/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear.decompose;

public class Householder {
    public static double decompose(double[][] A, double[] d, double[] t) {
        int r = A.length;
        int c = A[0].length;
        if (t == null) {
            t = new double[c];
        }
        double det = 1.0;
        int k = 0;
        while (k < c && k < r) {
            double sgn = A[k][k];
            double s = sgn * sgn;
            double akk = Math.sqrt(s);
            sgn = akk != 0.0 ? (sgn /= akk) : 1.0;
            int i = k + 1;
            while (i < r) {
                double s_ = A[i][k];
                s += s_ * s_;
                ++i;
            }
            s = Math.sqrt(s);
            double b = Math.sqrt(1.0 / (2.0 * s * (s + akk)));
            double a = sgn * s;
            d[k] = -a;
            det *= a;
            double[] dArray = A[k];
            int n = k;
            dArray[n] = dArray[n] + a;
            int i2 = k;
            while (i2 < r) {
                double[] dArray2 = A[i2];
                int n2 = k;
                dArray2[n2] = dArray2[n2] * b;
                ++i2;
            }
            int j = k + 1;
            while (j < c) {
                double s_ = 0.0;
                int i3 = k;
                while (i3 < r) {
                    s_ += A[i3][k] * A[i3][j];
                    ++i3;
                }
                t[j] = 2.0 * s_;
                ++j;
            }
            j = k + 1;
            while (j < c) {
                int i4 = k;
                while (i4 < r) {
                    double[] dArray3 = A[i4];
                    int n3 = j;
                    dArray3[n3] = dArray3[n3] - A[i4][k] * t[j];
                    ++i4;
                }
                ++j;
            }
            ++k;
        }
        return det;
    }

    public static double decompose(double[][] A, double[][] Q, double[] t0, double[] t1) {
        int r = A.length;
        int c = A[0].length;
        int n = Q[0].length;
        double det = Householder.decompose(A, t0, t1);
        int j = 0;
        while (j < n) {
            Q[0][j] = 0.0;
            ++j;
        }
        int i = 1;
        while (i < r) {
            System.arraycopy(Q[0], 0, Q[i], 0, n);
            ++i;
        }
        i = 0;
        while (i < n) {
            Q[i][i] = 1.0;
            ++i;
        }
        Householder.qTimes(A, Q, false, t1);
        j = 0;
        while (j < c) {
            A[c - 1][j] = 0.0;
            ++j;
        }
        i = 1;
        while (i < c - 1) {
            System.arraycopy(A[c - 1], 0, A[i], 0, i);
            ++i;
        }
        i = c;
        while (i < r) {
            System.arraycopy(A[c - 1], 0, A[i], 0, c);
            ++i;
        }
        i = 0;
        while (i < c) {
            A[i][i] = t0[i];
            ++i;
        }
        return det;
    }

    public static double decompose(double[][] A, double[][] Q, double[][] R) {
        int r = A.length;
        int c = A[0].length;
        int i = 0;
        while (i < r) {
            System.arraycopy(A[i], 0, R[i], 0, c);
            ++i;
        }
        double[] t0 = new double[c];
        double[] t1 = new double[r];
        double det = Householder.decompose(R, Q, t0, t1);
        return det;
    }

    public static double[] decompose(double[][] A_re, double[][] A_im, double[] d_re, double[] d_im, double[] t0, double[] t1) {
        int r = A_re.length;
        int c = A_re[0].length;
        if (t0 == null) {
            t0 = new double[c];
        }
        if (t1 == null) {
            t1 = new double[c];
        }
        double[] det = new double[]{1.0, 0.0};
        int k = 0;
        while (k < c && k < r) {
            double sgn_re = A_re[k][k];
            double sgn_im = A_im[k][k];
            double s = sgn_re * sgn_re + sgn_im * sgn_im;
            double a = Math.sqrt(s);
            if (a != 0.0) {
                sgn_re /= a;
                sgn_im /= a;
            } else {
                sgn_re = 1.0;
                sgn_im = 0.0;
            }
            int i = k + 1;
            while (i < r) {
                double s_re = A_re[i][k];
                double s_im = A_im[i][k];
                s += s_re * s_re + s_im * s_im;
                ++i;
            }
            s = Math.sqrt(s);
            double b = Math.sqrt(1.0 / (2.0 * s * (s + a)));
            double akk_re = sgn_re * s;
            double akk_im = sgn_im * s;
            d_re[k] = -akk_re;
            d_im[k] = -akk_im;
            a = det[0] * akk_re - det[1] * akk_im;
            det[1] = det[0] * akk_im + det[1] * akk_re;
            det[0] = a;
            double[] dArray = A_re[k];
            int n = k;
            dArray[n] = dArray[n] + akk_re;
            double[] dArray2 = A_im[k];
            int n2 = k;
            dArray2[n2] = dArray2[n2] + akk_im;
            int i2 = k;
            while (i2 < r) {
                double[] dArray3 = A_re[i2];
                int n3 = k;
                dArray3[n3] = dArray3[n3] * b;
                double[] dArray4 = A_im[i2];
                int n4 = k;
                dArray4[n4] = dArray4[n4] * b;
                ++i2;
            }
            int j = k + 1;
            while (j < c) {
                double s_re = 0.0;
                double s_im = 0.0;
                int i3 = k;
                while (i3 < r) {
                    double a_re = A_re[i3][k];
                    double a_im = -A_im[i3][k];
                    double b_re = A_re[i3][j];
                    double b_im = A_im[i3][j];
                    s_re += a_re * b_re - a_im * b_im;
                    s_im += a_im * b_re + a_re * b_im;
                    ++i3;
                }
                t0[j] = 2.0 * s_re;
                t1[j] = 2.0 * s_im;
                ++j;
            }
            j = k + 1;
            while (j < c) {
                int i4 = k;
                while (i4 < r) {
                    double a_re = A_re[i4][k];
                    double a_im = A_im[i4][k];
                    double b_re = t0[j];
                    double b_im = t1[j];
                    double[] dArray5 = A_re[i4];
                    int n5 = j;
                    dArray5[n5] = dArray5[n5] - (a_re * b_re - a_im * b_im);
                    double[] dArray6 = A_im[i4];
                    int n6 = j;
                    dArray6[n6] = dArray6[n6] - (a_im * b_re + a_re * b_im);
                    ++i4;
                }
                ++j;
            }
            ++k;
        }
        return det;
    }

    public static double[] decompose(double[][] A_re, double[][] A_im, double[][] Q_re, double[][] Q_im, double[] t0, double[] t1, double[] t2, double[] t3) {
        int r = A_re.length;
        int c = A_re[0].length;
        int n = Q_re[0].length;
        double[] det = Householder.decompose(A_re, A_im, t0, t1, t2, t3);
        int j = 0;
        while (j < n) {
            Q_re[0][j] = 0.0;
            ++j;
        }
        System.arraycopy(Q_re[0], 0, Q_im[0], 0, n);
        int i = 1;
        while (i < r) {
            System.arraycopy(Q_re[0], 0, Q_re[i], 0, n);
            System.arraycopy(Q_im[0], 0, Q_im[i], 0, n);
            ++i;
        }
        i = 0;
        while (i < n) {
            Q_re[i][i] = 1.0;
            ++i;
        }
        Householder.qTimes(A_re, A_im, Q_re, Q_im, false, t2, t3);
        j = 0;
        while (j < c) {
            A_re[c - 1][j] = 0.0;
            ++j;
        }
        System.arraycopy(A_re[c - 1], 0, A_im[c - 1], 0, c);
        i = 1;
        while (i < c - 1) {
            System.arraycopy(A_re[c - 1], 0, A_re[i], 0, i);
            System.arraycopy(A_im[c - 1], 0, A_im[i], 0, i);
            ++i;
        }
        i = c;
        while (i < r) {
            System.arraycopy(A_re[c - 1], 0, A_re[i], 0, c);
            System.arraycopy(A_im[c - 1], 0, A_im[i], 0, c);
            ++i;
        }
        i = 0;
        while (i < c) {
            A_re[i][i] = t0[i];
            A_im[i][i] = t1[i];
            ++i;
        }
        return det;
    }

    public static double[] decompose(double[][] A_re, double[][] A_im, double[][] Q_re, double[][] Q_im, double[][] R_re, double[][] R_im) {
        int r = A_re.length;
        int c = A_re[0].length;
        int i = 0;
        while (i < r) {
            System.arraycopy(A_re[i], 0, R_re[i], 0, c);
            System.arraycopy(A_im[i], 0, R_im[i], 0, c);
            ++i;
        }
        double[] t0_re = new double[c];
        double[] t0_im = new double[c];
        double[] t1_re = new double[r];
        double[] t1_im = new double[r];
        double[] det = Householder.decompose(R_re, R_im, Q_re, Q_im, t0_re, t0_im, t1_re, t1_im);
        return det;
    }

    public static void qTimes(double[][] Q, double[] a, boolean conj) {
        int r = Q.length;
        int c = Q[0].length;
        int l = 0;
        while (l < c) {
            int k = conj ? l : c - 1 - l;
            double t = 0.0;
            int i = k;
            while (i < r) {
                t += Q[i][k] * a[i];
                ++i;
            }
            t *= 2.0;
            i = k;
            while (i < r) {
                int n = i;
                a[n] = a[n] - Q[i][k] * t;
                ++i;
            }
            ++l;
        }
    }

    public static void qTimes(double[][] Q_re, double[][] Q_im, double[] a_re, double[] a_im, boolean conj) {
        int r = Q_re.length;
        int c = Q_re[0].length;
        int l = 0;
        while (l < c) {
            double a__im;
            double a__re;
            int k = conj ? l : c - 1 - l;
            double t_re = 0.0;
            double t_im = 0.0;
            int i = k;
            while (i < r) {
                a__re = Q_re[i][k];
                a__im = -Q_im[i][k];
                double b_re = a_re[i];
                double b_im = a_im[i];
                t_re += a__re * b_re - a__im * b_im;
                t_im += a__im * b_re + a__re * b_im;
                ++i;
            }
            t_re *= 2.0;
            t_im *= 2.0;
            i = k;
            while (i < r) {
                a__re = Q_re[i][k];
                a__im = Q_im[i][k];
                int n = i;
                a_re[n] = a_re[n] - (a__re * t_re - a__im * t_im);
                int n2 = i++;
                a_im[n2] = a_im[n2] - (a__im * t_re + a__re * t_im);
            }
            ++l;
        }
    }

    public static void qTimes(double[][] Q, double[][] A, boolean conj, double[] t) {
        int r = Q.length;
        int c = Q[0].length;
        int n = A[0].length;
        if (t == null) {
            t = new double[n];
        }
        int l = 0;
        while (l < c) {
            int k = conj ? l : c - 1 - l;
            int j = 0;
            while (j < n) {
                double s = 0.0;
                int i = k;
                while (i < r) {
                    s += Q[i][k] * A[i][j];
                    ++i;
                }
                t[j] = 2.0 * s;
                ++j;
            }
            int i = k;
            while (i < r) {
                int j2 = 0;
                while (j2 < n) {
                    double[] dArray = A[i];
                    int n2 = j2;
                    dArray[n2] = dArray[n2] - Q[i][k] * t[j2];
                    ++j2;
                }
                ++i;
            }
            ++l;
        }
    }

    public static void qTimes(double[][] Q_re, double[][] Q_im, double[][] A_re, double[][] A_im, boolean conj, double[] t0, double[] t1) {
        int r = Q_re.length;
        int c = Q_re[0].length;
        int n = A_re[0].length;
        if (t0 == null) {
            t0 = new double[n];
        }
        if (t1 == null) {
            t1 = new double[n];
        }
        int l = 0;
        while (l < c) {
            int k = conj ? l : c - 1 - l;
            int j = 0;
            while (j < n) {
                double s_re = 0.0;
                double s_im = 0.0;
                int i = k;
                while (i < r) {
                    double a_re = Q_re[i][k];
                    double a_im = -Q_im[i][k];
                    double b_re = A_re[i][j];
                    double b_im = A_im[i][j];
                    s_re += a_re * b_re - a_im * b_im;
                    s_im += a_im * b_re + a_re * b_im;
                    ++i;
                }
                t0[j] = 2.0 * s_re;
                t1[j] = 2.0 * s_im;
                ++j;
            }
            int i = k;
            while (i < r) {
                int j2 = 0;
                while (j2 < n) {
                    double a_re = Q_re[i][k];
                    double a_im = Q_im[i][k];
                    double b_re = t0[j2];
                    double b_im = t1[j2];
                    double[] dArray = A_re[i];
                    int n2 = j2;
                    dArray[n2] = dArray[n2] - (a_re * b_re - a_im * b_im);
                    double[] dArray2 = A_im[i];
                    int n3 = j2++;
                    dArray2[n3] = dArray2[n3] - (a_im * b_re + a_re * b_im);
                }
                ++i;
            }
            ++l;
        }
    }
}

