/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear.solve;

import de.jtem.numericalMethods.algebra.linear.decompose.Householder;
import de.jtem.numericalMethods.algebra.linear.solve.RXB;

public class AXB {
    public static boolean solve(double[][] A, double[] b, double[] t0, double[] t1) {
        int c = A[0].length;
        if (t0 == null) {
            t0 = new double[c];
        }
        if (Householder.decompose(A, t0, t1) == 0.0) {
            return false;
        }
        Householder.qTimes(A, b, true);
        int i = 0;
        while (i < c) {
            A[i][i] = t0[i];
            ++i;
        }
        return RXB.solve(A, b);
    }

    public static boolean solve(double[][] A, double[] x, double[] b) {
        int r = A.length;
        int c = A[0].length;
        double[] t = new double[r];
        double[][] T = new double[r][c];
        System.arraycopy(b, 0, t, 0, r);
        int i = 0;
        while (i < r) {
            System.arraycopy(A[i], 0, T[i], 0, c);
            ++i;
        }
        if (!AXB.solve(T, t, new double[c], new double[c])) {
            return false;
        }
        System.arraycopy(t, 0, x, 0, c);
        return true;
    }

    public static boolean solve(double[][] A_re, double[][] A_im, double[] b_re, double[] b_im, double[] t0, double[] t1, double[] t2, double[] t3) {
        double[] t;
        int c = A_re[0].length;
        if (t0 == null) {
            t0 = new double[c];
        }
        if (t1 == null) {
            t1 = new double[c];
        }
        if ((t = Householder.decompose(A_re, A_im, t0, t1, t2, t3))[0] == 0.0 && t[1] == 0.0) {
            return false;
        }
        Householder.qTimes(A_re, A_im, b_re, b_im, true);
        int i = 0;
        while (i < c) {
            A_re[i][i] = t0[i];
            A_im[i][i] = t1[i];
            ++i;
        }
        return RXB.solve(A_re, A_im, b_re, b_im);
    }

    public static boolean solve(double[][] A_re, double[][] A_im, double[] x_re, double[] x_im, double[] b_re, double[] b_im) {
        int r = A_re.length;
        int c = A_re[0].length;
        double[] t_re = new double[r];
        double[] t_im = new double[r];
        double[][] T_re = new double[r][c];
        double[][] T_im = new double[r][c];
        System.arraycopy(b_re, 0, t_re, 0, r);
        System.arraycopy(b_im, 0, t_im, 0, r);
        int i = 0;
        while (i < r) {
            System.arraycopy(A_re[i], 0, T_re[i], 0, c);
            System.arraycopy(A_im[i], 0, T_im[i], 0, c);
            ++i;
        }
        if (!AXB.solve(T_re, T_im, t_re, t_im, new double[c], new double[c], new double[c], new double[c])) {
            return false;
        }
        System.arraycopy(t_re, 0, x_re, 0, c);
        System.arraycopy(t_im, 0, x_im, 0, c);
        return true;
    }

    public static boolean solve(double[][] A, double[][] B, double[] t0, double[] t1) {
        int c = A[0].length;
        if (t0 == null) {
            t0 = new double[c];
        }
        if (Householder.decompose(A, t0, t1) == 0.0) {
            return false;
        }
        Householder.qTimes(A, B, true, t1);
        int i = 0;
        while (i < A[0].length) {
            A[i][i] = t0[i];
            ++i;
        }
        return RXB.solve(A, B);
    }

    public static boolean solve(double[][] A, double[][] X, double[][] B) {
        int r = A.length;
        int c = A[0].length;
        int n = B[0].length;
        double[][] T0 = new double[r][c];
        double[][] T1 = new double[r][n];
        int i = 0;
        while (i < r) {
            System.arraycopy(A[i], 0, T0[i], 0, c);
            System.arraycopy(B[i], 0, T1[i], 0, n);
            ++i;
        }
        if (!AXB.solve(T0, T1, new double[c], new double[c])) {
            return false;
        }
        i = 0;
        while (i < c) {
            System.arraycopy(T1[i], 0, X[i], 0, n);
            ++i;
        }
        return true;
    }

    public static boolean solve(double[][] A_re, double[][] A_im, double[][] B_re, double[][] B_im, double[] t0, double[] t1, double[] t2, double[] t3) {
        double[] t;
        int c = A_re[0].length;
        if (t0 == null) {
            t0 = new double[c];
        }
        if (t1 == null) {
            t1 = new double[c];
        }
        if ((t = Householder.decompose(A_re, A_im, t0, t1, t2, t3))[0] == 0.0 && t[1] == 0.0) {
            return false;
        }
        Householder.qTimes(A_re, A_im, B_re, B_im, true, t2, t3);
        int i = 0;
        while (i < A_re[0].length) {
            A_re[i][i] = t0[i];
            A_im[i][i] = t1[i];
            ++i;
        }
        return RXB.solve(A_re, A_im, B_re, B_im);
    }

    public static boolean solve(double[][] A_re, double[][] A_im, double[][] X_re, double[][] X_im, double[][] B_re, double[][] B_im) {
        int r = A_re.length;
        int c = A_re[0].length;
        int n = B_re[0].length;
        double[][] A0_re = new double[r][c];
        double[][] A0_im = new double[r][c];
        double[][] B0_re = new double[r][n];
        double[][] B0_im = new double[r][n];
        int i = 0;
        while (i < r) {
            System.arraycopy(A_re[i], 0, A0_re[i], 0, c);
            System.arraycopy(A_im[i], 0, A0_im[i], 0, c);
            System.arraycopy(B_re[i], 0, B0_re[i], 0, n);
            System.arraycopy(B_im[i], 0, B0_im[i], 0, n);
            ++i;
        }
        if (!AXB.solve(A0_re, A0_im, B0_re, B0_im, new double[c], new double[c], new double[c], new double[c])) {
            return false;
        }
        i = 0;
        while (i < c) {
            System.arraycopy(B0_re[i], 0, X_re[i], 0, n);
            System.arraycopy(B0_im[i], 0, X_im[i], 0, n);
            ++i;
        }
        return true;
    }
}

