/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.functionApproximation.bestFitting;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariablesWithGradient;
import de.jtem.numericalMethods.calculus.functionApproximation.bestFitting.BasisFunction;
import de.jtem.numericalMethods.calculus.functionApproximation.bestFitting.LinearFunctionSpaceElement;
import de.jtem.numericalMethods.calculus.functionApproximation.bestFitting.Sample;
import de.jtem.numericalMethods.calculus.minimizing.ConjugateGradient;

public class LinearFunctionSpace {
    BasisFunction[][] f;
    public final int n;
    public final int m;
    public final int dim;
    double[][] c;

    LinearFunctionSpace(BasisFunction[][] f) {
        this.f = f;
        this.n = f[0][0].getNumberOfVariables();
        this.m = f[0].length;
        this.dim = f.length;
        this.c = new double[this.dim][this.m];
    }

    public int getDimension() {
        return this.m * this.dim;
    }

    void eval(double[] x, double[] parameter, double[] u) {
        this.eval(x, parameter, u, this.c);
    }

    void eval(double[] x, double[] parameter, double[] u, double[][] c) {
        int j = 0;
        while (j < this.m) {
            u[j] = 0.0;
            ++j;
        }
        int i = 0;
        int k = 0;
        while (i < this.dim) {
            int j2 = 0;
            while (j2 < this.m) {
                double f_ij;
                c[i][j2] = f_ij = this.f[i][j2].eval(x);
                int n = j2++;
                u[n] = u[n] + parameter[k] * f_ij;
                ++k;
            }
            ++i;
        }
    }

    public LinearFunctionSpaceElement searchForBestFit(double[] startParameter, Sample[] samples, double tol, int maxNumberOfSteps) {
        LinearFunctionSpaceElement best = new LinearFunctionSpaceElement(this);
        Energy energy = new Energy(samples);
        ConjugateGradient.search(best.coefficient, tol, energy, maxNumberOfSteps, false, null);
        return best;
    }

    public LinearFunctionSpaceElement searchForBestFit(LinearFunctionSpaceElement start, Sample[] samples, double tol, int maxNumberOfSteps) {
        return this.searchForBestFit(start, samples, tol, maxNumberOfSteps, 0);
    }

    public LinearFunctionSpaceElement searchForBestFit(LinearFunctionSpaceElement start, Sample[] samples, double tol, int maxNumberOfSteps, int numberOfDimensionsBeingFixed) {
        LinearFunctionSpaceElement best = new LinearFunctionSpaceElement(this, start.getCoefficients());
        Energy energy = new Energy(samples, numberOfDimensionsBeingFixed);
        ConjugateGradient.search(best.coefficient, tol, energy, maxNumberOfSteps, false, null);
        return best;
    }

    public LinearFunctionSpaceElement searchForBestFit(Sample[] samples, double tol, int maxNumberOfSteps) {
        return this.searchForBestFit(new LinearFunctionSpaceElement(this), samples, tol, maxNumberOfSteps);
    }

    class Energy
    implements RealFunctionOfSeveralVariablesWithGradient {
        final Sample[] samples;
        final double[] y;
        final int numberOfDimensionBeingFixed;

        Energy(Sample[] samples, int numberOfDimensionBeingFixed) {
            this.samples = samples;
            this.numberOfDimensionBeingFixed = numberOfDimensionBeingFixed;
            this.y = new double[LinearFunctionSpace.this.m];
        }

        Energy(Sample[] samples) {
            this(samples, 0);
        }

        final double absSqr(double[] u) {
            double uu = 0.0;
            int i = 0;
            while (i < LinearFunctionSpace.this.m) {
                uu += u[i] * u[i];
                ++i;
            }
            return uu;
        }

        @Override
        public double eval(double[] parameter, double[] gradient) {
            double energy = 0.0;
            if (gradient != null) {
                int j = 0;
                while (j < LinearFunctionSpace.this.m * LinearFunctionSpace.this.dim) {
                    gradient[j] = 0.0;
                    ++j;
                }
            }
            int i = 0;
            while (i < this.samples.length) {
                Sample sample = this.samples[i];
                LinearFunctionSpace.this.eval(sample.x, parameter, this.y, LinearFunctionSpace.this.c);
                int j = 0;
                while (j < LinearFunctionSpace.this.m) {
                    int n = j;
                    this.y[n] = this.y[n] - sample.y[j];
                    ++j;
                }
                if (gradient != null) {
                    j = this.numberOfDimensionBeingFixed;
                    int l = LinearFunctionSpace.this.m * this.numberOfDimensionBeingFixed;
                    while (j < LinearFunctionSpace.this.dim) {
                        int k = 0;
                        while (k < LinearFunctionSpace.this.m) {
                            int n = l++;
                            gradient[n] = gradient[n] + LinearFunctionSpace.this.c[j][k] * this.y[k] * sample.weight;
                            ++k;
                        }
                        ++j;
                    }
                }
                energy += this.absSqr(this.y) * sample.weight;
                ++i;
            }
            return energy / 2.0;
        }

        @Override
        public double eval(double[] parameter) {
            return this.eval(parameter, null);
        }

        @Override
        public int getNumberOfVariables() {
            return LinearFunctionSpace.this.getDimension();
        }
    }
}

