/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.latticeReduction;

public final class ExactLLL {
    private static int[] P = new int[10];
    private static long[] D = new long[11];
    private static long[][] lam = new long[10][10];
    static long[] det = new long[1];

    private static long exactDiv(long a, long b) {
        if (a % b != 0L) {
            throw new RuntimeException("nonbzero remainder");
        }
        return a / b;
    }

    private static long balDiv(long a, long b) {
        long r = a % b;
        long q = a / b;
        if (r + r > b || r + r == b && q < 0L) {
            return q + 1L;
        }
        return q;
    }

    private static long mulAddDiv(long c1, long c2, long x, long y, long z) {
        return (x * c1 + y * c2) / z;
    }

    private static long mulSubDiv(long c1, long c2, long x, long y, long z) {
        return (x * c1 - y * c2) / z;
    }

    private static void mulSubDiv(long[] c, long[] c1, long[] c2, long x, long y, long z) {
        int n = c.length;
        if (c1.length != n || c2.length != n) {
            throw new IllegalArgumentException("length mismatch");
        }
        int i = 0;
        while (i < n) {
            c[i] = (x * c1[i] - y * c2[i]) / z;
            ++i;
        }
    }

    private static void rowTransform(long[] c1, long[] c2, long x, long y, long u, long v) {
        int n = c1.length;
        if (c2.length != n) {
            throw new IllegalArgumentException("length mismatch");
        }
        int i = 0;
        while (i < n) {
            long t1 = x * c1[i] + y * c2[i];
            long t2 = u * c1[i] + v * c2[i];
            c1[i] = t1;
            c2[i] = t2;
            ++i;
        }
    }

    private static void rowTransform(long[][] M, int i, int j, int k, long x, long y, long u, long v) {
        long t1 = x * M[i][k] + y * M[j][k];
        long t2 = u * M[i][k] + v * M[j][k];
        M[i][k] = t1;
        M[j][k] = t2;
    }

    private static long mulAdd(long c1, long c2, long y) {
        return c1 + y * c2;
    }

    private static long mulSub(long c1, long c2, long y) {
        return c1 - y * c2;
    }

    private static void mulSub(long[] c, long[] c1, long[] c2, long x) {
        int n = c.length;
        if (c1.length != n || c2.length != n) {
            throw new IllegalArgumentException("length mismatch");
        }
        int i = 0;
        while (i < n) {
            c[i] = c1[i] - x * c2[i];
            ++i;
        }
    }

    private static boolean swapTest(long d0, long d1, long d2, long lam, long a, long b) {
        return a * d1 * d1 > b * (d0 * d2 + lam * lam);
    }

    private static void reduce(int k, int l, long[][] B, int[] P, long[] D, long[][] lam, long[][] U) {
        if (P[l] == -1) {
            return;
        }
        if (2L * Math.abs(lam[k][P[l]]) < D[1 + P[l]]) {
            return;
        }
        long r = ExactLLL.balDiv(lam[k][P[l]], D[1 + P[l]]);
        ExactLLL.mulSub(B[k], B[k], B[l], r);
        if (U != null) {
            ExactLLL.mulSub(U[k], U[k], U[l], r);
        }
        int j = 0;
        while (j <= l - 1) {
            if (P[j] != -1) {
                lam[k][P[j]] = ExactLLL.mulSub(lam[k][P[j]], lam[l][P[j]], r);
            }
            ++j;
        }
        lam[k][P[l]] = ExactLLL.mulSub(lam[k][P[l]], D[1 + P[l]], r);
    }

    private static void swap(long[] a, long[] b) {
        long[] tmp = a;
        b = a;
        b = tmp;
    }

    private static final long gcd(long dvr, long dvd) {
        while (dvr != 0L) {
            long rem = dvd % dvr;
            dvd = dvr;
            dvr = rem;
        }
        return dvd;
    }

    private static final long xgcd(long a, long b, long[] s) {
        long r1 = a;
        long r2 = b % a;
        long x1 = 1L;
        long x2 = -b / a;
        long y1 = 0L;
        long y2 = 1L;
        do {
            long r0 = r1;
            r1 = r2;
            long x0 = x1;
            x1 = x2;
            long y0 = y1;
            y1 = y2;
            long q = r0 / r1;
            r2 = r0 % r1;
            x2 = x0 - q * x1;
            y2 = y0 - q * y1;
        } while (r2 != 0L);
        s[0] = x1;
        s[1] = y1;
        return r1;
    }

    private static boolean swap(int k, long[][] B, int[] P, long[] D, long[][] lam, long[][] U, int m, boolean verbose) {
        if (P[k] != -1) {
            if (verbose) {
                System.out.println("swap case 1: " + k);
            }
            ExactLLL.swap(B[k - 1], B[k]);
            if (U != null) {
                ExactLLL.swap(U[k - 1], U[k]);
            }
            int j = 0;
            while (j <= k - 2) {
                if (P[j] != -1) {
                    long tmp = lam[k - 1][P[j]];
                    lam[k - 1][P[j]] = lam[k][P[j]];
                    lam[k][P[j]] = tmp;
                }
                ++j;
            }
            int i = k + 1;
            while (i < m) {
                long t1 = ExactLLL.mulAddDiv(lam[i][P[k] - 1], lam[i][P[k]], lam[k][P[k] - 1], D[1 + P[k] - 2], D[1 + P[k] - 1]);
                long t2 = ExactLLL.mulSubDiv(lam[i][P[k] - 1], lam[i][P[k]], D[1 + P[k]], lam[k][P[k] - 1], D[1 + P[k] - 1]);
                lam[i][P[k] - 1] = t1;
                lam[i][P[k]] = t2;
                ++i;
            }
            D[1 + P[k] - 1] = ExactLLL.mulAddDiv(D[1 + P[k]], lam[k][P[k] - 1], D[1 + P[k] - 2], lam[k][P[k] - 1], D[1 + P[k] - 1]);
            return false;
        }
        if (lam[k][P[k - 1]] != 0L) {
            if (verbose) {
                System.out.println("swap case 2: " + k);
            }
            long[] xy = new long[2];
            long e = ExactLLL.xgcd(lam[k][P[k - 1]], D[1 + P[k - 1]], xy);
            long x = xy[0];
            long y = xy[1];
            long t1 = ExactLLL.exactDiv(lam[k][P[k - 1]], e);
            long t3 = ExactLLL.exactDiv(D[1 + P[k - 1]], e);
            long t2 = -t3;
            ExactLLL.rowTransform(B[k - 1], B[k], t1, t2, y, x);
            if (U != null) {
                ExactLLL.rowTransform(U[k - 1], U[k], t1, t2, y, x);
            }
            int j = 0;
            while (j <= k - 2) {
                if (P[j] != -1) {
                    ExactLLL.rowTransform(lam, k - 1, k, P[j], t1, t2, y, x);
                }
                ++j;
            }
            t2 *= t2;
            D[1 + P[k - 1]] = ExactLLL.exactDiv(D[1 + P[k - 1]], t2);
            int i = k + 1;
            while (i < m) {
                if (P[i] != -1) {
                    D[1 + P[i]] = ExactLLL.exactDiv(D[1 + P[i]], t2);
                    int j2 = i + 1;
                    while (j2 < m) {
                        lam[j2][P[i]] = ExactLLL.exactDiv(lam[j2][P[i]], t2);
                        ++j2;
                    }
                }
                ++i;
            }
            i = k + 1;
            while (i < m) {
                lam[i][P[k - 1]] = ExactLLL.exactDiv(lam[i][P[k - 1]], t3);
                ++i;
            }
            int tmp = P[k - 1];
            P[k - 1] = P[k];
            P[k] = tmp;
            return true;
        }
        if (verbose) {
            System.out.println("swap case 3: " + k);
        }
        ExactLLL.swap(B[k - 1], B[k]);
        if (U != null) {
            ExactLLL.swap(U[k - 1], U[k]);
        }
        int j = 0;
        while (j <= k - 2) {
            if (P[j] != -1) {
                long tmp = lam[k - 1][P[j]];
                lam[k - 1][P[j]] = lam[k][P[j]];
                lam[k][P[j]] = tmp;
            }
            ++j;
        }
        int tmp = P[k - 1];
        P[k - 1] = P[k];
        P[k] = tmp;
        return false;
    }

    private static long innerProduct(long[] v, long[] w) {
        long p = 0L;
        if (v.length != w.length) {
            throw new IllegalArgumentException("length mismatch");
        }
        int i = 0;
        while (i < v.length) {
            p += v[i] * w[i];
            ++i;
        }
        return p;
    }

    private static int incrementalGS(long[][] B, int[] P, long[] D, long[][] lam, int s, int k) {
        long n = B[0].length;
        long m = B.length;
        int j = 0;
        while (j <= k - 1) {
            int posj = P[j];
            if (posj != -1) {
                long u = ExactLLL.innerProduct(B[k], B[j]);
                int i = 0;
                while (i <= posj - 1) {
                    long t1 = D[1 + i] * u;
                    long t2 = lam[k][i] * lam[j][i];
                    u = (t1 - t2) / D[1 + i - 1];
                    ++i;
                }
                lam[k][posj] = u;
            }
            ++j;
        }
        long u = ExactLLL.innerProduct(B[k], B[k]);
        int i = 0;
        while (i < s) {
            long t1 = D[1 + i] * u;
            long t2 = lam[k][i] * lam[k][i];
            u = (t1 - t2) / D[1 + i - 1];
            ++i;
        }
        if (u == 0L) {
            P[k] = -1;
        } else {
            P[k] = s;
            D[1 + s] = u;
            ++s;
        }
        return s;
    }

    private static long[] reduce(long[][] B, long[][] U, long a, long b, boolean verbose) {
        int j;
        int i;
        int n = B[0].length;
        int m = B.length;
        boolean force_reduce = true;
        if (P.length < m) {
            P = new int[m];
            D = new long[m + 1];
        } else {
            i = 0;
            while (i < m) {
                ExactLLL.P[i] = 0;
                ExactLLL.D[i] = 0L;
                j = 0;
                while (j < m) {
                    ExactLLL.lam[i][j] = 0L;
                    ++j;
                }
                ++i;
            }
        }
        ExactLLL.D[m] = 0L;
        ExactLLL.D[0] = 1L;
        if (U.length != m || U[0].length != m) {
            throw new IllegalArgumentException("U has wrong length");
        }
        if (U != null) {
            i = 0;
            while (i < m) {
                j = 0;
                while (j < m) {
                    U[i][j] = i == j ? 1 : 0;
                    ++j;
                }
                ++i;
            }
        }
        int s = 0;
        int k = 0;
        int max_k = -1;
        while (k < m) {
            if (k > max_k) {
                s = ExactLLL.incrementalGS(B, P, D, lam, s, k);
                max_k = k;
            }
            if (k == 0) {
                force_reduce = true;
                ++k;
                continue;
            }
            if (force_reduce) {
                int j2 = k - 1;
                while (j2 >= 0) {
                    ExactLLL.reduce(k, j2, B, P, D, lam, U);
                    --j2;
                }
            }
            if (P[k - 1] != -1 && (P[k] == -1 || ExactLLL.swapTest(D[1 + P[k]], D[1 + P[k] - 1], D[1 + P[k] - 2], lam[k][P[k] - 1], a, b))) {
                force_reduce = ExactLLL.swap(k, B, P, D, lam, U, max_k, verbose);
                --k;
                continue;
            }
            force_reduce = true;
            ++k;
        }
        long[] finalD = new long[s + 1];
        System.arraycopy(D, 0, finalD, 0, s + 1);
        return finalD;
    }

    public static int reduce(long[][] B, long[][] U) {
        return ExactLLL.reduce(B, U, 3L, 4L, false).length - 1;
    }

    public static int reduce(long[][] B, long[][] U, long[] det) {
        long[] D = ExactLLL.reduce(B, U, 3L, 4L, false);
        int s = D.length - 1;
        det[0] = D[s];
        return s;
    }

    public static int reduce(long[][] B, long[][] U, long a, long b, long[] det) {
        if (a <= 0L || b <= 0L || a > b || b / 4L >= a) {
            throw new IllegalArgumentException("wrong constants");
        }
        long[] D = ExactLLL.reduce(B, U, a, b, false);
        int s = D.length - 1;
        det[0] = D[s];
        return s;
    }

    public static int reduce(long[][] B, long a, long b, long[] det) {
        return ExactLLL.reduce(B, null, a, b, det);
    }

    private static long image(long[][] B, long[][] U, long[] det, boolean verbose) {
        int j;
        int i;
        int n = B[0].length;
        int m = B.length;
        boolean force_reduce = true;
        if (P.length < m) {
            P = new int[m];
            D = new long[m + 1];
        } else {
            i = 0;
            while (i < m) {
                ExactLLL.P[i] = 0;
                ExactLLL.D[i] = 0L;
                j = 0;
                while (j < m) {
                    ExactLLL.lam[i][j] = 0L;
                    ++j;
                }
                ++i;
            }
        }
        ExactLLL.D[m] = 0L;
        ExactLLL.D[0] = 1L;
        if (U.length != m || U[0].length != m) {
            throw new IllegalArgumentException("U has wrong length");
        }
        if (U != null) {
            i = 0;
            while (i < m) {
                j = 0;
                while (j < m) {
                    U[i][j] = i == j ? 1 : 0;
                    ++j;
                }
                ++i;
            }
        }
        int s = 0;
        int k = 0;
        int max_k = -1;
        while (k < m) {
            if (k > max_k) {
                ExactLLL.incrementalGS(B, P, D, lam, s, k);
                max_k = k;
            }
            if (k == 0) {
                force_reduce = true;
                ++k;
                continue;
            }
            if (force_reduce) {
                int j2 = k - 1;
                while (j2 >= 0) {
                    ExactLLL.reduce(k, j2, B, P, D, lam, U);
                    --j2;
                }
            }
            if (P[k - 1] != -1 && P[k] == -1) {
                force_reduce = ExactLLL.swap(k, B, P, D, lam, U, max_k, verbose);
                --k;
                continue;
            }
            force_reduce = true;
            ++k;
        }
        det[0] = D[s];
        return s;
    }

    public static long image(long[][] B, long[][] U, long[] det) {
        return ExactLLL.image(B, U, det, false);
    }

    public static long image(long[][] B, long[][] U) {
        return ExactLLL.image(B, U, det, false);
    }

    public static long image(long[][] B) {
        return ExactLLL.image(B, null, det, false);
    }
}

