/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.plugin.jrdesktop;

import de.jtem.jrworkspace.plugin.Controller;
import de.jtem.jrworkspace.plugin.Plugin;
import de.jtem.jrworkspace.plugin.PluginInfo;
import de.jtem.jrworkspace.plugin.flavor.PerspectiveFlavor;
import de.jtem.jrworkspace.plugin.jrdesktop.JRDesktopFrame;
import de.jtem.jrworkspace.plugin.jrdesktop.image.ImageHook;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.beans.PropertyVetoException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class JRDesktopPlugin
extends Plugin
implements PerspectiveFlavor {
    private JDesktopPane desktop = new JDesktopPane();

    public JRDesktopPlugin() {
        this.desktop.setPreferredSize(new Dimension(500, 400));
    }

    @Override
    public PluginInfo getPluginInfo() {
        PluginInfo info = new PluginInfo();
        info.name = "jRDesktop";
        info.vendorName = "Stefan Sechelmann";
        info.icon = ImageHook.getIcon("arrow_right_blue_round.png");
        return info;
    }

    @Override
    public Component getCenterComponent() {
        return this.desktop;
    }

    public void addDesktopPlugin(JRDesktopFrame p) {
        JInternalFrame frame = p.getInternalFrame();
        frame.setVisible(true);
        this.desktop.add(frame);
        try {
            frame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void removeDesktopPlugin(JRDesktopFrame p) {
        JInternalFrame frame = p.getInternalFrame();
        frame.setVisible(false);
        this.desktop.remove(frame);
    }

    @Override
    public void setVisible(boolean visible) {
    }

    @Override
    public void install(Controller c) throws Exception {
    }

    @Override
    public void uninstall(Controller c) throws Exception {
    }

    @Override
    public Icon getIcon() {
        return this.getPluginInfo().icon;
    }

    @Override
    public List<Image> getIconList() {
        return null;
    }

    @Override
    public String getTitle() {
        return this.getPluginInfo().name;
    }
}

