/*
 * Decompiled with CFR 0.152.
 */
package de.smrj.tcp.management;

import de.smrj.tcp.management.ClientEnvironment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClientService {
    private boolean running = true;
    ClientEnvironment currentEnvironment;

    public ClientService(String inetName, int port) throws IOException {
        try {
            MulticastReceiver receiver = new MulticastReceiver(inetName, port);
            new Thread(receiver).start();
        }
        catch (IOException ioe) {
            Logger.getLogger("SMRJ").log(Level.WARNING, "Failed to listen for multicast packages at " + inetName + ":" + port);
            throw ioe;
        }
        Logger.getLogger("SMRJ").log(Level.CONFIG, "Listenting for multicast packages at " + inetName + ":" + port);
    }

    public ClientService(int port) throws IOException {
        try {
            SinglecastReceiver receiver = new SinglecastReceiver(port);
            new Thread(receiver).start();
        }
        catch (IOException ioe) {
            Logger.getLogger("SMRJ").log(Level.WARNING, "Failed to listen for TCP connections at port " + port);
            throw ioe;
        }
        Logger.getLogger("SMRJ").log(Level.CONFIG, "Listening for TCP connections at port " + port);
    }

    private void processCommand(String received) {
        boolean correctHost = true;
        if (received.startsWith("shutdown")) {
            this.shutdown();
        } else if (received.startsWith("new-connection:")) {
            String[] args = received.split(" ");
            if (args.length == 4) {
                try {
                    correctHost = InetAddress.getByName(args[3]).equals(InetAddress.getLocalHost());
                    Logger.getLogger("SMRJ").log(Level.FINE, "restricted connection for " + args[3] + " siMe: " + correctHost);
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
            }
            if (correctHost) {
                this.newConnection(args[1], Integer.parseInt(args[2]));
            }
        } else if (received.startsWith("cp-server:")) {
            String[] args = received.split(" ");
            if (correctHost) {
                this.cpConnection(args[1], Integer.parseInt(args[2]));
            }
        } else if (received.startsWith("response-type:")) {
            String[] args = received.split(" ");
            if (correctHost) {
                this.responseType(Integer.parseInt(args[1]));
            }
        } else if (received.startsWith("cp-element:")) {
            String[] args = received.split(" ");
            if (correctHost) {
                this.newCpEntry(args[1]);
            }
        } else if (received.startsWith("do-connect")) {
            String[] args = received.split(" ");
            if (correctHost) {
                this.doConnect(args[1]);
            }
        } else {
            Logger.getLogger("SMRJ").log(Level.WARNING, "Unknown command: " + received);
        }
    }

    private void doConnect(String clientFactoryClass) {
        try {
            this.currentEnvironment.doConnect(clientFactoryClass);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void cpConnection(String host, int port) {
        this.currentEnvironment.setCpServer(host, port);
    }

    private void newCpEntry(String entryName) {
        this.currentEnvironment.newCpEntry(entryName);
    }

    private void responseType(int i) {
        this.currentEnvironment.setResponseType(i);
    }

    private void newConnection(String host, int port) {
        this.currentEnvironment = new ClientEnvironment();
        this.currentEnvironment.setServer(host, port);
    }

    private void shutdown() {
        if (this.currentEnvironment != null) {
            this.currentEnvironment.doShutdown();
        }
        this.currentEnvironment = null;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            new ClientService("230.0.0.1", 4446);
        } else if (args[0].equals("udp")) {
            if (args.length == 1) {
                new ClientService("230.0.0.1", 4446);
            }
            if (args.length == 2) {
                new ClientService(args[1], 4446);
            }
            if (args.length == 3) {
                new ClientService(args[1], Integer.parseInt(args[2]));
            }
        } else if (args[0].equals("tcp")) {
            if (args.length == 1) {
                new ClientService(4446);
            }
            if (args.length == 2) {
                new ClientService(Integer.parseInt(args[1]));
            }
        } else {
            System.out.println("USAGE: ClientService [tcp [<port>] | udp [<inetname> [<port>]]]");
        }
    }

    private class SinglecastReceiver
    implements Runnable {
        ServerSocket serverSocket;

        public SinglecastReceiver(int port) throws IOException {
            this.serverSocket = new ServerSocket(port);
        }

        public void run() {
            while (ClientService.this.running) {
                try {
                    Socket clientSocket = this.serverSocket.accept();
                    PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
                    BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                    out.println("Ready.");
                    String command = in.readLine();
                    ClientService.this.processCommand(command);
                    out.println("OK");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class MulticastReceiver
    implements Runnable {
        MulticastSocket socket;
        InetAddress group;

        MulticastReceiver(String inetAddressName, int port) throws IOException {
            this.socket = new MulticastSocket(port);
            this.group = InetAddress.getByName(inetAddressName);
            this.socket.joinGroup(this.group);
        }

        public void run() {
            while (ClientService.this.running) {
                for (int i = 0; i < 5; ++i) {
                    byte[] buf = new byte[256];
                    DatagramPacket packet = new DatagramPacket(buf, buf.length);
                    try {
                        this.socket.receive(packet);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    byte[] b = packet.getData();
                    int len = ByteBuffer.wrap(b).asIntBuffer().get();
                    String received = new String(b, 4, len);
                    ClientService.this.processCommand(received);
                }
            }
            try {
                this.socket.leaveGroup(this.group);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.socket.close();
        }
    }
}

