/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.loopGroup;

import de.jtem.numericalMethods.algebra.linear.MatrixOperations;
import de.jtem.numericalMethods.algebra.linear.VectorOperations;
import de.jtem.numericalMethods.algebra.linear.decompose.Householder;

public class IwasawaFactorization {
    public static void factor(double[][][] xRe, double[][][] xIm, double[][][] fRe, double[][][] fIm, int blockSize) {
        int n = xRe.length;
        int N = xRe[0][0].length / 2;
        int R = blockSize;
        int rows = 2 * N + 1 + R;
        int m = rows * n;
        int r = R * n;
        double[][] uRe = new double[m][r];
        double[][] uIm = new double[m][r];
        double[] dRe = new double[r];
        double[] dIm = new double[r];
        double[] pRe = new double[m];
        double[] pIm = new double[m];
        double[][] zRe = new double[n][m];
        double[][] zIm = new double[n][m];
        double[][] gRe = new double[m][n];
        double[][] gIm = new double[m][n];
        IwasawaFactorization.factor(xRe, xIm, fRe, fIm, uRe, uIm, dRe, dIm, pRe, pIm, zRe, zIm, gRe, gIm, blockSize);
    }

    public static void factor(double[][][] xRe, double[][][] xIm, double[][][] fRe, double[][][] fIm, double[][] uRe, double[][] uIm, double[] dRe, double[] dIm, double[] pRe, double[] pIm, double[][] zRe, double[][] zIm, double[][] gRe, double[][] gIm, int blockSize) {
        if (blockSize <= 0) {
            throw new IllegalArgumentException("blockSize must be positive");
        }
        int n = xRe.length;
        int N = (xRe[0][0].length - 1) / 2;
        int R = blockSize;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                IwasawaFactorization.setBlock(xRe[i][j], uRe, i, j, N, R);
                IwasawaFactorization.setBlock(xIm[i][j], uIm, i, j, N, R);
                ++j;
            }
            ++i;
        }
        double[] t = Householder.decompose(uRe, uIm, dRe, dIm, pRe, pIm);
        if (t[0] == 0.0 && t[1] == 0.0) {
            throw new RuntimeException("not solvable");
        }
        int i2 = 0;
        while (i2 < n) {
            int j = 0;
            while (j < n) {
                IwasawaFactorization.setBlock(xRe[j][i2], zRe[i2], j, N, R);
                IwasawaFactorization.setBlock(xIm[j][i2], zIm[i2], j, N, R);
                ++j;
            }
            VectorOperations.assign(zRe[i2], pRe);
            VectorOperations.assign(zIm[i2], pIm);
            Householder.qTimes(uRe, uIm, pRe, pIm, true);
            int k = R * n;
            while (k < pRe.length) {
                pIm[k] = 0.0;
                pRe[k] = 0.0;
                ++k;
            }
            Householder.qTimes(uRe, uIm, pRe, pIm, false);
            VectorOperations.minus(zRe[i2], pRe, zRe[i2]);
            VectorOperations.minus(zIm[i2], pIm, zIm[i2]);
            ++i2;
        }
        MatrixOperations.transpose(zRe, gRe);
        MatrixOperations.transpose(zIm, gIm);
        double[] T = Householder.decompose(gRe, gIm, dRe, dIm, pRe, pIm);
        if (T[0] == 0.0 && T[1] == 0.0) {
            throw new RuntimeException("not solvable");
        }
        int i3 = 0;
        while (i3 < n) {
            IwasawaFactorization.assignZero(zRe[i3]);
            IwasawaFactorization.assignZero(zIm[i3]);
            zRe[i3][i3] = 1.0;
            Householder.qTimes(gRe, gIm, zRe[i3], zIm[i3], false);
            ++i3;
        }
        i3 = 0;
        while (i3 < n) {
            double absOfD = Math.sqrt(dRe[i3] * dRe[i3] + dIm[i3] * dIm[i3]);
            double nRe = dRe[i3] / absOfD;
            double nIm = dIm[i3] / absOfD;
            VectorOperations.times(zRe[i3], zIm[i3], nRe, nIm, zRe[i3], zIm[i3]);
            ++i3;
        }
        i3 = 0;
        while (i3 < n) {
            int j = 0;
            while (j < n) {
                IwasawaFactorization.getBlock(fRe[j][i3], zRe[i3], j, N, R);
                IwasawaFactorization.getBlock(fIm[j][i3], zIm[i3], j, N, R);
                ++j;
            }
            ++i3;
        }
    }

    public static void positivePart(double[][][] xRe, double[][][] xIm, double[][][] fRe, double[][][] fIm, double[][][] bRe, double[][][] bIm) {
        int N = xRe[0][0].length;
        double[] tmpRe = new double[N + 1];
        double[] tmpIm = new double[N + 1];
        IwasawaFactorization.positivePart(xRe, xIm, fRe, fIm, bRe, bIm, tmpRe, tmpIm);
    }

    public static void positivePart(double[][][] xRe, double[][][] xIm, double[][][] fRe, double[][][] fIm, double[][][] bRe, double[][][] bIm, double[] tmpRe, double[] tmpIm) {
        IwasawaFactorization.times(fRe, fIm, xRe, xIm, bRe, bIm, tmpRe, tmpIm);
    }

    private static void times(double[][][] fRe, double[][][] fIm, double[][][] xRe, double[][][] xIm, double[][][] bRe, double[][][] bIm, double[] tmpRe, double[] tmpIm) {
        int n = fRe.length;
        int i = 0;
        while (i < n) {
            int j = 0;
            while (j < n) {
                IwasawaFactorization.polynomialTimes(fRe[0][i], fIm[0][i], xRe[0][j], xIm[0][j], bRe[i][j], bIm[i][j]);
                int k = 1;
                while (k < n) {
                    IwasawaFactorization.polynomialTimes(fRe[k][i], fIm[k][i], xRe[k][j], xIm[k][j], tmpRe, tmpIm);
                    VectorOperations.plus(bRe[i][j], tmpRe, bRe[i][j]);
                    VectorOperations.plus(bIm[i][j], tmpIm, bIm[i][j]);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private static void polynomialTimes(double[] fRe, double[] fIm, double[] xRe, double[] xIm, double[] bRe, double[] bIm) {
        if (fRe == bRe || xRe == bRe) {
            throw new IllegalArgumentException();
        }
        int N = (fRe.length - 1) / 2;
        int i = 0;
        while (i <= N) {
            double br = 0.0;
            double bi = 0.0;
            int j = 0;
            while (j <= 2 * N - i) {
                br += fRe[j] * xRe[i + j] + fIm[j] * xIm[i + j];
                bi += fRe[j] * xIm[i + j] - fIm[j] * xRe[i + j];
                ++j;
            }
            bRe[i] = br;
            bIm[i] = bi;
            ++i;
        }
    }

    private static void setBlock(double[] coeff, double[][] m, int row, int col, int N, int R) {
        int rows = 2 * N + 1 + R;
        int rowOffset = row * (2 * N + 1 + R);
        int colOffset = col * R;
        int j = 0;
        while (j < R) {
            int p0 = j + 1;
            int p1 = Math.min(rows, 2 * N + 2 + j);
            int i = 0;
            while (i < p0) {
                m[i + rowOffset][j + colOffset] = 0.0;
                ++i;
            }
            i = p0;
            while (i < p1) {
                m[i + rowOffset][j + colOffset] = coeff[i - j - 1];
                ++i;
            }
            i = p1;
            while (i < rows) {
                m[i + rowOffset][j + colOffset] = 0.0;
                ++i;
            }
            ++j;
        }
    }

    private static void setBlock(double[] coeff, double[] x, int row, int N, int R) {
        System.arraycopy(coeff, 0, x, row * (2 * N + 1 + R), 2 * N + 1);
        int i = row * (2 * N + 1 + R) + 2 * N + 1;
        int last = i + R;
        while (i < last) {
            x[i] = 0.0;
            ++i;
        }
    }

    private static void getBlock(double[] coeff, double[] x, int row, int N, int R) {
        System.arraycopy(x, row * (2 * N + 1 + R), coeff, 0, 2 * N + 1);
    }

    private static void assignZero(double[] x) {
        int i = 0;
        while (i < x.length) {
            x[i] = 0.0;
            ++i;
        }
    }
}

