/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.calculus.minimizing;

import de.jtem.numericalMethods.calculus.function.RealFunctionOfSeveralVariables;
import de.jtem.numericalMethods.calculus.minimizing.BrentOnLine;
import de.jtem.numericalMethods.calculus.minimizing.Info;
import java.io.Serializable;

public final class Powell
implements Serializable {
    private static final long serialVersionUID = 1L;
    static int ITMAX = 200;

    public static int getITMAX() {
        return ITMAX;
    }

    public static void setITMAX(int v) {
        ITMAX = v;
    }

    static final double sqr(double a) {
        return a * a;
    }

    public static double[][] getStandardBasis(int dim) {
        double[][] basis = new double[dim][dim];
        int i = 0;
        while (i < dim) {
            basis[i][i] = 1.0;
            ++i;
        }
        return basis;
    }

    public static final double search(double[] p, double ftol, RealFunctionOfSeveralVariables f) {
        return Powell.search(p, Powell.getStandardBasis(p.length), ftol, f, ITMAX, null);
    }

    public static final double search(double[] p, double ftol, int maxIteration, RealFunctionOfSeveralVariables f) {
        return Powell.search(p, Powell.getStandardBasis(p.length), ftol, f, maxIteration, null);
    }

    public static final double search(double[] p, double ftol, int maxIteration, RealFunctionOfSeveralVariables f, Info info) {
        return Powell.search(p, Powell.getStandardBasis(p.length), ftol, f, maxIteration, info);
    }

    public static double search(double[] p, double[][] xi, double ftol, RealFunctionOfSeveralVariables f, int itMax, Info info) {
        double[] aTuple = new double[2];
        int n = p.length;
        double[] pt = new double[n];
        double[] ptt = new double[n];
        double[] xit = new double[n];
        BrentOnLine brentOnLine = new BrentOnLine(p, xit, f);
        double fret = f.eval(p);
        if (info != null) {
            String s = new String(" f(p) = " + fret + " , p = ");
            int i = 0;
            while (i < n) {
                s = String.valueOf(s) + p[i] + " ";
                ++i;
            }
            info.setMessage(s);
            info.setMaxIter(itMax);
        }
        int j = 0;
        while (j < n) {
            pt[j] = p[j];
            ++j;
        }
        int iter = 1;
        while (true) {
            double t;
            double fptt;
            double fp = fret;
            int ibig = 0;
            double del = 0.0;
            int i = 0;
            while (i < n) {
                int j2 = 0;
                while (j2 < n) {
                    xit[j2] = xi[j2][i];
                    ++j2;
                }
                fptt = fret;
                if (Math.abs(fptt - (fret = brentOnLine.search(2.0E-8))) > del) {
                    del = Math.abs(fptt - fret);
                    ibig = i;
                }
                ++i;
            }
            if (2.0 * Math.abs(fp - fret) <= ftol * (Math.abs(fp) + Math.abs(fret))) {
                if (info != null) {
                    String s = new String("iter = " + iter + ", fret = " + fret + ", fp = " + fp + ", p = ");
                    int i2 = 0;
                    while (i2 < n) {
                        s = String.valueOf(s) + p[i2] + " ";
                        ++i2;
                    }
                    info.addMessage(s);
                    info.setCurrentIter(iter);
                    info.printDebug();
                }
                return fret;
            }
            if (info != null && iter == itMax) {
                info.setCurrentIter(iter);
                info.setMessage("Too many iterations in routine POWELL");
                info.printDebug();
                return fret;
            }
            int j3 = 0;
            while (j3 < n) {
                ptt[j3] = 2.0 * p[j3] - pt[j3];
                xit[j3] = p[j3] - pt[j3];
                pt[j3] = p[j3];
                ++j3;
            }
            fptt = f.eval(ptt);
            if (fptt < fp && (t = 2.0 * (fp - 2.0 * fret + fptt) * Powell.sqr(fp - fret - del) - del * Powell.sqr(fp - fptt)) < 0.0) {
                fret = brentOnLine.search(2.0E-8);
                int j4 = 0;
                while (j4 < n) {
                    xi[j4][ibig] = xit[j4];
                    ++j4;
                }
            }
            ++iter;
        }
    }
}

