/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.jrworkspace.plugin.simplecontroller.preferences;

import de.jtem.jrworkspace.plugin.flavor.PreferencesFlavor;
import de.jtem.jrworkspace.plugin.simplecontroller.image.ImageHook;
import de.jtem.jrworkspace.plugin.simplecontroller.widget.AbstractTreeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class PreferencesWindow
extends JDialog
implements TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private Image dialogIcon = ImageHook.getImage("prefs.png");
    private LinkedList<PreferencesFlavor> plugins = new LinkedList();
    private NavTreeModel navTreeModel = new NavTreeModel();
    private JTree navTree = new JTree(this.navTreeModel);
    private JPanel pagePanel = new JPanel();
    private JScrollPane navScroller = new JScrollPane(this.navTree);
    private JScrollPane pageScroller = new JScrollPane(this.pagePanel);
    private JSplitPane splitter = new JSplitPane(1, this.navScroller, this.pageScroller);
    private Icon defaultIcon = ImageHook.getIcon("prefs.png");

    public PreferencesWindow(Frame parent) {
        super(parent);
        this.setSize(600, 500);
        this.setMinimumSize(new Dimension(400, 400));
        ImageHook.setIconImage(this, this.dialogIcon);
        this.setTitle("jRWorkspace Preferences");
        this.makeLayout();
        this.navTree.setCellRenderer(this.navTreeModel);
        this.navTree.getSelectionModel().addTreeSelectionListener(this);
    }

    private void makeLayout() {
        this.setLayout(new BorderLayout());
        this.splitter.setContinuousLayout(true);
        this.splitter.setDividerLocation(200);
        this.add((Component)this.splitter, "Center");
        this.navTree.setShowsRootHandles(true);
        this.navTree.setExpandsSelectedPaths(false);
        this.navTree.setRootVisible(false);
        this.pagePanel.setLayout(new GridLayout());
    }

    public void updateData() {
        this.navTreeModel.update();
        int count = this.navTree.getRowCount();
        while (count-- > 0) {
            this.navTree.expandRow(count);
        }
    }

    public void showWindow() {
        if (this.isShowing()) {
            this.toFront();
            return;
        }
        this.setLocationByPlatform(true);
        this.setLocationRelativeTo(this.getParent());
        this.updateData();
        this.setVisible(true);
    }

    public boolean addPreferencesPlugin(PreferencesFlavor plugin) {
        boolean result = this.plugins.add(plugin);
        Collections.sort(this.plugins, new PageComparator());
        this.navTree.updateUI();
        return result;
    }

    public boolean removePreferencesPlugin(PreferencesFlavor plugin) {
        boolean result = this.plugins.remove(plugin);
        this.navTree.updateUI();
        return result;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = e.getNewLeadSelectionPath();
        if (path == null) {
            return;
        }
        if (path.getPathCount() < 2) {
            return;
        }
        if (path.getPathCount() == 2) {
            PreferencesFlavor plugin = (PreferencesFlavor)path.getLastPathComponent();
            this.pagePanel.removeAll();
            this.pagePanel.add(plugin.getMainPage());
        } else {
            PageTreeRow pageTreeRow = (PageTreeRow)path.getLastPathComponent();
            this.pagePanel.removeAll();
            this.pagePanel.add(pageTreeRow.pagePanel);
        }
        SwingUtilities.updateComponentTreeUI(this.pagePanel);
    }

    private class NavTreeModel
    extends AbstractTreeModel
    implements TreeCellRenderer {
        private DefaultTreeCellRenderer defaultTreeCellRenderer;

        public NavTreeModel() {
            super("Root Node");
            this.defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent == this.getRoot()) {
                return PreferencesWindow.this.plugins.get(index);
            }
            if (parent instanceof PreferencesFlavor) {
                PreferencesFlavor plugin = (PreferencesFlavor)parent;
                PageTreeRow pageTreeRow = new PageTreeRow();
                pageTreeRow.pageIndex = index;
                pageTreeRow.pageName = plugin.getSubPageName(index);
                pageTreeRow.pagePanel = plugin.getSubPage(index);
                pageTreeRow.pageIcon = plugin.getSubPageIcon(index);
                return pageTreeRow;
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent == this.getRoot()) {
                return PreferencesWindow.this.plugins.size();
            }
            if (parent instanceof PreferencesFlavor) {
                PreferencesFlavor plugin = (PreferencesFlavor)parent;
                return plugin.getNumSubPages();
            }
            return 0;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel l = (JLabel)this.defaultTreeCellRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof PreferencesFlavor) {
                PreferencesFlavor p = (PreferencesFlavor)value;
                l.setText(p.getMainName());
                if (p.getMainIcon() != null) {
                    Icon i = ImageHook.scaleIcon(p.getMainIcon(), 16, 16);
                    l.setIcon(i);
                } else {
                    l.setIcon(PreferencesWindow.this.defaultIcon);
                }
            } else if (value instanceof PageTreeRow) {
                PageTreeRow ptr = (PageTreeRow)value;
                if (ptr.pageIcon != null) {
                    Icon i = ImageHook.scaleIcon(ptr.pageIcon, 16, 16);
                    l.setIcon(i);
                } else {
                    l.setIcon(PreferencesWindow.this.defaultIcon);
                }
            }
            return l;
        }

        public void update() {
            this.fireTreeStructureChanged(this.getRoot());
        }

        @Override
        public Object getParent(Object o) {
            return null;
        }
    }

    private class PageComparator
    implements Comparator<PreferencesFlavor> {
        private PageComparator() {
        }

        @Override
        public int compare(PreferencesFlavor o1, PreferencesFlavor o2) {
            return o1.getMainName().compareTo(o2.getMainName());
        }
    }

    private static class PageTreeRow {
        public String pageName = "";
        public int pageIndex = 0;
        public JPanel pagePanel = null;
        public Icon pageIcon = null;

        private PageTreeRow() {
        }

        public String toString() {
            return String.valueOf(this.pageName) + ": " + this.pageIndex;
        }
    }
}

