/**
This file is part of a jTEM project.
All jTEM projects are licensed under the FreeBSD license 
or 2-clause BSD license (see http://www.opensource.org/licenses/bsd-license.php). 

Copyright (c) 2006-2010, Technische Universität Berlin, jTEM
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

-	Redistributions of source code must retain the above copyright notice, 
	this list of conditions and the following disclaimer.

-	Redistributions in binary form must reproduce the above copyright notice, 
	this list of conditions and the following disclaimer in the documentation 
	and/or other materials provided with the distribution.
 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS 
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, 
OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
**/

package de.jtem.beans;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.util.HashMap;
import java.util.HashSet;

//import sun.beans.editors.*;

public class EditorManager {

    private static HashMap<Class<?>,Class<?>> registry = new HashMap<Class<?>,Class<?>>();
    private static HashSet<Class<?>> ignoredTypes = new HashSet<Class<?>>();

    static {
    	registerEditor(Boolean.TYPE, BoolEditor.class);
    	registerEditor(Boolean.class, BooleanEditor.class);
    	registerEditor(Integer.class, IntegerSpinnerEditor.class);
    	registerEditor(Integer.TYPE, IntegerTypeSpinnerEditor.class);
    	registerEditor(Double.class, DoubleSpinnerEditor.class);
    	registerEditor(Double.TYPE, DoubleTypeSpinnerEditor.class);

    	registerEditor(String.class, StringEditor.class);
    	registerEditor(Color.class, ColorEditor.class);
    	registerEditor(Stroke.class, StrokeEditor.class);
    	registerEditor(Paint.class, ColorEditor.WithNullOption.class);
    	registerEditor(Font.class, FontEditor.class);
    }
    
    public static void registerIgnoredType(Class<?> ignoredType) {
        ignoredTypes.add(ignoredType);
    }
    
    public static void registerEditor(Class<?> targetType, Class<?> editorClass) {
	if (editorClass == null) {
	    registry.remove(targetType);
	} else {
	    registry.put(targetType, editorClass);
	}
    }

    public static synchronized PropertyEditor findEditor(Class<?> targetType) {
    if (ignoredTypes.contains(targetType)) return null;
	Class<?> editorClass = (Class<?>)registry.get(targetType);
	if (editorClass != null) {
	    try {
		Object o = editorClass.newInstance();
        	return (PropertyEditor)o;
	    } catch (Exception ex) {
	 	System.err.println("Couldn't instantiate type editor \"" +
			editorClass.getName() + "\" : " + ex);
	    }
	}
	try {
		// Now try adding "Editor" to the class name.
		String editorName = targetType.getName() + "Editor";
	    return (PropertyEditor) Class.forName(editorName).newInstance();
	} catch (Exception ex) {
	   // Silently ignore any errors.
	}

	return null;
    }
    
    public static PropertyEditor findEditor(PropertyDescriptor descriptor) {
        Class<?> propertyType = descriptor.getPropertyType();
        if (ignoredTypes.contains(propertyType)) return null;
        // TODO: which order?
        PropertyEditor pe=findEditor(propertyType);
        
        Class<?> edcl=descriptor.getPropertyEditorClass();
        if(edcl!=null) try
        {
            pe=(PropertyEditor)edcl.newInstance();
        } catch(Exception ex){
            ex.printStackTrace();
        }
        return pe;
    }
}