/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.geodesic;

public class IntTriple {
    IntTriple() {
    }

    public static int getOppEntry(int[] triple, int entryA, int entryB) {
        if (triple[0] != entryA && triple[0] != entryB) {
            return triple[0];
        }
        if (triple[1] != entryA && triple[1] != entryB) {
            return triple[1];
        }
        return triple[2];
    }

    public static int getOppLocInd(int[] triple, int entryA, int entryB) {
        if (triple[0] != entryA && triple[0] != entryB) {
            return 0;
        }
        if (triple[1] != entryA && triple[1] != entryB) {
            return 1;
        }
        if (triple[2] != entryA && triple[2] != entryB) {
            return 2;
        }
        return -1;
    }

    public static int getLocInd(int[] triple, int entry) {
        if (triple[0] == entry) {
            return 0;
        }
        if (triple[1] == entry) {
            return 1;
        }
        if (triple[2] == entry) {
            return 2;
        }
        return -1;
    }

    public static void replaceEntry(int[] triple, int entry, int newEntry) {
        if (triple[0] == entry) {
            triple[0] = newEntry;
        }
        if (triple[1] == entry) {
            triple[1] = newEntry;
        }
        if (triple[2] == entry) {
            triple[2] = newEntry;
        }
    }

    public static int getMax(int[] triple) {
        int max = triple[0];
        if (triple[1] > max) {
            max = triple[1];
        }
        if (triple[2] > max) {
            max = triple[2];
        }
        return max;
    }

    public static int getMin(int[] triple) {
        int min = triple[0];
        if (triple[1] < min) {
            min = triple[1];
        }
        if (triple[2] < min) {
            min = triple[2];
        }
        return min;
    }

    public static int getMap(int[] map, int[] triple1, int[] triple2) {
        int k = 0;
        int i = 0;
        while (i < 3) {
            map[i] = -1;
            int j = 0;
            while (j < 3) {
                if (triple1[j] == triple2[i]) {
                    map[i] = j;
                    ++k;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return k;
    }

    public static void applyToVec3(int[] map, double[] vec) {
        double[] h = new double[]{vec[0], vec[1], vec[2]};
        vec[0] = map[0] < 0 ? 0.0 : h[map[0]];
        vec[1] = map[1] < 0 ? 0.0 : h[map[1]];
        vec[2] = map[2] < 0 ? 0.0 : h[map[2]];
    }

    public static void applyInvToVec3(int[] map, double[] vec) {
        double[] h = new double[]{vec[0], vec[1], vec[2]};
        if (map[0] < 0) {
            vec[0] = 0.0;
        } else {
            vec[map[0]] = h[0];
        }
        if (map[1] < 0) {
            vec[1] = 0.0;
        } else {
            vec[map[1]] = h[1];
        }
        if (map[2] < 0) {
            vec[2] = 0.0;
        } else {
            vec[map[2]] = h[2];
        }
    }

    public static double getMapForVec3(int[] map, double[] vec1, double[] vec2) {
        double out = 0.0;
        boolean[] is = new boolean[3];
        int i = 0;
        while (i < 3) {
            double min = 1.0E99;
            int j = 0;
            while (j < 3) {
                if (!is[j]) {
                    double d;
                    double help = Math.abs(vec1[i] - vec2[j]);
                    if (d < min) {
                        map[i] = j;
                        min = help;
                    }
                }
                ++j;
            }
            is[map[i]] = true;
            out += min;
            ++i;
        }
        return out / (Math.abs(vec1[0]) + Math.abs(vec1[1]) + Math.abs(vec1[2]));
    }
}

