/*
 * Decompiled with CFR 0.152.
 */
package vrpn;

import java.util.Vector;
import vrpn.TrackerRemote;

public class TrackerRemoteListener
implements TrackerRemote.PositionChangeListener,
TrackerRemote.VelocityChangeListener,
TrackerRemote.AccelerationChangeListener {
    public static final int ALL_UPDATES = 0;
    public static final int LAST_UPDATE = 1;
    protected Vector trackerUpdates = new Vector();
    protected Vector velocityUpdates = new Vector();
    protected Vector accelerationUpdates = new Vector();
    protected int trackerBufferMode = 1;
    protected int velocityBufferMode = 1;
    protected int accelerationBufferMode = 1;

    public TrackerRemoteListener(TrackerRemote tracker) {
        tracker.addPositionChangeListener(this);
        tracker.addVelocityChangeListener(this);
        tracker.addAccelerationChangeListener(this);
    }

    public synchronized void setModeLastTrackerUpdate() {
        this.trackerBufferMode = 1;
        if (!this.trackerUpdates.isEmpty()) {
            Object temp = this.trackerUpdates.lastElement();
            this.trackerUpdates.removeAllElements();
            this.trackerUpdates.addElement(temp);
        }
    }

    public synchronized void setModeLastVelocityUpdate() {
        this.velocityBufferMode = 1;
        if (!this.velocityUpdates.isEmpty()) {
            Object temp = this.velocityUpdates.lastElement();
            this.velocityUpdates.removeAllElements();
            this.velocityUpdates.addElement(temp);
        }
    }

    public synchronized void setModeLastAccelerationUpdate() {
        this.accelerationBufferMode = 1;
        if (!this.accelerationUpdates.isEmpty()) {
            Object temp = this.accelerationUpdates.lastElement();
            this.accelerationUpdates.removeAllElements();
            this.accelerationUpdates.addElement(temp);
        }
    }

    public synchronized void setModeAllTrackerUpdates() {
        if (this.trackerBufferMode == 1) {
            this.trackerUpdates.removeAllElements();
        }
        this.trackerBufferMode = 0;
    }

    public synchronized void setModeAllVelocityUpdates() {
        if (this.velocityBufferMode == 1) {
            this.velocityUpdates.removeAllElements();
        }
        this.velocityBufferMode = 0;
    }

    public synchronized void setModeAllAccelerationUpdates() {
        if (this.accelerationBufferMode == 1) {
            this.accelerationUpdates.removeAllElements();
        }
        this.accelerationBufferMode = 0;
    }

    public synchronized int getModeTrackerUpdate() {
        return this.trackerBufferMode;
    }

    public synchronized int getModeVelocityUpdate() {
        return this.velocityBufferMode;
    }

    public synchronized int getModeAccelerationUpdate() {
        return this.accelerationBufferMode;
    }

    public synchronized Vector getTrackerUpdate() {
        Vector v = new Vector();
        if (this.trackerUpdates.isEmpty()) {
            return v;
        }
        if (this.trackerBufferMode == 1) {
            v.addElement(this.trackerUpdates.lastElement());
        } else if (this.trackerBufferMode == 0) {
            int i = 0;
            while (i < this.trackerUpdates.size()) {
                v.addElement(this.trackerUpdates.elementAt(i));
                ++i;
            }
            this.trackerUpdates.removeAllElements();
        }
        return v;
    }

    public synchronized Vector getVelocityUpdate() {
        Vector v = new Vector();
        if (this.velocityUpdates.isEmpty()) {
            return v;
        }
        if (this.velocityBufferMode == 1) {
            v.addElement(this.velocityUpdates.lastElement());
        } else if (this.velocityBufferMode == 0) {
            int i = 0;
            while (i < this.velocityUpdates.size()) {
                v.addElement(this.velocityUpdates.elementAt(i));
                ++i;
            }
            this.velocityUpdates.removeAllElements();
        }
        return v;
    }

    public synchronized Vector getAcclerationUpdate() {
        Vector v = new Vector();
        if (this.accelerationUpdates.isEmpty()) {
            return v;
        }
        if (this.accelerationBufferMode == 1) {
            v.addElement(this.accelerationUpdates.lastElement());
        } else if (this.accelerationBufferMode == 0) {
            int i = 0;
            while (i < this.accelerationUpdates.size()) {
                v.addElement(this.accelerationUpdates.elementAt(i));
                ++i;
            }
            this.accelerationUpdates.removeAllElements();
        }
        return v;
    }

    public synchronized TrackerRemote.TrackerUpdate getLastTrackerUpdate() {
        if (this.trackerUpdates.isEmpty()) {
            return null;
        }
        return (TrackerRemote.TrackerUpdate)this.trackerUpdates.lastElement();
    }

    public synchronized TrackerRemote.VelocityUpdate getLastVelocityUpdate() {
        if (this.velocityUpdates.isEmpty()) {
            return null;
        }
        return (TrackerRemote.VelocityUpdate)this.velocityUpdates.lastElement();
    }

    public synchronized TrackerRemote.AccelerationUpdate getLastAccelerationUpdate() {
        if (this.accelerationUpdates.isEmpty()) {
            return null;
        }
        return (TrackerRemote.AccelerationUpdate)this.accelerationUpdates.lastElement();
    }

    @Override
    public synchronized void trackerPositionUpdate(TrackerRemote.TrackerUpdate u, TrackerRemote tracker) {
        if (this.trackerBufferMode == 1) {
            this.trackerUpdates.removeAllElements();
        }
        this.trackerUpdates.addElement(u);
    }

    @Override
    public synchronized void trackerVelocityUpdate(TrackerRemote.VelocityUpdate v, TrackerRemote tracker) {
        if (this.velocityBufferMode == 1) {
            this.velocityUpdates.removeAllElements();
        }
        this.velocityUpdates.addElement(v);
    }

    @Override
    public synchronized void trackerAccelerationUpdate(TrackerRemote.AccelerationUpdate a, TrackerRemote tracker) {
        if (this.accelerationBufferMode == 1) {
            this.accelerationUpdates.removeAllElements();
        }
        this.accelerationUpdates.addElement(a);
    }
}

