#include "mddata.h"
#define NULL (char *)0

/* arrays and data for parsing/printing printer data types */

/* array giving strings for printing and parsing colour names */
const OptEntry colour_table[] = {
  { "Black", colBlack } ,
  { "Cyan", colCyan } ,
  { "Magenta", colMagenta } ,
  { "Yellow", colYellow } ,
  { "MetallicGold", colMetallicGold } ,
  { "MetallicMagenta", colMetallicMagenta } ,
  { "MetallicCyan", colMetallicCyan } ,
  { "MetallicSilver", colMetallicSilver } ,
  { "LabecaBlack", colLabecaBlack } ,
  { "LabecaRed", colLabecaRed } ,
  { "LabecaBlue", colLabecaBlue } ,
  { "White", colWhite } ,
  { "Overcoat", colDyeSubOvercoat } ,
  { "DyeSubFinish", colDyeSubGlossyFinish } ,
  { "Finish", colGlossyFinish } ,
  { "Unknown(0x0F)", colReserved0F },
  { "Primer", colVPhotoPrimer } ,
  { "GoldFoil", colGoldFoil } ,
  { "Unknown(0x12)", colReserved12 } ,
  { "Unknown(0x13)", colReserved13 } ,
  { "SilverFoil", colSilverFoil } ,
  { "Unknown(0x15)", colReserved15 } ,
  { "EconoBlack", colEconoBlack } ,
  { "RawGoldFoil", colRawGoldFoil },
  { "RawSilverFoil", colRawSilverFoil },
  { "NullSpot", colNullSpot },
  { "NullFoil", colNullFoil },
  /* and now some short names.
     c,m,y,fin,pri,w,n  are already included as prefixes.
  */
  { "k", colBlack },
  { "mg", colMetallicGold },
  { "mm", colMetallicMagenta },
  { "mc", colMetallicCyan },
  { "ms", colMetallicSilver },
  { "oc", colDyeSubOvercoat },
  { "dsf", colDyeSubGlossyFinish },
  { "gf", colGoldFoil },
  { "sf", colSilverFoil },
  { "eb", colEconoBlack },
  { "rgf", colRawGoldFoil },
  { "rsf", colRawSilverFoil },
  { "ns", colNullSpot },
  { "nf", colNullFoil },
  { NULL, -1 }
};

/* This is an array that maps the colour codes used by the program
   to the colour selection bytes used by the printer. It is mostly
   the identity, except that the RawFoil colours map to the Foil codes.
*/
const unsigned char colour_to_command[] = {
  colBlack,
  colCyan,
  colMagenta,
  colYellow,
  colMetallicGold,
  colMetallicMagenta,
  colMetallicCyan,
  colMetallicSilver,
  colLabecaBlack,
  colLabecaRed,
  colLabecaBlue,
  colWhite,
  colDyeSubOvercoat,
  colDyeSubGlossyFinish,
  colGlossyFinish,
  colReserved0F,
  colVPhotoPrimer,
  colGoldFoil,
  colReserved12,
  colReserved13,
  colSilverFoil,
  colReserved15,
  colEconoBlack,
  /* colRawGoldFoil */ colGoldFoil,
  /* colRawSilverFoil */ colSilverFoil
};

/* This is an array that maps colours to barcodes
   if NOT in dyesub mode. It assumes a 5000. */
const barCode colour_to_barcode[] = {
  /* colBlack */ barBlack,
  /* colCyan */ barCyan,
  /* colMagenta */ barMagenta,
  /* colYellow */ barYellow,
  /* colMetallicGold */ barMetallicGold,
  /* colMetallicMagenta */ barMetallicMagenta,
  /* colMetallicCyan */ barMetallicCyan,
  /* colMetallicSilver */ barMetallicSilver,
  /* colLabecaBlack */ barLabecaBlack,
  /* colLabecaRed */ barLabecaRed,
  /* colLabecaBlue */ barLabecaBlue,
  /* colWhite */ barWhite,
  /* colDyeSubOvercoat */ barDyeSubOvercoat,
  /* colDyeSubGlossyFinish */ barDyeSubFinish,
  /* colGlossyFinish */ barFinishII,
  /* colReserved0F */ barNoCassette,
  /* colVPhotoPrimer */ barVPhotoPrimer,
  /* colGoldFoil */ barGoldFoil,
  /* colReserved12 */ barNoCassette,
  /* colReserved13 */ barNoCassette,
  /* colSilverFoil */ barSilverFoil,
  /* colReserved15 */ barNoCassette,
  /* colEconoBlack */ barEconoBlack,
  /* colRawGoldFoil */ barGoldFoil,
  /* colRawSilverFoil */ barSilverFoil,
};

/* This is an array that maps colours to barcodes
   in dyesub mode. It assumes a 5000. */
const barCode colour_to_barcode_dyesub[] = {
  /* colBlack */ barNoCassette,
  /* colCyan */ barDyeSubCyan,
  /* colMagenta */ barDyeSubMagenta,
  /* colYellow */ barDyeSubYellow,
  /* colMetallicGold */ barNoCassette,
  /* colMetallicMagenta */ barNoCassette,
  /* colMetallicCyan */ barNoCassette,
  /* colMetallicSilver */ barNoCassette,
  /* colLabecaBlack */ barNoCassette,
  /* colLabecaRed */ barNoCassette,
  /* colLabecaBlue */ barNoCassette,
  /* colWhite */ barNoCassette,
  /* colDyeSubOvercoat */ barDyeSubOvercoat,
  /* colDyeSubGlossyFinish */ barDyeSubFinish,
  /* colGlossyFinish */ barNoCassette,
  /* colReserved0F */ barNoCassette,
  /* colVPhotoPrimer */ barNoCassette,
  /* colGoldFoil */ barNoCassette,
  /* colReserved12 */ barNoCassette,
  /* colReserved13 */ barNoCassette,
  /* colSilverFoil */ barNoCassette,
  /* colReserved15 */ barNoCassette,
  /* colEconoBlack */ barNoCassette,
  /* colRawGoldFoil */ barNoCassette,
  /* colRawSilverFoil */ barNoCassette
};

/* array of names for cassettes */
const char *cassette_names[] = {
  "Black",
  "Yellow",
  "Magenta",
  "Cyan",
  "MultiColour",
  "GoldFoil",
  "SilverFoil",
  "Unknown(7)",
  "MetallicGold",
  "MetallicMagenta",
  "MetallicCyan",
  "MetallicSilver",
  "Unknown(12)",
  "Yellow(OHP)",
  "Magenta(OHP)",
  "Cyan(OHP)",
  "White",
  "Finish",
  "VPhotoPrimer",
  "FinishII",
  "LabecaBlack",
  "LabecaBlue",
  "LabecaRed",
  "EconoBlack",
  "Unknown(24)",
  "Yellow(DyeSub)",
  "Magenta(DyeSub)",
  "Cyan(DyeSub)",
  "Overcoat(DyeSub)",
  "Unknown(29)",
  "OvercoatII(DyeSub)",
  "Unknown(31)",
  "SpotRed",
  "SpotGreen",
  "SpotBlue",
  "ProcessBlack",
  "ProcessYellow",
  "ProcessMagenta",
  "ProcessCyan"
};

/* the first byte of the media code */
const char media_byte1[] =
{ 0x00, 0x00,
  0x01, 0x01,
  0x02, 0x02,
  0x03,
  0x04, 0x04,
  0x05,
  0x06,
  0x07,
  0x08, 0x08,
  0x09, 0x09,
  0x0A,
  0x0B,
  0x0C,
  0x0D,
  0x0E,
  0x0F,
  0x10,
  0x11
};

/* the second byte of the media code */
const char media_byte2[] =
{ 0x00, 0x02,
  0x00, 0x01,
  0x01, 0x02,
  0x00,
  0x00, 0x01,
  0x00,
  0x00,
  0x00,
  0x00, 0x01,
  0x00, 0x02,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00
};

/* names for media types */
const OptEntry media_table[] = {
  { "PlainPaper", mediaPlainPaper } ,
  { "FinePlainPaper", mediaFinePlainPaper } ,
  { "FineSpecialOHP", mediaFineSpecialOHP } ,
  { "SpecialOHP", mediaSpecialOHP } ,
  { "SpecialIron", mediaSpecialIron } ,
  { "IronSheet", mediaIronSheet } ,
  { "LabecaSheet", mediaLabecaSheet } ,
  { "ThermalPaper", mediaThermalPaper } ,
  { "CDMaster", mediaCDMaster } ,
  { "Cardboard", mediaCardboard } ,
  { "PostCard", mediaPostCard } ,
  { "LaserPaper", mediaLaserPaper } ,
  { "FineOHP", mediaFineOHP } ,
  { "OHP", mediaOHP } ,
  { "BackPrint", mediaBackPrint } ,
  { "FineBackPrint", mediaFineBackPrint } ,
  { "DyeSubPaper", mediaDyeSubPaper } ,
  { "Reserved0B00", mediaReserved0B00 } ,
  { "DyeSubLabel", mediaDyeSubLabel } ,
  { "Reserved0D00", mediaReserved0D00 } ,
  { "GlossyLabel", mediaGlossyLabel } ,
  { "GlossyPaper", mediaGlossyPaper } ,
  { "VPhotoFilm", mediaVPhotoFilm } ,
  { "VPhotoCard", mediaVPhotoCard } ,
  { NULL, -1 }
};

/* names */
const OptEntry paper_table[] = {
  { "Custom", paperCustom } ,
  { "Executive", paperExecutive } ,
  { "Letter", paperLetter } ,
  { "Legal", paperLegal } ,
  { "A4", paperA4 } ,
  { "B5", paperB5 } ,
  { "PostCard", paperPostCard } ,
  { "DyeSubLabel", paperDyeSubLabel } ,
  { NULL, -1 }
};

const OptEntry model_table[] = {
  { "Printiva-600", modelPrintiva600 } ,
  { "Printiva-600U", modelPrintiva600U } ,
  { "Printiva-700", modelPrintiva700 } ,
  { "Printiva-1700", modelPrintiva1700 } ,
  { "MD-2000", modelMD2000 } ,
  { "MD-2010", modelMD2010 } ,
  { "MD-4000", modelMD4000 } ,
  { "MD-2300", modelMD2300 } ,
  { "MD-1000", modelMD1000 } ,
  { "MD-1300", modelMD1300 } ,
  { "MD-1500", modelMD1500 } ,
  { "MD-5000", modelMD5000 } ,
  { "MD-5500", modelMD5500 } ,
  { "", -1 } ,
  { "", -1 } ,
  { "", -1 } ,
  { "", -1 } ,
  { "", -1 } ,
  { "", -1 } ,
  { "", -1 } ,
  { "DP-5000", modelDP5000 } ,
  { NULL, -1 }
};

/* models that support white */
const int
  modelHasWhite = mbit(modelMD1000) |  mbit(modelMD1300)
     |  mbit(modelMD1500) | model5k;
  /* mbit(models) that support glossy finish; believed to be the same
     as white */
const int
modelHasFinish = mbit(modelMD1000) |  mbit(modelMD1300)
     |  mbit(modelMD1500) | model5k;
  /* models that support dyesub */
const int
  modelHasDyeSub = mbit(modelMD2300) | mbit(modelMD1300) | mbit(modelMD1500) 
  | mbit(modelMD5000) | mbit(modelMD5500) | mbit(modelDP5000);
  /* models that support 1200dpi in colour */
const int
modelHasHighResColour = mbit(modelMD1000) | mbit(modelMD1300) | mbit(modelMD2300) /*?*/ | mbit(modelMD1500) | model5k;
  /* models that support vphoto (4bit colour other than dyesub).
     I believe that (amazingly) models before the 5000 did not
     support this, even if they had dyesub. */
const int
modelHasVPhoto = model5k;
/* models that support vphoto primer. */
const int
modelHasVPhotoPrimer = model5k;
/* models that support foil */
const int
modelHasFoil = model5k;
/* models supporting econoblack */
const int
modelHasEconoBlack = model5k;
/* A4 models with the extended carriage and page sizes, introduced with
   the 5000 series */
const int
  modelHas5000PageSizes = mbit(modelMD5000) | mbit(modelMD5500) | mbit(modelDP5000);
/* Models that support print modes independent of the media type */
const int modelHasPrintModes = model5k;

/* this is a single property: printers that support
   the multi-plane raster modes, and the multicolour CMY ribbon,
   and the modes that select by cassette holder. Support for
   all of these was withdrawn with the 5000 */
const int
  modelHasMultiRaster = mbit(modelPrintiva600) | mbit(modelPrintiva600U) 
  | mbit(modelPrintiva700) | mbit(modelPrintiva1700) | mbit(modelMD2000) 
  | mbit(modelMD2010) | mbit(modelMD4000) | mbit(modelMD2300) | mbit(modelMD1000) 
  |  mbit(modelMD1300) | mbit(modelMD1500) ;

/* and names for printing/parsing */
const OptEntry transfer_mode_table[] = {
  { "Black", blackRaster } ,
  { "EconoBlack", econoblackRaster } ,
  { "RasterColour", colourRaster },
  { "", -1 } , /* dummy - reserved mode */
  { "Colour", colourPlane } ,
  { "RasterCassette", cassetteRaster } ,
  { "", -1 } , /* dummy - reserved mode */
  { "Cassette", cassettePlane } ,
  { "NColour", multiPlane },
  { "", -1 }, /* end of main list */
  { "MultiColour", multiPlane }, /* for backwards compat */
  { NULL, -1 }
};

/* the codes in the print mode setting command */
unsigned char print_mode_bytes[] = {
  0x00,
  0x01, 0x02,
  0x11, 0x12, 0x13, 0x14,
  0x21, 0x22,
  0x81, 0x82,
  0x91, 0x92
};

