#ifndef EMOJIS_H__
#define EMOJIS_H__

typedef struct emoji_s {
    const char *alias;
    const char *emoji;
} emoji_t;
// emoji_t array are expected to be NULL terminated

static emoji_t EmojiTable[] = {
    {":grinning:", "\xf0\x9f\x98\x80"}, // 😀
    {":smiley:", "\xf0\x9f\x98\x83"}, // 😃
    {":smile:", "\xf0\x9f\x98\x84"}, // 😄
    {":grin:", "\xf0\x9f\x98\x81"}, // 😁
    {":laughing:", "\xf0\x9f\x98\x86"}, // 😆
    {":satisfied:", "\xf0\x9f\x98\x86"}, // 😆
    {":sweat_smile:", "\xf0\x9f\x98\x85"}, // 😅
    {":rofl:", "\xf0\x9f\xa4\xa3"}, // 🤣
    {":joy:", "\xf0\x9f\x98\x82"}, // 😂
    {":slightly_smiling_face:", "\xf0\x9f\x99\x82"}, // 🙂
    {":upside_down_face:", "\xf0\x9f\x99\x83"}, // 🙃
    {":wink:", "\xf0\x9f\x98\x89"}, // 😉
    {":blush:", "\xf0\x9f\x98\x8a"}, // 😊
    {":innocent:", "\xf0\x9f\x98\x87"}, // 😇
    {":smiling_face_with_three_hearts:", "\xf0\x9f\xa5\xb0"}, // 🥰
    {":heart_eyes:", "\xf0\x9f\x98\x8d"}, // 😍
    {":star_struck:", "\xf0\x9f\xa4\xa9"}, // 🤩
    {":kissing_heart:", "\xf0\x9f\x98\x98"}, // 😘
    {":kissing:", "\xf0\x9f\x98\x97"}, // 😗
    {":relaxed:", "\xe2\x98\xba\xef\xb8\x8f"}, // ☺️
    {":kissing_closed_eyes:", "\xf0\x9f\x98\x9a"}, // 😚
    {":kissing_smiling_eyes:", "\xf0\x9f\x98\x99"}, // 😙
    {":smiling_face_with_tear:", "\xf0\x9f\xa5\xb2"}, // 🥲
    {":yum:", "\xf0\x9f\x98\x8b"}, // 😋
    {":stuck_out_tongue:", "\xf0\x9f\x98\x9b"}, // 😛
    {":stuck_out_tongue_winking_eye:", "\xf0\x9f\x98\x9c"}, // 😜
    {":zany_face:", "\xf0\x9f\xa4\xaa"}, // 🤪
    {":stuck_out_tongue_closed_eyes:", "\xf0\x9f\x98\x9d"}, // 😝
    {":money_mouth_face:", "\xf0\x9f\xa4\x91"}, // 🤑
    {":hugs:", "\xf0\x9f\xa4\x97"}, // 🤗
    {":hand_over_mouth:", "\xf0\x9f\xa4\xad"}, // 🤭
    {":shushing_face:", "\xf0\x9f\xa4\xab"}, // 🤫
    {":thinking:", "\xf0\x9f\xa4\x94"}, // 🤔
    {":zipper_mouth_face:", "\xf0\x9f\xa4\x90"}, // 🤐
    {":raised_eyebrow:", "\xf0\x9f\xa4\xa8"}, // 🤨
    {":neutral_face:", "\xf0\x9f\x98\x90"}, // 😐
    {":expressionless:", "\xf0\x9f\x98\x91"}, // 😑
    {":no_mouth:", "\xf0\x9f\x98\xb6"}, // 😶
    {":face_in_clouds:", "\xf0\x9f\x98\xb6\xe2\x80\x8d\xf0\x9f\x8c\xab\xef\xb8\x8f"}, // 😶‍🌫️
    {":smirk:", "\xf0\x9f\x98\x8f"}, // 😏
    {":unamused:", "\xf0\x9f\x98\x92"}, // 😒
    {":roll_eyes:", "\xf0\x9f\x99\x84"}, // 🙄
    {":grimacing:", "\xf0\x9f\x98\xac"}, // 😬
    {":face_exhaling:", "\xf0\x9f\x98\xae\xe2\x80\x8d\xf0\x9f\x92\xa8"}, // 😮‍💨
    {":lying_face:", "\xf0\x9f\xa4\xa5"}, // 🤥
    {":relieved:", "\xf0\x9f\x98\x8c"}, // 😌
    {":pensive:", "\xf0\x9f\x98\x94"}, // 😔
    {":sleepy:", "\xf0\x9f\x98\xaa"}, // 😪
    {":drooling_face:", "\xf0\x9f\xa4\xa4"}, // 🤤
    {":sleeping:", "\xf0\x9f\x98\xb4"}, // 😴
    {":mask:", "\xf0\x9f\x98\xb7"}, // 😷
    {":face_with_thermometer:", "\xf0\x9f\xa4\x92"}, // 🤒
    {":face_with_head_bandage:", "\xf0\x9f\xa4\x95"}, // 🤕
    {":nauseated_face:", "\xf0\x9f\xa4\xa2"}, // 🤢
    {":vomiting_face:", "\xf0\x9f\xa4\xae"}, // 🤮
    {":sneezing_face:", "\xf0\x9f\xa4\xa7"}, // 🤧
    {":hot_face:", "\xf0\x9f\xa5\xb5"}, // 🥵
    {":cold_face:", "\xf0\x9f\xa5\xb6"}, // 🥶
    {":woozy_face:", "\xf0\x9f\xa5\xb4"}, // 🥴
    {":dizzy_face:", "\xf0\x9f\x98\xb5"}, // 😵
    {":face_with_spiral_eyes:", "\xf0\x9f\x98\xb5\xe2\x80\x8d\xf0\x9f\x92\xab"}, // 😵‍💫
    {":exploding_head:", "\xf0\x9f\xa4\xaf"}, // 🤯
    {":cowboy_hat_face:", "\xf0\x9f\xa4\xa0"}, // 🤠
    {":partying_face:", "\xf0\x9f\xa5\xb3"}, // 🥳
    {":disguised_face:", "\xf0\x9f\xa5\xb8"}, // 🥸
    {":sunglasses:", "\xf0\x9f\x98\x8e"}, // 😎
    {":nerd_face:", "\xf0\x9f\xa4\x93"}, // 🤓
    {":monocle_face:", "\xf0\x9f\xa7\x90"}, // 🧐
    {":confused:", "\xf0\x9f\x98\x95"}, // 😕
    {":worried:", "\xf0\x9f\x98\x9f"}, // 😟
    {":slightly_frowning_face:", "\xf0\x9f\x99\x81"}, // 🙁
    {":frowning_face:", "\xe2\x98\xb9\xef\xb8\x8f"}, // ☹️
    {":open_mouth:", "\xf0\x9f\x98\xae"}, // 😮
    {":hushed:", "\xf0\x9f\x98\xaf"}, // 😯
    {":astonished:", "\xf0\x9f\x98\xb2"}, // 😲
    {":flushed:", "\xf0\x9f\x98\xb3"}, // 😳
    {":pleading_face:", "\xf0\x9f\xa5\xba"}, // 🥺
    {":frowning:", "\xf0\x9f\x98\xa6"}, // 😦
    {":anguished:", "\xf0\x9f\x98\xa7"}, // 😧
    {":fearful:", "\xf0\x9f\x98\xa8"}, // 😨
    {":cold_sweat:", "\xf0\x9f\x98\xb0"}, // 😰
    {":disappointed_relieved:", "\xf0\x9f\x98\xa5"}, // 😥
    {":cry:", "\xf0\x9f\x98\xa2"}, // 😢
    {":sob:", "\xf0\x9f\x98\xad"}, // 😭
    {":scream:", "\xf0\x9f\x98\xb1"}, // 😱
    {":confounded:", "\xf0\x9f\x98\x96"}, // 😖
    {":persevere:", "\xf0\x9f\x98\xa3"}, // 😣
    {":disappointed:", "\xf0\x9f\x98\x9e"}, // 😞
    {":sweat:", "\xf0\x9f\x98\x93"}, // 😓
    {":weary:", "\xf0\x9f\x98\xa9"}, // 😩
    {":tired_face:", "\xf0\x9f\x98\xab"}, // 😫
    {":yawning_face:", "\xf0\x9f\xa5\xb1"}, // 🥱
    {":triumph:", "\xf0\x9f\x98\xa4"}, // 😤
    {":rage:", "\xf0\x9f\x98\xa1"}, // 😡
    {":pout:", "\xf0\x9f\x98\xa1"}, // 😡
    {":angry:", "\xf0\x9f\x98\xa0"}, // 😠
    {":cursing_face:", "\xf0\x9f\xa4\xac"}, // 🤬
    {":smiling_imp:", "\xf0\x9f\x98\x88"}, // 😈
    {":imp:", "\xf0\x9f\x91\xbf"}, // 👿
    {":skull:", "\xf0\x9f\x92\x80"}, // 💀
    {":skull_and_crossbones:", "\xe2\x98\xa0\xef\xb8\x8f"}, // ☠️
    {":hankey:", "\xf0\x9f\x92\xa9"}, // 💩
    {":poop:", "\xf0\x9f\x92\xa9"}, // 💩
    {":shit:", "\xf0\x9f\x92\xa9"}, // 💩
    {":clown_face:", "\xf0\x9f\xa4\xa1"}, // 🤡
    {":japanese_ogre:", "\xf0\x9f\x91\xb9"}, // 👹
    {":japanese_goblin:", "\xf0\x9f\x91\xba"}, // 👺
    {":ghost:", "\xf0\x9f\x91\xbb"}, // 👻
    {":alien:", "\xf0\x9f\x91\xbd"}, // 👽
    {":space_invader:", "\xf0\x9f\x91\xbe"}, // 👾
    {":robot:", "\xf0\x9f\xa4\x96"}, // 🤖
    {":smiley_cat:", "\xf0\x9f\x98\xba"}, // 😺
    {":smile_cat:", "\xf0\x9f\x98\xb8"}, // 😸
    {":joy_cat:", "\xf0\x9f\x98\xb9"}, // 😹
    {":heart_eyes_cat:", "\xf0\x9f\x98\xbb"}, // 😻
    {":smirk_cat:", "\xf0\x9f\x98\xbc"}, // 😼
    {":kissing_cat:", "\xf0\x9f\x98\xbd"}, // 😽
    {":scream_cat:", "\xf0\x9f\x99\x80"}, // 🙀
    {":crying_cat_face:", "\xf0\x9f\x98\xbf"}, // 😿
    {":pouting_cat:", "\xf0\x9f\x98\xbe"}, // 😾
    {":see_no_evil:", "\xf0\x9f\x99\x88"}, // 🙈
    {":hear_no_evil:", "\xf0\x9f\x99\x89"}, // 🙉
    {":speak_no_evil:", "\xf0\x9f\x99\x8a"}, // 🙊
    {":kiss:", "\xf0\x9f\x92\x8b"}, // 💋
    {":love_letter:", "\xf0\x9f\x92\x8c"}, // 💌
    {":cupid:", "\xf0\x9f\x92\x98"}, // 💘
    {":gift_heart:", "\xf0\x9f\x92\x9d"}, // 💝
    {":sparkling_heart:", "\xf0\x9f\x92\x96"}, // 💖
    {":heartpulse:", "\xf0\x9f\x92\x97"}, // 💗
    {":heartbeat:", "\xf0\x9f\x92\x93"}, // 💓
    {":revolving_hearts:", "\xf0\x9f\x92\x9e"}, // 💞
    {":two_hearts:", "\xf0\x9f\x92\x95"}, // 💕
    {":heart_decoration:", "\xf0\x9f\x92\x9f"}, // 💟
    {":heavy_heart_exclamation:", "\xe2\x9d\xa3\xef\xb8\x8f"}, // ❣️
    {":broken_heart:", "\xf0\x9f\x92\x94"}, // 💔
    {":heart_on_fire:", "\xe2\x9d\xa4\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x94\xa5"}, // ❤️‍🔥
    {":mending_heart:", "\xe2\x9d\xa4\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\xa9\xb9"}, // ❤️‍🩹
    {":heart:", "\xe2\x9d\xa4\xef\xb8\x8f"}, // ❤️
    {":orange_heart:", "\xf0\x9f\xa7\xa1"}, // 🧡
    {":yellow_heart:", "\xf0\x9f\x92\x9b"}, // 💛
    {":green_heart:", "\xf0\x9f\x92\x9a"}, // 💚
    {":blue_heart:", "\xf0\x9f\x92\x99"}, // 💙
    {":purple_heart:", "\xf0\x9f\x92\x9c"}, // 💜
    {":brown_heart:", "\xf0\x9f\xa4\x8e"}, // 🤎
    {":black_heart:", "\xf0\x9f\x96\xa4"}, // 🖤
    {":white_heart:", "\xf0\x9f\xa4\x8d"}, // 🤍
    {":100:", "\xf0\x9f\x92\xaf"}, // 💯
    {":anger:", "\xf0\x9f\x92\xa2"}, // 💢
    {":boom:", "\xf0\x9f\x92\xa5"}, // 💥
    {":collision:", "\xf0\x9f\x92\xa5"}, // 💥
    {":dizzy:", "\xf0\x9f\x92\xab"}, // 💫
    {":sweat_drops:", "\xf0\x9f\x92\xa6"}, // 💦
    {":dash:", "\xf0\x9f\x92\xa8"}, // 💨
    {":hole:", "\xf0\x9f\x95\xb3\xef\xb8\x8f"}, // 🕳️
    {":bomb:", "\xf0\x9f\x92\xa3"}, // 💣
    {":speech_balloon:", "\xf0\x9f\x92\xac"}, // 💬
    {":eye_speech_bubble:", "\xf0\x9f\x91\x81\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x97\xa8\xef\xb8\x8f"}, // 👁️‍🗨️
    {":left_speech_bubble:", "\xf0\x9f\x97\xa8\xef\xb8\x8f"}, // 🗨️
    {":right_anger_bubble:", "\xf0\x9f\x97\xaf\xef\xb8\x8f"}, // 🗯️
    {":thought_balloon:", "\xf0\x9f\x92\xad"}, // 💭
    {":zzz:", "\xf0\x9f\x92\xa4"}, // 💤
    {":wave:", "\xf0\x9f\x91\x8b"}, // 👋
    {":raised_back_of_hand:", "\xf0\x9f\xa4\x9a"}, // 🤚
    {":raised_hand_with_fingers_splayed:", "\xf0\x9f\x96\x90\xef\xb8\x8f"}, // 🖐️
    {":hand:", "\xe2\x9c\x8b"}, // ✋
    {":raised_hand:", "\xe2\x9c\x8b"}, // ✋
    {":vulcan_salute:", "\xf0\x9f\x96\x96"}, // 🖖
    {":ok_hand:", "\xf0\x9f\x91\x8c"}, // 👌
    {":pinched_fingers:", "\xf0\x9f\xa4\x8c"}, // 🤌
    {":pinching_hand:", "\xf0\x9f\xa4\x8f"}, // 🤏
    {":v:", "\xe2\x9c\x8c\xef\xb8\x8f"}, // ✌️
    {":crossed_fingers:", "\xf0\x9f\xa4\x9e"}, // 🤞
    {":love_you_gesture:", "\xf0\x9f\xa4\x9f"}, // 🤟
    {":metal:", "\xf0\x9f\xa4\x98"}, // 🤘
    {":call_me_hand:", "\xf0\x9f\xa4\x99"}, // 🤙
    {":point_left:", "\xf0\x9f\x91\x88"}, // 👈
    {":point_right:", "\xf0\x9f\x91\x89"}, // 👉
    {":point_up_2:", "\xf0\x9f\x91\x86"}, // 👆
    {":middle_finger:", "\xf0\x9f\x96\x95"}, // 🖕
    {":fu:", "\xf0\x9f\x96\x95"}, // 🖕
    {":point_down:", "\xf0\x9f\x91\x87"}, // 👇
    {":point_up:", "\xe2\x98\x9d\xef\xb8\x8f"}, // ☝️
    {":+1:", "\xf0\x9f\x91\x8d"}, // 👍
    {":thumbsup:", "\xf0\x9f\x91\x8d"}, // 👍
    {":-1:", "\xf0\x9f\x91\x8e"}, // 👎
    {":thumbsdown:", "\xf0\x9f\x91\x8e"}, // 👎
    {":fist_raised:", "\xe2\x9c\x8a"}, // ✊
    {":fist:", "\xe2\x9c\x8a"}, // ✊
    {":fist_oncoming:", "\xf0\x9f\x91\x8a"}, // 👊
    {":facepunch:", "\xf0\x9f\x91\x8a"}, // 👊
    {":punch:", "\xf0\x9f\x91\x8a"}, // 👊
    {":fist_left:", "\xf0\x9f\xa4\x9b"}, // 🤛
    {":fist_right:", "\xf0\x9f\xa4\x9c"}, // 🤜
    {":clap:", "\xf0\x9f\x91\x8f"}, // 👏
    {":raised_hands:", "\xf0\x9f\x99\x8c"}, // 🙌
    {":open_hands:", "\xf0\x9f\x91\x90"}, // 👐
    {":palms_up_together:", "\xf0\x9f\xa4\xb2"}, // 🤲
    {":handshake:", "\xf0\x9f\xa4\x9d"}, // 🤝
    {":pray:", "\xf0\x9f\x99\x8f"}, // 🙏
    {":writing_hand:", "\xe2\x9c\x8d\xef\xb8\x8f"}, // ✍️
    {":nail_care:", "\xf0\x9f\x92\x85"}, // 💅
    {":selfie:", "\xf0\x9f\xa4\xb3"}, // 🤳
    {":muscle:", "\xf0\x9f\x92\xaa"}, // 💪
    {":mechanical_arm:", "\xf0\x9f\xa6\xbe"}, // 🦾
    {":mechanical_leg:", "\xf0\x9f\xa6\xbf"}, // 🦿
    {":leg:", "\xf0\x9f\xa6\xb5"}, // 🦵
    {":foot:", "\xf0\x9f\xa6\xb6"}, // 🦶
    {":ear:", "\xf0\x9f\x91\x82"}, // 👂
    {":ear_with_hearing_aid:", "\xf0\x9f\xa6\xbb"}, // 🦻
    {":nose:", "\xf0\x9f\x91\x83"}, // 👃
    {":brain:", "\xf0\x9f\xa7\xa0"}, // 🧠
    {":anatomical_heart:", "\xf0\x9f\xab\x80"}, // 🫀
    {":lungs:", "\xf0\x9f\xab\x81"}, // 🫁
    {":tooth:", "\xf0\x9f\xa6\xb7"}, // 🦷
    {":bone:", "\xf0\x9f\xa6\xb4"}, // 🦴
    {":eyes:", "\xf0\x9f\x91\x80"}, // 👀
    {":eye:", "\xf0\x9f\x91\x81\xef\xb8\x8f"}, // 👁️
    {":tongue:", "\xf0\x9f\x91\x85"}, // 👅
    {":lips:", "\xf0\x9f\x91\x84"}, // 👄
    {":baby:", "\xf0\x9f\x91\xb6"}, // 👶
    {":child:", "\xf0\x9f\xa7\x92"}, // 🧒
    {":boy:", "\xf0\x9f\x91\xa6"}, // 👦
    {":girl:", "\xf0\x9f\x91\xa7"}, // 👧
    {":adult:", "\xf0\x9f\xa7\x91"}, // 🧑
    {":blond_haired_person:", "\xf0\x9f\x91\xb1"}, // 👱
    {":man:", "\xf0\x9f\x91\xa8"}, // 👨
    {":bearded_person:", "\xf0\x9f\xa7\x94"}, // 🧔
    {":man_beard:", "\xf0\x9f\xa7\x94\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🧔‍♂️
    {":woman_beard:", "\xf0\x9f\xa7\x94\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🧔‍♀️
    {":red_haired_man:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\xa6\xb0"}, // 👨‍🦰
    {":curly_haired_man:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\xa6\xb1"}, // 👨‍🦱
    {":white_haired_man:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\xa6\xb3"}, // 👨‍🦳
    {":bald_man:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\xa6\xb2"}, // 👨‍🦲
    {":woman:", "\xf0\x9f\x91\xa9"}, // 👩
    {":red_haired_woman:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\xa6\xb0"}, // 👩‍🦰
    {":person_red_hair:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\xa6\xb0"}, // 🧑‍🦰
    {":curly_haired_woman:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\xa6\xb1"}, // 👩‍🦱
    {":person_curly_hair:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\xa6\xb1"}, // 🧑‍🦱
    {":white_haired_woman:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\xa6\xb3"}, // 👩‍🦳
    {":person_white_hair:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\xa6\xb3"}, // 🧑‍🦳
    {":bald_woman:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\xa6\xb2"}, // 👩‍🦲
    {":person_bald:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\xa6\xb2"}, // 🧑‍🦲
    {":blond_haired_woman:", "\xf0\x9f\x91\xb1\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 👱‍♀️
    {":blonde_woman:", "\xf0\x9f\x91\xb1\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 👱‍♀️
    {":blond_haired_man:", "\xf0\x9f\x91\xb1\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 👱‍♂️
    {":older_adult:", "\xf0\x9f\xa7\x93"}, // 🧓
    {":older_man:", "\xf0\x9f\x91\xb4"}, // 👴
    {":older_woman:", "\xf0\x9f\x91\xb5"}, // 👵
    {":frowning_person:", "\xf0\x9f\x99\x8d"}, // 🙍
    {":frowning_man:", "\xf0\x9f\x99\x8d\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🙍‍♂️
    {":frowning_woman:", "\xf0\x9f\x99\x8d\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🙍‍♀️
    {":pouting_face:", "\xf0\x9f\x99\x8e"}, // 🙎
    {":pouting_man:", "\xf0\x9f\x99\x8e\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🙎‍♂️
    {":pouting_woman:", "\xf0\x9f\x99\x8e\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🙎‍♀️
    {":no_good:", "\xf0\x9f\x99\x85"}, // 🙅
    {":no_good_man:", "\xf0\x9f\x99\x85\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🙅‍♂️
    {":ng_man:", "\xf0\x9f\x99\x85\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🙅‍♂️
    {":no_good_woman:", "\xf0\x9f\x99\x85\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🙅‍♀️
    {":ng_woman:", "\xf0\x9f\x99\x85\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🙅‍♀️
    {":ok_person:", "\xf0\x9f\x99\x86"}, // 🙆
    {":ok_man:", "\xf0\x9f\x99\x86\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🙆‍♂️
    {":ok_woman:", "\xf0\x9f\x99\x86\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🙆‍♀️
    {":tipping_hand_person:", "\xf0\x9f\x92\x81"}, // 💁
    {":information_desk_person:", "\xf0\x9f\x92\x81"}, // 💁
    {":tipping_hand_man:", "\xf0\x9f\x92\x81\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 💁‍♂️
    {":sassy_man:", "\xf0\x9f\x92\x81\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 💁‍♂️
    {":tipping_hand_woman:", "\xf0\x9f\x92\x81\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 💁‍♀️
    {":sassy_woman:", "\xf0\x9f\x92\x81\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 💁‍♀️
    {":raising_hand:", "\xf0\x9f\x99\x8b"}, // 🙋
    {":raising_hand_man:", "\xf0\x9f\x99\x8b\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🙋‍♂️
    {":raising_hand_woman:", "\xf0\x9f\x99\x8b\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🙋‍♀️
    {":deaf_person:", "\xf0\x9f\xa7\x8f"}, // 🧏
    {":deaf_man:", "\xf0\x9f\xa7\x8f\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🧏‍♂️
    {":deaf_woman:", "\xf0\x9f\xa7\x8f\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🧏‍♀️
    {":bow:", "\xf0\x9f\x99\x87"}, // 🙇
    {":bowing_man:", "\xf0\x9f\x99\x87\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🙇‍♂️
    {":bowing_woman:", "\xf0\x9f\x99\x87\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🙇‍♀️
    {":facepalm:", "\xf0\x9f\xa4\xa6"}, // 🤦
    {":man_facepalming:", "\xf0\x9f\xa4\xa6\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🤦‍♂️
    {":woman_facepalming:", "\xf0\x9f\xa4\xa6\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🤦‍♀️
    {":shrug:", "\xf0\x9f\xa4\xb7"}, // 🤷
    {":man_shrugging:", "\xf0\x9f\xa4\xb7\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🤷‍♂️
    {":woman_shrugging:", "\xf0\x9f\xa4\xb7\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🤷‍♀️
    {":health_worker:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xe2\x9a\x95\xef\xb8\x8f"}, // 🧑‍⚕️
    {":man_health_worker:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xe2\x9a\x95\xef\xb8\x8f"}, // 👨‍⚕️
    {":woman_health_worker:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9a\x95\xef\xb8\x8f"}, // 👩‍⚕️
    {":student:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x8e\x93"}, // 🧑‍🎓
    {":man_student:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x8e\x93"}, // 👨‍🎓
    {":woman_student:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x8e\x93"}, // 👩‍🎓
    {":teacher:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x8f\xab"}, // 🧑‍🏫
    {":man_teacher:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x8f\xab"}, // 👨‍🏫
    {":woman_teacher:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x8f\xab"}, // 👩‍🏫
    {":judge:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xe2\x9a\x96\xef\xb8\x8f"}, // 🧑‍⚖️
    {":man_judge:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xe2\x9a\x96\xef\xb8\x8f"}, // 👨‍⚖️
    {":woman_judge:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9a\x96\xef\xb8\x8f"}, // 👩‍⚖️
    {":farmer:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x8c\xbe"}, // 🧑‍🌾
    {":man_farmer:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x8c\xbe"}, // 👨‍🌾
    {":woman_farmer:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x8c\xbe"}, // 👩‍🌾
    {":cook:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x8d\xb3"}, // 🧑‍🍳
    {":man_cook:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x8d\xb3"}, // 👨‍🍳
    {":woman_cook:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x8d\xb3"}, // 👩‍🍳
    {":mechanic:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x94\xa7"}, // 🧑‍🔧
    {":man_mechanic:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x94\xa7"}, // 👨‍🔧
    {":woman_mechanic:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x94\xa7"}, // 👩‍🔧
    {":factory_worker:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x8f\xad"}, // 🧑‍🏭
    {":man_factory_worker:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x8f\xad"}, // 👨‍🏭
    {":woman_factory_worker:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x8f\xad"}, // 👩‍🏭
    {":office_worker:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x92\xbc"}, // 🧑‍💼
    {":man_office_worker:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x92\xbc"}, // 👨‍💼
    {":woman_office_worker:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x92\xbc"}, // 👩‍💼
    {":scientist:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x94\xac"}, // 🧑‍🔬
    {":man_scientist:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x94\xac"}, // 👨‍🔬
    {":woman_scientist:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x94\xac"}, // 👩‍🔬
    {":technologist:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x92\xbb"}, // 🧑‍💻
    {":man_technologist:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x92\xbb"}, // 👨‍💻
    {":woman_technologist:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x92\xbb"}, // 👩‍💻
    {":singer:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x8e\xa4"}, // 🧑‍🎤
    {":man_singer:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x8e\xa4"}, // 👨‍🎤
    {":woman_singer:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x8e\xa4"}, // 👩‍🎤
    {":artist:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x8e\xa8"}, // 🧑‍🎨
    {":man_artist:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x8e\xa8"}, // 👨‍🎨
    {":woman_artist:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x8e\xa8"}, // 👩‍🎨
    {":pilot:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xe2\x9c\x88\xef\xb8\x8f"}, // 🧑‍✈️
    {":man_pilot:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xe2\x9c\x88\xef\xb8\x8f"}, // 👨‍✈️
    {":woman_pilot:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9c\x88\xef\xb8\x8f"}, // 👩‍✈️
    {":astronaut:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x9a\x80"}, // 🧑‍🚀
    {":man_astronaut:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x9a\x80"}, // 👨‍🚀
    {":woman_astronaut:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x9a\x80"}, // 👩‍🚀
    {":firefighter:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x9a\x92"}, // 🧑‍🚒
    {":man_firefighter:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x9a\x92"}, // 👨‍🚒
    {":woman_firefighter:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x9a\x92"}, // 👩‍🚒
    {":police_officer:", "\xf0\x9f\x91\xae"}, // 👮
    {":cop:", "\xf0\x9f\x91\xae"}, // 👮
    {":policeman:", "\xf0\x9f\x91\xae\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 👮‍♂️
    {":policewoman:", "\xf0\x9f\x91\xae\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 👮‍♀️
    {":detective:", "\xf0\x9f\x95\xb5\xef\xb8\x8f"}, // 🕵️
    {":male_detective:", "\xf0\x9f\x95\xb5\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🕵️‍♂️
    {":female_detective:", "\xf0\x9f\x95\xb5\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🕵️‍♀️
    {":guard:", "\xf0\x9f\x92\x82"}, // 💂
    {":guardsman:", "\xf0\x9f\x92\x82\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 💂‍♂️
    {":guardswoman:", "\xf0\x9f\x92\x82\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 💂‍♀️
    {":ninja:", "\xf0\x9f\xa5\xb7"}, // 🥷
    {":construction_worker:", "\xf0\x9f\x91\xb7"}, // 👷
    {":construction_worker_man:", "\xf0\x9f\x91\xb7\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 👷‍♂️
    {":construction_worker_woman:", "\xf0\x9f\x91\xb7\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 👷‍♀️
    {":prince:", "\xf0\x9f\xa4\xb4"}, // 🤴
    {":princess:", "\xf0\x9f\x91\xb8"}, // 👸
    {":person_with_turban:", "\xf0\x9f\x91\xb3"}, // 👳
    {":man_with_turban:", "\xf0\x9f\x91\xb3\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 👳‍♂️
    {":woman_with_turban:", "\xf0\x9f\x91\xb3\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 👳‍♀️
    {":man_with_gua_pi_mao:", "\xf0\x9f\x91\xb2"}, // 👲
    {":woman_with_headscarf:", "\xf0\x9f\xa7\x95"}, // 🧕
    {":person_in_tuxedo:", "\xf0\x9f\xa4\xb5"}, // 🤵
    {":man_in_tuxedo:", "\xf0\x9f\xa4\xb5\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🤵‍♂️
    {":woman_in_tuxedo:", "\xf0\x9f\xa4\xb5\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🤵‍♀️
    {":person_with_veil:", "\xf0\x9f\x91\xb0"}, // 👰
    {":man_with_veil:", "\xf0\x9f\x91\xb0\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 👰‍♂️
    {":woman_with_veil:", "\xf0\x9f\x91\xb0\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 👰‍♀️
    {":bride_with_veil:", "\xf0\x9f\x91\xb0\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 👰‍♀️
    {":pregnant_woman:", "\xf0\x9f\xa4\xb0"}, // 🤰
    {":breast_feeding:", "\xf0\x9f\xa4\xb1"}, // 🤱
    {":woman_feeding_baby:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x8d\xbc"}, // 👩‍🍼
    {":man_feeding_baby:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x8d\xbc"}, // 👨‍🍼
    {":person_feeding_baby:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x8d\xbc"}, // 🧑‍🍼
    {":angel:", "\xf0\x9f\x91\xbc"}, // 👼
    {":santa:", "\xf0\x9f\x8e\x85"}, // 🎅
    {":mrs_claus:", "\xf0\x9f\xa4\xb6"}, // 🤶
    {":mx_claus:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\x8e\x84"}, // 🧑‍🎄
    {":superhero:", "\xf0\x9f\xa6\xb8"}, // 🦸
    {":superhero_man:", "\xf0\x9f\xa6\xb8\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🦸‍♂️
    {":superhero_woman:", "\xf0\x9f\xa6\xb8\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🦸‍♀️
    {":supervillain:", "\xf0\x9f\xa6\xb9"}, // 🦹
    {":supervillain_man:", "\xf0\x9f\xa6\xb9\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🦹‍♂️
    {":supervillain_woman:", "\xf0\x9f\xa6\xb9\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🦹‍♀️
    {":mage:", "\xf0\x9f\xa7\x99"}, // 🧙
    {":mage_man:", "\xf0\x9f\xa7\x99\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🧙‍♂️
    {":mage_woman:", "\xf0\x9f\xa7\x99\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🧙‍♀️
    {":fairy:", "\xf0\x9f\xa7\x9a"}, // 🧚
    {":fairy_man:", "\xf0\x9f\xa7\x9a\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🧚‍♂️
    {":fairy_woman:", "\xf0\x9f\xa7\x9a\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🧚‍♀️
    {":vampire:", "\xf0\x9f\xa7\x9b"}, // 🧛
    {":vampire_man:", "\xf0\x9f\xa7\x9b\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🧛‍♂️
    {":vampire_woman:", "\xf0\x9f\xa7\x9b\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🧛‍♀️
    {":merperson:", "\xf0\x9f\xa7\x9c"}, // 🧜
    {":merman:", "\xf0\x9f\xa7\x9c\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🧜‍♂️
    {":mermaid:", "\xf0\x9f\xa7\x9c\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🧜‍♀️
    {":elf:", "\xf0\x9f\xa7\x9d"}, // 🧝
    {":elf_man:", "\xf0\x9f\xa7\x9d\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🧝‍♂️
    {":elf_woman:", "\xf0\x9f\xa7\x9d\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🧝‍♀️
    {":genie:", "\xf0\x9f\xa7\x9e"}, // 🧞
    {":genie_man:", "\xf0\x9f\xa7\x9e\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🧞‍♂️
    {":genie_woman:", "\xf0\x9f\xa7\x9e\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🧞‍♀️
    {":zombie:", "\xf0\x9f\xa7\x9f"}, // 🧟
    {":zombie_man:", "\xf0\x9f\xa7\x9f\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🧟‍♂️
    {":zombie_woman:", "\xf0\x9f\xa7\x9f\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🧟‍♀️
    {":massage:", "\xf0\x9f\x92\x86"}, // 💆
    {":massage_man:", "\xf0\x9f\x92\x86\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 💆‍♂️
    {":massage_woman:", "\xf0\x9f\x92\x86\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 💆‍♀️
    {":haircut:", "\xf0\x9f\x92\x87"}, // 💇
    {":haircut_man:", "\xf0\x9f\x92\x87\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 💇‍♂️
    {":haircut_woman:", "\xf0\x9f\x92\x87\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 💇‍♀️
    {":walking:", "\xf0\x9f\x9a\xb6"}, // 🚶
    {":walking_man:", "\xf0\x9f\x9a\xb6\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🚶‍♂️
    {":walking_woman:", "\xf0\x9f\x9a\xb6\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🚶‍♀️
    {":standing_person:", "\xf0\x9f\xa7\x8d"}, // 🧍
    {":standing_man:", "\xf0\x9f\xa7\x8d\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🧍‍♂️
    {":standing_woman:", "\xf0\x9f\xa7\x8d\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🧍‍♀️
    {":kneeling_person:", "\xf0\x9f\xa7\x8e"}, // 🧎
    {":kneeling_man:", "\xf0\x9f\xa7\x8e\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🧎‍♂️
    {":kneeling_woman:", "\xf0\x9f\xa7\x8e\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🧎‍♀️
    {":person_with_probing_cane:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\xa6\xaf"}, // 🧑‍🦯
    {":man_with_probing_cane:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\xa6\xaf"}, // 👨‍🦯
    {":woman_with_probing_cane:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\xa6\xaf"}, // 👩‍🦯
    {":person_in_motorized_wheelchair:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\xa6\xbc"}, // 🧑‍🦼
    {":man_in_motorized_wheelchair:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\xa6\xbc"}, // 👨‍🦼
    {":woman_in_motorized_wheelchair:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\xa6\xbc"}, // 👩‍🦼
    {":person_in_manual_wheelchair:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\xa6\xbd"}, // 🧑‍🦽
    {":man_in_manual_wheelchair:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\xa6\xbd"}, // 👨‍🦽
    {":woman_in_manual_wheelchair:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\xa6\xbd"}, // 👩‍🦽
    {":runner:", "\xf0\x9f\x8f\x83"}, // 🏃
    {":running:", "\xf0\x9f\x8f\x83"}, // 🏃
    {":running_man:", "\xf0\x9f\x8f\x83\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🏃‍♂️
    {":running_woman:", "\xf0\x9f\x8f\x83\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🏃‍♀️
    {":woman_dancing:", "\xf0\x9f\x92\x83"}, // 💃
    {":dancer:", "\xf0\x9f\x92\x83"}, // 💃
    {":man_dancing:", "\xf0\x9f\x95\xba"}, // 🕺
    {":business_suit_levitating:", "\xf0\x9f\x95\xb4\xef\xb8\x8f"}, // 🕴️
    {":dancers:", "\xf0\x9f\x91\xaf"}, // 👯
    {":dancing_men:", "\xf0\x9f\x91\xaf\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 👯‍♂️
    {":dancing_women:", "\xf0\x9f\x91\xaf\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 👯‍♀️
    {":sauna_person:", "\xf0\x9f\xa7\x96"}, // 🧖
    {":sauna_man:", "\xf0\x9f\xa7\x96\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🧖‍♂️
    {":sauna_woman:", "\xf0\x9f\xa7\x96\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🧖‍♀️
    {":climbing:", "\xf0\x9f\xa7\x97"}, // 🧗
    {":climbing_man:", "\xf0\x9f\xa7\x97\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🧗‍♂️
    {":climbing_woman:", "\xf0\x9f\xa7\x97\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🧗‍♀️
    {":person_fencing:", "\xf0\x9f\xa4\xba"}, // 🤺
    {":horse_racing:", "\xf0\x9f\x8f\x87"}, // 🏇
    {":skier:", "\xe2\x9b\xb7\xef\xb8\x8f"}, // ⛷️
    {":snowboarder:", "\xf0\x9f\x8f\x82"}, // 🏂
    {":golfing:", "\xf0\x9f\x8f\x8c\xef\xb8\x8f"}, // 🏌️
    {":golfing_man:", "\xf0\x9f\x8f\x8c\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🏌️‍♂️
    {":golfing_woman:", "\xf0\x9f\x8f\x8c\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🏌️‍♀️
    {":surfer:", "\xf0\x9f\x8f\x84"}, // 🏄
    {":surfing_man:", "\xf0\x9f\x8f\x84\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🏄‍♂️
    {":surfing_woman:", "\xf0\x9f\x8f\x84\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🏄‍♀️
    {":rowboat:", "\xf0\x9f\x9a\xa3"}, // 🚣
    {":rowing_man:", "\xf0\x9f\x9a\xa3\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🚣‍♂️
    {":rowing_woman:", "\xf0\x9f\x9a\xa3\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🚣‍♀️
    {":swimmer:", "\xf0\x9f\x8f\x8a"}, // 🏊
    {":swimming_man:", "\xf0\x9f\x8f\x8a\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🏊‍♂️
    {":swimming_woman:", "\xf0\x9f\x8f\x8a\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🏊‍♀️
    {":bouncing_ball_person:", "\xe2\x9b\xb9\xef\xb8\x8f"}, // ⛹️
    {":bouncing_ball_man:", "\xe2\x9b\xb9\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // ⛹️‍♂️
    {":basketball_man:", "\xe2\x9b\xb9\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // ⛹️‍♂️
    {":bouncing_ball_woman:", "\xe2\x9b\xb9\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // ⛹️‍♀️
    {":basketball_woman:", "\xe2\x9b\xb9\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // ⛹️‍♀️
    {":weight_lifting:", "\xf0\x9f\x8f\x8b\xef\xb8\x8f"}, // 🏋️
    {":weight_lifting_man:", "\xf0\x9f\x8f\x8b\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🏋️‍♂️
    {":weight_lifting_woman:", "\xf0\x9f\x8f\x8b\xef\xb8\x8f\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🏋️‍♀️
    {":bicyclist:", "\xf0\x9f\x9a\xb4"}, // 🚴
    {":biking_man:", "\xf0\x9f\x9a\xb4\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🚴‍♂️
    {":biking_woman:", "\xf0\x9f\x9a\xb4\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🚴‍♀️
    {":mountain_bicyclist:", "\xf0\x9f\x9a\xb5"}, // 🚵
    {":mountain_biking_man:", "\xf0\x9f\x9a\xb5\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🚵‍♂️
    {":mountain_biking_woman:", "\xf0\x9f\x9a\xb5\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🚵‍♀️
    {":cartwheeling:", "\xf0\x9f\xa4\xb8"}, // 🤸
    {":man_cartwheeling:", "\xf0\x9f\xa4\xb8\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🤸‍♂️
    {":woman_cartwheeling:", "\xf0\x9f\xa4\xb8\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🤸‍♀️
    {":wrestling:", "\xf0\x9f\xa4\xbc"}, // 🤼
    {":men_wrestling:", "\xf0\x9f\xa4\xbc\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🤼‍♂️
    {":women_wrestling:", "\xf0\x9f\xa4\xbc\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🤼‍♀️
    {":water_polo:", "\xf0\x9f\xa4\xbd"}, // 🤽
    {":man_playing_water_polo:", "\xf0\x9f\xa4\xbd\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🤽‍♂️
    {":woman_playing_water_polo:", "\xf0\x9f\xa4\xbd\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🤽‍♀️
    {":handball_person:", "\xf0\x9f\xa4\xbe"}, // 🤾
    {":man_playing_handball:", "\xf0\x9f\xa4\xbe\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🤾‍♂️
    {":woman_playing_handball:", "\xf0\x9f\xa4\xbe\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🤾‍♀️
    {":juggling_person:", "\xf0\x9f\xa4\xb9"}, // 🤹
    {":man_juggling:", "\xf0\x9f\xa4\xb9\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🤹‍♂️
    {":woman_juggling:", "\xf0\x9f\xa4\xb9\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🤹‍♀️
    {":lotus_position:", "\xf0\x9f\xa7\x98"}, // 🧘
    {":lotus_position_man:", "\xf0\x9f\xa7\x98\xe2\x80\x8d\xe2\x99\x82\xef\xb8\x8f"}, // 🧘‍♂️
    {":lotus_position_woman:", "\xf0\x9f\xa7\x98\xe2\x80\x8d\xe2\x99\x80\xef\xb8\x8f"}, // 🧘‍♀️
    {":bath:", "\xf0\x9f\x9b\x80"}, // 🛀
    {":sleeping_bed:", "\xf0\x9f\x9b\x8c"}, // 🛌
    {":people_holding_hands:", "\xf0\x9f\xa7\x91\xe2\x80\x8d\xf0\x9f\xa4\x9d\xe2\x80\x8d\xf0\x9f\xa7\x91"}, // 🧑‍🤝‍🧑
    {":two_women_holding_hands:", "\xf0\x9f\x91\xad"}, // 👭
    {":couple:", "\xf0\x9f\x91\xab"}, // 👫
    {":two_men_holding_hands:", "\xf0\x9f\x91\xac"}, // 👬
    {":couplekiss:", "\xf0\x9f\x92\x8f"}, // 💏
    {":couplekiss_man_woman:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9d\xa4\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x92\x8b\xe2\x80\x8d\xf0\x9f\x91\xa8"}, // 👩‍❤️‍💋‍👨
    {":couplekiss_man_man:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xe2\x9d\xa4\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x92\x8b\xe2\x80\x8d\xf0\x9f\x91\xa8"}, // 👨‍❤️‍💋‍👨
    {":couplekiss_woman_woman:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9d\xa4\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x92\x8b\xe2\x80\x8d\xf0\x9f\x91\xa9"}, // 👩‍❤️‍💋‍👩
    {":couple_with_heart:", "\xf0\x9f\x92\x91"}, // 💑
    {":couple_with_heart_woman_man:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9d\xa4\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x91\xa8"}, // 👩‍❤️‍👨
    {":couple_with_heart_man_man:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xe2\x9d\xa4\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x91\xa8"}, // 👨‍❤️‍👨
    {":couple_with_heart_woman_woman:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xe2\x9d\xa4\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x91\xa9"}, // 👩‍❤️‍👩
    {":family:", "\xf0\x9f\x91\xaa"}, // 👪
    {":family_man_woman_boy:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa6"}, // 👨‍👩‍👦
    {":family_man_woman_girl:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7"}, // 👨‍👩‍👧
    {":family_man_woman_girl_boy:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa6"}, // 👨‍👩‍👧‍👦
    {":family_man_woman_boy_boy:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa6\xe2\x80\x8d\xf0\x9f\x91\xa6"}, // 👨‍👩‍👦‍👦
    {":family_man_woman_girl_girl:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa7"}, // 👨‍👩‍👧‍👧
    {":family_man_man_boy:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa6"}, // 👨‍👨‍👦
    {":family_man_man_girl:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa7"}, // 👨‍👨‍👧
    {":family_man_man_girl_boy:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa6"}, // 👨‍👨‍👧‍👦
    {":family_man_man_boy_boy:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa6\xe2\x80\x8d\xf0\x9f\x91\xa6"}, // 👨‍👨‍👦‍👦
    {":family_man_man_girl_girl:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa7"}, // 👨‍👨‍👧‍👧
    {":family_woman_woman_boy:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa6"}, // 👩‍👩‍👦
    {":family_woman_woman_girl:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7"}, // 👩‍👩‍👧
    {":family_woman_woman_girl_boy:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa6"}, // 👩‍👩‍👧‍👦
    {":family_woman_woman_boy_boy:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa6\xe2\x80\x8d\xf0\x9f\x91\xa6"}, // 👩‍👩‍👦‍👦
    {":family_woman_woman_girl_girl:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa7"}, // 👩‍👩‍👧‍👧
    {":family_man_boy:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa6"}, // 👨‍👦
    {":family_man_boy_boy:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa6\xe2\x80\x8d\xf0\x9f\x91\xa6"}, // 👨‍👦‍👦
    {":family_man_girl:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa7"}, // 👨‍👧
    {":family_man_girl_boy:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa6"}, // 👨‍👧‍👦
    {":family_man_girl_girl:", "\xf0\x9f\x91\xa8\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa7"}, // 👨‍👧‍👧
    {":family_woman_boy:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa6"}, // 👩‍👦
    {":family_woman_boy_boy:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa6\xe2\x80\x8d\xf0\x9f\x91\xa6"}, // 👩‍👦‍👦
    {":family_woman_girl:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7"}, // 👩‍👧
    {":family_woman_girl_boy:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa6"}, // 👩‍👧‍👦
    {":family_woman_girl_girl:", "\xf0\x9f\x91\xa9\xe2\x80\x8d\xf0\x9f\x91\xa7\xe2\x80\x8d\xf0\x9f\x91\xa7"}, // 👩‍👧‍👧
    {":speaking_head:", "\xf0\x9f\x97\xa3\xef\xb8\x8f"}, // 🗣️
    {":bust_in_silhouette:", "\xf0\x9f\x91\xa4"}, // 👤
    {":busts_in_silhouette:", "\xf0\x9f\x91\xa5"}, // 👥
    {":people_hugging:", "\xf0\x9f\xab\x82"}, // 🫂
    {":footprints:", "\xf0\x9f\x91\xa3"}, // 👣
    {":monkey_face:", "\xf0\x9f\x90\xb5"}, // 🐵
    {":monkey:", "\xf0\x9f\x90\x92"}, // 🐒
    {":gorilla:", "\xf0\x9f\xa6\x8d"}, // 🦍
    {":orangutan:", "\xf0\x9f\xa6\xa7"}, // 🦧
    {":dog:", "\xf0\x9f\x90\xb6"}, // 🐶
    {":dog2:", "\xf0\x9f\x90\x95"}, // 🐕
    {":guide_dog:", "\xf0\x9f\xa6\xae"}, // 🦮
    {":service_dog:", "\xf0\x9f\x90\x95\xe2\x80\x8d\xf0\x9f\xa6\xba"}, // 🐕‍🦺
    {":poodle:", "\xf0\x9f\x90\xa9"}, // 🐩
    {":wolf:", "\xf0\x9f\x90\xba"}, // 🐺
    {":fox_face:", "\xf0\x9f\xa6\x8a"}, // 🦊
    {":raccoon:", "\xf0\x9f\xa6\x9d"}, // 🦝
    {":cat:", "\xf0\x9f\x90\xb1"}, // 🐱
    {":cat2:", "\xf0\x9f\x90\x88"}, // 🐈
    {":black_cat:", "\xf0\x9f\x90\x88\xe2\x80\x8d\xe2\xac\x9b"}, // 🐈‍⬛
    {":lion:", "\xf0\x9f\xa6\x81"}, // 🦁
    {":tiger:", "\xf0\x9f\x90\xaf"}, // 🐯
    {":tiger2:", "\xf0\x9f\x90\x85"}, // 🐅
    {":leopard:", "\xf0\x9f\x90\x86"}, // 🐆
    {":horse:", "\xf0\x9f\x90\xb4"}, // 🐴
    {":racehorse:", "\xf0\x9f\x90\x8e"}, // 🐎
    {":unicorn:", "\xf0\x9f\xa6\x84"}, // 🦄
    {":zebra:", "\xf0\x9f\xa6\x93"}, // 🦓
    {":deer:", "\xf0\x9f\xa6\x8c"}, // 🦌
    {":bison:", "\xf0\x9f\xa6\xac"}, // 🦬
    {":cow:", "\xf0\x9f\x90\xae"}, // 🐮
    {":ox:", "\xf0\x9f\x90\x82"}, // 🐂
    {":water_buffalo:", "\xf0\x9f\x90\x83"}, // 🐃
    {":cow2:", "\xf0\x9f\x90\x84"}, // 🐄
    {":pig:", "\xf0\x9f\x90\xb7"}, // 🐷
    {":pig2:", "\xf0\x9f\x90\x96"}, // 🐖
    {":boar:", "\xf0\x9f\x90\x97"}, // 🐗
    {":pig_nose:", "\xf0\x9f\x90\xbd"}, // 🐽
    {":ram:", "\xf0\x9f\x90\x8f"}, // 🐏
    {":sheep:", "\xf0\x9f\x90\x91"}, // 🐑
    {":goat:", "\xf0\x9f\x90\x90"}, // 🐐
    {":dromedary_camel:", "\xf0\x9f\x90\xaa"}, // 🐪
    {":camel:", "\xf0\x9f\x90\xab"}, // 🐫
    {":llama:", "\xf0\x9f\xa6\x99"}, // 🦙
    {":giraffe:", "\xf0\x9f\xa6\x92"}, // 🦒
    {":elephant:", "\xf0\x9f\x90\x98"}, // 🐘
    {":mammoth:", "\xf0\x9f\xa6\xa3"}, // 🦣
    {":rhinoceros:", "\xf0\x9f\xa6\x8f"}, // 🦏
    {":hippopotamus:", "\xf0\x9f\xa6\x9b"}, // 🦛
    {":mouse:", "\xf0\x9f\x90\xad"}, // 🐭
    {":mouse2:", "\xf0\x9f\x90\x81"}, // 🐁
    {":rat:", "\xf0\x9f\x90\x80"}, // 🐀
    {":hamster:", "\xf0\x9f\x90\xb9"}, // 🐹
    {":rabbit:", "\xf0\x9f\x90\xb0"}, // 🐰
    {":rabbit2:", "\xf0\x9f\x90\x87"}, // 🐇
    {":chipmunk:", "\xf0\x9f\x90\xbf\xef\xb8\x8f"}, // 🐿️
    {":beaver:", "\xf0\x9f\xa6\xab"}, // 🦫
    {":hedgehog:", "\xf0\x9f\xa6\x94"}, // 🦔
    {":bat:", "\xf0\x9f\xa6\x87"}, // 🦇
    {":bear:", "\xf0\x9f\x90\xbb"}, // 🐻
    {":polar_bear:", "\xf0\x9f\x90\xbb\xe2\x80\x8d\xe2\x9d\x84\xef\xb8\x8f"}, // 🐻‍❄️
    {":koala:", "\xf0\x9f\x90\xa8"}, // 🐨
    {":panda_face:", "\xf0\x9f\x90\xbc"}, // 🐼
    {":sloth:", "\xf0\x9f\xa6\xa5"}, // 🦥
    {":otter:", "\xf0\x9f\xa6\xa6"}, // 🦦
    {":skunk:", "\xf0\x9f\xa6\xa8"}, // 🦨
    {":kangaroo:", "\xf0\x9f\xa6\x98"}, // 🦘
    {":badger:", "\xf0\x9f\xa6\xa1"}, // 🦡
    {":feet:", "\xf0\x9f\x90\xbe"}, // 🐾
    {":paw_prints:", "\xf0\x9f\x90\xbe"}, // 🐾
    {":turkey:", "\xf0\x9f\xa6\x83"}, // 🦃
    {":chicken:", "\xf0\x9f\x90\x94"}, // 🐔
    {":rooster:", "\xf0\x9f\x90\x93"}, // 🐓
    {":hatching_chick:", "\xf0\x9f\x90\xa3"}, // 🐣
    {":baby_chick:", "\xf0\x9f\x90\xa4"}, // 🐤
    {":hatched_chick:", "\xf0\x9f\x90\xa5"}, // 🐥
    {":bird:", "\xf0\x9f\x90\xa6"}, // 🐦
    {":penguin:", "\xf0\x9f\x90\xa7"}, // 🐧
    {":dove:", "\xf0\x9f\x95\x8a\xef\xb8\x8f"}, // 🕊️
    {":eagle:", "\xf0\x9f\xa6\x85"}, // 🦅
    {":duck:", "\xf0\x9f\xa6\x86"}, // 🦆
    {":swan:", "\xf0\x9f\xa6\xa2"}, // 🦢
    {":owl:", "\xf0\x9f\xa6\x89"}, // 🦉
    {":dodo:", "\xf0\x9f\xa6\xa4"}, // 🦤
    {":feather:", "\xf0\x9f\xaa\xb6"}, // 🪶
    {":flamingo:", "\xf0\x9f\xa6\xa9"}, // 🦩
    {":peacock:", "\xf0\x9f\xa6\x9a"}, // 🦚
    {":parrot:", "\xf0\x9f\xa6\x9c"}, // 🦜
    {":frog:", "\xf0\x9f\x90\xb8"}, // 🐸
    {":crocodile:", "\xf0\x9f\x90\x8a"}, // 🐊
    {":turtle:", "\xf0\x9f\x90\xa2"}, // 🐢
    {":lizard:", "\xf0\x9f\xa6\x8e"}, // 🦎
    {":snake:", "\xf0\x9f\x90\x8d"}, // 🐍
    {":dragon_face:", "\xf0\x9f\x90\xb2"}, // 🐲
    {":dragon:", "\xf0\x9f\x90\x89"}, // 🐉
    {":sauropod:", "\xf0\x9f\xa6\x95"}, // 🦕
    {":t-rex:", "\xf0\x9f\xa6\x96"}, // 🦖
    {":whale:", "\xf0\x9f\x90\xb3"}, // 🐳
    {":whale2:", "\xf0\x9f\x90\x8b"}, // 🐋
    {":dolphin:", "\xf0\x9f\x90\xac"}, // 🐬
    {":flipper:", "\xf0\x9f\x90\xac"}, // 🐬
    {":seal:", "\xf0\x9f\xa6\xad"}, // 🦭
    {":fish:", "\xf0\x9f\x90\x9f"}, // 🐟
    {":tropical_fish:", "\xf0\x9f\x90\xa0"}, // 🐠
    {":blowfish:", "\xf0\x9f\x90\xa1"}, // 🐡
    {":shark:", "\xf0\x9f\xa6\x88"}, // 🦈
    {":octopus:", "\xf0\x9f\x90\x99"}, // 🐙
    {":shell:", "\xf0\x9f\x90\x9a"}, // 🐚
    {":snail:", "\xf0\x9f\x90\x8c"}, // 🐌
    {":butterfly:", "\xf0\x9f\xa6\x8b"}, // 🦋
    {":bug:", "\xf0\x9f\x90\x9b"}, // 🐛
    {":ant:", "\xf0\x9f\x90\x9c"}, // 🐜
    {":bee:", "\xf0\x9f\x90\x9d"}, // 🐝
    {":honeybee:", "\xf0\x9f\x90\x9d"}, // 🐝
    {":beetle:", "\xf0\x9f\xaa\xb2"}, // 🪲
    {":lady_beetle:", "\xf0\x9f\x90\x9e"}, // 🐞
    {":cricket:", "\xf0\x9f\xa6\x97"}, // 🦗
    {":cockroach:", "\xf0\x9f\xaa\xb3"}, // 🪳
    {":spider:", "\xf0\x9f\x95\xb7\xef\xb8\x8f"}, // 🕷️
    {":spider_web:", "\xf0\x9f\x95\xb8\xef\xb8\x8f"}, // 🕸️
    {":scorpion:", "\xf0\x9f\xa6\x82"}, // 🦂
    {":mosquito:", "\xf0\x9f\xa6\x9f"}, // 🦟
    {":fly:", "\xf0\x9f\xaa\xb0"}, // 🪰
    {":worm:", "\xf0\x9f\xaa\xb1"}, // 🪱
    {":microbe:", "\xf0\x9f\xa6\xa0"}, // 🦠
    {":bouquet:", "\xf0\x9f\x92\x90"}, // 💐
    {":cherry_blossom:", "\xf0\x9f\x8c\xb8"}, // 🌸
    {":white_flower:", "\xf0\x9f\x92\xae"}, // 💮
    {":rosette:", "\xf0\x9f\x8f\xb5\xef\xb8\x8f"}, // 🏵️
    {":rose:", "\xf0\x9f\x8c\xb9"}, // 🌹
    {":wilted_flower:", "\xf0\x9f\xa5\x80"}, // 🥀
    {":hibiscus:", "\xf0\x9f\x8c\xba"}, // 🌺
    {":sunflower:", "\xf0\x9f\x8c\xbb"}, // 🌻
    {":blossom:", "\xf0\x9f\x8c\xbc"}, // 🌼
    {":tulip:", "\xf0\x9f\x8c\xb7"}, // 🌷
    {":seedling:", "\xf0\x9f\x8c\xb1"}, // 🌱
    {":potted_plant:", "\xf0\x9f\xaa\xb4"}, // 🪴
    {":evergreen_tree:", "\xf0\x9f\x8c\xb2"}, // 🌲
    {":deciduous_tree:", "\xf0\x9f\x8c\xb3"}, // 🌳
    {":palm_tree:", "\xf0\x9f\x8c\xb4"}, // 🌴
    {":cactus:", "\xf0\x9f\x8c\xb5"}, // 🌵
    {":ear_of_rice:", "\xf0\x9f\x8c\xbe"}, // 🌾
    {":herb:", "\xf0\x9f\x8c\xbf"}, // 🌿
    {":shamrock:", "\xe2\x98\x98\xef\xb8\x8f"}, // ☘️
    {":four_leaf_clover:", "\xf0\x9f\x8d\x80"}, // 🍀
    {":maple_leaf:", "\xf0\x9f\x8d\x81"}, // 🍁
    {":fallen_leaf:", "\xf0\x9f\x8d\x82"}, // 🍂
    {":leaves:", "\xf0\x9f\x8d\x83"}, // 🍃
    {":grapes:", "\xf0\x9f\x8d\x87"}, // 🍇
    {":melon:", "\xf0\x9f\x8d\x88"}, // 🍈
    {":watermelon:", "\xf0\x9f\x8d\x89"}, // 🍉
    {":tangerine:", "\xf0\x9f\x8d\x8a"}, // 🍊
    {":orange:", "\xf0\x9f\x8d\x8a"}, // 🍊
    {":mandarin:", "\xf0\x9f\x8d\x8a"}, // 🍊
    {":lemon:", "\xf0\x9f\x8d\x8b"}, // 🍋
    {":banana:", "\xf0\x9f\x8d\x8c"}, // 🍌
    {":pineapple:", "\xf0\x9f\x8d\x8d"}, // 🍍
    {":mango:", "\xf0\x9f\xa5\xad"}, // 🥭
    {":apple:", "\xf0\x9f\x8d\x8e"}, // 🍎
    {":green_apple:", "\xf0\x9f\x8d\x8f"}, // 🍏
    {":pear:", "\xf0\x9f\x8d\x90"}, // 🍐
    {":peach:", "\xf0\x9f\x8d\x91"}, // 🍑
    {":cherries:", "\xf0\x9f\x8d\x92"}, // 🍒
    {":strawberry:", "\xf0\x9f\x8d\x93"}, // 🍓
    {":blueberries:", "\xf0\x9f\xab\x90"}, // 🫐
    {":kiwi_fruit:", "\xf0\x9f\xa5\x9d"}, // 🥝
    {":tomato:", "\xf0\x9f\x8d\x85"}, // 🍅
    {":olive:", "\xf0\x9f\xab\x92"}, // 🫒
    {":coconut:", "\xf0\x9f\xa5\xa5"}, // 🥥
    {":avocado:", "\xf0\x9f\xa5\x91"}, // 🥑
    {":eggplant:", "\xf0\x9f\x8d\x86"}, // 🍆
    {":potato:", "\xf0\x9f\xa5\x94"}, // 🥔
    {":carrot:", "\xf0\x9f\xa5\x95"}, // 🥕
    {":corn:", "\xf0\x9f\x8c\xbd"}, // 🌽
    {":hot_pepper:", "\xf0\x9f\x8c\xb6\xef\xb8\x8f"}, // 🌶️
    {":bell_pepper:", "\xf0\x9f\xab\x91"}, // 🫑
    {":cucumber:", "\xf0\x9f\xa5\x92"}, // 🥒
    {":leafy_green:", "\xf0\x9f\xa5\xac"}, // 🥬
    {":broccoli:", "\xf0\x9f\xa5\xa6"}, // 🥦
    {":garlic:", "\xf0\x9f\xa7\x84"}, // 🧄
    {":onion:", "\xf0\x9f\xa7\x85"}, // 🧅
    {":mushroom:", "\xf0\x9f\x8d\x84"}, // 🍄
    {":peanuts:", "\xf0\x9f\xa5\x9c"}, // 🥜
    {":chestnut:", "\xf0\x9f\x8c\xb0"}, // 🌰
    {":bread:", "\xf0\x9f\x8d\x9e"}, // 🍞
    {":croissant:", "\xf0\x9f\xa5\x90"}, // 🥐
    {":baguette_bread:", "\xf0\x9f\xa5\x96"}, // 🥖
    {":flatbread:", "\xf0\x9f\xab\x93"}, // 🫓
    {":pretzel:", "\xf0\x9f\xa5\xa8"}, // 🥨
    {":bagel:", "\xf0\x9f\xa5\xaf"}, // 🥯
    {":pancakes:", "\xf0\x9f\xa5\x9e"}, // 🥞
    {":waffle:", "\xf0\x9f\xa7\x87"}, // 🧇
    {":cheese:", "\xf0\x9f\xa7\x80"}, // 🧀
    {":meat_on_bone:", "\xf0\x9f\x8d\x96"}, // 🍖
    {":poultry_leg:", "\xf0\x9f\x8d\x97"}, // 🍗
    {":cut_of_meat:", "\xf0\x9f\xa5\xa9"}, // 🥩
    {":bacon:", "\xf0\x9f\xa5\x93"}, // 🥓
    {":hamburger:", "\xf0\x9f\x8d\x94"}, // 🍔
    {":fries:", "\xf0\x9f\x8d\x9f"}, // 🍟
    {":pizza:", "\xf0\x9f\x8d\x95"}, // 🍕
    {":hotdog:", "\xf0\x9f\x8c\xad"}, // 🌭
    {":sandwich:", "\xf0\x9f\xa5\xaa"}, // 🥪
    {":taco:", "\xf0\x9f\x8c\xae"}, // 🌮
    {":burrito:", "\xf0\x9f\x8c\xaf"}, // 🌯
    {":tamale:", "\xf0\x9f\xab\x94"}, // 🫔
    {":stuffed_flatbread:", "\xf0\x9f\xa5\x99"}, // 🥙
    {":falafel:", "\xf0\x9f\xa7\x86"}, // 🧆
    {":egg:", "\xf0\x9f\xa5\x9a"}, // 🥚
    {":fried_egg:", "\xf0\x9f\x8d\xb3"}, // 🍳
    {":shallow_pan_of_food:", "\xf0\x9f\xa5\x98"}, // 🥘
    {":stew:", "\xf0\x9f\x8d\xb2"}, // 🍲
    {":fondue:", "\xf0\x9f\xab\x95"}, // 🫕
    {":bowl_with_spoon:", "\xf0\x9f\xa5\xa3"}, // 🥣
    {":green_salad:", "\xf0\x9f\xa5\x97"}, // 🥗
    {":popcorn:", "\xf0\x9f\x8d\xbf"}, // 🍿
    {":butter:", "\xf0\x9f\xa7\x88"}, // 🧈
    {":salt:", "\xf0\x9f\xa7\x82"}, // 🧂
    {":canned_food:", "\xf0\x9f\xa5\xab"}, // 🥫
    {":bento:", "\xf0\x9f\x8d\xb1"}, // 🍱
    {":rice_cracker:", "\xf0\x9f\x8d\x98"}, // 🍘
    {":rice_ball:", "\xf0\x9f\x8d\x99"}, // 🍙
    {":rice:", "\xf0\x9f\x8d\x9a"}, // 🍚
    {":curry:", "\xf0\x9f\x8d\x9b"}, // 🍛
    {":ramen:", "\xf0\x9f\x8d\x9c"}, // 🍜
    {":spaghetti:", "\xf0\x9f\x8d\x9d"}, // 🍝
    {":sweet_potato:", "\xf0\x9f\x8d\xa0"}, // 🍠
    {":oden:", "\xf0\x9f\x8d\xa2"}, // 🍢
    {":sushi:", "\xf0\x9f\x8d\xa3"}, // 🍣
    {":fried_shrimp:", "\xf0\x9f\x8d\xa4"}, // 🍤
    {":fish_cake:", "\xf0\x9f\x8d\xa5"}, // 🍥
    {":moon_cake:", "\xf0\x9f\xa5\xae"}, // 🥮
    {":dango:", "\xf0\x9f\x8d\xa1"}, // 🍡
    {":dumpling:", "\xf0\x9f\xa5\x9f"}, // 🥟
    {":fortune_cookie:", "\xf0\x9f\xa5\xa0"}, // 🥠
    {":takeout_box:", "\xf0\x9f\xa5\xa1"}, // 🥡
    {":crab:", "\xf0\x9f\xa6\x80"}, // 🦀
    {":lobster:", "\xf0\x9f\xa6\x9e"}, // 🦞
    {":shrimp:", "\xf0\x9f\xa6\x90"}, // 🦐
    {":squid:", "\xf0\x9f\xa6\x91"}, // 🦑
    {":oyster:", "\xf0\x9f\xa6\xaa"}, // 🦪
    {":icecream:", "\xf0\x9f\x8d\xa6"}, // 🍦
    {":shaved_ice:", "\xf0\x9f\x8d\xa7"}, // 🍧
    {":ice_cream:", "\xf0\x9f\x8d\xa8"}, // 🍨
    {":doughnut:", "\xf0\x9f\x8d\xa9"}, // 🍩
    {":cookie:", "\xf0\x9f\x8d\xaa"}, // 🍪
    {":birthday:", "\xf0\x9f\x8e\x82"}, // 🎂
    {":cake:", "\xf0\x9f\x8d\xb0"}, // 🍰
    {":cupcake:", "\xf0\x9f\xa7\x81"}, // 🧁
    {":pie:", "\xf0\x9f\xa5\xa7"}, // 🥧
    {":chocolate_bar:", "\xf0\x9f\x8d\xab"}, // 🍫
    {":candy:", "\xf0\x9f\x8d\xac"}, // 🍬
    {":lollipop:", "\xf0\x9f\x8d\xad"}, // 🍭
    {":custard:", "\xf0\x9f\x8d\xae"}, // 🍮
    {":honey_pot:", "\xf0\x9f\x8d\xaf"}, // 🍯
    {":baby_bottle:", "\xf0\x9f\x8d\xbc"}, // 🍼
    {":milk_glass:", "\xf0\x9f\xa5\x9b"}, // 🥛
    {":coffee:", "\xe2\x98\x95"}, // ☕
    {":teapot:", "\xf0\x9f\xab\x96"}, // 🫖
    {":tea:", "\xf0\x9f\x8d\xb5"}, // 🍵
    {":sake:", "\xf0\x9f\x8d\xb6"}, // 🍶
    {":champagne:", "\xf0\x9f\x8d\xbe"}, // 🍾
    {":wine_glass:", "\xf0\x9f\x8d\xb7"}, // 🍷
    {":cocktail:", "\xf0\x9f\x8d\xb8"}, // 🍸
    {":tropical_drink:", "\xf0\x9f\x8d\xb9"}, // 🍹
    {":beer:", "\xf0\x9f\x8d\xba"}, // 🍺
    {":beers:", "\xf0\x9f\x8d\xbb"}, // 🍻
    {":clinking_glasses:", "\xf0\x9f\xa5\x82"}, // 🥂
    {":tumbler_glass:", "\xf0\x9f\xa5\x83"}, // 🥃
    {":cup_with_straw:", "\xf0\x9f\xa5\xa4"}, // 🥤
    {":bubble_tea:", "\xf0\x9f\xa7\x8b"}, // 🧋
    {":beverage_box:", "\xf0\x9f\xa7\x83"}, // 🧃
    {":mate:", "\xf0\x9f\xa7\x89"}, // 🧉
    {":ice_cube:", "\xf0\x9f\xa7\x8a"}, // 🧊
    {":chopsticks:", "\xf0\x9f\xa5\xa2"}, // 🥢
    {":plate_with_cutlery:", "\xf0\x9f\x8d\xbd\xef\xb8\x8f"}, // 🍽️
    {":fork_and_knife:", "\xf0\x9f\x8d\xb4"}, // 🍴
    {":spoon:", "\xf0\x9f\xa5\x84"}, // 🥄
    {":hocho:", "\xf0\x9f\x94\xaa"}, // 🔪
    {":knife:", "\xf0\x9f\x94\xaa"}, // 🔪
    {":amphora:", "\xf0\x9f\x8f\xba"}, // 🏺
    {":earth_africa:", "\xf0\x9f\x8c\x8d"}, // 🌍
    {":earth_americas:", "\xf0\x9f\x8c\x8e"}, // 🌎
    {":earth_asia:", "\xf0\x9f\x8c\x8f"}, // 🌏
    {":globe_with_meridians:", "\xf0\x9f\x8c\x90"}, // 🌐
    {":world_map:", "\xf0\x9f\x97\xba\xef\xb8\x8f"}, // 🗺️
    {":japan:", "\xf0\x9f\x97\xbe"}, // 🗾
    {":compass:", "\xf0\x9f\xa7\xad"}, // 🧭
    {":mountain_snow:", "\xf0\x9f\x8f\x94\xef\xb8\x8f"}, // 🏔️
    {":mountain:", "\xe2\x9b\xb0\xef\xb8\x8f"}, // ⛰️
    {":volcano:", "\xf0\x9f\x8c\x8b"}, // 🌋
    {":mount_fuji:", "\xf0\x9f\x97\xbb"}, // 🗻
    {":camping:", "\xf0\x9f\x8f\x95\xef\xb8\x8f"}, // 🏕️
    {":beach_umbrella:", "\xf0\x9f\x8f\x96\xef\xb8\x8f"}, // 🏖️
    {":desert:", "\xf0\x9f\x8f\x9c\xef\xb8\x8f"}, // 🏜️
    {":desert_island:", "\xf0\x9f\x8f\x9d\xef\xb8\x8f"}, // 🏝️
    {":national_park:", "\xf0\x9f\x8f\x9e\xef\xb8\x8f"}, // 🏞️
    {":stadium:", "\xf0\x9f\x8f\x9f\xef\xb8\x8f"}, // 🏟️
    {":classical_building:", "\xf0\x9f\x8f\x9b\xef\xb8\x8f"}, // 🏛️
    {":building_construction:", "\xf0\x9f\x8f\x97\xef\xb8\x8f"}, // 🏗️
    {":bricks:", "\xf0\x9f\xa7\xb1"}, // 🧱
    {":rock:", "\xf0\x9f\xaa\xa8"}, // 🪨
    {":wood:", "\xf0\x9f\xaa\xb5"}, // 🪵
    {":hut:", "\xf0\x9f\x9b\x96"}, // 🛖
    {":houses:", "\xf0\x9f\x8f\x98\xef\xb8\x8f"}, // 🏘️
    {":derelict_house:", "\xf0\x9f\x8f\x9a\xef\xb8\x8f"}, // 🏚️
    {":house:", "\xf0\x9f\x8f\xa0"}, // 🏠
    {":house_with_garden:", "\xf0\x9f\x8f\xa1"}, // 🏡
    {":office:", "\xf0\x9f\x8f\xa2"}, // 🏢
    {":post_office:", "\xf0\x9f\x8f\xa3"}, // 🏣
    {":european_post_office:", "\xf0\x9f\x8f\xa4"}, // 🏤
    {":hospital:", "\xf0\x9f\x8f\xa5"}, // 🏥
    {":bank:", "\xf0\x9f\x8f\xa6"}, // 🏦
    {":hotel:", "\xf0\x9f\x8f\xa8"}, // 🏨
    {":love_hotel:", "\xf0\x9f\x8f\xa9"}, // 🏩
    {":convenience_store:", "\xf0\x9f\x8f\xaa"}, // 🏪
    {":school:", "\xf0\x9f\x8f\xab"}, // 🏫
    {":department_store:", "\xf0\x9f\x8f\xac"}, // 🏬
    {":factory:", "\xf0\x9f\x8f\xad"}, // 🏭
    {":japanese_castle:", "\xf0\x9f\x8f\xaf"}, // 🏯
    {":european_castle:", "\xf0\x9f\x8f\xb0"}, // 🏰
    {":wedding:", "\xf0\x9f\x92\x92"}, // 💒
    {":tokyo_tower:", "\xf0\x9f\x97\xbc"}, // 🗼
    {":statue_of_liberty:", "\xf0\x9f\x97\xbd"}, // 🗽
    {":church:", "\xe2\x9b\xaa"}, // ⛪
    {":mosque:", "\xf0\x9f\x95\x8c"}, // 🕌
    {":hindu_temple:", "\xf0\x9f\x9b\x95"}, // 🛕
    {":synagogue:", "\xf0\x9f\x95\x8d"}, // 🕍
    {":shinto_shrine:", "\xe2\x9b\xa9\xef\xb8\x8f"}, // ⛩️
    {":kaaba:", "\xf0\x9f\x95\x8b"}, // 🕋
    {":fountain:", "\xe2\x9b\xb2"}, // ⛲
    {":tent:", "\xe2\x9b\xba"}, // ⛺
    {":foggy:", "\xf0\x9f\x8c\x81"}, // 🌁
    {":night_with_stars:", "\xf0\x9f\x8c\x83"}, // 🌃
    {":cityscape:", "\xf0\x9f\x8f\x99\xef\xb8\x8f"}, // 🏙️
    {":sunrise_over_mountains:", "\xf0\x9f\x8c\x84"}, // 🌄
    {":sunrise:", "\xf0\x9f\x8c\x85"}, // 🌅
    {":city_sunset:", "\xf0\x9f\x8c\x86"}, // 🌆
    {":city_sunrise:", "\xf0\x9f\x8c\x87"}, // 🌇
    {":bridge_at_night:", "\xf0\x9f\x8c\x89"}, // 🌉
    {":hotsprings:", "\xe2\x99\xa8\xef\xb8\x8f"}, // ♨️
    {":carousel_horse:", "\xf0\x9f\x8e\xa0"}, // 🎠
    {":ferris_wheel:", "\xf0\x9f\x8e\xa1"}, // 🎡
    {":roller_coaster:", "\xf0\x9f\x8e\xa2"}, // 🎢
    {":barber:", "\xf0\x9f\x92\x88"}, // 💈
    {":circus_tent:", "\xf0\x9f\x8e\xaa"}, // 🎪
    {":steam_locomotive:", "\xf0\x9f\x9a\x82"}, // 🚂
    {":railway_car:", "\xf0\x9f\x9a\x83"}, // 🚃
    {":bullettrain_side:", "\xf0\x9f\x9a\x84"}, // 🚄
    {":bullettrain_front:", "\xf0\x9f\x9a\x85"}, // 🚅
    {":train2:", "\xf0\x9f\x9a\x86"}, // 🚆
    {":metro:", "\xf0\x9f\x9a\x87"}, // 🚇
    {":light_rail:", "\xf0\x9f\x9a\x88"}, // 🚈
    {":station:", "\xf0\x9f\x9a\x89"}, // 🚉
    {":tram:", "\xf0\x9f\x9a\x8a"}, // 🚊
    {":monorail:", "\xf0\x9f\x9a\x9d"}, // 🚝
    {":mountain_railway:", "\xf0\x9f\x9a\x9e"}, // 🚞
    {":train:", "\xf0\x9f\x9a\x8b"}, // 🚋
    {":bus:", "\xf0\x9f\x9a\x8c"}, // 🚌
    {":oncoming_bus:", "\xf0\x9f\x9a\x8d"}, // 🚍
    {":trolleybus:", "\xf0\x9f\x9a\x8e"}, // 🚎
    {":minibus:", "\xf0\x9f\x9a\x90"}, // 🚐
    {":ambulance:", "\xf0\x9f\x9a\x91"}, // 🚑
    {":fire_engine:", "\xf0\x9f\x9a\x92"}, // 🚒
    {":police_car:", "\xf0\x9f\x9a\x93"}, // 🚓
    {":oncoming_police_car:", "\xf0\x9f\x9a\x94"}, // 🚔
    {":taxi:", "\xf0\x9f\x9a\x95"}, // 🚕
    {":oncoming_taxi:", "\xf0\x9f\x9a\x96"}, // 🚖
    {":car:", "\xf0\x9f\x9a\x97"}, // 🚗
    {":red_car:", "\xf0\x9f\x9a\x97"}, // 🚗
    {":oncoming_automobile:", "\xf0\x9f\x9a\x98"}, // 🚘
    {":blue_car:", "\xf0\x9f\x9a\x99"}, // 🚙
    {":pickup_truck:", "\xf0\x9f\x9b\xbb"}, // 🛻
    {":truck:", "\xf0\x9f\x9a\x9a"}, // 🚚
    {":articulated_lorry:", "\xf0\x9f\x9a\x9b"}, // 🚛
    {":tractor:", "\xf0\x9f\x9a\x9c"}, // 🚜
    {":racing_car:", "\xf0\x9f\x8f\x8e\xef\xb8\x8f"}, // 🏎️
    {":motorcycle:", "\xf0\x9f\x8f\x8d\xef\xb8\x8f"}, // 🏍️
    {":motor_scooter:", "\xf0\x9f\x9b\xb5"}, // 🛵
    {":manual_wheelchair:", "\xf0\x9f\xa6\xbd"}, // 🦽
    {":motorized_wheelchair:", "\xf0\x9f\xa6\xbc"}, // 🦼
    {":auto_rickshaw:", "\xf0\x9f\x9b\xba"}, // 🛺
    {":bike:", "\xf0\x9f\x9a\xb2"}, // 🚲
    {":kick_scooter:", "\xf0\x9f\x9b\xb4"}, // 🛴
    {":skateboard:", "\xf0\x9f\x9b\xb9"}, // 🛹
    {":roller_skate:", "\xf0\x9f\x9b\xbc"}, // 🛼
    {":busstop:", "\xf0\x9f\x9a\x8f"}, // 🚏
    {":motorway:", "\xf0\x9f\x9b\xa3\xef\xb8\x8f"}, // 🛣️
    {":railway_track:", "\xf0\x9f\x9b\xa4\xef\xb8\x8f"}, // 🛤️
    {":oil_drum:", "\xf0\x9f\x9b\xa2\xef\xb8\x8f"}, // 🛢️
    {":fuelpump:", "\xe2\x9b\xbd"}, // ⛽
    {":rotating_light:", "\xf0\x9f\x9a\xa8"}, // 🚨
    {":traffic_light:", "\xf0\x9f\x9a\xa5"}, // 🚥
    {":vertical_traffic_light:", "\xf0\x9f\x9a\xa6"}, // 🚦
    {":stop_sign:", "\xf0\x9f\x9b\x91"}, // 🛑
    {":construction:", "\xf0\x9f\x9a\xa7"}, // 🚧
    {":anchor:", "\xe2\x9a\x93"}, // ⚓
    {":boat:", "\xe2\x9b\xb5"}, // ⛵
    {":sailboat:", "\xe2\x9b\xb5"}, // ⛵
    {":canoe:", "\xf0\x9f\x9b\xb6"}, // 🛶
    {":speedboat:", "\xf0\x9f\x9a\xa4"}, // 🚤
    {":passenger_ship:", "\xf0\x9f\x9b\xb3\xef\xb8\x8f"}, // 🛳️
    {":ferry:", "\xe2\x9b\xb4\xef\xb8\x8f"}, // ⛴️
    {":motor_boat:", "\xf0\x9f\x9b\xa5\xef\xb8\x8f"}, // 🛥️
    {":ship:", "\xf0\x9f\x9a\xa2"}, // 🚢
    {":airplane:", "\xe2\x9c\x88\xef\xb8\x8f"}, // ✈️
    {":small_airplane:", "\xf0\x9f\x9b\xa9\xef\xb8\x8f"}, // 🛩️
    {":flight_departure:", "\xf0\x9f\x9b\xab"}, // 🛫
    {":flight_arrival:", "\xf0\x9f\x9b\xac"}, // 🛬
    {":parachute:", "\xf0\x9f\xaa\x82"}, // 🪂
    {":seat:", "\xf0\x9f\x92\xba"}, // 💺
    {":helicopter:", "\xf0\x9f\x9a\x81"}, // 🚁
    {":suspension_railway:", "\xf0\x9f\x9a\x9f"}, // 🚟
    {":mountain_cableway:", "\xf0\x9f\x9a\xa0"}, // 🚠
    {":aerial_tramway:", "\xf0\x9f\x9a\xa1"}, // 🚡
    {":artificial_satellite:", "\xf0\x9f\x9b\xb0\xef\xb8\x8f"}, // 🛰️
    {":rocket:", "\xf0\x9f\x9a\x80"}, // 🚀
    {":flying_saucer:", "\xf0\x9f\x9b\xb8"}, // 🛸
    {":bellhop_bell:", "\xf0\x9f\x9b\x8e\xef\xb8\x8f"}, // 🛎️
    {":luggage:", "\xf0\x9f\xa7\xb3"}, // 🧳
    {":hourglass:", "\xe2\x8c\x9b"}, // ⌛
    {":hourglass_flowing_sand:", "\xe2\x8f\xb3"}, // ⏳
    {":watch:", "\xe2\x8c\x9a"}, // ⌚
    {":alarm_clock:", "\xe2\x8f\xb0"}, // ⏰
    {":stopwatch:", "\xe2\x8f\xb1\xef\xb8\x8f"}, // ⏱️
    {":timer_clock:", "\xe2\x8f\xb2\xef\xb8\x8f"}, // ⏲️
    {":mantelpiece_clock:", "\xf0\x9f\x95\xb0\xef\xb8\x8f"}, // 🕰️
    {":clock12:", "\xf0\x9f\x95\x9b"}, // 🕛
    {":clock1230:", "\xf0\x9f\x95\xa7"}, // 🕧
    {":clock1:", "\xf0\x9f\x95\x90"}, // 🕐
    {":clock130:", "\xf0\x9f\x95\x9c"}, // 🕜
    {":clock2:", "\xf0\x9f\x95\x91"}, // 🕑
    {":clock230:", "\xf0\x9f\x95\x9d"}, // 🕝
    {":clock3:", "\xf0\x9f\x95\x92"}, // 🕒
    {":clock330:", "\xf0\x9f\x95\x9e"}, // 🕞
    {":clock4:", "\xf0\x9f\x95\x93"}, // 🕓
    {":clock430:", "\xf0\x9f\x95\x9f"}, // 🕟
    {":clock5:", "\xf0\x9f\x95\x94"}, // 🕔
    {":clock530:", "\xf0\x9f\x95\xa0"}, // 🕠
    {":clock6:", "\xf0\x9f\x95\x95"}, // 🕕
    {":clock630:", "\xf0\x9f\x95\xa1"}, // 🕡
    {":clock7:", "\xf0\x9f\x95\x96"}, // 🕖
    {":clock730:", "\xf0\x9f\x95\xa2"}, // 🕢
    {":clock8:", "\xf0\x9f\x95\x97"}, // 🕗
    {":clock830:", "\xf0\x9f\x95\xa3"}, // 🕣
    {":clock9:", "\xf0\x9f\x95\x98"}, // 🕘
    {":clock930:", "\xf0\x9f\x95\xa4"}, // 🕤
    {":clock10:", "\xf0\x9f\x95\x99"}, // 🕙
    {":clock1030:", "\xf0\x9f\x95\xa5"}, // 🕥
    {":clock11:", "\xf0\x9f\x95\x9a"}, // 🕚
    {":clock1130:", "\xf0\x9f\x95\xa6"}, // 🕦
    {":new_moon:", "\xf0\x9f\x8c\x91"}, // 🌑
    {":waxing_crescent_moon:", "\xf0\x9f\x8c\x92"}, // 🌒
    {":first_quarter_moon:", "\xf0\x9f\x8c\x93"}, // 🌓
    {":moon:", "\xf0\x9f\x8c\x94"}, // 🌔
    {":waxing_gibbous_moon:", "\xf0\x9f\x8c\x94"}, // 🌔
    {":full_moon:", "\xf0\x9f\x8c\x95"}, // 🌕
    {":waning_gibbous_moon:", "\xf0\x9f\x8c\x96"}, // 🌖
    {":last_quarter_moon:", "\xf0\x9f\x8c\x97"}, // 🌗
    {":waning_crescent_moon:", "\xf0\x9f\x8c\x98"}, // 🌘
    {":crescent_moon:", "\xf0\x9f\x8c\x99"}, // 🌙
    {":new_moon_with_face:", "\xf0\x9f\x8c\x9a"}, // 🌚
    {":first_quarter_moon_with_face:", "\xf0\x9f\x8c\x9b"}, // 🌛
    {":last_quarter_moon_with_face:", "\xf0\x9f\x8c\x9c"}, // 🌜
    {":thermometer:", "\xf0\x9f\x8c\xa1\xef\xb8\x8f"}, // 🌡️
    {":sunny:", "\xe2\x98\x80\xef\xb8\x8f"}, // ☀️
    {":full_moon_with_face:", "\xf0\x9f\x8c\x9d"}, // 🌝
    {":sun_with_face:", "\xf0\x9f\x8c\x9e"}, // 🌞
    {":ringed_planet:", "\xf0\x9f\xaa\x90"}, // 🪐
    {":star:", "\xe2\xad\x90"}, // ⭐
    {":star2:", "\xf0\x9f\x8c\x9f"}, // 🌟
    {":stars:", "\xf0\x9f\x8c\xa0"}, // 🌠
    {":milky_way:", "\xf0\x9f\x8c\x8c"}, // 🌌
    {":cloud:", "\xe2\x98\x81\xef\xb8\x8f"}, // ☁️
    {":partly_sunny:", "\xe2\x9b\x85"}, // ⛅
    {":cloud_with_lightning_and_rain:", "\xe2\x9b\x88\xef\xb8\x8f"}, // ⛈️
    {":sun_behind_small_cloud:", "\xf0\x9f\x8c\xa4\xef\xb8\x8f"}, // 🌤️
    {":sun_behind_large_cloud:", "\xf0\x9f\x8c\xa5\xef\xb8\x8f"}, // 🌥️
    {":sun_behind_rain_cloud:", "\xf0\x9f\x8c\xa6\xef\xb8\x8f"}, // 🌦️
    {":cloud_with_rain:", "\xf0\x9f\x8c\xa7\xef\xb8\x8f"}, // 🌧️
    {":cloud_with_snow:", "\xf0\x9f\x8c\xa8\xef\xb8\x8f"}, // 🌨️
    {":cloud_with_lightning:", "\xf0\x9f\x8c\xa9\xef\xb8\x8f"}, // 🌩️
    {":tornado:", "\xf0\x9f\x8c\xaa\xef\xb8\x8f"}, // 🌪️
    {":fog:", "\xf0\x9f\x8c\xab\xef\xb8\x8f"}, // 🌫️
    {":wind_face:", "\xf0\x9f\x8c\xac\xef\xb8\x8f"}, // 🌬️
    {":cyclone:", "\xf0\x9f\x8c\x80"}, // 🌀
    {":rainbow:", "\xf0\x9f\x8c\x88"}, // 🌈
    {":closed_umbrella:", "\xf0\x9f\x8c\x82"}, // 🌂
    {":open_umbrella:", "\xe2\x98\x82\xef\xb8\x8f"}, // ☂️
    {":umbrella:", "\xe2\x98\x94"}, // ☔
    {":parasol_on_ground:", "\xe2\x9b\xb1\xef\xb8\x8f"}, // ⛱️
    {":zap:", "\xe2\x9a\xa1"}, // ⚡
    {":snowflake:", "\xe2\x9d\x84\xef\xb8\x8f"}, // ❄️
    {":snowman_with_snow:", "\xe2\x98\x83\xef\xb8\x8f"}, // ☃️
    {":snowman:", "\xe2\x9b\x84"}, // ⛄
    {":comet:", "\xe2\x98\x84\xef\xb8\x8f"}, // ☄️
    {":fire:", "\xf0\x9f\x94\xa5"}, // 🔥
    {":droplet:", "\xf0\x9f\x92\xa7"}, // 💧
    {":ocean:", "\xf0\x9f\x8c\x8a"}, // 🌊
    {":jack_o_lantern:", "\xf0\x9f\x8e\x83"}, // 🎃
    {":christmas_tree:", "\xf0\x9f\x8e\x84"}, // 🎄
    {":fireworks:", "\xf0\x9f\x8e\x86"}, // 🎆
    {":sparkler:", "\xf0\x9f\x8e\x87"}, // 🎇
    {":firecracker:", "\xf0\x9f\xa7\xa8"}, // 🧨
    {":sparkles:", "\xe2\x9c\xa8"}, // ✨
    {":balloon:", "\xf0\x9f\x8e\x88"}, // 🎈
    {":tada:", "\xf0\x9f\x8e\x89"}, // 🎉
    {":confetti_ball:", "\xf0\x9f\x8e\x8a"}, // 🎊
    {":tanabata_tree:", "\xf0\x9f\x8e\x8b"}, // 🎋
    {":bamboo:", "\xf0\x9f\x8e\x8d"}, // 🎍
    {":dolls:", "\xf0\x9f\x8e\x8e"}, // 🎎
    {":flags:", "\xf0\x9f\x8e\x8f"}, // 🎏
    {":wind_chime:", "\xf0\x9f\x8e\x90"}, // 🎐
    {":rice_scene:", "\xf0\x9f\x8e\x91"}, // 🎑
    {":red_envelope:", "\xf0\x9f\xa7\xa7"}, // 🧧
    {":ribbon:", "\xf0\x9f\x8e\x80"}, // 🎀
    {":gift:", "\xf0\x9f\x8e\x81"}, // 🎁
    {":reminder_ribbon:", "\xf0\x9f\x8e\x97\xef\xb8\x8f"}, // 🎗️
    {":tickets:", "\xf0\x9f\x8e\x9f\xef\xb8\x8f"}, // 🎟️
    {":ticket:", "\xf0\x9f\x8e\xab"}, // 🎫
    {":medal_military:", "\xf0\x9f\x8e\x96\xef\xb8\x8f"}, // 🎖️
    {":trophy:", "\xf0\x9f\x8f\x86"}, // 🏆
    {":medal_sports:", "\xf0\x9f\x8f\x85"}, // 🏅
    {":1st_place_medal:", "\xf0\x9f\xa5\x87"}, // 🥇
    {":2nd_place_medal:", "\xf0\x9f\xa5\x88"}, // 🥈
    {":3rd_place_medal:", "\xf0\x9f\xa5\x89"}, // 🥉
    {":soccer:", "\xe2\x9a\xbd"}, // ⚽
    {":baseball:", "\xe2\x9a\xbe"}, // ⚾
    {":softball:", "\xf0\x9f\xa5\x8e"}, // 🥎
    {":basketball:", "\xf0\x9f\x8f\x80"}, // 🏀
    {":volleyball:", "\xf0\x9f\x8f\x90"}, // 🏐
    {":football:", "\xf0\x9f\x8f\x88"}, // 🏈
    {":rugby_football:", "\xf0\x9f\x8f\x89"}, // 🏉
    {":tennis:", "\xf0\x9f\x8e\xbe"}, // 🎾
    {":flying_disc:", "\xf0\x9f\xa5\x8f"}, // 🥏
    {":bowling:", "\xf0\x9f\x8e\xb3"}, // 🎳
    {":cricket_game:", "\xf0\x9f\x8f\x8f"}, // 🏏
    {":field_hockey:", "\xf0\x9f\x8f\x91"}, // 🏑
    {":ice_hockey:", "\xf0\x9f\x8f\x92"}, // 🏒
    {":lacrosse:", "\xf0\x9f\xa5\x8d"}, // 🥍
    {":ping_pong:", "\xf0\x9f\x8f\x93"}, // 🏓
    {":badminton:", "\xf0\x9f\x8f\xb8"}, // 🏸
    {":boxing_glove:", "\xf0\x9f\xa5\x8a"}, // 🥊
    {":martial_arts_uniform:", "\xf0\x9f\xa5\x8b"}, // 🥋
    {":goal_net:", "\xf0\x9f\xa5\x85"}, // 🥅
    {":golf:", "\xe2\x9b\xb3"}, // ⛳
    {":ice_skate:", "\xe2\x9b\xb8\xef\xb8\x8f"}, // ⛸️
    {":fishing_pole_and_fish:", "\xf0\x9f\x8e\xa3"}, // 🎣
    {":diving_mask:", "\xf0\x9f\xa4\xbf"}, // 🤿
    {":running_shirt_with_sash:", "\xf0\x9f\x8e\xbd"}, // 🎽
    {":ski:", "\xf0\x9f\x8e\xbf"}, // 🎿
    {":sled:", "\xf0\x9f\x9b\xb7"}, // 🛷
    {":curling_stone:", "\xf0\x9f\xa5\x8c"}, // 🥌
    {":dart:", "\xf0\x9f\x8e\xaf"}, // 🎯
    {":yo_yo:", "\xf0\x9f\xaa\x80"}, // 🪀
    {":kite:", "\xf0\x9f\xaa\x81"}, // 🪁
    {":8ball:", "\xf0\x9f\x8e\xb1"}, // 🎱
    {":crystal_ball:", "\xf0\x9f\x94\xae"}, // 🔮
    {":magic_wand:", "\xf0\x9f\xaa\x84"}, // 🪄
    {":nazar_amulet:", "\xf0\x9f\xa7\xbf"}, // 🧿
    {":video_game:", "\xf0\x9f\x8e\xae"}, // 🎮
    {":joystick:", "\xf0\x9f\x95\xb9\xef\xb8\x8f"}, // 🕹️
    {":slot_machine:", "\xf0\x9f\x8e\xb0"}, // 🎰
    {":game_die:", "\xf0\x9f\x8e\xb2"}, // 🎲
    {":jigsaw:", "\xf0\x9f\xa7\xa9"}, // 🧩
    {":teddy_bear:", "\xf0\x9f\xa7\xb8"}, // 🧸
    {":pinata:", "\xf0\x9f\xaa\x85"}, // 🪅
    {":nesting_dolls:", "\xf0\x9f\xaa\x86"}, // 🪆
    {":spades:", "\xe2\x99\xa0\xef\xb8\x8f"}, // ♠️
    {":hearts:", "\xe2\x99\xa5\xef\xb8\x8f"}, // ♥️
    {":diamonds:", "\xe2\x99\xa6\xef\xb8\x8f"}, // ♦️
    {":clubs:", "\xe2\x99\xa3\xef\xb8\x8f"}, // ♣️
    {":chess_pawn:", "\xe2\x99\x9f\xef\xb8\x8f"}, // ♟️
    {":black_joker:", "\xf0\x9f\x83\x8f"}, // 🃏
    {":mahjong:", "\xf0\x9f\x80\x84"}, // 🀄
    {":flower_playing_cards:", "\xf0\x9f\x8e\xb4"}, // 🎴
    {":performing_arts:", "\xf0\x9f\x8e\xad"}, // 🎭
    {":framed_picture:", "\xf0\x9f\x96\xbc\xef\xb8\x8f"}, // 🖼️
    {":art:", "\xf0\x9f\x8e\xa8"}, // 🎨
    {":thread:", "\xf0\x9f\xa7\xb5"}, // 🧵
    {":sewing_needle:", "\xf0\x9f\xaa\xa1"}, // 🪡
    {":yarn:", "\xf0\x9f\xa7\xb6"}, // 🧶
    {":knot:", "\xf0\x9f\xaa\xa2"}, // 🪢
    {":eyeglasses:", "\xf0\x9f\x91\x93"}, // 👓
    {":dark_sunglasses:", "\xf0\x9f\x95\xb6\xef\xb8\x8f"}, // 🕶️
    {":goggles:", "\xf0\x9f\xa5\xbd"}, // 🥽
    {":lab_coat:", "\xf0\x9f\xa5\xbc"}, // 🥼
    {":safety_vest:", "\xf0\x9f\xa6\xba"}, // 🦺
    {":necktie:", "\xf0\x9f\x91\x94"}, // 👔
    {":shirt:", "\xf0\x9f\x91\x95"}, // 👕
    {":tshirt:", "\xf0\x9f\x91\x95"}, // 👕
    {":jeans:", "\xf0\x9f\x91\x96"}, // 👖
    {":scarf:", "\xf0\x9f\xa7\xa3"}, // 🧣
    {":gloves:", "\xf0\x9f\xa7\xa4"}, // 🧤
    {":coat:", "\xf0\x9f\xa7\xa5"}, // 🧥
    {":socks:", "\xf0\x9f\xa7\xa6"}, // 🧦
    {":dress:", "\xf0\x9f\x91\x97"}, // 👗
    {":kimono:", "\xf0\x9f\x91\x98"}, // 👘
    {":sari:", "\xf0\x9f\xa5\xbb"}, // 🥻
    {":one_piece_swimsuit:", "\xf0\x9f\xa9\xb1"}, // 🩱
    {":swim_brief:", "\xf0\x9f\xa9\xb2"}, // 🩲
    {":shorts:", "\xf0\x9f\xa9\xb3"}, // 🩳
    {":bikini:", "\xf0\x9f\x91\x99"}, // 👙
    {":womans_clothes:", "\xf0\x9f\x91\x9a"}, // 👚
    {":purse:", "\xf0\x9f\x91\x9b"}, // 👛
    {":handbag:", "\xf0\x9f\x91\x9c"}, // 👜
    {":pouch:", "\xf0\x9f\x91\x9d"}, // 👝
    {":shopping:", "\xf0\x9f\x9b\x8d\xef\xb8\x8f"}, // 🛍️
    {":school_satchel:", "\xf0\x9f\x8e\x92"}, // 🎒
    {":thong_sandal:", "\xf0\x9f\xa9\xb4"}, // 🩴
    {":mans_shoe:", "\xf0\x9f\x91\x9e"}, // 👞
    {":shoe:", "\xf0\x9f\x91\x9e"}, // 👞
    {":athletic_shoe:", "\xf0\x9f\x91\x9f"}, // 👟
    {":hiking_boot:", "\xf0\x9f\xa5\xbe"}, // 🥾
    {":flat_shoe:", "\xf0\x9f\xa5\xbf"}, // 🥿
    {":high_heel:", "\xf0\x9f\x91\xa0"}, // 👠
    {":sandal:", "\xf0\x9f\x91\xa1"}, // 👡
    {":ballet_shoes:", "\xf0\x9f\xa9\xb0"}, // 🩰
    {":boot:", "\xf0\x9f\x91\xa2"}, // 👢
    {":crown:", "\xf0\x9f\x91\x91"}, // 👑
    {":womans_hat:", "\xf0\x9f\x91\x92"}, // 👒
    {":tophat:", "\xf0\x9f\x8e\xa9"}, // 🎩
    {":mortar_board:", "\xf0\x9f\x8e\x93"}, // 🎓
    {":billed_cap:", "\xf0\x9f\xa7\xa2"}, // 🧢
    {":military_helmet:", "\xf0\x9f\xaa\x96"}, // 🪖
    {":rescue_worker_helmet:", "\xe2\x9b\x91\xef\xb8\x8f"}, // ⛑️
    {":prayer_beads:", "\xf0\x9f\x93\xbf"}, // 📿
    {":lipstick:", "\xf0\x9f\x92\x84"}, // 💄
    {":ring:", "\xf0\x9f\x92\x8d"}, // 💍
    {":gem:", "\xf0\x9f\x92\x8e"}, // 💎
    {":mute:", "\xf0\x9f\x94\x87"}, // 🔇
    {":speaker:", "\xf0\x9f\x94\x88"}, // 🔈
    {":sound:", "\xf0\x9f\x94\x89"}, // 🔉
    {":loud_sound:", "\xf0\x9f\x94\x8a"}, // 🔊
    {":loudspeaker:", "\xf0\x9f\x93\xa2"}, // 📢
    {":mega:", "\xf0\x9f\x93\xa3"}, // 📣
    {":postal_horn:", "\xf0\x9f\x93\xaf"}, // 📯
    {":bell:", "\xf0\x9f\x94\x94"}, // 🔔
    {":no_bell:", "\xf0\x9f\x94\x95"}, // 🔕
    {":musical_score:", "\xf0\x9f\x8e\xbc"}, // 🎼
    {":musical_note:", "\xf0\x9f\x8e\xb5"}, // 🎵
    {":notes:", "\xf0\x9f\x8e\xb6"}, // 🎶
    {":studio_microphone:", "\xf0\x9f\x8e\x99\xef\xb8\x8f"}, // 🎙️
    {":level_slider:", "\xf0\x9f\x8e\x9a\xef\xb8\x8f"}, // 🎚️
    {":control_knobs:", "\xf0\x9f\x8e\x9b\xef\xb8\x8f"}, // 🎛️
    {":microphone:", "\xf0\x9f\x8e\xa4"}, // 🎤
    {":headphones:", "\xf0\x9f\x8e\xa7"}, // 🎧
    {":radio:", "\xf0\x9f\x93\xbb"}, // 📻
    {":saxophone:", "\xf0\x9f\x8e\xb7"}, // 🎷
    {":accordion:", "\xf0\x9f\xaa\x97"}, // 🪗
    {":guitar:", "\xf0\x9f\x8e\xb8"}, // 🎸
    {":musical_keyboard:", "\xf0\x9f\x8e\xb9"}, // 🎹
    {":trumpet:", "\xf0\x9f\x8e\xba"}, // 🎺
    {":violin:", "\xf0\x9f\x8e\xbb"}, // 🎻
    {":banjo:", "\xf0\x9f\xaa\x95"}, // 🪕
    {":drum:", "\xf0\x9f\xa5\x81"}, // 🥁
    {":long_drum:", "\xf0\x9f\xaa\x98"}, // 🪘
    {":iphone:", "\xf0\x9f\x93\xb1"}, // 📱
    {":calling:", "\xf0\x9f\x93\xb2"}, // 📲
    {":phone:", "\xe2\x98\x8e\xef\xb8\x8f"}, // ☎️
    {":telephone:", "\xe2\x98\x8e\xef\xb8\x8f"}, // ☎️
    {":telephone_receiver:", "\xf0\x9f\x93\x9e"}, // 📞
    {":pager:", "\xf0\x9f\x93\x9f"}, // 📟
    {":fax:", "\xf0\x9f\x93\xa0"}, // 📠
    {":battery:", "\xf0\x9f\x94\x8b"}, // 🔋
    {":electric_plug:", "\xf0\x9f\x94\x8c"}, // 🔌
    {":computer:", "\xf0\x9f\x92\xbb"}, // 💻
    {":desktop_computer:", "\xf0\x9f\x96\xa5\xef\xb8\x8f"}, // 🖥️
    {":printer:", "\xf0\x9f\x96\xa8\xef\xb8\x8f"}, // 🖨️
    {":keyboard:", "\xe2\x8c\xa8\xef\xb8\x8f"}, // ⌨️
    {":computer_mouse:", "\xf0\x9f\x96\xb1\xef\xb8\x8f"}, // 🖱️
    {":trackball:", "\xf0\x9f\x96\xb2\xef\xb8\x8f"}, // 🖲️
    {":minidisc:", "\xf0\x9f\x92\xbd"}, // 💽
    {":floppy_disk:", "\xf0\x9f\x92\xbe"}, // 💾
    {":cd:", "\xf0\x9f\x92\xbf"}, // 💿
    {":dvd:", "\xf0\x9f\x93\x80"}, // 📀
    {":abacus:", "\xf0\x9f\xa7\xae"}, // 🧮
    {":movie_camera:", "\xf0\x9f\x8e\xa5"}, // 🎥
    {":film_strip:", "\xf0\x9f\x8e\x9e\xef\xb8\x8f"}, // 🎞️
    {":film_projector:", "\xf0\x9f\x93\xbd\xef\xb8\x8f"}, // 📽️
    {":clapper:", "\xf0\x9f\x8e\xac"}, // 🎬
    {":tv:", "\xf0\x9f\x93\xba"}, // 📺
    {":camera:", "\xf0\x9f\x93\xb7"}, // 📷
    {":camera_flash:", "\xf0\x9f\x93\xb8"}, // 📸
    {":video_camera:", "\xf0\x9f\x93\xb9"}, // 📹
    {":vhs:", "\xf0\x9f\x93\xbc"}, // 📼
    {":mag:", "\xf0\x9f\x94\x8d"}, // 🔍
    {":mag_right:", "\xf0\x9f\x94\x8e"}, // 🔎
    {":candle:", "\xf0\x9f\x95\xaf\xef\xb8\x8f"}, // 🕯️
    {":bulb:", "\xf0\x9f\x92\xa1"}, // 💡
    {":flashlight:", "\xf0\x9f\x94\xa6"}, // 🔦
    {":izakaya_lantern:", "\xf0\x9f\x8f\xae"}, // 🏮
    {":lantern:", "\xf0\x9f\x8f\xae"}, // 🏮
    {":diya_lamp:", "\xf0\x9f\xaa\x94"}, // 🪔
    {":notebook_with_decorative_cover:", "\xf0\x9f\x93\x94"}, // 📔
    {":closed_book:", "\xf0\x9f\x93\x95"}, // 📕
    {":book:", "\xf0\x9f\x93\x96"}, // 📖
    {":open_book:", "\xf0\x9f\x93\x96"}, // 📖
    {":green_book:", "\xf0\x9f\x93\x97"}, // 📗
    {":blue_book:", "\xf0\x9f\x93\x98"}, // 📘
    {":orange_book:", "\xf0\x9f\x93\x99"}, // 📙
    {":books:", "\xf0\x9f\x93\x9a"}, // 📚
    {":notebook:", "\xf0\x9f\x93\x93"}, // 📓
    {":ledger:", "\xf0\x9f\x93\x92"}, // 📒
    {":page_with_curl:", "\xf0\x9f\x93\x83"}, // 📃
    {":scroll:", "\xf0\x9f\x93\x9c"}, // 📜
    {":page_facing_up:", "\xf0\x9f\x93\x84"}, // 📄
    {":newspaper:", "\xf0\x9f\x93\xb0"}, // 📰
    {":newspaper_roll:", "\xf0\x9f\x97\x9e\xef\xb8\x8f"}, // 🗞️
    {":bookmark_tabs:", "\xf0\x9f\x93\x91"}, // 📑
    {":bookmark:", "\xf0\x9f\x94\x96"}, // 🔖
    {":label:", "\xf0\x9f\x8f\xb7\xef\xb8\x8f"}, // 🏷️
    {":moneybag:", "\xf0\x9f\x92\xb0"}, // 💰
    {":coin:", "\xf0\x9f\xaa\x99"}, // 🪙
    {":yen:", "\xf0\x9f\x92\xb4"}, // 💴
    {":dollar:", "\xf0\x9f\x92\xb5"}, // 💵
    {":euro:", "\xf0\x9f\x92\xb6"}, // 💶
    {":pound:", "\xf0\x9f\x92\xb7"}, // 💷
    {":money_with_wings:", "\xf0\x9f\x92\xb8"}, // 💸
    {":credit_card:", "\xf0\x9f\x92\xb3"}, // 💳
    {":receipt:", "\xf0\x9f\xa7\xbe"}, // 🧾
    {":chart:", "\xf0\x9f\x92\xb9"}, // 💹
    {":envelope:", "\xe2\x9c\x89\xef\xb8\x8f"}, // ✉️
    {":email:", "\xf0\x9f\x93\xa7"}, // 📧
    {":e-mail:", "\xf0\x9f\x93\xa7"}, // 📧
    {":incoming_envelope:", "\xf0\x9f\x93\xa8"}, // 📨
    {":envelope_with_arrow:", "\xf0\x9f\x93\xa9"}, // 📩
    {":outbox_tray:", "\xf0\x9f\x93\xa4"}, // 📤
    {":inbox_tray:", "\xf0\x9f\x93\xa5"}, // 📥
    {":package:", "\xf0\x9f\x93\xa6"}, // 📦
    {":mailbox:", "\xf0\x9f\x93\xab"}, // 📫
    {":mailbox_closed:", "\xf0\x9f\x93\xaa"}, // 📪
    {":mailbox_with_mail:", "\xf0\x9f\x93\xac"}, // 📬
    {":mailbox_with_no_mail:", "\xf0\x9f\x93\xad"}, // 📭
    {":postbox:", "\xf0\x9f\x93\xae"}, // 📮
    {":ballot_box:", "\xf0\x9f\x97\xb3\xef\xb8\x8f"}, // 🗳️
    {":pencil2:", "\xe2\x9c\x8f\xef\xb8\x8f"}, // ✏️
    {":black_nib:", "\xe2\x9c\x92\xef\xb8\x8f"}, // ✒️
    {":fountain_pen:", "\xf0\x9f\x96\x8b\xef\xb8\x8f"}, // 🖋️
    {":pen:", "\xf0\x9f\x96\x8a\xef\xb8\x8f"}, // 🖊️
    {":paintbrush:", "\xf0\x9f\x96\x8c\xef\xb8\x8f"}, // 🖌️
    {":crayon:", "\xf0\x9f\x96\x8d\xef\xb8\x8f"}, // 🖍️
    {":memo:", "\xf0\x9f\x93\x9d"}, // 📝
    {":pencil:", "\xf0\x9f\x93\x9d"}, // 📝
    {":briefcase:", "\xf0\x9f\x92\xbc"}, // 💼
    {":file_folder:", "\xf0\x9f\x93\x81"}, // 📁
    {":open_file_folder:", "\xf0\x9f\x93\x82"}, // 📂
    {":card_index_dividers:", "\xf0\x9f\x97\x82\xef\xb8\x8f"}, // 🗂️
    {":date:", "\xf0\x9f\x93\x85"}, // 📅
    {":calendar:", "\xf0\x9f\x93\x86"}, // 📆
    {":spiral_notepad:", "\xf0\x9f\x97\x92\xef\xb8\x8f"}, // 🗒️
    {":spiral_calendar:", "\xf0\x9f\x97\x93\xef\xb8\x8f"}, // 🗓️
    {":card_index:", "\xf0\x9f\x93\x87"}, // 📇
    {":chart_with_upwards_trend:", "\xf0\x9f\x93\x88"}, // 📈
    {":chart_with_downwards_trend:", "\xf0\x9f\x93\x89"}, // 📉
    {":bar_chart:", "\xf0\x9f\x93\x8a"}, // 📊
    {":clipboard:", "\xf0\x9f\x93\x8b"}, // 📋
    {":pushpin:", "\xf0\x9f\x93\x8c"}, // 📌
    {":round_pushpin:", "\xf0\x9f\x93\x8d"}, // 📍
    {":paperclip:", "\xf0\x9f\x93\x8e"}, // 📎
    {":paperclips:", "\xf0\x9f\x96\x87\xef\xb8\x8f"}, // 🖇️
    {":straight_ruler:", "\xf0\x9f\x93\x8f"}, // 📏
    {":triangular_ruler:", "\xf0\x9f\x93\x90"}, // 📐
    {":scissors:", "\xe2\x9c\x82\xef\xb8\x8f"}, // ✂️
    {":card_file_box:", "\xf0\x9f\x97\x83\xef\xb8\x8f"}, // 🗃️
    {":file_cabinet:", "\xf0\x9f\x97\x84\xef\xb8\x8f"}, // 🗄️
    {":wastebasket:", "\xf0\x9f\x97\x91\xef\xb8\x8f"}, // 🗑️
    {":lock:", "\xf0\x9f\x94\x92"}, // 🔒
    {":unlock:", "\xf0\x9f\x94\x93"}, // 🔓
    {":lock_with_ink_pen:", "\xf0\x9f\x94\x8f"}, // 🔏
    {":closed_lock_with_key:", "\xf0\x9f\x94\x90"}, // 🔐
    {":key:", "\xf0\x9f\x94\x91"}, // 🔑
    {":old_key:", "\xf0\x9f\x97\x9d\xef\xb8\x8f"}, // 🗝️
    {":hammer:", "\xf0\x9f\x94\xa8"}, // 🔨
    {":axe:", "\xf0\x9f\xaa\x93"}, // 🪓
    {":pick:", "\xe2\x9b\x8f\xef\xb8\x8f"}, // ⛏️
    {":hammer_and_pick:", "\xe2\x9a\x92\xef\xb8\x8f"}, // ⚒️
    {":hammer_and_wrench:", "\xf0\x9f\x9b\xa0\xef\xb8\x8f"}, // 🛠️
    {":dagger:", "\xf0\x9f\x97\xa1\xef\xb8\x8f"}, // 🗡️
    {":crossed_swords:", "\xe2\x9a\x94\xef\xb8\x8f"}, // ⚔️
    {":gun:", "\xf0\x9f\x94\xab"}, // 🔫
    {":boomerang:", "\xf0\x9f\xaa\x83"}, // 🪃
    {":bow_and_arrow:", "\xf0\x9f\x8f\xb9"}, // 🏹
    {":shield:", "\xf0\x9f\x9b\xa1\xef\xb8\x8f"}, // 🛡️
    {":carpentry_saw:", "\xf0\x9f\xaa\x9a"}, // 🪚
    {":wrench:", "\xf0\x9f\x94\xa7"}, // 🔧
    {":screwdriver:", "\xf0\x9f\xaa\x9b"}, // 🪛
    {":nut_and_bolt:", "\xf0\x9f\x94\xa9"}, // 🔩
    {":gear:", "\xe2\x9a\x99\xef\xb8\x8f"}, // ⚙️
    {":clamp:", "\xf0\x9f\x97\x9c\xef\xb8\x8f"}, // 🗜️
    {":balance_scale:", "\xe2\x9a\x96\xef\xb8\x8f"}, // ⚖️
    {":probing_cane:", "\xf0\x9f\xa6\xaf"}, // 🦯
    {":link:", "\xf0\x9f\x94\x97"}, // 🔗
    {":chains:", "\xe2\x9b\x93\xef\xb8\x8f"}, // ⛓️
    {":hook:", "\xf0\x9f\xaa\x9d"}, // 🪝
    {":toolbox:", "\xf0\x9f\xa7\xb0"}, // 🧰
    {":magnet:", "\xf0\x9f\xa7\xb2"}, // 🧲
    {":ladder:", "\xf0\x9f\xaa\x9c"}, // 🪜
    {":alembic:", "\xe2\x9a\x97\xef\xb8\x8f"}, // ⚗️
    {":test_tube:", "\xf0\x9f\xa7\xaa"}, // 🧪
    {":petri_dish:", "\xf0\x9f\xa7\xab"}, // 🧫
    {":dna:", "\xf0\x9f\xa7\xac"}, // 🧬
    {":microscope:", "\xf0\x9f\x94\xac"}, // 🔬
    {":telescope:", "\xf0\x9f\x94\xad"}, // 🔭
    {":satellite:", "\xf0\x9f\x93\xa1"}, // 📡
    {":syringe:", "\xf0\x9f\x92\x89"}, // 💉
    {":drop_of_blood:", "\xf0\x9f\xa9\xb8"}, // 🩸
    {":pill:", "\xf0\x9f\x92\x8a"}, // 💊
    {":adhesive_bandage:", "\xf0\x9f\xa9\xb9"}, // 🩹
    {":stethoscope:", "\xf0\x9f\xa9\xba"}, // 🩺
    {":door:", "\xf0\x9f\x9a\xaa"}, // 🚪
    {":elevator:", "\xf0\x9f\x9b\x97"}, // 🛗
    {":mirror:", "\xf0\x9f\xaa\x9e"}, // 🪞
    {":window:", "\xf0\x9f\xaa\x9f"}, // 🪟
    {":bed:", "\xf0\x9f\x9b\x8f\xef\xb8\x8f"}, // 🛏️
    {":couch_and_lamp:", "\xf0\x9f\x9b\x8b\xef\xb8\x8f"}, // 🛋️
    {":chair:", "\xf0\x9f\xaa\x91"}, // 🪑
    {":toilet:", "\xf0\x9f\x9a\xbd"}, // 🚽
    {":plunger:", "\xf0\x9f\xaa\xa0"}, // 🪠
    {":shower:", "\xf0\x9f\x9a\xbf"}, // 🚿
    {":bathtub:", "\xf0\x9f\x9b\x81"}, // 🛁
    {":mouse_trap:", "\xf0\x9f\xaa\xa4"}, // 🪤
    {":razor:", "\xf0\x9f\xaa\x92"}, // 🪒
    {":lotion_bottle:", "\xf0\x9f\xa7\xb4"}, // 🧴
    {":safety_pin:", "\xf0\x9f\xa7\xb7"}, // 🧷
    {":broom:", "\xf0\x9f\xa7\xb9"}, // 🧹
    {":basket:", "\xf0\x9f\xa7\xba"}, // 🧺
    {":roll_of_paper:", "\xf0\x9f\xa7\xbb"}, // 🧻
    {":bucket:", "\xf0\x9f\xaa\xa3"}, // 🪣
    {":soap:", "\xf0\x9f\xa7\xbc"}, // 🧼
    {":toothbrush:", "\xf0\x9f\xaa\xa5"}, // 🪥
    {":sponge:", "\xf0\x9f\xa7\xbd"}, // 🧽
    {":fire_extinguisher:", "\xf0\x9f\xa7\xaf"}, // 🧯
    {":shopping_cart:", "\xf0\x9f\x9b\x92"}, // 🛒
    {":smoking:", "\xf0\x9f\x9a\xac"}, // 🚬
    {":coffin:", "\xe2\x9a\xb0\xef\xb8\x8f"}, // ⚰️
    {":headstone:", "\xf0\x9f\xaa\xa6"}, // 🪦
    {":funeral_urn:", "\xe2\x9a\xb1\xef\xb8\x8f"}, // ⚱️
    {":moyai:", "\xf0\x9f\x97\xbf"}, // 🗿
    {":placard:", "\xf0\x9f\xaa\xa7"}, // 🪧
    {":atm:", "\xf0\x9f\x8f\xa7"}, // 🏧
    {":put_litter_in_its_place:", "\xf0\x9f\x9a\xae"}, // 🚮
    {":potable_water:", "\xf0\x9f\x9a\xb0"}, // 🚰
    {":wheelchair:", "\xe2\x99\xbf"}, // ♿
    {":mens:", "\xf0\x9f\x9a\xb9"}, // 🚹
    {":womens:", "\xf0\x9f\x9a\xba"}, // 🚺
    {":restroom:", "\xf0\x9f\x9a\xbb"}, // 🚻
    {":baby_symbol:", "\xf0\x9f\x9a\xbc"}, // 🚼
    {":wc:", "\xf0\x9f\x9a\xbe"}, // 🚾
    {":passport_control:", "\xf0\x9f\x9b\x82"}, // 🛂
    {":customs:", "\xf0\x9f\x9b\x83"}, // 🛃
    {":baggage_claim:", "\xf0\x9f\x9b\x84"}, // 🛄
    {":left_luggage:", "\xf0\x9f\x9b\x85"}, // 🛅
    {":warning:", "\xe2\x9a\xa0\xef\xb8\x8f"}, // ⚠️
    {":children_crossing:", "\xf0\x9f\x9a\xb8"}, // 🚸
    {":no_entry:", "\xe2\x9b\x94"}, // ⛔
    {":no_entry_sign:", "\xf0\x9f\x9a\xab"}, // 🚫
    {":no_bicycles:", "\xf0\x9f\x9a\xb3"}, // 🚳
    {":no_smoking:", "\xf0\x9f\x9a\xad"}, // 🚭
    {":do_not_litter:", "\xf0\x9f\x9a\xaf"}, // 🚯
    {":non-potable_water:", "\xf0\x9f\x9a\xb1"}, // 🚱
    {":no_pedestrians:", "\xf0\x9f\x9a\xb7"}, // 🚷
    {":no_mobile_phones:", "\xf0\x9f\x93\xb5"}, // 📵
    {":underage:", "\xf0\x9f\x94\x9e"}, // 🔞
    {":radioactive:", "\xe2\x98\xa2\xef\xb8\x8f"}, // ☢️
    {":biohazard:", "\xe2\x98\xa3\xef\xb8\x8f"}, // ☣️
    {":arrow_up:", "\xe2\xac\x86\xef\xb8\x8f"}, // ⬆️
    {":arrow_upper_right:", "\xe2\x86\x97\xef\xb8\x8f"}, // ↗️
    {":arrow_right:", "\xe2\x9e\xa1\xef\xb8\x8f"}, // ➡️
    {":arrow_lower_right:", "\xe2\x86\x98\xef\xb8\x8f"}, // ↘️
    {":arrow_down:", "\xe2\xac\x87\xef\xb8\x8f"}, // ⬇️
    {":arrow_lower_left:", "\xe2\x86\x99\xef\xb8\x8f"}, // ↙️
    {":arrow_left:", "\xe2\xac\x85\xef\xb8\x8f"}, // ⬅️
    {":arrow_upper_left:", "\xe2\x86\x96\xef\xb8\x8f"}, // ↖️
    {":arrow_up_down:", "\xe2\x86\x95\xef\xb8\x8f"}, // ↕️
    {":left_right_arrow:", "\xe2\x86\x94\xef\xb8\x8f"}, // ↔️
    {":leftwards_arrow_with_hook:", "\xe2\x86\xa9\xef\xb8\x8f"}, // ↩️
    {":arrow_right_hook:", "\xe2\x86\xaa\xef\xb8\x8f"}, // ↪️
    {":arrow_heading_up:", "\xe2\xa4\xb4\xef\xb8\x8f"}, // ⤴️
    {":arrow_heading_down:", "\xe2\xa4\xb5\xef\xb8\x8f"}, // ⤵️
    {":arrows_clockwise:", "\xf0\x9f\x94\x83"}, // 🔃
    {":arrows_counterclockwise:", "\xf0\x9f\x94\x84"}, // 🔄
    {":back:", "\xf0\x9f\x94\x99"}, // 🔙
    {":end:", "\xf0\x9f\x94\x9a"}, // 🔚
    {":on:", "\xf0\x9f\x94\x9b"}, // 🔛
    {":soon:", "\xf0\x9f\x94\x9c"}, // 🔜
    {":top:", "\xf0\x9f\x94\x9d"}, // 🔝
    {":place_of_worship:", "\xf0\x9f\x9b\x90"}, // 🛐
    {":atom_symbol:", "\xe2\x9a\x9b\xef\xb8\x8f"}, // ⚛️
    {":om:", "\xf0\x9f\x95\x89\xef\xb8\x8f"}, // 🕉️
    {":star_of_david:", "\xe2\x9c\xa1\xef\xb8\x8f"}, // ✡️
    {":wheel_of_dharma:", "\xe2\x98\xb8\xef\xb8\x8f"}, // ☸️
    {":yin_yang:", "\xe2\x98\xaf\xef\xb8\x8f"}, // ☯️
    {":latin_cross:", "\xe2\x9c\x9d\xef\xb8\x8f"}, // ✝️
    {":orthodox_cross:", "\xe2\x98\xa6\xef\xb8\x8f"}, // ☦️
    {":star_and_crescent:", "\xe2\x98\xaa\xef\xb8\x8f"}, // ☪️
    {":peace_symbol:", "\xe2\x98\xae\xef\xb8\x8f"}, // ☮️
    {":menorah:", "\xf0\x9f\x95\x8e"}, // 🕎
    {":six_pointed_star:", "\xf0\x9f\x94\xaf"}, // 🔯
    {":aries:", "\xe2\x99\x88"}, // ♈
    {":taurus:", "\xe2\x99\x89"}, // ♉
    {":gemini:", "\xe2\x99\x8a"}, // ♊
    {":cancer:", "\xe2\x99\x8b"}, // ♋
    {":leo:", "\xe2\x99\x8c"}, // ♌
    {":virgo:", "\xe2\x99\x8d"}, // ♍
    {":libra:", "\xe2\x99\x8e"}, // ♎
    {":scorpius:", "\xe2\x99\x8f"}, // ♏
    {":sagittarius:", "\xe2\x99\x90"}, // ♐
    {":capricorn:", "\xe2\x99\x91"}, // ♑
    {":aquarius:", "\xe2\x99\x92"}, // ♒
    {":pisces:", "\xe2\x99\x93"}, // ♓
    {":ophiuchus:", "\xe2\x9b\x8e"}, // ⛎
    {":twisted_rightwards_arrows:", "\xf0\x9f\x94\x80"}, // 🔀
    {":repeat:", "\xf0\x9f\x94\x81"}, // 🔁
    {":repeat_one:", "\xf0\x9f\x94\x82"}, // 🔂
    {":arrow_forward:", "\xe2\x96\xb6\xef\xb8\x8f"}, // ▶️
    {":fast_forward:", "\xe2\x8f\xa9"}, // ⏩
    {":next_track_button:", "\xe2\x8f\xad\xef\xb8\x8f"}, // ⏭️
    {":play_or_pause_button:", "\xe2\x8f\xaf\xef\xb8\x8f"}, // ⏯️
    {":arrow_backward:", "\xe2\x97\x80\xef\xb8\x8f"}, // ◀️
    {":rewind:", "\xe2\x8f\xaa"}, // ⏪
    {":previous_track_button:", "\xe2\x8f\xae\xef\xb8\x8f"}, // ⏮️
    {":arrow_up_small:", "\xf0\x9f\x94\xbc"}, // 🔼
    {":arrow_double_up:", "\xe2\x8f\xab"}, // ⏫
    {":arrow_down_small:", "\xf0\x9f\x94\xbd"}, // 🔽
    {":arrow_double_down:", "\xe2\x8f\xac"}, // ⏬
    {":pause_button:", "\xe2\x8f\xb8\xef\xb8\x8f"}, // ⏸️
    {":stop_button:", "\xe2\x8f\xb9\xef\xb8\x8f"}, // ⏹️
    {":record_button:", "\xe2\x8f\xba\xef\xb8\x8f"}, // ⏺️
    {":eject_button:", "\xe2\x8f\x8f\xef\xb8\x8f"}, // ⏏️
    {":cinema:", "\xf0\x9f\x8e\xa6"}, // 🎦
    {":low_brightness:", "\xf0\x9f\x94\x85"}, // 🔅
    {":high_brightness:", "\xf0\x9f\x94\x86"}, // 🔆
    {":signal_strength:", "\xf0\x9f\x93\xb6"}, // 📶
    {":vibration_mode:", "\xf0\x9f\x93\xb3"}, // 📳
    {":mobile_phone_off:", "\xf0\x9f\x93\xb4"}, // 📴
    {":female_sign:", "\xe2\x99\x80\xef\xb8\x8f"}, // ♀️
    {":male_sign:", "\xe2\x99\x82\xef\xb8\x8f"}, // ♂️
    {":transgender_symbol:", "\xe2\x9a\xa7\xef\xb8\x8f"}, // ⚧️
    {":heavy_multiplication_x:", "\xe2\x9c\x96\xef\xb8\x8f"}, // ✖️
    {":heavy_plus_sign:", "\xe2\x9e\x95"}, // ➕
    {":heavy_minus_sign:", "\xe2\x9e\x96"}, // ➖
    {":heavy_division_sign:", "\xe2\x9e\x97"}, // ➗
    {":infinity:", "\xe2\x99\xbe\xef\xb8\x8f"}, // ♾️
    {":bangbang:", "\xe2\x80\xbc\xef\xb8\x8f"}, // ‼️
    {":interrobang:", "\xe2\x81\x89\xef\xb8\x8f"}, // ⁉️
    {":question:", "\xe2\x9d\x93"}, // ❓
    {":grey_question:", "\xe2\x9d\x94"}, // ❔
    {":grey_exclamation:", "\xe2\x9d\x95"}, // ❕
    {":exclamation:", "\xe2\x9d\x97"}, // ❗
    {":heavy_exclamation_mark:", "\xe2\x9d\x97"}, // ❗
    {":wavy_dash:", "\xe3\x80\xb0\xef\xb8\x8f"}, // 〰️
    {":currency_exchange:", "\xf0\x9f\x92\xb1"}, // 💱
    {":heavy_dollar_sign:", "\xf0\x9f\x92\xb2"}, // 💲
    {":medical_symbol:", "\xe2\x9a\x95\xef\xb8\x8f"}, // ⚕️
    {":recycle:", "\xe2\x99\xbb\xef\xb8\x8f"}, // ♻️
    {":fleur_de_lis:", "\xe2\x9a\x9c\xef\xb8\x8f"}, // ⚜️
    {":trident:", "\xf0\x9f\x94\xb1"}, // 🔱
    {":name_badge:", "\xf0\x9f\x93\x9b"}, // 📛
    {":beginner:", "\xf0\x9f\x94\xb0"}, // 🔰
    {":o:", "\xe2\xad\x95"}, // ⭕
    {":white_check_mark:", "\xe2\x9c\x85"}, // ✅
    {":ballot_box_with_check:", "\xe2\x98\x91\xef\xb8\x8f"}, // ☑️
    {":heavy_check_mark:", "\xe2\x9c\x94\xef\xb8\x8f"}, // ✔️
    {":x:", "\xe2\x9d\x8c"}, // ❌
    {":negative_squared_cross_mark:", "\xe2\x9d\x8e"}, // ❎
    {":curly_loop:", "\xe2\x9e\xb0"}, // ➰
    {":loop:", "\xe2\x9e\xbf"}, // ➿
    {":part_alternation_mark:", "\xe3\x80\xbd\xef\xb8\x8f"}, // 〽️
    {":eight_spoked_asterisk:", "\xe2\x9c\xb3\xef\xb8\x8f"}, // ✳️
    {":eight_pointed_black_star:", "\xe2\x9c\xb4\xef\xb8\x8f"}, // ✴️
    {":sparkle:", "\xe2\x9d\x87\xef\xb8\x8f"}, // ❇️
    {":copyright:", "\xc2\xa9\xef\xb8\x8f"}, // ©️
    {":registered:", "\xc2\xae\xef\xb8\x8f"}, // ®️
    {":tm:", "\xe2\x84\xa2\xef\xb8\x8f"}, // ™️
    {":hash:", "\x23\xef\xb8\x8f\xe2\x83\xa3"}, // #️⃣
    {":asterisk:", "\x2a\xef\xb8\x8f\xe2\x83\xa3"}, // *️⃣
    {":zero:", "\x30\xef\xb8\x8f\xe2\x83\xa3"}, // 0️⃣
    {":one:", "\x31\xef\xb8\x8f\xe2\x83\xa3"}, // 1️⃣
    {":two:", "\x32\xef\xb8\x8f\xe2\x83\xa3"}, // 2️⃣
    {":three:", "\x33\xef\xb8\x8f\xe2\x83\xa3"}, // 3️⃣
    {":four:", "\x34\xef\xb8\x8f\xe2\x83\xa3"}, // 4️⃣
    {":five:", "\x35\xef\xb8\x8f\xe2\x83\xa3"}, // 5️⃣
    {":six:", "\x36\xef\xb8\x8f\xe2\x83\xa3"}, // 6️⃣
    {":seven:", "\x37\xef\xb8\x8f\xe2\x83\xa3"}, // 7️⃣
    {":eight:", "\x38\xef\xb8\x8f\xe2\x83\xa3"}, // 8️⃣
    {":nine:", "\x39\xef\xb8\x8f\xe2\x83\xa3"}, // 9️⃣
    {":keycap_ten:", "\xf0\x9f\x94\x9f"}, // 🔟
    {":capital_abcd:", "\xf0\x9f\x94\xa0"}, // 🔠
    {":abcd:", "\xf0\x9f\x94\xa1"}, // 🔡
    {":1234:", "\xf0\x9f\x94\xa2"}, // 🔢
    {":symbols:", "\xf0\x9f\x94\xa3"}, // 🔣
    {":abc:", "\xf0\x9f\x94\xa4"}, // 🔤
    {":a:", "\xf0\x9f\x85\xb0\xef\xb8\x8f"}, // 🅰️
    {":ab:", "\xf0\x9f\x86\x8e"}, // 🆎
    {":b:", "\xf0\x9f\x85\xb1\xef\xb8\x8f"}, // 🅱️
    {":cl:", "\xf0\x9f\x86\x91"}, // 🆑
    {":cool:", "\xf0\x9f\x86\x92"}, // 🆒
    {":free:", "\xf0\x9f\x86\x93"}, // 🆓
    {":information_source:", "\xe2\x84\xb9\xef\xb8\x8f"}, // ℹ️
    {":id:", "\xf0\x9f\x86\x94"}, // 🆔
    {":m:", "\xe2\x93\x82\xef\xb8\x8f"}, // Ⓜ️
    {":new:", "\xf0\x9f\x86\x95"}, // 🆕
    {":ng:", "\xf0\x9f\x86\x96"}, // 🆖
    {":o2:", "\xf0\x9f\x85\xbe\xef\xb8\x8f"}, // 🅾️
    {":ok:", "\xf0\x9f\x86\x97"}, // 🆗
    {":parking:", "\xf0\x9f\x85\xbf\xef\xb8\x8f"}, // 🅿️
    {":sos:", "\xf0\x9f\x86\x98"}, // 🆘
    {":up:", "\xf0\x9f\x86\x99"}, // 🆙
    {":vs:", "\xf0\x9f\x86\x9a"}, // 🆚
    {":koko:", "\xf0\x9f\x88\x81"}, // 🈁
    {":sa:", "\xf0\x9f\x88\x82\xef\xb8\x8f"}, // 🈂️
    {":u6708:", "\xf0\x9f\x88\xb7\xef\xb8\x8f"}, // 🈷️
    {":u6709:", "\xf0\x9f\x88\xb6"}, // 🈶
    {":u6307:", "\xf0\x9f\x88\xaf"}, // 🈯
    {":ideograph_advantage:", "\xf0\x9f\x89\x90"}, // 🉐
    {":u5272:", "\xf0\x9f\x88\xb9"}, // 🈹
    {":u7121:", "\xf0\x9f\x88\x9a"}, // 🈚
    {":u7981:", "\xf0\x9f\x88\xb2"}, // 🈲
    {":accept:", "\xf0\x9f\x89\x91"}, // 🉑
    {":u7533:", "\xf0\x9f\x88\xb8"}, // 🈸
    {":u5408:", "\xf0\x9f\x88\xb4"}, // 🈴
    {":u7a7a:", "\xf0\x9f\x88\xb3"}, // 🈳
    {":congratulations:", "\xe3\x8a\x97\xef\xb8\x8f"}, // ㊗️
    {":secret:", "\xe3\x8a\x99\xef\xb8\x8f"}, // ㊙️
    {":u55b6:", "\xf0\x9f\x88\xba"}, // 🈺
    {":u6e80:", "\xf0\x9f\x88\xb5"}, // 🈵
    {":red_circle:", "\xf0\x9f\x94\xb4"}, // 🔴
    {":orange_circle:", "\xf0\x9f\x9f\xa0"}, // 🟠
    {":yellow_circle:", "\xf0\x9f\x9f\xa1"}, // 🟡
    {":green_circle:", "\xf0\x9f\x9f\xa2"}, // 🟢
    {":large_blue_circle:", "\xf0\x9f\x94\xb5"}, // 🔵
    {":purple_circle:", "\xf0\x9f\x9f\xa3"}, // 🟣
    {":brown_circle:", "\xf0\x9f\x9f\xa4"}, // 🟤
    {":black_circle:", "\xe2\x9a\xab"}, // ⚫
    {":white_circle:", "\xe2\x9a\xaa"}, // ⚪
    {":red_square:", "\xf0\x9f\x9f\xa5"}, // 🟥
    {":orange_square:", "\xf0\x9f\x9f\xa7"}, // 🟧
    {":yellow_square:", "\xf0\x9f\x9f\xa8"}, // 🟨
    {":green_square:", "\xf0\x9f\x9f\xa9"}, // 🟩
    {":blue_square:", "\xf0\x9f\x9f\xa6"}, // 🟦
    {":purple_square:", "\xf0\x9f\x9f\xaa"}, // 🟪
    {":brown_square:", "\xf0\x9f\x9f\xab"}, // 🟫
    {":black_large_square:", "\xe2\xac\x9b"}, // ⬛
    {":white_large_square:", "\xe2\xac\x9c"}, // ⬜
    {":black_medium_square:", "\xe2\x97\xbc\xef\xb8\x8f"}, // ◼️
    {":white_medium_square:", "\xe2\x97\xbb\xef\xb8\x8f"}, // ◻️
    {":black_medium_small_square:", "\xe2\x97\xbe"}, // ◾
    {":white_medium_small_square:", "\xe2\x97\xbd"}, // ◽
    {":black_small_square:", "\xe2\x96\xaa\xef\xb8\x8f"}, // ▪️
    {":white_small_square:", "\xe2\x96\xab\xef\xb8\x8f"}, // ▫️
    {":large_orange_diamond:", "\xf0\x9f\x94\xb6"}, // 🔶
    {":large_blue_diamond:", "\xf0\x9f\x94\xb7"}, // 🔷
    {":small_orange_diamond:", "\xf0\x9f\x94\xb8"}, // 🔸
    {":small_blue_diamond:", "\xf0\x9f\x94\xb9"}, // 🔹
    {":small_red_triangle:", "\xf0\x9f\x94\xba"}, // 🔺
    {":small_red_triangle_down:", "\xf0\x9f\x94\xbb"}, // 🔻
    {":diamond_shape_with_a_dot_inside:", "\xf0\x9f\x92\xa0"}, // 💠
    {":radio_button:", "\xf0\x9f\x94\x98"}, // 🔘
    {":white_square_button:", "\xf0\x9f\x94\xb3"}, // 🔳
    {":black_square_button:", "\xf0\x9f\x94\xb2"}, // 🔲
    {":checkered_flag:", "\xf0\x9f\x8f\x81"}, // 🏁
    {":triangular_flag_on_post:", "\xf0\x9f\x9a\xa9"}, // 🚩
    {":crossed_flags:", "\xf0\x9f\x8e\x8c"}, // 🎌
    {":black_flag:", "\xf0\x9f\x8f\xb4"}, // 🏴
    {":white_flag:", "\xf0\x9f\x8f\xb3\xef\xb8\x8f"}, // 🏳️
    {":rainbow_flag:", "\xf0\x9f\x8f\xb3\xef\xb8\x8f\xe2\x80\x8d\xf0\x9f\x8c\x88"}, // 🏳️‍🌈
    {":transgender_flag:", "\xf0\x9f\x8f\xb3\xef\xb8\x8f\xe2\x80\x8d\xe2\x9a\xa7\xef\xb8\x8f"}, // 🏳️‍⚧️
    {":pirate_flag:", "\xf0\x9f\x8f\xb4\xe2\x80\x8d\xe2\x98\xa0\xef\xb8\x8f"}, // 🏴‍☠️
    {":ascension_island:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xa8"}, // 🇦🇨
    {":andorra:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xa9"}, // 🇦🇩
    {":united_arab_emirates:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xaa"}, // 🇦🇪
    {":afghanistan:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xab"}, // 🇦🇫
    {":antigua_barbuda:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xac"}, // 🇦🇬
    {":anguilla:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xae"}, // 🇦🇮
    {":albania:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xb1"}, // 🇦🇱
    {":armenia:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xb2"}, // 🇦🇲
    {":angola:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xb4"}, // 🇦🇴
    {":antarctica:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xb6"}, // 🇦🇶
    {":argentina:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xb7"}, // 🇦🇷
    {":american_samoa:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xb8"}, // 🇦🇸
    {":austria:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xb9"}, // 🇦🇹
    {":australia:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xba"}, // 🇦🇺
    {":aruba:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xbc"}, // 🇦🇼
    {":aland_islands:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xbd"}, // 🇦🇽
    {":azerbaijan:", "\xf0\x9f\x87\xa6\xf0\x9f\x87\xbf"}, // 🇦🇿
    {":bosnia_herzegovina:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xa6"}, // 🇧🇦
    {":barbados:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xa7"}, // 🇧🇧
    {":bangladesh:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xa9"}, // 🇧🇩
    {":belgium:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xaa"}, // 🇧🇪
    {":burkina_faso:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xab"}, // 🇧🇫
    {":bulgaria:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xac"}, // 🇧🇬
    {":bahrain:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xad"}, // 🇧🇭
    {":burundi:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xae"}, // 🇧🇮
    {":benin:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xaf"}, // 🇧🇯
    {":st_barthelemy:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb1"}, // 🇧🇱
    {":bermuda:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb2"}, // 🇧🇲
    {":brunei:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb3"}, // 🇧🇳
    {":bolivia:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb4"}, // 🇧🇴
    {":caribbean_netherlands:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb6"}, // 🇧🇶
    {":brazil:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb7"}, // 🇧🇷
    {":bahamas:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb8"}, // 🇧🇸
    {":bhutan:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xb9"}, // 🇧🇹
    {":bouvet_island:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xbb"}, // 🇧🇻
    {":botswana:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xbc"}, // 🇧🇼
    {":belarus:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xbe"}, // 🇧🇾
    {":belize:", "\xf0\x9f\x87\xa7\xf0\x9f\x87\xbf"}, // 🇧🇿
    {":canada:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xa6"}, // 🇨🇦
    {":cocos_islands:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xa8"}, // 🇨🇨
    {":congo_kinshasa:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xa9"}, // 🇨🇩
    {":central_african_republic:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xab"}, // 🇨🇫
    {":congo_brazzaville:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xac"}, // 🇨🇬
    {":switzerland:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xad"}, // 🇨🇭
    {":cote_divoire:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xae"}, // 🇨🇮
    {":cook_islands:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xb0"}, // 🇨🇰
    {":chile:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xb1"}, // 🇨🇱
    {":cameroon:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xb2"}, // 🇨🇲
    {":cn:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xb3"}, // 🇨🇳
    {":colombia:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xb4"}, // 🇨🇴
    {":clipperton_island:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xb5"}, // 🇨🇵
    {":costa_rica:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xb7"}, // 🇨🇷
    {":cuba:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xba"}, // 🇨🇺
    {":cape_verde:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xbb"}, // 🇨🇻
    {":curacao:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xbc"}, // 🇨🇼
    {":christmas_island:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xbd"}, // 🇨🇽
    {":cyprus:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xbe"}, // 🇨🇾
    {":czech_republic:", "\xf0\x9f\x87\xa8\xf0\x9f\x87\xbf"}, // 🇨🇿
    {":de:", "\xf0\x9f\x87\xa9\xf0\x9f\x87\xaa"}, // 🇩🇪
    {":diego_garcia:", "\xf0\x9f\x87\xa9\xf0\x9f\x87\xac"}, // 🇩🇬
    {":djibouti:", "\xf0\x9f\x87\xa9\xf0\x9f\x87\xaf"}, // 🇩🇯
    {":denmark:", "\xf0\x9f\x87\xa9\xf0\x9f\x87\xb0"}, // 🇩🇰
    {":dominica:", "\xf0\x9f\x87\xa9\xf0\x9f\x87\xb2"}, // 🇩🇲
    {":dominican_republic:", "\xf0\x9f\x87\xa9\xf0\x9f\x87\xb4"}, // 🇩🇴
    {":algeria:", "\xf0\x9f\x87\xa9\xf0\x9f\x87\xbf"}, // 🇩🇿
    {":ceuta_melilla:", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xa6"}, // 🇪🇦
    {":ecuador:", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xa8"}, // 🇪🇨
    {":estonia:", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xaa"}, // 🇪🇪
    {":egypt:", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xac"}, // 🇪🇬
    {":western_sahara:", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xad"}, // 🇪🇭
    {":eritrea:", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xb7"}, // 🇪🇷
    {":es:", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xb8"}, // 🇪🇸
    {":ethiopia:", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xb9"}, // 🇪🇹
    {":eu:", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xba"}, // 🇪🇺
    {":european_union:", "\xf0\x9f\x87\xaa\xf0\x9f\x87\xba"}, // 🇪🇺
    {":finland:", "\xf0\x9f\x87\xab\xf0\x9f\x87\xae"}, // 🇫🇮
    {":fiji:", "\xf0\x9f\x87\xab\xf0\x9f\x87\xaf"}, // 🇫🇯
    {":falkland_islands:", "\xf0\x9f\x87\xab\xf0\x9f\x87\xb0"}, // 🇫🇰
    {":micronesia:", "\xf0\x9f\x87\xab\xf0\x9f\x87\xb2"}, // 🇫🇲
    {":faroe_islands:", "\xf0\x9f\x87\xab\xf0\x9f\x87\xb4"}, // 🇫🇴
    {":fr:", "\xf0\x9f\x87\xab\xf0\x9f\x87\xb7"}, // 🇫🇷
    {":gabon:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xa6"}, // 🇬🇦
    {":gb:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xa7"}, // 🇬🇧
    {":uk:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xa7"}, // 🇬🇧
    {":grenada:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xa9"}, // 🇬🇩
    {":georgia:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xaa"}, // 🇬🇪
    {":french_guiana:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xab"}, // 🇬🇫
    {":guernsey:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xac"}, // 🇬🇬
    {":ghana:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xad"}, // 🇬🇭
    {":gibraltar:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xae"}, // 🇬🇮
    {":greenland:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb1"}, // 🇬🇱
    {":gambia:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb2"}, // 🇬🇲
    {":guinea:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb3"}, // 🇬🇳
    {":guadeloupe:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb5"}, // 🇬🇵
    {":equatorial_guinea:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb6"}, // 🇬🇶
    {":greece:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb7"}, // 🇬🇷
    {":south_georgia_south_sandwich_islands:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb8"}, // 🇬🇸
    {":guatemala:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xb9"}, // 🇬🇹
    {":guam:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xba"}, // 🇬🇺
    {":guinea_bissau:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xbc"}, // 🇬🇼
    {":guyana:", "\xf0\x9f\x87\xac\xf0\x9f\x87\xbe"}, // 🇬🇾
    {":hong_kong:", "\xf0\x9f\x87\xad\xf0\x9f\x87\xb0"}, // 🇭🇰
    {":heard_mcdonald_islands:", "\xf0\x9f\x87\xad\xf0\x9f\x87\xb2"}, // 🇭🇲
    {":honduras:", "\xf0\x9f\x87\xad\xf0\x9f\x87\xb3"}, // 🇭🇳
    {":croatia:", "\xf0\x9f\x87\xad\xf0\x9f\x87\xb7"}, // 🇭🇷
    {":haiti:", "\xf0\x9f\x87\xad\xf0\x9f\x87\xb9"}, // 🇭🇹
    {":hungary:", "\xf0\x9f\x87\xad\xf0\x9f\x87\xba"}, // 🇭🇺
    {":canary_islands:", "\xf0\x9f\x87\xae\xf0\x9f\x87\xa8"}, // 🇮🇨
    {":indonesia:", "\xf0\x9f\x87\xae\xf0\x9f\x87\xa9"}, // 🇮🇩
    {":ireland:", "\xf0\x9f\x87\xae\xf0\x9f\x87\xaa"}, // 🇮🇪
    {":israel:", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb1"}, // 🇮🇱
    {":isle_of_man:", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb2"}, // 🇮🇲
    {":india:", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb3"}, // 🇮🇳
    {":british_indian_ocean_territory:", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb4"}, // 🇮🇴
    {":iraq:", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb6"}, // 🇮🇶
    {":iran:", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb7"}, // 🇮🇷
    {":iceland:", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb8"}, // 🇮🇸
    {":it:", "\xf0\x9f\x87\xae\xf0\x9f\x87\xb9"}, // 🇮🇹
    {":jersey:", "\xf0\x9f\x87\xaf\xf0\x9f\x87\xaa"}, // 🇯🇪
    {":jamaica:", "\xf0\x9f\x87\xaf\xf0\x9f\x87\xb2"}, // 🇯🇲
    {":jordan:", "\xf0\x9f\x87\xaf\xf0\x9f\x87\xb4"}, // 🇯🇴
    {":jp:", "\xf0\x9f\x87\xaf\xf0\x9f\x87\xb5"}, // 🇯🇵
    {":kenya:", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xaa"}, // 🇰🇪
    {":kyrgyzstan:", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xac"}, // 🇰🇬
    {":cambodia:", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xad"}, // 🇰🇭
    {":kiribati:", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xae"}, // 🇰🇮
    {":comoros:", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xb2"}, // 🇰🇲
    {":st_kitts_nevis:", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xb3"}, // 🇰🇳
    {":north_korea:", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xb5"}, // 🇰🇵
    {":kr:", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xb7"}, // 🇰🇷
    {":kuwait:", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xbc"}, // 🇰🇼
    {":cayman_islands:", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xbe"}, // 🇰🇾
    {":kazakhstan:", "\xf0\x9f\x87\xb0\xf0\x9f\x87\xbf"}, // 🇰🇿
    {":laos:", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xa6"}, // 🇱🇦
    {":lebanon:", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xa7"}, // 🇱🇧
    {":st_lucia:", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xa8"}, // 🇱🇨
    {":liechtenstein:", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xae"}, // 🇱🇮
    {":sri_lanka:", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xb0"}, // 🇱🇰
    {":liberia:", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xb7"}, // 🇱🇷
    {":lesotho:", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xb8"}, // 🇱🇸
    {":lithuania:", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xb9"}, // 🇱🇹
    {":luxembourg:", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xba"}, // 🇱🇺
    {":latvia:", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xbb"}, // 🇱🇻
    {":libya:", "\xf0\x9f\x87\xb1\xf0\x9f\x87\xbe"}, // 🇱🇾
    {":morocco:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xa6"}, // 🇲🇦
    {":monaco:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xa8"}, // 🇲🇨
    {":moldova:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xa9"}, // 🇲🇩
    {":montenegro:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xaa"}, // 🇲🇪
    {":st_martin:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xab"}, // 🇲🇫
    {":madagascar:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xac"}, // 🇲🇬
    {":marshall_islands:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xad"}, // 🇲🇭
    {":macedonia:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb0"}, // 🇲🇰
    {":mali:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb1"}, // 🇲🇱
    {":myanmar:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb2"}, // 🇲🇲
    {":mongolia:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb3"}, // 🇲🇳
    {":macau:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb4"}, // 🇲🇴
    {":northern_mariana_islands:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb5"}, // 🇲🇵
    {":martinique:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb6"}, // 🇲🇶
    {":mauritania:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb7"}, // 🇲🇷
    {":montserrat:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb8"}, // 🇲🇸
    {":malta:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xb9"}, // 🇲🇹
    {":mauritius:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xba"}, // 🇲🇺
    {":maldives:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xbb"}, // 🇲🇻
    {":malawi:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xbc"}, // 🇲🇼
    {":mexico:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xbd"}, // 🇲🇽
    {":malaysia:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xbe"}, // 🇲🇾
    {":mozambique:", "\xf0\x9f\x87\xb2\xf0\x9f\x87\xbf"}, // 🇲🇿
    {":namibia:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xa6"}, // 🇳🇦
    {":new_caledonia:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xa8"}, // 🇳🇨
    {":niger:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xaa"}, // 🇳🇪
    {":norfolk_island:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xab"}, // 🇳🇫
    {":nigeria:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xac"}, // 🇳🇬
    {":nicaragua:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xae"}, // 🇳🇮
    {":netherlands:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xb1"}, // 🇳🇱
    {":norway:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xb4"}, // 🇳🇴
    {":nepal:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xb5"}, // 🇳🇵
    {":nauru:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xb7"}, // 🇳🇷
    {":niue:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xba"}, // 🇳🇺
    {":new_zealand:", "\xf0\x9f\x87\xb3\xf0\x9f\x87\xbf"}, // 🇳🇿
    {":oman:", "\xf0\x9f\x87\xb4\xf0\x9f\x87\xb2"}, // 🇴🇲
    {":panama:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xa6"}, // 🇵🇦
    {":peru:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xaa"}, // 🇵🇪
    {":french_polynesia:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xab"}, // 🇵🇫
    {":papua_new_guinea:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xac"}, // 🇵🇬
    {":philippines:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xad"}, // 🇵🇭
    {":pakistan:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xb0"}, // 🇵🇰
    {":poland:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xb1"}, // 🇵🇱
    {":st_pierre_miquelon:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xb2"}, // 🇵🇲
    {":pitcairn_islands:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xb3"}, // 🇵🇳
    {":puerto_rico:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xb7"}, // 🇵🇷
    {":palestinian_territories:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xb8"}, // 🇵🇸
    {":portugal:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xb9"}, // 🇵🇹
    {":palau:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xbc"}, // 🇵🇼
    {":paraguay:", "\xf0\x9f\x87\xb5\xf0\x9f\x87\xbe"}, // 🇵🇾
    {":qatar:", "\xf0\x9f\x87\xb6\xf0\x9f\x87\xa6"}, // 🇶🇦
    {":reunion:", "\xf0\x9f\x87\xb7\xf0\x9f\x87\xaa"}, // 🇷🇪
    {":romania:", "\xf0\x9f\x87\xb7\xf0\x9f\x87\xb4"}, // 🇷🇴
    {":serbia:", "\xf0\x9f\x87\xb7\xf0\x9f\x87\xb8"}, // 🇷🇸
    {":ru:", "\xf0\x9f\x87\xb7\xf0\x9f\x87\xba"}, // 🇷🇺
    {":rwanda:", "\xf0\x9f\x87\xb7\xf0\x9f\x87\xbc"}, // 🇷🇼
    {":saudi_arabia:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xa6"}, // 🇸🇦
    {":solomon_islands:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xa7"}, // 🇸🇧
    {":seychelles:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xa8"}, // 🇸🇨
    {":sudan:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xa9"}, // 🇸🇩
    {":sweden:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xaa"}, // 🇸🇪
    {":singapore:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xac"}, // 🇸🇬
    {":st_helena:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xad"}, // 🇸🇭
    {":slovenia:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xae"}, // 🇸🇮
    {":svalbard_jan_mayen:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xaf"}, // 🇸🇯
    {":slovakia:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb0"}, // 🇸🇰
    {":sierra_leone:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb1"}, // 🇸🇱
    {":san_marino:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb2"}, // 🇸🇲
    {":senegal:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb3"}, // 🇸🇳
    {":somalia:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb4"}, // 🇸🇴
    {":suriname:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb7"}, // 🇸🇷
    {":south_sudan:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb8"}, // 🇸🇸
    {":sao_tome_principe:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xb9"}, // 🇸🇹
    {":el_salvador:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xbb"}, // 🇸🇻
    {":sint_maarten:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xbd"}, // 🇸🇽
    {":syria:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xbe"}, // 🇸🇾
    {":swaziland:", "\xf0\x9f\x87\xb8\xf0\x9f\x87\xbf"}, // 🇸🇿
    {":tristan_da_cunha:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xa6"}, // 🇹🇦
    {":turks_caicos_islands:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xa8"}, // 🇹🇨
    {":chad:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xa9"}, // 🇹🇩
    {":french_southern_territories:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xab"}, // 🇹🇫
    {":togo:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xac"}, // 🇹🇬
    {":thailand:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xad"}, // 🇹🇭
    {":tajikistan:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xaf"}, // 🇹🇯
    {":tokelau:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xb0"}, // 🇹🇰
    {":timor_leste:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xb1"}, // 🇹🇱
    {":turkmenistan:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xb2"}, // 🇹🇲
    {":tunisia:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xb3"}, // 🇹🇳
    {":tonga:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xb4"}, // 🇹🇴
    {":tr:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xb7"}, // 🇹🇷
    {":trinidad_tobago:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xb9"}, // 🇹🇹
    {":tuvalu:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xbb"}, // 🇹🇻
    {":taiwan:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xbc"}, // 🇹🇼
    {":tanzania:", "\xf0\x9f\x87\xb9\xf0\x9f\x87\xbf"}, // 🇹🇿
    {":ukraine:", "\xf0\x9f\x87\xba\xf0\x9f\x87\xa6"}, // 🇺🇦
    {":uganda:", "\xf0\x9f\x87\xba\xf0\x9f\x87\xac"}, // 🇺🇬
    {":us_outlying_islands:", "\xf0\x9f\x87\xba\xf0\x9f\x87\xb2"}, // 🇺🇲
    {":united_nations:", "\xf0\x9f\x87\xba\xf0\x9f\x87\xb3"}, // 🇺🇳
    {":us:", "\xf0\x9f\x87\xba\xf0\x9f\x87\xb8"}, // 🇺🇸
    {":uruguay:", "\xf0\x9f\x87\xba\xf0\x9f\x87\xbe"}, // 🇺🇾
    {":uzbekistan:", "\xf0\x9f\x87\xba\xf0\x9f\x87\xbf"}, // 🇺🇿
    {":vatican_city:", "\xf0\x9f\x87\xbb\xf0\x9f\x87\xa6"}, // 🇻🇦
    {":st_vincent_grenadines:", "\xf0\x9f\x87\xbb\xf0\x9f\x87\xa8"}, // 🇻🇨
    {":venezuela:", "\xf0\x9f\x87\xbb\xf0\x9f\x87\xaa"}, // 🇻🇪
    {":british_virgin_islands:", "\xf0\x9f\x87\xbb\xf0\x9f\x87\xac"}, // 🇻🇬
    {":us_virgin_islands:", "\xf0\x9f\x87\xbb\xf0\x9f\x87\xae"}, // 🇻🇮
    {":vietnam:", "\xf0\x9f\x87\xbb\xf0\x9f\x87\xb3"}, // 🇻🇳
    {":vanuatu:", "\xf0\x9f\x87\xbb\xf0\x9f\x87\xba"}, // 🇻🇺
    {":wallis_futuna:", "\xf0\x9f\x87\xbc\xf0\x9f\x87\xab"}, // 🇼🇫
    {":samoa:", "\xf0\x9f\x87\xbc\xf0\x9f\x87\xb8"}, // 🇼🇸
    {":kosovo:", "\xf0\x9f\x87\xbd\xf0\x9f\x87\xb0"}, // 🇽🇰
    {":yemen:", "\xf0\x9f\x87\xbe\xf0\x9f\x87\xaa"}, // 🇾🇪
    {":mayotte:", "\xf0\x9f\x87\xbe\xf0\x9f\x87\xb9"}, // 🇾🇹
    {":south_africa:", "\xf0\x9f\x87\xbf\xf0\x9f\x87\xa6"}, // 🇿🇦
    {":zambia:", "\xf0\x9f\x87\xbf\xf0\x9f\x87\xb2"}, // 🇿🇲
    {":zimbabwe:", "\xf0\x9f\x87\xbf\xf0\x9f\x87\xbc"}, // 🇿🇼
    {":england:", "\xf0\x9f\x8f\xb4\xf3\xa0\x81\xa7\xf3\xa0\x81\xa2\xf3\xa0\x81\xa5\xf3\xa0\x81\xae\xf3\xa0\x81\xa7\xf3\xa0\x81\xbf"}, // 🏴󠁧󠁢󠁥󠁮󠁧󠁿
    {":scotland:", "\xf0\x9f\x8f\xb4\xf3\xa0\x81\xa7\xf3\xa0\x81\xa2\xf3\xa0\x81\xb3\xf3\xa0\x81\xa3\xf3\xa0\x81\xb4\xf3\xa0\x81\xbf"}, // 🏴󠁧󠁢󠁳󠁣󠁴󠁿
    {":wales:", "\xf0\x9f\x8f\xb4\xf3\xa0\x81\xa7\xf3\xa0\x81\xa2\xf3\xa0\x81\xb7\xf3\xa0\x81\xac\xf3\xa0\x81\xb3\xf3\xa0\x81\xbf"}, // 🏴󠁧󠁢󠁷󠁬󠁳󠁿
    {NULL, NULL}
};
#endif
