//-----------------------------------------------------------------------------
// Borrowed initially from
// https://raw.githubusercontent.com/LudovicRousseau/pcsc-tools/master/smartcard_list.txt
// Copyright (C) 2002-2021  Ludovic Rousseau
// Copyright (C) Proxmark3 contributors. See AUTHORS.md for details.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// See LICENSE.txt for the text of the license.
//-----------------------------------------------------------------------------
#ifndef ATRS_H__

#define ATRS_H__
#include <stddef.h>

typedef struct atr_s {
    const char *bytes;
    const char *desc;
} atr_t;

const char *getAtrInfo(const char *atr_str);

// atr_t array is expected to be NULL terminated
const static atr_t AtrTable[] = {
    { "3BDF18FFC080B1FE751F033078464646462026204963656D616E1D", "Cardhelper by 0xFFFF and Iceman" },
    { "3B..............0031B8640000000073......829000", "MultiApp ID IAS ECC 72K CC (with IAS XL / IAS ECC Applet) IAS ECC Type 3" },
    { "3B..............0031B8640000000073......829000..", "MultiApp ID IAS ECC 72K CC (with IAS XL / IAS ECC Applet) IAS ECC Type 4" },
    { "3B........0031B864........73......829000", "IDClassic IAS (old name: IAS TPC) IAS ECC Type 1\nMultiApp ID IAS ECC 72K CC (with IAS XL / IAS ECC Applet) IAS ECC Type 1" },
    { "3B........813180430031B864........73......829000", "IDClassic IAS (old name: IAS TPC) IAS ECC Type 1, T=1\nMultiApp ID IAS ECC 72K CC (with IAS XL / IAS ECC Applet) IAS ECC Type 2" },
    { "3B......0031B864........73......829000A3", "IDClassic IAS (old name: IAS TPC)\nIAS ECC Type 1 Contactless Prox-DU" },
    { "3B....417374726964", "Axalto Cryptoflex .NET" },
    { "3B003B28003441454130323030", "Cryptoguard card used for pay tv Plustelka (DVB-T2 - Slovak) (Pay TV)\nhttps://www.plustelka.sk/" },
    { "3B021050", "Visa  (Bank)" },
    { "3B02141C", "UAE (United Arab Emirates) (eID)" },
    { "3B021450", "Schlumberger Multiflex 3k" },
    { "3B02145011", "Maste visa card (Bank)" },
    { "3B021451", "8A (Bank)" },
    { "3B021540", "MasterCard  (Bank)" },
    { "3B02309201240016070000", "Credit (Bank)" },
    { "3B023602", "EMTG56 0.2" },
    { "3B025201", "EMTCG256-3G 0.1" },
    { "3B025301", "Gemplus GemClub Memo\nSuperShop clubcard" },
    { "3B026F33", "Polish national PKI equivalent to national id card issued by Eurocert - 1 of 2 Polish authorized issuers (PKI)\nhttps://eurocert.pl/index.php/en-us/" },
    { "3B0400000000", "Laundromat payment card\nSpanish ID ('DNIe: Documento Nacional de Identidad electronico).\nhttp://www.dnie.es/" },
    { "3B0400000073", "ASE M2 Card (I2C) (Other)" },
    { "3B0400040000", "Italian healtcare card (TS) National Service Card (CNS) - Regione Lazio - (HealthCare)\nhttp://cns.regione.lazio.it" },
    { "3B0401020304", "SLE4442 - memory card (256) with write protection PIN. (Other)" },
    { "3B0405D486C8", "Telstra (Telecom Australia) Pay Phone Phonecard (Telecommunication)\nhttps://www.telstra.com.au/home-phone/calling-cards" },
    { "3B04073C8592", "OLD Spanish Prepaid phone cards (pesetas) provided by Telefonica" },
    { "3B04073C859A", "OLD Spanish Prepaid phone cards (pesetas) provided by Telefonica" },
    { "3B04073C8910", "OLD Spanish Prepaid phone cards (pesetas) provided by Telefonica" },
    { "3B04073C8918", "OLD Spanish Prepaid phone cards (pesetas) provided by Telefonica" },
    { "3B04073C8992", "OLD Spanish Prepaid phone cards (pesetas) provided by Telefonica" },
    { "3B04073C899A", "OLD Spanish Prepaid phone cards (pesetas) provided by Telefonica" },
    { "3B04073C8C10", "OLD Spanish Prepaid phone cards (pesetas) provided by Telefonica" },
    { "3B04099C2B83", "T.P.G. - CART@BONUS 20CHF (Transport)\nhttp://www.tpg.ch/fr/titres-de-transport/moyens-de-paiement/carte-prepayee-cartabonus.php" },
    { "3B040A1CD1C4", "Lift (Transport)" },
    { "3B04173CCCE0", "prepaid payphone card, issued by Telefonica Comunicaciones Publicas\nhttp://www.cabitel.es" },
    { "3B0417D43000", "Gemalto BONZA game smart-card. (Other)" },
    { "3B0417D46608", "Prepaid public telephone card from Antel, Uruguay. (Telecommunication)" },
    { "3B0417D4C882", "prepaid payphone card, issued by Lietuvos Telekomas (now Teo LT)\nhttps://www.teo.lt/" },
    { "3B041BF43F54", "German TelefonKarte 50DM. Memory card with Solaic chip (Other)" },
    { "3B042AFF3200", "Mac Gray Intelligent Laundry Systems laundry card" },
    { "3B0441117781", "Sample Mifare DESFire contactless smartcard from Phillips" },
    { "3B04411177B1", "IBM JCOP 30 contactless" },
    { "3B044932432E", "German Health Insurance Card\n'LogCard' from concept2.com (a indoor rower manufacturer)\nI2C card" },
    { "3B0450D7F30E", "Ukranian memory card for public phones. Manufacturer: 'Kvazar' (Other)" },
    { "3B046089", "Smartcard 3.1 (JavaCard)" },
    { "3B04696C2065", "ASE M2 Card 2Kbit (Other)" },
    { "3B047F010000", "Russian memory card for payphones. Manufacturer: 'Exiton' (Other)" },
    { "3B0492231091", "Siemens SLE 4432/42 card" },
    { "3B04989400C4", "Windsor and Maidenhead Advantage Card\nhttp://www.rbwm.gov.uk/web/advantage_index.htm" },
    { "3B0499FFFF90", "Madrid prepaid parkimeters parking card" },
    { "3B049CFF2143", "Hercules laundry stored value card" },
    { "3B04A2010000", "Hospital's expenditure (HealthCare)" },
    { "3B04A2131091", "PM2P Chipkarte SLE 4442, Code FFFFFF\nBahn BKK (Deutsche Bahn AG - Insurance Company)\nNH Hotels World fidelization card\nMiele Professional card for paying washing machine\nSLE5542 Memory Card (Other)\nhttps://www.acs.com.hk/download-manual/6009/TDS_SLE5542.pdf" },
    { "3B04C9D0F140", "Cuban prepaid phone card provided by ETECSA" },
    { "3B04C9D5FD20", "Bell Canada LaPuce card - prepaid phone card (Telecommunication)" },
    { "3B04F0F03696", "Mooltipass Smartcard (Other)\nhttps://www.themooltipass.com/" },
    { "3B04FEFEFEFE", "Lawyers identity card (eID)\nhttps://www.abogacia.es/site/aca/que-es-aca-y-que-ventajas-te-ofrece/" },
    { "3B04FF1F0000", "master card (Bank)" },
    { "3B04FFFFFFFF", "Identity card Universidad del Pais Vasco / Euskal Herriko Unibertsitatea www.ehu.es" },
    { "3B0500033666AE", "HID (eID)" },
    { "3B056801010205", "Certinomis card (electronic certificates)\nSchlumberger Cryptoflex ActivCard" },
    { "3B058073F701C0", "(Shenzhen, China) Mingwah Aohan eKey, eID\nhttp://en.mwcard.com/index.php?option=com_k2&view=item&layout=item&id=79&Itemid=439" },
    { "3B060000042ECF4C", "HID 1346 ProxKey III\nhttp://www.hidglobal.com/products/cards-and-credentials/hid-proximity/1346" },
    { "3B06000564032B2B", "HID 0009 P (eID)" },
    { "3B06001001D6C546", "HID ProxKey II FOB\nhttp://www.hidglobal.com/documents/proxkey_ds_en.pdf" },
    { "3B0601........", "HID Prox H10301 Format\n26 bit (FAC+CN)\nhttps://www.hidglobal.com/sites/default/files/omnikey_contactless_developer_guide.pdf" },
    { "3B06010002009606", "EM4200 (eID)\nhttps://www.emmicroelectronic.com/product/lf-animal-access-ics/em4200" },
    { "3B06010010000660", "Access card for parking garage in South Boston (Other)" },
    { "3B06010022018227", "HID ProxCard II (Other)" },
    { "3B06010100001073", "HID Prox 26-bit (eID)" },
    { "3B06010102000001", "HID0009P (eID)" },
    { "3B06010210......", "ISOProx II Card:\nhttp://www.hidglobal.com/documents/isoprox_ds_en.pdf" },
    { "3B0602..........", "HID Prox H10302 Format\n37 bit (CN)\nhttps://www.hidglobal.com/sites/default/files/omnikey_contactless_developer_guide.pdf" },
    { "3B0604..........", "HID Prox H10304 Format\n37 bit (FAC+CN)\nhttps://www.hidglobal.com/sites/default/files/omnikey_contactless_developer_guide.pdf" },
    { "3B0614........", "HID Prox H10302 Format\n32 bit clock/data card\nhttps://www.hidglobal.com/sites/default/files/omnikey_contactless_developer_guide.pdf" },
    { "3B0614..........", "HID Prox Corp 1000 Format\n35 bit (CIC+CN)\nhttps://www.hidglobal.com/sites/default/files/omnikey_contactless_developer_guide.pdf" },
    { "3B062A0101010005", "Driving Licence  (Transport)" },
    { "3B06812480809000", "10EUR credit card for TV & telephone in Jerez de la\nFrontera hospital's rooms. The maker can be found at www.isernsa.com\n(ISERN Medical Telecomunications)" },
    { "3B06A21310919000", "C3P2K SAMPLE CARD (C3PO, S.L)" },
    { "3B06A21610919000", "rectangular (Other)" },
    { "3B07554E4B4E4F574E", "US DOD Smart Card" },
    { "3B0764............", "HID Corporate 1000 Format\nhttp://www.hidglobal.com/sites/hidglobal.com/files/resource_files/omnikey_contactless_developer_guide.pdf" },
    { "3B07640810........", "UC Berkeley student card" },
    { "3B09410411DD822F000088", "1k contactless Mifare" },
    { "3B0A20620C014F53459914AA", "GSM-SIM BEN (1800MHz)" },
    { "3B0A210026074F53459808F8", "ORGA test systems GSM phase 2+ test SIM." },
    { "3B0EBCE1CAAFC2DFBCADBCD3C3DCBFA8", "German 'Versichertenkarte' Healthcare card" },
    { "3B0F0065465305160571DF000000455053", "Feitian ePass3000, Feitian formatted" },
    { "3B0F0065465305160571DF000000806A82", "Feitian ePass3000, OpenSC formatted" },
    { "3B0F0065465305300571DF000000806A82", "Fetian epass3000" },
    { "3B0F524E424F2456232E00000012005876", "iKey1000 (PKI)" },
    { "3B0F802215E15A00200030210331210300", "RSA SecurID SID800 token" },
    { "3B0F802215E15A00200031210331210300", "RSA SecurID SID800 token" },
    { "3B0F8031E06B0507050282555555555555", "Secure Worker Access Consortium Identification (eID)\nhttps://www.secureworker.com" },
    { "3B0F806A163246495345538CE0FF079000", "GSM-SIM Sonera (from 1998)" },
    { "3B0F8091E1318065B0831111AC83009000", "TOP DM GX4 Cards [TOP DM GX4 on SmartLogon Pro]" },
    { "3B0FFFC1B5CC72CA0000..", "Mifare Std 1K" },
    { "3B0FFFFFFFFFFFFFFFFFFFFFFFFFFFFF80", "CAC (Contractor Access Card) / Oberthur ID One 128 v5.5a D (PKI)\nhttps://csrc.nist.gov/csrc/media/projects/cryptographic-module-validation-program/documents/security-policies/140sp1145.pdf" },
    { "3B101450", "HSID6000 (PKI)" },
    { "3B119580", "NXP J3H145 (JavaCard)" },
    { "3B12953606", "EMTG56 0.6 (sub-version 0.1)" },
    { "3B12953608", "EMTG56 0.8 (sub-version 0.1)" },
    { "3B12953609", "EMTG56 0.9 (sub-version 0.1)" },
    { "3B1396130917", "Teacher Card (Other)" },
    { "3B151112CA0700DB", "Tricolor TV center card (Pay TV)" },
    { "3B151112CA0711CA", "DRE Crypt (Pay TV)" },
    { "3B151112CA0714CF", "PlatformaHD (Russia) DRE Crypt 4AE1:14" },
    { "3B15138053415203", "Eutron CryptoIdentity (ATMEL AT903232C - 6464C Cryptographic\nprocessors, 64KB EEPROM, RSA 2048)" },
    { "3B15182E005C0001", "China Unicom 64k OTA" },
    { "3B15188053415205", "Israel Defence Force ID Card (eID)" },
    { "3B1594C302081601", "GSM-SIM EMT (Estonia)" },
    { "3B16117204013F0200", "Vodafone Romania SIM card (Telecommunication)" },
    { "3B1618AF0102020200", "SIM Virgin Mobile (Australia)" },
    { "3B1618D0000B010300", "Cellular SIM  (Telecommunication)" },
    { "3B169420020120010D", "Rogers SIM Card (phone / cable provider in Canada)" },
    { "3B16942006010C0100", "Vodafone Romania (Telecommunication)" },
    { "3B1694618000010603", "Thales PayShield9000 Local Master Key (hardware key) card (Other)" },
    { "3B1694710101002700", "Cingular GSM SIM Card" },
    { "3B1694710101010200", "Iridium SIM Card (Telecommunication)" },
    { "3B1694710101050200", "GSM SIM Bouygues Telecom" },
    { "3B1694710101060200", "SFR GSM SIM Card" },
    { "3B16947101010A0100", "TIM Brazil SIM card (Telecommunication)" },
    { "3B1694720401000000", "MTS SIM card, Russia (Telecommunication)" },
    { "3B169481100601....", "Schlumberger Cyberflex Access 16K" },
    { "3B169481100601812F", "Schlumberger Cyberflex Access Augmented Crypto" },
    { "3B169481100601813F", "Schlumberger Cyberflex Access Crypto" },
    { "3B1694D00013000000", "OPLUZ OPM610 EU Multifunction Smartcard Reader (Telecommunication)\nhttp://www.opluz.net/en/productshow.asp?id=135" },
    { "3B1694D0016E660D00", "Vodafone Romania (Telecommunication)" },
    { "3B1694D001760D2A00", "Peruvian GSM SIM" },
    { "3B1694D0017B2C0E00", "SIM tunisiana" },
    { "3B16959B0007011803", "Thai GSM UICC (Telecommunication)" },
    { "3B1695D00045F70100", "Telefonica O2 Czech Republic, a.s. - O2 sim card - 173285 / SIM64ND.GO0\nhttp://www.o2.cz" },
    { "3B1695D0016CFD0D00", "Virgin Mobile SIM card (SIM)" },
    { "3B1695D0017BDA0D00", "Verizon GSM SIM (Telecommunication)" },
    { "3B1696417374726964", "Gemalto IDPrime v2+ .NET" },
    { "3B1696770006010403", "AIS One-2-Call GSM UICC (Telecommunication)\nhttp://www.ais.co.th" },
    { "3B1696BA000E010603", "Vinaphone Vietnam SIM" },
    { "3B1696BA000E020A03", "Vietel (Telecommunication)" },
    { "3B1696D000D4072C00", "Vodafone India Postpaid / Local Operator 3G" },
    { "3B17118065AF034200D8", "TELE2 SPB SIM Russia" },
    { "3B17139C120201010740", "Schlumberger Cyberflex Access Developer 32k" },
    { "3B179418010101014193", "T-Mobile SIM card" },
    { "3B179418010102014149", "white SFR SIM card" },
    { "3B179418010102024149", "Sim card from SFR  (Telecommunication)" },
    { "3B179418010109014153", "Old Spanish Telefonica Movistar GSM SIM card" },
    { "3B179418020125014193", "AT&T Wireless GSM SIM Card" },
    { "3B17942001010A024143", "KPN SIM card" },
    { "3B1794200501100141FF", "CLARO SIM card (ex CTI Movil)" },
    { "3B17942103010A0241FF", "Eurotel Praha, spol. s r. o. - O2 SIM card (Telecommunication)\nhttp://www.o2.cz/" },
    { "3B17942104010704030B", "vodafone romania (Telecommunication)" },
    { "3B17947C01010D01415B", "Plus (PL) SIM card (2001) (Telecommunication)" },
    { "3B17948065D0016CF2BE", "CMCC sim cards with TD-SCDMA support" },
    { "3B17948065D0018BF208", "China SIM card" },
    { "3B17948065D001A41009", "China Telecom UIM Card (128K 2014) (Telecommunication)\nhttp://www.189.cn" },
    { "3B179483A1000901410B", "Telfor SIM card (Telecommunication)" },
    { "3B179489010201024187", "Vodafone/Omnitel 16K GSM SIM" },
    { "3B17958065D0017E0DF0", "Si.Mobil Slovenia GSM SIM card (Telecommunication)\nhttp://www.simobil.si" },
    { "3B17958065D0017E0E05", "Finnish DNA Prepaid SIM-card (Telecommunication)" },
    { "3B17958065D0020C103E", "Airtel Tanzania (Telecommunication)" },
    { "3B1811E843011009050777", "Sim Card GSM for provider 3 telecommunication Indonesia (Telecommunication)\nhttp://tri.co.id/" },
    { "3B1894451537000100FF02", "Micro SIM Life (Telecommunication)\nhttp://www.life.ua/" },
    { "3B1894451543DA0100FF02", "Airtel Tanzania Prepaid SIM Card (Telecommunication)" },
    { "3B1894530D06772407FF02", "GSM SIM Tele2 Estonia, prepaid (Telecommunication)" },
    { "3B1894532007AD0A05FF02", "GSM SIM Beeline Kazakhstan (Telecommunication)\nhttp://beeline.kz/" },
    { "3B19145590010101000508B0", "Schlumberger Multiflex 8k" },
    { "3B19145590010201000504B0", "Schlumberger Multiflex 4k" },
    { "3B19145901010F01000508B0", "Schlumberger Multiflex 8k" },
    { "3B199431020510459801024E", "GSM-SIM EMT (Estonia)" },
    { "3B19943303013145410602B6", "BASE Twin simcard (Telecommunication)" },
    { "3B1994806794080125010101", "Mobiphone (Telecommunication)" },
    { "3B1996806793270102020401", "Orange SIM card (Telecommunication)" },
    { "3B1996806794160203010101", "Movistar Argentina Usim Card (Telecommunication)\nwww.movistar.com.ar" },
    { "3B1996806798040101010101", "PLUS gsm (Telecommunication)" },
    { "3B1A9692015493320103022501", "BEELINE (Telecommunication)" },
    { "3B1B948069060222110080080000", "eID" },
    { "3B1B948069070521110080000000", "Aircel SIM (Telecommunication)" },
    { "3B1B960543433252530512109000", "ChipCity CC32RS512 factory boot loader\n(this is a flash based CPU card with a factory-default bootloader)" },
    { "3B1C94434849504452495645303031", "SCM Chipdrive MyKey MasterKey 24k" },
    { "3B1D11003204000000FF000000009000", "chip ST32F32A (Telecommunication)" },
    { "3B1D1106027F3F130317010011351000", "XL (Telecommunication)\nhttp://www.xl.co.id/" },
    { "3B1D11434C5F53414D00143800009000", "Planeta Informatica CL-SAM (Transport)\nhttp://www.planeta.inf.br" },
    { "3B1D9600230700000000000000009000", "emulator card prototype from ST" },
    { "3B1D97434C5F53414D00143800009000", "CLSAM (Transport)\nhttp://www.planeta.inf.br" },
    { "3B1E130069454D4345663228F86B009000", "ECHS (Ex-servicemen Contributory Health Scheme) Card (HealthCare)\nhttp://echs.gov.in/" },
    { "3B1F110067424146495345535266FF819000", "Finnish student id card" },
    { "3B1F110067804246495345105266FF819000", "Nokia branded SC (Setec)" },
    { "3B1F11006A013846495345108C02FF079000", "GSM-SIM Saunalahti (from 2004)\nFinnish cell phone operator 'Sonera' SIM card (from 2002)" },
    { "3B1F11006A313646495345138C02FF079000", "GSM-SIM card - Telenor Mobil\nhttp://www.telenor.com/" },
    { "3B1F11006A313846495345138C02FF079000", "Latvian GSM operator TELE2 (SIM)" },
    { "3B1F11806A163246495345158CE6FF079000", "GSM SIM card - Tele2 Estonia\nhttp://www.tele2.ee" },
    { "3B1F11806A323746495345128C00FF079000", "Setec Test card, SetCOS 3.7.2, rel 1.3" },
    { "3B1F11806A323746495345128C02FF079000", "GSM-SIM DNA Finland (from 2001)" },
    { "3B1F11806A803446495345539400FF07....", "Setec SetCos 3.4" },
    { "3B1F11806A803446495345539436FF079000", "SetCOS 3.4.0c\nRSA SecurID 3100" },
    { "3B1F94006A013846495345108C02FF079000", "GSM-SIM Saunalahti (from 2004)" },
    { "3B1F9480310073122113574A33052B323400", "Metfone Cambodia SIM card\nhttp://metfone.com.kh/en/Home/Default.aspx" },
    { "3B1F9480310073122113574A330530323400", "Tron - MVNO Malaysia SIM Card (Giesecke & Devrient SIM)\nhttp://www.tron.my" },
    { "3B1F94806A163246495345158CE6FF079000", "GSM-SIM Sonera (from 2002)" },
    { "3B1F9580310073122113574A330E19323300", "Latvian GSM Operator BITE" },
    { "3B1F9580310073122113574A330E1A323600", "Telcel Mexico SIM Card (Telecommunication)" },
    { "3B1F96380503200617020440100007089000", "THC20F17BD blank smartcard (Pay TV)\nhttp://tsinghuaic.com/product/product.asp?id=12&bid=8552" },
    { "3B230000364181", "Schlumberger Payflex 4k SAM" },
    { "3B2300351180", "Schlumberger Payflex 1k User" },
    { "3B2300351181", "Schlumberger Payflex 1k SAM" },
    { "3B2300351380", "Schlumberger Cyberflex Access Campus" },
    { "3B23003513FF", "Schlumberger MicroPayflex" },
    { "3B2300354180", "PayflexHID (idenfitied by Sun Ray Services)" },
    { "3B2400......45", "Conax" },
    { "3B240000000000", "MultiChoice satelite TV Card Eutelsat 36B at 35.9degE\nhttp://www.lyngsat.com/Eutelsat-36B.html" },
    { "3B240000E29267", "Health care (HealthCare)" },
    { "3B240030423030", "ComHem Digital-TV smartcard (Sweden)\nTNK Telewizja Na Karte (Poland) - Conditional access system : Conax (Norway)\nhttp://telewizjanakarte.pl/" },
    { "3B240080729443", "MPCOS-3DES 64K \\ EMV Filter (Gemplus)" },
    { "3B2400FFFCFCFC", "Carta Nazionale dei Servizi - Camerica di Commercio di Torino (eID)" },
    { "3B2400FFFFFFFF", "ATMEL AT24C64SC (Other)" },
    { "3B2600002640009000", "Schlumberger, purse?" },
    { "3B260011016D03", "OLD CajaMadrid Visa Cash, ID card for Universidad Autonoma de Madrid, Madrid (about 1998)" },
    { "3B260011045C039000", "Caixa Abierta (Barcelona, Spain) Cash/Visa Electron" },
    { "3B2600110623039000", "Tarjeta de la Seguridad Social (Spanish Social Insurance Card)" },
    { "3B2600211826039000", "Smart card used in transport (spain) (Transport)" },
    { "3B2600240601000080", "old KPN NetBox card" },
    { "3B260031086C039000", "VISA ELECTRON from Caixa Catalunya bank card (www.caixacatalunya.es) for students in UPC university of Barcelona (Spain) (www.upc.es)" },
    { "3B26003109C2039000", "Old version of spanish Social Security card for its employees (eID)" },
    { "3B2600310BD2039000", "Former Universidad de Leon (Spain) Identification Card (partnership with Caja Espana bank - Visa Cash) (Bank)" },
    { "3B2600311A45039000", "Tajeta Sanitaria Individual (Spanish Insurance Card)\nfrom the 'Junta de Andalucia(Consejeria de Salud)'" },
    { "3B2600311A51039000", "Andalusian Health Service identification card (HealthCare)" },
    { "3B270011140003029000", "ITTAS CNA Smart Card Reader (PKI)\nhttps://www.ittas.by/en/solutions/cna-cryptographic-protection-of-information" },
    { "3B27008065A2..010137", "Gemplus GemSAFE Smart Card (4K)" },
    { "3B27008065A200010137", "Gemplus GemSAFE Card CSP v1.0" },
    { "3B27008065A202028237", "Gemplus GPK2000s" },
    { "3B27008065A202038237", "Gemplus GPK2000sp" },
    { "3B27008065A204010137", "Gemplus GPK4000s" },
    { "3B27008065A205010137", "Gemplus GPK4000sp" },
    { "3B27008065A206010137", "GPK 4000, RSA 512 bits Sign, Unwrap 40 bits" },
    { "3B27008065A20C010137", "Gemplus GPK4000" },
    { "3B27008065A28C3B2700", "GPK 4000, RSA 1024 bits Sign, Unwrap 256 bits" },
    { "3B28003441454130323030", "Cryptoguard AB (Other)" },
    { "3B29002493010000000001A9", "Telephone chipcard for the Vienna University of Technology\nhttp://nic.tuwien.ac.at/telefonie/chipkarte/" },
    { "3B29008072A44564........", "MPCOS-3DES 8K (Gemplus)" },
    { "3B29008072A445640000D015", "Moeda Electronica Bradesco (Brasilia)" },
    { "3B29008072A4456400FF0010", "MBNA Europe Platinum Plus Mastercard\nMasterCard Card - Worldcard - Yapikredi / Turkey\nPortugal BPI Visa Electron\nUCFIN (Italy) 'UniCreditCard Free' or 'Plus' (VISA or MasterCard) credit card" },
    { "3B2A008065A05804016272D643", "Gemplus GemCombiXplore MPCOS Pro" },
    { "3B2A008065A201......72D641", "Gemplus MPCOS EMV 1 Byte sectors" },
    { "3B2A008065A201......72D643", "Gemplus MPCOS EMV 4 Byte sectors" },
    { "3B2A008065A20100000072D641", "MPCOS_EMV_1B" },
    { "3B2A008065A20100000072D643", "MPCOS_EMV_4B" },
    { "3B2A008065A20101013C72D643", "Estonian bank 'SEB' (VISA Electron)" },
    { "3B2A008065A20101013D72D643", "GEMPLUS Logico Secure SmartCard for Citrix Metaframe\nPTTPost Easy Stamp\nHungarian student card" },
    { "3B2A008065A20102013172D643", "MPCOS-EMV 64K Functional Sample\nTHALES nShield Security World\nTHALES NCIPHER product line" },
    { "3B2B000064053E020F31800E9000", "Health Insurance Institute of Slovenia personal card (HealthCare)\nhttp://www.zzzs.si/zzzs/internet/zzzs.nsf/o/B8F997CE9D45E99AC1256E8B003B46B0" },
    { "3B2B0000640E3E02F031800E9000", "HPC card" },
    { "3B2F00806910800001A10A010159830E9000", "Belgium Dexia (Axion) Bank Card\nProton/Bancontact Mister Cash/Maestro" },
    { "3B2F008069AF0307066800000A0E8306", "GSM SIM MobilCom (Gemplus)" },
    { "3B2F008069AF0307066800000A0E83069F16", "MobilCom-Karte" },
    { "3B2F008069AF0307066800010A0E833E9F16", "Virgin Mobile UK SIM, early 2000s (Telecommunication)" },
    { "3B2F008069AF0307066800050A0E833E9F16", "KPN @ Mobile SIM card" },
    { "3B3215000680", "Schlumberger Multiflex 8k" },
    { "3B3215000695", "Schlumberger Multiflex 8k DES" },
    { "3B34000030423030", "Conax card: T-Home Hungary" },
    { "3B34130034414644", "Demo card Enigo CAS (Pay TV)" },
    { "3B34940030423030", "Conax card: ComHem sweden" },
    { "3B351100594C595231", "Student catering card, ADISURC (Other)\nhttps://www.adisurcampania.it/" },
    { "3B371100464C4F4D419000", "SLE 4428" },
    { "3B3711004B494154079000", "Rome ATAC Metrebus card (Transport)\nhttps://www.atac.roma.it/page.asp?p=226&i=14" },
    { "3B37130080621104829000", "Swiss UBS Maestro/CASH Bank Card" },
    { "3B37130080622113829000", "Swiss UBS Maestro/CASH Bank Card" },
    { "3B39110026BF00F00000839000", "MAGIS Club Access card (Other)" },
    { "3B391300806416040186829000", "The cantonal bank of Baselland (Bank)" },
    { "3B391300806416040282829000", "Swiss cantonal bank (Bank)" },
    { "3B391900534F4D41445333303[1,3]", "Identity card of the Republic of Kazakhstan (passport)\nhttp://pki.gov.kz/" },
    { "3B3B..00806.A[FE]030[CD]....83..9000", "GemXplore Xpresso V3" },
    { "3B3B026F333BDB9600801F030031C0", "US Government CAC (PKI)" },
    { "3B3B11002FAF21FA10000281839000", "alo (Telecommunication)" },
    { "3B3B11002FAF21FA10000283839000", "romanian telecommunication operator obsolete sim (Telecommunication)" },
    { "3B3B110067AF10300700C033339000", "Mobicarte Orange" },
    { "3B3B11006A3820000027A033339000", "Spanish C*******r Movil SIM card" },
    { "3B3B11008065AF030C016F830F9000", "Gemplus GemX{plore,presso} V3-B1" },
    { "3B3B11008069AF030C016F830[01]9000", "GemXplore'Xpresso V3 64K" },
    { "3B3B110091411010105BA000339000", "Pannon SIM card (Hungary)" },
    { "3B3B13008066120301030004829000", "UBS Maestro (Bank)" },
    { "3B3B13008066120301030008829000", "UBS Switzerland Maestro Debit Card (Bank)" },
    { "3B3B1300806612040104004[4,9]829000", "Neue Aargauer Bank Maestro card (Bank)" },
    { "3B3B13008066120401040061829000", "Maestro debit card, Banque Cantonal du Valais, Switzerland (Bank)\nhttps://www.bcvs.ch" },
    { "3B3B13008066120401040158829000", "Schaffhauser Kantonalbank Switzerland (Bank)\nhttp://www.shkb.ch" },
    { "3B3B7F380000006A444E496510024C", "dnie (eID)" },
    { "3B3B7F380000006A444E496520024C", "DNI (eID)" },
    { "3B3B8E800180318066B1840C016E01830090001C021450", "all transport travel pass (Transport)\nhttp://www.metro.spb.ru/cnblt41.html" },
    { "3B3B94000064053E030F31800E9000", "Slovenian national health insurance card" },
    { "3B3B940000640E3E02F031800E9000", "HPC card 2\nZZZS Health care professional card- Slovenia (Healthcard) (HealthCare)\nhttps://partner.zzzs.si/wps/portal/portali/aizv/e-poslovanje/kartice_in_citalniki/prof_kartica/" },
    { "3B3B940000640E3E030F31800E9000", "HIC card\nZZZS Health care card- Slovenia (HealthCare)\nhttps://partner.zzzs.si/wps/portal/portali/aizv/e-poslovanje/kartice_in_citalniki/kartica_zdravstvenega_zavarovanja/!ut/p/z1/04_Sj9CPykssy0xPLMnMz0vMAfIjo8ziTQxdPd2N_Q08LSyCDQ0cjZzMzXz8XQ3cXU30C7IdFQEohG-V/" },
    { "3B3B94004F341020010..033339000", "Wind (Italy) GSM SIM card" },
    { "3B3B94006737100000396033339000", "Avea GSM / Turkey" },
    { "3B3B9400693C1030013E4033009000", "UK Vodafone GSM SIM" },
    { "3B3B94006A3820000000A033339000", "Croatia VIPNet Mobile Operator (Telecommunication)" },
    { "3B3B94006A3820000009E033339000", "virgin mobile (french) SIM card" },
    { "3B3B94006A382000000A2033339000", "SIM Card for cellular (Orange) (Telecommunication)" },
    { "3B3B94008065321304033083819000", "SIM cards by the austrian cell phone provider A1" },
    { "3B3B94008065AF030D0174830F9000", "Gemplus GemXplore Xpresso V3 B1P\nMobistar SIM - Belgium (Gemplus)" },
    { "3B3B94009138115046974033339000", "Leclerc Mobile (French MVNO) SIM card" },
    { "3B3B940092381010491B40AA6A9000", "T-Mobile (USA) OCS_2.3 (Telecommunication)" },
    { "3B3B94009238102001048033139000", "TELE2 Sim Card (Telecommunication)" },
    { "3B3B94009B4420104D042000339000", "SIM card for 063 network of Telekom Srbije, the Serbian state-owned telephone company." },
    { "3B3B94009B4420104D050000339000", "SIM card for 066 network Telekom Srbije, the Serbian state-owned telephone company." },
    { "3B3B9400A639900000002183839000", "meteor ireland\nhttp://www.meteor.ie" },
    { "3B3B95009138112001008033339000", "GSM SIM of WIND Italian mobile company" },
    { "3B3B96000752510000A8FD33339000", "Movistar Costa Rica SIM card" },
    { "3B3B96004022510000420033339000", "Wind (Italy) 128K GSM SIM card" },
    { "3B3B9600405301000041C033339000", "Wind (Italy) 128K SIM card (Telecommunication)" },
    { "3B3B960040540100000AC033339000", "Wind (Italy) 64K prepaid GSM SIM card" },
    { "3B3B9600408891000008EA33339000", "iraqmanager (eID)" },
    { "3B3B9600914110205709A000339000", "old vodafone romania sim (Telecommunication)\nhttps://vodafone.ro" },
    { "3B3B9600924210105A02E000339000", "Roaming Test SIM (Telecommunication)" },
    { "3B3B9600A74C90000090AC33339000", "Brazilian TIM GSM SIM" },
    { "3B3BF71800008031FE45736674652D", "Serasa Experian (PKI)\nhttps://serasa.certificadodigital.com.br/" },
    { "3B3BFF1800FF8131FE55006B020903", "Smart card commercial chamber - Tuscan region - Aruba (eID)" },
    { "3B3C110040AF13F31200068783809000", "SIM GSM Orange Fr" },
    { "3B3C110042AF20A32007002283809000", "SIM Card for cellular (Orange) (Telecommunication)" },
    { "3B3C110042AF20A32007002283829000", "Orange Mobicarte (SIM card old generation)" },
    { "3B3C110044AF11F7200504FB83819000", "itineris (Old French Mobile Operator SIM card) (Telecommunication)" },
    { "3B3C9400423111A21202095183809000", "Omnitel IT 16K GSM SIM card" },
    { "3B3C94004B3125A21013144783839000", "GSM SFR" },
    { "3B3C94004C3125A7201B001583839000", "GSM-SIM (900MHz) card of the carrier vodafone for their cellular\nnetwork (phase 2+ with 3V)" },
    { "3B3C9400633112F00000464083839000", "Old russian 'beeline' sim" },
    { "3B3D9400010F0036000086601804000107", "Vodafone GSM / Turkey" },
    { "3B3D940023180256000086605B1B00000F", "GSM SIM, TMN (Moche prepaid, Portugal)" },
    { "3B3D9400240E00960000866031B5000607", "GSM SIM Tele2 Estonia; 2008" },
    { "3B3D9400240E00960000866031E0800007", "Operator CMCC SIM card. old 2G SIM. (Telecommunication)" },
    { "3B3D94002E0E025600008660C0A400000F", "Globe Telecom (Telecommunication)\nhttp://www.globe.com.ph" },
    { "3B3D940035060144000386608D588AE207", "OAUSim (Telecommunication)" },
    { "3B3D9400444D5411000606176211003000", "China Unicom SIM card" },
    { "3B3D94008067AF030F017C060E833E9F16", "A1 Telekom Austria (Austrian mobile provider) SIM card (Telecommunication)\nhttp://a1.net" },
    { "3B3D95008067AF030F017C060E833E9F16", "(Sprint) Nextel USA iDEN SIM card\nhttp://www.sprint.com/index_n.html?brand=Nextel" },
    { "3B3E940080310073FE211362003183819000", "Vodafone (Italy) 64kB GSM SIM card" },
    { "3B3E9500534F4D412D633030372D44533161", "Kazakhstan Identity Card (eID)" },
    { "3B3E9500534F4D412D633030372D44533162", "Kazakhstan Identity Card (eID)" },
    { "3B3E950080310073FE211362003483819000", "STMicroelectronics GSM File system sample CARD for ST microcontrollers" },
    { "3B3F11006FAF65031201807332211B830F9000", "GSM SIM card Orange J2RE postpaid" },
    { "3B3F110079AF65031201807332211B830F9000", "GSM SIM card from Orange (labeled J2RE)" },
    { "3B3F11008012009131C0640E01131272F74105", "SCOSTA Smart Card Operating System for Transport Application (transport)" },
    { "3B3F11008012009131C0640E0128AA72F74105", "SCOSTA Smart Card Operating System for Transport Application (transport)" },
    { "3B3F11008012009131C0640E0146AC72F74105", "scosta (Other)" },
    { "3B3F11008069AF031B02AB0000060E833E9F16", "PEOPLES (China Mobile HK) sim (Telecommunication)" },
    { "3B3F11008069AF033700120000000E83189F16", "Reliance SIM (Prepaid), Telecommunication" },
    { "3B3F11008069AF033D00C60000000E831E9F16", "Cosmote Romania prepaid sim (Telecommunication)" },
    { "3B3F94008065AF0312016F7332211B830F9000", "GSM SIM Card (GEMPLUS), issued by Orange Switzerland (Prepaid)\nItalian Vodafone 64k SIM\nGSM SIM T-Mobile NL" },
    { "3B3F94008065AF0312017973322100830F9000", "O2 (UK) SIM" },
    { "3B3F94008065AF031201797332211B830F9000", "UK O2 GSM SIM (2G Online Prepay Maldives)\nTesco Mobile (UK) SIM" },
    { "3B3F94008069AF0307066700000A0E833E9F16", "SFR SIM card (red Gemplus Repertoire)" },
    { "3B3F94008069AF0307066709970A0E833E9F16", "BASE SIM - Belgium (Gemplus)" },
    { "3B3F94008069AF0307066800750A0E833E9F16", "O2 Mobile Ireland SIM, late 2000s (Telecommunication)" },
    { "3B3F94008069AF03070668007F0A0E833E9F16", "Debitel Vodafone, de (Telecommunication)" },
    { "3B3F94008069AF0307066800850A0E833E9F16", "O2 (UK) SIM" },
    { "3B3F94008069AF030F0280FFFF060E833E9F16", "GSM-SIM Telefonica Movistar, prepaid (Spain)" },
    { "3B3F94008069AF030F07A40000060E833E9F16", "SIM Card PRO from the austrian telecom 'A1'" },
    { "3B3F95008065AF0312016F7332211B83009000", "Gemplus GemXpresso PRO 64 PK SIM" },
    { "3B3F95008065AF0312016F7332211B830F9000", "Vodafone Italia SIM 64K" },
    { "3B3F95008065AF0312017973322100830F9000", "GSM SIM Orange NL" },
    { "3B3F95008065AF0314018A7332211B830F9000", "SIM Vodafone 64k" },
    { "3B3F95008069AF030F0280FFFF060E833E9F16", "AT&T Wireless GSM SIM Card\nUK Virgin Mobile GSM SIM" },
    { "3B3F95008069AF030F06A3FFFF060E833E9F16", "'SIMYO' SIM card (KPN)" },
    { "3B3F95008069AF031B03B8FFFF060E833E9F16", "USIM of Elisa Oyj, Finland (Telecommunication)" },
    { "3B3F96008012009131C0640E4744FA72F741052F", "MEmbership card (Loyalty)" },
    { "3B3F9600805A2380E1083108AE0136DD829000", "Spirtech SAM-S5 v2" },
    { "3B3F9600805A2380F1083102AE013AF2829000", "Spirtech SAM-S1 F1 with Desfire support" },
    { "3B3F96008069AF033D00C60000000E831E9F16", "GSM SIM card of the Austrian provider A1" },
    { "3B4F0041543838534331303220202020FFFF", "siral smartcard (JavaCard)" },
    { "3B4F004932435F436172643D4E6F5F515452", "AT24C (Bank)" },
    { "3B4F00536C653434322D34343DA2131091", "Debit card  (Bank)" },
    { "3B4F00536C65343433322D34323DA2131091", "VISA (Bank)" },
    { "3B57180293020101019000", "Easyflex FastOS 2.0 / Schlumberger" },
    { "3B5B96000031C064BAFC10000F9000", "SERGAS - Galician Healtcare Service (Spain) (HealthCare)\nhttps://www.sergas.gal" },
    { "3B5B96000031C064C6FC1000019000", "Banking card (Oberthur C.S. 06 18710-04-10)" },
    { "3B5B96000031C064C7FC1000019000", "EBanking card (Oberthur C.S. 03 1146821)" },
    { "3B5E11FF4573744549442076657220312E30", "Estonian Identity Card (EstEID v1.0 2006 warm)" },
    { "3B5F1100807300010059434C5A1B0311409000", "Player Plus Cash Card issue of French Partouche Casino (Other)" },
    { "3B5F9500807300010059434C5A1B0011409000", "SCM Chipdrive MyKey SC" },
    { "3B5F9500807300010059434C5A1C0011409000", "'CardLogic' CLXSU256KF5" },
    { "3B5F9500807300010059434C5AC506117C9000", "Smart Card C5 68K CardLogix Corp (Other)\nhttps://www.cardlogix.com/products/most-card-c-series-microprocessor-smart-cards/" },
    { "3B5F9500807300010059434C5AC50612C09000", "Republic of Liberia Civil Service Identification Card (eID)" },
    { "3B5F9600805A2C1100101000FFFFFFFF829000", "Calypso (Transport)" },
    { "3B61000080", "blank A40CR card (JavaCard)" },
    { "3B630000364180", "Schlumberger Payflex 4k User" },
    { "3B64..FF8062..A2", "JCOP20" },
    { "3B64000080620.51", "Setec SetCOS 5.1.0 EMV" },
    { "3B6400FF806202A2", "VISA credit card (Nordea bank)" },
    { "3B6500002063CB4700", "Orga SmartyPlus DATA STORE issued by MORPHO CARDS PERU" },
    { "3B6500002063CB6300", "Bank card from Societe Generale (Oberthur)" },
    { "3B6500002063CB6400", "Bank card Caisse d'Epargne" },
    { "3B6500002063CB6480", "MasterCard from La Banque Postale" },
    { "3B6500002063CB6600", "Boursorama banque VISA (bank)" },
    { "3B6500002063CB6680", "Credit Agricole (french bank) MasterCard" },
    { "3B6500002063CB6800", "VISA credit card (Skandiabanken)\nVISA credit card (Banque Populaire)\nBanque Postale card (bank)\nSociete Generale (visa / jazz)\nHSBC Business VISA" },
    { "3B6500002063CB680026", "VISA Societe Generale - Oberthur CS" },
    { "3B6500002063CB6880", "Capital One MasterCard Platinum" },
    { "3B6500002063CB6A00", "CB Visa La Banque Postale (Gemalto)\nCB Visa BNP Paribas (France)\nCB Visa du Credit Cooperatif\nCB Visa from Banque Caledonienne d'Investissement (BCI)" },
    { "3B6500002063CB6A80", "Mastercard EMV Debit Card\nCredit Agricole (french bank) Gold Mastercard" },
    { "3B6500002063CB6B00", "EMV VISA (France)" },
    { "3B6500002063CB6B80", "Credit Agricole (french bank) Mastercard" },
    { "3B6500002063CB6C80", "Credit Agricole Bank Card (Bank)" },
    { "3B6500002063CBA000", "CB Visa Banque Populaire (France)" },
    { "3B6500002063CBA080", "C*******r, MasterCard credit card, Pass Banque, Oberthur" },
    { "3B6500002063CBA100", "AIB Visa Debit Card, manufactured by Oberthur" },
    { "3B6500002063CBA180", "bpaid: bpost prepaid Mastercard\nhttp://www.bpost.be/site/fr/residential/finance/bpaid/index.html" },
    { "3B6500002063CBA300", "BNP VISA CARD" },
    { "3B6500002063CBA320", "MasterCard Credit Agricole Anjou-Maine (type Societaire)" },
    { "3B6500002063CBA3A0", "VISA card from Banque Populaire" },
    { "3B6500002063CBA520", "Mastercard international credit card, with Moneo extension" },
    { "3B6500002063CBA5A0", "French banking card 'Banque Populaire'\nVisa Card distributed by BNP PARIBAS (French Bank)" },
    { "3B6500002063CBA620", "Mastercard Credit Agricole (French Bank)" },
    { "3B6500002063CBA6A0", "Visa Premier Boursorama (French bank)" },
    { "3B6500002063CBA720", "ING Direct (French Bank) Gold MasterCard" },
    { "3B6500002063CBA800", "Novo Banco Debit Card (Bank)\nhttp://www.novobanco.pt/site/cms.aspx?plg=3FDF9B9E-C73B-4D76-80C7-F73AF087EADF" },
    { "3B6500002063CBA820", "Belgazprombank (Belarus) MasterCard (Bank)\nhttp://belgazprombank.by/" },
    { "3B6500002063CBA8A0", "HSBC VISA Card" },
    { "3B6500002063CBA9A0", "VISA PREMIER CREDIT CARD (Bank)" },
    { "3B6500002063CBAA20", "Cumulus Mastercard (Cembra Money Bank AG, Switzerland) (Bank)\nhttps://www.cembra.ch/de/kundencenter/karten/cumulus-mastercard/" },
    { "3B6500002063CBAB20", "bank card (Bank)" },
    { "3B6500002063CBAB80", "Portugal Caixa Geral de Depositos Mastercard 'Caixa Classic'" },
    { "3B6500002063CBABA0", "Visa card (a blue one) edited by Banque Caledonienne d'Investissement (BCI)\nVisa Card distributed by La Banque Postale" },
    { "3B6500002063CBAD00", "MasterCard Debit (Bank)\nhttp://www.mastercard.com/ae/personal/en/aboutourcards/debit/gold_card.html" },
    { "3B6500002063CBAD20", "bpost bpaid (Bank)\nhttp://www.bpost.be/bpaid/\nKBC Ireland Mastercard Debit (Bank)\nING Direct MasterCard (Bank)\nhttps://www.ingdirect.es/\nbancopopular-e (Spain) (Mastercard) credit card (Bank)\nhttps://www2.bancopopular-e.com" },
    { "3B6500002063CBAD80", "Santander Debit Card (Bank)" },
    { "3B6500002063CBADA0", "VISA Card, issued by Czech bank 'Komercni banka' (Bank)\nhttps://www.kb.cz/en/" },
    { "3B6500002063CBAE20", "MasterCard payment card for French Credit Agricole bank (Bank)" },
    { "3B6500002063CBAE80", "Visa Premier (HelloBank), Gemalto SGP U1074311B 1214 (Bank)" },
    { "3B6500002063CBAF20", "@ccess MasterCard (Bank)\nhttps://www.mastercard.com/fr/particuliers/carte-bancaire-access.html" },
    { "3B6500002063CBB020", "Credit Mutuel Arkea paycard (Bank)" },
    { "3B6500002063CBB120", "Bank card 'Credit Agricole' (Bank)" },
    { "3B6500002063CBB280", "Visa card distributed by 'Societe Generale' (French Bank) (Bank)\nVisa card distributed by 'Boursorama Banque' (French Bank) (Bank)\nhttps://www.visa.fr/" },
    { "3B6500002063CBB620", "MasterCard credit card, issued by Swedbank LT (Bank)" },
    { "3B6500002063CBB680", "Visa bank card  (Bank)" },
    { "3B6500002063CBB700", "Lloyds Bank (UK) 'Avios Duo' Mastercard credit card (Bank)" },
    { "3B6500002063CBB720", "Lloyds Bank Platinum Mastercard Credit (Bank)" },
    { "3B6500002063CBB780", "VISA Credit Card (Bank)" },
    { "3B6500002063CBB900", "Mastercard (Bank)" },
    { "3B6500002063CBBC00", "Credit Agricole MasterCard Societaire (France) (Bank)\nhttps://www.ca-centrefrance.fr/moyens-de-paiement/carte-bancaire-societaire.html" },
    { "3B6500002063CBBC10", "French 'Ticket Restaurant' Edenred payment card (Other)\nhttps://www.myedenred.fr/" },
    { "3B6500002063CBBC80", "CB / Visa La Banque Postale (Gemalto SP)" },
    { "3B6500002063CBBD00", "Credit Mutuel Arkea (Bank)" },
    { "3B6500002063CBC000", "Nickel Credit Card (Bank)\nhttps://nickel.eu" },
    { "3B6500002063CBC080", "VISA debit card (Bank)\nhttps://www.cic.fr/fr/banques/professionnels/gestion-courante/cartes-paiement-professionnelles.html" },
    { "3B6500002063CBC100", "CIC (Bank)\nhttps://www.cic.fr/" },
    { "3B6500002063CBC310", "Pass Restaurant Sodexo Pass France (Bank)\nhttps://moncompte.sodexopass.fr/" },
    { "3B6500002063CBC380", "Apetiz restaurant card (French luncheon vouchers) (Bank)\nhttps://www.apetiz.com/faq/?thematic=achats-apetiz-quoi-quand-combien" },
    { "3B6500002063CBFF00", "Credit Agricole business mastercard (Bank)" },
    { "3B6500002640009000", "Alacard Petroltech (Transport)\nhttp://www.alacard.kz/" },
    { "3B6500002905010201", "ActivCard (Schlumberger) CyberFlex 64K V1 SM 2.1" },
    { "3B6500004156494F4E", "RBC (Royal Bank of Canada) Avion Visa" },
    { "3B65000043046C9000", "Carte Bancaire (French banking card) (hot reset)" },
    { "3B6500005801010080", "RBS Advanta Platinum Reserve Master Card\nUK Lloyds TSB Visa Debit (issued 2003, Gemplus)" },
    { "3B6500008031E06B04520502BF555555555555", "mifare  (Transport)" },
    { "3B6500008073C60100", "NX by Abanca free Mastercard debit card (Bank)\nhttp://www.abanca.com/es/cuentas/cuenta-nx/" },
    { "3B6500009C02020102", "Dectel CI692" },
    { "3B6500009C02020702", "US Department of Defense, TEST Common Access Card (CAC)\nSchlumberger Cyberflex Access #2\nAxalto Cyberflex Access 32K V2\nSun Microsystems employee card" },
    { "3B6500009C1[01]010103", "Schlumberger Cyberflex Palmera" },
    { "3B650000D000370080", "Visa Debit card issued by National Bank of Dubai" },
    { "3B660000009C11010103", "Axalto Cyberflex Access 32K V4 SM 1.3" },
    { "3B660000009C11010301", "Axalto Cyberflex Access 64K V1 Bio SM 3.1" },
    { "3B6600000512010101B1", "Lyon1 student card (Moneo compatible)" },
    { "3B660000314B01010080", "VISA credit card (Skandiabanken)" },
    { "3B66000032D000300201", "Kazakhstan Kazkom Onlinebank (Homebank) PKI client key-card\nhttps://www.homebank.kz/" },
    { "3B66000062C901010000", "safeview (Pay TV)\nhttps://safeviewmedia.com/" },
    { "3B6600006644010103B1", "Carte etudiant Paris 1 moneo BNP Paribas france (Oberthur)\nCarte Moneo Caise d'epargne Crouse de Lyon" },
    { "3B66000090D1020110B1", "Moneo card (e-purse)\nCard 'Bordeaux Ma Ville' (yellow)\nhttp://www.bordeaux.fr/ebx/portals/ebx.portal?_nfpb=true&_pageLabel=pgPresStand8&classofcontent=presentationStandard&id=57733" },
    { "3B66000090D1020120B1", "Moneo card (e-purse)" },
    { "3B66000090D1020140B1", "Student card from Paris Diderot University (with Moneo)" },
    { "3B66000090D1020152B1", "Pass Campus Alsace, a mix of a student card, a transport card (Badgeo) and a Moneo\nhttp://www.passcampus-alsace.fr/\nhttp://www.cts-strasbourg.fr/Tarifs/Carte%C3%A0puceBadgeo/tabid/598/language/fr-FR/Default.aspx" },
    { "3B660000D00047440080", "VISA credit card (RBC Royal Bank)" },
    { "3B6600FF4A434F503033", "IBM JCOP 30" },
    { "3B6600FF4A434F503130", "debit card (Visa Electron) issued by Nordea bank (2008-2015) (Bank)" },
    { "3B6600FF4A434F503230", "UOB Preferred Platinum Visa Card (Bank)\nhttp://www.uob.com.sg/personal/cards/credit/preferred_platinum_visa_card.html" },
    { "3B6600FF4A434F503231", "JCOP 21" },
    { "3B6600FF4A434F503330", "JCOP30 'OP-DI 16k VISA v2 (JCOP30) ORGA'" },
    { "3B67000000000000009000", "Axa Bank (Belgium) Mastercard Gold / Axa Bank Belgium\nMisterCash & Proton card\nVISA Card (emitted by Bank Card Company - Belgium)" },
    { "3B67000000000000418684", "ezpu100 (Bank)" },
    { "3B67000000002000009000", "BankID card from Sparebank1" },
    { "3B67000000318071869000", "Swiss ZKB-Bancomat-Card" },
    { "3B67000004124501600111", "Bank ATM card (Bank)" },
    { "3B67000004124501600112", "I & M BANK KENYA (Bank)" },
    { "3B67000004134601600111", "Equity (Bank)" },
    { "3B6700002920006F789000", "ING (previously Postbank Chippas) (chipknip) Netherlands\nRabobank bankcard (dutch)\nASN Bank debit card\nSNS Bank debit card\nABN-AMRO Maestro" },
    { "3B6700002920006F789A00", "ABN AMRO wereldpas" },
    { "3B6700002920006F789F00", "SNS Bank debit card (Bank)" },
    { "3B6700002A200041789000", "Prepaid Chipknip Netherlands" },
    { "3B6700002D201601789000", "CNAMTS and CPAM SSO card (French Health Insurance)" },
    { "3B6700002D203600789000", "Swedish cashcard\nhttp://www.ida.liu.se/~TDDB31/Cashcard.pdf\nBank Card (ING - Belgium)\nSchiphol Group Privium biometric card (Amsterdam Airport entry system)" },
    { "3B6700002E300032689F22", "Stralfors fingerprint card (Other)\nhttps://www.stralfors.com/" },
    { "3B6700004404010000FF07", "Visa Electron card, 'Bank St. Petersburg', Russia (Bank)" },
    { "3B6700007320006B689000", "MyKad (eID)" },
    { "3B6700007320006C..9000", "Malaysia Citizen Identity Card (MyKad)\nhttp://www.jpn.gov.my/en/identitycard" },
    { "3B6700007320006C683132", "Malaysian multipurpose identity card (MyKad) that is also an electronic passport, banking card (MEPS - Malaysian Electronic Payment System) and drivers license. (eID)\nhttps://github.com/OpenSC/OpenSC/wiki/Malaysian-MyKAD" },
    { "3B6700007C2040342B9000", "Swedbank Visa card" },
    { "3B6700007D2040343B9000", "Nordea Visa Sweden" },
    { "3B67000080203A30789000", "CIMB Bank Malaysia, ATM, MEPS/Maestro/Cirrus (Bank)" },
    { "3B67000080622113829000", "UBS MAESTRO CARD (Bank)" },
    { "3B67000085203630789000", "Belgium Fortis Bank\nBelgium Keytrade Bank\nBelgium Post Bank" },
    { "3B67000085221631789000", "Swiss UBS Ebanking Chipcard" },
    { "3B67000085221631789F00", "UBS Token Card (bank)" },
    { "3B67000086602222278001", "ICBC Debit Card (Bank)\nhttp://www.icbc.com.cn/" },
    { "3B67000086884748F5FF08", "Industrial and Commercial Bank of China Savings Card (Bank)\nhttp://www.icbc.com.cn/icbc/" },
    { "3B6700009C10010103FF07", "Schlumberger Cyberflex Palmera Protect" },
    { "3B670000A4207941789000", "UBS Switzerland Debitcard (Bank)\nhttps://www.ubs.com/de/en.html" },
    { "3B670000A52040101F9000", "Swedish eLegitimation (eID) from Nordea Bank\nhttp://www.elegitimation.se/" },
    { "3B670000A6404000099000", "Visa card issued by Norway bank DNBNor" },
    { "3B670000A81042201F9000", "MyKad- Identification Card for Malaysians\nhttp://en.wikipedia.org/wiki/MyKad" },
    { "3B670000AB404026099000", "Swedish VISA credit card (Volvofinans)" },
    { "3B670000AB4040270B9000", "Sparebanken Vest, Norway (spv.no). Visa credit card and national\ndebit card [BankAxept] + Gemalto Todos authentication" },
    { "3B670000B14040320B9000", "Gjensidige Bank Visa debit card (Bank)\nhttps://www.gjensidige.no/privat/bank" },
    { "3B670000B14040330B9000", "Sparebank1 VISA card, Norway\nwww.sparebank1.no" },
    { "3B670000B24040200B9000", "Sodexo BASF Antwerpen company card for Belgian 'meal cheques'" },
    { "3B670000B34040003B9000", "Handelsbanken BankID card (Swedish bank authentication issued 2011)" },
    { "3B670000B44040250B9000", "Electronic meal check" },
    { "3B670000B44040260B9000", "MasterCard Debit MC Student ctls (Bank)" },
    { "3B670000B54040520B9000", "Sodexo card (Other)\nhttp://be.benefits-rewards.sodexo.com/fr/entreprises/sodexo-card" },
    { "3B670000B74040419B9000", "CSOB Master Card (Bank)\nhttps://www.csob.cz" },
    { "3B670000B74040439B9000", "MasterCard (Bank)" },
    { "3B670000B74040449B9000", "Handelsbanken frikort maestro (Bank)" },
    { "3B670000B84040729B9000", "Handelsbanken SE Mastercard (Bank)" },
    { "3B670000C13040010B9000", "MC/Maestro card issued by Czech's 'Ceskoslovenska obchodni banka'" },
    { "3B670000C43040010B9000", "MasterCard issued by Czech's 'Ceskoslovenska obchodni banka'\nSwedish Maestro bank card (Handelsbanken)" },
    { "3B670000C53040010B9000", "Banking card (Oberthur C.S. 03 1027069)" },
    { "3B6700FFC50000FFFFFFFF5D", "Alice Tv italia (Pay TV)" },
    { "3B6725002920006F789000", "Albert Heijn klantenkaart (loyalty card)\nRabopas (Rabobank)" },
    { "3B6725002A20004[05]689000", "Swedish cashcard (proton)" },
    { "3B67250062243303..", "Bull TB1000 ? (SAM for ATM in Luxemburg)" },
    { "3B6800000000000090028184", "Intesa Sanpaolo Bancomat & Maestro Card (Bank)" },
    { "3B680000000262C901459000", "Politecnico di Milano's PoliCard (issued by Banca Popolare di Sondrio, Mastercard prepaid card) (Bank)" },
    { "3B6800000053430660010F90", "Capital one master card (Bank)" },
    { "3B6800000073C84000009000", "Barclaycard Visa Wave & Pay - Chip I/F\nVISA Card (Skandinaviska Enskilda Banken) with Swedish BankID\nPayPal UK MasterCard Chip I/F\nPrepaid Platinum MasterCard for QANTAS Cash, Australia\nMonzo Bank (UK) Debit Mastercard\nbunq (NL) Debit Mastercard\nWescom Credit Union Visa Credit Card (Bank)\nhttps://www.wescom.org/credit-cards/" },
    { "3B6800000073C84010009000", "Icelandic Banking scheme Issued by the Ministry of Treasure in Iceland\nhttp://www.islandsrot.is/" },
    { "3B6800000073C84011009000", "Woolworths Everyday Money prepaid Mastercard\nNordea Bank Norway Visa + national debet card [BankAxept]\nVISA Classic - Nordlandsbanken (Norway)\nCiti Double Cash MasterCard\nWescom Credit Union Visa Debit Card (Bank)\nhttps://www.wescom.org/CHECKING/CHECK-CARD.ASP" },
    { "3B6800000073C84012009000", "Brazilian 'e-CPF' card" },
    { "3B6800000073C84013009000", "MASTERCARD issued by MLP (Marschollek, Lautenschlager and Partner)\nG&D 12696-GDM-10/11 DEBIT CARD issued by BANCO DE CREDITO DEL PERU\nVisa from Caisse populaire Desjardins (Canada) (Bank)\nhttps://www.desjardins.com/\nMasterCard issued by President's Choice Bank (Canada)\nhttp://pcfinancial.ca/mastercard\nMasterCard issued by CIBC (Canada)\nhttp://www.cibc.com/\nMasterCard issued by The Bank of Nova Scotia (Canada)\nhttp://www.scotiabank.com/\nMasterCard issued by JPMorgan Chase Bank, N.A.\nhttps://www.chase.com/\nCaixaBank Visa Electron (Bank)\nhttps://www.lacaixa.cat/" },
    { "3B6800000073C8401300907D", "NextCard - Mastercard Debit card - Intesa Sanpaolo Bank (Italy) (Bank)\nhttps://www.intesasanpaolo.com/it/persone-e-famiglie/prodotti/carte/carte-di-debito/next-card.html" },
    { "3B68000000DE511001019000", "Itau Bank Mastercard Debit Card (Brazil) (Bank)\nhttps://www.itau.com.br" },
    { "3B6800000101309600009000", "Edenred - French Restauration e-Ticket card (2013) (Other)\nhttps://www.edenred.fr/ticket-restaurant" },
    { "3B6800000101310000009000", "VISA ELECTRON Sberbank card (Bank)\nSubmarino MasterCard credit card (Brazil) (Bank)\nhttps://www.submarino.com.br/landingpage/ofertas-cartao-submarino" },
    { "3B6800000102109600009000", "Italian BancoPostaClick Postamat Card (Poste Italiane) -\nMasterCard debit card\nmbna PLATINUM MasterCard\nFlash (Banca Fideuram) Italy prepaid Mastercard" },
    { "3B6800000105200000009000", "Air Bank a.s. MasterCard debit card with PayPass (Bank)" },
    { "3B6800000105219600009000", "PayPal Access (Bank)\nhttps://www.paypal.com/uk/webapps/mpp/accesscard" },
    { "3B6800000105309600009000", "MasterCard issued by mbna (Bank)" },
    { "3B6800004D4343434C322E31", "Mastercard debit card from FIO bank, CZ (Bank)\nhttps://www.fio.cz/bankovni-sluzby/platebni-karty/mastercard-debit-contactless" },
    { "3B68000053430660010F9000", "Credit Card Credicard (Bank)\nhttp://www.credicard.com.br" },
    { "3B68000053430660010F9090", "Discount (Bank)" },
    { "3B68000053432D3031324A53", "Blue (Bank)" },
    { "3B6800005448204E49442036", "Thai id card (Other)" },
    { "3B680000565344434C433130", "VISA (Estonian), made by www.trueb.ch\nLatvian bank 'Latvijas Krajbanka' (VISA Electron)" },
    { "3B6800008062003C83009000", "Italian PostePay prepaid VISA-Electron\nPagoBancomat (Debtcard) Maestro - Intesa Sanpaolo Bank / Italy" },
    { "3B6800008062004583009000", "MasterCard - Intesa Sanpaolo Bank / Italy\nPaypal italia (mastercard)" },
    { "3B6800008066454601381803", "FNMT WG108k" },
    { "3B6800008066575901000203", "Junta de Extremadura (Spain) (PKI)" },
    { "3B6800008066575901000803", "Spanish ULPGC student id card\nhttp://www.ulpgc.es/\nE-Money capability\nAlliance With La Caja de Canarias Bank\nManufactured by GyD IBERICA\nhttp://www.gi-de.com" },
    { "3B6800008066A20308013107", "University ID Card for University of Seville (Other)\nhttp://institucional.us.es/vrelinstitu/carne-universitario" },
    { "3B6800008066A20601016400", "Visa card issued by Czech's 'Komercni banka' (Gemplus brand on chip)" },
    { "3B6800008066A2060201320E", "Gemplus GemClub 1K" },
    { "3B6800008066B00701010707", "Java Gemalto R7 (Bank)\nGemalto Santander Optelio TUI R7 with WG10 using Contact interface" },
    { "3B6800008066B00701017707", "Tecnico Lisboa Student Card (Bank)\nhttp://www.tecnico.ulisboa.pt/\nOther Optelio Card (Santander)\nSantander Totta Student Card - Portugal (Bank)\nhttps://www.santandertotta.pt" },
    { "3B68000081000350010F9000", "Holvi Payment Master Card (Bank)\nhttp://www.holvi.com" },
    { "3B680000990200D103042201", "N26 business debit card (Bank)\nhttps://n26.com/en-de/business-account" },
    { "3B6800009D03020101564953", "Visa Card - SberBank / Russia" },
    { "3B6800009D08010201564953", "Visa Card - bonus - DenizBank / Turkey" },
    { "3B6800009D080103014F5453", "MasterCard Card - bonus - Garanti Bank / Turkey" },
    { "3B6800009D08010301564953", "MasterCard Card - bonus - Garanti Bank / Turkey\nMasterCard Card - bonus plus (paypass) - Garanti Bank / Turkey" },
    { "3B6800009D08010501564953", "MasterCard Card - CartaSi (Italian Credit Card)" },
    { "3B680000A102020101564953", "UK NatWest Business MasterCard\nUK Barclaycard VISA\nUK NatWest Platinum MasterCard\nVisa Card - DenizBank / Turkey" },
    { "3B680000FF29230007689000", "Politecnico di Milano student card\n'Le Chiavi della Citta' SienaCard MINIpay Card" },
    { "3B6800FF0073C84000009000", "Visa credit card for Bank of Taiwan\nCommSec Debit MasterCard (Australia)\nVISA Debit card for Bank of Sydney, Australia" },
    { "3B6800FF382B4152446E7373", "Dummy smart card from vsmartcard project. (Other)\nhttp://frankmorgner.github.io/vsmartcard/remote-reader/README.html" },
    { "3B6800FF4A434F5076323431", "Alfa-bank VISA Classic card (Bank)\nhttps://alfabank.ru" },
    { "3B6800FF56434152446E7373", "NSSVirtual Smart Card for qemu" },
    { "3B690000240C160A0000000000", "LUNCH COUPON (Other)" },
    { "3B6900002494010000000001A9", "Kazakhstan Helios gas station debit card\nhttp://helios.kz/" },
    { "3B6900002494010201000101A9", "Chipcard from SUN to be used in SunRay's\n370-4328-01 (31091)" },
    { "3B6900002494010301000100A9", "Schlumberger MicroPayflex S card" },
    { "3B6900004944353056312E....", "eID Card to user authenticate and save paswords in the Card. Product ID50 Password manager from IDENTOS GmbH (eID)\nhttps://identos.com/id50-password-manager/" },
    { "3B6900004944363056312E....", "token appidkey ID60-USB (Other)\nhttps://identsmart.com/en/products/id60-datasafe/" },
    { "3B6900004A434F503331563232", "Visa Europe Sample Card / Axalto" },
    { "3B6900005001010401000101A9", "Sample card given to all attendees of the CTST 2004 SmartCard Conference" },
    { "3B690000554B542056312E3000", "PostFinance Card Direct (Swiss Post)" },
    { "3B6900005649535F494E462006", "VISA credit card (Ceska Sporitelna)\nMaestro credit card (Ceska Sporitelna)" },
    { "3B6900005792020000000000A9", "SURGUTNEFTEGAZ Fuel station network loyalty card, Russia (Loyalty)" },
    { "3B6900005792020101000100A9", "Sun Microsystems Sun Ray 1G thin client access card (Other)" },
    { "3B6900005A454E20544F4B454E", "Ezio Flex BLE OATH Token (other)\nhttps://data-protection-updates.gemalto.com/2017/03/06/ezio-flex-ble-oath-token-is-launched/" },
    { "3B6900008031E0554245524753", "Banrisul Bank" },
    { "3B6900008065A2........72D6", "Other Optelio Card (Santander MPCOS)" },
    { "3B6900008072A4456400FF0010", "Visa Credit Card Denizbank Afilli Bonus -Turkey (Bank)\nhttp://www.denizbank.com/kartlar/deniz-bonus-card/afili-bonus/" },
    { "3B690000AC04000004B18C6121", "Student card for Universite numerique Paris Ile-de-France\nhttp://unpidf.univ-paris1.fr/la-carte-multiservice-etudiant-de-paris-et-d-ile-de-france-1775.kjsp?RH=unr-carte&RF=unr-carte" },
    { "3B690000C5020201046B0101A9", "Payflex 1K from Schlumberger" },
    { "3B690000EB03010301700108A9", "Gasprom card (JavaCard)" },
    { "3B690000EB03010601700102A9", "Azeriqaz-SOCAR(Azerbaijan) (Other)\nhttp://socar.az/socar/en/home" },
    { "3B690000F704010601800102A9", "Azeriqaz Smart Payment (eID)\nhttp://azeriqaz104.az/" },
    { "3B690000F704010801800102A9", "Multinet (Other)" },
    { "3B69000241434F534A76313031", "ACOSJ 40K Dual Interface (JavaCard)" },
    { "3B69000241434F534A76323033", "ACS ACOSJ Java Card (JavaCard)\nhttps://www.acs.com.hk/en/products/405/acosj-java-card-combi/" },
    { "3B6900FF00644A100432059000", "NXP JCOP 20 V2.1 16K" },
    { "3B6900FF3131313054434F5350", "Seven-Eleven Value Card / Smart Purse - Thailand (Other)\nhttp://www.7eleven.co.th/about7card.php" },
    { "3B6900FF323332435343533336", "CSCS smart card. Must be read using CSCS go smart software.\nhttps://download.cscsreader.co.uk/" },
    { "3B6900FF4A434F503234325232", "MCD 20 (Other)" },
    { "3B6900FF4A434F503331563232", "JCOP 31 v22 72K - S/C I/F" },
    { "3B6900FF536D40727443616665", "G&D (Giesecke&Devrient) Sm@rtCafe" },
    { "3B6A00000.4431314352020025C3", "Feitian Java Card D11CR (JavaCard)\nhttp://www.ftsafe.com/product/smartcard/javacard" },
    { "3B6A00000031C173C84000009000", "Java NXP J2L040 JCOP3 (JavaCard)\nhttps://www.alibaba.com/product-detail/Hico-jcop-plastic-cards-Smart-Card_60547840305.html" },
    { "3B6A000030303030333044333544", "Building access card (eID)" },
    { "3B6A000030303030333044454241", "HID Global DuoProx II Low Frequency 125 KHz (HealthCare)\nhttps://www.hidglobal.com/sites/default/files/resource_files/prox-duoprox-ii-card-ds-en.pdf" },
    { "3B6A00004A434F50313056323331", "Dongle Smart Card (MxKey) (Other)\nhttp://www.mxkey.biz/" },
    { "3B6A00008031C0A1020301328116", "Lloyds TSB Visa Credit/Debit Card" },
    { "3B6A00008065A2........72D6..", "IDClassic 3XX Cards (with MPCOS Applet)" },
    { "3B6A00008065A20101013D72D643", "GemSafe Xpresso 16k" },
    { "3B6A00008065A20102013172D643", "UNISINOS University Student's card (Other)" },
    { "3B6A00008065A20103018D72D643", "American Express Blue Card" },
    { "3B6A00008065A20131013D72D641", "Emirates ID (eID)\nhttp://www.emiratesid.gov.ae/" },
    { "3B6A00008065A20145013D72D643", "STATE OF KUWAIT CIVIL ID CARD (eID)\nhttp://www.e.gov.kw/PACI_en/Pages/EServices/CivilIDValidity.aspx#" },
    { "3B6A00008066A1090201630E9000", "Danish Visa/Dankort\nUK MBNA MasterCard\nVisa Card - Worldcard - YapiKredi / Turkey\nVISA - Lloyds TSB DEBIT\nUK Halifax Visa Debit" },
    { "3B6A00008066A20A01018B0E9000", "CAP-EMV demo card" },
    { "3B6A0000813F017511010281010A", "Huada CIU9872B (Java Card 2.2.2) (JavaCard)" },
    { "3B6A0000866500A758C046009000", "China Merchants Bank card (Bank)" },
    { "3B6A0000866500A758C055009000", "Credit card (Bank)" },
    { "3B6A00FF0031C173C84000009000", "Paypal EMV debit card (Bank)" },
    { "3B6A00FF41424344324546474849", "Austria card - JCOP 31/36K" },
    { "3B6A00FF4A434F50323156323331", "JCOP21 v2.3 Standard" },
    { "3B6A00FF4A434F50343156323231", "JCOP41 Cards (not supported, but recognized by Classic Client)\nNHS hospital smartcard login key (HealthCare)" },
    { "3B6B..FF8062..A25646696E454944", "JCOP20 v2.x" },
    { "3B6B0000000031C0643F680100079000", "EMV (Bank)" },
    { "3B6B0000003180642DA0020C8C6127", "SmartEMV prototype" },
    { "3B6B00000031806443B002008C6127", "Bull Odyssey 1.2 (Javacard 2.0)" },
    { "3B6B00000031C06400273400079000", "American Express Gold Air France - KLM (Bank)" },
    { "3B6B00000031C064002734000F9000", "American Express Chip and Signature Card (Contact) ()\nhttps://americanexpress.com/chipandsignature" },
    { "3B6B00000031C06408046112079000", "Visa Electron. BSB Bank. Belarus (Bank)" },
    { "3B6B00000031C064080461120F9000", "Portuguese National Identity Card (eID)\nhttps://www.autenticacao.gov.pt/o-cartao-de-cidadao" },
    { "3B6B00000031C06408046120079000", "AMEX Bank DI Card (Bank)" },
    { "3B6B00000031C06408046176079000", "Alliance Bank Debit Card (Bank)" },
    { "3B6B00000031C064080461770F9000", "'Strelka' Russian Federation Travelcard (Transport)\nhttp://strelkacard.ru/" },
    { "3B6B00000031C06408046184079000", "American Express credit card (Bank)\nhttps://amex.es/" },
    { "3B6B00000031C064080461840F9000", "Lloyds Bank (UK) 'Avios Duo' American Express credit card (Bank)" },
    { "3B6B00000031C064080461F40F9000", "N26 Maestro Card (Bank)\nhttps://n26.com/maestro-card/\nN26 MasterCard (Bank)\nhttps://n26.com/mastercard/" },
    { "3B6B00000031C064081031040F9000", "Visa - Wells Fargo Debit Card (Bank)" },
    { "3B6B00000031C06408104108079000", "Bank of America Travel Rewards Visa Signature Credit Card (Issued 2018) (Bank)" },
    { "3B6B00000031C064081041100F9000", "Nationwide Building Society regular savings account ATM card (Bank)" },
    { "3B6B00000031C064081051100F9000", "Skrill MasterCard (Bank)\nhttps://www.skrill.com" },
    { "3B6B00000031C06408177100079000", "MasterCard Debit Card for Macquarie Bank, Australia (Bank)" },
    { "3B6B00000031C064083981040F9000", "Visa Debit (Bank)" },
    { "3B6B00000031C064083991080F9000", "MasterCard Bank Card (Bank)\nhttps://www.creditonebank.com/" },
    { "3B6B00000031C064084403040F9000", "VISA debit card (ActivoBank, Portugal) (Bank)\nhttps://www.activobank.pt" },
    { "3B6B00000031C064084403050F9000", "Visa (Bank)" },
    { "3B6B00000031C06408440312079000", "VISA (Bank)" },
    { "3B6B00000031C064084403120F9000", "Debit Card/MasterCard shipped by electronic Bank N26 (Number26) (Bank)\nhttps://n26.com/de-de/\nBBVA (Spain) (MasterCard) debit card (Bank)\nhttps://www.bbva.es/eng/productos/ficha/tarjeta-ahora-bbva/0000009719" },
    { "3B6B00000031C06408440313079000", "MasterCard, Alfa Bank (Russia) (Bank)\nhttps://alfabank.ru/everyday/debit-cards/perekrestok-prepaid/" },
    { "3B6B00000031C064084403680F9000", "Credit card emitted by KBC Brussels, Belgium (Bank)\nAdvanzia Credit Card (Master Card gold), Germany (IDK if there is a difference between the german one and the other ones) (Bank)\nhttps://mastercard.gebuhrenfrei.com/\nItalian Intesa Sanpaolo Superflash Prepaid Mastercard (Bank)" },
    { "3B6B00000031C06408440376079000", "Blu American Express Credit Card (Bank)\nhttps://www.americanexpress.com/it/content/carta-blu/" },
    { "3B6B00000031C064084403760F9000", "Maestro debit card, issued by Caixa Geral de Depositos (Bank)\nhttps://www.cgd.pt/Particulares/Cartoes/Cartoes-de-Debito/Pages/Cartao-Debito-Cauxautomatica-Maestro.aspx" },
    { "3B6B00000031C064131402000F9000", "UBA Card PREPAID (Bank)" },
    { "3B6B00000031C0641F1801000F9000", "Portuguese Medical Association eID card (Cedula Profissional, Ordem dos Medicos, Portugal) (eID)\nhttp://www.omsul.pt/tabid/242/Default.aspx" },
    { "3B6B00000031C0641F270100079000", "SOCCARDRT (HealthCare)" },
    { "3B6B00000031C0641F2701150F9000", "VISA Debit card for HSBC, Australia" },
    { "3B6B00000031C0641F27011C079000", "Raiffeizen Bank, Russia, MasterCard paypass card (Bank)" },
    { "3B6B00000031C0641F2701350F9000", "V PAY (Bank)\nhttps://www.unicreditbulbank.bg/en/individual-clients/everyday-banking/payments/debit-cards/" },
    { "3B6B00000031C0643F6801020F9000", "dinacard (Bank)" },
    { "3B6B00000031C0643F680103079000", "American Express Blue Cash (Bank)\nhttps://www.americanexpress.com/us/credit-cards/" },
    { "3B6B00000031C0643F6801030F9000", "HSBC Credit Gold Card  from VISA (Bank)" },
    { "3B6B00000031C0643F6801040F9000", "VISA credit card (ActivoBank, Portugal) (Bank)\nhttps://www.activobank.pt" },
    { "3B6B00000031C0643F68010B0F9000", "MasterCard credit card (Bank)" },
    { "3B6B00000031C064A9EC0100829000", "Entropia Universe Gold card\nhttp://account.entropiauniverse.com/account/security/" },
    { "3B6B00000031C064BC020100829000", "Flazz BCA Indonesia (Other)\nhttps://www.bca.co.id/flazz" },
    { "3B6B00000031C064BE1B0100079000", "MTS Bank MasterCard paypass card (Bank)\nhttps://www.mtsbank.ru/" },
    { "3B6B00000031C064BE1B01000F9000", "An old version of the Politecnico di Milano student ID. It doubles as a VISA debit card for Banca Popolare di Sondrio. (Other)\nhttp://www.popso.it/attivamentepolimi" },
    { "3B6B00000031C064BE1B01030F9000", "dsafas (Telecommunication)" },
    { "3B6B00000031C064D0100100079000", "Alfa-Bank (Russia) Master Card (Aeroflot bonus) (Bank)" },
    { "3B6B00000031C16408603206079000", "HSBC (Bank)" },
    { "3B6B00000031C164086032060F9000", "Nationwide Building Society VISA Debit card (Bank)" },
    { "3B6B00000031C164086032100F9000", "ICA Bank, Mastercard (Bank)\nhttps://www.icabanken.se/kort-och-betala/bankkort/" },
    { "3B6B00000031C1640860321F079000", "NMRC Card (Transport)" },
    { "3B6B00000031C1640860321F0F9000", "Fio bank, Mastercard, credit (Bank)\nhttps://www.fio.cz/bankovni-sluzby/platebni-karty/kreditni-karty" },
    { "3B6B00000031C164086032200F9000", "Twisto (Bank)" },
    { "3B6B00000031C164087771300F9000", "Apple Card (from launch) (Bank)\nhttps://www.apple.com/apple-card/" },
    { "3B6B00000031C164089862010F9000", "Sodexo Czech Gastro/Multipass (Other)\nhttps://www.sodexo.cz/" },
    { "3B6B000020900000000000B0A2BD69", "Fudan FM1280 (JavaCard)" },
    { "3B6B0000426C756361726420344B42", "Blutronics Blucard 4K (Loyalty)\nhttp://blucard.blutronics.com" },
    { "3B6B00004348495031342056312E30", "Swiss PostFinance Card (Bank)\nhttps://www.postfinance.ch/en/priv/prod/card/pfcard.html" },
    { "3B6B00004750003A060141200F9000", "SBI Debit Card (Bank)\nhttps://www.sbi.co.in/portal/web/personal-banking/state-bank-classic-debit-card" },
    { "3B6B0000475000630A0040000F9000", "cash app visa prepaid debit (Bank)\nhttps://cash.app/" },
    { "3B6B000053430015020250010F9000", "Visa (Bank)" },
    { "3B6B000053430015080250010F9000", "ALELO-BENEFICIOS (Other)" },
    { "3B6B00008031C06348107F83E09000", "ABL card (Bank)\nasdasd (Bank)" },
    { "3B6B0000805A4458544F4B454E3031", "DXToken - Dexon Cryptography Token (Other)\nhttp://www.dexon.ind.br" },
    { "3B6B00008065A109030197830E9000", "Visa Card - Worldcard - YapiKredi / Turkey" },
    { "3B6B00008065B083......83009000", "IDClassic 3XX Cards (without MPCOS Applet - FIPS)" },
    { "3B6B00008065B08301017483009000", "GemXpresso Pro R3 with 64K EEPROM" },
    { "3B6B00008065B08301037483009000", "Gemplus GemXpresso PRO 64K R3 v1" },
    { "3B6B00008065B08301047483009000", "Gemplus GXP3 64V2N\nU.S. Department of Defense Common Access Card (DoD CAC)" },
    { "3B6B000081007226010010000F9000", "Debit card issued by Falabella Bank of Peru from IDEMIA (Bank)\nhttp://www.bancofalabella.pe" },
    { "3B6B000081007226020040000F9000", "Yuna To Go prepaid MasterCard (PaySafeCard) (Bank)\nhttp://yunacard.com\nPaygoo Reload Mastercard" },
    { "3B6B000081007226020041000F9000", "Wave Crest Holding (Bank)" },
    { "3B6B000081007843040241010F9000", "Max Mastercard (Bank)\nhttps://www.aumax.fr" },
    { "3B6B00FF33000009FA10008001FFFF", "Atmel 6464C PRO 64K" },
    { "3B6B00FF56434152445F4E5353", "NSSVirtual smart card for qemu" },
    { "3B6C00000A0B0C0A0B0C0A0B0C0A0B0C", "Estonian Residence Permit (eID)" },
    { "3B6C00000F31C071D664136A01005D84", "MasterCard debit card: skrill.com card issued by Newcastle Building Society (Bank)\nhttps://www.skrill.com\nNationwide InvestDirect (UK)\nMasterCard debit card issued by Santander Brasil (Bank)\nhttps://www.santander.com.br" },
    { "3B6C00000F31C071D6643E6701005D84", "Banca Transilvania VISA CARD (Bank)" },
    { "3B6C00000F31C071D6643E6701015D84", "VISA GOLD or Maestro, issued by Swedbank Lithuania (Bank)\nVISA credit card, issued by HSBC Commercial Card UK (Bank)\nhttp://www.swedbank.lt/lt/pages/privatiems/auksine_kredito_kortele\nHSBC Commercial Card (UK) VISA\nCapital One UK Platinum MasterCard" },
    { "3B6C0000101010300000000000000000", "Datacard Group Aptura Development Card V1.1b" },
    { "3B6C0000426C756C6F676F6E20344B42", "eID Blutronics Blulogon 4K\nhttp://shop.blutronics.com/Prodotti.asp" },
    { "3B6C00004E544943339051024A030000", "Topas TV (Pay TV)" },
    { "3B6C000080641134014873F741C08107", "Universal Electronic Card (UEC Russia) (eID)" },
    { "3B6C0000806411650190730000008107", "Universal Electronic Card (UEC Russia) (eID)" },
    { "3B6C0002366186384B8C13046203598A", "Nagravision, Swiss mode" },
    { "3B6C00FF8073C8211366010611590001", "Visa Crypto Business Electron by neyvabank.ru (Bank)\nhttps://neyvabank.ru/uploads/files/download/bankdirectvisacryptocardreader.pdf" },
    { "3B6D0000", "PVT (Bank)" },
    { "3B6D0000003180642DA0040C71968C6129", "UK Co-operative Bank Visa Debit (produced 2002)" },
    { "3B6D000000318071966433D10100829000", "DeLaRue GalactIC JavaCard" },
    { "3B6D00000031C071D66411223301839000", "Egg (bank) VISA\nFirst Direct (bank) Maestro card\nFirst Direct Gold VISA\nUK Barclaycard Platinum VISA\nUK Barclaycard VISA\nUK Halifax Platinum VISA\nUK HSBC MasterCard\nUCFIN (Italy) 'UniCreditCard Free' or 'Plus' (VISA or MasterCard) credit card" },
    { "3B6D00000031C071D66419160100849000", "Eurocard Corporate MasterCard issued by Eurocard AB Sweden\nCapital One (UK) MasterCard\nVISA card, issued by Swedbank Latvia\nVISA issued by Citibank International plc (manufacturer Oberthur)\nVISA/Maestro/MasterCard, issued by Swedbank LT/EE (manufacturer: Oberthur)\nMasterCard issued by Swedbank Estonia (manufacturer Oberthur)\nSantander Business Visa Debit" },
    { "3B6D00000031C071D66419160102849000", "VISA (JavaCard)" },
    { "3B6D00000031C071D66434C70100849000", "DeLaRue ProlifIC" },
    { "3B6D00000031C071D66434C70200849000", "Cybelys card (Thalys fidelity card)" },
    { "3B6D00000031C071D66438D00200849000", "EMV Visa Electron (Oberthur)" },
    { "3B6D00000031C071D66438D00300849000", "HSBC Visa/MasterCard credit card\nBarclay Card MasterCard" },
    { "3B6D00000031C071D6644ED80101849000", "UK Capital One Platinum MasterCard" },
    { "3B6D00000031C071D66458D70100849000", "UK Nationwide Bank Visa Delta\nUK First Direct Maestro\nUK Halifax Platinum Visa\nUK Co-operative Bank Visa Debit (produced 2003-2004)\nUK HSBC LiveCash Solo Debit card" },
    { "3B6D00000031C071D664A0010400849000", "Swiss Mastercard M-Budget (Bank)" },
    { "3B6D00000031C071D66511223301839000", "UK Co-operative Bank Visa Debit (produced 2006)" },
    { "3B6D000000664D453153050653036104F0", "FutureCard Ind. LLC / Feb-18 | Blank card for programming (JavaCard)" },
    { "3B6D00000073C800136447374532009000", "Canada TD Bank Visa Debit/Interac Debit Card (Bank)" },
    { "3B6D00000073C80013644A374237009000", "Sberbank Visa card (Bank)" },
    { "3B6D00000073C800136454334433009000", "FirstBankcard issued for overstock.com (Bank)\nhttp://www.firstbankcard.com/overstock/" },
    { "3B6D00000073C800136454344233009000", "chase (Bank)" },
    { "3B6D00000073C800136454344432009000", "Metrobank debit (Bank)" },
    { "3B6D00000073C800136454344631009000", "Discover (Bank)\nhttps://www.discover.com/credit-cards/" },
    { "3B6D00000073C800136454374138009000", "German comdirect bank - Visa Credit, prepaid (Bank)\nimaginBank (Spain) (VISA Electron) debit card (Bank)\nhttps://www.imaginbank.com/preguntasfrecuentes/tarjeta_en.html" },
    { "3B6D00000073C800136454374234009000", "Visa Electron Debit Card (Bank)\nhttp://www.creditoagricola.pt/CAI" },
    { "3B6D00000073C800136454374237009000", "VISA GOLD WITH CHIP (Bank)\nNatWest (UK) Current account VISA Debit" },
    { "3B6D00000073C800136454374333009000", "SEB Debit mastercard (Skandinaviska Enskilda Banken) (Bank)\nhttps://seb.se/privat/betala/kort/seb-debit" },
    { "3B6D00000073C800136454374335009000", "ABANCA Mastercard Credit Card (Bank)" },
    { "3B6D00000073C800136454374433009000", "Deutsche Bank MasterCard Credit Card (Bank)\nhttps://www.deutsche-bank.de/pfb/content/pk-konto-und-karte-kreditkarte.html" },
    { "3B6D00000073C800136454374B33009000", "Fineco (Italy) Bancomat (Visa) (Bank)" },
    { "3B6D00000073C800136454374B34009000", "BNL (Banca Nazionale Del Lavoro, BNP Paribas Group) Debit Card (Bank)\nhttps://bnl.it/it/Individui-e-Famiglie/Carte/Carta-di-Debito-BNL" },
    { "3B6D00000080318065B0893501F183009000", "MasterCard  (Bank)" },
    { "3B6D000000814D22088660222228400001", "Unipay Credit Card Issued by CITIC (Bank)" },
    { "3B6D0000009008209000900000FFFFFFFF", "Student college card" },
    { "3B6D00004946582D6A6333303167703232", "MasterCard Debit card of N26 bank (Bank)" },
    { "3B6D00005744285746035062136568541F", "Card for decrypt encrypted tv channels made in china  (Pay TV)" },
    { "3B6D00005744296C808693D1271F13323D", "SCSTA (Transport)" },
    { "3B6D00005744296C808693D603EE082A3D", "SCSTA (Transport)" },
    { "3B6D000057443641018693073037373633", "Watchdata USB Key (PKI)" },
    { "3B6D000057443641018693073131323235", "Watchdata Proxkey (PKI)\nhttps://www.watchdata.com/" },
    { "3B6D000057443641018693073231343431", "Watchdata USB Key (PKI)" },
    { "3B6D000057443641018693073231363432", "Watchdata USB Key (Other)" },
    { "3B6D000057443641018693073332353530", "Watchdata Proxkey (PKI)\nhttps://www.watchdata.com/" },
    { "3B6D0000574436410186930739........", "WatchData Proxkey with VID:PID as 0x163C:0x0417 (PKI)\nhttp://www.watchdata.com/class.php?id=19" },
    { "3B6D000080318065495301000183079000", "Yandex money world card (Bank)\nhttps://money.yandex.ru" },
    { "3B6D000080318065495301030183079000", "MTS Money Bank Card (Bank)" },
    { "3B6D000080318065495302020183079000", "MasterCard SMP BANK (Bank)\nhttps://smpbank.ru/" },
    { "3B6D000080318065495304030183079000", "Mastercard Tinkoff.ru platinum (black) (Bank)\nhttps://www.tinkoff.ru/" },
    { "3B6D00008031806549530605FF83079000", "MIR Debit Card (Russia), Bank of Saint Petersburg (Bank)\nhttps://www.bspb.ru/retail/cards/standard-classic/" },
    { "3B6D000080318065B00601017783009000", "GemXpresso Lite: with EMV application" },
    { "3B6D000080318065B00702028983009000", "JCOP30 contact interface" },
    { "3B6D000080318065B04301007783009000", "Gemplus GemXpresso Lite" },
    { "3B6D000080318065B083......83009000", "IDClassic 3XX / Classic TPC (IXS, IS, IS V2, IS CC, IM, IM CC, IM CC V3) / MultiApp ID Cards" },
    { "3B6D000080318065B08301029083009000", "DeutscheBank Identification card" },
    { "3B6D000080318065B08302047E83009000", "LuxTrust card\nhttps://www.luxtrust.lu/solutions/comp/cartech2\nhttps://www.luxtrust.lu/faq/middleware/middleware" },
    { "3B6D000080318065B0831140C883009000", "Gemalto TOP IM\n(Old name GemSafeXpresso 64)" },
    { "3B6D000080318065B0840100C883009000", "Optelio Cards (D38-D72 R6) T=0 Normal Speed" },
    { "3B6D000080318065B08626010883089000", "RBC Royal Bank VISA (Bank)" },
    { "3B6D000080318065B0872701BC83089000", "Kazcommertsbank\nhttp://en.kkb.kz/page/WhoWeAre\none of the biggest banks in Republic of Kazakhstan\nNordea (Finland) + Finnair MasterCard (credit)\nGXP7 T=0" },
    { "3B6D000080318065B0873401D783009000", "Fidelity Investment Rewards (AMEX) (Bank)\nhttps://www.fidelity.com/cash-management/american-express-cards" },
    { "3B6D000080318065B0893501F183009000", "Bank of America BankAmericard Travel Visa Chip Card (Gemalto)\nhttps://www.bankofamerica.com/credit-cards/products/bankamericard-travel-rewards-credit-card.go\nCredito Trevigiano - Banca di Credito Cooperativo - Carta BCC\nVISA Signature issued by RBC Bank (Georgia), N.A.\nhttps://www.rbcbank.com/\nBanca Popolare di Novara - (Bancomat Maestro)" },
    { "3B6D000080318065B0894001F283009000", "PSAM Card" },
    { "3B6D00008067A1110101640855830E9000", "Italian Intesa SanPaolo Maestro" },
    { "3B6D00FF003180718E6448D50200829000", "Blue for Business, American Express@Business" },
    { "3B6D00FF80655343010D067394211B810[15]", "Giesecke & Devrient CardToken 350 (ICCD)" },
    { "3B6D00FF8073002113574A544861314700", "ActiveKey SIM" },
    { "3B6D00FF8073002113574A544861314800", "Spanish Medical College Card" },
    { "3B6E00000031807186650164022232809000", "MasterCard Card - bonus plus (paypass) - Garanti Bank / Turkey" },
    { "3B6E00000031807186650164022232839000", "MasterCard Card - bonus YKM - Garanti Bank / Turkey" },
    { "3B6E0000003180718665016702A00A839000", "Australian ANZ First Visa Card from the ANZ\n(Australia and New Zealand) Bank" },
    { "3B6E00000031807186654744230102839000", "Nat West Master Card" },
    { "3B6E00000031807186654744240181839000", "MasterCard Card - Maximum - IS Bank / Turkey\nVisa Card - Axess - Akbank / Turkey" },
    { "3B6E00000031C0650AD702008271D68C6133", "Lloyds (Bank)" },
    { "3B6E00000031C0650AD702008271D68C6137", "MasterCard credit card issued by Citadele bank (Latvia) including e-Talons (public transportation system) (Bank)" },
    { "3B6E00000031C0650AD702008271D68C615A", "mastercard (Bank)\nhttp://nickel.com" },
    { "3B6E00000031C06554B601008471D68C612C", "Kazakhstan Centrcredit bank VISA electron card\nhttp://www.bcc.kz/en/" },
    { "3B6E00000031C06554B601008471D68C6131", "UK BARCLAYS VISA Connect Debit card.\nThe chip is used for the Chip&PIN application common for all UK-issued cards\nhttp://www.chipandpin.co.uk/" },
    { "3B6E00000031C06554B601008471D68C6135", "VISA Electron of Commerzbank AG (Bank)\nhttps://www.commerzbank.com/" },
    { "3B6E00000031C06576B401016071D68C611F", "MasterCard Silver from Viseca Card Services SA\nhttp://www.viseca.ch/html/en/kreditkarten/produkte_neutrale_karten.php" },
    { "3B6E00000031C06577B201014771D68C6133", "VISA Credit Card (National Bank of Greece)" },
    { "3B6E00000031C06577B201034771D68C6131", "UK Barclaycard Business VISA\nNationwide Building Society (UK) Visa Debit and Credit Cards" },
    { "3B6E00000031C06577B201034771D68C6137", "Italian Soldintasca Sanpaolo prepaid VISA-Electron" },
    { "3B6E00000031C06577B301007071D68C61..", "Italian Bancomat (debit card)" },
    { "3B6E00000031C0657CB501008071D68C612C", "Kazakhstan Kazkom bank VISA electron card\nhttp://en.kkb.kz/" },
    { "3B6E00000031C0657CB501008071D68C6135", "MasterCard Classic, issued by Avangard Bank (Russia)\nhttp://avangard.ru/" },
    { "3B6E00000031C0657CB501008071D68C6137", "Swedbank MasterCard card" },
    { "3B6E00000031C0657CB501018071D68C6121", "MUFG CARD (AMEX .jp) (Bank)\nhttp://www.cr.mufg.jp/mufgcard/support/webs/" },
    { "3B6E00000031C065BCD002010671D68C612E", "Lloyds TSB Mastercard Credit Card" },
    { "3B6E00000031C065BCD002010671D68C6133", "Lloyds TSB Visa Debit\nBarclays Visa DEBIT" },
    { "3B6E00000031C065BCD002010671D68C6143", "S-pankki (Finland) Visa Debit" },
    { "3B6E00000031C065BCD102010171D68C6133", "Travelex Cash Passport - Prepaid MasterCard Currency Card" },
    { "3B6E00000031C065BCD102010171D68C6135", "MasterCard Card, issues by Rabobank in the Netherlands" },
    { "3B6E00000031C065D3C102012871D68C6122", "Visa debit card" },
    { "3B6E00000031C065D3C102012871D68C6125", "BBK (Spain) (VISA,  Euro 6000) credit card (Bank)" },
    { "3B6E00000031C065D3C102012871D68C6133", "SberBank Silver Debit Card" },
    { "3B6E00000031C065D3C102012871D68C6139", "Paypal Italy prepaid Mastercard" },
    { "3B6E00000031C065D3C202000571D68C6135", "Italian Intesa SanPaolo VISA\nIntesa Sanpaolo Bancomat & Maestro Card (Bank)" },
    { "3B6E00000031C065D3C202000571D68C6139", "Italian Bancomat (Cassa di Risparmio di Rimini) (bank card)" },
    { "3B6E00000031C065D3C302030171D68C613B", "American Express Platinum from Banco do Brasil" },
    { "3B6E00000031C065E2C402010171D68C6122", "mastercard (Bank)" },
    { "3B6E00000031C065E2C402020171D68C6125", "Spanish 'Santander' bank - Maestro debit card - Made by gemalto sp SA" },
    { "3B6E00000031C065E7D202011071D68C6123", "Visa debit card: mBank - BRE Bank SA" },
    { "3B6E00000031C065E7D202011071D68C6127", "ATEbank VISA (Bank)" },
    { "3B6E00000031C065E7D202011071D68C6133", "Clydesdal Bank Maestro Card\nhttp://www.cbonline.co.uk/personal/current-accounts/debit-card/" },
    { "3B6E00000031C065E7D202011071D68C6135", "Knab Bank debit card (Bank)\nhttp://knab.nl" },
    { "3B6E00000031C065E7D202011071D68C6137", "UCFIN (Italy) 'UniCreditCard Free' or 'Plus' (VISA or MasterCard) credit card" },
    { "3B6E00000031C065E7D202011071D68C6139", "Yandex Money MasterCard (Bank)\nhttp://money.yandex.ru" },
    { "3B6E00000031C065E7D202011071D68C613D", "VISA credit card (Nordea DK) (Bank)\nhttps://www.nordea.dk/om+nordea/nordeadk+in+brief/visa+dankort+card/1619932.html" },
    { "3B6E00000031C065E7D202011071D68C6141", "VISA by CAL ( Israeli Credit Card Company ) (Bank)\nhttps://www.cal-online.co.il/he-IL/Cal/Pages/home.aspx" },
    { "3B6E00000031C065E7D202011071D68C6147", "Hellenic Bank Visa Electron (Gemalto)" },
    { "3B6E00000031C065ECD402000871D68C6133", "Victoria Bank (Republic of Moldova) - Visa Electron" },
    { "3B6E00000031C065EEC502010B71D68C6139", "Desjardins Bank Acces (Bank)" },
    { "3B6E00000031C065F1D502010971D68C6133", "HALIFAX (Bank)" },
    { "3B6E00000031C065F7C602000671D68C6133", "Visa Card - SberBank / Russia (Bank)\nhttp://sberbank.ru/" },
    { "3B6E00000031C065F7C602000671D68C6137", "Finnish Ticket lunch card (Edenred) (Bank)" },
    { "3B6E00000031C065F7C602000671D68C6139", "'Ticket Restaurant' Edenred Espana S.A. (Bank)\nhttp://www.edenred.es/ticket-restaurant/tarjeta-restaurante" },
    { "3B6E00000031C065F8D602010771D68C6123", "Visa debit card: mBank S.A. (Bank)" },
    { "3B6E00000031C065F8D602010771D68C6127", "VISA Credit Card issued by Santander Bank (Bank)" },
    { "3B6E00000031C065F8D602010771D68C612E", "Sainsbury's Bank MasterCard (Bank)" },
    { "3B6E00000031C065F8D602010771D68C6133", "Tesco Bank Credit Card (VISA) (Bank)\nTesco Bank UK MasterCard ClubCard Credit Card" },
    { "3B6E00000031C065F8D602010771D68C6135", "Bank Of Ireland Visa Debit (Bank)" },
    { "3B6E00000031C065F8D602010771D68C6137", "UCFIN (Italy) 'UniCreditCard Free' or 'Plus' (VISA or MasterCard) credit card" },
    { "3B6E00000031C065F8D602010771D68C6139", "CartaBcc Classic VISA (Bank)\nhttps://www.cartabcc.it/privati/carte-di-credito-privati/Pagine/Classic.aspx" },
    { "3B6E00000031C065F8D602010771D68C6141", "Estonian bank 'SEB' (MasterCard warm) (Bank)" },
    { "3B6E00000031C065F8D602010771D68C615A", "Compte-Nickel bank card (Bank)\nhttps://compte-nickel.fr/" },
    { "3B6E00000031C07186650164022233839000", "UK NatWest ServiceCard 100 Maestro\nVisa Card - bonus - Garanti Bank / Turkey\nUK Royal Bank of Scotland Highline Maestro Debit" },
    { "3B6E00000031C07186650178012734839000", "UK NatWest ServiceCard 100 Maestro\nVisa Card - Gold - CARDFINANS / Turkey" },
    { "3B6E00000031C071866501BB01133B839000", "NatWest Servicecard 100 - Maestro ATM\nNatWest Visa Debit" },
    { "3B6E00000031C07186650202040441839000", "CIBC (Canada) 'Platinum' (VISA) credit card\nING Direct (Italy) 'Gold' (VISA) credit card\nING Direct (Italy) 'Bancomat' (V PAY) debit card\nHSBC (Canada) (Interac/Cirrus/The Exchange) debit card\nUniCredit (Italy) 'Bancomat' (Maestro) debit card" },
    { "3B6E00000031C071866502020404418390F0", "Italian Hellobank Maestro (Bank)\nhttps://hellobank.it/it/guide/Carte" },
    { "3B6E00000031C071C66501B0010337839000", "NatWest (UK) 'Business' (MasterCard) credit card\nNatWest (UK) (Maestro) debit card\nSantander Totta (Portugal) 'JA KA KONTA' (VISA Electron) debit card\nANZ (Australia) (VISA) credit card\nMillennium BCP (Portugal) (VISA Electron) debit card\nOpenBank (Spain) (VISA) credit card\nCIBC (Canada) debit card\nUniCredit (Italy) 'Genius Card' (MasterCard) debit card\nUniCredit (Italy) 'UniCreditCard Click' (MasterCard) debit card\nVISA Electron debit card from the Spanish branch of ING Direct (bank)" },
    { "3B6E00000031C071C66501B001033A839000", "MasterCard hostet by Deutsche Bank, Germany\nMaestro card by Caja de Burgos, Spain\nMasterCard Debit Card issued by Spain Openbank (www.openbank.es)" },
    { "3B6E00000031C071C66501B0013137839000", "Electron VISA Credit Card (BANK OF Cyprus)" },
    { "3B6E00000031C071C665170B04362D0F9000", "Capitec Bank Card (Bank)" },
    { "3B6E00000031C071C665190204062F0F9000", "UniCredit (Italy) 'Bancomat' (Maestro) debit card (Bank)" },
    { "3B6E00000031C071C66519020406320F9000", "Visa Electron card (Bank)" },
    { "3B6E00000031C071C665237B027539839000", "MASTERCARD (CARTASI') (Bank)" },
    { "3B6E00000031C071C665422C013535839000", "UniCredit (Italy) 'UniCreditCard Classic' (VISA) credit card" },
    { "3B6E00000031C071C665710C043536839000", "NatWest VISA Business Debit\nVISA Debit Card (NatWest / ING DiBa)\nKomercni Banka, A.S., Visa Debit, Czech Republic" },
    { "3B6E00000031C071C6657304042538839000", "Itau Debit Card (mastercard) (Bank)\nhttps://www.itau.com.br" },
    { "3B6E00000031C071C665740B0416310F9000", "Creditcard Deutsche Bank\nNatWest (UK) Savings account PLUS card" },
    { "3B6E00000031C071D66438D003008490", "visadebit (Bank)" },
    { "3B6E00000031C071D665120D018100839000", "VISA Gold (VISA ORO) from the Spanish branch of ING Direct (bank)\nhttp://www.ingdirect.es/tarjetas-ing/\nVisa Credit Card issued by Spain Cetelem for PayPal (www.paypal.es/cetelem)\nMasterCard debit card: moneybookers.com card issued by Newcastle Building Society\nMasterCard debit card (Maestro) issued by Caixa\nhttp://www.caixa.gov.br/" },
    { "3B6E00000031C071D665130D018100839000", "Mastercard Black issued by Banco do Brasil (www.bb.com.br)\nManufactured by Oberthur (www.oberthur.com)" },
    { "3B6E00000031C071D6657DE40110A0839000", "VISA card, issued by the ANWB, the Dutch national Automobile club\nVISA Card - Maximum - Oyak Bank / Turkey\nVISA - Barclays Premier" },
    { "3B6E00000031C071D6657DE40111A0839000", "UK CapitalOne Platinum Mastercard" },
    { "3B6E00000031C071D66594E8034000839000", "First Direct UK VISA Debit\nItalian Cariparma Maestro\n'Net+ Mastercard card' from netpluscards.com, Neteller\nUCFIN (Italy) 'UniCreditCard Free' (VISA) credit card\nCirrus ATM Card issued by Permanent TSB in Ireland" },
    { "3B6E00000031C071D665A303018000839000", "UK First Direct (HSBC) Maestro / Cirrus\nUK Capital One Platinum MasterCard\nHSBC Commercial Card Visa\nVISA issued by Czech's 'Komercni banka' (member of Societe General group)\nPortugal Caixa Geral de Depositos debit card\nThe co-operative bank VISA Debit\nSberBank Silver Debit Card (VISA)\nMaestro/Cirrus/Laser Card issued by Bank of Ireland in Ireland" },
    { "3B6E00000031C071D665CE0B014000839000", "Nationwide InvestDirect (bank)\nSberBank Gold Credit Card (VISA)" },
    { "3B6E00000031C071D665CE0B014100839000", "Intesa Sanpaolo Bancomat & Maestro Card (Bank)" },
    { "3B6E0000003B6B00000031C0640810410807", "Bank Of America Signature Visa (Bank)\nhttps://www.managerewardsonline.bankofamerica.com/RWDapp/ns/home?mc=SIGRWD&locale=en_US" },
    { "3B6E0000003B6F00008031E06B04546B0201", "Visa Prepaid Debit Card (Bank)\nhttps://www.visaprepaidprocessing.com/eddcard" },
    { "3B6E00000062..43574156414E5410819000", "Setec SetCOS 4.3.0" },
    { "3B6E000000620000574156414E5410819000", "Setec SetCOS 5.1.0 EMV + AVANT" },
    { "3B6E000000621643..4156414E541081....", "Setec SetCos 4.3.0" },
    { "3B6E000000628042574156414E5410819000", "Sampo Pankki (Finland) (now known as Danske Bank) ATM card (Bank)" },
    { "3B6E00000073C80013645430334520009000", "Day Tronic Flex electronic meal vouchers (Other)\nhttps://www.day.it/buoni-pasto" },
    { "3B6E00000073C80013645744303320009000", "Up Day Tronic electronic meal voucher card (Italy) (Other)\nhttps://www.day.it/pausa-pranzo-buoni-pasto" },
    { "3B6E000033304A3033868876703676332E30", "Agricultural Bank of China (Bank)" },
    { "3B6E00004573744549442076657220312E30", "Estonian Identity Card (EstEID v1.1 'MULTOS' cold)" },
    { "3B6E00004B41444E494B414876312E309000", "Nikah, Cerai, Rujuk (NCR) - The marriage information with identity of Husband and Wife registered at Jabatan Agama Islam Selangor, Malaysia (eID)\nhttp://ncr.jais.gov.my/" },
    { "3B6E00005744361369869302221936281211", "bb token bank Banco do Brasil (Bank)" },
    { "3B6E00005744361369869302321256282532", "Watchdata Brazil CSP v1.0 (Banco do Brasil)\nhttp://www.watchdata.com/en/bank/solutions.jsp" },
    { "3B6E00005744361969869302211815500E2B", "Usb Token from watchdata from Brazil (PKI)\nhttp://www.watchdata.com/brazil/watchkey/index.htm" },
    { "3B6E00005744361969869302211815502027", "Watchdata USB Key (PKI)\nhttp://www.watchdata.com/brazil/watchkey/index.htm" },
    { "3B6E00005744361969869302231815502008", "Card used by SERPRO at Brazil (PKI)\nhttps://www.watchdata.com/ese/" },
    { "3B6E00005744361969869302241175421D0E", "Watchdata USB Key (eID)" },
    { "3B6E0000574436196986930225117542322B", "Watchdata USB Key (PKI)\nhttp://www.watchdata.com/brazil/watchkey/" },
    { "3B6E00005744361969869302311815500615", "WatchData USB Key (Other)" },
    { "3B6E0000574436196986930233117542331E", "Watchdata USB token (white, Serpro Brasil) (Other)\nhttps://www.watchdata.com/tokenwatchdata/" },
    { "3B6E00005744361969869302351175421630", "WATCHDATA USB KEY (Other)\nhttps://www.watchdata.com/" },
    { "3B6E0000626C756361726420324B422F7634", "eID Blutronics Blucard 2K\nhttp://blucard.blutronics.com" },
    { "3B6E0000626C756361726420344B422F7634", "eID Blutronics Blucard 4K\nhttp://blucard.blutronics.com" },
    { "3B6E0000626C756361726420384B422F7634", "eID Blutronics Blucard 8K\nhttp://blucard.blutronics.com" },
    { "3B6E00008025A00000002856801024000111", "Opencard, new card in Prague, Czech Republic (transport card)" },
    { "3B6E000080318065B00301015E8300009000", "FirstUSA Visa" },
    { "3B6E000080318065B00302015E8300009000", "Gemplus GemXpresso 211is" },
    { "3B6E000080318066B0070300AC0183009000", "e-payment card with topup system, propreteary by local bank\nhttp://www.klikbca.com/individual/silver/product.html?s=69" },
    { "3B6E000080318066B0840C016E0183009000", "Optelio Cards (D72 R4 WR)\nNordea (a Skandinavian bank) eID card\nhttp://linux.fi/wiki/Nordea_eID\nRBC Royal Bank Client Card (bank in Canada)\nBanco Santander TUI/USC R7\nGemalto Optelio/Desineo D72 (JavaCard) with WG10 and Maestro (JavaCard) (Bank)\nCarte Ticket Restaurant with MasterCard\nCitigold VISA Debit for Citibank, Australia\nPlatinum VISA card for Citibank, Australia\nVISA Infinite issued by RBC Royal Bank (Canada)\nhttp://www.rbc.com/\nPostepay Evolution - Poste Italiane (mastercard)\n'la Caixa' (Spain) (VISA Electron) debit card (Bank)\nhttps://www.lacaixa.es/\nItalian Webank.it BPM Banca Popolare di Milano Bancomat & Maestro Card (Bank)" },
    { "3B6E000080318066B08412016E0183009000", "Barclaycard Platinum VISA\nInteligo debit card\nVISA issued by ING (Poland)\nVISA Debit card for ING Direct, Australia\nVISA Gold issued by RBC Royal Bank (Canada)\nhttp://www.rbc.com/\nGas Natural Fenosa Visa (issued by CaixaBank) (Bank)\nhttp://www.clubfenosa.gasnaturalfenosa.es/ca/1285341160257/targeta+gas+natural+fenosa.html" },
    { "3B6E000080318066B08416016E0183009000", "UK 'Barclaycard Gold VISA' with RFID" },
    { "3B6E000080318066B0870C016E0183009000", "Banco Santander TUI/USC R7 - Gemalto Optelio/Desineo D72 (JavaCard)\nhttp://www.observatoriotui.com/home" },
    { "3B6E000080318066B1A1110100F683009000", "Gemalto Desineo D72 FXR1 (PKI)\nGemalto TOP DL V2 (PKI)" },
    { "3B6E000080318066B1A11101A0F683009000", "Optelio D72 FXR1 (MD) T=0" },
    { "3B6E000080318066B1A30101210A83009000", "French 'Livret A' issued by 'La banque postale' (Bank)" },
    { "3B6E000080318066B1A30401110B83009000", "Mastercard used in Spain to pay in Restaurants. Made by Edenred. Limited in payment and unable to get physical cash. (Bank)\nhttps://www.edenred.es/" },
    { "3B6E000080318066B1A50102321983009000", "Meeza BDC (Bank)" },
    { "3B6E000080318066B1A60101011383009000", "Finnish Smartum benefit card (Other)\nhttps://www.smartum.fi/" },
    { "3B6E00008066B1A30401110B83009000", "Bank of America (Bank)\nhttps://www.bankofamerica.com/" },
    { "3B6E00FF00620000574156414E5410819000", "debit card (Visa Electron) issued by Nordea bank" },
    { "3B6E00FF4573744549442076657220312E30", "Estonian Identity Card (EstEID v1.0 warm)" },
    { "3B6E00FF47442D47502D333256342D444553", "Mastercard Ourocard Platinum from Banco do Brasil" },
    { "3B6F00000031C068435350454D560300079000", "SOCCARDRT (HealthCare)" },
    { "3B6F00000031C173C821106441443231009000", "Debit Card for Santander Universidades PT (Bank)\nhttps://www.santander.pt/pt_PT/Particulares/Universitarios.html" },
    { "3B6F00000031C173C8211064474D3131009000", "Beutsche Bank Business mastercard credit (Bank)\nhttps://www.deutsche-bank.de/gk/zahlungsverkehr/zahlungsverkehr-im-ueberblick/kreditkarte.html" },
    { "3B6F00000031C173C8211064474D3133009000", "Bank card from the Commonwealth Bank of Australia (Bank)\nhttps://www.commbank.com.au/business/pds/cbb127_eftpos_int_v7.pdf" },
    { "3B6F00000031C173C8211064474D3134009000", "bancomat Banca Popolare Milano + maestro debit card + rfid (Bank)" },
    { "3B6F00000031C173C8211064474D3331009000", "BBVA Antes Card (Spain) (VISA) prepaid card (Bank)\nhttps://www.bbva.es/eng/productos/ficha/tarjeta-antes-bbva/0T00000225" },
    { "3B6F00000031C173C8211064474D3332009000", "td debit visa card (Bank)" },
    { "3B6F00000031C173C8211064474D3338009000", "ING Direct Debit Card (Bank)" },
    { "3B6F00000031C173C8211064474D3341009000", "Fineco debit card (Bancomat, Visa Debit) (Bank)\nhttps://finecobank.com/it/online/conto-e-carte/carte-e-bancomat/" },
    { "3B6F00000031C173C8211064474D3435009000", "VISA card, issued by OP Financial Group, Finland (Bank)" },
    { "3B6F00000031C173C8211064474D3437009000", "Visa credit card, issued by Klarna (Bank) (Bank)\nhttps://www.klarna.com/se/kort/" },
    { "3B6F00000031C173C821106457493131009000", "Banca Popolare Di Sondrio (IT) - Ateneo+ Card for University of Brescia (Bank)\nhttps://www.ateneopiu.it/home" },
    { "3B6F00000031C173C8211064574B3037009000", "NatWest VISA Debit card (Bank)\nhttps://personal.natwest.com/personal/current-accounts/select_account.html" },
    { "3B6F00000031C173C8211064574B3133009000", "Carta HYPE MasterCard (Italy) (Bank)\nhttps://www.hype.it/\nRACC Master (Bank)\nhttps://www.racc.cat/targeta-racc-master" },
    { "3B6F00000031C173C821106457533430009000", "PNC Debit (Bank)" },
    { "3B6F000000664D453161030153086104F09000", "Spanish University of Murcia smart ID card - Old version (M.Mar OS) - Also used by many others spanish universities" },
    { "3B6F000000664D4531B1030153086104F09000", "Spanish UCAM University smart ID card - (M.Mar OS) - Also used by many others spanish universities" },
    { "3B6F000000664D45668003..53066103F09000", "Millenium Card (www.coruna.es/millennium) municipal city card for A Coruna, Spain.\nelectronic wallet for paying services like parking meter or public service (bus) transportation." },
    { "3B6F000000664D456680030C53066105F09000", "Transporte Metropolitano de Galicia (Transport)\nhttp://tmg.xunta.gal/" },
    { "3B6F000000664D456680031453036104F09000", "Paypal Prepaid Card (YoUnique Money E.D.E.)" },
    { "3B6F000000664D456680031653066105F09000", "Transport Metropolitano de Galicia (Transport)\nhttps://tmg.xunta.gal/" },
    { "3B6F000000664D456684030953036104F09000", "spanish MAESTRO debit card, from Unicaja bank" },
    { "3B6F000000672.4346495345125266FF819000", "Setec SetCOS 4.3.2" },
    { "3B6F000000682B4205024649534531C8079000", "MAESTRO card, issued by Swedbank Estonia" },
    { "3B6F000000682C4205024649534531C8079000", "VISA card, issued by Swedbank Latvia\nVISA card, issued by the Latvian bank 'Latvijas Krajbanka'" },
    { "3B6F000000B854211004900000000000000000", "VIABUY Credit card (Bank)\nhttp://www.viabuy.de" },
    { "3B6F000000B854311007900000000000000000", "Revolut Premium Mastercard (Bank)\nhttps://www.revolut.com/revolut-premium\nMonzo Bank (UK) Debit Mastercard\nhttps://monzo.com/\nLansforsakringar (SE) Debit Mastercard\nhttps://www.lansforsakringar.se/\nING Direct MasterCard (Bank)\nhttps://www.ing.es/tarjetas-ing" },
    { "3B6F00000231B813FF000000000000000F9000", "Coverflex | Flexible Benefits Platform (Other)\nhttps://www.coverflex.com/" },
    { "3B6F0000626C75636172642031364B422F7634", "eID Blutronics Blucard 16K\nhttp://blucard.blutronics.com" },
    { "3B6F00008031C0520083640219083283839000", "Bancomer Mexican Bank" },
    { "3B6F00008031C05205B5640200647183839000", "Read Card in USB, used for application in Java. (JavaCard)" },
    { "3B6F00008031C0520752640219083283839000", "Santander (Bank)" },
    { "3B6F00008031C052076F640219043283839000", "Credit Card IXE Banco, Mexico" },
    { "3B6F00008031C0520A476402B3023783839000", "Visa debit card issued by the Spanish bank 'tubancaja'" },
    { "3B6F00008031C05210686402B3027083839000", "Santander Brazil VISA Elite Platinum (Bank)\nhttps://www.santander.com.br/fazer-cartao-credito/lead/cc-elite-platinum" },
    { "3B6F00008031C05211F46402B3023783839000", "VISA (Bank)" },
    { "3B6F00008031C052132F640219083283839000", "Cajamadrid-UCM (Madrid, Spain) Cash/Visa Electron" },
    { "3B6F00008031C05216B9640566803283839000", "Banorte Mexican Bank" },
    { "3B6F00008031C05220E2640562178083839000", "VISA MedicusMundi (VISA Classic Affinity credit card, issued by Laboral Kutxa) (Bank)\nhttps://www.medicusmundi.es/es/que-puedes-hacer-tu/tarjetas-affinity" },
    { "3B6F00008031E05B4555520000000000070200", "Pre-loaded wallet card. 'Mondex is a smart card electronic cash system, implemented as a stored-value card' (Bank)\nhttps://en.wikipedia.org/wiki/Mondex" },
    { "3B6F00008031E05B4E4F4B0000000000000200", "Norsk-Tipping (Buypass) Monodex card" },
    { "3B6F00008031E05B5457440000000000000200", "MasterCard credit card for Far Eastern Bank, Taiwan" },
    { "3B6F00008031E05B59544C0000000000000200", "Turkish Armed Force - Daily Social Facility Usage Card" },
    { "3B6F00008031E06B01030502E0555555555555", "American Express Gold Credit Card" },
    { "3B6F00008031E06B0201020701555555555555", "Brazilian state bank: Caixa Economica Federal debit card" },
    { "3B6F00008031E06B0203020701555555555555", "Banco de Brasilia MasterCard Credit Card (Bank)" },
    { "3B6F00008031E06B0403030405555555555555", "Blue American Express Card" },
    { "3B6F00008031E06B0406030413555555555555", "Telstra MULTOS v4 Card (PKI)" },
    { "3B6F00008031E06B0406030440555555555555", "Blue American Express Card" },
    { "3B6F00008031E06B0406050217555555555555", "Marx Software Security - Cryptoken M2048, MULTOS, Infineon SLE66CX, 64kByte\nhttp://www.marx.com/en/" },
    { "3B6F00008031E06B0406050225555555555555", "Hong Kong Permanent Identity Card (eID)\nhttp://www.gov.hk/en/residents/immigration/idcard/hkic/faq_hkic.htm" },
    { "3B6F00008031E06B0420050230555555555555", "Buypass card for Norsk Tipping\nhttp://norsk-tipping.no" },
    { "3B6F00008031E06B0420050247555555555555", "'Norsk-Tipping (Buypass) Monodex card'\nbought from http://buypass.no and used to access norwegian state services at http://altinn.no" },
    { "3B6F00008031E06B0420050258555555555555", "Norsk Tipping online player card\nhttp://www.norsk-tipping.no/\nNorwegian government controlled betting company" },
    { "3B6F00008031E06B0421050257555555555555", "GE 28 Degrees MasterCard (Australia) (Bank)\nhttp://www.28degreescard.com.au/" },
    { "3B6F00008031E06B0421050261555555555555", "NORSK TIPPING NORWAY\nhttp://www.norsk-tipping.no/" },
    { "3B6F00008031E06B042105026C555555555555", "Icelandic Electronic ID (eID)\nhttps://www.audkenni.is/rafraen-skilriki/einkaskilriki/" },
    { "3B6F00008031E06B0421050272555555555555", "Card CAA Quebec (Mastercard) (Bank)\nhttps://www.caaquebec.com/en/your-privileges/caa-dollars/earning/caa-quebec-dollars-mastercardr-credit-card/" },
    { "3B6F00008031E06B04310502A6555555555555", "USAA EMV Mastercard Creditcard (Bank)\nhttps://www.usaa.com/inet/pages/bk_cc_chipcardLP_landing_mkt?adID=VURL_chipcard" },
    { "3B6F00008031E06B04310502AC555555555555", "Diners Club Credit card (British Airways, Switzerland) (Bank)\nhttps://dinersclub.ch/en/private-customers/all-credit-cards/british-airways-card/" },
    { "3B6F00008031E06B04310502AF555555555555", "debit card (Bank)\nhttps://www.usaa.com/inet/wc/banking" },
    { "3B6F00008031E06B04310502D1555555555555", "Pockit Pre-Paid Mastercard (Contact Chip). (Bank)\nhttps://revolut.com/" },
    { "3B6F00008031E06B04310502D6555555555555", "Bank IN - Slovenian bank (Bank)\nhttps://www.bankain.si/BIN/vstopna.seam" },
    { "3B6F00008031E06B04520502BB555555555555", "AlfaBROU - Mastercard (prepaid card emitted by Banco Republica - Uruguay) (Bank)\nhttps://www.brou.com.uy/personas/tarjetas/prepaga-alfabrou" },
    { "3B6F00008031E06B04520502FD555555555555", "C6 Bank Mastercard Global Account (Bank)\nhttps://www.c6bank.com.br/conta-global\nC6 Bank Mastercard Brazil Account (Bank)\nhttps://www.c6bank.com.br/nossos-produtos" },
    { "3B6F00008031E06B04520502FE555555555555", "CITIBanamex 'Perfiles' debit card (Bank)\nhttps://www.banamex.com/es/personas/cuentas/cuenta-perfiles.html" },
    { "3B6F00008031E06B0505050280555555555555", "Banamex cuenta perfiles (Bank)\nhttp://banamex.com" },
    { "3B6F00008031E06B0508050283555555555555", "Bank of Montreal debit card" },
    { "3B6F00008031E06B0512050287555555555555", "American Express credit card" },
    { "3B6F00008031E06B061605028C555555555555", "Air Miles American Express card (contact) (Bank)" },
    { "3B6F00008031E06B071405028A555555555555", "SolutionsBanking Canada Interac debit card" },
    { "3B6F00008031E06B08240502B5555555555555", "Revolut MasterCard (UK)" },
    { "3B6F00008031E06B082A0502DE555555555555", "VISA Debit Card Issued by State Employees Credit Union of Maryland (Bank)\nhttps://www.secumd.org/personal/credit-cards/card-services.aspx" },
    { "3B6F00008031E06B082D0502B8555555555555", "pag seguro Brasil (Bank)" },
    { "3B6F00008031E06B082E0502B9555555", "CAIXA ECONOMICA (Bank)\nhttps://www.caixa.gov.br/Paginas/home-caixa.aspx" },
    { "3B6F00008031E06B082E0502B9555555555555", "CAIXA (Bank)" },
    { "3B6F00008031E06B0925020209555555555555", "OCA  Card - Master Card credit card (Bank)" },
    { "3B6F00008031E06B8406030431555555555555", "Multos Developer Sample" },
    { "3B6F00008031E06B84060E0202555555555555", "Multos Developer Sample" },
    { "3B6F00008031E06B8420050239555555555555", "Multos 14D (2-0-10) 64K Developer Card" },
    { "3B6F00008031E06B8420050242555555555555", "Multos 14Dc(6-0-13) 64K Dual-Interface Developer Card" },
    { "3B6F00008031E06B843105027A555555555555", "36K MULTOS contact chip community developer card (Other)\nhttps://www.usmartcards.co.uk/multos-smart-card-training-kit.html" },
    { "3B6F00008054434F4C44000000000000829000", "Valovis Bank Mastercard (www.valovisbank.de)" },
    { "3B6F0000805A..0[1-5]................829000", "Card supporting a Calypso application Rev 1\nNavigo (France) transport card\nACTV (Italy) transport card" },
    { "3B6F0000805A080303000000015664F6829000", "transport bus/tram 'atout.tag' semitag grenoble" },
    { "3B6F0000805A08030300000002BB267C829000", "Twisto\nhttp://www.twisto.fr" },
    { "3B6F0000805A08030300000002BF024A829200", "ALSEO, the Alsacian Express Regional Train card (Transport)\nhttp://www.ter.sncf.com/alsace/gares/preparer-son-voyage/carte-alseo/" },
    { "3B6F0000805A08030300000002C883CB829200", "card for Bordeaux transport (Transport)" },
    { "3B6F0000805A080303000000C00FAF04829200", "Bordeaux Urban Transportation Card (NFC) (Transport)" },
    { "3B6F0000805A080314000200........829000", "Metro do Porto, public transport card of Oporto - Portugal (Transport)" },
    { "3B6F0000805A080608200200........829000", "Lisboa Viva, public transport card of Lisbon (Portugal)" },
    { "3B6F0000805A08060820020010003EDC829000", "CTS (Compagnie des Transports Strasbourgeois) to hold transportation tickets" },
    { "3B6F0000805A080608200200100048EA829000", "french public transport card (www.cts-strasbourg.fr)" },
    { "3B6F0000805A08060820020092351E52829000", "Public transport card of Lisbon (www.carris.pt)" },
    { "3B6F0000805A0806082002239216D1BD829000", "'OPUS Card' Montreal's transit system by oberthur cardsystems" },
    { "3B6F0000805A080608200223921B4B59829000", "'OPUS Card' Quebec's Bus system." },
    { "3B6F0000805A08060820022B9297CF7D829000", "OPUS (Montreal transport card) (Transport)\nhttp://www.stm.info/en/info/fares/opus-cards-and-other-fare-media/opus-card" },
    { "3B6F0000805A08060820022B9298A199829000", "OPUS card for AMT - STM Montreal (subway - train and bus ticket) (Transport)\nhttps://opusenligne.ca/en" },
    { "3B6F0000805A08060820022B92990F84829000", "OPUS (Montreal transport card) (Transport)\nhttp://www.stm.info/en/info/fares/opus-cards-and-other-fare-media/opus-card" },
    { "3B6F0000805A08060820022B92B1AADC829000", "OPUS Card, Montreal, Quebec, Canada community transport (Transport)\nhttp://www.stm.info/" },
    { "3B6F0000805A08060820022B92B2B64E829000", "Small card reader from WatchData (model W1981-plus) to recharge public transport cards (metro or bus) from OPUS network in Quebec (Canada). (Transport)\nhttps://stm.opusenligne.ca/en" },
    { "3B6F0000805A08060820022B92B894FC829000", "Montreal OPUS card (Transport)\nhttp://www.stm.info" },
    { "3B6F0000805A08060820022B92EF41EE829000", "OPUS transit wallet (Transport)\nhttp://opusenligne.ca" },
    { "3B6F0000805A08060820022B92F9B67B829000", "The OPUS card is a smart card on which you can charge all STM transit fares, with the exception of group fares, which are available on tickets only. OPUS cards are used by most transit authorities in the Greater Montreal area. (Transport)\nhttp://www.stm.info/en/info/fares/opus-cards-and-other-fare-media/opus-card" },
    { "3B6F0000805A08060820022B93129845829000", "OPUS card for Montreal, Quebec, Canada transit system, subscription-based, non-rechargeable (Transport)\nhttps://opusenligne.ca" },
    { "3B6F0000805A08060820022B9319C24F829000", "OPUS, rechargeable contactless stored value smart card using the Calypso Standard and used by most of the public transit operators in the province of Quebec, Canada. (Transport)\nhttp://carteopus.info/" },
    { "3B6F0000805A08060820022B9334D5D3829000", "Montreal Transport Board (STM) - Opus CARD (Transport)\nhttp://www.stm.info/en/info/fares/opus-cards-and-other-fare-media/opus-card" },
    { "3B6F0000805A08060820022B9339E82B829000", "OPUS is a rechargeable contactless stored value smart card using the Calypso Standard and is used by major public transit operators in Greater Montreal and Quebec City, Quebec, Canada. (Transport)\nhttp://carteopus.info/?language=en" },
    { "3B6F0000805A08060820022B9342782A829000", "OPUS card (Transport)\nhttp://www.carteopus.info/" },
    { "3B6F0000805A08060820022B934564EC829000", "OPUS Card (Transport)\nhttp://carteopus.info/" },
    { "3B6F0000805A08060820022B9346A2C5829000", "Carte OPUS / OPUS Card - Transport Montreal, Laval, Longueuil, Quebec (Transport)\nhttp://carteopus.info/" },
    { "3B6F0000805A08060820022B9349A83F829000", "Montreal OPUS Transportation Card for the STM, STL, RTM and RTL (Transport)\nhttp://www.stm.info/en/info/fares/opus-cards-and-other-fare-media" },
    { "3B6F0000805A080608201223C1E2F6C6829000", "STM Opus Card - Montreal Transit Pay Card (Other)\nhttps://en.wikipedia.org/wiki/OPUS_card" },
    { "3B6F0000805A080608201223C1EA7F50829000", "Montreal transport Opus Card (Transport)" },
    { "3B6F0000805A080608201223C1ECE24B829000", "STM (Transport)\nhttp://www.stm.info" },
    { "3B6F0000805A080608201223C202795D829000", "OPUS is card for storing public transit passes and tickets (Transport)\nhttps://opusenligne.ca/" },
    { "3B6F0000805A080608201223C2036347829000", "OPUS Card  RTC Quebec's Bus system (Canada) (Transport)\nhttps://opusenligne.ca" },
    { "3B6F0000805A0A010120031103DCB31B829000", "Card Transport 'Lignes d'Azur' of 'Metropole Nice Cote d'Azur'" },
    { "3B6F0000805A0A01012003119361D7D7829000", "Carte Tecely (Reseau TCL: metro, tramway, bus et funiculaire de Lyon) (Idemia)" },
    { "3B6F0000805A0A0102200311........829000", "Card << Oura ! >> of region Rhone-Alpes, Calypso standard (TER, Transisere)" },
    { "3B6F0000805A0A0706200401029495D3829000", "Rav-Kav Public Transport (Transport)\nhttps://ravkavonline.co.il/he/" },
    { "3B6F0000805A0A07062004010301F41F829000", "RAV KAV (israel) transportation card (Transport)" },
    { "3B6F0000805A0A0706200401030BA945829000", "Israeli Ravkav card (Transport)" },
    { "3B6F0000805A0A070620040103967A29829000", "Rav-Kav transport card for Israel Ministry of Transport (Transport)\nhttps://en.wikipedia.org/wiki/Rav-Kav" },
    { "3B6F0000805A0A07062004010397DB3D829000", "Israeli Ravkav card (Transport)\nhttps://ravkavonline.co.il/" },
    { "3B6F0000805A0A0706200401039A407F829000", "Israeli public transport card ('RavKav') (Transport)\nhttp://nohal.mot.gov.il/%d7%94%d7%92%d7%93%d7%a8%d7%95%d7%aa%20%d7%91%d7%a0%d7%95%d7%a9%d7%90%20%d7%9b%d7%a8%d7%98%d7%95%d7%a1%20%d7%97%d7%9b%d7%9d.aspx" },
    { "3B6F0000805A0A070620040103ABB5B9829000", "Israeli transport card (Rav-Kav) (Transport)\nhttps://ravkavonline.co.il/en/" },
    { "3B6F0000805A0A070620040103AD1A73829000", "Israeli public transport 'RavKav' card (ASK Tango variant) (Transport)\nhttp://hopon.co.il/" },
    { "3B6F0000805A0A070620040103B86ED6829000", "Rav Kav (IL) (Transport)\nhttps://ravkavonline.co.il" },
    { "3B6F0000805A0A070620040103B93280829000", "Rav-Kav (Transport)\nhttps://ravkavonline.co.il" },
    { "3B6F0000805A0A0706200401044BA8BA829000", "Israeli Rav-Kav (Transport)\nhttps://ravkavonline.co.il/en/" },
    { "3B6F0000805A0A070620042B105A8F94829000", "Rav-Kav, Used by Israeli public transportation companies (Transport)" },
    { "3B6F0000805A0A070620042B77E9EB9F829000", "RavKav Israeli Public Transportation smart card (Transport)\nhttps://ravkavonline.co.il/" },
    { "3B6F0000805A0A070620042C0260FB72829000", "RAV KAV - Israel's  Ministry of Transport public transport smart card (Transport)\nhttp://www.rail.co.il/EN/Tickets/Rav-Kav/Pages/default.aspx" },
    { "3B6F0000805A0A070620042C027AF6DE829000", "Rav-Kav Israel (Transport)\nhttps://ravkavonline.co.il/he/" },
    { "3B6F0000805A0A070620042C027C3C4C829000", "Israeli Railraod Ravkav  (Transport)\nhttps://www.rail.co.il/en/ravkav" },
    { "3B6F0000805A0A070620042C03171106829000", "Israeli Transport Card Rav-Kav (Transport)\nhttp://www.citypass.co.il/english/ContentPage.aspx?ID=9" },
    { "3B6F0000805A0A070620042C031B899B829000", "Israeli public transport 'RavKav' card (ASK variant) (Transport)\nhttp://www.dannorth.co.il/" },
    { "3B6F0000805A0A070620042C031C112A829000", "Peronalized RavKav (Transport)\nhttps://ravkavonline.co.il/he/" },
    { "3B6F0000805A0A070620042C03288444829000", "rav-kav (Transport)\nhttp://nohal.mot.gov.il/%d7%94%d7%92%d7%93%d7%a8%d7%95%d7%aa%20%d7%91%d7%a0%d7%95%d7%a9%d7%90%20%d7%9b%d7%a8%d7%98%d7%95%d7%a1%20%d7%97%d7%9b%d7%9d.aspx" },
    { "3B6F0000805A0A070620042DC1660B73829000", "Rav-Kav: Israel's Travel Card (Transport)" },
    { "3B6F0000805A0A070620042DC169517A829000", "Card for bus (Transport)" },
    { "3B6F0000805A28010220122103346577829000", "ONYGO! pass\nhttp://www.region-basse-normandie.fr/pass-onygo" },
    { "3B6F0000805A2811421010122B260CD45A829000", "French transport card Navigo (Transport)\nhttps://www.iledefrance-mobilites.fr/je-gere-ma-carte" },
    { "3B6F0000805A28114210122B037A89AA829000", "Ile-de-France Mobilites (Navigo Easy) (Transport)\nhttps://www.iledefrance-mobilites.fr/titres-et-tarifs/supports/passe-navigo-easy" },
    { "3B6F0000805A28114210122B037AED59829000", "Navigo Easy (Paris) (Transport)\nhttps://www.iledefrance-mobilites.fr/titres-et-tarifs/supports/passe-navigo-easy" },
    { "3B6F0000805A28114210122B23A9E229829000", "Navigo(French transport) (Transport)\nhttp://www.navigo.fr/je-gere-ma-carte/" },
    { "3B6F0000805A28114210122B23BD87EE829000", "Navigo pass Calypso standard (Transport)\nhttp://www.navigo.fr/" },
    { "3B6F0000805A28114210122B2581EBA5829000", "Navigo Decouverte card for Paris and suburbs transportation, no subscription required (Transport)\nhttp://www.navigo.fr/le-choix-entre-la-carte-navigo-ou-la-carte-navigo-decouverte.html" },
    { "3B6F0000805A28114210122B2582885F829000", "Navigo Decouverte (Transport)" },
    { "3B6F0000805A28114210122B26......829000", "French 'Navigo' transport card (Transport)\nhttp://www.navigo.fr/\nhttp://www.imagine-r.com/" },
    { "3B6F0000805A28114210122B26147C55829000", "Navigo (transport)" },
    { "3B6F0000805A28114210122B26149922829000", "French 'Navigo' NFC card (visually, new design of 2014, with purple/grey color theme, portrait orientation) (Transport)\nhttp://www.navigo.fr/" },
    { "3B6F0000805A28114210122B26155EE3829000", "French 'Navigo' transport card (Transport)\nhttp://www.navigo.fr/" },
    { "3B6F0000805A28114210122B265AADB0829000", "Navigo card (from March 2014 onwards), to be used in Paris and its suburbs (Transport)\nhttp://www.navigo.fr/" },
    { "3B6F0000805A28114210122B272653F8829000", "New Navigo card - Paris Sub transport (Transport)" },
    { "3B6F0000805A28114210122B272851D4829000", "Navigo, Paris and Isle of France transport card (Transport)\nhttps://www.iledefrance-mobilites.fr/titres-et-tarifs" },
    { "3B6F0000805A28114210122B272A8FE7829000", "Navigo Decouverte card, a rechargeable card for travel in Paris, France. (Transport)\nhttps://parisbytrain.com/paris-train-metro-week-pass-navigo-decouverte/" },
    { "3B6F0000805A28114210122B27328308829000", "Navigo Easy (Paris) (Transport) (Transport)\nhttps://www.iledefrance-mobilites.fr/titres-et-tarifs/supports/passe-navigo-easy" },
    { "3B6F0000805A28114210122B27358F16829000", "French Navigo passcard to travel in Paris area using RATP & SNCF services (Transport)\nhttp://www.navigo.fr/" },
    { "3B6F0000805A28114210122B27406D7A829000", "French Navigo Card for Transport (RATP, SNCF) (Transport)\nhttp://www.navigo.fr/" },
    { "3B6F0000805A28114210122B27430CE1829000", "French Navigo Card (Transport)" },
    { "3B6F0000805A28114210122B27522899829000", "SNCF Navigo Card (Transport)\nhttps://www.sncf.com/fr" },
    { "3B6F0000805A28114210122B2755784A829000", "French card navigo (Transport)" },
    { "3B6F0000805A28114210122B27558E85829000", "Stif  Navigo Pass (French Syndicate of Transport in Ile de France) (Transport)" },
    { "3B6F0000805A28114210122B275DCF41829000", "Pass navigo (Transport)" },
    { "3B6F0000805A28114210122B276132D6829000", "Navigo (Transport)" },
    { "3B6F0000805A28114210122B2764E735829000", "Navigo pass, Paris (France) transport network (https://en.wikipedia.org/wiki/Navigo_pass) (Transport)" },
    { "3B6F0000805A28114210122B276562F7829000", "French NAVIGO Card (simple Navigo model, not annual or Imagin'R) (Transport)" },
    { "3B6F0000805A28114210122B276780D9829000", "Navigo (Transport)\nhttps://www.navigo.fr/" },
    { "3B6F0000805A28114210122B276D6BB5829000", "Navigo (Transport)" },
    { "3B6F0000805A28114210122B2777EED6829000", "Navigo (Paris) - Gamalto SmarCard (Transport)\nhttps://www.iledefrance-mobilites.fr/" },
    { "3B6F0000805A28114210122B277A7C32829000", "Navigo Pass used mainly on the french SNCF, Optile and RATP transit networks (Transport)\nhttps://www.iledefrance-mobilites.fr/titres-et-tarifs" },
    { "3B6F0000805A28114210122B279BC4F1829000", "Navigo Liberte + (Transport)\nhttps://www.iledefrance-mobilites.fr/titres-et-tarifs/detail/liberte-plus" },
    { "3B6F0000805A28114210122B279C786C829000", "Navigo Easy (Transport)\nhttp://www.navigo.fr/titres/titre-t-support-sans-contact-presentation/" },
    { "3B6F0000805A28114210122B27A1487B829000", "Navigo card using Calypso stantard (Other)\nhttps://en.wikipedia.org/wiki/Calypso_(electronic_ticketing_system)" },
    { "3B6F0000805A28114210122B27AE59B9829000", "French 'Navigo' transport card (Transport)\nhttp://www.navigo.fr/" },
    { "3B6F0000805A28114210122B4C09310D829000", "Pass Navigo personnalise (Paris) (Transport)\nhttp://www.navigo.fr/titres/le-forfait-navigo-mois-choix-carte-navigo-carte-decouverte/" },
    { "3B6F0000805A28114210122B4C0EFAD0829000", "Ile-de-France Mobilites (Navigo Nominative) (Transport)\nhttps://www.iledefrance-mobilites.fr/titres-et-tarifs/supports/passe-navigo" },
    { "3B6F0000805A28130210122B034BEB8D829000", "Korigo card transport for star company (France) (Transport)\nhttp://www.star.fr/titres-et-tarifs/carte-korrigo/" },
    { "3B6F0000805A28130210122B03CF898A829000", "Korrigo Card (Rennes Metropole bus network) (Transport)\nhttps://www.star.fr/" },
    { "3B6F0000805A28130210122B03D99C6F829000", "KorriGo (Brittany) transport card (Transport)" },
    { "3B6F0000805A28130210122B03DAF62B829000", "Transport card KorriGo (from 2018) for the region of brittany in France (Transport)\nhttps://www.star.fr/titres-tarifs/carte-korrigo" },
    { "3B6F0000805A28130210122B03EF5400829000", "Korrigo Ter French card for train travels (Transport)\nhttps://www.ter.sncf.com/bretagne/offres/carte-korrigo" },
    { "3B6F0000805A28130210122B03F7E432829000", "KorriGo, smart transport card in France region Brittany (Transport)\nhttps://www.ter.sncf.com/bretagne/offres/carte-korrigo" },
    { "3B6F0000805A28130210122B03F80BC3829000", "Korrigo Card (Transport in Rennes Area in France ) (Transport)\nhttps://www.star.fr/titres-tarifs/carte-korrigo/" },
    { "3B6F0000805A28130210122B75021B8A829000", "KorriGo, smart transport card in France region Brittany (Transport)\nhttps://www.ter.sncf.com/bretagne/offres/carte-korrigo" },
    { "3B6F0000805A28130210122B9292E642829000", "Transport card in cote d'or France (mobigo)" },
    { "3B6F0000805A28130210122B9292E829829000", "French transport card of the city of Dijon and Cote d'or department. (Transport)\nhttps://www.viamobigo.fr/fr/acheter-mes-titres-de-transport-mobigo-en-cote-dor/176" },
    { "3B6F0000805A28130210122B92D663FC829000", "Card 'Korrigo' region Bretagne, France, Bibus Brest Metropole public transport  (Transport)\nhttps://fr.wikipedia.org/wiki/KorriGo" },
    { "3B6F0000805A28130210122BC129DC7D829000", "KorriGo card, french britanny travel card (Transport)\nhttps://www.ter.sncf.com/bretagne/offres/carte-korrigo" },
    { "3B6F0000805A28130210122BC3151351829000", "Korigo card transport for star company (France) (Transport)\nhttps://www.star.fr/" },
    { "3B6F0000805A29130910113[36]........829000", "MOBIB (reseau transport en commun Bruxelles, Belgique)\nhttp://www.uclouvain.be/sites/security/mobib.html\nCalypso application similar to French NAVIGO\nMOBIB (Transport)\nhttp://www.stib-mivb.be/mobib.html?l=en" },
    { "3B6F0000805A2C060810100592E4FFF0829000", "Lisbon area transport card (Transport)\nhttps://www.portalviva.pt/" },
    { "3B6F0000805A2C06081010059304D66B829000", "Lisboa VIVA - Lisbon public transport card (Transport)\nhttps://www.portalviva.pt/" },
    { "3B6F0000805A2C0608101005930924D0829000", "Portuguese Lisboa VIVA transport card (Transport)\nhttps://www.portalviva.pt/pt/homepage/cart%C3%B5es/transportes/lisboa-viva.aspx" },
    { "3B6F0000805A2C06081010059316213D829000", "Portuguese Viva Card (Transport)\nhttp://www.portalviva.pt" },
    { "3B6F0000805A2C0608101005932268D0829000", "Public transport card lisbon (Transport)\nhttp://www.portalviva.pt" },
    { "3B6F0000805A2C0608101005932346E2829000", "Lisboa Viva (Transport)" },
    { "3B6F0000805A2C11C31010057B01004B829000", "French Military Circulation card (Transport)" },
    { "3B6F0000805A2C11C31010057B0A1DBA829000", "French military discount on SNCF trains card (Transport)" },
    { "3B6F0000805A2C11C31010057B120D53829000", "French military transport card (Transport)" },
    { "3B6F0000805A2C23C2101005........829000", "MOBIB (reseau transport en commun Bruxelles, Belgique)" },
    { "3B6F0000805A2C23C30003020282D39D829000", "MOBIB Public Transport - De Lijn (Transport)\nhttp://www.delijn.be/nl/vervoerbewijzen/mobib-kaart/" },
    { "3B6F0000805A2C23C3000302028494EA829000", "MOBIB card for DeLijn (public transport operator for the Flemish part of Belgium)" },
    { "3B6F0000805A2C23C3101005........829000", "NMBS/SNCB MOBIB Card (Transport)\nhttp://www.mobib.be/\nhttp://www.belgianrail.be/en/travel-tickets/mobib/no-mobib.aspx\nhttp://www.stib-mivb.be/mobib.html" },
    { "3B6F0000805A2C23C4000306030F02BF829000", "MOBIB card - De Lijn (Transport)\nhttps://www.delijn.be/en/vervoerbewijzen/mobib/?vertaling=true" },
    { "3B6F0000805A2C23C400030603952459829000", "MOBIB - De Lijn (Transport)\nhttps://www.delijn.be/nl/vervoerbewijzen/mobib-kaart/mobib.html" },
    { "3B6F0000805A2C23C41010057113AA4F829000", "NMBS National Belgian Railways MOBIB Card (Transport)\nhttp://www.belgianrail.be/en/travel-tickets/mobib.aspx" },
    { "3B6F0000805A2C23C410100571209D05829000", "Gent schakelt slim. AustriaCard  (Transport)" },
    { "3B6F0000805A2C23C41010057120BA62829000", "Belgian MOBIB public transport card (Transport)\nhttps://mobib.be/en.html" },
    { "3B6F0000805A2C23C410100571217A3A829000", "mobob (Transport)" },
    { "3B6F0000805A2C23C4101005C0224F89829000", "MoBIB card (Transport)\nhttps://mobib.be/en.html" },
    { "3B6F0000805A2C23C4101005C0292CEE829000", "MoBIB card (Transport) (Transport)\nhttps://mobib.be/" },
    { "3B6F0000805A2C23EA000302028524CA829000", "Pcard Interparking Mobib (Transport)" },
    { "3B6F0000805A2C23EA00030502AAE6CE829000", "MOBIB (TEC IT Easy) (Transport)\nhttp://www.infotec.be/fr-be/titresettarifs/mobib.aspx" },
    { "3B6F0000805A2C23EA000305039E9CDB829000", "Belgium TEC MOBIB card (Transport)\nhttps://www.infotec.be/" },
    { "3B6F0000805A2C23EA00030503BD09B2829000", "TEC MoBIB Transportation Card (Transport)\nhttps://www.infotec.be/fr-be/acheteruntitre/mobib.aspx" },
    { "3B6F0000805A2C23EA00030503BF9E2B829000", "MOBIB - TEC (Transport)\nhttps://www.infotec.be/fr-be/acheteruntitre/mobib.aspx" },
    { "3B6F0000805A2D0608101002782BB4A4829000", "Lisboa Viva, Lisbon public transport card (Transport)\nhttps://www.portalviva.pt/" },
    { "3B6F0000805A2D06081010027835EDCE829000", "Lisbon Transportation SmartCard (Transport)" },
    { "3B6F0000805A2D06081010027848BBCC829000", "Lisbon Metro Monthly Student Pass (Transport)\nhttps://www.metrolisboa.pt/" },
    { "3B6F0000805A3407061500017917A7E2829000", "Rav-Kav multi-line travel ticket used in the public transportation system in Israel (Transport)\nhttps://www.gov.il/en/departments/guides/multi_line_card" },
    { "3B6F0000805A3B0706150101793E797B829000", "Rav Kav (Transport)\nhttp://alhakav.mot.gov.il/he/rav-kav" },
    { "3B6F0000805A3B070615010279537211829000", "Israeli public transport card ('RavKav') (Transport)\nhttps://ravkavonline.co.il" },
    { "3B6F0000805A3B07061501027956C5F4829000", "RAVKAV - Israel dual interface transport card (Calypso standard) (Transport)\nhttps://en.wikipedia.org/wiki/Rav-Kav" },
    { "3B6F0000805A3C0608140101C3805E38829000", "Lisboa VIVA - Lisbon public transport card (Transport)\nhttps://www.portalviva.pt/" },
    { "3B6F0000805A3C1142141001274AC890829000", "Gemalto Celego G1 (Transport)" },
    { "3B6F0000805A3C114214100127A46D02829000", "Navigo decouverte Paris (Transport)\nhttp://www.navigo.fr/titres/le-forfait-navigo-semaine-presentation/" },
    { "3B6F0000805A3C1142141001C12954D4829000", "Public transportation card (navigo) for Paris and Ile-de-France region, France (Transport)\nhttps://www.iledefrance-mobilites.fr/en/tickets-fares/detail/navigo-monthly-ticket" },
    { "3B6F0000805A3C1142141001C140E819829000", "France Ile de France Public Transport Card (Transport)" },
    { "3B6F0000805A3C1142141001C1523E9D829000", "navigo (Transport)" },
    { "3B6F0000805A3C1142141001C17BC3D4829000", "Navigo easy -- French (Paris region) transport card (Transport)" },
    { "3B6F0000805A3C1142141001C17BC993829000", "Navigo Easy (Transport)\nhttps://www.ratp.fr/titres-et-tarifs/passe-navigo-easy" },
    { "3B6F0000805A3C1142141001C17DA8CA829000", "Navigo Easy (France) transport card (Transport)\nhttps://www.ratp.fr/titres-et-tarifs/passe-navigo-easy" },
    { "3B6F0000805A3C1142141001C185D47B829000", "Navigo Liberte+ -- French (Paris region) transport card (Transport)" },
    { "3B6F0000805A3C1142141001C2BF7B46829000", "Navigo RATP (Transport)" },
    { "3B6F0000805A3C1330141001C3568397829000", "'oura' card for leman express and ter sncf rhone-alpes (Transport)" },
    { "3B6F0000805A3C23C4141001C02EF7F8829000", "MOBIB basic Brussels (with NFC) (Transport)\nhttps://mobib.be/en.html" },
    { "3B6F0000805A3C23C4141001C02EFA97829000", "Brussels STIB MOBIB Classic (Transport)\nhttps://www.stib-mivb.be/mobib.html" },
    { "3B6F0000805A3C23C4141001C02FDEFA829000", "MOBIB public transport card (Belgium); contacted IC (Transport)" },
    { "3B6F0000805A3C23C4141001C03219CF829000", "Personalized MOBIB card (Brussels transports) (Transport)\nhttp://www.stib-mivb.be/mobib.html?l=en" },
    { "3B6F0000805A3C23C4141001C0D966F5829000", "MOBIB (reseau transport en commun Bruxelles, Belgique)\nhttp://www.uclouvain.be/sites/security/mobib.html\nCalypso application similar to French NAVIGO MOBIB (Transport)\nhttp://www.stib-mivb.be/mobib.html?l=en (Transport)" },
    { "3B6F0000805A3C23C4141001C0E7D752829000", "MoBIB (Transport)\nhttps://mobib.be/nl.html" },
    { "3B6F0000805A3C23C4141001C1035546829000", "MoBIB: Belgian transport card (NFC) (Transport)\nhttps://mobib.be/en.html" },
    { "3B6F0000805A3C23C4141001C1075758829000", "MOBIB Basic (public transport card for Brussels, Belgium) (Transport)\nhttps://www.stib-mivb.be/article.html?_guid=30af0085-2483-3410-5394-a71daf08acd1&l=en" },
    { "3B6F0000805A3C23C4141001C108A3C1829000", "MIVB/STIB MOBIB Card (Transport)\nhttps://mobib.be/" },
    { "3B6F0000805A3C23C4141001C10AE139829000", "STIB/MIVB Mobib card (Transport)\nhttps://www.stib-mivb.be/article.html?_guid=d02c7fb6-3e9c-3810-248e-eec4ee5ebc8c&l=en" },
    { "3B6F0000805A3D0706150101792CB636829000", "RavKav (Transport)" },
    { "3B6F0000805A3D23C41501027937D7AE829000", "MOBIB - Brussels (Transport)\nhttps://www.stib-mivb.be/article.html?_guid=d02c7fb6-3e9c-3810-248e-eec4ee5ebc8c&l=fr" },
    { "3B6F0000805A3D23C41501027949789C829000", "MOBIB basic (Transport)\nhttp://www.stib-mivb.be/article.html?_guid=30af0085-2483-3410-5394-a71daf08acd1&l=en#contentBodyList1" },
    { "3B6F0000805A434F4C44000000000000829000", "LBB Berlin, MasterCard (ADAC branding?)" },
    { "3B6F0000805A4880C1205001AEC00295829000", "Calypso SAM C1 (Transport)" },
    { "3B6F0000806645460138180353023110829000", "Fabrica Nacional de Moneda y Timbre FNMT WG10\nhttp://www.fnmt.es/es/html/tage/fichaTarjeta/fp1_ta_01.asp" },
    { "3B6F0000806645460138180353023124829000", "Electronic purse of the Universidad Politecnica of Madrid (provided by Banco Santander)" },
    { "3B6F0000806645460138180353076104829000", "Vitrasa Card municipal city card for Vigo, Spain. Electronic wallet for paying bus transportation.\nhttp://www.vitrasa.es/php/index.php" },
    { "3B6F0000806657590100080353076104829000", "Green card of City council of Vigo (public transport)" },
    { "3B6F0000806657590100080353076114829000", "E-money Vitrasa Card - Public transport in Vigo" },
    { "3B6F00008066A20302023D0753023110829000", "Electronic purse of the Universidad Politecnica of Madrid (provided by Banco Santander)" },
    { "3B6F00008066B007010107............9000", "Gemalto Santander Optelio TUI R7 with WG10 customized using Contact interface" },
    { "3B6F00008066B0070101070753023110829000", "Banco Santander TUI/USC R7 - Gemalto Optelio/Desineo D72 (JavaCard) with WG10  (JavaCard)" },
    { "3B6F00008066B0070101070753023124829000", "Banco Santander TUI/USC R7 - Gemalto Optelio/Desineo D72 (JavaCard) with WG10 and Maestro (JavaCard)" },
    { "3B6F00008066B007010177............9000", "Other Optelio Card (Santander)" },
    { "3B6F00008066B0070101770753023110829000", "University ID card (issued by Banco Santander Central Hispano)\n.\nUniversidad Nacional de Educacion a Distancia (UNED, Spain)\nhttp://www.uned.es/tarjeta\n.\nUniversitat Politecnica de Catalunya (UPC.edu)\nhttps://www.upc.edu/identitatdigital\n.\nUniversitat Ramon Llull (URL)\nhttp://www.url.edu/cont/url/carnet.php" },
    { "3B6F00008066B0070101770753023124829000", "Santander 4B Maestro\nUniversity of Santiago de Compostela. Spain\nPolytechnical University of Madrid, Spain" },
    { "3B6F00018031E06B0406050211555555555555", "American Express 'Entourage' credit card issued by CIBC\nhttp://www.cibc.com" },
    { "3B6F00FF00567275546F6B6E73302000009000", "Aktiv Rutoken S\nhttps://www.rutoken.ru/products/all/rutoken-s/" },
    { "3B6F00FF525341536563757249442852293130", "RSA SecurID SID800 token" },
    { "3B6F00FF534653452D43583332322D56180202", "Giesecke & Devrient SmartCafe Expert 2.0" },
    { "3B7418000073667465", "SafeSign from A.E.T. Europe B.V.\nManufactured by Giesecke & Devrient (G&D)" },
    { "3B7511000024C2019000", "Alladin Smartcard CP1 (Other)" },
    { "3B751200002905010401", "CAC Cryptographic Service Provider\nAxalto Cyberflex Access 64K V1 SM 4.1" },
    { "3B751300004309EA9000", "Vitale 2 (french health card)" },
    { "3B751300004409EA9000", "Carte Vitale 2 (Nouvelle version avec photo)" },
    { "3B751300004509EA9000", "Carte Vitale 2 (French health card)" },
    { "3B751300004509FA9000", "Carte VItate (HealthCare)" },
    { "3B751300004609EA9000", "Health Care card" },
    { "3B751300004709EA9000", "Carte Vitale (HealthCare)" },
    { "3B751300004809EA9000", "Carte Vitale (HealthCare)\nhttps://en.wikipedia.org/wiki/Carte_Vitale" },
    { "3B751300004909EA9000", "Vitale Card French Healthcare (HealthCare)\nhttps://www.service-public.fr/particuliers/vosdroits/F265" },
    { "3B751300009C02020102", "Cyberflex Access 32k v2" },
    { "3B759400006202020[1-3]01", "Schlumberger Cyberflex 32K e-gate\nGemalto TOP US (product code HWP115278A)" },
    { "3B76110000009C11010202", "Schlumberger Cyberflex Access 32K" },
    { "3B76110000009C11010203", "RSA SecureID 5100" },
    { "3B76120000009C11010303", "Precise BioMatch (TM) JavaCard (Schlumberger)\nwww.precisebiometrics.com" },
    { "3B76130000436869703137", "PostFinance Switzerland Gemalto SP U1128785A 1017 (Bank)\nhttps://www.postfinance.ch" },
    { "3B76130000806207418180", "Generic mass produced Motorola smart card" },
    { "3B76130000806207418181", "TransLink card (discontinued San Francisco Bay Area transit card)" },
    { "3B76980000009C11010102", "CyberFlex Access 32" },
    { "3B771800004B4153414B4944", "Identification Kazakhstan Republic (passport)\nhttps://egov.kz/" },
    { "3B7812000047C403008FF19000", "Sattelite bg 23.5 East cryptoworks card" },
    { "3B7812000054C401078FF19000", "XtraMusic listening card (Pay TV)" },
    { "3B7812000054C40204FFFF6F04", "UPC Direct Satellite TV Card (Pay TV)\nhttp://www.upcdirect.com/" },
    { "3B7812000054C402078FF19000", "Polish WIZJA TV pay-tv card for satellite receivers (Pay TV)" },
    { "3B7812000054C403008FF19000", "Skylink irdeto from Towercom a.s. company\nirdeto card for the ORF (Austrian national public television) HD channels" },
    { "3B7812000065C405008FF19000", "Digiturk Cryptoworks" },
    { "3B7812000065C405058FF19000", "Turkie Digiturk Cryptoworks" },
    { "3B78120000A0C403068FF19000", "ORF Digital (Irdeto/Cryptoworks) (pay tv)" },
    { "3B78120000A0C403078FF19000", "IRDETO-Smartcard for crytoworks for austrian television (ORF), DVB-s" },
    { "3B78120000A0C406008FF19000", "Cryptoworks/Nagravision decoding card" },
    { "3B78120000A0C406058FF19000", "Satellite cardu, provider: UPC DTH, CAID: 0D02" },
    { "3B78120000A0C406068FF19000", "Skylink old card cryptoworks 0d03 (Pay TV)" },
    { "3B78120000A0C406078FF19000", "Skylink CZ/SK - Cryptoworks" },
    { "3B781300000073C84010009000", "credit/debit card from issued by Finnish credit authority Luottokunta Oy" },
    { "3B7813000043433169AA200000", "PostFinance debit card (Bank)\nhttps://www.postfinance.ch/en/priv/prod/card/pfcard/direct/offer.html" },
    { "3B781300007275746F6B656E6D", "Aktiv Rutoken Micron" },
    { "3B781400000073C8400000", "e-tazkira (eID)" },
    { "3B781800000073C80140009000", "The Kyrgyz Republic eID (eID)" },
    { "3B781800000073C840000000009000", "VERISOFT REWARDO LOYALTY CARD and CUSTOM PERSONALIZATION PROJECTS FOR EXTERNAL ENTITIES (Loyalty)\nhttp://www.verisoft.com" },
    { "3B781800005448204E4944203.", "Thailand National ID (eID)" },
    { "3B7818000100000000C31E6919", "Storage for passwords (Bank)" },
    { "3B781800FF0073C84000009000", "NAB Visa Debit - Contact I/F (Bank)" },
    { "3B789600000073C84000009000", "SAM card for acquirer module by lanit.ru (Bank)" },
    { "3B789600005343066001079000", "Bank of America Travel Rewards Credit Card (Bank)\nhttps://www.bankofamerica.com/credit-cards/products/travel-rewards-credit-card/" },
    { "3B789600008100035001079000", "RMA BMCE BANK CARD (Bank)" },
    { "3B791100008054434F4C44829000", "amazon.de / VISA / LBB Debit Card (Bank)" },
    { "3B79130000806416030183829000", "Raiffeisen VPay Debit Card (Bank)\nhttp://raiffeisen.ch" },
    { "3B79130000806416030185829000", "UBS Vpay Debit card (Bank)\nhttps://www.ubs.com/ch/en/private/accounts-and-cards/debitcards/vpay.html" },
    { "3B791800004272617A494465616C", "Brazilian digital certificate card (eID)\nhttps://serasa.certificadodigital.com.br" },
    { "3B7918000053462D3443432D3031", "SmartCafe Expert 3.2 144K Dual interface card supports specifications ISO 14443A T=CL and ISO 7816 T=1/0. (PKI)\nhttp://www.smartcardfocus.com/shop/ilp/id~523/smartcafe-expert-3-2-144k-dual/p/index.shtml" },
    { "3B791800005448204E4944203130", "Thai National ID Card (eID)" },
    { "3B791800008054434F4C44829000", "LBB VISA Card" },
    { "3B7918000080634B560283079000", "Pay charge of South Korean Highway Tollgate, It named hi-pass. This card is sales by 'SM hiplus', and card name is 'Greencar Postpaid hi-pass Card'. In this name, 'Greencar' means South Korea's Car Sharing Service. This card from Rented car. (Transport)\nhttps://www.lottecard.co.kr/" },
    { "3B79180000806355500183079000", "TEST SAM Card (espark) (Other)" },
    { "3B79180000806355561283079000", "'hi-pass+ Prepaid hi-pass Card' pay charge of South Korean Highway Tollgate. Sold by 'SM hiplus' (Transport)\nhttp://www.hipluscard.co.kr/" },
    { "3B799400005901010E016B0102A9", "Vending machine payment card ('Necta' brand)" },
    { "3B79940000EB03010102700102A9", "Sodexo - Spanish vending machines (Other)\nhttp://es.sodexo.com/home.html" },
    { "3B79940000F704010103800102A9", "Pelican Rouge, vending machine (Other)\nhttp://colnect.com/es/functional_cards/functional_card/26065-Maquinas_Cafe_-_Pelican_Rouge-Pelican_Rouge-Vending-Espa%C3%B1a\nhttp://www.pelicanrouge.co.uk/en-uk/about-us" },
    { "3B7995000054454C454D10211010", "Israeli Identity Card (eID)\nhttp://smartid.gov.il/English/Pages/default.aspx" },
    { "3B799600005448204E494420313.", "Thai National ID Card (eID)" },
    { "3B799800005001010401000101A9", "Gemalto PayFlex used in Aristocrat System 7000 Casino Management System (South Africa only)" },
    { "3B79980000EB03010000700101A9", "Casino Rio Patras, Greece" },
    { "3B7A..00008065A2........72D6..", "IDClassic 3XX Cards (with MPCOS Applet)" },
    { "3B7A1100004844322E30346FFF9000", "User Smartcard provided with the Hiddn Crypto Adapter (www.hiddn.no)" },
    { "3B7A110002484F5354060319029000", "Swedish bankcard with Mastercard from ICA-banken" },
    { "3B7A1300000009A5050100B701A601", "'cleyris' authentication card. monpass.sante from Mutuelle Generale" },
    { "3B7A130000094431314352020025C3", "Feitian D11CR 2016 (JavaCard)" },
    { "3B7A1300007275746F6B656E6D7363", "Aktiv Rutoken Mikron SC" },
    { "3B7A18000000487970734944205333", "Certinomis card (eID)" },
    { "3B7A18000073667465206364313434", "Republic Slovenia e-Gov, Ministry of Public Administration\nSIGOV-CA, Slovenian Governmental Certification Authority\nGiesecke & Devrient (PIV Endpoint) G&D Sm@rtCafe Expert v3.2" },
    { "3B7A180000736674652D6364303830", "HYPOnet online banking card / Croatia" },
    { "3B7A1800FF4A434F50323156323331", "JCOP21 18K" },
    { "3B7A9400008065A20101013D72D641", "Personal Identity card (passport)" },
    { "3B7A9400008065A20101013D72D643", "Gemplus GemXpresso Pro R3 E32 PK" },
    { "3B7A9500008065A20131013D72D641", "Emirates Identification authority UAE card (eID)\nhttp://sdk.emiratesid.ae/" },
    { "3B7A9600008065A20101013D72D643", "AGH University of Science and Technology (Poland) - Student Identity Card (ELS) (eID)\nWarsaw University of Technology (Poland) (eID)" },
    { "3B7A9600008065A201200100303D72D641", "Oman eID (eID)" },
    { "3B7A9600008065A20120013D72D641", "Oman eID (eID)" },
    { "3B7A9700008065B08520040272D641", "OMAN EID CARD (eID)" },
    { "3B7B..000080620.515646696E454944", "Setec SetCOS 5.1.0" },
    { "3B7B..00008065B083......83009000", "IDClassic 3XX Cards (without MPCOS Applet - FIPS)" },
    { "3B7B11000031FE45436F6D624F532000", "Debit card emmited by Societe Generale Morocco (Bank)" },
    { "3B7B1800000031C06477E30300829000", "Oberthur Cosmopolic 64K v5.2 D" },
    { "3B7B1800000031C06477E91000019000", "Oberthur Card Systems: Cosmo 64 RSA V5.4 (ISK Key Set: 404142 .. 4E4F)" },
    { "3B7B1800000031C06490E31100829000", "oberthur card in the middle http://postarca.posta.si/downloadfile.aspx?fileid=16918 (eID)\nhttp://postarca.posta.si/" },
    { "3B7B1800000031C064C6FC1000079000", "Sberbank of the RUSSIAN federation" },
    { "3B7B1800000031E85427E60000019000", "Oberthur ID-One COSMO 64k v.5" },
    { "3B7B180000806201545646696E454944", "FineID identity card for organizations\nhttp://fineid.fi/default.aspx?id=491\nhttp://www.opensc-project.org/opensc/wiki/FinnishEid" },
    { "3B7B94000080621[12]515646696E454944", "Finnish Electronic ID card (fineid card www.fineid.fi)" },
    { "3B7B9400008065521607865383009000", "Truemove H Thailand (Telecommunication)\nhttp://truemoveh.truecorp.co.th/" },
    { "3B7B9400008065B083010[13]7483009000", "Gemplus GemXpresso Pro R3 (E64 PK)" },
    { "3B7B9500008065B08301047483009000", "Gemplus GemXpresso Pro 64K R3 FIPS v2" },
    { "3B7B9600004750003A06014120079000", "Discover Card (Other)\nhttp://Discover.com" },
    { "3B7C13000080641134014873F741C08107", "universal electronic card UEC Rissa (eID)\nhttp://www.uecard.ru/for-citizens/" },
    { "3B7C130000806411650190730000008107", "Universal Electronic Card (UEC Russia) (eID)" },
    { "3B7C1800004352455343454E444F383030", "HID Global Crescendo C800 (PKI)\nhttp://www.hidglobal.com/products/cards-and-credentials/crescendo/c800" },
    { "3B7C1800008688000001B3F420550181B3", "smart (Telecommunication)" },
    { "3B7C94000050524F474558494143535032", "mutual health Martinique (UFR PASS+) (HealthCare)" },
    { "3B7C95000045534D415254474F53543130", "ESMART Token GOST (PKI)\nhttps://esmart.ru/products/informatsionnaya-bezopasnost/usb-nositeli-esmart-token-gost/" },
    { "3B7D..000080318065B0........83..9000", "IDClassic 3XX / Classic TPC (IXS, IS, IS V2, IS CC, IM, IM CC, IM CC V3) / MultiApp ID Cards" },
    { "3B7D110000003180718E6452D90100829000", "Oberthur Galactic V2" },
    { "3B7D110000003180718E6477E30100829000", "Oberthur Cosmo 64k RSA v5" },
    { "3B7D110000003180718E6477E30200829000", "Oberthur 64k v5/2.2.0" },
    { "3B7D110000003180718E6486D60100819000", "DOD-CAC" },
    { "3B7D110000003180718E6486D60200829000", "Oberthur Card Systems (OCS), Galactic v1 32K, Original Pilot CAC, V1 Applets" },
    { "3B7D1300004D44572D4941532D4341524432", "IAS (Identification, Authentication, and electronic Signature) Premium, profil DGME from Sagem" },
    { "3B7D140002805759505349443034836F9000", "IDEMIA ypsID S2 (PKI)" },
    { "3B7D180000003180718E6477E30100829000", "Oberthur 64k v4/2.1.1" },
    { "3B7D180000003180718E6477E30200829000", "Smart Card for identity Patient (eID)\nhttp://www.sergas.es" },
    { "3B7D18000000487970734944205333079000", "Safran Morpho YpsID S3" },
    { "3B7D180002805759505349443033837F9000", "Sagem YpsID s2 (SafeSign)\nBrazilian 'e-CNPJ' card, issued by Certisign (Safesign)" },
    { "3B7D180002805759505349443034837F9000", "Morpho e-CPF YpsID S2-11/11 (PKI)\nhttp://safeweb.com.br" },
    { "3B7D9400005555530A7486930B247C4D5468", "SIM from sysmocom sysmoSIM-GR2" },
    { "3B7D94000057442908308693070565182B56", "Canal Digitaal (Pay TV)\nhttp://webshop.canaldigitaal.nl/nl/smartcards-2" },
    { "3B7D9400005744295A2186930332EF174607", "Chevrolet Club Card (Loyalty)\nhttps://my.chevrolet.com/login" },
    { "3B7D940000574429615086930351462501DC", "Sodexo Meal Card (Other)\nhttps://www.sodexoavantaj.com" },
    { "3B7D9400005744530554869300156A5F1378", "Idea Indian GSM operator SIM" },
    { "3B7D94000057445324658693020581741057", "kyivstar (Telecommunication)" },
    { "3B7D940000574453246586930210B7251297", "Kyivstar (Telecommunication)" },
    { "3B7D94000057445363968693009DF710009D", "China Mobile SIM card" },
    { "3B7D94000057445372FD8693110106755B0F", "China Telecom UIM 64K" },
    { "3B7D94000057445396FA869303B7BFBF5F63", "Airtel India SIM" },
    { "3B7D94000057445399648693120300006346", "Dtac (Telecommunication)" },
    { "3B7D94000080318065B08301019083009000", "GemSafeXpresso 16k R3.2" },
    { "3B7D94000080318065B08301029083009000", "Gem e-Seal\n(GemSafeXpresso 32k R3.2)\nGemalto Classic TPC - IS" },
    { "3B7D94000080318065B08302047E83009000", "GXP Pro R3.2 64K, GemSafe applet MPCOS v1.11\ncard issued by Czech National Bank\ndual card: chip used for electronic certificates\n(czech commercial bank use such card to sign money transfer orders sent to national clearing central)" },
    { "3B7D94000080318065B0831100AC83009000", "GemCombiXpresso R4 72K" },
    { "3B7D94000080318065B0831100C883009000", "personal identity card (ID card) of Republic of Lithuania\nLuxTrust card" },
    { "3B7D94000080318065B0831140AC83009000", "GXP4 E72PK Applet V1 T=0 (PKI)" },
    { "3B7D94000080318065B0831148C883009000", "Online banking\nhttp://www.getinbank.pl/" },
    { "3B7D94000080318065B08311C0A983009000", "GemXpresso R4 72K\nNational ID card of Republic of Lithuania (2007-2012)" },
    { "3B7D95000080318065B08302047E83009000", "Gemalto's Classic TPC HM CC Mifare 1K White PVC\n(Old name GemSafeXpresso 64K)" },
    { "3B7D95000080318065B08311....83009000", "Portuguese ID Card (eID)\nhttp://www.cartaodecidadao.pt/" },
    { "3B7D96000080318065B0830201F383009000", "Gemalto IDClassic 340" },
    { "3B7D96000080318065B0831100C883009000", "GEMALTO Clasic TPC IM CC" },
    { "3B7D96000080318065B0831111AC83009000", "GEMALTO WM GX4 72 DHS TSA" },
    { "3B7D96000080318065B0831111E583009000", "Gemalto TOP DL v2 StdR\neCPF (Cadastro de Pessoas Fisicas) from Imprensa Oficial do Brasil\nIdentidade digital (e-CPF) from Caixa\nhttp://www.caixa.gov.br/\nIngenico Sign/Kit Telium TETRA (Developer kit signature card)\nhttps://developer.ingenico.com/hc/en-gb\nBrazilian 'e-CNPJ' card, issued by Certisign (Safesign)" },
    { "3B7D96000080318065B0831113AC83009000", "CAC card (GEMALTO GCX4 72K DI)" },
    { "3B7D96000080318065B0831117D683009000", "DoD CAC card issued Jan 14, 2010\nGEMALTO TOP DL GX4 144K\nGeneva Conventions Identification Card" },
    { "3B7D96000080318065B0831117E583009000", "Gemalto IDPrime PIV Card2.0 (eID)" },
    { "3B7D96000080318065B0831140AC83009000", "GemXpresso R4 64k" },
    { "3B7D96000080318065B0831140C883009000", "ING BusinessOnLine Bank eToken / Poland\nGemalto Classic TPC - IM\nIran Driving License ID card (eID)" },
    { "3B7D96000080318065B0831148C883009000", "Gemalto GemSafe V1" },
    { "3B7D96000080318065B08311C0A983009000", "Gemplus X-Presso Pro 64k" },
    { "3B7D96000080318065B08311C0C883009000", "TOP IM GX4 from Gemalto (was GemXpresso R4)\nJava Card 2.2.1\nGlobal Platform 2.1.1 (amendment A)" },
    { "3B7D96000080318065B08311D0A983009000", "GemSafe V2 (2.04, GemP15-1)\nGemplus GemXpresso Pro R3 E32PK\nGemalto TOP IM GX4" },
    { "3B7D96000080318065B0840100C883009000", "Optelio Cards (D38-D72 R6) T=0 High Speed" },
    { "3B7D96000080318065B0850200CF83019000", "Gemalto IDCore 3010\nhttp://www.cryptoshop.com/gemalto-top-dm-cc.html" },
    { "3B7D96000080318065B09311D0A983009000", "Gemalto Classic TPC (Trusted PKI Card) IM\nClassic TPC IM (PKCS#15): 12 x RSA key containers (standard profile)" },
    { "3B7D96000080318065B0A30201F383009000", "SetCOS 2048 (eID)" },
    { "3B7D96000080318065B0A31100C883000000", "Handelsbanken BankID card (Swedish bank authentication)" },
    { "3B7D96000080318065B0A31100C883009000", "Swedish eID (Telia IP5a)\nhttp://www.telia.se/privat/katalog/VisaProdukt.do?productRef=/privat/produkter_tjanster/bredband/tjanster/sakerhetstjanster/teliae-legitimation.1537014385.product" },
    { "3B7D96000080318065B0A31101F383009000", "Telia EID IP5a (eID)\nhttps://cve.trust.telia.com/TeliaElegNG" },
    { "3B7E110000006A11635408302401....219001", "Sagem Windows for smart cards" },
    { "3B7E1300000031C071C66501B0010440839000", "BahnCard / Commerzbank MasterCard Credit Card\nBank Pekao SA (Poland) (Maestro) debit card (Bank)\nhttps://www.pekao.com.pl/" },
    { "3B7E1300000031C071C66501B4010440839000", "Portugal Millennium BCP MAESTRO debit Card" },
    { "3B7E130000006A1163540548......01229000", "Sagem Windows for smart cards" },
    { "3B7E18000080584D4333322042494F83059000", "Person Authentication Service Card (PKI)\nhttps://igc2.finances.gouv.fr/#igc1" },
    { "3B7E9400008025020310010056000000010100", "Czech citizen ID card (eID)\nhttps://portal.gov.cz/eobcanka" },
    { "3B7E9400008025A00000002856801008000114", "MujKlic smart card with a certificate for Direct Banking (PKI)\nhttps://www.kb.cz/en/direct-banking/certificates/certificate-on-smartcards/" },
    { "3B7E9400008025A00000002856801012000114", "ProID+ Q (PKI)\nhttp://proid.cz" },
    { "3B7E9400008025A00000002856801012000116", "CryptoPlus CS xg" },
    { "3B7E9400008025A00000002856801012000119", "Ceska sporitelna personal certificate card" },
    { "3B7E9400008025A00000002856801012810117", "Ceska Sporitelna SERVIS24 certificate card\nhttp://smallhacks.wordpress.com/2012/05/04/exploring-servis24-certificate-card-from-the-ceska-sporitelna-bank/" },
    { "3B7E9400008025A00000002856801021000114", "CryptoPlus ProID, students ISIC card at University of Zilina, Slovakia\nTOP GX4 72k contact chip using JavaCard v2.2.1. and GlobalPlatform 2.1.1" },
    { "3B7E9400008025A00000002856801024000111", "'OpenCard' - card issued by Prague local authority\ndual card: chip used for electronic certificates" },
    { "3B7E9400008025D20310010056000000010100", "Personal identity card (ID card) of Czech Republic" },
    { "3B7E9400008025D20310010056000000020200", "Official Czech Republic identity card issued since 7/2018 (eID)\nhttps://www.eidentita.cz/" },
    { "3B7E94000080318066475091450313830F9000", "JTOP Trusted Logic" },
    { "3B7E940000803180664750A4450511830F9000", "JTOP Trusted Logic" },
    { "3B7E9500008031807334118082900000000000", "IAS (Identification, Authentication, and electronic Signature) Premium, profil DGME from Gemalto" },
    { "3B7F..0000006A4345524553022C3402..039000", "Ceres ST v2" },
    { "3B7F..0000006A4345524553022C3403..039000", "Ceres ST v3" },
    { "3B7F..00008031..65B000000000......8290..", "MultiApp V2.1 (with IAS XL / IAS ECC and IAS Classic Applet V3) [MultiApp V2.1 Type 2]" },
    { "3B7F..000080318065B0........120FFE829000", "IDPrime MD 8840, 3840, 3810, 840 and 830 Cards T=0" },
    { "3B7F0100FE58434F53763235312863295046424D", "XCOS is an Experimental Card Operating System for Atmel based smartcards (Funcard, etc..) (Other)\nhttp://runningserver.com/?page=runningserver.content.download.xcos" },
    { "3B7F04000080318071906754454D44412E309000", "public key (PKI)" },
    { "3B7F1100000031C053CAC4016452D90400829000", "DoD CAC, Oberthur CosmopolIC 32K V4" },
    { "3B7F110000006A4345524553022C340200039000", "FNMT-CERES ST (Fabrica Nacional de Moneda y Timbre)" },
    { "3B7F1100008031C052141E640218195383839000", "Advantis card\nhttp://www.sermepa.es/ingles/familiaadvantis.htm" },
    { "3B7F1100008031C0522157640218195383839000", "banking card (www.caixacatalunya.com)\nstudent id of Universitat Autonoma de Barcelona" },
    { "3B7F1100008031C0523531640566615283839000", "Oberthur Manufactured VISA Banking card (www.caixaterrassa.cat)" },
    { "3B7F1100008031C0523651640566615283839000", "Alsa Plus (Transport)\nhttps://www.alsa.es" },
    { "3B7F1100008031C0523A65640696186283839000", "Visa Electron Triodos Bank Card (Bank)" },
    { "3B7F1100008031C0523BC7640696186283839000", "Triodos Bank Visa Classic (Bank)" },
    { "3B7F12000044564E205445434820526576353376", "Chinese cable TV JETCAS card (DVN)" },
    { "3B7F1300008031C052020F6402B3027083839000", "Banco Bradesco ELO (Brazil) (Bank)" },
    { "3B7F1300008031C0520271640562347083839000", "Mastercard Debit Card issued by Caixa d'Enginyers\nhttp://www.caixa-enginyers.com" },
    { "3B7F1300008031C052056E640253043683839000", "Mastercard from Banc Sabadell in Spain" },
    { "3B7F1300008031C05206E8640566993683839000", "HSBC Debit VISA CARD MX (Bank)" },
    { "3B7F1300008031C052077D640566993683839000", "VISA CEPSA (Porque tu vuelves) from Spain\nhttp://www.porquetuvuelves.com/\nVisa Credit Card issued by Citibank\nhttp://www.citibank.es" },
    { "3B7F1300008031C0520849640566993683839000", "Spanish bank called BBVA" },
    { "3B7F1300008031C052084B640566946183839000", "Visa Electron Card from a Spanish bank called 'Caja de Ingenieros'" },
    { "3B7F1300008031C0520880640566993683839000", "'la Caixa' (Spain) (VISA Electron) debit card (Bank)\nhttps://www.lacaixa.es/" },
    { "3B7F1300008031C0520889640200657183839000", "Guardadito | Banco Azteca (Bank)\nhttps://www.bancoazteca.com.mx/productos/cuentas/guardadito.html" },
    { "3B7F1300008031C05209AA640566993683839000", "Advantis 8k (Bank)" },
    { "3B7F1300008031C0520A456402B3023783839000", "Bancaja online (Visa) Card , Entity : Bancaja Bank Spain (Bankia currently)" },
    { "3B7F1300008031C0520AA66402B3023783839000", "Credit card Visa Classic by 'La Caixa' (Spain)" },
    { "3B7F1300008031C0520AD6640566946183839000", "Visa Credit Card issued by Caixa d'Enginyers\nhttp://www.caixa-enginyers.com" },
    { "3B7F1300008031C0520B71640566983683839000", "OuroCard VISA International - Banco do Brasil" },
    { "3B7F1300008031C0520BBB640566983683839000", "VISA OUROCARD Banco do Brasil S.A." },
    { "3B7F1300008031C0520D1E640566946183839000", "Universitat Politecnica de Valencia ID Visa Electron Card\nhttp://www.upv.es" },
    { "3B7F1300008031C0520DEA640566946183839000", "Universitat Rovira i Virgili Identification Card\nThis card enables his/her propietary to sign documents and to access to rooms, laboratories and classes." },
    { "3B7F1300008031C0520ED4640566966183839000", "BBVA Blue Card (VISA)\nwww.bluebbva.com" },
    { "3B7F1300008031C05210496402B3027083839000", "Bank of Brazil (Bank)\nhttp://www.bb.com.br/pbb/pagina-inicial" },
    { "3B7F1300008031C05210686402B3027083839000", "Santander VISA (Brazil) (Bank)" },
    { "3B7F1300008031C05210A46402B3027083839000", "EMV Smartcard Reader (Other)\nSaraiva (Banco do Brasil) - VISA (Bank)\nhttps://www.bb.com.br/pbb/pagina-inicial/voce/produtos-e-servicos/cartoes#/" },
    { "3B7F1300008031C052112F640569937083839000", "Banco do Brasil (Bank)\nhttp://www.bb.com.br/" },
    { "3B7F1300008031C05212936402B3027083839000", "Visa Infinite issued by Banco do Brasil (www.bb.com.br)\nManufactured by Giesecke & Devrient (G&D www.gi-de.com)" },
    { "3B7F1300008031C052130B6402B3023783839000", "Visa Ourocard Platinum from Banco do Brasil" },
    { "3B7F1300008031C0521366640566983683839000", "VISA Platinum from Banco do Brasil" },
    { "3B7F1300008031C05214D5640566966183839000", "Visa Electron Debit Card issued by Spain Caja Madrid (www.cajamadrid.es)" },
    { "3B7F1300008031C0521554640566983683839000", "VISA Card from Banc Sabadell in Spain" },
    { "3B7F1300008031C05215B8640200647183839000", "Debit classic card banorte 'banco mercantilmdel norte' (Bank)\nhttps://www.banorte.com/" },
    { "3B7F1300008031C05215C7640569937083839000", "Brazil Bank Debit Cart - Visa Electron (Banco do Brasil) (Bank)" },
    { "3B7F1300008031C05215CB640566966183839000", "Bank, Spanish group BANKIA (www.bankia.es)\nVisa, Servired\nManufactured by Saetic\nhttp://www.saetic.es/" },
    { "3B7F1300008031C05215ED640200647183839000", "VISA - Bradescard (Casas Bahia) (Bank)\nhttps://www.bradescard.com.br/conteudo/cartoes/cartoes-cea.shtm" },
    { "3B7F1300008031C052161B640569937083839000", "Card BNB National Bank of Bolivia - Debit Card (Bank)\nhttps://www.bnb.com.bo/" },
    { "3B7F1300008031C0521620640566966183839000", "Bank, Spanish BBVA\nhttp://www.bbva.com/\nVisa, Servired\nManufactured by Oberthur\nhttp://www.oberthur.com/" },
    { "3B7F1300008031C0521643640569937083839000", "Gemalto Debit Card cwbU1071682A1212 issued by BANCO DE CREDITO DEL PERU" },
    { "3B7F1300008031C05216506402B3027083839000", "Banrisul credit card (Bank)" },
    { "3B7F1300008031C05216D7640562178083839000", "Bank card from BBVA (spanish) (Bank)\nhttps://www.bbva.es" },
    { "3B7F1300008031C05216F5640569937083839000", "Banco do Brasil (Bank)" },
    { "3B7F1300008031C052172D6402B3023783839000", "Spanish 'cajamar' bank - Visa Electron Debit Card. Made by Tag Systems" },
    { "3B7F1300008031C05217616402B3027083839000", "ELO Debit Card from CAIXA (Bank)\nhttps://www.caixa.gov.br/" },
    { "3B7F1300008031C05217A06402B3023783839000", "Credit card Visa Classic by 'La Caixa' (Spain)" },
    { "3B7F1300008031C05217B4640566983683839000", "Credit Card Banorte International, Mexico" },
    { "3B7F1300008031C0521848640200647183839000", "Itau Visa LATAM Pass (Bank)" },
    { "3B7F1300008031C0521880640566983683839000", "Visa Electron Debit Card issued by 'la Caixa'" },
    { "3B7F1300008031C05218946402B3027083839000", "Advantis duo 8k (Bank)" },
    { "3B7F1300008031C0521895640200647183839000", "Alfa BROU, prepaid VISA (UY) (Bank)" },
    { "3B7F1300008031C05218976402B3023783839000", "tool-valley (vale-pedagio) from Bradesco" },
    { "3B7F1300008031C052191B6402B3027083839000", "La Caixa Visa electron ATM Card (Bank)\nhttps://portal3.lacaixa.es/apl/tarjetas/catalogo/catalogo.index_es.html?idImagen=1041,14&filtro=DE" },
    { "3B7F1300008031C0521BF1640562178083839000", "blueBBVA Visa (Bank)" },
    { "3B7F1300008031C0521DDE640500E47183839000", "Evo finance Visa gold (Bank)\nhttps://www.evofinance.com/" },
    { "3B7F1300008031C0521E63640500E47183839000", "iTAU Brazil Gold VISA (Bank)" },
    { "3B7F1300008031C05220DD640562178083839000", "VISA ELECTRON debit card (Bank)\nhttps://en.wikipedia.org/wiki/Visa_Electron" },
    { "3B7F1300008031C0522167640500E47183839000", "Credito Oro Banca Personal Bankia (Bank)\nhttps://www.bankia.es/en/personal-banking/tarjeta-credito-oro-banca-personal" },
    { "3B7F1300008031C0522298640500E47183839000", "PECUNPAY Prepaid VISA Card (Bank)" },
    { "3B7F1300008031C05225AD640562347083839000", "Citi Bank (Spain) (VISA Electron) debit card (Bank)" },
    { "3B7F1300008031C05226DE640562347083839000", "debit card (Bank)" },
    { "3B7F1300008031C05234D6640566946183839000", "Visa Credit Card issued by Spain Obsidiana (www.obsidiana.com)" },
    { "3B7F1300008031C052350D640261186383839000", "Visa Credit Card issued by Spain Caja Madrid (www.cajamadrid.es)" },
    { "3B7F1300008031C0523642640566946183839000", "Visa debit card issued by Spain Caja Madrid bank" },
    { "3B7F1300008031C05237C46402000B7083839000", "BANKING (Bank)" },
    { "3B7F1300008031C0523B0E6402000B7083839000", "RACC MasterCard (Bank)\nhttps://www.racc.cat/targeta-racc-master" },
    { "3B7F1300008031C0523B2E6402000B7083839000", "Bankinter VISA credit card (Bank)" },
    { "3B7F1300008031C0523C896402000B7083839000", "ING Direct Visa (Bank)\nhttps://www.ingdirect.es/" },
    { "3B7F1300008031C052710B640500EC7183839000", "Itau Visa Volar Debit (Bank)\nhttps://www.itau.com.uy/inst/tarjetaVolarDebitoComercios.html" },
    { "3B7F1300FF0031C173C8211064414D3137079000", "icc (Bank)" },
    { "3B7F1300FF45434F53763131302863295046424D", "ECOS-Card [Experimental Card Operating System V.1.1] by Philipp Maier\nhttp://www.runningserver.com/?page=runningserver.content.download.ecos" },
    { "3B7F140000804100574A2D49444D3634837F9000", "Electronic CPF in Brazil (Cadastro de Pessoas Fisicas)\nhttp://pt.wikipedia.org/wiki/E-CPF" },
    { "3B7F1800000031B8645023ECC173940180829000", "PENIT, Carte non ECC-France (eID)\nhttps://nantes.sso.intranet.justice.gouv.fr/\nSSO card distributed by the University Hospital of Lille (CHRU de Lille)" },
    { "3B7F1800000031C0739E010B6452D90300829000", "Oberthur Galactic V3 (32k)" },
    { "3B7F1800000031C0739E010B6452D90400829000", "Oberthur CosmopolIC 32K v4 Fast ATR\nOberthur Authentic" },
    { "3B7F1800000031C0739E010B6452D90500829000", "Oberthur 32k BIO" },
    { "3B7F18000043553269AA20003220202020202000", "UBS Access Card (Online Banking, NFC, Switzerland) (Bank)" },
    { "3B7F18000080594944656159494465616C5F312E", "e-CNPJ issued by Fenacon (eID)\nhttp://www.fenacon.org.br" },
    { "3B7F1800008059494465616C5F312E3483079000", "Sagem YpsID s3" },
    { "3B7F18000280410057534F414C424944837F9000", "Albanian ID Card (eID)\nhttps://www.aleat.al/" },
    { "3B7F380000006A4345524553022C340202039000", "WG10" },
    { "3B7F380000006A4345524553022C340310039000", "Used card Aragon government (Aragon - Espana)" },
    { "3B7F380000006A4345524553022C340320039000", "TiDcarm (Region de Murcia)\n(Government of the Autonomous region of Murcia, Spain)\nhttp://www.carm.es" },
    { "3B7F380000006A444E496500024C3401130F6581", "DNI (Documento Nacional de Identidad), Spanish ID Card" },
    { "3B7F380000006A444E4965[12]0024C340113039000", "DNI electronico (Spanish electronic ID card)\nhttp://www.dnielectronico.es" },
    { "3B7F9400008025A0000000285780103001000100", "ProID+ (PKI)\nhttp://proid.cz" },
    { "3B7F9400008025A0000000285780104202000100", "ProID+Q Client (JavaCard)\nhttps://www.proid.cz" },
    { "3B7F94000080318065B0850300EF120FFF829000", "Gemalto Classic V4\nJuridic Person's Token (PKI)\nUruguayan Identification Card (Cedula de Identidad) (eID)" },
    { "3B7F94000080318071906754454D44312E309000", "M.MAR (MEE GVB1.1/11.06) eID\nTarjeta Electronica del Ministerio de Defensa (M.MAR TEMDv1.0)\nhttps://www.commoncriteriaportal.org/files/epfiles/2004-03-ST.pdf" },
    { "3B7F95000080318065B0831100C8120084829000", "Cape Verde National Identity Card (CNI) (eID)\nhttps://sniac.cv/cartao-nacional-de-identificacao/" },
    { "3B7F9600000031B8644070141073940180829000", "IAS/ECC Gemalto (eID)" },
    { "3B7F9600000031B86440F3851073940180829000", "IAS ECC Type 1" },
    { "3B7F960000006A444E49650001015504210F6581", "DNIe (eID)" },
    { "3B7F960000006A444E49650001779803110F6581", "Electronic Spanish National ID card (eID)\nhttp://digital.csic.es/handle/10261/15941" },
    { "3B7F960000006A444E49651001015504..039000", "DNIE Spain (eID)\nhttp://www.dnielectronico.es/PortalDNIe/" },
    { "3B7F960000006A444E4965100177980.11039000", "DNI electronico (Spanish electronic ID card) (eID)\nhttp://www.dnielectronico.es" },
    { "3B7F960000006A444E4965200101550410039000", "Spanish DNI (3.0 version) (eID)\nhttp://www.dnielectronico.es/PortalDNIe/" },
    { "3B7F960000006A444E4965200101550421039000", "DNI electronico (Spanish electronic ID card) (eID)\nhttp://www.dnielectronico.es" },
    { "3B7F960000006A444E4965200177980311039000", "Spanish ID card (DNIe) (eID)\nwww.dnielectronico.es/" },
    { "3B7F960000006A464E4D54030411430430039000", "CERES Spanish SmartCard from the 'Fabrica Nacional de Moneda y Timbre' (FNMT) (eID)\nhttp://www.cert.fnmt.es/" },
    { "3B7F96000000B854311007900000000000000000", "Mastercard  (Bank)" },
    { "3B7F96000000B854311107900000000000000000", "STPay-Gold (JavaCard)\nhttp://www.st.com/en/secure-mcus/stpay-gold.html" },
    { "3B7F9600003100DE525001001500000000000000", "VALES (Bank)" },
    { "3B7F9600008031806555850300EF124140829000", "Civil ID  (eID)" },
    { "3B7F96000080318065B0842327E5120FFE829000", "Gemalto IDPrime MD 3810 dual interface smartcard ISO 7816, ISO 14443 and NFC (PKI)\nhttp://www.smartcardfocus.com/shop/ilp/id~672/gemalto-idprime-md-3810-dual-interface-smartcard/p/index.shtml" },
    { "3B7F96000080318065B084413DF612004C829000", "Serasa Experian (Other)" },
    { "3B7F96000080318065B084413DF6120FFE829000", "Gemalto IDPrime MD" },
    { "3B7F96000080318065B084534C0F12037B829000", "Serbian International Student Identity Card (ISIC) (eID)\nhttps://www.gpa.rs/kartice" },
    { "3B7F96000080318065B0846160FB120FFD829000", "IDPrime 930/3930 FIPS Level 2 or Level 3 (T=0 CT=96) (BAI1, BAI2, BAI3, BAI5, BAI7) (PKI)" },
    { "3B7F96000080318065B0850201F3120FFF829000", "Swedish National Identity Card (eID)\nhttps://polisen.se/tjanster-tillstand/pass-och-nationellt-id-kort/" },
    { "3B7F96000080318065B0850201F312FFFE829000", "Gemalto TOP IM GX4 (PKI)\nhttp://www.cryptotech.com.pl/compl/data/gemalto/pdf/TOP_GX4_Nov08.pdf" },
    { "3B7F96000080318065B0850300EF120268829000", "Polish Qualified Signature (eID)\nhttp://www.elektronicznypodpis.pl/oferta/certyfikaty-kwalifikowane/" },
    { "3B7F96000080318065B0850300EF1202C1829000", "Gemalto IDPrime MD840 (eID)\nhttps://safenet.gemalto.com/resources/data-protection/idprime-840-product-brief/" },
    { "3B7F96000080318065B0850300EF1202F0829000", "Swedish MCA (eID)" },
    { "3B7F96000080318065B0850300EF120FFE829000", "Gemalto IDPrime MD 840 (PKI)\nhttp://www.gemalto.com/Products/IDPrime_MD/index.html" },
    { "3B7F96000080318065B0850300EF120FFF82", "CPR card (eID)" },
    { "3B7F96000080318065B0850300EF120FFF829000", "Portuguese Blood Donator National Card (HealthCare)\nSwedish ID card from Skatteverket with an Electronic ID from AB Svenska Pass, issued September 2017 or later\nhttps://skatteverket.se/privat/folkbokforing/idkort/elegitimationpaidkortet.4.3810a01c150939e893f8169.html\nSwedish ID card from Skatteverket with an Electronic ID from AB Svenska Pass, issued September 2017 or later (eID)\nhttps://skatteverket.se/privat/folkbokforing/idkort/elegitimationpaidkortet.4.3810a01c150939e893f8169.html" },
    { "3B7F96000080318065B0850300EF12FFFE829000", "JavaCard (JavaCard)" },
    { "3B7F96000080318065B085040011120FFF829000", "Swedish national ID card (eID)" },
    { "3B7F96000080318065B085040120120FFF829000", "Belgian eID v1.8 (eID)\nhttps://github.com/Fedict/eid-mw" },
    { "3B7F96000080318065B085040120F20001829000", "Health Insurance Institute of Slovenia - Health Insurance Card Gen. 3 (HealthCare)" },
    { "3B7F96000080318065B085040120F20002829000", "Health Insurance Institute of Slovenia - Professional Card Gen. 3 (HealthCare)" },
    { "3B7F96000080318065B0855956FB12FFFE829000", "IDCORE 3140 (JavaCard)" },
    { "3B7F9600008031B865B0850300EF1200F6829000", "Finnish identity card (eID)\nhttp://vrk.fi/en/citizen-certificate" },
    { "3B7F9600008031B865B08504021B1200F6829000", "Finnish ID-card v5.0(?) (eID)\nhttps://dvv.fi/en/fineid-specifications" },
    { "3B7F960000EA5CBDF07AEB6541894B0400000000", "Gemalto TOP IM GX4 (Other)" },
    { "3B7F9700000031C173C821106457533430009000", "PNC Bank VISA card (Bank)" },
    { "3B7F980000805A070404000102028458F2829000", "Mobili'carte (Angouleme mobility services card) (Transport)\nhttp://www.mobilite-grandangouleme.fr/" },
    { "3B800181", "NXP Semiconductors VNG OpenPGP Card (Other)\nhttps://www.vng.com.vn/" },
    { "3B80800101", "ISO 14443 Type B without historical bytes\nElectronic Passport\nSpanish passport (2012)\nCanadian Passport\nVenez_Prox" },
    { "3B810020", "Old MobilCOM GSM (Telecom D1) (Telecommunication)" },
    { "3B81010080", "Rompetrol Romania Fill&Go Fuel Card (Other)" },
    { "3B811F00CC52", "eToken R2 2242" },
    { "3B8180018080", "RFID - ISO 14443 Type A - NXP DESFire or DESFire EV1 or EV2\n'Reiner LoginCard' (or 'OWOK', how they name it) - they have been distributed by a german computer magazine ('Computer BILD')\nhttps://cardlogin.reiner-sct.com/\nBelgium A-kaart (Antwerp citycard)\nOyster card - Transport for London (second-gen 'D')\nhttps://en.wikipedia.org/wiki/Oyster_card\nKaba Legic Advant 4k\nSydney Opal card public transport ticket (Transport)\nhttps://www.opal.com.au\nTH Koln (University of Applied Sciences Cologne) - Student Identity Card\nhttps://www.th-koeln.de/en/academics/multica_5893.php\nGerman red cross blood donation service\nhttp://www.blutspende-nordost.de/\nGreater Toronto/Hamilton/Ottawa PRESTO contactless fare card\nhttp://en.wikipedia.org/wiki/Presto_card\nElectic vehicle charging card of the EMSP EnBW Energie Baden-Wurttemberg AG, Tarif ADAC e-Charge, Germany" },
    { "3B8180018181", "Ticket (Transport)" },
    { "3B82005518", "GSM SIM of TIM ITalian mobile company" },
    { "3B82005519", "GSM card 'Hi' (KPN brand)" },
    { "3B82005522", "GSM-SIM TELE2 Smart (Estonia, prepaid or subscription)" },
    { "3B8201020382", "EMV CL (Bank)" },
    { "3B8280010244..", "RFID - NFC Forum tag type 1 (Topaz)" },
    { "3B828001030202", "Visa Credit Card, issued by TargoBank" },
    { "3B828001424A0B", "Beijing Transport(YKT) (Transport)" },
    { "3B828001477236", "emoney (Transport)" },
    { "3B8280014792D6", "Beijing Bus (Transport)" },
    { "3B828001485813", "Yikatong BMAC -Beijing Municipal Administration & Communication contactless card (Transport)\nhttps://en.wikipedia.org/wiki/Yikatong" },
    { "3B82800186880D", "Beijing Municipal Administration Traffic Card (with cpu) (Transport)\nhttp://www.bmac.com.cn/" },
    { "3B828001C902C8", "Bartl V5.3DI (PKI)" },
    { "3B8281317643C002C5", "CardOS/M2 V2.01(SLE44CxxS)" },
    { "3B8281317643C103C5", "i.ti (ticket card for Collogne/Bonn)\nCardOS M2 Combi V2.02 (SLE44R42S)" },
    { "3B8300121096", "GSM-SIM T-Mobil D1 (900MHz)" },
    { "3B8300435610", "Comviq 2G SIM" },
    { "3B83800100000002", "Mastercard debit (BNP Paribas Ukrsibbank) (Bank)\nhttps://my.ukrsibbank.com/ru/personal/cards/welcome_card/" },
    { "3B83800141012664", "ACOS3 Multi-Application Contactless Card (Other)\nhttps://www.acs.com.hk/en/products/316/acos3-microprocessor-card-contactless/" },
    { "3B83800141070541", "ACOS3 Multi-Application Contactless Card (Other)\nhttps://www.acs.com.hk/en/products/316/acos3-microprocessor-card-contactless/" },
    { "3B8380014110095A", "Card RFID ACS (Other)" },
    { "3B83800181028001", "Mifare DESFire EV1 2K (Other)" },
    { "3B840091180100", "Proximus 075 Belgacom Mobile SIM" },
    { "3B8480010000000005", "UMoney card UB Transport (Transport)" },
    { "3B8480010000900095", "German (test) passport issued in january 2010\nLuxembourg passport (2012)\nUnited Kingdom passport (2010)" },
    { "3B8480010110000612", "Snapper New Zealand (Type A)" },
    { "3B848001011000091D", "snapper (www.snapper.co.nz) prepaid 14443A cards" },
    { "3B8480010111200336", "Snapper Sprat (Transport)\nhttps://www.snapper.co.nz/snapper-store/" },
    { "3B84800101112003369000", "TMES Total Mobility (Wellington City Council, New Zealand)" },
    { "3B848001043833B1BB", "Dutch passport" },
    { "3B8480014743504312", "Polish eID card: pl.ID / e-Dowod (SIGN3-ChipDoc) (eID)\nhttps://www.gov.pl/web/e-dowod" },
    { "3B8480014777F400C1", "True Money Touch Sim (Thailand)" },
    { "3B8480016918000074", "e-money flazz (Bank)\nhttps://www.bca.co.id/Individu/Produk/E-Banking/Flazz" },
    { "3B8480018082900097", "German passport (passport)" },
    { "3B85001202010096", "GSM-SIM Victorvox D1 (900MHz)" },
    { "3B85008725013802", "GSM-SIM Viag Interkom E2 Loop GSM (1800MHz)" },
    { "3B85008725013900", "GSM-SIM Telfort (Netherlands) 900 MHz" },
    { "3B854020680101....", "Schlumberger Cryptoflex 8k" },
    { "3B8540206801010000", "Schlumberger Cryptoflex 8k (no RSA key generation)" },
    { "3B8540206801010305", "Schlumberger Cryptoflex Key Generation" },
    { "3B8540206801010501", "Schlumberger Cryptoflex 8k (with RSA key generation)" },
    { "3B8540FE6801010204", "Axalto CryptoFlex 8K" },
    { "3B8540FF6301010301", "Axalto Cryptoflex 16K" },
    { "3B85800101A213109135", "Contact (7816-10) 2WBP (HealthCare)" },
    { "3B8580012063CBA0002C", "Visa card from Banque populaire du nord/Casden" },
    { "3B8580012063CBA1002D", "AIB Visa Debit Card, manufactured by Oberthur (NFC interface)" },
    { "3B8580012063CBA180AD", "bpaid: bpost prepaid Mastercard (contactless)\nhttp://www.bpost.be/site/fr/residential/finance/bpaid/index.html" },
    { "3B8580012063CBA3A08F", "BNP Paribas Visa Classic Card (NFC) (Bank) 2014-2017 (Bank)\nhttps://mabanque.bnpparibas/fr/notre-offre/comptes-cartes-et-services/cartes-et-moyens-de-paiement/decouvrir-toutes-les-cartes/carte-visa-classic" },
    { "3B8580012063CBA52009", "MasterCard issued by OTP Bank (Hungary) (Bank)\nhttps://www.otpbank.hu/portal/en/Retail/Bankcards" },
    { "3B8580012063CBA5A089", "Visa contactless from Banque Populaire des Alpes (France) (Bank)" },
    { "3B8580012063CBAD0021", "NUMBER26 MasterCard (Bank)\nhttps://number26.eu" },
    { "3B8580012063CBAD2001", "KBC Ireland MasterCard Debit Card (Bank)\nhttp://www.kbc.ie/" },
    { "3B8580012063CBAD80A1", "VISA Caisse d'Epargne  (Bank)\nVISA BNP Paribas (NFC) (Bank)" },
    { "3B8580012063CBB7201B", "Halifax Clarity Mastercard (Bank)" },
    { "3B8580012063CBB780BB", "First Direct Debit (Bank)" },
    { "3B8580012063CBB880B4", "VISA Cleo LCL (Bank)\nhttps://particuliers.lcl.fr/quotidien/cartes/carte-visa-cleo/" },
    { "3B858001300101303034", "German Health Insurance Card 'elektronische Gesundheitskarte' (eGK) / European Health Insurance Card (EHIC) (HealthCare)\nhttps://fachportal.gematik.de/karten-und-identitaeten/elektronische-gesundheitskarte" },
    { "3B8580014A4D52544441", "JMRTD - Java Machine Readable Travel Document (ePassport emulator\nhttp://jmrtd.org/)" },
    { "3B8580014D7945494478", "MyEID" },
    { "3B8580015A43372E3531", "BasicCard ZC7.5 32K (Other)\nhttp://www.basiccard.com" },
    { "3B8580015A4356445659", "Card Issued by 'Verkeiersverbond' Luxembourg 'M Kaart' Card containing Tickets for all public transportation in the country of Luxembourg (Transport)\nhttps://mshop.lu/\nhttp://http://www.mobiliteit.lu/" },
    { "3B858001807384214012", "Dutch Biometric Passport" },
    { "3B8580018073C821100E", "NXP P71 (SmartMX3 P71D320 JCOP4) (JavaCard)" },
    { "3B858001A000000000A4", "Italian Passport (passport)" },
    { "3B85C0FA216380630101051B", "Public Distribution System\nhttp://cg.nic.in/pdsonline/corepds/" },
    { "3B8640206801010204AC", "Activcard Gold, SchlumbergerSema Cryptoflex 8k" },
    { "3B86800100049AEE00CABD", "ASK CPL 528" },
    { "3B86800103020211000015", "cash bee card. transportation and payment in south korea (seoul) (Transport)\nhttp://cashbee.co.kr" },
    { "3B86800106757781028000", "NXP Mifare DESFire EV1 8K / MF3ICD81\n'OpenCard' - card issued by Prague local authority\ndual card: RFID (1k Mirfare) used for parkimeters and as public traffic ticket" },
    { "3B86800106757781028F00", "Desfire (eID)" },
    { "3B8680013930433032317E", "Chase Freedom VISA card" },
    { "3B86800144492030324D65", "Lufthansa Miles & More Gold MasterCard PayPass\nRaiffeizen Bank, Russia, MasterCard paypass card" },
    { "3B8680014449203032567E", "DKB VISA paywave (Bank)\nhttp://www.visaeurope.com/en/cardholders/visa_paywave.aspx" },
    { "3B8680014A434F50333012", "Mifare ProX T=CL" },
    { "3B8680014A434F50333113", "JCOP BIO 31 Contactless Card" },
    { "3B8680014B4F4E4112203E", "Citibank Russia, Mastercard paypass" },
    { "3B8680014B4F4E41141109", "Mastercard paypass enabled credit card" },
    { "3B8680015741524930310B", "Gusto Karta (Bank)\nhttps://www.gustokarta.cz" },
    { "3B86800157575061737336", "WWPass Passkey (eID)\nhttps://www.wwpass.com/passkey" },
    { "3B86800180540410010FC9", "Nickel.eu prepaid account (Bank)\nhttps://nickel.eu" },
    { "3B868001C1052F2F01BC7E", "Contactless interface to St. Petersburg unified card, Russia (Edinaia karta peterburzhtsa) (Other)\nhttps://ekp.spb.ru/" },
    { "3B868131703445504120454B08", "Austrian Quick E-purse 'Einreichkarte' (transfer card)\nhttp://www.quick.at/" },
    { "3B8780014D49464152452B39", "PEKA CARD (JavaCard)" },
    { "3B8780014D525444312E3026", "Russian Foreign Passport (passport)" },
    { "3B8780014D525444322E3025", "Biometric Passport of the Russian Federation (passport)" },
    { "3B8780015A4350757273655E", "ZCPurse RFID card (ATR created by PCSC-Reader) (Transport)\nhttp://www.zeitcontrol.de/en/zcpurse" },
    { "3B87800173C840000090006D", "Amazon.de VISA Card (Bank)\nhttp://lbb.de/amazon\nCIBC Visa" },
    { "3B8780017743324C0101004C", "CiPurse L profile with 304 bytes user memory (Other)\nhttps://www.infineon.com/cms/en/product/security-smart-card-solutions/cipurse-products/" },
    { "3B878001774332530008005B", "CiPurse S profile (Other)\nhttps://www.infineon.com/cms/en/product/security-smart-card-solutions/cipurse-products/" },
    { "3B8780017743325300090258", "CiPurse S profile (Other)\nhttps://www.infineon.com/cms/en/product/security-smart-card-solutions/cipurse-products/" },
    { "3B878001774332530100015377433253010001", "Cipurse ISO 14443-4 Card (Other)" },
    { "3B8780017743325301000250", "CIPURSE (Transport)\nhttps://www.osptalliance.org/cipurse-specifications/" },
    { "3B8780017743325400090558", "CIPURSE (Transport)\nhttps://www.osptalliance.org/cipurse-specifications/" },
    { "3B8780017743325401010054", "CiPurse T profile (Other)\nhttps://www.infineon.com/cms/en/product/security-smart-card-solutions/cipurse-products/" },
    { "3B8780017743495002000128", "CIPURSE (transport)\nhttp://www.osptalliance.org/" },
    { "3B8780018031807396128040", "Public transport: VRS Verkehrsverbund Rhein-Sieg (Germany, North_Rhine-Westphalia)\nhttp://www.vrsinfo.de/englisch/the-vrs/vrs-about-us.html" },
    { "3B878001803198738401E039", "Austrian Passport" },
    { "3B8780018031B8738401E019", "Personalausweis (German Identity Card) (eID)" },
    { "3B8780018031B973842160B8", "Hungarian eID (2016) (eID)\nhttp://kekkh.gov.hu/Eszemelyi/" },
    { "3B8780018031C073D620C032", "RFID GeldKarte (girogo)" },
    { "3B8780018031C073D621C033", "Sparkasse Hannover - German contactless GeldKarte (RFID, NFC, girogo)\nhttps://www.geldkarte.de/_www/en/pub/geldkarte/service_navigation/about_us.php" },
    { "3B8780018031C073D631C023", "girocard contactless (Bank)\nhttps://www.girocard.eu/english.html" },
    { "3B878001C10521300077C165", "Mifare Plus (Other)\nhttp://www.Mifare.net" },
    { "3B878001C1052F2F0035C730", "MiFare Plus 2K 'S' (Other)" },
    { "3B878001C1052F2F01BCD6A9", "RFID - ISO 14443 Type A - NXP Mifare Plus" },
    { "3B87813140434D4643203133316F", "Telekom Paycard" },
    { "3B88010003050668D06080D1", "125 Khz HID Proximity card (eID)\nhttps://www.hidglobal.com/product-display/cards-and-credentials/hid-proximity" },
    { "3B88014B415A544F4B454E82", "Kaztoken (eID)\nhttp://kaztoken.kz/" },
    { "3B888001000000000000000009", "Personalausweis (German Identity Card) (eID)" },
    { "3B8880010000000000419100D9", "EffiTIC (Transport)\nwww.effitic.com" },
    { "3B888001000000000071710009", "OPUS Public Transport card (Montreal, Quebec, Canada) - Oberthur based\nhttp://carteopus.info/\nACTV (Italy) transport card (RFID)" },
    { "3B8880010000000000718100F9", "Navigo Decouverte (RFID interface) (Transport)" },
    { "3B8880010000000000817700FF", "KBC Maestro card (Bank)" },
    { "3B88800100000000008187000F", "ING Bank Card (Bank)\nhttps://www.ing.nl/particulier/betalen/passen/betaalpas/contactloos-betalen-met-uw-betaalpas/index.html" },
    { "3B888001000000000081911009", "Trenitalia (Italy) fidelity card 'CartaFreccia' (RFID)" },
    { "3B88800100000000038191001A", "Italian healthcare card (TS) National Service Card (CNS) NFC Interface (eID)" },
    { "3B888001000000001181810018", "Rav Kav (Transport)\nhttps://ravkavonline.co.il/he/" },
    { "3B88800100000000338181003A", "Interparking MOBIB basic - RFID/Smartcard car park and car wash token" },
    { "3B88800100000000338191002A", "Regional services for Lombardy (Italy) (Other)\nhttp://www.crs.regione.lombardia.it/" },
    { "3B88800100000000778191006E", "Ireland EPassport (passport)" },
    { "3B88800100000000778191107E", "Romanian Electronic Passport (passport)" },
    { "3B888001000000007783950000", "MULTOS (PKI)" },
    { "3B888001000000007783B3004E", "Polish ePassport (eID)\nhttps://www.pwpw.pl/Produkty/Dokumenty_identyfikacyjne/Paszporty_i_dokumenty_pod.html" },
    { "3B888001000000008081710079", "Apple Pay card - Usually EMV" },
    { "3B888001000000009171710098", "Public transportation fare card (Morocco CAS: Urban bus) (Transport)" },
    { "3B888001000000009181C100D8", "Driving License card of Japan (NFC type-B) (eID)" },
    { "3B88800100000000B37171.0.A", "Public transportation card in Riga, Latvia, called 'e-Talons'\nhttp://etalons.rigassatiksme.lv/en/payments/activating_the_e-ticket/\nBelgian MOBIB (transport)" },
    { "3B88800100000000F781C100BE", "Italian Health Insurance card (eID)\nhttps://en.wikipedia.org/wiki/Italian_health_insurance_card" },
    { "3B88800100000011778183006D", "Taglio PIVKey C980 - RFID I/F (PKI)" },
    { "3B8880010000010701729000EC", "Belgian passport (2008-2009)" },
    { "3B888001000005E0B381A1007F", "Japanese JPKI card (aka JINC card) (eID)\nhttps://github.com/jpki/myna" },
    { "3B888001000014E0B38191005E", "'JUKICARD', the Basic Resident Registration Card in Japan (eID)" },
    { "3B888001000041E0B381A1003B", "ID card issued by Japan government (eID)\nhttps://www.kojinbango-card.go.jp/mynumber/index.html" },
    { "3B8880010073C8400000900062", "NXP JCOP 31 V2.2 36K - RFID I/F\nBarclaycard Visa Wave & Pay - RFID I/F\nCIBC Visa" },
    { "3B8880010073C8401300900071", "Nokia 6131 NFC phone\nhttp://wiki.forum.nokia.com/index.php/Nokia_6131_NFC_-_FAQs\nGiesecke & Devrient's (G&D) Sm@rtCafe Expert 3.1\nAmex Bank of Canada American Express\nTD Canada Trust Visa\nTD Canada Trust Access Card (Visa Debit)" },
    { "3B88800100DDA611F771850060", " 'Pyrelis' card, PAU (France) public transport card. (Calypso card). (Transport)\n http://www.reseau-idelis.com/930-Billettique-IDELIS.html" },
    { "3B888001040200200071C140DF", "Seoul Citypass+ T-Money Card" },
    { "3B8880011000000000817000E8", "Tap&Go MasterCard Sim Card (Bank)\nhttps://www.tapngo.com.hk" },
    { "3B88800111000011008184000C", "OCBC bank card (Bank)" },
    { "3B88800111000011778183007C", "Passport of citizen of Ukraine, Passport of citizen of Ukraine for traveling abroad (passport)" },
    { "3B88800111223344808171003D", "FIME Card Emulator (Other)\nhttps://www.fime.com/products/terminal-integration/savvi.html" },
    { "3B8880011BE1F35E11778100B9", "Uruguyan persona ID. Nowadays a eID. (eID)\nhttps://www.gub.uy/agencia-gobierno-electronico-sociedad-informacion-conocimiento/firma-digital/es-cedula-identidad-digital" },
    { "3B8880011C2D9411F7718500BE", "CEPAS Card (Adult card issued by EZ-Link) (Transport)" },
    { "3B8880011C912611F7718500B0", "NETS Singapore contactless payment card\nhttp://www.nets.com.sg/" },
    { "3B8880011CF0E111F771850016", "CEPAS Card (Concession card issued by Land Transport Authority Singapore) (Transport)" },
    { "3B88800130415654000000077D", "Avtor ID Key (eID)\nhttp://avtor.ua/" },
    { "3B888001304C47127783D50001", "elesec - TCOS 3.0 Signature Card (eID)\nhttps://www.telesec.de/de/tcos/support/downloadbereich/category/28-leistungsbeschreibung" },
    { "3B88800131CCCC017781C1000E", "Ideal v 1.4 (Transport)" },
    { "3B88800131CCCC017783A1006C", "Chile RUT (eID)" },
    { "3B88800131F35E110081950090", "Venez_Omnikey" },
    { "3B88800132F35E1133879500A6", "IDPrime 3930 FIPS Level 3 (Contactless TypeB) (BAI6) (PKI)" },
    { "3B88800135200000778191007B", "Ireland EPassport (passport)" },
    { "3B8880014241454944312E306D", "eID BiH card (eID)" },
    { "3B8880014241454944312E316C", "BiH eID card (eID)" },
    { "3B88800143433169AA200000DB", "PostFinance Switzerland (Bank)\nhttp://www.postfinance.ch" },
    { "3B888001434C6169726520360F", "VISA credit card with NFC payment function (Bank)\nhttp://www.visa.ca/en/personal/visa-paywave/index.jsp" },
    { "3B88800146494445534D4F3167", "Fidesmo card (install or uninstall JavaCard applets or Mifare-based services on the field, using the Fidesmo Android App. (JavaCard))\nhttps://developer.fidesmo.com/" },
    { "3B8880014A434F50763234315E", "RFID - ISO 14443 Type A - NXP JCOP\nNXP J3A081 JavaCard (contactless interface)" },
    { "3B88800150FFFF117783D50069", "Gematik TSYS eHBA G2.1 (HealthCare)" },
    { "3B88800152744D430081C10061", "Rutoken 2151 smart card (eID)\nhttps://www.rutoken.ru/products/catalogue/id_50.html" },
    { "3B88800152745343778183206A", "Aktiv Rutoken ECP 3.0 NFC (PKI)\nhttps://www.rutoken.ru/products/all/rutoken-ecp-nfc/" },
    { "3B888001534B55500100000015", "Silesian public services card (Transport)\nhttp://www.kartaskup.pl" },
    { "3B888001536D61727441707011", "national Lithuania ID card (eID)\nhttps://www.dokumentai.lt/viewpage.php?page_id=77" },
    { "3B8880017661756C746974315F", "ID06 2.0 (eID)" },
    { "3B8880017661756C746974325C", "Vaultit Identity Card (eID)" },
    { "3B8880018066B007010107....", "Gemalto Santander Optelio TUI R7 with WG10 using Contactless interface" },
    { "3B888001990200D10304220167", "Debit card (Bank)" },
    { "3B888001C91207520200811014", "electronic Tickes from the german Transport Association VGN (Verkehrsgemeinschaft Niederrhein)" },
    { "3B888001D10386050080800058", "Resident Identity Card of People Republic of China (Second Generation with RF Feature) (eID)\nhttp://www.gov.cn/banshi/2005-08/02/content_19457.htm" },
    { "3B888001E1E1F35E1377830043", "ePerso - German ID card (issued 2011) (eID)" },
    { "3B888001E1F35E117381A50003", "US passport (2007)" },
    { "3B888001E1F35E117781950037", "Belgian Passport (passport)" },
    { "3B888001E1F35E117781A10003", "Spanish ID know as DNIe (eID)\nhttp://www.dnielectronico.es" },
    { "3B888001E1F35E117781A50007", "US passport (2012)" },
    { "3B888001E1F35E117781C72045", "French passport (2007-2008)" },
    { "3B888001E1F35E117781E10043", "DNIE Spain (eID) Contactless (eID)\nhttp://www.dnielectronico.es/PortalDNIe/" },
    { "3B888001E1F35E1177830000A0", "Residence permit (eID)\nhttp://de.wikipedia.org/wiki/Aufenthaltstitel" },
    { "3B888001E1F35E117783950035", "French biometric ePassport (issued in 2012)" },
    { "3B888001E1F35E117783D50075", "German Passport (ePass) (issued June 2009)" },
    { "3B888001E1F35E117783D70077", "Spanish Electronic Passport 2.0 (passport)\nhttps://www.dnielectronico.es/PortalDNIe/PRF1_Cons02.action?pag=REF_1080&id_menu=56" },
    { "3B888001E1F35E117787950031", "Dutch Government Pilot E-rijbewijs (eID)\nhttps://www.digid.nl/over-digid/kaartlezer-pilot" },
    { "3B888001E1F35E1180879500C6", "Irish Driver Learner Permit (Other)" },
    { "3B888001E1F35E1377830000A2", "ePerso - German ID card (issued 2013)" },
    { "3B888001E1F35E137783D50077", "ePerso - German ID card (issued 2011)" },
    { "3B88813120550057696E4361726429", "SmartCard for Windows 1.0" },
    { "3B888EFE532A031E049280004132360111E4", "German C-Netz SIM card / TeleKarte for mobile phones or phone boxes - 1990s (Telecommunication)\nhttp://download.eversberg.eu/mobilfunk/C-Netz-Dokus/" },
    { "3B890056434152445F4E5353", "Coolkey emulated card using virtual viewer with nssdb (eID)" },
    { "3B8900912691060001220100", "BT Cellnet SIM" },
    { "3B8900912691090001430200", "O2 (UK) SIM - Pay As You Go (Telecommunication)" },
    { "3B894014474732364D35323830", "GSM-SIM e-plus (1800MHz)" },
    { "3B898001006404150102009000EE", "German Passport (issued Apr 2007)" },
    { "3B898001006404280302009000D1", "TCOS 3.0 release 2 on Philips P5CD080 (PKI)\nhttps://www.digchip.com/datasheets/parts/datasheet/1019/P5CD080.php" },
    { "3B8980013131313054434F535052", "Seven-Eleven Value Card / Smart Purse - Thailand (Contactless) (Other)\nhttp://www.7eleven.co.th/about7card.php" },
    { "3B8980013233324353435333363E", "CSCS Smartcard (passport)\nhttp://getgosmart.io" },
    { "3B89800141434F534A763130311A", "ACS ACOSJ (Combi) (JavaCard)\nhttp://www.acs.com.hk/en/products/405/acosj-java-card-combi/" },
    { "3B8980014341524441474146435E", "Student ID of University Duisburg-Essen (Other)\nhttps://www.uni-due.de/studierendensekretariat/studierendenausweis.shtml" },
    { "3B898001434C616972653220363C", "Fidor Smartcard Mastercard/Maestro (Bank)\nhttps://www.fidor.eu" },
    { "3B898001434C616972653320363D", "MasterCard with PayPass issued by Commerbank AG (Germany)  (Bank)\nhttps://www.commerzbank.de/portal/de/privatkunden/produkte/bezahlen/kreditkarten/mastercard-classic/mastercardclassic.html" },
    { "3B898001454D5620303320200673", "Lufthansa Miles & More Gold MasterCard PayPass (old one)\nFound a reference pointing to NXP\nhttp://www.usingrfid.com/news/read.asp?lc=l17607hx1500zk" },
    { "3B8980014A434F5032343252324A", "NXP JCOP J3D" },
    { "3B8980014A434F5032343252334B", "Feitian ePass FIDO-NFC (passport)\nhttps://ftsafe.com/products/FIDO/NFC" },
    { "3B8980014A434F5033315632324A", "JCOP 31 v22 72K (with Mifare 1K emulation) - RFID I/F" },
    { "3B8980014A434F5034315632324D", "JCOP41 Cards (not supported, but recognized by Classic Client)\nNew Zealand e-Passport\nPhilips Semiconductor JCOP41V22" },
    { "3B8980014D54434F537002010439", "Tajikistan passport (passport)" },
    { "3B8980014D54434F53730102013F", "Contactless MTCOS\nhttp://www.masktech.de/" },
    { "3B8980014D54434F53730201043A", "Biometric passport of Czech republic\nBiometric passport of Libya\nBiometric passport of United Kingdom" },
    { "3B8980014D54434F537302020439", "Berlin-Brandenburg public transport eticket fahrCard (Transport)\nhttp://www.vbb.de/de/k/fahrpreise/vbb-fahrcard/798.html\nGerman eTicketing SAM (Transport)\nhttps://www.eticket-deutschland.de/" },
    { "3B8980014D54434F53730205043E", "VGN eTicket (regional public transport for Nuremberg, Germany) (Transport)\nhttps://www.vgn.de/" },
    { "3B89800150565F4A33413034305D", "Java Card J3A040 (JavaCard)\nhttp://smartcardsource.com/contents/en-ca/d9_JCOP-NXP-cards.html" },
    { "3B898001535049564B4559373044", "Taglio PIVkey C980 smart card (Other)\nhttps://pivkey.com/" },
    { "3B89800153504B323544499000DA", "SPK 2.5 D1" },
    { "3B89800166494658425332476F32", "Blockchain Security 2Go (JavaCard)\nhttps://github.com/Infineon/Blockchain" },
    { "3B898001664A41434F53322E3016", "MasterCard, Credit Card by TargoBank, Germany --  (Bank)" },
    { "3B898001665257453250524F4D1C", "NFC enabled SIM card. (Telecommunication)\nElectic vehicle charging card of the EMSP Chargepoint" },
    { "3B8980016653434F4E454432307C", "Alioth 98886 chip (Bank)" },
    { "3B8980018057454D5650524F438F", "BNP Paribas Visa Classic Card (NFC) (Bank)\nhttps://mabanque.bnpparibas/fr/notre-offre/comptes-cartes-et-services/cartes-et-moyens-de-paiement/decouvrir-toutes-les-cartes/carte-visa-classic" },
    { "3B89800180574A4D5650726F33F0", "PayPal UK MasterCard Contacless" },
    { "3B89800180574A4D5676352E30D3", "PayPal Access Business MasterCard (contactless) (Bank)\nCoinbase Card, Visa Debit (Paysafe / TCT FCU) (Bank)\nhttps://coinbase.com/card" },
    { "3B8980018064160402828290006C", "Maestro card (from Mastercard) used by BCGE (switzerland) bank (Bank)" },
    { "3B89800180670412B0030501024C", "Austrian Passport" },
    { "3B8A0091010016000116010096", "GSM-SIM T-Mobil D1 (900MHz)" },
    { "3B8A0091010016000120010096", "GSM-SIM T-D1 prepaid (Xtra)" },
    { "3B8A0091010016000120020096", "GSM-SIM (900MHz) card of the carrier t-mobile for their cellular\nnetwork (phase 2+ with 3V)" },
    { "3B8A00919100160001030[34]0096", "GSM-SIM max.mobil (since 2002: T-Mobile Austria)" },
    { "3B8A0091910017000107020096", "GSM-SIM T-Mobile Austria" },
    { "3B8A0091910017000107030096", "T-Mobile prepaid 2G SIM" },
    { "3B8A0091910017000108010096", "GSM-SIM T-Mobile Austria" },
    { "3B8A0092012691070001930300", "Kazakhstan driver licence" },
    { "3B8A0092020391080001010400", "32K SIM Card from the austrian telecom 'ONE'" },
    { "3B8A0092026591090001010100", "Romania unknown sim/usim card (Telecommunication)" },
    { "3B8A01434F50343156323231FF4A", "JCOP41 Cards (not supported, but recognized by Classic Client)" },
    { "3B8A014A434F50343156323231FF", "JCOP41" },
    { "3B8A80010031C173C8400000900090", "NXP PN65o's Internal Secure Element in card emulation mode. (Other)" },
    { "3B8A80010064055C02033180900016", "T-System Contactless Netkey Card" },
    { "3B8A8001006405760203318090003C", "T-System Contactless TCOS Min" },
    { "3B8A80014A3341303831563234316B", "NXP JCOP CJ3A081 (NFC) (JavaCard)\nNXP JCOP 80K - J3A081V241" },
    { "3B8A80014A434F503331563233327A", "Snapper New Zealand (JCOP)" },
    { "3B8A80014A434F503431563232317F", "JCOP41 Cards (not supported, but recognized by Classic Client)\nNXP JCOP 41 v2.2.1 72k RFID I/F" },
    { "3B8A8001534F535345020325010374", "Super SIM X-SIM 16-in-1 (Telecommunication)\nhttps://multi-com.eu/,details,id_pr,14881,key,super-sim-16-in-1-card,smenu,gsm.html" },
    { "3B8A8001546963546F6B20332E3008", "Cryptas TicTok v3 (PKI)\nhttps://www.cryptas.com/en/products/tictok-card" },
    { "3B8A80018031B8738401E082900006", "German ID Card - Personalausweis" },
    { "3B8A80018031F873F741E082900075", "ePerso - German ID card" },
    { "3B8A80018065A20101013D72D64397", "Gemplus GemXpresso Pro R3 E32 PK (combi)\nMultiApp ID Dual Citizen EAC 80K CC / IDClassic 3340 (old name: Classic TPC DM) (with MPCOS Applet installed by default) - Contactless Mode with Prox DU" },
    { "3B8A80018065A20131013D72D641A5", "Resident Identity Card (eID)" },
    { "3B8B005275746F6B656E6C745344E3", "Aktiv Rutoken Lite SD\nhttps://www.rutoken.ru/products/catalogue/info_52.html" },
    { "3B8B01527450494E5061642020329C", "Aktiv Rutoken PINPad\nhttps://www.rutoken.ru/products/all/rutoken-pinpad/" },
    { "3B8B015275746F6B656E20445320C1", "Aktiv Rutoken ECP\nhttps://www.rutoken.ru/products/all/rutoken-ecp/" },
    { "3B8B015275746F6B656E20454350A0", "Aktiv Rutoken ECP\nhttps://www.rutoken.ru/products/all/cp-rutoken-csp/" },
    { "3B8B015275746F6B656E44534254D7", "Rutoken ECP Bluetooth (eID)\nhttp://www.rutoken.ru" },
    { "3B8B015275746F6B656E6C697465C2", "Aktiv Rutoken Lite\nhttps://www.rutoken.ru/products/all/rutoken-lite/" },
    { "3B8B80010012233F536549440F9000A0", "Estonian Identity Card (eID)\nhttp://id.ee/" },
    { "3B8B80010031C0640804610000900062", "NUMBER26 Maestro Card (Bank)\nhttps://number26.eu\nAmerican Express credit card for corporations" },
    { "3B8B80010031C0640844030400900044", "Credit Card Visa (Other)" },
    { "3B8B80010031C0640844031200900052", "Tomorrow Debit Mastercard issued by solarisBank AG (Bank)\nhttps://www.tomorrow.one/" },
    { "3B8B80010031C0640844031300900053", "Swedbank ISIC (eID)\nhttps://www.swedbank.ee/private/cards/debit/isic?language=EST" },
    { "3B8B80010031C0640844036800900028", "Advanzia / Gebuhrenfrei.com Mastercard Gold (Bank)\nhttps://www.gebuhrenfrei.com/Home/" },
    { "3B8B80010031C0640844037600900036", "American Express Blue Card (Germany) (Bank)" },
    { "3B8B80010031C06408440393009000D3", "Novacard pp0815-04/20 chip (Bank)" },
    { "3B8B80010031C0641F18010000900009", "Student ID card in Poland (eID)" },
    { "3B8B80010031C0641F27010000900036", "American Express Platinum (AU Issued) (Bank)" },
    { "3B8B80010031C064A2E304E182900029", "Electronic ID card  (eID)" },
    { "3B8B80010031C064B0FC100000900053", "Thai Passport 2010, 2011" },
    { "3B8B80010031C1640840213000900057", "MOICA Citizen Digital Certificate of Taiwan R.O.C. (PKI)\nhttps://moica.nat.gov.tw/en/index.html" },
    { "3B8B80010031C1640840223000900054", "IDEMIA Cosmo v8.1-n (Other)" },
    { "3B8B80010031C1640860320600900052", "Banco CTT (Portugal) contactless VISA Debit card (Bank) (Bank)\nhttps://www.bancoctt.pt/home/abrir-conta.html" },
    { "3B8B80010031C1640860321200900046", "AMEX Silver Credit (Bank)" },
    { "3B8B80010031C1640860322000900074", "IDEMIA (Other)" },
    { "3B8B80010031C16408923354009000F3", "Italian healtcare card (TS) National Service Card (CNS) (HealthCare)\nhttp://www.salute.gov.it/portale/lea/dettaglioContenutiLea.jsp?lingua=italiano&id=4693&area=Lea&menu=leaEssn" },
    { "3B8B80010031C1640911213000900007", "SmartMX (Other)" },
    { "3B8B80010031C1640937721300900051", "French ID Card 2021 (contactless interface) (eID)\nhttps://ants.gouv.fr/Les-titres/Carte-nationale-d-identite/La-puce-de-la-nouvelle-carte-nationale-d-identite" },
    { "3B8B800100640411010131800090005A", "German Passport (issued Nov 2006)\nUnited Kingdom e-Passport\nLuxembourg passport (2007)" },
    { "3B8B80010B7880820244492030324D1B", "Mastercard Debit issued by Raiffeisen bank in Czech Republic" },
    { "3B8B80012085008B030FE09AA0E04052", "Shanghai Public Transportation Card (Transport)\nhttp://www.sptcc.com/" },
    { "3B8B8001209000000000001614CDAADF", "JCOP 41 IBM card for Guizhou Normal University (JavaCard)" },
    { "3B8B800120900000000000C3A4CC0918", "ID card (Other)" },
    { "3B8B80012A26A7A10C804100000709C3", "T-Mobilitat (Transport)\nhttps://t-mobilitat.cat/" },
    { "3B8B80014E58502D4E46432032000038", "TouchandTravel Touchpoint NFC-Card.\nTrain-Station in Berlin. Use a NFC-compliant phone to check in for a ticket." },
    { "3B8B800150333038473050335F31302B", "Indonesian ektp (eID)" },
    { "3B8B8001536F6C6F4B65792074617027", "Solokeys Solo Tap: 2FA device with NFC (Other)\nhttps://solokeys.com/products/solo-tap-usb-a-preorder?variant=27688204271680" },
    { "3B8B8001654B5450304432654B54504C", "NXP smart eID - Indonesia ektp (eID)" },
    { "3B8B80018031C06305107F8300900061", "UAB Bank - Prepaid VISA Card (Bank)\nhttps://www.uab.com.mm/cards/" },
    { "3B8B80018066475000B8007F8290002E", "Italian Card Identity (eID)\nhttps://www.cartaidentita.interno.gov.it/" },
    { "3B8B800180F9A00000030800001000C8", "Probably the same as 'JCOP3 SecID P60 CS (JavaCard)' but mated with a contactless Identiv reader (JavaCard)" },
    { "3B8B80018688FF6F391E743C200800D3", "Chinese ICBC (bank)" },
    { "3B8B81314034534D41525453434F5045316D", "Zeeland kaart (Telecommunication)" },
    { "3B8C014D79536D6172744C6F676F6EA5", "EIDVirtual (USB key emulated as a virtual smart card) (PKI)\nhttp://www.mysmartlogon.com/eidvirtual/" },
    { "3B8C40FA808105520101A00000015001", "Algerian Postal Services Current Account Card (Bank)" },
    { "3B8C80010443FD....................", "RFID - NFC Forum tag type 3 (FeliCa)" },
    { "3B8C80014F5449442894B3C00100900045", "Belgian passport (2009-2013)" },
    { "3B8C80014F5449442894F7C00000900000", "French passport (2010-2013)" },
    { "3B8C800150........E1F35E117781E1..", "Spanish eID, Documento Nacional de Identidad (DNIe) (eID)\nhttp://www.dnielectronico.es/" },
    { "3B8C80015000000000000000009181A0ED", "Belimo VAV-Compact NFC (Other)\nhttp://www.belimo.ch/pdf/e/flyer_nfc_en.pdf" },
    { "3B8C8001500005022D0206000000819163", "Local Transport card for Trentino region (Italy) trentino trasporti esercizio (Transport)\nhttp://www.ttesercizio.it/" },
    { "3B8C80015001A5CE19000000008081715E", "VISA Card from Bank BANQUE POPULAIRE (Bank)" },
    { "3B8C80015001BA137E00000000B3717138", "Mobib (Brussels public transportation card)" },
    { "3B8C80015003A129CF0000000011818108", "rav-kav, Israel transport card (Transport)\nhttp://www.egged.co.il/Article-786-Rav-Kav-Card.aspx" },
    { "3B8C80015004463EC3E1F35E117781A1E8", "Spanish ID (eID)" },
    { "3B8C80015005A966960000000080817171", "Hello bank! VISA CLASSIC Card (Bank)\nhttp://www.hellobank.fr/" },
    { "3B8C80015006DCA8590000000080817106", "VISA Hello bank! (NFC) (Bank)\nhttps://www.hellobank.fr/" },
    { "3B8C800150107331B400000000B3717108", "MiMuovo public transport card used in Italian region Emilia Romagna (Transport)" },
    { "3B8C80015010B76AAE00000000B371718D", "Tisseo (Toulouse)  (Transport)\nhttp://www.tisseo.fr/les-tarifs/obtenir-une-carte-pastel" },
    { "3B8C80015010B9F98900000000B3717137", "Toulouse (France) city public transport card called TISSEO Pastel (Transport)\nhttps://www.tisseo.fr/les-tarifs/obtenir-une-carte-pastel" },
    { "3B8C80015010D632A000000000B37171BA", "MOBIB (STIB) (Transport)\nhttps://www.stib-mivb.be/article.html?_guid=30af0085-2483-3410-5394-a71daf08acd1&l=en" },
    { "3B8C800150186188CEE1F35E117781C70E", "French passport (2007-2008)" },
    { "3B8C80015019E3BB3D00000000008177D7", "ING/Maestro bank card (Bank)\nhttps://www.ing.nl/particulier/betalen/passen/index.html" },
    { "3B8C80015024AD64E10000000033819172", "Italian healthcare + public administration card (HealthCare)\nhttp://sistemats1.sanita.finanze.it/wps/portal" },
    { "3B8C800150260DBB150000000000718128", "Navigo Card (Transport)\nhttp://www.navigo.fr/" },
    { "3B8C8001502704002400000000007181AA", "Navigo pass (Transport)\nhttp://www.navigo.fr/" },
    { "3B8C8001502722ED0D0000000000718148", "Navigo (France) transport card (Transport)" },
    { "3B8C8001502724266400000000007181EC", "French Transport Card (Navigo Card) (Transport)\nhttps://fr.wikipedia.org/wiki/Passe_Navigo" },
    { "3B8C8001502747D205000000000071811A", "Pass Navigo Decouverte (Transport)\nhttps://fr.wikipedia.org/wiki/Passe_Navigo" },
    { "3B8C800150275038CE000000000071812C", "Paris transportation card (Pass Navigo) (Transport)\nhttps://fr.wikipedia.org/wiki/Passe_Navigo" },
    { "3B8C80015027B1F76B0000000000717157", "Navigo (public transportation in Ile-de-France), IDF Mobilites (Transport)\nhttps://www.iledefrance-mobilites.fr/l-innovation/navigo/" },
    { "3B8C8001502C8D214B23180100778197CD", "Indonesian Driver License" },
    { "3B8C80015035A45B650000000080817182", "Trenitalia cartafreccia (Transport)\nhttp://www.trenitalia.com/tcom/Cartafreccia" },
    { "3B8C800150370B16BD310106017781777C", "Driver License of Indonesia - SIM (Surat Izin Mengemudi) (Transport)" },
    { "3B8C800150380EB25B00000000B3717131", "BIP (Biglietto Integrato Piemonte) Card, GTT (Gruppo Trasporti Torinese) (Transport)\nhttp://bip.piemonte.it/" },
    { "3B8C8001503A88EC29E1F35E117781E160", "DNI electronico (Spanish electronic ID card) (eID)\nhttp://www.dnielectronico.es" },
    { "3B8C8001503A964B0000000000008180BB", "Ventra Transit Pass (Transport)\nhttps://www.ventrachicago.com/how-to/ventra-cards/" },
    { "3B8C80015043E0F5F43101060077817748", "Indonesian Driver License" },
    { "3B8C8001504553FFC6E1F35E117781A178", "Electronic DNI (eID)" },
    { "3B8C80015046E570EC2318010077819739", "Indonesian Driver License" },
    { "3B8C800150497A5177E1F35E117781A546", "USA PASSPORT BOOK ICAO  (passport)\nhttps://www.icao.int/publications/pages/publication.aspx?docnum=9303" },
    { "3B8C8001504B75AF41E1F35E117781A583", "USA PASSPORT BOOK ICAO  (passport)\nhttps://www.icao.int/publications/pages/publication.aspx?docnum=9303" },
    { "3B8C8001505381573630AAAA017781D7FE", "Indonesian ektp (eID)" },
    { "3B8C8001505467137900000000F781C1B3", "Tessera Sanitaria italian health care card (HealthCare)" },
    { "3B8C8001505CF5A94530AAAA017781D708", "Indonesia ektp (eID)" },
    { "3B8C800150605F2EFA00000000778191D1", "Residence Permit (Switzerland) (eID)" },
    { "3B8C80015064E65B000000000000818085", "Chicago CTA Ventra Transit card\nhttps://www.ventrachicago.com/" },
    { "3B8C800150710CF3C800000000B37171A8", "MOBIB CARD BELGIUM (Transport)" },
    { "3B8C800150773B2DBD0000001100818594", "Texas Instruments Dynamic NFC Interface Transponder (RF430CL330H)" },
    { "3B8C800150784B2CCB00000000B371713A", "... (Transport)\nhttps://www.portalviva.pt/" },
    { "3B8C80015078F87217E1F35E117781A5B6", "US (passport)" },
    { "3B8C8001507919600100DDA611F7718535", "Transport Traway Montpellier France  (Transport)" },
    { "3B8C8001507AA44007231801007781979F", "Indonesian Driver License" },
    { "3B8C8001507E0071D20000000000717180", "Unica (= Just one) joined train and public transport card for Italian region Emilia Romagna (evolution of MiMuovo) (Transport)" },
    { "3B8C8001507F9C668A0000000000818754", "NFC Mastercard issued by CSOB bank Czech Republic, first 4 digits 5168" },
    { "3B8C80015089DCA96E00000000808171BF", "Cartafreccia VISA (Italian Railways Prepaid + Loyalty Card) (Bank)" },
    { "3B8C800150915D7129E1F35E117781A1C3", "Spanish eID, Documento Nacional de Identidad (DNIe) (eID)\nhttp://www.dnielectronico.es/" },
    { "3B8C80015093195E3000000000007171B9", "OPUS STM CANADA (Transport)\nhttp://stm.info/" },
    { "3B8C800150933CCC05000000000071713B", "OPUS Card, public transport (subway) of Montreal (Transport)\nhttp://www.stm.info/fr/infos/titres-et-tarifs/carte-opus-et-autres-supports/carte-opus" },
    { "3B8C800150A221FAA031CCCC017781C183", "Morpho (eID)\nhttp://www.morpho.com/" },
    { "3B8C800150AC039D44E1F35E117781A121", "Spanish DNIe (eID)\nhttps://www.dnielectronico.es" },
    { "3B8C800150B156D8BB00000011008185CC", "TI rf430cl330h (Other)\nhttp://www.ti.com/product/rf430cl330h" },
    { "3B8C800150C098373F000000009171719C", "PassPass card issued by Transpole : the public transportation service of Lille, France, and SNCF : the french national railway. (Transport)\nhttps://www.transpole.fr/fr/pass-pass-et-tarifs/carte-pass-pass-personnelle.aspx" },
    { "3B8C800150C0AA574E00000000B371719D", "Transportation Pastel Card from Toulouse (France)  (Transport)\nhttps://www.tisseo.fr/se-deplacer/bien-voyager" },
    { "3B8C800150C0C894D300000000B37171A1", "pastel (Transport)" },
    { "3B8C800150C0CA568F000000009171711F", "Ginko card, France - Besancon transport company (Transport)\nhttps://ginko.voyage" },
    { "3B8C800150C0E450CA0000000091717172", "Transportation card for Lille (France) (Transport)" },
    { "3B8C800150C0EA9CBB00000000B37171E3", "Tisseo (Toulouse) (Transport)\nhttp://www.tisseo.fr/les-tarifs/obtenir-une-carte-pastel" },
    { "3B8C800150C0F1DE700000000091717153", "isodep, NfcB (Transport)" },
    { "3B8C800150C110BBA9000000009171710F", "Divia card (passport)" },
    { "3B8C800150C11BA3F10000000091717144", "Tramway (PKI)" },
    { "3B8C800150C14164E3000000000071715A", "Navigo Annuel (France) (Transport)\nhttps://www.iledefrance-mobilites.fr/titres-et-tarifs/detail/forfait-navigo-annuel" },
    { "3B8C800150C16A347200000000007171B0", "Navigo pass (RATP) (Transport)\nhttp://www.navigo.fr/" },
    { "3B8C800150C17B55BA0000000000717108", "Navigo Easy (Paris public transportation) (Transport)\nhttps://parisbytrain.com/navigo-easy/" },
    { "3B8C800150C17DA8CA0000000000717183", "Navigo Easy (France) transport card (Transport)\nhttps://www.ratp.fr/titres-et-tarifs/passe-navigo-easy" },
    { "3B8C800150C7251C5A00000011F781811F", "MOBIB Belgian public transport Card (Transport)\nhttps://mobib.be/fr.html" },
    { "3B8C800150CA24513E00000011F781813A", "belgian mobib transportation card (Transport)" },
    { "3B8C800150CBFB077E000000008081E1F4", "Samsung Digital Center in Seul Access ID card for guests (eID)" },
    { "3B8C800150D5404F231C000011778185DA", "CEPAS Card (Concession card issued by Land Transport Authority Singapore) (Transport)" },
    { "3B8C800150D94E7D0000000000008180B6", "Chicago CTA Ventra Transit card (Transport)\nhttps://www.ventrachicago.com/" },
    { "3B8C800150DF4C852C0000000000817791", "SNS Bank Netherlands (Bank)" },
    { "3B8C800150E2F8282E0000000000818747", "ING Maestro Debit Card (Bank)\nhttps://www.ing.nl/particulier/index.html" },
    { "3B8C800150EB5E6A120000000000817766", "Maestro card (Bank)" },
    { "3B8C800150F2AD19D7000000000081773A", "ING Maestro Debit Card (Bank)\nhttps://www.ing.nl/particulier/index.html" },
    { "3B8C800150F56FF82BE1F35E113381C73C", "ID of the Republic of Kazakhstan Ministry of Internal Affairs of the Republic of Kazakhstan (eID)" },
    { "3B8C800150F6D9142C00000000008177BC", "ING (NL) Maestro (Bank)\nhttps://ing.nl/" },
    { "3B8C800150F6DCFC1323180100778197C3", "mifare (Transport)" },
    { "3B8C800150F9F360D9E1F35E117781A1E4", "DNI electronico (Spanish electronic ID card) (eID)\nhttp://www.dnielectronico.es" },
    { "3B8C800150FE51569F0000000033819118", "Repubblica Italiana - Tessera Sanitaria (HealthCare)\nhttps://sistemats1.sanita.finanze.it/portale/tessera-sanitaria" },
    { "3B8C800150FE892767110000117781811D", "'Carta Mobile' bus card by CTT (Tuscany's bus company) (Transport)\nhttp://www.pisa.cttnord.it/Carta_Mobile/P/561" },
    { "3B8C800150FFFFFFFFFFFFFF22001051C1", "Printer ribbon tag (Other)" },
    { "3B8C800150FFFFFFFFFFFFFF33001051D0", "Atmel AT88SC0808CRF CryptoRF(r) EEPROM Memory (Other)\nhttp://www.microchip.com/mymicrochip/filehandler.aspx?ddocname=en590154" },
    { "3B8C8001597562696B65794E454F723358", "Yubikey Neo" },
    { "3B8C8001597562696B65794E454F72FF94", "Yubikey Neo via NFC reader (Other)\nhttps://www.yubico.com/" },
    { "3B8C8001805A414B4465444C76312E30AD", "Electronic driving license card\nhttp://www.akd.hr/?p=10" },
    { "3B8C8001806411650190730000008107F9", "Universal Electronic Card (UEC) Russian (passport)\nhttp://uecard.ru/" },
    { "3B8C80018091E1657701010306829000F8", "french BIO Passeport (2006)" },
    { "3B8C80018091E165D00043000082900019", "French passport (issued in late 2008)" },
    { "3B8C80018091E165D0004600008290001C", "US passport (2009)" },
    { "3B8C80019067464A00641606F2727E007C", "PIVKey C910 (PKI)\nhttps://pivkey.com/" },
    { "3B8C80019067464A006808060000000090", "Feitian JavaCard - RFID I/F (JavaCard)" },
    { "3B8C80019067464A0100360600000000C7", "A40CR (eID)" },
    { "3B8D0180FBA000000397425446590401", "Microsoft Virtual Smart Card 0 (PKI)" },
    { "3B8D0180FBA000000397425446590401CF", "Microsoft Virtual Smartcard Provider shared through VMWare Workstation. (Other)\nhttps://technet.microsoft.com/en-us/library/dn593708%28v=ws.11%29.aspx" },
    { "3B8D80010073C80013644737423700900055", "TD Canada Trust Visa" },
    { "3B8D80010073C8001364543741380090004A", "Visa Debit (ING-DiBa) (Bank)\nhttps://www.ing-diba.de/\nVisa Debit Card with NFC payment function (Consorsbank)\nhttps://www.consorsbank.de/" },
    { "3B8D80010073C80013645437423700900046", "pay (Bank)" },
    { "3B8D80010073C80013645437433300900043", "Deutsche Bank Debit MasterCard (Bank)" },
    { "3B8D80010073C80013645437433500900045", "Student ID card in Poland (eID)" },
    { "3B8D80010073C80013645437443300900044", "master cRD (Bank)\nTD MasterCard\nTangerine MasterCard" },
    { "3B8D80010073C80013645437473100900045", "Tangerine ATM/ABM Card" },
    { "3B8D80010D788084020073C840130090FFF8", "Nokia 6212 phone seen as NFC device" },
    { "3B8D80010D78F7B1024A434F50763234316A", "Electronic Identity For Students at university (eID)" },
    { "3B8D80014946582D6A63333031677032325A", "Degussa Bank Corporate MasterCard (Bank)\nhttps://firmenkarten.degussa-bank.de/" },
    { "3B8D8001534C4A35324778787979797A5248", "cipurse (Other)" },
    { "3B8D800154415854434F534E201703073304", "Contactless Java Card v.2.2, GP version 2.2.1 with a NDEF storage applet installed. (JavaCard)" },
    { "3B8D8001736674652D63643038302D6E663F", "G&D SmartCafe Expert 3.2 80K Dual" },
    { "3B8D800180318065B0070202898300900075", "JCOP30 contactless interface" },
    { "3B8D80018073C021C057597562694B6579F9", "Yubikey 5 NFC (via NFC) (Other)\nhttps://www.yubico.com/product/yubikey-5-nfc/#yubikey-5-nfc" },
    { "3B8D80018073C021C057597562694B65FF7F", "Yubikey 5 NFC via ACR122U (Other)" },
    { "3B8D80018091E1318065B0831111AC830034", "TOP DM GX4 Cards [TOP DM GX4 on Gemalto Prox]" },
    { "3B8D80018091E165D0005B010273D44140B7", "Portuguese Passport (passport)\nhttp://www.pep.pt/PagesPT/Caracteristicas.aspx" },
    { "3B8D80018091E165D0005B010373D44140B6", "French passport (2010-2011)" },
    { "3B8E8001005100631F6D01739F20C0C0900012", "Identity card (eID) Republic of Latvia (eID)\nhttps://www.pmlp.gov.lv/en/home/services/personal-certificates-%28eid%29/" },
    { "3B8E8001005131631F5901739F20C0C0900017", "Identity card (eID) Republic of Latvia (eID)\nhttp://www.pmlp.gov.lv/en/home/services/personal-certificates-%28eid%29/\nFrench driving license (eID) (contactless)" },
    { "3B8E80010E7833C4020064041501020090FF95", "Spanish Passport" },
    { "3B8E8001103877A78091E165D0004200008272", "Czech Republic e-Passport (issued Feb 2009)" },
    { "3B8E80011178B3C0024F5449442894B3FFFF0E", "Civilian passport NFC tag (passport)" },
    { "3B8E8001137880720280318066B1840C01FF04", "Optelio Contactless Gemalto (Bank)" },
    { "3B8E8001137880800246494F4D4B5F3030314E", "MasterCard/PayPass Card issued by Czech FIO Banka a.s. (contactless chip)\nnote the ASCII string 'FIOK_001N' embedded in ATR" },
    { "3B8E800152464944494F74204A434F5038305A", "RFIDIOt G&D SmartCafe 80K" },
    { "3B8E800153434536302D43443038312D6E464A", "SmartCafe Expert 6.0 80K Dual (JavaCard)\nhttp://www.smartcardfocus.com/shop/ilp/id~684/smartcafe-expert-6-0-80k-dual-/p/index.shtml" },
    { "3B8E80018031806549544E5850120FFF8290F0", "Italian Electronic Contactless Identity Card v. 3.0 (CIE 3.0) - ICAO 9303 Compliant (eID)\nhttps://www.cartaidentita.interno.gov.it/caratteristiche-del-documento/" },
    { "3B8E80018031806549544E5850120FFFFFFFE2", "Italian identity card, 2nd version (eID)\nhttps://www.cartaidentita.interno.gov.it/" },
    { "3B8E800180318066409089120802830190000B", "ISO 14443B Type T = CL Infineon Card" },
    { "3B8E800180318066B0070300AC018300900052", "BCA Flazz Card (Bank) www.bca.com" },
    { "3B8E800180318066B0840C016E01830090001D", "MultiApp Cards (Easy 72K Type B and Combi 72K Type B)\nBarclaycard Platinum contact/contactless (wave)" },
    { "3B8E800180318066B08412016E018300900003", "Contactless Barclaycard Visa\nMyCiti Transport Card MasterCard PayPass (Cape Town, South Africa)" },
    { "3B8E800180318066B08416016E018300900007", "Barclaycard Platinum VISA (Bank)" },
    { "3B8E800180318066B1840C016E0183009000..", "Gemalto Santander Optelio TUI R7 using Contactless interface" },
    { "3B8E800180318066B1840C016E01830090001C", "UK Lloyds Bank Gold Visa Debit (Contact & Contactless)\nbPay by barclaycard - contactless pre-paid Visa\nBPP Digital pre-paid VISA card (Bank)\nhttps://bpp.com.br/" },
    { "3B8E80018031815448534D3173802140810718", "Smartcard-HSM (Contactless Interface) (PKI)\nhttp://www.cardcontact.de/products/sc-hsm.html" },
    { "3B8E80018031815448534D3173802140FFFF9E", "SmartCard-HSM RFID (PKI)\nhttps://www.smartcard-hsm.com/" },
    { "3B8E800180919131C06477E30300838290001C", "Belgian Passport (2005)\nThai Passport 2005" },
    { "3B8E80018091E131C06477E30300838290006C", "Belgian Passport (2006-2007)" },
    { "3B8F008031E073FE21116340726283079000", "Beeline (Telecommunication)\nhttp://beeline.ru" },
    { "3B8F008031E073FE2113574A330E20333100", "MegaFon RUS (Telecommunication)\nhttp://megafon.ru" },
    { "3B8F01415642000000000000000001000000DA", "AVEST-SYSTEMS AvBign (PKI)" },
    { "3B8F0145464B000000000000000004000000C2", "EfitKey (PKI)" },
    { "3B8F018025A00000005657444B3430300600B7", "SafeNet IKey4000" },
    { "3B8F80010000000000000000000000000000000E", "Tangem card (Other)\nhttps://tangem.com/" },
    { "3B8F80010000000000000000000000FF829000E3", "CIE (eID)" },
    { "3B8F80010031B86404B0ECC1739401808290000E", "Contactless CPS v3 Card (Carte de Professionnel de Sante)" },
    { "3B8F80010031C173C8211064414D333007900088", "ING-VISA-Card (Bank)\nhttps://www.ing.de/girokonto/karten-bargeld/" },
    { "3B8F80010031C173C8211064574B313400900099", "G&D Sm@rtCafe Card embedded in a wristband (Bank)\nhttps://www.gi-de.com/en/au/mobile-security/industries/financial-institutions/wearables/" },
    { "3B8F800100664653051000FF71DF000000000039", "JavaCOS A40 dual interface Java card - 64K (JavaCard)" },
    { "3B8F800100B85421000090000000000000000053", "netbank Germany, Mastercard (Bank)\nhttps://netbank.de" },
    { "3B8F800100B85431000090000000000000000043", "Monzo MasterCard Contactless (Bank)\nhttps://monzo.com/" },
    { "3B8F800100B854310000900000000000FFFFFFBC", "VISA Debit issued by WIREX. card made by CONTIS / TAG SYSTEMS (Bank)\nhttps://wirexapp.com/" },
    { "3B8F800141434F53204449616E6131204C63365B", "DKB-VISA-Card (Bank)\nhttps://produkte.dkb.de/?&page=girokonto#kreditkarte" },
    { "3B8F800141434F53204449616E613120FFFFFFBD", "DKB Visa Credit Card (Bank)\nhttps://www.dkb.de" },
    { "3B8F800143443269AB41202020202020FFFFFF47", "BKB VISA Card Switzerland (Bank)\nhttps://www.bkb.ch/de/privatkunden/konten-und-karten/kreditkarten/world-mastercard-silber-oder-visa-classic/factsheet" },
    { "3B8F800143553269AA20202020202020202020E9", "UBS Access Card (Mobile Online Banking, NFC, Switzerland)" },
    { "3B8F800145504100000000........00........", "Austrian Quick E-purse contactless\nhttp://www.quick.at/" },
    { "3B8F80014A434F50332041545320434841525326", "Samsung Galaxy Watch Active NFC (Other)" },
    { "3B8F800152464944494F74204A434F5020333676", "RFIDIOt JCOP 36K Blank\nhttp://rfidiot.org" },
    { "3B8F800152464944494F74204A434F5020373276", "RFIDIOt JCOP 72K Blank\nhttp://rfidiot.org" },
    { "3B8F800152464944494F74204A434F5037327224", "RFIDIOt JCOP 72K RANDOM_UID Blank\nhttp://rfidiot.org" },
    { "3B8F800156696E5061795379732050757273652F", "JCOP (Other)" },
    { "3B8F800180318065B0........120FFE829000..", "IDPrime MD 3810 T=Contactless (Prox DU)" },
    { "3B8F800180318065B0842327E5120FFE8290007E", "Gemalto IDPrime MD 3810 Blank Card (Other)\nhttp://www.gemalto.com/products/IDPrime_MD/index.html" },
    { "3B8F800180318065B0846160FB120FFD82900066", "IDPrime 3930 FIPS Level 2 (Contactless TypeA) (BAI5, BAI7) (PKI)" },
    { "3B8F800180318065B0850300EF120FFE82900072", "Gemalto IDPrime MD 3840\nhttp://www.gemalto.com/dwnld/6891_IDPrimeMD3840_Product_Datasheet_May14.pdf" },
    { "3B8F800180318065B0850300EF120FFF82900073", "Grand Duchy of Luxembourg / Identity card with LuxTrust certificate (eID)\nhttp://www.guichet.public.lu/citoyens/fr/citoyennete/papiers-identite/carte-identite/nouv-carte-identite-adulte-EN/index.html" },
    { "3B8F800180318065B085040011120FFF8290008A", "Dutch driver licence (eID)\nItalian electronic identity card (eID)\nhttps://en.wikipedia.org/wiki/Italian_electronic_identity_card" },
    { "3B8F80018031B865B0850300EF1200F68290004D", "Finnish electronic identity card (eID)\nhttps://vrk.fi/en/electronic-identity-and-certificates" },
    { "3B8F80018031E06B042105027255555555555564", "Banamex/Citi Bank Bsmart MasterCard Paypass (Bank)\nhttps://www.banamex.com/es/personas/tarjetas_credito/ver_tarjetas/puntos_efectivo/bsmart.htm" },
    { "3B8F80018031E06B04310502D1555555........", "Revolut Prepaid Mastercard (Contactless) (Bank)\nhttps://revolut.com/" },
    { "3B8F80018031E06B061605028C555555555555AF", "Air Miles American Express card (contactless) (Bank)" },
    { "3B8F8001804F0CA000000306..000000000000..", "Card name not given (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..000100000000..", "MIFARE Classic 1K (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..000200000000..", "MIFARE Classic 4K (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..000300000000..", "MIFARE Ultralight (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..000400000000..", "SLE55R_XXXX (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..000600000000..", "SR176 (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..000700000000..", "SRI X4K (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..000800000000..", "AT88RF020 (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..000900000000..", "AT88SC0204CRF (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..000A00000000..", "AT88SC0808CRF (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..000B00000000..", "AT88SC1616CRF (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..000C00000000..", "AT88SC3216CRF (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..000D00000000..", "AT88SC6416CRF (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..000E00000000..", "SRF55V10P (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..000F00000000..", "SRF55V02P (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..001000000000..", "SRF55V10S (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..001100000000..", "SRF55V02S (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..001200000000..", "TAG_IT (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..001300000000..", "LRI512 (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..001400000000..", "ICODESLI (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..001500000000..", "TEMPSENS (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..001600000000..", "I.CODE1 (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..001700000000..", "PicoPass 2K (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..001800000000..", "PicoPass 2KS (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..001900000000..", "PicoPass 16K (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..001A00000000..", "PicoPass 16Ks (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..001B00000000..", "PicoPass 16K(8x2) (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..001C00000000..", "PicoPass 16KS(8x2) (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..001D00000000..", "PicoPass 32KS(16+16) (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..001E00000000..", "PicoPass 32KS(16+8x2) (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..001F00000000..", "PicoPass 32KS(8x2+16) (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..002000000000..", "PicoPass 32KS(8x2+8x2) (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..002100000000..", "LRI64 (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..002200000000..", "I.CODE UID (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..002300000000..", "I.CODE EPC (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..002400000000..", "LRI12 (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..002500000000..", "LRI128 (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..002600000000..", "Mifare Mini (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..002700000000..", "my-d move (SLE 66R01P) (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..002800000000..", "my-d NFC (SLE 66RxxP) (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..002900000000..", "my-d proximity 2 (SLE 66RxxS) (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..002A00000000..", "my-d proximity enhanced (SLE 55RxxE) (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..002B00000000..", "my-d light (SRF 55V01P) (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..002C00000000..", "PJM Stack Tag (SRF 66V10ST) (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..002D00000000..", "PJM Item Tag (SRF 66V10IT) (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..002E00000000..", "PJM Light (SRF 66V01ST) (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..002F00000000..", "Jewel Tag (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..003000000000..", "Topaz NFC Tag (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..003100000000..", "AT88SC0104CRF (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..003200000000..", "AT88SC0404CRF (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..003300000000..", "AT88RF01C (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..003400000000..", "AT88RF04C (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..003500000000..", "i-Code SL2 (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..003600000000..", "MIFARE Plus SL1 2K (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..003700000000..", "MIFARE Plus SL1 4K (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..003800000000..", "MIFARE Plus SL2 2K (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..003900000000..", "MIFARE Plus SL2 4K (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..003A00000000..", "MIFARE Ultralight C (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..003B00000000..", "FeliCa (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..003C00000000..", "Melexis Sensor Tag (MLX90129) (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306..003D00000000..", "MIFARE Ultralight EV1 (as per PCSC std part3)" },
    { "3B8F8001804F0CA00000030600....00000000..", "RFID - No standard given (as per PCSC std part3)" },
    { "3B8F8001804F0CA0000003060000000000000068", "NFC/RFID 'Android Beam' mode on a Sony Xperia Ion" },
    { "3B8F8001804F0CA00000030601....00000000..", "RFID - ISO 14443 Type A Part 1 (as per PCSC std part3)" },
    { "3B8F8001804F0CA00000030602....00000000..", "RFID - ISO 14443 Type A Part 2 (as per PCSC std part3)" },
    { "3B8F8001804F0CA00000030603....00000000..", "RFID - ISO 14443 Type A Part 3 (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306030000000000006B", "buss/train pass for use with Skanetrafiken (www.skanetrafiken.se) busses and trains.\npublic library of Dusseldorf\nhttp://www.duesseldorf.de/stadtbuechereien/\nspecialized Mifare Ultralight card" },
    { "3B8F8001804F0CA000000306030001000000006A", "NXP/Philips MIFARE Classic 1K (as per PCSC std part3)\nhttp://www.nxp.com/#/pip/pip=[pfp=41863]|pp=[t=pfp,i=41863]\nOyster card - Transport for London (first-gen)\nhttps://en.wikipedia.org/wiki/Oyster_card\nACOS5/1k Mirfare\nvivotech ViVOcard Contactless Test Card\nBangkok BTS Sky SmartPass\nMifare Classic 1K (block 0 re-writeable)\nElectic vehicle charging card of the German Telekom, acting as EMSP GetCharge\nElectic vehicle charging card of the EMSP Stadtwerke Muenchen (SWM), ladenetz.de, Germany\nElectic vehicle charging card of the EMSP EinfachStromLaden of Maingau-Energie, Germany\nScouter carsharing customer card in Germany\nhttps://scouter.de/" },
    { "3B8F8001804F0CA0000003060300020000000069", "RFID - ISO 14443 Type A - NXP Mifare card with 4k EEPROM" },
    { "3B8F8001804F0CA0000003060300030000000068", "RFID - ISO 14443 Type A - NXP Mifare Ultralight or UltralightC" },
    { "3B8F8001804F0CA0000003060300FF0000000094", "ACTV (Italy) prepaid transport ticket\n'NFC Tag' -- Sony's 'Smart Tags'" },
    { "3B8F8001804F0CA00000030603F004000000009F", "NFC FORUM TYPE 1 TAG\nwww.inovision-group.com/topaz\nISO/IEC 14443A - 96 Bytes read/write NFC/RFID IC mandated by NFC Forum as the Type 1 NFC Forum Tag Format." },
    { "3B8F8001804F0CA00000030603F011000000008A", "Bangkok Metro (MRT)\nHTC One X Android phone (European edition 'endaevoru')" },
    { "3B8F8001804F0CA00000030603FF4000000000D4", "Nokia N9" },
    { "3B8F8001804F0CA00000030603FF88000000001C", "Infineon Mifare SLE 66R35\nhttp://www.infineon.com/cms/en/product/channel.html?channel=ff80808112ab681d0112ab69686e01ee\n'Old' 'unlimited trips' card for Moscow Metro (underground)" },
    { "3B8F8001804F0CA00000030605....00000000..", "RFID - ISO 14443 Type B Part 1 (as per PCSC std part3)" },
    { "3B8F8001804F0CA00000030606....00000000..", "RFID - ISO 14443 Type B Part 2 (as per PCSC std part3)" },
    { "3B8F8001804F0CA00000030607....00000000..", "RFID - ISO 14443 Type B Part 3 (as per PCSC std part3)" },
    { "3B8F8001804F0CA000000306070000000000006F", "Atmel AT88RF04C CryptoRF" },
    { "3B8F8001804F0CA000000306074344600201E4EF", "'Andante' Card, Porto (Portugal) metro card. (ISO14443 B CTS/CTM512B) (Transport)\nhttp://www.transportespublicos.pt/en/glossary/andante-ticket-system/" },
    { "3B8F8001804F0CA00000030609....00000000..", "RFID - ISO 15693 Part 1 (as per PCSC std part3)" },
    { "3B8F8001804F0CA0000003060A....00000000..", "RFID - ISO 15693 Part 2 (as per PCSC std part3)" },
    { "3B8F8001804F0CA0000003060A001C000000007E", "RFID - HID iCLASS 16K CL" },
    { "3B8F8001804F0CA0000003060B....00000000..", "RFID - ISO 15693 Part 3 (as per PCSC std part3)" },
    { "3B8F8001804F0CA0000003060B00000000000063", "RFID - ISO 15693 - EM Microelectronic-Marin SA" },
    { "3B8F8001804F0CA0000003060B000E000000006D", "RFID - ISO 15693 - Infineon" },
    { "3B8F8001804F0CA0000003060B00120000000071", "RFID - ISO 15693 - Texas Instrument" },
    { "3B8F8001804F0CA0000003060B00130000000070", "Discovery kit for M24LR04E\nhttp://www.st.com/m24lr04e-discovery" },
    { "3B8F8001804F0CA0000003060B00140000000077", "Philips ICode\nRFID - ISO 15693 - Philips Semiconductors" },
    { "3B8F8001804F0CA0000003060C....00000000..", "RFID - ISO 15693 Part 4 (as per PCSC std part3)" },
    { "3B8F8001804F0CA0000003060D....00000000..", "Contact (7816-10) I2C (as per PCSC std part3)" },
    { "3B8F8001804F0CA0000003060E....00000000..", "Contact (7816-10) Extended I2C (as per PCSC std part3)" },
    { "3B8F8001804F0CA0000003060F....00000000..", "Contact (7816-10) 2WBP (as per PCSC std part3)" },
    { "3B8F8001804F0CA00000030610....00000000..", "RFID - FeliCa compatible (as per PCSC std part3)\nContact (7816-10) 3WBP (as per PCSC std part3)" },
    { "3B8F8001804F0CA00000030611003B0000000042", "RFID - FeliCa (generic) (as per PCSC std part3)\nSuica public transit card (Japan IC system)\n(also: Hayakaken, ICOCA, Kitaca, manaca, nimoca, PASMO, PiTaPa, SUGOCA, TOICA)\nhttps://en.wikipedia.org/wiki/Suica\nOctopus, MTR network from Hong Kong, 2014" },
    { "3B8F8001804F0CA00000030640....00000000..", "RFID - Low Frequency < 135 kHz (as per PCSC std part3)" },
    { "3B8F8001804F0CA0000003064000000000000028", "HID Proximity. Used to access buildings. Reference on the card 'HID0008P'.\nhttp://www.hidglobal.com/product-display/cards-and-credentials/hid-proximity" },
    { "3B8F8001804F0CA0001A0000000078", "iclass 16k cl (eID)" },
    { "3B8F8001805A08030300000001524321829000FF", "Carte Mode Pass (Used in Clermont-Ferrand, France, to store personal\ninformation and T2C subscription. T2C is the public transport\ncompany of Clermont-Ferrand)\nhttp://www.t2c.fr/" },
    { "3B8F8001805A08030300000001D3377282900059", "French Transport Card Pass'bus (used in Metz, France)\nhttp://www.tcrm-metz.fr/" },
    { "3B8F8001805A08030300000002B36C5382900040", "Modalis: transport card for Gironde buses (France) (Transport)\nhttp://transgironde.gironde.fr/" },
    { "3B8F8001805A08030400020024E279788290000C", "Paris Navigo card 14443 B' (Innovatron - Calypso)" },
    { "3B8F80018066B007010107............9000..", "Gemalto Santander Optelio TUI R7 with WG10 customized using Contactless interface" },
    { "3B8F80018073CC91CBF9A0000003080000100029", "NIST demo PIV card (eID)" },
    { "3B8F80018091E1318065B0831100AC83009000B7", "TOP DM GX4 Cards [TOP DM GX4 - contact interface]\nGemCombiXpresso R4 72K (contactless interface)" },
    { "3B8F80018091E1318065B0831111AC83009000A6", "TOP DM GX4 Cards [TOP DM GX4 on Omnikey]\nGEMALTO WM GX4 72 DHS TSA (contactless interface)" },
    { "3B8F80018091E1318065B0831111E583009000EF", "TOP DL V2 Cards" },
    { "3B8F80018091E1318065B0831117E583009000E9", "IDPrime PIV Card v2.0 AES SCP03 (eID)\nhttp://www.gemalto.com/products/piv_card/product_brief.html" },
    { "3B8F80018091E1318065B0850200CF83009000C1", "Gemalto IDCore 3010 CC (JavaCard)\nhttp://www.gemalto.com/Products/top_javacard/index.html\nMultiApp ID Dual Citizen EAC 80K CC / IDClassic 3340 (old name: Classic TPC DM) (with IAS Applet V3) - Contactless Mode" },
    { "3B8F80018091E1318065B0850200E983009000E7", "MultiApp ID Dual Citizen EAC 144K CC (with IAS Applet V3) -Contactless Mode" },
    { "3B8F80018091E1319865B0850300EF739441C08D", "Italian Passport (passport)\nhttps://www.passaportonline.poliziadistato.it/" },
    { "3B8F80018091E1319865B0850300EF739441FFB2", "Italian Passport (passport)" },
    { "3B8F80018091E131D865B28C01000773C441E05C", "Portuguese epassport (passport)" },
    { "3B8F800186844354444E409F3EC40D682804007D", "Access card to the underground network of guangzhou (Transport)" },
    { "3B8F8001FF43727970746E6F784649444F3230C2", "Fast Identification Online card (FIDO2) from Cryptnox manufacturer  (Other)\nhttps://www.cryptnox.ch" },
    { "3B8F8001FF43727970746E6F78464944FFFFFF70", "CRYPTNOX FIDO2 CARD (Other)\nhttp://www.cryptnox.ch" },
    { "3B90160187", "BIFIT USB-Token iBank2key" },
    { "3B90180189", "IIT E.Key Almaz-1C 00 00 (Other)\nhttps://iit.com.ua/" },
    { "3B90958011FE6A", "JC30M48CR JavaCard  (JavaCard)" },
    { "3B9095801FC359", "Dai Nippon Printing Co., DNP Standard-J T3.1" },
    { "3B90968111FE68", "Xirka (eID)" },
    { "3B9194801F0323BA", "China black(COS) SIM, does not support clock stop" },
    { "3B931100003200", "01-3936b2013 (Pay TV)\nhttp://www.lripl.com" },
    { "3B941881B1807D1F0319C80050DC", "GoldKey Security PIV Token" },
    { "3B9495810146545601C4", "blank J3H145 card (Other)" },
    { "3B95..40FF620101....", "Schlumberger Cryptoflex e-gate" },
    { "3B951381018073FF01000B", "vsmartcard - iso7816 (Other)\nhttps://frankmorgner.github.io/vsmartcard/" },
    { "3B951540..680102....", "Schlumberger CryptoFlex 8k v2" },
    { "3B951540FF6301010000", "Cryptoflex 16K" },
    { "3B951840FF6201020104", "Schlumberger Cryptoflex 32K e-gate" },
    { "3B951840FF6204010105", "Schlumberger CryptoFlex 32Ko V1" },
    { "3B951840FF6402010102", "Schlumberger CryptoFlex 32Ko" },
    { "3B959440FF6301010201", "Schlumberger Cryptoflex 16Ko" },
    { "3B959540FFAE01010203", "Axalto Cyberflex Access 64K v2a SM 2.3" },
    { "3B959540FFAE01030000", "Axalto - Cyberflex Access v2c 64K\nGemalto TOP IM FIPS CY2 (product code HWP115291A)" },
    { "3B959540FFD0001A0101", "Cyberflex Access 64k (v3)" },
    { "3B959540FFD000310101", "Cyberflex Access E-gate V3" },
    { "3B959540FFD000520102", "CHIFA (Child Healthcare Information For All?) (HealthCare)" },
    { "3B959540FFD00054013.", "Portuguese identity card\nhttp://www.cartaodecidadao.pt" },
    { "3B95958011FE544143484F3E", "Russian Federation driver card for the digital tachograph (Other)" },
    { "3B9596007064434F53", "Ticket Restaurant Card  (Other)\nhttp://www.edenred.it/buoni-pasto-welfare-benefit/ticket-restaurant-card/#soluzione" },
    { "3B959640F001130A0A1D", "xcrypt (Pay TV)" },
    { "3B959640F00F100A096A", "Zain Usim Card (Telecommunication)\nwww.qariya.com" },
    { "3B959680B1FE551FC7477261636513", "IClass SE Processor (Other)\nhttps://www.hidglobal.com/products/embedded-modules/iclass-se/sio-processor" },
    { "3B9596C0F01FC20F100A0A16", "viettel (Telecommunication)" },
    { "3B961880018051006110309F006110309E", "Atmel/Athena T0 PC/SC Compliance Test Card No. 1 (warm reset)" },
    { "3B9695801FC3D007830254005D", "au IC-card ver.001 (for CDMA2000) (Telecommunication)\nhttps://ja.wikipedia.org/wiki/Au_IC%E3%82%AB%E3%83%BC%E3%83%89" },
    { "3B9711801F418031A073BE2100A6", "Comprion UT3 simulator SIM (Other)" },
    { "3B9711801F428031A073BE2100A6", "ETSI 102 230 Test case 5.2.5.3. Comprion IT3 SIM emulator (Telecommunication)" },
    { "3B9711C0FFB1FE351F83A505010102A3015F", "digital chronotachygraphe card: conducteur/driver, entreprise, controleur/controler et atelier/workshop, 2006-2010\nmanufactured by Imprimerie Nationale, distributed by Chronoservices" },
    { "3B9713C0FFB1FE351F83A505010102A3015D", "digital chronotachygraphe card: conducteur/driver, entreprise, controleur/controler et atelier/workshop, 2005-2006\nmanufactured by Imprimerie Nationale, distributed by Chronoservices" },
    { "3B9794801F438031E073FE211B39", "Telenor SIM card (Hungary) (Telecommunication)\nhttps://www.telenor.hu" },
    { "3B9794803F44908031A073BE210095", "Comprion Simulated card that indicate Low Impedance support: TB(3) = 0x90 (Telecommunication)" },
    { "3B9795801F438031E073FE211B38", "JIO (Telecommunication)" },
    { "3B9795801F478031E073FE211B3C", "iFree MOGO SIM Card  for test  (Telecommunication)" },
    { "3B9795801FC78031A073B6211BB4", "DNP Local5G (Telecommunication)" },
    { "3B9795C02A31FE35D000480105A3113C", "digital chronotachygraphe card: conducteur/driver, entreprise, controleur/controler et atelier/workshop, 2010-2015\nmanufactured by Imprimerie Nationale, distributed by Chronoservices" },
    { "3B9811000205013242030500", "Sino 3G Nano-sim ordered off Alie Express (Telecommunication)\nhttp://goo.gl/rSEi4N" },
    { "3B9813400AA503010101AD1311", "Belgium Electronic ID card (eID)" },
    { "3B981801524D4D2076312E32A8", "Ericsson Mini-Link RYS 110 243/1 (Other)" },
    { "3B98188131FE433041565400000007F9", "Avtor SecureToken 00 00 (Other)" },
    { "3B98188131FE453541565400000020DD", "Avtor Secure Token (eID)\nhttps://avtor.ua/" },
    { "3B9830400AA503010101AD1311", "Belgium Electronic eID card (eID)" },
    { "3B989400939114010A060606", "Orange Spain 64k Sim card" },
    { "3B9894009391150104030303", "old orange sim (Telecommunication)\nhttps://orange.ro" },
    { "3B9894400AA503010101AD1310", "Belgium Electronic ID card (eID)" },
    { "3B9894801FC2322E31303114014028", "CMCC operator UICC (Telecommunication)" },
    { "3B9894801FC38031E073FE211B08BE", "XLB EVDO Test Card (Telecommunication)" },
    { "3B9895009394040403030303", "T-Mobile MVNO SIM card" },
    { "3B989540FFD000480101AD1321", "Belgium Electronic ID card (eID) - virtual test card\nhttps://env.dev.eid.belgium.be/prepcard.php" },
    { "3B9896004B415A544F4B454E", "Kaztoken SC" },
    { "3B9896008031C072F7418107", "Aktiv Rutoken Magistra" },
    { "3B9896009394030703040404", "SIM card\nGSM SIM of VIP CRoatian mobile company" },
    { "3B9896009394030805030303", "SIMple Mobile SIM Card\nhttp://www.simplemobile.com" },
    { "3B9896009394030903020202", "MySims2Go GSM SIM Card (Telecommunication)\nhttp://www.mysims2go.com" },
    { "3B9896009394040204050505", "Roshan (Afgan Wireless ) SIM (Telecommunication)" },
    { "3B991800118822334455667760", "sysmocom sysmoSIM-GR1" },
    { "3B999400910891060001060600", "GSM-SIM Orange-UK (1800)" },
    { "3B999400911691080001250100", "GSM SIM E-plus, Germany (Telecommunication)" },
    { "3B999400919993120001160200", "ORGA test systems - GSM Phase 2+ Test SIM" },
    { "3B9A180082627593110001020200", "Supersim 6 in 1 (Telecommunication)" },
    { "3B9A18801FC731425243442E312E3538C0", "HP StorageWorks (Other)\nhttps://hpe.com" },
    { "3B9A940091010017000123100096", "GSM-SIM Victorvox D1 (900MHz)" },
    { "3B9A940091010017000123110096", "GSM-SIM Card T-D1 (900MHz)" },
    { "3B9A940091010017000126050096", "GSM-SIM T-D1 prepaid (Xtra) (Telecommunication)" },
    { "3B9A940091010017000126060096", "T D1 GSM card" },
    { "3B9A9400920275931100010202..", "SuperSIM (X-sim)" },
    { "3B9A960092013693170002040300", "GSM-SIM EMT 'Simpel' (prepaid, Estonia)\nhttps://www.emt.ee/web/simpel" },
    { "3B9A960092014893170002120400", "SIM Card C*******r Mobile (Belgium)" },
    { "3B9A960092016693170002120400", "GSM SIM Bite.lv prepaid 'Toxic'; 2008" },
    { "3B9A960092019893170002280200", "Hardware USB Key (Other)" },
    { "3B9A960092027193160001070100", "SIM card (emitted in ~2007) of Ukrainian Telecommunications Operator Kyivstar (Kyivstar GSM) (GSM/UMTS services) (Telecommunication)\nhttp://www.kyivstar.ua" },
    { "3B9A960092034993160001210100", "GSM-SIM card of the Austrian provider Yesss!\nhttp://www.yesss.at" },
    { "3B9A9601F156504E2D4B45590000CE", "Amicon Remote Admin (Other)" },
    { "3B9A96401E41505443402950778501", "Java card Version 2.2.2 S3FS9FX series Java card  (eID)" },
    { "3B9A96C01031FE5D0064057B01023180900076", "EU smart tachograph card (driver/company/control/workshop)\nhttps://dtc.jrc.ec.europa.eu/" },
    { "3B9B95801F438031A073BE21005334500119", "True Move GSM UICC (Telecommunication)" },
    { "3B9B95801F478031A073BE2100532711024C", "SIM TELE2 Sweden" },
    { "3B9B95801F478031A073BE210053349905D0", "GSM-SIM EMT 'Diil', prepaid (Estonia)" },
    { "3B9B96C00A31FE4580670567B6040100008105FF", "Business Card (eID)" },
    { "3B9B97C00A31FE4580670567B6040100008105FE", "Company Card for Tachograph Data (Transport)" },
    { "3B9C131181647265616D6372797074000408", "XPlusTV & INXCT Access Card-9 (FIRECrypt)" },
    { "3B9C131181647265616D6372797074900599", "FireCrypt, access card 9 (Pay TV)" },
    { "3B9C940068868D0A86980256C2000500", "G3 & GSM & Blank SIM card: to be programmed for OpenBTS with pySim-prog (Telecommunication)" },
    { "3B9C940068868D0C86980245A1000500", "China Mobile (Telecommunication)" },
    { "3B9C940068868D0C86980256408B0500", "mobiledit (Telecommunication)" },
    { "3B9C948011405275746F6B656E4543507363C3", "Aktiv Rutoken ECP SC T1\nhttps://www.rutoken.ru/products/all/rutoken-ecp-sc/" },
    { "3B9C94801F478031E073FE211B5450845450B2", "cambodia (Telecommunication)\nhttps://www.smart.com.kh/" },
    { "3B9C94801F478031E073FE211B54538974509C", "China Unicom 128K M2M Card (Telecommunication)" },
    { "3B9C94801F478031E073FE211B545983795091", "Vodafone Ukraine (Telecommunication)" },
    { "3B9C95801FC78031E073FE211B6457444946CF", "MTC (Moscow) phone SIM card (Telecommunication)\nhttps://moskva.mts.ru/personal" },
    { "3B9C9580811F039067464A01005404F272FE00C0", "Feitian Technologies Java Card A22CR (JavaCard)\nhttps://www.javacardos.com/store/javacard-a22cr.php" },
    { "3B9C9580811F039067464A01011706F2727E0000", "A40CR (JavaCard)" },
    { "3B9C96005275746F6B656E4543507363", "Aktiv Rutoken ECP SC T0\nhttps://www.rutoken.ru/products/all/rutoken-ecp-sc/" },
    { "3B9C960058442403020020010A009005", "Ticket Restaurant Card (Other)\nhttp://www.edenred.it/buoni-pasto-welfare-benefit/ticket-restaurant-card/" },
    { "3B9C978011405275746F6B656E4543507363C0", "Aktiv Rutoken ECP 3.0 NFC (PKI)\nhttps://www.rutoken.ru/products/all/rutoken-ecp-nfc/" },
    { "3B9D114023006810114D696F434F53009000", "MioCOS 1.0" },
    { "3B9D13813160378031C0694D54434F537302020440", "DPI Card Guatemala (eID)\nhttp://www.masktech.de/" },
    { "3B9D13813160378031C0694D54434F537302020541", "MTCOS  (eID)\nhttp://www.masktech.com/Products/MTCOS-Professional/11/en" },
    { "3B9D944023006820014D696F434F53009000", "Miotec smartcard running Miocos 2.0 on an Atmel AT90SC646\nhttp://www.miotec.fi" },
    { "3B9D95801FC38031E0524B5462110373FE211B8F", "KT WiBro UICC (2.3 GHz mobile WiMAX in South Korea)" },
    { "3B9D95801FC38031E073FE211B65D00057026230", "Gemalto NFC enabled (acquired through the Simagine contest)" },
    { "3B9D95801FC38063AF03A0731A211B830F9000F4", "Greece TIM GSM SIM" },
    { "3B9D95801FC380731A211B63AF06A6830F9000F7", "Travelsim GSM SIM Card (Telecommunication)\nhttp://www.travelsim.com" },
    { "3B9D95801FC380731A211B63AF07A7830F9000F7", "GemXplore 3G" },
    { "3B9D95801FC380731A211B63AF07B7830F9000E7", "Tchibo (Telefonica) SIM-Card (JavaCard)" },
    { "3B9D95801FC78031A073BE2100510483059000EE", "SIM :NTT Docomo(Japan) (Telecommunication)" },
    { "3B9D95801FC780731A211B63AF06A6830F9000F3", "Orange UK GSM/UMTS SIM" },
    { "3B9D95801FC780731A211B63AF09A9830F9000F3", "Estonian GSM operator TELE2 (WPKI eID support)" },
    { "3B9D95803FC7A08031A073BE21135105830590007C", "NTT docomo Xi(LTE) DN05(DNP) Pink SIM (Telecommunication)" },
    { "3B9E94801F4280310073BE211066545953044C25CF", "MCI (Mobile Communication Company of Iran) SIM" },
    { "3B9E94801F478031A073BE21136686880210421014", "Airspan USIM (Telecommunication)" },
    { "3B9E94801F478031A073BE21136686880210731025", "module (JavaCard)" },
    { "3B9E94801F478031E073BE211366868882183942F5", "China Unicom 128K Mini USIM (Telecommunication)" },
    { "3B9E94801FC38031E073FE211B66D00017B40000A5", "Vodafone Ireland SIM card" },
    { "3B9E94801FC78031E073FE211366425454423031DB", "XLB.5G CTC Test Card (Telecommunication)\nhttps://xielibo.com" },
    { "3B9E94801FC78031E073FE211B66D0006C025F0033", "Vivo Brasil SIM Card" },
    { "3B9E94801FC78031E073FE211B66D0006C0634005C", "SIM card SFR 250 128ko" },
    { "3B9E94801FC78031E073FE211B66D0007A00000078", "GaduAIR (Poland) - Subscriber Identity Module (SIM)" },
    { "3B9E94801FC78031E073FE211B66D0016DE80C008A", "Mobile TeleSystems (MTS) GSM SIM\nhttp://www.mts.ru/" },
    { "3B9E94801FC78031E073FE211B66D001A18D0F0020", "StarHub Happy Prepaid SIM (Telecommunication)\nhttp://www.starhub.com/personal/mobile/mobile-phones-plans/prepaid-cards.html" },
    { "3B9E94801FC78031E073FE211B66D00217F71300F3", "VIETTEL Telecom 4G SIM 128KB (Vietnam) (Telecommunication)\nhttp://vietteltelecom.vn/" },
    { "3B9E94801FC78031E073FE211B66D002195C130056", "SIM Card of the French mobile carrier 'La Poste Mobile' (Telecommunication)" },
    { "3B9E94801FC78031E073FE211B66D0022424140014", "Citymesh Connect (Telecommunication)\nhttps://citymesh.com/en/solutions/citymesh-connect" },
    { "3B9E95801FC38031A073BE2113672902010404CD39", "H3G (?) UMTS USIM card\nJ+ SWIM WIB UMTS SIM Test card\nhttp://www.exceldata.es/microprocess/j%2Bswinwibusim.html" },
    { "3B9E95801FC38031E073FE211B66D00029B6010099", "GSM SIM (Telecommunication)" },
    { "3B9E95801FC38031E073FE211B66D00029F40100DB", "Vodafone (UK) Pay As You Talk SIM" },
    { "3B9E95801FC38031E073FE211B66D000490000004E", "UK O2 Unlimited Prepay GSM/UMTS USIM" },
    { "3B9E95801FC3804B434F5320566572012E0190001C", "Vehicular License Veracruz, Mexico (Transport)" },
    { "3B9E95801FC68031E073FE211B66D0019FBD100031", "H3G (Three UK) Prepaid USIM (Telecommunication)" },
    { "3B9E95801FC78031E073FE211B66D00007001E001A", "H3G (Ireland, UK) UMTS USIM card" },
    { "3B9E95801FC78031E073FE211B66D000261C010038", "GSM-SIM Telefonica Movistar, contract (Spain)\nhttp://www.movistar.es/" },
    { "3B9E95801FC78031E073FE211B66D00028C40000EF", "H3G (Italy) UMTS USIM card" },
    { "3B9E95801FC78031E073FE211B66D000490000004A", "Rogers 3G SIM card" },
    { "3B9E95801FC78031E073FE211B66D0004900C0004A", "Rogers SIM card" },
    { "3B9E95801FC78031E073FE211B66D0006C091A007C", "AT&T UICC with USIM (Telecommunication)" },
    { "3B9E95801FC78031E073FE211B66D0007502050071", "SIM card, provided by brasilian operator 'claro' (Telecommunication)" },
    { "3B9E95801FC78031E073FE211B66D0007A00000079", "Simyo SIM Card, Spanish Mobile Company\nHi SIM" },
    { "3B9E95801FC78031E073FE211B66D00081C80D0047", "ESEYE ES4520 Anynet MFF Embedded SIM" },
    { "3B9E95801FC78031E073FE211B66D0016B750E0012", "Oskarta Vodafone (Czech Republic) 128kB GSM LTE SIM (Telecommunication)\nhttps://www.oskarta.cz/" },
    { "3B9E95801FC78031E073FE211B66D0016C040D0067", "3G Yoigo SIM Card from Spain" },
    { "3B9E95801FC78031E073FE211B66D0016C390D005A", "Andrews & Arnold (A&A) 3G mobile data SIM - using the 'Three' network in the UK (Telecommunication)\nhttp://www.aa.net.uk/telecoms-mobile-data.html" },
    { "3B9E95801FC78031E073FE211B66D0016CC10D00A2", "Three Hong Kong Prepaid SIM Card (Telecommunication)\nhttp://www.three.com.hk/website/appmanager/three/home?_nfpb=true&_pageLabel=P200470391219567710594&pageid=631001&lang=eng" },
    { "3B9E95801FC78031E073FE211B66D0016D850E00E4", "Vodafone Germany SIM Card (Telecommunication)" },
    { "3B9E95801FC78031E073FE211B66D001790E6B001E", "TracFone (US) TF64SIMC4 V2 GSM SIM Card" },
    { "3B9E95801FC78031E073FE211B66D0017A0650002E", "AT&T UICC with USIM (Telecommunication)" },
    { "3B9E95801FC78031E073FE211B66D0017A0E3E0048", "TracFone (US) TF64PSIMC4 GSM SIM Card" },
    { "3B9E95801FC78031E073FE211B66D0017B980D00EC", "Mobile Vicking SIM card (Telecommunication)\nhttps://vikingco.com/fr/mobile-vikings/" },
    { "3B9E95801FC78031E073FE211B66D0017BEB0D009F", "TRE (Telecommunication)\nhttp://www.tre.se" },
    { "3B9E95801FC78031E073FE211B66D00199291000A2", "Simyo-Mobile Belgium GSM SIM card" },
    { "3B9E95801FC78031E073FE211B66D001997F0F00EB", "sim card RUS Megafon Krasnodar (Telecommunication)" },
    { "3B9E95801FC78031E073FE211B66D001A0741000C6", "vodafone italy sim (Telecommunication)" },
    { "3B9E95801FC78031E073FE211B66D001A0C3120073", "3G MTN IRANCELL Sim Card. (Telecommunication)" },
    { "3B9E95801FC78031E073FE211B66D001A1141100A6", "Globe (Telecommunication)" },
    { "3B9E95801FC78031E073FE211B66D001A1721000C1", "Vodafone Hungary SIM Card (Telecommunication)\nhttp://vodafone.hu" },
    { "3B9E95801FC78031E073FE211B66D001A18C12003D", "Telkomsel SIM card (Telecommunication)\nhttps://www.telkomsel.com/en/kartu-as" },
    { "3B9E95801FC78031E073FE211B66D001A1B810000B", "abc mobile prepaid sim card (serviced by CSL) (Telecommunication)\nhttps://www.hkcsl.com/en/abc-Mobile-Prepaid-SIM-Cards/" },
    { "3B9E95801FC78031E073FE211B66D0021702130007", "AT&T prepaid nano iphone/android sim card  (Telecommunication)" },
    { "3B9E95801FC78031E073FE211B66D002173E12003A", "USIM issued by Unite mobile operator in Moldova (Telecommunication)\nhttps://en.wikipedia.org/wiki/Unit%C3%A9" },
    { "3B9E95801FC78031E073FE211B66D0021766130063", "Three UK USIM card (Telecommunication)" },
    { "3B9E95801FC78031E073FE211B66D0021786120082", "Singtel Hi! Tourist SIM Card (Telecommunication)\nhttps://www.singtel.com/personal/i/phones-plans/mobile/prepaid/hitouristsimcards" },
    { "3B9E95801FC78031E073FE211B66D002178B12008F", "Ufone (SIM Card) (Telecommunication)\nhttps://ufone.com/Consumer-Manual/668-SIM-Information-System/" },
    { "3B9E95801FC78031E073FE211B66D00217C71100C0", "3 UK SIM card (Telecommunication)" },
    { "3B9E95801FC78031E073FE211B66D00217F61100F1", "Ziggo SmartCard Television Subscription (Pay TV)" },
    { "3B9E95801FC78031E073FE211B66D00219151300", "ABS-CBN (Telecommunication)" },
    { "3B9E95C00A1FC68031E073FE211B66D001830D58811E", "Mobile Paypass G199 NFC" },
    { "3B9E96008031C0654D4700000072F7418107", "Russian Magistra (UTF8: Magistra) smart card (eID)\nhttp://www.smart-park.ru/index.php/products/smartcards.html" },
    { "3B9E96008031C0654D5300000072F7418107", "Smart-key for bank-client of MDM Bank (RU) with faktura.ru service (Bank)" },
    { "3B9E96800141054100000000000000000090001C", "ACOS5-64 v3.00 is a FIPS 140-2 Level 3 Certified Cryptographic Smart Card which is fully compliant with ISO7816-1/2/3/4/8/9 and common criteria EAL5+ (chip level) specifications. (PKI)\nhttps://www.acs.com.hk/en/products/308/acos5-64-v3.00-cryptographic-card-contact/\nACOS5 EVO V4.10" },
    { "3B9E96800141054200000000000000000090001F", "ACOS5 EVO 192KB PKI combined (PKI)" },
    { "3B9E96800141054300000000000000000090001E", "ACS CryptoMate EVO PKI token (PKI)\nhttps://www.acs.com.hk/en/products/494/cryptomate-evo-cryptographic-usb-tokens/" },
    { "3B9E96801F478031A073BE211366868802101D1049", "Maroc Telecom USIM" },
    { "3B9E96801F838031E073FE21126655574E41323391", "TDC mobile UICC (Telecommunication)" },
    { "3B9E96801FC38031E073FE211B66D0016C040D0060", "toggle GSM SIM\nhttp://www.togglemobile.co.uk" },
    { "3B9E96801FC38031E073FE211B66D0017B980D00EB", "Lycamobile Pay As You Go SIM" },
    { "3B9E96801FC68031E073FE211B66D0019F134D00C1", "Telus Mobility Tri-SIM card (Telecommunication)\nhttps://www.telus.com/en/mobility/sim-cards" },
    { "3B9E96801FC68031E073FE211B66D0019F691100E7", "Oister 3G SIM Card (Telecommunication)\nhttps://www.oister.dk/" },
    { "3B9E96801FC68031E073FE211B66D0019F8F110001", "Spark New Zealand SIM Card  (Telecommunication)\nhttp://spark.co.nz" },
    { "3B9E96801FC68031E073FE211B66D0019F8F120002", "Russian 'Megafon' gsm sim card (Telecommunication)\nhttp://www.megafon.ru/" },
    { "3B9E96801FC68031E073FE211B66D0019FBC100033", "sim beeline russia krasnodar (Telecommunication)" },
    { "3B9E96801FC68031E073FE211B66D0019FEF100060", "Infineon SLU14MCO480K2 (JavaCard)" },
    { "3B9E96801FC78031E073FE21136200498381900007", "Claro Brazil SIM card (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D000282401000D", "United Mobile SIM" },
    { "3B9E96801FC78031E073FE211B66D0002B2D020004", "KTF SHOW GE-B1400 WCDMA USIM (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D0006C0C720012", "Orange Austria GSM/3G SIM: 'Mobiles Internet'" },
    { "3B9E96801FC78031E073FE211B66D0006C0D7A001B", "Vodafone UK GSM SIM Card (Telecommunication)\nhttp://www.vodafone.co.uk" },
    { "3B9E96801FC78031E073FE211B66D000717B020008", "Bouygues Telecom (French Mobile Provider SIM card) (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D0013800000039", "SIM card (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D0016B230E0047", "Vodafone Ireland SIM (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D0016C040D0064", "Cincinati Bell. UICC with USIM 128k-b (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D0016C390D0059", "SIM card from Austrian ISP 'Drei' (H3G) (Other)" },
    { "3B9E96801FC78031E073FE211B66D0016CC10D00A1", "3 (Italian telecommunication provider) 3g sim card 2FF format H3G Italy" },
    { "3B9E96801FC78031E073FE211B66D0016CCF0D00AF", "TLC Sim Card (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D0016D0C0E006E", "SimpleMobile Sim Card (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D0016FF90D009A", "T-Mobile US SIM card (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D00177490D0032", "UK simcard - O2 unlimited prepay 3G (4DM) USIM (EXT)" },
    { "3B9E96801FC78031E073FE211B66D00177600E0018", "Walmart Family Mobile (T-Mobile) West Coast (Telecommunication)\nT-Mobile US USIM 'TM9190' v50.05 (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D001777B0E0003", "Bouygues Telecom SIM - 3G (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D00177970D00", "SIM Free Mobile" },
    { "3B9E96801FC78031E073FE211B66D00177970D00EC", "SIM Free Mobile" },
    { "3B9E96801FC78031E073FE211B66D0017A490D003F", "SUPER start package (Estonia, EMT, 4G) (Telecommunication)\nhttps://www.super.ee/en/" },
    { "3B9E96801FC78031E073FE211B66D0017A7C0D000A", "Orange SIM (Telecommunication)\nhttp://www.orange.es" },
    { "3B9E96801FC78031E073FE211B66D0017B3E0E004A", "SIM card from lapostemobile in France (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D0017B5C0E0028", "SIM card by German mobile phone provider E-Plus for Product 'WhatsApp SIM' (Telecommunication)\nhttps://www.eplus.de/whatsapp" },
    { "3B9E96801FC78031E073FE211B66D0017BAF0D00D8", "Chunghwa Telecom SIM card (Telecommunication)\nhttp://www.cht.com.tw/en/personal/pops.html" },
    { "3B9E96801FC78031E073FE211B66D0017BEB0D009C", "3 prepaid mobile phone card (Other)\nhttps://drei.at/" },
    { "3B9E96801FC78031E073FE211B66D00185870E000D", "Fido USIM Card (Telecommunication)\nhttp://fido.ca" },
    { "3B9E96801FC78031E073FE211B66D00185C40F004F", "T-Mobile USA (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D0018D5F1000C3", "eUICC for Gemalto (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D0018D791200E7", "Verizon Rugged M2M SIM (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D00191880E0016", "Lenovo SIM card (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D00199C80F005F", "OneSimCard (Telecommunication)\nhttp://www.onesimcard.com/" },
    { "3B9E96801FC78031E073FE211B66D00199FE0E0068", "Finnish Sonera SIM-card (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D001A0041100B4", "Aldi Talk SIM card, Germany (Telecommunication)\nhttps://www.alditalk.de/talk" },
    { "3B9E96801FC78031E073FE211B66D001A01E1100AE", "Zevvle SIM Card (Telecommunication)\nhttps://zevvle.com" },
    { "3B9E96801FC78031E073FE211B66D001A0DD12006E", "USIM (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D001A0EC11005C", "Boost Mobile Prepaid Micro SIM Card (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D001A1121000A2", "OpenAirInerface (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D001A1581100E9", "Vodafone CZ: SIMPLUS V128 LTE (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D001A1680F00C7", "Free Mobile SIM card (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D001A1721000C2", "Vodafone (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D001A1731000C3", "Prepaid public telephone card from Lidl Connect, Germany (Telecommunication)\nhttps://www.lidl.de/de/lidl-connect/s7373597" },
    { "3B9E96801FC78031E073FE211B66D001A1A70F0008", "Spanish Movistar Mobile phone SIM card (Telecommunication)\nhttp://www.movistar.es/" },
    { "3B9E96801FC78031E073FE211B66D001A1E60F0049", "SIM O2 CZ (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D0021759140058", "USIM card of of Ukrainian Telecommunications Operator Kyivstar, emitted after 2016 (Kyivstar GSM) (GSM/UMTS/LTE services) (Telecommunication) (Telecommunication)\nhttps://kyivstar.ua/uk/4g" },
    { "3B9E96801FC78031E073FE211B66D002175B12005C", "Cellcom Israel USIM (micro FF) (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D0021760130066", "Vodafone spain barcelona (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D0021762120065", "Free Mobile (Telecommunication)\nhttp://mobile.free.fr" },
    { "3B9E96801FC78031E073FE211B66D00217A01200A7", "USIM Card (Etisalat) (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D00217BF1100BB", "Telkom (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D00217C91100CD", "Vivo 4G (Other)" },
    { "3B9E96801FC78031E073FE211B66D00217CD1100C9", "O2 4G SIM card (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D00217D91200DE", "telenor (swedish mobile provider) SIM card (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D00217F41200F3", "SIM card for Swedish operator Vimla! (Telecommunication)\nhttps://www.vimla.se" },
    { "3B9E96801FC78031E073FE211B66D002194B120042", "halebop (swedish mobile provider) SIM card (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D0022A72130049", "SIM Card OI (Brazil) (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D0022A861300BD", "Mobile Vikings SIM Card (Telecommunication)\nhttps://mobilevikings.com" },
    { "3B9E96801FC78031E073FE211B66D0022AD31300E8", "sim card from Mobilcom Debitel Telefonica (Telecommunication)\nhttps://md.de" },
    { "3B9E96801FC78031E073FE211B66D0022AD91300E2", "sim (Telecommunication)" },
    { "3B9E96801FC78031E073FE211B66D00233AD140088", "4G-LTE (Telecommunication)" },
    { "3B9E96803FC3A08031E073FE211B630801140F9000D3", "KT Olleh LTE Warp SA-L 1670 (Telecommunication)" },
    { "3B9E97801FC78031E073FE211B66D0006B951100EE", "TracFone SIM Verizon Wireless LTE supported (Telecommunication)\nhttps://www.tracfone.com" },
    { "3B9E97801FC78031E073FE211B66D0022AB3130089", "SIM T-MObile (Telecommunication)" },
    { "3B9F..801FC300681.4405014649534531C8..9000..", "Setec SetCOS 4.4.1" },
    { "3B9F1110804154393853433033324354312E3535", "'ID Vault' brand device  (Other)\nhttp://www.idvault.com/index.html" },
    { "3B9F1110805661756C74494320343630312E3032", "Inside Secure VaultIC 460 Smart Object [ICCD 1.00] (Other)\nhttp://www.insidesecure.com/Products-Technologies/Secure-Solutions/VaultIC460" },
    { "3B9F11406049524445544F204143532056352E30", "'La7 Cartapiu' for DVB-T decoders, IRDETO access" },
    { "3B9F11406049524445544F204143532056352E37", "dahlia Tv Italian Provider" },
    { "3B9F11406049524445544F204143532056352E38", "Videocon D2H (Pay TV)" },
    { "3B9F11406049524445544F204143532056352E3800", "irdeto (Pay TV)\nVTC card (Pay TV)" },
    { "3B9F11406049524445544F204143532056362E30", "skylink, Pay TV\nhttp://www.skylink.cz\nT-Mobile Czech Republic, Irdeto Satellite TV encryption card" },
    { "3B9F11801FC38031E073FE211B640753630182900074", "Cingular SIM" },
    { "3B9F11801FC78031E073FE211B63E206A6830F90000D", "i-SmartSim GSM phone SIM-lock bypass card\nhttp://i-smartsim.com/component/portfolio/7-unlock-sim/7-universal-unlock-sim-f300gold" },
    { "3B9F11803FC7A08031E073FE211F63006C008381900029", "Verizon Wireless 4G LTE SIM (Telecommunication)" },
    { "3B9F1181113D00067577810280000000000000000024", "Key knob used to grant access to 'spaces' offices (coworking). (Other)" },
    { "3B9F1181113D000A788070022063CBB780000000001C", "French VISA card 'Boursorama Premier' with contactless logo. The back has a mention of OT, probably Oberthur. (Bank)" },
    { "3B9F1181113D001378F70000000000000000000000BF", "French driver's license (2015) (Other)" },
    { "3B9F1181113D01502678D364000000000071816C0007", "Navigo (Transportation in Paris) (Transport)\nhttp://www.navigo.fr/" },
    { "3B9F1181113D1005BD255000000000000000000000FE", "Key Knob from a chinese electronic kit (described as 'blank s50', probably mifare) (Other)" },
    { "3B9F1181113D108E79BF9400000000000000000000EF", "Visitor card at 'Cartes Secure Connexions' 2015 event (Other)" },
    { "3B9F1181113D10C691B16500000000000000000000B0", "Blank card from a chinese electronic kit (described as 'blank s50', probably mifare) (Other)" },
    { "3B9F1181113D10FD546B7D000000000000000000008C", "Electronic Identity  (eID)" },
    { "3B9F1181113D12042CDBA2983C810000000000000045", "business card from a chinese manufacturer ('Realmart') commercial. (Other)" },
    { "3B9F118131FE9F006A6D546F6B656E2D46000081900079", "USB Token mToken CryptoID by Longmai (JavaCard)\nhttp://www.longmai.net/products/mtoken/" },
    { "3B9F118131FE9F006A6D546F6B656E2D5000058190006A", "Longmai mToken CryptoIDA Reader (PKI)" },
    { "3B9F118131FE9F006B42495434494420332E30009000CF", "bit4id TokenMe (eID)" },
    { "3B9F11C00A1FC78031E073FE211B63F100AD830F900059", "GemXplore Generation 3G" },
    { "3B9F138131FE45806755454B41451261318073B3A1801C", "UKiS 1.2.1 on YITAL chip" },
    { "3B9F138131FE45806755454B41451264318073B3A18019", "UKiS 1.2.1 on HNEC chip" },
    { "3B9F138131FE45806755454B41451265318073B3A18018", "UKiS 1.2.1 on SMIC chip" },
    { "3B9F1381B180371F038031F8694D54434F5370020102810786", "Swiss Health Insurance Card" },
    { "3B9F158131FE45806755454B41451221318073B3A1805A", "AKIS (eID)" },
    { "3B9F210E49524445544F20414353038395008055", "Nagravision Betacrypt" },
    { "3B9F210E49524445544F204143530384556DFF80", "Nagravision Betacrypt" },
    { "3B9F210E49524445544F20414353038455FF806D", "TV smart card Sky Germany BEtacrypt 1702\nhttp://providers.wikidot.com/sky-deutschland" },
    { "3B9F210E49524445544F204143532056312E32A0", "Irdeto ACS V1.2 Pay-TV smartcard (Pay TV)" },
    { "3B9F210E49524445544F204143532056342E319D", "Foxtel paytv decoder in Australia acs 4.1 Irdeto2" },
    { "3B9F210E49524445544F204143532056352E309D", "Irdeto ACS 5.0 One (Pay TV)" },
    { "3B9F210E49524445544F204143532056352E339E", "red dragoncard chid 0604- Austar provider (pay tv)" },
    { "3B9F210E49524445544F204143532056352E3499", "Nova Greece package on satellite 13E Hotbird" },
    { "3B9F210E49524445544F204143532056352E379A", "irdeto2 www.digiturk.com.tr (Pay TV)" },
    { "3B9F210E49524445544F204143532056362E309E", "irdeto (Other)" },
    { "3B9F210E49524445544F204143532056372E309F", "pay TV card of Irdeto. (Pay TV)" },
    { "3B9F92801FC38031E073FE21146302010183079000CD", "Programmable SIM card as one of the requirement for free5GC testing procedure (Telecommunication)" },
    { "3B9F94401E0067..4346495345105266FF81....", "SLE66CX160S running SETCOS 4.3.1 Revision A" },
    { "3B9F94401E0067114346495345105266FF819000", "Setec / FINEID\nSETEC Instant EID" },
    { "3B9F94401E0067164346495345105266FF819000", "RSA SecurID 3100 or Utimaco Safeware Smartcard\nSetCOS 4.3.1 Revision Unknown" },
    { "3B9F94801FC30068104405014649534531C807900018", "SetCOS 4.3.0 32K RSA\nInstant EID IP2\nSETEC SetCard 32K PKI Evaluated SetCOS 4.4.1a2" },
    { "3B9F94801FC38031A073B6A10067CF3251CC9E6EC015", "OYEITIMES 2G GSM  Blank SIM Card (Other)\nhttps://www.aliexpress.com/item/32972705510.html?spm=a2g0s.9042311.0.0.5a564c4daKCdcQ" },
    { "3B9F94801FC38031E073FE21136301030283079000CE", "Programmable SIM card as one of the requirement for free5GC testing procedure (Telecommunication)" },
    { "3B9F94801FC78031E073FE2100644090610082900069", "softsim (Telecommunication)" },
    { "3B9F94801FC78031E073FE21116307525183079000CC", "sim card RUS Beeline Krasnodar (Telecommunication)" },
    { "3B9F94801FC78031E073FE2111634072628307900098", "sim card RUS Beeline Krasnodar (Telecommunication)" },
    { "3B9F94801FC78031E073FE2111634082928307900098", "PrixTel (Telecommunication)" },
    { "3B9F94801FC78031E073FE21116341284183079000E0", "Mongolian MNO Skytel (Telecommunication)\nhttps://www.skytel.mn" },
    { "3B9F94801FC78031E073FE2111634C00908307900014", "Obertur Java 2.21 card (Telecommunication)" },
    { "3B9F94801FC78031E073FE21135712291102010000C3", "Sysmocom USIM-GR1 (Telecommunication)\nhttp://www.sysmocom.de/products/programmable-sysmousim-gr1-sim-card" },
    { "3B9F94801FC78031E073FE21135747440E01005501B2", "China Unicom 4G sim card (Telecommunication)" },
    { "3B9F94801FC78031E073FE211357474430010055018C", "China Unicom USIM Card (Telecommunication)" },
    { "3B9F94801FC78031E073FE21135749050C86986018CC", "China Unicom USIM 128K 6131H" },
    { "3B9F94801FC78031E073FE21135786810586984018AE", "China Unicom USIM Card (Telecommunication)" },
    { "3B9F94801FC78031E073FE211357868107869862188E", "OYEITIMES MCR3516 SIM Card (Telecommunication)" },
    { "3B9F94801FC78031E073FE21135786850686984218AB", "4G LTE blank USIM Green Card (Telecommunication)\nhttp://grcard.en.alibaba.com/product/60076835567-209365843/4G_LTE_blank_usim_card_for_4G_network.html" },
    { "3B9F94801FC78031E073FE21136321150683079000F8", "Maroc Telecom 4G+ (Telecommunication)" },
    { "3B9F94801FC78031E073FE21136761210D10000070F7", "Celcom XPAX (Telecommunication)\nhttps://www.celcom.com.my/personal/prepaid" },
    { "3B9F94801FC78031E073FE2119573C8660CFB902A0EE", "Gotanet SE USIM (Telecommunication)" },
    { "3B9F94801FC78031E073FE2119573C8660CFBA02A0ED", "Gotanet DK USIM (Telecommunication)" },
    { "3B9F94801FC78031E073FE211B573786609B3289B2A1", "China Unicom Travel SIM (Telecommunication)\nhttps://www.cuniq.com/hk/data-card/asia/asia-12days.html" },
    { "3B9F94801FC78031E073FE211B573786609BA182109B", "U Mobile POWER Prepaid (Telecommunication)\nhttp://www.u.com.my/prepaid" },
    { "3B9F94801FC78031E073FE211B573F86604D03000075", "Prepaid SIM card MOCHE (Portugal) (Telecommunication)" },
    { "3B9F94801FC78031E073FE211B573F866083020000BA", "GSM-SIM Beeline RU (Telecommunication)\nhttp://beeline.ru" },
    { "3B9F94801FC78031E073FE211B573F8660AF01000095", "Gotanet SE USIM (Telecommunication)" },
    { "3B9F94801FC78031E073FE211B573F8660B803000080", "Zero1 SIM card, Singapore (Telecommunication)" },
    { "3B9F94801FC78031E073FE211B6345431983009000DA", "Smartjac (Telecommunication)" },
    { "3B9F94801FC78031E073FE211B640681010082900045", "Mobicarte Orange" },
    { "3B9F94801FC78031E073FE211B6407564200829000D0", "SIM mobi orange" },
    { "3B9F94801FC78031E073FE211B649F4F002082900033", "USIM (3G DF) Orange (French Mobile Network) (Telecommunication)" },
    { "3B9F95801F038031A073B6A10067CF97F9E063689957", "Telestial OneRate International SIM card (Telecommunication)\nhttp://www.amazon.com/gp/product/B004GV13VY/ref=oh_aui_detailpage_o02_s00?ie=UTF8&psc=1" },
    { "3B9F95801F438031E073362113574A330E09314100A9", "GSM-SIM Elisa (Estonia, WPKI eID support)" },
    { "3B9F95801F438031E073362113574A330E0C314100AC", "Vodafone SIM (mobile phone)" },
    { "3B9F95801F438031E073362113574A330E10314100B0", "SIM card O2 (UK, Pay-As-You-Go)\nTesco Mobile (UK) SIM" },
    { "3B9F95801F438031E073F62113574A4305213141003A", "GSM SIM AT&T US" },
    { "3B9F95801F478031E073362113574A330E10314100B4", "Sonera Easy (Telecommunication)\nhttp://www.sonera.fi/\nGSM SIM MEDIONmobile (MVNO) Germany - from 2011" },
    { "3B9F95801F478031E073362113574A330E11314100B5", "Telus 3G SIM Card" },
    { "3B9F95801F478031E073FE2113574A33052B3234003A", "Finnish DNA SIM-card (Telecommunication)" },
    { "3B9F95801F478031E073FE2113574A33052C3234003D", "GSM SIM / LTE UICC card issued by TELE2, Lithuania (Telecommunication)" },
    { "3B9F95801FC38031A073BE21005302D006830590003A", "NTT docomo FOMA(W-CDMA) AX02(Gemalto) Green SIM (Telecommunication)\nhttps://ja.wikipedia.org/wiki/%E3%83%89%E3%82%B3%E3%83%A2UIM%E3%82%AB%E3%83%BC%E3%83%89" },
    { "3B9F95801FC38031A073BE21005302E232830590003C", "NTT docomo FOMA(W-CDMA) GE02(Japan Gemplus) Green SIM (Telecommunication)\nhttps://ja.wikipedia.org/wiki/%E3%83%89%E3%82%B3%E3%83%A2UIM%E3%82%AB%E3%83%BC%E3%83%89" },
    { "3B9F95801FC38031A073BE2113674701030102000099", "T-Mobile (UK) SIM\nFresh Mobile (UK) SIM" },
    { "3B9F95801FC38031A073BE2113674701050104000099", "T-Mobile Nederlands\nhttp://www.tmobile.nl" },
    { "3B9F95801FC38031A073BE2113674701090901000098", "German SIM card (T-Mobile) (Telecommunication)" },
    { "3B9F95801FC38031A073BE211367D002030901000006", "GSM, T-Mobile (Germany)" },
    { "3B9F95801FC38031A073BE211367D002031901000016", "GSM SIM card from congstar (a no-frills service provider of Deutsche Telekom)" },
    { "3B9F95801FC38031A073BE211367D00203210500002A", "T-Mobile CZ SIM+USIM, printed label says @LB. (Telecommunication)" },
    { "3B9F95801FC38031A073BE211367D00203310500003A", "T-MOBILE CZ GSM card" },
    { "3B9F95801FC38031E073FE21135786810286984418A8", "GREEN CARD, Grcard (Hong Kong ) Co.,Limited, LTE Usim Card (Telecommunication)\nCelcom Postpaid 3G (Telecommunication)" },
    { "3B9F95801FC38031E073FE21136355401883079000C2", "Ubivelox (JavaCard)" },
    { "3B9F95801FC38031E073FE211B573F866046CD0001B4", "China Unicom USIM 128K 1295E" },
    { "3B9F95801FC38031E073FE211B63E209A9830F90008D", "GSM-SIM EMT (Estonia, WPKI eID support)" },
    { "3B9F95801FC38031E073FE211B63E20AD2830F9000F5", "GSM, Vodafone (Germany)" },
    { "3B9F95801FC38031E073FE211B640690610082900031", "3G SIM card from AT&T USA" },
    { "3B9F95801FC38031E073FE211B640690620082900032", "AT&T GoPhone SIM Card" },
    { "3B9F95801FC38031E073FE211B649B4D011182900000", "Singular (now AT&T) 3G GSM SIM Card" },
    { "3B9F95801FC38031E073FE211BB3E20174830F900088", "Gemplus GemXplore 3G USIM" },
    { "3B9F95801FC78031A073B6A10067CF1713C41D2D3649", "Idemia card (Telecommunication)" },
    { "3B9F95801FC78031A073B6A10067CF3211B252C679F3", "open5gs (Telecommunication)" },
    { "3B9F95801FC78031A073BE21005304D08083059000BE", "NTT_DoCoMo (Telecommunication)" },
    { "3B9F95801FC78031A073BE211367D002040901000005", "T-Mobile SIM card issued in Germany 2012" },
    { "3B9F95801FC78031E073F62113674D451500390102F4", "Vivo 4G LTE SIM Card (Telecommunication)" },
    { "3B9F95801FC78031E073F62113674D4516004301008F", "VALID USIM (Telecommunication)" },
    { "3B9F95801FC78031E073FE21135712291102010000C2", "sysmocom sysmoUSIM-GR1\nhttp://sysmocom.de/" },
    { "3B9F95801FC78031E073FE2113574A33052C323400BD", "SoftBank (Black UICC) (Telecommunication)" },
    { "3B9F95801FC78031E073FE2113574A33052E323400", "SIM card" },
    { "3B9F95801FC78031E073FE2113574A33052F323400BE", "T-Mobile (US) USIM" },
    { "3B9F95801FC78031E073FE2113574A330530323400A1", "H2O Wireless GSM UICC (Telecommunication)\nhttp://www.h2owirelessnow.com" },
    { "3B9F95801FC78031E073FE2113574A330530323401A0", "RedPocket Mobile Contract-Free SIM Card (Telecommunication)\nhttps://www.redpocket.com/" },
    { "3B9F95801FC78031E073FE2113574A330E0732300099", "Bell Canada 3G SIM" },
    { "3B9F95801FC78031E073FE2113574A330E1932330084", "WIND Mobile SIM Card" },
    { "3B9F95801FC78031E073FE2113574A330E1A32330087", "Rohde and Schwarz CMW-Z04. Mini-UICC Test Card (Telecommunication)" },
    { "3B9F95801FC78031E073FE2113574A330E1A32360082", "TELUS 3G SIM Card" },
    { "3B9F95801FC78031E073FE2113635510888307900006", "SHOW or UPlus USIM (Telecommunication)" },
    { "3B9F95801FC78031E073FE2113635510AA8307900024", "2degrees NFC (Telecommunication)\nhttp://www.2degreesmobile.co.nz/home" },
    { "3B9F95801FC78031E073FE2113672228004001000191", "Lycamobile Prepaid SIM-Card (Telecommunication)\nhttp://lycamobile.at" },
    { "3B9F95801FC78031E073FE211367940311000002035C", "AT&T (US) GSM SIM" },
    { "3B9F95801FC78031E073FE211B573C8660BEB7002010", "Kyivstar SIM (Telecommunication)\nhttps://kyivstar.ua/" },
    { "3B9F95801FC78031E073FE211B63E20394830F9000BE", "Telenet N.V. Walk & Talk SIM Card Belgium" },
    { "3B9F95801FC78031E073FE211B63E204A5830F900088", "Cingular '64Ksmartchip' GSM SIM\nTelia GSM/3G (Swedish operator)" },
    { "3B9F95801FC78031E073FE211B63E206A6830F900089", "TracFone (US) Net10 GSM SIM card\nSimyo (Germany) GSM SIM card\nH3G (Italy) UMTS USIM card" },
    { "3B9F95801FC78031E073FE211B63E207A7830F900089", "SIM NRJ Mobile\nH3G (UK) UMTS USIM card\nOrange UK GSM/UMTS SIM" },
    { "3B9F95801FC78031E073FE211B63E208A8830F900089", "H3G (Sweden) UMTS USIM card" },
    { "3B9F95801FC78031E073FE211B63E209A9830F900089", "GSM SIM Vodafone NL postpaid" },
    { "3B9F95801FC78031E073FE211B63E20AD2830F9000F1", "GSM, Vodafone (Germany) (Telecommunication)" },
    { "3B9F95801FC78031E073FE211B640690620082900036", "AT&T UICC with USIM (Telecommunication)" },
    { "3B9F95801FC78031E073FE211B640752930182900005", "AT&T nano SIM (Telecommunication)" },
    { "3B9F95801FC78031E073FE211B640752930282900006", "AT&T GO PHONE 2G (Telecommunication)\nhttps://www.att.com/shop/wireless/gophone.html" },
    { "3B9F95801FC78031E073FE211B6407536301829000F4", "AT&T UICC with USIM and ISIM (Telecommunication)" },
    { "3B9F95801FC78031E073FE211B6440614100829000A2", "SIM card (Telecommunication)" },
    { "3B9F95801FC78031E073FE211B644112010082900090", "MTS SIM card (Russia) (Telecommunication)\nhttp://www.mts.ru/" },
    { "3B9F95801FC78031E073FE211B6441132100829000B1", "AT&T SIM card (Telecommunication)" },
    { "3B9F95801FC78031E073FE211B644132310082900080", "Telefonica | Vivo Brazil M2M SIM Card (Telecommunication)" },
    { "3B9F95801FC78031E073FE211B6441671100829000F5", "MTS SIM card (Russia) (Telecommunication)\nhttps://www.mts.ru" },
    { "3B9F95801FC78031E073FE211B659F010902048105C4", "2degrees mobile SIM card\nhttp://www.2degreesmobile.co.nz/" },
    { "3B9F95801FC78031E073FE211B65B4010E01028105ED", "USIM Card by Maroc Telecom Morocco (Telecommunication)" },
    { "3B9F95801FC78031E073FE211B675348434F5F01019B", "baicells sim card (Telecommunication)\nhttp://www.baicells.com/" },
    { "3B9F95803FC3A08031E073FE2113638D434283F0900034", "Taisys Java Csrd (Telecommunication)" },
    { "3B9F95803FC7A08031A073BE211B5305D0808305900024", "NTT docomo Xi(LTE) AX05(Gemalto) Pink SIM (Telecommunication)\nhttps://ja.wikipedia.org/wiki/%E3%83%89%E3%82%B3%E3%83%A2UIM%E3%82%AB%E3%83%BC%E3%83%89" },
    { "3B9F95803FC7A08031E073FE211363554022830790007C", "Ubivelox (JavaCard)" },
    { "3B9F958131FE9F0065465305..0671DF000000........", "Feitian PKI\nhttp://www.ftsafe.com/products/PKI-Card.html\nFTCOS/PK-01C" },
    { "3B9F958131FE9F0065465305300671DF000000806A825E", "Feitian PKI\nhttp://www.ftsafe.com/products/PKI-Card.html" },
    { "3B9F958131FE9F006646530501001171DF0000........", "Feitian ePass2003 token" },
    { "3B9F958131FE9F00664653051000FF71DF0000000000EC", "JavaCOS A22 dual interface Java card - 150K (JavaCard)\nhttp://www.smartcardfocus.us/shop/ilp/id~709/javacos-a22-dual-interface-java-card-150k/p/index.shtml" },
    { "3B9F958131FE9F006646530510043171DF000000000026", "ePass2003 (PKI)" },
    { "3B9F958131FE9F006646530510043171DF000006000020", "FEITIAN ePASS 2003 Auto (PKI)" },
    { "3B9F958131FE9F006646530510043171DF00003900001F", "Feitian ePass2003 (PKI)" },
    { "3B9F958131FE9F006646530520032571DF000000000005", "Feitian ePass2003 token" },
    { "3B9F958131FE9F006646530520032571DF000003900096", "Feitian ePass2003 token (PKI)" },
    { "3B9F958131FE9F006646530523002571C39F0000000086", "Feitian ePass2003 token" },
    { "3B9F958131FE9F006646530523002571DF00000.00000.", "FEITAIN ePASS2003 (PKI)\nhttp://www.ftsafe.com/product/epass/epass2003" },
    { "3B9F958131FE9F006646530523002571DF000003900096", "Feitian USB Cryptographic token (FIPS 140-2 Level 3) (PKI)\nhttp://www.ftsafe.com/product/epass/epass2003" },
    { "3B9F958131FE9F006646530532022571DF000006000010", "ePass 3003 Auto (PKI)\nhttps://www.ftsafe.com/products/PKI/Standard/Specification" },
    { "3B9F958131FE9F006646530534002571DF0000036A82F9", "Feitian ePass2003Auto (PKI)\nhttps://www.ftsafe.com/Products/PKI/Standard/Specification" },
    { "3B9F95C00A1F078031E073FE211B63F100AD830F90001D", "EMT WPKI USIM (2014, Estonia, JavaCard) (Telecommunication)" },
    { "3B9F95C00A1FC78031E073FE211B63F100AD830F9000DD", "Telenor SIM card (Norway)" },
    { "3B9F96400A8031E06B0420050258555555555555", "BuyPass identification card. It can also possibly be used to hold e-currency." },
    { "3B9F96400A8031E06B0421050261555555555555", "altinn - Buypass\nElectronic ID card for login to the altinn.no service" },
    { "3B9F96400A8031E06B042105026C555555555555", "Banca Intesa (Bank)\nhttp://www.bancaintesa.rs/code/navigate.aspx?Id=677" },
    { "3B9F96400A8031E06B04310502A8555555555555", "Norsk Tipping tippekort (eID)\nhttps://www.norsk-tipping.no/bli-nettspiller" },
    { "3B9F96801F438031E073362113574A330E09314100AA", "Elisa UICC (Telecommunication)" },
    { "3B9F96801F438031E073362113574A330E0C314100AF", "GSM, Vodafone (Germany)" },
    { "3B9F96801F478031E073362113574A330E0C314100AB", "NATEL SIM-Card swisscom\nVodafone Germany Micro-SIM from 2010" },
    { "3B9F96801F478031E073FE2113574A330E253332003B", "SMART prepaid card, Estonia (Telecommunication)" },
    { "3B9F96801F878031E073FE2119674A555473300948DB", "nano sim/usim card (Telecommunication)" },
    { "3B9F96801F878031E073FE2119674A555475300662F8", "SIM Card (Telecommunication)" },
    { "3B9F96801F878031E073FE2119674A557330310746BE", "Hologram Developer Global IoT SIM Card (Telecommunication)\nhttps://hologram.io/store/global-iot-sim-card/17" },
    { "3B9F96801F878031E073FE211B674A4C7530300248A9", "Cardcentrics (Telecommunication)" },
    { "3B9F96801F878031E073FE211B674A4C753034054BA9", "Test Card (Telecommunication)" },
    { "3B9F96801FC30068104405014649534531C80790001A", "SETEC SetCard 32K PKI Evaluated SetCOS 4.4.1" },
    { "3B9F96801FC38031E073FA21006331602383109000BE", "TAISYS SIMoME JAR (JavaCard)\nhttp://www.taisys.com/p-detail?id=39beTne-hf4u2Y5DnWghweplyFR-dUUf1-xpy55cWQ" },
    { "3B9F96801FC38031E073FE211BB3E2027E830F900082", "Vodafone SIM Card (D2, 1800Mhz, Germany, Twincard, possibly others too?), manufactured by Gemplus (See stamp on the chip)\nMobileOne (Singaporean 3G/GSM operator) SIM card 'II(3G-64) M1 3G '" },
    { "3B9F96801FC68031E073F62113674D45220079020080", "TMobile (Telecommunication)" },
    { "3B9F96801FC68031E073F62113674D4522008001007A", "ORANGE SPAIN GSM 4G SIM (Telecommunication)" },
    { "3B9F96801FC68031E073F62113675602220080010127", "giffgaff USIM (Telecommunication)" },
    { "3B9F96801FC68031E073F62113675603220121010087", "Rain 4G 5G Internet Service provider  (Telecommunication)\nhttps://www.rain.co.za" },
    { "3B9F96801FC68031E073FE2111633F011183079000E4", "VR-Bank VRNetworld HBCI Card (Bank)" },
    { "3B9F96801FC68031E073FE2113574A330577333300E2", "USIM issued by Moldcell mobile operator in Moldova (Telecommunication)\nhttp://www.moldcell.md/" },
    { "3B9F96801FC68031E073FE211B6441024100829000C2", "Empire Bank ltd (Bank)\nFinnish Telia SIM-card (Telecommunication)" },
    { "3B9F96801FC68031E073FE211B644104810082900004", "SAP Leonardo IoT Connect 365 SIM card (Telecommunication)\nhttps://www.sap.com/uk/products/enterprise-iot-connect.html" },
    { "3B9F96801FC68031E073FE211B644115010082900095", "Telia LT prepaid Ezys USIM (Telecommunication)\nhttps://www.ezys.lt" },
    { "3B9F96801FC68031E073FE211B6441177300829000E5", "Prixtel SIM card over OrangeF network (Telecommunication)\nhttps://www.prixtel.com" },
    { "3B9F96801FC68031E073FE211B6441193100829000A9", "Taiwan Star Telecom Corporation Limited (Telecommunication)\nhttps://www.tstartel.com/CWS/" },
    { "3B9F96801FC68031E073FE211B644124910082900034", "Fido Canada (Telecommunication)" },
    { "3B9F96801FC68031E073FE211B6441255100829000F5", "R&S CMW-Z06 Multi Test SIM (Telecommunication)" },
    { "3B9F96801FC68031E073FE211B644130320082900083", "SFR (Telecommunication)" },
    { "3B9F96801FC68031E073FE211B6441346100829000D4", "Ting X1 GSM SIM Card (4G, T-Mobile network) (Telecommunication)\nhttps://ting.com/shop/gsmSIM" },
    { "3B9F96801FC68031E073FE211B66D00206131218031E", "SIM card (Telecommunication)" },
    { "3B9F96801FC68031E073FE211B66D00206E20F1801F0", "Telekom Sim card (Telecommunication)" },
    { "3B9F96801FC68031E073FE211B66D00206E20F1803F2", "Vulcan 0502 T-Mobile SIM (Telecommunication)" },
    { "3B9F96801FC68031E073FE211B66D00206E20F1804F5", "T-Mobile Nederlands (Telecommunication)\nhttps://t-mobile.nl/" },
    { "3B9F96801FC68031E073FE211B66D00206E20F1809F8", "Croatian Telecom SIM card (Telecommunication)" },
    { "3B9F96801FC68031E073FE211B66D00206E20F3805D4", "SIM Card from Tmobile Czech Republic (Telecommunication)" },
    { "3B9F96801FC68031E073FE211B66D00221AB11180180", "Telekom Germany Triple SIM issued in 2018 (Telecommunication)" },
    { "3B9F96801FC68031E073FE211B66D00221AB11180786", "telekom HU nano sim card (Telecommunication)\nhttps://www.telekom.hu" },
    { "3B9F96801FC68031E073FE211C6441193100829000AE", "SORACOM SIM (plan unknown) (Telecommunication)" },
    { "3B9F96801FC78031A073BE2113674320071800000100", "sysmoUSIM-SJS1 (Telecommunication) (Telecommunication)\nhttp://www.sysmocom.de/products/sysmousim-sjs1-sim-usim" },
    { "3B9F96801FC78031A073BE21136743200718000001A5", "sysmoUSIM-SJS1 (Telecommunication)\nhttp://www.sysmocom.de/products/sysmousim-sjs1-sim-usim" },
    { "3B9F96801FC78031A073BE21136744220610000001A9", "Fairwaves test SIM card (Telecommunication)\nhttp://fairwaves.co" },
    { "3B9F96801FC78031E073F62113674D4516004301008C", "SIM From Tuenti Movil Spain (Telecommunication)" },
    { "3B9F96801FC78031E073F62113674D451600610100AE", "T-Mobile USA SIM Card (Telecommunication)\nhttps://support.t-mobile.com/docs/DOC-2031" },
    { "3B9F96801FC78031E073F62113674D451700630201AF", "TIM 4G LTE SIM Card (Telecommunication)\nhttp://www.tim.com.br" },
    { "3B9F96801FC78031E073F62113674D4524006701009A", "Mediamarkt Mobil SIM card (Austria) (Telecommunication)\nhttp://mobil.mediamarkt.at" },
    { "3B9F96801FC78031E073F62113674D45270077010089", "T-Mobile Compatible Straight Talk(tm) SIM Card (Telecommunication)\nhttps://www.straighttalk.com/home" },
    { "3B9F96801FC78031E073F62113675603270089010228", "TMobile Prepaid USIM (Telecommunication)" },
    { "3B9F96801FC78031E073F621136756032701010203A3", "USIM LTE MOVISTAR (Telecommunication)" },
    { "3B9F96801FC78031E073F621136756032701020100A0", "vivo (Other)" },
    { "3B9F96801FC78031E073FE21..63......83..9000..", "TIM (Italy) 128KB GSM SIM\nH3G (Italy) UMTS USIM\nVodafone (UK) SIM" },
    { "3B9F96801FC78031E073FE211163407262830790009A", "GSM SIM / LTE UICC card issued by Omnitel, Lithuania (Telecomunications)" },
    { "3B9F96801FC78031E073FE2111634082918307900099", "Chunghwa Telecom (Taiwan) 3G/4G PrePaid card\nhttps://www.twgate.net/prepaidcard/product_en.html" },
    { "3B9F96801FC78031E073FE21116566740E1113910057", "XLB.LTE Test Card (Telecommunication)\nhttp://www.xielibo.com" },
    { "3B9F96801FC78031E073FE2113574A330531333000A6", "AT&T eUICC (Telecommunication)" },
    { "3B9F96801FC78031E073FE2113574A330E1F33310082", "Sysmocom SIM Card (Telecommunication)" },
    { "3B9F96801FC78031E073FE2113574A330E1F33320081", "Lidl Connect SIM Card (Vodafone) (Telecommunication)" },
    { "3B9F96801FC78031E073FE2113574A330E20333100BD", "T-Mobile US USIM card (Telecommunication)" },
    { "3B9F96801FC78031E073FE2113574A330E20333200BE", "M2M2FF1-NONRUG-D - Verizon Non-Rugged M2M SIM Card (Telecommunication)" },
    { "3B9F96801FC78031E073FE2113574A330E20333300BF", "Turk Telekom SIM card [4>5G] (Telecommunication)\nhttps://bireysel.turktelekom.com.tr/4-5G/index.html" },
    { "3B9F96801FC78031E073FE2113574A330E22333200BC", "Project Fi (Telecommunication)\nhttps://fi.google.com" },
    { "3B9F96801FC78031E073FE2113574A330E24333200BA", "GSM, Vodafone (Germany) (Telecommunication)" },
    { "3B9F96801FC78031E073FE2113574A330E25333200BB", "Sintel hi! Tourist prepaid (Telecommunication)\nhttp://www1.singtel.com/personal/phones-plans/mobile/prepaid/hitouristsimcards.html" },
    { "3B9F96801FC78031E073FE2113574A330E26333200B8", "Vodafone sim card (Telecommunication)" },
    { "3B9F96801FC78031E073FE2113574A330E3F333400A7", "SIM Card (Telecommunication)" },
    { "3B9F96801FC78031E073FE2113679118020406060651", "USIM (3G PF) Orange" },
    { "3B9F96801FC78031E073FE211367931801010401095F", "Telstra 128K Universal Orange SIM Card (Telecommunication)" },
    { "3B9F96801FC78031E073FE2113679319010401010750", "Telefonica m2m simcard, Movistar o2 vivo (Telecommunication)" },
    { "3B9F96801FC78031E073FE211367932101070301036D", "GSM SIM blau (MVNO) Germany from 2013" },
    { "3B9F96801FC78031E073FE2113679327010202050169", "DigiMobil SIM (Telecommunication)" },
    { "3B9F96801FC78031E073FE2113679327010204080162", "Orange USIM card used in Poland (Telecommunication)" },
    { "3B9F96801FC78031E073FE211367933001030301047F", "T-Mobile US SIM card (Telecommunication)" },
    { "3B9F96801FC78031E073FE211367933001030403027C", "Comprion test U(SIM): model 128K/J LTE Test (U)SIM - Mini-UICC, product number Prod. No.: 10432006 (Telecommunication)\nhttp://www.comprion.com/en/products/test__u_sims/3g_test_usim_cards" },
    { "3B9F96801FC78031E073FE211367933001060201027D", "Morpho USIM (Telecommunication)" },
    { "3B9F96801FC78031E073FE211367933001110201026A", "R&S CMW-Z04 Mini-UICC Test Card (Telecommunication)\nhttp://www.rhode-schwartz.com" },
    { "3B9F96801FC78031E073FE2113679331010801010172", "Morpho (Telecommunication)" },
    { "3B9F96801FC78031E073FE2113679403030A02020244", "Digi mobil Romania (old sim card version) (Telecommunication)" },
    { "3B9F96801FC78031E073FE211367940307030404044F", "GSM-SIM EMT (3G modem 2011, Estonia)" },
    { "3B9F96801FC78031E073FE211367940307040707074B", "Older Vodafone SIM Card New Zealand (full-size, 64k) (Telecommunication)\nhttp://vodafone.co.nz" },
    { "3B9F96801FC78031E073FE211367940311000002035F", "Simple mobile. UICC with USIM (Telecommunication)" },
    { "3B9F96801FC78031E073FE211367940401070202024C", "Orange Mobicarte (France)" },
    { "3B9F96801FC78031E073FE211367940404030505054A", "Claro operator SIM" },
    { "3B9F96801FC78031E073FE211367941602070502025A", "CSL Mobile / PCCW SIM Card (Telecommunication)\nhttp://www.hkcsl.com/" },
    { "3B9F96801FC78031E073FE2113679801010202030142", "Telenor SIM card (Hungary) (Telecommunication)\nhttps://www.telenor.hu" },
    { "3B9F96801FC78031E073FE2113679801010402030247", "ReadySIM / T-Mobile USA USIM (2013) (Telecommunication)\nhttp://www.readysim.com/" },
    { "3B9F96801FC78031E073FE2113679801010803010349", "Yesss! SIM card (Austria) (Telecommunication)\nhttps://www.yesss.at" },
    { "3B9F96801FC78031E073FE2113679802010105010543", "CMHK card. China Mobile Hong Kong. (Telecommunication)\nhttps://www.hk.chinamobile.com" },
    { "3B9F96801FC78031E073FE2113679802010701010145", "Vodafone SIM card (Czech Republic) (Telecommunication)\nhttps://www.vodafone.cz" },
    { "3B9F96801FC78031E073FE2113679804010103010345", "Telekom Romania Mobile Communications (ex Cosmote) (Telecommunication)\nhttps://www.telekom.ro/" },
    { "3B9F96801FC78031E073FE2113679805020103010347", "USA T-Mobile 4G LTE GSM mobile data sim card, text, talk, and data (contract plan). Issued to/for android smart phone. (Telecommunication)" },
    { "3B9F96801FC78031E073FE2113679805020403010342", " AuStralian telstra usim (Telecommunication)" },
    { "3B9F96801FC78031E073FE2113679805021203010354", "Vodafone UK PAYG Data SIM (Telecommunication)" },
    { "3B9F96801FC78031E073FE2113679807020101010145", "Chunghwa Telecom Prepaid 4G SIM (Telecommunication)\nhttps://prepaidsim.twgate.net/index_en.html" },
    { "3B9F96801FC78031E073FE2113679807020102010245", "SIM card from the Polish telecom operator 'P4' or 'Play' (Telecommunication)\nhttps://www.play.pl/" },
    { "3B9F96801FC78031E073FE211367980702040238017A", "Beeline (Russia) SIM card (Telecommunication)\nhttps://moskva.beeline.ru/" },
    { "3B9F96801FC78031E073FE2113679807020506030144", "French free.fr 2EUR/month sim card  (Telecommunication)" },
    { "3B9F96801FC78031E073FE2113679807020601010142", "Digi Mobil (Telecommunication)\nhttps://digi.ro" },
    { "3B9F96801FC78031E073FE2113679807021001010154", "SIM Card (Carrier: BOB, Country: Austria) (Telecommunication)\nhttps://www.bob.at" },
    { "3B9F96801FC78031E073FE2113679807021301010157", "Polish MVNO 'nju mobile' SIM card (Telecommunication)\nhttps://njumobile.pl" },
    { "3B9F96801FC78031E073FE2113679807021402010351", "LTE USIM (US) (Telecommunication)" },
    { "3B9F96801FC78031E073FE2115574A330E3B333400A5", "O2 Spain phone SIM (Telecommunication)\nhttps://o2online.es/" },
    { "3B9F96801FC78031E073FE2115574A330E3F333500A0", "Telefonica (Germany) SIM Card (Telecommunication)" },
    { "3B9F96801FC78031E073FE2117574A330E3F333600A1", "Bell Mobility MULTI SIM (Telecommunication)\nhttps://bell.ca" },
    { "3B9F96801FC78031E073FE2117574A33810433360015", "HoT Austria SIM Card (Telecommunication)\nhttps://hot.at/" },
    { "3B9F96801FC78031E073FE211B57318660B21A0C0C9F", "SIM CARD (JavaCard)" },
    { "3B9F96801FC78031E073FE211B630057008381900011", "3 (3g microUSIM) Italian subsidiary H3G" },
    { "3B9F96801FC78031E073FE211B634041918307900050", "giffgaff UK 3G SIM\nnetzclub sponsored mobile\no2 Loop GSM SIM Germany (PREPAID) from 2013" },
    { "3B9F96801FC78031E073FE211B63E20394830F9000BD", "USIM (3G DF) Orange" },
    { "3B9F96801FC78031E073FE211B6406858300829000C1", "ANCEL (Telecommunication)" },
    { "3B9F96801FC78031E073FE211B6406978200829000D2", "MTN IRANCELL In Iran Sim Card (Telecommunication)\nhttp://www.irancell.ir/Portal/home/?21744/About%20Irancell" },
    { "3B9F96801FC78031E073FE211B640714810082900053", "SFR operator 3G" },
    { "3B9F96801FC78031E073FE211B6407546100829000F3", "Aero2 (Poland) - A 900Mhz HSPA+ and 2500Mhz LTE wholesale telecom operator\nUSIM providing toll-free access to the Internet ('Bezplatny Dostep do Internetu' service)\nhttp://aero2.pl/bdi.html" },
    { "3B9F96801FC78031E073FE211B6407595100829000CE00000000000000000000", "Oberthur USIM card (Telecommunication)" },
    { "3B9F96801FC78031E073FE211B6408102100829000F8", "Telia Mobile-ID SIM card in Estonia (Telecommunication)" },
    { "3B9F96801FC78031E073FE211B6408282300829000C2", "eSIM from automotive module (Telecommunication)" },
    { "3B9F96801FC78031E073FE211B6440411100829000D1", "TEST CARD (Telecommunication)\nhttp://optus.com" },
    { "3B9F96801FC78031E073FE211B6440411200829000D2", "Free Mobile SIM Card\nB&YOU SIM card" },
    { "3B9F96801FC78031E073FE211B6440451100829000D5", "Orange Spain GSM SIM Card (Telecommunication)\nhttp://www.orange.es" },
    { "3B9F96801FC78031E073FE211B644061810082900061", "tele2 (Telecommunication)\nhttp://www.tele2.ru" },
    { "3B9F96801FC78031E073FE211B64407883008290007A", "Free Mobile SIM (Telecommunication)" },
    { "3B9F96801FC78031E073FE211B644082210082900022", "Bouygues Telecom (French Mobile Provider SIM card) (Telecommunication)" },
    { "3B9F96801FC78031E073FE211B644091220082900032", "1&1 Simcard (Telecommunication)\nhttps://www.1und1.de/" },
    { "3B9F96801FC78031E073FE211B644124940082900030", "Telefonica Germany / o2 cellular USIM card (ICCID starts with 89492281945) - Card manufacturer IDEMIA Germany GmbH (code 8) - Year 19 / Week 45 (Telecommunication)" },
    { "3B9F96801FC78031E073FE211B6441271100829000B6", "Viettel LTE SIM Card (Telecommunication)" },
    { "3B9F96801FC78031E073FE211B6441380200829000BA", "SIM card operateur Free (Telecommunication)" },
    { "3B9F96801FC78031E073FE211B6441447300829000B7", "Bouygues Telecom (French Mobile Provider SIM card) (Telecommunication)\nhttps://www.bouyguestelecom.fr" },
    { "3B9F96801FC78031E073FE211B6441503100829000E1", "telcel sim card (Telecommunication)" },
    { "3B9F96801FC78031E073FE211B6441725100829000A3", "Free Mobile (French wireless service provider) SIM card (mini-SIM with micro-SIM cutout) received in 2020-09 (Telecommunication)\nhttps://mobile.free.fr/" },
    { "3B9F96801FC78031E073FE211B6441763200829000C4", "T-Mobile SIM card issued April 2021 (Telecommunication)" },
    { "3B9F96801FC78031E073FE211B65240109010081057B", "Lycamobile (UK) GSM SIM card" },
    { "3B9F96801FC78031E073FE211B65260109000781057F", "EMT WPKI 2015 (ECC) subscription (Telecommunication)\nhttps://www.emt.ee/en/pakkumised/mobiil-id" },
    { "3B9F96801FC78031E073FE211B65270109010381057B", "slarmy (Telecommunication)" },
    { "3B9F96801FC78031E073FE211B652A01090101810574", "9mobile Nigeria (Telecommunication)\nhttp://www.9mobile.com.ng" },
    { "3B9F96801FC78031E073FE211B652A010A0102810574", "Thailand AIS SIM Card (Telecommunication)" },
    { "3B9F96801FC78031E073FE211B652A010E0201810570", "gsm (Telecommunication)" },
    { "3B9F96801FC78031E073FE211B652D010C0400810572", "Tri Indonesia Bima+ SIM Card (Telecommunication)\nhttps://beta.tri.co.id/3digiworld/Bimaplus" },
    { "3B9F96801FC78031E073FE211B652F010A0301810570", "SMART Prepaid SIM (Telecommunication)" },
    { "3B9F96801FC78031E073FE211B6556544C017481056D", "Viettel LTE SIM (Telecommunication)" },
    { "3B9F96801FC78031E073FE211B65630109020181053E", "2degrees Mobile SIM Card New Zealand (Telecommunication)\nhttp://2degreesmobile.co.nz" },
    { "3B9F96801FC78031E073FE211B65BA010904048100E1", "Blank SIM (Telecommunication)" },
    { "3B9F96801FC78031E073FE211B66D0016B820E1801FE", "Telekom Deutschland GmbH - Xtra Data Karte (3G SIM)" },
    { "3B9F96801FC78031E073FE211B66D0016B820E1803FC", "Hofer Telekom (HoT) Austrian mobile provider SIM card (Telecommunication)\nhttps://www.hot.at/" },
    { "3B9F96801FC78031E073FE211B66D0016B820E3805DA", "GTS Czech MVNE SIM for T-Mobile (Telecommunication)\nhttp://www.gts.cz/cz-en/solutions/types/wholesale/mvne" },
    { "3B9F96801FC78031E073FE211BB3E20394830F90006D", "GemXplore 3G v2.2" },
    { "3B9F96801FC78031E073FE211BB3E204A5830F90005B", "Tre Italia Gemplus (Telecommunication)" },
    { "3B9F96803FC3A08031E073F62113574A4D0E1D31300071", "Telenor SIM card (Norway)" },
    { "3B9F96803FC6A08031E073F62116574A4D020B34546369", "SIM card Wingo operator (Switzerland) (Telecommunication)" },
    { "3B9F96803FC7008031E073FE211B6408050300829000EF", "Multipurpose UICC card for 2G, 3G, 4G/LTE, CDMA, ISIM & NFC (Telecommunication)\nhttp://www.smartjac.biz/index.php/component/eshop/telecom/test-uicc-sim-cards/2ff-mini-sim-cards/4g-open-multipurpose-uicc-card-3ff?Itemid=0" },
    { "3B9F96803FC7008031E073FE211F6441262100829000A3", "Smartjac SMAOT100A234FF (Telecommunication)\nhttps://smartjac.com" },
    { "3B9F96803FC7828031E073F62157574A330581053000CE", "COMPRION M2M eUICC (Telecommunication)" },
    { "3B9F96803FC7A08031E073F62156574A4D020B3444005B", "Norwegian telenor (Telecommunication)\nhttp://www.telenor.no" },
    { "3B9F96803FC7A08031E073F62157574A4D020B34546329", "Orange FR - opa (Telecommunication)" },
    { "3B9F96803FC7A08031E073FE211B63F100E8830090005E", "UICC CARD (Telecommunication)" },
    { "3B9F96803FC7A08031E073FE211B64080503008290004F", "NFC-enabled SIM card of MTS Russia. (Telecommunication)" },
    { "3B9F96803FC7A08031E073FE211F6441269100829000B3", "LTE Lab SIM Ver 1.3 (Telecommunication)" },
    { "3B9F968131FE458065544312210831C073F6218081059A", "Scientific and Technological Research Council of Turkey (test card) (eID)" },
    { "3B9F968131FE45806755454B41451212318073B3A180EA", "AKiS v1.2 on nxp chip" },
    { "3B9F968131FE45806755454B41451252318073B3A180AA", "AKiS v1.2.1 on infineon chip" },
    { "3B9F968131FE45806755454B41451253318073B3A180AB", "AKiS v1.2.1 on nxp chip" },
    { "3B9F968131FE45806755454B41451292318073B3A1806A", "AKiS v1.2.2 on infineon chip" },
    { "3B9F968131FE45806755454B41451293318073B3A1806B", "AKiS v1.3 on infineon chip" },
    { "3B9F968131FE5D00640428010231C073F701D000900065", "German eTicketing SAM (Transport)\nhttps://www.eticket-deutschland.de/" },
    { "3B9F968131FE9D006405A0030431C073F701D000900028", "Deutsche Telekom AG, TeleSec PKS ECC Signature Card (PKI)\nhttps://www.telesec.de/en/signaturecard" },
    { "3B9F9681B1FE451F070064051EB20031B0739621DB0590005C", "SignTrust (www.signtrust.de)\nInfinion SLE66CX680PE with Starcos 3.2\nhttp://www.deutschepost.de/dpag?xmlFile=link1015459_49595" },
    { "3B9F9681B1FE451F070064051EB20331B0739621C005900044", "German Dentist ID (eID)" },
    { "3B9F96C00A1FC38031E073FE211B63F100AD830F9000DA", "SIM SFR Pro (French Mobile Operator)" },
    { "3B9F96C00A1FC78031E073FE211B63F100AD830F9000DE", "H3G (Italy) UMTS USIM card" },
    { "3B9F96C00A1FC78031E073FE211B65D0011009228100F3", "Verizon 4G LTE SIM Card (Telecommunication)\nhttp://www.verizonwireless.com/support/information/4gsim.html" },
    { "3B9F96C00A1FC78031E073FE211B65D0018E0E3281007A", "Rogers 3G SIM card" },
    { "3B9F96C00A1FC78031E073FE211F65D0020912EE810F35", "German SIM card Drillisch (Telefonica) (Telecommunication) (Telecommunication)\nhttps://www.drillisch-online.de/" },
    { "3B9F96C00A1FC78031E073FE211F65D0020B11A4810F7E", "Telia Finland Oyj, network operator LTE  (Telecommunication)" },
    { "3B9F96C00A1FC78031E073FE211F65D013370F3B810FD2", "Gemalto Security Element (PKI)" },
    { "3B9F96C00A31FE45435431690B010001000000000000000D", "EU smart tachograph card (driver/company/control/workshop)\nhttps://dtc.jrc.ec.europa.eu/" },
    { "3B9F96C00A3FC6A08031E073FE211B65D001740EEB810FD7", "Verizon '4G LTE' USIM (Telecommunication)" },
    { "3B9F96C00A3FC6A08031E073FE211B65D001740F50810F6D", "5G (Telecommunication)" },
    { "3B9F96C00A3FC6A08031E073FE211F65D001900F3B810FE6", "Verizon US USIM card (Telecommunication)" },
    { "3B9F96C00A3FC6A08031E073FE211F65D00209107C810F24", "GSM SIM Vodafone NL postpaid NFC+ (Telecommunication)" },
    { "3B9F96C00A3FC6A08031E073FE211F65D0021B12B7810FFF", "SIM Card Fastweb IT GSM mobile network  (Telecommunication)" },
    { "3B9F96C00A3FC7A08031E073FE211B65D001740E8D810FB0", "USIM" },
    { "3B9F96C00A3FC7A08031E073FE211B65D001740EE3810FDE", "EE (UK) Mobile Phone SIM Card circa 2016 (Telecommunication)" },
    { "3B9F96C00A3FC7A08031E073FE211B65D001740F13810F2F", "Phone card sim  (Telecommunication)" },
    { "3B9F96C00A3FC7A08031E073FE211F65D0021A12AB810FE3", "Orange SIM (Telecommunication)" },
    { "3B9F96C00A3FC7A08031E073FE211F65D0021B12B7810FFE", "ISPL Card (Telecommunication)" },
    { "3B9F97801FC68031E073FE211B6441442100829000E5", "SAKURA Internet SIM (Telecommunication)\nhttps://www.sakura.ad.jp/services/sim/" },
    { "3B9F97801FC68031E073FE211B65CA010E060B81059E", "rain Networks - R15 4G Sim Card (Telecommunication)\nhttp://www.rain.co.za" },
    { "3B9F97801FC78031E073FE211367980801120401045B", "Tmobile Sim card  (Telecommunication)" },
    { "3B9F97803FC7828031E073FE211F640856210082900019", "eSIM card (Telecommunication)" },
    { "3B9F97803FC7828031E073FE211F6409069200829000FB", "Ubigi Transatel esim (Telecommunication)" },
    { "3B9F978131FE458065544312210831C073F621808105", "Republic of Turkey Identity Card (eID)\nhttps://bilgem.tubitak.gov.tr/en/icerik/national-identity-card-tr-nc-identity-card" },
    { "3B9F978131FE458065544312210831C073F62180810590", "Turkish National Electronic Identity Card - TCKK (eID)\nhttp://www.ekds.gov.tr" },
    { "3B9F978131FE458065544312210831C073F6218081059B", "Turkish Republic Identity Card - Turkiye Cumhuriyeti Kimlik Karti (TCKK) (eID)\nhttp://www.ekds.gov.tr/tckk/t-c-kimlik-karti/tanim" },
    { "3B9F978131FE4580655443D2210831C073F6218081055B", "Turkish Republic official electronic ID card with biometric data, e-signature, authentication, secure private-key cryptographic messaging, etc.  (eID)\nhttp://bilgem.tubitak.gov.tr/en/icerik/national-identity-card-tr-nc-identity-card" },
    { "3B9F978131FE4580655443D3228231C073F621808105D3", "Turkish eID (Turkiye Cumhuriyeti Kimlik Karti) (eID)" },
    { "3B9F97C00A1FC78031E073FE211B65D0011009228100F2", "'ultra fast card, max speed supported for telecom'? (transport)" },
    { "3B9F97C00A1FC78031E073FE211B65D001900F3B810F62", "Gemalto Multi-SIM consumer 4.2 (ST33I1M2) (Telecommunication)" },
    { "3B9F97C00A3FC6A08031E073FE211B65D001740EEB810FD6", "Verizon 4G LTE Micro SIM (Telecommunication)" },
    { "3B9F97C00A3FC6A08031E073FE211F65D0021B13F6810FBE", "Verizon SIM Card (Telecommunication)" },
    { "3B9F97C00A3FC7A08031E073FE211F65D001900FEE810F33", "AT&T Mobility LLC MicroSIM Card (Telecommunication)\nhttps://www.att.com/wireless/" },
    { "3B9F97C00AB1FE453FC6828031E073FE211B65D0023A14C9810F8B", "SIM (Telecommunication)" },
    { "3B9F97C0FF1FC78031E073FE211B63F100AD830F90002A", "Gemalto Speed Enhancement 97 (Telecommunication)" },
    { "3B9FB681B1FE5D1F4700640411030131C073B7010000900035", "BOS (Telecommunication)" },
    { "3B9FD680B1A0591FC7534C4538385F50534C5F56302E353001", "Infineon SLE88CFX4000P" },
    { "3BA70040..8065A208......", "Gemplus GemSAFE Smart Card (8K)" },
    { "3BA70040148065A214010137", "Gemplus GPK4000sdo" },
    { "3BA70040188065A208010152", "Gemplus GPK8000\nGemSAFE Smart Card (8K)" },
    { "3BA70040188065A209010152", "Gemplus GPK16000" },
    { "3BA70040188065A209010252", "Gemplus GPK16000" },
    { "3BA70040188065A209010352", "Gemplus GemSAFE std (GPK16000?)" },
    { "3BA8008171465D0054434F53312E320065", "Telesec TCOS 1.2" },
    { "3BA8008171465D0054434F53312E324B2E", "CeloCom Card with TCOS 1.2" },
    { "3BAA00401447473245543553343830", "Old German 'D2 Privat' sim card (Telecommunication)" },
    { "3BAA00401447473247543553343830", "GSM-SIM Libertel (900MHz)" },
    { "3BAA004080534F805345030411AAA3", "'open platform' ATMEGA 'new Generation'\nhttp://www.masterixweb-italy.com/new/images/articoli/atmega.jpg" },
    { "3BAB00813140458031C0650806800000000084", "Reloadable Visa Cash card (Schlumberger), Bank of America" },
    { "3BAC00402A001225006480000310009000", "Sesam Vitale card CPS (Carte Profesionnel de Sante)\nhttps://esante.gouv.fr/securite/cartes-et-certificats/CPS" },
    { "3BAC00402A001225006480820212009000", "Sesam Vitale card CPS (Carte Profesionnel de Sante)" },
    { "3BAD0040FF80318065B00501015E83009000", "Dallas Semiconductor iButton\nJIB\nGemplus GemXpresso 2.11PK" },
    { "3BB0110081319073F2", "SamOS 2.7" },
    { "3BB033009181316B35FC", "SkyperfecTV HD IC Card (Pay TV)\nhttps://www.skyperfectv.co.jp/eng/" },
    { "3BB036008131FE5D95", "Betacrypt 2 (Comvenient GmbH) Conditional Access Smart Card (Pay TV)\nwww.comvenient.com" },
    { "3BB2110010800001", "Atmel memory card AT88SC0104C\nhttp://www.atmel.com/dyn/resources/prod_documents/doc5210.pdf\nPlug'n'Print" },
    { "3BB2110010800002", "Atmel memory card AT88SC0204C (Atmel memory card)\nhttp://www.atmel.com/dyn/resources/prod_documents/doc5211.pdf\nCard LAVAGE reloadadble  from stations TOTAL" },
    { "3BB2110010800004", "Atmel memory card AT88SC0404C\nhttp://www.atmel.com/dyn/resources/prod_documents/doc5210.pdf" },
    { "3BB2110010800008", "Atmel memory card AT88SC0808C\nhttp://www.atmel.com/dyn/resources/prod_documents/doc5210.pdf\nSmart VR Card - GD Burti" },
    { "3BB2110010800016", "Atmel memory card AT88SC1616C\nhttp://www.atmel.com/dyn/resources/prod_documents/doc5210.pdf\nRexall (Canada) - Blood Pressure Check card\nhttp://www.rexall.ca/services/blood-pressure-tracking" },
    { "3BB3110000000032", "Atmel memory card AT88SC3216C\nhttp://www.atmel.com/dyn/resources/prod_documents/doc5210.pdf" },
    { "3BB3110000000064", "Atmel memory card AT88SC6416C\nhttp://www.atmel.com/dyn/resources/prod_documents/doc5210.pdf" },
    { "3BB3110000000128", "Atmel memory card AT88SC12816C\nhttp://www.atmel.com/dyn/resources/prod_documents/doc5210.pdf" },
    { "3BB3110000000256", "Atmel memory card AT88SC25616C\nhttp://www.atmel.com/dyn/resources/prod_documents/doc5210.pdf" },
    { "3BB7110081319043A5..............", "Siemens CardOS/M V1.4 (SLE44C80S)" },
    { "3BB7110081319043C517B09D19221E1F", "CryptoTech blank access/authentication card (Other)\nhttp://www.cryptotech.com.pl/" },
    { "3BB7110081319053B5..............", "CardOS EM/V1.4 (SLE44CR80S)" },
    { "3BB718008131704310434E5452563253", "Avtor SecureToken (PKI)" },
    { "3BB718008131FE6553504B323490005A", "Giesecke & Devrient Starcos 2.4" },
    { "3BB71800C03E31FE6553504B3234900025", "G&D STARCOS SPK 2.4" },
    { "3BB794008131FE5553504B32329000E0", "Dresdner Bank (a German Bank) Key-Card for InternetBanking" },
    { "3BB794008131FE6553504B32329000D0", "Giesecke & Devrient STARCOS SPK2.2" },
    { "3BB794008131FE6553504B32339000D1", "Giesecke & Devrient Starcos 2.3\nDeutsche Bank WebSign (RSA-Card)\nG&D StarSign Token\nOsakidetza ONA (eID)\nhttp://www.osakidetza.euskadi.eus/r85-ckserv01/es/contenidos/nota_prensa/ruedasanidad35/es_rs/ruedasanidad35_c.html" },
    { "3BB813008131205D0057696E4361726402", "SmartCard for Windows 1.1" },
    { "3BB813008131FA524348544D4F494341A5", "citizen digital certificate (PKI)\nhttp://moica.nat.gov.tw/" },
    { "3BB918008131FE9E8073FF614083000000DF", "Serbian Identity Card\nThis is the new Serbian biometric identity card (every adult cityzen\nmust have). The chip contains owners picture, name, date and place\nof birth, current address, unique ID number and fingerprint." },
    { "3BB9940040144747334D4838353330", "T D1 GSM card (Telecommunication)" },
    { "3BB9940040144747334E4838363430", "GSM-SIM card of the Austrian mobile phone provider One\nhttp://www.one.at\nProximus SIM - Belgium (SetCOS?)\no2 GSM-SIM card Germany 2003" },
    { "3BBA11001000434C5F53414D00133800", "Planeta Informatica CL-SAM (Other)\nhttp://www.planeta.inf.br/" },
    { "3BBA11008131FE4D55454B41452056312E30AE", "AKIS v1.0 on infineon chip" },
    { "3BBA13008131865D0064050A0201318090008B", "Telesec TCOS 2 (SLE44)\nTCOS 2.0 (on CR80S)\nCryptokarte with RSA-Controller, T=1 Protocol" },
    { "3BBA14008131865D0064051402023180900091", "TCOS 2.0 (on CX160S)\nTelesec TCOS 2 (SLE66)" },
    { "3BBA14008131865D0064057B020331809000", "PHILIPS (HealthCare)" },
    { "3BBA14008131865D0064057B020331809000FF", "PHILIPS (HealthCare)" },
    { "3BBA14008131865D0064057B0203319000FF", "JCOP CARD (Other)" },
    { "3BBA94004014", "GG3RS732S0 ?" },
    { "3BBA9400401447473352533731365300", "Micro Sim MCP crew sim (Telecommunication)" },
    { "3BBA9400401447473352533731365320", "GSM SIM Elisa Estonia" },
    { "3BBA9400401447473352533731365330", "GSM-SIM Viag Interkom E2 Loop (1800MHz)\nGSM-SIM card of the Austrian A1\nhttp://www.a1.net/privat/home\nGSM SIM Radiolinja Estonia; 2005" },
    { "3BBA9400401447473353533731365330", "GSM SIM Cellway (e-plus), Germany (Telecommunication)" },
    { "3BBA95001080434C5F53414D00013811", "CLSAM (Transport)\nhttp://www.planeta.inf.br" },
    { "3BBA950081B1865D1F430064045C02033180900084", "T-Mobile Corporate ID Card" },
    { "3BBA96008131865D0064056002033180900066", "Telesec TCOS 2 (SLE66P)\nTCOS 2.0 (on CX320P)\nTeleSec Netkey Card" },
    { "3BBA96008131865D00640560020331809000667001040530C9", "TeleSec Netkey E4 Card" },
    { "3BBA96008131865D0064057B0203318090007D", "TeleSec NetKey Card\nDeutsche Post card (tcos)" },
    { "3BBB1800C01031FE4580670412B003030000810138", "Giesecke & Devrient Star Sign Card, STARCOS 3.0 DI, 72 KB, RSA2048 bit\nGiesecke & Devrient Smartc@fe Expert 32K v2.0" },
    { "3BBB1800C01031FE4580670412B00303000081053C", "Philips Smart MX\nSzczecin University of Technology in Poland student identity card (Elektroniczna Legitymacja Studencka = student identity card)\nCSOB bank, Czech Republic\nCATCert (Agencia Catalana de Certificacio) catalan government workers identity card" },
    { "3BBB1800C03E31FE654726442054534D20312E30B7", "Italian Tachograph Driver Card" },
    { "3BBC1800813120755A43332E313220524556204146", "ZeitControl BasicCard Enhanced 3.7\nhttp://www.basiccard.com/" },
    { "3BBC1800813120755A43332E313420524556204445", "ZeitControl BasicCard Enhanced 3.14 Rev D\nhttp://www.basiccard.com/" },
    { "3BBC1800813120755A43332E333220524556204247", "ZeitControl BasicCard (Other)\nhttps://ZeitControl" },
    { "3BBC94004014474733483335585332303030", "GSM-SIM Era-PL\nT-Mobile GSM SIM Card" },
    { "3BBC94004014474733483335585632303030", "GSM SIM CARD 32K, Vodafone" },
    { "3BBC94004014474733493539424332303030", "GSM SIM Vodafona NL prepaid" },
    { "3BBC94004014474733493543414331303030", "Siemens SIM card" },
    { "3BBC94004014474733493731394332303020", "Telenor SIM card (Norway)" },
    { "3BBC94004014474733494231424331303020", "Telenor SIM (Telecommunication)" },
    { "3BBC94004014474733494231424331303030", "SIM Card (Scarlet, Belgium) (Telecommunication)\nhttps://www.scarlet.be/nl/prepaid/" },
    { "3BBC94004014474733533035315331303130", "GSM SIM (Tele2, Estonia)\nGSM SIM Elisa Estonia; 2007\nGSM SIM from 'fonic' Germany" },
    { "3BBD18008131FE45805102670414B10101020081053D", "Austrian 'e-Card' (=Health Card)\nspecial Version of Starcos 3.1" },
    { "3BBD18008131FE45805102670518B102020201810531", "Austrian health insurance card 'e-card'" },
    { "3BBD18008131FE45805103670414B10101020081053C", "Austrian Health insurance card 'eCard' (HealthCare)\nhttp://www.chipkarte.at" },
    { "3BBE..000041052000............00009000", "CryptoMate64 USB Cryptographic token\nhttp://www.acs.com.hk/en/products/18/cryptomate64-cryptographic-usb-tokens/\nACS ACOS5-64 V2.00\nhttp://www.acs.com.hk/en/products/17/acos5-64-cryptographic-smart-card/" },
    { "3BBE1100004101102038000000000000000000", "ACOS2" },
    { "3BBE1100004101380000000000000000019000", "ACS (Advanced Card System) ACOS-1\nACOS3\nhttps://www.acs.com.hk/en/products/306/acos3-microprocessor-card-contact/" },
    { "3BBE1100004101380000000000000000029000", "ACS (Advanced Card System) ACOS-1 8K" },
    { "3BBE1100004101380000010000000000019000", "ACOS3 Microprocessor Card (Contact) (Other)\nhttp://www.acs.com.hk/en/products/306/acos3-microprocessor-card-contact/" },
    { "3BBE1100004101380000030000000000019000", "ACS ACOS3-32 (Telecommunication)\nhttp://www.acos3.com/" },
    { "3BBE110000410138000004006275627A019000", "Advanced Card Systems ACOS3 (24k) V1.7\nhttp://www.acs.com.hk/index.php?pid=product&prod_sections=0&id=ACOS3" },
    { "3BBE1100004101380000050000000000029000", "ACS (Advanced Card System) ACOS2" },
    { "3BBE1100004101380100030000000000029000", "ACOS2 test card from ACS reading off a ACR38U" },
    { "3BBE1100004101380300040000000000019000", "ACOS 3 from ACS (Other)" },
    { "3BBE1100004101380400140000000000019000", "Dekart Smartcard Logon (eID)\nhttp://www.smartcardfocus.com/shop/ilp/se~81/dekart-smartcard-logon/p/index.shtml" },
    { "3BBE1100004101380400140000000000029000", "DEKART proprietary logon authentication solution for Windows (Other)\nhttp://www.dekart.com/products/" },
    { "3BBE1100004101380500070000000000029000", "EEPROM card (Other)" },
    { "3BBE11000041013817CE010000000000019000", "ACOS3 Contact Microprocessor Card (Other)\nhttps://www.acs.com.hk/en/products/306/acos3-microprocessor-card-contact/" },
    { "3BBE1100004101382500030000000000019000", "8 pin (eID)" },
    { "3BBE1100004101384D800A8050524F56009000", "ACS (Advanced Card System) ACOS-3" },
    { "3BBE110000410138FF40000000000000019000", "Acos3 (zend) (eID)" },
    { "3BBE1100004107020000000000000000019000", "ACOS7 MOC Combi-Card (Other)\nhttp://www.acs.com.hk/en/products/123/acos7-moc-combi-card/" },
    { "3BBE1800004105..0000000000000000009000", "Advanced Card Systems (ACS) ACOS5 Cryptographic Smart Card" },
    { "3BBE1800004105100000000000000000009000", "ACS ACOS5 'ACOS5-32-G' dual card\nhttp://www.acs.com.hk/acos5.asp" },
    { "3BBE940040144747335333454441544C36303130", "SingTel hi! Prepaid GSM SIM UICC (Telecommunication)" },
    { "3BBE940040144747335333454841544C39313000", "Latvian GSM operator TELE2" },
    { "3BBE940040144747335333474841544C39313030", "simCard Vip Mobile(Serbia) or Telecom Austria (Telecommunication)\nhttp://www.vipmobile.rs/" },
    { "3BBE94008131FE3553504B3233205745353031364E4325", "G&D StarCOS SPK 2.3 secure element (Bank)" },
    { "3BBE9500004103000000000000000000029000", "touchatag SAM card\nSpanish University of Murcia smart ID card - Old version with CajaMurcia Banking card integrated (Maestro card) (M.Mar OS) - Also used by many others spanish universities\nACOS6 C6\nhttps://www.acs.com.hk/en/products/309/acos6-multi-application-purse-card-contact/\nACOS6S C7 SAM\nhttps://www.acs.com.hk/en/products/310/acos6-sam-secure-access-module-card-contact/" },
    { "3BBE96000041013802001D0000000000019000", "ACOS3-32 (Other)\nhttps://www.acs.com.hk/en/products/306/acos3-microprocessor-card-contact/" },
    { "3BBE9600004103000000000000000000029000", "SAM inside the Tikitag reader from Alcatel-Lucent\nhttp://hackerati.com/post/57314994/rfid-on-the-cheap-hacking-tikitag" },
    { "3BBE9600004105004E46000000000000009000", "ACOS5-64 v3.00 (PKI)\nhttps://www.acs.com.hk/en/products/308/acos5-64-v3.00-cryptographic-card-contact/" },
    { "3BBE9600004105300000000000000000009000", "CryptoMate Nano USB Cryptographic token\nhttp://www.acs.com.hk/en/products/414/cryptomate-nano-cryptographic-usb-tokens/\nACS ACOS5-64 V3.00\nhttp://www.acs.com.hk/en/products/308/acos5-64-v3.00-cryptographic-card-contact/" },
    { "3BBE9600004206210000000000000000009000", "ESMART Token (PKI)\nhttps://esmart.ru/products/informatsionnaya-bezopasnost/smart-karty-esmart-token/" },
    { "3BBE9600801FC78031E073FE21136200..83819000..", "Vodafone (Italy) 128 kB GSM SIM card\nTIM (Italy) 128 kB GSM SIM card" },
    { "3BBF..008131FE5D0064040F03..31C073F701D0009000..", "TCOS 3.0 on Philips P5CD036" },
    { "3BBF..008131FE5D0064041103..31C073F701D0009000..", "TCOS 3.0 on Philips P5CT072" },
    { "3BBF..008131FE5D0064041503..31C073F701D0009000..", "TCOS 3.0 on Philips P5CD072" },
    { "3BBF..008131FE5D00640428030231C073F701D0009000..", "TCOS 3.0 release 2 on Philips P5CD080" },
    { "3BBF..008131FE5D0064056D03..31C073F701D0009000..", "TCOS 3.0 on Infineon SLE 66CX642P" },
    { "3BBF..008131FE5D0064058903..31C073F701D0009000..", "TCOS 3.0 on Infineon SLE 66CLX641P" },
    { "3BBF..008131FE5D0064058A03..31C073F701D0009000..", "TCOS 3.0 on Infineon SLE 66CLX640P" },
    { "3BBF..008131FE5D0064059103..31C073F701D0009000..", "TCOS 3.0 on Infineon SLE 66CX680PE" },
    { "3BBF11008131..4545504100000000........0000......", "Austrian Quick E-purse\nhttp://www.quick.at/" },
    { "3BBF11008131FE45455041000000000000000000000000F1", "a.sign premium signature card" },
    { "3BBF11008131FE454D434100000100016971850000000077", "Austrian 'easybank' branded Mastercard, issued 2007" },
    { "3BBF11008131FE454D434100000100020820510000000090", "austrian combined card of a mastercard and OBB Vorteilscard (Austrian Federal Railways)\nhttp://www.oebb.at/pv/de/Servicebox/VORTEILScard/Bezahlen_mit_der_VORTEILScard/VORTEILScard_MasterCard.jsp" },
    { "3BBF11008131FE454D43410000010002559133000000001E", "Mastercard (Paylife Austria)" },
    { "3BBF1100C01031FE44534D405254204341464520312E3143C1", "Giesecke&Devrient SmartCafe 1.1" },
    { "3BBF18008031703553544152434F5320533231204390009B", "Giesecke & Devrient STARCOS S2.1" },
    { "3BBF18008131705553544152434F532053323120439000FA", "Giesecke & Devrient STARCOS S2.1" },
    { "3BBF1800C02031705253544152434F5320533231204390009C", "Giesecke & Devrient SPK 2.1 C" },
    { "3BBF94008131FE65454C55204175737472696120312E3238", "A-Trust: trust-sign (Old Version, ca. 2002) for Digital Signature etc.\nA-Trust: a-sign-premium (ca. 2004) 'Burgerkarte' ('Citizen-Card')\nfor Identifikation, Digital Signature etc.\n('should be' Starcos 2.3)" },
    { "3BBF96008131FE5D0064........31C073F701D0009000..", "TCOS 3.0 / NetKey 3.0" },
    { "3BBF96008131FE5D00640411000031C073F701D0009000", "DATEV eG, Nuernberg, Bavaria, Germany (PKI)\nhttp://www.datev.de" },
    { "3BBF96008131FE5D00640411030131C07301D000900000", "DATEV eG, Nuernberg, Bavaria, Germany (PKI)\nhttp://www.datev.de" },
    { "3BBF96008131FE5D00640411030131C073F701D0009000", "DATEV eG, Nuernberg, Bavaria, Germany (PKI)\nhttp://www.datev.de" },
    { "3BC5FF8131FB458073C6010000", "Japanese Individual Number Card (eID)\nhttps://www.kojinbango-card.go.jp/en/kojinbango/index.html" },
    { "3BC800000073C84000000000", "verve (Bank)" },
    { "3BCDFF8031FE450068D276000028040481009000CD", "Tachograph company test card (Transport)" },
    { "3BD096FF81B1FE451F032E", "New european health insurance card of the German health insurance (G2) (HealthCare)\nhttps://de.wikipedia.org/wiki/Elektronische_Gesundheitskarte" },
    { "3BD096FF81B1FE451F072A", "German public health insurance card (,,Gesundheitskarte'), 2nd generation (G2), issuer Techniker Krankenkasse (HealthCare)\nhttps://gematik.de/cms/de/spezifikation/wirkbetrieb/kartengeneration2/kartengeneration2.jsp" },
    { "3BD096FF81B1FE451FC7EA", "German public health insurance card (Elektronische Gesundheitskarte eGK), 2nd generation (G2) (HealthCare)" },
    { "3BD097FF81B1FE451F072B", "German Elektronische Gesundheitskarte (eGK) (HealthCare) - From TK (HealthCare)\nhttps://de.wikipedia.org/wiki/Elektronische_Gesundheitskarte" },
    { "3BD097FF81B1FE451FC7EB", "German Health Professional Card (eHBA) (HealthCare)\ngSMC-KT, STARCOS 3.6 (HealthCare)" },
    { "3BD0A8FF81F1FB24001FC3F4", "Philips DESFire SAM" },
    { "3BD218008131FE450101C1", "Dutch License Plate Card (RDW)\nhttps://commons.wikimedia.org/wiki/File:Kentekencard_voorzijde_1_december_2013.jpg" },
    { "3BD218008131FE58C90114", "Atos CardOS5 (PKI)\nhttp://atos.net/NR/rdonlyres/17C7BDD0-225B-4A58-B9A4-438EA3F3238A/0/74743_20120830_160149_cardos_v5_0__datenblatt_en.pdf" },
    { "3BD218008131FE58C90217", "WVDP (West Valley Demonstration Project?) (PKI)" },
    { "3BD218008131FE58C90316", "Austrian 'RKS-Card' issued by GlobalTrust (PKI)\nhttps://secure.globaltrust.eu/info-rksv.html" },
    { "3BD218008131FE58C90411", "Identity Card in Slovakia with security chip and e-signature issued after 2021-06-21 (eID)" },
    { "3BD218008131FE58CA6076", "CardOS IoT V5.4 (PKI)\nhttps://atos.net/wp-content/uploads/2018/11/ct_181127_lpm_cardos_iot_v5-4_fs_en4_web.pdf" },
    { "3BD21802C10A31FE58C80D51", "Siemens Card CardOS M4.4" },
    { "3BD396FF81B1FE451F078081052D", "German public health insurance card (Elektronische Gesundheitskarte eGK), 2nd generation (G2) (HealthCare)" },
    { "3BD5180081313A7D8073C8211030", "Aladdin eToken NG-Flash with 256MB of flash memory\nAladdin eToken PRO (72KB)\nhttp://www.aladdin.com/etoken/devices/default.aspx" },
    { "3BD518008131FE7D8073C82110F4", "Bank of Lithuania Identification card\nGemalto SafeNet eToken Java Based Cards\nhttps://safenet.gemalto.com/multi-factor-authentication/authenticators/pki-usb-authentication/" },
    { "3BD518FF8091FE1FC38073C8211308", "Athena IDProtect (JavaCard 2.2.2)\nhttp://www.athena-scs.com/product.asp?pid=32\nThales nShield Security World Card - Remote Administration Ready\nhttps://www.thalesesecurity.fr/products/hsm-management-and-monitoring/nshield-remote-administration" },
    { "3BD518FF8191FE1FC38073C821100A", "ComSign digital signature card (eID)\nhttps://www.comsign.co.uk/" },
    { "3BD518FF8191FE1FC38073C8211309", "Athena IDProtect Key (v2)\nhttp://www.athena-scs.com/product.asp?pid=33" },
    { "3BD5950400AE01020101", "Axalto Cyberflex Access 64K v2b SM 1.1" },
    { "3BD595FF8091FE1FC38073C8211385", "Athena IDProtect - Cryptographic Java Card\nhttp://www.athena-scs.com/product.asp?pid=32" },
    { "3BD596FF8191FE1FC34332333030CC", "HID Global - Crescendo C2300 (PKI)\nhttps://www.hidglobal.com/products/cards-and-credentials/crescendo/c2300" },
    { "3BD6180080B1806D1F038051006110309E", "Atmel/Athena T0 PC/SC Compliance Test Card No. 1" },
    { "3BD618008131FE7D415350204F5383", "ASP FIXED CHAL1, 2, 3  and  4 (Other)" },
    { "3BD6180081B1807D1F038051006110308F", "ASECard Crypto\nhttp://www.athena-scs.com/product.asp?pid=8" },
    { "3BD6960081B1FE451F078031C1521118F8", "smart card from NASA, 2019 (PKI)" },
    { "3BD6960081B1FE451F878031C152211949", "DHS CAC card (PKI)" },
    { "3BD6960081B1FE451F878031C152411A2A", "Identiv SCR3310 v2.0 (eID)" },
    { "3BD6970081B1FE451F078031C1521118F9", "NASA Personal Identity Verification (PIV) card (eID)" },
    { "3BD6970081B1FE451F078031C1521119F8", "Secure badge (PKI)" },
    { "3BD6970081B1FE451F878031C152211948", "DOS PIV (PKI)" },
    { "3BD6970081B1FE451F878031C152211A4B", "ID-One PIV 2.4 (P/N 1501381) from IDEMIA (Other)" },
    { "3BD6970081B1FE451F878031C152411A2B", "Oberthur Technologies ID-One PIV/CIV on V8 Device (eID)\nhttps://csrc.nist.gov/csrc/media/projects/cryptographic-module-validation-program/documents/security-policies/140sp2986.pdf" },
    { "3BD8180080B1FE451F078031C1640806920FD5", "Oberthur Cosmo v8 (PKI)" },
    { "3BD818FF8131FE458064041BB42A8105D5", "Schweizerische Krankenversicherungskarte KVG (HealthCare)" },
    { "3BD818FF81B1FE451F038064041AB403810561", "D-Trust multicard advanced 3.1\nGerman public health insurance card ('Gesundheitskarte'), issuer SBK 'Siemens Betriebskrankenkasse'" },
    { "3BD8960081B1FE451F0743485447504B494ADD", "Citizen Digital Certificate, Taiwan (PKI)\nhttp://moica.nat.gov.tw/" },
    { "3BD896FF8131FE458064041BB42A81055B", "Swiss LAMal health insurance card" },
    { "3BD911008131FE8D0000464F4D53312E3132", "TFOMS (eID)\nhttp://www.samtfoms.ru" },
    { "3BD918008011F08054434F4C4482900062", "TransaXiom Janus Card (Other)\nhttp://www.transaxiom.co.uk" },
    { "3BD91800C00910FE5459464F4E45000000", "Tyfone's SideTap Card (NFC payments)" },
    { "3BD918FF8191FE1FC35441474C494F5049565B", "Taglio PIV C2190 (NXP JCOP 3 SecID P60 CS) (eID)\nhttps://www.taglio.com/pivcard.html" },
    { "3BD99400004D4502000901009000", "Moviestar. GSM SIM card (Telecommunication)" },
    { "3BD99400004D454576352E369000", "Vending Machine Card (Other)" },
    { "3BD99400004D4D41523331349000", "Vodafone Spain 64kb SIM card. GSM/3G networks" },
    { "3BD99500004D4516005401009000", "MTS Ukraine (Telecommunication)\nhttp://www.mts.ua/" },
    { "3BD996FF8131FE454352455343454E444FFF", "HID Global Crescendo JCOP 21 v2.4.1 R2 64K (PKI)" },
    { "3BD996FF8131FE458031B8738601E0810522", "German dentist's identity card (eID)\nhttp://www.medisign.de/" },
    { "3BD996FF8191FE1FC343323330302D4B4559BA", "Crescendo Key (USB Type-A) (PKI)\nhttps://www.hidglobal.com/products/cards-and-credentials/crescendo/crescendo-key" },
    { "3BDA11FF81B1FE551F0300318473800180009000E4", "Gnuk OpenPGP Token (PKI)\nhttps://www.fsij.org/category/gnuk.html" },
    { "3BDA11FF81B1FE551F0300318473800180059000E1", "Nitrokey Start (Openpgp USB) (Other)\nhttps://www.nitrokey.com/products/nitrokey-start" },
    { "3BDA13FF8131FB468012392F31C173C601C03B", "My Number Card (The Social Security and Tax Number System in JAPAN) (eID)\nhttp://www.cas.go.jp/jp/seisaku/bangoseido/english.html" },
    { "3BDA1802C10A31FE584B53776973735369676EA9", "SuisseID Post - ATOS CardOS 4.x (eID)\nhttps://postsuisseid.ch/" },
    { "3BDA18FF8191FE1FC350564A434F503353494472", "J3H145 (P6 SecID) purchased from FUTAKO Ltd., Taiwan (JavaCard)\nhttp://www.javacardsdk.com" },
    { "3BDA18FF81B1FE451FC3546963546F6B20322E3068", "TikTok 2.0 (PKI)" },
    { "3BDA18FF81B1FE451FC3546963546F6B20332E3069", "TicTok 3.0 (PKI) (PKI)\nhttps://en.cryptoshop.com/products/cryptas-tictok-v3-basisartikel.html" },
    { "3BDA18FF81B1FE751F030031C573C001400090000C", "OpenPGP Card V2" },
    { "3BDA18FF81B1FE751F030031F573C001600090001C", "OpenPGP Card V3" },
    { "3BDA9400004D4D41524A2B33399000", "SIM card from Vodafone Spain" },
    { "3BDA9500400A2508004053434F535441", "Card used for issuing commodity to benificiary for rice, wheat and more (Other)" },
    { "3BDA96FF8131FE45805631B85349434181057B", "STARCOS 3.5 ID ECC C1R (PKI)\nhttps://www.gi-de.com/fileadmin/user_upload/MS/Certificates/STARCOS35_ID_ECC_TABLES.pdf" },
    { "3BDB11FF5000FF0000000000000007921603", "NEC V-WAY64 v2.1" },
    { "3BDB1800801F030031C06477E303008290004F", "Oberthur ID-One Cosmo 64K V5.2" },
    { "3BDB180080B1FE451F830031C064C7FC1000019000FA", "Oberthur Cosmo V7 64K Dual/128K" },
    { "3BDB18FF8191FE1FC306092B06010401E9100503D7", "SafeSign Default QSCD (NXP JCOP 3 SecID P60) (PKI)\nhttps://www.tuv-nederland.nl/assets/files/cerfiticaten/2020/02/security-target-v1.0.pdf" },
    { "3BDB18FF81B1FE751F03504B436172642056312E30ED", "Tecos 3 card (Other)" },
    { "3BDB18FF81B1FE751F035A43372E35205245562041AE", "BasicCard Professional ZC7.5-COMBI (Other)\nhttp://www.basiccard.com/" },
    { "3BDB18FF81B1FE751F035A43372E36205245562044A8", "Zeitcontrol Professional BasicCard ZC 7.6 REV D (Other)\nhttp://www.zeitcontrol.de/en/products/basiccard/basiccard" },
    { "3BDB18FFC080B1FE751F035A43372E352052455620416F", "ZeitControl BasicCard ZC7.5 user-programmable dual interface smart card\nhttp://www.smartcardfocus.com/shop/ilp/id~380/BasicCard_ZC7_5_Dual_Interface/p/index.shtml" },
    { "3BDB18FFC080B1FE751F035A43372E352052455620426C", "BasicCard ZC7.5 dual-interface programmable smartcard (30K) (eID)\nhttps://secure.zeitcontrol.de/shop/Smart-card-BasicCard-Professional-ZC75-Combi" },
    { "3BDB18FFC080B1FE751F035A43372E352052455620446A", "Smart card BasicCard Professional ZC7.5, ZeitControl cardsystems GmbH\nhttp://www.zeitcontrol.de/en/products/chip-cards/processor-chip-cards/basiccard" },
    { "3BDB18FFC080B1FE751F035A43372E3620524556204469", "ZeitControl BasicCard 7.6 (Other)\nhttps://www.zeitcontrol.de/en/products/basiccard/basiccard" },
    { "3BDB9600801F030031C06477E30300829000C1", "Oberthur Card Systems (contactless pilot) ID-One Cosmo v5.2D 64K\nOberthur Card Systems (PIV Transitional) ID-One Cosmo v5.2D 72K\nCAC (Common Access Card)" },
    { "3BDB9600801F030031C064B0F3100007900080", "DoD CAC, Oberthur ID One 128 v5.5 Dual" },
    { "3BDB9600801F030031C064B0F310000F900088", "US Department of Veterans Affairs PIV" },
    { "3BDB9600801F830031C0641D18010001900051", "ID0One Cosmo Development Kit (JavaCard)" },
    { "3BDB96008031FE448059654944204E414452418F", "Pakistan ID card (eID)" },
    { "3BDB960080B1FE451F830012233F536549440F9000F1", "Estonia ID-card (eID)\nhttps://id.ee" },
    { "3BDB960080B1FE451F830012428F536549440F900020", "Latvia eID (eID)\nhttps://www.eparaksts.lv/lv/" },
    { "3BDB960080B1FE451F830031C064102301000F900063", "Extremenian Health Service target (HealthCare)\nhttps://saludextremadura.ses.es/web/preguntas-frecuentes" },
    { "3BDB960080B1FE451F830031C0641A1801000790005A", "Ercom CRYPTOSMART\nhttp://www.ssi.gouv.fr/entreprise/qualification/gamme-cryptosmart-pour-la-securisation-des-smartphones-et-des-tablettes/" },
    { "3BDB960080B1FE451F830031C0641A1801000F900052", "Serbian Car registration ID card\nhttp://blog.goranrakic.com/archives/2011/07/citanje_saobracajne_dozvole_sa_cipom.html" },
    { "3BDB960080B1FE451F830031C0641A71010007900033", "ChamberSign Gemalto USB Shell Token V2 - Certificat Audacio ** (eID)\nhttp://www.chambersign.fr/certificat-rgs-audacio/" },
    { "3BDB960080B1FE451F830031C064B0FC100007900005", "Oberthur Cosmo V7 debug card (SDK)" },
    { "3BDB960080B1FE451F830031C064B0FC10000F90000D", "ID-One PIV (that's the only non-numeric identifying mark) (PKI)" },
    { "3BDB960080B1FE451F830031C064BE1B0100019000FB", "Bank card" },
    { "3BDB960080B1FE451F830031C064C30801000F90009B", "SIM Aruba (Italian provider)" },
    { "3BDB960080B1FE451F830031C064C7FC100001900074", "Oberthur Cosmo (eID)\nhttp://www.stampit.org" },
    { "3BDB960080B1FE451F830031C064C7FC10000F90007A", "Guatemalan ID Card\nhttp://www.renap.gob.gt/" },
    { "3BDB960080B1FE451F830031C164084022300F90000A", "Oberthur v7 - in a Gemalto (was Gemplus) GemPC Key SmartCard Reader (grey USB dongle) - bought at ChamberSign (PKI)" },
    { "3BDB960080B1FE451F830031E85427E6040007900084", "Polish encard (eID)" },
    { "3BDB960080B1FE451F830031E85427E604000F90008C", "Token card from iBRE CompanyNet (mbank) (Bank)" },
    { "3BDB960080B1FE451F834553544F4E49412D65494455", "Estonian Identity Card (ID-One Cosmo v8.1) (eID)" },
    { "3BDB960081B1FE451F0380F9A0000003080000100018", "Oberthur CS PIV End Point v1.08 FIPS201 Certified" },
    { "3BDB960081B1FE451F0380F9A0000003480000000149", "Fly Clear card" },
    { "3BDB960081B1FE451F8380F9A0000003080000100098", "Oberthur Cosmo v7 128K with PIV applet\nhttp://www.smartcardfocus.com/shop/ilp/id~410/p/index.shtml" },
    { "3BDB96FF80B1FE451F870031C164093772130F9000F4", "French ID Card 2021 (eID)\nhttps://ants.gouv.fr/Les-titres/Carte-nationale-d-identite/La-puce-de-la-nouvelle-carte-nationale-d-identite" },
    { "3BDB96FF8131FE4580670534B50201064081051B", "SINA STARCOS 3.5 BX-CombiCard+HSB (Other)" },
    { "3BDB96FFC01031FE4580671501B403000900810521", "Digital Tachograph Card for Professional Driver\nolish driver card for digital tachograph" },
    { "3BDC1802C10A31FE588031A873B0019B2460071320AA", "Public Services Card | Ireland (Other)\nhttps://psc.gov.ie/" },
    { "3BDC18FF8011C18073C821136605036351000232", "GoTrust Idem Card (Other)\nhttps://www.gotrustid.com/idem-card" },
    { "3BDC18FF8091FE1FC38073C8211366010B0352000539", "Digital Signature Costa Rica (eID)" },
    { "3BDC18FF8091FE1FC38073C821136602040355000235", "ST security module for German smart meter gateway (JavaCard)\nhttps://www.bsi.bund.de/SharedDocs/Downloads/DE/BSI/Publikationen/TechnischeRichtlinien/TR03109/TR-03109-2-Anforderungen_an_die_Funktionalitaet.pdf?__blob=publicationFile&v=3" },
    { "3BDC18FF8111C18073C821136605036351000233", "GoTrust Idem Key  (Other)\nhttps://www.gotrustid.com/idem-key" },
    { "3BDC18FF8111FE8073C82113660106013080018D", "Aladdin R.D. JaCarta LT (eID)" },
    { "3BDC18FF8191FE1FC3060A2B06010401E910050203D1", "Caregiver card for Dutch Medical System called UZI (Unieke Zorgverlener Identificatie, Caring Unique Identification) (HealthCare)\nhttps://www.uziregister.nl/" },
    { "3BDC18FF8191FE1FC38073C821136601060130040155", "Athena IDProtect Key Laser" },
    { "3BDC18FF8191FE1FC38073C821136601061159000128", "JaCarta (PKI)\nhttp://www.aladdin-rd.ru" },
    { "3BDC18FF8191FE1FC38073C8211366010B0352000538", "Athena IDProtect Smart Card Logon Card" },
    { "3BDC18FF8191FE1FC38073C821136605024258000279", "NXP Athena SCS (PKI)" },
    { "3BDC18FF8191FE1FC38073C821136605036057000255", "NXP IDProtect (X) (JavaCard)" },
    { "3BDC18FF8191FE1FC38073C821136605036351000250", "JCOP3 SecID P60 CS (JavaCard)" },
    { "3BDC96FF8111FE8031C8544356300573FFA1C03B", "NXP Javacard with Athena SCS OS (JavaCard)" },
    { "3BDC96FF81B1FE431FC30B46415245474F53414D5632CC", "Penis (Pay TV)" },
    { "3BDD18008131FE4580F9A0000000770100700A90008B", "National ID Card of Peru issued by RENIEC from Oberthur" },
    { "3BDD18008131FE4580F9A000000077010800079000FE", "Oberthur Cosmo v7 IAS ECC\nBrazilian 'e-CNPJ' card, issued by Certisign (Oberthur)" },
    { "3BDD18008131FE45904C41545649412D65494490008C", "Identity card (eID) Republic of Latvia\nhttp://www.pmlp.gov.lv/lv/pakalpojumi/passes/eid.html" },
    { "3BDD18FFC080B1FE451FC30068D276000028040411009000C9", "Russian Federation driver card for the digital tachograph\nPolish driver card for digital tachograph" },
    { "3BDD18FFC080B1FE451FC30068D276000028040971009000A4", "Worktime/driving style monitoring card (Transport)\nhttp://www.paetronics.fi/en/" },
    { "3BDD96008010FE8031806301FFC073B3211B8105", "BIFIT iBank 2 USB Key (Bank)\nhttp://bifit.ua" },
    { "3BDD96008031FE450031B8640429ECC1739401808248", "Finnish Digital and Population Services Agency Organisation Card (eID)\nhttps://dvv.fi/en/organisation-cards" },
    { "3BDD960080B1FE451F8380640503040056564453414554FC", "VASCO DIGIPASS KEY 101 (Other)" },
    { "3BDD96008131FE4580F9A00000007701080007900070", "IDEMIA Cosmo v8.1-n (JavaCard)" },
    { "3BDD96FF801F034E5850204E53434F5320342E3006", "SCOSTA (Transport)" },
    { "3BDD96FF8131FE4580595F5374645F496E697481059B", "Karta kryptograficzna cryptoCertum 3.5 (PKI)\nhttps://www.certum.pl/pl/karty-do-czytnikow/" },
    { "3BDD96FF81B1FE451F03006404050803739621D0009000C9", "German public health insurance card ('Gesundheitskarte'), issuer Techniker Krankenkasse" },
    { "3BDD96FF81B1FE451F03006404050A02739621D0009000CA", "German public health insurance card ('Gesundheitskarte'), issuer Techniker Krankenkasse, issued 02/15 (HealthCare)" },
    { "3BDD96FF81B1FE451F030064057310A673D621C000900053", "New european health insurance card of the German health insurance" },
    { "3BDD96FF81B1FE451F038031B052010364041BB42281051B", "Austrian Motor Vehicle Registration Certificate (Transport)" },
    { "3BDD96FF81B1FE451F038031B052020364041BB422810518", "Austrian 'e-card' G3 (State Health Insurance Card)\n(running StarCOS 3.4 by Giesecke & Devrient)" },
    { "3BDD97FF81B1FE451F03006404050803739621D0009000C8", "German 'eGK' (State Health Insurance Card)" },
    { "3BDD97FF81B1FE451F0300640405080373969621D00090C8", "German public health insurance card ('Gesundheitskarte'), issuer Knappschaft" },
    { "3BDD97FF81B1FE451F03006404050A02739621D0009000CB", "German Elektronische Gesundheitskarte (eGK) (HealthCare)\nhttp://www.bmg.bund.de/en/health/the-electronic-health-card.html\nhttps://de.wikipedia.org/wiki/Elektronische_Gesundheitskarte" },
    { "3BDE11000049434F5335330000000000000008", "MyKID (eID)" },
    { "3BDE13000049434F5335330000000000000008", "Malaysian citizens under age of 12 including newborns (non-compulsory) (eID)\nhttps://en.wikipedia.org/wiki/Malaysian_identity_card#MyKid" },
    { "3BDE18FF8191FE1FC38031815448534D317380214081071C", "SmartCard-HSM 4K USB-Token (JavaCard)\nhttps://www.smartcard-hsm.com/features.html#usbstick" },
    { "3BDE18FF81F1FB34001F074445534669726553414D56312E30D2", "Mifare Desfire SAM Module" },
    { "3BDE18FF81F1FE43003F078344455346697265382053414D2D5817", "NXP SAM" },
    { "3BDE18FFC080B1FE451F034573744549442076657220312E302B", "Estonian Identity Card (EstEID v1.0 2006 cold)" },
    { "3BDE86FF9101F1FB34001F074445534669726553414D56312E305D", "Mifare Desfire SAM Module (after warm reset) (Other)" },
    { "3BDE96FF8191FE1FC38031815448534D3173802140810792", "SmartCard HSM (PKI)\nhttps://www.smartcard-hsm.com/" },
    { "3BDF18008131FE580031B964050E010073B401D300000022", "Identity Card in Slovakia with security chip and e-signature" },
    { "3BDF18008131FE588031905241016405C903AC73B7B1D444", "a.sign RK CHIP with certificate\nhttps://www.a-trust.at/webshop/Detail.aspx?ProdId=2021" },
    { "3BDF18008131FE588031B05202046405C903AC73B7B1D422", "Austrian 'e-Card' (=Health Card) of the 4th generation. (HealthCare)" },
    { "3BDF18008131FE58AC31B05202046405C903AC73B7B1D422", "e-Card Austria (HealthCare)" },
    { "3BDF18008131FE67005C49434DD49147D276000038330058", "Infineon SICRYPT Card Module D4 PC/SC Compliance Test Card" },
    { "3BDF18008131FE7D006B020C0182011101434E53103180FC", "Italian healtcare card (TS) National Service Card (CNS) (HealthCare)" },
    { "3BDF18008131FE7D006B040C0184011101434E53103180FC", "Italian healthcare card (TS) National Service Card (CNS) (HealthCare)\nhttp://www.regione.toscana.it/cartasanitaria" },
    { "3BDF18008131FE7D006B150C0180011101434E53103180E9", "Provider: Actalis S.p.A.\ncode: AT00006181\nhttp://www.actalis.it" },
    { "3BDF18008131FE7D006B150C0181011101434E53103180E8", "Italian healthcare card (TS) National Service Card (CNS)\nCarta Regionale dei Servizi - Regione Lombardia\nTuscany TS-CNS\nhttp://www.regione.toscana.it/cartasanitaria" },
    { "3BDF18FF8131FE4580590180484944433730307300011B33", "Crescendo C700 + MiFare 4K\nhttp://www.smartcardfocus.com/shop/ilp/id~265/p/index.shtml" },
    { "3BDF18FF8191FE1FC3003138644790ECC273140150829000BA", "Card store authentication and signature keys (JavaCard)\nhttps://ants.gouv.fr/Les-titres/Cartes-Agents/Adhesion/Telechargement-et-support" },
    { "3BDF18FF8191FE1FC30031B8640000EC0073940000829000FE", "NXP Jcop3 P60 ChipDoc v7b4 (JavaCard)\nhttps://www.javacardos.com/store/products/10029" },
    { "3BDF18FF8191FE1FC30031B86404216010739401C005900001", "Dutch Governement Identity Card using physical  (eID)\nhttps://nl.wikipedia.org/wiki/Rijkspas" },
    { "3BDF18FF8191FE1FC30031B8640C01ECC173940180829000B3", "ebee card\nhttps://www.ebeeoffice.ca/ebee-home/public\nDigital Signature Costa Rica (issued since 09/2019) (eID)\nhttps://www.mifirmadigital.go.cr/" },
    { "3BDF18FF81F1FE43001F034D494641524520506C75732053414D98", "Mifare SAM AV2" },
    { "3BDF18FF81F1FE43003F03834D494641524520506C75732053414D3B", "NXP SAM AV2 module" },
    { "3BDF18FF81F1FE43003F03834D4946506C75732053414D3B53414D3B", "Mifare SAM -AV2 (PKI)" },
    { "3BDF18FF81F1FE43003F07834D49464152452053414D204156333011", "NXP SAM AV3 module" },
    { "3BDF94FFC080B1FE451F03006AD2760000280415FA10040090006B", "UK Digital Tacho card (Other)" },
    { "3BDF94FFC080B1FE451F03006AD2760000280415FA40040090003B", "DVLA Company Card (Transport)" },
    { "3BDF9500801F878031A073FF21006345B105830F900060", "FUTURE CARD Normal ISO SIM (Telecommunication)" },
    { "3BDF9500801F878031A073FF21006345B309830F90006E", "Card Mobilis Algeria telecom (Telecommunication)\nhttp://www.mobilis.dz" },
    { "3BDF9500801FC38031E073FE211B674C455441323135BD", "SK Telecom SIM card (in Korea) (Telecommunication)\nhttp://www.sktelecom.co.kr/" },
    { "3BDF95FF8091FE1FC349445044554F33475049544356008029", "Generic Card NFC (eID)" },
    { "3BDF95FF8091FE1FC38025A0000000685319000173C8211329", "CardLogix Credensys-J Contacted Java Card 2.2.1 Global Platform 2.1.1 (Atmel AT90SC12872RCFT)\n(bank)" },
    { "3BDF96008031FE450031B864041FECC173940180829000EC", "Ministry of Interior - France 'Agent Card'\n(Carte Agent du Ministere de l'Interieur Francais)" },
    { "3BDF96008031FE450031B8640429ECC173940180829000DA", "Finnish identity card given by the City of Helsinki to all members of city council, board and commitees" },
    { "3BDF960080B1FE451F830012276F5741495242555331079000EA", "IDEMIA ID-One Cosmo V8.2 IAS ECC card (eID)" },
    { "3BDF960080B1FE451F838073BC9180F9A00000007780080201A4", "Latvian eSignature card (eID)\nhttps://www.lvrtc.lv/e-signature.html" },
    { "3BDF960080B1FE451F870031C16408923201738421E0059000C5", "Company Card for Transport companies (Transport)" },
    { "3BDF96008131FE4541434F532D4944303032382E3031366F", "Sri Lankan driving license [ web: motortraffic.gov.lk ] (eID)\nhttp://www.motortraffic.gov.lk/web/index.php?option=com_content&view=article&id=83&Itemid=140&lang=en" },
    { "3BDF960081B1FE451F838073CC91CBF9A0000003080000100079", "Test PIV Cards available for sale from NIST\nhttp://csrc.nist.gov/groups/SNS/piv/testcards.html" },
    { "3BDF96FF8131FE455A018048494443313158587300011B09", "HID Crescendo iCLASS Px G8H" },
    { "3BDF96FF8131FE4580590180504956434C41537300011BDE", "HID Global pivCLASS v1.0 (PKI)\nhttp://www.hidglobal.com/products/cards-and-credentials/pivclass/pivclass-smart-card" },
    { "3BDF96FF8131FE45805B44452E42415F53433335328105B5", "Employee ID card from the Federal Employment Agency (Germany) (PKI)\nhttps://www.pki.arbeitsagentur.de/" },
    { "3BDF96FF8131FE45805B44452E424E4F544B3130308105A0", "BeA - Certification Card for German Solicitors (Other)\nhttps://bea.bnotk.de/" },
    { "3BDF97008131FE588031B05202056405A100AC73D622C021", "Austrian healthcare insurance identification card (HealthCare)\nhttps://www.chipkarte.at" },
    { "3BDF970081B1FE451F838073CC91CBF9A0000003080000100078", "NASA PIV Card (Other)" },
    { "3BE000008131204030", "SmarTEC" },
    { "3BE000FF8131FE4514", "'JUKICARD', digitally sign tax documents in Japan" },
    { "3BE20000402049..", "Schlumberger Cryptoflex 4k" },
    { "3BE2000040204905", "Schlumberger Cryptoflex DES" },
    { "3BE2000040204906", "Schlumberger Cryptoflex" },
    { "3BE2000040204907", "Schlumberger Cryptoflex Key Generation" },
    { "3BE200FFC11031FE55C8029C", "Aladdin eToken PRO (USB token)\nSiemens CardOS M4.0" },
    { "3BE300FF9181712644000113202D", "Metrebus Card\n(used in Rome to store personal information and Atac subscription.\nAtac is the public transport company of the city of Rome.)\nhttp://www.atac.roma.it/smart/smart.asp?A=2&S=22&PR=4&LNG=2" },
    { "3BE500008121459C100100800D", "BIN 470132 -- BANK OF AMERICA VISA DEBIT -- GEMALTO MGY 0 U1090788B - 12/14 F8 00 89 (Bank)" },
    { "3BE500008131FE45D00037008089", "ATM card for Standard Chartered, Taiwan" },
    { "3BE500FF8131FE458073C601082D", "MUFG (.jp) (Bank)" },
    { "3BE6000080318066B1A30401110B83009000", "VISA Credit Card (Bank)" },
    { "3BE60000812145324B010101017A", "Axalto Cyberflex Palmera V5" },
    { "3BE600FF8131FE4544492030324D70", "Alior Sync (Poland) - MasterCard Debit Card with PayPass (Bank)\nMasterCard Contactless Debit Card issued by Raiffeisen Bank in Czech Republic\nDebit MasterCard with paypass issued by Bank Zachodni WBK (Poland)\nDebit MasterCard with paypass issued by AliorSync" },
    { "3BE600FF8131FE454449203032566B", "VISA credit card (DKB)" },
    { "3BE600FF8131FE454A434F50303307", "IBM JCOP 30/16" },
    { "3BE600FF8131FE454A434F50313005", "IBM JCOP 10/16\nRental card for Blockbuster, Taiwan" },
    { "3BE600FF8131FE454A434F50323006", "IBM JCOP 20/16\nIBM JCOP20 with MIFARE\nor Datakey Smart Card Model 330J\nhttp://www.datakey.com/products/smart_cards/products_sc_330j.shtml" },
    { "3BE600FF8131FE454A434F50323107", "IBM JCOP ID21" },
    { "3BE600FF8131FE454A434F50333007", "Mifare ProX T=1" },
    { "3BE600FF8131FE454A434F50333106", "IBM JCOP 30/31bio (contact interface)" },
    { "3BE700008131FE4200639531059000B9", "Chunghwa Post Co., Ltd. Visa Debit Card (Bank)\nhttp://www.post.gov.tw/post/internet/U_english/index.jsp?ID=24030107" },
    { "3BE70000918131FE410110300100908049", "'FirmenTicket' from the 'Rheinbahn' for the 'VRR'\nits a ticket corporates can buy for their employees. so its called\n'FirmenTicket'. 'Rheinbahn' is the local service operator for the\nmass traffic in and around duesseldorf/germany. 'VRR' is traffic\nnetwork spanning over at least a big part of north rhine westphalia\n(Verkehrsverbund Rhein-Ruhr)\nhttp://www.vrr.de/de/tickets_und_tarife/vielfahrer/firmenticket/index.php" },
    { "3BE700FF8131FE454430382E30203657", "EMV (MasterCard) card, issued by Raiffeisen Bank in Russia\n'Deutsche Kreditbank AG' Visa Card produced by AustriaCard GNC\nAll cards (MasterCard, Maestro, VISA Electron) issued by Raiffeisen Bank in Romania\nEMV (MasterCard) Card, issued by Raiffeisen Bank in Czech Republic" },
    { "3BE700FF8131FE454430382E31203656", "WinWin Austria Player-ID-Card (Other)\nhttps://www.winwin.at/" },
    { "3BE700FF8131FE454430382E32203655", "Mastercard (Bank)" },
    { "3BE700FF8131FE454D43412038203652", "Mastercard credit card issued by 'PayLife Bank GmbH'.\nBank number is '5266' - Bawag PSK." },
    { "3BE700FF8131FE458031C073C62148BE", "Japanese ETC (Electronic Toll Collection System) card (Transport) and Credit card (Issuer: Toyota) (Transport)" },
    { "3BE700FF81B1FE451F018031C073C6214820", "Japanese ETC (Electronic Toll Collection System) card (Transport)" },
    { "3BE8000040FA0073C84011009000", "KEBTechnology KONA USB SmartCard (Other)" },
    { "3BE80000813120450073C8400000900056", "Visa credit card for Standard Chartered, Taiwan" },
    { "3BE800008131FE00506572736F53696DAA", "Simulated virtual smartcard, from project PersoSim (eID)\nhttps://persosim.de/?q=node/33" },
    { "3BE800008131FE450073C8400000900088", "VISA Card (Skandinaviska Enskilda Banken) with Swedish BankID\nVISA card (Chinatrust Bank (Taiwan), dual-interface card with a Taipei Metro e-purse function)" },
    { "3BE800008131FE454A434F50763234....", "NXP JCOP v2.4.x (see hist bytes for more info)" },
    { "3BE800008131FE454A434F5076323431B4", "VISA Debit card for NAB, Australia" },
    { "3BE800FF8131FE43AA00000000000000B0", "Secure Signing Token (eID)" },
    { "3BE800FF8131FE45434C6169726520361A", "DKB Visa card with PayWave" },
    { "3BE90000812145454D565F41545220066C", "VISA card, issued by HVB Bank Czech Republic or austrian BankAustria\nhttp://www.hvb.cz" },
    { "3BE900008121454D435F5F494E46200665", "MasterCard Credit card issued by SpareBank1 in Norway\nhttp://www.sparebank1.no" },
    { "3BE900008121455649535F494E46200678", "VISA card, issued by the Austrian 'Raiffeisen' bank\nhttp://www.raiffeisen.at/\nVisa Card - Maximum - Oyak Bank / Turkey\nVISA, issued by Austrian bank 'Erste Bank'\nVISA card, issued by the Latvian bank 'Latvijas Krajbanka'" },
    { "3BE900008131FE00FF506572736F53696D54", "German PersoSim (eID)\nhttps://persosim.secunet.com/en/" },
    { "3BE900008131FE4543443169A90000000014", "Mastercard credit card, UBS Switzerland (Bank)" },
    { "3BE900008131FE45434432690900000000B7", "Swiss UBS MasterCard Creditcard" },
    { "3BE900008131FE45454D5620303320200699", "Visa credit card\nMasterCard credit card" },
    { "3BE900008131FE45454D5630325F34530680", "Maestro Card issued by 'First Investment Bank' in Bulgaria\nhttp://fibank.bg/\nVisa Electron card: TATRA BANKA, a.s." },
    { "3BE900008131FE454A434F503130563232A3", "ORGA Open Platform DES 16k V2.0 / JCOP10" },
    { "3BE900008131FE454A434F503234325232A0", "NXP J3D081 (JavaCard)" },
    { "3BE900008131FE454A434F503331563232A0", "JCOP 31 / 72k" },
    { "3BE900008131FE454A434F503431563232A7", "IBM JCOP v2.2 41" },
    { "3BE900008131FE454D434120303320200688", "PayLife Gold MasterCard -- an unbranded version of the master card" },
    { "3BE900FF8131FE45434C6169726532203629", "UB(SK) Visa Vusiness card with PayWave (Bank)\nhttps://www.vub.sk/en/companies-entrepreneurs/cards/debit-cards/visa-business/" },
    { "3BE900FF8131FE45434C6169726533203628", "BZ WBK Mastercard (Bank)" },
    { "3BE900FFC11031FE5500640500C80231800047", "Identity card of Italian Republic" },
    { "3BE900FFC11031FE55C80120504E34303132AD", "Siemens CardOS/M 3.0 (SLE66CX160S)" },
    { "3BEA0000813120438065A2........72D6....", "IDClassic 3XX Cards (with MPCOS Applet)" },
    { "3BEA0000813120438065A20101013D72D643A5", "GemXpresso Pro R3 32PK (MPCOS, T=1) (warn reset)" },
    { "3BEA00008131FE450031C173C840000090007A", "Nigerian eID Card (cold reset)\nChip is NXP JCOP 2.4.1R3" },
    { "3BEA00008131FE45436F6D624F5320494900FE", "UBS VISA Gold Card\nMasterCard from lhv.ee\nNordea Bank Finland PLC Estonian Branch (ABnote)" },
    { "3BEA00008131FE454A434F5033315632333290", "NAB VISA Debit card" },
    { "3BEA00008131FE454A434F5034315632323195", "HID Crescendo C700\nhttps://www.hidglobal.com/products/cards-and-credentials/crescendo/c700" },
    { "3BEA00FF813120750064051401023100900027", "GCOS-MDK" },
    { "3BEA00FF8131FE455455422D434B010301007B", "Technische Universitat Berlin - Campus Karte\nMaybe Sm@rtCafe Expert 2.0 (Giesecke & Devrient)\nor GemXpresso 211 PK (Gemplus)\nIncludes a Mifare-Chip (1 KB - Memory-Chip)" },
    { "3BEB0000813120454A434F503331333647445478", "card for testing (eID)" },
    { "3BEB0000813142454E4C436853434B303430312B", "Dutch University accesscard & Electronic purse & telphone card" },
    { "3BEB0000813142454E4C4368697070657230310A", "Dutch Post (Chipper)" },
    { "3BEB00008131FE450031C0643F680102079000B6", "Chris firstbank (Bank)" },
    { "3BEB00008131FE450031C0643F6801020F9000BE", "VISA Debit card for Taishin International Bank, Taiwan (Bank)" },
    { "3BEB00008131FE450031C0643F680108079000BC", "Debit Mastercard of Mega ICBC, Taiwan (Bank)\nhttps://www.megabank.com.tw/en-us/english/credit-card" },
    { "3BEB00008131FE450031C064A9EC010082900023", "Junta de Extremadura (Spain) public healthcare card (HealthCare)\nhttps://saludextremadura.ses.es/web/preguntas-frecuentes" },
    { "3BEB00008131FE45436F6D624F5320312E3015C5", "Reka Card - Swiss Holiday Member Card (Loyalty)\nhttps://reka.ch/en/rekamoney/privatepersons/reka-card/Seiten/reka-card.aspx?lang=en" },
    { "3BEC00004032424C554520445241474F4E20430001", "Pay TV" },
    { "3BEC00004032544954414E49554D00110106", "Titanium high security access smartcard (the back says something about 'DoorCard') (Other)" },
    { "3BEC00004032544954414E49554D00130202", "Titanium 2 Card Pirat Card for Seca 2 / Viaccess 2004 (Pay TV)" },
    { "3BEC00FF8131FE45A0000000563333304A330600A1", "Datakey model 330J card, www.datakey.com\nhttp://www.hmk.de/downloads/datakey/Model_330J_Smart_Card.pdf\nModel 330J JavaCard v2.1.1\nGlobal Platform v2.0.1 specifications.\nJCCOS operating system applet (Java-based Cryptographic Card Operating System)" },
    { "3BED000080318065B0840100C883009000", "Optelio Cards (D38-D72 R6) T=1 Normal Speed" },
    { "3BED00008131204380318065B083......830090....", "IDClassic 3XX / Classic TPC (IXS, IS, IS V2, IS CC, IM, IM CC, IM CC V3) / MultiApp ID Cards" },
    { "3BED00008131204380318065B08302047E8300900032", "Latvian Digital Signature Card (warm)\nhttp://www.eme.lv/" },
    { "3BED00008131804280318065B0872701BC830890007D", "EMV (V PAY) Issued by UniCredit Bulbank Bulgaria\nGXP7 T=1" },
    { "3BED00008131804280318065B0894001F28300900052", "VISA Debit card for Taishin International Bank, Taiwan" },
    { "3BED00008131FE450031C071C6644D3533560F900046", "Kostadin (Bank)" },
    { "3BED00008131FE450031C071C6644D35354D0F9000", "ING Credit Card (Bank)\nhttps://www.ing.nl/particulier/betalen/creditcards/index.html" },
    { "3BED00FF813120754D424320534D502056312E3130BD", "Used to Control a Laser Device" },
    { "3BEE00008131804280318066B0840C016E01830090008E", "MultiApp Cards (Easy 72K Type B and Combi 72K Type B)\nE.SUN Commercial bank debit master card (Bank)\nTaiwan EasyCard (Transport)\nhttps://www.easycard.com.tw/english/index.asp" },
    { "3BEE00008131804380318066B1A1110100F683009000", "Optelio/Desineo Cards (D72 FXR1)" },
    { "3BEE00008131804380318066B1A11101A0F683009000", "Optelio D72 FXR1 (MD) T=1" },
    { "3BEE00008131FE45003180718665016702A00A8390001B", "IBM JCOP 'Java Card 2.1.1' et 'Open Platform 2.0.1'" },
    { "3BEE00008131FE4580318066409093060F1783019000FD", "Health insurance (HealthCare)" },
    { "3BEE00008131FE4580318066409093060F17830F9000F3", "IC card for the National Health Insurance, Taiwan" },
    { "3BEF..0040148025434552455357....0101039000", "Electronic Identification Card from the FNMT, the Spanish Official\nCertification Authority (Fabrica Nacional de Moneda y Timbre)\nFNMT-Ceres Siemens Infineon SLE 19" },
    { "3BEF..0040148025434552455357....0102039000", "FNMT-Ceres Siemens Infineon SLE 20\nFabrica Nacional de Moneda y Timbre" },
    { "3BEF000081312049005C5043541027F8D27600003833004D", "Infineon Technologies PC/SC Compliance Test Card V1.0" },
    { "3BEF000081314069005C50435335C53AD27600003833000F", "Siemens Nixdorf Sicrypt" },
    { "3BEF00008131FC4580318065110113000153414345810421", "Slovenska sporitelna (SLSP) Bank card, Maestro Card with chip" },
    { "3BEF00008131FC4580318065111123100253414345810412", "VISA card issued by UBS, Switzerland" },
    { "3BEF00008131FE450031C173C8211064474D313600900067", "ING Gold Credit Card (Italy) (Bank)\nhttps://www.ing.it/" },
    { "3BEF00008131FE45417441434F53322E345345204C6337C9", "Maestro Polish Alior debit card (Bank)" },
    { "3BEF00008131FE4543443269A98100002020202020200090", "UBS Switzerland Mastercard credit card (Bank)" },
    { "3BEF00008131FE4543443369098000002020202020200030", "Nordea Credit Gold MasterCard (Bank)\nhttp://www.nordea.ee/Private+customers/Daily+banking/Cards/Nordea+Gold/67062.html?lnkid=frontpage_teaser_GOLD_30-07-2014" },
    { "3BEF00008131FE45434D425F436F6D4444413030353500F7", "Master Card (emitted by bank Nordea - Lithuania)" },
    { "3BEF00008131FE45434D425F436F6D5344413030343000E4", "VISA (Danske Bank Eesti / www.sampopank.ee)" },
    { "3BEF00008131FE45434D425F436F6D5344413030353100E4", "Visa (Sampo Estonia, 2010)" },
    { "3BEF00008131FE45436F6D624F53205620202020202000AD", "Corporate Credit Card - SIEMENS MasterCard issued by Degussa Bank (Bank)" },
    { "3BEF00008131FE45436F6D624F53205649202020202000C4", "VfB Stuttgart Fankarte (pay card for the football stadium of the german club VfB Stuttgart)" },
    { "3BEF00008131FE45444C415A46545632444944313030FF06", "Lufthansa ID Card (eID)" },
    { "3BEF00008131FE4546494F4D4B5F3030312030313041009C", "MasterCard/PayPass Card issued by Czech FIO Banka a.s. (contact chip)\nnote the ASCII string ' FIOMK_001 010A' embedded in ATR" },
    { "3BEF00008131FE65005C504353D19147D276000038330070", "Siemens/Infineon Sicrypt S26381-F252-V1 GS:03" },
    { "3BEF00008131FE67005C49434DDBC97ED27600003833001E", "Infineon SICRYPT CardModule Card" },
    { "3BEF00FF8131..456563", "Debit card (Germany): ec-cash, GeldKarte(DEM), Maestro, Cirrus" },
    { "3BEF00FF81312045426173696343617264205A43322E33BD", "ZeitControl BasicCard Enhanced 2.3" },
    { "3BEF00FF81312045426173696343617264205A43332E33BC", "Electronic Purse (Elton Senegal)" },
    { "3BEF00FF81312075426173696343617264205A43332E338C", "ZeitControl BasicCard Enhanced 3.3" },
    { "3BEF00FF81312075426173696343617264205A43332E3788", "ZeitControl BasicCard Enhanced 3.7" },
    { "3BEF00FF81312075426173696343617264205A43332E3986", "ZeitControl BasicCard Enhanced 3.9" },
    { "3BEF00FF81314245.*38", "UNI-Card" },
    { "3BEF00FF8131424565630302030280002240489596002028", "Scard Sparkasse Detmold, Deutschland BLZ 47650130" },
    { "3BEF00FF81315045426173696343617264205A43312E31CC", "ZeitControl BasicCard Compact 1.1" },
    { "3BEF00FF813150456563............................", "GeldKarte v2 (Germany)" },
    { "3BEF00FF8131504565630000000000000000000000000000", "Geldkarte v2" },
    { "3BEF00FF813150456563080B40028000081520033604007E", "old banking card (electronic-card / Maestro / Geldkarte) of the\nStadt-Sparkasse Duesseldorf (like the above, but old - around 2002)." },
    { "3BEF00FF8131504565630D24200280000508335610010243", "German ec card" },
    { "3BEF00FF813152454D46432049424D2034304839363031FB", "IBM MFC 3.5 file system smart card\n(Card from the book 'Smart Card Application Development Using Java')" },
    { "3BEF00FF8131604565630402110000000000A532A50111B6", "GledKarte\nSiemens M3-Module with a Motorola SC-28.\nG&D (Giesecke&Devrient) Geldkarten-OS mit der Version 11" },
    { "3BEF00FF813160456563060314025000065108115E014190", "Geldkarte from Deutsche Bank, Thomson-Chip" },
    { "3BEF00FF8131664549424D204D46433430303230383331A1", "IBM MFC 4.1 file system smart card\nCard from the book 'Smart Card Application Development Using Java'\nauthors: Uwe Hansmann, Martin. S. Nicklous, Thomas Schack, Achim Schneider, Frank Seliger" },
    { "3BEF00FF813166456563202049424D20332E3120202020", "IBM eCash" },
    { "3BEF00FF813166456563202049424D20332E3120202020CF", "IBM eCash" },
    { "3BEF00FF8131864549424D204D4643343030303038333143", "ComCard MFC 4.1" },
    { "3BEF00FF8131FE4541434F53204449616E6131204C63364E", "comdirect VISA card (Bank)\nhttps://www.comdirect.de/konto/karten.html#Visa-Karte" },
    { "3BEF00FF8131FE4541434F53204449616E6132204C63364D", "Alior Bank SA (Bank)\nhttps://www.aliorbank.pl/" },
    { "3BEF00FF8131FE4565630D12810156001F00006686080122", "Commerzbank signature card SECCOS (6 or 7) providing RAH security profile (Bank)\nhttps://www.chipkartenleser-shop.de/commerzbank/electronic-banking-chipkarten/commerzbank-signaturkarte-2710050006" },
    { "3BEF00FF8131FE4565631104010280000F274000030100E1", "Postbank Geldkarte" },
    { "3BEF00FF8131FE4565631104010280000F462004230100C4", "Postbank ec/Maestro (Germany)" },
    { "3BEF00FF8131FE4565631108430250001021200324053016", "Bank (Bank)" },
    { "3BEF00FF8131FE456563111261025000100A072722071022", "DKB Online Banking Card (Bank)\nhttps://www.dkb.de" },
    { "3BEF00FF8131FE456563111261025000100A07811C0710BA", "German Sparkasse HBCI card (Bank)\nhttps://www.sparkasse.de/service/finanzlexikon/hbci-verfahren.html" },
    { "3BEF00FF8131FE4565631113710528001F00010228372060", "MasterCard of SpardaBank Hamburg in Germany (Bank)\nhttps://www.sparda-bank-hamburg.de" },
    { "3BEF00FF8131FE4565631113710528001F0006124137201E", "BankCard Sparda-Bank Baden-Wurttemberg eG (Bank)" },
    { "3BEF00FF8131FE4565631113710528001F0007241A372072", "Commerzbank Maestro Card (Bank)\nhttp://www.maestrokarten.de/girokontovergleich/commerzbank_girokonto.html" },
    { "3BEF00FF8131FE4565631113710528001F00083B3C372044", "Comdirect Debit Card Germany - AustriaCard 55616 (Bank)\nhttps://www.comdirect.de/" },
    { "3BEF00FF8131FE4565631113710528001F000A1B18372042", "German debit card (girocard, V-Pay) (Bank)\nhttps://www.girocard.eu/english/" },
    { "3BEF00FF8131FE4565631113710528001F000B161C37204A", "Commerzbank / girocard /maestro (Bank)" },
    { "3BEF00FF8131FE4565631113710528001F000D163A37206A", "BankCard Sparda-Bank West eG (Bank)" },
    { "3BEF00FF8131FE4565631113710528001F00120F24372072", "Debit card (Germany): Postbank - GeldKarte (EUR), girocard, V-PAY (Bank)" },
    { "3BEF00FF8131FE4565631113710528001F00153D47372024", "Girocard issued by Comdirect bank AG (Bank)" },
    { "3BEF00FF8131FE4565631113710528001F00193516372071", "Commerzbank Germany (Bank)" },
    { "3BEF00FF8131FE4565631114710528001F00024D36371005", "comdirect girocard (Bank)\nhttps://www.comdirect.de/konto/karten.html#girocard" },
    { "3BEF00FF8131FE4565631114710528001F0003443137100A", "DKB Banking Card (Bank) (Bank)\nhttps://www.dkb.de" },
    { "3BEF00FF8131FE4565631114710528001F00034A36371003", "German Sparkasse, Girocard, GeldCard, girogo, EUROSERV (Bank)" },
    { "3BEF00FF8131FE4565631114710528001F0005210F371057", "girocard maestro Bank (Bank)\nhttps://www.girocard.eu/" },
    { "3BEF00FF8131FE4565631114710528001F0006302F371065", "MasterCard German Sparkasse (Bank)" },
    { "3BEF00FF8131FE4565631114710528001F0006543137101F", "Sparkasse (Bank)" },
    { "3BEF00FF8131FE4565631114710528001F00071D46371020", "DKB (Deutsche Kreditbank) debit card (V-PAY) (Bank)" },
    { "3BEF00FF8131FE4565631114710528001F000A1E1337107B", "girocard (Bank)" },
    { "3BEF00FF8131FE4565631114710528001F000B361B37105A", "Kreissparkasse bank Girocard (Germany) (Bank)\nhttps://www.kskmse.de/de/home/privatkunden/girokonto/girokonto-online.html?n=true&stref=productbox" },
    { "3BEF00FF8131FE4565631114710528001F000C1A1737107D", "Bank card issued by Sparkasse (Bank)" },
    { "3BEF00FF8131FE4565631114710528001F000C2024371074", "Debit card (Germany): ec-cash, GeldKarte(EUR), Maestro, Cirrus, ... (Bank)" },
    { "3BEF00FF8131FE4565631114710528001F000C3D35371078", "Sparkasse KolnBonn Bank (Bank)\nhttps://www.sparkasse-koelnbonn.de" },
    { "3BEF00FF8131FE4565631114710528001F0010142437105C", "Deutsche Kreditbank AG (Bank)\nhttps://www.dkb.de/" },
    { "3BEF00FF8131FE4565631114710528001F00113B32371064", "DKB GiroCard (Bank)\nhttps://dkb.de" },
    { "3BEF00FF8131FE4565631114710528001F00172846371005", "Sparkasse Zwickau Maestro card (Bank)\nhttps://www.spk-zwickau.de/de/home/privatkunden/girokonto/sparkassencard.html" },
    { "3BEF00FF8131FE4565631114710528001F00180F48371023", "SparkassenCard (Bank)\nhttps://sparkasse.de" },
    { "3BEF00FF8131FE4565631114710528001F0018242A37106A", "Sparkasse girocard (Bank)" },
    { "3BEF00FF8131FE4565631114710528001F00182D1C371055", "Debit card (Germany): ec-cash, GeldKarte(EUR) (Bank)" },
    { "3BEF00FF8131FE456563111562025000100A002B2107201E", "EC Card Sparkasse Mittelfranken Sued (Bank)\nhttps://www.spkmfrs.de" },
    { "3BEF00FF8131FE456563111562025000100A09AC030720B2", "Girocard Sparkasse Darmstadt (Bank)" },
    { "3BEF00FF8131FE4565631901620280000F003500420620BB", "Credit card (Germany, Postbank AG): VISA" },
    { "3BEF00FF8131FE4565631D028402500023180920E7010121", "Deutsche Kreditbank AG (DKB AG) bank card (Bank)\nhttps://www.dkb.de/info/tan-verfahren/chipTAN/" },
    { "3BEF00FF8131FE458031C06B49424D204A65745A204D3239", "UBS Internet Card (IBM JetZ M2)" },
    { "3BEF00FF8131FE458031E06B042105026B55555555555568", "MasterCard credit card for Mega International Commercial Bank, Taiwan (Bank)\nhttps://www.megabank.com.tw/creditcard/index.asp" },
    { "3BEF00FF8131FF6549424D204D4643393232393238393017", "IBM MFC 4.22 (University of Cambridge smartchip card)" },
    { "3BF01200FF9181B17C451F019B", "Japanese Chijou Digital B-CAS Card (pay TV) (Pay TV)" },
    { "3BF01200FF9181B17C451F0399", "Japanese Chijou Digital B-CAS Card (pay TV)" },
    { "3BF01200FF9181B1EF451F030A", "Japanese Digital CATV C-CAS card" },
    { "3BF01300001000", "MasterCard ETEC InterOp 27. This is an dual-app Maestro/MasterCard Credit EMV test card" },
    { "3BF01300008131FE45E8", "Healt care card Romania (HealthCare)\nhttp://www.cnas.ro/casmb/national-page/cardul-national-de-asigurari-de-sanatate-2.html" },
    { "3BF01300FF9181B1FE461F0319", "Japan BS/CS 4K Satellite Broadcasting A-CAS Card (Pay TV)\nhttp://www.acas.or.jp/index.html" },
    { "3BF2180000C10A31FE55C80675", "HID iCLASS P16K C4H\nproximity card used for both door locks and keystore" },
    { "3BF2180002C10A31FE55C80776", "Siemens CardOS V4.3" },
    { "3BF2180002C10A31FE58C80874", "Siemens CardOS V4.3B\nD-Trust multicard 2.1 (may only be the testcard for it)" },
    { "3BF2180002C10A31FE58C80975", "Siemens CardOS V4.2B" },
    { "3BF2180002C10A31FE58C80B77", "CardOS V4.2C (SLE66CX360PE dual interface)" },
    { "3BF21800FFC10A31FE55C8068A", "Siemens CardOS M 4.2 (SLE66CX642P)" },
    { "3BF2960000813180438031A6", "Card of Justice (Other)" },
    { "3BF29800FFC11031FE55C80315", "Siemens CardOS M 4.01 (SLE66CX320P)" },
    { "3BF29800FFC11031FE55C80412", "CardOS M4.01a (SLE66CX322P)" },
    { "3BF39600FFC00A31FE4D8031E083", "MARX Cryptoken (supported by RaakSign)" },
    { "3BF41300008131FE4552465A4FED", "Serbian Health Care electronic card (HealthCare)\nhttp://www.rfzo.rs/index.php/osiguranalica/ekartica" },
    { "3BF4180002C10A31FE5856346376C5", "Eutron CryptoIdentity (reader + card token)" },
    { "3BF41800FF8131805500318000C7", "Identity card of Italian Republic" },
    { "3BF49800FFC11031FE554D346376B4", "Eutron Digipass 860 (reader + card token)" },
    { "3BF51300008131FE4573746431308F", "card for NF-e in Brazil (PKI)\nhttps://certificadodigital.imprensaoficial.com.br/certificados-digitais/e-cnpj/a3/e-cnpj-a3-cartao" },
    { "3BF51800008131FE454D794549449A", "Aventra ActiveSecurity MyEID\nhttp://www.aventra.fi/pdf/ActiveSecurity%20MyEID%20Tokens%20white%20paper%20(2p)%20EN.pdf" },
    { "3BF518000210804F73454944", "Atmega 128 microcontroller based open source EID smartcard with RSA and ECC.  (eID)\nhttps://oseid.sourceforge.io/" },
    { "3BF57100FFFE2400011E0F3339320103", "Mydo IC Card from Japan, based on NTTDATA CARD (Loyalty)\nhttps://www.idemitsu.com/company/history/13.html" },
    { "3BF59100FF918171FE40000A086E773A65", "iCLASS Card (Other)" },
    { "3BF59100FF918171FE4000410000000005", "Contactless Mifare Ultralight" },
    { "3BF59100FF918171FE400041080000000D", "Contactless Mifare" },
    { "3BF59100FF918171FE400041180000001D", "Contactless Mifare 4k" },
    { "3BF59100FF918171FE400041880000008D", "Contactless Mifare 1k or 4k" },
    { "3BF59100FF918171FE4000420001008186", "American Express Blue RFID" },
    { "3BF59100FF918171FE400042000100D1D6", "Japanese Public Key Infrastructure (PKI)\nhttps://www.jpki.go.jp/\nMy Number Card (The Social Security and Tax Number System in JAPAN) (eID)\nhttps://www.cao.go.jp/bangouseido/" },
    { "3BF59100FF918171FE400042000177D1A1", "German Passport (ePass) (issued May 2008)" },
    { "3BF59100FF918171FE4000420001B3A115", "Individual Number Card (eID)\nhttps://www.kojinbango-card.go.jp/" },
    { "3BF59600008.31FE454D794549441.", "MyEID card (Infineon chip) (PKI)\nhttps://services.aventra.fi/English/products_MyEID_E.php" },
    { "3BF61800FF8131FE454A32413038301B", "NXP J2A080 - 80K (blank)\nhttp://www.classic.nxp.com/acrobat_download2/literature/9397/75016728.pdf" },
    { "3BF61800FF8131FE454A434F5032300E", "IBM JCOP20" },
    { "3BF61800FF8131FE454A434F5033300F", "Philips P8RF5016 running IBM JCOP 30 (contact interface)" },
    { "3BF61800FF8131FE454A434F5033310E", "IBM JCOP BIO31\nIBM JCOP BIO31 Java card" },
    { "3BF71100008131FE6543616E6F6B657999", "Canokey (Other)\nhttp://canokeys.org/" },
    { "3BF711000081718042000063950A019000B9", "ATM Card for Chunghwa Post Inc., Taiwan" },
    { "3BF71100008171FE420000639501019000CC", "ATM Card for Mega International Commercial Bank, Taiwan\nATM card for HSBC Direct, Taiwan\nATM card for TaChong Bank, Taiwan\nATM card for Chunghwa Post, Taiwan\nVISA card for Taipei Fubon Bank, Taiwan\nATM card for Cathay United Bank, Taiwan (Bank)\nhttps://www.cathaybk.com.tw/cathaybk/english/eindex.htm" },
    { "3BF71100008171FE420000639531029000FF", "VISA card for Taipei Fubon Bank, Taiwan" },
    { "3BF71100008171FE420000639531049000F9", "E.SUN Bank, Taiwan (Bank)\nhttps://www.esunbank.com.tw" },
    { "3BF71100008171FE420000639531059000F8", "ATM card for Chunghwa Post, Taiwan\nATM card for E.Sun Commercial Bank, Taiwan\nATM card for Taishin International Bank, Taiwan\nATM card for Bank of Taiwan, Taiwan\nATM card for Land Bank of Taiwan, Taiwan" },
    { "3BF711000140965430040E6CB6D6", "Atmel (FunCard) Smart Card with AT90S8515 and 24LC64 chip on it (Other)\nhttp://docs-europe.electrocomponents.com/webdocs/1173/0900766b811730a2.pdf" },
    { "3BF711000140965430040E6CB6D69000", "PIC16F876-04/SP (PICCard2) or\nPIC16F84A-04/P + 24LC16B (PICCard1) or\nCanal + Canal Digital Spain year 2000/2001 or\nPIC Silver Card 2 (PIC16F876/7 + 24C64)" },
    { "3BF711000140965760140E6CB6D6", "old SECA of D+ Italian sat pay tv" },
    { "3BF711000140965842140E6CB6D6", "UK on digital (terrestrial digital TV card)" },
    { "3BF711000140966060060E6CB6D6", "CANAL+ CANALSATELLITE SmartCard (possibly from 2005) (Pay TV)" },
    { "3BF711000140967070070E6CB6D6", "Cyfra+ SECA Card\nhttp://cyfraplus.pl/" },
    { "3BF711000140967070070E6CB6D69000", "M-II (a.k.a. M-2, a.k.a. Platinum Card), AT90SC6464C based\nKnotCard II\nTitaniumElite" },
    { "3BF7110001409670700A0E6CB6D6", "TopUp TV NagraVision viewing card" },
    { "3BF7110001409670700A0E6CB6D69000", "Canal Digitaal (Pay TV)\nhttp://webshop.canaldigitaal.nl/nl/smartcards-2" },
    { "3BF711000140967070170E6CB6D6", "Canal Satellite card (VERSION 7.1 SYSTEM / SECA2)" },
    { "3BF711000140967070370E6CB6D6", "Carte pour decodeur cable numerique (fourni par www.voo.be et\nwww.ledecodeur.be)" },
    { "3BF711000140967070670E6CB6D6", "UK TopUp TV" },
    { "3BF711000140967071090E6CB6D6", "Carte pour decodeur tele de Neuf Telecom TV" },
    { "3BF71300008131FE45464F4D534F4D53A9", "Health card Russian Federation" },
    { "3BF71300008131FE454A434F503234....", "NXP JCOP v2.4.x (see hist bytes for more info)" },
    { "3BF71800008031FE45736674652D6E66C4", "SmartCafe Expert 3.2 72K" },
    { "3BF71800008031FE45FE42475265494424", "Bulgarian eID PKI card pilot on IFX SLE78 jTOP (PKI)" },
    { "3BF71800008131FE458055433776706B28", "Only labeled 'J35110', dual interface (JavaCard)" },
    { "3BF718000081718042000063840C019000A7", "Citibank Taiwan ATM Card (Bank)\nhttps://www.citibank.com.tw/" },
    { "3BF718000081718042000063950A019000B0", "7-Eleven icash card, Taiwan" },
    { "3BF79100FF918171FE40000A0260CF5104CB7F", "UK Metro Bank Mastercard Debit (Bank)\nhttps://www.metrobankonline.co.uk/" },
    { "3BF79100FF918171FE40004120001177818040", "Contactless Mifare DESFire" },
    { "3BF81100008171FE4200544E051900000002A1", "Taiwan EasyCard (Transport)\nhttps://www.easycard.com.tw/english/index.asp" },
    { "3BF811200340FF0303030312109000", "Bar Ilan KesefCard from Bezeq (Other)\nhttps://halemo.net/web/www.aurora.co.il/english/c_kesefcard.html" },
    { "3BF811200340FFFFFFFFFF12109000", "G&D (STARCOS SV 1.1)" },
    { "3BF81300008131FE15597562696B657934D4", "Yubico Yubikey 4 OTP+CCID" },
    { "3BF81300008131FE4546494445534D4F318E", "Fidesmo Card with Dual Interface (JavaCard)\nhttp://shop.fidesmo.com/product/fidesmo-card-dual-interface" },
    { "3BF81300008131FE454A434F50763234....", "NXP JCOP v2.4.x (see hist bytes for more info)" },
    { "3BF81300008131FE454A434F5076323431B7", "Nigerian eID Card (blank card)\nChip is NXP JCOP 2.4.1R3" },
    { "3BF81300008131FE454A4F5076323431B7", "Nigerian eID card (eID)" },
    { "3BF81300008131FE455049564B45593730FF", "PIVKey CP70 (PKI)\nhttps://pivkey.com/" },
    { "3BF81300008131FE455241414B43327635CB", "Raak C2 Smart Card (PKI)\nhttp://www.raaktechnologies.com/software-downloads-documentation/" },
    { "3BF81300008131FE45534B555001000000FC", "Silesian Card of Public Services (Transport)\nhttps://portal.kartaskup.pl/" },
    { "3BF81300008131FE45536D617274417070F8", "national Lithuania ID card" },
    { "3BF81300008131FE45FF4A32413034300012", "MIDAS Card Diversification Key JavaCard (J2A040) (Bank)\nhttps://github.com/kategray/midas" },
    { "3BF81800008031FE450073C8401300900092", "G&D StarSign Token" },
    { "3BF81800008131FE450073C8400000900080", "NXP JCOP 31 V2.2 36K - S/C I/F" },
    { "3BF81800008131FE450073C8401300900093", "Giesecke & Devrient Sm@rtCafe Expert 3.0" },
    { "3BF81800008131FE454A434F50563234319C", "NXP JCOP2.4.1\nJ3A080 80KB T=1 GP2.1.1 JC2.2.2 SCP02" },
    { "3BF81800008131FE454A434F5076323431BC", "NXP J2A080 JavaCard" },
    { "3BF81800FF8131FE450073C840000090007F", "NXP JCOP 10\nNXP JCOP 31 (contact interface)" },
    { "3BF81800FF8131FE454A434F507632343143", "VIVOtech SAM\nNXP JCOP V241\nNXP J3A081 JavaCard (contact interface)" },
    { "3BF89600008131FE4400739401C00F9000DD", "fourth-generation Hong Kong permanent identity card (Other)\nhttps://en.wikipedia.org/wiki/Hong_Kong_identity_card" },
    { "3BF89600008131FE454A434F507632343132", "NXP JCOP 2.4.1 (JavaCard)" },
    { "3BF91100008131FE45436F6D624F53205600AA", "VISA Card (Bank)" },
    { "3BF91300008131F0454E425502000320000097", "Bank" },
    { "3BF91300008131FE45454F4E436172645631F6", "NXP J2A080 (PKI)\nhttp://www.smartcardsource.com/contents/en-ca/d9_JCOP-NXP-cards.html" },
    { "3BF91300008131FE454A434F503234........", "NXP JCOP v2.4.x (see hist bytes for more info)" },
    { "3BF91300008131FE454A434F503431563234A2", "JCOP41 v2.4" },
    { "3BF91300008131FE454A434F5076323431B701", "J2A040 NXP (JavaCard)\nhttps://secure.smartcardsource.com/j2a040-java-smart-card.html" },
    { "3BF91300008131FE45535049564B45593730AD", "PIVKey T840 (Other)\nhttps://pivkey.com/" },
    { "3BF91300FF10808031E0554245524753", "Banrisul bank" },
    { "3BF91500FF910131FE43806448657261829000C7", "RC-S500 card (FeliCa SAM for reader?) (Other)" },
    { "3BF918000000534345372003002046", "G+D FIPS 201 SCE 7.0 (PKI)" },
    { "3BF91800008031FE4580574E454F574156457D", "Neowave Weneo" },
    { "3BF91800008131FE45393532383530313331DA", "JCOP31 / 72B1 V2.2 (4096 RSA key support)\nSmartcard Dual Interface JCOP31 with 72KB EEPROM and V2.2 Java Card Open Platform" },
    { "3BF91800008131FE454A32443038315F5056B6", "NXP J2D081 Java Card 80KB  JCOP 2.4.2 R2 GP 2.2.1 JC 3.0.1 (JavaCard)\nhttp://www.javacardsdk.com/Index.aspx?p0=AAT1P0000012&p1=1&p2=1&p3=1&p4=0&p5=1" },
    { "3BF91800008131FE454A434F503231563232A9", "NXP JCOP 21 V2.2 36K" },
    { "3BF91800008131FE454A434F503331563232A8", "JCOP31 / 72B1 V2.2\nSmartcard Dual Interface JCOP31 with 72KB EEPROM and V2.2 Java Card Open Platform" },
    { "3BF91800008131FE454A434F503431563232AF", "JCOP41 Cards (not supported, but recognized by Classic Client)\nNHS Care Identity Service (CIS) smartcard (HealthCare)\nhttps://www.e-lfh.org.uk/programmes/national-ra-and-smartcard-policy/" },
    { "3BF91800008131FE4550565F4A3244303831B6", "Taiwanese Health Professional Card(TW HPC) (HealthCare)\nhttps://hca.nat.gov.tw/Intro.aspx" },
    { "3BF91800FF8131FE4550565F4A334130343040", "Yubico Yubikey NEO OTP+U2F+CCID (PKI)\nhttps://www.yubico.com/products/yubikey-hardware/yubikey-neo/" },
    { "3BF91800FF8131FE4550565F4A33413038314D", "NXP JCOP J3A081 (JavaCard)\nhttps://secure.smartcardsource.com/j3a081m.html" },
    { "3BF99100FF9181714040004180045B89BAB352803A", "mifare desfire 2k (eID)" },
    { "3BF99100FF918171FC40000A095161900058C290D2", "NFC PASS card (eID)" },
    { "3BF99400008131FE6546542056313030900083", "ePass 2000" },
    { "3BF99600008031FE454A546178436F7265560F", "Secure element for fiscal system in Serbia (PKI)" },
    { "3BF99600008031FE4553434537200000202027", "G&D SmartCafe Expert 7 (JavaCard)" },
    { "3BF99600008031FE4553434537200300204642", "ActivIdentity Activkey Sim (PKI)\nhttps://www.hidglobal.com/products/cards-and-credentials/activid/usb-tokens" },
    { "3BF99600008031FE4553434537200F0020464E", "Giesecke & Devrient (DoD Alternate Token) G+D Sm@rtCafe Expert v7.0 144K DI #3 (PKI)" },
    { "3BF99600008131FE45454F4E43617264563173", "eONCard V1 (PKI)" },
    { "3BF99600008131FE4553434537200E00202028", "Giesecke & Devrient GmbH StarSign CUT S" },
    { "3BF99600008131FE45535049564B4559373028", "Taglio PIVKey C980 (PKI)\nhttps://www.pivkey.com" },
    { "3BF99800FFC11031FE55414D20434D4431313083", "Service card of the Ministry of Defense of Italy - Military Aviation" },
    { "3BF99800FFC11031FE55454920434D4431313083", "Service card of the Ministry of Defense of Italy - Italian Army" },
    { "3BF99800FFC11031FE554D4D20434D443131308F", "Service card of the Ministry of Defense of Italy - Navy" },
    { "3BF99800FFC11031FE55504320434D443131309C", "Service card of the Ministry of Defense of Italy - Civil personnel" },
    { "3BFA..00008131..438065A2........72D6....", "IDClassic 3XX Cards (with MPCOS Applet)" },
    { "3BFA1100008131FE45436F6D624F5320495600E0", "MyWireCard 2go Prepaid VISA Card" },
    { "3BFA110002406043C602F8030300009000", "DeLaRue DX(?)" },
    { "3BFA1300008131FE15597562696B65794E454FA6", "Yubikey NEO" },
    { "3BFA1300008131FE450031C173C8400000900079", "Nigerian eID Card (warm reset)\nChip is NXP JCOP 2.4.1R3" },
    { "3BFA1300008131FE454465786120434620763198", "Dexa Systems Crossfire Card (PKI)\nhttp://www.dexasystems.com/products-services/products/dexa-smartcards-credential-tokens-peripherals" },
    { "3BFA1300008131FE454A434F503.3.56323332..", "JCOPxx/yy v2.3.2 (see hist bytes for more info)" },
    { "3BFA1300008131FE454A434F5032315632333191", "NXP JCOP 21 V2.3.1 36K" },
    { "3BFA1300008131FE454A434F5032315632343196", "NXP JCOP 2.1 V 2.4.1 (JavaCard)" },
    { "3BFA1300008131FE454A434F50343156", "JCOP41 V221" },
    { "3BFA1300008131FE454A434F5034315632333197", "JCOP41 /72K (eID)" },
    { "3BFA1300008131FE454A434F50763234........", "NXP JCOP v2.4.x (see hist bytes for more info)" },
    { "3BFA1300FF813180450031C173C00100009000B1", "OpenPGP" },
    { "3BFA1800008031FE45FE654944202F20504B4903", "Estonian Identity Card (EstEID v3.5 (10.2014) cold) (eID)\nhttp://id.ee/" },
    { "3BFA1800008131FE4506082A841001876E0805BC", "Dutch Rijkspas (eID)" },
    { "3BFA1800008131FE4506082A841001876E0807BE", "Rijkspas (identification card dutch government employees) (eID)\nhttps://nl.wikipedia.org/wiki/Rijkspas\nDutch government multifunctional smartcard (Other)\nhttps://nl.wikipedia.org/wiki/Rijkspas" },
    { "3BFA1800008131FE45060860841001876F0602FE", "Card used by the Dutch health insurers to give medical personell access to patient insurance information" },
    { "3BFA1800008131FE454A33413034305632343184", "NXP J3A 40K\nJava Card v2.2.2 - Global Platform v2.2.1\nDual-interface functionality (features 1K Mifare emulation)" },
    { "3BFA1800008131FE454A33413038315632343189", "NXP JCOP CJ3A081\nhttp://www.usmartcards.com/media/downloads/492/NXP%20P5CX012%2002X%2040%2073%2080%20144%20%20%202011.pdf" },
    { "3BFA1800008131FE454A434F503431563232319D", "NXP JCOP 41 v2.2.1 72k SmartCard I/F" },
    { "3BFA1800008131FE454A546178436F72655631B2", "Taxpayer Portal Authentication for Fiji Revenue & Customs Service taxpayer portal (PKI)" },
    { "3BFA1800008131FE454D4F54494F4E0000900760", "SIM card (Telecommunication)" },
    { "3BFA1800008131FE4550564A434F5033454D5694", "NXP JCOP3 J3H082 Java Card 3.0.4 Dual-Interface (JavaCard)\nhttps://www.cardlogix.com/product/nxp-jcop3-j3h082-java-card-3-0-4-j3h081-dual-interface/" },
    { "3BFA180000910131FE4550564A434F503453494482", "Supposed P71 SecID purchased from a Chinese manufacturer (JavaCard)" },
    { "3BFA180002C10A31FE584B53776973735369676E89", "SuisseId card (used for qualified signatures)\nhttp://postsuisseid.ch/de/suisseid\nhttp://www.suisseid.ch/" },
    { "3BFA1800FF10004A546178436F72655631", "NXP JCOP4 J3R200 P71 (JavaCard)" },
    { "3BFA1800FF8131FE454A434F5032315632333165", "TrubDemax healthcare card\nJCOP 21 / 72k" },
    { "3BFA1800FF8131FE454A434F5034314332303074", "HID Crescendo C200\nhttps://www.hidglobal.com/sites/hidglobal.com/files/resource_files/crescendo-c200-c700-smart-card-ds-en.pdf" },
    { "3BFA1800FF8131FE454A434F5034315632323162", "JCOP41\nHID Crescendo C700\nhttp://www.hidcorp.com/\nShould be compatible to RAAK\nhttp://www.raaktechnologies.com/\nMarx CrypToken MX2048-JCOP USB Token" },
    { "3BFA1800FF8131FE454A434F5034315632333163", "JCOP41 V2.3.1 Dual Interface, Mifare emulation, 72K (NXP SmartMX P5CT072)\nJCOP (Java Card OpenPlatform) is a Java smart card distributed and developed by NXP.\nThe JCOP 41 v2.3.1. is an USB-smart card and can be used not only with standard smart card reader, but also with simple USB-connectors. The JCOP card is connected as ICCD card and can be used with such ICCD standard drivers.\nJCOP 41 is a Dual-Interface Smart Card, that means, the card can also be contacted with a contactless card reader. For building access systems, this card is also be able to emulate Mifare Classic 1k/4k.\nJCOP 41 v2.3.1 is compliant to JavaCard Standard 2.2.1. and GlobalPlattform 2.1.1. Their cryptographic features supports RSA up to 2432 bit, 'Eliptic curves' - ECC GF(2n), AES and 3DES.\nMore information is available here:\nhttp://www.nxp.com/documents/short_data_sheet/P5Cx009_P5Cx072_FAM_SDS.pdf" },
    { "3BFA940000813120438065A20101013D72D64321", "GemXpresso Pro R3 32PK (MPCOS, T=1)" },
    { "3BFA9600008031FE450031C8239752270F9000C1", "Swedish ID card (eID)" },
    { "3BFA960000813180438065A20101013D72D64383", "Malta identity card delivered by the Identity Management Office (eID)\nhttps://mhas.gov.mt/en/MHAS-Departments/Land%20Public%20Registry/Pages/ID-MO.aspx" },
    { "3BFA9800FFC11031FE55C8035341475F504B493277", "Siemens corporate ID card (access to the building / rooms etc,\nstores PKI private keys/certificates)" },
    { "3BFA9800FFC11031FE55C8045341475F504B493270", "Siemens Corporate Card (Belgium , Germany)" },
    { "3BFB11000040288059535059525553AE0002", "Spyrus Rosetta Basic" },
    { "3BFB11000040788059535059525553AE0202", "Rosetta(r) Series II Smart Card manufactured by Spyrus\nhttp://spyrus.com/products/rosetta_smart_usb.asp" },
    { "3BFB1100008131FE450031C06477E910000090006A", "OCS ID-One Cosmo Card USB Token" },
    { "3BFB1100FF81318055006802001010534941450004", "Italian Society of Authors and Publishers ticket and report signing smart card (PKI)\nhttps://www.siae.it/en/utilizzatori/other-services-stamps-certifications-data-and-statistics/automated-ticket-issuing-systems" },
    { "3BFB1300008131FE454A434F50533.3.56323332..", "JCOP-Sxx/yy v2.3.2 (see hist bytes for more info)" },
    { "3BFB1300008131FE456368617269736D6174657884", "Charismathics smart card JCOP and Qualified electronic signature CHJCOP-xxx (PKI)\nhttps://www.stampit.org/en/page/808" },
    { "3BFB1300FF10800031C164086032060F9000", "Stripe Issuing Card (Bank)" },
    { "3BFB1300FF10800031C164086032100F9000", "Varo (Bank)" },
    { "3BFB1300FF813180755A43352E3520524556204763", "ZeitControl BasicCard 5.5" },
    { "3BFB1300FF813180755A43352E3620524556204D6A", "ZeitControl BasicCard ZC5.6 user-programmable smart card\nhttp://www.basiccard.com/index.html?overview.htm" },
    { "3BFB1300FF813180755A43362E3520524556204364", "ZeitControl BasicCard 6.5, multiapplication with 30 kByte EEPROM" },
    { "3BFB1300FFC0803180755A43352E34205245562041A5", "ZeitControl BasicCard Professional 5.4 Revision A" },
    { "3BFB1300FFC0803180755A43352E34205245562048AC", "ZeitControl BasicCard Professional 5.4" },
    { "3BFB1300FFC0803180755A43352E3420524556204DA9", "Basiccard ZC5.4 revision M (Other)\nhttp://basiccard.com" },
    { "3BFB1300FFC0807553544F4C4C4D31504C5553BD", "Stoll M1PLUS (Other)" },
    { "3BFB180000407880595350595255530B0003", "Spyrus, Inc. Rosetta USB (PKI)" },
    { "3BFB180000407880595350595255530B0402", "SPYRUS Rosetta Series 2 (eID)\nhttp://www.spyrus.com/rosetta-hsm/" },
    { "3BFB18000040788059535059525553AE0402", "Spyrus Rosetta Series II" },
    { "3BFB1800008131FE450031C06477E9100001900062", "ID card for personal of 'Govern Illes Balears'\nhttp://www.caib.es/sacmicrofront/contenido.do?cont=7584&mkey=M08110610180317195848&&lang=en" },
    { "3BFB1800008131FE454A33483134354337583330C6", "COTECH OpenPGP Card - ECC (PKI)" },
    { "3BFB9100FF918171FE40004120000100812063CBA08003", "C*******r, MasterCard credit card, Pass Banque, Oberthur - contactless/PayPass" },
    { "3BFB9600008031FE450031C06477E3020082900076", "Oberthur ID-One Cosmo" },
    { "3BFB9600008031FE450031C06477E3030081900074", "D.O.D. Eid Passport rapidgate card (eID)" },
    { "3BFB9600008131FE450031C06477E91000019000EC", "Oberthur ID-ONE v5.4" },
    { "3BFB9600008131FE450031C06477E910000F9000E2", "Elektroniczna Legitymacja Studencka - Polish Student's ID Issued in Poznan in 2007" },
    { "3BFB9600008131FE450031E85427E60100079000BC", "Gemalto (PKI)" },
    { "3BFB9600008131FE4556445349354001000400011F", "Vasco DIGIPASS KEY 200 usb token\nhttp://www.vasco.com/products/digipass/digipass_pki/digipass_pki_keys/digipass_key_200.aspx\nShould contain a 'Oberthur cosmo v 5.4 or V7.0D' smartcard" },
    { "3BFB9800FFC11031FE550064052047033180009000F3", "Gemplus GemGate 32K\ndistributed by Postecert (www.postecert.it) to legally sign documents" },
    { "3BFC1300008131FE15597562696B65794E454F7233E1", "YubiKey NEO (PKI)\nhttp://www.yubico.com/" },
    { "3BFC1300008131FE45597562696B65794E454F7233B1", "Yubikey Neo\nhttp://www.yubico.com/products/yubikey-hardware/yubikey-neo/" },
    { "3BFC180000813180459067464A00641606F2727E00E0", "PIVKey C910 PKI Smart Card (eID)\nhttp://pivkey.com/" },
    { "3BFC180000813180459067464A00642D70C172FEE0FE", "pivkey token (JavaCard)\nhttp://www.pivkey.com/" },
    { "3BFC180000813180459067464A0068080.000000000.", "Feitian A22 JavaCard (150K) (JavaCard)\nhttp://www.smartcardfocus.com/shop/ilp/id~712/javacos-a22-dual-interface-java-card-150k/p/index.shtml\nFeitian A40 JavaCard (64K) (JavaCard)\nhttp://www.smartcardfocus.com/shop/ilp/id~711/javacos-a40-dual-interface-java-card-64k/p/index.shtml" },
    { "3BFC180000813180459067464A01002005000000004E", "Feitian A40 (JavaCard)\nhttp://www.smartcardfocus.com/shop/ilp/id~711/javacos-a40-dual-interface-java-card-64k/p/index.shtml" },
    { "3BFC180000813180459067464A01002504000000004A", "Feitian JavaCOS A22CR ()\nhttp://www.javacardos.com/store/javacard-a22cr.php" },
    { "3BFC180000813180459067464A0100870600000000EA", "Feitian FTJCOS (https://www.ftsafe.com/products/Card_OS) (JavaCard)\nhttps://www.ftsafe.com/onlinestore/product?id=18" },
    { "3BFC180000813180459067464A01642F70C172FEE0FD", "Feitian eJavaToken (JavaCard)\nhttp://www.ftsafe.com/product/epass/eJavaToken" },
    { "3BFC1800008131FE458073C8211366020403550002D2", "National Health Insurance Card, Taiwan" },
    { "3BFC9800FFC11031FE55C803496E666F63616D65726528", "New Card Infocamere (Italy) series 1402...\nhttp://www.card.infocamere.it/\nSiemens Informatica - Siemens M4.01a\nchip Infineon SLE66CX322P (CC EAL5)\nMemory EEPROM: 32KB\nOperating system CARDOS\nMax numero dei tentativi PIN: 3\nPin: da 5 a 8 digit\nUnblocked by tool CARDOS API 2.2" },
    { "3BFD..00008131..4380318065B0........83..90....", "IDClassic 3XX / Classic TPC (IXS, IS, IS V2, IS CC, IM, IM CC, IM CC V3) / MultiApp ID Cards" },
    { "3BFD1300008131FE158073C021C057597562694B657940", "Yubico YubiKey 5 NFC (PKI)\nhttps://www.yubico.com/product/yubikey-5-nfc" },
    { "3BFD1300008131FE4500125553554D49444153000000F6", "Midas key diversification card (Other)" },
    { "3BFD1300008131FE4541373030354347203234325231D5", "Feitian ePass FIDO NFC (Other)\nhttps://www.ftsafe.com/Products/FIDO/NFC" },
    { "3BFD1300008131FE4541373030364347203234325231D6", "YubiKey NEO (token)" },
    { "3BFD1300008131FE454A434F50323176323331474454E1", "National Health Insurance Card, Taiwan" },
    { "3BFD1300008131FE45543D314A323133364B56323331DC", "ic Card (JavaCard)" },
    { "3BFD1800008031FE45003180718E6452D904008190005B", "Oberthur Card Systems, authentIC" },
    { "3BFD1800008031FE4553434536302D43443038312D46C4", "Panama Electronic Signature (JavaCard)" },
    { "3BFD1800008031FE45736674652063643134342D6E66D8", "SmartCafe Expert 3.2 144K Dual is a contact and contactless technology Java card from G&D with 144K on-board EEPROM for application and data storage. Certified to FIPS 140-2 Level 3 and Common Criteria EAL 5+. Supports specifications ISO 14443A T=CL and ISO 7816 T=1/0. (PKI)\nhttp://www.smartcardfocus.us/shop/ilp/id~523/smartcafe-expert-3-2-144k-dual/p/index.shtml" },
    { "3BFD1800008031FE45736674652D63643038302D6E66DC", "G&D Sm@Cafe 3.1 (eID)" },
    { "3BFD1800008131FE4553434536302D43433038312D46C2", "Giesecke & Devrient StarSign USB Token" },
    { "3BFD1800008131FE45534C4A35324778787979797A52AA", "The National Health Insurance Card issued by the National Health Insurance Administration Ministy of Health and Welfare in Taiwan (HealthCare)\nhttps://www.nhi.gov.tw/English/Content_List.aspx?n=320832076C00692B&topn=BCB2B0D2433F6491" },
    { "3BFD1800008131FE458031806540907B01518307900055", "Croatian Health Care card" },
    { "3BFD1800008131FE4580318153474531738421C081072E", "Georgian ID Card" },
    { "3BFD1800FF80B1FE451F078073002113574A5448613147005F", "Activkey Sim\nhttp://www.actividentity.com/products/activkey_usb_tokens__home.php" },
    { "3BFD1800FF80B1FE451F078073002113574A54486131480050", "G&D Sm@rtCafe Expert 64 v2" },
    { "3BFD1800FF80B1FE451F078073002113574A544861314A0052", "e-CPF issued by AASP (Lawyers Association of Sao Paulo, Brazil)" },
    { "3BFD1800FF8131FE4543494247555A494A324130383158", "Caregiver card for Dutch Medical System called UZI\n(Unieke Zorgverlener Identificatie, Caring Unique Identification)" },
    { "3BFD9100FF918171FE40004120004100818031C073D621C0D8", "Sparkasse Hanau - German contactless GeldKarte (PPSE, girogo)\nhttps://www.geldkarte.de/_www/en/pub/geldkarte/service_navigation/about_us.php" },
    { "3BFD9400008131204380318065B08302047E83009000B6", "GXPPRo-R3.x STD PTS T=1\nLatvian Digital Signature Card (cold)\nhttp://www.eme.lv/" },
    { "3BFD940000813160658031C0694D54434F5373010111E0", "MTCOS Light\nhttp://www.masktech.de/products/mtcoslight/index.html" },
    { "3BFD940000813160658031C0694D54434F5373010116E7", "Polish student card (eID)" },
    { "3BFD9500008131FE41008C0F17BD008C000000000030F2", "Khmer Identify Card (eID)" },
    { "3BFD9600008031FE45534C4A35324778787979797A5225", "TIPL (Other)" },
    { "3BFD9600008131204380318065B0831100C88300900015", "Gemalto TOP IM GX4 MSA081, T=1 (PKI)" },
    { "3BFD9600008131204380318065B0831148C883009000", "Pay TV" },
    { "3BFD9600008131484280318065B0840100C883009000", "Optelio Cards (D38-D72 R6) T=1 High Speed" },
    { "3BFD9600008131804380318065B0850100D683019000BC", "Queensland Drivers' Licence (Australia) (eID)" },
    { "3BFD9600008131FE4500000152332980000000000000A9", "DPI Guatemala (eID)\nhttp://www.renap.gob.gt/" },
    { "3BFD9600008131FE450000015233672000000000000047", "DPI Guatemala (eID)\nhttps://www.renap.gob.gt/servicios/que-es-el-dpi" },
    { "3BFD9600008131FE4500000161638620000000000000C5", "Renap Guatemala (eID)" },
    { "3BFD9600008131FE45534C4A353247444C313238435257", "Universal JCard (Contact) with Infineon SLE78 (JavaCard)\nhttp://www.usmartcards.co.uk/cards/universal-jcard-contact-with-infineon-sle78-white-gloss-pvc-card.html" },
    { "3BFE1300008131FE454A434F5076323431204C4F542057B1", "LOT test card (JavaCard)\nwww.lotgroup.eu" },
    { "3BFE1800008031FE454573744549442076657220312E30A8", "Estonian Identity Card (EstEID 3.0 'JavaCard' cold)" },
    { "3BFE1800008031FE4553434536302D43443038312D6E46A9", "G&D Sm@rtCafe Expert 6.0 (JavaCard)\nhttp://www.smartcardfocus.com/shop/ilp/id~684/smartcafe-expert-6-0-80k-dual-/p/index.shtml" },
    { "3BFE1800008031FE4553434536302D43443134352D6E46A0", "Smart Cafe Expert 6.0, Java Card 3.0 (PKI)" },
    { "3BFE1800008031FE45803180664090A4162A0083019000E1", "Estonian Identity Card (EstEID 3.0 'JavaCard' warm)" },
    { "3BFE1800008031FE45803180664090A4162A00830F9000EF", "iEstonian Identity Card (EstEID 3.0 (18.01.2011) warm)" },
    { "3BFE1800008031FE45803180664090A5102E03830F9000EF", "Infineon jTOP SLE78 SLJ52GCA080CL IFX v46.03 (JavaCard) (JavaCard)" },
    { "3BFE1800008031FE45803180664090A5102E038381900061", "Infineon Trust-P (JavaCard)" },
    { "3BFE1800008031FE45803180664090A5102E1083019000F2", "Infineon CJTOP 80K INF SLJ 52GLA080AL M8.4 (JavaCard)" },
    { "3BFE1800008131FE458031815448534D31738021408107FA", "Smartcard-HSM\nhttp://www.cardcontact.de/products/sc-hsm.html" },
    { "3BFE1800FF8131FE454A3231024103479049544356008044", "Brazilian Army ID Card (eID)" },
    { "3BFE1800FF8131FE456368616E67696E677465634A33445E", "xgames pki (eID)" },
    { "3BFE9100FF918171FE40004120001177C1000000000000000089", "Tangem Tap It cryptocurrency hardware wallet (Other)\nhttps://tangem.com/" },
    { "3BFE9100FF918171FE400041200051779180318065B0850300FB", " Italian Card Identity (CIE Comune di Parma) (eID)\nhttp://www.comune.parma.it/servizi/Servizi-Demografici-Carta-di-identita/Carta-di-identita-Elettronica-CIE_A2_C100_P96.aspx" },
    { "3BFE9100FF918171FE40004128000180810073C840000090004D", "Philips SmartMX chip (IBMs JCOP OS)" },
    { "3BFE9100FF918171FE40004128001133B04A434F5033315632C4", "JCOP31 72K\ndual interface functionality, 1K Mifare emulation." },
    { "3BFE9100FF918171FE400041380011F7B14A434F503234325211", "SwissPass (Transport)\nhttps://www.swisspass.ch" },
    { "3BFE9100FF918171FE40004138002180718066B00701010707B7", "Java Gemalto R7 (contactless) (Bank)" },
    { "3BFE9100FF918171FE40004138002180818065A2010201317210", "Santander TUI Brazil (Bank)\nhttp://www.santanderuniversidades.com.br/Paginas/home.aspx" },
    { "3BFE9100FF918171FE40004138002180818066B00701017707B7", "Java Gemalto R5 (contactless) (Bank)" },
    { "3BFE940000801F42803180664750204583018301900002", "TATA Docomo UICC (Telecommunication)\nhttp://www.tatadocomo.com/" },
    { "3BFE9400FF80B1FA451F034573744549442076657220312E3043", "Estonian Identity Card (EstEID v1.0 cold)\nEstonian Identity Card (EstEID v1.1 'MULTOS' warm)" },
    { "3BFE9600008031FE4380738400E065B0850400FB8290004E", "EU smart tachograph card (driver/company/control/workshop)\nhttps://dtc.jrc.ec.europa.eu/" },
    { "3BFE9600008131FE45803180664090A5102E03830190006E9000", "Swissbit PS-100u (JavaCard)\nhttps://www.swissbit.com/ps-100u/" },
    { "3BFE9600FF8131FE455DFF6D6553414D2076312E302E320C", "SAM module for Kharkiv E-ticket (mikroelektronika) (JavaCard)\nhttp://www.mikroelektronika.com/en/card-and-ticket-validators" },
    { "3BFE9600FFC00A31FE4D4573744549442076657220312E309B", "Estonian Identity Card (EstEID v1.1 compatible)\nhttp://www.id.ee/?id=11019&&langchange=1" },
    { "3BFF..00008131..4380318065B0........120FFE829000..", "IDPrime MD 8840, 3840, 3810, 840 and 830 Cards T=1" },
    { "3BFF..00FF8131..456563............................", "Debit card (Germany): ec-cash, GeldKarte(EUR), Maestro, Cirrus, ..." },
    { "3BFF0000FF8131FE458025A000000056575343363530000000", "SafeNet SC650" },
    { "3BFF00FF8131..456563............................", "Debit card (Germany): ec-cash, GeldKarte(EUR), Maestro, Cirrus, ..." },
    { "3BFF1100008131FE4D8025A00000005657444B3333300600D0", "Datakey 32K PKI Smart Card Model 330\nhttp://www.datakey.com/products/smart_cards/products_sc_330.shtml" },
    { "3BFF1100008171404200002101314252000[05]63........9000.*", "Smart Card 'The Smart Way to Login'\nUsed on Acer TravelMate to secure boot" },
    { "3BFF11000240648069A2070103570000FF0083009000", "Gemplus GemXpresso" },
    { "3BFF1100FF8131FE9580F9D2760000255444010083000000A0", "GiroCard Haspa Hamburger Sparkasse (Bank)\nhttps://www.haspa.de/privatkunden/ihr-online-banking/unser-angebot/haspa-digital-services-96198/" },
    { "3BFF1300008131FE450031B9640404ECC17394018082900052", "AKD kID (eID)\nhttps://www.id.hr" },
    { "3BFF1300008131FE450031B9640444ECC17394018082900012", "Croation personal ID card (eID)\nhttp://eid.hr/" },
    { "3BFF1300008131FE4543443269A94100002020202020200053", "Visa credit card (Viseca Card Services SA, Switzerland) (Bank)\nhttps://www.viseca.ch/privatkunden/kreditkarten\nVisa credit card, UBS Switzerland (Bank)" },
    { "3BFF1300008131FE45434433690940000020202020202000F3", "VISA credit card (LBBW/Payback VISA) (Bank)" },
    { "3BFF1300008131FE454F574F4B31302D4A................", "OWOK (One Web, One Key) login card\nhttp://www.reiner-sct.com/owok/\nReiner SCT loginCard\nhttps://cardlogin.reiner-sct.com/" },
    { "3BFF1300008131FE4D8025A00000005657444B3333300600D2", "Datakey DCOS model 330 (DKCCOS 6.0 token)" },
    { "3BFF1300FF10000031C173C821106441443533079000", "BRADESCO-CONTA SALARIO (Bank)" },
    { "3BFF1300FF10000031C173C8211064414D3330079000", "VISA card issued by ING-DiBa AG (Germany) (Bank)" },
    { "3BFF1300FF10000031C173C8211064414D3337079000", "VISA Credit Card (Postbank), Germany (Bank)" },
    { "3BFF1300FF10000031C173C8211064414D3341079000", "BBVA debit card Uruguay. MIFRE Plus compatible. (Bank)" },
    { "3BFF1300FF10000031C173C8211064414D3347079000", "Chase Visa Debit Card (Bank)\nhttps://www.chase.com/bankinghelp" },
    { "3BFF1300FF10000031C173C8211064414D3348079000", "BBVA blue VISA Debit Card  (Bank)\nhttps://www.bbva.es/en/personas/productos/tarjetas/tarjeta-joven-ahora.html" },
    { "3BFF1300FF10808031E06B04310502AF555555555555", "USAA EMV Visa Debit Card (Bank)" },
    { "3BFF1300FF10808031E06B071405028A555555555555", "Tangerine Debit Card (Bank)\nhttps://www.tangerine.ca" },
    { "3BFF1300FF10808031E06B08240502B5555555555555", "Tangerine Canada Interac debit card (Bank)\nhttps://www.tangerine.ca/" },
    { "3BFF1300FF8031FE45534653452D43583332322D5601010165", "Portugal Santander Totta Universitarios 'Associacao Academica de Coimbra'" },
    { "3BFF1300FF8031FE45534653452D43583332322D5618020876", "SmartCafe Expert Java" },
    { "3BFF1300FF8031FE45534653452D43583332322D5618030877", "Giesecke & Devrient SmartCafe Expert 32K v2.0 #2" },
    { "3BFF1300FF8131FE45656311045002800008390004020502E9", "German 'Geldkarte' supplied by the Deutsche Bank in Karlsruhe,\nBaden-Wurttemberg, Germany." },
    { "3BFF1300FF8131FE45656311045002800008540004230502A5", "Maestrocard/Geldkarte (Stadtsparkasse Haltern, Germany)" },
    { "3BFF1300FF8131FE5D8025A00000005657444B33323005003F", "Datakey DCOS model 320" },
    { "3BFF1300FF918131FE4541434F53204449616E6132204C6336DF", "Alior Bank MasterCard debit (Bank)" },
    { "3BFF1400FF8131FE458025A000000056575343363530010039", "SafeNet SC650 (PKI)\nhttp://www.safenet-inc.com/data-protection/authentication/smartcard-650/" },
    { "3BFF1400FF8131FE458025A000000056575343363530030239", "SafeNet SC650 v3.2 (PKI)\nhttp://www.safenetat.com/products-solutions/high-assurance-authentication/sc650/" },
    { "3BFF1400FF8131FE458025A00000005657534336353004003C", "SafeNet AT SC650 V4.0 02/2018 (PKI)\nhttps://www.safenetat.com/Solutions/Enterprise-Security/high-assurance-authentication/sc650/" },
    { "3BFF1800008131FE45006B04050100011101434E5310318069", "Sanitary Card of 'Friuli Venezia Giulia' region (Italian Republic)\nCarta Nazionale dei Servizi (Italia)\nhttp://cartaservizi.regione.fvg.it/" },
    { "3BFF1800008131FE45006B040501000112024850431031806C", "Carta del Professionista Sanitario - CNS - Provincia autonoma di Trento\nProfessional Health card, Autonomous Province of Trento" },
    { "3BFF1800008131FE45006B0405010001210143494510318048", "hybrid card for various health services and regional services (access to various organizations and digital signatures)" },
    { "3BFF1800008131FE45006B04050100012101434E5310318059", "CNS - Carta Nazionale dei Servizi (Italia)\nPA emittente: Regione Autonoma della Sardegna\nCarta del Servizio Sanitario Regionale - Emilia Romagna" },
    { "3BFF1800008131FE45006B05051017012101434E531031805E", "Regional Card - Regione Liguria, Veneto - Italy (eID)\nTessera Sanitaria - Carta Regionale dei Servizi" },
    { "3BFF1800008131FE45006B05052000012101434E5310318079", "health card (HealthCare)\nhttps://tscns.regione.sardegna.it/" },
    { "3BFF1800008131FE45006B11050700011101434E531131807B", "Italian National Fire Corps  -special identification card (eID)" },
    { "3BFF1800008131FE45006B11050700012101434E531031804A", "Oberthur ID-One Cosmo V7-n it's a java card 2.2.2\nIzenpe Certificado Ciudadano (eID)\nhttps://www.izenpe.eus/informacion/certificado-ciudadano/s15-content/es/" },
    { "3BFF1800008131FE4D8025A00000005657444B3430300600DD", "DataKey 400 (DK400)" },
    { "3BFF1800008131FE55006B02090403010101434E5310318065", "Italian Chambers of Commerce CNS (PKI)\nhttp://www.card.infocamere.it/infocard/pub/" },
    { "3BFF1800008131FE55006B0209040301010144534410318068", "ACA (Lawyer Identifier Card) (eID)" },
    { "3BFF1800008131FE55006B02090503010101434E5310318064", "Bit4id J-SIGN 2048 (L) (PKI)\nhttps://www.bit4id.com/en/j-sign/" },
    { "3BFF1800008131FE55006B02090603010101434E5310318067", "ST microelettronics JSign3 (HealthCare)" },
    { "3BFF1800008131FE55006B02091403010101434E5310318075", "Smart Card INFOCERT digital key CNS from CST PADOVA (eID)" },
    { "3BFF1800FF8031FE45534653452D43583332322D561803087C", "Giesecke & Devrient Sm@rtCafe Expert 2.0" },
    { "3BFF1800FF8031FE45536D4072744361666545787065727465", "Giesecke & Devrient SmartCafe 32K v1" },
    { "3BFF1800FF8131..456563............................", "Geldkarte (generic ATR)" },
    { "3BFF1800FF81313C4565630D02310250001090002600041009", "Maestrocard/Geldkarte (Postbank, Germany)" },
    { "3BFF1800FF81313C4565630D0231025000109001550004107B", "Volksbank VR-BankCard (GeldKarte)" },
    { "3BFF1800FF81313C4565630D02310250001090052900041003", "Geldkarte/HBCI(DDV-1) (Stadtsparkasse Vorpommern, Germany)" },
    { "3BFF1800FF81313C4565630D023102500010900788000410A0", "HBCI-Karte (Berliner Sparkasse, Germany)" },
    { "3BFF1800FF81313C4565630D023102500010901382000410BE", "Bremer Karte ('Geldkarte und BSAG-Kundenkarte in einem.')\nhttp://www.bsag.de/4911.php" },
    { "3BFF1800FF81313C4565630D0231025000109014060004103D", "Geldkarte/HBCI(DDV-1) (Staedtische Sparkasse Offenbach, Germany)" },
    { "3BFF1800FF81313C4565630D0231025000109014440004107F", "Geldkarte/HBCI (Kreissparkasse Ebersberg, Deutschland)" },
    { "3BFF1800FF81313C4565630D0231025000109055700004100A", "EC-Card from DKB (Deutsche Kreditbank AG)" },
    { "3BFF1800FF81313C4565630D02310280001224300020041059", "Geldkarte (Germany)" },
    { "3BFF1800FF813150456563............................", "GeldKarte v3 (Germany)" },
    { "3BFF1800FF8131FE4165630608710156000FB8602AA0471231", "Debit card (Germany): Postbank - GeldKarte (EUR), girocard, V-PAY (Bank)\nhttps://www.postbank.de/" },
    { "3BFF1800FF8131FE450031C573C00180547615020105900074", "SIGILANCE NFC OpenPGP Smart Card (JavaCard)\nhttps://www.sigilance.com/" },
    { "3BFF1800FF8131FE455448434331305445434F4744484E3224", "National Health Insurance Card, Taiwan" },
    { "3BFF1800FF8131FE455448434331305445434F4744494E3126", "National Health Insurance Card, Taiwan" },
    { "3BFF1800FF8131FE4565630D0450028000089009700005002A", "Landesbank baden-Wurttemberg Geldkarte" },
    { "3BFF1800FF8131FE4565630D07630528000D90810600061558", "Geldkarte/HBCI (Frankfurter Sparkasse, Germany)" },
    { "3BFF1800FF8131FE4565630D07630764000D........0615..", "Giesecke & Devrient GmbH\nROM Mask=SDP2G330.E_1 (BES0), SWP2G370.E_1 (CS0)\nInit-Table=ecD6.3\nSignaturerstellungseinheit ZKA TUVIT.09397.TU.03.2005 Banking Signature Card, v6.31 NP, Type 3\nTUVIT.09397.TU.03.2005" },
    { "3BFF1800FF8131FE4565630D07630764000D9058450006158C", "Stadtsparkasse Munchen electronic cash card / Geldkarte" },
    { "3BFF1800FF8131FE4565630D07630764000D907307000615E5", "Sparkasse Acchen HBCI Geld Karte" },
    { "3BFF1800FF8131FE4565630D07630764000D907432000615D7", "German HBCI-Banking Card with 'Geldkarte' from the bank 'Sparkasse Marburg-Biedenkopf'" },
    { "3BFF1800FF8131FE4565630D07630764000D90926100061562", "Geldkarte (Frankfurter Sparkasse, Germany)" },
    { "3BFF1800FF8131FE4565630D08650764000D........0616..", "Giesecke & Devrient GmbH\nROM Mask=ecD6.5\nInit-Table=SWP3G5J0.E_1 (CS0)\nSignaturerstellungseinheit ZKA Banking Signature Card, v6.51\nTUVIT.93129.TU.03.2006" },
    { "3BFF1800FF8131FE4565630D08650764000D9104900006160E", "German Railway's (Deutsche Bahn AG) 'Konzernausweis'" },
    { "3BFF1800FF8131FE4565630D0C760764000D9581200007300F", "Master Card Credit Card issued by WGZ bank (all german volksbank institutes use them)" },
    { "3BFF1800FF8131FE4565630D0C760764000D960361000730CF", "VR-Networld-Card with SECCOS-chip / Volksbank eG Konstanz\nfor Online-Banking (FinTS / HBCI-3.0 + EBICS; RD 01/12 NetWorld)" },
    { "3BFF1800FF8131FE456563110350028000082770020605018A", "old banking card (electronic-card / Maestro / Geldkarte) of the\n'Volksbank Gelderland eG' (around 2003)" },
    { "3BFF1800FF8131FE4565631105400250001055100303050043", "belongs to a banking card (electronic-card / Maestro / Geldkarte).\nthe bank calls it 'VR-BankCard'. the banks name is 'Volksbank\nGelderland eG' and is part of the 'Volksbanken und Raiffeisenbanken'\nhttp://www.vb-gelderland.de/html/5/2394/rubrik/1282.html" },
    { "3BFF1800FF8131FE45656311064002500010........0500..", "Gemplus-mids GmbH,\nROM Mask=ZKA 322 V5A,\nInit-Table=SWI1P070.E_0 (CS0),SDI1P080.E_1 (BES0),\nSignaturerstellungseinheit ZKASignaturkarte v5.02,\nTUVIT.09385.TU.09.2004" },
    { "3BFF1800FF8131FE4565631106400250001005500310050043", "HBCI-Karte (Bordesholmer Sparkasse, Germany)" },
    { "3BFF1800FF8131FE4565631106400250001019100420050028", "Stadtsparkasse Munchen HBCI card / Geldkarte" },
    { "3BFF1800FF8131FE4565631106400250001025600512050057", "Geldkarte/HBCI(DDV-1) (Stadtsparkasse Vorpommern, Germany)" },
    { "3BFF1800FF8131FE4565631106400250001027300216050006", "GeldKarte from Sparkasse bank" },
    { "3BFF1800FF8131FE4565631106400250001027800325050084", "Volksbank VR-BankCard (GeldKarte)" },
    { "3BFF1800FF8131FE456563110640025000102850011105006D", "HBCI Bancing Card of Sparkasse Pforzheim" },
    { "3BFF1800FF8131FE45656311066202800011........0613..", "Giesecke & Devrient GmbH\nROM Mask=ecD6.2,\nInit-Table=SDI1G280.E_1 (BES0),\nSignaturerstellungseinheit ZKA Banking Signature Card, v6.2b NP & 6.2f NP, Type 3\nTUVIT.09395.TU.01.2005" },
    { "3BFF1800FF8131FE4565631106620280001106600304061387", "Geldkarte (Volksbank Offenburg, Germany)" },
    { "3BFF1800FF8131FE45656311066202800011165005170613B2", "FinTS (BBBank Karlsruhe, Germany)" },
    { "3BFF1800FF8131FE456563110662028000112090030906135C", "Geldkarte [ec, Maestro] (1822 direkt Frankfurter Sparkasse, Germany)" },
    { "3BFF1800FF8131FE45656311066202800011435001170613E3", "EC-Card of Sparkasse Pforzheim Calw" },
    { "3BFF1800FF8131FE45656311075102500010728000020620C6", "Maestro Card Deutsche Kredit Bank (DKB) / Germany" },
    { "3BFF1800FF8131FE45656311076402800011........0619..", "Giesecke & Devrient GmbH\nROM Mask=ecD6.4\nInit-Table=SDI2G4G0.E_4 (BES0), SWI2G4H0.E_2 (CS0)\nSignaturerstellungseinheit ZKA 17.01.2006 Banking Signature Card, v6.4\nTUVIT.93123.TU.01.2006" },
    { "3BFF1800FF8131FE45656311084302500010........0530..", "Gemalto\nROM Mask=ZKA 680 V5A\nInit-Table=SSI3P3M6E_1 (MS0)\nMassen-Signaturerstellungseinheit ZKA Banking Signature Card, Version 5.11M\nTUVIT.93148.TU.06.2007" },
    { "3BFF1800FF8131FE4565631108430250001046500108053027", "HBCI-Karte (Sparkasse Altmark-West, Salzwedel, Germany)" },
    { "3BFF1800FF8131FE45656311084302500010847001040530C9", "HBCI Card (1822 direkt Frankfurter Sparkasse, Germany) Geldkarte [ec, Maestro]" },
    { "3BFF1800FF8131FE45656311086602800011........0620..", "Giesecke & Devrient GmbH\nROM Mask=ecD6.6\nInit-Table=SDI3G6G0.E_3 (BES0), SSI3G6M0.E_2 (S0), SWI3G6H0.E_3 (CS0)\nSignaturerstellungseinheit ZKA Banking Signature Card, Version 6.6\nTUVIT.93130.TU.05.2006 - 2. Nachbestatigung" },
    { "3BFF1800FF8131FE45656311086602800011405003180620D4", "banking card (electronic-card / Maestro / Geldkarte). the bank+calls\nit 'S-Card' or 'Sparkassen-Card'. the banks name is 'Stadtsparkasse\nDuesseldorf' and is part of the 'Sparkassen-Finanzgruppe' (a finance\ngroup, network of local banks)." },
    { "3BFF1800FF8131FE4565631108660280001156000318062092", "Geldkarte [ec, Maestro] (Sparkasse Langen-Seligenstadt, Germany)" },
    { "3BFF1800FF8131FE4565631901500280000F........0512..", "SAGEM ORGA GmbH\nROM Mask=SecV1.5.3\nInit-Table=SDR0O1G0.A_B (BES0), SWR0O1H0.A_5 (CS0)\nSignaturerstellungseinheit ZKA SECCOS Sig v1.5.3\nBSI.02076.TE.12.2006" },
    { "3BFF1800FF8131FE4565631A01410250001052090567051021", "Maestro/Geldkarte (BBBank Karlsruhe, Germany)" },
    { "3BFF1800FF8131FE55006B02090200010101434E531031809F", "Carta Nazionale dei Servizi - InfoCamere" },
    { "3BFF1800FF8131FE55006B0209020001010144534410318092", "Postcom S.P.A. (digital certificate)" },
    { "3BFF1800FF8131FE55006B02090200011101434E531031808F", "Carta Regionale dei Servizi - Regione Lombardia" },
    { "3BFF1800FF8131FE55006B02090200011101434E531131808E", "Infocamere CNS" },
    { "3BFF1800FF8131FE55006B02090300011101434E531131808F", "Card description: Multiservice Card - CMCC - Arma Carabinieri (Carta Multiservizi)" },
    { "3BFF1800FF8131FE55006B02090303010101434E531031809D", "Aruba CNS for Regione Toscana (IT)\nhttp://www.regione.toscana.it\nAruba CNS for Infocamere (the Chambers of Commerce)" },
    { "3BFF1800FF8131FE55006B0209030301010144534410318090", "Postecert (www.postecert.it) to legally sign documents" },
    { "3BFF1800FF8131FE55006B02090303011101434E531131808C", "Infocert 1205* smart card\nUniversita' Degli Studi di Torino (Infocert)" },
    { "3BFF1800FF8131FE55006B0209040301010144534410318097", "J-Sign (STMicroelectronics S.r.l. - Incard Division) (JavaCard)" },
    { "3BFF1800FF8131FE55006B02091300024954494420203180D3", "electronic identity card (PKI)" },
    { "3BFF1800FF8131FE55006B02091301011101434E531131809E", "Service card of the Ministry of Defense of Italy" },
    { "3BFF1800FF8131FE55006B0209130301000150534510318094", "Italian Electronic ID Card (eID)\nhttp://www.interno.gov.it/mininterno/site/it/temi/servizi_demografici/scheda_006.html" },
    { "3BFF1800FF8131FE55006B02091303010101434E531031808D", "Aruba Digital Signature (Other)\nhttps://www.pec.it/offerta-firma-digitale.aspx" },
    { "3BFF1800FF8131FE55006B02091303011101434E531131809C", "Politecnico di Torino Student Card (eID)\nhttp://www.polito.it/" },
    { "3BFF1800FF8131FE55006B02091617011101434E531131808D", "Carta Regionale dei Servizi - Regione Autonoma Friuli Venezia Giulia (HealthCare)\nhttps://www.regione.fvg.it/rafvg/cms/RAFVG/GEN/carta-regionale-servizi/" },
    { "3BFF1800FF8131FE55006B42495434494420312E3000900091", "Touch&Sign 2048 (PKI)" },
    { "3BFF1800FF8131FE55006B42495434494420322E3000900092", "Izenpe Green Card (Citizen Certificate) (eID)\nhttp://www.izenpe.com/s15-12020/en/contenidos/informacion/ciudadano/en_def/index.shtml" },
    { "3BFF1800FFC10A31FE55006B0508C805011101434E531031800C", "Carta Regionale dei Servizi - Regione Lombardia" },
    { "3BFF1800FFC10A31FE55006B0508C809011101434E5310318000", "Carta regionale dei servizi - Regione Sicilia\nhttp://www.regione.sicilia.it/crs/index.asp" },
    { "3BFF1800FFC10A31FE55006B0508C80A011101434E5310318003", "Carta Regionale dei Servizi - Regione Lombardia" },
    { "3BFF1800FFC10A31FE55006B0508C80C011101434E5310318005", "Healthcare card (TS-CNS) - Provincia Autonoma di Trento\nUnified Healthcare card (TS-CNS) - Repubblica Italiana" },
    { "3BFF32000010808031E05B4742500000000000000255", "UK NatWest BT PayToView Mondex" },
    { "3BFF6700008131FE45FF43727970746E6F784649444F32305F", "Fast Identification Online card (FIDO2) from Cryptnox manufacturer (Other)\nhttps://www.cryptnox.ch" },
    { "3BFF9100FF918171FC40000A654B5450304432654B5450043D5B62", "Indonesian eID (eID)" },
    { "3BFF94000000434D425F55425369676E3030303215", "UBS Access Card used for online banking with UBS in Switzerland.\nIt resides in a calculator like token, that is used for a challenge\nresponse when logging in." },
    { "3BFF940000400A80310073122113574A330E01314100", "O2 Loop SIM card" },
    { "3BFF940000400A80310073122113574A330E02314100", "GSM-SIM Beeline RU (Telecommunication)\nhttp://beeline.ru" },
    { "3BFF940000400A80310073122113574A330E02324100", "Turkcell SIMPlus64 / Turkey" },
    { "3BFF940000400A80310073122113574A330E10314100", "GSM SIM MEDIONmobile (MVNO) the Netherlands (Telecommunication)" },
    { "3BFF940000801F478031E073FE210000000000830F900052", "Telecommunication SIM (Telecommunication)" },
    { "3BFF9400008131804380318065B0850201F3120FFF82900079", "Serbian Identity Card (eID)\nJava Card (Sealys MultiApp ID v2.1) supporting Global Platform 2.1.1" },
    { "3BFF9400008131FE4380318065B0846160FB120FFD8290000E", "IDPrime 930 FIPS Level 3 (T=1 CT=94) (BAI4) (PKI)" },
    { "3BFF940000C00AB1FE491F438031E073F62113573436434132302068", "Sonera UICC (Telecommunication)" },
    { "3BFF9400FF400A80310073122113574A332009314100", "Globul GSM operator card (Bulgaria) (Telecommunication)" },
    { "3BFF9400FF80B1FE451F030068D276000028FE052231800090001E", "Alice Business card (to be used in the modem supplied by an Italian provider)" },
    { "3BFF9400FF80B1FE451F030068D276000028FF051E318000900023", "D-Trust Signature Card (www.d-trust.net):\n- Citizencard of the People of Ulm in Germany (Burgerkarte)\n- Qualified Electronic Signature Card (Qualifizierte Signaturkarte)" },
    { "3BFF9400FFC00A1F438031E073362113574A43491C3130321C", "Giesecke & Devrient - UniverSIM Pegasus" },
    { "3BFF9400FFC00A1F478031E073F62113574A33200B314141D4", "SIM  (Telecommunication)" },
    { "3BFF950000400A80310073122113574A330E10314100", "Verizon GSM SIM (Telecommunication)" },
    { "3BFF9500008031FE4380318067B0850201F3A3018301900045", "Swedish digital tachograph driver smart card (Other)\nhttps://www.transportstyrelsen.se/sv/vagtrafik/Yrkestrafik/Kor--och-vilotider/Fardskrivare/ansokan-om-forarkort/" },
    { "3BFF9500008031FE4380318067B0850201F3A3048301900040", "Company Card for authentication in tachograph applications (Other)\nhttps://ec.europa.eu/transport/modes/road/social_provisions/tachograph/tachonet_en" },
    { "3BFF9500008031FE4380318067B0850201F3A3138301900057", "Driver's Card (Tachograf card) issued by pwpw Poland (Transport)\nhttps://www.pwpw.pl/en/Products/Cards/Cards.html" },
    { "3BFF9500008031FE4380318067B0850201F3A3138301F83BFF", "UK Drivers Tachograph Card (Transport)" },
    { "3BFF950000C00A1F438031E073362113574A330E0231410088", "'BASE' SIM card; BASE is a german mobile phone operator, which is a brand of E-Plus, Germany." },
    { "3BFF95000150801C444E41535034323020526576533430F1", "NC+ Polland (Pay TV)\nhttp://www.flysat.com/ncplus.php" },
    { "3BFF95000150801C444E41535034323020526576533430F15D", "NC+ Polland (Pay TV)\nhttp://www.flysat.com/ncplus.php" },
    { "3BFF95000150801C444E41535034323020526576533441", "Platforma Canal+ Polska, cayman card (Pay TV)\nhttps://www.flysat.com/canalplus-pl.php" },
    { "3BFF9500FF400A803100731A2113574A504860314147", "Vodafone 64 KB SIM with Javacard" },
    { "3BFF9500FF400A8031E873F62113674A474860314200", "Giesecke & Devrient STARSIM" },
    { "3BFF9500FF50801C444E41535034303020526576493431", "Pay TV card nc+ polish (seca with merlin layer) (Pay TV)\nhttp://www.flysat.com/ncplus.php" },
    { "3BFF9500FF50801C444E41535034303020526576493435", "Decoder card for VOO TV distributer in Belgium (Pay TV)" },
    { "3BFF9500FF50801C444E41535034303020526576493439", "Big TV India (Pay TV)\nhttps://www.lyngsat.com/packages/Big-TV.html" },
    { "3BFF9500FF50801C444E41535034303020526576493441", "Pay TV - NC+ in Poland (Pay TV)\nhttp://ncplus.pl/" },
    { "3BFF9500FF50801C444E41535034303020526576493447", "Platforma Canal+ Polska, cameleon card (Pay TV)\nhttps://www.flysat.com/canalplus-pl.php" },
    { "3BFF9500FF50801C444E41535034303020526576493548", "Canal+ France Nagra3 (Pay TV)\nhttps://www.canalplus.com/" },
    { "3BFF9500FFC00A1F438031E073362113574A3320073341411F", "Swisscom 3G SIM card" },
    { "3BFF9500FFC00A1F438031E073F62113574A334857314141E5", "MTNL 3G USIM (India)" },
    { "3BFF9500FFC00A1F438031E073F62113574A334861324147D6", "GSM SIM (issued by e-plus, Germany)" },
    { "3BFF9500FFC00A1F438031E073F62113574A554860324100F6", "GSM SIM from O2 Germany (UMTS ready) from 2005" },
    { "3BFF9500FFC00A1F478031E073F62113574A33200B314141D5", "Telenor SIM card (Norway)" },
    { "3BFF9600008031FE45536D40727443616665204578702E374E", "haruka (eID)" },
    { "3BFF9600008131804380318065B0850300EF12026C829000F9", "Authorization Card (eID)" },
    { "3BFF9600008131804380318065B0850300EF120FFF82900067", "Greek Academic ID (eID)\nhttp://academicid.minedu.gov.gr/" },
    { "3BFF9600008131804380318065B0850300EF12FFFE82900096", "Gematlo IDCore 8030 (JavaCard)" },
    { "3BFF9600008131804380318068B0850300EF780100829000F1", "Cameroon National Identity Card (eID)" },
    { "3BFF9600008131FE4380318065B0845651101201788290006A", "SafeNet eToken 5300 (PKI)" },
    { "3BFF9600008131FE4380318065B08456511012021082900001", "Nedap NexS N:Secure (eID)\nhttps://www.nsecure.nl/nl/" },
    { "3BFF9600008131FE4380318065B0846160FB120FFD8290000C", "IDPrime 930 FIPS Level 2 (T=1 CT=96) (BAI3.1) (PKI)" },
    { "3BFF9600008131FE4380318065B085040011120FFF829000E0", "Pakistan National identity card (eID)" },
    { "3BFF9600008131FE4380318065B085040120120FFF829000D0", "Portuguese National Identity Card (eID) (eID)\nhttps://www.autenticacao.gov.pt/o-cartao-de-cidadao" },
    { "3BFF9600008131FE4580F9A0000003080000100053454E54AC", "cac (eID)" },
    { "3BFF9600008131FE55006B02090403010101434E53103180EB", "Aruba PEC SpA digital signature card made by Incard (eID)\nhttps://www.pec.it/download-software-driver.aspx" },
    { "3BFF9600FF8131FE4565630D09710764000D00035450070181", "Commerzbank ServiceCard / Maestro / GeldKarte / Cirrus / girocard / CashGroup / electronic cash" },
    { "3BFF9600FF8131FE4565631901500280000F002B0046501172", "Sparkasse Bremen Germany HBCI DDV" },
    { "3BFF9600FF8131FE4565631901500280000F002F0025501115", "German Postbank Giro card with electronic cash, Maestro, GeldKarte features" },
    { "3BFF9600FF8131FE4D8031E06B0431050277555555555555EA", "IRMA card (eID)\nhttp://irmacard.org" },
    { "3BFF9600FF8131FE55006B02090403010101434E5310318014", "JavaCard Bit4Id (JavaCard)" },
    { "3BFF9600FF918131FE4D8031E06B043105027555555555555579", "algeria national identity card (eID)" },
    { "3BFF9600FFC00A1F438031E073362113574A43491C3130321E", "Giesecke & Devrient - UniverSIM Pegasus" },
    { "3BFF9600FFC00A31FE4D8031E06B04310502A85555555555557E", "Multos (Other)" },
    { "3BFF9700008131FE4380318065B0846160FB120FFD8290000D", "IDPrime 3930 FIPS Level 3 (T=1 CT=97) (BAI6) (PKI)" },
    { "3F05DC20FC0001", "DigiCash Facility Card" },
    { "3F28000011140003689000", "SIMEMU - a DIY GSM SIM card\nhttp://simemu.cjb.net/" },
    { "3F2D0027A051827D00000052000C9000", "Porta Moedas Multibanco (Portugeese electronic purse)" },
    { "3F2F0036AF690204018000000A0E833E9F16", "SIM Card GSM (Telecommunication)" },
    { "3F2F008059AF0201013000000A0E83069F12", "Gemplus GemXplore" },
    { "3F2F008059AF02010230000C0A0E831E9F16", "GSM-SIM (900MHz) card of the carrier 'Mannesmann Mobilfunk' for\ntheir network 'D2-Privat' - now known as Vodafone Mobilfunk\nhttp://www.vodafone.de/" },
    { "3F2F008069AE0202013600000A0E833E9F16", "GSM-SIM e-plus (1800MHz)" },
    { "3F2F008069AF0204013600020A0E833E9F16", "GSM-SIM D2 CallYa (900MHz)" },
    { "3F2F008069AF0307015900000A0E833E9F16", "Nokia SIM Ph2 16K Ver2.0" },
    { "3F2F008069AF0307015900130A0E833E9F16", "Old Spanish Telefonica Movistar GSM SIM card manufactured by Gemplus" },
    { "3F2F008069AF0307015900240A0E833E9F16", "dialog romania now orange (Telecommunication)\nhttps://orange.ro" },
    { "3F2F008069AF0307035200000A0E833E9F16", "GemXplore 98 V1 16K" },
    { "3F2F008069AF03070352000D0A0E833E9F16", "GSM-SIM Debitel D2 (900MHz)" },
    { "3F2F008069AF0307035A00150A0E833E9F16", "Virgin Mobile SIM (Gemplus)" },
    { "3F36110053495B015153", "Sodexo Pass Lunch Card. An employee benefits card to provide meal tickets to workers. (Other)\nhttps://www.sodexo-benefits.it/prodotto/aziende/pausa-pranzo-aziende/pass-lunch-card/#tabsoluzioni" },
    { "3F3D1100806728500402200000838E9000", "GSM SIM card of the Austrian provider A1" },
    { "3F3E110046524543434941524F5353419000", "Trenitalia (Italy) fidelity card 'CartaFreccia' (Smartcard)" },
    { "3F3F94008069AF0307015900000A0E833E9F16", "Finnish SIM card from 'Radiolinja' now 'Elisa'" },
    { "3F6525....046C90.0", "Carte Bancaire (French banking card)" },
    { "3F65250024096B9000", "Old Postgirot/Plusgirot SmartSec bank ID card (Bank)" },
    { "3F65250024096E9000", "Oberthur Bull CP8 smart card. Russian 'Pochtovyj Bank' (Bank)" },
    { "3F6525002B09629000", "Coinamatic SmartyCity smartcard" },
    { "3F6525002B09699000", "Municipal parking meter card for the City of St. John's, NL, Canada.\nhttp://www.stjohns.ca/index.jsp" },
    { "3F6525002B09EB9000", "Bull Scot 5" },
    { "3F6525002[2C]09[F6]99000", "Sesam Vitale (French health card)" },
    { "3F65250052096A9000", "French carte Vitale" },
    { "3F6525005343689000", "'Flying Cow'- russian pirate CAM-card. (Pay TV)\nhttp://mxc.do.am/publ/collection/viewing_card_smart_karty_sputnikovogo_veshhanija/flying_cow_smart_card/13-1-0-25" },
    { "3F652500A[34]096A9000", "Sesam Vitale (French health card)" },
    { "3F6525082204689000", "France Telecom card (ex Pastel card)" },
    { "3F6525082304689000", "France Telecom card" },
    { "3F6525083304209000", "D-Trust card" },
    { "3F65250843046C9000", "CB visa La Poste France (Oberthur)\nCB visa Societe Generale France (Oberthur)" },
    { "3F65250863046C9000", "CB visa La Poste France (Oberthur)\nCB Master Carte du Credit Mutuel" },
    { "3F65250865046C9000", "CB visa Boursorama France (Axalto)" },
    { "3F6535100.04[6,E]C9000", "Postcard (Switzerland)" },
    { "3F6535100104EC9000", "Old Swiss Postbank card (Bank)" },
    { "3F6535640104689040", "Bull AFNOR-positioned microprocessor chip card 'Carte Pastel Internationale' by France Telecom (Other)\nhttp://phonecards.free.fr/carte_pastel.htm" },
    { "3F6535640204689040", "Carte Pastel Nationale - nominal France Telecom service card with Bull CP8 chip in AFNOR position (Other)" },
    { "3F65356402046C9040", "Postcard (Switzerland)" },
    { "3F6725002120000F689000", "Smart Builder 'your kit for PC/SC applications' and Bull\nhttp://www.cp8.bull.net/" },
    { "3F6725002120000F789000", "Bank Nederlandse Gemeenten, BNG Data Services" },
    { "3F67250026140020689000", "Pay-TV card from Casema Cable Television, Netherland" },
    { "3F6725002A20000F689000", "Carte Grand Voyageur (SNCF: French train company)" },
    { "3F6725002A200040689F00", "Swiss Cash card\nChipknip SNS Bank (banking card)" },
    { "3F6725002A200041689000", "ChipKnip" },
    { "3F6725002A20004[01]689000", "Dutch ChipKnip, Proton\n(chip Bull CC 60 V1, Bull CC 60 V2 or Bull CC 1000)" },
    { "3F67250421200007689000", "Philips TB100 (C-MOS chip)" },
    { "3F672F0011140001689000", "FilmNet(Sweden, 1984-1997) (Pay TV)" },
    { "3F672F0011140003689000", "D2MAC/Eurocrypt (Pay TV)" },
    { "3F672F0411200000689000", "BULL HN ITALIA 06/92 - 100.000 - 64MP\nLa Sapienza - Universita' di Roma" },
    { "3F69000024AF01700101FF9000", "French GSM SIM card (900MHz)" },
    { "3F6A000000640150010C820101A9", "Credit Card cafe Selecta" },
    { "3F6B150002A007906F4D59000C9000", "Sky Viewing Card (Gen 1) from 1990s (Pay TV)" },
    { "3F6C000024A03000FF00000100049000", "Gemplus MCOS 16K DES Sample Card" },
    { "3F6C000025A0308976000001030C9000", "MCOS 24Ko Gemplus (eID)" },
    { "3F6C000025A0308976000004010C9000", "MCOS 24k EEPROM" },
    { "3F6C000025A03100FF00000180049000", "Motorola Clone Card (Telecommunication)\nhttp://web.mclink.it/MK0750/Motorola_files/docuclon.txt" },
    { "3F6C00003CA0309E6100000100049000", "Gemplus - British Gas - Gascard" },
    { "3F6C00003CA030A758000001018C9000", "Rendezvous Series 7 (D2-Mac satellite TV card)" },
    { "3F6C00003DA030BE4100370100049000", "Sberbank (Bank)" },
    { "3F6D000080318065B00501025E83009000", "Gemplus GemXpresso 211PK or 211PK-IS" },
    { "3F6D000080318065B00501025E92009000", "Gemplus GemXpresso 32K" },
    { "3F77130000C11400A2689000", "Boxer DTV Sweden (Pay TV)\nhttp://www.boxer.se" },
    { "3F77180000C11400A2689000", "Viacess card HRT (Hrvatska Radio Televizija)" },
    { "3F77180000C11401A2689000", "VIA 2.6 XXX (Pay TV)" },
    { "3F77180000C21400C1689000", "Viaccess Sexview" },
    { "3F77180000C2474000689000", "Viacces card: SRG SSR idee suisse" },
    { "3F77180000C27A4102689000", "Viacces card: SRG SSR idee suisse" },
    { "3F77180000C27A4202689000", "SCT (Via Access)" },
    { "3F77180000C27A4302689000", "DORCEL (Via Access)" },
    { "3F77180000C27A4402689000", "XXX Redlight_HD (Viaccess)" },
    { "3F77180000C2EB41026C9000", "Elite HD10+ (Pay TV)\nSattelite cryptoworks card - Smart card Viaccess (Telesat - belgium) (Pay TV)" },
    { "3F77180000C2EB45026C9000", "facetv (Other)" },
    { "3F77180000D38A4001649000", "Skylink Viaccess 5.0 (Pay TV)\nhttp://www.skylink.sk/" },
    { "3F77180000D38A4201649000", "Satellite decoder card for TV Vlaanderen (Other)\nhttps://www.tv-vlaanderen.be" },
    { "3F7718250029140062689000", "Viaccess card" },
    { "3F7812250140B0034A50204855", "DSS/DTV H" },
    { "3F7813250340B020FFFF4A5000", "DSS/DTV P4" },
    { "3F7D11250241B00369FF4A50F08000565403", "Viasat Baltics Videoguard card (Pay TV)" },
    { "3F7E11250521B01200004D59000000534B0900", "Sky Viewing Card (Gen 9) (Pay TV)" },
    { "3F7E11250540B00800004D59000000534B0B07", "BSkyB Series 11 (DSS satellite TV card)" },
    { "3F7E11250540B00800004D59000000534B0B08", "Sky Series 11 (DSS satellite TV card)" },
    { "3F7E11250940B00100004D59000003534B0A01", "Sky Series 10 (DSS satellite TV card)" },
    { "3F7F11250333B00969FF4A507000005654010000", "Viasat Baltic (satellite card, NDS)" },
    { "3F7F11250540B00F69FF4D59000000534B0C0600", "Sky Series 12 (DSS satellite TV card)" },
    { "3F7F13250140B01069FF4A5001474C0000000000", "NDS Smartcard (Pay TV)" },
    { "3F7F13250240B00C69FF4A50C000005253000000", "Stream Italy NDS 1 (Pay TV)" },
    { "3F7F13250240B01269FF4A5090474C0000000000", "NDS VideoGuard GL23 Card (Sky Brazil) (Pay TV)\nhttps://en.wikipedia.org/wiki/VideoGuard" },
    { "3F7F13250240B01269FF4A509054560000000000", "NDS Smartcard (Pay TV)" },
    { "3F7F13250241B004FFFF4A508080000000475806", "NDS card DIRECTV (Other)" },
    { "3F7F13250241B00EFFFF4A508080000000474C07", "SKY BRASIL (Pay TV)" },
    { "3F7F13250333B00669FF4A50D000005359000000", "Sky 2005/6 (DSS satellite TV card)" },
    { "3F7F13250333B01169FF4A505000004956010000", "Indonesia Videoguard 2 card" },
    { "3F7F13250338B004FFFF4A500000294855......", "DSS/DTV HU" },
    { "3F7F13250340B00B694C4A50C000005359000000", "Sky Digital (DSS satellite TV card)" },
    { "3F7F13250540B01169FF4A500000004754000C00", "YES DBS Israel Videoguard 090C,090D" },
    { "3F7F15250333B01169FF4A505000004956010000", "Sky Germany V13 Smartcard (Pay TV)" },
    { "3F961880018051006110309F", "Atmel/Athena T0 Inverse Convention PC/SC Compliance Test Card No. 2" },
    { "3FEF00FF8131..456563", "Debit card (Germany): ec-cash, GeldKarte(DEM), Maestro, Cirrus" },
    { "3FFA1125040001B00200004D59008180", "Sky Viewing Card (Gen 1) from 1990s (Pay TV)" },
    { "3FFA1125050001B0023B364D59028090", "HackTV SKY11 PIC16F84 card (Other)\nhttps://github.com/captainjack64/hacktv" },
    { "3FFA1125050001B0023B404D59008180", "Sky Viewing Card (Gen 7) (Pay TV)" },
    { "3FFA1125050001B0023BD04D59008180", "Sky Viewing Card (Gen 7) (Pay TV)" },
    { "3FFD11250250000333B01569FF4A50F080034B4C03", "Kabel Deutschland G02  (Pay TV)" },
    { "3FFD11250250800F41B00A69FF4A507080005A4503", "Buypass smart card (Bank)\nhttps://www.buypass.no/bruker/buypass-id/buypass-smartkort" },
    { "3FFD11250250800F41B00D69FF4A50F08000565403", "Viasat (Pay TV)" },
    { "3FFD13250250000F33B00F69FF4A50D00000535902", "Sky Digital (DSS satellite TV card) 2009 issue" },
    { "3FFD13250250000F33B01669FF4A50D08000535903", "Sky TV Multiroom (Pay TV)" },
    { "3FFD13250250800F..B0..69FF4A50D08000495403", "Sky (Italy) VideoGuard CAM card" },
    { "3FFD13250250800F33B008FFFF4A50900000474C01", "Sky (Brasil) VideoGuard CAM card" },
    { "3FFD13250250800F33B008FFFF4A50900000545601", "NDS Videoguard TV CAM card (Sky Mexico 0905) (Pay TV)\nhttps://en.wikipedia.org/wiki/VideoGuard" },
    { "3FFD13250250800F41B00A69FF4A50F00000503103", "Sky Germany V14 NDS card (Pay TV)\nhttp://www.wikipedia.org/wiki/Sky_Deutschland" },
    { "3FFD13250250800F55B00269FF4A50F08000503103", "SKY DE V15 (Pay TV)" },
    { "3FFD14250150000F33B00BFFFF4A50800000475801", "DirecTV card" },
    { "3FFD14250250800F41B00A69FF4A507080004E5A03", "Sky Network Televisiton Limited (New Zealand) card for new (2016) decoder.  Reportedly, this is a Kaon NS1120-500 box. (Pay TV)\nhttp://www.sky.co.nz" },
    { "3FFD14250250800F41B00D69FF4A50F08000425203", "Airtel Digital TV (Pay TV)" },
    { "3FFD15250250000333B01569FF4A50F080034B4C03", "Kabel Deutschland (G02) (Pay TV)\nhttps://www.kabeldeutschland.com" },
    { "3FFD15250250800F41B00569FF4A50F00000415A03", "astro Pay TV Measat 91.5 E Caid: 0910 Provider: 000000" },
    { "3FFD15250250800F41B00A69FF4A50F00000503103", "Sky Germany [NDS|V14] (098C:000000) (Pay TV)" },
    { "3FFD15250250800F41B00D69FF4A50F08000414A03", "beIN Sports Arabia NDS (09B5:000000) (Pay TV)" },
    { "3FFD15250250800F41B00D69FF4A50F08000565403", "TVPLAY HOME (Pay TV)\nhttps://www.tvplayhome.lt/" },
    { "3FFD15250250800F55B00269FF4A50F08000503103", "Sky Germany [NDS|V15] (098D:000000) (Pay TV) (Pay TV)\nhttp://www.sky.de" },
    { "3FFDFF250250800F54B00469FF4A50D08000495403", "SKy italia (Pay TV)" },
    { "3FFE142503108041B00769FF4A5070804245544114", "OSN (Pay TV)\nhttps://www.osn.com" },
    { "3FFF112503108041B00669FF4A50700000415A010011", "Astro (Pay TV)\nhttp://www.astro.com.my" },
    { "3FFF112503108041B00769FF4A507000005031010011", "Sky (Germany) VideoGuard CAM card (www.sky.de)" },
    { "3FFF13250250800F54B003FFFF4A508000000000474C05", "Sky (Brasil) VideoGuard CAM card" },
    { "3FFF132503108033B00E69FF4A507000004954020000", "Sky entitlement card" },
    { "3FFF132503108033B01069FF4A507000004E5A010000", "NDS SKY NZ (Pay TV)" },
    { "3FFF13250B50000F33B00469FF4A50E000005335000000", "Stream TV (IP television) decoder card, provided by stream.ru ISP in Moscow" },
    { "3FFF13250B50000F33B00469FF4A50E000005438000000", "Stream TV (IP television) decoder card, provided by aon (Telekom Austria) TV card, contains Incorporated NDS Videoguard (TM) security system" },
    { "3FFF142503108033B01069FF4A507000004352010000", "Russian cable TV AKADO NDS Card (Pay TV)\nhttp://www.akado.ru/" },
    { "3FFF142503108033B01069FF4A507000005A45010000", "Norwegian DVB-C provider Get (www.get.no). NDS Videoguard security card." },
    { "3FFF142503108041B00169FF4A507000005356010000", "Tata Sky India Card (Telecommunication)" },
    { "3FFF142503108041B00169FF4A507000005A48010000", "'D-Smart' NDS from Turkie" },
    { "3FFF142503108041B00169FF4A507000005A4A010000", "Dolce by RomTelecom (Pay TV)" },
    { "3FFF142503108041B00169FF4A507000005A4B010000", "Pay TV, Viasat Ukraine" },
    { "3FFF142503108041B00269FF4A507000004252010000", "airtel (Pay TV)" },
    { "3FFF142503108041B00269FF4A50708000414F010014", "Pay TV" },
    { "3FFF142503108041B00769FF4A507080005844010014", "NDS vivacom Bulgaria card  (Pay TV)\nhttps://www.vivacom.bg/bg/tv" },
    { "3FFF142503108041B00769FF4A5070800058440100FF", "Provider Vivacom Bulgaria NDS (Pay TV)\nhttp://www.vivacom.bg/en/satellite-services" },
    { "3FFF142503108041B00769FF4A507080005845010014", "Sat TV (Other)" },
    { "3FFF142503108054B00169FF4A507000004B57010000", "PayTV Card Kabel BW (www.kabelbw.de), Encryption: NDS by Videoguard, Distribution Standard: DVB-C" },
    { "3FFF152503108041B00769FF4A507000005031010015", "Sky (Germany) VideoGuard CAM card (www.sky.de) in Fast Mode (ins7e11=15) (Pay TV)" },
    { "3FFF3F3F3F3F003F3FFF3F3F3F3F3FFF3FFF953FFF953FFF", "Premium joker card to see Spanish TDT premium (goltv)" },
    { "3FFF9500FF918171..4700..4.4.....3.3.3.20..657.........", "Nagravision TV CAM card\nhttp://en.wikipedia.org/wiki/Nagravision" },
    { "3FFF9500FF918171..47004E434D45443.303.20526576..3.3...", "Mediaset Premium (Italy) CAM card" },
    { "3FFF9500FF918171644700444E41535030303320526576333233FF", "Satellite TV Card 'Via Digital' (Nagra)" },
    { "3FFF9500FF918171A04700444E4153503031302052657641323048", "DSS/DISH ROM10" },
    { "3FFF9500FF918171A04700444E4153503031302052657641323149", "PayTV card for DishNetwork Sat receiver\nhttp://www.dishnetwork.com/" },
    { "3FFF9500FF918171A04700444E4153503031312052657642", "NTL digial TV card (Nagravision)" },
    { "3FFF9500FF918171A04700444E415350303131205265764230364E", "Telewest Broadband (Nagravision)" },
    { "3FFF9500FF918171A04700444E415350303131205265764230423A", "NagraVision card for StarHub Digital Cable DVB-C Singapore" },
    { "3FFF9500FF918171A04700444E415350303131205265764230443C", "NagraVision card for Virgin Media in the UK" },
    { "3FFF9500FF918171A04700444E415350313830204D657230303028", "NagraVision (VG04) for Virgin Media (UK)\nNagraVision 3 for DigiTV (Romania)\nhttp://www.rcs-rds.ro/televiziune-digi-tv/satelit" },
    { "3FFF9500FF918171FE4700444E4153503131302052657641303114", "TVA Digital - Nagra Vision ID TV-01" },
    { "3FFF9500FF918171FE4700444E4153503131302052657641303712", "UPC Austria/UPC-Cablecom Switzerland, digital television encryption card\nhttp://www.upc-cablecom.ch/" },
    { "3FFF9500FF918171FE4700444E4153503131302052657641323215", "UM01 card from German Unitymedia cable TV provider" },
    { "3FFF9500FF918171FE4700444E4153503131302052657641343514", "Telenet N.V. HDTV Decoder Card Belgium" },
    { "3FFF9500FF918171FE4700444E4153503131302052657641433365", "Brazilian NET Digital (Cable TV provider) - Nagra Vision 'NASP110 RevA01'" },
    { "3FFF9500FF918171FE4700444E4153503134322052657647303216", "Polsat Nagra3\nBrazil - Claro TV Nagra3 Red" },
    { "3FFF9500FF918171FE4700444E4153503134322052657647303410", "Nagra 3 Card - Telefonica Brazil Green" },
    { "3FFF9500FF918171FE4700444E4153503134322052657647303612", "UM02 card from German Unitymedia cable TV provider" },
    { "3FFF9500FF918171FE4700444E4153503134322052657647433463", "HD+ card used by the satelite company astra for decryption of the HDTV channels of RTL, VOX, Sat1 and ProSieben. Nagravision V3 is used for the encryption." },
    { "3FFF9500FF918171FE4700444E415350313830204D65724A30320E", "Nagra 3 Digital Plus Spain" },
    { "3FFF9500FF918171FE4700444E41535032343120447368", "DISH Network G3 (Pay TV)" },
    { "3FFF9500FF918171FE4700444E415350323431204473684830390C", "Dish Network Smart Card (Pay TV)" },
    { "3FFF9500FF918171FE47004E434D4544303041205265764130316C", "Mediaset Premium (Italy) 2013" },
    { "3FFF9500FF918171FE47004E434D4544303043205265764330306D", "Mediaset Premium rechargeable (Pay TV)\nhttp://www.mediasetpremium.it/" },
    { "3FFF9500FF918171FE47005449474552363031205265764D383013", "Spanish pay TV card for GOLTV" },
    { "3FFF9500FF918171FE5700444E415350314230204D657257323079", "Vodafone HUNGARY (Pay TV)" },
    { "3FFF9500FF918171FE5700444E4153503431302052657651323210", "Telenet CI+ card Belgium (Pay TV)\nhttps://www2.telenet.be/nl/tv-met-een-kaartje/" },
    { "3FFF9500FF918171FE5700444E4153503431302052657651323517", "New ROM of Nagra PayTV Card DNASP410 (Pay TV)\nhttp://en.wikipedia.org/wiki/Nagravision" },
    { "3FFF9500FF918171FE5700444E4153503431302052657651323715", "New Digi Slovakia (Pay TV)\nhttps://www.lyngsat.com/packages/Digi.html" },
    { "3FFF9500FF918171FE5700444E4153503431302052657651324260", "Nagravision Kudelski Generation 7 card  Rom410 MerQ2B   (Pay TV)" },
    { "3FFF9500FF918171FE5700444E4153503431302052657651325371", "Slovak and Czech pay TV provider Slovak Telecom (Pay TV)\nhttp://www.flysat.com/novadigi-sk.php" },
    { "3FFF9500FF918171FE5700444E4153503432302052657653363017", "HD+ HD04b Card (Pay TV)" },
    { "3FFF9500FF918171FE5700444E4153503432302052657653364265", "Nagra Kudelski / Canalsat Reunion (Pay TV)" },
    { "3FFF9500FF918171FE5700444E4153503435302052657657363014", "HD+ HD05 Paytv smartcard (Pay TV)" },
    { "3FFF9500FF918171FE5700444E415350343832205265765232361C", "Max Tv Croatia (Pay TV)\nhttps://www.lyngsat.com/packages/Max-TV.html" },
    { "3FFF9500FF918171FE5700444E415350353532204473684E30391F", "Dish Network ROM552 (Pay TV)" },
    { "3FFF9500FF918171FE5700444E415350353532204473684E304264", "Dish Network (Satellite Pay TV) NASP 552 (Pay TV)\nhttp://www.dishnetwork.com/" },
    { "3FFF9500FF918171FE5700444E415350353533205265764E304178", "BELL CA EXPRESS VU CARD (Pay TV)" },
    { "3FFF9500FF918171FF4700444E4153505330312044736836303916", "PayTV card for DishNetwork Sat receiver\nhttp://www.dishnetwork.com/\nCards were obsoleted in nationwide system update in 2009." },
    { "3FFF9500FF918171FF4700444E4153505330312052657636343702", "BELL EXPRESSVU (Pay TV)" },
    { "3FFF9500FF918171FF470054494745523030332052657632353064", "Tivu' Sat (Italy) CAM card www.tivu.tv" },
    {NULL, "N/A"}
};

#endif
