# PSPP - a program for statistical analysis.
# Copyright (C) 2017 Free Software Foundation, Inc.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
## Process this file with automake to produce Makefile.in  -*- makefile -*-


noinst_LTLIBRARIES += src/libpspp/liblibpspp.la

src_libpspp_liblibpspp_la_SOURCES = \
	src/libpspp/abt.c \
	src/libpspp/abt.h \
	src/libpspp/argv-parser.c \
	src/libpspp/argv-parser.h \
	src/libpspp/array.c \
	src/libpspp/array.h \
	src/libpspp/assertion.h \
	src/libpspp/bit-vector.c \
	src/libpspp/bit-vector.h \
	src/libpspp/bt.c \
	src/libpspp/bt.h \
	src/libpspp/cast.h \
	src/libpspp/cmac-aes256.c \
	src/libpspp/cmac-aes256.h \
	src/libpspp/compiler.h \
	src/libpspp/copyleft.c \
	src/libpspp/copyleft.h \
	src/libpspp/deque.c \
	src/libpspp/deque.h \
	src/libpspp/encoding-guesser.c \
	src/libpspp/encoding-guesser.h \
	src/libpspp/ext-array.c \
	src/libpspp/ext-array.h \
	src/libpspp/float-format.c \
	src/libpspp/float-format.h \
	src/libpspp/freaderror.c \
	src/libpspp/freaderror.h \
	src/libpspp/hash-functions.c \
	src/libpspp/hash-functions.h \
	src/libpspp/heap.c \
	src/libpspp/heap.h \
	src/libpspp/hmap.c \
	src/libpspp/hmap.h \
	src/libpspp/hmapx.c \
	src/libpspp/hmapx.h \
	src/libpspp/i18n.c \
	src/libpspp/i18n.h \
	src/libpspp/integer-format.c \
	src/libpspp/integer-format.h \
	src/libpspp/intern.c \
	src/libpspp/intern.h \
	src/libpspp/line-reader.c \
	src/libpspp/line-reader.h \
	src/libpspp/ll.c \
	src/libpspp/ll.h \
	src/libpspp/llx.c \
	src/libpspp/llx.h \
	src/libpspp/message.c \
	src/libpspp/message.h \
	src/libpspp/misc.c \
	src/libpspp/misc.h \
	src/libpspp/model-checker.c \
	src/libpspp/model-checker.h \
	src/libpspp/pool.c \
	src/libpspp/pool.h \
	src/libpspp/prompt.c \
	src/libpspp/prompt.h \
	src/libpspp/range-map.c \
	src/libpspp/range-map.h \
	src/libpspp/range-set.c \
	src/libpspp/range-set.h \
	src/libpspp/range-tower.c \
	src/libpspp/range-tower.h \
	src/libpspp/sparse-array.c \
	src/libpspp/sparse-array.h \
	src/libpspp/sparse-xarray.c \
	src/libpspp/sparse-xarray.h \
	src/libpspp/start-date.c \
	src/libpspp/start-date.h \
	src/libpspp/string-array.c \
	src/libpspp/string-array.h \
	src/libpspp/string-map.c \
	src/libpspp/string-map.h \
	src/libpspp/string-set.c \
	src/libpspp/string-set.h \
	src/libpspp/stringi-map.c \
	src/libpspp/stringi-map.h \
	src/libpspp/stringi-set.c \
	src/libpspp/stringi-set.h \
	src/libpspp/str.c \
	src/libpspp/str.h \
	src/libpspp/taint.c \
	src/libpspp/taint.h \
	src/libpspp/temp-file.c \
	src/libpspp/temp-file.h \
	src/libpspp/tower.c \
	src/libpspp/tower.h \
	src/libpspp/u8-istream.c \
	src/libpspp/u8-istream.h \
	src/libpspp/u8-line.c \
	src/libpspp/u8-line.h \
	src/libpspp/version.h \
	src/libpspp/zip-private.h \
	src/libpspp/zip-reader.c \
	src/libpspp/zip-reader.h \
	src/libpspp/zip-writer.c \
	src/libpspp/zip-writer.h

DISTCLEANFILES+=src/libpspp/version.c

src_libpspp_liblibpspp_la_CPPFLAGS = \
	-I $(top_srcdir)/src/libpspp \
	$(AM_CPPFLAGS)

nodist_src_libpspp_liblibpspp_la_SOURCES = src/libpspp/version.c

src/libpspp/version.c: $(top_srcdir)/AUTHORS Makefile
	@$(MKDIR_P) src/libpspp
	$(AM_V_GEN){ \
	  echo "/* 	-*- mode: c; buffer-read-only: t -*-"; \
	  echo "   Generated by src/libpspp/automake.mk --- Do not edit."; \
	  echo; \
	  echo "   The following line is for the benefit of the perl module"; \
	  echo "\$$VERSION='$(VERSION_FOR_PERL)';"; \
	  echo "*/"; \
	  echo "#include \"version.h\""; \
	  echo "const char bare_version[] = \"$(VERSION)\";"; \
	  echo "const char version[] = \"GNU $(PACKAGE) $(VERSION)\";"; \
	  printf "const char announced_version[] = \"GNU $(PACKAGE) $(VERSION)\""; \
	  case `echo $(VERSION) | $(SED) -e 's/[0-9][0-9]*\.[0-9]*\([0-9]\)\.[0-9][0-9]*/\1/'` in \
	    [13579]) printf "\"\\\nThis is an unreleased test version. It is not recommended for production use. Use at your own risk\"" ;; \
	  esac; \
	  printf ";\n"; \
	  echo "const char host_system[] = \"$(host_triplet)\";"; \
	  echo "const char build_system[] = \"$(build_triplet)\";"; \
	  echo "const char locale_dir[] = \"$(datadir)/locale\";"; \
	  echo "const char examples_dir[] = \"$(examplesdir)\";"; \
	  echo "const char *const authors[] = {"; \
	  $(SED) -e 's/^/  \"/' -e 's/$$/\",/' $(top_srcdir)/AUTHORS; \
	  echo "  0"; \
          echo "};"; \
	} > $@,tmp && mv $@,tmp $@
