from collections import OrderedDict

from .. import Provider as ColorProvider

localized = True


class Provider(ColorProvider):
    """Implement color provider for ``es_ES`` locale."""

    all_colors = OrderedDict(
        (
            ("Agua marina medio", "#66CDAA"),
            ("Agua-marina", "#7FFFD4"),
            ("Almendra blanqueado", "#FFEBCD"),
            ("Amarillo", "#FFFF00"),
            ("Amarillo claro", "#FFFFE0"),
            ("Amarillo dorado", "#DAA520"),
            ("Amarillo dorado claro", "#FAFAD2"),
            ("Amarillo dorado oscuro", "#B8860B"),
            ("Amarillo dorado pálido", "#EEE8AA"),
            ("Amarillo trigo", "#F5DEB3"),
            ("Amarillo verde", "#9ACD32"),
            ("Azul", "#0000FF"),
            ("Azul Alicia", "#F0F8FF"),
            ("Azul acero", "#4682B4"),
            ("Azul acero claro", "#B0C4DE"),
            ("Azul anciano", "#6495ED"),
            ("Azul azur", "#F0FFFF"),
            ("Azul cadete", "#5F9EA0"),
            ("Azul cielo", "#87CEEB"),
            ("Azul cielo claro", "#87CEFA"),
            ("Azul cielo profundo", "#00BFFF"),
            ("Azul claro", "#ADD8E6"),
            ("Azul lona", "#1E90FF"),
            ("Azul marino", "#000080"),
            ("Azul medianoche", "#191970"),
            ("Azul medio", "#0000CD"),
            ("Azul oscuro", "#00008B"),
            ("Azul pizarra", "#6A5ACD"),
            ("Azul pizarra medio", "#7B68EE"),
            ("Azul pizarra oscuro", "#483D8B"),
            ("Azul polvo", "#B0E0E6"),
            ("Azul real", "#4169E1"),
            ("Azul violeta", "#8A2BE2"),
            ("Beige", "#F5F5DC"),
            ("Beige antiguo", "#FAEBD7"),
            ("Beige limón", "#FFFACD"),
            ("Beige melocotón", "#FFDAB9"),
            ("Beige mocasín", "#FFE4B5"),
            ("Beige papaya", "#FFEFD5"),
            ("Bisque", "#FFE4C4"),
            ("Blanco", "#FFFFFF"),
            ("Blanco concha", "#FFF5EE"),
            ("Blanco encaje", "#FDF5E6"),
            ("Blanco fantasma", "#F8F8FF"),
            ("Blanco floral", "#FFFAF0"),
            ("Blanco humo", "#F5F5F5"),
            ("Blanco lavanda", "#FFF0F5"),
            ("Blanco lino", "#FAF0E6"),
            ("Blanco menta", "#F5FFFA"),
            ("Blanco navajo", "#FFDEAD"),
            ("Blanco nieve", "#FFFAFA"),
            ("Caqui", "#6B8E23"),
            ("Caqui oscuro", "#BDB76B"),
            ("Chartreuse", "#7FFF00"),
            ("Chocolate", "#D2691E"),
            ("Cian", "#00FFFF"),
            ("Cian clarto", "#E0FFFF"),
            ("Ciruela", "#DDA0DD"),
            ("Coral", "#FF7F50"),
            ("Coral claro", "#F08080"),
            ("Amarillo maíz dulce", "#FFF8DC"),
            ("Cyan oscuro", "#008B8B"),
            ("Fucsia", "#FF00FF"),
            ("Granate", "#800000"),
            ("Gris", "#808080"),
            ("Gris claro", "#D3D3D3"),
            ("Gris gainsboro (Estaño)", "#DCDCDC"),
            ("Gris mate", "#696969"),
            ("Gris oscuro", "#A9A9A9"),
            ("Gris pizarra", "#708090"),
            ("Gris pizarra claro", "#778899"),
            ("Gris pizarra oscuro", "#2F4F4F"),
            ("Lavanda", "#E6E6FA"),
            ("Lima", "#00FF00"),
            ("Magenta", "#FF00FF"),
            ("Magenta oscuro", "#8B008B"),
            ("Marfil", "#FFFFF0"),
            ("Marrón", "#A52A2A"),
            ("Marrón arena", "#F4A460"),
            ("Marrón caqui", "#F0E68C"),
            ("Marrón cuero", "#8B4513"),
            ("Marrón madera rústica", "#DEB887"),
            ("Marrón perú", "#CD853F"),
            ("Marrón rojizo", "#D2B48C"),
            ("Marrón rosado", "#BC8F8F"),
            ("Marrón siena", "#A0522D"),
            ("Melón dulce", "#F0FFF0"),
            ("Naranja", "#FFA500"),
            ("Naranja oscuro", "#FF8C00"),
            ("Negro", "#000000"),
            ("Oliva", "#808000"),
            ("Oro", "#FFD700"),
            ("Orquídea", "#DA70D6"),
            ("Orquídea medio", "#BA55D3"),
            ("Orquídea púrpura oscuro", "#9932CC"),
            ("Plata", "#C0C0C0"),
            ("Púrpura", "#800080"),
            ("Púrpura medio", "#9370DB"),
            ("Rojo", "#FF0000"),
            ("Rojo anaranjado", "#FF4500"),
            ("Rojo carmesí", "#DC143C"),
            ("Rojo indio", "#CD5C5C"),
            ("Rojo ladrillo", "#B22222"),
            ("Rojo oscuro", "#8B0000"),
            ("Rojo tomate", "#FF6347"),
            ("Rojo violeta medio", "#C71585"),
            ("Rosa", "#FFC0CB"),
            ("Rosa brumoso", "#FFE4E1"),
            ("Rosa caliente", "#FF69B4"),
            ("Rosa claro", "#FFB6C1"),
            ("Rosa profundo", "#FF1493"),
            ("Salmón", "#FA8072"),
            ("Salmón claro", "#FFA07A"),
            ("Salmón oscuro", "#E9967A"),
            ("Turquesa", "#40E0D0"),
            ("Turquesa medio", "#48D1CC"),
            ("Turquesa oscuro", "#00CED1"),
            ("Turquesa pálido", "#AFEEEE"),
            ("Verde", "#008000"),
            ("Verde azulado", "#008080"),
            ("Verde bosque", "#228B22"),
            ("Verde claro", "#90EE90"),
            ("Verde lima", "#32CD32"),
            ("Verde limón", "#ADFF2F"),
            ("Verde mar", "#2E8B57"),
            ("Verde mar claro", "#20B2AA"),
            ("Verde mar medio", "#3CB371"),
            ("Verde mar oscuro", "#8FBC8F"),
            ("Verde oliva oscuro", "#556B2F"),
            ("Verde oscuro", "#006400"),
            ("Verde prado", "#7CFC00"),
            ("Verde primavera", "#00FF7F"),
            ("Verde primavera medio", "#00FA9A"),
            ("Verde pálido", "#98FB98"),
            ("Violeta", "#EE82EE"),
            ("Violeta cardo", "#D8BFD8"),
            ("Violeta oscuro", "#9400D3"),
            ("Violeta sonrojado pálido", "#DB7093"),
            ("Índigo", "#4B0082"),
        )
    )

    safe_colors = (
        "negro",
        "budeos",
        "verde",
        "rojo",
        "violeta",
        "verde azulado",
        "azul",
        "plata",
        "gris",
        "amarilo",
        "fucsia",
        "cian",
        "blanco",
    )
