from .. import Provider as DateTimeProvider


class Provider(DateTimeProvider):

    DAY_NAMES = {
        "0": "রবিবার",
        "1": "সোমবার",
        "2": "মঙ্গলবার",
        "3": "বুধবার",
        "4": "বৃহস্পতিবার",
        "5": "শুক্রবার",
        "6": "শনিবার",
    }

    MONTH_NAMES = {
        "01": "জানুয়ারি",
        "02": "ফেব্রুয়ারি",
        "03": "মার্চ",
        "04": "এপ্রিল",
        "05": "মে",
        "06": "জুন",
        "07": "জুলাই",
        "08": "আগস্ট",
        "09": "সেপ্টেম্বর",
        "10": "অক্টোবর",
        "11": "নভেম্বর",
        "12": "ডিসেম্বর",
    }

    countries = [
        {
            "timezones": ["ইউরোপ/অ্যান্ডোরা"],
            "alpha-2-code": "AD",
            "alpha-3-code": "এবং",
            "continent": "ইউরোপ",
            "name": "অ্যান্ডোরা",
            "capital": "অ্যান্ডোরা লা ভেলা",
        },
        {
            "timezones": ["এশিয়া/কাবুল"],
            "alpha-2-code": "AF",
            "alpha-3-code": "AFG",
            "continent": "এশিয়া",
            "name": "আফগানিস্তান",
            "capital": "কাবুল",
        },
        {
            "timezones": ["আমেরিকা/অ্যান্টিগা"],
            "alpha-2-code": "AG",
            "alpha-3-code": "ATG",
            "continent": "উত্তর আমেরিকা",
            "name": "অ্যান্টিগা এবং বারবুডা",
            "capital": "সেন্ট জনস",
        },
        {
            "timezones": ["ইউরোপ/তিরানে"],
            "alpha-2-code": "AL",
            "alpha-3-code": "ALB",
            "continent": "ইউরোপ",
            "name": "আলবেনিয়া",
            "capital": "তিরানা",
        },
        {
            "timezones": ["এশিয়া/ইয়েরেভান"],
            "alpha-2-code": "AM",
            "alpha-3-code": "ARM",
            "continent": "এশিয়া",
            "name": "আর্মেনিয়া",
            "capital": "ইয়েরেভান",
        },
        {
            "timezones": ["আফ্রিকা/লুয়ান্ডা"],
            "alpha-2-code": "AO",
            "alpha-3-code": "আগে",
            "continent": "আফ্রিকা",
            "name": "অ্যাঙ্গোলা",
            "capital": "লুয়ান্ডা",
        },
        {
            "timezones": [
                "আমেরিকা/আর্জেন্টিনা/বুয়েনস_আয়ার্স",
                "আমেরিকা/আর্জেন্টিনা/কর্ডোবা",
                "আমেরিকা/আর্জেন্টিনা/জুজুয়",
                "আমেরিকা/আর্জেন্টিনা/টুকুমান",
                "আমেরিকা/আর্জেন্টিনা/কাটামার্কা",
                "আমেরিকা/আর্জেন্টিনা/লা_রিওজা",
                "আমেরিকা/আর্জেন্টিনা/সান_জুয়ান",
                "আমেরিকা/আর্জেন্টিনা/মেন্ডোজা",
                "আমেরিকা/আর্জেন্টিনা/রিও_গ্যালেগোস",
                "আমেরিকা/আর্জেন্টিনা/উশুইয়া",
            ],
            "alpha-2-code": "AR",
            "alpha-3-code": "ARG",
            "continent": "দক্ষিণ আমেরিকা",
            "name": "আর্জেন্টিনা",
            "capital": "বুয়েনস আইরেস",
        },
        {
            "timezones": ["ইউরোপ/ভিয়েনা"],
            "alpha-2-code": "AT",
            "alpha-3-code": "AUT",
            "continent": "ইউরোপ",
            "name": "অস্ট্রিয়া",
            "capital": "ভিয়েনা",
        },
        {
            "timezones": [
                "অস্ট্রেলিয়া/লর্ড_হাউ",
                "অস্ট্রেলিয়া/হোবার্ট",
                "অস্ট্রেলিয়া/কারি",
                "অস্ট্রেলিয়া/মেলবোর্ন",
                "অস্ট্রেলিয়া/সিডনি",
                "অস্ট্রেলিয়া/ব্রোকেন_হিল",
                "অস্ট্রেলিয়া/ব্রিসবেন",
                "অস্ট্রেলিয়া/লিন্ডেম্যান",
                "অস্ট্রেলিয়া/অ্যাডিলেড",
                "অস্ট্রেলিয়া/ডারউইন",
                "অস্ট্রেলিয়া/পার্থ",
            ],
            "alpha-2-code": "AU",
            "alpha-3-code": "AUS",
            "continent": "ওশেনিয়া",
            "name": "অস্ট্রেলিয়া",
            "capital": "ক্যানবেরা",
        },
        {
            "timezones": ["এশিয়া/বাকু"],
            "alpha-2-code": "AZ",
            "alpha-3-code": "AZE",
            "continent": "এশিয়া",
            "name": "আজারবাইজান",
            "capital": "বাকু",
        },
        {
            "timezones": ["আমেরিকা/বার্বাডোস"],
            "alpha-2-code": "BB",
            "alpha-3-code": "BRB",
            "continent": "উত্তর আমেরিকা",
            "name": "বার্বাডোস",
            "capital": "ব্রিজটাউন",
        },
        {
            "timezones": ["এশিয়া/ঢাকা"],
            "alpha-2-code": "বিডি",
            "alpha-3-code": "BGD",
            "continent": "এশিয়া",
            "name": "বাংলাদেশ",
            "capital": "ঢাকা",
        },
        {
            "timezones": ["ইউরোপ/ব্রাসেলস"],
            "alpha-2-code": "BE",
            "alpha-3-code": "BEL",
            "continent": "ইউরোপ",
            "name": "বেলজিয়াম",
            "capital": "ব্রাসেলস",
        },
        {
            "timezones": ["আফ্রিকা/ওগাডুগু"],
            "alpha-2-code": "BF",
            "alpha-3-code": "BFA",
            "continent": "আফ্রিকা",
            "name": "বুর্কিনা ফাসো",
            "capital": "ওগাডুগউ",
        },
        {
            "timezones": ["ইউরোপ/সোফিয়া"],
            "alpha-2-code": "বিজি",
            "alpha-3-code": "BGR",
            "continent": "ইউরোপ",
            "name": "বুলগেরিয়া",
            "capital": "সোফিয়া",
        },
        {
            "timezones": ["এশিয়া/বাহরাইন"],
            "alpha-2-code": "BH",
            "alpha-3-code": "BHR",
            "continent": "এশিয়া",
            "name": "বাহরাইন",
            "capital": "মাnameা",
        },
        {
            "timezones": ["আফ্রিকা/বুজুম্বুরা"],
            "alpha-2-code": "BI",
            "alpha-3-code": "BDI",
            "continent": "আফ্রিকা",
            "name": "বুরুন্ডি",
            "capital": "বুজুম্বুরা",
        },
        {
            "timezones": ["আফ্রিকা/পোর্টো-নোভো"],
            "alpha-2-code": "BJ",
            "alpha-3-code": "BEN",
            "continent": "আফ্রিকা",
            "name": "বেনিন",
            "capital": "পোর্টো-নভো",
        },
        {
            "timezones": ["এশিয়া/ব্রুনাই"],
            "alpha-2-code": "BN",
            "alpha-3-code": "BRN",
            "continent": "এশিয়া",
            "name": "ব্রুনাই দারুসসালাম",
            "capital": "বন্দর সেরি বেগাওয়ান",
        },
        {
            "timezones": ["আমেরিকা/লা_পাজ"],
            "alpha-2-code": "BO",
            "alpha-3-code": "BOL",
            "continent": "দক্ষিণ আমেরিকা",
            "name": "বলিভিয়া",
            "capital": "সুক্রে",
        },
        {
            "timezones": [
                "আমেরিকা/নরোনহা",
                "আমেরিকা/বেলেম",
                "আমেরিকা/ফর্তালেজা",
                "আমেরিকা/রেসিফ",
                "আমেরিকা/আরাগুয়েনা",
                "আমেরিকা/ম্যাসিও",
                "আমেরিকা/বাহিয়া",
                "আমেরিকা/সাও_পাওলো",
                "আমেরিকা/ক্যাম্পো_গ্রান্ডে",
                "আমেরিকা/কুয়াবা",
                "আমেরিকা/পোর্টো_ভেলহো",
                "আমেরিকা/বোয়া_ভিস্তা",
                "আমেরিকা/মানাস",
                "আমেরিকা/ইরুনেপে",
                "আমেরিকা/রিও_ব্র্যাঙ্কো",
            ],
            "alpha-2-code": "BR",
            "alpha-3-code": "BRA",
            "continent": "দক্ষিণ আমেরিকা",
            "name": "ব্রাজিল",
            "capital": "ব্রাসেলস",
        },
        {
            "timezones": ["আমেরিকা/নাসাউ"],
            "alpha-2-code": "BS",
            "alpha-3-code": "BHS",
            "continent": "উত্তর আমেরিকা",
            "name": "বাহামাস",
            "capital": "নাসাউ",
        },
        {
            "timezones": ["এশিয়া/থিম্পু"],
            "alpha-2-code": "BT",
            "alpha-3-code": "BTN",
            "continent": "এশিয়া",
            "name": "ভুটান",
            "capital": "থিম্পু",
        },
        {
            "timezones": ["আফ্রিকা/গ্যাবোরোন"],
            "alpha-2-code": "BW",
            "alpha-3-code": "BWA",
            "continent": "আফ্রিকা",
            "name": "বতসোয়ানা",
            "capital": "গ্যাবরোন",
        },
        {
            "timezones": ["ইউরোপ/মিনস্ক"],
            "alpha-2-code": "দ্বারা",
            "alpha-3-code": "BLR",
            "continent": "ইউরোপ",
            "name": "বেলারুশ",
            "capital": "মিনস্ক",
        },
        {
            "timezones": ["আমেরিকা/বেলিজ"],
            "alpha-2-code": "BZ",
            "alpha-3-code": "BLZ",
            "continent": "উত্তর আমেরিকা",
            "name": "বেলিজ",
            "capital": "বেলমোপান",
        },
        {
            "timezones": [
                "আমেরিকা/সেন্ট জনস",
                "আমেরিকা/হ্যালিফ্যাক্স",
                "আমেরিকা/গ্লেস_বে",
                "আমেরিকা/মঙ্কটন",
                "আমেরিকা/গোজ_বে",
                "আমেরিকা/ব্ল্যাঙ্ক-সাবলন",
                "আমেরিকা/মন্ট্রিল",
                "আমেরিকা/টরন্টো",
                "আমেরিকা/নিপিগন",
                "আমেরিকা/থান্ডার_বে",
                "আমেরিকা/পাংনিরতুং",
                "আমেরিকা/ইকালুইট",
                "আমেরিকা/আতিকোকান",
                "আমেরিকা/র‍্যাঙ্কিন_ইনলেট",
                "আমেরিকা/উইনিপেগ",
                "আমেরিকা/বৃষ্টি_নদী",
                "আমেরিকা/কেমব্রিজ_বে",
                "আমেরিকা/রেজিনা",
                "আমেরিকা/সুইফট_কারেন্ট",
                "আমেরিকা/এডমন্টন",
                "আমেরিকা/ইয়েলোনাইফ",
                "আমেরিকা/ইনুভিক",
                "আমেরিকা/ডসন_ক্রিক",
                "আমেরিকা/ভ্যাঙ্কুভার",
                "আমেরিকা/হোয়াইটহরস",
                "আমেরিকা/ডসন",
            ],
            "alpha-2-code": "CA",
            "alpha-3-code": "CAN",
            "continent": "উত্তর আমেরিকা",
            "name": "কানাডা",
            "capital": "অটোয়া",
        },
        {
            "timezones": ["আফ্রিকা/কিনশাসা", "আফ্রিকা/লুবুম্বাশি"],
            "alpha-2-code": "CD",
            "alpha-3-code": "COD",
            "continent": "আফ্রিকা",
            "name": "কঙ্গো গণতান্ত্রিক প্রজাতন্ত্র",
            "capital": "কিনশাসা",
        },
        {
            "timezones": ["আফ্রিকা/ব্রাজাভিল"],
            "alpha-2-code": "CG",
            "alpha-3-code": "COG",
            "continent": "আফ্রিকা",
            "name": "কঙ্গো প্রজাতন্ত্র",
            "capital": "ব্রাজাভিল",
        },
        {
            "timezones": ["আফ্রিকা/আবিজান"],
            "alpha-2-code": "CI",
            "alpha-3-code": "CIV",
            "continent": "আফ্রিকা",
            "name": "C\xc3\xb4te d'Ivoire",
            "capital": "ইয়ামুসুক্রো",
        },
        {
            "timezones": ["আমেরিকা/সান্টিয়াগো", "প্যাসিফিক/ইস্টার"],
            "alpha-2-code": "CL",
            "alpha-3-code": "CHL",
            "continent": "দক্ষিণ আমেরিকা",
            "name": "চিলি",
            "capital": "সান্তিয়াগো",
        },
        {
            "timezones": ["আফ্রিকা/ডুয়ালা"],
            "alpha-2-code": "CM",
            "alpha-3-code": "CMR",
            "continent": "আফ্রিকা",
            "name": "ক্যামেরুন",
            "capital": "ইয়াউন্ড",
        },
        {
            "timezones": [
                "এশিয়া/সাংহাই",
                "এশিয়া/হারবিন",
                "এশিয়া/চংকিং",
                "এশিয়া/উরুমকি",
                "এশিয়া/কাশগর",
            ],
            "alpha-2-code": "CN",
            "alpha-3-code": "CHN",
            "continent": "এশিয়া",
            "name": "গণপ্রজাতন্ত্রী চীন",
            "capital": "বেইজিং",
        },
        {
            "timezones": ["আমেরিকা/বোগোটা"],
            "alpha-2-code": "CO",
            "alpha-3-code": "COL",
            "continent": "দক্ষিণ আমেরিকা",
            "name": "কলম্বিয়া",
            "capital": "বোগোট\xc3\xa1",
        },
        {
            "timezones": ["আমেরিকা/কোস্টা_রিকা"],
            "alpha-2-code": "CR",
            "alpha-3-code": "CRI",
            "continent": "উত্তর আমেরিকা",
            "name": "কোস্টারিকা",
            "capital": "সান জোস\xc3\xa9",
        },
        {
            "timezones": ["আমেরিকা/হাভানা"],
            "alpha-2-code": "CU",
            "alpha-3-code": "CUB",
            "continent": "উত্তর আমেরিকা",
            "name": "কিউবা",
            "capital": "হাভানা",
        },
        {
            "timezones": ["আটলান্টিক/কেপ_ভার্দে"],
            "alpha-2-code": "সিভি",
            "alpha-3-code": "CPV",
            "continent": "আফ্রিকা",
            "name": "কেপ ভার্দে",
            "capital": "প্রাইয়া",
        },
        {
            "timezones": ["এশিয়া/নিকোসিয়া"],
            "alpha-2-code": "CY",
            "alpha-3-code": "CYP",
            "continent": "এশিয়া",
            "name": "সাইপ্রাস",
            "capital": "নিকোসিয়া",
        },
        {
            "timezones": ["ইউরোপ/প্রাগ"],
            "alpha-2-code": "CZ",
            "alpha-3-code": "CZE",
            "continent": "ইউরোপ",
            "name": "চেক প্রজাতন্ত্র",
            "capital": "প্রাগ",
        },
        {
            "timezones": ["ইউরোপ/বার্লিন"],
            "alpha-2-code": "DE",
            "alpha-3-code": "DEU",
            "continent": "ইউরোপ",
            "name": "জার্মানি",
            "capital": "বার্লিন",
        },
        {
            "timezones": ["আফ্রিকা/জিবুতি"],
            "alpha-2-code": "ডিজে",
            "alpha-3-code": "DJI",
            "continent": "আফ্রিকা",
            "name": "জিবুতি",
            "capital": "জিবুতি শহর",
        },
        {
            "timezones": ["ইউরোপ/কোপেনহেগেন"],
            "alpha-2-code": "DK",
            "alpha-3-code": "DNK",
            "continent": "ইউরোপ",
            "name": "ডেনমার্ক",
            "capital": "কোপেনহেগেন",
        },
        {
            "timezones": ["আমেরিকা/ডোমিনিকা"],
            "alpha-2-code": "DM",
            "alpha-3-code": "DMA",
            "continent": "উত্তর আমেরিকা",
            "name": "ডোমিনিকা",
            "capital": "রোজাও",
        },
        {
            "timezones": ["আমেরিকা/সান্টো_ডোমিঙ্গো"],
            "alpha-2-code": "করুন",
            "alpha-3-code": "DOM",
            "continent": "উত্তর আমেরিকা",
            "name": "ডোমিনিকান রিপাবলিক",
            "capital": "সান্তো ডোমিঙ্গো",
        },
        {
            "timezones": ["আমেরিকা/গুয়াকিল", "প্যাসিফিক/গালাপাগোস"],
            "alpha-2-code": "EC",
            "alpha-3-code": "ECU",
            "continent": "দক্ষিণ আমেরিকা",
            "name": "ইকুয়েডর",
            "capital": "কুইটো",
        },
        {
            "timezones": ["ইউরোপ/টালিন"],
            "alpha-2-code": "EE",
            "alpha-3-code": "EST",
            "continent": "ইউরোপ",
            "name": "এস্তোনিয়া",
            "capital": "টালিন",
        },
        {
            "timezones": ["আফ্রিকা/কায়রো"],
            "alpha-2-code": "EG",
            "alpha-3-code": "EGY",
            "continent": "আফ্রিকা",
            "name": "মিশর",
            "capital": "কায়রো",
        },
        {
            "timezones": ["আফ্রিকা/আসমেরা"],
            "alpha-2-code": "ER",
            "alpha-3-code": "ERI",
            "continent": "আফ্রিকা",
            "name": "ইরিত্রিয়া",
            "capital": "আসমারা",
        },
        {
            "timezones": ["আফ্রিকা/আদিস_আবাবা"],
            "alpha-2-code": "ET",
            "alpha-3-code": "ETH",
            "continent": "আফ্রিকা",
            "name": "ইথিওপিয়া",
            "capital": "আদিস আবাবা",
        },
        {
            "timezones": ["ইউরোপ/হেলসিঙ্কি"],
            "alpha-2-code": "FI",
            "alpha-3-code": "FIN",
            "continent": "ইউরোপ",
            "name": "ফিনল্যান্ড",
            "capital": "হেলসিঙ্কি",
        },
        {
            "timezones": ["প্যাসিফিক/ফিজি"],
            "alpha-2-code": "FJ",
            "alpha-3-code": "FJI",
            "continent": "ওশেনিয়া",
            "name": "ফিজি",
            "capital": "সুভা",
        },
        {
            "timezones": ["ইউরোপ/প্যারিস"],
            "alpha-2-code": "FR",
            "alpha-3-code": "FRA",
            "continent": "ইউরোপ",
            "name": "ফ্রান্স",
            "capital": "প্যারিস",
        },
        {
            "timezones": ["আফ্রিকা/লিব্রেভিল"],
            "alpha-2-code": "GA",
            "alpha-3-code": "GAB",
            "continent": "আফ্রিকা",
            "name": "গ্যাবন",
            "capital": "লিব্রেভিল",
        },
        {
            "timezones": ["এশিয়া/টিবিলিসি"],
            "alpha-2-code": "GE",
            "alpha-3-code": "জিও",
            "continent": "এশিয়া",
            "name": "জর্জিয়া",
            "capital": "তিবিলিসি",
        },
        {
            "timezones": ["আফ্রিকা/আকরা"],
            "alpha-2-code": "GH",
            "alpha-3-code": "GHA",
            "continent": "আফ্রিকা",
            "name": "ঘানা",
            "capital": "আকরা",
        },
        {
            "timezones": ["আফ্রিকা/বানজুল"],
            "alpha-2-code": "GM",
            "alpha-3-code": "GMB",
            "continent": "আফ্রিকা",
            "name": "গাম্বিয়া",
            "capital": "বানজুল",
        },
        {
            "timezones": ["আফ্রিকা/কোনাক্রি"],
            "alpha-2-code": "GN",
            "alpha-3-code": "GIN",
            "continent": "আফ্রিকা",
            "name": "গিনি",
            "capital": "কোনাক্রি",
        },
        {
            "timezones": ["ইউরোপ/এথেন্স"],
            "alpha-2-code": "GR",
            "alpha-3-code": "GRC",
            "continent": "ইউরোপ",
            "name": "গ্রীস",
            "capital": "এথেন্স",
        },
        {
            "timezones": ["আমেরিকা/গুয়েতেমালা"],
            "alpha-2-code": "GT",
            "alpha-3-code": "GTM",
            "continent": "উত্তর আমেরিকা",
            "name": "গুয়েতেমালা",
            "capital": "গুয়েতেমালা সিটি",
        },
        {
            "timezones": ["আমেরিকা/গুয়েতেমালা"],
            "alpha-2-code": "HT",
            "alpha-3-code": "HTI",
            "continent": "উত্তর আমেরিকা",
            "name": "হাইতি",
            "capital": "পোর্ট-অ-প্রিন্স",
        },
        {
            "timezones": ["আফ্রিকা/বিসাউ"],
            "alpha-2-code": "GW",
            "alpha-3-code": "GNB",
            "continent": "আফ্রিকা",
            "name": "গিনি-বিসাউ",
            "capital": "বিসাউ",
        },
        {
            "timezones": ["আমেরিকা/গিয়ানা"],
            "alpha-2-code": "GY",
            "alpha-3-code": "লোক",
            "continent": "দক্ষিণ আমেরিকা",
            "name": "গিয়ানা",
            "capital": "জর্জটাউন",
        },
        {
            "timezones": ["আমেরিকা/টেগুসিগালপা"],
            "alpha-2-code": "HN",
            "alpha-3-code": "HND",
            "continent": "উত্তর আমেরিকা",
            "name": "হন্ডুরাস",
            "capital": "টেগুসিগালপা",
        },
        {
            "timezones": ["ইউরোপ/বুদাপেস্ট"],
            "alpha-2-code": "HU",
            "alpha-3-code": "HUN",
            "continent": "ইউরোপ",
            "name": "হাঙ্গেরি",
            "capital": "বুদাপেস্ট",
        },
        {
            "timezones": [
                "এশিয়া/জাকার্তা",
                "এশিয়া/পন্টিয়ানাক",
                "এশিয়া/মাকাসার",
                "এশিয়া/জয়াপুরা",
            ],
            "alpha-2-code": "আইডি",
            "alpha-3-code": "IDN",
            "continent": "এশিয়া",
            "name": "ইন্দোনেশিয়া",
            "capital": "জাকার্তা",
        },
        {
            "timezones": ["ইউরোপ/ডাবলিন"],
            "alpha-2-code": "IE",
            "alpha-3-code": "IRL",
            "continent": "ইউরোপ",
            "name": "আয়ারল্যান্ড প্রজাতন্ত্র",
            "capital": "ডাবলিন",
        },
        {
            "timezones": ["এশিয়া/জেরুজালেম"],
            "alpha-2-code": "IL",
            "alpha-3-code": "ISR",
            "continent": "এশিয়া",
            "name": "ইসরায়েল",
            "capital": "জেরুজালেম",
        },
        {
            "timezones": ["এশিয়া/কলকাতা"],
            "alpha-2-code": "IN",
            "alpha-3-code": "IND",
            "continent": "এশিয়া",
            "name": "ভারত",
            "capital": "নয়া দিল্লী",
        },
        {
            "timezones": ["এশিয়া/বাগদাদ"],
            "alpha-2-code": "IQ",
            "alpha-3-code": "IRQ",
            "continent": "এশিয়া",
            "name": "ইরাক",
            "capital": "বাগদাদ",
        },
        {
            "timezones": ["এশিয়া/তেহরান"],
            "alpha-2-code": "IR",
            "alpha-3-code": "IRN",
            "continent": "এশিয়া",
            "name": "ইরান",
            "capital": "তেহরান",
        },
        {
            "timezones": ["আটলান্টিক/রেকজাভিক"],
            "alpha-2-code": "IS",
            "alpha-3-code": "ISL",
            "continent": "ইউরোপ",
            "name": "আইসল্যান্ড",
            "capital": "রেকজাভিক",
        },
        {
            "timezones": ["ইউরোপ/রোম"],
            "alpha-2-code": "IT",
            "alpha-3-code": "ITA",
            "continent": "ইউরোপ",
            "name": "ইতালি",
            "capital": "রোম",
        },
        {
            "timezones": ["আমেরিকা/জ্যামাইকা"],
            "alpha-2-code": "JM",
            "alpha-3-code": "JAM",
            "continent": "উত্তর আমেরিকা",
            "name": "জ্যামাইকা",
            "capital": "কিংসটন",
        },
        {
            "timezones": ["এশিয়া/আম্মান"],
            "alpha-2-code": "JO",
            "alpha-3-code": "JOR",
            "continent": "এশিয়া",
            "name": "জর্ডান",
            "capital": "আম্মান",
        },
        {
            "timezones": ["এশিয়া/টোকিও"],
            "alpha-2-code": "JP",
            "alpha-3-code": "JPN",
            "continent": "এশিয়া",
            "name": "জাপান",
            "capital": "টোকিও",
        },
        {
            "timezones": ["আফ্রিকা/নাইরোবি"],
            "alpha-2-code": "KE",
            "alpha-3-code": "KEN",
            "continent": "আফ্রিকা",
            "name": "কেনিয়া",
            "capital": "নাইরোবি",
        },
        {
            "timezones": ["এশিয়া/বিশকেক"],
            "alpha-2-code": "কেজি",
            "alpha-3-code": "KGZ",
            "continent": "এশিয়া",
            "name": "কিরগিজস্তান",
            "capital": "বিশকেক",
        },
        {
            "timezones": ["প্যাসিফিক/তারাওয়া", "প্যাসিফিক/এন্ডারবেরি", "প্যাসিফিক/কিরিটিমাতি"],
            "alpha-2-code": "KI",
            "alpha-3-code": "KIR",
            "continent": "ওশেনিয়া",
            "name": "কিরিবাতি",
            "capital": "তারাওয়া",
        },
        {
            "timezones": ["এশিয়া/পিয়ংইয়ং"],
            "alpha-2-code": "KP",
            "alpha-3-code": "PRK",
            "continent": "এশিয়া",
            "name": "উত্তর কোরিয়া",
            "capital": "পিয়ংইয়ং",
        },
        {
            "timezones": ["এশিয়া/সিউল"],
            "alpha-2-code": "KR",
            "alpha-3-code": "KOR",
            "continent": "এশিয়া",
            "name": "দক্ষিণ কোরিয়া",
            "capital": "সিউল",
        },
        {
            "timezones": ["এশিয়া/কুয়েত"],
            "alpha-2-code": "কিলোওয়াট",
            "alpha-3-code": "KWT",
            "continent": "এশিয়া",
            "name": "কুয়েত",
            "capital": "কুয়েত সিটি",
        },
        {
            "timezones": ["এশিয়া/বৈরুত"],
            "alpha-2-code": "LB",
            "alpha-3-code": "LBN",
            "continent": "এশিয়া",
            "name": "লেবানন",
            "capital": "বৈরুত",
        },
        {
            "timezones": ["ইউরোপ/ভাদুজ"],
            "alpha-2-code": "LI",
            "alpha-3-code": "মিথ্যা",
            "continent": "ইউরোপ",
            "name": "লিচেনস্টাইন",
            "capital": "ভাদুজ",
        },
        {
            "timezones": ["আফ্রিকা/মনরোভিয়া"],
            "alpha-2-code": "LR",
            "alpha-3-code": "LBR",
            "continent": "আফ্রিকা",
            "name": "লাইবেরিয়া",
            "capital": "মনরোভিয়া",
        },
        {
            "timezones": ["আফ্রিকা/মাসেরু"],
            "alpha-2-code": "LS",
            "alpha-3-code": "LSO",
            "continent": "আফ্রিকা",
            "name": "লেসোথো",
            "capital": "মাসেরু",
        },
        {
            "timezones": ["ইউরোপ/ভিলনিয়াস"],
            "alpha-2-code": "LT",
            "alpha-3-code": "LTU",
            "continent": "ইউরোপ",
            "name": "লিথুয়ানিয়া",
            "capital": "ভিলনিয়াস",
        },
        {
            "timezones": ["ইউরোপ/লাক্সেমবার্গ"],
            "alpha-2-code": "LU",
            "alpha-3-code": "LUX",
            "continent": "ইউরোপ",
            "name": "লাক্সেমবার্গ",
            "capital": "লাক্সেমবার্গ সিটি",
        },
        {
            "timezones": ["ইউরোপ/রিগা"],
            "alpha-2-code": "LV",
            "alpha-3-code": "LVA",
            "continent": "ইউরোপ",
            "name": "লাটভিয়া",
            "capital": "রিগা",
        },
        {
            "timezones": ["আফ্রিকা/ত্রিপোলি"],
            "alpha-2-code": "LY",
            "alpha-3-code": "LBY",
            "continent": "আফ্রিকা",
            "name": "লিবিয়া",
            "capital": "ত্রিপোলি",
        },
        {
            "timezones": ["ভারতীয়/আন্তানানারিভো"],
            "alpha-2-code": "MG",
            "alpha-3-code": "MDG",
            "continent": "আফ্রিকা",
            "name": "মাদাগাস্কার",
            "capital": "আন্তানানারিভো",
        },
        {
            "timezones": ["প্যাসিফিক/মাজুরো", "প্যাসিফিক/কোয়াজালেইন"],
            "alpha-2-code": "MH",
            "alpha-3-code": "MHL",
            "continent": "ওশেনিয়া",
            "name": "মার্শাল দ্বীপপুঞ্জ",
            "capital": "মাজুরো",
        },
        {
            "timezones": ["ইউরোপ/স্কোপজে"],
            "alpha-2-code": "MK",
            "alpha-3-code": "MKD",
            "continent": "ইউরোপ",
            "name": "ম্যাসিডোনিয়া",
            "capital": "স্কোপজে",
        },
        {
            "timezones": ["আফ্রিকা/বামাকো"],
            "alpha-2-code": "ML",
            "alpha-3-code": "MLI",
            "continent": "আফ্রিকা",
            "name": "মালি",
            "capital": "বামাকো",
        },
        {
            "timezones": ["এশিয়া/রেঙ্গুন"],
            "alpha-2-code": "MM",
            "alpha-3-code": "MMR",
            "continent": "এশিয়া",
            "name": "মিয়ানমার",
            "capital": "নায়প্যিদা",
        },
        {
            "timezones": ["এশিয়া/উলানবাতার", "এশিয়া/হোভড", "এশিয়া/চোইবালসান"],
            "alpha-2-code": "MN",
            "alpha-3-code": "MNG",
            "continent": "এশিয়া",
            "name": "মঙ্গোলিয়া",
            "capital": "উলানবাতার",
        },
        {
            "timezones": ["আফ্রিকা/নোয়াকচট"],
            "alpha-2-code": "MR",
            "alpha-3-code": "MRT",
            "continent": "আফ্রিকা",
            "name": "মৌরিতানিয়া",
            "capital": "নুয়াকচট",
        },
        {
            "timezones": ["ইউরোপ/মাল্টা"],
            "alpha-2-code": "MT",
            "alpha-3-code": "MLT",
            "continent": "ইউরোপ",
            "name": "মাল্টা",
            "capital": "ভ্যালেটা",
        },
        {
            "timezones": ["ভারতীয়/মরিশাস"],
            "alpha-2-code": "MU",
            "alpha-3-code": "MUS",
            "continent": "আফ্রিকা",
            "name": "মরিশাস",
            "capital": "পোর্ট লুইস",
        },
        {
            "timezones": ["ভারতীয়/মালদ্বীপ"],
            "alpha-2-code": "MV",
            "alpha-3-code": "MDV",
            "continent": "এশিয়া",
            "name": "মালদ্বীপ",
            "capital": "মাল\xc3\xa9",
        },
        {
            "timezones": ["আফ্রিকা/ব্লান্টিয়ার"],
            "alpha-2-code": "মেগাওয়াট",
            "alpha-3-code": "MWI",
            "continent": "আফ্রিকা",
            "name": "মালাউই",
            "capital": "লিলংওয়ে",
        },
        {
            "timezones": [
                "আমেরিকা/মেক্সিকো_সিটি",
                "আমেরিকা/কানকুন",
                "আমেরিকা/মেরিডা",
                "আমেরিকা/মন্টেরে",
                "আমেরিকা/মাজাতলান",
                "আমেরিকা/চিহুয়াহুয়া",
                "আমেরিকা/হার্মোসিলো",
                "আমেরিকা/টিজুয়ানা",
            ],
            "alpha-2-code": "MX",
            "alpha-3-code": "MEX",
            "continent": "উত্তর আমেরিকা",
            "name": "মেক্সিকো",
            "capital": "মেক্সিকো সিটি",
        },
        {
            "timezones": ["এশিয়া/কুয়ালা_লামপুর", "এশিয়া/কুচিং"],
            "alpha-2-code": "আমার",
            "alpha-3-code": "MYS",
            "continent": "এশিয়া",
            "name": "মালয়েশিয়া",
            "capital": "কুয়ালালামপুর",
        },
        {
            "timezones": ["আফ্রিকা/মাপুটো"],
            "alpha-2-code": "MZ",
            "alpha-3-code": "MOZ",
            "continent": "আফ্রিকা",
            "name": "মোজাম্বিক",
            "capital": "মাপুতো",
        },
        {
            "timezones": ["আফ্রিকা/উইন্ডহোক"],
            "alpha-2-code": "NA",
            "alpha-3-code": "NAM",
            "continent": "আফ্রিকা",
            "name": "nameিবিয়া",
            "capital": "উইন্ডহোক",
        },
        {
            "timezones": ["আফ্রিকা/নিয়ামে"],
            "alpha-2-code": "NE",
            "alpha-3-code": "NER",
            "continent": "আফ্রিকা",
            "name": "নাইজার",
            "capital": "নিয়ামে",
        },
        {
            "timezones": ["আফ্রিকা/লাগোস"],
            "alpha-2-code": "NG",
            "alpha-3-code": "NGA",
            "continent": "আফ্রিকা",
            "name": "নাইজেরিয়া",
            "capital": "আবুজা",
        },
        {
            "timezones": ["আমেরিকা/মানাগুয়া"],
            "alpha-2-code": "NI",
            "alpha-3-code": "NIC",
            "continent": "উত্তর আমেরিকা",
            "name": "নিকারাগুয়া",
            "capital": "মানাগুয়া",
        },
        {
            "timezones": ["ইউরোপ/আমস্টারডাম"],
            "alpha-2-code": "NL",
            "alpha-3-code": "NLD",
            "continent": "ইউরোপ",
            "name": "নেদারল্যান্ডের রাজ্য",
            "capital": "আমস্টারডাম",
        },
        {
            "timezones": ["ইউরোপ/অসলো"],
            "alpha-2-code": "না",
            "alpha-3-code": "NOR",
            "continent": "ইউরোপ",
            "name": "নরওয়ে",
            "capital": "অসলো",
        },
        {
            "timezones": ["এশিয়া/কাটমান্ডু"],
            "alpha-2-code": "NP",
            "alpha-3-code": "NPL",
            "continent": "এশিয়া",
            "name": "নেপাল",
            "capital": "কাঠমান্ডু",
        },
        {
            "timezones": ["প্যাসিফিক/নাউরু"],
            "alpha-2-code": "NR",
            "alpha-3-code": "NRU",
            "continent": "ওশেনিয়া",
            "name": "নাউরু",
            "capital": "ইয়েরেন",
        },
        {
            "timezones": ["প্যাসিফিক/অকল্যান্ড", "প্যাসিফিক/চ্যাথাম"],
            "alpha-2-code": "NZ",
            "alpha-3-code": "NZL",
            "continent": "ওশেনিয়া",
            "name": "নিউজিল্যান্ড",
            "capital": "ওয়েলিংটন",
        },
        {
            "timezones": ["এশিয়া/মাস্কাট"],
            "alpha-2-code": "OM",
            "alpha-3-code": "OMN",
            "continent": "এশিয়া",
            "name": "ওমান",
            "capital": "মাস্কাট",
        },
        {
            "timezones": ["আমেরিকা/পাnameা"],
            "alpha-2-code": "PA",
            "alpha-3-code": "PAN",
            "continent": "উত্তর আমেরিকা",
            "name": "পাnameা",
            "capital": "পাnameা সিটি",
        },
        {
            "timezones": ["আমেরিকা/লিমা"],
            "alpha-2-code": "PE",
            "alpha-3-code": "PER",
            "continent": "দক্ষিণ আমেরিকা",
            "name": "পেরু",
            "capital": "লিমা",
        },
        {
            "timezones": ["প্যাসিফিক/পোর্ট_মোরেসবি"],
            "alpha-2-code": "PG",
            "alpha-3-code": "PNG",
            "continent": "ওশেনিয়া",
            "name": "পাপুয়া নিউ গিনি",
            "capital": "পোর্ট মোরসবি",
        },
        {
            "timezones": ["এশিয়া/ম্যানিলা"],
            "alpha-2-code": "PH",
            "alpha-3-code": "PHL",
            "continent": "এশিয়া",
            "name": "ফিলিপাইন",
            "capital": "ম্যানিলা",
        },
        {
            "timezones": ["এশিয়া/করাচি"],
            "alpha-2-code": "PK",
            "alpha-3-code": "PAK",
            "continent": "এশিয়া",
            "name": "পাকিস্তান",
            "capital": "ইসলামাবাদ",
        },
        {
            "timezones": ["ইউরোপ/ওয়ারশ"],
            "alpha-2-code": "PL",
            "alpha-3-code": "POL",
            "continent": "ইউরোপ",
            "name": "পোল্যান্ড",
            "capital": "ওয়ারশ",
        },
        {
            "timezones": ["ইউরোপ/লিসবন", "আটলান্টিক/মাদেইরা", "আটলান্টিক/আজোরস"],
            "alpha-2-code": "PT",
            "alpha-3-code": "PRT",
            "continent": "ইউরোপ",
            "name": "পর্তুগাল",
            "capital": "লিসবন",
        },
        {
            "timezones": ["প্যাসিফিক/পালাউ"],
            "alpha-2-code": "PW",
            "alpha-3-code": "PLW",
            "continent": "ওশেনিয়া",
            "name": "পালাউ",
            "capital": "এনগেরুলমুদ",
        },
        {
            "timezones": ["আমেরিকা/আসুনসিয়ন"],
            "alpha-2-code": "PY",
            "alpha-3-code": "PRY",
            "continent": "দক্ষিণ আমেরিকা",
            "name": "প্যারাগুয়ে",
            "capital": "আসুন্সি\xc3\xb3n",
        },
        {
            "timezones": ["এশিয়া/কাতার"],
            "alpha-2-code": "QA",
            "alpha-3-code": "QAT",
            "continent": "এশিয়া",
            "name": "কাতার",
            "capital": "দোহা",
        },
        {
            "timezones": ["ইউরোপ/বুখারেস্ট"],
            "alpha-2-code": "RO",
            "alpha-3-code": "ROU",
            "continent": "ইউরোপ",
            "name": "রোমানিয়া",
            "capital": "বুখারেস্ট",
        },
        {
            "timezones": [
                "ইউরোপ/ক্যালিনিনগ্রাদ",
                "ইউরোপ/মস্কো",
                "ইউরোপ/ভলগোগ্রাদ",
                "ইউরোপ/সামারা",
                "এশিয়া/ইয়েকাটেরিনবার্গ",
                "এশিয়া/ওমস্ক",
                "এশিয়া/নভোসিবিরস্ক",
                "এশিয়া/ক্রাসনোয়ারস্ক",
                "এশিয়া/ইরকুটস্ক",
                "এশিয়া/ইয়াকুটস্ক",
                "এশিয়া/ভ্লাদিভোস্টক",
                "এশিয়া/সাখালিন",
                "এশিয়া/মাগাদান",
                "এশিয়া/কামচাটকা",
                "এশিয়া/আনাডার",
            ],
            "alpha-2-code": "RU",
            "alpha-3-code": "RUS",
            "continent": "ইউরোপ",
            "name": "রাশিয়া",
            "capital": "মস্কো",
        },
        {
            "timezones": ["আফ্রিকা/কিগালি"],
            "alpha-2-code": "RW",
            "alpha-3-code": "RWA",
            "continent": "আফ্রিকা",
            "name": "রুয়ান্ডা",
            "capital": "কিগালি",
        },
        {
            "timezones": ["এশিয়া/রিয়াদ"],
            "alpha-2-code": "SA",
            "alpha-3-code": "SAU",
            "continent": "এশিয়া",
            "name": "সৌদি আরব",
            "capital": "রিয়াদ",
        },
        {
            "timezones": ["প্যাসিফিক/গুয়াডালকানাল"],
            "alpha-2-code": "SB",
            "alpha-3-code": "SLB",
            "continent": "ওশেনিয়া",
            "name": "সলোমন দ্বীপপুঞ্জ",
            "capital": "হোনিয়ারা",
        },
        {
            "timezones": ["ভারতীয়/মাহে"],
            "alpha-2-code": "SC",
            "alpha-3-code": "SYC",
            "continent": "আফ্রিকা",
            "name": "সেশেলস",
            "capital": "ভিক্টোরিয়া",
        },
        {
            "timezones": ["আফ্রিকা/খার্তুম"],
            "alpha-2-code": "SD",
            "alpha-3-code": "SDN",
            "continent": "আফ্রিকা",
            "name": "সুদান",
            "capital": "খার্তুম",
        },
        {
            "timezones": ["ইউরোপ/স্টকহোম"],
            "alpha-2-code": "SE",
            "alpha-3-code": "SWE",
            "continent": "ইউরোপ",
            "name": "সুইডেন",
            "capital": "স্টকহোম",
        },
        {
            "timezones": ["এশিয়া/সিঙ্গাপুর"],
            "alpha-2-code": "SG",
            "alpha-3-code": "SGP",
            "continent": "এশিয়া",
            "name": "সিঙ্গাপুর",
            "capital": "সিঙ্গাপুর",
        },
        {
            "timezones": ["ইউরোপ/লুব্লজানা"],
            "alpha-2-code": "SI",
            "alpha-3-code": "SVN",
            "continent": "ইউরোপ",
            "name": "স্লোভেনিয়া",
            "capital": "লুব্লজানা",
        },
        {
            "timezones": ["ইউরোপ/ব্র্যাটিস্লাভা"],
            "alpha-2-code": "SK",
            "alpha-3-code": "SVK",
            "continent": "ইউরোপ",
            "name": "স্লোভাকিয়া",
            "capital": "ব্রাটিস্লাভা",
        },
        {
            "timezones": ["আফ্রিকা/ফ্রিটাউন"],
            "alpha-2-code": "SL",
            "alpha-3-code": "SLE",
            "continent": "আফ্রিকা",
            "name": "সিয়েরা লিওন",
            "capital": "ফ্রিটাউন",
        },
        {
            "timezones": ["ইউরোপ/সান_মারিনো"],
            "alpha-2-code": "SM",
            "alpha-3-code": "SMR",
            "continent": "ইউরোপ",
            "name": "সান মারিনো",
            "capital": "সান মারিনো",
        },
        {
            "timezones": ["আফ্রিকা/ডাকার"],
            "alpha-2-code": "SN",
            "alpha-3-code": "SEN",
            "continent": "আফ্রিকা",
            "name": "সেনেগাল",
            "capital": "ডাকার",
        },
        {
            "timezones": ["আফ্রিকা/মোগাদিশু"],
            "alpha-2-code": "SO",
            "alpha-3-code": "SOM",
            "continent": "আফ্রিকা",
            "name": "সোমালিয়া",
            "capital": "মোগাদিশু",
        },
        {
            "timezones": ["আমেরিকা/পারামারিবো"],
            "alpha-2-code": "SR",
            "alpha-3-code": "SUR",
            "continent": "দক্ষিণ আমেরিকা",
            "name": "সুরিname",
            "capital": "পারমারিবো",
        },
        {
            "timezones": ["আফ্রিকা/সাও_টোম"],
            "alpha-2-code": "ST",
            "alpha-3-code": "STP",
            "continent": "আফ্রিকা",
            "name": "S\xc3\xa3o Tom\xc3\xa9 এবং Pr\xc3\xadncipe",
            "capital": "S\xc3\xa3o টম\xc3\xa9",
        },
        {
            "timezones": ["এশিয়া/দামাস্কাস"],
            "alpha-2-code": "SY",
            "alpha-3-code": "SYR",
            "continent": "এশিয়া",
            "name": "সিরিয়া",
            "capital": "দামাস্কাস",
        },
        {
            "timezones": ["আফ্রিকা/লোম"],
            "alpha-2-code": "TG",
            "alpha-3-code": "TGO",
            "continent": "আফ্রিকা",
            "name": "টোগো",
            "capital": "Lom\xc3\xa9",
        },
        {
            "timezones": ["এশিয়া/ব্যাংকক"],
            "alpha-2-code": "TH",
            "alpha-3-code": "THA",
            "continent": "এশিয়া",
            "name": "থাইল্যান্ড",
            "capital": "ব্যাংকক",
        },
        {
            "timezones": ["এশিয়া/দুশানবে"],
            "alpha-2-code": "TJ",
            "alpha-3-code": "TJK",
            "continent": "এশিয়া",
            "name": "তাজিকিস্তান",
            "capital": "দুশানবে",
        },
        {
            "timezones": ["এশিয়া/আশগাবাত"],
            "alpha-2-code": "TM",
            "alpha-3-code": "TKM",
            "continent": "এশিয়া",
            "name": "তুর্কমেনিস্তান",
            "capital": "আশগাবাত",
        },
        {
            "timezones": ["আফ্রিকা/টিউনিস"],
            "alpha-2-code": "TN",
            "alpha-3-code": "TUN",
            "continent": "আফ্রিকা",
            "name": "তিউনিসিয়া",
            "capital": "তিউনিস",
        },
        {
            "timezones": ["প্যাসিফিক/টোঙ্গাটাপু"],
            "alpha-2-code": "TO",
            "alpha-3-code": "TON",
            "continent": "ওশেনিয়া",
            "name": "টোঙ্গা",
            "capital": "নুকু\xca\xbbalofa",
        },
        {
            "timezones": ["ইউরোপ/ইস্তানবুল"],
            "alpha-2-code": "TR",
            "alpha-3-code": "TUR",
            "continent": "এশিয়া",
            "name": "তুরস্ক",
            "capital": "আঙ্কারা",
        },
        {
            "timezones": ["আমেরিকা/পোর্ট_অফ_স্পেন"],
            "alpha-2-code": "TT",
            "alpha-3-code": "TTO",
            "continent": "উত্তর আমেরিকা",
            "name": "ত্রিনিদাদ ও টোবাগো",
            "capital": "স্পেন বন্দর",
        },
        {
            "timezones": ["প্যাসিফিক/ফুনাফুটি"],
            "alpha-2-code": "টিভি",
            "alpha-3-code": "TUV",
            "continent": "ওশেনিয়া",
            "name": "টুভালু",
            "capital": "ফুনাফুটি",
        },
        {
            "timezones": ["আফ্রিকা/দার_এস_সালাম"],
            "alpha-2-code": "TZ",
            "alpha-3-code": "TZA",
            "continent": "আফ্রিকা",
            "name": "তানজানিয়া",
            "capital": "ডোডোমা",
        },
        {
            "timezones": [
                "ইউরোপ/কিয়েভ",
                "ইউরোপ/উজগোরড",
                "ইউরোপ/জাপোরোজি",
                "ইউরোপ/সিমফেরোপল",
            ],
            "alpha-2-code": "UA",
            "alpha-3-code": "UKR",
            "continent": "ইউরোপ",
            "name": "ইউক্রেন",
            "capital": "কিয়েভ",
        },
        {
            "timezones": ["আফ্রিকা/কাম্পালা"],
            "alpha-2-code": "UG",
            "alpha-3-code": "UGA",
            "continent": "আফ্রিকা",
            "name": "উগান্ডা",
            "capital": "কাম্পালা",
        },
        {
            "timezones": [
                "আমেরিকা/নিউইয়র্ক",
                "আমেরিকা/ডেট্রয়েট",
                "আমেরিকা/কেনটাকি/লুইসভিল",
                "আমেরিকা/কেনটাকি/মন্টিসেলো",
                "আমেরিকা/ইন্ডিয়ানা/ইন্ডিয়ানাপোলিস",
                "আমেরিকা/ইন্ডিয়ানা/মারেঙ্গো",
                "আমেরিকা/ইন্ডিয়ানা/নক্স",
                "আমেরিকা/ইন্ডিয়ানা/ভেভে",
                "আমেরিকা/শিকাগো",
                "আমেরিকা/ইন্ডিয়ানা/ভিনসেনেস",
                "আমেরিকা/ইন্ডিয়ানা/পিটার্সবার্গ",
                "আমেরিকা/মেনোমিনী",
                "আমেরিকা/উত্তর_ডাকোটা/সেন্টার",
                "আমেরিকা/উত্তর_ডাকোটা/নিউ_সালেম",
                "আমেরিকা/ডেনভার",
                "আমেরিকা/বোইস",
                "আমেরিকা/শিপ্রক",
                "আমেরিকা/ফিনিক্স",
                "আমেরিকা/লস_এঞ্জেলেস",
                "আমেরিকা/অ্যাঙ্কোরেজ",
                "আমেরিকা/জুনেউ",
                "আমেরিকা/ইয়াকুটাত",
                "আমেরিকা/name",
                "আমেরিকা/আডাক",
                "প্যাসিফিক/হনোলুলু",
            ],
            "alpha-2-code": "মার্কিন যুক্তরাষ্ট্র",
            "alpha-3-code": "USA",
            "continent": "উত্তর আমেরিকা",
            "name": "মার্কিন যুক্তরাষ্ট্র",
            "capital": "ওয়াশিংটন, ডিসি",
        },
        {
            "timezones": ["আমেরিকা/মন্টেভিডিও"],
            "alpha-2-code": "UY",
            "alpha-3-code": "URY",
            "continent": "দক্ষিণ আমেরিকা",
            "name": "উরুগুয়ে",
            "capital": "মন্টেভিডিও",
        },
        {
            "timezones": ["এশিয়া/সমরকন্দ", "এশিয়া/তাসখন্দ"],
            "alpha-2-code": "UZ",
            "alpha-3-code": "UZB",
            "continent": "এশিয়া",
            "name": "উজবেকিস্তান",
            "capital": "তাসখন্দ",
        },
        {
            "timezones": ["ইউরোপ/ভ্যাটিকান"],
            "alpha-2-code": "VA",
            "alpha-3-code": "ভ্যাট",
            "continent": "ইউরোপ",
            "name": "ভ্যাটিকান সিটি",
            "capital": "ভ্যাটিকান সিটি",
        },
        {
            "timezones": ["আমেরিকা/কারাকাস"],
            "alpha-2-code": "VE",
            "alpha-3-code": "VEN",
            "continent": "দক্ষিণ আমেরিকা",
            "name": "ভেনিজুয়েলা",
            "capital": "কারাকাস",
        },
        {
            "timezones": ["এশিয়া/সাইগন"],
            "alpha-2-code": "VN",
            "alpha-3-code": "VNM",
            "continent": "এশিয়া",
            "name": "ভিয়েতname",
            "capital": "হানয়",
        },
        {
            "timezones": ["প্যাসিফিক/ইফেট"],
            "alpha-2-code": "VU",
            "alpha-3-code": "VUT",
            "continent": "ওশেনিয়া",
            "name": "ভানুয়াতু",
            "capital": "পোর্ট ভিলা",
        },
        {
            "timezones": ["এশিয়া/এডেন"],
            "alpha-2-code": "YE",
            "alpha-3-code": "YEM",
            "continent": "এশিয়া",
            "name": "ইয়েমেন",
            "capital": "সানা",
        },
        {
            "timezones": ["আফ্রিকা/লুসাকা"],
            "alpha-2-code": "ZM",
            "alpha-3-code": "ZMB",
            "continent": "আফ্রিকা",
            "name": "জাম্বিয়া",
            "capital": "লুসাকা",
        },
        {
            "timezones": ["আফ্রিকা/হারারে"],
            "alpha-2-code": "ZW",
            "alpha-3-code": "ZWE",
            "continent": "আফ্রিকা",
            "name": "জিম্বাবুয়ে",
            "capital": "হারারে",
        },
        {
            "timezones": ["আফ্রিকা/আলজিয়ার্স"],
            "alpha-2-code": "DZ",
            "alpha-3-code": "DZA",
            "continent": "আফ্রিকা",
            "name": "আলজেরিয়া",
            "capital": "আলজিয়ার্স",
        },
        {
            "timezones": ["ইউরোপ/সারাজেভো"],
            "alpha-2-code": "BA",
            "alpha-3-code": "BIH",
            "continent": "ইউরোপ",
            "name": "বসনিয়া ও হার্জেগোভিনা",
            "capital": "সারায়েভো",
        },
        {
            "timezones": ["এশিয়া/ফনম_পেন"],
            "alpha-2-code": "KH",
            "alpha-3-code": "KHM",
            "continent": "এশিয়া",
            "name": "কম্বোডিয়া",
            "capital": "নম পেন",
        },
        {
            "timezones": ["আফ্রিকা/বাঙ্গুই"],
            "alpha-2-code": "CF",
            "alpha-3-code": "CAF",
            "continent": "আফ্রিকা",
            "name": "মধ্য আফ্রিকান প্রজাতন্ত্র",
            "capital": "বাঙ্গুই",
        },
        {
            "timezones": ["আফ্রিকা/এনডজামেনা"],
            "alpha-2-code": "TD",
            "alpha-3-code": "TCD",
            "continent": "আফ্রিকা",
            "name": "চাদ",
            "capital": "এন'জামেনা",
        },
        {
            "timezones": ["ভারতীয়/কোমোরো"],
            "alpha-2-code": "KM",
            "alpha-3-code": "COM",
            "continent": "আফ্রিকা",
            "name": "কোমোরোস",
            "capital": "মোরোনি",
        },
        {
            "timezones": ["ইউরোপ/জাগরেব"],
            "alpha-2-code": "HR",
            "alpha-3-code": "HRV",
            "continent": "ইউরোপ",
            "name": "ক্রোয়েশিয়া",
            "capital": "জাগরেব",
        },
        {
            "timezones": ["এশিয়া/দিলি"],
            "alpha-2-code": "TL",
            "alpha-3-code": "TLS",
            "continent": "এশিয়া",
            "name": "পূর্ব তিমুর",
            "capital": "দিলি",
        },
        {
            "timezones": ["আমেরিকা/এল_সালভাদর"],
            "alpha-2-code": "SV",
            "alpha-3-code": "SLV",
            "continent": "উত্তর আমেরিকা",
            "name": "এল সালভাদর",
            "capital": "সান সালভাদর",
        },
        {
            "timezones": ["আফ্রিকা/মালাবো"],
            "alpha-2-code": "GQ",
            "alpha-3-code": "GNQ",
            "continent": "আফ্রিকা",
            "name": "নিরক্ষীয় গিনি",
            "capital": "মালাবো",
        },
        {
            "timezones": ["আমেরিকা/গ্রেনাডা"],
            "alpha-2-code": "GD",
            "alpha-3-code": "GRD",
            "continent": "উত্তর আমেরিকা",
            "name": "গ্রেনাডা",
            "capital": "সেন্ট জর্জস",
        },
        {
            "timezones": [
                "এশিয়া/আলমাটি",
                "এশিয়া/কিউজিলর্ডা",
                "এশিয়া/আকতোব",
                "এশিয়া/আকতাউ",
                "এশিয়া/ওরাল",
            ],
            "alpha-2-code": "KZ",
            "alpha-3-code": "KAZ",
            "continent": "এশিয়া",
            "name": "কাজাখস্তান",
            "capital": "আস্তানা",
        },
        {
            "timezones": ["এশিয়া/ভিয়েনতিয়েন"],
            "alpha-2-code": "LA",
            "alpha-3-code": "LAO",
            "continent": "এশিয়া",
            "name": "লাওস",
            "capital": "ভিয়েনতিয়েন",
        },
        {
            "timezones": ["প্যাসিফিক/ট্রুক", "প্যাসিফিক/পোনাপে", "প্যাসিফিক/কোসরা"],
            "alpha-2-code": "FM",
            "alpha-3-code": "FSM",
            "continent": "ওশেনিয়া",
            "name": "মাইক্রোনেশিয়ার ফেডারেটেড স্টেটস",
            "capital": "পালকির",
        },
        {
            "timezones": ["ইউরোপ/চিসিনাউ"],
            "alpha-2-code": "MD",
            "alpha-3-code": "MDA",
            "continent": "ইউরোপ",
            "name": "মোল্দোভা",
            "capital": "চি\xc5\x9fin\xc4\x83u",
        },
        {
            "timezones": ["ইউরোপ/মোনাকো"],
            "alpha-2-code": "MC",
            "alpha-3-code": "MCO",
            "continent": "ইউরোপ",
            "name": "মোনাকো",
            "capital": "মোনাকো",
        },
        {
            "timezones": ["ইউরোপ/পডগোরিকা"],
            "alpha-2-code": "ME",
            "alpha-3-code": "MNE",
            "continent": "ইউরোপ",
            "name": "মন্টিনিগ্রো",
            "capital": "পডগোরিকা",
        },
        {
            "timezones": ["আফ্রিকা/ক্যাসাব্লাঙ্কা"],
            "alpha-2-code": "MA",
            "alpha-3-code": "MAR",
            "continent": "আফ্রিকা",
            "name": "মরক্কো",
            "capital": "রাবাত",
        },
        {
            "timezones": ["আমেরিকা/সেন্ট_কিটস"],
            "alpha-2-code": "KN",
            "alpha-3-code": "KNA",
            "continent": "উত্তর আমেরিকা",
            "name": "সেন্ট কিটস অ্যান্ড নেভিস",
            "capital": "ব্যাসেটেরে",
        },
        {
            "timezones": ["আমেরিকা/সেন্ট_লুসিয়া"],
            "alpha-2-code": "LC",
            "alpha-3-code": "LCA",
            "continent": "উত্তর আমেরিকা",
            "name": "সেন্ট লুসিয়া",
            "capital": "ক্যাস্ট্রিজ",
        },
        {
            "timezones": ["America/St_Vincent"],
            "alpha-2-code": "ভিসি",
            "alpha-3-code": "VCT",
            "continent": "উত্তর আমেরিকা",
            "name": "সেন্ট ভিনসেন্ট এবং গ্রেনাডাইনস",
            "capital": "কিংসটাউন",
        },
        {
            "timezones": ["প্যাসিফিক/অপিয়া"],
            "alpha-2-code": "WS",
            "alpha-3-code": "WSM",
            "continent": "ওশেনিয়া",
            "name": "সামোয়া",
            "capital": "আপিয়া",
        },
        {
            "timezones": ["ইউরোপ/বেলগ্রেড"],
            "alpha-2-code": "RS",
            "alpha-3-code": "SRB",
            "continent": "ইউরোপ",
            "name": "সার্বিয়া",
            "capital": "বেলগ্রেড",
        },
        {
            "timezones": ["আফ্রিকা/জোহানেসবার্গ"],
            "alpha-2-code": "ZA",
            "alpha-3-code": "ZAF",
            "continent": "আফ্রিকা",
            "name": "দক্ষিণ আফ্রিকা",
            "capital": "প্রিটোরিয়া",
        },
        {
            "timezones": ["ইউরোপ/মাদ্রিদ", "আফ্রিকা/সেউটা", "আটলান্টিক/ক্যানারি"],
            "alpha-2-code": "ES",
            "alpha-3-code": "ESP",
            "continent": "ইউরোপ",
            "name": "স্পেন",
            "capital": "মাদ্রিদ",
        },
        {
            "timezones": ["এশিয়া/কলম্বো"],
            "alpha-2-code": "LK",
            "alpha-3-code": "LKA",
            "continent": "এশিয়া",
            "name": "শ্রীলঙ্কা",
            "capital": "শ্রী জয়বর্ধনেপুরা কোট্টে",
        },
        {
            "timezones": ["আফ্রিকা/এমবাবেন"],
            "alpha-2-code": "SZ",
            "alpha-3-code": "SWZ",
            "continent": "আফ্রিকা",
            "name": "সোয়াজিল্যান্ড",
            "capital": "এমবাবেন",
        },
        {
            "timezones": ["ইউরোপ/জুরিখ"],
            "alpha-2-code": "CH",
            "alpha-3-code": "CHE",
            "continent": "ইউরোপ",
            "name": "সুইজারল্যান্ড",
            "capital": "বার্ন",
        },
        {
            "timezones": ["এশিয়া/দুবাই"],
            "alpha-2-code": "AE",
            "alpha-3-code": "ARE",
            "continent": "এশিয়া",
            "name": "সংযুক্ত আরব আমিরাত",
            "capital": "আবুধাবি",
        },
        {
            "timezones": ["ইউরোপ/লন্ডন"],
            "alpha-2-code": "GB",
            "alpha-3-code": "GBR",
            "continent": "ইউরোপ",
            "name": "যুক্তরাজ্য",
            "capital": "লন্ডন",
        },
        {
            "timezones": ["এশিয়া/তাইপেই"],
            "alpha-2-code": "TW",
            "alpha-3-code": "TWN",
            "continent": "এশিয়া",
            "name": "তাইওয়ান",
            "capital": "তাইপেই",
        },
        {
            "timezones": ["এশিয়া/গাজা", "এশিয়া/হেব্রন"],
            "alpha-2-code": "PS",
            "alpha-3-code": "PSE",
            "continent": "এশিয়া",
            "name": "ফিলিস্তিন",
            "capital": "রামাল্লা",
        },
    ]

    def day_of_week(self) -> str:
        day = self.date("%w")
        return self.DAY_NAMES[day]

    def month_name(self) -> str:
        month = self.month()
        return self.MONTH_NAMES[month]
