/*
 * PMTAfft.h
 *
 * Copyright (c) 1995 Duke University 
 * All Rights Reserved.
 *
 * based on: Version 3.0, February 20, 1994 by Bill Elliott.
 *
 */

/*
 * RCS Id:
 *
 * $Id: mpe_fftC.h,v 1.2 1997/11/03 18:46:44 wrankin Exp $
 *
 * RSC History:
 *
 * $Log: mpe_fftC.h,v $
 * Revision 1.2  1997/11/03 18:46:44  wrankin
 * general cleanup/ansi-fication of code.  no new features.
 *
 *
 *
 */


#define SINPI_4   0.7071067811865475
#define SINPI_8   0.3826834323650898
#define COSPI_8   0.9238795325112868
#define SIN3PI_16 0.5555702330196022
#define COS3PI_16 0.8314696123025452
#define SINPI_16  0.1950903220161282
#define COSPI_16  0.9807852804032305
#define SQRT2     1.4142135623730950

#define MAXP 64

#define   FFTH32(in) \
{ \
int i; \
Real tempr, tempi; \
Real t0,t1,t2,t3,t4,t5,t6,t7,t8,t9,t10,t11,t12,t13,t14,t15; \
Real t16,t17,t18,t19,t20,t21,t22,t23,t24,t25,t26,t27,t28,t29,t30,t31; \
Real t32,t33,t34,t35,t36,t37,t38,t39,t40,t41,t42,t43,t44,t45,t46,t47; \
Real t48,t49,t50,t51,t52,t53,t54,t55,t56,t57,t58,t59,t60,t61,t62,t63; \
Real i0,i1,i2,i3,i4,i5,i6,i7,i8,i9,i10,i11,i12,i13,i14,i15; \
Real i16,i17,i18,i19,i20,i21,i22,i23,i24,i25,i26,i27,i28,i29,i30,i31; \
Real i32,i33,i34,i35,i36,i37,i38,i39,i40,i41,i42,i43,i44,i45,i46,i47; \
Real i48,i49,i50,i51,i52,i53,i54,i55,i56,i57,i58,i59,i60,i61,i62,i63; \
t0 = in[0]; \
t1 = in[1]; \
t2 = in[2]; \
t3 = in[3]; \
t4 = in[4]; \
t5 = in[5]; \
t6 = in[6]; \
t7 = in[7]; \
t8 = in[8]; \
t9 = in[9]; \
t10 = in[10]; \
t11 = in[11]; \
t12 = in[12]; \
t13 = in[13]; \
t14 = in[14]; \
t15 = in[15]; \
t16 = in[16]; \
t17 = in[17]; \
t18 = in[18]; \
t19 = in[19]; \
t20 = in[20]; \
t21 = in[21]; \
t22 = in[22]; \
t23 = in[23]; \
t24 = in[24]; \
t25 = in[25]; \
t26 = in[26]; \
t27 = in[27]; \
t28 = in[28]; \
t29 = in[29]; \
t30 = in[30]; \
t31 = in[31]; \
i0 = ((t0)+(t16+t16)); \
i1 = 0.0; \
i2 = ((t0)-(t17-(-t17))); \
i3 = 0.0; \
i4 = ((t0)-((t16+t16))); \
i5 = 0.0; \
i6 = ((t0)-(-(t17-(-t17)))); \
i7 = 0.0; \
i8 = ((t8+t24)+(t24+t8)); \
i9 = 0.0; \
i10 = ((t8-(t24))-(t25-(-t9))); \
i11 = ((t9-(-t25))+(t24-(t8))); \
i12 = 0.0; \
i13 = ((t9-t25)-((t25-t9))); \
i14 = ((t8-(t24))-(-(t25-(-t9)))); \
i15 = ((t9-(-t25))-((t24-(t8)))); \
i16 = ((t4+t28)+(t20+t12)); \
i17 = ((t5-t29)+(t21-t13)); \
i18 = ((t4-(t28))-(t21-(-t13))); \
i19 = ((t5-(-t29))+(t20-(t12))); \
i20 = ((t4+t28)-((t20+t12))); \
i21 = ((t5-t29)-((t21-t13))); \
i22 = ((t4-(t28))-(-(t21-(-t13)))); \
i23 = ((t5-(-t29))-((t20-(t12)))); \
i24 = ((t12+t20)+(t28+t4)); \
i25 = ((t13-t21)+(t29-t5)); \
i26 = ((t12-(t20))-(t29-(-t5))); \
i27 = ((t13-(-t21))+(t28-(t4))); \
i28 = ((t12+t20)-((t28+t4))); \
i29 = ((t13-t21)-((t29-t5))); \
i30 = ((t12-(t20))-(-(t29-(-t5)))); \
i31 = ((t13-(-t21))-((t28-(t4)))); \
i32 = ((t2-t30)+(t18-t14)); \
i33 = ((t3+t31)+(t19+t15)); \
i34 = ((t2-(-t30))-(t19-(t15))); \
i35 = ((t3-(t31))+(t18-(-t14))); \
i36 = ((t2-t30)-((t18-t14))); \
i37 = ((t3+t31)-((t19+t15))); \
i38 = ((t2-(-t30))-(-(t19-(t15)))); \
i39 = ((t3-(t31))-((t18-(-t14)))); \
i40 = ((t10-t22)+(t26-t6)); \
i41 = ((t11+t23)+(t27+t7)); \
i42 = ((t10-(-t22))-(t27-(t7))); \
i43 = ((t11-(t23))+(t26-(-t6))); \
i44 = ((t10-t22)-((t26-t6))); \
i45 = ((t11+t23)-((t27+t7))); \
i46 = ((t10-(-t22))-(-(t27-(t7)))); \
i47 = ((t11-(t23))-((t26-(-t6)))); \
i48 = ((t6-t26)+(t22-t10)); \
i49 = ((t7+t27)+(t23+t11)); \
i50 = ((t6-(-t26))-(t23-(t11))); \
i51 = ((t7-(t27))+(t22-(-t10))); \
i52 = ((t6-t26)-((t22-t10))); \
i53 = ((t7+t27)-((t23+t11))); \
i54 = ((t6-(-t26))-(-(t23-(t11)))); \
i55 = ((t7-(t27))-((t22-(-t10)))); \
i56 = ((t14-t18)+(t30-t2)); \
i57 = ((t15+t19)+(t31+t3)); \
i58 = ((t14-(-t18))-(t31-(t3))); \
i59 = ((t15-(t19))+(t30-(-t2))); \
i60 = ((t14-t18)-((t30-t2))); \
i61 = ((t15+t19)-((t31+t3))); \
i62 = ((t14-(-t18))-(-(t31-(t3)))); \
i63 = ((t15-(t19))-((t30-(-t2)))); \
t0 = i0; \
t1 = i1; \
t2 = i2; \
t3 = i3; \
t4 = i4; \
t5 = i5; \
t6 = i6; \
t7 = i7; \
t8 = i8; \
t9 = i9; \
t10 = i10; \
t11 = i11; \
t12 = i12; \
t13 = i13; \
t14 = i14; \
t15 = i15; \
t16 = i16; \
t17 = i17; \
t18 = i18; \
t19 = i19; \
t20 = i20; \
t21 = i21; \
t22 = i22; \
t23 = i23; \
t24 = i24; \
t25 = i25; \
t26 = i26; \
t27 = i27; \
t28 = i28; \
t29 = i29; \
t30 = i30; \
t31 = i31; \
t32 = i32; \
t33 = i33; \
t34 = i34; \
t35 = i35; \
t36 = i36; \
t37 = i37; \
t38 = i38; \
t39 = i39; \
t40 = i40; \
t41 = i41; \
t42 = i42; \
t43 = i43; \
t44 = i44; \
t45 = i45; \
t46 = i46; \
t47 = i47; \
t48 = i48; \
t49 = i49; \
t50 = i50; \
t51 = i51; \
t52 = i52; \
t53 = i53; \
t54 = i54; \
t55 = i55; \
t56 = i56; \
t57 = i57; \
t58 = i58; \
t59 = i59; \
t60 = i60; \
t61 = i61; \
t62 = i62; \
t63 = i63; \
tempr=t8; \
t8 = t0-tempr; \
t9 = 0.0; \
t0+=tempr; \
t1 = 0.0; \
tempr=t24; \
tempi=t25; \
t24 = 0.0; \
t25 = t17-tempi; \
t16+=tempr; \
t17 = 0.0; \
tempr=t40; \
tempi=t41; \
t40 = t32-tempr; \
t41 = t33-tempi; \
t32+=tempr; \
t33+=tempi; \
tempr=t56; \
tempi=t57; \
t56 = t48-tempr; \
t57 = t49-tempi; \
t48+=tempr; \
t49+=tempi; \
tempr=SINPI_4*t10-SINPI_4*t11; \
t10 = t2-tempr; \
t11 = 0.0; \
t2+=tempr; \
t3 = 0.0; \
tempr=SINPI_4*t26-SINPI_4*t27; \
tempi=SINPI_4*t27+SINPI_4*t26; \
t26 = t18-tempr; \
t27 = t19-tempi; \
t18+=tempr; \
t19+=tempi; \
tempr=SINPI_4*t42-SINPI_4*t43; \
tempi=SINPI_4*t43+SINPI_4*t42; \
t42 = t34-tempr; \
t43 = t35-tempi; \
t34+=tempr; \
t35+=tempi; \
tempr=SINPI_4*t58-SINPI_4*t59; \
tempi=SINPI_4*t59+SINPI_4*t58; \
t58 = t50-tempr; \
t59 = t51-tempi; \
t50+=tempr; \
t51+=tempi; \
tempr=-t13; \
t12 = t4-tempr; \
t13 = 0.0; \
t4+=tempr; \
t5 = 0.0; \
tempr=-t29; \
tempi=t28; \
t28 = t20-tempr; \
t29 = t21-tempi; \
t20+=tempr; \
t21+=tempi; \
tempr=-t45; \
tempi=t44; \
t44 = t36-tempr; \
t45 = t37-tempi; \
t36+=tempr; \
t37+=tempi; \
tempr=-t61; \
tempi=t60; \
t60 = t52-tempr; \
t61 = t53-tempi; \
t52+=tempr; \
t53+=tempi; \
tempr=-SINPI_4*t14-SINPI_4*t15; \
t14 = t6-tempr; \
t15 = 0.0; \
t6+=tempr; \
t7 = 0.0; \
tempr=-SINPI_4*t30-SINPI_4*t31; \
tempi=-SINPI_4*t31+SINPI_4*t30; \
t30 = t22-tempr; \
t31 = t23-tempi; \
t22+=tempr; \
t23+=tempi; \
tempr=-SINPI_4*t46-SINPI_4*t47; \
tempi=-SINPI_4*t47+SINPI_4*t46; \
t46 = t38-tempr; \
t47 = t39-tempi; \
t38+=tempr; \
t39+=tempi; \
tempr=-SINPI_4*t62-SINPI_4*t63; \
tempi=-SINPI_4*t63+SINPI_4*t62; \
t62 = t54-tempr; \
t63 = t55-tempi; \
t54+=tempr; \
t55+=tempi; \
tempr=t16; \
t16 = t0-tempr; \
t17 = 0.0; \
t0+=tempr; \
t1 = 0.0; \
tempr=t48; \
tempi=t49; \
t48 = t32-tempr; \
t49 = 0.0; \
t32 = 0.0; \
t33+=tempi; \
tempr=COSPI_8*t18-SINPI_8*t19; \
t18 = t2-tempr; \
t19 = 0.0; \
t2+=tempr; \
t3 = 0.0; \
tempr=COSPI_8*t50-SINPI_8*t51; \
tempi=COSPI_8*t51+SINPI_8*t50; \
t50 = t34-tempr; \
t51 = t35-tempi; \
t34+=tempr; \
t35+=tempi; \
tempr=SINPI_4*t20-SINPI_4*t21; \
t20 = t4-tempr; \
t21 = 0.0; \
t4+=tempr; \
t5 = 0.0; \
tempr=SINPI_4*t52-SINPI_4*t53; \
tempi=SINPI_4*t53+SINPI_4*t52; \
t52 = t36-tempr; \
t53 = t37-tempi; \
t36+=tempr; \
t37+=tempi; \
tempr=SINPI_8*t22-COSPI_8*t23; \
t22 = t6-tempr; \
t23 = 0.0; \
t6+=tempr; \
t7 = 0.0; \
tempr=SINPI_8*t54-COSPI_8*t55; \
tempi=SINPI_8*t55+COSPI_8*t54; \
t54 = t38-tempr; \
t55 = t39-tempi; \
t38+=tempr; \
t39+=tempi; \
tempr=-t25; \
t24 = t8-tempr; \
t25 = 0.0; \
t8+=tempr; \
t9 = 0.0; \
tempr=-t57; \
tempi=t56; \
t56 = t40-tempr; \
t57 = t41-tempi; \
t40+=tempr; \
t41+=tempi; \
tempr=-SINPI_8*t26-COSPI_8*t27; \
t26 = t10-tempr; \
t27 = 0.0; \
t10+=tempr; \
t11 = 0.0; \
tempr=-SINPI_8*t58-COSPI_8*t59; \
tempi=-SINPI_8*t59+COSPI_8*t58; \
t58 = t42-tempr; \
t59 = t43-tempi; \
t42+=tempr; \
t43+=tempi; \
tempr=-SINPI_4*t28-SINPI_4*t29; \
t28 = t12-tempr; \
t29 = 0.0; \
t12+=tempr; \
t13 = 0.0; \
tempr=-SINPI_4*t60-SINPI_4*t61; \
tempi=-SINPI_4*t61+SINPI_4*t60; \
t60 = t44-tempr; \
t61 = t45-tempi; \
t44+=tempr; \
t45+=tempi; \
tempr=-COSPI_8*t30-SINPI_8*t31; \
t30 = t14-tempr; \
t31 = 0.0; \
t14+=tempr; \
t15 = 0.0; \
tempr=-COSPI_8*t62-SINPI_8*t63; \
tempi=-COSPI_8*t63+SINPI_8*t62; \
t62 = t46-tempr; \
t63 = t47-tempi; \
t46+=tempr; \
t47+=tempi; \
tempi=t33; \
t32 = t0; \
t33 = t1-tempi; \
t1+=tempi; \
tempi=COSPI_16*t35+SINPI_16*t34; \
t34 = t2; \
t35 = t3-tempi; \
t3+=tempi; \
tempi=COSPI_8*t37+SINPI_8*t36; \
t36 = t4; \
t37 = t5-tempi; \
t5+=tempi; \
tempi=COS3PI_16*t39+SIN3PI_16*t38; \
t38 = t6; \
t39 = t7-tempi; \
t7+=tempi; \
tempi=SINPI_4*t41+SINPI_4*t40; \
t40 = t8; \
t41 = t9-tempi; \
t9+=tempi; \
tempi=SIN3PI_16*t43+COS3PI_16*t42; \
t42 = t10; \
t43 = t11-tempi; \
t11+=tempi; \
tempi=SINPI_8*t45+COSPI_8*t44; \
t44 = t12; \
t45 = t13-tempi; \
t13+=tempi; \
tempi=SINPI_16*t47+COSPI_16*t46; \
t46 = t14; \
t47 = t15-tempi; \
t15+=tempi; \
tempi=t48; \
t48 = t16; \
t49 = t17-tempi; \
t17+=tempi; \
tempi=-SINPI_16*t51+COSPI_16*t50; \
t50 = t18; \
t51 = t19-tempi; \
t19+=tempi; \
tempi=-SINPI_8*t53+COSPI_8*t52; \
t52 = t20; \
t53 = t21-tempi; \
t21+=tempi; \
tempi=-SIN3PI_16*t55+COS3PI_16*t54; \
t54 = t22; \
t55 = t23-tempi; \
t23+=tempi; \
tempi=-SINPI_4*t57+SINPI_4*t56; \
t56 = t24; \
t57 = t25-tempi; \
t25+=tempi; \
tempi=-COS3PI_16*t59+SIN3PI_16*t58; \
t58 = t26; \
t59 = t27-tempi; \
t27+=tempi; \
tempi=-COSPI_8*t61+SINPI_8*t60; \
t60 = t28; \
t61 = t29-tempi; \
t29+=tempi; \
tempi=-COSPI_16*t63+SINPI_16*t62; \
t62 = t30; \
t63 = t31-tempi; \
t31+=tempi; \
in[0]=t0; \
in[1]=t1; \
in[2]=t2; \
in[3]=t3; \
in[4]=t4; \
in[5]=t5; \
in[6]=t6; \
in[7]=t7; \
in[8]=t8; \
in[9]=t9; \
in[10]=t10; \
in[11]=t11; \
in[12]=t12; \
in[13]=t13; \
in[14]=t14; \
in[15]=t15; \
in[16]=t16; \
in[17]=t17; \
in[18]=t18; \
in[19]=t19; \
in[20]=t20; \
in[21]=t21; \
in[22]=t22; \
in[23]=t23; \
in[24]=t24; \
in[25]=t25; \
in[26]=t26; \
in[27]=t27; \
in[28]=t28; \
in[29]=t29; \
in[30]=t30; \
in[31]=t31; \
}




#define FFTH16(in) \
{ \
int i; \
Real tempr, tempi; \
Real t0,t1,t2,t3,t4,t5,t6,t7,t8,t9,t10,t11,t12,t13,t14,t15,t16,t17,t18,t19,t20,t21,t22,t23,t24,t25,t26,t27,t28,t29,t30,t31; \
Real i0,i1,i2,i3,i4,i5,i6,i7,i8,i9,i10,i11,i12,i13,i14,i15,i16,i17,i18,i19,i20,i21,i22,i23,i24,i25,i26,i27,i28,i29,i30,i31; \
t0 = in[0]; \
t1 = in[1]; \
t2 = in[2]; \
t3 = in[3]; \
t4 = in[4]; \
t5 = in[5]; \
t6 = in[6]; \
t7 = in[7]; \
t8 = in[8]; \
t9 = in[9]; \
t10 = in[10]; \
t11 = in[11]; \
t12 = in[12]; \
t13 = in[13]; \
t14 = in[14]; \
t15 = in[15]; \
i0 = ((t0)+(t8+t8)); \
i1 = 0.0; \
i2 = ((t0)-(t9-(-t9))); \
i3 = 0.0; \
i4 = ((t0)-((t8+t8))); \
i5 = 0.0; \
i6 = ((t0)-(-(t9-(-t9)))); \
i7 = 0.0; \
i8 = ((t4+t12)+(t12+t4)); \
i9 = 0.0; \
i10 = ((t4-(t12))-(t13-(-t5))); \
i11 = ((t5-(-t13))+(t12-(t4))); \
i12 = 0.0; \
i13 = ((t5-t13)-((t13-t5))); \
i14 = ((t4-(t12))-(-(t13-(-t5)))); \
i15 = ((t5-(-t13))-((t12-(t4)))); \
i16 = ((t2-t14)+(t10-t6)); \
i17 = ((t3+t15)+(t11+t7)); \
i18 = ((t2-(-t14))-(t11-(t7))); \
i19 = ((t3-(t15))+(t10-(-t6))); \
i20 = ((t2-t14)-((t10-t6))); \
i21 = ((t3+t15)-((t11+t7))); \
i22 = ((t2-(-t14))-(-(t11-(t7)))); \
i23 = ((t3-(t15))-((t10-(-t6)))); \
i24 = ((t6-t10)+(t14-t2)); \
i25 = ((t7+t11)+(t15+t3)); \
i26 = ((t6-(-t10))-(t15-(t3))); \
i27 = ((t7-(t11))+(t14-(-t2))); \
i28 = ((t6-t10)-((t14-t2))); \
i29 = ((t7+t11)-((t15+t3))); \
i30 = ((t6-(-t10))-(-(t15-(t3)))); \
i31 = ((t7-(t11))-((t14-(-t2)))); \
t0 = i0; \
t1 = i1; \
t2 = i2; \
t3 = i3; \
t4 = i4; \
t5 = i5; \
t6 = i6; \
t7 = i7; \
t8 = i8; \
t9 = i9; \
t10 = i10; \
t11 = i11; \
t12 = i12; \
t13 = i13; \
t14 = i14; \
t15 = i15; \
t16 = i16; \
t17 = i17; \
t18 = i18; \
t19 = i19; \
t20 = i20; \
t21 = i21; \
t22 = i22; \
t23 = i23; \
t24 = i24; \
t25 = i25; \
t26 = i26; \
t27 = i27; \
t28 = i28; \
t29 = i29; \
t30 = i30; \
t31 = i31; \
tempr=t8; \
t8 = t0-tempr; \
t9 = 0.0; \
t0+=tempr; \
t1 = 0.0; \
tempr=t24; \
tempi=t25; \
t24 = t16-tempr; \
t25 = 0.0; \
t16 = 0.0; \
t17+=tempi; \
tempr=SINPI_4*t10-SINPI_4*t11; \
t10 = t2-tempr; \
t11 = 0.0; \
t2+=tempr; \
t3 = 0.0; \
tempr=SINPI_4*t26-SINPI_4*t27; \
tempi=SINPI_4*t27+SINPI_4*t26; \
t26 = t18-tempr; \
t27 = t19-tempi; \
t18+=tempr; \
t19+=tempi; \
tempr=-t13; \
t12 = t4-tempr; \
t13 = 0.0; \
t4+=tempr; \
t5 = 0.0; \
tempr=-t29; \
tempi=t28; \
t28 = t20-tempr; \
t29 = t21-tempi; \
t20+=tempr; \
t21+=tempi; \
tempr=-SINPI_4*t14-SINPI_4*t15; \
t14 = t6-tempr; \
t15 = 0.0; \
t6+=tempr; \
t7 = 0.0; \
tempr=-SINPI_4*t30-SINPI_4*t31; \
tempi=-SINPI_4*t31+SINPI_4*t30; \
t30 = t22-tempr; \
t31 = t23-tempi; \
t22+=tempr; \
t23+=tempi; \
tempi=t17; \
t16 = t0; \
t17 = t1-tempi; \
t1+=tempi; \
tempi=COSPI_8*t19+SINPI_8*t18; \
t18 = t2; \
t19 = t3-tempi; \
t3+=tempi; \
tempi=SINPI_4*t21+SINPI_4*t20; \
t20 = t4; \
t21 = t5-tempi; \
t5+=tempi; \
tempi=SINPI_8*t23+COSPI_8*t22; \
t22 = t6; \
t23 = t7-tempi; \
t7+=tempi; \
tempi=t24; \
t24 = t8; \
t25 = t9-tempi; \
t9+=tempi; \
tempi=-SINPI_8*t27+COSPI_8*t26; \
t26 = t10; \
t27 = t11-tempi; \
t11+=tempi; \
tempi=-SINPI_4*t29+SINPI_4*t28; \
t28 = t12; \
t29 = t13-tempi; \
t13+=tempi; \
tempi=-COSPI_8*t31+SINPI_8*t30; \
t30 = t14; \
t31 = t15-tempi; \
t15+=tempi; \
in[0]=t0; \
in[1]=t1; \
in[2]=t2; \
in[3]=t3; \
in[4]=t4; \
in[5]=t5; \
in[6]=t6; \
in[7]=t7; \
in[8]=t8; \
in[9]=t9; \
in[10]=t10; \
in[11]=t11; \
in[12]=t12; \
in[13]=t13; \
in[14]=t14; \
in[15]=t15; \
}




#define FFTV8(in, rowlen) \
{ \
int i; \
unsigned long increment;  \
Real t0, t1,t2,t3,t4,t5,t6,t7;  \
Real *row0, *row1, *row2, *row3, *row4, *row5, *row6, *row7;  \
increment = rowlen;  \
increment = increment << 1;  \
row0 = in;  \
row1 = row0 + increment;  \
row2 = row1 + increment;  \
row3 = row2 + increment;  \
row4 = row3 + increment;  \
row5 = row4 + increment;  \
row6 = row5 + increment;  \
row7 = row6 + increment;  \
increment = rowlen;  \
for (i=0; i < increment; i++) { \
t0 = *row0;  \
t1 = *(row0+1);  \
t2 = *row1;  \
t3 = *(row1+1);  \
t4 = *row2;  \
t5 = *(row2+1);  \
t6 = *row3;  \
t7 = *(row3+1);  \
*row0++ = (((t0)+(t4))+((t2)+(t6)));  \
*row0++ = (((t1)+(t5))+((t3)+(t7)));  \
*row1++ = (((t0)-(t5))+SINPI_4*((t2)-(t7))-SINPI_4*((t3)+(t6)));  \
*row1++ = (((t1)+(t4))+SINPI_4*((t3)+(t6))+SINPI_4*((t2)-(t7)));  \
*row2++ = (((t0)-((t4)))-((t3)-((t7))));  \
*row2++ = (((t1)-((t5)))+((t2)-((t6))));  \
*row3++ = (((t0)-(-(t5)))-SINPI_4*((t2)-(-(t7)))-SINPI_4*((t3)-((t6))));  \
*row3++ = (((t1)-((t4)))-SINPI_4*((t3)-((t6)))+SINPI_4*((t2)-(-(t7))));  \
*row4++ = (((t0)+(t4))-(((t2)+(t6))));  \
*row4++ = (((t1)+(t5))-(((t3)+(t7))));  \
*row5++ = (((t0)-(t5))-(SINPI_4*((t2)-(t7))-SINPI_4*((t3)+(t6))));  \
*row5++ = (((t1)+(t4))-(SINPI_4*((t3)+(t6))+SINPI_4*((t2)-(t7))));  \
*row6++ = (((t0)-((t4)))-(-((t3)-((t7)))));  \
*row6++ = (((t1)-((t5)))-(((t2)-((t6)))));  \
*row7++ = (((t0)-(-(t5)))-(-SINPI_4*((t2)-(-(t7)))-SINPI_4*((t3)-((t6)))));  \
*row7++ = (((t1)-((t4)))-(-SINPI_4*((t3)-((t6)))+SINPI_4*((t2)-(-(t7)))));  \
} \
}




#define IFFTV8(in, rowlen)  \
{ \
int i;  \
Real *row0, *row1, *row2, *row3, *row4, *row5, *row6, *row7;  \
int  increment;  \
Real tempr, tempi;  \
Real t0,t1,t2,t3,t4,t5,t6,t7,t8,t9,t10,t11,t12,t13,t14,t15;  \
Real i0,i1,i2,i3,i4,i5,i6,i7,i8,i9,i10,i11,i12,i13,i14,i15;  \
increment = rowlen << 1;  \
row0 = in;  \
row1 = row0 + increment;  \
row2 = row1 + increment;  \
row3 = row2 + increment;  \
row4 = row3 + increment;  \
row5 = row4 + increment;  \
row6 = row5 + increment;  \
row7 = row6 + increment;  \
\
for (i=0; i<rowlen; i++) {   \
t0 = *row0;  \
t1 = *(row0+1);  \
t2 = *row1;  \
t3 = *(row1+1);  \
t4 = *row2;  \
t5 = *(row2+1);  \
t6 = *row3;  \
t7 = *(row3+1);  \
t8 = *row4;  \
t9 = *(row4+1);  \
t10 = *row5;  \
t11 = *(row5+1);  \
t12 = *row6;  \
t13 = *(row6+1);  \
t14 = *row7;  \
t15 = *(row7+1);  \
*row0++ = (((t0+t8)+(t4+t12))+((t2+t10)+(t6+t14)));  \
*row0++ = (((t1+t9)+(t5+t13))+((t3+t11)+(t7+t15)));  \
*row1++ = (((t0-(t8))+(t5-(t13)))+SINPI_4*((t2-(t10))+(t7-(t15)))+SINPI_4*((t3-(t11))-(t6-(t14))));  \
*row1++ = (((t1-(t9))-(t4-(t12)))+SINPI_4*((t3-(t11))-(t6-(t14)))-SINPI_4*((t2-(t10))+(t7-(t15))));  \
*row2++ = (((t0+t8)-((t4+t12)))+((t3+t11)-((t7+t15))));  \
*row2++ = (((t1+t9)-((t5+t13)))-((t2+t10)-((t6+t14))));  \
*row3++ = (((t0-(t8))-((t5-(t13))))-SINPI_4*((t2-(t10))-((t7-(t15))))+SINPI_4*((t3-(t11))-(-(t6-(t14)))));  \
*row3++ = (((t1-(t9))-(-(t4-(t12))))-SINPI_4*((t3-(t11))-(-(t6-(t14))))-SINPI_4*((t2-(t10))-((t7-(t15)))));  \
*row4++ = (((t0+t8)+(t4+t12))-(((t2+t10)+(t6+t14))));  \
*row4++ = (((t1+t9)+(t5+t13))-(((t3+t11)+(t7+t15))));  \
*row5++ = (((t0-(t8))+(t5-(t13)))-(SINPI_4*((t2-(t10))+(t7-(t15)))+SINPI_4*((t3-(t11))-(t6-(t14)))));  \
*row5++ = (((t1-(t9))-(t4-(t12)))-(SINPI_4*((t3-(t11))-(t6-(t14)))-SINPI_4*((t2-(t10))+(t7-(t15)))));  \
*row6++ = (((t0+t8)-((t4+t12)))-(((t3+t11)-((t7+t15)))));  \
*row6++ = (((t1+t9)-((t5+t13)))-(-((t2+t10)-((t6+t14)))));  \
*row7++ = (((t0-(t8))-((t5-(t13))))-(-SINPI_4*((t2-(t10))-((t7-(t15))))+SINPI_4*((t3-(t11))-(-(t6-(t14))))));  \
*row7++ = (((t1-(t9))-(-(t4-(t12))))-(-SINPI_4*((t3-(t11))-(-(t6-(t14))))-SINPI_4*((t2-(t10))-((t7-(t15))))));  \
}  \
}




#define IFFTH16(in) \
{ \
int i;  \
Real tempr, tempi;  \
Real t0,t1,t2,t3,t4,t5,t6,t7,t8,t9,t10,t11,t12,t13,t14,t15,t16,t17,t18,t19,t20,t21,t22,t23,t24,t25,t26,t27,t28,t29,t30,t31;  \
Real i0,i1,i2,i3,i4,i5,i6,i7,i8,i9,i10,i11,i12,i13,i14,i15,i16,i17,i18,i19,i20,i21,i22,i23,i24,i25,i26,i27,i28,i29,i30,i31;  \
t0 = in[0];  \
t1 = in[1];  \
t2 = in[2];  \
t3 = in[3];  \
t4 = in[4];  \
t5 = in[5];  \
t6 = in[6];  \
t7 = in[7];  \
t8 = in[8];  \
t9 = in[9];  \
t10 = in[10];  \
t11 = in[11];  \
t12 = in[12];  \
t13 = in[13];  \
t14 = in[14];  \
t15 = in[15];  \
i0 = ((t0+t0)+(t8+t8));  \
i1 = 0.0;  \
i2 = ((t9-(-t9)));  \
i3 = ((t1-(-t1)));  \
i4 = ((t0+t0)-((t8+t8)));  \
i5 = 0.0;  \
i6 = (-((t9-(-t9))));  \
i7 = ((t1-(-t1)));  \
i8 = ((t4+t4)+(t12+t12));  \
i9 = 0.0;  \
i10 = ((t13-(-t13)));  \
i11 = ((t5-(-t5)));  \
i12 = ((t4+t4)-((t12+t12)));  \
i13 = 0.0;  \
i14 = (-((t13-(-t13))));  \
i15 = ((t5-(-t5)));  \
i16 = ((t2+t2)+(t10+t10));  \
i17 = 0.0;  \
i18 = ((t11-(-t11)));  \
i19 = ((t3-(-t3)));  \
i20 = ((t2+t2)-((t10+t10)));  \
i21 = 0.0;  \
i22 = (-((t11-(-t11))));  \
i23 = ((t3-(-t3)));  \
i24 = ((t6+t6)+(t14+t14));  \
i25 = 0.0;  \
i26 = ((t15-(-t15)));  \
i27 = ((t7-(-t7)));  \
i28 = ((t6+t6)-((t14+t14)));  \
i29 = 0.0;  \
i30 = (-((t15-(-t15))));  \
i31 = ((t7-(-t7)));  \
t0 = i0;  \
t1 = i1;  \
t2 = i2;  \
t3 = i3;  \
t4 = i4;  \
t5 = i5;  \
t6 = i6;  \
t7 = i7;  \
t8 = i8;  \
t9 = i9;  \
t10 = i10;  \
t11 = i11;  \
t12 = i12;  \
t13 = i13;  \
t14 = i14;  \
t15 = i15;  \
t16 = i16;  \
t17 = i17;  \
t18 = i18;  \
t19 = i19;  \
t20 = i20;  \
t21 = i21;  \
t22 = i22;  \
t23 = i23;  \
t24 = i24;  \
t25 = i25;  \
t26 = i26;  \
t27 = i27;  \
t28 = i28;  \
t29 = i29;  \
t30 = i30;  \
t31 = i31;  \
tempr=t8;  \
t8 = t0-tempr;  \
t9 = 0.0;  \
t0+=tempr;  \
t1 = 0.0;  \
tempr=t24;  \
t24 = t16-tempr;  \
t25 = 0.0;  \
t16+=tempr;  \
t17 = 0.0;  \
tempr=SINPI_4*t10+SINPI_4*t11;  \
tempi=SINPI_4*t11-SINPI_4*t10;  \
t10 = t2-tempr;  \
t11 = t3-tempi;  \
t2+=tempr;  \
t3+=tempi;  \
tempr=SINPI_4*t26+SINPI_4*t27;  \
tempi=SINPI_4*t27-SINPI_4*t26;  \
t26 = t18-tempr;  \
t27 = t19-tempi;  \
t18+=tempr;  \
t19+=tempi;  \
tempi=-t12;  \
t12 = t4;  \
t13 = t5-tempi;  \
t5+=tempi;  \
tempi=-t28;  \
t28 = t20;  \
t29 = t21-tempi;  \
t21+=tempi;  \
tempr=-SINPI_4*t14+SINPI_4*t15;  \
tempi=-SINPI_4*t15-SINPI_4*t14;  \
t14 = t6-tempr;  \
t15 = t7-tempi;  \
t6+=tempr;  \
t7+=tempi;  \
tempr=-SINPI_4*t30+SINPI_4*t31;  \
tempi=-SINPI_4*t31-SINPI_4*t30;  \
t30 = t22-tempr;  \
t31 = t23-tempi;  \
t22+=tempr;  \
t23+=tempi;  \
tempr=t16;  \
t16 = t0-tempr;  \
t17 = 0.0;  \
t0+=tempr;  \
t1 = 0.0;  \
tempr=COSPI_8*t18+SINPI_8*t19;  \
tempi=COSPI_8*t19-SINPI_8*t18;  \
t18 = t2-tempr;  \
t19 = t3-tempi;  \
t2+=tempr;  \
t3+=tempi;  \
tempr=SINPI_4*t20+SINPI_4*t21;  \
tempi=SINPI_4*t21-SINPI_4*t20;  \
t20 = t4-tempr;  \
t21 = t5-tempi;  \
t4+=tempr;  \
t5+=tempi;  \
tempr=SINPI_8*t22+COSPI_8*t23;  \
tempi=SINPI_8*t23-COSPI_8*t22;  \
t22 = t6-tempr;  \
t23 = t7-tempi;  \
t6+=tempr;  \
t7+=tempi;  \
tempi=-t24;  \
t24 = t8;  \
t25 = t9-tempi;  \
t9+=tempi;  \
tempr=-SINPI_8*t26+COSPI_8*t27;  \
tempi=-SINPI_8*t27-COSPI_8*t26;  \
t26 = t10-tempr;  \
t27 = t11-tempi;  \
t10+=tempr;  \
t11+=tempi;  \
tempr=-SINPI_4*t28+SINPI_4*t29;  \
tempi=-SINPI_4*t29-SINPI_4*t28;  \
t28 = t12-tempr;  \
t29 = t13-tempi;  \
t12+=tempr;  \
t13+=tempi;  \
tempr=-COSPI_8*t30+SINPI_8*t31;  \
tempi=-COSPI_8*t31-SINPI_8*t30;  \
t30 = t14-tempr;  \
t31 = t15-tempi;  \
t14+=tempr;  \
t15+=tempi;  \
in[0]=t0;  \
in[1]=t1;  \
in[2]=t2;  \
in[3]=t3;  \
in[4]=t4;  \
in[5]=t5;  \
in[6]=t6;  \
in[7]=t7;  \
in[8]=t8;  \
in[9]=t9;  \
in[10]=t10;  \
in[11]=t11;  \
in[12]=t12;  \
in[13]=t13;  \
in[14]=t14;  \
in[15]=t15;  \
}


#define IFFTH32(in)  \
{   \
int i;  \
Real tempr, tempi;  \
Real t0,t1,t2,t3,t4,t5,t6,t7,t8,t9,t10,t11,t12,t13,t14,t15,t16,t17,t18,t19,t20,t21,t22,t23,t24,t25,t26,t27,t28,t29,t30,t31,t32,t33,t34,t35,t36,t37,t38,t39,t40,t41,t42,t43,t44,t45,t46,t47,t48,t49,t50,t51,t52,t53,t54,t55,t56,t57,t58,t59,t60,t61,t62,t63;  \
Real i0,i1,i2,i3,i4,i5,i6,i7,i8,i9,i10,i11,i12,i13,i14,i15,i16,i17,i18,i19,i20,i21,i22,i23,i24,i25,i26,i27,i28,i29,i30,i31,i32,i33,i34,i35,i36,i37,i38,i39,i40,i41,i42,i43,i44,i45,i46,i47,i48,i49,i50,i51,i52,i53,i54,i55,i56,i57,i58,i59,i60,i61,i62,i63;  \
t0 = in[0];  \
t1 = in[1];  \
t2 = in[2];  \
t3 = in[3];  \
t4 = in[4];  \
t5 = in[5];  \
t6 = in[6];  \
t7 = in[7];  \
t8 = in[8];  \
t9 = in[9];  \
t10 = in[10];  \
t11 = in[11];  \
t12 = in[12];  \
t13 = in[13];  \
t14 = in[14];  \
t15 = in[15];  \
t16 = in[16];  \
t17 = in[17];  \
t18 = in[18];  \
t19 = in[19];  \
t20 = in[20];  \
t21 = in[21];  \
t22 = in[22];  \
t23 = in[23];  \
t24 = in[24];  \
t25 = in[25];  \
t26 = in[26];  \
t27 = in[27];  \
t28 = in[28];  \
t29 = in[29];  \
t30 = in[30];  \
t31 = in[31];  \
i0 = ((t0+t0)+(t16+t16));  \
i1 = 0.0;  \
i2 = ((t17-(-t17)));  \
i3 = ((t1-(-t1)));  \
i4 = ((t0+t0)-((t16+t16)));  \
i5 = 0.0;  \
i6 = (-((t17-(-t17))));  \
i7 = ((t1-(-t1)));  \
i8 = ((t8+t8)+(t24+t24));  \
i9 = 0.0;  \
i10 = ((t25-(-t25)));  \
i11 = ((t9-(-t9)));  \
i12 = ((t8+t8)-((t24+t24)));  \
i13 = 0.0;  \
i14 = (-((t25-(-t25))));  \
i15 = ((t9-(-t9)));  \
i16 = ((t4+t4)+(t20+t20));  \
i17 = 0.0;  \
i18 = ((t21-(-t21)));  \
i19 = ((t5-(-t5)));  \
i20 = ((t4+t4)-((t20+t20)));  \
i21 = 0.0;  \
i22 = (-((t21-(-t21))));  \
i23 = ((t5-(-t5)));  \
i24 = ((t12+t12)+(t28+t28));  \
i25 = 0.0;  \
i26 = ((t29-(-t29)));  \
i27 = ((t13-(-t13)));  \
i28 = ((t12+t12)-((t28+t28)));  \
i29 = 0.0;  \
i30 = (-((t29-(-t29))));  \
i31 = ((t13-(-t13)));  \
i32 = ((t2+t2)+(t18+t18));  \
i33 = 0.0;  \
i34 = ((t19-(-t19)));  \
i35 = ((t3-(-t3)));  \
i36 = ((t2+t2)-((t18+t18)));  \
i37 = 0.0;  \
i38 = (-((t19-(-t19))));  \
i39 = ((t3-(-t3)));  \
i40 = ((t10+t10)+(t26+t26));  \
i41 = 0.0;  \
i42 = ((t27-(-t27)));  \
i43 = ((t11-(-t11)));  \
i44 = ((t10+t10)-((t26+t26)));  \
i45 = 0.0;  \
i46 = (-((t27-(-t27))));  \
i47 = ((t11-(-t11)));  \
i48 = ((t6+t6)+(t22+t22));  \
i49 = 0.0;  \
i50 = ((t23-(-t23)));  \
i51 = ((t7-(-t7)));  \
i52 = ((t6+t6)-((t22+t22)));  \
i53 = 0.0;  \
i54 = (-((t23-(-t23))));  \
i55 = ((t7-(-t7)));  \
i56 = ((t14+t14)+(t30+t30));  \
i57 = 0.0;  \
i58 = ((t31-(-t31)));  \
i59 = ((t15-(-t15)));  \
i60 = ((t14+t14)-((t30+t30)));  \
i61 = 0.0;  \
i62 = (-((t31-(-t31))));  \
i63 = ((t15-(-t15)));  \
t0 = i0;  \
t1 = i1;  \
t2 = i2;  \
t3 = i3;  \
t4 = i4;  \
t5 = i5;  \
t6 = i6;  \
t7 = i7;  \
t8 = i8;  \
t9 = i9;  \
t10 = i10;  \
t11 = i11;  \
t12 = i12;  \
t13 = i13;  \
t14 = i14;  \
t15 = i15;  \
t16 = i16;  \
t17 = i17;  \
t18 = i18;  \
t19 = i19;  \
t20 = i20;  \
t21 = i21;  \
t22 = i22;  \
t23 = i23;  \
t24 = i24;  \
t25 = i25;  \
t26 = i26;  \
t27 = i27;  \
t28 = i28;  \
t29 = i29;  \
t30 = i30;  \
t31 = i31;  \
t32 = i32;  \
t33 = i33;  \
t34 = i34;  \
t35 = i35;  \
t36 = i36;  \
t37 = i37;  \
t38 = i38;  \
t39 = i39;  \
t40 = i40;  \
t41 = i41;  \
t42 = i42;  \
t43 = i43;  \
t44 = i44;  \
t45 = i45;  \
t46 = i46;  \
t47 = i47;  \
t48 = i48;  \
t49 = i49;  \
t50 = i50;  \
t51 = i51;  \
t52 = i52;  \
t53 = i53;  \
t54 = i54;  \
t55 = i55;  \
t56 = i56;  \
t57 = i57;  \
t58 = i58;  \
t59 = i59;  \
t60 = i60;  \
t61 = i61;  \
t62 = i62;  \
t63 = i63;  \
tempr=t8;  \
t8 = t0-tempr;  \
t9 = 0.0;  \
t0+=tempr;  \
t1 = 0.0;  \
tempr=t24;  \
t24 = t16-tempr;  \
t25 = 0.0;  \
t16+=tempr;  \
t17 = 0.0;  \
tempr=t40;  \
t40 = t32-tempr;  \
t41 = 0.0;  \
t32+=tempr;  \
t33 = 0.0;  \
tempr=t56;  \
t56 = t48-tempr;  \
t57 = 0.0;  \
t48+=tempr;  \
t49 = 0.0;  \
tempr=SINPI_4*t10+SINPI_4*t11;  \
tempi=SINPI_4*t11-SINPI_4*t10;  \
t10 = t2-tempr;  \
t11 = t3-tempi;  \
t2+=tempr;  \
t3+=tempi;  \
tempr=SINPI_4*t26+SINPI_4*t27;  \
tempi=SINPI_4*t27-SINPI_4*t26;  \
t26 = t18-tempr;  \
t27 = t19-tempi;  \
t18+=tempr;  \
t19+=tempi;  \
tempr=SINPI_4*t42+SINPI_4*t43;  \
tempi=SINPI_4*t43-SINPI_4*t42;  \
t42 = t34-tempr;  \
t43 = t35-tempi;  \
t34+=tempr;  \
t35+=tempi;  \
tempr=SINPI_4*t58+SINPI_4*t59;  \
tempi=SINPI_4*t59-SINPI_4*t58;  \
t58 = t50-tempr;  \
t59 = t51-tempi;  \
t50+=tempr;  \
t51+=tempi;  \
tempi=-t12;  \
t12 = t4;  \
t13 = t5-tempi;  \
t5+=tempi;  \
tempi=-t28;  \
t28 = t20;  \
t29 = t21-tempi;  \
t21+=tempi;  \
tempi=-t44;  \
t44 = t36;  \
t45 = t37-tempi;  \
t37+=tempi;  \
tempi=-t60;  \
t60 = t52;  \
t61 = t53-tempi;  \
t53+=tempi;  \
tempr=-SINPI_4*t14+SINPI_4*t15;  \
tempi=-SINPI_4*t15-SINPI_4*t14;  \
t14 = t6-tempr;  \
t15 = t7-tempi;  \
t6+=tempr;  \
t7+=tempi;  \
tempr=-SINPI_4*t30+SINPI_4*t31;  \
tempi=-SINPI_4*t31-SINPI_4*t30;  \
t30 = t22-tempr;  \
t31 = t23-tempi;  \
t22+=tempr;  \
t23+=tempi;  \
tempr=-SINPI_4*t46+SINPI_4*t47;  \
tempi=-SINPI_4*t47-SINPI_4*t46;  \
t46 = t38-tempr;  \
t47 = t39-tempi;  \
t38+=tempr;  \
t39+=tempi;  \
tempr=-SINPI_4*t62+SINPI_4*t63;  \
tempi=-SINPI_4*t63-SINPI_4*t62;  \
t62 = t54-tempr;  \
t63 = t55-tempi;  \
t54+=tempr;  \
t55+=tempi;  \
tempr=t16;  \
t16 = t0-tempr;  \
t17 = 0.0;  \
t0+=tempr;  \
t1 = 0.0;  \
tempr=t48;  \
t48 = t32-tempr;  \
t49 = 0.0;  \
t32+=tempr;  \
t33 = 0.0;  \
tempr=COSPI_8*t18+SINPI_8*t19;  \
tempi=COSPI_8*t19-SINPI_8*t18;  \
t18 = t2-tempr;  \
t19 = t3-tempi;  \
t2+=tempr;  \
t3+=tempi;  \
tempr=COSPI_8*t50+SINPI_8*t51;  \
tempi=COSPI_8*t51-SINPI_8*t50;  \
t50 = t34-tempr;  \
t51 = t35-tempi;  \
t34+=tempr;  \
t35+=tempi;  \
tempr=SINPI_4*t20+SINPI_4*t21;  \
tempi=SINPI_4*t21-SINPI_4*t20;  \
t20 = t4-tempr;  \
t21 = t5-tempi;  \
t4+=tempr;  \
t5+=tempi;  \
tempr=SINPI_4*t52+SINPI_4*t53;  \
tempi=SINPI_4*t53-SINPI_4*t52;  \
t52 = t36-tempr;  \
t53 = t37-tempi;  \
t36+=tempr;  \
t37+=tempi;  \
tempr=SINPI_8*t22+COSPI_8*t23;  \
tempi=SINPI_8*t23-COSPI_8*t22;  \
t22 = t6-tempr;  \
t23 = t7-tempi;  \
t6+=tempr;  \
t7+=tempi;  \
tempr=SINPI_8*t54+COSPI_8*t55;  \
tempi=SINPI_8*t55-COSPI_8*t54;  \
t54 = t38-tempr;  \
t55 = t39-tempi;  \
t38+=tempr;  \
t39+=tempi;  \
tempi=-t24;  \
t24 = t8;  \
t25 = t9-tempi;  \
t9+=tempi;  \
tempi=-t56;  \
t56 = t40;  \
t57 = t41-tempi;  \
t41+=tempi;  \
tempr=-SINPI_8*t26+COSPI_8*t27;  \
tempi=-SINPI_8*t27-COSPI_8*t26;  \
t26 = t10-tempr;  \
t27 = t11-tempi;  \
t10+=tempr;  \
t11+=tempi;  \
tempr=-SINPI_8*t58+COSPI_8*t59;  \
tempi=-SINPI_8*t59-COSPI_8*t58;  \
t58 = t42-tempr;  \
t59 = t43-tempi;  \
t42+=tempr;  \
t43+=tempi;  \
tempr=-SINPI_4*t28+SINPI_4*t29;  \
tempi=-SINPI_4*t29-SINPI_4*t28;  \
t28 = t12-tempr;  \
t29 = t13-tempi;  \
t12+=tempr;  \
t13+=tempi;  \
tempr=-SINPI_4*t60+SINPI_4*t61;  \
tempi=-SINPI_4*t61-SINPI_4*t60;  \
t60 = t44-tempr;  \
t61 = t45-tempi;  \
t44+=tempr;  \
t45+=tempi;  \
tempr=-COSPI_8*t30+SINPI_8*t31;  \
tempi=-COSPI_8*t31-SINPI_8*t30;  \
t30 = t14-tempr;  \
t31 = t15-tempi;  \
t14+=tempr;  \
t15+=tempi;  \
tempr=-COSPI_8*t62+SINPI_8*t63;  \
tempi=-COSPI_8*t63-SINPI_8*t62;  \
t62 = t46-tempr;  \
t63 = t47-tempi;  \
t46+=tempr;  \
t47+=tempi;  \
tempr=t32;  \
t32 = t0-tempr;  \
t33 = 0.0;  \
t0+=tempr;  \
t1 = 0.0;  \
tempr=COSPI_16*t34+SINPI_16*t35;  \
tempi=COSPI_16*t35-SINPI_16*t34;  \
t34 = t2-tempr;  \
t35 = t3-tempi;  \
t2+=tempr;  \
t3+=tempi;  \
tempr=COSPI_8*t36+SINPI_8*t37;  \
tempi=COSPI_8*t37-SINPI_8*t36;  \
t36 = t4-tempr;  \
t37 = t5-tempi;  \
t4+=tempr;  \
t5+=tempi;  \
tempr=COS3PI_16*t38+SIN3PI_16*t39;  \
tempi=COS3PI_16*t39-SIN3PI_16*t38;  \
t38 = t6-tempr;  \
t39 = t7-tempi;  \
t6+=tempr;  \
t7+=tempi;  \
tempr=SINPI_4*t40+SINPI_4*t41;  \
tempi=SINPI_4*t41-SINPI_4*t40;  \
t40 = t8-tempr;  \
t41 = t9-tempi;  \
t8+=tempr;  \
t9+=tempi;  \
tempr=SIN3PI_16*t42+COS3PI_16*t43;  \
tempi=SIN3PI_16*t43-COS3PI_16*t42;  \
t42 = t10-tempr;  \
t43 = t11-tempi;  \
t10+=tempr;  \
t11+=tempi;  \
tempr=SINPI_8*t44+COSPI_8*t45;  \
tempi=SINPI_8*t45-COSPI_8*t44;  \
t44 = t12-tempr;  \
t45 = t13-tempi;  \
t12+=tempr;  \
t13+=tempi;  \
tempr=SINPI_16*t46+COSPI_16*t47;  \
tempi=SINPI_16*t47-COSPI_16*t46;  \
t46 = t14-tempr;  \
t47 = t15-tempi;  \
t14+=tempr;  \
t15+=tempi;  \
tempi=-t48;  \
t48 = t16;  \
t49 = t17-tempi;  \
t17+=tempi;  \
tempr=-SINPI_16*t50+COSPI_16*t51;  \
tempi=-SINPI_16*t51-COSPI_16*t50;  \
t50 = t18-tempr;  \
t51 = t19-tempi;  \
t18+=tempr;  \
t19+=tempi;  \
tempr=-SINPI_8*t52+COSPI_8*t53;  \
tempi=-SINPI_8*t53-COSPI_8*t52;  \
t52 = t20-tempr;  \
t53 = t21-tempi;  \
t20+=tempr;  \
t21+=tempi;  \
tempr=-SIN3PI_16*t54+COS3PI_16*t55;  \
tempi=-SIN3PI_16*t55-COS3PI_16*t54;  \
t54 = t22-tempr;  \
t55 = t23-tempi;  \
t22+=tempr;  \
t23+=tempi;  \
tempr=-SINPI_4*t56+SINPI_4*t57;  \
tempi=-SINPI_4*t57-SINPI_4*t56;  \
t56 = t24-tempr;  \
t57 = t25-tempi;  \
t24+=tempr;  \
t25+=tempi;  \
tempr=-COS3PI_16*t58+SIN3PI_16*t59;  \
tempi=-COS3PI_16*t59-SIN3PI_16*t58;  \
t58 = t26-tempr;  \
t59 = t27-tempi;  \
t26+=tempr;  \
t27+=tempi;  \
tempr=-COSPI_8*t60+SINPI_8*t61;  \
tempi=-COSPI_8*t61-SINPI_8*t60;  \
t60 = t28-tempr;  \
t61 = t29-tempi;  \
t28+=tempr;  \
t29+=tempi;  \
tempr=-COSPI_16*t62+SINPI_16*t63;  \
tempi=-COSPI_16*t63-SINPI_16*t62;  \
t62 = t30-tempr;  \
t63 = t31-tempi;  \
t30+=tempr;  \
t31+=tempi;  \
in[0]=t0;  \
in[1]=t1;  \
in[2]=t2;  \
in[3]=t3;  \
in[4]=t4;  \
in[5]=t5;  \
in[6]=t6;  \
in[7]=t7;  \
in[8]=t8;  \
in[9]=t9;  \
in[10]=t10;  \
in[11]=t11;  \
in[12]=t12;  \
in[13]=t13;  \
in[14]=t14;  \
in[15]=t15;  \
in[16]=t16;  \
in[17]=t17;  \
in[18]=t18;  \
in[19]=t19;  \
in[20]=t20;  \
in[21]=t21;  \
in[22]=t22;  \
in[23]=t23;  \
in[24]=t24;  \
in[25]=t25;  \
in[26]=t26;  \
in[27]=t27;  \
in[28]=t28;  \
in[29]=t29;  \
in[30]=t30;  \
in[31]=t31;  \
}



#define FFTH8(in)   \
{  \
Real t0,t1,t2,t3,t4,t5,t6,t7;  \
t0 = in[0];  \
t1 = in[1];  \
t2 = in[2];  \
t3 = in[3];  \
t4 = in[4];  \
t5 = in[5];  \
t6 = in[6];  \
t7 = in[7];  \
in[0]=t0+t4+t4;  \
in[1]=t3+t3+t7+t7;  \
in[2]=t0-(t5+t5);  \
in[3]=SQRT2*(t3-t7+t6+t2);  \
in[4]=t0-(t4+t4);  \
in[5]=t2+t2-(t6+t6);  \
in[6]=t0+t5+t5;  \
in[7]=SQRT2*(t7-t3+t2+t6);  \
}  \


#define IFFTH8(in) \
{ \
Real t0,t1,t2,t3,t4,t5,t6,t7;  \
t0 = in[0];  \
t1 = in[1];  \
t2 = in[2];  \
t3 = in[3];  \
t4 = in[4];  \
t5 = in[5];  \
t6 = in[6];  \
t7 = in[7];  \
in[0] = 2.0*(t0+t4+t2+t6);  \
in[1] = 0.0;  \
in[2] = (t5+t5)+SQRT2*(t7+t3);  \
in[3] = (t1+t1)+SQRT2*(t3-t7);  \
in[4] = 2.0*(t0-t4);  \
in[5] = 2.0*(t6-t2);  \
in[6] = -(t5+t5)+SQRT2*(t7+t3);  \
in[7] = (t1+t1)-SQRT2*(t3-t7);  \
} \


