from MMTK import *
from MMTK.Proteins import Protein
from MMTK.ForceFields import Amber99ForceField
from MMTK_PINormalModeIntegrator import PINormalModeIntegrator, PILangevinNormalModeIntegrator
from MMTK.Dynamics import Heater, TranslationRemover, RotationRemover
from MMTK.Trajectory import Trajectory, TrajectoryOutput, \
                            RestartTrajectoryOutput, StandardLogOutput
from MMTK.Environment import PathIntegrals
from Scientific import N
import time

universe = InfiniteUniverse(Amber99ForceField(mod_files=['frcmod.ff99SB']))
universe.protein = Protein('bala1')
for atom in universe.atomIterator():
    #if atom.symbol == 'H':
    #    atom.setNumberOfBeads(16)
    atom.setNumberOfBeads(4)
temperature = 100.*Units.K
universe.addObject(PathIntegrals(temperature, False))

universe.initializeVelocitiesToTemperature(0.2*temperature)

if True:
    integrator = PILangevinNormalModeIntegrator(universe, delta_t=1.*Units.fs,
                                                centroid_friction = 2.*N.pi*100./Units.ps)
    filename = "bala1_pi_l.nc"
else:
    integrator = PINormalModeIntegrator(universe, delta_t=0.1*Units.fs)
    filename = "bala1_pi.nc"

trajectory = Trajectory(universe, filename, "w", "A simple test case")

integrator(steps=1000,
           actions = [TrajectoryOutput(trajectory, ("time", "energy", "thermodynamic",
                                                    "configuration"),
                                       0, None, 1)])
print N.sum(trajectory.temperature[500:])/500
print trajectory.temperature[-1], universe.temperature()
trajectory.close()

#print universe.configuration().array
