SQL Support in Blaze
====================

The SQL support in blaze is provided through a set of implemented blaze
kernels. These kernels are SQL implementations of general blaze functions.
These stages the expressions go through are the same as usual, but we shall
take closer attention to the SQL aspects of it:

    * The user uses blaze functions, which builds up an expression graph
    * The user calls blaze.eval
        - this produces AIR
        - SQL queries are generated
        - SQL queries are executed

Below we will focus on these individual steps.

SQL Expression Generation
-------------------------
Queries are generated by the SQL interpreter. First, the general implementation
partioner assigns backends to operations (which are blaze function
applications). This happens in `blaze/compute/air/frontend/partitioning.py`:

    https://github.com/ContinuumIO/blaze/blob/master/blaze/compute/air/frontend/partitioning.py

See especially the `partition` function.

The SQL query generator then determines all operations that
should be handled in the SQL domain. This happens in `blaze/io/sql/air.py`:

    https://github.com/ContinuumIO/blaze/blob/master/blaze/io/sql/air.py

See especially the `rewrite_sql` function. This simply applies each SQL kernel,
passing in the arguments, generated by other operations.

The SQL kernel's job is then to compose larger queries from smaller queries.
Since SQL syntax expects a certain syntax which does not correspond cleanly
with the way blaze expressions are nested, kernels generate a little SQL
term tree, defined in `blaze/io/sql/syntax.py`:

    https://github.com/ContinuumIO/blaze/blob/master/blaze/io/sql/syntax.py

This syntax module supports a fairly simple and straightforward syntax:

```python
    Table   = qtuple('Table',   ['tablename'])
    Column  = qtuple('Column',  ['table', 'colname'])
    Select  = qtuple('Select',  ['exprs', 'from_expr', 'where',
                                 'groupby', 'order'])
    Where   = qtuple('Where',   ['expr'])
    GroupBy = qtuple('GroupBy', ['cols'])
    From    = qtuple('From',    ['exprs'])
    OrderBy = qtuple('OrderBy', ['exprs', 'ascending'])
    Call    = qtuple('Call',    ['name', 'args'])
    Expr    = qtuple('Expr',    ['args'])
```

This syntax is generated by SQL *expressions*, generated from kernels.
This looks somewhat like this:

```python
    QWhere      = namedtuple('QWhere',   ['arr', 'expr'])
    QGroupBy    = namedtuple('QGroupBy', ['arr', 'keys'])
    QOrderBy    = namedtuple('QOrderBy', ['arr', 'exprs', 'ascending'])
```

Selecting SQL Kernels
---------------------
After generating all the SQL expressions, `rewrite_sql` removes intermediate
SQL kernel nodes from the AIR that are no longer needed, and replaces the
"root" nodes with SQL implementations. These are the nodes that are consumed
by some other kernel that has no corresponding SQL counterpart, because the
parent node has other children which describe non-sql data sources, or simply
because it is the root of the expression.

The root is then replaced by `sql_pykernel` in `air.py`:

    https://github.com/ContinuumIO/blaze/blob/master/blaze/io/sql/air.py

Generating SQL Syntax
---------------------
The `sql_pykernel` function closes over the previously generated SQL
expression. It generates an SQL syntax query string from this using the
syntax module (`reorder_select` and `emit`). Remember that its job is to
return a new blaze array.

It first executes the query using pyodbc (or currently, sqlite). Then it
wraps the resulting cursor in an SQLDataDescriptor, along with its datashape.
The exact sizes of the columns may however be unknown in the resulting type.

SQL Data Descriptors
--------------------
The SQL data descriptors can be found here:

    https://github.com/ContinuumIO/blaze/blob/master/blaze/io/sql/datadescriptor.py

The `SQLDataDescriptor` describes a remote SQL column or table, ready for
retrieval or querying from the database. The `SQLResultDataDescriptor` is
a datadescriptor to describe the result of an executed SQL query, that lazily
pulls in the data when (and if) requested.

Other Features
--------------
There are still many pieces missing:

    * Load type information from existing SQL table or column
        - connect to catalog
    * Support groupby, orderby, etc