import numpy as np

from bokeh.io import output_file, show
from bokeh.models import HoverTool
from bokeh.plotting import figure

n = 500
x = 2 + 2*np.random.standard_normal(n)
y = 2 + 2*np.random.standard_normal(n)

p = figure(title="Hexbin for 500 points", match_aspect=True,
           tools="wheel_zoom,reset", background_fill_color='#440154')
p.grid.visible = False

r, bins = p.hexbin(x, y, size=0.5, hover_color="pink", hover_alpha=0.8)

p.circle(x, y, color="white", size=1)

hover = HoverTool(tooltips=[("count", "@c"), ("(q,r)", "(@q, @r)")],
                  mode="mouse", point_policy="follow_mouse", renderers=[r])

p.add_tools(hover)

output_file("hexbin.html")

show(p)
