/*!
 * Copyright (c) 2012 - 2020, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
*/
(function(root, factory) {
  const bokeh = factory();
  bokeh.__bokeh__ = true;
  if (typeof root.Bokeh === "undefined" || typeof root.Bokeh.__bokeh__ === "undefined") {
    root.Bokeh = bokeh;
  }
  const Bokeh = root.Bokeh;
  Bokeh[bokeh.version] = bokeh;
})(this, function() {
  var define;
  var parent_require = typeof require === "function" && require
  return (function(modules, entry, aliases, externals) {
    if (aliases === undefined) aliases = {};
    if (externals === undefined) externals = {};

    var cache = {};

    var normalize = function(name) {
      if (typeof name === "number")
        return name;

      if (name === "bokehjs")
        return entry;

      var prefix = "@bokehjs/"
      if (name.slice(0, prefix.length) === prefix)
        name = name.slice(prefix.length)

      var alias = aliases[name]
      if (alias != null)
        return alias;

      var trailing = name.length > 0 && name[name.lenght-1] === "/";
      var index = aliases[name + (trailing ? "" : "/") + "index"];
      if (index != null)
        return index;

      return name;
    }

    var require = function(name) {
      var mod = cache[name];
      if (!mod) {
        var id = normalize(name);

        mod = cache[id];
        if (!mod) {
          if (!modules[id]) {
            if (externals[id] === false || (externals[id] == true && parent_require)) {
              try {
                mod = {exports: externals[id] ? parent_require(id) : {}};
                cache[id] = cache[name] = mod;
                return mod.exports;
              } catch (e) {}
            }

            var err = new Error("Cannot find module '" + name + "'");
            err.code = 'MODULE_NOT_FOUND';
            throw err;
          }

          mod = {exports: {}};
          cache[id] = cache[name] = mod;
          modules[id].call(mod.exports, require, mod, mod.exports);
        } else
          cache[name] = mod;
      }

      return mod.exports;
    }
    require.resolve = function(name) {
      return ""
    }

    var main = require(entry);
    main.require = require;

    if (typeof Proxy !== "undefined") {
      // allow Bokeh.loader["@bokehjs/module/name"] syntax
      main.loader = new Proxy({}, {
        get: function(_obj, module) {
          return require(module);
        }
      });
    }

    main.register_plugin = function(plugin_modules, plugin_entry, plugin_aliases, plugin_externals) {
      if (plugin_aliases === undefined) plugin_aliases = {};
      if (plugin_externals === undefined) plugin_externals = {};

      for (var name in plugin_modules) {
        modules[name] = plugin_modules[name];
      }

      for (var name in plugin_aliases) {
        aliases[name] = plugin_aliases[name];
      }

      for (var name in plugin_externals) {
        externals[name] = plugin_externals[name];
      }

      var plugin = require(plugin_entry);

      for (var name in plugin) {
        main[name] = plugin[name];
      }

      return plugin;
    }

    return main;
  })
([
function _(e,t,_){Object.defineProperty(_,"__esModule",{value:!0});e(1).__exportStar(e(2),_)},
function _(t,e,n){
/*! *****************************************************************************
    Copyright (c) Microsoft Corporation.
    
    Permission to use, copy, modify, and/or distribute this software for any
    purpose with or without fee is hereby granted.
    
    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
    REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
    AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
    INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
    LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
    OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
    PERFORMANCE OF THIS SOFTWARE.
    ***************************************************************************** */
Object.defineProperty(n,"__esModule",{value:!0});var r=function(t,e){return(r=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n])})(t,e)};function o(t){var e="function"==typeof Symbol&&Symbol.iterator,n=e&&t[e],r=0;if(n)return n.call(t);if(t&&"number"==typeof t.length)return{next:function(){return t&&r>=t.length&&(t=void 0),{value:t&&t[r++],done:!t}}};throw new TypeError(e?"Object is not iterable.":"Symbol.iterator is not defined.")}function a(t,e){var n="function"==typeof Symbol&&t[Symbol.iterator];if(!n)return t;var r,o,a=n.call(t),i=[];try{for(;(void 0===e||e-- >0)&&!(r=a.next()).done;)i.push(r.value)}catch(t){o={error:t}}finally{try{r&&!r.done&&(n=a.return)&&n.call(a)}finally{if(o)throw o.error}}return i}function i(t){return this instanceof i?(this.v=t,this):new i(t)}n.__extends=function(t,e){function n(){this.constructor=t}r(t,e),t.prototype=null===e?Object.create(e):(n.prototype=e.prototype,new n)},n.__assign=function(){return n.__assign=Object.assign||function(t){for(var e,n=1,r=arguments.length;n<r;n++)for(var o in e=arguments[n])Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o]);return t},n.__assign.apply(this,arguments)},n.__rest=function(t,e){var n={};for(var r in t)Object.prototype.hasOwnProperty.call(t,r)&&e.indexOf(r)<0&&(n[r]=t[r]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var o=0;for(r=Object.getOwnPropertySymbols(t);o<r.length;o++)e.indexOf(r[o])<0&&Object.prototype.propertyIsEnumerable.call(t,r[o])&&(n[r[o]]=t[r[o]])}return n},n.__decorate=function(t,e,n,r){var o,a=arguments.length,i=a<3?e:null===r?r=Object.getOwnPropertyDescriptor(e,n):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)i=Reflect.decorate(t,e,n,r);else for(var u=t.length-1;u>=0;u--)(o=t[u])&&(i=(a<3?o(i):a>3?o(e,n,i):o(e,n))||i);return a>3&&i&&Object.defineProperty(e,n,i),i},n.__param=function(t,e){return function(n,r){e(n,r,t)}},n.__metadata=function(t,e){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(t,e)},n.__awaiter=function(t,e,n,r){return new(n||(n=Promise))((function(o,a){function i(t){try{c(r.next(t))}catch(t){a(t)}}function u(t){try{c(r.throw(t))}catch(t){a(t)}}function c(t){var e;t.done?o(t.value):(e=t.value,e instanceof n?e:new n((function(t){t(e)}))).then(i,u)}c((r=r.apply(t,e||[])).next())}))},n.__generator=function(t,e){var n,r,o,a,i={label:0,sent:function(){if(1&o[0])throw o[1];return o[1]},trys:[],ops:[]};return a={next:u(0),throw:u(1),return:u(2)},"function"==typeof Symbol&&(a[Symbol.iterator]=function(){return this}),a;function u(a){return function(u){return function(a){if(n)throw new TypeError("Generator is already executing.");for(;i;)try{if(n=1,r&&(o=2&a[0]?r.return:a[0]?r.throw||((o=r.return)&&o.call(r),0):r.next)&&!(o=o.call(r,a[1])).done)return o;switch(r=0,o&&(a=[2&a[0],o.value]),a[0]){case 0:case 1:o=a;break;case 4:return i.label++,{value:a[1],done:!1};case 5:i.label++,r=a[1],a=[0];continue;case 7:a=i.ops.pop(),i.trys.pop();continue;default:if(!(o=i.trys,(o=o.length>0&&o[o.length-1])||6!==a[0]&&2!==a[0])){i=0;continue}if(3===a[0]&&(!o||a[1]>o[0]&&a[1]<o[3])){i.label=a[1];break}if(6===a[0]&&i.label<o[1]){i.label=o[1],o=a;break}if(o&&i.label<o[2]){i.label=o[2],i.ops.push(a);break}o[2]&&i.ops.pop(),i.trys.pop();continue}a=e.call(t,i)}catch(t){a=[6,t],r=0}finally{n=o=0}if(5&a[0])throw a[1];return{value:a[0]?a[1]:void 0,done:!0}}([a,u])}}},n.__createBinding=function(t,e,n,r){void 0===r&&(r=n),t[r]=e[n]},n.__exportStar=function(t,e){for(var n in t)"default"===n||e.hasOwnProperty(n)||(e[n]=t[n])},n.__values=o,n.__read=a,n.__spread=function(){for(var t=[],e=0;e<arguments.length;e++)t=t.concat(a(arguments[e]));return t},n.__spreadArrays=function(){for(var t=0,e=0,n=arguments.length;e<n;e++)t+=arguments[e].length;var r=Array(t),o=0;for(e=0;e<n;e++)for(var a=arguments[e],i=0,u=a.length;i<u;i++,o++)r[o]=a[i];return r},n.__await=i,n.__asyncGenerator=function(t,e,n){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var r,o=n.apply(t,e||[]),a=[];return r={},u("next"),u("throw"),u("return"),r[Symbol.asyncIterator]=function(){return this},r;function u(t){o[t]&&(r[t]=function(e){return new Promise((function(n,r){a.push([t,e,n,r])>1||c(t,e)}))})}function c(t,e){try{(n=o[t](e)).value instanceof i?Promise.resolve(n.value.v).then(f,l):s(a[0][2],n)}catch(t){s(a[0][3],t)}var n}function f(t){c("next",t)}function l(t){c("throw",t)}function s(t,e){t(e),a.shift(),a.length&&c(a[0][0],a[0][1])}},n.__asyncDelegator=function(t){var e,n;return e={},r("next"),r("throw",(function(t){throw t})),r("return"),e[Symbol.iterator]=function(){return this},e;function r(r,o){e[r]=t[r]?function(e){return(n=!n)?{value:i(t[r](e)),done:"return"===r}:o?o(e):e}:o}},n.__asyncValues=function(t){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var e,n=t[Symbol.asyncIterator];return n?n.call(t):(t=o(t),e={},r("next"),r("throw"),r("return"),e[Symbol.asyncIterator]=function(){return this},e);function r(n){e[n]=t[n]&&function(e){return new Promise((function(r,o){(function(t,e,n,r){Promise.resolve(r).then((function(e){t({value:e,done:n})}),e)})(r,o,(e=t[n](e)).done,e.value)}))}}},n.__makeTemplateObject=function(t,e){return Object.defineProperty?Object.defineProperty(t,"raw",{value:e}):t.raw=e,t},n.__importStar=function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var n in t)Object.hasOwnProperty.call(t,n)&&(e[n]=t[n]);return e.default=t,e},n.__importDefault=function(t){return t&&t.__esModule?t:{default:t}},n.__classPrivateFieldGet=function(t,e){if(!e.has(t))throw new TypeError("attempted to get private field on non-instance");return e.get(t)},n.__classPrivateFieldSet=function(t,e,n){if(!e.has(t))throw new TypeError("attempted to set private field on non-instance");return e.set(t,n),n}},
function _(e,r,t){var l=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var r={};if(null!=e)for(var t in e)Object.hasOwnProperty.call(e,t)&&(r[t]=e[t]);return r.default=e,r};Object.defineProperty(t,"__esModule",{value:!0});var o=e(3);t.version=o.version;var s=e(4);t.index=s.index,t.embed=l(e(4)),t.protocol=l(e(390)),t._testing=l(e(391));var n=e(19);t.logger=n.logger,t.set_log_level=n.set_log_level;var a=e(27);t.settings=a.settings;var i=e(7);t.Models=i.Models;var v=e(5);t.documents=v.documents;var _=e(392);t.safely=_.safely},
function _(e,n,o){Object.defineProperty(o,"__esModule",{value:!0}),o.version="2.2.2"},
function _(e,o,t){Object.defineProperty(t,"__esModule",{value:!0});const n=e(5),s=e(19),r=e(29),d=e(13),_=e(8),c=e(16),i=e(381),a=e(383),u=e(382);var l=e(381);t.add_document_standalone=l.add_document_standalone,t.index=l.index;var m=e(383);t.add_document_from_session=m.add_document_from_session;var f=e(388);t.embed_items_notebook=f.embed_items_notebook,t.kernels=f.kernels;var g=e(382);async function O(e,o,t,c){_.isString(e)&&(e=JSON.parse(r.unescape(e)));const l={};for(const[o,t]of d.entries(e))l[o]=n.Document.from_json(t);const m=[];for(const e of o){const o=u._resolve_element(e),n=u._resolve_root_elements(e);if(null!=e.docid)m.push(await i.add_document_standalone(l[e.docid],o,n,e.use_for_title));else{if(null==e.token)throw new Error("Error rendering Bokeh items: either 'docid' or 'token' was expected.");{const r=a._get_ws_url(t,c);s.logger.debug("embed: computed ws url: "+r);try{m.push(await a.add_document_from_session(r,e.token,o,n,e.use_for_title)),console.log("Bokeh items were rendered successfully")}catch(e){console.log("Error rendering Bokeh items:",e)}}}}return m}t.BOKEH_ROOT=g.BOKEH_ROOT,t.embed_item=async function(e,o){const t={},n=r.uuid4();t[n]=e.doc,null==o&&(o=e.target_id);const s=document.getElementById(o);null!=s&&s.classList.add(u.BOKEH_ROOT);const d={roots:{[e.root_id]:o},root_ids:[e.root_id],docid:n},[_]=await c.defer(()=>O(t,[d]));return _},t.embed_items=async function(e,o,t,n){return await c.defer(()=>O(e,o,t,n))}},
function _(e,t,_){Object.defineProperty(_,"__esModule",{value:!0});const o=e(1);o.__exportStar(e(6),_),o.__exportStar(e(121),_)},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const o=e(1),n=e(7),r=e(3),i=e(19),_=e(313),a=e(14),l=e(15),c=e(17),h=e(31),d=e(9),f=e(13),u=o.__importStar(e(120)),m=e(25),g=e(8),p=e(272),w=e(85),v=e(81),b=e(121);class y{constructor(e){this.document=e,this.session=null,this.subscribed_models=new Set}send_event(e){const t=new b.MessageSentEvent(this.document,"bokeh_event",e.to_json());this.document._trigger_on_change(t)}trigger(e){for(const t of this.subscribed_models)null!=e.origin&&e.origin!=t||t._process_event(e)}}s.EventManager=y,y.__name__="EventManager",s.documents=[],s.DEFAULT_TITLE="Bokeh Application";class j{constructor(){s.documents.push(this),this._init_timestamp=Date.now(),this._title=s.DEFAULT_TITLE,this._roots=[],this._all_models=new Map,this._all_models_freeze_count=0,this._callbacks=new Map,this._message_callbacks=new Map,this.event_manager=new y(this),this.idle=new l.Signal0(this,"idle"),this._idle_roots=new WeakMap,this._interactive_timestamp=null,this._interactive_plot=null}get layoutables(){return this._roots.filter(e=>e instanceof p.LayoutDOM)}get is_idle(){for(const e of this.layoutables)if(!this._idle_roots.has(e))return!1;return!0}notify_idle(e){this._idle_roots.set(e,!0),this.is_idle&&(i.logger.info(`document idle at ${Date.now()-this._init_timestamp} ms`),this.event_manager.send_event(new _.DocumentReady),this.idle.emit())}clear(){this._push_all_models_freeze();try{for(;this._roots.length>0;)this.remove_root(this._roots[0])}finally{this._pop_all_models_freeze()}}interactive_start(e){null==this._interactive_plot&&(this._interactive_plot=e,this._interactive_plot.trigger_event(new _.LODStart)),this._interactive_timestamp=Date.now()}interactive_stop(){null!=this._interactive_plot&&this._interactive_plot.trigger_event(new _.LODEnd),this._interactive_plot=null,this._interactive_timestamp=null}interactive_duration(){return null==this._interactive_timestamp?-1:Date.now()-this._interactive_timestamp}destructively_move(e){if(e===this)throw new Error("Attempted to overwrite a document with itself");e.clear();const t=d.copy(this._roots);this.clear();for(const e of t)if(null!=e.document)throw new Error("Somehow we didn't detach "+e);if(0!=this._all_models.size)throw new Error("this._all_models still had stuff in it: "+this._all_models);for(const s of t)e.add_root(s);e.set_title(this._title)}_push_all_models_freeze(){this._all_models_freeze_count+=1}_pop_all_models_freeze(){this._all_models_freeze_count-=1,0===this._all_models_freeze_count&&this._recompute_all_models()}_invalidate_all_models(){i.logger.debug("invalidating document models"),0===this._all_models_freeze_count&&this._recompute_all_models()}_recompute_all_models(){let e=new Set;for(const t of this._roots)e=u.union(e,t.references());const t=new Set(this._all_models.values()),s=u.difference(t,e),o=u.difference(e,t),n=new Map;for(const t of e)n.set(t.id,t);for(const e of s)e.detach_document();for(const e of o)e.attach_document(this);this._all_models=n}roots(){return this._roots}add_root(e,t){if(i.logger.debug("Adding root: "+e),!d.includes(this._roots,e)){this._push_all_models_freeze();try{this._roots.push(e)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new b.RootAddedEvent(this,e,t))}}remove_root(e,t){const s=this._roots.indexOf(e);if(!(s<0)){this._push_all_models_freeze();try{this._roots.splice(s,1)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new b.RootRemovedEvent(this,e,t))}}title(){return this._title}set_title(e,t){e!==this._title&&(this._title=e,this._trigger_on_change(new b.TitleChangedEvent(this,e,t)))}get_model_by_id(e){var t;return null!==(t=this._all_models.get(e))&&void 0!==t?t:null}get_model_by_name(e){const t=[];for(const s of this._all_models.values())s instanceof v.Model&&s.name==e&&t.push(s);switch(t.length){case 0:return null;case 1:return t[0];default:throw new Error(`Multiple models are named '${e}'`)}}on_message(e,t){const s=this._message_callbacks.get(e);null==s?this._message_callbacks.set(e,new Set([t])):s.add(t)}remove_on_message(e,t){var s;null===(s=this._message_callbacks.get(e))||void 0===s||s.delete(t)}_trigger_on_message(e,t){const s=this._message_callbacks.get(e);if(null!=s)for(const e of s)e(t)}on_change(e,t=!1){this._callbacks.has(e)||this._callbacks.set(e,t)}remove_on_change(e){this._callbacks.delete(e)}_trigger_on_change(e){for(const[t,s]of this._callbacks)if(!s&&e instanceof b.DocumentEventBatch)for(const s of e.events)t(s);else t(e)}_notify_change(e,t,s,o,n){this._trigger_on_change(new b.ModelChangedEvent(this,e,t,s,o,null==n?void 0:n.setter_id,null==n?void 0:n.hint))}static _references_json(e,t=!0){const s=[];for(const o of e){const e=o.struct();e.attributes=o.attributes_as_json(t),delete e.attributes.id,s.push(e)}return s}static _instantiate_object(e,t,s){const o=Object.assign(Object.assign({},s),{id:e,__deferred__:!0});return new(n.Models(t))(o)}static _instantiate_references_json(e,t){const s=new Map;for(const o of e){const e=o.id,n=o.type,r=o.attributes||{};let i=t.get(e);null==i&&(i=j._instantiate_object(e,n,r),null!=o.subtype&&i.set_subtype(o.subtype)),s.set(i.id,i)}return s}static _resolve_refs(e,t,s,o){function n(e){if(c.is_ref(e)){if(t.has(e.id))return t.get(e.id);if(s.has(e.id))return s.get(e.id);throw new Error(`reference ${JSON.stringify(e)} isn't known (not in Document?)`)}return h.is_NDArray_ref(e)?h.decode_NDArray(e,o):g.isArray(e)?function(e){const t=[];for(const s of e)t.push(n(s));return t}(e):g.isPlainObject(e)?function(e){const t={};for(const[s,o]of f.entries(e))t[s]=n(o);return t}(e):e}return n(e)}static _initialize_references_json(e,t,s,o){const n=new Map;for(const{id:r,attributes:i}of e){const e=!t.has(r),_=e?s.get(r):t.get(r),a=j._resolve_refs(i,t,s,o);_.setv(a,{silent:!0}),n.set(r,{instance:_,is_new:e})}const r=[],i=new Set;function _(e){if(e instanceof a.HasProps){if(n.has(e.id)&&!i.has(e.id)){i.add(e.id);const{instance:t,is_new:s}=n.get(e.id),{attributes:o}=t;for(const e of f.values(o))_(e);s&&(t.finalize(),r.push(t))}}else if(g.isArray(e))for(const t of e)_(t);else if(g.isPlainObject(e))for(const t of f.values(e))_(t)}for(const e of n.values())_(e.instance);for(const e of r)e.connect_signals()}static _event_for_attribute_change(e,t,s,o,n){if(o.get_model_by_id(e.id).property(t).syncable){const r={kind:"ModelChanged",model:{id:e.id},attr:t,new:s};return a.HasProps._json_record_references(o,s,n,{recursive:!0}),r}return null}static _events_to_sync_objects(e,t,s,o){const n=Object.keys(e.attributes),r=Object.keys(t.attributes),_=d.difference(n,r),a=d.difference(r,n),l=d.intersection(n,r),c=[];for(const e of _)i.logger.warn(`Server sent key ${e} but we don't seem to have it in our JSON`);for(const n of a){const r=t.attributes[n];c.push(j._event_for_attribute_change(e,n,r,s,o))}for(const n of l){const r=e.attributes[n],i=t.attributes[n];null==r&&null==i||(null==r||null==i?c.push(j._event_for_attribute_change(e,n,i,s,o)):m.isEqual(r,i)||c.push(j._event_for_attribute_change(e,n,i,s,o)))}return c.filter(e=>null!=e)}static _compute_patch_since_json(e,t){const s=t.to_json(!1);function o(e){const t=new Map;for(const s of e.roots.references)t.set(s.id,s);return t}const n=o(e),r=new Map,i=[];for(const t of e.roots.root_ids)r.set(t,n.get(t)),i.push(t);const _=o(s),a=new Map,l=[];for(const e of s.roots.root_ids)a.set(e,_.get(e)),l.push(e);if(i.sort(),l.sort(),d.difference(i,l).length>0||d.difference(l,i).length>0)throw new Error("Not implemented: computing add/remove of document roots");const c=new Set;let h=[];for(const e of t._all_models.keys())if(n.has(e)){const s=j._events_to_sync_objects(n.get(e),_.get(e),t,c);h=h.concat(s)}return{references:j._references_json(c,!1),events:h}}to_json_string(e=!0){return JSON.stringify(this.to_json(e))}to_json(e=!0){const t=this._roots.map(e=>e.id),s=this._all_models.values();return{version:r.version,title:this._title,roots:{root_ids:t,references:j._references_json(s,e)}}}static from_json_string(e){const t=JSON.parse(e);return j.from_json(t)}static from_json(e){i.logger.debug("Creating Document from JSON");const t=e.version,s=-1!==t.indexOf("+")||-1!==t.indexOf("-"),o=`Library versions: JS (${r.version}) / Python (${t})`;s||r.version.replace(/-(dev|rc)\./,"$1")==t?i.logger.debug(o):(i.logger.warn("JS/Python version mismatch"),i.logger.warn(o));const n=e.roots,_=n.root_ids,a=n.references,l=j._instantiate_references_json(a,new Map);j._initialize_references_json(a,new Map,l,new Map);const c=new j;for(const e of _){const t=l.get(e);null!=t&&c.add_root(t)}return c.set_title(e.title),c}replace_with_json(e){j.from_json(e).destructively_move(this)}create_json_patch_string(e){return JSON.stringify(this.create_json_patch(e))}create_json_patch(e){const t=new Set,s=[];for(const o of e){if(o.document!==this)throw i.logger.warn("Cannot create a patch using events from a different document, event had ",o.document," we are ",this),new Error("Cannot create a patch using events from a different document");s.push(o.json(t))}return{events:s,references:j._references_json(t)}}apply_json_patch(e,t=new Map,s){const o=e.references,n=e.events,r=j._instantiate_references_json(o,this._all_models);t instanceof Map||(t=new Map(t));for(const e of n)switch(e.kind){case"RootAdded":case"RootRemoved":case"ModelChanged":{const t=e.model.id,s=this._all_models.get(t);if(null!=s)r.set(t,s);else if(!r.has(t))throw i.logger.warn(`Got an event for unknown model ${e.model}"`),new Error("event model wasn't known");break}}const _=new Map,a=new Map;for(const[e,t]of r)this._all_models.has(e)?_.set(e,t):a.set(e,t);j._initialize_references_json(o,_,a,t);for(const e of n)switch(e.kind){case"MessageSent":{const{msg_type:s,msg_data:o}=e;let n;if(void 0===o){if(1!=t.size)throw new Error("expected exactly one buffer");{const[[,e]]=t;n=e}}else n=j._resolve_refs(o,_,a,t);this._trigger_on_message(s,n);break}case"ModelChanged":{const o=e.model.id,n=this._all_models.get(o);if(null==n)throw new Error(`Cannot apply patch to ${o} which is not in the document`);const r=e.attr,i=j._resolve_refs(e.new,_,a,t);n.setv({[r]:i},{setter_id:s});break}case"ColumnDataChanged":{const o=e.column_source.id,n=this._all_models.get(o);if(null==n)throw new Error(`Cannot stream to ${o} which is not in the document`);const r=j._resolve_refs(e.new,new Map,new Map,t);if(null!=e.cols)for(const e in n.data)e in r||(r[e]=n.data[e]);n.setv({data:r},{setter_id:s,check_eq:!1});break}case"ColumnsStreamed":{const t=e.column_source.id,o=this._all_models.get(t);if(null==o)throw new Error(`Cannot stream to ${t} which is not in the document`);if(!(o instanceof w.ColumnDataSource))throw new Error("Cannot stream to non-ColumnDataSource");const n=e.data,r=e.rollover;o.stream(n,r,s);break}case"ColumnsPatched":{const t=e.column_source.id,o=this._all_models.get(t);if(null==o)throw new Error(`Cannot patch ${t} which is not in the document`);if(!(o instanceof w.ColumnDataSource))throw new Error("Cannot patch non-ColumnDataSource");const n=e.patches;o.patch(n,s);break}case"RootAdded":{const t=e.model.id,o=r.get(t);this.add_root(o,s);break}case"RootRemoved":{const t=e.model.id,o=r.get(t);this.remove_root(o,s);break}case"TitleChanged":this.set_title(e.title,s);break;default:throw new Error("Unknown patch event "+JSON.stringify(e))}}}s.Document=j,j.__name__="Document"},
function _(e,r,s){Object.defineProperty(s,"__esModule",{value:!0});const o=e(1),t=e(8),d=e(13),i=e(14);s.overrides={};const l=new Map;s.Models=e=>{const r=s.overrides[e]||l.get(e);if(null==r)throw new Error(`Model '${e}' does not exist. This could be due to a widget or a custom model not being registered before first usage.`);return r},s.Models.register=(e,r)=>{s.overrides[e]=r},s.Models.unregister=e=>{delete s.overrides[e]},s.Models.register_models=(e,r=!1,s)=>{var o;if(null!=e)for(const n of d.values(e))if(o=n,t.isObject(o)&&o.prototype instanceof i.HasProps){const e=n.__qualified__;r||!l.has(e)?l.set(e,n):null!=s?s(e):console.warn(`Model '${e}' was already registered`)}},s.register_models=s.Models.register_models,s.Models.registered_names=()=>Array.from(l.keys());const n=o.__importStar(e(34));s.register_models(n)},
function _(n,t,r){Object.defineProperty(r,"__esModule",{value:!0});
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
const e=n(9),i=Object.prototype.toString;function o(n){return"[object Number]"===i.call(n)}function c(n){const t=typeof n;return"function"===t||"object"===t&&!!n}r.isBoolean=function(n){return!0===n||!1===n||"[object Boolean]"===i.call(n)},r.isNumber=o,r.isInteger=function(n){return o(n)&&Number.isInteger(n)},r.isString=function(n){return"[object String]"===i.call(n)},r.isFunction=function(n){return"[object Function]"===i.call(n)},r.isArray=function(n){return Array.isArray(n)},r.isArrayOf=function(n,t){return e.every(n,t)},r.isArrayableOf=function(n,t){for(let r=0,e=n.length;r<e;r++)if(!t(n[r]))return!1;return!0},r.isTypedArray=function(n){return ArrayBuffer.isView(n)&&!(n instanceof DataView)},r.isObject=c,r.isPlainObject=function(n){return c(n)&&(null==n.constructor||n.constructor===Object)},r.isIterable=function(n){return Symbol.iterator in Object(n)}},
function _(n,t,e){Object.defineProperty(e,"__esModule",{value:!0});
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
const r=n(10),o=n(11),i=n(12);e.map=i.map,e.reduce=i.reduce,e.min=i.min,e.min_by=i.min_by,e.max=i.max,e.max_by=i.max_by,e.sum=i.sum,e.cumsum=i.cumsum,e.every=i.every,e.some=i.some,e.find=i.find,e.find_last=i.find_last,e.find_index=i.find_index,e.find_last_index=i.find_last_index,e.sorted_index=i.sorted_index,e.is_empty=i.is_empty;const u=Array.prototype.slice;function c(n){return u.call(n)}function f(n){return[].concat(...n)}function s(n,t){return-1!==n.indexOf(t)}function a(n,t,e=1){o.assert(e>0,"'step' must be a positive number"),null==t&&(t=n,n=0);const{max:r,ceil:i,abs:u}=Math,c=n<=t?e:-e,f=r(i(u(t-n)/e),0),s=new Array(f);for(let t=0;t<f;t++,n+=c)s[t]=n;return s}e.head=function(n){return n[0]},e.tail=function(n){return n[n.length-1]},e.last=function(n){return n[n.length-1]},e.copy=c,e.concat=f,e.includes=s,e.contains=s,e.nth=function(n,t){return n[t>=0?t:n.length+t]},e.zip=function(...n){if(0==n.length)return[];const t=i.min(n.map(n=>n.length)),e=n.length,r=new Array(t);for(let o=0;o<t;o++){r[o]=new Array(e);for(let t=0;t<e;t++)r[o][t]=n[t][o]}return r},e.unzip=function(n){const t=n.length,e=i.min(n.map(n=>n.length)),r=Array(e);for(let n=0;n<e;n++)r[n]=new Array(t);for(let o=0;o<t;o++)for(let t=0;t<e;t++)r[t][o]=n[o][t];return r},e.range=a,e.linspace=function(n,t,e=100){const r=(t-n)/(e-1),o=new Array(e);for(let t=0;t<e;t++)o[t]=n+r*t;return o},e.transpose=function(n){const t=n.length,e=n[0].length,r=[];for(let o=0;o<e;o++){r[o]=[];for(let e=0;e<t;e++)r[o][e]=n[e][o]}return r},e.argmin=function(n){return i.min_by(a(n.length),t=>n[t])},e.argmax=function(n){return i.max_by(a(n.length),t=>n[t])},e.sort_by=function(n,t){const e=n.map((n,e)=>({value:n,index:e,key:t(n)}));return e.sort((n,t)=>{const e=n.key,r=t.key;if(e!==r){if(e>r||void 0===e)return 1;if(e<r||void 0===r)return-1}return n.index-t.index}),e.map(n=>n.value)},e.uniq=function(n){const t=new Set;for(const e of n)t.add(e);return[...t]},e.uniq_by=function(n,t){const e=[],r=[];for(const o of n){const n=t(o);s(r,n)||(r.push(n),e.push(o))}return e},e.union=function(...n){const t=new Set;for(const e of n)for(const n of e)t.add(n);return[...t]},e.intersection=function(n,...t){const e=[];n:for(const r of n)if(!s(e,r)){for(const n of t)if(!s(n,r))continue n;e.push(r)}return e},e.difference=function(n,...t){const e=f(t);return n.filter(n=>!s(e,n))},e.remove_at=function(n,t){const e=c(n);return e.splice(t,1),e},e.remove_by=function(n,t){for(let e=0;e<n.length;)t(n[e])?n.splice(e,1):e++},e.shuffle=function(n){const t=n.length,e=new Array(t);for(let o=0;o<t;o++){const t=r.randomIn(0,o);t!==o&&(e[o]=e[t]),e[t]=n[o]}return e},e.pairwise=function(n,t){const e=n.length,r=new Array(e-1);for(let o=0;o<e-1;o++)r[o]=t(n[o],n[o+1]);return r},e.reversed=function(n){const t=n.length,e=new Array(t);for(let r=0;r<t;r++)e[t-r-1]=n[r];return e},e.repeat=function(n,t){const e=new Array(t);for(let r=0;r<t;r++)e[r]=n;return e}},
function _(n,t,r){function e(n){if(0==n)return 0;for(;n<=0;)n+=2*Math.PI;for(;n>2*Math.PI;)n-=2*Math.PI;return n}function a(n,t){return e(n-t)}function o(){return Math.random()}Object.defineProperty(r,"__esModule",{value:!0}),r.angle_norm=e,r.angle_dist=a,r.angle_between=function(n,t,r,o){const u=a(t,r);if(0==u)return!1;if(u==2*Math.PI)return!0;const f=e(n),i=a(t,f)<=u&&a(f,r)<=u;return 0==o?i:!i},r.random=o,r.randomIn=function(n,t){return null==t&&(t=n,n=0),n+Math.floor(Math.random()*(t-n+1))},r.atan2=function(n,t){return Math.atan2(t[1]-n[1],t[0]-n[0])},r.radians=function(n){return n*(Math.PI/180)},r.degrees=function(n){return n/(Math.PI/180)},r.rnorm=function(n,t){let r,e;for(;r=o(),e=o(),e=(2*e-1)*Math.sqrt(1/Math.E*2),!(-4*r*r*Math.log(r)>=e*e););let a=e/r;return a=n+t*a,a},r.clamp=function(n,t,r){return n<t?t:n>r?r:n}},
function _(e,r,n){Object.defineProperty(n,"__esModule",{value:!0});class o extends Error{}n.AssertionError=o,o.__name__="AssertionError",n.assert=function(e,r){if(!(!0===e||!1!==e&&e()))throw new o(null!=r?r:"Assertion failed")},n.unreachable=function(){throw new Error("unreachable code")}},
function _(n,t,e){Object.defineProperty(e,"__esModule",{value:!0});const r=n(8),o=n(10);function i(n,t,e,...r){const o=n.length;t<0&&(t+=o),t<0?t=0:t>o&&(t=o),null==e||e>o-t?e=o-t:e<0&&(e=0);const i=o-e+r.length,u=new n.constructor(i);let l=0;for(;l<t;l++)u[l]=n[l];for(const n of r)u[l++]=n;for(let r=t+e;r<o;r++)u[l++]=n[r];return u}function u(n,t){return i(n,t,n.length-t)}function l(n,t){const e=n.length,r=new n.constructor(e);for(let o=0;o<e;o++)r[o]=t(n[o],o,n);return r}function c(n,t,e){const r=n.length;if(void 0===e&&0==r)throw new Error("can't reduce an empty array without an initial value");let o,i;for(void 0===e?(o=n[0],i=1):(o=e,i=0);i<r;i++)o=t(o,n[i],i,n);return o}function f(n){return function(t,e){const r=t.length;let o=n>0?0:r-1;for(;o>=0&&o<r;o+=n)if(e(t[o]))return o;return-1}}function s(n,t){let e=0,r=n.length;for(;e<r;){const o=Math.floor((e+r)/2);n[o]<t?e=o+1:r=o}return e}function h(n,t,e,r,o){const i=(o-e)/(r-t);let u=i*(n-t)+e;return isFinite(u)||(u=i*(n-r)+o,isFinite(u)||e!=o||(u=e)),u}function a(n,t){if(n<t[0])return-1;if(n>t[t.length-1])return t.length;let e=0,r=t.length-1;for(;r-e!=1;){const o=e+Math.floor((r-e)/2);n>=t[o]?e=o:r=o}return e}e.is_empty=function(n){return 0==n.length},e.copy=function(n){return r.isArray(n)?n.slice():new n.constructor(n)},e.splice=i,e.head=u,e.insert=function(n,t,e){return i(n,e,0,t)},e.append=function(n,t){return i(n,n.length,0,t)},e.prepend=function(n,t){return i(n,0,0,t)},e.indexOf=function(n,t){for(let e=0,r=n.length;e<r;e++)if(n[e]===t)return e;return-1},e.subselect=function(n,t){const e=t.length,r=new n.constructor(e);for(let o=0;o<e;o++)r[o]=n[t[o]];return r},e.map=l,e.filter=function(n,t){const e=n.length,r=new n.constructor(e);let o=0;for(let i=0;i<e;i++){const e=n[i];t(e,i,n)&&(r[o++]=e)}return u(r,o)},e.reduce=c,e.min=function(n){let t,e=1/0;for(let r=0,o=n.length;r<o;r++)t=n[r],!isNaN(t)&&t<e&&(e=t);return e},e.max=function(n){let t,e=-1/0;for(let r=0,o=n.length;r<o;r++)t=n[r],!isNaN(t)&&t>e&&(e=t);return e},e.minmax=function(n){let t,e=1/0,r=-1/0;for(let o=0,i=n.length;o<i;o++)t=n[o],isNaN(t)||(t<e&&(e=t),t>r&&(r=t));return[e,r]},e.min_by=function(n,t){if(0==n.length)throw new Error("min_by() called with an empty array");let e=n[0],r=t(e);for(let o=1,i=n.length;o<i;o++){const i=n[o],u=t(i);u<r&&(e=i,r=u)}return e},e.max_by=function(n,t){if(0==n.length)throw new Error("max_by() called with an empty array");let e=n[0],r=t(e);for(let o=1,i=n.length;o<i;o++){const i=n[o],u=t(i);u>r&&(e=i,r=u)}return e},e.sum=function(n){let t=0;for(let e=0,r=n.length;e<r;e++)t+=n[e];return t},e.cumsum=function(n){const t=new n.constructor(n.length);return c(n,(n,e,r)=>t[r]=n+e,0),t},e.every=function(n,t){for(let e=0,r=n.length;e<r;e++)if(!t(n[e]))return!1;return!0},e.some=function(n,t){for(let e=0,r=n.length;e<r;e++)if(t(n[e]))return!0;return!1},e.index_of=function(n,t){for(let e=0,r=n.length;e<r;e++)if(n[e]===t)return e;return-1},e.find_index=f(1),e.find_last_index=f(-1),e.find=function(n,t){const r=e.find_index(n,t);return-1==r?void 0:n[r]},e.find_last=function(n,t){const r=e.find_last_index(n,t);return-1==r?void 0:n[r]},e.sorted_index=s,e.bin_counts=function(n,t){const e=t.length-1,r=Array(e).fill(0);for(let i=0;i<n.length;i++){const u=s(t,n[i]);r[o.clamp(u-1,0,e-1)]+=1}return r},e.interpolate=function(n,t,e){const r=n.length,o=new Array(r);for(let i=0;i<r;i++){const r=n[i];if(isNaN(r)){o[i]=r;continue}const u=a(r,t);if(-1==u)o[i]=e[0];else if(u==t.length)o[i]=e[e.length-1];else if(u==t.length-1||t[u]==r)o[i]=e[u];else{const n=t[u],l=e[u],c=t[u+1],f=e[u+1];o[i]=h(r,n,l,c,f)}}return o},e.left_edge_index=a,e.norm=function(n,t,e){const r=e-t;return l(n,n=>(n-t)/r)}},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const c=e(9);function o(e){return Object.keys(e).length}n.keys=Object.keys,n.values=Object.values,n.entries=Object.entries,n.extend=Object.assign,n.clone=function(e){return Object.assign({},e)},n.merge=function(e,t){const n=Object.create(Object.prototype),o=c.concat([Object.keys(e),Object.keys(t)]);for(const s of o){const o=e.hasOwnProperty(s)?e[s]:[],r=t.hasOwnProperty(s)?t[s]:[];n[s]=c.union(o,r)}return n},n.size=o,n.isEmpty=function(e){return 0==o(e)},n.to_object=function(e){const t={};for(const[n,c]of e)t[n]=c;return t}},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});const s=t(1),n=t(15),i=t(17),o=s.__importStar(t(18)),c=s.__importStar(t(21)),a=s.__importStar(t(28)),_=t(29),u=t(9),f=t(13),l=t(8),h=t(25),p=t(5),d=t(30),y=t(31),g=t(25),v=t(33),m=s.__importStar(t(21));class b extends(n.Signalable()){constructor(t={}){var e;super(),this._subtype=void 0,this.document=null,this.destroyed=new n.Signal0(this,"destroyed"),this.change=new n.Signal0(this,"change"),this.transformchange=new n.Signal0(this,"transformchange"),this.properties={},this._pending=!1,this._changing=!1;const r=t instanceof Map?t.get:e=>t[e];for(const[t,{type:e,default_value:s,options:n}]of f.entries(this._props)){let i;i=e instanceof c.Kind?new o.PrimitiveProperty(this,t,e,s,r(t),n):new e(this,t,c.Any,s,r(t),n),this.properties[t]=i}null!==(e=r("__deferred__"))&&void 0!==e&&e||(this.finalize(),this.connect_signals())}set type(t){console.warn("prototype.type = 'ModelName' is deprecated, use static __name__ instead"),this.constructor.__name__=t}get type(){return this.constructor.__qualified__}static get __qualified__(){const{__module__:t,__name__:e}=this;return null!=t?`${t}.${e}`:e}static get[Symbol.toStringTag](){return this.__name__}static init_HasProps(){this.prototype._props={},this.prototype._mixins=[],this.define({id:[o.String,()=>_.uniqueId()]})}static _fix_default(t,e){if(void 0!==t){if(l.isFunction(t))return t;if(l.isArray(t))return()=>u.copy(t);if(l.isPlainObject(t))return()=>f.clone(t);if(l.isObject(t))throw new Error(t+" must be explicitly wrapped in a function");return()=>t}}static define(t){for(const[e,r]of f.entries(l.isFunction(t)?t(m):t)){if(null!=this.prototype._props[e])throw new Error(`attempted to redefine property '${this.prototype.type}.${e}'`);if(null!=this.prototype[e])throw new Error(`attempted to redefine attribute '${this.prototype.type}.${e}'`);Object.defineProperty(this.prototype,e,{get(){return this.properties[e].get_value()},set(t){return this.setv({[e]:t}),this},configurable:!1,enumerable:!0});const[t,s,n]=r,i={type:t,default_value:this._fix_default(s,e),options:n},o=f.clone(this.prototype._props);o[e]=i,this.prototype._props=o}}static internal(t){const e={};for(const[r,s]of f.entries(t)){const[t,n,i={}]=s;e[r]=[t,n,Object.assign(Object.assign({},i),{internal:!0})]}this.define(e)}static mixins(t){function e(t){switch(t){case"line":return a.LineVector;case"fill":return a.FillVector;case"hatch":return a.HatchVector;case"text":return a.TextVector;default:throw new Error(`Unknown property mixin kind '${t}'`)}}function r(t,e){const r={};for(const[s,n]of f.entries(e))r[t+s]=n;return r}function s(t){const[e]=Object.keys(t),[r]=e.split("_",1);return r}l.isArray(t)||(t=[t]);const n={},i=[];for(const o of t)if(l.isString(o)){const[t,s=""]=o.split(":"),c=e(t);i.push(o),f.extend(n,r(s,c))}else if(l.isArray(o)){const[t,e]=o;i.push(`${s(e)}:${t}`),f.extend(n,r(t,e))}else{const t=o;i.push(s(t)),f.extend(n,t)}this.define(n),this.prototype._mixins=[...this.prototype._mixins,...i]}static override(t){for(const[e,r]of f.entries(t)){const t=this._fix_default(r,e),s=this.prototype._props[e];if(null==s)throw new Error(`attempted to override nonexistent '${this.prototype.type}.${e}'`);const n=f.clone(this.prototype._props);n[e]=Object.assign(Object.assign({},s),{default_value:t}),this.prototype._props=n}}toString(){return`${this.type}(${this.id})`}property(t){const e=this.properties[t];if(null!=e)return e;throw new Error(`unknown property ${this.type}.${t}`)}get attributes(){const t={};for(const e of this)t[e.attr]=e.get_value();return t}[g.equals](t,e){for(const r of this){const s=t.property(r.attr);if(e.eq(r.get_value(),s.get_value()))return!1}return!0}[v.pretty](t){const e=t.token,r=[];for(const s of this)if(s.dirty){const n=s.get_value();r.push(`${s.attr}${e(":")} ${t.to_string(n)}`)}return`${this.constructor.__qualified__}${e("(")}${e("{")}${r.join(e(",")+" ")}${e("}")}${e(")")}`}finalize(){for(const t of this)null!=t.spec.transform&&this.connect(t.spec.transform.change,()=>this.transformchange.emit());this.initialize()}initialize(){}connect_signals(){}disconnect_signals(){n.Signal.disconnectReceiver(this)}destroy(){this.disconnect_signals(),this.destroyed.emit()}clone(){return new this.constructor(this.attributes)}_setv(t,e){const r=e.check_eq,s=[],n=this._changing;this._changing=!0;for(const[e,n]of t)!1!==r&&h.isEqual(e.get_value(),n)||(e.set_value(n),s.push(e));s.length>0&&(this._pending=!0);for(const t of s)t.change.emit();if(!n){if(!e.no_change)for(;this._pending;)this._pending=!1,this.change.emit();this._pending=!1,this._changing=!1}}setv(t,e={}){const r=f.entries(t);if(0==r.length)return;if(!0===e.silent){for(const[t,e]of r)this.properties[t].set_value(e);return}const s=new Map,n=new Map;for(const[t,e]of r){const r=this.properties[t];s.set(r,e),n.set(r,r.get_value())}this._setv(s,e);const{document:i}=this;if(null!=i){const t=[];for(const[e,r]of n)t.push([e,r,e.get_value()]);for(const[,e,r]of t)if(this._needs_invalidate(e,r)){i._invalidate_all_models();break}this._push_changes(t,e)}}getv(t){return this.property(t).get_value()}ref(){return{id:this.id}}struct(){const t={type:this.type,id:this.id,attributes:{}};return null!=this._subtype&&(t.subtype=this._subtype),t}set_subtype(t){this._subtype=t}*[Symbol.iterator](){yield*f.values(this.properties)}*syncable_properties(){for(const t of this)t.syncable&&(yield t)}serializable_attributes(){const t={};for(const e of this.syncable_properties())t[e.attr]=e.get_value();return t}static _value_to_json(t){if(t instanceof b)return t.ref();if(d.is_NDArray(t))return y.encode_NDArray(t);if(l.isArray(t)||l.isTypedArray(t)){const e=t.length,r=new Array(e);for(let s=0;s<e;s++){const e=t[s];r[s]=b._value_to_json(e)}return r}if(l.isPlainObject(t)){const e={};for(const[r,s]of f.entries(t))e[r]=b._value_to_json(s);return e}return t}attributes_as_json(t=!0,e=b._value_to_json){const r={};for(const s of this)s.syncable&&(t||s.dirty)&&(r[s.attr]=e(s.get_value()));return r}static _json_record_references(t,e,r,s){const{recursive:n}=s;if(i.is_ref(e)){const s=t.get_model_by_id(e.id);null==s||r.has(s)||b._value_record_references(s,r,{recursive:n})}else if(l.isArray(e))for(const s of e)b._json_record_references(t,s,r,{recursive:n});else if(l.isPlainObject(e))for(const s of f.values(e))b._json_record_references(t,s,r,{recursive:n})}static _value_record_references(t,e,r){const{recursive:s}=r;if(t instanceof b){if(!e.has(t)&&(e.add(t),s)){const r=t._immediate_references();for(const t of r)b._value_record_references(t,e,{recursive:!0})}}else if(l.isArray(t))for(const r of t)b._value_record_references(r,e,{recursive:s});else if(l.isPlainObject(t))for(const r of f.values(t))b._value_record_references(r,e,{recursive:s})}_immediate_references(){const t=new Set;for(const e of this.syncable_properties()){const r=e.get_value();b._value_record_references(r,t,{recursive:!1})}return t}references(){const t=new Set;return b._value_record_references(this,t,{recursive:!0}),t}_doc_attached(){}_doc_detached(){}attach_document(t){if(null!=this.document&&this.document!=t)throw new Error("models must be owned by only a single document");this.document=t,this._doc_attached()}detach_document(){this._doc_detached(),this.document=null}_needs_invalidate(t,e){const r=new Set;b._value_record_references(e,r,{recursive:!1});const s=new Set;b._value_record_references(t,s,{recursive:!1});for(const t of r)if(!s.has(t))return!0;for(const t of s)if(!r.has(t))return!0;return!1}_push_changes(t,e={}){const{document:r}=this;if(null==r)return;const{setter_id:s}=e,n=[];for(const[e,i,o]of t)e.syncable&&n.push(new p.ModelChangedEvent(r,this,e.attr,i,o,s));if(0!=n.length){let t;1==n.length?[t]=n:t=new p.DocumentEventBatch(r,n,s),r._trigger_on_change(t)}}materialize_dataspecs(t){const e={};for(const r of this){if(!(r instanceof o.VectorSpec))continue;if(r.optional&&null==r.spec.value&&!r.dirty)continue;const s=r.attr,n=r.array(t);e["_"+s]=n,r instanceof o.DistanceSpec&&(e["max_"+s]=u.max(n))}return e}on_change(t,e){for(const r of l.isArray(t)?t:[t])this.connect(r.change,e)}}r.HasProps=b,b.init_HasProps()},
function _(n,t,e){Object.defineProperty(e,"__esModule",{value:!0});const l=n(16),s=n(9);class o{constructor(n,t){this.sender=n,this.name=t}connect(n,t=null){c.has(this.sender)||c.set(this.sender,[]);const e=c.get(this.sender);if(null!=u(e,this,n,t))return!1;const l=null!=t?t:n;r.has(l)||r.set(l,[]);const s=r.get(l),o={signal:this,slot:n,context:t};return e.push(o),s.push(o),!0}disconnect(n,t=null){const e=c.get(this.sender);if(null==e||0===e.length)return!1;const l=u(e,this,n,t);if(null==l)return!1;const s=null!=t?t:n,o=r.get(s);return l.signal=null,a(e),a(o),!0}emit(n){var t;const e=null!==(t=c.get(this.sender))&&void 0!==t?t:[];for(const{signal:t,slot:l,context:s}of e)t===this&&l.call(s,n,this.sender)}}e.Signal=o,o.__name__="Signal";class i extends o{emit(){super.emit(void 0)}}e.Signal0=i,i.__name__="Signal0",function(n){n.disconnectBetween=function(n,t){const e=c.get(n);if(null==e||0===e.length)return;const l=r.get(t);if(null!=l&&0!==l.length){for(const t of l){if(null==t.signal)return;t.signal.sender===n&&(t.signal=null)}a(e),a(l)}},n.disconnectSender=function(n){var t;const e=c.get(n);if(null!=e&&0!==e.length){for(const n of e){if(null==n.signal)return;const e=null!==(t=n.context)&&void 0!==t?t:n.slot;n.signal=null,a(r.get(e))}a(e)}},n.disconnectReceiver=function(n){const t=r.get(n);if(null!=t&&0!==t.length){for(const n of t){if(null==n.signal)return;const t=n.signal.sender;n.signal=null,a(c.get(t))}a(t)}},n.disconnectAll=function(n){const t=c.get(n);if(null!=t&&0!==t.length){for(const n of t)n.signal=null;a(t)}const e=r.get(n);if(null!=e&&0!==e.length){for(const n of e)n.signal=null;a(e)}}}(o||(e.Signal=o={})),e.Signalable=function(){return class{connect(n,t){return n.connect(t,this)}disconnect(n,t){return n.disconnect(t,this)}}};const c=new WeakMap,r=new WeakMap;function u(n,t,e,l){return s.find(n,n=>n.signal===t&&n.slot===e&&n.context===l)}const g=new Set;function a(n){0===g.size&&l.defer(f),g.add(n)}function f(){for(const n of g)s.remove_by(n,n=>null==n.signal);g.clear()}},
function _(n,e,t){Object.defineProperty(t,"__esModule",{value:!0}),t.delay=
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
function(n,e){return setTimeout(n,e)};const u="function"==typeof requestAnimationFrame?requestAnimationFrame:setImmediate;t.defer=function(n){return new Promise(e=>{u(()=>e(n()))})},t.throttle=function(n,e,t={}){let u,o,i,r=null,l=0;const c=function(){l=!1===t.leading?0:Date.now(),r=null,i=n.apply(u,o),r||(u=o=null)};return function(){const a=Date.now();l||!1!==t.leading||(l=a);const f=e-(a-l);return u=this,o=arguments,f<=0||f>e?(r&&(clearTimeout(r),r=null),l=a,i=n.apply(u,o),r||(u=o=null)):r||!1===t.trailing||(r=setTimeout(c,f)),i}},t.once=function(n){let e,t=!1;return function(){return t||(t=!0,e=n()),e}}},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});const i=e(8),r=e(13);t.is_ref=function(e){if(i.isPlainObject(e)){const n=r.keys(e);return 1==n.length&&"id"==n[0]}return!1}},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const a=e(1),s=e(15),i=e(19),r=a.__importStar(e(20)),l=e(24),o=e(9),c=e(12),_=e(22),u=e(8),d=e(27);function p(e){try{return JSON.stringify(e)}catch(t){return e.toString()}}function S(e){return u.isPlainObject(e)&&(void 0===e.value?0:1)+(void 0===e.field?0:1)+(void 0===e.expr?0:1)==1}n.isSpec=S;class m{constructor(e,t,n,a,i,r={}){var l,o;let c;if(this.obj=e,this.attr=t,this.kind=n,this.default_value=a,this._dirty=!1,this.change=new s.Signal0(this.obj,"change"),this.internal=null!==(l=r.internal)&&void 0!==l&&l,this.optional=null!==(o=r.optional)&&void 0!==o&&o,void 0!==i)c=i,this._dirty=!0;else{const t=this._default_override();c=void 0!==t?t:void 0!==a?a(e):null}this._update(c)}get is_value(){return void 0!==this.spec.value}get syncable(){return!this.internal}get_value(){return this.spec.value}set_value(e){this._update(e),this._dirty=!0}_default_override(){}get dirty(){return this._dirty}_update(e){null!=e&&this.validate(e),this.spec={value:e}}toString(){return`Prop(${this.obj}.${this.attr}, spec: ${p(this.spec)})`}normalize(e){return e}validate(e){if(!this.valid(e))throw new Error(`${this.obj.type}.${this.attr} given invalid value: ${p(e)}`)}valid(e){return this.kind.valid(e)}value(e=!0){if(!this.is_value)throw new Error("attempted to retrieve property value for property without value specification");let t=this.normalize([this.spec.value])[0];return null!=this.spec.transform&&e&&(t=this.spec.transform.compute(t)),t}}n.Property=m,m.__name__="Property";class h extends m{}n.PrimitiveProperty=h,h.__name__="PrimitiveProperty";class v extends m{}n.Any=v,v.__name__="Any";class g extends m{valid(e){return u.isArray(e)||e instanceof Float32Array||e instanceof Float64Array}}n.Array=g,g.__name__="Array";class x extends m{valid(e){return u.isBoolean(e)}}n.Boolean=x,x.__name__="Boolean";class y extends m{valid(e){return u.isString(e)&&_.is_color(e)}}n.Color=y,y.__name__="Color";class f extends m{}n.Instance=f,f.__name__="Instance";class A extends m{valid(e){return u.isNumber(e)}}n.Number=A,A.__name__="Number";class P extends A{valid(e){return u.isNumber(e)&&(0|e)==e}}n.Int=P,P.__name__="Int";class C extends A{}n.Angle=C,C.__name__="Angle";class b extends A{valid(e){return u.isNumber(e)&&0<=e&&e<=1}}n.Percent=b,b.__name__="Percent";class L extends m{valid(e){return u.isString(e)}}n.String=L,L.__name__="String";class N extends m{valid(e){return null===e||u.isString(e)}}n.NullString=N,N.__name__="NullString";class T extends L{}n.FontSize=T,T.__name__="FontSize";class q extends L{_default_override(){return d.settings.dev?"Bokeh":void 0}}n.Font=q,q.__name__="Font";class B extends m{valid(e){return u.isString(e)&&o.includes(this.enum_values,e)}}function M(e){return class extends B{get enum_values(){return[...e]}}}n.EnumProperty=B,B.__name__="EnumProperty",n.Enum=M;class w extends B{get enum_values(){return[...r.Direction]}normalize(e){const t=new Uint8Array(e.length);for(let n=0;n<e.length;n++)switch(e[n]){case"clock":t[n]=0;break;case"anticlock":t[n]=1}return t}}n.Direction=w,w.__name__="Direction",n.Anchor=M(r.Anchor),n.AngleUnits=M(r.AngleUnits),n.BoxOrigin=M(r.BoxOrigin),n.ButtonType=M(r.ButtonType),n.CalendarPosition=M(r.CalendarPosition),n.Dimension=M(r.Dimension),n.Dimensions=M(r.Dimensions),n.Distribution=M(r.Distribution),n.FontStyle=M(r.FontStyle),n.HatchPatternType=M(r.HatchPatternType),n.HTTPMethod=M(r.HTTPMethod),n.HexTileOrientation=M(r.HexTileOrientation),n.HoverMode=M(r.HoverMode),n.LatLon=M(r.LatLon),n.LegendClickPolicy=M(r.LegendClickPolicy),n.LegendLocation=M(r.LegendLocation),n.LineCap=M(r.LineCap),n.LineJoin=M(r.LineJoin),n.LinePolicy=M(r.LinePolicy),n.Location=M(r.Location),n.Logo=M(r.Logo),n.MarkerType=M(r.MarkerType),n.MutedPolicy=M(r.MutedPolicy),n.Orientation=M(r.Orientation),n.OutputBackend=M(r.OutputBackend),n.PaddingUnits=M(r.PaddingUnits),n.Place=M(r.Place),n.PointPolicy=M(r.PointPolicy),n.RadiusDimension=M(r.RadiusDimension),n.RenderLevel=M(r.RenderLevel),n.RenderMode=M(r.RenderMode),n.ResetPolicy=M(r.ResetPolicy),n.RoundingFunction=M(r.RoundingFunction),n.Side=M(r.Side),n.SizingMode=M(r.SizingMode),n.Sort=M(r.Sort),n.SpatialUnits=M(r.SpatialUnits),n.StartEnd=M(r.StartEnd),n.StepMode=M(r.StepMode),n.TapBehavior=M(r.TapBehavior),n.TextAlign=M(r.TextAlign),n.TextBaseline=M(r.TextBaseline),n.TextureRepetition=M(r.TextureRepetition),n.TickLabelOrientation=M(r.TickLabelOrientation),n.TooltipAttachment=M(r.TooltipAttachment),n.UpdateMode=M(r.UpdateMode),n.VerticalAlign=M(r.VerticalAlign);class D extends m{get_value(){return null===this.spec.value?null:this.spec}_update(e){S(e)?this.spec=e:this.spec={value:e},null!=this.spec.value&&this.validate(this.spec.value)}}n.ScalarSpec=D,D.__name__="ScalarSpec";class k extends D{}n.AnyScalar=k,k.__name__="AnyScalar";class F extends D{}n.ColorScalar=F,F.__name__="ColorScalar";class U extends D{}n.NumberScalar=U,U.__name__="NumberScalar";class z extends D{}n.StringScalar=z,z.__name__="StringScalar";class O extends D{}n.NullStringScalar=O,O.__name__="NullStringScalar";class R extends D{}n.ArrayScalar=R,R.__name__="ArrayScalar";class $ extends D{}n.LineJoinScalar=$,$.__name__="LineJoinScalar";class E extends D{}n.LineCapScalar=E,E.__name__="LineCapScalar";class H extends D{}n.FontSizeScalar=H,H.__name__="FontSizeScalar";class j extends D{}n.FontStyleScalar=j,j.__name__="FontStyleScalar";class X extends D{}n.TextAlignScalar=X,X.__name__="TextAlignScalar";class Y extends D{}n.TextBaselineScalar=Y,Y.__name__="TextBaselineScalar";class I extends m{get_value(){return null===this.spec.value?null:this.spec}_update(e){S(e)?this.spec=e:this.spec={value:e},null!=this.spec.value&&this.validate(this.spec.value)}array(e){var t;let n;const a=null!==(t=e.get_length())&&void 0!==t?t:1;if(null!=this.spec.field){const t=e.get_column(this.spec.field);if(null!=t)n=this.normalize(t);else{i.logger.warn(`attempted to retrieve property array for nonexistent field '${this.spec.field}'`);const e=new l.NumberArray(a);e.fill(NaN),n=e}}else if(null!=this.spec.expr)n=this.normalize(this.spec.expr.v_compute(e));else{const e=this.value(!1);if(u.isNumber(e)){const t=new l.NumberArray(a);t.fill(e),n=t}else n=o.repeat(e,a)}return null!=this.spec.transform&&(n=this.spec.transform.v_compute(n)),n}}n.VectorSpec=I,I.__name__="VectorSpec";class J extends I{}n.DataSpec=J,J.__name__="DataSpec";class V extends I{_update(e){super._update(e),null==this.spec.units&&(this.spec.units=this.default_units);const t=this.spec.units;if(!o.includes(this.valid_units,t))throw new Error(`units must be one of ${this.valid_units.join(", ")}; got: ${t}`)}get units(){return this.spec.units}set units(e){this.spec.units=e}}n.UnitsSpec=V,V.__name__="UnitsSpec";class G extends V{array(e){return new l.NumberArray(super.array(e))}}n.NumberUnitsSpec=G,G.__name__="NumberUnitsSpec";class K extends J{}n.BaseCoordinateSpec=K,K.__name__="BaseCoordinateSpec";class Q extends K{}n.CoordinateSpec=Q,Q.__name__="CoordinateSpec";class W extends K{}n.CoordinateSeqSpec=W,W.__name__="CoordinateSeqSpec";class Z extends K{}n.CoordinateSeqSeqSeqSpec=Z,Z.__name__="CoordinateSeqSeqSeqSpec";class ee extends Q{constructor(){super(...arguments),this.dimension="x"}}n.XCoordinateSpec=ee,ee.__name__="XCoordinateSpec";class te extends Q{constructor(){super(...arguments),this.dimension="y"}}n.YCoordinateSpec=te,te.__name__="YCoordinateSpec";class ne extends W{constructor(){super(...arguments),this.dimension="x"}}n.XCoordinateSeqSpec=ne,ne.__name__="XCoordinateSeqSpec";class ae extends W{constructor(){super(...arguments),this.dimension="y"}}n.YCoordinateSeqSpec=ae,ae.__name__="YCoordinateSeqSpec";class se extends Z{constructor(){super(...arguments),this.dimension="x"}}n.XCoordinateSeqSeqSeqSpec=se,se.__name__="XCoordinateSeqSeqSeqSpec";class ie extends Z{constructor(){super(...arguments),this.dimension="y"}}n.YCoordinateSeqSeqSeqSpec=ie,ie.__name__="YCoordinateSeqSeqSeqSpec";class re extends G{get default_units(){return"rad"}get valid_units(){return[...r.AngleUnits]}normalize(e){return"deg"==this.spec.units&&(e=c.map(e,e=>e*Math.PI/180)),e=c.map(e,e=>-e),super.normalize(e)}}n.AngleSpec=re,re.__name__="AngleSpec";class le extends G{get default_units(){return"data"}get valid_units(){return[...r.SpatialUnits]}}n.DistanceSpec=le,le.__name__="DistanceSpec";class oe extends J{array(e){return new Uint8Array(super.array(e))}}n.BooleanSpec=oe,oe.__name__="BooleanSpec";class ce extends J{array(e){return new l.NumberArray(super.array(e))}}n.NumberSpec=ce,ce.__name__="NumberSpec";class _e extends J{array(e){const t=super.array(e),n=t.length,a=new l.ColorArray(n);for(let e=0;e<n;e++){const n=t[e];if(u.isNumber(n))a[e]=n;else{const t=_.color2rgba(n);a[e]=_.encode_rgba(t)}}return a}}n.ColorSpec=_e,_e.__name__="ColorSpec";class ue extends J{}n.FontSizeSpec=ue,ue.__name__="FontSizeSpec";class de extends J{}n.MarkerSpec=de,de.__name__="MarkerSpec";class pe extends J{}n.StringSpec=pe,pe.__name__="StringSpec";class Se extends J{}n.NullStringSpec=Se,Se.__name__="NullStringSpec";class me extends J{}n.NDArraySpec=me,me.__name__="NDArraySpec"},
function _(e,l,o){Object.defineProperty(o,"__esModule",{value:!0});const n=e(8),t=e(13),s={};class g{constructor(e,l){this.name=e,this.level=l}}o.LogLevel=g,g.__name__="LogLevel";class r{constructor(e,l=r.INFO){this._name=e,this.set_level(l)}static get levels(){return Object.keys(r.log_levels)}static get(e,l=r.INFO){if(e.length>0){let o=s[e];return null==o&&(s[e]=o=new r(e,l)),o}throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level")}get level(){return this.get_level()}get_level(){return this._log_level}set_level(e){if(e instanceof g)this._log_level=e;else{if(!n.isString(e)||null==r.log_levels[e])throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");this._log_level=r.log_levels[e]}const l=`[${this._name}]`;for(const[e,o]of t.entries(r.log_levels))o.level<this._log_level.level||this._log_level.level===r.OFF.level?this[e]=function(){}:this[e]=i(e,l)}trace(...e){}debug(...e){}info(...e){}warn(...e){}error(...e){}}function i(e,l){return null!=console[e]?console[e].bind(console,l):null!=console.log?console.log.bind(console,l):function(){}}function _(e){const l=o.logger.level;return n.isString(e)&&null==r.log_levels[e]?(console.log(`[bokeh] unrecognized logging level '${e}' passed to Bokeh.set_log_level(), ignoring`),console.log("[bokeh] valid log levels are: "+r.levels.join(", "))):(console.log(`[bokeh] setting log level to: '${n.isString(e)?e:e.level}'`),o.logger.set_level(e)),l}o.Logger=r,r.__name__="Logger",r.TRACE=new g("trace",0),r.DEBUG=new g("debug",1),r.INFO=new g("info",2),r.WARN=new g("warn",6),r.ERROR=new g("error",7),r.FATAL=new g("fatal",8),r.OFF=new g("off",9),r.log_levels={trace:r.TRACE,debug:r.DEBUG,info:r.INFO,warn:r.WARN,error:r.ERROR,fatal:r.FATAL,off:r.OFF},o.logger=r.get("bokeh"),o.set_log_level=_,o.with_log_level=function(e,l){const o=_(e);try{l()}finally{_(o)}}},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});const o=e(21);t.Align=o.Enum("start","center","end"),t.Anchor=o.Enum("top_left","top_center","top_right","center_left","center","center_right","bottom_left","bottom_center","bottom_right"),t.AngleUnits=o.Enum("deg","rad"),t.BoxOrigin=o.Enum("corner","center"),t.ButtonType=o.Enum("default","primary","success","warning","danger"),t.CalendarPosition=o.Enum("auto","above","below"),t.Dimension=o.Enum("width","height"),t.Dimensions=o.Enum("width","height","both"),t.Direction=o.Enum("clock","anticlock"),t.Distribution=o.Enum("uniform","normal"),t.FontStyle=o.Enum("normal","italic","bold","bold italic"),t.HatchPatternType=o.Enum("blank","dot","ring","horizontal_line","vertical_line","cross","horizontal_dash","vertical_dash","spiral","right_diagonal_line","left_diagonal_line","diagonal_cross","right_diagonal_dash","left_diagonal_dash","horizontal_wave","vertical_wave","criss_cross"," ",".","o","-","|","+",'"',":","@","/","\\","x",",","`","v",">","*"),t.HTTPMethod=o.Enum("POST","GET"),t.HexTileOrientation=o.Enum("pointytop","flattop"),t.HoverMode=o.Enum("mouse","hline","vline"),t.LatLon=o.Enum("lat","lon"),t.LegendClickPolicy=o.Enum("none","hide","mute"),t.LegendLocation=t.Anchor,t.LineCap=o.Enum("butt","round","square"),t.LineJoin=o.Enum("miter","round","bevel"),t.LinePolicy=o.Enum("prev","next","nearest","interp","none"),t.Location=o.Enum("above","below","left","right"),t.Logo=o.Enum("normal","grey"),t.MarkerType=o.Enum("asterisk","circle","circle_cross","circle_dot","circle_x","circle_y","cross","dash","diamond","diamond_cross","diamond_dot","dot","hex","hex_dot","inverted_triangle","plus","square","square_cross","square_dot","square_pin","square_x","triangle","triangle_dot","triangle_pin","x","y"),t.MutedPolicy=o.Enum("show","ignore"),t.Orientation=o.Enum("vertical","horizontal"),t.OutputBackend=o.Enum("canvas","svg","webgl"),t.PaddingUnits=o.Enum("percent","absolute"),t.Place=o.Enum("above","below","left","right","center"),t.PointPolicy=o.Enum("snap_to_data","follow_mouse","none"),t.RadiusDimension=o.Enum("x","y","max","min"),t.RenderLevel=o.Enum("image","underlay","glyph","guide","annotation","overlay"),t.RenderMode=o.Enum("canvas","css"),t.ResetPolicy=o.Enum("standard","event_only"),t.RoundingFunction=o.Enum("round","nearest","floor","rounddown","ceil","roundup"),t.SelectionMode=o.Enum("replace","append","intersect","subtract"),t.Side=o.Enum("above","below","left","right"),t.SizingMode=o.Enum("stretch_width","stretch_height","stretch_both","scale_width","scale_height","scale_both","fixed"),t.Sort=o.Enum("ascending","descending"),t.SpatialUnits=o.Enum("screen","data"),t.StartEnd=o.Enum("start","end"),t.StepMode=o.Enum("after","before","center"),t.TapBehavior=o.Enum("select","inspect"),t.TextAlign=o.Enum("left","right","center"),t.TextBaseline=o.Enum("top","middle","bottom","alphabetic","hanging","ideographic"),t.TextureRepetition=o.Enum("repeat","repeat_x","repeat_y","no_repeat"),t.TickLabelOrientation=o.Enum("vertical","horizontal","parallel","normal"),t.TooltipAttachment=o.Enum("horizontal","vertical","left","right","above","below"),t.UpdateMode=o.Enum("replace","append"),t.VerticalAlign=o.Enum("top","middle","bottom")},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});const s=e(1).__importStar(e(8)),r=e(22);class i{}t.Kind=i,i.__name__="Kind",function(e){class n extends i{valid(e){return!0}}n.__name__="Any",e.Any=n;class t extends i{valid(e){return!0}}t.__name__="Unknown",e.Unknown=t;class l extends i{valid(e){return s.isBoolean(e)}}l.__name__="Boolean",e.Boolean=l;class a extends i{constructor(e){super(),this.obj_type=e}valid(e){return!0}}a.__name__="Ref",e.Ref=a;class _ extends i{valid(e){return s.isNumber(e)}}_.__name__="Number",e.Number=_;class u extends _{valid(e){return super.valid(e)&&s.isInteger(e)}}u.__name__="Int",e.Int=u;class d extends i{constructor(e){super(),this.types=e,this.types=e}valid(e){return this.types.some(n=>n.valid(e))}}d.__name__="Or",e.Or=d;class o extends i{constructor(e){super(),this.types=e,this.types=e}valid(e){if(!s.isArray(e))return!1;for(let n=0;n<this.types.length;n++){const t=this.types[n],s=e[n];if(!t.valid(s))return!1}return!0}}o.__name__="Tuple",e.Tuple=o;class c extends i{constructor(e){super(),this.item_type=e}valid(e){return s.isArray(e)&&e.every(e=>this.item_type.valid(e))}}c.__name__="Array",e.Array=c;class m extends i{valid(e){return null===e}}m.__name__="Null",e.Null=m;class p extends i{constructor(e){super(),this.base_type=e}valid(e){return null===e||this.base_type.valid(e)}}p.__name__="Nullable",e.Nullable=p;class y extends i{valid(e){return s.isString(e)}}y.__name__="String",e.String=y;class v extends i{constructor(e){super(),this.values=new Set(e)}valid(e){return this.values.has(e)}*[Symbol.iterator](){yield*this.values}}v.__name__="Enum",e.Enum=v;class h extends i{constructor(e){super(),this.item_type=e}valid(e){if(!s.isPlainObject(e))return!1;for(const n in e)if(e.hasOwnProperty(n)){const t=e[n];if(!this.item_type.valid(t))return!1}return!0}}h.__name__="Struct",e.Struct=h;class w extends i{constructor(e,n){super(),this.key_type=e,this.item_type=n}valid(e){if(!(e instanceof Map))return!1;for(const[n,t]of e.entries())if(!this.key_type.valid(n)||!this.item_type.valid(t))return!1;return!0}}w.__name__="Dict",e.Dict=w;class K extends i{valid(e){return s.isString(e)&&r.is_color(e)}}K.__name__="Color",e.Color=K;class f extends _{valid(e){return super.valid(e)&&0<=e&&e<=1}}f.__name__="Percent",e.Percent=f}(t.Kinds||(t.Kinds={})),t.Any=new t.Kinds.Any,t.Unknown=new t.Kinds.Unknown,t.Boolean=new t.Kinds.Boolean,t.Number=new t.Kinds.Number,t.Int=new t.Kinds.Int,t.String=new t.Kinds.String,t.Null=new t.Kinds.Null,t.Nullable=e=>new t.Kinds.Nullable(e),t.Or=(...e)=>new t.Kinds.Or(e),t.Tuple=(...e)=>new t.Kinds.Tuple(e),t.Array=e=>new t.Kinds.Array(e),t.Struct=e=>new t.Kinds.Struct(e),t.Dict=(e,n)=>new t.Kinds.Dict(e,n),t.Enum=(...e)=>new t.Kinds.Enum(e),t.Ref=e=>new t.Kinds.Ref(e),t.Percent=new t.Kinds.Percent,t.Color=new t.Kinds.Color,t.Auto=t.Enum("auto"),t.FontSize=t.String,t.Font=t.String,t.Angle=t.Number},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});const n=e(23),l=e(9);function a(e){const r=Number(e).toString(16);return 1==r.length?"0"+r:r}function o(e){if(0==(e+="").indexOf("#"))return e;if(n.is_svg_color(e))return n.svg_colors[e];if(0==e.indexOf("rgb")){const r=e.replace(/^rgba?\(|\s+|\)$/g,"").split(",");let t=r.slice(0,3).map(a).join("");return 4==r.length&&(t+=a(Math.floor(255*parseFloat(r[3])))),"#"+t.slice(0,8)}return e}function s(e){let r;switch(e.substring(0,4)){case"rgba":r={start:"rgba(",len:4,alpha:!0};break;case"rgb(":r={start:"rgb(",len:3,alpha:!1};break;default:return!1}if(new RegExp(".*?(\\.).*(,)").test(e))return!1;const t=e.replace(r.start,"").replace(")","").split(",").map(parseFloat);return t.length==r.len&&((!r.alpha||0<=t[3]&&t[3]<=1)&&!l.includes(t.slice(0,3).map(e=>0<=e&&e<=255),!1))}t.is_color=function(e){return n.is_svg_color(e.toLowerCase())||"#"==e.substring(0,1)||s(e)},t.rgb2hex=function(e,r,t){return`#${a(255&e)}${a(255&r)}${a(255&t)}`},t.color2hex=o,t.encode_rgba=function([e,r,t,n]){return(255*e|0)<<24|(255*r|0)<<16|(255*t|0)<<8|255*n|0},t.decode_rgba=function(e){return[(e>>24&255)/255,(e>>16&255)/255,(e>>8&255)/255,(e>>0&255)/255]},t.color2rgba=function(e,r=1){if(!e)return[0,0,0,0];let t=o(e);t=t.replace(/ |#/g,""),t.length<=4&&(t=t.replace(/(.)/g,"$1$1"));const n=t.match(/../g).map(e=>parseInt(e,16)/255);for(;n.length<3;)n.push(0);return n.length<4&&n.push(r),n.slice(0,4)},t.valid_rgb=s},
function _(e,F,r){Object.defineProperty(r,"__esModule",{value:!0}),r.svg_colors={indianred:"#CD5C5C",lightcoral:"#F08080",salmon:"#FA8072",darksalmon:"#E9967A",lightsalmon:"#FFA07A",crimson:"#DC143C",red:"#FF0000",firebrick:"#B22222",darkred:"#8B0000",pink:"#FFC0CB",lightpink:"#FFB6C1",hotpink:"#FF69B4",deeppink:"#FF1493",mediumvioletred:"#C71585",palevioletred:"#DB7093",coral:"#FF7F50",tomato:"#FF6347",orangered:"#FF4500",darkorange:"#FF8C00",orange:"#FFA500",gold:"#FFD700",yellow:"#FFFF00",lightyellow:"#FFFFE0",lemonchiffon:"#FFFACD",lightgoldenrodyellow:"#FAFAD2",papayawhip:"#FFEFD5",moccasin:"#FFE4B5",peachpuff:"#FFDAB9",palegoldenrod:"#EEE8AA",khaki:"#F0E68C",darkkhaki:"#BDB76B",lavender:"#E6E6FA",thistle:"#D8BFD8",plum:"#DDA0DD",violet:"#EE82EE",orchid:"#DA70D6",fuchsia:"#FF00FF",magenta:"#FF00FF",mediumorchid:"#BA55D3",mediumpurple:"#9370DB",blueviolet:"#8A2BE2",darkviolet:"#9400D3",darkorchid:"#9932CC",darkmagenta:"#8B008B",purple:"#800080",indigo:"#4B0082",slateblue:"#6A5ACD",darkslateblue:"#483D8B",mediumslateblue:"#7B68EE",greenyellow:"#ADFF2F",chartreuse:"#7FFF00",lawngreen:"#7CFC00",lime:"#00FF00",limegreen:"#32CD32",palegreen:"#98FB98",lightgreen:"#90EE90",mediumspringgreen:"#00FA9A",springgreen:"#00FF7F",mediumseagreen:"#3CB371",seagreen:"#2E8B57",forestgreen:"#228B22",green:"#008000",darkgreen:"#006400",yellowgreen:"#9ACD32",olivedrab:"#6B8E23",olive:"#808000",darkolivegreen:"#556B2F",mediumaquamarine:"#66CDAA",darkseagreen:"#8FBC8F",lightseagreen:"#20B2AA",darkcyan:"#008B8B",teal:"#008080",aqua:"#00FFFF",cyan:"#00FFFF",lightcyan:"#E0FFFF",paleturquoise:"#AFEEEE",aquamarine:"#7FFFD4",turquoise:"#40E0D0",mediumturquoise:"#48D1CC",darkturquoise:"#00CED1",cadetblue:"#5F9EA0",steelblue:"#4682B4",lightsteelblue:"#B0C4DE",powderblue:"#B0E0E6",lightblue:"#ADD8E6",skyblue:"#87CEEB",lightskyblue:"#87CEFA",deepskyblue:"#00BFFF",dodgerblue:"#1E90FF",cornflowerblue:"#6495ED",royalblue:"#4169E1",blue:"#0000FF",mediumblue:"#0000CD",darkblue:"#00008B",navy:"#000080",midnightblue:"#191970",cornsilk:"#FFF8DC",blanchedalmond:"#FFEBCD",bisque:"#FFE4C4",navajowhite:"#FFDEAD",wheat:"#F5DEB3",burlywood:"#DEB887",tan:"#D2B48C",rosybrown:"#BC8F8F",sandybrown:"#F4A460",goldenrod:"#DAA520",darkgoldenrod:"#B8860B",peru:"#CD853F",chocolate:"#D2691E",saddlebrown:"#8B4513",sienna:"#A0522D",brown:"#A52A2A",maroon:"#800000",white:"#FFFFFF",snow:"#FFFAFA",honeydew:"#F0FFF0",mintcream:"#F5FFFA",azure:"#F0FFFF",aliceblue:"#F0F8FF",ghostwhite:"#F8F8FF",whitesmoke:"#F5F5F5",seashell:"#FFF5EE",beige:"#F5F5DC",oldlace:"#FDF5E6",floralwhite:"#FFFAF0",ivory:"#FFFFF0",antiquewhite:"#FAEBD7",linen:"#FAF0E6",lavenderblush:"#FFF0F5",mistyrose:"#FFE4E1",gainsboro:"#DCDCDC",lightgray:"#D3D3D3",lightgrey:"#D3D3D3",silver:"#C0C0C0",darkgray:"#A9A9A9",darkgrey:"#A9A9A9",gray:"#808080",grey:"#808080",dimgray:"#696969",dimgrey:"#696969",lightslategray:"#778899",lightslategrey:"#778899",slategray:"#708090",slategrey:"#708090",darkslategray:"#2F4F4F",darkslategrey:"#2F4F4F",black:"#000000"},r.is_svg_color=function(e){return e in r.svg_colors}},
function _(r,t,e){Object.defineProperty(e,"__esModule",{value:!0}),e.NumberArray=Float32Array,e.ColorArray=Uint32Array;const s=r(25);class a{constructor(r,t){this.offsets=r,this.array=t}[s.equals](r,t){return t.arrays(this.offsets,r.offsets)&&t.arrays(this.array,r.array)}get length(){return this.offsets.length}clone(){return new a(new Uint32Array(this.offsets),new e.NumberArray(this.array))}static from(r){const t=r.length,s=new Uint32Array(t);let n=0;for(let e=0;e<t;e++){const t=r[e].length;s[e]=n,n+=t}const o=new e.NumberArray(n);for(let e=0;e<t;e++)o.set(r[e],s[e]);return new a(s,o)}*[Symbol.iterator](){const{offsets:r,length:t}=this;for(let e=0;e<t;e++)yield this.array.subarray(r[e],r[e+1])}get(r){const{offsets:t}=this;return this.array.subarray(t[r],t[r+1])}set(r,t){this.array.set(t,this.offsets[r])}}e.RaggedArray=a,a.__name__="RaggedArray",a[Symbol.toStringTag]="RaggedArray";var n=r(26);e.Indices=n.BitSet},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0}),r.equals=Symbol("equals"),r.wildcard=Symbol("wildcard");const n=Object.prototype.toString;class s{constructor(){this.a_stack=[],this.b_stack=[]}eq(t,e){if(Object.is(t,e))return!0;if(t===r.wildcard||e===r.wildcard)return!0;if(null==t||null==e)return t===e;const s=n.call(t);if(s!=n.call(e))return!1;switch(s){case"[object Number]":return this.numbers(t,e);case"[object RegExp]":case"[object String]":return""+t==""+e;case"[object Date]":case"[object Boolean]":return+t==+e}const{a_stack:o,b_stack:c}=this;let a=o.length;for(;a--;)if(o[a]===t)return c[a]===e;o.push(t),c.push(e);const i=(()=>{if(null!=t[r.equals]&&null!=e[r.equals])return t[r.equals](e,this);switch(s){case"[object Array]":case"[object Uint8Array]":case"[object Int8Array]":case"[object Uint16Array]":case"[object Int16Array]":case"[object Uint32Array]":case"[object Int32Array]":case"[object Float32Array]":case"[object Float64Array]":return this.arrays(t,e);case"[object Map]":return this.maps(t,e);case"[object Set]":return this.sets(t,e);case"[object Object]":if(t.constructor==e.constructor&&(null==t.constructor||t.constructor===Object))return this.objects(t,e);case"[object Function]":if(t.constructor==e.constructor&&t.constructor===Function)return this.eq(""+t,""+e)}if(t instanceof Node)return this.nodes(t,e);throw Error("can't compare objects of type "+s)})();return o.pop(),c.pop(),i}numbers(t,e){return Object.is(t,e)}arrays(t,e){const{length:r}=t;if(r!=e.length)return!1;for(let n=0;n<r;n++)if(!this.eq(t[n],e[n]))return!1;return!0}iterables(t,e){const r=t[Symbol.iterator](),n=e[Symbol.iterator]();for(;;){const t=r.next(),e=n.next();if(t.done&&e.done)return!0;if(t.done||e.done)return!1;if(!this.eq(t.value,e.value))return!1}}maps(t,e){if(t.size!=e.size)return!1;for(const[r,n]of t)if(!e.has(r)||!this.eq(n,e.get(r)))return!1;return!0}sets(t,e){if(t.size!=e.size)return!1;for(const r of t)if(!e.has(r))return!1;return!0}objects(t,e){const r=Object.keys(t);if(r.length!=Object.keys(e).length)return!1;for(const n of r)if(!e.hasOwnProperty(n)||!this.eq(t[n],e[n]))return!1;return!0}nodes(t,e){return t.nodeType==e.nodeType&&(t.textContent==e.textContent&&!!this.iterables(t.childNodes,e.childNodes))}}r.Comparator=s,s.__name__="Comparator";const{abs:o}=Math;class c extends s{constructor(t=1e-4){super(),this.tolerance=t}numbers(t,e){return super.numbers(t,e)||o(t-e)<this.tolerance}}function a(t,e){return(new s).eq(t,e)}r.SimilarComparator=c,c.__name__="SimilarComparator",r.is_equal=a,r.is_similar=function(t,e,r){return new c(r).eq(t,e)},r.isEqual=a},
function _(t,s,r){Object.defineProperty(r,"__esModule",{value:!0});const e=t(11),i=t(9),n=t(25);class o{constructor(t,s=0){this.size=t,this[Symbol.toStringTag]="BitSet",this._count=null,this._nwords=Math.ceil(t/32),0==s||1==s?(this._array=new Uint32Array(this._nwords),1==s&&this._array.fill(4294967295)):(e.assert(s.length==this._nwords,"Initializer size mismatch"),this._array=s)}clone(){return new o(this.size,new Uint32Array(this._array))}[n.equals](t,s){if(!s.eq(this.size,t.size))return!1;const{_nwords:r}=this,e=this.size%r,i=0==e?r:r-1;for(let s=0;s<i;s++)if(this._array[s]!=t._array[s])return!1;if(0==e)return!0;{const s=1<<e-1,r=s-1^s;return(this._array[i]&r)==(t._array[i]&r)}}static all_set(t){return new o(t,1)}static all_unset(t){return new o(t,0)}static from_indices(t,s){const r=new o(t);for(const t of s)r.set(t);return r}static from_booleans(t,s){const r=new o(t),e=Math.min(t,s.length);for(let t=0;t<e;t++)s[t]&&r.set(t);return r}_check_bounds(t){e.assert(0<=t&&t<this.size,"Out of bounds")}get(t){this._check_bounds(t);const s=t>>>5,r=31&t;return!!(this._array[s]>>r&1)}set(t,s=!0){this._check_bounds(t),this._count=null;const r=t>>>5,e=31&t;s?this._array[r]|=1<<e:this._array[r]&=~(1<<e)}unset(t){this.set(t,!1)}*[Symbol.iterator](){yield*this.ones()}get count(){let t=this._count;return null==t&&(this._count=t=this._get_count()),t}_get_count(){const{_array:t,_nwords:s,size:r}=this;let e=0;for(let i=0,n=0;n<s;n++){const s=t[n];if(0==s)i+=32;else for(let t=0;t<32&&i<r;t++,i++)s>>>t&1&&(e+=1)}return e}*ones(){const{_array:t,_nwords:s,size:r}=this;for(let e=0,i=0;i<s;i++){const s=t[i];if(0!=s)for(let t=0;t<32&&e<r;t++,e++)s>>>t&1&&(yield e);else e+=32}}*zeros(){const{_array:t,_nwords:s,size:r}=this;for(let e=0,i=0;i<s;i++){const s=t[i];if(4294967295!=s)for(let t=0;t<32&&e<r;t++,e++)s>>>t&1||(yield e);else e+=32}}_check_size(t){e.assert(this.size==t.size,"Size mismatch")}add(t){this._check_size(t);for(let s=0;s<this._nwords;s++)this._array[s]|=t._array[s]}intersect(t){this._check_size(t);for(let s=0;s<this._nwords;s++)this._array[s]&=t._array[s]}subtract(t){this._check_size(t);for(let s=0;s<this._nwords;s++){const r=this._array[s],e=t._array[s];this._array[s]=(r^e)&r}}union(t){this._check_size(t);const s=this.clone();for(let r=0;r<this._nwords;r++)s._array[r]|=t._array[r];return s}intersection(t){this._check_size(t);const s=this.clone();for(let r=0;r<this._nwords;r++)s._array[r]&=t._array[r];return s}difference(t){this._check_size(t);const s=this.clone();for(let r=0;r<this._nwords;r++){const e=this._array[r],i=t._array[r];s._array[r]=(e^i)&e}return s}select(t){const s=this.count,r=new t.constructor(s);let e=0;for(const s of this)r[e++]=t[s];return r}}r.BitSet=o,o.__name__="BitSet";class a{constructor(t,s,r){this.nrows=t,this.ncols=s,this._matrix=new Array(t);for(let e=0;e<t;e++){this._matrix[e]=new Array(s);for(let t=0;t<s;t++)this._matrix[e][t]=r(e,t)}}at(t,s){return this._matrix[t][s]}*[Symbol.iterator](){for(let t=0;t<this.nrows;t++)for(let s=0;s<this.ncols;s++){const r=this._matrix[t][s];yield[r,t,s]}}*values(){for(const[t]of this)yield t}map(t){return new a(this.nrows,this.ncols,(s,r)=>t(this.at(s,r),s,r))}apply(t){const s=a.from(t),{nrows:r,ncols:e}=this;if(r==s.nrows&&e==s.ncols)return new a(r,e,(t,r)=>s.at(t,r)(this.at(t,r),t,r));throw new Error("dimensions don't match")}to_sparse(){return[...this]}static from(t,s){if(t instanceof a)return t;if(null!=s){const r=t,e=Math.floor(r.length/s);return new a(e,s,(t,e)=>r[t*s+e])}{const s=t,r=t.length,e=i.min(s.map(t=>t.length));return new a(r,e,(t,r)=>s[t][r])}}}r.Matrix=a,a.__name__="Matrix"},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});class n{constructor(){this._dev=!1}set dev(e){this._dev=e}get dev(){return this._dev}}s.Settings=n,n.__name__="Settings",s.settings=new n},
function _(e,l,t){Object.defineProperty(t,"__esModule",{value:!0});const a=e(1).__importStar(e(18));t.Line={line_color:[a.Color,"black"],line_alpha:[a.Number,1],line_width:[a.Number,1],line_join:[a.LineJoin,"bevel"],line_cap:[a.LineCap,"butt"],line_dash:[a.Array,[]],line_dash_offset:[a.Number,0]},t.Fill={fill_color:[a.Color,"gray"],fill_alpha:[a.Number,1]},t.Hatch={hatch_color:[a.Color,"black"],hatch_alpha:[a.Number,1],hatch_scale:[a.Number,12],hatch_pattern:[a.NullString,null],hatch_weight:[a.Number,1],hatch_extra:[a.Any,{}]},t.Text={text_color:[a.Color,"#444444"],text_alpha:[a.Number,1],text_font:[a.Font,"helvetica"],text_font_size:[a.FontSize,"16px"],text_font_style:[a.FontStyle,"normal"],text_align:[a.TextAlign,"left"],text_baseline:[a.TextBaseline,"bottom"],text_line_height:[a.Number,1.2]},t.LineScalar={line_color:[a.ColorScalar,"black"],line_alpha:[a.NumberScalar,1],line_width:[a.NumberScalar,1],line_join:[a.LineJoinScalar,"bevel"],line_cap:[a.LineCapScalar,"butt"],line_dash:[a.ArrayScalar,[]],line_dash_offset:[a.NumberScalar,0]},t.FillScalar={fill_color:[a.ColorScalar,"gray"],fill_alpha:[a.NumberScalar,1]},t.HatchScalar={hatch_color:[a.ColorScalar,"black"],hatch_alpha:[a.NumberScalar,1],hatch_scale:[a.NumberScalar,12],hatch_pattern:[a.NullStringScalar,null],hatch_weight:[a.NumberScalar,1],hatch_extra:[a.AnyScalar,{}]},t.TextScalar={text_color:[a.ColorScalar,"#444444"],text_alpha:[a.NumberScalar,1],text_font:[a.Font,"helvetica"],text_font_size:[a.FontSizeScalar,"16px"],text_font_style:[a.FontStyleScalar,"normal"],text_align:[a.TextAlignScalar,"left"],text_baseline:[a.TextBaselineScalar,"bottom"],text_line_height:[a.NumberScalar,1.2]},t.LineVector={line_color:[a.ColorSpec,"black"],line_alpha:[a.NumberSpec,1],line_width:[a.NumberSpec,1],line_join:[a.LineJoin,"bevel"],line_cap:[a.LineCap,"butt"],line_dash:[a.Array,[]],line_dash_offset:[a.Number,0]},t.FillVector={fill_color:[a.ColorSpec,"gray"],fill_alpha:[a.NumberSpec,1]},t.HatchVector={hatch_color:[a.ColorSpec,"black"],hatch_alpha:[a.NumberSpec,1],hatch_scale:[a.NumberSpec,12],hatch_pattern:[a.NullStringSpec,null],hatch_weight:[a.NumberSpec,1],hatch_extra:[a.Any,{}]},t.TextVector={text_color:[a.ColorSpec,"#444444"],text_alpha:[a.NumberSpec,1],text_font:[a.Font,"helvetica"],text_font_size:[a.FontSizeSpec,"16px"],text_font_style:[a.FontStyle,"normal"],text_align:[a.TextAlign,"left"],text_baseline:[a.TextBaseline,"bottom"],text_line_height:[a.Number,1.2]}},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});const n=t(27);function u(){const t=new Array(32);for(let e=0;e<32;e++)t[e]="0123456789ABCDEF".substr(Math.floor(16*Math.random()),1);return t[12]="4",t[16]="0123456789ABCDEF".substr(3&t[16].charCodeAt(0)|8,1),t.join("")}r.startsWith=function(t,e,r=0){return t.substr(r,e.length)==e},r.uuid4=u;let s=1e3;r.uniqueId=function(t){const e=n.settings.dev?"j"+s++:u();return null!=t?`${t}-${e}`:e},r.escape=function(t){return t.replace(/(?:[&<>"'`])/g,t=>{switch(t){case"&":return"&amp;";case"<":return"&lt;";case">":return"&gt;";case'"':return"&quot;";case"'":return"&#x27;";case"`":return"&#x60;";default:return t}})},r.unescape=function(t){return t.replace(/&(amp|lt|gt|quot|#x27|#x60);/g,(t,e)=>{switch(e){case"amp":return"&";case"lt":return"<";case"gt":return">";case"quot":return'"';case"#x27":return"'";case"#x60":return"`";default:return e}})},r.use_strict=function(t){return"'use strict';\n"+t}},
function _(t,s,e){Object.defineProperty(e,"__esModule",{value:!0});const r=t(8),a=t(11),n=t(25),i=Symbol("__ndarray__");class h extends Uint8Array{constructor(t,s){super(t),this.__ndarray__=i,this.dtype="uint8",this.shape=null!=s?s:d(t)?t.shape:[this.length],this.dimension=this.shape.length}[n.equals](t,s){return s.eq(this.shape,t.shape)&&s.arrays(this,t)}}e.Uint8NDArray=h,h.__name__="Uint8NDArray";class _ extends Int8Array{constructor(t,s){super(t),this.__ndarray__=i,this.dtype="int8",this.shape=null!=s?s:d(t)?t.shape:[this.length],this.dimension=this.shape.length}[n.equals](t,s){return s.eq(this.shape,t.shape)&&s.arrays(this,t)}}e.Int8NDArray=_,_.__name__="Int8NDArray";class u extends Uint16Array{constructor(t,s){super(t),this.__ndarray__=i,this.dtype="uint16",this.shape=null!=s?s:d(t)?t.shape:[this.length],this.dimension=this.shape.length}[n.equals](t,s){return s.eq(this.shape,t.shape)&&s.arrays(this,t)}}e.Uint16NDArray=u,u.__name__="Uint16NDArray";class l extends Int16Array{constructor(t,s){super(t),this.__ndarray__=i,this.dtype="int16",this.shape=null!=s?s:d(t)?t.shape:[this.length],this.dimension=this.shape.length}[n.equals](t,s){return s.eq(this.shape,t.shape)&&s.arrays(this,t)}}e.Int16NDArray=l,l.__name__="Int16NDArray";class y extends Uint32Array{constructor(t,s){super(t),this.__ndarray__=i,this.dtype="uint32",this.shape=null!=s?s:d(t)?t.shape:[this.length],this.dimension=this.shape.length}[n.equals](t,s){return s.eq(this.shape,t.shape)&&s.arrays(this,t)}}e.Uint32NDArray=y,y.__name__="Uint32NDArray";class c extends Int32Array{constructor(t,s){super(t),this.__ndarray__=i,this.dtype="int32",this.shape=null!=s?s:d(t)?t.shape:[this.length],this.dimension=this.shape.length}[n.equals](t,s){return s.eq(this.shape,t.shape)&&s.arrays(this,t)}}e.Int32NDArray=c,c.__name__="Int32NDArray";class p extends Float32Array{constructor(t,s){super(t),this.__ndarray__=i,this.dtype="float32",this.shape=null!=s?s:d(t)?t.shape:[this.length],this.dimension=this.shape.length}[n.equals](t,s){return s.eq(this.shape,t.shape)&&s.arrays(this,t)}}e.Float32NDArray=p,p.__name__="Float32NDArray";class o extends Float64Array{constructor(t,s){super(t),this.__ndarray__=i,this.dtype="float64",this.shape=null!=s?s:d(t)?t.shape:[this.length],this.dimension=this.shape.length}[n.equals](t,s){return s.eq(this.shape,t.shape)&&s.arrays(this,t)}}function d(t){return r.isObject(t)&&t.__ndarray__==i}e.Float64NDArray=o,o.__name__="Float64NDArray",e.is_NDArray=d,e.ndarray=function(t,s={}){let{dtype:e}=s;null==e&&(e=t instanceof ArrayBuffer||r.isArray(t)?"float32":(()=>{switch(!0){case t instanceof Uint8Array:return"uint8";case t instanceof Int8Array:return"int8";case t instanceof Uint16Array:return"uint16";case t instanceof Int16Array:return"int16";case t instanceof Uint32Array:return"uint32";case t instanceof Int32Array:return"int32";case t instanceof Float32Array:return"float32";case t instanceof Float64Array:return"float64";default:a.unreachable()}})());const{shape:n}=s;switch(e){case"uint8":return new h(t,n);case"int8":return new _(t,n);case"uint16":return new u(t,n);case"int16":return new l(t,n);case"uint32":return new y(t,n);case"int32":return new c(t,n);case"float32":return new p(t,n);case"float64":return new o(t,n)}}},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});const n=e(1),a=e(8),f=e(32),_=n.__importStar(e(30));function o(e){const r=new Uint8Array(e),t=Array.from(r).map(e=>String.fromCharCode(e));return btoa(t.join(""))}function s(e){const r=atob(e),t=r.length,n=new Uint8Array(t);for(let e=0,a=t;e<a;e++)n[e]=r.charCodeAt(e);return n.buffer}function i(e){const r=new Uint8Array(e.buffer,e.byteOffset,2*e.length);for(let e=0,t=r.length;e<t;e+=2){const t=r[e];r[e]=r[e+1],r[e+1]=t}}function u(e){const r=new Uint8Array(e.buffer,e.byteOffset,4*e.length);for(let e=0,t=r.length;e<t;e+=4){let t=r[e];r[e]=r[e+3],r[e+3]=t,t=r[e+1],r[e+1]=r[e+2],r[e+2]=t}}function c(e){const r=new Uint8Array(e.buffer,e.byteOffset,8*e.length);for(let e=0,t=r.length;e<t;e+=8){let t=r[e];r[e]=r[e+7],r[e+7]=t,t=r[e+1],r[e+1]=r[e+6],r[e+6]=t,t=r[e+2],r[e+2]=r[e+5],r[e+5]=t,t=r[e+3],r[e+3]=r[e+4],r[e+4]=t}}t.buffer_to_base64=o,t.base64_to_buffer=s,t.BYTE_ORDER=f.is_little_endian?"little":"big",t.swap16=i,t.swap32=u,t.swap64=c,t.is_NDArray_ref=function(e){return a.isPlainObject(e)&&("__buffer__"in e||"__ndarray__"in e)},t.decode_NDArray=function(e,r){const{shape:n,dtype:a,order:f}=e;let o;if("__buffer__"in e){const t=r.get(e.__buffer__);if(null==t)throw new Error(`buffer for ${e.__buffer__} not found`);o=t}else o=s(e.__ndarray__);const l=(()=>{switch(a){case"uint8":return new _.Uint8NDArray(o,n);case"int8":return new _.Int8NDArray(o,n);case"uint16":return new _.Uint16NDArray(o,n);case"int16":return new _.Int16NDArray(o,n);case"uint32":return new _.Uint32NDArray(o,n);case"int32":return new _.Int32NDArray(o,n);case"float32":return new _.Float32NDArray(o,n);case"float64":return new _.Float64NDArray(o,n)}})();if(f!==t.BYTE_ORDER)switch(l.BYTES_PER_ELEMENT){case 2:i(l);break;case 4:u(l);break;case 8:c(l)}return l},t.encode_NDArray=function(e,r){const n={order:t.BYTE_ORDER,dtype:e.dtype,shape:e.shape};if(null!=r){const t=""+r.size;return r.set(t,e.buffer),Object.assign({__buffer__:t},n)}{const r=o(e.buffer);return Object.assign({__ndarray__:r},n)}}},
function _(e,n,i){Object.defineProperty(i,"__esModule",{value:!0}),i.is_ie=(()=>{const e="undefined"!=typeof navigator?navigator.userAgent:"";return e.indexOf("MSIE")>=0||e.indexOf("Trident")>0||e.indexOf("Edge")>0})(),i.is_mobile="undefined"!=typeof window&&("ontouchstart"in window||navigator.maxTouchPoints>0),i.is_little_endian=(()=>{const e=new ArrayBuffer(4),n=new Uint8Array(e);new Uint32Array(e)[1]=168496141;let i=!0;return 10==n[4]&&11==n[5]&&12==n[6]&&13==n[7]&&(i=!1),i})()},
function _(t,r,n){Object.defineProperty(n,"__esModule",{value:!0});const e=t(8),i=t(13);n.pretty=Symbol("pretty");class o{constructor(t){this.precision=null==t?void 0:t.precision}to_string(t){return function(t){return n.pretty in Object(t)}(t)?t[n.pretty](this):e.isBoolean(t)?this.boolean(t):e.isNumber(t)?this.number(t):e.isString(t)?this.string(t):e.isArray(t)?this.array(t):e.isIterable(t)?this.iterable(t):e.isPlainObject(t)?this.object(t):""+t}token(t){return t}boolean(t){return""+t}number(t){return null!=this.precision?t.toFixed(this.precision):""+t}string(t){return`"${t.replace(/'/g,"\\'")}"`}array(t){const r=this.token,n=[];for(const r of t)n.push(this.to_string(r));return`${r("[")}${n.join(r(",")+" ")}${r("]")}`}iterable(t){var r;const n=this.token,e=null!==(r=Object(t)[Symbol.toStringTag])&&void 0!==r?r:"Object",i=this.array(t);return`${e}${n("(")}${i}${n(")")}`}object(t){const r=this.token,n=[];for(const[e,o]of i.entries(t))n.push(`${e}${r(":")} ${this.to_string(o)}`);return`${r("{")}${n.join(r(",")+" ")}${r("}")}`}}n.Printer=o,o.__name__="Printer",n.to_string=function(t,r){return new o(r).to_string(t)}},
function _(t,_,r){Object.defineProperty(r,"__esModule",{value:!0});const e=t(1);e.__exportStar(t(35),r),e.__exportStar(t(176),r),e.__exportStar(t(203),r),e.__exportStar(t(207),r),e.__exportStar(t(218),r),e.__exportStar(t(222),r),e.__exportStar(t(228),r),e.__exportStar(t(232),r),e.__exportStar(t(265),r),e.__exportStar(t(268),r),e.__exportStar(t(270),r),e.__exportStar(t(132),r),e.__exportStar(t(148),r),e.__exportStar(t(287),r),e.__exportStar(t(291),r),e.__exportStar(t(320),r),e.__exportStar(t(321),r),e.__exportStar(t(322),r),e.__exportStar(t(323),r),e.__exportStar(t(324),r),e.__exportStar(t(329),r),e.__exportStar(t(331),r),e.__exportStar(t(342),r),e.__exportStar(t(346),r)},
function _(a,e,o){Object.defineProperty(o,"__esModule",{value:!0});var r=a(36);o.Annotation=r.Annotation;var n=a(83);o.Arrow=n.Arrow;var t=a(84);o.ArrowHead=t.ArrowHead;var v=a(84);o.OpenHead=v.OpenHead;var l=a(84);o.NormalHead=l.NormalHead;var d=a(84);o.TeeHead=d.TeeHead;var i=a(84);o.VeeHead=i.VeeHead;var A=a(122);o.Band=A.Band;var H=a(124);o.BoxAnnotation=H.BoxAnnotation;var T=a(125);o.ColorBar=T.ColorBar;var p=a(160);o.Label=p.Label;var L=a(162);o.LabelSet=L.LabelSet;var b=a(163);o.Legend=b.Legend;var B=a(164);o.LegendItem=B.LegendItem;var S=a(166);o.PolyAnnotation=S.PolyAnnotation;var P=a(167);o.Slope=P.Slope;var g=a(168);o.Span=g.Span;var m=a(161);o.TextAnnotation=m.TextAnnotation;var w=a(169);o.Title=w.Title;var x=a(170);o.ToolbarPanel=x.ToolbarPanel;var s=a(171);o.Tooltip=s.Tooltip;var u=a(175);o.Whisker=u.Whisker},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});const s=t(1).__importStar(t(37)),i=t(13),o=t(70);class _ extends o.RendererView{get panel(){return this.layout}connect_signals(){super.connect_signals();const t=this.model.properties;this.on_change(t.visible,()=>this.plot_view.request_layout())}get_size(){if(this.model.visible){const{width:t,height:e}=this._get_size();return{width:Math.round(t),height:Math.round(e)}}return{width:0,height:0}}_get_size(){throw new Error("not implemented")}set_data(t){const e=this.model.materialize_dataspecs(t);if(i.extend(this,e),this.plot_model.use_map){const t=this;null!=t._x&&([t._x,t._y]=s.project_xy(t._x,t._y)),null!=t._xs&&([t._xs,t._ys]=s.project_xsys(t._xs,t._ys))}}get needs_clip(){return null==this.layout}serializable_state(){const t=super.serializable_state();return null==this.layout?t:Object.assign(Object.assign({},t),{bbox:this.layout.bbox.box})}}n.AnnotationView=_,_.__name__="AnnotationView";class a extends o.Renderer{constructor(t){super(t)}static init_Annotation(){this.override({level:"annotation"})}}n.Annotation=a,a.__name__="Annotation",a.init_Annotation()},
function _(n,t,e){Object.defineProperty(e,"__esModule",{value:!0});const r=n(1),o=r.__importDefault(n(38)),l=r.__importDefault(n(39)),c=n(24),i=new l.default("GOOGLE"),u=new l.default("WGS84"),a=o.default(u,i);e.wgs84_mercator={compute:(n,t)=>isFinite(n)&&isFinite(t)?a.forward([n,t]):[NaN,NaN],invert:(n,t)=>isFinite(n)&&isFinite(t)?a.inverse([n,t]):[NaN,NaN]};const s={lon:[-20026376.39,20026376.39],lat:[-20048966.1,20048966.1]},f={lon:[-180,180],lat:[-85.06,85.06]},{min:_,max:p}=Math;function m(n,t){const r=_(n.length,t.length),o=new c.NumberArray(r),l=new c.NumberArray(r);return e.inplace.project_xy(n,t,o,l),[o,l]}e.clip_mercator=function(n,t,e){const[r,o]=s[e];return[p(n,r),_(t,o)]},e.in_bounds=function(n,t){const[e,r]=f[t];return e<n&&n<r},function(n){function t(n,t,r,o){const l=_(n.length,t.length);r=null!=r?r:n,o=null!=o?o:t;for(let c=0;c<l;c++){const l=n[c],i=t[c],[u,a]=e.wgs84_mercator.compute(l,i);r[c]=u,o[c]=a}}n.project_xy=t,n.project_xsys=function(n,e,r,o){const l=_(n.length,e.length);r=null!=r?r:n,o=null!=o?o:e;for(let c=0;c<l;c++)t(n[c],e[c],r[c],o[c])}}(e.inplace||(e.inplace={})),e.project_xy=m,e.project_xsys=function(n,t){const e=_(n.length,t.length),r=new Array(e),o=new Array(e);for(let l=0;l<e;l++){const[e,c]=m(n[l],t[l]);r[l]=e,o[l]=c}return[r,o]}},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});const r=e(1),o=r.__importDefault(e(39)),a=r.__importDefault(e(64));var i=o.default("WGS84");function c(e,n,t){var r,o,i;return Array.isArray(t)?(r=a.default(e,n,t)||{x:NaN,y:NaN},t.length>2?void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name?"number"==typeof r.z?[r.x,r.y,r.z].concat(t.splice(3)):[r.x,r.y,t[2]].concat(t.splice(3)):[r.x,r.y].concat(t.splice(2)):[r.x,r.y]):(o=a.default(e,n,t),2===(i=Object.keys(t)).length||i.forEach((function(r){if(void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name){if("x"===r||"y"===r||"z"===r)return}else if("x"===r||"y"===r)return;o[r]=t[r]})),o)}function u(e){return e instanceof o.default?e:e.oProj?e.oProj:o.default(e)}t.default=function(e,n,t){e=u(e);var r,o=!1;return void 0===n?(n=e,e=i,o=!0):(void 0!==n.x||Array.isArray(n))&&(t=n,n=e,e=i,o=!0),n=u(n),t?c(e,n,t):(r={forward:function(t){return c(e,n,t)},inverse:function(t){return c(n,e,t)}},o&&(r.oProj=n),r)}},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const s=e(1),i=s.__importDefault(e(40)),u=s.__importDefault(e(51)),l=s.__importDefault(e(52)),o=e(60),r=s.__importDefault(e(62)),f=s.__importDefault(e(63)),d=s.__importDefault(e(47));function p(e,t){if(!(this instanceof p))return new p(e);t=t||function(e){if(e)throw e};var a=i.default(e);if("object"==typeof a){var s=p.projections.get(a.projName);if(s){if(a.datumCode&&"none"!==a.datumCode){var l=d.default(r.default,a.datumCode);l&&(a.datum_params=l.towgs84?l.towgs84.split(","):null,a.ellps=l.ellipse,a.datumName=l.datumName?l.datumName:a.datumCode)}a.k0=a.k0||1,a.axis=a.axis||"enu",a.ellps=a.ellps||"wgs84";var m=o.sphere(a.a,a.b,a.rf,a.ellps,a.sphere),n=o.eccentricity(m.a,m.b,m.rf,a.R_A),h=a.datum||f.default(a.datumCode,a.datum_params,m.a,m.b,n.es,n.ep2);u.default(this,a),u.default(this,s),this.a=m.a,this.b=m.b,this.rf=m.rf,this.sphere=m.sphere,this.es=n.es,this.e=n.e,this.ep2=n.ep2,this.datum=h,this.init(),t(null,this)}else t(e)}else t(e)}p.projections=l.default,p.projections.start(),a.default=p},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});const u=t(1),n=u.__importDefault(t(41)),f=u.__importDefault(t(48)),i=u.__importDefault(t(43)),a=u.__importDefault(t(47));var o=["PROJECTEDCRS","PROJCRS","GEOGCS","GEOCCS","PROJCS","LOCAL_CS","GEODCRS","GEODETICCRS","GEODETICDATUM","ENGCRS","ENGINEERINGCRS"];var l=["3857","900913","3785","102113"];r.default=function(t){if(!function(t){return"string"==typeof t}(t))return t;if(function(t){return t in n.default}(t))return n.default[t];if(function(t){return o.some((function(e){return t.indexOf(e)>-1}))}(t)){var e=f.default(t);if(function(t){var e=a.default(t,"authority");if(e){var r=a.default(e,"epsg");return r&&l.indexOf(r)>-1}}(e))return n.default["EPSG:3857"];var r=function(t){var e=a.default(t,"extension");if(e)return a.default(e,"proj4")}(e);return r?i.default(r):e}return function(t){return"+"===t[0]}(t)?i.default(t):void 0}},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});const i=t(1),n=i.__importDefault(t(42)),f=i.__importDefault(t(43)),a=i.__importDefault(t(48));function l(t){var e=this;if(2===arguments.length){var r=arguments[1];"string"==typeof r?"+"===r.charAt(0)?l[t]=f.default(arguments[1]):l[t]=a.default(arguments[1]):l[t]=r}else if(1===arguments.length){if(Array.isArray(t))return t.map((function(t){Array.isArray(t)?l.apply(e,t):l(t)}));if("string"==typeof t){if(t in l)return l[t]}else"EPSG"in t?l["EPSG:"+t.EPSG]=t:"ESRI"in t?l["ESRI:"+t.ESRI]=t:"IAU2000"in t?l["IAU2000:"+t.IAU2000]=t:console.log(t);return}}n.default(l),r.default=l},
function _(e,t,l){Object.defineProperty(l,"__esModule",{value:!0}),l.default=function(e){e("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),e("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),e("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"),e.WGS84=e["EPSG:4326"],e["EPSG:3785"]=e["EPSG:3857"],e.GOOGLE=e["EPSG:3857"],e["EPSG:900913"]=e["EPSG:3857"],e["EPSG:102113"]=e["EPSG:3857"]}},
function _(t,n,o){Object.defineProperty(o,"__esModule",{value:!0});const e=t(1),a=t(44),u=e.__importDefault(t(45)),r=e.__importDefault(t(46)),i=e.__importDefault(t(47));o.default=function(t){var n,o,e,f={},l=t.split("+").map((function(t){return t.trim()})).filter((function(t){return t})).reduce((function(t,n){var o=n.split("=");return o.push(!0),t[o[0].toLowerCase()]=o[1],t}),{}),c={proj:"projName",datum:"datumCode",rf:function(t){f.rf=parseFloat(t)},lat_0:function(t){f.lat0=t*a.D2R},lat_1:function(t){f.lat1=t*a.D2R},lat_2:function(t){f.lat2=t*a.D2R},lat_ts:function(t){f.lat_ts=t*a.D2R},lon_0:function(t){f.long0=t*a.D2R},lon_1:function(t){f.long1=t*a.D2R},lon_2:function(t){f.long2=t*a.D2R},alpha:function(t){f.alpha=parseFloat(t)*a.D2R},lonc:function(t){f.longc=t*a.D2R},x_0:function(t){f.x0=parseFloat(t)},y_0:function(t){f.y0=parseFloat(t)},k_0:function(t){f.k0=parseFloat(t)},k:function(t){f.k0=parseFloat(t)},a:function(t){f.a=parseFloat(t)},b:function(t){f.b=parseFloat(t)},r_a:function(){f.R_A=!0},zone:function(t){f.zone=parseInt(t,10)},south:function(){f.utmSouth=!0},towgs84:function(t){f.datum_params=t.split(",").map((function(t){return parseFloat(t)}))},to_meter:function(t){f.to_meter=parseFloat(t)},units:function(t){f.units=t;var n=i.default(r.default,t);n&&(f.to_meter=n.to_meter)},from_greenwich:function(t){f.from_greenwich=t*a.D2R},pm:function(t){var n=i.default(u.default,t);f.from_greenwich=(n||parseFloat(t))*a.D2R},nadgrids:function(t){"@null"===t?f.datumCode="none":f.nadgrids=t},axis:function(t){3===t.length&&-1!=="ewnsud".indexOf(t.substr(0,1))&&-1!=="ewnsud".indexOf(t.substr(1,1))&&-1!=="ewnsud".indexOf(t.substr(2,1))&&(f.axis=t)}};for(n in l)o=l[n],n in c?"function"==typeof(e=c[n])?e(o):f[e]=o:f[n]=o;return"string"==typeof f.datumCode&&"WGS84"!==f.datumCode&&(f.datumCode=f.datumCode.toLowerCase()),f}},
function _(P,_,e){Object.defineProperty(e,"__esModule",{value:!0}),e.PJD_3PARAM=1,e.PJD_7PARAM=2,e.PJD_WGS84=4,e.PJD_NODATUM=5,e.SEC_TO_RAD=484813681109536e-20,e.HALF_PI=Math.PI/2,e.SIXTH=.16666666666666666,e.RA4=.04722222222222222,e.RA6=.022156084656084655,e.EPSLN=1e-10,e.D2R=.017453292519943295,e.R2D=57.29577951308232,e.FORTPI=Math.PI/4,e.TWO_PI=2*Math.PI,e.SPI=3.14159265359},
function _(e,o,r){Object.defineProperty(r,"__esModule",{value:!0});var a={};r.default=a,a.greenwich=0,a.lisbon=-9.131906111111,a.paris=2.337229166667,a.bogota=-74.080916666667,a.madrid=-3.687938888889,a.rome=12.452333333333,a.bern=7.439583333333,a.jakarta=106.807719444444,a.ferro=-17.666666666667,a.brussels=4.367975,a.stockholm=18.058277777778,a.athens=23.7163375,a.oslo=10.722916666667},
function _(e,t,f){Object.defineProperty(f,"__esModule",{value:!0}),f.default={ft:{to_meter:.3048},"us-ft":{to_meter:1200/3937}}},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var o=/[\s_\-\/\(\)]/g;t.default=function(e,r){if(e[r])return e[r];for(var t,a=Object.keys(e),n=r.toLowerCase().replace(o,""),f=-1;++f<a.length;)if((t=a[f]).toLowerCase().replace(o,"")===n)return e[t]}},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const o=e(1);const d=o.__importDefault(e(49)),r=e(50);function n(e){return.017453292519943295*e}a.default=function(e){var t=d.default(e),a=t.shift(),o=t.shift();t.unshift(["name",o]),t.unshift(["type",a]);var l={};return r.sExpr(t,l),function(e){if("GEOGCS"===e.type?e.projName="longlat":"LOCAL_CS"===e.type?(e.projName="identity",e.local=!0):"object"==typeof e.PROJECTION?e.projName=Object.keys(e.PROJECTION)[0]:e.projName=e.PROJECTION,e.AXIS){for(var t="",a=0,o=e.AXIS.length;a<o;++a){var d=e.AXIS[a][0].toLowerCase();-1!==d.indexOf("north")?t+="n":-1!==d.indexOf("south")?t+="s":-1!==d.indexOf("east")?t+="e":-1!==d.indexOf("west")&&(t+="w")}2===t.length&&(t+="u"),3===t.length&&(e.axis=t)}e.UNIT&&(e.units=e.UNIT.name.toLowerCase(),"metre"===e.units&&(e.units="meter"),e.UNIT.convert&&("GEOGCS"===e.type?e.DATUM&&e.DATUM.SPHEROID&&(e.to_meter=e.UNIT.convert*e.DATUM.SPHEROID.a):e.to_meter=e.UNIT.convert));var r=e.GEOGCS;function l(t){return t*(e.to_meter||1)}"GEOGCS"===e.type&&(r=e),r&&(r.DATUM?e.datumCode=r.DATUM.name.toLowerCase():e.datumCode=r.name.toLowerCase(),"d_"===e.datumCode.slice(0,2)&&(e.datumCode=e.datumCode.slice(2)),"new_zealand_geodetic_datum_1949"!==e.datumCode&&"new_zealand_1949"!==e.datumCode||(e.datumCode="nzgd49"),"wgs_1984"!==e.datumCode&&"world_geodetic_system_1984"!==e.datumCode||("Mercator_Auxiliary_Sphere"===e.PROJECTION&&(e.sphere=!0),e.datumCode="wgs84"),"_ferro"===e.datumCode.slice(-6)&&(e.datumCode=e.datumCode.slice(0,-6)),"_jakarta"===e.datumCode.slice(-8)&&(e.datumCode=e.datumCode.slice(0,-8)),~e.datumCode.indexOf("belge")&&(e.datumCode="rnb72"),r.DATUM&&r.DATUM.SPHEROID&&(e.ellps=r.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),"international"===e.ellps.toLowerCase().slice(0,13)&&(e.ellps="intl"),e.a=r.DATUM.SPHEROID.a,e.rf=parseFloat(r.DATUM.SPHEROID.rf,10)),r.DATUM&&r.DATUM.TOWGS84&&(e.datum_params=r.DATUM.TOWGS84),~e.datumCode.indexOf("osgb_1936")&&(e.datumCode="osgb36"),~e.datumCode.indexOf("osni_1952")&&(e.datumCode="osni52"),(~e.datumCode.indexOf("tm65")||~e.datumCode.indexOf("geodetic_datum_of_1965"))&&(e.datumCode="ire65"),"ch1903+"===e.datumCode&&(e.datumCode="ch1903"),~e.datumCode.indexOf("israel")&&(e.datumCode="isr93")),e.b&&!isFinite(e.b)&&(e.b=e.a),[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_2","Standard_Parallel_2"],["false_easting","False_Easting"],["false_northing","False_Northing"],["central_meridian","Central_Meridian"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_Of_Center"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",n],["longitude_of_center","Longitude_Of_Center"],["longitude_of_center","Longitude_of_center"],["longc","longitude_of_center",n],["x0","false_easting",l],["y0","false_northing",l],["long0","central_meridian",n],["lat0","latitude_of_origin",n],["lat0","standard_parallel_1",n],["lat1","standard_parallel_1",n],["lat2","standard_parallel_2",n],["azimuth","Azimuth"],["alpha","azimuth",n],["srsCode","name"]].forEach((function(t){return a=e,d=(o=t)[0],r=o[1],void(!(d in a)&&r in a&&(a[d]=a[r],3===o.length&&(a[d]=o[2](a[d]))));var a,o,d,r})),e.long0||!e.longc||"Albers_Conic_Equal_Area"!==e.projName&&"Lambert_Azimuthal_Equal_Area"!==e.projName||(e.long0=e.longc),e.lat_ts||!e.lat1||"Stereographic_South_Pole"!==e.projName&&"Polar Stereographic (variant B)"!==e.projName||(e.lat0=n(e.lat1>0?90:-90),e.lat_ts=e.lat1)}(l),l}},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=function(t){return new a(t).output()};var i=/\s/,s=/[A-Za-z]/,h=/[A-Za-z84]/,o=/[,\]]/,n=/[\d\.E\-\+]/;function a(t){if("string"!=typeof t)throw new Error("not a string");this.text=t.trim(),this.level=0,this.place=0,this.root=null,this.stack=[],this.currentObject=null,this.state=1}a.prototype.readCharicter=function(){var t=this.text[this.place++];if(4!==this.state)for(;i.test(t);){if(this.place>=this.text.length)return;t=this.text[this.place++]}switch(this.state){case 1:return this.neutral(t);case 2:return this.keyword(t);case 4:return this.quoted(t);case 5:return this.afterquote(t);case 3:return this.number(t);case-1:return}},a.prototype.afterquote=function(t){if('"'===t)return this.word+='"',void(this.state=4);if(o.test(t))return this.word=this.word.trim(),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in afterquote yet, index '+this.place)},a.prototype.afterItem=function(t){return","===t?(null!==this.word&&this.currentObject.push(this.word),this.word=null,void(this.state=1)):"]"===t?(this.level--,null!==this.word&&(this.currentObject.push(this.word),this.word=null),this.state=1,this.currentObject=this.stack.pop(),void(this.currentObject||(this.state=-1))):void 0},a.prototype.number=function(t){if(!n.test(t)){if(o.test(t))return this.word=parseFloat(this.word),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in number yet, index '+this.place)}this.word+=t},a.prototype.quoted=function(t){'"'!==t?this.word+=t:this.state=5},a.prototype.keyword=function(t){if(h.test(t))this.word+=t;else{if("["===t){var e=[];return e.push(this.word),this.level++,null===this.root?this.root=e:this.currentObject.push(e),this.stack.push(this.currentObject),this.currentObject=e,void(this.state=1)}if(!o.test(t))throw new Error("havn't handled \""+t+'" in keyword yet, index '+this.place);this.afterItem(t)}},a.prototype.neutral=function(t){if(s.test(t))return this.word=t,void(this.state=2);if('"'===t)return this.word="",void(this.state=4);if(n.test(t))return this.word=t,void(this.state=3);if(!o.test(t))throw new Error("havn't handled \""+t+'" in neutral yet, index '+this.place);this.afterItem(t)},a.prototype.output=function(){for(;this.place<this.text.length;)this.readCharicter();if(-1===this.state)return this.root;throw new Error('unable to parse string "'+this.text+'". State is '+this.state)}},
function _(e,r,a){function s(e,r,a){Array.isArray(r)&&(a.unshift(r),r=null);var s=r?{}:e,n=a.reduce((function(e,r){return c(r,e),e}),s);r&&(e[r]=n)}function c(e,r){if(Array.isArray(e)){var a=e.shift();if("PARAMETER"===a&&(a=e.shift()),1===e.length)return Array.isArray(e[0])?(r[a]={},void c(e[0],r[a])):void(r[a]=e[0]);if(e.length)if("TOWGS84"!==a){if("AXIS"===a)return a in r||(r[a]=[]),void r[a].push(e);var n;switch(Array.isArray(a)||(r[a]={}),a){case"UNIT":case"PRIMEM":case"VERT_DATUM":return r[a]={name:e[0].toLowerCase(),convert:e[1]},void(3===e.length&&c(e[2],r[a]));case"SPHEROID":case"ELLIPSOID":return r[a]={name:e[0],a:e[1],rf:e[2]},void(4===e.length&&c(e[3],r[a]));case"PROJECTEDCRS":case"PROJCRS":case"GEOGCS":case"GEOCCS":case"PROJCS":case"LOCAL_CS":case"GEODCRS":case"GEODETICCRS":case"GEODETICDATUM":case"EDATUM":case"ENGINEERINGDATUM":case"VERT_CS":case"VERTCRS":case"VERTICALCRS":case"COMPD_CS":case"COMPOUNDCRS":case"ENGINEERINGCRS":case"ENGCRS":case"FITTED_CS":case"LOCAL_DATUM":case"DATUM":return e[0]=["name",e[0]],void s(r,a,e);default:for(n=-1;++n<e.length;)if(!Array.isArray(e[n]))return c(e,r[a]);return s(r,a,e)}}else r[a]=e;else r[a]=!0}else r[e]=!0}Object.defineProperty(a,"__esModule",{value:!0}),a.sExpr=c},
function _(e,n,r){Object.defineProperty(r,"__esModule",{value:!0}),r.default=function(e,n){var r,t;if(e=e||{},!n)return e;for(t in n)void 0!==(r=n[t])&&(e[t]=r);return e}},
function _(t,e,o){Object.defineProperty(o,"__esModule",{value:!0});const a=t(1),n=a.__importDefault(t(53)),r=a.__importDefault(t(59));var u=[n.default,r.default],f={},i=[];function d(t,e){var o=i.length;return t.names?(i[o]=t,t.names.forEach((function(t){f[t.toLowerCase()]=o})),this):(console.log(e),!0)}function c(t){if(!t)return!1;var e=t.toLowerCase();return void 0!==f[e]&&i[f[e]]?i[f[e]]:void 0}function l(){u.forEach(d)}o.add=d,o.get=c,o.start=l,o.default={start:l,add:d,get:c}},
function _(t,i,s){Object.defineProperty(s,"__esModule",{value:!0});const h=t(1),a=h.__importDefault(t(54)),e=h.__importDefault(t(55)),r=h.__importDefault(t(57)),n=h.__importDefault(t(58)),l=t(44);function u(){var t=this.b/this.a;this.es=1-t*t,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=a.default(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)}function o(t){var i,s,h=t.x,a=t.y;if(a*l.R2D>90&&a*l.R2D<-90&&h*l.R2D>180&&h*l.R2D<-180)return null;if(Math.abs(Math.abs(a)-l.HALF_PI)<=l.EPSLN)return null;if(this.sphere)i=this.x0+this.a*this.k0*e.default(h-this.long0),s=this.y0+this.a*this.k0*Math.log(Math.tan(l.FORTPI+.5*a));else{var n=Math.sin(a),u=r.default(this.e,a,n);i=this.x0+this.a*this.k0*e.default(h-this.long0),s=this.y0-this.a*this.k0*Math.log(u)}return t.x=i,t.y=s,t}function f(t){var i,s,h=t.x-this.x0,a=t.y-this.y0;if(this.sphere)s=l.HALF_PI-2*Math.atan(Math.exp(-a/(this.a*this.k0)));else{var r=Math.exp(-a/(this.a*this.k0));if(-9999===(s=n.default(this.e,r)))return null}return i=e.default(this.long0+h/(this.a*this.k0)),t.x=i,t.y=s,t}s.init=u,s.forward=o,s.inverse=f,s.names=["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","merc"],s.default={init:u,forward:o,inverse:f,names:s.names}},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(e,t,n){var r=e*t;return n/Math.sqrt(1-r*r)}},
function _(e,t,u){Object.defineProperty(u,"__esModule",{value:!0});const n=e(1),a=e(44),f=n.__importDefault(e(56));u.default=function(e){return Math.abs(e)<=a.SPI?e:e-f.default(e)*a.TWO_PI}},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e){return e<0?-1:1}},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});const a=t(44);n.default=function(t,e,n){var o=t*n,u=.5*t;return o=Math.pow((1-o)/(1+o),u),Math.tan(.5*(a.HALF_PI-e))/o}},
function _(t,a,e){Object.defineProperty(e,"__esModule",{value:!0});const n=t(44);e.default=function(t,a){for(var e,r,o=.5*t,u=n.HALF_PI-2*Math.atan(a),f=0;f<=15;f++)if(e=t*Math.sin(u),u+=r=n.HALF_PI-2*Math.atan(a*Math.pow((1-e)/(1+e),o))-u,Math.abs(r)<=1e-10)return u;return-9999}},
function _(e,n,i){function t(){}function r(e){return e}Object.defineProperty(i,"__esModule",{value:!0}),i.init=t,i.forward=r,i.inverse=r,i.names=["longlat","identity"],i.default={init:t,forward:r,inverse:r,names:i.names}},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const a=e(1),n=e(44),f=a.__importStar(e(61)),u=a.__importDefault(e(47));r.eccentricity=function(e,t,r,a){var f=e*e,u=t*t,i=(f-u)/f,c=0;return a?(f=(e*=1-i*(n.SIXTH+i*(n.RA4+i*n.RA6)))*e,i=0):c=Math.sqrt(i),{es:i,e:c,ep2:(f-u)/u}},r.sphere=function(e,t,r,a,i){if(!e){var c=u.default(f.default,a);c||(c=f.WGS84),e=c.a,t=c.b,r=c.rf}return r&&!t&&(t=(1-1/r)*e),(0===r||Math.abs(e-t)<n.EPSLN)&&(i=!0,t=e),{a:e,b:t,rf:r,sphere:i}}},
function _(e,a,l){Object.defineProperty(l,"__esModule",{value:!0});var s={};l.default=s,s.MERIT={a:6378137,rf:298.257,ellipseName:"MERIT 1983"},s.SGS85={a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},s.GRS80={a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},s.IAU76={a:6378140,rf:298.257,ellipseName:"IAU 1976"},s.airy={a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},s.APL4={a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},s.NWL9D={a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},s.mod_airy={a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},s.andrae={a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},s.aust_SA={a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},s.GRS67={a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},s.bessel={a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},s.bess_nam={a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},s.clrk66={a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},s.clrk80={a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},s.clrk58={a:6378293.645208759,rf:294.2606763692654,ellipseName:"Clarke 1858"},s.CPM={a:6375738.7,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},s.delmbr={a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},s.engelis={a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},s.evrst30={a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},s.evrst48={a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},s.evrst56={a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},s.evrst69={a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},s.evrstSS={a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},s.fschr60={a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},s.fschr60m={a:6378155,rf:298.3,ellipseName:"Fischer 1960"},s.fschr68={a:6378150,rf:298.3,ellipseName:"Fischer 1968"},s.helmert={a:6378200,rf:298.3,ellipseName:"Helmert 1906"},s.hough={a:6378270,rf:297,ellipseName:"Hough"},s.intl={a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},s.kaula={a:6378163,rf:298.24,ellipseName:"Kaula 1961"},s.lerch={a:6378139,rf:298.257,ellipseName:"Lerch 1979"},s.mprts={a:6397300,rf:191,ellipseName:"Maupertius 1738"},s.new_intl={a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},s.plessis={a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},s.krass={a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},s.SEasia={a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},s.walbeck={a:6376896,b:6355834.8467,ellipseName:"Walbeck"},s.WGS60={a:6378165,rf:298.3,ellipseName:"WGS 60"},s.WGS66={a:6378145,rf:298.25,ellipseName:"WGS 66"},s.WGS7={a:6378135,rf:298.26,ellipseName:"WGS 72"},l.WGS84=s.WGS84={a:6378137,rf:298.257223563,ellipseName:"WGS 84"},s.sphere={a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"}},
function _(e,a,s){Object.defineProperty(s,"__esModule",{value:!0});var t={};s.default=t,t.wgs84={towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},t.ch1903={towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},t.ggrs87={towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},t.nad83={towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},t.nad27={nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},t.potsdam={towgs84:"606.0,23.0,413.0",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},t.carthage={towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},t.hermannskogel={towgs84:"653.0,-212.0,449.0",ellipse:"bessel",datumName:"Hermannskogel"},t.osni52={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"airy",datumName:"Irish National"},t.ire65={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},t.rassadiran={towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},t.nzgd49={towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},t.osgb36={towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"},t.s_jtsk={towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},t.beduaram={towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},t.gunung_segara={towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},t.rnb72={towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"}},
function _(a,m,_){Object.defineProperty(_,"__esModule",{value:!0});const t=a(44);_.default=function(a,m,_,u,d,p){var r={};return r.datum_type=void 0===a||"none"===a?t.PJD_NODATUM:t.PJD_WGS84,m&&(r.datum_params=m.map(parseFloat),0===r.datum_params[0]&&0===r.datum_params[1]&&0===r.datum_params[2]||(r.datum_type=t.PJD_3PARAM),r.datum_params.length>3&&(0===r.datum_params[3]&&0===r.datum_params[4]&&0===r.datum_params[5]&&0===r.datum_params[6]||(r.datum_type=t.PJD_7PARAM,r.datum_params[3]*=t.SEC_TO_RAD,r.datum_params[4]*=t.SEC_TO_RAD,r.datum_params[5]*=t.SEC_TO_RAD,r.datum_params[6]=r.datum_params[6]/1e6+1))),r.a=_,r.b=u,r.es=d,r.ep2=p,r}},
function _(t,e,a){Object.defineProperty(a,"__esModule",{value:!0});const r=t(1),u=t(44),m=r.__importDefault(t(65)),_=r.__importDefault(t(67)),o=r.__importDefault(t(39)),d=r.__importDefault(t(68)),f=r.__importDefault(t(69));a.default=function t(e,a,r){var n;if(Array.isArray(r)&&(r=d.default(r)),f.default(r),e.datum&&a.datum&&function(t,e){return(t.datum.datum_type===u.PJD_3PARAM||t.datum.datum_type===u.PJD_7PARAM)&&"WGS84"!==e.datumCode||(e.datum.datum_type===u.PJD_3PARAM||e.datum.datum_type===u.PJD_7PARAM)&&"WGS84"!==t.datumCode}(e,a)&&(r=t(e,n=new o.default("WGS84"),r),e=n),"enu"!==e.axis&&(r=_.default(e,!1,r)),"longlat"===e.projName)r={x:r.x*u.D2R,y:r.y*u.D2R,z:r.z||0};else if(e.to_meter&&(r={x:r.x*e.to_meter,y:r.y*e.to_meter,z:r.z||0}),!(r=e.inverse(r)))return;return e.from_greenwich&&(r.x+=e.from_greenwich),r=m.default(e.datum,a.datum,r),a.from_greenwich&&(r={x:r.x-a.from_greenwich,y:r.y,z:r.z||0}),"longlat"===a.projName?r={x:r.x*u.R2D,y:r.y*u.R2D,z:r.z||0}:(r=a.forward(r),a.to_meter&&(r={x:r.x/a.to_meter,y:r.y/a.to_meter,z:r.z||0})),"enu"!==a.axis?_.default(a,!0,r):r}},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const u=e(44),o=e(66);function _(e){return e===u.PJD_3PARAM||e===u.PJD_7PARAM}a.default=function(e,t,a){return o.compareDatums(e,t)||e.datum_type===u.PJD_NODATUM||t.datum_type===u.PJD_NODATUM?a:e.es!==t.es||e.a!==t.a||_(e.datum_type)||_(t.datum_type)?(a=o.geodeticToGeocentric(a,e.es,e.a),_(e.datum_type)&&(a=o.geocentricToWgs84(a,e.datum_type,e.datum_params)),_(t.datum_type)&&(a=o.geocentricFromWgs84(a,t.datum_type,t.datum_params)),o.geocentricToGeodetic(a,t.es,t.a,t.b)):a}},
function _(a,t,r){Object.defineProperty(r,"__esModule",{value:!0});const e=a(44);r.compareDatums=function(a,t){return a.datum_type===t.datum_type&&(!(a.a!==t.a||Math.abs(a.es-t.es)>5e-11)&&(a.datum_type===e.PJD_3PARAM?a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]:a.datum_type!==e.PJD_7PARAM||a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]&&a.datum_params[3]===t.datum_params[3]&&a.datum_params[4]===t.datum_params[4]&&a.datum_params[5]===t.datum_params[5]&&a.datum_params[6]===t.datum_params[6]))},r.geodeticToGeocentric=function(a,t,r){var m,u,s,_,n=a.x,d=a.y,i=a.z?a.z:0;if(d<-e.HALF_PI&&d>-1.001*e.HALF_PI)d=-e.HALF_PI;else if(d>e.HALF_PI&&d<1.001*e.HALF_PI)d=e.HALF_PI;else{if(d<-e.HALF_PI)return{x:-1/0,y:-1/0,z:a.z};if(d>e.HALF_PI)return{x:1/0,y:1/0,z:a.z}}return n>Math.PI&&(n-=2*Math.PI),u=Math.sin(d),_=Math.cos(d),s=u*u,{x:((m=r/Math.sqrt(1-t*s))+i)*_*Math.cos(n),y:(m+i)*_*Math.sin(n),z:(m*(1-t)+i)*u}},r.geocentricToGeodetic=function(a,t,r,m){var u,s,_,n,d,i,p,P,o,y,M,z,c,A,x,f=a.x,h=a.y,I=a.z?a.z:0;if(u=Math.sqrt(f*f+h*h),s=Math.sqrt(f*f+h*h+I*I),u/r<1e-12){if(A=0,s/r<1e-12)return e.HALF_PI,x=-m,{x:a.x,y:a.y,z:a.z}}else A=Math.atan2(h,f);_=I/s,P=(n=u/s)*(1-t)*(d=1/Math.sqrt(1-t*(2-t)*n*n)),o=_*d,c=0;do{c++,i=t*(p=r/Math.sqrt(1-t*o*o))/(p+(x=u*P+I*o-p*(1-t*o*o))),z=(M=_*(d=1/Math.sqrt(1-i*(2-i)*n*n)))*P-(y=n*(1-i)*d)*o,P=y,o=M}while(z*z>1e-24&&c<30);return{x:A,y:Math.atan(M/Math.abs(y)),z:x}},r.geocentricToWgs84=function(a,t,r){if(t===e.PJD_3PARAM)return{x:a.x+r[0],y:a.y+r[1],z:a.z+r[2]};if(t===e.PJD_7PARAM){var m=r[0],u=r[1],s=r[2],_=r[3],n=r[4],d=r[5],i=r[6];return{x:i*(a.x-d*a.y+n*a.z)+m,y:i*(d*a.x+a.y-_*a.z)+u,z:i*(-n*a.x+_*a.y+a.z)+s}}},r.geocentricFromWgs84=function(a,t,r){if(t===e.PJD_3PARAM)return{x:a.x-r[0],y:a.y-r[1],z:a.z-r[2]};if(t===e.PJD_7PARAM){var m=r[0],u=r[1],s=r[2],_=r[3],n=r[4],d=r[5],i=r[6],p=(a.x-m)/i,P=(a.y-u)/i,o=(a.z-s)/i;return{x:p+d*P-n*o,y:-d*p+P+_*o,z:n*p-_*P+o}}}},
function _(e,a,i){Object.defineProperty(i,"__esModule",{value:!0}),i.default=function(e,a,i){var s,n,r,c=i.x,d=i.y,u=i.z||0,f={};for(r=0;r<3;r++)if(!a||2!==r||void 0!==i.z)switch(0===r?(s=c,n=-1!=="ew".indexOf(e.axis[r])?"x":"y"):1===r?(s=d,n=-1!=="ns".indexOf(e.axis[r])?"y":"x"):(s=u,n="z"),e.axis[r]){case"e":case"w":case"n":case"s":f[n]=s;break;case"u":void 0!==i[n]&&(f.z=s);break;case"d":void 0!==i[n]&&(f.z=-s);break;default:return null}return f}},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e){var n={x:e[0],y:e[1]};return e.length>2&&(n.z=e[2]),e.length>3&&(n.m=e[3]),n}},
function _(e,i,n){function t(e){if("function"==typeof Number.isFinite){if(Number.isFinite(e))return;throw new TypeError("coordinates must be finite numbers")}if("number"!=typeof e||e!=e||!isFinite(e))throw new TypeError("coordinates must be finite numbers")}Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(e){t(e.x),t(e.y)}},
function _(e,i,t){Object.defineProperty(t,"__esModule",{value:!0});const n=e(1),r=e(71),s=n.__importStar(e(74)),_=n.__importStar(e(18)),a=e(81),o=e(82);class l extends r.View{get coordinates(){return this._coordinates}initialize(){super.initialize(),this.visuals=new s.Visuals(this.model),this.needs_webgl_blit=!1,this._initialize_coordinates()}connect_signals(){super.connect_signals();const{x_range_name:e,y_range_name:i}=this.model.properties;this.on_change([e,i],()=>this._initialize_coordinates())}_initialize_coordinates(){const{x_range_name:e,y_range_name:i}=this.model,{frame:t}=this.plot_view,n=t.x_scales.get(e),r=t.y_scales.get(i);this._coordinates=new o.CoordinateTransform(n,r)}get plot_view(){return this.parent}get plot_model(){return this.parent.model}get layer(){const{overlays:e,primary:i}=this.plot_view.canvas_view;return"overlay"==this.model.level?e:i}request_render(){this.plot_view.request_render()}notify_finished(){this.plot_view.notify_finished()}get needs_clip(){return!1}get has_webgl(){return!1}render(){this.model.visible&&this._render(),this._has_finished=!0}}t.RendererView=l,l.__name__="RendererView";class d extends a.Model{constructor(e){super(e)}static init_Renderer(){this.define({level:[_.RenderLevel],visible:[_.Boolean,!0],x_range_name:[_.String,"default"],y_range_name:[_.String,"default"]})}}t.Renderer=d,d.__name__="Renderer",d.init_Renderer()},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const i=t(1),r=t(15),n=t(72),o=t(8),h=i.__importDefault(t(73));class a{constructor(t){if(this.removed=new r.Signal0(this,"removed"),this._ready=Promise.resolve(void 0),null==t.model)throw new Error("model of a view wasn't configured");this.model=t.model,this._parent=t.parent}get ready(){return this._ready}connect(t,e){return t.connect((t,s)=>{const i=Promise.resolve(e.call(this,t,s));this._ready=this._ready.then(()=>i)},this)}disconnect(t,e){return t.disconnect(e,this)}initialize(){this._has_finished=!1,this.is_root&&(this._stylesheet=n.stylesheet);for(const t of this.styles())this.stylesheet.append(t)}async lazy_initialize(){}remove(){this._parent=void 0,this.disconnect_signals(),this.removed.emit()}toString(){return`${this.model.type}View(${this.model.id})`}serializable_state(){return{type:this.model.type}}get parent(){if(void 0!==this._parent)return this._parent;throw new Error("parent of a view wasn't configured")}get is_root(){return null===this.parent}get root(){return this.is_root?this:this.parent.root}assert_root(){if(!this.is_root)throw new Error(this.toString()+" is not a root layout")}has_finished(){return this._has_finished}get is_idle(){return this.has_finished()}connect_signals(){}disconnect_signals(){r.Signal.disconnectReceiver(this)}on_change(t,e){for(const s of o.isArray(t)?t:[t])this.connect(s.change,e)}cursor(t,e){return null}get stylesheet(){return this.is_root?this._stylesheet:this.root.stylesheet}styles(){return[h.default]}}s.View=a,a.__name__="View"},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});const i=t(8),o=t(13),s=t=>(e={},...n)=>{const s=document.createElement(t);s.classList.add("bk");for(let[t,n]of o.entries(e))if(null!=n&&(!i.isBoolean(n)||n))if("class"===t&&(i.isString(n)&&(n=n.split(/\s+/)),i.isArray(n)))for(const t of n)null!=t&&s.classList.add(t);else if("style"===t&&i.isPlainObject(n))for(const[t,e]of o.entries(n))s.style[t]=e;else if("data"===t&&i.isPlainObject(n))for(const[t,e]of o.entries(n))s.dataset[t]=e;else s.setAttribute(t,n);function l(t){if(i.isString(t))s.appendChild(document.createTextNode(t));else if(t instanceof Node)s.appendChild(t);else if(t instanceof NodeList||t instanceof HTMLCollection)for(const e of t)s.appendChild(e);else if(null!=t&&!1!==t)throw new Error("expected a DOM element, string, false or null, got "+JSON.stringify(t))}for(const t of n)if(i.isArray(t))for(const e of t)l(e);else l(t);return s};function l(t){const e=t.parentNode;null!=e&&e.removeChild(t)}function r(t,...e){const n=t.firstChild;for(const i of e)t.insertBefore(i,n)}function a(t,e){const n=Element.prototype;return(n.matches||n.webkitMatchesSelector||n.mozMatchesSelector||n.msMatchesSelector).call(t,e)}function c(t){return parseFloat(t)||0}function h(t){const e=getComputedStyle(t);return{border:{top:c(e.borderTopWidth),bottom:c(e.borderBottomWidth),left:c(e.borderLeftWidth),right:c(e.borderRightWidth)},margin:{top:c(e.marginTop),bottom:c(e.marginBottom),left:c(e.marginLeft),right:c(e.marginRight)},padding:{top:c(e.paddingTop),bottom:c(e.paddingBottom),left:c(e.paddingLeft),right:c(e.paddingRight)}}}function d(t){const e=t.getBoundingClientRect();return{width:Math.ceil(e.width),height:Math.ceil(e.height)}}n.createElement=function(t,e,...n){return s(t)(e,...n)},n.div=s("div"),n.span=s("span"),n.canvas=s("canvas"),n.link=s("link"),n.style=s("style"),n.a=s("a"),n.p=s("p"),n.i=s("i"),n.pre=s("pre"),n.button=s("button"),n.label=s("label"),n.input=s("input"),n.select=s("select"),n.option=s("option"),n.optgroup=s("optgroup"),n.textarea=s("textarea"),n.nbsp=function(){return document.createTextNode(" ")},n.append=function(t,...e){for(const n of e)t.appendChild(n)},n.remove=l,n.removeElement=l,n.replaceWith=function(t,e){const n=t.parentNode;null!=n&&n.replaceChild(e,t)},n.prepend=r,n.empty=function(t,e=!1){let n;for(;n=t.firstChild;)t.removeChild(n);if(e&&t instanceof Element)for(const e of t.attributes)t.removeAttributeNode(e)},n.display=function(t){t.style.display=""},n.undisplay=function(t){t.style.display="none"},n.show=function(t){t.style.visibility=""},n.hide=function(t){t.style.visibility="hidden"},n.offset=function(t){const e=t.getBoundingClientRect();return{top:e.top+window.pageYOffset-document.documentElement.clientTop,left:e.left+window.pageXOffset-document.documentElement.clientLeft}},n.matches=a,n.parent=function(t,e){let n=t;for(;n=n.parentElement;)if(a(n,e))return n;return null},n.extents=h,n.size=d,n.scroll_size=function(t){return{width:Math.ceil(t.scrollWidth),height:Math.ceil(t.scrollHeight)}},n.outer_size=function(t){const{margin:{left:e,right:n,top:i,bottom:o}}=h(t),{width:s,height:l}=d(t);return{width:Math.ceil(s+e+n),height:Math.ceil(l+i+o)}},n.content_size=function(t){const{left:e,top:n}=t.getBoundingClientRect(),{padding:i}=h(t);let o=0,s=0;for(const l of t.children){const t=l.getBoundingClientRect();o=Math.max(o,Math.ceil(t.left-e-i.left+t.width)),s=Math.max(s,Math.ceil(t.top-n-i.top+t.height))}return{width:o,height:s}},n.position=function(t,e,n){const{style:i}=t;if(i.left=e.x+"px",i.top=e.y+"px",i.width=e.width+"px",i.height=e.height+"px",null==n)i.margin="";else{const{top:t,right:e,bottom:o,left:s}=n;i.margin=`${t}px ${e}px ${o}px ${s}px`}},n.children=function(t){return Array.from(t.children)};class f{constructor(t){this.el=t,this.classList=t.classList}get values(){const t=[];for(let e=0;e<this.classList.length;e++){const n=this.classList.item(e);null!=n&&t.push(n)}return t}has(t){return this.classList.contains(t)}add(...t){for(const e of t)this.classList.add(e);return this}remove(...t){for(const e of t)this.classList.remove(e);return this}clear(){for(const t of this.values)"bk"!=t&&this.classList.remove(t);return this}toggle(t,e){return(null!=e?e:!this.has(t))?this.add(t):this.remove(t),this}}var u;function p(t,e,n){const{width:i,height:o,position:s,display:l}=t.style;t.style.position="absolute",t.style.display="",t.style.width=null!=e.width&&e.width!=1/0?e.width+"px":"auto",t.style.height=null!=e.height&&e.height!=1/0?e.height+"px":"auto";try{return n()}finally{t.style.position=s,t.style.display=l,t.style.width=i,t.style.height=o}}n.ClassList=f,f.__name__="ClassList",n.classes=function(t){return new f(t)},n.toggle_attribute=function(t,e,n){null==n&&(n=!t.hasAttribute(e)),n?t.setAttribute(e,"true"):t.removeAttribute(e)},(u=n.Keys||(n.Keys={}))[u.Backspace=8]="Backspace",u[u.Tab=9]="Tab",u[u.Enter=13]="Enter",u[u.Esc=27]="Esc",u[u.PageUp=33]="PageUp",u[u.PageDown=34]="PageDown",u[u.Left=37]="Left",u[u.Up=38]="Up",u[u.Right=39]="Right",u[u.Down=40]="Down",u[u.Delete=46]="Delete",n.undisplayed=function(t,e){const{display:n}=t.style;t.style.display="none";try{return e()}finally{t.style.display=n}},n.unsized=function(t,e){return p(t,{},e)},n.sized=p;class g{constructor(t){this.root=t,this.known=new Set,this.style=n.style({type:"text/css"}),r(t,this.style)}append(t){this.known.has(t)||(this.style.appendChild(document.createTextNode(t)),this.known.add(t))}}n.StyleSheet=g,g.__name__="StyleSheet",n.stylesheet=new g(document.head)},
function _(n,o,e){Object.defineProperty(e,"__esModule",{value:!0});e.default="\n.bk-root {\n  position: relative;\n  width: auto;\n  height: auto;\n  z-index: 0;\n  box-sizing: border-box;\n  font-family: Helvetica, Arial, sans-serif;\n  font-size: 13px;\n}\n.bk-root .bk,\n.bk-root .bk:before,\n.bk-root .bk:after {\n  box-sizing: inherit;\n  margin: 0;\n  border: 0;\n  padding: 0;\n  background-image: none;\n  font-family: inherit;\n  font-size: 100%;\n  line-height: 1.42857143;\n}\n.bk-root pre.bk {\n  font-family: Courier, monospace;\n}\n"},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const s=e(1),l=s.__importStar(e(28)),c=s.__importStar(e(18)),i=e(22),o=e(8),r=e(75),h=e(77);function n(e,t){const[a,s,l,c]=o.isString(e)?i.color2rgba(e):i.decode_rgba(e);return`rgba(${255*a}, ${255*s}, ${255*l}, ${1==c?t:c})`}function _(e,t,a){e.moveTo(0,a+.5),e.lineTo(t,a+.5),e.stroke()}function u(e,t,a){e.moveTo(a+.5,0),e.lineTo(a+.5,t),e.stroke()}function v(e,t){e.moveTo(0,t),e.lineTo(t,0),e.stroke(),e.moveTo(0,0),e.lineTo(t,t),e.stroke()}a.hatch_aliases={" ":"blank",".":"dot",o:"ring","-":"horizontal_line","|":"vertical_line","+":"cross",'"':"horizontal_dash",":":"vertical_dash","@":"spiral","/":"right_diagonal_line","\\":"left_diagonal_line",x:"diagonal_cross",",":"right_diagonal_dash","`":"left_diagonal_dash",v:"horizontal_wave",">":"vertical_wave","*":"criss_cross"};class p{constructor(e,t=""){this.obj=e,this.prefix=t,this.cache={};for(const a of this.attrs)this[a]=e.properties[t+a]}warm_cache(e,t){for(const a of this.attrs){const s=this.obj.properties[this.prefix+a];if(void 0!==s.spec.value)this.cache[a]=s.spec.value;else{if(!(null!=e&&s instanceof c.VectorSpec))throw new Error("source is required with a vectorized visual property");{const l=s.array(e),c=null!=t?t.select(l):l;this.cache[a+"_array"]=c}}}}cache_select(e,t){const a=this.obj.properties[this.prefix+e];let s;return void 0!==a.spec.value?this.cache[e]=s=a.spec.value:this.cache[e]=s=this.cache[e+"_array"][t],s}get_array(e){return this.cache[e+"_array"]}set_vectorize(e,t){this._set_vectorize(e,t)}}a.ContextProperties=p,p.__name__="ContextProperties";class f extends p{set_value(e){const t=this.line_color.value(),a=this.line_alpha.value();e.strokeStyle=n(t,a),e.lineWidth=this.line_width.value(),e.lineJoin=this.line_join.value(),e.lineCap=this.line_cap.value(),e.lineDash=this.line_dash.value(),e.lineDashOffset=this.line_dash_offset.value()}get doit(){return!(null===this.line_color.spec.value||0==this.line_alpha.spec.value||0==this.line_width.spec.value)}_set_vectorize(e,t){const a=this.cache_select("line_color",t),s=this.cache_select("line_alpha",t),l=this.cache_select("line_width",t),c=this.cache_select("line_join",t),i=this.cache_select("line_cap",t),o=this.cache_select("line_dash",t),r=this.cache_select("line_dash_offset",t);e.strokeStyle=n(a,s),e.lineWidth=l,e.lineJoin=c,e.lineCap=i,e.lineDash=o,e.lineDashOffset=r}color_value(){return n(this.line_color.value(),this.line_alpha.value())}}a.Line=f,f.__name__="Line",f.prototype.attrs=Object.keys(l.LineVector);class d extends p{set_value(e){const t=this.fill_color.value(),a=this.fill_alpha.value();e.fillStyle=n(t,a)}get doit(){return!(null===this.fill_color.spec.value||0==this.fill_alpha.spec.value)}_set_vectorize(e,t){const a=this.cache_select("fill_color",t),s=this.cache_select("fill_alpha",t);e.fillStyle=n(a,s)}color_value(){return n(this.fill_color.value(),this.fill_alpha.value())}}a.Fill=d,d.__name__="Fill",d.prototype.attrs=Object.keys(l.FillVector);class k extends p{cache_select(e,t){let s;if("pattern"==e){const e=this.cache_select("hatch_color",t),s=this.cache_select("hatch_alpha",t),l=this.cache_select("hatch_scale",t),c=this.cache_select("hatch_pattern",t),i=this.cache_select("hatch_weight",t),{hatch_extra:o}=this.cache;if(null!=o&&o.hasOwnProperty(c)){const t=o[c];this.cache.pattern=t.get_pattern(e,s,l,i)}else this.cache.pattern=t=>{const o=t instanceof r.SVGRenderingContext2D?"svg":"canvas",p=new h.CanvasLayer(o,!0);return p.resize(l,l),p.prepare(),function(e,t,s,l,c,i){var o;const r=c,h=r/2,p=h/2;switch(e.strokeStyle=n(s,l),e.lineCap="square",e.fillStyle=s,e.lineWidth=i,null!==(o=a.hatch_aliases[t])&&void 0!==o?o:t){case"blank":break;case"dot":e.arc(h,h,h/2,0,2*Math.PI,!0),e.fill();break;case"ring":e.arc(h,h,h/2,0,2*Math.PI,!0),e.stroke();break;case"horizontal_line":_(e,r,h);break;case"vertical_line":u(e,r,h);break;case"cross":_(e,r,h),u(e,r,h);break;case"horizontal_dash":_(e,h,h);break;case"vertical_dash":u(e,h,h);break;case"spiral":{const t=r/30;e.moveTo(h,h);for(let a=0;a<360;a++){const s=.1*a,l=h+t*s*Math.cos(s),c=h+t*s*Math.sin(s);e.lineTo(l,c)}e.stroke();break}case"right_diagonal_line":e.moveTo(.5-p,r),e.lineTo(p+.5,0),e.stroke(),e.moveTo(p+.5,r),e.lineTo(3*p+.5,0),e.stroke(),e.moveTo(3*p+.5,r),e.lineTo(5*p+.5,0),e.stroke(),e.stroke();break;case"left_diagonal_line":e.moveTo(p+.5,r),e.lineTo(.5-p,0),e.stroke(),e.moveTo(3*p+.5,r),e.lineTo(p+.5,0),e.stroke(),e.moveTo(5*p+.5,r),e.lineTo(3*p+.5,0),e.stroke(),e.stroke();break;case"diagonal_cross":v(e,r);break;case"right_diagonal_dash":e.moveTo(p+.5,3*p+.5),e.lineTo(3*p+.5,p+.5),e.stroke();break;case"left_diagonal_dash":e.moveTo(p+.5,p+.5),e.lineTo(3*p+.5,3*p+.5),e.stroke();break;case"horizontal_wave":e.moveTo(0,p),e.lineTo(h,3*p),e.lineTo(r,p),e.stroke();break;case"vertical_wave":e.moveTo(p,0),e.lineTo(3*p,h),e.lineTo(p,r),e.stroke();break;case"criss_cross":v(e,r),_(e,r,h),u(e,r,h)}}(p.ctx,c,e,s,l,i),t.createPattern(p.canvas,"repeat")}}else s=super.cache_select(e,t);return s}_try_defer(e){const{hatch_pattern:t,hatch_extra:a}=this.cache;if(null!=a&&a.hasOwnProperty(t)){a[t].onload(e)}}get doit(){return!(null===this.hatch_color.spec.value||0==this.hatch_alpha.spec.value||" "==this.hatch_pattern.spec.value||"blank"==this.hatch_pattern.spec.value||null===this.hatch_pattern.spec.value)}doit2(e,t,a,s){if(!this.doit)return;this.cache_select("pattern",t);null==this.cache.pattern(e)?this._try_defer(s):(this.set_vectorize(e,t),a())}_set_vectorize(e,t){this.cache_select("pattern",t),e.fillStyle=this.cache.pattern(e)}color_value(){return n(this.hatch_color.value(),this.hatch_alpha.value())}}a.Hatch=k,k.__name__="Hatch",k.prototype.attrs=Object.keys(l.HatchVector);class x extends p{color_value(){return n(this.text_color.value(),this.text_alpha.value())}font_value(){const e=this.text_font.value(),t=this.text_font_size.value();return`${this.text_font_style.value()} ${t} ${e}`}v_font_value(e){super.cache_select("text_font_style",e),super.cache_select("text_font_size",e),super.cache_select("text_font",e);const{text_font_style:t,text_font_size:a,text_font:s}=this.cache;return`${t} ${a} ${s}`}cache_select(e,t){let a;return"font"==e?this.cache.font=a=this.v_font_value(t):a=super.cache_select(e,t),a}set_value(e){const t=this.text_color.value(),a=this.text_alpha.value();e.fillStyle=n(t,a),e.font=this.font_value(),e.textAlign=this.text_align.value(),e.textBaseline=this.text_baseline.value()}get doit(){return!(null===this.text_color.spec.value||0==this.text_alpha.spec.value)}_set_vectorize(e,t){const a=this.cache_select("text_color",t),s=this.cache_select("text_alpha",t),l=this.cache_select("font",t),c=this.cache_select("text_align",t),i=this.cache_select("text_baseline",t);e.fillStyle=n(a,s),e.font=l,e.textAlign=c,e.textBaseline=i}}a.Text=x,x.__name__="Text",x.prototype.attrs=Object.keys(l.TextVector);class b{constructor(e){for(const t of e._mixins){const[a,s=""]=t.split(":");let l;switch(a){case"line":l=f;break;case"fill":l=d;break;case"hatch":l=k;break;case"text":l=x;break;default:throw new Error("unknown visual: "+a)}this[s+a]=new l(e,s)}}warm_cache(e,t){for(const a in this)if(this.hasOwnProperty(a)){const s=this[a];s instanceof p&&s.warm_cache(e,t)}}}a.Visuals=b,b.__name__="Visuals"},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const s=t(76),n=t(8),r=t(72);function a(t){if(!t)throw new Error("cannot create a random attribute name for an undefined object");const e="ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";let i="";do{i="";for(let t=0;t<12;t++)i+=e[Math.floor(Math.random()*e.length)]}while(t[i]);return i}function o(t){const e={left:"start",right:"end",center:"middle",start:"start",end:"end"};return e[t]||e.start}function l(t){const e={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return e[t]||e.alphabetic}const h=function(t,e){const i=new Map,s=t.split(",");e=e||10;for(let t=0;t<s.length;t+=2){const n="&"+s[t+1]+";",r=parseInt(s[t],e);i.set(n,"&#"+r+";")}return i.set("\\xa0","&#160;"),i}("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32),c={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"}};class _{constructor(t,e){this.__root=t,this.__ctx=e}addColorStop(t,e){const i=this.__ctx.__createElement("stop");if(i.setAttribute("offset",""+t),-1!==e.indexOf("rgba")){const t=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(e),[,s,n,r,a]=t;i.setAttribute("stop-color",`rgb(${s},${n},${r})`),i.setAttribute("stop-opacity",a)}else i.setAttribute("stop-color",e);this.__root.appendChild(i)}}_.__name__="CanvasGradient";class u{constructor(t,e){this.__root=t,this.__ctx=e}}u.__name__="CanvasPattern";class p{constructor(t){var e,i,n;this.__currentPosition=null,this.__currentElementsToStyle=null,this._transform=new s.AffineTransform,this._clip_path=null,this.__document=null!==(e=null==t?void 0:t.document)&&void 0!==e?e:document,(null==t?void 0:t.ctx)?this.__ctx=t.ctx:(this.__canvas=this.__document.createElement("canvas"),this.__ctx=this.__canvas.getContext("2d")),this.__setDefaultStyles(),this.__stack=[],this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg"),this.__root.setAttribute("version","1.1"),this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg"),this.__root.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink"),this.width=null!==(i=null==t?void 0:t.width)&&void 0!==i?i:500,this.height=null!==(n=null==t?void 0:t.height)&&void 0!==n?n:500,this.__ids={},this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs"),this.__root.appendChild(this.__defs)}get canvas(){return this}get width(){return this._width}set width(t){this._width=t,this.__root.setAttribute("width",""+t)}get height(){return this._height}set height(t){this._height=t,this.__root.setAttribute("height",""+t)}__createElement(t,e={},i=!1){const s=this.__document.createElementNS("http://www.w3.org/2000/svg",t);i&&(s.setAttribute("fill","none"),s.setAttribute("stroke","none"));const n=Object.keys(e);for(const t of n)s.setAttribute(t,""+e[t]);return s}__setDefaultStyles(){const t=Object.keys(c),e=this;for(let i=0;i<t.length;i++){const s=t[i];e[s]=c[s].canvas}}__applyStyleState(t){const e=Object.keys(t),i=this;for(let s=0;s<e.length;s++){const n=e[s];i[n]=t[n]}}__getStyleState(){const t=Object.keys(c),e={};for(let i=0;i<t.length;i++){const s=t[i];e[s]=this[s]}return e}__applyStyleToCurrentElement(t){let e=this.__currentElement;const i=this.__currentElementsToStyle;if(null!=i){e.setAttribute(t,""),e=i.element;for(const e of i.children)e.setAttribute(t,"")}const s=Object.keys(c);for(let i=0;i<s.length;i++){const r=c[s[i]],a=this[s[i]];if(r.apply)if(a instanceof u){for(const t of[...a.__ctx.__defs.childNodes])if(t instanceof Element){const e=t.getAttribute("id");this.__ids[e]=e,this.__defs.appendChild(t)}const t=a.__root.getAttribute("id");e.setAttribute(r.apply,`url(#${t})`)}else if(a instanceof _){const t=a.__root.getAttribute("id");e.setAttribute(r.apply,`url(#${t})`)}else if(-1!==r.apply.indexOf(t)&&r.svg!==a)if("stroke"!==r.svgAttr&&"fill"!==r.svgAttr||!n.isString(a)||-1===a.indexOf("rgba")){let n=r.svgAttr;if("globalAlpha"===s[i]&&(n=t+"-"+r.svgAttr,e.getAttribute(n)))continue;e.setAttribute(n,""+a)}else{const t=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(a),[,i,s,n,o]=t;e.setAttribute(r.svgAttr,`rgb(${i},${s},${n})`);let l=parseFloat(o);const h=this.globalAlpha;null!=h&&(l*=h),e.setAttribute(r.svgAttr+"-opacity",""+l)}}}get_serialized_svg(t=!1){let e=(new XMLSerializer).serializeToString(this.__root);if(/xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi.test(e)&&(e=e.replace('xmlns="http://www.w3.org/2000/svg','xmlns:xlink="http://www.w3.org/1999/xlink')),t)for(const[t,i]of h){const s=new RegExp(t,"gi");s.test(e)&&(e=e.replace(s,i))}return e}get_svg(){return this.__root}save(){this.__stack.push({transform:this._transform,clip_path:this._clip_path,attributes:this.__getStyleState()}),this._transform=this._transform.clone()}restore(){if(0==this.__stack.length)return;const{transform:t,clip_path:e,attributes:i}=this.__stack.pop();this._transform=t,this._clip_path=e,this.__applyStyleState(i)}_apply_transform(t,e=this._transform){e.is_identity||t.setAttribute("transform",e.toString())}scale(t,e){isFinite(t)&&(null==e||isFinite(e))&&this._transform.scale(t,null!=e?e:t)}rotate(t){isFinite(t)&&this._transform.rotate(t)}translate(t,e){isFinite(t+e)&&this._transform.translate(t,e)}transform(t,e,i,s,n,r){isFinite(t+e+i+s+n+r)&&this._transform.transform(t,e,i,s,n,r)}beginPath(){this.__currentDefaultPath="",this.__currentPosition=null;const t=this.__createElement("path",{},!0);this.__root.appendChild(t),this.__currentElement=t}__applyCurrentDefaultPath(){const t=this.__currentElement;"path"===t.nodeName?t.setAttribute("d",this.__currentDefaultPath):console.error("Attempted to apply path command to node",t.nodeName)}__addPathCommand(t,e,i){const s=this.__currentDefaultPath?" ":"";this.__currentDefaultPath+=s+i,this.__currentPosition={x:t,y:e}}get _hasCurrentDefaultPath(){return!!this.__currentDefaultPath}moveTo(t,e){if(!isFinite(t+e))return;"path"!==this.__currentElement.nodeName&&this.beginPath();const[i,s]=this._transform.apply(t,e);this.__addPathCommand(i,s,`M ${i} ${s}`)}closePath(){this._hasCurrentDefaultPath&&this.__addPathCommand(NaN,NaN,"Z")}lineTo(t,e){if(isFinite(t+e))if(this._hasCurrentDefaultPath){const[i,s]=this._transform.apply(t,e);this.__addPathCommand(i,s,`L ${i} ${s}`)}else this.moveTo(t,e)}bezierCurveTo(t,e,i,s,n,r){if(!isFinite(t+e+i+s+n+r))return;const[a,o]=this._transform.apply(n,r),[l,h]=this._transform.apply(t,e),[c,_]=this._transform.apply(i,s);this.__addPathCommand(a,o,`C ${l} ${h} ${c} ${_} ${a} ${o}`)}quadraticCurveTo(t,e,i,s){if(!isFinite(t+e+i+s))return;const[n,r]=this._transform.apply(i,s),[a,o]=this._transform.apply(t,e);this.__addPathCommand(n,r,`Q ${a} ${o} ${n} ${r}`)}arcTo(t,e,i,s,n){if(!isFinite(t+e+i+s+n))return;if(null==this.__currentPosition)return;const r=this.__currentPosition.x,a=this.__currentPosition.y;if(n<0)throw new Error("IndexSizeError: The radius provided ("+n+") is negative.");if(r===t&&a===e||t===i&&e===s||0===n)return void this.lineTo(t,e);function o([t,e]){const i=Math.sqrt(t**2+e**2);return[t/i,e/i]}const l=o([r-t,a-e]),h=o([i-t,s-e]);if(l[0]*h[1]==l[1]*h[0])return void this.lineTo(t,e);const c=l[0]*h[0]+l[1]*h[1],_=Math.acos(Math.abs(c)),u=o([l[0]+h[0],l[1]+h[1]]),p=n/Math.sin(_/2),d=t+p*u[0],m=e+p*u[1],f=[-l[1],l[0]],g=[h[1],-h[0]];function w(t){const e=t[0];return t[1]>=0?Math.acos(e):-Math.acos(e)}const b=w(f),v=w(g);this.lineTo(d+f[0]*n,m+f[1]*n),this.arc(d,m,n,b,v)}stroke(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","fill"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("stroke"),null!=this._clip_path&&this.__currentElement.setAttribute("clip-path",this._clip_path)}fill(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","stroke"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("fill"),null!=this._clip_path&&this.__currentElement.setAttribute("clip-path",this._clip_path)}rect(t,e,i,s){isFinite(t+e+i+s)&&("path"!==this.__currentElement.nodeName&&this.beginPath(),this.moveTo(t,e),this.lineTo(t+i,e),this.lineTo(t+i,e+s),this.lineTo(t,e+s),this.lineTo(t,e))}fillRect(t,e,i,s){isFinite(t+e+i+s)&&(this.beginPath(),this.rect(t,e,i,s),this.fill())}strokeRect(t,e,i,s){isFinite(t+e+i+s)&&(this.beginPath(),this.rect(t,e,i,s),this.stroke())}__clearCanvas(){r.empty(this.__defs),r.empty(this.__root),this.__root.appendChild(this.__defs),this.__currentElement=this.__root}clearRect(t,e,i,s){if(!isFinite(t+e+i+s))return;if(0===t&&0===e&&i===this.width&&s===this.height)return void this.__clearCanvas();const n=this.__createElement("rect",{x:t,y:e,width:i,height:s,fill:"#FFFFFF"},!0);this._apply_transform(n),this.__root.appendChild(n)}createLinearGradient(t,e,i,s){if(!isFinite(t+e+i+s))throw new Error("The provided double value is non-finite");const[n,r]=this._transform.apply(t,e),[o,l]=this._transform.apply(i,s),h=this.__createElement("linearGradient",{id:a(this.__ids),x1:n+"px",x2:o+"px",y1:r+"px",y2:l+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(h),new _(h,this)}createRadialGradient(t,e,i,s,n,r){if(!isFinite(t+e+i+s+n+r))throw new Error("The provided double value is non-finite");const[o,l]=this._transform.apply(t,e),[h,c]=this._transform.apply(s,n),u=this.__createElement("radialGradient",{id:a(this.__ids),cx:h+"px",cy:c+"px",r:r+"px",fx:o+"px",fy:l+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(u),new _(u,this)}__parseFont(){const t=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i.exec(this.font),e={style:t[1]||"normal",size:t[4]||"10px",family:t[6]||"sans-serif",weight:t[3]||"normal",decoration:t[2]||"normal"};return"underline"===this.__fontUnderline&&(e.decoration="underline"),null!=this.__fontHref&&(e.href=this.__fontHref),e}__wrapTextLink(t,e){if(t.href){const i=this.__createElement("a");return i.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",t.href),i.appendChild(e),i}return e}__applyText(t,e,i,s){const n=this.__parseFont(),r=this.__createElement("text",{"font-family":n.family,"font-size":n.size,"font-style":n.style,"font-weight":n.weight,"text-decoration":n.decoration,x:e,y:i,"text-anchor":o(this.textAlign),"dominant-baseline":l(this.textBaseline)},!0);r.appendChild(this.__document.createTextNode(t)),this._apply_transform(r),this.__currentElement=r,this.__applyStyleToCurrentElement(s),this.__root.appendChild(this.__wrapTextLink(n,r))}fillText(t,e,i){null!=t&&isFinite(e+i)&&this.__applyText(t,e,i,"fill")}strokeText(t,e,i){null!=t&&isFinite(e+i)&&this.__applyText(t,e,i,"stroke")}measureText(t){return this.__ctx.font=this.font,this.__ctx.measureText(t)}arc(t,e,i,s,n,r=!1){if(!isFinite(t+e+i+s+n))return;if(s===n)return;(s%=2*Math.PI)===(n%=2*Math.PI)&&(n=(n+2*Math.PI-.001*(r?-1:1))%(2*Math.PI));const a=t+i*Math.cos(n),o=e+i*Math.sin(n),l=t+i*Math.cos(s),h=e+i*Math.sin(s),c=r?0:1;let _=0,u=n-s;u<0&&(u+=2*Math.PI),_=r?u>Math.PI?0:1:u>Math.PI?1:0,this.lineTo(l,h);const p=i,d=i,[m,f]=this._transform.apply(a,o);this.__addPathCommand(m,f,`A ${p} ${d} 0 ${_} ${c} ${m} ${f}`)}clip(){const t=this.__createElement("clipPath"),e=a(this.__ids);this.__applyCurrentDefaultPath(),t.setAttribute("id",e),t.appendChild(this.__currentElement),this.__defs.appendChild(t),this._clip_path=`url(#${e})`}drawImage(t,...e){let i,s,n,r,a,o,l,h;if(2==e.length){if([i,s]=e,!isFinite(i+s))return;a=0,o=0,l=t.width,h=t.height,n=l,r=h}else if(4==e.length){if([i,s,n,r]=e,!isFinite(i+s+n+r))return;a=0,o=0,l=t.width,h=t.height}else{if(8!==e.length)throw new Error("Inavlid number of arguments passed to drawImage: "+arguments.length);if([a,o,l,h,i,s,n,r]=e,!isFinite(a+o+l+h+i+s+n+r))return}const c=this.__root,_="translate("+i+", "+s+")",u=this._transform.clone().translate(i,s);if(t instanceof p||t instanceof SVGSVGElement){const e=(t instanceof SVGSVGElement?t:t.get_svg()).cloneNode(!0);let i;u.is_identity?i=c:(i=this.__createElement("g"),this._apply_transform(i,u),c.appendChild(i));for(const t of[...e.childNodes])if(t instanceof SVGDefsElement){for(const e of[...t.childNodes])if(e instanceof Element){const t=e.getAttribute("id");this.__ids[t]=t,this.__defs.appendChild(e)}}else i.appendChild(t)}else if(t instanceof HTMLImageElement||t instanceof SVGImageElement){const e=this.__createElement("image");if(e.setAttribute("width",""+n),e.setAttribute("height",""+r),e.setAttribute("preserveAspectRatio","none"),a||o||l!==t.width||h!==t.height){const e=this.__document.createElement("canvas");e.width=n,e.height=r;e.getContext("2d").drawImage(t,a,o,l,h,0,0,n,r),t=e}e.setAttribute("transform",_);const i=t instanceof HTMLCanvasElement?t.toDataURL():t.getAttribute("src");e.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",i),c.appendChild(e)}else if(t instanceof HTMLCanvasElement){const e=this.__createElement("image");e.setAttribute("width",""+n),e.setAttribute("height",""+r),e.setAttribute("preserveAspectRatio","none");const i=this.__document.createElement("canvas");i.width=n,i.height=r;const s=i.getContext("2d");s.imageSmoothingEnabled=!1,s.drawImage(t,a,o,l,h,0,0,n,r),t=i,e.setAttribute("transform",_),e.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",t.toDataURL()),c.appendChild(e)}}createPattern(t,e){const i=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),s=a(this.__ids);if(i.setAttribute("id",s),i.setAttribute("width",""+this._to_number(t.width)),i.setAttribute("height",""+this._to_number(t.height)),i.setAttribute("patternUnits","userSpaceOnUse"),t instanceof HTMLCanvasElement||t instanceof HTMLImageElement||t instanceof SVGImageElement){const e=this.__document.createElementNS("http://www.w3.org/2000/svg","image"),s=t instanceof HTMLCanvasElement?t.toDataURL():t.getAttribute("src");e.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",s),i.appendChild(e),this.__defs.appendChild(i)}else if(t instanceof p){for(const e of[...t.__root.childNodes])e instanceof SVGDefsElement||i.appendChild(e);this.__defs.appendChild(i)}else{if(!(t instanceof SVGSVGElement))throw new Error("unsupported");for(const e of[...t.childNodes])e instanceof SVGDefsElement||i.appendChild(e);this.__defs.appendChild(i)}return new u(i,this)}setLineDash(t){t&&t.length>0?this.lineDash=t.join(","):this.lineDash=null}_to_number(t){return n.isNumber(t)?t:t.baseVal.value}}i.SVGRenderingContext2D=p,p.__name__="SVGRenderingContext2D"},
function _(t,s,r){Object.defineProperty(r,"__esModule",{value:!0});const{sin:e,cos:n}=Math;class i{constructor(t=1,s=0,r=0,e=1,n=0,i=0){this.a=t,this.b=s,this.c=r,this.d=e,this.e=n,this.f=i}toString(){const{a:t,b:s,c:r,d:e,e:n,f:i}=this;return`matrix(${t}, ${s}, ${r}, ${e}, ${n}, ${i})`}clone(){const{a:t,b:s,c:r,d:e,e:n,f:a}=this;return new i(t,s,r,e,n,a)}get is_identity(){const{a:t,b:s,c:r,d:e,e:n,f:i}=this;return 1==t&&0==s&&0==r&&1==e&&0==n&&0==i}apply(t,s){const{a:r,b:e,c:n,d:i,e:a,f:h}=this;return[r*t+n*s+a,e*t+i*s+h]}iv_apply(t,s){const{a:r,b:e,c:n,d:i,e:a,f:h}=this,c=t.length;for(let o=0;o<c;o++){const c=t[o],f=s[o];t[o]=r*c+n*f+a,s[o]=e*c+i*f+h}}transform(t,s,r,e,n,i){const{a,b:h,c,d:o,e:f,f:l}=this;return this.a=a*t+c*s,this.c=a*r+c*e,this.e=a*n+c*i+f,this.b=h*t+o*s,this.d=h*r+o*e,this.f=h*n+o*i+l,this}translate(t,s){return this.transform(1,0,0,1,t,s)}scale(t,s){return this.transform(t,0,0,s,0,0)}skew(t,s){return this.transform(1,s,t,1,0,0)}rotate(t){const s=e(t),r=n(t);return this.transform(r,s,-s,r,0,0)}rotate_ccw(t){return this.rotate(-t)}translate_x(t){return this.translate(t,0)}translate_y(t){return this.translate(0,t)}flip(){return this.scale(-1,-1)}flip_x(){return this.scale(1,-1)}flip_y(){return this.scale(-1,1)}}r.AffineTransform=i,i.__name__="AffineTransform"},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(1),a=e(14),n=e(78),l=e(19),o=s.__importStar(e(18)),r=e(72),h=e(13),c=e(79),_=e(80),d=e(75),p=(()=>{const e=document.createElement("canvas"),t=e.getContext("webgl",{premultipliedAlpha:!0});return null!=t?{canvas:e,gl:t}:void l.logger.trace("WebGL is not supported")})(),v={position:"absolute",top:"0",left:"0",width:"100%",height:"100%"};class b{constructor(e,t){switch(this.backend=e,this.hidpi=t,this.pixel_ratio=1,this.bbox=new c.BBox,e){case"webgl":case"canvas":{this._el=this._canvas=r.canvas({style:v});const e=this.canvas.getContext("2d");if(null==e)throw new Error("unable to obtain 2D rendering context");this._ctx=e,t&&(this.pixel_ratio=devicePixelRatio);break}case"svg":{const e=new d.SVGRenderingContext2D;this._ctx=e,this._canvas=e.get_svg(),this._el=r.div({style:v},this._canvas);break}}_.fixup_ctx(this._ctx)}get canvas(){return this._canvas}get ctx(){return this._ctx}get el(){return this._el}resize(e,t){this.bbox=new c.BBox({left:0,top:0,width:e,height:t});const i=this._ctx instanceof d.SVGRenderingContext2D?this._ctx:this.canvas;i.width=e*this.pixel_ratio,i.height=t*this.pixel_ratio}prepare(){const{ctx:e,hidpi:t,pixel_ratio:i}=this;e.save(),t&&(e.scale(i,i),e.translate(.5,.5)),this.clear()}clear(){const{x:e,y:t,width:i,height:s}=this.bbox;this.ctx.clearRect(e,t,i,s)}finish(){this.ctx.restore()}to_blob(){const{_canvas:e}=this;if(e instanceof HTMLCanvasElement)return null!=e.msToBlob?Promise.resolve(e.msToBlob()):new Promise((t,i)=>{e.toBlob(e=>null!=e?t(e):i(),"image/png")});{const e=this._ctx.get_serialized_svg(!0),t=new Blob([e],{type:"image/svg+xml"});return Promise.resolve(t)}}}i.CanvasLayer=b,b.__name__="CanvasLayer";class g extends n.DOMView{constructor(){super(...arguments),this.bbox=new c.BBox}initialize(){super.initialize();const{output_backend:e,hidpi:t}=this.model;"webgl"==e&&(this.webgl=p),this.underlays_el=r.div({style:v}),this.primary=new b(e,t),this.overlays=new b(e,t),this.overlays_el=r.div({style:v}),this.events_el=r.div({class:"bk-canvas-events",style:v});const i=[this.underlays_el,this.primary.el,this.overlays.el,this.overlays_el,this.events_el];h.extend(this.el.style,v),r.append(this.el,...i),l.logger.debug("CanvasView initialized")}add_underlay(e){this.underlays_el.appendChild(e)}add_overlay(e){this.overlays_el.appendChild(e)}add_event(e){this.events_el.appendChild(e)}get pixel_ratio(){return this.primary.pixel_ratio}resize(e,t){this.bbox=new c.BBox({left:0,top:0,width:e,height:t}),this.primary.resize(e,t),this.overlays.resize(e,t)}prepare_webgl(e){const{webgl:t}=this;if(null!=t){const{width:i,height:s}=this.bbox;t.canvas.width=this.pixel_ratio*i,t.canvas.height=this.pixel_ratio*s;const{gl:a}=t;a.enable(a.SCISSOR_TEST);const[n,l,o,r]=e,{xview:h,yview:c}=this.bbox,_=h.compute(n),d=c.compute(l+r),p=this.pixel_ratio;a.scissor(p*_,p*d,p*o,p*r),a.enable(a.BLEND),a.blendFuncSeparate(a.SRC_ALPHA,a.ONE_MINUS_SRC_ALPHA,a.ONE_MINUS_DST_ALPHA,a.ONE)}}clear_webgl(){const{webgl:e}=this;if(null!=e){const{gl:t,canvas:i}=e;t.viewport(0,0,i.width,i.height),t.clearColor(0,0,0,0),t.clear(t.COLOR_BUFFER_BIT||t.DEPTH_BUFFER_BIT)}}blit_webgl(e){const{webgl:t}=this;if(null!=t&&(l.logger.debug("Blitting WebGL canvas"),e.restore(),e.drawImage(t.canvas,0,0),e.save(),this.model.hidpi)){const t=this.pixel_ratio;e.scale(t,t),e.translate(.5,.5)}}compose(){const{output_backend:e,hidpi:t}=this.model,{width:i,height:s}=this.bbox,a=new b(e,t);return a.resize(i,s),a.ctx.drawImage(this.primary.canvas,0,0),a.ctx.drawImage(this.overlays.canvas,0,0),a}to_blob(){return this.compose().to_blob()}}i.CanvasView=g,g.__name__="CanvasView";class x extends a.HasProps{constructor(e){super(e)}static init_Canvas(){this.prototype.default_view=g,this.internal({hidpi:[o.Boolean,!0],output_backend:[o.OutputBackend,"canvas"]})}}i.Canvas=x,x.__name__="Canvas",x.init_Canvas()},
function _(e,s,t){Object.defineProperty(t,"__esModule",{value:!0});const i=e(71),r=e(72);class n extends i.View{initialize(){super.initialize(),this.el=this._createElement()}remove(){r.remove(this.el),super.remove()}css_classes(){return[]}render(){}renderTo(e){e.appendChild(this.el),this.render()}_createElement(){return r.createElement(this.tagName,{class:this.css_classes()})}}t.DOMView=n,n.__name__="DOMView",n.prototype.tagName="div"},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});const h=t(24),{min:r,max:s}=Math;e.empty=function(){return{x0:1/0,y0:1/0,x1:-1/0,y1:-1/0}},e.positive_x=function(){return{x0:Number.MIN_VALUE,y0:-1/0,x1:1/0,y1:1/0}},e.positive_y=function(){return{x0:-1/0,y0:Number.MIN_VALUE,x1:1/0,y1:1/0}},e.union=function(t,i){return{x0:r(t.x0,i.x0),x1:s(t.x1,i.x1),y0:r(t.y0,i.y0),y1:s(t.y1,i.y1)}};class n{constructor(t){if(null==t)this.x0=0,this.y0=0,this.x1=0,this.y1=0;else if("x0"in t){const{x0:i,y0:e,x1:h,y1:r}=t;if(!(i<=h&&e<=r))throw new Error(`invalid bbox {x0: ${i}, y0: ${e}, x1: ${h}, y1: ${r}}`);this.x0=i,this.y0=e,this.x1=h,this.y1=r}else if("x"in t){const{x:i,y:e,width:h,height:r}=t;if(!(h>=0&&r>=0))throw new Error(`invalid bbox {x: ${i}, y: ${e}, width: ${h}, height: ${r}}`);this.x0=i,this.y0=e,this.x1=i+h,this.y1=e+r}else{let i,e,h,r;if("width"in t)if("left"in t)i=t.left,e=i+t.width;else if("right"in t)e=t.right,i=e-t.width;else{const h=t.width/2;i=t.hcenter-h,e=t.hcenter+h}else i=t.left,e=t.right;if("height"in t)if("top"in t)h=t.top,r=h+t.height;else if("bottom"in t)r=t.bottom,h=r-t.height;else{const i=t.height/2;h=t.vcenter-i,r=t.vcenter+i}else h=t.top,r=t.bottom;if(!(i<=e&&h<=r))throw new Error(`invalid bbox {left: ${i}, top: ${h}, right: ${e}, bottom: ${r}}`);this.x0=i,this.y0=h,this.x1=e,this.y1=r}}toString(){return`BBox({left: ${this.left}, top: ${this.top}, width: ${this.width}, height: ${this.height}})`}get left(){return this.x0}get top(){return this.y0}get right(){return this.x1}get bottom(){return this.y1}get p0(){return[this.x0,this.y0]}get p1(){return[this.x1,this.y1]}get x(){return this.x0}get y(){return this.y0}get width(){return this.x1-this.x0}get height(){return this.y1-this.y0}get rect(){return{x0:this.x0,y0:this.y0,x1:this.x1,y1:this.y1}}get box(){return{x:this.x,y:this.y,width:this.width,height:this.height}}get h_range(){return{start:this.x0,end:this.x1}}get v_range(){return{start:this.y0,end:this.y1}}get ranges(){return[this.h_range,this.v_range]}get aspect(){return this.width/this.height}get hcenter(){return(this.left+this.right)/2}get vcenter(){return(this.top+this.bottom)/2}relativize(){const{width:t,height:i}=this;return new n({x:0,y:0,width:t,height:i})}contains(t,i){return t>=this.x0&&t<=this.x1&&i>=this.y0&&i<=this.y1}clip(t,i){return t<this.x0?t=this.x0:t>this.x1&&(t=this.x1),i<this.y0?i=this.y0:i>this.y1&&(i=this.y1),[t,i]}union(t){return new n({x0:r(this.x0,t.x0),y0:r(this.y0,t.y0),x1:s(this.x1,t.x1),y1:s(this.y1,t.y1)})}equals(t){return this.x0==t.x0&&this.y0==t.y0&&this.x1==t.x1&&this.y1==t.y1}get xview(){return{compute:t=>this.left+t,v_compute:t=>{const i=new h.NumberArray(t.length),e=this.left;for(let h=0;h<t.length;h++)i[h]=e+t[h];return i}}}get yview(){return{compute:t=>this.bottom-t,v_compute:t=>{const i=new h.NumberArray(t.length),e=this.bottom;for(let h=0;h<t.length;h++)i[h]=e-t[h];return i}}}}e.BBox=n,n.__name__="BBox"},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0}),n.fixup_ctx=function(e){!function(e){void 0===e.lineDash&&Object.defineProperty(e,"lineDash",{get:()=>e.getLineDash(),set:t=>e.setLineDash(t)})}(e),function(e){e.setImageSmoothingEnabled=t=>{e.imageSmoothingEnabled=t,e.mozImageSmoothingEnabled=t,e.oImageSmoothingEnabled=t,e.webkitImageSmoothingEnabled=t,e.msImageSmoothingEnabled=t},e.getImageSmoothingEnabled=()=>{const t=e.imageSmoothingEnabled;return null==t||t}}(e),function(e){e.measureText&&null==e.html5MeasureText&&(e.html5MeasureText=e.measureText,e.measureText=t=>{const n=e.html5MeasureText(t);return n.ascent=1.6*e.html5MeasureText("m").width,n})}(e),function(e){e.ellipse||(e.ellipse=function(t,n,o,a,i,l,m,r=!1){const u=.551784;e.translate(t,n),e.rotate(i);let s=o,g=a;r&&(s=-o,g=-a),e.moveTo(-s,0),e.bezierCurveTo(-s,g*u,-s*u,g,0,g),e.bezierCurveTo(s*u,g,s,g*u,s,0),e.bezierCurveTo(s,-g*u,s*u,-g,0,-g),e.bezierCurveTo(-s*u,-g,-s,-g*u,-s,0),e.rotate(-i),e.translate(-t,-n)})}(e)}},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const n=e(1),c=e(14),i=n.__importStar(e(18)),a=e(8),r=e(13),o=e(19);class l extends c.HasProps{constructor(e){super(e)}static init_Model(){this.define({tags:[i.Array,[]],name:[i.String],js_property_callbacks:[i.Any,{}],js_event_callbacks:[i.Any,{}],subscribed_events:[i.Array,[]]})}initialize(){super.initialize(),this._js_callbacks=new Map}connect_signals(){super.connect_signals(),this._update_property_callbacks(),this.connect(this.properties.js_property_callbacks.change,()=>this._update_property_callbacks()),this.connect(this.properties.js_event_callbacks.change,()=>this._update_event_callbacks()),this.connect(this.properties.subscribed_events.change,()=>this._update_event_callbacks())}_process_event(e){for(const t of this.js_event_callbacks[e.event_name]||[])t.execute(e);null!=this.document&&this.subscribed_events.some(t=>t==e.event_name)&&this.document.event_manager.send_event(e)}trigger_event(e){null!=this.document&&(e.origin=this,this.document.event_manager.trigger(e))}_update_event_callbacks(){null!=this.document?this.document.event_manager.subscribed_models.add(this):o.logger.warn("WARNING: Document not defined for updating event callbacks")}_update_property_callbacks(){const e=e=>{const[t,s=null]=e.split(":");return null!=s?this.properties[s][t]:this[t]};for(const[t,s]of this._js_callbacks){const n=e(t);for(const e of s)this.disconnect(n,e)}this._js_callbacks.clear();for(const[t,s]of r.entries(this.js_property_callbacks)){const n=s.map(e=>()=>e.execute(this));this._js_callbacks.set(t,n);const c=e(t);for(const e of n)this.connect(c,e)}}_doc_attached(){r.isEmpty(this.js_event_callbacks)&&0==this.subscribed_events.length||this._update_event_callbacks()}_doc_detached(){this.document.event_manager.subscribed_models.delete(this)}select(e){if(a.isString(e))return[...this.references()].filter(t=>t instanceof l&&t.name===e);if(e.prototype instanceof c.HasProps)return[...this.references()].filter(t=>t instanceof e);throw new Error("invalid selector")}select_one(e){const t=this.select(e);switch(t.length){case 0:return null;case 1:return t[0];default:throw new Error("found more than one object matching given selector")}}}s.Model=l,l.__name__="Model",l.init_Model()},
function _(e,s,_){Object.defineProperty(_,"__esModule",{value:!0});class t{constructor(e,s){this.x_scale=e,this.y_scale=s,this.x_range=this.x_scale.source_range,this.y_range=this.y_scale.source_range,this.ranges=[this.x_range,this.y_range],this.scales=[this.x_scale,this.y_scale]}map_to_screen(e,s){return[this.x_scale.v_compute(e),this.y_scale.v_compute(s)]}map_from_screen(e,s){return[this.x_scale.v_invert(e),this.y_scale.v_invert(s)]}}_.CoordinateTransform=t,t.__name__="CoordinateTransform"},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const i=t(1),a=t(36),o=t(84),r=t(85),n=t(28),_=i.__importStar(t(18)),h=t(10);class c extends a.AnnotationView{initialize(){super.initialize(),null==this.model.source&&(this.model.source=new r.ColumnDataSource),this.set_data(this.model.source)}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.set_data(this.model.source)),this.connect(this.model.source.streaming,()=>this.set_data(this.model.source)),this.connect(this.model.source.patching,()=>this.set_data(this.model.source)),this.connect(this.model.source.change,()=>this.set_data(this.model.source))}set_data(t){super.set_data(t),this.visuals.warm_cache(t),this.plot_view.request_render()}_map_data(){const{frame:t}=this.plot_view;let e,s,i,a;return"data"==this.model.start_units?(e=this.coordinates.x_scale.v_compute(this._x_start),s=this.coordinates.y_scale.v_compute(this._y_start)):(e=t.xview.v_compute(this._x_start),s=t.yview.v_compute(this._y_start)),"data"==this.model.end_units?(i=this.coordinates.x_scale.v_compute(this._x_end),a=this.coordinates.y_scale.v_compute(this._y_end)):(i=t.xview.v_compute(this._x_end),a=t.yview.v_compute(this._y_end)),[[e,s],[i,a]]}_render(){const{ctx:t}=this.layer;t.save();const[e,s]=this._map_data();null!=this.model.end&&this._arrow_head(t,"render",this.model.end,e,s),null!=this.model.start&&this._arrow_head(t,"render",this.model.start,s,e),t.beginPath();const{x:i,y:a,width:o,height:r}=this.plot_view.frame.bbox;t.rect(i,a,o,r),null!=this.model.end&&this._arrow_head(t,"clip",this.model.end,e,s),null!=this.model.start&&this._arrow_head(t,"clip",this.model.start,s,e),t.closePath(),t.clip(),this._arrow_body(t,e,s),t.restore()}_arrow_head(t,e,s,i,a){for(let o=0,r=this._x_start.length;o<r;o++){const r=Math.PI/2+h.atan2([i[0][o],i[1][o]],[a[0][o],a[1][o]]);t.save(),t.translate(a[0][o],a[1][o]),t.rotate(r),"render"==e?s.render(t,o):"clip"==e&&s.clip(t,o),t.restore()}}_arrow_body(t,e,s){if(this.visuals.line.doit)for(let i=0,a=this._x_start.length;i<a;i++)this.visuals.line.set_vectorize(t,i),t.beginPath(),t.moveTo(e[0][i],e[1][i]),t.lineTo(s[0][i],s[1][i]),t.stroke()}}s.ArrowView=c,c.__name__="ArrowView";class d extends a.Annotation{constructor(t){super(t)}static init_Arrow(){this.prototype.default_view=c,this.mixins(n.LineVector),this.define({x_start:[_.NumberSpec],y_start:[_.NumberSpec],start_units:[_.SpatialUnits,"data"],start:[_.Instance,null],x_end:[_.NumberSpec],y_end:[_.NumberSpec],end_units:[_.SpatialUnits,"data"],end:[_.Instance,()=>new o.OpenHead({})],source:[_.Instance]})}}s.Arrow=d,d.__name__="Arrow",d.init_Arrow()},
function _(i,e,s){Object.defineProperty(s,"__esModule",{value:!0});const t=i(1),o=i(36),l=i(74),n=i(28),h=t.__importStar(i(18));class a extends o.Annotation{constructor(i){super(i)}static init_ArrowHead(){this.define({size:[h.Number,25]})}initialize(){super.initialize(),this.visuals=new l.Visuals(this)}}s.ArrowHead=a,a.__name__="ArrowHead",a.init_ArrowHead();class r extends a{constructor(i){super(i)}static init_OpenHead(){this.mixins(n.LineVector)}clip(i,e){this.visuals.line.set_vectorize(i,e),i.moveTo(.5*this.size,this.size),i.lineTo(.5*this.size,-2),i.lineTo(-.5*this.size,-2),i.lineTo(-.5*this.size,this.size),i.lineTo(0,0),i.lineTo(.5*this.size,this.size)}render(i,e){this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),i.beginPath(),i.moveTo(.5*this.size,this.size),i.lineTo(0,0),i.lineTo(-.5*this.size,this.size),i.stroke())}}s.OpenHead=r,r.__name__="OpenHead",r.init_OpenHead();class z extends a{constructor(i){super(i)}static init_NormalHead(){this.mixins([n.LineVector,n.FillVector]),this.override({fill_color:"black"})}clip(i,e){this.visuals.line.set_vectorize(i,e),i.moveTo(.5*this.size,this.size),i.lineTo(.5*this.size,-2),i.lineTo(-.5*this.size,-2),i.lineTo(-.5*this.size,this.size),i.lineTo(.5*this.size,this.size)}render(i,e){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(i,e),this._normal(i,e),i.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),this._normal(i,e),i.stroke())}_normal(i,e){i.beginPath(),i.moveTo(.5*this.size,this.size),i.lineTo(0,0),i.lineTo(-.5*this.size,this.size),i.closePath()}}s.NormalHead=z,z.__name__="NormalHead",z.init_NormalHead();class _ extends a{constructor(i){super(i)}static init_VeeHead(){this.mixins([n.LineVector,n.FillVector]),this.override({fill_color:"black"})}clip(i,e){this.visuals.line.set_vectorize(i,e),i.moveTo(.5*this.size,this.size),i.lineTo(.5*this.size,-2),i.lineTo(-.5*this.size,-2),i.lineTo(-.5*this.size,this.size),i.lineTo(0,.5*this.size),i.lineTo(.5*this.size,this.size)}render(i,e){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(i,e),this._vee(i,e),i.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),this._vee(i,e),i.stroke())}_vee(i,e){i.beginPath(),i.moveTo(.5*this.size,this.size),i.lineTo(0,0),i.lineTo(-.5*this.size,this.size),i.lineTo(0,.5*this.size),i.closePath()}}s.VeeHead=_,_.__name__="VeeHead",_.init_VeeHead();class c extends a{constructor(i){super(i)}static init_TeeHead(){this.mixins(n.LineVector)}render(i,e){this.visuals.line.doit&&(this.visuals.line.set_vectorize(i,e),i.beginPath(),i.moveTo(.5*this.size,0),i.lineTo(-.5*this.size,0),i.stroke())}clip(i,e){}}s.TeeHead=c,c.__name__="TeeHead",c.init_TeeHead()},
function _(t,n,e){Object.defineProperty(e,"__esModule",{value:!0});const s=t(1),o=t(86),r=s.__importStar(t(18)),i=t(8),l=t(13),a=s.__importStar(t(119)),c=t(120),u=t(121);function h(t,n,e){if(i.isArray(t)){const s=t.concat(n);return null!=e&&s.length>e?s.slice(-e):s}if(i.isTypedArray(t)){const s=t.length+n.length;if(null!=e&&s>e){const o=s-e,r=t.length;let i;t.length<e?(i=new t.constructor(e),i.set(t,0)):i=t;for(let t=o,n=r;t<n;t++)i[t-o]=i[t];for(let t=0,e=n.length;t<e;t++)i[t+(r-o)]=n[t];return i}{const e=new t.constructor(n);return a.concat(t,e)}}throw new Error("unsupported array types")}function d(t,n){let e,s,o;return i.isNumber(t)?(e=t,o=t+1,s=1):(e=null!=t.start?t.start:0,o=null!=t.stop?t.stop:n,s=null!=t.step?t.step:1),[e,o,s]}function f(t,n){const e=new Set;let s=!1;for(const[o,r]of n){let n,l,a,c;if(i.isArray(o)){const[s]=o;e.add(s),n=t[s].shape,l=t[s],c=r,2===o.length?(n=[1,n[0]],a=[o[0],0,o[1]]):a=o}else i.isNumber(o)?(c=[r],e.add(o)):(c=r,s=!0),a=[0,0,o],n=[1,t.length],l=t;let u=0;const[h,f,m]=d(a[1],n[0]),[_,p,g]=d(a[2],n[1]);for(let t=h;t<f;t+=m)for(let o=_;o<p;o+=g)s&&e.add(o),l[t*n[1]+o]=c[u],u++}return e}e.stream_to_column=h,e.slice=d,e.patch_to_column=f;class m extends o.ColumnarDataSource{constructor(t){super(t)}static init_ColumnDataSource(){this.define({data:[r.Any,{}]})}stream(t,n,e){const{data:s}=this;for(const[e,o]of l.entries(t))s[e]=h(s[e],o,n);if(this.setv({data:s},{silent:!0}),this.streaming.emit(),null!=this.document){const s=new u.ColumnsStreamedEvent(this.document,this.ref(),t,n);this.document._notify_change(this,"data",null,null,{setter_id:e,hint:s})}}patch(t,n){const{data:e}=this;let s=new Set;for(const[n,o]of l.entries(t))s=c.union(s,f(e[n],o));if(this.setv({data:e},{silent:!0}),this.patching.emit([...s]),null!=this.document){const e=new u.ColumnsPatchedEvent(this.document,this.ref(),t);this.document._notify_change(this,"data",null,null,{setter_id:n,hint:e})}}}e.ColumnDataSource=m,m.__name__="ColumnDataSource",m.init_ColumnDataSource()},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});const a=t(1),s=t(87),i=t(15),r=t(19),l=t(89),c=a.__importStar(t(18)),o=t(8),u=t(9),h=t(13),g=t(88),_=t(118);class d extends s.DataSource{constructor(t){super(t)}get_array(t){let e=this.data[t];return null==e?this.data[t]=e=[]:o.isArray(e)||(this.data[t]=e=Array.from(e)),e}static init_ColumnarDataSource(){this.define({selection_policy:[c.Instance,()=>new _.UnionRenderers]}),this.internal({selection_manager:[c.Instance,t=>new l.SelectionManager({source:t})],inspected:[c.Instance,()=>new g.Selection]})}initialize(){super.initialize(),this._select=new i.Signal0(this,"select"),this.inspect=new i.Signal(this,"inspect"),this.streaming=new i.Signal0(this,"streaming"),this.patching=new i.Signal(this,"patching")}get_column(t){const e=this.data[t];return null!=e?e:null}columns(){return h.keys(this.data)}get_length(t=!0){const e=u.uniq(h.values(this.data).map(t=>t.length));switch(e.length){case 0:return null;case 1:return e[0];default:{const n="data source has columns of inconsistent lengths";if(t)return r.logger.warn(n),e.sort()[0];throw new Error(n)}}}get length(){var t;return null!==(t=this.get_length())&&void 0!==t?t:0}clear(){const t={};for(const e of this.columns())t[e]=new this.data[e].constructor(0);this.data=t}}n.ColumnarDataSource=d,d.__name__="ColumnarDataSource",d.init_ColumnarDataSource()},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const c=e(1),n=e(81),o=e(88),i=c.__importStar(e(18));class r extends n.Model{constructor(e){super(e)}static init_DataSource(){this.define({selected:[i.Instance,()=>new o.Selection]})}}a.DataSource=r,r.__name__="DataSource",r.init_DataSource()},
function _(i,e,s){Object.defineProperty(s,"__esModule",{value:!0});const t=i(1),n=i(81),l=t.__importStar(i(18)),c=i(9),h=i(13);class d extends n.Model{constructor(i){super(i)}get_view(){return this.view}static init_Selection(){this.define({indices:[l.Array,[]],line_indices:[l.Array,[]],multiline_indices:[l.Any,{}]}),this.internal({selected_glyphs:[l.Array,[]],view:[l.Any],image_indices:[l.Array,[]]})}initialize(){super.initialize()}get selected_glyph(){return this.selected_glyphs.length>0?this.selected_glyphs[0]:null}add_to_selected_glyphs(i){this.selected_glyphs.push(i)}update(i,e=!0,s="replace"){switch(s){case"replace":this.indices=i.indices,this.line_indices=i.line_indices,this.selected_glyphs=i.selected_glyphs,this.view=i.view,this.multiline_indices=i.multiline_indices,this.image_indices=i.image_indices;break;case"append":this.update_through_union(i);break;case"intersect":this.update_through_intersection(i);break;case"subtract":this.update_through_subtraction(i)}}clear(){this.indices=[],this.line_indices=[],this.multiline_indices={},this.view=null,this.selected_glyphs=[]}is_empty(){return 0==this.indices.length&&0==this.line_indices.length&&0==this.image_indices.length}update_through_union(i){this.indices=c.union(this.indices,i.indices),this.selected_glyphs=c.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=c.union(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=h.merge(i.multiline_indices,this.multiline_indices)}update_through_intersection(i){this.indices=c.intersection(this.indices,i.indices),this.selected_glyphs=c.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=c.union(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=h.merge(i.multiline_indices,this.multiline_indices)}update_through_subtraction(i){this.indices=c.difference(this.indices,i.indices),this.selected_glyphs=c.union(i.selected_glyphs,this.selected_glyphs),this.line_indices=c.union(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=h.merge(i.multiline_indices,this.multiline_indices)}}s.Selection=d,d.__name__="Selection",d.init_Selection()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),n=e(14),o=e(88),c=e(90),r=e(116),l=i.__importStar(e(18));class p extends n.HasProps{constructor(e){super(e),this.inspectors=new Map}static init_SelectionManager(){this.internal({source:[l.Any]})}select(e,t,s,i="replace"){const n=[],o=[];for(const t of e)t instanceof c.GlyphRendererView?n.push(t):t instanceof r.GraphRendererView&&o.push(t);let l=!1;for(const e of o){const n=e.model.selection_policy.hit_test(t,e);l=l||e.model.selection_policy.do_selection(n,e.model,s,i)}if(n.length>0){const e=this.source.selection_policy.hit_test(t,n);l=l||this.source.selection_policy.do_selection(e,this.source,s,i)}return l}inspect(e,t){let s=!1;if(e instanceof c.GlyphRendererView){const i=e.hit_test(t);if(null!=i){s=!i.is_empty();const n=this.get_or_create_inspector(e.model);n.update(i,!0,"replace"),this.source.setv({inspected:n},{silent:!0}),this.source.inspect.emit([e,{geometry:t}])}}else if(e instanceof r.GraphRendererView){const i=e.model.inspection_policy.hit_test(t,e);s=s||e.model.inspection_policy.do_inspection(i,t,e,!1,"replace")}return s}clear(e){this.source.selected.clear(),null!=e&&this.get_or_create_inspector(e.model).clear()}get_or_create_inspector(e){let t=this.inspectors.get(e);return null==t&&(t=new o.Selection,this.inspectors.set(e,t)),t}}s.SelectionManager=p,p.__name__="SelectionManager",p.init_SelectionManager()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(1),l=e(91),n=e(92),h=e(110),o=e(111),a=e(113),c=e(114),_=e(24),d=s.__importStar(e(18)),r=e(12),p=e(9),g=e(13),u=e(115),y=e(98),m={fill:{},line:{}},v={fill:{fill_alpha:.3,fill_color:"grey"},line:{line_alpha:.3,line_color:"grey"}},f={fill:{fill_alpha:.2},line:{}};class w extends l.DataRendererView{async lazy_initialize(){await super.lazy_initialize();const e=this.model.glyph,t=p.includes(e._mixins,"fill"),i=p.includes(e._mixins,"line"),s=g.clone(e.attributes);function l(l){const n=g.clone(s);return t&&g.extend(n,l.fill),i&&g.extend(n,l.line),new e.constructor(n)}delete s.id,this.glyph=await this.build_glyph_view(e);let{selection_glyph:n}=this.model;null==n?n=l({fill:{},line:{}}):"auto"===n&&(n=l(m)),this.selection_glyph=await this.build_glyph_view(n);let{nonselection_glyph:h}=this.model;null==h?h=l({fill:{},line:{}}):"auto"===h&&(h=l(f)),this.nonselection_glyph=await this.build_glyph_view(h);const{hover_glyph:o}=this.model;null!=o&&(this.hover_glyph=await this.build_glyph_view(o));const{muted_glyph:a}=this.model;null!=a&&(this.muted_glyph=await this.build_glyph_view(a));const c=l(v);this.decimated_glyph=await this.build_glyph_view(c),this.set_data(!1)}async build_glyph_view(e){return u.build_view(e,{parent:this})}remove(){var e,t;this.glyph.remove(),this.selection_glyph.remove(),this.nonselection_glyph.remove(),null===(e=this.hover_glyph)||void 0===e||e.remove(),null===(t=this.muted_glyph)||void 0===t||t.remove(),this.decimated_glyph.remove(),super.remove()}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.request_render()),this.connect(this.model.glyph.change,()=>this.set_data()),this.connect(this.model.data_source.change,()=>this.set_data()),this.connect(this.model.data_source.streaming,()=>this.set_data()),this.connect(this.model.data_source.patching,e=>this.set_data(!0,e)),this.connect(this.model.data_source.selected.change,()=>this.request_render()),this.connect(this.model.data_source._select,()=>this.request_render()),null!=this.hover_glyph&&this.connect(this.model.data_source.inspect,()=>this.request_render()),this.connect(this.model.properties.view.change,()=>this.set_data()),this.connect(this.model.view.properties.indices.change,()=>this.set_data()),this.connect(this.model.view.properties.masked.change,()=>this.set_visuals()),this.connect(this.model.properties.visible.change,()=>this.plot_view.update_dataranges());const{x_ranges:e,y_ranges:t}=this.plot_view.frame;for(const[,t]of e)t instanceof y.FactorRange&&this.connect(t.change,()=>this.set_data());for(const[,e]of t)e instanceof y.FactorRange&&this.connect(e.change,()=>this.set_data());this.connect(this.model.glyph.transformchange,()=>this.set_data())}_update_masked_indices(){const e=this.glyph.mask_data();return this.model.view.masked=e,e}set_data(e=!0,t=null){const i=this.model.data_source;this.all_indices=this.model.view.indices;const{all_indices:s}=this;this.glyph.set_data(i,s,t),this.set_visuals(),this._update_masked_indices();const{lod_factor:l}=this.plot_model,n=this.all_indices.count;this.decimated=new _.Indices(n);for(let e=0;e<n;e+=l)this.decimated.set(e);this.set_data_timestamp=Date.now(),e&&this.request_render()}set_visuals(){var e,t,i,s;const l=this.model.data_source,{all_indices:n}=this;this.glyph.set_visuals(l,n),this.decimated_glyph.set_visuals(l,n),null===(e=this.selection_glyph)||void 0===e||e.set_visuals(l,n),null===(t=this.nonselection_glyph)||void 0===t||t.set_visuals(l,n),null===(i=this.hover_glyph)||void 0===i||i.set_visuals(l,n),null===(s=this.muted_glyph)||void 0===s||s.set_visuals(l,n)}get has_webgl(){return this.glyph.has_webgl}_render(){const e=this.has_webgl;this.glyph.map_data();const t=[...this.all_indices];let i=[...this._update_masked_indices()];const{ctx:s}=this.layer;s.save();const{selected:l}=this.model.data_source;let c;c=!l||l.is_empty()?[]:this.glyph instanceof n.LineView&&l.selected_glyph===this.glyph.model?this.model.view.convert_indices_from_subset(i):l.indices;const{inspected:_}=this.model.data_source,d=new Set((()=>!_||_.is_empty()?[]:_.selected_glyph?this.model.view.convert_indices_from_subset(i):_.indices.length>0?_.indices:Object.keys(_.multiline_indices).map(e=>parseInt(e)))()),g=r.filter(i,e=>d.has(t[e])),{lod_threshold:u}=this.plot_model;let y,m,v;if(null!=this.model.document&&this.model.document.interactive_duration()>0&&!e&&null!=u&&t.length>u?(i=[...this.decimated],y=this.decimated_glyph,m=this.decimated_glyph,v=this.selection_glyph):(y=this.model.muted&&null!=this.muted_glyph?this.muted_glyph:this.glyph,m=this.nonselection_glyph,v=this.selection_glyph),null!=this.hover_glyph&&g.length&&(i=p.difference(i,g)),c.length){const e={};for(const t of c)e[t]=!0;const l=new Array,h=new Array;if(this.glyph instanceof n.LineView)for(const i of t)null!=e[i]?l.push(i):h.push(i);else for(const s of i)null!=e[t[s]]?l.push(s):h.push(s);m.render(s,h,this.glyph),v.render(s,l,this.glyph),null!=this.hover_glyph&&(this.glyph instanceof n.LineView?this.hover_glyph.render(s,this.model.view.convert_indices_from_subset(g),this.glyph):this.hover_glyph.render(s,g,this.glyph))}else if(this.glyph instanceof n.LineView)this.hover_glyph&&g.length?this.hover_glyph.render(s,this.model.view.convert_indices_from_subset(g),this.glyph):y.render(s,t,this.glyph);else if(this.glyph instanceof h.PatchView||this.glyph instanceof o.HAreaView||this.glyph instanceof a.VAreaView)if(0==_.selected_glyphs.length||null==this.hover_glyph)y.render(s,t,this.glyph);else for(const e of _.selected_glyphs)e==this.glyph.model&&this.hover_glyph.render(s,t,this.glyph);else y.render(s,i,this.glyph),this.hover_glyph&&g.length&&this.hover_glyph.render(s,g,this.glyph);s.restore()}draw_legend(e,t,i,s,l,n,h,o){null==o&&(o=this.model.get_reference_point(n,h)),this.glyph.draw_legend_for_index(e,{x0:t,x1:i,y0:s,y1:l},o)}hit_test(e){if(!this.model.visible)return null;const t=this.glyph.hit_test(e);return null==t?null:this.model.view.convert_selection_from_subset(t)}}i.GlyphRendererView=w,w.__name__="GlyphRendererView";class b extends l.DataRenderer{constructor(e){super(e)}static init_GlyphRenderer(){this.prototype.default_view=w,this.define({data_source:[d.Instance],view:[d.Instance,()=>new c.CDSView],glyph:[d.Instance],hover_glyph:[d.Instance],nonselection_glyph:[d.Any,"auto"],selection_glyph:[d.Any,"auto"],muted_glyph:[d.Instance],muted:[d.Boolean,!1]})}initialize(){super.initialize(),null==this.view.source&&(this.view.source=this.data_source,this.view.compute_indices())}get_reference_point(e,t){let i=0;if(null!=e){const s=this.data_source.get_column(e);if(null!=s){const e=r.indexOf(s,t);-1!=e&&(i=e)}}return i}get_selection_manager(){return this.data_source.selection_manager}}i.GlyphRenderer=b,b.__name__="GlyphRenderer",b.init_GlyphRenderer()},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});const a=e(70);class n extends a.RendererView{get xscale(){return this.coordinates.x_scale}get yscale(){return this.coordinates.y_scale}}t.DataRendererView=n,n.__name__="DataRendererView";class s extends a.Renderer{constructor(e){super(e)}static init_DataRenderer(){this.override({level:"glyph"})}}t.DataRenderer=s,s.__name__="DataRenderer",s.init_DataRenderer()},
function _(e,i,t){Object.defineProperty(t,"__esModule",{value:!0});const s=e(1),n=e(93),l=e(100),_=e(102),r=s.__importStar(e(28)),o=s.__importStar(e(101)),h=e(88);class a extends n.XYGlyphView{initialize(){super.initialize();const{webgl:e}=this.renderer.plot_view.canvas_view;null!=e&&(this.glglyph=new _.LineGL(e.gl,this))}_render(e,i,{sx:t,sy:s}){let n=!1,l=null;this.visuals.line.set_value(e);for(const _ of i){if(n){if(!isFinite(t[_]+s[_])){e.stroke(),e.beginPath(),n=!1,l=_;continue}null!=l&&_-l>1&&(e.stroke(),n=!1)}n?e.lineTo(t[_],s[_]):(e.beginPath(),e.moveTo(t[_],s[_]),n=!0),l=_}n&&e.stroke()}_hit_point(e){const i=new h.Selection,t={x:e.sx,y:e.sy};let s=9999;const n=Math.max(2,this.visuals.line.line_width.value()/2);for(let e=0,l=this.sx.length-1;e<l;e++){const l={x:this.sx[e],y:this.sy[e]},_={x:this.sx[e+1],y:this.sy[e+1]},r=o.dist_to_segment(t,l,_);r<n&&r<s&&(s=r,i.add_to_selected_glyphs(this.model),i.view=this,i.line_indices=[e])}return i}_hit_span(e){const{sx:i,sy:t}=e,s=new h.Selection;let n,l;"v"==e.direction?(n=this.renderer.yscale.invert(t),l=this._y):(n=this.renderer.xscale.invert(i),l=this._x);for(let e=0,i=l.length-1;e<i;e++)(l[e]<=n&&n<=l[e+1]||l[e+1]<=n&&n<=l[e])&&(s.add_to_selected_glyphs(this.model),s.view=this,s.line_indices.push(e));return s}get_interpolation_hit(e,i){const[t,s,n,_]=[this._x[e],this._y[e],this._x[e+1],this._y[e+1]];return l.line_interpolation(this.renderer,i,t,s,n,_)}draw_legend_for_index(e,i,t){l.generic_line_legend(this.visuals,e,i,t)}}t.LineView=a,a.__name__="LineView";class c extends n.XYGlyph{constructor(e){super(e)}static init_Line(){this.prototype.default_view=a,this.mixins(r.Line)}}t.Line=c,c.__name__="Line",c.init_Line()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(1),_=e(37),n=s.__importStar(e(18)),a=e(94);class d extends a.GlyphView{_project_data(){_.inplace.project_xy(this._x,this._y)}_index_data(e){const{data_size:t}=this;for(let i=0;i<t;i++){const t=this._x[i],s=this._y[i];isNaN(t+s)||!isFinite(t+s)?e.add_empty():e.add(t,s,t,s)}}scenterxy(e){return[this.sx[e],this.sy[e]]}}i.XYGlyphView=d,d.__name__="XYGlyphView";class p extends a.Glyph{constructor(e){super(e)}static init_XYGlyph(){this.define({x:[n.XCoordinateSpec,{field:"x"}],y:[n.YCoordinateSpec,{field:"y"}]})}}i.XYGlyph=p,p.__name__="XYGlyph",p.init_XYGlyph()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(1),n=s.__importStar(e(18)),r=s.__importStar(e(79)),a=s.__importStar(e(74)),_=e(71),l=e(81),o=e(19),h=e(24),d=e(12),c=e(95),u=e(98),p=e(88);class y extends _.View{constructor(){super(...arguments),this._index=null,this._data_size=null,this._nohit_warned=new Set}get renderer(){return this.parent}get has_webgl(){return null!=this.glglyph}get index(){const{_index:e}=this;if(null!=e)return e;throw new Error(this+".index_data() wasn't called")}get data_size(){const{_data_size:e}=this;if(null!=e)return e;throw new Error(this+".set_data() wasn't called")}initialize(){super.initialize(),this.visuals=new a.Visuals(this.model)}set_visuals(e,t){this.visuals.warm_cache(e,t),null!=this.glglyph&&this.glglyph.set_visuals_changed()}render(e,t,i){e.beginPath(),null!=this.glglyph&&(this.renderer.needs_webgl_blit=this.glglyph.render(e,t,i),this.renderer.needs_webgl_blit)||this._render(e,t,i)}has_finished(){return!0}notify_finished(){this.renderer.notify_finished()}_bounds(e){return e}bounds(){return this._bounds(this.index.bbox)}log_bounds(){const{x0:e,x1:t}=this.index.bounds(r.positive_x()),{y0:i,y1:s}=this.index.bounds(r.positive_y());return this._bounds({x0:e,y0:i,x1:t,y1:s})}get_anchor_point(e,t,[i,s]){switch(e){case"center":{const[e,n]=this.scenterxy(t,i,s);return{x:e,y:n}}default:return null}}scenterx(e,t,i){return this.scenterxy(e,t,i)[0]}scentery(e,t,i){return this.scenterxy(e,t,i)[1]}sdist(e,t,i,s="edge",n=!1){let r,a;const _=t.length;if("center"==s){const e=d.map(i,e=>e/2);r=new h.NumberArray(_);for(let i=0;i<_;i++)r[i]=t[i]-e[i];a=new h.NumberArray(_);for(let i=0;i<_;i++)a[i]=t[i]+e[i]}else{r=t,a=new h.NumberArray(_);for(let e=0;e<_;e++)a[e]=r[e]+i[e]}const l=e.v_compute(r),o=e.v_compute(a);return n?d.map(l,(e,t)=>Math.ceil(Math.abs(o[t]-l[t]))):d.map(l,(e,t)=>Math.abs(o[t]-l[t]))}draw_legend_for_index(e,t,i){}hit_test(e){switch(e.type){case"point":if(null!=this._hit_point)return this._hit_point(e);break;case"span":if(null!=this._hit_span)return this._hit_span(e);break;case"rect":if(null!=this._hit_rect)return this._hit_rect(e);break;case"poly":if(null!=this._hit_poly)return this._hit_poly(e)}return this._nohit_warned.has(e.type)||(o.logger.debug(`'${e.type}' selection not available for ${this.model.type}`),this._nohit_warned.add(e.type)),null}_hit_rect_against_index(e){const{sx0:t,sx1:i,sy0:s,sy1:n}=e,[r,a]=this.renderer.coordinates.x_scale.r_invert(t,i),[_,l]=this.renderer.coordinates.y_scale.r_invert(s,n),o=[...this.index.indices({x0:r,x1:a,y0:_,y1:l})];return new p.Selection({indices:o})}_project_data(){}set_data(e,t,i){var s,r;const{x_range:a,y_range:_}=this.renderer.coordinates;this._data_size=null!==(s=e.get_length())&&void 0!==s?s:1;for(const i of this.model){if(!(i instanceof n.VectorSpec))continue;if(i.optional&&null==i.spec.value&&!i.dirty)continue;const s=i.attr,r=i.array(e);let l=t.select(r);if(i instanceof n.BaseCoordinateSpec){const e="x"==i.dimension?a:_;if(e instanceof u.FactorRange)if(i instanceof n.CoordinateSpec)l=e.v_synthetic(l);else if(i instanceof n.CoordinateSeqSpec)for(let t=0;t<l.length;t++)l[t]=e.v_synthetic(l[t]);i instanceof n.CoordinateSeqSpec&&(l=h.RaggedArray.from(l))}else i instanceof n.DistanceSpec&&(this["max_"+s]=d.max(l));this["_"+s]=l}this.renderer.plot_view.model.use_map&&this._project_data(),this._set_data(i),null===(r=this.glglyph)||void 0===r||r.set_data_changed(),this.index_data()}_set_data(e){}get _index_size(){return this.data_size}index_data(){const e=new c.SpatialIndex(this._index_size);this._index_data(e),e.finish(),this._index=e}mask_data(){return null!=this.glglyph||null==this._mask_data?h.Indices.all_set(this.data_size):this._mask_data()}map_data(){var e;const t=this,{x_scale:i,y_scale:s}=this.renderer.coordinates;for(const e of this.model)if(e instanceof n.BaseCoordinateSpec){const n="x"==e.dimension?i:s;let r=t["_"+e.attr];if(r instanceof h.RaggedArray){const e=n.v_compute(r.array);r=new h.RaggedArray(r.offsets,e)}else r=n.v_compute(r);this["s"+e.attr]=r}this._map_data(),null===(e=this.glglyph)||void 0===e||e.set_data_changed()}_map_data(){}}i.GlyphView=y,y.__name__="GlyphView";class g extends l.Model{constructor(e){super(e)}static init_Glyph(){}}i.Glyph=g,g.__name__="Glyph",g.init_Glyph()},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});const i=e(1).__importDefault(e(96)),s=e(24),o=e(79);function d(e,n){let t=0,i=n.length-1;for(;t<i;){const s=t+i>>1;n[s]>e?i=s:t=s+1}return n[t]}class x extends i.default{search_indices(e,n,t,i){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");let o=this._boxes.length-4;const x=[],h=new s.Indices(this.numItems);for(;void 0!==o;){const s=Math.min(o+4*this.nodeSize,d(o,this._levelBounds));for(let d=o;d<s;d+=4){const s=0|this._indices[d>>2];t<this._boxes[d+0]||(i<this._boxes[d+1]||e>this._boxes[d+2]||n>this._boxes[d+3]||(o<4*this.numItems?h.set(s):x.push(s)))}o=x.pop()}return h}}x.__name__="_FlatBush";class h{constructor(e){this.index=null,e>0&&(this.index=new x(e))}add(e,n,t,i){var s;null===(s=this.index)||void 0===s||s.add(e,n,t,i)}add_empty(){var e;null===(e=this.index)||void 0===e||e.add(1/0,1/0,-1/0,-1/0)}finish(){var e;null===(e=this.index)||void 0===e||e.finish()}_normalize(e){let{x0:n,y0:t,x1:i,y1:s}=e;return n>i&&([n,i]=[i,n]),t>s&&([t,s]=[s,t]),{x0:n,y0:t,x1:i,y1:s}}get bbox(){if(null==this.index)return o.empty();{const{minX:e,minY:n,maxX:t,maxY:i}=this.index;return{x0:e,y0:n,x1:t,y1:i}}}indices(e){if(null==this.index)return new s.Indices(0);{const{x0:n,y0:t,x1:i,y1:s}=this._normalize(e);return this.index.search_indices(n,t,i,s)}}bounds(e){const n=o.empty();for(const t of this.indices(e)){const e=this.index._boxes,i=e[4*t+0],s=e[4*t+1],o=e[4*t+2],d=e[4*t+3];o<n.x0&&(n.x0=o),i>n.x1&&(n.x1=i),d<n.y0&&(n.y0=d),s>n.y1&&(n.y1=s)}return n}}t.SpatialIndex=h,h.__name__="SpatialIndex"},
function _(t,s,i){Object.defineProperty(i,"__esModule",{value:!0});const e=t(1).__importDefault(t(97)),h=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class n{static from(t){if(!(t instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[s,i]=new Uint8Array(t,0,2);if(251!==s)throw new Error("Data does not appear to be in a Flatbush format.");if(i>>4!=3)throw new Error(`Got v${i>>4} data when expected v3.`);const[e]=new Uint16Array(t,2,1),[o]=new Uint32Array(t,4,1);return new n(o,e,h[15&i],t)}constructor(t,s=16,i=Float64Array,n){if(void 0===t)throw new Error("Missing required argument: numItems.");if(isNaN(t)||t<=0)throw new Error(`Unpexpected numItems value: ${t}.`);this.numItems=+t,this.nodeSize=Math.min(Math.max(+s,2),65535);let o=t,r=o;this._levelBounds=[4*o];do{o=Math.ceil(o/this.nodeSize),r+=o,this._levelBounds.push(4*r)}while(1!==o);this.ArrayType=i||Float64Array,this.IndexArrayType=r<16384?Uint16Array:Uint32Array;const a=h.indexOf(this.ArrayType),_=4*r*this.ArrayType.BYTES_PER_ELEMENT;if(a<0)throw new Error(`Unexpected typed array class: ${i}.`);n&&n instanceof ArrayBuffer?(this.data=n,this._boxes=new this.ArrayType(this.data,8,4*r),this._indices=new this.IndexArrayType(this.data,8+_,r),this._pos=4*r,this.minX=this._boxes[this._pos-4],this.minY=this._boxes[this._pos-3],this.maxX=this._boxes[this._pos-2],this.maxY=this._boxes[this._pos-1]):(this.data=new ArrayBuffer(8+_+r*this.IndexArrayType.BYTES_PER_ELEMENT),this._boxes=new this.ArrayType(this.data,8,4*r),this._indices=new this.IndexArrayType(this.data,8+_,r),this._pos=0,this.minX=1/0,this.minY=1/0,this.maxX=-1/0,this.maxY=-1/0,new Uint8Array(this.data,0,2).set([251,48+a]),new Uint16Array(this.data,2,1)[0]=s,new Uint32Array(this.data,4,1)[0]=t),this._queue=new e.default}add(t,s,i,e){const h=this._pos>>2;return this._indices[h]=h,this._boxes[this._pos++]=t,this._boxes[this._pos++]=s,this._boxes[this._pos++]=i,this._boxes[this._pos++]=e,t<this.minX&&(this.minX=t),s<this.minY&&(this.minY=s),i>this.maxX&&(this.maxX=i),e>this.maxY&&(this.maxY=e),h}finish(){if(this._pos>>2!==this.numItems)throw new Error(`Added ${this._pos>>2} items when expected ${this.numItems}.`);if(this.numItems<=this.nodeSize)return this._boxes[this._pos++]=this.minX,this._boxes[this._pos++]=this.minY,this._boxes[this._pos++]=this.maxX,void(this._boxes[this._pos++]=this.maxY);const t=this.maxX-this.minX,s=this.maxY-this.minY,i=new Uint32Array(this.numItems);for(let e=0;e<this.numItems;e++){let h=4*e;const n=this._boxes[h++],o=this._boxes[h++],r=this._boxes[h++],a=this._boxes[h++],d=Math.floor(65535*((n+r)/2-this.minX)/t),x=Math.floor(65535*((o+a)/2-this.minY)/s);i[e]=_(d,x)}!function t(s,i,e,h,n,o){if(Math.floor(h/o)>=Math.floor(n/o))return;const r=s[h+n>>1];let _=h-1,d=n+1;for(;;){do{_++}while(s[_]<r);do{d--}while(s[d]>r);if(_>=d)break;a(s,i,e,_,d)}t(s,i,e,h,d,o),t(s,i,e,d+1,n,o)}(i,this._boxes,this._indices,0,this.numItems-1,this.nodeSize);for(let t=0,s=0;t<this._levelBounds.length-1;t++){const i=this._levelBounds[t];for(;s<i;){const t=s;let e=1/0,h=1/0,n=-1/0,o=-1/0;for(let t=0;t<this.nodeSize&&s<i;t++)e=Math.min(e,this._boxes[s++]),h=Math.min(h,this._boxes[s++]),n=Math.max(n,this._boxes[s++]),o=Math.max(o,this._boxes[s++]);this._indices[this._pos>>2]=t,this._boxes[this._pos++]=e,this._boxes[this._pos++]=h,this._boxes[this._pos++]=n,this._boxes[this._pos++]=o}}}search(t,s,i,e,h){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");let n=this._boxes.length-4;const o=[],a=[];for(;void 0!==n;){const _=Math.min(n+4*this.nodeSize,r(n,this._levelBounds));for(let r=n;r<_;r+=4){const _=0|this._indices[r>>2];i<this._boxes[r]||(e<this._boxes[r+1]||t>this._boxes[r+2]||s>this._boxes[r+3]||(n<4*this.numItems?(void 0===h||h(_))&&a.push(_):o.push(_)))}n=o.pop()}return a}neighbors(t,s,i=1/0,e=1/0,h){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");let n=this._boxes.length-4;const a=this._queue,_=[],d=e*e;for(;void 0!==n;){const e=Math.min(n+4*this.nodeSize,r(n,this._levelBounds));for(let i=n;i<e;i+=4){const e=0|this._indices[i>>2],r=o(t,this._boxes[i],this._boxes[i+2]),_=o(s,this._boxes[i+1],this._boxes[i+3]),d=r*r+_*_;n<4*this.numItems?(void 0===h||h(e))&&a.push(-e-1,d):a.push(e,d)}for(;a.length&&a.peek()<0;){if(a.peekValue()>d)return a.clear(),_;if(_.push(-a.pop()-1),_.length===i)return a.clear(),_}n=a.pop()}return a.clear(),_}}function o(t,s,i){return t<s?s-t:t<=i?0:t-i}function r(t,s){let i=0,e=s.length-1;for(;i<e;){const h=i+e>>1;s[h]>t?e=h:i=h+1}return s[i]}function a(t,s,i,e,h){const n=t[e];t[e]=t[h],t[h]=n;const o=4*e,r=4*h,a=s[o],_=s[o+1],d=s[o+2],x=s[o+3];s[o]=s[r],s[o+1]=s[r+1],s[o+2]=s[r+2],s[o+3]=s[r+3],s[r]=a,s[r+1]=_,s[r+2]=d,s[r+3]=x;const l=i[e];i[e]=i[h],i[h]=l}function _(t,s){let i=t^s,e=65535^i,h=65535^(t|s),n=t&(65535^s),o=i|e>>1,r=i>>1^i,a=h>>1^e&n>>1^h,_=i&h>>1^n>>1^n;i=o,e=r,h=a,n=_,o=i&i>>2^e&e>>2,r=i&e>>2^e&(i^e)>>2,a^=i&h>>2^e&n>>2,_^=e&h>>2^(i^e)&n>>2,i=o,e=r,h=a,n=_,o=i&i>>4^e&e>>4,r=i&e>>4^e&(i^e)>>4,a^=i&h>>4^e&n>>4,_^=e&h>>4^(i^e)&n>>4,i=o,e=r,h=a,n=_,a^=i&h>>8^e&n>>8,_^=e&h>>8^(i^e)&n>>8,i=a^a>>1,e=_^_>>1;let d=t^s,x=e|65535^(d|i);return d=16711935&(d|d<<8),d=252645135&(d|d<<4),d=858993459&(d|d<<2),d=1431655765&(d|d<<1),x=16711935&(x|x<<8),x=252645135&(x|x<<4),x=858993459&(x|x<<2),x=1431655765&(x|x<<1),(x<<1|d)>>>0}i.default=n},
function _(s,t,i){Object.defineProperty(i,"__esModule",{value:!0});i.default=class{constructor(){this.ids=[],this.values=[],this.length=0}clear(){this.length=0}push(s,t){let i=this.length++;for(this.ids[i]=s,this.values[i]=t;i>0;){const s=i-1>>1,h=this.values[s];if(t>=h)break;this.ids[i]=this.ids[s],this.values[i]=h,i=s}this.ids[i]=s,this.values[i]=t}pop(){if(0===this.length)return;const s=this.ids[0];if(this.length--,this.length>0){const s=this.ids[0]=this.ids[this.length],t=this.values[0]=this.values[this.length],i=this.length>>1;let h=0;for(;h<i;){let s=1+(h<<1);const i=s+1;let e=this.ids[s],l=this.values[s];const n=this.values[i];if(i<this.length&&n<l&&(s=i,e=this.ids[i],l=n),l>=t)break;this.ids[h]=e,this.values[h]=l,h=s}this.ids[h]=s,this.values[h]=t}return s}peek(){if(0!==this.length)return this.ids[0]}peekValue(){if(0!==this.length)return this.values[0]}}},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});const s=t(1),i=t(99),r=s.__importStar(t(18)),a=t(24),o=t(9),p=t(8),g=t(11);function c(t,e,n=0){const s=new Map;for(let i=0;i<t.length;i++){const r=t[i];if(s.has(r))throw new Error("duplicate factor or subfactor: "+r);s.set(r,{value:.5+i*(1+e)+n})}return[s,(t.length-1)*e]}function l(t,e,n,s=0){var i;const r=new Map,a=new Map;for(const[e,n]of t){const t=null!==(i=a.get(e))&&void 0!==i?i:[];a.set(e,[...t,n])}let p=s,g=0;for(const[t,s]of a){const i=s.length,[a,l]=c(s,n,p);g+=l;const u=o.sum(s.map(t=>a.get(t).value));r.set(t,{value:u/i,mapping:a}),p+=i+e+l}return[r,(a.size-1)*e+g]}function u(t,e,n,s,i=0){var r;const a=new Map,p=new Map;for(const[e,n,s]of t){const t=null!==(r=p.get(e))&&void 0!==r?r:[];p.set(e,[...t,[n,s]])}let g=i,c=0;for(const[t,i]of p){const r=i.length,[p,u]=l(i,n,s,g);c+=u;const h=o.sum(i.map(([t])=>p.get(t).value));a.set(t,{value:h/r,mapping:p}),g+=r+e+u}return[a,(p.size-1)*e+c]}n.map_one_level=c,n.map_two_levels=l,n.map_three_levels=u;class h extends i.Range{constructor(t){super(t)}static init_FactorRange(){this.define({factors:[r.Array,[]],factor_padding:[r.Number,0],subgroup_padding:[r.Number,.8],group_padding:[r.Number,1.4],range_padding:[r.Number,0],range_padding_units:[r.PaddingUnits,"percent"],start:[r.Number],end:[r.Number]}),this.internal({levels:[r.Number],mids:[r.Array,null],tops:[r.Array,null]})}get min(){return this.start}get max(){return this.end}initialize(){super.initialize(),this._init(!0)}connect_signals(){super.connect_signals(),this.connect(this.properties.factors.change,()=>this.reset()),this.connect(this.properties.factor_padding.change,()=>this.reset()),this.connect(this.properties.group_padding.change,()=>this.reset()),this.connect(this.properties.subgroup_padding.change,()=>this.reset()),this.connect(this.properties.range_padding.change,()=>this.reset()),this.connect(this.properties.range_padding_units.change,()=>this.reset())}reset(){this._init(!1),this.change.emit()}_lookup(t){switch(t.length){case 1:{const[e]=t,n=this._mapping.get(e);return null!=n?n.value:NaN}case 2:{const[e,n]=t,s=this._mapping.get(e);if(null!=s){const t=s.mapping.get(n);if(null!=t)return t.value}return NaN}case 3:{const[e,n,s]=t,i=this._mapping.get(e);if(null!=i){const t=i.mapping.get(n);if(null!=t){const e=t.mapping.get(s);if(null!=e)return e.value}}return NaN}default:g.unreachable()}}synthetic(t){if(p.isNumber(t))return t;if(p.isString(t))return this._lookup([t]);let e=0;const n=t[t.length-1];return p.isNumber(n)&&(e=n,t=t.slice(0,-1)),this._lookup(t)+e}v_synthetic(t){const e=t.length,n=new a.NumberArray(e);for(let s=0;s<e;s++)n[s]=this.synthetic(t[s]);return n}_init(t){const{levels:e,mapping:n,tops:s,mids:i,inside_padding:r}=(()=>{if(o.every(this.factors,p.isString)){const t=this.factors,[e,n]=c(t,this.factor_padding);return{levels:1,mapping:e,tops:null,mids:null,inside_padding:n}}if(o.every(this.factors,t=>p.isArray(t)&&2==t.length&&p.isString(t[0])&&p.isString(t[1]))){const t=this.factors,[e,n]=l(t,this.group_padding,this.factor_padding),s=[...e.keys()];return{levels:2,mapping:e,tops:s,mids:null,inside_padding:n}}if(o.every(this.factors,t=>p.isArray(t)&&3==t.length&&p.isString(t[0])&&p.isString(t[1])&&p.isString(t[2]))){const t=this.factors,[e,n]=u(t,this.group_padding,this.subgroup_padding,this.factor_padding),s=[...e.keys()],i=[];for(const[t,n]of e)for(const e of n.mapping.keys())i.push([t,e]);return{levels:3,mapping:e,tops:s,mids:i,inside_padding:n}}g.unreachable()})();this._mapping=n,this.tops=s,this.mids=i;let a=0,h=this.factors.length+r;if("percent"==this.range_padding_units){const t=(h-a)*this.range_padding/2;a-=t,h+=t}else a-=this.range_padding,h+=this.range_padding;this.setv({start:a,end:h,levels:e},{silent:t}),"auto"==this.bounds&&this.setv({bounds:[a,h]},{silent:!0})}}n.FactorRange=h,h.__name__="FactorRange",h.init_FactorRange()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const n=e(1),s=e(81),a=n.__importStar(e(18));class r extends s.Model{constructor(e){super(e),this.have_updated_interactively=!1}static init_Range(){this.define({bounds:[a.Any],min_interval:[a.Any],max_interval:[a.Any]}),this.internal({plots:[a.Array,[]]})}get is_reversed(){return this.start>this.end}get is_valid(){return!isNaN(this.min)&&!isNaN(this.max)}}i.Range=r,r.__name__="Range",r.init_Range()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const n=e(1).__importStar(e(101));i.generic_line_legend=function(e,t,{x0:i,x1:n,y0:c,y1:o},r){t.save(),t.beginPath(),t.moveTo(i,(c+o)/2),t.lineTo(n,(c+o)/2),e.line.doit&&(e.line.set_vectorize(t,r),t.stroke()),t.restore()},i.generic_area_legend=function(e,t,{x0:i,x1:n,y0:c,y1:o},r){const l=.1*Math.abs(n-i),a=.1*Math.abs(o-c),s=i+l,_=n-l,h=c+a,v=o-a;e.fill.doit&&(e.fill.set_vectorize(t,r),t.fillRect(s,h,_-s,v-h)),null!=e.hatch&&e.hatch.doit&&(e.hatch.set_vectorize(t,r),t.fillRect(s,h,_-s,v-h)),e.line&&e.line.doit&&(t.beginPath(),t.rect(s,h,_-s,v-h),e.line.set_vectorize(t,r),t.stroke())},i.line_interpolation=function(e,t,i,c,o,r){const{sx:l,sy:a}=t;let s,_,h,v;"point"==t.type?([h,v]=e.yscale.r_invert(a-1,a+1),[s,_]=e.xscale.r_invert(l-1,l+1)):"v"==t.direction?([h,v]=e.yscale.r_invert(a,a),[s,_]=[Math.min(i-1,o-1),Math.max(i+1,o+1)]):([s,_]=e.xscale.r_invert(l,l),[h,v]=[Math.min(c-1,r-1),Math.max(c+1,r+1)]);const{x,y}=n.check_2_segments_intersect(s,h,_,v,i,c,o,r);return[x,y]}},
function _(t,n,e){function i(t,n){return(t.x-n.x)**2+(t.y-n.y)**2}function r(t,n,e){const r=i(n,e);if(0==r)return i(t,n);const s=((t.x-n.x)*(e.x-n.x)+(t.y-n.y)*(e.y-n.y))/r;if(s<0)return i(t,n);if(s>1)return i(t,e);return i(t,{x:n.x+s*(e.x-n.x),y:n.y+s*(e.y-n.y)})}Object.defineProperty(e,"__esModule",{value:!0}),e.point_in_poly=function(t,n,e,i){let r=!1,s=e[e.length-1],o=i[i.length-1];for(let u=0;u<e.length;u++){const c=e[u],_=i[u];o<n!=_<n&&s+(n-o)/(_-o)*(c-s)<t&&(r=!r),s=c,o=_}return r},e.point_in_ellipse=function(t,n,e,i,r,s,o){return((Math.cos(e)/r)**2+(Math.sin(e)/i)**2)*(t-s)**2+2*Math.cos(e)*Math.sin(e)*((1/r)**2-(1/i)**2)*(t-s)*(n-o)+((Math.cos(e)/i)**2+(Math.sin(e)/r)**2)*(n-o)**2<=1},e.dist_2_pts=i,e.dist_to_segment_squared=r,e.dist_to_segment=function(t,n,e){return Math.sqrt(r(t,n,e))},e.check_2_segments_intersect=function(t,n,e,i,r,s,o,u){const c=(u-s)*(e-t)-(o-r)*(i-n);if(0==c)return{hit:!1,x:null,y:null};{let _=n-s,l=t-r;const y=(e-t)*_-(i-n)*l;_=((o-r)*_-(u-s)*l)/c,l=y/c;return{hit:_>0&&_<1&&l>0&&l<1,x:t+_*(e-t),y:n+_*(i-n)}}}},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const i=t(103),a=t(107),n=t(108),o=t(109),_=t(22);class h{constructor(t){this._atlas=new Map,this._width=256,this._height=256,this.tex=new i.Texture2d(t),this.tex.set_wrapping(t.REPEAT,t.REPEAT),this.tex.set_interpolation(t.NEAREST,t.NEAREST),this.tex.set_size([this._width,this._height],t.RGBA),this.tex.set_data([0,0],[this._width,this._height],new Uint8Array(4*this._width*this._height)),this.get_atlas_data([1])}get_atlas_data(t){const e=t.join("-");let s=this._atlas.get(e);if(null==s){const[i,a]=this.make_pattern(t),n=this._atlas.size;this.tex.set_data([0,n],[this._width,1],new Uint8Array(i.map(t=>t+10))),s=[n/this._height,a],this._atlas.set(e,s)}return s}make_pattern(t){t.length>1&&t.length%2&&(t=t.concat(t));let e=0;for(const s of t)e+=s;const s=[];let i=0;for(let e=0,a=t.length+2;e<a;e+=2){const a=Math.max(1e-4,t[e%t.length]),n=Math.max(1e-4,t[(e+1)%t.length]);s.push(i,i+a),i+=a+n}const a=this._width,n=new Float32Array(4*a);for(let t=0,i=a;t<i;t++){let i,o,_;const h=e*t/(a-1);let r=0,l=1e16;for(let t=0,e=s.length;t<e;t++){const e=Math.abs(s[t]-h);e<l&&(r=t,l=e)}r%2==0?(_=h<=s[r]?1:0,o=s[r],i=s[r+1]):(_=h>s[r]?-1:0,o=s[r-1],i=s[r]),n[4*t+0]=s[r],n[4*t+1]=_,n[4*t+2]=o,n[4*t+3]=i}return[n,e]}}h.__name__="DashAtlas";const r={miter:0,round:1,bevel:2},l={"":0,none:0,".":0,round:1,")":1,"(":1,o:1,"triangle in":2,"<":2,"triangle out":3,">":3,square:4,"[":4,"]":4,"=":4,butt:5,"|":5};class g extends a.BaseGLGlyph{init(){const{gl:t}=this;this._scale_aspect=0;const e=n.vertex_shader,s=o.fragment_shader;this.prog=new i.Program(t),this.prog.set_shaders(e,s),this.index_buffer=new i.IndexBuffer(t),this.vbo_position=new i.VertexBuffer(t),this.vbo_tangents=new i.VertexBuffer(t),this.vbo_segment=new i.VertexBuffer(t),this.vbo_angles=new i.VertexBuffer(t),this.vbo_texcoord=new i.VertexBuffer(t),this.dash_atlas=new h(t)}draw(t,e,s){const i=e.glglyph;if(i.data_changed&&(i._set_data(),i.data_changed=!1),this.visuals_changed&&(this._set_visuals(),this.visuals_changed=!1),i._update_scale(1,1),this._scale_aspect=1,this.prog.set_attribute("a_position","vec2",i.vbo_position),this.prog.set_attribute("a_tangents","vec4",i.vbo_tangents),this.prog.set_attribute("a_segment","vec2",i.vbo_segment),this.prog.set_attribute("a_angles","vec2",i.vbo_angles),this.prog.set_attribute("a_texcoord","vec2",i.vbo_texcoord),this.prog.set_uniform("u_length","float",[i.cumsum]),this.prog.set_texture("u_dash_atlas",this.dash_atlas.tex),this.prog.set_uniform("u_pixel_ratio","float",[s.pixel_ratio]),this.prog.set_uniform("u_canvas_size","vec2",[s.width,s.height]),this.prog.set_uniform("u_scale_aspect","vec2",[1,1]),this.prog.set_uniform("u_scale_length","float",[Math.sqrt(2)]),this.I_triangles=i.I_triangles,this.I_triangles.length<65535)this.index_buffer.set_size(2*this.I_triangles.length),this.index_buffer.set_data(0,new Uint16Array(this.I_triangles)),this.prog.draw(this.gl.TRIANGLES,this.index_buffer);else{t=Array.from(this.I_triangles);const e=this.I_triangles.length,s=64008,a=[];for(let t=0,i=Math.ceil(e/s);t<i;t++)a.push([]);for(let e=0,i=t.length;e<i;e++){const i=t[e]%s;a[Math.floor(t[e]/s)].push(i)}for(let t=0,e=a.length;t<e;t++){const e=new Uint16Array(a[t]),n=t*s*4;0!==e.length&&(this.prog.set_attribute("a_position","vec2",i.vbo_position,0,2*n),this.prog.set_attribute("a_tangents","vec4",i.vbo_tangents,0,4*n),this.prog.set_attribute("a_segment","vec2",i.vbo_segment,0,2*n),this.prog.set_attribute("a_angles","vec2",i.vbo_angles,0,2*n),this.prog.set_attribute("a_texcoord","vec2",i.vbo_texcoord,0,2*n),this.index_buffer.set_size(2*e.length),this.index_buffer.set_data(0,e),this.prog.draw(this.gl.TRIANGLES,this.index_buffer))}}}_set_data(){this._bake(),this.vbo_position.set_size(4*this.V_position.length),this.vbo_position.set_data(0,this.V_position),this.vbo_tangents.set_size(4*this.V_tangents.length),this.vbo_tangents.set_data(0,this.V_tangents),this.vbo_angles.set_size(4*this.V_angles.length),this.vbo_angles.set_data(0,this.V_angles),this.vbo_texcoord.set_size(4*this.V_texcoord.length),this.vbo_texcoord.set_data(0,this.V_texcoord)}_set_visuals(){const t=_.color2rgba(this.glyph.visuals.line.line_color.value(),this.glyph.visuals.line.line_alpha.value()),e=l[this.glyph.visuals.line.line_cap.value()],s=r[this.glyph.visuals.line.line_join.value()];this.prog.set_uniform("u_color","vec4",t),this.prog.set_uniform("u_linewidth","float",[this.glyph.visuals.line.line_width.value()]),this.prog.set_uniform("u_antialias","float",[.9]),this.prog.set_uniform("u_linecaps","vec2",[e,e]),this.prog.set_uniform("u_linejoin","float",[s]),this.prog.set_uniform("u_miter_limit","float",[10]);const i=this.glyph.visuals.line.line_dash.value();let a=0,n=1;i.length&&([a,n]=this.dash_atlas.get_atlas_data(i)),this.prog.set_uniform("u_dash_index","float",[a]),this.prog.set_uniform("u_dash_phase","float",[this.glyph.visuals.line.line_dash_offset.value()]),this.prog.set_uniform("u_dash_period","float",[n]),this.prog.set_uniform("u_dash_caps","vec2",[e,e]),this.prog.set_uniform("u_closed","float",[0])}_bake(){let t,e,s,i,a,n,o,_;const h=this.nvertices,r=this.glyph.sx,l=this.glyph.sy,g=o=new Float32Array(2*h),u=new Float32Array(2*h),f=_=new Float32Array(4*h);for(let t=0,e=h;t<e;t++)g[2*t+0]=r[t],g[2*t+1]=l[t];this.tangents=e=new Float32Array(2*h-2);for(let t=0,s=h-1;t<s;t++)e[2*t+0]=o[2*(t+1)+0]-o[2*t+0],e[2*t+1]=o[2*(t+1)+1]-o[2*t+1];for(let t=0,s=h-1;t<s;t++)f[4*(t+1)+0]=e[2*t+0],f[4*(t+1)+1]=e[2*t+1],f[4*t+2]=e[2*t+0],f[4*t+3]=e[2*t+1];f[0]=e[0],f[1]=e[1],f[4*(h-1)+2]=e[2*(h-2)+0],f[4*(h-1)+3]=e[2*(h-2)+1];const c=new Float32Array(h);for(let t=0,e=h;t<e;t++)c[t]=Math.atan2(_[4*t+0]*_[4*t+3]-_[4*t+1]*_[4*t+2],_[4*t+0]*_[4*t+2]+_[4*t+1]*_[4*t+3]);for(let t=0,e=h-1;t<e;t++)u[2*t+0]=c[t],u[2*t+1]=c[t+1];const p=4*h-4;this.V_position=i=new Float32Array(2*p),this.V_angles=s=new Float32Array(2*p),this.V_tangents=a=new Float32Array(4*p),this.V_texcoord=n=new Float32Array(2*p);for(let t=0,e=h;t<e;t++)for(let e=0;e<4;e++){for(let a=0;a<2;a++)i[2*(4*t+e-2)+a]=g[2*t+a],s[2*(4*t+e)+a]=u[2*t+a];for(let s=0;s<4;s++)a[4*(4*t+e-2)+s]=f[4*t+s]}for(let t=0,e=h;t<e;t++)n[2*(4*t+0)+0]=-1,n[2*(4*t+1)+0]=-1,n[2*(4*t+2)+0]=1,n[2*(4*t+3)+0]=1,n[2*(4*t+0)+1]=-1,n[2*(4*t+1)+1]=1,n[2*(4*t+2)+1]=-1,n[2*(4*t+3)+1]=1;const d=6*(h-1);this.I_triangles=t=new Uint32Array(d);for(let e=0,s=h;e<s;e++)t[6*e+0]=0+4*e,t[6*e+1]=1+4*e,t[6*e+2]=3+4*e,t[6*e+3]=2+4*e,t[6*e+4]=0+4*e,t[6*e+5]=3+4*e}_update_scale(t,e){let s;const i=this.nvertices,a=4*i-4,n=this.tangents,o=new Float32Array(i-1),_=new Float32Array(2*i);this.V_segment=s=new Float32Array(2*a);for(let s=0,a=i-1;s<a;s++)o[s]=Math.sqrt((n[2*s+0]*t)**2+(n[2*s+1]*e)**2);let h=0;for(let t=0,e=i-1;t<e;t++)h+=o[t],_[2*(t+1)+0]=h,_[2*t+1]=h;for(let t=0,e=i;t<e;t++)for(let e=0;e<4;e++)for(let i=0;i<2;i++)s[2*(4*t+e)+i]=_[2*t+i];this.cumsum=h,this.vbo_segment.set_size(4*this.V_segment.length),this.vbo_segment.set_data(0,this.V_segment)}}s.LineGL=g,g.__name__="LineGL"},
function _(e,r,f){Object.defineProperty(f,"__esModule",{value:!0});var u=e(104);f.Program=u.Program;var t=e(106);f.Texture2d=t.Texture2d;var a=e(105);f.IndexBuffer=a.IndexBuffer,f.VertexBuffer=a.VertexBuffer},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const s=t(105);class a{constructor(t){this.gl=t,this.UTYPEMAP={float:"uniform1fv",vec2:"uniform2fv",vec3:"uniform3fv",vec4:"uniform4fv",int:"uniform1iv",ivec2:"uniform2iv",ivec3:"uniform3iv",ivec4:"uniform4iv",bool:"uniform1iv",bvec2:"uniform2iv",bvec3:"uniform3iv",bvec4:"uniform4iv",mat2:"uniformMatrix2fv",mat3:"uniformMatrix3fv",mat4:"uniformMatrix4fv",sampler1D:"uniform1i",sampler2D:"uniform1i",sampler3D:"uniform1i"},this.ATYPEMAP={float:"vertexAttrib1f",vec2:"vertexAttrib2f",vec3:"vertexAttrib3f",vec4:"vertexAttrib4f"},this.ATYPEINFO={float:[1,5126],vec2:[2,5126],vec3:[3,5126],vec4:[4,5126]},this._linked=!1,this._validated=!1,this._unset_variables=new Set,this._known_invalid=new Set,this._locations=new Map,this._samplers=new Map,this._attributes=new Map,this.handle=this.gl.createProgram()}delete(){this.gl.deleteProgram(this.handle)}activate(){this.gl.useProgram(this.handle)}deactivate(){this.gl.useProgram(0)}set_shaders(t,e){const i=this.gl;this._linked=!1;const s=i.createShader(i.VERTEX_SHADER),a=i.createShader(i.FRAGMENT_SHADER),r=[[t,s,"vertex"],[e,a,"fragment"]];for(const[t,e,s]of r){i.shaderSource(e,t),i.compileShader(e);if(!i.getShaderParameter(e,i.COMPILE_STATUS)){const t=i.getShaderInfoLog(e);throw new Error(`errors in ${s} shader:\n${t}`)}}if(i.attachShader(this.handle,s),i.attachShader(this.handle,a),i.linkProgram(this.handle),!i.getProgramParameter(this.handle,i.LINK_STATUS)){const t=i.getProgramInfoLog(this.handle);throw new Error("Program link error:\n"+t)}this._unset_variables=this._get_active_attributes_and_uniforms(),i.detachShader(this.handle,s),i.detachShader(this.handle,a),i.deleteShader(s),i.deleteShader(a),this._known_invalid.clear(),this._linked=!0}_get_active_attributes_and_uniforms(){const t=this.gl;this._locations.clear();const e=new RegExp("(\\w+)\\s*(\\[(\\d+)\\])\\s*"),i=t.getProgramParameter(this.handle,t.ACTIVE_UNIFORMS),s=[],a=[],r=[[s,t.getProgramParameter(this.handle,t.ACTIVE_ATTRIBUTES),t.getActiveAttrib,t.getAttribLocation],[a,i,t.getActiveUniform,t.getUniformLocation]];for(const[i,s,a,n]of r)for(let r=0;r<s;r+=1){const s=a.call(t,this.handle,r),o=s.name,h=o.match(e);if(null!=h){const t=h[1];for(let e=0;e<s.size;e+=1)i.push([`${t}[${e}]`,s.type])}else i.push([o,s.type]);this._locations.set(o,n.call(t,this.handle,o))}const n=new Set;for(const[t]of s)n.add(t);for(const[t]of a)n.add(t);return n}set_texture(t,e){var i;if(!this._linked)throw new Error("Cannot set uniform when program has no code");const s=null!==(i=this._locations.get(t))&&void 0!==i?i:-1;if(s<0)this._known_invalid.has(t)||(this._known_invalid.add(t),console.log(`"Variable ${t} is not an active texture`));else{this._unset_variables.has(t)&&this._unset_variables.delete(t),this.activate();{let i=this._samplers.size;this._samplers.has(t)&&(i=this._samplers.get(t)[2]),this._samplers.set(t,[e._target,e.handle,i]),this.gl.uniform1i(s,i)}}}set_uniform(t,e,i){var s;if(!this._linked)throw new Error("Cannot set uniform when program has no code");const a=null!==(s=this._locations.get(t))&&void 0!==s?s:-1;if(a<0)return void(this._known_invalid.has(t)||(this._known_invalid.add(t),console.log(`Variable ${t} is not an active uniform`)));this._unset_variables.has(t)&&this._unset_variables.delete(t);let r=1;if(!e.startsWith("mat")){const t="int"==e||"bool"==e?"float":e.replace(/^ib/,"");r=Math.floor(i.length/this.ATYPEINFO[t][0])}if(r>1)for(let e=0;e<r;e+=1)if(this._unset_variables.has(`${t}[${e}]`)){const i=`${t}[${e}]`;this._unset_variables.has(i)&&this._unset_variables.delete(i)}const n=this.UTYPEMAP[e];this.activate(),e.startsWith("mat")?this.gl[n](a,!1,i):this.gl[n](a,i)}set_attribute(t,e,i,a=0,r=0){var n;if(!this._linked)throw new Error("Cannot set attribute when program has no code");const o=null!==(n=this._locations.get(t))&&void 0!==n?n:-1;if(o<0)this._known_invalid.has(t)||(this._known_invalid.add(t),i instanceof s.VertexBuffer&&r>0||console.log(`Variable ${t} is not an active attribute`));else if(this._unset_variables.has(t)&&this._unset_variables.delete(t),this.activate(),i instanceof s.VertexBuffer){const[s,n]=this.ATYPEINFO[e],h="vertexAttribPointer",l=[s,n,!1,a,r];this._attributes.set(t,[i.handle,o,h,l])}else{const s=this.ATYPEMAP[e];this._attributes.set(t,[null,o,s,i])}}_pre_draw(){this.activate();for(const[t,e,i]of this._samplers.values())this.gl.activeTexture(this.gl.TEXTURE0+i),this.gl.bindTexture(t,e);for(const[t,e,i,s]of this._attributes.values())null!=t?(this.gl.bindBuffer(this.gl.ARRAY_BUFFER,t),this.gl.enableVertexAttribArray(e),this.gl[i].apply(this.gl,[e,...s])):(this.gl.bindBuffer(this.gl.ARRAY_BUFFER,null),this.gl.disableVertexAttribArray(e),this.gl[i].apply(this.gl,[e,...s]));this._validated||(this._validated=!0,this._validate())}_validate(){if(this._unset_variables.size&&console.log("Program has unset variables: "+this._unset_variables),this.gl.validateProgram(this.handle),!this.gl.getProgramParameter(this.handle,this.gl.VALIDATE_STATUS))throw console.log(this.gl.getProgramInfoLog(this.handle)),new Error("Program validation error")}draw(t,e){if(!this._linked)throw new Error("Cannot draw program if code has not been set");if(e instanceof s.IndexBuffer){this._pre_draw(),e.activate();const i=e.buffer_size/2,s=this.gl.UNSIGNED_SHORT;this.gl.drawElements(t,i,s,0),e.deactivate()}else{const[i,s]=e;0!=s&&(this._pre_draw(),this.gl.drawArrays(t,i,s))}}}i.Program=a,a.__name__="Program"},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});class i{constructor(e){this.gl=e,this._usage=35048,this.buffer_size=0,this.handle=this.gl.createBuffer()}delete(){this.gl.deleteBuffer(this.handle)}activate(){this.gl.bindBuffer(this._target,this.handle)}deactivate(){this.gl.bindBuffer(this._target,null)}set_size(e){e!=this.buffer_size&&(this.activate(),this.gl.bufferData(this._target,e,this._usage),this.buffer_size=e)}set_data(e,t){this.activate(),this.gl.bufferSubData(this._target,e,t)}}s.Buffer=i,i.__name__="Buffer";class r extends i{constructor(){super(...arguments),this._target=34962}}s.VertexBuffer=r,r.__name__="VertexBuffer";class a extends i{constructor(){super(...arguments),this._target=34963}}s.IndexBuffer=a,a.__name__="IndexBuffer"},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const a=t(11);class r{constructor(t){this.gl=t,this._target=3553,this._types={Int8Array:5120,Uint8Array:5121,Int16Array:5122,Uint16Array:5123,Int32Array:5124,Uint32Array:5125,Float32Array:5126},this.handle=this.gl.createTexture()}delete(){this.gl.deleteTexture(this.handle)}activate(){this.gl.bindTexture(this._target,this.handle)}deactivate(){this.gl.bindTexture(this._target,0)}_get_alignment(t){const e=[4,8,2,1];for(const i of e)if(t%i==0)return i;a.unreachable()}set_wrapping(t,e){this.activate(),this.gl.texParameterf(this._target,this.gl.TEXTURE_WRAP_S,t),this.gl.texParameterf(this._target,this.gl.TEXTURE_WRAP_T,e)}set_interpolation(t,e){this.activate(),this.gl.texParameterf(this._target,this.gl.TEXTURE_MIN_FILTER,t),this.gl.texParameterf(this._target,this.gl.TEXTURE_MAG_FILTER,e)}set_size([t,e],i){var a,r,s;t==(null===(a=this._shape_format)||void 0===a?void 0:a.width)&&e==(null===(r=this._shape_format)||void 0===r?void 0:r.height)&&i==(null===(s=this._shape_format)||void 0===s?void 0:s.format)||(this._shape_format={width:t,height:e,format:i},this.activate(),this.gl.texImage2D(this._target,0,i,t,e,0,i,this.gl.UNSIGNED_BYTE,null))}set_data(t,[e,i],a){this.activate();const{format:r}=this._shape_format,[s,h]=t,l=this._types[a.constructor.name];if(null==l)throw new Error(`Type ${a.constructor.name} not allowed for texture`);const _=this._get_alignment(e);4!=_&&this.gl.pixelStorei(this.gl.UNPACK_ALIGNMENT,_),this.gl.texSubImage2D(this._target,0,s,h,e,i,r,l,a),4!=_&&this.gl.pixelStorei(this.gl.UNPACK_ALIGNMENT,4)}}i.Texture2d=r,r.__name__="Texture2d"},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});class s{constructor(e,t){this.gl=e,this.glyph=t,this.nvertices=0,this.size_changed=!1,this.data_changed=!1,this.visuals_changed=!1,this.init()}set_data_changed(){const{data_size:e}=this.glyph;e!=this.nvertices&&(this.nvertices=e,this.size_changed=!0),this.data_changed=!0}set_visuals_changed(){this.visuals_changed=!0}render(e,t,i){if(0==t.length)return!0;const{width:s,height:h}=this.glyph.renderer.plot_view.canvas_view.webgl.canvas,a={pixel_ratio:this.glyph.renderer.plot_view.canvas_view.pixel_ratio,width:s,height:h};return this.draw(t,i,a),!0}}i.BaseGLGlyph=s,s.__name__="BaseGLGlyph"},
function _(n,e,t){Object.defineProperty(t,"__esModule",{value:!0}),t.vertex_shader="\nprecision mediump float;\n\nconst float PI = 3.14159265358979323846264;\nconst float THETA = 15.0 * 3.14159265358979323846264/180.0;\n\nuniform float u_pixel_ratio;\nuniform vec2 u_canvas_size, u_offset;\nuniform vec2 u_scale_aspect;\nuniform float u_scale_length;\n\nuniform vec4 u_color;\nuniform float u_antialias;\nuniform float u_length;\nuniform float u_linewidth;\nuniform float u_dash_index;\nuniform float u_closed;\n\nattribute vec2 a_position;\nattribute vec4 a_tangents;\nattribute vec2 a_segment;\nattribute vec2 a_angles;\nattribute vec2 a_texcoord;\n\nvarying vec4  v_color;\nvarying vec2  v_segment;\nvarying vec2  v_angles;\nvarying vec2  v_texcoord;\nvarying vec2  v_miter;\nvarying float v_length;\nvarying float v_linewidth;\n\nfloat cross(in vec2 v1, in vec2 v2)\n{\n    return v1.x*v2.y - v1.y*v2.x;\n}\n\nfloat signed_distance(in vec2 v1, in vec2 v2, in vec2 v3)\n{\n    return cross(v2-v1,v1-v3) / length(v2-v1);\n}\n\nvoid rotate( in vec2 v, in float alpha, out vec2 result )\n{\n    float c = cos(alpha);\n    float s = sin(alpha);\n    result = vec2( c*v.x - s*v.y,\n                   s*v.x + c*v.y );\n}\n\nvoid main()\n{\n    bool closed = (u_closed > 0.0);\n\n    // Attributes and uniforms to varyings\n    v_color = u_color;\n    v_linewidth = u_linewidth;\n    v_segment = a_segment * u_scale_length;\n    v_length = u_length * u_scale_length;\n\n    // Scale to map to pixel coordinates. The original algorithm from the paper\n    // assumed isotropic scale. We obviously do not have this.\n    vec2 abs_scale_aspect = abs(u_scale_aspect);\n    vec2 abs_scale = u_scale_length * abs_scale_aspect;\n\n    // Correct angles for aspect ratio\n    vec2 av;\n    av = vec2(1.0, tan(a_angles.x)) / abs_scale_aspect;\n    v_angles.x = atan(av.y, av.x);\n    av = vec2(1.0, tan(a_angles.y)) / abs_scale_aspect;\n    v_angles.y = atan(av.y, av.x);\n\n    // Thickness below 1 pixel are represented using a 1 pixel thickness\n    // and a modified alpha\n    v_color.a = min(v_linewidth, v_color.a);\n    v_linewidth = max(v_linewidth, 1.0);\n\n    // If color is fully transparent we just will discard the fragment anyway\n    if( v_color.a <= 0.0 ) {\n        gl_Position = vec4(0.0,0.0,0.0,1.0);\n        return;\n    }\n\n    // This is the actual half width of the line\n    float w = ceil(u_antialias+v_linewidth)/2.0;\n\n    vec2 position = a_position;\n\n    vec2 t1 = normalize(a_tangents.xy * abs_scale_aspect);  // note the scaling for aspect ratio here\n    vec2 t2 = normalize(a_tangents.zw * abs_scale_aspect);\n    float u = a_texcoord.x;\n    float v = a_texcoord.y;\n    vec2 o1 = vec2( +t1.y, -t1.x);\n    vec2 o2 = vec2( +t2.y, -t2.x);\n\n    // This is a join\n    // ----------------------------------------------------------------\n    if( t1 != t2 ) {\n        float angle = atan (t1.x*t2.y-t1.y*t2.x, t1.x*t2.x+t1.y*t2.y);  // Angle needs recalculation for some reason\n        vec2 t  = normalize(t1+t2);\n        vec2 o  = vec2( + t.y, - t.x);\n\n        if ( u_dash_index > 0.0 )\n        {\n            // Broken angle\n            // ----------------------------------------------------------------\n            if( (abs(angle) > THETA) ) {\n                position += v * w * o / cos(angle/2.0);\n                float s = sign(angle);\n                if( angle < 0.0 ) {\n                    if( u == +1.0 ) {\n                        u = v_segment.y + v * w * tan(angle/2.0);\n                        if( v == 1.0 ) {\n                            position -= 2.0 * w * t1 / sin(angle);\n                            u -= 2.0 * w / sin(angle);\n                        }\n                    } else {\n                        u = v_segment.x - v * w * tan(angle/2.0);\n                        if( v == 1.0 ) {\n                            position += 2.0 * w * t2 / sin(angle);\n                            u += 2.0*w / sin(angle);\n                        }\n                    }\n                } else {\n                    if( u == +1.0 ) {\n                        u = v_segment.y + v * w * tan(angle/2.0);\n                        if( v == -1.0 ) {\n                            position += 2.0 * w * t1 / sin(angle);\n                            u += 2.0 * w / sin(angle);\n                        }\n                    } else {\n                        u = v_segment.x - v * w * tan(angle/2.0);\n                        if( v == -1.0 ) {\n                            position -= 2.0 * w * t2 / sin(angle);\n                            u -= 2.0*w / sin(angle);\n                        }\n                    }\n                }\n                // Continuous angle\n                // ------------------------------------------------------------\n            } else {\n                position += v * w * o / cos(angle/2.0);\n                if( u == +1.0 ) u = v_segment.y;\n                else            u = v_segment.x;\n            }\n        }\n\n        // Solid line\n        // --------------------------------------------------------------------\n        else\n        {\n            position.xy += v * w * o / cos(angle/2.0);\n            if( angle < 0.0 ) {\n                if( u == +1.0 ) {\n                    u = v_segment.y + v * w * tan(angle/2.0);\n                } else {\n                    u = v_segment.x - v * w * tan(angle/2.0);\n                }\n            } else {\n                if( u == +1.0 ) {\n                    u = v_segment.y + v * w * tan(angle/2.0);\n                } else {\n                    u = v_segment.x - v * w * tan(angle/2.0);\n                }\n            }\n        }\n\n    // This is a line start or end (t1 == t2)\n    // ------------------------------------------------------------------------\n    } else {\n        position += v * w * o1;\n        if( u == -1.0 ) {\n            u = v_segment.x - w;\n            position -= w * t1;\n        } else {\n            u = v_segment.y + w;\n            position += w * t2;\n        }\n    }\n\n    // Miter distance\n    // ------------------------------------------------------------------------\n    vec2 t;\n    vec2 curr = a_position * abs_scale;\n    if( a_texcoord.x < 0.0 ) {\n        vec2 next = curr + t2*(v_segment.y-v_segment.x);\n\n        rotate( t1, +v_angles.x/2.0, t);\n        v_miter.x = signed_distance(curr, curr+t, position);\n\n        rotate( t2, +v_angles.y/2.0, t);\n        v_miter.y = signed_distance(next, next+t, position);\n    } else {\n        vec2 prev = curr - t1*(v_segment.y-v_segment.x);\n\n        rotate( t1, -v_angles.x/2.0,t);\n        v_miter.x = signed_distance(prev, prev+t, position);\n\n        rotate( t2, -v_angles.y/2.0,t);\n        v_miter.y = signed_distance(curr, curr+t, position);\n    }\n\n    if (!closed && v_segment.x <= 0.0) {\n        v_miter.x = 1e10;\n    }\n    if (!closed && v_segment.y >= v_length)\n    {\n        v_miter.y = 1e10;\n    }\n\n    v_texcoord = vec2( u, v*w );\n\n    // Calculate position in device coordinates. Note that we\n    // already scaled with abs scale above.\n    vec2 normpos = position * sign(u_scale_aspect);\n    normpos += 0.5;  // make up for Bokeh's offset\n    normpos /= u_canvas_size / u_pixel_ratio;  // in 0..1\n    gl_Position = vec4(normpos*2.0-1.0, 0.0, 1.0);\n    gl_Position.y *= -1.0;\n}\n"},
function _(n,t,e){Object.defineProperty(e,"__esModule",{value:!0}),e.fragment_shader="\nprecision mediump float;\n\nconst float PI = 3.14159265358979323846264;\nconst float THETA = 15.0 * 3.14159265358979323846264/180.0;\n\nuniform sampler2D u_dash_atlas;\n\nuniform vec2 u_linecaps;\nuniform float u_miter_limit;\nuniform float u_linejoin;\nuniform float u_antialias;\nuniform float u_dash_phase;\nuniform float u_dash_period;\nuniform float u_dash_index;\nuniform vec2 u_dash_caps;\nuniform float u_closed;\n\nvarying vec4  v_color;\nvarying vec2  v_segment;\nvarying vec2  v_angles;\nvarying vec2  v_texcoord;\nvarying vec2  v_miter;\nvarying float v_length;\nvarying float v_linewidth;\n\n// Compute distance to cap ----------------------------------------------------\nfloat cap( int type, float dx, float dy, float t, float linewidth )\n{\n    float d = 0.0;\n    dx = abs(dx);\n    dy = abs(dy);\n    if      (type == 0)  discard;  // None\n    else if (type == 1)  d = sqrt(dx*dx+dy*dy);  // Round\n    else if (type == 3)  d = (dx+abs(dy));  // Triangle in\n    else if (type == 2)  d = max(abs(dy),(t+dx-abs(dy)));  // Triangle out\n    else if (type == 4)  d = max(dx,dy);  // Square\n    else if (type == 5)  d = max(dx+t,dy);  // Butt\n    return d;\n}\n\n// Compute distance to join -------------------------------------------------\nfloat join( in int type, in float d, in vec2 segment, in vec2 texcoord, in vec2 miter,\n           in float linewidth )\n{\n    // texcoord.x is distance from start\n    // texcoord.y is distance from centerline\n    // segment.x and y indicate the limits (as for texcoord.x) for this segment\n\n    float dx = texcoord.x;\n\n    // Round join\n    if( type == 1 ) {\n        if (dx < segment.x) {\n            d = max(d,length( texcoord - vec2(segment.x,0.0)));\n            //d = length( texcoord - vec2(segment.x,0.0));\n        } else if (dx > segment.y) {\n            d = max(d,length( texcoord - vec2(segment.y,0.0)));\n            //d = length( texcoord - vec2(segment.y,0.0));\n        }\n    }\n    // Bevel join\n    else if ( type == 2 ) {\n        if (dx < segment.x) {\n            vec2 x = texcoord - vec2(segment.x,0.0);\n            d = max(d, max(abs(x.x), abs(x.y)));\n\n        } else if (dx > segment.y) {\n            vec2 x = texcoord - vec2(segment.y,0.0);\n            d = max(d, max(abs(x.x), abs(x.y)));\n        }\n        /*  Original code for bevel which does not work for us\n        if( (dx < segment.x) ||  (dx > segment.y) )\n            d = max(d, min(abs(x.x),abs(x.y)));\n        */\n    }\n\n    return d;\n}\n\nvoid main()\n{\n    // If color is fully transparent we just discard the fragment\n    if( v_color.a <= 0.0 ) {\n        discard;\n    }\n\n    // Test if dash pattern is the solid one (0)\n    bool solid =  (u_dash_index == 0.0);\n\n    // Test if path is closed\n    bool closed = (u_closed > 0.0);\n\n    vec4 color = v_color;\n    float dx = v_texcoord.x;\n    float dy = v_texcoord.y;\n    float t = v_linewidth/2.0-u_antialias;\n    float width = 1.0;  //v_linewidth; original code had dashes scale with line width, we do not\n    float d = 0.0;\n\n    vec2 linecaps = u_linecaps;\n    vec2 dash_caps = u_dash_caps;\n    float line_start = 0.0;\n    float line_stop = v_length;\n\n    // Apply miter limit; fragments too far into the miter are simply discarded\n    if( (dx < v_segment.x) || (dx > v_segment.y) ) {\n        float into_miter = max(v_segment.x - dx, dx - v_segment.y);\n        if (into_miter > u_miter_limit*v_linewidth/2.0)\n          discard;\n    }\n\n    // Solid line --------------------------------------------------------------\n    if( solid ) {\n        d = abs(dy);\n        if( (!closed) && (dx < line_start) ) {\n            d = cap( int(u_linecaps.x), abs(dx), abs(dy), t, v_linewidth );\n        }\n        else if( (!closed) &&  (dx > line_stop) ) {\n            d = cap( int(u_linecaps.y), abs(dx)-line_stop, abs(dy), t, v_linewidth );\n        }\n        else {\n            d = join( int(u_linejoin), abs(dy), v_segment, v_texcoord, v_miter, v_linewidth );\n        }\n\n    // Dash line --------------------------------------------------------------\n    } else {\n        float segment_start = v_segment.x;\n        float segment_stop  = v_segment.y;\n        float segment_center= (segment_start+segment_stop)/2.0;\n        float freq          = u_dash_period*width;\n        float u = mod( dx + u_dash_phase*width, freq);\n        vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n        float dash_center= tex.x * width;\n        float dash_type  = tex.y;\n        float _start = tex.z * width;\n        float _stop  = tex.a * width;\n        float dash_start = dx - u + _start;\n        float dash_stop  = dx - u + _stop;\n\n        // Compute extents of the first dash (the one relative to v_segment.x)\n        // Note: this could be computed in the vertex shader\n        if( (dash_stop < segment_start) && (dash_caps.x != 5.0) ) {\n            float u = mod(segment_start + u_dash_phase*width, freq);\n            vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n            dash_center= tex.x * width;\n            //dash_type  = tex.y;\n            float _start = tex.z * width;\n            float _stop  = tex.a * width;\n            dash_start = segment_start - u + _start;\n            dash_stop = segment_start - u + _stop;\n        }\n\n        // Compute extents of the last dash (the one relatives to v_segment.y)\n        // Note: This could be computed in the vertex shader\n        else if( (dash_start > segment_stop)  && (dash_caps.y != 5.0) ) {\n            float u = mod(segment_stop + u_dash_phase*width, freq);\n            vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n            dash_center= tex.x * width;\n            //dash_type  = tex.y;\n            float _start = tex.z * width;\n            float _stop  = tex.a * width;\n            dash_start = segment_stop - u + _start;\n            dash_stop  = segment_stop - u + _stop;\n        }\n\n        // This test if the we are dealing with a discontinuous angle\n        bool discontinuous = ((dx <  segment_center) && abs(v_angles.x) > THETA) ||\n                             ((dx >= segment_center) && abs(v_angles.y) > THETA);\n        //if( dx < line_start) discontinuous = false;\n        //if( dx > line_stop)  discontinuous = false;\n\n        float d_join = join( int(u_linejoin), abs(dy),\n                            v_segment, v_texcoord, v_miter, v_linewidth );\n\n        // When path is closed, we do not have room for linecaps, so we make room\n        // by shortening the total length\n        if (closed) {\n             line_start += v_linewidth/2.0;\n             line_stop  -= v_linewidth/2.0;\n        }\n\n        // We also need to take antialias area into account\n        //line_start += u_antialias;\n        //line_stop  -= u_antialias;\n\n        // Check is dash stop is before line start\n        if( dash_stop <= line_start ) {\n            discard;\n        }\n        // Check is dash start is beyond line stop\n        if( dash_start >= line_stop ) {\n            discard;\n        }\n\n        // Check if current dash start is beyond segment stop\n        if( discontinuous ) {\n            // Dash start is beyond segment, we discard\n            if( (dash_start > segment_stop) ) {\n                discard;\n                //gl_FragColor = vec4(1.0,0.0,0.0,.25); return;\n            }\n\n            // Dash stop is before segment, we discard\n            if( (dash_stop < segment_start) ) {\n                discard;  //gl_FragColor = vec4(0.0,1.0,0.0,.25); return;\n            }\n\n            // Special case for round caps (nicer with this)\n            if( dash_caps.x == 1.0 ) {\n                if( (u > _stop) && (dash_stop > segment_stop )  && (abs(v_angles.y) < PI/2.0)) {\n                    discard;\n                }\n            }\n\n            // Special case for round caps  (nicer with this)\n            if( dash_caps.y == 1.0 ) {\n                if( (u < _start) && (dash_start < segment_start )  && (abs(v_angles.x) < PI/2.0)) {\n                    discard;\n                }\n            }\n\n            // Special case for triangle caps (in & out) and square\n            // We make sure the cap stop at crossing frontier\n            if( (dash_caps.x != 1.0) && (dash_caps.x != 5.0) ) {\n                if( (dash_start < segment_start )  && (abs(v_angles.x) < PI/2.0) ) {\n                    float a = v_angles.x/2.0;\n                    float x = (segment_start-dx)*cos(a) - dy*sin(a);\n                    float y = (segment_start-dx)*sin(a) + dy*cos(a);\n                    if( x > 0.0 ) discard;\n                    // We transform the cap into square to avoid holes\n                    dash_caps.x = 4.0;\n                }\n            }\n\n            // Special case for triangle caps (in & out) and square\n            // We make sure the cap stop at crossing frontier\n            if( (dash_caps.y != 1.0) && (dash_caps.y != 5.0) ) {\n                if( (dash_stop > segment_stop )  && (abs(v_angles.y) < PI/2.0) ) {\n                    float a = v_angles.y/2.0;\n                    float x = (dx-segment_stop)*cos(a) - dy*sin(a);\n                    float y = (dx-segment_stop)*sin(a) + dy*cos(a);\n                    if( x > 0.0 ) discard;\n                    // We transform the caps into square to avoid holes\n                    dash_caps.y = 4.0;\n                }\n            }\n        }\n\n        // Line cap at start\n        if( (dx < line_start) && (dash_start < line_start) && (dash_stop > line_start) ) {\n            d = cap( int(linecaps.x), dx-line_start, dy, t, v_linewidth);\n        }\n        // Line cap at stop\n        else if( (dx > line_stop) && (dash_stop > line_stop) && (dash_start < line_stop) ) {\n            d = cap( int(linecaps.y), dx-line_stop, dy, t, v_linewidth);\n        }\n        // Dash cap left - dash_type = -1, 0 or 1, but there may be roundoff errors\n        else if( dash_type < -0.5 ) {\n            d = cap( int(dash_caps.y), abs(u-dash_center), dy, t, v_linewidth);\n            if( (dx > line_start) && (dx < line_stop) )\n                d = max(d,d_join);\n        }\n        // Dash cap right\n        else if( dash_type > 0.5 ) {\n            d = cap( int(dash_caps.x), abs(dash_center-u), dy, t, v_linewidth);\n            if( (dx > line_start) && (dx < line_stop) )\n                d = max(d,d_join);\n        }\n        // Dash body (plain)\n        else {// if( dash_type > -0.5 &&  dash_type < 0.5) {\n            d = abs(dy);\n        }\n\n        // Line join\n        if( (dx > line_start) && (dx < line_stop)) {\n            if( (dx <= segment_start) && (dash_start <= segment_start)\n                && (dash_stop >= segment_start) ) {\n                d = d_join;\n                // Antialias at outer border\n                float angle = PI/2.+v_angles.x;\n                float f = abs( (segment_start - dx)*cos(angle) - dy*sin(angle));\n                d = max(f,d);\n            }\n            else if( (dx > segment_stop) && (dash_start <= segment_stop)\n                     && (dash_stop >= segment_stop) ) {\n                d = d_join;\n                // Antialias at outer border\n                float angle = PI/2.+v_angles.y;\n                float f = abs((dx - segment_stop)*cos(angle) - dy*sin(angle));\n                d = max(f,d);\n            }\n            else if( dx < (segment_start - v_linewidth/2.)) {\n                discard;\n            }\n            else if( dx > (segment_stop + v_linewidth/2.)) {\n                discard;\n            }\n        }\n        else if( dx < (segment_start - v_linewidth/2.)) {\n            discard;\n        }\n        else if( dx > (segment_stop + v_linewidth/2.)) {\n            discard;\n        }\n    }\n\n    // Distance to border ------------------------------------------------------\n    d = d - t;\n    if( d < 0.0 ) {\n        gl_FragColor = color;\n    } else {\n        d /= u_antialias;\n        gl_FragColor = vec4(color.rgb, exp(-d*d)*color.a);\n    }\n}\n"},
function _(e,i,t){Object.defineProperty(t,"__esModule",{value:!0});const s=e(1),l=e(93),_=e(100),n=s.__importStar(e(101)),o=s.__importStar(e(28)),a=e(88);class h extends l.XYGlyphView{_inner_loop(e,i,t,s,l){for(const _ of i)0!=_?isNaN(t[_]+s[_])?(e.closePath(),l.apply(e),e.beginPath()):e.lineTo(t[_],s[_]):(e.beginPath(),e.moveTo(t[_],s[_]));e.closePath(),l.call(e)}_render(e,i,{sx:t,sy:s}){this.visuals.fill.doit&&(this.visuals.fill.set_value(e),this._inner_loop(e,i,t,s,e.fill)),this.visuals.hatch.doit2(e,0,()=>this._inner_loop(e,i,t,s,e.fill),()=>this.renderer.request_render()),this.visuals.line.doit&&(this.visuals.line.set_value(e),this._inner_loop(e,i,t,s,e.stroke))}draw_legend_for_index(e,i,t){_.generic_area_legend(this.visuals,e,i,t)}_hit_point(e){const i=new a.Selection;return n.point_in_poly(e.sx,e.sy,this.sx,this.sy)&&(i.add_to_selected_glyphs(this.model),i.view=this),i}}t.PatchView=h,h.__name__="PatchView";class r extends l.XYGlyph{constructor(e){super(e)}static init_Patch(){this.prototype.default_view=h,this.mixins([o.Line,o.Fill,o.Hatch])}}t.Patch=r,r.__name__="Patch",r.init_Patch()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),r=e(24),n=e(112),a=i.__importStar(e(101)),_=i.__importStar(e(18)),h=e(88);class l extends n.AreaView{_index_data(e){const{min:t,max:s}=Math,{data_size:i}=this;for(let r=0;r<i;r++){const i=this._x1[r],n=this._x2[r],a=this._y[r];isNaN(i+n+a)||!isFinite(i+n+a)?e.add_empty():e.add(t(i,n),a,s(i,n),a)}}_inner(e,t,s,i,r){e.beginPath();for(let s=0,r=t.length;s<r;s++)e.lineTo(t[s],i[s]);for(let t=s.length-1;t>=0;t--)e.lineTo(s[t],i[t]);e.closePath(),r.call(e)}_render(e,t,{sx1:s,sx2:i,sy:r}){this.visuals.fill.doit&&(this.visuals.fill.set_value(e),this._inner(e,s,i,r,e.fill)),this.visuals.hatch.doit2(e,0,()=>this._inner(e,s,i,r,e.fill),()=>this.renderer.request_render())}_hit_point(e){const t=this.sy.length,s=new r.NumberArray(2*t),i=new r.NumberArray(2*t);for(let e=0,r=t;e<r;e++)s[e]=this.sx1[e],i[e]=this.sy[e],s[t+e]=this.sx2[t-e-1],i[t+e]=this.sy[t-e-1];const n=new h.Selection;return a.point_in_poly(e.sx,e.sy,s,i)&&(n.add_to_selected_glyphs(this.model),n.view=this),n}scenterxy(e){return[(this.sx1[e]+this.sx2[e])/2,this.sy[e]]}_map_data(){this.sx1=this.renderer.xscale.v_compute(this._x1),this.sx2=this.renderer.xscale.v_compute(this._x2),this.sy=this.renderer.yscale.v_compute(this._y)}}s.HAreaView=l,l.__name__="HAreaView";class o extends n.Area{constructor(e){super(e)}static init_HArea(){this.prototype.default_view=l,this.define({x1:[_.XCoordinateSpec,{field:"x1"}],x2:[_.XCoordinateSpec,{field:"x2"}],y:[_.YCoordinateSpec,{field:"y"}]})}}s.HArea=o,o.__name__="HArea",o.init_HArea()},
function _(e,_,i){Object.defineProperty(i,"__esModule",{value:!0});const a=e(1),r=e(94),t=e(100),n=a.__importStar(e(28));class s extends r.GlyphView{draw_legend_for_index(e,_,i){t.generic_area_legend(this.visuals,e,_,i)}}i.AreaView=s,s.__name__="AreaView";class c extends r.Glyph{constructor(e){super(e)}static init_Area(){this.mixins([n.Fill,n.HatchVector])}}i.Area=c,c.__name__="Area",c.init_Area()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),r=e(24),n=e(112),a=i.__importStar(e(101)),_=i.__importStar(e(18)),h=e(88);class l extends n.AreaView{_index_data(e){const{min:t,max:s}=Math,{data_size:i}=this;for(let r=0;r<i;r++){const i=this._x[r],n=this._y1[r],a=this._y2[r];isNaN(i+n+a)||!isFinite(i+n+a)?e.add_empty():e.add(i,t(n,a),i,s(n,a))}}_inner(e,t,s,i,r){e.beginPath();for(let i=0,r=s.length;i<r;i++)e.lineTo(t[i],s[i]);for(let s=i.length-1;s>=0;s--)e.lineTo(t[s],i[s]);e.closePath(),r.call(e)}_render(e,t,{sx:s,sy1:i,sy2:r}){this.visuals.fill.doit&&(this.visuals.fill.set_value(e),this._inner(e,s,i,r,e.fill)),this.visuals.hatch.doit2(e,0,()=>this._inner(e,s,i,r,e.fill),()=>this.renderer.request_render())}scenterxy(e){return[this.sx[e],(this.sy1[e]+this.sy2[e])/2]}_hit_point(e){const t=this.sx.length,s=new r.NumberArray(2*t),i=new r.NumberArray(2*t);for(let e=0,r=t;e<r;e++)s[e]=this.sx[e],i[e]=this.sy1[e],s[t+e]=this.sx[t-e-1],i[t+e]=this.sy2[t-e-1];const n=new h.Selection;return a.point_in_poly(e.sx,e.sy,s,i)&&(n.add_to_selected_glyphs(this.model),n.view=this),n}_map_data(){this.sx=this.renderer.xscale.v_compute(this._x),this.sy1=this.renderer.yscale.v_compute(this._y1),this.sy2=this.renderer.yscale.v_compute(this._y2)}}s.VAreaView=l,l.__name__="VAreaView";class o extends n.Area{constructor(e){super(e)}static init_VArea(){this.prototype.default_view=l,this.define({x:[_.XCoordinateSpec,{field:"x"}],y1:[_.YCoordinateSpec,{field:"y1"}],y2:[_.YCoordinateSpec,{field:"y2"}]})}}s.VArea=o,o.__name__="VArea",o.init_VArea()},
function _(i,e,s){Object.defineProperty(s,"__esModule",{value:!0});const t=i(1),n=i(81),c=t.__importStar(i(18)),o=i(88),r=i(24),_=i(86);class a extends n.Model{constructor(i){super(i)}static init_CDSView(){this.define({filters:[c.Array,[]],source:[c.Instance]}),this.internal({indices:[c.Any],indices_map:[c.Any,{}],masked:[c.Any,null]})}initialize(){super.initialize(),this.compute_indices()}connect_signals(){super.connect_signals(),this.connect(this.properties.filters.change,()=>this.compute_indices());const i=()=>{const i=()=>this.compute_indices();null!=this.source&&(this.connect(this.source.change,i),this.source instanceof _.ColumnarDataSource&&(this.connect(this.source.streaming,i),this.connect(this.source.patching,i)))};let e=null!=this.source;e?i():this.connect(this.properties.source.change,()=>{e||(i(),e=!0)})}compute_indices(){var i;const{source:e}=this;if(null==e)return;const s=null!==(i=e.get_length())&&void 0!==i?i:1,t=r.Indices.all_set(s);for(const i of this.filters)t.intersect(i.compute_indices(e));this.indices=t,this._indices=[...t],this.indices_map_to_subset()}indices_map_to_subset(){this.indices_map={};for(let i=0;i<this._indices.length;i++)this.indices_map[this._indices[i]]=i}convert_selection_from_subset(i){const e=i.indices.map(i=>this._indices[i]);return new o.Selection(Object.assign(Object.assign({},i.attributes),{indices:e}))}convert_selection_to_subset(i){const e=i.indices.map(i=>this.indices_map[i]);return new o.Selection(Object.assign(Object.assign({},i.attributes),{indices:e}))}convert_indices_from_subset(i){return i.map(i=>this._indices[i])}}s.CDSView=a,a.__name__="CDSView",a.init_CDSView()},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});const o=e(9);async function i(e,n,t){const o=new e(Object.assign(Object.assign({},t),{model:n}));return o.initialize(),await o.lazy_initialize(),o}t.build_view=async function(e,n={parent:null},t=(e=>e.default_view)){const o=await i(t(e),e,n);return o.connect_signals(),o},t.build_views=async function(e,n,t={parent:null},s=(e=>e.default_view)){const c=o.difference([...e.keys()],n);for(const n of c)e.get(n).remove(),e.delete(n);const a=[],f=n.filter(n=>!e.has(n));for(const n of f){const o=await i(s(n),n,t);e.set(n,o),a.push(o)}for(const e of a)e.connect_signals();return a},t.remove_views=function(e){for(const[n,t]of e)t.remove(),e.delete(n)}},
function _(e,r,n){Object.defineProperty(n,"__esModule",{value:!0});const t=e(1),i=e(91),s=e(117),a=t.__importStar(e(18)),o=e(115),_=e(11);class l extends i.DataRendererView{async lazy_initialize(){await super.lazy_initialize();const e=this.model;let r=null,n=null;const t={v_compute(n){_.assert(null==r);const[t]=r=e.layout_provider.get_edge_coordinates(n);return t}},i={v_compute(e){_.assert(null!=r);const[,n]=r;return r=null,n}},s={v_compute(r){_.assert(null==n);const[t]=n=e.layout_provider.get_node_coordinates(r);return t}},a={v_compute(e){_.assert(null!=n);const[,r]=n;return n=null,r}},{edge_renderer:l,node_renderer:d}=this.model;l.glyph.properties.xs.internal=!0,l.glyph.properties.ys.internal=!0,d.glyph.properties.x.internal=!0,d.glyph.properties.y.internal=!0,l.glyph.xs={expr:t},l.glyph.ys={expr:i},d.glyph.x={expr:s},d.glyph.y={expr:a};const{parent:p}=this;this.edge_view=await o.build_view(l,{parent:p}),this.node_view=await o.build_view(d,{parent:p})}connect_signals(){super.connect_signals(),this.connect(this.model.layout_provider.change,()=>{this.edge_view.set_data(!1),this.node_view.set_data(!1),this.request_render()})}remove(){this.edge_view.remove(),this.node_view.remove(),super.remove()}_render(){this.edge_view.render(),this.node_view.render()}}n.GraphRendererView=l,l.__name__="GraphRendererView";class d extends i.DataRenderer{constructor(e){super(e)}static init_GraphRenderer(){this.prototype.default_view=l,this.define({layout_provider:[a.Instance],node_renderer:[a.Instance],edge_renderer:[a.Instance],selection_policy:[a.Instance,()=>new s.NodesOnly],inspection_policy:[a.Instance,()=>new s.NodesOnly]})}get_selection_manager(){return this.node_renderer.data_source.selection_manager}}n.GraphRenderer=d,d.__name__="GraphRenderer",d.init_GraphRenderer()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const d=e(81),s=e(12),o=e(9),_=e(88);class i extends d.Model{constructor(e){super(e)}_hit_test_nodes(e,t){if(!t.model.visible)return null;const n=t.node_view.glyph.hit_test(e);return null==n?null:t.node_view.model.view.convert_selection_from_subset(n)}_hit_test_edges(e,t){if(!t.model.visible)return null;const n=t.edge_view.glyph.hit_test(e);return null==n?null:t.edge_view.model.view.convert_selection_from_subset(n)}}n.GraphHitTestPolicy=i,i.__name__="GraphHitTestPolicy";class r extends i{constructor(e){super(e)}hit_test(e,t){return this._hit_test_nodes(e,t)}do_selection(e,t,n,d){if(null==e)return!1;const s=t.node_renderer.data_source.selected;return s.update(e,n,d),t.node_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,n,d,s){if(null==e)return!1;const o=n.model.get_selection_manager().get_or_create_inspector(n.node_view.model);return o.update(e,d,s),n.node_view.model.data_source.setv({inspected:o},{silent:!0}),n.node_view.model.data_source.inspect.emit([n.node_view,{geometry:t}]),!o.is_empty()}}n.NodesOnly=r,r.__name__="NodesOnly";class c extends i{constructor(e){super(e)}hit_test(e,t){return this._hit_test_nodes(e,t)}get_linked_edges(e,t,n){let d=[];"selection"==n?d=e.selected.indices.map(t=>e.data.index[t]):"inspection"==n&&(d=e.inspected.indices.map(t=>e.data.index[t]));const s=[];for(let e=0;e<t.data.start.length;e++)(o.contains(d,t.data.start[e])||o.contains(d,t.data.end[e]))&&s.push(e);const i=new _.Selection;for(const e of s)i.multiline_indices[e]=[0];return i.indices=s,i}do_selection(e,t,n,d){if(null==e)return!1;const s=t.node_renderer.data_source.selected;s.update(e,n,d);const o=t.edge_renderer.data_source.selected,_=this.get_linked_edges(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.update(_,n,d),t.node_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,n,d,s){if(null==e)return!1;const o=n.node_view.model.data_source.selection_manager.get_or_create_inspector(n.node_view.model);o.update(e,d,s),n.node_view.model.data_source.setv({inspected:o},{silent:!0});const _=n.edge_view.model.data_source.selection_manager.get_or_create_inspector(n.edge_view.model),i=this.get_linked_edges(n.node_view.model.data_source,n.edge_view.model.data_source,"inspection");return _.update(i,d,s),n.edge_view.model.data_source.setv({inspected:_},{silent:!0}),n.node_view.model.data_source.inspect.emit([n.node_view,{geometry:t}]),!o.is_empty()}}n.NodesAndLinkedEdges=c,c.__name__="NodesAndLinkedEdges";class a extends i{constructor(e){super(e)}hit_test(e,t){return this._hit_test_edges(e,t)}get_linked_nodes(e,t,n){let d=[];"selection"==n?d=t.selected.indices:"inspection"==n&&(d=t.inspected.indices);const i=[];for(const e of d)i.push(t.data.start[e]),i.push(t.data.end[e]);const r=o.uniq(i).map(t=>s.indexOf(e.data.index,t));return new _.Selection({indices:r})}do_selection(e,t,n,d){if(null==e)return!1;const s=t.edge_renderer.data_source.selected;s.update(e,n,d);const o=t.node_renderer.data_source.selected,_=this.get_linked_nodes(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.update(_,n,d),t.edge_renderer.data_source._select.emit(),!s.is_empty()}do_inspection(e,t,n,d,s){if(null==e)return!1;const o=n.edge_view.model.data_source.selection_manager.get_or_create_inspector(n.edge_view.model);o.update(e,d,s),n.edge_view.model.data_source.setv({inspected:o},{silent:!0});const _=n.node_view.model.data_source.selection_manager.get_or_create_inspector(n.node_view.model),i=this.get_linked_nodes(n.node_view.model.data_source,n.edge_view.model.data_source,"inspection");return _.update(i,d,s),n.node_view.model.data_source.setv({inspected:_},{silent:!0}),n.edge_view.model.data_source.inspect.emit([n.edge_view,{geometry:t}]),!o.is_empty()}}n.EdgesAndLinkedNodes=a,a.__name__="EdgesAndLinkedNodes"},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const s=e(81);class o extends s.Model{do_selection(e,t,n,s){return null!==e&&(t.selected.update(e,n,s),t._select.emit(),!t.selected.is_empty())}}n.SelectionPolicy=o,o.__name__="SelectionPolicy";class r extends o{hit_test(e,t){const n=[];for(const s of t){const t=s.hit_test(e);null!==t&&n.push(t)}if(n.length>0){const e=n[0];for(const t of n)e.update_through_intersection(t);return e}return null}}n.IntersectRenderers=r,r.__name__="IntersectRenderers";class c extends o{hit_test(e,t){const n=[];for(const s of t){const t=s.hit_test(e);null!==t&&n.push(t)}if(n.length>0){const e=n[0];for(const t of n)e.update_through_union(t);return e}return null}}n.UnionRenderers=c,c.__name__="UnionRenderers"},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0}),n.concat=function(t,...e){let n=t.length;for(const t of e)n+=t.length;const o=new t.constructor(n);o.set(t,0);let c=t.length;for(const t of e)o.set(t,c),c+=t.length;return o}},
function _(n,o,e){function t(...n){const o=new Set;for(const e of n)for(const n of e)o.add(n);return o}Object.defineProperty(e,"__esModule",{value:!0}),e.union=t,e.intersection=function(n,...o){const e=new Set;n:for(const t of n){for(const n of o)if(!n.has(t))continue n;e.add(t)}return e},e.difference=function(n,...o){const e=new Set(n);for(const n of t(...o))e.delete(n);return e}},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const n=e(14);class o{constructor(e){this.document=e}}s.DocumentEvent=o,o.__name__="DocumentEvent";class r extends o{constructor(e,t,s){super(e),this.events=t,this.setter_id=s}}s.DocumentEventBatch=r,r.__name__="DocumentEventBatch";class d extends o{}s.DocumentChangedEvent=d,d.__name__="DocumentChangedEvent";class _ extends d{constructor(e,t,s){super(e),this.msg_type=t,this.msg_data=s}json(e){const t=this.msg_data,s=n.HasProps._value_to_json(t),o=new Set;return n.HasProps._value_record_references(t,o,{recursive:!0}),{kind:"MessageSent",msg_type:this.msg_type,msg_data:s}}}s.MessageSentEvent=_,_.__name__="MessageSentEvent";class i extends d{constructor(e,t,s,n,o,r,d){super(e),this.model=t,this.attr=s,this.old=n,this.new_=o,this.setter_id=r,this.hint=d}json(e){if("id"===this.attr)throw new Error("'id' field should never change, whatever code just set it is wrong");if(null!=this.hint)return this.hint.json(e);const t=this.new_,s=n.HasProps._value_to_json(t),o=new Set;n.HasProps._value_record_references(t,o,{recursive:!0}),o.has(this.model)&&this.model!==t&&o.delete(this.model);for(const t of o)e.add(t);return{kind:"ModelChanged",model:this.model.ref(),attr:this.attr,new:s}}}s.ModelChangedEvent=i,i.__name__="ModelChangedEvent";class a extends d{constructor(e,t,s){super(e),this.column_source=t,this.patches=s}json(e){return{kind:"ColumnsPatched",column_source:this.column_source,patches:this.patches}}}s.ColumnsPatchedEvent=a,a.__name__="ColumnsPatchedEvent";class c extends d{constructor(e,t,s,n){super(e),this.column_source=t,this.data=s,this.rollover=n}json(e){return{kind:"ColumnsStreamed",column_source:this.column_source,data:this.data,rollover:this.rollover}}}s.ColumnsStreamedEvent=c,c.__name__="ColumnsStreamedEvent";class h extends d{constructor(e,t,s){super(e),this.title=t,this.setter_id=s}json(e){return{kind:"TitleChanged",title:this.title}}}s.TitleChangedEvent=h,h.__name__="TitleChangedEvent";class u extends d{constructor(e,t,s){super(e),this.model=t,this.setter_id=s}json(e){return n.HasProps._value_record_references(this.model,e,{recursive:!0}),{kind:"RootAdded",model:this.model.ref()}}}s.RootAddedEvent=u,u.__name__="RootAddedEvent";class l extends d{constructor(e,t,s){super(e),this.model=t,this.setter_id=s}json(e){return{kind:"RootRemoved",model:this.model.ref()}}}s.RootRemovedEvent=l,l.__name__="RootRemovedEvent"},
function _(e,s,t){Object.defineProperty(t,"__esModule",{value:!0});const i=e(1),l=e(123),_=i.__importStar(e(28));class o extends l.UpperLowerView{connect_signals(){super.connect_signals();const e=()=>this.set_data(this.model.source);this.connect(this.model.change,e),this.connect(this.model.source.streaming,e),this.connect(this.model.source.patching,e),this.connect(this.model.source.change,e)}_render(){this._map_data();const{ctx:e}=this.layer;e.beginPath(),e.moveTo(this._lower_sx[0],this._lower_sy[0]);for(let s=0,t=this._lower_sx.length;s<t;s++)e.lineTo(this._lower_sx[s],this._lower_sy[s]);for(let s=this._upper_sx.length-1;s>=0;s--)e.lineTo(this._upper_sx[s],this._upper_sy[s]);e.closePath(),this.visuals.fill.doit&&(this.visuals.fill.set_value(e),e.fill()),e.beginPath(),e.moveTo(this._lower_sx[0],this._lower_sy[0]);for(let s=0,t=this._lower_sx.length;s<t;s++)e.lineTo(this._lower_sx[s],this._lower_sy[s]);this.visuals.line.doit&&(this.visuals.line.set_value(e),e.stroke()),e.beginPath(),e.moveTo(this._upper_sx[0],this._upper_sy[0]);for(let s=0,t=this._upper_sx.length;s<t;s++)e.lineTo(this._upper_sx[s],this._upper_sy[s]);this.visuals.line.doit&&(this.visuals.line.set_value(e),e.stroke())}}t.BandView=o,o.__name__="BandView";class n extends l.UpperLower{constructor(e){super(e)}static init_Band(){this.prototype.default_view=o,this.mixins([_.Line,_.Fill]),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})}}t.Band=n,n.__name__="Band",n.init_Band()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(1),o=e(36),r=e(85),p=s.__importStar(e(18));class _ extends o.AnnotationView{initialize(){super.initialize(),this.set_data(this.model.source)}set_data(e){super.set_data(e),this.visuals.warm_cache(e),this.plot_view.request_render()}_map_data(){const{frame:e}=this.plot_view,t=this.model.dimension,i=this.coordinates.x_scale,s=this.coordinates.y_scale,o="height"==t?s:i,r="height"==t?i:s,p="height"==t?e.yview:e.xview,_="height"==t?e.xview:e.yview;let a,n,h;a="data"==this.model.properties.lower.units?o.v_compute(this._lower):p.v_compute(this._lower),n="data"==this.model.properties.upper.units?o.v_compute(this._upper):p.v_compute(this._upper),h="data"==this.model.properties.base.units?r.v_compute(this._base):_.v_compute(this._base);const[c,u]="height"==t?[1,0]:[0,1],l=[a,h],w=[n,h];this._lower_sx=l[c],this._lower_sy=l[u],this._upper_sx=w[c],this._upper_sy=w[u]}}i.UpperLowerView=_,_.__name__="UpperLowerView";class a extends o.Annotation{constructor(e){super(e)}static init_UpperLower(){this.define({lower:[p.DistanceSpec],upper:[p.DistanceSpec],base:[p.DistanceSpec],dimension:[p.Dimension,"height"],source:[p.Instance,()=>new r.ColumnDataSource]})}}i.UpperLower=a,a.__name__="UpperLower",a.init_UpperLower()},
function _(t,i,s){Object.defineProperty(s,"__esModule",{value:!0});const e=t(1),o=t(36),n=t(15),l=e.__importStar(t(28)),a=e.__importStar(t(18)),h=t(79);s.EDGE_TOLERANCE=2.5;class r extends o.AnnotationView{connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.plot_view.request_paint(this)),this.connect(this.model.data_update,()=>this.plot_view.request_paint(this))}_render(){if(null==this.model.left&&null==this.model.right&&null==this.model.top&&null==this.model.bottom)return;const{frame:t}=this.plot_view,i=this.coordinates.x_scale,s=this.coordinates.y_scale,e=(t,i,s,e,o)=>{let n;return n=null!=t?this.model.screen?t:"data"==i?s.compute(t):e.compute(t):o,n};this.sleft=e(this.model.left,this.model.left_units,i,t.xview,t.bbox.left),this.sright=e(this.model.right,this.model.right_units,i,t.xview,t.bbox.right),this.stop=e(this.model.top,this.model.top_units,s,t.yview,t.bbox.top),this.sbottom=e(this.model.bottom,this.model.bottom_units,s,t.yview,t.bbox.bottom),this._paint_box(this.sleft,this.sright,this.sbottom,this.stop)}_paint_box(t,i,s,e){const{ctx:o}=this.layer;o.save(),o.beginPath(),o.rect(t,e,i-t,s-e),this.visuals.fill.doit&&(this.visuals.fill.set_value(o),o.fill()),this.visuals.line.doit&&(this.visuals.line.set_value(o),o.stroke()),o.restore()}interactive_bbox(){const t=this.model.properties.line_width.value()+s.EDGE_TOLERANCE;return new h.BBox({x0:this.sleft-t,y0:this.stop-t,x1:this.sright+t,y1:this.sbottom+t})}interactive_hit(t,i){if(null==this.model.in_cursor)return!1;return this.interactive_bbox().contains(t,i)}cursor(t,i){return Math.abs(t-this.sleft)<3||Math.abs(t-this.sright)<3?this.model.ew_cursor:Math.abs(i-this.sbottom)<3||Math.abs(i-this.stop)<3?this.model.ns_cursor:t>this.sleft&&t<this.sright&&i>this.stop&&i<this.sbottom?this.model.in_cursor:null}}s.BoxAnnotationView=r,r.__name__="BoxAnnotationView";class u extends o.Annotation{constructor(t){super(t)}static init_BoxAnnotation(){this.prototype.default_view=r,this.mixins([l.Line,l.Fill]),this.define({render_mode:[a.RenderMode,"canvas"],top:[a.Number,null],top_units:[a.SpatialUnits,"data"],bottom:[a.Number,null],bottom_units:[a.SpatialUnits,"data"],left:[a.Number,null],left_units:[a.SpatialUnits,"data"],right:[a.Number,null],right_units:[a.SpatialUnits,"data"]}),this.internal({screen:[a.Boolean,!1],ew_cursor:[a.String,null],ns_cursor:[a.String,null],in_cursor:[a.String,null]}),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})}initialize(){super.initialize(),this.data_update=new n.Signal0(this,"data_update")}update({left:t,right:i,top:s,bottom:e}){this.setv({left:t,right:i,top:s,bottom:e,screen:!0},{silent:!0}),this.data_update.emit()}}s.BoxAnnotation=u,u.__name__="BoxAnnotation",u.init_BoxAnnotation()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const o=t(1),a=t(36),s=t(126),r=t(130),n=t(132),l=t(145),_=t(156),h=t(157),m=t(158),d=o.__importStar(t(28)),c=o.__importStar(t(18)),u=o.__importStar(t(159)),g=t(9),p=t(12),f=t(8),b=t(11);class v extends a.AnnotationView{initialize(){super.initialize(),this._set_canvas_image()}connect_signals(){super.connect_signals(),this.connect(this.model.ticker.change,()=>this.plot_view.request_render()),this.connect(this.model.formatter.change,()=>this.plot_view.request_render()),null!=this.model.color_mapper&&this.connect(this.model.color_mapper.change,()=>{this._set_canvas_image(),this.plot_view.request_render()})}_get_size(){if(null==this.model.color_mapper)return{width:0,height:0};{const{width:t,height:e}=this.compute_legend_dimensions();return{width:t,height:e}}}_set_canvas_image(){if(null==this.model.color_mapper)return;let t,e,{palette:i}=this.model.color_mapper;switch("vertical"==this.model.orientation&&(i=g.reversed(i)),this.model.orientation){case"vertical":[t,e]=[1,i.length];break;case"horizontal":[t,e]=[i.length,1]}const o=document.createElement("canvas");o.width=t,o.height=e;const a=o.getContext("2d"),s=a.getImageData(0,0,t,e),r=new n.LinearColorMapper({palette:i}).rgba_mapper.v_compute(g.range(0,i.length));s.data.set(r),a.putImageData(s,0,0),this.image=o}compute_legend_dimensions(){const t=this._computed_image_dimensions(),[e,i]=[t.height,t.width],o=this._get_label_extent(),a=this._title_extent(),s=this._tick_extent(),{padding:r}=this.model;let n,l;switch(this.model.orientation){case"vertical":n=e+a+2*r,l=i+s+o+2*r;break;case"horizontal":n=e+a+s+o+2*r,l=i+2*r}return{width:l,height:n}}compute_legend_location(){const t=this.compute_legend_dimensions(),[e,i]=[t.height,t.width],o=this.model.margin,a=null!=this.panel?this.panel:this.plot_view.frame,[s,r]=a.bbox.ranges,{location:n}=this.model;let l,_;if(f.isString(n))switch(n){case"top_left":l=s.start+o,_=r.start+o;break;case"top_center":l=(s.end+s.start)/2-i/2,_=r.start+o;break;case"top_right":l=s.end-o-i,_=r.start+o;break;case"bottom_right":l=s.end-o-i,_=r.end-o-e;break;case"bottom_center":l=(s.end+s.start)/2-i/2,_=r.end-o-e;break;case"bottom_left":l=s.start+o,_=r.end-o-e;break;case"center_left":l=s.start+o,_=(r.end+r.start)/2-e/2;break;case"center":l=(s.end+s.start)/2-i/2,_=(r.end+r.start)/2-e/2;break;case"center_right":l=s.end-o-i,_=(r.end+r.start)/2-e/2}else if(f.isArray(n)&&2==n.length){const[t,i]=n;l=a.xview.compute(t),_=a.yview.compute(i)-e}else b.unreachable();return{sx:l,sy:_}}_render(){if(null==this.model.color_mapper)return;const{ctx:t}=this.layer;t.save();const{sx:e,sy:i}=this.compute_legend_location();t.translate(e,i),this._draw_bbox(t);const o=this._get_image_offset();t.translate(o.x,o.y),this._draw_image(t);const a=this.tick_info();this._draw_major_ticks(t,a),this._draw_minor_ticks(t,a),this._draw_major_labels(t,a),this.model.title&&this._draw_title(t),t.restore()}_draw_bbox(t){const e=this.compute_legend_dimensions();t.save(),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(0,0,e.width,e.height)),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.strokeRect(0,0,e.width,e.height)),t.restore()}_draw_image(t){const e=this._computed_image_dimensions();t.save(),t.setImageSmoothingEnabled(!1),t.globalAlpha=this.model.scale_alpha,t.drawImage(this.image,0,0,e.width,e.height),this.visuals.bar_line.doit&&(this.visuals.bar_line.set_value(t),t.strokeRect(0,0,e.width,e.height)),t.restore()}_draw_major_ticks(t,e){if(!this.visuals.major_tick_line.doit)return;const[i,o]=this._normals(),a=this._computed_image_dimensions(),[s,r]=[a.width*i,a.height*o],[n,l]=e.coords.major,_=this.model.major_tick_in,h=this.model.major_tick_out;t.save(),t.translate(s,r),this.visuals.major_tick_line.set_value(t);for(let e=0,a=n.length;e<a;e++)t.beginPath(),t.moveTo(Math.round(n[e]+i*h),Math.round(l[e]+o*h)),t.lineTo(Math.round(n[e]-i*_),Math.round(l[e]-o*_)),t.stroke();t.restore()}_draw_minor_ticks(t,e){if(!this.visuals.minor_tick_line.doit)return;const[i,o]=this._normals(),a=this._computed_image_dimensions(),[s,r]=[a.width*i,a.height*o],[n,l]=e.coords.minor,_=this.model.minor_tick_in,h=this.model.minor_tick_out;t.save(),t.translate(s,r),this.visuals.minor_tick_line.set_value(t);for(let e=0,a=n.length;e<a;e++)t.beginPath(),t.moveTo(Math.round(n[e]+i*h),Math.round(l[e]+o*h)),t.lineTo(Math.round(n[e]-i*_),Math.round(l[e]-o*_)),t.stroke();t.restore()}_draw_major_labels(t,e){if(!this.visuals.major_label_text.doit)return;const[i,o]=this._normals(),a=this._computed_image_dimensions(),[s,r]=[a.width*i,a.height*o],n=this.model.label_standoff+this._tick_extent(),[l,_]=[n*i,n*o],[h,m]=e.coords.major,d=e.labels.major;this.visuals.major_label_text.set_value(t),t.save(),t.translate(s+l,r+_);for(let e=0,a=h.length;e<a;e++)t.fillText(d[e],Math.round(h[e]+i*this.model.label_standoff),Math.round(m[e]+o*this.model.label_standoff));t.restore()}_draw_title(t){this.visuals.title_text.doit&&(t.save(),this.visuals.title_text.set_value(t),t.fillText(this.model.title,0,-this.model.title_standoff),t.restore())}_get_label_extent(){const t=this.tick_info().labels.major;let e;if(g.is_empty(t))e=0;else{const{ctx:i}=this.layer;switch(i.save(),this.visuals.major_label_text.set_value(i),this.model.orientation){case"vertical":e=g.max(t.map(t=>i.measureText(t.toString()).width));break;case"horizontal":e=u.measure_font(this.visuals.major_label_text.font_value()).height}e+=this.model.label_standoff,i.restore()}return e}_get_image_offset(){return{x:this.model.padding,y:this.model.padding+this._title_extent()}}_normals(){return"vertical"==this.model.orientation?[1,0]:[0,1]}_title_extent(){const t=this.model.title_text_font+" "+this.model.title_text_font_size+" "+this.model.title_text_font_style;return this.model.title?u.measure_font(t).height+this.model.title_standoff:0}_tick_extent(){return g.max([this.model.major_tick_out,this.model.minor_tick_out])}_computed_image_dimensions(){const t=this.plot_view.frame.bbox.height,e=this.plot_view.frame.bbox.width,i=this._title_extent();let o,a;switch(this.model.orientation){case"vertical":"auto"==this.model.height?null!=this.panel?o=t-2*this.model.padding-i:(o=g.max([25*this.model.color_mapper.palette.length,.3*t]),o=g.min([o,.8*t-2*this.model.padding-i])):o=this.model.height,a="auto"==this.model.width?25:this.model.width;break;case"horizontal":o="auto"==this.model.height?25:this.model.height,"auto"==this.model.width?null!=this.panel?a=e-2*this.model.padding:(a=g.max([25*this.model.color_mapper.palette.length,.3*e]),a=g.min([a,.8*e-2*this.model.padding])):a=this.model.width}return{width:a,height:o}}_tick_coordinate_scale(t){const e={source_range:new m.Range1d({start:this.model.color_mapper.metrics.min,end:this.model.color_mapper.metrics.max}),target_range:new m.Range1d({start:0,end:t})},{color_mapper:i}=this.model;if(i instanceof n.LinearColorMapper)return new l.LinearScale(e);if(i instanceof n.LogColorMapper)return new h.LogScale(e);if(i instanceof n.ScanningColorMapper){const{binning:t}=i.metrics;return new _.LinearInterpolationScale(Object.assign(Object.assign({},e),{binning:t}))}b.unreachable()}_format_major_labels(t,e){const i=this.model.formatter.doFormat(t,null);for(let t=0,o=e.length;t<o;t++)e[t]in this.model.major_label_overrides&&(i[t]=this.model.major_label_overrides[e[t]]);return i}tick_info(){const t=this._computed_image_dimensions();let e;switch(this.model.orientation){case"vertical":e=t.height;break;case"horizontal":e=t.width}const i=this._tick_coordinate_scale(e),[o,a]=this._normals(),[s,r]=[this.model.color_mapper.metrics.min,this.model.color_mapper.metrics.max],n=this.model.ticker.get_ticks(s,r,null,null,this.model.ticker.desired_num_ticks),l=n.major,_=n.minor,h=[[],[]],m=[[],[]];for(let t=0,e=l.length;t<e;t++)l[t]<s||l[t]>r||(h[o].push(l[t]),h[a].push(0));for(let t=0,e=_.length;t<e;t++)_[t]<s||_[t]>r||(m[o].push(_[t]),m[a].push(0));const d={major:this._format_major_labels(h[o],l)},c={major:[[],[]],minor:[[],[]]};return c.major[o]=i.v_compute(h[o]),c.minor[o]=i.v_compute(m[o]),c.major[a]=h[a],c.minor[a]=m[a],"vertical"==this.model.orientation&&(c.major[o]=p.map(c.major[o],t=>e-t),c.minor[o]=p.map(c.minor[o],t=>e-t)),{coords:c,labels:d}}}i.ColorBarView=v,v.__name__="ColorBarView";class w extends a.Annotation{constructor(t){super(t)}static init_ColorBar(){this.prototype.default_view=v,this.mixins([["major_label_",d.Text],["title_",d.Text],["major_tick_",d.Line],["minor_tick_",d.Line],["border_",d.Line],["bar_",d.Line],["background_",d.Fill]]),this.define({location:[c.Any,"top_right"],orientation:[c.Orientation,"vertical"],title:[c.String],title_standoff:[c.Number,2],width:[c.Any,"auto"],height:[c.Any,"auto"],scale_alpha:[c.Number,1],ticker:[c.Instance,()=>new s.BasicTicker],formatter:[c.Instance,()=>new r.BasicTickFormatter],major_label_overrides:[c.Any,{}],color_mapper:[c.Instance],label_standoff:[c.Number,5],margin:[c.Number,30],padding:[c.Number,10],major_tick_in:[c.Number,5],major_tick_out:[c.Number,0],minor_tick_in:[c.Number,0],minor_tick_out:[c.Number,0]}),this.override({background_fill_color:"#ffffff",background_fill_alpha:.95,bar_line_color:null,border_line_color:null,major_label_text_align:"center",major_label_text_baseline:"middle",major_label_text_font_size:"11px",major_tick_line_color:"#ffffff",minor_tick_line_color:null,title_text_font_size:"13px",title_text_font_style:"italic"})}}i.ColorBar=w,w.__name__="ColorBar",w.init_ColorBar()},
function _(e,c,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(127);class r extends i.AdaptiveTicker{constructor(e){super(e)}}s.BasicTicker=r,r.__name__="BasicTicker"},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});const a=t(1),s=t(128),n=t(9),r=a.__importStar(t(18));class _ extends s.ContinuousTicker{constructor(t){super(t)}static init_AdaptiveTicker(){this.define({base:[r.Number,10],mantissas:[r.Array,[1,2,5]],min_interval:[r.Number,0],max_interval:[r.Number]})}initialize(){super.initialize();const t=n.nth(this.mantissas,-1)/this.base,i=n.nth(this.mantissas,0)*this.base;this.extended_mantissas=[t,...this.mantissas,i],this.base_factor=0===this.get_min_interval()?1:this.get_min_interval()}get_interval(t,i,e){const a=i-t,s=this.get_ideal_interval(t,i,e),r=Math.floor(function(t,i=Math.E){return Math.log(t)/Math.log(i)}(s/this.base_factor,this.base)),_=this.base**r*this.base_factor,h=this.extended_mantissas,m=h.map(t=>Math.abs(e-a/(t*_))),o=h[n.argmin(m)];return c=o*_,l=this.get_min_interval(),u=this.get_max_interval(),Math.max(l,Math.min(u,c));var c,l,u}}e.AdaptiveTicker=_,_.__name__="AdaptiveTicker",_.init_AdaptiveTicker()},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});const n=t(1),r=t(129),s=n.__importStar(t(18)),o=t(9);class _ extends r.Ticker{constructor(t){super(t)}static init_ContinuousTicker(){this.define({num_minor_ticks:[s.Number,5],desired_num_ticks:[s.Number,6]})}get_ticks(t,i,e,n,r){return this.get_ticks_no_defaults(t,i,n,this.desired_num_ticks)}get_ticks_no_defaults(t,i,e,n){const r=this.get_interval(t,i,n),s=Math.floor(t/r),_=Math.ceil(i/r);let c;c=isFinite(s)&&isFinite(_)?o.range(s,_+1):[];const u=c.map(t=>t*r).filter(e=>t<=e&&e<=i),a=this.num_minor_ticks,l=[];if(a>0&&u.length>0){const e=r/a,n=o.range(0,a).map(t=>t*e);for(const e of n.slice(1)){const n=u[0]-e;t<=n&&n<=i&&l.push(n)}for(const e of u)for(const r of n){const n=e+r;t<=n&&n<=i&&l.push(n)}}return{major:u,minor:l}}get_min_interval(){return this.min_interval}get_max_interval(){return null!=this.max_interval?this.max_interval:1/0}get_ideal_interval(t,i,e){return(i-t)/e}}e.ContinuousTicker=_,_.__name__="ContinuousTicker",_.init_ContinuousTicker()},
function _(e,c,n){Object.defineProperty(n,"__esModule",{value:!0});const o=e(81);class r extends o.Model{constructor(e){super(e)}}n.Ticker=r,r.__name__="Ticker"},
function _(i,t,e){Object.defineProperty(e,"__esModule",{value:!0});const r=i(1),s=i(131),n=r.__importStar(i(18));class o extends s.TickFormatter{constructor(i){super(i),this.last_precision=3}static init_BasicTickFormatter(){this.define({precision:[n.Any,"auto"],use_scientific:[n.Boolean,!0],power_limit_high:[n.Number,5],power_limit_low:[n.Number,-3]})}get scientific_limit_low(){return 10**this.power_limit_low}get scientific_limit_high(){return 10**this.power_limit_high}_need_sci(i){if(!this.use_scientific)return!1;const{scientific_limit_high:t}=this,{scientific_limit_low:e}=this,r=i.length<2?0:Math.abs(i[1]-i[0])/1e4;for(const s of i){const i=Math.abs(s);if(!(i<=r)&&(i>=t||i<=e))return!0}return!1}_format_with_precision(i,t,e){const r=new Array(i.length);if(t)for(let t=0,s=i.length;t<s;t++)r[t]=i[t].toExponential(e);else for(let t=0,s=i.length;t<s;t++)r[t]=i[t].toFixed(e).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,"");return r}_auto_precision(i,t){const e=new Array(i.length),r=this.last_precision<=15;i:for(let s=this.last_precision;r?s<=15:s>=1;r?s++:s--){if(t){e[0]=i[0].toExponential(s);for(let t=1;t<i.length;t++)if(e[t]==e[t-1])continue i;this.last_precision=s;break}e[0]=i[0].toFixed(s).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,"");for(let t=1;t<i.length;t++)if(e[t]=i[t].toFixed(s).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,""),e[t]==e[t-1])continue i;this.last_precision=s;break}return this.last_precision}doFormat(i,t){if(0==i.length)return[];const e=this._need_sci(i),r="auto"==this.precision?this._auto_precision(i,e):this.precision;return this._format_with_precision(i,e,r)}}e.BasicTickFormatter=o,o.__name__="BasicTickFormatter",o.init_BasicTickFormatter()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});const r=e(81);class c extends r.Model{constructor(e){super(e)}}o.TickFormatter=c,c.__name__="TickFormatter"},
function _(r,a,o){Object.defineProperty(o,"__esModule",{value:!0});var e=r(133);o.CategoricalColorMapper=e.CategoricalColorMapper;var p=r(138);o.CategoricalMarkerMapper=p.CategoricalMarkerMapper;var l=r(139);o.CategoricalPatternMapper=l.CategoricalPatternMapper;var C=r(140);o.ContinuousColorMapper=C.ContinuousColorMapper;var M=r(135);o.ColorMapper=M.ColorMapper;var n=r(141);o.LinearColorMapper=n.LinearColorMapper;var t=r(142);o.LogColorMapper=t.LogColorMapper;var i=r(143);o.ScanningColorMapper=i.ScanningColorMapper;var c=r(144);o.EqHistColorMapper=c.EqHistColorMapper},
function _(r,t,e){Object.defineProperty(e,"__esModule",{value:!0});const o=r(1),a=r(134),c=r(135),i=o.__importStar(r(18));class s extends c.ColorMapper{constructor(r){super(r)}static init_CategoricalColorMapper(){this.define({factors:[i.Array],start:[i.Number,0],end:[i.Number]})}_v_compute(r,t,e,{nan_color:o}){a.cat_v_compute(r,this.factors,e,t,this.start,this.end,o)}}e.CategoricalColorMapper=s,s.__name__="CategoricalColorMapper",s.init_CategoricalColorMapper()},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});const l=e(12),i=e(8);function u(e,n){if(e.length!=n.length)return!1;for(let t=0,l=e.length;t<l;t++)if(e[t]!==n[t])return!1;return!0}t._cat_equals=u,t.cat_v_compute=function(e,n,t,c,f,o,r){for(let _=0,g=e.length;_<g;_++){let g,s,d=e[_];i.isString(d)?g=l.index_of(n,d):(null!=f?d=null!=o?d.slice(f,o):d.slice(f):null!=o&&(d=d.slice(0,o)),g=1==d.length?l.index_of(n,d[0]):l.find_index(n,e=>u(e,d))),s=g<0||g>=t.length?r:t[g],c[_]=s}}},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});const n=t(1),o=t(136),_=n.__importStar(t(18)),i=t(8),l=t(22),c=t(32);function a(t){return i.isNumber(t)?t:("#"!=t[0]&&(t=l.color2hex(t)),9!=t.length&&(t+="ff"),parseInt(t.slice(1),16))}function s(t){const e=new Uint32Array(t.length);for(let r=0,n=t.length;r<n;r++)e[r]=a(t[r]);return e}function p(t){if(c.is_little_endian){const e=new DataView(t.buffer);for(let r=0,n=t.length;r<n;r++)e.setUint32(4*r,t[r])}return new Uint8Array(t.buffer)}r._convert_color=a,r._convert_palette=s,r._uint32_to_rgba=p;class u extends o.Mapper{constructor(t){super(t)}static init_ColorMapper(){this.define({palette:[_.Any],nan_color:[_.Color,"gray"]})}v_compute(t){const e=new Array(t.length);return this._v_compute(t,e,this.palette,this._colors(t=>t)),e}get rgba_mapper(){const t=this,e=s(this.palette),r=this._colors(a);return{v_compute(n){const o=new Uint32Array(n.length);return t._v_compute(n,o,e,r),p(o)}}}_colors(t){return{nan_color:t(this.nan_color)}}}r.ColorMapper=u,u.__name__="ColorMapper",u.init_ColorMapper()},
function _(e,r,n){Object.defineProperty(n,"__esModule",{value:!0});const o=e(137);class s extends o.Transform{constructor(e){super(e)}compute(e){throw new Error("mapping single values is not supported")}}n.Mapper=s,s.__name__="Mapper"},
function _(e,n,o){Object.defineProperty(o,"__esModule",{value:!0});const r=e(81);class s extends r.Model{constructor(e){super(e)}}o.Transform=s,s.__name__="Transform"},
function _(r,e,a){Object.defineProperty(a,"__esModule",{value:!0});const t=r(1),s=r(134),i=r(136),c=t.__importStar(r(18));class n extends i.Mapper{constructor(r){super(r)}static init_CategoricalMarkerMapper(){this.define({factors:[c.Array],markers:[c.Array],start:[c.Number,0],end:[c.Number],default_value:[c.MarkerType,"circle"]})}v_compute(r){const e=new Array(r.length);return s.cat_v_compute(r,this.factors,this.markers,e,this.start,this.end,this.default_value),e}}a.CategoricalMarkerMapper=n,n.__name__="CategoricalMarkerMapper",n.init_CategoricalMarkerMapper()},
function _(t,e,a){Object.defineProperty(a,"__esModule",{value:!0});const r=t(1),n=t(134),s=t(136),i=r.__importStar(t(18));class c extends s.Mapper{constructor(t){super(t)}static init_CategoricalPatternMapper(){this.define({factors:[i.Array],patterns:[i.Array],start:[i.Number,0],end:[i.Number],default_value:[i.HatchPatternType," "]})}v_compute(t){const e=new Array(t.length);return n.cat_v_compute(t,this.factors,this.patterns,e,this.start,this.end,this.default_value),e}}a.CategoricalPatternMapper=c,c.__name__="CategoricalPatternMapper",c.init_CategoricalPatternMapper()},
function _(t,o,e){Object.defineProperty(e,"__esModule",{value:!0});const n=t(135),s=t(90),l=t(9),i=t(8);class c extends n.ColorMapper{constructor(t){super(t),this._scan_data=null}static init_ContinuousColorMapper(){this.define(({Number:t,String:o,Null:e,Ref:n,Color:l,Or:i,Tuple:c,Array:a})=>({high:[i(t,e),null],low:[i(t,e),null],high_color:[i(l,e),null],low_color:[i(l,e),null],domain:[a(c(n(s.GlyphRenderer),i(o,a(o)))),[]]}))}connect_signals(){super.connect_signals();const t=()=>{for(const[t]of this.domain)this.connect(t.view.change,()=>this.update_data()),this.connect(t.data_source.selected.change,()=>this.update_data())};this.connect(this.properties.domain.change,()=>t()),t()}update_data(){const{domain:t,palette:o}=this,e=[...this._collect(t)];this._scan_data=this.scan(e,o.length),this.change.emit()}get metrics(){return null==this._scan_data&&this.update_data(),this._scan_data}*_collect(t){for(const[o,e]of t)for(const t of i.isArray(e)?e:[e]){let e=o.data_source.get_column(t);e=o.view.indices.select(e);const n=o.view.masked,s=o.data_source.selected.indices;let c;if(null!=n&&s.length>0?c=l.intersection([...n],s):null!=n?c=[...n]:s.length>0&&(c=s),null!=c&&(e=l.map(c,t=>e[t])),e.length>0&&!i.isNumber(e[0]))for(const t of e)yield*t;else yield*e}}_v_compute(t,o,e,n){const{nan_color:s}=n;let{low_color:i,high_color:c}=n;null==i&&(i=e[0]),null==c&&(c=e[e.length-1]);const{domain:a}=this,r=l.is_empty(a)?t:[...this._collect(a)];this._scan_data=this.scan(r,e.length);for(let n=0,l=t.length;n<l;n++){const l=t[n];isNaN(l)?o[n]=s:o[n]=this.cmap(l,e,i,c,this._scan_data)}}_colors(t){return Object.assign(Object.assign({},super._colors(t)),{low_color:null!=this.low_color?t(this.low_color):void 0,high_color:null!=this.high_color?t(this.high_color):void 0})}}e.ContinuousColorMapper=c,c.__name__="ContinuousColorMapper",c.init_ContinuousColorMapper()},
function _(n,r,o){Object.defineProperty(o,"__esModule",{value:!0});const e=n(140),t=n(12);class a extends e.ContinuousColorMapper{constructor(n){super(n)}scan(n,r){const o=null!=this.low?this.low:t.min(n),e=null!=this.high?this.high:t.max(n);return{max:e,min:o,norm_factor:1/(e-o),normed_interval:1/r}}cmap(n,r,o,e,t){const a=r.length-1;if(n==t.max)return r[a];const i=(n-t.min)*t.norm_factor,l=Math.floor(i/t.normed_interval);return l<0?o:l>a?e:r[l]}}o.LinearColorMapper=a,a.__name__="LinearColorMapper"},
function _(o,t,n){Object.defineProperty(n,"__esModule",{value:!0});const e=o(140),r=o(12);class l extends e.ContinuousColorMapper{constructor(o){super(o)}scan(o,t){const n=null!=this.low?this.low:r.min(o),e=null!=this.high?this.high:r.max(o);return{max:e,min:n,scale:t/(Math.log(e)-Math.log(n))}}cmap(o,t,n,e,r){const l=t.length-1;if(o>r.max)return e;if(o==r.max)return t[l];if(o<r.min)return n;const a=Math.log(o)-Math.log(r.min);let s=Math.floor(a*r.scale);return s>l&&(s=l),t[s]}}n.LogColorMapper=l,l.__name__="LogColorMapper"},
function _(n,e,r){Object.defineProperty(r,"__esModule",{value:!0});const i=n(140),o=n(12);class t extends i.ContinuousColorMapper{constructor(n){super(n)}cmap(n,e,r,i,t){if(n<t.binning[0])return r;if(n>t.binning[t.binning.length-1])return i;return e[o.left_edge_index(n,t.binning)]}}r.ScanningColorMapper=t,t.__name__="ScanningColorMapper"},
function _(n,t,e){Object.defineProperty(e,"__esModule",{value:!0});const i=n(1),o=n(143),r=n(12),s=n(9),a=i.__importStar(n(18)),l=n(19);class p extends o.ScanningColorMapper{constructor(n){super(n)}static init_EqHistColorMapper(){this.define({bins:[a.Int,65536]})}scan(n,t){const e=null!=this.low?this.low:r.min(n),i=null!=this.high?this.high:r.max(n),o=this.bins,a=s.linspace(e,i,o+1),p=r.bin_counts(n,a),c=new Array(o);for(let n=0,t=a.length;n<t-1;n++){const t=a[n],e=a[n+1];c[n]=(t+e)/2}const h=s.cumsum(p),u=h[h.length-1],g=r.map(h,n=>n/u);let m=t-1,_=[],M=0,f=2*t;for(;m!=t&&M<4&&0!=m;){const n=f/m;if(n>1e3)break;f=Math.round(Math.max(t*n,t));const e=s.range(0,f),i=r.map(g,n=>n*(f-1));_=r.interpolate(e,i,c);m=s.uniq(_).length-1,M++}if(0==m){_=[e,i];for(let n=0;n<t-1;n++)_.push(i)}else _=_.slice(_.length-t-1),m!=t&&l.logger.warn("EqHistColorMapper warning: Histogram equalization did not converge.");return{min:e,max:i,binning:_}}}e.EqHistColorMapper=p,p.__name__="EqHistColorMapper",p.init_EqHistColorMapper()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const r=e(1),i=e(146),_=r.__importStar(e(18));class a extends i.ContinuousScale{constructor(e){super(e)}static init_LinearScale(){this.internal({scan_result:[_.Any]})}compute(e){return this._linear_compute(e)}v_compute(e){return this._linear_v_compute(e)}invert(e){return this._linear_invert(e)}v_invert(e){return this._linear_v_invert(e)}}n.LinearScale=a,a.__name__="LinearScale",a.init_LinearScale()},
function _(e,n,o){Object.defineProperty(o,"__esModule",{value:!0});const c=e(147);class s extends c.Scale{constructor(e){super(e)}}o.ContinuousScale=s,s.__name__="ContinuousScale"},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});const n=t(1),_=t(148),s=t(24),i=n.__importStar(t(18));class a extends _.Transform{constructor(t){super(t)}static init_Scale(){this.internal({source_range:[i.Any],target_range:[i.Any]})}r_compute(t,e){return this.target_range.is_reversed?[this.compute(e),this.compute(t)]:[this.compute(t),this.compute(e)]}r_invert(t,e){return this.target_range.is_reversed?[this.invert(e),this.invert(t)]:[this.invert(t),this.invert(e)]}_linear_compute(t){const[e,r]=this._linear_compute_state();return e*t+r}_linear_v_compute(t){const[e,r]=this._linear_compute_state(),n=new s.NumberArray(t.length);for(let _=0;_<t.length;_++)n[_]=e*t[_]+r;return n}_linear_invert(t){const[e,r]=this._linear_compute_state();return(t-r)/e}_linear_v_invert(t){const[e,r]=this._linear_compute_state(),n=new s.NumberArray(t.length);for(let _=0;_<t.length;_++)n[_]=(t[_]-r)/e;return n}_linear_compute_state(){const t=this.source_range.start,e=this.source_range.end,r=this.target_range.start,n=(this.target_range.end-r)/(e-t);return[n,-n*t+r]}}r.Scale=a,a.__name__="Scale",a.init_Scale()},
function _(r,o,t){Object.defineProperty(t,"__esModule",{value:!0});var e=r(149);t.CustomJSTransform=e.CustomJSTransform;var a=r(150);t.Dodge=a.Dodge;var n=r(152);t.Interpolator=n.Interpolator;var p=r(153);t.Jitter=p.Jitter;var l=r(154);t.LinearInterpolator=l.LinearInterpolator;var v=r(155);t.StepInterpolator=v.StepInterpolator;var s=r(137);t.Transform=s.Transform},
function _(t,r,s){Object.defineProperty(s,"__esModule",{value:!0});const n=t(1),e=t(137),a=n.__importStar(t(18)),o=t(13),u=t(29);class i extends e.Transform{constructor(t){super(t)}static init_CustomJSTransform(){this.define({args:[a.Any,{}],func:[a.String,""],v_func:[a.String,""]})}get names(){return o.keys(this.args)}get values(){return o.values(this.args)}_make_transform(t,r){return new Function(...this.names,t,u.use_strict(r))}get scalar_transform(){return this._make_transform("x",this.func)}get vector_transform(){return this._make_transform("xs",this.v_func)}compute(t){return this.scalar_transform(...this.values,t)}v_compute(t){return this.vector_transform(...this.values,t)}}s.CustomJSTransform=i,i.__name__="CustomJSTransform",i.init_CustomJSTransform()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const o=e(1),r=e(151),_=o.__importStar(e(18));class i extends r.RangeTransform{constructor(e){super(e)}static init_Dodge(){this.define({value:[_.Number,0]})}_compute(e){return e+this.value}}n.Dodge=i,i.__name__="Dodge",i.init_Dodge()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const r=e(1),s=e(137),a=e(98),i=r.__importStar(e(18)),o=e(24),c=e(8);class u extends s.Transform{constructor(e){super(e)}static init_RangeTransform(){this.define({range:[i.Instance]})}v_compute(e){let t;if(this.range instanceof a.FactorRange)t=this.range.v_synthetic(e);else{if(!c.isArrayableOf(e,c.isNumber))throw new Error("unexpected");t=e}const n=new o.NumberArray(t.length);for(let e=0;e<t.length;e++){const r=t[e];n[e]=this._compute(r)}return n}compute(e){if(this.range instanceof a.FactorRange)return this._compute(this.range.synthetic(e));if(c.isNumber(e))return this._compute(e);throw new Error("unexpected")}}n.RangeTransform=u,u.__name__="RangeTransform",u.init_RangeTransform()},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});const n=t(1),o=t(137),s=n.__importStar(t(18)),i=t(24),a=t(9),h=t(8);class d extends o.Transform{constructor(t){super(t),this._sorted_dirty=!0}static init_Interpolator(){this.define({x:[s.Any],y:[s.Any],data:[s.Any],clip:[s.Boolean,!0]})}connect_signals(){super.connect_signals(),this.connect(this.change,()=>this._sorted_dirty=!0)}v_compute(t){const e=new i.NumberArray(t.length);for(let r=0;r<t.length;r++){const n=t[r];e[r]=this.compute(n)}return e}sort(t=!1){if(!this._sorted_dirty)return;let e,r;if(h.isString(this.x)&&h.isString(this.y)&&null!=this.data){const t=this.data.columns();if(!a.includes(t,this.x))throw new Error("The x parameter does not correspond to a valid column name defined in the data parameter");if(!a.includes(t,this.y))throw new Error("The y parameter does not correspond to a valid column name defined in the data parameter");e=this.data.get_column(this.x),r=this.data.get_column(this.y)}else{if(!h.isArray(this.x)||!h.isArray(this.y))throw new Error("parameters 'x' and 'y' must be both either string fields or arrays");e=this.x,r=this.y}if(e.length!==r.length)throw new Error("The length for x and y do not match");if(e.length<2)throw new Error("x and y must have at least two elements to support interpolation");const n=e.length,o=new Uint32Array(n);for(let t=0;t<n;t++)o[t]=t;const s=t?-1:1;o.sort((t,r)=>s*(e[t]-e[r])),this._x_sorted=new i.NumberArray(n),this._y_sorted=new i.NumberArray(n);for(let t=0;t<n;t++)this._x_sorted[t]=e[o[t]],this._y_sorted[t]=r[o[t]];this._sorted_dirty=!1}}r.Interpolator=d,d.__name__="Interpolator",d.init_Interpolator()},
function _(t,i,e){Object.defineProperty(e,"__esModule",{value:!0});const r=t(1),s=t(151),n=r.__importStar(t(18)),u=r.__importStar(t(10));class o extends s.RangeTransform{constructor(t){super(t)}static init_Jitter(){this.define({mean:[n.Number,0],width:[n.Number,1],distribution:[n.Distribution,"uniform"]})}v_compute(t){return null!=this.previous_values&&this.previous_values.length==t.length||(this.previous_values=super.v_compute(t)),this.previous_values}_compute(t){switch(this.distribution){case"uniform":return t+this.mean+(u.random()-.5)*this.width;case"normal":return t+u.rnorm(this.mean,this.width)}}}e.Jitter=o,o.__name__="Jitter",o.init_Jitter()},
function _(t,s,e){Object.defineProperty(e,"__esModule",{value:!0});const _=t(9),r=t(152);class o extends r.Interpolator{constructor(t){super(t)}compute(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}if(t==this._x_sorted[0])return this._y_sorted[0];const s=_.find_last_index(this._x_sorted,s=>s<t),e=this._x_sorted[s],r=this._x_sorted[s+1],o=this._y_sorted[s],i=this._y_sorted[s+1];return o+(t-e)/(r-e)*(i-o)}}e.LinearInterpolator=o,o.__name__="LinearInterpolator"},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});const s=t(1),o=t(152),_=s.__importStar(t(18)),i=t(9);class n extends o.Interpolator{constructor(t){super(t)}static init_StepInterpolator(){this.define({mode:[_.StepMode,"after"]})}compute(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}let e;switch(this.mode){case"after":e=i.find_last_index(this._x_sorted,e=>t>=e);break;case"before":e=i.find_index(this._x_sorted,e=>t<=e);break;case"center":{const r=this._x_sorted.map(e=>Math.abs(e-t)),s=i.min(r);e=i.find_index(r,t=>s===t);break}default:throw new Error("unknown mode: "+this.mode)}return-1!=e?this._y_sorted[e]:NaN}}r.StepInterpolator=n,n.__name__="StepInterpolator",n.init_StepInterpolator()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const r=e(1),a=e(147),i=e(24),s=e(9),o=e(12),c=r.__importStar(e(18));class _ extends a.Scale{constructor(e){super(e)}static init_LinearInterpolationScale(){this.internal({binning:[c.Array]})}compute(e){return e}v_compute(e){const t=o.norm(e,this.source_range.start,this.source_range.end),n=s.linspace(0,1,this.binning.length),r=o.interpolate(t,n,this.binning),a=o.norm(r,this.source_range.start,this.source_range.end),c=this.target_range.end-this.target_range.start,_=o.map(a,e=>this.target_range.start+e*c);return new i.NumberArray(_)}invert(e){return e}v_invert(e){return new i.NumberArray(e)}}n.LinearInterpolationScale=_,_.__name__="LinearInterpolationScale",_.init_LinearInterpolationScale()},
function _(t,e,o){Object.defineProperty(o,"__esModule",{value:!0});const a=t(146),r=t(24);class s extends a.ContinuousScale{constructor(t){super(t)}compute(t){const[e,o,a,r]=this._compute_state();let s;if(0==a)s=0;else{const n=(Math.log(t)-r)/a;s=isFinite(n)?n*e+o:NaN}return s}v_compute(t){const[e,o,a,s]=this._compute_state(),n=new r.NumberArray(t.length);if(0==a)for(let e=0;e<t.length;e++)n[e]=0;else for(let r=0;r<t.length;r++){const l=(Math.log(t[r])-s)/a;let c;c=isFinite(l)?l*e+o:NaN,n[r]=c}return n}invert(t){const[e,o,a,r]=this._compute_state(),s=(t-o)/e;return Math.exp(a*s+r)}v_invert(t){const[e,o,a,s]=this._compute_state(),n=new r.NumberArray(t.length);for(let r=0;r<t.length;r++){const l=(t[r]-o)/e;n[r]=Math.exp(a*l+s)}return n}_get_safe_factor(t,e){let o=t<0?0:t,a=e<0?0:e;if(o==a)if(0==o)[o,a]=[1,10];else{const t=Math.log(o)/Math.log(10);o=10**Math.floor(t),a=Math.ceil(t)!=Math.floor(t)?10**Math.ceil(t):10**(Math.ceil(t)+1)}return[o,a]}_compute_state(){const t=this.source_range.start,e=this.source_range.end,o=this.target_range.start,a=this.target_range.end-o,[r,s]=this._get_safe_factor(t,e);let n,l;0==r?(n=Math.log(s),l=0):(n=Math.log(s)-Math.log(r),l=Math.log(r));return[a,o,n,l]}}o.LogScale=s,s.__name__="LogScale"},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const i=t(1),n=t(99),r=i.__importStar(t(18));class a extends n.Range{constructor(t){super(t)}static init_Range1d(){this.define({start:[r.Number,0],end:[r.Number,1],reset_start:[r.Number],reset_end:[r.Number]})}_set_auto_bounds(){if("auto"==this.bounds){const t=Math.min(this.reset_start,this.reset_end),e=Math.max(this.reset_start,this.reset_end);this.setv({bounds:[t,e]},{silent:!0})}}initialize(){super.initialize(),null==this.reset_start&&(this.reset_start=this.start),null==this.reset_end&&(this.reset_end=this.end),this._set_auto_bounds()}get min(){return Math.min(this.start,this.end)}get max(){return Math.max(this.start,this.end)}reset(){this._set_auto_bounds(),this.start!=this.reset_start||this.end!=this.reset_end?this.setv({start:this.reset_start,end:this.reset_end}):this.change.emit()}}s.Range1d=a,a.__name__="Range1d",a.init_Range1d()},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});const o=t(72),i=new Map;n.measure_font=function(t){const e=i.get(t);if(null!=e)return e;const n=o.span({style:{font:t}},"Hg"),l=o.div({style:{display:"inline-block",width:"1px",height:"0px"}}),s=o.div({},n,l);document.body.appendChild(s);try{l.style.verticalAlign="baseline";const e=o.offset(l).top-o.offset(n).top;l.style.verticalAlign="bottom";const d=o.offset(l).top-o.offset(n).top,c={height:d,ascent:e,descent:d-e};return i.set(t,c),c}finally{document.body.removeChild(s)}};const l=new Map;n.measure_text=function(t,e){let n=l.get(e);if(null!=n){const e=n.get(t);if(null!=e)return e}else n=new Map,l.set(e,n);const i=o.div({style:{display:"inline-block","white-space":"nowrap",font:e}},t);document.body.appendChild(i);try{const{width:e,height:o}=i.getBoundingClientRect();return n.set(t,{width:e,height:o}),{width:e,height:o}}finally{document.body.removeChild(i)}}},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const s=t(1),a=t(161),l=s.__importStar(t(28)),n=s.__importStar(t(18));class o extends a.TextAnnotationView{initialize(){super.initialize(),this.visuals.warm_cache()}_get_size(){const{ctx:t}=this.layer;this.visuals.text.set_value(t);const{width:e,ascent:i}=t.measureText(this.model.text);return{width:e,height:i}}_render(){let t;switch(this.model.angle_units){case"rad":t=-this.model.angle;break;case"deg":t=-this.model.angle*Math.PI/180}const e=null!=this.panel?this.panel:this.plot_view.frame,i=this.coordinates.x_scale,s=this.coordinates.y_scale;let a="data"==this.model.x_units?i.compute(this.model.x):e.xview.compute(this.model.x),l="data"==this.model.y_units?s.compute(this.model.y):e.yview.compute(this.model.y);a+=this.model.x_offset,l-=this.model.y_offset;("canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this))(this.layer.ctx,this.model.text,a,l,t)}}i.LabelView=o,o.__name__="LabelView";class _ extends a.TextAnnotation{constructor(t){super(t)}static init_Label(){this.prototype.default_view=o,this.mixins([l.Text,["border_",l.Line],["background_",l.Fill]]),this.define({x:[n.Number],x_units:[n.SpatialUnits,"data"],y:[n.Number],y_units:[n.SpatialUnits,"data"],text:[n.String],angle:[n.Angle,0],angle_units:[n.AngleUnits,"rad"],x_offset:[n.Number,0],y_offset:[n.Number,0]}),this.override({background_fill_color:null,border_line_color:null})}}i.Label=_,_.__name__="Label",_.init_Label()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),l=e(36),a=e(72),n=i.__importStar(e(18)),o=e(159),r=e(11);class _ extends l.AnnotationView{constructor(){super(...arguments),this.rotate=!0}initialize(){super.initialize(),"css"==this.model.render_mode&&(this.el=a.div(),this.plot_view.canvas_view.add_overlay(this.el))}remove(){null!=this.el&&a.remove(this.el),super.remove()}connect_signals(){super.connect_signals(),"css"==this.model.render_mode?this.connect(this.model.change,()=>this.render()):this.connect(this.model.change,()=>this.plot_view.request_render())}render(){this.model.visible||"css"!=this.model.render_mode||a.undisplay(this.el),super.render()}_calculate_text_dimensions(e,t){const{width:s}=e.measureText(t),{height:i}=o.measure_font(this.visuals.text.font_value());return[s,i]}_calculate_bounding_box_dimensions(e,t){const[s,i]=this._calculate_text_dimensions(e,t);let l,a;switch(e.textAlign){case"left":l=0;break;case"center":l=-s/2;break;case"right":l=-s;break;default:r.unreachable()}switch(e.textBaseline){case"top":a=0;break;case"middle":a=-.5*i;break;case"bottom":a=-1*i;break;case"alphabetic":a=-.8*i;break;case"hanging":a=-.17*i;break;case"ideographic":a=-.83*i;break;default:r.unreachable()}return[l,a,s,i]}_canvas_text(e,t,s,i,l){this.visuals.text.set_value(e);const a=this._calculate_bounding_box_dimensions(e,t);e.save(),e.beginPath(),e.translate(s,i),l&&e.rotate(l),e.rect(a[0],a[1],a[2],a[3]),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(e),e.fill()),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(e),e.stroke()),this.visuals.text.doit&&(this.visuals.text.set_value(e),e.fillText(t,0,0)),e.restore()}_css_text(e,t,s,i,l){const{el:n}=this;r.assert(null!=n),a.undisplay(n),this.visuals.text.set_value(e);const o=this._calculate_bounding_box_dimensions(e,t),_=this.visuals.border_line.line_dash.value().length<2?"solid":"dashed";this.visuals.border_line.set_value(e),this.visuals.background_fill.set_value(e),n.style.position="absolute",n.style.left=s+o[0]+"px",n.style.top=i+o[1]+"px",n.style.color=""+this.visuals.text.text_color.value(),n.style.opacity=""+this.visuals.text.text_alpha.value(),n.style.font=""+this.visuals.text.font_value(),n.style.lineHeight="normal",l&&(n.style.transform=`rotate(${l}rad)`),this.visuals.background_fill.doit&&(n.style.backgroundColor=""+this.visuals.background_fill.color_value()),this.visuals.border_line.doit&&(n.style.borderStyle=""+_,n.style.borderWidth=this.visuals.border_line.line_width.value()+"px",n.style.borderColor=""+this.visuals.border_line.color_value()),n.textContent=t,a.display(n)}}s.TextAnnotationView=_,_.__name__="TextAnnotationView";class u extends l.Annotation{constructor(e){super(e)}static init_TextAnnotation(){this.define({render_mode:[n.RenderMode,"canvas"]})}}s.TextAnnotation=u,u.__name__="TextAnnotation",u.init_TextAnnotation()},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const i=t(1),o=t(161),l=t(85),a=i.__importStar(t(28)),n=t(72),r=i.__importStar(t(18));class _ extends o.TextAnnotationView{initialize(){if(super.initialize(),this.set_data(this.model.source),"css"==this.model.render_mode)for(let t=0,e=this._text.length;t<e;t++){const t=n.div({style:{display:"none"}});this.el.appendChild(t)}}connect_signals(){super.connect_signals(),"css"==this.model.render_mode?(this.connect(this.model.change,()=>{this.set_data(this.model.source),this.render()}),this.connect(this.model.source.streaming,()=>{this.set_data(this.model.source),this.render()}),this.connect(this.model.source.patching,()=>{this.set_data(this.model.source),this.render()}),this.connect(this.model.source.change,()=>{this.set_data(this.model.source),this.render()})):(this.connect(this.model.change,()=>{this.set_data(this.model.source),this.plot_view.request_render()}),this.connect(this.model.source.streaming,()=>{this.set_data(this.model.source),this.plot_view.request_render()}),this.connect(this.model.source.patching,()=>{this.set_data(this.model.source),this.plot_view.request_render()}),this.connect(this.model.source.change,()=>{this.set_data(this.model.source),this.plot_view.request_render()}))}set_data(t){super.set_data(t),this.visuals.warm_cache(t)}_map_data(){const t=this.coordinates.x_scale,e=this.coordinates.y_scale,s=null!=this.panel?this.panel:this.plot_view.frame;return["data"==this.model.x_units?t.v_compute(this._x):s.xview.v_compute(this._x),"data"==this.model.y_units?e.v_compute(this._y):s.yview.v_compute(this._y)]}_render(){const t="canvas"==this.model.render_mode?this._v_canvas_text.bind(this):this._v_css_text.bind(this),{ctx:e}=this.layer,[s,i]=this._map_data();for(let o=0,l=this._text.length;o<l;o++)t(e,o,this._text[o],s[o]+this._x_offset[o],i[o]-this._y_offset[o],this._angle[o])}_get_size(){const{ctx:t}=this.layer;this.visuals.text.set_value(t);const{width:e,ascent:s}=t.measureText(this._text[0]);return{width:e,height:s}}_v_canvas_text(t,e,s,i,o,l){this.visuals.text.set_vectorize(t,e);const a=this._calculate_bounding_box_dimensions(t,s);t.save(),t.beginPath(),t.translate(i,o),t.rotate(l),t.rect(a[0],a[1],a[2],a[3]),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_vectorize(t,e),t.fill()),this.visuals.border_line.doit&&(this.visuals.border_line.set_vectorize(t,e),t.stroke()),this.visuals.text.doit&&(this.visuals.text.set_vectorize(t,e),t.fillText(s,0,0)),t.restore()}_v_css_text(t,e,s,i,o,l){const a=this.el.children[e];a.textContent=s,this.visuals.text.set_vectorize(t,e);const r=this._calculate_bounding_box_dimensions(t,s),_=this.visuals.border_line.line_dash.value().length<2?"solid":"dashed";this.visuals.border_line.set_vectorize(t,e),this.visuals.background_fill.set_vectorize(t,e),a.style.position="absolute",a.style.left=i+r[0]+"px",a.style.top=o+r[1]+"px",a.style.color=""+this.visuals.text.text_color.value(),a.style.opacity=""+this.visuals.text.text_alpha.value(),a.style.font=""+this.visuals.text.font_value(),a.style.lineHeight="normal",l&&(a.style.transform=`rotate(${l}rad)`),this.visuals.background_fill.doit&&(a.style.backgroundColor=""+this.visuals.background_fill.color_value()),this.visuals.border_line.doit&&(a.style.borderStyle=""+_,a.style.borderWidth=this.visuals.border_line.line_width.value()+"px",a.style.borderColor=""+this.visuals.border_line.color_value()),n.display(a)}}s.LabelSetView=_,_.__name__="LabelSetView";class h extends o.TextAnnotation{constructor(t){super(t)}static init_LabelSet(){this.prototype.default_view=_,this.mixins([a.TextVector,["border_",a.LineVector],["background_",a.FillVector]]),this.define({x:[r.NumberSpec],y:[r.NumberSpec],x_units:[r.SpatialUnits,"data"],y_units:[r.SpatialUnits,"data"],text:[r.StringSpec,{field:"text"}],angle:[r.AngleSpec,0],x_offset:[r.NumberSpec,{value:0}],y_offset:[r.NumberSpec,{value:0}],source:[r.Instance,()=>new l.ColumnDataSource]}),this.override({background_fill_color:null,border_line_color:null})}}s.LabelSet=h,h.__name__="LabelSet",h.init_LabelSet()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const s=t(1),l=t(36),n=s.__importStar(t(28)),h=s.__importStar(t(18)),a=t(15),_=t(159),o=t(79),r=t(9),d=t(8),c=t(11);class g extends l.AnnotationView{cursor(t,e){return"none"==this.model.click_policy?null:"pointer"}get legend_padding(){return null!=this.visuals.border_line.line_color.value()?this.model.padding:0}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.plot_view.request_render()),this.connect(this.model.item_change,()=>this.plot_view.request_render())}compute_legend_bbox(){const t=this.model.get_legend_names(),{glyph_height:e,glyph_width:i}=this.model,{label_height:s,label_width:l}=this.model;this.max_label_height=r.max([_.measure_font(this.visuals.label_text.font_value()).height,s,e]);const{ctx:n}=this.layer;n.save(),this.visuals.label_text.set_value(n),this.text_widths=new Map;for(const e of t)this.text_widths.set(e,r.max([n.measureText(e).width,l]));this.visuals.title_text.set_value(n),this.title_height=this.model.title?_.measure_font(this.visuals.title_text.font_value()).height+this.model.title_standoff:0,this.title_width=this.model.title?n.measureText(this.model.title).width:0,n.restore();const h=Math.max(r.max([...this.text_widths.values()]),0),a=this.model.margin,{legend_padding:g}=this,m=this.model.spacing,{label_standoff:b}=this.model;let u,f;if("vertical"==this.model.orientation)u=t.length*this.max_label_height+Math.max(t.length-1,0)*m+2*g+this.title_height,f=r.max([h+i+b+2*g,this.title_width+2*g]);else{let e=2*g+Math.max(t.length-1,0)*m;for(const[,t]of this.text_widths)e+=r.max([t,l])+i+b;f=r.max([this.title_width+2*g,e]),u=this.max_label_height+this.title_height+2*g}const x=null!=this.panel?this.panel:this.plot_view.frame,[p,w]=x.bbox.ranges,{location:v}=this.model;let y,k;if(d.isString(v))switch(v){case"top_left":y=p.start+a,k=w.start+a;break;case"top_center":y=(p.end+p.start)/2-f/2,k=w.start+a;break;case"top_right":y=p.end-a-f,k=w.start+a;break;case"bottom_right":y=p.end-a-f,k=w.end-a-u;break;case"bottom_center":y=(p.end+p.start)/2-f/2,k=w.end-a-u;break;case"bottom_left":y=p.start+a,k=w.end-a-u;break;case"center_left":y=p.start+a,k=(w.end+w.start)/2-u/2;break;case"center":y=(p.end+p.start)/2-f/2,k=(w.end+w.start)/2-u/2;break;case"center_right":y=p.end-a-f,k=(w.end+w.start)/2-u/2}else if(d.isArray(v)&&2==v.length){const[t,e]=v;y=x.xview.compute(t),k=x.yview.compute(e)-u}else c.unreachable();return new o.BBox({left:y,top:k,width:f,height:u})}interactive_bbox(){return this.compute_legend_bbox()}interactive_hit(t,e){return this.interactive_bbox().contains(t,e)}on_hit(t,e){let i;const{glyph_width:s}=this.model,{legend_padding:l}=this,n=this.model.spacing,{label_standoff:h}=this.model;let a=i=l;const _=this.compute_legend_bbox(),r="vertical"==this.model.orientation;for(const d of this.model.items){const c=d.get_labels_list_from_label_prop();for(const g of c){const c=_.x+a,m=_.y+i+this.title_height;let b,u;[b,u]=r?[_.width-2*l,this.max_label_height]:[this.text_widths.get(g)+s+h,this.max_label_height];if(new o.BBox({left:c,top:m,width:b,height:u}).contains(t,e)){switch(this.model.click_policy){case"hide":for(const t of d.renderers)t.visible=!t.visible;break;case"mute":for(const t of d.renderers)t.muted=!t.muted}return!0}r?i+=this.max_label_height+n:a+=this.text_widths.get(g)+s+h+n}}return!1}_render(){if(0==this.model.items.length)return;for(const t of this.model.items)t.legend=this.model;const{ctx:t}=this.layer,e=this.compute_legend_bbox();t.save(),this._draw_legend_box(t,e),this._draw_legend_items(t,e),this.model.title&&this._draw_title(t,e),t.restore()}_draw_legend_box(t,e){t.beginPath(),t.rect(e.x,e.y,e.width,e.height),this.visuals.background_fill.set_value(t),t.fill(),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.stroke())}_draw_legend_items(t,e){const{glyph_width:i,glyph_height:s}=this.model,{legend_padding:l}=this,n=this.model.spacing,{label_standoff:h}=this.model;let a=l,_=l;const o="vertical"==this.model.orientation;for(const d of this.model.items){const c=d.get_labels_list_from_label_prop(),g=d.get_field_from_label_prop();if(0==c.length)continue;const m=(()=>{switch(this.model.click_policy){case"none":return!0;case"hide":return r.every(d.renderers,t=>t.visible);case"mute":return r.every(d.renderers,t=>!t.muted)}})();for(const r of c){const c=e.x+a,b=e.y+_+this.title_height,u=c+i,f=b+s;o?_+=this.max_label_height+n:a+=this.text_widths.get(r)+i+h+n,this.visuals.label_text.set_value(t),t.fillText(r,u+h,b+this.max_label_height/2);for(const e of d.renderers){this.plot_view.renderer_views.get(e).draw_legend(t,c,u,b,f,g,r,d.index)}if(!m){let s,n;[s,n]=o?[e.width-2*l,this.max_label_height]:[this.text_widths.get(r)+i+h,this.max_label_height],t.beginPath(),t.rect(c,b,s,n),this.visuals.inactive_fill.set_value(t),t.fill()}}}}_draw_title(t,e){this.visuals.title_text.doit&&(t.save(),t.translate(e.x0,e.y0+this.title_height),this.visuals.title_text.set_value(t),t.fillText(this.model.title,this.legend_padding,this.legend_padding-this.model.title_standoff),t.restore())}_get_size(){const{width:t,height:e}=this.compute_legend_bbox();return{width:t+2*this.model.margin,height:e+2*this.model.margin}}}i.LegendView=g,g.__name__="LegendView";class m extends l.Annotation{constructor(t){super(t)}initialize(){super.initialize(),this.item_change=new a.Signal0(this,"item_change")}static init_Legend(){this.prototype.default_view=g,this.mixins([["label_",n.Text],["title_",n.Text],["inactive_",n.Fill],["border_",n.Line],["background_",n.Fill]]),this.define({orientation:[h.Orientation,"vertical"],location:[h.Any,"top_right"],title:[h.String],title_standoff:[h.Number,5],label_standoff:[h.Number,5],glyph_height:[h.Number,20],glyph_width:[h.Number,20],label_height:[h.Number,20],label_width:[h.Number,20],margin:[h.Number,10],padding:[h.Number,10],spacing:[h.Number,3],items:[h.Array,[]],click_policy:[h.Any,"none"]}),this.override({border_line_color:"#e5e5e5",border_line_alpha:.5,border_line_width:1,background_fill_color:"#ffffff",background_fill_alpha:.95,inactive_fill_color:"white",inactive_fill_alpha:.7,label_text_font_size:"13px",label_text_baseline:"middle",title_text_font_size:"13px",title_text_font_style:"italic"})}get_legend_names(){const t=[];for(const e of this.items){const i=e.get_labels_list_from_label_prop();t.push(...i)}return t}}i.Legend=m,m.__name__="Legend",m.init_Legend()},
function _(e,r,n){Object.defineProperty(n,"__esModule",{value:!0});const t=e(1),l=e(81),i=e(86),s=e(165),o=t.__importStar(e(18)),_=e(19),a=e(9);class u extends l.Model{constructor(e){super(e)}static init_LegendItem(){this.define({label:[o.StringSpec,null],renderers:[o.Array,[]],index:[o.Number,null]})}_check_data_sources_on_renderers(){if(null!=this.get_field_from_label_prop()){if(this.renderers.length<1)return!1;const e=this.renderers[0].data_source;if(null!=e)for(const r of this.renderers)if(r.data_source!=e)return!1}return!0}_check_field_label_on_data_source(){const e=this.get_field_from_label_prop();if(null!=e){if(this.renderers.length<1)return!1;const r=this.renderers[0].data_source;if(null!=r&&!a.includes(r.columns(),e))return!1}return!0}initialize(){super.initialize(),this.legend=null,this.connect(this.change,()=>{var e;return null===(e=this.legend)||void 0===e?void 0:e.item_change.emit()});this._check_data_sources_on_renderers()||_.logger.error("Non matching data sources on legend item renderers");this._check_field_label_on_data_source()||_.logger.error("Bad column name on label: "+this.label)}get_field_from_label_prop(){const{label:e}=this;return s.isField(e)?e.field:null}get_labels_list_from_label_prop(){if(s.isValue(this.label)){const{value:e}=this.label;return null!=e?[e]:[]}const e=this.get_field_from_label_prop();if(null!=e){let r;if(!this.renderers[0]||null==this.renderers[0].data_source)return["No source found"];if(r=this.renderers[0].data_source,r instanceof i.ColumnarDataSource){const n=r.get_column(e);return null!=n?a.uniq(Array.from(n)):["Invalid field"]}}return[]}}n.LegendItem=u,u.__name__="LegendItem",u.init_LegendItem()},
function _(e,i,n){Object.defineProperty(n,"__esModule",{value:!0});const t=e(8);n.isValue=function(e){return t.isPlainObject(e)&&"value"in e},n.isField=function(e){return t.isPlainObject(e)&&"field"in e}},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const n=t(1),s=t(36),o=n.__importStar(t(28)),l=t(15),a=n.__importStar(t(18));class r extends s.AnnotationView{connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.plot_view.request_render()),this.connect(this.model.data_update,()=>this.plot_view.request_render())}_render(){const{xs:t,ys:e}=this.model;if(t.length!=e.length)return;if(t.length<3||e.length<3)return;const{frame:i}=this.plot_view,{ctx:n}=this.layer;for(let s=0,o=t.length;s<o;s++){let o,l;if("screen"!=this.model.xs_units)throw new Error("not implemented");if(o=this.model.screen?t[s]:i.xview.compute(t[s]),"screen"!=this.model.ys_units)throw new Error("not implemented");l=this.model.screen?e[s]:i.yview.compute(e[s]),0==s?(n.beginPath(),n.moveTo(o,l)):n.lineTo(o,l)}n.closePath(),this.visuals.line.doit&&(this.visuals.line.set_value(n),n.stroke()),this.visuals.fill.doit&&(this.visuals.fill.set_value(n),n.fill())}}i.PolyAnnotationView=r,r.__name__="PolyAnnotationView";class _ extends s.Annotation{constructor(t){super(t)}static init_PolyAnnotation(){this.prototype.default_view=r,this.mixins([o.Line,o.Fill]),this.define({xs:[a.Array,[]],xs_units:[a.SpatialUnits,"data"],ys:[a.Array,[]],ys_units:[a.SpatialUnits,"data"]}),this.internal({screen:[a.Boolean,!1]}),this.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})}initialize(){super.initialize(),this.data_update=new l.Signal0(this,"data_update")}update({xs:t,ys:e}){this.setv({xs:t,ys:e,screen:!0},{silent:!0}),this.data_update.emit()}}i.PolyAnnotation=_,_.__name__="PolyAnnotation",_.init_PolyAnnotation()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const n=e(1),o=e(36),s=n.__importStar(e(28)),l=n.__importStar(e(18));class r extends o.AnnotationView{initialize(){super.initialize()}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.plot_view.request_render())}_render(){const e=this.model.gradient,t=this.model.y_intercept;if(null==e||null==t)return;const{frame:i}=this.plot_view,n=this.coordinates.x_scale,o=this.coordinates.y_scale,s=i.bbox.top,l=s+i.bbox.height,r=(o.invert(s)-t)/e,_=(o.invert(l)-t)/e,a=n.compute(r),c=n.compute(_),{ctx:p}=this.layer;p.save(),p.beginPath(),this.visuals.line.set_value(p),p.moveTo(a,s),p.lineTo(c,l),p.stroke(),p.restore()}}i.SlopeView=r,r.__name__="SlopeView";class _ extends o.Annotation{constructor(e){super(e)}static init_Slope(){this.prototype.default_view=r,this.mixins(s.Line),this.define({gradient:[l.Number,null],y_intercept:[l.Number,null]}),this.override({line_color:"black"})}}i.Slope=_,_.__name__="Slope",_.init_Slope()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const n=e(1),o=e(36),s=n.__importStar(e(28)),a=n.__importStar(e(18));class l extends o.AnnotationView{connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.plot_view.request_paint(this))}_render(){const{location:e}=this.model;if(null==e)return;const{frame:t}=this.plot_view,i=this.coordinates.x_scale,n=this.coordinates.y_scale,o=(t,i)=>"data"==this.model.location_units?t.compute(e):this.model.for_hover?e:i.compute(e);let s,a,l,r;"width"==this.model.dimension?(l=o(n,t.yview),a=t.bbox.left,r=t.bbox.width,s=this.model.properties.line_width.value()):(l=t.bbox.top,a=o(i,t.xview),r=this.model.properties.line_width.value(),s=t.bbox.height);const{ctx:_}=this.layer;_.save(),_.beginPath(),this.visuals.line.set_value(_),_.moveTo(a,l),"width"==this.model.dimension?_.lineTo(a+r,l):_.lineTo(a,l+s),_.stroke(),_.restore()}}i.SpanView=l,l.__name__="SpanView";class r extends o.Annotation{constructor(e){super(e)}static init_Span(){this.prototype.default_view=l,this.mixins(s.Line),this.define({render_mode:[a.RenderMode,"canvas"],location:[a.Number,null],location_units:[a.SpatialUnits,"data"],dimension:[a.Dimension,"width"]}),this.override({line_color:"black"}),this.internal({for_hover:[a.Boolean,!1]})}}i.Span=r,r.__name__="Span",r.init_Span()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const l=t(1),s=t(161),a=t(74),n=l.__importStar(t(28)),o=l.__importStar(t(18));class r extends s.TextAnnotationView{initialize(){super.initialize(),this.visuals.text=new a.Text(this.model)}_get_location(){const t=this.panel,e=this.model.offset;let i,l;const{bbox:s}=t;switch(t.side){case"above":case"below":switch(this.model.vertical_align){case"top":l=s.top+5;break;case"middle":l=s.vcenter;break;case"bottom":l=s.bottom-5}switch(this.model.align){case"left":i=s.left+e;break;case"center":i=s.hcenter;break;case"right":i=s.right-e}break;case"left":switch(this.model.vertical_align){case"top":i=s.left-5;break;case"middle":i=s.hcenter;break;case"bottom":i=s.right+5}switch(this.model.align){case"left":l=s.bottom-e;break;case"center":l=s.vcenter;break;case"right":l=s.top+e}break;case"right":switch(this.model.vertical_align){case"top":i=s.right-5;break;case"middle":i=s.hcenter;break;case"bottom":i=s.left+5}switch(this.model.align){case"left":l=s.top+e;break;case"center":l=s.vcenter;break;case"right":l=s.bottom-e}}return[i,l]}_render(){const{text:t}=this.model;if(null==t||0==t.length)return;this.model.text_baseline=this.model.vertical_align,this.model.text_align=this.model.align;const[e,i]=this._get_location(),l=this.panel.get_label_angle_heuristic("parallel");("canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this))(this.layer.ctx,t,e,i,l)}_get_size(){const{text:t}=this.model;if(null==t||0==t.length)return{width:0,height:0};{this.visuals.text.set_value(this.layer.ctx);const{width:e,ascent:i}=this.layer.ctx.measureText(t);return{width:e,height:i*this.visuals.text.text_line_height.value()+10}}}}i.TitleView=r,r.__name__="TitleView";class c extends s.TextAnnotation{constructor(t){super(t)}static init_Title(){this.prototype.default_view=r,this.mixins([["border_",n.Line],["background_",n.Fill]]),this.define({text:[o.String],text_font:[o.Font,"helvetica"],text_font_size:[o.StringSpec,"13px"],text_font_style:[o.FontStyle,"bold"],text_color:[o.ColorSpec,"#444444"],text_alpha:[o.NumberSpec,1],text_line_height:[o.Number,1],vertical_align:[o.VerticalAlign,"bottom"],align:[o.TextAlign,"left"],offset:[o.Number,0]}),this.override({background_fill_color:null,border_line_color:null}),this.internal({text_align:[o.TextAlign,"left"],text_baseline:[o.TextBaseline,"bottom"]})}}i.Title=c,c.__name__="Title",c.init_Title()},
function _(e,i,t){Object.defineProperty(t,"__esModule",{value:!0});const o=e(1),l=e(36),s=e(115),a=e(72),n=e(79),r=o.__importStar(e(18));class _ extends l.AnnotationView{constructor(){super(...arguments),this.rotate=!0,this._invalidate_toolbar=!0,this._previous_bbox=new n.BBox}initialize(){super.initialize(),this.el=a.div(),this.plot_view.canvas_view.add_event(this.el)}async lazy_initialize(){this._toolbar_view=await s.build_view(this.model.toolbar,{parent:this}),this.plot_view.visibility_callbacks.push(e=>this._toolbar_view.set_visibility(e))}remove(){this._toolbar_view.remove(),a.remove(this.el),super.remove()}render(){this.model.visible||a.undisplay(this.el),super.render()}_render(){const{bbox:e}=this.panel;this._previous_bbox.equals(e)||(a.position(this.el,e),this._previous_bbox=e),this._invalidate_toolbar&&(this.el.style.position="absolute",this.el.style.overflow="hidden",this._toolbar_view.render(),a.empty(this.el),this.el.appendChild(this._toolbar_view.el),this._invalidate_toolbar=!1),a.display(this.el)}_get_size(){const{tools:e,logo:i}=this.model.toolbar;return{width:30*e.length+(null!=i?25:0),height:30}}}t.ToolbarPanelView=_,_.__name__="ToolbarPanelView";class h extends l.Annotation{constructor(e){super(e)}static init_ToolbarPanel(){this.prototype.default_view=_,this.define({toolbar:[r.Instance]})}}t.ToolbarPanel=h,h.__name__="ToolbarPanel",h.init_ToolbarPanel()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const s=t(1),l=t(36),o=t(72),n=s.__importStar(t(18)),a=t(172),h=t(173),r=s.__importDefault(t(174));class c extends l.AnnotationView{initialize(){super.initialize(),this.el=o.div({class:a.bk_tooltip}),o.undisplay(this.el),this.plot_view.canvas_view.add_overlay(this.el)}remove(){o.remove(this.el),super.remove()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.content.change,()=>this.render()),this.connect(this.model.properties.position.change,()=>this._reposition())}styles(){return[...super.styles(),r.default]}render(){this.model.visible||o.undisplay(this.el),super.render()}_render(){const{content:t}=this.model;null!=t?(o.empty(this.el),o.classes(this.el).toggle(a.bk_tooltip_custom,this.model.custom),this.el.appendChild(t),this.model.show_arrow&&this.el.classList.add(a.bk_tooltip_arrow)):o.undisplay(this.el)}_reposition(){const{position:t}=this.model;if(null==t)return void o.undisplay(this.el);const[e,i]=t,s=(()=>{const t=this.parent.layout.bbox.relativize(),{attachment:s}=this.model;switch(s){case"horizontal":return e<t.hcenter?"right":"left";case"vertical":return i<t.vcenter?"below":"above";default:return s}})();let l;this.el.classList.remove(h.bk_right),this.el.classList.remove(h.bk_left),this.el.classList.remove(h.bk_above),this.el.classList.remove(h.bk_below),o.display(this.el);let n=null,a=null;switch(s){case"right":this.el.classList.add(h.bk_left),n=e+(this.el.offsetWidth-this.el.clientWidth)+10,l=i-this.el.offsetHeight/2;break;case"left":this.el.classList.add(h.bk_right),a=this.plot_view.layout.bbox.width-e+10,l=i-this.el.offsetHeight/2;break;case"below":this.el.classList.add(h.bk_above),l=i+(this.el.offsetHeight-this.el.clientHeight)+10,n=Math.round(e-this.el.offsetWidth/2);break;case"above":this.el.classList.add(h.bk_below),l=i-this.el.offsetHeight-10,n=Math.round(e-this.el.offsetWidth/2)}this.el.style.top=l+"px",this.el.style.left=null!=n?n+"px":"auto",this.el.style.right=null!=a?a+"px":"auto"}}i.TooltipView=c,c.__name__="TooltipView";class d extends l.Annotation{constructor(t){super(t)}static init_Tooltip(){this.prototype.default_view=c,this.define({attachment:[n.TooltipAttachment,"horizontal"],inner_only:[n.Boolean,!0],show_arrow:[n.Boolean,!0]}),this.override({level:"overlay"}),this.internal({position:[n.Any,null],content:[n.Any,()=>o.div()],custom:[n.Any]})}clear(){this.position=null}}i.Tooltip=d,d.__name__="Tooltip",d.init_Tooltip()},
function _(o,t,l){Object.defineProperty(l,"__esModule",{value:!0}),l.bk_tooltip="bk-tooltip",l.bk_tooltip_arrow="bk-tooltip-arrow",l.bk_tooltip_custom="bk-tooltip-custom",l.bk_tooltip_row_label="bk-tooltip-row-label",l.bk_tooltip_row_value="bk-tooltip-row-value",l.bk_tooltip_color_block="bk-tooltip-color-block"},
function _(e,b,k){Object.defineProperty(k,"__esModule",{value:!0}),k.bk_active="bk-active",k.bk_inline="bk-inline",k.bk_left="bk-left",k.bk_right="bk-right",k.bk_above="bk-above",k.bk_below="bk-below",k.bk_up="bk-up",k.bk_down="bk-down",k.bk_side=function(e){switch(e){case"above":return k.bk_above;case"below":return k.bk_below;case"left":return k.bk_left;case"right":return k.bk_right}}},
function _(o,n,t){Object.defineProperty(t,"__esModule",{value:!0});t.default='\n.bk-root {\n  /* Same border color used everywhere */\n  /* Gray of icons */\n}\n.bk-root .bk-tooltip {\n  font-weight: 300;\n  font-size: 12px;\n  position: absolute;\n  padding: 5px;\n  border: 1px solid #e5e5e5;\n  color: #2f2f2f;\n  background-color: white;\n  pointer-events: none;\n  opacity: 0.95;\n  z-index: 100;\n}\n.bk-root .bk-tooltip > div:not(:first-child) {\n  /* gives space when multiple elements are being hovered over */\n  margin-top: 5px;\n  border-top: #e5e5e5 1px dashed;\n}\n.bk-root .bk-tooltip.bk-left.bk-tooltip-arrow::before {\n  position: absolute;\n  margin: -7px 0 0 0;\n  top: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 7px 0 7px 0;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  left: -10px;\n  border-right-width: 10px;\n  border-right-color: #909599;\n}\n.bk-root .bk-tooltip.bk-left::before {\n  left: -10px;\n  border-right-width: 10px;\n  border-right-color: #909599;\n}\n.bk-root .bk-tooltip.bk-right.bk-tooltip-arrow::after {\n  position: absolute;\n  margin: -7px 0 0 0;\n  top: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 7px 0 7px 0;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  right: -10px;\n  border-left-width: 10px;\n  border-left-color: #909599;\n}\n.bk-root .bk-tooltip.bk-right::after {\n  right: -10px;\n  border-left-width: 10px;\n  border-left-color: #909599;\n}\n.bk-root .bk-tooltip.bk-above::before {\n  position: absolute;\n  margin: 0 0 0 -7px;\n  left: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 0 7px 0 7px;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  top: -10px;\n  border-bottom-width: 10px;\n  border-bottom-color: #909599;\n}\n.bk-root .bk-tooltip.bk-below::after {\n  position: absolute;\n  margin: 0 0 0 -7px;\n  left: 50%;\n  width: 0;\n  height: 0;\n  border-style: solid;\n  border-width: 0 7px 0 7px;\n  border-color: transparent;\n  content: " ";\n  display: block;\n  bottom: -10px;\n  border-top-width: 10px;\n  border-top-color: #909599;\n}\n.bk-root .bk-tooltip-row-label {\n  text-align: right;\n  color: #26aae1;\n  /* blue from toolbar highlighting */\n}\n.bk-root .bk-tooltip-row-value {\n  color: default;\n  /* seems to be necessary for notebook */\n}\n.bk-root .bk-tooltip-color-block {\n  width: 12px;\n  height: 12px;\n  margin-left: 5px;\n  margin-right: 5px;\n  outline: #dddddd solid 1px;\n  display: inline-block;\n}\n'},
function _(e,s,t){Object.defineProperty(t,"__esModule",{value:!0});const i=e(1),r=e(123),o=e(84),h=e(28),n=i.__importStar(e(18));class l extends r.UpperLowerView{connect_signals(){super.connect_signals(),this.connect(this.model.source.streaming,()=>this.set_data(this.model.source)),this.connect(this.model.source.patching,()=>this.set_data(this.model.source)),this.connect(this.model.source.change,()=>this.set_data(this.model.source))}_render(){this._map_data();const{ctx:e}=this.layer;if(this.visuals.line.doit)for(let s=0,t=this._lower_sx.length;s<t;s++)this.visuals.line.set_vectorize(e,s),e.beginPath(),e.moveTo(this._lower_sx[s],this._lower_sy[s]),e.lineTo(this._upper_sx[s],this._upper_sy[s]),e.stroke();const s="height"==this.model.dimension?0:Math.PI/2;if(null!=this.model.lower_head)for(let t=0,i=this._lower_sx.length;t<i;t++)e.save(),e.translate(this._lower_sx[t],this._lower_sy[t]),e.rotate(s+Math.PI),this.model.lower_head.render(e,t),e.restore();if(null!=this.model.upper_head)for(let t=0,i=this._upper_sx.length;t<i;t++)e.save(),e.translate(this._upper_sx[t],this._upper_sy[t]),e.rotate(s),this.model.upper_head.render(e,t),e.restore()}}t.WhiskerView=l,l.__name__="WhiskerView";class _ extends r.UpperLower{constructor(e){super(e)}static init_Whisker(){this.prototype.default_view=l,this.mixins(h.LineVector),this.define({lower_head:[n.Instance,()=>new o.TeeHead({level:"underlay",size:10})],upper_head:[n.Instance,()=>new o.TeeHead({level:"underlay",size:10})]}),this.override({level:"underlay"})}}t.Whisker=_,_.__name__="Whisker",_.init_Whisker()},
function _(i,a,e){Object.defineProperty(e,"__esModule",{value:!0});var r=i(177);e.Axis=r.Axis;var s=i(179);e.CategoricalAxis=s.CategoricalAxis;var x=i(182);e.ContinuousAxis=x.ContinuousAxis;var A=i(183);e.DatetimeAxis=A.DatetimeAxis;var o=i(184);e.LinearAxis=o.LinearAxis;var t=i(197);e.LogAxis=t.LogAxis;var n=i(200);e.MercatorAxis=n.MercatorAxis},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const s=t(1),a=t(178),l=s.__importStar(t(28)),n=s.__importStar(t(18)),o=t(9),r=t(8),_=t(98),{abs:h,min:c,max:d}=Math;class m extends a.GuideRendererView{constructor(){super(...arguments),this.rotate=!0}get panel(){return this.layout}get is_renderable(){const[t,e]=this.ranges;return t.is_valid&&e.is_valid}_render(){var t;if(!this.is_renderable)return;const e={tick:this._tick_extent(),tick_label:this._tick_label_extents(),axis_label:this._axis_label_extent()},{tick_coords:i}=this,s=this.layer.ctx;s.save(),this._draw_rule(s,e),this._draw_major_ticks(s,e,i),this._draw_minor_ticks(s,e,i),this._draw_major_labels(s,e,i),this._draw_axis_label(s,e,i),null===(t=this._paint)||void 0===t||t.call(this,s,e,i),s.restore()}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.plot_view.request_layout())}get_size(){if(this.model.visible&&null==this.model.fixed_location&&this.is_renderable){const t=this._get_size();return{width:0,height:Math.round(t)}}return{width:0,height:0}}_get_size(){return this._tick_extent()+this._tick_label_extent()+this._axis_label_extent()}get needs_clip(){return null!=this.model.fixed_location}_draw_rule(t,e){if(!this.visuals.axis_line.doit)return;const[i,s]=this.rule_coords,[a,l]=this.coordinates.map_to_screen(i,s),[n,o]=this.normals,[r,_]=this.offsets;this.visuals.axis_line.set_value(t),t.beginPath(),t.moveTo(Math.round(a[0]+n*r),Math.round(l[0]+o*_));for(let e=1;e<a.length;e++){const i=Math.round(a[e]+n*r),s=Math.round(l[e]+o*_);t.lineTo(i,s)}t.stroke()}_draw_major_ticks(t,e,i){const s=this.model.major_tick_in,a=this.model.major_tick_out,l=this.visuals.major_tick_line;this._draw_ticks(t,i.major,s,a,l)}_draw_minor_ticks(t,e,i){const s=this.model.minor_tick_in,a=this.model.minor_tick_out,l=this.visuals.minor_tick_line;this._draw_ticks(t,i.minor,s,a,l)}_draw_major_labels(t,e,i){const s=i.major,a=this.compute_labels(s[this.dimension]),l=this.model.major_label_orientation,n=e.tick+this.model.major_label_standoff,o=this.visuals.major_label_text;this._draw_oriented_labels(t,a,s,l,this.panel.side,n,o)}_draw_axis_label(t,e,i){if(null==this.model.axis_label||0==this.model.axis_label.length||null!=this.model.fixed_location)return;let s,a;const{bbox:l}=this.panel;switch(this.panel.side){case"above":s=l.hcenter,a=l.bottom;break;case"below":s=l.hcenter,a=l.top;break;case"left":s=l.right,a=l.vcenter;break;case"right":s=l.left,a=l.vcenter;break;default:throw new Error("unknown side: "+this.panel.side)}const n=[[s],[a]],r=e.tick+o.sum(e.tick_label)+this.model.axis_label_standoff,_=this.visuals.axis_label_text;this._draw_oriented_labels(t,[this.model.axis_label],n,"parallel",this.panel.side,r,_,"screen")}_draw_ticks(t,e,i,s,a){if(!a.doit)return;const[l,n]=e,[o,r]=this.coordinates.map_to_screen(l,n),[_,h]=this.normals,[c,d]=this.offsets,[m,b]=[_*(c-i),h*(d-i)],[u,x]=[_*(c+s),h*(d+s)];a.set_value(t),t.beginPath();for(let e=0;e<o.length;e++){const i=Math.round(o[e]+u),s=Math.round(r[e]+x),a=Math.round(o[e]+m),l=Math.round(r[e]+b);t.moveTo(i,s),t.lineTo(a,l)}t.stroke()}_draw_oriented_labels(t,e,i,s,a,l,n,o="data"){if(!n.doit||0==e.length)return;let _,h,c,d;if("screen"==o)[_,h]=i,[c,d]=[0,0];else{const[t,e]=i;[_,h]=this.coordinates.map_to_screen(t,e),[c,d]=this.offsets}const[m,b]=this.normals,u=m*(c+l),x=b*(d+l);let f;n.set_value(t),this.panel.apply_label_text_heuristics(t,s),f=r.isString(s)?this.panel.get_label_angle_heuristic(s):-s;for(let i=0;i<_.length;i++){const s=Math.round(_[i]+u),a=Math.round(h[i]+x);t.translate(s,a),t.rotate(f),t.fillText(e[i],0,0),t.rotate(-f),t.translate(-s,-a)}}_axis_label_extent(){if(null==this.model.axis_label||""==this.model.axis_label)return 0;const t=this.model.axis_label_standoff,e=this.visuals.axis_label_text;return this._oriented_labels_extent([this.model.axis_label],"parallel",this.panel.side,t,e)}_tick_extent(){return this.model.major_tick_out}_tick_label_extent(){return o.sum(this._tick_label_extents())}_tick_label_extents(){const t=this.tick_coords.major,e=this.compute_labels(t[this.dimension]),i=this.model.major_label_orientation,s=this.model.major_label_standoff,a=this.visuals.major_label_text;return[this._oriented_labels_extent(e,i,this.panel.side,s,a)]}_oriented_labels_extent(t,e,i,s,a){if(0==t.length)return 0;const l=this.layer.ctx;let n,o;a.set_value(l),r.isString(e)?(n=1,o=this.panel.get_label_angle_heuristic(e)):(n=2,o=-e),o=Math.abs(o);const _=Math.cos(o),h=Math.sin(o);let c=0;for(let e=0;e<t.length;e++){const s=1.1*l.measureText(t[e]).width,a=.9*l.measureText(t[e]).ascent;let o;o="above"==i||"below"==i?s*h+a/n*_:s*_+a/n*h,o>c&&(c=o)}return c>0&&(c+=s),c}get normals(){return this.panel.normals}get dimension(){return this.panel.dimension}compute_labels(t){const e=this.model.formatter.doFormat(t,this);for(let i=0;i<t.length;i++)t[i]in this.model.major_label_overrides&&(e[i]=this.model.major_label_overrides[t[i]]);return e}get offsets(){if(null!=this.model.fixed_location)return[0,0];const{frame:t}=this.plot_view;let[e,i]=[0,0];switch(this.panel.side){case"below":i=h(this.panel.bbox.top-t.bbox.bottom);break;case"above":i=h(this.panel.bbox.bottom-t.bbox.top);break;case"right":e=h(this.panel.bbox.left-t.bbox.right);break;case"left":e=h(this.panel.bbox.right-t.bbox.left)}return[e,i]}get ranges(){const t=this.dimension,e=(t+1)%2,{ranges:i}=this.coordinates;return[i[t],i[e]]}get computed_bounds(){const[t]=this.ranges,e=this.model.bounds,i=[t.min,t.max];if("auto"==e)return[t.min,t.max];{let t,s;const[a,l]=e,[n,o]=i;return h(a-l)>h(n-o)?(t=d(c(a,l),n),s=c(d(a,l),o)):(t=c(a,l),s=d(a,l)),[t,s]}}get rule_coords(){const t=this.dimension,e=(t+1)%2,[i]=this.ranges,[s,a]=this.computed_bounds,l=[new Array(2),new Array(2)];return l[t][0]=Math.max(s,i.min),l[t][1]=Math.min(a,i.max),l[t][0]>l[t][1]&&(l[t][0]=l[t][1]=NaN),l[e][0]=this.loc,l[e][1]=this.loc,l}get tick_coords(){const t=this.dimension,e=(t+1)%2,[i]=this.ranges,[s,a]=this.computed_bounds,l=this.model.ticker.get_ticks(s,a,i,this.loc,{}),n=l.major,o=l.minor,r=[[],[]],_=[[],[]],[h,c]=[i.min,i.max];for(let i=0;i<n.length;i++)n[i]<h||n[i]>c||(r[t].push(n[i]),r[e].push(this.loc));for(let i=0;i<o.length;i++)o[i]<h||o[i]>c||(_[t].push(o[i]),_[e].push(this.loc));return{major:r,minor:_}}get loc(){const{fixed_location:t}=this.model;if(null!=t){if(r.isNumber(t))return t;const[,e]=this.ranges;if(e instanceof _.FactorRange)return e.synthetic(t);throw new Error("unexpected")}const[,e]=this.ranges;switch(this.panel.side){case"left":case"below":return e.start;case"right":case"above":return e.end}}serializable_state(){return Object.assign(Object.assign({},super.serializable_state()),{bbox:this.layout.bbox.box})}}i.AxisView=m,m.__name__="AxisView";class b extends a.GuideRenderer{constructor(t){super(t)}static init_Axis(){this.prototype.default_view=m,this.mixins([["axis_",l.Line],["major_tick_",l.Line],["minor_tick_",l.Line],["major_label_",l.Text],["axis_label_",l.Text]]),this.define({bounds:[n.Any,"auto"],ticker:[n.Instance],formatter:[n.Instance],axis_label:[n.String,""],axis_label_standoff:[n.Int,5],major_label_standoff:[n.Int,5],major_label_orientation:[n.Any,"horizontal"],major_label_overrides:[n.Any,{}],major_tick_in:[n.Number,2],major_tick_out:[n.Number,6],minor_tick_in:[n.Number,0],minor_tick_out:[n.Number,4],fixed_location:[n.Any,null]}),this.override({axis_line_color:"black",major_tick_line_color:"black",minor_tick_line_color:"black",major_label_text_font_size:"11px",major_label_text_align:"center",major_label_text_baseline:"alphabetic",axis_label_text_font_size:"13px",axis_label_text_font_style:"italic"})}}i.Axis=b,b.__name__="Axis",b.init_Axis()},
function _(e,r,d){Object.defineProperty(d,"__esModule",{value:!0});const i=e(70);class n extends i.RendererView{}d.GuideRendererView=n,n.__name__="GuideRendererView";class t extends i.Renderer{constructor(e){super(e)}static init_GuideRenderer(){this.override({level:"guide"})}}d.GuideRenderer=t,t.__name__="GuideRenderer",t.init_GuideRenderer()},
function _(t,s,o){Object.defineProperty(o,"__esModule",{value:!0});const e=t(1),i=t(177),r=t(180),a=t(181),l=e.__importStar(t(28)),_=e.__importStar(t(18));class n extends i.AxisView{_paint(t,s,o){this._draw_group_separators(t,s,o)}_draw_group_separators(t,s,o){const[e]=this.ranges,[i,r]=this.computed_bounds;if(!e.tops||e.tops.length<2||!this.visuals.separator_line.doit)return;const a=this.dimension,l=(a+1)%2,_=[[],[]];let n=0;for(let t=0;t<e.tops.length-1;t++){let s,o;for(let i=n;i<e.factors.length;i++)if(e.factors[i][0]==e.tops[t+1]){[s,o]=[e.factors[i-1],e.factors[i]],n=i;break}const h=(e.synthetic(s)+e.synthetic(o))/2;h>i&&h<r&&(_[a].push(h),_[l].push(this.loc))}const h=this._tick_label_extent();this._draw_ticks(t,_,-3,h-6,this.visuals.separator_line)}_draw_major_labels(t,s,o){const e=this._get_factor_info();let i=s.tick+this.model.major_label_standoff;for(let o=0;o<e.length;o++){const[r,a,l,_]=e[o];this._draw_oriented_labels(t,r,a,l,this.panel.side,i,_),i+=s.tick_label[o]}}_tick_label_extents(){const t=this._get_factor_info(),s=[];for(const[o,,e,i]of t){const t=this._oriented_labels_extent(o,e,this.panel.side,this.model.major_label_standoff,i);s.push(t)}return s}_get_factor_info(){const[t]=this.ranges,[s,o]=this.computed_bounds,e=this.loc,i=this.model.ticker.get_ticks(s,o,t,e,{}),r=this.tick_coords,a=[];if(1==t.levels){const t=i.major,s=this.model.formatter.doFormat(t,this);a.push([s,r.major,this.model.major_label_orientation,this.visuals.major_label_text])}else if(2==t.levels){const t=i.major.map(t=>t[1]),s=this.model.formatter.doFormat(t,this);a.push([s,r.major,this.model.major_label_orientation,this.visuals.major_label_text]),a.push([i.tops,r.tops,this.model.group_label_orientation,this.visuals.group_text])}else if(3==t.levels){const t=i.major.map(t=>t[2]),s=this.model.formatter.doFormat(t,this),o=i.mids.map(t=>t[1]);a.push([s,r.major,this.model.major_label_orientation,this.visuals.major_label_text]),a.push([o,r.mids,this.model.subgroup_label_orientation,this.visuals.subgroup_text]),a.push([i.tops,r.tops,this.model.group_label_orientation,this.visuals.group_text])}return a}get tick_coords(){const t=this.dimension,s=(t+1)%2,[o]=this.ranges,[e,i]=this.computed_bounds,r=this.model.ticker.get_ticks(e,i,o,this.loc,{}),a={major:[[],[]],mids:[[],[]],tops:[[],[]],minor:[[],[]]};return a.major[t]=r.major,a.major[s]=r.major.map(t=>this.loc),3==o.levels&&(a.mids[t]=r.mids,a.mids[s]=r.mids.map(t=>this.loc)),o.levels>1&&(a.tops[t]=r.tops,a.tops[s]=r.tops.map(t=>this.loc)),a}}o.CategoricalAxisView=n,n.__name__="CategoricalAxisView";class h extends i.Axis{constructor(t){super(t)}static init_CategoricalAxis(){this.prototype.default_view=n,this.mixins([["separator_",l.Line],["group_",l.Text],["subgroup_",l.Text]]),this.define({group_label_orientation:[_.Any,"parallel"],subgroup_label_orientation:[_.Any,"parallel"]}),this.override({ticker:()=>new r.CategoricalTicker,formatter:()=>new a.CategoricalTickFormatter,separator_line_color:"lightgrey",separator_line_width:2,group_text_font_style:"bold",group_text_font_size:"11px",group_text_color:"grey",subgroup_text_font_style:"bold",subgroup_text_font_size:"11px"})}}o.CategoricalAxis=h,h.__name__="CategoricalAxis",h.init_CategoricalAxis()},
function _(t,c,e){Object.defineProperty(e,"__esModule",{value:!0});const o=t(129);class s extends o.Ticker{constructor(t){super(t)}get_ticks(t,c,e,o,s){return{major:this._collect(e.factors,e,t,c),minor:[],tops:this._collect(e.tops||[],e,t,c),mids:this._collect(e.mids||[],e,t,c)}}_collect(t,c,e,o){const s=[];for(const r of t){const t=c.synthetic(r);t>e&&t<o&&s.push(r)}return s}}e.CategoricalTicker=s,s.__name__="CategoricalTicker"},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const o=e(131),c=e(9);class a extends o.TickFormatter{constructor(e){super(e)}doFormat(e,t){return c.copy(e)}}r.CategoricalTickFormatter=a,a.__name__="CategoricalTickFormatter"},
function _(s,e,n){Object.defineProperty(n,"__esModule",{value:!0});const o=s(177);class t extends o.Axis{constructor(s){super(s)}}n.ContinuousAxis=t,t.__name__="ContinuousAxis"},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(184),a=e(185),r=e(190);class n extends s.LinearAxisView{}i.DatetimeAxisView=n,n.__name__="DatetimeAxisView";class _ extends s.LinearAxis{constructor(e){super(e)}static init_DatetimeAxis(){this.prototype.default_view=n,this.override({ticker:()=>new r.DatetimeTicker,formatter:()=>new a.DatetimeTickFormatter})}}i.DatetimeAxis=_,_.__name__="DatetimeAxis",_.init_DatetimeAxis()},
function _(e,i,s){Object.defineProperty(s,"__esModule",{value:!0});const t=e(177),n=e(182),r=e(130),a=e(126);class _ extends t.AxisView{}s.LinearAxisView=_,_.__name__="LinearAxisView";class c extends n.ContinuousAxis{constructor(e){super(e)}static init_LinearAxis(){this.prototype.default_view=_,this.override({ticker:()=>new a.BasicTicker,formatter:()=>new r.BasicTickFormatter})}}s.LinearAxis=c,c.__name__="LinearAxis",c.init_LinearAxis()},
function _(t,s,e){Object.defineProperty(e,"__esModule",{value:!0});const r=t(1),i=r.__importDefault(t(186)),n=t(131),o=t(19),a=r.__importStar(t(18)),c=t(187),m=t(9),u=t(8);function h(t){return i.default(t,"%Y %m %d %H %M %S").split(/\s+/).map(t=>parseInt(t,10))}function d(t,s){if(u.isFunction(s))return s(t);{const e=c.sprintf("$1%06d",function(t){return Math.round(t/1e3%1*1e6)}(t));return-1==(s=s.replace(/((^|[^%])(%%)*)%f/,e)).indexOf("%")?s:i.default(t,s)}}const l=["microseconds","milliseconds","seconds","minsec","minutes","hourmin","hours","days","months","years"];class _ extends n.TickFormatter{constructor(t){super(t),this.strip_leading_zeros=!0}static init_DatetimeTickFormatter(){this.define({microseconds:[a.Array,["%fus"]],milliseconds:[a.Array,["%3Nms","%S.%3Ns"]],seconds:[a.Array,["%Ss"]],minsec:[a.Array,[":%M:%S"]],minutes:[a.Array,[":%M","%Mm"]],hourmin:[a.Array,["%H:%M"]],hours:[a.Array,["%Hh","%H:%M"]],days:[a.Array,["%m/%d","%a%d"]],months:[a.Array,["%m/%Y","%b %Y"]],years:[a.Array,["%Y"]]})}initialize(){super.initialize(),this._update_width_formats()}_update_width_formats(){const t=+i.default(new Date),s=function(s){const e=s.map(s=>d(t,s).length),r=m.sort_by(m.zip(e,s),([t])=>t);return m.unzip(r)};this._width_formats={microseconds:s(this.microseconds),milliseconds:s(this.milliseconds),seconds:s(this.seconds),minsec:s(this.minsec),minutes:s(this.minutes),hourmin:s(this.hourmin),hours:s(this.hours),days:s(this.days),months:s(this.months),years:s(this.years)}}_get_resolution_str(t,s){const e=1.1*t;switch(!1){case!(e<.001):return"microseconds";case!(e<1):return"milliseconds";case!(e<60):return s>=60?"minsec":"seconds";case!(e<3600):return s>=3600?"hourmin":"minutes";case!(e<86400):return"hours";case!(e<2678400):return"days";case!(e<31536e3):return"months";default:return"years"}}doFormat(t,s){if(0==t.length)return[];const e=Math.abs(t[t.length-1]-t[0])/1e3,r=e/(t.length-1),i=this._get_resolution_str(r,e),[,[n]]=this._width_formats[i],a=[],c=l.indexOf(i),m={};for(const t of l)m[t]=0;m.seconds=5,m.minsec=4,m.minutes=4,m.hourmin=3,m.hours=3;for(const s of t){let t,e;try{e=h(s),t=d(s,n)}catch(t){o.logger.warn("unable to format tick for timestamp value "+s),o.logger.warn(" - "+t),a.push("ERR");continue}let r=!1,u=c;for(;0==e[m[l[u]]];){let n;if(u+=1,u==l.length)break;if(("minsec"==i||"hourmin"==i)&&!r){if("minsec"==i&&0==e[4]&&0!=e[5]||"hourmin"==i&&0==e[3]&&0!=e[4]){n=this._width_formats[l[c-1]][1][0],t=d(s,n);break}r=!0}n=this._width_formats[l[u]][1][0],t=d(s,n)}if(this.strip_leading_zeros){let s=t.replace(/^0+/g,"");s!=t&&isNaN(parseInt(s))&&(s="0"+s),a.push(s)}else a.push(t)}return a}}e.DatetimeTickFormatter=_,_.__name__="DatetimeTickFormatter",_.init_DatetimeTickFormatter()},
function _(e,t,n){!function(e){"object"==typeof t&&t.exports?t.exports=e():"function"==typeof define?define(e):this.tz=e()}((function(){function e(e,t,n){var r,o=t.day[1];do{r=new Date(Date.UTC(n,t.month,Math.abs(o++)))}while(t.day[0]<7&&r.getUTCDay()!=t.day[0]);return(r={clock:t.clock,sort:r.getTime(),rule:t,save:6e4*t.save,offset:e.offset})[r.clock]=r.sort+6e4*t.time,r.posix?r.wallclock=r[r.clock]+(e.offset+t.saved):r.posix=r[r.clock]-(e.offset+t.saved),r}function t(t,n,r){var o,a,u,i,l,s,c,f=t[t.zone],h=[],T=new Date(r).getUTCFullYear(),g=1;for(o=1,a=f.length;o<a&&!(f[o][n]<=r);o++);if((u=f[o]).rules){for(s=t[u.rules],c=T+1;c>=T-g;--c)for(o=0,a=s.length;o<a;o++)s[o].from<=c&&c<=s[o].to?h.push(e(u,s[o],c)):s[o].to<c&&1==g&&(g=c-s[o].to);for(h.sort((function(e,t){return e.sort-t.sort})),o=0,a=h.length;o<a;o++)r>=h[o][n]&&h[o][h[o].clock]>u[h[o].clock]&&(i=h[o])}return i&&((l=/^(.*)\/(.*)$/.exec(u.format))?i.abbrev=l[i.save?2:1]:i.abbrev=u.format.replace(/%s/,i.rule.letter)),i||u}function n(e,n){return"UTC"==e.zone?n:(e.entry=t(e,"posix",n),n+e.entry.offset+e.entry.save)}function r(e,n){return"UTC"==e.zone?n:(e.entry=r=t(e,"wallclock",n),0<(o=n-r.wallclock)&&o<r.save?null:n-r.offset-r.save);var r,o}function o(e,t,o){var a,i=+(o[1]+1),s=o[2]*i,c=u.indexOf(o[3].toLowerCase());if(c>9)t+=s*l[c-10];else{if(a=new Date(n(e,t)),c<7)for(;s;)a.setUTCDate(a.getUTCDate()+i),a.getUTCDay()==c&&(s-=i);else 7==c?a.setUTCFullYear(a.getUTCFullYear()+s):8==c?a.setUTCMonth(a.getUTCMonth()+s):a.setUTCDate(a.getUTCDate()+s);null==(t=r(e,a.getTime()))&&(t=r(e,a.getTime()+864e5*i)-864e5*i)}return t}var a={clock:function(){return+new Date},zone:"UTC",entry:{abbrev:"UTC",offset:0,save:0},UTC:1,z:function(e,t,n,r){var o,a,u=this.entry.offset+this.entry.save,i=Math.abs(u/1e3),l=[],s=3600;for(o=0;o<3;o++)l.push(("0"+Math.floor(i/s)).slice(-2)),i%=s,s/=60;return"^"!=n||u?("^"==n&&(r=3),3==r?(a=(a=l.join(":")).replace(/:00$/,""),"^"!=n&&(a=a.replace(/:00$/,""))):r?(a=l.slice(0,r+1).join(":"),"^"==n&&(a=a.replace(/:00$/,""))):a=l.slice(0,2).join(""),a=(a=(u<0?"-":"+")+a).replace(/([-+])(0)/,{_:" $1","-":"$1"}[n]||"$1$2")):"Z"},"%":function(e){return"%"},n:function(e){return"\n"},t:function(e){return"\t"},U:function(e){return s(e,0)},W:function(e){return s(e,1)},V:function(e){return c(e)[0]},G:function(e){return c(e)[1]},g:function(e){return c(e)[1]%100},j:function(e){return Math.floor((e.getTime()-Date.UTC(e.getUTCFullYear(),0))/864e5)+1},s:function(e){return Math.floor(e.getTime()/1e3)},C:function(e){return Math.floor(e.getUTCFullYear()/100)},N:function(e){return e.getTime()%1e3*1e6},m:function(e){return e.getUTCMonth()+1},Y:function(e){return e.getUTCFullYear()},y:function(e){return e.getUTCFullYear()%100},H:function(e){return e.getUTCHours()},M:function(e){return e.getUTCMinutes()},S:function(e){return e.getUTCSeconds()},e:function(e){return e.getUTCDate()},d:function(e){return e.getUTCDate()},u:function(e){return e.getUTCDay()||7},w:function(e){return e.getUTCDay()},l:function(e){return e.getUTCHours()%12||12},I:function(e){return e.getUTCHours()%12||12},k:function(e){return e.getUTCHours()},Z:function(e){return this.entry.abbrev},a:function(e){return this[this.locale].day.abbrev[e.getUTCDay()]},A:function(e){return this[this.locale].day.full[e.getUTCDay()]},h:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},b:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},B:function(e){return this[this.locale].month.full[e.getUTCMonth()]},P:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)].toLowerCase()},p:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)]},R:function(e,t){return this.convert([t,"%H:%M"])},T:function(e,t){return this.convert([t,"%H:%M:%S"])},D:function(e,t){return this.convert([t,"%m/%d/%y"])},F:function(e,t){return this.convert([t,"%Y-%m-%d"])},x:function(e,t){return this.convert([t,this[this.locale].date])},r:function(e,t){return this.convert([t,this[this.locale].time12||"%I:%M:%S"])},X:function(e,t){return this.convert([t,this[this.locale].time24])},c:function(e,t){return this.convert([t,this[this.locale].dateTime])},convert:function(e){if(!e.length)return"1.0.23";var t,a,u,l,s,c=Object.create(this),f=[];for(t=0;t<e.length;t++)if(l=e[t],Array.isArray(l))t||isNaN(l[1])?l.splice.apply(e,[t--,1].concat(l)):s=l;else if(isNaN(l)){if("string"==(u=typeof l))~l.indexOf("%")?c.format=l:t||"*"!=l?!t&&(u=/^(\d{4})-(\d{2})-(\d{2})(?:[T\s](\d{2}):(\d{2})(?::(\d{2})(?:\.(\d+))?)?(Z|(([+-])(\d{2}(:\d{2}){0,2})))?)?$/.exec(l))?((s=[]).push.apply(s,u.slice(1,8)),u[9]?(s.push(u[10]+1),s.push.apply(s,u[11].split(/:/))):u[8]&&s.push(1)):/^\w{2,3}_\w{2}$/.test(l)?c.locale=l:(u=i.exec(l))?f.push(u):c.zone=l:s=l;else if("function"==u){if(u=l.call(c))return u}else if(/^\w{2,3}_\w{2}$/.test(l.name))c[l.name]=l;else if(l.zones){for(u in l.zones)c[u]=l.zones[u];for(u in l.rules)c[u]=l.rules[u]}}else t||(s=l);if(c[c.locale]||delete c.locale,c[c.zone]||delete c.zone,null!=s){if("*"==s)s=c.clock();else if(Array.isArray(s)){for(u=[],a=!s[7],t=0;t<11;t++)u[t]=+(s[t]||0);--u[1],s=Date.UTC.apply(Date.UTC,u)+-u[7]*(36e5*u[8]+6e4*u[9]+1e3*u[10])}else s=Math.floor(s);if(!isNaN(s)){if(a&&(s=r(c,s)),null==s)return s;for(t=0,a=f.length;t<a;t++)s=o(c,s,f[t]);return c.format?(u=new Date(n(c,s)),c.format.replace(/%([-0_^]?)(:{0,3})(\d*)(.)/g,(function(e,t,n,r,o){var a,i,l="0";if(a=c[o]){for(e=String(a.call(c,u,s,t,n.length)),"_"==(t||a.style)&&(l=" "),i="-"==t?0:a.pad||0;e.length<i;)e=l+e;for(i="-"==t?0:r||a.pad;e.length<i;)e=l+e;"N"==o&&i<e.length&&(e=e.slice(0,i)),"^"==t&&(e=e.toUpperCase())}return e}))):s}}return function(){return c.convert(arguments)}},locale:"en_US",en_US:{date:"%m/%d/%Y",time24:"%I:%M:%S %p",time12:"%I:%M:%S %p",dateTime:"%a %d %b %Y %I:%M:%S %p %Z",meridiem:["AM","PM"],month:{abbrev:"Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec".split("|"),full:"January|February|March|April|May|June|July|August|September|October|November|December".split("|")},day:{abbrev:"Sun|Mon|Tue|Wed|Thu|Fri|Sat".split("|"),full:"Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday".split("|")}}},u="Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|year|month|day|hour|minute|second|millisecond",i=new RegExp("^\\s*([+-])(\\d+)\\s+("+u+")s?\\s*$","i"),l=[36e5,6e4,1e3,1];function s(e,t){var n,r,o;return r=new Date(Date.UTC(e.getUTCFullYear(),0)),n=Math.floor((e.getTime()-r.getTime())/864e5),r.getUTCDay()==t?o=0:8==(o=7-r.getUTCDay()+t)&&(o=1),n>=o?Math.floor((n-o)/7)+1:0}function c(e){var t,n,r;return n=e.getUTCFullYear(),t=new Date(Date.UTC(n,0)).getUTCDay(),(r=s(e,1)+(t>1&&t<=4?1:0))?53!=r||4==t||3==t&&29==new Date(n,1,29).getDate()?[r,e.getUTCFullYear()]:[1,e.getUTCFullYear()+1]:(n=e.getUTCFullYear()-1,[r=4==(t=new Date(Date.UTC(n,0)).getUTCDay())||3==t&&29==new Date(n,1,29).getDate()?53:52,e.getUTCFullYear()-1])}return u=u.toLowerCase().split("|"),"delmHMSUWVgCIky".replace(/./g,(function(e){a[e].pad=2})),a.N.pad=9,a.j.pad=3,a.k.style="_",a.l.style="_",a.e.style="_",function(){return a.convert(arguments)}}))},
function _(r,e,t){Object.defineProperty(t,"__esModule",{value:!0});const n=r(1),i=n.__importStar(r(188)),u=r(189),a=n.__importDefault(r(186)),f=r(29),o=r(8);function l(r,...e){return u.sprintf(r,...e)}function s(r,e,t){if(o.isNumber(r)){return l((()=>{switch(!1){case Math.floor(r)!=r:return"%d";case!(Math.abs(r)>.1&&Math.abs(r)<1e3):return"%0.3f";default:return"%0.3e"}})(),r)}return""+r}function c(r,e,n){if(null==e)return s;if(null!=n&&r in n){const e=n[r];if(o.isString(e)){if(e in t.DEFAULT_FORMATTERS)return t.DEFAULT_FORMATTERS[e];throw new Error(`Unknown tooltip field formatter type '${e}'`)}return function(r,t,n){return e.format(r,t,n)}}return t.DEFAULT_FORMATTERS.numeral}function m(r,e,t,n){if("$"==r[0]){return function(r,e){if(r in e)return e[r];throw new Error(`Unknown special variable '$${r}'`)}(r.substring(1),n)}return function(r,e,t){const n=e.get_column(r);if(null==n)return null;if(o.isNumber(t))return n[t];const i=n[t.index];if(o.isTypedArray(i)||o.isArray(i)){if(o.isArray(i[0])){return i[t.dim2][t.dim1]}return i[t.flat_index]}return i}(r.substring(1).replace(/[{}]/g,""),e,t)}t.DEFAULT_FORMATTERS={numeral:(r,e,t)=>i.format(r,e),datetime:(r,e,t)=>a.default(r,e),printf:(r,e,t)=>l(e,r)},t.sprintf=l,t.basic_formatter=s,t.get_formatter=c,t.get_value=m,t.replace_placeholders=function(r,e,t,n,i={}){let u,a;if(o.isString(r)?(u=r,a=!1):(u=r.html,a=!0),u=u.replace(/@\$name/g,r=>`@{${i.name}}`),u=u.replace(/((?:\$\w+)|(?:@\w+)|(?:@{(?:[^{}]+)}))(?:{([^{}]+)})?/g,(r,u,o)=>{const l=m(u,e,t,i);if(null==l)return""+f.escape("???");if("safe"==o)return a=!0,""+l;const s=c(u,o,n);return""+f.escape(s(l,o,i))}),a){return[...(new DOMParser).parseFromString(u,"text/html").body.childNodes]}return u}},
function _(e,n,t){
/*!
     * numbro.js
     * version : 1.6.2
     * author : Företagsplatsen AB
     * license : MIT
     * http://www.foretagsplatsen.se
     */
var r,i={},a=i,o="en-US",l=null,u="0,0";void 0!==n&&n.exports;function c(e){this._value=e}function s(e){var n,t="";for(n=0;n<e;n++)t+="0";return t}function f(e,n,t,r){var i,a,o=Math.pow(10,n);return a=e.toFixed(0).search("e")>-1?function(e,n){var t,r,i,a;return t=(a=e.toString()).split("e")[0],i=a.split("e")[1],a=t.split(".")[0]+(r=t.split(".")[1]||"")+s(i-r.length),n>0&&(a+="."+s(n)),a}(e,n):(t(e*o)/o).toFixed(n),r&&(i=new RegExp("0{1,"+r+"}$"),a=a.replace(i,"")),a}function d(e,n,t){return n.indexOf("$")>-1?function(e,n,t){var r,a,l=n,u=l.indexOf("$"),c=l.indexOf("("),s=l.indexOf("+"),f=l.indexOf("-"),d="",p="";-1===l.indexOf("$")?"infix"===i[o].currency.position?(p=i[o].currency.symbol,i[o].currency.spaceSeparated&&(p=" "+p+" ")):i[o].currency.spaceSeparated&&(d=" "):l.indexOf(" $")>-1?(d=" ",l=l.replace(" $","")):l.indexOf("$ ")>-1?(d=" ",l=l.replace("$ ","")):l=l.replace("$","");if(a=h(e,l,t,p),-1===n.indexOf("$"))switch(i[o].currency.position){case"postfix":a.indexOf(")")>-1?((a=a.split("")).splice(-1,0,d+i[o].currency.symbol),a=a.join("")):a=a+d+i[o].currency.symbol;break;case"infix":break;case"prefix":a.indexOf("(")>-1||a.indexOf("-")>-1?(a=a.split(""),r=Math.max(c,f)+1,a.splice(r,0,i[o].currency.symbol+d),a=a.join("")):a=i[o].currency.symbol+d+a;break;default:throw Error('Currency position should be among ["prefix", "infix", "postfix"]')}else u<=1?a.indexOf("(")>-1||a.indexOf("+")>-1||a.indexOf("-")>-1?(a=a.split(""),r=1,(u<c||u<s||u<f)&&(r=0),a.splice(r,0,i[o].currency.symbol+d),a=a.join("")):a=i[o].currency.symbol+d+a:a.indexOf(")")>-1?((a=a.split("")).splice(-1,0,d+i[o].currency.symbol),a=a.join("")):a=a+d+i[o].currency.symbol;return a}(e,n,t):n.indexOf("%")>-1?function(e,n,t){var r,i="";e*=100,n.indexOf(" %")>-1?(i=" ",n=n.replace(" %","")):n=n.replace("%","");(r=h(e,n,t)).indexOf(")")>-1?((r=r.split("")).splice(-1,0,i+"%"),r=r.join("")):r=r+i+"%";return r}(e,n,t):n.indexOf(":")>-1?function(e){var n=Math.floor(e/60/60),t=Math.floor((e-60*n*60)/60),r=Math.round(e-60*n*60-60*t);return n+":"+(t<10?"0"+t:t)+":"+(r<10?"0"+r:r)}(e):h(e,n,t)}function h(e,n,t,r){var a,u,c,s,d,h,p,m,x,g,O,b,w,y,M,v,$,B=!1,E=!1,F=!1,k="",U=!1,N=!1,S=!1,j=!1,D=!1,C="",L="",T=Math.abs(e),K=["B","KiB","MiB","GiB","TiB","PiB","EiB","ZiB","YiB"],G=["B","KB","MB","GB","TB","PB","EB","ZB","YB"],I="",P=!1,R=!1;if(0===e&&null!==l)return l;if(!isFinite(e))return""+e;if(0===n.indexOf("{")){var W=n.indexOf("}");if(-1===W)throw Error('Format should also contain a "}"');b=n.slice(1,W),n=n.slice(W+1)}else b="";if(n.indexOf("}")===n.length-1){var Y=n.indexOf("{");if(-1===Y)throw Error('Format should also contain a "{"');w=n.slice(Y+1,-1),n=n.slice(0,Y+1)}else w="";if(v=null===($=-1===n.indexOf(".")?n.match(/([0-9]+).*/):n.match(/([0-9]+)\..*/))?-1:$[1].length,-1!==n.indexOf("-")&&(P=!0),n.indexOf("(")>-1?(B=!0,n=n.slice(1,-1)):n.indexOf("+")>-1&&(E=!0,n=n.replace(/\+/g,"")),n.indexOf("a")>-1){if(g=n.split(".")[0].match(/[0-9]+/g)||["0"],g=parseInt(g[0],10),U=n.indexOf("aK")>=0,N=n.indexOf("aM")>=0,S=n.indexOf("aB")>=0,j=n.indexOf("aT")>=0,D=U||N||S||j,n.indexOf(" a")>-1?(k=" ",n=n.replace(" a","")):n=n.replace("a",""),p=0===(p=(d=Math.floor(Math.log(T)/Math.LN10)+1)%3)?3:p,g&&0!==T&&(h=Math.floor(Math.log(T)/Math.LN10)+1-g,m=3*~~((Math.min(g,d)-p)/3),T/=Math.pow(10,m),-1===n.indexOf(".")&&g>3))for(n+="[.]",M=(M=0===h?0:3*~~(h/3)-h)<0?M+3:M,a=0;a<M;a++)n+="0";Math.floor(Math.log(Math.abs(e))/Math.LN10)+1!==g&&(T>=Math.pow(10,12)&&!D||j?(k+=i[o].abbreviations.trillion,e/=Math.pow(10,12)):T<Math.pow(10,12)&&T>=Math.pow(10,9)&&!D||S?(k+=i[o].abbreviations.billion,e/=Math.pow(10,9)):T<Math.pow(10,9)&&T>=Math.pow(10,6)&&!D||N?(k+=i[o].abbreviations.million,e/=Math.pow(10,6)):(T<Math.pow(10,6)&&T>=Math.pow(10,3)&&!D||U)&&(k+=i[o].abbreviations.thousand,e/=Math.pow(10,3)))}if(n.indexOf("b")>-1)for(n.indexOf(" b")>-1?(C=" ",n=n.replace(" b","")):n=n.replace("b",""),s=0;s<=K.length;s++)if(u=Math.pow(1024,s),c=Math.pow(1024,s+1),e>=u&&e<c){C+=K[s],u>0&&(e/=u);break}if(n.indexOf("d")>-1)for(n.indexOf(" d")>-1?(C=" ",n=n.replace(" d","")):n=n.replace("d",""),s=0;s<=G.length;s++)if(u=Math.pow(1e3,s),c=Math.pow(1e3,s+1),e>=u&&e<c){C+=G[s],u>0&&(e/=u);break}if(n.indexOf("o")>-1&&(n.indexOf(" o")>-1?(L=" ",n=n.replace(" o","")):n=n.replace("o",""),i[o].ordinal&&(L+=i[o].ordinal(e))),n.indexOf("[.]")>-1&&(F=!0,n=n.replace("[.]",".")),x=e.toString().split(".")[0],O=n.split(".")[1],y=n.indexOf(","),O){if(x=(I=-1!==O.indexOf("*")?f(e,e.toString().split(".")[1].length,t):O.indexOf("[")>-1?f(e,(O=(O=O.replace("]","")).split("["))[0].length+O[1].length,t,O[1].length):f(e,O.length,t)).split(".")[0],I.split(".")[1].length)I=(r?k+r:i[o].delimiters.decimal)+I.split(".")[1];else I="";F&&0===Number(I.slice(1))&&(I="")}else x=f(e,null,t);return x.indexOf("-")>-1&&(x=x.slice(1),R=!0),x.length<v&&(x=new Array(v-x.length+1).join("0")+x),y>-1&&(x=x.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g,"$1"+i[o].delimiters.thousands)),0===n.indexOf(".")&&(x=""),b+(n.indexOf("(")<n.indexOf("-")?(B&&R?"(":"")+(P&&R||!B&&R?"-":""):(P&&R||!B&&R?"-":"")+(B&&R?"(":""))+(!R&&E&&0!==e?"+":"")+x+I+(L||"")+(k&&!r?k:"")+(C||"")+(B&&R?")":"")+w}function p(e,n){i[e]=n}function m(e){o=e;var n=i[e].defaults;n&&n.format&&r.defaultFormat(n.format),n&&n.currencyFormat&&r.defaultCurrencyFormat(n.currencyFormat)}(r=function(e){return r.isNumbro(e)?e=e.value():0===e||void 0===e?e=0:Number(e)||(e=r.fn.unformat(e)),new c(Number(e))}).version="1.6.2",r.isNumbro=function(e){return e instanceof c},r.setLanguage=function(e,n){console.warn("`setLanguage` is deprecated since version 1.6.0. Use `setCulture` instead");var t=e,r=e.split("-")[0],i=null;a[t]||(Object.keys(a).forEach((function(e){i||e.split("-")[0]!==r||(i=e)})),t=i||n||"en-US"),m(t)},r.setCulture=function(e,n){var t=e,r=e.split("-")[1],a=null;i[t]||(r&&Object.keys(i).forEach((function(e){a||e.split("-")[1]!==r||(a=e)})),t=a||n||"en-US"),m(t)},r.language=function(e,n){if(console.warn("`language` is deprecated since version 1.6.0. Use `culture` instead"),!e)return o;if(e&&!n){if(!a[e])throw new Error("Unknown language : "+e);m(e)}return!n&&a[e]||p(e,n),r},r.culture=function(e,n){if(!e)return o;if(e&&!n){if(!i[e])throw new Error("Unknown culture : "+e);m(e)}return!n&&i[e]||p(e,n),r},r.languageData=function(e){if(console.warn("`languageData` is deprecated since version 1.6.0. Use `cultureData` instead"),!e)return a[o];if(!a[e])throw new Error("Unknown language : "+e);return a[e]},r.cultureData=function(e){if(!e)return i[o];if(!i[e])throw new Error("Unknown culture : "+e);return i[e]},r.culture("en-US",{delimiters:{thousands:",",decimal:"."},abbreviations:{thousand:"k",million:"m",billion:"b",trillion:"t"},ordinal:function(e){var n=e%10;return 1==~~(e%100/10)?"th":1===n?"st":2===n?"nd":3===n?"rd":"th"},currency:{symbol:"$",position:"prefix"},defaults:{currencyFormat:",0000 a"},formats:{fourDigits:"0000 a",fullWithTwoDecimals:"$ ,0.00",fullWithTwoDecimalsNoCurrency:",0.00"}}),r.languages=function(){return console.warn("`languages` is deprecated since version 1.6.0. Use `cultures` instead"),a},r.cultures=function(){return i},r.zeroFormat=function(e){l="string"==typeof e?e:null},r.defaultFormat=function(e){u="string"==typeof e?e:"0.0"},r.defaultCurrencyFormat=function(e){"string"==typeof e?e:"0$"},r.validate=function(e,n){var t,i,a,o,l,u,c,s;if("string"!=typeof e&&(e+="",console.warn&&console.warn("Numbro.js: Value is not string. It has been co-erced to: ",e)),(e=e.trim()).match(/^\d+$/))return!0;if(""===e)return!1;try{c=r.cultureData(n)}catch(e){c=r.cultureData(r.culture())}return a=c.currency.symbol,l=c.abbreviations,t=c.delimiters.decimal,i="."===c.delimiters.thousands?"\\.":c.delimiters.thousands,(null===(s=e.match(/^[^\d]+/))||(e=e.substr(1),s[0]===a))&&((null===(s=e.match(/[^\d]+$/))||(e=e.slice(0,-1),s[0]===l.thousand||s[0]===l.million||s[0]===l.billion||s[0]===l.trillion))&&(u=new RegExp(i+"{2}"),!e.match(/[^\d.,]/g)&&(!((o=e.split(t)).length>2)&&(o.length<2?!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u):1===o[0].length?!!o[0].match(/^\d+$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/):!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/)))))},n.exports={format:function(e,n,t,i){return null!=t&&t!==r.culture()&&r.setCulture(t),d(Number(e),null!=n?n:u,null==i?Math.round:i)}}},
function _(e,n,t){!function(){"use strict";var e={not_string:/[^s]/,not_bool:/[^t]/,not_type:/[^T]/,not_primitive:/[^v]/,number:/[diefg]/,numeric_arg:/[bcdiefguxX]/,json:/[j]/,not_json:/[^j]/,text:/^[^\x25]+/,modulo:/^\x25{2}/,placeholder:/^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,key:/^([a-z_][a-z_\d]*)/i,key_access:/^\.([a-z_][a-z_\d]*)/i,index_access:/^\[(\d+)\]/,sign:/^[+-]/};function n(e){return i(a(e),arguments)}function r(e,t){return n.apply(null,[e].concat(t||[]))}function i(t,r){var i,s,a,o,p,c,l,u,f,d=1,g=t.length,y="";for(s=0;s<g;s++)if("string"==typeof t[s])y+=t[s];else if("object"==typeof t[s]){if((o=t[s]).keys)for(i=r[d],a=0;a<o.keys.length;a++){if(null==i)throw new Error(n('[sprintf] Cannot access property "%s" of undefined value "%s"',o.keys[a],o.keys[a-1]));i=i[o.keys[a]]}else i=o.param_no?r[o.param_no]:r[d++];if(e.not_type.test(o.type)&&e.not_primitive.test(o.type)&&i instanceof Function&&(i=i()),e.numeric_arg.test(o.type)&&"number"!=typeof i&&isNaN(i))throw new TypeError(n("[sprintf] expecting number but found %T",i));switch(e.number.test(o.type)&&(u=i>=0),o.type){case"b":i=parseInt(i,10).toString(2);break;case"c":i=String.fromCharCode(parseInt(i,10));break;case"d":case"i":i=parseInt(i,10);break;case"j":i=JSON.stringify(i,null,o.width?parseInt(o.width):0);break;case"e":i=o.precision?parseFloat(i).toExponential(o.precision):parseFloat(i).toExponential();break;case"f":i=o.precision?parseFloat(i).toFixed(o.precision):parseFloat(i);break;case"g":i=o.precision?String(Number(i.toPrecision(o.precision))):parseFloat(i);break;case"o":i=(parseInt(i,10)>>>0).toString(8);break;case"s":i=String(i),i=o.precision?i.substring(0,o.precision):i;break;case"t":i=String(!!i),i=o.precision?i.substring(0,o.precision):i;break;case"T":i=Object.prototype.toString.call(i).slice(8,-1).toLowerCase(),i=o.precision?i.substring(0,o.precision):i;break;case"u":i=parseInt(i,10)>>>0;break;case"v":i=i.valueOf(),i=o.precision?i.substring(0,o.precision):i;break;case"x":i=(parseInt(i,10)>>>0).toString(16);break;case"X":i=(parseInt(i,10)>>>0).toString(16).toUpperCase()}e.json.test(o.type)?y+=i:(!e.number.test(o.type)||u&&!o.sign?f="":(f=u?"+":"-",i=i.toString().replace(e.sign,"")),c=o.pad_char?"0"===o.pad_char?"0":o.pad_char.charAt(1):" ",l=o.width-(f+i).length,p=o.width&&l>0?c.repeat(l):"",y+=o.align?f+i+p:"0"===c?f+p+i:p+f+i)}return y}var s=Object.create(null);function a(n){if(s[n])return s[n];for(var t,r=n,i=[],a=0;r;){if(null!==(t=e.text.exec(r)))i.push(t[0]);else if(null!==(t=e.modulo.exec(r)))i.push("%");else{if(null===(t=e.placeholder.exec(r)))throw new SyntaxError("[sprintf] unexpected placeholder");if(t[2]){a|=1;var o=[],p=t[2],c=[];if(null===(c=e.key.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");for(o.push(c[1]);""!==(p=p.substring(c[0].length));)if(null!==(c=e.key_access.exec(p)))o.push(c[1]);else{if(null===(c=e.index_access.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");o.push(c[1])}t[2]=o}else a|=2;if(3===a)throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");i.push({placeholder:t[0],param_no:t[1],keys:t[2],sign:t[3],pad_char:t[4],align:t[5],width:t[6],precision:t[7],type:t[8]})}r=r.substring(t[0].length)}return s[n]=i}void 0!==t&&(t.sprintf=n,t.vsprintf=r),"undefined"!=typeof window&&(window.sprintf=n,window.vsprintf=r,"function"==typeof define&&define.amd&&define((function(){return{sprintf:n,vsprintf:r}})))}()},
function _(e,i,n){Object.defineProperty(n,"__esModule",{value:!0});const t=e(9),a=e(127),s=e(191),r=e(192),c=e(195),_=e(196),m=e(194);class k extends s.CompositeTicker{constructor(e){super(e)}static init_DatetimeTicker(){this.override({num_minor_ticks:0,tickers:()=>[new a.AdaptiveTicker({mantissas:[1,2,5],base:10,min_interval:0,max_interval:500*m.ONE_MILLI,num_minor_ticks:0}),new a.AdaptiveTicker({mantissas:[1,2,5,10,15,20,30],base:60,min_interval:m.ONE_SECOND,max_interval:30*m.ONE_MINUTE,num_minor_ticks:0}),new a.AdaptiveTicker({mantissas:[1,2,4,6,8,12],base:24,min_interval:m.ONE_HOUR,max_interval:12*m.ONE_HOUR,num_minor_ticks:0}),new r.DaysTicker({days:t.range(1,32)}),new r.DaysTicker({days:t.range(1,31,3)}),new r.DaysTicker({days:[1,8,15,22]}),new r.DaysTicker({days:[1,15]}),new c.MonthsTicker({months:t.range(0,12,1)}),new c.MonthsTicker({months:t.range(0,12,2)}),new c.MonthsTicker({months:t.range(0,12,4)}),new c.MonthsTicker({months:t.range(0,12,6)}),new _.YearsTicker({})]})}}n.DatetimeTicker=k,k.__name__="DatetimeTicker",k.init_DatetimeTicker()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const r=t(1),s=t(128),n=r.__importStar(t(18)),_=t(9);class a extends s.ContinuousTicker{constructor(t){super(t)}static init_CompositeTicker(){this.define({tickers:[n.Array,[]]})}get min_intervals(){return this.tickers.map(t=>t.get_min_interval())}get max_intervals(){return this.tickers.map(t=>t.get_max_interval())}get min_interval(){return this.min_intervals[0]}get max_interval(){return this.max_intervals[0]}get_best_ticker(t,e,i){const r=e-t,s=this.get_ideal_interval(t,e,i),n=[_.sorted_index(this.min_intervals,s)-1,_.sorted_index(this.max_intervals,s)],a=[this.min_intervals[n[0]],this.max_intervals[n[1]]].map(t=>Math.abs(i-r/t));let c;if(_.is_empty(a.filter(t=>!isNaN(t))))c=this.tickers[0];else{const t=n[_.argmin(a)];c=this.tickers[t]}return c}get_interval(t,e,i){return this.get_best_ticker(t,e,i).get_interval(t,e,i)}get_ticks_no_defaults(t,e,i,r){return this.get_best_ticker(t,e,r).get_ticks_no_defaults(t,e,i,r)}}i.CompositeTicker=a,a.__name__="CompositeTicker",a.init_CompositeTicker()},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});const i=t(1),s=t(193),a=t(194),o=i.__importStar(t(18)),r=t(9);class _ extends s.SingleIntervalTicker{constructor(t){super(t)}static init_DaysTicker(){this.define({days:[o.Array,[]]}),this.override({num_minor_ticks:0})}initialize(){super.initialize();const t=this.days;t.length>1?this.interval=(t[1]-t[0])*a.ONE_DAY:this.interval=31*a.ONE_DAY}get_ticks_no_defaults(t,e,n,i){const s=function(t,e){const n=a.last_month_no_later_than(new Date(t)),i=a.last_month_no_later_than(new Date(e));i.setUTCMonth(i.getUTCMonth()+1);const s=[],o=n;for(;s.push(a.copy_date(o)),o.setUTCMonth(o.getUTCMonth()+1),!(o>i););return s}(t,e),o=this.days,_=this.interval;return{major:r.concat(s.map(t=>((t,e)=>{const n=t.getUTCMonth(),i=[];for(const s of o){const o=a.copy_date(t);o.setUTCDate(s);new Date(o.getTime()+e/2).getUTCMonth()==n&&i.push(o)}return i})(t,_))).map(t=>t.getTime()).filter(n=>t<=n&&n<=e),minor:[]}}}n.DaysTicker=_,_.__name__="DaysTicker",_.init_DaysTicker()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const n=e(1),r=e(128),l=n.__importStar(e(18));class a extends r.ContinuousTicker{constructor(e){super(e)}static init_SingleIntervalTicker(){this.define({interval:[l.Number]})}get_interval(e,t,i){return this.interval}get min_interval(){return this.interval}get max_interval(){return this.interval}}i.SingleIntervalTicker=a,a.__name__="SingleIntervalTicker",a.init_SingleIntervalTicker()},
function _(t,e,n){function _(t){return new Date(t.getTime())}function O(t){const e=_(t);return e.setUTCDate(1),e.setUTCHours(0),e.setUTCMinutes(0),e.setUTCSeconds(0),e.setUTCMilliseconds(0),e}Object.defineProperty(n,"__esModule",{value:!0}),n.ONE_MILLI=1,n.ONE_SECOND=1e3,n.ONE_MINUTE=60*n.ONE_SECOND,n.ONE_HOUR=60*n.ONE_MINUTE,n.ONE_DAY=24*n.ONE_HOUR,n.ONE_MONTH=30*n.ONE_DAY,n.ONE_YEAR=365*n.ONE_DAY,n.copy_date=_,n.last_month_no_later_than=O,n.last_year_no_later_than=function(t){const e=O(t);return e.setUTCMonth(0),e}},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});const r=t(1),i=t(193),s=t(194),a=r.__importStar(t(18)),o=t(9);class _ extends i.SingleIntervalTicker{constructor(t){super(t)}static init_MonthsTicker(){this.define({months:[a.Array,[]]})}initialize(){super.initialize();const t=this.months;t.length>1?this.interval=(t[1]-t[0])*s.ONE_MONTH:this.interval=12*s.ONE_MONTH}get_ticks_no_defaults(t,e,n,r){const i=function(t,e){const n=s.last_year_no_later_than(new Date(t)),r=s.last_year_no_later_than(new Date(e));r.setUTCFullYear(r.getUTCFullYear()+1);const i=[],a=n;for(;i.push(s.copy_date(a)),a.setUTCFullYear(a.getUTCFullYear()+1),!(a>r););return i}(t,e),a=this.months;return{major:o.concat(i.map(t=>a.map(e=>{const n=s.copy_date(t);return n.setUTCMonth(e),n}))).map(t=>t.getTime()).filter(n=>t<=n&&n<=e),minor:[]}}}n.MonthsTicker=_,_.__name__="MonthsTicker",_.init_MonthsTicker()},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const i=e(126),r=e(193),n=e(194);class _ extends r.SingleIntervalTicker{constructor(e){super(e)}initialize(){super.initialize(),this.interval=n.ONE_YEAR,this.basic_ticker=new i.BasicTicker({num_minor_ticks:0})}get_ticks_no_defaults(e,t,a,i){const r=n.last_year_no_later_than(new Date(e)).getUTCFullYear(),_=n.last_year_no_later_than(new Date(t)).getUTCFullYear();return{major:this.basic_ticker.get_ticks_no_defaults(r,_,a,i).major.map(e=>Date.UTC(e,0,1)).filter(a=>e<=a&&a<=t),minor:[]}}}a.YearsTicker=_,_.__name__="YearsTicker"},
function _(e,i,t){Object.defineProperty(t,"__esModule",{value:!0});const s=e(177),o=e(182),n=e(198),r=e(199);class _ extends s.AxisView{}t.LogAxisView=_,_.__name__="LogAxisView";class c extends o.ContinuousAxis{constructor(e){super(e)}static init_LogAxis(){this.prototype.default_view=_,this.override({ticker:()=>new r.LogTicker,formatter:()=>new n.LogTickFormatter})}}t.LogAxis=c,c.__name__="LogAxis",c.init_LogAxis()},
function _(t,e,r){Object.defineProperty(r,"__esModule",{value:!0});const i=t(1),o=t(131),a=t(130),n=i.__importStar(t(18));class c extends o.TickFormatter{constructor(t){super(t)}static init_LogTickFormatter(){this.define({ticker:[n.Instance,null]})}initialize(){super.initialize(),this.basic_formatter=new a.BasicTickFormatter}doFormat(t,e){if(0==t.length)return[];const r=null!=this.ticker?this.ticker.base:10;let i=!1;const o=new Array(t.length);for(let e=0,a=t.length;e<a;e++)if(o[e]=`${r}^${Math.round(Math.log(t[e])/Math.log(r))}`,e>0&&o[e]==o[e-1]){i=!0;break}return i?this.basic_formatter.doFormat(t,e):o}}r.LogTickFormatter=c,c.__name__="LogTickFormatter",c.init_LogTickFormatter()},
function _(t,o,e){Object.defineProperty(e,"__esModule",{value:!0});const i=t(127),s=t(9);class n extends i.AdaptiveTicker{constructor(t){super(t)}static init_LogTicker(){this.override({mantissas:[1,5]})}get_ticks_no_defaults(t,o,e,i){const n=this.num_minor_ticks,r=[],c=this.base,a=Math.log(t)/Math.log(c),f=Math.log(o)/Math.log(c),l=f-a;let h;if(isFinite(l))if(l<2){const e=this.get_interval(t,o,i),c=Math.floor(t/e),a=Math.ceil(o/e);if(h=s.range(c,a+1).filter(t=>0!=t).map(t=>t*e).filter(e=>t<=e&&e<=o),n>0&&h.length>0){const t=e/n,o=s.range(0,n).map(o=>o*t);for(const t of o.slice(1))r.push(h[0]-t);for(const t of h)for(const e of o)r.push(t+e)}}else{const t=Math.ceil(.999999*a),o=Math.floor(1.000001*f),e=Math.ceil((o-t)/9);if(h=s.range(t-1,o+1,e).map(t=>c**t),n>0&&h.length>0){const t=c**e/n,o=s.range(1,n+1).map(o=>o*t);for(const t of o)r.push(h[0]/t);r.push(h[0]);for(const t of h)for(const e of o)r.push(t*e)}}else h=[];return{major:h.filter(e=>t<=e&&e<=o),minor:r.filter(e=>t<=e&&e<=o)}}}e.LogTicker=n,n.__name__="LogTicker",n.init_LogTicker()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const i=e(177),s=e(184),o=e(201),a=e(202);class c extends i.AxisView{}r.MercatorAxisView=c,c.__name__="MercatorAxisView";class n extends s.LinearAxis{constructor(e){super(e)}static init_MercatorAxis(){this.prototype.default_view=c,this.override({ticker:()=>new a.MercatorTicker({dimension:"lat"}),formatter:()=>new o.MercatorTickFormatter({dimension:"lat"})})}}r.MercatorAxis=n,n.__name__="MercatorAxis",n.init_MercatorAxis()},
function _(r,t,e){Object.defineProperty(e,"__esModule",{value:!0});const o=r(1),n=r(130),i=o.__importStar(r(18)),c=r(37);class a extends n.BasicTickFormatter{constructor(r){super(r)}static init_MercatorTickFormatter(){this.define({dimension:[i.LatLon]})}doFormat(r,t){if(null==this.dimension)throw new Error("MercatorTickFormatter.dimension not configured");if(0==r.length)return[];const e=r.length,o=new Array(e);if("lon"==this.dimension)for(let n=0;n<e;n++){const[e]=c.wgs84_mercator.invert(r[n],t.loc);o[n]=e}else for(let n=0;n<e;n++){const[,e]=c.wgs84_mercator.invert(t.loc,r[n]);o[n]=e}return super.doFormat(o,t)}}e.MercatorTickFormatter=a,a.__name__="MercatorTickFormatter",a.init_MercatorTickFormatter()},
function _(t,o,r){Object.defineProperty(r,"__esModule",{value:!0});const n=t(1),s=t(126),e=n.__importStar(t(18)),i=t(37);class c extends s.BasicTicker{constructor(t){super(t)}static init_MercatorTicker(){this.define({dimension:[e.LatLon]})}get_ticks_no_defaults(t,o,r,n){if(null==this.dimension)throw new Error(this+".dimension wasn't configured");return[t,o]=i.clip_mercator(t,o,this.dimension),"lon"==this.dimension?this._get_ticks_lon(t,o,r,n):this._get_ticks_lat(t,o,r,n)}_get_ticks_lon(t,o,r,n){const[s]=i.wgs84_mercator.invert(t,r),[e,c]=i.wgs84_mercator.invert(o,r),_=super.get_ticks_no_defaults(s,e,r,n),a=[];for(const t of _.major)if(i.in_bounds(t,"lon")){const[o]=i.wgs84_mercator.compute(t,c);a.push(o)}const m=[];for(const t of _.minor)if(i.in_bounds(t,"lon")){const[o]=i.wgs84_mercator.compute(t,c);m.push(o)}return{major:a,minor:m}}_get_ticks_lat(t,o,r,n){const[,s]=i.wgs84_mercator.invert(r,t),[e,c]=i.wgs84_mercator.invert(r,o),_=super.get_ticks_no_defaults(s,c,r,n),a=[];for(const t of _.major)if(i.in_bounds(t,"lat")){const[,o]=i.wgs84_mercator.compute(e,t);a.push(o)}const m=[];for(const t of _.minor)if(i.in_bounds(t,"lat")){const[,o]=i.wgs84_mercator.compute(e,t);m.push(o)}return{major:a,minor:m}}}r.MercatorTicker=c,c.__name__="MercatorTicker",c.init_MercatorTicker()},
function _(e,n,o){Object.defineProperty(o,"__esModule",{value:!0});var t=e(204);o.CustomJS=t.CustomJS;var u=e(206);o.OpenURL=u.OpenURL},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const n=t(1),u=t(205),c=n.__importStar(t(18)),r=t(13),a=t(29);class i extends u.Callback{constructor(t){super(t)}static init_CustomJS(){this.define({args:[c.Any,{}],code:[c.String,""]})}get names(){return r.keys(this.args)}get values(){return r.values(this.args)}get func(){const t=a.use_strict(this.code);return new Function(...this.names,"cb_obj","cb_data",t)}execute(t,e={}){return this.func.apply(t,this.values.concat(t,e))}}s.CustomJS=i,i.__name__="CustomJS",i.init_CustomJS()},
function _(e,c,l){Object.defineProperty(l,"__esModule",{value:!0});const a=e(81);class n extends a.Model{constructor(e){super(e)}}l.Callback=n,n.__name__="Callback"},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const o=e(1),i=e(205),s=e(187),r=e(8),c=o.__importStar(e(18));class a extends i.Callback{constructor(e){super(e)}static init_OpenURL(){this.define({url:[c.String,"http://"],same_tab:[c.Boolean,!1]})}execute(e,{source:t}){const n=e=>{const n=s.replace_placeholders(this.url,t,e);if(!r.isString(n))throw new Error("HTML output is not supported in this context");this.same_tab?window.location.href=n:window.open(n)},{selected:o}=t;for(const e of o.indices)n(e);for(const e of o.line_indices)n(e)}}n.OpenURL=a,a.__name__="OpenURL",a.init_OpenURL()},
function _(a,e,r){Object.defineProperty(r,"__esModule",{value:!0});var n=a(77);r.Canvas=n.Canvas;var s=a(208);r.CartesianFrame=s.CartesianFrame},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const a=e(209),_=e(146),n=e(157),r=e(158),i=e(210),g=e(98),c=e(212),o=e(13),l=e(11);class h extends c.LayoutItem{constructor(e,t,s,a,_={},n={}){super(),this.in_x_scale=e,this.in_y_scale=t,this.x_range=s,this.y_range=a,this.extra_x_ranges=_,this.extra_y_ranges=n,l.assert(null==e.source_range&&null==e.target_range),l.assert(null==t.source_range&&null==t.target_range),this._configure_scales()}_get_ranges(e,t){return new Map(o.entries(Object.assign(Object.assign({},t),{default:e})))}_get_scales(e,t,s){const c=new Map;for(const[o,l]of t){if((l instanceof i.DataRange1d||l instanceof r.Range1d)&&!(e instanceof _.ContinuousScale))throw new Error(`Range ${l.type} is incompatible is Scale ${e.type}`);if(l instanceof g.FactorRange&&!(e instanceof a.CategoricalScale))throw new Error(`Range ${l.type} is incompatible is Scale ${e.type}`);e instanceof n.LogScale&&l instanceof i.DataRange1d&&(l.scale_hint="log");const t=e.clone();t.setv({source_range:l,target_range:s}),c.set(o,t)}return c}_configure_frame_ranges(){const{bbox:e}=this;this._x_target=new r.Range1d({start:e.left,end:e.right}),this._y_target=new r.Range1d({start:e.bottom,end:e.top})}_configure_scales(){this._configure_frame_ranges(),this._x_ranges=this._get_ranges(this.x_range,this.extra_x_ranges),this._y_ranges=this._get_ranges(this.y_range,this.extra_y_ranges),this._x_scales=this._get_scales(this.in_x_scale,this._x_ranges,this._x_target),this._y_scales=this._get_scales(this.in_y_scale,this._y_ranges,this._y_target)}_update_scales(){this._configure_frame_ranges();for(const[,e]of this._x_scales)e.target_range=this._x_target;for(const[,e]of this._y_scales)e.target_range=this._y_target}_set_geometry(e,t){super._set_geometry(e,t),this._update_scales()}get x_ranges(){return this._x_ranges}get y_ranges(){return this._y_ranges}get x_scales(){return this._x_scales}get y_scales(){return this._y_scales}get x_scale(){return this._x_scales.get("default")}get y_scale(){return this._y_scales.get("default")}get xscales(){return o.to_object(this.x_scales)}get yscales(){return o.to_object(this.y_scales)}}s.CartesianFrame=h,h.__name__="CartesianFrame"},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});const n=e(147);class _ extends n.Scale{constructor(e){super(e)}compute(e){return super._linear_compute(this.source_range.synthetic(e))}v_compute(e){return super._linear_v_compute(this.source_range.v_synthetic(e))}invert(e){return this._linear_invert(e)}v_invert(e){return this._linear_v_invert(e)}}t.CategoricalScale=_,_.__name__="CategoricalScale"},
function _(t,i,n){Object.defineProperty(n,"__esModule",{value:!0});const e=t(1),a=t(211),s=t(90),l=t(19),_=e.__importStar(t(18)),o=e.__importStar(t(79)),r=t(9);class h extends a.DataRange{constructor(t){super(t),this.have_updated_interactively=!1}static init_DataRange1d(){this.define({start:[_.Number],end:[_.Number],range_padding:[_.Number,.1],range_padding_units:[_.PaddingUnits,"percent"],flipped:[_.Boolean,!1],follow:[_.StartEnd],follow_interval:[_.Number],default_span:[_.Number,2],only_visible:[_.Boolean,!1]}),this.internal({scale_hint:[_.String,"auto"]})}initialize(){super.initialize(),this._initial_start=this.start,this._initial_end=this.end,this._initial_range_padding=this.range_padding,this._initial_range_padding_units=this.range_padding_units,this._initial_follow=this.follow,this._initial_follow_interval=this.follow_interval,this._initial_default_span=this.default_span,this._plot_bounds=new Map}get min(){return Math.min(this.start,this.end)}get max(){return Math.max(this.start,this.end)}computed_renderers(){const t=this.names;let i=this.renderers;if(0==i.length)for(const t of this.plots){const n=t.renderers.filter(t=>t instanceof s.GlyphRenderer);i=i.concat(n)}t.length>0&&(i=i.filter(i=>r.includes(t,i.name))),l.logger.debug(`computed ${i.length} renderers for ${this}`);for(const t of i)l.logger.trace(" - "+t);return i}_compute_plot_bounds(t,i){let n=o.empty();for(const e of t){const t=i.get(e);null==t||!e.visible&&this.only_visible||(n=o.union(n,t))}return n}adjust_bounds_for_aspect(t,i){const n=o.empty();let e=t.x1-t.x0;e<=0&&(e=1);let a=t.y1-t.y0;a<=0&&(a=1);const s=.5*(t.x1+t.x0),l=.5*(t.y1+t.y0);return e<i*a?e=i*a:a=e/i,n.x1=s+.5*e,n.x0=s-.5*e,n.y1=l+.5*a,n.y0=l-.5*a,n}_compute_min_max(t,i){let n,e,a=o.empty();for(const i of t)a=o.union(a,i);return[n,e]=0==i?[a.x0,a.x1]:[a.y0,a.y1],[n,e]}_compute_range(t,i){const n=this.range_padding;let e,a;if(null!=this._initial_start&&(t=this._initial_start),null!=this._initial_end&&(i=this._initial_end),"log"==this.scale_hint){let s,_;if((isNaN(t)||!isFinite(t)||t<=0)&&(t=isNaN(i)||!isFinite(i)||i<=0?.1:i/100,l.logger.warn("could not determine minimum data value for log axis, DataRange1d using value "+t)),(isNaN(i)||!isFinite(i)||i<=0)&&(i=isNaN(t)||!isFinite(t)||t<=0?10:100*t,l.logger.warn("could not determine maximum data value for log axis, DataRange1d using value "+i)),i==t)_=this.default_span+.001,s=Math.log(t)/Math.log(10);else{let e,a;"percent"==this.range_padding_units?(e=Math.log(t)/Math.log(10),a=Math.log(i)/Math.log(10),_=(a-e)*(1+n)):(e=Math.log(t-n)/Math.log(10),a=Math.log(i+n)/Math.log(10),_=a-e),s=(e+a)/2}e=10**(s-_/2),a=10**(s+_/2)}else{let s;s=i==t?this.default_span:"percent"==this.range_padding_units?(i-t)*(1+n):i-t+2*n;const l=(i+t)/2;e=l-s/2,a=l+s/2}let s=1;this.flipped&&([e,a]=[a,e],s=-1);const _=this.follow_interval;return null!=_&&Math.abs(e-a)>_&&("start"==this.follow?a=e+s*_:"end"==this.follow&&(e=a-s*_)),[e,a]}update(t,i,n,e){if(this.have_updated_interactively)return;const a=this.computed_renderers();let s=this._compute_plot_bounds(a,t);null!=e&&(s=this.adjust_bounds_for_aspect(s,e)),this._plot_bounds.set(n,s);const[l,_]=this._compute_min_max(this._plot_bounds.values(),i);let[o,r]=this._compute_range(l,_);null!=this._initial_start&&("log"==this.scale_hint?this._initial_start>0&&(o=this._initial_start):o=this._initial_start),null!=this._initial_end&&("log"==this.scale_hint?this._initial_end>0&&(r=this._initial_end):r=this._initial_end);const[h,d]=[this.start,this.end];if(o!=h||r!=d){const t={};o!=h&&(t.start=o),r!=d&&(t.end=r),this.setv(t)}"auto"==this.bounds&&this.setv({bounds:[o,r]},{silent:!0}),this.change.emit()}reset(){this.have_updated_interactively=!1,this.setv({range_padding:this._initial_range_padding,range_padding_units:this._initial_range_padding_units,follow:this._initial_follow,follow_interval:this._initial_follow_interval,default_span:this._initial_default_span},{silent:!0}),this.change.emit()}}n.DataRange1d=h,h.__name__="DataRange1d",h.init_DataRange1d()},
function _(e,a,t){Object.defineProperty(t,"__esModule",{value:!0});const n=e(1),r=e(99),s=n.__importStar(e(18));class _ extends r.Range{constructor(e){super(e)}static init_DataRange(){this.define({names:[s.Array,[]],renderers:[s.Array,[]]})}}t.DataRange=_,_.__name__="DataRange",_.init_DataRange()},
function _(a,o,t){Object.defineProperty(t,"__esModule",{value:!0});var e=a(213);t.Sizeable=e.Sizeable,t.SizingPolicy=e.SizingPolicy;var i=a(214);t.Layoutable=i.Layoutable,t.LayoutItem=i.LayoutItem;var n=a(215);t.HStack=n.HStack,t.VStack=n.VStack,t.AnchorLayout=n.AnchorLayout;var r=a(216);t.Grid=r.Grid,t.Row=r.Row,t.Column=r.Column;var c=a(217);t.ContentBox=c.ContentBox,t.VariadicBox=c.VariadicBox},
function _(t,h,i){Object.defineProperty(i,"__esModule",{value:!0});const e=t(21),{min:d,max:n}=Math;class w{constructor(t={}){this.width=null!=t.width?t.width:0,this.height=null!=t.height?t.height:0}bounded_to({width:t,height:h}){return new w({width:this.width==1/0&&null!=t?t:this.width,height:this.height==1/0&&null!=h?h:this.height})}expanded_to({width:t,height:h}){return new w({width:t!=1/0?n(this.width,t):this.width,height:h!=1/0?n(this.height,h):this.height})}expand_to({width:t,height:h}){this.width=n(this.width,t),this.height=n(this.height,h)}narrowed_to({width:t,height:h}){return new w({width:d(this.width,t),height:d(this.height,h)})}narrow_to({width:t,height:h}){this.width=d(this.width,t),this.height=d(this.height,h)}grow_by({left:t,right:h,top:i,bottom:e}){const d=this.width+t+h,n=this.height+i+e;return new w({width:d,height:n})}shrink_by({left:t,right:h,top:i,bottom:e}){const d=n(this.width-t-h,0),s=n(this.height-i-e,0);return new w({width:d,height:s})}map(t,h){return new w({width:t(this.width),height:(null!=h?h:t)(this.height)})}}i.Sizeable=w,w.__name__="Sizeable",i.SizingPolicy=e.Enum("fixed","fit","min","max")},
function _(i,t,h){Object.defineProperty(h,"__esModule",{value:!0});const e=i(213),s=i(79),{min:n,max:g,round:a}=Math;class l{constructor(){this._bbox=new s.BBox,this._inner_bbox=new s.BBox}get bbox(){return this._bbox}get inner_bbox(){return this._inner_bbox}get sizing(){return this._sizing}set_sizing(i){const t=i.width_policy||"fit",h=i.width,e=null!=i.min_width?i.min_width:0,s=null!=i.max_width?i.max_width:1/0,n=i.height_policy||"fit",g=i.height,a=null!=i.min_height?i.min_height:0,l=null!=i.max_height?i.max_height:1/0,_=i.aspect,d=i.margin||{top:0,right:0,bottom:0,left:0},r=!1!==i.visible,w=i.halign||"start",o=i.valign||"start";this._sizing={width_policy:t,min_width:e,width:h,max_width:s,height_policy:n,min_height:a,height:g,max_height:l,aspect:_,margin:d,visible:r,halign:w,valign:o,size:{width:h,height:g},min_size:{width:e,height:a},max_size:{width:s,height:l}},this._init()}_init(){}_set_geometry(i,t){this._bbox=i,this._inner_bbox=t}set_geometry(i,t){this._set_geometry(i,t||i)}is_width_expanding(){return"max"==this.sizing.width_policy}is_height_expanding(){return"max"==this.sizing.height_policy}apply_aspect(i,{width:t,height:h}){const{aspect:e}=this.sizing;if(null!=e){const{width_policy:s,height_policy:n}=this.sizing,g=(i,t)=>{const h={max:4,fit:3,min:2,fixed:1};return h[i]>h[t]};if("fixed"!=s&&"fixed"!=n)if(s==n){const s=t,n=a(t/e),g=a(h*e),l=h;Math.abs(i.width-s)+Math.abs(i.height-n)<=Math.abs(i.width-g)+Math.abs(i.height-l)?(t=s,h=n):(t=g,h=l)}else g(s,n)?h=a(t/e):t=a(h*e);else"fixed"==s?h=a(t/e):"fixed"==n&&(t=a(h*e))}return{width:t,height:h}}measure(i){if(!this.sizing.visible)return{width:0,height:0};const t=i=>"fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:i,h=i=>"fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:i,s=new e.Sizeable(i).shrink_by(this.sizing.margin).map(t,h),n=this._measure(s),g=this.clip_size(n),a=t(g.width),l=h(g.height),_=this.apply_aspect(s,{width:a,height:l});return Object.assign(Object.assign({},n),_)}compute(i={}){const t=this.measure({width:null!=i.width&&this.is_width_expanding()?i.width:1/0,height:null!=i.height&&this.is_height_expanding()?i.height:1/0}),{width:h,height:e}=t,n=new s.BBox({left:0,top:0,width:h,height:e});let g=void 0;if(null!=t.inner){const{left:i,top:n,right:a,bottom:l}=t.inner;g=new s.BBox({left:i,top:n,right:h-a,bottom:e-l})}this.set_geometry(n,g)}get xview(){return this.bbox.xview}get yview(){return this.bbox.yview}clip_width(i){return g(this.sizing.min_width,n(i,this.sizing.max_width))}clip_height(i){return g(this.sizing.min_height,n(i,this.sizing.max_height))}clip_size({width:i,height:t}){return{width:this.clip_width(i),height:this.clip_height(t)}}}h.Layoutable=l,l.__name__="Layoutable";class _ extends l{_measure(i){const{width_policy:t,height_policy:h}=this.sizing;let e,s;if(i.width==1/0)e=null!=this.sizing.width?this.sizing.width:0;else switch(t){case"fixed":e=null!=this.sizing.width?this.sizing.width:0;break;case"min":e=null!=this.sizing.width?n(i.width,this.sizing.width):0;break;case"fit":e=null!=this.sizing.width?n(i.width,this.sizing.width):i.width;break;case"max":e=null!=this.sizing.width?g(i.width,this.sizing.width):i.width}if(i.height==1/0)s=null!=this.sizing.height?this.sizing.height:0;else switch(h){case"fixed":s=null!=this.sizing.height?this.sizing.height:0;break;case"min":s=null!=this.sizing.height?n(i.height,this.sizing.height):0;break;case"fit":s=null!=this.sizing.height?n(i.height,this.sizing.height):i.height;break;case"max":s=null!=this.sizing.height?g(i.height,this.sizing.height):i.height}return{width:e,height:s}}}h.LayoutItem=_,_.__name__="LayoutItem";class d extends l{_measure(i){const t=this._content_size(),h=i.bounded_to(this.sizing.size).bounded_to(t);return{width:(()=>{switch(this.sizing.width_policy){case"fixed":return null!=this.sizing.width?this.sizing.width:t.width;case"min":return t.width;case"fit":return h.width;case"max":return Math.max(t.width,h.width)}})(),height:(()=>{switch(this.sizing.height_policy){case"fixed":return null!=this.sizing.height?this.sizing.height:t.height;case"min":return t.height;case"fit":return h.height;case"max":return Math.max(t.height,h.height)}})()}}}h.ContentLayoutable=d,d.__name__="ContentLayoutable"},
function _(t,e,h){Object.defineProperty(h,"__esModule",{value:!0});const o=t(214),r=t(79);class i extends o.Layoutable{constructor(){super(...arguments),this.children=[]}}h.Stack=i,i.__name__="Stack";class s extends i{_measure(t){let e=0,h=0;for(const t of this.children){const o=t.measure({width:0,height:0});e+=o.width,h=Math.max(h,o.height)}return{width:e,height:h}}_set_geometry(t,e){super._set_geometry(t,e);const{top:h,bottom:o}=t;let{left:i}=t;for(const t of this.children){const{width:e}=t.measure({width:0,height:0});t.set_geometry(new r.BBox({left:i,width:e,top:h,bottom:o})),i+=e}}}h.HStack=s,s.__name__="HStack";class n extends i{_measure(t){let e=0,h=0;for(const t of this.children){const o=t.measure({width:0,height:0});e=Math.max(e,o.width),h+=o.height}return{width:e,height:h}}_set_geometry(t,e){super._set_geometry(t,e);const{left:h,right:o}=t;let{top:i}=t;for(const t of this.children){const{height:e}=t.measure({width:0,height:0});t.set_geometry(new r.BBox({top:i,height:e,left:h,right:o})),i+=e}}}h.VStack=n,n.__name__="VStack";class c extends o.Layoutable{constructor(){super(...arguments),this.children=[]}_measure(t){let e=0,h=0;for(const{layout:o}of this.children){const r=o.measure(t);e=Math.max(e,r.width),h=Math.max(h,r.height)}return{width:e,height:h}}_set_geometry(t,e){super._set_geometry(t,e);for(const{layout:e,anchor:h,margin:o}of this.children){const{left:i,right:s,top:n,bottom:c,hcenter:a,vcenter:_}=t,{width:g,height:d}=e.measure(t);let m;switch(h){case"top_left":m=new r.BBox({left:i+o,top:n+o,width:g,height:d});break;case"top_center":m=new r.BBox({hcenter:a,top:n+o,width:g,height:d});break;case"top_right":m=new r.BBox({right:s-o,top:n+o,width:g,height:d});break;case"bottom_right":m=new r.BBox({right:s-o,bottom:c-o,width:g,height:d});break;case"bottom_center":m=new r.BBox({hcenter:a,bottom:c-o,width:g,height:d});break;case"bottom_left":m=new r.BBox({left:i+o,bottom:c-o,width:g,height:d});break;case"center_left":m=new r.BBox({left:i+o,vcenter:_,width:g,height:d});break;case"center":m=new r.BBox({hcenter:a,vcenter:_,width:g,height:d});break;case"center_right":m=new r.BBox({right:s-o,vcenter:_,width:g,height:d})}e.set_geometry(m)}}}h.AnchorLayout=c,c.__name__="AnchorLayout"},
function _(t,i,s){Object.defineProperty(s,"__esModule",{value:!0});const e=t(213),o=t(214),n=t(8),r=t(79),h=t(9),{max:l,round:c}=Math;class a{constructor(t){this.def=t,this._map=new Map}get(t){let i=this._map.get(t);return void 0===i&&(i=this.def(),this._map.set(t,i)),i}apply(t,i){const s=this.get(t);this._map.set(t,i(s))}}a.__name__="DefaultMap";class g{constructor(){this._items=[],this._nrows=0,this._ncols=0}get nrows(){return this._nrows}get ncols(){return this._ncols}add(t,i){const{r1:s,c1:e}=t;this._nrows=l(this._nrows,s+1),this._ncols=l(this._ncols,e+1),this._items.push({span:t,data:i})}at(t,i){return this._items.filter(({span:s})=>s.r0<=t&&t<=s.r1&&s.c0<=i&&i<=s.c1).map(({data:t})=>t)}row(t){return this._items.filter(({span:i})=>i.r0<=t&&t<=i.r1).map(({data:t})=>t)}col(t){return this._items.filter(({span:i})=>i.c0<=t&&t<=i.c1).map(({data:t})=>t)}foreach(t){for(const{span:i,data:s}of this._items)t(i,s)}map(t){const i=new g;for(const{span:s,data:e}of this._items)i.add(s,t(s,e));return i}}g.__name__="Container";class p extends o.Layoutable{constructor(t=[]){super(),this.items=t,this.rows="auto",this.cols="auto",this.spacing=0,this.absolute=!1}is_width_expanding(){if(super.is_width_expanding())return!0;if("fixed"==this.sizing.width_policy)return!1;const{cols:t}=this._state;return h.some(t,t=>"max"==t.policy)}is_height_expanding(){if(super.is_height_expanding())return!0;if("fixed"==this.sizing.height_policy)return!1;const{rows:t}=this._state;return h.some(t,t=>"max"==t.policy)}_init(){super._init();const t=new g;for(const{layout:i,row:s,col:e,row_span:o,col_span:n}of this.items)if(i.sizing.visible){const r=s,h=e,l=s+(null!=o?o:1)-1,c=e+(null!=n?n:1)-1;t.add({r0:r,c0:h,r1:l,c1:c},i)}const{nrows:i,ncols:s}=t,e=new Array(i);for(let s=0;s<i;s++){const i=(()=>{const t=n.isPlainObject(this.rows)?this.rows[s]||this.rows["*"]:this.rows;return null==t?{policy:"auto"}:n.isNumber(t)?{policy:"fixed",height:t}:n.isString(t)?{policy:t}:t})(),o=i.align||"auto";if("fixed"==i.policy)e[s]={policy:"fixed",height:i.height,align:o};else if("min"==i.policy)e[s]={policy:"min",align:o};else if("fit"==i.policy||"max"==i.policy)e[s]={policy:i.policy,flex:i.flex||1,align:o};else{if("auto"!=i.policy)throw new Error("unrechable");h.some(t.row(s),t=>t.is_height_expanding())?e[s]={policy:"max",flex:1,align:o}:e[s]={policy:"min",align:o}}}const o=new Array(s);for(let i=0;i<s;i++){const s=(()=>{const t=n.isPlainObject(this.cols)?this.cols[i]||this.cols["*"]:this.cols;return null==t?{policy:"auto"}:n.isNumber(t)?{policy:"fixed",width:t}:n.isString(t)?{policy:t}:t})(),e=s.align||"auto";if("fixed"==s.policy)o[i]={policy:"fixed",width:s.width,align:e};else if("min"==s.policy)o[i]={policy:"min",align:e};else if("fit"==s.policy||"max"==s.policy)o[i]={policy:s.policy,flex:s.flex||1,align:e};else{if("auto"!=s.policy)throw new Error("unrechable");h.some(t.col(i),t=>t.is_width_expanding())?o[i]={policy:"max",flex:1,align:e}:o[i]={policy:"min",align:e}}}const[r,l]=n.isNumber(this.spacing)?[this.spacing,this.spacing]:this.spacing;this._state={items:t,nrows:i,ncols:s,rows:e,cols:o,rspacing:r,cspacing:l}}_measure_totals(t,i){const{nrows:s,ncols:e,rspacing:o,cspacing:n}=this._state;return{height:h.sum(t)+(s-1)*o,width:h.sum(i)+(e-1)*n}}_measure_cells(t){const{items:i,nrows:s,ncols:o,rows:n,cols:r,rspacing:h,cspacing:a}=this._state,p=new Array(s);for(let t=0;t<s;t++){const i=n[t];p[t]="fixed"==i.policy?i.height:0}const _=new Array(o);for(let t=0;t<o;t++){const i=r[t];_[t]="fixed"==i.policy?i.width:0}const f=new g;i.foreach((i,s)=>{const{r0:o,c0:g,r1:d,c1:w}=i,u=(d-o)*h,m=(w-g)*a;let y=0;for(let i=o;i<=d;i++)y+=t(i,g).height;y+=u;let x=0;for(let i=g;i<=w;i++)x+=t(o,i).width;x+=m;const b=s.measure({width:x,height:y});f.add(i,{layout:s,size_hint:b});const z=new e.Sizeable(b).grow_by(s.sizing.margin);z.height-=u,z.width-=m;const j=[];for(let t=o;t<=d;t++){const i=n[t];"fixed"==i.policy?z.height-=i.height:j.push(t)}if(z.height>0){const t=c(z.height/j.length);for(const i of j)p[i]=l(p[i],t)}const O=[];for(let t=g;t<=w;t++){const i=r[t];"fixed"==i.policy?z.width-=i.width:O.push(t)}if(z.width>0){const t=c(z.width/O.length);for(const i of O)_[i]=l(_[i],t)}});return{size:this._measure_totals(p,_),row_heights:p,col_widths:_,size_hints:f}}_measure_grid(t){const{nrows:i,ncols:s,rows:e,cols:o,rspacing:n,cspacing:r}=this._state,h=this._measure_cells((t,i)=>{const s=e[t],n=o[i];return{width:"fixed"==n.policy?n.width:1/0,height:"fixed"==s.policy?s.height:1/0}});let a;a="fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:t.height!=1/0&&this.is_height_expanding()?t.height:h.size.height;let g,p=0;for(let t=0;t<i;t++){const i=e[t];"fit"==i.policy||"max"==i.policy?p+=i.flex:a-=h.row_heights[t]}if(a-=(i-1)*n,0!=p&&a>0)for(let t=0;t<i;t++){const i=e[t];if("fit"==i.policy||"max"==i.policy){const s=c(a*(i.flex/p));a-=s,h.row_heights[t]=s,p-=i.flex}}else if(a<0){let t=0;for(let s=0;s<i;s++){"fixed"!=e[s].policy&&t++}let s=-a;for(let o=0;o<i;o++){if("fixed"!=e[o].policy){const i=h.row_heights[o],e=c(s/t);h.row_heights[o]=l(i-e,0),s-=e>i?i:e,t--}}}g="fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:t.width!=1/0&&this.is_width_expanding()?t.width:h.size.width;let _=0;for(let t=0;t<s;t++){const i=o[t];"fit"==i.policy||"max"==i.policy?_+=i.flex:g-=h.col_widths[t]}if(g-=(s-1)*r,0!=_&&g>0)for(let t=0;t<s;t++){const i=o[t];if("fit"==i.policy||"max"==i.policy){const s=c(g*(i.flex/_));g-=s,h.col_widths[t]=s,_-=i.flex}}else if(g<0){let t=0;for(let i=0;i<s;i++){"fixed"!=o[i].policy&&t++}let i=-g;for(let e=0;e<s;e++){if("fixed"!=o[e].policy){const s=h.col_widths[e],o=c(i/t);h.col_widths[e]=l(s-o,0),i-=o>s?s:o,t--}}}const{row_heights:f,col_widths:d,size_hints:w}=this._measure_cells((t,i)=>({width:h.col_widths[i],height:h.row_heights[t]}));return{size:this._measure_totals(f,d),row_heights:f,col_widths:d,size_hints:w}}_measure(t){const{size:i}=this._measure_grid(t);return i}_set_geometry(t,i){super._set_geometry(t,i);const{nrows:s,ncols:e,rspacing:o,cspacing:n}=this._state,{row_heights:h,col_widths:g,size_hints:p}=this._measure_grid(t),_=this._state.rows.map((t,i)=>Object.assign(Object.assign({},t),{top:0,height:h[i],get bottom(){return this.top+this.height}})),f=this._state.cols.map((t,i)=>Object.assign(Object.assign({},t),{left:0,width:g[i],get right(){return this.left+this.width}})),d=p.map((t,i)=>Object.assign(Object.assign({},i),{outer:new r.BBox,inner:new r.BBox}));for(let i=0,e=this.absolute?t.top:0;i<s;i++){const t=_[i];t.top=e,e+=t.height+o}for(let i=0,s=this.absolute?t.left:0;i<e;i++){const t=f[i];t.left=s,s+=t.width+n}d.foreach(({r0:t,c0:i,r1:s,c1:e},h)=>{const{layout:l,size_hint:a}=h,{sizing:g}=l,{width:p,height:d}=a,w=function(t,i){let s=(i-t)*n;for(let e=t;e<=i;e++)s+=f[e].width;return s}(i,e),u=function(t,i){let s=(i-t)*o;for(let e=t;e<=i;e++)s+=_[e].height;return s}(t,s),m=i==e&&"auto"!=f[i].align?f[i].align:g.halign,y=t==s&&"auto"!=_[t].align?_[t].align:g.valign;let x=f[i].left;"start"==m?x+=g.margin.left:"center"==m?x+=c((w-p)/2):"end"==m&&(x+=w-g.margin.right-p);let b=_[t].top;"start"==y?b+=g.margin.top:"center"==y?b+=c((u-d)/2):"end"==y&&(b+=u-g.margin.bottom-d),h.outer=new r.BBox({left:x,top:b,width:p,height:d})});const w=_.map(()=>({start:new a(()=>0),end:new a(()=>0)})),u=f.map(()=>({start:new a(()=>0),end:new a(()=>0)}));d.foreach(({r0:t,c0:i,r1:s,c1:e},{size_hint:o,outer:n})=>{const{inner:r}=o;null!=r&&(w[t].start.apply(n.top,t=>l(t,r.top)),w[s].end.apply(_[s].bottom-n.bottom,t=>l(t,r.bottom)),u[i].start.apply(n.left,t=>l(t,r.left)),u[e].end.apply(f[e].right-n.right,t=>l(t,r.right)))}),d.foreach(({r0:t,c0:i,r1:s,c1:e},o)=>{const{size_hint:n,outer:h}=o;function l({left:t,right:i,top:s,bottom:e}){const o=h.width-t-i,n=h.height-s-e;return new r.BBox({left:t,top:s,width:o,height:n})}if(null!=n.inner){let r=l(n.inner);if(!1!==n.align){const o=w[t].start.get(h.top),n=w[s].end.get(_[s].bottom-h.bottom),c=u[i].start.get(h.left),a=u[e].end.get(f[e].right-h.right);try{r=l({top:o,bottom:n,left:c,right:a})}catch(t){}}o.inner=r}else o.inner=h}),d.foreach((t,{layout:i,outer:s,inner:e})=>{i.set_geometry(s,e)})}}s.Grid=p,p.__name__="Grid";class _ extends p{constructor(t){super(),this.items=t.map((t,i)=>({layout:t,row:0,col:i})),this.rows="fit"}}s.Row=_,_.__name__="Row";class f extends p{constructor(t){super(),this.items=t.map((t,i)=>({layout:t,row:i,col:0})),this.cols="fit"}}s.Column=f,f.__name__="Column"},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const n=e(214),i=e(213),a=e(72);class c extends n.ContentLayoutable{constructor(e){super(),this.content_size=a.unsized(e,()=>new i.Sizeable(a.size(e)))}_content_size(){return this.content_size}}s.ContentBox=c,c.__name__="ContentBox";class o extends n.Layoutable{constructor(e){super(),this.el=e}_measure(e){const t=new i.Sizeable(e).bounded_to(this.sizing.size);return a.sized(this.el,t,()=>{const e=new i.Sizeable(a.content_size(this.el)),{border:t,padding:s}=a.extents(this.el);return e.grow_by(t).grow_by(s).map(Math.ceil)})}}s.VariadicBox=o,o.__name__="VariadicBox";class r extends o{constructor(e){super(e),this._cache=new Map}_measure(e){const{width:t,height:s}=e,n=`${t},${s}`;let i=this._cache.get(n);return null==i&&(i=super._measure(e),this._cache.set(n,i)),i}invalidate_cache(){this._cache.clear()}}s.CachedVariadicBox=r,r.__name__="CachedVariadicBox"},
function _(e,r,u){Object.defineProperty(u,"__esModule",{value:!0});var a=e(219);u.Expression=a.Expression;var n=e(220);u.Stack=n.Stack;var o=e(221);u.CumSum=o.CumSum},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const n=e(81);class i extends n.Model{constructor(e){super(e)}initialize(){super.initialize(),this._connected=new Set,this._result=new Map}v_compute(e){this._connected.has(e)||(this.connect(e.change,()=>this._result.delete(e)),this.connect(e.patching,()=>this._result.delete(e)),this.connect(e.streaming,()=>this._result.delete(e)),this._connected.add(e));let t=this._result.get(e);return null==t&&(t=this._v_compute(e),this._result.set(e,t)),t}}s.Expression=i,i.__name__="Expression"},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});const r=t(1),i=t(219),s=t(24),o=r.__importStar(t(18));class a extends i.Expression{constructor(t){super(t)}static init_Stack(){this.define({fields:[o.Array,[]]})}_v_compute(t){var e;const n=null!==(e=t.get_length())&&void 0!==e?e:0,r=new s.NumberArray(n);for(const e of this.fields){const i=t.data[e];if(null!=i)for(let t=0,e=Math.min(n,i.length);t<e;t++)r[t]+=i[t]}return r}}n.Stack=a,a.__name__="Stack",a.init_Stack()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const i=e(1),u=e(219),r=e(24),_=i.__importStar(e(18));class o extends u.Expression{constructor(e){super(e)}static init_CumSum(){this.define({field:[_.String],include_zero:[_.Boolean,!1]})}_v_compute(e){const t=new r.NumberArray(e.get_length()||0),n=e.data[this.field],i=this.include_zero?1:0;t[0]=this.include_zero?0:n[0];for(let e=1;e<t.length;e++)t[e]=t[e-1]+n[e-i];return t}}n.CumSum=o,o.__name__="CumSum",o.init_CumSum()},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});var l=e(223);t.BooleanFilter=l.BooleanFilter;var i=e(225);t.CustomJSFilter=i.CustomJSFilter;var o=e(224);t.Filter=o.Filter;var F=e(226);t.GroupFilter=F.GroupFilter;var a=e(227);t.IndexFilter=a.IndexFilter},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});const o=e(1),l=e(224),i=o.__importStar(e(18)),s=e(24);class r extends l.Filter{constructor(e){super(e)}static init_BooleanFilter(){this.define({booleans:[i.Array,null]})}compute_indices(e){const n=e.length,{booleans:t}=this;return null==t?s.Indices.all_set(n):s.Indices.from_booleans(n,t)}}t.BooleanFilter=r,r.__name__="BooleanFilter",r.init_BooleanFilter()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const o=e(81);class r extends o.Model{constructor(e){super(e)}}n.Filter=r,r.__name__="Filter"},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const s=e(1),n=e(224),i=s.__importStar(e(18)),o=e(24),u=e(13),c=e(8),a=e(29);class l extends n.Filter{constructor(e){super(e)}static init_CustomJSFilter(){this.define({args:[i.Any,{}],code:[i.String,""]})}get names(){return u.keys(this.args)}get values(){return u.values(this.args)}get func(){const e=a.use_strict(this.code);return new Function(...this.names,"source",e)}compute_indices(e){const t=e.length,r=this.func(...this.values,e);if(null==r)return o.Indices.all_set(t);if(c.isArrayOf(r,c.isInteger))return o.Indices.from_indices(t,r);if(c.isArrayOf(r,c.isBoolean))return o.Indices.from_booleans(t,r);throw new Error("expect an array of integers or booleans, or null, got "+r)}}r.CustomJSFilter=l,l.__name__="CustomJSFilter",l.init_CustomJSFilter()},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const r=e(1),i=e(224),o=r.__importStar(e(18)),u=e(24),s=e(19);class c extends i.Filter{constructor(e){super(e)}static init_GroupFilter(){this.define({column_name:[o.String],group:[o.String]})}compute_indices(e){const t=e.get_column(this.column_name);if(null==t)return s.logger.warn(`${this}: groupby column '${this.column_name}' not found in the data source`),new u.Indices(e.length,1);{const n=new u.Indices(e.length);for(let e=0;e<n.size;e++)t[e]===this.group&&n.set(e);return n}}}n.GroupFilter=c,c.__name__="GroupFilter",c.init_GroupFilter()},
function _(e,i,n){Object.defineProperty(n,"__esModule",{value:!0});const t=e(1),s=e(224),r=t.__importStar(e(18)),c=e(24);class l extends s.Filter{constructor(e){super(e)}static init_IndexFilter(){this.define({indices:[r.Array,null]})}compute_indices(e){const i=e.length,{indices:n}=this;return null==n?c.Indices.all_set(i):c.Indices.from_indices(i,n)}}n.IndexFilter=l,l.__name__="IndexFilter",l.init_IndexFilter()},
function _(r,t,a){Object.defineProperty(a,"__esModule",{value:!0});var e=r(130);a.BasicTickFormatter=e.BasicTickFormatter;var c=r(181);a.CategoricalTickFormatter=c.CategoricalTickFormatter;var i=r(185);a.DatetimeTickFormatter=i.DatetimeTickFormatter;var o=r(229);a.FuncTickFormatter=o.FuncTickFormatter;var m=r(198);a.LogTickFormatter=m.LogTickFormatter;var F=r(201);a.MercatorTickFormatter=F.MercatorTickFormatter;var k=r(230);a.NumeralTickFormatter=k.NumeralTickFormatter;var T=r(231);a.PrintfTickFormatter=T.PrintfTickFormatter;var v=r(131);a.TickFormatter=v.TickFormatter},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});const r=t(1),s=t(131),i=r.__importStar(t(18)),c=t(13),a=t(29);class u extends s.TickFormatter{constructor(t){super(t)}static init_FuncTickFormatter(){this.define({args:[i.Any,{}],code:[i.String,""]})}get names(){return c.keys(this.args)}get values(){return c.values(this.args)}_make_func(){const t=a.use_strict(this.code);return new Function("tick","index","ticks",...this.names,t)}doFormat(t,e){const n=this._make_func().bind({});return t.map((t,e,r)=>n(t,e,r,...this.values))}}n.FuncTickFormatter=u,u.__name__="FuncTickFormatter",u.init_FuncTickFormatter()},
function _(r,t,n){Object.defineProperty(n,"__esModule",{value:!0});const e=r(1),o=e.__importStar(r(188)),a=r(131),i=e.__importStar(r(18));class u extends a.TickFormatter{constructor(r){super(r)}static init_NumeralTickFormatter(){this.define({format:[i.String,"0,0"],language:[i.String,"en"],rounding:[i.RoundingFunction,"round"]})}get _rounding_fn(){switch(this.rounding){case"round":case"nearest":return Math.round;case"floor":case"rounddown":return Math.floor;case"ceil":case"roundup":return Math.ceil}}doFormat(r,t){const{format:n,language:e,_rounding_fn:a}=this;return r.map(r=>o.format(r,n,e,a))}}n.NumeralTickFormatter=u,u.__name__="NumeralTickFormatter",u.init_NumeralTickFormatter()},
function _(t,r,i){Object.defineProperty(i,"__esModule",{value:!0});const e=t(1),n=t(131),o=t(187),a=e.__importStar(t(18));class c extends n.TickFormatter{constructor(t){super(t)}static init_PrintfTickFormatter(){this.define({format:[a.String,"%s"]})}doFormat(t,r){return t.map(t=>o.sprintf(this.format,t))}}i.PrintfTickFormatter=c,c.__name__="PrintfTickFormatter",c.init_PrintfTickFormatter()},
function _(a,e,r){Object.defineProperty(r,"__esModule",{value:!0});var v=a(233);r.AnnularWedge=v.AnnularWedge;var l=a(234);r.Annulus=l.Annulus;var t=a(235);r.Arc=t.Arc;var i=a(236);r.Bezier=i.Bezier;var n=a(237);r.Circle=n.Circle;var u=a(241);r.CenterRotatable=u.CenterRotatable;var c=a(242);r.Ellipse=c.Ellipse;var g=a(243);r.EllipseOval=g.EllipseOval;var A=a(94);r.Glyph=A.Glyph;var p=a(111);r.HArea=p.HArea;var s=a(244);r.HBar=s.HBar;var d=a(246);r.HexTile=d.HexTile;var R=a(247);r.Image=R.Image;var o=a(249);r.ImageRGBA=o.ImageRGBA;var y=a(250);r.ImageURL=y.ImageURL;var h=a(92);r.Line=h.Line;var m=a(252);r.MultiLine=m.MultiLine;var B=a(253);r.MultiPolygons=B.MultiPolygons;var P=a(254);r.Oval=P.Oval;var G=a(110);r.Patch=G.Patch;var H=a(255);r.Patches=H.Patches;var I=a(256);r.Quad=I.Quad;var L=a(257);r.Quadratic=L.Quadratic;var M=a(258);r.Ray=M.Ray;var O=a(259);r.Rect=O.Rect;var x=a(260);r.Segment=x.Segment;var C=a(261);r.Step=C.Step;var E=a(262);r.Text=E.Text;var Q=a(113);r.VArea=Q.VArea;var S=a(263);r.VBar=S.VBar;var T=a(264);r.Wedge=T.Wedge;var V=a(93);r.XYGlyph=V.XYGlyph},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),r=e(93),n=e(100),a=e(28),_=e(24),o=i.__importStar(e(18)),d=e(10),h=e(88);class u extends r.XYGlyphView{_map_data(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this._inner_radius):this.sinner_radius=this._inner_radius,"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this._outer_radius):this.souter_radius=this._outer_radius,this._angle=new _.NumberArray(this._start_angle.length);for(let e=0,t=this._start_angle.length;e<t;e++)this._angle[e]=this._end_angle[e]-this._start_angle[e]}_render(e,t,{sx:s,sy:i,_start_angle:r,_angle:n,sinner_radius:a,souter_radius:_}){const o=this.model.properties.direction.value();for(const d of t)isNaN(s[d]+i[d]+a[d]+_[d]+r[d]+n[d])||(e.translate(s[d],i[d]),e.rotate(r[d]),e.beginPath(),e.moveTo(_[d],0),e.arc(0,0,_[d],0,n[d],o),e.rotate(n[d]),e.lineTo(a[d],0),e.arc(0,0,a[d],0,-n[d],!o),e.closePath(),e.rotate(-n[d]-r[d]),e.translate(-s[d],-i[d]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,d),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,d),e.stroke()))}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),r=this.renderer.yscale.invert(s);let n,a,_,o;if("data"==this.model.properties.outer_radius.units)n=i-this.max_outer_radius,_=i+this.max_outer_radius,a=r-this.max_outer_radius,o=r+this.max_outer_radius;else{const e=t-this.max_outer_radius,i=t+this.max_outer_radius;[n,_]=this.renderer.xscale.r_invert(e,i);const r=s-this.max_outer_radius,d=s+this.max_outer_radius;[a,o]=this.renderer.yscale.r_invert(r,d)}const u=[];for(const e of this.index.indices({x0:n,x1:_,y0:a,y1:o})){const t=this.souter_radius[e]**2,s=this.sinner_radius[e]**2,[n,a]=this.renderer.xscale.r_compute(i,this._x[e]),[_,o]=this.renderer.yscale.r_compute(r,this._y[e]),d=(n-a)**2+(_-o)**2;d<=t&&d>=s&&u.push(e)}const l=this.model.properties.direction.value(),c=[];for(const e of u){const i=Math.atan2(s-this.sy[e],t-this.sx[e]);d.angle_between(-i,-this._start_angle[e],-this._end_angle[e],l)&&c.push(e)}return new h.Selection({indices:c})}draw_legend_for_index(e,t,s){n.generic_area_legend(this.visuals,e,t,s)}scenterxy(e){const t=(this.sinner_radius[e]+this.souter_radius[e])/2,s=(this._start_angle[e]+this._end_angle[e])/2;return[this.sx[e]+t*Math.cos(s),this.sy[e]+t*Math.sin(s)]}}s.AnnularWedgeView=u,u.__name__="AnnularWedgeView";class l extends r.XYGlyph{constructor(e){super(e)}static init_AnnularWedge(){this.prototype.default_view=u,this.mixins([a.LineVector,a.FillVector]),this.define({direction:[o.Direction,"anticlock"],inner_radius:[o.DistanceSpec],outer_radius:[o.DistanceSpec],start_angle:[o.AngleSpec],end_angle:[o.AngleSpec]})}}s.AnnularWedge=l,l.__name__="AnnularWedge",l.init_AnnularWedge()},
function _(s,i,e){Object.defineProperty(e,"__esModule",{value:!0});const t=s(1),r=s(93),n=s(28),a=t.__importStar(s(18)),_=s(32),u=s(88);class o extends r.XYGlyphView{_map_data(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this._inner_radius):this.sinner_radius=this._inner_radius,"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this._outer_radius):this.souter_radius=this._outer_radius}_render(s,i,{sx:e,sy:t,sinner_radius:r,souter_radius:n}){for(const a of i)if(!isNaN(e[a]+t[a]+r[a]+n[a])){if(this.visuals.fill.doit){if(this.visuals.fill.set_vectorize(s,a),s.beginPath(),_.is_ie)for(const i of[!1,!0])s.arc(e[a],t[a],r[a],0,Math.PI,i),s.arc(e[a],t[a],n[a],Math.PI,0,!i);else s.arc(e[a],t[a],r[a],0,2*Math.PI,!0),s.arc(e[a],t[a],n[a],2*Math.PI,0,!1);s.fill()}this.visuals.line.doit&&(this.visuals.line.set_vectorize(s,a),s.beginPath(),s.arc(e[a],t[a],r[a],0,2*Math.PI),s.moveTo(e[a]+n[a],t[a]),s.arc(e[a],t[a],n[a],0,2*Math.PI),s.stroke())}}_hit_point(s){const{sx:i,sy:e}=s,t=this.renderer.xscale.invert(i),r=this.renderer.yscale.invert(e);let n,a,_,o;if("data"==this.model.properties.outer_radius.units)n=t-this.max_outer_radius,_=t+this.max_outer_radius,a=r-this.max_outer_radius,o=r+this.max_outer_radius;else{const s=i-this.max_outer_radius,t=i+this.max_outer_radius;[n,_]=this.renderer.xscale.r_invert(s,t);const r=e-this.max_outer_radius,u=e+this.max_outer_radius;[a,o]=this.renderer.yscale.r_invert(r,u)}const d=[];for(const s of this.index.indices({x0:n,x1:_,y0:a,y1:o})){const i=this.souter_radius[s]**2,e=this.sinner_radius[s]**2,[n,a]=this.renderer.xscale.r_compute(t,this._x[s]),[_,u]=this.renderer.yscale.r_compute(r,this._y[s]),o=(n-a)**2+(_-u)**2;o<=i&&o>=e&&d.push(s)}return new u.Selection({indices:d})}draw_legend_for_index(s,{x0:i,y0:e,x1:t,y1:r},n){const a=n+1,_=new Array(a);_[n]=(i+t)/2;const u=new Array(a);u[n]=(e+r)/2;const o=.5*Math.min(Math.abs(t-i),Math.abs(r-e)),d=new Array(a);d[n]=.4*o;const h=new Array(a);h[n]=.8*o,this._render(s,[n],{sx:_,sy:u,sinner_radius:d,souter_radius:h})}}e.AnnulusView=o,o.__name__="AnnulusView";class d extends r.XYGlyph{constructor(s){super(s)}static init_Annulus(){this.prototype.default_view=o,this.mixins([n.LineVector,n.FillVector]),this.define({inner_radius:[a.DistanceSpec],outer_radius:[a.DistanceSpec]})}}e.Annulus=d,d.__name__="Annulus",d.init_Annulus()},
function _(e,i,s){Object.defineProperty(s,"__esModule",{value:!0});const t=e(1),r=e(93),n=e(100),a=e(28),_=t.__importStar(e(18));class c extends r.XYGlyphView{_map_data(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius):this.sradius=this._radius}_render(e,i,{sx:s,sy:t,sradius:r,_start_angle:n,_end_angle:a}){if(this.visuals.line.doit){const _=this.model.properties.direction.value();for(const c of i)isNaN(s[c]+t[c]+r[c]+n[c]+a[c])||(e.beginPath(),e.arc(s[c],t[c],r[c],n[c],a[c],_),this.visuals.line.set_vectorize(e,c),e.stroke())}}draw_legend_for_index(e,i,s){n.generic_line_legend(this.visuals,e,i,s)}}s.ArcView=c,c.__name__="ArcView";class d extends r.XYGlyph{constructor(e){super(e)}static init_Arc(){this.prototype.default_view=c,this.mixins(a.LineVector),this.define({direction:[_.Direction,"anticlock"],radius:[_.DistanceSpec],start_angle:[_.AngleSpec],end_angle:[_.AngleSpec]})}}s.Arc=d,d.__name__="Arc",d.init_Arc()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(1),n=e(28),c=e(94),o=e(100),_=e(37),r=s.__importStar(e(18));function a(e,t,i,s,n,c,o,_){const r=[],a=[[],[]];for(let a=0;a<=2;a++){let h,d,x;if(0===a?(d=6*e-12*i+6*n,h=-3*e+9*i-9*n+3*o,x=3*i-3*e):(d=6*t-12*s+6*c,h=-3*t+9*s-9*c+3*_,x=3*s-3*t),Math.abs(h)<1e-12){if(Math.abs(d)<1e-12)continue;const e=-x/d;0<e&&e<1&&r.push(e);continue}const l=d*d-4*x*h,y=Math.sqrt(l);if(l<0)continue;const p=(-d+y)/(2*h);0<p&&p<1&&r.push(p);const f=(-d-y)/(2*h);0<f&&f<1&&r.push(f)}let h=r.length;const d=h;for(;h--;){const d=r[h],x=1-d,l=x*x*x*e+3*x*x*d*i+3*x*d*d*n+d*d*d*o;a[0][h]=l;const y=x*x*x*t+3*x*x*d*s+3*x*d*d*c+d*d*d*_;a[1][h]=y}return a[0][d]=e,a[1][d]=t,a[0][d+1]=o,a[1][d+1]=_,[Math.min(...a[0]),Math.max(...a[1]),Math.max(...a[0]),Math.min(...a[1])]}class h extends c.GlyphView{_project_data(){_.inplace.project_xy(this._x0,this._y0),_.inplace.project_xy(this._x1,this._y1)}_index_data(e){const{data_size:t}=this;for(let i=0;i<t;i++)if(isNaN(this._x0[i]+this._x1[i]+this._y0[i]+this._y1[i]+this._cx0[i]+this._cy0[i]+this._cx1[i]+this._cy1[i]))e.add_empty();else{const[t,s,n,c]=a(this._x0[i],this._y0[i],this._x1[i],this._y1[i],this._cx0[i],this._cy0[i],this._cx1[i],this._cy1[i]);e.add(t,s,n,c)}}_render(e,t,{sx0:i,sy0:s,sx1:n,sy1:c,scx0:o,scy0:_,scx1:r,scy1:a}){if(this.visuals.line.doit)for(const h of t)isNaN(i[h]+s[h]+n[h]+c[h]+o[h]+_[h]+r[h]+a[h])||(e.beginPath(),e.moveTo(i[h],s[h]),e.bezierCurveTo(o[h],_[h],r[h],a[h],n[h],c[h]),this.visuals.line.set_vectorize(e,h),e.stroke())}draw_legend_for_index(e,t,i){o.generic_line_legend(this.visuals,e,t,i)}scenterxy(){throw new Error(this+".scenterxy() is not implemented")}}i.BezierView=h,h.__name__="BezierView";class d extends c.Glyph{constructor(e){super(e)}static init_Bezier(){this.prototype.default_view=h,this.define({x0:[r.XCoordinateSpec,{field:"x0"}],y0:[r.YCoordinateSpec,{field:"y0"}],x1:[r.XCoordinateSpec,{field:"x1"}],y1:[r.YCoordinateSpec,{field:"y1"}],cx0:[r.XCoordinateSpec,{field:"cx0"}],cy0:[r.YCoordinateSpec,{field:"cy0"}],cx1:[r.XCoordinateSpec,{field:"cx1"}],cy1:[r.YCoordinateSpec,{field:"cy1"}]}),this.mixins(n.LineVector)}}i.Bezier=d,d.__name__="Bezier",d.init_Bezier()},
function _(s,i,e){Object.defineProperty(e,"__esModule",{value:!0});const t=s(1),r=s(93),a=s(238),n=s(28),h=t.__importStar(s(101)),d=t.__importStar(s(18)),l=s(9),_=s(12),c=s(88);class o extends r.XYGlyphView{initialize(){super.initialize();const{webgl:s}=this.renderer.plot_view.canvas_view;null!=s&&(this.glglyph=new a.CircleGL(s.gl,this))}_map_data(){if(null!=this._radius)if("data"==this.model.properties.radius.units)switch(this.model.radius_dimension){case"x":this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius);break;case"y":this.sradius=this.sdist(this.renderer.yscale,this._y,this._radius);break;case"max":{const s=this.sdist(this.renderer.xscale,this._x,this._radius),i=this.sdist(this.renderer.yscale,this._y,this._radius);this.sradius=_.map(s,(s,e)=>Math.max(s,i[e]));break}case"min":{const s=this.sdist(this.renderer.xscale,this._x,this._radius),i=this.sdist(this.renderer.yscale,this._y,this._radius);this.sradius=_.map(s,(s,e)=>Math.min(s,i[e]));break}}else this.sradius=this._radius,this.max_size=2*this.max_radius;else this.sradius=_.map(this._size,s=>s/2)}_mask_data(){const[s,i]=this.renderer.plot_view.frame.bbox.ranges;let e,t,r,a;if(null!=this._radius&&"data"==this.model.properties.radius.units){const n=s.start,h=s.end;[e,r]=this.renderer.xscale.r_invert(n,h),e-=this.max_radius,r+=this.max_radius;const d=i.start,l=i.end;[t,a]=this.renderer.yscale.r_invert(d,l),t-=this.max_radius,a+=this.max_radius}else{const n=s.start-this.max_size,h=s.end+this.max_size;[e,r]=this.renderer.xscale.r_invert(n,h);const d=i.start-this.max_size,l=i.end+this.max_size;[t,a]=this.renderer.yscale.r_invert(d,l)}return this.index.indices({x0:e,x1:r,y0:t,y1:a})}_render(s,i,{sx:e,sy:t,sradius:r}){for(const a of i)isNaN(e[a]+t[a]+r[a])||(s.beginPath(),s.arc(e[a],t[a],r[a],0,2*Math.PI,!1),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(s,a),s.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(s,a),s.stroke()))}_hit_point(s){const{sx:i,sy:e}=s,t=this.renderer.xscale.invert(i),r=this.renderer.yscale.invert(e);let a,n,h,d;if(null!=this._radius&&"data"==this.model.properties.radius.units)a=t-this.max_radius,n=t+this.max_radius,h=r-this.max_radius,d=r+this.max_radius;else{const s=i-this.max_size,t=i+this.max_size;[a,n]=this.renderer.xscale.r_invert(s,t);const r=e-this.max_size,l=e+this.max_size;[h,d]=this.renderer.yscale.r_invert(r,l)}const l=this.index.indices({x0:a,x1:n,y0:h,y1:d}),_=[];if(null!=this._radius&&"data"==this.model.properties.radius.units)for(const s of l){const i=this.sradius[s]**2,[e,a]=this.renderer.xscale.r_compute(t,this._x[s]),[n,h]=this.renderer.yscale.r_compute(r,this._y[s]);(e-a)**2+(n-h)**2<=i&&_.push(s)}else for(const s of l){const t=this.sradius[s]**2;(this.sx[s]-i)**2+(this.sy[s]-e)**2<=t&&_.push(s)}return new c.Selection({indices:_})}_hit_span(s){const{sx:i,sy:e}=s,t=this.bounds();let r,a,n,h;if("h"==s.direction){let s,e;if(n=t.y0,h=t.y1,null!=this._radius&&"data"==this.model.properties.radius.units)s=i-this.max_radius,e=i+this.max_radius,[r,a]=this.renderer.xscale.r_invert(s,e);else{const t=this.max_size/2;s=i-t,e=i+t,[r,a]=this.renderer.xscale.r_invert(s,e)}}else{let s,i;if(r=t.x0,a=t.x1,null!=this._radius&&"data"==this.model.properties.radius.units)s=e-this.max_radius,i=e+this.max_radius,[n,h]=this.renderer.yscale.r_invert(s,i);else{const t=this.max_size/2;s=e-t,i=e+t,[n,h]=this.renderer.yscale.r_invert(s,i)}}const d=[...this.index.indices({x0:r,x1:a,y0:n,y1:h})];return new c.Selection({indices:d})}_hit_rect(s){const{sx0:i,sx1:e,sy0:t,sy1:r}=s,[a,n]=this.renderer.xscale.r_invert(i,e),[h,d]=this.renderer.yscale.r_invert(t,r),l=[...this.index.indices({x0:a,x1:n,y0:h,y1:d})];return new c.Selection({indices:l})}_hit_poly(s){const{sx:i,sy:e}=s,t=l.range(0,this.sx.length),r=[];for(let s=0,a=t.length;s<a;s++){const a=t[s];h.point_in_poly(this.sx[s],this.sy[s],i,e)&&r.push(a)}return new c.Selection({indices:r})}draw_legend_for_index(s,{x0:i,y0:e,x1:t,y1:r},a){const n=a+1,h=new Array(n);h[a]=(i+t)/2;const d=new Array(n);d[a]=(e+r)/2;const l=new Array(n);l[a]=.2*Math.min(Math.abs(t-i),Math.abs(r-e)),this._render(s,[a],{sx:h,sy:d,sradius:l})}}e.CircleView=o,o.__name__="CircleView";class u extends r.XYGlyph{constructor(s){super(s)}static init_Circle(){this.prototype.default_view=o,this.mixins([n.LineVector,n.FillVector]),this.define({angle:[d.AngleSpec,0],size:[d.DistanceSpec,{units:"screen",value:4}],radius:[d.DistanceSpec,void 0,{optional:!0}],radius_dimension:[d.RadiusDimension,"x"]})}}e.Circle=u,u.__name__="Circle",u.init_Circle()},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const i=t(1),a=t(103),r=t(107),o=t(239),_=t(240),l=t(237),h=t(12),n=t(19),g=t(22);function u(t,e,s,i,a,r){if(a.doit)if(a[r].is_value)e.used=!1,t.set_attribute(s,"float",[a[r].value()]);else{e.used=!0;const o=new Float32Array(a.get_array(r));e.set_size(4*i),e.set_data(0,o),t.set_attribute(s,"float",e)}else e.used=!1,t.set_attribute(s,"float",[0])}function f(t,e,s,i,a,r){const o=r+"_color",_=r+"_alpha";if(a.doit){let r,l;if(e.used=!0,a[o].is_value){const t=g.encode_rgba(g.color2rgba(a[o].value())),e=new Uint32Array(i);e.fill(t),r=e}else r=a.get_array(o);if(a[_].is_value){const t=a[_].value(),e=new Float32Array(i);e.fill(t),l=e}else l=a.get_array(_);const h=new Float32Array(4*i);for(let t=0,e=i;t<e;t++){const e=g.decode_rgba(r[t]);1==e[3]&&(e[3]=l[t]),h.set(e,4*t)}e.set_size(4*i*4),e.set_data(0,h),t.set_attribute(s,"vec4",e)}else e.used=!1,t.set_attribute(s,"vec4",[0,0,0,0])}s.attach_float=u,s.attach_color=f;class d extends r.BaseGLGlyph{init(){const{gl:t}=this,e=o.vertex_shader,s=_.fragment_shader(this._marker_code);this.prog=new a.Program(t),this.prog.set_shaders(e,s),this.vbo_sx=new a.VertexBuffer(t),this.prog.set_attribute("a_sx","float",this.vbo_sx),this.vbo_sy=new a.VertexBuffer(t),this.prog.set_attribute("a_sy","float",this.vbo_sy),this.vbo_s=new a.VertexBuffer(t),this.prog.set_attribute("a_size","float",this.vbo_s),this.vbo_a=new a.VertexBuffer(t),this.prog.set_attribute("a_angle","float",this.vbo_a),this.vbo_linewidth=new a.VertexBuffer(t),this.vbo_fg_color=new a.VertexBuffer(t),this.vbo_bg_color=new a.VertexBuffer(t),this.index_buffer=new a.IndexBuffer(t)}draw(t,e,s){const i=e.glglyph,{nvertices:a}=i;if(i.data_changed&&(i._set_data(a),this.glyph instanceof l.CircleView&&null!=this.glyph._radius&&this.vbo_s.set_data(0,h.map(this.glyph.sradius,t=>2*t)),i.data_changed=!1),this.visuals_changed&&(this._set_visuals(a),this.visuals_changed=!1),this.prog.set_uniform("u_pixel_ratio","float",[s.pixel_ratio]),this.prog.set_uniform("u_canvas_size","vec2",[s.width,s.height]),this.prog.set_attribute("a_sx","float",i.vbo_sx),this.prog.set_attribute("a_sy","float",i.vbo_sy),this.prog.set_attribute("a_size","float",i.vbo_s),this.prog.set_attribute("a_angle","float",i.vbo_a),0!=t.length)if(t.length===a)this.prog.draw(this.gl.POINTS,[0,a]);else if(a<65535){const e=window.navigator.userAgent;e.indexOf("MSIE ")+e.indexOf("Trident/")+e.indexOf("Edge/")>0&&n.logger.warn("WebGL warning: IE is known to produce 1px sprites whith selections."),this.index_buffer.set_size(2*t.length),this.index_buffer.set_data(0,new Uint16Array(t)),this.prog.draw(this.gl.POINTS,this.index_buffer)}else{const e=64e3,s=[];for(let t=0,i=Math.ceil(a/e);t<i;t++)s.push([]);for(let i=0,a=t.length;i<a;i++){const a=t[i]%e;s[Math.floor(t[i]/e)].push(a)}for(let t=0,a=s.length;t<a;t++){const a=new Uint16Array(s[t]),r=t*e*4;0!==a.length&&(this.prog.set_attribute("a_sx","float",i.vbo_sx,0,r),this.prog.set_attribute("a_sy","float",i.vbo_sy,0,r),this.prog.set_attribute("a_size","float",i.vbo_s,0,r),this.prog.set_attribute("a_angle","float",i.vbo_a,0,r),this.vbo_linewidth.used&&this.prog.set_attribute("a_linewidth","float",this.vbo_linewidth,0,r),this.vbo_fg_color.used&&this.prog.set_attribute("a_fg_color","vec4",this.vbo_fg_color,0,4*r),this.vbo_bg_color.used&&this.prog.set_attribute("a_bg_color","vec4",this.vbo_bg_color,0,4*r),this.index_buffer.set_size(2*a.length),this.index_buffer.set_data(0,a),this.prog.draw(this.gl.POINTS,this.index_buffer))}}}_set_data(t){const e=4*t;this.vbo_sx.set_size(e),this.vbo_sy.set_size(e),this.vbo_a.set_size(e),this.vbo_s.set_size(e),this.vbo_sx.set_data(0,this.glyph.sx),this.vbo_sy.set_data(0,this.glyph.sy),null!=this.glyph._angle&&this.vbo_a.set_data(0,new Float32Array(this.glyph._angle)),this.glyph instanceof l.CircleView&&null!=this.glyph._radius?this.vbo_s.set_data(0,h.map(this.glyph.sradius,t=>2*t)):this.vbo_s.set_data(0,new Float32Array(this.glyph._size))}_set_visuals(t){u(this.prog,this.vbo_linewidth,"a_linewidth",t,this.glyph.visuals.line,"line_width"),f(this.prog,this.vbo_fg_color,"a_fg_color",t,this.glyph.visuals.line,"line"),f(this.prog,this.vbo_bg_color,"a_bg_color",t,this.glyph.visuals.fill,"fill"),this.prog.set_uniform("u_antialias","float",[.8])}}function b(t){return class extends d{get _marker_code(){return t}}}s.MarkerGL=d,d.__name__="MarkerGL";const c=i.__importStar(t(240));s.AsteriskGL=b(c.asterisk),s.CircleGL=b(c.circle),s.CircleCrossGL=b(c.circlecross),s.CircleXGL=b(c.circlex),s.CrossGL=b(c.cross),s.DiamondGL=b(c.diamond),s.DiamondCrossGL=b(c.diamondcross),s.HexGL=b(c.hex),s.InvertedTriangleGL=b(c.invertedtriangle),s.SquareGL=b(c.square),s.SquareCrossGL=b(c.squarecross),s.SquareXGL=b(c.squarex),s.TriangleGL=b(c.triangle),s.XGL=b(c.x)},
function _(n,i,a){Object.defineProperty(a,"__esModule",{value:!0}),a.vertex_shader="\nprecision mediump float;\nconst float SQRT_2 = 1.4142135623730951;\n//\nuniform float u_pixel_ratio;\nuniform vec2 u_canvas_size;\nuniform vec2 u_offset;\nuniform vec2 u_scale;\nuniform float u_antialias;\n//\nattribute float a_sx;\nattribute float a_sy;\nattribute float a_size;\nattribute float a_angle;  // in radians\nattribute float a_linewidth;\nattribute vec4  a_fg_color;\nattribute vec4  a_bg_color;\n//\nvarying float v_linewidth;\nvarying float v_size;\nvarying vec4  v_fg_color;\nvarying vec4  v_bg_color;\nvarying vec2  v_rotation;\n\nvoid main (void)\n{\n    v_size = a_size * u_pixel_ratio;\n    v_linewidth = a_linewidth * u_pixel_ratio;\n    v_fg_color = a_fg_color;\n    v_bg_color = a_bg_color;\n    v_rotation = vec2(cos(-a_angle), sin(-a_angle));\n    vec2 pos = vec2(a_sx, a_sy);  // in pixels\n    pos += 0.5;  // make up for Bokeh's offset\n    pos /= u_canvas_size / u_pixel_ratio;  // in 0..1\n    gl_Position = vec4(pos*2.0-1.0, 0.0, 1.0);\n    gl_Position.y *= -1.0;\n    gl_PointSize = SQRT_2 * v_size + 2.0 * (v_linewidth + 1.5*u_antialias);\n}\n"},
function _(a,n,s){Object.defineProperty(s,"__esModule",{value:!0}),s.fragment_shader=a=>`\nprecision mediump float;\nconst float SQRT_2 = 1.4142135623730951;\nconst float PI = 3.14159265358979323846264;\n//\nuniform float u_antialias;\n//\nvarying vec4  v_fg_color;\nvarying vec4  v_bg_color;\nvarying float v_linewidth;\nvarying float v_size;\nvarying vec2  v_rotation;\n\n${a}\n\nvec4 outline(float distance, float linewidth, float antialias, vec4 fg_color, vec4 bg_color)\n{\n    vec4 frag_color;\n    float t = linewidth/2.0 - antialias;\n    float signed_distance = distance;\n    float border_distance = abs(signed_distance) - t;\n    float alpha = border_distance/antialias;\n    alpha = exp(-alpha*alpha);\n\n    // If fg alpha is zero, it probably means no outline. To avoid a dark outline\n    // shining through due to aa, we set the fg color to the bg color. Avoid if (i.e. branching).\n    float select = float(bool(fg_color.a));\n    fg_color.rgb = select * fg_color.rgb + (1.0  - select) * bg_color.rgb;\n    // Similarly, if we want a transparent bg\n    select = float(bool(bg_color.a));\n    bg_color.rgb = select * bg_color.rgb + (1.0  - select) * fg_color.rgb;\n\n    if( border_distance < 0.0)\n        frag_color = fg_color;\n    else if( signed_distance < 0.0 ) {\n        frag_color = mix(bg_color, fg_color, sqrt(alpha));\n    } else {\n        if( abs(signed_distance) < (linewidth/2.0 + antialias) ) {\n            frag_color = vec4(fg_color.rgb, fg_color.a * alpha);\n        } else {\n            discard;\n        }\n    }\n    return frag_color;\n}\n\nvoid main()\n{\n    vec2 P = gl_PointCoord.xy - vec2(0.5, 0.5);\n    P = vec2(v_rotation.x*P.x - v_rotation.y*P.y,\n             v_rotation.y*P.x + v_rotation.x*P.y);\n    float point_size = SQRT_2*v_size  + 2.0 * (v_linewidth + 1.5*u_antialias);\n    float distance = marker(P*point_size, v_size);\n    gl_FragColor = outline(distance, v_linewidth, u_antialias, v_fg_color, v_bg_color);\n}\n`,s.circle="\nfloat marker(vec2 P, float size)\n{\n    return length(P) - size/2.0;\n}\n",s.square="\nfloat marker(vec2 P, float size)\n{\n    return max(abs(P.x), abs(P.y)) - size/2.0;\n}\n",s.diamond="\nfloat marker(vec2 P, float size)\n{\n    float x = SQRT_2 / 2.0 * (P.x * 1.5 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.5 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / (2.0 * SQRT_2);\n    return r1 / SQRT_2;\n}\n",s.hex="\nfloat marker(vec2 P, float size)\n{\n    vec2 q = abs(P);\n    return max(q.y * 0.57735 + q.x - 1.0 * size/2.0, q.y - 0.866 * size/2.0);\n}\n",s.triangle="\nfloat marker(vec2 P, float size)\n{\n    P.y -= size * 0.3;\n    float x = SQRT_2 / 2.0 * (P.x * 1.7 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.7 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / 1.6;\n    float r2 = P.y;\n    return max(r1 / SQRT_2, r2);  // Intersect diamond with rectangle\n}\n",s.invertedtriangle="\nfloat marker(vec2 P, float size)\n{\n    P.y += size * 0.3;\n    float x = SQRT_2 / 2.0 * (P.x * 1.7 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.7 + P.y);\n    float r1 = max(abs(x), abs(y)) - size / 1.6;\n    float r2 = - P.y;\n    return max(r1 / SQRT_2, r2);  // Intersect diamond with rectangle\n}\n",s.cross='\nfloat marker(vec2 P, float size)\n{\n    float square = max(abs(P.x), abs(P.y)) - size / 2.5;   // 2.5 is a tweak\n    float cross = min(abs(P.x), abs(P.y)) - size / 100.0;  // bit of "width" for aa\n    return max(square, cross);\n}\n',s.circlecross="\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float circle = length(P) - size/2.0;\n    float c1 = max(circle, s1);\n    float c2 = max(circle, s2);\n    float c3 = max(circle, s3);\n    float c4 = max(circle, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n",s.squarecross="\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float square = max(abs(P.x), abs(P.y)) - size/2.0;\n    float c1 = max(square, s1);\n    float c2 = max(square, s2);\n    float c3 = max(square, s3);\n    float c4 = max(square, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n",s.diamondcross="\nfloat marker(vec2 P, float size)\n{\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(P.x - qs), abs(P.y - qs)) - qs;\n    float s2 = max(abs(P.x + qs), abs(P.y - qs)) - qs;\n    float s3 = max(abs(P.x - qs), abs(P.y + qs)) - qs;\n    float s4 = max(abs(P.x + qs), abs(P.y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float x = SQRT_2 / 2.0 * (P.x * 1.5 - P.y);\n    float y = SQRT_2 / 2.0 * (P.x * 1.5 + P.y);\n    float diamond = max(abs(x), abs(y)) - size / (2.0 * SQRT_2);\n    diamond /= SQRT_2;\n    float c1 = max(diamond, s1);\n    float c2 = max(diamond, s2);\n    float c3 = max(diamond, s3);\n    float c4 = max(diamond, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n",s.x='\nfloat marker(vec2 P, float size)\n{\n    float circle = length(P) - size / 1.6;\n    float X = min(abs(P.x - P.y), abs(P.x + P.y)) - size / 100.0;  // bit of "width" for aa\n    return max(circle, X);\n}\n',s.circlex='\nfloat marker(vec2 P, float size)\n{\n    float x = P.x - P.y;\n    float y = P.x + P.y;\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(x - qs), abs(y - qs)) - qs;\n    float s2 = max(abs(x + qs), abs(y - qs)) - qs;\n    float s3 = max(abs(x - qs), abs(y + qs)) - qs;\n    float s4 = max(abs(x + qs), abs(y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float circle = length(P) - size/2.0;\n    float c1 = max(circle, s1);\n    float c2 = max(circle, s2);\n    float c3 = max(circle, s3);\n    float c4 = max(circle, s4);\n    // Union\n    float almost = min(min(min(c1, c2), c3), c4);\n    // In this case, the X is also outside of the main shape\n    float Xmask = length(P) - size / 1.6;  // a circle\n    float X = min(abs(P.x - P.y), abs(P.x + P.y)) - size / 100.0;  // bit of "width" for aa\n    return min(max(X, Xmask), almost);\n}\n',s.squarex="\nfloat marker(vec2 P, float size)\n{\n    float x = P.x - P.y;\n    float y = P.x + P.y;\n    // Define quadrants\n    float qs = size / 2.0;  // quadrant size\n    float s1 = max(abs(x - qs), abs(y - qs)) - qs;\n    float s2 = max(abs(x + qs), abs(y - qs)) - qs;\n    float s3 = max(abs(x - qs), abs(y + qs)) - qs;\n    float s4 = max(abs(x + qs), abs(y + qs)) - qs;\n    // Intersect main shape with quadrants (to form cross)\n    float square = max(abs(P.x), abs(P.y)) - size/2.0;\n    float c1 = max(square, s1);\n    float c2 = max(square, s2);\n    float c3 = max(square, s3);\n    float c4 = max(square, s4);\n    // Union\n    return min(min(min(c1, c2), c3), c4);\n}\n",s.asterisk='\nfloat marker(vec2 P, float size)\n{\n    // Masks\n    float diamond = max(abs(SQRT_2 / 2.0 * (P.x - P.y)), abs(SQRT_2 / 2.0 * (P.x + P.y))) - size / (2.0 * SQRT_2);\n    float square = max(abs(P.x), abs(P.y)) - size / (2.0 * SQRT_2);\n    // Shapes\n    float X = min(abs(P.x - P.y), abs(P.x + P.y)) - size / 100.0;  // bit of "width" for aa\n    float cross = min(abs(P.x), abs(P.y)) - size / 100.0;  // bit of "width" for aa\n    // Result is union of masked shapes\n    return min(max(X, diamond), max(cross, square));\n}\n'},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const a=e(1),i=e(93),l=e(28),s=a.__importStar(e(18));class c extends i.XYGlyphView{}n.CenterRotatableView=c,c.__name__="CenterRotatableView";class o extends i.XYGlyph{constructor(e){super(e)}static init_CenterRotatable(){this.mixins([l.LineVector,l.FillVector]),this.define({angle:[s.AngleSpec,0],width:[s.DistanceSpec],height:[s.DistanceSpec]})}}n.CenterRotatable=o,o.__name__="CenterRotatable",o.init_CenterRotatable()},
function _(e,l,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(243);class t extends s.EllipseOvalView{}i.EllipseView=t,t.__name__="EllipseView";class _ extends s.EllipseOval{constructor(e){super(e)}static init_Ellipse(){this.prototype.default_view=t}}i.Ellipse=_,_.__name__="Ellipse",_.init_Ellipse()},
function _(t,s,i){Object.defineProperty(i,"__esModule",{value:!0});const e=t(1),h=t(241),a=e.__importStar(t(101)),r=t(88);class n extends h.CenterRotatableView{_set_data(){this.max_w2=0,"data"==this.model.properties.width.units&&(this.max_w2=this.max_width/2),this.max_h2=0,"data"==this.model.properties.height.units&&(this.max_h2=this.max_height/2)}_map_data(){"data"==this.model.properties.width.units?this.sw=this.sdist(this.renderer.xscale,this._x,this._width,"center"):this.sw=this._width,"data"==this.model.properties.height.units?this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"):this.sh=this._height}_render(t,s,{sx:i,sy:e,sw:h,sh:a,_angle:r}){for(const n of s)isNaN(i[n]+e[n]+h[n]+a[n]+r[n])||(t.beginPath(),t.ellipse(i[n],e[n],h[n]/2,a[n]/2,r[n],0,2*Math.PI),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,n),t.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,n),t.stroke()))}_hit_point(t){let s,i,e,h,n,_,l,d,o;const{sx:x,sy:m}=t,w=this.renderer.xscale.invert(x),c=this.renderer.yscale.invert(m);"data"==this.model.properties.width.units?(s=w-this.max_width,i=w+this.max_width):(_=x-this.max_width,l=x+this.max_width,[s,i]=this.renderer.xscale.r_invert(_,l)),"data"==this.model.properties.height.units?(e=c-this.max_height,h=c+this.max_height):(d=m-this.max_height,o=m+this.max_height,[e,h]=this.renderer.yscale.r_invert(d,o));const p=this.index.indices({x0:s,x1:i,y0:e,y1:h}),y=[];for(const t of p)n=a.point_in_ellipse(x,m,this._angle[t],this.sh[t]/2,this.sw[t]/2,this.sx[t],this.sy[t]),n&&y.push(t);return new r.Selection({indices:y})}draw_legend_for_index(t,{x0:s,y0:i,x1:e,y1:h},a){const r=a+1,n=new Array(r);n[a]=(s+e)/2;const _=new Array(r);_[a]=(i+h)/2;const l=this.sw[a]/this.sh[a],d=.8*Math.min(Math.abs(e-s),Math.abs(h-i)),o=new Array(r),x=new Array(r);l>1?(o[a]=d,x[a]=d/l):(o[a]=d*l,x[a]=d),this._render(t,[a],{sx:n,sy:_,sw:o,sh:x,_angle:[0]})}_bounds({x0:t,x1:s,y0:i,y1:e}){return{x0:t-this.max_w2,x1:s+this.max_w2,y0:i-this.max_h2,y1:e+this.max_h2}}}i.EllipseOvalView=n,n.__name__="EllipseOvalView";class _ extends h.CenterRotatable{constructor(t){super(t)}}i.EllipseOval=_,_.__name__="EllipseOval"},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const i=t(1),h=t(245),r=t(24),_=i.__importStar(t(18));class a extends h.BoxView{scenterxy(t){return[(this.sleft[t]+this.sright[t])/2,this.sy[t]]}_lrtb(t){return[Math.min(this._left[t],this._right[t]),Math.max(this._left[t],this._right[t]),this._y[t]+.5*this._height[t],this._y[t]-.5*this._height[t]]}_map_data(){this.sy=this.renderer.yscale.v_compute(this._y),this.sh=this.sdist(this.renderer.yscale,this._y,this._height,"center"),this.sleft=this.renderer.xscale.v_compute(this._left),this.sright=this.renderer.xscale.v_compute(this._right);const t=this.sy.length;this.stop=new r.NumberArray(t),this.sbottom=new r.NumberArray(t);for(let e=0;e<t;e++)this.stop[e]=this.sy[e]-this.sh[e]/2,this.sbottom[e]=this.sy[e]+this.sh[e]/2;this._clamp_viewport()}}s.HBarView=a,a.__name__="HBarView";class o extends h.Box{constructor(t){super(t)}static init_HBar(){this.prototype.default_view=a,this.define({left:[_.XCoordinateSpec,{value:0}],y:[_.YCoordinateSpec,{field:"y"}],height:[_.NumberSpec,{value:1}],right:[_.XCoordinateSpec,{field:"right"}]})}}s.HBar=o,o.__name__="HBar",o.init_HBar()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const s=t(28),r=t(94),n=t(100),a=t(88);class h extends r.GlyphView{get_anchor_point(t,e,i){const s=Math.min(this.sleft[e],this.sright[e]),r=Math.max(this.sright[e],this.sleft[e]),n=Math.min(this.stop[e],this.sbottom[e]),a=Math.max(this.sbottom[e],this.stop[e]);switch(t){case"top_left":return{x:s,y:n};case"top_center":return{x:(s+r)/2,y:n};case"top_right":return{x:r,y:n};case"bottom_left":return{x:s,y:a};case"bottom_center":return{x:(s+r)/2,y:a};case"bottom_right":return{x:r,y:a};case"center_left":return{x:s,y:(n+a)/2};case"center":return{x:(s+r)/2,y:(n+a)/2};case"center_right":return{x:r,y:(n+a)/2};default:return null}}_index_data(t){const{min:e,max:i}=Math,{data_size:s}=this;for(let r=0;r<s;r++){const[s,n,a,h]=this._lrtb(r);isNaN(s+n+a+h)||!isFinite(s+n+a+h)?t.add_empty():t.add(e(s,n),e(a,h),i(n,s),i(a,h))}}_render(t,e,{sleft:i,sright:s,stop:r,sbottom:n}){for(const a of e)isNaN(i[a]+r[a]+s[a]+n[a])||(t.rect(i[a],r[a],s[a]-i[a],n[a]-r[a]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(t,a),t.beginPath(),t.rect(i[a],r[a],s[a]-i[a],n[a]-r[a]),t.fill()),this.visuals.hatch.doit2(t,a,()=>{t.beginPath(),t.rect(i[a],r[a],s[a]-i[a],n[a]-r[a]),t.fill()},()=>this.renderer.request_render()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(t,a),t.beginPath(),t.rect(i[a],r[a],s[a]-i[a],n[a]-r[a]),t.stroke()))}_clamp_viewport(){const t=this.renderer.plot_view.frame.bbox.h_range,e=this.renderer.plot_view.frame.bbox.v_range,i=this.stop.length;for(let s=0;s<i;s++)this.stop[s]=Math.max(this.stop[s],e.start),this.sbottom[s]=Math.min(this.sbottom[s],e.end),this.sleft[s]=Math.max(this.sleft[s],t.start),this.sright[s]=Math.min(this.sright[s],t.end)}_hit_rect(t){return this._hit_rect_against_index(t)}_hit_point(t){const{sx:e,sy:i}=t,s=this.renderer.xscale.invert(e),r=this.renderer.yscale.invert(i),n=[...this.index.indices({x0:s,y0:r,x1:s,y1:r})];return new a.Selection({indices:n})}_hit_span(t){const{sx:e,sy:i}=t;let s;if("v"==t.direction){const t=this.renderer.yscale.invert(i),e=this.renderer.plot_view.frame.bbox.h_range,[r,n]=this.renderer.xscale.r_invert(e.start,e.end);s=[...this.index.indices({x0:r,y0:t,x1:n,y1:t})]}else{const t=this.renderer.xscale.invert(e),i=this.renderer.plot_view.frame.bbox.v_range,[r,n]=this.renderer.yscale.r_invert(i.start,i.end);s=[...this.index.indices({x0:t,y0:r,x1:t,y1:n})]}return new a.Selection({indices:s})}draw_legend_for_index(t,e,i){n.generic_area_legend(this.visuals,t,e,i)}}i.BoxView=h,h.__name__="BoxView";class o extends r.Glyph{constructor(t){super(t)}static init_Box(){this.mixins([s.LineVector,s.FillVector,s.HatchVector])}}i.Box=o,o.__name__="Box",o.init_Box()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),r=e(94),n=i.__importStar(e(101)),a=i.__importStar(e(18)),o=e(28),c=e(24),_=e(37),h=e(100),l=e(88);class d extends r.GlyphView{scenterxy(e){return[this.sx[e],this.sy[e]]}_set_data(){const e=this._q.length,{orientation:t,size:s,aspect_scale:i}=this.model;this._x=new c.NumberArray(e),this._y=new c.NumberArray(e);const r=Math.sqrt(3);if("pointytop"==t)for(let t=0;t<e;t++)this._x[t]=s*r*(this._q[t]+this._r[t]/2)/i,this._y[t]=3*-s/2*this._r[t];else for(let t=0;t<e;t++)this._x[t]=3*s/2*this._q[t],this._y[t]=-s*r*(this._r[t]+this._q[t]/2)*i}_project_data(){_.inplace.project_xy(this._x,this._y)}_index_data(e){let t=this.model.size,s=Math.sqrt(3)*t/2;"flattop"==this.model.orientation?([s,t]=[t,s],t*=this.model.aspect_scale):s/=this.model.aspect_scale;const{data_size:i}=this;for(let r=0;r<i;r++){const i=this._x[r],n=this._y[r];isNaN(i+n)||!isFinite(i+n)?e.add_empty():e.add(i-s,n-t,i+s,n+t)}}map_data(){[this.sx,this.sy]=this.renderer.coordinates.map_to_screen(this._x,this._y),[this.svx,this.svy]=this._get_unscaled_vertices()}_get_unscaled_vertices(){const e=this.model.size,t=this.model.aspect_scale;if("pointytop"==this.model.orientation){const s=this.renderer.yscale,i=this.renderer.xscale,r=Math.abs(s.compute(0)-s.compute(e)),n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))/t,a=r/2;return[[0,-n,-n,0,n,n],[r,a,-a,-r,-a,a]]}{const s=this.renderer.xscale,i=this.renderer.yscale,r=Math.abs(s.compute(0)-s.compute(e)),n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))*t,a=r/2;return[[r,a,-a,-r,-a,a],[0,-n,-n,0,n,n]]}}_render(e,t,{sx:s,sy:i,svx:r,svy:n,_scale:a}){for(const o of t)if(!isNaN(s[o]+i[o]+a[o])){e.translate(s[o],i[o]),e.beginPath();for(let t=0;t<6;t++)e.lineTo(r[t]*a[o],n[t]*a[o]);e.closePath(),e.translate(-s[o],-i[o]),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,o),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,o),e.stroke())}}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),r=this.renderer.yscale.invert(s),a=this.index.indices({x0:i,y0:r,x1:i,y1:r}),o=[];for(const e of a)n.point_in_poly(t-this.sx[e],s-this.sy[e],this.svx,this.svy)&&o.push(e);return new l.Selection({indices:o})}_hit_span(e){const{sx:t,sy:s}=e;let i;if("v"==e.direction){const e=this.renderer.yscale.invert(s),t=this.renderer.plot_view.frame.bbox.h_range,[r,n]=this.renderer.xscale.r_invert(t.start,t.end);i=[...this.index.indices({x0:r,y0:e,x1:n,y1:e})]}else{const e=this.renderer.xscale.invert(t),s=this.renderer.plot_view.frame.bbox.v_range,[r,n]=this.renderer.yscale.r_invert(s.start,s.end);i=[...this.index.indices({x0:e,y0:r,x1:e,y1:n})]}return new l.Selection({indices:i})}_hit_rect(e){const{sx0:t,sx1:s,sy0:i,sy1:r}=e,[n,a]=this.renderer.xscale.r_invert(t,s),[o,c]=this.renderer.yscale.r_invert(i,r),_=[...this.index.indices({x0:n,x1:a,y0:o,y1:c})];return new l.Selection({indices:_})}draw_legend_for_index(e,t,s){h.generic_area_legend(this.visuals,e,t,s)}}s.HexTileView=d,d.__name__="HexTileView";class x extends r.Glyph{constructor(e){super(e)}static init_HexTile(){this.prototype.default_view=d,this.mixins([o.LineVector,o.FillVector]),this.define({r:[a.NumberSpec],q:[a.NumberSpec],size:[a.Number,1],aspect_scale:[a.Number,1],scale:[a.NumberSpec,1],orientation:[a.HexTileOrientation,"pointytop"]}),this.override({line_color:null})}}s.HexTile=x,x.__name__="HexTile",x.init_HexTile()},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const _=e(1),i=e(248),n=e(141),s=_.__importStar(e(18));class r extends i.ImageBaseView{connect_signals(){super.connect_signals(),this.connect(this.model.color_mapper.change,()=>this._update_image())}_update_image(){null!=this.image_data&&(this._set_data(null),this.renderer.plot_view.request_render())}_flat_img_to_buf8(e){return this.model.color_mapper.rgba_mapper.v_compute(e)}}a.ImageView=r,r.__name__="ImageView";class o extends i.ImageBase{constructor(e){super(e)}static init_Image(){this.prototype.default_view=r,this.define({color_mapper:[s.Instance,()=>new n.LinearColorMapper({palette:["#000000","#252525","#525252","#737373","#969696","#bdbdbd","#d9d9d9","#f0f0f0","#ffffff"]})]})}}a.Image=o,o.__name__="Image",o.init_Image()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),a=e(93),h=e(24),_=i.__importStar(e(18)),n=e(88),r=e(9),d=e(30),l=e(11);class g extends a.XYGlyphView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.global_alpha.change,()=>this.renderer.request_render())}_render(e,t,{image_data:s,sx:i,sy:a,sw:h,sh:_}){const n=e.getImageSmoothingEnabled();e.setImageSmoothingEnabled(!1),e.globalAlpha=this.model.global_alpha;for(const n of t){if(null==s[n]||isNaN(i[n]+a[n]+h[n]+_[n]))continue;const t=a[n];e.translate(0,t),e.scale(1,-1),e.translate(0,-t),e.drawImage(s[n],0|i[n],0|a[n],h[n],_[n]),e.translate(0,t),e.scale(1,-1),e.translate(0,-t)}e.setImageSmoothingEnabled(n)}_set_data(e){this._set_width_heigh_data();for(let t=0,s=this._image.length;t<s;t++){if(null!=e&&e.indexOf(t)<0)continue;const s=this._image[t];let i;d.is_NDArray(s)?(l.assert(2==s.dimension,"expected a 2D array"),i=s,this._height[t]=s.shape[0],this._width[t]=s.shape[1]):(i=r.concat(s),this._height[t]=s.length,this._width[t]=s[0].length);const a=this._flat_img_to_buf8(i);this._set_image_data_from_buffer(t,a)}}_index_data(e){const{data_size:t}=this;for(let s=0;s<t;s++){const[t,i,a,h]=this._lrtb(s);isNaN(t+i+a+h)||!isFinite(t+i+a+h)?e.add_empty():e.add(t,h,i,a)}}_lrtb(e){const t=this.renderer.xscale.source_range,s=this._x[e],i=t.is_reversed?s-this._dw[e]:s+this._dw[e],a=this.renderer.yscale.source_range,h=this._y[e],_=a.is_reversed?h-this._dh[e]:h+this._dh[e],[n,r]=s<i?[s,i]:[i,s],[d,l]=h<_?[h,_]:[_,h];return[n,r,l,d]}_set_width_heigh_data(){null!=this.image_data&&this.image_data.length==this._image.length||(this.image_data=new Array(this._image.length)),null!=this._width&&this._width.length==this._image.length||(this._width=new h.NumberArray(this._image.length)),null!=this._height&&this._height.length==this._image.length||(this._height=new h.NumberArray(this._image.length))}_get_or_create_canvas(e){const t=this.image_data[e];if(null!=t&&t.width==this._width[e]&&t.height==this._height[e])return t;{const t=document.createElement("canvas");return t.width=this._width[e],t.height=this._height[e],t}}_set_image_data_from_buffer(e,t){const s=this._get_or_create_canvas(e),i=s.getContext("2d"),a=i.getImageData(0,0,this._width[e],this._height[e]);a.data.set(t),i.putImageData(a,0,0),this.image_data[e]=s}_map_data(){switch(this.model.properties.dw.units){case"data":this.sw=this.sdist(this.renderer.xscale,this._x,this._dw,"edge",this.model.dilate);break;case"screen":this.sw=this._dw}switch(this.model.properties.dh.units){case"data":this.sh=this.sdist(this.renderer.yscale,this._y,this._dh,"edge",this.model.dilate);break;case"screen":this.sh=this._dh}}_image_index(e,t,s){const[i,a,h,_]=this._lrtb(e),n=this._width[e],r=this._height[e],d=(a-i)/n,l=(h-_)/r;let g=Math.floor((t-i)/d),o=Math.floor((s-_)/l);return this.renderer.xscale.source_range.is_reversed&&(g=n-g-1),this.renderer.yscale.source_range.is_reversed&&(o=r-o-1),{index:e,dim1:g,dim2:o,flat_index:o*n+g}}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),a=this.renderer.yscale.invert(s),h=this.index.indices({x0:i,x1:i,y0:a,y1:a}),_=new n.Selection;for(const e of h)t!=1/0&&s!=1/0&&_.image_indices.push(this._image_index(e,i,a));return _}}s.ImageBaseView=g,g.__name__="ImageBaseView";class o extends a.XYGlyph{constructor(e){super(e)}static init_ImageBase(){this.define({image:[_.NDArraySpec],dw:[_.DistanceSpec],dh:[_.DistanceSpec],dilate:[_.Boolean,!1],global_alpha:[_.Number,1]})}}s.ImageBase=o,o.__name__="ImageBase",o.init_ImageBase()},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const _=e(248),i=e(8);class n extends _.ImageBaseView{_flat_img_to_buf8(e){let t;return t=i.isArray(e)?new Uint32Array(e):e,new Uint8Array(t.buffer)}}a.ImageRGBAView=n,n.__name__="ImageRGBAView";class r extends _.ImageBase{constructor(e){super(e)}static init_ImageRGBA(){this.prototype.default_view=n}}a.ImageRGBA=r,r.__name__="ImageRGBA",r.init_ImageRGBA()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const r=e(1),i=e(93),a=e(24),n=r.__importStar(e(18)),h=e(12),o=e(251);class _ extends i.XYGlyphView{constructor(){super(...arguments),this._images_rendered=!1}initialize(){super.initialize(),this.connect(this.model.properties.global_alpha.change,()=>this.renderer.request_render())}_index_data(e){const{data_size:t}=this;for(let s=0;s<t;s++)e.add_empty()}_set_data(){null!=this.image&&this.image.length==this._url.length||(this.image=h.map(this._url,()=>null));const{retry_attempts:e,retry_timeout:t}=this.model;for(let s=0,r=this._url.length;s<r;s++){const r=this._url[s];null!=r&&""!=r&&new o.ImageLoader(r,{loaded:e=>{this.image[s]=e,this.renderer.request_render()},attempts:e+1,timeout:t})}const s="data"==this.model.properties.w.units,r="data"==this.model.properties.h.units,i=this._x.length,n=new a.NumberArray(s?2*i:i),_=new a.NumberArray(r?2*i:i),{anchor:c}=this.model;function l(e,t){switch(c){case"top_left":case"bottom_left":case"center_left":return[e,e+t];case"top_center":case"bottom_center":case"center":return[e-t/2,e+t/2];case"top_right":case"bottom_right":case"center_right":return[e-t,e]}}function d(e,t){switch(c){case"top_left":case"top_center":case"top_right":return[e,e-t];case"bottom_left":case"bottom_center":case"bottom_right":return[e+t,e];case"center_left":case"center":case"center_right":return[e+t/2,e-t/2]}}if(s)for(let e=0;e<i;e++)[n[e],n[i+e]]=l(this._x[e],this._w[e]);else n.set(this._x,0);if(r)for(let e=0;e<i;e++)[_[e],_[i+e]]=d(this._y[e],this._h[e]);else _.set(this._y,0);const[m,u]=h.minmax(n),[p,g]=h.minmax(_);this._bounds_rect={x0:m,x1:u,y0:p,y1:g}}has_finished(){return super.has_finished()&&1==this._images_rendered}_map_data(){const e=null!=this.model.w?this._w:h.map(this._x,()=>NaN),t=null!=this.model.h?this._h:h.map(this._x,()=>NaN);switch(this.model.properties.w.units){case"data":this.sw=this.sdist(this.renderer.xscale,this._x,e,"edge",this.model.dilate);break;case"screen":this.sw=e}switch(this.model.properties.h.units){case"data":this.sh=this.sdist(this.renderer.yscale,this._y,t,"edge",this.model.dilate);break;case"screen":this.sh=t}}_render(e,t,{image:s,sx:r,sy:i,sw:a,sh:n,_angle:h}){const{frame:o}=this.renderer.plot_view;e.rect(o.bbox.left+1,o.bbox.top+1,o.bbox.width-2,o.bbox.height-2),e.clip();let _=!0;for(const o of t){if(isNaN(r[o]+i[o]+h[o]))continue;const t=s[o];null!=t?this._render_image(e,o,t,r,i,a,n,h):_=!1}_&&!this._images_rendered&&(this._images_rendered=!0,this.notify_finished())}_final_sx_sy(e,t,s,r,i){switch(e){case"top_left":return[t,s];case"top_center":return[t-r/2,s];case"top_right":return[t-r,s];case"center_right":return[t-r,s-i/2];case"bottom_right":return[t-r,s-i];case"bottom_center":return[t-r/2,s-i];case"bottom_left":return[t,s-i];case"center_left":return[t,s-i/2];case"center":return[t-r/2,s-i/2]}}_render_image(e,t,s,r,i,a,n,h){isNaN(a[t])&&(a[t]=s.width),isNaN(n[t])&&(n[t]=s.height);const{anchor:o}=this.model,[_,c]=this._final_sx_sy(o,r[t],i[t],a[t],n[t]);e.save(),e.globalAlpha=this.model.global_alpha;const l=a[t]/2,d=n[t]/2;h[t]?(e.translate(_,c),e.translate(l,d),e.rotate(h[t]),e.translate(-l,-d),e.drawImage(s,0,0,a[t],n[t]),e.translate(l,d),e.rotate(-h[t]),e.translate(-l,-d),e.translate(-_,-c)):e.drawImage(s,_,c,a[t],n[t]),e.restore()}bounds(){return this._bounds_rect}}s.ImageURLView=_,_.__name__="ImageURLView";class c extends i.XYGlyph{constructor(e){super(e)}static init_ImageURL(){this.prototype.default_view=_,this.define({url:[n.StringSpec],anchor:[n.Anchor,"top_left"],global_alpha:[n.Number,1],angle:[n.AngleSpec,0],w:[n.DistanceSpec],h:[n.DistanceSpec],dilate:[n.Boolean,!1],retry_attempts:[n.Number,0],retry_timeout:[n.Number,0]})}}s.ImageURL=c,c.__name__="ImageURL",c.init_ImageURL()},
function _(i,e,t){Object.defineProperty(t,"__esModule",{value:!0});const s=i(19);class a{constructor(i,e={}){this._image=new Image,this._finished=!1;const{attempts:t=1,timeout:a=1}=e;this.promise=new Promise((o,n)=>{this._image.crossOrigin="anonymous";let r=0;this._image.onerror=()=>{if(++r==t){const a=`unable to load ${i} image after ${t} attempts`;if(s.logger.warn(a),null==this._image.crossOrigin)return void(null!=e.failed&&e.failed());s.logger.warn(`attempting to load ${i} without a cross origin policy`),this._image.crossOrigin=null,r=0}setTimeout(()=>this._image.src=i,a)},this._image.onload=()=>{this._finished=!0,null!=e.loaded&&e.loaded(this._image),o(this._image)},this._image.src=i})}get finished(){return this._finished}get image(){return this._image}}t.ImageLoader=a,a.__name__="ImageLoader"},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(1),n=e(37),o=e(28),l=s.__importStar(e(101)),r=s.__importStar(e(18)),_=e(12),c=e(13),a=e(94),h=e(100),d=e(88);class y extends a.GlyphView{_project_data(){n.inplace.project_xy(this._xs.array,this._ys.array)}_index_data(e){const{data_size:t}=this;for(let i=0;i<t;i++){const t=this._xs.get(i);if(0==t.length){e.add_empty();continue}const s=this._ys.get(i);if(0==s.length){e.add_empty();continue}const[n,o]=_.minmax(t),[l,r]=_.minmax(s);e.add(n,l,o,r)}}_render(e,t,{sxs:i,sys:s}){for(const n of t){const t=i.get(n),o=s.get(n);this.visuals.line.set_vectorize(e,n);for(let i=0,s=t.length;i<s;i++)0!=i?isNaN(t[i])||isNaN(o[i])?(e.stroke(),e.beginPath()):e.lineTo(t[i],o[i]):(e.beginPath(),e.moveTo(t[i],o[i]));e.stroke()}}_hit_point(e){const t={x:e.sx,y:e.sy};let i=9999;const s=new Map;for(let e=0,n=this.sxs.length;e<n;e++){const n=Math.max(2,this.visuals.line.cache_select("line_width",e)/2),o=this.sxs.get(e),r=this.sys.get(e);let _=null;for(let e=0,s=o.length-1;e<s;e++){const s={x:o[e],y:r[e]},c={x:o[e+1],y:r[e+1]},a=l.dist_to_segment(t,s,c);a<n&&a<i&&(i=a,_=[e])}null!=_&&s.set(e,_)}return new d.Selection({indices:[...s.keys()],multiline_indices:c.to_object(s)})}_hit_span(e){const{sx:t,sy:i}=e;let s,n;"v"==e.direction?(s=this.renderer.yscale.invert(i),n=this._ys):(s=this.renderer.xscale.invert(t),n=this._xs);const o=new Map;for(let e=0,t=n.length;e<t;e++){const t=n.get(e),i=[];for(let e=0,n=t.length-1;e<n;e++)t[e]<=s&&s<=t[e+1]&&i.push(e);i.length>0&&o.set(e,i)}return new d.Selection({indices:[...o.keys()],multiline_indices:c.to_object(o)})}get_interpolation_hit(e,t,i){const s=this._xs.get(e),n=this._ys.get(e),o=s[t],l=n[t],r=s[t+1],_=n[t+1];return h.line_interpolation(this.renderer,i,o,l,r,_)}draw_legend_for_index(e,t,i){h.generic_line_legend(this.visuals,e,t,i)}scenterxy(){throw new Error(this+".scenterxy() is not implemented")}}i.MultiLineView=y,y.__name__="MultiLineView";class x extends a.Glyph{constructor(e){super(e)}static init_MultiLine(){this.prototype.default_view=y,this.define({xs:[r.XCoordinateSeqSpec,{field:"xs"}],ys:[r.YCoordinateSeqSpec,{field:"ys"}]}),this.mixins(o.LineVector)}}i.MultiLine=x,x.__name__="MultiLine",x.init_MultiLine()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),n=e(95),o=e(94),r=e(100),l=e(12),h=e(12),_=e(28),a=i.__importStar(e(101)),d=i.__importStar(e(18)),c=e(88),x=e(11);class y extends o.GlyphView{_project_data(){}_index_data(e){const{min:t,max:s}=Math,{data_size:i}=this;for(let n=0;n<i;n++){const i=this._xs[n],o=this._ys[n];if(0==i.length||0==o.length){e.add_empty();continue}let r=1/0,h=-1/0,_=1/0,a=-1/0;for(let e=0,n=i.length;e<n;e++){const n=i[e][0],d=o[e][0];if(0!=n.length&&0!=d.length){const[e,i]=l.minmax(n),[o,c]=l.minmax(d);r=t(r,e),h=s(h,i),_=t(_,o),a=s(a,c)}}isFinite(r+h+_+a)?e.add(r,_,h,a):e.add_empty()}this._hole_index=this._index_hole_data()}_index_hole_data(){const{min:e,max:t}=Math,{data_size:s}=this,i=new n.SpatialIndex(s);for(let n=0;n<s;n++){const s=this._xs[n],o=this._ys[n];if(0==s.length||0==o.length){i.add_empty();continue}let r=1/0,h=-1/0,_=1/0,a=-1/0;for(let i=0,n=s.length;i<n;i++){const n=s[i],d=o[i];if(n.length>1&&d.length>1)for(let s=1,i=n.length;s<i;s++){const[i,o]=l.minmax(n[s]),[c,x]=l.minmax(d[s]);r=e(r,i),h=t(h,o),_=e(_,c),a=t(a,x)}}isFinite(r+h+_+a)?i.add(r,_,h,a):i.add_empty()}return i.finish(),i}_mask_data(){const e=this.renderer.plot_view.frame.x_range,[t,s]=[e.min,e.max],i=this.renderer.plot_view.frame.y_range,[n,o]=[i.min,i.max];return this.index.indices({x0:t,x1:s,y0:n,y1:o})}_inner_loop(e,t,s){e.beginPath();for(let i=0,n=t.length;i<n;i++)for(let n=0,o=t[i].length;n<o;n++){const o=t[i][n],r=s[i][n];for(let t=0,s=o.length;t<s;t++)0!=t?e.lineTo(o[t],r[t]):e.moveTo(o[t],r[t]);e.closePath()}}_render(e,t,{sxs:s,sys:i}){if(this.visuals.fill.doit||this.visuals.line.doit)for(const n of t){const[t,o]=[s[n],i[n]];this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,n),this._inner_loop(e,t,o),e.fill("evenodd")),this.visuals.hatch.doit2(e,n,()=>{this._inner_loop(e,t,o),e.fill("evenodd")},()=>this.renderer.request_render()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,n),this._inner_loop(e,t,o),e.stroke())}}_hit_rect(e){const{sx0:t,sx1:s,sy0:i,sy1:n}=e,o=[t,s,s,t],r=[i,i,n,n],[l,h]=this.renderer.xscale.r_invert(t,s),[_,d]=this.renderer.yscale.r_invert(i,n),x=this.index.indices({x0:l,x1:h,y0:_,y1:d}),y=[];for(const e of x){const t=this.sxs[e],s=this.sys[e];let i=!0;for(let e=0,n=t.length;e<n;e++){for(let n=0,l=t[e][0].length;n<l;n++){const l=t[e][0][n],h=s[e][0][n];if(!a.point_in_poly(l,h,o,r)){i=!1;break}}if(!i)break}i&&y.push(e)}return new c.Selection({indices:y})}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),n=this.renderer.yscale.invert(s),o=this.index.indices({x0:i,y0:n,x1:i,y1:n}),r=this._hole_index.indices({x0:i,y0:n,x1:i,y1:n}),l=[];for(const e of o){const i=this.sxs[e],n=this.sys[e];for(let o=0,h=i.length;o<h;o++){const h=i[o].length;if(a.point_in_poly(t,s,i[o][0],n[o][0]))if(1==h)l.push(e);else if(r.get(e)){if(h>1){let r=!1;for(let e=1;e<h;e++){const l=i[o][e],h=n[o][e];if(a.point_in_poly(t,s,l,h)){r=!0;break}}r||l.push(e)}}else l.push(e)}}return new c.Selection({indices:l})}_get_snap_coord(e){return h.sum(e)/e.length}scenterxy(e,t,s){if(1==this.sxs[e].length){return[this._get_snap_coord(this.sxs[e][0][0]),this._get_snap_coord(this.sys[e][0][0])]}{const i=this.sxs[e],n=this.sys[e];for(let e=0,o=i.length;e<o;e++)if(a.point_in_poly(t,s,i[e][0],n[e][0])){return[this._get_snap_coord(i[e][0]),this._get_snap_coord(n[e][0])]}}x.unreachable()}map_data(){const e=this._xs.length;this.sxs=new Array(e),this.sys=new Array(e);for(let t=0;t<e;t++){const e=this._xs[t].length;this.sxs[t]=new Array(e),this.sys[t]=new Array(e);for(let s=0;s<e;s++){const e=this._xs[t][s].length;this.sxs[t][s]=new Array(e),this.sys[t][s]=new Array(e);for(let i=0;i<e;i++){const[e,n]=this.renderer.coordinates.map_to_screen(this._xs[t][s][i],this._ys[t][s][i]);this.sxs[t][s][i]=e,this.sys[t][s][i]=n}}}}draw_legend_for_index(e,t,s){r.generic_area_legend(this.visuals,e,t,s)}}s.MultiPolygonsView=y,y.__name__="MultiPolygonsView";class f extends o.Glyph{constructor(e){super(e)}static init_MultiPolygons(){this.prototype.default_view=y,this.define({xs:[d.XCoordinateSeqSeqSeqSpec,{field:"xs"}],ys:[d.YCoordinateSeqSeqSeqSpec,{field:"ys"}]}),this.mixins([_.LineVector,_.FillVector,_.HatchVector])}}s.MultiPolygons=f,f.__name__="MultiPolygons",f.init_MultiPolygons()},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const l=e(243);class s extends l.EllipseOvalView{_map_data(){super._map_data();const{sw:e}=this,t=e.length;for(let a=0;a<t;a++)e[a]*=.75}}a.OvalView=s,s.__name__="OvalView";class _ extends l.EllipseOval{constructor(e){super(e)}static init_Oval(){this.prototype.default_view=s}}a.Oval=_,_.__name__="Oval",_.init_Oval()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),n=e(94),r=e(100),o=e(12),a=e(28),_=i.__importStar(e(101)),c=i.__importStar(e(18)),l=e(88),h=e(11),d=e(37);class y extends n.GlyphView{_project_data(){d.inplace.project_xy(this._xs.array,this._ys.array)}_index_data(e){const{data_size:t}=this;for(let s=0;s<t;s++){const t=this._xs.get(s),i=this._ys.get(s);if(0==t.length)e.add_empty();else{const[s,n]=o.minmax(t),[r,a]=o.minmax(i);e.add(s,r,n,a)}}}_mask_data(){const e=this.renderer.plot_view.frame.x_range,[t,s]=[e.min,e.max],i=this.renderer.plot_view.frame.y_range,[n,r]=[i.min,i.max];return this.index.indices({x0:t,x1:s,y0:n,y1:r})}_inner_loop(e,t,s,i){for(let n=0,r=t.length;n<r;n++)0!=n?isNaN(t[n]+s[n])?(e.closePath(),i.apply(e),e.beginPath()):e.lineTo(t[n],s[n]):(e.beginPath(),e.moveTo(t[n],s[n]));e.closePath(),i.call(e)}_render(e,t,{sxs:s,sys:i}){for(const n of t){const t=s.get(n),r=i.get(n);this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,n),this._inner_loop(e,t,r,e.fill)),this.visuals.hatch.doit2(e,n,()=>this._inner_loop(e,t,r,e.fill),()=>this.renderer.request_render()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,n),this._inner_loop(e,t,r,e.stroke))}}_hit_rect(e){const{sx0:t,sx1:s,sy0:i,sy1:n}=e,r=[t,s,s,t],o=[i,i,n,n],[a,c]=this.renderer.xscale.r_invert(t,s),[h,d]=this.renderer.yscale.r_invert(i,n),y=this.index.indices({x0:a,x1:c,y0:h,y1:d}),p=[];for(const e of y){const t=this.sxs.get(e),s=this.sys.get(e);let i=!0;for(let e=0,n=t.length;e<n;e++){const n=t[e],a=s[e];if(!_.point_in_poly(n,a,r,o)){i=!1;break}}i&&p.push(e)}return new l.Selection({indices:p})}_hit_point(e){const{sx:t,sy:s}=e,i=this.renderer.xscale.invert(t),n=this.renderer.yscale.invert(s),r=this.index.indices({x0:i,y0:n,x1:i,y1:n}),o=[];for(const e of r){const i=this.sxs.get(e),n=this.sys.get(e),r=i.length;for(let a=0,c=0;;c++){if(isNaN(i[c])||c==r){const r=i.subarray(a,c),l=n.subarray(a,c);if(_.point_in_poly(t,s,r,l)){o.push(e);break}a=c+1}if(c==r)break}}return new l.Selection({indices:o})}_get_snap_coord(e){return o.sum(e)/e.length}scenterxy(e,t,s){const i=this.sxs.get(e),n=this.sys.get(e),r=i.length;let o=!1;for(let e=0,a=0;;a++){const c=isNaN(i[a]);if(o=o||c,a==r&&!o){return[this._get_snap_coord(i),this._get_snap_coord(n)]}if(c||a==r){const r=i.subarray(e,a),o=n.subarray(e,a);if(_.point_in_poly(t,s,r,o)){return[this._get_snap_coord(r),this._get_snap_coord(o)]}e=a+1}if(a==r)break}h.unreachable()}draw_legend_for_index(e,t,s){r.generic_area_legend(this.visuals,e,t,s)}}s.PatchesView=y,y.__name__="PatchesView";class p extends n.Glyph{constructor(e){super(e)}static init_Patches(){this.prototype.default_view=y,this.define({xs:[c.XCoordinateSeqSpec,{field:"xs"}],ys:[c.YCoordinateSeqSpec,{field:"ys"}]}),this.mixins([a.LineVector,a.FillVector,a.HatchVector])}}s.Patches=p,p.__name__="Patches",p.init_Patches()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const o=t(1),s=t(245),r=o.__importStar(t(18));class _ extends s.BoxView{scenterxy(t){return[(this.sleft[t]+this.sright[t])/2,(this.stop[t]+this.sbottom[t])/2]}_lrtb(t){return[this._left[t],this._right[t],this._top[t],this._bottom[t]]}}i.QuadView=_,_.__name__="QuadView";class d extends s.Box{constructor(t){super(t)}static init_Quad(){this.prototype.default_view=_,this.define({right:[r.XCoordinateSpec,{field:"right"}],bottom:[r.YCoordinateSpec,{field:"bottom"}],left:[r.XCoordinateSpec,{field:"left"}],top:[r.YCoordinateSpec,{field:"top"}]})}}i.Quad=d,d.__name__="Quad",d.init_Quad()},
function _(i,e,t){Object.defineProperty(t,"__esModule",{value:!0});const s=i(1),a=i(28),_=i(37),c=i(94),n=i(100),r=s.__importStar(i(18));function o(i,e,t){if(e==(i+t)/2)return[i,t];{const s=(i-e)/(i-2*e+t),a=i*(1-s)**2+2*e*(1-s)*s+t*s**2;return[Math.min(i,t,a),Math.max(i,t,a)]}}class d extends c.GlyphView{_project_data(){_.inplace.project_xy(this._x0,this._y0),_.inplace.project_xy(this._x1,this._y1)}_index_data(i){const{data_size:e}=this;for(let t=0;t<e;t++)if(isNaN(this._x0[t]+this._x1[t]+this._y0[t]+this._y1[t]+this._cx[t]+this._cy[t]))i.add_empty();else{const[e,s]=o(this._x0[t],this._cx[t],this._x1[t]),[a,_]=o(this._y0[t],this._cy[t],this._y1[t]);i.add(e,a,s,_)}}_render(i,e,{sx0:t,sy0:s,sx1:a,sy1:_,scx:c,scy:n}){if(this.visuals.line.doit)for(const r of e)isNaN(t[r]+s[r]+a[r]+_[r]+c[r]+n[r])||(i.beginPath(),i.moveTo(t[r],s[r]),i.quadraticCurveTo(c[r],n[r],a[r],_[r]),this.visuals.line.set_vectorize(i,r),i.stroke())}draw_legend_for_index(i,e,t){n.generic_line_legend(this.visuals,i,e,t)}scenterxy(){throw new Error(this+".scenterxy() is not implemented")}}t.QuadraticView=d,d.__name__="QuadraticView";class h extends c.Glyph{constructor(i){super(i)}static init_Quadratic(){this.prototype.default_view=d,this.define({x0:[r.XCoordinateSpec,{field:"x0"}],y0:[r.YCoordinateSpec,{field:"y0"}],x1:[r.XCoordinateSpec,{field:"x1"}],y1:[r.YCoordinateSpec,{field:"y1"}],cx:[r.XCoordinateSpec,{field:"cx"}],cy:[r.YCoordinateSpec,{field:"cy"}]}),this.mixins(a.LineVector)}}t.Quadratic=h,h.__name__="Quadratic",h.init_Quadratic()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(1),n=e(93),a=e(100),r=e(28),l=s.__importStar(e(18));class _ extends n.XYGlyphView{_map_data(){"data"==this.model.properties.length.units?this.slength=this.sdist(this.renderer.xscale,this._x,this._length):this.slength=this._length}_render(e,t,{sx:i,sy:s,slength:n,_angle:a}){if(this.visuals.line.doit){const r=2*(this.renderer.plot_view.frame.bbox.width+this.renderer.plot_view.frame.bbox.height);for(let e=0,t=n.length;e<t;e++)0==n[e]&&(n[e]=r);for(const r of t)isNaN(i[r]+s[r]+a[r]+n[r])||(e.translate(i[r],s[r]),e.rotate(a[r]),e.beginPath(),e.moveTo(0,0),e.lineTo(n[r],0),this.visuals.line.set_vectorize(e,r),e.stroke(),e.rotate(-a[r]),e.translate(-i[r],-s[r]))}}draw_legend_for_index(e,t,i){a.generic_line_legend(this.visuals,e,t,i)}}i.RayView=_,_.__name__="RayView";class h extends n.XYGlyph{constructor(e){super(e)}static init_Ray(){this.prototype.default_view=_,this.mixins(r.LineVector),this.define({length:[l.DistanceSpec],angle:[l.AngleSpec]})}}i.Ray=h,h.__name__="Ray",h.init_Ray()},
function _(t,s,e){Object.defineProperty(e,"__esModule",{value:!0});const i=t(1),h=t(241),r=t(100),a=t(24),n=i.__importStar(t(18)),_=t(12),o=t(88);class l extends h.CenterRotatableView{_set_data(){this.max_w2=0,"data"==this.model.properties.width.units&&(this.max_w2=this.max_width/2),this.max_h2=0,"data"==this.model.properties.height.units&&(this.max_h2=this.max_height/2)}_map_data(){if("data"==this.model.properties.width.units)[this.sw,this.sx0]=this._map_dist_corner_for_data_side_length(this._x,this._width,this.renderer.xscale);else{this.sw=this._width;const t=this.sx.length;this.sx0=new a.NumberArray(t);for(let s=0;s<t;s++)this.sx0[s]=this.sx[s]-this.sw[s]/2}if("data"==this.model.properties.height.units)[this.sh,this.sy1]=this._map_dist_corner_for_data_side_length(this._y,this._height,this.renderer.yscale);else{this.sh=this._height;const t=this.sy.length;this.sy1=new a.NumberArray(t);for(let s=0;s<t;s++)this.sy1[s]=this.sy[s]-this.sh[s]/2}const t=this.sw.length;this.ssemi_diag=new a.NumberArray(t);for(let s=0;s<t;s++)this.ssemi_diag[s]=Math.sqrt(this.sw[s]/2*this.sw[s]/2+this.sh[s]/2*this.sh[s]/2)}_render(t,s,{sx:e,sy:i,sx0:h,sy1:r,sw:a,sh:n,_angle:_}){if(this.visuals.fill.doit)for(const o of s)isNaN(e[o]+i[o]+h[o]+r[o]+a[o]+n[o]+_[o])||(this.visuals.fill.set_vectorize(t,o),_[o]?(t.translate(e[o],i[o]),t.rotate(_[o]),t.fillRect(-a[o]/2,-n[o]/2,a[o],n[o]),t.rotate(-_[o]),t.translate(-e[o],-i[o])):t.fillRect(h[o],r[o],a[o],n[o]));if(this.visuals.line.doit){t.beginPath();for(const o of s)isNaN(e[o]+i[o]+h[o]+r[o]+a[o]+n[o]+_[o])||0!=a[o]&&0!=n[o]&&(_[o]?(t.translate(e[o],i[o]),t.rotate(_[o]),t.rect(-a[o]/2,-n[o]/2,a[o],n[o]),t.rotate(-_[o]),t.translate(-e[o],-i[o])):t.rect(h[o],r[o],a[o],n[o]),this.visuals.line.set_vectorize(t,o),t.stroke(),t.beginPath());t.stroke()}}_hit_rect(t){return this._hit_rect_against_index(t)}_hit_point(t){let{sx:s,sy:e}=t;const i=this.renderer.xscale.invert(s),h=this.renderer.yscale.invert(e),r=this.sx0.length,n=new a.NumberArray(r);for(let t=0;t<r;t++)n[t]=this.sx0[t]+this.sw[t]/2;const l=new a.NumberArray(r);for(let t=0;t<r;t++)l[t]=this.sy1[t]+this.sh[t]/2;const d=_.max(this._ddist(0,n,this.ssemi_diag)),c=_.max(this._ddist(1,l,this.ssemi_diag)),x=i-d,m=i+d,y=h-c,w=h+c;let f,u;const g=[];for(const t of this.index.indices({x0:x,x1:m,y0:y,y1:w})){if(this._angle[t]){const i=Math.sin(-this._angle[t]),h=Math.cos(-this._angle[t]),r=h*(s-this.sx[t])-i*(e-this.sy[t])+this.sx[t],a=i*(s-this.sx[t])+h*(e-this.sy[t])+this.sy[t];s=r,e=a,f=Math.abs(this.sx[t]-s)<=this.sw[t]/2,u=Math.abs(this.sy[t]-e)<=this.sh[t]/2}else{const i=s-this.sx0[t],h=e-this.sy1[t];f=0<=i&&i<=this.sw[t],u=0<=h&&h<=this.sh[t]}f&&u&&g.push(t)}return new o.Selection({indices:g})}_map_dist_corner_for_data_side_length(t,s,e){const i=t.length,h=new a.NumberArray(i),r=new a.NumberArray(i);for(let e=0;e<i;e++)h[e]=t[e]-s[e]/2,r[e]=t[e]+s[e]/2;const n=e.v_compute(h),_=e.v_compute(r),o=this.sdist(e,h,s,"edge",this.model.dilate);let l=n;for(let t=0;t<i;t++){const s=n[t],e=_[t];if(!isNaN(s+e)&&s!=e){l=s<e?n:_;break}}return[o,l]}_ddist(t,s,e){const i=0==t?this.renderer.xscale:this.renderer.yscale,h=s,r=h.length,n=new a.NumberArray(r);for(let t=0;t<r;t++)n[t]=h[t]+e[t];const _=i.v_invert(h),o=i.v_invert(n),l=_.length,d=new a.NumberArray(l);for(let t=0;t<l;t++)d[t]=Math.abs(o[t]-_[t]);return d}draw_legend_for_index(t,s,e){r.generic_area_legend(this.visuals,t,s,e)}_bounds({x0:t,x1:s,y0:e,y1:i}){return{x0:t-this.max_w2,x1:s+this.max_w2,y0:e-this.max_h2,y1:i+this.max_h2}}}e.RectView=l,l.__name__="RectView";class d extends h.CenterRotatable{constructor(t){super(t)}static init_Rect(){this.prototype.default_view=l,this.define({dilate:[n.Boolean,!1]})}}e.Rect=d,d.__name__="Rect",d.init_Rect()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),n=i.__importStar(e(101)),r=i.__importStar(e(18)),_=e(28),h=e(37),a=e(94),o=e(100),c=e(88);class d extends a.GlyphView{_project_data(){h.inplace.project_xy(this._x0,this._y0),h.inplace.project_xy(this._x1,this._y1)}_index_data(e){const{min:t,max:s}=Math,{data_size:i}=this;for(let n=0;n<i;n++){const i=this._x0[n],r=this._x1[n],_=this._y0[n],h=this._y1[n];isNaN(i+r+_+h)?e.add_empty():e.add(t(i,r),t(_,h),s(i,r),s(_,h))}}_render(e,t,{sx0:s,sy0:i,sx1:n,sy1:r}){if(this.visuals.line.doit)for(const _ of t)isNaN(s[_]+i[_]+n[_]+r[_])||(e.beginPath(),e.moveTo(s[_],i[_]),e.lineTo(n[_],r[_]),this.visuals.line.set_vectorize(e,_),e.stroke())}_hit_point(e){const{sx:t,sy:s}=e,i={x:t,y:s},[r,_]=this.renderer.xscale.r_invert(t-2,t+2),[h,a]=this.renderer.yscale.r_invert(s-2,s+2),o=this.index.indices({x0:r,y0:h,x1:_,y1:a}),d=[];for(const e of o){const t=Math.max(2,this.visuals.line.cache_select("line_width",e)/2)**2,s={x:this.sx0[e],y:this.sy0[e]},r={x:this.sx1[e],y:this.sy1[e]};n.dist_to_segment_squared(i,s,r)<t&&d.push(e)}return new c.Selection({indices:d})}_hit_span(e){const[t,s]=this.renderer.plot_view.frame.bbox.ranges,{sx:i,sy:n}=e;let r,_,h;"v"==e.direction?(h=this.renderer.yscale.invert(n),[r,_]=[this._y0,this._y1]):(h=this.renderer.xscale.invert(i),[r,_]=[this._x0,this._x1]);const a=[],[o,d]=this.renderer.xscale.r_invert(t.start,t.end),[x,l]=this.renderer.yscale.r_invert(s.start,s.end),y=this.index.indices({x0:o,y0:x,x1:d,y1:l});for(const t of y){(r[t]<=h&&h<=_[t]||_[t]<=h&&h<=r[t])&&a.push(t);const s=1.5+this.visuals.line.cache_select("line_width",t)/2;r[t]==_[t]&&("h"==e.direction?Math.abs(this.sx0[t]-i)<=s&&a.push(t):Math.abs(this.sy0[t]-n)<=s&&a.push(t))}return new c.Selection({indices:a})}scenterxy(e){return[(this.sx0[e]+this.sx1[e])/2,(this.sy0[e]+this.sy1[e])/2]}draw_legend_for_index(e,t,s){o.generic_line_legend(this.visuals,e,t,s)}}s.SegmentView=d,d.__name__="SegmentView";class x extends a.Glyph{constructor(e){super(e)}static init_Segment(){this.prototype.default_view=d,this.define({x0:[r.XCoordinateSpec,{field:"x0"}],y0:[r.YCoordinateSpec,{field:"y0"}],x1:[r.XCoordinateSpec,{field:"x1"}],y1:[r.YCoordinateSpec,{field:"y1"}]}),this.mixins(_.LineVector)}}s.Segment=x,x.__name__="Segment",x.init_Segment()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const n=e(1),s=e(93),o=e(100),r=e(28),l=n.__importStar(e(18));class a extends s.XYGlyphView{_render(e,t,{sx:i,sy:n}){let s=!1,o=null;this.visuals.line.set_value(e);const r=t.length;if(!(r<2)){e.beginPath(),e.moveTo(i[0],n[0]);for(const r of t){let t,l,a,_;switch(this.model.mode){case"before":[t,a]=[i[r-1],n[r]],[l,_]=[i[r],n[r]];break;case"after":[t,a]=[i[r],n[r-1]],[l,_]=[i[r],n[r]];break;case"center":{const e=(i[r-1]+i[r])/2;[t,a]=[e,n[r-1]],[l,_]=[e,n[r]];break}default:throw new Error("unexpected")}if(s){if(!isFinite(i[r]+n[r])){e.stroke(),e.beginPath(),s=!1,o=r;continue}null!=o&&r-o>1&&(e.stroke(),s=!1)}s?(e.lineTo(t,a),e.lineTo(l,_)):(e.beginPath(),e.moveTo(i[r],n[r]),s=!0),o=r}e.lineTo(i[r-1],n[r-1]),e.stroke()}}draw_legend_for_index(e,t,i){o.generic_line_legend(this.visuals,e,t,i)}}i.StepView=a,a.__name__="StepView";class _ extends s.XYGlyph{constructor(e){super(e)}static init_Step(){this.prototype.default_view=a,this.mixins(r.LineVector),this.define({mode:[l.StepMode,"before"]})}}i.Step=_,_.__name__="Step",_.init_Step()},
function _(t,s,e){Object.defineProperty(e,"__esModule",{value:!0});const i=t(1),n=t(93),_=t(28),o=i.__importStar(t(101)),h=i.__importStar(t(18)),l=t(159),a=t(11),r=t(88);class c extends n.XYGlyphView{_rotate_point(t,s,e,i,n){return[(t-e)*Math.cos(n)-(s-i)*Math.sin(n)+e,(t-e)*Math.sin(n)+(s-i)*Math.cos(n)+i]}_text_bounds(t,s,e,i){return[[t,t+e,t+e,t,t],[s,s,s-i,s-i,s]]}_render(t,s,{sx:e,sy:i,_x_offset:n,_y_offset:_,_angle:o,_text:h}){this._sys=[],this._sxs=[];for(const a of s)if(this._sxs[a]=[],this._sys[a]=[],!isNaN(e[a]+i[a]+n[a]+_[a]+o[a])&&null!=h[a]&&this.visuals.text.doit){const s=""+h[a];t.save(),t.translate(e[a]+n[a],i[a]+_[a]),t.rotate(o[a]),this.visuals.text.set_vectorize(t,a);const r=this.visuals.text.cache_select("font",a),{height:c}=l.measure_font(r),x=this.visuals.text.text_line_height.value()*c;if(-1==s.indexOf("\n")){t.fillText(s,0,0);const o=e[a]+n[a],h=i[a]+_[a],l=t.measureText(s).width,[r,c]=this._text_bounds(o,h,l,x);this._sxs[a].push(r),this._sys[a].push(c)}else{const o=s.split("\n"),h=x*o.length,l=this.visuals.text.cache_select("text_baseline",a);let r;switch(l){case"top":r=0;break;case"middle":r=-h/2+x/2;break;case"bottom":r=-h+x;break;default:r=0,console.warn(`'${l}' baseline not supported with multi line text`)}for(const s of o){t.fillText(s,0,r);const o=e[a]+n[a],h=r+i[a]+_[a],l=t.measureText(s).width,[c,u]=this._text_bounds(o,h,l,x);this._sxs[a].push(c),this._sys[a].push(u),r+=x}}t.restore()}}_hit_point(t){const{sx:s,sy:e}=t,i=[];for(let t=0;t<this._sxs.length;t++){const n=this._sxs[t],_=this._sys[t],h=n.length;for(let l=0,a=h;l<a;l++){const[a,r]=this._rotate_point(s,e,n[h-1][0],_[h-1][0],-this._angle[t]);o.point_in_poly(a,r,n[l],_[l])&&i.push(t)}}return new r.Selection({indices:i})}scenterxy(t){const s=this._sxs[t],e=this._sys[t];a.assert(0!=s.length&&0!=e.length);const i=s[0][0],n=e[0][0],_=(s[0][2]+i)/2,o=(e[0][2]+n)/2,[h,l]=this._rotate_point(_,o,i,n,this._angle[t]);return[h,l]}}e.TextView=c,c.__name__="TextView";class x extends n.XYGlyph{constructor(t){super(t)}static init_Text(){this.prototype.default_view=c,this.mixins(_.TextVector),this.define({text:[h.NullStringSpec,{field:"text"}],angle:[h.AngleSpec,0],x_offset:[h.NumberSpec,0],y_offset:[h.NumberSpec,0]})}}e.Text=x,x.__name__="Text",x.init_Text()},
function _(t,s,e){Object.defineProperty(e,"__esModule",{value:!0});const i=t(1),r=t(245),h=t(24),o=i.__importStar(t(18));class _ extends r.BoxView{scenterxy(t){return[this.sx[t],(this.stop[t]+this.sbottom[t])/2]}_lrtb(t){return[this._x[t]-this._width[t]/2,this._x[t]+this._width[t]/2,Math.max(this._top[t],this._bottom[t]),Math.min(this._top[t],this._bottom[t])]}_map_data(){this.sx=this.renderer.xscale.v_compute(this._x),this.sw=this.sdist(this.renderer.xscale,this._x,this._width,"center"),this.stop=this.renderer.yscale.v_compute(this._top),this.sbottom=this.renderer.yscale.v_compute(this._bottom);const t=this.sx.length;this.sleft=new h.NumberArray(t),this.sright=new h.NumberArray(t);for(let s=0;s<t;s++)this.sleft[s]=this.sx[s]-this.sw[s]/2,this.sright[s]=this.sx[s]+this.sw[s]/2;this._clamp_viewport()}}e.VBarView=_,_.__name__="VBarView";class a extends r.Box{constructor(t){super(t)}static init_VBar(){this.prototype.default_view=_,this.define({x:[o.XCoordinateSpec,{field:"x"}],bottom:[o.YCoordinateSpec,{value:0}],width:[o.NumberSpec,{value:1}],top:[o.YCoordinateSpec,{field:"top"}]})}}e.VBar=a,a.__name__="VBar",a.init_VBar()},
function _(e,s,t){Object.defineProperty(t,"__esModule",{value:!0});const i=e(1),r=e(93),n=e(100),a=e(28),d=i.__importStar(e(18)),l=e(10),o=e(88);class _ extends r.XYGlyphView{_map_data(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this._radius):this.sradius=this._radius}_render(e,s,{sx:t,sy:i,sradius:r,_start_angle:n,_end_angle:a}){const d=this.model.properties.direction.value();for(const l of s)isNaN(t[l]+i[l]+r[l]+n[l]+a[l])||(e.beginPath(),e.arc(t[l],i[l],r[l],n[l],a[l],d),e.lineTo(t[l],i[l]),e.closePath(),this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,l),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,l),e.stroke()))}_hit_point(e){let s,t,i,r,n,a,d,_,c;const{sx:h,sy:u}=e,p=this.renderer.xscale.invert(h),g=this.renderer.yscale.invert(u),x=2*this.max_radius;"data"===this.model.properties.radius.units?(a=p-x,d=p+x,_=g-x,c=g+x):(t=h-x,i=h+x,[a,d]=this.renderer.xscale.r_invert(t,i),r=u-x,n=u+x,[_,c]=this.renderer.yscale.r_invert(r,n));const v=[];for(const e of this.index.indices({x0:a,x1:d,y0:_,y1:c})){const a=this.sradius[e]**2;[t,i]=this.renderer.xscale.r_compute(p,this._x[e]),[r,n]=this.renderer.yscale.r_compute(g,this._y[e]),s=(t-i)**2+(r-n)**2,s<=a&&v.push(e)}const y=this.model.properties.direction.value(),f=[];for(const e of v){const s=Math.atan2(u-this.sy[e],h-this.sx[e]);l.angle_between(-s,-this._start_angle[e],-this._end_angle[e],y)&&f.push(e)}return new o.Selection({indices:f})}draw_legend_for_index(e,s,t){n.generic_area_legend(this.visuals,e,s,t)}scenterxy(e){const s=this.sradius[e]/2,t=(this._start_angle[e]+this._end_angle[e])/2;return[this.sx[e]+s*Math.cos(t),this.sy[e]+s*Math.sin(t)]}}t.WedgeView=_,_.__name__="WedgeView";class c extends r.XYGlyph{constructor(e){super(e)}static init_Wedge(){this.prototype.default_view=_,this.mixins([a.LineVector,a.FillVector]),this.define({direction:[d.Direction,"anticlock"],radius:[d.DistanceSpec],start_angle:[d.AngleSpec],end_angle:[d.AngleSpec]})}}t.Wedge=c,c.__name__="Wedge",c.init_Wedge()},
function _(e,t,_){Object.defineProperty(_,"__esModule",{value:!0});const r=e(1);r.__exportStar(e(117),_),r.__exportStar(e(266),_),r.__exportStar(e(267),_)},
function _(e,o,r){Object.defineProperty(r,"__esModule",{value:!0});const t=e(81);class n extends t.Model{constructor(e){super(e)}}r.LayoutProvider=n,n.__name__="LayoutProvider"},
function _(t,a,e){Object.defineProperty(e,"__esModule",{value:!0});const r=t(1),o=t(266),n=t(24),s=r.__importStar(t(18));class u extends o.LayoutProvider{constructor(t){super(t)}static init_StaticLayoutProvider(){this.define({graph_layout:[s.Any,{}]})}get_node_coordinates(t){const a=t.data.index,e=a.length,r=new n.NumberArray(e),o=new n.NumberArray(e);for(let t=0;t<e;t++){const e=this.graph_layout[a[t]],[n,s]=null!=e?e:[NaN,NaN];r[t]=n,o[t]=s}return[r,o]}get_edge_coordinates(t){const a=t.data.start,e=t.data.end,r=a.length,o=[],n=[],s=null!=t.data.xs&&null!=t.data.ys;for(let u=0;u<r;u++){const r=null!=this.graph_layout[a[u]]&&null!=this.graph_layout[e[u]];if(s&&r)o.push(t.data.xs[u]),n.push(t.data.ys[u]);else{let t,s;r?(t=this.graph_layout[a[u]],s=this.graph_layout[e[u]]):(t=[NaN,NaN],s=[NaN,NaN]),o.push([t[0],s[0]]),n.push([t[1],s[1]])}}return[o,n]}}e.StaticLayoutProvider=u,u.__name__="StaticLayoutProvider",u.init_StaticLayoutProvider()},
function _(e,r,d){Object.defineProperty(d,"__esModule",{value:!0});var i=e(269);d.Grid=i.Grid},
function _(i,e,t){Object.defineProperty(t,"__esModule",{value:!0});const s=i(1),n=i(178),r=s.__importStar(i(28)),o=s.__importStar(i(18)),d=i(8);class _ extends n.GuideRendererView{_render(){const i=this.layer.ctx;i.save(),this._draw_regions(i),this._draw_minor_grids(i),this._draw_grids(i),i.restore()}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.request_render())}_draw_regions(i){if(!this.visuals.band_fill.doit&&!this.visuals.band_hatch.doit)return;this.visuals.band_fill.set_value(i);const[e,t]=this.grid_coords("major",!1);for(let s=0;s<e.length-1;s++){if(s%2!=1)continue;const[n,r]=this.coordinates.map_to_screen(e[s],t[s]),[o,d]=this.coordinates.map_to_screen(e[s+1],t[s+1]);this.visuals.band_fill.doit&&i.fillRect(n[0],r[0],o[1]-n[0],d[1]-r[0]),this.visuals.band_hatch.doit2(i,s,()=>{i.fillRect(n[0],r[0],o[1]-n[0],d[1]-r[0])},()=>this.request_render())}}_draw_grids(i){if(!this.visuals.grid_line.doit)return;const[e,t]=this.grid_coords("major");this._draw_grid_helper(i,this.visuals.grid_line,e,t)}_draw_minor_grids(i){if(!this.visuals.minor_grid_line.doit)return;const[e,t]=this.grid_coords("minor");this._draw_grid_helper(i,this.visuals.minor_grid_line,e,t)}_draw_grid_helper(i,e,t,s){e.set_value(i),i.beginPath();for(let e=0;e<t.length;e++){const[n,r]=this.coordinates.map_to_screen(t[e],s[e]);i.moveTo(Math.round(n[0]),Math.round(r[0]));for(let e=1;e<n.length;e++)i.lineTo(Math.round(n[e]),Math.round(r[e]))}i.stroke()}ranges(){const i=this.model.dimension,e=(i+1)%2,{ranges:t}=this.coordinates;return[t[i],t[e]]}computed_bounds(){const[i]=this.ranges(),e=this.model.bounds,t=[i.min,i.max];let s,n;if(d.isArray(e))s=Math.min(e[0],e[1]),n=Math.max(e[0],e[1]),s<t[0]&&(s=t[0]),n>t[1]&&(n=t[1]);else{[s,n]=t;for(const i of this.plot_view.axis_views)i.dimension==this.model.dimension&&i.model.x_range_name==this.model.x_range_name&&i.model.y_range_name==this.model.y_range_name&&([s,n]=i.computed_bounds)}return[s,n]}grid_coords(i,e=!0){const t=this.model.dimension,s=(t+1)%2,[n,r]=this.ranges();let[o,d]=this.computed_bounds();[o,d]=[Math.min(o,d),Math.max(o,d)];const _=[[],[]],a=this.model.get_ticker();if(null==a)return _;const l=a.get_ticks(o,d,n,r.min,{})[i],h=n.min,c=n.max,u=r.min,m=r.max;e||(l[0]!=h&&l.splice(0,0,h),l[l.length-1]!=c&&l.push(c));for(let i=0;i<l.length;i++){if((l[i]==h||l[i]==c)&&e)continue;const n=[],r=[],o=2;for(let e=0;e<o;e++){const t=u+(m-u)/(o-1)*e;n.push(l[i]),r.push(t)}_[t].push(n),_[s].push(r)}return _}}t.GridView=_,_.__name__="GridView";class a extends n.GuideRenderer{constructor(i){super(i)}static init_Grid(){this.prototype.default_view=_,this.mixins([["grid_",r.Line],["minor_grid_",r.Line],["band_",r.Fill],["band_",r.Hatch]]),this.define({bounds:[o.Any,"auto"],dimension:[o.Any,0],axis:[o.Instance],ticker:[o.Instance]}),this.override({level:"underlay",band_fill_color:null,band_fill_alpha:0,grid_line_color:"#e5e5e5",minor_grid_line_color:null})}get_ticker(){return null!=this.ticker?this.ticker:null!=this.axis?this.axis.ticker:null}}t.Grid=a,a.__name__="Grid",a.init_Grid()},
function _(a,o,r){Object.defineProperty(r,"__esModule",{value:!0});var e=a(271);r.Box=e.Box;var v=a(274);r.Column=v.Column;var x=a(275);r.GridBox=x.GridBox;var B=a(276);r.HTMLBox=B.HTMLBox;var n=a(272);r.LayoutDOM=n.LayoutDOM;var t=a(277);r.Row=t.Row;var u=a(278);r.Spacer=u.Spacer;var d=a(279);r.Panel=d.Panel,r.Tabs=d.Tabs;var i=a(286);r.WidgetBox=i.WidgetBox},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const n=e(1),s=e(272),o=n.__importStar(e(18));class c extends s.LayoutDOMView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.children.change,()=>this.rebuild())}get child_models(){return this.model.children}}i.BoxView=c,c.__name__="BoxView";class r extends s.LayoutDOM{constructor(e){super(e)}static init_Box(){this.define({children:[o.Array,[]],spacing:[o.Number,0]})}}i.Box=r,r.__name__="Box",r.init_Box()},
function _(i,t,e){Object.defineProperty(e,"__esModule",{value:!0});const s=i(81),o=i(20),l=i(72),n=i(19),h=i(8),a=i(115),r=i(78),_=i(212),d=i(273),c=i(77);class u extends r.DOMView{constructor(){super(...arguments),this._idle_notified=!1,this._offset_parent=null,this._viewport={}}initialize(){super.initialize(),this.el.style.position=this.is_root?"relative":"absolute",this._child_views=new Map}async lazy_initialize(){await this.build_child_views()}remove(){for(const i of this.child_views)i.remove();this._child_views.clear(),super.remove()}connect_signals(){super.connect_signals(),this.is_root&&(this._on_resize=()=>this.resize_layout(),window.addEventListener("resize",this._on_resize),this._parent_observer=setInterval(()=>{const i=this.el.offsetParent;this._offset_parent!=i&&(this._offset_parent=i,null!=i&&(this.compute_viewport(),this.invalidate_layout()))},250));const i=this.model.properties;this.on_change([i.width,i.height,i.min_width,i.min_height,i.max_width,i.max_height,i.margin,i.width_policy,i.height_policy,i.sizing_mode,i.aspect_ratio,i.visible],()=>this.invalidate_layout()),this.on_change([i.background,i.css_classes],()=>this.invalidate_render())}disconnect_signals(){null!=this._parent_observer&&clearTimeout(this._parent_observer),null!=this._on_resize&&window.removeEventListener("resize",this._on_resize),super.disconnect_signals()}css_classes(){return super.css_classes().concat(this.model.css_classes)}get child_views(){return this.child_models.map(i=>this._child_views.get(i))}async build_child_views(){await a.build_views(this._child_views,this.child_models,{parent:this})}render(){super.render(),l.empty(this.el);const{background:i}=this.model;this.el.style.backgroundColor=null!=i?i:"",l.classes(this.el).clear().add(...this.css_classes());for(const i of this.child_views)this.el.appendChild(i.el),i.render()}update_layout(){for(const i of this.child_views)i.update_layout();this._update_layout()}update_position(){this.el.style.display=this.model.visible?"block":"none";const i=this.is_root?this.layout.sizing.margin:void 0;l.position(this.el,this.layout.bbox,i);for(const i of this.child_views)i.update_position()}after_layout(){for(const i of this.child_views)i.after_layout();this._has_finished=!0}compute_viewport(){this._viewport=this._viewport_size()}renderTo(i){i.appendChild(this.el),this._offset_parent=this.el.offsetParent,this.compute_viewport(),this.build()}build(){return this.assert_root(),this.render(),this.update_layout(),this.compute_layout(),this}async rebuild(){await this.build_child_views(),this.invalidate_render()}compute_layout(){const i=Date.now();this.layout.compute(this._viewport),this.update_position(),this.after_layout(),n.logger.debug(`layout computed in ${Date.now()-i} ms`),this.notify_finished()}resize_layout(){this.root.compute_viewport(),this.root.compute_layout()}invalidate_layout(){this.root.update_layout(),this.root.compute_layout()}invalidate_render(){this.render(),this.invalidate_layout()}has_finished(){if(!super.has_finished())return!1;for(const i of this.child_views)if(!i.has_finished())return!1;return!0}notify_finished(){this.is_root?!this._idle_notified&&this.has_finished()&&null!=this.model.document&&(this._idle_notified=!0,this.model.document.notify_idle(this.model)):this.root.notify_finished()}_width_policy(){return null!=this.model.width?"fixed":"fit"}_height_policy(){return null!=this.model.height?"fixed":"fit"}box_sizing(){let{width_policy:i,height_policy:t,aspect_ratio:e}=this.model;"auto"==i&&(i=this._width_policy()),"auto"==t&&(t=this._height_policy());const{sizing_mode:s}=this.model;if(null!=s)if("fixed"==s)i=t="fixed";else if("stretch_both"==s)i=t="max";else if("stretch_width"==s)i="max";else if("stretch_height"==s)t="max";else switch(null==e&&(e="auto"),s){case"scale_width":i="max",t="min";break;case"scale_height":i="min",t="max";break;case"scale_both":i="max",t="max"}const o={width_policy:i,height_policy:t},{min_width:l,min_height:n}=this.model;null!=l&&(o.min_width=l),null!=n&&(o.min_height=n);const{width:a,height:r}=this.model;null!=a&&(o.width=a),null!=r&&(o.height=r);const{max_width:_,max_height:d}=this.model;null!=_&&(o.max_width=_),null!=d&&(o.max_height=d),"auto"==e&&null!=a&&null!=r?o.aspect=a/r:h.isNumber(e)&&(o.aspect=e);const{margin:c}=this.model;if(null!=c)if(h.isNumber(c))o.margin={top:c,right:c,bottom:c,left:c};else if(2==c.length){const[i,t]=c;o.margin={top:i,right:t,bottom:i,left:t}}else{const[i,t,e,s]=c;o.margin={top:i,right:t,bottom:e,left:s}}o.visible=this.model.visible;const{align:u}=this.model;return h.isArray(u)?[o.halign,o.valign]=u:o.halign=o.valign=u,o}_viewport_size(){return l.undisplayed(this.el,()=>{let i=this.el;for(;i=i.parentElement;){if(i.classList.contains(d.bk_root))continue;if(i==document.body){const{margin:{left:i,right:t,top:e,bottom:s}}=l.extents(document.body);return{width:Math.ceil(document.documentElement.clientWidth-i-t),height:Math.ceil(document.documentElement.clientHeight-e-s)}}const{padding:{left:t,right:e,top:s,bottom:o}}=l.extents(i),{width:n,height:h}=i.getBoundingClientRect(),a=Math.ceil(n-t-e),r=Math.ceil(h-s-o);if(a>0||r>0)return{width:a>0?a:void 0,height:r>0?r:void 0}}return{}})}export(i,t=!0){const e="png"==i?"canvas":"svg",s=new c.CanvasLayer(e,t),{width:o,height:l}=this.layout.bbox;s.resize(o,l);for(const e of this.child_views){const o=e.export(i,t),{x:l,y:n}=e.layout.bbox;s.ctx.drawImage(o.canvas,l,n)}return s}serializable_state(){return Object.assign(Object.assign({},super.serializable_state()),{bbox:this.layout.bbox.box,children:this.child_views.map(i=>i.serializable_state())})}}e.LayoutDOMView=u,u.__name__="LayoutDOMView";class m extends s.Model{constructor(i){super(i)}static init_LayoutDOM(){this.define(i=>{const{Boolean:t,Number:e,String:s,Null:l,Auto:n,Color:h,Array:a,Tuple:r,Or:d}=i,c=r(e,e),u=r(e,e,e,e);return{width:[d(e,l),null],height:[d(e,l),null],min_width:[d(e,l),null],min_height:[d(e,l),null],max_width:[d(e,l),null],max_height:[d(e,l),null],margin:[d(e,c,u),[0,0,0,0]],width_policy:[d(_.SizingPolicy,n),"auto"],height_policy:[d(_.SizingPolicy,n),"auto"],aspect_ratio:[d(e,n,l),null],sizing_mode:[d(o.SizingMode,l),null],visible:[t,!0],disabled:[t,!1],align:[d(o.Align,r(o.Align,o.Align)),"start"],background:[d(h,l),null],css_classes:[a(s),[]]}})}}e.LayoutDOM=m,m.__name__="LayoutDOM",m.init_LayoutDOM()},
function _(e,o,t){Object.defineProperty(t,"__esModule",{value:!0}),t.bk_root="bk-root"},
function _(t,o,i){Object.defineProperty(i,"__esModule",{value:!0});const s=t(1),e=t(271),n=t(216),l=s.__importStar(t(18));class u extends e.BoxView{_update_layout(){const t=this.child_views.map(t=>t.layout);this.layout=new n.Column(t),this.layout.rows=this.model.rows,this.layout.spacing=[this.model.spacing,0],this.layout.set_sizing(this.box_sizing())}}i.ColumnView=u,u.__name__="ColumnView";class _ extends e.Box{constructor(t){super(t)}static init_Column(){this.prototype.default_view=u,this.define({rows:[l.Any,"auto"]})}}i.Column=_,_.__name__="Column",_.init_Column()},
function _(t,i,s){Object.defineProperty(s,"__esModule",{value:!0});const o=t(1),e=t(272),n=t(216),l=o.__importStar(t(18));class r extends e.LayoutDOMView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.children.change,()=>this.rebuild())}get child_models(){return this.model.children.map(([t])=>t)}_update_layout(){this.layout=new n.Grid,this.layout.rows=this.model.rows,this.layout.cols=this.model.cols,this.layout.spacing=this.model.spacing;for(const[t,i,s,o,e]of this.model.children){const n=this._child_views.get(t);this.layout.items.push({layout:n.layout,row:i,col:s,row_span:o,col_span:e})}this.layout.set_sizing(this.box_sizing())}}s.GridBoxView=r,r.__name__="GridBoxView";class a extends e.LayoutDOM{constructor(t){super(t)}static init_GridBox(){this.prototype.default_view=r,this.define({children:[l.Array,[]],rows:[l.Any,"auto"],cols:[l.Any,"auto"],spacing:[l.Any,0]})}}s.GridBox=a,a.__name__="GridBox",a.init_GridBox()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});const s=e(272),_=e(212);class n extends s.LayoutDOMView{get child_models(){return[]}_update_layout(){this.layout=new _.ContentBox(this.el),this.layout.set_sizing(this.box_sizing())}}o.HTMLBoxView=n,n.__name__="HTMLBoxView";class i extends s.LayoutDOM{constructor(e){super(e)}}o.HTMLBox=i,i.__name__="HTMLBox"},
function _(t,o,i){Object.defineProperty(i,"__esModule",{value:!0});const s=t(1),e=t(271),_=t(216),a=s.__importStar(t(18));class n extends e.BoxView{_update_layout(){const t=this.child_views.map(t=>t.layout);this.layout=new _.Row(t),this.layout.cols=this.model.cols,this.layout.spacing=[0,this.model.spacing],this.layout.set_sizing(this.box_sizing())}}i.RowView=n,n.__name__="RowView";class l extends e.Box{constructor(t){super(t)}static init_Row(){this.prototype.default_view=n,this.define({cols:[a.Any,"auto"]})}}i.Row=l,l.__name__="Row",l.init_Row()},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const i=e(272),s=e(212);class _ extends i.LayoutDOMView{get child_models(){return[]}_update_layout(){this.layout=new s.LayoutItem,this.layout.set_sizing(this.box_sizing())}}a.SpacerView=_,_.__name__="SpacerView";class o extends i.LayoutDOM{constructor(e){super(e)}static init_Spacer(){this.prototype.default_view=_}}a.Spacer=o,o.__name__="Spacer",o.init_Spacer()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),a=e(212),l=e(72),h=e(9),o=i.__importStar(e(18)),c=e(272),d=e(81),r=e(173),n=e(280),_=e(281),b=e(282),p=i.__importDefault(e(283)),u=i.__importDefault(e(284)),m=i.__importDefault(e(285));class v extends c.LayoutDOMView{connect_signals(){super.connect_signals(),this.connect(this.model.properties.tabs.change,()=>this.rebuild()),this.connect(this.model.properties.active.change,()=>this.on_active_change())}styles(){return[...super.styles(),p.default,u.default,m.default]}get child_models(){return this.model.tabs.map(e=>e.child)}_update_layout(){const e=this.model.tabs_location,t="above"==e||"below"==e,{scroll_el:s,headers_el:i}=this;this.header=new class extends a.ContentBox{_measure(e){const a=l.size(s),o=l.children(i).slice(0,3).map(e=>l.size(e)),{width:c,height:d}=super._measure(e);if(t){const t=a.width+h.sum(o.map(e=>e.width));return{width:e.width!=1/0?e.width:t,height:d}}{const t=a.height+h.sum(o.map(e=>e.height));return{width:c,height:e.height!=1/0?e.height:t}}}}(this.header_el),t?this.header.set_sizing({width_policy:"fit",height_policy:"fixed"}):this.header.set_sizing({width_policy:"fixed",height_policy:"fit"});let o=1,c=1;switch(e){case"above":o-=1;break;case"below":o+=1;break;case"left":c-=1;break;case"right":c+=1}const d={layout:this.header,row:o,col:c},r=this.child_views.map(e=>({layout:e.layout,row:1,col:1}));this.layout=new a.Grid([d,...r]),this.layout.set_sizing(this.box_sizing())}update_position(){super.update_position(),this.header_el.style.position="absolute",l.position(this.header_el,this.header.bbox);const e=this.model.tabs_location,t="above"==e||"below"==e,s=l.size(this.scroll_el),i=l.scroll_size(this.headers_el);if(t){const{width:e}=this.header.bbox;i.width>e?(this.wrapper_el.style.maxWidth=e-s.width+"px",l.display(this.scroll_el)):(this.wrapper_el.style.maxWidth="",l.undisplay(this.scroll_el))}else{const{height:e}=this.header.bbox;i.height>e?(this.wrapper_el.style.maxHeight=e-s.height+"px",l.display(this.scroll_el)):(this.wrapper_el.style.maxHeight="",l.undisplay(this.scroll_el))}const{child_views:a}=this;for(const e of a)l.hide(e.el);const h=a[this.model.active];null!=h&&l.show(h.el)}render(){super.render();const{active:e}=this.model,t=this.model.tabs_location,s="above"==t||"below"==t,i=this.model.tabs.map((t,s)=>{const i=l.div({class:[n.bk_tab,s==e?r.bk_active:null]},t.title);if(i.addEventListener("click",e=>{e.target==e.currentTarget&&this.change_active(s)}),t.closable){const e=l.div({class:n.bk_close});e.addEventListener("click",e=>{if(e.target==e.currentTarget){this.model.tabs=h.remove_at(this.model.tabs,s);const e=this.model.tabs.length;this.model.active>e-1&&(this.model.active=e-1)}}),i.appendChild(e)}return i});this.headers_el=l.div({class:[n.bk_headers]},i),this.wrapper_el=l.div({class:n.bk_headers_wrapper},this.headers_el);const a=l.div({class:[_.bk_btn,_.bk_btn_default],disabled:""},l.div({class:[b.bk_caret,r.bk_left]})),o=l.div({class:[_.bk_btn,_.bk_btn_default]},l.div({class:[b.bk_caret,r.bk_right]}));let c=0;const d=e=>()=>{const t=this.model.tabs.length;c="left"==e?Math.max(c-1,0):Math.min(c+1,t-1),0==c?a.setAttribute("disabled",""):a.removeAttribute("disabled"),c==t-1?o.setAttribute("disabled",""):o.removeAttribute("disabled");const i=l.children(this.headers_el).slice(0,c).map(e=>e.getBoundingClientRect());if(s){const e=-h.sum(i.map(e=>e.width));this.headers_el.style.left=e+"px"}else{const e=-h.sum(i.map(e=>e.height));this.headers_el.style.top=e+"px"}};a.addEventListener("click",d("left")),o.addEventListener("click",d("right")),this.scroll_el=l.div({class:_.bk_btn_group},a,o),this.header_el=l.div({class:[n.bk_tabs_header,r.bk_side(t)]},this.scroll_el,this.wrapper_el),this.el.appendChild(this.header_el)}change_active(e){e!=this.model.active&&(this.model.active=e)}on_active_change(){const e=this.model.active,t=l.children(this.headers_el);for(const e of t)e.classList.remove(r.bk_active);t[e].classList.add(r.bk_active);const{child_views:s}=this;for(const e of s)l.hide(e.el);l.show(s[e].el)}}s.TabsView=v,v.__name__="TabsView";class g extends c.LayoutDOM{constructor(e){super(e)}static init_Tabs(){this.prototype.default_view=v,this.define({tabs:[o.Array,[]],tabs_location:[o.Location,"above"],active:[o.Number,0]})}}s.Tabs=g,g.__name__="Tabs",g.init_Tabs();class w extends d.Model{constructor(e){super(e)}static init_Panel(){this.define({title:[o.String,""],child:[o.Instance],closable:[o.Boolean,!1]})}}s.Panel=w,w.__name__="Panel",w.init_Panel()},
function _(e,b,a){Object.defineProperty(a,"__esModule",{value:!0}),a.bk_tabs_header="bk-tabs-header",a.bk_headers_wrapper="bk-headers-wrapper",a.bk_headers="bk-headers",a.bk_tab="bk-tab",a.bk_close="bk-close"},
function _(n,b,t){Object.defineProperty(t,"__esModule",{value:!0}),t.bk_btn="bk-btn",t.bk_btn_group="bk-btn-group",t.bk_btn_default="bk-btn-default",t.bk_btn_primary="bk-btn-primary",t.bk_btn_success="bk-btn-success",t.bk_btn_warning="bk-btn-warning",t.bk_btn_danger="bk-btn-danger",t.bk_btn_type=function(n){switch(n){case"default":return t.bk_btn_default;case"primary":return t.bk_btn_primary;case"success":return t.bk_btn_success;case"warning":return t.bk_btn_warning;case"danger":return t.bk_btn_danger}},t.bk_dropdown_toggle="bk-dropdown-toggle"},
function _(e,b,d){Object.defineProperty(d,"__esModule",{value:!0}),d.bk_menu="bk-menu",d.bk_caret="bk-caret",d.bk_divider="bk-divider"},
function _(n,o,b){Object.defineProperty(b,"__esModule",{value:!0});b.default="\n.bk-root .bk-btn {\n  height: 100%;\n  display: inline-block;\n  text-align: center;\n  vertical-align: middle;\n  white-space: nowrap;\n  cursor: pointer;\n  padding: 6px 12px;\n  font-size: 12px;\n  border: 1px solid transparent;\n  border-radius: 4px;\n  outline: 0;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-btn:hover,\n.bk-root .bk-btn:focus {\n  text-decoration: none;\n}\n.bk-root .bk-btn:active,\n.bk-root .bk-btn.bk-active {\n  background-image: none;\n  box-shadow: inset 0 3px 5px rgba(0, 0, 0, 0.125);\n}\n.bk-root .bk-btn[disabled] {\n  cursor: not-allowed;\n  pointer-events: none;\n  opacity: 0.65;\n  box-shadow: none;\n}\n.bk-root .bk-btn-default {\n  color: #333;\n  background-color: #fff;\n  border-color: #ccc;\n}\n.bk-root .bk-btn-default:hover {\n  background-color: #f5f5f5;\n  border-color: #b8b8b8;\n}\n.bk-root .bk-btn-default.bk-active {\n  background-color: #ebebeb;\n  border-color: #adadad;\n}\n.bk-root .bk-btn-default[disabled],\n.bk-root .bk-btn-default[disabled]:hover,\n.bk-root .bk-btn-default[disabled]:focus,\n.bk-root .bk-btn-default[disabled]:active,\n.bk-root .bk-btn-default[disabled].bk-active {\n  background-color: #e6e6e6;\n  border-color: #ccc;\n}\n.bk-root .bk-btn-primary {\n  color: #fff;\n  background-color: #428bca;\n  border-color: #357ebd;\n}\n.bk-root .bk-btn-primary:hover {\n  background-color: #3681c1;\n  border-color: #2c699e;\n}\n.bk-root .bk-btn-primary.bk-active {\n  background-color: #3276b1;\n  border-color: #285e8e;\n}\n.bk-root .bk-btn-primary[disabled],\n.bk-root .bk-btn-primary[disabled]:hover,\n.bk-root .bk-btn-primary[disabled]:focus,\n.bk-root .bk-btn-primary[disabled]:active,\n.bk-root .bk-btn-primary[disabled].bk-active {\n  background-color: #506f89;\n  border-color: #357ebd;\n}\n.bk-root .bk-btn-success {\n  color: #fff;\n  background-color: #5cb85c;\n  border-color: #4cae4c;\n}\n.bk-root .bk-btn-success:hover {\n  background-color: #4eb24e;\n  border-color: #409240;\n}\n.bk-root .bk-btn-success.bk-active {\n  background-color: #47a447;\n  border-color: #398439;\n}\n.bk-root .bk-btn-success[disabled],\n.bk-root .bk-btn-success[disabled]:hover,\n.bk-root .bk-btn-success[disabled]:focus,\n.bk-root .bk-btn-success[disabled]:active,\n.bk-root .bk-btn-success[disabled].bk-active {\n  background-color: #667b66;\n  border-color: #4cae4c;\n}\n.bk-root .bk-btn-warning {\n  color: #fff;\n  background-color: #f0ad4e;\n  border-color: #eea236;\n}\n.bk-root .bk-btn-warning:hover {\n  background-color: #eea43b;\n  border-color: #e89014;\n}\n.bk-root .bk-btn-warning.bk-active {\n  background-color: #ed9c28;\n  border-color: #d58512;\n}\n.bk-root .bk-btn-warning[disabled],\n.bk-root .bk-btn-warning[disabled]:hover,\n.bk-root .bk-btn-warning[disabled]:focus,\n.bk-root .bk-btn-warning[disabled]:active,\n.bk-root .bk-btn-warning[disabled].bk-active {\n  background-color: #c89143;\n  border-color: #eea236;\n}\n.bk-root .bk-btn-danger {\n  color: #fff;\n  background-color: #d9534f;\n  border-color: #d43f3a;\n}\n.bk-root .bk-btn-danger:hover {\n  background-color: #d5433e;\n  border-color: #bd2d29;\n}\n.bk-root .bk-btn-danger.bk-active {\n  background-color: #d2322d;\n  border-color: #ac2925;\n}\n.bk-root .bk-btn-danger[disabled],\n.bk-root .bk-btn-danger[disabled]:hover,\n.bk-root .bk-btn-danger[disabled]:focus,\n.bk-root .bk-btn-danger[disabled]:active,\n.bk-root .bk-btn-danger[disabled].bk-active {\n  background-color: #a55350;\n  border-color: #d43f3a;\n}\n.bk-root .bk-btn-group {\n  height: 100%;\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-btn-group > .bk-btn {\n  flex-grow: 1;\n  -webkit-flex-grow: 1;\n}\n.bk-root .bk-btn-group > .bk-btn + .bk-btn {\n  margin-left: -1px;\n}\n.bk-root .bk-btn-group > .bk-btn:first-child:not(:last-child) {\n  border-bottom-right-radius: 0;\n  border-top-right-radius: 0;\n}\n.bk-root .bk-btn-group > .bk-btn:not(:first-child):last-child {\n  border-bottom-left-radius: 0;\n  border-top-left-radius: 0;\n}\n.bk-root .bk-btn-group > .bk-btn:not(:first-child):not(:last-child) {\n  border-radius: 0;\n}\n.bk-root .bk-btn-group .bk-dropdown-toggle {\n  flex: 0 0 0;\n  -webkit-flex: 0 0 0;\n  padding: 6px 6px;\n}\n"},
function _(n,o,r){Object.defineProperty(r,"__esModule",{value:!0});r.default="\n.bk-root .bk-menu-icon {\n  width: 28px;\n  height: 28px;\n  background-size: 60%;\n  background-color: transparent;\n  background-repeat: no-repeat;\n  background-position: center center;\n}\n.bk-root .bk-context-menu {\n  position: absolute;\n  display: inline-flex;\n  display: -webkit-inline-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n  width: auto;\n  height: auto;\n  z-index: 100;\n  cursor: pointer;\n  font-size: 12px;\n  background-color: #fff;\n  border: 1px solid #ccc;\n  border-radius: 4px;\n  box-shadow: 0 6px 12px rgba(0, 0, 0, 0.175);\n}\n.bk-root .bk-context-menu.bk-horizontal {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-context-menu.bk-vertical {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-context-menu > .bk-divider {\n  cursor: default;\n  overflow: hidden;\n  background-color: #e5e5e5;\n}\n.bk-root .bk-context-menu.bk-horizontal > .bk-divider {\n  width: 1px;\n  margin: 5px 0;\n}\n.bk-root .bk-context-menu.bk-vertical > .bk-divider {\n  height: 1px;\n  margin: 0 5px;\n}\n.bk-root .bk-context-menu > :not(.bk-divider) {\n  border: 1px solid transparent;\n}\n.bk-root .bk-context-menu > :not(.bk-divider).bk-active {\n  border-color: #26aae1;\n}\n.bk-root .bk-context-menu > :not(.bk-divider):hover {\n  background-color: #f9f9f9;\n}\n.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):first-child {\n  border-top-left-radius: 4px;\n  border-bottom-left-radius: 4px;\n}\n.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):last-child {\n  border-top-right-radius: 4px;\n  border-bottom-right-radius: 4px;\n}\n.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):first-child {\n  border-top-left-radius: 4px;\n  border-top-right-radius: 4px;\n}\n.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):last-child {\n  border-bottom-left-radius: 4px;\n  border-bottom-right-radius: 4px;\n}\n.bk-root .bk-menu {\n  position: absolute;\n  left: 0;\n  width: 100%;\n  z-index: 100;\n  cursor: pointer;\n  font-size: 12px;\n  background-color: #fff;\n  border: 1px solid #ccc;\n  border-radius: 4px;\n  box-shadow: 0 6px 12px rgba(0, 0, 0, 0.175);\n}\n.bk-root .bk-menu.bk-above {\n  bottom: 100%;\n}\n.bk-root .bk-menu.bk-below {\n  top: 100%;\n}\n.bk-root .bk-menu > .bk-divider {\n  height: 1px;\n  margin: 7.5px 0;\n  overflow: hidden;\n  background-color: #e5e5e5;\n}\n.bk-root .bk-menu > :not(.bk-divider) {\n  padding: 6px 12px;\n}\n.bk-root .bk-menu > :not(.bk-divider):hover,\n.bk-root .bk-menu > :not(.bk-divider).bk-active {\n  background-color: #e6e6e6;\n}\n.bk-root .bk-caret {\n  display: inline-block;\n  vertical-align: middle;\n  width: 0;\n  height: 0;\n  margin: 0 5px;\n}\n.bk-root .bk-caret.bk-down {\n  border-top: 4px solid;\n}\n.bk-root .bk-caret.bk-up {\n  border-bottom: 4px solid;\n}\n.bk-root .bk-caret.bk-down,\n.bk-root .bk-caret.bk-up {\n  border-right: 4px solid transparent;\n  border-left: 4px solid transparent;\n}\n.bk-root .bk-caret.bk-left {\n  border-right: 4px solid;\n}\n.bk-root .bk-caret.bk-right {\n  border-left: 4px solid;\n}\n.bk-root .bk-caret.bk-left,\n.bk-root .bk-caret.bk-right {\n  border-top: 4px solid transparent;\n  border-bottom: 4px solid transparent;\n}\n"},
function _(e,r,n){Object.defineProperty(n,"__esModule",{value:!0});n.default='\n.bk-root .bk-tabs-header {\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  overflow: hidden;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-tabs-header .bk-btn-group {\n  height: auto;\n  margin-right: 5px;\n}\n.bk-root .bk-tabs-header .bk-btn-group > .bk-btn {\n  flex-grow: 0;\n  -webkit-flex-grow: 0;\n  height: auto;\n  padding: 4px 4px;\n}\n.bk-root .bk-tabs-header .bk-headers-wrapper {\n  flex-grow: 1;\n  -webkit-flex-grow: 1;\n  overflow: hidden;\n  color: #666666;\n}\n.bk-root .bk-tabs-header.bk-above .bk-headers-wrapper {\n  border-bottom: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-right .bk-headers-wrapper {\n  border-left: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-below .bk-headers-wrapper {\n  border-top: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-left .bk-headers-wrapper {\n  border-right: 1px solid #e6e6e6;\n}\n.bk-root .bk-tabs-header.bk-above,\n.bk-root .bk-tabs-header.bk-below {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-tabs-header.bk-above .bk-headers,\n.bk-root .bk-tabs-header.bk-below .bk-headers {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-tabs-header.bk-left,\n.bk-root .bk-tabs-header.bk-right {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-tabs-header.bk-left .bk-headers,\n.bk-root .bk-tabs-header.bk-right .bk-headers {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-tabs-header .bk-headers {\n  position: relative;\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n}\n.bk-root .bk-tabs-header .bk-tab {\n  padding: 4px 8px;\n  border: solid transparent;\n  white-space: nowrap;\n  cursor: pointer;\n}\n.bk-root .bk-tabs-header .bk-tab:hover {\n  background-color: #f2f2f2;\n}\n.bk-root .bk-tabs-header .bk-tab.bk-active {\n  color: #4d4d4d;\n  background-color: white;\n  border-color: #e6e6e6;\n}\n.bk-root .bk-tabs-header .bk-tab .bk-close {\n  margin-left: 10px;\n}\n.bk-root .bk-tabs-header.bk-above .bk-tab {\n  border-width: 3px 1px 0px 1px;\n  border-radius: 4px 4px 0 0;\n}\n.bk-root .bk-tabs-header.bk-right .bk-tab {\n  border-width: 1px 3px 1px 0px;\n  border-radius: 0 4px 4px 0;\n}\n.bk-root .bk-tabs-header.bk-below .bk-tab {\n  border-width: 0px 1px 3px 1px;\n  border-radius: 0 0 4px 4px;\n}\n.bk-root .bk-tabs-header.bk-left .bk-tab {\n  border-width: 1px 0px 1px 3px;\n  border-radius: 4px 0 0 4px;\n}\n.bk-root .bk-close {\n  display: inline-block;\n  width: 10px;\n  height: 10px;\n  vertical-align: middle;\n  background-image: url(\'data:image/svg+xml;utf8,      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">        <line x1="1" y1="9" x2="9" y2="1" stroke="gray" stroke-width="2"/>        <line x1="1" y1="1" x2="9" y2="9" stroke="gray" stroke-width="2"/>      </svg>\');\n}\n.bk-root .bk-close:hover {\n  background-image: url(\'data:image/svg+xml;utf8,      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">        <line x1="1" y1="9" x2="9" y2="1" stroke="red" stroke-width="2"/>        <line x1="1" y1="1" x2="9" y2="9" stroke="red" stroke-width="2"/>      </svg>\');\n}\n'},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const o=e(274);class _ extends o.ColumnView{}i.WidgetBoxView=_,_.__name__="WidgetBoxView";class n extends o.Column{constructor(e){super(e)}static init_WidgetBox(){this.prototype.default_view=_}}i.WidgetBox=n,n.__name__="WidgetBox",n.init_WidgetBox()},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});e(1).__exportStar(e(288),t);var a=e(289);t.Marker=a.Marker;var _=e(290);t.Scatter=_.Scatter},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});const i=e(1),r=e(289),n=i.__importStar(e(238)),s=Math.sqrt(3);function c(e,t){e.rotate(Math.PI/4),a(e,t),e.rotate(-Math.PI/4)}function l(e,t){const o=t*s,i=o/3;e.moveTo(-o/2,-i),e.lineTo(0,0),e.lineTo(o/2,-i),e.lineTo(0,0),e.lineTo(0,t)}function a(e,t){e.moveTo(0,t),e.lineTo(0,-t),e.moveTo(-t,0),e.lineTo(t,0)}function u(e,t){e.moveTo(0,t),e.lineTo(t/1.5,0),e.lineTo(0,-t),e.lineTo(-t/1.5,0),e.closePath()}function d(e,t){const o=t*s,i=o/3;e.moveTo(-t,i),e.lineTo(t,i),e.lineTo(0,i-o),e.closePath()}function v(e,t,o,i,r){a(e,o),c(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function _(e,t,o,i,r){e.arc(0,0,o,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function f(e,t,o,i,r){e.arc(0,0,o,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),a(e,o),e.stroke())}function T(e,t,o,i,r){_(e,t,o,i,r),P(e,t,o,i,r)}function z(e,t,o,i,r){e.arc(0,0,o,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),l(e,o),e.stroke())}function C(e,t,o,i,r){e.arc(0,0,o,0,2*Math.PI,!1),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),c(e,o),e.stroke())}function k(e,t,o,i,r){a(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function m(e,t,o,i,r){u(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function h(e,t,o,i,r){u(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.moveTo(0,o),e.lineTo(0,-o),e.moveTo(-o/1.5,0),e.lineTo(o/1.5,0),e.stroke())}function q(e,t,o,i,r){m(e,t,o,i,r),P(e,t,o,i,r)}function P(e,t,o,i,r){!function(e,t){e.beginPath(),e.arc(0,0,t/4,0,2*Math.PI,!1),e.closePath()}(e,o),i.set_vectorize(e,t),e.fillStyle=e.strokeStyle,e.fill()}function D(e,t,o,i,r){!function(e,t){const o=t/2,i=s*o;e.moveTo(t,0),e.lineTo(o,-i),e.lineTo(-o,-i),e.lineTo(-t,0),e.lineTo(-o,i),e.lineTo(o,i),e.closePath()}(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function g(e,t,o,i,r){D(e,t,o,i,r),P(e,t,o,i)}function S(e,t,o,i,r){e.rotate(Math.PI),d(e,o),e.rotate(-Math.PI),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function G(e,t,o,i,r){const n=3*o/8,s=[n,n,o,o,n,n,-n,-n,-o,-o,-n,-n],c=[o,n,n,-n,-n,-o,-o,-n,-n,n,n,o];for(e.moveTo(s[0],c[0]),t=1;t<12;t++)e.lineTo(s[t],c[t]);e.closePath(),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function L(e,t,o,i,r){const n=2*o;e.rect(-o,-o,n,n),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function M(e,t,o,i,r){const n=3*o/8;e.moveTo(-o,-o),e.quadraticCurveTo(0,-n,o,-o),e.quadraticCurveTo(n,0,o,o),e.quadraticCurveTo(0,n,-o,o),e.quadraticCurveTo(-n,0,-o,-o),e.closePath(),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function p(e,t,o,i,r){const n=2*o;e.rect(-o,-o,n,n),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),a(e,o),e.stroke())}function x(e,t,o,i,r){L(e,t,o,i,r),P(e,t,o,i)}function I(e,t,o,i,r){const n=2*o;e.rect(-o,-o,n,n),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.moveTo(-o,o),e.lineTo(o,-o),e.moveTo(-o,-o),e.lineTo(o,o),e.stroke())}function y(e,t,o,i,r){d(e,o),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function X(e,t,o,i,r){y(e,t,o,i,r),P(e,t,o,i)}function H(e,t,o,i,r){const n=o*s,c=n/3,l=3*c/8;e.moveTo(-o,c),e.quadraticCurveTo(0,l,o,c),e.quadraticCurveTo(s*l/2,l/2,0,c-n),e.quadraticCurveTo(-s*l/2,l/2,-o,c),e.closePath(),r.doit&&(r.set_vectorize(e,t),e.fill()),i.doit&&(i.set_vectorize(e,t),e.stroke())}function Y(e,t,o,i,r){!function(e,t){e.moveTo(-t,0),e.lineTo(t,0)}(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function A(e,t,o,i,r){c(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function b(e,t,o,i,r){l(e,o),i.doit&&(i.set_vectorize(e,t),e.stroke())}function w(e,t,o){var i;const n=class extends r.MarkerView{static initClass(){this.prototype._render_one=t,this.prototype.glglyph_cls=o}};n.initClass();const s=((i=class extends r.Marker{static initClass(){this.prototype.default_view=n}}).__name__=e,i);return s.initClass(),s}o.Asterisk=w("Asterisk",v,n.AsteriskGL),o.CircleCross=w("CircleCross",f,n.CircleCrossGL),o.CircleDot=w("CircleDot",T),o.CircleY=w("CircleY",z),o.CircleX=w("CircleX",C,n.CircleXGL),o.Cross=w("Cross",k,n.CrossGL),o.Dash=w("Dash",Y),o.Diamond=w("Diamond",m,n.DiamondGL),o.DiamondCross=w("DiamondCross",h,n.DiamondCrossGL),o.DiamondDot=w("DiamondDot",q),o.Dot=w("Dot",P),o.Hex=w("Hex",D,n.HexGL),o.HexDot=w("HexDot",g),o.InvertedTriangle=w("InvertedTriangle",S,n.InvertedTriangleGL),o.Plus=w("Plus",G),o.Square=w("Square",L,n.SquareGL),o.SquareCross=w("SquareCross",p,n.SquareCrossGL),o.SquareDot=w("SquareDot",x),o.SquarePin=w("SquarePin",M),o.SquareX=w("SquareX",I,n.SquareXGL),o.Triangle=w("Triangle",y,n.TriangleGL),o.TriangleDot=w("TriangleDot",X),o.TrianglePin=w("TrianglePin",H),o.X=w("X",A,n.XGL),o.Y=w("Y",b),o.marker_funcs={asterisk:v,circle:_,circle_cross:f,circle_dot:T,circle_y:z,circle_x:C,cross:k,diamond:m,diamond_dot:q,diamond_cross:h,dot:P,hex:D,hex_dot:g,inverted_triangle:S,plus:G,square:L,square_cross:p,square_dot:x,square_pin:M,square_x:I,triangle:y,triangle_dot:X,triangle_pin:H,dash:Y,x:A,y:b}},
function _(e,s,i){Object.defineProperty(i,"__esModule",{value:!0});const t=e(1),n=e(93),r=e(28),a=t.__importStar(e(101)),_=t.__importStar(e(18)),h=e(9),l=e(88);class c extends n.XYGlyphView{initialize(){super.initialize();const{webgl:e}=this.renderer.plot_view.canvas_view;null!=e&&null!=this.glglyph_cls&&(this.glglyph=new this.glglyph_cls(e.gl,this))}_render(e,s,{sx:i,sy:t,_size:n,_angle:r}){for(const a of s){if(isNaN(i[a]+t[a]+n[a]+r[a]))continue;const s=n[a]/2;e.beginPath(),e.translate(i[a],t[a]),r[a]&&e.rotate(r[a]),this._render_one(e,a,s,this.visuals.line,this.visuals.fill),r[a]&&e.rotate(-r[a]),e.translate(-i[a],-t[a])}}_mask_data(){const e=this.renderer.plot_view.frame.bbox.h_range,s=e.start-this.max_size,i=e.end+this.max_size,[t,n]=this.renderer.xscale.r_invert(s,i),r=this.renderer.plot_view.frame.bbox.v_range,a=r.start-this.max_size,_=r.end+this.max_size,[h,l]=this.renderer.yscale.r_invert(a,_);return this.index.indices({x0:t,x1:n,y0:h,y1:l})}_hit_point(e){const{sx:s,sy:i}=e,t=s-this.max_size,n=s+this.max_size,[r,a]=this.renderer.xscale.r_invert(t,n),_=i-this.max_size,h=i+this.max_size,[c,o]=this.renderer.yscale.r_invert(_,h),x=this.index.indices({x0:r,x1:a,y0:c,y1:o}),d=[];for(const e of x){const t=this._size[e]/2;Math.abs(this.sx[e]-s)<=t&&Math.abs(this.sy[e]-i)<=t&&d.push(e)}return new l.Selection({indices:d})}_hit_span(e){const{sx:s,sy:i}=e,t=this.bounds(),n=this.max_size/2;let r,a,_,h;if("h"==e.direction){_=t.y0,h=t.y1;const e=s-n,i=s+n;[r,a]=this.renderer.xscale.r_invert(e,i)}else{r=t.x0,a=t.x1;const e=i-n,s=i+n;[_,h]=this.renderer.yscale.r_invert(e,s)}const c=[...this.index.indices({x0:r,x1:a,y0:_,y1:h})];return new l.Selection({indices:c})}_hit_rect(e){const{sx0:s,sx1:i,sy0:t,sy1:n}=e,[r,a]=this.renderer.xscale.r_invert(s,i),[_,h]=this.renderer.yscale.r_invert(t,n),c=[...this.index.indices({x0:r,x1:a,y0:_,y1:h})];return new l.Selection({indices:c})}_hit_poly(e){const{sx:s,sy:i}=e,t=h.range(0,this.sx.length),n=[];for(let e=0,r=t.length;e<r;e++){const r=t[e];a.point_in_poly(this.sx[e],this.sy[e],s,i)&&n.push(r)}return new l.Selection({indices:n})}_get_legend_args({x0:e,x1:s,y0:i,y1:t},n){const r=n+1,a=new Array(r);a[n]=(e+s)/2;const _=new Array(r);_[n]=(i+t)/2;const h=new Array(r);h[n]=.4*Math.min(Math.abs(s-e),Math.abs(t-i));const l=new Array(r);return l[n]=0,{sx:a,sy:_,_size:h,_angle:l}}draw_legend_for_index(e,{x0:s,x1:i,y0:t,y1:n},r){const a=this._get_legend_args({x0:s,x1:i,y0:t,y1:n},r);this._render(e,[r],a)}}i.MarkerView=c,c.__name__="MarkerView";class o extends n.XYGlyph{constructor(e){super(e)}static init_Marker(){this.mixins([r.LineVector,r.FillVector]),this.define({size:[_.DistanceSpec,{units:"screen",value:4}],angle:[_.AngleSpec,0]})}}i.Marker=o,o.__name__="Marker",o.init_Marker()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const a=e(1),s=e(289),i=e(288),n=a.__importStar(e(18));class _ extends s.MarkerView{_render(e,t,{sx:r,sy:a,_size:s,_angle:n,_marker:_}){for(const c of t){if(isNaN(r[c]+a[c]+s[c]+n[c])||null==_[c])continue;const t=s[c]/2;e.beginPath(),e.translate(r[c],a[c]),n[c]&&e.rotate(n[c]),i.marker_funcs[_[c]](e,c,t,this.visuals.line,this.visuals.fill),n[c]&&e.rotate(-n[c]),e.translate(-r[c],-a[c])}}draw_legend_for_index(e,{x0:t,x1:r,y0:a,y1:s},i){const n=this._get_legend_args({x0:t,x1:r,y0:a,y1:s},i),_=new Array(i+1);_[i]=this._marker[i],n._marker=_,this._render(e,[i],n)}}r.ScatterView=_,_.__name__="ScatterView";class c extends s.Marker{constructor(e){super(e)}static init_Scatter(){this.prototype.default_view=_,this.define({marker:[n.MarkerSpec,{value:"circle"}]})}}r.Scatter=c,c.__name__="Scatter",c.init_Scatter()},
function _(a,o,p){Object.defineProperty(p,"__esModule",{value:!0});var t=a(292);p.MapOptions=t.MapOptions;var e=a(292);p.GMapOptions=e.GMapOptions;var n=a(292);p.GMapPlot=n.GMapPlot;var M=a(293);p.Plot=M.Plot},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const o=t(1),n=t(19),a=t(293),s=o.__importStar(t(18)),p=t(81),r=t(158),_=t(319);i.GMapPlotView=_.GMapPlotView;class l extends p.Model{constructor(t){super(t)}static init_MapOptions(){this.define({lat:[s.Number],lng:[s.Number],zoom:[s.Number,12]})}}i.MapOptions=l,l.__name__="MapOptions",l.init_MapOptions();class c extends l{constructor(t){super(t)}static init_GMapOptions(){this.define({map_type:[s.String,"roadmap"],scale_control:[s.Boolean,!1],styles:[s.String],tilt:[s.Int,45]})}}i.GMapOptions=c,c.__name__="GMapOptions",c.init_GMapOptions();class u extends a.Plot{constructor(t){super(t)}static init_GMapPlot(){this.prototype.default_view=_.GMapPlotView,this.define({map_options:[s.Instance],api_key:[s.String]}),this.override({x_range:()=>new r.Range1d,y_range:()=>new r.Range1d})}initialize(){super.initialize(),this.use_map=!0,this.api_key||n.logger.error("api_key is required. See https://developers.google.com/maps/documentation/javascript/get-api-key for more information on how to obtain your own.")}}i.GMapPlot=u,u.__name__="GMapPlot",u.init_GMapPlot()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const i=e(1),o=i.__importStar(e(28)),n=i.__importStar(e(18)),s=e(15),a=e(9),l=e(13),_=e(8),h=e(272),c=e(169),u=e(145),d=e(294),b=e(85),g=e(90),p=e(210),m=e(312);r.PlotView=m.PlotView;class f extends h.LayoutDOM{constructor(e){super(e)}static init_Plot(){this.prototype.default_view=m.PlotView,this.mixins([["outline_",o.Line],["background_",o.Fill],["border_",o.Fill]]),this.define({toolbar:[n.Instance,()=>new d.Toolbar],toolbar_location:[n.Location,"right"],toolbar_sticky:[n.Boolean,!0],plot_width:[n.Number,600],plot_height:[n.Number,600],frame_width:[n.Number,null],frame_height:[n.Number,null],title:[n.Any,()=>new c.Title({text:""})],title_location:[n.Location,"above"],above:[n.Array,[]],below:[n.Array,[]],left:[n.Array,[]],right:[n.Array,[]],center:[n.Array,[]],renderers:[n.Array,[]],x_range:[n.Instance,()=>new p.DataRange1d],extra_x_ranges:[n.Any,{}],y_range:[n.Instance,()=>new p.DataRange1d],extra_y_ranges:[n.Any,{}],x_scale:[n.Instance,()=>new u.LinearScale],y_scale:[n.Instance,()=>new u.LinearScale],lod_factor:[n.Number,10],lod_interval:[n.Number,300],lod_threshold:[n.Number,2e3],lod_timeout:[n.Number,500],hidpi:[n.Boolean,!0],output_backend:[n.OutputBackend,"canvas"],min_border:[n.Number,5],min_border_top:[n.Number,null],min_border_left:[n.Number,null],min_border_bottom:[n.Number,null],min_border_right:[n.Number,null],inner_width:[n.Number],inner_height:[n.Number],outer_width:[n.Number],outer_height:[n.Number],match_aspect:[n.Boolean,!1],aspect_scale:[n.Number,1],reset_policy:[n.ResetPolicy,"standard"]}),this.override({outline_line_color:"#e5e5e5",border_fill_color:"#ffffff",background_fill_color:"#ffffff"})}get width(){const e=this.properties.width.get_value();return null!=e?e:this.plot_width}set width(e){this.setv({width:e,plot_width:e})}get height(){const e=this.properties.height.get_value();return null!=e?e:this.plot_height}set height(e){this.setv({height:e,plot_height:e})}_doc_attached(){super._doc_attached(),this._push_changes([[this.properties.inner_height,null,this.inner_height],[this.properties.inner_width,null,this.inner_width]])}initialize(){super.initialize(),this.reset=new s.Signal0(this,"reset");for(const e of l.values(this.extra_x_ranges).concat(this.x_range)){let t=e.plots;_.isArray(t)&&(t=t.concat(this),e.setv({plots:t},{silent:!0}))}for(const e of l.values(this.extra_y_ranges).concat(this.y_range)){let t=e.plots;_.isArray(t)&&(t=t.concat(this),e.setv({plots:t},{silent:!0}))}}add_layout(e,t="center"){const r=this.properties[t].get_value();this.setv({[t]:[...r,e]})}remove_layout(e){const t=t=>{a.remove_by(t,t=>t==e)};t(this.left),t(this.right),t(this.above),t(this.below),t(this.center)}add_renderers(...e){this.renderers=this.renderers.concat(e)}add_glyph(e,t=new b.ColumnDataSource,r={}){const i=Object.assign(Object.assign({},r),{data_source:t,glyph:e}),o=new g.GlyphRenderer(i);return this.add_renderers(o),o}add_tools(...e){this.toolbar.tools=this.toolbar.tools.concat(e)}get panels(){return[...this.side_panels,...this.center]}get side_panels(){const{above:e,below:t,left:r,right:i}=this;return a.concat([e,t,r,i])}}r.Plot=f,f.__name__="Plot",f.init_Plot()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const s=t(1).__importStar(t(18)),c=t(8),o=t(9),n=t(13),a=t(295),l=t(305),r=t=>{switch(t){case"tap":return"active_tap";case"pan":return"active_drag";case"pinch":case"scroll":return"active_scroll";case"multi":return"active_multi"}return null},_=t=>"tap"==t||"pan"==t;class h extends l.ToolbarBase{constructor(t){super(t)}static init_Toolbar(){this.prototype.default_view=l.ToolbarBaseView,this.define({active_drag:[s.Any,"auto"],active_inspect:[s.Any,"auto"],active_scroll:[s.Any,"auto"],active_tap:[s.Any,"auto"],active_multi:[s.Any,null]})}connect_signals(){super.connect_signals();const{tools:t,active_drag:e,active_inspect:i,active_scroll:s,active_tap:c,active_multi:o}=this.properties;this.on_change([t,e,i,s,c,o],()=>this._init_tools())}_init_tools(){if(super._init_tools(),"auto"==this.active_inspect);else if(this.active_inspect instanceof a.InspectTool){let t=!1;for(const e of this.inspectors)e!=this.active_inspect?e.active=!1:t=!0;t||(this.active_inspect=null)}else if(c.isArray(this.active_inspect)){const t=o.intersection(this.active_inspect,this.inspectors);t.length!=this.active_inspect.length&&(this.active_inspect=t);for(const t of this.inspectors)o.includes(this.active_inspect,t)||(t.active=!1)}else if(null==this.active_inspect)for(const t of this.inspectors)t.active=!1;const t=t=>{t.active?this._active_change(t):t.active=!0};for(const t of n.values(this.gestures)){t.tools=o.sort_by(t.tools,t=>t.default_order);for(const e of t.tools)this.connect(e.properties.active.change,()=>this._active_change(e))}for(const[e,i]of n.entries(this.gestures)){const s=r(e);if(s){const c=this[s];"auto"==c?0!=i.tools.length&&_(e)&&t(i.tools[0]):null!=c&&(o.includes(this.tools,c)?t(c):this[s]=null)}}}}i.Toolbar=h,h.__name__="Toolbar",h.init_Toolbar()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});const n=e(1),s=e(296),i=e(304),_=n.__importStar(e(18));class c extends s.ButtonToolView{}o.InspectToolView=c,c.__name__="InspectToolView";class l extends s.ButtonTool{constructor(e){super(e),this.event_type="move"}static init_InspectTool(){this.prototype.button_view=i.OnOffButtonView,this.define({toggleable:[_.Boolean,!0]}),this.override({active:!0})}}o.InspectTool=l,l.__name__="InspectTool",l.init_InspectTool()},
function _(t,e,o){Object.defineProperty(o,"__esModule",{value:!0});const i=t(1),s=i.__importDefault(t(297)),n=t(78),l=t(298),r=t(72),a=i.__importStar(t(18)),u=t(29),_=t(8),h=t(9),c=t(299),m=i.__importDefault(t(300)),d=i.__importDefault(t(301)),p=i.__importDefault(t(284)),f=t(302);class g extends n.DOMView{initialize(){super.initialize();const t=this.model.menu;if(null!=t){const e=this.parent.model.toolbar_location,o="left"==e||"above"==e,i=this.parent.model.horizontal?"vertical":"horizontal";this._menu=new f.ContextMenu(o?h.reversed(t):t,{orientation:i,prevent_hide:t=>t.target==this.el})}this._hammer=new s.default(this.el,{touchAction:"auto",inputClass:s.default.TouchMouseInput}),this.connect(this.model.change,()=>this.render()),this._hammer.on("tap",t=>{var e;(null===(e=this._menu)||void 0===e?void 0:e.is_open)?this._menu.hide():t.target==this.el&&this._clicked()}),this._hammer.on("press",()=>this._pressed())}remove(){var t;this._hammer.destroy(),null===(t=this._menu)||void 0===t||t.remove(),super.remove()}styles(){return[...super.styles(),m.default,d.default,p.default]}css_classes(){return super.css_classes().concat(c.bk_toolbar_button)}render(){r.empty(this.el);const t=this.model.computed_icon;_.isString(t)&&(u.startsWith(t,"data:image")?this.el.style.backgroundImage="url('"+t+"')":this.el.classList.add(t)),this.el.title=this.model.tooltip,null!=this._menu&&this.root.el.appendChild(this._menu.el)}_pressed(){var t;const{left:e,top:o,right:i,bottom:s}=this.el.getBoundingClientRect(),n=(()=>{switch(this.parent.model.toolbar_location){case"right":return{right:e,top:o};case"left":return{left:i,top:o};case"above":return{left:e,top:s};case"below":return{left:e,bottom:o}}})();null===(t=this._menu)||void 0===t||t.toggle(n)}}o.ButtonToolButtonView=g,g.__name__="ButtonToolButtonView";class v extends l.ToolView{}o.ButtonToolView=v,v.__name__="ButtonToolView";class b extends l.Tool{constructor(t){super(t)}static init_ButtonTool(){this.internal({disabled:[a.Boolean,!1]})}get tooltip(){return this.tool_name}get computed_icon(){return this.icon}get menu(){return null}}o.ButtonTool=b,b.__name__="ButtonTool",b.init_ButtonTool()},
function _(t,e,n){
/*! Hammer.JS - v2.0.7 - 2016-04-22
     * http://hammerjs.github.io/
     *
     * Copyright (c) 2016 Jorik Tangelder;
     * Licensed under the MIT license */
!function(t,n,i,r){"use strict";var s,o=["","webkit","Moz","MS","ms","o"],a=n.createElement("div"),h=Math.round,u=Math.abs,c=Date.now;function l(t,e,n){return setTimeout(y(t,n),e)}function p(t,e,n){return!!Array.isArray(t)&&(f(t,n[e],n),!0)}function f(t,e,n){var i;if(t)if(t.forEach)t.forEach(e,n);else if(void 0!==t.length)for(i=0;i<t.length;)e.call(n,t[i],i,t),i++;else for(i in t)t.hasOwnProperty(i)&&e.call(n,t[i],i,t)}function v(e,n,i){var r="DEPRECATED METHOD: "+n+"\n"+i+" AT \n";return function(){var n=new Error("get-stack-trace"),i=n&&n.stack?n.stack.replace(/^[^\(]+?[\n$]/gm,"").replace(/^\s+at\s+/gm,"").replace(/^Object.<anonymous>\s*\(/gm,"{anonymous}()@"):"Unknown Stack Trace",s=t.console&&(t.console.warn||t.console.log);return s&&s.call(t.console,r,i),e.apply(this,arguments)}}s="function"!=typeof Object.assign?function(t){if(null==t)throw new TypeError("Cannot convert undefined or null to object");for(var e=Object(t),n=1;n<arguments.length;n++){var i=arguments[n];if(null!=i)for(var r in i)i.hasOwnProperty(r)&&(e[r]=i[r])}return e}:Object.assign;var d=v((function(t,e,n){for(var i=Object.keys(e),r=0;r<i.length;)(!n||n&&void 0===t[i[r]])&&(t[i[r]]=e[i[r]]),r++;return t}),"extend","Use `assign`."),m=v((function(t,e){return d(t,e,!0)}),"merge","Use `assign`.");function g(t,e,n){var i,r=e.prototype;(i=t.prototype=Object.create(r)).constructor=t,i._super=r,n&&s(i,n)}function y(t,e){return function(){return t.apply(e,arguments)}}function T(t,e){return"function"==typeof t?t.apply(e&&e[0]||void 0,e):t}function E(t,e){return void 0===t?e:t}function I(t,e,n){f(S(e),(function(e){t.addEventListener(e,n,!1)}))}function A(t,e,n){f(S(e),(function(e){t.removeEventListener(e,n,!1)}))}function _(t,e){for(;t;){if(t==e)return!0;t=t.parentNode}return!1}function C(t,e){return t.indexOf(e)>-1}function S(t){return t.trim().split(/\s+/g)}function b(t,e,n){if(t.indexOf&&!n)return t.indexOf(e);for(var i=0;i<t.length;){if(n&&t[i][n]==e||!n&&t[i]===e)return i;i++}return-1}function x(t){return Array.prototype.slice.call(t,0)}function P(t,e,n){for(var i=[],r=[],s=0;s<t.length;){var o=e?t[s][e]:t[s];b(r,o)<0&&i.push(t[s]),r[s]=o,s++}return n&&(i=e?i.sort((function(t,n){return t[e]>n[e]})):i.sort()),i}function D(t,e){for(var n,i,r=e[0].toUpperCase()+e.slice(1),s=0;s<o.length;){if((i=(n=o[s])?n+r:e)in t)return i;s++}}var w=1;function O(e){var n=e.ownerDocument||e;return n.defaultView||n.parentWindow||t}var R="ontouchstart"in t,M=void 0!==D(t,"PointerEvent"),z=R&&/mobile|tablet|ip(ad|hone|od)|android/i.test(navigator.userAgent),N=["x","y"],X=["clientX","clientY"];function Y(t,e){var n=this;this.manager=t,this.callback=e,this.element=t.element,this.target=t.options.inputTarget,this.domHandler=function(e){T(t.options.enable,[t])&&n.handler(e)},this.init()}function F(t,e,n){var i=n.pointers.length,r=n.changedPointers.length,s=1&e&&i-r==0,o=12&e&&i-r==0;n.isFirst=!!s,n.isFinal=!!o,s&&(t.session={}),n.eventType=e,function(t,e){var n=t.session,i=e.pointers,r=i.length;n.firstInput||(n.firstInput=W(e));r>1&&!n.firstMultiple?n.firstMultiple=W(e):1===r&&(n.firstMultiple=!1);var s=n.firstInput,o=n.firstMultiple,a=o?o.center:s.center,h=e.center=q(i);e.timeStamp=c(),e.deltaTime=e.timeStamp-s.timeStamp,e.angle=U(a,h),e.distance=L(a,h),function(t,e){var n=e.center,i=t.offsetDelta||{},r=t.prevDelta||{},s=t.prevInput||{};1!==e.eventType&&4!==s.eventType||(r=t.prevDelta={x:s.deltaX||0,y:s.deltaY||0},i=t.offsetDelta={x:n.x,y:n.y});e.deltaX=r.x+(n.x-i.x),e.deltaY=r.y+(n.y-i.y)}(n,e),e.offsetDirection=H(e.deltaX,e.deltaY);var l=k(e.deltaTime,e.deltaX,e.deltaY);e.overallVelocityX=l.x,e.overallVelocityY=l.y,e.overallVelocity=u(l.x)>u(l.y)?l.x:l.y,e.scale=o?(p=o.pointers,f=i,L(f[0],f[1],X)/L(p[0],p[1],X)):1,e.rotation=o?function(t,e){return U(e[1],e[0],X)+U(t[1],t[0],X)}(o.pointers,i):0,e.maxPointers=n.prevInput?e.pointers.length>n.prevInput.maxPointers?e.pointers.length:n.prevInput.maxPointers:e.pointers.length,function(t,e){var n,i,r,s,o=t.lastInterval||e,a=e.timeStamp-o.timeStamp;if(8!=e.eventType&&(a>25||void 0===o.velocity)){var h=e.deltaX-o.deltaX,c=e.deltaY-o.deltaY,l=k(a,h,c);i=l.x,r=l.y,n=u(l.x)>u(l.y)?l.x:l.y,s=H(h,c),t.lastInterval=e}else n=o.velocity,i=o.velocityX,r=o.velocityY,s=o.direction;e.velocity=n,e.velocityX=i,e.velocityY=r,e.direction=s}(n,e);var p,f;var v=t.element;_(e.srcEvent.target,v)&&(v=e.srcEvent.target);e.target=v}(t,n),t.emit("hammer.input",n),t.recognize(n),t.session.prevInput=n}function W(t){for(var e=[],n=0;n<t.pointers.length;)e[n]={clientX:h(t.pointers[n].clientX),clientY:h(t.pointers[n].clientY)},n++;return{timeStamp:c(),pointers:e,center:q(e),deltaX:t.deltaX,deltaY:t.deltaY}}function q(t){var e=t.length;if(1===e)return{x:h(t[0].clientX),y:h(t[0].clientY)};for(var n=0,i=0,r=0;r<e;)n+=t[r].clientX,i+=t[r].clientY,r++;return{x:h(n/e),y:h(i/e)}}function k(t,e,n){return{x:e/t||0,y:n/t||0}}function H(t,e){return t===e?1:u(t)>=u(e)?t<0?2:4:e<0?8:16}function L(t,e,n){n||(n=N);var i=e[n[0]]-t[n[0]],r=e[n[1]]-t[n[1]];return Math.sqrt(i*i+r*r)}function U(t,e,n){n||(n=N);var i=e[n[0]]-t[n[0]],r=e[n[1]]-t[n[1]];return 180*Math.atan2(r,i)/Math.PI}Y.prototype={handler:function(){},init:function(){this.evEl&&I(this.element,this.evEl,this.domHandler),this.evTarget&&I(this.target,this.evTarget,this.domHandler),this.evWin&&I(O(this.element),this.evWin,this.domHandler)},destroy:function(){this.evEl&&A(this.element,this.evEl,this.domHandler),this.evTarget&&A(this.target,this.evTarget,this.domHandler),this.evWin&&A(O(this.element),this.evWin,this.domHandler)}};var V={mousedown:1,mousemove:2,mouseup:4};function j(){this.evEl="mousedown",this.evWin="mousemove mouseup",this.pressed=!1,Y.apply(this,arguments)}g(j,Y,{handler:function(t){var e=V[t.type];1&e&&0===t.button&&(this.pressed=!0),2&e&&1!==t.which&&(e=4),this.pressed&&(4&e&&(this.pressed=!1),this.callback(this.manager,e,{pointers:[t],changedPointers:[t],pointerType:"mouse",srcEvent:t}))}});var G={pointerdown:1,pointermove:2,pointerup:4,pointercancel:8,pointerout:8},Z={2:"touch",3:"pen",4:"mouse",5:"kinect"},B="pointerdown",$="pointermove pointerup pointercancel";function J(){this.evEl=B,this.evWin=$,Y.apply(this,arguments),this.store=this.manager.session.pointerEvents=[]}t.MSPointerEvent&&!t.PointerEvent&&(B="MSPointerDown",$="MSPointerMove MSPointerUp MSPointerCancel"),g(J,Y,{handler:function(t){var e=this.store,n=!1,i=t.type.toLowerCase().replace("ms",""),r=G[i],s=Z[t.pointerType]||t.pointerType,o="touch"==s,a=b(e,t.pointerId,"pointerId");1&r&&(0===t.button||o)?a<0&&(e.push(t),a=e.length-1):12&r&&(n=!0),a<0||(e[a]=t,this.callback(this.manager,r,{pointers:e,changedPointers:[t],pointerType:s,srcEvent:t}),n&&e.splice(a,1))}});var K={touchstart:1,touchmove:2,touchend:4,touchcancel:8};function Q(){this.evTarget="touchstart",this.evWin="touchstart touchmove touchend touchcancel",this.started=!1,Y.apply(this,arguments)}function tt(t,e){var n=x(t.touches),i=x(t.changedTouches);return 12&e&&(n=P(n.concat(i),"identifier",!0)),[n,i]}g(Q,Y,{handler:function(t){var e=K[t.type];if(1===e&&(this.started=!0),this.started){var n=tt.call(this,t,e);12&e&&n[0].length-n[1].length==0&&(this.started=!1),this.callback(this.manager,e,{pointers:n[0],changedPointers:n[1],pointerType:"touch",srcEvent:t})}}});var et={touchstart:1,touchmove:2,touchend:4,touchcancel:8};function nt(){this.evTarget="touchstart touchmove touchend touchcancel",this.targetIds={},Y.apply(this,arguments)}function it(t,e){var n=x(t.touches),i=this.targetIds;if(3&e&&1===n.length)return i[n[0].identifier]=!0,[n,n];var r,s,o=x(t.changedTouches),a=[],h=this.target;if(s=n.filter((function(t){return _(t.target,h)})),1===e)for(r=0;r<s.length;)i[s[r].identifier]=!0,r++;for(r=0;r<o.length;)i[o[r].identifier]&&a.push(o[r]),12&e&&delete i[o[r].identifier],r++;return a.length?[P(s.concat(a),"identifier",!0),a]:void 0}g(nt,Y,{handler:function(t){var e=et[t.type],n=it.call(this,t,e);n&&this.callback(this.manager,e,{pointers:n[0],changedPointers:n[1],pointerType:"touch",srcEvent:t})}});function rt(){Y.apply(this,arguments);var t=y(this.handler,this);this.touch=new nt(this.manager,t),this.mouse=new j(this.manager,t),this.primaryTouch=null,this.lastTouches=[]}function st(t,e){1&t?(this.primaryTouch=e.changedPointers[0].identifier,ot.call(this,e)):12&t&&ot.call(this,e)}function ot(t){var e=t.changedPointers[0];if(e.identifier===this.primaryTouch){var n={x:e.clientX,y:e.clientY};this.lastTouches.push(n);var i=this.lastTouches;setTimeout((function(){var t=i.indexOf(n);t>-1&&i.splice(t,1)}),2500)}}function at(t){for(var e=t.srcEvent.clientX,n=t.srcEvent.clientY,i=0;i<this.lastTouches.length;i++){var r=this.lastTouches[i],s=Math.abs(e-r.x),o=Math.abs(n-r.y);if(s<=25&&o<=25)return!0}return!1}g(rt,Y,{handler:function(t,e,n){var i="touch"==n.pointerType,r="mouse"==n.pointerType;if(!(r&&n.sourceCapabilities&&n.sourceCapabilities.firesTouchEvents)){if(i)st.call(this,e,n);else if(r&&at.call(this,n))return;this.callback(t,e,n)}},destroy:function(){this.touch.destroy(),this.mouse.destroy()}});var ht=D(a.style,"touchAction"),ut=void 0!==ht,ct=function(){if(!ut)return!1;var e={},n=t.CSS&&t.CSS.supports;return["auto","manipulation","pan-y","pan-x","pan-x pan-y","none"].forEach((function(i){e[i]=!n||t.CSS.supports("touch-action",i)})),e}();function lt(t,e){this.manager=t,this.set(e)}lt.prototype={set:function(t){"compute"==t&&(t=this.compute()),ut&&this.manager.element.style&&ct[t]&&(this.manager.element.style[ht]=t),this.actions=t.toLowerCase().trim()},update:function(){this.set(this.manager.options.touchAction)},compute:function(){var t=[];return f(this.manager.recognizers,(function(e){T(e.options.enable,[e])&&(t=t.concat(e.getTouchAction()))})),function(t){if(C(t,"none"))return"none";var e=C(t,"pan-x"),n=C(t,"pan-y");if(e&&n)return"none";if(e||n)return e?"pan-x":"pan-y";if(C(t,"manipulation"))return"manipulation";return"auto"}(t.join(" "))},preventDefaults:function(t){var e=t.srcEvent,n=t.offsetDirection;if(this.manager.session.prevented)e.preventDefault();else{var i=this.actions,r=C(i,"none")&&!ct.none,s=C(i,"pan-y")&&!ct["pan-y"],o=C(i,"pan-x")&&!ct["pan-x"];if(r){var a=1===t.pointers.length,h=t.distance<2,u=t.deltaTime<250;if(a&&h&&u)return}if(!o||!s)return r||s&&6&n||o&&24&n?this.preventSrc(e):void 0}},preventSrc:function(t){this.manager.session.prevented=!0,t.preventDefault()}};function pt(t){this.options=s({},this.defaults,t||{}),this.id=w++,this.manager=null,this.options.enable=E(this.options.enable,!0),this.state=1,this.simultaneous={},this.requireFail=[]}function ft(t){return 16&t?"cancel":8&t?"end":4&t?"move":2&t?"start":""}function vt(t){return 16==t?"down":8==t?"up":2==t?"left":4==t?"right":""}function dt(t,e){var n=e.manager;return n?n.get(t):t}function mt(){pt.apply(this,arguments)}function gt(){mt.apply(this,arguments),this.pX=null,this.pY=null}function yt(){mt.apply(this,arguments)}function Tt(){pt.apply(this,arguments),this._timer=null,this._input=null}function Et(){mt.apply(this,arguments)}function It(){mt.apply(this,arguments)}function At(){pt.apply(this,arguments),this.pTime=!1,this.pCenter=!1,this._timer=null,this._input=null,this.count=0}function _t(t,e){return(e=e||{}).recognizers=E(e.recognizers,_t.defaults.preset),new Ct(t,e)}pt.prototype={defaults:{},set:function(t){return s(this.options,t),this.manager&&this.manager.touchAction.update(),this},recognizeWith:function(t){if(p(t,"recognizeWith",this))return this;var e=this.simultaneous;return e[(t=dt(t,this)).id]||(e[t.id]=t,t.recognizeWith(this)),this},dropRecognizeWith:function(t){return p(t,"dropRecognizeWith",this)||(t=dt(t,this),delete this.simultaneous[t.id]),this},requireFailure:function(t){if(p(t,"requireFailure",this))return this;var e=this.requireFail;return-1===b(e,t=dt(t,this))&&(e.push(t),t.requireFailure(this)),this},dropRequireFailure:function(t){if(p(t,"dropRequireFailure",this))return this;t=dt(t,this);var e=b(this.requireFail,t);return e>-1&&this.requireFail.splice(e,1),this},hasRequireFailures:function(){return this.requireFail.length>0},canRecognizeWith:function(t){return!!this.simultaneous[t.id]},emit:function(t){var e=this,n=this.state;function i(n){e.manager.emit(n,t)}n<8&&i(e.options.event+ft(n)),i(e.options.event),t.additionalEvent&&i(t.additionalEvent),n>=8&&i(e.options.event+ft(n))},tryEmit:function(t){if(this.canEmit())return this.emit(t);this.state=32},canEmit:function(){for(var t=0;t<this.requireFail.length;){if(!(33&this.requireFail[t].state))return!1;t++}return!0},recognize:function(t){var e=s({},t);if(!T(this.options.enable,[this,e]))return this.reset(),void(this.state=32);56&this.state&&(this.state=1),this.state=this.process(e),30&this.state&&this.tryEmit(e)},process:function(t){},getTouchAction:function(){},reset:function(){}},g(mt,pt,{defaults:{pointers:1},attrTest:function(t){var e=this.options.pointers;return 0===e||t.pointers.length===e},process:function(t){var e=this.state,n=t.eventType,i=6&e,r=this.attrTest(t);return i&&(8&n||!r)?16|e:i||r?4&n?8|e:2&e?4|e:2:32}}),g(gt,mt,{defaults:{event:"pan",threshold:10,pointers:1,direction:30},getTouchAction:function(){var t=this.options.direction,e=[];return 6&t&&e.push("pan-y"),24&t&&e.push("pan-x"),e},directionTest:function(t){var e=this.options,n=!0,i=t.distance,r=t.direction,s=t.deltaX,o=t.deltaY;return r&e.direction||(6&e.direction?(r=0===s?1:s<0?2:4,n=s!=this.pX,i=Math.abs(t.deltaX)):(r=0===o?1:o<0?8:16,n=o!=this.pY,i=Math.abs(t.deltaY))),t.direction=r,n&&i>e.threshold&&r&e.direction},attrTest:function(t){return mt.prototype.attrTest.call(this,t)&&(2&this.state||!(2&this.state)&&this.directionTest(t))},emit:function(t){this.pX=t.deltaX,this.pY=t.deltaY;var e=vt(t.direction);e&&(t.additionalEvent=this.options.event+e),this._super.emit.call(this,t)}}),g(yt,mt,{defaults:{event:"pinch",threshold:0,pointers:2},getTouchAction:function(){return["none"]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.scale-1)>this.options.threshold||2&this.state)},emit:function(t){if(1!==t.scale){var e=t.scale<1?"in":"out";t.additionalEvent=this.options.event+e}this._super.emit.call(this,t)}}),g(Tt,pt,{defaults:{event:"press",pointers:1,time:251,threshold:9},getTouchAction:function(){return["auto"]},process:function(t){var e=this.options,n=t.pointers.length===e.pointers,i=t.distance<e.threshold,r=t.deltaTime>e.time;if(this._input=t,!i||!n||12&t.eventType&&!r)this.reset();else if(1&t.eventType)this.reset(),this._timer=l((function(){this.state=8,this.tryEmit()}),e.time,this);else if(4&t.eventType)return 8;return 32},reset:function(){clearTimeout(this._timer)},emit:function(t){8===this.state&&(t&&4&t.eventType?this.manager.emit(this.options.event+"up",t):(this._input.timeStamp=c(),this.manager.emit(this.options.event,this._input)))}}),g(Et,mt,{defaults:{event:"rotate",threshold:0,pointers:2},getTouchAction:function(){return["none"]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.rotation)>this.options.threshold||2&this.state)}}),g(It,mt,{defaults:{event:"swipe",threshold:10,velocity:.3,direction:30,pointers:1},getTouchAction:function(){return gt.prototype.getTouchAction.call(this)},attrTest:function(t){var e,n=this.options.direction;return 30&n?e=t.overallVelocity:6&n?e=t.overallVelocityX:24&n&&(e=t.overallVelocityY),this._super.attrTest.call(this,t)&&n&t.offsetDirection&&t.distance>this.options.threshold&&t.maxPointers==this.options.pointers&&u(e)>this.options.velocity&&4&t.eventType},emit:function(t){var e=vt(t.offsetDirection);e&&this.manager.emit(this.options.event+e,t),this.manager.emit(this.options.event,t)}}),g(At,pt,{defaults:{event:"tap",pointers:1,taps:1,interval:300,time:250,threshold:9,posThreshold:10},getTouchAction:function(){return["manipulation"]},process:function(t){var e=this.options,n=t.pointers.length===e.pointers,i=t.distance<e.threshold,r=t.deltaTime<e.time;if(this.reset(),1&t.eventType&&0===this.count)return this.failTimeout();if(i&&r&&n){if(4!=t.eventType)return this.failTimeout();var s=!this.pTime||t.timeStamp-this.pTime<e.interval,o=!this.pCenter||L(this.pCenter,t.center)<e.posThreshold;if(this.pTime=t.timeStamp,this.pCenter=t.center,o&&s?this.count+=1:this.count=1,this._input=t,0===this.count%e.taps)return this.hasRequireFailures()?(this._timer=l((function(){this.state=8,this.tryEmit()}),e.interval,this),2):8}return 32},failTimeout:function(){return this._timer=l((function(){this.state=32}),this.options.interval,this),32},reset:function(){clearTimeout(this._timer)},emit:function(){8==this.state&&(this._input.tapCount=this.count,this.manager.emit(this.options.event,this._input))}}),_t.VERSION="2.0.7",_t.defaults={domEvents:!1,touchAction:"compute",enable:!0,inputTarget:null,inputClass:null,preset:[[Et,{enable:!1}],[yt,{enable:!1},["rotate"]],[It,{direction:6}],[gt,{direction:6},["swipe"]],[At],[At,{event:"doubletap",taps:2},["tap"]],[Tt]],cssProps:{userSelect:"none",touchSelect:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}};function Ct(t,e){var n;this.options=s({},_t.defaults,e||{}),this.options.inputTarget=this.options.inputTarget||t,this.handlers={},this.session={},this.recognizers=[],this.oldCssProps={},this.element=t,this.input=new((n=this).options.inputClass||(M?J:z?nt:R?rt:j))(n,F),this.touchAction=new lt(this,this.options.touchAction),St(this,!0),f(this.options.recognizers,(function(t){var e=this.add(new t[0](t[1]));t[2]&&e.recognizeWith(t[2]),t[3]&&e.requireFailure(t[3])}),this)}function St(t,e){var n,i=t.element;i.style&&(f(t.options.cssProps,(function(r,s){n=D(i.style,s),e?(t.oldCssProps[n]=i.style[n],i.style[n]=r):i.style[n]=t.oldCssProps[n]||""})),e||(t.oldCssProps={}))}Ct.prototype={set:function(t){return s(this.options,t),t.touchAction&&this.touchAction.update(),t.inputTarget&&(this.input.destroy(),this.input.target=t.inputTarget,this.input.init()),this},stop:function(t){this.session.stopped=t?2:1},recognize:function(t){var e=this.session;if(!e.stopped){var n;this.touchAction.preventDefaults(t);var i=this.recognizers,r=e.curRecognizer;(!r||r&&8&r.state)&&(r=e.curRecognizer=null);for(var s=0;s<i.length;)n=i[s],2===e.stopped||r&&n!=r&&!n.canRecognizeWith(r)?n.reset():n.recognize(t),!r&&14&n.state&&(r=e.curRecognizer=n),s++}},get:function(t){if(t instanceof pt)return t;for(var e=this.recognizers,n=0;n<e.length;n++)if(e[n].options.event==t)return e[n];return null},add:function(t){if(p(t,"add",this))return this;var e=this.get(t.options.event);return e&&this.remove(e),this.recognizers.push(t),t.manager=this,this.touchAction.update(),t},remove:function(t){if(p(t,"remove",this))return this;if(t=this.get(t)){var e=this.recognizers,n=b(e,t);-1!==n&&(e.splice(n,1),this.touchAction.update())}return this},on:function(t,e){if(void 0!==t&&void 0!==e){var n=this.handlers;return f(S(t),(function(t){n[t]=n[t]||[],n[t].push(e)})),this}},off:function(t,e){if(void 0!==t){var n=this.handlers;return f(S(t),(function(t){e?n[t]&&n[t].splice(b(n[t],e),1):delete n[t]})),this}},emit:function(t,e){this.options.domEvents&&function(t,e){var i=n.createEvent("Event");i.initEvent(t,!0,!0),i.gesture=e,e.target.dispatchEvent(i)}(t,e);var i=this.handlers[t]&&this.handlers[t].slice();if(i&&i.length){e.type=t,e.preventDefault=function(){e.srcEvent.preventDefault()};for(var r=0;r<i.length;)i[r](e),r++}},destroy:function(){this.element&&St(this,!1),this.handlers={},this.session={},this.input.destroy(),this.element=null}},s(_t,{INPUT_START:1,INPUT_MOVE:2,INPUT_END:4,INPUT_CANCEL:8,STATE_POSSIBLE:1,STATE_BEGAN:2,STATE_CHANGED:4,STATE_ENDED:8,STATE_RECOGNIZED:8,STATE_CANCELLED:16,STATE_FAILED:32,DIRECTION_NONE:1,DIRECTION_LEFT:2,DIRECTION_RIGHT:4,DIRECTION_UP:8,DIRECTION_DOWN:16,DIRECTION_HORIZONTAL:6,DIRECTION_VERTICAL:24,DIRECTION_ALL:30,Manager:Ct,Input:Y,TouchAction:lt,TouchInput:nt,MouseInput:j,PointerEventInput:J,TouchMouseInput:rt,SingleTouchInput:Q,Recognizer:pt,AttrRecognizer:mt,Tap:At,Pan:gt,Swipe:It,Pinch:yt,Rotate:Et,Press:Tt,on:I,off:A,each:f,merge:m,extend:d,assign:s,inherit:g,bindFn:y,prefixed:D}),(void 0!==t?t:"undefined"!=typeof self?self:{}).Hammer=_t,"function"==typeof define&&define.amd?define((function(){return _t})):void 0!==e&&e.exports?e.exports=_t:t.Hammer=_t}(window,document)},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const n=t(1).__importStar(t(18)),o=t(71),s=t(9),a=t(81);class r extends o.View{get plot_view(){return this.parent}get plot_model(){return this.parent.model}connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,()=>{this.model.active?this.activate():this.deactivate()})}activate(){}deactivate(){}}i.ToolView=r,r.__name__="ToolView";class _ extends a.Model{constructor(t){super(t)}static init_Tool(){this.prototype._known_aliases=new Map,this.internal({active:[n.Boolean,!1]})}get synthetic_renderers(){return[]}_get_dim_tooltip(t,e){switch(e){case"width":return t+" (x-axis)";case"height":return t+" (y-axis)";case"both":return t}}_get_dim_limits([t,e],[i,n],o,a){const r=o.bbox.h_range;let _;"width"==a||"both"==a?(_=[s.min([t,i]),s.max([t,i])],_=[s.max([_[0],r.start]),s.min([_[1],r.end])]):_=[r.start,r.end];const l=o.bbox.v_range;let c;return"height"==a||"both"==a?(c=[s.min([e,n]),s.max([e,n])],c=[s.max([c[0],l.start]),s.min([c[1],l.end])]):c=[l.start,l.end],[_,c]}static register_alias(t,e){this.prototype._known_aliases.set(t,e)}static from_string(t){const e=this.prototype._known_aliases.get(t);if(null!=e)return e();{const e=[...this.prototype._known_aliases.keys()];throw new Error(`unexpected tool name '${t}', possible tools are ${e.join(", ")}`)}}}i.Tool=_,_.__name__="Tool",_.init_Tool()},
function _(o,b,t){Object.defineProperty(t,"__esModule",{value:!0}),t.bk_toolbar="bk-toolbar",t.bk_toolbar_hidden="bk-toolbar-hidden",t.bk_toolbar_button="bk-toolbar-button",t.bk_button_bar="bk-button-bar",t.bk_toolbar_button_custom_action="bk-toolbar-button-custom-action"},
function _(o,b,t){Object.defineProperty(t,"__esModule",{value:!0});t.default='\n.bk-root .bk-toolbar-hidden {\n  visibility: hidden;\n  opacity: 0;\n  transition: visibility 0.3s linear, opacity 0.3s linear;\n}\n.bk-root .bk-toolbar,\n.bk-root .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-wrap: nowrap;\n  -webkit-flex-wrap: nowrap;\n  align-items: center;\n  -webkit-align-items: center;\n  user-select: none;\n  -ms-user-select: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n}\n.bk-root .bk-toolbar .bk-logo {\n  flex-shrink: 0;\n  -webkit-flex-shrink: 0;\n}\n.bk-root .bk-toolbar.bk-above,\n.bk-root .bk-toolbar.bk-below {\n  flex-direction: row;\n  -webkit-flex-direction: row;\n  justify-content: flex-end;\n  -webkit-justify-content: flex-end;\n}\n.bk-root .bk-toolbar.bk-above .bk-button-bar,\n.bk-root .bk-toolbar.bk-below .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-direction: row;\n  -webkit-flex-direction: row;\n}\n.bk-root .bk-toolbar.bk-above .bk-logo,\n.bk-root .bk-toolbar.bk-below .bk-logo {\n  order: 1;\n  -webkit-order: 1;\n  margin-left: 5px;\n  margin-right: 0px;\n}\n.bk-root .bk-toolbar.bk-left,\n.bk-root .bk-toolbar.bk-right {\n  flex-direction: column;\n  -webkit-flex-direction: column;\n  justify-content: flex-start;\n  -webkit-justify-content: flex-start;\n}\n.bk-root .bk-toolbar.bk-left .bk-button-bar,\n.bk-root .bk-toolbar.bk-right .bk-button-bar {\n  display: flex;\n  display: -webkit-flex;\n  flex-direction: column;\n  -webkit-flex-direction: column;\n}\n.bk-root .bk-toolbar.bk-left .bk-logo,\n.bk-root .bk-toolbar.bk-right .bk-logo {\n  order: 0;\n  -webkit-order: 0;\n  margin-bottom: 5px;\n  margin-top: 0px;\n}\n.bk-root .bk-toolbar-button {\n  width: 30px;\n  height: 30px;\n  cursor: pointer;\n  background-size: 60% 60%;\n  background-origin: border-box;\n  background-color: transparent;\n  background-repeat: no-repeat;\n  background-position: center center;\n}\n.bk-root .bk-toolbar-button:hover {\n  background-color: rgba(192, 192, 192, 0.15);\n}\n.bk-root .bk-toolbar-button:focus {\n  outline: none;\n}\n.bk-root .bk-toolbar-button::-moz-focus-inner {\n  border: 0;\n}\n.bk-root .bk-toolbar.bk-above .bk-toolbar-button {\n  border-bottom: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-above .bk-toolbar-button.bk-active {\n  border-bottom-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-below .bk-toolbar-button {\n  border-top: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-below .bk-toolbar-button.bk-active {\n  border-top-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-right .bk-toolbar-button {\n  border-left: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-right .bk-toolbar-button.bk-active {\n  border-left-color: #26aae1;\n}\n.bk-root .bk-toolbar.bk-left .bk-toolbar-button {\n  border-right: 2px solid transparent;\n}\n.bk-root .bk-toolbar.bk-left .bk-toolbar-button.bk-active {\n  border-right-color: #26aae1;\n}\n.bk-root .bk-button-bar + .bk-button-bar:before {\n  content: " ";\n  display: inline-block;\n  background-color: lightgray;\n}\n.bk-root .bk-toolbar.bk-above .bk-button-bar + .bk-button-bar:before,\n.bk-root .bk-toolbar.bk-below .bk-button-bar + .bk-button-bar:before {\n  height: 10px;\n  width: 1px;\n}\n.bk-root .bk-toolbar.bk-left .bk-button-bar + .bk-button-bar:before,\n.bk-root .bk-toolbar.bk-right .bk-button-bar + .bk-button-bar:before {\n  height: 1px;\n  width: 10px;\n}\n'},
function _(A,g,C){Object.defineProperty(C,"__esModule",{value:!0});C.default='\n.bk-root .bk-tool-icon-copy-to-clipboard {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUSDBoBvcHQeQAAAG9JREFUWMNjXLhsJcNAAiaGAQYwB/xHwh/Q+ITEkfHQCwEWND4jmeb8H/JpgBwfI6cNBhLSEkqaGXRpgFRAcZoZsmlg1AGjDhh1wKgDRh0w6gCaVcf/R2wIkNqw+D9s0wADvUNiyIYA47BJAwPuAAAj/Cjd0TCN6wAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-replace-mode {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxokK3gniQAAAHpJREFUWMNjXLhsJcNAAiaGAQajDhhwB7DgEP+PxmeksvjgDwFcLmYkUh2hkBj8IcBIZXsYh1w2/I8v3sgAOM0bLYhGc8GgrwuICgldfQO88pcvXvg/aOuCUQeM5oLRuoCFCJcTbOMh5XOiW0JDNhdQS3y0IBp1ABwAAF8KGrhC1Eg6AAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-append-mode {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkZWD04WwAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAAAoUlEQVRYw+1WQQ6AIAwrhO8Y/bIXEz9jIMSDr8ETCUEPQzA4pMeFLKNbu4l5WR0CDOMEALBGIzMuQIBEZQjPgP9JLjwTfBjY9sO9lZsFA9IafZng3BlIyVefgd8XQFZBAWe8jfNxwsDhir6rzoCiPiy1K+J8/FRQemv2XfAdFcQ9znU4Viqg9ta1qYJ+D1BnAIBrkgGVOrXNqUA9rbyZm/AEzFh4jEeY/soAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-intersect-mode {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkrkOpp2wAAAPhJREFUWMPtV1EKwjAMTUavI3oawR/vtn5srJdREfzwMvHHQlcT2mpdMzFfWxiP5r2+JMN+mAiCOB72CABgR1cln4oOGocJnuMTSxWk8jMm7OggYkYXA9gPE3uyd8NXHONJ+eYMdE/NqCJmEZ5ZqlJJ4sUksKN7cYSaPoCZFWR1QI+Xm1fBACU63Cw22x0AAJxudwrffVwvZ+JmQdAHZkw0d4EpAMCw8k87pMdbnwtizQumJYv3nwV6XOA1qbUT/oQLUJgFRbsiNwFVucBIlyR3p0tdMp+XmFjfLKi1LatyAXtCRjPWBdL3Ke3VuACJKFfDr/xFN2fgAR/Go0qaLlmEAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-subtract-mode {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxgsF5XNOQAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAABFUlEQVRYw9VWUQqDMAxNpWfxQxD1MoP97G7zQ5mH2RTZYLtM9lWoMbXtxLXNX4OG9r28l4hrd0PQoqxqAACYpxH25C/nkwCHyCBwSPoS09k1T5Fo+4EiExcC4v584xGFmyIXHBLRISAVZyZufUPVa4rcrwmPDgr93ylo+2GliLRUYHK6th/o/6r7nfLpqaCsagEA8Hh9FmcNKeRmgeYDC+SCq0B6FFi8/BcV6BdR9cL3gCv3ijPKOacsn3rBEcjmaVxpfGcg4wHxzgJJnc6241Hn23DERFRAu1bNcWa3Q0uXi62XR6sCaWoSejbtdLYmU3kTEunNgj0bUbQqYG/IcMaqwPS9jftoVCAQ0ZVDJwf0zQdH4AsyW6fpQu4YegAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-clear-selection {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUGEhcuan3d3wAAAoRJREFUWMPtlzFP3EAQhd+b3TNSzg0N5TWXLkJQUUaKhIQ4fgP/g5ArrriE/I3opEgRrZtIVJR0FJQ010SioUmEZHtnUpwN9gWHGA5BJCy58MraffvmfZ41v3z9hqe8BE98vQh4cgG+Ydzmnrng8efvQJNi/uN7dznx/B3ggtfhf4ehNdUttRzBDIm/2VTiiWCG1HK0nc+3UWtq8BQIiEEakEQOADBIA4QCQmBqoHBhFNR27ikQSmGdYCdTqCpEHMDZmEKRWUBEv1gBDg5SzRJnpopILWICgWuRYflLamuzxB2BmtYqSRIka5VWU8QduXO+1hRc5YZu5GAwmP2ZJzND0IBu5HCV2+NQcAhAVRsnC2IbPzPdSjzd6to6VtfWkXi6YLaVWr7xoAwkfpb8MnC3SH7rKSMBe4M0jA/OTicFIbtCGRIyNbURhcf3ErCd6YwA1m0HgAxhw1NGQnlXBHG4kylVlSJuH0RfIP2CkL2I/qS1gIAAQiBl1QwFggIHtyxgrxK5PgyfC0JWKoT0HLh8LwoietB4TYKaIl7yeNURxB05UtMxDOcVQlZIrlRKdK6m47gjR/fuBRQihyLArtNeJD50Izcx2Eczu7iFkIug4VM3cpOr3MKDekFED0fWUHv9Zq0kpLnridjhY3XDg7NTN0jDrhO3X7O9Wg7wwyANu4mnayNg3gmbu0tCNoUyBNGv2l4rB9EXynA7082FOxAQLhU6rQVO9T2AvWowFToNCJcPORGxIRcnpjZSKATSU9NxvOQnAPArDSaQoUKnNI4iufkGtD4P3EHIcWZhz4HLceSOyrR3Izf5memPAL2cX3yhAkonysZVaWLBkd9dw1Ivv2a/AYPkK+ty1U1DAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-box-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg0kduFrowAAAIdJREFUWMPtVtEKwCAI9KL//4e9DPZ3+wP3KgOjNZouFYI4C8q7s7DtB1lGIeMoRMRinCLXg/ML3EcFqpjjloOyZxRntxpwQ8HsgHYARKFAtSFrCg3TCdMFCE1BuuALEXJLjC4qENsFVXCESZw38/kWLOkC/K4PcOc/Hj03WkoDT3EaWW9egQul6CUbq90JTwAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-box-zoom {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg82t254aQAAAkBJREFUWMPN11+E1FEUB/DPTFn2qaeIpcSwr5NlUyJiKWVXWUqvlUh/iE3RY9mUekkPPURtLKNRrFJEeuphGfUUaVliiX1aVjGs6aG7+XX9ZnZ+d2fTl2vmnHvPPfeee/79Sk+may2/UQq/q7Qu+bAJoxjHIKqB/wlfUMcMVqI9bLZ+DGIKwzlzQ2GcxCx2xwvKOUKlaHTiX8bHNspjDONHkOmJBW5jIof/FvPh/06MZOb6cRc7cGn1AKUE5cdzlM/gAr5F/O24H3xkFRfxAbVygvK+cIsspjGWo1zgjeFpxL+BvnLw7laBA4xjIFJwrgu52DoVjKdY4HBEX8dSF3JLYe1fe6UcYCii3xWQjdfuSTnAtoheKCC7GNED5Zx4L4qt61jbTLHA94geKSC7P7ZeShQ0Inoi1IJuEOeORooFXkV0FZNdZs5qvFfKAeqYy7nZ6yg//HG0MBfffh71lFrQDCW2EvEP4mt4okZUDftz9rmGZkotmMxJRtlisy+MTniAWrty3AlXw0hFM2TD89l+oNsoOJXjbIs4EpqNtTCLXbiZ0g+M4mFObj8U3vsNjoZCVcmk60ZwthpepLZkB/AsivWfOJZxtpUQHfWib7KWDwzjeegBZJSdKFiE2qJTFFTwElsi/unQ/awXrU4WGMD7nOJxBY/1EO2iYConq93CHT1GOwucjdqnRyFz+VcHmMNefMY9nNkA3SWUOoXhQviSWQ4huLIRFlirFixnQq/XaKXUgg2xQNGv4V7x/RcW+AXPB3h7H1PaiQAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-zoom-in {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsUBmL8iQAAA2JJREFUWMO9l12IlFUYx3//MzPrLpSjkm5oN4FFIWVEl66IQlFYwtLOzozsjHdGRSCRF0sfBEXRVV0FQuQiLm5CZNBFgRRaRLVFhbJ2EdiN5gbK7toObTPn6eYdPTvNzPvOBz5Xh/ec5/n/n89zXtEHmZqeSXSuXBz/3zfdKvBWJHQrwZuRcP0El+QkbQXeBX6WZEgm6TtJk5lM5o4Lc+cV6qpf4Ga20Tm338zeATItVK9Ker6yvPzp4NDQ3+XieGsCU9MzTYumGbhz7m4ze9/MHgvBgItACrgfGAj2jgAvAYs3wlEujjc13kii8YyZrXXOfWhmo9GnFUlvOOemarVapVqtkslksmb2KjARqL62ecuWN9NxbRInzrldAXhV0uFSIfdew7G/gNLU9MwS8CwSmE3Oz88fcXG5blfpqVRq0Ix8VIAAX0XgrVL7HDCHGcCaWrV60LUBN8Dae58aQIxEqcA592I9M610JL0cpG/U9TIHJNKY3RV5z0R+7Nd4HZ0P1g/2RMBuegLAsRMnb4vT8d5vqKfMzOgtAlADrkmqGywmiMBTwfr3dC9j1Xv/r6Tvg/5/5ejxE6cO7M9faVbQZrYNOFSPmqQvVo9FKexvi5uWX58943aM7DwAfBDY+FbSCxP5sdkGx55GeguzrUEXPaSo2pFkAbiSZQCAzZJOmdkjwd6SpB/M7KykQTPbA2wDhoIzRzcNDx9MJwGNIXdJ0mEzmwbujL7dbma7gd03A7lKfnTOvf74nl0r6bonTUbujRSUCrm2d4L3/kvn3JPe+8+BDW2i9o+kT7z3kxP5sYsA6W47oE64TsR7P9tQL4vA2mh9WdIscKxUyJ0M7aR7acOGzikD65EQLEjaa2ZXzMwDFeB6qZBbbLTRE4EGeSaozNOZgYFf8qP7lmIvs354n0qlHpB0T7B9Ogl4IgJJrmjv/SiQjbrkD+BMUkfSbYATPdckrTOzkciWAXOlQu5cYgLdPEIapud9wMOR9zVJH3ViKx333mtHMJvNuoWFhZ3A+ojMcja77njXBEKwJJfTcqUyCIQ34Mf7nnh0paMnXacFuGoC1mr3AtuDfLzd8Zuyl+rfuGn4HLAD+Az4qZQf+61TAj0Noj8vX6oC35SL43u7teG6rf5+iXppwW7/JUL5D03qaFRvvUe+AAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-zoom-out {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsHgty9VwAAA0FJREFUWMO9l09oXFUUxn/fmXlpItppi22k7UJBRSlVkCytSAuKUloIdjKT0El3FXVXdVFKRVAQV7qQohsNwdA0UFvBhYtqUVyIVlRaogtFQVq7qSTVjA3z3nHzBq/jvPmTN/Ss7rv3nvN99/y794kByMzcfE/7picn/jenmwWeRUI3E7wdCRskuCSTdDfwBvCtJEdySV9KOhpF0e0/LF5SqKtBgbv7ZjObcvfXgShD9Zqk5+orKx8Oj4z8NT05kU1gZm6+bdK0Azezu9z9hLs/HoIBvwAF4H5gKFh7B3gBWFY3460kWve4+3oze9fdx9OpVUmvmNlMHMf1RqNBFEUldz8OHAxUX9q6bduryut+Sfvc/Wz62ZD0fK1afjND9y3gGSRwv1GMojstTxUUCoVhdyopEYDzKXjWwZ4FFnEHWBc3Goet00m7lZlZYQixKw0FZnakGZksHUnHgvCN5/KARBH37enpOVg58H13HV0Kxg/kIuD/ngSA2ZMLt3bTSZJkUzNk7k4+D0AM/CGpaXCyBw/sC8Y/qZd2GpZiuL9YLN4Sx/HpoP5/c/exQ1OVq+1yyt13SLoArEsJnMjlgfOffvK3u58Kprab2QezJxfG2iTzUzI70wRPG9jbmpmb95SNB9mpzp7/j2yVdNbdx4K565K+cvfPJQ27+x5gBzAS7Hlvy+jo4WIvoC3kWpcvS3rR3eeAO9K529x9N7C7zX6AC2b28hN7Hl1Vt44niVq13LUjmtlYkiQfA5s6eO+GpDNJkhw9NFX5ueNt2ARodyF1IHIN2JiOl4H16fiKpK+B2Vq1vBAqFAf4IJkGNiIhWJK0192vunsC1IE/a9XycquNXARa5OnApeeioaHvKuP7r3dTGsiLqFAo7JR0T7B8rhfwXARa2us4UEqr5Ffgs151i/08oTNKdIO770ptObBYq5Yv5ibQq/sl3Qc8lJ4+lnSqH1vFfp9koZRKJVtaWnqkWXqSVkqlDe+vmUDWpZMlK/X6MBDegKf3P/nYaj8ErN9fqZBYEsf3Ag8G8Xit33BaniTcvGX0IvAw8BHwTa1y4Md+CeRqRL9fudwAvpienNi7Vhu21uwflOT+L+i1X2TJP57iUvUFtHWsAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-help {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-hover {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4oVHp0SwAAAQJJREFUWMPtlsENgzAMRb8RQ5VJItFDOgaZAMaAA0iZpN3KPZSoEEHSQBCViI/G8pfNt/KAFFcPshPdoAGgZkYVVYjQAFCyFLN8tlAbXRwAxp61nc9XCkGERpZCxRDvBl0zoxp7K98GAACxxH29srNNmPsK2l7zHoHHXZDr+/9vwDfB3kgeSB5IHkgeOH0DmesJjSXi6pUvkYt5u9teVy6aWREDM0D0BRvmGRV5N6DsQkMzI64FidtI5t3AOKWaFhuioY8dlYf9TO1PREUh/9HVeAqzIThHgWZ6MuNmC1jiL1mK4pAzlKUojEmNsxcmL0J60tazWjLZFpClPbd9BMJfL95145YajN5RHQAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-crosshair {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADEUlEQVRYR81XXVIaQRCeHqug8CXmBNETaE4gniDwIgpVspxAbxC9ATkBkCpQ8gKeQDiB5AQxNyAvUlrldr7eHxyGXZi1rMJ5opbp7m++7un+htSGF204vsoMoNXrlzSpfWa1oxQfhAegCZGaEtPorHo8znIoJwCt6+td8uk7ApUQCIHTF4BNAWzImq8ap6cP68CsBdDp9i9ZqXM7ML79g/EnCWD+jgMKENKqWT+tXK0CkQqgNRjs0OxpQIqKhoMxaG6/6JeRnK7T6yO2UvVqhYSlLX+ryORfgKn9ORDFIy7ky41yGcwsr0QAQfDH5zucOswx819fs4egI9OFCcD8DjBF7VNbEX0JzdWEt3NHSSASAcCxBDqMgt/623kvyTgNgNjJIfTjk4D4FqaJR1715MjmYAmA5Bx3AwUXQL+t105KaTlcBSC26XRvhjEIoLiq1yqXpr8FAGG16/ug4IT27fxBWu7EiQuAiImJpEMKE6nYM30uAIDDttSUOPfJP7JzbjPhAiBIh9QE67vIvoOi9WJfCwDavf40ulpjbCqmUf+W753ezURuh7Dg1SqflwAEHU6pgfyBq9Y4qx0LG++2fnZ/eUzcstmdM2AWH+jfc+liWdBJfSENf8Lifi3GVwC9mybOfi5dzatWVrbbLIHNva8p5h/16gkaFiLGGxbufkoE6XguwePiXLF3XmMfCUCUAqtKXU7sumd1CowOuJEi3Pg1FBpjitIGhyvVSfvmjci6ZR+rFQfDiPVE2jFYeICQ+PoewwjC5h7CZld6DBdyu6nDSKgzOyIMhmhK5TTqXYbRorZYM46TmpKAAOrGWwSJJekSB1yqJNOzp1Gs7YJ0EDeySDIMtJbQHh6Kf/uFfNFZkolJICRmz0P8DKWZuIG2g1hpok+Mk0Qphs0h9lzMtWRoNvYLuVImUWrmPJDlBKeRBDfATGOpHkhw670QSHWGLLckmF1PTsMlYqMJpyUbiO0weiMMceqLVTcotnMCYAYJJbcuQrVgZFP0NOOJYpr62pf3AmrHfWUG4O7abefGAfwH7EXSMJafOlYAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-lasso-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgwlGP1qdAAABMBJREFUWMO9V1uIVVUY/r61z57ZMx4DnbzgkbQXL5iCJphlWdpIGY4jpFBkEiU9ZNaDRRcITcIwMwgxoQtU2IMXdAZfMjFvpERXYiSbysyBEXFmyuHMnLP32uvrwT2xnY5nxvHQ93Jg7fWv71/r//7L4a59TRgqJk+Z6v3a+sv0OI5nk5wu6VaSVZImAThHsgjgrKTvM5nMUWvtmf5n8HodCIKgOgzDhc65pSTrJQWDsSNpJX1ljHnDOfdT37oZLLHv+8OMMasKhcIJ59xHAJYMlhwAJGUAzJfUTHLFuFzOG5QDU6dNMyQfs9Yedc5tBpAD4IYYNQGoBrDtQnt7/b0LFrJsCHzfn2itfQfAnZLiazytA3AaQAuAiwDaEgeNpGkkswAWSBqRONB38b88z5uTKePt6iiKXkk8jq+iJC5LOmiMaTLGHLPWhmWeHr7vV0dRtATAapAzIVmSo51zyzIlbm2stesFPA6pKk0r6Ryg93y/ek8YFvPOOTg3cDSiKCoC2OP7/rEoirYm4rUkF12lAWNM1lr7lqQn0+QA8gI2jBg5cj6Aj8OwmB+KAKIoukhyp6SRJAUgl0ndPLDWPi9pJQCbuviXvu+/GIZhW1dnJ24UJFuTjCCA2ADA8sYGWmsXS3qmL94kDYAtkh4Nw7ANlQJ5U6INT1KrAYC9zQdykl7nFSj5fXp5Y8NWVBhy7mUAjqShMYdMXV2dJ2klyRwAJ8lIeuGWCRMP7N7frEqSG2OmAFhKshNAp5wrmO7u7jEAngPQm1S2z2pqapr+OPt7XEly0oxwzq2RdFmSD2AMgKKJouhhAL4kA+Cs53l7e3t7uytJHgRBreTWkXwkKVJnJD0B4GAGwIJE9R6AFufc6UqSZ7PZbD6ff5dkA4CQZEHSqwAOISmXtwGIE+F1SeqqIP8d+Xz+C0mLJYWSAODteXffczjdDQNJ0BWMCoLg5gqIbRTJNwHsljQhUb0luWPM2LE7Thw/9m/5NCT/TByxAOYWi8X6/gdWV1dnfN8fNRBxJpMZTXKdc+6IpFVJWAEgkvSJpA0X2tvtVTaSjgOYBCAEEADYSHK87/sfhmEYA9gShuEDkgzJHyWtB/B1irQ2juP7ADxkrX0wOUOpzmdpzEY590HJ7Ni1r2kSyZOSiv2+hSRjSTXp/QAukzySNJOJkmalyNIl10hqMcasdc61XDNcQRD8BnITgNp+36r6kfcNFMMlLQGwTNLMEuQGQBfJl2bdPru+HDkAZAqFQux53jZHEsC6aw0eg2gylNRBcqcx5v04ji999+03AwsWAOI4Lsy9a94WkisAnE5a5WCJYwCfA1g7LJudI2lTHMeXBm1faiQzxkyRtF3S5CTupeAB+KG2tnZFT0/P30NO2VKLzrmfAbwGMipjG5Oc0dPTc0Md05SZ5U4Q2FxChErtEYD7jTGNQ3UgM8Asv90Yc9I5LSKRlXSI5CxJa0jWSALJjKRnAewfkniT+vwf7N7fXHK9rq7O7+jo+BTA/NRrdBpjnnLOnUrvXd7YMPQXSBunneno6IhIHgYwW1JtkgmBpBkATlVMAwOk3nFJ+VSoqgCMr6gIy2FcLtdKspAedyQN/98caDt/3kpyabUmf8WvG/8A1vODTBVE/0MAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-pan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4lKssI9gAAAOtJREFUWMPVll0KwyAMgNPgoc0JzDX2Mtgp3csKErSamGabIEUo/T6bHz0ezxdsjPJ5kvUDaROem7VJAp3gufkbtwtI+JYEOsHNEugIN0mgM1wtsVoF1MnyKtZHZBW4DVxoMh6jaAW0MTfnBAbALyUwCD6UwEB4VyJN4FXx4aqUAACgFLjzrsRP9AECAP4Cm88QtJeJrGivdeNdPpko+j1H7XzUB+6WYHmo4eDk4wj41XFMEfBZGXpK0F/eB+QhVcXslVo7i6eANjF5NYSojCN7wi05MJNgbfKiMaPZA75TBVKCrWWbnGrb3DPePZ9Bcbe/QecAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-xpan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4X4hxZdgAAAMpJREFUWMPtlsEKwjAMhr/pwOOedINJe/PobWXCfAIvgo/nA4heOiilZQqN2yE5lpD/I38SWt3uD9aMHSuHAiiAAmwaYCqoM/0KMABtQYDW11wEaHyiEei28bWb8LGOkk5C4iEEgE11YBQWDyHGuAMD0CeS30IQPfACbC3o+Vd2bOIOWMCtoO1mC+ap3CfmoCokFs/SZd6E0ILjnzrhvFbyEJ2FIZzXyB6iZ3AkjITn8WOdSbbAoaD4NSW+tIZdQYBOPyQKoAAKkIsPv0se4A/1UC0AAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-ypan {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4anK0lywAAAMVJREFUWMPtlzEKwzAMRX/S7rlpIMXeOnaLaME36FLo8XqCdNFghGljyc4kgQi2Q/SUj0F/eL7eMMTKz6j9wNlYPGRrFcSoLH4XxQPvdQeYuPOlcLbw2dRTgqvoXEaolWM0aP4LYm0NkHYWzyFSSwlmzjw2sR6OvAXNwgEcwAEcwAEcwAEcoGYk20SiMCHlmVoCzACoojEqjHBmCeJOCOo1lgPA7Q8E8TvdjMmHuzsV3NFD4w+1t+Ai/gTx3qHuOFqdMQB8ASMwJX0IEHOeAAAAAElFTkSuQmCC");\n}\n.bk-root .bk-tool-icon-range {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-polygon-select {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjc1OfiVKAAAAe1JREFUWMPt1r9rU1EUB/DPK0XbqphFHETo4OCiFhwF0V1KHbRSROLqon+AUMVRRFBwEbRFMBiV+mMW/wIxi5OD1kERRVKRJHUwLvfBTZrU5OWBGXLgQu7Jfe98z/ec7z0vKa88b2q1BDtRHdAPBaylm1NzsxsOjPnPNt6WSWprbft+/c3I3zOAjhT1Y4+fvcjEQJIXnVECSa+AhqIHqlHH5lWCZoe+Gk4GRgDG86j9SAUdlDBSQaZhlOkuHyoVdJmsw98D1S5fM4NYM1LCpqM+Lwa240oLgmZzpVZvzKT75VLZcqksSZKWlQeAy/iORVwIvh31xvotvK7VG3Px4aWHj3Jl4C2uYSvq+Bn8v6LLbaVWb9zsBiKLCvbiNG7gLm7jAYqbPHMJMziZ9lsKoh8GtqCEVVzHftwJn+TFHp4/hg8BSCYVfMOZoPEv2NZGdy9WCGUr9toDR3E2/H4V6nwRe/BmgN65H1ZhvMuB3XiKIyFoGefwO6ysVkUlrNUNsyAK/jli533Q+Y8cJFvAeXyMS1CI/jiMr/gUtD2LQwMGr4R3p7bY3oQHQ5b38CT4D2AXXg6YcQXHpyYnlqKsi5iOAVSwL9zd7zJ09r+Cpwq72omFMazjT9Dnibym0dTkRDUKrrgwH7MwXVyYB38BstaGDfLUTsgAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-redo {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4itK+dVQAAAaFJREFUWMPt1L1rFFEUBfDfJDaBBSslIFjbaSFp1FJQFMVCHkzhKIqdUYOCoBgErVz8rCwiTDMwBCIKipDWyip/gxAIWAmBgBC0eYFh2Gx2l9lFcA5M8e59782Zc84dWrT435Hs1siLchqn43MS0zgW22vYxjesYjVLw3YjBPKinMUTBOwf8J5fKLGYpWFjJAJ5Uc7gIW6jM6Kim3iNZ1katgYmEL/6I+YasvY7Lg6iRpIX5VF8wuEe/XV8wGf8jN6LWTiAc7iEQ7ucPZ+lYW0vAtfwvlbfwCKW9gpXDOv1mJvZHiSO91MiyYsyiQSuxtpXXM7SsDmM5nlRdrCMMz3sOJWl4Xevc/vwBzdwAl+yNNwZxfRI+GxelK9ikHcwh8d4NNR/YFRES1ZwoTYdR7I0rNf3TzVNIGbmSvR/Bx08mIgCFSVu4l2ltIWD9WxNGR+W8KOynqnZ0rwCeVG+wa0hjrxtWoF5dAfc28V8Mib/n+Nev5dnabg/zgw87aNEN/bHOwVRiRe4Wym9zNKwMKkpgIWKEt24njxiJlq0aPFv4i9ZWXMSPPhE/QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-reset {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4gWqH8eQAABLdJREFUWMPtlktsVGUUx3/nfvfOlLQaY2IiRRMQIRpI0PjamJhoVASDvNpCpYw1vJQYSVwZwIVQF6wwRHmkAUof9ElrI6VqDAXcID4TF0IiYQMkSlTokNCZ+b7jove2t+NMH7rQBWd3v+989/zP+Z8X3Jb/WGQySvUNTQBJESkNguAVYIWqzhaRhwBU9WcR+QXoymazn6jqzUQiMQSQzWZRVdal1vwzAI2tHQBPOuc2AbWTdOyQ53n7nHNfRwee51GzqoIQMCLDpr3x/tLQ0oZzrk5Vj0/BOEBt+KYuOlBVGlrahr0Wob27t3gEjnZ2AyQzmUwHsDgP6J/AYRE553neDwDOuUdU9QngNeCumK4TkRMhZUORcYC1qysLA6iuSQHIwkWLD6lqapQsuSmwTVV3h99I7EcAR462A2xR2Ilq6ehTaejvO1774kuLNALR33eclsaGsQDe3fYegHl43vyNwEeqGl1963mm2jl7YZRTQ82qlWP4HM6ZToC5ztkW4LHQoALru7s6Di5dvlIj/e6ujrEAWoZDn8hmMjXATMACGaAVuBjXTVVXFc/AxhaA+4zvn1DV+eHxVWPMAmvtb5GeMWZyZVhI2rt7qVy2pOh9U1snwIPW2vMi4oWJuBPYHkVAVScPoKmtkzVVK6cEMsyJraHhiCqJqJUwj/JRz7TW1iSSyR2rVyylqa0Ta+24Ic8vXaAEmDFc/l5Z2A/80OibuVyuz/f9ElUdHCmvw82t5HK5h6y1PYhsz2YyGw43t2KtBZHIGwB6+j4rCkBVUdV7gXrggnPuu8h4eP+xMeZS2D0rJYZ6AdAMzAt1b4nI26p6IFZOY8pugijcKSIHVLUK0LyST4vnrVfnWr3mjmP4QTATaERkXkypRFX3isjmuHdRJEK6Ckqquopp06bdKCkp2Sgi7XnGLcg7gzeutwNIiPYc8HixqIrIOlU9ONVIhHPEd851icgSVXUiskVV94gIqoonIt0i8gfQCfwae38e6BWRXuBZz5jZ8VbaOE4EIqlZVUEQBLlkMplS1QER2RwkEnsSyaREDUzyeNsvIhvCMqkH1kdIJ2o+k8iJB1LVVRfjZ6nqqlEAIbdVQGto8Lrv+/dbawcjAL7vc+6bs+zetetfLSHxniIFGofGGsU2oC7eOCbDfZ7nQawBOSAX74SF9oEPImOq+r7nmVmxb5raukZa8UReGmNmhbMkAwwBH467EYVZe49z7kdgenj8k7V2oTHm8kgdWcvrNdVFjR8cHkYzjDH9wLjDaEwEzpwa4MypgWvAjtjxfGNMj4jMiT+M+kFsZI/Q6Pv+HGNMT8w4wI7TAyevxXVPD5z8+zD64tRXAMHVK1eaVLUyVvuDqroV2BOnJF4ZIedviUidqt4Re9s+vbx8zZXLl7PR2+nl5Tz/zNOFp2FzxzGAklw22wUsLLaSKXwf8vhosZUM6PeDYEUum70VHfpBwKsVyyfeikOP6oBNwN1TrLbfgX3A1kKLzKeff8nLLzw38T5wZDgxn1LnNk5lLRfP26/OnR2hwfNYW2Atn9RCsrf+EECyrKysDFimqhXhyjY3VLkAXBKRDqA7nU6nS0tLhyIj6XSaN9bVclv+l/IXAmkwvZc+jNUAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-save {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4UexUIzAAAAIRJREFUWMNjXLhs5X+GAQRMDAMMWJDYjGhyf7CoIQf8x2H+f0KGM9M7BBio5FNcITo408CoA0YdQM1cwEhtB/ylgqMkCJmFLwrOQguj/xTg50hmkeyARAYGhlNUCIXjDAwM0eREwTUGBgbz0Ww46oBRB4w6YNQBow4YdcCIahP+H5EhAAAH2R8hH3Rg0QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-tap-select {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-undo {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4em8Dh0gAAAatJREFUWMPt1rFrFFEQBvDfGhACASshkL/ALpWVrSAKEQV5sIULWlgZNSgIFkGIVQ412gkBt1lYLERREFJqJRaW1oHAoZUQsDqwecWy7N3tbe6C4H2wxc682Zn3zTfvLXPM8b8j6RqYF+UCzsfnHBawGt3fMcAX7GEvS8NgKgXkRbmMxwg41TLsN0psZmnodyogL8pFPMIdLHUk7hA7eJKl4U/rAuKu3+HslFr/FZezNPSTFslX8QErDe4DvMVH/Iq9F7VwGpdwZUjsPtaSFjv/1vCBPjaxO0xcNbHejLpZrrlvJCMCT+JzA+2fcC1Lw+GE4l3CG1yIptfjCtiKoqtiJ0vD3aM0Py/K57iIMxgkQxat4EdN7e9xdRzlk+LEEPvDWvIDXJ928sYxjL36icWK+VaWhlezOIqbGFirJd/H7szugrwoX+D2BDEvszSsT5OBdfRaru/F9dPXQF6U27g/KnmWhgctxqyzBrZGMNGL/rHI0nDkKXiKexXTsywNGx0OnFbFNk3BRoWJXnw//j+ivCi32/S8CxPVNiWOAdUiJtXITIqYY45/Cn8B2D97FYW2H+IAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-wheel-pan {\n  background-image: url("data:image/png;base64,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");\n}\n.bk-root .bk-tool-icon-wheel-zoom {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgskILvMJQAABTtJREFUWMPdl1+MXVUVxn/fPvf2zrSFmUKnoBCUdjRoVaIxEpO2JhilMYBCtBQS2hejpg1Uo2NUrIFAoyGmtiE+GHwQGtvQJhqDmKYRBv+URFsFDNCSptH60DJTO3dKnX/33rM/H7rvsDu9M20fDMaVnGTvtb69z7fWXmvtc/TEzqd4OyXwNsv/FwFJQVI/sA14SZKRLOlPkr5TrVYXHz70quYkEEK4TtI2YAgYkrQthHDdhV5uuw+43/ZrwCbgRttgY/tjtrc0m83X3/f+D6ydnJhYcB4BSZcBA7aP2d4ELAGW2N5k+xgwkDB0IH19CGGH7R8B1aQeAf4KvAw0ku4K2zu7uru3ApdPEyiKohd4TNKjtjt5h6RHgccSNrddbvuHtm9Jqoak7xVF8WFgdavV+pSk5cCObNmXgK++85prCj3z28HKqZMnH7D9YAY4BvwujT8BvCuL1INX9vVt+dfwcCvNb7f9q2RuSfrGvWu/sL2Nf3LX7pzvj4ENSGBPVarVd4fRkZFltjdmoMGiKO4IIWwIIWwoiuIOYDDzeOPoyMiyFLkum7WJCMDztrcrTTrIRuAQZ6NcK1utL4dWq/VZoC8BhqvV6l1lWb4YYxyLMY6VZflitVq9CxhOmL60hhCKeYiV7WMKIXw9jT1HpXw3c+bOAKzOjJubzebJrKQCQLPZPClpc7bP6rMYKtjXth2OMf7tIkr11Wz8oQDc1Fb09vY+kQw1YAuwJY2nbUluAnCWpKkaFl6IQIzxivaR2SYA89sJVK/Xp2x32R6w/a30DNjuqtfrU0ArYecDCEqgLqm94T0dEm9mBG7PxkdDlkBnkhebgIezNQ8nHcCZPL9ijE1Jf/bZZoPtzbavmqNZLbf9tSxq+yoduuJ+SZ+zXSZyBXCqU+d8fvC5yRUrV+0G2j3g2hDCLyXd/+Su3QdnvP/zCuH72LWsgf2k0oHlH2c2odlkxcpVEdgr6aDtjyb8x20/J+mA7T9I6rL9SWA5dne2/GdXLl58qNJh398An85yTMA+4DOz8Dgu6Zu2dwJXJ91ltm8Gbp7Fgb+EEB4aHhpq5CEtACqVyr3AC0AlPS8k3TSmQ2YPhhBuS/1/LpmS9JTtNTHGfwBU2uUALARotVqniqJYH2Pck85pfavVaufAwnQvnHc0McaDKVptebN94QAnJB0EdtjekydyZXqjs/0ZgLIs/w6sy8bnYGYJ63pgERKC05JutT1kOwITwL9tvzlzUQUYB+Zjs2DBgu6xsbGJZHstByZbezregcBXeCsEz1bnzXt5anLyzLq71zDLxTRdVgemdx0fv2e2w5thO5DbiqL4oKT3ZKpnpyYnz+SY2ZpTAPZmJfdIrVZbNBNUq9UW2X4kU+2dcf53Aj1pj2PA7y/6m1DS00A9za9uNBq7iqJYBuoGdRdFsazRaOzKSqye1rTbaa/tlbYrqXQP2X4FIA9/J1l39xrC0v7+w5IeB8XkwS1lWe6TGJAYKMty31tfO4qSHl/a3384I3CDpI+kzC4lnRfrue6GytEjR8oQwlY73gC0L4qlth/q0M1/LYWtR48cKQF6enrC6dOnVwGLEpnxnp7en4+O1i/tszzGOCTpPmB7ahb57QUwBWyXdF+McWg6MScmuoA8OX8xOlpvXGz422XYTsB/SnpA0h7bX5R0WzI9HUL4qe2XbI+dk3xl+V7gxoztD5jRI+YK/zkEEokx2/uB/RdzIfUtueqVN04cXwF8G3iHY3z9Urw/j8ClyhsnjrcS2Vv/J/8NLxT+/zqBTkcxU/cfEkyEAu3kmjAAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-box-edit {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4QfHjM1QAAAGRJREFUWMNjXLhsJcNAAiaGAQYsDAwM/+lsJ+OgCwGsLqMB+D8o08CoA0YdMOqAUQewDFQdMBoFIyoN/B/U7YFRB7DQIc7xyo9GwbBMA4xDqhxgISH1klXbDYk0QOseEeOgDgEAIS0JQleje6IAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-freehand-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADTElEQVRYCeWWTWwMYRjH/88721X1lZJIGxJxcEE4OOiBgzjXWh8TJKR76kWacOBGxdEJIdk4VChZI/phidRBHMRRIr7DSUiaSCRFRM3u88gz+o7Z6bBTdjmYZPf9eJ55fv/5zzvvDPC/H9QsA66Olo9Ga+/MdR+Ljm2/KQIULsz9FqItGdOfJKLhApLgVkiSCGODjWit7QpKWy+TNrFeXvzKVUT8NiTVaIgDcbiCFJ7GiT8WkARXAdYBK0Lbhi/CenArRNskuM7/tgNp4ArQ42dwjf3WY5gWTqC7O/NbNn2Xkfw/YwdSw/We14HP2IEZwX+y9cZ9SH0LmgFP7UCz4KkENBNeV0Cz4b8U8DfgKiDxMWwUXETqLvJpCQpXZfawbzS7t9v5pL19cHBwfja7YA0y/lyCM0+E5hv5+piZXwKYcF23as+37bTXsQVqgkL0p/34fHR7DcBtbetFsBmGDwMOJCggYG55yw7dMlk6DuC1Bdu2RsCU9TYWQq2IoGbsreZ5NzvEqfSBsIsIy8OTbcdgiRHeh4o8AFAEwDakbY2AaCCpH7V9aGhoUUUy3UyVbkPYFuYLDlUZH8XBpwxkK0Dbgxg5HcVi0ent7a0RULMIozaHBSMfF9b2SzdutFcFB2FkwMIJOG6qfteXOa1nHZ48tyefuwyfT9s6wtzZ3t7eZse2DR2I228TtHXzuWCx9g8MtK5cuHCZTH4tiHEOa4xFngvTyS8f35d6enomiCi4/foEXBkZaQuukChL4FYA2Whd7YcC4gEdW3CpdL3LtGAVCVYJywEyTpAuJKeMOKXZs/Bw947C50KhUFOG4cwz35cjWNBlHGeD53n3xsfHP/T19U1qciggar8Fa4I3PHobIotBWBtc2hSiChyZxVzM53Pv7FVH6Tp3uVy+g0r1ImD2GjIrQGYIxjnfuXTZGICS5k/bBwJoubwEFX4TLah9EXomJGMA3za+f9913Yl4TnzsDQ+vE6YTZOjHh4ngibstt1pzQwd04F0bPStEBpXqRoBeQ/AKghfBnOEKgS+Q7z91Xfdz/HGKg8Ox7z8iYD9z6wqTkZFgnvhMGP9VZ2or1XVkPM9z0mytSfVsHa1RLBZbLoyNzUnK+ydz3wC6I9x+lwbngwAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-poly-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjglo9eZgwAAAc5JREFUWMPt1zFrU1EUB/DfS4OmVTGDIChCP4BgnQXRxVHqIJUupp9AB8VBQcRBQUXIB9DWQoMRiXZzcnQSA34A7aAuHSJKkgo2LvfBrU3aJnlYkBy4vHcP557zP/9z3r33JdXa647N0kHSZd5Nn0rSxc8G3cXp85sMcnZZ8vge3osZ+l3vB8CWFA0iL14t79h210swAjACMAIwAjACkB90D/8/GchI9ve4nPwTBh5E9ws7OepzGWb9EddSn51Op9ZstadSg4VK1UKlKkmSDSMLALewiuNh/hVJq71Wxttmqz0dG88vPc+MgWP4grvYG3SLOBrZFFFrttqPe4HIDxh4GSei+98iSlusuYopXEAjBtEPA3tQwUpwluAbDm4TPJUz+BTW9l2Ce6G7L0X/Bw8D3T/7SKKIDzHg7QCcxjvcQAEtXAnrrg/RP0/DKPbqgcN4iVOR7gcO4dcQgRuoh7HSqwlP4n20m63jJu5n8MkWMYfP3UowhzdR8FU8w9iQwevBdyq3/27CMRzAE5yLuvsRLg+ZcR1nJ8YL81HWJUzGAPaFZwe/Q5MdyYDyNHgjzO90YyGHtVDncuiJchaHw8R4oREFV5qdiVmYLM3OgD9k5209/atmIAAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-point-draw {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEiERGWPELgAAA4RJREFUWMO1lr1uG1cQhb9ztdRSP7AF1QxgwKlcuZSqRC9gWUUUINWqTh5AnaFOnVPEteQmRuhCURqWsSqqc9IolREXdEvQBElxtdw7KURSFEVKu4w8wAKLxdw9Z+bMnRmZGXfZ29//II8th4WwGVNyIoQLYB5vxA9Caq04iUd9A+7ZlsNC2I7TdSd2hZXMJKlnTqp9jtl/GBaqoyQ0noFKpUIzBicYYc+DEFpxkglc4oVJa5gvDn8v1xV2irG3FM4NSVwjUKlUaMcpJhCGmSEJQ6QGD8M5WnHCd8+f3QCXpPLx8WNwv0j6Bm9FMK7FJ3WBE+R/2t7c/GBmFvSBrzRTCsyTDjXrxUgEMtpxynJYmJoBJ4VAybwVARgvL7Oik0okCodnKpVKX7P0leiVMb0VvbJT+upznK4vh0GIeQwwQStJkHQD3MwsCALTJRG7Qrdrj5m/djgYaIa0hlkRdJk26XEgC9txurccBtVW3IudBImmZuACUP+ZlIDBt9FKcubYNTcAH/X0RYM1E7utJPlqe+uZzPxUcEkiSS4sTT95n15Mud0xWC0o2PAWOCdK3KYZlFxfM+tHOcnMzNr1es18ug+cgsVjP4yBU/Ppfrter1m/+l0+zYygML1xRVHU7TSb1cSzBzoBzszsH+AMdJJ49jrNZjWKou6wBnwOzcyndBpNbuueURR1Dw8Pq35p9cc5p/Dy9Dypt7jXrtdGwQECS9NPhr6Gq6txUzNigE6zydLK6lTw12/KT4FGFEUfJX2YJNONq5tVs4ODA7sD/DnwJ/BoADZuE3tHFs12dna6d4C/BI6AlbyzI8ii2TTw12/KK33gb2cdXsNZoAntbZC2SeO4c9592k/5eNQbiwvFd1kJuFGwLJr1wSPg/SwpvyFBHufOeXcFeAlE97U/uCxOY+P3b+Bn4B3Q+L8EdJfD4a+/AbC4UBzPxiPg3wlHZquB28Cn2IuR9x3gr3uV4DbwfvSDOvi4uFA8BDZmIRHkjHpS9Ht9iRqd8+5G3g05mAGcQbsdiX5QJ428G7Kygo8XYdb1/K4NWVmjzkNge2sz84bs+ELmpDDLtqWsNZBXgvmw8CTtpWVMT7x5YWBjLARnwZfKQNYN2U2LPvrh+5nBt7c2M2/It9bArCTKR8eZN+SJ13AScPnoODeRdqNenH+wul5w2gUr2WUjMFAt8bZ/0axX/wNnv4H8vTFb1QAAAABJRU5ErkJggg==");\n}\n.bk-root .bk-tool-icon-poly-edit {\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gELFi46qJmxxAAABV9JREFUWMOdl19vFFUYxn9n9u9sCyylUIzWUoMQBAWCMdEEIt6xIRQSLIEKtvHe6AcA4yeQb7CAUNJy0daLeomJN8SEULAC2kBBapBKoLvbmdl/c14vdmY7u91tF95kknPOnHmf95znPc97Ro2OTeBbdjFDT3c32ZxVHUOE9kSMB0/m6ExuoJn1H+ur6Y+OTfD50SMN5168OgrAlyf7CfuD+z7+iDs3p8hkLUQ0iFQ/yFl5Nm/qonfHVva+s32Zw9GxCYILsZ08tpNfBhbs+1YN4OH9+7huGdECSBVfqUosbsllfmauBqiR+cCNwOr7AEo8pPHJnymXykhg5fUWjoQpl0vVvhZhbSzGoUOHqgBlt6B6uruj2Zy1E9jo0fhfeyL2x4Mnc8VErK0KUEOB64JSyptfG4RSytsJjUJVxw2lsFy3urL9nx1Qd25ObctkrVMi+jQivd7U2ZyV/3Hzpq7h3h1b/7p9Y0o8v8rwAbTWrGpSocN/FGDlbAI0Rl23PCBan0Ok158H9Ipwzi25A/Mzc9Gl/BYx/E4kYqC1NKRARNAaDCNUM27Z+Zr+ouXs0q4+LSLBHPYCFkTkC6uU39kwCdsS7WRKmaYUiAhdnZ3MPX2K4+QjQI+C94A93rMzm8ltMwyDeDzWjMZeEb2pYQDdW3vITU2jtUZ5QThOPgm8C7wP7J15OPsBsB3oWpGnVWisCeDS1VHj4vBI92+/3tgB7Ab2AruAXiDBK5oIOkhtkEYRNRuJhObrd8Dl9ewf4D5wG7hVLpen29vb5wzD+BrkbBMaL3d1dk5nsrnlFDTTFWAWmAZueWD3gCemGde2k2fw1Al1YXhEvjozoO49eczdqekrWmsc2zlrmvEKOGoW1GUjFLqSk2KpJrCLwyMCPAP+BO54QL8DM6YZX/ClsP9YnwKkXnIBP4jdIpJRpdJTCYdMwwi98KU0Hjc/dDILNyUcwTCWdOSMJ0TRmBktGRhLugu0xyLk7CIqVNm+0bGJptl1YXikD0grpY4Rjc4a8Fbgdab/6OGbAJeCUuyJnnHmZH9pbSyGuBXV8NUwlUpR1EWyixmSyTWEwqGlJ2Swbo2JXbAAfgDGgGQA9I1A9t1tlq0AxrXxn0ilUpw4fhQqYkH/sT41OTnJJwf2s6FjI5mshdYa7bqVR2uezr9MJmJt14FvGrh/O9D+e6UkM/xyCuCqEKCYnJyUTKFQrZDHjxzGshwWLQcRsOz8Hi85P23id0ug/XilAMLBmm4tPGdoaKjSH5+oAGrhwvBI9SjZTn4QSK9yenoD7dlrExPoJlXW8G8ytpNHxRKk02lGxsdRKFwXLNvx5yY94HQLGhGk4LFCYQSqaE0AwWM1eOoEbR0dKBSW7bC4mKuffxs4D/wCLKwQQPAUzIkslfp6cVomROWSolh0GjldAM4nzDi2k9/i5UAzC9aKfwNJ3zgJg9YEvN6+C7SHgKm69+sD7RfNnKTTaZRPQfAut4oFV//IS7gkcB34VlVo8kGzphlfB+DU+TfNGBpZtRastvrvARJmfMF28ge9sc2B9/PNnCilMIDwK6y8/ow/Ai4kvILTljAXvDvEvrqKSUs60KolzPjBxspavQD2tKqCAGF/Ba+xE/Wbilu54wZV8NEKF5fXzQHl/bh4hUsE0WAXSlDMYcQSrQXgCmsTseXHsJkNnjqBFGwKJaHsKlxtUHYVhbLCzr1kaOA4bcn1y1Swmb+iLpJKpVrfgdpfsiVVCYcgluwgnU7jEgJ4s5UkLFtWYyHyEg0/N1q1tmQH+YXnAMFr97Nmv3p+0QsHQRsF8qpBOE5+rb9Nkaj50tVQKjqh4OU3GNL/1/So3vuUgbAAAAAASUVORK5CYII=");\n}\n.bk-root .bk-tool-icon-line-edit {\n  background-image: url("data:image/png;base64,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");\n}\n'},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const n=t(1),s=t(72),o=t(303),l=n.__importStar(t(282));class h{constructor(t,e={}){this.items=t,this.options=e,this.el=s.div(),this._open=!1,this._item_click=t=>{var e;null===(e=this.items[t])||void 0===e||e.handler(),this.hide()},this._on_mousedown=t=>{var e,i;const{target:n}=t;n instanceof Node&&this.el.contains(n)||(null===(i=(e=this.options).prevent_hide)||void 0===i?void 0:i.call(e,t))||this.hide()},this._on_keydown=t=>{t.keyCode==s.Keys.Esc&&this.hide()},this._on_blur=()=>{this.hide()},s.undisplay(this.el)}get is_open(){return this._open}get can_open(){return 0!=this.items.length}remove(){s.remove(this.el),this._unlisten()}_listen(){document.addEventListener("mousedown",this._on_mousedown),document.addEventListener("keydown",this._on_keydown),window.addEventListener("blur",this._on_blur)}_unlisten(){document.removeEventListener("mousedown",this._on_mousedown),document.removeEventListener("keydown",this._on_keydown),window.removeEventListener("blur",this._on_blur)}_position(t){const e=this.el.parentElement;if(null!=e){const i=e.getBoundingClientRect();this.el.style.left=null!=t.left?t.left-i.left+"px":"",this.el.style.top=null!=t.top?t.top-i.top+"px":"",this.el.style.right=null!=t.right?i.right-t.right+"px":"",this.el.style.bottom=null!=t.bottom?i.bottom-t.bottom+"px":""}}render(){var t,e;s.empty(this.el,!0);const i=null!==(t=this.options.orientation)&&void 0!==t?t:"vertical";s.classes(this.el).add("bk-context-menu","bk-"+i);for(const[t,i]of o.enumerate(this.items)){let n;if(null==t)n=s.div({class:l.bk_divider});else{if(null!=t.if&&!t.if())continue;{const i=null!=t.icon?s.div({class:["bk-menu-icon",t.icon]}):null;n=s.div({class:(null===(e=t.active)||void 0===e?void 0:e.call(t))?"bk-active":null,title:t.tooltip},i,t.label)}}n.addEventListener("click",()=>this._item_click(i)),this.el.appendChild(n)}}show(t){if(0!=this.items.length&&!this._open){if(this.render(),0==this.el.children.length)return;this._position(null!=t?t:{left:0,top:0}),s.display(this.el),this._listen(),this._open=!0}}hide(){this._open&&(this._open=!1,this._unlisten(),s.undisplay(this.el))}toggle(t){this._open?this.hide():this.show(t)}}i.ContextMenu=h,h.__name__="ContextMenu"},
function _(e,n,o){Object.defineProperty(o,"__esModule",{value:!0});const t=e(9);function*r(e,n){const o=e.length;if(n>o)return;const r=t.range(n);for(yield r.map(n=>e[n]);;){let f;for(const e of t.reversed(t.range(n)))if(r[e]!=e+o-n){f=e;break}if(null==f)return;r[f]+=1;for(const e of t.range(f+1,n))r[e]=r[e-1]+1;yield r.map(n=>e[n])}}o.enumerate=function*(e){let n=0;for(const o of e)yield[o,n++]},o.combinations=r,o.subsets=function*(e){for(const n of t.range(e.length+1))yield*r(e,n)}},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const o=e(296),i=e(173),s=e(72);class c extends o.ButtonToolButtonView{render(){super.render(),s.classes(this.el).toggle(i.bk_active,this.model.active)}_clicked(){const{active:e}=this.model;this.model.active=!e}}n.OnOffButtonView=c,c.__name__="OnOffButtonView"},
function _(t,o,e){Object.defineProperty(e,"__esModule",{value:!0});const i=t(1),s=t(19),l=t(72),n=t(115),a=i.__importStar(t(18)),r=t(78),_=t(9),c=t(13),h=t(8),u=t(81),v=t(306),d=t(307),b=t(308),p=t(295),g=t(299),f=t(310),m=t(173),w=i.__importDefault(t(300)),y=i.__importDefault(t(311));class T extends u.Model{constructor(t){super(t)}static init_ToolbarViewModel(){this.define({_visible:[a.Any,null],autohide:[a.Boolean,!1]})}get visible(){return!this.autohide||null!=this._visible&&this._visible}}e.ToolbarViewModel=T,T.__name__="ToolbarViewModel",T.init_ToolbarViewModel();class k extends r.DOMView{initialize(){super.initialize(),this._tool_button_views=new Map,this._toolbar_view_model=new T({autohide:this.model.autohide})}async lazy_initialize(){await this._build_tool_button_views()}connect_signals(){super.connect_signals(),this.connect(this.model.properties.tools.change,async()=>{await this._build_tool_button_views(),this.render()}),this.connect(this.model.properties.autohide.change,()=>{this._toolbar_view_model.autohide=this.model.autohide,this._on_visible_change()}),this.connect(this._toolbar_view_model.properties._visible.change,()=>this._on_visible_change())}styles(){return[...super.styles(),w.default,y.default]}remove(){n.remove_views(this._tool_button_views),super.remove()}async _build_tool_button_views(){const t=null!=this.model._proxied_tools?this.model._proxied_tools:this.model.tools;await n.build_views(this._tool_button_views,t,{parent:this},t=>t.button_view)}set_visibility(t){t!=this._toolbar_view_model._visible&&(this._toolbar_view_model._visible=t)}_on_visible_change(){const t=this._toolbar_view_model.visible,o=g.bk_toolbar_hidden;this.el.classList.contains(o)&&t?this.el.classList.remove(o):t||this.el.classList.add(o)}render(){if(l.empty(this.el),this.el.classList.add(g.bk_toolbar),this.el.classList.add(m.bk_side(this.model.toolbar_location)),this._toolbar_view_model.autohide=this.model.autohide,this._on_visible_change(),null!=this.model.logo){const t="grey"===this.model.logo?f.bk_grey:null,o=l.a({href:"https://bokeh.org/",target:"_blank",class:[f.bk_logo,f.bk_logo_small,t]});this.el.appendChild(o)}for(const[,t]of this._tool_button_views)t.render();const t=[],o=t=>this._tool_button_views.get(t).el,{gestures:e}=this.model;for(const i of c.values(e))t.push(i.tools.map(o));t.push(this.model.actions.map(o)),t.push(this.model.inspectors.filter(t=>t.toggleable).map(o));for(const o of t)if(0!==o.length){const t=l.div({class:g.bk_button_bar},o);this.el.appendChild(t)}}update_layout(){}update_position(){}after_layout(){this._has_finished=!0}}function M(){return{pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}}}e.ToolbarBaseView=k,k.__name__="ToolbarBaseView";class B extends u.Model{constructor(t){super(t)}static init_ToolbarBase(){this.prototype.default_view=k,this.define({tools:[a.Array,[]],logo:[a.Logo,"normal"],autohide:[a.Boolean,!1]}),this.internal({gestures:[a.Any,M],actions:[a.Array,[]],inspectors:[a.Array,[]],help:[a.Array,[]],toolbar_location:[a.Location,"right"]})}initialize(){super.initialize(),this._init_tools()}_init_tools(){const t=function(t,o){if(t.length!=o.length)return!0;const e=new Set(o.map(t=>t.id));return _.some(t,t=>!e.has(t.id))},o=this.tools.filter(t=>t instanceof p.InspectTool);t(this.inspectors,o)&&(this.inspectors=o);const e=this.tools.filter(t=>t instanceof b.HelpTool);t(this.help,e)&&(this.help=e);const i=this.tools.filter(t=>t instanceof d.ActionTool);t(this.actions,i)&&(this.actions=i);const l=(t,o)=>{t in this.gestures||s.logger.warn(`Toolbar: unknown event type '${t}' for tool: ${o}`)},n={pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}};for(const t of this.tools)if(t instanceof v.GestureTool&&t.event_type)if(h.isString(t.event_type))n[t.event_type].tools.push(t),l(t.event_type,t);else{n.multi.tools.push(t);for(const o of t.event_type)l(o,t)}for(const o of Object.keys(n)){const e=this.gestures[o];t(e.tools,n[o].tools)&&(e.tools=n[o].tools),e.active&&_.every(e.tools,t=>t.id!=e.active.id)&&(e.active=null)}}get horizontal(){return"above"===this.toolbar_location||"below"===this.toolbar_location}get vertical(){return"left"===this.toolbar_location||"right"===this.toolbar_location}_active_change(t){const{event_type:o}=t;if(null==o)return;const e=h.isString(o)?[o]:o;for(const o of e)if(t.active){const e=this.gestures[o].active;null!=e&&t!=e&&(s.logger.debug(`Toolbar: deactivating tool: ${e} for event type '${o}'`),e.active=!1),this.gestures[o].active=t,s.logger.debug(`Toolbar: activating tool: ${t} for event type '${o}'`)}else this.gestures[o].active=null}}e.ToolbarBase=B,B.__name__="ToolbarBase",B.init_ToolbarBase()},
function _(e,o,t){Object.defineProperty(t,"__esModule",{value:!0});const s=e(296),n=e(304);class u extends s.ButtonToolView{}t.GestureToolView=u,u.__name__="GestureToolView";class _ extends s.ButtonTool{constructor(e){super(e),this.button_view=n.OnOffButtonView}}t.GestureTool=_,_.__name__="GestureTool"},
function _(o,t,n){Object.defineProperty(n,"__esModule",{value:!0});const e=o(296),i=o(15);class s extends e.ButtonToolButtonView{_clicked(){this.model.do.emit(void 0)}}n.ActionToolButtonView=s,s.__name__="ActionToolButtonView";class c extends e.ButtonToolView{connect_signals(){super.connect_signals(),this.connect(this.model.do,o=>this.doit(o))}}n.ActionToolView=c,c.__name__="ActionToolView";class l extends e.ButtonTool{constructor(o){super(o),this.button_view=s,this.do=new i.Signal(this,"do")}}n.ActionTool=l,l.__name__="ActionTool"},
function _(o,e,t){Object.defineProperty(t,"__esModule",{value:!0});const i=o(1),l=o(307),s=i.__importStar(o(18)),n=o(309);class _ extends l.ActionToolView{doit(){window.open(this.model.redirect)}}t.HelpToolView=_,_.__name__="HelpToolView";class r extends l.ActionTool{constructor(o){super(o),this.tool_name="Help",this.icon=n.bk_tool_icon_help}static init_HelpTool(){this.prototype.default_view=_,this.define({help_tooltip:[s.String,"Click the question mark to learn more about Bokeh plot tools."],redirect:[s.String,"https://docs.bokeh.org/en/latest/docs/user_guide/tools.html"]}),this.register_alias("help",()=>new r)}get tooltip(){return this.help_tooltip}}t.HelpTool=r,r.__name__="HelpTool",r.init_HelpTool()},
function _(o,_,l){Object.defineProperty(l,"__esModule",{value:!0}),l.bk_tool_icon_box_select="bk-tool-icon-box-select",l.bk_tool_icon_box_zoom="bk-tool-icon-box-zoom",l.bk_tool_icon_zoom_in="bk-tool-icon-zoom-in",l.bk_tool_icon_zoom_out="bk-tool-icon-zoom-out",l.bk_tool_icon_help="bk-tool-icon-help",l.bk_tool_icon_hover="bk-tool-icon-hover",l.bk_tool_icon_crosshair="bk-tool-icon-crosshair",l.bk_tool_icon_lasso_select="bk-tool-icon-lasso-select",l.bk_tool_icon_pan="bk-tool-icon-pan",l.bk_tool_icon_xpan="bk-tool-icon-xpan",l.bk_tool_icon_ypan="bk-tool-icon-ypan",l.bk_tool_icon_range="bk-tool-icon-range",l.bk_tool_icon_polygon_select="bk-tool-icon-polygon-select",l.bk_tool_icon_redo="bk-tool-icon-redo",l.bk_tool_icon_reset="bk-tool-icon-reset",l.bk_tool_icon_save="bk-tool-icon-save",l.bk_tool_icon_tap_select="bk-tool-icon-tap-select",l.bk_tool_icon_undo="bk-tool-icon-undo",l.bk_tool_icon_wheel_pan="bk-tool-icon-wheel-pan",l.bk_tool_icon_wheel_zoom="bk-tool-icon-wheel-zoom",l.bk_tool_icon_box_edit="bk-tool-icon-box-edit",l.bk_tool_icon_freehand_draw="bk-tool-icon-freehand-draw",l.bk_tool_icon_poly_draw="bk-tool-icon-poly-draw",l.bk_tool_icon_point_draw="bk-tool-icon-point-draw",l.bk_tool_icon_poly_edit="bk-tool-icon-poly-edit",l.bk_tool_icon_line_edit="bk-tool-icon-line-edit"},
function _(o,l,b){Object.defineProperty(b,"__esModule",{value:!0}),b.bk_logo="bk-logo",b.bk_logo_notebook="bk-logo-notebook",b.bk_logo_small="bk-logo-small",b.bk_grey="bk-grey"},
function _(l,n,o){Object.defineProperty(o,"__esModule",{value:!0});o.default="\n.bk-root .bk-logo {\n  margin: 5px;\n  position: relative;\n  display: block;\n  background-repeat: no-repeat;\n}\n.bk-root .bk-logo.bk-grey {\n  filter: url(\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg'><filter id='grayscale'><feColorMatrix type='matrix' values='0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0'/></filter></svg>#grayscale\");\n  /* Firefox 10+, Firefox on Android */\n  filter: gray;\n  /* IE6-9 */\n  -webkit-filter: grayscale(100%);\n  /* Chrome 19+, Safari 6+, Safari 6+ iOS */\n}\n.bk-root .bk-logo-small {\n  width: 20px;\n  height: 20px;\n  background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAOkSURBVDiNjZRtaJVlGMd/1/08zzln5zjP1LWcU9N0NkN8m2CYjpgQYQXqSs0I84OLIC0hkEKoPtiH3gmKoiJDU7QpLgoLjLIQCpEsNJ1vqUOdO7ppbuec5+V+rj4ctwzd8IIbbi6u+8f1539dt3A78eXC7QizUF7gyV1fD1Yqg4JWz84yffhm0qkFqBogB9rM8tZdtwVsPUhWhGcFJngGeWrPzHm5oaMmkfEg1usvLFyc8jLRqDOMru7AyC8saQr7GG7f5fvDeH7Ej8CM66nIF+8yngt6HWaKh7k49Soy9nXurCi1o3qUbS3zWfrYeQDTB/Qj6kX6Ybhw4B+bOYoLKCC9H3Nu/leUTZ1JdRWkkn2ldcCamzrcf47KKXdAJllSlxAOkRgyHsGC/zRday5Qld9DyoM4/q/rUoy/CXh3jzOu3bHUVZeU+DEn8FInkPBFlu3+nW3Nw0mk6vCDiWg8CeJaxEwuHS3+z5RgY+YBR6V1Z1nxSOfoaPa4LASWxxdNp+VWTk7+4vzaou8v8PN+xo+KY2xsw6une2frhw05CTYOmQvsEhjhWjn0bmXPjpE1+kplmmkP3suftwTubK9Vq22qKmrBhpY4jvd5afdRA3wGjFAgcnTK2s4hY0/GPNIb0nErGMCRxWOOX64Z8RAC4oCXdklmEvcL8o0BfkNK4lUg9HTl+oPlQxdNo3Mg4Nv175e/1LDGzZen30MEjRUtmXSfiTVu1kK8W4txyV6BMKlbgk3lMwYCiusNy9fVfvvwMxv8Ynl6vxoByANLTWplvuj/nF9m2+PDtt1eiHPBr1oIfhCChQMBw6Aw0UulqTKZdfVvfG7VcfIqLG9bcldL/+pdWTLxLUy8Qq38heUIjh4XlzZxzQm19lLFlr8vdQ97rjZVOLf8nclzckbcD4wxXMidpX30sFd37Fv/GtwwhzhxGVAprjbg0gCAEeIgwCZyTV2Z1REEW8O4py0wsjeloKoMr6iCY6dP92H6Vw/oTyICIthibxjm/DfN9lVz8IqtqKYLUXfoKVMVQVVJOElGjrnnUt9T9wbgp8AyYKaGlqingHZU/uG2NTZSVqwHQTWkx9hxjkpWDaCg6Ckj5qebgBVbT3V3NNXMSiWSDdGV3hrtzla7J+duwPOToIg42ChPQOQjspnSlp1V+Gjdged7+8UN5CRAV7a5EdFNwCjEaBR27b3W890TE7g24NAP/mMDXRWrGoFPQI9ls/MWO2dWFAar/xcOIImbbpA3zgAAAABJRU5ErkJggg==);\n}\n.bk-root .bk-logo-notebook {\n  display: inline-block;\n  vertical-align: middle;\n  margin-right: 5px;\n}\n"},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});var s=this&&this.__rest||function(t,e){var i={};for(var s in t)Object.prototype.hasOwnProperty.call(t,s)&&e.indexOf(s)<0&&(i[s]=t[s]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var n=0;for(s=Object.getOwnPropertySymbols(t);n<s.length;n++)e.indexOf(s[n])<0&&Object.prototype.propertyIsEnumerable.call(t,s[n])&&(i[s[n]]=t[s[n]])}return i};const n=t(208),a=t(77),o=t(210),l=t(90),r=t(272),h=t(169),_=t(177),d=t(170),c=t(313),u=t(15),p=t(115),f=t(314),b=t(74),g=t(19),m=t(316),v=t(8),w=t(9),y=t(215),x=t(317),z=t(318),M=t(216),O=t(79);class k extends r.LayoutDOMView{constructor(){super(...arguments),this._outer_bbox=new O.BBox,this._inner_bbox=new O.BBox,this._needs_paint=!0,this._needs_layout=!1,this._invalidated_painters=new Set,this._invalidate_all=!0}get is_paused(){return null!=this._is_paused&&0!==this._is_paused}get child_models(){return[]}pause(){null==this._is_paused?this._is_paused=1:this._is_paused+=1}unpause(t=!1){if(null==this._is_paused)throw new Error("wasn't paused");this._is_paused-=1,0!=this._is_paused||t||this.request_paint()}request_render(){this.request_paint()}request_paint(t){if(null!=t?this._invalidated_painters.add(t):this._invalidate_all=!0,!this.is_paused){const t=this.throttled_paint();this._ready=this._ready.then(()=>t)}}request_layout(){this._needs_layout=!0,this.request_paint()}reset(){"standard"==this.model.reset_policy&&(this.clear_state(),this.reset_range(),this.reset_selection()),this.model.trigger_event(new c.Reset)}remove(){this.ui_event_bus.destroy(),p.remove_views(this.renderer_views),p.remove_views(this.tool_views),this.canvas_view.remove(),super.remove()}render(){super.render(),this.el.appendChild(this.canvas_view.el),this.canvas_view.render()}initialize(){this.pause(),super.initialize(),this.state_changed=new u.Signal0(this,"state_changed"),this.lod_started=!1,this.visuals=new b.Visuals(this.model),this._initial_state_info={selection:new Map,dimensions:{width:0,height:0}},this.visibility_callbacks=[],this.state={history:[],index:-1};const{hidpi:t,output_backend:e}=this.model;this.canvas=new a.Canvas({hidpi:t,output_backend:e}),this.frame=new n.CartesianFrame(this.model.x_scale,this.model.y_scale,this.model.x_range,this.model.y_range,this.model.extra_x_ranges,this.model.extra_y_ranges),this.throttled_paint=m.throttle(()=>this.repaint(),1e3/60);const{title_location:i,title:s}=this.model;null!=i&&null!=s&&(this._title=s instanceof h.Title?s:new h.Title({text:s}));const{toolbar_location:o,toolbar:l}=this.model;null!=o&&null!=l&&(this._toolbar=new d.ToolbarPanel({toolbar:l}),l.toolbar_location=o),this.renderer_views=new Map,this.tool_views=new Map}async lazy_initialize(){this.canvas_view=await p.build_view(this.canvas,{parent:this}),this.ui_event_bus=new f.UIEvents(this,this.model.toolbar,this.canvas_view.events_el),await this.build_renderer_views(),await this.build_tool_views(),this.update_dataranges(),this.unpause(!0),g.logger.debug("PlotView initialized")}_width_policy(){return null==this.model.frame_width?super._width_policy():"min"}_height_policy(){return null==this.model.frame_height?super._height_policy():"min"}_update_layout(){this.layout=new x.BorderLayout,this.layout.set_sizing(this.box_sizing());const{frame_width:t,frame_height:e}=this.model;this.layout.center_panel=this.frame,this.layout.center_panel.set_sizing(Object.assign(Object.assign({},null!=t?{width_policy:"fixed",width:t}:{width_policy:"fit"}),null!=e?{height_policy:"fixed",height:e}:{height_policy:"fit"}));const i=w.copy(this.model.above),s=w.copy(this.model.below),n=w.copy(this.model.left),a=w.copy(this.model.right),o=t=>{switch(t){case"above":return i;case"below":return s;case"left":return n;case"right":return a}},{title_location:l,title:r}=this.model;null!=l&&null!=r&&o(l).push(this._title);const{toolbar_location:_,toolbar:c}=this.model;if(null!=_&&null!=c){const t=o(_);let e=!0;if(this.model.toolbar_sticky)for(let i=0;i<t.length;i++){const s=t[i];if(s instanceof h.Title){t[i]="above"==_||"below"==_?[s,this._toolbar]:[this._toolbar,s],e=!1;break}}e&&t.push(this._toolbar)}const u=(t,e)=>{const i=this.renderer_views.get(e);return i.layout=new z.SidePanel(t,i)},p=(t,e)=>{const i="above"==t||"below"==t,s=[];for(const n of e)if(v.isArray(n)){const e=n.map(e=>{const s=u(t,e);if(e instanceof d.ToolbarPanel){const t=i?"width_policy":"height_policy";s.set_sizing(Object.assign(Object.assign({},s.sizing),{[t]:"min"}))}return s});let a;i?(a=new M.Row(e),a.set_sizing({width_policy:"max",height_policy:"min"})):(a=new M.Column(e),a.set_sizing({width_policy:"min",height_policy:"max"})),a.absolute=!0,s.push(a)}else s.push(u(t,n));return s},f=null!=this.model.min_border?this.model.min_border:0;this.layout.min_border={left:null!=this.model.min_border_left?this.model.min_border_left:f,top:null!=this.model.min_border_top?this.model.min_border_top:f,right:null!=this.model.min_border_right?this.model.min_border_right:f,bottom:null!=this.model.min_border_bottom?this.model.min_border_bottom:f};const b=new y.VStack,g=new y.VStack,m=new y.HStack,O=new y.HStack;b.children=w.reversed(p("above",i)),g.children=p("below",s),m.children=w.reversed(p("left",n)),O.children=p("right",a),b.set_sizing({width_policy:"fit",height_policy:"min"}),g.set_sizing({width_policy:"fit",height_policy:"min"}),m.set_sizing({width_policy:"min",height_policy:"fit"}),O.set_sizing({width_policy:"min",height_policy:"fit"}),this.layout.top_panel=b,this.layout.bottom_panel=g,this.layout.left_panel=m,this.layout.right_panel=O}get axis_views(){const t=[];for(const[,e]of this.renderer_views)e instanceof _.AxisView&&t.push(e);return t}set_cursor(t="default"){this.canvas_view.el.style.cursor=t}set_toolbar_visibility(t){for(const e of this.visibility_callbacks)e(t)}update_dataranges(){const t=new Map,e=new Map;let i=!1;for(const[,t]of this.frame.x_ranges)t instanceof o.DataRange1d&&"log"==t.scale_hint&&(i=!0);for(const[,t]of this.frame.y_ranges)t instanceof o.DataRange1d&&"log"==t.scale_hint&&(i=!0);for(const[s,n]of this.renderer_views)if(n instanceof l.GlyphRendererView){const a=n.glyph.bounds();if(null!=a&&t.set(s,a),i){const t=n.glyph.log_bounds();null!=t&&e.set(s,t)}}let s=!1,n=!1;const{width:a,height:r}=this.frame.bbox;let h;!1!==this.model.match_aspect&&0!=a&&0!=r&&(h=1/this.model.aspect_scale*(a/r));for(const[,i]of this.frame.x_ranges){if(i instanceof o.DataRange1d){const n="log"==i.scale_hint?e:t;i.update(n,0,this.model,h),i.follow&&(s=!0)}null!=i.bounds&&(n=!0)}for(const[,i]of this.frame.y_ranges){if(i instanceof o.DataRange1d){const n="log"==i.scale_hint?e:t;i.update(n,1,this.model,h),i.follow&&(s=!0)}null!=i.bounds&&(n=!0)}if(s&&n){g.logger.warn("Follow enabled so bounds are unset.");for(const[,t]of this.frame.x_ranges)t.bounds=null;for(const[,t]of this.frame.y_ranges)t.bounds=null}this.range_update_timestamp=Date.now()}push_state(t,e){const{history:i,index:s}=this.state,n=null!=i[s]?i[s].info:{},a=Object.assign(Object.assign(Object.assign({},this._initial_state_info),n),e);this.state.history=this.state.history.slice(0,this.state.index+1),this.state.history.push({type:t,info:a}),this.state.index=this.state.history.length-1,this.state_changed.emit()}clear_state(){this.state={history:[],index:-1},this.state_changed.emit()}can_undo(){return this.state.index>=0}can_redo(){return this.state.index<this.state.history.length-1}undo(){this.can_undo()&&(this.state.index-=1,this._do_state_change(this.state.index),this.state_changed.emit())}redo(){this.can_redo()&&(this.state.index+=1,this._do_state_change(this.state.index),this.state_changed.emit())}_do_state_change(t){const e=null!=this.state.history[t]?this.state.history[t].info:this._initial_state_info;null!=e.range&&this.update_range(e.range),null!=e.selection&&this.update_selection(e.selection)}get_selection(){const t=new Map;for(const e of this.model.renderers)if(e instanceof l.GlyphRenderer){const{selected:i}=e.data_source;t.set(e,i)}return t}update_selection(t){for(const e of this.model.renderers){if(!(e instanceof l.GlyphRenderer))continue;const i=e.data_source;if(null!=t){const s=t.get(e);null!=s&&i.selected.update(s,!0)}else i.selection_manager.clear()}}reset_selection(){this.update_selection(null)}_update_ranges_together(t){let e=1;for(const[i,s]of t)e=Math.min(e,this._get_weight_to_constrain_interval(i,s));if(e<1)for(const[i,s]of t)s.start=e*s.start+(1-e)*i.start,s.end=e*s.end+(1-e)*i.end}_update_ranges_individually(t,e,i,s){let n=!1;for(const[s,a]of t){if(!i){const t=this._get_weight_to_constrain_interval(s,a);t<1&&(a.start=t*a.start+(1-t)*s.start,a.end=t*a.end+(1-t)*s.end)}if(null!=s.bounds&&"auto"!=s.bounds){const[t,o]=s.bounds,l=Math.abs(a.end-a.start);s.is_reversed?(null!=t&&t>=a.end&&(n=!0,a.end=t,(e||i)&&(a.start=t+l)),null!=o&&o<=a.start&&(n=!0,a.start=o,(e||i)&&(a.end=o-l))):(null!=t&&t>=a.start&&(n=!0,a.start=t,(e||i)&&(a.end=t+l)),null!=o&&o<=a.end&&(n=!0,a.end=o,(e||i)&&(a.start=o-l)))}}if(!(i&&n&&s))for(const[e,i]of t)e.have_updated_interactively=!0,e.start==i.start&&e.end==i.end||e.setv(i)}_get_weight_to_constrain_interval(t,e){const{min_interval:i}=t;let{max_interval:s}=t;if(null!=t.bounds&&"auto"!=t.bounds){const[e,i]=t.bounds;if(null!=e&&null!=i){const t=Math.abs(i-e);s=null!=s?Math.min(s,t):t}}let n=1;if(null!=i||null!=s){const a=Math.abs(t.end-t.start),o=Math.abs(e.end-e.start);i>0&&o<i&&(n=(a-i)/(a-o)),s>0&&o>s&&(n=(s-a)/(o-a)),n=Math.max(0,Math.min(1,n))}return n}update_range(t,e=!1,i=!1,s=!0){this.pause();const{x_ranges:n,y_ranges:a}=this.frame;if(null==t){for(const[,t]of n)t.reset();for(const[,t]of a)t.reset();this.update_dataranges()}else{const o=[];for(const[e,i]of n)o.push([i,t.xrs.get(e)]);for(const[e,i]of a)o.push([i,t.yrs.get(e)]);i&&this._update_ranges_together(o),this._update_ranges_individually(o,e,i,s)}this.unpause()}reset_range(){this.update_range(null)}_invalidate_layout(){(()=>{for(const t of this.model.side_panels){if(this.renderer_views.get(t).layout.has_size_changed())return!0}return!1})()&&this.root.compute_layout()}get_renderer_views(){return this.computed_renderers.map(t=>this.renderer_views.get(t))}async build_renderer_views(){this.computed_renderers=[];const{above:t,below:e,left:i,right:s,center:n,renderers:a}=this.model;this.computed_renderers.push(...t,...e,...i,...s,...n,...a),null!=this._title&&this.computed_renderers.push(this._title),null!=this._toolbar&&this.computed_renderers.push(this._toolbar);for(const t of this.model.toolbar.tools)null!=t.overlay&&this.computed_renderers.push(t.overlay),this.computed_renderers.push(...t.synthetic_renderers);await p.build_views(this.renderer_views,this.computed_renderers,{parent:this})}async build_tool_views(){const t=this.model.toolbar.tools;(await p.build_views(this.tool_views,t,{parent:this})).map(t=>this.ui_event_bus.register_tool(t))}connect_signals(){super.connect_signals();const{x_ranges:t,y_ranges:e}=this.frame;for(const[,e]of t)this.connect(e.change,()=>{this._needs_layout=!0,this.request_paint()});for(const[,t]of e)this.connect(t.change,()=>{this._needs_layout=!0,this.request_paint()});const{plot_width:i,plot_height:s}=this.model.properties;this.on_change([i,s],()=>this.invalidate_layout());const{above:n,below:a,left:o,right:l,center:r,renderers:h}=this.model.properties;this.on_change([n,a,o,l,r,h],async()=>await this.build_renderer_views()),this.connect(this.model.toolbar.properties.tools.change,async()=>{await this.build_renderer_views(),await this.build_tool_views()}),this.connect(this.model.change,()=>this.request_paint()),this.connect(this.model.reset,()=>this.reset())}set_initial_range(){let t=!0;const{x_ranges:e,y_ranges:i}=this.frame,s=new Map,n=new Map;for(const[i,n]of e){const{start:e,end:a}=n;if(null==e||null==a||isNaN(e+a)){t=!1;break}s.set(i,{start:e,end:a})}if(t)for(const[e,s]of i){const{start:i,end:a}=s;if(null==i||null==a||isNaN(i+a)){t=!1;break}n.set(e,{start:i,end:a})}t?(this._initial_state_info.range={xrs:s,yrs:n},g.logger.debug("initial ranges set")):g.logger.warn("could not set initial ranges")}has_finished(){if(!super.has_finished())return!1;if(this.model.visible)for(const[,t]of this.renderer_views)if(!t.has_finished())return!1;return!0}after_layout(){if(super.after_layout(),this._needs_layout=!1,this.model.setv({inner_width:Math.round(this.frame.bbox.width),inner_height:Math.round(this.frame.bbox.height),outer_width:Math.round(this.layout.bbox.width),outer_height:Math.round(this.layout.bbox.height)},{no_change:!0}),!1!==this.model.match_aspect&&(this.pause(),this.update_dataranges(),this.unpause(!0)),!this._outer_bbox.equals(this.layout.bbox)){const{width:t,height:e}=this.layout.bbox;this.canvas_view.resize(t,e),this._outer_bbox=this.layout.bbox,this._invalidate_all=!0,this._needs_paint=!0}this._inner_bbox.equals(this.frame.inner_bbox)||(this._inner_bbox=this.layout.inner_bbox,this._needs_paint=!0),this._needs_paint&&this.paint()}repaint(){this._needs_layout&&this._invalidate_layout(),this.paint()}paint(){if(this.is_paused||!this.model.visible)return;g.logger.trace("PlotView.paint() for "+this.model.id);const{document:t}=this.model;if(null!=t){const e=t.interactive_duration();e>=0&&e<this.model.lod_interval?setTimeout(()=>{t.interactive_duration()>this.model.lod_timeout&&t.interactive_stop(),this.request_paint()},this.model.lod_timeout):t.interactive_stop()}for(const[,t]of this.renderer_views)if(null==this.range_update_timestamp||t instanceof l.GlyphRendererView&&t.set_data_timestamp>this.range_update_timestamp){this.update_dataranges();break}let e=!1,i=!1;if(this._invalidate_all)e=!0,i=!0;else for(const t of this._invalidated_painters){const{level:s}=t.model;if("overlay"!=s?e=!0:i=!0,e&&i)break}this._invalidated_painters.clear(),this._invalidate_all=!1;const s=[this.frame.bbox.left,this.frame.bbox.top,this.frame.bbox.width,this.frame.bbox.height],{primary:n,overlays:a}=this.canvas_view;e&&(n.prepare(),this.canvas_view.prepare_webgl(s),this.canvas_view.clear_webgl(),this._map_hook(n.ctx,s),this._paint_empty(n.ctx,s),this._paint_outline(n.ctx,s),this._paint_levels(n.ctx,"image",s,!0),this._paint_levels(n.ctx,"underlay",s,!0),this._paint_levels(n.ctx,"glyph",s,!0),this._paint_levels(n.ctx,"guide",s,!1),this._paint_levels(n.ctx,"annotation",s,!1),n.finish()),i&&(a.prepare(),this._paint_levels(a.ctx,"overlay",s,!1),a.finish()),null==this._initial_state_info.range&&this.set_initial_range(),this._needs_paint=!1}_paint_levels(t,e,i,s){for(const n of this.computed_renderers){if(n.level!=e)continue;const a=this.renderer_views.get(n);t.save(),(s||a.needs_clip)&&(t.beginPath(),t.rect(...i),t.clip()),a.render(),t.restore(),a.has_webgl&&a.needs_webgl_blit&&(this.canvas_view.blit_webgl(t),this.canvas_view.clear_webgl())}}_map_hook(t,e){}_paint_empty(t,e){const[i,s,n,a]=[0,0,this.layout.bbox.width,this.layout.bbox.height],[o,l,r,h]=e;this.visuals.border_fill.doit&&(this.visuals.border_fill.set_value(t),t.fillRect(i,s,n,a),t.clearRect(o,l,r,h)),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(o,l,r,h))}_paint_outline(t,e){if(this.visuals.outline_line.doit){t.save(),this.visuals.outline_line.set_value(t);let[i,s,n,a]=e;i+n==this.layout.bbox.width&&(n-=1),s+a==this.layout.bbox.height&&(a-=1),t.strokeRect(i,s,n,a),t.restore()}}to_blob(){return this.canvas_view.to_blob()}export(t,e=!0){const i="png"==t?"canvas":"svg",s=new a.CanvasLayer(i,e),{width:n,height:o}=this.layout.bbox;s.resize(n,o);const{canvas:l}=this.canvas_view.compose();return s.ctx.drawImage(l,0,0),s}serializable_state(){const t=super.serializable_state(),{children:e}=t,i=s(t,["children"]),n=this.get_renderer_views().map(t=>t.serializable_state()).filter(t=>"bbox"in t);return Object.assign(Object.assign({},i),{children:[...e,...n]})}}i.PlotView=k,k.__name__="PlotView"},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});var n=this&&this.__decorate||function(e,t,s,n){var _,a=arguments.length,o=a<3?t:null===n?n=Object.getOwnPropertyDescriptor(t,s):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)o=Reflect.decorate(e,t,s,n);else for(var r=e.length-1;r>=0;r--)(_=e[r])&&(o=(a<3?_(o):a>3?_(t,s,o):_(t,s))||o);return a>3&&o&&Object.defineProperty(t,s,o),o};function _(e){return function(t){t.prototype.event_name=e}}class a{to_json(){const{event_name:e}=this;return{event_name:e,event_values:this._to_json()}}}s.BokehEvent=a,a.__name__="BokehEvent";class o extends a{constructor(){super(...arguments),this.origin=null}_to_json(){return{model:this.origin}}}s.ModelEvent=o,o.__name__="ModelEvent";let r=class extends a{_to_json(){return{}}};s.DocumentReady=r,r.__name__="DocumentReady",s.DocumentReady=r=n([_("document_ready")],r);let c=class extends o{};s.ButtonClick=c,c.__name__="ButtonClick",s.ButtonClick=c=n([_("button_click")],c);let l=class extends o{constructor(e){super(),this.item=e}_to_json(){const{item:e}=this;return Object.assign(Object.assign({},super._to_json()),{item:e})}};s.MenuItemClick=l,l.__name__="MenuItemClick",s.MenuItemClick=l=n([_("menu_item_click")],l);class i extends o{}s.UIEvent=i,i.__name__="UIEvent";let u=class extends i{};s.LODStart=u,u.__name__="LODStart",s.LODStart=u=n([_("lodstart")],u);let d=class extends i{};s.LODEnd=d,d.__name__="LODEnd",s.LODEnd=d=n([_("lodend")],d);let h=class extends i{constructor(e,t){super(),this.geometry=e,this.final=t}_to_json(){const{geometry:e,final:t}=this;return Object.assign(Object.assign({},super._to_json()),{geometry:e,final:t})}};s.SelectionGeometry=h,h.__name__="SelectionGeometry",s.SelectionGeometry=h=n([_("selectiongeometry")],h);let m=class extends i{};s.Reset=m,m.__name__="Reset",s.Reset=m=n([_("reset")],m);class x extends i{constructor(e,t,s,n){super(),this.sx=e,this.sy=t,this.x=s,this.y=n}_to_json(){const{sx:e,sy:t,x:s,y:n}=this;return Object.assign(Object.assign({},super._to_json()),{sx:e,sy:t,x:s,y:n})}}s.PointEvent=x,x.__name__="PointEvent";let p=class extends x{constructor(e,t,s,n,_,a){super(e,t,s,n),this.sx=e,this.sy=t,this.x=s,this.y=n,this.delta_x=_,this.delta_y=a}_to_json(){const{delta_x:e,delta_y:t}=this;return Object.assign(Object.assign({},super._to_json()),{delta_x:e,delta_y:t})}};s.Pan=p,p.__name__="Pan",s.Pan=p=n([_("pan")],p);let j=class extends x{constructor(e,t,s,n,_){super(e,t,s,n),this.sx=e,this.sy=t,this.x=s,this.y=n,this.scale=_}_to_json(){const{scale:e}=this;return Object.assign(Object.assign({},super._to_json()),{scale:e})}};s.Pinch=j,j.__name__="Pinch",s.Pinch=j=n([_("pinch")],j);let y=class extends x{constructor(e,t,s,n,_){super(e,t,s,n),this.sx=e,this.sy=t,this.x=s,this.y=n,this.rotation=_}_to_json(){const{rotation:e}=this;return Object.assign(Object.assign({},super._to_json()),{rotation:e})}};s.Rotate=y,y.__name__="Rotate",s.Rotate=y=n([_("rotate")],y);let P=class extends x{constructor(e,t,s,n,_){super(e,t,s,n),this.sx=e,this.sy=t,this.x=s,this.y=n,this.delta=_}_to_json(){const{delta:e}=this;return Object.assign(Object.assign({},super._to_json()),{delta:e})}};s.MouseWheel=P,P.__name__="MouseWheel",s.MouseWheel=P=n([_("wheel")],P);let v=class extends x{};s.MouseMove=v,v.__name__="MouseMove",s.MouseMove=v=n([_("mousemove")],v);let O=class extends x{};s.MouseEnter=O,O.__name__="MouseEnter",s.MouseEnter=O=n([_("mouseenter")],O);let b=class extends x{};s.MouseLeave=b,b.__name__="MouseLeave",s.MouseLeave=b=n([_("mouseleave")],b);let g=class extends x{};s.Tap=g,g.__name__="Tap",s.Tap=g=n([_("tap")],g);let E=class extends x{};s.DoubleTap=E,E.__name__="DoubleTap",s.DoubleTap=E=n([_("doubletap")],E);let M=class extends x{};s.Press=M,M.__name__="Press",s.Press=M=n([_("press")],M);let R=class extends x{};s.PressUp=R,R.__name__="PressUp",s.PressUp=R=n([_("pressup")],R);let f=class extends x{};s.PanStart=f,f.__name__="PanStart",s.PanStart=f=n([_("panstart")],f);let S=class extends x{};s.PanEnd=S,S.__name__="PanEnd",s.PanEnd=S=n([_("panend")],S);let D=class extends x{};s.PinchStart=D,D.__name__="PinchStart",s.PinchStart=D=n([_("pinchstart")],D);let k=class extends x{};s.PinchEnd=k,k.__name__="PinchEnd",s.PinchEnd=k=n([_("pinchend")],k);let L=class extends x{};s.RotateStart=L,L.__name__="RotateStart",s.RotateStart=L=n([_("rotatestart")],L);let C=class extends x{};s.RotateEnd=C,C.__name__="RotateEnd",s.RotateEnd=C=n([_("rotateend")],C)},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const n=t(1),i=n.__importDefault(t(297)),r=t(15),a=t(19),h=t(72),_=n.__importStar(t(313)),o=t(315),c=t(9),l=t(8),p=t(32),u=t(302);class d{constructor(t,e,s){this.plot_view=t,this.toolbar=e,this.hit_area=s,this.pan_start=new r.Signal(this,"pan:start"),this.pan=new r.Signal(this,"pan"),this.pan_end=new r.Signal(this,"pan:end"),this.pinch_start=new r.Signal(this,"pinch:start"),this.pinch=new r.Signal(this,"pinch"),this.pinch_end=new r.Signal(this,"pinch:end"),this.rotate_start=new r.Signal(this,"rotate:start"),this.rotate=new r.Signal(this,"rotate"),this.rotate_end=new r.Signal(this,"rotate:end"),this.tap=new r.Signal(this,"tap"),this.doubletap=new r.Signal(this,"doubletap"),this.press=new r.Signal(this,"press"),this.pressup=new r.Signal(this,"pressup"),this.move_enter=new r.Signal(this,"move:enter"),this.move=new r.Signal(this,"move"),this.move_exit=new r.Signal(this,"move:exit"),this.scroll=new r.Signal(this,"scroll"),this.keydown=new r.Signal(this,"keydown"),this.keyup=new r.Signal(this,"keyup"),this.hammer=new i.default(this.hit_area,{touchAction:"auto",inputClass:i.default.TouchMouseInput}),this._configure_hammerjs(),this.hit_area.addEventListener("mousemove",t=>this._mouse_move(t)),this.hit_area.addEventListener("mouseenter",t=>this._mouse_enter(t)),this.hit_area.addEventListener("mouseleave",t=>this._mouse_exit(t)),this.hit_area.addEventListener("contextmenu",t=>this._context_menu(t)),this.hit_area.addEventListener("wheel",t=>this._mouse_wheel(t)),document.addEventListener("keydown",this),document.addEventListener("keyup",this),this.menu=new u.ContextMenu([],{prevent_hide:t=>2==t.button&&t.target==this.hit_area}),this.hit_area.appendChild(this.menu.el)}destroy(){this.menu.remove(),this.hammer.destroy(),document.removeEventListener("keydown",this),document.removeEventListener("keyup",this)}handleEvent(t){"keydown"==t.type?this._key_down(t):"keyup"==t.type&&this._key_up(t)}_configure_hammerjs(){this.hammer.get("doubletap").recognizeWith("tap"),this.hammer.get("tap").requireFailure("doubletap"),this.hammer.get("doubletap").dropRequireFailure("tap"),this.hammer.on("doubletap",t=>this._doubletap(t)),this.hammer.on("tap",t=>this._tap(t)),this.hammer.on("press",t=>this._press(t)),this.hammer.on("pressup",t=>this._pressup(t)),this.hammer.get("pan").set({direction:i.default.DIRECTION_ALL}),this.hammer.on("panstart",t=>this._pan_start(t)),this.hammer.on("pan",t=>this._pan(t)),this.hammer.on("panend",t=>this._pan_end(t)),this.hammer.get("pinch").set({enable:!0}),this.hammer.on("pinchstart",t=>this._pinch_start(t)),this.hammer.on("pinch",t=>this._pinch(t)),this.hammer.on("pinchend",t=>this._pinch_end(t)),this.hammer.get("rotate").set({enable:!0}),this.hammer.on("rotatestart",t=>this._rotate_start(t)),this.hammer.on("rotate",t=>this._rotate(t)),this.hammer.on("rotateend",t=>this._rotate_end(t))}register_tool(t){const e=t.model.event_type;null!=e&&(l.isString(e)?this._register_tool(t,e):e.forEach((e,s)=>this._register_tool(t,e,s<1)))}_register_tool(t,e,s=!0){const n=t,{id:i}=n.model,r=t=>e=>{e.id==i&&t(e.e)},h=t=>e=>{t(e.e)};switch(e){case"pan":null!=n._pan_start&&n.connect(this.pan_start,r(n._pan_start.bind(n))),null!=n._pan&&n.connect(this.pan,r(n._pan.bind(n))),null!=n._pan_end&&n.connect(this.pan_end,r(n._pan_end.bind(n)));break;case"pinch":null!=n._pinch_start&&n.connect(this.pinch_start,r(n._pinch_start.bind(n))),null!=n._pinch&&n.connect(this.pinch,r(n._pinch.bind(n))),null!=n._pinch_end&&n.connect(this.pinch_end,r(n._pinch_end.bind(n)));break;case"rotate":null!=n._rotate_start&&n.connect(this.rotate_start,r(n._rotate_start.bind(n))),null!=n._rotate&&n.connect(this.rotate,r(n._rotate.bind(n))),null!=n._rotate_end&&n.connect(this.rotate_end,r(n._rotate_end.bind(n)));break;case"move":null!=n._move_enter&&n.connect(this.move_enter,r(n._move_enter.bind(n))),null!=n._move&&n.connect(this.move,r(n._move.bind(n))),null!=n._move_exit&&n.connect(this.move_exit,r(n._move_exit.bind(n)));break;case"tap":null!=n._tap&&n.connect(this.tap,r(n._tap.bind(n)));break;case"press":null!=n._press&&n.connect(this.press,r(n._press.bind(n))),null!=n._pressup&&n.connect(this.pressup,r(n._pressup.bind(n)));break;case"scroll":null!=n._scroll&&n.connect(this.scroll,r(n._scroll.bind(n)));break;default:throw new Error("unsupported event_type: "+e)}s&&(null!=n._doubletap&&n.connect(this.doubletap,h(n._doubletap.bind(n))),null!=n._keydown&&n.connect(this.keydown,h(n._keydown.bind(n))),null!=n._keyup&&n.connect(this.keyup,h(n._keyup.bind(n))),p.is_mobile&&null!=n._scroll&&"pinch"==e&&(a.logger.debug("Registering scroll on touch screen"),n.connect(this.scroll,r(n._scroll.bind(n)))))}_hit_test_renderers(t,e){const s=this.plot_view.get_renderer_views();for(const n of c.reversed(s)){const{level:s}=n.model;if(("annotation"==s||"overlay"==s)&&null!=n.interactive_hit&&n.interactive_hit(t,e))return n}return null}_hit_test_frame(t,e){return this.plot_view.frame.bbox.contains(t,e)}_hit_test_canvas(t,e){return this.plot_view.layout.bbox.contains(t,e)}_trigger(t,e,s){const n=this.toolbar.gestures,i=t.name.split(":")[0],r=this._hit_test_renderers(e.sx,e.sy),a=this._hit_test_canvas(e.sx,e.sy);switch(i){case"move":{const s=n[i].active;null!=s&&this.trigger(t,e,s.id);const h=this.toolbar.inspectors.filter(t=>t.active);let _="default";null!=r?(_=r.cursor(e.sx,e.sy)||_,c.is_empty(h)||(t=this.move_exit)):this._hit_test_frame(e.sx,e.sy)&&(c.is_empty(h)||(_="crosshair")),this.plot_view.set_cursor(_),this.plot_view.set_toolbar_visibility(a),h.map(s=>this.trigger(t,e,s.id));break}case"tap":{const{target:a}=s;if(null!=a&&a!=this.hit_area)return;null!=r&&null!=r.on_hit&&r.on_hit(e.sx,e.sy);const h=n[i].active;null!=h&&this.trigger(t,e,h.id);break}case"scroll":{const i=n[p.is_mobile?"pinch":"scroll"].active;null!=i&&(s.preventDefault(),s.stopPropagation(),this.trigger(t,e,i.id));break}case"pan":{const r=n[i].active;null!=r&&(s.preventDefault(),this.trigger(t,e,r.id));break}default:{const s=n[i].active;null!=s&&this.trigger(t,e,s.id)}}this._trigger_bokeh_event(e)}trigger(t,e,s=null){t.emit({id:s,e})}_trigger_bokeh_event(t){const e=(()=>{const{sx:e,sy:s}=t,n=this.plot_view.frame.x_scale.invert(e),i=this.plot_view.frame.y_scale.invert(s);switch(t.type){case"wheel":return new _.MouseWheel(e,s,n,i,t.delta);case"mousemove":return new _.MouseMove(e,s,n,i);case"mouseenter":return new _.MouseEnter(e,s,n,i);case"mouseleave":return new _.MouseLeave(e,s,n,i);case"tap":return new _.Tap(e,s,n,i);case"doubletap":return new _.DoubleTap(e,s,n,i);case"press":return new _.Press(e,s,n,i);case"pressup":return new _.PressUp(e,s,n,i);case"pan":return new _.Pan(e,s,n,i,t.deltaX,t.deltaY);case"panstart":return new _.PanStart(e,s,n,i);case"panend":return new _.PanEnd(e,s,n,i);case"pinch":return new _.Pinch(e,s,n,i,t.scale);case"pinchstart":return new _.PinchStart(e,s,n,i);case"pinchend":return new _.PinchEnd(e,s,n,i);case"rotate":return new _.Rotate(e,s,n,i,t.rotation);case"rotatestart":return new _.RotateStart(e,s,n,i);case"rotateend":return new _.RotateEnd(e,s,n,i);default:return}})();null!=e&&this.plot_view.model.trigger_event(e)}_get_sxy(t){const{pageX:e,pageY:s}=function(t){return"undefined"!=typeof TouchEvent&&t instanceof TouchEvent}(t)?(0!=t.touches.length?t.touches:t.changedTouches)[0]:t,{left:n,top:i}=h.offset(this.hit_area);return{sx:e-n,sy:s-i}}_pan_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{deltaX:t.deltaX,deltaY:t.deltaY,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_pinch_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{scale:t.scale,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_rotate_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{rotation:t.rotation,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_tap_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t.srcEvent)),{shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})}_move_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t)),{shiftKey:t.shiftKey,ctrlKey:t.ctrlKey})}_scroll_event(t){return Object.assign(Object.assign({type:t.type},this._get_sxy(t)),{delta:o.getDeltaY(t),shiftKey:t.shiftKey,ctrlKey:t.ctrlKey})}_key_event(t){return{type:t.type,keyCode:t.keyCode}}_pan_start(t){const e=this._pan_event(t);e.sx-=t.deltaX,e.sy-=t.deltaY,this._trigger(this.pan_start,e,t.srcEvent)}_pan(t){this._trigger(this.pan,this._pan_event(t),t.srcEvent)}_pan_end(t){this._trigger(this.pan_end,this._pan_event(t),t.srcEvent)}_pinch_start(t){this._trigger(this.pinch_start,this._pinch_event(t),t.srcEvent)}_pinch(t){this._trigger(this.pinch,this._pinch_event(t),t.srcEvent)}_pinch_end(t){this._trigger(this.pinch_end,this._pinch_event(t),t.srcEvent)}_rotate_start(t){this._trigger(this.rotate_start,this._rotate_event(t),t.srcEvent)}_rotate(t){this._trigger(this.rotate,this._rotate_event(t),t.srcEvent)}_rotate_end(t){this._trigger(this.rotate_end,this._rotate_event(t),t.srcEvent)}_tap(t){this._trigger(this.tap,this._tap_event(t),t.srcEvent)}_doubletap(t){const e=this._tap_event(t);this._trigger_bokeh_event(e),this.trigger(this.doubletap,e)}_press(t){this._trigger(this.press,this._tap_event(t),t.srcEvent)}_pressup(t){this._trigger(this.pressup,this._tap_event(t),t.srcEvent)}_mouse_enter(t){this._trigger(this.move_enter,this._move_event(t),t)}_mouse_move(t){this._trigger(this.move,this._move_event(t),t)}_mouse_exit(t){this._trigger(this.move_exit,this._move_event(t),t)}_mouse_wheel(t){this._trigger(this.scroll,this._scroll_event(t),t)}_context_menu(t){!this.menu.is_open&&this.menu.can_open&&t.preventDefault();const{sx:e,sy:s}=this._get_sxy(t);this.menu.toggle({left:e,top:s})}_key_down(t){this.trigger(this.keydown,this._key_event(t))}_key_up(t){this.trigger(this.keyup,this._key_event(t))}}s.UIEvents=d,d.__name__="UIEvents"},
function _(e,t,n){
/*!
     * jQuery Mousewheel 3.1.13
     *
     * Copyright jQuery Foundation and other contributors
     * Released under the MIT license
     * http://jquery.org/license
     */
function r(e){const t=getComputedStyle(e).fontSize;return null!=t?parseInt(t,10):null}Object.defineProperty(n,"__esModule",{value:!0}),n.getDeltaY=function(e){let t=-e.deltaY;if(e.target instanceof HTMLElement)switch(e.deltaMode){case e.DOM_DELTA_LINE:t*=r((n=e.target).offsetParent||document.body)||r(n)||16;break;case e.DOM_DELTA_PAGE:t*=function(e){return e.clientHeight}(e.target)}var n;return t}},
function _(n,e,o){Object.defineProperty(o,"__esModule",{value:!0});const t=("undefined"!=typeof window?window.requestAnimationFrame:void 0)||("undefined"!=typeof window?window.webkitRequestAnimationFrame:void 0)||("undefined"!=typeof window?window.mozRequestAnimationFrame:void 0)||("undefined"!=typeof window?window.msRequestAnimationFrame:void 0)||function(n){return n(Date.now()),-1};o.throttle=function(n,e){let o=null,i=0,u=!1;return function(){return new Promise((d,w)=>{const r=function(){i=Date.now(),o=null,u=!1;try{n(),d()}catch(n){w(n)}},a=Date.now(),f=e-(a-i);f<=0&&!u?(null!=o&&clearTimeout(o),u=!0,t(r)):o||u?d():o=setTimeout(()=>t(r),f)})}}},
function _(t,e,h){Object.defineProperty(h,"__esModule",{value:!0});const i=t(213),o=t(214),r=t(79);class s extends o.Layoutable{constructor(){super(...arguments),this.min_border={left:0,top:0,right:0,bottom:0}}_measure(t){t=new i.Sizeable(t).bounded_to(this.sizing.size);const e=this.left_panel.measure({width:0,height:t.height}),h=Math.max(e.width,this.min_border.left),o=this.right_panel.measure({width:0,height:t.height}),r=Math.max(o.width,this.min_border.right),s=this.top_panel.measure({width:t.width,height:0}),n=Math.max(s.height,this.min_border.top),a=this.bottom_panel.measure({width:t.width,height:0}),g=Math.max(a.height,this.min_border.bottom),_=new i.Sizeable(t).shrink_by({left:h,right:r,top:n,bottom:g}),m=this.center_panel.measure(_);return{width:h+m.width+r,height:n+m.height+g,inner:{left:h,right:r,top:n,bottom:g},align:(()=>{const{width_policy:t,height_policy:e}=this.center_panel.sizing;return"fixed"!=t&&"fixed"!=e})()}}_set_geometry(t,e){super._set_geometry(t,e),this.center_panel.set_geometry(e);const h=this.left_panel.measure({width:0,height:t.height}),i=this.right_panel.measure({width:0,height:t.height}),o=this.top_panel.measure({width:t.width,height:0}),s=this.bottom_panel.measure({width:t.width,height:0}),{left:n,top:a,right:g,bottom:_}=e;this.top_panel.set_geometry(new r.BBox({left:n,right:g,bottom:a,height:o.height})),this.bottom_panel.set_geometry(new r.BBox({left:n,right:g,top:_,height:s.height})),this.left_panel.set_geometry(new r.BBox({top:a,bottom:_,right:n,width:h.width})),this.right_panel.set_geometry(new r.BBox({top:a,bottom:_,left:g,width:i.width}))}}h.BorderLayout=s,s.__name__="BorderLayout"},
function _(i,t,e){Object.defineProperty(e,"__esModule",{value:!0});const l=i(213),a=i(214),r=i(8),o=Math.PI/2,h="left",s="center",n={above:{parallel:0,normal:-o,horizontal:0,vertical:-o},below:{parallel:0,normal:o,horizontal:0,vertical:o},left:{parallel:-o,normal:0,horizontal:0,vertical:-o},right:{parallel:o,normal:0,horizontal:0,vertical:o}},d={above:{justified:"top",parallel:"alphabetic",normal:"middle",horizontal:"alphabetic",vertical:"middle"},below:{justified:"bottom",parallel:"hanging",normal:"middle",horizontal:"hanging",vertical:"middle"},left:{justified:"top",parallel:"alphabetic",normal:"middle",horizontal:"middle",vertical:"alphabetic"},right:{justified:"top",parallel:"alphabetic",normal:"middle",horizontal:"middle",vertical:"alphabetic"}},_={above:{justified:s,parallel:s,normal:h,horizontal:s,vertical:h},below:{justified:s,parallel:s,normal:h,horizontal:s,vertical:h},left:{justified:s,parallel:s,normal:"right",horizontal:"right",vertical:s},right:{justified:s,parallel:s,normal:h,horizontal:h,vertical:s}},c={above:"right",below:h,left:"right",right:h},m={above:h,below:"right",left:"right",right:h};class g extends a.ContentLayoutable{constructor(i,t){switch(super(),this.side=i,this.obj=t,this.side){case"above":this._dim=0,this._normals=[0,-1];break;case"below":this._dim=0,this._normals=[0,1];break;case"left":this._dim=1,this._normals=[-1,0];break;case"right":this._dim=1,this._normals=[1,0]}this.is_horizontal?this.set_sizing({width_policy:"max",height_policy:"fixed"}):this.set_sizing({width_policy:"fixed",height_policy:"max"})}_content_size(){return new l.Sizeable(this.get_oriented_size())}get_oriented_size(){const{width:i,height:t}=this.obj.get_size();return!this.obj.rotate||this.is_horizontal?{width:i,height:t}:{width:t,height:i}}has_size_changed(){const{width:i,height:t}=this.get_oriented_size();return this.is_horizontal?this.bbox.height!=t:this.bbox.width!=i}get dimension(){return this._dim}get normals(){return this._normals}get is_horizontal(){return 0==this._dim}get is_vertical(){return 1==this._dim}apply_label_text_heuristics(i,t){const e=this.side;let l,a;r.isString(t)?(l=d[e][t],a=_[e][t]):t<0?(l="middle",a=c[e]):(l="middle",a=m[e]),i.textBaseline=l,i.textAlign=a}get_label_angle_heuristic(i){return n[this.side][i]}}e.SidePanel=g,g.__name__="SidePanel"},
function _(t,e,s){Object.defineProperty(s,"__esModule",{value:!0});const i=t(15),o=t(72),a=t(37),n=t(312),p=new i.Signal0({},"gmaps_ready");class l extends n.PlotView{initialize(){this.pause(),super.initialize(),this._tiles_loaded=!1,this.zoom_count=0;const{zoom:t,lat:e,lng:s}=this.model.map_options;if(this.initial_zoom=t,this.initial_lat=e,this.initial_lng=s,"undefined"==typeof google||null==google.maps){if(void 0===window._bokeh_gmaps_callback){!function(t){window._bokeh_gmaps_callback=()=>p.emit();const e=document.createElement("script");e.type="text/javascript",e.src=`https://maps.googleapis.com/maps/api/js?v=3.36&key=${t}&callback=_bokeh_gmaps_callback`,document.body.appendChild(e)}(atob(this.model.api_key))}p.connect(()=>this.request_render())}this.unpause()}remove(){o.remove(this.map_el),super.remove()}update_range(t){if(null==t)this.map.setCenter({lat:this.initial_lat,lng:this.initial_lng}),this.map.setOptions({zoom:this.initial_zoom}),super.update_range(null);else if(null!=t.sdx||null!=t.sdy)this.map.panBy(t.sdx||0,t.sdy||0),super.update_range(t);else if(null!=t.factor){if(10!==this.zoom_count)return void(this.zoom_count+=1);this.zoom_count=0,this.pause(),super.update_range(t);const e=t.factor<0?-1:1,s=this.map.getZoom(),i=s+e;if(i>=2){this.map.setZoom(i);const[t,e,,]=this._get_projected_bounds();e-t<0&&this.map.setZoom(s)}this.unpause()}this._set_bokeh_ranges()}_build_map(){const{maps:t}=google;this.map_types={satellite:t.MapTypeId.SATELLITE,terrain:t.MapTypeId.TERRAIN,roadmap:t.MapTypeId.ROADMAP,hybrid:t.MapTypeId.HYBRID};const e=this.model.map_options,s={center:new t.LatLng(e.lat,e.lng),zoom:e.zoom,disableDefaultUI:!0,mapTypeId:this.map_types[e.map_type],scaleControl:e.scale_control,tilt:e.tilt};null!=e.styles&&(s.styles=JSON.parse(e.styles)),this.map_el=o.div({style:{position:"absolute"}}),this.canvas_view.add_underlay(this.map_el),this.map=new t.Map(this.map_el,s),t.event.addListener(this.map,"idle",()=>this._set_bokeh_ranges()),t.event.addListener(this.map,"bounds_changed",()=>this._set_bokeh_ranges()),t.event.addListenerOnce(this.map,"tilesloaded",()=>this._render_finished()),this.connect(this.model.properties.map_options.change,()=>this._update_options()),this.connect(this.model.map_options.properties.styles.change,()=>this._update_styles()),this.connect(this.model.map_options.properties.lat.change,()=>this._update_center("lat")),this.connect(this.model.map_options.properties.lng.change,()=>this._update_center("lng")),this.connect(this.model.map_options.properties.zoom.change,()=>this._update_zoom()),this.connect(this.model.map_options.properties.map_type.change,()=>this._update_map_type()),this.connect(this.model.map_options.properties.scale_control.change,()=>this._update_scale_control()),this.connect(this.model.map_options.properties.tilt.change,()=>this._update_tilt())}_render_finished(){this._tiles_loaded=!0,this.notify_finished()}has_finished(){return super.has_finished()&&!0===this._tiles_loaded}_get_latlon_bounds(){const t=this.map.getBounds(),e=t.getNorthEast(),s=t.getSouthWest();return[s.lng(),e.lng(),s.lat(),e.lat()]}_get_projected_bounds(){const[t,e,s,i]=this._get_latlon_bounds(),[o,n]=a.wgs84_mercator.compute(t,s),[p,l]=a.wgs84_mercator.compute(e,i);return[o,p,n,l]}_set_bokeh_ranges(){const[t,e,s,i]=this._get_projected_bounds();this.frame.x_range.setv({start:t,end:e}),this.frame.y_range.setv({start:s,end:i})}_update_center(t){const e=this.map.getCenter().toJSON();e[t]=this.model.map_options[t],this.map.setCenter(e),this._set_bokeh_ranges()}_update_map_type(){this.map.setOptions({mapTypeId:this.map_types[this.model.map_options.map_type]})}_update_scale_control(){this.map.setOptions({scaleControl:this.model.map_options.scale_control})}_update_tilt(){this.map.setOptions({tilt:this.model.map_options.tilt})}_update_options(){this._update_styles(),this._update_center("lat"),this._update_center("lng"),this._update_zoom(),this._update_map_type()}_update_styles(){this.map.setOptions({styles:JSON.parse(this.model.map_options.styles)})}_update_zoom(){this.map.setOptions({zoom:this.model.map_options.zoom}),this._set_bokeh_ranges()}_map_hook(t,e){if(null==this.map&&"undefined"!=typeof google&&null!=google.maps&&this._build_map(),null!=this.map_el){const[t,s,i,o]=e;this.map_el.style.top=s+"px",this.map_el.style.left=t+"px",this.map_el.style.width=i+"px",this.map_el.style.height=o+"px"}}_paint_empty(t,e){const s=this.layout.bbox.width,i=this.layout.bbox.height,[o,a,n,p]=e;t.clearRect(0,0,s,i),t.beginPath(),t.moveTo(0,0),t.lineTo(0,i),t.lineTo(s,i),t.lineTo(s,0),t.lineTo(0,0),t.moveTo(o,a),t.lineTo(o+n,a),t.lineTo(o+n,a+p),t.lineTo(o,a+p),t.lineTo(o,a),t.closePath(),null!=this.model.border_fill_color&&(t.fillStyle=this.model.border_fill_color,t.fill())}}s.GMapPlotView=l,l.__name__="GMapPlotView"},
function _(a,e,n){Object.defineProperty(n,"__esModule",{value:!0});var g=a(211);n.DataRange=g.DataRange;var R=a(210);n.DataRange1d=R.DataRange1d;var r=a(98);n.FactorRange=r.FactorRange;var t=a(99);n.Range=t.Range;var d=a(158);n.Range1d=d.Range1d},
function _(e,r,d){Object.defineProperty(d,"__esModule",{value:!0});var n=e(90);d.GlyphRenderer=n.GlyphRenderer;var R=e(116);d.GraphRenderer=R.GraphRenderer;var a=e(178);d.GuideRenderer=a.GuideRenderer;var G=e(70);d.Renderer=G.Renderer},
function _(a,e,l){Object.defineProperty(l,"__esModule",{value:!0});var c=a(209);l.CategoricalScale=c.CategoricalScale;var r=a(146);l.ContinuousScale=r.ContinuousScale;var n=a(145);l.LinearScale=n.LinearScale;var o=a(156);l.LinearInterpolationScale=o.LinearInterpolationScale;var i=a(157);l.LogScale=i.LogScale;var S=a(147);l.Scale=S.Scale},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});e(1).__exportStar(e(118),o);var n=e(88);o.Selection=n.Selection},
function _(a,e,r){Object.defineProperty(r,"__esModule",{value:!0});var o=a(325);r.ServerSentDataSource=o.ServerSentDataSource;var S=a(327);r.AjaxDataSource=S.AjaxDataSource;var u=a(85);r.ColumnDataSource=u.ColumnDataSource;var t=a(86);r.ColumnarDataSource=t.ColumnarDataSource;var c=a(114);r.CDSView=c.CDSView;var D=a(87);r.DataSource=D.DataSource;var v=a(328);r.GeoJSONDataSource=v.GeoJSONDataSource;var n=a(326);r.WebDataSource=n.WebDataSource},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const a=e(326);class s extends a.WebDataSource{constructor(e){super(e),this.initialized=!1}destroy(){super.destroy()}setup(){if(!this.initialized){this.initialized=!0;new EventSource(this.data_url).onmessage=e=>{this.load_data(JSON.parse(e.data),this.mode,this.max_size)}}}}i.ServerSentDataSource=s,s.__name__="ServerSentDataSource"},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const r=e(1),s=e(85),i=r.__importStar(e(18));class n extends s.ColumnDataSource{constructor(e){super(e)}get_column(e){const t=this.data[e];return null!=t?t:[]}initialize(){super.initialize(),this.setup()}load_data(e,t,a){const{adapter:r}=this;let s;switch(s=null!=r?r.execute(this,{response:e}):e,t){case"replace":this.data=s;break;case"append":{const e=this.data;for(const t of this.columns()){const r=Array.from(e[t]),i=Array.from(s[t]);s[t]=r.concat(i).slice(-a)}this.data=s;break}}}static init_WebDataSource(){this.define({mode:[i.UpdateMode,"replace"],max_size:[i.Number],adapter:[i.Any,null],data_url:[i.String]})}}a.WebDataSource=n,n.__name__="WebDataSource",n.init_WebDataSource()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const s=t(1),a=t(326),r=t(19),o=s.__importStar(t(18)),n=t(13);class d extends a.WebDataSource{constructor(t){super(t),this.initialized=!1}static init_AjaxDataSource(){this.define({polling_interval:[o.Number],content_type:[o.String,"application/json"],http_headers:[o.Any,{}],method:[o.HTTPMethod,"POST"],if_modified:[o.Boolean,!1]})}destroy(){null!=this.interval&&clearInterval(this.interval),super.destroy()}setup(){if(!this.initialized&&(this.initialized=!0,this.get_data(this.mode),this.polling_interval)){const t=()=>this.get_data(this.mode,this.max_size,this.if_modified);this.interval=setInterval(t,this.polling_interval)}}get_data(t,e=0,i=!1){const s=this.prepare_request();s.addEventListener("load",()=>this.do_load(s,t,e)),s.addEventListener("error",()=>this.do_error(s)),s.send()}prepare_request(){const t=new XMLHttpRequest;t.open(this.method,this.data_url,!0),t.withCredentials=!1,t.setRequestHeader("Content-Type",this.content_type);const e=this.http_headers;for(const[i,s]of n.entries(e))t.setRequestHeader(i,s);return t}do_load(t,e,i){if(200===t.status){const s=JSON.parse(t.responseText);this.load_data(s,e,i)}}do_error(t){r.logger.error(`Failed to fetch JSON from ${this.data_url} with code ${t.status}`)}}i.AjaxDataSource=d,d.__name__="AjaxDataSource",d.init_AjaxDataSource()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});const r=e(1),n=e(86),s=e(19),a=r.__importStar(e(18)),i=e(9),l=e(13);function c(e){return null!=e?e:NaN}class _ extends n.ColumnarDataSource{constructor(e){super(e)}static init_GeoJSONDataSource(){this.define({geojson:[a.Any]}),this.internal({data:[a.Any,{}]})}initialize(){super.initialize(),this._update_data()}connect_signals(){super.connect_signals(),this.connect(this.properties.geojson.change,()=>this._update_data())}_update_data(){this.data=this.geojson_to_column_data()}_get_new_list_array(e){return i.range(0,e).map(e=>[])}_get_new_nan_array(e){return i.range(0,e).map(e=>NaN)}_add_properties(e,t,o,r){var n;const s=null!==(n=e.properties)&&void 0!==n?n:{};for(const[e,n]of l.entries(s))t.hasOwnProperty(e)||(t[e]=this._get_new_nan_array(r)),t[e][o]=c(n)}_add_geometry(e,t,o){function r(e,t){return e.concat([[NaN,NaN,NaN]]).concat(t)}switch(e.type){case"Point":{const[r,n,s]=e.coordinates;t.x[o]=r,t.y[o]=n,t.z[o]=c(s);break}case"LineString":{const{coordinates:r}=e;for(let e=0;e<r.length;e++){const[n,s,a]=r[e];t.xs[o][e]=n,t.ys[o][e]=s,t.zs[o][e]=c(a)}break}case"Polygon":{e.coordinates.length>1&&s.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used.");const r=e.coordinates[0];for(let e=0;e<r.length;e++){const[n,s,a]=r[e];t.xs[o][e]=n,t.ys[o][e]=s,t.zs[o][e]=c(a)}break}case"MultiPoint":s.logger.warn("MultiPoint not supported in Bokeh");break;case"MultiLineString":{const n=e.coordinates.reduce(r);for(let e=0;e<n.length;e++){const[r,s,a]=n[e];t.xs[o][e]=r,t.ys[o][e]=s,t.zs[o][e]=c(a)}break}case"MultiPolygon":{const n=[];for(const t of e.coordinates)t.length>1&&s.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used."),n.push(t[0]);const a=n.reduce(r);for(let e=0;e<a.length;e++){const[r,n,s]=a[e];t.xs[o][e]=r,t.ys[o][e]=n,t.zs[o][e]=c(s)}break}default:throw new Error("Invalid GeoJSON geometry type: "+e.type)}}geojson_to_column_data(){const e=JSON.parse(this.geojson);let t;switch(e.type){case"GeometryCollection":if(null==e.geometries)throw new Error("No geometries found in GeometryCollection");if(0===e.geometries.length)throw new Error("geojson.geometries must have one or more items");t=e.geometries;break;case"FeatureCollection":if(null==e.features)throw new Error("No features found in FeaturesCollection");if(0==e.features.length)throw new Error("geojson.features must have one or more items");t=e.features;break;default:throw new Error("Bokeh only supports type GeometryCollection and FeatureCollection at top level")}let o=0;for(const e of t){const t="Feature"===e.type?e.geometry:e;"GeometryCollection"==t.type?o+=t.geometries.length:o+=1}const r={x:this._get_new_nan_array(o),y:this._get_new_nan_array(o),z:this._get_new_nan_array(o),xs:this._get_new_list_array(o),ys:this._get_new_list_array(o),zs:this._get_new_list_array(o)};let n=0;for(const e of t){const t="Feature"==e.type?e.geometry:e;if("GeometryCollection"==t.type)for(const s of t.geometries)this._add_geometry(s,r,n),"Feature"===e.type&&this._add_properties(e,r,n,o),n+=1;else this._add_geometry(t,r,n),"Feature"===e.type&&this._add_properties(e,r,n,o),n+=1}return r}}o.GeoJSONDataSource=_,_.__name__="GeoJSONDataSource",_.init_GeoJSONDataSource()},
function _(e,r,i){Object.defineProperty(i,"__esModule",{value:!0});var c=e(127);i.AdaptiveTicker=c.AdaptiveTicker;var a=e(126);i.BasicTicker=a.BasicTicker;var k=e(180);i.CategoricalTicker=k.CategoricalTicker;var T=e(191);i.CompositeTicker=T.CompositeTicker;var t=e(128);i.ContinuousTicker=t.ContinuousTicker;var o=e(190);i.DatetimeTicker=o.DatetimeTicker;var v=e(192);i.DaysTicker=v.DaysTicker;var n=e(330);i.FixedTicker=n.FixedTicker;var s=e(199);i.LogTicker=s.LogTicker;var l=e(202);i.MercatorTicker=l.MercatorTicker;var u=e(195);i.MonthsTicker=u.MonthsTicker;var d=e(193);i.SingleIntervalTicker=d.SingleIntervalTicker;var g=e(129);i.Ticker=g.Ticker;var C=e(196);i.YearsTicker=C.YearsTicker},
function _(i,t,e){Object.defineProperty(e,"__esModule",{value:!0});const r=i(1),n=i(128),s=r.__importStar(i(18));class _ extends n.ContinuousTicker{constructor(i){super(i),this.min_interval=0,this.max_interval=0}static init_FixedTicker(){this.define({ticks:[s.Array,[]],minor_ticks:[s.Array,[]]})}get_ticks_no_defaults(i,t,e,r){return{major:this.ticks,minor:this.minor_ticks}}get_interval(i,t,e){return 0}}e.FixedTicker=_,_.__name__="FixedTicker",_.init_FixedTicker()},
function _(e,r,o){Object.defineProperty(o,"__esModule",{value:!0});var T=e(332);o.BBoxTileSource=T.BBoxTileSource;var c=e(333);o.MercatorTileSource=c.MercatorTileSource;var i=e(336);o.QUADKEYTileSource=i.QUADKEYTileSource;var l=e(337);o.TileRenderer=l.TileRenderer;var S=e(334);o.TileSource=S.TileSource;var u=e(341);o.TMSTileSource=u.TMSTileSource;var a=e(338);o.WMTSTileSource=a.WMTSTileSource},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const o=e(1),i=e(333),l=o.__importStar(e(18));class _ extends i.MercatorTileSource{constructor(e){super(e)}static init_BBoxTileSource(){this.define({use_latlon:[l.Boolean,!1]})}get_image_url(e,t,r){const o=this.string_lookup_replace(this.url,this.extra_url_vars);let i,l,_,n;return this.use_latlon?[l,n,i,_]=this.get_tile_geographic_bounds(e,t,r):[l,n,i,_]=this.get_tile_meter_bounds(e,t,r),o.replace("{XMIN}",l.toString()).replace("{YMIN}",n.toString()).replace("{XMAX}",i.toString()).replace("{YMAX}",_.toString())}}r.BBoxTileSource=_,_.__name__="BBoxTileSource",_.init_BBoxTileSource()},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const _=t(1),s=t(334),r=_.__importStar(t(18)),o=t(9),n=t(335);class l extends s.TileSource{constructor(t){super(t)}static init_MercatorTileSource(){this.define({snap_to_zoom:[r.Boolean,!1],wrap_around:[r.Boolean,!0]}),this.override({x_origin_offset:20037508.34,y_origin_offset:20037508.34,initial_resolution:156543.03392804097})}initialize(){super.initialize(),this._resolutions=o.range(this.min_zoom,this.max_zoom+1).map(t=>this.get_resolution(t))}_computed_initial_resolution(){return null!=this.initial_resolution?this.initial_resolution:2*Math.PI*6378137/this.tile_size}is_valid_tile(t,e,i){return!(!this.wrap_around&&(t<0||t>=2**i))&&!(e<0||e>=2**i)}parent_by_tile_xyz(t,e,i){const _=this.tile_xyz_to_quadkey(t,e,i),s=_.substring(0,_.length-1);return this.quadkey_to_tile_xyz(s)}get_resolution(t){return this._computed_initial_resolution()/2**t}get_resolution_by_extent(t,e,i){return[(t[2]-t[0])/i,(t[3]-t[1])/e]}get_level_by_extent(t,e,i){const _=(t[2]-t[0])/i,s=(t[3]-t[1])/e,r=Math.max(_,s);let o=0;for(const t of this._resolutions){if(r>t){if(0==o)return 0;if(o>0)return o-1}o+=1}return o-1}get_closest_level_by_extent(t,e,i){const _=(t[2]-t[0])/i,s=(t[3]-t[1])/e,r=Math.max(_,s),o=this._resolutions.reduce((function(t,e){return Math.abs(e-r)<Math.abs(t-r)?e:t}));return this._resolutions.indexOf(o)}snap_to_zoom_level(t,e,i,_){const[s,r,o,n]=t,l=this._resolutions[_];let u=i*l,a=e*l;if(!this.snap_to_zoom){const t=(o-s)/u,e=(n-r)/a;t>e?(u=o-s,a*=t):(u*=e,a=n-r)}const h=(u-(o-s))/2,c=(a-(n-r))/2;return[s-h,r-c,o+h,n+c]}tms_to_wmts(t,e,i){return[t,2**i-1-e,i]}wmts_to_tms(t,e,i){return[t,2**i-1-e,i]}pixels_to_meters(t,e,i){const _=this.get_resolution(i);return[t*_-this.x_origin_offset,e*_-this.y_origin_offset]}meters_to_pixels(t,e,i){const _=this.get_resolution(i);return[(t+this.x_origin_offset)/_,(e+this.y_origin_offset)/_]}pixels_to_tile(t,e){let i=Math.ceil(t/this.tile_size);i=0===i?i:i-1;return[i,Math.max(Math.ceil(e/this.tile_size)-1,0)]}pixels_to_raster(t,e,i){return[t,(this.tile_size<<i)-e]}meters_to_tile(t,e,i){const[_,s]=this.meters_to_pixels(t,e,i);return this.pixels_to_tile(_,s)}get_tile_meter_bounds(t,e,i){const[_,s]=this.pixels_to_meters(t*this.tile_size,e*this.tile_size,i),[r,o]=this.pixels_to_meters((t+1)*this.tile_size,(e+1)*this.tile_size,i);return[_,s,r,o]}get_tile_geographic_bounds(t,e,i){const _=this.get_tile_meter_bounds(t,e,i),[s,r,o,l]=n.meters_extent_to_geographic(_);return[s,r,o,l]}get_tiles_by_extent(t,e,i=1){const[_,s,r,o]=t;let[n,l]=this.meters_to_tile(_,s,e),[u,a]=this.meters_to_tile(r,o,e);n-=i,l-=i,u+=i,a+=i;const h=[];for(let t=a;t>=l;t--)for(let i=n;i<=u;i++)this.is_valid_tile(i,t,e)&&h.push([i,t,e,this.get_tile_meter_bounds(i,t,e)]);return this.sort_tiles_from_center(h,[n,l,u,a]),h}quadkey_to_tile_xyz(t){let e=0,i=0;const _=t.length;for(let s=_;s>0;s--){const r=1<<s-1;switch(t.charAt(_-s)){case"0":continue;case"1":e|=r;break;case"2":i|=r;break;case"3":e|=r,i|=r;break;default:throw new TypeError("Invalid Quadkey: "+t)}}return[e,i,_]}tile_xyz_to_quadkey(t,e,i){let _="";for(let s=i;s>0;s--){const i=1<<s-1;let r=0;0!=(t&i)&&(r+=1),0!=(e&i)&&(r+=2),_+=r.toString()}return _}children_by_tile_xyz(t,e,i){const _=this.tile_xyz_to_quadkey(t,e,i),s=[];for(let t=0;t<=3;t++){const[e,i,r]=this.quadkey_to_tile_xyz(_+t.toString()),o=this.get_tile_meter_bounds(e,i,r);s.push([e,i,r,o])}return s}get_closest_parent_by_tile_xyz(t,e,i){const _=this.calculate_world_x_by_tile_xyz(t,e,i);[t,e,i]=this.normalize_xyz(t,e,i);let s=this.tile_xyz_to_quadkey(t,e,i);for(;s.length>0;)if(s=s.substring(0,s.length-1),[t,e,i]=this.quadkey_to_tile_xyz(s),[t,e,i]=this.denormalize_xyz(t,e,i,_),this.tiles.has(this.tile_xyz_to_key(t,e,i)))return[t,e,i];return[0,0,0]}normalize_xyz(t,e,i){if(this.wrap_around){const _=2**i;return[(t%_+_)%_,e,i]}return[t,e,i]}denormalize_xyz(t,e,i,_){return[t+_*2**i,e,i]}denormalize_meters(t,e,i,_){return[t+2*_*Math.PI*6378137,e]}calculate_world_x_by_tile_xyz(t,e,i){return Math.floor(t/2**i)}}i.MercatorTileSource=l,l.__name__="MercatorTileSource",l.init_MercatorTileSource()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const i=e(1),n=e(81),s=e(13),l=i.__importStar(e(18));class a extends n.Model{constructor(e){super(e)}static init_TileSource(){this.define({url:[l.String,""],tile_size:[l.Number,256],max_zoom:[l.Number,30],min_zoom:[l.Number,0],extra_url_vars:[l.Any,{}],attribution:[l.String,""],x_origin_offset:[l.Number],y_origin_offset:[l.Number],initial_resolution:[l.Number]})}initialize(){super.initialize(),this.tiles=new Map,this._normalize_case()}connect_signals(){super.connect_signals(),this.connect(this.change,()=>this._clear_cache())}string_lookup_replace(e,t){let r=e;for(const[e,i]of s.entries(t))r=r.replace(`{${e}}`,i);return r}_normalize_case(){const e=this.url.replace("{x}","{X}").replace("{y}","{Y}").replace("{z}","{Z}").replace("{q}","{Q}").replace("{xmin}","{XMIN}").replace("{ymin}","{YMIN}").replace("{xmax}","{XMAX}").replace("{ymax}","{YMAX}");this.url=e}_clear_cache(){this.tiles=new Map}tile_xyz_to_key(e,t,r){return`${e}:${t}:${r}`}key_to_tile_xyz(e){const[t,r,i]=e.split(":").map(e=>parseInt(e));return[t,r,i]}sort_tiles_from_center(e,t){const[r,i,n,s]=t,l=(n-r)/2+r,a=(s-i)/2+i;e.sort((function(e,t){return Math.sqrt((l-e[0])**2+(a-e[1])**2)-Math.sqrt((l-t[0])**2+(a-t[1])**2)}))}get_image_url(e,t,r){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",e.toString()).replace("{Y}",t.toString()).replace("{Z}",r.toString())}}r.TileSource=a,a.__name__="TileSource",a.init_TileSource()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const n=e(37);function o(e,t){return n.wgs84_mercator.compute(e,t)}function c(e,t){return n.wgs84_mercator.invert(e,t)}r.geographic_to_meters=o,r.meters_to_geographic=c,r.geographic_extent_to_meters=function(e){const[t,r,n,c]=e,[_,u]=o(t,r),[i,g]=o(n,c);return[_,u,i,g]},r.meters_extent_to_geographic=function(e){const[t,r,n,o]=e,[_,u]=c(t,r),[i,g]=c(n,o);return[_,u,i,g]}},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const _=e(333);class s extends _.MercatorTileSource{constructor(e){super(e)}get_image_url(e,t,r){const _=this.string_lookup_replace(this.url,this.extra_url_vars),[s,o,u]=this.tms_to_wmts(e,t,r),c=this.tile_xyz_to_quadkey(s,o,u);return _.replace("{Q}",c)}}r.QUADKEYTileSource=s,s.__name__="QUADKEYTileSource"},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0});const s=t(1),_=t(338),n=t(91),a=t(158),r=t(72),o=s.__importStar(t(18)),h=t(251),l=t(9),d=t(8),m=t(89),c=t(85),g=t(339),p=s.__importDefault(t(340));class u extends n.DataRendererView{initialize(){this._tiles=[],super.initialize()}connect_signals(){super.connect_signals(),this.connect(this.model.change,()=>this.request_render()),this.connect(this.model.tile_source.change,()=>this.request_render())}styles(){return[...super.styles(),p.default]}get_extent(){return[this.x_range.start,this.y_range.start,this.x_range.end,this.y_range.end]}get map_plot(){return this.plot_model}get map_canvas(){return this.layer.ctx}get map_frame(){return this.plot_view.frame}get x_range(){return this.map_plot.x_range}get y_range(){return this.map_plot.y_range}_set_data(){this.extent=this.get_extent(),this._last_height=void 0,this._last_width=void 0}_update_attribution(){null!=this.attribution_el&&r.removeElement(this.attribution_el);const{attribution:t}=this.model.tile_source;if(d.isString(t)&&t.length>0){const{layout:e,frame:i}=this.plot_view,s=e.bbox.width-i.bbox.right,_=e.bbox.height-i.bbox.bottom,n=i.bbox.width;this.attribution_el=r.div({class:g.bk_tile_attribution,style:{position:"absolute",right:s+"px",bottom:_+"px","max-width":n-4+"px",padding:"2px","background-color":"rgba(255,255,255,0.5)","font-size":"9px","line-height":"1.05","white-space":"nowrap",overflow:"hidden","text-overflow":"ellipsis"}}),this.plot_view.canvas_view.add_event(this.attribution_el),this.attribution_el.innerHTML=t,this.attribution_el.title=this.attribution_el.textContent.replace(/\s*\n\s*/g," ")}}_map_data(){this.initial_extent=this.get_extent();const t=this.model.tile_source.get_level_by_extent(this.initial_extent,this.map_frame.bbox.height,this.map_frame.bbox.width),e=this.model.tile_source.snap_to_zoom_level(this.initial_extent,this.map_frame.bbox.height,this.map_frame.bbox.width,t);this.x_range.start=e[0],this.y_range.start=e[1],this.x_range.end=e[2],this.y_range.end=e[3],this.x_range instanceof a.Range1d&&(this.x_range.reset_start=e[0],this.x_range.reset_end=e[2]),this.y_range instanceof a.Range1d&&(this.y_range.reset_start=e[1],this.y_range.reset_end=e[3]),this._update_attribution()}_create_tile(t,e,i,s,_=!1){const[n,a,r]=this.model.tile_source.normalize_xyz(t,e,i),o={img:void 0,tile_coords:[t,e,i],normalized_coords:[n,a,r],quadkey:this.model.tile_source.tile_xyz_to_quadkey(t,e,i),cache_key:this.model.tile_source.tile_xyz_to_key(t,e,i),bounds:s,loaded:!1,finished:!1,x_coord:s[0],y_coord:s[3]},l=this.model.tile_source.get_image_url(n,a,r);new h.ImageLoader(l,{loaded:t=>{Object.assign(o,{img:t,loaded:!0}),_?(o.finished=!0,this.notify_finished()):this.request_render()},failed(){o.finished=!0}}),this.model.tile_source.tiles.set(o.cache_key,o),this._tiles.push(o)}_enforce_aspect_ratio(){if(this._last_height!==this.map_frame.bbox.height||this._last_width!==this.map_frame.bbox.width){const t=this.get_extent(),e=this.model.tile_source.get_level_by_extent(t,this.map_frame.bbox.height,this.map_frame.bbox.width),i=this.model.tile_source.snap_to_zoom_level(t,this.map_frame.bbox.height,this.map_frame.bbox.width,e);this.x_range.setv({start:i[0],end:i[2]}),this.y_range.setv({start:i[1],end:i[3]}),this.extent=i,this._last_height=this.map_frame.bbox.height,this._last_width=this.map_frame.bbox.width}}has_finished(){if(!super.has_finished())return!1;if(0===this._tiles.length)return!1;for(const t of this._tiles)if(!t.finished)return!1;return!0}_render(){null==this.map_initialized&&(this._set_data(),this._map_data(),this.map_initialized=!0),this._enforce_aspect_ratio(),this._update(),null!=this.prefetch_timer&&clearTimeout(this.prefetch_timer),this.prefetch_timer=setTimeout(this._prefetch_tiles.bind(this),500),this.has_finished()&&this.notify_finished()}_draw_tile(t){const e=this.model.tile_source.tiles.get(t);if(null!=e&&e.loaded){const[[t],[i]]=this.coordinates.map_to_screen([e.bounds[0]],[e.bounds[3]]),[[s],[_]]=this.coordinates.map_to_screen([e.bounds[2]],[e.bounds[1]]),n=s-t,a=_-i,r=t,o=i,h=this.map_canvas.getImageSmoothingEnabled();this.map_canvas.setImageSmoothingEnabled(this.model.smoothing),this.map_canvas.drawImage(e.img,r,o,n,a),this.map_canvas.setImageSmoothingEnabled(h),e.finished=!0}}_set_rect(){const t=this.plot_model.properties.outline_line_width.value(),e=this.map_frame.bbox.left+t/2,i=this.map_frame.bbox.top+t/2,s=this.map_frame.bbox.width-t,_=this.map_frame.bbox.height-t;this.map_canvas.rect(e,i,s,_),this.map_canvas.clip()}_render_tiles(t){this.map_canvas.save(),this._set_rect(),this.map_canvas.globalAlpha=this.model.alpha;for(const e of t)this._draw_tile(e);this.map_canvas.restore()}_prefetch_tiles(){const{tile_source:t}=this.model,e=this.get_extent(),i=this.map_frame.bbox.height,s=this.map_frame.bbox.width,_=this.model.tile_source.get_level_by_extent(e,i,s),n=this.model.tile_source.get_tiles_by_extent(e,_);for(let e=0,i=Math.min(10,n.length);e<i;e++){const[i,s,_]=n[e],a=this.model.tile_source.children_by_tile_xyz(i,s,_);for(const e of a){const[i,s,_,n]=e;t.tiles.has(t.tile_xyz_to_key(i,s,_))||this._create_tile(i,s,_,n,!0)}}}_fetch_tiles(t){for(const e of t){const[t,i,s,_]=e;this._create_tile(t,i,s,_)}}_update(){const{tile_source:t}=this.model,{min_zoom:e}=t,{max_zoom:i}=t;let s=this.get_extent();const _=this.extent[2]-this.extent[0]<s[2]-s[0],n=this.map_frame.bbox.height,a=this.map_frame.bbox.width;let r=t.get_level_by_extent(s,n,a),o=!1;r<e?(s=this.extent,r=e,o=!0):r>i&&(s=this.extent,r=i,o=!0),o&&(this.x_range.setv({x_range:{start:s[0],end:s[2]}}),this.y_range.setv({start:s[1],end:s[3]})),this.extent=s;const h=t.get_tiles_by_extent(s,r),d=[],m=[],c=[],g=[];for(const e of h){const[i,s,n]=e,a=t.tile_xyz_to_key(i,s,n),r=t.tiles.get(a);if(null!=r&&r.loaded)m.push(a);else if(this.model.render_parents){const[e,a,r]=t.get_closest_parent_by_tile_xyz(i,s,n),o=t.tile_xyz_to_key(e,a,r),h=t.tiles.get(o);if(null!=h&&h.loaded&&!l.includes(c,o)&&c.push(o),_){const e=t.children_by_tile_xyz(i,s,n);for(const[i,s,_]of e){const e=t.tile_xyz_to_key(i,s,_);t.tiles.has(e)&&g.push(e)}}}null==r&&d.push(e)}this._render_tiles(c),this._render_tiles(g),this._render_tiles(m),null!=this.render_timer&&clearTimeout(this.render_timer),this.render_timer=setTimeout(()=>this._fetch_tiles(d),65)}}i.TileRendererView=u,u.__name__="TileRendererView";class b extends n.DataRenderer{constructor(t){super(t),this._selection_manager=new m.SelectionManager({source:new c.ColumnDataSource})}static init_TileRenderer(){this.prototype.default_view=u,this.define({alpha:[o.Number,1],smoothing:[o.Boolean,!0],tile_source:[o.Instance,()=>new _.WMTSTileSource],render_parents:[o.Boolean,!0]})}get_selection_manager(){return this._selection_manager}}i.TileRenderer=b,b.__name__="TileRenderer",b.init_TileRenderer()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const o=e(333);class s extends o.MercatorTileSource{constructor(e){super(e)}get_image_url(e,t,r){const o=this.string_lookup_replace(this.url,this.extra_url_vars),[s,c,_]=this.tms_to_wmts(e,t,r);return o.replace("{X}",s.toString()).replace("{Y}",c.toString()).replace("{Z}",_.toString())}}r.WMTSTileSource=s,s.__name__="WMTSTileSource"},
function _(t,e,i){Object.defineProperty(i,"__esModule",{value:!0}),i.bk_tile_attribution="bk-tile-attribution"},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});n.default="\n.bk-root .bk-tile-attribution a {\n  color: black;\n}\n"},
function _(e,r,t){Object.defineProperty(t,"__esModule",{value:!0});const o=e(333);class c extends o.MercatorTileSource{constructor(e){super(e)}get_image_url(e,r,t){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",e.toString()).replace("{Y}",r.toString()).replace("{Z}",t.toString())}}t.TMSTileSource=c,c.__name__="TMSTileSource"},
function _(e,r,a){Object.defineProperty(a,"__esModule",{value:!0});var t=e(343);a.CanvasTexture=t.CanvasTexture;var u=e(345);a.ImageURLTexture=u.ImageURLTexture;var v=e(344);a.Texture=v.Texture},
function _(t,e,n){Object.defineProperty(n,"__esModule",{value:!0});const r=t(1),c=t(344),s=r.__importStar(t(18)),i=t(29);class a extends c.Texture{constructor(t){super(t)}static init_CanvasTexture(){this.define({code:[s.String]})}get func(){const t=i.use_strict(this.code);return new Function("ctx","color","scale","weight",t)}get_pattern(t,e,n){return r=>{const c=document.createElement("canvas");c.width=e,c.height=e;const s=c.getContext("2d");return this.func.call(this,s,t,e,n),r.createPattern(c,this.repetition)}}}n.CanvasTexture=a,a.__name__="CanvasTexture",a.init_CanvasTexture()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const r=e(1),n=e(81),o=r.__importStar(e(18));class _ extends n.Model{constructor(e){super(e)}static init_Texture(){this.define({repetition:[o.TextureRepetition,"repeat"]})}onload(e){e()}}i.Texture=_,_.__name__="Texture",_.init_Texture()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const r=e(1),a=e(344),n=r.__importStar(e(18)),s=e(251);class o extends a.Texture{constructor(e){super(e)}static init_ImageURLTexture(){this.define({url:[n.String]})}initialize(){super.initialize(),this._loader=new s.ImageLoader(this.url)}get_pattern(e,t,i){return e=>this._loader.finished?e.createPattern(this._loader.image,this.repetition):null}onload(e){this._loader.promise.then(()=>e())}}i.ImageURLTexture=o,o.__name__="ImageURLTexture",o.init_ImageURLTexture()},
function _(o,l,T){Object.defineProperty(T,"__esModule",{value:!0});var a=o(307);T.ActionTool=a.ActionTool;var r=o(347);T.CustomAction=r.CustomAction;var e=o(308);T.HelpTool=e.HelpTool;var v=o(348);T.RedoTool=v.RedoTool;var t=o(349);T.ResetTool=t.ResetTool;var n=o(350);T.SaveTool=n.SaveTool;var s=o(351);T.UndoTool=s.UndoTool;var i=o(352);T.ZoomInTool=i.ZoomInTool;var P=o(355);T.ZoomOutTool=P.ZoomOutTool;var c=o(296);T.ButtonTool=c.ButtonTool;var d=o(356);T.EditTool=d.EditTool;var u=o(357);T.BoxEditTool=u.BoxEditTool;var y=o(358);T.FreehandDrawTool=y.FreehandDrawTool;var m=o(359);T.PointDrawTool=m.PointDrawTool;var x=o(360);T.PolyDrawTool=x.PolyDrawTool;var B=o(361);T.PolyTool=B.PolyTool;var S=o(362);T.PolyEditTool=S.PolyEditTool;var b=o(363);T.BoxSelectTool=b.BoxSelectTool;var h=o(366);T.BoxZoomTool=h.BoxZoomTool;var E=o(306);T.GestureTool=E.GestureTool;var Z=o(367);T.LassoSelectTool=Z.LassoSelectTool;var p=o(369);T.LineEditTool=p.LineEditTool;var w=o(371);T.PanTool=w.PanTool;var C=o(368);T.PolySelectTool=C.PolySelectTool;var D=o(372);T.RangeTool=D.RangeTool;var H=o(364);T.SelectTool=H.SelectTool;var R=o(373);T.TapTool=R.TapTool;var A=o(374);T.WheelPanTool=A.WheelPanTool;var I=o(375);T.WheelZoomTool=I.WheelZoomTool;var L=o(376);T.CrosshairTool=L.CrosshairTool;var W=o(377);T.CustomJSHover=W.CustomJSHover;var O=o(378);T.HoverTool=O.HoverTool;var _=o(295);T.InspectTool=_.InspectTool;var f=o(298);T.Tool=f.Tool;var g=o(379);T.ToolProxy=g.ToolProxy;var F=o(294);T.Toolbar=F.Toolbar;var G=o(305);T.ToolbarBase=G.ToolbarBase;var J=o(380);T.ProxyToolbar=J.ProxyToolbar;var U=o(380);T.ToolbarBox=U.ToolbarBox},
function _(t,o,i){Object.defineProperty(i,"__esModule",{value:!0});const n=t(1),s=t(307),e=n.__importStar(t(18)),c=t(299);class _ extends s.ActionToolButtonView{css_classes(){return super.css_classes().concat(c.bk_toolbar_button_custom_action)}}i.CustomActionButtonView=_,_.__name__="CustomActionButtonView";class l extends s.ActionToolView{doit(){null!=this.model.callback&&this.model.callback.execute(this.model)}}i.CustomActionView=l,l.__name__="CustomActionView";class u extends s.ActionTool{constructor(t){super(t),this.tool_name="Custom Action",this.button_view=_}static init_CustomAction(){this.prototype.default_view=l,this.define({action_tooltip:[e.String,"Perform a Custom Action"],callback:[e.Any],icon:[e.String]})}get tooltip(){return this.action_tooltip}}i.CustomAction=u,u.__name__="CustomAction",u.init_CustomAction()},
function _(o,e,t){Object.defineProperty(t,"__esModule",{value:!0});const i=o(307),s=o(309);class n extends i.ActionToolView{connect_signals(){super.connect_signals(),this.connect(this.plot_view.state_changed,()=>this.model.disabled=!this.plot_view.can_redo())}doit(){this.plot_view.redo()}}t.RedoToolView=n,n.__name__="RedoToolView";class _ extends i.ActionTool{constructor(o){super(o),this.tool_name="Redo",this.icon=s.bk_tool_icon_redo}static init_RedoTool(){this.prototype.default_view=n,this.override({disabled:!0}),this.register_alias("redo",()=>new _)}}t.RedoTool=_,_.__name__="RedoTool",_.init_RedoTool()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});const s=e(307),i=e(309);class _ extends s.ActionToolView{doit(){this.plot_view.reset()}}o.ResetToolView=_,_.__name__="ResetToolView";class l extends s.ActionTool{constructor(e){super(e),this.tool_name="Reset",this.icon=i.bk_tool_icon_reset}static init_ResetTool(){this.prototype.default_view=_,this.register_alias("reset",()=>new l)}}o.ResetTool=l,l.__name__="ResetTool",l.init_ResetTool()},
function _(e,o,t){Object.defineProperty(t,"__esModule",{value:!0});const a=e(307),i=e(309);class n extends a.ActionToolView{async copy(){const e=await this.plot_view.to_blob(),o=new ClipboardItem({[e.type]:e});await navigator.clipboard.write([o])}async save(e){const o=await this.plot_view.to_blob(),t=document.createElement("a");t.href=URL.createObjectURL(o),t.download=e,t.target="_blank",t.dispatchEvent(new MouseEvent("click"))}doit(e="save"){switch(e){case"save":this.save("bokeh_plot");break;case"copy":this.copy()}}}t.SaveToolView=n,n.__name__="SaveToolView";class s extends a.ActionTool{constructor(e){super(e),this.tool_name="Save",this.icon=i.bk_tool_icon_save}static init_SaveTool(){this.prototype.default_view=n,this.register_alias("save",()=>new s)}get menu(){return[{icon:"bk-tool-icon-copy-to-clipboard",tooltip:"Copy image to clipboard",if:()=>"undefined"!=typeof ClipboardItem,handler:()=>{this.do.emit("copy")}}]}}t.SaveTool=s,s.__name__="SaveTool",s.init_SaveTool()},
function _(o,t,e){Object.defineProperty(e,"__esModule",{value:!0});const n=o(307),i=o(309);class s extends n.ActionToolView{connect_signals(){super.connect_signals(),this.connect(this.plot_view.state_changed,()=>this.model.disabled=!this.plot_view.can_undo())}doit(){this.plot_view.undo()}}e.UndoToolView=s,s.__name__="UndoToolView";class _ extends n.ActionTool{constructor(o){super(o),this.tool_name="Undo",this.icon=i.bk_tool_icon_undo}static init_UndoTool(){this.prototype.default_view=s,this.override({disabled:!0}),this.register_alias("undo",()=>new _)}}e.UndoTool=_,_.__name__="UndoTool",_.init_UndoTool()},
function _(o,i,e){Object.defineProperty(e,"__esModule",{value:!0});const n=o(353),s=o(309);class t extends n.ZoomBaseTool{constructor(o){super(o),this.sign=1,this.tool_name="Zoom In",this.icon=s.bk_tool_icon_zoom_in}static init_ZoomInTool(){this.prototype.default_view=n.ZoomBaseToolView,this.register_alias("zoom_in",()=>new t({dimensions:"both"})),this.register_alias("xzoom_in",()=>new t({dimensions:"width"})),this.register_alias("yzoom_in",()=>new t({dimensions:"height"}))}}e.ZoomInTool=t,t.__name__="ZoomInTool",t.init_ZoomInTool()},
function _(o,t,e){Object.defineProperty(e,"__esModule",{value:!0});const i=o(1),s=o(307),n=o(354),_=i.__importStar(o(18));class l extends s.ActionToolView{doit(){const o=this.plot_view.frame,t=this.model.dimensions,e="width"==t||"both"==t,i="height"==t||"both"==t,s=n.scale_range(o,this.model.sign*this.model.factor,e,i);this.plot_view.push_state("zoom_out",{range:s}),this.plot_view.update_range(s,!1,!0),this.model.document&&this.model.document.interactive_start(this.plot_model)}}e.ZoomBaseToolView=l,l.__name__="ZoomBaseToolView";class a extends s.ActionTool{constructor(o){super(o)}static init_ZoomBaseTool(){this.prototype.default_view=l,this.define({factor:[_.Percent,.1],dimensions:[_.Dimensions,"both"]})}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimensions)}}e.ZoomBaseTool=a,a.__name__="ZoomBaseTool",a.init_ZoomBaseTool()},
function _(n,e,t){Object.defineProperty(t,"__esModule",{value:!0});const o=n(10);function r(n,e,t){const[o,r]=[n.start,n.end],s=null!=t?t:(r+o)/2;return[o-(o-s)*e,r-(r-s)*e]}function s(n,[e,t]){const o=new Map;for(const[r,s]of n){const[n,c]=s.r_invert(e,t);o.set(r,{start:n,end:c})}return o}t.scale_highlow=r,t.get_info=s,t.scale_range=function(n,e,t=!0,c=!0,l){e=o.clamp(e,-.9,.9);const a=t?e:0,[u,_]=r(n.bbox.h_range,a,null!=l?l.x:void 0),i=s(n.x_scales,[u,_]),f=c?e:0,[d,b]=r(n.bbox.v_range,f,null!=l?l.y:void 0);return{xrs:i,yrs:s(n.y_scales,[d,b]),factor:e}}},
function _(o,t,i){Object.defineProperty(i,"__esModule",{value:!0});const e=o(353),s=o(309);class n extends e.ZoomBaseTool{constructor(o){super(o),this.sign=-1,this.tool_name="Zoom Out",this.icon=s.bk_tool_icon_zoom_out}static init_ZoomOutTool(){this.prototype.default_view=e.ZoomBaseToolView,this.register_alias("zoom_out",()=>new n({dimensions:"both"})),this.register_alias("xzoom_out",()=>new n({dimensions:"width"})),this.register_alias("yzoom_out",()=>new n({dimensions:"height"}))}}i.ZoomOutTool=n,n.__name__="ZoomOutTool",n.init_ZoomOutTool()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});const s=e(1).__importStar(e(18)),i=e(9),n=e(8),r=e(11),_=e(306);class c extends _.GestureToolView{constructor(){super(...arguments),this._mouse_in_frame=!0}_select_mode(e){const{shiftKey:t,ctrlKey:o}=e;return t||o?t&&!o?"append":!t&&o?"intersect":t&&o?"subtract":void r.unreachable():"replace"}_move_enter(e){this._mouse_in_frame=!0}_move_exit(e){this._mouse_in_frame=!1}_map_drag(e,t,o){if(!this.plot_view.frame.bbox.contains(e,t))return null;const s=this.plot_view.renderer_views.get(o);return[s.coordinates.x_scale.invert(e),s.coordinates.y_scale.invert(t)]}_delete_selected(e){const t=e.data_source,o=t.selected.indices;o.sort();for(const e of t.columns()){const s=t.get_array(e);for(let e=0;e<o.length;e++){const t=o[e];s.splice(t-e,1)}}this._emit_cds_changes(t)}_pop_glyphs(e,t){const o=e.columns();if(t&&o.length)for(const s of o){let o=e.get_array(s);const i=o.length-t+1;i<1||(n.isArray(o)||(o=Array.from(o),e.data[s]=o),o.splice(0,i))}}_emit_cds_changes(e,t=!0,o=!0,s=!0){o&&e.selection_manager.clear(),t&&e.change.emit(),s&&(e.data=e.data,e.properties.data.change.emit())}_drag_points(e,t,o="both"){if(null==this._basepoint)return;const[s,i]=this._basepoint;for(const n of t){const t=this._map_drag(s,i,n),r=this._map_drag(e.sx,e.sy,n);if(null==r||null==t)continue;const[_,c]=r,[a,l]=t,[d,u]=[_-a,c-l],h=n.glyph,m=n.data_source,[p,f]=[h.x.field,h.y.field];for(const e of m.selected.indices)!p||"width"!=o&&"both"!=o||(m.data[p][e]+=d),!f||"height"!=o&&"both"!=o||(m.data[f][e]+=u);m.change.emit()}this._basepoint=[e.sx,e.sy]}_pad_empty_columns(e,t){for(const o of e.columns())i.includes(t,o)||e.get_array(o).push(this.model.empty_value)}_select_event(e,t,o){const s=this.plot_view.frame,{sx:i,sy:n}=e;if(!s.bbox.contains(i,n))return[];const r={type:"point",sx:i,sy:n},_=[];for(const e of o){const o=e.get_selection_manager(),s=e.data_source,i=[this.plot_view.renderer_views.get(e)];o.select(i,r,!0,t)&&_.push(e),s.properties.selected.change.emit()}return _}}o.EditToolView=c,c.__name__="EditToolView";class a extends _.GestureTool{constructor(e){super(e)}static init_EditTool(){this.define({custom_icon:[s.String],custom_tooltip:[s.String],empty_value:[s.Any],renderers:[s.Array,[]]})}get tooltip(){return this.custom_tooltip||this.tool_name}get computed_icon(){return this.custom_icon||this.icon}}o.EditTool=a,a.__name__="EditTool",a.init_EditTool()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),_=e(72),o=i.__importStar(e(18)),n=e(356),a=e(309);class d extends n.EditToolView{_tap(e){null==this._draw_basepoint&&null==this._basepoint&&this._select_event(e,this._select_mode(e),this.model.renderers)}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)if(e.keyCode===_.Keys.Backspace)this._delete_selected(t);else if(e.keyCode==_.Keys.Esc){t.data_source.selection_manager.clear()}}_set_extent([e,t],[s,i],_,o=!1){const n=this.model.renderers[0],a=this.plot_view.renderer_views.get(n),d=n.glyph,l=n.data_source,[r,h]=a.coordinates.x_scale.r_invert(e,t),[p,u]=a.coordinates.y_scale.r_invert(s,i),[c,m]=[(r+h)/2,(p+u)/2],[f,b]=[h-r,u-p],[x,y]=[d.x.field,d.y.field],[w,v]=[d.width.field,d.height.field];if(_)this._pop_glyphs(l,this.model.num_objects),x&&l.get_array(x).push(c),y&&l.get_array(y).push(m),w&&l.get_array(w).push(f),v&&l.get_array(v).push(b),this._pad_empty_columns(l,[x,y,w,v]);else{const e=l.data[x].length-1;x&&(l.data[x][e]=c),y&&(l.data[y][e]=m),w&&(l.data[w][e]=f),v&&(l.data[v][e]=b)}this._emit_cds_changes(l,!0,!1,o)}_update_box(e,t=!1,s=!1){if(null==this._draw_basepoint)return;const i=[e.sx,e.sy],_=this.plot_view.frame,o=this.model.dimensions,n=this.model._get_dim_limits(this._draw_basepoint,i,_,o);if(null!=n){const[e,i]=n;this._set_extent(e,i,t,s)}}_doubletap(e){this.model.active&&(null!=this._draw_basepoint?(this._update_box(e,!1,!0),this._draw_basepoint=null):(this._draw_basepoint=[e.sx,e.sy],this._select_event(e,"append",this.model.renderers),this._update_box(e,!0,!1)))}_move(e){this._update_box(e,!1,!1)}_pan_start(e){if(e.shiftKey){if(null!=this._draw_basepoint)return;this._draw_basepoint=[e.sx,e.sy],this._update_box(e,!0,!1)}else{if(null!=this._basepoint)return;this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy]}}_pan(e,t=!1,s=!1){if(e.shiftKey){if(null==this._draw_basepoint)return;this._update_box(e,t,s)}else{if(null==this._basepoint)return;this._drag_points(e,this.model.renderers)}}_pan_end(e){if(this._pan(e,!1,!0),e.shiftKey)this._draw_basepoint=null;else{this._basepoint=null;for(const e of this.model.renderers)this._emit_cds_changes(e.data_source,!1,!0,!0)}}}s.BoxEditToolView=d,d.__name__="BoxEditToolView";class l extends n.EditTool{constructor(e){super(e),this.tool_name="Box Edit Tool",this.icon=a.bk_tool_icon_box_edit,this.event_type=["tap","pan","move"],this.default_order=1}static init_BoxEditTool(){this.prototype.default_view=d,this.define({dimensions:[o.Dimensions,"both"],num_objects:[o.Int,0]})}}s.BoxEditTool=l,l.__name__="BoxEditTool",l.init_BoxEditTool()},
function _(e,t,a){Object.defineProperty(a,"__esModule",{value:!0});const s=e(1),r=e(72),_=s.__importStar(e(18)),o=e(8),i=e(356),d=e(309);class n extends i.EditToolView{_draw(e,t,a=!1){if(!this.model.active)return;const s=this.model.renderers[0],r=this._map_drag(e.sx,e.sy,s);if(null==r)return;const[_,i]=r,d=s.data_source,n=s.glyph,[l,h]=[n.xs.field,n.ys.field];if("new"==t)this._pop_glyphs(d,this.model.num_objects),l&&d.get_array(l).push([_]),h&&d.get_array(h).push([i]),this._pad_empty_columns(d,[l,h]);else if("add"==t){if(l){const e=d.data[l].length-1;let t=d.get_array(l)[e];o.isArray(t)||(t=Array.from(t),d.data[l][e]=t),t.push(_)}if(h){const e=d.data[h].length-1;let t=d.get_array(h)[e];o.isArray(t)||(t=Array.from(t),d.data[h][e]=t),t.push(i)}}this._emit_cds_changes(d,!0,!0,a)}_pan_start(e){this._draw(e,"new")}_pan(e){this._draw(e,"add")}_pan_end(e){this._draw(e,"add",!0)}_tap(e){this._select_event(e,this._select_mode(e),this.model.renderers)}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)e.keyCode===r.Keys.Esc?t.data_source.selection_manager.clear():e.keyCode===r.Keys.Backspace&&this._delete_selected(t)}}a.FreehandDrawToolView=n,n.__name__="FreehandDrawToolView";class l extends i.EditTool{constructor(e){super(e),this.tool_name="Freehand Draw Tool",this.icon=d.bk_tool_icon_freehand_draw,this.event_type=["pan","tap"],this.default_order=3}static init_FreehandDrawTool(){this.prototype.default_view=n,this.define({num_objects:[_.Int,0]})}}a.FreehandDrawTool=l,l.__name__="FreehandDrawTool",l.init_FreehandDrawTool()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});const s=e(1),i=e(72),a=s.__importStar(e(18)),n=e(356),_=e(309);class r extends n.EditToolView{_tap(e){if(this._select_event(e,this._select_mode(e),this.model.renderers).length||!this.model.add)return;const t=this.model.renderers[0],o=this._map_drag(e.sx,e.sy,t);if(null==o)return;const s=t.glyph,i=t.data_source,[a,n]=[s.x.field,s.y.field],[_,r]=o;this._pop_glyphs(i,this.model.num_objects),a&&i.get_array(a).push(_),n&&i.get_array(n).push(r),this._pad_empty_columns(i,[a,n]),i.change.emit(),i.data=i.data,i.properties.data.change.emit()}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)e.keyCode===i.Keys.Backspace?this._delete_selected(t):e.keyCode==i.Keys.Esc&&t.data_source.selection_manager.clear()}_pan_start(e){this.model.drag&&(this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy])}_pan(e){this.model.drag&&null!=this._basepoint&&this._drag_points(e,this.model.renderers)}_pan_end(e){if(this.model.drag){this._pan(e);for(const e of this.model.renderers)this._emit_cds_changes(e.data_source,!1,!0,!0);this._basepoint=null}}}o.PointDrawToolView=r,r.__name__="PointDrawToolView";class d extends n.EditTool{constructor(e){super(e),this.tool_name="Point Draw Tool",this.icon=_.bk_tool_icon_point_draw,this.event_type=["tap","pan","move"],this.default_order=2}static init_PointDrawTool(){this.prototype.default_view=r,this.define({add:[a.Boolean,!0],drag:[a.Boolean,!0],num_objects:[a.Int,0]})}}o.PointDrawTool=d,d.__name__="PointDrawTool",d.init_PointDrawTool()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),r=e(72),a=i.__importStar(e(18)),o=e(8),n=e(361),_=e(309);class d extends n.PolyToolView{constructor(){super(...arguments),this._drawing=!1,this._initialized=!1}_tap(e){this._drawing?this._draw(e,"add",!0):this._select_event(e,this._select_mode(e),this.model.renderers)}_draw(e,t,s=!1){const i=this.model.renderers[0],r=this._map_drag(e.sx,e.sy,i);if(this._initialized||this.activate(),null==r)return;const[a,n]=this._snap_to_vertex(e,...r),_=i.data_source,d=i.glyph,[l,h]=[d.xs.field,d.ys.field];if("new"==t)this._pop_glyphs(_,this.model.num_objects),l&&_.get_array(l).push([a,a]),h&&_.get_array(h).push([n,n]),this._pad_empty_columns(_,[l,h]);else if("edit"==t){if(l){const e=_.data[l][_.data[l].length-1];e[e.length-1]=a}if(h){const e=_.data[h][_.data[h].length-1];e[e.length-1]=n}}else if("add"==t){if(l){const e=_.data[l].length-1;let t=_.get_array(l)[e];const s=t[t.length-1];t[t.length-1]=a,o.isArray(t)||(t=Array.from(t),_.data[l][e]=t),t.push(s)}if(h){const e=_.data[h].length-1;let t=_.get_array(h)[e];const s=t[t.length-1];t[t.length-1]=n,o.isArray(t)||(t=Array.from(t),_.data[h][e]=t),t.push(s)}}this._emit_cds_changes(_,!0,!1,s)}_show_vertices(){if(!this.model.active)return;const e=[],t=[];for(let s=0;s<this.model.renderers.length;s++){const i=this.model.renderers[s],r=i.data_source,a=i.glyph,[o,n]=[a.xs.field,a.ys.field];if(o)for(const t of r.get_array(o))Array.prototype.push.apply(e,t);if(n)for(const e of r.get_array(n))Array.prototype.push.apply(t,e);this._drawing&&s==this.model.renderers.length-1&&(e.splice(e.length-1,1),t.splice(t.length-1,1))}this._set_vertices(e,t)}_doubletap(e){this.model.active&&(this._drawing?(this._drawing=!1,this._draw(e,"edit",!0)):(this._drawing=!0,this._draw(e,"new",!0)))}_move(e){this._drawing&&this._draw(e,"edit")}_remove(){const e=this.model.renderers[0],t=e.data_source,s=e.glyph,[i,r]=[s.xs.field,s.ys.field];if(i){const e=t.data[i].length-1,s=t.get_array(i)[e];s.splice(s.length-1,1)}if(r){const e=t.data[r].length-1,s=t.get_array(r)[e];s.splice(s.length-1,1)}this._emit_cds_changes(t)}_keyup(e){if(this.model.active&&this._mouse_in_frame)for(const t of this.model.renderers)e.keyCode===r.Keys.Backspace?this._delete_selected(t):e.keyCode==r.Keys.Esc&&(this._drawing&&(this._remove(),this._drawing=!1),t.data_source.selection_manager.clear())}_pan_start(e){this.model.drag&&(this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy])}_pan(e){if(null==this._basepoint||!this.model.drag)return;const[t,s]=this._basepoint;for(const i of this.model.renderers){const r=this._map_drag(t,s,i),a=this._map_drag(e.sx,e.sy,i);if(null==a||null==r)continue;const o=i.data_source,n=i.glyph,[_,d]=[n.xs.field,n.ys.field];if(!_&&!d)continue;const[l,h]=a,[c,g]=r,[p,f]=[l-c,h-g];for(const e of o.selected.indices){let t,s,i;_&&(s=o.data[_][e]),d?(i=o.data[d][e],t=i.length):t=s.length;for(let e=0;e<t;e++)s&&(s[e]+=p),i&&(i[e]+=f)}o.change.emit()}this._basepoint=[e.sx,e.sy]}_pan_end(e){if(this.model.drag){this._pan(e);for(const e of this.model.renderers)this._emit_cds_changes(e.data_source);this._basepoint=null}}activate(){if(this.model.vertex_renderer&&this.model.active){if(this._show_vertices(),!this._initialized)for(const e of this.model.renderers){const t=e.data_source;t.connect(t.properties.data.change,()=>this._show_vertices())}this._initialized=!0}}deactivate(){this._drawing&&(this._remove(),this._drawing=!1),this.model.vertex_renderer&&this._hide_vertices()}}s.PolyDrawToolView=d,d.__name__="PolyDrawToolView";class l extends n.PolyTool{constructor(e){super(e),this.tool_name="Polygon Draw Tool",this.icon=_.bk_tool_icon_poly_draw,this.event_type=["pan","tap","move"],this.default_order=3}static init_PolyDrawTool(){this.prototype.default_view=d,this.define({drag:[a.Boolean,!0],num_objects:[a.Int,0]})}}s.PolyDrawTool=l,l.__name__="PolyDrawTool",l.init_PolyDrawTool()},
function _(e,t,r){Object.defineProperty(r,"__esModule",{value:!0});const o=e(1).__importStar(e(18)),i=e(8),s=e(356);class _ extends s.EditToolView{_set_vertices(e,t){const r=this.model.vertex_renderer.glyph,o=this.model.vertex_renderer.data_source,[s,_]=[r.x.field,r.y.field];s&&(i.isArray(e)?o.data[s]=e:r.x={value:e}),_&&(i.isArray(t)?o.data[_]=t:r.y={value:t}),this._emit_cds_changes(o,!0,!0,!1)}_hide_vertices(){this._set_vertices([],[])}_snap_to_vertex(e,t,r){if(this.model.vertex_renderer){const o=this._select_event(e,"replace",[this.model.vertex_renderer]),i=this.model.vertex_renderer.data_source,s=this.model.vertex_renderer.glyph,[_,l]=[s.x.field,s.y.field];if(o.length){const e=i.selected.indices[0];_&&(t=i.data[_][e]),l&&(r=i.data[l][e]),i.selection_manager.clear()}}return[t,r]}}r.PolyToolView=_,_.__name__="PolyToolView";class l extends s.EditTool{constructor(e){super(e)}static init_PolyTool(){this.prototype.default_view=_,this.define({vertex_renderer:[o.Instance]})}}r.PolyTool=l,l.__name__="PolyTool",l.init_PolyTool()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const r=e(72),i=e(8),_=e(361),d=e(309);class n extends _.PolyToolView{constructor(){super(...arguments),this._drawing=!1}_doubletap(e){if(!this.model.active)return;const t=this._map_drag(e.sx,e.sy,this.model.vertex_renderer);if(null==t)return;const[s,r]=t,i=this._select_event(e,"replace",[this.model.vertex_renderer]),_=this.model.vertex_renderer.data_source,d=this.model.vertex_renderer.glyph,[n,l]=[d.x.field,d.y.field];if(i.length&&null!=this._selected_renderer){const e=_.selected.indices[0];this._drawing?(this._drawing=!1,_.selection_manager.clear()):(_.selected.indices=[e+1],n&&_.get_array(n).splice(e+1,0,s),l&&_.get_array(l).splice(e+1,0,r),this._drawing=!0),_.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}else this._show_vertices(e)}_show_vertices(e){if(!this.model.active)return;const t=this._select_event(e,"replace",this.model.renderers);if(!t.length)return this._set_vertices([],[]),this._selected_renderer=null,void(this._drawing=!1);const s=t[0],r=s.glyph,_=s.data_source,d=_.selected.indices[0],[n,l]=[r.xs.field,r.ys.field];let a,c;n?(a=_.data[n][d],i.isArray(a)||(_.data[n][d]=a=Array.from(a))):a=r.xs.value,l?(c=_.data[l][d],i.isArray(c)||(_.data[l][d]=c=Array.from(c))):c=r.ys.value,this._selected_renderer=s,this._set_vertices(a,c)}_move(e){if(this._drawing&&null!=this._selected_renderer){const t=this.model.vertex_renderer,s=t.data_source,r=t.glyph,i=this._map_drag(e.sx,e.sy,t);if(null==i)return;let[_,d]=i;const n=s.selected.indices;[_,d]=this._snap_to_vertex(e,_,d),s.selected.indices=n;const[l,a]=[r.x.field,r.y.field],c=n[0];l&&(s.data[l][c]=_),a&&(s.data[a][c]=d),s.change.emit(),this._selected_renderer.data_source.change.emit()}}_tap(e){const t=this.model.vertex_renderer,s=this._map_drag(e.sx,e.sy,t);if(null==s)return;if(this._drawing&&this._selected_renderer){let[r,i]=s;const _=t.data_source,d=t.glyph,[n,l]=[d.x.field,d.y.field],a=_.selected.indices;[r,i]=this._snap_to_vertex(e,r,i);const c=a[0];if(_.selected.indices=[c+1],n){const e=_.get_array(n),t=e[c];e[c]=r,e.splice(c+1,0,t)}if(l){const e=_.get_array(l),t=e[c];e[c]=i,e.splice(c+1,0,t)}return _.change.emit(),void this._emit_cds_changes(this._selected_renderer.data_source,!0,!1,!0)}const r=this._select_mode(e);this._select_event(e,r,[t]),this._select_event(e,r,this.model.renderers)}_remove_vertex(){if(!this._drawing||!this._selected_renderer)return;const e=this.model.vertex_renderer,t=e.data_source,s=e.glyph,r=t.selected.indices[0],[i,_]=[s.x.field,s.y.field];i&&t.get_array(i).splice(r,1),_&&t.get_array(_).splice(r,1),t.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}_pan_start(e){this._select_event(e,"append",[this.model.vertex_renderer]),this._basepoint=[e.sx,e.sy]}_pan(e){null!=this._basepoint&&(this._drag_points(e,[this.model.vertex_renderer]),this._selected_renderer&&this._selected_renderer.data_source.change.emit())}_pan_end(e){null!=this._basepoint&&(this._drag_points(e,[this.model.vertex_renderer]),this._emit_cds_changes(this.model.vertex_renderer.data_source,!1,!0,!0),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)}_keyup(e){if(!this.model.active||!this._mouse_in_frame)return;let t;t=this._selected_renderer?[this.model.vertex_renderer]:this.model.renderers;for(const s of t)e.keyCode===r.Keys.Backspace?(this._delete_selected(s),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source)):e.keyCode==r.Keys.Esc&&(this._drawing?(this._remove_vertex(),this._drawing=!1):this._selected_renderer&&this._hide_vertices(),s.data_source.selection_manager.clear())}deactivate(){this._selected_renderer&&(this._drawing&&(this._remove_vertex(),this._drawing=!1),this._hide_vertices())}}s.PolyEditToolView=n,n.__name__="PolyEditToolView";class l extends _.PolyTool{constructor(e){super(e),this.tool_name="Poly Edit Tool",this.icon=d.bk_tool_icon_poly_edit,this.event_type=["tap","pan","move"],this.default_order=4}static init_PolyEditTool(){this.prototype.default_view=n}}s.PolyEditTool=l,l.__name__="PolyEditTool",l.init_PolyEditTool()},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});const s=e(1),i=e(364),l=e(124),_=s.__importStar(e(18)),n=e(309);class c extends i.SelectToolView{_compute_limits(e){const t=this.plot_view.frame,o=this.model.dimensions;let s=this._base_point;if("center"==this.model.origin){const[t,o]=s,[i,l]=e;s=[t-(i-t),o-(l-o)]}return this.model._get_dim_limits(s,e,t,o)}_pan_start(e){const{sx:t,sy:o}=e;this._base_point=[t,o]}_pan(e){const{sx:t,sy:o}=e,s=[t,o],[i,l]=this._compute_limits(s);this.model.overlay.update({left:i[0],right:i[1],top:l[0],bottom:l[1]}),this.model.select_every_mousemove&&this._do_select(i,l,!1,this._select_mode(e))}_pan_end(e){const{sx:t,sy:o}=e,s=[t,o],[i,l]=this._compute_limits(s);this._do_select(i,l,!0,this._select_mode(e)),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null,this.plot_view.push_state("box_select",{selection:this.plot_view.get_selection()})}_do_select([e,t],[o,s],i,l="replace"){const _={type:"rect",sx0:e,sx1:t,sy0:o,sy1:s};this._select(_,i,l)}}o.BoxSelectToolView=c,c.__name__="BoxSelectToolView";const r=()=>new l.BoxAnnotation({level:"overlay",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]});class h extends i.SelectTool{constructor(e){super(e),this.tool_name="Box Select",this.icon=n.bk_tool_icon_box_select,this.event_type="pan",this.default_order=30}static init_BoxSelectTool(){this.prototype.default_view=c,this.define({dimensions:[_.Dimensions,"both"],select_every_mousemove:[_.Boolean,!1],overlay:[_.Instance,r],origin:[_.BoxOrigin,"corner"]}),this.register_alias("box_select",()=>new h),this.register_alias("xbox_select",()=>new h({dimensions:"width"})),this.register_alias("ybox_select",()=>new h({dimensions:"height"}))}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimensions)}}o.BoxSelectTool=h,h.__name__="BoxSelectTool",h.init_BoxSelectTool()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const n=e(1),o=e(306),r=e(90),c=e(116),i=e(365),l=n.__importStar(e(18)),a=e(72),_=e(313),d=e(15),h=e(11);class p extends o.GestureToolView{connect_signals(){super.connect_signals(),this.model.clear.connect(()=>this._clear())}get computed_renderers(){const e=this.model.renderers,t=this.plot_model.renderers,s=this.model.names;return i.compute_renderers(e,t,s)}_computed_renderers_by_data_source(){var e;const t=new Map;for(const s of this.computed_renderers){let n;if(s instanceof r.GlyphRenderer)n=s.data_source;else{if(!(s instanceof c.GraphRenderer))continue;n=s.node_renderer.data_source}const o=null!==(e=t.get(n))&&void 0!==e?e:[];t.set(n,[...o,s])}return t}_select_mode(e){const{shiftKey:t,ctrlKey:s}=e;return t||s?t&&!s?"append":!t&&s?"intersect":t&&s?"subtract":void h.unreachable():this.model.mode}_keyup(e){e.keyCode==a.Keys.Esc&&this._clear()}_clear(){for(const e of this.computed_renderers)e.get_selection_manager().clear();this.plot_view.request_render()}_select(e,t,s){const n=this._computed_renderers_by_data_source();for(const[,o]of n){const n=o[0].get_selection_manager(),r=[];for(const e of o){const t=this.plot_view.renderer_views.get(e);null!=t&&r.push(t)}n.select(r,e,t,s)}null!=this.model.callback&&this._emit_callback(e),this._emit_selection_event(e,t)}_emit_selection_event(e,t=!0){const{x_scale:s,y_scale:n}=this.plot_view.frame;let o;switch(e.type){case"point":{const{sx:t,sy:r}=e,c=s.invert(t),i=n.invert(r);o=Object.assign(Object.assign({},e),{x:c,y:i});break}case"span":{const{sx:t,sy:r}=e,c=s.invert(t),i=n.invert(r);o=Object.assign(Object.assign({},e),{x:c,y:i});break}case"rect":{const{sx0:t,sx1:r,sy0:c,sy1:i}=e,[l,a]=s.r_invert(t,r),[_,d]=n.r_invert(c,i);o=Object.assign(Object.assign({},e),{x0:l,y0:_,x1:a,y1:d});break}case"poly":{const{sx:t,sy:r}=e,c=s.v_invert(t),i=n.v_invert(r);o=Object.assign(Object.assign({},e),{x:c,y:i});break}}this.plot_model.trigger_event(new _.SelectionGeometry(o,t))}}s.SelectToolView=p,p.__name__="SelectToolView";class u extends o.GestureTool{constructor(e){super(e)}initialize(){super.initialize(),this.clear=new d.Signal0(this,"clear")}static init_SelectTool(){this.define({renderers:[l.Any,"auto"],names:[l.Array,[]],mode:[l.Any,"replace"]})}get menu(){return[{icon:"bk-tool-icon-replace-mode",tooltip:"Replace the current selection",active:()=>"replace"==this.mode,handler:()=>{this.mode="replace",this.active=!0}},{icon:"bk-tool-icon-append-mode",tooltip:"Append to the current selection (Shift)",active:()=>"append"==this.mode,handler:()=>{this.mode="append",this.active=!0}},{icon:"bk-tool-icon-intersect-mode",tooltip:"Intersect with the current selection (Ctrl)",active:()=>"intersect"==this.mode,handler:()=>{this.mode="intersect",this.active=!0}},{icon:"bk-tool-icon-subtract-mode",tooltip:"Subtract from the current selection (Shift+Ctrl)",active:()=>"subtract"==this.mode,handler:()=>{this.mode="subtract",this.active=!0}},null,{icon:"bk-tool-icon-clear-selection",tooltip:"Clear the current selection (Esc)",handler:()=>{this.clear.emit()}}]}}s.SelectTool=u,u.__name__="SelectTool",u.init_SelectTool()},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});const r=e(9);t.compute_renderers=function(e,n,t){if(null==e)return[];let u="auto"==e?n:e;return t.length>0&&(u=u.filter(e=>r.includes(t,e.name))),u}},
function _(t,o,e){Object.defineProperty(e,"__esModule",{value:!0});const s=t(1),i=t(306),n=t(124),_=s.__importStar(t(18)),a=t(309);class l extends i.GestureToolView{_match_aspect(t,o,e){const s=e.bbox.aspect,i=e.bbox.h_range.end,n=e.bbox.h_range.start,_=e.bbox.v_range.end,a=e.bbox.v_range.start;let l=Math.abs(t[0]-o[0]),r=Math.abs(t[1]-o[1]);const h=0==r?0:l/r,[c]=h>=s?[1,h/s]:[s/h,1];let m,p,d,b;return t[0]<=o[0]?(m=t[0],p=t[0]+l*c,p>i&&(p=i)):(p=t[0],m=t[0]-l*c,m<n&&(m=n)),l=Math.abs(p-m),t[1]<=o[1]?(b=t[1],d=t[1]+l/s,d>_&&(d=_)):(d=t[1],b=t[1]-l/s,b<a&&(b=a)),r=Math.abs(d-b),t[0]<=o[0]?p=t[0]+s*r:m=t[0]-s*r,[[m,p],[b,d]]}_compute_limits(t){const o=this.plot_view.frame,e=this.model.dimensions;let s,i,n=this._base_point;if("center"==this.model.origin){const[o,e]=n,[s,i]=t;n=[o-(s-o),e-(i-e)]}return this.model.match_aspect&&"both"==e?[s,i]=this._match_aspect(n,t,o):[s,i]=this.model._get_dim_limits(n,t,o,e),[s,i]}_pan_start(t){this._base_point=[t.sx,t.sy]}_pan(t){const o=[t.sx,t.sy],[e,s]=this._compute_limits(o);this.model.overlay.update({left:e[0],right:e[1],top:s[0],bottom:s[1]})}_pan_end(t){const o=[t.sx,t.sy],[e,s]=this._compute_limits(o);this._update(e,s),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null}_update([t,o],[e,s]){if(Math.abs(o-t)<=5||Math.abs(s-e)<=5)return;const{x_scales:i,y_scales:n}=this.plot_view.frame,_=new Map;for(const[e,s]of i){const[i,n]=s.r_invert(t,o);_.set(e,{start:i,end:n})}const a=new Map;for(const[t,o]of n){const[i,n]=o.r_invert(e,s);a.set(t,{start:i,end:n})}const l={xrs:_,yrs:a};this.plot_view.push_state("box_zoom",{range:l}),this.plot_view.update_range(l)}}e.BoxZoomToolView=l,l.__name__="BoxZoomToolView";const r=()=>new n.BoxAnnotation({level:"overlay",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]});class h extends i.GestureTool{constructor(t){super(t),this.tool_name="Box Zoom",this.icon=a.bk_tool_icon_box_zoom,this.event_type="pan",this.default_order=20}static init_BoxZoomTool(){this.prototype.default_view=l,this.define({dimensions:[_.Dimensions,"both"],overlay:[_.Instance,r],match_aspect:[_.Boolean,!1],origin:[_.BoxOrigin,"corner"]}),this.register_alias("box_zoom",()=>new h({dimensions:"both"})),this.register_alias("xbox_zoom",()=>new h({dimensions:"width"})),this.register_alias("ybox_zoom",()=>new h({dimensions:"height"}))}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimensions)}}e.BoxZoomTool=h,h.__name__="BoxZoomTool",h.init_BoxZoomTool()},
function _(e,s,t){Object.defineProperty(t,"__esModule",{value:!0});const o=e(1),a=e(364),i=e(368),l=e(72),_=o.__importStar(e(18)),c=e(309);class n extends a.SelectToolView{initialize(){super.initialize(),this.data=null}connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,()=>this._active_change())}_active_change(){this.model.active||this._clear_overlay()}_keyup(e){e.keyCode==l.Keys.Enter&&this._clear_overlay()}_pan_start(e){const{sx:s,sy:t}=e;this.data={sx:[s],sy:[t]}}_pan(e){const{sx:s,sy:t}=e,[o,a]=this.plot_view.frame.bbox.clip(s,t);this.data.sx.push(o),this.data.sy.push(a);this.model.overlay.update({xs:this.data.sx,ys:this.data.sy}),this.model.select_every_mousemove&&this._do_select(this.data.sx,this.data.sy,!1,this._select_mode(e))}_pan_end(e){this._clear_overlay(),this._do_select(this.data.sx,this.data.sy,!0,this._select_mode(e)),this.plot_view.push_state("lasso_select",{selection:this.plot_view.get_selection()})}_clear_overlay(){this.model.overlay.update({xs:[],ys:[]})}_do_select(e,s,t,o){const a={type:"poly",sx:e,sy:s};this._select(a,t,o)}}t.LassoSelectToolView=n,n.__name__="LassoSelectToolView";class h extends a.SelectTool{constructor(e){super(e),this.tool_name="Lasso Select",this.icon=c.bk_tool_icon_lasso_select,this.event_type="pan",this.default_order=12}static init_LassoSelectTool(){this.prototype.default_view=n,this.define({select_every_mousemove:[_.Boolean,!0],overlay:[_.Instance,i.DEFAULT_POLY_OVERLAY]}),this.register_alias("lasso_select",()=>new h)}}t.LassoSelectTool=h,h.__name__="LassoSelectTool",h.init_LassoSelectTool()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const l=e(1),i=e(364),o=e(166),a=e(72),_=l.__importStar(e(18)),c=e(9),n=e(309);class h extends i.SelectToolView{initialize(){super.initialize(),this.data={sx:[],sy:[]}}connect_signals(){super.connect_signals(),this.connect(this.model.properties.active.change,()=>this._active_change())}_active_change(){this.model.active||this._clear_data()}_keyup(e){e.keyCode==a.Keys.Enter&&this._clear_data()}_doubletap(e){this._do_select(this.data.sx,this.data.sy,!0,this._select_mode(e)),this.plot_view.push_state("poly_select",{selection:this.plot_view.get_selection()}),this._clear_data()}_clear_data(){this.data={sx:[],sy:[]},this.model.overlay.update({xs:[],ys:[]})}_tap(e){const{sx:t,sy:s}=e;this.plot_view.frame.bbox.contains(t,s)&&(this.data.sx.push(t),this.data.sy.push(s),this.model.overlay.update({xs:c.copy(this.data.sx),ys:c.copy(this.data.sy)}))}_do_select(e,t,s,l){const i={type:"poly",sx:e,sy:t};this._select(i,s,l)}}s.PolySelectToolView=h,h.__name__="PolySelectToolView",s.DEFAULT_POLY_OVERLAY=()=>new o.PolyAnnotation({level:"overlay",xs_units:"screen",ys_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]});class y extends i.SelectTool{constructor(e){super(e),this.tool_name="Poly Select",this.icon=n.bk_tool_icon_polygon_select,this.event_type="tap",this.default_order=11}static init_PolySelectTool(){this.prototype.default_view=h,this.define({overlay:[_.Instance,s.DEFAULT_POLY_OVERLAY]}),this.register_alias("poly_select",()=>new y)}}s.PolySelectTool=y,y.__name__="PolySelectTool",y.init_PolySelectTool()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(1),n=e(370),r=s.__importStar(e(18)),_=e(309);class d extends n.LineToolView{constructor(){super(...arguments),this._drawing=!1}_doubletap(e){if(!this.model.active)return;const t=this.model.renderers;for(const i of t){1==this._select_event(e,"replace",[i]).length&&(this._selected_renderer=i)}this._show_intersections(),this._update_line_cds()}_show_intersections(){if(!this.model.active)return;if(null==this._selected_renderer)return;if(!this.model.renderers.length)return this._set_intersection([],[]),this._selected_renderer=null,void(this._drawing=!1);const e=this._selected_renderer.data_source,t=this._selected_renderer.glyph,[i,s]=[t.x.field,t.y.field],n=e.get_array(i),r=e.get_array(s);this._set_intersection(n,r)}_tap(e){const t=this.model.intersection_renderer;if(null==this._map_drag(e.sx,e.sy,t))return;if(this._drawing&&this._selected_renderer){const i=this._select_mode(e);if(0==this._select_event(e,i,[t]).length)return}const i=this._select_mode(e);this._select_event(e,i,[t]),this._select_event(e,i,this.model.renderers)}_update_line_cds(){if(null==this._selected_renderer)return;const e=this.model.intersection_renderer.glyph,t=this.model.intersection_renderer.data_source,[i,s]=[e.x.field,e.y.field];if(i&&s){const e=t.data[i],n=t.data[s];this._selected_renderer.data_source.data[i]=e,this._selected_renderer.data_source.data[s]=n}this._emit_cds_changes(this._selected_renderer.data_source,!0,!0,!1)}_pan_start(e){this._select_event(e,"append",[this.model.intersection_renderer]),this._basepoint=[e.sx,e.sy]}_pan(e){null!=this._basepoint&&(this._drag_points(e,[this.model.intersection_renderer],this.model.dimensions),this._selected_renderer&&this._selected_renderer.data_source.change.emit())}_pan_end(e){null!=this._basepoint&&(this._drag_points(e,[this.model.intersection_renderer]),this._emit_cds_changes(this.model.intersection_renderer.data_source,!1,!0,!0),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)}activate(){this._drawing=!0}deactivate(){this._selected_renderer&&(this._drawing&&(this._drawing=!1),this._hide_intersections())}}i.LineEditToolView=d,d.__name__="LineEditToolView";class o extends n.LineTool{constructor(e){super(e),this.tool_name="Line Edit Tool",this.icon=_.bk_tool_icon_line_edit,this.event_type=["tap","pan","move"],this.default_order=4}static init_LineEditTool(){this.prototype.default_view=d,this.define({dimensions:[r.Dimensions,"both"]})}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimensions)}}i.LineEditTool=o,o.__name__="LineEditTool",o.init_LineEditTool()},
function _(e,i,t){Object.defineProperty(t,"__esModule",{value:!0});const n=e(1).__importStar(e(18)),o=e(8),s=e(356);class _ extends s.EditToolView{_set_intersection(e,i){const t=this.model.intersection_renderer.glyph,n=this.model.intersection_renderer.data_source,[s,_]=[t.x.field,t.y.field];s&&(o.isArray(e)?n.data[s]=e:t.x={value:e}),_&&(o.isArray(i)?n.data[_]=i:t.y={value:i}),this._emit_cds_changes(n,!0,!0,!1)}_hide_intersections(){this._set_intersection([],[])}}t.LineToolView=_,_.__name__="LineToolView";class r extends s.EditTool{constructor(e){super(e)}static init_LineTool(){this.prototype.default_view=_,this.define({intersection_renderer:[n.Instance]})}}t.LineTool=r,r.__name__="LineTool",r.init_LineTool()},
function _(t,s,e){Object.defineProperty(e,"__esModule",{value:!0});const n=t(1),i=t(306),o=n.__importStar(t(18)),a=t(309);function _(t,s,e){const n=new Map;for(const[i,o]of t){const[t,a]=o.r_invert(s,e);n.set(i,{start:t,end:a})}return n}e.update_ranges=_;class h extends i.GestureToolView{_pan_start(t){this.last_dx=0,this.last_dy=0;const{sx:s,sy:e}=t,n=this.plot_view.frame.bbox;if(!n.contains(s,e)){const t=n.h_range,i=n.v_range;(s<t.start||s>t.end)&&(this.v_axis_only=!0),(e<i.start||e>i.end)&&(this.h_axis_only=!0)}null!=this.model.document&&this.model.document.interactive_start(this.plot_model)}_pan(t){this._update(t.deltaX,t.deltaY),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)}_pan_end(t){this.h_axis_only=!1,this.v_axis_only=!1,null!=this.pan_info&&this.plot_view.push_state("pan",{range:this.pan_info})}_update(t,s){const e=this.plot_view.frame,n=t-this.last_dx,i=s-this.last_dy,o=e.bbox.h_range,a=o.start-n,h=o.end-n,l=e.bbox.v_range,r=l.start-i,d=l.end-i,p=this.model.dimensions;let c,u,m,x,y,g;"width"!=p&&"both"!=p||this.v_axis_only?(c=o.start,u=o.end,m=0):(c=a,u=h,m=-n),"height"!=p&&"both"!=p||this.h_axis_only?(x=l.start,y=l.end,g=0):(x=r,y=d,g=-i),this.last_dx=t,this.last_dy=s;const{x_scales:w,y_scales:b}=e,f=_(w,c,u),v=_(b,x,y);this.pan_info={xrs:f,yrs:v,sdx:m,sdy:g},this.plot_view.update_range(this.pan_info,!0)}}e.PanToolView=h,h.__name__="PanToolView";class l extends i.GestureTool{constructor(t){super(t),this.tool_name="Pan",this.event_type="pan",this.default_order=10}static init_PanTool(){this.prototype.default_view=h,this.define({dimensions:[o.Dimensions,"both"]}),this.register_alias("pan",()=>new l({dimensions:"both"})),this.register_alias("xpan",()=>new l({dimensions:"width"})),this.register_alias("ypan",()=>new l({dimensions:"height"}))}get tooltip(){return this._get_dim_tooltip("Pan",this.dimensions)}get icon(){switch(this.dimensions){case"both":return a.bk_tool_icon_pan;case"width":return a.bk_tool_icon_xpan;case"height":return a.bk_tool_icon_ypan}}}e.PanTool=l,l.__name__="PanTool",l.init_PanTool()},
function _(e,t,i){Object.defineProperty(i,"__esModule",{value:!0});const s=e(1),n=e(124),l=e(19),a=s.__importStar(e(18)),r=e(306),o=e(309);function _(e){switch(e){case 1:return 2;case 2:return 1;case 4:return 5;case 5:return 4;default:return e}}function h(e,t,i,s){if(null==t)return!1;const n=i.compute(t);return Math.abs(e-n)<s}function d(e,t,i,s,n){let l=!0;if(null!=n.left&&null!=n.right){const t=i.invert(e);(t<n.left||t>n.right)&&(l=!1)}if(null!=n.bottom&&null!=n.top){const e=s.invert(t);(e<n.bottom||e>n.top)&&(l=!1)}return l}function u(e,t,i){let s=0;return e>=i.start&&e<=i.end&&(s+=1),t>=i.start&&t<=i.end&&(s+=1),s}function c(e,t,i,s){const n=t.compute(e),l=t.invert(n+i);return l>=s.start&&l<=s.end?l:e}function g(e,t,i){return e>t.start?(t.end=e,i):(t.end=t.start,t.start=e,_(i))}function y(e,t,i){return e<t.end?(t.start=e,i):(t.start=t.end,t.end=e,_(i))}function f(e,t,i,s){const[n,l]=t.r_compute(e.start,e.end),[a,r]=t.r_invert(n+i,l+i),o=u(e.start,e.end,s);u(a,r,s)>=o&&(e.start=a,e.end=r)}i.flip_side=_,i.is_near=h,i.is_inside=d,i.sides_inside=u,i.compute_value=c,i.update_range_end_side=g,i.update_range_start_side=y,i.update_range=f;class p extends r.GestureToolView{initialize(){super.initialize(),this.side=0,this.model.update_overlay_from_ranges()}connect_signals(){super.connect_signals(),null!=this.model.x_range&&this.connect(this.model.x_range.change,()=>this.model.update_overlay_from_ranges()),null!=this.model.y_range&&this.connect(this.model.y_range.change,()=>this.model.update_overlay_from_ranges())}_pan_start(e){this.last_dx=0,this.last_dy=0;const t=this.model.x_range,i=this.model.y_range,{frame:s}=this.plot_view,l=s.x_scale,a=s.y_scale,r=this.model.overlay,{left:o,right:_,top:u,bottom:c}=r,g=this.model.overlay.properties.line_width.value()+n.EDGE_TOLERANCE;null!=t&&this.model.x_interaction&&(h(e.sx,o,l,g)?this.side=1:h(e.sx,_,l,g)?this.side=2:d(e.sx,e.sy,l,a,r)&&(this.side=3)),null!=i&&this.model.y_interaction&&(0==this.side&&h(e.sy,c,a,g)&&(this.side=4),0==this.side&&h(e.sy,u,a,g)?this.side=5:d(e.sx,e.sy,l,a,this.model.overlay)&&(3==this.side?this.side=7:this.side=6))}_pan(e){const t=this.plot_view.frame,i=e.deltaX-this.last_dx,s=e.deltaY-this.last_dy,n=this.model.x_range,l=this.model.y_range,a=t.x_scale,r=t.y_scale;if(null!=n)if(3==this.side||7==this.side)f(n,a,i,t.x_range);else if(1==this.side){const e=c(n.start,a,i,t.x_range);this.side=y(e,n,this.side)}else if(2==this.side){const e=c(n.end,a,i,t.x_range);this.side=g(e,n,this.side)}if(null!=l)if(6==this.side||7==this.side)f(l,r,s,t.y_range);else if(4==this.side){const e=c(l.start,r,s,t.y_range);this.side=y(e,l,this.side)}else if(5==this.side){const e=c(l.end,r,s,t.y_range);this.side=g(e,l,this.side)}this.last_dx=e.deltaX,this.last_dy=e.deltaY}_pan_end(e){this.side=0}}i.RangeToolView=p,p.__name__="RangeToolView";const m=()=>new n.BoxAnnotation({level:"overlay",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:.5,line_dash:[2,2]});class v extends r.GestureTool{constructor(e){super(e),this.tool_name="Range Tool",this.icon=o.bk_tool_icon_range,this.event_type="pan",this.default_order=1}static init_RangeTool(){this.prototype.default_view=p,this.define({x_range:[a.Instance,null],x_interaction:[a.Boolean,!0],y_range:[a.Instance,null],y_interaction:[a.Boolean,!0],overlay:[a.Instance,m]})}initialize(){super.initialize(),this.overlay.in_cursor="grab",this.overlay.ew_cursor=null!=this.x_range&&this.x_interaction?"ew-resize":null,this.overlay.ns_cursor=null!=this.y_range&&this.y_interaction?"ns-resize":null}update_overlay_from_ranges(){null==this.x_range&&null==this.y_range&&(this.overlay.left=null,this.overlay.right=null,this.overlay.bottom=null,this.overlay.top=null,l.logger.warn("RangeTool not configured with any Ranges.")),null==this.x_range?(this.overlay.left=null,this.overlay.right=null):(this.overlay.left=this.x_range.start,this.overlay.right=this.x_range.end),null==this.y_range?(this.overlay.bottom=null,this.overlay.top=null):(this.overlay.bottom=this.y_range.start,this.overlay.top=this.y_range.end)}}i.RangeTool=v,v.__name__="RangeTool",v.init_RangeTool()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const o=e(1),i=e(364),c=o.__importStar(e(18)),n=e(309);class a extends i.SelectToolView{_tap(e){const{sx:t,sy:s}=e,o={type:"point",sx:t,sy:s};this._select(o,!0,this._select_mode(e))}_select(e,t,s){const o=this.model.callback;if("select"==this.model.behavior){const i=this._computed_renderers_by_data_source();for(const[,c]of i){const i=c[0].get_selection_manager(),n=c.map(e=>this.plot_view.renderer_views.get(e));if(i.select(n,e,t,s)&&null!=o){const t=n[0].coordinates.x_scale.invert(e.sx),s=n[0].coordinates.y_scale.invert(e.sy),c={geometries:Object.assign(Object.assign({},e),{x:t,y:s}),source:i.source};o.execute(this.model,c)}}this._emit_selection_event(e),this.plot_view.push_state("tap",{selection:this.plot_view.get_selection()})}else for(const t of this.computed_renderers){const s=this.plot_view.renderer_views.get(t),i=t.get_selection_manager();if(i.inspect(s,e)&&null!=o){const t=s.coordinates.x_scale.invert(e.sx),c=s.coordinates.y_scale.invert(e.sy),n={geometries:Object.assign(Object.assign({},e),{x:t,y:c}),source:i.source};o.execute(this.model,n)}}}}s.TapToolView=a,a.__name__="TapToolView";class _ extends i.SelectTool{constructor(e){super(e),this.tool_name="Tap",this.icon=n.bk_tool_icon_tap_select,this.event_type="tap",this.default_order=10}static init_TapTool(){this.prototype.default_view=a,this.define({behavior:[c.TapBehavior,"select"],callback:[c.Any]}),this.register_alias("click",()=>new _({behavior:"inspect"})),this.register_alias("tap",()=>new _)}}s.TapTool=_,_.__name__="TapTool",_.init_TapTool()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=e(1),o=e(306),n=i.__importStar(e(18)),a=e(309),l=e(371);class _ extends o.GestureToolView{_scroll(e){let t=this.model.speed*e.delta;t>.9?t=.9:t<-.9&&(t=-.9),this._update_ranges(t)}_update_ranges(e){const{frame:t}=this.plot_view,s=t.bbox.h_range,i=t.bbox.v_range,[o,n]=[s.start,s.end],[a,_]=[i.start,i.end];let h,r,d,p;switch(this.model.dimension){case"height":{const t=Math.abs(_-a);h=o,r=n,d=a-t*e,p=_-t*e;break}case"width":{const t=Math.abs(n-o);h=o-t*e,r=n-t*e,d=a,p=_;break}default:throw new Error("this shouldn't have happened")}const{x_scales:c,y_scales:u}=t,m={xrs:l.update_ranges(c,h,r),yrs:l.update_ranges(u,d,p),factor:e};this.plot_view.push_state("wheel_pan",{range:m}),this.plot_view.update_range(m,!1,!0),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)}}s.WheelPanToolView=_,_.__name__="WheelPanToolView";class h extends o.GestureTool{constructor(e){super(e),this.tool_name="Wheel Pan",this.icon=a.bk_tool_icon_wheel_pan,this.event_type="scroll",this.default_order=12}static init_WheelPanTool(){this.prototype.default_view=_,this.define({dimension:[n.Dimension,"width"]}),this.internal({speed:[n.Number,.001]}),this.register_alias("xwheel_pan",()=>new h({dimension:"width"})),this.register_alias("ywheel_pan",()=>new h({dimension:"height"}))}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimension)}}s.WheelPanTool=h,h.__name__="WheelPanTool",h.init_WheelPanTool()},
function _(e,o,t){Object.defineProperty(t,"__esModule",{value:!0});const s=e(1),i=e(306),l=e(354),n=s.__importStar(e(18)),_=e(32),h=e(309);class a extends i.GestureToolView{_pinch(e){const{sx:o,sy:t,scale:s,ctrlKey:i,shiftKey:l}=e;let n;n=s>=1?20*(s-1):-20/s,this._scroll({type:"wheel",sx:o,sy:t,delta:n,ctrlKey:i,shiftKey:l})}_scroll(e){const{frame:o}=this.plot_view,t=o.bbox.h_range,s=o.bbox.v_range,{sx:i,sy:n}=e,_=this.model.dimensions,h=("width"==_||"both"==_)&&t.start<i&&i<t.end,a=("height"==_||"both"==_)&&s.start<n&&n<s.end;if(!(h&&a||this.model.zoom_on_axis))return;const m=this.model.speed*e.delta,r=l.scale_range(o,m,h,a,{x:i,y:n});this.plot_view.push_state("wheel_zoom",{range:r}),this.plot_view.update_range(r,!1,!0,this.model.maintain_focus),null!=this.model.document&&this.model.document.interactive_start(this.plot_model)}}t.WheelZoomToolView=a,a.__name__="WheelZoomToolView";class m extends i.GestureTool{constructor(e){super(e),this.tool_name="Wheel Zoom",this.icon=h.bk_tool_icon_wheel_zoom,this.event_type=_.is_mobile?"pinch":"scroll",this.default_order=10}static init_WheelZoomTool(){this.prototype.default_view=a,this.define({dimensions:[n.Dimensions,"both"],maintain_focus:[n.Boolean,!0],zoom_on_axis:[n.Boolean,!0],speed:[n.Number,1/600]}),this.register_alias("wheel_zoom",()=>new m({dimensions:"both"})),this.register_alias("xwheel_zoom",()=>new m({dimensions:"width"})),this.register_alias("ywheel_zoom",()=>new m({dimensions:"height"}))}get tooltip(){return this._get_dim_tooltip(this.tool_name,this.dimensions)}}t.WheelZoomTool=m,m.__name__="WheelZoomTool",m.init_WheelZoomTool()},
function _(i,s,e){Object.defineProperty(e,"__esModule",{value:!0});const t=i(1),o=i(295),n=i(168),l=t.__importStar(i(18)),h=i(13),a=i(309);class r extends o.InspectToolView{_move(i){if(!this.model.active)return;const{sx:s,sy:e}=i;this.plot_view.frame.bbox.contains(s,e)?this._update_spans(s,e):this._update_spans(null,null)}_move_exit(i){this._update_spans(null,null)}_update_spans(i,s){const e=this.model.dimensions;"width"!=e&&"both"!=e||(this.model.spans.width.location=s),"height"!=e&&"both"!=e||(this.model.spans.height.location=i)}}e.CrosshairToolView=r,r.__name__="CrosshairToolView";class _ extends o.InspectTool{constructor(i){super(i),this.tool_name="Crosshair",this.icon=a.bk_tool_icon_crosshair}static init_CrosshairTool(){this.prototype.default_view=r,this.define({dimensions:[l.Dimensions,"both"],line_color:[l.Color,"black"],line_width:[l.Number,1],line_alpha:[l.Number,1]}),this.internal({spans:[l.Any]}),this.register_alias("crosshair",()=>new _)}get tooltip(){return this._get_dim_tooltip("Crosshair",this.dimensions)}get synthetic_renderers(){return h.values(this.spans)}initialize(){super.initialize(),this.spans={width:new n.Span({for_hover:!0,dimension:"width",location_units:"screen",level:"overlay",line_color:this.line_color,line_width:this.line_width,line_alpha:this.line_alpha}),height:new n.Span({for_hover:!0,dimension:"height",location_units:"screen",level:"overlay",line_color:this.line_color,line_width:this.line_width,line_alpha:this.line_alpha})}}}e.CrosshairTool=_,_.__name__="CrosshairTool",_.init_CrosshairTool()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const r=e(1),o=e(81),i=r.__importStar(e(18)),a=e(13),n=e(29);class u extends o.Model{constructor(e){super(e)}static init_CustomJSHover(){this.define({args:[i.Any,{}],code:[i.String,""]})}get values(){return a.values(this.args)}_make_code(e,t,s,r){return new Function(...a.keys(this.args),e,t,s,n.use_strict(r))}format(e,t,s){return this._make_code("value","format","special_vars",this.code)(...this.values,e,t,s)}}s.CustomJSHover=u,u.__name__="CustomJSHover",u.init_CustomJSHover()},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const o=e(1),n=e(295),i=e(171),r=e(90),l=e(116),c=e(365),a=o.__importStar(e(101)),_=e(187),d=e(72),p=o.__importStar(e(18)),h=e(22),m=e(13),u=e(303),y=e(8),f=e(115),x=e(309),v=e(172);function w(e,t,s,o,n,i){const r={x:n[e],y:i[e]},l={x:n[e+1],y:i[e+1]};let c,_;if("span"==t.type)"h"==t.direction?(c=Math.abs(r.x-s),_=Math.abs(l.x-s)):(c=Math.abs(r.y-o),_=Math.abs(l.y-o));else{const e={x:s,y:o};c=a.dist_2_pts(r,e),_=a.dist_2_pts(l,e)}return c<_?[[r.x,r.y],e]:[[l.x,l.y],e+1]}function g(e,t,s){return[[e[s],t[s]],s]}s._nearest_line_hit=w,s._line_hit=g;class b extends n.InspectToolView{initialize(){super.initialize(),this._ttmodels=null,this._ttviews=new Map;const{tooltips:e}=this.model;y.isArray(e)&&(this._template_el=this._create_template(e))}remove(){f.remove_views(this._ttviews),super.remove()}connect_signals(){super.connect_signals();for(const e of this.computed_renderers)e instanceof r.GlyphRenderer?this.connect(e.data_source.inspect,this._update):e instanceof l.GraphRenderer&&(this.connect(e.node_renderer.data_source.inspect,this._update),this.connect(e.edge_renderer.data_source.inspect,this._update));this.connect(this.model.properties.renderers.change,()=>this._computed_renderers=this._ttmodels=null),this.connect(this.model.properties.names.change,()=>this._computed_renderers=this._ttmodels=null),this.connect(this.model.properties.tooltips.change,()=>this._ttmodels=null)}_compute_ttmodels(){const e=new Map,t=this.model.tooltips;if(null!=t)for(const s of this.computed_renderers){const o=new i.Tooltip({custom:y.isString(t)||y.isFunction(t),attachment:this.model.attachment,show_arrow:this.model.show_arrow});s instanceof r.GlyphRenderer?e.set(s,o):s instanceof l.GraphRenderer&&(e.set(s.node_renderer,o),e.set(s.edge_renderer,o))}return(async()=>{const t=await f.build_views(this._ttviews,[...e.values()],{parent:this.plot_view});for(const e of t)e.render()})(),e}get computed_renderers(){if(null==this._computed_renderers){const e=this.model.renderers,t=this.plot_model.renderers,s=this.model.names;this._computed_renderers=c.compute_renderers(e,t,s)}return this._computed_renderers}get ttmodels(){return null==this._ttmodels&&(this._ttmodels=this._compute_ttmodels()),this._ttmodels}_clear(){this._inspect(1/0,1/0);for(const[,e]of this.ttmodels)e.clear()}_move(e){if(!this.model.active)return;const{sx:t,sy:s}=e;this.plot_view.frame.bbox.contains(t,s)?this._inspect(t,s):this._clear()}_move_exit(){this._clear()}_inspect(e,t){let s;if("mouse"==this.model.mode)s={type:"point",sx:e,sy:t};else{s={type:"span",direction:"vline"==this.model.mode?"h":"v",sx:e,sy:t}}for(const e of this.computed_renderers){e.get_selection_manager().inspect(this.plot_view.renderer_views.get(e),s)}null!=this.model.callback&&this._emit_callback(s)}_update([e,{geometry:t}]){if(!this.model.active)return;if(!(e instanceof r.GlyphRendererView))return;const{model:s}=e;if("ignore"==this.model.muted_policy&&s instanceof r.GlyphRenderer&&s.muted)return;const o=this.ttmodels.get(s);if(null==o)return;const n=s.get_selection_manager();let i=n.inspectors.get(s);if(s instanceof r.GlyphRenderer&&(i=s.view.convert_selection_to_subset(i)),i.is_empty())return void o.clear();const l=n.source,{sx:c,sy:a}=t,_=e.coordinates.x_scale,p=e.coordinates.y_scale,h=_.invert(c),u=p.invert(a),y=e.glyph,f=[];for(const s of i.line_indices){let o,n,r=y._x[s+1],d=y._y[s+1],m=s;switch(this.model.line_policy){case"interp":[r,d]=y.get_interpolation_hit(s,t),o=_.compute(r),n=p.compute(d);break;case"prev":[[o,n],m]=g(y.sx,y.sy,s);break;case"next":[[o,n],m]=g(y.sx,y.sy,s+1);break;case"nearest":[[o,n],m]=w(s,t,c,a,y.sx,y.sy),r=y._x[m],d=y._y[m];break;default:[o,n]=[c,a]}const x={index:m,x:h,y:u,sx:c,sy:a,data_x:r,data_y:d,rx:o,ry:n,indices:i.line_indices,name:e.model.name};f.push([o,n,this._render_tooltips(l,m,x)])}for(const t of i.image_indices){const s={index:t.index,x:h,y:u,sx:c,sy:a,name:e.model.name},o=this._render_tooltips(l,t,s);f.push([c,a,o])}for(const o of i.indices)if(m.isEmpty(i.multiline_indices)){const t=null!=y._x?y._x[o]:void 0,n=null!=y._y?y._y[o]:void 0;let _,d,p;if("snap_to_data"==this.model.point_policy){let e=y.get_anchor_point(this.model.anchor,o,[c,a]);null==e&&(e=y.get_anchor_point("center",o,[c,a])),_=e.x,d=e.y}else[_,d]=[c,a];p=s instanceof r.GlyphRenderer?s.view.convert_indices_from_subset([o])[0]:o;const m={index:p,x:h,y:u,sx:c,sy:a,data_x:t,data_y:n,indices:i.indices,name:e.model.name};f.push([_,d,this._render_tooltips(l,p,m)])}else for(const n of i.multiline_indices[o.toString()]){let d,m,x,v=y._xs[o][n],b=y._ys[o][n],k=n;switch(this.model.line_policy){case"interp":[v,b]=y.get_interpolation_hit(o,n,t),d=_.compute(v),m=p.compute(b);break;case"prev":[[d,m],k]=g(y.sxs[o],y.sys[o],n);break;case"next":[[d,m],k]=g(y.sxs[o],y.sys[o],n+1);break;case"nearest":[[d,m],k]=w(n,t,c,a,y.sxs[o],y.sys[o]),v=y._xs[o][k],b=y._ys[o][k];break;default:throw new Error("should't have happened")}x=s instanceof r.GlyphRenderer?s.view.convert_indices_from_subset([o])[0]:o;const A={index:x,x:h,y:u,sx:c,sy:a,data_x:v,data_y:b,segment_index:k,indices:i.multiline_indices,name:e.model.name};f.push([d,m,this._render_tooltips(l,x,A)])}if(0==f.length)o.clear();else{const{content:e}=o;d.empty(o.content);for(const[,,t]of f)e.appendChild(t);const[t,s]=f[f.length-1];o.setv({position:[t,s]},{check_eq:!1})}}_emit_callback(e){for(const t of this.computed_renderers){const s=this.plot_view.renderer_views.get(t),o=s.coordinates.x_scale.invert(e.sx),n=s.coordinates.y_scale.invert(e.sy),i=t.data_source.inspected,r=Object.assign({x:o,y:n},e);this.model.callback.execute(this.model,{index:i,geometry:r,renderer:t})}}_create_template(e){const t=d.div({style:{display:"table",borderSpacing:"2px"}});for(const[s]of e){const e=d.div({style:{display:"table-row"}});t.appendChild(e);const o=d.div({style:{display:"table-cell"},class:v.bk_tooltip_row_label},0!=s.length?s+": ":"");e.appendChild(o);const n=d.span();n.dataset.value="";const i=d.span({class:v.bk_tooltip_color_block}," ");i.dataset.swatch="",d.undisplay(i);const r=d.div({style:{display:"table-cell"},class:v.bk_tooltip_row_value},n,i);e.appendChild(r)}return t}_render_template(e,t,s,o,n){const i=e.cloneNode(!0),r=i.querySelectorAll("[data-value]"),l=i.querySelectorAll("[data-swatch]"),c=/\$color(\[.*\])?:(\w*)/;for(const[[,e],i]of u.enumerate(t)){const t=e.match(c);if(null!=t){const[,e="",n]=t,c=s.get_column(n);if(null==c){r[i].textContent=n+" unknown";continue}const a=e.indexOf("hex")>=0,_=e.indexOf("swatch")>=0;let p=y.isNumber(o)?c[o]:null;if(null==p){r[i].textContent="(null)";continue}a&&(p=h.color2hex(p)),r[i].textContent=p,_&&(l[i].style.backgroundColor=p,d.display(l[i]))}else{const t=_.replace_placeholders(e.replace("$~","$data_"),s,o,this.model.formatters,n);if(y.isString(t))r[i].textContent=t;else for(const e of t)r[i].appendChild(e)}}return i}_render_tooltips(e,t,s){const o=this.model.tooltips;if(y.isString(o)){const n=_.replace_placeholders({html:o},e,t,this.model.formatters,s);return d.div({},n)}return y.isFunction(o)?o(e,s):this._render_template(this._template_el,o,e,t,s)}}s.HoverToolView=b,b.__name__="HoverToolView";class k extends n.InspectTool{constructor(e){super(e),this.tool_name="Hover",this.icon=x.bk_tool_icon_hover}static init_HoverTool(){this.prototype.default_view=b,this.define({tooltips:[p.Any,[["index","$index"],["data (x, y)","($x, $y)"],["screen (x, y)","($sx, $sy)"]]],formatters:[p.Any,{}],renderers:[p.Any,"auto"],names:[p.Array,[]],mode:[p.HoverMode,"mouse"],muted_policy:[p.MutedPolicy,"show"],point_policy:[p.PointPolicy,"snap_to_data"],line_policy:[p.LinePolicy,"nearest"],show_arrow:[p.Boolean,!0],anchor:[p.Anchor,"center"],attachment:[p.TooltipAttachment,"horizontal"],callback:[p.Any]}),this.register_alias("hover",()=>new k)}}s.HoverTool=k,k.__name__="HoverTool",k.init_HoverTool()},
function _(t,o,e){Object.defineProperty(e,"__esModule",{value:!0});const i=t(1).__importStar(t(18)),n=t(15),s=t(81),l=t(295),c=t(303);class r extends s.Model{constructor(t){super(t)}static init_ToolProxy(){this.define({tools:[i.Array,[]],active:[i.Boolean,!1],disabled:[i.Boolean,!1]})}get button_view(){return this.tools[0].button_view}get event_type(){return this.tools[0].event_type}get tooltip(){return this.tools[0].tooltip}get tool_name(){return this.tools[0].tool_name}get icon(){return this.tools[0].computed_icon}get computed_icon(){return this.icon}get toggleable(){const t=this.tools[0];return t instanceof l.InspectTool&&t.toggleable}initialize(){super.initialize(),this.do=new n.Signal0(this,"do")}connect_signals(){super.connect_signals(),this.connect(this.do,()=>this.doit()),this.connect(this.properties.active.change,()=>this.set_active());for(const t of this.tools)this.connect(t.properties.active.change,()=>{this.active=t.active})}doit(){for(const t of this.tools)t.do.emit()}set_active(){for(const t of this.tools)t.active=this.active}get menu(){const{menu:t}=this.tools[0];if(null==t)return null;const o=[];for(const[e,i]of c.enumerate(t))if(null==e)o.push(null);else{const t=()=>{var t,o;for(const e of this.tools)null===(o=null===(t=e.menu)||void 0===t?void 0:t[i])||void 0===o||o.handler()};o.push(Object.assign(Object.assign({},e),{handler:t}))}return o}}e.ToolProxy=r,r.__name__="ToolProxy",r.init_ToolProxy()},
function _(o,t,s){Object.defineProperty(s,"__esModule",{value:!0});const i=o(1).__importStar(o(18)),e=o(9),n=o(13),r=o(305),l=o(379),c=o(272),h=o(212);class a extends r.ToolbarBase{constructor(o){super(o)}static init_ProxyToolbar(){this.define({toolbars:[i.Array,[]]})}initialize(){super.initialize(),this._merge_tools()}_merge_tools(){this._proxied_tools=[];const o={},t={},s={},i=[],r=[];for(const o of this.help)e.includes(r,o.redirect)||(i.push(o),r.push(o.redirect));this._proxied_tools.push(...i),this.help=i;for(const[o,t]of n.entries(this.gestures)){o in s||(s[o]={});for(const i of t.tools)i.type in s[o]||(s[o][i.type]=[]),s[o][i.type].push(i)}for(const t of this.inspectors)t.type in o||(o[t.type]=[]),o[t.type].push(t);for(const o of this.actions)o.type in t||(t[o.type]=[]),t[o.type].push(o);const c=(o,t=!1)=>{const s=new l.ToolProxy({tools:o,active:t});return this._proxied_tools.push(s),s};for(const o of n.keys(s)){const t=this.gestures[o];t.tools=[];for(const i of n.keys(s[o])){const e=s[o][i];if(e.length>0)if("multi"==o)for(const o of e){const s=c([o]);t.tools.push(s),this.connect(s.properties.active.change,()=>this._active_change(s))}else{const o=c(e);t.tools.push(o),this.connect(o.properties.active.change,()=>this._active_change(o))}}}this.actions=[];for(const[o,s]of n.entries(t))if("CustomAction"==o)for(const o of s)this.actions.push(c([o]));else s.length>0&&this.actions.push(c(s));this.inspectors=[];for(const t of n.values(o))t.length>0&&this.inspectors.push(c(t,!0));for(const[o,t]of n.entries(this.gestures))0!=t.tools.length&&(t.tools=e.sort_by(t.tools,o=>o.default_order),"pinch"!=o&&"scroll"!=o&&"multi"!=o&&(t.tools[0].active=!0))}}s.ProxyToolbar=a,a.__name__="ProxyToolbar",a.init_ProxyToolbar();class _ extends c.LayoutDOMView{initialize(){this.model.toolbar.toolbar_location=this.model.toolbar_location,super.initialize()}get child_models(){return[this.model.toolbar]}_update_layout(){this.layout=new h.ContentBox(this.child_views[0].el);const{toolbar:o}=this.model;o.horizontal?this.layout.set_sizing({width_policy:"fit",min_width:100,height_policy:"fixed"}):this.layout.set_sizing({width_policy:"fixed",height_policy:"fit",min_height:100})}}s.ToolbarBoxView=_,_.__name__="ToolbarBoxView";class p extends c.LayoutDOM{constructor(o){super(o)}static init_ToolbarBox(){this.prototype.default_view=_,this.define({toolbar:[i.Instance],toolbar_location:[i.Location,"right"]})}}s.ToolbarBox=p,p.__name__="ToolbarBox",p.init_ToolbarBox()},
function _(e,n,t){Object.defineProperty(t,"__esModule",{value:!0});const o=e(5),i=e(78),d=e(115),c=e(72),l=e(382);t.index={},t.add_document_standalone=async function(e,n,s=[],a=!1){const u=new Map;async function r(o){let a;const r=e.roots().indexOf(o),f=s[r];null!=f?a=f:n.classList.contains(l.BOKEH_ROOT)?a=n:(a=c.div({class:l.BOKEH_ROOT}),n.appendChild(a));const v=await d.build_view(o,{parent:null});return v instanceof i.DOMView&&v.renderTo(a),u.set(o,v),t.index[o.id]=v,v}for(const n of e.roots())await r(n);return a&&(window.document.title=e.title()),e.on_change(e=>{e instanceof o.RootAddedEvent?r(e.model):e instanceof o.RootRemovedEvent?function(e){const n=u.get(e);null!=n&&(n.remove(),u.delete(e),delete t.index[e.id])}(e.model):a&&e instanceof o.TitleChangedEvent&&(window.document.title=e.title)}),[...u.values()]}},
function _(e,o,n){Object.defineProperty(n,"__esModule",{value:!0});const t=e(72),r=e(273);function l(e){let o=document.getElementById(e);if(null==o)throw new Error(`Error rendering Bokeh model: could not find #${e} HTML tag`);if(!document.body.contains(o))throw new Error(`Error rendering Bokeh model: element #${e} must be under <body>`);if("SCRIPT"==o.tagName){const e=t.div({class:n.BOKEH_ROOT});t.replaceWith(o,e),o=e}return o}n.BOKEH_ROOT=r.bk_root,n._resolve_element=function(e){const{elementid:o}=e;return null!=o?l(o):document.body},n._resolve_root_elements=function(e){const o=[];if(null!=e.root_ids&&null!=e.roots)for(const n of e.root_ids)o.push(l(e.roots[n]));return o}},
function _(n,o,t){Object.defineProperty(t,"__esModule",{value:!0});const e=n(384),s=n(19),c=n(381);t._get_ws_url=function(n,o){let t,e="ws:";return"https:"==window.location.protocol&&(e="wss:"),null!=o?(t=document.createElement("a"),t.href=o):t=window.location,null!=n?"/"==n&&(n=""):n=t.pathname.replace(/\/+$/,""),e+"//"+t.host+n+"/ws"};const r={};t.add_document_from_session=async function(n,o,t,a=[],i=!1){const l=window.location.search.substr(1);let d;try{d=await function(n,o,t){const s=e.parse_token(o).session_id;n in r||(r[n]={});const c=r[n];return s in c||(c[s]=e.pull_session(n,o,t)),c[s]}(n,o,l)}catch(n){const t=e.parse_token(o).session_id;throw s.logger.error(`Failed to load Bokeh session ${t}: ${n}`),n}return c.add_document_standalone(d.document,t,a,i)}},
function _(e,s,n){Object.defineProperty(n,"__esModule",{value:!0});const t=e(19),o=e(5),r=e(385),i=e(386),c=e(387);n.DEFAULT_SERVER_WEBSOCKET_URL="ws://localhost:5006/ws",n.DEFAULT_TOKEN="eyJzZXNzaW9uX2lkIjogImRlZmF1bHQifQ";let l=0;function _(e){let s=e.split(".")[0];const n=s.length%4;return 0!=n&&(s+="=".repeat(4-n)),JSON.parse(atob(s.replace(/_/g,"/").replace(/-/g,"+")))}n.parse_token=_;class h{constructor(e=n.DEFAULT_SERVER_WEBSOCKET_URL,s=n.DEFAULT_TOKEN,o=null){this.url=e,this.token=s,this.args_string=o,this._number=l++,this.socket=null,this.session=null,this.closed_permanently=!1,this._current_handler=null,this._pending_replies=new Map,this._pending_messages=[],this._receiver=new i.Receiver,this.id=_(s).session_id.split(".")[0],t.logger.debug(`Creating websocket ${this._number} to '${this.url}' session '${this.id}'`)}async connect(){if(this.closed_permanently)throw new Error("Cannot connect() a closed ClientConnection");if(null!=this.socket)throw new Error("Already connected");this._current_handler=null,this._pending_replies.clear(),this._pending_messages=[];try{let e=""+this.url;return null!=this.args_string&&this.args_string.length>0&&(e+="?"+this.args_string),this.socket=new WebSocket(e,["bokeh",this.token]),new Promise((e,s)=>{this.socket.binaryType="arraybuffer",this.socket.onopen=()=>this._on_open(e,s),this.socket.onmessage=e=>this._on_message(e),this.socket.onclose=e=>this._on_close(e,s),this.socket.onerror=()=>this._on_error(s)})}catch(e){throw t.logger.error("websocket creation failed to url: "+this.url),t.logger.error(" - "+e),e}}close(){this.closed_permanently||(t.logger.debug("Permanently closing websocket connection "+this._number),this.closed_permanently=!0,null!=this.socket&&this.socket.close(1e3,"close method called on ClientConnection "+this._number),this.session._connection_closed())}_schedule_reconnect(e){setTimeout(()=>{this.closed_permanently||t.logger.info(`Websocket connection ${this._number} disconnected, will not attempt to reconnect`)},e)}send(e){if(null==this.socket)throw new Error("not connected so cannot send "+e);e.send(this.socket)}async send_with_reply(e){const s=await new Promise((s,n)=>{this._pending_replies.set(e.msgid(),{resolve:s,reject:n}),this.send(e)});if("ERROR"===s.msgtype())throw new Error("Error reply "+s.content.text);return s}async _pull_doc_json(){const e=r.Message.create("PULL-DOC-REQ",{}),s=await this.send_with_reply(e);if(!("doc"in s.content))throw new Error("No 'doc' field in PULL-DOC-REPLY");return s.content.doc}async _repull_session_doc(e,s){var n;t.logger.debug(this.session?"Repulling session":"Pulling session for first time");try{const n=await this._pull_doc_json();if(null==this.session)if(this.closed_permanently)t.logger.debug("Got new document after connection was already closed"),s(new Error("The connection has been closed"));else{const s=o.Document.from_json(n),i=o.Document._compute_patch_since_json(n,s);if(i.events.length>0){t.logger.debug(`Sending ${i.events.length} changes from model construction back to server`);const e=r.Message.create("PATCH-DOC",{},i);this.send(e)}this.session=new c.ClientSession(this,s,this.id);for(const e of this._pending_messages)this.session.handle(e);this._pending_messages=[],t.logger.debug("Created a new session from new pulled doc"),e(this.session)}else this.session.document.replace_with_json(n),t.logger.debug("Updated existing session with new pulled doc")}catch(e){null===(n=console.trace)||void 0===n||n.call(console,e),t.logger.error("Failed to repull session "+e),s(e)}}_on_open(e,s){t.logger.info(`Websocket connection ${this._number} is now open`),this._current_handler=n=>{this._awaiting_ack_handler(n,e,s)}}_on_message(e){null==this._current_handler&&t.logger.error("Got a message with no current handler set");try{this._receiver.consume(e.data)}catch(e){this._close_bad_protocol(e.toString())}const s=this._receiver.message;if(null!=s){const e=s.problem();null!=e&&this._close_bad_protocol(e),this._current_handler(s)}}_on_close(e,s){t.logger.info(`Lost websocket ${this._number} connection, ${e.code} (${e.reason})`),this.socket=null,this._pending_replies.forEach(e=>e.reject("Disconnected")),this._pending_replies.clear(),this.closed_permanently||this._schedule_reconnect(2e3),s(new Error(`Lost websocket connection, ${e.code} (${e.reason})`))}_on_error(e){t.logger.debug("Websocket error on socket "+this._number);const s="Could not open websocket";t.logger.error("Failed to connect to Bokeh server: "+s),e(new Error(s))}_close_bad_protocol(e){t.logger.error("Closing connection: "+e),null!=this.socket&&this.socket.close(1002,e)}_awaiting_ack_handler(e,s,n){"ACK"===e.msgtype()?(this._current_handler=e=>this._steady_state_handler(e),this._repull_session_doc(s,n)):this._close_bad_protocol("First message was not an ACK")}_steady_state_handler(e){const s=e.reqid(),n=this._pending_replies.get(s);n?(this._pending_replies.delete(s),n.resolve(e)):this.session?this.session.handle(e):"PATCH-DOC"!=e.msgtype()&&this._pending_messages.push(e)}}n.ClientConnection=h,h.__name__="ClientConnection",n.pull_session=function(e,s,n){return new h(e,s,n).connect()}},
function _(e,s,t){Object.defineProperty(t,"__esModule",{value:!0});const r=e(29);class n{constructor(e,s,t){this.header=e,this.metadata=s,this.content=t,this.buffers=new Map}static assemble(e,s,t){const r=JSON.parse(e),i=JSON.parse(s),a=JSON.parse(t);return new n(r,i,a)}assemble_buffer(e,s){const t=null!=this.header.num_buffers?this.header.num_buffers:0;if(t<=this.buffers.size)throw new Error("too many buffers received, expecting "+t);const{id:r}=JSON.parse(e);this.buffers.set(r,s)}static create(e,s,t={}){const r=n.create_header(e);return new n(r,s,t)}static create_header(e){return{msgid:r.uniqueId(),msgtype:e}}complete(){return null!=this.header&&null!=this.metadata&&null!=this.content&&(null==this.header.num_buffers||this.buffers.size==this.header.num_buffers)}send(e){if((null!=this.header.num_buffers?this.header.num_buffers:0)>0)throw new Error("BokehJS only supports receiving buffers, not sending");const s=JSON.stringify(this.header),t=JSON.stringify(this.metadata),r=JSON.stringify(this.content);e.send(s),e.send(t),e.send(r)}msgid(){return this.header.msgid}msgtype(){return this.header.msgtype}reqid(){return this.header.reqid}problem(){return"msgid"in this.header?"msgtype"in this.header?null:"No msgtype in header":"No msgid in header"}}t.Message=n,n.__name__="Message"},
function _(e,t,s){Object.defineProperty(s,"__esModule",{value:!0});const _=e(385),r=e(8);class i{constructor(){this.message=null,this._partial=null,this._fragments=[],this._buf_header=null,this._current_consumer=this._HEADER}consume(e){this._current_consumer(e)}_HEADER(e){this._assume_text(e),this.message=null,this._partial=null,this._fragments=[e],this._buf_header=null,this._current_consumer=this._METADATA}_METADATA(e){this._assume_text(e),this._fragments.push(e),this._current_consumer=this._CONTENT}_CONTENT(e){this._assume_text(e),this._fragments.push(e);const[t,s,r]=this._fragments.slice(0,3);this._partial=_.Message.assemble(t,s,r),this._check_complete()}_BUFFER_HEADER(e){this._assume_text(e),this._buf_header=e,this._current_consumer=this._BUFFER_PAYLOAD}_BUFFER_PAYLOAD(e){this._assume_binary(e),this._partial.assemble_buffer(this._buf_header,e),this._check_complete()}_assume_text(e){if(!r.isString(e))throw new Error("Expected text fragment but received binary fragment")}_assume_binary(e){if(!(e instanceof ArrayBuffer))throw new Error("Expected binary fragment but received text fragment")}_check_complete(){this._partial.complete()?(this.message=this._partial,this._current_consumer=this._HEADER):this._current_consumer=this._BUFFER_HEADER}}s.Receiver=i,i.__name__="Receiver"},
function _(e,t,n){Object.defineProperty(n,"__esModule",{value:!0});const o=e(5),s=e(385),c=e(19);class i{constructor(e,t,n){this._connection=e,this.document=t,this.id=n,this._document_listener=e=>{this._document_changed(e)},this.document.on_change(this._document_listener,!0)}handle(e){const t=e.msgtype();"PATCH-DOC"===t?this._handle_patch(e):"OK"===t?this._handle_ok(e):"ERROR"===t?this._handle_error(e):c.logger.debug("Doing nothing with message "+e.msgtype())}close(){this._connection.close()}_connection_closed(){this.document.remove_on_change(this._document_listener)}async request_server_info(){const e=s.Message.create("SERVER-INFO-REQ",{});return(await this._connection.send_with_reply(e)).content}async force_roundtrip(){await this.request_server_info()}_document_changed(e){if(e.setter_id===this.id)return;const t=e instanceof o.DocumentEventBatch?e.events:[e],n=this.document.create_json_patch(t),c=s.Message.create("PATCH-DOC",{},n);this._connection.send(c)}_handle_patch(e){this.document.apply_json_patch(e.content,e.buffers,this.id)}_handle_ok(e){c.logger.trace("Unhandled OK reply to "+e.reqid())}_handle_error(e){c.logger.error(`Unhandled ERROR reply to ${e.reqid()}: ${e.content.text}`)}}n.ClientSession=i,i.__name__="ClientSession"},
function _(e,o,t){Object.defineProperty(t,"__esModule",{value:!0});const n=e(1);var r=this&&this.__asyncValues||function(e){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var o,t=e[Symbol.asyncIterator];return t?t.call(e):(e="function"==typeof __values?__values(e):e[Symbol.iterator](),o={},n("next"),n("throw"),n("return"),o[Symbol.asyncIterator]=function(){return this},o);function n(t){o[t]=e[t]&&function(o){return new Promise((function(n,r){(function(e,o,t,n){Promise.resolve(n).then((function(o){e({value:o,done:t})}),o)})(n,r,(o=e[t](o)).done,o.value)}))}}};const s=e(5),i=e(386),l=e(19),a=e(72),c=e(13),u=e(381),f=e(382),g=n.__importDefault(e(73)),m=n.__importDefault(e(311)),d=n.__importDefault(e(389));function p(e,o){o.buffers.length>0?e.consume(o.buffers[0].buffer):e.consume(o.content.data);const t=e.message;null!=t&&this.apply_json_patch(t.content,t.buffers)}function _(e,o){if("undefined"!=typeof Jupyter&&null!=Jupyter.notebook.kernel){l.logger.info("Registering Jupyter comms for target "+e);const t=Jupyter.notebook.kernel.comm_manager;try{t.register_target(e,t=>{l.logger.info("Registering Jupyter comms for target "+e);const n=new i.Receiver;t.on_msg(p.bind(o,n))})}catch(e){l.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else if(o.roots()[0].id in t.kernels){l.logger.info("Registering JupyterLab comms for target "+e);const n=t.kernels[o.roots()[0].id];try{n.registerCommTarget(e,t=>{l.logger.info("Registering JupyterLab comms for target "+e);const n=new i.Receiver;t.onMsg=p.bind(o,n)})}catch(e){l.logger.warn(`Jupyter comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else if("undefined"!=typeof google&&null!=google.colab.kernel){l.logger.info("Registering Google Colab comms for target "+e);const t=google.colab.kernel.comms;try{t.registerTarget(e,async t=>{var n,s,a;l.logger.info("Registering Google Colab comms for target "+e);const c=new i.Receiver;try{for(var u,f=r(t.messages);!(u=await f.next()).done;){const e=u.value,t={data:e.data},n=[];for(const o of null!==(a=e.buffers)&&void 0!==a?a:[])n.push(new DataView(o));const r={content:t,buffers:n};p.bind(o)(c,r)}}catch(e){n={error:e}}finally{try{u&&!u.done&&(s=f.return)&&await s.call(f)}finally{if(n)throw n.error}}})}catch(e){l.logger.warn(`Google Colab comms failed to register. push_notebook() will not function. (exception reported: ${e})`)}}else console.warn("Jupyter notebooks comms not available. push_notebook() will not function. If running JupyterLab ensure the latest @bokeh/jupyter_bokeh extension is installed. In an exported notebook this warning is expected.")}a.stylesheet.append(g.default),a.stylesheet.append(m.default),a.stylesheet.append(d.default),t.kernels={},t.embed_items_notebook=function(e,o){if(1!=c.size(e))throw new Error("embed_items_notebook expects exactly one document in docs_json");const t=s.Document.from_json(c.values(e)[0]);for(const e of o){null!=e.notebook_comms_target&&_(e.notebook_comms_target,t);const o=f._resolve_element(e),n=f._resolve_root_elements(e);u.add_document_standalone(t,o,n)}}},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0});o.default="\n/* notebook specific tweaks so no black outline and matching padding\n/* can't be wrapped inside bk-root. here are the offending jupyter lines:\n/* https://github.com/jupyter/notebook/blob/master/notebook/static/notebook/less/renderedhtml.less#L59-L76 */\n.rendered_html .bk-root .bk-tooltip table,\n.rendered_html .bk-root .bk-tooltip tr,\n.rendered_html .bk-root .bk-tooltip th,\n.rendered_html .bk-root .bk-tooltip td {\n  border: none;\n  padding: 1px;\n}\n"},
function _(e,t,_){Object.defineProperty(_,"__esModule",{value:!0});const o=e(1);o.__exportStar(e(385),_),o.__exportStar(e(386),_)},
function _(e,t,n){function s(){const e=document.getElementsByTagName("body")[0],t=document.getElementsByClassName("bokeh-test-div");1==t.length&&(e.removeChild(t[0]),delete t[0]);const n=document.createElement("div");n.classList.add("bokeh-test-div"),n.style.display="none",e.insertBefore(n,e.firstChild)}Object.defineProperty(n,"__esModule",{value:!0}),n.results={},n.init=function(){s()},n.record0=function(e,t){n.results[e]=t},n.record=function(e,t){n.results[e]=t,s()},n.count=function(e){null==n.results[e]&&(n.results[e]=0),n.results[e]+=1,s()}},
function _(e,t,o){Object.defineProperty(o,"__esModule",{value:!0}),o.safely=function(e,t=!1){try{return e()}catch(e){if(function(e){const t=document.createElement("div");t.style.backgroundColor="#f2dede",t.style.border="1px solid #a94442",t.style.borderRadius="4px",t.style.display="inline-block",t.style.fontFamily="sans-serif",t.style.marginTop="5px",t.style.minWidth="200px",t.style.padding="5px 5px 5px 10px",t.classList.add("bokeh-error-box-into-flames");const o=document.createElement("span");o.style.backgroundColor="#a94442",o.style.borderRadius="0px 4px 0px 0px",o.style.color="white",o.style.cursor="pointer",o.style.cssFloat="right",o.style.fontSize="0.8em",o.style.margin="-6px -6px 0px 0px",o.style.padding="2px 5px 4px 5px",o.title="close",o.setAttribute("aria-label","close"),o.appendChild(document.createTextNode("x")),o.addEventListener("click",()=>r.removeChild(t));const n=document.createElement("h3");n.style.color="#a94442",n.style.margin="8px 0px 0px 0px",n.style.padding="0px",n.appendChild(document.createTextNode("Bokeh Error"));const l=document.createElement("pre");l.style.whiteSpace="unset",l.style.overflowX="auto";const s=e instanceof Error?e.message:e;l.appendChild(document.createTextNode(s)),t.appendChild(o),t.appendChild(n),t.appendChild(l);const r=document.getElementsByTagName("body")[0];r.insertBefore(t,r.firstChild)}(e),t)return;throw e}}},
], 0, {"main":0,"tslib":1,"index":2,"version":3,"embed/index":4,"document/index":5,"document/document":6,"base":7,"core/util/types":8,"core/util/array":9,"core/util/math":10,"core/util/assert":11,"core/util/arrayable":12,"core/util/object":13,"core/has_props":14,"core/signaling":15,"core/util/callback":16,"core/util/refs":17,"core/properties":18,"core/logging":19,"core/enums":20,"core/kinds":21,"core/util/color":22,"core/util/svg_colors":23,"core/types":24,"core/util/eq":25,"core/util/data_structures":26,"core/settings":27,"core/property_mixins":28,"core/util/string":29,"core/util/ndarray":30,"core/util/serialization":31,"core/util/compat":32,"core/util/pretty":33,"models/index":34,"models/annotations/index":35,"models/annotations/annotation":36,"core/util/projections":37,"models/renderers/renderer":70,"core/view":71,"core/dom":72,"styles/root.css":73,"core/visuals":74,"core/util/svg":75,"core/util/affine":76,"models/canvas/canvas":77,"core/dom_view":78,"core/util/bbox":79,"core/util/canvas":80,"model":81,"models/canvas/coordinates":82,"models/annotations/arrow":83,"models/annotations/arrow_head":84,"models/sources/column_data_source":85,"models/sources/columnar_data_source":86,"models/sources/data_source":87,"models/selections/selection":88,"core/selection_manager":89,"models/renderers/glyph_renderer":90,"models/renderers/data_renderer":91,"models/glyphs/line":92,"models/glyphs/xy_glyph":93,"models/glyphs/glyph":94,"core/util/spatial":95,"models/ranges/factor_range":98,"models/ranges/range":99,"models/glyphs/utils":100,"core/hittest":101,"models/glyphs/webgl/line":102,"models/glyphs/webgl/utils/index":103,"models/glyphs/webgl/utils/program":104,"models/glyphs/webgl/utils/buffer":105,"models/glyphs/webgl/utils/texture":106,"models/glyphs/webgl/base":107,"models/glyphs/webgl/line.vert":108,"models/glyphs/webgl/line.frag":109,"models/glyphs/patch":110,"models/glyphs/harea":111,"models/glyphs/area":112,"models/glyphs/varea":113,"models/sources/cds_view":114,"core/build_views":115,"models/renderers/graph_renderer":116,"models/graphs/graph_hit_test_policy":117,"models/selections/interaction_policy":118,"core/util/typed_array":119,"core/util/set":120,"document/events":121,"models/annotations/band":122,"models/annotations/upper_lower":123,"models/annotations/box_annotation":124,"models/annotations/color_bar":125,"models/tickers/basic_ticker":126,"models/tickers/adaptive_ticker":127,"models/tickers/continuous_ticker":128,"models/tickers/ticker":129,"models/formatters/basic_tick_formatter":130,"models/formatters/tick_formatter":131,"models/mappers/index":132,"models/mappers/categorical_color_mapper":133,"models/mappers/categorical_mapper":134,"models/mappers/color_mapper":135,"models/mappers/mapper":136,"models/transforms/transform":137,"models/mappers/categorical_marker_mapper":138,"models/mappers/categorical_pattern_mapper":139,"models/mappers/continuous_color_mapper":140,"models/mappers/linear_color_mapper":141,"models/mappers/log_color_mapper":142,"models/mappers/scanning_color_mapper":143,"models/mappers/eqhist_color_mapper":144,"models/scales/linear_scale":145,"models/scales/continuous_scale":146,"models/scales/scale":147,"models/transforms/index":148,"models/transforms/customjs_transform":149,"models/transforms/dodge":150,"models/transforms/range_transform":151,"models/transforms/interpolator":152,"models/transforms/jitter":153,"models/transforms/linear_interpolator":154,"models/transforms/step_interpolator":155,"models/scales/linear_interpolation_scale":156,"models/scales/log_scale":157,"models/ranges/range1d":158,"core/util/text":159,"models/annotations/label":160,"models/annotations/text_annotation":161,"models/annotations/label_set":162,"models/annotations/legend":163,"models/annotations/legend_item":164,"core/vectorization":165,"models/annotations/poly_annotation":166,"models/annotations/slope":167,"models/annotations/span":168,"models/annotations/title":169,"models/annotations/toolbar_panel":170,"models/annotations/tooltip":171,"styles/tooltips":172,"styles/mixins":173,"styles/tooltips.css":174,"models/annotations/whisker":175,"models/axes/index":176,"models/axes/axis":177,"models/renderers/guide_renderer":178,"models/axes/categorical_axis":179,"models/tickers/categorical_ticker":180,"models/formatters/categorical_tick_formatter":181,"models/axes/continuous_axis":182,"models/axes/datetime_axis":183,"models/axes/linear_axis":184,"models/formatters/datetime_tick_formatter":185,"core/util/templating":187,"models/tickers/datetime_ticker":190,"models/tickers/composite_ticker":191,"models/tickers/days_ticker":192,"models/tickers/single_interval_ticker":193,"models/tickers/util":194,"models/tickers/months_ticker":195,"models/tickers/years_ticker":196,"models/axes/log_axis":197,"models/formatters/log_tick_formatter":198,"models/tickers/log_ticker":199,"models/axes/mercator_axis":200,"models/formatters/mercator_tick_formatter":201,"models/tickers/mercator_ticker":202,"models/callbacks/index":203,"models/callbacks/customjs":204,"models/callbacks/callback":205,"models/callbacks/open_url":206,"models/canvas/index":207,"models/canvas/cartesian_frame":208,"models/scales/categorical_scale":209,"models/ranges/data_range1d":210,"models/ranges/data_range":211,"core/layout/index":212,"core/layout/types":213,"core/layout/layoutable":214,"core/layout/alignments":215,"core/layout/grid":216,"core/layout/html":217,"models/expressions/index":218,"models/expressions/expression":219,"models/expressions/stack":220,"models/expressions/cumsum":221,"models/filters/index":222,"models/filters/boolean_filter":223,"models/filters/filter":224,"models/filters/customjs_filter":225,"models/filters/group_filter":226,"models/filters/index_filter":227,"models/formatters/index":228,"models/formatters/func_tick_formatter":229,"models/formatters/numeral_tick_formatter":230,"models/formatters/printf_tick_formatter":231,"models/glyphs/index":232,"models/glyphs/annular_wedge":233,"models/glyphs/annulus":234,"models/glyphs/arc":235,"models/glyphs/bezier":236,"models/glyphs/circle":237,"models/glyphs/webgl/markers":238,"models/glyphs/webgl/markers.vert":239,"models/glyphs/webgl/markers.frag":240,"models/glyphs/center_rotatable":241,"models/glyphs/ellipse":242,"models/glyphs/ellipse_oval":243,"models/glyphs/hbar":244,"models/glyphs/box":245,"models/glyphs/hex_tile":246,"models/glyphs/image":247,"models/glyphs/image_base":248,"models/glyphs/image_rgba":249,"models/glyphs/image_url":250,"core/util/image":251,"models/glyphs/multi_line":252,"models/glyphs/multi_polygons":253,"models/glyphs/oval":254,"models/glyphs/patches":255,"models/glyphs/quad":256,"models/glyphs/quadratic":257,"models/glyphs/ray":258,"models/glyphs/rect":259,"models/glyphs/segment":260,"models/glyphs/step":261,"models/glyphs/text":262,"models/glyphs/vbar":263,"models/glyphs/wedge":264,"models/graphs/index":265,"models/graphs/layout_provider":266,"models/graphs/static_layout_provider":267,"models/grids/index":268,"models/grids/grid":269,"models/layouts/index":270,"models/layouts/box":271,"models/layouts/layout_dom":272,"styles/root":273,"models/layouts/column":274,"models/layouts/grid_box":275,"models/layouts/html_box":276,"models/layouts/row":277,"models/layouts/spacer":278,"models/layouts/tabs":279,"styles/tabs":280,"styles/buttons":281,"styles/menus":282,"styles/buttons.css":283,"styles/menus.css":284,"styles/tabs.css":285,"models/layouts/widget_box":286,"models/markers/index":287,"models/markers/defs":288,"models/markers/marker":289,"models/markers/scatter":290,"models/plots/index":291,"models/plots/gmap_plot":292,"models/plots/plot":293,"models/tools/toolbar":294,"models/tools/inspectors/inspect_tool":295,"models/tools/button_tool":296,"models/tools/tool":298,"styles/toolbar":299,"styles/toolbar.css":300,"styles/icons.css":301,"core/util/menus":302,"core/util/iterator":303,"models/tools/on_off_button":304,"models/tools/toolbar_base":305,"models/tools/gestures/gesture_tool":306,"models/tools/actions/action_tool":307,"models/tools/actions/help_tool":308,"styles/icons":309,"styles/logo":310,"styles/logo.css":311,"models/plots/plot_canvas":312,"core/bokeh_events":313,"core/ui_events":314,"core/util/wheel":315,"core/util/throttle":316,"core/layout/border":317,"core/layout/side_panel":318,"models/plots/gmap_plot_canvas":319,"models/ranges/index":320,"models/renderers/index":321,"models/scales/index":322,"models/selections/index":323,"models/sources/index":324,"models/sources/server_sent_data_source":325,"models/sources/web_data_source":326,"models/sources/ajax_data_source":327,"models/sources/geojson_data_source":328,"models/tickers/index":329,"models/tickers/fixed_ticker":330,"models/tiles/index":331,"models/tiles/bbox_tile_source":332,"models/tiles/mercator_tile_source":333,"models/tiles/tile_source":334,"models/tiles/tile_utils":335,"models/tiles/quadkey_tile_source":336,"models/tiles/tile_renderer":337,"models/tiles/wmts_tile_source":338,"styles/tiles":339,"styles/tiles.css":340,"models/tiles/tms_tile_source":341,"models/textures/index":342,"models/textures/canvas_texture":343,"models/textures/texture":344,"models/textures/image_url_texture":345,"models/tools/index":346,"models/tools/actions/custom_action":347,"models/tools/actions/redo_tool":348,"models/tools/actions/reset_tool":349,"models/tools/actions/save_tool":350,"models/tools/actions/undo_tool":351,"models/tools/actions/zoom_in_tool":352,"models/tools/actions/zoom_base_tool":353,"core/util/zoom":354,"models/tools/actions/zoom_out_tool":355,"models/tools/edit/edit_tool":356,"models/tools/edit/box_edit_tool":357,"models/tools/edit/freehand_draw_tool":358,"models/tools/edit/point_draw_tool":359,"models/tools/edit/poly_draw_tool":360,"models/tools/edit/poly_tool":361,"models/tools/edit/poly_edit_tool":362,"models/tools/gestures/box_select_tool":363,"models/tools/gestures/select_tool":364,"models/tools/util":365,"models/tools/gestures/box_zoom_tool":366,"models/tools/gestures/lasso_select_tool":367,"models/tools/gestures/poly_select_tool":368,"models/tools/edit/line_edit_tool":369,"models/tools/edit/line_tool":370,"models/tools/gestures/pan_tool":371,"models/tools/gestures/range_tool":372,"models/tools/gestures/tap_tool":373,"models/tools/gestures/wheel_pan_tool":374,"models/tools/gestures/wheel_zoom_tool":375,"models/tools/inspectors/crosshair_tool":376,"models/tools/inspectors/customjs_hover":377,"models/tools/inspectors/hover_tool":378,"models/tools/tool_proxy":379,"models/tools/toolbar_box":380,"embed/standalone":381,"embed/dom":382,"embed/server":383,"client/connection":384,"protocol/message":385,"protocol/receiver":386,"client/session":387,"embed/notebook":388,"styles/notebook.css":389,"protocol/index":390,"testing":391,"safely":392}, {});
})

