/*!
 * Copyright (c) 2012 - 2021, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  const bokeh = factory();
  bokeh.__bokeh__ = true;
  if (typeof root.Bokeh === "undefined" || typeof root.Bokeh.__bokeh__ === "undefined") {
    root.Bokeh = bokeh;
  }
  const Bokeh = root.Bokeh;
  Bokeh[bokeh.version] = bokeh;
})(this, function() {
  var define;
  var parent_require = typeof require === "function" && require
  return (function(modules, entry, aliases, externals) {
  if (aliases === undefined) aliases = {};
  if (externals === undefined) externals = {};

  var cache = {};

  var normalize = function(name) {
    if (typeof name === "number")
      return name;

    if (name === "bokehjs")
      return entry;

    if (!externals[name]) {
      var prefix = "@bokehjs/"
      if (name.slice(0, prefix.length) === prefix)
        name = name.slice(prefix.length)
    }

    var alias = aliases[name]
    if (alias != null)
      return alias;

    var trailing = name.length > 0 && name[name.lenght-1] === "/";
    var index = aliases[name + (trailing ? "" : "/") + "index"];
    if (index != null)
      return index;

    return name;
  }

  var require = function(name) {
    var mod = cache[name];
    if (!mod) {
      var id = normalize(name);

      mod = cache[id];
      if (!mod) {
        if (!modules[id]) {
          if (externals[id] === false || (externals[id] == true && parent_require)) {
            try {
              mod = {exports: externals[id] ? parent_require(id) : {}};
              cache[id] = cache[name] = mod;
              return mod.exports;
            } catch (e) {}
          }

          var err = new Error("Cannot find module '" + name + "'");
          err.code = 'MODULE_NOT_FOUND';
          throw err;
        }

        mod = {exports: {}};
        cache[id] = cache[name] = mod;

        function __esModule() {
          Object.defineProperty(mod.exports, "__esModule", {value: true});
        }

        function __esExport(name, value) {
          Object.defineProperty(mod.exports, name, {
            enumerable: true, get: function () { return value; }
          });
        }

        modules[id].call(mod.exports, require, mod, mod.exports, __esModule, __esExport);
      } else {
        cache[name] = mod;
      }
    }

    return mod.exports;
  }
  require.resolve = function(name) {
    return ""
  }

  var main = require(entry);
  main.require = require;

  if (typeof Proxy !== "undefined") {
    // allow Bokeh.loader["@bokehjs/module/name"] syntax
    main.loader = new Proxy({}, {
      get: function(_obj, module) {
        return require(module);
      }
    });
  }

  main.register_plugin = function(plugin_modules, plugin_entry, plugin_aliases, plugin_externals) {
    if (plugin_aliases === undefined) plugin_aliases = {};
    if (plugin_externals === undefined) plugin_externals = {};

    for (var name in plugin_modules) {
      modules[name] = plugin_modules[name];
    }

    for (var name in plugin_aliases) {
      aliases[name] = plugin_aliases[name];
    }

    for (var name in plugin_externals) {
      externals[name] = plugin_externals[name];
    }

    var plugin = require(plugin_entry);

    for (var name in plugin) {
      main[name] = plugin[name];
    }

    return plugin;
  }

  return main;
})
([
/* legacy.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    require(2) /* ./polyfill */;
    tslib_1.__exportStar(require(116) /* ./main */, exports);
},
/* tslib/tslib.es6.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) {
                for (var p in b)
                    if (Object.prototype.hasOwnProperty.call(b, p))
                        d[p] = b[p];
            };
        return extendStatics(d, b);
    };
    function __extends(d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }
    exports.__extends = __extends;
    var __assign = function () {
        exports.__assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return exports.__assign.apply(this, arguments);
    };
    exports.__assign = __assign;
    function __rest(s, e) {
        var t = {};
        for (var p in s)
            if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
                t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
                if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                    t[p[i]] = s[p[i]];
            }
        return t;
    }
    exports.__rest = __rest;
    function __decorate(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }
    exports.__decorate = __decorate;
    function __param(paramIndex, decorator) {
        return function (target, key) { decorator(target, key, paramIndex); };
    }
    exports.__param = __param;
    function __metadata(metadataKey, metadataValue) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(metadataKey, metadataValue);
    }
    exports.__metadata = __metadata;
    function __awaiter(thisArg, _arguments, P, generator) {
        function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) {
                try {
                    step(generator.next(value));
                }
                catch (e) {
                    reject(e);
                }
            }
            function rejected(value) {
                try {
                    step(generator["throw"](value));
                }
                catch (e) {
                    reject(e);
                }
            }
            function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
    }
    exports.__awaiter = __awaiter;
    function __generator(thisArg, body) {
        var _ = { label: 0, sent: function () {
                if (t[0] & 1)
                    throw t[1];
                return t[1];
            }, trys: [], ops: [] }, f, y, t, g;
        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function () { return this; }), g;
        function verb(n) { return function (v) { return step([n, v]); }; }
        function step(op) {
            if (f)
                throw new TypeError("Generator is already executing.");
            while (_)
                try {
                    if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
                        return t;
                    if (y = 0, t)
                        op = [op[0] & 2, t.value];
                    switch (op[0]) {
                        case 0:
                        case 1:
                            t = op;
                            break;
                        case 4:
                            _.label++;
                            return { value: op[1], done: false };
                        case 5:
                            _.label++;
                            y = op[1];
                            op = [0];
                            continue;
                        case 7:
                            op = _.ops.pop();
                            _.trys.pop();
                            continue;
                        default:
                            if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                                _ = 0;
                                continue;
                            }
                            if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) {
                                _.label = op[1];
                                break;
                            }
                            if (op[0] === 6 && _.label < t[1]) {
                                _.label = t[1];
                                t = op;
                                break;
                            }
                            if (t && _.label < t[2]) {
                                _.label = t[2];
                                _.ops.push(op);
                                break;
                            }
                            if (t[2])
                                _.ops.pop();
                            _.trys.pop();
                            continue;
                    }
                    op = body.call(thisArg, _);
                }
                catch (e) {
                    op = [6, e];
                    y = 0;
                }
                finally {
                    f = t = 0;
                }
            if (op[0] & 5)
                throw op[1];
            return { value: op[0] ? op[1] : void 0, done: true };
        }
    }
    exports.__generator = __generator;
    exports.__createBinding = Object.create ? (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        Object.defineProperty(o, k2, { enumerable: true, get: function () { return m[k]; } });
    }) : (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        o[k2] = m[k];
    });
    function __exportStar(m, o) {
        for (var p in m)
            if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p))
                exports.__createBinding(o, m, p);
    }
    exports.__exportStar = __exportStar;
    function __values(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    }
    exports.__values = __values;
    function __read(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    }
    exports.__read = __read;
    function __spread() {
        for (var ar = [], i = 0; i < arguments.length; i++)
            ar = ar.concat(__read(arguments[i]));
        return ar;
    }
    exports.__spread = __spread;
    function __spreadArrays() {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++)
            s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
            for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                r[k] = a[j];
        return r;
    }
    exports.__spreadArrays = __spreadArrays;
    ;
    function __await(v) {
        return this instanceof __await ? (this.v = v, this) : new __await(v);
    }
    exports.__await = __await;
    function __asyncGenerator(thisArg, _arguments, generator) {
        if (!Symbol.asyncIterator)
            throw new TypeError("Symbol.asyncIterator is not defined.");
        var g = generator.apply(thisArg, _arguments || []), i, q = [];
        return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
        function verb(n) {
            if (g[n])
                i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); };
        }
        function resume(n, v) {
            try {
                step(g[n](v));
            }
            catch (e) {
                settle(q[0][3], e);
            }
        }
        function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
        function fulfill(value) { resume("next", value); }
        function reject(value) { resume("throw", value); }
        function settle(f, v) {
            if (f(v), q.shift(), q.length)
                resume(q[0][0], q[0][1]);
        }
    }
    exports.__asyncGenerator = __asyncGenerator;
    function __asyncDelegator(o) {
        var i, p;
        return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
        function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
    }
    exports.__asyncDelegator = __asyncDelegator;
    function __asyncValues(o) {
        if (!Symbol.asyncIterator)
            throw new TypeError("Symbol.asyncIterator is not defined.");
        var m = o[Symbol.asyncIterator], i;
        return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
        function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
        function settle(resolve, reject, d, v) { Promise.resolve(v).then(function (v) { resolve({ value: v, done: d }); }, reject); }
    }
    exports.__asyncValues = __asyncValues;
    function __makeTemplateObject(cooked, raw) {
        if (Object.defineProperty) {
            Object.defineProperty(cooked, "raw", { value: raw });
        }
        else {
            cooked.raw = raw;
        }
        return cooked;
    }
    exports.__makeTemplateObject = __makeTemplateObject;
    ;
    var __setModuleDefault = Object.create ? (function (o, v) {
        Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function (o, v) {
        o["default"] = v;
    };
    function __importStar(mod) {
        if (mod && mod.__esModule)
            return mod;
        var result = {};
        if (mod != null)
            for (var k in mod)
                if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
                    exports.__createBinding(result, mod, k);
        __setModuleDefault(result, mod);
        return result;
    }
    exports.__importStar = __importStar;
    function __importDefault(mod) {
        return (mod && mod.__esModule) ? mod : { default: mod };
    }
    exports.__importDefault = __importDefault;
    function __classPrivateFieldGet(receiver, privateMap) {
        if (!privateMap.has(receiver)) {
            throw new TypeError("attempted to get private field on non-instance");
        }
        return privateMap.get(receiver);
    }
    exports.__classPrivateFieldGet = __classPrivateFieldGet;
    function __classPrivateFieldSet(receiver, privateMap, value) {
        if (!privateMap.has(receiver)) {
            throw new TypeError("attempted to set private field on non-instance");
        }
        privateMap.set(receiver, value);
        return value;
    }
    exports.__classPrivateFieldSet = __classPrivateFieldSet;
},
/* polyfill.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    require(3) /* es5-ext/object/assign/implement */;
    require(12) /* es5-ext/object/entries/implement */;
    require(15) /* es5-ext/number/is-integer/implement */;
    require(18) /* es5-ext/string/#/repeat/implement */;
    require(25) /* es5-ext/array/from/implement */;
    require(55) /* es5-ext/array/#/fill/implement */;
    require(58) /* es5-ext/math/log10/implement */;
    require(61) /* es5-ext/math/log1p/implement */;
    require(64) /* es6-set/implement */;
    require(100) /* es6-map/implement */;
    require(107) /* es6-weak-map/implement */;
    require(113) /* es6-symbol/implement */;
    require(114) /* es6-promise/auto */;
    if (typeof Object.is === "undefined") {
        Object.is = function (a, b) {
            if (a === b)
                return a !== 0 || 1 / a === 1 / b;
            else
                return a !== a && b !== b;
        };
    }
    if (typeof Object.values === "undefined") {
        Object.values = function (obj) {
            return Object.keys(obj).map(function (key) { return obj[key]; });
        };
    }
    if (typeof String.prototype.includes === "undefined") {
        String.prototype.includes = function (search, start) {
            if (start === void 0) {
                start = 0;
            }
            return this.indexOf(search, start) != -1;
        };
    }
    if (typeof Uint8Array.prototype.fill === "undefined") {
        var fill = Array.prototype.fill;
        Uint8Array.prototype.fill = fill;
        Int8Array.prototype.fill = fill;
        Uint16Array.prototype.fill = fill;
        Int16Array.prototype.fill = fill;
        Uint32Array.prototype.fill = fill;
        Int32Array.prototype.fill = fill;
        Float32Array.prototype.fill = fill;
        Float64Array.prototype.fill = fill;
    }
    if (typeof Array.prototype[Symbol.iterator] === "undefined") {
        function iterator() {
            var i = 0;
            var self = this;
            return {
                next: function () {
                    var done = self.length <= i;
                    var value = done ? undefined : self[i++];
                    return { value: value, done: done };
                },
            };
        }
        (function () {
            arguments.constructor.prototype[Symbol.iterator] = iterator;
            Array.prototype[Symbol.iterator] = iterator;
            Uint8Array.prototype[Symbol.iterator] = iterator;
            Int8Array.prototype[Symbol.iterator] = iterator;
            Uint16Array.prototype[Symbol.iterator] = iterator;
            Int16Array.prototype[Symbol.iterator] = iterator;
            Uint32Array.prototype[Symbol.iterator] = iterator;
            Int32Array.prototype[Symbol.iterator] = iterator;
            Float32Array.prototype[Symbol.iterator] = iterator;
            Float64Array.prototype[Symbol.iterator] = iterator;
        })();
    }
    // fixes up a problem with some versions of IE11
    // ref: http://stackoverflow.com/questions/22062313/imagedata-set-in-internetexplorer
    if (typeof CanvasPixelArray !== "undefined") {
        CanvasPixelArray.prototype.set = function (arr) {
            for (var i = 0; i < this.length; i++) {
                this[i] = arr[i];
            }
        };
    }
},
/* es5-ext/object/assign/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(4) /* ./is-implemented */()) {
        Object.defineProperty(Object, "assign", {
            value: require(5) /* ./shim */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es5-ext/object/assign/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        var assign = Object.assign, obj;
        if (typeof assign !== "function")
            return false;
        obj = { foo: "raz" };
        assign(obj, { bar: "dwa" }, { trzy: "trzy" });
        return obj.foo + obj.bar + obj.trzy === "razdwatrzy";
    };
},
/* es5-ext/object/assign/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    var keys = require(6) /* ../keys */, value = require(11) /* ../valid-value */, max = Math.max;
    module.exports = function (dest, src /*, …srcn*/) {
        var error, i, length = max(arguments.length, 2), assign;
        dest = Object(value(dest));
        assign = function (key) {
            try {
                dest[key] = src[key];
            }
            catch (e) {
                if (!error)
                    error = e;
            }
        };
        for (i = 1; i < length; ++i) {
            src = arguments[i];
            keys(src).forEach(assign);
        }
        if (error !== undefined)
            throw error;
        return dest;
    };
},
/* es5-ext/object/keys/index.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(7) /* ./is-implemented */() ? Object.keys : require(8) /* ./shim */;
},
/* es5-ext/object/keys/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        try {
            Object.keys("primitive");
            return true;
        }
        catch (e) {
            return false;
        }
    };
},
/* es5-ext/object/keys/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    var isValue = require(9) /* ../is-value */;
    var keys = Object.keys;
    module.exports = function (object) { return keys(isValue(object) ? Object(object) : object); };
},
/* es5-ext/object/is-value.js */ function _(require, module, exports, __esModule, __esExport) {
    var _undefined = require(10) /* ../function/noop */(); // Support ES3 engines
    module.exports = function (val) { return val !== _undefined && val !== null; };
},
/* es5-ext/function/noop.js */ function _(require, module, exports, __esModule, __esExport) {
    // eslint-disable-next-line no-empty-function
    module.exports = function () { };
},
/* es5-ext/object/valid-value.js */ function _(require, module, exports, __esModule, __esExport) {
    var isValue = require(9) /* ./is-value */;
    module.exports = function (value) {
        if (!isValue(value))
            throw new TypeError("Cannot use null or undefined");
        return value;
    };
},
/* es5-ext/object/entries/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(13) /* ./is-implemented */()) {
        Object.defineProperty(Object, "entries", {
            value: require(14) /* ./shim */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es5-ext/object/entries/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        try {
            return Object.entries({ foo: 12 })[0][0] === "foo";
        }
        catch (e) {
            return false;
        }
    };
},
/* es5-ext/object/entries/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    var ensureValue = require(11) /* ../valid-value */;
    module.exports = function (object) {
        ensureValue(object);
        var result = [];
        object = Object(object);
        for (var key in object) {
            if (!propertyIsEnumerable.call(object, key))
                continue;
            result.push([key, object[key]]);
        }
        return result;
    };
},
/* es5-ext/number/is-integer/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(16) /* ./is-implemented */()) {
        Object.defineProperty(Number, "isInteger", {
            value: require(17) /* ./shim */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es5-ext/number/is-integer/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        var isInteger = Number.isInteger;
        if (typeof isInteger !== "function")
            return false;
        return !isInteger("23") && isInteger(34) && !isInteger(32.34);
    };
},
/* es5-ext/number/is-integer/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function (value) {
        if (typeof value !== "number")
            return false;
        return value % 1 === 0;
    };
},
/* es5-ext/string/#/repeat/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(19) /* ./is-implemented */()) {
        Object.defineProperty(String.prototype, "repeat", {
            value: require(20) /* ./shim */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es5-ext/string/#/repeat/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    var str = "foo";
    module.exports = function () {
        if (typeof str.repeat !== "function")
            return false;
        return str.repeat(2) === "foofoo";
    };
},
/* es5-ext/string/#/repeat/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    var value = require(11) /* ../../../object/valid-value */, toInteger = require(21) /* ../../../number/to-integer */;
    module.exports = function (count) {
        var str = String(value(this)), result;
        count = toInteger(count);
        if (count < 0)
            throw new RangeError("Count must be >= 0");
        if (!isFinite(count))
            throw new RangeError("Count must be < ∞");
        result = "";
        while (count) {
            if (count % 2)
                result += str;
            if (count > 1)
                str += str;
            // eslint-disable-next-line no-bitwise
            count >>= 1;
        }
        return result;
    };
},
/* es5-ext/number/to-integer.js */ function _(require, module, exports, __esModule, __esExport) {
    var sign = require(22) /* ../math/sign */, abs = Math.abs, floor = Math.floor;
    module.exports = function (value) {
        if (isNaN(value))
            return 0;
        value = Number(value);
        if (value === 0 || !isFinite(value))
            return value;
        return sign(value) * floor(abs(value));
    };
},
/* es5-ext/math/sign/index.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(23) /* ./is-implemented */() ? Math.sign : require(24) /* ./shim */;
},
/* es5-ext/math/sign/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        var sign = Math.sign;
        if (typeof sign !== "function")
            return false;
        return sign(10) === 1 && sign(-20) === -1;
    };
},
/* es5-ext/math/sign/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function (value) {
        value = Number(value);
        if (isNaN(value) || value === 0)
            return value;
        return value > 0 ? 1 : -1;
    };
},
/* es5-ext/array/from/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(26) /* ./is-implemented */()) {
        Object.defineProperty(Array, "from", {
            value: require(27) /* ./shim */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es5-ext/array/from/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        var from = Array.from, arr, result;
        if (typeof from !== "function")
            return false;
        arr = ["raz", "dwa"];
        result = from(arr);
        return Boolean(result && result !== arr && result[1] === "dwa");
    };
},
/* es5-ext/array/from/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    var iteratorSymbol = require(28) /* es6-symbol */.iterator, isArguments = require(50) /* ../../function/is-arguments */, isFunction = require(51) /* ../../function/is-function */, toPosInt = require(52) /* ../../number/to-pos-integer */, callable = require(53) /* ../../object/valid-callable */, validValue = require(11) /* ../../object/valid-value */, isValue = require(9) /* ../../object/is-value */, isString = require(54) /* ../../string/is-string */, isArray = Array.isArray, call = Function.prototype.call, desc = { configurable: true, enumerable: true, writable: true, value: null }, defineProperty = Object.defineProperty;
    // eslint-disable-next-line complexity, max-lines-per-function
    module.exports = function (arrayLike /*, mapFn, thisArg*/) {
        var mapFn = arguments[1], thisArg = arguments[2], Context, i, j, arr, length, code, iterator, result, getIterator, value;
        arrayLike = Object(validValue(arrayLike));
        if (isValue(mapFn))
            callable(mapFn);
        if (!this || this === Array || !isFunction(this)) {
            // Result: Plain array
            if (!mapFn) {
                if (isArguments(arrayLike)) {
                    // Source: Arguments
                    length = arrayLike.length;
                    if (length !== 1)
                        return Array.apply(null, arrayLike);
                    arr = new Array(1);
                    arr[0] = arrayLike[0];
                    return arr;
                }
                if (isArray(arrayLike)) {
                    // Source: Array
                    arr = new Array((length = arrayLike.length));
                    for (i = 0; i < length; ++i)
                        arr[i] = arrayLike[i];
                    return arr;
                }
            }
            arr = [];
        }
        else {
            // Result: Non plain array
            Context = this;
        }
        if (!isArray(arrayLike)) {
            if ((getIterator = arrayLike[iteratorSymbol]) !== undefined) {
                // Source: Iterator
                iterator = callable(getIterator).call(arrayLike);
                if (Context)
                    arr = new Context();
                result = iterator.next();
                i = 0;
                while (!result.done) {
                    value = mapFn ? call.call(mapFn, thisArg, result.value, i) : result.value;
                    if (Context) {
                        desc.value = value;
                        defineProperty(arr, i, desc);
                    }
                    else {
                        arr[i] = value;
                    }
                    result = iterator.next();
                    ++i;
                }
                length = i;
            }
            else if (isString(arrayLike)) {
                // Source: String
                length = arrayLike.length;
                if (Context)
                    arr = new Context();
                for (i = 0, j = 0; i < length; ++i) {
                    value = arrayLike[i];
                    if (i + 1 < length) {
                        code = value.charCodeAt(0);
                        // eslint-disable-next-line max-depth
                        if (code >= 0xd800 && code <= 0xdbff)
                            value += arrayLike[++i];
                    }
                    value = mapFn ? call.call(mapFn, thisArg, value, j) : value;
                    if (Context) {
                        desc.value = value;
                        defineProperty(arr, j, desc);
                    }
                    else {
                        arr[j] = value;
                    }
                    ++j;
                }
                length = j;
            }
        }
        if (length === undefined) {
            // Source: array or array-like
            length = toPosInt(arrayLike.length);
            if (Context)
                arr = new Context(length);
            for (i = 0; i < length; ++i) {
                value = mapFn ? call.call(mapFn, thisArg, arrayLike[i], i) : arrayLike[i];
                if (Context) {
                    desc.value = value;
                    defineProperty(arr, i, desc);
                }
                else {
                    arr[i] = value;
                }
            }
        }
        if (Context) {
            desc.value = null;
            arr.length = length;
        }
        return arr;
    };
},
/* es6-symbol/index.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(29) /* ./is-implemented */()
        ? require(30) /* ext/global-this */.Symbol
        : require(33) /* ./polyfill */;
},
/* es6-symbol/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    var global = require(30) /* ext/global-this */, validTypes = { object: true, symbol: true };
    module.exports = function () {
        var Symbol = global.Symbol;
        var symbol;
        if (typeof Symbol !== "function")
            return false;
        symbol = Symbol("test symbol");
        try {
            String(symbol);
        }
        catch (e) {
            return false;
        }
        // Return 'true' also for polyfills
        if (!validTypes[typeof Symbol.iterator])
            return false;
        if (!validTypes[typeof Symbol.toPrimitive])
            return false;
        if (!validTypes[typeof Symbol.toStringTag])
            return false;
        return true;
    };
},
/* ext/global-this/index.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(31) /* ./is-implemented */() ? globalThis : require(32) /* ./implementation */;
},
/* ext/global-this/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        if (typeof globalThis !== "object")
            return false;
        if (!globalThis)
            return false;
        return globalThis.Array === Array;
    };
},
/* ext/global-this/implementation.js */ function _(require, module, exports, __esModule, __esExport) {
    var naiveFallback = function () {
        if (typeof self === "object" && self)
            return self;
        if (typeof window === "object" && window)
            return window;
        throw new Error("Unable to resolve global `this`");
    };
    module.exports = (function () {
        if (this)
            return this;
        // Unexpected strict mode (may happen if e.g. bundled into ESM module)
        // Thanks @mathiasbynens -> https://mathiasbynens.be/notes/globalthis
        // In all ES5+ engines global object inherits from Object.prototype
        // (if you approached one that doesn't please report)
        try {
            Object.defineProperty(Object.prototype, "__global__", {
                get: function () { return this; },
                configurable: true
            });
        }
        catch (error) {
            // Unfortunate case of Object.prototype being sealed (via preventExtensions, seal or freeze)
            return naiveFallback();
        }
        try {
            // Safari case (window.__global__ is resolved with global context, but __global__ does not)
            if (!__global__)
                return naiveFallback();
            return __global__;
        }
        finally {
            delete Object.prototype.__global__;
        }
    })();
},
/* es6-symbol/polyfill.js */ function _(require, module, exports, __esModule, __esExport) {
    var d = require(34) /* d */, validateSymbol = require(45) /* ./validate-symbol */, NativeSymbol = require(30) /* ext/global-this */.Symbol, generateName = require(47) /* ./lib/private/generate-name */, setupStandardSymbols = require(48) /* ./lib/private/setup/standard-symbols */, setupSymbolRegistry = require(49) /* ./lib/private/setup/symbol-registry */;
    var create = Object.create, defineProperties = Object.defineProperties, defineProperty = Object.defineProperty;
    var SymbolPolyfill, HiddenSymbol, isNativeSafe;
    if (typeof NativeSymbol === "function") {
        try {
            String(NativeSymbol());
            isNativeSafe = true;
        }
        catch (ignore) { }
    }
    else {
        NativeSymbol = null;
    }
    // Internal constructor (not one exposed) for creating Symbol instances.
    // This one is used to ensure that `someSymbol instanceof Symbol` always return false
    HiddenSymbol = function Symbol(description) {
        if (this instanceof HiddenSymbol)
            throw new TypeError("Symbol is not a constructor");
        return SymbolPolyfill(description);
    };
    // Exposed `Symbol` constructor
    // (returns instances of HiddenSymbol)
    module.exports = SymbolPolyfill = function Symbol(description) {
        var symbol;
        if (this instanceof Symbol)
            throw new TypeError("Symbol is not a constructor");
        if (isNativeSafe)
            return NativeSymbol(description);
        symbol = create(HiddenSymbol.prototype);
        description = description === undefined ? "" : String(description);
        return defineProperties(symbol, {
            __description__: d("", description),
            __name__: d("", generateName(description))
        });
    };
    setupStandardSymbols(SymbolPolyfill);
    setupSymbolRegistry(SymbolPolyfill);
    // Internal tweaks for real symbol producer
    defineProperties(HiddenSymbol.prototype, {
        constructor: d(SymbolPolyfill),
        toString: d("", function () { return this.__name__; })
    });
    // Proper implementation of methods exposed on Symbol.prototype
    // They won't be accessible on produced symbol instances as they derive from HiddenSymbol.prototype
    defineProperties(SymbolPolyfill.prototype, {
        toString: d(function () { return "Symbol (" + validateSymbol(this).__description__ + ")"; }),
        valueOf: d(function () { return validateSymbol(this); })
    });
    defineProperty(SymbolPolyfill.prototype, SymbolPolyfill.toPrimitive, d("", function () {
        var symbol = validateSymbol(this);
        if (typeof symbol === "symbol")
            return symbol;
        return symbol.toString();
    }));
    defineProperty(SymbolPolyfill.prototype, SymbolPolyfill.toStringTag, d("c", "Symbol"));
    // Proper implementaton of toPrimitive and toStringTag for returned symbol instances
    defineProperty(HiddenSymbol.prototype, SymbolPolyfill.toStringTag, d("c", SymbolPolyfill.prototype[SymbolPolyfill.toStringTag]));
    // Note: It's important to define `toPrimitive` as last one, as some implementations
    // implement `toPrimitive` natively without implementing `toStringTag` (or other specified symbols)
    // And that may invoke error in definition flow:
    // See: https://github.com/medikoo/es6-symbol/issues/13#issuecomment-164146149
    defineProperty(HiddenSymbol.prototype, SymbolPolyfill.toPrimitive, d("c", SymbolPolyfill.prototype[SymbolPolyfill.toPrimitive]));
},
/* d/index.js */ function _(require, module, exports, __esModule, __esExport) {
    var isValue = require(35) /* type/value/is */, isPlainFunction = require(36) /* type/plain-function/is */, assign = require(40) /* es5-ext/object/assign */, normalizeOpts = require(41) /* es5-ext/object/normalize-options */, contains = require(42) /* es5-ext/string/#/contains */;
    var d = (module.exports = function (dscr, value /*, options*/) {
        var c, e, w, options, desc;
        if (arguments.length < 2 || typeof dscr !== "string") {
            options = value;
            value = dscr;
            dscr = null;
        }
        else {
            options = arguments[2];
        }
        if (isValue(dscr)) {
            c = contains.call(dscr, "c");
            e = contains.call(dscr, "e");
            w = contains.call(dscr, "w");
        }
        else {
            c = w = true;
            e = false;
        }
        desc = { value: value, configurable: c, enumerable: e, writable: w };
        return !options ? desc : assign(normalizeOpts(options), desc);
    });
    d.gs = function (dscr, get, set /*, options*/) {
        var c, e, options, desc;
        if (typeof dscr !== "string") {
            options = set;
            set = get;
            get = dscr;
            dscr = null;
        }
        else {
            options = arguments[3];
        }
        if (!isValue(get)) {
            get = undefined;
        }
        else if (!isPlainFunction(get)) {
            options = get;
            get = set = undefined;
        }
        else if (!isValue(set)) {
            set = undefined;
        }
        else if (!isPlainFunction(set)) {
            options = set;
            set = undefined;
        }
        if (isValue(dscr)) {
            c = contains.call(dscr, "c");
            e = contains.call(dscr, "e");
        }
        else {
            c = true;
            e = false;
        }
        desc = { get: get, set: set, configurable: c, enumerable: e };
        return !options ? desc : assign(normalizeOpts(options), desc);
    };
},
/* type/value/is.js */ function _(require, module, exports, __esModule, __esExport) {
    // ES3 safe
    var _undefined = void 0;
    module.exports = function (value) { return value !== _undefined && value !== null; };
},
/* type/plain-function/is.js */ function _(require, module, exports, __esModule, __esExport) {
    var isFunction = require(37) /* ../function/is */;
    var classRe = /^\s*class[\s{/}]/, functionToString = Function.prototype.toString;
    module.exports = function (value) {
        if (!isFunction(value))
            return false;
        if (classRe.test(functionToString.call(value)))
            return false;
        return true;
    };
},
/* type/function/is.js */ function _(require, module, exports, __esModule, __esExport) {
    var isPrototype = require(38) /* ../prototype/is */;
    module.exports = function (value) {
        if (typeof value !== "function")
            return false;
        if (!hasOwnProperty.call(value, "length"))
            return false;
        try {
            if (typeof value.length !== "number")
                return false;
            if (typeof value.call !== "function")
                return false;
            if (typeof value.apply !== "function")
                return false;
        }
        catch (error) {
            return false;
        }
        return !isPrototype(value);
    };
},
/* type/prototype/is.js */ function _(require, module, exports, __esModule, __esExport) {
    var isObject = require(39) /* ../object/is */;
    module.exports = function (value) {
        if (!isObject(value))
            return false;
        try {
            if (!value.constructor)
                return false;
            return value.constructor.prototype === value;
        }
        catch (error) {
            return false;
        }
    };
},
/* type/object/is.js */ function _(require, module, exports, __esModule, __esExport) {
    var isValue = require(35) /* ../value/is */;
    // prettier-ignore
    var possibleTypes = { "object": true, "function": true, "undefined": true /* document.all */ };
    module.exports = function (value) {
        if (!isValue(value))
            return false;
        return hasOwnProperty.call(possibleTypes, typeof value);
    };
},
/* es5-ext/object/assign/index.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(4) /* ./is-implemented */() ? Object.assign : require(5) /* ./shim */;
},
/* es5-ext/object/normalize-options.js */ function _(require, module, exports, __esModule, __esExport) {
    var isValue = require(9) /* ./is-value */;
    var forEach = Array.prototype.forEach, create = Object.create;
    var process = function (src, obj) {
        var key;
        for (key in src)
            obj[key] = src[key];
    };
    // eslint-disable-next-line no-unused-vars
    module.exports = function (opts1 /*, …options*/) {
        var result = create(null);
        forEach.call(arguments, function (options) {
            if (!isValue(options))
                return;
            process(Object(options), result);
        });
        return result;
    };
},
/* es5-ext/string/#/contains/index.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(43) /* ./is-implemented */() ? String.prototype.contains : require(44) /* ./shim */;
},
/* es5-ext/string/#/contains/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    var str = "razdwatrzy";
    module.exports = function () {
        if (typeof str.contains !== "function")
            return false;
        return str.contains("dwa") === true && str.contains("foo") === false;
    };
},
/* es5-ext/string/#/contains/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    var indexOf = String.prototype.indexOf;
    module.exports = function (searchString /*, position*/) {
        return indexOf.call(this, searchString, arguments[1]) > -1;
    };
},
/* es6-symbol/validate-symbol.js */ function _(require, module, exports, __esModule, __esExport) {
    var isSymbol = require(46) /* ./is-symbol */;
    module.exports = function (value) {
        if (!isSymbol(value))
            throw new TypeError(value + " is not a symbol");
        return value;
    };
},
/* es6-symbol/is-symbol.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function (value) {
        if (!value)
            return false;
        if (typeof value === "symbol")
            return true;
        if (!value.constructor)
            return false;
        if (value.constructor.name !== "Symbol")
            return false;
        return value[value.constructor.toStringTag] === "Symbol";
    };
},
/* es6-symbol/lib/private/generate-name.js */ function _(require, module, exports, __esModule, __esExport) {
    var d = require(34) /* d */;
    var create = Object.create, defineProperty = Object.defineProperty, objPrototype = Object.prototype;
    var created = create(null);
    module.exports = function (desc) {
        var postfix = 0, name, ie11BugWorkaround;
        while (created[desc + (postfix || "")])
            ++postfix;
        desc += postfix || "";
        created[desc] = true;
        name = "@@" + desc;
        defineProperty(objPrototype, name, d.gs(null, function (value) {
            // For IE11 issue see:
            // https://connect.microsoft.com/IE/feedbackdetail/view/1928508/
            //    ie11-broken-getters-on-dom-objects
            // https://github.com/medikoo/es6-symbol/issues/12
            if (ie11BugWorkaround)
                return;
            ie11BugWorkaround = true;
            defineProperty(this, name, d(value));
            ie11BugWorkaround = false;
        }));
        return name;
    };
},
/* es6-symbol/lib/private/setup/standard-symbols.js */ function _(require, module, exports, __esModule, __esExport) {
    var d = require(34) /* d */, NativeSymbol = require(30) /* ext/global-this */.Symbol;
    module.exports = function (SymbolPolyfill) {
        return Object.defineProperties(SymbolPolyfill, {
            // To ensure proper interoperability with other native functions (e.g. Array.from)
            // fallback to eventual native implementation of given symbol
            hasInstance: d("", (NativeSymbol && NativeSymbol.hasInstance) || SymbolPolyfill("hasInstance")),
            isConcatSpreadable: d("", (NativeSymbol && NativeSymbol.isConcatSpreadable) ||
                SymbolPolyfill("isConcatSpreadable")),
            iterator: d("", (NativeSymbol && NativeSymbol.iterator) || SymbolPolyfill("iterator")),
            match: d("", (NativeSymbol && NativeSymbol.match) || SymbolPolyfill("match")),
            replace: d("", (NativeSymbol && NativeSymbol.replace) || SymbolPolyfill("replace")),
            search: d("", (NativeSymbol && NativeSymbol.search) || SymbolPolyfill("search")),
            species: d("", (NativeSymbol && NativeSymbol.species) || SymbolPolyfill("species")),
            split: d("", (NativeSymbol && NativeSymbol.split) || SymbolPolyfill("split")),
            toPrimitive: d("", (NativeSymbol && NativeSymbol.toPrimitive) || SymbolPolyfill("toPrimitive")),
            toStringTag: d("", (NativeSymbol && NativeSymbol.toStringTag) || SymbolPolyfill("toStringTag")),
            unscopables: d("", (NativeSymbol && NativeSymbol.unscopables) || SymbolPolyfill("unscopables"))
        });
    };
},
/* es6-symbol/lib/private/setup/symbol-registry.js */ function _(require, module, exports, __esModule, __esExport) {
    var d = require(34) /* d */, validateSymbol = require(45) /* ../../../validate-symbol */;
    var registry = Object.create(null);
    module.exports = function (SymbolPolyfill) {
        return Object.defineProperties(SymbolPolyfill, {
            for: d(function (key) {
                if (registry[key])
                    return registry[key];
                return (registry[key] = SymbolPolyfill(String(key)));
            }),
            keyFor: d(function (symbol) {
                var key;
                validateSymbol(symbol);
                for (key in registry) {
                    if (registry[key] === symbol)
                        return key;
                }
                return undefined;
            })
        });
    };
},
/* es5-ext/function/is-arguments.js */ function _(require, module, exports, __esModule, __esExport) {
    var objToString = Object.prototype.toString, id = objToString.call((function () { return arguments; })());
    module.exports = function (value) { return objToString.call(value) === id; };
},
/* es5-ext/function/is-function.js */ function _(require, module, exports, __esModule, __esExport) {
    var objToString = Object.prototype.toString, isFunctionStringTag = RegExp.prototype.test.bind(/^[object [A-Za-z0-9]*Function]$/);
    module.exports = function (value) {
        return typeof value === "function" && isFunctionStringTag(objToString.call(value));
    };
},
/* es5-ext/number/to-pos-integer.js */ function _(require, module, exports, __esModule, __esExport) {
    var toInteger = require(21) /* ./to-integer */, max = Math.max;
    module.exports = function (value) { return max(0, toInteger(value)); };
},
/* es5-ext/object/valid-callable.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function (fn) {
        if (typeof fn !== "function")
            throw new TypeError(fn + " is not a function");
        return fn;
    };
},
/* es5-ext/string/is-string.js */ function _(require, module, exports, __esModule, __esExport) {
    var objToString = Object.prototype.toString, id = objToString.call("");
    module.exports = function (value) {
        return (typeof value === "string" ||
            (value &&
                typeof value === "object" &&
                (value instanceof String || objToString.call(value) === id)) ||
            false);
    };
},
/* es5-ext/array/#/fill/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(56) /* ./is-implemented */()) {
        Object.defineProperty(Array.prototype, "fill", {
            value: require(57) /* ./shim */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es5-ext/array/#/fill/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        var arr = [1, 2, 3, 4, 5, 6];
        if (typeof arr.fill !== "function")
            return false;
        return String(arr.fill(-1, -3)) === "1,2,3,-1,-1,-1";
    };
},
/* es5-ext/array/#/fill/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    var toInteger = require(21) /* ../../../number/to-integer */, toPosInt = require(52) /* ../../../number/to-pos-integer */, validValue = require(11) /* ../../../object/valid-value */, max = Math.max, min = Math.min;
    module.exports = function (value /*, start, end*/) {
        var arr = validValue(this), start = arguments[1], end = arguments[2], length = toPosInt(arr.length), relativeStart, i;
        start = start === undefined ? 0 : toInteger(start);
        end = end === undefined ? length : toInteger(end);
        relativeStart = start < 0 ? max(length + start, 0) : min(start, length);
        for (i = relativeStart; i < length && i < end; ++i)
            arr[i] = value;
        return arr;
    };
},
/* es5-ext/math/log10/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(59) /* ./is-implemented */()) {
        Object.defineProperty(Math, "log10", {
            value: require(60) /* ./shim */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es5-ext/math/log10/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        var log10 = Math.log10;
        if (typeof log10 !== "function")
            return false;
        return log10(2) === 0.3010299956639812;
    };
},
/* es5-ext/math/log10/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    var log = Math.log, LOG10E = Math.LOG10E;
    module.exports = function (value) {
        if (isNaN(value))
            return NaN;
        value = Number(value);
        if (value < 0)
            return NaN;
        if (value === 0)
            return -Infinity;
        if (value === 1)
            return 0;
        if (value === Infinity)
            return Infinity;
        return log(value) * LOG10E;
    };
},
/* es5-ext/math/log1p/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(62) /* ./is-implemented */()) {
        Object.defineProperty(Math, "log1p", {
            value: require(63) /* ./shim */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es5-ext/math/log1p/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        var log1p = Math.log1p;
        if (typeof log1p !== "function")
            return false;
        return log1p(1) === 0.6931471805599453;
    };
},
/* es5-ext/math/log1p/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    var log = Math.log;
    module.exports = function (value) {
        if (isNaN(value))
            return NaN;
        value = Number(value);
        if (value < -1)
            return NaN;
        if (value === -1)
            return -Infinity;
        if (value === 0)
            return value;
        if (value === Infinity)
            return Infinity;
        if (value > -1.0e-8 && value < 1.0e-8)
            return value - (value * value) / 2;
        return log(1 + value);
    };
},
/* es6-set/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(65) /* ./is-implemented */()) {
        Object.defineProperty(require(66) /* es5-ext/global */, 'Set', { value: require(67) /* ./polyfill */, configurable: true, enumerable: false,
            writable: true });
    }
},
/* es6-set/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        var set, iterator, result;
        if (typeof Set !== 'function')
            return false;
        set = new Set(['raz', 'dwa', 'trzy']);
        if (String(set) !== '[object Set]')
            return false;
        if (set.size !== 3)
            return false;
        if (typeof set.add !== 'function')
            return false;
        if (typeof set.clear !== 'function')
            return false;
        if (typeof set.delete !== 'function')
            return false;
        if (typeof set.entries !== 'function')
            return false;
        if (typeof set.forEach !== 'function')
            return false;
        if (typeof set.has !== 'function')
            return false;
        if (typeof set.keys !== 'function')
            return false;
        if (typeof set.values !== 'function')
            return false;
        iterator = set.values();
        result = iterator.next();
        if (result.done !== false)
            return false;
        if (result.value !== 'raz')
            return false;
        return true;
    };
},
/* es5-ext/global.js */ function _(require, module, exports, __esModule, __esExport) {
    var naiveFallback = function () {
        if (typeof self === "object" && self)
            return self;
        if (typeof window === "object" && window)
            return window;
        throw new Error("Unable to resolve global `this`");
    };
    module.exports = (function () {
        if (this)
            return this;
        // Unexpected strict mode (may happen if e.g. bundled into ESM module)
        // Fallback to standard globalThis if available
        if (typeof globalThis === "object" && globalThis)
            return globalThis;
        // Thanks @mathiasbynens -> https://mathiasbynens.be/notes/globalthis
        // In all ES5+ engines global object inherits from Object.prototype
        // (if you approached one that doesn't please report)
        try {
            Object.defineProperty(Object.prototype, "__global__", {
                get: function () { return this; },
                configurable: true
            });
        }
        catch (error) {
            // Unfortunate case of updates to Object.prototype being restricted
            // via preventExtensions, seal or freeze
            return naiveFallback();
        }
        try {
            // Safari case (window.__global__ works, but __global__ does not)
            if (!__global__)
                return naiveFallback();
            return __global__;
        }
        finally {
            delete Object.prototype.__global__;
        }
    })();
},
/* es6-set/polyfill.js */ function _(require, module, exports, __esModule, __esExport) {
    var clear = require(68) /* es5-ext/array/#/clear */, eIndexOf = require(69) /* es5-ext/array/#/e-index-of */, setPrototypeOf = require(73) /* es5-ext/object/set-prototype-of */, callable = require(53) /* es5-ext/object/valid-callable */, d = require(34) /* d */, ee = require(78) /* event-emitter */, Symbol = require(28) /* es6-symbol */, iterator = require(79) /* es6-iterator/valid-iterable */, forOf = require(81) /* es6-iterator/for-of */, Iterator = require(98) /* ./lib/iterator */, isNative = require(99) /* ./is-native-implemented */, call = Function.prototype.call, defineProperty = Object.defineProperty, getPrototypeOf = Object.getPrototypeOf, SetPoly, getValues, NativeSet;
    if (isNative)
        NativeSet = Set;
    module.exports = SetPoly = function Set( /*iterable*/) {
        var iterable = arguments[0], self;
        if (!(this instanceof SetPoly))
            throw new TypeError('Constructor requires \'new\'');
        if (isNative && setPrototypeOf)
            self = setPrototypeOf(new NativeSet(), getPrototypeOf(this));
        else
            self = this;
        if (iterable != null)
            iterator(iterable);
        defineProperty(self, '__setData__', d('c', []));
        if (!iterable)
            return self;
        forOf(iterable, function (value) {
            if (eIndexOf.call(this, value) !== -1)
                return;
            this.push(value);
        }, self.__setData__);
        return self;
    };
    if (isNative) {
        if (setPrototypeOf)
            setPrototypeOf(SetPoly, NativeSet);
        SetPoly.prototype = Object.create(NativeSet.prototype, { constructor: d(SetPoly) });
    }
    ee(Object.defineProperties(SetPoly.prototype, {
        add: d(function (value) {
            if (this.has(value))
                return this;
            this.emit('_add', this.__setData__.push(value) - 1, value);
            return this;
        }),
        clear: d(function () {
            if (!this.__setData__.length)
                return;
            clear.call(this.__setData__);
            this.emit('_clear');
        }),
        delete: d(function (value) {
            var index = eIndexOf.call(this.__setData__, value);
            if (index === -1)
                return false;
            this.__setData__.splice(index, 1);
            this.emit('_delete', index, value);
            return true;
        }),
        entries: d(function () { return new Iterator(this, 'key+value'); }),
        forEach: d(function (cb /*, thisArg*/) {
            var thisArg = arguments[1], iterator, result, value;
            callable(cb);
            iterator = this.values();
            result = iterator._next();
            while (result !== undefined) {
                value = iterator._resolve(result);
                call.call(cb, thisArg, value, value, this);
                result = iterator._next();
            }
        }),
        has: d(function (value) {
            return (eIndexOf.call(this.__setData__, value) !== -1);
        }),
        keys: d(getValues = function () { return this.values(); }),
        size: d.gs(function () { return this.__setData__.length; }),
        values: d(function () { return new Iterator(this); }),
        toString: d(function () { return '[object Set]'; })
    }));
    defineProperty(SetPoly.prototype, Symbol.iterator, d(getValues));
    defineProperty(SetPoly.prototype, Symbol.toStringTag, d('c', 'Set'));
},
/* es5-ext/array/#/clear.js */ function _(require, module, exports, __esModule, __esExport) {
    var value = require(11) /* ../../object/valid-value */;
    module.exports = function () {
        value(this).length = 0;
        return this;
    };
},
/* es5-ext/array/#/e-index-of.js */ function _(require, module, exports, __esModule, __esExport) {
    var numberIsNaN = require(70) /* ../../number/is-nan */, toPosInt = require(52) /* ../../number/to-pos-integer */, value = require(11) /* ../../object/valid-value */, indexOf = Array.prototype.indexOf, objHasOwnProperty = Object.prototype.hasOwnProperty, abs = Math.abs, floor = Math.floor;
    module.exports = function (searchElement /*, fromIndex*/) {
        var i, length, fromIndex, val;
        if (!numberIsNaN(searchElement))
            return indexOf.apply(this, arguments);
        length = toPosInt(value(this).length);
        fromIndex = arguments[1];
        if (isNaN(fromIndex))
            fromIndex = 0;
        else if (fromIndex >= 0)
            fromIndex = floor(fromIndex);
        else
            fromIndex = toPosInt(this.length) - floor(abs(fromIndex));
        for (i = fromIndex; i < length; ++i) {
            if (objHasOwnProperty.call(this, i)) {
                val = this[i];
                if (numberIsNaN(val))
                    return i; // Jslint: ignore
            }
        }
        return -1;
    };
},
/* es5-ext/number/is-nan/index.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(71) /* ./is-implemented */() ? Number.isNaN : require(72) /* ./shim */;
},
/* es5-ext/number/is-nan/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        var numberIsNaN = Number.isNaN;
        if (typeof numberIsNaN !== "function")
            return false;
        return !numberIsNaN({}) && numberIsNaN(NaN) && !numberIsNaN(34);
    };
},
/* es5-ext/number/is-nan/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function (value) {
        // eslint-disable-next-line no-self-compare
        return value !== value;
    };
},
/* es5-ext/object/set-prototype-of/index.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(74) /* ./is-implemented */() ? Object.setPrototypeOf : require(75) /* ./shim */;
},
/* es5-ext/object/set-prototype-of/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    var create = Object.create, getPrototypeOf = Object.getPrototypeOf, plainObject = {};
    module.exports = function ( /* CustomCreate*/) {
        var setPrototypeOf = Object.setPrototypeOf, customCreate = arguments[0] || create;
        if (typeof setPrototypeOf !== "function")
            return false;
        return getPrototypeOf(setPrototypeOf(customCreate(null), plainObject)) === plainObject;
    };
},
/* es5-ext/object/set-prototype-of/shim.js */ function _(require, module, exports, __esModule, __esExport) {
    var isObject = require(76) /* ../is-object */, value = require(11) /* ../valid-value */, objIsPrototypeOf = Object.prototype.isPrototypeOf, defineProperty = Object.defineProperty, nullDesc = { configurable: true, enumerable: false, writable: true, value: undefined }, validate;
    validate = function (obj, prototype) {
        value(obj);
        if (prototype === null || isObject(prototype))
            return obj;
        throw new TypeError("Prototype must be null or an object");
    };
    module.exports = (function (status) {
        var fn, set;
        if (!status)
            return null;
        if (status.level === 2) {
            if (status.set) {
                set = status.set;
                fn = function (obj, prototype) {
                    set.call(validate(obj, prototype), prototype);
                    return obj;
                };
            }
            else {
                fn = function (obj, prototype) {
                    validate(obj, prototype).__proto__ = prototype;
                    return obj;
                };
            }
        }
        else {
            fn = function self(obj, prototype) {
                var isNullBase;
                validate(obj, prototype);
                isNullBase = objIsPrototypeOf.call(self.nullPolyfill, obj);
                if (isNullBase)
                    delete self.nullPolyfill.__proto__;
                if (prototype === null)
                    prototype = self.nullPolyfill;
                obj.__proto__ = prototype;
                if (isNullBase)
                    defineProperty(self.nullPolyfill, "__proto__", nullDesc);
                return obj;
            };
        }
        return Object.defineProperty(fn, "level", {
            configurable: false,
            enumerable: false,
            writable: false,
            value: status.level
        });
    })((function () {
        var tmpObj1 = Object.create(null), tmpObj2 = {}, set, desc = Object.getOwnPropertyDescriptor(Object.prototype, "__proto__");
        if (desc) {
            try {
                set = desc.set; // Opera crashes at this point
                set.call(tmpObj1, tmpObj2);
            }
            catch (ignore) { }
            if (Object.getPrototypeOf(tmpObj1) === tmpObj2)
                return { set: set, level: 2 };
        }
        tmpObj1.__proto__ = tmpObj2;
        if (Object.getPrototypeOf(tmpObj1) === tmpObj2)
            return { level: 2 };
        tmpObj1 = {};
        tmpObj1.__proto__ = tmpObj2;
        if (Object.getPrototypeOf(tmpObj1) === tmpObj2)
            return { level: 1 };
        return false;
    })());
    require(77) /* ../create */;
},
/* es5-ext/object/is-object.js */ function _(require, module, exports, __esModule, __esExport) {
    var isValue = require(9) /* ./is-value */;
    var map = { function: true, object: true };
    module.exports = function (value) { return (isValue(value) && map[typeof value]) || false; };
},
/* es5-ext/object/create.js */ function _(require, module, exports, __esModule, __esExport) {
    var create = Object.create, shim;
    if (!require(74) /* ./set-prototype-of/is-implemented */()) {
        shim = require(75) /* ./set-prototype-of/shim */;
    }
    module.exports = (function () {
        var nullObject, polyProps, desc;
        if (!shim)
            return create;
        if (shim.level !== 1)
            return create;
        nullObject = {};
        polyProps = {};
        desc = { configurable: false, enumerable: false, writable: true, value: undefined };
        Object.getOwnPropertyNames(Object.prototype).forEach(function (name) {
            if (name === "__proto__") {
                polyProps[name] = {
                    configurable: true,
                    enumerable: false,
                    writable: true,
                    value: undefined
                };
                return;
            }
            polyProps[name] = desc;
        });
        Object.defineProperties(nullObject, polyProps);
        Object.defineProperty(shim, "nullPolyfill", {
            configurable: false,
            enumerable: false,
            writable: false,
            value: nullObject
        });
        return function (prototype, props) {
            return create(prototype === null ? nullObject : prototype, props);
        };
    })();
},
/* event-emitter/index.js */ function _(require, module, exports, __esModule, __esExport) {
    var d = require(34) /* d */, callable = require(53) /* es5-ext/object/valid-callable */, apply = Function.prototype.apply, call = Function.prototype.call, create = Object.create, defineProperty = Object.defineProperty, defineProperties = Object.defineProperties, hasOwnProperty = Object.prototype.hasOwnProperty, descriptor = { configurable: true, enumerable: false, writable: true }, on, once, off, emit, methods, descriptors, base;
    on = function (type, listener) {
        var data;
        callable(listener);
        if (!hasOwnProperty.call(this, '__ee__')) {
            data = descriptor.value = create(null);
            defineProperty(this, '__ee__', descriptor);
            descriptor.value = null;
        }
        else {
            data = this.__ee__;
        }
        if (!data[type])
            data[type] = listener;
        else if (typeof data[type] === 'object')
            data[type].push(listener);
        else
            data[type] = [data[type], listener];
        return this;
    };
    once = function (type, listener) {
        var once, self;
        callable(listener);
        self = this;
        on.call(this, type, once = function () {
            off.call(self, type, once);
            apply.call(listener, this, arguments);
        });
        once.__eeOnceListener__ = listener;
        return this;
    };
    off = function (type, listener) {
        var data, listeners, candidate, i;
        callable(listener);
        if (!hasOwnProperty.call(this, '__ee__'))
            return this;
        data = this.__ee__;
        if (!data[type])
            return this;
        listeners = data[type];
        if (typeof listeners === 'object') {
            for (i = 0; (candidate = listeners[i]); ++i) {
                if ((candidate === listener) ||
                    (candidate.__eeOnceListener__ === listener)) {
                    if (listeners.length === 2)
                        data[type] = listeners[i ? 0 : 1];
                    else
                        listeners.splice(i, 1);
                }
            }
        }
        else {
            if ((listeners === listener) ||
                (listeners.__eeOnceListener__ === listener)) {
                delete data[type];
            }
        }
        return this;
    };
    emit = function (type) {
        var i, l, listener, listeners, args;
        if (!hasOwnProperty.call(this, '__ee__'))
            return;
        listeners = this.__ee__[type];
        if (!listeners)
            return;
        if (typeof listeners === 'object') {
            l = arguments.length;
            args = new Array(l - 1);
            for (i = 1; i < l; ++i)
                args[i - 1] = arguments[i];
            listeners = listeners.slice();
            for (i = 0; (listener = listeners[i]); ++i) {
                apply.call(listener, this, args);
            }
        }
        else {
            switch (arguments.length) {
                case 1:
                    call.call(listeners, this);
                    break;
                case 2:
                    call.call(listeners, this, arguments[1]);
                    break;
                case 3:
                    call.call(listeners, this, arguments[1], arguments[2]);
                    break;
                default:
                    l = arguments.length;
                    args = new Array(l - 1);
                    for (i = 1; i < l; ++i) {
                        args[i - 1] = arguments[i];
                    }
                    apply.call(listeners, this, args);
            }
        }
    };
    methods = {
        on: on,
        once: once,
        off: off,
        emit: emit
    };
    descriptors = {
        on: d(on),
        once: d(once),
        off: d(off),
        emit: d(emit)
    };
    base = defineProperties({}, descriptors);
    module.exports = exports = function (o) {
        return (o == null) ? create(base) : defineProperties(Object(o), descriptors);
    };
    exports.methods = methods;
},
/* es6-iterator/valid-iterable.js */ function _(require, module, exports, __esModule, __esExport) {
    var isIterable = require(80) /* ./is-iterable */;
    module.exports = function (value) {
        if (!isIterable(value))
            throw new TypeError(value + " is not iterable");
        return value;
    };
},
/* es6-iterator/is-iterable.js */ function _(require, module, exports, __esModule, __esExport) {
    var isArguments = require(50) /* es5-ext/function/is-arguments */, isValue = require(9) /* es5-ext/object/is-value */, isString = require(54) /* es5-ext/string/is-string */;
    var iteratorSymbol = require(28) /* es6-symbol */.iterator, isArray = Array.isArray;
    module.exports = function (value) {
        if (!isValue(value))
            return false;
        if (isArray(value))
            return true;
        if (isString(value))
            return true;
        if (isArguments(value))
            return true;
        return typeof value[iteratorSymbol] === "function";
    };
},
/* es6-iterator/for-of.js */ function _(require, module, exports, __esModule, __esExport) {
    var isArguments = require(50) /* es5-ext/function/is-arguments */, callable = require(53) /* es5-ext/object/valid-callable */, isString = require(54) /* es5-ext/string/is-string */, get = require(82) /* ./get */;
    var isArray = Array.isArray, call = Function.prototype.call, some = Array.prototype.some;
    module.exports = function (iterable, cb /*, thisArg*/) {
        var mode, thisArg = arguments[2], result, doBreak, broken, i, length, char, code;
        if (isArray(iterable) || isArguments(iterable))
            mode = "array";
        else if (isString(iterable))
            mode = "string";
        else
            iterable = get(iterable);
        callable(cb);
        doBreak = function () {
            broken = true;
        };
        if (mode === "array") {
            some.call(iterable, function (value) {
                call.call(cb, thisArg, value, doBreak);
                return broken;
            });
            return;
        }
        if (mode === "string") {
            length = iterable.length;
            for (i = 0; i < length; ++i) {
                char = iterable[i];
                if (i + 1 < length) {
                    code = char.charCodeAt(0);
                    if (code >= 0xd800 && code <= 0xdbff)
                        char += iterable[++i];
                }
                call.call(cb, thisArg, char, doBreak);
                if (broken)
                    break;
            }
            return;
        }
        result = iterable.next();
        while (!result.done) {
            call.call(cb, thisArg, result.value, doBreak);
            if (broken)
                return;
            result = iterable.next();
        }
    };
},
/* es6-iterator/get.js */ function _(require, module, exports, __esModule, __esExport) {
    var isArguments = require(50) /* es5-ext/function/is-arguments */, isString = require(54) /* es5-ext/string/is-string */, ArrayIterator = require(83) /* ./array */, StringIterator = require(97) /* ./string */, iterable = require(79) /* ./valid-iterable */, iteratorSymbol = require(28) /* es6-symbol */.iterator;
    module.exports = function (obj) {
        if (typeof iterable(obj)[iteratorSymbol] === "function")
            return obj[iteratorSymbol]();
        if (isArguments(obj))
            return new ArrayIterator(obj);
        if (isString(obj))
            return new StringIterator(obj);
        return new ArrayIterator(obj);
    };
},
/* es6-iterator/array.js */ function _(require, module, exports, __esModule, __esExport) {
    var setPrototypeOf = require(73) /* es5-ext/object/set-prototype-of */, contains = require(42) /* es5-ext/string/#/contains */, d = require(34) /* d */, Symbol = require(28) /* es6-symbol */, Iterator = require(84) /* ./ */;
    var defineProperty = Object.defineProperty, ArrayIterator;
    ArrayIterator = module.exports = function (arr, kind) {
        if (!(this instanceof ArrayIterator))
            throw new TypeError("Constructor requires 'new'");
        Iterator.call(this, arr);
        if (!kind)
            kind = "value";
        else if (contains.call(kind, "key+value"))
            kind = "key+value";
        else if (contains.call(kind, "key"))
            kind = "key";
        else
            kind = "value";
        defineProperty(this, "__kind__", d("", kind));
    };
    if (setPrototypeOf)
        setPrototypeOf(ArrayIterator, Iterator);
    // Internal %ArrayIteratorPrototype% doesn't expose its constructor
    delete ArrayIterator.prototype.constructor;
    ArrayIterator.prototype = Object.create(Iterator.prototype, {
        _resolve: d(function (i) {
            if (this.__kind__ === "value")
                return this.__list__[i];
            if (this.__kind__ === "key+value")
                return [i, this.__list__[i]];
            return i;
        })
    });
    defineProperty(ArrayIterator.prototype, Symbol.toStringTag, d("c", "Array Iterator"));
},
/* es6-iterator/index.js */ function _(require, module, exports, __esModule, __esExport) {
    var clear = require(68) /* es5-ext/array/#/clear */, assign = require(40) /* es5-ext/object/assign */, callable = require(53) /* es5-ext/object/valid-callable */, value = require(11) /* es5-ext/object/valid-value */, d = require(34) /* d */, autoBind = require(85) /* d/auto-bind */, Symbol = require(28) /* es6-symbol */;
    var defineProperty = Object.defineProperty, defineProperties = Object.defineProperties, Iterator;
    module.exports = Iterator = function (list, context) {
        if (!(this instanceof Iterator))
            throw new TypeError("Constructor requires 'new'");
        defineProperties(this, {
            __list__: d("w", value(list)),
            __context__: d("w", context),
            __nextIndex__: d("w", 0)
        });
        if (!context)
            return;
        callable(context.on);
        context.on("_add", this._onAdd);
        context.on("_delete", this._onDelete);
        context.on("_clear", this._onClear);
    };
    // Internal %IteratorPrototype% doesn't expose its constructor
    delete Iterator.prototype.constructor;
    defineProperties(Iterator.prototype, assign({
        _next: d(function () {
            var i;
            if (!this.__list__)
                return undefined;
            if (this.__redo__) {
                i = this.__redo__.shift();
                if (i !== undefined)
                    return i;
            }
            if (this.__nextIndex__ < this.__list__.length)
                return this.__nextIndex__++;
            this._unBind();
            return undefined;
        }),
        next: d(function () {
            return this._createResult(this._next());
        }),
        _createResult: d(function (i) {
            if (i === undefined)
                return { done: true, value: undefined };
            return { done: false, value: this._resolve(i) };
        }),
        _resolve: d(function (i) {
            return this.__list__[i];
        }),
        _unBind: d(function () {
            this.__list__ = null;
            delete this.__redo__;
            if (!this.__context__)
                return;
            this.__context__.off("_add", this._onAdd);
            this.__context__.off("_delete", this._onDelete);
            this.__context__.off("_clear", this._onClear);
            this.__context__ = null;
        }),
        toString: d(function () {
            return "[object " + (this[Symbol.toStringTag] || "Object") + "]";
        })
    }, autoBind({
        _onAdd: d(function (index) {
            if (index >= this.__nextIndex__)
                return;
            ++this.__nextIndex__;
            if (!this.__redo__) {
                defineProperty(this, "__redo__", d("c", [index]));
                return;
            }
            this.__redo__.forEach(function (redo, i) {
                if (redo >= index)
                    this.__redo__[i] = ++redo;
            }, this);
            this.__redo__.push(index);
        }),
        _onDelete: d(function (index) {
            var i;
            if (index >= this.__nextIndex__)
                return;
            --this.__nextIndex__;
            if (!this.__redo__)
                return;
            i = this.__redo__.indexOf(index);
            if (i !== -1)
                this.__redo__.splice(i, 1);
            this.__redo__.forEach(function (redo, j) {
                if (redo > index)
                    this.__redo__[j] = --redo;
            }, this);
        }),
        _onClear: d(function () {
            if (this.__redo__)
                clear.call(this.__redo__);
            this.__nextIndex__ = 0;
        })
    })));
    defineProperty(Iterator.prototype, Symbol.iterator, d(function () {
        return this;
    }));
},
/* d/auto-bind.js */ function _(require, module, exports, __esModule, __esExport) {
    var isValue = require(35) /* type/value/is */, ensureValue = require(86) /* type/value/ensure */, ensurePlainFunction = require(91) /* type/plain-function/ensure */, copy = require(92) /* es5-ext/object/copy */, normalizeOptions = require(41) /* es5-ext/object/normalize-options */, map = require(94) /* es5-ext/object/map */;
    var bind = Function.prototype.bind, defineProperty = Object.defineProperty, hasOwnProperty = Object.prototype.hasOwnProperty, define;
    define = function (name, desc, options) {
        var value = ensureValue(desc) && ensurePlainFunction(desc.value), dgs;
        dgs = copy(desc);
        delete dgs.writable;
        delete dgs.value;
        dgs.get = function () {
            if (!options.overwriteDefinition && hasOwnProperty.call(this, name))
                return value;
            desc.value = bind.call(value, options.resolveContext ? options.resolveContext(this) : this);
            defineProperty(this, name, desc);
            return this[name];
        };
        return dgs;
    };
    module.exports = function (props /*, options*/) {
        var options = normalizeOptions(arguments[1]);
        if (isValue(options.resolveContext))
            ensurePlainFunction(options.resolveContext);
        return map(props, function (desc, name) { return define(name, desc, options); });
    };
},
/* type/value/ensure.js */ function _(require, module, exports, __esModule, __esExport) {
    var resolveException = require(87) /* ../lib/resolve-exception */, is = require(35) /* ./is */;
    module.exports = function (value /*, options*/) {
        if (is(value))
            return value;
        return resolveException(value, "Cannot use %v", arguments[1]);
    };
},
/* type/lib/resolve-exception.js */ function _(require, module, exports, __esModule, __esExport) {
    var isValue = require(35) /* ../value/is */, isObject = require(39) /* ../object/is */, stringCoerce = require(88) /* ../string/coerce */, toShortString = require(89) /* ./to-short-string */;
    var resolveMessage = function (message, value) {
        return message.replace("%v", toShortString(value));
    };
    module.exports = function (value, defaultMessage, inputOptions) {
        if (!isObject(inputOptions))
            throw new TypeError(resolveMessage(defaultMessage, value));
        if (!isValue(value)) {
            if ("default" in inputOptions)
                return inputOptions["default"];
            if (inputOptions.isOptional)
                return null;
        }
        var errorMessage = stringCoerce(inputOptions.errorMessage);
        if (!isValue(errorMessage))
            errorMessage = defaultMessage;
        throw new TypeError(resolveMessage(errorMessage, value));
    };
},
/* type/string/coerce.js */ function _(require, module, exports, __esModule, __esExport) {
    var isValue = require(35) /* ../value/is */, isObject = require(39) /* ../object/is */;
    var objectToString = Object.prototype.toString;
    module.exports = function (value) {
        if (!isValue(value))
            return null;
        if (isObject(value)) {
            // Reject Object.prototype.toString coercion
            var valueToString = value.toString;
            if (typeof valueToString !== "function")
                return null;
            if (valueToString === objectToString)
                return null;
            // Note: It can be object coming from other realm, still as there's no ES3 and CSP compliant
            // way to resolve its realm's Object.prototype.toString it's left as not addressed edge case
        }
        try {
            return "" + value; // Ensure implicit coercion
        }
        catch (error) {
            return null;
        }
    };
},
/* type/lib/to-short-string.js */ function _(require, module, exports, __esModule, __esExport) {
    var safeToString = require(90) /* ./safe-to-string */;
    var reNewLine = /[\n\r\u2028\u2029]/g;
    module.exports = function (value) {
        var string = safeToString(value);
        if (string === null)
            return "<Non-coercible to string value>";
        // Trim if too long
        if (string.length > 100)
            string = string.slice(0, 99) + "…";
        // Replace eventual new lines
        string = string.replace(reNewLine, function (char) {
            switch (char) {
                case "\n":
                    return "\\n";
                case "\r":
                    return "\\r";
                case "\u2028":
                    return "\\u2028";
                case "\u2029":
                    return "\\u2029";
                /* istanbul ignore next */
                default:
                    throw new Error("Unexpected character");
            }
        });
        return string;
    };
},
/* type/lib/safe-to-string.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function (value) {
        try {
            return value.toString();
        }
        catch (error) {
            try {
                return String(value);
            }
            catch (error2) {
                return null;
            }
        }
    };
},
/* type/plain-function/ensure.js */ function _(require, module, exports, __esModule, __esExport) {
    var resolveException = require(87) /* ../lib/resolve-exception */, is = require(36) /* ./is */;
    module.exports = function (value /*, options*/) {
        if (is(value))
            return value;
        return resolveException(value, "%v is not a plain function", arguments[1]);
    };
},
/* es5-ext/object/copy.js */ function _(require, module, exports, __esModule, __esExport) {
    var aFrom = require(93) /* ../array/from */, assign = require(40) /* ./assign */, value = require(11) /* ./valid-value */;
    module.exports = function (obj /*, propertyNames, options*/) {
        var copy = Object(value(obj)), propertyNames = arguments[1], options = Object(arguments[2]);
        if (copy !== obj && !propertyNames)
            return copy;
        var result = {};
        if (propertyNames) {
            aFrom(propertyNames, function (propertyName) {
                if (options.ensure || propertyName in obj)
                    result[propertyName] = obj[propertyName];
            });
        }
        else {
            assign(result, obj);
        }
        return result;
    };
},
/* es5-ext/array/from/index.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(26) /* ./is-implemented */() ? Array.from : require(27) /* ./shim */;
},
/* es5-ext/object/map.js */ function _(require, module, exports, __esModule, __esExport) {
    var callable = require(53) /* ./valid-callable */, forEach = require(95) /* ./for-each */, call = Function.prototype.call;
    module.exports = function (obj, cb /*, thisArg*/) {
        var result = {}, thisArg = arguments[2];
        callable(cb);
        forEach(obj, function (value, key, targetObj, index) {
            result[key] = call.call(cb, thisArg, value, key, targetObj, index);
        });
        return result;
    };
},
/* es5-ext/object/for-each.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(96) /* ./_iterate */("forEach");
},
/* es5-ext/object/_iterate.js */ function _(require, module, exports, __esModule, __esExport) {
    var callable = require(53) /* ./valid-callable */, value = require(11) /* ./valid-value */, bind = Function.prototype.bind, call = Function.prototype.call, keys = Object.keys, objPropertyIsEnumerable = Object.prototype.propertyIsEnumerable;
    module.exports = function (method, defVal) {
        return function (obj, cb /*, thisArg, compareFn*/) {
            var list, thisArg = arguments[2], compareFn = arguments[3];
            obj = Object(value(obj));
            callable(cb);
            list = keys(obj);
            if (compareFn) {
                list.sort(typeof compareFn === "function" ? bind.call(compareFn, obj) : undefined);
            }
            if (typeof method !== "function")
                method = list[method];
            return call.call(method, list, function (key, index) {
                if (!objPropertyIsEnumerable.call(obj, key))
                    return defVal;
                return call.call(cb, thisArg, obj[key], key, obj, index);
            });
        };
    };
},
/* es6-iterator/string.js */ function _(require, module, exports, __esModule, __esExport) {
    var setPrototypeOf = require(73) /* es5-ext/object/set-prototype-of */, d = require(34) /* d */, Symbol = require(28) /* es6-symbol */, Iterator = require(84) /* ./ */;
    var defineProperty = Object.defineProperty, StringIterator;
    StringIterator = module.exports = function (str) {
        if (!(this instanceof StringIterator))
            throw new TypeError("Constructor requires 'new'");
        str = String(str);
        Iterator.call(this, str);
        defineProperty(this, "__length__", d("", str.length));
    };
    if (setPrototypeOf)
        setPrototypeOf(StringIterator, Iterator);
    // Internal %ArrayIteratorPrototype% doesn't expose its constructor
    delete StringIterator.prototype.constructor;
    StringIterator.prototype = Object.create(Iterator.prototype, {
        _next: d(function () {
            if (!this.__list__)
                return undefined;
            if (this.__nextIndex__ < this.__length__)
                return this.__nextIndex__++;
            this._unBind();
            return undefined;
        }),
        _resolve: d(function (i) {
            var char = this.__list__[i], code;
            if (this.__nextIndex__ === this.__length__)
                return char;
            code = char.charCodeAt(0);
            if (code >= 0xd800 && code <= 0xdbff)
                return char + this.__list__[this.__nextIndex__++];
            return char;
        })
    });
    defineProperty(StringIterator.prototype, Symbol.toStringTag, d("c", "String Iterator"));
},
/* es6-set/lib/iterator.js */ function _(require, module, exports, __esModule, __esExport) {
    var setPrototypeOf = require(73) /* es5-ext/object/set-prototype-of */, contains = require(42) /* es5-ext/string/#/contains */, d = require(34) /* d */, Iterator = require(84) /* es6-iterator */, toStringTagSymbol = require(28) /* es6-symbol */.toStringTag, defineProperty = Object.defineProperty, SetIterator;
    SetIterator = module.exports = function (set, kind) {
        if (!(this instanceof SetIterator))
            return new SetIterator(set, kind);
        Iterator.call(this, set.__setData__, set);
        if (!kind)
            kind = 'value';
        else if (contains.call(kind, 'key+value'))
            kind = 'key+value';
        else
            kind = 'value';
        defineProperty(this, '__kind__', d('', kind));
    };
    if (setPrototypeOf)
        setPrototypeOf(SetIterator, Iterator);
    SetIterator.prototype = Object.create(Iterator.prototype, {
        constructor: d(SetIterator),
        _resolve: d(function (i) {
            if (this.__kind__ === 'value')
                return this.__list__[i];
            return [this.__list__[i], this.__list__[i]];
        }),
        toString: d(function () { return '[object Set Iterator]'; })
    });
    defineProperty(SetIterator.prototype, toStringTagSymbol, d('c', 'Set Iterator'));
},
/* es6-set/is-native-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = (function () {
        if (typeof Set === 'undefined')
            return false;
        return (Object.prototype.toString.call(Set.prototype) === '[object Set]');
    }());
},
/* es6-map/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(101) /* ./is-implemented */()) {
        Object.defineProperty(require(66) /* es5-ext/global */, 'Map', { value: require(102) /* ./polyfill */, configurable: true, enumerable: false,
            writable: true });
    }
},
/* es6-map/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        var map, iterator, result;
        if (typeof Map !== 'function')
            return false;
        try {
            // WebKit doesn't support arguments and crashes
            map = new Map([['raz', 'one'], ['dwa', 'two'], ['trzy', 'three']]);
        }
        catch (e) {
            return false;
        }
        if (String(map) !== '[object Map]')
            return false;
        if (map.size !== 3)
            return false;
        if (typeof map.clear !== 'function')
            return false;
        if (typeof map.delete !== 'function')
            return false;
        if (typeof map.entries !== 'function')
            return false;
        if (typeof map.forEach !== 'function')
            return false;
        if (typeof map.get !== 'function')
            return false;
        if (typeof map.has !== 'function')
            return false;
        if (typeof map.keys !== 'function')
            return false;
        if (typeof map.set !== 'function')
            return false;
        if (typeof map.values !== 'function')
            return false;
        iterator = map.entries();
        result = iterator.next();
        if (result.done !== false)
            return false;
        if (!result.value)
            return false;
        if (result.value[0] !== 'raz')
            return false;
        if (result.value[1] !== 'one')
            return false;
        return true;
    };
},
/* es6-map/polyfill.js */ function _(require, module, exports, __esModule, __esExport) {
    var clear = require(68) /* es5-ext/array/#/clear */, eIndexOf = require(69) /* es5-ext/array/#/e-index-of */, setPrototypeOf = require(73) /* es5-ext/object/set-prototype-of */, callable = require(53) /* es5-ext/object/valid-callable */, validValue = require(11) /* es5-ext/object/valid-value */, d = require(34) /* d */, ee = require(78) /* event-emitter */, Symbol = require(28) /* es6-symbol */, iterator = require(79) /* es6-iterator/valid-iterable */, forOf = require(81) /* es6-iterator/for-of */, Iterator = require(103) /* ./lib/iterator */, isNative = require(106) /* ./is-native-implemented */, call = Function.prototype.call, defineProperties = Object.defineProperties, getPrototypeOf = Object.getPrototypeOf, MapPoly;
    module.exports = MapPoly = function ( /*iterable*/) {
        var iterable = arguments[0], keys, values, self;
        if (!(this instanceof MapPoly))
            throw new TypeError('Constructor requires \'new\'');
        if (isNative && setPrototypeOf && (Map !== MapPoly)) {
            self = setPrototypeOf(new Map(), getPrototypeOf(this));
        }
        else {
            self = this;
        }
        if (iterable != null)
            iterator(iterable);
        defineProperties(self, {
            __mapKeysData__: d('c', keys = []),
            __mapValuesData__: d('c', values = [])
        });
        if (!iterable)
            return self;
        forOf(iterable, function (value) {
            var key = validValue(value)[0];
            value = value[1];
            if (eIndexOf.call(keys, key) !== -1)
                return;
            keys.push(key);
            values.push(value);
        }, self);
        return self;
    };
    if (isNative) {
        if (setPrototypeOf)
            setPrototypeOf(MapPoly, Map);
        MapPoly.prototype = Object.create(Map.prototype, {
            constructor: d(MapPoly)
        });
    }
    ee(defineProperties(MapPoly.prototype, {
        clear: d(function () {
            if (!this.__mapKeysData__.length)
                return;
            clear.call(this.__mapKeysData__);
            clear.call(this.__mapValuesData__);
            this.emit('_clear');
        }),
        delete: d(function (key) {
            var index = eIndexOf.call(this.__mapKeysData__, key);
            if (index === -1)
                return false;
            this.__mapKeysData__.splice(index, 1);
            this.__mapValuesData__.splice(index, 1);
            this.emit('_delete', index, key);
            return true;
        }),
        entries: d(function () { return new Iterator(this, 'key+value'); }),
        forEach: d(function (cb /*, thisArg*/) {
            var thisArg = arguments[1], iterator, result;
            callable(cb);
            iterator = this.entries();
            result = iterator._next();
            while (result !== undefined) {
                call.call(cb, thisArg, this.__mapValuesData__[result], this.__mapKeysData__[result], this);
                result = iterator._next();
            }
        }),
        get: d(function (key) {
            var index = eIndexOf.call(this.__mapKeysData__, key);
            if (index === -1)
                return;
            return this.__mapValuesData__[index];
        }),
        has: d(function (key) {
            return (eIndexOf.call(this.__mapKeysData__, key) !== -1);
        }),
        keys: d(function () { return new Iterator(this, 'key'); }),
        set: d(function (key, value) {
            var index = eIndexOf.call(this.__mapKeysData__, key), emit;
            if (index === -1) {
                index = this.__mapKeysData__.push(key) - 1;
                emit = true;
            }
            this.__mapValuesData__[index] = value;
            if (emit)
                this.emit('_add', index, key);
            return this;
        }),
        size: d.gs(function () { return this.__mapKeysData__.length; }),
        values: d(function () { return new Iterator(this, 'value'); }),
        toString: d(function () { return '[object Map]'; })
    }));
    Object.defineProperty(MapPoly.prototype, Symbol.iterator, d(function () {
        return this.entries();
    }));
    Object.defineProperty(MapPoly.prototype, Symbol.toStringTag, d('c', 'Map'));
},
/* es6-map/lib/iterator.js */ function _(require, module, exports, __esModule, __esExport) {
    var setPrototypeOf = require(73) /* es5-ext/object/set-prototype-of */, d = require(34) /* d */, Iterator = require(84) /* es6-iterator */, toStringTagSymbol = require(28) /* es6-symbol */.toStringTag, kinds = require(104) /* ./iterator-kinds */, defineProperties = Object.defineProperties, unBind = Iterator.prototype._unBind, MapIterator;
    MapIterator = module.exports = function (map, kind) {
        if (!(this instanceof MapIterator))
            return new MapIterator(map, kind);
        Iterator.call(this, map.__mapKeysData__, map);
        if (!kind || !kinds[kind])
            kind = 'key+value';
        defineProperties(this, {
            __kind__: d('', kind),
            __values__: d('w', map.__mapValuesData__)
        });
    };
    if (setPrototypeOf)
        setPrototypeOf(MapIterator, Iterator);
    MapIterator.prototype = Object.create(Iterator.prototype, {
        constructor: d(MapIterator),
        _resolve: d(function (i) {
            if (this.__kind__ === 'value')
                return this.__values__[i];
            if (this.__kind__ === 'key')
                return this.__list__[i];
            return [this.__list__[i], this.__values__[i]];
        }),
        _unBind: d(function () {
            this.__values__ = null;
            unBind.call(this);
        }),
        toString: d(function () { return '[object Map Iterator]'; })
    });
    Object.defineProperty(MapIterator.prototype, toStringTagSymbol, d('c', 'Map Iterator'));
},
/* es6-map/lib/iterator-kinds.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(105) /* es5-ext/object/primitive-set */('key', 'value', 'key+value');
},
/* es5-ext/object/primitive-set.js */ function _(require, module, exports, __esModule, __esExport) {
    var forEach = Array.prototype.forEach, create = Object.create;
    // eslint-disable-next-line no-unused-vars
    module.exports = function (arg /*, …args*/) {
        var set = create(null);
        forEach.call(arguments, function (name) { set[name] = true; });
        return set;
    };
},
/* es6-map/is-native-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = (function () {
        if (typeof Map === 'undefined')
            return false;
        return (Object.prototype.toString.call(new Map()) === '[object Map]');
    }());
},
/* es6-weak-map/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(108) /* ./is-implemented */()) {
        Object.defineProperty(require(66) /* es5-ext/global */, "WeakMap", {
            value: require(109) /* ./polyfill */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es6-weak-map/is-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = function () {
        var weakMap, obj;
        if (typeof WeakMap !== "function")
            return false;
        try {
            // WebKit doesn't support arguments and crashes
            weakMap = new WeakMap([[obj = {}, "one"], [{}, "two"], [{}, "three"]]);
        }
        catch (e) {
            return false;
        }
        if (String(weakMap) !== "[object WeakMap]")
            return false;
        if (typeof weakMap.set !== "function")
            return false;
        if (weakMap.set({}, 1) !== weakMap)
            return false;
        if (typeof weakMap.delete !== "function")
            return false;
        if (typeof weakMap.has !== "function")
            return false;
        if (weakMap.get(obj) !== "one")
            return false;
        return true;
    };
},
/* es6-weak-map/polyfill.js */ function _(require, module, exports, __esModule, __esExport) {
    var isValue = require(9) /* es5-ext/object/is-value */, setPrototypeOf = require(73) /* es5-ext/object/set-prototype-of */, object = require(110) /* es5-ext/object/valid-object */, ensureValue = require(11) /* es5-ext/object/valid-value */, randomUniq = require(111) /* es5-ext/string/random-uniq */, d = require(34) /* d */, getIterator = require(82) /* es6-iterator/get */, forOf = require(81) /* es6-iterator/for-of */, toStringTagSymbol = require(28) /* es6-symbol */.toStringTag, isNative = require(112) /* ./is-native-implemented */, isArray = Array.isArray, defineProperty = Object.defineProperty, objHasOwnProperty = Object.prototype.hasOwnProperty, getPrototypeOf = Object.getPrototypeOf, WeakMapPoly;
    module.exports = WeakMapPoly = function ( /* Iterable*/) {
        var iterable = arguments[0], self;
        if (!(this instanceof WeakMapPoly))
            throw new TypeError("Constructor requires 'new'");
        self = isNative && setPrototypeOf && (WeakMap !== WeakMapPoly)
            ? setPrototypeOf(new WeakMap(), getPrototypeOf(this)) : this;
        if (isValue(iterable)) {
            if (!isArray(iterable))
                iterable = getIterator(iterable);
        }
        defineProperty(self, "__weakMapData__", d("c", "$weakMap$" + randomUniq()));
        if (!iterable)
            return self;
        forOf(iterable, function (val) {
            ensureValue(val);
            self.set(val[0], val[1]);
        });
        return self;
    };
    if (isNative) {
        if (setPrototypeOf)
            setPrototypeOf(WeakMapPoly, WeakMap);
        WeakMapPoly.prototype = Object.create(WeakMap.prototype, { constructor: d(WeakMapPoly) });
    }
    Object.defineProperties(WeakMapPoly.prototype, {
        delete: d(function (key) {
            if (objHasOwnProperty.call(object(key), this.__weakMapData__)) {
                delete key[this.__weakMapData__];
                return true;
            }
            return false;
        }),
        get: d(function (key) {
            if (!objHasOwnProperty.call(object(key), this.__weakMapData__))
                return undefined;
            return key[this.__weakMapData__];
        }),
        has: d(function (key) {
            return objHasOwnProperty.call(object(key), this.__weakMapData__);
        }),
        set: d(function (key, value) {
            defineProperty(object(key), this.__weakMapData__, d("c", value));
            return this;
        }),
        toString: d(function () {
            return "[object WeakMap]";
        })
    });
    defineProperty(WeakMapPoly.prototype, toStringTagSymbol, d("c", "WeakMap"));
},
/* es5-ext/object/valid-object.js */ function _(require, module, exports, __esModule, __esExport) {
    var isObject = require(76) /* ./is-object */;
    module.exports = function (value) {
        if (!isObject(value))
            throw new TypeError(value + " is not an Object");
        return value;
    };
},
/* es5-ext/string/random-uniq.js */ function _(require, module, exports, __esModule, __esExport) {
    var generated = Object.create(null), random = Math.random;
    module.exports = function () {
        var str;
        do {
            str = random().toString(36).slice(2);
        } while (generated[str]);
        return str;
    };
},
/* es6-weak-map/is-native-implemented.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = (function () {
        if (typeof WeakMap !== "function")
            return false;
        return Object.prototype.toString.call(new WeakMap()) === "[object WeakMap]";
    }());
},
/* es6-symbol/implement.js */ function _(require, module, exports, __esModule, __esExport) {
    if (!require(29) /* ./is-implemented */()) {
        Object.defineProperty(require(30) /* ext/global-this */, "Symbol", {
            value: require(33) /* ./polyfill */,
            configurable: true,
            enumerable: false,
            writable: true
        });
    }
},
/* es6-promise/auto.js */ function _(require, module, exports, __esModule, __esExport) {
    module.exports = require(115) /* ./ */.polyfill();
},
/* es6-promise/dist/es6-promise.js */ function _(require, module, exports, __esModule, __esExport) {
    /*!
     * @overview es6-promise - a tiny implementation of Promises/A+.
     * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
     * @license   Licensed under MIT license
     *            See https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE
     * @version   v4.2.8+1e68dce6
     */
    (function (global, factory) {
        typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
            typeof define === 'function' && define.amd ? define(factory) :
                (global.ES6Promise = factory());
    }(this, (function () {
        'use strict';
        function objectOrFunction(x) {
            var type = typeof x;
            return x !== null && (type === 'object' || type === 'function');
        }
        function isFunction(x) {
            return typeof x === 'function';
        }
        var _isArray = void 0;
        if (Array.isArray) {
            _isArray = Array.isArray;
        }
        else {
            _isArray = function (x) {
                return Object.prototype.toString.call(x) === '[object Array]';
            };
        }
        var isArray = _isArray;
        var len = 0;
        var vertxNext = void 0;
        var customSchedulerFn = void 0;
        var asap = function asap(callback, arg) {
            queue[len] = callback;
            queue[len + 1] = arg;
            len += 2;
            if (len === 2) {
                // If len is 2, that means that we need to schedule an async flush.
                // If additional callbacks are queued before the queue is flushed, they
                // will be processed by this flush that we are scheduling.
                if (customSchedulerFn) {
                    customSchedulerFn(flush);
                }
                else {
                    scheduleFlush();
                }
            }
        };
        function setScheduler(scheduleFn) {
            customSchedulerFn = scheduleFn;
        }
        function setAsap(asapFn) {
            asap = asapFn;
        }
        var browserWindow = typeof window !== 'undefined' ? window : undefined;
        var browserGlobal = browserWindow || {};
        var BrowserMutationObserver = browserGlobal.MutationObserver || browserGlobal.WebKitMutationObserver;
        var isNode = typeof self === 'undefined' && typeof process !== 'undefined' && {}.toString.call(process) === '[object process]';
        // test for web worker but not in IE10
        var isWorker = typeof Uint8ClampedArray !== 'undefined' && typeof importScripts !== 'undefined' && typeof MessageChannel !== 'undefined';
        // node
        function useNextTick() {
            // node version 0.10.x displays a deprecation warning when nextTick is used recursively
            // see https://github.com/cujojs/when/issues/410 for details
            return function () {
                return process.nextTick(flush);
            };
        }
        // vertx
        function useVertxTimer() {
            if (typeof vertxNext !== 'undefined') {
                return function () {
                    vertxNext(flush);
                };
            }
            return useSetTimeout();
        }
        function useMutationObserver() {
            var iterations = 0;
            var observer = new BrowserMutationObserver(flush);
            var node = document.createTextNode('');
            observer.observe(node, { characterData: true });
            return function () {
                node.data = iterations = ++iterations % 2;
            };
        }
        // web worker
        function useMessageChannel() {
            var channel = new MessageChannel();
            channel.port1.onmessage = flush;
            return function () {
                return channel.port2.postMessage(0);
            };
        }
        function useSetTimeout() {
            // Store setTimeout reference so es6-promise will be unaffected by
            // other code modifying setTimeout (like sinon.useFakeTimers())
            var globalSetTimeout = setTimeout;
            return function () {
                return globalSetTimeout(flush, 1);
            };
        }
        var queue = new Array(1000);
        function flush() {
            for (var i = 0; i < len; i += 2) {
                var callback = queue[i];
                var arg = queue[i + 1];
                callback(arg);
                queue[i] = undefined;
                queue[i + 1] = undefined;
            }
            len = 0;
        }
        function attemptVertx() {
            try {
                var vertx = Function('return this')().require('vertx');
                vertxNext = vertx.runOnLoop || vertx.runOnContext;
                return useVertxTimer();
            }
            catch (e) {
                return useSetTimeout();
            }
        }
        var scheduleFlush = void 0;
        // Decide what async method to use to triggering processing of queued callbacks:
        if (isNode) {
            scheduleFlush = useNextTick();
        }
        else if (BrowserMutationObserver) {
            scheduleFlush = useMutationObserver();
        }
        else if (isWorker) {
            scheduleFlush = useMessageChannel();
        }
        else if (browserWindow === undefined && typeof require === 'function') {
            scheduleFlush = attemptVertx();
        }
        else {
            scheduleFlush = useSetTimeout();
        }
        function then(onFulfillment, onRejection) {
            var parent = this;
            var child = new this.constructor(noop);
            if (child[PROMISE_ID] === undefined) {
                makePromise(child);
            }
            var _state = parent._state;
            if (_state) {
                var callback = arguments[_state - 1];
                asap(function () {
                    return invokeCallback(_state, child, callback, parent._result);
                });
            }
            else {
                subscribe(parent, child, onFulfillment, onRejection);
            }
            return child;
        }
        /**
          `Promise.resolve` returns a promise that will become resolved with the
          passed `value`. It is shorthand for the following:
        
          ```javascript
          let promise = new Promise(function(resolve, reject){
            resolve(1);
          });
        
          promise.then(function(value){
            // value === 1
          });
          ```
        
          Instead of writing the above, your code now simply becomes the following:
        
          ```javascript
          let promise = Promise.resolve(1);
        
          promise.then(function(value){
            // value === 1
          });
          ```
        
          @method resolve
          @static
          @param {Any} value value that the returned promise will be resolved with
          Useful for tooling.
          @return {Promise} a promise that will become fulfilled with the given
          `value`
        */
        function resolve$1(object) {
            /*jshint validthis:true */
            var Constructor = this;
            if (object && typeof object === 'object' && object.constructor === Constructor) {
                return object;
            }
            var promise = new Constructor(noop);
            resolve(promise, object);
            return promise;
        }
        var PROMISE_ID = Math.random().toString(36).substring(2);
        function noop() { }
        var PENDING = void 0;
        var FULFILLED = 1;
        var REJECTED = 2;
        function selfFulfillment() {
            return new TypeError("You cannot resolve a promise with itself");
        }
        function cannotReturnOwn() {
            return new TypeError('A promises callback cannot return that same promise.');
        }
        function tryThen(then$$1, value, fulfillmentHandler, rejectionHandler) {
            try {
                then$$1.call(value, fulfillmentHandler, rejectionHandler);
            }
            catch (e) {
                return e;
            }
        }
        function handleForeignThenable(promise, thenable, then$$1) {
            asap(function (promise) {
                var sealed = false;
                var error = tryThen(then$$1, thenable, function (value) {
                    if (sealed) {
                        return;
                    }
                    sealed = true;
                    if (thenable !== value) {
                        resolve(promise, value);
                    }
                    else {
                        fulfill(promise, value);
                    }
                }, function (reason) {
                    if (sealed) {
                        return;
                    }
                    sealed = true;
                    reject(promise, reason);
                }, 'Settle: ' + (promise._label || ' unknown promise'));
                if (!sealed && error) {
                    sealed = true;
                    reject(promise, error);
                }
            }, promise);
        }
        function handleOwnThenable(promise, thenable) {
            if (thenable._state === FULFILLED) {
                fulfill(promise, thenable._result);
            }
            else if (thenable._state === REJECTED) {
                reject(promise, thenable._result);
            }
            else {
                subscribe(thenable, undefined, function (value) {
                    return resolve(promise, value);
                }, function (reason) {
                    return reject(promise, reason);
                });
            }
        }
        function handleMaybeThenable(promise, maybeThenable, then$$1) {
            if (maybeThenable.constructor === promise.constructor && then$$1 === then && maybeThenable.constructor.resolve === resolve$1) {
                handleOwnThenable(promise, maybeThenable);
            }
            else {
                if (then$$1 === undefined) {
                    fulfill(promise, maybeThenable);
                }
                else if (isFunction(then$$1)) {
                    handleForeignThenable(promise, maybeThenable, then$$1);
                }
                else {
                    fulfill(promise, maybeThenable);
                }
            }
        }
        function resolve(promise, value) {
            if (promise === value) {
                reject(promise, selfFulfillment());
            }
            else if (objectOrFunction(value)) {
                var then$$1 = void 0;
                try {
                    then$$1 = value.then;
                }
                catch (error) {
                    reject(promise, error);
                    return;
                }
                handleMaybeThenable(promise, value, then$$1);
            }
            else {
                fulfill(promise, value);
            }
        }
        function publishRejection(promise) {
            if (promise._onerror) {
                promise._onerror(promise._result);
            }
            publish(promise);
        }
        function fulfill(promise, value) {
            if (promise._state !== PENDING) {
                return;
            }
            promise._result = value;
            promise._state = FULFILLED;
            if (promise._subscribers.length !== 0) {
                asap(publish, promise);
            }
        }
        function reject(promise, reason) {
            if (promise._state !== PENDING) {
                return;
            }
            promise._state = REJECTED;
            promise._result = reason;
            asap(publishRejection, promise);
        }
        function subscribe(parent, child, onFulfillment, onRejection) {
            var _subscribers = parent._subscribers;
            var length = _subscribers.length;
            parent._onerror = null;
            _subscribers[length] = child;
            _subscribers[length + FULFILLED] = onFulfillment;
            _subscribers[length + REJECTED] = onRejection;
            if (length === 0 && parent._state) {
                asap(publish, parent);
            }
        }
        function publish(promise) {
            var subscribers = promise._subscribers;
            var settled = promise._state;
            if (subscribers.length === 0) {
                return;
            }
            var child = void 0, callback = void 0, detail = promise._result;
            for (var i = 0; i < subscribers.length; i += 3) {
                child = subscribers[i];
                callback = subscribers[i + settled];
                if (child) {
                    invokeCallback(settled, child, callback, detail);
                }
                else {
                    callback(detail);
                }
            }
            promise._subscribers.length = 0;
        }
        function invokeCallback(settled, promise, callback, detail) {
            var hasCallback = isFunction(callback), value = void 0, error = void 0, succeeded = true;
            if (hasCallback) {
                try {
                    value = callback(detail);
                }
                catch (e) {
                    succeeded = false;
                    error = e;
                }
                if (promise === value) {
                    reject(promise, cannotReturnOwn());
                    return;
                }
            }
            else {
                value = detail;
            }
            if (promise._state !== PENDING) {
                // noop
            }
            else if (hasCallback && succeeded) {
                resolve(promise, value);
            }
            else if (succeeded === false) {
                reject(promise, error);
            }
            else if (settled === FULFILLED) {
                fulfill(promise, value);
            }
            else if (settled === REJECTED) {
                reject(promise, value);
            }
        }
        function initializePromise(promise, resolver) {
            try {
                resolver(function resolvePromise(value) {
                    resolve(promise, value);
                }, function rejectPromise(reason) {
                    reject(promise, reason);
                });
            }
            catch (e) {
                reject(promise, e);
            }
        }
        var id = 0;
        function nextId() {
            return id++;
        }
        function makePromise(promise) {
            promise[PROMISE_ID] = id++;
            promise._state = undefined;
            promise._result = undefined;
            promise._subscribers = [];
        }
        function validationError() {
            return new Error('Array Methods must be provided an Array');
        }
        var Enumerator = function () {
            function Enumerator(Constructor, input) {
                this._instanceConstructor = Constructor;
                this.promise = new Constructor(noop);
                if (!this.promise[PROMISE_ID]) {
                    makePromise(this.promise);
                }
                if (isArray(input)) {
                    this.length = input.length;
                    this._remaining = input.length;
                    this._result = new Array(this.length);
                    if (this.length === 0) {
                        fulfill(this.promise, this._result);
                    }
                    else {
                        this.length = this.length || 0;
                        this._enumerate(input);
                        if (this._remaining === 0) {
                            fulfill(this.promise, this._result);
                        }
                    }
                }
                else {
                    reject(this.promise, validationError());
                }
            }
            Enumerator.prototype._enumerate = function _enumerate(input) {
                for (var i = 0; this._state === PENDING && i < input.length; i++) {
                    this._eachEntry(input[i], i);
                }
            };
            Enumerator.prototype._eachEntry = function _eachEntry(entry, i) {
                var c = this._instanceConstructor;
                var resolve$$1 = c.resolve;
                if (resolve$$1 === resolve$1) {
                    var _then = void 0;
                    var error = void 0;
                    var didError = false;
                    try {
                        _then = entry.then;
                    }
                    catch (e) {
                        didError = true;
                        error = e;
                    }
                    if (_then === then && entry._state !== PENDING) {
                        this._settledAt(entry._state, i, entry._result);
                    }
                    else if (typeof _then !== 'function') {
                        this._remaining--;
                        this._result[i] = entry;
                    }
                    else if (c === Promise$1) {
                        var promise = new c(noop);
                        if (didError) {
                            reject(promise, error);
                        }
                        else {
                            handleMaybeThenable(promise, entry, _then);
                        }
                        this._willSettleAt(promise, i);
                    }
                    else {
                        this._willSettleAt(new c(function (resolve$$1) {
                            return resolve$$1(entry);
                        }), i);
                    }
                }
                else {
                    this._willSettleAt(resolve$$1(entry), i);
                }
            };
            Enumerator.prototype._settledAt = function _settledAt(state, i, value) {
                var promise = this.promise;
                if (promise._state === PENDING) {
                    this._remaining--;
                    if (state === REJECTED) {
                        reject(promise, value);
                    }
                    else {
                        this._result[i] = value;
                    }
                }
                if (this._remaining === 0) {
                    fulfill(promise, this._result);
                }
            };
            Enumerator.prototype._willSettleAt = function _willSettleAt(promise, i) {
                var enumerator = this;
                subscribe(promise, undefined, function (value) {
                    return enumerator._settledAt(FULFILLED, i, value);
                }, function (reason) {
                    return enumerator._settledAt(REJECTED, i, reason);
                });
            };
            return Enumerator;
        }();
        /**
          `Promise.all` accepts an array of promises, and returns a new promise which
          is fulfilled with an array of fulfillment values for the passed promises, or
          rejected with the reason of the first passed promise to be rejected. It casts all
          elements of the passed iterable to promises as it runs this algorithm.
        
          Example:
        
          ```javascript
          let promise1 = resolve(1);
          let promise2 = resolve(2);
          let promise3 = resolve(3);
          let promises = [ promise1, promise2, promise3 ];
        
          Promise.all(promises).then(function(array){
            // The array here would be [ 1, 2, 3 ];
          });
          ```
        
          If any of the `promises` given to `all` are rejected, the first promise
          that is rejected will be given as an argument to the returned promises's
          rejection handler. For example:
        
          Example:
        
          ```javascript
          let promise1 = resolve(1);
          let promise2 = reject(new Error("2"));
          let promise3 = reject(new Error("3"));
          let promises = [ promise1, promise2, promise3 ];
        
          Promise.all(promises).then(function(array){
            // Code here never runs because there are rejected promises!
          }, function(error) {
            // error.message === "2"
          });
          ```
        
          @method all
          @static
          @param {Array} entries array of promises
          @param {String} label optional string for labeling the promise.
          Useful for tooling.
          @return {Promise} promise that is fulfilled when all `promises` have been
          fulfilled, or rejected if any of them become rejected.
          @static
        */
        function all(entries) {
            return new Enumerator(this, entries).promise;
        }
        /**
          `Promise.race` returns a new promise which is settled in the same way as the
          first passed promise to settle.
        
          Example:
        
          ```javascript
          let promise1 = new Promise(function(resolve, reject){
            setTimeout(function(){
              resolve('promise 1');
            }, 200);
          });
        
          let promise2 = new Promise(function(resolve, reject){
            setTimeout(function(){
              resolve('promise 2');
            }, 100);
          });
        
          Promise.race([promise1, promise2]).then(function(result){
            // result === 'promise 2' because it was resolved before promise1
            // was resolved.
          });
          ```
        
          `Promise.race` is deterministic in that only the state of the first
          settled promise matters. For example, even if other promises given to the
          `promises` array argument are resolved, but the first settled promise has
          become rejected before the other promises became fulfilled, the returned
          promise will become rejected:
        
          ```javascript
          let promise1 = new Promise(function(resolve, reject){
            setTimeout(function(){
              resolve('promise 1');
            }, 200);
          });
        
          let promise2 = new Promise(function(resolve, reject){
            setTimeout(function(){
              reject(new Error('promise 2'));
            }, 100);
          });
        
          Promise.race([promise1, promise2]).then(function(result){
            // Code here never runs
          }, function(reason){
            // reason.message === 'promise 2' because promise 2 became rejected before
            // promise 1 became fulfilled
          });
          ```
        
          An example real-world use case is implementing timeouts:
        
          ```javascript
          Promise.race([ajax('foo.json'), timeout(5000)])
          ```
        
          @method race
          @static
          @param {Array} promises array of promises to observe
          Useful for tooling.
          @return {Promise} a promise which settles in the same way as the first passed
          promise to settle.
        */
        function race(entries) {
            /*jshint validthis:true */
            var Constructor = this;
            if (!isArray(entries)) {
                return new Constructor(function (_, reject) {
                    return reject(new TypeError('You must pass an array to race.'));
                });
            }
            else {
                return new Constructor(function (resolve, reject) {
                    var length = entries.length;
                    for (var i = 0; i < length; i++) {
                        Constructor.resolve(entries[i]).then(resolve, reject);
                    }
                });
            }
        }
        /**
          `Promise.reject` returns a promise rejected with the passed `reason`.
          It is shorthand for the following:
        
          ```javascript
          let promise = new Promise(function(resolve, reject){
            reject(new Error('WHOOPS'));
          });
        
          promise.then(function(value){
            // Code here doesn't run because the promise is rejected!
          }, function(reason){
            // reason.message === 'WHOOPS'
          });
          ```
        
          Instead of writing the above, your code now simply becomes the following:
        
          ```javascript
          let promise = Promise.reject(new Error('WHOOPS'));
        
          promise.then(function(value){
            // Code here doesn't run because the promise is rejected!
          }, function(reason){
            // reason.message === 'WHOOPS'
          });
          ```
        
          @method reject
          @static
          @param {Any} reason value that the returned promise will be rejected with.
          Useful for tooling.
          @return {Promise} a promise rejected with the given `reason`.
        */
        function reject$1(reason) {
            /*jshint validthis:true */
            var Constructor = this;
            var promise = new Constructor(noop);
            reject(promise, reason);
            return promise;
        }
        function needsResolver() {
            throw new TypeError('You must pass a resolver function as the first argument to the promise constructor');
        }
        function needsNew() {
            throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.");
        }
        /**
          Promise objects represent the eventual result of an asynchronous operation. The
          primary way of interacting with a promise is through its `then` method, which
          registers callbacks to receive either a promise's eventual value or the reason
          why the promise cannot be fulfilled.
        
          Terminology
          -----------
        
          - `promise` is an object or function with a `then` method whose behavior conforms to this specification.
          - `thenable` is an object or function that defines a `then` method.
          - `value` is any legal JavaScript value (including undefined, a thenable, or a promise).
          - `exception` is a value that is thrown using the throw statement.
          - `reason` is a value that indicates why a promise was rejected.
          - `settled` the final resting state of a promise, fulfilled or rejected.
        
          A promise can be in one of three states: pending, fulfilled, or rejected.
        
          Promises that are fulfilled have a fulfillment value and are in the fulfilled
          state.  Promises that are rejected have a rejection reason and are in the
          rejected state.  A fulfillment value is never a thenable.
        
          Promises can also be said to *resolve* a value.  If this value is also a
          promise, then the original promise's settled state will match the value's
          settled state.  So a promise that *resolves* a promise that rejects will
          itself reject, and a promise that *resolves* a promise that fulfills will
          itself fulfill.
        
        
          Basic Usage:
          ------------
        
          ```js
          let promise = new Promise(function(resolve, reject) {
            // on success
            resolve(value);
        
            // on failure
            reject(reason);
          });
        
          promise.then(function(value) {
            // on fulfillment
          }, function(reason) {
            // on rejection
          });
          ```
        
          Advanced Usage:
          ---------------
        
          Promises shine when abstracting away asynchronous interactions such as
          `XMLHttpRequest`s.
        
          ```js
          function getJSON(url) {
            return new Promise(function(resolve, reject){
              let xhr = new XMLHttpRequest();
        
              xhr.open('GET', url);
              xhr.onreadystatechange = handler;
              xhr.responseType = 'json';
              xhr.setRequestHeader('Accept', 'application/json');
              xhr.send();
        
              function handler() {
                if (this.readyState === this.DONE) {
                  if (this.status === 200) {
                    resolve(this.response);
                  } else {
                    reject(new Error('getJSON: `' + url + '` failed with status: [' + this.status + ']'));
                  }
                }
              };
            });
          }
        
          getJSON('/posts.json').then(function(json) {
            // on fulfillment
          }, function(reason) {
            // on rejection
          });
          ```
        
          Unlike callbacks, promises are great composable primitives.
        
          ```js
          Promise.all([
            getJSON('/posts'),
            getJSON('/comments')
          ]).then(function(values){
            values[0] // => postsJSON
            values[1] // => commentsJSON
        
            return values;
          });
          ```
        
          @class Promise
          @param {Function} resolver
          Useful for tooling.
          @constructor
        */
        var Promise$1 = function () {
            function Promise(resolver) {
                this[PROMISE_ID] = nextId();
                this._result = this._state = undefined;
                this._subscribers = [];
                if (noop !== resolver) {
                    typeof resolver !== 'function' && needsResolver();
                    this instanceof Promise ? initializePromise(this, resolver) : needsNew();
                }
            }
            /**
            The primary way of interacting with a promise is through its `then` method,
            which registers callbacks to receive either a promise's eventual value or the
            reason why the promise cannot be fulfilled.
             ```js
            findUser().then(function(user){
              // user is available
            }, function(reason){
              // user is unavailable, and you are given the reason why
            });
            ```
             Chaining
            --------
             The return value of `then` is itself a promise.  This second, 'downstream'
            promise is resolved with the return value of the first promise's fulfillment
            or rejection handler, or rejected if the handler throws an exception.
             ```js
            findUser().then(function (user) {
              return user.name;
            }, function (reason) {
              return 'default name';
            }).then(function (userName) {
              // If `findUser` fulfilled, `userName` will be the user's name, otherwise it
              // will be `'default name'`
            });
             findUser().then(function (user) {
              throw new Error('Found user, but still unhappy');
            }, function (reason) {
              throw new Error('`findUser` rejected and we're unhappy');
            }).then(function (value) {
              // never reached
            }, function (reason) {
              // if `findUser` fulfilled, `reason` will be 'Found user, but still unhappy'.
              // If `findUser` rejected, `reason` will be '`findUser` rejected and we're unhappy'.
            });
            ```
            If the downstream promise does not specify a rejection handler, rejection reasons will be propagated further downstream.
             ```js
            findUser().then(function (user) {
              throw new PedagogicalException('Upstream error');
            }).then(function (value) {
              // never reached
            }).then(function (value) {
              // never reached
            }, function (reason) {
              // The `PedgagocialException` is propagated all the way down to here
            });
            ```
             Assimilation
            ------------
             Sometimes the value you want to propagate to a downstream promise can only be
            retrieved asynchronously. This can be achieved by returning a promise in the
            fulfillment or rejection handler. The downstream promise will then be pending
            until the returned promise is settled. This is called *assimilation*.
             ```js
            findUser().then(function (user) {
              return findCommentsByAuthor(user);
            }).then(function (comments) {
              // The user's comments are now available
            });
            ```
             If the assimliated promise rejects, then the downstream promise will also reject.
             ```js
            findUser().then(function (user) {
              return findCommentsByAuthor(user);
            }).then(function (comments) {
              // If `findCommentsByAuthor` fulfills, we'll have the value here
            }, function (reason) {
              // If `findCommentsByAuthor` rejects, we'll have the reason here
            });
            ```
             Simple Example
            --------------
             Synchronous Example
             ```javascript
            let result;
             try {
              result = findResult();
              // success
            } catch(reason) {
              // failure
            }
            ```
             Errback Example
             ```js
            findResult(function(result, err){
              if (err) {
                // failure
              } else {
                // success
              }
            });
            ```
             Promise Example;
             ```javascript
            findResult().then(function(result){
              // success
            }, function(reason){
              // failure
            });
            ```
             Advanced Example
            --------------
             Synchronous Example
             ```javascript
            let author, books;
             try {
              author = findAuthor();
              books  = findBooksByAuthor(author);
              // success
            } catch(reason) {
              // failure
            }
            ```
             Errback Example
             ```js
             function foundBooks(books) {
             }
             function failure(reason) {
             }
             findAuthor(function(author, err){
              if (err) {
                failure(err);
                // failure
              } else {
                try {
                  findBoooksByAuthor(author, function(books, err) {
                    if (err) {
                      failure(err);
                    } else {
                      try {
                        foundBooks(books);
                      } catch(reason) {
                        failure(reason);
                      }
                    }
                  });
                } catch(error) {
                  failure(err);
                }
                // success
              }
            });
            ```
             Promise Example;
             ```javascript
            findAuthor().
              then(findBooksByAuthor).
              then(function(books){
                // found books
            }).catch(function(reason){
              // something went wrong
            });
            ```
             @method then
            @param {Function} onFulfilled
            @param {Function} onRejected
            Useful for tooling.
            @return {Promise}
            */
            /**
            `catch` is simply sugar for `then(undefined, onRejection)` which makes it the same
            as the catch block of a try/catch statement.
            ```js
            function findAuthor(){
            throw new Error('couldn't find that author');
            }
            // synchronous
            try {
            findAuthor();
            } catch(reason) {
            // something went wrong
            }
            // async with promises
            findAuthor().catch(function(reason){
            // something went wrong
            });
            ```
            @method catch
            @param {Function} onRejection
            Useful for tooling.
            @return {Promise}
            */
            Promise.prototype.catch = function _catch(onRejection) {
                return this.then(null, onRejection);
            };
            /**
              `finally` will be invoked regardless of the promise's fate just as native
              try/catch/finally behaves
            
              Synchronous example:
            
              ```js
              findAuthor() {
                if (Math.random() > 0.5) {
                  throw new Error();
                }
                return new Author();
              }
            
              try {
                return findAuthor(); // succeed or fail
              } catch(error) {
                return findOtherAuther();
              } finally {
                // always runs
                // doesn't affect the return value
              }
              ```
            
              Asynchronous example:
            
              ```js
              findAuthor().catch(function(reason){
                return findOtherAuther();
              }).finally(function(){
                // author was either found, or not
              });
              ```
            
              @method finally
              @param {Function} callback
              @return {Promise}
            */
            Promise.prototype.finally = function _finally(callback) {
                var promise = this;
                var constructor = promise.constructor;
                if (isFunction(callback)) {
                    return promise.then(function (value) {
                        return constructor.resolve(callback()).then(function () {
                            return value;
                        });
                    }, function (reason) {
                        return constructor.resolve(callback()).then(function () {
                            throw reason;
                        });
                    });
                }
                return promise.then(callback, callback);
            };
            return Promise;
        }();
        Promise$1.prototype.then = then;
        Promise$1.all = all;
        Promise$1.race = race;
        Promise$1.resolve = resolve$1;
        Promise$1.reject = reject$1;
        Promise$1._setScheduler = setScheduler;
        Promise$1._setAsap = setAsap;
        Promise$1._asap = asap;
        /*global self*/
        function polyfill() {
            var local = void 0;
            if (typeof global !== 'undefined') {
                local = global;
            }
            else if (typeof self !== 'undefined') {
                local = self;
            }
            else {
                try {
                    local = Function('return this')();
                }
                catch (e) {
                    throw new Error('polyfill failed because global object is unavailable in this environment');
                }
            }
            var P = local.Promise;
            if (P) {
                var promiseToString = null;
                try {
                    promiseToString = Object.prototype.toString.call(P.resolve());
                }
                catch (e) {
                    // silently ignored
                }
                if (promiseToString === '[object Promise]' && !P.cast) {
                    return;
                }
            }
            local.Promise = Promise$1;
        }
        // Strange compat..
        Promise$1.polyfill = polyfill;
        Promise$1.Promise = Promise$1;
        return Promise$1;
    })));
},
/* main.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    tslib_1.__exportStar(require(117) /* ./index */, exports);
},
/* index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var version_1 = require(118) /* ./version */;
    __esExport("version", version_1.version);
    var embed_1 = require(119) /* ./embed */;
    __esExport("index", embed_1.index);
    exports.embed = tslib_1.__importStar(require(119) /* ./embed */);
    exports.protocol = tslib_1.__importStar(require(519) /* ./protocol */);
    exports._testing = tslib_1.__importStar(require(520) /* ./testing */);
    var logging_1 = require(134) /* ./core/logging */;
    __esExport("logger", logging_1.logger);
    __esExport("set_log_level", logging_1.set_log_level);
    var settings_1 = require(143) /* ./core/settings */;
    __esExport("settings", settings_1.settings);
    var base_1 = require(122) /* ./base */;
    __esExport("Models", base_1.Models);
    var document_1 = require(120) /* ./document */;
    __esExport("documents", document_1.documents);
    var safely_1 = require(521) /* ./safely */;
    __esExport("safely", safely_1.safely);
},
/* version.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.version = "2.3.1";
},
/* embed/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var document_1 = require(120) /* ../document */;
    var logging_1 = require(134) /* ../core/logging */;
    var string_1 = require(149) /* ../core/util/string */;
    var object_1 = require(128) /* ../core/util/object */;
    var types_1 = require(123) /* ../core/util/types */;
    var defer_1 = require(131) /* ../core/util/defer */;
    var standalone_1 = require(510) /* ./standalone */;
    var server_1 = require(512) /* ./server */;
    var dom_1 = require(511) /* ./dom */;
    var standalone_2 = require(510) /* ./standalone */;
    __esExport("add_document_standalone", standalone_2.add_document_standalone);
    __esExport("index", standalone_2.index);
    var server_2 = require(512) /* ./server */;
    __esExport("add_document_from_session", server_2.add_document_from_session);
    var notebook_1 = require(517) /* ./notebook */;
    __esExport("embed_items_notebook", notebook_1.embed_items_notebook);
    __esExport("kernels", notebook_1.kernels);
    var dom_2 = require(511) /* ./dom */;
    __esExport("BOKEH_ROOT", dom_2.BOKEH_ROOT);
    function embed_item(item, target_id) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var docs_json, doc_id, element, roots, render_item, _a, views;
            var _b;
            return tslib_1.__generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        docs_json = {};
                        doc_id = string_1.uuid4();
                        docs_json[doc_id] = item.doc;
                        if (target_id == null)
                            target_id = item.target_id;
                        element = document.getElementById(target_id);
                        if (element != null)
                            element.classList.add(dom_1.BOKEH_ROOT);
                        roots = (_b = {}, _b[item.root_id] = target_id, _b);
                        render_item = { roots: roots, root_ids: [item.root_id], docid: doc_id };
                        return [4 /*yield*/, defer_1.defer()];
                    case 1:
                        _c.sent();
                        return [4 /*yield*/, _embed_items(docs_json, [render_item])];
                    case 2:
                        _a = tslib_1.__read.apply(void 0, [_c.sent(), 1]), views = _a[0];
                        return [2 /*return*/, views];
                }
            });
        });
    }
    exports.embed_item = embed_item;
    // TODO (bev) this is currently clunky. Standalone embeds only provide
    // the first two args, whereas server provide the app_app, and *may* prove and
    // absolute_url as well if non-relative links are needed for resources. This function
    // should probably be split in to two pieces to reflect the different usage patterns
    function embed_items(docs_json, render_items, app_path, absolute_url) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, defer_1.defer()];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, _embed_items(docs_json, render_items, app_path, absolute_url)];
                }
            });
        });
    }
    exports.embed_items = embed_items;
    function _embed_items(docs_json, render_items, app_path, absolute_url) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var docs, _a, _b, _c, docid, doc_json, views, render_items_1, render_items_1_1, item, element, roots, _d, _e, websocket_url, _f, _g, error_1, e_1_1;
            var e_2, _h, e_1, _j;
            return tslib_1.__generator(this, function (_k) {
                switch (_k.label) {
                    case 0:
                        if (types_1.isString(docs_json))
                            docs_json = JSON.parse(string_1.unescape(docs_json));
                        docs = {};
                        try {
                            for (_a = tslib_1.__values(object_1.entries(docs_json)), _b = _a.next(); !_b.done; _b = _a.next()) {
                                _c = tslib_1.__read(_b.value, 2), docid = _c[0], doc_json = _c[1];
                                docs[docid] = document_1.Document.from_json(doc_json);
                            }
                        }
                        catch (e_2_1) {
                            e_2 = { error: e_2_1 };
                        }
                        finally {
                            try {
                                if (_b && !_b.done && (_h = _a.return))
                                    _h.call(_a);
                            }
                            finally {
                                if (e_2)
                                    throw e_2.error;
                            }
                        }
                        views = [];
                        _k.label = 1;
                    case 1:
                        _k.trys.push([1, 12, 13, 14]);
                        render_items_1 = tslib_1.__values(render_items), render_items_1_1 = render_items_1.next();
                        _k.label = 2;
                    case 2:
                        if (!!render_items_1_1.done)
                            return [3 /*break*/, 11];
                        item = render_items_1_1.value;
                        element = dom_1._resolve_element(item);
                        roots = dom_1._resolve_root_elements(item);
                        if (!(item.docid != null))
                            return [3 /*break*/, 4];
                        _e = (_d = views).push;
                        return [4 /*yield*/, standalone_1.add_document_standalone(docs[item.docid], element, roots, item.use_for_title)];
                    case 3:
                        _e.apply(_d, [_k.sent()]);
                        return [3 /*break*/, 10];
                    case 4:
                        if (!(item.token != null))
                            return [3 /*break*/, 9];
                        websocket_url = server_1._get_ws_url(app_path, absolute_url);
                        logging_1.logger.debug("embed: computed ws url: " + websocket_url);
                        _k.label = 5;
                    case 5:
                        _k.trys.push([5, 7, , 8]);
                        _g = (_f = views).push;
                        return [4 /*yield*/, server_1.add_document_from_session(websocket_url, item.token, element, roots, item.use_for_title)];
                    case 6:
                        _g.apply(_f, [_k.sent()]);
                        console.log("Bokeh items were rendered successfully");
                        return [3 /*break*/, 8];
                    case 7:
                        error_1 = _k.sent();
                        console.log("Error rendering Bokeh items:", error_1);
                        return [3 /*break*/, 8];
                    case 8: return [3 /*break*/, 10];
                    case 9: throw new Error("Error rendering Bokeh items: either 'docid' or 'token' was expected.");
                    case 10:
                        render_items_1_1 = render_items_1.next();
                        return [3 /*break*/, 2];
                    case 11: return [3 /*break*/, 14];
                    case 12:
                        e_1_1 = _k.sent();
                        e_1 = { error: e_1_1 };
                        return [3 /*break*/, 14];
                    case 13:
                        try {
                            if (render_items_1_1 && !render_items_1_1.done && (_j = render_items_1.return))
                                _j.call(render_items_1);
                        }
                        finally {
                            if (e_1)
                                throw e_1.error;
                        }
                        return [7 /*endfinally*/];
                    case 14: return [2 /*return*/, views];
                }
            });
        });
    }
},
/* document/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    tslib_1.__exportStar(require(121) /* ./document */, exports);
    tslib_1.__exportStar(require(150) /* ./events */, exports);
},
/* document/document.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var base_1 = require(122) /* ../base */;
    var version_1 = require(118) /* ../version */;
    var logging_1 = require(134) /* ../core/logging */;
    var bokeh_events_1 = require(379) /* ../core/bokeh_events */;
    var has_props_1 = require(129) /* ../core/has_props */;
    var serializer_1 = require(145) /* ../core/serializer */;
    var signaling_1 = require(130) /* ../core/signaling */;
    var refs_1 = require(132) /* ../core/util/refs */;
    var serialization_1 = require(146) /* ../core/util/serialization */;
    var array_1 = require(124) /* ../core/util/array */;
    var object_1 = require(128) /* ../core/util/object */;
    var sets = tslib_1.__importStar(require(247) /* ../core/util/set */);
    var eq_1 = require(141) /* ../core/util/eq */;
    var types_1 = require(123) /* ../core/util/types */;
    var layout_dom_1 = require(434) /* ../models/layouts/layout_dom */;
    var column_data_source_1 = require(245) /* ../models/sources/column_data_source */;
    var model_1 = require(168) /* ../model */;
    var defs_1 = require(509) /* ./defs */;
    var events_1 = require(150) /* ./events */;
    // Dispatches events to the subscribed models
    var EventManager = /** @class */ (function () {
        function EventManager(document) {
            this.document = document;
            this.session = null;
            this.subscribed_models = new Set();
        }
        EventManager.prototype.send_event = function (bokeh_event) {
            var event = new events_1.MessageSentEvent(this.document, "bokeh_event", bokeh_event.to_json());
            this.document._trigger_on_change(event);
        };
        EventManager.prototype.trigger = function (event) {
            var e_1, _a;
            try {
                for (var _b = tslib_1.__values(this.subscribed_models), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var model = _c.value;
                    if (event.origin != null && event.origin != model)
                        continue;
                    model._process_event(event);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        return EventManager;
    }());
    exports.EventManager = EventManager;
    EventManager.__name__ = "EventManager";
    exports.documents = [];
    exports.DEFAULT_TITLE = "Bokeh Application";
    // This class should match the API of the Python Document class
    // as much as possible.
    var Document = /** @class */ (function () {
        function Document(options) {
            var _a;
            exports.documents.push(this);
            this._init_timestamp = Date.now();
            this._resolver = (_a = options === null || options === void 0 ? void 0 : options.resolver) !== null && _a !== void 0 ? _a : new base_1.ModelResolver();
            this._title = exports.DEFAULT_TITLE;
            this._roots = [];
            this._all_models = new Map();
            this._all_models_freeze_count = 0;
            this._callbacks = new Map();
            this._message_callbacks = new Map();
            this.event_manager = new EventManager(this);
            this.idle = new signaling_1.Signal0(this, "idle");
            this._idle_roots = new WeakMap(); // TODO: WeakSet would be better
            this._interactive_timestamp = null;
            this._interactive_plot = null;
        }
        Object.defineProperty(Document.prototype, "layoutables", {
            get: function () {
                return this._roots.filter(function (root) { return root instanceof layout_dom_1.LayoutDOM; });
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Document.prototype, "is_idle", {
            get: function () {
                var e_2, _a;
                try {
                    for (var _b = tslib_1.__values(this.layoutables), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var root = _c.value;
                        if (!this._idle_roots.has(root))
                            return false;
                    }
                }
                catch (e_2_1) {
                    e_2 = { error: e_2_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_2)
                            throw e_2.error;
                    }
                }
                return true;
            },
            enumerable: false,
            configurable: true
        });
        Document.prototype.notify_idle = function (model) {
            this._idle_roots.set(model, true);
            if (this.is_idle) {
                logging_1.logger.info("document idle at " + (Date.now() - this._init_timestamp) + " ms");
                this.event_manager.send_event(new bokeh_events_1.DocumentReady());
                this.idle.emit();
            }
        };
        Document.prototype.clear = function () {
            this._push_all_models_freeze();
            try {
                while (this._roots.length > 0) {
                    this.remove_root(this._roots[0]);
                }
            }
            finally {
                this._pop_all_models_freeze();
            }
        };
        Document.prototype.interactive_start = function (plot) {
            if (this._interactive_plot == null) {
                this._interactive_plot = plot;
                this._interactive_plot.trigger_event(new bokeh_events_1.LODStart());
            }
            this._interactive_timestamp = Date.now();
        };
        Document.prototype.interactive_stop = function () {
            if (this._interactive_plot != null) {
                this._interactive_plot.trigger_event(new bokeh_events_1.LODEnd());
            }
            this._interactive_plot = null;
            this._interactive_timestamp = null;
        };
        Document.prototype.interactive_duration = function () {
            if (this._interactive_timestamp == null)
                return -1;
            else
                return Date.now() - this._interactive_timestamp;
        };
        Document.prototype.destructively_move = function (dest_doc) {
            var e_3, _a, e_4, _b;
            if (dest_doc === this) {
                throw new Error("Attempted to overwrite a document with itself");
            }
            dest_doc.clear();
            // we have to remove ALL roots before adding any
            // to the new doc or else models referenced from multiple
            // roots could be in both docs at once, which isn't allowed.
            var roots = array_1.copy(this._roots);
            this.clear();
            try {
                for (var roots_1 = tslib_1.__values(roots), roots_1_1 = roots_1.next(); !roots_1_1.done; roots_1_1 = roots_1.next()) {
                    var root = roots_1_1.value;
                    if (root.document != null)
                        throw new Error("Somehow we didn't detach " + root);
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (roots_1_1 && !roots_1_1.done && (_a = roots_1.return))
                        _a.call(roots_1);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            if (this._all_models.size != 0) {
                throw new Error("this._all_models still had stuff in it: " + this._all_models);
            }
            try {
                for (var roots_2 = tslib_1.__values(roots), roots_2_1 = roots_2.next(); !roots_2_1.done; roots_2_1 = roots_2.next()) {
                    var root = roots_2_1.value;
                    dest_doc.add_root(root);
                }
            }
            catch (e_4_1) {
                e_4 = { error: e_4_1 };
            }
            finally {
                try {
                    if (roots_2_1 && !roots_2_1.done && (_b = roots_2.return))
                        _b.call(roots_2);
                }
                finally {
                    if (e_4)
                        throw e_4.error;
                }
            }
            dest_doc.set_title(this._title);
        };
        // TODO other fields of doc
        Document.prototype._push_all_models_freeze = function () {
            this._all_models_freeze_count += 1;
        };
        Document.prototype._pop_all_models_freeze = function () {
            this._all_models_freeze_count -= 1;
            if (this._all_models_freeze_count === 0) {
                this._recompute_all_models();
            }
        };
        /*protected*/ Document.prototype._invalidate_all_models = function () {
            logging_1.logger.debug("invalidating document models");
            // if freeze count is > 0, we'll recompute on unfreeze
            if (this._all_models_freeze_count === 0) {
                this._recompute_all_models();
            }
        };
        Document.prototype._recompute_all_models = function () {
            var e_5, _a, e_6, _b, e_7, _c, e_8, _d;
            var new_all_models_set = new Set();
            try {
                for (var _e = tslib_1.__values(this._roots), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var r = _f.value;
                    new_all_models_set = sets.union(new_all_models_set, r.references());
                }
            }
            catch (e_5_1) {
                e_5 = { error: e_5_1 };
            }
            finally {
                try {
                    if (_f && !_f.done && (_a = _e.return))
                        _a.call(_e);
                }
                finally {
                    if (e_5)
                        throw e_5.error;
                }
            }
            var old_all_models_set = new Set(this._all_models.values());
            var to_detach = sets.difference(old_all_models_set, new_all_models_set);
            var to_attach = sets.difference(new_all_models_set, old_all_models_set);
            var recomputed = new Map();
            try {
                for (var new_all_models_set_1 = tslib_1.__values(new_all_models_set), new_all_models_set_1_1 = new_all_models_set_1.next(); !new_all_models_set_1_1.done; new_all_models_set_1_1 = new_all_models_set_1.next()) {
                    var model = new_all_models_set_1_1.value;
                    recomputed.set(model.id, model);
                }
            }
            catch (e_6_1) {
                e_6 = { error: e_6_1 };
            }
            finally {
                try {
                    if (new_all_models_set_1_1 && !new_all_models_set_1_1.done && (_b = new_all_models_set_1.return))
                        _b.call(new_all_models_set_1);
                }
                finally {
                    if (e_6)
                        throw e_6.error;
                }
            }
            try {
                for (var to_detach_1 = tslib_1.__values(to_detach), to_detach_1_1 = to_detach_1.next(); !to_detach_1_1.done; to_detach_1_1 = to_detach_1.next()) {
                    var d = to_detach_1_1.value;
                    d.detach_document();
                }
            }
            catch (e_7_1) {
                e_7 = { error: e_7_1 };
            }
            finally {
                try {
                    if (to_detach_1_1 && !to_detach_1_1.done && (_c = to_detach_1.return))
                        _c.call(to_detach_1);
                }
                finally {
                    if (e_7)
                        throw e_7.error;
                }
            }
            try {
                for (var to_attach_1 = tslib_1.__values(to_attach), to_attach_1_1 = to_attach_1.next(); !to_attach_1_1.done; to_attach_1_1 = to_attach_1.next()) {
                    var a = to_attach_1_1.value;
                    a.attach_document(this);
                }
            }
            catch (e_8_1) {
                e_8 = { error: e_8_1 };
            }
            finally {
                try {
                    if (to_attach_1_1 && !to_attach_1_1.done && (_d = to_attach_1.return))
                        _d.call(to_attach_1);
                }
                finally {
                    if (e_8)
                        throw e_8.error;
                }
            }
            this._all_models = recomputed;
        };
        Document.prototype.roots = function () {
            return this._roots;
        };
        Document.prototype.add_root = function (model, setter_id) {
            logging_1.logger.debug("Adding root: " + model);
            if (array_1.includes(this._roots, model))
                return;
            this._push_all_models_freeze();
            try {
                this._roots.push(model);
            }
            finally {
                this._pop_all_models_freeze();
            }
            this._trigger_on_change(new events_1.RootAddedEvent(this, model, setter_id));
        };
        Document.prototype.remove_root = function (model, setter_id) {
            var i = this._roots.indexOf(model);
            if (i < 0)
                return;
            this._push_all_models_freeze();
            try {
                this._roots.splice(i, 1);
            }
            finally {
                this._pop_all_models_freeze();
            }
            this._trigger_on_change(new events_1.RootRemovedEvent(this, model, setter_id));
        };
        Document.prototype.title = function () {
            return this._title;
        };
        Document.prototype.set_title = function (title, setter_id) {
            if (title !== this._title) {
                this._title = title;
                this._trigger_on_change(new events_1.TitleChangedEvent(this, title, setter_id));
            }
        };
        Document.prototype.get_model_by_id = function (model_id) {
            var _a;
            return (_a = this._all_models.get(model_id)) !== null && _a !== void 0 ? _a : null;
        };
        Document.prototype.get_model_by_name = function (name) {
            var e_9, _a;
            var found = [];
            try {
                for (var _b = tslib_1.__values(this._all_models.values()), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var model = _c.value;
                    if (model instanceof model_1.Model && model.name == name)
                        found.push(model);
                }
            }
            catch (e_9_1) {
                e_9 = { error: e_9_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_9)
                        throw e_9.error;
                }
            }
            switch (found.length) {
                case 0:
                    return null;
                case 1:
                    return found[0];
                default:
                    throw new Error("Multiple models are named '" + name + "'");
            }
        };
        Document.prototype.on_message = function (msg_type, callback) {
            var message_callbacks = this._message_callbacks.get(msg_type);
            if (message_callbacks == null)
                this._message_callbacks.set(msg_type, new Set([callback]));
            else
                message_callbacks.add(callback);
        };
        Document.prototype.remove_on_message = function (msg_type, callback) {
            var _a;
            (_a = this._message_callbacks.get(msg_type)) === null || _a === void 0 ? void 0 : _a.delete(callback);
        };
        Document.prototype._trigger_on_message = function (msg_type, msg_data) {
            var e_10, _a;
            var message_callbacks = this._message_callbacks.get(msg_type);
            if (message_callbacks != null) {
                try {
                    for (var message_callbacks_1 = tslib_1.__values(message_callbacks), message_callbacks_1_1 = message_callbacks_1.next(); !message_callbacks_1_1.done; message_callbacks_1_1 = message_callbacks_1.next()) {
                        var cb = message_callbacks_1_1.value;
                        cb(msg_data);
                    }
                }
                catch (e_10_1) {
                    e_10 = { error: e_10_1 };
                }
                finally {
                    try {
                        if (message_callbacks_1_1 && !message_callbacks_1_1.done && (_a = message_callbacks_1.return))
                            _a.call(message_callbacks_1);
                    }
                    finally {
                        if (e_10)
                            throw e_10.error;
                    }
                }
            }
        };
        Document.prototype.on_change = function (callback, allow_batches) {
            if (allow_batches === void 0) {
                allow_batches = false;
            }
            if (!this._callbacks.has(callback)) {
                this._callbacks.set(callback, allow_batches);
            }
        };
        Document.prototype.remove_on_change = function (callback) {
            this._callbacks.delete(callback);
        };
        Document.prototype._trigger_on_change = function (event) {
            var e_11, _a, e_12, _b;
            try {
                for (var _c = tslib_1.__values(this._callbacks), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var _e = tslib_1.__read(_d.value, 2), callback = _e[0], allow_batches = _e[1];
                    if (!allow_batches && event instanceof events_1.DocumentEventBatch) {
                        try {
                            for (var _f = (e_12 = void 0, tslib_1.__values(event.events)), _g = _f.next(); !_g.done; _g = _f.next()) {
                                var ev = _g.value;
                                callback(ev);
                            }
                        }
                        catch (e_12_1) {
                            e_12 = { error: e_12_1 };
                        }
                        finally {
                            try {
                                if (_g && !_g.done && (_b = _f.return))
                                    _b.call(_f);
                            }
                            finally {
                                if (e_12)
                                    throw e_12.error;
                            }
                        }
                    }
                    else {
                        callback(event); // TODO
                    }
                }
            }
            catch (e_11_1) {
                e_11 = { error: e_11_1 };
            }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return))
                        _a.call(_c);
                }
                finally {
                    if (e_11)
                        throw e_11.error;
                }
            }
        };
        Document.prototype._notify_change = function (model, attr, old_value, new_value, options) {
            this._trigger_on_change(new events_1.ModelChangedEvent(this, model, attr, old_value, new_value, options === null || options === void 0 ? void 0 : options.setter_id, options === null || options === void 0 ? void 0 : options.hint));
        };
        Document._instantiate_object = function (obj_id, obj_type, obj_attrs, resolver) {
            var full_attrs = tslib_1.__assign(tslib_1.__assign({}, obj_attrs), { id: obj_id, __deferred__: true });
            var model = resolver.get(obj_type);
            return new model(full_attrs);
        };
        // given a JSON representation of all models in a graph, return a
        // dict of new model objects
        Document._instantiate_references_json = function (references_json, existing_models, resolver) {
            var e_13, _a;
            var _b;
            // Create all instances, but without setting their props
            var references = new Map();
            try {
                for (var references_json_1 = tslib_1.__values(references_json), references_json_1_1 = references_json_1.next(); !references_json_1_1.done; references_json_1_1 = references_json_1.next()) {
                    var obj = references_json_1_1.value;
                    var obj_id = obj.id;
                    var obj_type = obj.type;
                    var obj_attrs = (_b = obj.attributes) !== null && _b !== void 0 ? _b : {};
                    var instance = existing_models.get(obj_id);
                    if (instance == null) {
                        instance = Document._instantiate_object(obj_id, obj_type, obj_attrs, resolver);
                        if (obj.subtype != null)
                            instance.set_subtype(obj.subtype);
                    }
                    references.set(instance.id, instance);
                }
            }
            catch (e_13_1) {
                e_13 = { error: e_13_1 };
            }
            finally {
                try {
                    if (references_json_1_1 && !references_json_1_1.done && (_a = references_json_1.return))
                        _a.call(references_json_1);
                }
                finally {
                    if (e_13)
                        throw e_13.error;
                }
            }
            return references;
        };
        // if v looks like a ref, or a collection, resolve it, otherwise return it unchanged
        // recurse into collections but not into HasProps
        Document._resolve_refs = function (value, old_references, new_references, buffers) {
            function resolve_ref(v) {
                var _a;
                if (refs_1.is_ref(v)) {
                    var obj = (_a = old_references.get(v.id)) !== null && _a !== void 0 ? _a : new_references.get(v.id);
                    if (obj != null)
                        return obj;
                    else
                        throw new Error("reference " + JSON.stringify(v) + " isn't known (not in Document?)");
                }
                else if (serialization_1.is_NDArray_ref(v)) {
                    return serialization_1.decode_NDArray(v, buffers);
                }
                else if (types_1.isArray(v))
                    return resolve_array(v);
                else if (types_1.isPlainObject(v))
                    return resolve_dict(v);
                else
                    return v;
            }
            function resolve_array(array) {
                var e_14, _a;
                var results = [];
                try {
                    for (var array_2 = tslib_1.__values(array), array_2_1 = array_2.next(); !array_2_1.done; array_2_1 = array_2.next()) {
                        var v = array_2_1.value;
                        results.push(resolve_ref(v));
                    }
                }
                catch (e_14_1) {
                    e_14 = { error: e_14_1 };
                }
                finally {
                    try {
                        if (array_2_1 && !array_2_1.done && (_a = array_2.return))
                            _a.call(array_2);
                    }
                    finally {
                        if (e_14)
                            throw e_14.error;
                    }
                }
                return results;
            }
            function resolve_dict(dict) {
                var e_15, _a;
                var resolved = {};
                try {
                    for (var _b = tslib_1.__values(object_1.entries(dict)), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var _d = tslib_1.__read(_c.value, 2), k = _d[0], v = _d[1];
                        resolved[k] = resolve_ref(v);
                    }
                }
                catch (e_15_1) {
                    e_15 = { error: e_15_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_15)
                            throw e_15.error;
                    }
                }
                return resolved;
            }
            return resolve_ref(value);
        };
        // given a JSON representation of all models in a graph and new
        // model instances, set the properties on the models from the
        // JSON
        Document._initialize_references_json = function (references_json, old_references, new_references, buffers) {
            var e_16, _a, e_17, _b, e_18, _c;
            var to_update = new Map();
            try {
                for (var references_json_2 = tslib_1.__values(references_json), references_json_2_1 = references_json_2.next(); !references_json_2_1.done; references_json_2_1 = references_json_2.next()) {
                    var _d = references_json_2_1.value, id = _d.id, attributes = _d.attributes;
                    var is_new = !old_references.has(id);
                    var instance = is_new ? new_references.get(id) : old_references.get(id);
                    // replace references with actual instances in obj_attrs
                    var resolved_attrs = Document._resolve_refs(attributes, old_references, new_references, buffers);
                    instance.setv(resolved_attrs, { silent: true });
                    to_update.set(id, { instance: instance, is_new: is_new });
                }
            }
            catch (e_16_1) {
                e_16 = { error: e_16_1 };
            }
            finally {
                try {
                    if (references_json_2_1 && !references_json_2_1.done && (_a = references_json_2.return))
                        _a.call(references_json_2);
                }
                finally {
                    if (e_16)
                        throw e_16.error;
                }
            }
            var ordered_instances = [];
            var handled = new Set();
            function finalize_all_by_dfs(v) {
                var e_19, _a, e_20, _b, e_21, _c;
                if (v instanceof has_props_1.HasProps) {
                    // note that we ignore instances that aren't updated (not in to_update)
                    if (to_update.has(v.id) && !handled.has(v.id)) {
                        handled.add(v.id);
                        var _d = to_update.get(v.id), instance = _d.instance, is_new = _d.is_new;
                        var attributes = instance.attributes;
                        try {
                            for (var _e = tslib_1.__values(object_1.values(attributes)), _f = _e.next(); !_f.done; _f = _e.next()) {
                                var value = _f.value;
                                finalize_all_by_dfs(value);
                            }
                        }
                        catch (e_19_1) {
                            e_19 = { error: e_19_1 };
                        }
                        finally {
                            try {
                                if (_f && !_f.done && (_a = _e.return))
                                    _a.call(_e);
                            }
                            finally {
                                if (e_19)
                                    throw e_19.error;
                            }
                        }
                        if (is_new) {
                            // Finalizing here just to avoid iterating
                            // over `ordered_instances` twice.
                            instance.finalize();
                            // Preserving an ordered collection of instances
                            // to avoid having to go through DFS again.
                            ordered_instances.push(instance);
                        }
                    }
                }
                else if (types_1.isArray(v)) {
                    try {
                        for (var v_1 = tslib_1.__values(v), v_1_1 = v_1.next(); !v_1_1.done; v_1_1 = v_1.next()) {
                            var e = v_1_1.value;
                            finalize_all_by_dfs(e);
                        }
                    }
                    catch (e_20_1) {
                        e_20 = { error: e_20_1 };
                    }
                    finally {
                        try {
                            if (v_1_1 && !v_1_1.done && (_b = v_1.return))
                                _b.call(v_1);
                        }
                        finally {
                            if (e_20)
                                throw e_20.error;
                        }
                    }
                }
                else if (types_1.isPlainObject(v)) {
                    try {
                        for (var _g = tslib_1.__values(object_1.values(v)), _h = _g.next(); !_h.done; _h = _g.next()) {
                            var value = _h.value;
                            finalize_all_by_dfs(value);
                        }
                    }
                    catch (e_21_1) {
                        e_21 = { error: e_21_1 };
                    }
                    finally {
                        try {
                            if (_h && !_h.done && (_c = _g.return))
                                _c.call(_g);
                        }
                        finally {
                            if (e_21)
                                throw e_21.error;
                        }
                    }
                }
            }
            try {
                for (var _e = tslib_1.__values(to_update.values()), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var item = _f.value;
                    finalize_all_by_dfs(item.instance);
                }
            }
            catch (e_17_1) {
                e_17 = { error: e_17_1 };
            }
            finally {
                try {
                    if (_f && !_f.done && (_b = _e.return))
                        _b.call(_e);
                }
                finally {
                    if (e_17)
                        throw e_17.error;
                }
            }
            try {
                // `connect_signals` has to be executed last because it
                // may rely on properties of dependencies that are initialized
                // only in `finalize`. It's a problem that appears when
                // there are circular references, e.g. as in
                // CDS -> CustomJS (on data change) -> GlyphRenderer (in args) -> CDS.
                for (var ordered_instances_1 = tslib_1.__values(ordered_instances), ordered_instances_1_1 = ordered_instances_1.next(); !ordered_instances_1_1.done; ordered_instances_1_1 = ordered_instances_1.next()) {
                    var instance = ordered_instances_1_1.value;
                    instance.connect_signals();
                }
            }
            catch (e_18_1) {
                e_18 = { error: e_18_1 };
            }
            finally {
                try {
                    if (ordered_instances_1_1 && !ordered_instances_1_1.done && (_c = ordered_instances_1.return))
                        _c.call(ordered_instances_1);
                }
                finally {
                    if (e_18)
                        throw e_18.error;
                }
            }
        };
        //////
        ///{{{
        Document._event_for_attribute_change = function (changed_obj, key, new_value, doc, value_refs) {
            var changed_model = doc.get_model_by_id(changed_obj.id); // XXX!
            if (!changed_model.property(key).syncable)
                return null;
            else {
                var event = {
                    kind: "ModelChanged",
                    model: { id: changed_obj.id },
                    attr: key,
                    new: new_value,
                };
                has_props_1.HasProps._json_record_references(doc, new_value, value_refs, { recursive: true });
                return event;
            }
        };
        Document._events_to_sync_objects = function (from_obj, to_obj, to_doc, value_refs) {
            var e_22, _a, e_23, _b, e_24, _c;
            var from_keys = Object.keys(from_obj.attributes); //XXX!
            var to_keys = Object.keys(to_obj.attributes); //XXX!
            var removed = array_1.difference(from_keys, to_keys);
            var added = array_1.difference(to_keys, from_keys);
            var shared = array_1.intersection(from_keys, to_keys);
            var events = [];
            try {
                for (var removed_1 = tslib_1.__values(removed), removed_1_1 = removed_1.next(); !removed_1_1.done; removed_1_1 = removed_1.next()) {
                    var key = removed_1_1.value;
                    // we don't really have a "remove" event - not sure this ever
                    // happens even. One way this could happen is if the server
                    // does include_defaults=True and we do
                    // include_defaults=false ... in that case it'd be best to
                    // just ignore this probably. Warn about it, could mean
                    // there's a bug if we don't have a key that the server sent.
                    logging_1.logger.warn("Server sent key " + key + " but we don't seem to have it in our JSON");
                }
            }
            catch (e_22_1) {
                e_22 = { error: e_22_1 };
            }
            finally {
                try {
                    if (removed_1_1 && !removed_1_1.done && (_a = removed_1.return))
                        _a.call(removed_1);
                }
                finally {
                    if (e_22)
                        throw e_22.error;
                }
            }
            try {
                for (var added_1 = tslib_1.__values(added), added_1_1 = added_1.next(); !added_1_1.done; added_1_1 = added_1.next()) {
                    var key = added_1_1.value;
                    var new_value = to_obj.attributes[key]; // XXX!
                    events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
                }
            }
            catch (e_23_1) {
                e_23 = { error: e_23_1 };
            }
            finally {
                try {
                    if (added_1_1 && !added_1_1.done && (_b = added_1.return))
                        _b.call(added_1);
                }
                finally {
                    if (e_23)
                        throw e_23.error;
                }
            }
            try {
                for (var shared_1 = tslib_1.__values(shared), shared_1_1 = shared_1.next(); !shared_1_1.done; shared_1_1 = shared_1.next()) {
                    var key = shared_1_1.value;
                    var old_value = from_obj.attributes[key]; // XXX!
                    var new_value = to_obj.attributes[key]; // XXX!
                    if (old_value == null && new_value == null) {
                    }
                    else if (old_value == null || new_value == null) {
                        events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
                    }
                    else {
                        if (!eq_1.is_equal(old_value, new_value))
                            events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
                    }
                }
            }
            catch (e_24_1) {
                e_24 = { error: e_24_1 };
            }
            finally {
                try {
                    if (shared_1_1 && !shared_1_1.done && (_c = shared_1.return))
                        _c.call(shared_1);
                }
                finally {
                    if (e_24)
                        throw e_24.error;
                }
            }
            return events.filter(function (e) { return e != null; });
        };
        // we use this to detect changes during document deserialization
        // (in model constructors and initializers)
        Document._compute_patch_since_json = function (from_json, to_doc) {
            var e_25, _a, e_26, _b, e_27, _c;
            var to_json = to_doc.to_json(false); // include_defaults=false
            function refs(json) {
                var e_28, _a;
                var result = new Map();
                try {
                    for (var _b = tslib_1.__values(json.roots.references), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var obj = _c.value;
                        result.set(obj.id, obj);
                    }
                }
                catch (e_28_1) {
                    e_28 = { error: e_28_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_28)
                            throw e_28.error;
                    }
                }
                return result;
            }
            var from_references = refs(from_json);
            var from_roots = new Map();
            var from_root_ids = [];
            try {
                for (var _d = tslib_1.__values(from_json.roots.root_ids), _e = _d.next(); !_e.done; _e = _d.next()) {
                    var r = _e.value;
                    from_roots.set(r, from_references.get(r));
                    from_root_ids.push(r);
                }
            }
            catch (e_25_1) {
                e_25 = { error: e_25_1 };
            }
            finally {
                try {
                    if (_e && !_e.done && (_a = _d.return))
                        _a.call(_d);
                }
                finally {
                    if (e_25)
                        throw e_25.error;
                }
            }
            var to_references = refs(to_json);
            var to_roots = new Map();
            var to_root_ids = [];
            try {
                for (var _f = tslib_1.__values(to_json.roots.root_ids), _g = _f.next(); !_g.done; _g = _f.next()) {
                    var r = _g.value;
                    to_roots.set(r, to_references.get(r));
                    to_root_ids.push(r);
                }
            }
            catch (e_26_1) {
                e_26 = { error: e_26_1 };
            }
            finally {
                try {
                    if (_g && !_g.done && (_b = _f.return))
                        _b.call(_f);
                }
                finally {
                    if (e_26)
                        throw e_26.error;
                }
            }
            from_root_ids.sort();
            to_root_ids.sort();
            if (array_1.difference(from_root_ids, to_root_ids).length > 0 ||
                array_1.difference(to_root_ids, from_root_ids).length > 0) {
                // this would arise if someone does add_root/remove_root during
                // document deserialization, hopefully they won't ever do so.
                throw new Error("Not implemented: computing add/remove of document roots");
            }
            var value_refs = new Set();
            var events = [];
            try {
                for (var _h = tslib_1.__values(to_doc._all_models.keys()), _j = _h.next(); !_j.done; _j = _h.next()) {
                    var id = _j.value;
                    if (from_references.has(id)) {
                        var update_model_events = Document._events_to_sync_objects(from_references.get(id), to_references.get(id), to_doc, value_refs);
                        events = events.concat(update_model_events);
                    }
                }
            }
            catch (e_27_1) {
                e_27 = { error: e_27_1 };
            }
            finally {
                try {
                    if (_j && !_j.done && (_c = _h.return))
                        _c.call(_h);
                }
                finally {
                    if (e_27)
                        throw e_27.error;
                }
            }
            var serializer = new serializer_1.Serializer({ include_defaults: false });
            serializer.to_serializable(tslib_1.__spread(value_refs));
            return {
                references: tslib_1.__spread(serializer.definitions),
                events: events,
            };
        };
        ///}}}
        //////
        Document.prototype.to_json_string = function (include_defaults) {
            if (include_defaults === void 0) {
                include_defaults = true;
            }
            return JSON.stringify(this.to_json(include_defaults));
        };
        Document.prototype.to_json = function (include_defaults) {
            if (include_defaults === void 0) {
                include_defaults = true;
            }
            var serializer = new serializer_1.Serializer({ include_defaults: include_defaults });
            var roots = serializer.to_serializable(this._roots);
            return {
                version: version_1.version,
                title: this._title,
                roots: {
                    root_ids: roots.map(function (r) { return r.id; }),
                    references: tslib_1.__spread(serializer.definitions),
                },
            };
        };
        Document.from_json_string = function (s) {
            var json = JSON.parse(s);
            return Document.from_json(json);
        };
        Document.from_json = function (json) {
            var e_29, _a;
            logging_1.logger.debug("Creating Document from JSON");
            function pyify(version) {
                return version.replace(/-(dev|rc)\./, "$1");
            }
            var py_version = json.version; // XXX!
            var is_dev = py_version.indexOf('+') !== -1 || py_version.indexOf('-') !== -1;
            var versions_string = "Library versions: JS (" + version_1.version + ") / Python (" + py_version + ")";
            if (!is_dev && pyify(version_1.version) != py_version) {
                logging_1.logger.warn("JS/Python version mismatch");
                logging_1.logger.warn(versions_string);
            }
            else
                logging_1.logger.debug(versions_string);
            var resolver = new base_1.ModelResolver();
            if (json.defs != null) {
                defs_1.resolve_defs(json.defs, resolver);
            }
            var roots_json = json.roots;
            var root_ids = roots_json.root_ids;
            var references_json = roots_json.references;
            var references = Document._instantiate_references_json(references_json, new Map(), resolver);
            Document._initialize_references_json(references_json, new Map(), references, new Map());
            var doc = new Document({ resolver: resolver });
            try {
                for (var root_ids_1 = tslib_1.__values(root_ids), root_ids_1_1 = root_ids_1.next(); !root_ids_1_1.done; root_ids_1_1 = root_ids_1.next()) {
                    var id = root_ids_1_1.value;
                    var root = references.get(id);
                    if (root != null) {
                        doc.add_root(root); // XXX: HasProps
                    }
                }
            }
            catch (e_29_1) {
                e_29 = { error: e_29_1 };
            }
            finally {
                try {
                    if (root_ids_1_1 && !root_ids_1_1.done && (_a = root_ids_1.return))
                        _a.call(root_ids_1);
                }
                finally {
                    if (e_29)
                        throw e_29.error;
                }
            }
            doc.set_title(json.title); // XXX!
            return doc;
        };
        Document.prototype.replace_with_json = function (json) {
            var replacement = Document.from_json(json);
            replacement.destructively_move(this);
        };
        /** @deprecated */
        Document.prototype.create_json_patch_string = function (events) {
            return JSON.stringify(this.create_json_patch(events));
        };
        Document.prototype.create_json_patch = function (events) {
            var e_30, _a, e_31, _b;
            try {
                for (var events_2 = tslib_1.__values(events), events_2_1 = events_2.next(); !events_2_1.done; events_2_1 = events_2.next()) {
                    var event = events_2_1.value;
                    if (event.document != this)
                        throw new Error("Cannot create a patch using events from a different document");
                }
            }
            catch (e_30_1) {
                e_30 = { error: e_30_1 };
            }
            finally {
                try {
                    if (events_2_1 && !events_2_1.done && (_a = events_2.return))
                        _a.call(events_2);
                }
                finally {
                    if (e_30)
                        throw e_30.error;
                }
            }
            var serializer = new serializer_1.Serializer();
            var events_repr = serializer.to_serializable(events);
            try {
                // TODO: We need a proper differential serializer. For now just remove known
                // definitions. We are doing this after a complete serialization, so that all
                // new objects are recorded.
                for (var _c = tslib_1.__values(this._all_models.values()), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var model = _d.value;
                    serializer.remove_def(model);
                }
            }
            catch (e_31_1) {
                e_31 = { error: e_31_1 };
            }
            finally {
                try {
                    if (_d && !_d.done && (_b = _c.return))
                        _b.call(_c);
                }
                finally {
                    if (e_31)
                        throw e_31.error;
                }
            }
            return {
                events: events_repr,
                references: tslib_1.__spread(serializer.definitions),
            };
        };
        Document.prototype.apply_json_patch = function (patch, buffers, setter_id) {
            var e_32, _a, e_33, _b, e_34, _c, _d;
            if (buffers === void 0) {
                buffers = new Map();
            }
            var references_json = patch.references;
            var events_json = patch.events;
            var references = Document._instantiate_references_json(references_json, this._all_models, this._resolver);
            if (!(buffers instanceof Map)) {
                buffers = new Map(buffers);
            }
            try {
                // The model being changed isn't always in references so add it in
                for (var events_json_1 = tslib_1.__values(events_json), events_json_1_1 = events_json_1.next(); !events_json_1_1.done; events_json_1_1 = events_json_1.next()) {
                    var event_json = events_json_1_1.value;
                    switch (event_json.kind) {
                        case "RootAdded":
                        case "RootRemoved":
                        case "ModelChanged": {
                            var model_id = event_json.model.id;
                            var model = this._all_models.get(model_id);
                            if (model != null) {
                                references.set(model_id, model);
                            }
                            else if (!references.has(model_id)) {
                                logging_1.logger.warn("Got an event for unknown model " + event_json.model + "\"");
                                throw new Error("event model wasn't known");
                            }
                            break;
                        }
                    }
                }
            }
            catch (e_32_1) {
                e_32 = { error: e_32_1 };
            }
            finally {
                try {
                    if (events_json_1_1 && !events_json_1_1.done && (_a = events_json_1.return))
                        _a.call(events_json_1);
                }
                finally {
                    if (e_32)
                        throw e_32.error;
                }
            }
            // split references into old and new so we know whether to initialize or update
            var old_references = new Map(this._all_models);
            var new_references = new Map();
            try {
                for (var references_1 = tslib_1.__values(references), references_1_1 = references_1.next(); !references_1_1.done; references_1_1 = references_1.next()) {
                    var _e = tslib_1.__read(references_1_1.value, 2), id = _e[0], value = _e[1];
                    if (!old_references.has(id))
                        new_references.set(id, value);
                }
            }
            catch (e_33_1) {
                e_33 = { error: e_33_1 };
            }
            finally {
                try {
                    if (references_1_1 && !references_1_1.done && (_b = references_1.return))
                        _b.call(references_1);
                }
                finally {
                    if (e_33)
                        throw e_33.error;
                }
            }
            Document._initialize_references_json(references_json, old_references, new_references, buffers);
            try {
                for (var events_json_2 = tslib_1.__values(events_json), events_json_2_1 = events_json_2.next(); !events_json_2_1.done; events_json_2_1 = events_json_2.next()) {
                    var event_json = events_json_2_1.value;
                    switch (event_json.kind) {
                        case 'MessageSent': {
                            var msg_type = event_json.msg_type, msg_data = event_json.msg_data;
                            var data = void 0;
                            if (msg_data === undefined) {
                                if (buffers.size == 1) {
                                    var _f = tslib_1.__read(buffers, 1), _g = tslib_1.__read(_f[0], 2), buffer = _g[1];
                                    data = buffer;
                                }
                                else {
                                    throw new Error("expected exactly one buffer");
                                }
                            }
                            else {
                                data = Document._resolve_refs(msg_data, old_references, new_references, buffers);
                            }
                            this._trigger_on_message(msg_type, data);
                            break;
                        }
                        case 'ModelChanged': {
                            var patched_id = event_json.model.id;
                            var patched_obj = this._all_models.get(patched_id);
                            if (patched_obj == null) {
                                throw new Error("Cannot apply patch to " + patched_id + " which is not in the document");
                            }
                            var attr = event_json.attr;
                            var value = Document._resolve_refs(event_json.new, old_references, new_references, buffers);
                            patched_obj.setv((_d = {}, _d[attr] = value, _d), { setter_id: setter_id });
                            break;
                        }
                        case 'ColumnDataChanged': {
                            var column_source_id = event_json.column_source.id;
                            var column_source = this._all_models.get(column_source_id);
                            if (column_source == null) {
                                throw new Error("Cannot stream to " + column_source_id + " which is not in the document");
                            }
                            var data = Document._resolve_refs(event_json.new, new Map(), new Map(), buffers);
                            if (event_json.cols != null) {
                                for (var k in column_source.data) {
                                    if (!(k in data)) {
                                        data[k] = column_source.data[k];
                                    }
                                }
                            }
                            column_source.setv({ data: data }, { setter_id: setter_id, check_eq: false });
                            break;
                        }
                        case 'ColumnsStreamed': {
                            var column_source_id = event_json.column_source.id;
                            var column_source = this._all_models.get(column_source_id);
                            if (column_source == null) {
                                throw new Error("Cannot stream to " + column_source_id + " which is not in the document");
                            }
                            if (!(column_source instanceof column_data_source_1.ColumnDataSource)) {
                                throw new Error("Cannot stream to non-ColumnDataSource");
                            }
                            var data = event_json.data;
                            var rollover = event_json.rollover;
                            column_source.stream(data, rollover, setter_id);
                            break;
                        }
                        case 'ColumnsPatched': {
                            var column_source_id = event_json.column_source.id;
                            var column_source = this._all_models.get(column_source_id);
                            if (column_source == null) {
                                throw new Error("Cannot patch " + column_source_id + " which is not in the document");
                            }
                            if (!(column_source instanceof column_data_source_1.ColumnDataSource)) {
                                throw new Error("Cannot patch non-ColumnDataSource");
                            }
                            var patches = event_json.patches;
                            column_source.patch(patches, setter_id);
                            break;
                        }
                        case 'RootAdded': {
                            var root_id = event_json.model.id;
                            var root_obj = references.get(root_id);
                            this.add_root(root_obj, setter_id); // XXX: HasProps
                            break;
                        }
                        case 'RootRemoved': {
                            var root_id = event_json.model.id;
                            var root_obj = references.get(root_id);
                            this.remove_root(root_obj, setter_id); // XXX: HasProps
                            break;
                        }
                        case 'TitleChanged': {
                            this.set_title(event_json.title, setter_id);
                            break;
                        }
                        default:
                            throw new Error("Unknown patch event " + JSON.stringify(event_json));
                    }
                }
            }
            catch (e_34_1) {
                e_34 = { error: e_34_1 };
            }
            finally {
                try {
                    if (events_json_2_1 && !events_json_2_1.done && (_c = events_json_2.return))
                        _c.call(events_json_2);
                }
                finally {
                    if (e_34)
                        throw e_34.error;
                }
            }
        };
        return Document;
    }());
    exports.Document = Document;
    Document.__name__ = "Document";
},
/* base.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var types_1 = require(123) /* ./core/util/types */;
    var object_1 = require(128) /* ./core/util/object */;
    var has_props_1 = require(129) /* ./core/has_props */;
    exports.overrides = {};
    var _all_models = new Map();
    exports.Models = (function (name) {
        var model = exports.Models.get(name);
        if (model != null)
            return model;
        else
            throw new Error("Model '" + name + "' does not exist. This could be due to a widget or a custom model not being registered before first usage.");
    });
    exports.Models.get = function (name) {
        var _a;
        return (_a = exports.overrides[name]) !== null && _a !== void 0 ? _a : _all_models.get(name);
    };
    exports.Models.register = function (name, model) {
        exports.overrides[name] = model;
    };
    exports.Models.unregister = function (name) {
        delete exports.overrides[name];
    };
    function is_HasProps(obj) {
        return types_1.isObject(obj) && obj.prototype instanceof has_props_1.HasProps;
    }
    exports.Models.register_models = function (models, force, errorFn) {
        var e_1, _a;
        if (force === void 0) {
            force = false;
        }
        if (models == null)
            return;
        try {
            for (var _b = tslib_1.__values(types_1.isArray(models) ? models : object_1.values(models)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var model = _c.value;
                if (is_HasProps(model)) {
                    var qualified = model.__qualified__;
                    if (force || !_all_models.has(qualified))
                        _all_models.set(qualified, model);
                    else if (errorFn != null)
                        errorFn(qualified);
                    else
                        console.warn("Model '" + qualified + "' was already registered");
                }
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return))
                    _a.call(_b);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
    };
    exports.register_models = exports.Models.register_models;
    exports.Models.registered_names = function () { return tslib_1.__spread(_all_models.keys()); };
    var ModelResolver = /** @class */ (function () {
        function ModelResolver() {
            this._known_models = new Map();
        }
        ModelResolver.prototype.get = function (name, or_else) {
            var _a;
            var model = (_a = exports.Models.get(name)) !== null && _a !== void 0 ? _a : this._known_models.get(name);
            if (model != null)
                return model;
            else if (or_else !== undefined)
                return or_else;
            else
                throw new Error("Model '" + name + "' does not exist. This could be due to a widget or a custom model not being registered before first usage.");
        };
        ModelResolver.prototype.register = function (model) {
            var name = model.__qualified__;
            if (this.get(name, null) == null)
                this._known_models.set(name, model);
            else
                console.warn("Model '" + name + "' was already registered with this resolver");
        };
        return ModelResolver;
    }());
    exports.ModelResolver = ModelResolver;
    ModelResolver.__name__ = "ModelResolver";
    // TODO: this doesn't belong here, but it's easier this way for backwards compatibility
    var AllModels = tslib_1.__importStar(require(153) /* ./models */);
    exports.register_models(AllModels);
},
/* core/util/types.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    //     Underscore.js 1.8.3
    //     http://underscorejs.org
    //     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
    //     Underscore may be freely distributed under the MIT license.
    var array_1 = require(124) /* ./array */;
    var toString = Object.prototype.toString;
    function isBoolean(obj) {
        return obj === true || obj === false || toString.call(obj) === '[object Boolean]';
    }
    exports.isBoolean = isBoolean;
    function isNumber(obj) {
        return toString.call(obj) === "[object Number]";
    }
    exports.isNumber = isNumber;
    function isInteger(obj) {
        return isNumber(obj) && Number.isInteger(obj);
    }
    exports.isInteger = isInteger;
    function isString(obj) {
        return toString.call(obj) === "[object String]";
    }
    exports.isString = isString;
    function isPrimitive(obj) {
        return obj === null || isBoolean(obj) || isNumber(obj) || isString(obj);
    }
    exports.isPrimitive = isPrimitive;
    function isFunction(obj) {
        return toString.call(obj) === "[object Function]";
    }
    exports.isFunction = isFunction;
    function isArray(obj) {
        return Array.isArray(obj);
    }
    exports.isArray = isArray;
    function isArrayOf(arr, predicate) {
        return array_1.every(arr, predicate);
    }
    exports.isArrayOf = isArrayOf;
    function isArrayableOf(arr, predicate) {
        for (var i = 0, end = arr.length; i < end; i++) {
            if (!predicate(arr[i]))
                return false;
        }
        return true;
    }
    exports.isArrayableOf = isArrayableOf;
    function isTypedArray(obj) {
        return ArrayBuffer.isView(obj) && !(obj instanceof DataView);
    }
    exports.isTypedArray = isTypedArray;
    function isObject(obj) {
        var tp = typeof obj;
        return tp === 'function' || tp === 'object' && !!obj;
    }
    exports.isObject = isObject;
    function isPlainObject(obj) {
        return isObject(obj) && (obj.constructor == null || obj.constructor === Object);
    }
    exports.isPlainObject = isPlainObject;
    function isIterable(obj) {
        return isObject(obj) && obj[Symbol.iterator] !== undefined;
    }
    exports.isIterable = isIterable;
    function isArrayable(obj) {
        return isIterable(obj) && "length" in obj;
    }
    exports.isArrayable = isArrayable;
},
/* core/util/array.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    //     Underscore.js 1.8.3
    //     http://underscorejs.org
    //     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
    //     Underscore may be freely distributed under the MIT license.
    var math_1 = require(125) /* ./math */;
    var assert_1 = require(126) /* ./assert */;
    var arrayable_1 = require(127) /* ./arrayable */;
    __esExport("map", arrayable_1.map);
    __esExport("reduce", arrayable_1.reduce);
    __esExport("min", arrayable_1.min);
    __esExport("min_by", arrayable_1.min_by);
    __esExport("max", arrayable_1.max);
    __esExport("max_by", arrayable_1.max_by);
    __esExport("sum", arrayable_1.sum);
    __esExport("cumsum", arrayable_1.cumsum);
    __esExport("every", arrayable_1.every);
    __esExport("some", arrayable_1.some);
    __esExport("find", arrayable_1.find);
    __esExport("find_last", arrayable_1.find_last);
    __esExport("find_index", arrayable_1.find_index);
    __esExport("find_last_index", arrayable_1.find_last_index);
    __esExport("sorted_index", arrayable_1.sorted_index);
    __esExport("is_empty", arrayable_1.is_empty);
    var slice = Array.prototype.slice;
    function head(array) {
        return array[0];
    }
    exports.head = head;
    function tail(array) {
        return array[array.length - 1];
    }
    exports.tail = tail;
    function last(array) {
        return array[array.length - 1];
    }
    exports.last = last;
    function copy(array) {
        return slice.call(array);
    }
    exports.copy = copy;
    function concat(arrays) {
        return [].concat.apply([], tslib_1.__spread(arrays));
    }
    exports.concat = concat;
    function includes(array, value) {
        return array.indexOf(value) !== -1;
    }
    exports.includes = includes;
    exports.contains = includes;
    function nth(array, index) {
        return array[index >= 0 ? index : array.length + index];
    }
    exports.nth = nth;
    function zip() {
        var arrays = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            arrays[_i] = arguments[_i];
        }
        if (arrays.length == 0)
            return [];
        var n = arrayable_1.min(arrays.map(function (a) { return a.length; }));
        var k = arrays.length;
        var result = new Array(n);
        for (var i = 0; i < n; i++) {
            result[i] = new Array(k);
            for (var j = 0; j < k; j++)
                result[i][j] = arrays[j][i];
        }
        return result;
    }
    exports.zip = zip;
    function unzip(array) {
        var n = array.length;
        var k = arrayable_1.min(array.map(function (a) { return a.length; }));
        var results = Array(k);
        for (var j = 0; j < k; j++)
            results[j] = new Array(n);
        for (var i = 0; i < n; i++) {
            for (var j = 0; j < k; j++)
                results[j][i] = array[i][j];
        }
        return results;
    }
    exports.unzip = unzip;
    function range(start, stop, step) {
        if (step === void 0) {
            step = 1;
        }
        assert_1.assert(step > 0, "'step' must be a positive number");
        if (stop == null) {
            stop = start;
            start = 0;
        }
        var max = Math.max, ceil = Math.ceil, abs = Math.abs;
        var delta = start <= stop ? step : -step;
        var length = max(ceil(abs(stop - start) / step), 0);
        var range = new Array(length);
        for (var i = 0; i < length; i++, start += delta) {
            range[i] = start;
        }
        return range;
    }
    exports.range = range;
    function linspace(start, stop, num) {
        if (num === void 0) {
            num = 100;
        }
        var step = (stop - start) / (num - 1);
        var array = new Array(num);
        for (var i = 0; i < num; i++) {
            array[i] = start + step * i;
        }
        return array;
    }
    exports.linspace = linspace;
    function transpose(array) {
        var rows = array.length;
        var cols = array[0].length;
        var transposed = [];
        for (var j = 0; j < cols; j++) {
            transposed[j] = [];
            for (var i = 0; i < rows; i++) {
                transposed[j][i] = array[i][j];
            }
        }
        return transposed;
    }
    exports.transpose = transpose;
    function argmin(array) {
        return arrayable_1.min_by(range(array.length), function (i) { return array[i]; });
    }
    exports.argmin = argmin;
    function argmax(array) {
        return arrayable_1.max_by(range(array.length), function (i) { return array[i]; });
    }
    exports.argmax = argmax;
    function sort_by(array, key) {
        var tmp = array.map(function (value, index) {
            return { value: value, index: index, key: key(value) };
        });
        tmp.sort(function (left, right) {
            var a = left.key;
            var b = right.key;
            if (a !== b) {
                if (a > b || a === undefined)
                    return 1;
                if (a < b || b === undefined)
                    return -1;
            }
            return left.index - right.index;
        });
        return tmp.map(function (item) { return item.value; });
    }
    exports.sort_by = sort_by;
    function uniq(array) {
        var e_1, _a;
        var result = new Set();
        try {
            for (var array_1 = tslib_1.__values(array), array_1_1 = array_1.next(); !array_1_1.done; array_1_1 = array_1.next()) {
                var value = array_1_1.value;
                result.add(value);
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (array_1_1 && !array_1_1.done && (_a = array_1.return))
                    _a.call(array_1);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
        return tslib_1.__spread(result);
    }
    exports.uniq = uniq;
    function uniq_by(array, key) {
        var e_2, _a;
        var result = [];
        var seen = [];
        try {
            for (var array_2 = tslib_1.__values(array), array_2_1 = array_2.next(); !array_2_1.done; array_2_1 = array_2.next()) {
                var value = array_2_1.value;
                var computed = key(value);
                if (!includes(seen, computed)) {
                    seen.push(computed);
                    result.push(value);
                }
            }
        }
        catch (e_2_1) {
            e_2 = { error: e_2_1 };
        }
        finally {
            try {
                if (array_2_1 && !array_2_1.done && (_a = array_2.return))
                    _a.call(array_2);
            }
            finally {
                if (e_2)
                    throw e_2.error;
            }
        }
        return result;
    }
    exports.uniq_by = uniq_by;
    function union() {
        var e_3, _a, e_4, _b;
        var arrays = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            arrays[_i] = arguments[_i];
        }
        var result = new Set();
        try {
            for (var arrays_1 = tslib_1.__values(arrays), arrays_1_1 = arrays_1.next(); !arrays_1_1.done; arrays_1_1 = arrays_1.next()) {
                var array = arrays_1_1.value;
                try {
                    for (var array_3 = (e_4 = void 0, tslib_1.__values(array)), array_3_1 = array_3.next(); !array_3_1.done; array_3_1 = array_3.next()) {
                        var value = array_3_1.value;
                        result.add(value);
                    }
                }
                catch (e_4_1) {
                    e_4 = { error: e_4_1 };
                }
                finally {
                    try {
                        if (array_3_1 && !array_3_1.done && (_b = array_3.return))
                            _b.call(array_3);
                    }
                    finally {
                        if (e_4)
                            throw e_4.error;
                    }
                }
            }
        }
        catch (e_3_1) {
            e_3 = { error: e_3_1 };
        }
        finally {
            try {
                if (arrays_1_1 && !arrays_1_1.done && (_a = arrays_1.return))
                    _a.call(arrays_1);
            }
            finally {
                if (e_3)
                    throw e_3.error;
            }
        }
        return tslib_1.__spread(result);
    }
    exports.union = union;
    function intersection(array) {
        var e_5, _a, e_6, _b;
        var arrays = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            arrays[_i - 1] = arguments[_i];
        }
        var result = [];
        try {
            top: for (var array_4 = tslib_1.__values(array), array_4_1 = array_4.next(); !array_4_1.done; array_4_1 = array_4.next()) {
                var item = array_4_1.value;
                if (includes(result, item))
                    continue;
                try {
                    for (var arrays_2 = (e_6 = void 0, tslib_1.__values(arrays)), arrays_2_1 = arrays_2.next(); !arrays_2_1.done; arrays_2_1 = arrays_2.next()) {
                        var other = arrays_2_1.value;
                        if (!includes(other, item))
                            continue top;
                    }
                }
                catch (e_6_1) {
                    e_6 = { error: e_6_1 };
                }
                finally {
                    try {
                        if (arrays_2_1 && !arrays_2_1.done && (_b = arrays_2.return))
                            _b.call(arrays_2);
                    }
                    finally {
                        if (e_6)
                            throw e_6.error;
                    }
                }
                result.push(item);
            }
        }
        catch (e_5_1) {
            e_5 = { error: e_5_1 };
        }
        finally {
            try {
                if (array_4_1 && !array_4_1.done && (_a = array_4.return))
                    _a.call(array_4);
            }
            finally {
                if (e_5)
                    throw e_5.error;
            }
        }
        return result;
    }
    exports.intersection = intersection;
    function difference(array) {
        var arrays = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            arrays[_i - 1] = arguments[_i];
        }
        var rest = concat(arrays);
        return array.filter(function (value) { return !includes(rest, value); });
    }
    exports.difference = difference;
    function remove_at(array, i) {
        var result = copy(array);
        result.splice(i, 1);
        return result;
    }
    exports.remove_at = remove_at;
    function remove_by(array, key) {
        for (var i = 0; i < array.length;) {
            if (key(array[i]))
                array.splice(i, 1);
            else
                i++;
        }
    }
    exports.remove_by = remove_by;
    // Shuffle a collection, using the modern version of the
    // [Fisher-Yates shuffle](http://en.wikipedia.org/wiki/Fisher–Yates_shuffle).
    function shuffle(array) {
        var length = array.length;
        var shuffled = new Array(length);
        for (var i = 0; i < length; i++) {
            var rand = math_1.randomIn(0, i);
            if (rand !== i)
                shuffled[i] = shuffled[rand];
            shuffled[rand] = array[i];
        }
        return shuffled;
    }
    exports.shuffle = shuffle;
    function pairwise(array, fn) {
        var n = array.length;
        var result = new Array(n - 1);
        for (var i = 0; i < n - 1; i++) {
            result[i] = fn(array[i], array[i + 1]);
        }
        return result;
    }
    exports.pairwise = pairwise;
    function reversed(array) {
        var n = array.length;
        var result = new Array(n);
        for (var i = 0; i < n; i++) {
            result[n - i - 1] = array[i];
        }
        return result;
    }
    exports.reversed = reversed;
    function repeat(value, n) {
        var result = new Array(n);
        for (var i = 0; i < n; i++) {
            result[i] = value;
        }
        return result;
    }
    exports.repeat = repeat;
},
/* core/util/math.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var PI = Math.PI;
    function angle_norm(angle) {
        if (angle == 0) {
            return 0;
        }
        while (angle <= 0) {
            angle += 2 * PI;
        }
        while (angle > 2 * PI) {
            angle -= 2 * PI;
        }
        return angle;
    }
    exports.angle_norm = angle_norm;
    function angle_dist(lhs, rhs) {
        return angle_norm(lhs - rhs);
    }
    exports.angle_dist = angle_dist;
    function angle_between(mid, lhs, rhs, anticlock) {
        if (anticlock === void 0) {
            anticlock = false;
        }
        var d = angle_dist(lhs, rhs);
        if (d == 0)
            return false;
        if (d == 2 * PI)
            return true;
        var norm_mid = angle_norm(mid);
        var cond = angle_dist(lhs, norm_mid) <= d && angle_dist(norm_mid, rhs) <= d;
        return !anticlock ? cond : !cond;
    }
    exports.angle_between = angle_between;
    function random() {
        return Math.random();
    }
    exports.random = random;
    function randomIn(min, max) {
        if (max == null) {
            max = min;
            min = 0;
        }
        return min + Math.floor(Math.random() * (max - min + 1));
    }
    exports.randomIn = randomIn;
    function atan2(start, end) {
        /*
         * Calculate the angle between a line containing start and end points (composed
         * of [x, y] arrays) and the positive x-axis.
         */
        return Math.atan2(end[1] - start[1], end[0] - start[0]);
    }
    exports.atan2 = atan2;
    function radians(degrees) {
        return degrees * (PI / 180);
    }
    exports.radians = radians;
    function degrees(radians) {
        return radians / (PI / 180);
    }
    exports.degrees = degrees;
    function resolve_angle(angle, units) {
        /** Convert CCW angle with units to CW radians (canvas). */
        return -to_radians_coeff(units) * angle;
    }
    exports.resolve_angle = resolve_angle;
    function to_radians_coeff(units) {
        switch (units) {
            case "deg": return PI / 180;
            case "rad": return 1;
            case "grad": return PI / 200;
            case "turn": return 2 * PI;
        }
    }
    exports.to_radians_coeff = to_radians_coeff;
    // http://www2.econ.osaka-u.ac.jp/~tanizaki/class/2013/econome3/13.pdf (Page 432)
    function rnorm(mu, sigma) {
        // Generate a random normal with a mean of 0 and a sigma of 1
        var r1;
        var r2;
        while (true) {
            r1 = random();
            r2 = random();
            r2 = (2 * r2 - 1) * Math.sqrt(2 * (1 / Math.E));
            if (-4 * r1 * r1 * Math.log(r1) >= r2 * r2)
                break;
        }
        var rn = r2 / r1;
        // Transform the standard normal to meet the characteristics that we want (mu, sigma)
        rn = mu + sigma * rn;
        return rn;
    }
    exports.rnorm = rnorm;
    function clamp(val, min, max) {
        return val < min ? min : (val > max ? max : val);
    }
    exports.clamp = clamp;
    function log(x, base) {
        if (base === void 0) {
            base = Math.E;
        }
        return Math.log(x) / Math.log(base);
    }
    exports.log = log;
},
/* core/util/assert.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var AssertionError = /** @class */ (function (_super) {
        tslib_1.__extends(AssertionError, _super);
        function AssertionError() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return AssertionError;
    }(Error));
    exports.AssertionError = AssertionError;
    AssertionError.__name__ = "AssertionError";
    function assert(condition, message) {
        if (condition === true || (condition !== false && condition()))
            return;
        throw new AssertionError(message !== null && message !== void 0 ? message : "Assertion failed");
    }
    exports.assert = assert;
    function unreachable() {
        throw new Error("unreachable code");
    }
    exports.unreachable = unreachable;
},
/* core/util/arrayable.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var math_1 = require(125) /* ./math */;
    function is_empty(array) {
        return array.length == 0;
    }
    exports.is_empty = is_empty;
    function copy(array) {
        if (Array.isArray(array))
            return array.slice();
        else
            return new array.constructor(array);
    }
    exports.copy = copy;
    function splice(array, start, k) {
        var e_1, _a;
        var items = [];
        for (var _i = 3; _i < arguments.length; _i++) {
            items[_i - 3] = arguments[_i];
        }
        var len = array.length;
        if (start < 0)
            start += len;
        if (start < 0)
            start = 0;
        else if (start > len)
            start = len;
        if (k == null || k > len - start)
            k = len - start;
        else if (k < 0)
            k = 0;
        var n = len - k + items.length;
        var result = new array.constructor(n);
        var i = 0;
        for (; i < start; i++) {
            result[i] = array[i];
        }
        try {
            for (var items_1 = tslib_1.__values(items), items_1_1 = items_1.next(); !items_1_1.done; items_1_1 = items_1.next()) {
                var item = items_1_1.value;
                result[i++] = item;
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (items_1_1 && !items_1_1.done && (_a = items_1.return))
                    _a.call(items_1);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
        for (var j = start + k; j < len; j++) {
            result[i++] = array[j];
        }
        return result;
    }
    exports.splice = splice;
    function head(array, n) {
        return splice(array, n, array.length - n);
    }
    exports.head = head;
    function insert(array, item, i) {
        return splice(array, i, 0, item);
    }
    exports.insert = insert;
    function append(array, item) {
        return splice(array, array.length, 0, item);
    }
    exports.append = append;
    function prepend(array, item) {
        return splice(array, 0, 0, item);
    }
    exports.prepend = prepend;
    function indexOf(array, item) {
        for (var i = 0, n = array.length; i < n; i++) {
            if (array[i] === item)
                return i;
        }
        return -1;
    }
    exports.indexOf = indexOf;
    function subselect(array, indices) {
        var n = indices.length;
        var result = new array.constructor(n);
        for (var i = 0; i < n; i++) {
            result[i] = array[indices[i]];
        }
        return result;
    }
    exports.subselect = subselect;
    function mul(array, coeff, output) {
        var n = array.length;
        var result = output !== null && output !== void 0 ? output : new array.constructor(n);
        for (var i = 0; i < n; i++) {
            result[i] = array[i] * coeff;
        }
        return result;
    }
    exports.mul = mul;
    function map(array, fn) {
        var n = array.length;
        var result = new array.constructor(n);
        for (var i = 0; i < n; i++) {
            result[i] = fn(array[i], i, array);
        }
        return result;
    }
    exports.map = map;
    function inplace_map(array, fn, output) {
        var n = array.length;
        var result = output !== null && output !== void 0 ? output : array;
        for (var i = 0; i < n; i++) {
            result[i] = fn(array[i], i);
        }
    }
    exports.inplace_map = inplace_map;
    function filter(array, pred) {
        var n = array.length;
        var result = new array.constructor(n);
        var k = 0;
        for (var i = 0; i < n; i++) {
            var value = array[i];
            if (pred(value, i, array))
                result[k++] = value;
        }
        return head(result, k);
    }
    exports.filter = filter;
    function reduce(array, fn, initial) {
        var n = array.length;
        if (initial === undefined && n == 0)
            throw new Error("can't reduce an empty array without an initial value");
        var value;
        var i;
        if (initial === undefined) {
            value = array[0];
            i = 1;
        }
        else {
            value = initial;
            i = 0;
        }
        for (; i < n; i++) {
            value = fn(value, array[i], i, array);
        }
        return value;
    }
    exports.reduce = reduce;
    function min(array) {
        var value;
        var result = Infinity;
        for (var i = 0, length = array.length; i < length; i++) {
            value = array[i];
            if (!isNaN(value) && value < result) {
                result = value;
            }
        }
        return result;
    }
    exports.min = min;
    function max(array) {
        var value;
        var result = -Infinity;
        for (var i = 0, length = array.length; i < length; i++) {
            value = array[i];
            if (!isNaN(value) && value > result) {
                result = value;
            }
        }
        return result;
    }
    exports.max = max;
    function minmax(array) {
        var value;
        var min = +Infinity;
        var max = -Infinity;
        for (var i = 0, length = array.length; i < length; i++) {
            value = array[i];
            if (!isNaN(value)) {
                if (value < min) {
                    min = value;
                }
                if (value > max) {
                    max = value;
                }
            }
        }
        return [min, max];
    }
    exports.minmax = minmax;
    function min_by(array, key) {
        if (array.length == 0)
            throw new Error("min_by() called with an empty array");
        var result = array[0];
        var resultComputed = key(result);
        for (var i = 1, length = array.length; i < length; i++) {
            var value = array[i];
            var computed = key(value);
            if (computed < resultComputed) {
                result = value;
                resultComputed = computed;
            }
        }
        return result;
    }
    exports.min_by = min_by;
    function max_by(array, key) {
        if (array.length == 0)
            throw new Error("max_by() called with an empty array");
        var result = array[0];
        var resultComputed = key(result);
        for (var i = 1, length = array.length; i < length; i++) {
            var value = array[i];
            var computed = key(value);
            if (computed > resultComputed) {
                result = value;
                resultComputed = computed;
            }
        }
        return result;
    }
    exports.max_by = max_by;
    function sum(array) {
        var result = 0;
        for (var i = 0, n = array.length; i < n; i++) {
            result += array[i];
        }
        return result;
    }
    exports.sum = sum;
    function cumsum(array) {
        var result = new array.constructor(array.length);
        reduce(array, function (a, b, i) { return result[i] = a + b; }, 0);
        return result;
    }
    exports.cumsum = cumsum;
    function every(array, predicate) {
        for (var i = 0, length = array.length; i < length; i++) {
            if (!predicate(array[i]))
                return false;
        }
        return true;
    }
    exports.every = every;
    function some(array, predicate) {
        for (var i = 0, length = array.length; i < length; i++) {
            if (predicate(array[i]))
                return true;
        }
        return false;
    }
    exports.some = some;
    function index_of(array, value) {
        for (var i = 0, length = array.length; i < length; i++) {
            if (array[i] === value)
                return i;
        }
        return -1;
    }
    exports.index_of = index_of;
    function _find_index(dir) {
        return function (array, predicate) {
            var length = array.length;
            var index = dir > 0 ? 0 : length - 1;
            for (; index >= 0 && index < length; index += dir) {
                if (predicate(array[index]))
                    return index;
            }
            return -1;
        };
    }
    exports.find_index = _find_index(1);
    exports.find_last_index = _find_index(-1);
    function find(array, predicate) {
        var index = exports.find_index(array, predicate);
        return index == -1 ? undefined : array[index];
    }
    exports.find = find;
    function find_last(array, predicate) {
        var index = exports.find_last_index(array, predicate);
        return index == -1 ? undefined : array[index];
    }
    exports.find_last = find_last;
    function sorted_index(array, value) {
        var low = 0;
        var high = array.length;
        while (low < high) {
            var mid = Math.floor((low + high) / 2);
            if (array[mid] < value)
                low = mid + 1;
            else
                high = mid;
        }
        return low;
    }
    exports.sorted_index = sorted_index;
    function bin_counts(data, bin_edges) {
        var nbins = bin_edges.length - 1;
        var counts = Array(nbins).fill(0);
        for (var i = 0; i < data.length; i++) {
            var sample = data[i];
            var index = sorted_index(bin_edges, sample);
            var bin = math_1.clamp(index - 1, 0, nbins - 1);
            counts[bin] += 1;
        }
        return counts;
    }
    exports.bin_counts = bin_counts;
    function interpolate(points, x_values, y_values) {
        // Implementation ported from np.interp
        var n = points.length;
        var results = new Array(n);
        for (var i = 0; i < n; i++) {
            var point = points[i];
            if (isNaN(point)) {
                results[i] = point;
                continue;
            }
            var index = left_edge_index(point, x_values);
            if (index == -1)
                results[i] = y_values[0];
            else if (index == x_values.length)
                results[i] = y_values[y_values.length - 1];
            else if (index == x_values.length - 1 || x_values[index] == point) {
                results[i] = y_values[index];
            }
            else {
                var x0 = x_values[index];
                var y0 = y_values[index];
                var x1 = x_values[index + 1];
                var y1 = y_values[index + 1];
                results[i] = lerp(point, x0, y0, x1, y1);
            }
        }
        return results;
    }
    exports.interpolate = interpolate;
    function lerp(x, x0, y0, x1, y1) {
        var slope = (y1 - y0) / (x1 - x0);
        var res = slope * (x - x0) + y0;
        if (!isFinite(res)) {
            res = slope * (x - x1) + y1;
            if (!isFinite(res) && (y0 == y1))
                res = y0;
        }
        return res;
    }
    function left_edge_index(point, intervals) {
        if (point < intervals[0])
            return -1;
        if (point > intervals[intervals.length - 1])
            return intervals.length;
        var leftEdgeIndex = 0;
        var rightEdgeIndex = intervals.length - 1;
        while (rightEdgeIndex - leftEdgeIndex != 1) {
            var indexOfNumberToCompare = leftEdgeIndex + Math.floor((rightEdgeIndex - leftEdgeIndex) / 2);
            if (point >= intervals[indexOfNumberToCompare])
                leftEdgeIndex = indexOfNumberToCompare;
            else
                rightEdgeIndex = indexOfNumberToCompare;
        }
        return leftEdgeIndex;
    }
    exports.left_edge_index = left_edge_index;
    function norm(array, start, end) {
        var span = end - start;
        return map(array, function (x) { return (x - start) / span; });
    }
    exports.norm = norm;
},
/* core/util/object.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var array_1 = require(124) /* ./array */;
    var hasOwnProperty = Object.prototype.hasOwnProperty;
    exports.keys = Object.keys, exports.values = Object.values, exports.entries = Object.entries, exports.extend = Object.assign;
    function clone(obj) {
        return tslib_1.__assign({}, obj);
    }
    exports.clone = clone;
    function merge(obj1, obj2) {
        var e_1, _a;
        /*
         * Returns an object with the array values for obj1 and obj2 unioned by key.
         */
        var result = Object.create(Object.prototype);
        var keys = array_1.concat([Object.keys(obj1), Object.keys(obj2)]);
        try {
            for (var keys_1 = tslib_1.__values(keys), keys_1_1 = keys_1.next(); !keys_1_1.done; keys_1_1 = keys_1.next()) {
                var key = keys_1_1.value;
                var arr1 = hasOwnProperty.call(obj1, key) ? obj1[key] : [];
                var arr2 = hasOwnProperty.call(obj2, key) ? obj2[key] : [];
                result[key] = array_1.union(arr1, arr2);
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (keys_1_1 && !keys_1_1.done && (_a = keys_1.return))
                    _a.call(keys_1);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
        return result;
    }
    exports.merge = merge;
    function size(obj) {
        return Object.keys(obj).length;
    }
    exports.size = size;
    function isEmpty(obj) {
        return size(obj) == 0;
    }
    exports.isEmpty = isEmpty;
    function to_object(map) {
        var e_2, _a;
        var obj = {};
        try {
            for (var map_1 = tslib_1.__values(map), map_1_1 = map_1.next(); !map_1_1.done; map_1_1 = map_1.next()) {
                var _b = tslib_1.__read(map_1_1.value, 2), key = _b[0], val = _b[1];
                obj[key] = val;
            }
        }
        catch (e_2_1) {
            e_2 = { error: e_2_1 };
        }
        finally {
            try {
                if (map_1_1 && !map_1_1.done && (_a = map_1.return))
                    _a.call(map_1);
            }
            finally {
                if (e_2)
                    throw e_2.error;
            }
        }
        return obj;
    }
    exports.to_object = to_object;
},
/* core/has_props.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var signaling_1 = require(130) /* ./signaling */;
    var refs_1 = require(132) /* ./util/refs */;
    var p = tslib_1.__importStar(require(133) /* ./properties */);
    var k = tslib_1.__importStar(require(136) /* ./kinds */);
    var string_1 = require(149) /* ./util/string */;
    var object_1 = require(128) /* ./util/object */;
    var types_1 = require(123) /* ./util/types */;
    var eq_1 = require(141) /* ./util/eq */;
    var serializer_1 = require(145) /* ./serializer */;
    var events_1 = require(150) /* ../document/events */;
    var eq_2 = require(141) /* ./util/eq */;
    var pretty_1 = require(151) /* ./util/pretty */;
    var cloneable_1 = require(152) /* ./util/cloneable */;
    var kinds = tslib_1.__importStar(require(136) /* ./kinds */);
    var HasProps = /** @class */ (function (_super) {
        tslib_1.__extends(HasProps, _super);
        function HasProps(attrs) {
            var e_1, _a;
            if (attrs === void 0) {
                attrs = {};
            }
            var _b, _c;
            var _this = _super.call(this) || this;
            _this._subtype = undefined;
            _this.document = null;
            _this.destroyed = new signaling_1.Signal0(_this, "destroyed");
            _this.change = new signaling_1.Signal0(_this, "change");
            _this.transformchange = new signaling_1.Signal0(_this, "transformchange");
            _this.exprchange = new signaling_1.Signal0(_this, "exprchange");
            _this.properties = {};
            _this._pending = false;
            _this._changing = false;
            var get = attrs instanceof Map ? attrs.get.bind(attrs) : function (name) { return attrs[name]; };
            _this.id = (_b = get("id")) !== null && _b !== void 0 ? _b : string_1.uniqueId();
            var _loop_1 = function (name, type, default_value, options) {
                var property = void 0;
                if (type instanceof p.PropertyAlias) {
                    Object.defineProperty(this_1.properties, name, {
                        get: function () { return _this.properties[type.attr]; },
                        configurable: false,
                        enumerable: false,
                    });
                }
                else {
                    if (type instanceof k.Kind)
                        property = new p.PrimitiveProperty(this_1, name, type, default_value, get(name), options);
                    else
                        property = new type(this_1, name, k.Any, default_value, get(name), options);
                    this_1.properties[name] = property;
                }
            };
            var this_1 = this;
            try {
                for (var _d = tslib_1.__values(object_1.entries(_this._props)), _e = _d.next(); !_e.done; _e = _d.next()) {
                    var _f = tslib_1.__read(_e.value, 2), name = _f[0], _g = _f[1], type = _g.type, default_value = _g.default_value, options = _g.options;
                    _loop_1(name, type, default_value, options);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_e && !_e.done && (_a = _d.return))
                        _a.call(_d);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            // allowing us to defer initialization when loading many models
            // when loading a bunch of models, we want to do initialization as a second pass
            // because other objects that this one depends on might not be loaded yet
            if (!((_c = get("__deferred__")) !== null && _c !== void 0 ? _c : false)) {
                _this.finalize();
                _this.connect_signals();
            }
            return _this;
        }
        Object.defineProperty(HasProps.prototype, "is_syncable", {
            get: function () {
                return true;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(HasProps.prototype, "type", {
            get: function () {
                return this.constructor.__qualified__;
            },
            // XXX: setter is only required for backwards compatibility
            set: function (name) {
                console.warn("prototype.type = 'ModelName' is deprecated, use static __name__ instead");
                this.constructor.__name__ = name;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(HasProps, "__qualified__", {
            get: function () {
                var _a = this, __module__ = _a.__module__, __name__ = _a.__name__;
                return __module__ != null ? __module__ + "." + __name__ : __name__;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(HasProps, Symbol.toStringTag, {
            get: function () {
                return this.__name__;
            },
            enumerable: false,
            configurable: true
        });
        HasProps.init_HasProps = function () {
            this.prototype._props = {};
            this.prototype._mixins = [];
        };
        HasProps._fix_default = function (default_value, _attr) {
            if (default_value === undefined || types_1.isFunction(default_value))
                return default_value;
            else if (types_1.isPrimitive(default_value))
                return function () { return default_value; };
            else {
                var cloner_1 = new cloneable_1.Cloner();
                return function () { return cloner_1.clone(default_value); };
            }
        };
        // TODO: don't use Partial<>, but exclude inherited properties
        HasProps.define = function (obj) {
            var e_2, _a;
            var _loop_2 = function (name, prop) {
                if (this_2.prototype._props[name] != null)
                    throw new Error("attempted to redefine property '" + this_2.prototype.type + "." + name + "'");
                if (this_2.prototype[name] != null)
                    throw new Error("attempted to redefine attribute '" + this_2.prototype.type + "." + name + "'");
                Object.defineProperty(this_2.prototype, name, {
                    // XXX: don't use tail calls in getters/setters due to https://bugs.webkit.org/show_bug.cgi?id=164306
                    get: function () {
                        var value = this.properties[name].get_value();
                        return value;
                    },
                    set: function (value) {
                        var _a;
                        this.setv((_a = {}, _a[name] = value, _a));
                        return this;
                    },
                    configurable: false,
                    enumerable: true,
                });
                var _a = tslib_1.__read(prop, 3), type = _a[0], default_value = _a[1], _b = _a[2], options = _b === void 0 ? {} : _b;
                var refined_prop = {
                    type: type,
                    default_value: this_2._fix_default(default_value, name),
                    options: options,
                };
                var props = tslib_1.__assign({}, this_2.prototype._props);
                props[name] = refined_prop;
                this_2.prototype._props = props;
            };
            var this_2 = this;
            try {
                for (var _b = tslib_1.__values(object_1.entries(types_1.isFunction(obj) ? obj(kinds) : obj)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var _d = tslib_1.__read(_c.value, 2), name = _d[0], prop = _d[1];
                    _loop_2(name, prop);
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
        };
        HasProps.internal = function (obj) {
            var e_3, _a;
            var _object = {};
            try {
                for (var _b = tslib_1.__values(object_1.entries(types_1.isFunction(obj) ? obj(kinds) : obj)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var _d = tslib_1.__read(_c.value, 2), name = _d[0], prop = _d[1];
                    var _e = tslib_1.__read(prop, 3), type = _e[0], default_value = _e[1], _f = _e[2], options = _f === void 0 ? {} : _f;
                    _object[name] = [type, default_value, tslib_1.__assign(tslib_1.__assign({}, options), { internal: true })];
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            this.define(_object);
        };
        HasProps.mixins = function (defs) {
            var e_4, _a;
            function rename(prefix, mixin) {
                var e_5, _a;
                var result = {};
                try {
                    for (var _b = tslib_1.__values(object_1.entries(mixin)), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var _d = tslib_1.__read(_c.value, 2), name = _d[0], prop = _d[1];
                        result[prefix + name] = prop;
                    }
                }
                catch (e_5_1) {
                    e_5 = { error: e_5_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_5)
                            throw e_5.error;
                    }
                }
                return result;
            }
            var mixin_defs = {};
            var mixins = [];
            try {
                for (var _b = tslib_1.__values(types_1.isArray(defs) ? defs : [defs]), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var def = _c.value;
                    if (types_1.isArray(def)) {
                        var _d = tslib_1.__read(def, 2), prefix = _d[0], mixin = _d[1];
                        object_1.extend(mixin_defs, rename(prefix, mixin));
                        mixins.push([prefix, mixin]);
                    }
                    else {
                        var mixin = def;
                        object_1.extend(mixin_defs, mixin);
                        mixins.push(["", mixin]);
                    }
                }
            }
            catch (e_4_1) {
                e_4 = { error: e_4_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_4)
                        throw e_4.error;
                }
            }
            this.define(mixin_defs);
            this.prototype._mixins = tslib_1.__spread(this.prototype._mixins, mixins);
        };
        HasProps.override = function (obj) {
            var e_6, _a;
            try {
                for (var _b = tslib_1.__values(object_1.entries(obj)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var _d = tslib_1.__read(_c.value, 2), name = _d[0], prop = _d[1];
                    var default_value = this._fix_default(prop, name);
                    var value = this.prototype._props[name];
                    if (value == null)
                        throw new Error("attempted to override nonexistent '" + this.prototype.type + "." + name + "'");
                    var props = tslib_1.__assign({}, this.prototype._props);
                    props[name] = tslib_1.__assign(tslib_1.__assign({}, value), { default_value: default_value });
                    this.prototype._props = props;
                }
            }
            catch (e_6_1) {
                e_6 = { error: e_6_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_6)
                        throw e_6.error;
                }
            }
        };
        HasProps.prototype.toString = function () {
            return this.type + "(" + this.id + ")";
        };
        HasProps.prototype.property = function (name) {
            var prop = this.properties[name];
            if (prop != null)
                return prop;
            else
                throw new Error("unknown property " + this.type + "." + name);
        };
        Object.defineProperty(HasProps.prototype, "attributes", {
            get: function () {
                var e_7, _a;
                var attrs = {};
                try {
                    for (var _b = tslib_1.__values(this), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var prop = _c.value;
                        attrs[prop.attr] = prop.get_value();
                    }
                }
                catch (e_7_1) {
                    e_7 = { error: e_7_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_7)
                            throw e_7.error;
                    }
                }
                return attrs;
            },
            enumerable: false,
            configurable: true
        });
        HasProps.prototype[cloneable_1.clone] = function (cloner) {
            var e_8, _a;
            var attrs = new Map();
            try {
                for (var _b = tslib_1.__values(this), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var prop = _c.value;
                    if (prop.dirty) {
                        attrs.set(prop.attr, cloner.clone(prop.get_value()));
                    }
                }
            }
            catch (e_8_1) {
                e_8 = { error: e_8_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_8)
                        throw e_8.error;
                }
            }
            return new this.constructor(attrs);
        };
        HasProps.prototype[eq_2.equals] = function (that, cmp) {
            var e_9, _a;
            try {
                for (var _b = tslib_1.__values(this), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var p0 = _c.value;
                    var p1 = that.property(p0.attr);
                    if (cmp.eq(p0.get_value(), p1.get_value()))
                        return false;
                }
            }
            catch (e_9_1) {
                e_9 = { error: e_9_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_9)
                        throw e_9.error;
                }
            }
            return true;
        };
        HasProps.prototype[pretty_1.pretty] = function (printer) {
            var e_10, _a;
            var T = printer.token;
            var items = [];
            try {
                for (var _b = tslib_1.__values(this), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var prop = _c.value;
                    if (prop.dirty) {
                        var value = prop.get_value();
                        items.push("" + prop.attr + T(":") + " " + printer.to_string(value));
                    }
                }
            }
            catch (e_10_1) {
                e_10 = { error: e_10_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_10)
                        throw e_10.error;
                }
            }
            var cls = this.constructor.__qualified__;
            return "" + cls + T("(") + T("{") + items.join(T(",") + " ") + T("}") + T(")");
        };
        HasProps.prototype[serializer_1.serialize] = function (serializer) {
            var e_11, _a;
            var ref = this.ref();
            serializer.add_ref(this, ref);
            var struct = this.struct();
            try {
                for (var _b = tslib_1.__values(this), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var prop = _c.value;
                    if (prop.syncable && (serializer.include_defaults || prop.dirty)) {
                        struct.attributes[prop.attr] = serializer.to_serializable(prop.get_value());
                    }
                }
            }
            catch (e_11_1) {
                e_11 = { error: e_11_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_11)
                        throw e_11.error;
                }
            }
            serializer.add_def(this, struct);
            return ref;
        };
        HasProps.prototype.finalize = function () {
            var e_12, _a;
            var _this = this;
            try {
                for (var _b = tslib_1.__values(this), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var prop = _c.value;
                    if (!(prop instanceof p.VectorSpec || prop instanceof p.ScalarSpec))
                        continue;
                    var value = prop.get_value(); // XXX: T -> any under instanceof
                    if (value != null) {
                        var transform = value.transform, expr = value.expr;
                        if (transform != null)
                            this.connect(transform.change, function () { return _this.transformchange.emit(); });
                        if (expr != null)
                            this.connect(expr.change, function () { return _this.exprchange.emit(); });
                    }
                }
            }
            catch (e_12_1) {
                e_12 = { error: e_12_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_12)
                        throw e_12.error;
                }
            }
            this.initialize();
        };
        HasProps.prototype.initialize = function () { };
        HasProps.prototype.connect_signals = function () { };
        HasProps.prototype.disconnect_signals = function () {
            signaling_1.Signal.disconnectReceiver(this);
        };
        HasProps.prototype.destroy = function () {
            this.disconnect_signals();
            this.destroyed.emit();
        };
        // Create a new model with exact attribute values to this one, but new identity.
        HasProps.prototype.clone = function () {
            var cloner = new cloneable_1.Cloner();
            return cloner.clone(this);
        };
        // Set a hash of model attributes on the object, firing `"change"`. This is
        // the core primitive operation of a model, updating the data and notifying
        // anyone who needs to know about the change in state. The heart of the beast.
        HasProps.prototype._setv = function (changes, options) {
            var e_13, _a, e_14, _b;
            // Extract attributes and options.
            var check_eq = options.check_eq;
            var changed = [];
            var changing = this._changing;
            this._changing = true;
            try {
                for (var changes_1 = tslib_1.__values(changes), changes_1_1 = changes_1.next(); !changes_1_1.done; changes_1_1 = changes_1.next()) {
                    var _c = tslib_1.__read(changes_1_1.value, 2), prop = _c[0], value = _c[1];
                    if (check_eq === false || !eq_1.is_equal(prop.get_value(), value)) {
                        prop.set_value(value);
                        changed.push(prop);
                    }
                }
            }
            catch (e_13_1) {
                e_13 = { error: e_13_1 };
            }
            finally {
                try {
                    if (changes_1_1 && !changes_1_1.done && (_a = changes_1.return))
                        _a.call(changes_1);
                }
                finally {
                    if (e_13)
                        throw e_13.error;
                }
            }
            // Trigger all relevant attribute changes.
            if (changed.length > 0)
                this._pending = true;
            try {
                for (var changed_1 = tslib_1.__values(changed), changed_1_1 = changed_1.next(); !changed_1_1.done; changed_1_1 = changed_1.next()) {
                    var prop = changed_1_1.value;
                    prop.change.emit();
                }
            }
            catch (e_14_1) {
                e_14 = { error: e_14_1 };
            }
            finally {
                try {
                    if (changed_1_1 && !changed_1_1.done && (_b = changed_1.return))
                        _b.call(changed_1);
                }
                finally {
                    if (e_14)
                        throw e_14.error;
                }
            }
            // You might be wondering why there's a `while` loop here. Changes can
            // be recursively nested within `"change"` events.
            if (changing)
                return;
            if (!options.no_change) {
                while (this._pending) {
                    this._pending = false;
                    this.change.emit();
                }
            }
            this._pending = false;
            this._changing = false;
        };
        HasProps.prototype.setv = function (changed_attrs, options) {
            var e_15, _a, e_16, _b, e_17, _c, e_18, _d;
            if (options === void 0) {
                options = {};
            }
            var changes = object_1.entries(changed_attrs);
            if (changes.length == 0)
                return;
            if (options.silent === true) {
                try {
                    for (var changes_2 = tslib_1.__values(changes), changes_2_1 = changes_2.next(); !changes_2_1.done; changes_2_1 = changes_2.next()) {
                        var _e = tslib_1.__read(changes_2_1.value, 2), attr = _e[0], value = _e[1];
                        this.properties[attr].set_value(value);
                    }
                }
                catch (e_15_1) {
                    e_15 = { error: e_15_1 };
                }
                finally {
                    try {
                        if (changes_2_1 && !changes_2_1.done && (_a = changes_2.return))
                            _a.call(changes_2);
                    }
                    finally {
                        if (e_15)
                            throw e_15.error;
                    }
                }
                return;
            }
            var changed = new Map();
            var previous = new Map();
            try {
                for (var changes_3 = tslib_1.__values(changes), changes_3_1 = changes_3.next(); !changes_3_1.done; changes_3_1 = changes_3.next()) {
                    var _f = tslib_1.__read(changes_3_1.value, 2), attr = _f[0], value = _f[1];
                    var prop = this.properties[attr];
                    changed.set(prop, value);
                    previous.set(prop, prop.get_value());
                }
            }
            catch (e_16_1) {
                e_16 = { error: e_16_1 };
            }
            finally {
                try {
                    if (changes_3_1 && !changes_3_1.done && (_b = changes_3.return))
                        _b.call(changes_3);
                }
                finally {
                    if (e_16)
                        throw e_16.error;
                }
            }
            this._setv(changed, options);
            var document = this.document;
            if (document != null) {
                var changed_3 = [];
                try {
                    for (var previous_1 = tslib_1.__values(previous), previous_1_1 = previous_1.next(); !previous_1_1.done; previous_1_1 = previous_1.next()) {
                        var _g = tslib_1.__read(previous_1_1.value, 2), prop = _g[0], value = _g[1];
                        changed_3.push([prop, value, prop.get_value()]);
                    }
                }
                catch (e_17_1) {
                    e_17 = { error: e_17_1 };
                }
                finally {
                    try {
                        if (previous_1_1 && !previous_1_1.done && (_c = previous_1.return))
                            _c.call(previous_1);
                    }
                    finally {
                        if (e_17)
                            throw e_17.error;
                    }
                }
                try {
                    for (var changed_2 = tslib_1.__values(changed_3), changed_2_1 = changed_2.next(); !changed_2_1.done; changed_2_1 = changed_2.next()) {
                        var _h = tslib_1.__read(changed_2_1.value, 3), old_value = _h[1], new_value = _h[2];
                        if (this._needs_invalidate(old_value, new_value)) {
                            document._invalidate_all_models();
                            break;
                        }
                    }
                }
                catch (e_18_1) {
                    e_18 = { error: e_18_1 };
                }
                finally {
                    try {
                        if (changed_2_1 && !changed_2_1.done && (_d = changed_2.return))
                            _d.call(changed_2);
                    }
                    finally {
                        if (e_18)
                            throw e_18.error;
                    }
                }
                this._push_changes(changed_3, options);
            }
        };
        /** @deprecated */
        HasProps.prototype.getv = function (name) {
            return this.property(name).get_value();
        };
        HasProps.prototype.ref = function () {
            return { id: this.id };
        };
        HasProps.prototype.struct = function () {
            var struct = {
                type: this.type,
                id: this.id,
                attributes: {},
            };
            if (this._subtype != null) {
                struct.subtype = this._subtype;
            }
            return struct;
        };
        // we only keep the subtype so we match Python;
        // only Python cares about this
        HasProps.prototype.set_subtype = function (subtype) {
            this._subtype = subtype;
        };
        HasProps.prototype[Symbol.iterator] = function () {
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [5 /*yield**/, tslib_1.__values(object_1.values(this.properties))];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        };
        HasProps.prototype.syncable_properties = function () {
            var _a, _b, prop, e_19_1;
            var e_19, _c;
            return tslib_1.__generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        _d.trys.push([0, 5, 6, 7]);
                        _a = tslib_1.__values(this), _b = _a.next();
                        _d.label = 1;
                    case 1:
                        if (!!_b.done)
                            return [3 /*break*/, 4];
                        prop = _b.value;
                        if (!prop.syncable)
                            return [3 /*break*/, 3];
                        return [4 /*yield*/, prop];
                    case 2:
                        _d.sent();
                        _d.label = 3;
                    case 3:
                        _b = _a.next();
                        return [3 /*break*/, 1];
                    case 4: return [3 /*break*/, 7];
                    case 5:
                        e_19_1 = _d.sent();
                        e_19 = { error: e_19_1 };
                        return [3 /*break*/, 7];
                    case 6:
                        try {
                            if (_b && !_b.done && (_c = _a.return))
                                _c.call(_a);
                        }
                        finally {
                            if (e_19)
                                throw e_19.error;
                        }
                        return [7 /*endfinally*/];
                    case 7: return [2 /*return*/];
                }
            });
        };
        /** @deprecated */
        HasProps.prototype.serializable_attributes = function () {
            var e_20, _a;
            var attrs = {};
            try {
                for (var _b = tslib_1.__values(this.syncable_properties()), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var prop = _c.value;
                    attrs[prop.attr] = prop.get_value();
                }
            }
            catch (e_20_1) {
                e_20 = { error: e_20_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_20)
                        throw e_20.error;
                }
            }
            return attrs;
        };
        // this is like _value_record_references but expects to find refs
        // instead of models, and takes a doc to look up the refs in
        HasProps._json_record_references = function (doc, v, refs, options) {
            var e_21, _a, e_22, _b;
            var recursive = options.recursive;
            if (refs_1.is_ref(v)) {
                var model = doc.get_model_by_id(v.id);
                if (model != null && !refs.has(model)) {
                    HasProps._value_record_references(model, refs, { recursive: recursive });
                }
            }
            else if (types_1.isArray(v)) {
                try {
                    for (var v_1 = tslib_1.__values(v), v_1_1 = v_1.next(); !v_1_1.done; v_1_1 = v_1.next()) {
                        var elem = v_1_1.value;
                        HasProps._json_record_references(doc, elem, refs, { recursive: recursive });
                    }
                }
                catch (e_21_1) {
                    e_21 = { error: e_21_1 };
                }
                finally {
                    try {
                        if (v_1_1 && !v_1_1.done && (_a = v_1.return))
                            _a.call(v_1);
                    }
                    finally {
                        if (e_21)
                            throw e_21.error;
                    }
                }
            }
            else if (types_1.isPlainObject(v)) {
                try {
                    for (var _c = tslib_1.__values(object_1.values(v)), _d = _c.next(); !_d.done; _d = _c.next()) {
                        var elem = _d.value;
                        HasProps._json_record_references(doc, elem, refs, { recursive: recursive });
                    }
                }
                catch (e_22_1) {
                    e_22 = { error: e_22_1 };
                }
                finally {
                    try {
                        if (_d && !_d.done && (_b = _c.return))
                            _b.call(_c);
                    }
                    finally {
                        if (e_22)
                            throw e_22.error;
                    }
                }
            }
        };
        // add all references from 'v' to 'result', if recurse
        // is true then descend into refs, if false only
        // descend into non-refs
        HasProps._value_record_references = function (v, refs, options) {
            var e_23, _a, e_24, _b, e_25, _c;
            var recursive = options.recursive;
            if (v instanceof HasProps) {
                if (!refs.has(v)) {
                    refs.add(v);
                    if (recursive) {
                        try {
                            for (var _d = tslib_1.__values(v.syncable_properties()), _e = _d.next(); !_e.done; _e = _d.next()) {
                                var prop = _e.value;
                                var value = prop.get_value();
                                HasProps._value_record_references(value, refs, { recursive: recursive });
                            }
                        }
                        catch (e_23_1) {
                            e_23 = { error: e_23_1 };
                        }
                        finally {
                            try {
                                if (_e && !_e.done && (_a = _d.return))
                                    _a.call(_d);
                            }
                            finally {
                                if (e_23)
                                    throw e_23.error;
                            }
                        }
                    }
                }
            }
            else if (types_1.isArray(v)) {
                try {
                    for (var v_2 = tslib_1.__values(v), v_2_1 = v_2.next(); !v_2_1.done; v_2_1 = v_2.next()) {
                        var elem = v_2_1.value;
                        HasProps._value_record_references(elem, refs, { recursive: recursive });
                    }
                }
                catch (e_24_1) {
                    e_24 = { error: e_24_1 };
                }
                finally {
                    try {
                        if (v_2_1 && !v_2_1.done && (_b = v_2.return))
                            _b.call(v_2);
                    }
                    finally {
                        if (e_24)
                            throw e_24.error;
                    }
                }
            }
            else if (types_1.isPlainObject(v)) {
                try {
                    for (var _f = tslib_1.__values(object_1.values(v)), _g = _f.next(); !_g.done; _g = _f.next()) {
                        var elem = _g.value;
                        HasProps._value_record_references(elem, refs, { recursive: recursive });
                    }
                }
                catch (e_25_1) {
                    e_25 = { error: e_25_1 };
                }
                finally {
                    try {
                        if (_g && !_g.done && (_c = _f.return))
                            _c.call(_f);
                    }
                    finally {
                        if (e_25)
                            throw e_25.error;
                    }
                }
            }
        };
        HasProps.prototype.references = function () {
            var refs = new Set();
            HasProps._value_record_references(this, refs, { recursive: true });
            return refs;
        };
        HasProps.prototype._doc_attached = function () { };
        HasProps.prototype._doc_detached = function () { };
        HasProps.prototype.attach_document = function (doc) {
            // This should only be called by the Document implementation to set the document field
            if (this.document != null && this.document != doc)
                throw new Error("models must be owned by only a single document");
            this.document = doc;
            this._doc_attached();
        };
        HasProps.prototype.detach_document = function () {
            // This should only be called by the Document implementation to unset the document field
            this._doc_detached();
            this.document = null;
        };
        HasProps.prototype._needs_invalidate = function (old_value, new_value) {
            var e_26, _a, e_27, _b;
            var new_refs = new Set();
            HasProps._value_record_references(new_value, new_refs, { recursive: false });
            var old_refs = new Set();
            HasProps._value_record_references(old_value, old_refs, { recursive: false });
            try {
                for (var new_refs_1 = tslib_1.__values(new_refs), new_refs_1_1 = new_refs_1.next(); !new_refs_1_1.done; new_refs_1_1 = new_refs_1.next()) {
                    var new_id = new_refs_1_1.value;
                    if (!old_refs.has(new_id))
                        return true;
                }
            }
            catch (e_26_1) {
                e_26 = { error: e_26_1 };
            }
            finally {
                try {
                    if (new_refs_1_1 && !new_refs_1_1.done && (_a = new_refs_1.return))
                        _a.call(new_refs_1);
                }
                finally {
                    if (e_26)
                        throw e_26.error;
                }
            }
            try {
                for (var old_refs_1 = tslib_1.__values(old_refs), old_refs_1_1 = old_refs_1.next(); !old_refs_1_1.done; old_refs_1_1 = old_refs_1.next()) {
                    var old_id = old_refs_1_1.value;
                    if (!new_refs.has(old_id))
                        return true;
                }
            }
            catch (e_27_1) {
                e_27 = { error: e_27_1 };
            }
            finally {
                try {
                    if (old_refs_1_1 && !old_refs_1_1.done && (_b = old_refs_1.return))
                        _b.call(old_refs_1);
                }
                finally {
                    if (e_27)
                        throw e_27.error;
                }
            }
            return false;
        };
        HasProps.prototype._push_changes = function (changes, options) {
            var e_28, _a, _b;
            if (options === void 0) {
                options = {};
            }
            if (!this.is_syncable)
                return;
            var document = this.document;
            if (document == null)
                return;
            var setter_id = options.setter_id;
            var events = [];
            try {
                for (var changes_4 = tslib_1.__values(changes), changes_4_1 = changes_4.next(); !changes_4_1.done; changes_4_1 = changes_4.next()) {
                    var _c = tslib_1.__read(changes_4_1.value, 3), prop = _c[0], old_value = _c[1], new_value = _c[2];
                    if (prop.syncable)
                        events.push(new events_1.ModelChangedEvent(document, this, prop.attr, old_value, new_value, setter_id));
                }
            }
            catch (e_28_1) {
                e_28 = { error: e_28_1 };
            }
            finally {
                try {
                    if (changes_4_1 && !changes_4_1.done && (_a = changes_4.return))
                        _a.call(changes_4);
                }
                finally {
                    if (e_28)
                        throw e_28.error;
                }
            }
            if (events.length != 0) {
                var event = void 0;
                if (events.length == 1)
                    _b = tslib_1.__read(events, 1), event = _b[0];
                else
                    event = new events_1.DocumentEventBatch(document, events, setter_id);
                document._trigger_on_change(event);
            }
        };
        HasProps.prototype.on_change = function (properties, fn) {
            var e_29, _a;
            try {
                for (var _b = tslib_1.__values(types_1.isArray(properties) ? properties : [properties]), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var property = _c.value;
                    this.connect(property.change, fn);
                }
            }
            catch (e_29_1) {
                e_29 = { error: e_29_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_29)
                        throw e_29.error;
                }
            }
        };
        return HasProps;
    }(signaling_1.Signalable()));
    exports.HasProps = HasProps;
    HasProps.init_HasProps();
},
/* core/signaling.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    // Based on https://github.com/phosphorjs/phosphor/blob/master/packages/signaling/src/index.ts
    var defer_1 = require(131) /* ./util/defer */;
    var array_1 = require(124) /* ./util/array */;
    var Signal = /** @class */ (function () {
        function Signal(sender, name) {
            this.sender = sender;
            this.name = name;
        }
        Signal.prototype.connect = function (slot, context) {
            if (context === void 0) {
                context = null;
            }
            if (!receiversForSender.has(this.sender)) {
                receiversForSender.set(this.sender, []);
            }
            var receivers = receiversForSender.get(this.sender);
            if (find_connection(receivers, this, slot, context) != null) {
                return false;
            }
            var receiver = context !== null && context !== void 0 ? context : slot;
            if (!sendersForReceiver.has(receiver)) {
                sendersForReceiver.set(receiver, []);
            }
            var senders = sendersForReceiver.get(receiver);
            var connection = { signal: this, slot: slot, context: context };
            receivers.push(connection);
            senders.push(connection);
            return true;
        };
        Signal.prototype.disconnect = function (slot, context) {
            if (context === void 0) {
                context = null;
            }
            var receivers = receiversForSender.get(this.sender);
            if (receivers == null || receivers.length === 0) {
                return false;
            }
            var connection = find_connection(receivers, this, slot, context);
            if (connection == null) {
                return false;
            }
            var receiver = context !== null && context !== void 0 ? context : slot;
            var senders = sendersForReceiver.get(receiver);
            connection.signal = null;
            schedule_cleanup(receivers);
            schedule_cleanup(senders);
            return true;
        };
        Signal.prototype.emit = function (args) {
            var e_1, _a;
            var _b;
            var receivers = (_b = receiversForSender.get(this.sender)) !== null && _b !== void 0 ? _b : [];
            try {
                for (var receivers_1 = tslib_1.__values(receivers), receivers_1_1 = receivers_1.next(); !receivers_1_1.done; receivers_1_1 = receivers_1.next()) {
                    var _c = receivers_1_1.value, signal = _c.signal, slot = _c.slot, context = _c.context;
                    if (signal === this) {
                        slot.call(context, args, this.sender);
                    }
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (receivers_1_1 && !receivers_1_1.done && (_a = receivers_1.return))
                        _a.call(receivers_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        return Signal;
    }());
    exports.Signal = Signal;
    Signal.__name__ = "Signal";
    var Signal0 = /** @class */ (function (_super) {
        tslib_1.__extends(Signal0, _super);
        function Signal0() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Signal0.prototype.emit = function () {
            _super.prototype.emit.call(this, undefined);
        };
        return Signal0;
    }(Signal));
    exports.Signal0 = Signal0;
    Signal0.__name__ = "Signal0";
    (function (Signal) {
        function disconnect_between(sender, receiver) {
            var e_2, _a;
            var receivers = receiversForSender.get(sender);
            if (receivers == null || receivers.length === 0)
                return;
            var senders = sendersForReceiver.get(receiver);
            if (senders == null || senders.length === 0)
                return;
            try {
                for (var senders_1 = tslib_1.__values(senders), senders_1_1 = senders_1.next(); !senders_1_1.done; senders_1_1 = senders_1.next()) {
                    var connection = senders_1_1.value;
                    if (connection.signal == null)
                        return;
                    if (connection.signal.sender === sender)
                        connection.signal = null;
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (senders_1_1 && !senders_1_1.done && (_a = senders_1.return))
                        _a.call(senders_1);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            schedule_cleanup(receivers);
            schedule_cleanup(senders);
        }
        Signal.disconnect_between = disconnect_between;
        function disconnect_sender(sender) {
            var e_3, _a;
            var _b;
            var receivers = receiversForSender.get(sender);
            if (receivers == null || receivers.length === 0)
                return;
            try {
                for (var receivers_2 = tslib_1.__values(receivers), receivers_2_1 = receivers_2.next(); !receivers_2_1.done; receivers_2_1 = receivers_2.next()) {
                    var connection = receivers_2_1.value;
                    if (connection.signal == null)
                        return;
                    var receiver = (_b = connection.context) !== null && _b !== void 0 ? _b : connection.slot;
                    connection.signal = null;
                    schedule_cleanup(sendersForReceiver.get(receiver));
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (receivers_2_1 && !receivers_2_1.done && (_a = receivers_2.return))
                        _a.call(receivers_2);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            schedule_cleanup(receivers);
        }
        Signal.disconnect_sender = disconnect_sender;
        function disconnect_receiver(receiver, slot, except_senders) {
            var e_4, _a;
            var senders = sendersForReceiver.get(receiver);
            if (senders == null || senders.length === 0)
                return;
            try {
                for (var senders_2 = tslib_1.__values(senders), senders_2_1 = senders_2.next(); !senders_2_1.done; senders_2_1 = senders_2.next()) {
                    var connection = senders_2_1.value;
                    if (connection.signal == null)
                        return;
                    if (slot != null && connection.slot != slot)
                        continue;
                    var sender = connection.signal.sender;
                    if (except_senders != null && except_senders.has(sender))
                        continue;
                    connection.signal = null;
                    schedule_cleanup(receiversForSender.get(sender));
                }
            }
            catch (e_4_1) {
                e_4 = { error: e_4_1 };
            }
            finally {
                try {
                    if (senders_2_1 && !senders_2_1.done && (_a = senders_2.return))
                        _a.call(senders_2);
                }
                finally {
                    if (e_4)
                        throw e_4.error;
                }
            }
            schedule_cleanup(senders);
        }
        Signal.disconnect_receiver = disconnect_receiver;
        function disconnect_all(obj) {
            var e_5, _a, e_6, _b;
            var receivers = receiversForSender.get(obj);
            if (receivers != null && receivers.length !== 0) {
                try {
                    for (var receivers_3 = tslib_1.__values(receivers), receivers_3_1 = receivers_3.next(); !receivers_3_1.done; receivers_3_1 = receivers_3.next()) {
                        var connection = receivers_3_1.value;
                        connection.signal = null;
                    }
                }
                catch (e_5_1) {
                    e_5 = { error: e_5_1 };
                }
                finally {
                    try {
                        if (receivers_3_1 && !receivers_3_1.done && (_a = receivers_3.return))
                            _a.call(receivers_3);
                    }
                    finally {
                        if (e_5)
                            throw e_5.error;
                    }
                }
                schedule_cleanup(receivers);
            }
            var senders = sendersForReceiver.get(obj);
            if (senders != null && senders.length !== 0) {
                try {
                    for (var senders_3 = tslib_1.__values(senders), senders_3_1 = senders_3.next(); !senders_3_1.done; senders_3_1 = senders_3.next()) {
                        var connection = senders_3_1.value;
                        connection.signal = null;
                    }
                }
                catch (e_6_1) {
                    e_6 = { error: e_6_1 };
                }
                finally {
                    try {
                        if (senders_3_1 && !senders_3_1.done && (_b = senders_3.return))
                            _b.call(senders_3);
                    }
                    finally {
                        if (e_6)
                            throw e_6.error;
                    }
                }
                schedule_cleanup(senders);
            }
        }
        Signal.disconnect_all = disconnect_all;
        /** @deprecated */
        Signal.disconnectBetween = disconnect_between;
        /** @deprecated */
        Signal.disconnectSender = disconnect_sender;
        /** @deprecated */
        Signal.disconnectReceiver = disconnect_receiver;
        /** @deprecated */
        Signal.disconnectAll = disconnect_all;
    })(Signal || (exports.Signal = Signal = {}));
    function Signalable() {
        return /** @class */ (function () {
            function class_1() {
            }
            class_1.prototype.connect = function (signal, slot) {
                return signal.connect(slot, this);
            };
            class_1.prototype.disconnect = function (signal, slot) {
                return signal.disconnect(slot, this);
            };
            return class_1;
        }());
    }
    exports.Signalable = Signalable;
    var receiversForSender = new WeakMap();
    var sendersForReceiver = new WeakMap();
    function find_connection(conns, signal, slot, context) {
        return array_1.find(conns, function (conn) { return conn.signal === signal && conn.slot === slot && conn.context === context; });
    }
    var dirty_set = new Set();
    function schedule_cleanup(connections) {
        var _this = this;
        if (dirty_set.size === 0) {
            (function () {
                return tslib_1.__awaiter(_this, void 0, void 0, function () {
                    return tslib_1.__generator(this, function (_a) {
                        switch (_a.label) {
                            case 0: return [4 /*yield*/, defer_1.defer()];
                            case 1:
                                _a.sent();
                                cleanup_dirty_set();
                                return [2 /*return*/];
                        }
                    });
                });
            })();
        }
        dirty_set.add(connections);
    }
    function cleanup_dirty_set() {
        var e_7, _a;
        try {
            for (var dirty_set_1 = tslib_1.__values(dirty_set), dirty_set_1_1 = dirty_set_1.next(); !dirty_set_1_1.done; dirty_set_1_1 = dirty_set_1.next()) {
                var connections = dirty_set_1_1.value;
                array_1.remove_by(connections, function (connection) { return connection.signal == null; });
            }
        }
        catch (e_7_1) {
            e_7 = { error: e_7_1 };
        }
        finally {
            try {
                if (dirty_set_1_1 && !dirty_set_1_1.done && (_a = dirty_set_1.return))
                    _a.call(dirty_set_1);
            }
            finally {
                if (e_7)
                    throw e_7.error;
            }
        }
        dirty_set.clear();
    }
},
/* core/util/defer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var channel = new MessageChannel();
    var tasks = new Map();
    channel.port1.onmessage = function (event) {
        var handle = event.data;
        var fn = tasks.get(handle);
        if (fn != null) {
            try {
                fn();
            }
            finally {
                tasks.delete(handle);
            }
        }
    };
    var counter = 1;
    function defer() {
        return new Promise(function (resolve) {
            var handle = counter++;
            tasks.set(handle, resolve);
            channel.port2.postMessage(handle);
        });
    }
    exports.defer = defer;
},
/* core/util/refs.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var types_1 = require(123) /* ./types */;
    var object_1 = require(128) /* ./object */;
    // Determine whether an object has the proper format of a Bokeh reference
    //
    // @param arg [Object] the object to test
    // @return [bool] whether the object is a reference
    //
    // @note this function does not check that the id and types are valid,
    //   only that the format is correct (all required keys are present)
    //
    function is_ref(arg) {
        if (types_1.isPlainObject(arg)) {
            var attrs = object_1.keys(arg);
            return attrs.length == 1 && attrs[0] == "id";
        }
        return false;
    }
    exports.is_ref = is_ref;
},
/* core/properties.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.YCoordinateSeqSeqSeqSpec = exports.XCoordinateSeqSeqSeqSpec = exports.YCoordinateSeqSpec = exports.XCoordinateSeqSpec = exports.YCoordinateSpec = exports.XCoordinateSpec = exports.CoordinateSeqSeqSeqSpec = exports.CoordinateSeqSpec = exports.CoordinateSpec = exports.BaseCoordinateSpec = exports.NumberUnitsSpec = exports.UnitsSpec = exports.DataSpec = exports.VectorSpec = exports.TextBaselineScalar = exports.TextAlignScalar = exports.FontStyleScalar = exports.FontSizeScalar = exports.FontScalar = exports.LineDashScalar = exports.LineCapScalar = exports.LineJoinScalar = exports.ArrayScalar = exports.NullStringScalar = exports.StringScalar = exports.NumberScalar = exports.ColorScalar = exports.AnyScalar = exports.ScalarSpec = exports.VerticalAlign = exports.UpdateMode = exports.TooltipAttachment = exports.TickLabelOrientation = exports.TextureRepetition = exports.TextBaseline = exports.TextAlign = exports.TapBehavior = exports.StepMode = exports.StartEnd = exports.SpatialUnits = exports.Sort = exports.SizingMode = exports.Side = exports.RoundingFunction = exports.ResetPolicy = exports.RenderMode = exports.RenderLevel = exports.RadiusDimension = exports.PointPolicy = exports.Place = void 0;
    exports.TextBaselineSpec = exports.TextAlignSpec = exports.FontStyleSpec = exports.FontSizeSpec = exports.FontSpec = exports.LineDashSpec = exports.LineCapSpec = exports.LineJoinSpec = exports.MarkerSpec = exports.ArraySpec = exports.NullStringSpec = exports.StringSpec = exports.AnySpec = exports.NDArraySpec = exports.ColorSpec = exports.NumberSpec = exports.BooleanSpec = exports.ScreenDistanceSpec = exports.NullDistanceSpec = exports.DistanceSpec = exports.AngleSpec = void 0;
    var tslib_1 = require(1) /* tslib */;
    var signaling_1 = require(130) /* ./signaling */;
    var logging_1 = require(134) /* ./logging */;
    var enums = tslib_1.__importStar(require(135) /* ./enums */);
    var types_1 = require(139) /* ./types */;
    var array_1 = require(124) /* ./util/array */;
    var arrayable_1 = require(127) /* ./util/arrayable */;
    var math_1 = require(125) /* ./util/math */;
    var color_1 = require(137) /* ./util/color */;
    var platform_1 = require(142) /* ./util/platform */;
    var types_2 = require(123) /* ./util/types */;
    var settings_1 = require(143) /* ./settings */;
    var ndarray_1 = require(144) /* ./util/ndarray */;
    var uniforms_1 = require(148) /* ./uniforms */;
    __esExport("Uniform", uniforms_1.Uniform);
    __esExport("UniformScalar", uniforms_1.UniformScalar);
    __esExport("UniformVector", uniforms_1.UniformVector);
    function valueToString(value) {
        try {
            return JSON.stringify(value);
        }
        catch (_a) {
            return value.toString();
        }
    }
    function isSpec(obj) {
        return types_2.isPlainObject(obj) &&
            ((obj.value === undefined ? 0 : 1) +
                (obj.field === undefined ? 0 : 1) +
                (obj.expr === undefined ? 0 : 1) == 1); // garbage JS XOR
    }
    exports.isSpec = isSpec;
    var Property = /** @class */ (function () {
        function Property(obj, attr, kind, default_value, initial_value, options) {
            if (options === void 0) {
                options = {};
            }
            var _a;
            this.obj = obj;
            this.attr = attr;
            this.kind = kind;
            this.default_value = default_value;
            this._dirty = false;
            this.change = new signaling_1.Signal0(this.obj, "change");
            this.internal = (_a = options.internal) !== null && _a !== void 0 ? _a : false;
            this.on_update = options.on_update;
            var attr_value;
            if (initial_value !== undefined) {
                attr_value = initial_value;
                this._dirty = true;
            }
            else {
                var value = this._default_override();
                if (value !== undefined)
                    attr_value = value;
                else if (default_value !== undefined)
                    attr_value = default_value(obj);
                else {
                    // XXX: temporary and super sketchy, but affects only "readonly" and a few internal properties
                    // console.warn(`${this.obj}.${this.attr} has no value nor default`)
                    this.spec = { value: null };
                    return;
                }
            }
            this._update(attr_value);
        }
        Object.defineProperty(Property.prototype, "is_value", {
            get: function () {
                return this.spec.value !== undefined;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Property.prototype, "syncable", {
            get: function () {
                return !this.internal;
            },
            enumerable: false,
            configurable: true
        });
        Property.prototype.get_value = function () {
            return this.spec.value;
        };
        Property.prototype.set_value = function (val) {
            this._update(val);
            this._dirty = true;
        };
        // abstract _intrinsic_default(): T
        Property.prototype._default_override = function () {
            return undefined;
        };
        Object.defineProperty(Property.prototype, "dirty", {
            get: function () {
                return this._dirty;
            },
            enumerable: false,
            configurable: true
        });
        //protected abstract _update(attr_value: T): void
        Property.prototype._update = function (attr_value) {
            var _a;
            this.validate(attr_value);
            this.spec = { value: attr_value };
            (_a = this.on_update) === null || _a === void 0 ? void 0 : _a.call(this, attr_value, this.obj);
        };
        Property.prototype.toString = function () {
            /*${this.name}*/
            return "Prop(" + this.obj + "." + this.attr + ", spec: " + valueToString(this.spec) + ")";
        };
        // ----- customizable policies
        Property.prototype.normalize = function (values) {
            return values;
        };
        Property.prototype.validate = function (value) {
            if (!this.valid(value))
                throw new Error(this.obj + "." + this.attr + " given invalid value: " + valueToString(value));
        };
        Property.prototype.valid = function (value) {
            return this.kind.valid(value);
        };
        // ----- property accessors
        Property.prototype._value = function (do_spec_transform) {
            if (do_spec_transform === void 0) {
                do_spec_transform = true;
            }
            if (!this.is_value)
                throw new Error("attempted to retrieve property value for property without value specification");
            var ret = this.normalize([this.spec.value])[0];
            if (this.spec.transform != null && do_spec_transform)
                ret = this.spec.transform.compute(ret);
            return ret;
        };
        return Property;
    }());
    exports.Property = Property;
    Property.__name__ = "Property";
    var PropertyAlias = /** @class */ (function () {
        function PropertyAlias(attr) {
            this.attr = attr;
        }
        return PropertyAlias;
    }());
    exports.PropertyAlias = PropertyAlias;
    PropertyAlias.__name__ = "PropertyAlias";
    function Alias(attr) {
        return new PropertyAlias(attr);
    }
    exports.Alias = Alias;
    //
    // Primitive Properties
    //
    var PrimitiveProperty = /** @class */ (function (_super) {
        tslib_1.__extends(PrimitiveProperty, _super);
        function PrimitiveProperty() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return PrimitiveProperty;
    }(Property));
    exports.PrimitiveProperty = PrimitiveProperty;
    PrimitiveProperty.__name__ = "PrimitiveProperty";
    /** @deprecated */
    var Any = /** @class */ (function (_super) {
        tslib_1.__extends(Any, _super);
        function Any() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Any;
    }(Property));
    exports.Any = Any;
    Any.__name__ = "Any";
    /** @deprecated */
    var Array = /** @class */ (function (_super) {
        tslib_1.__extends(Array, _super);
        function Array() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Array.prototype.valid = function (value) {
            return types_2.isArray(value) || types_2.isTypedArray(value);
        };
        return Array;
    }(Property));
    exports.Array = Array;
    Array.__name__ = "Array";
    /** @deprecated */
    var Boolean = /** @class */ (function (_super) {
        tslib_1.__extends(Boolean, _super);
        function Boolean() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Boolean.prototype.valid = function (value) {
            return types_2.isBoolean(value);
        };
        return Boolean;
    }(Property));
    exports.Boolean = Boolean;
    Boolean.__name__ = "Boolean";
    /** @deprecated */
    var Color = /** @class */ (function (_super) {
        tslib_1.__extends(Color, _super);
        function Color() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Color.prototype.valid = function (value) {
            return color_1.is_Color(value);
        };
        return Color;
    }(Property));
    exports.Color = Color;
    Color.__name__ = "Color";
    /** @deprecated */
    var Instance = /** @class */ (function (_super) {
        tslib_1.__extends(Instance, _super);
        function Instance() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Instance;
    }(Property));
    exports.Instance = Instance;
    Instance.__name__ = "Instance";
    /** @deprecated */
    var Number = /** @class */ (function (_super) {
        tslib_1.__extends(Number, _super);
        function Number() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Number.prototype.valid = function (value) {
            return types_2.isNumber(value);
        };
        return Number;
    }(Property));
    exports.Number = Number;
    Number.__name__ = "Number";
    /** @deprecated */
    var Int = /** @class */ (function (_super) {
        tslib_1.__extends(Int, _super);
        function Int() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Int.prototype.valid = function (value) {
            return types_2.isNumber(value) && (value | 0) == value;
        };
        return Int;
    }(Number));
    exports.Int = Int;
    Int.__name__ = "Int";
    /** @deprecated */
    var Angle = /** @class */ (function (_super) {
        tslib_1.__extends(Angle, _super);
        function Angle() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Angle;
    }(Number));
    exports.Angle = Angle;
    Angle.__name__ = "Angle";
    /** @deprecated */
    var Percent = /** @class */ (function (_super) {
        tslib_1.__extends(Percent, _super);
        function Percent() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Percent.prototype.valid = function (value) {
            return types_2.isNumber(value) && 0 <= value && value <= 1.0;
        };
        return Percent;
    }(Number));
    exports.Percent = Percent;
    Percent.__name__ = "Percent";
    /** @deprecated */
    var String = /** @class */ (function (_super) {
        tslib_1.__extends(String, _super);
        function String() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        String.prototype.valid = function (value) {
            return types_2.isString(value);
        };
        return String;
    }(Property));
    exports.String = String;
    String.__name__ = "String";
    /** @deprecated */
    var NullString = /** @class */ (function (_super) {
        tslib_1.__extends(NullString, _super);
        function NullString() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        NullString.prototype.valid = function (value) {
            return value === null || types_2.isString(value);
        };
        return NullString;
    }(Property));
    exports.NullString = NullString;
    NullString.__name__ = "NullString";
    /** @deprecated */
    var FontSize = /** @class */ (function (_super) {
        tslib_1.__extends(FontSize, _super);
        function FontSize() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return FontSize;
    }(String));
    exports.FontSize = FontSize;
    FontSize.__name__ = "FontSize";
    /** @deprecated */
    var Font = /** @class */ (function (_super) {
        tslib_1.__extends(Font, _super);
        function Font() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Font.prototype._default_override = function () {
            return settings_1.settings.dev ? "Bokeh" : undefined;
        };
        return Font;
    }(String));
    exports.Font = Font;
    Font.__name__ = "Font";
    //
    // Enum properties
    //
    /** @deprecated */
    var EnumProperty = /** @class */ (function (_super) {
        tslib_1.__extends(EnumProperty, _super);
        function EnumProperty() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        EnumProperty.prototype.valid = function (value) {
            return types_2.isString(value) && array_1.includes(this.enum_values, value);
        };
        return EnumProperty;
    }(Property));
    exports.EnumProperty = EnumProperty;
    EnumProperty.__name__ = "EnumProperty";
    /** @deprecated */
    function Enum(values) {
        return /** @class */ (function (_super) {
            tslib_1.__extends(class_1, _super);
            function class_1() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Object.defineProperty(class_1.prototype, "enum_values", {
                get: function () {
                    return tslib_1.__spread(values);
                },
                enumerable: false,
                configurable: true
            });
            return class_1;
        }(EnumProperty));
    }
    exports.Enum = Enum;
    var Direction = /** @class */ (function (_super) {
        tslib_1.__extends(Direction, _super);
        function Direction() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(Direction.prototype, "enum_values", {
            get: function () {
                return tslib_1.__spread(enums.Direction);
            },
            enumerable: false,
            configurable: true
        });
        Direction.prototype.normalize = function (values) {
            var result = new Uint8Array(values.length);
            for (var i = 0; i < values.length; i++) {
                switch (values[i]) {
                    case "clock":
                        result[i] = 0;
                        break;
                    case "anticlock":
                        result[i] = 1;
                        break;
                }
            }
            return result;
        };
        return Direction;
    }(EnumProperty));
    exports.Direction = Direction;
    Direction.__name__ = "Direction";
    /** @deprecated */ exports.Anchor = Enum(enums.Anchor);
    /** @deprecated */ exports.AngleUnits = Enum(enums.AngleUnits);
    /** @deprecated */ exports.BoxOrigin = Enum(enums.BoxOrigin);
    /** @deprecated */ exports.ButtonType = Enum(enums.ButtonType);
    /** @deprecated */ exports.CalendarPosition = Enum(enums.CalendarPosition);
    /** @deprecated */ exports.Dimension = Enum(enums.Dimension);
    /** @deprecated */ exports.Dimensions = Enum(enums.Dimensions);
    /** @deprecated */ exports.Distribution = Enum(enums.Distribution);
    /** @deprecated */ exports.FontStyle = Enum(enums.FontStyle);
    /** @deprecated */ exports.HatchPatternType = Enum(enums.HatchPatternType);
    /** @deprecated */ exports.HTTPMethod = Enum(enums.HTTPMethod);
    /** @deprecated */ exports.HexTileOrientation = Enum(enums.HexTileOrientation);
    /** @deprecated */ exports.HoverMode = Enum(enums.HoverMode);
    /** @deprecated */ exports.LatLon = Enum(enums.LatLon);
    /** @deprecated */ exports.LegendClickPolicy = Enum(enums.LegendClickPolicy);
    /** @deprecated */ exports.LegendLocation = Enum(enums.LegendLocation);
    /** @deprecated */ exports.LineCap = Enum(enums.LineCap);
    /** @deprecated */ exports.LineJoin = Enum(enums.LineJoin);
    /** @deprecated */ exports.LinePolicy = Enum(enums.LinePolicy);
    /** @deprecated */ exports.Location = Enum(enums.Location);
    /** @deprecated */ exports.Logo = Enum(enums.Logo);
    /** @deprecated */ exports.MarkerType = Enum(enums.MarkerType);
    /** @deprecated */ exports.MutedPolicy = Enum(enums.MutedPolicy);
    /** @deprecated */ exports.Orientation = Enum(enums.Orientation);
    /** @deprecated */ exports.OutputBackend = Enum(enums.OutputBackend);
    /** @deprecated */ exports.PaddingUnits = Enum(enums.PaddingUnits);
    /** @deprecated */ exports.Place = Enum(enums.Place);
    /** @deprecated */ exports.PointPolicy = Enum(enums.PointPolicy);
    /** @deprecated */ exports.RadiusDimension = Enum(enums.RadiusDimension);
    /** @deprecated */ exports.RenderLevel = Enum(enums.RenderLevel);
    /** @deprecated */ exports.RenderMode = Enum(enums.RenderMode);
    /** @deprecated */ exports.ResetPolicy = Enum(enums.ResetPolicy);
    /** @deprecated */ exports.RoundingFunction = Enum(enums.RoundingFunction);
    /** @deprecated */ exports.Side = Enum(enums.Side);
    /** @deprecated */ exports.SizingMode = Enum(enums.SizingMode);
    /** @deprecated */ exports.Sort = Enum(enums.Sort);
    /** @deprecated */ exports.SpatialUnits = Enum(enums.SpatialUnits);
    /** @deprecated */ exports.StartEnd = Enum(enums.StartEnd);
    /** @deprecated */ exports.StepMode = Enum(enums.StepMode);
    /** @deprecated */ exports.TapBehavior = Enum(enums.TapBehavior);
    /** @deprecated */ exports.TextAlign = Enum(enums.TextAlign);
    /** @deprecated */ exports.TextBaseline = Enum(enums.TextBaseline);
    /** @deprecated */ exports.TextureRepetition = Enum(enums.TextureRepetition);
    /** @deprecated */ exports.TickLabelOrientation = Enum(enums.TickLabelOrientation);
    /** @deprecated */ exports.TooltipAttachment = Enum(enums.TooltipAttachment);
    /** @deprecated */ exports.UpdateMode = Enum(enums.UpdateMode);
    /** @deprecated */ exports.VerticalAlign = Enum(enums.VerticalAlign);
    //
    // DataSpec properties
    //
    var ScalarSpec = /** @class */ (function (_super) {
        tslib_1.__extends(ScalarSpec, _super);
        function ScalarSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ScalarSpec.prototype.get_value = function () {
            // XXX: denormalize value for serialization, because bokeh doens't support scalar properties
            var _a = this.spec, value = _a.value, expr = _a.expr, transform = _a.transform;
            return (expr != null || transform != null ? this.spec : value);
            // XXX: allow obj.x = null; obj.x == null
            // return this.spec.value === null ? null : this.spec as any
        };
        ScalarSpec.prototype._update = function (attr_value) {
            if (isSpec(attr_value))
                this.spec = attr_value;
            else
                this.spec = { value: attr_value };
            if (this.spec.value != null)
                this.validate(this.spec.value);
        };
        ScalarSpec.prototype.materialize = function (value) {
            return value;
        };
        ScalarSpec.prototype.scalar = function (value, n) {
            return new uniforms_1.UniformScalar(value, n);
        };
        ScalarSpec.prototype.uniform = function (source) {
            var _a;
            var _b = this.spec, expr = _b.expr, value = _b.value, transform = _b.transform;
            var n = (_a = source.get_length()) !== null && _a !== void 0 ? _a : 1;
            if (expr != null) {
                var result = expr.compute(source);
                if (transform != null)
                    result = transform.compute(result);
                result = this.materialize(result);
                return this.scalar(result, n);
            }
            else {
                var result = value;
                if (transform != null)
                    result = transform.compute(result);
                result = this.materialize(result);
                return this.scalar(result, n);
            }
        };
        return ScalarSpec;
    }(Property));
    exports.ScalarSpec = ScalarSpec;
    ScalarSpec.__name__ = "ScalarSpec";
    var AnyScalar = /** @class */ (function (_super) {
        tslib_1.__extends(AnyScalar, _super);
        function AnyScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return AnyScalar;
    }(ScalarSpec));
    exports.AnyScalar = AnyScalar;
    AnyScalar.__name__ = "AnyScalar";
    var ColorScalar = /** @class */ (function (_super) {
        tslib_1.__extends(ColorScalar, _super);
        function ColorScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return ColorScalar;
    }(ScalarSpec));
    exports.ColorScalar = ColorScalar;
    ColorScalar.__name__ = "ColorScalar";
    var NumberScalar = /** @class */ (function (_super) {
        tslib_1.__extends(NumberScalar, _super);
        function NumberScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return NumberScalar;
    }(ScalarSpec));
    exports.NumberScalar = NumberScalar;
    NumberScalar.__name__ = "NumberScalar";
    var StringScalar = /** @class */ (function (_super) {
        tslib_1.__extends(StringScalar, _super);
        function StringScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return StringScalar;
    }(ScalarSpec));
    exports.StringScalar = StringScalar;
    StringScalar.__name__ = "StringScalar";
    var NullStringScalar = /** @class */ (function (_super) {
        tslib_1.__extends(NullStringScalar, _super);
        function NullStringScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return NullStringScalar;
    }(ScalarSpec));
    exports.NullStringScalar = NullStringScalar;
    NullStringScalar.__name__ = "NullStringScalar";
    var ArrayScalar = /** @class */ (function (_super) {
        tslib_1.__extends(ArrayScalar, _super);
        function ArrayScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return ArrayScalar;
    }(ScalarSpec));
    exports.ArrayScalar = ArrayScalar;
    ArrayScalar.__name__ = "ArrayScalar";
    var LineJoinScalar = /** @class */ (function (_super) {
        tslib_1.__extends(LineJoinScalar, _super);
        function LineJoinScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LineJoinScalar;
    }(ScalarSpec));
    exports.LineJoinScalar = LineJoinScalar;
    LineJoinScalar.__name__ = "LineJoinScalar";
    var LineCapScalar = /** @class */ (function (_super) {
        tslib_1.__extends(LineCapScalar, _super);
        function LineCapScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LineCapScalar;
    }(ScalarSpec));
    exports.LineCapScalar = LineCapScalar;
    LineCapScalar.__name__ = "LineCapScalar";
    var LineDashScalar = /** @class */ (function (_super) {
        tslib_1.__extends(LineDashScalar, _super);
        function LineDashScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LineDashScalar;
    }(ScalarSpec));
    exports.LineDashScalar = LineDashScalar;
    LineDashScalar.__name__ = "LineDashScalar";
    var FontScalar = /** @class */ (function (_super) {
        tslib_1.__extends(FontScalar, _super);
        function FontScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        FontScalar.prototype._default_override = function () {
            return settings_1.settings.dev ? "Bokeh" : undefined;
        };
        return FontScalar;
    }(ScalarSpec));
    exports.FontScalar = FontScalar;
    FontScalar.__name__ = "FontScalar";
    var FontSizeScalar = /** @class */ (function (_super) {
        tslib_1.__extends(FontSizeScalar, _super);
        function FontSizeScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return FontSizeScalar;
    }(ScalarSpec));
    exports.FontSizeScalar = FontSizeScalar;
    FontSizeScalar.__name__ = "FontSizeScalar";
    var FontStyleScalar = /** @class */ (function (_super) {
        tslib_1.__extends(FontStyleScalar, _super);
        function FontStyleScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return FontStyleScalar;
    }(ScalarSpec));
    exports.FontStyleScalar = FontStyleScalar;
    FontStyleScalar.__name__ = "FontStyleScalar";
    var TextAlignScalar = /** @class */ (function (_super) {
        tslib_1.__extends(TextAlignScalar, _super);
        function TextAlignScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return TextAlignScalar;
    }(ScalarSpec));
    exports.TextAlignScalar = TextAlignScalar;
    TextAlignScalar.__name__ = "TextAlignScalar";
    var TextBaselineScalar = /** @class */ (function (_super) {
        tslib_1.__extends(TextBaselineScalar, _super);
        function TextBaselineScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return TextBaselineScalar;
    }(ScalarSpec));
    exports.TextBaselineScalar = TextBaselineScalar;
    TextBaselineScalar.__name__ = "TextBaselineScalar";
    var VectorSpec = /** @class */ (function (_super) {
        tslib_1.__extends(VectorSpec, _super);
        function VectorSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        VectorSpec.prototype.get_value = function () {
            // XXX: allow obj.x = null; obj.x == null
            return this.spec.value === null ? null : this.spec;
        };
        VectorSpec.prototype._update = function (attr_value) {
            if (isSpec(attr_value))
                this.spec = attr_value;
            else
                this.spec = { value: attr_value };
            if (this.spec.value != null)
                this.validate(this.spec.value);
        };
        VectorSpec.prototype.materialize = function (value) {
            return value;
        };
        VectorSpec.prototype.v_materialize = function (values) {
            return values;
        };
        VectorSpec.prototype.scalar = function (value, n) {
            return new uniforms_1.UniformScalar(value, n);
        };
        VectorSpec.prototype.vector = function (values) {
            return new uniforms_1.UniformVector(values);
        };
        VectorSpec.prototype.uniform = function (source) {
            var _a;
            var _b = this.spec, field = _b.field, expr = _b.expr, value = _b.value, transform = _b.transform;
            var n = (_a = source.get_length()) !== null && _a !== void 0 ? _a : 1;
            if (field != null) {
                var array = source.get_column(field);
                if (array != null) {
                    if (transform != null)
                        array = transform.v_compute(array);
                    array = this.v_materialize(array);
                    return this.vector(array);
                }
                else {
                    logging_1.logger.warn("attempted to retrieve property array for nonexistent field '" + field + "'");
                    return this.scalar(null, n);
                }
            }
            else if (expr != null) {
                var array = expr.v_compute(source);
                if (transform != null)
                    array = transform.v_compute(array);
                array = this.v_materialize(array);
                return this.vector(array);
            }
            else {
                var result = value;
                if (transform != null)
                    result = transform.compute(result);
                result = this.materialize(result);
                return this.scalar(result, n);
            }
        };
        VectorSpec.prototype.array = function (source) {
            var _a;
            var array;
            var length = (_a = source.get_length()) !== null && _a !== void 0 ? _a : 1;
            if (this.spec.field != null) {
                var column = source.get_column(this.spec.field);
                if (column != null)
                    array = this.normalize(column);
                else {
                    logging_1.logger.warn("attempted to retrieve property array for nonexistent field '" + this.spec.field + "'");
                    var missing = new Float64Array(length);
                    missing.fill(NaN);
                    array = missing;
                }
            }
            else if (this.spec.expr != null) {
                array = this.normalize(this.spec.expr.v_compute(source));
            }
            else {
                var value = this._value(false); // don't apply any spec transform
                if (types_2.isNumber(value)) {
                    var values = new Float64Array(length);
                    values.fill(value);
                    array = values;
                }
                else
                    array = array_1.repeat(value, length);
            }
            if (this.spec.transform != null)
                array = this.spec.transform.v_compute(array);
            return array;
        };
        return VectorSpec;
    }(Property));
    exports.VectorSpec = VectorSpec;
    VectorSpec.__name__ = "VectorSpec";
    var DataSpec = /** @class */ (function (_super) {
        tslib_1.__extends(DataSpec, _super);
        function DataSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return DataSpec;
    }(VectorSpec));
    exports.DataSpec = DataSpec;
    DataSpec.__name__ = "DataSpec";
    var UnitsSpec = /** @class */ (function (_super) {
        tslib_1.__extends(UnitsSpec, _super);
        function UnitsSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        UnitsSpec.prototype._update = function (attr_value) {
            _super.prototype._update.call(this, attr_value);
            var units = this.spec.units;
            if (units != null && !array_1.includes(this.valid_units, units)) {
                throw new Error("units must be one of " + this.valid_units.join(", ") + "; got: " + units);
            }
        };
        Object.defineProperty(UnitsSpec.prototype, "units", {
            get: function () {
                var _a;
                return (_a = this.spec.units) !== null && _a !== void 0 ? _a : this.default_units;
            },
            set: function (units) {
                if (units != this.default_units)
                    this.spec.units = units;
                else
                    delete this.spec.units;
            },
            enumerable: false,
            configurable: true
        });
        return UnitsSpec;
    }(VectorSpec));
    exports.UnitsSpec = UnitsSpec;
    UnitsSpec.__name__ = "UnitsSpec";
    var NumberUnitsSpec = /** @class */ (function (_super) {
        tslib_1.__extends(NumberUnitsSpec, _super);
        function NumberUnitsSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        NumberUnitsSpec.prototype.array = function (source) {
            return new Float64Array(_super.prototype.array.call(this, source));
        };
        return NumberUnitsSpec;
    }(UnitsSpec));
    exports.NumberUnitsSpec = NumberUnitsSpec;
    NumberUnitsSpec.__name__ = "NumberUnitsSpec";
    var BaseCoordinateSpec = /** @class */ (function (_super) {
        tslib_1.__extends(BaseCoordinateSpec, _super);
        function BaseCoordinateSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return BaseCoordinateSpec;
    }(DataSpec));
    exports.BaseCoordinateSpec = BaseCoordinateSpec;
    BaseCoordinateSpec.__name__ = "BaseCoordinateSpec";
    var CoordinateSpec = /** @class */ (function (_super) {
        tslib_1.__extends(CoordinateSpec, _super);
        function CoordinateSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return CoordinateSpec;
    }(BaseCoordinateSpec));
    exports.CoordinateSpec = CoordinateSpec;
    CoordinateSpec.__name__ = "CoordinateSpec";
    var CoordinateSeqSpec = /** @class */ (function (_super) {
        tslib_1.__extends(CoordinateSeqSpec, _super);
        function CoordinateSeqSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return CoordinateSeqSpec;
    }(BaseCoordinateSpec));
    exports.CoordinateSeqSpec = CoordinateSeqSpec;
    CoordinateSeqSpec.__name__ = "CoordinateSeqSpec";
    var CoordinateSeqSeqSeqSpec = /** @class */ (function (_super) {
        tslib_1.__extends(CoordinateSeqSeqSeqSpec, _super);
        function CoordinateSeqSeqSeqSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return CoordinateSeqSeqSeqSpec;
    }(BaseCoordinateSpec));
    exports.CoordinateSeqSeqSeqSpec = CoordinateSeqSeqSeqSpec;
    CoordinateSeqSeqSeqSpec.__name__ = "CoordinateSeqSeqSeqSpec";
    var XCoordinateSpec = /** @class */ (function (_super) {
        tslib_1.__extends(XCoordinateSpec, _super);
        function XCoordinateSpec() {
            var _this = _super.apply(this, tslib_1.__spread(arguments)) || this;
            _this.dimension = "x";
            return _this;
        }
        return XCoordinateSpec;
    }(CoordinateSpec));
    exports.XCoordinateSpec = XCoordinateSpec;
    XCoordinateSpec.__name__ = "XCoordinateSpec";
    var YCoordinateSpec = /** @class */ (function (_super) {
        tslib_1.__extends(YCoordinateSpec, _super);
        function YCoordinateSpec() {
            var _this = _super.apply(this, tslib_1.__spread(arguments)) || this;
            _this.dimension = "y";
            return _this;
        }
        return YCoordinateSpec;
    }(CoordinateSpec));
    exports.YCoordinateSpec = YCoordinateSpec;
    YCoordinateSpec.__name__ = "YCoordinateSpec";
    var XCoordinateSeqSpec = /** @class */ (function (_super) {
        tslib_1.__extends(XCoordinateSeqSpec, _super);
        function XCoordinateSeqSpec() {
            var _this = _super.apply(this, tslib_1.__spread(arguments)) || this;
            _this.dimension = "x";
            return _this;
        }
        return XCoordinateSeqSpec;
    }(CoordinateSeqSpec));
    exports.XCoordinateSeqSpec = XCoordinateSeqSpec;
    XCoordinateSeqSpec.__name__ = "XCoordinateSeqSpec";
    var YCoordinateSeqSpec = /** @class */ (function (_super) {
        tslib_1.__extends(YCoordinateSeqSpec, _super);
        function YCoordinateSeqSpec() {
            var _this = _super.apply(this, tslib_1.__spread(arguments)) || this;
            _this.dimension = "y";
            return _this;
        }
        return YCoordinateSeqSpec;
    }(CoordinateSeqSpec));
    exports.YCoordinateSeqSpec = YCoordinateSeqSpec;
    YCoordinateSeqSpec.__name__ = "YCoordinateSeqSpec";
    var XCoordinateSeqSeqSeqSpec = /** @class */ (function (_super) {
        tslib_1.__extends(XCoordinateSeqSeqSeqSpec, _super);
        function XCoordinateSeqSeqSeqSpec() {
            var _this = _super.apply(this, tslib_1.__spread(arguments)) || this;
            _this.dimension = "x";
            return _this;
        }
        return XCoordinateSeqSeqSeqSpec;
    }(CoordinateSeqSeqSeqSpec));
    exports.XCoordinateSeqSeqSeqSpec = XCoordinateSeqSeqSeqSpec;
    XCoordinateSeqSeqSeqSpec.__name__ = "XCoordinateSeqSeqSeqSpec";
    var YCoordinateSeqSeqSeqSpec = /** @class */ (function (_super) {
        tslib_1.__extends(YCoordinateSeqSeqSeqSpec, _super);
        function YCoordinateSeqSeqSeqSpec() {
            var _this = _super.apply(this, tslib_1.__spread(arguments)) || this;
            _this.dimension = "y";
            return _this;
        }
        return YCoordinateSeqSeqSeqSpec;
    }(CoordinateSeqSeqSeqSpec));
    exports.YCoordinateSeqSeqSeqSpec = YCoordinateSeqSeqSeqSpec;
    YCoordinateSeqSeqSeqSpec.__name__ = "YCoordinateSeqSeqSeqSpec";
    var AngleSpec = /** @class */ (function (_super) {
        tslib_1.__extends(AngleSpec, _super);
        function AngleSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(AngleSpec.prototype, "default_units", {
            get: function () { return "rad"; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(AngleSpec.prototype, "valid_units", {
            get: function () { return tslib_1.__spread(enums.AngleUnits); },
            enumerable: false,
            configurable: true
        });
        AngleSpec.prototype.materialize = function (value) {
            var coeff = -math_1.to_radians_coeff(this.units);
            return value * coeff;
        };
        AngleSpec.prototype.v_materialize = function (values) {
            var coeff = -math_1.to_radians_coeff(this.units);
            var result = new Float32Array(values.length);
            arrayable_1.mul(values, coeff, result); // TODO: in-place?
            return result;
        };
        AngleSpec.prototype.array = function (_source) {
            throw new Error("not supported");
        };
        return AngleSpec;
    }(NumberUnitsSpec));
    exports.AngleSpec = AngleSpec;
    AngleSpec.__name__ = "AngleSpec";
    var DistanceSpec = /** @class */ (function (_super) {
        tslib_1.__extends(DistanceSpec, _super);
        function DistanceSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(DistanceSpec.prototype, "default_units", {
            get: function () { return "data"; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(DistanceSpec.prototype, "valid_units", {
            get: function () { return tslib_1.__spread(enums.SpatialUnits); },
            enumerable: false,
            configurable: true
        });
        return DistanceSpec;
    }(NumberUnitsSpec));
    exports.DistanceSpec = DistanceSpec;
    DistanceSpec.__name__ = "DistanceSpec";
    var NullDistanceSpec = /** @class */ (function (_super) {
        tslib_1.__extends(NullDistanceSpec, _super);
        function NullDistanceSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        NullDistanceSpec.prototype.materialize = function (value) {
            return value !== null && value !== void 0 ? value : NaN;
        };
        return NullDistanceSpec;
    }(DistanceSpec));
    exports.NullDistanceSpec = NullDistanceSpec;
    NullDistanceSpec.__name__ = "NullDistanceSpec";
    var ScreenDistanceSpec = /** @class */ (function (_super) {
        tslib_1.__extends(ScreenDistanceSpec, _super);
        function ScreenDistanceSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(ScreenDistanceSpec.prototype, "default_units", {
            get: function () { return "screen"; },
            enumerable: false,
            configurable: true
        });
        return ScreenDistanceSpec;
    }(DistanceSpec));
    exports.ScreenDistanceSpec = ScreenDistanceSpec;
    ScreenDistanceSpec.__name__ = "ScreenDistanceSpec";
    var BooleanSpec = /** @class */ (function (_super) {
        tslib_1.__extends(BooleanSpec, _super);
        function BooleanSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        BooleanSpec.prototype.v_materialize = function (values) {
            return new Uint8Array(values);
        };
        BooleanSpec.prototype.array = function (source) {
            return new Uint8Array(_super.prototype.array.call(this, source));
        };
        return BooleanSpec;
    }(DataSpec));
    exports.BooleanSpec = BooleanSpec;
    BooleanSpec.__name__ = "BooleanSpec";
    var NumberSpec = /** @class */ (function (_super) {
        tslib_1.__extends(NumberSpec, _super);
        function NumberSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        NumberSpec.prototype.v_materialize = function (values) {
            return types_2.isTypedArray(values) ? values : new Float64Array(values);
        };
        NumberSpec.prototype.array = function (source) {
            return new Float64Array(_super.prototype.array.call(this, source));
        };
        return NumberSpec;
    }(DataSpec));
    exports.NumberSpec = NumberSpec;
    NumberSpec.__name__ = "NumberSpec";
    var ColorSpec = /** @class */ (function (_super) {
        tslib_1.__extends(ColorSpec, _super);
        function ColorSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ColorSpec.prototype.materialize = function (color) {
            return color_1.encode_rgba(color_1.color2rgba(color));
        };
        ColorSpec.prototype.v_materialize = function (colors) {
            var e_1, _a, e_2, _b;
            if (ndarray_1.is_NDArray(colors)) {
                if (colors.dtype == "uint32" && colors.dimension == 1) {
                    return platform_1.to_big_endian(colors);
                }
                else if (colors.dtype == "uint8" && colors.dimension == 1) {
                    var _c = tslib_1.__read(colors.shape, 1), n = _c[0];
                    var array = new types_1.RGBAArray(4 * n);
                    var j = 0;
                    try {
                        for (var colors_1 = tslib_1.__values(colors), colors_1_1 = colors_1.next(); !colors_1_1.done; colors_1_1 = colors_1.next()) {
                            var gray = colors_1_1.value;
                            array[j++] = gray;
                            array[j++] = gray;
                            array[j++] = gray;
                            array[j++] = 255;
                        }
                    }
                    catch (e_1_1) {
                        e_1 = { error: e_1_1 };
                    }
                    finally {
                        try {
                            if (colors_1_1 && !colors_1_1.done && (_a = colors_1.return))
                                _a.call(colors_1);
                        }
                        finally {
                            if (e_1)
                                throw e_1.error;
                        }
                    }
                    return new types_1.ColorArray(array.buffer);
                }
                else if (colors.dtype == "uint8" && colors.dimension == 2) {
                    var _d = tslib_1.__read(colors.shape, 2), n = _d[0], d = _d[1];
                    if (d == 4) {
                        return new types_1.ColorArray(colors.buffer);
                    }
                    else if (d == 3) {
                        var array = new types_1.RGBAArray(4 * n);
                        for (var i = 0, j = 0; i < d * n;) {
                            array[j++] = colors[i++];
                            array[j++] = colors[i++];
                            array[j++] = colors[i++];
                            array[j++] = 255;
                        }
                        return new types_1.ColorArray(array.buffer);
                    }
                }
                else if ((colors.dtype == "float32" || colors.dtype == "float64") && colors.dimension == 2) {
                    var _e = tslib_1.__read(colors.shape, 2), n = _e[0], d = _e[1];
                    if (d == 3 || d == 4) {
                        var array = new types_1.RGBAArray(4 * n);
                        for (var i = 0, j = 0; i < d * n;) {
                            array[j++] = colors[i++] * 255;
                            array[j++] = colors[i++] * 255;
                            array[j++] = colors[i++] * 255;
                            array[j++] = (d == 3 ? 1 : colors[i++]) * 255;
                        }
                        return new types_1.ColorArray(array.buffer);
                    }
                }
            }
            else {
                var n = colors.length;
                var array = new types_1.RGBAArray(4 * n);
                var j = 0;
                try {
                    for (var colors_2 = tslib_1.__values(colors), colors_2_1 = colors_2.next(); !colors_2_1.done; colors_2_1 = colors_2.next()) {
                        var color = colors_2_1.value;
                        var _f = tslib_1.__read(color_1.color2rgba(color), 4), r = _f[0], g = _f[1], b = _f[2], a = _f[3];
                        array[j++] = r;
                        array[j++] = g;
                        array[j++] = b;
                        array[j++] = a;
                    }
                }
                catch (e_2_1) {
                    e_2 = { error: e_2_1 };
                }
                finally {
                    try {
                        if (colors_2_1 && !colors_2_1.done && (_b = colors_2.return))
                            _b.call(colors_2);
                    }
                    finally {
                        if (e_2)
                            throw e_2.error;
                    }
                }
                return new types_1.ColorArray(array.buffer);
            }
            throw new Error("invalid color array");
        };
        ColorSpec.prototype.vector = function (values) {
            return new uniforms_1.ColorUniformVector(values);
        };
        return ColorSpec;
    }(DataSpec));
    exports.ColorSpec = ColorSpec;
    ColorSpec.__name__ = "ColorSpec";
    var NDArraySpec = /** @class */ (function (_super) {
        tslib_1.__extends(NDArraySpec, _super);
        function NDArraySpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return NDArraySpec;
    }(DataSpec));
    exports.NDArraySpec = NDArraySpec;
    NDArraySpec.__name__ = "NDArraySpec";
    var AnySpec = /** @class */ (function (_super) {
        tslib_1.__extends(AnySpec, _super);
        function AnySpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return AnySpec;
    }(DataSpec));
    exports.AnySpec = AnySpec;
    AnySpec.__name__ = "AnySpec";
    var StringSpec = /** @class */ (function (_super) {
        tslib_1.__extends(StringSpec, _super);
        function StringSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return StringSpec;
    }(DataSpec));
    exports.StringSpec = StringSpec;
    StringSpec.__name__ = "StringSpec";
    var NullStringSpec = /** @class */ (function (_super) {
        tslib_1.__extends(NullStringSpec, _super);
        function NullStringSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return NullStringSpec;
    }(DataSpec));
    exports.NullStringSpec = NullStringSpec;
    NullStringSpec.__name__ = "NullStringSpec";
    var ArraySpec = /** @class */ (function (_super) {
        tslib_1.__extends(ArraySpec, _super);
        function ArraySpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return ArraySpec;
    }(DataSpec));
    exports.ArraySpec = ArraySpec;
    ArraySpec.__name__ = "ArraySpec";
    var MarkerSpec = /** @class */ (function (_super) {
        tslib_1.__extends(MarkerSpec, _super);
        function MarkerSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return MarkerSpec;
    }(DataSpec));
    exports.MarkerSpec = MarkerSpec;
    MarkerSpec.__name__ = "MarkerSpec";
    var LineJoinSpec = /** @class */ (function (_super) {
        tslib_1.__extends(LineJoinSpec, _super);
        function LineJoinSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LineJoinSpec;
    }(DataSpec));
    exports.LineJoinSpec = LineJoinSpec;
    LineJoinSpec.__name__ = "LineJoinSpec";
    var LineCapSpec = /** @class */ (function (_super) {
        tslib_1.__extends(LineCapSpec, _super);
        function LineCapSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LineCapSpec;
    }(DataSpec));
    exports.LineCapSpec = LineCapSpec;
    LineCapSpec.__name__ = "LineCapSpec";
    var LineDashSpec = /** @class */ (function (_super) {
        tslib_1.__extends(LineDashSpec, _super);
        function LineDashSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LineDashSpec;
    }(DataSpec));
    exports.LineDashSpec = LineDashSpec;
    LineDashSpec.__name__ = "LineDashSpec";
    var FontSpec = /** @class */ (function (_super) {
        tslib_1.__extends(FontSpec, _super);
        function FontSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        FontSpec.prototype._default_override = function () {
            return settings_1.settings.dev ? "Bokeh" : undefined;
        };
        return FontSpec;
    }(DataSpec));
    exports.FontSpec = FontSpec;
    FontSpec.__name__ = "FontSpec";
    var FontSizeSpec = /** @class */ (function (_super) {
        tslib_1.__extends(FontSizeSpec, _super);
        function FontSizeSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return FontSizeSpec;
    }(DataSpec));
    exports.FontSizeSpec = FontSizeSpec;
    FontSizeSpec.__name__ = "FontSizeSpec";
    var FontStyleSpec = /** @class */ (function (_super) {
        tslib_1.__extends(FontStyleSpec, _super);
        function FontStyleSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return FontStyleSpec;
    }(DataSpec));
    exports.FontStyleSpec = FontStyleSpec;
    FontStyleSpec.__name__ = "FontStyleSpec";
    var TextAlignSpec = /** @class */ (function (_super) {
        tslib_1.__extends(TextAlignSpec, _super);
        function TextAlignSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return TextAlignSpec;
    }(DataSpec));
    exports.TextAlignSpec = TextAlignSpec;
    TextAlignSpec.__name__ = "TextAlignSpec";
    var TextBaselineSpec = /** @class */ (function (_super) {
        tslib_1.__extends(TextBaselineSpec, _super);
        function TextBaselineSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return TextBaselineSpec;
    }(DataSpec));
    exports.TextBaselineSpec = TextBaselineSpec;
    TextBaselineSpec.__name__ = "TextBaselineSpec";
},
/* core/logging.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    // This is based on https://github.com/pimterry/loglevel
    var types_1 = require(123) /* ./util/types */;
    var object_1 = require(128) /* ./util/object */;
    var _loggers = {};
    var LogLevel = /** @class */ (function () {
        function LogLevel(name, level) {
            this.name = name;
            this.level = level;
        }
        return LogLevel;
    }());
    exports.LogLevel = LogLevel;
    LogLevel.__name__ = "LogLevel";
    var Logger = /** @class */ (function () {
        function Logger(name, level) {
            if (level === void 0) {
                level = Logger.INFO;
            }
            this._name = name;
            this.set_level(level);
        }
        Object.defineProperty(Logger, "levels", {
            get: function () {
                return Object.keys(Logger.log_levels);
            },
            enumerable: false,
            configurable: true
        });
        Logger.get = function (name, level) {
            if (level === void 0) {
                level = Logger.INFO;
            }
            if (name.length > 0) {
                var logger_1 = _loggers[name];
                if (logger_1 == null)
                    _loggers[name] = logger_1 = new Logger(name, level);
                return logger_1;
            }
            else
                throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level");
        };
        Object.defineProperty(Logger.prototype, "level", {
            get: function () {
                return this.get_level();
            },
            enumerable: false,
            configurable: true
        });
        Logger.prototype.get_level = function () {
            return this._log_level;
        };
        Logger.prototype.set_level = function (log_level) {
            var e_1, _a;
            if (log_level instanceof LogLevel)
                this._log_level = log_level;
            else if (types_1.isString(log_level) && Logger.log_levels[log_level] != null)
                this._log_level = Logger.log_levels[log_level];
            else
                throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");
            var logger_name = "[" + this._name + "]";
            try {
                for (var _b = tslib_1.__values(object_1.entries(Logger.log_levels)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var _d = tslib_1.__read(_c.value, 2), name = _d[0], log_level_1 = _d[1];
                    if (log_level_1.level < this._log_level.level || this._log_level.level === Logger.OFF.level)
                        this[name] = function () { };
                    else
                        this[name] = _method_factory(name, logger_name);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        Logger.prototype.trace = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        Logger.prototype.debug = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        Logger.prototype.info = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        Logger.prototype.warn = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        Logger.prototype.error = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        return Logger;
    }());
    exports.Logger = Logger;
    Logger.__name__ = "Logger";
    Logger.TRACE = new LogLevel("trace", 0);
    Logger.DEBUG = new LogLevel("debug", 1);
    Logger.INFO = new LogLevel("info", 2);
    Logger.WARN = new LogLevel("warn", 6);
    Logger.ERROR = new LogLevel("error", 7);
    Logger.FATAL = new LogLevel("fatal", 8);
    Logger.OFF = new LogLevel("off", 9);
    Logger.log_levels = {
        trace: Logger.TRACE,
        debug: Logger.DEBUG,
        info: Logger.INFO,
        warn: Logger.WARN,
        error: Logger.ERROR,
        fatal: Logger.FATAL,
        off: Logger.OFF,
    };
    function _method_factory(method_name, logger_name) {
        if (console[method_name] != null)
            return console[method_name].bind(console, logger_name);
        else if (console.log != null)
            return console.log.bind(console, logger_name);
        else
            return function () { };
    }
    exports.logger = Logger.get("bokeh");
    function set_log_level(level) {
        var previous_level = exports.logger.level;
        if (types_1.isString(level) && Logger.log_levels[level] == null) {
            console.log("[bokeh] unrecognized logging level '" + level + "' passed to Bokeh.set_log_level(), ignoring");
            console.log("[bokeh] valid log levels are: " + Logger.levels.join(', '));
        }
        else {
            console.log("[bokeh] setting log level to: '" + (types_1.isString(level) ? level : level.level) + "'");
            exports.logger.set_level(level);
        }
        return previous_level;
    }
    exports.set_log_level = set_log_level;
    function with_log_level(level, fn) {
        var original = set_log_level(level);
        try {
            fn();
        }
        finally {
            set_log_level(original);
        }
    }
    exports.with_log_level = with_log_level;
},
/* core/enums.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.VerticalAlign = void 0;
    var kinds_1 = require(136) /* ./kinds */;
    exports.Align = kinds_1.Enum("start", "center", "end");
    exports.Anchor = kinds_1.Enum("top_left", "top_center", "top_right", "center_left", "center_center", "center_right", "bottom_left", "bottom_center", "bottom_right", "top", "left", "center", "right", "bottom");
    exports.AngleUnits = kinds_1.Enum("deg", "rad", "grad", "turn");
    exports.BoxOrigin = kinds_1.Enum("corner", "center");
    exports.ButtonType = kinds_1.Enum("default", "primary", "success", "warning", "danger", "light");
    exports.CalendarPosition = kinds_1.Enum("auto", "above", "below");
    exports.Dimension = kinds_1.Enum("width", "height");
    exports.Dimensions = kinds_1.Enum("width", "height", "both");
    exports.Direction = kinds_1.Enum("clock", "anticlock");
    exports.Distribution = kinds_1.Enum("uniform", "normal");
    exports.FontStyle = kinds_1.Enum("normal", "italic", "bold", "bold italic");
    exports.HatchPatternType = kinds_1.Enum('blank', 'dot', 'ring', 'horizontal_line', 'vertical_line', 'cross', 'horizontal_dash', 'vertical_dash', 'spiral', 'right_diagonal_line', 'left_diagonal_line', 'diagonal_cross', 'right_diagonal_dash', 'left_diagonal_dash', 'horizontal_wave', 'vertical_wave', 'criss_cross', ' ', '.', 'o', '-', '|', '+', '"', ':', '@', '/', '\\', 'x', ',', '`', 'v', '>', '*');
    exports.HTTPMethod = kinds_1.Enum("POST", "GET");
    exports.HexTileOrientation = kinds_1.Enum("pointytop", "flattop");
    exports.HoverMode = kinds_1.Enum("mouse", "hline", "vline");
    exports.LatLon = kinds_1.Enum("lat", "lon");
    exports.LegendClickPolicy = kinds_1.Enum("none", "hide", "mute");
    exports.LegendLocation = exports.Anchor;
    exports.LineCap = kinds_1.Enum("butt", "round", "square");
    exports.LineJoin = kinds_1.Enum("miter", "round", "bevel");
    exports.LineDash = kinds_1.Enum("solid", "dashed", "dotted", "dotdash", "dashdot");
    exports.LinePolicy = kinds_1.Enum("prev", "next", "nearest", "interp", "none");
    exports.Location = kinds_1.Enum("above", "below", "left", "right");
    exports.Logo = kinds_1.Enum("normal", "grey");
    exports.MarkerType = kinds_1.Enum("asterisk", "circle", "circle_cross", "circle_dot", "circle_x", "circle_y", "cross", "dash", "diamond", "diamond_cross", "diamond_dot", "dot", "hex", "hex_dot", "inverted_triangle", "plus", "square", "square_cross", "square_dot", "square_pin", "square_x", "star", "star_dot", "triangle", "triangle_dot", "triangle_pin", "x", "y");
    exports.MutedPolicy = kinds_1.Enum("show", "ignore");
    exports.Orientation = kinds_1.Enum("vertical", "horizontal");
    exports.OutputBackend = kinds_1.Enum("canvas", "svg", "webgl");
    exports.PaddingUnits = kinds_1.Enum("percent", "absolute");
    exports.Place = kinds_1.Enum("above", "below", "left", "right", "center");
    exports.PointPolicy = kinds_1.Enum("snap_to_data", "follow_mouse", "none");
    exports.RadiusDimension = kinds_1.Enum("x", "y", "max", "min");
    exports.RenderLevel = kinds_1.Enum("image", "underlay", "glyph", "guide", "annotation", "overlay");
    exports.RenderMode = kinds_1.Enum("canvas", "css");
    exports.ResetPolicy = kinds_1.Enum("standard", "event_only");
    exports.RoundingFunction = kinds_1.Enum("round", "nearest", "floor", "rounddown", "ceil", "roundup");
    exports.SelectionMode = kinds_1.Enum("replace", "append", "intersect", "subtract");
    exports.Side = kinds_1.Enum("above", "below", "left", "right");
    exports.SizingMode = kinds_1.Enum("stretch_width", "stretch_height", "stretch_both", "scale_width", "scale_height", "scale_both", "fixed");
    exports.Sort = kinds_1.Enum("ascending", "descending");
    exports.SpatialUnits = kinds_1.Enum("screen", "data");
    exports.StartEnd = kinds_1.Enum("start", "end");
    exports.StepMode = kinds_1.Enum("after", "before", "center");
    exports.TapBehavior = kinds_1.Enum("select", "inspect");
    exports.TextAlign = kinds_1.Enum("left", "right", "center");
    exports.TextBaseline = kinds_1.Enum("top", "middle", "bottom", "alphabetic", "hanging", "ideographic");
    exports.TextureRepetition = kinds_1.Enum("repeat", "repeat_x", "repeat_y", "no_repeat");
    exports.TickLabelOrientation = kinds_1.Enum("vertical", "horizontal", "parallel", "normal");
    exports.TooltipAttachment = kinds_1.Enum("horizontal", "vertical", "left", "right", "above", "below");
    exports.UpdateMode = kinds_1.Enum("replace", "append");
    exports.VerticalAlign = kinds_1.Enum("top", "middle", "bottom");
},
/* core/kinds.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var tp = tslib_1.__importStar(require(123) /* ./util/types */);
    var color_1 = require(137) /* ./util/color */;
    var object_1 = require(128) /* ./util/object */;
    var ESMap = window.Map;
    var hasOwnProperty = Object.prototype.hasOwnProperty;
    var Kind = /** @class */ (function () {
        function Kind() {
        }
        return Kind;
    }());
    exports.Kind = Kind;
    Kind.__name__ = "Kind";
    (function (Kinds) {
        var Any = /** @class */ (function (_super) {
            tslib_1.__extends(Any, _super);
            function Any() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Any.prototype.valid = function (_value) {
                return true;
            };
            return Any;
        }(Kind));
        Any.__name__ = "Any";
        Kinds.Any = Any;
        var Unknown = /** @class */ (function (_super) {
            tslib_1.__extends(Unknown, _super);
            function Unknown() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Unknown.prototype.valid = function (_value) {
                return true;
            };
            return Unknown;
        }(Kind));
        Unknown.__name__ = "Unknown";
        Kinds.Unknown = Unknown;
        var Boolean = /** @class */ (function (_super) {
            tslib_1.__extends(Boolean, _super);
            function Boolean() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Boolean.prototype.valid = function (value) {
                return tp.isBoolean(value);
            };
            return Boolean;
        }(Kind));
        Boolean.__name__ = "Boolean";
        Kinds.Boolean = Boolean;
        var Ref = /** @class */ (function (_super) {
            tslib_1.__extends(Ref, _super);
            function Ref(obj_type) {
                var _this = _super.call(this) || this;
                _this.obj_type = obj_type;
                return _this;
            }
            Ref.prototype.valid = function (_value) {
                // XXX: disable validation for now, because object graph initialization depends on this.
                // return value instanceof this.obj_type
                return true;
            };
            return Ref;
        }(Kind));
        Ref.__name__ = "Ref";
        Kinds.Ref = Ref;
        var AnyRef = /** @class */ (function (_super) {
            tslib_1.__extends(AnyRef, _super);
            function AnyRef() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            AnyRef.prototype.valid = function (_value) {
                // XXX: disable validation for now, because object graph initialization depends on this.
                // return tp.isObject(value)
                return true;
            };
            return AnyRef;
        }(Kind));
        AnyRef.__name__ = "AnyRef";
        Kinds.AnyRef = AnyRef;
        var Number = /** @class */ (function (_super) {
            tslib_1.__extends(Number, _super);
            function Number() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Number.prototype.valid = function (value) {
                return tp.isNumber(value);
            };
            return Number;
        }(Kind));
        Number.__name__ = "Number";
        Kinds.Number = Number;
        var Int = /** @class */ (function (_super) {
            tslib_1.__extends(Int, _super);
            function Int() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Int.prototype.valid = function (value) {
                return _super.prototype.valid.call(this, value) && tp.isInteger(value);
            };
            return Int;
        }(Number));
        Int.__name__ = "Int";
        Kinds.Int = Int;
        var Percent = /** @class */ (function (_super) {
            tslib_1.__extends(Percent, _super);
            function Percent() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Percent.prototype.valid = function (value) {
                return _super.prototype.valid.call(this, value) && 0 <= value && value <= 1;
            };
            return Percent;
        }(Number));
        Percent.__name__ = "Percent";
        Kinds.Percent = Percent;
        var Or = /** @class */ (function (_super) {
            tslib_1.__extends(Or, _super);
            function Or(types) {
                var _this = _super.call(this) || this;
                _this.types = types;
                _this.types = types;
                return _this;
            }
            Or.prototype.valid = function (value) {
                return this.types.some(function (type) { return type.valid(value); });
            };
            return Or;
        }(Kind));
        Or.__name__ = "Or";
        Kinds.Or = Or;
        var Tuple = /** @class */ (function (_super) {
            tslib_1.__extends(Tuple, _super);
            function Tuple(types) {
                var _this = _super.call(this) || this;
                _this.types = types;
                _this.types = types;
                return _this;
            }
            Tuple.prototype.valid = function (value) {
                if (!tp.isArray(value))
                    return false;
                for (var i = 0; i < this.types.length; i++) {
                    var type = this.types[i];
                    var item = value[i];
                    if (!type.valid(item))
                        return false;
                }
                return true;
            };
            return Tuple;
        }(Kind));
        Tuple.__name__ = "Tuple";
        Kinds.Tuple = Tuple;
        var Struct = /** @class */ (function (_super) {
            tslib_1.__extends(Struct, _super);
            function Struct(struct_type) {
                var _this = _super.call(this) || this;
                _this.struct_type = struct_type;
                return _this;
            }
            Struct.prototype.valid = function (value) {
                if (!tp.isPlainObject(value))
                    return false;
                var struct_type = this.struct_type;
                if (object_1.size(struct_type) != object_1.size(value))
                    return false;
                for (var key in struct_type) {
                    if (hasOwnProperty.call(struct_type, key)) {
                        if (!hasOwnProperty.call(value, key))
                            return false;
                        var item_type = struct_type[key];
                        var item = value[key];
                        if (!item_type.valid(item))
                            return false;
                    }
                }
                return true;
            };
            return Struct;
        }(Kind));
        Struct.__name__ = "Struct";
        Kinds.Struct = Struct;
        var Arrayable = /** @class */ (function (_super) {
            tslib_1.__extends(Arrayable, _super);
            function Arrayable() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Arrayable.prototype.valid = function (value) {
                return tp.isArray(value) || tp.isTypedArray(value); // TODO: too specific
            };
            return Arrayable;
        }(Kind));
        Arrayable.__name__ = "Arrayable";
        Kinds.Arrayable = Arrayable;
        var Array = /** @class */ (function (_super) {
            tslib_1.__extends(Array, _super);
            function Array(item_type) {
                var _this = _super.call(this) || this;
                _this.item_type = item_type;
                return _this;
            }
            Array.prototype.valid = function (value) {
                var _this = this;
                return tp.isArray(value) && value.every(function (item) { return _this.item_type.valid(item); });
            };
            return Array;
        }(Kind));
        Array.__name__ = "Array";
        Kinds.Array = Array;
        var Null = /** @class */ (function (_super) {
            tslib_1.__extends(Null, _super);
            function Null() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Null.prototype.valid = function (value) {
                return value === null;
            };
            return Null;
        }(Kind));
        Null.__name__ = "Null";
        Kinds.Null = Null;
        var Nullable = /** @class */ (function (_super) {
            tslib_1.__extends(Nullable, _super);
            function Nullable(base_type) {
                var _this = _super.call(this) || this;
                _this.base_type = base_type;
                return _this;
            }
            Nullable.prototype.valid = function (value) {
                return value === null || this.base_type.valid(value);
            };
            return Nullable;
        }(Kind));
        Nullable.__name__ = "Nullable";
        Kinds.Nullable = Nullable;
        var Opt = /** @class */ (function (_super) {
            tslib_1.__extends(Opt, _super);
            function Opt(base_type) {
                var _this = _super.call(this) || this;
                _this.base_type = base_type;
                return _this;
            }
            Opt.prototype.valid = function (value) {
                return value === undefined || this.base_type.valid(value);
            };
            return Opt;
        }(Kind));
        Opt.__name__ = "Opt";
        Kinds.Opt = Opt;
        var String = /** @class */ (function (_super) {
            tslib_1.__extends(String, _super);
            function String() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            String.prototype.valid = function (value) {
                return tp.isString(value);
            };
            return String;
        }(Kind));
        String.__name__ = "String";
        Kinds.String = String;
        var Enum = /** @class */ (function (_super) {
            tslib_1.__extends(Enum, _super);
            function Enum(values) {
                var _this = _super.call(this) || this;
                _this.values = new Set(values);
                return _this;
            }
            Enum.prototype.valid = function (value) {
                return this.values.has(value);
            };
            Enum.prototype[Symbol.iterator] = function () {
                return tslib_1.__generator(this, function (_a) {
                    switch (_a.label) {
                        case 0: return [5 /*yield**/, tslib_1.__values(this.values)];
                        case 1:
                            _a.sent();
                            return [2 /*return*/];
                    }
                });
            };
            return Enum;
        }(Kind));
        Enum.__name__ = "Enum";
        Kinds.Enum = Enum;
        var Dict = /** @class */ (function (_super) {
            tslib_1.__extends(Dict, _super);
            function Dict(item_type) {
                var _this = _super.call(this) || this;
                _this.item_type = item_type;
                return _this;
            }
            Dict.prototype.valid = function (value) {
                if (!tp.isPlainObject(value))
                    return false;
                for (var key in value) {
                    if (hasOwnProperty.call(value, key)) {
                        var item = value[key];
                        if (!this.item_type.valid(item))
                            return false;
                    }
                }
                return true;
            };
            return Dict;
        }(Kind));
        Dict.__name__ = "Dict";
        Kinds.Dict = Dict;
        var Map = /** @class */ (function (_super) {
            tslib_1.__extends(Map, _super);
            function Map(key_type, item_type) {
                var _this = _super.call(this) || this;
                _this.key_type = key_type;
                _this.item_type = item_type;
                return _this;
            }
            Map.prototype.valid = function (value) {
                var e_1, _a;
                if (!(value instanceof ESMap))
                    return false;
                try {
                    for (var _b = tslib_1.__values(value.entries()), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var _d = tslib_1.__read(_c.value, 2), key = _d[0], item = _d[1];
                        if (!(this.key_type.valid(key) && this.item_type.valid(item)))
                            return false;
                    }
                }
                catch (e_1_1) {
                    e_1 = { error: e_1_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_1)
                            throw e_1.error;
                    }
                }
                return true;
            };
            return Map;
        }(Kind));
        Map.__name__ = "Map";
        Kinds.Map = Map;
        var Color = /** @class */ (function (_super) {
            tslib_1.__extends(Color, _super);
            function Color() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Color.prototype.valid = function (value) {
                return color_1.is_Color(value);
            };
            return Color;
        }(Kind));
        Color.__name__ = "Color";
        Kinds.Color = Color;
        var Function = /** @class */ (function (_super) {
            tslib_1.__extends(Function, _super);
            function Function() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            Function.prototype.valid = function (value) {
                return tp.isFunction(value);
            };
            return Function;
        }(Kind));
        Function.__name__ = "Function";
        Kinds.Function = Function;
    })(exports.Kinds || (exports.Kinds = {}));
    exports.Any = new exports.Kinds.Any();
    exports.Unknown = new exports.Kinds.Unknown();
    exports.Boolean = new exports.Kinds.Boolean();
    exports.Number = new exports.Kinds.Number();
    exports.Int = new exports.Kinds.Int();
    exports.String = new exports.Kinds.String();
    exports.Null = new exports.Kinds.Null();
    var Nullable = function (base_type) { return new exports.Kinds.Nullable(base_type); };
    exports.Nullable = Nullable;
    var Opt = function (base_type) { return new exports.Kinds.Opt(base_type); };
    exports.Opt = Opt;
    var Or = function () {
        var types = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            types[_i] = arguments[_i];
        }
        return new exports.Kinds.Or(types);
    };
    exports.Or = Or;
    var Tuple = function () {
        var types = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            types[_i] = arguments[_i];
        }
        return new exports.Kinds.Tuple(types);
    };
    exports.Tuple = Tuple;
    var Struct = function (struct_type) { return new exports.Kinds.Struct(struct_type); };
    exports.Struct = Struct;
    exports.Arrayable = new exports.Kinds.Arrayable();
    var Array = function (item_type) { return new exports.Kinds.Array(item_type); };
    exports.Array = Array;
    var Dict = function (item_type) { return new exports.Kinds.Dict(item_type); };
    exports.Dict = Dict;
    var Map = function (key_type, item_type) { return new exports.Kinds.Map(key_type, item_type); };
    exports.Map = Map;
    var Enum = function () {
        var values = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            values[_i] = arguments[_i];
        }
        return new exports.Kinds.Enum(values);
    };
    exports.Enum = Enum;
    var Ref = function (obj_type) { return new exports.Kinds.Ref(obj_type); };
    exports.Ref = Ref;
    var AnyRef = function () { return new exports.Kinds.AnyRef(); };
    exports.AnyRef = AnyRef;
    var Function = function () { return new exports.Kinds.Function(); };
    exports.Function = Function;
    exports.Percent = new exports.Kinds.Percent();
    exports.Alpha = exports.Percent;
    exports.Color = new exports.Kinds.Color();
    exports.Auto = exports.Enum("auto");
    exports.FontSize = exports.String;
    exports.Font = exports.String;
    exports.Angle = exports.Number;
},
/* core/util/color.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var svg_colors_1 = require(138) /* ./svg_colors */;
    var math_1 = require(125) /* ./math */;
    var types_1 = require(123) /* ./types */;
    var round = Math.round;
    function byte(v) {
        return math_1.clamp(round(v), 0, 255);
    }
    function transparent() {
        return [0, 0, 0, 0];
    }
    exports.transparent = transparent;
    function encode_rgba(_a) {
        var _b = tslib_1.__read(_a, 4), r = _b[0], g = _b[1], b = _b[2], a = _b[3];
        return r << 24 | g << 16 | b << 8 | a;
    }
    exports.encode_rgba = encode_rgba;
    function decode_rgba(rgba) {
        var r = (rgba >> 24) & 0xff;
        var g = (rgba >> 16) & 0xff;
        var b = (rgba >> 8) & 0xff;
        var a = rgba & 0xff;
        return [r, g, b, a];
    }
    exports.decode_rgba = decode_rgba;
    function compose_alpha(color, alpha) {
        if ((color & 0xff) == 255)
            return (color & 0xffffff00) | byte(alpha * 255);
        else
            return color;
    }
    exports.compose_alpha = compose_alpha;
    function color2rgba(color, alpha) {
        var _a, _b, _c, _d, _e;
        var _f;
        var r, g, b, a;
        if (color == null)
            _a = tslib_1.__read(transparent(), 4), r = _a[0], g = _a[1], b = _a[2], a = _a[3];
        else if (types_1.isInteger(color))
            _b = tslib_1.__read(decode_rgba(color), 4), r = _b[0], g = _b[1], b = _b[2], a = _b[3];
        else if (types_1.isString(color))
            _c = tslib_1.__read((_f = css4_parse(color)) !== null && _f !== void 0 ? _f : transparent(), 4), r = _c[0], g = _c[1], b = _c[2], a = _c[3];
        else {
            _d = tslib_1.__read(color, 4), r = _d[0], g = _d[1], b = _d[2], _e = _d[3], a = _e === void 0 ? 1.0 : _e;
            a = byte(a * 255);
        }
        if (a == 255 && alpha != null)
            a = byte(alpha * 255);
        return [r, g, b, a];
    }
    exports.color2rgba = color2rgba;
    var _hex_table = {
        0: "0", 1: "1", 2: "2", 3: "3", 4: "4", 5: "5", 6: "6", 7: "7", 8: "8", 9: "9",
        10: "a", 11: "b", 12: "c", 13: "d", 14: "e", 15: "f",
    };
    function hex(v) {
        return _hex_table[v >> 4] + _hex_table[v & 0xf];
    }
    function color2css(color, alpha) {
        var _a = tslib_1.__read(color2rgba(color, alpha), 4), r = _a[0], g = _a[1], b = _a[2], a = _a[3];
        return "rgba(" + r + ", " + g + ", " + b + ", " + a / 255 + ")";
    }
    exports.color2css = color2css;
    function color2hex(color, alpha) {
        var _a = tslib_1.__read(color2rgba(color, alpha), 4), r = _a[0], g = _a[1], b = _a[2], a = _a[3];
        var rgb = "#" + hex(r) + hex(g) + hex(b);
        return a == 255 ? rgb : "" + rgb + hex(a);
    }
    exports.color2hex = color2hex;
    function color2hexrgb(color) {
        var _a = tslib_1.__read(color2rgba(color), 3), r = _a[0], g = _a[1], b = _a[2];
        return "#" + hex(r) + hex(g) + hex(b);
    }
    exports.color2hexrgb = color2hexrgb;
    /*
    let _last_color = "transparent"
    let _last_alpha = 1.0
    let _last_rgba = transparent()
    
    export function _color2rgba(color: string | null, alpha: number = 1.0): RGBA {
      if (color == _last_color && alpha == _last_alpha)
        return [..._last_rgba]
    
      const [r, g, b, a] = parsed
      const rgba: RGBA = [r, g, b, a == 255 ? byte(alpha*255) : a]
      _last_color = color
      _last_alpha = alpha
      _last_rgba = rgba
      return rgba
    }
    */
    var rgb_modern = /^rgba?\(\s*([^\s,]+?)\s+([^\s,]+?)\s+([^\s,]+?)(?:\s*\/\s*([^\s,]+?))?\s*\)$/;
    var rgb_legacy = /^rgba?\(\s*([^\s,]+?)\s*,\s*([^\s,]+?)\s*,\s*([^\s,]+?)(?:\s*,\s*([^\s,]+?))?\s*\)$/;
    var css4_normalize = (function () {
        var canvas = document.createElement("canvas");
        canvas.width = 1;
        canvas.height = 1;
        var ctx = canvas.getContext("2d");
        var gradient = ctx.createLinearGradient(0, 0, 1, 1);
        return function (color) {
            ctx.fillStyle = gradient; // lgtm [js/useless-assignment-to-property]
            ctx.fillStyle = color;
            var style = ctx.fillStyle;
            return style != gradient ? style : null;
        };
    })();
    function css4_parse(color) {
        var _a;
        /**
          Parses CSS4 color strings:
      
          - transparent
          - named color
          - #RRGGBB[AA]
          - #RGB[A]
          - rgb[a](R G B[ / A])
          - rgb[a](R, G, B[, A])
          - other CSS4 syntax (browser dependent)
      
        */
        color = color.trim().toLowerCase();
        if (!color)
            return null;
        else if (color == "transparent")
            return transparent();
        else if (svg_colors_1.is_named_color(color)) {
            return decode_rgba(svg_colors_1.named_colors[color]);
        }
        else if (color[0] == "#") {
            var v = Number("0x" + color.substr(1));
            if (isNaN(v))
                return null;
            switch (color.length - 1) {
                case 3: {
                    var r = (v >> 8) & 0xf;
                    var g = (v >> 4) & 0xf;
                    var b = (v >> 0) & 0xf;
                    var rr = (r << 4) | r;
                    var gg = (g << 4) | g;
                    var bb = (b << 4) | b;
                    return [rr, gg, bb, 255];
                }
                case 4: {
                    var r = (v >> 12) & 0xf;
                    var g = (v >> 8) & 0xf;
                    var b = (v >> 4) & 0xf;
                    var a = (v >> 0) & 0xf;
                    var rr = (r << 4) | r;
                    var gg = (g << 4) | g;
                    var bb = (b << 4) | b;
                    var aa = (a << 4) | a;
                    return [rr, gg, bb, aa];
                }
                case 6: {
                    var rr = (v >> 16) & 0xff;
                    var gg = (v >> 8) & 0xff;
                    var bb = (v >> 0) & 0xff;
                    return [rr, gg, bb, 255];
                }
                case 8: {
                    var rr = (v >> 24) & 0xff;
                    var gg = (v >> 16) & 0xff;
                    var bb = (v >> 8) & 0xff;
                    var aa = (v >> 0) & 0xff;
                    return [rr, gg, bb, aa];
                }
            }
        }
        else if (color.startsWith("rgb")) {
            var result = (_a = color.match(rgb_modern)) !== null && _a !== void 0 ? _a : color.match(rgb_legacy);
            if (result != null) {
                var _b = tslib_1.__read(result, 5), r = _b[1], g = _b[2], b = _b[3], _c = _b[4], a = _c === void 0 ? "1" : _c; // XXX: use groups when IE is dropped
                var rp = r.endsWith("%");
                var gp = g.endsWith("%");
                var bp = b.endsWith("%");
                var ap = a.endsWith("%");
                if (!(rp && gp && bp || (!rp && !gp && !bp)))
                    return null;
                if (rp)
                    r = r.slice(0, -1);
                if (gp)
                    g = g.slice(0, -1);
                if (bp)
                    b = b.slice(0, -1);
                if (ap)
                    a = a.slice(0, -1);
                var R = Number(r);
                var G = Number(g);
                var B = Number(b);
                var A = Number(a);
                if (isNaN(R + G + B + A))
                    return null;
                if (rp)
                    R = 255 * (R / 100);
                if (gp)
                    G = 255 * (G / 100);
                if (bp)
                    B = 255 * (B / 100);
                A = 255 * (ap ? A / 100 : A);
                R = byte(R);
                G = byte(G);
                B = byte(B);
                A = byte(A);
                return [R, G, B, A];
            }
        }
        else {
            var style = css4_normalize(color);
            if (style != null)
                return css4_parse(style);
        }
        return null;
    }
    exports.css4_parse = css4_parse;
    function is_Color(value) {
        if (types_1.isInteger(value))
            return true;
        if (types_1.isString(value) && css4_parse(value) != null)
            return true;
        if (types_1.isArray(value) && (value.length == 3 || value.length == 4))
            return true;
        return false;
    }
    exports.is_Color = is_Color;
    function is_dark(_a) {
        var _b = tslib_1.__read(_a, 3), r = _b[0], g = _b[1], b = _b[2];
        var l = 1 - (0.299 * r + 0.587 * g + 0.114 * b) / 255;
        return l >= 0.6;
    }
    exports.is_dark = is_dark;
},
/* core/util/svg_colors.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var _named_colors = {
        aliceblue: 0xf0f8ffff,
        antiquewhite: 0xfaebd7ff,
        aqua: 0x00ffffff,
        aquamarine: 0x7fffd4ff,
        azure: 0xf0ffffff,
        beige: 0xf5f5dcff,
        bisque: 0xffe4c4ff,
        black: 0x000000ff,
        blanchedalmond: 0xffebcdff,
        blue: 0x0000ffff,
        blueviolet: 0x8a2be2ff,
        brown: 0xa52a2aff,
        burlywood: 0xdeb887ff,
        cadetblue: 0x5f9ea0ff,
        chartreuse: 0x7fff00ff,
        chocolate: 0xd2691eff,
        coral: 0xff7f50ff,
        cornflowerblue: 0x6495edff,
        cornsilk: 0xfff8dcff,
        crimson: 0xdc143cff,
        cyan: 0x00ffffff,
        darkblue: 0x00008bff,
        darkcyan: 0x008b8bff,
        darkgoldenrod: 0xb8860bff,
        darkgray: 0xa9a9a9ff,
        darkgreen: 0x006400ff,
        darkgrey: 0xa9a9a9ff,
        darkkhaki: 0xbdb76bff,
        darkmagenta: 0x8b008bff,
        darkolivegreen: 0x556b2fff,
        darkorange: 0xff8c00ff,
        darkorchid: 0x9932ccff,
        darkred: 0x8b0000ff,
        darksalmon: 0xe9967aff,
        darkseagreen: 0x8fbc8fff,
        darkslateblue: 0x483d8bff,
        darkslategray: 0x2f4f4fff,
        darkslategrey: 0x2f4f4fff,
        darkturquoise: 0x00ced1ff,
        darkviolet: 0x9400d3ff,
        deeppink: 0xff1493ff,
        deepskyblue: 0x00bfffff,
        dimgray: 0x696969ff,
        dimgrey: 0x696969ff,
        dodgerblue: 0x1e90ffff,
        firebrick: 0xb22222ff,
        floralwhite: 0xfffaf0ff,
        forestgreen: 0x228b22ff,
        fuchsia: 0xff00ffff,
        gainsboro: 0xdcdcdcff,
        ghostwhite: 0xf8f8ffff,
        gold: 0xffd700ff,
        goldenrod: 0xdaa520ff,
        gray: 0x808080ff,
        green: 0x008000ff,
        greenyellow: 0xadff2fff,
        grey: 0x808080ff,
        honeydew: 0xf0fff0ff,
        hotpink: 0xff69b4ff,
        indianred: 0xcd5c5cff,
        indigo: 0x4b0082ff,
        ivory: 0xfffff0ff,
        khaki: 0xf0e68cff,
        lavender: 0xe6e6faff,
        lavenderblush: 0xfff0f5ff,
        lawngreen: 0x7cfc00ff,
        lemonchiffon: 0xfffacdff,
        lightblue: 0xadd8e6ff,
        lightcoral: 0xf08080ff,
        lightcyan: 0xe0ffffff,
        lightgoldenrodyellow: 0xfafad2ff,
        lightgray: 0xd3d3d3ff,
        lightgreen: 0x90ee90ff,
        lightgrey: 0xd3d3d3ff,
        lightpink: 0xffb6c1ff,
        lightsalmon: 0xffa07aff,
        lightseagreen: 0x20b2aaff,
        lightskyblue: 0x87cefaff,
        lightslategray: 0x778899ff,
        lightslategrey: 0x778899ff,
        lightsteelblue: 0xb0c4deff,
        lightyellow: 0xffffe0ff,
        lime: 0x00ff00ff,
        limegreen: 0x32cd32ff,
        linen: 0xfaf0e6ff,
        magenta: 0xff00ffff,
        maroon: 0x800000ff,
        mediumaquamarine: 0x66cdaaff,
        mediumblue: 0x0000cdff,
        mediumorchid: 0xba55d3ff,
        mediumpurple: 0x9370dbff,
        mediumseagreen: 0x3cb371ff,
        mediumslateblue: 0x7b68eeff,
        mediumspringgreen: 0x00fa9aff,
        mediumturquoise: 0x48d1ccff,
        mediumvioletred: 0xc71585ff,
        midnightblue: 0x191970ff,
        mintcream: 0xf5fffaff,
        mistyrose: 0xffe4e1ff,
        moccasin: 0xffe4b5ff,
        navajowhite: 0xffdeadff,
        navy: 0x000080ff,
        oldlace: 0xfdf5e6ff,
        olive: 0x808000ff,
        olivedrab: 0x6b8e23ff,
        orange: 0xffa500ff,
        orangered: 0xff4500ff,
        orchid: 0xda70d6ff,
        palegoldenrod: 0xeee8aaff,
        palegreen: 0x98fb98ff,
        paleturquoise: 0xafeeeeff,
        palevioletred: 0xdb7093ff,
        papayawhip: 0xffefd5ff,
        peachpuff: 0xffdab9ff,
        peru: 0xcd853fff,
        pink: 0xffc0cbff,
        plum: 0xdda0ddff,
        powderblue: 0xb0e0e6ff,
        purple: 0x800080ff,
        rebeccapurple: 0x663399ff,
        red: 0xff0000ff,
        rosybrown: 0xbc8f8fff,
        royalblue: 0x4169e1ff,
        saddlebrown: 0x8b4513ff,
        salmon: 0xfa8072ff,
        sandybrown: 0xf4a460ff,
        seagreen: 0x2e8b57ff,
        seashell: 0xfff5eeff,
        sienna: 0xa0522dff,
        silver: 0xc0c0c0ff,
        skyblue: 0x87ceebff,
        slateblue: 0x6a5acdff,
        slategray: 0x708090ff,
        slategrey: 0x708090ff,
        snow: 0xfffafaff,
        springgreen: 0x00ff7fff,
        steelblue: 0x4682b4ff,
        tan: 0xd2b48cff,
        teal: 0x008080ff,
        thistle: 0xd8bfd8ff,
        tomato: 0xff6347ff,
        turquoise: 0x40e0d0ff,
        violet: 0xee82eeff,
        wheat: 0xf5deb3ff,
        white: 0xffffffff,
        whitesmoke: 0xf5f5f5ff,
        yellow: 0xffff00ff,
        yellowgreen: 0x9acd32ff,
    };
    exports.named_colors = _named_colors;
    function is_named_color(color) {
        return color in exports.named_colors;
    }
    exports.is_named_color = is_named_color;
},
/* core/types.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    exports.GeneratorFunction = Object.getPrototypeOf(function () {
        return tslib_1.__generator(this, function (_a) {
            return [2 /*return*/];
        });
    }).constructor;
    exports.ColorArray = Uint32Array;
    exports.RGBAArray = Uint8ClampedArray;
    function infer_type(a0, a1) {
        if (a0 instanceof Float64Array || a0 instanceof Array)
            return Float64Array;
        if (a1 instanceof Float64Array || a1 instanceof Array)
            return Float64Array;
        return Float32Array;
    }
    exports.infer_type = infer_type;
    exports.ScreenArray = Float32Array;
    function to_screen(array) {
        if (!(array instanceof Float32Array))
            return new Float32Array(array);
        else
            return array;
    }
    exports.to_screen = to_screen;
    var bitset_1 = require(140) /* ./util/bitset */;
    __esExport("Indices", bitset_1.BitSet);
},
/* core/util/bitset.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var eq_1 = require(141) /* ./eq */;
    var assert_1 = require(126) /* ./assert */;
    var BitSet = /** @class */ (function () {
        function BitSet(size, init) {
            if (init === void 0) {
                init = 0;
            }
            this.size = size;
            this[Symbol.toStringTag] = "BitSet";
            this._count = null;
            this._nwords = Math.ceil(size / 32);
            if (init == 0 || init == 1) {
                this._array = new Uint32Array(this._nwords);
                if (init == 1) {
                    this._array.fill(0xffffffff);
                }
            }
            else {
                assert_1.assert(init.length == this._nwords, "Initializer size mismatch");
                this._array = init;
            }
        }
        BitSet.prototype.clone = function () {
            return new BitSet(this.size, new Uint32Array(this._array));
        };
        BitSet.prototype[eq_1.equals] = function (that, cmp) {
            if (!cmp.eq(this.size, that.size))
                return false;
            var _nwords = this._nwords;
            var trailing = this.size % _nwords;
            var n = trailing == 0 ? _nwords : _nwords - 1;
            for (var i = 0; i < n; i++) {
                if (this._array[i] != that._array[i])
                    return false;
            }
            if (trailing == 0)
                return true;
            else {
                var msb = 1 << (trailing - 1);
                var mask = (msb - 1) ^ msb;
                return (this._array[n] & mask) == (that._array[n] & mask);
            }
        };
        BitSet.all_set = function (size) {
            return new BitSet(size, 1);
        };
        BitSet.all_unset = function (size) {
            return new BitSet(size, 0);
        };
        BitSet.from_indices = function (size, indices) {
            var e_1, _a;
            var bits = new BitSet(size);
            try {
                for (var indices_1 = tslib_1.__values(indices), indices_1_1 = indices_1.next(); !indices_1_1.done; indices_1_1 = indices_1.next()) {
                    var i = indices_1_1.value;
                    bits.set(i);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (indices_1_1 && !indices_1_1.done && (_a = indices_1.return))
                        _a.call(indices_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            return bits;
        };
        BitSet.from_booleans = function (size, booleans) {
            var bits = new BitSet(size);
            var n = Math.min(size, booleans.length);
            for (var i = 0; i < n; i++) {
                if (booleans[i])
                    bits.set(i);
            }
            return bits;
        };
        BitSet.prototype._check_bounds = function (k) {
            assert_1.assert(0 <= k && k < this.size, "Out of bounds: 0 <= " + k + " < " + this.size);
        };
        BitSet.prototype.get = function (k) {
            this._check_bounds(k);
            var i = k >>> 5; // Math.floor(k/32)
            var j = k & 0x1f; // k % 32
            return !!((this._array[i] >> j) & 0x1);
        };
        BitSet.prototype.set = function (k, v) {
            if (v === void 0) {
                v = true;
            }
            this._check_bounds(k);
            this._count = null;
            var i = k >>> 5; // Math.floor(k/32)
            var j = k & 0x1f; // k % 32
            if (v)
                this._array[i] |= 0x1 << j;
            else
                this._array[i] &= ~(0x1 << j);
        };
        BitSet.prototype.unset = function (k) {
            this.set(k, false);
        };
        BitSet.prototype[Symbol.iterator] = function () {
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [5 /*yield**/, tslib_1.__values(this.ones())];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        };
        Object.defineProperty(BitSet.prototype, "count", {
            get: function () {
                var count = this._count;
                if (count == null)
                    this._count = count = this._get_count();
                return count;
            },
            enumerable: false,
            configurable: true
        });
        BitSet.prototype._get_count = function () {
            var _a = this, _array = _a._array, _nwords = _a._nwords, size = _a.size;
            var c = 0;
            for (var k = 0, i = 0; i < _nwords; i++) {
                var word = _array[i];
                if (word == 0) {
                    k += 32;
                }
                else {
                    for (var j = 0; j < 32 && k < size; j++, k++) {
                        if ((word >>> j) & 0x1)
                            c += 1;
                    }
                }
            }
            return c;
        };
        BitSet.prototype.ones = function () {
            var _a, _array, _nwords, size, k, i, word, j;
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = this, _array = _a._array, _nwords = _a._nwords, size = _a.size;
                        k = 0, i = 0;
                        _b.label = 1;
                    case 1:
                        if (!(i < _nwords))
                            return [3 /*break*/, 6];
                        word = _array[i];
                        if (word == 0) {
                            k += 32;
                            return [3 /*break*/, 5];
                        }
                        j = 0;
                        _b.label = 2;
                    case 2:
                        if (!(j < 32 && k < size))
                            return [3 /*break*/, 5];
                        if (!((word >>> j) & 0x1))
                            return [3 /*break*/, 4];
                        return [4 /*yield*/, k];
                    case 3:
                        _b.sent();
                        _b.label = 4;
                    case 4:
                        j++, k++;
                        return [3 /*break*/, 2];
                    case 5:
                        i++;
                        return [3 /*break*/, 1];
                    case 6: return [2 /*return*/];
                }
            });
        };
        BitSet.prototype.zeros = function () {
            var _a, _array, _nwords, size, k, i, word, j;
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = this, _array = _a._array, _nwords = _a._nwords, size = _a.size;
                        k = 0, i = 0;
                        _b.label = 1;
                    case 1:
                        if (!(i < _nwords))
                            return [3 /*break*/, 6];
                        word = _array[i];
                        if (word == 0xffffffff) {
                            k += 32;
                            return [3 /*break*/, 5];
                        }
                        j = 0;
                        _b.label = 2;
                    case 2:
                        if (!(j < 32 && k < size))
                            return [3 /*break*/, 5];
                        if (!!((word >>> j) & 0x1))
                            return [3 /*break*/, 4];
                        return [4 /*yield*/, k];
                    case 3:
                        _b.sent();
                        _b.label = 4;
                    case 4:
                        j++, k++;
                        return [3 /*break*/, 2];
                    case 5:
                        i++;
                        return [3 /*break*/, 1];
                    case 6: return [2 /*return*/];
                }
            });
        };
        BitSet.prototype._check_size = function (other) {
            assert_1.assert(this.size == other.size, "Size mismatch");
        };
        BitSet.prototype.add = function (other) {
            this._check_size(other);
            for (var i = 0; i < this._nwords; i++) {
                this._array[i] |= other._array[i];
            }
        };
        BitSet.prototype.intersect = function (other) {
            this._check_size(other);
            for (var i = 0; i < this._nwords; i++) {
                this._array[i] &= other._array[i];
            }
        };
        BitSet.prototype.subtract = function (other) {
            this._check_size(other);
            for (var i = 0; i < this._nwords; i++) {
                var a = this._array[i];
                var b = other._array[i];
                this._array[i] = (a ^ b) & a;
            }
        };
        BitSet.prototype.union = function (other) {
            this._check_size(other);
            var result = this.clone();
            for (var i = 0; i < this._nwords; i++) {
                result._array[i] |= other._array[i];
            }
            return result;
        };
        BitSet.prototype.intersection = function (other) {
            this._check_size(other);
            var result = this.clone();
            for (var i = 0; i < this._nwords; i++) {
                result._array[i] &= other._array[i];
            }
            return result;
        };
        BitSet.prototype.difference = function (other) {
            this._check_size(other);
            var result = this.clone();
            for (var i = 0; i < this._nwords; i++) {
                var a = this._array[i];
                var b = other._array[i];
                result._array[i] = (a ^ b) & a;
            }
            return result;
        };
        BitSet.prototype.select = function (array) {
            var e_2, _a;
            assert_1.assert(this.size <= array.length, "Size mismatch");
            var n = this.count;
            var result = new array.constructor(n);
            var i = 0;
            try {
                for (var _b = tslib_1.__values(this), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var j = _c.value;
                    result[i++] = array[j];
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            return result;
        };
        return BitSet;
    }());
    exports.BitSet = BitSet;
    BitSet.__name__ = "BitSet";
},
/* core/util/eq.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    // Based on Underscore.js 1.8.3 (http://underscorejs.org)
    var types_1 = require(123) /* ./types */;
    var hasOwnProperty = Object.prototype.hasOwnProperty;
    exports.equals = Symbol("equals");
    function is_Equatable(obj) {
        return types_1.isObject(obj) && obj[exports.equals] !== undefined;
    }
    exports.wildcard = Symbol("wildcard");
    var toString = Object.prototype.toString;
    var Comparator = /** @class */ (function () {
        function Comparator() {
            this.a_stack = [];
            this.b_stack = [];
        }
        Comparator.prototype.eq = function (a, b) {
            var _this = this;
            if (Object.is(a, b))
                return true;
            if (a === exports.wildcard || b === exports.wildcard)
                return true;
            if (a == null || b == null)
                return a === b;
            var class_name = toString.call(a);
            if (class_name != toString.call(b))
                return false;
            switch (class_name) {
                case '[object Number]':
                    return this.numbers(a, b);
                case '[object RegExp]':
                case '[object String]':
                    return "" + a == "" + b;
                case '[object Date]':
                case '[object Boolean]':
                    return +a === +b;
            }
            // Assume equality for cyclic structures. The algorithm for detecting cyclic
            // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.
            // Initializing stack of traversed objects.
            // It's done here since we only need them for objects and arrays comparison.
            var _a = this, a_stack = _a.a_stack, b_stack = _a.b_stack;
            var length = a_stack.length;
            while (length--) {
                // Linear search. Performance is inversely proportional to the number of
                // unique nested structures.
                if (a_stack[length] === a)
                    return b_stack[length] === b;
            }
            a_stack.push(a);
            b_stack.push(b);
            var result = (function () {
                if (is_Equatable(a) && is_Equatable(b)) {
                    return a[exports.equals](b, _this);
                }
                switch (class_name) {
                    case "[object Array]":
                    case "[object Uint8Array]":
                    case "[object Int8Array]":
                    case "[object Uint16Array]":
                    case "[object Int16Array]":
                    case "[object Uint32Array]":
                    case "[object Int32Array]":
                    case "[object Float32Array]":
                    case "[object Float64Array]": {
                        return _this.arrays(a, b);
                    }
                    case "[object Map]":
                        return _this.maps(a, b);
                    case "[object Set]":
                        return _this.sets(a, b);
                    case "[object Object]": {
                        if (a.constructor == b.constructor && (a.constructor == null || a.constructor === Object)) {
                            return _this.objects(a, b);
                        }
                    }
                    case "[object Function]": {
                        if (a.constructor == b.constructor && a.constructor === Function) {
                            return _this.eq("" + a, "" + b);
                        }
                    }
                }
                if (a instanceof Node) {
                    return _this.nodes(a, b);
                }
                throw Error("can't compare objects of type " + class_name);
            })();
            a_stack.pop();
            b_stack.pop();
            return result;
        };
        Comparator.prototype.numbers = function (a, b) {
            return Object.is(a, b);
        };
        Comparator.prototype.arrays = function (a, b) {
            var length = a.length;
            if (length != b.length)
                return false;
            for (var i = 0; i < length; i++) {
                if (!this.eq(a[i], b[i]))
                    return false;
            }
            return true;
        };
        Comparator.prototype.iterables = function (a, b) {
            var ai = a[Symbol.iterator]();
            var bi = b[Symbol.iterator]();
            while (true) {
                var an = ai.next();
                var bn = bi.next();
                if (an.done && bn.done)
                    return true;
                if (an.done || bn.done)
                    return false;
                if (!this.eq(an.value, bn.value))
                    return false;
            }
        };
        Comparator.prototype.maps = function (a, b) {
            var e_1, _a;
            if (a.size != b.size)
                return false;
            try {
                for (var a_1 = tslib_1.__values(a), a_1_1 = a_1.next(); !a_1_1.done; a_1_1 = a_1.next()) {
                    var _b = tslib_1.__read(a_1_1.value, 2), key = _b[0], val = _b[1];
                    if (!b.has(key) || !this.eq(val, b.get(key)))
                        return false;
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (a_1_1 && !a_1_1.done && (_a = a_1.return))
                        _a.call(a_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            return true;
        };
        Comparator.prototype.sets = function (a, b) {
            var e_2, _a;
            if (a.size != b.size)
                return false;
            try {
                for (var a_2 = tslib_1.__values(a), a_2_1 = a_2.next(); !a_2_1.done; a_2_1 = a_2.next()) {
                    var key = a_2_1.value;
                    if (!b.has(key))
                        return false;
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (a_2_1 && !a_2_1.done && (_a = a_2.return))
                        _a.call(a_2);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            return true;
        };
        Comparator.prototype.objects = function (a, b) {
            var e_3, _a;
            var keys = Object.keys(a);
            if (keys.length != Object.keys(b).length)
                return false;
            try {
                for (var keys_1 = tslib_1.__values(keys), keys_1_1 = keys_1.next(); !keys_1_1.done; keys_1_1 = keys_1.next()) {
                    var key = keys_1_1.value;
                    if (!hasOwnProperty.call(b, key) || !this.eq(a[key], b[key]))
                        return false;
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (keys_1_1 && !keys_1_1.done && (_a = keys_1.return))
                        _a.call(keys_1);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            return true;
        };
        Comparator.prototype.nodes = function (a, b) {
            if (a.nodeType != b.nodeType)
                return false;
            if (a.textContent != b.textContent)
                return false;
            if (!this.iterables(a.childNodes, b.childNodes))
                return false;
            return true;
        };
        return Comparator;
    }());
    exports.Comparator = Comparator;
    Comparator.__name__ = "Comparator";
    var abs = Math.abs;
    var SimilarComparator = /** @class */ (function (_super) {
        tslib_1.__extends(SimilarComparator, _super);
        function SimilarComparator(tolerance) {
            if (tolerance === void 0) {
                tolerance = 1e-4;
            }
            var _this = _super.call(this) || this;
            _this.tolerance = tolerance;
            return _this;
        }
        SimilarComparator.prototype.numbers = function (a, b) {
            return _super.prototype.numbers.call(this, a, b) || abs(a - b) < this.tolerance;
        };
        return SimilarComparator;
    }(Comparator));
    exports.SimilarComparator = SimilarComparator;
    SimilarComparator.__name__ = "SimilarComparator";
    function is_equal(a, b) {
        var comparator = new Comparator();
        return comparator.eq(a, b);
    }
    exports.is_equal = is_equal;
    function is_similar(a, b, tolerance) {
        var comparator = new SimilarComparator(tolerance);
        return comparator.eq(a, b);
    }
    exports.is_similar = is_similar;
    /** @deprecated */
    exports.isEqual = is_equal;
},
/* core/util/platform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    exports.is_windows = (function () {
        return navigator.appVersion.includes("Windows");
    })();
    exports.is_ie = (function () {
        var ua = navigator.userAgent;
        return ua.includes("MSIE") || ua.includes("Trident") || ua.includes("Edge");
    })();
    exports.is_mobile = (function () {
        return typeof window !== "undefined" && ("ontouchstart" in window || navigator.maxTouchPoints > 0);
    })();
    exports.is_little_endian = (function () {
        var buf = new ArrayBuffer(4);
        var buf8 = new Uint8Array(buf);
        var buf32 = new Uint32Array(buf);
        buf32[1] = 0x0a0b0c0d;
        var little_endian = true;
        if (buf8[4] == 0x0a && buf8[5] == 0x0b && buf8[6] == 0x0c && buf8[7] == 0x0d) {
            little_endian = false;
        }
        return little_endian;
    })();
    exports.BYTE_ORDER = exports.is_little_endian ? "little" : "big";
    function to_big_endian(values) {
        var e_1, _a;
        if (exports.is_little_endian) {
            var result = new Uint32Array(values.length);
            var view = new DataView(result.buffer);
            var j = 0;
            try {
                for (var values_1 = tslib_1.__values(values), values_1_1 = values_1.next(); !values_1_1.done; values_1_1 = values_1.next()) {
                    var color = values_1_1.value;
                    view.setUint32(j, color);
                    j += 4;
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (values_1_1 && !values_1_1.done && (_a = values_1.return))
                        _a.call(values_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            return result;
        }
        else
            return values;
    }
    exports.to_big_endian = to_big_endian;
},
/* core/settings.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var Settings = /** @class */ (function () {
        function Settings() {
            this._dev = false;
            this._wireframe = false;
        }
        Object.defineProperty(Settings.prototype, "dev", {
            get: function () {
                return this._dev;
            },
            set: function (dev) {
                this._dev = dev;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Settings.prototype, "wireframe", {
            get: function () {
                return this._wireframe;
            },
            set: function (wireframe) {
                this._wireframe = wireframe;
            },
            enumerable: false,
            configurable: true
        });
        return Settings;
    }());
    exports.Settings = Settings;
    Settings.__name__ = "Settings";
    exports.settings = new Settings();
},
/* core/util/ndarray.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var _a, _b, _c, _d, _e, _f, _g, _h;
    var types_1 = require(123) /* ./types */;
    var assert_1 = require(126) /* ./assert */;
    var eq_1 = require(141) /* ./eq */;
    var serializer_1 = require(145) /* ../serializer */;
    var serialization_1 = require(146) /* ./serialization */;
    var __ndarray__ = Symbol("__ndarray__");
    var Uint8NDArray = /** @class */ (function (_super) {
        tslib_1.__extends(Uint8NDArray, _super);
        function Uint8NDArray(seq, shape) {
            var _this = new _super(seq);
            _this[_a] = true;
            _this.dtype = "uint8";
            _this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [_this.length]);
            _this.dimension = _this.shape.length;
            return _this;
        }
        Uint8NDArray.prototype[(_a = __ndarray__, eq_1.equals)] = function (that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        };
        Uint8NDArray.prototype[serializer_1.serialize] = function (_serializer) {
            return serialization_1.encode_NDArray(this);
        };
        return Uint8NDArray;
    }(Uint8Array));
    exports.Uint8NDArray = Uint8NDArray;
    Uint8NDArray.__name__ = "Uint8NDArray";
    var Int8NDArray = /** @class */ (function (_super) {
        tslib_1.__extends(Int8NDArray, _super);
        function Int8NDArray(seq, shape) {
            var _this = new _super(seq);
            _this[_b] = true;
            _this.dtype = "int8";
            _this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [_this.length]);
            _this.dimension = _this.shape.length;
            return _this;
        }
        Int8NDArray.prototype[(_b = __ndarray__, eq_1.equals)] = function (that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        };
        Int8NDArray.prototype[serializer_1.serialize] = function (_serializer) {
            return serialization_1.encode_NDArray(this);
        };
        return Int8NDArray;
    }(Int8Array));
    exports.Int8NDArray = Int8NDArray;
    Int8NDArray.__name__ = "Int8NDArray";
    var Uint16NDArray = /** @class */ (function (_super) {
        tslib_1.__extends(Uint16NDArray, _super);
        function Uint16NDArray(seq, shape) {
            var _this = new _super(seq);
            _this[_c] = true;
            _this.dtype = "uint16";
            _this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [_this.length]);
            _this.dimension = _this.shape.length;
            return _this;
        }
        Uint16NDArray.prototype[(_c = __ndarray__, eq_1.equals)] = function (that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        };
        Uint16NDArray.prototype[serializer_1.serialize] = function (_serializer) {
            return serialization_1.encode_NDArray(this);
        };
        return Uint16NDArray;
    }(Uint16Array));
    exports.Uint16NDArray = Uint16NDArray;
    Uint16NDArray.__name__ = "Uint16NDArray";
    var Int16NDArray = /** @class */ (function (_super) {
        tslib_1.__extends(Int16NDArray, _super);
        function Int16NDArray(seq, shape) {
            var _this = new _super(seq);
            _this[_d] = true;
            _this.dtype = "int16";
            _this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [_this.length]);
            _this.dimension = _this.shape.length;
            return _this;
        }
        Int16NDArray.prototype[(_d = __ndarray__, eq_1.equals)] = function (that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        };
        Int16NDArray.prototype[serializer_1.serialize] = function (_serializer) {
            return serialization_1.encode_NDArray(this);
        };
        return Int16NDArray;
    }(Int16Array));
    exports.Int16NDArray = Int16NDArray;
    Int16NDArray.__name__ = "Int16NDArray";
    var Uint32NDArray = /** @class */ (function (_super) {
        tslib_1.__extends(Uint32NDArray, _super);
        function Uint32NDArray(seq, shape) {
            var _this = new _super(seq);
            _this[_e] = true;
            _this.dtype = "uint32";
            _this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [_this.length]);
            _this.dimension = _this.shape.length;
            return _this;
        }
        Uint32NDArray.prototype[(_e = __ndarray__, eq_1.equals)] = function (that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        };
        Uint32NDArray.prototype[serializer_1.serialize] = function (_serializer) {
            return serialization_1.encode_NDArray(this);
        };
        return Uint32NDArray;
    }(Uint32Array));
    exports.Uint32NDArray = Uint32NDArray;
    Uint32NDArray.__name__ = "Uint32NDArray";
    var Int32NDArray = /** @class */ (function (_super) {
        tslib_1.__extends(Int32NDArray, _super);
        function Int32NDArray(seq, shape) {
            var _this = new _super(seq);
            _this[_f] = true;
            _this.dtype = "int32";
            _this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [_this.length]);
            _this.dimension = _this.shape.length;
            return _this;
        }
        Int32NDArray.prototype[(_f = __ndarray__, eq_1.equals)] = function (that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        };
        Int32NDArray.prototype[serializer_1.serialize] = function (_serializer) {
            return serialization_1.encode_NDArray(this);
        };
        return Int32NDArray;
    }(Int32Array));
    exports.Int32NDArray = Int32NDArray;
    Int32NDArray.__name__ = "Int32NDArray";
    var Float32NDArray = /** @class */ (function (_super) {
        tslib_1.__extends(Float32NDArray, _super);
        function Float32NDArray(seq, shape) {
            var _this = new _super(seq);
            _this[_g] = true;
            _this.dtype = "float32";
            _this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [_this.length]);
            _this.dimension = _this.shape.length;
            return _this;
        }
        Float32NDArray.prototype[(_g = __ndarray__, eq_1.equals)] = function (that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        };
        Float32NDArray.prototype[serializer_1.serialize] = function (_serializer) {
            return serialization_1.encode_NDArray(this);
        };
        return Float32NDArray;
    }(Float32Array));
    exports.Float32NDArray = Float32NDArray;
    Float32NDArray.__name__ = "Float32NDArray";
    var Float64NDArray = /** @class */ (function (_super) {
        tslib_1.__extends(Float64NDArray, _super);
        function Float64NDArray(seq, shape) {
            var _this = new _super(seq);
            _this[_h] = true;
            _this.dtype = "float64";
            _this.shape = shape !== null && shape !== void 0 ? shape : (is_NDArray(seq) ? seq.shape : [_this.length]);
            _this.dimension = _this.shape.length;
            return _this;
        }
        Float64NDArray.prototype[(_h = __ndarray__, eq_1.equals)] = function (that, cmp) {
            return cmp.eq(this.shape, that.shape) && cmp.arrays(this, that);
        };
        Float64NDArray.prototype[serializer_1.serialize] = function (_serializer) {
            return serialization_1.encode_NDArray(this);
        };
        return Float64NDArray;
    }(Float64Array));
    exports.Float64NDArray = Float64NDArray;
    Float64NDArray.__name__ = "Float64NDArray";
    function is_NDArray(v) {
        return types_1.isObject(v) && v[__ndarray__] !== undefined;
    }
    exports.is_NDArray = is_NDArray;
    function ndarray(array, options) {
        if (options === void 0) {
            options = {};
        }
        var dtype = options.dtype;
        if (dtype == null) {
            if (array instanceof ArrayBuffer || types_1.isArray(array)) {
                dtype = "float64";
            }
            else {
                dtype = (function () {
                    switch (true) {
                        case array instanceof Uint8Array: return "uint8";
                        case array instanceof Int8Array: return "int8";
                        case array instanceof Uint16Array: return "uint16";
                        case array instanceof Int16Array: return "int16";
                        case array instanceof Uint32Array: return "uint32";
                        case array instanceof Int32Array: return "int32";
                        case array instanceof Float32Array: return "float32";
                        case array instanceof Float64Array: return "float64";
                        default:
                            assert_1.unreachable();
                    }
                })();
            }
        }
        var shape = options.shape;
        switch (dtype) {
            case "uint8": return new Uint8NDArray(array, shape);
            case "int8": return new Int8NDArray(array, shape);
            case "uint16": return new Uint16NDArray(array, shape);
            case "int16": return new Int16NDArray(array, shape);
            case "uint32": return new Uint32NDArray(array, shape);
            case "int32": return new Int32NDArray(array, shape);
            case "float32": return new Float32NDArray(array, shape);
            case "float64": return new Float64NDArray(array, shape);
        }
    }
    exports.ndarray = ndarray;
},
/* core/serializer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var assert_1 = require(126) /* ./util/assert */;
    var object_1 = require(128) /* ./util/object */;
    var types_1 = require(123) /* ./util/types */;
    //| Map<SerializableType, SerializableType>
    //| Set<SerializableType>
    //| ArrayBuffer
    // TypedArray?
    exports.serialize = Symbol("serialize");
    function is_Serializable(obj) {
        return types_1.isObject(obj) && obj[exports.serialize] !== undefined;
    }
    var SerializationError = /** @class */ (function (_super) {
        tslib_1.__extends(SerializationError, _super);
        function SerializationError() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return SerializationError;
    }(Error));
    exports.SerializationError = SerializationError;
    SerializationError.__name__ = "SerializationError";
    var Serializer = /** @class */ (function () {
        function Serializer(options) {
            var _a;
            this._references = new Map();
            this._definitions = new Map();
            this._refmap = new Map();
            this.include_defaults = (_a = options === null || options === void 0 ? void 0 : options.include_defaults) !== null && _a !== void 0 ? _a : true;
        }
        Serializer.prototype.get_ref = function (obj) {
            return this._references.get(obj);
        };
        Serializer.prototype.add_ref = function (obj, ref) {
            assert_1.assert(!this._references.has(obj));
            this._references.set(obj, ref);
        };
        Serializer.prototype.add_def = function (obj, def) {
            var ref = this.get_ref(obj);
            assert_1.assert(ref != null);
            this._definitions.set(obj, def);
            this._refmap.set(ref, def);
        };
        Object.defineProperty(Serializer.prototype, "objects", {
            get: function () {
                return new Set(this._references.keys());
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Serializer.prototype, "references", {
            get: function () {
                return new Set(this._references.values());
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Serializer.prototype, "definitions", {
            get: function () {
                return new Set(this._definitions.values());
            },
            enumerable: false,
            configurable: true
        });
        Serializer.prototype.resolve_ref = function (ref) {
            return this._refmap.get(ref);
        };
        Serializer.prototype.remove_ref = function (obj) {
            return this._references.delete(obj);
        };
        Serializer.prototype.remove_def = function (obj) {
            return this._definitions.delete(obj);
        };
        Serializer.prototype.to_serializable = function (obj) {
            var e_1, _a;
            var ref = this.get_ref(obj);
            if (ref != null)
                return ref;
            else if (is_Serializable(obj))
                return obj[exports.serialize](this);
            else if (types_1.isArray(obj) || types_1.isTypedArray(obj)) {
                var n = obj.length;
                var result = new Array(n);
                for (var i = 0; i < n; i++) {
                    var value = obj[i];
                    result[i] = this.to_serializable(value);
                }
                return result;
            }
            else if (types_1.isPlainObject(obj)) {
                var result = {};
                try {
                    for (var _b = tslib_1.__values(object_1.entries(obj)), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var _d = tslib_1.__read(_c.value, 2), key = _d[0], value = _d[1];
                        result[key] = this.to_serializable(value);
                    }
                }
                catch (e_1_1) {
                    e_1 = { error: e_1_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_1)
                            throw e_1.error;
                    }
                }
                return result;
            }
            else if (obj === null || types_1.isBoolean(obj) || types_1.isNumber(obj) || types_1.isString(obj)) {
                return obj;
            }
            else
                throw new SerializationError(Object.prototype.toString.call(obj) + " is not serializable");
        };
        return Serializer;
    }());
    exports.Serializer = Serializer;
    Serializer.__name__ = "Serializer";
},
/* core/util/serialization.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var types_1 = require(123) /* ./types */;
    var ndarray = tslib_1.__importStar(require(144) /* ./ndarray */);
    var platform_1 = require(142) /* ./platform */;
    var buffer_1 = require(147) /* ./buffer */;
    function is_NDArray_ref(v) {
        return types_1.isPlainObject(v) && ("__buffer__" in v || "__ndarray__" in v);
    }
    exports.is_NDArray_ref = is_NDArray_ref;
    function decode_NDArray(ref, buffers) {
        var shape = ref.shape, dtype = ref.dtype, order = ref.order;
        var bytes;
        if ("__buffer__" in ref) {
            var buffer = buffers.get(ref.__buffer__);
            if (buffer != null)
                bytes = buffer;
            else
                throw new Error("buffer for " + ref.__buffer__ + " not found");
        }
        else {
            bytes = buffer_1.base64_to_buffer(ref.__ndarray__);
        }
        var array = (function () {
            switch (dtype) {
                case "uint8": return new ndarray.Uint8NDArray(bytes, shape);
                case "int8": return new ndarray.Int8NDArray(bytes, shape);
                case "uint16": return new ndarray.Uint16NDArray(bytes, shape);
                case "int16": return new ndarray.Int16NDArray(bytes, shape);
                case "uint32": return new ndarray.Uint32NDArray(bytes, shape);
                case "int32": return new ndarray.Int32NDArray(bytes, shape);
                case "float32": return new ndarray.Float32NDArray(bytes, shape);
                case "float64": return new ndarray.Float64NDArray(bytes, shape);
            }
        })();
        if (order !== platform_1.BYTE_ORDER) {
            buffer_1.swap(array);
        }
        return array;
    }
    exports.decode_NDArray = decode_NDArray;
    function encode_NDArray(array, buffers) {
        var data = {
            order: platform_1.BYTE_ORDER,
            dtype: array.dtype,
            shape: array.shape,
        };
        if (buffers != null) {
            var __buffer__ = "" + buffers.size;
            buffers.set(__buffer__, array.buffer);
            return tslib_1.__assign({ __buffer__: __buffer__ }, data);
        }
        else {
            var __ndarray__ = buffer_1.buffer_to_base64(array.buffer);
            return tslib_1.__assign({ __ndarray__: __ndarray__ }, data);
        }
    }
    exports.encode_NDArray = encode_NDArray;
},
/* core/util/buffer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function buffer_to_base64(buffer) {
        var bytes = new Uint8Array(buffer);
        var chars = Array.from(bytes).map(function (b) { return String.fromCharCode(b); });
        return btoa(chars.join(""));
    }
    exports.buffer_to_base64 = buffer_to_base64;
    function base64_to_buffer(base64) {
        var binary_string = atob(base64);
        var len = binary_string.length;
        var bytes = new Uint8Array(len);
        for (var i = 0, end = len; i < end; i++) {
            bytes[i] = binary_string.charCodeAt(i);
        }
        return bytes.buffer;
    }
    exports.base64_to_buffer = base64_to_buffer;
    function swap16(a) {
        var x = new Uint8Array(a.buffer, a.byteOffset, a.length * 2);
        for (var i = 0, end = x.length; i < end; i += 2) {
            var t = x[i];
            x[i] = x[i + 1];
            x[i + 1] = t;
        }
    }
    function swap32(a) {
        var x = new Uint8Array(a.buffer, a.byteOffset, a.length * 4);
        for (var i = 0, end = x.length; i < end; i += 4) {
            var t = x[i];
            x[i] = x[i + 3];
            x[i + 3] = t;
            t = x[i + 1];
            x[i + 1] = x[i + 2];
            x[i + 2] = t;
        }
    }
    function swap64(a) {
        var x = new Uint8Array(a.buffer, a.byteOffset, a.length * 8);
        for (var i = 0, end = x.length; i < end; i += 8) {
            var t = x[i];
            x[i] = x[i + 7];
            x[i + 7] = t;
            t = x[i + 1];
            x[i + 1] = x[i + 6];
            x[i + 6] = t;
            t = x[i + 2];
            x[i + 2] = x[i + 5];
            x[i + 5] = t;
            t = x[i + 3];
            x[i + 3] = x[i + 4];
            x[i + 4] = t;
        }
    }
    function swap(array) {
        switch (array.BYTES_PER_ELEMENT) {
            case 2:
                swap16(array);
                break;
            case 4:
                swap32(array);
                break;
            case 8:
                swap64(array);
                break;
        }
    }
    exports.swap = swap;
},
/* core/uniforms.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var eq_1 = require(141) /* ./util/eq */;
    var Uniform = /** @class */ (function () {
        function Uniform() {
        }
        Uniform.prototype.is_Scalar = function () { return this.is_scalar; };
        Uniform.prototype.is_Vector = function () { return !this.is_scalar; };
        return Uniform;
    }());
    exports.Uniform = Uniform;
    Uniform.__name__ = "Uniform";
    var UniformScalar = /** @class */ (function (_super) {
        tslib_1.__extends(UniformScalar, _super);
        function UniformScalar(value, length) {
            var _this = _super.call(this) || this;
            _this.value = value;
            _this.length = length;
            _this.is_scalar = true;
            return _this;
        }
        UniformScalar.prototype.get = function (_i) {
            return this.value;
        };
        UniformScalar.prototype[Symbol.iterator] = function () {
            var _a, length, value, i;
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = this, length = _a.length, value = _a.value;
                        i = 0;
                        _b.label = 1;
                    case 1:
                        if (!(i < length))
                            return [3 /*break*/, 4];
                        return [4 /*yield*/, value];
                    case 2:
                        _b.sent();
                        _b.label = 3;
                    case 3:
                        i++;
                        return [3 /*break*/, 1];
                    case 4: return [2 /*return*/];
                }
            });
        };
        UniformScalar.prototype.select = function (indices) {
            return new UniformScalar(this.value, indices.count);
        };
        UniformScalar.prototype[eq_1.equals] = function (that, cmp) {
            return cmp.eq(this.length, that.length) && cmp.eq(this.value, that.value);
        };
        return UniformScalar;
    }(Uniform));
    exports.UniformScalar = UniformScalar;
    UniformScalar.__name__ = "UniformScalar";
    var UniformVector = /** @class */ (function (_super) {
        tslib_1.__extends(UniformVector, _super);
        function UniformVector(array) {
            var _this = _super.call(this) || this;
            _this.array = array;
            _this.is_scalar = false;
            _this.length = _this.array.length;
            return _this;
        }
        UniformVector.prototype.get = function (i) {
            return this.array[i];
        };
        UniformVector.prototype[Symbol.iterator] = function () {
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [5 /*yield**/, tslib_1.__values(this.array)];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        };
        UniformVector.prototype.select = function (indices) {
            var array = indices.select(this.array);
            return new this.constructor(array);
        };
        UniformVector.prototype[eq_1.equals] = function (that, cmp) {
            return cmp.eq(this.length, that.length) && cmp.eq(this.array, that.array);
        };
        return UniformVector;
    }(Uniform));
    exports.UniformVector = UniformVector;
    UniformVector.__name__ = "UniformVector";
    var ColorUniformVector = /** @class */ (function (_super) {
        tslib_1.__extends(ColorUniformVector, _super);
        function ColorUniformVector(array) {
            var _this = _super.call(this, array) || this;
            _this.array = array;
            _this._view = new DataView(array.buffer);
            return _this;
        }
        ColorUniformVector.prototype.get = function (i) {
            return this._view.getUint32(4 * i);
        };
        ColorUniformVector.prototype[Symbol.iterator] = function () {
            var n, i;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        n = this.length;
                        i = 0;
                        _a.label = 1;
                    case 1:
                        if (!(i < n))
                            return [3 /*break*/, 4];
                        return [4 /*yield*/, this.get(i)];
                    case 2:
                        _a.sent();
                        _a.label = 3;
                    case 3:
                        i++;
                        return [3 /*break*/, 1];
                    case 4: return [2 /*return*/];
                }
            });
        };
        return ColorUniformVector;
    }(UniformVector));
    exports.ColorUniformVector = ColorUniformVector;
    ColorUniformVector.__name__ = "ColorUniformVector";
},
/* core/util/string.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var settings_1 = require(143) /* ../settings */;
    function startsWith(str, searchString, position) {
        if (position === void 0) {
            position = 0;
        }
        return str.substr(position, searchString.length) == searchString;
    }
    exports.startsWith = startsWith;
    function uuid4() {
        // from ipython project
        // http://www.ietf.org/rfc/rfc4122.txt
        var s = new Array(32);
        var hexDigits = "0123456789ABCDEF";
        for (var i = 0; i < 32; i++) {
            s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
        }
        s[12] = "4"; // bits 12-15 of the time_hi_and_version field to 0010
        s[16] = hexDigits.substr((s[16].charCodeAt(0) & 0x3) | 0x8, 1); // bits 6-7 of the clock_seq_hi_and_reserved to 01
        return s.join("");
    }
    exports.uuid4 = uuid4;
    var counter = 1000;
    function uniqueId(prefix) {
        var id = settings_1.settings.dev ? "j" + counter++ : uuid4();
        if (prefix != null)
            return prefix + "-" + id;
        else
            return id;
    }
    exports.uniqueId = uniqueId;
    function escape(s) {
        return s.replace(/(?:[&<>"'`])/g, function (ch) {
            switch (ch) {
                case '&': return '&amp;';
                case '<': return '&lt;';
                case '>': return '&gt;';
                case '"': return '&quot;';
                case "'": return '&#x27;';
                case '`': return '&#x60;';
                default: return ch;
            }
        });
    }
    exports.escape = escape;
    function unescape(s) {
        return s.replace(/&(amp|lt|gt|quot|#x27|#x60);/g, function (_, entity) {
            switch (entity) {
                case 'amp': return '&';
                case 'lt': return '<';
                case 'gt': return '>';
                case 'quot': return '"';
                case '#x27': return "'";
                case '#x60': return '`';
                default: return entity;
            }
        });
    }
    exports.unescape = unescape;
    function use_strict(code) {
        return "'use strict';\n" + code;
    }
    exports.use_strict = use_strict;
    function to_fixed(val, precision) {
        return val.toFixed(precision).replace(/(\.[0-9]*?)0+$/, "$1").replace(/\.$/, "");
    }
    exports.to_fixed = to_fixed;
},
/* document/events.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var serializer_1 = require(145) /* ../core/serializer */;
    var DocumentEvent = /** @class */ (function () {
        function DocumentEvent(document) {
            this.document = document;
        }
        return DocumentEvent;
    }());
    exports.DocumentEvent = DocumentEvent;
    DocumentEvent.__name__ = "DocumentEvent";
    var DocumentEventBatch = /** @class */ (function (_super) {
        tslib_1.__extends(DocumentEventBatch, _super);
        function DocumentEventBatch(document, events, setter_id) {
            var _this = _super.call(this, document) || this;
            _this.events = events;
            _this.setter_id = setter_id;
            return _this;
        }
        return DocumentEventBatch;
    }(DocumentEvent));
    exports.DocumentEventBatch = DocumentEventBatch;
    DocumentEventBatch.__name__ = "DocumentEventBatch";
    var DocumentChangedEvent = /** @class */ (function (_super) {
        tslib_1.__extends(DocumentChangedEvent, _super);
        function DocumentChangedEvent() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return DocumentChangedEvent;
    }(DocumentEvent));
    exports.DocumentChangedEvent = DocumentChangedEvent;
    DocumentChangedEvent.__name__ = "DocumentChangedEvent";
    var MessageSentEvent = /** @class */ (function (_super) {
        tslib_1.__extends(MessageSentEvent, _super);
        function MessageSentEvent(document, msg_type, msg_data) {
            var _this = _super.call(this, document) || this;
            _this.msg_type = msg_type;
            _this.msg_data = msg_data;
            return _this;
        }
        MessageSentEvent.prototype[serializer_1.serialize] = function (serializer) {
            var value = this.msg_data;
            var value_serialized = serializer.to_serializable(value);
            return {
                kind: "MessageSent",
                msg_type: this.msg_type,
                msg_data: value_serialized,
            };
        };
        return MessageSentEvent;
    }(DocumentChangedEvent));
    exports.MessageSentEvent = MessageSentEvent;
    MessageSentEvent.__name__ = "MessageSentEvent";
    var ModelChangedEvent = /** @class */ (function (_super) {
        tslib_1.__extends(ModelChangedEvent, _super);
        function ModelChangedEvent(document, model, attr, old, new_, setter_id, hint) {
            var _this = _super.call(this, document) || this;
            _this.model = model;
            _this.attr = attr;
            _this.old = old;
            _this.new_ = new_;
            _this.setter_id = setter_id;
            _this.hint = hint;
            return _this;
        }
        ModelChangedEvent.prototype[serializer_1.serialize] = function (serializer) {
            if (this.hint != null)
                return serializer.to_serializable(this.hint);
            var value = this.new_;
            var value_serialized = serializer.to_serializable(value);
            if (this.model != value) {
                // we know we don't want a whole new copy of the obj we're
                // patching unless it's also the value itself
                serializer.remove_def(this.model);
            }
            return {
                kind: "ModelChanged",
                model: this.model.ref(),
                attr: this.attr,
                new: value_serialized,
            };
        };
        return ModelChangedEvent;
    }(DocumentChangedEvent));
    exports.ModelChangedEvent = ModelChangedEvent;
    ModelChangedEvent.__name__ = "ModelChangedEvent";
    var ColumnsPatchedEvent = /** @class */ (function (_super) {
        tslib_1.__extends(ColumnsPatchedEvent, _super);
        function ColumnsPatchedEvent(document, column_source, patches) {
            var _this = _super.call(this, document) || this;
            _this.column_source = column_source;
            _this.patches = patches;
            return _this;
        }
        ColumnsPatchedEvent.prototype[serializer_1.serialize] = function (_serializer) {
            return {
                kind: "ColumnsPatched",
                column_source: this.column_source,
                patches: this.patches,
            };
        };
        return ColumnsPatchedEvent;
    }(DocumentChangedEvent));
    exports.ColumnsPatchedEvent = ColumnsPatchedEvent;
    ColumnsPatchedEvent.__name__ = "ColumnsPatchedEvent";
    var ColumnsStreamedEvent = /** @class */ (function (_super) {
        tslib_1.__extends(ColumnsStreamedEvent, _super);
        function ColumnsStreamedEvent(document, column_source, data, rollover) {
            var _this = _super.call(this, document) || this;
            _this.column_source = column_source;
            _this.data = data;
            _this.rollover = rollover;
            return _this;
        }
        ColumnsStreamedEvent.prototype[serializer_1.serialize] = function (_serializer) {
            return {
                kind: "ColumnsStreamed",
                column_source: this.column_source,
                data: this.data,
                rollover: this.rollover,
            };
        };
        return ColumnsStreamedEvent;
    }(DocumentChangedEvent));
    exports.ColumnsStreamedEvent = ColumnsStreamedEvent;
    ColumnsStreamedEvent.__name__ = "ColumnsStreamedEvent";
    var TitleChangedEvent = /** @class */ (function (_super) {
        tslib_1.__extends(TitleChangedEvent, _super);
        function TitleChangedEvent(document, title, setter_id) {
            var _this = _super.call(this, document) || this;
            _this.title = title;
            _this.setter_id = setter_id;
            return _this;
        }
        TitleChangedEvent.prototype[serializer_1.serialize] = function (_serializer) {
            return {
                kind: "TitleChanged",
                title: this.title,
            };
        };
        return TitleChangedEvent;
    }(DocumentChangedEvent));
    exports.TitleChangedEvent = TitleChangedEvent;
    TitleChangedEvent.__name__ = "TitleChangedEvent";
    var RootAddedEvent = /** @class */ (function (_super) {
        tslib_1.__extends(RootAddedEvent, _super);
        function RootAddedEvent(document, model, setter_id) {
            var _this = _super.call(this, document) || this;
            _this.model = model;
            _this.setter_id = setter_id;
            return _this;
        }
        RootAddedEvent.prototype[serializer_1.serialize] = function (serializer) {
            return {
                kind: "RootAdded",
                model: serializer.to_serializable(this.model),
            };
        };
        return RootAddedEvent;
    }(DocumentChangedEvent));
    exports.RootAddedEvent = RootAddedEvent;
    RootAddedEvent.__name__ = "RootAddedEvent";
    var RootRemovedEvent = /** @class */ (function (_super) {
        tslib_1.__extends(RootRemovedEvent, _super);
        function RootRemovedEvent(document, model, setter_id) {
            var _this = _super.call(this, document) || this;
            _this.model = model;
            _this.setter_id = setter_id;
            return _this;
        }
        RootRemovedEvent.prototype[serializer_1.serialize] = function (_serializer) {
            return {
                kind: "RootRemoved",
                model: this.model.ref(),
            };
        };
        return RootRemovedEvent;
    }(DocumentChangedEvent));
    exports.RootRemovedEvent = RootRemovedEvent;
    RootRemovedEvent.__name__ = "RootRemovedEvent";
},
/* core/util/pretty.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var types_1 = require(123) /* ./types */;
    var object_1 = require(128) /* ./object */;
    exports.pretty = Symbol("pretty");
    function is_Printable(obj) {
        return types_1.isObject(obj) && obj[exports.pretty] !== undefined;
    }
    var Printer = /** @class */ (function () {
        function Printer(options) {
            this.precision = options === null || options === void 0 ? void 0 : options.precision;
        }
        Printer.prototype.to_string = function (obj) {
            if (is_Printable(obj))
                return obj[exports.pretty](this);
            else if (types_1.isBoolean(obj))
                return this.boolean(obj);
            else if (types_1.isNumber(obj))
                return this.number(obj);
            else if (types_1.isString(obj))
                return this.string(obj);
            else if (types_1.isArray(obj))
                return this.array(obj);
            else if (types_1.isIterable(obj))
                return this.iterable(obj);
            else if (types_1.isPlainObject(obj))
                return this.object(obj);
            else
                return "" + obj;
        };
        Printer.prototype.token = function (val) {
            return val;
        };
        Printer.prototype.boolean = function (val) {
            return "" + val;
        };
        Printer.prototype.number = function (val) {
            if (this.precision != null)
                return val.toFixed(this.precision);
            else
                return "" + val;
        };
        Printer.prototype.string = function (val) {
            return "\"" + val.replace(/'/g, "\\'") + "\""; // lgtm [js/incomplete-sanitization]
        };
        Printer.prototype.array = function (obj) {
            var e_1, _a;
            var T = this.token;
            var items = [];
            try {
                for (var obj_1 = tslib_1.__values(obj), obj_1_1 = obj_1.next(); !obj_1_1.done; obj_1_1 = obj_1.next()) {
                    var entry = obj_1_1.value;
                    items.push(this.to_string(entry));
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (obj_1_1 && !obj_1_1.done && (_a = obj_1.return))
                        _a.call(obj_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            return "" + T("[") + items.join(T(",") + " ") + T("]");
        };
        Printer.prototype.iterable = function (obj) {
            var _a;
            var T = this.token;
            var tag = (_a = Object(obj)[Symbol.toStringTag]) !== null && _a !== void 0 ? _a : "Object";
            var items = this.array(obj);
            return "" + tag + T("(") + items + T(")");
        };
        Printer.prototype.object = function (obj) {
            var e_2, _a;
            var T = this.token;
            var items = [];
            try {
                for (var _b = tslib_1.__values(object_1.entries(obj)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var _d = tslib_1.__read(_c.value, 2), key = _d[0], val = _d[1];
                    items.push("" + key + T(":") + " " + this.to_string(val));
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            return "" + T("{") + items.join(T(",") + " ") + T("}");
        };
        return Printer;
    }());
    exports.Printer = Printer;
    Printer.__name__ = "Printer";
    function to_string(obj, options) {
        var printer = new Printer(options);
        return printer.to_string(obj);
    }
    exports.to_string = to_string;
},
/* core/util/cloneable.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var object_1 = require(128) /* ./object */;
    var types_1 = require(123) /* ./types */;
    //| Map<CloneableType, CloneableType>
    //| Set<CloneableType>
    exports.clone = Symbol("clone");
    function is_Cloneable(obj) {
        return types_1.isObject(obj) && obj[exports.clone] !== undefined;
    }
    exports.is_Cloneable = is_Cloneable;
    var CloningError = /** @class */ (function (_super) {
        tslib_1.__extends(CloningError, _super);
        function CloningError() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return CloningError;
    }(Error));
    exports.CloningError = CloningError;
    CloningError.__name__ = "CloningError";
    var Cloner = /** @class */ (function () {
        function Cloner() {
        }
        Cloner.prototype.clone = function (obj) {
            var e_1, _a;
            if (is_Cloneable(obj))
                return obj[exports.clone](this);
            else if (types_1.isArray(obj)) {
                var n = obj.length;
                var result = new Array(n);
                for (var i = 0; i < n; i++) {
                    var value = obj[i];
                    result[i] = this.clone(value);
                }
                return result;
            }
            else if (types_1.isPlainObject(obj)) {
                var result = {};
                try {
                    for (var _b = tslib_1.__values(object_1.entries(obj)), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var _d = tslib_1.__read(_c.value, 2), key = _d[0], value = _d[1];
                        result[key] = this.clone(value);
                    }
                }
                catch (e_1_1) {
                    e_1 = { error: e_1_1 };
                }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return))
                            _a.call(_b);
                    }
                    finally {
                        if (e_1)
                            throw e_1.error;
                    }
                }
                return result;
            }
            else if (obj === null || types_1.isBoolean(obj) || types_1.isNumber(obj) || types_1.isString(obj)) {
                return obj;
            }
            else
                throw new CloningError(Object.prototype.toString.call(obj) + " is not cloneable");
        };
        return Cloner;
    }());
    exports.Cloner = Cloner;
    Cloner.__name__ = "Cloner";
},
/* models/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    tslib_1.__exportStar(require(154) /* ./annotations */, exports);
    tslib_1.__exportStar(require(277) /* ./axes */, exports);
    tslib_1.__exportStar(require(372) /* ./callbacks */, exports);
    tslib_1.__exportStar(require(376) /* ./canvas */, exports);
    tslib_1.__exportStar(require(381) /* ./expressions */, exports);
    tslib_1.__exportStar(require(387) /* ./filters */, exports);
    tslib_1.__exportStar(require(320) /* ./formatters */, exports);
    tslib_1.__exportStar(require(392) /* ./glyphs */, exports);
    tslib_1.__exportStar(require(428) /* ./graphs */, exports);
    tslib_1.__exportStar(require(430) /* ./grids */, exports);
    tslib_1.__exportStar(require(432) /* ./layouts */, exports);
    tslib_1.__exportStar(require(324) /* ./mappers */, exports);
    tslib_1.__exportStar(require(262) /* ./transforms */, exports);
    tslib_1.__exportStar(require(445) /* ./plots */, exports);
    tslib_1.__exportStar(require(453) /* ./policies */, exports);
    tslib_1.__exportStar(require(335) /* ./ranges */, exports);
    tslib_1.__exportStar(require(454) /* ./renderers */, exports);
    tslib_1.__exportStar(require(332) /* ./scales */, exports);
    tslib_1.__exportStar(require(455) /* ./selections */, exports);
    tslib_1.__exportStar(require(456) /* ./sources */, exports);
    tslib_1.__exportStar(require(313) /* ./tickers */, exports);
    tslib_1.__exportStar(require(461) /* ./tiles */, exports);
    tslib_1.__exportStar(require(471) /* ./textures */, exports);
    tslib_1.__exportStar(require(475) /* ./tools */, exports);
},
/* models/annotations/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var annotation_1 = require(155) /* ./annotation */;
    __esExport("Annotation", annotation_1.Annotation);
    var arrow_1 = require(170) /* ./arrow */;
    __esExport("Arrow", arrow_1.Arrow);
    var arrow_head_1 = require(248) /* ./arrow_head */;
    __esExport("ArrowHead", arrow_head_1.ArrowHead);
    var arrow_head_2 = require(248) /* ./arrow_head */;
    __esExport("OpenHead", arrow_head_2.OpenHead);
    var arrow_head_3 = require(248) /* ./arrow_head */;
    __esExport("NormalHead", arrow_head_3.NormalHead);
    var arrow_head_4 = require(248) /* ./arrow_head */;
    __esExport("TeeHead", arrow_head_4.TeeHead);
    var arrow_head_5 = require(248) /* ./arrow_head */;
    __esExport("VeeHead", arrow_head_5.VeeHead);
    var band_1 = require(249) /* ./band */;
    __esExport("Band", band_1.Band);
    var box_annotation_1 = require(251) /* ./box_annotation */;
    __esExport("BoxAnnotation", box_annotation_1.BoxAnnotation);
    var color_bar_1 = require(252) /* ./color_bar */;
    __esExport("ColorBar", color_bar_1.ColorBar);
    var label_1 = require(341) /* ./label */;
    __esExport("Label", label_1.Label);
    var label_set_1 = require(342) /* ./label_set */;
    __esExport("LabelSet", label_set_1.LabelSet);
    var legend_1 = require(343) /* ./legend */;
    __esExport("Legend", legend_1.Legend);
    var legend_item_1 = require(344) /* ./legend_item */;
    __esExport("LegendItem", legend_item_1.LegendItem);
    var poly_annotation_1 = require(346) /* ./poly_annotation */;
    __esExport("PolyAnnotation", poly_annotation_1.PolyAnnotation);
    var slope_1 = require(347) /* ./slope */;
    __esExport("Slope", slope_1.Slope);
    var span_1 = require(348) /* ./span */;
    __esExport("Span", span_1.Span);
    var text_annotation_1 = require(254) /* ./text_annotation */;
    __esExport("TextAnnotation", text_annotation_1.TextAnnotation);
    var title_1 = require(253) /* ./title */;
    __esExport("Title", title_1.Title);
    var toolbar_panel_1 = require(349) /* ./toolbar_panel */;
    __esExport("ToolbarPanel", toolbar_panel_1.ToolbarPanel);
    var tooltip_1 = require(369) /* ./tooltip */;
    __esExport("Tooltip", tooltip_1.Tooltip);
    var whisker_1 = require(371) /* ./whisker */;
    __esExport("Whisker", whisker_1.Whisker);
},
/* models/annotations/annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var renderer_1 = require(156) /* ../renderers/renderer */;
    var AnnotationView = /** @class */ (function (_super) {
        tslib_1.__extends(AnnotationView, _super);
        function AnnotationView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        AnnotationView.prototype.get_size = function () {
            if (this.model.visible) {
                var _a = this._get_size(), width = _a.width, height = _a.height;
                return { width: Math.round(width), height: Math.round(height) };
            }
            else
                return { width: 0, height: 0 };
        };
        AnnotationView.prototype._get_size = function () {
            throw new Error("not implemented");
        };
        AnnotationView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            var p = this.model.properties;
            this.on_change(p.visible, function () {
                if (_this.layout != null) {
                    _this.layout.visible = _this.model.visible;
                    _this.plot_view.request_layout();
                }
            });
        };
        Object.defineProperty(AnnotationView.prototype, "needs_clip", {
            get: function () {
                return this.layout == null; // TODO: change this, when center layout is fully implemented
            },
            enumerable: false,
            configurable: true
        });
        AnnotationView.prototype.serializable_state = function () {
            var state = _super.prototype.serializable_state.call(this);
            return this.layout == null ? state : tslib_1.__assign(tslib_1.__assign({}, state), { bbox: this.layout.bbox.box });
        };
        return AnnotationView;
    }(renderer_1.RendererView));
    exports.AnnotationView = AnnotationView;
    AnnotationView.__name__ = "AnnotationView";
    var Annotation = /** @class */ (function (_super) {
        tslib_1.__extends(Annotation, _super);
        function Annotation(attrs) {
            return _super.call(this, attrs) || this;
        }
        Annotation.init_Annotation = function () {
            this.override({
                level: 'annotation',
            });
        };
        return Annotation;
    }(renderer_1.Renderer));
    exports.Annotation = Annotation;
    Annotation.__name__ = "Annotation";
    Annotation.init_Annotation();
},
/* models/renderers/renderer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var view_1 = require(157) /* ../../core/view */;
    var visuals = tslib_1.__importStar(require(160) /* ../../core/visuals */);
    var enums_1 = require(135) /* ../../core/enums */;
    var model_1 = require(168) /* ../../model */;
    var coordinates_1 = require(169) /* ../canvas/coordinates */;
    var RendererView = /** @class */ (function (_super) {
        tslib_1.__extends(RendererView, _super);
        function RendererView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(RendererView.prototype, "coordinates", {
            get: function () {
                var _coordinates = this._coordinates;
                if (_coordinates != null)
                    return _coordinates;
                else
                    return this._coordinates = this._initialize_coordinates();
            },
            enumerable: false,
            configurable: true
        });
        RendererView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.visuals = new visuals.Visuals(this);
            this.needs_webgl_blit = false;
        };
        RendererView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            var _a = this.model.properties, x_range_name = _a.x_range_name, y_range_name = _a.y_range_name;
            this.on_change([x_range_name, y_range_name], function () { return _this._initialize_coordinates(); });
        };
        RendererView.prototype._initialize_coordinates = function () {
            var _a = this.model, x_range_name = _a.x_range_name, y_range_name = _a.y_range_name;
            var frame = this.plot_view.frame;
            var x_scale = frame.x_scales.get(x_range_name);
            var y_scale = frame.y_scales.get(y_range_name);
            return new coordinates_1.CoordinateTransform(x_scale, y_scale);
        };
        Object.defineProperty(RendererView.prototype, "plot_view", {
            get: function () {
                return this.parent;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(RendererView.prototype, "plot_model", {
            get: function () {
                return this.parent.model;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(RendererView.prototype, "layer", {
            get: function () {
                var _a = this.canvas, overlays = _a.overlays, primary = _a.primary;
                return this.model.level == "overlay" ? overlays : primary;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(RendererView.prototype, "canvas", {
            get: function () {
                return this.plot_view.canvas_view;
            },
            enumerable: false,
            configurable: true
        });
        RendererView.prototype.request_render = function () {
            this.request_paint();
        };
        RendererView.prototype.request_paint = function () {
            this.plot_view.request_paint(this);
        };
        RendererView.prototype.notify_finished = function () {
            this.plot_view.notify_finished();
        };
        Object.defineProperty(RendererView.prototype, "needs_clip", {
            get: function () {
                return false;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(RendererView.prototype, "has_webgl", {
            get: function () {
                return false;
            },
            enumerable: false,
            configurable: true
        });
        RendererView.prototype.render = function () {
            if (this.model.visible) {
                this._render();
            }
            this._has_finished = true;
        };
        RendererView.prototype.renderer_view = function (_renderer) {
            return undefined;
        };
        return RendererView;
    }(view_1.View));
    exports.RendererView = RendererView;
    RendererView.__name__ = "RendererView";
    var Renderer = /** @class */ (function (_super) {
        tslib_1.__extends(Renderer, _super);
        function Renderer(attrs) {
            return _super.call(this, attrs) || this;
        }
        Renderer.init_Renderer = function () {
            this.define(function (_a) {
                var Boolean = _a.Boolean, String = _a.String;
                return ({
                    level: [enums_1.RenderLevel, "image"],
                    visible: [Boolean, true],
                    x_range_name: [String, "default"],
                    y_range_name: [String, "default"],
                });
            });
        };
        return Renderer;
    }(model_1.Model));
    exports.Renderer = Renderer;
    Renderer.__name__ = "Renderer";
    Renderer.init_Renderer();
},
/* core/view.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var signaling_1 = require(130) /* ./signaling */;
    var dom_1 = require(158) /* ./dom */;
    var types_1 = require(123) /* ./util/types */;
    var root_css_1 = tslib_1.__importDefault(require(159) /* ../styles/root.css */);
    var View = /** @class */ (function () {
        function View(options) {
            this.removed = new signaling_1.Signal0(this, "removed");
            this._ready = Promise.resolve(undefined);
            /** @internal */
            this._slots = new WeakMap();
            var model = options.model, parent = options.parent;
            this.model = model;
            this.parent = parent;
            this.root = parent == null ? this : parent.root;
            this.removed.emit();
        }
        Object.defineProperty(View.prototype, "ready", {
            get: function () {
                return this._ready;
            },
            enumerable: false,
            configurable: true
        });
        View.prototype.connect = function (signal, slot) {
            var _this = this;
            var new_slot = this._slots.get(slot);
            if (new_slot == null) {
                new_slot = function (args, sender) {
                    var promise = Promise.resolve(slot.call(_this, args, sender));
                    _this._ready = _this._ready.then(function () { return promise; });
                };
                this._slots.set(slot, new_slot);
            }
            return signal.connect(new_slot, this);
        };
        View.prototype.disconnect = function (signal, slot) {
            return signal.disconnect(slot, this);
        };
        View.prototype.initialize = function () {
            var e_1, _a;
            this._has_finished = false;
            if (this.is_root) {
                this._stylesheet = dom_1.stylesheet;
            }
            try {
                for (var _b = tslib_1.__values(this.styles()), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var style = _c.value;
                    this.stylesheet.append(style);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        View.prototype.lazy_initialize = function () {
            return tslib_1.__awaiter(this, void 0, void 0, function () {
                return tslib_1.__generator(this, function (_a) {
                    return [2 /*return*/];
                });
            });
        };
        View.prototype.remove = function () {
            this.disconnect_signals();
            this.removed.emit();
        };
        View.prototype.toString = function () {
            return this.model.type + "View(" + this.model.id + ")";
        };
        View.prototype.serializable_state = function () {
            return { type: this.model.type };
        };
        Object.defineProperty(View.prototype, "is_root", {
            get: function () {
                return this.parent == null;
            },
            enumerable: false,
            configurable: true
        });
        View.prototype.assert_root = function () {
            if (!this.is_root)
                throw new Error(this.toString() + " is not a root layout");
        };
        View.prototype.has_finished = function () {
            return this._has_finished;
        };
        Object.defineProperty(View.prototype, "is_idle", {
            get: function () {
                return this.has_finished();
            },
            enumerable: false,
            configurable: true
        });
        View.prototype.connect_signals = function () { };
        View.prototype.disconnect_signals = function () {
            signaling_1.Signal.disconnect_receiver(this);
        };
        View.prototype.on_change = function (properties, fn) {
            var e_2, _a;
            try {
                for (var _b = tslib_1.__values(types_1.isArray(properties) ? properties : [properties]), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var property = _c.value;
                    this.connect(property.change, fn);
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
        };
        View.prototype.cursor = function (_sx, _sy) {
            return null;
        };
        Object.defineProperty(View.prototype, "stylesheet", {
            get: function () {
                if (this.is_root)
                    return this._stylesheet;
                else
                    return this.root.stylesheet;
            },
            enumerable: false,
            configurable: true
        });
        View.prototype.styles = function () {
            return [root_css_1.default];
        };
        return View;
    }());
    exports.View = View;
    View.__name__ = "View";
},
/* core/dom.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var types_1 = require(123) /* ./util/types */;
    var object_1 = require(128) /* ./util/object */;
    var _createElement = function (tag) {
        return function (attrs) {
            var e_1, _a, e_2, _b, e_3, _c, e_4, _d, e_5, _e, e_6, _f;
            if (attrs === void 0) {
                attrs = {};
            }
            var children = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                children[_i - 1] = arguments[_i];
            }
            var element = document.createElement(tag);
            element.classList.add("bk");
            try {
                for (var _g = tslib_1.__values(object_1.entries(attrs)), _h = _g.next(); !_h.done; _h = _g.next()) {
                    var _j = tslib_1.__read(_h.value, 2), attr = _j[0], value = _j[1];
                    if (value == null || types_1.isBoolean(value) && !value)
                        continue;
                    if (attr === "class") {
                        if (types_1.isString(value))
                            value = value.split(/\s+/);
                        if (types_1.isArray(value)) {
                            try {
                                for (var value_1 = (e_2 = void 0, tslib_1.__values(value)), value_1_1 = value_1.next(); !value_1_1.done; value_1_1 = value_1.next()) {
                                    var cls = value_1_1.value;
                                    if (cls != null)
                                        element.classList.add(cls);
                                }
                            }
                            catch (e_2_1) {
                                e_2 = { error: e_2_1 };
                            }
                            finally {
                                try {
                                    if (value_1_1 && !value_1_1.done && (_b = value_1.return))
                                        _b.call(value_1);
                                }
                                finally {
                                    if (e_2)
                                        throw e_2.error;
                                }
                            }
                            continue;
                        }
                    }
                    if (attr === "style" && types_1.isPlainObject(value)) {
                        try {
                            for (var _k = (e_3 = void 0, tslib_1.__values(object_1.entries(value))), _l = _k.next(); !_l.done; _l = _k.next()) {
                                var _m = tslib_1.__read(_l.value, 2), prop = _m[0], data = _m[1];
                                element.style[prop] = data;
                            }
                        }
                        catch (e_3_1) {
                            e_3 = { error: e_3_1 };
                        }
                        finally {
                            try {
                                if (_l && !_l.done && (_c = _k.return))
                                    _c.call(_k);
                            }
                            finally {
                                if (e_3)
                                    throw e_3.error;
                            }
                        }
                        continue;
                    }
                    if (attr === "data" && types_1.isPlainObject(value)) {
                        try {
                            for (var _o = (e_4 = void 0, tslib_1.__values(object_1.entries(value))), _p = _o.next(); !_p.done; _p = _o.next()) {
                                var _q = tslib_1.__read(_p.value, 2), key = _q[0], data = _q[1];
                                element.dataset[key] = data; // XXX: attrs needs a better type
                            }
                        }
                        catch (e_4_1) {
                            e_4 = { error: e_4_1 };
                        }
                        finally {
                            try {
                                if (_p && !_p.done && (_d = _o.return))
                                    _d.call(_o);
                            }
                            finally {
                                if (e_4)
                                    throw e_4.error;
                            }
                        }
                        continue;
                    }
                    element.setAttribute(attr, value);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_h && !_h.done && (_a = _g.return))
                        _a.call(_g);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            function append(child) {
                var e_7, _a;
                if (types_1.isString(child))
                    element.appendChild(document.createTextNode(child));
                else if (child instanceof Node)
                    element.appendChild(child);
                else if (child instanceof NodeList || child instanceof HTMLCollection) {
                    try {
                        for (var child_2 = tslib_1.__values(child), child_2_1 = child_2.next(); !child_2_1.done; child_2_1 = child_2.next()) {
                            var el = child_2_1.value;
                            element.appendChild(el);
                        }
                    }
                    catch (e_7_1) {
                        e_7 = { error: e_7_1 };
                    }
                    finally {
                        try {
                            if (child_2_1 && !child_2_1.done && (_a = child_2.return))
                                _a.call(child_2);
                        }
                        finally {
                            if (e_7)
                                throw e_7.error;
                        }
                    }
                }
                else if (child != null && child !== false)
                    throw new Error("expected a DOM element, string, false or null, got " + JSON.stringify(child));
            }
            try {
                for (var children_1 = tslib_1.__values(children), children_1_1 = children_1.next(); !children_1_1.done; children_1_1 = children_1.next()) {
                    var child = children_1_1.value;
                    if (types_1.isArray(child)) {
                        try {
                            for (var child_1 = (e_6 = void 0, tslib_1.__values(child)), child_1_1 = child_1.next(); !child_1_1.done; child_1_1 = child_1.next()) {
                                var _child = child_1_1.value;
                                append(_child);
                            }
                        }
                        catch (e_6_1) {
                            e_6 = { error: e_6_1 };
                        }
                        finally {
                            try {
                                if (child_1_1 && !child_1_1.done && (_f = child_1.return))
                                    _f.call(child_1);
                            }
                            finally {
                                if (e_6)
                                    throw e_6.error;
                            }
                        }
                    }
                    else
                        append(child);
                }
            }
            catch (e_5_1) {
                e_5 = { error: e_5_1 };
            }
            finally {
                try {
                    if (children_1_1 && !children_1_1.done && (_e = children_1.return))
                        _e.call(children_1);
                }
                finally {
                    if (e_5)
                        throw e_5.error;
                }
            }
            return element;
        };
    };
    function createElement(tag, attrs) {
        var children = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            children[_i - 2] = arguments[_i];
        }
        return _createElement(tag).apply(void 0, tslib_1.__spread([attrs], children));
    }
    exports.createElement = createElement;
    exports.div = _createElement("div"), exports.span = _createElement("span"), exports.canvas = _createElement("canvas"), exports.link = _createElement("link"), exports.style = _createElement("style"), exports.a = _createElement("a"), exports.p = _createElement("p"), exports.i = _createElement("i"), exports.pre = _createElement("pre"), exports.button = _createElement("button"), exports.label = _createElement("label"), exports.input = _createElement("input"), exports.select = _createElement("select"), exports.option = _createElement("option"), exports.optgroup = _createElement("optgroup"), exports.textarea = _createElement("textarea");
    function nbsp() {
        return document.createTextNode("\u00a0");
    }
    exports.nbsp = nbsp;
    function append(element) {
        var e_8, _a;
        var children = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            children[_i - 1] = arguments[_i];
        }
        try {
            for (var children_2 = tslib_1.__values(children), children_2_1 = children_2.next(); !children_2_1.done; children_2_1 = children_2.next()) {
                var child = children_2_1.value;
                element.appendChild(child);
            }
        }
        catch (e_8_1) {
            e_8 = { error: e_8_1 };
        }
        finally {
            try {
                if (children_2_1 && !children_2_1.done && (_a = children_2.return))
                    _a.call(children_2);
            }
            finally {
                if (e_8)
                    throw e_8.error;
            }
        }
    }
    exports.append = append;
    function remove(element) {
        var parent = element.parentNode;
        if (parent != null) {
            parent.removeChild(element);
        }
    }
    exports.remove = remove;
    exports.removeElement = remove;
    function replaceWith(element, replacement) {
        var parent = element.parentNode;
        if (parent != null) {
            parent.replaceChild(replacement, element);
        }
    }
    exports.replaceWith = replaceWith;
    function prepend(element) {
        var e_9, _a;
        var nodes = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            nodes[_i - 1] = arguments[_i];
        }
        var first = element.firstChild;
        try {
            for (var nodes_1 = tslib_1.__values(nodes), nodes_1_1 = nodes_1.next(); !nodes_1_1.done; nodes_1_1 = nodes_1.next()) {
                var node = nodes_1_1.value;
                element.insertBefore(node, first);
            }
        }
        catch (e_9_1) {
            e_9 = { error: e_9_1 };
        }
        finally {
            try {
                if (nodes_1_1 && !nodes_1_1.done && (_a = nodes_1.return))
                    _a.call(nodes_1);
            }
            finally {
                if (e_9)
                    throw e_9.error;
            }
        }
    }
    exports.prepend = prepend;
    function empty(node, attrs) {
        var e_10, _a;
        if (attrs === void 0) {
            attrs = false;
        }
        var child;
        while (child = node.firstChild) {
            node.removeChild(child);
        }
        if (attrs && node instanceof Element) {
            try {
                for (var _b = tslib_1.__values(node.attributes), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var attr = _c.value;
                    node.removeAttributeNode(attr);
                }
            }
            catch (e_10_1) {
                e_10 = { error: e_10_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_10)
                        throw e_10.error;
                }
            }
        }
    }
    exports.empty = empty;
    function display(element) {
        element.style.display = "";
    }
    exports.display = display;
    function undisplay(element) {
        element.style.display = "none";
    }
    exports.undisplay = undisplay;
    function show(element) {
        element.style.visibility = "";
    }
    exports.show = show;
    function hide(element) {
        element.style.visibility = "hidden";
    }
    exports.hide = hide;
    function offset(element) {
        var rect = element.getBoundingClientRect();
        return {
            top: rect.top + window.pageYOffset - document.documentElement.clientTop,
            left: rect.left + window.pageXOffset - document.documentElement.clientLeft,
        };
    }
    exports.offset = offset;
    function matches(el, selector) {
        var _a, _b, _c;
        var p = Element.prototype;
        var f = (_c = (_b = (_a = p.matches) !== null && _a !== void 0 ? _a : p.webkitMatchesSelector) !== null && _b !== void 0 ? _b : p.mozMatchesSelector) !== null && _c !== void 0 ? _c : p.msMatchesSelector;
        return f.call(el, selector);
    }
    exports.matches = matches;
    function parent(el, selector) {
        var node = el;
        while (node = node.parentElement) {
            if (matches(node, selector))
                return node;
        }
        return null;
    }
    exports.parent = parent;
    function num(value) {
        return parseFloat(value) || 0;
    }
    function extents(el) {
        var style = getComputedStyle(el);
        return {
            border: {
                top: num(style.borderTopWidth),
                bottom: num(style.borderBottomWidth),
                left: num(style.borderLeftWidth),
                right: num(style.borderRightWidth),
            },
            margin: {
                top: num(style.marginTop),
                bottom: num(style.marginBottom),
                left: num(style.marginLeft),
                right: num(style.marginRight),
            },
            padding: {
                top: num(style.paddingTop),
                bottom: num(style.paddingBottom),
                left: num(style.paddingLeft),
                right: num(style.paddingRight),
            },
        };
    }
    exports.extents = extents;
    function size(el) {
        var rect = el.getBoundingClientRect();
        return {
            width: Math.ceil(rect.width),
            height: Math.ceil(rect.height),
        };
    }
    exports.size = size;
    function scroll_size(el) {
        return {
            width: Math.ceil(el.scrollWidth),
            height: Math.ceil(el.scrollHeight),
        };
    }
    exports.scroll_size = scroll_size;
    function outer_size(el) {
        var _a = extents(el).margin, left = _a.left, right = _a.right, top = _a.top, bottom = _a.bottom;
        var _b = size(el), width = _b.width, height = _b.height;
        return {
            width: Math.ceil(width + left + right),
            height: Math.ceil(height + top + bottom),
        };
    }
    exports.outer_size = outer_size;
    function content_size(el) {
        var e_11, _a;
        var _b = el.getBoundingClientRect(), left = _b.left, top = _b.top;
        var padding = extents(el).padding;
        var width = 0;
        var height = 0;
        try {
            for (var _c = tslib_1.__values(el.children), _d = _c.next(); !_d.done; _d = _c.next()) {
                var child = _d.value;
                var rect = child.getBoundingClientRect();
                width = Math.max(width, Math.ceil(rect.left - left - padding.left + rect.width));
                height = Math.max(height, Math.ceil(rect.top - top - padding.top + rect.height));
            }
        }
        catch (e_11_1) {
            e_11 = { error: e_11_1 };
        }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return))
                    _a.call(_c);
            }
            finally {
                if (e_11)
                    throw e_11.error;
            }
        }
        return { width: width, height: height };
    }
    exports.content_size = content_size;
    function position(el, box, margin) {
        var style = el.style;
        style.left = box.x + "px";
        style.top = box.y + "px";
        style.width = box.width + "px";
        style.height = box.height + "px";
        if (margin == null)
            style.margin = "";
        else {
            var top = margin.top, right = margin.right, bottom = margin.bottom, left = margin.left;
            style.margin = top + "px " + right + "px " + bottom + "px " + left + "px";
        }
    }
    exports.position = position;
    function children(el) {
        return Array.from(el.children);
    }
    exports.children = children;
    var ClassList = /** @class */ (function () {
        function ClassList(el) {
            this.el = el;
            this.classList = el.classList;
        }
        Object.defineProperty(ClassList.prototype, "values", {
            get: function () {
                var values = [];
                for (var i_1 = 0; i_1 < this.classList.length; i_1++) {
                    var item = this.classList.item(i_1);
                    if (item != null)
                        values.push(item);
                }
                return values;
            },
            enumerable: false,
            configurable: true
        });
        ClassList.prototype.has = function (cls) {
            return this.classList.contains(cls);
        };
        ClassList.prototype.add = function () {
            var e_12, _a;
            var classes = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                classes[_i] = arguments[_i];
            }
            try {
                for (var classes_1 = tslib_1.__values(classes), classes_1_1 = classes_1.next(); !classes_1_1.done; classes_1_1 = classes_1.next()) {
                    var cls = classes_1_1.value;
                    this.classList.add(cls);
                }
            }
            catch (e_12_1) {
                e_12 = { error: e_12_1 };
            }
            finally {
                try {
                    if (classes_1_1 && !classes_1_1.done && (_a = classes_1.return))
                        _a.call(classes_1);
                }
                finally {
                    if (e_12)
                        throw e_12.error;
                }
            }
            return this;
        };
        ClassList.prototype.remove = function () {
            var e_13, _a;
            var classes = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                classes[_i] = arguments[_i];
            }
            try {
                for (var classes_2 = tslib_1.__values(classes), classes_2_1 = classes_2.next(); !classes_2_1.done; classes_2_1 = classes_2.next()) {
                    var cls = classes_2_1.value;
                    this.classList.remove(cls);
                }
            }
            catch (e_13_1) {
                e_13 = { error: e_13_1 };
            }
            finally {
                try {
                    if (classes_2_1 && !classes_2_1.done && (_a = classes_2.return))
                        _a.call(classes_2);
                }
                finally {
                    if (e_13)
                        throw e_13.error;
                }
            }
            return this;
        };
        ClassList.prototype.clear = function () {
            var e_14, _a;
            try {
                for (var _b = tslib_1.__values(this.values), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var cls = _c.value;
                    if (cls != "bk")
                        this.classList.remove(cls);
                }
            }
            catch (e_14_1) {
                e_14 = { error: e_14_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_14)
                        throw e_14.error;
                }
            }
            return this;
        };
        ClassList.prototype.toggle = function (cls, activate) {
            var add = activate != null ? activate : !this.has(cls);
            if (add)
                this.add(cls);
            else
                this.remove(cls);
            return this;
        };
        return ClassList;
    }());
    exports.ClassList = ClassList;
    ClassList.__name__ = "ClassList";
    function classes(el) {
        return new ClassList(el);
    }
    exports.classes = classes;
    function toggle_attribute(el, attr, state) {
        if (state == null) {
            state = !el.hasAttribute(attr);
        }
        if (state)
            el.setAttribute(attr, "true");
        else
            el.removeAttribute(attr);
    }
    exports.toggle_attribute = toggle_attribute;
    (function (Keys) {
        Keys[Keys["Backspace"] = 8] = "Backspace";
        Keys[Keys["Tab"] = 9] = "Tab";
        Keys[Keys["Enter"] = 13] = "Enter";
        Keys[Keys["Esc"] = 27] = "Esc";
        Keys[Keys["PageUp"] = 33] = "PageUp";
        Keys[Keys["PageDown"] = 34] = "PageDown";
        Keys[Keys["Left"] = 37] = "Left";
        Keys[Keys["Up"] = 38] = "Up";
        Keys[Keys["Right"] = 39] = "Right";
        Keys[Keys["Down"] = 40] = "Down";
        Keys[Keys["Delete"] = 46] = "Delete";
    })(exports.Keys || (exports.Keys = {}));
    function undisplayed(el, fn) {
        var display = el.style.display;
        el.style.display = "none";
        try {
            return fn();
        }
        finally {
            el.style.display = display;
        }
    }
    exports.undisplayed = undisplayed;
    function unsized(el, fn) {
        return sized(el, {}, fn);
    }
    exports.unsized = unsized;
    function sized(el, size, fn) {
        var _a = el.style, width = _a.width, height = _a.height, position = _a.position, display = _a.display;
        el.style.position = "absolute";
        el.style.display = "";
        el.style.width = size.width != null && size.width != Infinity ? size.width + "px" : "auto";
        el.style.height = size.height != null && size.height != Infinity ? size.height + "px" : "auto";
        try {
            return fn();
        }
        finally {
            el.style.position = position;
            el.style.display = display;
            el.style.width = width;
            el.style.height = height;
        }
    }
    exports.sized = sized;
    var StyleSheet = /** @class */ (function () {
        function StyleSheet(root) {
            this.root = root;
            this.known = new Set();
            this.style = exports.style({ type: "text/css" });
            prepend(root, this.style);
        }
        StyleSheet.prototype.append = function (css) {
            if (!this.known.has(css)) {
                this.style.appendChild(document.createTextNode(css));
                this.known.add(css);
            }
        };
        return StyleSheet;
    }());
    exports.StyleSheet = StyleSheet;
    StyleSheet.__name__ = "StyleSheet";
    exports.stylesheet = new StyleSheet(document.head);
    function dom_ready() {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                if (document.readyState == "loading") {
                    return [2 /*return*/, new Promise(function (resolve, _reject) {
                            document.addEventListener("DOMContentLoaded", function () { return resolve(); }, { once: true });
                        })];
                }
                return [2 /*return*/];
            });
        });
    }
    exports.dom_ready = dom_ready;
},
/* styles/root.css.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.root = "bk-root";
    exports.default = ".bk-root{position:relative;width:auto;height:auto;z-index:0;box-sizing:border-box;font-family:Helvetica, Arial, sans-serif;font-size:13px;}.bk-root .bk,.bk-root .bk:before,.bk-root .bk:after{box-sizing:inherit;margin:0;border:0;padding:0;background-image:none;font-family:inherit;font-size:100%;line-height:1.42857143;}.bk-root pre.bk{font-family:Courier, monospace;}";
},
/* core/visuals/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var line_1 = require(161) /* ./line */;
    __esExport("Line", line_1.Line);
    __esExport("LineScalar", line_1.LineScalar);
    __esExport("LineVector", line_1.LineVector);
    var fill_1 = require(164) /* ./fill */;
    __esExport("Fill", fill_1.Fill);
    __esExport("FillScalar", fill_1.FillScalar);
    __esExport("FillVector", fill_1.FillVector);
    var text_1 = require(165) /* ./text */;
    __esExport("Text", text_1.Text);
    __esExport("TextScalar", text_1.TextScalar);
    __esExport("TextVector", text_1.TextVector);
    var hatch_1 = require(166) /* ./hatch */;
    __esExport("Hatch", hatch_1.Hatch);
    __esExport("HatchScalar", hatch_1.HatchScalar);
    __esExport("HatchVector", hatch_1.HatchVector);
    var mixins = tslib_1.__importStar(require(163) /* ../property_mixins */);
    var visual_1 = require(162) /* ./visual */;
    __esExport("VisualProperties", visual_1.VisualProperties);
    __esExport("VisualUniforms", visual_1.VisualUniforms);
    var Visuals = /** @class */ (function () {
        function Visuals(view) {
            var e_1, _a;
            this._visuals = [];
            var _loop_1 = function (prefix, mixin) {
                var visual = (function () {
                    switch (mixin) {
                        case mixins.Line: return new line_1.Line(view, prefix);
                        case mixins.LineScalar: return new line_1.LineScalar(view, prefix);
                        case mixins.LineVector: return new line_1.LineVector(view, prefix);
                        case mixins.Fill: return new fill_1.Fill(view, prefix);
                        case mixins.FillScalar: return new fill_1.FillScalar(view, prefix);
                        case mixins.FillVector: return new fill_1.FillVector(view, prefix);
                        case mixins.Text: return new text_1.Text(view, prefix);
                        case mixins.TextScalar: return new text_1.TextScalar(view, prefix);
                        case mixins.TextVector: return new text_1.TextVector(view, prefix);
                        case mixins.Hatch: return new hatch_1.Hatch(view, prefix);
                        case mixins.HatchScalar: return new hatch_1.HatchScalar(view, prefix);
                        case mixins.HatchVector: return new hatch_1.HatchVector(view, prefix);
                        default:
                            throw new Error("unknown visual");
                    }
                })();
                this_1._visuals.push(visual);
                Object.defineProperty(this_1, prefix + visual.type, {
                    get: function () { return visual; },
                    configurable: false,
                    enumerable: true,
                });
            };
            var this_1 = this;
            try {
                for (var _b = tslib_1.__values(view.model._mixins), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var _d = tslib_1.__read(_c.value, 2), prefix = _d[0], mixin = _d[1];
                    _loop_1(prefix, mixin);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        }
        Visuals.prototype[Symbol.iterator] = function () {
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [5 /*yield**/, tslib_1.__values(this._visuals)];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        };
        return Visuals;
    }());
    exports.Visuals = Visuals;
    Visuals.__name__ = "Visuals";
},
/* core/visuals/line.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var visual_1 = require(162) /* ./visual */;
    var mixins = tslib_1.__importStar(require(163) /* ../property_mixins */);
    var color_1 = require(137) /* ../util/color */;
    var types_1 = require(123) /* ../util/types */;
    function resolve_line_dash(line_dash) {
        if (types_1.isArray(line_dash))
            return line_dash;
        else {
            switch (line_dash) {
                case "solid": return [];
                case "dashed": return [6];
                case "dotted": return [2, 4];
                case "dotdash": return [2, 4, 6, 4];
                case "dashdot": return [6, 4, 2, 4];
                default:
                    return line_dash.split(" ").map(Number).filter(types_1.isInteger);
            }
        }
    }
    exports.resolve_line_dash = resolve_line_dash;
    var Line = /** @class */ (function (_super) {
        tslib_1.__extends(Line, _super);
        function Line() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(Line.prototype, "doit", {
            get: function () {
                var color = this.line_color.get_value();
                var alpha = this.line_alpha.get_value();
                var width = this.line_width.get_value();
                return !(color == null || alpha == 0 || width == 0);
            },
            enumerable: false,
            configurable: true
        });
        Line.prototype.set_value = function (ctx) {
            var color = this.line_color.get_value();
            var alpha = this.line_alpha.get_value();
            ctx.strokeStyle = color_1.color2css(color, alpha);
            ctx.lineWidth = this.line_width.get_value();
            ctx.lineJoin = this.line_join.get_value();
            ctx.lineCap = this.line_cap.get_value();
            ctx.lineDash = resolve_line_dash(this.line_dash.get_value());
            ctx.lineDashOffset = this.line_dash_offset.get_value();
        };
        return Line;
    }(visual_1.VisualProperties));
    exports.Line = Line;
    Line.__name__ = "Line";
    var LineScalar = /** @class */ (function (_super) {
        tslib_1.__extends(LineScalar, _super);
        function LineScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(LineScalar.prototype, "doit", {
            get: function () {
                var color = this.line_color.value;
                var alpha = this.line_alpha.value;
                var width = this.line_width.value;
                return !(color == 0 || alpha == 0 || width == 0);
            },
            enumerable: false,
            configurable: true
        });
        LineScalar.prototype.set_value = function (ctx) {
            var color = this.line_color.value;
            var alpha = this.line_alpha.value;
            ctx.strokeStyle = color_1.color2css(color, alpha);
            ctx.lineWidth = this.line_width.value;
            ctx.lineJoin = this.line_join.value;
            ctx.lineCap = this.line_cap.value;
            ctx.lineDash = resolve_line_dash(this.line_dash.value);
            ctx.lineDashOffset = this.line_dash_offset.value;
        };
        return LineScalar;
    }(visual_1.VisualUniforms));
    exports.LineScalar = LineScalar;
    LineScalar.__name__ = "LineScalar";
    var LineVector = /** @class */ (function (_super) {
        tslib_1.__extends(LineVector, _super);
        function LineVector() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(LineVector.prototype, "doit", {
            get: function () {
                var line_color = this.line_color;
                if (line_color.is_Scalar() && line_color.value == 0)
                    return false;
                var line_alpha = this.line_alpha;
                if (line_alpha.is_Scalar() && line_alpha.value == 0)
                    return false;
                var line_width = this.line_width;
                if (line_width.is_Scalar() && line_width.value == 0)
                    return false;
                return true;
            },
            enumerable: false,
            configurable: true
        });
        LineVector.prototype.set_vectorize = function (ctx, i) {
            var color = this.line_color.get(i);
            var alpha = this.line_alpha.get(i);
            var width = this.line_width.get(i);
            var join = this.line_join.get(i);
            var cap = this.line_cap.get(i);
            var dash = this.line_dash.get(i);
            var offset = this.line_dash_offset.get(i);
            ctx.strokeStyle = color_1.color2css(color, alpha);
            ctx.lineWidth = width;
            ctx.lineJoin = join;
            ctx.lineCap = cap;
            ctx.lineDash = resolve_line_dash(dash);
            ctx.lineDashOffset = offset;
        };
        return LineVector;
    }(visual_1.VisualUniforms));
    exports.LineVector = LineVector;
    LineVector.__name__ = "LineVector";
    Line.prototype.type = "line";
    Line.prototype.attrs = Object.keys(mixins.Line);
    LineScalar.prototype.type = "line";
    LineScalar.prototype.attrs = Object.keys(mixins.LineScalar);
    LineVector.prototype.type = "line";
    LineVector.prototype.attrs = Object.keys(mixins.LineVector);
},
/* core/visuals/visual.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var VisualProperties = /** @class */ (function () {
        function VisualProperties(obj, prefix) {
            var e_1, _a;
            var _this = this;
            if (prefix === void 0) {
                prefix = "";
            }
            this.obj = obj;
            this.prefix = prefix;
            var self = this;
            this._props = [];
            try {
                for (var _b = tslib_1.__values(this.attrs), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var attr = _c.value;
                    var prop = obj.model.properties[prefix + attr];
                    prop.change.connect(function () { return _this.update(); });
                    self[attr] = prop;
                    this._props.push(prop);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            this.update();
        }
        VisualProperties.prototype[Symbol.iterator] = function () {
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [5 /*yield**/, tslib_1.__values(this._props)];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        };
        VisualProperties.prototype.update = function () { };
        return VisualProperties;
    }());
    exports.VisualProperties = VisualProperties;
    VisualProperties.__name__ = "VisualProperties";
    var VisualUniforms = /** @class */ (function () {
        function VisualUniforms(obj, prefix) {
            var e_2, _a;
            if (prefix === void 0) {
                prefix = "";
            }
            this.obj = obj;
            this.prefix = prefix;
            var _loop_1 = function (attr) {
                Object.defineProperty(this_1, attr, {
                    get: function () {
                        return obj[prefix + attr];
                    },
                });
            };
            var this_1 = this;
            try {
                for (var _b = tslib_1.__values(this.attrs), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var attr = _c.value;
                    _loop_1(attr);
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
        }
        VisualUniforms.prototype[Symbol.iterator] = function () {
            var _a, _b, attr, e_3_1;
            var e_3, _c;
            return tslib_1.__generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        _d.trys.push([0, 5, 6, 7]);
                        _a = tslib_1.__values(this.attrs), _b = _a.next();
                        _d.label = 1;
                    case 1:
                        if (!!_b.done)
                            return [3 /*break*/, 4];
                        attr = _b.value;
                        return [4 /*yield*/, this.obj.model.properties[this.prefix + attr]];
                    case 2:
                        _d.sent();
                        _d.label = 3;
                    case 3:
                        _b = _a.next();
                        return [3 /*break*/, 1];
                    case 4: return [3 /*break*/, 7];
                    case 5:
                        e_3_1 = _d.sent();
                        e_3 = { error: e_3_1 };
                        return [3 /*break*/, 7];
                    case 6:
                        try {
                            if (_b && !_b.done && (_c = _a.return))
                                _c.call(_a);
                        }
                        finally {
                            if (e_3)
                                throw e_3.error;
                        }
                        return [7 /*endfinally*/];
                    case 7: return [2 /*return*/];
                }
            });
        };
        VisualUniforms.prototype.update = function () { };
        return VisualUniforms;
    }());
    exports.VisualUniforms = VisualUniforms;
    VisualUniforms.__name__ = "VisualUniforms";
},
/* core/property_mixins.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var p = tslib_1.__importStar(require(133) /* ./properties */);
    var enums_1 = require(135) /* ./enums */;
    var k = tslib_1.__importStar(require(136) /* ./kinds */);
    var object_1 = require(128) /* ./util/object */;
    exports.Line = {
        line_color: [k.Nullable(k.Color), "black"],
        line_alpha: [k.Alpha, 1.0],
        line_width: [k.Number, 1],
        line_join: [enums_1.LineJoin, "bevel"],
        line_cap: [enums_1.LineCap, "butt"],
        line_dash: [k.Or(enums_1.LineDash, k.Array(k.Number)), []],
        line_dash_offset: [k.Number, 0],
    };
    exports.Fill = {
        fill_color: [k.Nullable(k.Color), "gray"],
        fill_alpha: [k.Alpha, 1.0],
    };
    exports.Hatch = {
        hatch_color: [k.Nullable(k.Color), "black"],
        hatch_alpha: [k.Alpha, 1.0],
        hatch_scale: [k.Number, 12.0],
        hatch_pattern: [k.Nullable(k.Or(enums_1.HatchPatternType, k.String)), null],
        hatch_weight: [k.Number, 1.0],
        hatch_extra: [k.Dict(k.AnyRef()), {}],
    };
    exports.Text = {
        text_color: [k.Nullable(k.Color), "#444444"],
        text_alpha: [k.Alpha, 1.0],
        text_font: [p.Font, "helvetica"],
        text_font_size: [k.FontSize, "16px"],
        text_font_style: [enums_1.FontStyle, "normal"],
        text_align: [enums_1.TextAlign, "left"],
        text_baseline: [enums_1.TextBaseline, "bottom"],
        text_line_height: [k.Number, 1.2],
    };
    exports.LineScalar = {
        line_color: [p.ColorScalar, "black"],
        line_alpha: [p.NumberScalar, 1.0],
        line_width: [p.NumberScalar, 1],
        line_join: [p.LineJoinScalar, "bevel"],
        line_cap: [p.LineCapScalar, "butt"],
        line_dash: [p.LineDashScalar, []],
        line_dash_offset: [p.NumberScalar, 0],
    };
    exports.FillScalar = {
        fill_color: [p.ColorScalar, "gray"],
        fill_alpha: [p.NumberScalar, 1.0],
    };
    exports.HatchScalar = {
        hatch_color: [p.ColorScalar, "black"],
        hatch_alpha: [p.NumberScalar, 1.0],
        hatch_scale: [p.NumberScalar, 12.0],
        hatch_pattern: [p.NullStringScalar, null],
        hatch_weight: [p.NumberScalar, 1.0],
        hatch_extra: [p.AnyScalar, {}],
    };
    exports.TextScalar = {
        text_color: [p.ColorScalar, "#444444"],
        text_alpha: [p.NumberScalar, 1.0],
        text_font: [p.FontScalar, "helvetica"],
        text_font_size: [p.FontSizeScalar, "16px"],
        text_font_style: [p.FontStyleScalar, "normal"],
        text_align: [p.TextAlignScalar, "left"],
        text_baseline: [p.TextBaselineScalar, "bottom"],
        text_line_height: [p.NumberScalar, 1.2],
    };
    exports.LineVector = {
        line_color: [p.ColorSpec, "black"],
        line_alpha: [p.NumberSpec, 1.0],
        line_width: [p.NumberSpec, 1],
        line_join: [p.LineJoinSpec, "bevel"],
        line_cap: [p.LineCapSpec, "butt"],
        line_dash: [p.LineDashSpec, []],
        line_dash_offset: [p.NumberSpec, 0],
    };
    exports.FillVector = {
        fill_color: [p.ColorSpec, "gray"],
        fill_alpha: [p.NumberSpec, 1.0],
    };
    exports.HatchVector = {
        hatch_color: [p.ColorSpec, "black"],
        hatch_alpha: [p.NumberSpec, 1.0],
        hatch_scale: [p.NumberSpec, 12.0],
        hatch_pattern: [p.NullStringSpec, null],
        hatch_weight: [p.NumberSpec, 1.0],
        hatch_extra: [p.AnyScalar, {}],
    };
    exports.TextVector = {
        text_color: [p.ColorSpec, "#444444"],
        text_alpha: [p.NumberSpec, 1.0],
        text_font: [p.FontSpec, "helvetica"],
        text_font_size: [p.FontSizeSpec, "16px"],
        text_font_style: [p.FontStyleSpec, "normal"],
        text_align: [p.TextAlignSpec, "left"],
        text_baseline: [p.TextBaselineSpec, "bottom"],
        text_line_height: [p.NumberSpec, 1.2],
    };
    function attrs_of(model, prefix, mixin, prefixed) {
        var e_1, _a;
        if (prefixed === void 0) {
            prefixed = false;
        }
        var attrs = {};
        try {
            for (var _b = tslib_1.__values(object_1.keys(mixin)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var attr = _c.value;
                var prefixed_attr = "" + prefix + attr;
                var value = model[prefixed_attr];
                attrs[prefixed ? prefixed_attr : attr] = value;
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return))
                    _a.call(_b);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
        return attrs;
    }
    exports.attrs_of = attrs_of;
},
/* core/visuals/fill.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var visual_1 = require(162) /* ./visual */;
    var mixins = tslib_1.__importStar(require(163) /* ../property_mixins */);
    var color_1 = require(137) /* ../util/color */;
    var Fill = /** @class */ (function (_super) {
        tslib_1.__extends(Fill, _super);
        function Fill() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(Fill.prototype, "doit", {
            get: function () {
                var color = this.fill_color.get_value();
                var alpha = this.fill_alpha.get_value();
                return !(color == null || alpha == 0);
            },
            enumerable: false,
            configurable: true
        });
        Fill.prototype.set_value = function (ctx) {
            var color = this.fill_color.get_value();
            var alpha = this.fill_alpha.get_value();
            ctx.fillStyle = color_1.color2css(color, alpha);
        };
        return Fill;
    }(visual_1.VisualProperties));
    exports.Fill = Fill;
    Fill.__name__ = "Fill";
    var FillScalar = /** @class */ (function (_super) {
        tslib_1.__extends(FillScalar, _super);
        function FillScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(FillScalar.prototype, "doit", {
            get: function () {
                var color = this.fill_color.value;
                var alpha = this.fill_alpha.value;
                return !(color == 0 || alpha == 0);
            },
            enumerable: false,
            configurable: true
        });
        FillScalar.prototype.set_value = function (ctx) {
            var color = this.fill_color.value;
            var alpha = this.fill_alpha.value;
            ctx.fillStyle = color_1.color2css(color, alpha);
        };
        return FillScalar;
    }(visual_1.VisualUniforms));
    exports.FillScalar = FillScalar;
    FillScalar.__name__ = "FillScalar";
    var FillVector = /** @class */ (function (_super) {
        tslib_1.__extends(FillVector, _super);
        function FillVector() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(FillVector.prototype, "doit", {
            get: function () {
                var fill_color = this.fill_color;
                if (fill_color.is_Scalar() && fill_color.value == 0)
                    return false;
                var fill_alpha = this.fill_alpha;
                if (fill_alpha.is_Scalar() && fill_alpha.value == 0)
                    return false;
                return true;
            },
            enumerable: false,
            configurable: true
        });
        FillVector.prototype.set_vectorize = function (ctx, i) {
            var color = this.fill_color.get(i);
            var alpha = this.fill_alpha.get(i);
            ctx.fillStyle = color_1.color2css(color, alpha);
        };
        return FillVector;
    }(visual_1.VisualUniforms));
    exports.FillVector = FillVector;
    FillVector.__name__ = "FillVector";
    Fill.prototype.type = "fill";
    Fill.prototype.attrs = Object.keys(mixins.Fill);
    FillScalar.prototype.type = "fill";
    FillScalar.prototype.attrs = Object.keys(mixins.FillScalar);
    FillVector.prototype.type = "fill";
    FillVector.prototype.attrs = Object.keys(mixins.FillVector);
},
/* core/visuals/text.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var visual_1 = require(162) /* ./visual */;
    var mixins = tslib_1.__importStar(require(163) /* ../property_mixins */);
    var color_1 = require(137) /* ../util/color */;
    var Text = /** @class */ (function (_super) {
        tslib_1.__extends(Text, _super);
        function Text() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(Text.prototype, "doit", {
            get: function () {
                var color = this.text_color.get_value();
                var alpha = this.text_alpha.get_value();
                return !(color == null || alpha == 0);
            },
            enumerable: false,
            configurable: true
        });
        Text.prototype.set_value = function (ctx) {
            var color = this.text_color.get_value();
            var alpha = this.text_alpha.get_value();
            ctx.fillStyle = color_1.color2css(color, alpha);
            ctx.font = this.font_value();
            ctx.textAlign = this.text_align.get_value();
            ctx.textBaseline = this.text_baseline.get_value();
        };
        Text.prototype.font_value = function () {
            var style = this.text_font_style.get_value();
            var size = this.text_font_size.get_value();
            var face = this.text_font.get_value();
            return style + " " + size + " " + face;
        };
        return Text;
    }(visual_1.VisualProperties));
    exports.Text = Text;
    Text.__name__ = "Text";
    var TextScalar = /** @class */ (function (_super) {
        tslib_1.__extends(TextScalar, _super);
        function TextScalar() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(TextScalar.prototype, "doit", {
            get: function () {
                var color = this.text_color.value;
                var alpha = this.text_alpha.value;
                return !(color == 0 || alpha == 0);
            },
            enumerable: false,
            configurable: true
        });
        TextScalar.prototype.set_value = function (ctx) {
            var color = this.text_color.value;
            var alpha = this.text_alpha.value;
            var font = this.font_value();
            var align = this.text_align.value;
            var baseline = this.text_baseline.value;
            ctx.fillStyle = color_1.color2css(color, alpha);
            ctx.font = font;
            ctx.textAlign = align;
            ctx.textBaseline = baseline;
        };
        TextScalar.prototype.font_value = function () {
            var style = this.text_font_style.value;
            var size = this.text_font_size.value;
            var face = this.text_font.value;
            return style + " " + size + " " + face;
        };
        return TextScalar;
    }(visual_1.VisualUniforms));
    exports.TextScalar = TextScalar;
    TextScalar.__name__ = "TextScalar";
    var TextVector = /** @class */ (function (_super) {
        tslib_1.__extends(TextVector, _super);
        function TextVector() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(TextVector.prototype, "doit", {
            get: function () {
                var text_color = this.text_color;
                if (text_color.is_Scalar() && text_color.value == 0)
                    return false;
                var text_alpha = this.text_alpha;
                if (text_alpha.is_Scalar() && text_alpha.value == 0)
                    return false;
                return true;
            },
            enumerable: false,
            configurable: true
        });
        TextVector.prototype.set_vectorize = function (ctx, i) {
            var color = this.text_color.get(i);
            var alpha = this.text_alpha.get(i);
            var font = this.font_value(i);
            var align = this.text_align.get(i);
            var baseline = this.text_baseline.get(i);
            ctx.fillStyle = color_1.color2css(color, alpha);
            ctx.font = font;
            ctx.textAlign = align;
            ctx.textBaseline = baseline;
        };
        TextVector.prototype.font_value = function (i) {
            var style = this.text_font_style.get(i);
            var size = this.text_font_size.get(i);
            var face = this.text_font.get(i);
            return style + " " + size + " " + face;
        };
        return TextVector;
    }(visual_1.VisualUniforms));
    exports.TextVector = TextVector;
    TextVector.__name__ = "TextVector";
    Text.prototype.type = "text";
    Text.prototype.attrs = Object.keys(mixins.Text);
    TextScalar.prototype.type = "text";
    TextScalar.prototype.attrs = Object.keys(mixins.TextScalar);
    TextVector.prototype.type = "text";
    TextVector.prototype.attrs = Object.keys(mixins.TextVector);
},
/* core/visuals/hatch.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var visual_1 = require(162) /* ./visual */;
    var patterns_1 = require(167) /* ./patterns */;
    var p = tslib_1.__importStar(require(133) /* ../properties */);
    var mixins = tslib_1.__importStar(require(163) /* ../property_mixins */);
    var Hatch = /** @class */ (function (_super) {
        tslib_1.__extends(Hatch, _super);
        function Hatch() {
            var _this = _super.apply(this, tslib_1.__spread(arguments)) || this;
            _this._update_iteration = 0;
            return _this;
        }
        Hatch.prototype.update = function () {
            var _this = this;
            this._update_iteration++;
            this._hatch_image = null;
            if (!this.doit)
                return;
            var color = this.hatch_color.get_value();
            var alpha = this.hatch_alpha.get_value();
            var scale = this.hatch_scale.get_value();
            var pattern = this.hatch_pattern.get_value();
            var weight = this.hatch_weight.get_value();
            var finalize = function (image) {
                _this._hatch_image = image;
            };
            var textures = this.hatch_extra.get_value();
            var texture = textures[pattern];
            if (texture != null) {
                var image = texture.get_pattern(color, alpha, scale, weight);
                if (image instanceof Promise) {
                    var _update_iteration_1 = this._update_iteration;
                    image.then(function (image) {
                        if (_this._update_iteration == _update_iteration_1) {
                            finalize(image);
                            _this.obj.request_render();
                        }
                    });
                }
                else {
                    finalize(image);
                }
            }
            else {
                var layer = this.obj.canvas.create_layer();
                var image = patterns_1.get_pattern(layer, pattern, color, alpha, scale, weight);
                finalize(image);
            }
        };
        Object.defineProperty(Hatch.prototype, "doit", {
            get: function () {
                var color = this.hatch_color.get_value();
                var alpha = this.hatch_alpha.get_value();
                var pattern = this.hatch_pattern.get_value();
                return !(color == null || alpha == 0 || pattern == " " || pattern == "blank" || pattern == null);
            },
            enumerable: false,
            configurable: true
        });
        Hatch.prototype.set_value = function (ctx) {
            var pattern = this.pattern(ctx);
            ctx.fillStyle = pattern !== null && pattern !== void 0 ? pattern : "transparent";
        };
        Hatch.prototype.pattern = function (ctx) {
            var image = this._hatch_image;
            if (image == null)
                return null;
            else
                return ctx.createPattern(image, this.repetition());
        };
        Hatch.prototype.repetition = function () {
            var pattern = this.hatch_pattern.get_value();
            var texture = this.hatch_extra.get_value()[pattern];
            if (texture == null)
                return "repeat";
            else {
                switch (texture.repetition) {
                    case "repeat": return "repeat";
                    case "repeat_x": return "repeat-x";
                    case "repeat_y": return "repeat-y";
                    case "no_repeat": return "no-repeat";
                }
            }
        };
        return Hatch;
    }(visual_1.VisualProperties));
    exports.Hatch = Hatch;
    Hatch.__name__ = "Hatch";
    var HatchScalar = /** @class */ (function (_super) {
        tslib_1.__extends(HatchScalar, _super);
        function HatchScalar() {
            var _this = _super.apply(this, tslib_1.__spread(arguments)) || this;
            _this._static_doit = false;
            _this._update_iteration = 0;
            return _this;
        }
        HatchScalar.prototype._compute_static_doit = function () {
            var color = this.hatch_color.value;
            var alpha = this.hatch_alpha.value;
            var pattern = this.hatch_pattern.value;
            return !(color == null || alpha == 0 || pattern == " " || pattern == "blank" || pattern == null);
        };
        HatchScalar.prototype.update = function () {
            var _this = this;
            this._update_iteration++;
            var n = this.hatch_color.length;
            this._hatch_image = new p.UniformScalar(null, n);
            this._static_doit = this._compute_static_doit();
            if (!this._static_doit)
                return;
            var color = this.hatch_color.value;
            var alpha = this.hatch_alpha.value;
            var scale = this.hatch_scale.value;
            var pattern = this.hatch_pattern.value;
            var weight = this.hatch_weight.value;
            var finalize = function (image) {
                _this._hatch_image = new p.UniformScalar(image, n);
            };
            var textures = this.hatch_extra.value;
            var texture = textures[pattern];
            if (texture != null) {
                var image = texture.get_pattern(color, alpha, scale, weight);
                if (image instanceof Promise) {
                    var _update_iteration_2 = this._update_iteration;
                    image.then(function (image) {
                        if (_this._update_iteration == _update_iteration_2) {
                            finalize(image);
                            _this.obj.request_render();
                        }
                    });
                }
                else {
                    finalize(image);
                }
            }
            else {
                var layer = this.obj.canvas.create_layer();
                var image = patterns_1.get_pattern(layer, pattern, color, alpha, scale, weight);
                finalize(image);
            }
        };
        Object.defineProperty(HatchScalar.prototype, "doit", {
            get: function () {
                return this._static_doit;
            },
            enumerable: false,
            configurable: true
        });
        HatchScalar.prototype.set_value = function (ctx) {
            var _a;
            ctx.fillStyle = (_a = this.pattern(ctx)) !== null && _a !== void 0 ? _a : "transparent";
        };
        HatchScalar.prototype.pattern = function (ctx) {
            var image = this._hatch_image.value;
            if (image == null)
                return null;
            else
                return ctx.createPattern(image, this.repetition());
        };
        HatchScalar.prototype.repetition = function () {
            var pattern = this.hatch_pattern.value;
            var texture = this.hatch_extra.value[pattern];
            if (texture == null)
                return "repeat";
            else {
                switch (texture.repetition) {
                    case "repeat": return "repeat";
                    case "repeat_x": return "repeat-x";
                    case "repeat_y": return "repeat-y";
                    case "no_repeat": return "no-repeat";
                }
            }
        };
        return HatchScalar;
    }(visual_1.VisualUniforms));
    exports.HatchScalar = HatchScalar;
    HatchScalar.__name__ = "HatchScalar";
    var HatchVector = /** @class */ (function (_super) {
        tslib_1.__extends(HatchVector, _super);
        function HatchVector() {
            var _this = _super.apply(this, tslib_1.__spread(arguments)) || this;
            _this._static_doit = false;
            _this._update_iteration = 0;
            return _this;
        }
        HatchVector.prototype._compute_static_doit = function () {
            var hatch_color = this.hatch_color;
            if (hatch_color.is_Scalar() && hatch_color.value == 0)
                return false;
            var hatch_alpha = this.hatch_alpha;
            if (hatch_alpha.is_Scalar() && hatch_alpha.value == 0)
                return false;
            var hatch_pattern = this.hatch_pattern;
            if (hatch_pattern.is_Scalar()) {
                var pattern = hatch_pattern.value;
                if (pattern == " " || pattern == "blank" || pattern == null)
                    return false;
            }
            return true;
        };
        HatchVector.prototype.update = function () {
            var _this = this;
            this._update_iteration++;
            var n = this.hatch_color.length;
            this._hatch_image = new p.UniformScalar(null, n);
            this._static_doit = this._compute_static_doit();
            if (!this._static_doit)
                return;
            var resolve_image = function (pattern, color, alpha, scale, weight, finalize) {
                var textures = _this.hatch_extra.value;
                var texture = textures[pattern];
                if (texture != null) {
                    var image = texture.get_pattern(color, alpha, scale, weight);
                    if (image instanceof Promise) {
                        var _update_iteration_3 = _this._update_iteration;
                        image.then(function (image) {
                            if (_this._update_iteration == _update_iteration_3) {
                                finalize(image);
                                _this.obj.request_render();
                            }
                        });
                    }
                    else {
                        finalize(image);
                    }
                }
                else {
                    var layer = _this.obj.canvas.create_layer();
                    var image = patterns_1.get_pattern(layer, pattern, color, alpha, scale, weight);
                    finalize(image);
                }
            };
            if (this.hatch_color.is_Scalar() &&
                this.hatch_alpha.is_Scalar() &&
                this.hatch_scale.is_Scalar() &&
                this.hatch_pattern.is_Scalar() &&
                this.hatch_weight.is_Scalar()) {
                var color = this.hatch_color.value;
                var alpha = this.hatch_alpha.value;
                var scale = this.hatch_scale.value;
                var pattern = this.hatch_pattern.value;
                var weight = this.hatch_weight.value;
                resolve_image(pattern, color, alpha, scale, weight, function (image) {
                    _this._hatch_image = new p.UniformScalar(image, n);
                });
            }
            else {
                var images_1 = new Array(n);
                images_1.fill(null);
                this._hatch_image = new p.UniformVector(images_1);
                var _loop_1 = function (i) {
                    var color = this_1.hatch_color.get(i);
                    var alpha = this_1.hatch_alpha.get(i);
                    var scale = this_1.hatch_scale.get(i);
                    var pattern = this_1.hatch_pattern.get(i);
                    var weight = this_1.hatch_weight.get(i);
                    resolve_image(pattern, color, alpha, scale, weight, function (image) {
                        images_1[i] = image;
                    });
                };
                var this_1 = this;
                for (var i = 0; i < n; i++) {
                    _loop_1(i);
                }
            }
        };
        Object.defineProperty(HatchVector.prototype, "doit", {
            get: function () {
                return this._static_doit;
            },
            enumerable: false,
            configurable: true
        });
        HatchVector.prototype.set_vectorize = function (ctx, i) {
            var _a;
            ctx.fillStyle = (_a = this.pattern(ctx, i)) !== null && _a !== void 0 ? _a : "transparent";
        };
        HatchVector.prototype.pattern = function (ctx, i) {
            var image = this._hatch_image.get(i);
            if (image == null)
                return null;
            else
                return ctx.createPattern(image, this.repetition(i));
        };
        HatchVector.prototype.repetition = function (i) {
            var pattern = this.hatch_pattern.get(i);
            var texture = this.hatch_extra.value[pattern];
            if (texture == null)
                return "repeat";
            else {
                switch (texture.repetition) {
                    case "repeat": return "repeat";
                    case "repeat_x": return "repeat-x";
                    case "repeat_y": return "repeat-y";
                    case "no_repeat": return "no-repeat";
                }
            }
        };
        return HatchVector;
    }(visual_1.VisualUniforms));
    exports.HatchVector = HatchVector;
    HatchVector.__name__ = "HatchVector";
    Hatch.prototype.type = "hatch";
    Hatch.prototype.attrs = Object.keys(mixins.Hatch);
    HatchScalar.prototype.type = "hatch";
    HatchScalar.prototype.attrs = Object.keys(mixins.HatchScalar);
    HatchVector.prototype.type = "hatch";
    HatchVector.prototype.attrs = Object.keys(mixins.HatchVector);
},
/* core/visuals/patterns.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var color_1 = require(137) /* ../util/color */;
    function _horz(ctx, h, h2) {
        ctx.moveTo(0, h2 + 0.5);
        ctx.lineTo(h, h2 + 0.5);
        ctx.stroke();
    }
    function _vert(ctx, h, h2) {
        ctx.moveTo(h2 + 0.5, 0);
        ctx.lineTo(h2 + 0.5, h);
        ctx.stroke();
    }
    function _x(ctx, h) {
        ctx.moveTo(0, h);
        ctx.lineTo(h, 0);
        ctx.stroke();
        ctx.moveTo(0, 0);
        ctx.lineTo(h, h);
        ctx.stroke();
    }
    exports.hatch_aliases = {
        " ": "blank",
        ".": "dot",
        o: "ring",
        "-": "horizontal_line",
        "|": "vertical_line",
        "+": "cross",
        "\"": "horizontal_dash",
        ":": "vertical_dash",
        "@": "spiral",
        "/": "right_diagonal_line",
        "\\": "left_diagonal_line",
        x: "diagonal_cross",
        ",": "right_diagonal_dash",
        "`": "left_diagonal_dash",
        v: "horizontal_wave",
        ">": "vertical_wave",
        "*": "criss_cross",
    };
    function get_pattern(layer, pattern, color, alpha, scale, weight) {
        layer.resize(scale, scale);
        layer.prepare();
        create_hatch_canvas(layer.ctx, pattern, color, alpha, scale, weight);
        return layer.canvas;
    }
    exports.get_pattern = get_pattern;
    function create_hatch_canvas(ctx, hatch_pattern, hatch_color, hatch_alpha, hatch_scale, hatch_weight) {
        var _a;
        var h = hatch_scale;
        var h2 = h / 2;
        var h4 = h2 / 2;
        var color = color_1.color2css(hatch_color, hatch_alpha);
        ctx.strokeStyle = color;
        ctx.fillStyle = color;
        ctx.lineCap = "square";
        ctx.lineWidth = hatch_weight;
        switch ((_a = exports.hatch_aliases[hatch_pattern]) !== null && _a !== void 0 ? _a : hatch_pattern) {
            // we should not need these if code conditions on hatch.doit, but
            // include them here just for completeness
            case "blank":
                break;
            case "dot":
                ctx.arc(h2, h2, h2 / 2, 0, 2 * Math.PI, true);
                ctx.fill();
                break;
            case "ring":
                ctx.arc(h2, h2, h2 / 2, 0, 2 * Math.PI, true);
                ctx.stroke();
                break;
            case "horizontal_line":
                _horz(ctx, h, h2);
                break;
            case "vertical_line":
                _vert(ctx, h, h2);
                break;
            case "cross":
                _horz(ctx, h, h2);
                _vert(ctx, h, h2);
                break;
            case "horizontal_dash":
                _horz(ctx, h2, h2);
                break;
            case "vertical_dash":
                _vert(ctx, h2, h2);
                break;
            case "spiral": {
                var h30 = h / 30;
                ctx.moveTo(h2, h2);
                for (var i = 0; i < 360; i++) {
                    var angle = 0.1 * i;
                    var x = h2 + (h30 * angle) * Math.cos(angle);
                    var y = h2 + (h30 * angle) * Math.sin(angle);
                    ctx.lineTo(x, y);
                }
                ctx.stroke();
                break;
            }
            case "right_diagonal_line":
                ctx.moveTo(-h4 + 0.5, h);
                ctx.lineTo(h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(h4 + 0.5, h);
                ctx.lineTo(3 * h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(3 * h4 + 0.5, h);
                ctx.lineTo(5 * h4 + 0.5, 0);
                ctx.stroke();
                ctx.stroke();
                break;
            case "left_diagonal_line":
                ctx.moveTo(h4 + 0.5, h);
                ctx.lineTo(-h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(3 * h4 + 0.5, h);
                ctx.lineTo(h4 + 0.5, 0);
                ctx.stroke();
                ctx.moveTo(5 * h4 + 0.5, h);
                ctx.lineTo(3 * h4 + 0.5, 0);
                ctx.stroke();
                ctx.stroke();
                break;
            case "diagonal_cross":
                _x(ctx, h);
                break;
            case "right_diagonal_dash":
                ctx.moveTo(h4 + 0.5, 3 * h4 + 0.5);
                ctx.lineTo(3 * h4 + 0.5, h4 + 0.5);
                ctx.stroke();
                break;
            case "left_diagonal_dash":
                ctx.moveTo(h4 + 0.5, h4 + 0.5);
                ctx.lineTo(3 * h4 + 0.5, 3 * h4 + 0.5);
                ctx.stroke();
                break;
            case "horizontal_wave":
                ctx.moveTo(0, h4);
                ctx.lineTo(h2, 3 * h4);
                ctx.lineTo(h, h4);
                ctx.stroke();
                break;
            case "vertical_wave":
                ctx.moveTo(h4, 0);
                ctx.lineTo(3 * h4, h2);
                ctx.lineTo(h4, h);
                ctx.stroke();
                break;
            case "criss_cross":
                _x(ctx, h);
                _horz(ctx, h, h2);
                _vert(ctx, h, h2);
                break;
        }
    }
},
/* model.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var has_props_1 = require(129) /* ./core/has_props */;
    var types_1 = require(123) /* ./core/util/types */;
    var object_1 = require(128) /* ./core/util/object */;
    var logging_1 = require(134) /* ./core/logging */;
    var Model = /** @class */ (function (_super) {
        tslib_1.__extends(Model, _super);
        function Model(attrs) {
            return _super.call(this, attrs) || this;
        }
        Object.defineProperty(Model.prototype, "is_syncable", {
            get: function () {
                return this.syncable;
            },
            enumerable: false,
            configurable: true
        });
        Model.init_Model = function () {
            this.define(function (_a) {
                var Any = _a.Any, Unknown = _a.Unknown, Boolean = _a.Boolean, String = _a.String, Array = _a.Array, Dict = _a.Dict, Nullable = _a.Nullable;
                return ({
                    tags: [Array(Unknown), []],
                    name: [Nullable(String), null],
                    js_property_callbacks: [Dict(Array(Any /*TODO*/)), {}],
                    js_event_callbacks: [Dict(Array(Any /*TODO*/)), {}],
                    subscribed_events: [Array(String), []],
                    syncable: [Boolean, true],
                });
            });
        };
        Model.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._js_callbacks = new Map();
        };
        Model.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this._update_property_callbacks();
            this.connect(this.properties.js_property_callbacks.change, function () { return _this._update_property_callbacks(); });
            this.connect(this.properties.js_event_callbacks.change, function () { return _this._update_event_callbacks(); });
            this.connect(this.properties.subscribed_events.change, function () { return _this._update_event_callbacks(); });
        };
        /*protected*/ Model.prototype._process_event = function (event) {
            var e_1, _a;
            var _b;
            try {
                for (var _c = tslib_1.__values((_b = this.js_event_callbacks[event.event_name]) !== null && _b !== void 0 ? _b : []), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var callback = _d.value;
                    callback.execute(event);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return))
                        _a.call(_c);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            if (this.document != null && this.subscribed_events.some(function (m) { return m == event.event_name; }))
                this.document.event_manager.send_event(event);
        };
        Model.prototype.trigger_event = function (event) {
            if (this.document != null) {
                event.origin = this;
                this.document.event_manager.trigger(event);
            }
        };
        Model.prototype._update_event_callbacks = function () {
            if (this.document == null) {
                logging_1.logger.warn('WARNING: Document not defined for updating event callbacks');
                return;
            }
            this.document.event_manager.subscribed_models.add(this);
        };
        Model.prototype._update_property_callbacks = function () {
            var e_2, _a, e_3, _b, e_4, _c, e_5, _d;
            var _this = this;
            var signal_for = function (event) {
                var _a = tslib_1.__read(event.split(":"), 2), evt = _a[0], _b = _a[1], attr = _b === void 0 ? null : _b;
                return attr != null ? _this.properties[attr][evt] : _this[evt];
            };
            try {
                for (var _e = tslib_1.__values(this._js_callbacks), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var _g = tslib_1.__read(_f.value, 2), event = _g[0], callbacks = _g[1];
                    var signal = signal_for(event);
                    try {
                        for (var callbacks_1 = (e_3 = void 0, tslib_1.__values(callbacks)), callbacks_1_1 = callbacks_1.next(); !callbacks_1_1.done; callbacks_1_1 = callbacks_1.next()) {
                            var cb = callbacks_1_1.value;
                            this.disconnect(signal, cb);
                        }
                    }
                    catch (e_3_1) {
                        e_3 = { error: e_3_1 };
                    }
                    finally {
                        try {
                            if (callbacks_1_1 && !callbacks_1_1.done && (_b = callbacks_1.return))
                                _b.call(callbacks_1);
                        }
                        finally {
                            if (e_3)
                                throw e_3.error;
                        }
                    }
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_f && !_f.done && (_a = _e.return))
                        _a.call(_e);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            this._js_callbacks.clear();
            try {
                for (var _h = tslib_1.__values(object_1.entries(this.js_property_callbacks)), _j = _h.next(); !_j.done; _j = _h.next()) {
                    var _k = tslib_1.__read(_j.value, 2), event = _k[0], callbacks = _k[1];
                    var wrappers = callbacks.map(function (cb) { return function () { return cb.execute(_this); }; });
                    this._js_callbacks.set(event, wrappers);
                    var signal = signal_for(event);
                    try {
                        for (var wrappers_1 = (e_5 = void 0, tslib_1.__values(wrappers)), wrappers_1_1 = wrappers_1.next(); !wrappers_1_1.done; wrappers_1_1 = wrappers_1.next()) {
                            var cb = wrappers_1_1.value;
                            this.connect(signal, cb);
                        }
                    }
                    catch (e_5_1) {
                        e_5 = { error: e_5_1 };
                    }
                    finally {
                        try {
                            if (wrappers_1_1 && !wrappers_1_1.done && (_d = wrappers_1.return))
                                _d.call(wrappers_1);
                        }
                        finally {
                            if (e_5)
                                throw e_5.error;
                        }
                    }
                }
            }
            catch (e_4_1) {
                e_4 = { error: e_4_1 };
            }
            finally {
                try {
                    if (_j && !_j.done && (_c = _h.return))
                        _c.call(_h);
                }
                finally {
                    if (e_4)
                        throw e_4.error;
                }
            }
        };
        Model.prototype._doc_attached = function () {
            if (!object_1.isEmpty(this.js_event_callbacks) || this.subscribed_events.length != 0)
                this._update_event_callbacks();
        };
        Model.prototype._doc_detached = function () {
            this.document.event_manager.subscribed_models.delete(this);
        };
        Model.prototype.select = function (selector) {
            if (types_1.isString(selector))
                return tslib_1.__spread(this.references()).filter(function (ref) { return ref instanceof Model && ref.name === selector; });
            else if (selector.prototype instanceof has_props_1.HasProps)
                return tslib_1.__spread(this.references()).filter(function (ref) { return ref instanceof selector; });
            else
                throw new Error("invalid selector");
        };
        Model.prototype.select_one = function (selector) {
            var result = this.select(selector);
            switch (result.length) {
                case 0:
                    return null;
                case 1:
                    return result[0];
                default:
                    throw new Error("found more than one object matching given selector");
            }
        };
        return Model;
    }(has_props_1.HasProps));
    exports.Model = Model;
    Model.__name__ = "Model";
    Model.init_Model();
},
/* models/canvas/coordinates.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var CoordinateTransform = /** @class */ (function () {
        function CoordinateTransform(x_scale, y_scale) {
            this.x_scale = x_scale;
            this.y_scale = y_scale;
            this.x_range = this.x_scale.source_range;
            this.y_range = this.y_scale.source_range;
            this.ranges = [this.x_range, this.y_range];
            this.scales = [this.x_scale, this.y_scale];
        }
        CoordinateTransform.prototype.map_to_screen = function (xs, ys) {
            var sxs = this.x_scale.v_compute(xs);
            var sys = this.y_scale.v_compute(ys);
            return [sxs, sys];
        };
        CoordinateTransform.prototype.map_from_screen = function (sxs, sys) {
            var xs = this.x_scale.v_invert(sxs);
            var ys = this.y_scale.v_invert(sys);
            return [xs, ys];
        };
        return CoordinateTransform;
    }());
    exports.CoordinateTransform = CoordinateTransform;
    CoordinateTransform.__name__ = "CoordinateTransform";
},
/* models/annotations/arrow.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var data_annotation_1 = require(171) /* ./data_annotation */;
    var arrow_head_1 = require(248) /* ./arrow_head */;
    var property_mixins_1 = require(163) /* ../../core/property_mixins */;
    var enums_1 = require(135) /* ../../core/enums */;
    var types_1 = require(139) /* ../../core/types */;
    var build_views_1 = require(237) /* ../../core/build_views */;
    var p = tslib_1.__importStar(require(133) /* ../../core/properties */);
    var math_1 = require(125) /* ../../core/util/math */;
    var ArrowView = /** @class */ (function (_super) {
        tslib_1.__extends(ArrowView, _super);
        function ArrowView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ArrowView.prototype.lazy_initialize = function () {
            return tslib_1.__awaiter(this, void 0, void 0, function () {
                var _a, start, end, _b, _c;
                return tslib_1.__generator(this, function (_d) {
                    switch (_d.label) {
                        case 0: return [4 /*yield*/, _super.prototype.lazy_initialize.call(this)];
                        case 1:
                            _d.sent();
                            _a = this.model, start = _a.start, end = _a.end;
                            if (!(start != null))
                                return [3 /*break*/, 3];
                            _b = this;
                            return [4 /*yield*/, build_views_1.build_view(start, { parent: this })];
                        case 2:
                            _b.start = _d.sent();
                            _d.label = 3;
                        case 3:
                            if (!(end != null))
                                return [3 /*break*/, 5];
                            _c = this;
                            return [4 /*yield*/, build_views_1.build_view(end, { parent: this })];
                        case 4:
                            _c.end = _d.sent();
                            _d.label = 5;
                        case 5: return [2 /*return*/];
                    }
                });
            });
        };
        ArrowView.prototype.set_data = function (source) {
            var _a, _b;
            _super.prototype.set_data.call(this, source);
            (_a = this.start) === null || _a === void 0 ? void 0 : _a.set_data(source);
            (_b = this.end) === null || _b === void 0 ? void 0 : _b.set_data(source);
        };
        ArrowView.prototype.remove = function () {
            var _a, _b;
            (_a = this.start) === null || _a === void 0 ? void 0 : _a.remove();
            (_b = this.end) === null || _b === void 0 ? void 0 : _b.remove();
            _super.prototype.remove.call(this);
        };
        ArrowView.prototype.map_data = function () {
            var frame = this.plot_view.frame;
            if (this.model.start_units == "data") {
                this._sx_start = this.coordinates.x_scale.v_compute(this._x_start);
                this._sy_start = this.coordinates.y_scale.v_compute(this._y_start);
            }
            else {
                this._sx_start = frame.bbox.xview.v_compute(this._x_start);
                this._sy_start = frame.bbox.yview.v_compute(this._y_start);
            }
            if (this.model.end_units == "data") {
                this._sx_end = this.coordinates.x_scale.v_compute(this._x_end);
                this._sy_end = this.coordinates.y_scale.v_compute(this._y_end);
            }
            else {
                this._sx_end = frame.bbox.xview.v_compute(this._x_end);
                this._sy_end = frame.bbox.yview.v_compute(this._y_end);
            }
            var _a = this, _sx_start = _a._sx_start, _sy_start = _a._sy_start, _sx_end = _a._sx_end, _sy_end = _a._sy_end;
            var n = _sx_start.length;
            var angles = this._angles = new types_1.ScreenArray(n);
            for (var i = 0; i < n; i++) {
                // arrow head runs orthogonal to arrow body (???)
                angles[i] = Math.PI / 2 + math_1.atan2([_sx_start[i], _sy_start[i]], [_sx_end[i], _sy_end[i]]);
            }
        };
        ArrowView.prototype.paint = function (ctx) {
            var _a = this, start = _a.start, end = _a.end;
            var _b = this, _sx_start = _b._sx_start, _sy_start = _b._sy_start, _sx_end = _b._sx_end, _sy_end = _b._sy_end, _angles = _b._angles;
            var _c = this.plot_view.frame.bbox, x = _c.x, y = _c.y, width = _c.width, height = _c.height;
            for (var i = 0, n = _sx_start.length; i < n; i++) {
                if (end != null) {
                    ctx.save();
                    ctx.translate(_sx_end[i], _sy_end[i]);
                    ctx.rotate(_angles[i]);
                    end.render(ctx, i);
                    ctx.restore();
                }
                if (start != null) {
                    ctx.save();
                    ctx.translate(_sx_start[i], _sy_start[i]);
                    ctx.rotate(_angles[i] + Math.PI);
                    start.render(ctx, i);
                    ctx.restore();
                }
                if (this.visuals.line.doit) {
                    ctx.save();
                    if (start != null || end != null) {
                        ctx.beginPath();
                        ctx.rect(x, y, width, height);
                        if (end != null) {
                            ctx.save();
                            ctx.translate(_sx_end[i], _sy_end[i]);
                            ctx.rotate(_angles[i]);
                            end.clip(ctx, i);
                            ctx.restore();
                        }
                        if (start != null) {
                            ctx.save();
                            ctx.translate(_sx_start[i], _sy_start[i]);
                            ctx.rotate(_angles[i] + Math.PI);
                            start.clip(ctx, i);
                            ctx.restore();
                        }
                        ctx.closePath();
                        ctx.clip();
                    }
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.beginPath();
                    ctx.moveTo(_sx_start[i], _sy_start[i]);
                    ctx.lineTo(_sx_end[i], _sy_end[i]);
                    ctx.stroke();
                    ctx.restore();
                }
            }
        };
        return ArrowView;
    }(data_annotation_1.DataAnnotationView));
    exports.ArrowView = ArrowView;
    ArrowView.__name__ = "ArrowView";
    var Arrow = /** @class */ (function (_super) {
        tslib_1.__extends(Arrow, _super);
        function Arrow(attrs) {
            return _super.call(this, attrs) || this;
        }
        Arrow.init_Arrow = function () {
            this.prototype.default_view = ArrowView;
            this.mixins(property_mixins_1.LineVector);
            this.define(function (_a) {
                var Ref = _a.Ref, Nullable = _a.Nullable;
                return ({
                    x_start: [p.XCoordinateSpec, { field: "x_start" }],
                    y_start: [p.YCoordinateSpec, { field: "y_start" }],
                    start_units: [enums_1.SpatialUnits, "data"],
                    start: [Nullable(Ref(arrow_head_1.ArrowHead)), null],
                    x_end: [p.XCoordinateSpec, { field: "x_end" }],
                    y_end: [p.YCoordinateSpec, { field: "y_end" }],
                    end_units: [enums_1.SpatialUnits, "data"],
                    end: [Nullable(Ref(arrow_head_1.ArrowHead)), function () { return new arrow_head_1.OpenHead(); }],
                });
            });
        };
        return Arrow;
    }(data_annotation_1.DataAnnotation));
    exports.Arrow = Arrow;
    Arrow.__name__ = "Arrow";
    Arrow.init_Arrow();
},
/* models/annotations/data_annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var annotation_1 = require(155) /* ./annotation */;
    var columnar_data_source_1 = require(172) /* ../sources/columnar_data_source */;
    var column_data_source_1 = require(245) /* ../sources/column_data_source */;
    var projections_1 = require(180) /* ../../core/util/projections */;
    var p = tslib_1.__importStar(require(133) /* ../../core/properties */);
    var DataAnnotationView = /** @class */ (function (_super) {
        tslib_1.__extends(DataAnnotationView, _super);
        function DataAnnotationView() {
            var _this = _super.apply(this, tslib_1.__spread(arguments)) || this;
            _this._initial_set_data = false;
            return _this;
        }
        DataAnnotationView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            var update = function () {
                _this.set_data(_this.model.source);
                _this.request_render();
            };
            this.connect(this.model.change, update);
            this.connect(this.model.source.streaming, update);
            this.connect(this.model.source.patching, update);
            this.connect(this.model.source.change, update);
        };
        DataAnnotationView.prototype.set_data = function (source) {
            var e_1, _a, e_2, _b;
            var self = this;
            try {
                for (var _c = tslib_1.__values(this.model), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var prop = _d.value;
                    if (!(prop instanceof p.VectorSpec || prop instanceof p.ScalarSpec))
                        continue;
                    if (prop instanceof p.BaseCoordinateSpec) {
                        var array = prop.array(source);
                        self["_" + prop.attr] = array;
                    }
                    else {
                        var uniform = prop.uniform(source);
                        self["" + prop.attr] = uniform;
                    }
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return))
                        _a.call(_c);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            if (this.plot_model.use_map) {
                if (self._x != null)
                    projections_1.inplace.project_xy(self._x, self._y);
                if (self._xs != null)
                    projections_1.inplace.project_xsys(self._xs, self._ys);
            }
            try {
                for (var _e = tslib_1.__values(this.visuals), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var visual = _f.value;
                    visual.update();
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_f && !_f.done && (_b = _e.return))
                        _b.call(_e);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
        };
        DataAnnotationView.prototype._render = function () {
            if (!this._initial_set_data) {
                this.set_data(this.model.source);
                this._initial_set_data = true;
            }
            this.map_data();
            this.paint(this.layer.ctx);
        };
        return DataAnnotationView;
    }(annotation_1.AnnotationView));
    exports.DataAnnotationView = DataAnnotationView;
    DataAnnotationView.__name__ = "DataAnnotationView";
    var DataAnnotation = /** @class */ (function (_super) {
        tslib_1.__extends(DataAnnotation, _super);
        function DataAnnotation(attrs) {
            return _super.call(this, attrs) || this;
        }
        DataAnnotation.init_DataAnnotation = function () {
            this.define(function (_a) {
                var Ref = _a.Ref;
                return ({
                    source: [Ref(columnar_data_source_1.ColumnarDataSource), function () { return new column_data_source_1.ColumnDataSource(); }],
                });
            });
        };
        return DataAnnotation;
    }(annotation_1.Annotation));
    exports.DataAnnotation = DataAnnotation;
    DataAnnotation.__name__ = "DataAnnotation";
    DataAnnotation.init_DataAnnotation();
},
/* models/sources/columnar_data_source.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var data_source_1 = require(173) /* ./data_source */;
    var signaling_1 = require(130) /* ../../core/signaling */;
    var logging_1 = require(134) /* ../../core/logging */;
    var selection_manager_1 = require(175) /* ../../core/selection_manager */;
    var types_1 = require(123) /* ../../core/util/types */;
    var array_1 = require(124) /* ../../core/util/array */;
    var object_1 = require(128) /* ../../core/util/object */;
    var selection_1 = require(174) /* ../selections/selection */;
    var interaction_policy_1 = require(244) /* ../selections/interaction_policy */;
    var ndarray_1 = require(144) /* ../../core/util/ndarray */;
    var ColumnarDataSource = /** @class */ (function (_super) {
        tslib_1.__extends(ColumnarDataSource, _super);
        function ColumnarDataSource(attrs) {
            return _super.call(this, attrs) || this;
        }
        ColumnarDataSource.prototype.get_array = function (key) {
            var column = this.data[key];
            if (column == null)
                this.data[key] = column = [];
            else if (!types_1.isArray(column))
                this.data[key] = column = Array.from(column);
            return column;
        };
        ColumnarDataSource.init_ColumnarDataSource = function () {
            this.define(function (_a) {
                var Ref = _a.Ref;
                return ({
                    selection_policy: [Ref(interaction_policy_1.SelectionPolicy), function () { return new interaction_policy_1.UnionRenderers(); }],
                });
            });
            this.internal(function (_a) {
                var AnyRef = _a.AnyRef;
                return ({
                    selection_manager: [AnyRef(), function (self) { return new selection_manager_1.SelectionManager({ source: self }); }],
                    inspected: [AnyRef(), function () { return new selection_1.Selection(); }],
                });
            });
        };
        ColumnarDataSource.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._select = new signaling_1.Signal0(this, "select");
            this.inspect = new signaling_1.Signal(this, "inspect");
            this.streaming = new signaling_1.Signal0(this, "streaming");
            this.patching = new signaling_1.Signal(this, "patching");
        };
        ColumnarDataSource.prototype.get_column = function (colname) {
            var column = this.data[colname];
            return column != null ? column : null;
        };
        ColumnarDataSource.prototype.columns = function () {
            // return the column names in this data source
            return object_1.keys(this.data);
        };
        ColumnarDataSource.prototype.get_length = function (soft) {
            if (soft === void 0) {
                soft = true;
            }
            var lengths = array_1.uniq(object_1.values(this.data).map(function (v) { return ndarray_1.is_NDArray(v) ? v.shape[0] : v.length; }));
            switch (lengths.length) {
                case 0: {
                    return null; // XXX: don't guess, treat on case-by-case basis
                }
                case 1: {
                    return lengths[0];
                }
                default: {
                    var msg = "data source has columns of inconsistent lengths";
                    if (soft) {
                        logging_1.logger.warn(msg);
                        return lengths.sort()[0];
                    }
                    else
                        throw new Error(msg);
                }
            }
        };
        Object.defineProperty(ColumnarDataSource.prototype, "length", {
            get: function () {
                var _a;
                return (_a = this.get_length()) !== null && _a !== void 0 ? _a : 0;
            },
            enumerable: false,
            configurable: true
        });
        ColumnarDataSource.prototype.clear = function () {
            var e_1, _a;
            var empty = {};
            try {
                for (var _b = tslib_1.__values(this.columns()), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var col = _c.value;
                    empty[col] = new this.data[col].constructor(0);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            this.data = empty;
        };
        return ColumnarDataSource;
    }(data_source_1.DataSource));
    exports.ColumnarDataSource = ColumnarDataSource;
    ColumnarDataSource.__name__ = "ColumnarDataSource";
    ColumnarDataSource.init_ColumnarDataSource();
},
/* models/sources/data_source.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var model_1 = require(168) /* ../../model */;
    var selection_1 = require(174) /* ../selections/selection */;
    var DataSource = /** @class */ (function (_super) {
        tslib_1.__extends(DataSource, _super);
        function DataSource(attrs) {
            return _super.call(this, attrs) || this;
        }
        DataSource.init_DataSource = function () {
            this.define(function (_a) {
                var Ref = _a.Ref;
                return ({
                    selected: [Ref(selection_1.Selection), function () { return new selection_1.Selection(); }],
                });
            });
        };
        return DataSource;
    }(model_1.Model));
    exports.DataSource = DataSource;
    DataSource.__name__ = "DataSource";
    DataSource.init_DataSource();
},
/* models/selections/selection.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var model_1 = require(168) /* ../../model */;
    var array_1 = require(124) /* ../../core/util/array */;
    var object_1 = require(128) /* ../../core/util/object */;
    var Selection = /** @class */ (function (_super) {
        tslib_1.__extends(Selection, _super);
        function Selection(attrs) {
            return _super.call(this, attrs) || this;
        }
        Selection.prototype.get_view = function () {
            return this.view;
        };
        Selection.init_Selection = function () {
            this.define(function (_a) {
                var Int = _a.Int, Array = _a.Array, Dict = _a.Dict;
                return ({
                    indices: [Array(Int), []],
                    line_indices: [Array(Int), []],
                    multiline_indices: [Dict(Array(Int)), {}],
                });
            });
            this.internal(function (_a) {
                var Int = _a.Int, Array = _a.Array, AnyRef = _a.AnyRef, Struct = _a.Struct, Nullable = _a.Nullable;
                return ({
                    selected_glyphs: [Array(AnyRef()), []],
                    view: [Nullable(AnyRef()), null],
                    // Used internally to support hover tool for now. Python API TBD
                    image_indices: [Array(Struct({ index: Int, dim1: Int, dim2: Int, flat_index: Int })), []],
                });
            });
        };
        Object.defineProperty(Selection.prototype, "selected_glyph", {
            get: function () {
                return this.selected_glyphs.length > 0 ? this.selected_glyphs[0] : null;
            },
            enumerable: false,
            configurable: true
        });
        Selection.prototype.add_to_selected_glyphs = function (glyph) {
            this.selected_glyphs.push(glyph);
        };
        Selection.prototype.update = function (selection, _final, mode) {
            if (_final === void 0) {
                _final = true;
            }
            if (mode === void 0) {
                mode = "replace";
            }
            switch (mode) {
                case "replace": {
                    this.indices = selection.indices;
                    this.line_indices = selection.line_indices;
                    this.selected_glyphs = selection.selected_glyphs;
                    this.view = selection.view;
                    this.multiline_indices = selection.multiline_indices;
                    this.image_indices = selection.image_indices;
                    break;
                }
                case "append": {
                    this.update_through_union(selection);
                    break;
                }
                case "intersect": {
                    this.update_through_intersection(selection);
                    break;
                }
                case "subtract": {
                    this.update_through_subtraction(selection);
                    break;
                }
            }
        };
        Selection.prototype.clear = function () {
            this.indices = [];
            this.line_indices = [];
            this.multiline_indices = {};
            this.view = null;
            this.selected_glyphs = [];
        };
        Selection.prototype.is_empty = function () {
            return this.indices.length == 0 && this.line_indices.length == 0 && this.image_indices.length == 0;
        };
        Selection.prototype.update_through_union = function (other) {
            this.indices = array_1.union(this.indices, other.indices);
            this.selected_glyphs = array_1.union(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = array_1.union(other.line_indices, this.line_indices);
            this.view = other.view;
            this.multiline_indices = object_1.merge(other.multiline_indices, this.multiline_indices);
        };
        Selection.prototype.update_through_intersection = function (other) {
            this.indices = array_1.intersection(this.indices, other.indices);
            // TODO: think through and fix any logic below
            this.selected_glyphs = array_1.union(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = array_1.union(other.line_indices, this.line_indices);
            this.view = other.view;
            this.multiline_indices = object_1.merge(other.multiline_indices, this.multiline_indices);
        };
        Selection.prototype.update_through_subtraction = function (other) {
            this.indices = array_1.difference(this.indices, other.indices);
            // TODO: think through and fix any logic below
            this.selected_glyphs = array_1.union(other.selected_glyphs, this.selected_glyphs);
            this.line_indices = array_1.union(other.line_indices, this.line_indices);
            this.view = other.view;
            this.multiline_indices = object_1.merge(other.multiline_indices, this.multiline_indices);
        };
        return Selection;
    }(model_1.Model));
    exports.Selection = Selection;
    Selection.__name__ = "Selection";
    Selection.init_Selection();
},
/* core/selection_manager.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var has_props_1 = require(129) /* ./has_props */;
    var selection_1 = require(174) /* ../models/selections/selection */;
    var glyph_renderer_1 = require(176) /* ../models/renderers/glyph_renderer */;
    var graph_renderer_1 = require(238) /* ../models/renderers/graph_renderer */;
    var SelectionManager = /** @class */ (function (_super) {
        tslib_1.__extends(SelectionManager, _super);
        function SelectionManager(attrs) {
            var _this = _super.call(this, attrs) || this;
            _this.inspectors = new Map();
            return _this;
        }
        SelectionManager.init_SelectionManager = function () {
            this.internal(function (_a) {
                var AnyRef = _a.AnyRef;
                return ({
                    source: [AnyRef()],
                });
            });
        };
        SelectionManager.prototype.select = function (renderer_views, geometry, final, mode) {
            var e_1, _a, e_2, _b;
            if (mode === void 0) {
                mode = "replace";
            }
            // divide renderers into glyph_renderers or graph_renderers
            var glyph_renderer_views = [];
            var graph_renderer_views = [];
            try {
                for (var renderer_views_1 = tslib_1.__values(renderer_views), renderer_views_1_1 = renderer_views_1.next(); !renderer_views_1_1.done; renderer_views_1_1 = renderer_views_1.next()) {
                    var r = renderer_views_1_1.value;
                    if (r instanceof glyph_renderer_1.GlyphRendererView)
                        glyph_renderer_views.push(r);
                    else if (r instanceof graph_renderer_1.GraphRendererView)
                        graph_renderer_views.push(r);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (renderer_views_1_1 && !renderer_views_1_1.done && (_a = renderer_views_1.return))
                        _a.call(renderer_views_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            var did_hit = false;
            try {
                // graph renderer case
                for (var graph_renderer_views_1 = tslib_1.__values(graph_renderer_views), graph_renderer_views_1_1 = graph_renderer_views_1.next(); !graph_renderer_views_1_1.done; graph_renderer_views_1_1 = graph_renderer_views_1.next()) {
                    var r = graph_renderer_views_1_1.value;
                    var hit_test_result = r.model.selection_policy.hit_test(geometry, r);
                    did_hit = did_hit || r.model.selection_policy.do_selection(hit_test_result, r.model, final, mode);
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (graph_renderer_views_1_1 && !graph_renderer_views_1_1.done && (_b = graph_renderer_views_1.return))
                        _b.call(graph_renderer_views_1);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            // glyph renderers
            if (glyph_renderer_views.length > 0) {
                var hit_test_result = this.source.selection_policy.hit_test(geometry, glyph_renderer_views);
                did_hit = did_hit || this.source.selection_policy.do_selection(hit_test_result, this.source, final, mode);
            }
            return did_hit;
        };
        SelectionManager.prototype.inspect = function (renderer_view, geometry) {
            var did_hit = false;
            if (renderer_view instanceof glyph_renderer_1.GlyphRendererView) {
                var hit_test_result = renderer_view.hit_test(geometry);
                if (hit_test_result != null) {
                    did_hit = !hit_test_result.is_empty();
                    var inspection = this.get_or_create_inspector(renderer_view.model);
                    inspection.update(hit_test_result, true, "replace");
                    this.source.setv({ inspected: inspection }, { silent: true });
                    this.source.inspect.emit([renderer_view.model, { geometry: geometry }]);
                }
            }
            else if (renderer_view instanceof graph_renderer_1.GraphRendererView) {
                var hit_test_result = renderer_view.model.inspection_policy.hit_test(geometry, renderer_view);
                did_hit = did_hit || renderer_view.model.inspection_policy.do_inspection(hit_test_result, geometry, renderer_view, false, "replace");
            }
            return did_hit;
        };
        SelectionManager.prototype.clear = function (rview) {
            this.source.selected.clear();
            if (rview != null)
                this.get_or_create_inspector(rview.model).clear();
        };
        SelectionManager.prototype.get_or_create_inspector = function (renderer) {
            var selection = this.inspectors.get(renderer);
            if (selection == null) {
                selection = new selection_1.Selection();
                this.inspectors.set(renderer, selection);
            }
            return selection;
        };
        return SelectionManager;
    }(has_props_1.HasProps));
    exports.SelectionManager = SelectionManager;
    SelectionManager.__name__ = "SelectionManager";
    SelectionManager.init_SelectionManager();
},
/* models/renderers/glyph_renderer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var data_renderer_1 = require(177) /* ./data_renderer */;
    var line_1 = require(178) /* ../glyphs/line */;
    var patch_1 = require(231) /* ../glyphs/patch */;
    var harea_1 = require(232) /* ../glyphs/harea */;
    var varea_1 = require(234) /* ../glyphs/varea */;
    var glyph_1 = require(213) /* ../glyphs/glyph */;
    var columnar_data_source_1 = require(172) /* ../sources/columnar_data_source */;
    var cds_view_1 = require(235) /* ../sources/cds_view */;
    var types_1 = require(139) /* ../../core/types */;
    var arrayable_1 = require(127) /* ../../core/util/arrayable */;
    var array_1 = require(124) /* ../../core/util/array */;
    var object_1 = require(128) /* ../../core/util/object */;
    var build_views_1 = require(237) /* ../../core/build_views */;
    var factor_range_1 = require(219) /* ../ranges/factor_range */;
    var selection_defaults = {
        fill: {},
        line: {},
    };
    var decimated_defaults = {
        fill: { fill_alpha: 0.3, fill_color: "grey" },
        line: { line_alpha: 0.3, line_color: "grey" },
    };
    var nonselection_defaults = {
        fill: { fill_alpha: 0.2 },
        line: {},
    };
    var GlyphRendererView = /** @class */ (function (_super) {
        tslib_1.__extends(GlyphRendererView, _super);
        function GlyphRendererView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(GlyphRendererView.prototype, "glyph_view", {
            get: function () {
                return this.glyph;
            },
            enumerable: false,
            configurable: true
        });
        GlyphRendererView.prototype.lazy_initialize = function () {
            var _a, _b;
            return tslib_1.__awaiter(this, void 0, void 0, function () {
                function mk_glyph(defaults) {
                    var attrs = object_1.clone(glyph_attrs);
                    if (has_fill)
                        object_1.extend(attrs, defaults.fill);
                    if (has_line)
                        object_1.extend(attrs, defaults.line);
                    return new base_glyph.constructor(attrs);
                }
                var base_glyph, _c, has_fill, has_line, glyph_attrs, selection_glyph, _d, nonselection_glyph, _e, hover_glyph, _f, muted_glyph, _g, decimated_glyph, _h;
                return tslib_1.__generator(this, function (_j) {
                    switch (_j.label) {
                        case 0: return [4 /*yield*/, _super.prototype.lazy_initialize.call(this)];
                        case 1:
                            _j.sent();
                            base_glyph = this.model.glyph;
                            _c = this;
                            return [4 /*yield*/, this.build_glyph_view(base_glyph)];
                        case 2:
                            _c.glyph = _j.sent();
                            has_fill = "fill" in this.glyph.visuals;
                            has_line = "line" in this.glyph.visuals;
                            glyph_attrs = tslib_1.__assign({}, base_glyph.attributes);
                            delete glyph_attrs.id;
                            selection_glyph = this.model.selection_glyph;
                            if (selection_glyph == null)
                                selection_glyph = mk_glyph({ fill: {}, line: {} });
                            else if (selection_glyph == "auto")
                                selection_glyph = mk_glyph(selection_defaults);
                            _d = this;
                            return [4 /*yield*/, this.build_glyph_view(selection_glyph)];
                        case 3:
                            _d.selection_glyph = _j.sent();
                            nonselection_glyph = this.model.nonselection_glyph;
                            if (nonselection_glyph == null)
                                nonselection_glyph = mk_glyph({ fill: {}, line: {} });
                            else if (nonselection_glyph == "auto")
                                nonselection_glyph = mk_glyph(nonselection_defaults);
                            _e = this;
                            return [4 /*yield*/, this.build_glyph_view(nonselection_glyph)];
                        case 4:
                            _e.nonselection_glyph = _j.sent();
                            hover_glyph = this.model.hover_glyph;
                            if (!(hover_glyph != null))
                                return [3 /*break*/, 6];
                            _f = this;
                            return [4 /*yield*/, this.build_glyph_view(hover_glyph)];
                        case 5:
                            _f.hover_glyph = _j.sent();
                            _j.label = 6;
                        case 6:
                            muted_glyph = this.model.muted_glyph;
                            if (!(muted_glyph != null))
                                return [3 /*break*/, 8];
                            _g = this;
                            return [4 /*yield*/, this.build_glyph_view(muted_glyph)];
                        case 7:
                            _g.muted_glyph = _j.sent();
                            _j.label = 8;
                        case 8:
                            decimated_glyph = mk_glyph(decimated_defaults);
                            _h = this;
                            return [4 /*yield*/, this.build_glyph_view(decimated_glyph)];
                        case 9:
                            _h.decimated_glyph = _j.sent();
                            this.selection_glyph.set_base(this.glyph);
                            this.nonselection_glyph.set_base(this.glyph);
                            (_a = this.hover_glyph) === null || _a === void 0 ? void 0 : _a.set_base(this.glyph);
                            (_b = this.muted_glyph) === null || _b === void 0 ? void 0 : _b.set_base(this.glyph);
                            this.decimated_glyph.set_base(this.glyph);
                            this.set_data();
                            return [2 /*return*/];
                    }
                });
            });
        };
        GlyphRendererView.prototype.build_glyph_view = function (glyph) {
            return tslib_1.__awaiter(this, void 0, void 0, function () {
                return tslib_1.__generator(this, function (_a) {
                    return [2 /*return*/, build_views_1.build_view(glyph, { parent: this })];
                });
            });
        };
        GlyphRendererView.prototype.remove = function () {
            var _a, _b;
            this.glyph.remove();
            this.selection_glyph.remove();
            this.nonselection_glyph.remove();
            (_a = this.hover_glyph) === null || _a === void 0 ? void 0 : _a.remove();
            (_b = this.muted_glyph) === null || _b === void 0 ? void 0 : _b.remove();
            this.decimated_glyph.remove();
            _super.prototype.remove.call(this);
        };
        GlyphRendererView.prototype.connect_signals = function () {
            var e_1, _a, e_2, _b;
            var _this = this;
            _super.prototype.connect_signals.call(this);
            var render = function () { return _this.request_render(); };
            var update = function () { return _this.update_data(); };
            this.connect(this.model.change, render);
            this.connect(this.glyph.model.change, update);
            this.connect(this.selection_glyph.model.change, update);
            this.connect(this.nonselection_glyph.model.change, update);
            if (this.hover_glyph != null)
                this.connect(this.hover_glyph.model.change, update);
            if (this.muted_glyph != null)
                this.connect(this.muted_glyph.model.change, update);
            this.connect(this.decimated_glyph.model.change, update);
            this.connect(this.model.data_source.change, update);
            this.connect(this.model.data_source.streaming, update);
            this.connect(this.model.data_source.patching, function (indices) { return _this.update_data(indices); });
            this.connect(this.model.data_source.selected.change, render);
            this.connect(this.model.data_source._select, render);
            if (this.hover_glyph != null)
                this.connect(this.model.data_source.inspect, render);
            this.connect(this.model.properties.view.change, update);
            this.connect(this.model.view.properties.indices.change, update);
            this.connect(this.model.view.properties.masked.change, function () { return _this.set_visuals(); });
            this.connect(this.model.properties.visible.change, function () { return _this.plot_view.invalidate_dataranges = true; });
            var _c = this.plot_view.frame, x_ranges = _c.x_ranges, y_ranges = _c.y_ranges;
            try {
                for (var x_ranges_1 = tslib_1.__values(x_ranges), x_ranges_1_1 = x_ranges_1.next(); !x_ranges_1_1.done; x_ranges_1_1 = x_ranges_1.next()) {
                    var _d = tslib_1.__read(x_ranges_1_1.value, 2), range = _d[1];
                    if (range instanceof factor_range_1.FactorRange)
                        this.connect(range.change, update);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (x_ranges_1_1 && !x_ranges_1_1.done && (_a = x_ranges_1.return))
                        _a.call(x_ranges_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            try {
                for (var y_ranges_1 = tslib_1.__values(y_ranges), y_ranges_1_1 = y_ranges_1.next(); !y_ranges_1_1.done; y_ranges_1_1 = y_ranges_1.next()) {
                    var _e = tslib_1.__read(y_ranges_1_1.value, 2), range = _e[1];
                    if (range instanceof factor_range_1.FactorRange)
                        this.connect(range.change, update);
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (y_ranges_1_1 && !y_ranges_1_1.done && (_b = y_ranges_1.return))
                        _b.call(y_ranges_1);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            var _f = this.model.glyph, transformchange = _f.transformchange, exprchange = _f.exprchange;
            this.connect(transformchange, update);
            this.connect(exprchange, update);
        };
        GlyphRendererView.prototype._update_masked_indices = function () {
            var masked = this.glyph.mask_data();
            this.model.view.masked = masked;
            return masked;
        };
        GlyphRendererView.prototype.update_data = function (indices) {
            this.set_data(indices);
            this.request_render();
        };
        // in case of partial updates like patching, the list of indices that actually
        // changed may be passed as the "indices" parameter to afford any optional optimizations
        GlyphRendererView.prototype.set_data = function (indices) {
            var source = this.model.data_source;
            this.all_indices = this.model.view.indices;
            var all_indices = this.all_indices;
            this.glyph.set_data(source, all_indices, indices);
            this.set_visuals();
            this._update_masked_indices();
            var lod_factor = this.plot_model.lod_factor;
            var n = this.all_indices.count;
            this.decimated = new types_1.Indices(n);
            for (var i = 0; i < n; i += lod_factor) {
                this.decimated.set(i);
            }
            this.plot_view.invalidate_dataranges = true;
        };
        GlyphRendererView.prototype.set_visuals = function () {
            var _a, _b, _c, _d;
            var source = this.model.data_source;
            var all_indices = this.all_indices;
            this.glyph.set_visuals(source, all_indices);
            this.decimated_glyph.set_visuals(source, all_indices);
            (_a = this.selection_glyph) === null || _a === void 0 ? void 0 : _a.set_visuals(source, all_indices);
            (_b = this.nonselection_glyph) === null || _b === void 0 ? void 0 : _b.set_visuals(source, all_indices);
            (_c = this.hover_glyph) === null || _c === void 0 ? void 0 : _c.set_visuals(source, all_indices);
            (_d = this.muted_glyph) === null || _d === void 0 ? void 0 : _d.set_visuals(source, all_indices);
        };
        Object.defineProperty(GlyphRendererView.prototype, "has_webgl", {
            get: function () {
                return this.glyph.has_webgl;
            },
            enumerable: false,
            configurable: true
        });
        GlyphRendererView.prototype._render = function () {
            var e_3, _a, e_4, _b, e_5, _c, e_6, _d;
            var _this = this;
            var glsupport = this.has_webgl;
            this.glyph.map_data();
            // all_indices is in full data space, indices is converted to subset space by mask_data (that may use the spatial index)
            var all_indices = tslib_1.__spread(this.all_indices);
            var indices = tslib_1.__spread(this._update_masked_indices());
            var ctx = this.layer.ctx;
            ctx.save();
            // selected is in full set space
            var selected = this.model.data_source.selected;
            var selected_full_indices;
            if (!selected || selected.is_empty())
                selected_full_indices = [];
            else {
                if (this.glyph instanceof line_1.LineView && selected.selected_glyph === this.glyph.model)
                    selected_full_indices = this.model.view.convert_indices_from_subset(indices);
                else
                    selected_full_indices = selected.indices;
            }
            // inspected is in full set space
            var inspected = this.model.data_source.inspected;
            var inspected_full_indices = new Set((function () {
                if (!inspected || inspected.is_empty())
                    return [];
                else {
                    if (inspected.selected_glyph)
                        return _this.model.view.convert_indices_from_subset(indices);
                    else if (inspected.indices.length > 0)
                        return inspected.indices;
                    else {
                        // TODO: return inspected.multiline_indices.keys()
                        return Object.keys(inspected.multiline_indices).map(function (i) { return parseInt(i); });
                    }
                }
            })());
            // inspected is transformed to subset space
            var inspected_subset_indices = arrayable_1.filter(indices, function (i) { return inspected_full_indices.has(all_indices[i]); });
            var lod_threshold = this.plot_model.lod_threshold;
            var glyph;
            var nonselection_glyph;
            var selection_glyph;
            if ((this.model.document != null ? this.model.document.interactive_duration() > 0 : false)
                && !glsupport && lod_threshold != null && all_indices.length > lod_threshold) {
                // Render decimated during interaction if too many elements and not using GL
                indices = tslib_1.__spread(this.decimated);
                glyph = this.decimated_glyph;
                nonselection_glyph = this.decimated_glyph;
                selection_glyph = this.selection_glyph;
            }
            else {
                glyph = this.model.muted && this.muted_glyph != null ? this.muted_glyph : this.glyph;
                nonselection_glyph = this.nonselection_glyph;
                selection_glyph = this.selection_glyph;
            }
            if (this.hover_glyph != null && inspected_subset_indices.length)
                indices = array_1.difference(indices, inspected_subset_indices);
            // Render with no selection
            if (!selected_full_indices.length) {
                if (this.glyph instanceof line_1.LineView) {
                    if (this.hover_glyph && inspected_subset_indices.length)
                        this.hover_glyph.render(ctx, this.model.view.convert_indices_from_subset(inspected_subset_indices));
                    else
                        glyph.render(ctx, all_indices);
                }
                else if (this.glyph instanceof patch_1.PatchView || this.glyph instanceof harea_1.HAreaView || this.glyph instanceof varea_1.VAreaView) {
                    if (inspected.selected_glyphs.length == 0 || this.hover_glyph == null) {
                        glyph.render(ctx, all_indices);
                    }
                    else {
                        try {
                            for (var _e = tslib_1.__values(inspected.selected_glyphs), _f = _e.next(); !_f.done; _f = _e.next()) {
                                var sglyph = _f.value;
                                if (sglyph == this.glyph.model)
                                    this.hover_glyph.render(ctx, all_indices);
                            }
                        }
                        catch (e_3_1) {
                            e_3 = { error: e_3_1 };
                        }
                        finally {
                            try {
                                if (_f && !_f.done && (_a = _e.return))
                                    _a.call(_e);
                            }
                            finally {
                                if (e_3)
                                    throw e_3.error;
                            }
                        }
                    }
                }
                else {
                    glyph.render(ctx, indices);
                    if (this.hover_glyph && inspected_subset_indices.length)
                        this.hover_glyph.render(ctx, inspected_subset_indices);
                }
                // Render with selection
            }
            else {
                // reset the selection mask
                var selected_mask = {};
                try {
                    for (var selected_full_indices_1 = tslib_1.__values(selected_full_indices), selected_full_indices_1_1 = selected_full_indices_1.next(); !selected_full_indices_1_1.done; selected_full_indices_1_1 = selected_full_indices_1.next()) {
                        var i = selected_full_indices_1_1.value;
                        selected_mask[i] = true;
                    }
                }
                catch (e_4_1) {
                    e_4 = { error: e_4_1 };
                }
                finally {
                    try {
                        if (selected_full_indices_1_1 && !selected_full_indices_1_1.done && (_b = selected_full_indices_1.return))
                            _b.call(selected_full_indices_1);
                    }
                    finally {
                        if (e_4)
                            throw e_4.error;
                    }
                }
                // intersect/different selection with render mask
                var selected_subset_indices = new Array();
                var nonselected_subset_indices = new Array();
                // now, selected is changed to subset space, except for Line glyph
                if (this.glyph instanceof line_1.LineView) {
                    try {
                        for (var all_indices_1 = tslib_1.__values(all_indices), all_indices_1_1 = all_indices_1.next(); !all_indices_1_1.done; all_indices_1_1 = all_indices_1.next()) {
                            var i = all_indices_1_1.value;
                            if (selected_mask[i] != null)
                                selected_subset_indices.push(i);
                            else
                                nonselected_subset_indices.push(i);
                        }
                    }
                    catch (e_5_1) {
                        e_5 = { error: e_5_1 };
                    }
                    finally {
                        try {
                            if (all_indices_1_1 && !all_indices_1_1.done && (_c = all_indices_1.return))
                                _c.call(all_indices_1);
                        }
                        finally {
                            if (e_5)
                                throw e_5.error;
                        }
                    }
                }
                else {
                    try {
                        for (var indices_1 = tslib_1.__values(indices), indices_1_1 = indices_1.next(); !indices_1_1.done; indices_1_1 = indices_1.next()) {
                            var i = indices_1_1.value;
                            if (selected_mask[all_indices[i]] != null)
                                selected_subset_indices.push(i);
                            else
                                nonselected_subset_indices.push(i);
                        }
                    }
                    catch (e_6_1) {
                        e_6 = { error: e_6_1 };
                    }
                    finally {
                        try {
                            if (indices_1_1 && !indices_1_1.done && (_d = indices_1.return))
                                _d.call(indices_1);
                        }
                        finally {
                            if (e_6)
                                throw e_6.error;
                        }
                    }
                }
                nonselection_glyph.render(ctx, nonselected_subset_indices);
                selection_glyph.render(ctx, selected_subset_indices);
                if (this.hover_glyph != null) {
                    if (this.glyph instanceof line_1.LineView)
                        this.hover_glyph.render(ctx, this.model.view.convert_indices_from_subset(inspected_subset_indices));
                    else
                        this.hover_glyph.render(ctx, inspected_subset_indices);
                }
            }
            ctx.restore();
        };
        GlyphRendererView.prototype.draw_legend = function (ctx, x0, x1, y0, y1, field, label, index) {
            if (this.glyph.data_size == 0)
                return;
            if (index == null)
                index = this.model.get_reference_point(field, label);
            this.glyph.draw_legend_for_index(ctx, { x0: x0, x1: x1, y0: y0, y1: y1 }, index);
        };
        GlyphRendererView.prototype.hit_test = function (geometry) {
            if (!this.model.visible)
                return null;
            var hit_test_result = this.glyph.hit_test(geometry);
            // glyphs that don't have hit-testing implemented will return null
            if (hit_test_result == null)
                return null;
            return this.model.view.convert_selection_from_subset(hit_test_result);
        };
        return GlyphRendererView;
    }(data_renderer_1.DataRendererView));
    exports.GlyphRendererView = GlyphRendererView;
    GlyphRendererView.__name__ = "GlyphRendererView";
    var GlyphRenderer = /** @class */ (function (_super) {
        tslib_1.__extends(GlyphRenderer, _super);
        function GlyphRenderer(attrs) {
            return _super.call(this, attrs) || this;
        }
        GlyphRenderer.init_GlyphRenderer = function () {
            this.prototype.default_view = GlyphRendererView;
            this.define(function (_a) {
                var Boolean = _a.Boolean, Auto = _a.Auto, Or = _a.Or, Ref = _a.Ref, Null = _a.Null, Nullable = _a.Nullable;
                return ({
                    data_source: [Ref(columnar_data_source_1.ColumnarDataSource)],
                    view: [Ref(cds_view_1.CDSView), function (self) { return new cds_view_1.CDSView({ source: self.data_source }); }],
                    glyph: [Ref(glyph_1.Glyph)],
                    hover_glyph: [Nullable(Ref(glyph_1.Glyph)), null],
                    nonselection_glyph: [Or(Ref(glyph_1.Glyph), Auto, Null), "auto"],
                    selection_glyph: [Or(Ref(glyph_1.Glyph), Auto, Null), "auto"],
                    muted_glyph: [Nullable(Ref(glyph_1.Glyph)), null],
                    muted: [Boolean, false],
                });
            });
        };
        GlyphRenderer.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            if (this.view.source != this.data_source) {
                this.view.source = this.data_source;
                this.view.compute_indices();
            }
        };
        GlyphRenderer.prototype.get_reference_point = function (field, value) {
            var e_7, _a;
            if (field != null) {
                var data = this.data_source.get_column(field);
                if (data != null) {
                    try {
                        for (var _b = tslib_1.__values(Object.entries(this.view.indices_map)), _c = _b.next(); !_c.done; _c = _b.next()) {
                            var _d = tslib_1.__read(_c.value, 2), key = _d[0], index = _d[1];
                            if (data[parseInt(key)] == value)
                                return index;
                        }
                    }
                    catch (e_7_1) {
                        e_7 = { error: e_7_1 };
                    }
                    finally {
                        try {
                            if (_c && !_c.done && (_a = _b.return))
                                _a.call(_b);
                        }
                        finally {
                            if (e_7)
                                throw e_7.error;
                        }
                    }
                }
            }
            return 0;
        };
        GlyphRenderer.prototype.get_selection_manager = function () {
            return this.data_source.selection_manager;
        };
        return GlyphRenderer;
    }(data_renderer_1.DataRenderer));
    exports.GlyphRenderer = GlyphRenderer;
    GlyphRenderer.__name__ = "GlyphRenderer";
    GlyphRenderer.init_GlyphRenderer();
},
/* models/renderers/data_renderer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var renderer_1 = require(156) /* ./renderer */;
    var DataRendererView = /** @class */ (function (_super) {
        tslib_1.__extends(DataRendererView, _super);
        function DataRendererView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(DataRendererView.prototype, "xscale", {
            get: function () {
                return this.coordinates.x_scale;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(DataRendererView.prototype, "yscale", {
            get: function () {
                return this.coordinates.y_scale;
            },
            enumerable: false,
            configurable: true
        });
        return DataRendererView;
    }(renderer_1.RendererView));
    exports.DataRendererView = DataRendererView;
    DataRendererView.__name__ = "DataRendererView";
    var DataRenderer = /** @class */ (function (_super) {
        tslib_1.__extends(DataRenderer, _super);
        function DataRenderer(attrs) {
            return _super.call(this, attrs) || this;
        }
        DataRenderer.init_DataRenderer = function () {
            this.override({
                level: 'glyph',
            });
        };
        Object.defineProperty(DataRenderer.prototype, "selection_manager", {
            get: function () {
                return this.get_selection_manager();
            },
            enumerable: false,
            configurable: true
        });
        return DataRenderer;
    }(renderer_1.Renderer));
    exports.DataRenderer = DataRenderer;
    DataRenderer.__name__ = "DataRenderer";
    DataRenderer.init_DataRenderer();
},
/* models/glyphs/line.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var xy_glyph_1 = require(179) /* ./xy_glyph */;
    var utils_1 = require(221) /* ./utils */;
    var line_1 = require(223) /* ./webgl/line */;
    var mixins = tslib_1.__importStar(require(163) /* ../../core/property_mixins */);
    var hittest = tslib_1.__importStar(require(222) /* ../../core/hittest */);
    var selection_1 = require(174) /* ../selections/selection */;
    var LineView = /** @class */ (function (_super) {
        tslib_1.__extends(LineView, _super);
        function LineView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        LineView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            var webgl = this.renderer.plot_view.canvas_view.webgl;
            if (webgl != null) {
                this.glglyph = new line_1.LineGL(webgl.gl, this);
            }
        };
        LineView.prototype._render = function (ctx, indices, data) {
            var e_1, _a;
            var _b = data !== null && data !== void 0 ? data : this, sx = _b.sx, sy = _b.sy;
            var move = true;
            ctx.beginPath();
            try {
                for (var indices_1 = tslib_1.__values(indices), indices_1_1 = indices_1.next(); !indices_1_1.done; indices_1_1 = indices_1.next()) {
                    var i = indices_1_1.value;
                    var sx_i = sx[i];
                    var sy_i = sy[i];
                    if (!isFinite(sx_i + sy_i))
                        move = true;
                    else {
                        if (move) {
                            ctx.moveTo(sx_i, sy_i);
                            move = false;
                        }
                        else
                            ctx.lineTo(sx_i, sy_i);
                    }
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (indices_1_1 && !indices_1_1.done && (_a = indices_1.return))
                        _a.call(indices_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            this.visuals.line.set_value(ctx);
            ctx.stroke();
        };
        LineView.prototype._hit_point = function (geometry) {
            /* Check if the point geometry hits this line glyph and return an object
            that describes the hit result:
              Args:
                * geometry (object): object with the following keys
                  * sx (float): screen x coordinate of the point
                  * sy (float): screen y coordinate of the point
                  * type (str): type of geometry (in this case it's a point)
            */
            var result = new selection_1.Selection();
            var point = { x: geometry.sx, y: geometry.sy };
            var shortest = 9999;
            var threshold = Math.max(2, this.line_width.value / 2);
            for (var i = 0, end = this.sx.length - 1; i < end; i++) {
                var p0 = { x: this.sx[i], y: this.sy[i] };
                var p1 = { x: this.sx[i + 1], y: this.sy[i + 1] };
                var dist = hittest.dist_to_segment(point, p0, p1);
                if (dist < threshold && dist < shortest) {
                    shortest = dist;
                    result.add_to_selected_glyphs(this.model);
                    result.view = this;
                    result.line_indices = [i];
                }
            }
            return result;
        };
        LineView.prototype._hit_span = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            var result = new selection_1.Selection();
            var val;
            var values;
            if (geometry.direction == 'v') {
                val = this.renderer.yscale.invert(sy);
                values = this._y;
            }
            else {
                val = this.renderer.xscale.invert(sx);
                values = this._x;
            }
            for (var i = 0, end = values.length - 1; i < end; i++) {
                if ((values[i] <= val && val <= values[i + 1]) || (values[i + 1] <= val && val <= values[i])) {
                    result.add_to_selected_glyphs(this.model);
                    result.view = this;
                    result.line_indices.push(i);
                }
            }
            return result;
        };
        LineView.prototype.get_interpolation_hit = function (i, geometry) {
            var _a = tslib_1.__read([this._x[i], this._y[i], this._x[i + 1], this._y[i + 1]], 4), x2 = _a[0], y2 = _a[1], x3 = _a[2], y3 = _a[3];
            return utils_1.line_interpolation(this.renderer, geometry, x2, y2, x3, y3);
        };
        LineView.prototype.draw_legend_for_index = function (ctx, bbox, _index) {
            utils_1.generic_line_scalar_legend(this.visuals, ctx, bbox);
        };
        return LineView;
    }(xy_glyph_1.XYGlyphView));
    exports.LineView = LineView;
    LineView.__name__ = "LineView";
    var Line = /** @class */ (function (_super) {
        tslib_1.__extends(Line, _super);
        function Line(attrs) {
            return _super.call(this, attrs) || this;
        }
        Line.init_Line = function () {
            this.prototype.default_view = LineView;
            this.mixins(mixins.LineScalar);
        };
        return Line;
    }(xy_glyph_1.XYGlyph));
    exports.Line = Line;
    Line.__name__ = "Line";
    Line.init_Line();
},
/* models/glyphs/xy_glyph.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var projections_1 = require(180) /* ../../core/util/projections */;
    var p = tslib_1.__importStar(require(133) /* ../../core/properties */);
    var glyph_1 = require(213) /* ./glyph */;
    var XYGlyphView = /** @class */ (function (_super) {
        tslib_1.__extends(XYGlyphView, _super);
        function XYGlyphView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        XYGlyphView.prototype._project_data = function () {
            projections_1.inplace.project_xy(this._x, this._y);
        };
        XYGlyphView.prototype._index_data = function (index) {
            var _a = this, _x = _a._x, _y = _a._y, data_size = _a.data_size;
            for (var i = 0; i < data_size; i++) {
                var x = _x[i];
                var y = _y[i];
                if (isNaN(x + y) || !isFinite(x + y))
                    index.add_empty();
                else
                    index.add(x, y, x, y);
            }
        };
        XYGlyphView.prototype.scenterxy = function (i) {
            return [this.sx[i], this.sy[i]];
        };
        return XYGlyphView;
    }(glyph_1.GlyphView));
    exports.XYGlyphView = XYGlyphView;
    XYGlyphView.__name__ = "XYGlyphView";
    var XYGlyph = /** @class */ (function (_super) {
        tslib_1.__extends(XYGlyph, _super);
        function XYGlyph(attrs) {
            return _super.call(this, attrs) || this;
        }
        XYGlyph.init_XYGlyph = function () {
            this.define(function (_a) {
                return ({
                    x: [p.XCoordinateSpec, { field: "x" }],
                    y: [p.YCoordinateSpec, { field: "y" }],
                });
            });
        };
        return XYGlyph;
    }(glyph_1.Glyph));
    exports.XYGlyph = XYGlyph;
    XYGlyph.__name__ = "XYGlyph";
    XYGlyph.init_XYGlyph();
},
/* core/util/projections.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var core_1 = tslib_1.__importDefault(require(181) /* proj4/lib/core */);
    var Proj_1 = tslib_1.__importDefault(require(182) /* proj4/lib/Proj */);
    var types_1 = require(139) /* ../types */;
    var mercator = new Proj_1.default('GOOGLE');
    var wgs84 = new Proj_1.default('WGS84');
    var _wgs84_mercator = core_1.default(wgs84, mercator);
    exports.wgs84_mercator = {
        compute: function (x, y) {
            if (isFinite(x) && isFinite(y))
                return _wgs84_mercator.forward([x, y]);
            else
                return [NaN, NaN];
        },
        invert: function (merc_x, merc_y) {
            if (isFinite(merc_x) && isFinite(merc_y))
                return _wgs84_mercator.inverse([merc_x, merc_y]);
            else
                return [NaN, NaN];
        },
    };
    var mercator_bounds = {
        lon: [-20026376.39, 20026376.39],
        lat: [-20048966.10, 20048966.10],
    };
    var latlon_bounds = {
        lon: [-180, 180],
        lat: [-85.06, 85.06],
    };
    var min = Math.min, max = Math.max;
    function clip_mercator(low, high, dimension) {
        var _a = tslib_1.__read(mercator_bounds[dimension], 2), vmin = _a[0], vmax = _a[1];
        return [max(low, vmin), min(high, vmax)];
    }
    exports.clip_mercator = clip_mercator;
    function in_bounds(value, dimension) {
        var _a = tslib_1.__read(latlon_bounds[dimension], 2), min = _a[0], max = _a[1];
        return min < value && value < max;
    }
    exports.in_bounds = in_bounds;
    (function (inplace) {
        function project_xy(x, y, merc_x, merc_y) {
            var n = min(x.length, y.length);
            merc_x = merc_x !== null && merc_x !== void 0 ? merc_x : x;
            merc_y = merc_y !== null && merc_y !== void 0 ? merc_y : y;
            for (var i = 0; i < n; i++) {
                var xi = x[i];
                var yi = y[i];
                var _a = tslib_1.__read(exports.wgs84_mercator.compute(xi, yi), 2), merc_xi = _a[0], merc_yi = _a[1];
                merc_x[i] = merc_xi;
                merc_y[i] = merc_yi;
            }
        }
        inplace.project_xy = project_xy;
        function project_xsys(xs, ys, merc_xs, merc_ys) {
            var n = min(xs.length, ys.length);
            merc_xs = merc_xs !== null && merc_xs !== void 0 ? merc_xs : xs;
            merc_ys = merc_ys !== null && merc_ys !== void 0 ? merc_ys : ys;
            for (var i = 0; i < n; i++) {
                project_xy(xs[i], ys[i], merc_xs[i], merc_ys[i]);
            }
        }
        inplace.project_xsys = project_xsys;
    })(exports.inplace || (exports.inplace = {}));
    function project_xy(x, y) {
        var n = min(x.length, y.length);
        var ArrayType = types_1.infer_type(x, y);
        var merc_x = new ArrayType(n);
        var merc_y = new ArrayType(n);
        exports.inplace.project_xy(x, y, merc_x, merc_y);
        return [merc_x, merc_y];
    }
    exports.project_xy = project_xy;
    function project_xsys(xs, ys) {
        var n = min(xs.length, ys.length);
        var merc_xs = new Array(n);
        var merc_ys = new Array(n);
        for (var i = 0; i < n; i++) {
            var _a = tslib_1.__read(project_xy(xs[i], ys[i]), 2), merc_x = _a[0], merc_y = _a[1];
            merc_xs[i] = merc_x;
            merc_ys[i] = merc_y;
        }
        return [merc_xs, merc_ys];
    }
    exports.project_xsys = project_xsys;
},
/* proj4/lib/core.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var Proj_1 = tslib_1.__importDefault(require(182) /* ./Proj */);
    var transform_1 = tslib_1.__importDefault(require(207) /* ./transform */);
    var wgs84 = Proj_1.default('WGS84');
    function transformer(from, to, coords) {
        var transformedArray, out, keys;
        if (Array.isArray(coords)) {
            transformedArray = transform_1.default(from, to, coords) || { x: NaN, y: NaN };
            if (coords.length > 2) {
                if ((typeof from.name !== 'undefined' && from.name === 'geocent') || (typeof to.name !== 'undefined' && to.name === 'geocent')) {
                    if (typeof transformedArray.z === 'number') {
                        return [transformedArray.x, transformedArray.y, transformedArray.z].concat(coords.splice(3));
                    }
                    else {
                        return [transformedArray.x, transformedArray.y, coords[2]].concat(coords.splice(3));
                    }
                }
                else {
                    return [transformedArray.x, transformedArray.y].concat(coords.splice(2));
                }
            }
            else {
                return [transformedArray.x, transformedArray.y];
            }
        }
        else {
            out = transform_1.default(from, to, coords);
            keys = Object.keys(coords);
            if (keys.length === 2) {
                return out;
            }
            keys.forEach(function (key) {
                if ((typeof from.name !== 'undefined' && from.name === 'geocent') || (typeof to.name !== 'undefined' && to.name === 'geocent')) {
                    if (key === 'x' || key === 'y' || key === 'z') {
                        return;
                    }
                }
                else {
                    if (key === 'x' || key === 'y') {
                        return;
                    }
                }
                out[key] = coords[key];
            });
            return out;
        }
    }
    function checkProj(item) {
        if (item instanceof Proj_1.default) {
            return item;
        }
        if (item.oProj) {
            return item.oProj;
        }
        return Proj_1.default(item);
    }
    function proj4(fromProj, toProj, coord) {
        fromProj = checkProj(fromProj);
        var single = false;
        var obj;
        if (typeof toProj === 'undefined') {
            toProj = fromProj;
            fromProj = wgs84;
            single = true;
        }
        else if (typeof toProj.x !== 'undefined' || Array.isArray(toProj)) {
            coord = toProj;
            toProj = fromProj;
            fromProj = wgs84;
            single = true;
        }
        toProj = checkProj(toProj);
        if (coord) {
            return transformer(fromProj, toProj, coord);
        }
        else {
            obj = {
                forward: function (coords) {
                    return transformer(fromProj, toProj, coords);
                },
                inverse: function (coords) {
                    return transformer(toProj, fromProj, coords);
                }
            };
            if (single) {
                obj.oProj = toProj;
            }
            return obj;
        }
    }
    exports.default = proj4;
},
/* proj4/lib/Proj.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var parseCode_1 = tslib_1.__importDefault(require(183) /* ./parseCode */);
    var extend_1 = tslib_1.__importDefault(require(194) /* ./extend */);
    var projections_1 = tslib_1.__importDefault(require(195) /* ./projections */);
    var deriveConstants_1 = require(203) /* ./deriveConstants */;
    var Datum_1 = tslib_1.__importDefault(require(205) /* ./constants/Datum */);
    var datum_1 = tslib_1.__importDefault(require(206) /* ./datum */);
    var match_1 = tslib_1.__importDefault(require(190) /* ./match */);
    function Projection(srsCode, callback) {
        if (!(this instanceof Projection)) {
            return new Projection(srsCode);
        }
        callback = callback || function (error) {
            if (error) {
                throw error;
            }
        };
        var json = parseCode_1.default(srsCode);
        if (typeof json !== 'object') {
            callback(srsCode);
            return;
        }
        var ourProj = Projection.projections.get(json.projName);
        if (!ourProj) {
            callback(srsCode);
            return;
        }
        if (json.datumCode && json.datumCode !== 'none') {
            var datumDef = match_1.default(Datum_1.default, json.datumCode);
            if (datumDef) {
                json.datum_params = datumDef.towgs84 ? datumDef.towgs84.split(',') : null;
                json.ellps = datumDef.ellipse;
                json.datumName = datumDef.datumName ? datumDef.datumName : json.datumCode;
            }
        }
        json.k0 = json.k0 || 1.0;
        json.axis = json.axis || 'enu';
        json.ellps = json.ellps || 'wgs84';
        var sphere_ = deriveConstants_1.sphere(json.a, json.b, json.rf, json.ellps, json.sphere);
        var ecc = deriveConstants_1.eccentricity(sphere_.a, sphere_.b, sphere_.rf, json.R_A);
        var datumObj = json.datum || datum_1.default(json.datumCode, json.datum_params, sphere_.a, sphere_.b, ecc.es, ecc.ep2);
        extend_1.default(this, json); // transfer everything over from the projection because we don't know what we'll need
        extend_1.default(this, ourProj); // transfer all the methods from the projection
        // copy the 4 things over we calulated in deriveConstants.sphere
        this.a = sphere_.a;
        this.b = sphere_.b;
        this.rf = sphere_.rf;
        this.sphere = sphere_.sphere;
        // copy the 3 things we calculated in deriveConstants.eccentricity
        this.es = ecc.es;
        this.e = ecc.e;
        this.ep2 = ecc.ep2;
        // add in the datum object
        this.datum = datumObj;
        // init the projection
        this.init();
        // legecy callback from back in the day when it went to spatialreference.org
        callback(null, this);
    }
    Projection.projections = projections_1.default;
    Projection.projections.start();
    exports.default = Projection;
},
/* proj4/lib/parseCode.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var defs_1 = tslib_1.__importDefault(require(184) /* ./defs */);
    var wkt_parser_1 = tslib_1.__importDefault(require(191) /* wkt-parser */);
    var projString_1 = tslib_1.__importDefault(require(186) /* ./projString */);
    var match_1 = tslib_1.__importDefault(require(190) /* ./match */);
    function testObj(code) {
        return typeof code === 'string';
    }
    function testDef(code) {
        return code in defs_1.default;
    }
    var codeWords = ['PROJECTEDCRS', 'PROJCRS', 'GEOGCS', 'GEOCCS', 'PROJCS', 'LOCAL_CS', 'GEODCRS', 'GEODETICCRS', 'GEODETICDATUM', 'ENGCRS', 'ENGINEERINGCRS'];
    function testWKT(code) {
        return codeWords.some(function (word) {
            return code.indexOf(word) > -1;
        });
    }
    var codes = ['3857', '900913', '3785', '102113'];
    function checkMercator(item) {
        var auth = match_1.default(item, 'authority');
        if (!auth) {
            return;
        }
        var code = match_1.default(auth, 'epsg');
        return code && codes.indexOf(code) > -1;
    }
    function checkProjStr(item) {
        var ext = match_1.default(item, 'extension');
        if (!ext) {
            return;
        }
        return match_1.default(ext, 'proj4');
    }
    function testProj(code) {
        return code[0] === '+';
    }
    function parse(code) {
        if (testObj(code)) {
            //check to see if this is a WKT string
            if (testDef(code)) {
                return defs_1.default[code];
            }
            if (testWKT(code)) {
                var out = wkt_parser_1.default(code);
                // test of spetial case, due to this being a very common and often malformed
                if (checkMercator(out)) {
                    return defs_1.default['EPSG:3857'];
                }
                var maybeProjStr = checkProjStr(out);
                if (maybeProjStr) {
                    return projString_1.default(maybeProjStr);
                }
                return out;
            }
            if (testProj(code)) {
                return projString_1.default(code);
            }
        }
        else {
            return code;
        }
    }
    exports.default = parse;
},
/* proj4/lib/defs.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var global_1 = tslib_1.__importDefault(require(185) /* ./global */);
    var projString_1 = tslib_1.__importDefault(require(186) /* ./projString */);
    var wkt_parser_1 = tslib_1.__importDefault(require(191) /* wkt-parser */);
    function defs(name) {
        /*global console*/
        var that = this;
        if (arguments.length === 2) {
            var def = arguments[1];
            if (typeof def === 'string') {
                if (def.charAt(0) === '+') {
                    defs[name] = projString_1.default(arguments[1]);
                }
                else {
                    defs[name] = wkt_parser_1.default(arguments[1]);
                }
            }
            else {
                defs[name] = def;
            }
        }
        else if (arguments.length === 1) {
            if (Array.isArray(name)) {
                return name.map(function (v) {
                    if (Array.isArray(v)) {
                        defs.apply(that, v);
                    }
                    else {
                        defs(v);
                    }
                });
            }
            else if (typeof name === 'string') {
                if (name in defs) {
                    return defs[name];
                }
            }
            else if ('EPSG' in name) {
                defs['EPSG:' + name.EPSG] = name;
            }
            else if ('ESRI' in name) {
                defs['ESRI:' + name.ESRI] = name;
            }
            else if ('IAU2000' in name) {
                defs['IAU2000:' + name.IAU2000] = name;
            }
            else {
                console.log(name);
            }
            return;
        }
    }
    global_1.default(defs);
    exports.default = defs;
},
/* proj4/lib/global.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(defs) {
        defs('EPSG:4326', "+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees");
        defs('EPSG:4269', "+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees");
        defs('EPSG:3857', "+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs");
        defs.WGS84 = defs['EPSG:4326'];
        defs['EPSG:3785'] = defs['EPSG:3857']; // maintain backward compat, official code is 3857
        defs.GOOGLE = defs['EPSG:3857'];
        defs['EPSG:900913'] = defs['EPSG:3857'];
        defs['EPSG:102113'] = defs['EPSG:3857'];
    }
    exports.default = default_1;
},
/* proj4/lib/projString.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var values_1 = require(187) /* ./constants/values */;
    var PrimeMeridian_1 = tslib_1.__importDefault(require(188) /* ./constants/PrimeMeridian */);
    var units_1 = tslib_1.__importDefault(require(189) /* ./constants/units */);
    var match_1 = tslib_1.__importDefault(require(190) /* ./match */);
    function default_1(defData) {
        var self = {};
        var paramObj = defData.split('+').map(function (v) {
            return v.trim();
        }).filter(function (a) {
            return a;
        }).reduce(function (p, a) {
            var split = a.split('=');
            split.push(true);
            p[split[0].toLowerCase()] = split[1];
            return p;
        }, {});
        var paramName, paramVal, paramOutname;
        var params = {
            proj: 'projName',
            datum: 'datumCode',
            rf: function (v) {
                self.rf = parseFloat(v);
            },
            lat_0: function (v) {
                self.lat0 = v * values_1.D2R;
            },
            lat_1: function (v) {
                self.lat1 = v * values_1.D2R;
            },
            lat_2: function (v) {
                self.lat2 = v * values_1.D2R;
            },
            lat_ts: function (v) {
                self.lat_ts = v * values_1.D2R;
            },
            lon_0: function (v) {
                self.long0 = v * values_1.D2R;
            },
            lon_1: function (v) {
                self.long1 = v * values_1.D2R;
            },
            lon_2: function (v) {
                self.long2 = v * values_1.D2R;
            },
            alpha: function (v) {
                self.alpha = parseFloat(v) * values_1.D2R;
            },
            lonc: function (v) {
                self.longc = v * values_1.D2R;
            },
            x_0: function (v) {
                self.x0 = parseFloat(v);
            },
            y_0: function (v) {
                self.y0 = parseFloat(v);
            },
            k_0: function (v) {
                self.k0 = parseFloat(v);
            },
            k: function (v) {
                self.k0 = parseFloat(v);
            },
            a: function (v) {
                self.a = parseFloat(v);
            },
            b: function (v) {
                self.b = parseFloat(v);
            },
            r_a: function () {
                self.R_A = true;
            },
            zone: function (v) {
                self.zone = parseInt(v, 10);
            },
            south: function () {
                self.utmSouth = true;
            },
            towgs84: function (v) {
                self.datum_params = v.split(",").map(function (a) {
                    return parseFloat(a);
                });
            },
            to_meter: function (v) {
                self.to_meter = parseFloat(v);
            },
            units: function (v) {
                self.units = v;
                var unit = match_1.default(units_1.default, v);
                if (unit) {
                    self.to_meter = unit.to_meter;
                }
            },
            from_greenwich: function (v) {
                self.from_greenwich = v * values_1.D2R;
            },
            pm: function (v) {
                var pm = match_1.default(PrimeMeridian_1.default, v);
                self.from_greenwich = (pm ? pm : parseFloat(v)) * values_1.D2R;
            },
            nadgrids: function (v) {
                if (v === '@null') {
                    self.datumCode = 'none';
                }
                else {
                    self.nadgrids = v;
                }
            },
            axis: function (v) {
                var legalAxis = "ewnsud";
                if (v.length === 3 && legalAxis.indexOf(v.substr(0, 1)) !== -1 && legalAxis.indexOf(v.substr(1, 1)) !== -1 && legalAxis.indexOf(v.substr(2, 1)) !== -1) {
                    self.axis = v;
                }
            }
        };
        for (paramName in paramObj) {
            paramVal = paramObj[paramName];
            if (paramName in params) {
                paramOutname = params[paramName];
                if (typeof paramOutname === 'function') {
                    paramOutname(paramVal);
                }
                else {
                    self[paramOutname] = paramVal;
                }
            }
            else {
                self[paramName] = paramVal;
            }
        }
        if (typeof self.datumCode === 'string' && self.datumCode !== "WGS84") {
            self.datumCode = self.datumCode.toLowerCase();
        }
        return self;
    }
    exports.default = default_1;
},
/* proj4/lib/constants/values.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.PJD_3PARAM = 1;
    exports.PJD_7PARAM = 2;
    exports.PJD_WGS84 = 4; // WGS84 or equivalent
    exports.PJD_NODATUM = 5; // WGS84 or equivalent
    exports.SEC_TO_RAD = 4.84813681109535993589914102357e-6;
    exports.HALF_PI = Math.PI / 2;
    // ellipoid pj_set_ell.c
    exports.SIXTH = 0.1666666666666666667;
    /* 1/6 */
    exports.RA4 = 0.04722222222222222222;
    /* 17/360 */
    exports.RA6 = 0.02215608465608465608;
    exports.EPSLN = 1.0e-10;
    // you'd think you could use Number.EPSILON above but that makes
    // Mollweide get into an infinate loop.
    exports.D2R = 0.01745329251994329577;
    exports.R2D = 57.29577951308232088;
    exports.FORTPI = Math.PI / 4;
    exports.TWO_PI = Math.PI * 2;
    // SPI is slightly greater than Math.PI, so values that exceed the -180..180
    // degree range by a tiny amount don't get wrapped. This prevents points that
    // have drifted from their original location along the 180th meridian (due to
    // floating point error) from changing their sign.
    exports.SPI = 3.14159265359;
},
/* proj4/lib/constants/PrimeMeridian.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var exports$1 = {};
    exports.default = exports$1;
    exports$1.greenwich = 0.0; //"0dE",
    exports$1.lisbon = -9.131906111111; //"9d07'54.862\"W",
    exports$1.paris = 2.337229166667; //"2d20'14.025\"E",
    exports$1.bogota = -74.080916666667; //"74d04'51.3\"W",
    exports$1.madrid = -3.687938888889; //"3d41'16.58\"W",
    exports$1.rome = 12.452333333333; //"12d27'8.4\"E",
    exports$1.bern = 7.439583333333; //"7d26'22.5\"E",
    exports$1.jakarta = 106.807719444444; //"106d48'27.79\"E",
    exports$1.ferro = -17.666666666667; //"17d40'W",
    exports$1.brussels = 4.367975; //"4d22'4.71\"E",
    exports$1.stockholm = 18.058277777778; //"18d3'29.8\"E",
    exports$1.athens = 23.7163375; //"23d42'58.815\"E",
    exports$1.oslo = 10.722916666667; //"10d43'22.5\"E"
},
/* proj4/lib/constants/units.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = {
        ft: { to_meter: 0.3048 },
        'us-ft': { to_meter: 1200 / 3937 }
    };
},
/* proj4/lib/match.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var ignoredChar = /[\s_\-\/\(\)]/g;
    function match(obj, key) {
        if (obj[key]) {
            return obj[key];
        }
        var keys = Object.keys(obj);
        var lkey = key.toLowerCase().replace(ignoredChar, '');
        var i = -1;
        var testkey, processedKey;
        while (++i < keys.length) {
            testkey = keys[i];
            processedKey = testkey.toLowerCase().replace(ignoredChar, '');
            if (processedKey === lkey) {
                return obj[testkey];
            }
        }
    }
    exports.default = match;
},
/* wkt-parser/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var D2R = 0.01745329251994329577;
    var parser_1 = tslib_1.__importDefault(require(192) /* ./parser */);
    var process_1 = require(193) /* ./process */;
    function rename(obj, params) {
        var outName = params[0];
        var inName = params[1];
        if (!(outName in obj) && (inName in obj)) {
            obj[outName] = obj[inName];
            if (params.length === 3) {
                obj[outName] = params[2](obj[outName]);
            }
        }
    }
    function d2r(input) {
        return input * D2R;
    }
    function cleanWKT(wkt) {
        if (wkt.type === 'GEOGCS') {
            wkt.projName = 'longlat';
        }
        else if (wkt.type === 'LOCAL_CS') {
            wkt.projName = 'identity';
            wkt.local = true;
        }
        else {
            if (typeof wkt.PROJECTION === 'object') {
                wkt.projName = Object.keys(wkt.PROJECTION)[0];
            }
            else {
                wkt.projName = wkt.PROJECTION;
            }
        }
        if (wkt.AXIS) {
            var axisOrder = '';
            for (var i = 0, ii = wkt.AXIS.length; i < ii; ++i) {
                var axis = wkt.AXIS[i];
                var descriptor = axis[0].toLowerCase();
                if (descriptor.indexOf('north') !== -1) {
                    axisOrder += 'n';
                }
                else if (descriptor.indexOf('south') !== -1) {
                    axisOrder += 's';
                }
                else if (descriptor.indexOf('east') !== -1) {
                    axisOrder += 'e';
                }
                else if (descriptor.indexOf('west') !== -1) {
                    axisOrder += 'w';
                }
            }
            if (axisOrder.length === 2) {
                axisOrder += 'u';
            }
            if (axisOrder.length === 3) {
                wkt.axis = axisOrder;
            }
        }
        if (wkt.UNIT) {
            wkt.units = wkt.UNIT.name.toLowerCase();
            if (wkt.units === 'metre') {
                wkt.units = 'meter';
            }
            if (wkt.UNIT.convert) {
                if (wkt.type === 'GEOGCS') {
                    if (wkt.DATUM && wkt.DATUM.SPHEROID) {
                        wkt.to_meter = wkt.UNIT.convert * wkt.DATUM.SPHEROID.a;
                    }
                }
                else {
                    wkt.to_meter = wkt.UNIT.convert;
                }
            }
        }
        var geogcs = wkt.GEOGCS;
        if (wkt.type === 'GEOGCS') {
            geogcs = wkt;
        }
        if (geogcs) {
            //if(wkt.GEOGCS.PRIMEM&&wkt.GEOGCS.PRIMEM.convert){
            //  wkt.from_greenwich=wkt.GEOGCS.PRIMEM.convert*D2R;
            //}
            if (geogcs.DATUM) {
                wkt.datumCode = geogcs.DATUM.name.toLowerCase();
            }
            else {
                wkt.datumCode = geogcs.name.toLowerCase();
            }
            if (wkt.datumCode.slice(0, 2) === 'd_') {
                wkt.datumCode = wkt.datumCode.slice(2);
            }
            if (wkt.datumCode === 'new_zealand_geodetic_datum_1949' || wkt.datumCode === 'new_zealand_1949') {
                wkt.datumCode = 'nzgd49';
            }
            if (wkt.datumCode === 'wgs_1984' || wkt.datumCode === 'world_geodetic_system_1984') {
                if (wkt.PROJECTION === 'Mercator_Auxiliary_Sphere') {
                    wkt.sphere = true;
                }
                wkt.datumCode = 'wgs84';
            }
            if (wkt.datumCode.slice(-6) === '_ferro') {
                wkt.datumCode = wkt.datumCode.slice(0, -6);
            }
            if (wkt.datumCode.slice(-8) === '_jakarta') {
                wkt.datumCode = wkt.datumCode.slice(0, -8);
            }
            if (~wkt.datumCode.indexOf('belge')) {
                wkt.datumCode = 'rnb72';
            }
            if (geogcs.DATUM && geogcs.DATUM.SPHEROID) {
                wkt.ellps = geogcs.DATUM.SPHEROID.name.replace('_19', '').replace(/[Cc]larke\_18/, 'clrk');
                if (wkt.ellps.toLowerCase().slice(0, 13) === 'international') {
                    wkt.ellps = 'intl';
                }
                wkt.a = geogcs.DATUM.SPHEROID.a;
                wkt.rf = parseFloat(geogcs.DATUM.SPHEROID.rf, 10);
            }
            if (geogcs.DATUM && geogcs.DATUM.TOWGS84) {
                wkt.datum_params = geogcs.DATUM.TOWGS84;
            }
            if (~wkt.datumCode.indexOf('osgb_1936')) {
                wkt.datumCode = 'osgb36';
            }
            if (~wkt.datumCode.indexOf('osni_1952')) {
                wkt.datumCode = 'osni52';
            }
            if (~wkt.datumCode.indexOf('tm65')
                || ~wkt.datumCode.indexOf('geodetic_datum_of_1965')) {
                wkt.datumCode = 'ire65';
            }
            if (wkt.datumCode === 'ch1903+') {
                wkt.datumCode = 'ch1903';
            }
            if (~wkt.datumCode.indexOf('israel')) {
                wkt.datumCode = 'isr93';
            }
        }
        if (wkt.b && !isFinite(wkt.b)) {
            wkt.b = wkt.a;
        }
        function toMeter(input) {
            var ratio = wkt.to_meter || 1;
            return input * ratio;
        }
        var renamer = function (a) {
            return rename(wkt, a);
        };
        var list = [
            ['standard_parallel_1', 'Standard_Parallel_1'],
            ['standard_parallel_2', 'Standard_Parallel_2'],
            ['false_easting', 'False_Easting'],
            ['false_northing', 'False_Northing'],
            ['central_meridian', 'Central_Meridian'],
            ['latitude_of_origin', 'Latitude_Of_Origin'],
            ['latitude_of_origin', 'Central_Parallel'],
            ['scale_factor', 'Scale_Factor'],
            ['k0', 'scale_factor'],
            ['latitude_of_center', 'Latitude_Of_Center'],
            ['latitude_of_center', 'Latitude_of_center'],
            ['lat0', 'latitude_of_center', d2r],
            ['longitude_of_center', 'Longitude_Of_Center'],
            ['longitude_of_center', 'Longitude_of_center'],
            ['longc', 'longitude_of_center', d2r],
            ['x0', 'false_easting', toMeter],
            ['y0', 'false_northing', toMeter],
            ['long0', 'central_meridian', d2r],
            ['lat0', 'latitude_of_origin', d2r],
            ['lat0', 'standard_parallel_1', d2r],
            ['lat1', 'standard_parallel_1', d2r],
            ['lat2', 'standard_parallel_2', d2r],
            ['azimuth', 'Azimuth'],
            ['alpha', 'azimuth', d2r],
            ['srsCode', 'name']
        ];
        list.forEach(renamer);
        if (!wkt.long0 && wkt.longc && (wkt.projName === 'Albers_Conic_Equal_Area' || wkt.projName === 'Lambert_Azimuthal_Equal_Area')) {
            wkt.long0 = wkt.longc;
        }
        if (!wkt.lat_ts && wkt.lat1 && (wkt.projName === 'Stereographic_South_Pole' || wkt.projName === 'Polar Stereographic (variant B)')) {
            wkt.lat0 = d2r(wkt.lat1 > 0 ? 90 : -90);
            wkt.lat_ts = wkt.lat1;
        }
    }
    function default_1(wkt) {
        var lisp = parser_1.default(wkt);
        var type = lisp.shift();
        var name = lisp.shift();
        lisp.unshift(['name', name]);
        lisp.unshift(['type', type]);
        var obj = {};
        process_1.sExpr(lisp, obj);
        cleanWKT(obj);
        return obj;
    }
    exports.default = default_1;
},
/* wkt-parser/parser.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    exports.default = parseString;
    var NEUTRAL = 1;
    var KEYWORD = 2;
    var NUMBER = 3;
    var QUOTED = 4;
    var AFTERQUOTE = 5;
    var ENDED = -1;
    var whitespace = /\s/;
    var latin = /[A-Za-z]/;
    var keyword = /[A-Za-z84]/;
    var endThings = /[,\]]/;
    var digets = /[\d\.E\-\+]/;
    // const ignoredChar = /[\s_\-\/\(\)]/g;
    function Parser(text) {
        if (typeof text !== 'string') {
            throw new Error('not a string');
        }
        this.text = text.trim();
        this.level = 0;
        this.place = 0;
        this.root = null;
        this.stack = [];
        this.currentObject = null;
        this.state = NEUTRAL;
    }
    Parser.prototype.readCharicter = function () {
        var char = this.text[this.place++];
        if (this.state !== QUOTED) {
            while (whitespace.test(char)) {
                if (this.place >= this.text.length) {
                    return;
                }
                char = this.text[this.place++];
            }
        }
        switch (this.state) {
            case NEUTRAL:
                return this.neutral(char);
            case KEYWORD:
                return this.keyword(char);
            case QUOTED:
                return this.quoted(char);
            case AFTERQUOTE:
                return this.afterquote(char);
            case NUMBER:
                return this.number(char);
            case ENDED:
                return;
        }
    };
    Parser.prototype.afterquote = function (char) {
        if (char === '"') {
            this.word += '"';
            this.state = QUOTED;
            return;
        }
        if (endThings.test(char)) {
            this.word = this.word.trim();
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in afterquote yet, index ' + this.place);
    };
    Parser.prototype.afterItem = function (char) {
        if (char === ',') {
            if (this.word !== null) {
                this.currentObject.push(this.word);
            }
            this.word = null;
            this.state = NEUTRAL;
            return;
        }
        if (char === ']') {
            this.level--;
            if (this.word !== null) {
                this.currentObject.push(this.word);
                this.word = null;
            }
            this.state = NEUTRAL;
            this.currentObject = this.stack.pop();
            if (!this.currentObject) {
                this.state = ENDED;
            }
            return;
        }
    };
    Parser.prototype.number = function (char) {
        if (digets.test(char)) {
            this.word += char;
            return;
        }
        if (endThings.test(char)) {
            this.word = parseFloat(this.word);
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in number yet, index ' + this.place);
    };
    Parser.prototype.quoted = function (char) {
        if (char === '"') {
            this.state = AFTERQUOTE;
            return;
        }
        this.word += char;
        return;
    };
    Parser.prototype.keyword = function (char) {
        if (keyword.test(char)) {
            this.word += char;
            return;
        }
        if (char === '[') {
            var newObjects = [];
            newObjects.push(this.word);
            this.level++;
            if (this.root === null) {
                this.root = newObjects;
            }
            else {
                this.currentObject.push(newObjects);
            }
            this.stack.push(this.currentObject);
            this.currentObject = newObjects;
            this.state = NEUTRAL;
            return;
        }
        if (endThings.test(char)) {
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in keyword yet, index ' + this.place);
    };
    Parser.prototype.neutral = function (char) {
        if (latin.test(char)) {
            this.word = char;
            this.state = KEYWORD;
            return;
        }
        if (char === '"') {
            this.word = '';
            this.state = QUOTED;
            return;
        }
        if (digets.test(char)) {
            this.word = char;
            this.state = NUMBER;
            return;
        }
        if (endThings.test(char)) {
            this.afterItem(char);
            return;
        }
        throw new Error('havn\'t handled "' + char + '" in neutral yet, index ' + this.place);
    };
    Parser.prototype.output = function () {
        while (this.place < this.text.length) {
            this.readCharicter();
        }
        if (this.state === ENDED) {
            return this.root;
        }
        throw new Error('unable to parse string "' + this.text + '". State is ' + this.state);
    };
    function parseString(txt) {
        var parser = new Parser(txt);
        return parser.output();
    }
},
/* wkt-parser/process.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function mapit(obj, key, value) {
        if (Array.isArray(key)) {
            value.unshift(key);
            key = null;
        }
        var thing = key ? {} : obj;
        var out = value.reduce(function (newObj, item) {
            sExpr(item, newObj);
            return newObj;
        }, thing);
        if (key) {
            obj[key] = out;
        }
    }
    function sExpr(v, obj) {
        if (!Array.isArray(v)) {
            obj[v] = true;
            return;
        }
        var key = v.shift();
        if (key === 'PARAMETER') {
            key = v.shift();
        }
        if (v.length === 1) {
            if (Array.isArray(v[0])) {
                obj[key] = {};
                sExpr(v[0], obj[key]);
                return;
            }
            obj[key] = v[0];
            return;
        }
        if (!v.length) {
            obj[key] = true;
            return;
        }
        if (key === 'TOWGS84') {
            obj[key] = v;
            return;
        }
        if (key === 'AXIS') {
            if (!(key in obj)) {
                obj[key] = [];
            }
            obj[key].push(v);
            return;
        }
        if (!Array.isArray(key)) {
            obj[key] = {};
        }
        var i;
        switch (key) {
            case 'UNIT':
            case 'PRIMEM':
            case 'VERT_DATUM':
                obj[key] = {
                    name: v[0].toLowerCase(),
                    convert: v[1]
                };
                if (v.length === 3) {
                    sExpr(v[2], obj[key]);
                }
                return;
            case 'SPHEROID':
            case 'ELLIPSOID':
                obj[key] = {
                    name: v[0],
                    a: v[1],
                    rf: v[2]
                };
                if (v.length === 4) {
                    sExpr(v[3], obj[key]);
                }
                return;
            case 'PROJECTEDCRS':
            case 'PROJCRS':
            case 'GEOGCS':
            case 'GEOCCS':
            case 'PROJCS':
            case 'LOCAL_CS':
            case 'GEODCRS':
            case 'GEODETICCRS':
            case 'GEODETICDATUM':
            case 'EDATUM':
            case 'ENGINEERINGDATUM':
            case 'VERT_CS':
            case 'VERTCRS':
            case 'VERTICALCRS':
            case 'COMPD_CS':
            case 'COMPOUNDCRS':
            case 'ENGINEERINGCRS':
            case 'ENGCRS':
            case 'FITTED_CS':
            case 'LOCAL_DATUM':
            case 'DATUM':
                v[0] = ['name', v[0]];
                mapit(obj, key, v);
                return;
            default:
                i = -1;
                while (++i < v.length) {
                    if (!Array.isArray(v[i])) {
                        return sExpr(v, obj[key]);
                    }
                }
                return mapit(obj, key, v);
        }
    }
    exports.sExpr = sExpr;
},
/* proj4/lib/extend.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(destination, source) {
        destination = destination || {};
        var value, property;
        if (!source) {
            return destination;
        }
        for (property in source) {
            value = source[property];
            if (value !== undefined) {
                destination[property] = value;
            }
        }
        return destination;
    }
    exports.default = default_1;
},
/* proj4/lib/projections.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var merc_1 = tslib_1.__importDefault(require(196) /* ./projections/merc */);
    var longlat_1 = tslib_1.__importDefault(require(202) /* ./projections/longlat */);
    var projs = [merc_1.default, longlat_1.default];
    var names = {};
    var projStore = [];
    function add(proj, i) {
        var len = projStore.length;
        if (!proj.names) {
            console.log(i);
            return true;
        }
        projStore[len] = proj;
        proj.names.forEach(function (n) {
            names[n.toLowerCase()] = len;
        });
        return this;
    }
    exports.add = add;
    function get(name) {
        if (!name) {
            return false;
        }
        var n = name.toLowerCase();
        if (typeof names[n] !== 'undefined' && projStore[names[n]]) {
            return projStore[names[n]];
        }
    }
    exports.get = get;
    function start() {
        projs.forEach(add);
    }
    exports.start = start;
    exports.default = {
        start: start,
        add: add,
        get: get
    };
},
/* proj4/lib/projections/merc.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var msfnz_1 = tslib_1.__importDefault(require(197) /* ../common/msfnz */);
    var adjust_lon_1 = tslib_1.__importDefault(require(198) /* ../common/adjust_lon */);
    var tsfnz_1 = tslib_1.__importDefault(require(200) /* ../common/tsfnz */);
    var phi2z_1 = tslib_1.__importDefault(require(201) /* ../common/phi2z */);
    var values_1 = require(187) /* ../constants/values */;
    function init() {
        var con = this.b / this.a;
        this.es = 1 - con * con;
        if (!('x0' in this)) {
            this.x0 = 0;
        }
        if (!('y0' in this)) {
            this.y0 = 0;
        }
        this.e = Math.sqrt(this.es);
        if (this.lat_ts) {
            if (this.sphere) {
                this.k0 = Math.cos(this.lat_ts);
            }
            else {
                this.k0 = msfnz_1.default(this.e, Math.sin(this.lat_ts), Math.cos(this.lat_ts));
            }
        }
        else {
            if (!this.k0) {
                if (this.k) {
                    this.k0 = this.k;
                }
                else {
                    this.k0 = 1;
                }
            }
        }
    }
    exports.init = init;
    /* Mercator forward equations--mapping lat,long to x,y
      --------------------------------------------------*/
    function forward(p) {
        var lon = p.x;
        var lat = p.y;
        // convert to radians
        if (lat * values_1.R2D > 90 && lat * values_1.R2D < -90 && lon * values_1.R2D > 180 && lon * values_1.R2D < -180) {
            return null;
        }
        var x, y;
        if (Math.abs(Math.abs(lat) - values_1.HALF_PI) <= values_1.EPSLN) {
            return null;
        }
        else {
            if (this.sphere) {
                x = this.x0 + this.a * this.k0 * adjust_lon_1.default(lon - this.long0);
                y = this.y0 + this.a * this.k0 * Math.log(Math.tan(values_1.FORTPI + 0.5 * lat));
            }
            else {
                var sinphi = Math.sin(lat);
                var ts = tsfnz_1.default(this.e, lat, sinphi);
                x = this.x0 + this.a * this.k0 * adjust_lon_1.default(lon - this.long0);
                y = this.y0 - this.a * this.k0 * Math.log(ts);
            }
            p.x = x;
            p.y = y;
            return p;
        }
    }
    exports.forward = forward;
    /* Mercator inverse equations--mapping x,y to lat/long
      --------------------------------------------------*/
    function inverse(p) {
        var x = p.x - this.x0;
        var y = p.y - this.y0;
        var lon, lat;
        if (this.sphere) {
            lat = values_1.HALF_PI - 2 * Math.atan(Math.exp(-y / (this.a * this.k0)));
        }
        else {
            var ts = Math.exp(-y / (this.a * this.k0));
            lat = phi2z_1.default(this.e, ts);
            if (lat === -9999) {
                return null;
            }
        }
        lon = adjust_lon_1.default(this.long0 + x / (this.a * this.k0));
        p.x = lon;
        p.y = lat;
        return p;
    }
    exports.inverse = inverse;
    exports.names = ["Mercator", "Popular Visualisation Pseudo Mercator", "Mercator_1SP", "Mercator_Auxiliary_Sphere", "merc"];
    exports.default = {
        init: init,
        forward: forward,
        inverse: inverse,
        names: exports.names
    };
},
/* proj4/lib/common/msfnz.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(eccent, sinphi, cosphi) {
        var con = eccent * sinphi;
        return cosphi / (Math.sqrt(1 - con * con));
    }
    exports.default = default_1;
},
/* proj4/lib/common/adjust_lon.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var values_1 = require(187) /* ../constants/values */;
    var sign_1 = tslib_1.__importDefault(require(199) /* ./sign */);
    function default_1(x) {
        return (Math.abs(x) <= values_1.SPI) ? x : (x - (sign_1.default(x) * values_1.TWO_PI));
    }
    exports.default = default_1;
},
/* proj4/lib/common/sign.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(x) {
        return x < 0 ? -1 : 1;
    }
    exports.default = default_1;
},
/* proj4/lib/common/tsfnz.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var values_1 = require(187) /* ../constants/values */;
    function default_1(eccent, phi, sinphi) {
        var con = eccent * sinphi;
        var com = 0.5 * eccent;
        con = Math.pow(((1 - con) / (1 + con)), com);
        return (Math.tan(0.5 * (values_1.HALF_PI - phi)) / con);
    }
    exports.default = default_1;
},
/* proj4/lib/common/phi2z.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var values_1 = require(187) /* ../constants/values */;
    function default_1(eccent, ts) {
        var eccnth = 0.5 * eccent;
        var con, dphi;
        var phi = values_1.HALF_PI - 2 * Math.atan(ts);
        for (var i = 0; i <= 15; i++) {
            con = eccent * Math.sin(phi);
            dphi = values_1.HALF_PI - 2 * Math.atan(ts * (Math.pow(((1 - con) / (1 + con)), eccnth))) - phi;
            phi += dphi;
            if (Math.abs(dphi) <= 0.0000000001) {
                return phi;
            }
        }
        //console.log("phi2z has NoConvergence");
        return -9999;
    }
    exports.default = default_1;
},
/* proj4/lib/projections/longlat.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function init() {
        //no-op for longlat
    }
    exports.init = init;
    function identity(pt) {
        return pt;
    }
    exports.forward = identity;
    exports.inverse = identity;
    exports.names = ["longlat", "identity"];
    exports.default = {
        init: init,
        forward: identity,
        inverse: identity,
        names: exports.names
    };
},
/* proj4/lib/deriveConstants.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var values_1 = require(187) /* ./constants/values */;
    var Ellipsoid_1 = tslib_1.__importStar(require(204) /* ./constants/Ellipsoid */);
    var match_1 = tslib_1.__importDefault(require(190) /* ./match */);
    function eccentricity(a, b, rf, R_A) {
        var a2 = a * a; // used in geocentric
        var b2 = b * b; // used in geocentric
        var es = (a2 - b2) / a2; // e ^ 2
        var e = 0;
        if (R_A) {
            a *= 1 - es * (values_1.SIXTH + es * (values_1.RA4 + es * values_1.RA6));
            a2 = a * a;
            es = 0;
        }
        else {
            e = Math.sqrt(es); // eccentricity
        }
        var ep2 = (a2 - b2) / b2; // used in geocentric
        return {
            es: es,
            e: e,
            ep2: ep2
        };
    }
    exports.eccentricity = eccentricity;
    function sphere(a, b, rf, ellps, sphere) {
        if (!a) { // do we have an ellipsoid?
            var ellipse = match_1.default(Ellipsoid_1.default, ellps);
            if (!ellipse) {
                ellipse = Ellipsoid_1.WGS84;
            }
            a = ellipse.a;
            b = ellipse.b;
            rf = ellipse.rf;
        }
        if (rf && !b) {
            b = (1.0 - 1.0 / rf) * a;
        }
        if (rf === 0 || Math.abs(a - b) < values_1.EPSLN) {
            sphere = true;
            b = a;
        }
        return {
            a: a,
            b: b,
            rf: rf,
            sphere: sphere
        };
    }
    exports.sphere = sphere;
},
/* proj4/lib/constants/Ellipsoid.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var exports$1 = {};
    exports.default = exports$1;
    exports$1.MERIT = {
        a: 6378137.0,
        rf: 298.257,
        ellipseName: "MERIT 1983"
    };
    exports$1.SGS85 = {
        a: 6378136.0,
        rf: 298.257,
        ellipseName: "Soviet Geodetic System 85"
    };
    exports$1.GRS80 = {
        a: 6378137.0,
        rf: 298.257222101,
        ellipseName: "GRS 1980(IUGG, 1980)"
    };
    exports$1.IAU76 = {
        a: 6378140.0,
        rf: 298.257,
        ellipseName: "IAU 1976"
    };
    exports$1.airy = {
        a: 6377563.396,
        b: 6356256.910,
        ellipseName: "Airy 1830"
    };
    exports$1.APL4 = {
        a: 6378137,
        rf: 298.25,
        ellipseName: "Appl. Physics. 1965"
    };
    exports$1.NWL9D = {
        a: 6378145.0,
        rf: 298.25,
        ellipseName: "Naval Weapons Lab., 1965"
    };
    exports$1.mod_airy = {
        a: 6377340.189,
        b: 6356034.446,
        ellipseName: "Modified Airy"
    };
    exports$1.andrae = {
        a: 6377104.43,
        rf: 300.0,
        ellipseName: "Andrae 1876 (Den., Iclnd.)"
    };
    exports$1.aust_SA = {
        a: 6378160.0,
        rf: 298.25,
        ellipseName: "Australian Natl & S. Amer. 1969"
    };
    exports$1.GRS67 = {
        a: 6378160.0,
        rf: 298.2471674270,
        ellipseName: "GRS 67(IUGG 1967)"
    };
    exports$1.bessel = {
        a: 6377397.155,
        rf: 299.1528128,
        ellipseName: "Bessel 1841"
    };
    exports$1.bess_nam = {
        a: 6377483.865,
        rf: 299.1528128,
        ellipseName: "Bessel 1841 (Namibia)"
    };
    exports$1.clrk66 = {
        a: 6378206.4,
        b: 6356583.8,
        ellipseName: "Clarke 1866"
    };
    exports$1.clrk80 = {
        a: 6378249.145,
        rf: 293.4663,
        ellipseName: "Clarke 1880 mod."
    };
    exports$1.clrk58 = {
        a: 6378293.645208759,
        rf: 294.2606763692654,
        ellipseName: "Clarke 1858"
    };
    exports$1.CPM = {
        a: 6375738.7,
        rf: 334.29,
        ellipseName: "Comm. des Poids et Mesures 1799"
    };
    exports$1.delmbr = {
        a: 6376428.0,
        rf: 311.5,
        ellipseName: "Delambre 1810 (Belgium)"
    };
    exports$1.engelis = {
        a: 6378136.05,
        rf: 298.2566,
        ellipseName: "Engelis 1985"
    };
    exports$1.evrst30 = {
        a: 6377276.345,
        rf: 300.8017,
        ellipseName: "Everest 1830"
    };
    exports$1.evrst48 = {
        a: 6377304.063,
        rf: 300.8017,
        ellipseName: "Everest 1948"
    };
    exports$1.evrst56 = {
        a: 6377301.243,
        rf: 300.8017,
        ellipseName: "Everest 1956"
    };
    exports$1.evrst69 = {
        a: 6377295.664,
        rf: 300.8017,
        ellipseName: "Everest 1969"
    };
    exports$1.evrstSS = {
        a: 6377298.556,
        rf: 300.8017,
        ellipseName: "Everest (Sabah & Sarawak)"
    };
    exports$1.fschr60 = {
        a: 6378166.0,
        rf: 298.3,
        ellipseName: "Fischer (Mercury Datum) 1960"
    };
    exports$1.fschr60m = {
        a: 6378155.0,
        rf: 298.3,
        ellipseName: "Fischer 1960"
    };
    exports$1.fschr68 = {
        a: 6378150.0,
        rf: 298.3,
        ellipseName: "Fischer 1968"
    };
    exports$1.helmert = {
        a: 6378200.0,
        rf: 298.3,
        ellipseName: "Helmert 1906"
    };
    exports$1.hough = {
        a: 6378270.0,
        rf: 297.0,
        ellipseName: "Hough"
    };
    exports$1.intl = {
        a: 6378388.0,
        rf: 297.0,
        ellipseName: "International 1909 (Hayford)"
    };
    exports$1.kaula = {
        a: 6378163.0,
        rf: 298.24,
        ellipseName: "Kaula 1961"
    };
    exports$1.lerch = {
        a: 6378139.0,
        rf: 298.257,
        ellipseName: "Lerch 1979"
    };
    exports$1.mprts = {
        a: 6397300.0,
        rf: 191.0,
        ellipseName: "Maupertius 1738"
    };
    exports$1.new_intl = {
        a: 6378157.5,
        b: 6356772.2,
        ellipseName: "New International 1967"
    };
    exports$1.plessis = {
        a: 6376523.0,
        rf: 6355863.0,
        ellipseName: "Plessis 1817 (France)"
    };
    exports$1.krass = {
        a: 6378245.0,
        rf: 298.3,
        ellipseName: "Krassovsky, 1942"
    };
    exports$1.SEasia = {
        a: 6378155.0,
        b: 6356773.3205,
        ellipseName: "Southeast Asia"
    };
    exports$1.walbeck = {
        a: 6376896.0,
        b: 6355834.8467,
        ellipseName: "Walbeck"
    };
    exports$1.WGS60 = {
        a: 6378165.0,
        rf: 298.3,
        ellipseName: "WGS 60"
    };
    exports$1.WGS66 = {
        a: 6378145.0,
        rf: 298.25,
        ellipseName: "WGS 66"
    };
    exports$1.WGS7 = {
        a: 6378135.0,
        rf: 298.26,
        ellipseName: "WGS 72"
    };
    exports.WGS84 = exports$1.WGS84 = {
        a: 6378137.0,
        rf: 298.257223563,
        ellipseName: "WGS 84"
    };
    exports$1.sphere = {
        a: 6370997.0,
        b: 6370997.0,
        ellipseName: "Normal Sphere (r=6370997)"
    };
},
/* proj4/lib/constants/Datum.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var exports$1 = {};
    exports.default = exports$1;
    exports$1.wgs84 = {
        towgs84: "0,0,0",
        ellipse: "WGS84",
        datumName: "WGS84"
    };
    exports$1.ch1903 = {
        towgs84: "674.374,15.056,405.346",
        ellipse: "bessel",
        datumName: "swiss"
    };
    exports$1.ggrs87 = {
        towgs84: "-199.87,74.79,246.62",
        ellipse: "GRS80",
        datumName: "Greek_Geodetic_Reference_System_1987"
    };
    exports$1.nad83 = {
        towgs84: "0,0,0",
        ellipse: "GRS80",
        datumName: "North_American_Datum_1983"
    };
    exports$1.nad27 = {
        nadgrids: "@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",
        ellipse: "clrk66",
        datumName: "North_American_Datum_1927"
    };
    exports$1.potsdam = {
        towgs84: "606.0,23.0,413.0",
        ellipse: "bessel",
        datumName: "Potsdam Rauenberg 1950 DHDN"
    };
    exports$1.carthage = {
        towgs84: "-263.0,6.0,431.0",
        ellipse: "clark80",
        datumName: "Carthage 1934 Tunisia"
    };
    exports$1.hermannskogel = {
        towgs84: "653.0,-212.0,449.0",
        ellipse: "bessel",
        datumName: "Hermannskogel"
    };
    exports$1.osni52 = {
        towgs84: "482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",
        ellipse: "airy",
        datumName: "Irish National"
    };
    exports$1.ire65 = {
        towgs84: "482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",
        ellipse: "mod_airy",
        datumName: "Ireland 1965"
    };
    exports$1.rassadiran = {
        towgs84: "-133.63,-157.5,-158.62",
        ellipse: "intl",
        datumName: "Rassadiran"
    };
    exports$1.nzgd49 = {
        towgs84: "59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",
        ellipse: "intl",
        datumName: "New Zealand Geodetic Datum 1949"
    };
    exports$1.osgb36 = {
        towgs84: "446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",
        ellipse: "airy",
        datumName: "Airy 1830"
    };
    exports$1.s_jtsk = {
        towgs84: "589,76,480",
        ellipse: 'bessel',
        datumName: 'S-JTSK (Ferro)'
    };
    exports$1.beduaram = {
        towgs84: '-106,-87,188',
        ellipse: 'clrk80',
        datumName: 'Beduaram'
    };
    exports$1.gunung_segara = {
        towgs84: '-403,684,41',
        ellipse: 'bessel',
        datumName: 'Gunung Segara Jakarta'
    };
    exports$1.rnb72 = {
        towgs84: "106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",
        ellipse: "intl",
        datumName: "Reseau National Belge 1972"
    };
},
/* proj4/lib/datum.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var values_1 = require(187) /* ./constants/values */;
    function datum(datumCode, datum_params, a, b, es, ep2) {
        var out = {};
        if (datumCode === undefined || datumCode === 'none') {
            out.datum_type = values_1.PJD_NODATUM;
        }
        else {
            out.datum_type = values_1.PJD_WGS84;
        }
        if (datum_params) {
            out.datum_params = datum_params.map(parseFloat);
            if (out.datum_params[0] !== 0 || out.datum_params[1] !== 0 || out.datum_params[2] !== 0) {
                out.datum_type = values_1.PJD_3PARAM;
            }
            if (out.datum_params.length > 3) {
                if (out.datum_params[3] !== 0 || out.datum_params[4] !== 0 || out.datum_params[5] !== 0 || out.datum_params[6] !== 0) {
                    out.datum_type = values_1.PJD_7PARAM;
                    out.datum_params[3] *= values_1.SEC_TO_RAD;
                    out.datum_params[4] *= values_1.SEC_TO_RAD;
                    out.datum_params[5] *= values_1.SEC_TO_RAD;
                    out.datum_params[6] = (out.datum_params[6] / 1000000.0) + 1.0;
                }
            }
        }
        out.a = a; //datum object also uses these values
        out.b = b;
        out.es = es;
        out.ep2 = ep2;
        return out;
    }
    exports.default = datum;
},
/* proj4/lib/transform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var values_1 = require(187) /* ./constants/values */;
    var datum_transform_1 = tslib_1.__importDefault(require(208) /* ./datum_transform */);
    var adjust_axis_1 = tslib_1.__importDefault(require(210) /* ./adjust_axis */);
    var Proj_1 = tslib_1.__importDefault(require(182) /* ./Proj */);
    var toPoint_1 = tslib_1.__importDefault(require(211) /* ./common/toPoint */);
    var checkSanity_1 = tslib_1.__importDefault(require(212) /* ./checkSanity */);
    function checkNotWGS(source, dest) {
        return ((source.datum.datum_type === values_1.PJD_3PARAM || source.datum.datum_type === values_1.PJD_7PARAM) && dest.datumCode !== 'WGS84') || ((dest.datum.datum_type === values_1.PJD_3PARAM || dest.datum.datum_type === values_1.PJD_7PARAM) && source.datumCode !== 'WGS84');
    }
    function transform(source, dest, point) {
        var wgs84;
        if (Array.isArray(point)) {
            point = toPoint_1.default(point);
        }
        checkSanity_1.default(point);
        // Workaround for datum shifts towgs84, if either source or destination projection is not wgs84
        if (source.datum && dest.datum && checkNotWGS(source, dest)) {
            wgs84 = new Proj_1.default('WGS84');
            point = transform(source, wgs84, point);
            source = wgs84;
        }
        // DGR, 2010/11/12
        if (source.axis !== 'enu') {
            point = adjust_axis_1.default(source, false, point);
        }
        // Transform source points to long/lat, if they aren't already.
        if (source.projName === 'longlat') {
            point = {
                x: point.x * values_1.D2R,
                y: point.y * values_1.D2R,
                z: point.z || 0
            };
        }
        else {
            if (source.to_meter) {
                point = {
                    x: point.x * source.to_meter,
                    y: point.y * source.to_meter,
                    z: point.z || 0
                };
            }
            point = source.inverse(point); // Convert Cartesian to longlat
            if (!point) {
                return;
            }
        }
        // Adjust for the prime meridian if necessary
        if (source.from_greenwich) {
            point.x += source.from_greenwich;
        }
        // Convert datums if needed, and if possible.
        point = datum_transform_1.default(source.datum, dest.datum, point);
        // Adjust for the prime meridian if necessary
        if (dest.from_greenwich) {
            point = {
                x: point.x - dest.from_greenwich,
                y: point.y,
                z: point.z || 0
            };
        }
        if (dest.projName === 'longlat') {
            // convert radians to decimal degrees
            point = {
                x: point.x * values_1.R2D,
                y: point.y * values_1.R2D,
                z: point.z || 0
            };
        }
        else { // else project
            point = dest.forward(point);
            if (dest.to_meter) {
                point = {
                    x: point.x / dest.to_meter,
                    y: point.y / dest.to_meter,
                    z: point.z || 0
                };
            }
        }
        // DGR, 2010/11/12
        if (dest.axis !== 'enu') {
            return adjust_axis_1.default(dest, true, point);
        }
        return point;
    }
    exports.default = transform;
},
/* proj4/lib/datum_transform.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var values_1 = require(187) /* ./constants/values */;
    var datumUtils_1 = require(209) /* ./datumUtils */;
    function checkParams(type) {
        return (type === values_1.PJD_3PARAM || type === values_1.PJD_7PARAM);
    }
    function default_1(source, dest, point) {
        // Short cut if the datums are identical.
        if (datumUtils_1.compareDatums(source, dest)) {
            return point; // in this case, zero is sucess,
            // whereas cs_compare_datums returns 1 to indicate TRUE
            // confusing, should fix this
        }
        // Explicitly skip datum transform by setting 'datum=none' as parameter for either source or dest
        if (source.datum_type === values_1.PJD_NODATUM || dest.datum_type === values_1.PJD_NODATUM) {
            return point;
        }
        // If this datum requires grid shifts, then apply it to geodetic coordinates.
        // Do we need to go through geocentric coordinates?
        if (source.es === dest.es && source.a === dest.a && !checkParams(source.datum_type) && !checkParams(dest.datum_type)) {
            return point;
        }
        // Convert to geocentric coordinates.
        point = datumUtils_1.geodeticToGeocentric(point, source.es, source.a);
        // Convert between datums
        if (checkParams(source.datum_type)) {
            point = datumUtils_1.geocentricToWgs84(point, source.datum_type, source.datum_params);
        }
        if (checkParams(dest.datum_type)) {
            point = datumUtils_1.geocentricFromWgs84(point, dest.datum_type, dest.datum_params);
        }
        return datumUtils_1.geocentricToGeodetic(point, dest.es, dest.a, dest.b);
    }
    exports.default = default_1;
},
/* proj4/lib/datumUtils.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var values_1 = require(187) /* ./constants/values */;
    function compareDatums(source, dest) {
        if (source.datum_type !== dest.datum_type) {
            return false; // false, datums are not equal
        }
        else if (source.a !== dest.a || Math.abs(source.es - dest.es) > 0.000000000050) {
            // the tolerance for es is to ensure that GRS80 and WGS84
            // are considered identical
            return false;
        }
        else if (source.datum_type === values_1.PJD_3PARAM) {
            return (source.datum_params[0] === dest.datum_params[0] && source.datum_params[1] === dest.datum_params[1] && source.datum_params[2] === dest.datum_params[2]);
        }
        else if (source.datum_type === values_1.PJD_7PARAM) {
            return (source.datum_params[0] === dest.datum_params[0] && source.datum_params[1] === dest.datum_params[1] && source.datum_params[2] === dest.datum_params[2] && source.datum_params[3] === dest.datum_params[3] && source.datum_params[4] === dest.datum_params[4] && source.datum_params[5] === dest.datum_params[5] && source.datum_params[6] === dest.datum_params[6]);
        }
        else {
            return true; // datums are equal
        }
    } // cs_compare_datums()
    exports.compareDatums = compareDatums;
    /*
     * The function Convert_Geodetic_To_Geocentric converts geodetic coordinates
     * (latitude, longitude, and height) to geocentric coordinates (X, Y, Z),
     * according to the current ellipsoid parameters.
     *
     *    Latitude  : Geodetic latitude in radians                     (input)
     *    Longitude : Geodetic longitude in radians                    (input)
     *    Height    : Geodetic height, in meters                       (input)
     *    X         : Calculated Geocentric X coordinate, in meters    (output)
     *    Y         : Calculated Geocentric Y coordinate, in meters    (output)
     *    Z         : Calculated Geocentric Z coordinate, in meters    (output)
     *
     */
    function geodeticToGeocentric(p, es, a) {
        var Longitude = p.x;
        var Latitude = p.y;
        var Height = p.z ? p.z : 0; //Z value not always supplied
        var Rn; /*  Earth radius at location  */
        var Sin_Lat; /*  Math.sin(Latitude)  */
        var Sin2_Lat; /*  Square of Math.sin(Latitude)  */
        var Cos_Lat; /*  Math.cos(Latitude)  */
        /*
         ** Don't blow up if Latitude is just a little out of the value
         ** range as it may just be a rounding issue.  Also removed longitude
         ** test, it should be wrapped by Math.cos() and Math.sin().  NFW for PROJ.4, Sep/2001.
         */
        if (Latitude < -values_1.HALF_PI && Latitude > -1.001 * values_1.HALF_PI) {
            Latitude = -values_1.HALF_PI;
        }
        else if (Latitude > values_1.HALF_PI && Latitude < 1.001 * values_1.HALF_PI) {
            Latitude = values_1.HALF_PI;
        }
        else if (Latitude < -values_1.HALF_PI) {
            /* Latitude out of range */
            //..reportError('geocent:lat out of range:' + Latitude);
            return { x: -Infinity, y: -Infinity, z: p.z };
        }
        else if (Latitude > values_1.HALF_PI) {
            /* Latitude out of range */
            return { x: Infinity, y: Infinity, z: p.z };
        }
        if (Longitude > Math.PI) {
            Longitude -= (2 * Math.PI);
        }
        Sin_Lat = Math.sin(Latitude);
        Cos_Lat = Math.cos(Latitude);
        Sin2_Lat = Sin_Lat * Sin_Lat;
        Rn = a / (Math.sqrt(1.0e0 - es * Sin2_Lat));
        return {
            x: (Rn + Height) * Cos_Lat * Math.cos(Longitude),
            y: (Rn + Height) * Cos_Lat * Math.sin(Longitude),
            z: ((Rn * (1 - es)) + Height) * Sin_Lat
        };
    } // cs_geodetic_to_geocentric()
    exports.geodeticToGeocentric = geodeticToGeocentric;
    function geocentricToGeodetic(p, es, a, b) {
        /* local defintions and variables */
        /* end-criterium of loop, accuracy of sin(Latitude) */
        var genau = 1e-12;
        var genau2 = (genau * genau);
        var maxiter = 30;
        var P; /* distance between semi-minor axis and location */
        var RR; /* distance between center and location */
        var CT; /* sin of geocentric latitude */
        var ST; /* cos of geocentric latitude */
        var RX;
        var RK;
        var RN; /* Earth radius at location */
        var CPHI0; /* cos of start or old geodetic latitude in iterations */
        var SPHI0; /* sin of start or old geodetic latitude in iterations */
        var CPHI; /* cos of searched geodetic latitude */
        var SPHI; /* sin of searched geodetic latitude */
        var SDPHI; /* end-criterium: addition-theorem of sin(Latitude(iter)-Latitude(iter-1)) */
        var iter; /* # of continous iteration, max. 30 is always enough (s.a.) */
        var X = p.x;
        var Y = p.y;
        var Z = p.z ? p.z : 0.0; //Z value not always supplied
        var Longitude;
        var Latitude;
        var Height;
        P = Math.sqrt(X * X + Y * Y);
        RR = Math.sqrt(X * X + Y * Y + Z * Z);
        /*      special cases for latitude and longitude */
        if (P / a < genau) {
            /*  special case, if P=0. (X=0., Y=0.) */
            Longitude = 0.0;
            /*  if (X,Y,Z)=(0.,0.,0.) then Height becomes semi-minor axis
             *  of ellipsoid (=center of mass), Latitude becomes PI/2 */
            if (RR / a < genau) {
                Latitude = values_1.HALF_PI;
                Height = -b;
                return {
                    x: p.x,
                    y: p.y,
                    z: p.z
                };
            }
        }
        else {
            /*  ellipsoidal (geodetic) longitude
             *  interval: -PI < Longitude <= +PI */
            Longitude = Math.atan2(Y, X);
        }
        /* --------------------------------------------------------------
         * Following iterative algorithm was developped by
         * "Institut for Erdmessung", University of Hannover, July 1988.
         * Internet: www.ife.uni-hannover.de
         * Iterative computation of CPHI,SPHI and Height.
         * Iteration of CPHI and SPHI to 10**-12 radian resp.
         * 2*10**-7 arcsec.
         * --------------------------------------------------------------
         */
        CT = Z / RR;
        ST = P / RR;
        RX = 1.0 / Math.sqrt(1.0 - es * (2.0 - es) * ST * ST);
        CPHI0 = ST * (1.0 - es) * RX;
        SPHI0 = CT * RX;
        iter = 0;
        /* loop to find sin(Latitude) resp. Latitude
         * until |sin(Latitude(iter)-Latitude(iter-1))| < genau */
        do {
            iter++;
            RN = a / Math.sqrt(1.0 - es * SPHI0 * SPHI0);
            /*  ellipsoidal (geodetic) height */
            Height = P * CPHI0 + Z * SPHI0 - RN * (1.0 - es * SPHI0 * SPHI0);
            RK = es * RN / (RN + Height);
            RX = 1.0 / Math.sqrt(1.0 - RK * (2.0 - RK) * ST * ST);
            CPHI = ST * (1.0 - RK) * RX;
            SPHI = CT * RX;
            SDPHI = SPHI * CPHI0 - CPHI * SPHI0;
            CPHI0 = CPHI;
            SPHI0 = SPHI;
        } while (SDPHI * SDPHI > genau2 && iter < maxiter);
        /*      ellipsoidal (geodetic) latitude */
        Latitude = Math.atan(SPHI / Math.abs(CPHI));
        return {
            x: Longitude,
            y: Latitude,
            z: Height
        };
    } // cs_geocentric_to_geodetic()
    exports.geocentricToGeodetic = geocentricToGeodetic;
    /****************************************************************/
    // pj_geocentic_to_wgs84( p )
    //  p = point to transform in geocentric coordinates (x,y,z)
    /** point object, nothing fancy, just allows values to be
        passed back and forth by reference rather than by value.
        Other point classes may be used as long as they have
        x and y properties, which will get modified in the transform method.
    */
    function geocentricToWgs84(p, datum_type, datum_params) {
        if (datum_type === values_1.PJD_3PARAM) {
            // if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: p.x + datum_params[0],
                y: p.y + datum_params[1],
                z: p.z + datum_params[2],
            };
        }
        else if (datum_type === values_1.PJD_7PARAM) {
            var Dx_BF = datum_params[0];
            var Dy_BF = datum_params[1];
            var Dz_BF = datum_params[2];
            var Rx_BF = datum_params[3];
            var Ry_BF = datum_params[4];
            var Rz_BF = datum_params[5];
            var M_BF = datum_params[6];
            // if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: M_BF * (p.x - Rz_BF * p.y + Ry_BF * p.z) + Dx_BF,
                y: M_BF * (Rz_BF * p.x + p.y - Rx_BF * p.z) + Dy_BF,
                z: M_BF * (-Ry_BF * p.x + Rx_BF * p.y + p.z) + Dz_BF
            };
        }
    } // cs_geocentric_to_wgs84
    exports.geocentricToWgs84 = geocentricToWgs84;
    /****************************************************************/
    // pj_geocentic_from_wgs84()
    //  coordinate system definition,
    //  point to transform in geocentric coordinates (x,y,z)
    function geocentricFromWgs84(p, datum_type, datum_params) {
        if (datum_type === values_1.PJD_3PARAM) {
            //if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: p.x - datum_params[0],
                y: p.y - datum_params[1],
                z: p.z - datum_params[2],
            };
        }
        else if (datum_type === values_1.PJD_7PARAM) {
            var Dx_BF = datum_params[0];
            var Dy_BF = datum_params[1];
            var Dz_BF = datum_params[2];
            var Rx_BF = datum_params[3];
            var Ry_BF = datum_params[4];
            var Rz_BF = datum_params[5];
            var M_BF = datum_params[6];
            var x_tmp = (p.x - Dx_BF) / M_BF;
            var y_tmp = (p.y - Dy_BF) / M_BF;
            var z_tmp = (p.z - Dz_BF) / M_BF;
            //if( x[io] === HUGE_VAL )
            //    continue;
            return {
                x: x_tmp + Rz_BF * y_tmp - Ry_BF * z_tmp,
                y: -Rz_BF * x_tmp + y_tmp + Rx_BF * z_tmp,
                z: Ry_BF * x_tmp - Rx_BF * y_tmp + z_tmp
            };
        } //cs_geocentric_from_wgs84()
    }
    exports.geocentricFromWgs84 = geocentricFromWgs84;
},
/* proj4/lib/adjust_axis.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(crs, denorm, point) {
        var xin = point.x, yin = point.y, zin = point.z || 0.0;
        var v, t, i;
        var out = {};
        for (i = 0; i < 3; i++) {
            if (denorm && i === 2 && point.z === undefined) {
                continue;
            }
            if (i === 0) {
                v = xin;
                if ("ew".indexOf(crs.axis[i]) !== -1) {
                    t = 'x';
                }
                else {
                    t = 'y';
                }
            }
            else if (i === 1) {
                v = yin;
                if ("ns".indexOf(crs.axis[i]) !== -1) {
                    t = 'y';
                }
                else {
                    t = 'x';
                }
            }
            else {
                v = zin;
                t = 'z';
            }
            switch (crs.axis[i]) {
                case 'e':
                    out[t] = v;
                    break;
                case 'w':
                    out[t] = -v;
                    break;
                case 'n':
                    out[t] = v;
                    break;
                case 's':
                    out[t] = -v;
                    break;
                case 'u':
                    if (point[t] !== undefined) {
                        out.z = v;
                    }
                    break;
                case 'd':
                    if (point[t] !== undefined) {
                        out.z = -v;
                    }
                    break;
                default:
                    //console.log("ERROR: unknow axis ("+crs.axis[i]+") - check definition of "+crs.projName);
                    return null;
            }
        }
        return out;
    }
    exports.default = default_1;
},
/* proj4/lib/common/toPoint.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(array) {
        var out = {
            x: array[0],
            y: array[1]
        };
        if (array.length > 2) {
            out.z = array[2];
        }
        if (array.length > 3) {
            out.m = array[3];
        }
        return out;
    }
    exports.default = default_1;
},
/* proj4/lib/checkSanity.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function default_1(point) {
        checkCoord(point.x);
        checkCoord(point.y);
    }
    exports.default = default_1;
    function checkCoord(num) {
        if (typeof Number.isFinite === 'function') {
            if (Number.isFinite(num)) {
                return;
            }
            throw new TypeError('coordinates must be finite numbers');
        }
        if (typeof num !== 'number' || num !== num || !isFinite(num)) {
            throw new TypeError('coordinates must be finite numbers');
        }
    }
},
/* models/glyphs/glyph.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var p = tslib_1.__importStar(require(133) /* ../../core/properties */);
    var bbox = tslib_1.__importStar(require(214) /* ../../core/util/bbox */);
    var visuals = tslib_1.__importStar(require(160) /* ../../core/visuals */);
    var view_1 = require(157) /* ../../core/view */;
    var model_1 = require(168) /* ../../model */;
    var logging_1 = require(134) /* ../../core/logging */;
    var types_1 = require(139) /* ../../core/types */;
    var types_2 = require(123) /* ../../core/util/types */;
    var ragged_array_1 = require(215) /* ../../core/util/ragged_array */;
    var arrayable_1 = require(127) /* ../../core/util/arrayable */;
    var eq_1 = require(141) /* ../../core/util/eq */;
    var spatial_1 = require(216) /* ../../core/util/spatial */;
    var factor_range_1 = require(219) /* ../ranges/factor_range */;
    var selection_1 = require(174) /* ../selections/selection */;
    var abs = Math.abs, ceil = Math.ceil;
    var GlyphView = /** @class */ (function (_super) {
        tslib_1.__extends(GlyphView, _super);
        function GlyphView() {
            var _this = _super.apply(this, tslib_1.__spread(arguments)) || this;
            _this._index = null;
            _this._data_size = null;
            _this._nohit_warned = new Set();
            return _this;
        }
        Object.defineProperty(GlyphView.prototype, "renderer", {
            get: function () {
                return this.parent;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(GlyphView.prototype, "has_webgl", {
            get: function () {
                return this.glglyph != null;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(GlyphView.prototype, "index", {
            get: function () {
                var _index = this._index;
                if (_index != null)
                    return _index;
                else
                    throw new Error(this + ".index_data() wasn't called");
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(GlyphView.prototype, "data_size", {
            get: function () {
                var _data_size = this._data_size;
                if (_data_size != null)
                    return _data_size;
                else
                    throw new Error(this + ".set_data() wasn't called");
            },
            enumerable: false,
            configurable: true
        });
        GlyphView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.visuals = new visuals.Visuals(this);
        };
        GlyphView.prototype.request_render = function () {
            this.parent.request_render();
        };
        Object.defineProperty(GlyphView.prototype, "canvas", {
            get: function () {
                return this.renderer.parent.canvas_view;
            },
            enumerable: false,
            configurable: true
        });
        GlyphView.prototype.render = function (ctx, indices, data) {
            var _a;
            if (this.glglyph != null) {
                this.renderer.needs_webgl_blit = this.glglyph.render(ctx, indices, (_a = this.base) !== null && _a !== void 0 ? _a : this);
                if (this.renderer.needs_webgl_blit)
                    return;
            }
            ctx.beginPath();
            this._render(ctx, indices, data !== null && data !== void 0 ? data : this.base);
        };
        GlyphView.prototype.has_finished = function () {
            return true;
        };
        GlyphView.prototype.notify_finished = function () {
            this.renderer.notify_finished();
        };
        GlyphView.prototype._bounds = function (bounds) {
            return bounds;
        };
        GlyphView.prototype.bounds = function () {
            return this._bounds(this.index.bbox);
        };
        GlyphView.prototype.log_bounds = function () {
            var _a = this.index.bounds(bbox.positive_x()), x0 = _a.x0, x1 = _a.x1;
            var _b = this.index.bounds(bbox.positive_y()), y0 = _b.y0, y1 = _b.y1;
            return this._bounds({ x0: x0, y0: y0, x1: x1, y1: y1 });
        };
        GlyphView.prototype.get_anchor_point = function (anchor, i, _a) {
            var _b = tslib_1.__read(_a, 2), sx = _b[0], sy = _b[1];
            switch (anchor) {
                case "center":
                case "center_center": {
                    var _c = tslib_1.__read(this.scenterxy(i, sx, sy), 2), x = _c[0], y = _c[1];
                    return { x: x, y: y };
                }
                default:
                    return null;
            }
        };
        /** @deprecated */
        GlyphView.prototype.scenterx = function (i, sx, sy) {
            return this.scenterxy(i, sx, sy)[0];
        };
        /** @deprecated */
        GlyphView.prototype.scentery = function (i, sx, sy) {
            return this.scenterxy(i, sx, sy)[1];
        };
        GlyphView.prototype.sdist = function (scale, pts, spans, pts_location, dilate) {
            if (pts_location === void 0) {
                pts_location = "edge";
            }
            if (dilate === void 0) {
                dilate = false;
            }
            var n = pts.length;
            var sdist = new types_1.ScreenArray(n);
            var compute = scale.s_compute;
            if (pts_location == "center") {
                for (var i = 0; i < n; i++) {
                    var pts_i = pts[i];
                    var halfspan_i = spans.get(i) / 2;
                    var spt0 = compute(pts_i - halfspan_i);
                    var spt1 = compute(pts_i + halfspan_i);
                    sdist[i] = abs(spt1 - spt0);
                }
            }
            else {
                for (var i = 0; i < n; i++) {
                    var pts_i = pts[i];
                    var spt0 = compute(pts_i);
                    var spt1 = compute(pts_i + spans.get(i));
                    sdist[i] = abs(spt1 - spt0);
                }
            }
            if (dilate)
                arrayable_1.inplace_map(sdist, function (sd) { return ceil(sd); });
            return sdist;
        };
        GlyphView.prototype.draw_legend_for_index = function (_ctx, _bbox, _index) { };
        GlyphView.prototype.hit_test = function (geometry) {
            switch (geometry.type) {
                case "point":
                    if (this._hit_point != null)
                        return this._hit_point(geometry);
                    break;
                case "span":
                    if (this._hit_span != null)
                        return this._hit_span(geometry);
                    break;
                case "rect":
                    if (this._hit_rect != null)
                        return this._hit_rect(geometry);
                    break;
                case "poly":
                    if (this._hit_poly != null)
                        return this._hit_poly(geometry);
                    break;
            }
            if (!this._nohit_warned.has(geometry.type)) {
                logging_1.logger.debug("'" + geometry.type + "' selection not available for " + this.model.type);
                this._nohit_warned.add(geometry.type);
            }
            return null;
        };
        GlyphView.prototype._hit_rect_against_index = function (geometry) {
            var sx0 = geometry.sx0, sx1 = geometry.sx1, sy0 = geometry.sy0, sy1 = geometry.sy1;
            var _a = tslib_1.__read(this.renderer.coordinates.x_scale.r_invert(sx0, sx1), 2), x0 = _a[0], x1 = _a[1];
            var _b = tslib_1.__read(this.renderer.coordinates.y_scale.r_invert(sy0, sy1), 2), y0 = _b[0], y1 = _b[1];
            var indices = tslib_1.__spread(this.index.indices({ x0: x0, x1: x1, y0: y0, y1: y1 }));
            return new selection_1.Selection({ indices: indices });
        };
        GlyphView.prototype._project_data = function () { };
        GlyphView.prototype._iter_visuals = function () {
            var _a, _b, visual, visual_1, visual_1_1, prop, e_1_1, e_2_1;
            var e_2, _c, e_1, _d;
            return tslib_1.__generator(this, function (_e) {
                switch (_e.label) {
                    case 0:
                        _e.trys.push([0, 11, 12, 13]);
                        _a = tslib_1.__values(this.visuals), _b = _a.next();
                        _e.label = 1;
                    case 1:
                        if (!!_b.done)
                            return [3 /*break*/, 10];
                        visual = _b.value;
                        _e.label = 2;
                    case 2:
                        _e.trys.push([2, 7, 8, 9]);
                        visual_1 = (e_1 = void 0, tslib_1.__values(visual)), visual_1_1 = visual_1.next();
                        _e.label = 3;
                    case 3:
                        if (!!visual_1_1.done)
                            return [3 /*break*/, 6];
                        prop = visual_1_1.value;
                        if (!(prop instanceof p.VectorSpec || prop instanceof p.ScalarSpec))
                            return [3 /*break*/, 5];
                        return [4 /*yield*/, prop];
                    case 4:
                        _e.sent();
                        _e.label = 5;
                    case 5:
                        visual_1_1 = visual_1.next();
                        return [3 /*break*/, 3];
                    case 6: return [3 /*break*/, 9];
                    case 7:
                        e_1_1 = _e.sent();
                        e_1 = { error: e_1_1 };
                        return [3 /*break*/, 9];
                    case 8:
                        try {
                            if (visual_1_1 && !visual_1_1.done && (_d = visual_1.return))
                                _d.call(visual_1);
                        }
                        finally {
                            if (e_1)
                                throw e_1.error;
                        }
                        return [7 /*endfinally*/];
                    case 9:
                        _b = _a.next();
                        return [3 /*break*/, 1];
                    case 10: return [3 /*break*/, 13];
                    case 11:
                        e_2_1 = _e.sent();
                        e_2 = { error: e_2_1 };
                        return [3 /*break*/, 13];
                    case 12:
                        try {
                            if (_b && !_b.done && (_c = _a.return))
                                _c.call(_a);
                        }
                        finally {
                            if (e_2)
                                throw e_2.error;
                        }
                        return [7 /*endfinally*/];
                    case 13: return [2 /*return*/];
                }
            });
        };
        GlyphView.prototype.set_base = function (base) {
            if (base != this && base instanceof this.constructor)
                this.base = base;
        };
        GlyphView.prototype._configure = function (prop, descriptor) {
            Object.defineProperty(this, types_2.isString(prop) ? prop : prop.attr, tslib_1.__assign({ configurable: true, enumerable: true }, descriptor));
        };
        GlyphView.prototype.set_visuals = function (source, indices) {
            var e_3, _a, e_4, _b;
            var _c;
            var _loop_1 = function (prop) {
                var base = this_1.base;
                if (base != null) {
                    var base_prop = base.model.properties[prop.attr];
                    if (base_prop != null && eq_1.is_equal(prop.get_value(), base_prop.get_value())) {
                        this_1._configure(prop, {
                            get: function () { return base["" + prop.attr]; },
                        });
                        return "continue";
                    }
                }
                var uniform = prop.uniform(source).select(indices);
                this_1._configure(prop, { value: uniform });
            };
            var this_1 = this;
            try {
                for (var _d = tslib_1.__values(this._iter_visuals()), _e = _d.next(); !_e.done; _e = _d.next()) {
                    var prop = _e.value;
                    _loop_1(prop);
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (_e && !_e.done && (_a = _d.return))
                        _a.call(_d);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            try {
                for (var _f = tslib_1.__values(this.visuals), _g = _f.next(); !_g.done; _g = _f.next()) {
                    var visual = _g.value;
                    visual.update();
                }
            }
            catch (e_4_1) {
                e_4 = { error: e_4_1 };
            }
            finally {
                try {
                    if (_g && !_g.done && (_b = _f.return))
                        _b.call(_f);
                }
                finally {
                    if (e_4)
                        throw e_4.error;
                }
            }
            (_c = this.glglyph) === null || _c === void 0 ? void 0 : _c.set_visuals_changed();
        };
        GlyphView.prototype.set_data = function (source, indices, indices_to_update) {
            var e_5, _a;
            var _b;
            var _c = this.renderer.coordinates, x_range = _c.x_range, y_range = _c.y_range;
            var visual_props = new Set(this._iter_visuals());
            this._data_size = indices.count;
            try {
                for (var _d = tslib_1.__values(this.model), _e = _d.next(); !_e.done; _e = _d.next()) {
                    var prop = _e.value;
                    if (!(prop instanceof p.VectorSpec || prop instanceof p.ScalarSpec))
                        continue;
                    if (visual_props.has(prop)) // let set_visuals() do the work, at least for now
                        continue;
                    if (prop instanceof p.BaseCoordinateSpec) {
                        var base_array = prop.array(source);
                        var array = indices.select(base_array);
                        var range = prop.dimension == "x" ? x_range : y_range;
                        if (range instanceof factor_range_1.FactorRange) {
                            if (prop instanceof p.CoordinateSpec) {
                                array = range.v_synthetic(array);
                            }
                            else if (prop instanceof p.CoordinateSeqSpec) {
                                for (var i = 0; i < array.length; i++) {
                                    array[i] = range.v_synthetic(array[i]);
                                }
                            }
                        }
                        var final_array = void 0;
                        if (prop instanceof p.CoordinateSeqSpec) {
                            // TODO: infer precision
                            final_array = ragged_array_1.RaggedArray.from(array, Float64Array);
                        }
                        else
                            final_array = array;
                        this._configure("_" + prop.attr, { value: final_array });
                    }
                    else {
                        var uniform = prop.uniform(source).select(indices);
                        this._configure(prop, { value: uniform });
                        if (prop instanceof p.DistanceSpec) {
                            var max_value = uniform.is_Scalar() ? uniform.value : arrayable_1.max(uniform.array);
                            this._configure("max_" + prop.attr, { value: max_value });
                        }
                    }
                }
            }
            catch (e_5_1) {
                e_5 = { error: e_5_1 };
            }
            finally {
                try {
                    if (_e && !_e.done && (_a = _d.return))
                        _a.call(_d);
                }
                finally {
                    if (e_5)
                        throw e_5.error;
                }
            }
            if (this.renderer.plot_view.model.use_map) {
                this._project_data();
            }
            this._set_data(indices_to_update !== null && indices_to_update !== void 0 ? indices_to_update : null); // TODO doesn't take subset indices into account
            (_b = this.glglyph) === null || _b === void 0 ? void 0 : _b.set_data_changed();
            this.index_data();
        };
        GlyphView.prototype._set_data = function (_indices) { };
        Object.defineProperty(GlyphView.prototype, "_index_size", {
            get: function () {
                return this.data_size;
            },
            enumerable: false,
            configurable: true
        });
        GlyphView.prototype.index_data = function () {
            var index = new spatial_1.SpatialIndex(this._index_size);
            this._index_data(index);
            index.finish();
            this._index = index;
        };
        GlyphView.prototype.mask_data = function () {
            /** Returns subset indices in the viewport. */
            if (this._mask_data == null)
                return types_1.Indices.all_set(this.data_size);
            else
                return this._mask_data();
        };
        GlyphView.prototype.map_data = function () {
            var e_6, _a;
            var _b;
            var self = this;
            var _c = this.renderer.coordinates, x_scale = _c.x_scale, y_scale = _c.y_scale;
            try {
                for (var _d = tslib_1.__values(this.model), _e = _d.next(); !_e.done; _e = _d.next()) {
                    var prop = _e.value;
                    if (prop instanceof p.BaseCoordinateSpec) {
                        var scale = prop.dimension == "x" ? x_scale : y_scale;
                        var array = self["_" + prop.attr];
                        if (array instanceof ragged_array_1.RaggedArray) {
                            var screen = scale.v_compute(array.array);
                            array = new ragged_array_1.RaggedArray(array.offsets, screen);
                        }
                        else {
                            array = scale.v_compute(array);
                        }
                        this["s" + prop.attr] = array;
                    }
                }
            }
            catch (e_6_1) {
                e_6 = { error: e_6_1 };
            }
            finally {
                try {
                    if (_e && !_e.done && (_a = _d.return))
                        _a.call(_d);
                }
                finally {
                    if (e_6)
                        throw e_6.error;
                }
            }
            this._map_data();
            (_b = this.glglyph) === null || _b === void 0 ? void 0 : _b.set_data_changed();
        };
        // This is where specs not included in coords are computed, e.g. radius.
        GlyphView.prototype._map_data = function () { };
        return GlyphView;
    }(view_1.View));
    exports.GlyphView = GlyphView;
    GlyphView.__name__ = "GlyphView";
    var Glyph = /** @class */ (function (_super) {
        tslib_1.__extends(Glyph, _super);
        function Glyph(attrs) {
            return _super.call(this, attrs) || this;
        }
        return Glyph;
    }(model_1.Model));
    exports.Glyph = Glyph;
    Glyph.__name__ = "Glyph";
},
/* core/util/bbox.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var types_1 = require(139) /* ../types */;
    var eq_1 = require(141) /* ./eq */;
    var min = Math.min, max = Math.max;
    function empty() {
        return {
            x0: Infinity,
            y0: Infinity,
            x1: -Infinity,
            y1: -Infinity,
        };
    }
    exports.empty = empty;
    function positive_x() {
        return {
            x0: Number.MIN_VALUE,
            y0: -Infinity,
            x1: Infinity,
            y1: Infinity,
        };
    }
    exports.positive_x = positive_x;
    function positive_y() {
        return {
            x0: -Infinity,
            y0: Number.MIN_VALUE,
            x1: Infinity,
            y1: Infinity,
        };
    }
    exports.positive_y = positive_y;
    function union(a, b) {
        return {
            x0: min(a.x0, b.x0),
            x1: max(a.x1, b.x1),
            y0: min(a.y0, b.y0),
            y1: max(a.y1, b.y1),
        };
    }
    exports.union = union;
    var BBox = /** @class */ (function () {
        function BBox(box) {
            if (box == null) {
                this.x0 = 0;
                this.y0 = 0;
                this.x1 = 0;
                this.y1 = 0;
            }
            else if ('x0' in box) {
                var x0 = box.x0, y0 = box.y0, x1 = box.x1, y1 = box.y1;
                if (!(x0 <= x1 && y0 <= y1))
                    throw new Error("invalid bbox {x0: " + x0 + ", y0: " + y0 + ", x1: " + x1 + ", y1: " + y1 + "}");
                this.x0 = x0;
                this.y0 = y0;
                this.x1 = x1;
                this.y1 = y1;
            }
            else if ("x" in box) {
                var x = box.x, y = box.y, width = box.width, height = box.height;
                if (!(width >= 0 && height >= 0))
                    throw new Error("invalid bbox {x: " + x + ", y: " + y + ", width: " + width + ", height: " + height + "}");
                this.x0 = x;
                this.y0 = y;
                this.x1 = x + width;
                this.y1 = y + height;
            }
            else {
                var left = void 0, right = void 0;
                var top = void 0, bottom = void 0;
                if ("width" in box) {
                    if ("left" in box) {
                        left = box.left;
                        right = left + box.width;
                    }
                    else if ("right" in box) {
                        right = box.right;
                        left = right - box.width;
                    }
                    else {
                        var w2 = box.width / 2;
                        left = box.hcenter - w2;
                        right = box.hcenter + w2;
                    }
                }
                else {
                    left = box.left;
                    right = box.right;
                }
                if ("height" in box) {
                    if ("top" in box) {
                        top = box.top;
                        bottom = top + box.height;
                    }
                    else if ("bottom" in box) {
                        bottom = box.bottom;
                        top = bottom - box.height;
                    }
                    else {
                        var h2 = box.height / 2;
                        top = box.vcenter - h2;
                        bottom = box.vcenter + h2;
                    }
                }
                else {
                    top = box.top;
                    bottom = box.bottom;
                }
                if (!(left <= right && top <= bottom))
                    throw new Error("invalid bbox {left: " + left + ", top: " + top + ", right: " + right + ", bottom: " + bottom + "}");
                this.x0 = left;
                this.y0 = top;
                this.x1 = right;
                this.y1 = bottom;
            }
        }
        BBox.from_rect = function (_a) {
            var left = _a.left, right = _a.right, top = _a.top, bottom = _a.bottom;
            return new BBox({
                x0: Math.min(left, right),
                y0: Math.min(top, bottom),
                x1: Math.max(left, right),
                y1: Math.max(top, bottom),
            });
        };
        BBox.prototype.equals = function (that) {
            return this.x0 == that.x0 && this.y0 == that.y0 &&
                this.x1 == that.x1 && this.y1 == that.y1;
        };
        BBox.prototype[eq_1.equals] = function (that, cmp) {
            return cmp.eq(this.x0, that.x0) && cmp.eq(this.y0, that.y0) &&
                cmp.eq(this.x1, that.x1) && cmp.eq(this.y1, that.y1);
        };
        BBox.prototype.toString = function () {
            return "BBox({left: " + this.left + ", top: " + this.top + ", width: " + this.width + ", height: " + this.height + "})";
        };
        Object.defineProperty(BBox.prototype, "left", {
            get: function () { return this.x0; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "top", {
            get: function () { return this.y0; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "right", {
            get: function () { return this.x1; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "bottom", {
            get: function () { return this.y1; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "p0", {
            get: function () { return [this.x0, this.y0]; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "p1", {
            get: function () { return [this.x1, this.y1]; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "x", {
            get: function () { return this.x0; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "y", {
            get: function () { return this.y0; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "width", {
            get: function () { return this.x1 - this.x0; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "height", {
            get: function () { return this.y1 - this.y0; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "size", {
            get: function () { return { width: this.width, height: this.height }; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "rect", {
            get: function () {
                var _a = this, x0 = _a.x0, y0 = _a.y0, x1 = _a.x1, y1 = _a.y1;
                return {
                    p0: { x: x0, y: y0 },
                    p1: { x: x1, y: y0 },
                    p2: { x: x1, y: y1 },
                    p3: { x: x0, y: y1 },
                };
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "box", {
            get: function () {
                var _a = this, x = _a.x, y = _a.y, width = _a.width, height = _a.height;
                return { x: x, y: y, width: width, height: height };
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "h_range", {
            get: function () { return { start: this.x0, end: this.x1 }; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "v_range", {
            get: function () { return { start: this.y0, end: this.y1 }; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "ranges", {
            get: function () { return [this.h_range, this.v_range]; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "aspect", {
            get: function () { return this.width / this.height; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "hcenter", {
            get: function () { return (this.left + this.right) / 2; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "vcenter", {
            get: function () { return (this.top + this.bottom) / 2; },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "area", {
            get: function () { return this.width * this.height; },
            enumerable: false,
            configurable: true
        });
        BBox.prototype.relative = function () {
            var _a = this, width = _a.width, height = _a.height;
            return new BBox({ x: 0, y: 0, width: width, height: height });
        };
        BBox.prototype.translate = function (tx, ty) {
            var _a = this, x = _a.x, y = _a.y, width = _a.width, height = _a.height;
            return new BBox({ x: tx + x, y: ty + y, width: width, height: height });
        };
        BBox.prototype.relativize = function (x, y) {
            return [x - this.x, y - this.y];
        };
        BBox.prototype.contains = function (x, y) {
            return this.x0 <= x && x <= this.x1 && this.y0 <= y && y <= this.y1;
        };
        BBox.prototype.clip = function (x, y) {
            if (x < this.x0)
                x = this.x0;
            else if (x > this.x1)
                x = this.x1;
            if (y < this.y0)
                y = this.y0;
            else if (y > this.y1)
                y = this.y1;
            return [x, y];
        };
        BBox.prototype.grow_by = function (size) {
            return new BBox({
                left: this.left - size,
                right: this.right + size,
                top: this.top - size,
                bottom: this.bottom + size,
            });
        };
        BBox.prototype.shrink_by = function (size) {
            return new BBox({
                left: this.left + size,
                right: this.right - size,
                top: this.top + size,
                bottom: this.bottom - size,
            });
        };
        BBox.prototype.union = function (that) {
            return new BBox({
                x0: min(this.x0, that.x0),
                y0: min(this.y0, that.y0),
                x1: max(this.x1, that.x1),
                y1: max(this.y1, that.y1),
            });
        };
        BBox.prototype.intersection = function (that) {
            if (!this.intersects(that))
                return null;
            else {
                return new BBox({
                    x0: max(this.x0, that.x0),
                    y0: max(this.y0, that.y0),
                    x1: min(this.x1, that.x1),
                    y1: min(this.y1, that.y1),
                });
            }
        };
        BBox.prototype.intersects = function (that) {
            return !(that.x1 < this.x0 || that.x0 > this.x1 ||
                that.y1 < this.y0 || that.y0 > this.y1);
        };
        Object.defineProperty(BBox.prototype, "xview", {
            get: function () {
                var _this = this;
                return {
                    compute: function (x) {
                        return _this.left + x;
                    },
                    v_compute: function (xx) {
                        var _xx = new types_1.ScreenArray(xx.length);
                        var left = _this.left;
                        for (var i = 0; i < xx.length; i++) {
                            _xx[i] = left + xx[i];
                        }
                        return _xx;
                    },
                };
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, "yview", {
            get: function () {
                var _this = this;
                return {
                    compute: function (y) {
                        return _this.bottom - y;
                    },
                    v_compute: function (yy) {
                        var _yy = new types_1.ScreenArray(yy.length);
                        var bottom = _this.bottom;
                        for (var i = 0; i < yy.length; i++) {
                            _yy[i] = bottom - yy[i];
                        }
                        return _yy;
                    },
                };
            },
            enumerable: false,
            configurable: true
        });
        return BBox;
    }());
    exports.BBox = BBox;
    BBox.__name__ = "BBox";
},
/* core/util/ragged_array.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var eq_1 = require(141) /* ./eq */;
    var assert_1 = require(126) /* ./assert */;
    var RaggedArray = /** @class */ (function () {
        function RaggedArray(offsets, array) {
            this.offsets = offsets;
            this.array = array;
        }
        RaggedArray.prototype[eq_1.equals] = function (that, cmp) {
            return cmp.arrays(this.offsets, that.offsets) && cmp.arrays(this.array, that.array);
        };
        Object.defineProperty(RaggedArray.prototype, "length", {
            get: function () {
                return this.offsets.length;
            },
            enumerable: false,
            configurable: true
        });
        RaggedArray.prototype.clone = function () {
            return new RaggedArray(this.offsets.slice(), this.array.slice());
        };
        RaggedArray.from = function (items, ctor) {
            var n = items.length;
            var offset = 0;
            var offsets = (function () {
                var offsets = new Uint32Array(n);
                for (var i = 0; i < n; i++) {
                    var length = items[i].length;
                    offsets[i] = offset;
                    offset += length;
                }
                if (offset < 256)
                    return new Uint8Array(offsets);
                else if (offset < 65536)
                    return new Uint16Array(offsets);
                else
                    return offsets;
            })();
            var array = new ctor(offset);
            for (var i = 0; i < n; i++) {
                array.set(items[i], offsets[i]);
            }
            return new RaggedArray(offsets, array);
        };
        RaggedArray.prototype[Symbol.iterator] = function () {
            var _a, offsets, length, i;
            return tslib_1.__generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        _a = this, offsets = _a.offsets, length = _a.length;
                        i = 0;
                        _b.label = 1;
                    case 1:
                        if (!(i < length))
                            return [3 /*break*/, 4];
                        return [4 /*yield*/, this.array.subarray(offsets[i], offsets[i + 1])];
                    case 2:
                        _b.sent();
                        _b.label = 3;
                    case 3:
                        i++;
                        return [3 /*break*/, 1];
                    case 4: return [2 /*return*/];
                }
            });
        };
        RaggedArray.prototype._check_bounds = function (i) {
            assert_1.assert(0 <= i && i < this.length, "Out of bounds: 0 <= " + i + " < " + this.length);
        };
        RaggedArray.prototype.get = function (i) {
            this._check_bounds(i);
            var offsets = this.offsets;
            return this.array.subarray(offsets[i], offsets[i + 1]);
        };
        RaggedArray.prototype.set = function (i, array) {
            this._check_bounds(i);
            this.array.set(array, this.offsets[i]);
        };
        return RaggedArray;
    }());
    exports.RaggedArray = RaggedArray;
    RaggedArray.__name__ = "RaggedArray";
    RaggedArray[Symbol.toStringTag] = "RaggedArray";
},
/* core/util/spatial.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var flatbush_1 = tslib_1.__importDefault(require(217) /* flatbush */);
    var types_1 = require(139) /* ../types */;
    var bbox_1 = require(214) /* ./bbox */;
    function upperBound(value, arr) {
        var i = 0;
        var j = arr.length - 1;
        while (i < j) {
            var m = (i + j) >> 1;
            if (arr[m] > value) {
                j = m;
            }
            else {
                i = m + 1;
            }
        }
        return arr[i];
    }
    var _FlatBush = /** @class */ (function (_super) {
        tslib_1.__extends(_FlatBush, _super);
        function _FlatBush() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        _FlatBush.prototype.search_indices = function (minX, minY, maxX, maxY) {
            if (this._pos !== this._boxes.length) {
                throw new Error('Data not yet indexed - call index.finish().');
            }
            var nodeIndex = this._boxes.length - 4;
            var queue = [];
            var results = new types_1.Indices(this.numItems);
            while (nodeIndex !== undefined) {
                // find the end index of the node
                var end = Math.min(nodeIndex + this.nodeSize * 4, upperBound(nodeIndex, this._levelBounds));
                // search through child nodes
                for (var pos = nodeIndex; pos < end; pos += 4) {
                    var index = this._indices[pos >> 2] | 0;
                    // check if node bbox intersects with query bbox
                    if (maxX < this._boxes[pos + 0])
                        continue; // maxX < nodeMinX
                    if (maxY < this._boxes[pos + 1])
                        continue; // maxY < nodeMinY
                    if (minX > this._boxes[pos + 2])
                        continue; // minX > nodeMaxX
                    if (minY > this._boxes[pos + 3])
                        continue; // minY > nodeMaxY
                    if (nodeIndex < this.numItems * 4) {
                        results.set(index); // leaf item
                    }
                    else {
                        queue.push(index); // node; add it to the search queue
                    }
                }
                nodeIndex = queue.pop();
            }
            return results;
        };
        return _FlatBush;
    }(flatbush_1.default));
    _FlatBush.__name__ = "_FlatBush";
    var SpatialIndex = /** @class */ (function () {
        function SpatialIndex(size) {
            this.index = null;
            if (size > 0) {
                this.index = new _FlatBush(size);
            }
        }
        SpatialIndex.prototype.add = function (x0, y0, x1, y1) {
            var _a;
            (_a = this.index) === null || _a === void 0 ? void 0 : _a.add(x0, y0, x1, y1);
        };
        SpatialIndex.prototype.add_empty = function () {
            var _a;
            (_a = this.index) === null || _a === void 0 ? void 0 : _a.add(Infinity, Infinity, -Infinity, -Infinity);
        };
        SpatialIndex.prototype.finish = function () {
            var _a;
            (_a = this.index) === null || _a === void 0 ? void 0 : _a.finish();
        };
        SpatialIndex.prototype._normalize = function (rect) {
            var _a, _b;
            var x0 = rect.x0, y0 = rect.y0, x1 = rect.x1, y1 = rect.y1;
            if (x0 > x1)
                _a = tslib_1.__read([x1, x0], 2), x0 = _a[0], x1 = _a[1];
            if (y0 > y1)
                _b = tslib_1.__read([y1, y0], 2), y0 = _b[0], y1 = _b[1];
            return { x0: x0, y0: y0, x1: x1, y1: y1 };
        };
        Object.defineProperty(SpatialIndex.prototype, "bbox", {
            get: function () {
                if (this.index == null)
                    return bbox_1.empty();
                else {
                    var _a = this.index, minX = _a.minX, minY = _a.minY, maxX = _a.maxX, maxY = _a.maxY;
                    return { x0: minX, y0: minY, x1: maxX, y1: maxY };
                }
            },
            enumerable: false,
            configurable: true
        });
        SpatialIndex.prototype.indices = function (rect) {
            if (this.index == null)
                return new types_1.Indices(0);
            else {
                var _a = this._normalize(rect), x0 = _a.x0, y0 = _a.y0, x1 = _a.x1, y1 = _a.y1;
                return this.index.search_indices(x0, y0, x1, y1);
            }
        };
        SpatialIndex.prototype.bounds = function (rect) {
            var e_1, _a;
            var bounds = bbox_1.empty();
            try {
                for (var _b = tslib_1.__values(this.indices(rect)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var i = _c.value;
                    var boxes = this.index._boxes;
                    var x1 = boxes[4 * i + 0];
                    var y1 = boxes[4 * i + 1];
                    var x0 = boxes[4 * i + 2];
                    var y0 = boxes[4 * i + 3];
                    if (x0 < bounds.x0)
                        bounds.x0 = x0;
                    if (x1 > bounds.x1)
                        bounds.x1 = x1;
                    if (y0 < bounds.y0)
                        bounds.y0 = y0;
                    if (y1 > bounds.y1)
                        bounds.y1 = y1;
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            return bounds;
        };
        return SpatialIndex;
    }());
    exports.SpatialIndex = SpatialIndex;
    SpatialIndex.__name__ = "SpatialIndex";
},
/* flatbush/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var flatqueue_1 = tslib_1.__importDefault(require(218) /* flatqueue */);
    var ARRAY_TYPES = [
        Int8Array, Uint8Array, Uint8ClampedArray, Int16Array, Uint16Array,
        Int32Array, Uint32Array, Float32Array, Float64Array
    ];
    var VERSION = 3; // serialized format version
    var Flatbush = /** @class */ (function () {
        function Flatbush(numItems, nodeSize, ArrayType, data) {
            if (nodeSize === void 0) {
                nodeSize = 16;
            }
            if (ArrayType === void 0) {
                ArrayType = Float64Array;
            }
            if (numItems === undefined)
                throw new Error('Missing required argument: numItems.');
            if (isNaN(numItems) || numItems <= 0)
                throw new Error("Unpexpected numItems value: " + numItems + ".");
            this.numItems = +numItems;
            this.nodeSize = Math.min(Math.max(+nodeSize, 2), 65535);
            // calculate the total number of nodes in the R-tree to allocate space for
            // and the index of each tree level (used in search later)
            var n = numItems;
            var numNodes = n;
            this._levelBounds = [n * 4];
            do {
                n = Math.ceil(n / this.nodeSize);
                numNodes += n;
                this._levelBounds.push(numNodes * 4);
            } while (n !== 1);
            this.ArrayType = ArrayType || Float64Array;
            this.IndexArrayType = numNodes < 16384 ? Uint16Array : Uint32Array;
            var arrayTypeIndex = ARRAY_TYPES.indexOf(this.ArrayType);
            var nodesByteSize = numNodes * 4 * this.ArrayType.BYTES_PER_ELEMENT;
            if (arrayTypeIndex < 0) {
                throw new Error("Unexpected typed array class: " + ArrayType + ".");
            }
            if (data && (data instanceof ArrayBuffer)) {
                this.data = data;
                this._boxes = new this.ArrayType(this.data, 8, numNodes * 4);
                this._indices = new this.IndexArrayType(this.data, 8 + nodesByteSize, numNodes);
                this._pos = numNodes * 4;
                this.minX = this._boxes[this._pos - 4];
                this.minY = this._boxes[this._pos - 3];
                this.maxX = this._boxes[this._pos - 2];
                this.maxY = this._boxes[this._pos - 1];
            }
            else {
                this.data = new ArrayBuffer(8 + nodesByteSize + numNodes * this.IndexArrayType.BYTES_PER_ELEMENT);
                this._boxes = new this.ArrayType(this.data, 8, numNodes * 4);
                this._indices = new this.IndexArrayType(this.data, 8 + nodesByteSize, numNodes);
                this._pos = 0;
                this.minX = Infinity;
                this.minY = Infinity;
                this.maxX = -Infinity;
                this.maxY = -Infinity;
                new Uint8Array(this.data, 0, 2).set([0xfb, (VERSION << 4) + arrayTypeIndex]);
                new Uint16Array(this.data, 2, 1)[0] = nodeSize;
                new Uint32Array(this.data, 4, 1)[0] = numItems;
            }
            // a priority queue for k-nearest-neighbors queries
            this._queue = new flatqueue_1.default();
        }
        Flatbush.from = function (data) {
            if (!(data instanceof ArrayBuffer)) {
                throw new Error('Data must be an instance of ArrayBuffer.');
            }
            var _a = tslib_1.__read(new Uint8Array(data, 0, 2), 2), magic = _a[0], versionAndType = _a[1];
            if (magic !== 0xfb) {
                throw new Error('Data does not appear to be in a Flatbush format.');
            }
            if (versionAndType >> 4 !== VERSION) {
                throw new Error("Got v" + (versionAndType >> 4) + " data when expected v" + VERSION + ".");
            }
            var _b = tslib_1.__read(new Uint16Array(data, 2, 1), 1), nodeSize = _b[0];
            var _c = tslib_1.__read(new Uint32Array(data, 4, 1), 1), numItems = _c[0];
            return new Flatbush(numItems, nodeSize, ARRAY_TYPES[versionAndType & 0x0f], data);
        };
        Flatbush.prototype.add = function (minX, minY, maxX, maxY) {
            var index = this._pos >> 2;
            this._indices[index] = index;
            this._boxes[this._pos++] = minX;
            this._boxes[this._pos++] = minY;
            this._boxes[this._pos++] = maxX;
            this._boxes[this._pos++] = maxY;
            if (minX < this.minX)
                this.minX = minX;
            if (minY < this.minY)
                this.minY = minY;
            if (maxX > this.maxX)
                this.maxX = maxX;
            if (maxY > this.maxY)
                this.maxY = maxY;
            return index;
        };
        Flatbush.prototype.finish = function () {
            if (this._pos >> 2 !== this.numItems) {
                throw new Error("Added " + (this._pos >> 2) + " items when expected " + this.numItems + ".");
            }
            if (this.numItems <= this.nodeSize) {
                // only one node, skip sorting and just fill the root box
                this._boxes[this._pos++] = this.minX;
                this._boxes[this._pos++] = this.minY;
                this._boxes[this._pos++] = this.maxX;
                this._boxes[this._pos++] = this.maxY;
                return;
            }
            var width = this.maxX - this.minX;
            var height = this.maxY - this.minY;
            var hilbertValues = new Uint32Array(this.numItems);
            var hilbertMax = (1 << 16) - 1;
            // map item centers into Hilbert coordinate space and calculate Hilbert values
            for (var i = 0; i < this.numItems; i++) {
                var pos = 4 * i;
                var minX = this._boxes[pos++];
                var minY = this._boxes[pos++];
                var maxX = this._boxes[pos++];
                var maxY = this._boxes[pos++];
                var x = Math.floor(hilbertMax * ((minX + maxX) / 2 - this.minX) / width);
                var y = Math.floor(hilbertMax * ((minY + maxY) / 2 - this.minY) / height);
                hilbertValues[i] = hilbert(x, y);
            }
            // sort items by their Hilbert value (for packing later)
            sort(hilbertValues, this._boxes, this._indices, 0, this.numItems - 1, this.nodeSize);
            // generate nodes at each tree level, bottom-up
            for (var i = 0, pos = 0; i < this._levelBounds.length - 1; i++) {
                var end = this._levelBounds[i];
                // generate a parent node for each block of consecutive <nodeSize> nodes
                while (pos < end) {
                    var nodeIndex = pos;
                    // calculate bbox for the new node
                    var nodeMinX = Infinity;
                    var nodeMinY = Infinity;
                    var nodeMaxX = -Infinity;
                    var nodeMaxY = -Infinity;
                    for (var i_1 = 0; i_1 < this.nodeSize && pos < end; i_1++) {
                        nodeMinX = Math.min(nodeMinX, this._boxes[pos++]);
                        nodeMinY = Math.min(nodeMinY, this._boxes[pos++]);
                        nodeMaxX = Math.max(nodeMaxX, this._boxes[pos++]);
                        nodeMaxY = Math.max(nodeMaxY, this._boxes[pos++]);
                    }
                    // add the new node to the tree data
                    this._indices[this._pos >> 2] = nodeIndex;
                    this._boxes[this._pos++] = nodeMinX;
                    this._boxes[this._pos++] = nodeMinY;
                    this._boxes[this._pos++] = nodeMaxX;
                    this._boxes[this._pos++] = nodeMaxY;
                }
            }
        };
        Flatbush.prototype.search = function (minX, minY, maxX, maxY, filterFn) {
            if (this._pos !== this._boxes.length) {
                throw new Error('Data not yet indexed - call index.finish().');
            }
            var nodeIndex = this._boxes.length - 4;
            var queue = [];
            var results = [];
            while (nodeIndex !== undefined) {
                // find the end index of the node
                var end = Math.min(nodeIndex + this.nodeSize * 4, upperBound(nodeIndex, this._levelBounds));
                // search through child nodes
                for (var pos = nodeIndex; pos < end; pos += 4) {
                    var index = this._indices[pos >> 2] | 0;
                    // check if node bbox intersects with query bbox
                    if (maxX < this._boxes[pos])
                        continue; // maxX < nodeMinX
                    if (maxY < this._boxes[pos + 1])
                        continue; // maxY < nodeMinY
                    if (minX > this._boxes[pos + 2])
                        continue; // minX > nodeMaxX
                    if (minY > this._boxes[pos + 3])
                        continue; // minY > nodeMaxY
                    if (nodeIndex < this.numItems * 4) {
                        if (filterFn === undefined || filterFn(index)) {
                            results.push(index); // leaf item
                        }
                    }
                    else {
                        queue.push(index); // node; add it to the search queue
                    }
                }
                nodeIndex = queue.pop();
            }
            return results;
        };
        Flatbush.prototype.neighbors = function (x, y, maxResults, maxDistance, filterFn) {
            if (maxResults === void 0) {
                maxResults = Infinity;
            }
            if (maxDistance === void 0) {
                maxDistance = Infinity;
            }
            if (this._pos !== this._boxes.length) {
                throw new Error('Data not yet indexed - call index.finish().');
            }
            var nodeIndex = this._boxes.length - 4;
            var q = this._queue;
            var results = [];
            var maxDistSquared = maxDistance * maxDistance;
            while (nodeIndex !== undefined) {
                // find the end index of the node
                var end = Math.min(nodeIndex + this.nodeSize * 4, upperBound(nodeIndex, this._levelBounds));
                // add child nodes to the queue
                for (var pos = nodeIndex; pos < end; pos += 4) {
                    var index = this._indices[pos >> 2] | 0;
                    var dx = axisDist(x, this._boxes[pos], this._boxes[pos + 2]);
                    var dy = axisDist(y, this._boxes[pos + 1], this._boxes[pos + 3]);
                    var dist = dx * dx + dy * dy;
                    if (nodeIndex < this.numItems * 4) { // leaf node
                        if (filterFn === undefined || filterFn(index)) {
                            // put a negative index if it's an item rather than a node, to recognize later
                            q.push(-index - 1, dist);
                        }
                    }
                    else {
                        q.push(index, dist);
                    }
                }
                // pop items from the queue
                while (q.length && q.peek() < 0) {
                    var dist = q.peekValue();
                    if (dist > maxDistSquared) {
                        q.clear();
                        return results;
                    }
                    results.push(-q.pop() - 1);
                    if (results.length === maxResults) {
                        q.clear();
                        return results;
                    }
                }
                nodeIndex = q.pop();
            }
            q.clear();
            return results;
        };
        return Flatbush;
    }());
    exports.default = Flatbush;
    function axisDist(k, min, max) {
        return k < min ? min - k : k <= max ? 0 : k - max;
    }
    // binary search for the first value in the array bigger than the given
    function upperBound(value, arr) {
        var i = 0;
        var j = arr.length - 1;
        while (i < j) {
            var m = (i + j) >> 1;
            if (arr[m] > value) {
                j = m;
            }
            else {
                i = m + 1;
            }
        }
        return arr[i];
    }
    // custom quicksort that partially sorts bbox data alongside the hilbert values
    function sort(values, boxes, indices, left, right, nodeSize) {
        if (Math.floor(left / nodeSize) >= Math.floor(right / nodeSize))
            return;
        var pivot = values[(left + right) >> 1];
        var i = left - 1;
        var j = right + 1;
        while (true) {
            do
                i++;
            while (values[i] < pivot);
            do
                j--;
            while (values[j] > pivot);
            if (i >= j)
                break;
            swap(values, boxes, indices, i, j);
        }
        sort(values, boxes, indices, left, j, nodeSize);
        sort(values, boxes, indices, j + 1, right, nodeSize);
    }
    // swap two values and two corresponding boxes
    function swap(values, boxes, indices, i, j) {
        var temp = values[i];
        values[i] = values[j];
        values[j] = temp;
        var k = 4 * i;
        var m = 4 * j;
        var a = boxes[k];
        var b = boxes[k + 1];
        var c = boxes[k + 2];
        var d = boxes[k + 3];
        boxes[k] = boxes[m];
        boxes[k + 1] = boxes[m + 1];
        boxes[k + 2] = boxes[m + 2];
        boxes[k + 3] = boxes[m + 3];
        boxes[m] = a;
        boxes[m + 1] = b;
        boxes[m + 2] = c;
        boxes[m + 3] = d;
        var e = indices[i];
        indices[i] = indices[j];
        indices[j] = e;
    }
    // Fast Hilbert curve algorithm by http://threadlocalmutex.com/
    // Ported from C++ https://github.com/rawrunprotected/hilbert_curves (public domain)
    function hilbert(x, y) {
        var a = x ^ y;
        var b = 0xFFFF ^ a;
        var c = 0xFFFF ^ (x | y);
        var d = x & (y ^ 0xFFFF);
        var A = a | (b >> 1);
        var B = (a >> 1) ^ a;
        var C = ((c >> 1) ^ (b & (d >> 1))) ^ c;
        var D = ((a & (c >> 1)) ^ (d >> 1)) ^ d;
        a = A;
        b = B;
        c = C;
        d = D;
        A = ((a & (a >> 2)) ^ (b & (b >> 2)));
        B = ((a & (b >> 2)) ^ (b & ((a ^ b) >> 2)));
        C ^= ((a & (c >> 2)) ^ (b & (d >> 2)));
        D ^= ((b & (c >> 2)) ^ ((a ^ b) & (d >> 2)));
        a = A;
        b = B;
        c = C;
        d = D;
        A = ((a & (a >> 4)) ^ (b & (b >> 4)));
        B = ((a & (b >> 4)) ^ (b & ((a ^ b) >> 4)));
        C ^= ((a & (c >> 4)) ^ (b & (d >> 4)));
        D ^= ((b & (c >> 4)) ^ ((a ^ b) & (d >> 4)));
        a = A;
        b = B;
        c = C;
        d = D;
        C ^= ((a & (c >> 8)) ^ (b & (d >> 8)));
        D ^= ((b & (c >> 8)) ^ ((a ^ b) & (d >> 8)));
        a = C ^ (C >> 1);
        b = D ^ (D >> 1);
        var i0 = x ^ y;
        var i1 = b | (0xFFFF ^ (i0 | a));
        i0 = (i0 | (i0 << 8)) & 0x00FF00FF;
        i0 = (i0 | (i0 << 4)) & 0x0F0F0F0F;
        i0 = (i0 | (i0 << 2)) & 0x33333333;
        i0 = (i0 | (i0 << 1)) & 0x55555555;
        i1 = (i1 | (i1 << 8)) & 0x00FF00FF;
        i1 = (i1 | (i1 << 4)) & 0x0F0F0F0F;
        i1 = (i1 | (i1 << 2)) & 0x33333333;
        i1 = (i1 | (i1 << 1)) & 0x55555555;
        return ((i1 << 1) | i0) >>> 0;
    }
},
/* flatqueue/index.mjs */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var FlatQueue = /** @class */ (function () {
        function FlatQueue() {
            this.ids = [];
            this.values = [];
            this.length = 0;
        }
        FlatQueue.prototype.clear = function () {
            this.length = 0;
        };
        FlatQueue.prototype.push = function (id, value) {
            var pos = this.length++;
            this.ids[pos] = id;
            this.values[pos] = value;
            while (pos > 0) {
                var parent = (pos - 1) >> 1;
                var parentValue = this.values[parent];
                if (value >= parentValue)
                    break;
                this.ids[pos] = this.ids[parent];
                this.values[pos] = parentValue;
                pos = parent;
            }
            this.ids[pos] = id;
            this.values[pos] = value;
        };
        FlatQueue.prototype.pop = function () {
            if (this.length === 0)
                return undefined;
            var top = this.ids[0];
            this.length--;
            if (this.length > 0) {
                var id = this.ids[0] = this.ids[this.length];
                var value = this.values[0] = this.values[this.length];
                var halfLength = this.length >> 1;
                var pos = 0;
                while (pos < halfLength) {
                    var left = (pos << 1) + 1;
                    var right = left + 1;
                    var bestIndex = this.ids[left];
                    var bestValue = this.values[left];
                    var rightValue = this.values[right];
                    if (right < this.length && rightValue < bestValue) {
                        left = right;
                        bestIndex = this.ids[right];
                        bestValue = rightValue;
                    }
                    if (bestValue >= value)
                        break;
                    this.ids[pos] = bestIndex;
                    this.values[pos] = bestValue;
                    pos = left;
                }
                this.ids[pos] = id;
                this.values[pos] = value;
            }
            return top;
        };
        FlatQueue.prototype.peek = function () {
            if (this.length === 0)
                return undefined;
            return this.ids[0];
        };
        FlatQueue.prototype.peekValue = function () {
            if (this.length === 0)
                return undefined;
            return this.values[0];
        };
        return FlatQueue;
    }());
    exports.default = FlatQueue;
},
/* models/ranges/factor_range.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var range_1 = require(220) /* ./range */;
    var enums_1 = require(135) /* ../../core/enums */;
    var kinds_1 = require(136) /* ../../core/kinds */;
    var types_1 = require(139) /* ../../core/types */;
    var array_1 = require(124) /* ../../core/util/array */;
    var types_2 = require(123) /* ../../core/util/types */;
    var assert_1 = require(126) /* ../../core/util/assert */;
    exports.Factor = kinds_1.Or(kinds_1.String, kinds_1.Tuple(kinds_1.String, kinds_1.String), kinds_1.Tuple(kinds_1.String, kinds_1.String, kinds_1.String));
    exports.FactorSeq = kinds_1.Or(kinds_1.Array(kinds_1.String), kinds_1.Array(kinds_1.Tuple(kinds_1.String, kinds_1.String)), kinds_1.Array(kinds_1.Tuple(kinds_1.String, kinds_1.String, kinds_1.String)));
    function map_one_level(factors, padding, offset) {
        if (offset === void 0) {
            offset = 0;
        }
        var mapping = new Map();
        for (var i = 0; i < factors.length; i++) {
            var factor = factors[i];
            if (!mapping.has(factor))
                mapping.set(factor, { value: 0.5 + i * (1 + padding) + offset });
            else
                throw new Error("duplicate factor or subfactor: " + factor);
        }
        return [mapping, (factors.length - 1) * padding];
    }
    exports.map_one_level = map_one_level;
    function map_two_levels(factors, outer_pad, factor_pad, offset) {
        var e_1, _a, e_2, _b;
        var _c;
        if (offset === void 0) {
            offset = 0;
        }
        var mapping = new Map();
        var tops = new Map();
        try {
            for (var factors_1 = tslib_1.__values(factors), factors_1_1 = factors_1.next(); !factors_1_1.done; factors_1_1 = factors_1.next()) {
                var _d = tslib_1.__read(factors_1_1.value, 2), f0 = _d[0], f1 = _d[1];
                var top = (_c = tops.get(f0)) !== null && _c !== void 0 ? _c : [];
                tops.set(f0, tslib_1.__spread(top, [f1]));
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (factors_1_1 && !factors_1_1.done && (_a = factors_1.return))
                    _a.call(factors_1);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
        var suboffset = offset;
        var total_subpad = 0;
        var _loop_1 = function (f0, top) {
            var n = top.length;
            var _a = tslib_1.__read(map_one_level(top, factor_pad, suboffset), 2), submap = _a[0], subpad = _a[1];
            total_subpad += subpad;
            var subtot = array_1.sum(top.map(function (f1) { return submap.get(f1).value; }));
            mapping.set(f0, { value: subtot / n, mapping: submap });
            suboffset += n + outer_pad + subpad;
        };
        try {
            for (var tops_1 = tslib_1.__values(tops), tops_1_1 = tops_1.next(); !tops_1_1.done; tops_1_1 = tops_1.next()) {
                var _e = tslib_1.__read(tops_1_1.value, 2), f0 = _e[0], top = _e[1];
                _loop_1(f0, top);
            }
        }
        catch (e_2_1) {
            e_2 = { error: e_2_1 };
        }
        finally {
            try {
                if (tops_1_1 && !tops_1_1.done && (_b = tops_1.return))
                    _b.call(tops_1);
            }
            finally {
                if (e_2)
                    throw e_2.error;
            }
        }
        return [mapping, (tops.size - 1) * outer_pad + total_subpad];
    }
    exports.map_two_levels = map_two_levels;
    function map_three_levels(factors, outer_pad, inner_pad, factor_pad, offset) {
        var e_3, _a, e_4, _b;
        var _c;
        if (offset === void 0) {
            offset = 0;
        }
        var mapping = new Map();
        var tops = new Map();
        try {
            for (var factors_2 = tslib_1.__values(factors), factors_2_1 = factors_2.next(); !factors_2_1.done; factors_2_1 = factors_2.next()) {
                var _d = tslib_1.__read(factors_2_1.value, 3), f0 = _d[0], f1 = _d[1], f2 = _d[2];
                var top = (_c = tops.get(f0)) !== null && _c !== void 0 ? _c : [];
                tops.set(f0, tslib_1.__spread(top, [[f1, f2]]));
            }
        }
        catch (e_3_1) {
            e_3 = { error: e_3_1 };
        }
        finally {
            try {
                if (factors_2_1 && !factors_2_1.done && (_a = factors_2.return))
                    _a.call(factors_2);
            }
            finally {
                if (e_3)
                    throw e_3.error;
            }
        }
        var suboffset = offset;
        var total_subpad = 0;
        var _loop_2 = function (f0, top) {
            var n = top.length;
            var _a = tslib_1.__read(map_two_levels(top, inner_pad, factor_pad, suboffset), 2), submap = _a[0], subpad = _a[1];
            total_subpad += subpad;
            var subtot = array_1.sum(top.map(function (_a) {
                var _b = tslib_1.__read(_a, 1), f1 = _b[0];
                return submap.get(f1).value;
            }));
            mapping.set(f0, { value: subtot / n, mapping: submap });
            suboffset += n + outer_pad + subpad;
        };
        try {
            for (var tops_2 = tslib_1.__values(tops), tops_2_1 = tops_2.next(); !tops_2_1.done; tops_2_1 = tops_2.next()) {
                var _e = tslib_1.__read(tops_2_1.value, 2), f0 = _e[0], top = _e[1];
                _loop_2(f0, top);
            }
        }
        catch (e_4_1) {
            e_4 = { error: e_4_1 };
        }
        finally {
            try {
                if (tops_2_1 && !tops_2_1.done && (_b = tops_2.return))
                    _b.call(tops_2);
            }
            finally {
                if (e_4)
                    throw e_4.error;
            }
        }
        return [mapping, (tops.size - 1) * outer_pad + total_subpad];
    }
    exports.map_three_levels = map_three_levels;
    var FactorRange = /** @class */ (function (_super) {
        tslib_1.__extends(FactorRange, _super);
        function FactorRange(attrs) {
            return _super.call(this, attrs) || this;
        }
        FactorRange.init_FactorRange = function () {
            this.define(function (_a) {
                var Number = _a.Number;
                return ({
                    factors: [exports.FactorSeq, []],
                    factor_padding: [Number, 0],
                    subgroup_padding: [Number, 0.8],
                    group_padding: [Number, 1.4],
                    range_padding: [Number, 0],
                    range_padding_units: [enums_1.PaddingUnits, "percent"],
                    start: [Number],
                    end: [Number],
                });
            });
            this.internal(function (_a) {
                var Number = _a.Number, String = _a.String, Array = _a.Array, Tuple = _a.Tuple, Nullable = _a.Nullable;
                return ({
                    levels: [Number],
                    mids: [Nullable(Array(Tuple(String, String))), null],
                    tops: [Nullable(Array(String)), null],
                });
            });
        };
        Object.defineProperty(FactorRange.prototype, "min", {
            get: function () {
                return this.start;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(FactorRange.prototype, "max", {
            get: function () {
                return this.end;
            },
            enumerable: false,
            configurable: true
        });
        FactorRange.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._init(true);
        };
        FactorRange.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.properties.factors.change, function () { return _this.reset(); });
            this.connect(this.properties.factor_padding.change, function () { return _this.reset(); });
            this.connect(this.properties.group_padding.change, function () { return _this.reset(); });
            this.connect(this.properties.subgroup_padding.change, function () { return _this.reset(); });
            this.connect(this.properties.range_padding.change, function () { return _this.reset(); });
            this.connect(this.properties.range_padding_units.change, function () { return _this.reset(); });
        };
        FactorRange.prototype.reset = function () {
            this._init(false);
            this.change.emit();
        };
        FactorRange.prototype._lookup = function (x) {
            switch (x.length) {
                case 1: {
                    var _a = tslib_1.__read(x, 1), f0 = _a[0];
                    var mapping = this._mapping;
                    var y0 = mapping.get(f0);
                    return y0 != null ? y0.value : NaN;
                }
                case 2: {
                    var _b = tslib_1.__read(x, 2), f0 = _b[0], f1 = _b[1];
                    var mapping = this._mapping;
                    var y0 = mapping.get(f0);
                    if (y0 != null) {
                        var y1 = y0.mapping.get(f1);
                        if (y1 != null)
                            return y1.value;
                    }
                    return NaN;
                }
                case 3: {
                    var _c = tslib_1.__read(x, 3), f0 = _c[0], f1 = _c[1], f2 = _c[2];
                    var mapping = this._mapping;
                    var y0 = mapping.get(f0);
                    if (y0 != null) {
                        var y1 = y0.mapping.get(f1);
                        if (y1 != null) {
                            var y2 = y1.mapping.get(f2);
                            if (y2 != null)
                                return y2.value;
                        }
                    }
                    return NaN;
                }
                default:
                    assert_1.unreachable();
            }
        };
        // convert a string factor into a synthetic coordinate
        FactorRange.prototype.synthetic = function (x) {
            if (types_2.isNumber(x))
                return x;
            if (types_2.isString(x))
                return this._lookup([x]);
            var offset = 0;
            var off = x[x.length - 1];
            if (types_2.isNumber(off)) {
                offset = off;
                x = x.slice(0, -1);
            }
            return this._lookup(x) + offset;
        };
        // convert an array of string factors into synthetic coordinates
        FactorRange.prototype.v_synthetic = function (xs) {
            var n = xs.length;
            var array = new types_1.ScreenArray(n);
            for (var i = 0; i < n; i++) {
                array[i] = this.synthetic(xs[i]);
            }
            return array;
        };
        FactorRange.prototype._init = function (silent) {
            var _this = this;
            var _a = (function () {
                var e_5, _a, e_6, _b;
                if (array_1.every(_this.factors, types_2.isString)) {
                    var factors = _this.factors;
                    var _c = tslib_1.__read(map_one_level(factors, _this.factor_padding), 2), mapping_2 = _c[0], inside_padding_1 = _c[1];
                    var tops_3 = null;
                    var mids_1 = null;
                    return { levels: 1, mapping: mapping_2, tops: tops_3, mids: mids_1, inside_padding: inside_padding_1 };
                }
                else if (array_1.every(_this.factors, function (x) { return types_2.isArray(x) && x.length == 2 && types_2.isString(x[0]) && types_2.isString(x[1]); })) {
                    var factors = _this.factors;
                    var _d = tslib_1.__read(map_two_levels(factors, _this.group_padding, _this.factor_padding), 2), mapping_3 = _d[0], inside_padding_2 = _d[1];
                    var tops_4 = tslib_1.__spread(mapping_3.keys());
                    var mids_2 = null;
                    return { levels: 2, mapping: mapping_3, tops: tops_4, mids: mids_2, inside_padding: inside_padding_2 };
                }
                else if (array_1.every(_this.factors, function (x) { return types_2.isArray(x) && x.length == 3 && types_2.isString(x[0]) && types_2.isString(x[1]) && types_2.isString(x[2]); })) {
                    var factors = _this.factors;
                    var _e = tslib_1.__read(map_three_levels(factors, _this.group_padding, _this.subgroup_padding, _this.factor_padding), 2), mapping_4 = _e[0], inside_padding_3 = _e[1];
                    var tops_5 = tslib_1.__spread(mapping_4.keys());
                    var mids_3 = [];
                    try {
                        for (var mapping_1 = tslib_1.__values(mapping_4), mapping_1_1 = mapping_1.next(); !mapping_1_1.done; mapping_1_1 = mapping_1.next()) {
                            var _f = tslib_1.__read(mapping_1_1.value, 2), f0 = _f[0], L2 = _f[1];
                            try {
                                for (var _g = (e_6 = void 0, tslib_1.__values(L2.mapping.keys())), _h = _g.next(); !_h.done; _h = _g.next()) {
                                    var f1 = _h.value;
                                    mids_3.push([f0, f1]);
                                }
                            }
                            catch (e_6_1) {
                                e_6 = { error: e_6_1 };
                            }
                            finally {
                                try {
                                    if (_h && !_h.done && (_b = _g.return))
                                        _b.call(_g);
                                }
                                finally {
                                    if (e_6)
                                        throw e_6.error;
                                }
                            }
                        }
                    }
                    catch (e_5_1) {
                        e_5 = { error: e_5_1 };
                    }
                    finally {
                        try {
                            if (mapping_1_1 && !mapping_1_1.done && (_a = mapping_1.return))
                                _a.call(mapping_1);
                        }
                        finally {
                            if (e_5)
                                throw e_5.error;
                        }
                    }
                    return { levels: 3, mapping: mapping_4, tops: tops_5, mids: mids_3, inside_padding: inside_padding_3 };
                }
                else
                    assert_1.unreachable();
            })(), levels = _a.levels, mapping = _a.mapping, tops = _a.tops, mids = _a.mids, inside_padding = _a.inside_padding;
            this._mapping = mapping;
            this.tops = tops;
            this.mids = mids;
            var start = 0;
            var end = this.factors.length + inside_padding;
            if (this.range_padding_units == "percent") {
                var half_span = (end - start) * this.range_padding / 2;
                start -= half_span;
                end += half_span;
            }
            else {
                start -= this.range_padding;
                end += this.range_padding;
            }
            this.setv({ start: start, end: end, levels: levels }, { silent: silent });
            if (this.bounds == "auto")
                this.setv({ bounds: [start, end] }, { silent: true });
        };
        return FactorRange;
    }(range_1.Range));
    exports.FactorRange = FactorRange;
    FactorRange.__name__ = "FactorRange";
    FactorRange.init_FactorRange();
},
/* models/ranges/range.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var model_1 = require(168) /* ../../model */;
    var Range = /** @class */ (function (_super) {
        tslib_1.__extends(Range, _super);
        function Range(attrs) {
            var _this = _super.call(this, attrs) || this;
            _this.have_updated_interactively = false;
            return _this;
        }
        Range.init_Range = function () {
            this.define(function (_a) {
                var Number = _a.Number, Tuple = _a.Tuple, Or = _a.Or, Auto = _a.Auto, Nullable = _a.Nullable;
                return ({
                    bounds: [Nullable(Or(Tuple(Nullable(Number), Nullable(Number)), Auto)), null],
                    min_interval: [Nullable(Number), null],
                    max_interval: [Nullable(Number), null],
                });
            });
            this.internal(function (_a) {
                var Array = _a.Array, AnyRef = _a.AnyRef;
                return ({
                    plots: [Array(AnyRef()), []],
                });
            });
        };
        Object.defineProperty(Range.prototype, "is_reversed", {
            get: function () {
                return this.start > this.end;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(Range.prototype, "is_valid", {
            get: function () {
                return isFinite(this.min) && isFinite(this.max);
            },
            enumerable: false,
            configurable: true
        });
        return Range;
    }(model_1.Model));
    exports.Range = Range;
    Range.__name__ = "Range";
    Range.init_Range();
},
/* models/glyphs/utils.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var hittest = tslib_1.__importStar(require(222) /* ../../core/hittest */);
    function generic_line_scalar_legend(visuals, ctx, _a) {
        var x0 = _a.x0, x1 = _a.x1, y0 = _a.y0, y1 = _a.y1;
        ctx.save();
        ctx.beginPath();
        ctx.moveTo(x0, (y0 + y1) / 2);
        ctx.lineTo(x1, (y0 + y1) / 2);
        if (visuals.line.doit) {
            visuals.line.set_value(ctx);
            ctx.stroke();
        }
        ctx.restore();
    }
    exports.generic_line_scalar_legend = generic_line_scalar_legend;
    function generic_line_vector_legend(visuals, ctx, _a, index) {
        var x0 = _a.x0, x1 = _a.x1, y0 = _a.y0, y1 = _a.y1;
        ctx.save();
        ctx.beginPath();
        ctx.moveTo(x0, (y0 + y1) / 2);
        ctx.lineTo(x1, (y0 + y1) / 2);
        if (visuals.line.doit) {
            visuals.line.set_vectorize(ctx, index);
            ctx.stroke();
        }
        ctx.restore();
    }
    exports.generic_line_vector_legend = generic_line_vector_legend;
    exports.generic_line_legend = generic_line_vector_legend;
    function generic_area_scalar_legend(visuals, ctx, _a) {
        var _b, _c;
        var x0 = _a.x0, x1 = _a.x1, y0 = _a.y0, y1 = _a.y1;
        var w = Math.abs(x1 - x0);
        var dw = w * 0.1;
        var h = Math.abs(y1 - y0);
        var dh = h * 0.1;
        var sx0 = x0 + dw;
        var sx1 = x1 - dw;
        var sy0 = y0 + dh;
        var sy1 = y1 - dh;
        ctx.beginPath();
        ctx.rect(sx0, sy0, sx1 - sx0, sy1 - sy0);
        if (visuals.fill.doit) {
            visuals.fill.set_value(ctx);
            ctx.fill();
        }
        if ((_b = visuals.hatch) === null || _b === void 0 ? void 0 : _b.doit) {
            visuals.hatch.set_value(ctx);
            ctx.fill();
        }
        if ((_c = visuals.line) === null || _c === void 0 ? void 0 : _c.doit) {
            visuals.line.set_value(ctx);
            ctx.stroke();
        }
    }
    exports.generic_area_scalar_legend = generic_area_scalar_legend;
    function generic_area_vector_legend(visuals, ctx, _a, index) {
        var _b, _c;
        var x0 = _a.x0, x1 = _a.x1, y0 = _a.y0, y1 = _a.y1;
        var w = Math.abs(x1 - x0);
        var dw = w * 0.1;
        var h = Math.abs(y1 - y0);
        var dh = h * 0.1;
        var sx0 = x0 + dw;
        var sx1 = x1 - dw;
        var sy0 = y0 + dh;
        var sy1 = y1 - dh;
        ctx.beginPath();
        ctx.rect(sx0, sy0, sx1 - sx0, sy1 - sy0);
        if (visuals.fill.doit) {
            visuals.fill.set_vectorize(ctx, index);
            ctx.fill();
        }
        if ((_b = visuals.hatch) === null || _b === void 0 ? void 0 : _b.doit) {
            visuals.hatch.set_vectorize(ctx, index);
            ctx.fill();
        }
        if ((_c = visuals.line) === null || _c === void 0 ? void 0 : _c.doit) {
            visuals.line.set_vectorize(ctx, index);
            ctx.stroke();
        }
    }
    exports.generic_area_vector_legend = generic_area_vector_legend;
    exports.generic_area_legend = generic_area_vector_legend;
    function line_interpolation(renderer, geometry, x2, y2, x3, y3) {
        var _a, _b, _c, _d, _e, _f;
        var sx = geometry.sx, sy = geometry.sy;
        var x0, x1;
        var y0, y1;
        if (geometry.type == 'point') {
            // The +/- adjustments here are to dilate the hit point into a virtual "segment" to use below
            _a = tslib_1.__read(renderer.yscale.r_invert(sy - 1, sy + 1), 2), y0 = _a[0], y1 = _a[1];
            _b = tslib_1.__read(renderer.xscale.r_invert(sx - 1, sx + 1), 2), x0 = _b[0], x1 = _b[1];
        }
        else {
            // The +/- adjustments here are to handle cases such as purely horizontal or vertical lines
            if (geometry.direction == 'v') {
                _c = tslib_1.__read(renderer.yscale.r_invert(sy, sy), 2), y0 = _c[0], y1 = _c[1];
                _d = tslib_1.__read([Math.min(x2 - 1, x3 - 1), Math.max(x2 + 1, x3 + 1)], 2), x0 = _d[0], x1 = _d[1];
            }
            else {
                _e = tslib_1.__read(renderer.xscale.r_invert(sx, sx), 2), x0 = _e[0], x1 = _e[1];
                _f = tslib_1.__read([Math.min(y2 - 1, y3 - 1), Math.max(y2 + 1, y3 + 1)], 2), y0 = _f[0], y1 = _f[1];
            }
        }
        var _g = hittest.check_2_segments_intersect(x0, y0, x1, y1, x2, y2, x3, y3), x = _g.x, y = _g.y;
        return [x, y]; // XXX: null is not handled at use sites
    }
    exports.line_interpolation = line_interpolation;
},
/* core/hittest.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    function point_in_poly(x, y, px, py) {
        var inside = false;
        var x1 = px[px.length - 1];
        var y1 = py[py.length - 1];
        for (var i = 0; i < px.length; i++) {
            var x2 = px[i];
            var y2 = py[i];
            if ((y1 < y) != (y2 < y)) {
                if ((x1 + (y - y1) / (y2 - y1) * (x2 - x1)) < x)
                    inside = !inside;
            }
            x1 = x2;
            y1 = y2;
        }
        return inside;
    }
    exports.point_in_poly = point_in_poly;
    function point_in_ellipse(x, y, angle, b, a, x0, y0) {
        var A = (Math.pow((Math.cos(angle) / a), 2) + Math.pow((Math.sin(angle) / b), 2));
        var B = 2 * Math.cos(angle) * Math.sin(angle) * (Math.pow((1 / a), 2) - Math.pow((1 / b), 2));
        var C = (Math.pow((Math.cos(angle) / b), 2) + Math.pow((Math.sin(angle) / a), 2));
        var eqn = A * Math.pow((x - x0), 2) + B * (x - x0) * (y - y0) + C * Math.pow((y - y0), 2);
        var inside = eqn <= 1;
        return inside;
    }
    exports.point_in_ellipse = point_in_ellipse;
    function dist_2_pts(p0, p1) {
        return Math.pow((p0.x - p1.x), 2) + Math.pow((p0.y - p1.y), 2);
    }
    exports.dist_2_pts = dist_2_pts;
    function dist_to_segment_squared(p, v, w) {
        var l2 = dist_2_pts(v, w);
        if (l2 == 0)
            return dist_2_pts(p, v);
        var t = ((p.x - v.x) * (w.x - v.x) + (p.y - v.y) * (w.y - v.y)) / l2;
        if (t < 0)
            return dist_2_pts(p, v);
        if (t > 1)
            return dist_2_pts(p, w);
        var q = { x: v.x + t * (w.x - v.x), y: v.y + t * (w.y - v.y) };
        return dist_2_pts(p, q);
    }
    exports.dist_to_segment_squared = dist_to_segment_squared;
    function dist_to_segment(p, v, w) {
        return Math.sqrt(dist_to_segment_squared(p, v, w));
    }
    exports.dist_to_segment = dist_to_segment;
    function check_2_segments_intersect(l0_x0, l0_y0, l0_x1, l0_y1, l1_x0, l1_y0, l1_x1, l1_y1) {
        /*
         *  Check if 2 segments (l0 and l1) intersect. Returns a structure with
         *  the following attributes:
         *   * hit (boolean): whether the 2 segments intersect
         *   * x (float): x coordinate of the intersection point
         *   * y (float): y coordinate of the intersection point
         */
        var den = ((l1_y1 - l1_y0) * (l0_x1 - l0_x0)) - ((l1_x1 - l1_x0) * (l0_y1 - l0_y0));
        if (den == 0) {
            return { hit: false, x: null, y: null };
        }
        else {
            var a = l0_y0 - l1_y0;
            var b = l0_x0 - l1_x0;
            var num1 = ((l1_x1 - l1_x0) * a) - ((l1_y1 - l1_y0) * b);
            var num2 = ((l0_x1 - l0_x0) * a) - ((l0_y1 - l0_y0) * b);
            a = num1 / den;
            b = num2 / den;
            var x = l0_x0 + (a * (l0_x1 - l0_x0));
            var y = l0_y0 + (a * (l0_y1 - l0_y0));
            return { hit: (a > 0 && a < 1) && (b > 0 && b < 1), x: x, y: y };
        }
    }
    exports.check_2_segments_intersect = check_2_segments_intersect;
},
/* models/glyphs/webgl/line.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var utils_1 = require(224) /* ./utils */;
    var base_1 = require(228) /* ./base */;
    var line_vert_1 = tslib_1.__importDefault(require(229) /* ./line.vert */);
    var line_frag_1 = tslib_1.__importDefault(require(230) /* ./line.frag */);
    var color_1 = require(137) /* ../../../core/util/color */;
    var line_1 = require(161) /* ../../../core/visuals/line */;
    var DashAtlas = /** @class */ (function () {
        function DashAtlas(gl) {
            this._atlas = new Map();
            this._width = 256;
            this._height = 256;
            // Init texture
            this.tex = new utils_1.Texture2d(gl);
            this.tex.set_wrapping(gl.REPEAT, gl.REPEAT);
            this.tex.set_interpolation(gl.NEAREST, gl.NEAREST);
            this.tex.set_size([this._width, this._height], gl.RGBA);
            this.tex.set_data([0, 0], [this._width, this._height], new Uint8Array(4 * this._width * this._height));
            // Init with solid line (index 0 is reserved for this)
            this.get_atlas_data([1]);
        }
        DashAtlas.prototype.get_atlas_data = function (pattern) {
            var key = pattern.join("-");
            var atlas_data = this._atlas.get(key);
            if (atlas_data == null) {
                var _a = tslib_1.__read(this.make_pattern(pattern), 2), data = _a[0], period = _a[1];
                var index = this._atlas.size;
                this.tex.set_data([0, index], [this._width, 1], new Uint8Array(data.map(function (x) { return x + 10; })));
                atlas_data = [index / this._height, period];
                this._atlas.set(key, atlas_data);
            }
            return atlas_data;
        };
        DashAtlas.prototype.make_pattern = function (pattern) {
            var e_1, _a;
            // A pattern is defined as on/off sequence of segments
            // It must be a multiple of 2
            if (pattern.length > 1 && pattern.length % 2) {
                pattern = pattern.concat(pattern);
            }
            // Period is sum of elements
            var period = 0;
            try {
                for (var pattern_1 = tslib_1.__values(pattern), pattern_1_1 = pattern_1.next(); !pattern_1_1.done; pattern_1_1 = pattern_1.next()) {
                    var v = pattern_1_1.value;
                    period += v;
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (pattern_1_1 && !pattern_1_1.done && (_a = pattern_1.return))
                        _a.call(pattern_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            // Find all start and end of on-segment only
            var C = [];
            var c = 0;
            for (var i = 0, end = pattern.length + 2; i < end; i += 2) {
                var a = Math.max(0.0001, pattern[i % pattern.length]);
                var b = Math.max(0.0001, pattern[(i + 1) % pattern.length]);
                C.push(c, c + a);
                c += a + b;
            }
            // Build pattern
            var n = this._width;
            var Z = new Float32Array(n * 4);
            for (var i = 0, end = n; i < end; i++) {
                var dash_end = void 0, dash_start = void 0, dash_type = void 0;
                var x = (period * i) / (n - 1);
                // get index at min - index = np.argmin(abs(C-(x)))
                var index = 0;
                var val_at_index = 1e16;
                for (var j = 0, endj = C.length; j < endj; j++) {
                    var val = Math.abs(C[j] - x);
                    if (val < val_at_index) {
                        index = j;
                        val_at_index = val;
                    }
                }
                if ((index % 2) === 0) {
                    dash_type = (x <= C[index]) ? +1 : 0;
                    dash_start = C[index];
                    dash_end = C[index + 1];
                }
                else {
                    dash_type = (x > C[index]) ? -1 : 0;
                    dash_start = C[index - 1];
                    dash_end = C[index];
                }
                Z[(i * 4) + 0] = C[index];
                Z[(i * 4) + 1] = dash_type;
                Z[(i * 4) + 2] = dash_start;
                Z[(i * 4) + 3] = dash_end;
            }
            return [Z, period];
        };
        return DashAtlas;
    }());
    DashAtlas.__name__ = "DashAtlas";
    var joins = { miter: 0, round: 1, bevel: 2 };
    var caps = {
        '': 0, none: 0, '.': 0,
        round: 1, ')': 1, '(': 1, o: 1,
        'triangle in': 2, '<': 2,
        'triangle out': 3, '>': 3,
        square: 4, '[': 4, ']': 4, '=': 4,
        butt: 5, '|': 5,
    };
    var LineGL = /** @class */ (function (_super) {
        tslib_1.__extends(LineGL, _super);
        function LineGL(gl, glyph) {
            var _this = _super.call(this, gl, glyph) || this;
            _this.glyph = glyph;
            _this._scale_aspect = 0; // keep track, so we know when we need to update segment data
            var vert = line_vert_1.default;
            var frag = line_frag_1.default;
            // The program
            _this.prog = new utils_1.Program(gl);
            _this.prog.set_shaders(vert, frag);
            _this.index_buffer = new utils_1.IndexBuffer(gl);
            // Buffers
            _this.vbo_position = new utils_1.VertexBuffer(gl);
            _this.vbo_tangents = new utils_1.VertexBuffer(gl);
            _this.vbo_segment = new utils_1.VertexBuffer(gl);
            _this.vbo_angles = new utils_1.VertexBuffer(gl);
            _this.vbo_texcoord = new utils_1.VertexBuffer(gl);
            // Dash atlas
            _this.dash_atlas = new DashAtlas(gl);
            return _this;
        }
        LineGL.prototype.draw = function (indices, mainGlyph, trans) {
            var mainGlGlyph = mainGlyph.glglyph;
            if (mainGlGlyph.data_changed) {
                mainGlGlyph._set_data();
                mainGlGlyph.data_changed = false;
            }
            if (this.visuals_changed) {
                this._set_visuals();
                this.visuals_changed = false;
            }
            mainGlGlyph._update_scale(1, 1);
            this._scale_aspect = 1;
            // Select buffers from main glyph
            // (which may be this glyph but maybe not if this is a (non)selection glyph)
            this.prog.set_attribute('a_position', 'vec2', mainGlGlyph.vbo_position);
            this.prog.set_attribute('a_tangents', 'vec4', mainGlGlyph.vbo_tangents);
            this.prog.set_attribute('a_segment', 'vec2', mainGlGlyph.vbo_segment);
            this.prog.set_attribute('a_angles', 'vec2', mainGlGlyph.vbo_angles);
            this.prog.set_attribute('a_texcoord', 'vec2', mainGlGlyph.vbo_texcoord);
            //
            this.prog.set_uniform('u_length', 'float', [mainGlGlyph.cumsum]);
            this.prog.set_texture('u_dash_atlas', this.dash_atlas.tex);
            // Handle transformation to device coordinates
            this.prog.set_uniform('u_pixel_ratio', 'float', [trans.pixel_ratio]);
            this.prog.set_uniform('u_canvas_size', 'vec2', [trans.width, trans.height]);
            this.prog.set_uniform('u_scale_aspect', 'vec2', [1, 1]);
            this.prog.set_uniform('u_scale_length', 'float', [Math.sqrt(2)]);
            this.I_triangles = mainGlGlyph.I_triangles;
            if (this.I_triangles.length < 65535) {
                // Data is small enough to draw in one pass
                this.index_buffer.set_size(this.I_triangles.length * 2);
                this.index_buffer.set_data(0, new Uint16Array(this.I_triangles));
                this.prog.draw(this.gl.TRIANGLES, this.index_buffer);
                // @prog.draw(@gl.LINE_STRIP, @index_buffer)  # Use this to draw the line skeleton
            }
            else {
                // Work around the limit that the indexbuffer must be uint16. We draw in chunks.
                // First collect indices in chunks
                indices = Array.from(this.I_triangles);
                var nvertices = this.I_triangles.length;
                var chunksize = 64008; // 65536 max. 64008 is divisible by 12
                var chunks = [];
                for (var i = 0, end = Math.ceil(nvertices / chunksize); i < end; i++) {
                    chunks.push([]);
                }
                for (var i = 0, end = indices.length; i < end; i++) {
                    var uint16_index = indices[i] % chunksize;
                    var chunk = Math.floor(indices[i] / chunksize);
                    chunks[chunk].push(uint16_index);
                }
                // Then draw each chunk
                for (var chunk = 0, end = chunks.length; chunk < end; chunk++) {
                    var these_indices = new Uint16Array(chunks[chunk]);
                    var offset = chunk * chunksize * 4;
                    if (these_indices.length === 0) {
                        continue;
                    }
                    this.prog.set_attribute('a_position', 'vec2', mainGlGlyph.vbo_position, 0, offset * 2);
                    this.prog.set_attribute('a_tangents', 'vec4', mainGlGlyph.vbo_tangents, 0, offset * 4);
                    this.prog.set_attribute('a_segment', 'vec2', mainGlGlyph.vbo_segment, 0, offset * 2);
                    this.prog.set_attribute('a_angles', 'vec2', mainGlGlyph.vbo_angles, 0, offset * 2);
                    this.prog.set_attribute('a_texcoord', 'vec2', mainGlGlyph.vbo_texcoord, 0, offset * 2);
                    // The actual drawing
                    this.index_buffer.set_size(these_indices.length * 2);
                    this.index_buffer.set_data(0, these_indices);
                    this.prog.draw(this.gl.TRIANGLES, this.index_buffer);
                }
            }
        };
        LineGL.prototype._set_data = function () {
            this._bake();
            this.vbo_position.set_size(this.V_position.length * 4);
            this.vbo_position.set_data(0, this.V_position);
            this.vbo_tangents.set_size(this.V_tangents.length * 4);
            this.vbo_tangents.set_data(0, this.V_tangents);
            this.vbo_angles.set_size(this.V_angles.length * 4);
            this.vbo_angles.set_data(0, this.V_angles);
            this.vbo_texcoord.set_size(this.V_texcoord.length * 4);
            this.vbo_texcoord.set_data(0, this.V_texcoord);
        };
        LineGL.prototype._set_visuals = function () {
            var _a;
            var _b = this.glyph.visuals.line, line_color = _b.line_color, line_alpha = _b.line_alpha, line_width = _b.line_width, line_cap = _b.line_cap, line_join = _b.line_join, line_dash = _b.line_dash, line_dash_offset = _b.line_dash_offset;
            var _c = tslib_1.__read(color_1.color2rgba(line_color.value, line_alpha.value), 4), r = _c[0], g = _c[1], b = _c[2], a = _c[3];
            var width = line_width.value;
            var cap = caps[line_cap.value];
            var join = joins[line_join.value];
            this.prog.set_uniform('u_color', 'vec4', [r / 255, g / 255, b / 255, a / 255]);
            this.prog.set_uniform('u_linewidth', 'float', [width]);
            this.prog.set_uniform('u_antialias', 'float', [0.9]); // Smaller aa-region to obtain crisper images
            this.prog.set_uniform('u_linecaps', 'vec2', [cap, cap]);
            this.prog.set_uniform('u_linejoin', 'float', [join]);
            this.prog.set_uniform('u_miter_limit', 'float', [10.0]); // 10 should be a good value
            // https://developer.mozilla.org/en-US/docs/Web/SVG/Attribute/stroke-miterlimit
            var dash_pattern = line_1.resolve_line_dash(line_dash.value);
            var dash_index = 0;
            var dash_period = 1;
            if (dash_pattern.length) {
                _a = tslib_1.__read(this.dash_atlas.get_atlas_data(dash_pattern), 2), dash_index = _a[0], dash_period = _a[1];
            }
            this.prog.set_uniform('u_dash_index', 'float', [dash_index]); // 0 means solid line
            this.prog.set_uniform('u_dash_phase', 'float', [line_dash_offset.value]);
            this.prog.set_uniform('u_dash_period', 'float', [dash_period]);
            this.prog.set_uniform('u_dash_caps', 'vec2', [cap, cap]);
            this.prog.set_uniform('u_closed', 'float', [0]); // We dont do closed lines
        };
        LineGL.prototype._bake = function () {
            // This is what you get if you port 50 lines of numpy code to JS.
            // V_segment is handled in another method, because it depends on the aspect
            // ratio of the scale (The original paper/code assumed isotropic scaling).
            //
            // Buffer dtype from the Python implementation:
            //
            // self.vtype = np.dtype( [('a_position', 'f4', 2),
            //                         ('a_segment',  'f4', 2),
            //                         ('a_angles',   'f4', 2),
            //                         ('a_tangents', 'f4', 4),
            //                         ('a_texcoord', 'f4', 2) ])
            // Init array of implicit shape nx2
            var I, T, V_angles2, V_position2, V_tangents2, V_texcoord2, Vp, Vt;
            var n = this.nvertices;
            var sx = this.glyph.sx;
            var sy = this.glyph.sy;
            // Init vertex data
            var V_position = (Vp = new Float32Array(n * 2));
            //V_segment = new Float32Array(n*2)  # Done later
            var V_angles = new Float32Array(n * 2);
            var V_tangents = (Vt = new Float32Array(n * 4)); // mind the 4!
            // Position, replacing non-finite numbers with zeros
            for (var i = 0, end = n; i < end; i++) {
                V_position[(i * 2) + 0] = isFinite(sx[i]) ? sx[i] : 0.0;
                V_position[(i * 2) + 1] = isFinite(sy[i]) ? sy[i] : 0.0;
            }
            // Tangents & norms (need tangents to calculate segments based on scale)
            this.tangents = (T = new Float32Array((n * 2) - 2));
            for (var i = 0, end = n - 1; i < end; i++) {
                T[(i * 2) + 0] = Vp[((i + 1) * 2) + 0] - Vp[(i * 2) + 0];
                T[(i * 2) + 1] = Vp[((i + 1) * 2) + 1] - Vp[(i * 2) + 1];
            }
            for (var i = 0, end = n - 1; i < end; i++) {
                // V['a_tangents'][+1:, :2] = T
                V_tangents[((i + 1) * 4) + 0] = T[(i * 2) + 0];
                V_tangents[((i + 1) * 4) + 1] = T[(i * 2) + 1];
                // V['a_tangents'][:-1, 2:] = T
                V_tangents[(i * 4) + 2] = T[(i * 2) + 0];
                V_tangents[(i * 4) + 3] = T[(i * 2) + 1];
            }
            // V['a_tangents'][0  , :2] = T[0]
            V_tangents[(0 * 4) + 0] = T[0];
            V_tangents[(0 * 4) + 1] = T[1];
            // V['a_tangents'][ -1, 2:] = T[-1]
            V_tangents[((n - 1) * 4) + 2] = T[((n - 2) * 2) + 0];
            V_tangents[((n - 1) * 4) + 3] = T[((n - 2) * 2) + 1];
            // Angles
            var A = new Float32Array(n);
            for (var i = 0, end = n; i < end; i++) {
                A[i] = Math.atan2((Vt[(i * 4) + 0] * Vt[(i * 4) + 3]) - (Vt[(i * 4) + 1] * Vt[(i * 4) + 2]), (Vt[(i * 4) + 0] * Vt[(i * 4) + 2]) + (Vt[(i * 4) + 1] * Vt[(i * 4) + 3]));
            }
            for (var i = 0, end = n - 1; i < end; i++) {
                V_angles[(i * 2) + 0] = A[i];
                V_angles[(i * 2) + 1] = A[i + 1];
            }
            // Position, non-finite numbers
            for (var i = 0, end = n; i < end; i++) {
                if (!isFinite(sx[i])) {
                    V_position[(i * 2) + 0] = sx[i];
                }
                if (!isFinite(sy[i])) {
                    V_position[(i * 2) + 1] = sy[i];
                }
            }
            // Step 1: A -- B -- C  =>  A -- B, B' -- C
            // Repeat our array 4 times
            var m = (4 * n) - 4;
            this.V_position = (V_position2 = new Float32Array(m * 2));
            this.V_angles = (V_angles2 = new Float32Array(m * 2));
            this.V_tangents = (V_tangents2 = new Float32Array(m * 4)); // mind the 4!
            this.V_texcoord = (V_texcoord2 = new Float32Array(m * 2));
            var o = 2;
            //
            // Arg, we really need an ndarray thing in JS :/
            for (var i = 0, end = n; i < end; i++) { // all nodes on the line
                for (var j = 0; j < 4; j++) { // the four quad vertices
                    for (var k = 0; k < 2; k++) { // xy
                        V_position2[((((i * 4) + j) - o) * 2) + k] = V_position[(i * 2) + k];
                        V_angles2[(((i * 4) + j) * 2) + k] = V_angles[(i * 2) + k];
                    } // no offset
                    for (var k = 0; k < 4; k++) {
                        V_tangents2[((((i * 4) + j) - o) * 4) + k] = V_tangents[(i * 4) + k];
                    }
                }
            }
            for (var i = 0, end = n; i < end; i++) {
                V_texcoord2[(((i * 4) + 0) * 2) + 0] = -1;
                V_texcoord2[(((i * 4) + 1) * 2) + 0] = -1;
                V_texcoord2[(((i * 4) + 2) * 2) + 0] = +1;
                V_texcoord2[(((i * 4) + 3) * 2) + 0] = +1;
                //
                V_texcoord2[(((i * 4) + 0) * 2) + 1] = -1;
                V_texcoord2[(((i * 4) + 1) * 2) + 1] = +1;
                V_texcoord2[(((i * 4) + 2) * 2) + 1] = -1;
                V_texcoord2[(((i * 4) + 3) * 2) + 1] = +1;
            }
            // Indices
            //I = np.resize( np.array([0,1,2,1,2,3], dtype=np.uint32), (n-1)*(2*3))
            //I += np.repeat( 4*np.arange(n-1), 6)
            var ni = (n - 1) * 6;
            this.I_triangles = (I = new Uint32Array(ni));
            // Order of indices is such that drawing as line_strip reveals the line skeleton
            // Might have implications on culling, if we ever turn that on.
            // Order in paper was: 0 1 2 1 2 3
            for (var i = 0, end = n; i < end; i++) {
                I[(i * 6) + 0] = 0 + (4 * i);
                I[(i * 6) + 1] = 1 + (4 * i);
                I[(i * 6) + 2] = 3 + (4 * i);
                I[(i * 6) + 3] = 2 + (4 * i);
                I[(i * 6) + 4] = 0 + (4 * i);
                I[(i * 6) + 5] = 3 + (4 * i);
            }
        };
        LineGL.prototype._update_scale = function (sx, sy) {
            // Update segment data and cumsum so the length along the line has the
            // scale aspect ratio in it. In the vertex shader we multiply with the
            // "isotropic part" of the scale.
            var V_segment2;
            var n = this.nvertices;
            var m = (4 * n) - 4;
            // Prepare arrays
            var T = this.tangents;
            var N = new Float32Array(n - 1);
            var V_segment = new Float32Array(n * 2); // Elements are initialized with 0
            this.V_segment = (V_segment2 = new Float32Array(m * 2));
            // Calculate vector lengths - with scale aspect ratio taken into account
            for (var i = 0, end = n - 1; i < end; i++) {
                N[i] = Math.sqrt(Math.pow((T[(i * 2) + 0] * sx), 2) + Math.pow((T[(i * 2) + 1] * sy), 2));
            }
            // Calculate Segments
            var cumsum = 0;
            for (var i = 0, end = n - 1; i < end; i++) {
                cumsum += N[i];
                V_segment[((i + 1) * 2) + 0] = cumsum;
                V_segment[(i * 2) + 1] = cumsum;
            }
            // Upscale (same loop as in _bake())
            for (var i = 0, end = n; i < end; i++) {
                for (var j = 0; j < 4; j++) {
                    for (var k = 0; k < 2; k++) {
                        V_segment2[(((i * 4) + j) * 2) + k] = V_segment[(i * 2) + k];
                    }
                }
            }
            // Update
            this.cumsum = cumsum; // L[-1] in Nico's code
            this.vbo_segment.set_size(this.V_segment.length * 4);
            this.vbo_segment.set_data(0, this.V_segment);
        };
        return LineGL;
    }(base_1.BaseGLGlyph));
    exports.LineGL = LineGL;
    LineGL.__name__ = "LineGL";
},
/* models/glyphs/webgl/utils/index.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var program_1 = require(225) /* ./program */;
    __esExport("Program", program_1.Program);
    var texture_1 = require(227) /* ./texture */;
    __esExport("Texture2d", texture_1.Texture2d);
    var buffer_1 = require(226) /* ./buffer */;
    __esExport("IndexBuffer", buffer_1.IndexBuffer);
    __esExport("VertexBuffer", buffer_1.VertexBuffer);
},
/* models/glyphs/webgl/utils/program.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var buffer_1 = require(226) /* ./buffer */;
    var Program = /** @class */ (function () {
        function Program(gl) {
            this.gl = gl;
            this.UTYPEMAP = {
                float: "uniform1fv",
                vec2: "uniform2fv",
                vec3: "uniform3fv",
                vec4: "uniform4fv",
                int: "uniform1iv",
                ivec2: "uniform2iv",
                ivec3: "uniform3iv",
                ivec4: "uniform4iv",
                bool: "uniform1iv",
                bvec2: "uniform2iv",
                bvec3: "uniform3iv",
                bvec4: "uniform4iv",
                mat2: "uniformMatrix2fv",
                mat3: "uniformMatrix3fv",
                mat4: "uniformMatrix4fv",
                sampler1D: "uniform1i",
                sampler2D: "uniform1i",
                sampler3D: "uniform1i",
            };
            this.ATYPEMAP = {
                float: "vertexAttrib1f",
                vec2: "vertexAttrib2f",
                vec3: "vertexAttrib3f",
                vec4: "vertexAttrib4f",
            };
            this.ATYPEINFO = {
                float: [1, 5126],
                vec2: [2, 5126],
                vec3: [3, 5126],
                vec4: [4, 5126],
                vec4_uint8: [4, 5121],
            };
            this._linked = false;
            this._validated = false;
            this._unset_variables = new Set();
            this._known_invalid = new Set();
            this._locations = new Map();
            this._samplers = new Map();
            this._attributes = new Map();
            this.handle = this.gl.createProgram();
        }
        Program.prototype.delete = function () {
            this.gl.deleteProgram(this.handle);
        };
        Program.prototype.activate = function () {
            this.gl.useProgram(this.handle);
        };
        Program.prototype.deactivate = function () {
            this.gl.useProgram(0);
        };
        Program.prototype.set_shaders = function (vert, frag) {
            var e_1, _a;
            // Set GLSL code for the vertex and fragment shader.
            //
            // This function takes care of setting the shading code and
            // compiling+linking it into a working program object that is ready
            // to use.
            //
            // Parameters
            // ----------
            // vert : str
            //     GLSL code for the vertex shader.
            // frag : str
            //     GLSL code for the fragment shader.
            var gl = this.gl;
            this._linked = false;
            var vert_handle = gl.createShader(gl.VERTEX_SHADER);
            var frag_handle = gl.createShader(gl.FRAGMENT_SHADER);
            var tmp = [
                [vert, vert_handle, "vertex"],
                [frag, frag_handle, "fragment"],
            ];
            try {
                for (var tmp_1 = tslib_1.__values(tmp), tmp_1_1 = tmp_1.next(); !tmp_1_1.done; tmp_1_1 = tmp_1.next()) {
                    var _b = tslib_1.__read(tmp_1_1.value, 3), code = _b[0], handle = _b[1], type = _b[2];
                    gl.shaderSource(handle, code);
                    gl.compileShader(handle);
                    var status = gl.getShaderParameter(handle, gl.COMPILE_STATUS);
                    if (!status) {
                        var errors = gl.getShaderInfoLog(handle);
                        throw new Error("errors in " + type + " shader:\n" + errors);
                    }
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (tmp_1_1 && !tmp_1_1.done && (_a = tmp_1.return))
                        _a.call(tmp_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            gl.attachShader(this.handle, vert_handle);
            gl.attachShader(this.handle, frag_handle);
            gl.linkProgram(this.handle);
            if (!gl.getProgramParameter(this.handle, gl.LINK_STATUS)) {
                var logs = gl.getProgramInfoLog(this.handle);
                throw new Error("Program link error:\n" + logs);
            }
            this._unset_variables = this._get_active_attributes_and_uniforms();
            gl.detachShader(this.handle, vert_handle);
            gl.detachShader(this.handle, frag_handle);
            gl.deleteShader(vert_handle);
            gl.deleteShader(frag_handle);
            this._known_invalid.clear();
            this._linked = true;
        };
        Program.prototype._get_active_attributes_and_uniforms = function () {
            var e_2, _a, e_3, _b, e_4, _c;
            // Retrieve active attributes and uniforms to be able to check that
            // all uniforms/attributes are set by the user.
            var gl = this.gl;
            this._locations.clear();
            var regex = new RegExp("(\\w+)\\s*(\\[(\\d+)\\])\\s*");
            var cu = gl.getProgramParameter(this.handle, gl.ACTIVE_UNIFORMS);
            var ca = gl.getProgramParameter(this.handle, gl.ACTIVE_ATTRIBUTES);
            var attributes = [];
            var uniforms = [];
            var stub5_seq = [
                [attributes, ca, gl.getActiveAttrib, gl.getAttribLocation],
                [uniforms, cu, gl.getActiveUniform, gl.getUniformLocation],
            ];
            try {
                for (var stub5_seq_1 = tslib_1.__values(stub5_seq), stub5_seq_1_1 = stub5_seq_1.next(); !stub5_seq_1_1.done; stub5_seq_1_1 = stub5_seq_1.next()) {
                    var _d = tslib_1.__read(stub5_seq_1_1.value, 4), container = _d[0], count = _d[1], getActive = _d[2], getLocation = _d[3];
                    for (var i = 0; i < count; i += 1) {
                        var info = getActive.call(gl, this.handle, i);
                        var name = info.name;
                        var m = name.match(regex);
                        if (m != null) {
                            var name_1 = m[1];
                            for (var j = 0; j < info.size; j += 1) {
                                container.push([name_1 + "[" + j + "]", info.type]);
                            }
                        }
                        else {
                            container.push([name, info.type]);
                        }
                        this._locations.set(name, getLocation.call(gl, this.handle, name));
                    }
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (stub5_seq_1_1 && !stub5_seq_1_1.done && (_a = stub5_seq_1.return))
                        _a.call(stub5_seq_1);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            var attrs_and_uniforms = new Set();
            try {
                for (var attributes_1 = tslib_1.__values(attributes), attributes_1_1 = attributes_1.next(); !attributes_1_1.done; attributes_1_1 = attributes_1.next()) {
                    var _e = tslib_1.__read(attributes_1_1.value, 1), name = _e[0];
                    attrs_and_uniforms.add(name);
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (attributes_1_1 && !attributes_1_1.done && (_b = attributes_1.return))
                        _b.call(attributes_1);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            try {
                for (var uniforms_1 = tslib_1.__values(uniforms), uniforms_1_1 = uniforms_1.next(); !uniforms_1_1.done; uniforms_1_1 = uniforms_1.next()) {
                    var _f = tslib_1.__read(uniforms_1_1.value, 1), name = _f[0];
                    attrs_and_uniforms.add(name);
                }
            }
            catch (e_4_1) {
                e_4 = { error: e_4_1 };
            }
            finally {
                try {
                    if (uniforms_1_1 && !uniforms_1_1.done && (_c = uniforms_1.return))
                        _c.call(uniforms_1);
                }
                finally {
                    if (e_4)
                        throw e_4.error;
                }
            }
            return attrs_and_uniforms;
        };
        Program.prototype.set_texture = function (name, value) {
            var _a;
            // Set a texture sampler.
            //
            // A texture is a 2 dimensional grid of colors/intensities that
            // can be applied to a face (or used for other means by providing
            // a regular grid of data).
            //
            // Parameters
            // ----------
            // name : str
            //     The name by which the texture is known in the GLSL code.
            // value : Texture2d
            //     The Texture2d object to bind.
            if (!this._linked) {
                throw new Error("Cannot set uniform when program has no code");
            }
            var handle = (_a = this._locations.get(name)) !== null && _a !== void 0 ? _a : -1;
            if (handle < 0) {
                if (!this._known_invalid.has(name)) {
                    this._known_invalid.add(name);
                    console.log("\"Variable " + name + " is not an active texture");
                }
                return;
            }
            if (this._unset_variables.has(name)) {
                this._unset_variables.delete(name);
            }
            this.activate();
            if (true) {
                var unit = this._samplers.size;
                if (this._samplers.has(name)) {
                    unit = this._samplers.get(name)[2];
                }
                this._samplers.set(name, [value._target, value.handle, unit]);
                this.gl.uniform1i(handle, unit);
            }
        };
        Program.prototype.set_uniform = function (name, type_, value) {
            var _a;
            // Set a uniform value.
            //
            // A uniform is a value that is global to both the vertex and
            // fragment shader.
            //
            // Parameters
            // ----------
            // name : str
            //     The name by which the uniform is known in the GLSL code.
            // type_ : str
            //     The type of the uniform, e.g. 'float', 'vec2', etc.
            // value : list of scalars
            //     The value for the uniform. Should be a list even for type float.
            if (!this._linked) {
                throw new Error("Cannot set uniform when program has no code");
            }
            var handle = (_a = this._locations.get(name)) !== null && _a !== void 0 ? _a : -1;
            if (handle < 0) {
                if (!this._known_invalid.has(name)) {
                    this._known_invalid.add(name);
                    console.log("Variable " + name + " is not an active uniform");
                }
                return;
            }
            if (this._unset_variables.has(name)) {
                this._unset_variables.delete(name);
            }
            var count = 1;
            if (!type_.startsWith("mat")) {
                var a_type = type_ == "int" || type_ == "bool" ? "float" : type_.replace(/^ib/, "");
                count = Math.floor(value.length / (this.ATYPEINFO[a_type][0]));
            }
            if (count > 1) {
                for (var j = 0; j < count; j += 1) {
                    if (this._unset_variables.has(name + "[" + j + "]")) {
                        var name_ = name + "[" + j + "]";
                        if (this._unset_variables.has(name_)) {
                            this._unset_variables.delete(name_);
                        }
                    }
                }
            }
            var funcname = this.UTYPEMAP[type_];
            this.activate();
            if (type_.startsWith("mat")) {
                this.gl[funcname](handle, false, value);
            }
            else {
                this.gl[funcname](handle, value);
            }
        };
        Program.prototype.set_attribute = function (name, type_, value, stride, offset, normalize) {
            var _a;
            if (stride === void 0) {
                stride = 0;
            }
            if (offset === void 0) {
                offset = 0;
            }
            if (normalize === void 0) {
                normalize = false;
            }
            // Set an attribute value.
            //
            // An attribute represents per-vertex data and can only be used
            // in the vertex shader.
            //
            // Parameters
            // ----------
            // name : str
            //     The name by which the attribute is known in the GLSL code.
            // type_ : str
            //     The type of the attribute, e.g. 'float', 'vec2', etc.
            // value : VertexBuffer, array
            //     If value is a VertexBuffer, it is used (with stride and offset)
            //     for the vertex data. If value is an array, its used to set
            //     the value of all vertices (similar to a uniform).
            // stide : int, default 0
            //     The stride to "sample" the vertex data inside the buffer. Unless
            //     multiple vertex data are packed into a single buffer, this should
            //     be zero.
            // offset : int, default 0
            //     The offset to "sample" the vertex data inside the buffer. Unless
            //     multiple vertex data are packed into a single buffer, or only
            //     a part of the data must be used, this should probably be zero.
            if (!this._linked) {
                throw new Error("Cannot set attribute when program has no code");
            }
            var handle = (_a = this._locations.get(name)) !== null && _a !== void 0 ? _a : -1;
            if (handle < 0) {
                if (!this._known_invalid.has(name)) {
                    this._known_invalid.add(name);
                    if (value instanceof buffer_1.VertexBuffer && offset > 0) {
                    }
                    else {
                        console.log("Variable " + name + " is not an active attribute");
                    }
                }
                return;
            }
            if (this._unset_variables.has(name)) {
                this._unset_variables.delete(name);
            }
            this.activate();
            if (!(value instanceof buffer_1.VertexBuffer)) {
                var funcname = this.ATYPEMAP[type_];
                this._attributes.set(name, [null, handle, funcname, value]);
            }
            else {
                var _b = tslib_1.__read(this.ATYPEINFO[type_], 2), size = _b[0], gtype = _b[1];
                var funcname = "vertexAttribPointer";
                var args = [size, gtype, normalize, stride, offset];
                this._attributes.set(name, [value.handle, handle, funcname, args]);
            }
        };
        Program.prototype._pre_draw = function () {
            var e_5, _a, e_6, _b;
            this.activate();
            try {
                for (var _c = tslib_1.__values(this._samplers.values()), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var _e = tslib_1.__read(_d.value, 3), tex_target = _e[0], tex_handle = _e[1], unit = _e[2];
                    this.gl.activeTexture(this.gl.TEXTURE0 + unit);
                    this.gl.bindTexture(tex_target, tex_handle);
                }
            }
            catch (e_5_1) {
                e_5 = { error: e_5_1 };
            }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return))
                        _a.call(_c);
                }
                finally {
                    if (e_5)
                        throw e_5.error;
                }
            }
            try {
                for (var _f = tslib_1.__values(this._attributes.values()), _g = _f.next(); !_g.done; _g = _f.next()) {
                    var _h = tslib_1.__read(_g.value, 4), vbo_handle = _h[0], attr_handle = _h[1], funcname = _h[2], args = _h[3];
                    if (vbo_handle != null) {
                        this.gl.bindBuffer(this.gl.ARRAY_BUFFER, vbo_handle);
                        this.gl.enableVertexAttribArray(attr_handle);
                        this.gl[funcname].apply(this.gl, tslib_1.__spread([attr_handle], args));
                    }
                    else {
                        this.gl.bindBuffer(this.gl.ARRAY_BUFFER, null);
                        this.gl.disableVertexAttribArray(attr_handle);
                        this.gl[funcname].apply(this.gl, tslib_1.__spread([attr_handle], args));
                    }
                }
            }
            catch (e_6_1) {
                e_6 = { error: e_6_1 };
            }
            finally {
                try {
                    if (_g && !_g.done && (_b = _f.return))
                        _b.call(_f);
                }
                finally {
                    if (e_6)
                        throw e_6.error;
                }
            }
            if (!this._validated) {
                this._validated = true;
                this._validate();
            }
        };
        Program.prototype._validate = function () {
            if (this._unset_variables.size) {
                console.log("Program has unset variables: " + this._unset_variables);
            }
            this.gl.validateProgram(this.handle);
            if (!this.gl.getProgramParameter(this.handle, this.gl.VALIDATE_STATUS)) {
                console.log(this.gl.getProgramInfoLog(this.handle));
                throw new Error("Program validation error");
            }
        };
        Program.prototype.draw = function (mode, selection) {
            // Draw the current visualization defined by the program.
            //
            // Parameters
            // ----------
            // mode : GL enum
            //     Can be POINTS, LINES, LINE_LOOP, LINE_STRIP, LINE_FAN, TRIANGLES
            // selection : 2-element tuple or IndexBuffer
            //     The selection to draw, specified either as (first, count) or an
            //     IndexBuffer object.
            if (!this._linked) {
                throw new Error("Cannot draw program if code has not been set");
            }
            if (selection instanceof buffer_1.IndexBuffer) {
                this._pre_draw();
                selection.activate();
                var count = selection.buffer_size / 2;
                var gtype = this.gl.UNSIGNED_SHORT;
                this.gl.drawElements(mode, count, gtype, 0);
                selection.deactivate();
            }
            else {
                var _a = tslib_1.__read(selection, 2), first = _a[0], count = _a[1];
                if (count != 0) {
                    this._pre_draw();
                    this.gl.drawArrays(mode, first, count);
                }
            }
        };
        return Program;
    }());
    exports.Program = Program;
    Program.__name__ = "Program";
},
/* models/glyphs/webgl/utils/buffer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var Buffer = /** @class */ (function () {
        function Buffer(gl) {
            this.gl = gl;
            this._usage = 35048;
            this.buffer_size = 0;
            this.handle = this.gl.createBuffer();
        }
        Buffer.prototype.delete = function () {
            this.gl.deleteBuffer(this.handle);
        };
        Buffer.prototype.activate = function () {
            this.gl.bindBuffer(this._target, this.handle);
        };
        Buffer.prototype.deactivate = function () {
            this.gl.bindBuffer(this._target, null);
        };
        Buffer.prototype.set_size = function (nbytes) {
            // Set the size of the buffer in bytes.
            //
            // Parameters
            // ----------
            // nbytes : int
            //     The number of bytes that the buffer needs to hold.
            if (nbytes != this.buffer_size) {
                this.activate();
                this.gl.bufferData(this._target, nbytes, this._usage);
                this.buffer_size = nbytes;
            }
        };
        Buffer.prototype.set_data = function (offset, data) {
            // Set the buffer data.
            //
            // Parameters
            // ----------
            // offset : int
            //     The offset in bytes for the new data.
            // data : typed array
            //     The data to upload.
            this.activate();
            this.gl.bufferSubData(this._target, offset, data);
        };
        return Buffer;
    }());
    exports.Buffer = Buffer;
    Buffer.__name__ = "Buffer";
    var VertexBuffer = /** @class */ (function (_super) {
        tslib_1.__extends(VertexBuffer, _super);
        function VertexBuffer() {
            var _this = _super.apply(this, tslib_1.__spread(arguments)) || this;
            _this._target = 34962;
            return _this;
        }
        return VertexBuffer;
    }(Buffer));
    exports.VertexBuffer = VertexBuffer;
    VertexBuffer.__name__ = "VertexBuffer";
    var IndexBuffer = /** @class */ (function (_super) {
        tslib_1.__extends(IndexBuffer, _super);
        function IndexBuffer() {
            var _this = _super.apply(this, tslib_1.__spread(arguments)) || this;
            _this._target = 34963;
            return _this;
        }
        return IndexBuffer;
    }(Buffer));
    exports.IndexBuffer = IndexBuffer;
    IndexBuffer.__name__ = "IndexBuffer";
},
/* models/glyphs/webgl/utils/texture.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var assert_1 = require(126) /* ../../../../core/util/assert */;
    var Texture2d = /** @class */ (function () {
        function Texture2d(gl) {
            this.gl = gl;
            this._target = 3553;
            this._types = {
                Int8Array: 5120,
                Uint8Array: 5121,
                Int16Array: 5122,
                Uint16Array: 5123,
                Int32Array: 5124,
                Uint32Array: 5125,
                Float32Array: 5126,
            };
            this.handle = this.gl.createTexture();
        }
        Texture2d.prototype.delete = function () {
            this.gl.deleteTexture(this.handle);
        };
        Texture2d.prototype.activate = function () {
            this.gl.bindTexture(this._target, this.handle);
        };
        Texture2d.prototype.deactivate = function () {
            this.gl.bindTexture(this._target, 0);
        };
        Texture2d.prototype._get_alignment = function (width) {
            var e_1, _a;
            // Determines a textures byte alignment. If the width isn't a
            // power of 2 we need to adjust the byte alignment of the image.
            // The image height is unimportant.
            //
            // www.opengl.org/wiki/Common_Mistakes#Texture_upload_and_pixel_reads
            var alignments = [4, 8, 2, 1];
            try {
                for (var alignments_1 = tslib_1.__values(alignments), alignments_1_1 = alignments_1.next(); !alignments_1_1.done; alignments_1_1 = alignments_1.next()) {
                    var alignment = alignments_1_1.value;
                    if (width % alignment == 0) {
                        return alignment;
                    }
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (alignments_1_1 && !alignments_1_1.done && (_a = alignments_1.return))
                        _a.call(alignments_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            assert_1.unreachable();
        };
        Texture2d.prototype.set_wrapping = function (wrap_s, wrap_t) {
            // Set the texture wrapping mode.
            //
            // Parameters
            // ----------
            // wrap_s : GL enum
            //     The mode to wrap the x dimension. Valid values are REPEAT
            //     CLAMP_TO_EDGE MIRRORED_REPEAT
            // wrap_t : GL enum
            //     The mode to wrap the y dimension. Same options as for wrap_s.
            this.activate();
            this.gl.texParameterf(this._target, this.gl.TEXTURE_WRAP_S, wrap_s);
            this.gl.texParameterf(this._target, this.gl.TEXTURE_WRAP_T, wrap_t);
        };
        Texture2d.prototype.set_interpolation = function (min, mag) {
            // Set the texture interpolation mode
            //
            // Parameters
            // ----------
            // min : GL enum
            //     The interpolation mode when minifying (i.e. zoomed out). Valid
            //     values are LINEAR and NEAREST.
            // max : GL enum
            //     The interpolation mode when magnifying (i.e. zoomed in). Valid
            //     values are LINEAR, NEAREST, NEAREST_MIPMAP_NEAREST,
            //     LINEAR_MIPMAP_NEAREST, NEAREST_MIPMAP_LINEAR, LINEAR_MIPMAP_LINEAR.
            this.activate();
            this.gl.texParameterf(this._target, this.gl.TEXTURE_MIN_FILTER, min);
            this.gl.texParameterf(this._target, this.gl.TEXTURE_MAG_FILTER, mag);
        };
        Texture2d.prototype.set_size = function (_a, format) {
            var _b, _c, _d;
            var _e = tslib_1.__read(_a, 2), width = _e[0], height = _e[1];
            // Set the size of the 2D texture.
            //
            // Parameters
            // ----------
            // shape : tuple of ints
            //     The shape of the data to upload
            // format : GL enum
            //     The format of the texture data. Can be LUMINANCE, LUMINANCE_ALPHA,
            //     RGB, and RGBA.
            if (width != ((_b = this._shape_format) === null || _b === void 0 ? void 0 : _b.width) || height != ((_c = this._shape_format) === null || _c === void 0 ? void 0 : _c.height) || format != ((_d = this._shape_format) === null || _d === void 0 ? void 0 : _d.format)) {
                this._shape_format = { width: width, height: height, format: format };
                this.activate();
                this.gl.texImage2D(this._target, 0, format, width, height, 0, format, this.gl.UNSIGNED_BYTE, null);
            }
        };
        Texture2d.prototype.set_data = function (offset, _a, data) {
            var _b = tslib_1.__read(_a, 2), width = _b[0], height = _b[1];
            // Set the 2D texture data.
            //
            // Parameters
            // ----------
            // offset : tuple of ints
            //     Offset in pixels for each dimension.
            // shape : tuple of ints
            //     The shape of the data to upload
            // data : typed array
            //     The actual pixel data. Can be of any type, but on the GPU the
            //     dat is stored in 8 bit precision.
            this.activate();
            var format = this._shape_format.format;
            var _c = tslib_1.__read(offset, 2), x = _c[0], y = _c[1];
            var gtype = this._types[data.constructor.name];
            if (gtype == null) {
                throw new Error("Type " + data.constructor.name + " not allowed for texture");
            }
            var alignment = this._get_alignment(width);
            if (alignment != 4) {
                this.gl.pixelStorei(this.gl.UNPACK_ALIGNMENT, alignment);
            }
            this.gl.texSubImage2D(this._target, 0, x, y, width, height, format, gtype, data);
            if (alignment != 4) {
                this.gl.pixelStorei(this.gl.UNPACK_ALIGNMENT, 4);
            }
        };
        return Texture2d;
    }());
    exports.Texture2d = Texture2d;
    Texture2d.__name__ = "Texture2d";
},
/* models/glyphs/webgl/base.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var BaseGLGlyph = /** @class */ (function () {
        function BaseGLGlyph(gl, glyph) {
            this.gl = gl;
            this.glyph = glyph;
            this.nvertices = 0;
            this.size_changed = false;
            this.data_changed = false;
            this.visuals_changed = false;
        }
        BaseGLGlyph.prototype.set_data_changed = function () {
            var data_size = this.glyph.data_size;
            if (data_size != this.nvertices) {
                this.nvertices = data_size;
                this.size_changed = true;
            }
            this.data_changed = true;
        };
        BaseGLGlyph.prototype.set_visuals_changed = function () {
            this.visuals_changed = true;
        };
        BaseGLGlyph.prototype.render = function (_ctx, indices, mainglyph) {
            if (indices.length == 0) {
                return true;
            }
            var _a = this.glyph.renderer.plot_view.canvas_view.webgl.canvas, width = _a.width, height = _a.height;
            var trans = {
                pixel_ratio: this.glyph.renderer.plot_view.canvas_view.pixel_ratio,
                width: width,
                height: height,
            };
            this.draw(indices, mainglyph, trans);
            return true;
        };
        return BaseGLGlyph;
    }());
    exports.BaseGLGlyph = BaseGLGlyph;
    BaseGLGlyph.__name__ = "BaseGLGlyph";
},
/* models/glyphs/webgl/line.vert.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var shader = "\nprecision mediump float;\n\nconst float PI = 3.14159265358979323846264;\nconst float THETA = 15.0 * 3.14159265358979323846264/180.0;\n\nuniform float u_pixel_ratio;\nuniform vec2 u_canvas_size, u_offset;\nuniform vec2 u_scale_aspect;\nuniform float u_scale_length;\n\nuniform vec4 u_color;\nuniform float u_antialias;\nuniform float u_length;\nuniform float u_linewidth;\nuniform float u_dash_index;\nuniform float u_closed;\n\nattribute vec2 a_position;\nattribute vec4 a_tangents;\nattribute vec2 a_segment;\nattribute vec2 a_angles;\nattribute vec2 a_texcoord;\n\nvarying vec4  v_color;\nvarying vec2  v_segment;\nvarying vec2  v_angles;\nvarying vec2  v_texcoord;\nvarying vec2  v_miter;\nvarying float v_length;\nvarying float v_linewidth;\n\nfloat cross(in vec2 v1, in vec2 v2)\n{\n    return v1.x*v2.y - v1.y*v2.x;\n}\n\nfloat signed_distance(in vec2 v1, in vec2 v2, in vec2 v3)\n{\n    return cross(v2-v1,v1-v3) / length(v2-v1);\n}\n\nvoid rotate( in vec2 v, in float alpha, out vec2 result )\n{\n    float c = cos(alpha);\n    float s = sin(alpha);\n    result = vec2( c*v.x - s*v.y,\n                   s*v.x + c*v.y );\n}\n\nvoid main()\n{\n    bool closed = (u_closed > 0.0);\n\n    // Attributes and uniforms to varyings\n    v_color = u_color;\n    v_linewidth = u_linewidth;\n    v_segment = a_segment * u_scale_length;\n    v_length = u_length * u_scale_length;\n\n    // Scale to map to pixel coordinates. The original algorithm from the paper\n    // assumed isotropic scale. We obviously do not have this.\n    vec2 abs_scale_aspect = abs(u_scale_aspect);\n    vec2 abs_scale = u_scale_length * abs_scale_aspect;\n\n    // Correct angles for aspect ratio\n    vec2 av;\n    av = vec2(1.0, tan(a_angles.x)) / abs_scale_aspect;\n    v_angles.x = atan(av.y, av.x);\n    av = vec2(1.0, tan(a_angles.y)) / abs_scale_aspect;\n    v_angles.y = atan(av.y, av.x);\n\n    // Thickness below 1 pixel are represented using a 1 pixel thickness\n    // and a modified alpha\n    v_color.a = min(v_linewidth, v_color.a);\n    v_linewidth = max(v_linewidth, 1.0);\n\n    // If color is fully transparent we just will discard the fragment anyway\n    if( v_color.a <= 0.0 ) {\n        gl_Position = vec4(0.0,0.0,0.0,1.0);\n        return;\n    }\n\n    // This is the actual half width of the line\n    float w = ceil(u_antialias+v_linewidth)/2.0;\n\n    vec2 position = a_position;\n\n    vec2 t1 = normalize(a_tangents.xy * abs_scale_aspect);  // note the scaling for aspect ratio here\n    vec2 t2 = normalize(a_tangents.zw * abs_scale_aspect);\n    float u = a_texcoord.x;\n    float v = a_texcoord.y;\n    vec2 o1 = vec2( +t1.y, -t1.x);\n    vec2 o2 = vec2( +t2.y, -t2.x);\n\n    // This is a join\n    // ----------------------------------------------------------------\n    if( t1 != t2 ) {\n        float angle = atan (t1.x*t2.y-t1.y*t2.x, t1.x*t2.x+t1.y*t2.y);  // Angle needs recalculation for some reason\n        vec2 t  = normalize(t1+t2);\n        vec2 o  = vec2( + t.y, - t.x);\n\n        if ( u_dash_index > 0.0 )\n        {\n            // Broken angle\n            // ----------------------------------------------------------------\n            if( (abs(angle) > THETA) ) {\n                position += v * w * o / cos(angle/2.0);\n                float s = sign(angle);\n                if( angle < 0.0 ) {\n                    if( u == +1.0 ) {\n                        u = v_segment.y + v * w * tan(angle/2.0);\n                        if( v == 1.0 ) {\n                            position -= 2.0 * w * t1 / sin(angle);\n                            u -= 2.0 * w / sin(angle);\n                        }\n                    } else {\n                        u = v_segment.x - v * w * tan(angle/2.0);\n                        if( v == 1.0 ) {\n                            position += 2.0 * w * t2 / sin(angle);\n                            u += 2.0*w / sin(angle);\n                        }\n                    }\n                } else {\n                    if( u == +1.0 ) {\n                        u = v_segment.y + v * w * tan(angle/2.0);\n                        if( v == -1.0 ) {\n                            position += 2.0 * w * t1 / sin(angle);\n                            u += 2.0 * w / sin(angle);\n                        }\n                    } else {\n                        u = v_segment.x - v * w * tan(angle/2.0);\n                        if( v == -1.0 ) {\n                            position -= 2.0 * w * t2 / sin(angle);\n                            u -= 2.0*w / sin(angle);\n                        }\n                    }\n                }\n                // Continuous angle\n                // ------------------------------------------------------------\n            } else {\n                position += v * w * o / cos(angle/2.0);\n                if( u == +1.0 ) u = v_segment.y;\n                else            u = v_segment.x;\n            }\n        }\n\n        // Solid line\n        // --------------------------------------------------------------------\n        else\n        {\n            position.xy += v * w * o / cos(angle/2.0);\n            if( angle < 0.0 ) {\n                if( u == +1.0 ) {\n                    u = v_segment.y + v * w * tan(angle/2.0);\n                } else {\n                    u = v_segment.x - v * w * tan(angle/2.0);\n                }\n            } else {\n                if( u == +1.0 ) {\n                    u = v_segment.y + v * w * tan(angle/2.0);\n                } else {\n                    u = v_segment.x - v * w * tan(angle/2.0);\n                }\n            }\n        }\n\n    // This is a line start or end (t1 == t2)\n    // ------------------------------------------------------------------------\n    } else {\n        position += v * w * o1;\n        if( u == -1.0 ) {\n            u = v_segment.x - w;\n            position -= w * t1;\n        } else {\n            u = v_segment.y + w;\n            position += w * t2;\n        }\n    }\n\n    // Miter distance\n    // ------------------------------------------------------------------------\n    vec2 t;\n    vec2 curr = a_position * abs_scale;\n    if( a_texcoord.x < 0.0 ) {\n        vec2 next = curr + t2*(v_segment.y-v_segment.x);\n\n        rotate( t1, +v_angles.x/2.0, t);\n        v_miter.x = signed_distance(curr, curr+t, position);\n\n        rotate( t2, +v_angles.y/2.0, t);\n        v_miter.y = signed_distance(next, next+t, position);\n    } else {\n        vec2 prev = curr - t1*(v_segment.y-v_segment.x);\n\n        rotate( t1, -v_angles.x/2.0,t);\n        v_miter.x = signed_distance(prev, prev+t, position);\n\n        rotate( t2, -v_angles.y/2.0,t);\n        v_miter.y = signed_distance(curr, curr+t, position);\n    }\n\n    if (!closed && v_segment.x <= 0.0) {\n        v_miter.x = 1e10;\n    }\n    if (!closed && v_segment.y >= v_length)\n    {\n        v_miter.y = 1e10;\n    }\n\n    v_texcoord = vec2( u, v*w );\n\n    // Calculate position in device coordinates. Note that we\n    // already scaled with abs scale above.\n    vec2 normpos = position * sign(u_scale_aspect);\n    normpos += 0.5;  // make up for Bokeh's offset\n    normpos /= u_canvas_size / u_pixel_ratio;  // in 0..1\n    gl_Position = vec4(normpos*2.0-1.0, 0.0, 1.0);\n    gl_Position.y *= -1.0;\n}\n";
    exports.default = shader;
},
/* models/glyphs/webgl/line.frag.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var shader = "\nprecision mediump float;\n\nconst float PI = 3.14159265358979323846264;\nconst float THETA = 15.0 * 3.14159265358979323846264/180.0;\n\nuniform sampler2D u_dash_atlas;\n\nuniform vec2 u_linecaps;\nuniform float u_miter_limit;\nuniform float u_linejoin;\nuniform float u_antialias;\nuniform float u_dash_phase;\nuniform float u_dash_period;\nuniform float u_dash_index;\nuniform vec2 u_dash_caps;\nuniform float u_closed;\n\nvarying vec4  v_color;\nvarying vec2  v_segment;\nvarying vec2  v_angles;\nvarying vec2  v_texcoord;\nvarying vec2  v_miter;\nvarying float v_length;\nvarying float v_linewidth;\n\n// Compute distance to cap ----------------------------------------------------\nfloat cap( int type, float dx, float dy, float t, float linewidth )\n{\n    float d = 0.0;\n    dx = abs(dx);\n    dy = abs(dy);\n    if      (type == 0)  discard;  // None\n    else if (type == 1)  d = sqrt(dx*dx+dy*dy);  // Round\n    else if (type == 3)  d = (dx+abs(dy));  // Triangle in\n    else if (type == 2)  d = max(abs(dy),(t+dx-abs(dy)));  // Triangle out\n    else if (type == 4)  d = max(dx,dy);  // Square\n    else if (type == 5)  d = max(dx+t,dy);  // Butt\n    return d;\n}\n\n// Compute distance to join -------------------------------------------------\nfloat join( in int type, in float d, in vec2 segment, in vec2 texcoord, in vec2 miter,\n           in float linewidth )\n{\n    // texcoord.x is distance from start\n    // texcoord.y is distance from centerline\n    // segment.x and y indicate the limits (as for texcoord.x) for this segment\n\n    float dx = texcoord.x;\n\n    // Round join\n    if( type == 1 ) {\n        if (dx < segment.x) {\n            d = max(d,length( texcoord - vec2(segment.x,0.0)));\n            //d = length( texcoord - vec2(segment.x,0.0));\n        } else if (dx > segment.y) {\n            d = max(d,length( texcoord - vec2(segment.y,0.0)));\n            //d = length( texcoord - vec2(segment.y,0.0));\n        }\n    }\n    // Bevel join\n    else if ( type == 2 ) {\n        if (dx < segment.x) {\n            vec2 x = texcoord - vec2(segment.x,0.0);\n            d = max(d, max(abs(x.x), abs(x.y)));\n\n        } else if (dx > segment.y) {\n            vec2 x = texcoord - vec2(segment.y,0.0);\n            d = max(d, max(abs(x.x), abs(x.y)));\n        }\n        /*  Original code for bevel which does not work for us\n        if( (dx < segment.x) ||  (dx > segment.y) )\n            d = max(d, min(abs(x.x),abs(x.y)));\n        */\n    }\n\n    return d;\n}\n\nvoid main()\n{\n    // If color is fully transparent we just discard the fragment\n    if( v_color.a <= 0.0 ) {\n        discard;\n    }\n\n    // Test if dash pattern is the solid one (0)\n    bool solid =  (u_dash_index == 0.0);\n\n    // Test if path is closed\n    bool closed = (u_closed > 0.0);\n\n    vec4 color = v_color;\n    float dx = v_texcoord.x;\n    float dy = v_texcoord.y;\n    float t = v_linewidth/2.0-u_antialias;\n    float width = 1.0;  //v_linewidth; original code had dashes scale with line width, we do not\n    float d = 0.0;\n\n    vec2 linecaps = u_linecaps;\n    vec2 dash_caps = u_dash_caps;\n    float line_start = 0.0;\n    float line_stop = v_length;\n\n    // Apply miter limit; fragments too far into the miter are simply discarded\n    if( (dx < v_segment.x) || (dx > v_segment.y) ) {\n        float into_miter = max(v_segment.x - dx, dx - v_segment.y);\n        if (into_miter > u_miter_limit*v_linewidth/2.0)\n          discard;\n    }\n\n    // Solid line --------------------------------------------------------------\n    if( solid ) {\n        d = abs(dy);\n        if( (!closed) && (dx < line_start) ) {\n            d = cap( int(u_linecaps.x), abs(dx), abs(dy), t, v_linewidth );\n        }\n        else if( (!closed) &&  (dx > line_stop) ) {\n            d = cap( int(u_linecaps.y), abs(dx)-line_stop, abs(dy), t, v_linewidth );\n        }\n        else {\n            d = join( int(u_linejoin), abs(dy), v_segment, v_texcoord, v_miter, v_linewidth );\n        }\n\n    // Dash line --------------------------------------------------------------\n    } else {\n        float segment_start = v_segment.x;\n        float segment_stop  = v_segment.y;\n        float segment_center= (segment_start+segment_stop)/2.0;\n        float freq          = u_dash_period*width;\n        float u = mod( dx + u_dash_phase*width, freq);\n        vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n        float dash_center= tex.x * width;\n        float dash_type  = tex.y;\n        float _start = tex.z * width;\n        float _stop  = tex.a * width;\n        float dash_start = dx - u + _start;\n        float dash_stop  = dx - u + _stop;\n\n        // Compute extents of the first dash (the one relative to v_segment.x)\n        // Note: this could be computed in the vertex shader\n        if( (dash_stop < segment_start) && (dash_caps.x != 5.0) ) {\n            float u = mod(segment_start + u_dash_phase*width, freq);\n            vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n            dash_center= tex.x * width;\n            //dash_type  = tex.y;\n            float _start = tex.z * width;\n            float _stop  = tex.a * width;\n            dash_start = segment_start - u + _start;\n            dash_stop = segment_start - u + _stop;\n        }\n\n        // Compute extents of the last dash (the one relatives to v_segment.y)\n        // Note: This could be computed in the vertex shader\n        else if( (dash_start > segment_stop)  && (dash_caps.y != 5.0) ) {\n            float u = mod(segment_stop + u_dash_phase*width, freq);\n            vec4 tex = texture2D(u_dash_atlas, vec2(u/freq, u_dash_index)) * 255.0 -10.0;  // conversion to int-like\n            dash_center= tex.x * width;\n            //dash_type  = tex.y;\n            float _start = tex.z * width;\n            float _stop  = tex.a * width;\n            dash_start = segment_stop - u + _start;\n            dash_stop  = segment_stop - u + _stop;\n        }\n\n        // This test if the we are dealing with a discontinuous angle\n        bool discontinuous = ((dx <  segment_center) && abs(v_angles.x) > THETA) ||\n                             ((dx >= segment_center) && abs(v_angles.y) > THETA);\n        //if( dx < line_start) discontinuous = false;\n        //if( dx > line_stop)  discontinuous = false;\n\n        float d_join = join( int(u_linejoin), abs(dy),\n                            v_segment, v_texcoord, v_miter, v_linewidth );\n\n        // When path is closed, we do not have room for linecaps, so we make room\n        // by shortening the total length\n        if (closed) {\n             line_start += v_linewidth/2.0;\n             line_stop  -= v_linewidth/2.0;\n        }\n\n        // We also need to take antialias area into account\n        //line_start += u_antialias;\n        //line_stop  -= u_antialias;\n\n        // Check is dash stop is before line start\n        if( dash_stop <= line_start ) {\n            discard;\n        }\n        // Check is dash start is beyond line stop\n        if( dash_start >= line_stop ) {\n            discard;\n        }\n\n        // Check if current dash start is beyond segment stop\n        if( discontinuous ) {\n            // Dash start is beyond segment, we discard\n            if( (dash_start > segment_stop) ) {\n                discard;\n                //gl_FragColor = vec4(1.0,0.0,0.0,.25); return;\n            }\n\n            // Dash stop is before segment, we discard\n            if( (dash_stop < segment_start) ) {\n                discard;  //gl_FragColor = vec4(0.0,1.0,0.0,.25); return;\n            }\n\n            // Special case for round caps (nicer with this)\n            if( dash_caps.x == 1.0 ) {\n                if( (u > _stop) && (dash_stop > segment_stop )  && (abs(v_angles.y) < PI/2.0)) {\n                    discard;\n                }\n            }\n\n            // Special case for round caps  (nicer with this)\n            if( dash_caps.y == 1.0 ) {\n                if( (u < _start) && (dash_start < segment_start )  && (abs(v_angles.x) < PI/2.0)) {\n                    discard;\n                }\n            }\n\n            // Special case for triangle caps (in & out) and square\n            // We make sure the cap stop at crossing frontier\n            if( (dash_caps.x != 1.0) && (dash_caps.x != 5.0) ) {\n                if( (dash_start < segment_start )  && (abs(v_angles.x) < PI/2.0) ) {\n                    float a = v_angles.x/2.0;\n                    float x = (segment_start-dx)*cos(a) - dy*sin(a);\n                    float y = (segment_start-dx)*sin(a) + dy*cos(a);\n                    if( x > 0.0 ) discard;\n                    // We transform the cap into square to avoid holes\n                    dash_caps.x = 4.0;\n                }\n            }\n\n            // Special case for triangle caps (in & out) and square\n            // We make sure the cap stop at crossing frontier\n            if( (dash_caps.y != 1.0) && (dash_caps.y != 5.0) ) {\n                if( (dash_stop > segment_stop )  && (abs(v_angles.y) < PI/2.0) ) {\n                    float a = v_angles.y/2.0;\n                    float x = (dx-segment_stop)*cos(a) - dy*sin(a);\n                    float y = (dx-segment_stop)*sin(a) + dy*cos(a);\n                    if( x > 0.0 ) discard;\n                    // We transform the caps into square to avoid holes\n                    dash_caps.y = 4.0;\n                }\n            }\n        }\n\n        // Line cap at start\n        if( (dx < line_start) && (dash_start < line_start) && (dash_stop > line_start) ) {\n            d = cap( int(linecaps.x), dx-line_start, dy, t, v_linewidth);\n        }\n        // Line cap at stop\n        else if( (dx > line_stop) && (dash_stop > line_stop) && (dash_start < line_stop) ) {\n            d = cap( int(linecaps.y), dx-line_stop, dy, t, v_linewidth);\n        }\n        // Dash cap left - dash_type = -1, 0 or 1, but there may be roundoff errors\n        else if( dash_type < -0.5 ) {\n            d = cap( int(dash_caps.y), abs(u-dash_center), dy, t, v_linewidth);\n            if( (dx > line_start) && (dx < line_stop) )\n                d = max(d,d_join);\n        }\n        // Dash cap right\n        else if( dash_type > 0.5 ) {\n            d = cap( int(dash_caps.x), abs(dash_center-u), dy, t, v_linewidth);\n            if( (dx > line_start) && (dx < line_stop) )\n                d = max(d,d_join);\n        }\n        // Dash body (plain)\n        else {// if( dash_type > -0.5 &&  dash_type < 0.5) {\n            d = abs(dy);\n        }\n\n        // Line join\n        if( (dx > line_start) && (dx < line_stop)) {\n            if( (dx <= segment_start) && (dash_start <= segment_start)\n                && (dash_stop >= segment_start) ) {\n                d = d_join;\n                // Antialias at outer border\n                float angle = PI/2.+v_angles.x;\n                float f = abs( (segment_start - dx)*cos(angle) - dy*sin(angle));\n                d = max(f,d);\n            }\n            else if( (dx > segment_stop) && (dash_start <= segment_stop)\n                     && (dash_stop >= segment_stop) ) {\n                d = d_join;\n                // Antialias at outer border\n                float angle = PI/2.+v_angles.y;\n                float f = abs((dx - segment_stop)*cos(angle) - dy*sin(angle));\n                d = max(f,d);\n            }\n            else if( dx < (segment_start - v_linewidth/2.)) {\n                discard;\n            }\n            else if( dx > (segment_stop + v_linewidth/2.)) {\n                discard;\n            }\n        }\n        else if( dx < (segment_start - v_linewidth/2.)) {\n            discard;\n        }\n        else if( dx > (segment_stop + v_linewidth/2.)) {\n            discard;\n        }\n    }\n\n    // Distance to border ------------------------------------------------------\n    d = d - t;\n    if( d < 0.0 ) {\n        gl_FragColor = color;\n    } else {\n        d /= u_antialias;\n        gl_FragColor = vec4(color.rgb, exp(-d*d)*color.a);\n    }\n}\n";
    exports.default = shader;
},
/* models/glyphs/patch.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var xy_glyph_1 = require(179) /* ./xy_glyph */;
    var utils_1 = require(221) /* ./utils */;
    var hittest = tslib_1.__importStar(require(222) /* ../../core/hittest */);
    var mixins = tslib_1.__importStar(require(163) /* ../../core/property_mixins */);
    var selection_1 = require(174) /* ../selections/selection */;
    var PatchView = /** @class */ (function (_super) {
        tslib_1.__extends(PatchView, _super);
        function PatchView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        PatchView.prototype._inner_loop = function (ctx, indices, sx, sy, func) {
            var e_1, _a;
            try {
                for (var indices_1 = tslib_1.__values(indices), indices_1_1 = indices_1.next(); !indices_1_1.done; indices_1_1 = indices_1.next()) {
                    var i = indices_1_1.value;
                    var sx_i = sx[i];
                    var sy_i = sy[i];
                    if (i == 0) {
                        ctx.beginPath();
                        ctx.moveTo(sx_i, sy_i);
                        continue;
                    }
                    else if (isNaN(sx_i + sy_i)) {
                        ctx.closePath();
                        func.apply(ctx);
                        ctx.beginPath();
                        continue;
                    }
                    else
                        ctx.lineTo(sx_i, sy_i);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (indices_1_1 && !indices_1_1.done && (_a = indices_1.return))
                        _a.call(indices_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            ctx.closePath();
            func.call(ctx);
        };
        PatchView.prototype._render = function (ctx, indices, data) {
            var _a = data !== null && data !== void 0 ? data : this, sx = _a.sx, sy = _a.sy;
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_value(ctx);
                this._inner_loop(ctx, indices, sx, sy, ctx.fill);
            }
            if (this.visuals.hatch.doit) {
                this.visuals.hatch.set_value(ctx);
                this._inner_loop(ctx, indices, sx, sy, ctx.fill);
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_value(ctx);
                this._inner_loop(ctx, indices, sx, sy, ctx.stroke);
            }
        };
        PatchView.prototype.draw_legend_for_index = function (ctx, bbox, _index) {
            utils_1.generic_area_scalar_legend(this.visuals, ctx, bbox);
        };
        PatchView.prototype._hit_point = function (geometry) {
            var result = new selection_1.Selection();
            if (hittest.point_in_poly(geometry.sx, geometry.sy, this.sx, this.sy)) {
                result.add_to_selected_glyphs(this.model);
                result.view = this;
            }
            return result;
        };
        return PatchView;
    }(xy_glyph_1.XYGlyphView));
    exports.PatchView = PatchView;
    PatchView.__name__ = "PatchView";
    var Patch = /** @class */ (function (_super) {
        tslib_1.__extends(Patch, _super);
        function Patch(attrs) {
            return _super.call(this, attrs) || this;
        }
        Patch.init_Patch = function () {
            this.prototype.default_view = PatchView;
            this.mixins([mixins.LineScalar, mixins.FillScalar, mixins.HatchScalar]);
        };
        return Patch;
    }(xy_glyph_1.XYGlyph));
    exports.Patch = Patch;
    Patch.__name__ = "Patch";
    Patch.init_Patch();
},
/* models/glyphs/harea.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var types_1 = require(139) /* ../../core/types */;
    var area_1 = require(233) /* ./area */;
    var hittest = tslib_1.__importStar(require(222) /* ../../core/hittest */);
    var p = tslib_1.__importStar(require(133) /* ../../core/properties */);
    var selection_1 = require(174) /* ../selections/selection */;
    var HAreaView = /** @class */ (function (_super) {
        tslib_1.__extends(HAreaView, _super);
        function HAreaView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        HAreaView.prototype._index_data = function (index) {
            var min = Math.min, max = Math.max;
            var data_size = this.data_size;
            for (var i = 0; i < data_size; i++) {
                var x1 = this._x1[i];
                var x2 = this._x2[i];
                var y = this._y[i];
                if (isNaN(x1 + x2 + y) || !isFinite(x1 + x2 + y))
                    index.add_empty();
                else
                    index.add(min(x1, x2), y, max(x1, x2), y);
            }
        };
        HAreaView.prototype._inner = function (ctx, sx1, sx2, sy, func) {
            ctx.beginPath();
            for (var i = 0, end = sx1.length; i < end; i++) {
                ctx.lineTo(sx1[i], sy[i]);
            }
            // iterate backwards so that the upper end is below the lower start
            for (var i = sx2.length - 1; i >= 0; i--) {
                ctx.lineTo(sx2[i], sy[i]);
            }
            ctx.closePath();
            func.call(ctx);
        };
        HAreaView.prototype._render = function (ctx, _indices, data) {
            var _a = data !== null && data !== void 0 ? data : this, sx1 = _a.sx1, sx2 = _a.sx2, sy = _a.sy;
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_value(ctx);
                this._inner(ctx, sx1, sx2, sy, ctx.fill);
            }
            if (this.visuals.hatch.doit) {
                this.visuals.hatch.set_value(ctx);
                this._inner(ctx, sx1, sx2, sy, ctx.fill);
            }
        };
        HAreaView.prototype._hit_point = function (geometry) {
            var L = this.sy.length;
            var sx = new types_1.ScreenArray(2 * L);
            var sy = new types_1.ScreenArray(2 * L);
            for (var i = 0, end = L; i < end; i++) {
                sx[i] = this.sx1[i];
                sy[i] = this.sy[i];
                sx[L + i] = this.sx2[L - i - 1];
                sy[L + i] = this.sy[L - i - 1];
            }
            var result = new selection_1.Selection();
            if (hittest.point_in_poly(geometry.sx, geometry.sy, sx, sy)) {
                result.add_to_selected_glyphs(this.model);
                result.view = this;
            }
            return result;
        };
        HAreaView.prototype.scenterxy = function (i) {
            var scx = (this.sx1[i] + this.sx2[i]) / 2;
            var scy = this.sy[i];
            return [scx, scy];
        };
        HAreaView.prototype._map_data = function () {
            this.sx1 = this.renderer.xscale.v_compute(this._x1);
            this.sx2 = this.renderer.xscale.v_compute(this._x2);
            this.sy = this.renderer.yscale.v_compute(this._y);
        };
        return HAreaView;
    }(area_1.AreaView));
    exports.HAreaView = HAreaView;
    HAreaView.__name__ = "HAreaView";
    var HArea = /** @class */ (function (_super) {
        tslib_1.__extends(HArea, _super);
        function HArea(attrs) {
            return _super.call(this, attrs) || this;
        }
        HArea.init_HArea = function () {
            this.prototype.default_view = HAreaView;
            this.define(function (_a) {
                return ({
                    x1: [p.XCoordinateSpec, { field: "x1" }],
                    x2: [p.XCoordinateSpec, { field: "x2" }],
                    y: [p.YCoordinateSpec, { field: "y" }],
                });
            });
        };
        return HArea;
    }(area_1.Area));
    exports.HArea = HArea;
    HArea.__name__ = "HArea";
    HArea.init_HArea();
},
/* models/glyphs/area.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var glyph_1 = require(213) /* ./glyph */;
    var utils_1 = require(221) /* ./utils */;
    var mixins = tslib_1.__importStar(require(163) /* ../../core/property_mixins */);
    var AreaView = /** @class */ (function (_super) {
        tslib_1.__extends(AreaView, _super);
        function AreaView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        AreaView.prototype.draw_legend_for_index = function (ctx, bbox, _index) {
            utils_1.generic_area_scalar_legend(this.visuals, ctx, bbox);
        };
        return AreaView;
    }(glyph_1.GlyphView));
    exports.AreaView = AreaView;
    AreaView.__name__ = "AreaView";
    var Area = /** @class */ (function (_super) {
        tslib_1.__extends(Area, _super);
        function Area(attrs) {
            return _super.call(this, attrs) || this;
        }
        Area.init_Area = function () {
            this.mixins([mixins.FillScalar, mixins.HatchScalar]);
        };
        return Area;
    }(glyph_1.Glyph));
    exports.Area = Area;
    Area.__name__ = "Area";
    Area.init_Area();
},
/* models/glyphs/varea.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var types_1 = require(139) /* ../../core/types */;
    var area_1 = require(233) /* ./area */;
    var hittest = tslib_1.__importStar(require(222) /* ../../core/hittest */);
    var p = tslib_1.__importStar(require(133) /* ../../core/properties */);
    var selection_1 = require(174) /* ../selections/selection */;
    var VAreaView = /** @class */ (function (_super) {
        tslib_1.__extends(VAreaView, _super);
        function VAreaView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        VAreaView.prototype._index_data = function (index) {
            var min = Math.min, max = Math.max;
            var data_size = this.data_size;
            for (var i = 0; i < data_size; i++) {
                var x = this._x[i];
                var y1 = this._y1[i];
                var y2 = this._y2[i];
                if (isNaN(x + y1 + y2) || !isFinite(x + y1 + y2))
                    index.add_empty();
                else
                    index.add(x, min(y1, y2), x, max(y1, y2));
            }
        };
        VAreaView.prototype._inner = function (ctx, sx, sy1, sy2, func) {
            ctx.beginPath();
            for (var i = 0, end = sy1.length; i < end; i++) {
                ctx.lineTo(sx[i], sy1[i]);
            }
            // iterate backwards so that the upper end is below the lower start
            for (var i = sy2.length - 1; i >= 0; i--) {
                ctx.lineTo(sx[i], sy2[i]);
            }
            ctx.closePath();
            func.call(ctx);
        };
        VAreaView.prototype._render = function (ctx, _indices, data) {
            var _a = data !== null && data !== void 0 ? data : this, sx = _a.sx, sy1 = _a.sy1, sy2 = _a.sy2;
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_value(ctx);
                this._inner(ctx, sx, sy1, sy2, ctx.fill);
            }
            if (this.visuals.hatch.doit) {
                this.visuals.hatch.set_value(ctx);
                this._inner(ctx, sx, sy1, sy2, ctx.fill);
            }
        };
        VAreaView.prototype.scenterxy = function (i) {
            var scx = this.sx[i];
            var scy = (this.sy1[i] + this.sy2[i]) / 2;
            return [scx, scy];
        };
        VAreaView.prototype._hit_point = function (geometry) {
            var L = this.sx.length;
            var sx = new types_1.ScreenArray(2 * L);
            var sy = new types_1.ScreenArray(2 * L);
            for (var i = 0, end = L; i < end; i++) {
                sx[i] = this.sx[i];
                sy[i] = this.sy1[i];
                sx[L + i] = this.sx[L - i - 1];
                sy[L + i] = this.sy2[L - i - 1];
            }
            var result = new selection_1.Selection();
            if (hittest.point_in_poly(geometry.sx, geometry.sy, sx, sy)) {
                result.add_to_selected_glyphs(this.model);
                result.view = this;
            }
            return result;
        };
        VAreaView.prototype._map_data = function () {
            this.sx = this.renderer.xscale.v_compute(this._x);
            this.sy1 = this.renderer.yscale.v_compute(this._y1);
            this.sy2 = this.renderer.yscale.v_compute(this._y2);
        };
        return VAreaView;
    }(area_1.AreaView));
    exports.VAreaView = VAreaView;
    VAreaView.__name__ = "VAreaView";
    var VArea = /** @class */ (function (_super) {
        tslib_1.__extends(VArea, _super);
        function VArea(attrs) {
            return _super.call(this, attrs) || this;
        }
        VArea.init_VArea = function () {
            this.prototype.default_view = VAreaView;
            this.define(function (_a) {
                return ({
                    x: [p.XCoordinateSpec, { field: "x" }],
                    y1: [p.YCoordinateSpec, { field: "y1" }],
                    y2: [p.YCoordinateSpec, { field: "y2" }],
                });
            });
        };
        return VArea;
    }(area_1.Area));
    exports.VArea = VArea;
    VArea.__name__ = "VArea";
    VArea.init_VArea();
},
/* models/sources/cds_view.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var model_1 = require(168) /* ../../model */;
    var selection_1 = require(174) /* ../selections/selection */;
    var types_1 = require(139) /* ../../core/types */;
    var filter_1 = require(236) /* ../filters/filter */;
    var columnar_data_source_1 = require(172) /* ./columnar_data_source */;
    var CDSView = /** @class */ (function (_super) {
        tslib_1.__extends(CDSView, _super);
        function CDSView(attrs) {
            return _super.call(this, attrs) || this;
        }
        CDSView.init_CDSView = function () {
            this.define(function (_a) {
                var Array = _a.Array, Ref = _a.Ref;
                return ({
                    filters: [Array(Ref(filter_1.Filter)), []],
                    source: [Ref(columnar_data_source_1.ColumnarDataSource)],
                });
            });
            this.internal(function (_a) {
                var Int = _a.Int, Dict = _a.Dict, Ref = _a.Ref, Nullable = _a.Nullable;
                return ({
                    indices: [Ref(types_1.Indices)],
                    indices_map: [Dict(Int), {}],
                    masked: [Nullable(Ref(types_1.Indices)), null],
                });
            });
        };
        CDSView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.compute_indices();
        };
        CDSView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.properties.filters.change, function () { return _this.compute_indices(); });
            var connect_listeners = function () {
                var fn = function () { return _this.compute_indices(); };
                if (_this.source != null) {
                    _this.connect(_this.source.change, fn);
                    if (_this.source instanceof columnar_data_source_1.ColumnarDataSource) {
                        _this.connect(_this.source.streaming, fn);
                        _this.connect(_this.source.patching, fn);
                    }
                }
            };
            var initialized = this.source != null;
            if (initialized)
                connect_listeners();
            else {
                this.connect(this.properties.source.change, function () {
                    if (!initialized) {
                        connect_listeners();
                        initialized = true;
                    }
                });
            }
        };
        CDSView.prototype.compute_indices = function () {
            var e_1, _a;
            var _b;
            var source = this.source;
            if (source == null)
                return;
            // XXX: if the data source is empty, there still may be one
            // index originating from glyph's scalar values.
            var size = (_b = source.get_length()) !== null && _b !== void 0 ? _b : 1;
            var indices = types_1.Indices.all_set(size);
            try {
                for (var _c = tslib_1.__values(this.filters), _d = _c.next(); !_d.done; _d = _c.next()) {
                    var filter = _d.value;
                    indices.intersect(filter.compute_indices(source));
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_d && !_d.done && (_a = _c.return))
                        _a.call(_c);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            this.indices = indices;
            this._indices = tslib_1.__spread(indices);
            this.indices_map_to_subset();
        };
        CDSView.prototype.indices_map_to_subset = function () {
            this.indices_map = {};
            for (var i = 0; i < this._indices.length; i++) {
                this.indices_map[this._indices[i]] = i;
            }
        };
        CDSView.prototype.convert_selection_from_subset = function (selection_subset) {
            var _this = this;
            var indices = selection_subset.indices.map(function (i) { return _this._indices[i]; });
            return new selection_1.Selection(tslib_1.__assign(tslib_1.__assign({}, selection_subset.attributes), { indices: indices }));
        };
        CDSView.prototype.convert_selection_to_subset = function (selection_full) {
            var _this = this;
            var indices = selection_full.indices.map(function (i) { return _this.indices_map[i]; });
            return new selection_1.Selection(tslib_1.__assign(tslib_1.__assign({}, selection_full.attributes), { indices: indices }));
        };
        CDSView.prototype.convert_indices_from_subset = function (indices) {
            var _this = this;
            return indices.map(function (i) { return _this._indices[i]; });
        };
        return CDSView;
    }(model_1.Model));
    exports.CDSView = CDSView;
    CDSView.__name__ = "CDSView";
    CDSView.init_CDSView();
},
/* models/filters/filter.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var model_1 = require(168) /* ../../model */;
    var Filter = /** @class */ (function (_super) {
        tslib_1.__extends(Filter, _super);
        function Filter(attrs) {
            return _super.call(this, attrs) || this;
        }
        return Filter;
    }(model_1.Model));
    exports.Filter = Filter;
    Filter.__name__ = "Filter";
},
/* core/build_views.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var array_1 = require(124) /* ./util/array */;
    function _build_view(view_cls, model, options) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var view;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        view = new view_cls(tslib_1.__assign(tslib_1.__assign({}, options), { model: model }));
                        view.initialize();
                        return [4 /*yield*/, view.lazy_initialize()];
                    case 1:
                        _a.sent();
                        return [2 /*return*/, view];
                }
            });
        });
    }
    function build_view(model, options, cls) {
        if (options === void 0) {
            options = { parent: null };
        }
        if (cls === void 0) {
            cls = function (model) { return model.default_view; };
        }
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var view;
            return tslib_1.__generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, _build_view(cls(model), model, options)];
                    case 1:
                        view = _a.sent();
                        view.connect_signals();
                        return [2 /*return*/, view];
                }
            });
        });
    }
    exports.build_view = build_view;
    function build_views(view_storage, models, options, cls) {
        if (options === void 0) {
            options = { parent: null };
        }
        if (cls === void 0) {
            cls = function (model) { return model.default_view; };
        }
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            var to_remove, to_remove_1, to_remove_1_1, model, created_views, new_models, new_models_1, new_models_1_1, model, view, e_1_1, created_views_1, created_views_1_1, view;
            var e_2, _a, e_1, _b, e_3, _c;
            return tslib_1.__generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        to_remove = array_1.difference(tslib_1.__spread(view_storage.keys()), models);
                        try {
                            for (to_remove_1 = tslib_1.__values(to_remove), to_remove_1_1 = to_remove_1.next(); !to_remove_1_1.done; to_remove_1_1 = to_remove_1.next()) {
                                model = to_remove_1_1.value;
                                view_storage.get(model).remove();
                                view_storage.delete(model);
                            }
                        }
                        catch (e_2_1) {
                            e_2 = { error: e_2_1 };
                        }
                        finally {
                            try {
                                if (to_remove_1_1 && !to_remove_1_1.done && (_a = to_remove_1.return))
                                    _a.call(to_remove_1);
                            }
                            finally {
                                if (e_2)
                                    throw e_2.error;
                            }
                        }
                        created_views = [];
                        new_models = models.filter(function (model) { return !view_storage.has(model); });
                        _d.label = 1;
                    case 1:
                        _d.trys.push([1, 6, 7, 8]);
                        new_models_1 = tslib_1.__values(new_models), new_models_1_1 = new_models_1.next();
                        _d.label = 2;
                    case 2:
                        if (!!new_models_1_1.done)
                            return [3 /*break*/, 5];
                        model = new_models_1_1.value;
                        return [4 /*yield*/, _build_view(cls(model), model, options)];
                    case 3:
                        view = _d.sent();
                        view_storage.set(model, view);
                        created_views.push(view);
                        _d.label = 4;
                    case 4:
                        new_models_1_1 = new_models_1.next();
                        return [3 /*break*/, 2];
                    case 5: return [3 /*break*/, 8];
                    case 6:
                        e_1_1 = _d.sent();
                        e_1 = { error: e_1_1 };
                        return [3 /*break*/, 8];
                    case 7:
                        try {
                            if (new_models_1_1 && !new_models_1_1.done && (_b = new_models_1.return))
                                _b.call(new_models_1);
                        }
                        finally {
                            if (e_1)
                                throw e_1.error;
                        }
                        return [7 /*endfinally*/];
                    case 8:
                        try {
                            for (created_views_1 = tslib_1.__values(created_views), created_views_1_1 = created_views_1.next(); !created_views_1_1.done; created_views_1_1 = created_views_1.next()) {
                                view = created_views_1_1.value;
                                view.connect_signals();
                            }
                        }
                        catch (e_3_1) {
                            e_3 = { error: e_3_1 };
                        }
                        finally {
                            try {
                                if (created_views_1_1 && !created_views_1_1.done && (_c = created_views_1.return))
                                    _c.call(created_views_1);
                            }
                            finally {
                                if (e_3)
                                    throw e_3.error;
                            }
                        }
                        return [2 /*return*/, created_views];
                }
            });
        });
    }
    exports.build_views = build_views;
    function remove_views(view_storage) {
        var e_4, _a;
        try {
            for (var view_storage_1 = tslib_1.__values(view_storage), view_storage_1_1 = view_storage_1.next(); !view_storage_1_1.done; view_storage_1_1 = view_storage_1.next()) {
                var _b = tslib_1.__read(view_storage_1_1.value, 2), model = _b[0], view = _b[1];
                view.remove();
                view_storage.delete(model);
            }
        }
        catch (e_4_1) {
            e_4 = { error: e_4_1 };
        }
        finally {
            try {
                if (view_storage_1_1 && !view_storage_1_1.done && (_a = view_storage_1.return))
                    _a.call(view_storage_1);
            }
            finally {
                if (e_4)
                    throw e_4.error;
            }
        }
    }
    exports.remove_views = remove_views;
},
/* models/renderers/graph_renderer.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var data_renderer_1 = require(177) /* ./data_renderer */;
    var glyph_renderer_1 = require(176) /* ./glyph_renderer */;
    var expression_1 = require(239) /* ../expressions/expression */;
    var layout_provider_1 = require(240) /* ../graphs/layout_provider */;
    var graph_hit_test_policy_1 = require(241) /* ../graphs/graph_hit_test_policy */;
    var build_views_1 = require(237) /* ../../core/build_views */;
    var xy_glyph_1 = require(179) /* ../glyphs/xy_glyph */;
    var multi_line_1 = require(242) /* ../glyphs/multi_line */;
    var patches_1 = require(243) /* ../glyphs/patches */;
    var assert_1 = require(126) /* ../../core/util/assert */;
    var GraphRendererView = /** @class */ (function (_super) {
        tslib_1.__extends(GraphRendererView, _super);
        function GraphRendererView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(GraphRendererView.prototype, "glyph_view", {
            get: function () {
                return this.node_view.glyph;
            },
            enumerable: false,
            configurable: true
        });
        GraphRendererView.prototype.lazy_initialize = function () {
            return tslib_1.__awaiter(this, void 0, void 0, function () {
                var graph, xs_ys, x_y, xs_expr, ys_expr, x_expr, y_expr, _a, edge_renderer, node_renderer, parent, _b, _c;
                return tslib_1.__generator(this, function (_d) {
                    switch (_d.label) {
                        case 0: return [4 /*yield*/, _super.prototype.lazy_initialize.call(this)];
                        case 1:
                            _d.sent();
                            graph = this.model;
                            xs_ys = null;
                            x_y = null;
                            xs_expr = new /** @class */ (function (_super) {
                                tslib_1.__extends(class_1, _super);
                                function class_1() {
                                    return _super !== null && _super.apply(this, arguments) || this;
                                }
                                class_1.prototype._v_compute = function (source) {
                                    assert_1.assert(xs_ys == null);
                                    var _a = tslib_1.__read(xs_ys = graph.layout_provider.get_edge_coordinates(source), 1), xs = _a[0];
                                    return xs;
                                };
                                return class_1;
                            }(expression_1.Expression));
                            ys_expr = new /** @class */ (function (_super) {
                                tslib_1.__extends(class_2, _super);
                                function class_2() {
                                    return _super !== null && _super.apply(this, arguments) || this;
                                }
                                class_2.prototype._v_compute = function (_source) {
                                    assert_1.assert(xs_ys != null);
                                    var _a = tslib_1.__read(xs_ys, 2), ys = _a[1];
                                    xs_ys = null;
                                    return ys;
                                };
                                return class_2;
                            }(expression_1.Expression));
                            x_expr = new /** @class */ (function (_super) {
                                tslib_1.__extends(class_3, _super);
                                function class_3() {
                                    return _super !== null && _super.apply(this, arguments) || this;
                                }
                                class_3.prototype._v_compute = function (source) {
                                    assert_1.assert(x_y == null);
                                    var _a = tslib_1.__read(x_y = graph.layout_provider.get_node_coordinates(source), 1), x = _a[0];
                                    return x;
                                };
                                return class_3;
                            }(expression_1.Expression));
                            y_expr = new /** @class */ (function (_super) {
                                tslib_1.__extends(class_4, _super);
                                function class_4() {
                                    return _super !== null && _super.apply(this, arguments) || this;
                                }
                                class_4.prototype._v_compute = function (_source) {
                                    assert_1.assert(x_y != null);
                                    var _a = tslib_1.__read(x_y, 2), y = _a[1];
                                    x_y = null;
                                    return y;
                                };
                                return class_4;
                            }(expression_1.Expression));
                            _a = this.model, edge_renderer = _a.edge_renderer, node_renderer = _a.node_renderer;
                            // TODO: XsYsGlyph or something
                            if (!(edge_renderer.glyph instanceof multi_line_1.MultiLine || edge_renderer.glyph instanceof patches_1.Patches)) {
                                throw new Error(this + ".edge_renderer.glyph must be a MultiLine glyph");
                            }
                            if (!(node_renderer.glyph instanceof xy_glyph_1.XYGlyph)) {
                                throw new Error(this + ".node_renderer.glyph must be a XYGlyph glyph");
                            }
                            edge_renderer.glyph.properties.xs.internal = true;
                            edge_renderer.glyph.properties.ys.internal = true;
                            node_renderer.glyph.properties.x.internal = true;
                            node_renderer.glyph.properties.y.internal = true;
                            edge_renderer.glyph.xs = { expr: xs_expr };
                            edge_renderer.glyph.ys = { expr: ys_expr };
                            node_renderer.glyph.x = { expr: x_expr };
                            node_renderer.glyph.y = { expr: y_expr };
                            parent = this.parent;
                            _b = this;
                            return [4 /*yield*/, build_views_1.build_view(edge_renderer, { parent: parent })];
                        case 2:
                            _b.edge_view = _d.sent();
                            _c = this;
                            return [4 /*yield*/, build_views_1.build_view(node_renderer, { parent: parent })];
                        case 3:
                            _c.node_view = _d.sent();
                            return [2 /*return*/];
                    }
                });
            });
        };
        GraphRendererView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.layout_provider.change, function () {
                _this.edge_view.set_data();
                _this.node_view.set_data();
                _this.request_render();
            });
        };
        GraphRendererView.prototype.remove = function () {
            this.edge_view.remove();
            this.node_view.remove();
            _super.prototype.remove.call(this);
        };
        GraphRendererView.prototype._render = function () {
            this.edge_view.render();
            this.node_view.render();
        };
        GraphRendererView.prototype.renderer_view = function (renderer) {
            if (renderer instanceof glyph_renderer_1.GlyphRenderer) {
                if (renderer == this.edge_view.model)
                    return this.edge_view;
                if (renderer == this.node_view.model)
                    return this.node_view;
            }
            return _super.prototype.renderer_view.call(this, renderer);
        };
        return GraphRendererView;
    }(data_renderer_1.DataRendererView));
    exports.GraphRendererView = GraphRendererView;
    GraphRendererView.__name__ = "GraphRendererView";
    var GraphRenderer = /** @class */ (function (_super) {
        tslib_1.__extends(GraphRenderer, _super);
        function GraphRenderer(attrs) {
            return _super.call(this, attrs) || this;
        }
        GraphRenderer.init_GraphRenderer = function () {
            this.prototype.default_view = GraphRendererView;
            this.define(function (_a) {
                var Ref = _a.Ref;
                return ({
                    layout_provider: [Ref(layout_provider_1.LayoutProvider)],
                    node_renderer: [Ref(glyph_renderer_1.GlyphRenderer)],
                    edge_renderer: [Ref(glyph_renderer_1.GlyphRenderer)],
                    selection_policy: [Ref(graph_hit_test_policy_1.GraphHitTestPolicy), function () { return new graph_hit_test_policy_1.NodesOnly(); }],
                    inspection_policy: [Ref(graph_hit_test_policy_1.GraphHitTestPolicy), function () { return new graph_hit_test_policy_1.NodesOnly(); }],
                });
            });
        };
        GraphRenderer.prototype.get_selection_manager = function () {
            return this.node_renderer.data_source.selection_manager;
        };
        return GraphRenderer;
    }(data_renderer_1.DataRenderer));
    exports.GraphRenderer = GraphRenderer;
    GraphRenderer.__name__ = "GraphRenderer";
    GraphRenderer.init_GraphRenderer();
},
/* models/expressions/expression.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var model_1 = require(168) /* ../../model */;
    var Expression = /** @class */ (function (_super) {
        tslib_1.__extends(Expression, _super);
        function Expression(attrs) {
            return _super.call(this, attrs) || this;
        }
        Expression.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._connected = new Set();
            this._result = new Map();
        };
        Expression.prototype.v_compute = function (source) {
            var _this = this;
            if (!this._connected.has(source)) {
                this.connect(source.change, function () { return _this._result.delete(source); });
                this.connect(source.patching, function () { return _this._result.delete(source); });
                this.connect(source.streaming, function () { return _this._result.delete(source); });
                this._connected.add(source);
            }
            var result = this._result.get(source);
            if (result == null) {
                result = this._v_compute(source);
                this._result.set(source, result);
            }
            return result;
        };
        return Expression;
    }(model_1.Model));
    exports.Expression = Expression;
    Expression.__name__ = "Expression";
    var ScalarExpression = /** @class */ (function (_super) {
        tslib_1.__extends(ScalarExpression, _super);
        function ScalarExpression(attrs) {
            return _super.call(this, attrs) || this;
        }
        ScalarExpression.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._connected = new Set();
            this._result = new Map();
        };
        ScalarExpression.prototype.compute = function (source) {
            var _this = this;
            if (!this._connected.has(source)) {
                this.connect(source.change, function () { return _this._result.delete(source); });
                this.connect(source.patching, function () { return _this._result.delete(source); });
                this.connect(source.streaming, function () { return _this._result.delete(source); });
                this._connected.add(source);
            }
            var result = this._result.get(source);
            if (result == null) {
                result = this._compute(source);
                this._result.set(source, result);
            }
            return result;
        };
        return ScalarExpression;
    }(model_1.Model));
    exports.ScalarExpression = ScalarExpression;
    ScalarExpression.__name__ = "ScalarExpression";
},
/* models/graphs/layout_provider.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var model_1 = require(168) /* ../../model */;
    var LayoutProvider = /** @class */ (function (_super) {
        tslib_1.__extends(LayoutProvider, _super);
        function LayoutProvider(attrs) {
            return _super.call(this, attrs) || this;
        }
        return LayoutProvider;
    }(model_1.Model));
    exports.LayoutProvider = LayoutProvider;
    LayoutProvider.__name__ = "LayoutProvider";
},
/* models/graphs/graph_hit_test_policy.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var model_1 = require(168) /* ../../model */;
    var arrayable_1 = require(127) /* ../../core/util/arrayable */;
    var array_1 = require(124) /* ../../core/util/array */;
    var selection_1 = require(174) /* ../selections/selection */;
    var GraphHitTestPolicy = /** @class */ (function (_super) {
        tslib_1.__extends(GraphHitTestPolicy, _super);
        function GraphHitTestPolicy(attrs) {
            return _super.call(this, attrs) || this;
        }
        GraphHitTestPolicy.prototype._hit_test = function (geometry, graph_view, renderer_view) {
            if (!graph_view.model.visible)
                return null;
            var hit_test_result = renderer_view.glyph.hit_test(geometry);
            if (hit_test_result == null)
                return null;
            else
                return renderer_view.model.view.convert_selection_from_subset(hit_test_result);
        };
        return GraphHitTestPolicy;
    }(model_1.Model));
    exports.GraphHitTestPolicy = GraphHitTestPolicy;
    GraphHitTestPolicy.__name__ = "GraphHitTestPolicy";
    var EdgesOnly = /** @class */ (function (_super) {
        tslib_1.__extends(EdgesOnly, _super);
        function EdgesOnly(attrs) {
            return _super.call(this, attrs) || this;
        }
        EdgesOnly.prototype.hit_test = function (geometry, graph_view) {
            return this._hit_test(geometry, graph_view, graph_view.edge_view);
        };
        EdgesOnly.prototype.do_selection = function (hit_test_result, graph, final, mode) {
            if (hit_test_result == null)
                return false;
            var edge_selection = graph.edge_renderer.data_source.selected;
            edge_selection.update(hit_test_result, final, mode);
            graph.edge_renderer.data_source._select.emit();
            return !edge_selection.is_empty();
        };
        EdgesOnly.prototype.do_inspection = function (hit_test_result, geometry, graph_view, final, mode) {
            if (hit_test_result == null)
                return false;
            var edge_renderer = graph_view.model.edge_renderer;
            var edge_inspection = edge_renderer.get_selection_manager().get_or_create_inspector(graph_view.edge_view.model);
            edge_inspection.update(hit_test_result, final, mode);
            // silently set inspected attr to avoid triggering data_source.change event and rerender
            graph_view.edge_view.model.data_source.setv({ inspected: edge_inspection }, { silent: true });
            graph_view.edge_view.model.data_source.inspect.emit([graph_view.edge_view.model, { geometry: geometry }]);
            return !edge_inspection.is_empty();
        };
        return EdgesOnly;
    }(GraphHitTestPolicy));
    exports.EdgesOnly = EdgesOnly;
    EdgesOnly.__name__ = "EdgesOnly";
    var NodesOnly = /** @class */ (function (_super) {
        tslib_1.__extends(NodesOnly, _super);
        function NodesOnly(attrs) {
            return _super.call(this, attrs) || this;
        }
        NodesOnly.prototype.hit_test = function (geometry, graph_view) {
            return this._hit_test(geometry, graph_view, graph_view.node_view);
        };
        NodesOnly.prototype.do_selection = function (hit_test_result, graph, final, mode) {
            if (hit_test_result == null)
                return false;
            var node_selection = graph.node_renderer.data_source.selected;
            node_selection.update(hit_test_result, final, mode);
            graph.node_renderer.data_source._select.emit();
            return !node_selection.is_empty();
        };
        NodesOnly.prototype.do_inspection = function (hit_test_result, geometry, graph_view, final, mode) {
            if (hit_test_result == null)
                return false;
            var node_renderer = graph_view.model.node_renderer;
            var node_inspection = node_renderer.get_selection_manager().get_or_create_inspector(graph_view.node_view.model);
            node_inspection.update(hit_test_result, final, mode);
            // silently set inspected attr to avoid triggering data_source.change event and rerender
            graph_view.node_view.model.data_source.setv({ inspected: node_inspection }, { silent: true });
            graph_view.node_view.model.data_source.inspect.emit([graph_view.node_view.model, { geometry: geometry }]);
            return !node_inspection.is_empty();
        };
        return NodesOnly;
    }(GraphHitTestPolicy));
    exports.NodesOnly = NodesOnly;
    NodesOnly.__name__ = "NodesOnly";
    var NodesAndLinkedEdges = /** @class */ (function (_super) {
        tslib_1.__extends(NodesAndLinkedEdges, _super);
        function NodesAndLinkedEdges(attrs) {
            return _super.call(this, attrs) || this;
        }
        NodesAndLinkedEdges.prototype.hit_test = function (geometry, graph_view) {
            return this._hit_test(geometry, graph_view, graph_view.node_view);
        };
        NodesAndLinkedEdges.prototype.get_linked_edges = function (node_source, edge_source, mode) {
            var e_1, _a;
            var node_indices = [];
            if (mode == 'selection') {
                node_indices = node_source.selected.indices.map(function (i) { return node_source.data.index[i]; });
            }
            else if (mode == 'inspection') {
                node_indices = node_source.inspected.indices.map(function (i) { return node_source.data.index[i]; });
            }
            var edge_indices = [];
            for (var i = 0; i < edge_source.data.start.length; i++) {
                if (array_1.contains(node_indices, edge_source.data.start[i]) || array_1.contains(node_indices, edge_source.data.end[i]))
                    edge_indices.push(i);
            }
            var linked_edges = new selection_1.Selection();
            try {
                for (var edge_indices_1 = tslib_1.__values(edge_indices), edge_indices_1_1 = edge_indices_1.next(); !edge_indices_1_1.done; edge_indices_1_1 = edge_indices_1.next()) {
                    var i = edge_indices_1_1.value;
                    linked_edges.multiline_indices[i] = [0]; //currently only supports 2-element multilines, so this is all of it
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (edge_indices_1_1 && !edge_indices_1_1.done && (_a = edge_indices_1.return))
                        _a.call(edge_indices_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            linked_edges.indices = edge_indices;
            return linked_edges;
        };
        NodesAndLinkedEdges.prototype.do_selection = function (hit_test_result, graph, final, mode) {
            if (hit_test_result == null)
                return false;
            var node_selection = graph.node_renderer.data_source.selected;
            node_selection.update(hit_test_result, final, mode);
            var edge_selection = graph.edge_renderer.data_source.selected;
            var linked_edges_selection = this.get_linked_edges(graph.node_renderer.data_source, graph.edge_renderer.data_source, 'selection');
            edge_selection.update(linked_edges_selection, final, mode);
            graph.node_renderer.data_source._select.emit();
            return !node_selection.is_empty();
        };
        NodesAndLinkedEdges.prototype.do_inspection = function (hit_test_result, geometry, graph_view, final, mode) {
            if (hit_test_result == null)
                return false;
            var node_inspection = graph_view.node_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.node_view.model);
            node_inspection.update(hit_test_result, final, mode);
            graph_view.node_view.model.data_source.setv({ inspected: node_inspection }, { silent: true });
            var edge_inspection = graph_view.edge_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.edge_view.model);
            var linked_edges = this.get_linked_edges(graph_view.node_view.model.data_source, graph_view.edge_view.model.data_source, 'inspection');
            edge_inspection.update(linked_edges, final, mode);
            //silently set inspected attr to avoid triggering data_source.change event and rerender
            graph_view.edge_view.model.data_source.setv({ inspected: edge_inspection }, { silent: true });
            graph_view.node_view.model.data_source.inspect.emit([graph_view.node_view.model, { geometry: geometry }]);
            return !node_inspection.is_empty();
        };
        return NodesAndLinkedEdges;
    }(GraphHitTestPolicy));
    exports.NodesAndLinkedEdges = NodesAndLinkedEdges;
    NodesAndLinkedEdges.__name__ = "NodesAndLinkedEdges";
    var EdgesAndLinkedNodes = /** @class */ (function (_super) {
        tslib_1.__extends(EdgesAndLinkedNodes, _super);
        function EdgesAndLinkedNodes(attrs) {
            return _super.call(this, attrs) || this;
        }
        EdgesAndLinkedNodes.prototype.hit_test = function (geometry, graph_view) {
            return this._hit_test(geometry, graph_view, graph_view.edge_view);
        };
        EdgesAndLinkedNodes.prototype.get_linked_nodes = function (node_source, edge_source, mode) {
            var e_2, _a;
            var edge_indices = [];
            if (mode == 'selection')
                edge_indices = edge_source.selected.indices;
            else if (mode == 'inspection')
                edge_indices = edge_source.inspected.indices;
            var nodes = [];
            try {
                for (var edge_indices_2 = tslib_1.__values(edge_indices), edge_indices_2_1 = edge_indices_2.next(); !edge_indices_2_1.done; edge_indices_2_1 = edge_indices_2.next()) {
                    var i = edge_indices_2_1.value;
                    nodes.push(edge_source.data.start[i]);
                    nodes.push(edge_source.data.end[i]);
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (edge_indices_2_1 && !edge_indices_2_1.done && (_a = edge_indices_2.return))
                        _a.call(edge_indices_2);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            var node_indices = array_1.uniq(nodes).map(function (i) { return arrayable_1.indexOf(node_source.data.index, i); });
            return new selection_1.Selection({ indices: node_indices });
        };
        EdgesAndLinkedNodes.prototype.do_selection = function (hit_test_result, graph, final, mode) {
            if (hit_test_result == null)
                return false;
            var edge_selection = graph.edge_renderer.data_source.selected;
            edge_selection.update(hit_test_result, final, mode);
            var node_selection = graph.node_renderer.data_source.selected;
            var linked_nodes = this.get_linked_nodes(graph.node_renderer.data_source, graph.edge_renderer.data_source, 'selection');
            node_selection.update(linked_nodes, final, mode);
            graph.edge_renderer.data_source._select.emit();
            return !edge_selection.is_empty();
        };
        EdgesAndLinkedNodes.prototype.do_inspection = function (hit_test_result, geometry, graph_view, final, mode) {
            if (hit_test_result == null)
                return false;
            var edge_inspection = graph_view.edge_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.edge_view.model);
            edge_inspection.update(hit_test_result, final, mode);
            graph_view.edge_view.model.data_source.setv({ inspected: edge_inspection }, { silent: true });
            var node_inspection = graph_view.node_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.node_view.model);
            var linked_nodes = this.get_linked_nodes(graph_view.node_view.model.data_source, graph_view.edge_view.model.data_source, 'inspection');
            node_inspection.update(linked_nodes, final, mode);
            // silently set inspected attr to avoid triggering data_source.change event and rerender
            graph_view.node_view.model.data_source.setv({ inspected: node_inspection }, { silent: true });
            graph_view.edge_view.model.data_source.inspect.emit([graph_view.edge_view.model, { geometry: geometry }]);
            return !edge_inspection.is_empty();
        };
        return EdgesAndLinkedNodes;
    }(GraphHitTestPolicy));
    exports.EdgesAndLinkedNodes = EdgesAndLinkedNodes;
    EdgesAndLinkedNodes.__name__ = "EdgesAndLinkedNodes";
},
/* models/glyphs/multi_line.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var projections_1 = require(180) /* ../../core/util/projections */;
    var property_mixins_1 = require(163) /* ../../core/property_mixins */;
    var hittest = tslib_1.__importStar(require(222) /* ../../core/hittest */);
    var p = tslib_1.__importStar(require(133) /* ../../core/properties */);
    var arrayable_1 = require(127) /* ../../core/util/arrayable */;
    var object_1 = require(128) /* ../../core/util/object */;
    var glyph_1 = require(213) /* ./glyph */;
    var utils_1 = require(221) /* ./utils */;
    var selection_1 = require(174) /* ../selections/selection */;
    var MultiLineView = /** @class */ (function (_super) {
        tslib_1.__extends(MultiLineView, _super);
        function MultiLineView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        MultiLineView.prototype._project_data = function () {
            projections_1.inplace.project_xy(this._xs.array, this._ys.array);
        };
        MultiLineView.prototype._index_data = function (index) {
            var data_size = this.data_size;
            for (var i = 0; i < data_size; i++) {
                var xsi = this._xs.get(i);
                if (xsi.length == 0) {
                    index.add_empty();
                    continue;
                }
                var ysi = this._ys.get(i);
                if (ysi.length == 0) {
                    index.add_empty();
                    continue;
                }
                var _a = tslib_1.__read(arrayable_1.minmax(xsi), 2), x0 = _a[0], x1 = _a[1];
                var _b = tslib_1.__read(arrayable_1.minmax(ysi), 2), y0 = _b[0], y1 = _b[1];
                index.add(x0, y0, x1, y1);
            }
        };
        MultiLineView.prototype._render = function (ctx, indices, data) {
            var e_1, _a;
            var _b = data !== null && data !== void 0 ? data : this, sxs = _b.sxs, sys = _b.sys;
            try {
                for (var indices_1 = tslib_1.__values(indices), indices_1_1 = indices_1.next(); !indices_1_1.done; indices_1_1 = indices_1.next()) {
                    var i = indices_1_1.value;
                    var sx = sxs.get(i);
                    var sy = sys.get(i);
                    var n = Math.min(sx.length, sy.length);
                    var move = true;
                    ctx.beginPath();
                    for (var j = 0; j < n; j++) {
                        var sx_j = sx[j];
                        var sy_j = sy[j];
                        if (!isFinite(sx_j + sy_j))
                            move = true;
                        else {
                            if (move) {
                                ctx.moveTo(sx_j, sy_j);
                                move = false;
                            }
                            else
                                ctx.lineTo(sx_j, sy_j);
                        }
                    }
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (indices_1_1 && !indices_1_1.done && (_a = indices_1.return))
                        _a.call(indices_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        MultiLineView.prototype._hit_point = function (geometry) {
            var point = { x: geometry.sx, y: geometry.sy };
            var shortest = 9999;
            var hits = new Map();
            for (var i = 0, end = this.sxs.length; i < end; i++) {
                var threshold = Math.max(2, this.line_width.get(i) / 2);
                var sxsi = this.sxs.get(i);
                var sysi = this.sys.get(i);
                var points = null;
                for (var j = 0, endj = sxsi.length - 1; j < endj; j++) {
                    var p0 = { x: sxsi[j], y: sysi[j] };
                    var p1 = { x: sxsi[j + 1], y: sysi[j + 1] };
                    var dist = hittest.dist_to_segment(point, p0, p1);
                    if (dist < threshold && dist < shortest) {
                        shortest = dist;
                        points = [j];
                    }
                }
                if (points != null) {
                    hits.set(i, points);
                }
            }
            return new selection_1.Selection({
                indices: tslib_1.__spread(hits.keys()),
                multiline_indices: object_1.to_object(hits),
            });
        };
        MultiLineView.prototype._hit_span = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            var val;
            var vs;
            if (geometry.direction == 'v') {
                val = this.renderer.yscale.invert(sy);
                vs = this._ys;
            }
            else {
                val = this.renderer.xscale.invert(sx);
                vs = this._xs;
            }
            var hits = new Map();
            for (var i = 0, end = vs.length; i < end; i++) {
                var vsi = vs.get(i);
                var points = [];
                for (var j = 0, endj = vsi.length - 1; j < endj; j++) {
                    if (vsi[j] <= val && val <= vsi[j + 1])
                        points.push(j);
                }
                if (points.length > 0) {
                    hits.set(i, points);
                }
            }
            return new selection_1.Selection({
                indices: tslib_1.__spread(hits.keys()),
                multiline_indices: object_1.to_object(hits),
            });
        };
        MultiLineView.prototype.get_interpolation_hit = function (i, point_i, geometry) {
            var xsi = this._xs.get(i);
            var ysi = this._ys.get(i);
            var x2 = xsi[point_i];
            var y2 = ysi[point_i];
            var x3 = xsi[point_i + 1];
            var y3 = ysi[point_i + 1];
            return utils_1.line_interpolation(this.renderer, geometry, x2, y2, x3, y3);
        };
        MultiLineView.prototype.draw_legend_for_index = function (ctx, bbox, index) {
            utils_1.generic_line_vector_legend(this.visuals, ctx, bbox, index);
        };
        MultiLineView.prototype.scenterxy = function () {
            throw new Error(this + ".scenterxy() is not implemented");
        };
        return MultiLineView;
    }(glyph_1.GlyphView));
    exports.MultiLineView = MultiLineView;
    MultiLineView.__name__ = "MultiLineView";
    var MultiLine = /** @class */ (function (_super) {
        tslib_1.__extends(MultiLine, _super);
        function MultiLine(attrs) {
            return _super.call(this, attrs) || this;
        }
        MultiLine.init_MultiLine = function () {
            this.prototype.default_view = MultiLineView;
            this.define(function (_a) {
                return ({
                    xs: [p.XCoordinateSeqSpec, { field: "xs" }],
                    ys: [p.YCoordinateSeqSpec, { field: "ys" }],
                });
            });
            this.mixins(property_mixins_1.LineVector);
        };
        return MultiLine;
    }(glyph_1.Glyph));
    exports.MultiLine = MultiLine;
    MultiLine.__name__ = "MultiLine";
    MultiLine.init_MultiLine();
},
/* models/glyphs/patches.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var glyph_1 = require(213) /* ./glyph */;
    var utils_1 = require(221) /* ./utils */;
    var arrayable_1 = require(127) /* ../../core/util/arrayable */;
    var property_mixins_1 = require(163) /* ../../core/property_mixins */;
    var hittest = tslib_1.__importStar(require(222) /* ../../core/hittest */);
    var p = tslib_1.__importStar(require(133) /* ../../core/properties */);
    var selection_1 = require(174) /* ../selections/selection */;
    var assert_1 = require(126) /* ../../core/util/assert */;
    var projections_1 = require(180) /* ../../core/util/projections */;
    var PatchesView = /** @class */ (function (_super) {
        tslib_1.__extends(PatchesView, _super);
        function PatchesView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        PatchesView.prototype._project_data = function () {
            projections_1.inplace.project_xy(this._xs.array, this._ys.array);
        };
        PatchesView.prototype._index_data = function (index) {
            var data_size = this.data_size;
            for (var i = 0; i < data_size; i++) {
                var xsi = this._xs.get(i);
                var ysi = this._ys.get(i);
                if (xsi.length == 0)
                    index.add_empty();
                else {
                    var _a = tslib_1.__read(arrayable_1.minmax(xsi), 2), x0 = _a[0], x1 = _a[1];
                    var _b = tslib_1.__read(arrayable_1.minmax(ysi), 2), y0 = _b[0], y1 = _b[1];
                    index.add(x0, y0, x1, y1);
                }
            }
        };
        PatchesView.prototype._mask_data = function () {
            var _a = this.renderer.plot_view.frame, x_range = _a.x_range, y_range = _a.y_range;
            return this.index.indices({
                x0: x_range.min, x1: x_range.max,
                y0: y_range.min, y1: y_range.max,
            });
        };
        PatchesView.prototype._inner_loop = function (ctx, sx, sy, func) {
            for (var j = 0, end = sx.length; j < end; j++) {
                if (j == 0) {
                    ctx.beginPath();
                    ctx.moveTo(sx[j], sy[j]);
                    continue;
                }
                else if (isNaN(sx[j] + sy[j])) {
                    ctx.closePath();
                    func.apply(ctx);
                    ctx.beginPath();
                    continue;
                }
                else
                    ctx.lineTo(sx[j], sy[j]);
            }
            ctx.closePath();
            func.call(ctx);
        };
        PatchesView.prototype._render = function (ctx, indices, data) {
            var e_1, _a;
            var _b = data !== null && data !== void 0 ? data : this, sxs = _b.sxs, sys = _b.sys;
            try {
                for (var indices_1 = tslib_1.__values(indices), indices_1_1 = indices_1.next(); !indices_1_1.done; indices_1_1 = indices_1.next()) {
                    var i = indices_1_1.value;
                    var sx_i = sxs.get(i);
                    var sy_i = sys.get(i);
                    if (this.visuals.fill.doit) {
                        this.visuals.fill.set_vectorize(ctx, i);
                        this._inner_loop(ctx, sx_i, sy_i, ctx.fill);
                    }
                    if (this.visuals.hatch.doit) {
                        this.visuals.hatch.set_vectorize(ctx, i);
                        this._inner_loop(ctx, sx_i, sy_i, ctx.fill);
                    }
                    if (this.visuals.line.doit) {
                        this.visuals.line.set_vectorize(ctx, i);
                        this._inner_loop(ctx, sx_i, sy_i, ctx.stroke);
                    }
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (indices_1_1 && !indices_1_1.done && (_a = indices_1.return))
                        _a.call(indices_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        PatchesView.prototype._hit_rect = function (geometry) {
            var e_2, _a;
            var sx0 = geometry.sx0, sx1 = geometry.sx1, sy0 = geometry.sy0, sy1 = geometry.sy1;
            var xs = [sx0, sx1, sx1, sx0];
            var ys = [sy0, sy0, sy1, sy1];
            var _b = tslib_1.__read(this.renderer.xscale.r_invert(sx0, sx1), 2), x0 = _b[0], x1 = _b[1];
            var _c = tslib_1.__read(this.renderer.yscale.r_invert(sy0, sy1), 2), y0 = _c[0], y1 = _c[1];
            var candidates = this.index.indices({ x0: x0, x1: x1, y0: y0, y1: y1 });
            var indices = [];
            try {
                for (var candidates_1 = tslib_1.__values(candidates), candidates_1_1 = candidates_1.next(); !candidates_1_1.done; candidates_1_1 = candidates_1.next()) {
                    var index = candidates_1_1.value;
                    var sxss = this.sxs.get(index);
                    var syss = this.sys.get(index);
                    var hit = true;
                    for (var j = 0, endj = sxss.length; j < endj; j++) {
                        var sx = sxss[j];
                        var sy = syss[j];
                        if (!hittest.point_in_poly(sx, sy, xs, ys)) {
                            hit = false;
                            break;
                        }
                    }
                    if (hit) {
                        indices.push(index);
                    }
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (candidates_1_1 && !candidates_1_1.done && (_a = candidates_1.return))
                        _a.call(candidates_1);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            return new selection_1.Selection({ indices: indices });
        };
        PatchesView.prototype._hit_point = function (geometry) {
            var e_3, _a;
            var sx = geometry.sx, sy = geometry.sy;
            var x = this.renderer.xscale.invert(sx);
            var y = this.renderer.yscale.invert(sy);
            var candidates = this.index.indices({ x0: x, y0: y, x1: x, y1: y });
            var indices = [];
            try {
                for (var candidates_2 = tslib_1.__values(candidates), candidates_2_1 = candidates_2.next(); !candidates_2_1.done; candidates_2_1 = candidates_2.next()) {
                    var index = candidates_2_1.value;
                    var sxsi = this.sxs.get(index);
                    var sysi = this.sys.get(index);
                    var n = sxsi.length;
                    for (var k = 0, j = 0;; j++) {
                        if (isNaN(sxsi[j]) || j == n) {
                            var sxsi_kj = sxsi.subarray(k, j);
                            var sysi_kj = sysi.subarray(k, j);
                            if (hittest.point_in_poly(sx, sy, sxsi_kj, sysi_kj)) {
                                indices.push(index);
                                break;
                            }
                            k = j + 1;
                        }
                        if (j == n)
                            break;
                    }
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (candidates_2_1 && !candidates_2_1.done && (_a = candidates_2.return))
                        _a.call(candidates_2);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            return new selection_1.Selection({ indices: indices });
        };
        PatchesView.prototype._get_snap_coord = function (array) {
            return arrayable_1.sum(array) / array.length;
        };
        PatchesView.prototype.scenterxy = function (i, sx, sy) {
            var sxsi = this.sxs.get(i);
            var sysi = this.sys.get(i);
            var n = sxsi.length;
            var has_nan = false;
            for (var k = 0, j = 0;; j++) {
                var this_nan = isNaN(sxsi[j]);
                has_nan = has_nan || this_nan;
                if (j == n && !has_nan) {
                    var scx = this._get_snap_coord(sxsi);
                    var scy = this._get_snap_coord(sysi);
                    return [scx, scy];
                }
                if (this_nan || j == n) {
                    var sxsi_kj = sxsi.subarray(k, j);
                    var sysi_kj = sysi.subarray(k, j);
                    if (hittest.point_in_poly(sx, sy, sxsi_kj, sysi_kj)) {
                        var scx = this._get_snap_coord(sxsi_kj);
                        var scy = this._get_snap_coord(sysi_kj);
                        return [scx, scy];
                    }
                    k = j + 1;
                }
                if (j == n)
                    break;
            }
            assert_1.unreachable();
        };
        PatchesView.prototype.draw_legend_for_index = function (ctx, bbox, index) {
            utils_1.generic_area_vector_legend(this.visuals, ctx, bbox, index);
        };
        return PatchesView;
    }(glyph_1.GlyphView));
    exports.PatchesView = PatchesView;
    PatchesView.__name__ = "PatchesView";
    var Patches = /** @class */ (function (_super) {
        tslib_1.__extends(Patches, _super);
        function Patches(attrs) {
            return _super.call(this, attrs) || this;
        }
        Patches.init_Patches = function () {
            this.prototype.default_view = PatchesView;
            this.define(function (_a) {
                return ({
                    xs: [p.XCoordinateSeqSpec, { field: "xs" }],
                    ys: [p.YCoordinateSeqSpec, { field: "ys" }],
                });
            });
            this.mixins([property_mixins_1.LineVector, property_mixins_1.FillVector, property_mixins_1.HatchVector]);
        };
        return Patches;
    }(glyph_1.Glyph));
    exports.Patches = Patches;
    Patches.__name__ = "Patches";
    Patches.init_Patches();
},
/* models/selections/interaction_policy.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var model_1 = require(168) /* ../../model */;
    var SelectionPolicy = /** @class */ (function (_super) {
        tslib_1.__extends(SelectionPolicy, _super);
        function SelectionPolicy() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SelectionPolicy.prototype.do_selection = function (hit_test_result, source, final, mode) {
            if (hit_test_result == null) {
                return false;
            }
            else {
                source.selected.update(hit_test_result, final, mode);
                source._select.emit();
                return !source.selected.is_empty();
            }
        };
        return SelectionPolicy;
    }(model_1.Model));
    exports.SelectionPolicy = SelectionPolicy;
    SelectionPolicy.__name__ = "SelectionPolicy";
    var IntersectRenderers = /** @class */ (function (_super) {
        tslib_1.__extends(IntersectRenderers, _super);
        function IntersectRenderers() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        IntersectRenderers.prototype.hit_test = function (geometry, renderer_views) {
            var e_1, _a, e_2, _b;
            var hit_test_result_renderers = [];
            try {
                for (var renderer_views_1 = tslib_1.__values(renderer_views), renderer_views_1_1 = renderer_views_1.next(); !renderer_views_1_1.done; renderer_views_1_1 = renderer_views_1.next()) {
                    var r = renderer_views_1_1.value;
                    var result = r.hit_test(geometry);
                    if (result != null)
                        hit_test_result_renderers.push(result);
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (renderer_views_1_1 && !renderer_views_1_1.done && (_a = renderer_views_1.return))
                        _a.call(renderer_views_1);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
            if (hit_test_result_renderers.length > 0) {
                var hit_test_result = hit_test_result_renderers[0];
                try {
                    for (var hit_test_result_renderers_1 = tslib_1.__values(hit_test_result_renderers), hit_test_result_renderers_1_1 = hit_test_result_renderers_1.next(); !hit_test_result_renderers_1_1.done; hit_test_result_renderers_1_1 = hit_test_result_renderers_1.next()) {
                        var hit_test_result_other = hit_test_result_renderers_1_1.value;
                        hit_test_result.update_through_intersection(hit_test_result_other);
                    }
                }
                catch (e_2_1) {
                    e_2 = { error: e_2_1 };
                }
                finally {
                    try {
                        if (hit_test_result_renderers_1_1 && !hit_test_result_renderers_1_1.done && (_b = hit_test_result_renderers_1.return))
                            _b.call(hit_test_result_renderers_1);
                    }
                    finally {
                        if (e_2)
                            throw e_2.error;
                    }
                }
                return hit_test_result;
            }
            else {
                return null;
            }
        };
        return IntersectRenderers;
    }(SelectionPolicy));
    exports.IntersectRenderers = IntersectRenderers;
    IntersectRenderers.__name__ = "IntersectRenderers";
    var UnionRenderers = /** @class */ (function (_super) {
        tslib_1.__extends(UnionRenderers, _super);
        function UnionRenderers() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        UnionRenderers.prototype.hit_test = function (geometry, renderer_views) {
            var e_3, _a, e_4, _b;
            var hit_test_result_renderers = [];
            try {
                for (var renderer_views_2 = tslib_1.__values(renderer_views), renderer_views_2_1 = renderer_views_2.next(); !renderer_views_2_1.done; renderer_views_2_1 = renderer_views_2.next()) {
                    var r = renderer_views_2_1.value;
                    var result = r.hit_test(geometry);
                    if (result != null)
                        hit_test_result_renderers.push(result);
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (renderer_views_2_1 && !renderer_views_2_1.done && (_a = renderer_views_2.return))
                        _a.call(renderer_views_2);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            if (hit_test_result_renderers.length > 0) {
                var hit_test_result = hit_test_result_renderers[0];
                try {
                    for (var hit_test_result_renderers_2 = tslib_1.__values(hit_test_result_renderers), hit_test_result_renderers_2_1 = hit_test_result_renderers_2.next(); !hit_test_result_renderers_2_1.done; hit_test_result_renderers_2_1 = hit_test_result_renderers_2.next()) {
                        var hit_test_result_other = hit_test_result_renderers_2_1.value;
                        hit_test_result.update_through_union(hit_test_result_other);
                    }
                }
                catch (e_4_1) {
                    e_4 = { error: e_4_1 };
                }
                finally {
                    try {
                        if (hit_test_result_renderers_2_1 && !hit_test_result_renderers_2_1.done && (_b = hit_test_result_renderers_2.return))
                            _b.call(hit_test_result_renderers_2);
                    }
                    finally {
                        if (e_4)
                            throw e_4.error;
                    }
                }
                return hit_test_result;
            }
            else {
                return null;
            }
        };
        return UnionRenderers;
    }(SelectionPolicy));
    exports.UnionRenderers = UnionRenderers;
    UnionRenderers.__name__ = "UnionRenderers";
},
/* models/sources/column_data_source.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var columnar_data_source_1 = require(172) /* ./columnar_data_source */;
    var types_1 = require(123) /* ../../core/util/types */;
    var object_1 = require(128) /* ../../core/util/object */;
    var typed_array = tslib_1.__importStar(require(246) /* ../../core/util/typed_array */);
    var set_1 = require(247) /* ../../core/util/set */;
    var events_1 = require(150) /* ../../document/events */;
    //exported for testing
    function stream_to_column(col, new_col, rollover) {
        if (types_1.isArray(col)) {
            var result = col.concat(new_col);
            if (rollover != null && result.length > rollover)
                return result.slice(-rollover);
            else
                return result;
        }
        else if (types_1.isTypedArray(col)) {
            var total_len = col.length + new_col.length;
            // handle rollover case for typed arrays
            if (rollover != null && total_len > rollover) {
                var start = total_len - rollover;
                var end = col.length;
                // resize col if it is shorter than the rollover length
                var result = void 0;
                if (col.length < rollover) {
                    result = new col.constructor(rollover);
                    result.set(col, 0);
                }
                else
                    result = col;
                // shift values in original col to accommodate new_col
                for (var i = start, endi = end; i < endi; i++) {
                    result[i - start] = result[i];
                }
                // update end values in col with new_col
                for (var i = 0, endi = new_col.length; i < endi; i++) {
                    result[i + (end - start)] = new_col[i];
                }
                return result;
            }
            else {
                var tmp = new col.constructor(new_col);
                return typed_array.concat(col, tmp);
            }
        }
        else
            throw new Error("unsupported array types");
    }
    exports.stream_to_column = stream_to_column;
    // exported for testing
    function slice(ind, length) {
        var start, step, stop;
        if (types_1.isNumber(ind)) {
            start = ind;
            stop = ind + 1;
            step = 1;
        }
        else {
            start = ind.start != null ? ind.start : 0;
            stop = ind.stop != null ? ind.stop : length;
            step = ind.step != null ? ind.step : 1;
        }
        return [start, stop, step];
    }
    exports.slice = slice;
    // exported for testing
    function patch_to_column(col, patch) {
        var e_1, _a;
        var patched = new Set();
        var patched_range = false;
        try {
            for (var patch_1 = tslib_1.__values(patch), patch_1_1 = patch_1.next(); !patch_1_1.done; patch_1_1 = patch_1.next()) {
                var _b = tslib_1.__read(patch_1_1.value, 2), ind = _b[0], val = _b[1];
                // make the single index case look like the length-3 multi-index case
                var shape = void 0;
                var item = void 0;
                var index = void 0;
                var value = void 0;
                if (types_1.isArray(ind)) {
                    var _c = tslib_1.__read(ind, 1), i = _c[0];
                    patched.add(i);
                    shape = col[i].shape;
                    item = col[i];
                    value = val;
                    // this is basically like NumPy's "newaxis", inserting an empty dimension
                    // makes length 2 and 3 multi-index cases uniform, so that the same code
                    // can handle both
                    if (ind.length === 2) {
                        shape = [1, shape[0]];
                        index = [ind[0], 0, ind[1]];
                    }
                    else
                        index = ind;
                }
                else {
                    if (types_1.isNumber(ind)) {
                        value = [val];
                        patched.add(ind);
                    }
                    else {
                        value = val;
                        patched_range = true;
                    }
                    index = [0, 0, ind];
                    shape = [1, col.length];
                    item = col;
                }
                // now this one nested loop handles all cases
                var flat_index = 0;
                var _d = tslib_1.__read(slice(index[1], shape[0]), 3), istart = _d[0], istop = _d[1], istep = _d[2];
                var _e = tslib_1.__read(slice(index[2], shape[1]), 3), jstart = _e[0], jstop = _e[1], jstep = _e[2];
                for (var i = istart; i < istop; i += istep) {
                    for (var j = jstart; j < jstop; j += jstep) {
                        if (patched_range) {
                            patched.add(j);
                        }
                        item[i * shape[1] + j] = value[flat_index];
                        flat_index++;
                    }
                }
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (patch_1_1 && !patch_1_1.done && (_a = patch_1.return))
                    _a.call(patch_1);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
        return patched;
    }
    exports.patch_to_column = patch_to_column;
    var ColumnDataSource = /** @class */ (function (_super) {
        tslib_1.__extends(ColumnDataSource, _super);
        function ColumnDataSource(attrs) {
            return _super.call(this, attrs) || this;
        }
        ColumnDataSource.init_ColumnDataSource = function () {
            this.define(function (_a) {
                var Dict = _a.Dict, Any = _a.Any /*Arrayable*/;
                return ({
                    data: [Dict(Any /*Arrayable*/), {}],
                });
            });
        };
        ColumnDataSource.prototype.stream = function (new_data, rollover, setter_id) {
            var e_2, _a;
            var data = this.data;
            try {
                for (var _b = tslib_1.__values(object_1.entries(new_data)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var _d = tslib_1.__read(_c.value, 2), name = _d[0], new_column = _d[1];
                    data[name] = stream_to_column(data[name], new_column, rollover);
                }
            }
            catch (e_2_1) {
                e_2 = { error: e_2_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_2)
                        throw e_2.error;
                }
            }
            this.setv({ data: data }, { silent: true });
            this.streaming.emit();
            if (this.document != null) {
                var hint = new events_1.ColumnsStreamedEvent(this.document, this.ref(), new_data, rollover);
                this.document._notify_change(this, 'data', null, null, { setter_id: setter_id, hint: hint });
            }
        };
        ColumnDataSource.prototype.patch = function (patches, setter_id) {
            var e_3, _a;
            var data = this.data;
            var patched = new Set();
            try {
                for (var _b = tslib_1.__values(object_1.entries(patches)), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var _d = tslib_1.__read(_c.value, 2), column = _d[0], patch = _d[1];
                    patched = set_1.union(patched, patch_to_column(data[column], patch)); // XXX
                }
            }
            catch (e_3_1) {
                e_3 = { error: e_3_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_3)
                        throw e_3.error;
                }
            }
            this.setv({ data: data }, { silent: true });
            this.patching.emit(tslib_1.__spread(patched));
            if (this.document != null) {
                var hint = new events_1.ColumnsPatchedEvent(this.document, this.ref(), patches);
                this.document._notify_change(this, 'data', null, null, { setter_id: setter_id, hint: hint });
            }
        };
        return ColumnDataSource;
    }(columnar_data_source_1.ColumnarDataSource));
    exports.ColumnDataSource = ColumnDataSource;
    ColumnDataSource.__name__ = "ColumnDataSource";
    ColumnDataSource.init_ColumnDataSource();
},
/* core/util/typed_array.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    function concat(array0) {
        var e_1, _a, e_2, _b;
        var arrays = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            arrays[_i - 1] = arguments[_i];
        }
        var n = array0.length;
        try {
            for (var arrays_1 = tslib_1.__values(arrays), arrays_1_1 = arrays_1.next(); !arrays_1_1.done; arrays_1_1 = arrays_1.next()) {
                var array = arrays_1_1.value;
                n += array.length;
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (arrays_1_1 && !arrays_1_1.done && (_a = arrays_1.return))
                    _a.call(arrays_1);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
        var result = new array0.constructor(n);
        result.set(array0, 0);
        var i = array0.length;
        try {
            for (var arrays_2 = tslib_1.__values(arrays), arrays_2_1 = arrays_2.next(); !arrays_2_1.done; arrays_2_1 = arrays_2.next()) {
                var array = arrays_2_1.value;
                result.set(array, i);
                i += array.length;
            }
        }
        catch (e_2_1) {
            e_2 = { error: e_2_1 };
        }
        finally {
            try {
                if (arrays_2_1 && !arrays_2_1.done && (_b = arrays_2.return))
                    _b.call(arrays_2);
            }
            finally {
                if (e_2)
                    throw e_2.error;
            }
        }
        return result;
    }
    exports.concat = concat;
},
/* core/util/set.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    function union() {
        var e_1, _a, e_2, _b;
        var sets = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            sets[_i] = arguments[_i];
        }
        var result = new Set();
        try {
            for (var sets_1 = tslib_1.__values(sets), sets_1_1 = sets_1.next(); !sets_1_1.done; sets_1_1 = sets_1.next()) {
                var set = sets_1_1.value;
                try {
                    for (var set_1 = (e_2 = void 0, tslib_1.__values(set)), set_1_1 = set_1.next(); !set_1_1.done; set_1_1 = set_1.next()) {
                        var item = set_1_1.value;
                        result.add(item);
                    }
                }
                catch (e_2_1) {
                    e_2 = { error: e_2_1 };
                }
                finally {
                    try {
                        if (set_1_1 && !set_1_1.done && (_b = set_1.return))
                            _b.call(set_1);
                    }
                    finally {
                        if (e_2)
                            throw e_2.error;
                    }
                }
            }
        }
        catch (e_1_1) {
            e_1 = { error: e_1_1 };
        }
        finally {
            try {
                if (sets_1_1 && !sets_1_1.done && (_a = sets_1.return))
                    _a.call(sets_1);
            }
            finally {
                if (e_1)
                    throw e_1.error;
            }
        }
        return result;
    }
    exports.union = union;
    function intersection(set) {
        var e_3, _a, e_4, _b;
        var sets = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            sets[_i - 1] = arguments[_i];
        }
        var result = new Set();
        try {
            top: for (var set_2 = tslib_1.__values(set), set_2_1 = set_2.next(); !set_2_1.done; set_2_1 = set_2.next()) {
                var item = set_2_1.value;
                try {
                    for (var sets_2 = (e_4 = void 0, tslib_1.__values(sets)), sets_2_1 = sets_2.next(); !sets_2_1.done; sets_2_1 = sets_2.next()) {
                        var other = sets_2_1.value;
                        if (!other.has(item))
                            continue top;
                    }
                }
                catch (e_4_1) {
                    e_4 = { error: e_4_1 };
                }
                finally {
                    try {
                        if (sets_2_1 && !sets_2_1.done && (_b = sets_2.return))
                            _b.call(sets_2);
                    }
                    finally {
                        if (e_4)
                            throw e_4.error;
                    }
                }
                result.add(item);
            }
        }
        catch (e_3_1) {
            e_3 = { error: e_3_1 };
        }
        finally {
            try {
                if (set_2_1 && !set_2_1.done && (_a = set_2.return))
                    _a.call(set_2);
            }
            finally {
                if (e_3)
                    throw e_3.error;
            }
        }
        return result;
    }
    exports.intersection = intersection;
    function difference(set) {
        var e_5, _a;
        var sets = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            sets[_i - 1] = arguments[_i];
        }
        var result = new Set(set);
        try {
            for (var _b = tslib_1.__values(union.apply(void 0, tslib_1.__spread(sets))), _c = _b.next(); !_c.done; _c = _b.next()) {
                var item = _c.value;
                result.delete(item);
            }
        }
        catch (e_5_1) {
            e_5 = { error: e_5_1 };
        }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return))
                    _a.call(_b);
            }
            finally {
                if (e_5)
                    throw e_5.error;
            }
        }
        return result;
    }
    exports.difference = difference;
},
/* models/annotations/arrow_head.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var model_1 = require(168) /* ../../model */;
    var view_1 = require(157) /* ../../core/view */;
    var visuals = tslib_1.__importStar(require(160) /* ../../core/visuals */);
    var property_mixins_1 = require(163) /* ../../core/property_mixins */;
    var p = tslib_1.__importStar(require(133) /* ../../core/properties */);
    var ArrowHeadView = /** @class */ (function (_super) {
        tslib_1.__extends(ArrowHeadView, _super);
        function ArrowHeadView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ArrowHeadView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.visuals = new visuals.Visuals(this);
        };
        ArrowHeadView.prototype.request_render = function () {
            this.parent.request_render();
        };
        Object.defineProperty(ArrowHeadView.prototype, "canvas", {
            get: function () {
                return this.parent.canvas;
            },
            enumerable: false,
            configurable: true
        });
        ArrowHeadView.prototype.set_data = function (source) {
            var e_1, _a;
            var self = this;
            try {
                for (var _b = tslib_1.__values(this.model), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var prop = _c.value;
                    if (!(prop instanceof p.VectorSpec || prop instanceof p.ScalarSpec))
                        continue;
                    var uniform = prop.uniform(source);
                    self["" + prop.attr] = uniform;
                }
            }
            catch (e_1_1) {
                e_1 = { error: e_1_1 };
            }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return))
                        _a.call(_b);
                }
                finally {
                    if (e_1)
                        throw e_1.error;
                }
            }
        };
        return ArrowHeadView;
    }(view_1.View));
    exports.ArrowHeadView = ArrowHeadView;
    ArrowHeadView.__name__ = "ArrowHeadView";
    var ArrowHead = /** @class */ (function (_super) {
        tslib_1.__extends(ArrowHead, _super);
        function ArrowHead(attrs) {
            return _super.call(this, attrs) || this;
        }
        ArrowHead.init_ArrowHead = function () {
            this.define(function () {
                return ({
                    size: [p.NumberSpec, 25],
                });
            });
        };
        return ArrowHead;
    }(model_1.Model));
    exports.ArrowHead = ArrowHead;
    ArrowHead.__name__ = "ArrowHead";
    ArrowHead.init_ArrowHead();
    var OpenHeadView = /** @class */ (function (_super) {
        tslib_1.__extends(OpenHeadView, _super);
        function OpenHeadView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        OpenHeadView.prototype.clip = function (ctx, i) {
            this.visuals.line.set_vectorize(ctx, i);
            var size_i = this.size.get(i);
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.lineTo(0, 0);
            ctx.lineTo(0.5 * size_i, size_i);
        };
        OpenHeadView.prototype.render = function (ctx, i) {
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                var size_i = this.size.get(i);
                ctx.beginPath();
                ctx.moveTo(0.5 * size_i, size_i);
                ctx.lineTo(0, 0);
                ctx.lineTo(-0.5 * size_i, size_i);
                ctx.stroke();
            }
        };
        return OpenHeadView;
    }(ArrowHeadView));
    exports.OpenHeadView = OpenHeadView;
    OpenHeadView.__name__ = "OpenHeadView";
    var OpenHead = /** @class */ (function (_super) {
        tslib_1.__extends(OpenHead, _super);
        function OpenHead(attrs) {
            return _super.call(this, attrs) || this;
        }
        OpenHead.init_OpenHead = function () {
            this.prototype.default_view = OpenHeadView;
            this.mixins(property_mixins_1.LineVector);
        };
        return OpenHead;
    }(ArrowHead));
    exports.OpenHead = OpenHead;
    OpenHead.__name__ = "OpenHead";
    OpenHead.init_OpenHead();
    var NormalHeadView = /** @class */ (function (_super) {
        tslib_1.__extends(NormalHeadView, _super);
        function NormalHeadView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        NormalHeadView.prototype.clip = function (ctx, i) {
            this.visuals.line.set_vectorize(ctx, i);
            var size_i = this.size.get(i);
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.lineTo(0.5 * size_i, size_i);
        };
        NormalHeadView.prototype.render = function (ctx, i) {
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                this._normal(ctx, i);
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                this._normal(ctx, i);
                ctx.stroke();
            }
        };
        NormalHeadView.prototype._normal = function (ctx, i) {
            var size_i = this.size.get(i);
            ctx.beginPath();
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0, 0);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.closePath();
        };
        return NormalHeadView;
    }(ArrowHeadView));
    exports.NormalHeadView = NormalHeadView;
    NormalHeadView.__name__ = "NormalHeadView";
    var NormalHead = /** @class */ (function (_super) {
        tslib_1.__extends(NormalHead, _super);
        function NormalHead(attrs) {
            return _super.call(this, attrs) || this;
        }
        NormalHead.init_NormalHead = function () {
            this.prototype.default_view = NormalHeadView;
            this.mixins([property_mixins_1.LineVector, property_mixins_1.FillVector]);
            this.override({
                fill_color: "black",
            });
        };
        return NormalHead;
    }(ArrowHead));
    exports.NormalHead = NormalHead;
    NormalHead.__name__ = "NormalHead";
    NormalHead.init_NormalHead();
    var VeeHeadView = /** @class */ (function (_super) {
        tslib_1.__extends(VeeHeadView, _super);
        function VeeHeadView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        VeeHeadView.prototype.clip = function (ctx, i) {
            this.visuals.line.set_vectorize(ctx, i);
            var size_i = this.size.get(i);
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, -2);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.lineTo(0, 0.5 * size_i);
            ctx.lineTo(0.5 * size_i, size_i);
        };
        VeeHeadView.prototype.render = function (ctx, i) {
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                this._vee(ctx, i);
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                this._vee(ctx, i);
                ctx.stroke();
            }
        };
        VeeHeadView.prototype._vee = function (ctx, i) {
            var size_i = this.size.get(i);
            ctx.beginPath();
            ctx.moveTo(0.5 * size_i, size_i);
            ctx.lineTo(0, 0);
            ctx.lineTo(-0.5 * size_i, size_i);
            ctx.lineTo(0, 0.5 * size_i);
            ctx.closePath();
        };
        return VeeHeadView;
    }(ArrowHeadView));
    exports.VeeHeadView = VeeHeadView;
    VeeHeadView.__name__ = "VeeHeadView";
    var VeeHead = /** @class */ (function (_super) {
        tslib_1.__extends(VeeHead, _super);
        function VeeHead(attrs) {
            return _super.call(this, attrs) || this;
        }
        VeeHead.init_VeeHead = function () {
            this.prototype.default_view = VeeHeadView;
            this.mixins([property_mixins_1.LineVector, property_mixins_1.FillVector]);
            this.override({
                fill_color: "black",
            });
        };
        return VeeHead;
    }(ArrowHead));
    exports.VeeHead = VeeHead;
    VeeHead.__name__ = "VeeHead";
    VeeHead.init_VeeHead();
    var TeeHeadView = /** @class */ (function (_super) {
        tslib_1.__extends(TeeHeadView, _super);
        function TeeHeadView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        TeeHeadView.prototype.render = function (ctx, i) {
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                var size_i = this.size.get(i);
                ctx.beginPath();
                ctx.moveTo(0.5 * size_i, 0);
                ctx.lineTo(-0.5 * size_i, 0);
                ctx.stroke();
            }
        };
        TeeHeadView.prototype.clip = function (_ctx, _i) { };
        return TeeHeadView;
    }(ArrowHeadView));
    exports.TeeHeadView = TeeHeadView;
    TeeHeadView.__name__ = "TeeHeadView";
    var TeeHead = /** @class */ (function (_super) {
        tslib_1.__extends(TeeHead, _super);
        function TeeHead(attrs) {
            return _super.call(this, attrs) || this;
        }
        TeeHead.init_TeeHead = function () {
            this.prototype.default_view = TeeHeadView;
            this.mixins(property_mixins_1.LineVector);
        };
        return TeeHead;
    }(ArrowHead));
    exports.TeeHead = TeeHead;
    TeeHead.__name__ = "TeeHead";
    TeeHead.init_TeeHead();
},
/* models/annotations/band.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var upper_lower_1 = require(250) /* ./upper_lower */;
    var mixins = tslib_1.__importStar(require(163) /* ../../core/property_mixins */);
    var BandView = /** @class */ (function (_super) {
        tslib_1.__extends(BandView, _super);
        function BandView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        BandView.prototype.paint = function (ctx) {
            // Draw the band body
            ctx.beginPath();
            ctx.moveTo(this._lower_sx[0], this._lower_sy[0]);
            for (var i = 0, end = this._lower_sx.length; i < end; i++) {
                ctx.lineTo(this._lower_sx[i], this._lower_sy[i]);
            }
            // iterate backwards so that the upper end is below the lower start
            for (var i = this._upper_sx.length - 1; i >= 0; i--) {
                ctx.lineTo(this._upper_sx[i], this._upper_sy[i]);
            }
            ctx.closePath();
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_value(ctx);
                ctx.fill();
            }
            // Draw the lower band edge
            ctx.beginPath();
            ctx.moveTo(this._lower_sx[0], this._lower_sy[0]);
            for (var i = 0, end = this._lower_sx.length; i < end; i++) {
                ctx.lineTo(this._lower_sx[i], this._lower_sy[i]);
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_value(ctx);
                ctx.stroke();
            }
            // Draw the upper band edge
            ctx.beginPath();
            ctx.moveTo(this._upper_sx[0], this._upper_sy[0]);
            for (var i = 0, end = this._upper_sx.length; i < end; i++) {
                ctx.lineTo(this._upper_sx[i], this._upper_sy[i]);
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_value(ctx);
                ctx.stroke();
            }
        };
        return BandView;
    }(upper_lower_1.UpperLowerView));
    exports.BandView = BandView;
    BandView.__name__ = "BandView";
    var Band = /** @class */ (function (_super) {
        tslib_1.__extends(Band, _super);
        function Band(attrs) {
            return _super.call(this, attrs) || this;
        }
        Band.init_Band = function () {
            this.prototype.default_view = BandView;
            this.mixins([mixins.Line, mixins.Fill]);
            this.override({
                fill_color: "#fff9ba",
                fill_alpha: 0.4,
                line_color: "#cccccc",
                line_alpha: 0.3,
            });
        };
        return Band;
    }(upper_lower_1.UpperLower));
    exports.Band = Band;
    Band.__name__ = "Band";
    Band.init_Band();
},
/* models/annotations/upper_lower.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var data_annotation_1 = require(171) /* ./data_annotation */;
    var enums_1 = require(135) /* ../../core/enums */;
    var p = tslib_1.__importStar(require(133) /* ../../core/properties */);
    var UpperLowerView = /** @class */ (function (_super) {
        tslib_1.__extends(UpperLowerView, _super);
        function UpperLowerView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        UpperLowerView.prototype.map_data = function () {
            var frame = this.plot_view.frame;
            var dim = this.model.dimension;
            var xscale = this.coordinates.x_scale;
            var yscale = this.coordinates.y_scale;
            var limit_scale = dim == "height" ? yscale : xscale;
            var base_scale = dim == "height" ? xscale : yscale;
            var limit_view = dim == "height" ? frame.bbox.yview : frame.bbox.xview;
            var base_view = dim == "height" ? frame.bbox.xview : frame.bbox.yview;
            var _lower_sx;
            if (this.model.properties.lower.units == "data")
                _lower_sx = limit_scale.v_compute(this._lower);
            else
                _lower_sx = limit_view.v_compute(this._lower);
            var _upper_sx;
            if (this.model.properties.upper.units == "data")
                _upper_sx = limit_scale.v_compute(this._upper);
            else
                _upper_sx = limit_view.v_compute(this._upper);
            var _base_sx;
            if (this.model.properties.base.units == "data")
                _base_sx = base_scale.v_compute(this._base);
            else
                _base_sx = base_view.v_compute(this._base);
            var _a = tslib_1.__read(dim == 'height' ? [1, 0] : [0, 1], 2), i = _a[0], j = _a[1];
            var _lower = [_lower_sx, _base_sx];
            var _upper = [_upper_sx, _base_sx];
            this._lower_sx = _lower[i];
            this._lower_sy = _lower[j];
            this._upper_sx = _upper[i];
            this._upper_sy = _upper[j];
        };
        return UpperLowerView;
    }(data_annotation_1.DataAnnotationView));
    exports.UpperLowerView = UpperLowerView;
    UpperLowerView.__name__ = "UpperLowerView";
    var XOrYCoordinateSpec = /** @class */ (function (_super) {
        tslib_1.__extends(XOrYCoordinateSpec, _super);
        function XOrYCoordinateSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(XOrYCoordinateSpec.prototype, "dimension", {
            get: function () {
                return this.obj.dimension == "width" ? "x" : "y";
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(XOrYCoordinateSpec.prototype, "units", {
            // XXX: a hack to make a coordinate & unit spec
            get: function () {
                var _a;
                return (_a = this.spec.units) !== null && _a !== void 0 ? _a : "data";
            },
            enumerable: false,
            configurable: true
        });
        return XOrYCoordinateSpec;
    }(p.CoordinateSpec));
    exports.XOrYCoordinateSpec = XOrYCoordinateSpec;
    XOrYCoordinateSpec.__name__ = "XOrYCoordinateSpec";
    var UpperLower = /** @class */ (function (_super) {
        tslib_1.__extends(UpperLower, _super);
        function UpperLower(attrs) {
            return _super.call(this, attrs) || this;
        }
        UpperLower.init_UpperLower = function () {
            this.define(function () {
                return ({
                    dimension: [enums_1.Dimension, "height"],
                    lower: [XOrYCoordinateSpec, { field: "lower" }],
                    upper: [XOrYCoordinateSpec, { field: "upper" }],
                    base: [XOrYCoordinateSpec, { field: "base" }],
                });
            });
        };
        return UpperLower;
    }(data_annotation_1.DataAnnotation));
    exports.UpperLower = UpperLower;
    UpperLower.__name__ = "UpperLower";
    UpperLower.init_UpperLower();
},
/* models/annotations/box_annotation.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var annotation_1 = require(155) /* ./annotation */;
    var mixins = tslib_1.__importStar(require(163) /* ../../core/property_mixins */);
    var enums_1 = require(135) /* ../../core/enums */;
    var bbox_1 = require(214) /* ../../core/util/bbox */;
    exports.EDGE_TOLERANCE = 2.5;
    var BoxAnnotationView = /** @class */ (function (_super) {
        tslib_1.__extends(BoxAnnotationView, _super);
        function BoxAnnotationView() {
            var _this = _super.apply(this, tslib_1.__spread(arguments)) || this;
            _this.bbox = new bbox_1.BBox();
            return _this;
        }
        BoxAnnotationView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.change, function () { return _this.request_render(); });
        };
        BoxAnnotationView.prototype._render = function () {
            var _this = this;
            var _a = this.model, left = _a.left, right = _a.right, top = _a.top, bottom = _a.bottom;
            // don't render if *all* position are null
            if (left == null && right == null && top == null && bottom == null)
                return;
            var frame = this.plot_view.frame;
            var xscale = this.coordinates.x_scale;
            var yscale = this.coordinates.y_scale;
            var _calc_dim = function (dim, dim_units, scale, view, frame_extrema) {
                var sdim;
                if (dim != null) {
                    if (_this.model.screen)
                        sdim = dim;
                    else {
                        if (dim_units == 'data')
                            sdim = scale.compute(dim);
                        else
                            sdim = view.compute(dim);
                    }
                }
                else
                    sdim = frame_extrema;
                return sdim;
            };
            this.bbox = bbox_1.BBox.from_rect({
                left: _calc_dim(left, this.model.left_units, xscale, frame.bbox.xview, frame.bbox.left),
                right: _calc_dim(right, this.model.right_units, xscale, frame.bbox.xview, frame.bbox.right),
                top: _calc_dim(top, this.model.top_units, yscale, frame.bbox.yview, frame.bbox.top),
                bottom: _calc_dim(bottom, this.model.bottom_units, yscale, frame.bbox.yview, frame.bbox.bottom),
            });
            this._paint_box();
        };
        BoxAnnotationView.prototype._paint_box = function () {
            var ctx = this.layer.ctx;
            ctx.save();
            var _a = this.bbox, left = _a.left, top = _a.top, width = _a.width, height = _a.height;
            ctx.beginPath();
            ctx.rect(left, top, width, height);
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_value(ctx);
                ctx.fill();
            }
            if (this.visuals.hatch.doit) {
                this.visuals.hatch.set_value(ctx);
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_value(ctx);
                ctx.stroke();
            }
            ctx.restore();
        };
        BoxAnnotationView.prototype.interactive_bbox = function () {
            var tolerance = this.model.line_width + exports.EDGE_TOLERANCE;
            return this.bbox.grow_by(tolerance);
        };
        BoxAnnotationView.prototype.interactive_hit = function (sx, sy) {
            if (this.model.in_cursor == null)
                return false;
            var bbox = this.interactive_bbox();
            return bbox.contains(sx, sy);
        };
        BoxAnnotationView.prototype.cursor = function (sx, sy) {
            var tol = 3;
            var _a = this.bbox, left = _a.left, right = _a.right, bottom = _a.bottom, top = _a.top;
            if (Math.abs(sx - left) < tol || Math.abs(sx - right) < tol)
                return this.model.ew_cursor;
            else if (Math.abs(sy - bottom) < tol || Math.abs(sy - top) < tol)
                return this.model.ns_cursor;
            else if (this.bbox.contains(sx, sy))
                return this.model.in_cursor;
            else
                return null;
        };
        return BoxAnnotationView;
    }(annotation_1.AnnotationView));
    exports.BoxAnnotationView = BoxAnnotationView;
    BoxAnnotationView.__name__ = "BoxAnnotationView";
    var BoxAnnotation = /** @class */ (function (_super) {
        tslib_1.__extends(BoxAnnotation, _super);
        function BoxAnnotation(attrs) {
            return _super.call(this, attrs) || this;
        }
        BoxAnnotation.init_BoxAnnotation = function () {
            this.prototype.default_view = BoxAnnotationView;
            this.mixins([mixins.Line, mixins.Fill, mixins.Hatch]);
            this.define(function (_a) {
                var Number = _a.Number, Nullable = _a.Nullable;
                return ({
                    top: [Nullable(Number), null],
                    top_units: [enums_1.SpatialUnits, "data"],
                    bottom: [Nullable(Number), null],
                    bottom_units: [enums_1.SpatialUnits, "data"],
                    left: [Nullable(Number), null],
                    left_units: [enums_1.SpatialUnits, "data"],
                    right: [Nullable(Number), null],
                    right_units: [enums_1.SpatialUnits, "data"],
                    /** @deprecated */
                    render_mode: [enums_1.RenderMode, "canvas"],
                });
            });
            this.internal(function (_a) {
                var Boolean = _a.Boolean, String = _a.String, Nullable = _a.Nullable;
                return ({
                    screen: [Boolean, false],
                    ew_cursor: [Nullable(String), null],
                    ns_cursor: [Nullable(String), null],
                    in_cursor: [Nullable(String), null],
                });
            });
            this.override({
                fill_color: '#fff9ba',
                fill_alpha: 0.4,
                line_color: '#cccccc',
                line_alpha: 0.3,
            });
        };
        BoxAnnotation.prototype.update = function (_a) {
            var left = _a.left, right = _a.right, top = _a.top, bottom = _a.bottom;
            this.setv({ left: left, right: right, top: top, bottom: bottom, screen: true });
        };
        return BoxAnnotation;
    }(annotation_1.Annotation));
    exports.BoxAnnotation = BoxAnnotation;
    BoxAnnotation.__name__ = "BoxAnnotation";
    BoxAnnotation.init_BoxAnnotation();
},
/* models/annotations/color_bar.js */ function _(require, module, exports, __esModule, __esExport) {
    __esModule();
    var tslib_1 = require(1) /* tslib */;
    var annotation_1 = require(155) /* ./annotation */;
    var title_1 = require(253) /* ./title */;
    var cartesian_frame_1 = require(259) /* ../canvas/cartesian_frame */;
    var axes_1 = require(277) /* ../axes */;
    var ticker_1 = require(280) /* ../tickers/ticker */;
    var tickers_1 = require(313) /* ../tickers */;
    var tick_formatter_1 = require(281) /* ../formatters/tick_formatter */;
    var formatters_1 = require(320) /* ../formatters */;
    var labeling_1 = require(284) /* ../policies/labeling */;
    var color_mapper_1 = require(318) /* ../mappers/color_mapper */;
    var continuous_color_mapper_1 = require(317) /* ../mappers/continuous_color_mapper */;
    var mappers_1 = require(324) /* ../mappers */;
    var scales_1 = require(332) /* ../scales */;
    var ranges_1 = require(335) /* ../ranges */;
    var enums_1 = require(135) /* ../../core/enums */;
    var mixins = tslib_1.__importStar(require(163) /* ../../core/property_mixins */);
    var array_1 = require(124) /* ../../core/util/array */;
    var layout_1 = require(336) /* ../../core/layout */;
    var alignments_1 = require(337) /* ../../core/layout/alignments */;
    var border_1 = require(340) /* ../../core/layout/border */;
    var side_panel_1 = require(255) /* ../../core/layout/side_panel */;
    var assert_1 = require(126) /* ../../core/util/assert */;
    var build_views_1 = require(237) /* ../../core/build_views */;
    var types_1 = require(123) /* ../../core/util/types */;
    var MINOR_DIM = 25;
    var MAJOR_DIM_MIN_SCALAR = 0.3;
    var MAJOR_DIM_MAX_SCALAR = 0.8;
    var ColorBarView = /** @class */ (function (_super) {
        tslib_1.__extends(ColorBarView, _super);
        function ColorBarView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(ColorBarView.prototype, "orientation", {
            get: function () {
                return this._orientation;
            },
            enumerable: false,
            configurable: true
        });
        ColorBarView.prototype.initialize = function () {
            var _this = this;
            _super.prototype.initialize.call(this);
            var _a = this.model, ticker = _a.ticker, formatter = _a.formatter, color_mapper = _a.color_mapper;
            this._ticker = ticker != "auto" ? ticker : (function () {
                switch (true) {
                    case color_mapper instanceof mappers_1.LogColorMapper:
                        return new tickers_1.LogTicker();
                    case color_mapper instanceof mappers_1.ScanningColorMapper:
                        return new tickers_1.BinnedTicker({ mapper: color_mapper });
                    case color_mapper instanceof mappers_1.CategoricalColorMapper:
                        return new tickers_1.CategoricalTicker();
                    default:
                        return new tickers_1.BasicTicker();
                }
            })();
            this._formatter = formatter != "auto" ? formatter : (function () {
                switch (true) {
                    case _this._ticker instanceof tickers_1.LogTicker:
                        return new formatters_1.LogTickFormatter();
                    case color_mapper instanceof mappers_1.CategoricalColorMapper:
                        return new formatters_1.CategoricalTickFormatter();
                    default:
                        return new formatters_1.BasicTickFormatter();
                }
            })();
            /*
            Creates and returns a scale instance that maps the `color_mapper` range
            (low to high) to a screen space range equal to the length of the ColorBar's
            scale image. The scale is used to calculate the tick coordinates in screen
            coordinates for plotting purposes.
        
            Note: the type of color_mapper has to match the type of scale (i.e.
            a LinearColorMapper will require a corresponding LinearScale instance).
            */
            this._major_range = (function () {
                if (color_mapper instanceof mappers_1.CategoricalColorMapper) {
                    var factors = color_mapper.factors;
                    return new ranges_1.FactorRange({ factors: factors });
                }
                else if (color_mapper instanceof continuous_color_mapper_1.ContinuousColorMapper) {
                    var _a = color_mapper.metrics, min = _a.min, max = _a.max;
                    return new ranges_1.Range1d({ start: min, end: max });
                }
                else
                    assert_1.unreachable();
            })();
            this._major_scale = (function () {
                if (color_mapper instanceof mappers_1.LinearColorMapper)
                    return new scales_1.LinearScale();
                else if (color_mapper instanceof mappers_1.LogColorMapper)
                    return new scales_1.LogScale();
                else if (color_mapper instanceof mappers_1.ScanningColorMapper) {
                    var binning = color_mapper.metrics.binning;
                    return new scales_1.LinearInterpolationScale({ binning: binning });
                }
                else if (color_mapper instanceof mappers_1.CategoricalColorMapper) {
                    return new scales_1.CategoricalScale();
                }
                else
                    assert_1.unreachable();
            })();
            this._minor_range = new ranges_1.Range1d({ start: 0, end: 1 });
            this._minor_scale = new scales_1.LinearScale();
            var major_label_text = mixins.attrs_of(this.model, "major_label_", mixins.Text, true);
            var major_tick_line = mixins.attrs_of(this.model, "major_tick_", mixins.Line, true);
            var minor_tick_line = mixins.attrs_of(this.model, "minor_tick_", mixins.Line, true);
            var title_text = mixins.attrs_of(this.model, "title_", mixins.Text);
            var AxisCls = (function () {
                if (color_mapper instanceof mappers_1.CategoricalColorMapper)
                    return axes_1.CategoricalAxis;
                else if (color_mapper instanceof mappers_1.LogColorMapper)
                    return axes_1.LogAxis;
                else
                    return axes_1.LinearAxis;
            })();
            this._axis = new AxisCls(tslib_1.__assign(tslib_1.__assign(tslib_1.__assign({ ticker: this._ticker, formatter: this._formatter, major_tick_in: this.model.major_tick_in, major_tick_out: this.model.major_tick_out, minor_tick_in: this.model.minor_tick_in, minor_tick_out: this.model.minor_tick_out, major_label_standoff: this.model.label_standoff, major_label_overrides: this.model.major_label_overrides, major_label_policy: this.model.major_label_policy, axis_line_color: null }, major_label_text), major_tick_line), minor_tick_line));
            var title = this.model.title;
            if (title) {
                this._title = new title_1.Title(tslib_1.__assign({ text: title, standoff: this.model.title_standoff }, title_text));
            }
        };
        ColorBarView.prototype.lazy_initialize = function () {
            return tslib_1.__awaiter(this, void 0, void 0, function () {
                var self, parent, _a, _b;
                return tslib_1.__generator(this, function (_c) {
                    switch (_c.label) {
                        case 0: return [4 /*yield*/, _super.prototype.lazy_initialize.call(this)];
                        case 1:
                            _c.sent();
                            self = this;
                            parent = {
                                get parent() {
                                    return self.parent;
                                },
                                get root() {
                                    return self.root;
                                },
                                get frame() {
                                    return self._frame;
                                },
                                get canvas_view() {
                                    return self.parent.canvas_view;
                                },
                                request_layout: function () {
                                    self.parent.request_layout();
                                },
                            };
                            _a = this;
                            return [4 /*yield*/, build_views_1.build_view(this._axis, { parent: parent })];
                        case 2:
                            _a._axis_view = _c.sent();
                            if (!(this._title != null))
                                return [3 /*break*/, 4];
                            _b = this;
                            return [4 /*yield*/, build_views_1.build_view(this._title, { parent: parent })];
                        case 3:
                            _b._title_view = _c.sent();
                            _c.label = 4;
                        case 4: return [2 /*return*/];
                    }
                });
            });
        };
        ColorBarView.prototype.remove = function () {
            var _a;
            (_a = this._title_view) === null || _a === void 0 ? void 0 : _a.remove();
            this._axis_view.remove();
            _super.prototype.remove.call(this);
        };
        ColorBarView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            // TODO: this.connect(this.model.change, () => this.plot_view.invalidate_layout())
            this.connect(this._ticker.change, function () { return _this.request_render(); });
            this.connect(this._formatter.change, function () { return _this.request_render(); });
            this.connect(this.model.color_mapper.metrics_change, function () {
                var range = _this._major_range;
                var scale = _this._major_scale;
                var color_mapper = _this.model.color_mapper;
                if (color_mapper instanceof continuous_color_mapper_1.ContinuousColorMapper && range instanceof ranges_1.Range1d) {
                    var _a = color_mapper.metrics, min = _a.min, max = _a.max;
                    range.setv({ start: min, end: max });
                }
                if (color_mapper instanceof mappers_1.ScanningColorMapper && scale instanceof scales_1.LinearInterpolationScale) {
                    var binning = color_mapper.metrics.binning;
                    scale.binning = binning;
                }
                _this._set_canvas_image();
                _this.plot_view.request_layout(); // this.request_render()
            });
        };
        ColorBarView.prototype._set_canvas_image = function () {
            var _this = this;
            var orientation = this.orientation;
            var palette = (function () {
                var palette = _this.model.color_mapper.palette;
                if (orientation == "vertical")
                    return array_1.reversed(palette);
                else
                    return palette;
            })();
            var _a = tslib_1.__read((function () {
                if (orientation == "vertical")
                    return [1, palette.length];
                else
                    return [palette.length, 1];
            })(), 2), w = _a[0], h = _a[1];
            var canvas = this._image = document.createElement("canvas");
            canvas.width = w;
            canvas.height = h;
            var image_ctx = canvas.getContext("2d");
            var image_data = image_ctx.getImageData(0, 0, w, h);
            // We always want to draw the entire palette linearly, so we create a new
            // LinearColorMapper instance and map a monotonic range of values with
            // length = palette.length to get each palette color in order.
            var cmap = new mappers_1.LinearColorMapper({ palette: palette }).rgba_mapper;
            var buf8 = cmap.v_compute(array_1.range(0, palette.length));
            image_data.data.set(buf8);
            image_ctx.putImageData(image_data, 0, 0);
        };
        ColorBarView.prototype.update_layout = function () {
            var _this = this;
            var _a = this.model, location = _a.location, w = _a.width, h = _a.height, padding = _a.padding, margin = _a.margin;
            var _b = tslib_1.__read((function () {
                if (types_1.isString(location)) {
                    switch (location) {
                        case "top_left":
                            return ["start", "start"];
                        case "top":
                        case "top_center":
                            return ["start", "center"];
                        case "top_right":
                            return ["start", "end"];
                        case "bottom_left":
                            return ["end", "start"];
                        case "bottom":
                        case "bottom_center":
                            return ["end", "center"];
                        case "bottom_right":
                            return ["end", "end"];
                        case "left":
                        case "center_left":
                            return ["center", "start"];
                        case "center":
                        case "center_center":
                            return ["center", "center"];
                        case "right":
                        case "center_right":
                            return ["center", "end"];
                    }
                }
                else
                    return ["end", "start"]; // "bottom_left"
            })(), 2), valign = _b[0], halign = _b[1];
            var orientation = this._orientation = (function () {
                var orientation = _this.model.orientation;
                if (orientation == "auto") {
                    if (_this.panel != null)
                        return _this.panel.is_horizontal ? "horizontal" : "vertical";
                    else {
                        if (halign == "start" || halign == "end" || (halign == "center" && valign == "center"))
                            return "vertical";
                        else
                            return "horizontal";
                    }
                }
                else
                    return orientation;
            })();
            var center_panel = new alignments_1.NodeLayout();
            var top_panel = new alignments_1.VStack();
            var bottom_panel = new alignments_1.VStack();
            var left_panel = new alignments_1.HStack();
            var right_panel = new alignments_1.HStack();
            