/*!
 * Copyright (c) 2012 - 2021, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
  const bokeh = factory();
  bokeh.__bokeh__ = true;
  if (typeof root.Bokeh === "undefined" || typeof root.Bokeh.__bokeh__ === "undefined") {
    root.Bokeh = bokeh;
  }
  const Bokeh = root.Bokeh;
  Bokeh[bokeh.version] = bokeh;
})(this, function() {
  let define;
  const parent_require = typeof require === "function" && require
  return (function(modules, entry, aliases, externals) {
  if (aliases === undefined) aliases = {};
  if (externals === undefined) externals = {};

  const cache = {};

  const normalize = function(name) {
    if (typeof name === "number")
      return name;

    if (name === "bokehjs")
      return entry;

    if (!externals[name]) {
      const prefix = "@bokehjs/"
      if (name.slice(0, prefix.length) === prefix)
        name = name.slice(prefix.length)
    }

    const alias = aliases[name]
    if (alias != null)
      return alias;

    const trailing = name.length > 0 && name[name.lenght-1] === "/";
    const index = aliases[name + (trailing ? "" : "/") + "index"];
    if (index != null)
      return index;

    return name;
  }

  const require = function(name) {
    let mod = cache[name];
    if (!mod) {
      const id = normalize(name);

      mod = cache[id];
      if (!mod) {
        if (!modules[id]) {
          if (externals[id] === false || (externals[id] == true && parent_require)) {
            try {
              mod = {exports: externals[id] ? parent_require(id) : {}};
              cache[id] = cache[name] = mod;
              return mod.exports;
            } catch (e) {}
          }

          const err = new Error("Cannot find module '" + name + "'");
          err.code = 'MODULE_NOT_FOUND';
          throw err;
        }

        mod = {exports: {}};
        cache[id] = cache[name] = mod;

        function __esModule() {
          Object.defineProperty(mod.exports, "__esModule", {value: true});
        }

        function __esExport(name, value) {
          Object.defineProperty(mod.exports, name, {
            enumerable: true, get: function () { return value; }
          });
        }

        modules[id].call(mod.exports, require, mod, mod.exports, __esModule, __esExport);
      } else {
        cache[name] = mod;
      }
    }

    return mod.exports;
  }
  require.resolve = function(name) {
    return ""
  }

  const main = require(entry);
  main.require = require;

  if (typeof Proxy !== "undefined") {
    // allow Bokeh.loader["@bokehjs/module/name"] syntax
    main.loader = new Proxy({}, {
      get: function(_obj, module) {
        return require(module);
      }
    });
  }

  main.register_plugin = function(plugin_modules, plugin_entry, plugin_aliases, plugin_externals) {
    if (plugin_aliases === undefined) plugin_aliases = {};
    if (plugin_externals === undefined) plugin_externals = {};

    for (let name in plugin_modules) {
      modules[name] = plugin_modules[name];
    }

    for (let name in plugin_aliases) {
      aliases[name] = plugin_aliases[name];
    }

    for (let name in plugin_externals) {
      externals[name] = plugin_externals[name];
    }

    const plugin = require(plugin_entry);

    for (let name in plugin) {
      main[name] = plugin[name];
    }

    return plugin;
  }

  return main;
})
([
function _(r,t,_,a,n){a();var o=r(1);r(2),(0,o.__exportStar)(r(118),_)},
function _(t,e,r,n,o){n();var a=function(t,e){return a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var r in e)Object.prototype.hasOwnProperty.call(e,r)&&(t[r]=e[r])},a(t,e)};r.__extends=function(t,e){if("function"!=typeof e&&null!==e)throw new TypeError("Class extends value "+String(e)+" is not a constructor or null");function r(){this.constructor=t}a(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)};function i(t){var e="function"==typeof Symbol&&Symbol.iterator,r=e&&t[e],n=0;if(r)return r.call(t);if(t&&"number"==typeof t.length)return{next:function(){return t&&n>=t.length&&(t=void 0),{value:t&&t[n++],done:!t}}};throw new TypeError(e?"Object is not iterable.":"Symbol.iterator is not defined.")}function c(t,e){var r="function"==typeof Symbol&&t[Symbol.iterator];if(!r)return t;var n,o,a=r.call(t),i=[];try{for(;(void 0===e||e-- >0)&&!(n=a.next()).done;)i.push(n.value)}catch(t){o={error:t}}finally{try{n&&!n.done&&(r=a.return)&&r.call(a)}finally{if(o)throw o.error}}return i}function u(t){return this instanceof u?(this.v=t,this):new u(t)}r.__assign=function(){return r.__assign=Object.assign||function(t){for(var e,r=1,n=arguments.length;r<n;r++)for(var o in e=arguments[r])Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o]);return t},r.__assign.apply(this,arguments)},r.__rest=function(t,e){var r={};for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&e.indexOf(n)<0&&(r[n]=t[n]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var o=0;for(n=Object.getOwnPropertySymbols(t);o<n.length;o++)e.indexOf(n[o])<0&&Object.prototype.propertyIsEnumerable.call(t,n[o])&&(r[n[o]]=t[n[o]])}return r},r.__decorate=function(t,e,r,n){var o,a=arguments.length,i=a<3?e:null===n?n=Object.getOwnPropertyDescriptor(e,r):n;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)i=Reflect.decorate(t,e,r,n);else for(var c=t.length-1;c>=0;c--)(o=t[c])&&(i=(a<3?o(i):a>3?o(e,r,i):o(e,r))||i);return a>3&&i&&Object.defineProperty(e,r,i),i},r.__param=function(t,e){return function(r,n){e(r,n,t)}},r.__metadata=function(t,e){if("object"==typeof Reflect&&"function"==typeof Reflect.metadata)return Reflect.metadata(t,e)},r.__awaiter=function(t,e,r,n){return new(r||(r=Promise))((function(o,a){function i(t){try{u(n.next(t))}catch(t){a(t)}}function c(t){try{u(n.throw(t))}catch(t){a(t)}}function u(t){var e;t.done?o(t.value):(e=t.value,e instanceof r?e:new r((function(t){t(e)}))).then(i,c)}u((n=n.apply(t,e||[])).next())}))},r.__generator=function(t,e){var r,n,o,a,i={label:0,sent:function(){if(1&o[0])throw o[1];return o[1]},trys:[],ops:[]};return a={next:c(0),throw:c(1),return:c(2)},"function"==typeof Symbol&&(a[Symbol.iterator]=function(){return this}),a;function c(a){return function(c){return function(a){if(r)throw new TypeError("Generator is already executing.");for(;i;)try{if(r=1,n&&(o=2&a[0]?n.return:a[0]?n.throw||((o=n.return)&&o.call(n),0):n.next)&&!(o=o.call(n,a[1])).done)return o;switch(n=0,o&&(a=[2&a[0],o.value]),a[0]){case 0:case 1:o=a;break;case 4:return i.label++,{value:a[1],done:!1};case 5:i.label++,n=a[1],a=[0];continue;case 7:a=i.ops.pop(),i.trys.pop();continue;default:if(!(o=i.trys,(o=o.length>0&&o[o.length-1])||6!==a[0]&&2!==a[0])){i=0;continue}if(3===a[0]&&(!o||a[1]>o[0]&&a[1]<o[3])){i.label=a[1];break}if(6===a[0]&&i.label<o[1]){i.label=o[1],o=a;break}if(o&&i.label<o[2]){i.label=o[2],i.ops.push(a);break}o[2]&&i.ops.pop(),i.trys.pop();continue}a=e.call(t,i)}catch(t){a=[6,t],n=0}finally{r=o=0}if(5&a[0])throw a[1];return{value:a[0]?a[1]:void 0,done:!0}}([a,c])}}},r.__createBinding=Object.create?function(t,e,r,n){void 0===n&&(n=r),Object.defineProperty(t,n,{enumerable:!0,get:function(){return e[r]}})}:function(t,e,r,n){void 0===n&&(n=r),t[n]=e[r]},r.__exportStar=function(t,e){for(var n in t)"default"===n||Object.prototype.hasOwnProperty.call(e,n)||(0,r.__createBinding)(e,t,n)},r.__values=i,r.__read=c,r.__spread=function(){for(var t=[],e=0;e<arguments.length;e++)t=t.concat(c(arguments[e]));return t},r.__spreadArrays=function(){for(var t=0,e=0,r=arguments.length;e<r;e++)t+=arguments[e].length;var n=Array(t),o=0;for(e=0;e<r;e++)for(var a=arguments[e],i=0,c=a.length;i<c;i++,o++)n[o]=a[i];return n},r.__spreadArray=function(t,e,r){if(r||2===arguments.length)for(var n,o=0,a=e.length;o<a;o++)!n&&o in e||(n||(n=Array.prototype.slice.call(e,0,o)),n[o]=e[o]);return t.concat(n||Array.prototype.slice.call(e))},r.__await=u,r.__asyncGenerator=function(t,e,r){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var n,o=r.apply(t,e||[]),a=[];return n={},i("next"),i("throw"),i("return"),n[Symbol.asyncIterator]=function(){return this},n;function i(t){o[t]&&(n[t]=function(e){return new Promise((function(r,n){a.push([t,e,r,n])>1||c(t,e)}))})}function c(t,e){try{(r=o[t](e)).value instanceof u?Promise.resolve(r.value.v).then(f,l):s(a[0][2],r)}catch(t){s(a[0][3],t)}var r}function f(t){c("next",t)}function l(t){c("throw",t)}function s(t,e){t(e),a.shift(),a.length&&c(a[0][0],a[0][1])}},r.__asyncDelegator=function(t){var e,r;return e={},n("next"),n("throw",(function(t){throw t})),n("return"),e[Symbol.iterator]=function(){return this},e;function n(n,o){e[n]=t[n]?function(e){return(r=!r)?{value:u(t[n](e)),done:"return"===n}:o?o(e):e}:o}},r.__asyncValues=function(t){if(!Symbol.asyncIterator)throw new TypeError("Symbol.asyncIterator is not defined.");var e,r=t[Symbol.asyncIterator];return r?r.call(t):(t=i(t),e={},n("next"),n("throw"),n("return"),e[Symbol.asyncIterator]=function(){return this},e);function n(r){e[r]=t[r]&&function(e){return new Promise((function(n,o){(function(t,e,r,n){Promise.resolve(n).then((function(e){t({value:e,done:r})}),e)})(n,o,(e=t[r](e)).done,e.value)}))}}},r.__makeTemplateObject=function(t,e){return Object.defineProperty?Object.defineProperty(t,"raw",{value:e}):t.raw=e,t};var f=Object.create?function(t,e){Object.defineProperty(t,"default",{enumerable:!0,value:e})}:function(t,e){t.default=e};r.__importStar=function(t){if(t&&t.__esModule)return t;var e={};if(null!=t)for(var n in t)"default"!==n&&Object.prototype.hasOwnProperty.call(t,n)&&(0,r.__createBinding)(e,t,n);return f(e,t),e},r.__importDefault=function(t){return t&&t.__esModule?t:{default:t}},r.__classPrivateFieldGet=function(t,e,r,n){if("a"===r&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof e?t!==e||!n:!e.has(t))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===r?n:"a"===r?n.call(t):n?n.value:e.get(t)},r.__classPrivateFieldSet=function(t,e,r,n,o){if("m"===n)throw new TypeError("Private method is not writable");if("a"===n&&!o)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof e?t!==e||!o:!e.has(t))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===n?o.call(t,r):o?o.value=r:e.set(t,r),r}},
function _(r,t,o,a,n){a();var y=r(1);if(r(3),r(12),r(15),r(18),r(25),r(55),r(58),r(61),r(64),r(100),r(107),r(113),r(114),void 0===Object.is&&(Object.is=function(r,t){return r===t?0!==r||1/r==1/t:r!=r&&t!=t}),void 0===Object.values&&(Object.values=function(r){return Object.keys(r).map((function(t){return r[t]}))}),void 0===String.prototype.includes&&(String.prototype.includes=function(r,t){return void 0===t&&(t=0),-1!=this.indexOf(r,t)}),void 0===Uint8Array.prototype.fill){var i=Array.prototype.fill;Uint8Array.prototype.fill=i,Int8Array.prototype.fill=i,Uint16Array.prototype.fill=i,Int16Array.prototype.fill=i,Uint32Array.prototype.fill=i,Int32Array.prototype.fill=i,Float32Array.prototype.fill=i,Float64Array.prototype.fill=i}var e=r(116);if(void 0===Uint8Array.from){function l(r){var t=this;return function(o,a,n){var i=new r((0,y.__spreadArray)([],(0,y.__read)(o),!1));return null!=a&&(0,e.inplace_map)(i,(function(r,o){return a.call(null!=n?n:t,r,o)})),i}}Uint8Array.from=l(Uint8Array),Int8Array.from=l(Int8Array),Uint16Array.from=l(Uint16Array),Int16Array.from=l(Int16Array),Uint32Array.from=l(Uint32Array),Int32Array.from=l(Int32Array),Float32Array.from=l(Float32Array),Float64Array.from=l(Float64Array)}if(void 0===Array.prototype[Symbol.iterator]){function p(){var r=0,t=this;return{next:function(){var o=t.length<=r;return{value:o?void 0:t[r++],done:o}}}}!function(){arguments.constructor.prototype[Symbol.iterator]=p,Array.prototype[Symbol.iterator]=p,Uint8Array.prototype[Symbol.iterator]=p,Int8Array.prototype[Symbol.iterator]=p,Uint16Array.prototype[Symbol.iterator]=p,Int16Array.prototype[Symbol.iterator]=p,Uint32Array.prototype[Symbol.iterator]=p,Int32Array.prototype[Symbol.iterator]=p,Float32Array.prototype[Symbol.iterator]=p,Float64Array.prototype[Symbol.iterator]=p}()}"undefined"!=typeof CanvasPixelArray&&(CanvasPixelArray.prototype.set=function(r){for(var t=0;t<this.length;t++)this[t]=r[t]})},
function _(e,n,a,b,i){e(4)()||Object.defineProperty(Object,"assign",{value:e(5),configurable:!0,enumerable:!1,writable:!0})},
function _(r,t,o,a,n){t.exports=function(){var r,t=Object.assign;return"function"==typeof t&&(t(r={foo:"raz"},{bar:"dwa"},{trzy:"trzy"}),r.foo+r.bar+r.trzy==="razdwatrzy")}},
function _(t,r,n,o,c){var a=t(6),f=t(11),h=Math.max;r.exports=function(t,r){var n,o,c,i=h(arguments.length,2);for(t=Object(f(t)),c=function(o){try{t[o]=r[o]}catch(t){n||(n=t)}},o=1;o<i;++o)a(r=arguments[o]).forEach(c);if(void 0!==n)throw n;return t}},
function _(e,t,c,n,o){t.exports=e(7)()?Object.keys:e(8)},
function _(t,r,e,n,c){r.exports=function(){try{return Object.keys("primitive"),!0}catch(t){return!1}}},
function _(t,e,n,c,r){var o=t(9),u=Object.keys;e.exports=function(t){return u(o(t)?Object(t):t)}},
function _(n,r,t,u,o){var c=n(10)();r.exports=function(n){return n!==c&&null!==n}},
function _(n,o,t,c,f){o.exports=function(){}},
function _(n,r,e,o,t){var u=n(9);r.exports=function(n){if(!u(n))throw new TypeError("Cannot use null or undefined");return n}},
function _(e,n,r,t,b){e(13)()||Object.defineProperty(Object,"entries",{value:e(14),configurable:!0,enumerable:!1,writable:!0})},
function _(t,n,o,r,e){n.exports=function(){try{return"foo"===Object.entries({foo:12})[0][0]}catch(t){return!1}}},
function _(r,n,e,t,a){var o=r(11);n.exports=function(r){o(r);var n=[];for(var e in r=Object(r))propertyIsEnumerable.call(r,e)&&n.push([e,r[e]]);return n}},
function _(e,r,n,b,i){e(16)()||Object.defineProperty(Number,"isInteger",{value:e(17),configurable:!0,enumerable:!1,writable:!0})},
function _(n,t,e,r,o){t.exports=function(){var n=Number.isInteger;return"function"==typeof n&&(!n("23")&&n(34)&&!n(32.34))}},
function _(n,t,e,o,r){t.exports=function(n){return"number"==typeof n&&n%1==0}},
function _(e,r,t,n,a){e(19)()||Object.defineProperty(String.prototype,"repeat",{value:e(20),configurable:!0,enumerable:!1,writable:!0})},
function _(o,f,t,e,n){f.exports=function(){return"function"==typeof"foo".repeat&&"foofoo"==="foo".repeat(2)}},
function _(r,n,t,o,e){var i=r(11),u=r(21);n.exports=function(r){var n,t=String(i(this));if((r=u(r))<0)throw new RangeError("Count must be >= 0");if(!isFinite(r))throw new RangeError("Count must be < \u221e");for(n="";r;)r%2&&(n+=t),r>1&&(t+=t),r>>=1;return n}},
function _(t,i,n,r,a){var o=t(22),e=Math.abs,s=Math.floor;i.exports=function(t){return isNaN(t)?0:0!==(t=Number(t))&&isFinite(t)?o(t)*s(e(t)):t}},
function _(n,t,i,o,s){t.exports=n(23)()?Math.sign:n(24)},
function _(n,t,o,f,i){t.exports=function(){var n=Math.sign;return"function"==typeof n&&(1===n(10)&&-1===n(-20))}},
function _(n,r,t,u,e){r.exports=function(n){return n=Number(n),isNaN(n)||0===n?n:n>0?1:-1}},
function _(e,r,a,n,b){e(26)()||Object.defineProperty(Array,"from",{value:e(27),configurable:!0,enumerable:!1,writable:!0})},
function _(n,o,r,a,t){o.exports=function(){var n,o,r=Array.from;return"function"==typeof r&&(o=r(n=["raz","dwa"]),Boolean(o&&o!==n&&"dwa"===o[1]))}},
function _(e,l,r,n,t){var a=e(28).iterator,i=e(50),u=e(51),o=e(52),f=e(53),c=e(11),v=e(9),h=e(54),y=Array.isArray,s=Function.prototype.call,A={configurable:!0,enumerable:!0,writable:!0,value:null},g=Object.defineProperty;l.exports=function(e){var l,r,n,t,p,w,b,d,x,j,O=arguments[1],m=arguments[2];if(e=Object(c(e)),v(O)&&f(O),this&&this!==Array&&u(this))l=this;else{if(!O){if(i(e))return 1!==(p=e.length)?Array.apply(null,e):((t=new Array(1))[0]=e[0],t);if(y(e)){for(t=new Array(p=e.length),r=0;r<p;++r)t[r]=e[r];return t}}t=[]}if(!y(e))if(void 0!==(x=e[a])){for(b=f(x).call(e),l&&(t=new l),d=b.next(),r=0;!d.done;)j=O?s.call(O,m,d.value,r):d.value,l?(A.value=j,g(t,r,A)):t[r]=j,d=b.next(),++r;p=r}else if(h(e)){for(p=e.length,l&&(t=new l),r=0,n=0;r<p;++r)j=e[r],r+1<p&&(w=j.charCodeAt(0))>=55296&&w<=56319&&(j+=e[++r]),j=O?s.call(O,m,j,n):j,l?(A.value=j,g(t,n,A)):t[n]=j,++n;p=n}if(void 0===p)for(p=o(e.length),l&&(t=new l(p)),r=0;r<p;++r)j=O?s.call(O,m,e[r],r):e[r],l?(A.value=j,g(t,r,A)):t[r]=j;return l&&(A.value=null,t.length=p),t}},
function _(o,n,t,b,c){n.exports=o(29)()?o(30).Symbol:o(33)},
function _(t,o,r,e,n){var i=t(30),f={object:!0,symbol:!0};o.exports=function(){var t,o=i.Symbol;if("function"!=typeof o)return!1;t=o("test symbol");try{String(t)}catch(t){return!1}return!!f[typeof o.iterator]&&(!!f[typeof o.toPrimitive]&&!!f[typeof o.toStringTag])}},
function _(o,i,l,n,s){i.exports=o(31)()?globalThis:o(32)},
function _(o,r,l,t,a){r.exports=function(){return"object"==typeof globalThis&&(!!globalThis&&globalThis.Array===Array)}},
function _(t,e,o,r,n){var i=function(){if("object"==typeof self&&self)return self;if("object"==typeof window&&window)return window;throw new Error("Unable to resolve global `this`")};e.exports=function(){if(this)return this;try{Object.defineProperty(Object.prototype,"__global__",{get:function(){return this},configurable:!0})}catch(t){return i()}try{return __global__||i()}finally{delete Object.prototype.__global__}}()},
function _(t,o,r,n,e){var i,c,p,y=t(34),s=t(45),u=t(30).Symbol,f=t(47),_=t(48),a=t(49),S=Object.create,g=Object.defineProperties,m=Object.defineProperty;if("function"==typeof u)try{String(u()),p=!0}catch(t){}else u=null;c=function(t){if(this instanceof c)throw new TypeError("Symbol is not a constructor");return i(t)},o.exports=i=function t(o){var r;if(this instanceof t)throw new TypeError("Symbol is not a constructor");return p?u(o):(r=S(c.prototype),o=void 0===o?"":String(o),g(r,{__description__:y("",o),__name__:y("",f(o))}))},_(i),a(i),g(c.prototype,{constructor:y(i),toString:y("",(function(){return this.__name__}))}),g(i.prototype,{toString:y((function(){return"Symbol ("+s(this).__description__+")"})),valueOf:y((function(){return s(this)}))}),m(i.prototype,i.toPrimitive,y("",(function(){var t=s(this);return"symbol"==typeof t?t:t.toString()}))),m(i.prototype,i.toStringTag,y("c","Symbol")),m(c.prototype,i.toStringTag,y("c",i.prototype[i.toStringTag])),m(c.prototype,i.toPrimitive,y("c",i.prototype[i.toPrimitive]))},
function _(l,e,n,r,a){var t=l(35),c=l(36),i=l(40),o=l(41),u=l(42),v=e.exports=function(l,e){var n,r,a,c,v;return arguments.length<2||"string"!=typeof l?(c=e,e=l,l=null):c=arguments[2],t(l)?(n=u.call(l,"c"),r=u.call(l,"e"),a=u.call(l,"w")):(n=a=!0,r=!1),v={value:e,configurable:n,enumerable:r,writable:a},c?i(o(c),v):v};v.gs=function(l,e,n){var r,a,v,f;return"string"!=typeof l?(v=n,n=e,e=l,l=null):v=arguments[3],t(e)?c(e)?t(n)?c(n)||(v=n,n=void 0):n=void 0:(v=e,e=n=void 0):e=void 0,t(l)?(r=u.call(l,"c"),a=u.call(l,"e")):(r=!0,a=!1),f={get:e,set:n,configurable:r,enumerable:a},v?i(o(v),f):f}},
function _(n,t,u,o,r){t.exports=function(n){return null!=n}},
function _(t,n,o,r,s){var c=t(37),e=/^\s*class[\s{/}]/,i=Function.prototype.toString;n.exports=function(t){return!!c(t)&&!e.test(i.call(t))}},
function _(t,n,r,e,f){var u=t(38);n.exports=function(t){if("function"!=typeof t)return!1;if(!hasOwnProperty.call(t,"length"))return!1;try{if("number"!=typeof t.length)return!1;if("function"!=typeof t.call)return!1;if("function"!=typeof t.apply)return!1}catch(t){return!1}return!u(t)}},
function _(r,t,n,o,c){var u=r(39);t.exports=function(r){if(!u(r))return!1;try{return!!r.constructor&&r.constructor.prototype===r}catch(r){return!1}}},
function _(n,t,e,o,r){var c=n(35),f={object:!0,function:!0,undefined:!0};t.exports=function(n){return!!c(n)&&hasOwnProperty.call(f,typeof n)}},
function _(n,s,t,c,e){s.exports=n(4)()?Object.assign:n(5)},
function _(r,n,t,c,o){var a=r(9),e=Array.prototype.forEach,f=Object.create,u=function(r,n){var t;for(t in r)n[t]=r[t]};n.exports=function(r){var n=f(null);return e.call(arguments,(function(r){a(r)&&u(Object(r),n)})),n}},
function _(t,n,o,i,p){n.exports=t(43)()?String.prototype.contains:t(44)},
function _(n,o,t,a,c){var i="razdwatrzy";o.exports=function(){return"function"==typeof i.contains&&(!0===i.contains("dwa")&&!1===i.contains("foo"))}},
function _(t,n,r,i,o){var e=String.prototype.indexOf;n.exports=function(t){return e.call(this,t,arguments[1])>-1}},
function _(r,n,o,t,e){var i=r(46);n.exports=function(r){if(!i(r))throw new TypeError(r+" is not a symbol");return r}},
function _(o,t,n,r,c){t.exports=function(o){return!!o&&("symbol"==typeof o||!!o.constructor&&("Symbol"===o.constructor.name&&"Symbol"===o[o.constructor.toStringTag]))}},
function _(t,e,n,r,o){var c=t(34),u=Object.create,f=Object.defineProperty,i=Object.prototype,l=u(null);e.exports=function(t){for(var e,n,r=0;l[t+(r||"")];)++r;return l[t+=r||""]=!0,f(i,e="@@"+t,c.gs(null,(function(t){n||(n=!0,f(this,e,c(t)),n=!1)}))),e}},
function _(e,t,a,s,i){var r=e(34),c=e(30).Symbol;t.exports=function(e){return Object.defineProperties(e,{hasInstance:r("",c&&c.hasInstance||e("hasInstance")),isConcatSpreadable:r("",c&&c.isConcatSpreadable||e("isConcatSpreadable")),iterator:r("",c&&c.iterator||e("iterator")),match:r("",c&&c.match||e("match")),replace:r("",c&&c.replace||e("replace")),search:r("",c&&c.search||e("search")),species:r("",c&&c.species||e("species")),split:r("",c&&c.split||e("split")),toPrimitive:r("",c&&c.toPrimitive||e("toPrimitive")),toStringTag:r("",c&&c.toStringTag||e("toStringTag")),unscopables:r("",c&&c.unscopables||e("unscopables"))})}},
function _(r,n,e,t,i){var o=r(34),f=r(45),u=Object.create(null);n.exports=function(r){return Object.defineProperties(r,{for:o((function(n){return u[n]?u[n]:u[n]=r(String(n))})),keyFor:o((function(r){var n;for(n in f(r),u)if(u[n]===r)return n}))})}},
function _(t,n,r,o,c){var e=Object.prototype.toString,u=e.call(function(){return arguments}());n.exports=function(t){return e.call(t)===u}},
function _(t,o,n,e,c){var p=Object.prototype.toString,r=RegExp.prototype.test.bind(/^[object [A-Za-z0-9]*Function]$/);o.exports=function(t){return"function"==typeof t&&r(p.call(t))}},
function _(n,t,r,a,o){var u=n(21),c=Math.max;t.exports=function(n){return c(0,u(n))}},
function _(n,o,t,r,f){o.exports=function(n){if("function"!=typeof n)throw new TypeError(n+" is not a function");return n}},
function _(t,n,o,e,r){var c=Object.prototype.toString,i=c.call("");n.exports=function(t){return"string"==typeof t||t&&"object"==typeof t&&(t instanceof String||c.call(t)===i)||!1}},
function _(e,r,l,t,a){e(56)()||Object.defineProperty(Array.prototype,"fill",{value:e(57),configurable:!0,enumerable:!1,writable:!0})},
function _(n,t,f,i,o){t.exports=function(){var n=[1,2,3,4,5,6];return"function"==typeof n.fill&&"1,2,3,-1,-1,-1"===String(n.fill(-1,-3))}},
function _(t,n,i,o,r){var a=t(21),h=t(52),v=t(11),e=Math.max,f=Math.min;n.exports=function(t){var n,i=v(this),o=arguments[1],r=arguments[2],u=h(i.length);for(o=void 0===o?0:a(o),r=void 0===r?u:a(r),n=o<0?e(u+o,0):f(o,u);n<u&&n<r;++n)i[n]=t;return i}},
function _(e,a,l,n,r){e(59)()||Object.defineProperty(Math,"log10",{value:e(60),configurable:!0,enumerable:!1,writable:!0})},
function _(n,t,o,f,r){t.exports=function(){var n=Math.log10;return"function"==typeof n&&.3010299956639812===n(2)}},
function _(t,a,n,r,N){var o=Math.log,u=Math.LOG10E;a.exports=function(t){return isNaN(t)||(t=Number(t))<0?NaN:0===t?-1/0:1===t?0:t===1/0?1/0:o(t)*u}},
function _(e,a,l,n,r){e(62)()||Object.defineProperty(Math,"log1p",{value:e(63),configurable:!0,enumerable:!1,writable:!0})},
function _(n,t,o,f,r){t.exports=function(){var n=Math.log1p;return"function"==typeof n&&.6931471805599453===n(1)}},
function _(e,n,r,t,N){var a=Math.log;n.exports=function(e){return isNaN(e)||(e=Number(e))<-1?NaN:-1===e?-1/0:0===e?e:e===1/0?1/0:e>-1e-8&&e<1e-8?e-e*e/2:a(1+e)}},
function _(e,n,r,t,a){e(65)()||Object.defineProperty(e(66),"Set",{value:e(67),configurable:!0,enumerable:!1,writable:!0})},
function _(t,e,n,o,f){e.exports=function(){var t,e;return"function"==typeof Set&&(t=new Set(["raz","dwa","trzy"]),"[object Set]"===String(t)&&(3===t.size&&("function"==typeof t.add&&("function"==typeof t.clear&&("function"==typeof t.delete&&("function"==typeof t.entries&&("function"==typeof t.forEach&&("function"==typeof t.has&&("function"==typeof t.keys&&("function"==typeof t.values&&(!1===(e=t.values().next()).done&&"raz"===e.value)))))))))))}},
function _(t,e,o,r,l){var n=function(){if("object"==typeof self&&self)return self;if("object"==typeof window&&window)return window;throw new Error("Unable to resolve global `this`")};e.exports=function(){if(this)return this;if("object"==typeof globalThis&&globalThis)return globalThis;try{Object.defineProperty(Object.prototype,"__global__",{get:function(){return this},configurable:!0})}catch(t){return n()}try{return __global__||n()}finally{delete Object.prototype.__global__}}()},
function _(t,e,n,r,i){var s,o,a,_=t(68),c=t(69),u=t(73),h=t(53),l=t(34),f=t(78),p=t(28),y=t(79),v=t(81),d=t(98),D=t(99),g=Function.prototype.call,w=Object.defineProperty,b=Object.getPrototypeOf;D&&(a=Set),e.exports=s=function(){var t,e=arguments[0];if(!(this instanceof s))throw new TypeError("Constructor requires 'new'");return t=D&&u?u(new a,b(this)):this,null!=e&&y(e),w(t,"__setData__",l("c",[])),e?(v(e,(function(t){-1===c.call(this,t)&&this.push(t)}),t.__setData__),t):t},D&&(u&&u(s,a),s.prototype=Object.create(a.prototype,{constructor:l(s)})),f(Object.defineProperties(s.prototype,{add:l((function(t){return this.has(t)||this.emit("_add",this.__setData__.push(t)-1,t),this})),clear:l((function(){this.__setData__.length&&(_.call(this.__setData__),this.emit("_clear"))})),delete:l((function(t){var e=c.call(this.__setData__,t);return-1!==e&&(this.__setData__.splice(e,1),this.emit("_delete",e,t),!0)})),entries:l((function(){return new d(this,"key+value")})),forEach:l((function(t){var e,n,r,i=arguments[1];for(h(t),n=(e=this.values())._next();void 0!==n;)r=e._resolve(n),g.call(t,i,r,r,this),n=e._next()})),has:l((function(t){return-1!==c.call(this.__setData__,t)})),keys:l(o=function(){return this.values()}),size:l.gs((function(){return this.__setData__.length})),values:l((function(){return new d(this)})),toString:l((function(){return"[object Set]"}))})),w(s.prototype,p.iterator,l(o)),w(s.prototype,p.toStringTag,l("c","Set"))},
function _(t,n,i,r,e){var h=t(11);n.exports=function(){return h(this).length=0,this}},
function _(t,r,e,i,n){var o=t(70),a=t(52),h=t(11),s=Array.prototype.indexOf,p=Object.prototype.hasOwnProperty,f=Math.abs,l=Math.floor;r.exports=function(t){var r,e,i,n;if(!o(t))return s.apply(this,arguments);for(e=a(h(this).length),i=arguments[1],r=i=isNaN(i)?0:i>=0?l(i):a(this.length)-l(f(i));r<e;++r)if(p.call(this,r)&&(n=this[r],o(n)))return r;return-1}},
function _(N,e,i,n,o){e.exports=N(71)()?Number.isNaN:N(72)},
function _(n,t,o,r,u){t.exports=function(){var n=Number.isNaN;return"function"==typeof n&&(!n({})&&n(NaN)&&!n(34))}},
function _(n,t,o,r,u){t.exports=function(n){return n!=n}},
function _(t,e,o,c,f){e.exports=t(74)()?Object.setPrototypeOf:t(75)},
function _(t,e,o,n,r){var c=Object.create,f=Object.getPrototypeOf,u={};e.exports=function(){var t=Object.setPrototypeOf,e=arguments[0]||c;return"function"==typeof t&&f(t(e(null),u))===u}},
function _(e,t,l,r,o){var n,_,u,c,i=e(76),p=e(11),f=Object.prototype.isPrototypeOf,a=Object.defineProperty,b={configurable:!0,enumerable:!1,writable:!0,value:void 0};n=function(e,t){if(p(e),null===t||i(t))return e;throw new TypeError("Prototype must be null or an object")},t.exports=(_=function(){var e,t=Object.create(null),l={},r=Object.getOwnPropertyDescriptor(Object.prototype,"__proto__");if(r){try{(e=r.set).call(t,l)}catch(e){}if(Object.getPrototypeOf(t)===l)return{set:e,level:2}}return t.__proto__=l,Object.getPrototypeOf(t)===l?{level:2}:((t={}).__proto__=l,Object.getPrototypeOf(t)===l&&{level:1})}(),_?(2===_.level?_.set?(c=_.set,u=function(e,t){return c.call(n(e,t),t),e}):u=function(e,t){return n(e,t).__proto__=t,e}:u=function e(t,l){var r;return n(t,l),(r=f.call(e.nullPolyfill,t))&&delete e.nullPolyfill.__proto__,null===l&&(l=e.nullPolyfill),t.__proto__=l,r&&a(e.nullPolyfill,"__proto__",b),t},Object.defineProperty(u,"level",{configurable:!1,enumerable:!1,writable:!1,value:_.level})):null),e(77)},
function _(n,t,o,c,e){var f=n(9),r={function:!0,object:!0};t.exports=function(n){return f(n)&&r[typeof n]||!1}},
function _(e,r,l,t,n){var o,a,i,u,b=Object.create;e(74)()||(o=e(75)),r.exports=o?1!==o.level?b:(a={},i={},u={configurable:!1,enumerable:!1,writable:!0,value:void 0},Object.getOwnPropertyNames(Object.prototype).forEach((function(e){i[e]="__proto__"!==e?u:{configurable:!0,enumerable:!1,writable:!0,value:void 0}})),Object.defineProperties(a,i),Object.defineProperty(o,"nullPolyfill",{configurable:!1,enumerable:!1,writable:!1,value:a}),function(e,r){return b(null===e?a:e,r)}):b},
function _(e,t,n,i,l){var r,c,_,o,s,a,h,f=e(34),u=e(53),p=Function.prototype.apply,b=Function.prototype.call,y=Object.create,O=Object.defineProperty,j=Object.defineProperties,v=Object.prototype.hasOwnProperty,d={configurable:!0,enumerable:!1,writable:!0};c=function(e,t){var n,i;return u(t),i=this,r.call(this,e,n=function(){_.call(i,e,n),p.call(t,this,arguments)}),n.__eeOnceListener__=t,this},o=function(e){var t,n,i,l,r;if(v.call(this,"__ee__")&&(l=this.__ee__[e]))if("object"==typeof l){for(n=arguments.length,r=new Array(n-1),t=1;t<n;++t)r[t-1]=arguments[t];for(l=l.slice(),t=0;i=l[t];++t)p.call(i,this,r)}else switch(arguments.length){case 1:b.call(l,this);break;case 2:b.call(l,this,arguments[1]);break;case 3:b.call(l,this,arguments[1],arguments[2]);break;default:for(n=arguments.length,r=new Array(n-1),t=1;t<n;++t)r[t-1]=arguments[t];p.call(l,this,r)}},s={on:r=function(e,t){var n;return u(t),v.call(this,"__ee__")?n=this.__ee__:(n=d.value=y(null),O(this,"__ee__",d),d.value=null),n[e]?"object"==typeof n[e]?n[e].push(t):n[e]=[n[e],t]:n[e]=t,this},once:c,off:_=function(e,t){var n,i,l,r;if(u(t),!v.call(this,"__ee__"))return this;if(!(n=this.__ee__)[e])return this;if("object"==typeof(i=n[e]))for(r=0;l=i[r];++r)l!==t&&l.__eeOnceListener__!==t||(2===i.length?n[e]=i[r?0:1]:i.splice(r,1));else i!==t&&i.__eeOnceListener__!==t||delete n[e];return this},emit:o},a={on:f(r),once:f(c),off:f(_),emit:f(o)},h=j({},a),t.exports=n=function(e){return null==e?y(h):j(Object(e),a)},n.methods=s},
function _(r,n,t,e,o){var i=r(80);n.exports=function(r){if(!i(r))throw new TypeError(r+" is not iterable");return r}},
function _(r,t,n,o,i){var a=r(50),e=r(9),f=r(54),u=r(28).iterator,c=Array.isArray;t.exports=function(r){return!!e(r)&&(!!c(r)||(!!f(r)||(!!a(r)||"function"==typeof r[u])))}},
function _(r,n,t,a,e){var o=r(50),l=r(53),c=r(54),i=r(82),f=Array.isArray,u=Function.prototype.call,s=Array.prototype.some;n.exports=function(r,n){var t,a,e,y,p,A,g,v,x=arguments[2];if(f(r)||o(r)?t="array":c(r)?t="string":r=i(r),l(n),e=function(){y=!0},"array"!==t)if("string"!==t)for(a=r.next();!a.done;){if(u.call(n,x,a.value,e),y)return;a=r.next()}else for(A=r.length,p=0;p<A&&(g=r[p],p+1<A&&(v=g.charCodeAt(0))>=55296&&v<=56319&&(g+=r[++p]),u.call(n,x,g,e),!y);++p);else s.call(r,(function(r){return u.call(n,x,r,e),y}))}},
function _(n,t,e,o,r){var f=n(50),i=n(54),u=n(83),c=n(97),w=n(79),a=n(28).iterator;t.exports=function(n){return"function"==typeof w(n)[a]?n[a]():f(n)?new u(n):i(n)?new c(n):new u(n)}},
function _(t,e,r,o,_){var i,n=t(73),l=t(42),a=t(34),s=t(28),c=t(84),u=Object.defineProperty;i=e.exports=function(t,e){if(!(this instanceof i))throw new TypeError("Constructor requires 'new'");c.call(this,t),e=e?l.call(e,"key+value")?"key+value":l.call(e,"key")?"key":"value":"value",u(this,"__kind__",a("",e))},n&&n(i,c),delete i.prototype.constructor,i.prototype=Object.create(c.prototype,{_resolve:a((function(t){return"value"===this.__kind__?this.__list__[t]:"key+value"===this.__kind__?[t,this.__list__[t]]:t}))}),u(i.prototype,s.toStringTag,a("c","Array Iterator"))},
function _(_,t,e,n,i){var o,s=_(68),r=_(40),h=_(53),d=_(11),c=_(34),u=_(85),l=_(28),f=Object.defineProperty,x=Object.defineProperties;t.exports=o=function(_,t){if(!(this instanceof o))throw new TypeError("Constructor requires 'new'");x(this,{__list__:c("w",d(_)),__context__:c("w",t),__nextIndex__:c("w",0)}),t&&(h(t.on),t.on("_add",this._onAdd),t.on("_delete",this._onDelete),t.on("_clear",this._onClear))},delete o.prototype.constructor,x(o.prototype,r({_next:c((function(){var _;if(this.__list__)return this.__redo__&&void 0!==(_=this.__redo__.shift())?_:this.__nextIndex__<this.__list__.length?this.__nextIndex__++:void this._unBind()})),next:c((function(){return this._createResult(this._next())})),_createResult:c((function(_){return void 0===_?{done:!0,value:void 0}:{done:!1,value:this._resolve(_)}})),_resolve:c((function(_){return this.__list__[_]})),_unBind:c((function(){this.__list__=null,delete this.__redo__,this.__context__&&(this.__context__.off("_add",this._onAdd),this.__context__.off("_delete",this._onDelete),this.__context__.off("_clear",this._onClear),this.__context__=null)})),toString:c((function(){return"[object "+(this[l.toStringTag]||"Object")+"]"}))},u({_onAdd:c((function(_){_>=this.__nextIndex__||(++this.__nextIndex__,this.__redo__?(this.__redo__.forEach((function(t,e){t>=_&&(this.__redo__[e]=++t)}),this),this.__redo__.push(_)):f(this,"__redo__",c("c",[_])))})),_onDelete:c((function(_){var t;_>=this.__nextIndex__||(--this.__nextIndex__,this.__redo__&&(-1!==(t=this.__redo__.indexOf(_))&&this.__redo__.splice(t,1),this.__redo__.forEach((function(t,e){t>_&&(this.__redo__[e]=--t)}),this)))})),_onClear:c((function(){this.__redo__&&s.call(this.__redo__),this.__nextIndex__=0}))}))),f(o.prototype,l.iterator,c((function(){return this})))},
function _(e,t,n,r,o){var i,l=e(35),u=e(86),s=e(91),v=e(92),a=e(41),c=e(94),f=Function.prototype.bind,p=Object.defineProperty,h=Object.prototype.hasOwnProperty;i=function(e,t,n){var r,o=u(t)&&s(t.value);return delete(r=v(t)).writable,delete r.value,r.get=function(){return!n.overwriteDefinition&&h.call(this,e)?o:(t.value=f.call(o,n.resolveContext?n.resolveContext(this):this),p(this,e,t),this[e])},r},t.exports=function(e){var t=a(arguments[1]);return l(t.resolveContext)&&s(t.resolveContext),c(e,(function(e,n){return i(n,e,t)}))}},
function _(n,t,o,r,u){var e=n(87),a=n(35);t.exports=function(n){return a(n)?n:e(n,"Cannot use %v",arguments[1])}},
function _(r,e,n,t,i){var o=r(35),f=r(39),u=r(88),a=r(89),l=function(r,e){return r.replace("%v",a(e))};e.exports=function(r,e,n){if(!f(n))throw new TypeError(l(e,r));if(!o(r)){if("default"in n)return n.default;if(n.isOptional)return null}var t=u(n.errorMessage);throw o(t)||(t=e),new TypeError(l(t,r))}},
function _(t,n,r,u,e){var i=t(35),o=t(39),f=Object.prototype.toString;n.exports=function(t){if(!i(t))return null;if(o(t)){var n=t.toString;if("function"!=typeof n)return null;if(n===f)return null}try{return""+t}catch(t){return null}}},
function _(r,e,n,t,u){var c=r(90),a=/[\n\r\u2028\u2029]/g;e.exports=function(r){var e=c(r);return null===e?"<Non-coercible to string value>":(e.length>100&&(e=e.slice(0,99)+"\u2026"),e=e.replace(a,(function(r){switch(r){case"\n":return"\\n";case"\r":return"\\r";case"\u2028":return"\\u2028";case"\u2029":return"\\u2029";default:throw new Error("Unexpected character")}})))}},
function _(t,r,n,c,u){r.exports=function(t){try{return t.toString()}catch(r){try{return String(t)}catch(t){return null}}}},
function _(n,t,i,o,r){var u=n(87),a=n(36);t.exports=function(n){return a(n)?n:u(n,"%v is not a plain function",arguments[1])}},
function _(n,r,t,e,u){var c=n(93),i=n(40),f=n(11);r.exports=function(n){var r=Object(f(n)),t=arguments[1],e=Object(arguments[2]);if(r!==n&&!t)return r;var u={};return t?c(t,(function(r){(e.ensure||r in n)&&(u[r]=n[r])})):i(u,n),u}},
function _(r,o,f,n,t){o.exports=r(26)()?Array.from:r(27)},
function _(n,t,o,c,r){var u=n(53),a=n(95),i=Function.prototype.call;t.exports=function(n,t){var o={},c=arguments[2];return u(t),a(n,(function(n,r,u,a){o[r]=i.call(t,c,n,r,u,a)})),o}},
function _(o,c,f,n,r){c.exports=o(96)("forEach")},
function _(t,n,o,c,e){var r=t(53),u=t(11),l=Function.prototype.bind,p=Function.prototype.call,i=Object.keys,a=Object.prototype.propertyIsEnumerable;n.exports=function(t,n){return function(o,c){var e,f=arguments[2],y=arguments[3];return o=Object(u(o)),r(c),e=i(o),y&&e.sort("function"==typeof y?l.call(y,o):void 0),"function"!=typeof t&&(t=e[t]),p.call(t,e,(function(t,e){return a.call(o,t)?p.call(c,f,o[t],t,o,e):n}))}}},
function _(t,_,e,n,r){var i,o=t(73),s=t(34),h=t(28),c=t(84),l=Object.defineProperty;i=_.exports=function(t){if(!(this instanceof i))throw new TypeError("Constructor requires 'new'");t=String(t),c.call(this,t),l(this,"__length__",s("",t.length))},o&&o(i,c),delete i.prototype.constructor,i.prototype=Object.create(c.prototype,{_next:s((function(){if(this.__list__)return this.__nextIndex__<this.__length__?this.__nextIndex__++:void this._unBind()})),_resolve:s((function(t){var _,e=this.__list__[t];return this.__nextIndex__===this.__length__?e:(_=e.charCodeAt(0))>=55296&&_<=56319?e+this.__list__[this.__nextIndex__++]:e}))}),l(i.prototype,h.toStringTag,s("c","String Iterator"))},
function _(t,e,_,r,i){var o,n=t(73),s=t(42),a=t(34),c=t(84),l=t(28).toStringTag,u=Object.defineProperty;o=e.exports=function(t,e){if(!(this instanceof o))return new o(t,e);c.call(this,t.__setData__,t),e=e&&s.call(e,"key+value")?"key+value":"value",u(this,"__kind__",a("",e))},n&&n(o,c),o.prototype=Object.create(c.prototype,{constructor:a(o),_resolve:a((function(t){return"value"===this.__kind__?this.__list__[t]:[this.__list__[t],this.__list__[t]]})),toString:a((function(){return"[object Set Iterator]"}))}),u(o.prototype,l,a("c","Set Iterator"))},
function _(t,e,o,p,n){e.exports="undefined"!=typeof Set&&"[object Set]"===Object.prototype.toString.call(Set.prototype)},
function _(e,a,n,r,b){e(101)()||Object.defineProperty(e(66),"Map",{value:e(102),configurable:!0,enumerable:!1,writable:!0})},
function _(t,e,n,o,f){e.exports=function(){var t,e;if("function"!=typeof Map)return!1;try{t=new Map([["raz","one"],["dwa","two"],["trzy","three"]])}catch(t){return!1}return"[object Map]"===String(t)&&(3===t.size&&("function"==typeof t.clear&&("function"==typeof t.delete&&("function"==typeof t.entries&&("function"==typeof t.forEach&&("function"==typeof t.get&&("function"==typeof t.has&&("function"==typeof t.keys&&("function"==typeof t.set&&("function"==typeof t.values&&(!1===(e=t.entries().next()).done&&(!!e.value&&("raz"===e.value[0]&&"one"===e.value[1])))))))))))))}},
function _(t,e,a,_,n){var i,r=t(68),s=t(69),o=t(73),p=t(53),c=t(11),u=t(34),l=t(78),h=t(28),f=t(79),y=t(81),m=t(103),D=t(106),v=Function.prototype.call,K=Object.defineProperties,d=Object.getPrototypeOf;e.exports=i=function(){var t,e,a,_=arguments[0];if(!(this instanceof i))throw new TypeError("Constructor requires 'new'");return a=D&&o&&Map!==i?o(new Map,d(this)):this,null!=_&&f(_),K(a,{__mapKeysData__:u("c",t=[]),__mapValuesData__:u("c",e=[])}),_?(y(_,(function(a){var _=c(a)[0];a=a[1],-1===s.call(t,_)&&(t.push(_),e.push(a))}),a),a):a},D&&(o&&o(i,Map),i.prototype=Object.create(Map.prototype,{constructor:u(i)})),l(K(i.prototype,{clear:u((function(){this.__mapKeysData__.length&&(r.call(this.__mapKeysData__),r.call(this.__mapValuesData__),this.emit("_clear"))})),delete:u((function(t){var e=s.call(this.__mapKeysData__,t);return-1!==e&&(this.__mapKeysData__.splice(e,1),this.__mapValuesData__.splice(e,1),this.emit("_delete",e,t),!0)})),entries:u((function(){return new m(this,"key+value")})),forEach:u((function(t){var e,a,_=arguments[1];for(p(t),a=(e=this.entries())._next();void 0!==a;)v.call(t,_,this.__mapValuesData__[a],this.__mapKeysData__[a],this),a=e._next()})),get:u((function(t){var e=s.call(this.__mapKeysData__,t);if(-1!==e)return this.__mapValuesData__[e]})),has:u((function(t){return-1!==s.call(this.__mapKeysData__,t)})),keys:u((function(){return new m(this,"key")})),set:u((function(t,e){var a,_=s.call(this.__mapKeysData__,t);return-1===_&&(_=this.__mapKeysData__.push(t)-1,a=!0),this.__mapValuesData__[_]=e,a&&this.emit("_add",_,t),this})),size:u.gs((function(){return this.__mapKeysData__.length})),values:u((function(){return new m(this,"value")})),toString:u((function(){return"[object Map]"}))})),Object.defineProperty(i.prototype,h.iterator,u((function(){return this.entries()}))),Object.defineProperty(i.prototype,h.toStringTag,u("c","Map"))},
function _(t,_,e,i,n){var r,o=t(73),s=t(34),a=t(84),u=t(28).toStringTag,c=t(104),l=Object.defineProperties,p=a.prototype._unBind;r=_.exports=function(t,_){if(!(this instanceof r))return new r(t,_);a.call(this,t.__mapKeysData__,t),_&&c[_]||(_="key+value"),l(this,{__kind__:s("",_),__values__:s("w",t.__mapValuesData__)})},o&&o(r,a),r.prototype=Object.create(a.prototype,{constructor:s(r),_resolve:s((function(t){return"value"===this.__kind__?this.__values__[t]:"key"===this.__kind__?this.__list__[t]:[this.__list__[t],this.__values__[t]]})),_unBind:s((function(){this.__values__=null,p.call(this)})),toString:s((function(){return"[object Map Iterator]"}))}),Object.defineProperty(r.prototype,u,s("c","Map Iterator"))},
function _(e,u,a,k,l){u.exports=e(105)("key","value","key+value")},
function _(r,t,n,c,o){var a=Array.prototype.forEach,e=Object.create;t.exports=function(r){var t=e(null);return a.call(arguments,(function(r){t[r]=!0})),t}},
function _(t,e,o,p,n){e.exports="undefined"!=typeof Map&&"[object Map]"===Object.prototype.toString.call(new Map)},
function _(e,a,n,r,b){e(108)()||Object.defineProperty(e(66),"WeakMap",{value:e(109),configurable:!0,enumerable:!1,writable:!0})},
function _(t,e,n,o,f){e.exports=function(){var t,e;if("function"!=typeof WeakMap)return!1;try{t=new WeakMap([[e={},"one"],[{},"two"],[{},"three"]])}catch(t){return!1}return"[object WeakMap]"===String(t)&&("function"==typeof t.set&&(t.set({},1)===t&&("function"==typeof t.delete&&("function"==typeof t.has&&"one"===t.get(e)))))}},
function _(t,e,a,r,n){var o,p=t(9),_=t(73),i=t(110),c=t(11),s=t(111),u=t(34),f=t(82),k=t(81),M=t(28).toStringTag,h=t(112),w=Array.isArray,y=Object.defineProperty,l=Object.prototype.hasOwnProperty,D=Object.getPrototypeOf;e.exports=o=function(){var t,e=arguments[0];if(!(this instanceof o))throw new TypeError("Constructor requires 'new'");return t=h&&_&&WeakMap!==o?_(new WeakMap,D(this)):this,p(e)&&(w(e)||(e=f(e))),y(t,"__weakMapData__",u("c","$weakMap$"+s())),e?(k(e,(function(e){c(e),t.set(e[0],e[1])})),t):t},h&&(_&&_(o,WeakMap),o.prototype=Object.create(WeakMap.prototype,{constructor:u(o)})),Object.defineProperties(o.prototype,{delete:u((function(t){return!!l.call(i(t),this.__weakMapData__)&&(delete t[this.__weakMapData__],!0)})),get:u((function(t){if(l.call(i(t),this.__weakMapData__))return t[this.__weakMapData__]})),has:u((function(t){return l.call(i(t),this.__weakMapData__)})),set:u((function(t,e){return y(i(t),this.__weakMapData__,u("c",e)),this})),toString:u((function(){return"[object WeakMap]"}))}),y(o.prototype,M,u("c","WeakMap"))},
function _(n,r,t,o,e){var i=n(76);r.exports=function(n){if(!i(n))throw new TypeError(n+" is not an Object");return n}},
function _(t,n,r,e,o){var a=Object.create(null),c=Math.random;n.exports=function(){var t;do{t=c().toString(36).slice(2)}while(a[t]);return t}},
function _(t,e,o,a,p){e.exports="function"==typeof WeakMap&&"[object WeakMap]"===Object.prototype.toString.call(new WeakMap)},
function _(e,b,l,n,r){e(29)()||Object.defineProperty(e(30),"Symbol",{value:e(33),configurable:!0,enumerable:!1,writable:!0})},
function _(l,o,f,i,n){o.exports=l(115).polyfill()},
function _(t,e,n,r,o){
/*!
     * @overview es6-promise - a tiny implementation of Promises/A+.
     * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
     * @license   Licensed under MIT license
     *            See https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE
     * @version   v4.2.8+1e68dce6
     */
!function(t,r){"object"==typeof n&&void 0!==e?e.exports=r():"function"==typeof define&&define.amd?define(r):t.ES6Promise=r()}(this,(function(){"use strict";function e(t){return"function"==typeof t}var n=Array.isArray?Array.isArray:function(t){return"[object Array]"===Object.prototype.toString.call(t)},r=0,o=void 0,i=void 0,s=function(t,e){v[r]=t,v[r+1]=e,2===(r+=2)&&(i?i(p):b())};var u="undefined"!=typeof window?window:void 0,c=u||{},a=c.MutationObserver||c.WebKitMutationObserver,f="undefined"==typeof self&&"undefined"!=typeof process&&"[object process]"==={}.toString.call(process),l="undefined"!=typeof Uint8ClampedArray&&"undefined"!=typeof importScripts&&"undefined"!=typeof MessageChannel;function h(){var t=setTimeout;return function(){return t(p,1)}}var v=new Array(1e3);function p(){for(var t=0;t<r;t+=2){(0,v[t])(v[t+1]),v[t]=void 0,v[t+1]=void 0}r=0}var d,_,y,m,b=void 0;function w(t,e){var n=this,r=new this.constructor(j);void 0===r[A]&&k(r);var o=n._state;if(o){var i=arguments[o-1];s((function(){return F(o,r,i,n._result)}))}else O(n,r,t,e);return r}function g(t){if(t&&"object"==typeof t&&t.constructor===this)return t;var e=new this(j);return T(e,t),e}f?b=function(){return process.nextTick(p)}:a?(_=0,y=new a(p),m=document.createTextNode(""),y.observe(m,{characterData:!0}),b=function(){m.data=_=++_%2}):l?((d=new MessageChannel).port1.onmessage=p,b=function(){return d.port2.postMessage(0)}):b=void 0===u&&"function"==typeof t?function(){try{var t=Function("return this")().require("vertx");return void 0!==(o=t.runOnLoop||t.runOnContext)?function(){o(p)}:h()}catch(t){return h()}}():h();var A=Math.random().toString(36).substring(2);function j(){}var S=void 0;function E(t,n,r){n.constructor===t.constructor&&r===w&&n.constructor.resolve===g?function(t,e){1===e._state?P(t,e._result):2===e._state?C(t,e._result):O(e,void 0,(function(e){return T(t,e)}),(function(e){return C(t,e)}))}(t,n):void 0===r?P(t,n):e(r)?function(t,e,n){s((function(t){var r=!1,o=function(t,e,n,r){try{t.call(e,n,r)}catch(t){return t}}(n,e,(function(n){r||(r=!0,e!==n?T(t,n):P(t,n))}),(function(e){r||(r=!0,C(t,e))}),t._label);!r&&o&&(r=!0,C(t,o))}),t)}(t,n,r):P(t,n)}function T(t,e){if(t===e)C(t,new TypeError("You cannot resolve a promise with itself"));else if(o=typeof(r=e),null===r||"object"!==o&&"function"!==o)P(t,e);else{var n=void 0;try{n=e.then}catch(e){return void C(t,e)}E(t,e,n)}var r,o}function M(t){t._onerror&&t._onerror(t._result),x(t)}function P(t,e){t._state===S&&(t._result=e,t._state=1,0!==t._subscribers.length&&s(x,t))}function C(t,e){t._state===S&&(t._state=2,t._result=e,s(M,t))}function O(t,e,n,r){var o=t._subscribers,i=o.length;t._onerror=null,o[i]=e,o[i+1]=n,o[i+2]=r,0===i&&t._state&&s(x,t)}function x(t){var e=t._subscribers,n=t._state;if(0!==e.length){for(var r=void 0,o=void 0,i=t._result,s=0;s<e.length;s+=3)r=e[s],o=e[s+n],r?F(n,r,o,i):o(i);t._subscribers.length=0}}function F(t,n,r,o){var i=e(r),s=void 0,u=void 0,c=!0;if(i){try{s=r(o)}catch(t){c=!1,u=t}if(n===s)return void C(n,new TypeError("A promises callback cannot return that same promise."))}else s=o;n._state!==S||(i&&c?T(n,s):!1===c?C(n,u):1===t?P(n,s):2===t&&C(n,s))}var Y=0;function k(t){t[A]=Y++,t._state=void 0,t._result=void 0,t._subscribers=[]}var q=function(){function t(t,e){this._instanceConstructor=t,this.promise=new t(j),this.promise[A]||k(this.promise),n(e)?(this.length=e.length,this._remaining=e.length,this._result=new Array(this.length),0===this.length?P(this.promise,this._result):(this.length=this.length||0,this._enumerate(e),0===this._remaining&&P(this.promise,this._result))):C(this.promise,new Error("Array Methods must be provided an Array"))}return t.prototype._enumerate=function(t){for(var e=0;this._state===S&&e<t.length;e++)this._eachEntry(t[e],e)},t.prototype._eachEntry=function(t,e){var n=this._instanceConstructor,r=n.resolve;if(r===g){var o=void 0,i=void 0,s=!1;try{o=t.then}catch(t){s=!0,i=t}if(o===w&&t._state!==S)this._settledAt(t._state,e,t._result);else if("function"!=typeof o)this._remaining--,this._result[e]=t;else if(n===D){var u=new n(j);s?C(u,i):E(u,t,o),this._willSettleAt(u,e)}else this._willSettleAt(new n((function(e){return e(t)})),e)}else this._willSettleAt(r(t),e)},t.prototype._settledAt=function(t,e,n){var r=this.promise;r._state===S&&(this._remaining--,2===t?C(r,n):this._result[e]=n),0===this._remaining&&P(r,this._result)},t.prototype._willSettleAt=function(t,e){var n=this;O(t,void 0,(function(t){return n._settledAt(1,e,t)}),(function(t){return n._settledAt(2,e,t)}))},t}();var D=function(){function t(e){this[A]=Y++,this._result=this._state=void 0,this._subscribers=[],j!==e&&("function"!=typeof e&&function(){throw new TypeError("You must pass a resolver function as the first argument to the promise constructor")}(),this instanceof t?function(t,e){try{e((function(e){T(t,e)}),(function(e){C(t,e)}))}catch(e){C(t,e)}}(this,e):function(){throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.")}())}return t.prototype.catch=function(t){return this.then(null,t)},t.prototype.finally=function(t){var n=this,r=n.constructor;return e(t)?n.then((function(e){return r.resolve(t()).then((function(){return e}))}),(function(e){return r.resolve(t()).then((function(){throw e}))})):n.then(t,t)},t}();return D.prototype.then=w,D.all=function(t){return new q(this,t).promise},D.race=function(t){var e=this;return n(t)?new e((function(n,r){for(var o=t.length,i=0;i<o;i++)e.resolve(t[i]).then(n,r)})):new e((function(t,e){return e(new TypeError("You must pass an array to race."))}))},D.resolve=g,D.reject=function(t){var e=new this(j);return C(e,t),e},D._setScheduler=function(t){i=t},D._setAsap=function(t){s=t},D._asap=s,D.polyfill=function(){var t=void 0;if("undefined"!=typeof global)t=global;else if("undefined"!=typeof self)t=self;else try{t=Function("return this")()}catch(t){throw new Error("polyfill failed because global object is unavailable in this environment")}var e=t.Promise;if(e){var n=null;try{n=Object.prototype.toString.call(e.resolve())}catch(t){}if("[object Promise]"===n&&!e.cast)return}t.Promise=D},D.Promise=D,D}))},
function _(n,r,t,e,i){e();var o=n(1),u=n(117);function f(n,r,t){for(var e,i,u=[],f=3;f<arguments.length;f++)u[f-3]=arguments[f];var a=n.length;r<0&&(r+=a),r<0?r=0:r>a&&(r=a),null==t||t>a-r?t=a-r:t<0&&(t=0);for(var l=a-t+u.length,c=new n.constructor(l),v=0;v<r;v++)c[v]=n[v];try{for(var h=(0,o.__values)(u),g=h.next();!g.done;g=h.next()){var s=g.value;c[v++]=s}}catch(n){e={error:n}}finally{try{g&&!g.done&&(i=h.return)&&i.call(h)}finally{if(e)throw e.error}}for(var d=r+t;d<a;d++)c[v++]=n[d];return c}function a(n,r){return f(n,r,n.length-r)}function l(n,r){for(var t=n.length,e=new n.constructor(t),i=0;i<t;i++)e[i]=r(n[i],i,n);return e}function c(n,r,t){var e,i,o=n.length;if(void 0===t&&0==o)throw new Error("can't reduce an empty array without an initial value");for(void 0===t?(e=n[0],i=1):(e=t,i=0);i<o;i++)e=r(e,n[i],i,n);return e}function v(n){return function(r,t){for(var e=r.length,i=n>0?0:e-1;i>=0&&i<e;i+=n)if(t(r[i]))return i;return-1}}function h(n,r){for(var t=0,e=n.length;t<e;){var i=Math.floor((t+e)/2);n[i]<r?t=i+1:e=i}return t}function g(n,r,t,e,i){var o=(i-t)/(e-r),u=o*(n-r)+t;return isFinite(u)||(u=o*(n-e)+i,isFinite(u)||t!=i||(u=t)),u}function s(n,r){if(n<r[0])return-1;if(n>r[r.length-1])return r.length;for(var t=0,e=r.length-1;e-t!=1;){var i=t+Math.floor((e-t)/2);n>=r[i]?t=i:e=i}return t}t.is_empty=function(n){return 0==n.length},t.copy=function(n){return Array.isArray(n)?n.slice():new n.constructor(n)},t.splice=f,t.head=a,t.insert=function(n,r,t){return f(n,t,0,r)},t.append=function(n,r){return f(n,n.length,0,r)},t.prepend=function(n,r){return f(n,0,0,r)},t.indexOf=function(n,r){for(var t=0,e=n.length;t<e;t++)if(n[t]===r)return t;return-1},t.subselect=function(n,r){for(var t=r.length,e=new n.constructor(t),i=0;i<t;i++)e[i]=n[r[i]];return e},t.mul=function(n,r,t){for(var e=n.length,i=null!=t?t:new n.constructor(e),o=0;o<e;o++)i[o]=n[o]*r;return i},t.map=l,t.inplace_map=function(n,r,t){for(var e=n.length,i=null!=t?t:n,o=0;o<e;o++)i[o]=r(n[o],o)},t.filter=function(n,r){for(var t=n.length,e=new n.constructor(t),i=0,o=0;o<t;o++){var u=n[o];r(u,o,n)&&(e[i++]=u)}return a(e,i)},t.reduce=c,t.min=function(n){for(var r,t=1/0,e=0,i=n.length;e<i;e++)r=n[e],!isNaN(r)&&r<t&&(t=r);return t},t.max=function(n){for(var r,t=-1/0,e=0,i=n.length;e<i;e++)r=n[e],!isNaN(r)&&r>t&&(t=r);return t},t.minmax=function(n){for(var r,t=1/0,e=-1/0,i=0,o=n.length;i<o;i++)r=n[i],isNaN(r)||(r<t&&(t=r),r>e&&(e=r));return[t,e]},t.minmax2=function(n,r){for(var t,e,i=1/0,o=-1/0,u=1/0,f=-1/0,a=Math.min(n.length,r.length),l=0;l<a;l++)t=n[l],e=r[l],isNaN(t)||isNaN(e)||(t<i&&(i=t),t>o&&(o=t),e<u&&(u=e),e>f&&(f=e));return[i,o,u,f]},t.min_by=function(n,r){if(0==n.length)throw new Error("min_by() called with an empty array");for(var t=n[0],e=r(t),i=1,o=n.length;i<o;i++){var u=n[i],f=r(u);f<e&&(t=u,e=f)}return t},t.max_by=function(n,r){if(0==n.length)throw new Error("max_by() called with an empty array");for(var t=n[0],e=r(t),i=1,o=n.length;i<o;i++){var u=n[i],f=r(u);f>e&&(t=u,e=f)}return t},t.sum=function(n){for(var r=0,t=0,e=n.length;t<e;t++)r+=n[t];return r},t.cumsum=function(n){var r=new n.constructor(n.length);return c(n,(function(n,t,e){return r[e]=n+t}),0),r},t.every=function(n,r){for(var t=0,e=n.length;t<e;t++)if(!r(n[t]))return!1;return!0},t.some=function(n,r){for(var t=0,e=n.length;t<e;t++)if(r(n[t]))return!0;return!1},t.index_of=function(n,r){for(var t=0,e=n.length;t<e;t++)if(n[t]===r)return t;return-1},t.find_index=v(1),t.find_last_index=v(-1),t.find=function(n,r){var e=(0,t.find_index)(n,r);return-1==e?void 0:n[e]},t.find_last=function(n,r){var e=(0,t.find_last_index)(n,r);return-1==e?void 0:n[e]},t.sorted_index=h,t.bin_counts=function(n,r){for(var t=r.length-1,e=Array(t).fill(0),i=0;i<n.length;i++){var o=h(r,n[i]);e[(0,u.clamp)(o-1,0,t-1)]+=1}return e},t.interpolate=function(n,r,t){for(var e=n.length,i=new Array(e),o=0;o<e;o++){var u=n[o];if(isNaN(u))i[o]=u;else{var f=s(u,r);if(-1==f)i[o]=t[0];else if(f==r.length)i[o]=t[t.length-1];else if(f==r.length-1||r[f]==u)i[o]=t[f];else{var a=r[f],l=t[f],c=r[f+1],v=t[f+1];i[o]=g(u,a,l,c,v)}}}return i},t.left_edge_index=s,t.norm=function(n,r,t){var e=t-r;return l(n,(function(n){return(n-r)/e}))}},
function _(n,r,t,a,e){a();var o=Math.PI;function u(n){if(0==n)return 0;for(;n<=0;)n+=2*o;for(;n>2*o;)n-=2*o;return n}function f(n,r){return u(n-r)}function i(){return Math.random()}function c(n){switch(n){case"deg":return o/180;case"rad":return 1;case"grad":return o/200;case"turn":return 2*o}}t.angle_norm=u,t.angle_dist=f,t.angle_between=function(n,r,t,a){void 0===a&&(a=!1);var e=f(r,t);if(0==e)return!1;if(e==2*o)return!0;var i=u(n),c=f(r,i)<=e&&f(i,t)<=e;return a?!c:c},t.random=i,t.randomIn=function(n,r){return null==r&&(r=n,n=0),n+Math.floor(Math.random()*(r-n+1))},t.atan2=function(n,r){return Math.atan2(r[1]-n[1],r[0]-n[0])},t.radians=function(n){return n*(o/180)},t.degrees=function(n){return n/(o/180)},t.resolve_angle=function(n,r){return-c(r)*n},t.to_radians_coeff=c,t.rnorm=function(n,r){for(var t,a;t=i(),a=(2*(a=i())-1)*Math.sqrt(1/Math.E*2),!(-4*t*t*Math.log(t)>=a*a););var e=a/t;return e=n+r*e},t.clamp=function(n,r,t){return n<r?r:n>t?t:n},t.log=function(n,r){return void 0===r&&(r=Math.E),Math.log(n)/Math.log(r)},t.float32_epsilon=1.1920928955078125e-7},
function _(t,_,n,o,r){o(),(0,t(1).__exportStar)(t(119),n)},
function _(e,t,o,s,l){s();var r=e(1);l("version",e(120).version),l("index",e(121).index),o.embed=(0,r.__importStar)(e(121)),o.protocol=(0,r.__importStar)(e(521)),o._testing=(0,r.__importStar)(e(522));var _=e(134);l("logger",_.logger),l("set_log_level",_.set_log_level),l("settings",e(143).settings),l("Models",e(124).Models),l("documents",e(122).documents),l("safely",e(523).safely)},
function _(n,i,o,c,e){c(),o.version="2.4.2"},
function _(e,r,t,n,o){n();var s=e(1),a=e(122),d=e(134),u=e(149),i=e(128),_=e(125),l=e(131),c=e(512),m=e(514),f=e(513),h=e(512);o("add_document_standalone",h.add_document_standalone),o("index",h.index),o("add_document_from_session",e(514).add_document_from_session);var v=e(519);function b(e,r,t,n){return(0,s.__awaiter)(this,void 0,void 0,(function(){var o,l,h,v,b,g,p,w,y,k,O,x,B,E,H,K,R,T,S,j,D,I,J;return(0,s.__generator)(this,(function(L){switch(L.label){case 0:(0,_.isString)(e)&&(e=JSON.parse((0,u.unescape)(e))),o={};try{for(l=(0,s.__values)((0,i.entries)(e)),h=l.next();!h.done;h=l.next())v=(0,s.__read)(h.value,2),b=v[0],g=v[1],o[b]=a.Document.from_json(g)}catch(e){j={error:e}}finally{try{h&&!h.done&&(D=l.return)&&D.call(l)}finally{if(j)throw j.error}}p=[],L.label=1;case 1:L.trys.push([1,12,13,14]),w=(0,s.__values)(r),y=w.next(),L.label=2;case 2:return y.done?[3,11]:(k=y.value,O=(0,f._resolve_element)(k),x=(0,f._resolve_root_elements)(k),null==k.docid?[3,4]:(E=(B=p).push,[4,(0,c.add_document_standalone)(o[k.docid],O,x,k.use_for_title)]));case 3:return E.apply(B,[L.sent()]),[3,10];case 4:if(null==k.token)return[3,9];H=(0,m._get_ws_url)(t,n),d.logger.debug("embed: computed ws url: "+H),L.label=5;case 5:return L.trys.push([5,7,,8]),R=(K=p).push,[4,(0,m.add_document_from_session)(H,k.token,O,x,k.use_for_title)];case 6:return R.apply(K,[L.sent()]),console.log("Bokeh items were rendered successfully"),[3,8];case 7:return T=L.sent(),console.log("Error rendering Bokeh items:",T),[3,8];case 8:return[3,10];case 9:throw new Error("Error rendering Bokeh items: either 'docid' or 'token' was expected.");case 10:return y=w.next(),[3,2];case 11:return[3,14];case 12:return S=L.sent(),I={error:S},[3,14];case 13:try{y&&!y.done&&(J=w.return)&&J.call(w)}finally{if(I)throw I.error}return[7];case 14:return[2,p]}}))}))}o("embed_items_notebook",v.embed_items_notebook),o("kernels",v.kernels),o("BOKEH_ROOT",e(513).BOKEH_ROOT),t.embed_item=function(e,r){return(0,s.__awaiter)(this,void 0,void 0,(function(){var t,n,o,a,d,i;return(0,s.__generator)(this,(function(_){switch(_.label){case 0:return t={},n=(0,u.uuid4)(),t[n]=e.doc,null==r&&(r=e.target_id),null!=(o=document.getElementById(r))&&o.classList.add(f.BOKEH_ROOT),(i={})[e.root_id]=r,a={roots:i,root_ids:[e.root_id],docid:n},[4,(0,l.defer)()];case 1:return _.sent(),[4,b(t,[a])];case 2:return d=s.__read.apply(void 0,[_.sent(),1]),[2,d[0]]}}))}))},t.embed_items=function(e,r,t,n){return(0,s.__awaiter)(this,void 0,void 0,(function(){return(0,s.__generator)(this,(function(o){switch(o.label){case 0:return[4,(0,l.defer)()];case 1:return o.sent(),[2,b(e,r,t,n)]}}))}))}},
function _(r,t,_,a,o){a();var e=r(1);(0,e.__exportStar)(r(123),_),(0,e.__exportStar)(r(150),_)},
function _(e,t,r,n,o){n();var a=e(1),l=e(124),i=e(120),s=e(134),_=e(366),c=e(129),u=e(145),f=e(130),d=e(132),v=e(146),h=e(144),y=e(126),p=e(128),m=(0,a.__importStar)(e(192)),w=e(141),g=e(125),x=e(424),b=e(190),k=e(168),M=e(511),j=e(150),S=function(){function e(e){this.document=e,this.session=null,this.subscribed_models=new Set}return e.prototype.send_event=function(e){var t=new j.MessageSentEvent(this.document,"bokeh_event",e.to_json());this.document._trigger_on_change(t)},e.prototype.trigger=function(e){var t,r;try{for(var n=(0,a.__values)(this.subscribed_models),o=n.next();!o.done;o=n.next()){var l=o.value;null!=e.origin&&e.origin!=l||l._process_event(e)}}catch(e){t={error:e}}finally{try{o&&!o.done&&(r=n.return)&&r.call(n)}finally{if(t)throw t.error}}},e}();r.EventManager=S,S.__name__="EventManager",r.documents=[],r.DEFAULT_TITLE="Bokeh Application";var z=function(){function e(e){var t;r.documents.push(this),this._init_timestamp=Date.now(),this._resolver=null!==(t=null==e?void 0:e.resolver)&&void 0!==t?t:new l.ModelResolver,this._title=r.DEFAULT_TITLE,this._roots=[],this._all_models=new Map,this._all_models_freeze_count=0,this._callbacks=new Map,this._message_callbacks=new Map,this.event_manager=new S(this),this.idle=new f.Signal0(this,"idle"),this._idle_roots=new WeakMap,this._interactive_timestamp=null,this._interactive_plot=null}return Object.defineProperty(e.prototype,"layoutables",{get:function(){return this._roots.filter((function(e){return e instanceof x.LayoutDOM}))},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"is_idle",{get:function(){var e,t;try{for(var r=(0,a.__values)(this.layoutables),n=r.next();!n.done;n=r.next()){var o=n.value;if(!this._idle_roots.has(o))return!1}}catch(t){e={error:t}}finally{try{n&&!n.done&&(t=r.return)&&t.call(r)}finally{if(e)throw e.error}}return!0},enumerable:!1,configurable:!0}),e.prototype.notify_idle=function(e){this._idle_roots.set(e,!0),this.is_idle&&(s.logger.info("document idle at "+(Date.now()-this._init_timestamp)+" ms"),this.event_manager.send_event(new _.DocumentReady),this.idle.emit())},e.prototype.clear=function(){this._push_all_models_freeze();try{for(;this._roots.length>0;)this.remove_root(this._roots[0])}finally{this._pop_all_models_freeze()}},e.prototype.interactive_start=function(e,t){void 0===t&&(t=null),null==this._interactive_plot&&(this._interactive_plot=e,this._interactive_plot.trigger_event(new _.LODStart)),this._interactive_finalize=t,this._interactive_timestamp=Date.now()},e.prototype.interactive_stop=function(){null!=this._interactive_plot&&(this._interactive_plot.trigger_event(new _.LODEnd),null!=this._interactive_finalize&&this._interactive_finalize()),this._interactive_plot=null,this._interactive_timestamp=null,this._interactive_finalize=null},e.prototype.interactive_duration=function(){return null==this._interactive_timestamp?-1:Date.now()-this._interactive_timestamp},e.prototype.destructively_move=function(e){var t,r,n,o;if(e===this)throw new Error("Attempted to overwrite a document with itself");e.clear();var l=(0,y.copy)(this._roots);this.clear();try{for(var i=(0,a.__values)(l),s=i.next();!s.done;s=i.next()){if(null!=(u=s.value).document)throw new Error("Somehow we didn't detach "+u)}}catch(e){t={error:e}}finally{try{s&&!s.done&&(r=i.return)&&r.call(i)}finally{if(t)throw t.error}}if(0!=this._all_models.size)throw new Error("this._all_models still had stuff in it: "+this._all_models);try{for(var _=(0,a.__values)(l),c=_.next();!c.done;c=_.next()){var u=c.value;e.add_root(u)}}catch(e){n={error:e}}finally{try{c&&!c.done&&(o=_.return)&&o.call(_)}finally{if(n)throw n.error}}e.set_title(this._title)},e.prototype._push_all_models_freeze=function(){this._all_models_freeze_count+=1},e.prototype._pop_all_models_freeze=function(){this._all_models_freeze_count-=1,0===this._all_models_freeze_count&&this._recompute_all_models()},e.prototype._invalidate_all_models=function(){s.logger.debug("invalidating document models"),0===this._all_models_freeze_count&&this._recompute_all_models()},e.prototype._recompute_all_models=function(){var e,t,r,n,o,l,i,s,_=new Set;try{for(var c=(0,a.__values)(this._roots),u=c.next();!u.done;u=c.next()){var f=u.value;_=m.union(_,f.references())}}catch(t){e={error:t}}finally{try{u&&!u.done&&(t=c.return)&&t.call(c)}finally{if(e)throw e.error}}var d=new Set(this._all_models.values()),v=m.difference(d,_),h=m.difference(_,d),y=new Map;try{for(var p=(0,a.__values)(_),w=p.next();!w.done;w=p.next()){var g=w.value;y.set(g.id,g)}}catch(e){r={error:e}}finally{try{w&&!w.done&&(n=p.return)&&n.call(p)}finally{if(r)throw r.error}}try{for(var x=(0,a.__values)(v),b=x.next();!b.done;b=x.next()){b.value.detach_document()}}catch(e){o={error:e}}finally{try{b&&!b.done&&(l=x.return)&&l.call(x)}finally{if(o)throw o.error}}try{for(var k=(0,a.__values)(h),M=k.next();!M.done;M=k.next()){M.value.attach_document(this)}}catch(e){i={error:e}}finally{try{M&&!M.done&&(s=k.return)&&s.call(k)}finally{if(i)throw i.error}}this._all_models=y},e.prototype.roots=function(){return this._roots},e.prototype.add_root=function(e,t){if(s.logger.debug("Adding root: "+e),!(0,y.includes)(this._roots,e)){this._push_all_models_freeze();try{this._roots.push(e)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new j.RootAddedEvent(this,e,t))}},e.prototype.remove_root=function(e,t){var r=this._roots.indexOf(e);if(!(r<0)){this._push_all_models_freeze();try{this._roots.splice(r,1)}finally{this._pop_all_models_freeze()}this._trigger_on_change(new j.RootRemovedEvent(this,e,t))}},e.prototype.title=function(){return this._title},e.prototype.set_title=function(e,t){e!==this._title&&(this._title=e,this._trigger_on_change(new j.TitleChangedEvent(this,e,t)))},e.prototype.get_model_by_id=function(e){var t;return null!==(t=this._all_models.get(e))&&void 0!==t?t:null},e.prototype.get_model_by_name=function(e){var t,r,n=[];try{for(var o=(0,a.__values)(this._all_models.values()),l=o.next();!l.done;l=o.next()){var i=l.value;i instanceof k.Model&&i.name==e&&n.push(i)}}catch(e){t={error:e}}finally{try{l&&!l.done&&(r=o.return)&&r.call(o)}finally{if(t)throw t.error}}switch(n.length){case 0:return null;case 1:return n[0];default:throw new Error("Multiple models are named '"+e+"'")}},e.prototype.on_message=function(e,t){var r=this._message_callbacks.get(e);null==r?this._message_callbacks.set(e,new Set([t])):r.add(t)},e.prototype.remove_on_message=function(e,t){var r;null===(r=this._message_callbacks.get(e))||void 0===r||r.delete(t)},e.prototype._trigger_on_message=function(e,t){var r,n,o=this._message_callbacks.get(e);if(null!=o)try{for(var l=(0,a.__values)(o),i=l.next();!i.done;i=l.next()){(0,i.value)(t)}}catch(e){r={error:e}}finally{try{i&&!i.done&&(n=l.return)&&n.call(l)}finally{if(r)throw r.error}}},e.prototype.on_change=function(e,t){void 0===t&&(t=!1),this._callbacks.has(e)||this._callbacks.set(e,t)},e.prototype.remove_on_change=function(e){this._callbacks.delete(e)},e.prototype._trigger_on_change=function(e){var t,r,n,o;try{for(var l=(0,a.__values)(this._callbacks),i=l.next();!i.done;i=l.next()){var s=(0,a.__read)(i.value,2),_=s[0];if(!s[1]&&e instanceof j.DocumentEventBatch)try{for(var c=(n=void 0,(0,a.__values)(e.events)),u=c.next();!u.done;u=c.next()){_(u.value)}}catch(e){n={error:e}}finally{try{u&&!u.done&&(o=c.return)&&o.call(c)}finally{if(n)throw n.error}}else _(e)}}catch(e){t={error:e}}finally{try{i&&!i.done&&(r=l.return)&&r.call(l)}finally{if(t)throw t.error}}},e.prototype._notify_change=function(e,t,r,n,o){this._trigger_on_change(new j.ModelChangedEvent(this,e,t,r,n,null==o?void 0:o.setter_id,null==o?void 0:o.hint))},e._instantiate_object=function(e,t,r,n){var o=(0,a.__assign)((0,a.__assign)({},r),{id:e,__deferred__:!0});return new(n.get(t))(o)},e._instantiate_references_json=function(t,r,n){var o,l,i,s=new Map;try{for(var _=(0,a.__values)(t),c=_.next();!c.done;c=_.next()){var u=c.value,f=u.id,d=u.type,v=null!==(i=u.attributes)&&void 0!==i?i:{},h=r.get(f);null==h&&(h=e._instantiate_object(f,d,v,n),null!=u.subtype&&h.set_subtype(u.subtype)),s.set(h.id,h)}}catch(e){o={error:e}}finally{try{c&&!c.done&&(l=_.return)&&l.call(_)}finally{if(o)throw o.error}}return s},e._resolve_refs=function(e,t,r,n){function o(e){var l;if((0,d.is_ref)(e)){var i=null!==(l=t.get(e.id))&&void 0!==l?l:r.get(e.id);if(null!=i)return i;throw new Error("reference "+JSON.stringify(e)+" isn't known (not in Document?)")}if((0,v.is_NDArray_ref)(e)){var s=(0,v.decode_NDArray)(e,n),_=s.buffer,c=s.dtype,u=s.shape;return(0,h.ndarray)(_,{dtype:c,shape:u})}return(0,g.isArray)(e)?function(e){var t,r,n=[];try{for(var l=(0,a.__values)(e),i=l.next();!i.done;i=l.next()){var s=i.value;n.push(o(s))}}catch(e){t={error:e}}finally{try{i&&!i.done&&(r=l.return)&&r.call(l)}finally{if(t)throw t.error}}return n}(e):(0,g.isPlainObject)(e)?function(e){var t,r,n={};try{for(var l=(0,a.__values)((0,p.entries)(e)),i=l.next();!i.done;i=l.next()){var s=(0,a.__read)(i.value,2),_=s[0],c=s[1];n[_]=o(c)}}catch(e){t={error:e}}finally{try{i&&!i.done&&(r=l.return)&&r.call(l)}finally{if(t)throw t.error}}return n}(e):e}return o(e)},e._initialize_references_json=function(t,r,n,o){var l,i,s,_,u,f,d=new Map;try{for(var v=(0,a.__values)(t),h=v.next();!h.done;h=v.next()){var y=h.value,m=y.id,w=y.attributes,x=!r.has(m),b=x?n.get(m):r.get(m),k=e._resolve_refs(w,r,n,o);b.setv(k,{silent:!0}),d.set(m,{instance:b,is_new:x})}}catch(e){l={error:e}}finally{try{h&&!h.done&&(i=v.return)&&i.call(v)}finally{if(l)throw l.error}}var M=[],j=new Set;function S(e){var t,r,n,o,l,i;if(e instanceof c.HasProps){if(d.has(e.id)&&!j.has(e.id)){j.add(e.id);var s=d.get(e.id),_=s.instance,u=s.is_new,f=_.attributes;try{for(var v=(0,a.__values)((0,p.values)(f)),h=v.next();!h.done;h=v.next()){S(h.value)}}catch(e){t={error:e}}finally{try{h&&!h.done&&(r=v.return)&&r.call(v)}finally{if(t)throw t.error}}u&&(_.finalize(),M.push(_))}}else if((0,g.isArray)(e))try{for(var y=(0,a.__values)(e),m=y.next();!m.done;m=y.next()){S(m.value)}}catch(e){n={error:e}}finally{try{m&&!m.done&&(o=y.return)&&o.call(y)}finally{if(n)throw n.error}}else if((0,g.isPlainObject)(e))try{for(var w=(0,a.__values)((0,p.values)(e)),x=w.next();!x.done;x=w.next()){S(x.value)}}catch(e){l={error:e}}finally{try{x&&!x.done&&(i=w.return)&&i.call(w)}finally{if(l)throw l.error}}}try{for(var z=(0,a.__values)(d.values()),E=z.next();!E.done;E=z.next()){S(E.value.instance)}}catch(e){s={error:e}}finally{try{E&&!E.done&&(_=z.return)&&_.call(z)}finally{if(s)throw s.error}}try{for(var C=(0,a.__values)(M),D=C.next();!D.done;D=C.next()){(b=D.value).connect_signals()}}catch(e){u={error:e}}finally{try{D&&!D.done&&(f=C.return)&&f.call(C)}finally{if(u)throw u.error}}},e._event_for_attribute_change=function(e,t,r,n,o){if(n.get_model_by_id(e.id).property(t).syncable){var a={kind:"ModelChanged",model:{id:e.id},attr:t,new:r};return c.HasProps._json_record_references(n,r,o,{recursive:!0}),a}return null},e._events_to_sync_objects=function(t,r,n,o){var l,i,_,c,u,f,d=Object.keys(t.attributes),v=Object.keys(r.attributes),h=(0,y.difference)(d,v),p=(0,y.difference)(v,d),m=(0,y.intersection)(d,v),g=[];try{for(var x=(0,a.__values)(h),b=x.next();!b.done;b=x.next()){var k=b.value;s.logger.warn("Server sent key "+k+" but we don't seem to have it in our JSON")}}catch(e){l={error:e}}finally{try{b&&!b.done&&(i=x.return)&&i.call(x)}finally{if(l)throw l.error}}try{for(var M=(0,a.__values)(p),j=M.next();!j.done;j=M.next()){k=j.value;var S=r.attributes[k];g.push(e._event_for_attribute_change(t,k,S,n,o))}}catch(e){_={error:e}}finally{try{j&&!j.done&&(c=M.return)&&c.call(M)}finally{if(_)throw _.error}}try{for(var z=(0,a.__values)(m),E=z.next();!E.done;E=z.next()){k=E.value;var C=t.attributes[k];S=r.attributes[k];null==C&&null==S||(null==C||null==S?g.push(e._event_for_attribute_change(t,k,S,n,o)):"data"==k||(0,w.is_equal)(C,S)||g.push(e._event_for_attribute_change(t,k,S,n,o)))}}catch(e){u={error:e}}finally{try{E&&!E.done&&(f=z.return)&&f.call(z)}finally{if(u)throw u.error}}return g.filter((function(e){return null!=e}))},e._compute_patch_since_json=function(t,r){var n,o,l,i,s,_,c=r.to_json(!1);function f(e){var t,r,n=new Map;try{for(var o=(0,a.__values)(e.roots.references),l=o.next();!l.done;l=o.next()){var i=l.value;n.set(i.id,i)}}catch(e){t={error:e}}finally{try{l&&!l.done&&(r=o.return)&&r.call(o)}finally{if(t)throw t.error}}return n}var d=f(t),v=new Map,h=[];try{for(var p=(0,a.__values)(t.roots.root_ids),m=p.next();!m.done;m=p.next()){var w=m.value;v.set(w,d.get(w)),h.push(w)}}catch(e){n={error:e}}finally{try{m&&!m.done&&(o=p.return)&&o.call(p)}finally{if(n)throw n.error}}var g=f(c),x=new Map,b=[];try{for(var k=(0,a.__values)(c.roots.root_ids),M=k.next();!M.done;M=k.next()){w=M.value;x.set(w,g.get(w)),b.push(w)}}catch(e){l={error:e}}finally{try{M&&!M.done&&(i=k.return)&&i.call(k)}finally{if(l)throw l.error}}if(h.sort(),b.sort(),(0,y.difference)(h,b).length>0||(0,y.difference)(b,h).length>0)throw new Error("Not implemented: computing add/remove of document roots");var j=new Set,S=[];try{for(var z=(0,a.__values)(r._all_models.keys()),E=z.next();!E.done;E=z.next()){var C=E.value;if(d.has(C)){var D=e._events_to_sync_objects(d.get(C),g.get(C),r,j);S=S.concat(D)}}}catch(e){s={error:e}}finally{try{E&&!E.done&&(_=z.return)&&_.call(z)}finally{if(s)throw s.error}}var O=new u.Serializer({include_defaults:!1});return O.to_serializable((0,a.__spreadArray)([],(0,a.__read)(j),!1)),{references:(0,a.__spreadArray)([],(0,a.__read)(O.definitions),!1),events:S}},e.prototype.to_json_string=function(e){return void 0===e&&(e=!0),JSON.stringify(this.to_json(e))},e.prototype.to_json=function(e){void 0===e&&(e=!0);var t=new u.Serializer({include_defaults:e}),r=t.to_serializable(this._roots);return{version:i.version,title:this._title,roots:{root_ids:r.map((function(e){return e.id})),references:(0,a.__spreadArray)([],(0,a.__read)(t.definitions),!1)}}},e.from_json_string=function(t){var r=JSON.parse(t);return e.from_json(r)},e.from_json=function(t){var r,n;s.logger.debug("Creating Document from JSON");var o=t.version,_=-1!==o.indexOf("+")||-1!==o.indexOf("-"),c="Library versions: JS ("+i.version+") / Python ("+o+")";_||i.version.replace(/-(dev|rc)\./,"$1")==o?s.logger.debug(c):(s.logger.warn("JS/Python version mismatch"),s.logger.warn(c));var u=new l.ModelResolver;null!=t.defs&&(0,M.resolve_defs)(t.defs,u);var f=t.roots,d=f.root_ids,v=f.references,h=e._instantiate_references_json(v,new Map,u);e._initialize_references_json(v,new Map,h,new Map);var y=new e({resolver:u});try{for(var p=(0,a.__values)(d),m=p.next();!m.done;m=p.next()){var w=m.value,g=h.get(w);null!=g&&y.add_root(g)}}catch(e){r={error:e}}finally{try{m&&!m.done&&(n=p.return)&&n.call(p)}finally{if(r)throw r.error}}return y.set_title(t.title),y},e.prototype.replace_with_json=function(t){e.from_json(t).destructively_move(this)},e.prototype.create_json_patch_string=function(e){return JSON.stringify(this.create_json_patch(e))},e.prototype.create_json_patch=function(e){var t,r,n,o;try{for(var l=(0,a.__values)(e),i=l.next();!i.done;i=l.next()){if(i.value.document!=this)throw new Error("Cannot create a patch using events from a different document")}}catch(e){t={error:e}}finally{try{i&&!i.done&&(r=l.return)&&r.call(l)}finally{if(t)throw t.error}}var s=new u.Serializer,_=s.to_serializable(e);try{for(var c=(0,a.__values)(this._all_models.values()),f=c.next();!f.done;f=c.next()){var d=f.value;s.remove_def(d)}}catch(e){n={error:e}}finally{try{f&&!f.done&&(o=c.return)&&o.call(c)}finally{if(n)throw n.error}}return{events:_,references:(0,a.__spreadArray)([],(0,a.__read)(s.definitions),!1)}},e.prototype.apply_json_patch=function(t,r,n){var o,l,i,_,c,u,f;void 0===r&&(r=new Map);var d=t.references,v=t.events,h=e._instantiate_references_json(d,this._all_models,this._resolver);r instanceof Map||(r=new Map(r));try{for(var y=(0,a.__values)(v),p=y.next();!p.done;p=y.next()){switch((D=p.value).kind){case"RootAdded":case"RootRemoved":case"ModelChanged":var m=D.model.id,w=this._all_models.get(m);if(null!=w)h.set(m,w);else if(!h.has(m))throw s.logger.warn("Got an event for unknown model "+D.model+'"'),new Error("event model wasn't known")}}}catch(e){o={error:e}}finally{try{p&&!p.done&&(l=y.return)&&l.call(y)}finally{if(o)throw o.error}}var g=new Map(this._all_models),x=new Map;try{for(var k=(0,a.__values)(h),M=k.next();!M.done;M=k.next()){var j=(0,a.__read)(M.value,2),S=j[0],z=j[1];g.has(S)||x.set(S,z)}}catch(e){i={error:e}}finally{try{M&&!M.done&&(_=k.return)&&_.call(k)}finally{if(i)throw i.error}}e._initialize_references_json(d,g,x,r);try{for(var E=(0,a.__values)(v),C=E.next();!C.done;C=E.next()){var D;switch((D=C.value).kind){case"MessageSent":var O=D.msg_type,A=D.msg_data,R=void 0;if(void 0===A){if(1!=r.size)throw new Error("expected exactly one buffer");var N=(0,a.__read)(r,1);R=(0,a.__read)(N[0],2)[1]}else R=e._resolve_refs(A,g,x,r);this._trigger_on_message(O,R);break;case"ModelChanged":var J=D.model.id,P=this._all_models.get(J);if(null==P)throw new Error("Cannot apply patch to "+J+" which is not in the document");var L=D.attr;z=e._resolve_refs(D.new,g,x,r);P.setv(((f={})[L]=z,f),{setter_id:n});break;case"ColumnDataChanged":var T=D.column_source.id;if(null==(B=this._all_models.get(T)))throw new Error("Cannot stream to "+T+" which is not in the document");R=e._resolve_refs(D.new,new Map,new Map,r);if(null!=D.cols)for(var U in B.data)U in R||(R[U]=B.data[U]);B.setv({data:R},{setter_id:n,check_eq:!1});break;case"ColumnsStreamed":T=D.column_source.id;if(null==(B=this._all_models.get(T)))throw new Error("Cannot stream to "+T+" which is not in the document");if(!(B instanceof b.ColumnDataSource))throw new Error("Cannot stream to non-ColumnDataSource");R=D.data;var q=D.rollover;B.stream(R,q,n);break;case"ColumnsPatched":var B;T=D.column_source.id;if(null==(B=this._all_models.get(T)))throw new Error("Cannot patch "+T+" which is not in the document");if(!(B instanceof b.ColumnDataSource))throw new Error("Cannot patch non-ColumnDataSource");var F=D.patches;B.patch(F,n);break;case"RootAdded":var H=D.model.id,I=h.get(H);this.add_root(I,n);break;case"RootRemoved":H=D.model.id,I=h.get(H);this.remove_root(I,n);break;case"TitleChanged":this.set_title(D.title,n);break;default:throw new Error("Unknown patch event "+JSON.stringify(D))}}}catch(e){c={error:e}}finally{try{C&&!C.done&&(u=E.return)&&u.call(E)}finally{if(c)throw c.error}}},e}();r.Document=z,z.__name__="Document"},
function _(e,r,o,t,s){t();var n=e(1),i=e(125),l=e(128),d=e(129);o.overrides={};var a=new Map;o.Models=function(e){var r=o.Models.get(e);if(null!=r)return r;throw new Error("Model '"+e+"' does not exist. This could be due to a widget or a custom model not being registered before first usage.")},o.Models.get=function(e){var r;return null!==(r=o.overrides[e])&&void 0!==r?r:a.get(e)},o.Models.register=function(e,r){o.overrides[e]=r},o.Models.unregister=function(e){delete o.overrides[e]},o.Models.register_models=function(e,r,o){var t,s,u;if(void 0===r&&(r=!1),null!=e)try{for(var _=(0,n.__values)((0,i.isArray)(e)?e:(0,l.values)(e)),f=_.next();!f.done;f=_.next()){var v=f.value;if(u=v,(0,i.isObject)(u)&&u.prototype instanceof d.HasProps){var g=v.__qualified__;r||!a.has(g)?a.set(g,v):null!=o?o(g):console.warn("Model '"+g+"' was already registered")}}}catch(e){t={error:e}}finally{try{f&&!f.done&&(s=_.return)&&s.call(_)}finally{if(t)throw t.error}}},o.register_models=o.Models.register_models,o.Models.registered_names=function(){return(0,n.__spreadArray)([],(0,n.__read)(a.keys()),!1)};var u=function(){function e(){this._known_models=new Map}return e.prototype.get=function(e,r){var t,s=null!==(t=o.Models.get(e))&&void 0!==t?t:this._known_models.get(e);if(null!=s)return s;if(void 0!==r)return r;throw new Error("Model '"+e+"' does not exist. This could be due to a widget or a custom model not being registered before first usage.")},e.prototype.register=function(e){var r=e.__qualified__;null==this.get(r,null)?this._known_models.set(r,e):console.warn("Model '"+r+"' was already registered with this resolver")},e}();o.ModelResolver=u,u.__name__="ModelResolver";var _=(0,n.__importStar)(e(153));(0,o.register_models)(_);var f=(0,n.__importStar)(e(507));(0,o.register_models)(f)},
function _(n,r,t,e,i){e();
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
var o=n(126),u=Object.prototype.toString;function c(n){return!0===n||!1===n||"[object Boolean]"===u.call(n)}function f(n){return"[object Number]"===u.call(n)}function a(n){return"[object String]"===u.call(n)}function l(n){return"symbol"==typeof n}function s(n){var r=typeof n;return"function"===r||"object"===r&&!!n}function b(n){return s(n)&&void 0!==n[Symbol.iterator]}t.isBoolean=c,t.isNumber=f,t.isInteger=function(n){return f(n)&&Number.isInteger(n)},t.isString=a,t.isSymbol=l,t.isPrimitive=function(n){return null===n||c(n)||f(n)||a(n)||l(n)},t.isFunction=function(n){return"[object Function]"===u.call(n)},t.isArray=function(n){return Array.isArray(n)},t.isArrayOf=function(n,r){return(0,o.every)(n,r)},t.isArrayableOf=function(n,r){for(var t=0,e=n.length;t<e;t++)if(!r(n[t]))return!1;return!0},t.isTypedArray=function(n){return ArrayBuffer.isView(n)&&!(n instanceof DataView)},t.isObject=s,t.isPlainObject=function(n){return s(n)&&(null==n.constructor||n.constructor===Object)},t.isIterable=b,t.isArrayable=function(n){return b(n)&&"length"in n}},
function _(r,n,e,t,a){t();var i=r(1),o=r(117),u=r(127),f=r(116);
//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
//     Underscore may be freely distributed under the MIT license.
a("map",f.map),a("reduce",f.reduce),a("min",f.min),a("min_by",f.min_by),a("max",f.max),a("max_by",f.max_by),a("sum",f.sum),a("cumsum",f.cumsum),a("every",f.every),a("some",f.some),a("find",f.find),a("find_last",f.find_last),a("find_index",f.find_index),a("find_last_index",f.find_last_index),a("sorted_index",f.sorted_index),a("is_empty",f.is_empty);var l=Array.prototype.slice;function c(r){return l.call(r)}function v(r){return[].concat.apply([],(0,i.__spreadArray)([],(0,i.__read)(r),!1))}function y(r,n){return-1!==r.indexOf(n)}function d(r,n,e){void 0===e&&(e=1),(0,u.assert)(e>0,"'step' must be a positive number"),null==n&&(n=r,r=0);for(var t=r<=n?e:-e,a=(0,Math.max)((0,Math.ceil)((0,Math.abs)(n-r)/e),0),i=new Array(a),o=0;o<a;o++,r+=t)i[o]=r;return i}e.head=function(r){return r[0]},e.tail=function(r){return r[r.length-1]},e.last=function(r){return r[r.length-1]},e.copy=c,e.concat=v,e.includes=y,e.contains=y,e.nth=function(r,n){return r[n>=0?n:r.length+n]},e.zip=function(){for(var r=[],n=0;n<arguments.length;n++)r[n]=arguments[n];if(0==r.length)return[];for(var e=(0,f.min)(r.map((function(r){return r.length}))),t=r.length,a=new Array(e),i=0;i<e;i++){a[i]=new Array(t);for(var o=0;o<t;o++)a[i][o]=r[o][i]}return a},e.unzip=function(r){for(var n=r.length,e=(0,f.min)(r.map((function(r){return r.length}))),t=Array(e),a=0;a<e;a++)t[a]=new Array(n);for(var i=0;i<n;i++)for(a=0;a<e;a++)t[a][i]=r[i][a];return t},e.range=d,e.linspace=function(r,n,e){void 0===e&&(e=100);for(var t=(n-r)/(e-1),a=new Array(e),i=0;i<e;i++)a[i]=r+t*i;return a},e.transpose=function(r){for(var n=r.length,e=r[0].length,t=[],a=0;a<e;a++){t[a]=[];for(var i=0;i<n;i++)t[a][i]=r[i][a]}return t},e.argmin=function(r){return(0,f.min_by)(d(r.length),(function(n){return r[n]}))},e.argmax=function(r){return(0,f.max_by)(d(r.length),(function(n){return r[n]}))},e.sort_by=function(r,n){var e=r.map((function(r,e){return{value:r,index:e,key:n(r)}}));return e.sort((function(r,n){var e=r.key,t=n.key;if(e!==t){if(e>t||void 0===e)return 1;if(e<t||void 0===t)return-1}return r.index-n.index})),e.map((function(r){return r.value}))},e.uniq=function(r){var n,e,t=new Set;try{for(var a=(0,i.__values)(r),o=a.next();!o.done;o=a.next()){var u=o.value;t.add(u)}}catch(r){n={error:r}}finally{try{o&&!o.done&&(e=a.return)&&e.call(a)}finally{if(n)throw n.error}}return(0,i.__spreadArray)([],(0,i.__read)(t),!1)},e.uniq_by=function(r,n){var e,t,a=[],o=[];try{for(var u=(0,i.__values)(r),f=u.next();!f.done;f=u.next()){var l=f.value,c=n(l);y(o,c)||(o.push(c),a.push(l))}}catch(r){e={error:r}}finally{try{f&&!f.done&&(t=u.return)&&t.call(u)}finally{if(e)throw e.error}}return a},e.union=function(){for(var r,n,e,t,a=[],o=0;o<arguments.length;o++)a[o]=arguments[o];var u=new Set;try{for(var f=(0,i.__values)(a),l=f.next();!l.done;l=f.next()){var c=l.value;try{for(var v=(e=void 0,(0,i.__values)(c)),y=v.next();!y.done;y=v.next()){var d=y.value;u.add(d)}}catch(r){e={error:r}}finally{try{y&&!y.done&&(t=v.return)&&t.call(v)}finally{if(e)throw e.error}}}}catch(n){r={error:n}}finally{try{l&&!l.done&&(n=f.return)&&n.call(f)}finally{if(r)throw r.error}}return(0,i.__spreadArray)([],(0,i.__read)(u),!1)},e.intersection=function(r){for(var n,e,t,a,o=[],u=1;u<arguments.length;u++)o[u-1]=arguments[u];var f=[];try{r:for(var l=(0,i.__values)(r),c=l.next();!c.done;c=l.next()){var v=c.value;if(!y(f,v)){try{for(var d=(t=void 0,(0,i.__values)(o)),s=d.next();!s.done;s=d.next()){var _=s.value;if(!y(_,v))continue r}}catch(r){t={error:r}}finally{try{s&&!s.done&&(a=d.return)&&a.call(d)}finally{if(t)throw t.error}}f.push(v)}}}catch(r){n={error:r}}finally{try{c&&!c.done&&(e=l.return)&&e.call(l)}finally{if(n)throw n.error}}return f},e.difference=function(r){for(var n=[],e=1;e<arguments.length;e++)n[e-1]=arguments[e];var t=v(n);return r.filter((function(r){return!y(t,r)}))},e.remove_at=function(r,n){var e=c(r);return e.splice(n,1),e},e.remove_by=function(r,n){for(var e=0;e<r.length;)n(r[e])?r.splice(e,1):e++},e.shuffle=function(r){for(var n=r.length,e=new Array(n),t=0;t<n;t++){var a=(0,o.randomIn)(0,t);a!==t&&(e[t]=e[a]),e[a]=r[t]}return e},e.pairwise=function(r,n){for(var e=r.length,t=new Array(e-1),a=0;a<e-1;a++)t[a]=n(r[a],r[a+1]);return t},e.reversed=function(r){for(var n=r.length,e=new Array(n),t=0;t<n;t++)e[n-t-1]=r[t];return e},e.repeat=function(r,n){for(var e=new Array(n),t=0;t<n;t++)e[t]=r;return e}},
function _(r,n,e,t,o){t();var i=r(1),s=function(r){function n(){return null!==r&&r.apply(this,arguments)||this}return(0,i.__extends)(n,r),n}(Error);e.AssertionError=s,s.__name__="AssertionError",e.assert=function(r,n){if(!(!0===r||!1!==r&&r()))throw new s(null!=n?n:"Assertion failed")},e.unreachable=function(){throw new Error("unreachable code")}},
function _(e,r,t,n,a){n();var c=e(1),o=e(126),l=Object.prototype.hasOwnProperty;function i(e){return Object.keys(e).length}function u(e){return 0==i(e)}t.keys=Object.keys,t.values=Object.values,t.entries=Object.entries,t.extend=Object.assign,t.clone=function(e){return(0,c.__assign)({},e)},t.merge=function(e,r){var t,n,a=Object.create(Object.prototype),i=(0,o.concat)([Object.keys(e),Object.keys(r)]);try{for(var u=(0,c.__values)(i),s=u.next();!s.done;s=u.next()){var y=s.value,f=l.call(e,y)?e[y]:[],v=l.call(r,y)?r[y]:[];a[y]=(0,o.union)(f,v)}}catch(e){t={error:e}}finally{try{s&&!s.done&&(n=u.return)&&n.call(u)}finally{if(t)throw t.error}}return a},t.size=i,t.is_empty=u,t.isEmpty=u,t.to_object=function(e){var r,t,n={};try{for(var a=(0,c.__values)(e),o=a.next();!o.done;o=a.next()){var l=(0,c.__read)(o.value,2),i=l[0],u=l[1];n[i]=u}}catch(e){r={error:e}}finally{try{o&&!o.done&&(t=a.return)&&t.call(a)}finally{if(r)throw r.error}}return n}},
function _(e,r,t,n,a){n();var o,i=e(1),l=e(130),s=e(132),u=(0,i.__importStar)(e(133)),c=(0,i.__importStar)(e(136)),_=e(149),f=e(128),v=e(125),y=e(141),p=e(145),d=e(150),h=e(141),g=e(151),x=e(152),w=(0,i.__importStar)(e(136)),b=function(e){function r(r){var t,n,a,o;void 0===r&&(r={});var s=e.call(this)||this;s._subtype=void 0,s.document=null,s.destroyed=new l.Signal0(s,"destroyed"),s.change=new l.Signal0(s,"change"),s.transformchange=new l.Signal0(s,"transformchange"),s.exprchange=new l.Signal0(s,"exprchange"),s.properties={},s._watchers=new WeakMap,s._pending=!1,s._changing=!1;var v=r instanceof Map?r.get.bind(r):function(e){return r[e]};s.id=null!==(a=v("id"))&&void 0!==a?a:(0,_.uniqueId)();var y=function(e,r,t,n){var a=void 0;r instanceof u.PropertyAlias?Object.defineProperty(p.properties,e,{get:function(){return s.properties[r.attr]},configurable:!1,enumerable:!1}):(a=r instanceof c.Kind?new u.PrimitiveProperty(p,e,r,t,v(e),n):new r(p,e,c.Any,t,v(e),n),p.properties[e]=a)},p=this;try{for(var d=(0,i.__values)((0,f.entries)(s._props)),h=d.next();!h.done;h=d.next()){var g=(0,i.__read)(h.value,2),x=g[0],w=g[1];y(x,w.type,w.default_value,w.options)}}catch(e){t={error:e}}finally{try{h&&!h.done&&(n=d.return)&&n.call(d)}finally{if(t)throw t.error}}return null!==(o=v("__deferred__"))&&void 0!==o&&o||(s.finalize(),s.connect_signals()),s}return(0,i.__extends)(r,e),Object.defineProperty(r.prototype,"is_syncable",{get:function(){return!0},enumerable:!1,configurable:!0}),Object.defineProperty(r.prototype,"type",{get:function(){return this.constructor.__qualified__},set:function(e){console.warn("prototype.type = 'ModelName' is deprecated, use static __name__ instead"),this.constructor.__name__=e},enumerable:!1,configurable:!0}),Object.defineProperty(r,"__qualified__",{get:function(){var e=this.__module__,r=this.__name__;return null!=e?e+"."+r:r},enumerable:!1,configurable:!0}),Object.defineProperty(r,Symbol.toStringTag,{get:function(){return this.__name__},enumerable:!1,configurable:!0}),r._fix_default=function(e,r){if(void 0===e||(0,v.isFunction)(e))return e;if((0,v.isPrimitive)(e))return function(){return e};var t=new x.Cloner;return function(){return t.clone(e)}},r.define=function(e){var r,t,n=function(e,r){if(null!=a.prototype._props[e])throw new Error("attempted to redefine property '"+a.prototype.type+"."+e+"'");if(null!=a.prototype[e])throw new Error("attempted to redefine attribute '"+a.prototype.type+"."+e+"'");Object.defineProperty(a.prototype,e,{get:function(){return this.properties[e].get_value()},set:function(r){var t;return this.setv(((t={})[e]=r,t)),this},configurable:!1,enumerable:!0});var t=(0,i.__read)(r,3),n=t[0],o=t[1],l=t[2],s=void 0===l?{}:l,u={type:n,default_value:a._fix_default(o,e),options:s},c=(0,i.__assign)({},a.prototype._props);c[e]=u,a.prototype._props=c},a=this;try{for(var o=(0,i.__values)((0,f.entries)((0,v.isFunction)(e)?e(w):e)),l=o.next();!l.done;l=o.next()){var s=(0,i.__read)(l.value,2);n(s[0],s[1])}}catch(e){r={error:e}}finally{try{l&&!l.done&&(t=o.return)&&t.call(o)}finally{if(r)throw r.error}}},r.internal=function(e){var r,t,n={};try{for(var a=(0,i.__values)((0,f.entries)((0,v.isFunction)(e)?e(w):e)),o=a.next();!o.done;o=a.next()){var l=(0,i.__read)(o.value,2),s=l[0],u=l[1],c=(0,i.__read)(u,3),_=c[0],y=c[1],p=c[2],d=void 0===p?{}:p;n[s]=[_,y,(0,i.__assign)((0,i.__assign)({},d),{internal:!0})]}}catch(e){r={error:e}}finally{try{o&&!o.done&&(t=a.return)&&t.call(a)}finally{if(r)throw r.error}}this.define(n)},r.mixins=function(e){var r,t;function n(e,r){var t,n,a={};try{for(var o=(0,i.__values)((0,f.entries)(r)),l=o.next();!l.done;l=o.next()){var s=(0,i.__read)(l.value,2),u=s[0],c=s[1];a[e+u]=c}}catch(e){t={error:e}}finally{try{l&&!l.done&&(n=o.return)&&n.call(o)}finally{if(t)throw t.error}}return a}var a={},o=[];try{for(var l=(0,i.__values)((0,v.isArray)(e)?e:[e]),s=l.next();!s.done;s=l.next()){var u=s.value;if((0,v.isArray)(u)){var c=(0,i.__read)(u,2),_=c[0],y=c[1];(0,f.extend)(a,n(_,y)),o.push([_,y])}else{y=u;(0,f.extend)(a,y),o.push(["",y])}}}catch(e){r={error:e}}finally{try{s&&!s.done&&(t=l.return)&&t.call(l)}finally{if(r)throw r.error}}this.define(a),this.prototype._mixins=(0,i.__spreadArray)((0,i.__spreadArray)([],(0,i.__read)(this.prototype._mixins),!1),(0,i.__read)(o),!1)},r.override=function(e){var r,t;try{for(var n=(0,i.__values)((0,f.entries)(e)),a=n.next();!a.done;a=n.next()){var o=(0,i.__read)(a.value,2),l=o[0],s=o[1],u=this._fix_default(s,l),c=this.prototype._props[l];if(null==c)throw new Error("attempted to override nonexistent '"+this.prototype.type+"."+l+"'");var _=(0,i.__assign)({},this.prototype._props);_[l]=(0,i.__assign)((0,i.__assign)({},c),{default_value:u}),this.prototype._props=_}}catch(e){r={error:e}}finally{try{a&&!a.done&&(t=n.return)&&t.call(n)}finally{if(r)throw r.error}}},r.prototype.toString=function(){return this.type+"("+this.id+")"},r.prototype.property=function(e){var r=this.properties[e];if(null!=r)return r;throw new Error("unknown property "+this.type+"."+e)},Object.defineProperty(r.prototype,"attributes",{get:function(){var e,r,t={};try{for(var n=(0,i.__values)(this),a=n.next();!a.done;a=n.next()){var o=a.value;t[o.attr]=o.get_value()}}catch(r){e={error:r}}finally{try{a&&!a.done&&(r=n.return)&&r.call(n)}finally{if(e)throw e.error}}return t},enumerable:!1,configurable:!0}),r.prototype[x.clone]=function(e){var r,t,n=new Map;try{for(var a=(0,i.__values)(this),o=a.next();!o.done;o=a.next()){var l=o.value;l.dirty&&n.set(l.attr,e.clone(l.get_value()))}}catch(e){r={error:e}}finally{try{o&&!o.done&&(t=a.return)&&t.call(a)}finally{if(r)throw r.error}}return new this.constructor(n)},r.prototype[h.equals]=function(e,r){var t,n;try{for(var a=(0,i.__values)(this),o=a.next();!o.done;o=a.next()){var l=o.value,s=e.property(l.attr);if(!r.eq(l.get_value(),s.get_value()))return!1}}catch(e){t={error:e}}finally{try{o&&!o.done&&(n=a.return)&&n.call(a)}finally{if(t)throw t.error}}return!0},r.prototype[g.pretty]=function(e){var r,t,n=e.token,a=[];try{for(var o=(0,i.__values)(this),l=o.next();!l.done;l=o.next()){var s=l.value;if(s.dirty){var u=s.get_value();a.push(""+s.attr+n(":")+" "+e.to_string(u))}}}catch(e){r={error:e}}finally{try{l&&!l.done&&(t=o.return)&&t.call(o)}finally{if(r)throw r.error}}return""+this.constructor.__qualified__+n("(")+n("{")+a.join(n(",")+" ")+n("}")+n(")")},r.prototype[p.serialize]=function(e){var r,t,n=this.ref();e.add_ref(this,n);var a=this.struct();try{for(var o=(0,i.__values)(this),l=o.next();!l.done;l=o.next()){var s=l.value;s.syncable&&(e.include_defaults||s.dirty)&&(a.attributes[s.attr]=e.to_serializable(s.get_value()))}}catch(e){r={error:e}}finally{try{l&&!l.done&&(t=o.return)&&t.call(o)}finally{if(r)throw r.error}}return e.add_def(this,a),n},r.prototype.finalize=function(){var e,r,t=this;try{for(var n=(0,i.__values)(this),a=n.next();!a.done;a=n.next()){var o=a.value;if(o instanceof u.VectorSpec||o instanceof u.ScalarSpec){var l=o.get_value();if(null!=l){var s=l.transform,c=l.expr;null!=s&&this.connect(s.change,(function(){return t.transformchange.emit()})),null!=c&&this.connect(c.change,(function(){return t.exprchange.emit()}))}}}}catch(r){e={error:r}}finally{try{a&&!a.done&&(r=n.return)&&r.call(n)}finally{if(e)throw e.error}}this.initialize()},r.prototype.initialize=function(){},r.prototype.connect_signals=function(){},r.prototype.disconnect_signals=function(){l.Signal.disconnectReceiver(this)},r.prototype.destroy=function(){this.disconnect_signals(),this.destroyed.emit()},r.prototype.clone=function(){return(new x.Cloner).clone(this)},r.prototype.changed_for=function(e){var r=this._watchers.get(e);return this._watchers.set(e,!1),null==r||r},r.prototype._setv=function(e,r){var t,n,a,o,l=r.check_eq,s=[],u=this._changing;this._changing=!0;try{for(var c=(0,i.__values)(e),_=c.next();!_.done;_=c.next()){var f=(0,i.__read)(_.value,2),v=f[0],p=f[1];!1!==l&&(0,y.is_equal)(v.get_value(),p)||(v.set_value(p),s.push(v))}}catch(e){t={error:e}}finally{try{_&&!_.done&&(n=c.return)&&n.call(c)}finally{if(t)throw t.error}}s.length>0&&(this._watchers=new WeakMap,this._pending=!0);try{for(var d=(0,i.__values)(s),h=d.next();!h.done;h=d.next()){(v=h.value).change.emit()}}catch(e){a={error:e}}finally{try{h&&!h.done&&(o=d.return)&&o.call(d)}finally{if(a)throw a.error}}if(!u){if(!r.no_change)for(;this._pending;)this._pending=!1,this.change.emit();this._pending=!1,this._changing=!1}},r.prototype.setv=function(e,r){var t,n,a,o,l,s,u,c;void 0===r&&(r={});var _=(0,f.entries)(e);if(0!=_.length)if(!0!==r.silent){var v=new Map,y=new Map;try{for(var p=(0,i.__values)(_),d=p.next();!d.done;d=p.next()){var h=(0,i.__read)(d.value,2),g=(E=h[0],C=h[1],this.properties[E]);v.set(g,C),y.set(g,g.get_value())}}catch(e){a={error:e}}finally{try{d&&!d.done&&(o=p.return)&&o.call(p)}finally{if(a)throw a.error}}this._setv(v,r);var x=this.document;if(null!=x){var w=[];try{for(var b=(0,i.__values)(y),m=b.next();!m.done;m=b.next()){var S=(0,i.__read)(m.value,2);g=S[0],C=S[1];w.push([g,C,g.get_value()])}}catch(e){l={error:e}}finally{try{m&&!m.done&&(s=b.return)&&s.call(b)}finally{if(l)throw l.error}}try{for(var P=(0,i.__values)(w),j=P.next();!j.done;j=P.next()){var A=(0,i.__read)(j.value,3),M=A[1],O=A[2];if(this._needs_invalidate(M,O)){x._invalidate_all_models();break}}}catch(e){u={error:e}}finally{try{j&&!j.done&&(c=P.return)&&c.call(P)}finally{if(u)throw u.error}}this._push_changes(w,r)}}else{this._watchers=new WeakMap;try{for(var q=(0,i.__values)(_),k=q.next();!k.done;k=q.next()){var z=(0,i.__read)(k.value,2),E=z[0],C=z[1];this.properties[E].set_value(C)}}catch(e){t={error:e}}finally{try{k&&!k.done&&(n=q.return)&&n.call(q)}finally{if(t)throw t.error}}}},r.prototype.getv=function(e){return this.property(e).get_value()},r.prototype.ref=function(){return{id:this.id}},r.prototype.struct=function(){var e={type:this.type,id:this.id,attributes:{}};return null!=this._subtype&&(e.subtype=this._subtype),e},r.prototype.set_subtype=function(e){this._subtype=e},r.prototype[Symbol.iterator]=function(){return(0,i.__generator)(this,(function(e){switch(e.label){case 0:return[5,(0,i.__values)((0,f.values)(this.properties))];case 1:return e.sent(),[2]}}))},r.prototype.syncable_properties=function(){var e,r,t,n,a,o;return(0,i.__generator)(this,(function(l){switch(l.label){case 0:l.trys.push([0,5,6,7]),e=(0,i.__values)(this),r=e.next(),l.label=1;case 1:return r.done?[3,4]:(t=r.value).syncable?[4,t]:[3,3];case 2:l.sent(),l.label=3;case 3:return r=e.next(),[3,1];case 4:return[3,7];case 5:return n=l.sent(),a={error:n},[3,7];case 6:try{r&&!r.done&&(o=e.return)&&o.call(e)}finally{if(a)throw a.error}return[7];case 7:return[2]}}))},r.prototype.serializable_attributes=function(){var e,r,t={};try{for(var n=(0,i.__values)(this.syncable_properties()),a=n.next();!a.done;a=n.next()){var o=a.value;t[o.attr]=o.get_value()}}catch(r){e={error:r}}finally{try{a&&!a.done&&(r=n.return)&&r.call(n)}finally{if(e)throw e.error}}return t},r._json_record_references=function(e,t,n,a){var o,l,u,c,_=a.recursive;if((0,s.is_ref)(t)){var y=e.get_model_by_id(t.id);null==y||n.has(y)||r._value_record_references(y,n,{recursive:_})}else if((0,v.isArray)(t))try{for(var p=(0,i.__values)(t),d=p.next();!d.done;d=p.next()){var h=d.value;r._json_record_references(e,h,n,{recursive:_})}}catch(e){o={error:e}}finally{try{d&&!d.done&&(l=p.return)&&l.call(p)}finally{if(o)throw o.error}}else if((0,v.isPlainObject)(t))try{for(var g=(0,i.__values)((0,f.values)(t)),x=g.next();!x.done;x=g.next()){h=x.value;r._json_record_references(e,h,n,{recursive:_})}}catch(e){u={error:e}}finally{try{x&&!x.done&&(c=g.return)&&c.call(g)}finally{if(u)throw u.error}}},r._value_record_references=function(e,t,n){var a,o,l,s,u,c,_=n.recursive;if(e instanceof r){if(!t.has(e)&&(t.add(e),_))try{for(var y=(0,i.__values)(e.syncable_properties()),p=y.next();!p.done;p=y.next()){var d=p.value.get_value();r._value_record_references(d,t,{recursive:_})}}catch(e){a={error:e}}finally{try{p&&!p.done&&(o=y.return)&&o.call(y)}finally{if(a)throw a.error}}}else if((0,v.isArray)(e))try{for(var h=(0,i.__values)(e),g=h.next();!g.done;g=h.next()){var x=g.value;r._value_record_references(x,t,{recursive:_})}}catch(e){l={error:e}}finally{try{g&&!g.done&&(s=h.return)&&s.call(h)}finally{if(l)throw l.error}}else if((0,v.isPlainObject)(e))try{for(var w=(0,i.__values)((0,f.values)(e)),b=w.next();!b.done;b=w.next()){x=b.value;r._value_record_references(x,t,{recursive:_})}}catch(e){u={error:e}}finally{try{b&&!b.done&&(c=w.return)&&c.call(w)}finally{if(u)throw u.error}}},r.prototype.references=function(){var e=new Set;return r._value_record_references(this,e,{recursive:!0}),e},r.prototype._doc_attached=function(){},r.prototype._doc_detached=function(){},r.prototype.attach_document=function(e){if(null!=this.document&&this.document!=e)throw new Error("models must be owned by only a single document");this.document=e,this._doc_attached()},r.prototype.detach_document=function(){this._doc_detached(),this.document=null},r.prototype._needs_invalidate=function(e,t){var n,a,o,l,s=new Set;r._value_record_references(t,s,{recursive:!1});var u=new Set;r._value_record_references(e,u,{recursive:!1});try{for(var c=(0,i.__values)(s),_=c.next();!_.done;_=c.next()){var f=_.value;if(!u.has(f))return!0}}catch(e){n={error:e}}finally{try{_&&!_.done&&(a=c.return)&&a.call(c)}finally{if(n)throw n.error}}try{for(var v=(0,i.__values)(u),y=v.next();!y.done;y=v.next()){var p=y.value;if(!s.has(p))return!0}}catch(e){o={error:e}}finally{try{y&&!y.done&&(l=v.return)&&l.call(v)}finally{if(o)throw o.error}}return!1},r.prototype._push_changes=function(e,r){var t,n;if(void 0===r&&(r={}),this.is_syncable){var a=this.document;if(null!=a){var o=r.setter_id,l=[];try{for(var s=(0,i.__values)(e),u=s.next();!u.done;u=s.next()){var c=(0,i.__read)(u.value,3),_=c[0],f=c[1],v=c[2];_.syncable&&l.push(new d.ModelChangedEvent(a,this,_.attr,f,v,o))}}catch(e){t={error:e}}finally{try{u&&!u.done&&(n=s.return)&&n.call(s)}finally{if(t)throw t.error}}if(0!=l.length){var y=void 0;1==l.length?y=(0,i.__read)(l,1)[0]:y=new d.DocumentEventBatch(a,l,o),a._trigger_on_change(y)}}}},r.prototype.on_change=function(e,r){var t,n;try{for(var a=(0,i.__values)((0,v.isArray)(e)?e:[e]),o=a.next();!o.done;o=a.next()){var l=o.value;this.connect(l.change,r)}}catch(e){t={error:e}}finally{try{o&&!o.done&&(n=a.return)&&n.call(a)}finally{if(t)throw t.error}}},r}((0,l.Signalable)());t.HasProps=b,(o=b).prototype._props={},o.prototype._mixins=[]},
function _(n,e,t,r,l){r();var i=n(1),a=n(131),o=n(126),u=function(){function n(n,e){this.sender=n,this.name=e}return n.prototype.connect=function(n,e){void 0===e&&(e=null),s.has(this.sender)||s.set(this.sender,[]);var t=s.get(this.sender);if(null!=v(t,this,n,e))return!1;var r=null!=e?e:n;f.has(r)||f.set(r,[]);var l=f.get(r),i={signal:this,slot:n,context:e};return t.push(i),l.push(i),!0},n.prototype.disconnect=function(n,e){void 0===e&&(e=null);var t=s.get(this.sender);if(null==t||0===t.length)return!1;var r=v(t,this,n,e);if(null==r)return!1;var l=null!=e?e:n,i=f.get(l);return r.signal=null,h(t),h(i),!0},n.prototype.emit=function(n){var e,t,r,l=null!==(r=s.get(this.sender))&&void 0!==r?r:[];try{for(var a=(0,i.__values)(l),o=a.next();!o.done;o=a.next()){var u=o.value,c=u.signal,f=u.slot,v=u.context;c===this&&f.call(v,n,this.sender)}}catch(n){e={error:n}}finally{try{o&&!o.done&&(t=a.return)&&t.call(a)}finally{if(e)throw e.error}}},n}();t.Signal=u,u.__name__="Signal";var c=function(n){function e(){return null!==n&&n.apply(this,arguments)||this}return(0,i.__extends)(e,n),e.prototype.emit=function(){n.prototype.emit.call(this,void 0)},e}(u);t.Signal0=c,c.__name__="Signal0",function(n){function e(n,e){var t,r,l=s.get(n);if(null!=l&&0!==l.length){var a=f.get(e);if(null!=a&&0!==a.length){try{for(var o=(0,i.__values)(a),u=o.next();!u.done;u=o.next()){var c=u.value;if(null==c.signal)return;c.signal.sender===n&&(c.signal=null)}}catch(n){t={error:n}}finally{try{u&&!u.done&&(r=o.return)&&r.call(o)}finally{if(t)throw t.error}}h(l),h(a)}}}function t(n){var e,t,r,l=s.get(n);if(null!=l&&0!==l.length){try{for(var a=(0,i.__values)(l),o=a.next();!o.done;o=a.next()){var u=o.value;if(null==u.signal)return;var c=null!==(r=u.context)&&void 0!==r?r:u.slot;u.signal=null,h(f.get(c))}}catch(n){e={error:n}}finally{try{o&&!o.done&&(t=a.return)&&t.call(a)}finally{if(e)throw e.error}}h(l)}}function r(n,e,t){var r,l,a=f.get(n);if(null!=a&&0!==a.length){try{for(var o=(0,i.__values)(a),u=o.next();!u.done;u=o.next()){var c=u.value;if(null==c.signal)return;if(null==e||c.slot==e){var v=c.signal.sender;null!=t&&t.has(v)||(c.signal=null,h(s.get(v)))}}}catch(n){r={error:n}}finally{try{u&&!u.done&&(l=o.return)&&l.call(o)}finally{if(r)throw r.error}}h(a)}}function l(n){var e,t,r,l,a=s.get(n);if(null!=a&&0!==a.length){try{for(var o=(0,i.__values)(a),u=o.next();!u.done;u=o.next()){u.value.signal=null}}catch(n){e={error:n}}finally{try{u&&!u.done&&(t=o.return)&&t.call(o)}finally{if(e)throw e.error}}h(a)}var c=f.get(n);if(null!=c&&0!==c.length){try{for(var v=(0,i.__values)(c),d=v.next();!d.done;d=v.next()){d.value.signal=null}}catch(n){r={error:n}}finally{try{d&&!d.done&&(l=v.return)&&l.call(v)}finally{if(r)throw r.error}}h(c)}}n.disconnect_between=e,n.disconnect_sender=t,n.disconnect_receiver=r,n.disconnect_all=l,n.disconnectBetween=e,n.disconnectSender=t,n.disconnectReceiver=r,n.disconnectAll=l}(u||(t.Signal=u={})),t.Signalable=function(){return function(){function n(){}return n.prototype.connect=function(n,e){return n.connect(e,this)},n.prototype.disconnect=function(n,e){return n.disconnect(e,this)},n}()};var s=new WeakMap,f=new WeakMap;function v(n,e,t,r){return(0,o.find)(n,(function(n){return n.signal===e&&n.slot===t&&n.context===r}))}var d=new Set;function h(n){var e=this;0===d.size&&(0,i.__awaiter)(e,void 0,void 0,(function(){return(0,i.__generator)(this,(function(n){switch(n.label){case 0:return[4,(0,a.defer)()];case 1:return n.sent(),function(){var n,e;try{for(var t=(0,i.__values)(d),r=t.next();!r.done;r=t.next()){var l=r.value;(0,o.remove_by)(l,(function(n){return null==n.signal}))}}catch(e){n={error:e}}finally{try{r&&!r.done&&(e=t.return)&&e.call(t)}finally{if(n)throw n.error}}d.clear()}(),[2]}}))})),d.add(n)}},
function _(e,n,t,r,a){r();var o=new MessageChannel,i=new Map;o.port1.onmessage=function(e){var n=e.data,t=i.get(n);if(null!=t)try{t()}finally{i.delete(n)}};var s=1;t.defer=function(){return new Promise((function(e){var n=s++;i.set(n,e),o.port2.postMessage(n)}))},t.wait=function(e){return new Promise((function(n){return setTimeout(n,e)}))}},
function _(n,i,r,e,t){e();var f=n(125),u=n(128);r.is_ref=function(n){if((0,f.isPlainObject)(n)){var i=(0,u.keys)(n);return 1==i.length&&"id"==i[0]}return!1}},
function _(e,n,t,r,i){r(),t.YCoordinateSeqSeqSeqSpec=t.XCoordinateSeqSeqSeqSpec=t.YCoordinateSeqSpec=t.XCoordinateSeqSpec=t.YCoordinateSpec=t.XCoordinateSpec=t.CoordinateSeqSeqSeqSpec=t.CoordinateSeqSpec=t.CoordinateSpec=t.BaseCoordinateSpec=t.NumberUnitsSpec=t.UnitsSpec=t.DataSpec=t.VectorSpec=t.TextBaselineScalar=t.TextAlignScalar=t.FontStyleScalar=t.FontSizeScalar=t.FontScalar=t.LineDashScalar=t.LineCapScalar=t.LineJoinScalar=t.ArrayScalar=t.NullStringScalar=t.StringScalar=t.NumberScalar=t.ColorScalar=t.AnyScalar=t.ScalarSpec=t.VerticalAlign=t.UpdateMode=t.TooltipAttachment=t.TickLabelOrientation=t.TextureRepetition=t.TextBaseline=t.TextAlign=t.TapBehavior=t.StepMode=t.StartEnd=t.SpatialUnits=t.Sort=t.SizingMode=t.Side=t.RoundingFunction=t.ResetPolicy=t.RenderMode=t.RenderLevel=t.RadiusDimension=t.PointPolicy=t.Place=void 0,t.TextBaselineSpec=t.TextAlignSpec=t.FontStyleSpec=t.FontSizeSpec=t.FontSpec=t.LineDashSpec=t.LineCapSpec=t.LineJoinSpec=t.MarkerSpec=t.ArraySpec=t.NullStringSpec=t.StringSpec=t.AnySpec=t.NDArraySpec=t.ColorSpec=t.ScreenSizeSpec=t.NumberSpec=t.IntSpec=t.BooleanSpec=t.NullDistanceSpec=t.DistanceSpec=t.AngleSpec=void 0;var a=e(1),o=e(130),u=e(134),l=(0,a.__importStar)(e(135)),c=e(139),_=e(126),p=e(116),s=e(117),f=e(137),d=e(142),y=e(125),h=e(143),S=e(144),v=e(148);function m(e){try{return JSON.stringify(e)}catch(n){return e.toString()}}function g(e){return(0,y.isPlainObject)(e)&&(void 0===e.value?0:1)+(void 0===e.field?0:1)+(void 0===e.expr?0:1)==1}i("Uniform",v.Uniform),i("UniformScalar",v.UniformScalar),i("UniformVector",v.UniformVector),t.isSpec=g;var x=function(){function e(e,n,t,r,i,a){var u,l;if(void 0===a&&(a={}),this.obj=e,this.attr=n,this.kind=t,this.default_value=r,this._dirty=!1,this.change=new o.Signal0(this.obj,"change"),this.internal=null!==(u=a.internal)&&void 0!==u&&u,this.convert=a.convert,this.on_update=a.on_update,void 0!==i)l=i,this._dirty=!0;else{var c=this._default_override();if(void 0!==c)l=c;else{if(void 0===r)return void(this.spec={value:null});l=r(e)}}this._update(l)}return Object.defineProperty(e.prototype,"is_value",{get:function(){return void 0!==this.spec.value},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"syncable",{get:function(){return!this.internal},enumerable:!1,configurable:!0}),e.prototype.get_value=function(){return this.spec.value},e.prototype.set_value=function(e){this._update(e),this._dirty=!0},e.prototype._default_override=function(){},Object.defineProperty(e.prototype,"dirty",{get:function(){return this._dirty},enumerable:!1,configurable:!0}),e.prototype._update=function(e){var n;if(this.validate(e),null!=this.convert){var t=this.convert(e);void 0!==t&&(e=t)}this.spec={value:e},null===(n=this.on_update)||void 0===n||n.call(this,e,this.obj)},e.prototype.toString=function(){return"Prop("+this.obj+"."+this.attr+", spec: "+m(this.spec)+")"},e.prototype.normalize=function(e){return e},e.prototype.validate=function(e){if(!this.valid(e))throw new Error(this.obj+"."+this.attr+" given invalid value: "+m(e))},e.prototype.valid=function(e){return this.kind.valid(e)},e.prototype._value=function(e){if(void 0===e&&(e=!0),!this.is_value)throw new Error("attempted to retrieve property value for property without value specification");var n=this.normalize([this.spec.value])[0];return null!=this.spec.transform&&e&&(n=this.spec.transform.compute(n)),n},e}();t.Property=x,x.__name__="Property";var A=function(e){this.attr=e};t.PropertyAlias=A,A.__name__="PropertyAlias",t.Alias=function(e){return new A(e)};var b=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(x);t.PrimitiveProperty=b,b.__name__="PrimitiveProperty";var C=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(x);t.Any=C,C.__name__="Any";var P=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n.prototype.valid=function(e){return(0,y.isArray)(e)||(0,y.isTypedArray)(e)},n}(x);t.Array=P,P.__name__="Array";var T=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n.prototype.valid=function(e){return(0,y.isBoolean)(e)},n}(x);t.Boolean=T,T.__name__="Boolean";var L=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n.prototype.valid=function(e){return(0,f.is_Color)(e)},n}(x);t.Color=L,L.__name__="Color";var w=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(x);t.Instance=w,w.__name__="Instance";var q=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n.prototype.valid=function(e){return(0,y.isNumber)(e)},n}(x);t.Number=q,q.__name__="Number";var N=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n.prototype.valid=function(e){return(0,y.isNumber)(e)&&(0|e)==e},n}(q);t.Int=N,N.__name__="Int";var z=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(q);t.Angle=z,z.__name__="Angle";var B=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n.prototype.valid=function(e){return(0,y.isNumber)(e)&&0<=e&&e<=1},n}(q);t.Percent=B,B.__name__="Percent";var F=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n.prototype.valid=function(e){return(0,y.isString)(e)},n}(x);t.String=F,F.__name__="String";var D=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n.prototype.valid=function(e){return null===e||(0,y.isString)(e)},n}(x);t.NullString=D,D.__name__="NullString";var U=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(F);t.FontSize=U,U.__name__="FontSize";var M=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n.prototype._default_override=function(){return h.settings.dev?"Bokeh":void 0},n}(F);t.Font=M,M.__name__="Font";var O=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n.prototype.valid=function(e){return(0,y.isString)(e)&&(0,_.includes)(this.enum_values,e)},n}(x);function R(e){return function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return(0,a.__extends)(t,n),Object.defineProperty(t.prototype,"enum_values",{get:function(){return(0,a.__spreadArray)([],(0,a.__read)(e),!1)},enumerable:!1,configurable:!0}),t}(O)}t.EnumProperty=O,O.__name__="EnumProperty",t.Enum=R;var k=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),Object.defineProperty(n.prototype,"enum_values",{get:function(){return(0,a.__spreadArray)([],(0,a.__read)(l.Direction),!1)},enumerable:!1,configurable:!0}),n.prototype.normalize=function(e){for(var n=new Uint8Array(e.length),t=0;t<e.length;t++)switch(e[t]){case"clock":n[t]=0;break;case"anticlock":n[t]=1}return n},n}(O);t.Direction=k,k.__name__="Direction",t.Anchor=R(l.Anchor),t.AngleUnits=R(l.AngleUnits),t.BoxOrigin=R(l.BoxOrigin),t.ButtonType=R(l.ButtonType),t.CalendarPosition=R(l.CalendarPosition),t.Dimension=R(l.Dimension),t.Dimensions=R(l.Dimensions),t.Distribution=R(l.Distribution),t.FontStyle=R(l.FontStyle),t.HatchPatternType=R(l.HatchPatternType),t.HTTPMethod=R(l.HTTPMethod),t.HexTileOrientation=R(l.HexTileOrientation),t.HoverMode=R(l.HoverMode),t.LatLon=R(l.LatLon),t.LegendClickPolicy=R(l.LegendClickPolicy),t.LegendLocation=R(l.LegendLocation),t.LineCap=R(l.LineCap),t.LineJoin=R(l.LineJoin),t.LinePolicy=R(l.LinePolicy),t.Location=R(l.Location),t.Logo=R(l.Logo),t.MarkerType=R(l.MarkerType),t.MutedPolicy=R(l.MutedPolicy),t.Orientation=R(l.Orientation),t.OutputBackend=R(l.OutputBackend),t.PaddingUnits=R(l.PaddingUnits),t.Place=R(l.Place),t.PointPolicy=R(l.PointPolicy),t.RadiusDimension=R(l.RadiusDimension),t.RenderLevel=R(l.RenderLevel),t.RenderMode=R(l.RenderMode),t.ResetPolicy=R(l.ResetPolicy),t.RoundingFunction=R(l.RoundingFunction),t.Side=R(l.Side),t.SizingMode=R(l.SizingMode),t.Sort=R(l.Sort),t.SpatialUnits=R(l.SpatialUnits),t.StartEnd=R(l.StartEnd),t.StepMode=R(l.StepMode),t.TapBehavior=R(l.TapBehavior),t.TextAlign=R(l.TextAlign),t.TextBaseline=R(l.TextBaseline),t.TextureRepetition=R(l.TextureRepetition),t.TickLabelOrientation=R(l.TickLabelOrientation),t.TooltipAttachment=R(l.TooltipAttachment),t.UpdateMode=R(l.UpdateMode),t.VerticalAlign=R(l.VerticalAlign);var j=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n.prototype.get_value=function(){var e=this.spec,n=e.value,t=e.expr,r=e.transform;return null!=t||null!=r?this.spec:n},n.prototype._update=function(e){g(e)?this.spec=e:this.spec={value:e},null!=this.spec.value&&this.validate(this.spec.value)},n.prototype.materialize=function(e){return e},n.prototype.scalar=function(e,n){return new v.UniformScalar(e,n)},n.prototype.uniform=function(e){var n,t=this.spec,r=t.expr,i=t.value,a=t.transform,o=null!==(n=e.get_length())&&void 0!==n?n:1;if(null!=r){var u=r.compute(e);return null!=a&&(u=a.compute(u)),u=this.materialize(u),this.scalar(u,o)}u=i;return null!=a&&(u=a.compute(u)),u=this.materialize(u),this.scalar(u,o)},n}(x);t.ScalarSpec=j,j.__name__="ScalarSpec";var E=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(j);t.AnyScalar=E,E.__name__="AnyScalar";var V=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(j);t.ColorScalar=V,V.__name__="ColorScalar";var I=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(j);t.NumberScalar=I,I.__name__="NumberScalar";var J=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(j);t.StringScalar=J,J.__name__="StringScalar";var X=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(j);t.NullStringScalar=X,X.__name__="NullStringScalar";var Y=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(j);t.ArrayScalar=Y,Y.__name__="ArrayScalar";var H=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(j);t.LineJoinScalar=H,H.__name__="LineJoinScalar";var G=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(j);t.LineCapScalar=G,G.__name__="LineCapScalar";var K=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(j);t.LineDashScalar=K,K.__name__="LineDashScalar";var Q=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n.prototype._default_override=function(){return h.settings.dev?"Bokeh":void 0},n}(j);t.FontScalar=Q,Q.__name__="FontScalar";var W=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(j);t.FontSizeScalar=W,W.__name__="FontSizeScalar";var Z=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(j);t.FontStyleScalar=Z,Z.__name__="FontStyleScalar";var $=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(j);t.TextAlignScalar=$,$.__name__="TextAlignScalar";var ee=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(j);t.TextBaselineScalar=ee,ee.__name__="TextBaselineScalar";var ne=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n.prototype.get_value=function(){return null===this.spec.value?null:this.spec},n.prototype._update=function(e){g(e)?this.spec=e:this.spec={value:e},null!=this.spec.value&&this.validate(this.spec.value)},n.prototype.materialize=function(e){return e},n.prototype.v_materialize=function(e){return e},n.prototype.scalar=function(e,n){return new v.UniformScalar(e,n)},n.prototype.vector=function(e){return new v.UniformVector(e)},n.prototype.uniform=function(e){var n,t=this.spec,r=t.field,i=t.expr,a=t.value,o=t.transform,l=null!==(n=e.get_length())&&void 0!==n?n:1;if(null!=r)return null!=(c=e.get_column(r))?(null!=o&&(c=o.v_compute(c)),c=this.v_materialize(c),this.vector(c)):(u.logger.warn("attempted to retrieve property array for nonexistent field '"+r+"'"),this.scalar(null,l));if(null!=i){var c=i.v_compute(e);return null!=o&&(c=o.v_compute(c)),c=this.v_materialize(c),this.vector(c)}var _=a;return null!=o&&(_=o.compute(_)),_=this.materialize(_),this.scalar(_,l)},n.prototype.array=function(e){var n,t,r=null!==(n=e.get_length())&&void 0!==n?n:1;if(null!=this.spec.field){var i=e.get_column(this.spec.field);if(null!=i)t=this.normalize(i);else{u.logger.warn("attempted to retrieve property array for nonexistent field '"+this.spec.field+"'");var a=new Float64Array(r);a.fill(NaN),t=a}}else if(null!=this.spec.expr)t=this.normalize(this.spec.expr.v_compute(e));else{var o=this._value(!1);if((0,y.isNumber)(o)){var l=new Float64Array(r);l.fill(o),t=l}else t=(0,_.repeat)(o,r)}return null!=this.spec.transform&&(t=this.spec.transform.v_compute(t)),t},n}(x);t.VectorSpec=ne,ne.__name__="VectorSpec";var te=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(ne);t.DataSpec=te,te.__name__="DataSpec";var re=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n.prototype._update=function(n){e.prototype._update.call(this,n);var t=this.spec.units;if(null!=t&&!(0,_.includes)(this.valid_units,t))throw new Error("units must be one of "+this.valid_units.join(", ")+"; got: "+t)},Object.defineProperty(n.prototype,"units",{get:function(){var e;return null!==(e=this.spec.units)&&void 0!==e?e:this.default_units},set:function(e){e!=this.default_units?this.spec.units=e:delete this.spec.units},enumerable:!1,configurable:!0}),n}(ne);t.UnitsSpec=re,re.__name__="UnitsSpec";var ie=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n.prototype.array=function(n){return new Float64Array(e.prototype.array.call(this,n))},n}(re);t.NumberUnitsSpec=ie,ie.__name__="NumberUnitsSpec";var ae=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(te);t.BaseCoordinateSpec=ae,ae.__name__="BaseCoordinateSpec";var oe=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(ae);t.CoordinateSpec=oe,oe.__name__="CoordinateSpec";var ue=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(ae);t.CoordinateSeqSpec=ue,ue.__name__="CoordinateSeqSpec";var le=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(ae);t.CoordinateSeqSeqSeqSpec=le,le.__name__="CoordinateSeqSeqSeqSpec";var ce=function(e){function n(){var n=e.apply(this,(0,a.__spreadArray)([],(0,a.__read)(arguments),!1))||this;return n.dimension="x",n}return(0,a.__extends)(n,e),n}(oe);t.XCoordinateSpec=ce,ce.__name__="XCoordinateSpec";var _e=function(e){function n(){var n=e.apply(this,(0,a.__spreadArray)([],(0,a.__read)(arguments),!1))||this;return n.dimension="y",n}return(0,a.__extends)(n,e),n}(oe);t.YCoordinateSpec=_e,_e.__name__="YCoordinateSpec";var pe=function(e){function n(){var n=e.apply(this,(0,a.__spreadArray)([],(0,a.__read)(arguments),!1))||this;return n.dimension="x",n}return(0,a.__extends)(n,e),n}(ue);t.XCoordinateSeqSpec=pe,pe.__name__="XCoordinateSeqSpec";var se=function(e){function n(){var n=e.apply(this,(0,a.__spreadArray)([],(0,a.__read)(arguments),!1))||this;return n.dimension="y",n}return(0,a.__extends)(n,e),n}(ue);t.YCoordinateSeqSpec=se,se.__name__="YCoordinateSeqSpec";var fe=function(e){function n(){var n=e.apply(this,(0,a.__spreadArray)([],(0,a.__read)(arguments),!1))||this;return n.dimension="x",n}return(0,a.__extends)(n,e),n}(le);t.XCoordinateSeqSeqSeqSpec=fe,fe.__name__="XCoordinateSeqSeqSeqSpec";var de=function(e){function n(){var n=e.apply(this,(0,a.__spreadArray)([],(0,a.__read)(arguments),!1))||this;return n.dimension="y",n}return(0,a.__extends)(n,e),n}(le);t.YCoordinateSeqSeqSeqSpec=de,de.__name__="YCoordinateSeqSeqSeqSpec";var ye=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),Object.defineProperty(n.prototype,"default_units",{get:function(){return"rad"},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"valid_units",{get:function(){return(0,a.__spreadArray)([],(0,a.__read)(l.AngleUnits),!1)},enumerable:!1,configurable:!0}),n.prototype.materialize=function(e){return e*-(0,s.to_radians_coeff)(this.units)},n.prototype.v_materialize=function(e){var n=-(0,s.to_radians_coeff)(this.units),t=new Float32Array(e.length);return(0,p.mul)(e,n,t),t},n.prototype.array=function(e){throw new Error("not supported")},n}(ie);t.AngleSpec=ye,ye.__name__="AngleSpec";var he=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),Object.defineProperty(n.prototype,"default_units",{get:function(){return"data"},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"valid_units",{get:function(){return(0,a.__spreadArray)([],(0,a.__read)(l.SpatialUnits),!1)},enumerable:!1,configurable:!0}),n}(ie);t.DistanceSpec=he,he.__name__="DistanceSpec";var Se=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n.prototype.materialize=function(e){return null!=e?e:NaN},n}(he);t.NullDistanceSpec=Se,Se.__name__="NullDistanceSpec";var ve=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n.prototype.v_materialize=function(e){return new Uint8Array(e)},n.prototype.array=function(n){return new Uint8Array(e.prototype.array.call(this,n))},n}(te);t.BooleanSpec=ve,ve.__name__="BooleanSpec";var me=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n.prototype.v_materialize=function(e){return(0,y.isTypedArray)(e)?e:new Int32Array(e)},n.prototype.array=function(n){return new Int32Array(e.prototype.array.call(this,n))},n}(te);t.IntSpec=me,me.__name__="IntSpec";var ge=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n.prototype.v_materialize=function(e){return(0,y.isTypedArray)(e)?e:new Float64Array(e)},n.prototype.array=function(n){return new Float64Array(e.prototype.array.call(this,n))},n}(te);t.NumberSpec=ge,ge.__name__="NumberSpec";var xe=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n.prototype.valid=function(e){return(0,y.isNumber)(e)&&e>=0},n}(ge);t.ScreenSizeSpec=xe,xe.__name__="ScreenSizeSpec";var Ae=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n.prototype.materialize=function(e){return(0,f.encode_rgba)((0,f.color2rgba)(e))},n.prototype.v_materialize=function(e){var n,t,r,i;if(!(0,S.is_NDArray)(e)){v=e.length,m=new c.RGBAArray(4*v),g=0;try{for(var o=(0,a.__values)(e),u=o.next();!u.done;u=o.next()){var l=u.value,_=(0,a.__read)((0,f.color2rgba)(l),4),p=_[0],s=_[1],y=_[2],h=_[3];m[g++]=p,m[g++]=s,m[g++]=y,m[g++]=h}}catch(e){r={error:e}}finally{try{u&&!u.done&&(i=o.return)&&i.call(o)}finally{if(r)throw r.error}}return new c.ColorArray(m.buffer)}if("uint32"==e.dtype&&1==e.dimension)return(0,d.to_big_endian)(e);if("uint8"==e.dtype&&1==e.dimension){var v=(0,a.__read)(e.shape,1)[0],m=new c.RGBAArray(4*v),g=0;try{for(var x=(0,a.__values)(e),A=x.next();!A.done;A=x.next()){var b=A.value;m[g++]=b,m[g++]=b,m[g++]=b,m[g++]=255}}catch(e){n={error:e}}finally{try{A&&!A.done&&(t=x.return)&&t.call(x)}finally{if(n)throw n.error}}return new c.ColorArray(m.buffer)}if("uint8"==e.dtype&&2==e.dimension){var C=(0,a.__read)(e.shape,2),v=C[0];if(4==(T=C[1]))return new c.ColorArray(e.buffer);if(3==T){for(var m=new c.RGBAArray(4*v),P=0,g=0;P<T*v;)m[g++]=e[P++],m[g++]=e[P++],m[g++]=e[P++],m[g++]=255;return new c.ColorArray(m.buffer)}}else if(("float32"==e.dtype||"float64"==e.dtype)&&2==e.dimension){var T,L=(0,a.__read)(e.shape,2);v=L[0];if(3==(T=L[1])||4==T){for(m=new c.RGBAArray(4*v),P=0,g=0;P<T*v;)m[g++]=255*e[P++],m[g++]=255*e[P++],m[g++]=255*e[P++],m[g++]=255*(3==T?1:e[P++]);return new c.ColorArray(m.buffer)}}throw new Error("invalid color array")},n.prototype.vector=function(e){return new v.ColorUniformVector(e)},n}(te);t.ColorSpec=Ae,Ae.__name__="ColorSpec";var be=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(te);t.NDArraySpec=be,be.__name__="NDArraySpec";var Ce=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(te);t.AnySpec=Ce,Ce.__name__="AnySpec";var Pe=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(te);t.StringSpec=Pe,Pe.__name__="StringSpec";var Te=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(te);t.NullStringSpec=Te,Te.__name__="NullStringSpec";var Le=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(te);t.ArraySpec=Le,Le.__name__="ArraySpec";var we=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(te);t.MarkerSpec=we,we.__name__="MarkerSpec";var qe=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(te);t.LineJoinSpec=qe,qe.__name__="LineJoinSpec";var Ne=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(te);t.LineCapSpec=Ne,Ne.__name__="LineCapSpec";var ze=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(te);t.LineDashSpec=ze,ze.__name__="LineDashSpec";var Be=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n.prototype._default_override=function(){return h.settings.dev?"Bokeh":void 0},n}(te);t.FontSpec=Be,Be.__name__="FontSpec";var Fe=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(te);t.FontSizeSpec=Fe,Fe.__name__="FontSizeSpec";var De=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(te);t.FontStyleSpec=De,De.__name__="FontStyleSpec";var Ue=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(te);t.TextAlignSpec=Ue,Ue.__name__="TextAlignSpec";var Me=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),n}(te);t.TextBaselineSpec=Me,Me.__name__="TextBaselineSpec"},
function _(e,l,o,n,t){n();var r=e(1),g=e(125),i=e(128),v={},a=function(e,l){this.name=e,this.level=l};o.LogLevel=a,a.__name__="LogLevel";var s=function(){function e(l,o){void 0===o&&(o=e.INFO),this._name=l,this.set_level(o)}return Object.defineProperty(e,"levels",{get:function(){return Object.keys(e.log_levels)},enumerable:!1,configurable:!0}),e.get=function(l,o){if(void 0===o&&(o=e.INFO),l.length>0){var n=v[l];return null==n&&(v[l]=n=new e(l,o)),n}throw new TypeError("Logger.get() expects a non-empty string name and an optional log-level")},Object.defineProperty(e.prototype,"level",{get:function(){return this.get_level()},enumerable:!1,configurable:!0}),e.prototype.get_level=function(){return this._log_level},e.prototype.set_level=function(l){var o,n;if(l instanceof a)this._log_level=l;else{if(!(0,g.isString)(l)||null==e.log_levels[l])throw new Error("Logger.set_level() expects a log-level object or a string name of a log-level");this._log_level=e.log_levels[l]}var t="["+this._name+"]";try{for(var v=(0,r.__values)((0,i.entries)(e.log_levels)),s=v.next();!s.done;s=v.next()){var c=(0,r.__read)(s.value,2),_=c[0];c[1].level<this._log_level.level||this._log_level.level===e.OFF.level?this[_]=function(){}:this[_]=f(_,t)}}catch(e){o={error:e}}finally{try{s&&!s.done&&(n=v.return)&&n.call(v)}finally{if(o)throw o.error}}},e.prototype.trace=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e.prototype.debug=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e.prototype.info=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e.prototype.warn=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e.prototype.error=function(){for(var e=[],l=0;l<arguments.length;l++)e[l]=arguments[l]},e}();function f(e,l){return null!=console[e]?console[e].bind(console,l):null!=console.log?console.log.bind(console,l):function(){}}function c(e){var l=o.logger.level;return(0,g.isString)(e)&&null==s.log_levels[e]?(console.log("[bokeh] unrecognized logging level '"+e+"' passed to Bokeh.set_log_level(), ignoring"),console.log("[bokeh] valid log levels are: "+s.levels.join(", "))):(console.log("[bokeh] setting log level to: '"+((0,g.isString)(e)?e:e.level)+"'"),o.logger.set_level(e)),l}o.Logger=s,s.__name__="Logger",s.TRACE=new a("trace",0),s.DEBUG=new a("debug",1),s.INFO=new a("info",2),s.WARN=new a("warn",6),s.ERROR=new a("error",7),s.FATAL=new a("fatal",8),s.OFF=new a("off",9),s.log_levels={trace:s.TRACE,debug:s.DEBUG,info:s.INFO,warn:s.WARN,error:s.ERROR,fatal:s.FATAL,off:s.OFF},o.logger=s.get("bokeh"),o.set_log_level=c,o.with_log_level=function(e,l){var o=c(e);try{l()}finally{c(o)}}},
function _(e,n,t,o,i){o(),t.VerticalAlign=void 0;var a=e(136);t.Align=(0,a.Enum)("start","center","end"),t.Anchor=(0,a.Enum)("top_left","top_center","top_right","center_left","center_center","center_right","bottom_left","bottom_center","bottom_right","top","left","center","right","bottom"),t.AngleUnits=(0,a.Enum)("deg","rad","grad","turn"),t.BoxOrigin=(0,a.Enum)("corner","center"),t.ButtonType=(0,a.Enum)("default","primary","success","warning","danger","light"),t.CalendarPosition=(0,a.Enum)("auto","above","below"),t.Dimension=(0,a.Enum)("width","height"),t.Dimensions=(0,a.Enum)("width","height","both"),t.Direction=(0,a.Enum)("clock","anticlock"),t.Distribution=(0,a.Enum)("uniform","normal"),t.FontStyle=(0,a.Enum)("normal","italic","bold","bold italic"),t.HatchPatternType=(0,a.Enum)("blank","dot","ring","horizontal_line","vertical_line","cross","horizontal_dash","vertical_dash","spiral","right_diagonal_line","left_diagonal_line","diagonal_cross","right_diagonal_dash","left_diagonal_dash","horizontal_wave","vertical_wave","criss_cross"," ",".","o","-","|","+",'"',":","@","/","\\","x",",","`","v",">","*"),t.HTTPMethod=(0,a.Enum)("POST","GET"),t.HexTileOrientation=(0,a.Enum)("pointytop","flattop"),t.HoverMode=(0,a.Enum)("mouse","hline","vline"),t.LatLon=(0,a.Enum)("lat","lon"),t.LegendClickPolicy=(0,a.Enum)("none","hide","mute"),t.LegendLocation=t.Anchor,t.LineCap=(0,a.Enum)("butt","round","square"),t.LineJoin=(0,a.Enum)("miter","round","bevel"),t.LineDash=(0,a.Enum)("solid","dashed","dotted","dotdash","dashdot"),t.LinePolicy=(0,a.Enum)("prev","next","nearest","interp","none"),t.Location=(0,a.Enum)("above","below","left","right"),t.Logo=(0,a.Enum)("normal","grey"),t.MarkerType=(0,a.Enum)("asterisk","circle","circle_cross","circle_dot","circle_x","circle_y","cross","dash","diamond","diamond_cross","diamond_dot","dot","hex","hex_dot","inverted_triangle","plus","square","square_cross","square_dot","square_pin","square_x","star","star_dot","triangle","triangle_dot","triangle_pin","x","y"),t.MutedPolicy=(0,a.Enum)("show","ignore"),t.Orientation=(0,a.Enum)("vertical","horizontal"),t.OutputBackend=(0,a.Enum)("canvas","svg","webgl"),t.PaddingUnits=(0,a.Enum)("percent","absolute"),t.Place=(0,a.Enum)("above","below","left","right","center"),t.PointPolicy=(0,a.Enum)("snap_to_data","follow_mouse","none"),t.RadiusDimension=(0,a.Enum)("x","y","max","min"),t.RenderLevel=(0,a.Enum)("image","underlay","glyph","guide","annotation","overlay"),t.RenderMode=(0,a.Enum)("canvas","css"),t.ResetPolicy=(0,a.Enum)("standard","event_only"),t.RoundingFunction=(0,a.Enum)("round","nearest","floor","rounddown","ceil","roundup"),t.SelectionMode=(0,a.Enum)("replace","append","intersect","subtract"),t.Side=(0,a.Enum)("above","below","left","right"),t.SizingMode=(0,a.Enum)("stretch_width","stretch_height","stretch_both","scale_width","scale_height","scale_both","fixed"),t.Sort=(0,a.Enum)("ascending","descending"),t.SpatialUnits=(0,a.Enum)("screen","data"),t.StartEnd=(0,a.Enum)("start","end"),t.StepMode=(0,a.Enum)("after","before","center"),t.TapBehavior=(0,a.Enum)("select","inspect"),t.TextAlign=(0,a.Enum)("left","right","center"),t.TextBaseline=(0,a.Enum)("top","middle","bottom","alphabetic","hanging","ideographic"),t.TextureRepetition=(0,a.Enum)("repeat","repeat_x","repeat_y","no_repeat"),t.TickLabelOrientation=(0,a.Enum)("vertical","horizontal","parallel","normal"),t.TooltipAttachment=(0,a.Enum)("horizontal","vertical","left","right","above","below"),t.UpdateMode=(0,a.Enum)("replace","append"),t.VerticalAlign=(0,a.Enum)("top","middle","bottom")},
function _(n,t,r,e,i){e();var u=n(1),o=(0,u.__importStar)(n(125)),a=n(137),l=n(128),_=window.Map,s=Object.prototype.hasOwnProperty,c=function(){};r.Kind=c,c.__name__="Kind",function(n){var t=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return(0,u.__extends)(t,n),t.prototype.valid=function(n){return!0},t}(c);t.__name__="Any",n.Any=t;var r=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return(0,u.__extends)(t,n),t.prototype.valid=function(n){return!0},t}(c);r.__name__="Unknown",n.Unknown=r;var e=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return(0,u.__extends)(t,n),t.prototype.valid=function(n){return o.isBoolean(n)},t}(c);e.__name__="Boolean",n.Boolean=e;var i=function(n){function t(t){var r=n.call(this)||this;return r.obj_type=t,r}return(0,u.__extends)(t,n),t.prototype.valid=function(n){return!0},t}(c);i.__name__="Ref",n.Ref=i;var f=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return(0,u.__extends)(t,n),t.prototype.valid=function(n){return!0},t}(c);f.__name__="AnyRef",n.AnyRef=f;var p=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return(0,u.__extends)(t,n),t.prototype.valid=function(n){return o.isNumber(n)},t}(c);p.__name__="Number",n.Number=p;var y=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return(0,u.__extends)(t,n),t.prototype.valid=function(t){return n.prototype.valid.call(this,t)&&o.isInteger(t)},t}(p);y.__name__="Int",n.Int=y;var v=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return(0,u.__extends)(t,n),t.prototype.valid=function(t){return n.prototype.valid.call(this,t)&&0<=t&&t<=1},t}(p);v.__name__="Percent",n.Percent=v;var d=function(n){function t(t){var r=n.call(this)||this;return r.types=t,r.types=t,r}return(0,u.__extends)(t,n),t.prototype.valid=function(n){return this.types.some((function(t){return t.valid(n)}))},t}(c);d.__name__="Or",n.Or=d;var h=function(n){function t(t){var r=n.call(this)||this;return r.types=t,r.types=t,r}return(0,u.__extends)(t,n),t.prototype.valid=function(n){if(!o.isArray(n))return!1;for(var t=0;t<this.types.length;t++){var r=this.types[t],e=n[t];if(!r.valid(e))return!1}return!0},t}(c);h.__name__="Tuple",n.Tuple=h;var m=function(n){function t(t){var r=n.call(this)||this;return r.struct_type=t,r}return(0,u.__extends)(t,n),t.prototype.valid=function(n){if(!o.isPlainObject(n))return!1;var t=this.struct_type;if((0,l.size)(t)!=(0,l.size)(n))return!1;for(var r in t)if(s.call(t,r)){if(!s.call(n,r))return!1;var e=t[r],i=n[r];if(!e.valid(i))return!1}return!0},t}(c);m.__name__="Struct",n.Struct=m;var w=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return(0,u.__extends)(t,n),t.prototype.valid=function(n){return o.isArray(n)||o.isTypedArray(n)},t}(c);w.__name__="Arrayable",n.Arrayable=w;var K=function(n){function t(t){var r=n.call(this)||this;return r.item_type=t,r}return(0,u.__extends)(t,n),t.prototype.valid=function(n){var t=this;return o.isArray(n)&&n.every((function(n){return t.item_type.valid(n)}))},t}(c);K.__name__="Array",n.Array=K;var b=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return(0,u.__extends)(t,n),t.prototype.valid=function(n){return null===n},t}(c);b.__name__="Null",n.Null=b;var x=function(n){function t(t){var r=n.call(this)||this;return r.base_type=t,r}return(0,u.__extends)(t,n),t.prototype.valid=function(n){return null===n||this.base_type.valid(n)},t}(c);x.__name__="Nullable",n.Nullable=x;var A=function(n){function t(t){var r=n.call(this)||this;return r.base_type=t,r}return(0,u.__extends)(t,n),t.prototype.valid=function(n){return void 0===n||this.base_type.valid(n)},t}(c);A.__name__="Opt",n.Opt=A;var S=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return(0,u.__extends)(t,n),t.prototype.valid=function(n){return o.isString(n)},t}(c);S.__name__="String",n.String=S;var g=function(n){function t(t){var r=n.call(this)||this;return r.values=new Set(t),r}return(0,u.__extends)(t,n),t.prototype.valid=function(n){return this.values.has(n)},t.prototype[Symbol.iterator]=function(){return(0,u.__generator)(this,(function(n){switch(n.label){case 0:return[5,(0,u.__values)(this.values)];case 1:return n.sent(),[2]}}))},t}(c);g.__name__="Enum",n.Enum=g;var N=function(n){function t(t){var r=n.call(this)||this;return r.item_type=t,r}return(0,u.__extends)(t,n),t.prototype.valid=function(n){if(!o.isPlainObject(n))return!1;for(var t in n)if(s.call(n,t)){var r=n[t];if(!this.item_type.valid(r))return!1}return!0},t}(c);N.__name__="Dict",n.Dict=N;var O=function(n){function t(t,r){var e=n.call(this)||this;return e.key_type=t,e.item_type=r,e}return(0,u.__extends)(t,n),t.prototype.valid=function(n){var t,r;if(!(n instanceof _))return!1;try{for(var e=(0,u.__values)(n.entries()),i=e.next();!i.done;i=e.next()){var o=(0,u.__read)(i.value,2),a=o[0],l=o[1];if(!this.key_type.valid(a)||!this.item_type.valid(l))return!1}}catch(n){t={error:n}}finally{try{i&&!i.done&&(r=e.return)&&r.call(e)}finally{if(t)throw t.error}}return!0},t}(c);O.__name__="Map",n.Map=O;var P=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return(0,u.__extends)(t,n),t.prototype.valid=function(n){return(0,a.is_Color)(n)},t}(c);P.__name__="Color",n.Color=P;var R=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return(0,u.__extends)(t,n),t.prototype.valid=function(n){return o.isFunction(n)},t}(c);R.__name__="Function",n.Function=R}(r.Kinds||(r.Kinds={})),r.Any=new r.Kinds.Any,r.Unknown=new r.Kinds.Unknown,r.Boolean=new r.Kinds.Boolean,r.Number=new r.Kinds.Number,r.Int=new r.Kinds.Int,r.String=new r.Kinds.String,r.Null=new r.Kinds.Null;r.Nullable=function(n){return new r.Kinds.Nullable(n)};r.Opt=function(n){return new r.Kinds.Opt(n)};r.Or=function(){for(var n=[],t=0;t<arguments.length;t++)n[t]=arguments[t];return new r.Kinds.Or(n)};r.Tuple=function(){for(var n=[],t=0;t<arguments.length;t++)n[t]=arguments[t];return new r.Kinds.Tuple(n)};r.Struct=function(n){return new r.Kinds.Struct(n)},r.Arrayable=new r.Kinds.Arrayable;r.Array=function(n){return new r.Kinds.Array(n)};r.Dict=function(n){return new r.Kinds.Dict(n)};r.Map=function(n,t){return new r.Kinds.Map(n,t)};r.Enum=function(){for(var n=[],t=0;t<arguments.length;t++)n[t]=arguments[t];return new r.Kinds.Enum(n)};r.Ref=function(n){return new r.Kinds.Ref(n)};r.AnyRef=function(){return new r.Kinds.AnyRef};r.Function=function(){return new r.Kinds.Function},r.Percent=new r.Kinds.Percent,r.Alpha=r.Percent,r.Color=new r.Kinds.Color,r.Auto=(0,r.Enum)("auto"),r.FontSize=r.String,r.Font=r.String,r.Angle=r.Number},
function _(r,n,e,t,a){t();var u=r(1),s=r(138),i=r(117),l=r(125),c=Math.round;function o(r){return(0,i.clamp)(c(r),0,255)}function d(){return[0,0,0,0]}function _(r){return[r>>24&255,r>>16&255,r>>8&255,255&r]}function f(r,n){var e,t,a,s,i,c,d,f,v,h;return null==r?(d=(e=(0,u.__read)([0,0,0,0],4))[0],f=e[1],v=e[2],h=e[3]):(0,l.isInteger)(r)?(d=(t=(0,u.__read)(_(r),4))[0],f=t[1],v=t[2],h=t[3]):(0,l.isString)(r)?(d=(a=(0,u.__read)(null!==(c=N(r))&&void 0!==c?c:[0,0,0,0],4))[0],f=a[1],v=a[2],h=a[3]):(d=(s=(0,u.__read)(r,4))[0],f=s[1],v=s[2],h=o(255*(h=void 0===(i=s[3])?1:i))),255==h&&null!=n&&(h=o(255*n)),[d,f,v,h]}e.transparent=d,e.encode_rgba=function(r){var n=(0,u.__read)(r,4);return n[0]<<24|n[1]<<16|n[2]<<8|n[3]},e.decode_rgba=_,e.compose_alpha=function(r,n){return 255==(255&r)?4294967040&r|o(255*n):r},e.color2rgba=f;var v={0:"0",1:"1",2:"2",3:"3",4:"4",5:"5",6:"6",7:"7",8:"8",9:"9",10:"a",11:"b",12:"c",13:"d",14:"e",15:"f"};function h(r){return v[r>>4]+v[15&r]}e.color2css=function(r,n){var e=(0,u.__read)(f(r,n),4);return"rgba("+e[0]+", "+e[1]+", "+e[2]+", "+e[3]/255+")"},e.color2hex=function(r,n){var e=(0,u.__read)(f(r,n),4),t=e[0],a=e[1],s=e[2],i=e[3],l="#"+h(t)+h(a)+h(s);return 255==i?l:""+l+h(i)},e.color2hexrgb=function(r){var n=(0,u.__read)(f(r),3),e=n[0],t=n[1],a=n[2];return"#"+h(e)+h(t)+h(a)};var g=/^rgba?\(\s*([^\s,]+?)\s+([^\s,]+?)\s+([^\s,]+?)(?:\s*\/\s*([^\s,]+?))?\s*\)$/,b=/^rgba?\(\s*([^\s,]+?)\s*,\s*([^\s,]+?)\s*,\s*([^\s,]+?)(?:\s*,\s*([^\s,]+?))?\s*\)$/,m=function(){var r=document.createElement("canvas");r.width=1,r.height=1;var n=r.getContext("2d"),e=n.createLinearGradient(0,0,1,1);return function(r){n.fillStyle=e,n.fillStyle=r;var t=n.fillStyle;return t!=e?t:null}}();function N(r){var n;if(!(r=r.trim().toLowerCase()))return null;if("transparent"==r)return[0,0,0,0];if((0,s.is_named_color)(r))return _(s.named_colors[r]);if("#"==r[0]){var e=Number("0x"+r.substr(1));if(isNaN(e))return null;switch(r.length-1){case 3:return[(i=e>>8&15)<<4|i,(l=e>>4&15)<<4|l,(c=e>>0&15)<<4|c,255];case 4:return[(i=e>>12&15)<<4|i,(l=e>>8&15)<<4|l,(c=e>>4&15)<<4|c,(f=e>>0&15)<<4|f];case 6:return[e>>16&255,e>>8&255,e>>0&255,255];case 8:return[e>>24&255,e>>16&255,e>>8&255,e>>0&255]}}else if(r.startsWith("rgb")){var t=null!==(n=r.match(g))&&void 0!==n?n:r.match(b);if(null!=t){var a=(0,u.__read)(t,5),i=a[1],l=a[2],c=a[3],d=a[4],f=void 0===d?"1":d,v=i.endsWith("%"),h=l.endsWith("%"),p=c.endsWith("%"),S=f.endsWith("%");if(!(v&&h&&p)&&(v||h||p))return null;v&&(i=i.slice(0,-1)),h&&(l=l.slice(0,-1)),p&&(c=c.slice(0,-1)),S&&(f=f.slice(0,-1));var W=Number(i),x=Number(l),y=Number(c),w=Number(f);return isNaN(W+x+y+w)?null:(v&&(W=W/100*255),h&&(x=x/100*255),p&&(y=y/100*255),w=255*(S?w/100:w),[W=o(W),x=o(x),y=o(y),w=o(w)])}}else{var C=m(r);if(null!=C)return N(C)}return null}e.css4_parse=N,e.is_Color=function(r){return!!(0,l.isInteger)(r)||(!(!(0,l.isString)(r)||null==N(r))||!(!(0,l.isArray)(r)||3!=r.length&&4!=r.length))},e.is_dark=function(r){var n=(0,u.__read)(r,3);return 1-(.299*n[0]+.587*n[1]+.114*n[2])/255>=.6}},
function _(e,r,l,a,i){a();l.named_colors={aliceblue:4042850303,antiquewhite:4209760255,aqua:16777215,aquamarine:2147472639,azure:4043309055,beige:4126530815,bisque:4293182719,black:255,blanchedalmond:4293643775,blue:65535,blueviolet:2318131967,brown:2771004159,burlywood:3736635391,cadetblue:1604231423,chartreuse:2147418367,chocolate:3530104575,coral:4286533887,cornflowerblue:1687547391,cornsilk:4294499583,crimson:3692313855,cyan:16777215,darkblue:35839,darkcyan:9145343,darkgoldenrod:3095792639,darkgray:2846468607,darkgreen:6553855,darkgrey:2846468607,darkkhaki:3182914559,darkmagenta:2332068863,darkolivegreen:1433087999,darkorange:4287365375,darkorchid:2570243327,darkred:2332033279,darksalmon:3918953215,darkseagreen:2411499519,darkslateblue:1211993087,darkslategray:793726975,darkslategrey:793726975,darkturquoise:13554175,darkviolet:2483082239,deeppink:4279538687,deepskyblue:12582911,dimgray:1768516095,dimgrey:1768516095,dodgerblue:512819199,firebrick:2988581631,floralwhite:4294635775,forestgreen:579543807,fuchsia:4278255615,gainsboro:3705462015,ghostwhite:4177068031,gold:4292280575,goldenrod:3668254975,gray:2155905279,green:8388863,greenyellow:2919182335,grey:2155905279,honeydew:4043305215,hotpink:4285117695,indianred:3445382399,indigo:1258324735,ivory:4294963455,khaki:4041641215,lavender:3873897215,lavenderblush:4293981695,lawngreen:2096890111,lemonchiffon:4294626815,lightblue:2916673279,lightcoral:4034953471,lightcyan:3774873599,lightgoldenrodyellow:4210742015,lightgray:3553874943,lightgreen:2431553791,lightgrey:3553874943,lightpink:4290167295,lightsalmon:4288707327,lightseagreen:548580095,lightskyblue:2278488831,lightslategray:2005441023,lightslategrey:2005441023,lightsteelblue:2965692159,lightyellow:4294959359,lime:16711935,limegreen:852308735,linen:4210091775,magenta:4278255615,maroon:2147483903,mediumaquamarine:1724754687,mediumblue:52735,mediumorchid:3126187007,mediumpurple:2473647103,mediumseagreen:1018393087,mediumslateblue:2070474495,mediumspringgreen:16423679,mediumturquoise:1221709055,mediumvioletred:3340076543,midnightblue:421097727,mintcream:4127193855,mistyrose:4293190143,moccasin:4293178879,navajowhite:4292783615,navy:33023,oldlace:4260751103,olive:2155872511,olivedrab:1804477439,orange:4289003775,orangered:4282712319,orchid:3664828159,palegoldenrod:4008225535,palegreen:2566625535,paleturquoise:2951671551,palevioletred:3681588223,papayawhip:4293907967,peachpuff:4292524543,peru:3448061951,pink:4290825215,plum:3718307327,powderblue:2967529215,purple:2147516671,rebeccapurple:1714657791,red:4278190335,rosybrown:3163525119,royalblue:1097458175,saddlebrown:2336560127,salmon:4202722047,sandybrown:4104413439,seagreen:780883967,seashell:4294307583,sienna:2689740287,silver:3233857791,skyblue:2278484991,slateblue:1784335871,slategray:1887473919,slategrey:1887473919,snow:4294638335,springgreen:16744447,steelblue:1182971135,tan:3535047935,teal:8421631,thistle:3636451583,tomato:4284696575,turquoise:1088475391,violet:4001558271,wheat:4125012991,white:4294967295,whitesmoke:4126537215,yellow:4294902015,yellowgreen:2597139199},l.is_named_color=function(e){return e in l.named_colors}},
function _(r,t,n,a,o){a();var e=r(1);n.GeneratorFunction=Object.getPrototypeOf((function(){return(0,e.__generator)(this,(function(r){return[2]}))})).constructor,n.ColorArray=Uint32Array,n.RGBAArray=Uint8ClampedArray,n.infer_type=function(r,t){return r instanceof Float64Array||r instanceof Array||t instanceof Float64Array||t instanceof Array?Float64Array:Float32Array},n.ScreenArray=Float32Array,n.to_screen=function(r){return r instanceof Float32Array?r:Float32Array.from(r)},o("Indices",r(140).BitSet)},
function _(r,t,e,n,i){n();var s,a=r(1),o=r(141),c=r(127),u=function(){function r(r,t){void 0===t&&(t=0),this.size=r,this[s]="BitSet",this._count=null,this._nwords=Math.ceil(r/32),0==t||1==t?(this._array=new Uint32Array(this._nwords),1==t&&this._array.fill(4294967295)):((0,c.assert)(t.length==this._nwords,"Initializer size mismatch"),this._array=t)}return r.prototype.clone=function(){return new r(this.size,new Uint32Array(this._array))},r.prototype[(s=Symbol.toStringTag,o.equals)]=function(r,t){if(!t.eq(this.size,r.size))return!1;for(var e=this._nwords,n=this.size%e,i=0==n?e:e-1,s=0;s<i;s++)if(this._array[s]!=r._array[s])return!1;if(0==n)return!0;var a=1<<n-1,o=a-1^a;return(this._array[i]&o)==(r._array[i]&o)},r.all_set=function(t){return new r(t,1)},r.all_unset=function(t){return new r(t,0)},r.from_indices=function(t,e){var n,i,s=new r(t);try{for(var o=(0,a.__values)(e),c=o.next();!c.done;c=o.next()){var u=c.value;s.set(u)}}catch(r){n={error:r}}finally{try{c&&!c.done&&(i=o.return)&&i.call(o)}finally{if(n)throw n.error}}return s},r.from_booleans=function(t,e){for(var n=new r(t),i=Math.min(t,e.length),s=0;s<i;s++)e[s]&&n.set(s);return n},r.prototype._check_bounds=function(r){(0,c.assert)(0<=r&&r<this.size,"Out of bounds: 0 <= "+r+" < "+this.size)},r.prototype.get=function(r){this._check_bounds(r);var t=r>>>5,e=31&r;return!!(this._array[t]>>e&1)},r.prototype.set=function(r,t){void 0===t&&(t=!0),this._check_bounds(r),this._count=null;var e=r>>>5,n=31&r;t?this._array[e]|=1<<n:this._array[e]&=~(1<<n)},r.prototype.unset=function(r){this.set(r,!1)},r.prototype[Symbol.iterator]=function(){return(0,a.__generator)(this,(function(r){switch(r.label){case 0:return[5,(0,a.__values)(this.ones())];case 1:return r.sent(),[2]}}))},Object.defineProperty(r.prototype,"count",{get:function(){var r=this._count;return null==r&&(this._count=r=this._get_count()),r},enumerable:!1,configurable:!0}),r.prototype._get_count=function(){for(var r=this,t=r._array,e=r._nwords,n=r.size,i=0,s=0,a=0;a<e;a++){var o=t[a];if(0==o)s+=32;else for(var c=0;c<32&&s<n;c++,s++)o>>>c&1&&(i+=1)}return i},r.prototype.ones=function(){var r,t,e,n,i,s,o,c;return(0,a.__generator)(this,(function(a){switch(a.label){case 0:t=(r=this)._array,e=r._nwords,n=r.size,i=0,s=0,a.label=1;case 1:if(!(s<e))return[3,6];if(0==(o=t[s]))return i+=32,[3,5];c=0,a.label=2;case 2:return c<32&&i<n?o>>>c&1?[4,i]:[3,4]:[3,5];case 3:a.sent(),a.label=4;case 4:return c++,i++,[3,2];case 5:return s++,[3,1];case 6:return[2]}}))},r.prototype.zeros=function(){var r,t,e,n,i,s,o,c;return(0,a.__generator)(this,(function(a){switch(a.label){case 0:t=(r=this)._array,e=r._nwords,n=r.size,i=0,s=0,a.label=1;case 1:if(!(s<e))return[3,6];if(4294967295==(o=t[s]))return i+=32,[3,5];c=0,a.label=2;case 2:return c<32&&i<n?o>>>c&1?[3,4]:[4,i]:[3,5];case 3:a.sent(),a.label=4;case 4:return c++,i++,[3,2];case 5:return s++,[3,1];case 6:return[2]}}))},r.prototype._check_size=function(r){(0,c.assert)(this.size==r.size,"Size mismatch")},r.prototype.add=function(r){this._check_size(r);for(var t=0;t<this._nwords;t++)this._array[t]|=r._array[t]},r.prototype.intersect=function(r){this._check_size(r);for(var t=0;t<this._nwords;t++)this._array[t]&=r._array[t]},r.prototype.subtract=function(r){this._check_size(r);for(var t=0;t<this._nwords;t++){var e=this._array[t],n=r._array[t];this._array[t]=(e^n)&e}},r.prototype.union=function(r){this._check_size(r);for(var t=this.clone(),e=0;e<this._nwords;e++)t._array[e]|=r._array[e];return t},r.prototype.intersection=function(r){this._check_size(r);for(var t=this.clone(),e=0;e<this._nwords;e++)t._array[e]&=r._array[e];return t},r.prototype.difference=function(r){this._check_size(r);for(var t=this.clone(),e=0;e<this._nwords;e++){var n=this._array[e],i=r._array[e];t._array[e]=(n^i)&n}return t},r.prototype.select=function(r){var t,e;(0,c.assert)(this.size<=r.length,"Size mismatch");var n=this.count,i=new r.constructor(n),s=0;try{for(var o=(0,a.__values)(this),u=o.next();!u.done;u=o.next()){var _=u.value;i[s++]=r[_]}}catch(r){t={error:r}}finally{try{u&&!u.done&&(e=o.return)&&e.call(o)}finally{if(t)throw t.error}}return i},r}();e.BitSet=u,u.__name__="BitSet"},
function _(r,t,e,n,o){n();var a=r(1),c=r(125),i=Object.prototype.hasOwnProperty;function s(r){return(0,c.isObject)(r)&&void 0!==r[e.equals]}e.equals=Symbol("equals"),e.wildcard=Symbol("wildcard");var u=Object.prototype.toString,l=function(){function r(){this.a_stack=[],this.b_stack=[]}return r.prototype.eq=function(r,t){var n=this;if(Object.is(r,t))return!0;if(r===e.wildcard||t===e.wildcard)return!0;if(null==r||null==t)return r===t;var o=u.call(r);if(o!=u.call(t))return!1;switch(o){case"[object Number]":return this.numbers(r,t);case"[object RegExp]":case"[object String]":return""+r==""+t;case"[object Date]":case"[object Boolean]":return+r==+t}for(var a=this.a_stack,c=this.b_stack,i=a.length;i--;)if(a[i]===r)return c[i]===t;a.push(r),c.push(t);var l=function(){if(s(r)&&s(t))return r[e.equals](t,n);switch(o){case"[object Array]":case"[object Uint8Array]":case"[object Int8Array]":case"[object Uint16Array]":case"[object Int16Array]":case"[object Uint32Array]":case"[object Int32Array]":case"[object Float32Array]":case"[object Float64Array]":return n.arrays(r,t);case"[object Map]":return n.maps(r,t);case"[object Set]":return n.sets(r,t);case"[object Object]":if(r.constructor==t.constructor&&(null==r.constructor||r.constructor===Object))return n.objects(r,t);case"[object Function]":if(r.constructor==t.constructor&&r.constructor===Function)return n.eq(""+r,""+t)}if(r instanceof Node)return n.nodes(r,t);throw Error("can't compare objects of type "+o)}();return a.pop(),c.pop(),l},r.prototype.numbers=function(r,t){return Object.is(r,t)},r.prototype.arrays=function(r,t){var e=r.length;if(e!=t.length)return!1;for(var n=0;n<e;n++)if(!this.eq(r[n],t[n]))return!1;return!0},r.prototype.iterables=function(r,t){for(var e=r[Symbol.iterator](),n=t[Symbol.iterator]();;){var o=e.next(),a=n.next();if(o.done&&a.done)return!0;if(o.done||a.done)return!1;if(!this.eq(o.value,a.value))return!1}},r.prototype.maps=function(r,t){var e,n;if(r.size!=t.size)return!1;try{for(var o=(0,a.__values)(r),c=o.next();!c.done;c=o.next()){var i=(0,a.__read)(c.value,2),s=i[0],u=i[1];if(!t.has(s)||!this.eq(u,t.get(s)))return!1}}catch(r){e={error:r}}finally{try{c&&!c.done&&(n=o.return)&&n.call(o)}finally{if(e)throw e.error}}return!0},r.prototype.sets=function(r,t){var e,n;if(r.size!=t.size)return!1;try{for(var o=(0,a.__values)(r),c=o.next();!c.done;c=o.next()){var i=c.value;if(!t.has(i))return!1}}catch(r){e={error:r}}finally{try{c&&!c.done&&(n=o.return)&&n.call(o)}finally{if(e)throw e.error}}return!0},r.prototype.objects=function(r,t){var e,n,o=Object.keys(r);if(o.length!=Object.keys(t).length)return!1;try{for(var c=(0,a.__values)(o),s=c.next();!s.done;s=c.next()){var u=s.value;if(!i.call(t,u)||!this.eq(r[u],t[u]))return!1}}catch(r){e={error:r}}finally{try{s&&!s.done&&(n=c.return)&&n.call(c)}finally{if(e)throw e.error}}return!0},r.prototype.nodes=function(r,t){return r.nodeType==t.nodeType&&(r.textContent==t.textContent&&!!this.iterables(r.childNodes,t.childNodes))},r}();e.Comparator=l,l.__name__="Comparator";var f=Math.abs,y=function(r){function t(t){void 0===t&&(t=1e-4);var e=r.call(this)||this;return e.tolerance=t,e}return(0,a.__extends)(t,r),t.prototype.numbers=function(t,e){return r.prototype.numbers.call(this,t,e)||f(t-e)<this.tolerance},t}(l);function b(r,t){return(new l).eq(r,t)}e.SimilarComparator=y,y.__name__="SimilarComparator",e.is_equal=b,e.is_similar=function(r,t,e){return new y(e).eq(r,t)},e.isEqual=b},
function _(n,i,e,r,t){r();var a,o=n(1);e.is_windows=navigator.appVersion.includes("Windows"),e.is_ie=(a=navigator.userAgent).includes("MSIE")||a.includes("Trident")||a.includes("Edge"),e.is_mobile="undefined"!=typeof window&&("ontouchstart"in window||navigator.maxTouchPoints>0),e.is_little_endian=function(){var n=new ArrayBuffer(4),i=new Uint8Array(n);new Uint32Array(n)[1]=168496141;var e=!0;return 10==i[4]&&11==i[5]&&12==i[6]&&13==i[7]&&(e=!1),e}(),e.BYTE_ORDER=e.is_little_endian?"little":"big",e.to_big_endian=function(n){var i,r;if(e.is_little_endian){var t=new Uint32Array(n.length),a=new DataView(t.buffer),l=0;try{for(var u=(0,o.__values)(n),d=u.next();!d.done;d=u.next()){var s=d.value;a.setUint32(l,s),l+=4}}catch(n){i={error:n}}finally{try{d&&!d.done&&(r=u.return)&&r.call(u)}finally{if(i)throw i.error}}return t}return n}},
function _(e,t,n,r,i){r();var f=function(){function e(){this._dev=!1,this._wireframe=!1}return Object.defineProperty(e.prototype,"dev",{get:function(){return this._dev},set:function(e){this._dev=e},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"wireframe",{get:function(){return this._wireframe},set:function(e){this._wireframe=e},enumerable:!1,configurable:!0}),e}();n.Settings=f,f.__name__="Settings",n.settings=new f},
function _(e,n,r,t,a){t();var i,u,s,l,o,p,c,y,h=e(1),f=e(125),_=e(127),A=e(141),q=e(145),d=e(146),z=Symbol("__ndarray__"),D=function(e){function n(r,t){var a=new e(r);return a[i]=!0,a.dtype="uint8",a.shape=null!=t?t:x(r)?r.shape:[a.length],a.dimension=a.shape.length,null==a[A.equals]&&(a[A.equals]=function(e,r){return n.prototype[A.equals].call(a,e,r)}),null==a[q.serialize]&&(a[q.serialize]=function(e){return n.prototype[q.serialize].call(a,e)}),a}return(0,h.__extends)(n,e),n.prototype[(i=z,A.equals)]=function(e,n){return n.eq(this.shape,e.shape)&&n.arrays(this,e)},n.prototype[q.serialize]=function(e){return(0,d.encode_NDArray)(this)},n}(Uint8Array);r.Uint8NDArray=D,D.__name__="Uint8NDArray";var N=function(e){function n(r,t){var a=new e(r);return a[u]=!0,a.dtype="int8",a.shape=null!=t?t:x(r)?r.shape:[a.length],a.dimension=a.shape.length,null==a[A.equals]&&(a[A.equals]=function(e,r){return n.prototype[A.equals].call(a,e,r)}),null==a[q.serialize]&&(a[q.serialize]=function(e){return n.prototype[q.serialize].call(a,e)}),a}return(0,h.__extends)(n,e),n.prototype[(u=z,A.equals)]=function(e,n){return n.eq(this.shape,e.shape)&&n.arrays(this,e)},n.prototype[q.serialize]=function(e){return(0,d.encode_NDArray)(this)},n}(Int8Array);r.Int8NDArray=N,N.__name__="Int8NDArray";var v=function(e){function n(r,t){var a=new e(r);return a[s]=!0,a.dtype="uint16",a.shape=null!=t?t:x(r)?r.shape:[a.length],a.dimension=a.shape.length,null==a[A.equals]&&(a[A.equals]=function(e,r){return n.prototype[A.equals].call(a,e,r)}),null==a[q.serialize]&&(a[q.serialize]=function(e){return n.prototype[q.serialize].call(a,e)}),a}return(0,h.__extends)(n,e),n.prototype[(s=z,A.equals)]=function(e,n){return n.eq(this.shape,e.shape)&&n.arrays(this,e)},n.prototype[q.serialize]=function(e){return(0,d.encode_NDArray)(this)},n}(Uint16Array);r.Uint16NDArray=v,v.__name__="Uint16NDArray";var w=function(e){function n(r,t){var a=new e(r);return a[l]=!0,a.dtype="int16",a.shape=null!=t?t:x(r)?r.shape:[a.length],a.dimension=a.shape.length,null==a[A.equals]&&(a[A.equals]=function(e,r){return n.prototype[A.equals].call(a,e,r)}),null==a[q.serialize]&&(a[q.serialize]=function(e){return n.prototype[q.serialize].call(a,e)}),a}return(0,h.__extends)(n,e),n.prototype[(l=z,A.equals)]=function(e,n){return n.eq(this.shape,e.shape)&&n.arrays(this,e)},n.prototype[q.serialize]=function(e){return(0,d.encode_NDArray)(this)},n}(Int16Array);r.Int16NDArray=w,w.__name__="Int16NDArray";var m=function(e){function n(r,t){var a=new e(r);return a[o]=!0,a.dtype="uint32",a.shape=null!=t?t:x(r)?r.shape:[a.length],a.dimension=a.shape.length,null==a[A.equals]&&(a[A.equals]=function(e,r){return n.prototype[A.equals].call(a,e,r)}),null==a[q.serialize]&&(a[q.serialize]=function(e){return n.prototype[q.serialize].call(a,e)}),a}return(0,h.__extends)(n,e),n.prototype[(o=z,A.equals)]=function(e,n){return n.eq(this.shape,e.shape)&&n.arrays(this,e)},n.prototype[q.serialize]=function(e){return(0,d.encode_NDArray)(this)},n}(Uint32Array);r.Uint32NDArray=m,m.__name__="Uint32NDArray";var g=function(e){function n(r,t){var a=new e(r);return a[p]=!0,a.dtype="int32",a.shape=null!=t?t:x(r)?r.shape:[a.length],a.dimension=a.shape.length,null==a[A.equals]&&(a[A.equals]=function(e,r){return n.prototype[A.equals].call(a,e,r)}),null==a[q.serialize]&&(a[q.serialize]=function(e){return n.prototype[q.serialize].call(a,e)}),a}return(0,h.__extends)(n,e),n.prototype[(p=z,A.equals)]=function(e,n){return n.eq(this.shape,e.shape)&&n.arrays(this,e)},n.prototype[q.serialize]=function(e){return(0,d.encode_NDArray)(this)},n}(Int32Array);r.Int32NDArray=g,g.__name__="Int32NDArray";var I=function(e){function n(r,t){var a=new e(r);return a[c]=!0,a.dtype="float32",a.shape=null!=t?t:x(r)?r.shape:[a.length],a.dimension=a.shape.length,null==a[A.equals]&&(a[A.equals]=function(e,r){return n.prototype[A.equals].call(a,e,r)}),null==a[q.serialize]&&(a[q.serialize]=function(e){return n.prototype[q.serialize].call(a,e)}),a}return(0,h.__extends)(n,e),n.prototype[(c=z,A.equals)]=function(e,n){return n.eq(this.shape,e.shape)&&n.arrays(this,e)},n.prototype[q.serialize]=function(e){return(0,d.encode_NDArray)(this)},n}(Float32Array);r.Float32NDArray=I,I.__name__="Float32NDArray";var U=function(e){function n(r,t){var a=new e(r);return a[y]=!0,a.dtype="float64",a.shape=null!=t?t:x(r)?r.shape:[a.length],a.dimension=a.shape.length,null==a[A.equals]&&(a[A.equals]=function(e,r){return n.prototype[A.equals].call(a,e,r)}),null==a[q.serialize]&&(a[q.serialize]=function(e){return n.prototype[q.serialize].call(a,e)}),a}return(0,h.__extends)(n,e),n.prototype[(y=z,A.equals)]=function(e,n){return n.eq(this.shape,e.shape)&&n.arrays(this,e)},n.prototype[q.serialize]=function(e){return(0,d.encode_NDArray)(this)},n}(Float64Array);function x(e){return(0,f.isObject)(e)&&void 0!==e[z]}r.Float64NDArray=U,U.__name__="Float64NDArray",r.is_NDArray=x,r.ndarray=function(e,n){void 0===n&&(n={});var r=n.dtype;null==r&&(r=e instanceof ArrayBuffer||(0,f.isArray)(e)?"float64":function(){switch(!0){case e instanceof Uint8Array:return"uint8";case e instanceof Int8Array:return"int8";case e instanceof Uint16Array:return"uint16";case e instanceof Int16Array:return"int16";case e instanceof Uint32Array:return"uint32";case e instanceof Int32Array:return"int32";case e instanceof Float32Array:return"float32";case e instanceof Float64Array:return"float64";default:(0,_.unreachable)()}}());var t=n.shape;switch(r){case"uint8":return new D(e,t);case"int8":return new N(e,t);case"uint16":return new v(e,t);case"int16":return new w(e,t);case"uint32":return new m(e,t);case"int32":return new g(e,t);case"float32":return new I(e,t);case"float64":return new U(e,t)}}},
function _(e,r,t,i,n){i();var o=e(1),s=e(127),a=e(128),f=e(125);t.serialize=Symbol("serialize");var l=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return(0,o.__extends)(r,e),r}(Error);t.SerializationError=l,l.__name__="SerializationError";var u=function(){function e(e){var r;this._references=new Map,this._definitions=new Map,this._refmap=new Map,this.include_defaults=null===(r=null==e?void 0:e.include_defaults)||void 0===r||r}return e.prototype.get_ref=function(e){return this._references.get(e)},e.prototype.add_ref=function(e,r){(0,s.assert)(!this._references.has(e)),this._references.set(e,r)},e.prototype.add_def=function(e,r){var t=this.get_ref(e);(0,s.assert)(null!=t),this._definitions.set(e,r),this._refmap.set(t,r)},Object.defineProperty(e.prototype,"objects",{get:function(){return new Set(this._references.keys())},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"references",{get:function(){return new Set(this._references.values())},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"definitions",{get:function(){return new Set(this._definitions.values())},enumerable:!1,configurable:!0}),e.prototype.resolve_ref=function(e){return this._refmap.get(e)},e.prototype.remove_ref=function(e){return this._references.delete(e)},e.prototype.remove_def=function(e){return this._definitions.delete(e)},e.prototype.to_serializable=function(e){var r,i,n=this.get_ref(e);if(null!=n)return n;if(function(e){return(0,f.isObject)(e)&&void 0!==e[t.serialize]}(e))return e[t.serialize](this);if((0,f.isArray)(e)||(0,f.isTypedArray)(e)){for(var s=e.length,u=new Array(s),_=0;_<s;_++){var c=e[_];u[_]=this.to_serializable(c)}return u}if((0,f.isPlainObject)(e)){u={};try{for(var p=(0,o.__values)((0,a.entries)(e)),d=p.next();!d.done;d=p.next()){var h=(0,o.__read)(d.value,2),y=h[0];c=h[1];u[y]=this.to_serializable(c)}}catch(e){r={error:e}}finally{try{d&&!d.done&&(i=p.return)&&i.call(p)}finally{if(r)throw r.error}}return u}if(null===e||(0,f.isBoolean)(e)||(0,f.isNumber)(e)||(0,f.isString)(e))return e;throw new l(Object.prototype.toString.call(e)+" is not serializable")},e}();t.Serializer=u,u.__name__="Serializer"},
function _(r,_,e,f,n){f();var a=r(1),u=r(125),t=r(142),i=r(147);e.is_NDArray_ref=function(r){return(0,u.isPlainObject)(r)&&("__buffer__"in r||"__ndarray__"in r)},e.decode_NDArray=function(r,_){var e,f=r.shape,n=r.dtype,a=r.order;if("__buffer__"in r){var u=_.get(r.__buffer__);if(null==u)throw new Error("buffer for "+r.__buffer__+" not found");e=u}else e=(0,i.base64_to_buffer)(r.__ndarray__);return a!==t.BYTE_ORDER&&(0,i.swap)(e,n),{buffer:e,dtype:n,shape:f}},e.encode_NDArray=function(r,_){var e={order:t.BYTE_ORDER,dtype:r.dtype,shape:r.shape};if(null!=_){var f=""+_.size;return _.set(f,r.buffer),(0,a.__assign)({__buffer__:f},e)}var n={toJSON:function(){return(0,i.buffer_to_base64)(r.buffer)}};return(0,a.__assign)({__ndarray__:n},e)}},
function _(r,n,t,a,e){a(),t.buffer_to_base64=function(r){var n=new Uint8Array(r),t=Array.from(n).map((function(r){return String.fromCharCode(r)}));return btoa(t.join(""))},t.base64_to_buffer=function(r){for(var n=atob(r),t=n.length,a=new Uint8Array(t),e=0,o=t;e<o;e++)a[e]=n.charCodeAt(e);return a.buffer},t.swap=function(r,n){switch(n){case"uint16":case"int16":!function(r){for(var n=new Uint8Array(r),t=0,a=n.length;t<a;t+=2){var e=n[t];n[t]=n[t+1],n[t+1]=e}}(r);break;case"uint32":case"int32":case"float32":!function(r){for(var n=new Uint8Array(r),t=0,a=n.length;t<a;t+=4){var e=n[t];n[t]=n[t+3],n[t+3]=e,e=n[t+1],n[t+1]=n[t+2],n[t+2]=e}}(r);break;case"float64":!function(r){for(var n=new Uint8Array(r),t=0,a=n.length;t<a;t+=8){var e=n[t];n[t]=n[t+7],n[t+7]=e,e=n[t+1],n[t+1]=n[t+6],n[t+6]=e,e=n[t+2],n[t+2]=n[t+5],n[t+5]=e,e=n[t+3],n[t+3]=n[t+4],n[t+4]=e}}(r)}}},
function _(t,r,e,n,a){n();var o=t(1),i=t(141),s=function(){function t(){}return t.prototype.is_Scalar=function(){return this.is_scalar},t.prototype.is_Vector=function(){return!this.is_scalar},t}();e.Uniform=s,s.__name__="Uniform";var u=function(t){function r(r,e){var n=t.call(this)||this;return n.value=r,n.length=e,n.is_scalar=!0,n}return(0,o.__extends)(r,t),r.prototype.get=function(t){return this.value},r.prototype[Symbol.iterator]=function(){var t,r,e,n;return(0,o.__generator)(this,(function(a){switch(a.label){case 0:r=(t=this).length,e=t.value,n=0,a.label=1;case 1:return n<r?[4,e]:[3,4];case 2:a.sent(),a.label=3;case 3:return n++,[3,1];case 4:return[2]}}))},r.prototype.select=function(t){return new r(this.value,t.count)},r.prototype[i.equals]=function(t,r){return r.eq(this.length,t.length)&&r.eq(this.value,t.value)},r}(s);e.UniformScalar=u,u.__name__="UniformScalar";var c=function(t){function r(r){var e=t.call(this)||this;return e.array=r,e.is_scalar=!1,e.length=e.array.length,e}return(0,o.__extends)(r,t),r.prototype.get=function(t){return this.array[t]},r.prototype[Symbol.iterator]=function(){return(0,o.__generator)(this,(function(t){switch(t.label){case 0:return[5,(0,o.__values)(this.array)];case 1:return t.sent(),[2]}}))},r.prototype.select=function(t){var r=t.select(this.array);return new this.constructor(r)},r.prototype[i.equals]=function(t,r){return r.eq(this.length,t.length)&&r.eq(this.array,t.array)},r}(s);e.UniformVector=c,c.__name__="UniformVector";var l=function(t){function r(r){var e=t.call(this,r)||this;return e.array=r,e._view=new DataView(r.buffer),e}return(0,o.__extends)(r,t),r.prototype.get=function(t){return this._view.getUint32(4*t)},r.prototype[Symbol.iterator]=function(){var t,r;return(0,o.__generator)(this,(function(e){switch(e.label){case 0:t=this.length,r=0,e.label=1;case 1:return r<t?[4,this.get(r)]:[3,4];case 2:e.sent(),e.label=3;case 3:return r++,[3,1];case 4:return[2]}}))},r}(c);e.ColorUniformVector=l,l.__name__="ColorUniformVector"},
function _(r,t,e,n,u){n();var a=r(143);function c(){for(var r=new Array(32),t="0123456789ABCDEF",e=0;e<32;e++)r[e]=t.substr(Math.floor(16*Math.random()),1);return r[12]="4",r[16]=t.substr(3&r[16].charCodeAt(0)|8,1),r.join("")}e.startsWith=function(r,t,e){return void 0===e&&(e=0),r.substr(e,t.length)==t},e.uuid4=c;var s=1e3;e.uniqueId=function(r){var t=a.settings.dev?"j"+s++:c();return null!=r?r+"-"+t:t},e.escape=function(r){return r.replace(/(?:[&<>"'`])/g,(function(r){switch(r){case"&":return"&amp;";case"<":return"&lt;";case">":return"&gt;";case'"':return"&quot;";case"'":return"&#x27;";case"`":return"&#x60;";default:return r}}))},e.unescape=function(r){return r.replace(/&(amp|lt|gt|quot|#x27|#x60);/g,(function(r,t){switch(t){case"amp":return"&";case"lt":return"<";case"gt":return">";case"quot":return'"';case"#x27":return"'";case"#x60":return"`";default:return t}}))},e.use_strict=function(r){return"'use strict';\n"+r},e.to_fixed=function(r,t){return r.toFixed(t).replace(/(\.[0-9]*?)0+$/,"$1").replace(/\.$/,"")}},
function _(t,e,n,r,i){r();var o=t(1),a=t(145),s=function(t){this.document=t};n.DocumentEvent=s,s.__name__="DocumentEvent";var _=function(t){function e(e,n,r){var i=t.call(this,e)||this;return i.events=n,i.setter_id=r,i}return(0,o.__extends)(e,t),e}(s);n.DocumentEventBatch=_,_.__name__="DocumentEventBatch";var u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(e,t),e}(s);n.DocumentChangedEvent=u,u.__name__="DocumentChangedEvent";var l=function(t){function e(e,n,r){var i=t.call(this,e)||this;return i.msg_type=n,i.msg_data=r,i}return(0,o.__extends)(e,t),e.prototype[a.serialize]=function(t){var e=this.msg_data,n=t.to_serializable(e);return{kind:"MessageSent",msg_type:this.msg_type,msg_data:n}},e}(u);n.MessageSentEvent=l,l.__name__="MessageSentEvent";var d=function(t){function e(e,n,r,i,o,a,s){var _=t.call(this,e)||this;return _.model=n,_.attr=r,_.old=i,_.new_=o,_.setter_id=a,_.hint=s,_}return(0,o.__extends)(e,t),e.prototype[a.serialize]=function(t){if(null!=this.hint)return t.to_serializable(this.hint);var e=this.new_,n=t.to_serializable(e);return this.model!=e&&t.remove_def(this.model),{kind:"ModelChanged",model:this.model.ref(),attr:this.attr,new:n}},e}(u);n.ModelChangedEvent=d,d.__name__="ModelChangedEvent";var c=function(t){function e(e,n,r){var i=t.call(this,e)||this;return i.column_source=n,i.patches=r,i}return(0,o.__extends)(e,t),e.prototype[a.serialize]=function(t){return{kind:"ColumnsPatched",column_source:this.column_source,patches:this.patches}},e}(u);n.ColumnsPatchedEvent=c,c.__name__="ColumnsPatchedEvent";var h=function(t){function e(e,n,r,i){var o=t.call(this,e)||this;return o.column_source=n,o.data=r,o.rollover=i,o}return(0,o.__extends)(e,t),e.prototype[a.serialize]=function(t){return{kind:"ColumnsStreamed",column_source:this.column_source,data:this.data,rollover:this.rollover}},e}(u);n.ColumnsStreamedEvent=h,h.__name__="ColumnsStreamedEvent";var m=function(t){function e(e,n,r){var i=t.call(this,e)||this;return i.title=n,i.setter_id=r,i}return(0,o.__extends)(e,t),e.prototype[a.serialize]=function(t){return{kind:"TitleChanged",title:this.title}},e}(u);n.TitleChangedEvent=m,m.__name__="TitleChangedEvent";var v=function(t){function e(e,n,r){var i=t.call(this,e)||this;return i.model=n,i.setter_id=r,i}return(0,o.__extends)(e,t),e.prototype[a.serialize]=function(t){return{kind:"RootAdded",model:t.to_serializable(this.model)}},e}(u);n.RootAddedEvent=v,v.__name__="RootAddedEvent";var f=function(t){function e(e,n,r){var i=t.call(this,e)||this;return i.model=n,i.setter_id=r,i}return(0,o.__extends)(e,t),e.prototype[a.serialize]=function(t){return{kind:"RootRemoved",model:this.model.ref()}},e}(u);n.RootRemovedEvent=f,f.__name__="RootRemovedEvent"},
function _(t,r,n,i,e){i();var o=t(1),s=t(125),a=t(128);n.pretty=Symbol("pretty");var u=function(){function t(t){this.visited=new Set,this.precision=null==t?void 0:t.precision}return t.prototype.to_string=function(t){if((0,s.isObject)(t)){if(this.visited.has(t))return"<circular>";this.visited.add(t)}return function(t){return(0,s.isObject)(t)&&void 0!==t[n.pretty]}(t)?t[n.pretty](this):(0,s.isBoolean)(t)?this.boolean(t):(0,s.isNumber)(t)?this.number(t):(0,s.isString)(t)?this.string(t):(0,s.isArray)(t)?this.array(t):(0,s.isIterable)(t)?this.iterable(t):(0,s.isPlainObject)(t)?this.object(t):(0,s.isSymbol)(t)?this.symbol(t):""+t},t.prototype.token=function(t){return t},t.prototype.boolean=function(t){return""+t},t.prototype.number=function(t){return null!=this.precision?t.toFixed(this.precision):""+t},t.prototype.string=function(t){return'"'+t.replace(/'/g,"\\'")+'"'},t.prototype.symbol=function(t){return t.toString()},t.prototype.array=function(t){var r,n,i=this.token,e=[];try{for(var s=(0,o.__values)(t),a=s.next();!a.done;a=s.next()){var u=a.value;e.push(this.to_string(u))}}catch(t){r={error:t}}finally{try{a&&!a.done&&(n=s.return)&&n.call(s)}finally{if(r)throw r.error}}return""+i("[")+e.join(i(",")+" ")+i("]")},t.prototype.iterable=function(t){var r,n=this.token,i=null!==(r=Object(t)[Symbol.toStringTag])&&void 0!==r?r:"Object",e=this.array(t);return""+i+n("(")+e+n(")")},t.prototype.object=function(t){var r,n,i=this.token,e=[];try{for(var s=(0,o.__values)((0,a.entries)(t)),u=s.next();!u.done;u=s.next()){var l=(0,o.__read)(u.value,2),c=l[0],y=l[1];e.push(""+c+i(":")+" "+this.to_string(y))}}catch(t){r={error:t}}finally{try{u&&!u.done&&(n=s.return)&&n.call(s)}finally{if(r)throw r.error}}return""+i("{")+e.join(i(",")+" ")+i("}")},t}();n.Printer=u,u.__name__="Printer",n.to_string=function(t,r){return new u(r).to_string(t)}},
function _(r,n,e,t,o){t();var i=r(1),l=r(128),a=r(125);function c(r){return(0,a.isObject)(r)&&void 0!==r[e.clone]}e.clone=Symbol("clone"),e.is_Cloneable=c;var u=function(r){function n(){return null!==r&&r.apply(this,arguments)||this}return(0,i.__extends)(n,r),n}(Error);e.CloningError=u,u.__name__="CloningError";var f=function(){function r(){}return r.prototype.clone=function(r){var n,t;if(c(r))return r[e.clone](this);if((0,a.isArray)(r)){for(var o=r.length,f=new Array(o),s=0;s<o;s++){var _=r[s];f[s]=this.clone(_)}return f}if((0,a.isPlainObject)(r)){f={};try{for(var v=(0,i.__values)((0,l.entries)(r)),y=v.next();!y.done;y=v.next()){var h=(0,i.__read)(y.value,2),b=h[0];_=h[1];f[b]=this.clone(_)}}catch(r){n={error:r}}finally{try{y&&!y.done&&(t=v.return)&&t.call(v)}finally{if(n)throw n.error}}return f}if(null===r||(0,a.isBoolean)(r)||(0,a.isNumber)(r)||(0,a.isString)(r))return r;throw new u(Object.prototype.toString.call(r)+" is not cloneable")},r}();e.Cloner=f,f.__name__="Cloner"},
function _(r,t,_,a,o){a();var e=r(1);(0,e.__exportStar)(r(154),_),(0,e.__exportStar)(r(242),_),(0,e.__exportStar)(r(359),_),(0,e.__exportStar)(r(363),_),(0,e.__exportStar)(r(368),_),(0,e.__exportStar)(r(377),_),(0,e.__exportStar)(r(307),_),(0,e.__exportStar)(r(382),_),(0,e.__exportStar)(r(416),_),(0,e.__exportStar)(r(420),_),(0,e.__exportStar)(r(422),_),(0,e.__exportStar)(r(311),_),(0,e.__exportStar)(r(435),_),(0,e.__exportStar)(r(436),_),(0,e.__exportStar)(r(444),_),(0,e.__exportStar)(r(452),_),(0,e.__exportStar)(r(321),_),(0,e.__exportStar)(r(453),_),(0,e.__exportStar)(r(319),_),(0,e.__exportStar)(r(455),_),(0,e.__exportStar)(r(456),_),(0,e.__exportStar)(r(283),_),(0,e.__exportStar)(r(461),_),(0,e.__exportStar)(r(471),_),(0,e.__exportStar)(r(475),_)},
function _(e,o,n,a,t){a(),t("Annotation",e(155).Annotation),t("Arrow",e(183).Arrow),t("ArrowHead",e(227).ArrowHead),t("OpenHead",e(227).OpenHead),t("NormalHead",e(227).NormalHead),t("TeeHead",e(227).TeeHead),t("VeeHead",e(227).VeeHead),t("Band",e(229).Band),t("BoxAnnotation",e(231).BoxAnnotation),t("ColorBar",e(232).ColorBar),t("Label",e(327).Label),t("LabelSet",e(328).LabelSet),t("Legend",e(329).Legend),t("LegendItem",e(330).LegendItem),t("PolyAnnotation",e(332).PolyAnnotation),t("Slope",e(333).Slope),t("Span",e(334).Span),t("TextAnnotation",e(234).TextAnnotation),t("Title",e(233).Title),t("ToolbarPanel",e(335).ToolbarPanel),t("Tooltip",e(356).Tooltip),t("Whisker",e(358).Whisker)},
function _(t,e,n,i,o){i();var r,l=t(1),a=t(156),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,l.__extends)(e,t),e.prototype.get_size=function(){if(this.model.visible){var t=this._get_size(),e=t.width,n=t.height;return{width:Math.round(e),height:Math.round(n)}}return{width:0,height:0}},e.prototype._get_size=function(){throw new Error("not implemented")},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this);var n=this.model.properties;this.on_change(n.visible,(function(){null!=e.layout&&(e.layout.visible=e.model.visible,e.plot_view.request_layout())}))},Object.defineProperty(e.prototype,"needs_clip",{get:function(){return null==this.layout},enumerable:!1,configurable:!0}),e.prototype.serializable_state=function(){var e=t.prototype.serializable_state.call(this);return null==this.layout?e:(0,l.__assign)((0,l.__assign)({},e),{bbox:this.layout.bbox.box})},e}(a.RendererView);n.AnnotationView=s,s.__name__="AnnotationView";var u=function(t){function e(e){return t.call(this,e)||this}return(0,l.__extends)(e,t),e}(a.Renderer);n.Annotation=u,r=u,u.__name__="Annotation",r.override({level:"annotation"})},
function _(e,t,n,i,r){i();var o,a,l=e(1),s=e(157),u=(0,l.__importStar)(e(160)),_=e(135),p=e(168),c=e(169),f=function(e){function t(t){return e.call(this,t)||this}return(0,l.__extends)(t,e),t}(p.Model);n.RendererGroup=f,o=f,f.__name__="RendererGroup",o.define((function(e){return{visible:[e.Boolean,!0]}}));var d=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,l.__extends)(t,e),Object.defineProperty(t.prototype,"coordinates",{get:function(){var e=this._coordinates;return null!=e?e:this._coordinates=this._initialize_coordinates()},enumerable:!1,configurable:!0}),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.visuals=new u.Visuals(this),this.needs_webgl_blit=!1},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this);var n=this.model.properties,i=n.x_range_name,r=n.y_range_name;this.on_change([i,r],(function(){return t._initialize_coordinates()}));var o=this.model.group;null!=o&&this.on_change(o.properties.visible,(function(){t.model.visible=o.visible}))},t.prototype._initialize_coordinates=function(){var e=this.model.coordinates,t=this.plot_view.frame;if(null!=e)return e.get_transform(t);var n=this.model,i=n.x_range_name,r=n.y_range_name,o=t.x_scales.get(i),a=t.y_scales.get(r);return new c.CoordinateTransform(o,a)},Object.defineProperty(t.prototype,"plot_view",{get:function(){return this.parent},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"plot_model",{get:function(){return this.parent.model},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"layer",{get:function(){var e=this.canvas,t=e.overlays,n=e.primary;return"overlay"==this.model.level?t:n},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"canvas",{get:function(){return this.plot_view.canvas_view},enumerable:!1,configurable:!0}),t.prototype.request_render=function(){this.request_paint()},t.prototype.request_paint=function(){this.plot_view.request_paint(this)},t.prototype.request_layout=function(){this.plot_view.request_layout()},t.prototype.notify_finished=function(){this.plot_view.notify_finished()},t.prototype.notify_finished_after_paint=function(){this.plot_view.notify_finished_after_paint()},Object.defineProperty(t.prototype,"needs_clip",{get:function(){return!1},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"has_webgl",{get:function(){return!1},enumerable:!1,configurable:!0}),t.prototype.render=function(){this.model.visible&&this._render(),this._has_finished=!0},t.prototype.renderer_view=function(e){},t}(s.View);n.RendererView=d,d.__name__="RendererView";var h=function(e){function t(t){return e.call(this,t)||this}return(0,l.__extends)(t,e),t}(p.Model);n.Renderer=h,a=h,h.__name__="Renderer",a.define((function(e){var t=e.Boolean,n=e.String,i=e.Ref,r=e.Nullable;return{group:[r(i(f)),null],level:[_.RenderLevel,"image"],visible:[t,!0],x_range_name:[n,"default"],y_range_name:[n,"default"],coordinates:[r(i(c.CoordinateMapping)),null]}}))},
function _(t,e,i,n,o){n();var r=t(1),s=t(130),l=t(158),h=t(125),a=(0,r.__importDefault)(t(159)),u=function(){function t(t){this.removed=new s.Signal0(this,"removed"),this._ready=Promise.resolve(void 0),this._slots=new WeakMap,this._idle_notified=!1;var e=t.model,i=t.parent;this.model=e,this.parent=i,this.root=null==i?this:i.root,this.removed.emit()}return Object.defineProperty(t.prototype,"ready",{get:function(){return this._ready},enumerable:!1,configurable:!0}),t.prototype.connect=function(t,e){var i=this,n=this._slots.get(e);return null==n&&(n=function(t,n){var o=Promise.resolve(e.call(i,t,n));i._ready=i._ready.then((function(){return o}))},this._slots.set(e,n)),t.connect(n,this)},t.prototype.disconnect=function(t,e){return t.disconnect(e,this)},t.prototype.initialize=function(){var t,e;this._has_finished=!1,this.is_root&&(this._stylesheet=l.stylesheet);try{for(var i=(0,r.__values)(this.styles()),n=i.next();!n.done;n=i.next()){var o=n.value;this.stylesheet.append(o)}}catch(e){t={error:e}}finally{try{n&&!n.done&&(e=i.return)&&e.call(i)}finally{if(t)throw t.error}}},t.prototype.lazy_initialize=function(){return(0,r.__awaiter)(this,void 0,void 0,(function(){return(0,r.__generator)(this,(function(t){return[2]}))}))},t.prototype.remove=function(){this.disconnect_signals(),this.removed.emit()},t.prototype.toString=function(){return this.model.type+"View("+this.model.id+")"},t.prototype.serializable_state=function(){return{type:this.model.type}},Object.defineProperty(t.prototype,"is_root",{get:function(){return null==this.parent},enumerable:!1,configurable:!0}),t.prototype.has_finished=function(){return this._has_finished},Object.defineProperty(t.prototype,"is_idle",{get:function(){return this.has_finished()},enumerable:!1,configurable:!0}),t.prototype.connect_signals=function(){},t.prototype.disconnect_signals=function(){s.Signal.disconnect_receiver(this)},t.prototype.on_change=function(t,e){var i,n;try{for(var o=(0,r.__values)((0,h.isArray)(t)?t:[t]),s=o.next();!s.done;s=o.next()){var l=s.value;this.connect(l.change,e)}}catch(t){i={error:t}}finally{try{s&&!s.done&&(n=o.return)&&n.call(o)}finally{if(i)throw i.error}}},t.prototype.cursor=function(t,e){return null},Object.defineProperty(t.prototype,"stylesheet",{get:function(){return this.is_root?this._stylesheet:this.root.stylesheet},enumerable:!1,configurable:!0}),t.prototype.styles=function(){return[a.default]},t.prototype.notify_finished=function(){this.is_root?!this._idle_notified&&this.has_finished()&&null!=this.model.document&&(this._idle_notified=!0,this.model.document.notify_idle(this.model)):this.root.notify_finished()},t}();i.View=u,u.__name__="View"},
function _(e,t,r,n,i){n();var l=e(1),a=e(125),o=e(128),s=function(e){return function(t){var r,n,i,s,u,c,d,f,h,y,v,p;void 0===t&&(t={});for(var g=[],_=1;_<arguments.length;_++)g[_-1]=arguments[_];var m=document.createElement(e);m.classList.add("bk"),(0,a.isPlainObject)(t)||(g=(0,l.__spreadArray)([t],(0,l.__read)(g),!1),t={});try{for(var w=(0,l.__values)((0,o.entries)(t)),x=w.next();!x.done;x=w.next()){var b=(0,l.__read)(x.value,2),L=b[0],C=b[1];if(null!=C&&(!(0,a.isBoolean)(C)||C))if("class"===L&&((0,a.isString)(C)&&(C=C.split(/\s+/)),(0,a.isArray)(C)))try{for(var M=(i=void 0,(0,l.__values)(C)),E=M.next();!E.done;E=M.next()){var S=E.value;null!=S&&m.classList.add(S)}}catch(e){i={error:e}}finally{try{E&&!E.done&&(s=M.return)&&s.call(M)}finally{if(i)throw i.error}}else if("style"===L&&(0,a.isPlainObject)(C))try{for(var N=(u=void 0,(0,l.__values)((0,o.entries)(C))),A=N.next();!A.done;A=N.next()){var B=(0,l.__read)(A.value,2),T=B[0],O=B[1];m.style[T]=O}}catch(e){u={error:e}}finally{try{A&&!A.done&&(c=N.return)&&c.call(N)}finally{if(u)throw u.error}}else if("data"===L&&(0,a.isPlainObject)(C))try{for(var k=(d=void 0,(0,l.__values)((0,o.entries)(C))),D=k.next();!D.done;D=k.next()){var P=(0,l.__read)(D.value,2),R=P[0];O=P[1];m.dataset[R]=O}}catch(e){d={error:e}}finally{try{D&&!D.done&&(f=k.return)&&f.call(k)}finally{if(d)throw d.error}}else m.setAttribute(L,C)}}catch(e){r={error:e}}finally{try{x&&!x.done&&(n=w.return)&&n.call(w)}finally{if(r)throw r.error}}function z(e){var t,r;if((0,a.isString)(e))m.appendChild(document.createTextNode(e));else if(e instanceof Node)m.appendChild(e);else if(e instanceof NodeList||e instanceof HTMLCollection)try{for(var n=(0,l.__values)(e),i=n.next();!i.done;i=n.next()){var o=i.value;m.appendChild(o)}}catch(e){t={error:e}}finally{try{i&&!i.done&&(r=n.return)&&r.call(n)}finally{if(t)throw t.error}}else if(null!=e&&!1!==e)throw new Error("expected a DOM element, string, false or null, got "+JSON.stringify(e))}try{for(var W=(0,l.__values)(g),j=W.next();!j.done;j=W.next()){var U=j.value;if((0,a.isArray)(U))try{for(var H=(v=void 0,(0,l.__values)(U)),J=H.next();!J.done;J=H.next()){var K=J.value;z(K)}}catch(e){v={error:e}}finally{try{J&&!J.done&&(p=H.return)&&p.call(H)}finally{if(v)throw v.error}}else z(U)}}catch(e){h={error:e}}finally{try{j&&!j.done&&(y=W.return)&&y.call(W)}finally{if(h)throw h.error}}return m}};function u(e){var t=e.parentNode;null!=t&&t.removeChild(e)}function c(e){for(var t,r,n=[],i=1;i<arguments.length;i++)n[i-1]=arguments[i];var a=e.firstChild;try{for(var o=(0,l.__values)(n),s=o.next();!s.done;s=o.next()){var u=s.value;e.insertBefore(u,a)}}catch(e){t={error:e}}finally{try{s&&!s.done&&(r=o.return)&&r.call(o)}finally{if(t)throw t.error}}}function d(e,t){var r,n,i,l=Element.prototype;return(null!==(i=null!==(n=null!==(r=l.matches)&&void 0!==r?r:l.webkitMatchesSelector)&&void 0!==n?n:l.mozMatchesSelector)&&void 0!==i?i:l.msMatchesSelector).call(e,t)}function f(e){return parseFloat(e)||0}function h(e){var t=getComputedStyle(e);return{border:{top:f(t.borderTopWidth),bottom:f(t.borderBottomWidth),left:f(t.borderLeftWidth),right:f(t.borderRightWidth)},margin:{top:f(t.marginTop),bottom:f(t.marginBottom),left:f(t.marginLeft),right:f(t.marginRight)},padding:{top:f(t.paddingTop),bottom:f(t.paddingBottom),left:f(t.paddingLeft),right:f(t.paddingRight)}}}function y(e){var t=e.getBoundingClientRect();return{width:Math.ceil(t.width),height:Math.ceil(t.height)}}r.createElement=function(e,t){for(var r=[],n=2;n<arguments.length;n++)r[n-2]=arguments[n];return s(e).apply(void 0,(0,l.__spreadArray)([t],(0,l.__read)(r),!1))},r.div=s("div"),r.span=s("span"),r.canvas=s("canvas"),r.link=s("link"),r.style=s("style"),r.a=s("a"),r.p=s("p"),r.i=s("i"),r.pre=s("pre"),r.button=s("button"),r.label=s("label"),r.input=s("input"),r.select=s("select"),r.option=s("option"),r.optgroup=s("optgroup"),r.textarea=s("textarea"),r.createSVGElement=function(e,t){for(var r,n,i,s,u,c,d=[],f=2;f<arguments.length;f++)d[f-2]=arguments[f];var h=document.createElementNS("http://www.w3.org/2000/svg",e);try{for(var y=(0,l.__values)((0,o.entries)(null!=t?t:{})),v=y.next();!v.done;v=y.next()){var p=(0,l.__read)(v.value,2),g=p[0],_=p[1];null==_||(0,a.isBoolean)(_)&&!_||h.setAttribute(g,_)}}catch(e){r={error:e}}finally{try{v&&!v.done&&(n=y.return)&&n.call(y)}finally{if(r)throw r.error}}function m(e){var t,r;if((0,a.isString)(e))h.appendChild(document.createTextNode(e));else if(e instanceof Node)h.appendChild(e);else if(e instanceof NodeList||e instanceof HTMLCollection)try{for(var n=(0,l.__values)(e),i=n.next();!i.done;i=n.next()){var o=i.value;h.appendChild(o)}}catch(e){t={error:e}}finally{try{i&&!i.done&&(r=n.return)&&r.call(n)}finally{if(t)throw t.error}}else if(null!=e&&!1!==e)throw new Error("expected a DOM element, string, false or null, got "+JSON.stringify(e))}try{for(var w=(0,l.__values)(d),x=w.next();!x.done;x=w.next()){var b=x.value;if((0,a.isArray)(b))try{for(var L=(u=void 0,(0,l.__values)(b)),C=L.next();!C.done;C=L.next()){var M=C.value;m(M)}}catch(e){u={error:e}}finally{try{C&&!C.done&&(c=L.return)&&c.call(L)}finally{if(u)throw u.error}}else m(b)}}catch(e){i={error:e}}finally{try{x&&!x.done&&(s=w.return)&&s.call(w)}finally{if(i)throw i.error}}return h},r.nbsp=function(){return document.createTextNode("\xa0")},r.append=function(e){for(var t,r,n=[],i=1;i<arguments.length;i++)n[i-1]=arguments[i];try{for(var a=(0,l.__values)(n),o=a.next();!o.done;o=a.next()){var s=o.value;e.appendChild(s)}}catch(e){t={error:e}}finally{try{o&&!o.done&&(r=a.return)&&r.call(a)}finally{if(t)throw t.error}}},r.remove=u,r.removeElement=u,r.replaceWith=function(e,t){var r=e.parentNode;null!=r&&r.replaceChild(t,e)},r.prepend=c,r.empty=function(e,t){var r,n,i;for(void 0===t&&(t=!1);i=e.firstChild;)e.removeChild(i);if(t&&e instanceof Element)try{for(var a=(0,l.__values)(e.attributes),o=a.next();!o.done;o=a.next()){var s=o.value;e.removeAttributeNode(s)}}catch(e){r={error:e}}finally{try{o&&!o.done&&(n=a.return)&&n.call(a)}finally{if(r)throw r.error}}},r.display=function(e){e.style.display=""},r.undisplay=function(e){e.style.display="none"},r.show=function(e){e.style.visibility=""},r.hide=function(e){e.style.visibility="hidden"},r.offset=function(e){var t=e.getBoundingClientRect();return{top:t.top+window.pageYOffset-document.documentElement.clientTop,left:t.left+window.pageXOffset-document.documentElement.clientLeft}},r.matches=d,r.parent=function(e,t){for(var r=e;r=r.parentElement;)if(d(r,t))return r;return null},r.extents=h,r.size=y,r.scroll_size=function(e){return{width:Math.ceil(e.scrollWidth),height:Math.ceil(e.scrollHeight)}},r.outer_size=function(e){var t=h(e).margin,r=t.left,n=t.right,i=t.top,l=t.bottom,a=y(e),o=a.width,s=a.height;return{width:Math.ceil(o+r+n),height:Math.ceil(s+i+l)}},r.content_size=function(e){var t,r,n=e.getBoundingClientRect(),i=n.left,a=n.top,o=h(e).padding,s=0,u=0;try{for(var c=(0,l.__values)(e.children),d=c.next();!d.done;d=c.next()){var f=d.value.getBoundingClientRect();s=Math.max(s,Math.ceil(f.left-i-o.left+f.width)),u=Math.max(u,Math.ceil(f.top-a-o.top+f.height))}}catch(e){t={error:e}}finally{try{d&&!d.done&&(r=c.return)&&r.call(c)}finally{if(t)throw t.error}}return{width:s,height:u}},r.position=function(e,t,r){var n=e.style;if(n.left=t.x+"px",n.top=t.y+"px",n.width=t.width+"px",n.height=t.height+"px",null==r)n.margin="";else{var i=r.top,l=r.right,a=r.bottom,o=r.left;n.margin=i+"px "+l+"px "+a+"px "+o+"px"}},r.children=function(e){return Array.from(e.children)};var v,p=function(){function e(e){this.el=e,this.classList=e.classList}return Object.defineProperty(e.prototype,"values",{get:function(){for(var e=[],t=0;t<this.classList.length;t++){var r=this.classList.item(t);null!=r&&e.push(r)}return e},enumerable:!1,configurable:!0}),e.prototype.has=function(e){return this.classList.contains(e)},e.prototype.add=function(){for(var e,t,r=[],n=0;n<arguments.length;n++)r[n]=arguments[n];try{for(var i=(0,l.__values)(r),a=i.next();!a.done;a=i.next()){var o=a.value;this.classList.add(o)}}catch(t){e={error:t}}finally{try{a&&!a.done&&(t=i.return)&&t.call(i)}finally{if(e)throw e.error}}return this},e.prototype.remove=function(){for(var e,t,r=[],n=0;n<arguments.length;n++)r[n]=arguments[n];try{for(var i=(0,l.__values)(r),a=i.next();!a.done;a=i.next()){var o=a.value;this.classList.remove(o)}}catch(t){e={error:t}}finally{try{a&&!a.done&&(t=i.return)&&t.call(i)}finally{if(e)throw e.error}}return this},e.prototype.clear=function(){var e,t;try{for(var r=(0,l.__values)(this.values),n=r.next();!n.done;n=r.next()){var i=n.value;"bk"!=i&&this.classList.remove(i)}}catch(t){e={error:t}}finally{try{n&&!n.done&&(t=r.return)&&t.call(r)}finally{if(e)throw e.error}}return this},e.prototype.toggle=function(e,t){return(null!=t?t:!this.has(e))?this.add(e):this.remove(e),this},e}();function g(e,t,r){var n=e.style,i=n.width,l=n.height,a=n.position,o=n.display;e.style.position="absolute",e.style.display="",e.style.width=null!=t.width&&t.width!=1/0?t.width+"px":"auto",e.style.height=null!=t.height&&t.height!=1/0?t.height+"px":"auto";try{return r()}finally{e.style.position=a,e.style.display=o,e.style.width=i,e.style.height=l}}r.ClassList=p,p.__name__="ClassList",r.classes=function(e){return new p(e)},r.toggle_attribute=function(e,t,r){null==r&&(r=!e.hasAttribute(t)),r?e.setAttribute(t,"true"):e.removeAttribute(t)},(v=r.Keys||(r.Keys={}))[v.Backspace=8]="Backspace",v[v.Tab=9]="Tab",v[v.Enter=13]="Enter",v[v.Esc=27]="Esc",v[v.PageUp=33]="PageUp",v[v.PageDown=34]="PageDown",v[v.Left=37]="Left",v[v.Up=38]="Up",v[v.Right=39]="Right",v[v.Down=40]="Down",v[v.Delete=46]="Delete",r.undisplayed=function(e,t){var r=e.style.display;e.style.display="none";try{return t()}finally{e.style.display=r}},r.unsized=function(e,t){return g(e,{},t)},r.sized=g;var _=function(){function e(e){this.root=e,this.known=new Set,this.style=(0,r.style)({type:"text/css"}),c(e,this.style)}return e.prototype.append=function(e){this.known.has(e)||(this.style.appendChild(document.createTextNode(e)),this.known.add(e))},e}();r.StyleSheet=_,_.__name__="StyleSheet",r.stylesheet=new _(document.head),r.dom_ready=function(){return(0,l.__awaiter)(this,void 0,void 0,(function(){return(0,l.__generator)(this,(function(e){return"loading"==document.readyState?[2,new Promise((function(e,t){document.addEventListener("DOMContentLoaded",(function(){return e()}),{once:!0})}))]:[2]}))}))}},
function _(o,i,t,e,r){e(),t.root="bk-root",t.default=".bk-root{position:relative;width:auto;height:auto;box-sizing:border-box;font-family:Helvetica, Arial, sans-serif;font-size:13px;}.bk-root .bk,.bk-root .bk:before,.bk-root .bk:after{box-sizing:inherit;margin:0;border:0;padding:0;background-image:none;font-family:inherit;font-size:100%;line-height:1.42857143;}.bk-root pre.bk{font-family:Courier, monospace;}"},
function _(e,r,a,t,n){t();var c=e(1),l=e(161);n("Line",l.Line),n("LineScalar",l.LineScalar),n("LineVector",l.LineVector);var i=e(164);n("Fill",i.Fill),n("FillScalar",i.FillScalar),n("FillVector",i.FillVector);var o=e(165);n("Text",o.Text),n("TextScalar",o.TextScalar),n("TextVector",o.TextVector);var s=e(166);n("Hatch",s.Hatch),n("HatchScalar",s.HatchScalar),n("HatchVector",s.HatchVector);var u=(0,c.__importStar)(e(163)),V=e(162);n("VisualProperties",V.VisualProperties),n("VisualUniforms",V.VisualUniforms);var h=function(){function e(e){var r,a;this._visuals=[];var t=function(r,a){var t=function(){switch(a){case u.Line:return new l.Line(e,r);case u.LineScalar:return new l.LineScalar(e,r);case u.LineVector:return new l.LineVector(e,r);case u.Fill:return new i.Fill(e,r);case u.FillScalar:return new i.FillScalar(e,r);case u.FillVector:return new i.FillVector(e,r);case u.Text:return new o.Text(e,r);case u.TextScalar:return new o.TextScalar(e,r);case u.TextVector:return new o.TextVector(e,r);case u.Hatch:return new s.Hatch(e,r);case u.HatchScalar:return new s.HatchScalar(e,r);case u.HatchVector:return new s.HatchVector(e,r);default:throw new Error("unknown visual")}}();t instanceof V.VisualProperties&&t.update(),n._visuals.push(t),Object.defineProperty(n,r+t.type,{get:function(){return t},configurable:!1,enumerable:!0})},n=this;try{for(var h=(0,c.__values)(e.model._mixins),_=h.next();!_.done;_=h.next()){var f=(0,c.__read)(_.value,2);t(f[0],f[1])}}catch(e){r={error:e}}finally{try{_&&!_.done&&(a=h.return)&&a.call(h)}finally{if(r)throw r.error}}}return e.prototype[Symbol.iterator]=function(){return(0,c.__generator)(this,(function(e){switch(e.label){case 0:return[5,(0,c.__values)(this._visuals)];case 1:return e.sent(),[2]}}))},e}();a.Visuals=h,h.__name__="Visuals"},
function _(e,t,i,l,n){l();var a=e(1),s=e(162),r=(0,a.__importStar)(e(163)),o=e(137),h=e(125);function _(e){if((0,h.isArray)(e))return e;switch(e){case"solid":return[];case"dashed":return[6];case"dotted":return[2,4];case"dotdash":return[2,4,6,4];case"dashdot":return[6,4,2,4];default:return e.split(" ").map(Number).filter(h.isInteger)}}i.resolve_line_dash=_;var u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(t,e),Object.defineProperty(t.prototype,"doit",{get:function(){var e=this.line_color.get_value(),t=this.line_alpha.get_value(),i=this.line_width.get_value();return!(null==e||0==t||0==i)},enumerable:!1,configurable:!0}),t.prototype.apply=function(e){var t=this.doit;return t&&(this.set_value(e),e.stroke()),t},t.prototype.values=function(){return{color:this.line_color.get_value(),alpha:this.line_alpha.get_value(),width:this.line_width.get_value(),join:this.line_join.get_value(),cap:this.line_cap.get_value(),dash:this.line_dash.get_value(),offset:this.line_dash_offset.get_value()}},t.prototype.set_value=function(e){var t=this.line_color.get_value(),i=this.line_alpha.get_value();e.strokeStyle=(0,o.color2css)(t,i),e.lineWidth=this.line_width.get_value(),e.lineJoin=this.line_join.get_value(),e.lineCap=this.line_cap.get_value(),e.lineDash=_(this.line_dash.get_value()),e.lineDashOffset=this.line_dash_offset.get_value()},t}(s.VisualProperties);i.Line=u,u.__name__="Line";var p=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(t,e),Object.defineProperty(t.prototype,"doit",{get:function(){var e=this.line_color.value,t=this.line_alpha.value,i=this.line_width.value;return!(0==e||0==t||0==i)},enumerable:!1,configurable:!0}),t.prototype.apply=function(e){var t=this.doit;return t&&(this.set_value(e),e.stroke()),t},t.prototype.values=function(){return{color:this.line_color.value,alpha:this.line_alpha.value,width:this.line_width.value,join:this.line_join.value,cap:this.line_cap.value,dash:this.line_dash.value,offset:this.line_dash_offset.value}},t.prototype.set_value=function(e){var t=this.line_color.value,i=this.line_alpha.value;e.strokeStyle=(0,o.color2css)(t,i),e.lineWidth=this.line_width.value,e.lineJoin=this.line_join.value,e.lineCap=this.line_cap.value,e.lineDash=_(this.line_dash.value),e.lineDashOffset=this.line_dash_offset.value},t}(s.VisualUniforms);i.LineScalar=p,p.__name__="LineScalar";var c=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(t,e),Object.defineProperty(t.prototype,"doit",{get:function(){var e=this.line_color;if(e.is_Scalar()&&0==e.value)return!1;var t=this.line_alpha;if(t.is_Scalar()&&0==t.value)return!1;var i=this.line_width;return!i.is_Scalar()||0!=i.value},enumerable:!1,configurable:!0}),t.prototype.apply=function(e,t){var i=this.doit;return i&&(this.set_vectorize(e,t),e.stroke()),i},t.prototype.values=function(e){return{color:this.line_color.get(e),alpha:this.line_alpha.get(e),width:this.line_width.get(e),join:this.line_join.get(e),cap:this.line_cap.get(e),dash:this.line_dash.get(e),offset:this.line_dash_offset.get(e)}},t.prototype.set_vectorize=function(e,t){var i=this.line_color.get(t),l=this.line_alpha.get(t),n=this.line_width.get(t),a=this.line_join.get(t),s=this.line_cap.get(t),r=this.line_dash.get(t),h=this.line_dash_offset.get(t);e.strokeStyle=(0,o.color2css)(i,l),e.lineWidth=n,e.lineJoin=a,e.lineCap=s,e.lineDash=_(r),e.lineDashOffset=h},t}(s.VisualUniforms);i.LineVector=c,c.__name__="LineVector",u.prototype.type="line",u.prototype.attrs=Object.keys(r.Line),p.prototype.type="line",p.prototype.attrs=Object.keys(r.LineScalar),c.prototype.type="line",c.prototype.attrs=Object.keys(r.LineVector)},
function _(r,t,e,n,o){n();var i=r(1),a=function(){function r(r,t){var e,n,o=this;void 0===t&&(t=""),this.obj=r,this.prefix=t;this._props=[];try{for(var a=(0,i.__values)(this.attrs),s=a.next();!s.done;s=a.next()){var u=s.value,l=r.model.properties[t+u];l.change.connect((function(){return o.update()})),this[u]=l,this._props.push(l)}}catch(r){e={error:r}}finally{try{s&&!s.done&&(n=a.return)&&n.call(a)}finally{if(e)throw e.error}}}return r.prototype[Symbol.iterator]=function(){return(0,i.__generator)(this,(function(r){switch(r.label){case 0:return[5,(0,i.__values)(this._props)];case 1:return r.sent(),[2]}}))},r.prototype.update=function(){},r}();e.VisualProperties=a,a.__name__="VisualProperties";var s=function(){function r(r,t){var e,n;void 0===t&&(t=""),this.obj=r,this.prefix=t;var o=function(e){Object.defineProperty(a,e,{get:function(){return r[t+e]}})},a=this;try{for(var s=(0,i.__values)(this.attrs),u=s.next();!u.done;u=s.next()){o(u.value)}}catch(r){e={error:r}}finally{try{u&&!u.done&&(n=s.return)&&n.call(s)}finally{if(e)throw e.error}}}return r.prototype[Symbol.iterator]=function(){var r,t,e,n,o,a;return(0,i.__generator)(this,(function(s){switch(s.label){case 0:s.trys.push([0,5,6,7]),r=(0,i.__values)(this.attrs),t=r.next(),s.label=1;case 1:return t.done?[3,4]:(e=t.value,[4,this.obj.model.properties[this.prefix+e]]);case 2:s.sent(),s.label=3;case 3:return t=r.next(),[3,1];case 4:return[3,7];case 5:return n=s.sent(),o={error:n},[3,7];case 6:try{t&&!t.done&&(a=r.return)&&a.call(r)}finally{if(o)throw o.error}return[7];case 7:return[2]}}))},r.prototype.update=function(){},r}();e.VisualUniforms=s,s.__name__="VisualUniforms"},
function _(e,l,a,t,r){t();var c=e(1),n=(0,c.__importStar)(e(133)),o=e(135),i=(0,c.__importStar)(e(136)),_=e(128);a.Line={line_color:[i.Nullable(i.Color),"black"],line_alpha:[i.Alpha,1],line_width:[i.Number,1],line_join:[o.LineJoin,"bevel"],line_cap:[o.LineCap,"butt"],line_dash:[i.Or(o.LineDash,i.Array(i.Number)),[]],line_dash_offset:[i.Number,0]},a.Fill={fill_color:[i.Nullable(i.Color),"gray"],fill_alpha:[i.Alpha,1]},a.Hatch={hatch_color:[i.Nullable(i.Color),"black"],hatch_alpha:[i.Alpha,1],hatch_scale:[i.Number,12],hatch_pattern:[i.Nullable(i.Or(o.HatchPatternType,i.String)),null],hatch_weight:[i.Number,1],hatch_extra:[i.Dict(i.AnyRef()),{}]},a.Text={text_color:[i.Nullable(i.Color),"#444444"],text_alpha:[i.Alpha,1],text_font:[n.Font,"helvetica"],text_font_size:[i.FontSize,"16px"],text_font_style:[o.FontStyle,"normal"],text_align:[o.TextAlign,"left"],text_baseline:[o.TextBaseline,"bottom"],text_line_height:[i.Number,1.2]},a.LineScalar={line_color:[n.ColorScalar,"black"],line_alpha:[n.NumberScalar,1],line_width:[n.NumberScalar,1],line_join:[n.LineJoinScalar,"bevel"],line_cap:[n.LineCapScalar,"butt"],line_dash:[n.LineDashScalar,[]],line_dash_offset:[n.NumberScalar,0]},a.FillScalar={fill_color:[n.ColorScalar,"gray"],fill_alpha:[n.NumberScalar,1]},a.HatchScalar={hatch_color:[n.ColorScalar,"black"],hatch_alpha:[n.NumberScalar,1],hatch_scale:[n.NumberScalar,12],hatch_pattern:[n.NullStringScalar,null],hatch_weight:[n.NumberScalar,1],hatch_extra:[n.AnyScalar,{}]},a.TextScalar={text_color:[n.ColorScalar,"#444444"],text_alpha:[n.NumberScalar,1],text_font:[n.FontScalar,"helvetica"],text_font_size:[n.FontSizeScalar,"16px"],text_font_style:[n.FontStyleScalar,"normal"],text_align:[n.TextAlignScalar,"left"],text_baseline:[n.TextBaselineScalar,"bottom"],text_line_height:[n.NumberScalar,1.2]},a.LineVector={line_color:[n.ColorSpec,"black"],line_alpha:[n.NumberSpec,1],line_width:[n.NumberSpec,1],line_join:[n.LineJoinSpec,"bevel"],line_cap:[n.LineCapSpec,"butt"],line_dash:[n.LineDashSpec,[]],line_dash_offset:[n.NumberSpec,0]},a.FillVector={fill_color:[n.ColorSpec,"gray"],fill_alpha:[n.NumberSpec,1]},a.HatchVector={hatch_color:[n.ColorSpec,"black"],hatch_alpha:[n.NumberSpec,1],hatch_scale:[n.NumberSpec,12],hatch_pattern:[n.NullStringSpec,null],hatch_weight:[n.NumberSpec,1],hatch_extra:[n.AnyScalar,{}]},a.TextVector={text_color:[n.ColorSpec,"#444444"],text_alpha:[n.NumberSpec,1],text_font:[n.FontSpec,"helvetica"],text_font_size:[n.FontSizeSpec,"16px"],text_font_style:[n.FontStyleSpec,"normal"],text_align:[n.TextAlignSpec,"left"],text_baseline:[n.TextBaselineSpec,"bottom"],text_line_height:[n.NumberSpec,1.2]},a.attrs_of=function(e,l,a,t){var r,n;void 0===t&&(t=!1);var o={};try{for(var i=(0,c.__values)((0,_.keys)(a)),h=i.next();!h.done;h=i.next()){var S=h.value,p=""+l+S,b=e[p];o[t?p:S]=b}}catch(e){r={error:e}}finally{try{h&&!h.done&&(n=i.return)&&n.call(i)}finally{if(r)throw r.error}}return o}},
function _(t,l,e,i,r){i();var o=t(1),a=t(162),n=(0,o.__importStar)(t(163)),u=t(137),p=function(t){function l(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(l,t),Object.defineProperty(l.prototype,"doit",{get:function(){var t=this.fill_color.get_value(),l=this.fill_alpha.get_value();return!(null==t||0==l)},enumerable:!1,configurable:!0}),l.prototype.apply=function(t,l){var e=this.doit;return e&&(this.set_value(t),t.fill(l)),e},l.prototype.values=function(){return{color:this.fill_color.get_value(),alpha:this.fill_alpha.get_value()}},l.prototype.set_value=function(t){var l=this.fill_color.get_value(),e=this.fill_alpha.get_value();t.fillStyle=(0,u.color2css)(l,e)},l}(a.VisualProperties);e.Fill=p,p.__name__="Fill";var s=function(t){function l(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(l,t),Object.defineProperty(l.prototype,"doit",{get:function(){var t=this.fill_color.value,l=this.fill_alpha.value;return!(0==t||0==l)},enumerable:!1,configurable:!0}),l.prototype.apply=function(t,l){var e=this.doit;return e&&(this.set_value(t),t.fill(l)),e},l.prototype.values=function(){return{color:this.fill_color.value,alpha:this.fill_alpha.value}},l.prototype.set_value=function(t){var l=this.fill_color.value,e=this.fill_alpha.value;t.fillStyle=(0,u.color2css)(l,e)},l}(a.VisualUniforms);e.FillScalar=s,s.__name__="FillScalar";var c=function(t){function l(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(l,t),Object.defineProperty(l.prototype,"doit",{get:function(){var t=this.fill_color;if(t.is_Scalar()&&0==t.value)return!1;var l=this.fill_alpha;return!l.is_Scalar()||0!=l.value},enumerable:!1,configurable:!0}),l.prototype.apply=function(t,l,e){var i=this.doit;return i&&(this.set_vectorize(t,l),t.fill(e)),i},l.prototype.values=function(t){return{color:this.fill_color.get(t),alpha:this.fill_alpha.get(t)}},l.prototype.set_vectorize=function(t,l){var e=this.fill_color.get(l),i=this.fill_alpha.get(l);t.fillStyle=(0,u.color2css)(e,i)},l}(a.VisualUniforms);e.FillVector=c,c.__name__="FillVector",p.prototype.type="fill",p.prototype.attrs=Object.keys(n.Fill),s.prototype.type="fill",s.prototype.attrs=Object.keys(n.FillScalar),c.prototype.type="fill",c.prototype.attrs=Object.keys(n.FillVector)},
function _(t,e,i,l,n){l();var o=t(1),a=t(162),_=(0,o.__importStar)(t(163)),s=t(137),r=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(e,t),Object.defineProperty(e.prototype,"doit",{get:function(){var t=this.text_color.get_value(),e=this.text_alpha.get_value();return!(null==t||0==e)},enumerable:!1,configurable:!0}),e.prototype.values=function(){return{color:this.text_color.get_value(),alpha:this.text_alpha.get_value(),font:this.text_font.get_value(),font_size:this.text_font_size.get_value(),font_style:this.text_font_style.get_value(),align:this.text_align.get_value(),baseline:this.text_baseline.get_value(),line_height:this.text_line_height.get_value()}},e.prototype.set_value=function(t){var e=this.text_color.get_value(),i=this.text_alpha.get_value();t.fillStyle=(0,s.color2css)(e,i),t.font=this.font_value(),t.textAlign=this.text_align.get_value(),t.textBaseline=this.text_baseline.get_value()},e.prototype.font_value=function(){return this.text_font_style.get_value()+" "+this.text_font_size.get_value()+" "+this.text_font.get_value()},e}(a.VisualProperties);i.Text=r,r.__name__="Text";var u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(e,t),Object.defineProperty(e.prototype,"doit",{get:function(){var t=this.text_color.value,e=this.text_alpha.value;return!(0==t||0==e)},enumerable:!1,configurable:!0}),e.prototype.values=function(){return{color:this.text_color.value,alpha:this.text_alpha.value,font:this.text_font.value,font_size:this.text_font_size.value,font_style:this.text_font_style.value,align:this.text_align.value,baseline:this.text_baseline.value,line_height:this.text_line_height.value}},e.prototype.set_value=function(t){var e=this.text_color.value,i=this.text_alpha.value,l=this.font_value(),n=this.text_align.value,o=this.text_baseline.value;t.fillStyle=(0,s.color2css)(e,i),t.font=l,t.textAlign=n,t.textBaseline=o},e.prototype.font_value=function(){return this.text_font_style.value+" "+this.text_font_size.value+" "+this.text_font.value},e}(a.VisualUniforms);i.TextScalar=u,u.__name__="TextScalar";var h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(e,t),e.prototype.values=function(t){return{color:this.text_color.get(t),alpha:this.text_alpha.get(t),font:this.text_font.get(t),font_size:this.text_font_size.get(t),font_style:this.text_font_style.get(t),align:this.text_align.get(t),baseline:this.text_baseline.get(t),line_height:this.text_line_height.get(t)}},Object.defineProperty(e.prototype,"doit",{get:function(){var t=this.text_color;if(t.is_Scalar()&&0==t.value)return!1;var e=this.text_alpha;return!e.is_Scalar()||0!=e.value},enumerable:!1,configurable:!0}),e.prototype.set_vectorize=function(t,e){var i=this.text_color.get(e),l=this.text_alpha.get(e),n=this.font_value(e),o=this.text_align.get(e),a=this.text_baseline.get(e);t.fillStyle=(0,s.color2css)(i,l),t.font=n,t.textAlign=o,t.textBaseline=a},e.prototype.font_value=function(t){return this.text_font_style.get(t)+" "+this.text_font_size.get(t)+" "+this.text_font.get(t)},e}(a.VisualUniforms);i.TextVector=h,h.__name__="TextVector",r.prototype.type="text",r.prototype.attrs=Object.keys(_.Text),u.prototype.type="text",u.prototype.attrs=Object.keys(_.TextScalar),h.prototype.type="text",h.prototype.attrs=Object.keys(_.TextVector)},
function _(t,e,a,r,i){r();var n=t(1),h=t(162),o=t(167),_=(0,n.__importStar)(t(133)),c=(0,n.__importStar)(t(163)),l=function(t){function e(){var e=t.apply(this,(0,n.__spreadArray)([],(0,n.__read)(arguments),!1))||this;return e._update_iteration=0,e}return(0,n.__extends)(e,t),e.prototype.update=function(){var t=this;if(this._update_iteration++,this._hatch_image=null,this.doit){var e=this.hatch_color.get_value(),a=this.hatch_alpha.get_value(),r=this.hatch_scale.get_value(),i=this.hatch_pattern.get_value(),n=this.hatch_weight.get_value(),h=function(e){t._hatch_image=e},_=this.hatch_extra.get_value()[i];if(null!=_){if((s=_.get_pattern(e,a,r,n))instanceof Promise){var c=this._update_iteration;s.then((function(e){t._update_iteration==c&&(h(e),t.obj.request_render())}))}else h(s)}else{var l=this.obj.canvas.create_layer(),s=(0,o.get_pattern)(l,i,e,a,r,n);h(s)}}},Object.defineProperty(e.prototype,"doit",{get:function(){var t=this.hatch_color.get_value(),e=this.hatch_alpha.get_value(),a=this.hatch_pattern.get_value();return!(null==t||0==e||" "==a||"blank"==a||null==a)},enumerable:!1,configurable:!0}),e.prototype.apply=function(t,e){var a=this.doit;return a&&(this.set_value(t),t.layer.undo_transform((function(){return t.fill(e)}))),a},e.prototype.set_value=function(t){var e=this.pattern(t);t.fillStyle=null!=e?e:"transparent"},e.prototype.pattern=function(t){var e=this._hatch_image;return null==e?null:t.createPattern(e,this.repetition())},e.prototype.repetition=function(){var t=this.hatch_pattern.get_value(),e=this.hatch_extra.get_value()[t];if(null==e)return"repeat";switch(e.repetition){case"repeat":return"repeat";case"repeat_x":return"repeat-x";case"repeat_y":return"repeat-y";case"no_repeat":return"no-repeat"}},e}(h.VisualProperties);a.Hatch=l,l.__name__="Hatch";var s=function(t){function e(){var e=t.apply(this,(0,n.__spreadArray)([],(0,n.__read)(arguments),!1))||this;return e._static_doit=!1,e._update_iteration=0,e}return(0,n.__extends)(e,t),e.prototype._compute_static_doit=function(){var t=this.hatch_color.value,e=this.hatch_alpha.value,a=this.hatch_pattern.value;return!(null==t||0==e||" "==a||"blank"==a||null==a)},e.prototype.update=function(){var t=this;this._update_iteration++;var e=this.hatch_color.length;if(this._hatch_image=new _.UniformScalar(null,e),this._static_doit=this._compute_static_doit(),this._static_doit){var a=this.hatch_color.value,r=this.hatch_alpha.value,i=this.hatch_scale.value,n=this.hatch_pattern.value,h=this.hatch_weight.value,c=function(a){t._hatch_image=new _.UniformScalar(a,e)},l=this.hatch_extra.value[n];if(null!=l){if((p=l.get_pattern(a,r,i,h))instanceof Promise){var s=this._update_iteration;p.then((function(e){t._update_iteration==s&&(c(e),t.obj.request_render())}))}else c(p)}else{var u=this.obj.canvas.create_layer(),p=(0,o.get_pattern)(u,n,a,r,i,h);c(p)}}},Object.defineProperty(e.prototype,"doit",{get:function(){return this._static_doit},enumerable:!1,configurable:!0}),e.prototype.apply=function(t,e){var a=this.doit;return a&&(this.set_value(t),t.layer.undo_transform((function(){return t.fill(e)}))),a},e.prototype.set_value=function(t){var e;t.fillStyle=null!==(e=this.pattern(t))&&void 0!==e?e:"transparent"},e.prototype.pattern=function(t){var e=this._hatch_image.value;return null==e?null:t.createPattern(e,this.repetition())},e.prototype.repetition=function(){var t=this.hatch_pattern.value,e=this.hatch_extra.value[t];if(null==e)return"repeat";switch(e.repetition){case"repeat":return"repeat";case"repeat_x":return"repeat-x";case"repeat_y":return"repeat-y";case"no_repeat":return"no-repeat"}},e}(h.VisualUniforms);a.HatchScalar=s,s.__name__="HatchScalar";var u=function(t){function e(){var e=t.apply(this,(0,n.__spreadArray)([],(0,n.__read)(arguments),!1))||this;return e._static_doit=!1,e._update_iteration=0,e}return(0,n.__extends)(e,t),e.prototype._compute_static_doit=function(){var t=this.hatch_color;if(t.is_Scalar()&&0==t.value)return!1;var e=this.hatch_alpha;if(e.is_Scalar()&&0==e.value)return!1;var a=this.hatch_pattern;if(a.is_Scalar()){var r=a.value;if(" "==r||"blank"==r||null==r)return!1}return!0},e.prototype.update=function(){var t=this;this._update_iteration++;var e=this.hatch_color.length;if(this._hatch_image=new _.UniformScalar(null,e),this._static_doit=this._compute_static_doit(),this._static_doit){var a=function(e,a,r,i,n,h){var _=t.hatch_extra.value[e];if(null!=_){if((s=_.get_pattern(a,r,i,n))instanceof Promise){var c=t._update_iteration;s.then((function(e){t._update_iteration==c&&(h(e),t.obj.request_render())}))}else h(s)}else{var l=t.obj.canvas.create_layer(),s=(0,o.get_pattern)(l,e,a,r,i,n);h(s)}};if(this.hatch_color.is_Scalar()&&this.hatch_alpha.is_Scalar()&&this.hatch_scale.is_Scalar()&&this.hatch_pattern.is_Scalar()&&this.hatch_weight.is_Scalar()){var r=this.hatch_color.value,i=this.hatch_alpha.value,n=this.hatch_scale.value,h=this.hatch_pattern.value,c=this.hatch_weight.value;a(h,r,i,n,c,(function(a){t._hatch_image=new _.UniformScalar(a,e)}))}else{var l=new Array(e);l.fill(null),this._hatch_image=new _.UniformVector(l);for(var s=function(t){var e=u.hatch_color.get(t),r=u.hatch_alpha.get(t),i=u.hatch_scale.get(t),n=u.hatch_pattern.get(t),h=u.hatch_weight.get(t);a(n,e,r,i,h,(function(e){l[t]=e}))},u=this,p=0;p<e;p++)s(p)}}},Object.defineProperty(e.prototype,"doit",{get:function(){return this._static_doit},enumerable:!1,configurable:!0}),e.prototype.apply=function(t,e,a){var r=this.doit;return r&&(this.set_vectorize(t,e),t.layer.undo_transform((function(){return t.fill(a)}))),r},e.prototype.set_vectorize=function(t,e){var a;t.fillStyle=null!==(a=this.pattern(t,e))&&void 0!==a?a:"transparent"},e.prototype.pattern=function(t,e){var a=this._hatch_image.get(e);return null==a?null:t.createPattern(a,this.repetition(e))},e.prototype.repetition=function(t){var e=this.hatch_pattern.get(t),a=this.hatch_extra.value[e];if(null==a)return"repeat";switch(a.repetition){case"repeat":return"repeat";case"repeat_x":return"repeat-x";case"repeat_y":return"repeat-y";case"no_repeat":return"no-repeat"}},e}(h.VisualUniforms);a.HatchVector=u,u.__name__="HatchVector",l.prototype.type="hatch",l.prototype.attrs=Object.keys(c.Hatch),s.prototype.type="hatch",s.prototype.attrs=Object.keys(c.HatchScalar),u.prototype.type="hatch",u.prototype.attrs=Object.keys(c.HatchVector)},
function _(e,o,a,r,i){r();var s=e(137);function l(e,o,a){e.moveTo(0,a+.5),e.lineTo(o,a+.5),e.stroke()}function n(e,o,a){e.moveTo(a+.5,0),e.lineTo(a+.5,o),e.stroke()}function t(e,o){e.moveTo(0,o),e.lineTo(o,0),e.stroke(),e.moveTo(0,0),e.lineTo(o,o),e.stroke()}a.hatch_aliases={" ":"blank",".":"dot",o:"ring","-":"horizontal_line","|":"vertical_line","+":"cross",'"':"horizontal_dash",":":"vertical_dash","@":"spiral","/":"right_diagonal_line","\\":"left_diagonal_line",x:"diagonal_cross",",":"right_diagonal_dash","`":"left_diagonal_dash",v:"horizontal_wave",">":"vertical_wave","*":"criss_cross"},a.get_pattern=function(e,o,r,i,c,k){return e.resize(c,c),e.prepare(),function(e,o,r,i,c,k){var _,v=c,T=v/2,h=T/2,d=(0,s.color2css)(r,i);switch(e.strokeStyle=d,e.fillStyle=d,e.lineCap="square",e.lineWidth=k,null!==(_=a.hatch_aliases[o])&&void 0!==_?_:o){case"blank":break;case"dot":e.arc(T,T,T/2,0,2*Math.PI,!0),e.fill();break;case"ring":e.arc(T,T,T/2,0,2*Math.PI,!0),e.stroke();break;case"horizontal_line":l(e,v,T);break;case"vertical_line":n(e,v,T);break;case"cross":l(e,v,T),n(e,v,T);break;case"horizontal_dash":l(e,T,T);break;case"vertical_dash":n(e,T,T);break;case"spiral":var b=v/30;e.moveTo(T,T);for(var g=0;g<360;g++){var m=.1*g,f=T+b*m*Math.cos(m),u=T+b*m*Math.sin(m);e.lineTo(f,u)}e.stroke();break;case"right_diagonal_line":e.moveTo(.5-h,v),e.lineTo(h+.5,0),e.stroke(),e.moveTo(h+.5,v),e.lineTo(3*h+.5,0),e.stroke(),e.moveTo(3*h+.5,v),e.lineTo(5*h+.5,0),e.stroke(),e.stroke();break;case"left_diagonal_line":e.moveTo(h+.5,v),e.lineTo(.5-h,0),e.stroke(),e.moveTo(3*h+.5,v),e.lineTo(h+.5,0),e.stroke(),e.moveTo(5*h+.5,v),e.lineTo(3*h+.5,0),e.stroke(),e.stroke();break;case"diagonal_cross":t(e,v);break;case"right_diagonal_dash":e.moveTo(h+.5,3*h+.5),e.lineTo(3*h+.5,h+.5),e.stroke();break;case"left_diagonal_dash":e.moveTo(h+.5,h+.5),e.lineTo(3*h+.5,3*h+.5),e.stroke();break;case"horizontal_wave":e.moveTo(0,h),e.lineTo(T,3*h),e.lineTo(v,h),e.stroke();break;case"vertical_wave":e.moveTo(h,0),e.lineTo(3*h,T),e.lineTo(h,v),e.stroke();break;case"criss_cross":t(e,v),l(e,v,T),n(e,v,T)}}(e.ctx,o,r,i,c,k),e.canvas}},
function _(e,t,n,r,a){r();var o,c=e(1),s=e(129),i=e(125),l=e(128),_=e(141),u=e(134),p=function(e){function t(t){return e.call(this,t)||this}return(0,c.__extends)(t,e),Object.defineProperty(t.prototype,"is_syncable",{get:function(){return this.syncable},enumerable:!1,configurable:!0}),t.prototype[_.equals]=function(t,n){return n.eq(this.id,t.id)&&e.prototype[_.equals].call(this,t,n)},t.prototype.initialize=function(){e.prototype.initialize.call(this),this._js_callbacks=new Map},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this._update_property_callbacks(),this.connect(this.properties.js_property_callbacks.change,(function(){return t._update_property_callbacks()})),this.connect(this.properties.js_event_callbacks.change,(function(){return t._update_event_callbacks()})),this.connect(this.properties.subscribed_events.change,(function(){return t._update_event_callbacks()}))},t.prototype._process_event=function(e){var t,n,r;try{for(var a=(0,c.__values)(null!==(r=this.js_event_callbacks[e.event_name])&&void 0!==r?r:[]),o=a.next();!o.done;o=a.next()){o.value.execute(e)}}catch(e){t={error:e}}finally{try{o&&!o.done&&(n=a.return)&&n.call(a)}finally{if(t)throw t.error}}null!=this.document&&this.subscribed_events.some((function(t){return t==e.event_name}))&&this.document.event_manager.send_event(e)},t.prototype.trigger_event=function(e){null!=this.document&&(e.origin=this,this.document.event_manager.trigger(e))},t.prototype._update_event_callbacks=function(){null!=this.document?this.document.event_manager.subscribed_models.add(this):u.logger.warn("WARNING: Document not defined for updating event callbacks")},t.prototype._update_property_callbacks=function(){var e,t,n,r,a,o,s,i,_=this,u=function(e){var t=(0,c.__read)(e.split(":"),2),n=t[0],r=t[1],a=void 0===r?null:r;return null!=a?_.properties[a][n]:_[n]};try{for(var p=(0,c.__values)(this._js_callbacks),d=p.next();!d.done;d=p.next()){var h=(0,c.__read)(d.value,2),f=h[0],v=h[1],y=u(f);try{for(var b=(n=void 0,(0,c.__values)(v)),g=b.next();!g.done;g=b.next()){var m=g.value;this.disconnect(y,m)}}catch(e){n={error:e}}finally{try{g&&!g.done&&(r=b.return)&&r.call(b)}finally{if(n)throw n.error}}}}catch(t){e={error:t}}finally{try{d&&!d.done&&(t=p.return)&&t.call(p)}finally{if(e)throw e.error}}this._js_callbacks.clear();try{for(var k=(0,c.__values)((0,l.entries)(this.js_property_callbacks)),j=k.next();!j.done;j=k.next()){var w=(0,c.__read)(j.value,2),x=(f=w[0],(v=w[1]).map((function(e){return function(){return e.execute(_)}})));this._js_callbacks.set(f,x);y=u(f);try{for(var A=(s=void 0,(0,c.__values)(x)),q=A.next();!q.done;q=A.next()){m=q.value;this.connect(y,m)}}catch(e){s={error:e}}finally{try{q&&!q.done&&(i=A.return)&&i.call(A)}finally{if(s)throw s.error}}}}catch(e){a={error:e}}finally{try{j&&!j.done&&(o=k.return)&&o.call(k)}finally{if(a)throw a.error}}},t.prototype._doc_attached=function(){(0,l.isEmpty)(this.js_event_callbacks)&&0==this.subscribed_events.length||this._update_event_callbacks()},t.prototype._doc_detached=function(){this.document.event_manager.subscribed_models.delete(this)},t.prototype.select=function(e){if((0,i.isString)(e))return(0,c.__spreadArray)([],(0,c.__read)(this.references()),!1).filter((function(n){return n instanceof t&&n.name===e}));if(e.prototype instanceof s.HasProps)return(0,c.__spreadArray)([],(0,c.__read)(this.references()),!1).filter((function(t){return t instanceof e}));throw new Error("invalid selector")},t.prototype.select_one=function(e){var t=this.select(e);switch(t.length){case 0:return null;case 1:return t[0];default:throw new Error("found more than one object matching given selector")}},t}(s.HasProps);n.Model=p,o=p,p.__name__="Model",o.define((function(e){var t=e.Any,n=e.Unknown,r=e.Boolean,a=e.String,o=e.Array,c=e.Dict,s=e.Nullable;return{tags:[o(n),[]],name:[s(a),null],js_property_callbacks:[c(o(t)),{}],js_event_callbacks:[c(o(t)),{}],subscribed_events:[o(a),[]],syncable:[r,!0]}}))},
function _(e,t,r,n,a){n();var c,o,s=e(1),i=e(116),_=e(168),u=e(170),l=e(174),g=e(176),p=e(177),f=e(172),h=e(178),y=e(182),m=function(){function e(e,t){this.x_scale=e,this.y_scale=t,this.x_source=this.x_scale.source_range,this.y_source=this.y_scale.source_range,this.ranges=[this.x_source,this.y_source],this.scales=[this.x_scale,this.y_scale]}return e.prototype.map_to_screen=function(e,t){return[this.x_scale.v_compute(e),this.y_scale.v_compute(t)]},e.prototype.map_from_screen=function(e,t){return[this.x_scale.v_invert(e),this.y_scale.v_invert(t)]},e}();r.CoordinateTransform=m,m.__name__="CoordinateTransform";var v=function(e){function t(t){return e.call(this,t)||this}return(0,s.__extends)(t,e),Object.defineProperty(t.prototype,"x_ranges",{get:function(){return new Map([["default",this.x_source]])},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"y_ranges",{get:function(){return new Map([["default",this.y_source]])},enumerable:!1,configurable:!0}),t.prototype._get_scale=function(e,t,r){if(e instanceof y.FactorRange!=t instanceof p.CategoricalScale)throw new Error("Range "+e.type+" is incompatible is Scale "+t.type);t instanceof g.LogScale&&e instanceof h.DataRange1d&&(e.scale_hint="log");var n=t.clone();return n.setv({source_range:e,target_range:r}),n},t.prototype.get_transform=function(e){var t=this,r=t.x_source,n=t.x_scale,a=t.x_target,c=this._get_scale(r,n,a),o=this,s=o.y_source,i=o.y_scale,_=o.y_target,u=this._get_scale(s,i,_),l=new x({source_scale:c,source_range:c.source_range,target_scale:e.x_scale,target_range:e.x_target}),g=new x({source_scale:u,source_range:u.source_range,target_scale:e.y_scale,target_range:e.y_target});return new m(l,g)},t}(_.Model);r.CoordinateMapping=v,c=v,v.__name__="CoordinateMapping",c.define((function(e){var t=e.Ref;return{x_source:[t(f.Range),function(){return new h.DataRange1d}],y_source:[t(f.Range),function(){return new h.DataRange1d}],x_scale:[t(u.Scale),function(){return new l.LinearScale}],y_scale:[t(u.Scale),function(){return new l.LinearScale}],x_target:[t(f.Range)],y_target:[t(f.Range)]}}));var x=function(e){function t(t){return e.call(this,t)||this}return(0,s.__extends)(t,e),Object.defineProperty(t.prototype,"s_compute",{get:function(){var e=this.source_scale.s_compute,t=this.target_scale.s_compute;return function(r){return t(e(r))}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"s_invert",{get:function(){var e=this.source_scale.s_invert,t=this.target_scale.s_invert;return function(r){return e(t(r))}},enumerable:!1,configurable:!0}),t.prototype.compute=function(e){return this.s_compute(e)},t.prototype.v_compute=function(e){var t=this.s_compute;return(0,i.map)(e,t)},t.prototype.invert=function(e){return this.s_invert(e)},t.prototype.v_invert=function(e){var t=this.s_invert;return(0,i.map)(e,t)},t}(u.Scale);r.CompositeScale=x,o=x,x.__name__="CompositeScale",o.internal((function(e){var t=e.Ref;return{source_scale:[t(u.Scale)],target_scale:[t(u.Scale)]}}))},
function _(t,r,e,n,o){n();var i,u=t(1),a=t(171),s=t(172),_=t(173),c=t(139),p=function(t){function r(r){return t.call(this,r)||this}return(0,u.__extends)(r,t),r.prototype.compute=function(t){return this.s_compute(t)},r.prototype.v_compute=function(t){for(var r=new c.ScreenArray(t.length),e=this.s_compute,n=0;n<t.length;n++)r[n]=e(t[n]);return r},r.prototype.invert=function(t){return this.s_invert(t)},r.prototype.v_invert=function(t){for(var r=new Float64Array(t.length),e=this.s_invert,n=0;n<t.length;n++)r[n]=e(t[n]);return r},r.prototype.r_compute=function(t,r){var e=this.s_compute;return this.target_range.is_reversed?[e(r),e(t)]:[e(t),e(r)]},r.prototype.r_invert=function(t,r){var e=this.s_invert;return this.target_range.is_reversed?[e(r),e(t)]:[e(t),e(r)]},r}(a.Transform);e.Scale=p,i=p,p.__name__="Scale",i.internal((function(t){var r=t.Ref;return{source_range:[r(s.Range)],target_range:[r(_.Range1d)]}}))},
function _(n,r,t,_,e){_();var o=n(1),a=function(n){function r(r){return n.call(this,r)||this}return(0,o.__extends)(r,n),r}(n(168).Model);t.Transform=a,a.__name__="Transform"},
function _(e,n,t,r,i){r();var u,a=e(1),l=function(e){function n(n){var t=e.call(this,n)||this;return t.have_updated_interactively=!1,t}return(0,a.__extends)(n,e),Object.defineProperty(n.prototype,"is_reversed",{get:function(){return this.start>this.end},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"is_valid",{get:function(){return isFinite(this.min)&&isFinite(this.max)},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"span",{get:function(){return Math.abs(this.end-this.start)},enumerable:!1,configurable:!0}),n}(e(168).Model);t.Range=l,u=l,l.__name__="Range",u.define((function(e){var n=e.Number,t=e.Tuple,r=e.Or,i=e.Auto,u=e.Nullable;return{bounds:[u(r(t(u(n),u(n)),i)),null],min_interval:[u(n),null],max_interval:[u(n),null]}})),u.internal((function(e){return{plots:[(0,e.Array)((0,e.AnyRef)()),[]]}}))},
function _(t,e,n,s,r){s();var i,a=t(1),o=function(t){function e(e){return t.call(this,e)||this}return(0,a.__extends)(e,t),e.prototype._set_auto_bounds=function(){if("auto"==this.bounds){var t=Math.min(this._reset_start,this._reset_end),e=Math.max(this._reset_start,this._reset_end);this.setv({bounds:[t,e]},{silent:!0})}},e.prototype.initialize=function(){t.prototype.initialize.call(this),this._set_auto_bounds()},Object.defineProperty(e.prototype,"min",{get:function(){return Math.min(this.start,this.end)},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"max",{get:function(){return Math.max(this.start,this.end)},enumerable:!1,configurable:!0}),e.prototype.reset=function(){this._set_auto_bounds();var t=this._reset_start,e=this._reset_end;this.start!=t||this.end!=e?this.setv({start:t,end:e}):this.change.emit()},e.prototype.map=function(t){return new e({start:t(this.start),end:t(this.end)})},e.prototype.widen=function(t){var n=this.start,s=this.end;return this.is_reversed?(n+=t,s-=t):(n-=t,s+=t),new e({start:n,end:s})},e}(t(172).Range);n.Range1d=o,i=o,o.__name__="Range1d",i.define((function(t){var e=t.Number,n=t.Nullable;return{start:[e,0],end:[e,1],reset_start:[n(e),null,{on_update:function(t,e){e._reset_start=null!=t?t:e.start}}],reset_end:[n(e),null,{on_update:function(t,e){e._reset_end=null!=t?t:e.end}}]}}))},
function _(e,t,r,n,a){n();var i=e(1),u=function(e){function t(t){return e.call(this,t)||this}return(0,i.__extends)(t,e),Object.defineProperty(t.prototype,"s_compute",{get:function(){var e=(0,i.__read)(this._linear_compute_state(),2),t=e[0],r=e[1];return function(e){return t*e+r}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"s_invert",{get:function(){var e=(0,i.__read)(this._linear_compute_state(),2),t=e[0],r=e[1];return function(e){return(e-r)/t}},enumerable:!1,configurable:!0}),t.prototype._linear_compute_state=function(){var e=this.source_range.start,t=this.source_range.end,r=this.target_range.start,n=(this.target_range.end-r)/(t-e);return[n,-n*e+r]},t}(e(175).ContinuousScale);r.LinearScale=u,u.__name__="LinearScale"},
function _(n,t,u,e,c){e();var i=n(1),o=function(n){function t(t){return n.call(this,t)||this}return(0,i.__extends)(t,n),t}(n(170).Scale);u.ContinuousScale=o,o.__name__="ContinuousScale"},
function _(t,e,r,a,o){a();var n=t(1),i=function(t){function e(e){return t.call(this,e)||this}return(0,n.__extends)(e,t),Object.defineProperty(e.prototype,"s_compute",{get:function(){var t=(0,n.__read)(this._compute_state(),4),e=t[0],r=t[1],a=t[2],o=t[3];return function(t){if(0==a)return 0;var n=(Math.log(t)-o)/a;return isFinite(n)?n*e+r:NaN}},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"s_invert",{get:function(){var t=(0,n.__read)(this._compute_state(),4),e=t[0],r=t[1],a=t[2],o=t[3];return function(t){var n=(t-r)/e;return Math.exp(a*n+o)}},enumerable:!1,configurable:!0}),e.prototype._get_safe_factor=function(t,e){var r,a=t<0?0:t,o=e<0?0:e;if(a==o)if(0==a)a=(r=(0,n.__read)([1,10],2))[0],o=r[1];else{var i=Math.log(a)/Math.log(10);a=Math.pow(10,Math.floor(i)),o=Math.ceil(i)!=Math.floor(i)?Math.pow(10,Math.ceil(i)):Math.pow(10,Math.ceil(i)+1)}return[a,o]},e.prototype._compute_state=function(){var t,e,r=this.source_range.start,a=this.source_range.end,o=this.target_range.start,i=this.target_range.end-o,_=(0,n.__read)(this._get_safe_factor(r,a),2),u=_[0],c=_[1];return 0==u?(t=Math.log(c),e=0):(t=Math.log(c)-Math.log(u),e=Math.log(u)),[i,o,t,e]},e}(t(175).ContinuousScale);r.LogScale=i,i.__name__="LogScale"},
function _(e,t,r,n,a){n();var c=e(1),i=e(170),o=e(174).LinearScale.prototype._linear_compute_state,u=function(e){function t(t){return e.call(this,t)||this}return(0,c.__extends)(t,e),Object.defineProperty(t.prototype,"s_compute",{get:function(){var e=(0,c.__read)(o.call(this),2),t=e[0],r=e[1],n=this.source_range;return function(e){return t*n.synthetic(e)+r}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"s_invert",{get:function(){var e=(0,c.__read)(o.call(this),2),t=e[0],r=e[1];return function(e){return(e-r)/t}},enumerable:!1,configurable:!0}),t}(i.Scale);r.CategoricalScale=u,u.__name__="CategoricalScale"},
function _(t,i,n,a,e){a();var r,l=t(1),s=t(179),_=t(135),o=t(126),d=t(134),u=(0,l.__importStar)(t(180)),h=t(181),p=function(t){function i(i){var n=t.call(this,i)||this;return n.have_updated_interactively=!1,n}return(0,l.__extends)(i,t),i.prototype.initialize=function(){t.prototype.initialize.call(this),this._initial_start=this.start,this._initial_end=this.end,this._initial_range_padding=this.range_padding,this._initial_range_padding_units=this.range_padding_units,this._initial_follow=this.follow,this._initial_follow_interval=this.follow_interval,this._initial_default_span=this.default_span,this._plot_bounds=new Map},Object.defineProperty(i.prototype,"min",{get:function(){return Math.min(this.start,this.end)},enumerable:!1,configurable:!0}),Object.defineProperty(i.prototype,"max",{get:function(){return Math.max(this.start,this.end)},enumerable:!1,configurable:!0}),i.prototype.computed_renderers=function(){var t=this.renderers,i=this.names,n=(0,o.concat)(this.plots.map((function(t){return t.data_renderers})));return(0,h.compute_renderers)(0==t.length?"auto":t,n,i)},i.prototype._compute_plot_bounds=function(t,i){var n,a,e=u.empty();try{for(var r=(0,l.__values)(t),s=r.next();!s.done;s=r.next()){var _=s.value,o=i.get(_);null==o||!_.visible&&this.only_visible||(e=u.union(e,o))}}catch(t){n={error:t}}finally{try{s&&!s.done&&(a=r.return)&&a.call(r)}finally{if(n)throw n.error}}return e},i.prototype.adjust_bounds_for_aspect=function(t,i){var n=u.empty(),a=t.x1-t.x0;a<=0&&(a=1);var e=t.y1-t.y0;e<=0&&(e=1);var r=.5*(t.x1+t.x0),l=.5*(t.y1+t.y0);return a<i*e?a=i*e:e=a/i,n.x1=r+.5*a,n.x0=r-.5*a,n.y1=l+.5*e,n.y0=l-.5*e,n},i.prototype._compute_min_max=function(t,i){var n,a,e,r,s,_,o=u.empty();try{for(var d=(0,l.__values)(t),h=d.next();!h.done;h=d.next()){var p=(0,l.__read)(h.value,2),g=p[0],f=p[1];g.visible&&(o=u.union(o,f))}}catch(t){n={error:t}}finally{try{h&&!h.done&&(a=d.return)&&a.call(d)}finally{if(n)throw n.error}}return 0==i?(s=(e=(0,l.__read)([o.x0,o.x1],2))[0],_=e[1]):(s=(r=(0,l.__read)([o.y0,o.y1],2))[0],_=r[1]),[s,_]},i.prototype._compute_range=function(t,i){var n,a,e,r=this.range_padding;if(null!=this._initial_start&&(t=this._initial_start),null!=this._initial_end&&(i=this._initial_end),"log"==this.scale_hint){(isNaN(t)||!isFinite(t)||t<=0)&&(t=isNaN(i)||!isFinite(i)||i<=0?.1:i/100,d.logger.warn("could not determine minimum data value for log axis, DataRange1d using value "+t)),(isNaN(i)||!isFinite(i)||i<=0)&&(i=isNaN(t)||!isFinite(t)||t<=0?10:100*t,d.logger.warn("could not determine maximum data value for log axis, DataRange1d using value "+i));var s=void 0,_=void 0;if(i==t)_=this.default_span+.001,s=Math.log(t)/Math.log(10);else{var o=void 0,u=void 0;"percent"==this.range_padding_units?(o=Math.log(t)/Math.log(10),_=((u=Math.log(i)/Math.log(10))-o)*(1+r)):(o=Math.log(t-r)/Math.log(10),_=(u=Math.log(i+r)/Math.log(10))-o),s=(o+u)/2}a=Math.pow(10,s-_/2),e=Math.pow(10,s+_/2)}else{_=void 0;a=(s=(i+t)/2)-(_=i==t?this.default_span:"percent"==this.range_padding_units?(i-t)*(1+r):i-t+2*r)/2,e=s+_/2}var h=1;this.flipped&&(a=(n=(0,l.__read)([e,a],2))[0],e=n[1],h=-1);var p=this.follow_interval;return null!=p&&Math.abs(a-e)>p&&("start"==this.follow?e=a+h*p:"end"==this.follow&&(a=e-h*p)),[a,e]},i.prototype.update=function(t,i,n,a){if(!this.have_updated_interactively){var e=this.computed_renderers(),r=this._compute_plot_bounds(e,t);null!=a&&(r=this.adjust_bounds_for_aspect(r,a)),this._plot_bounds.set(n,r);var s=(0,l.__read)(this._compute_min_max(this._plot_bounds.entries(),i),2),_=s[0],o=s[1],d=(0,l.__read)(this._compute_range(_,o),2),u=d[0],h=d[1];null!=this._initial_start&&("log"==this.scale_hint?this._initial_start>0&&(u=this._initial_start):u=this._initial_start),null!=this._initial_end&&("log"==this.scale_hint?this._initial_end>0&&(h=this._initial_end):h=this._initial_end);var p=!1;"auto"==this.bounds&&(this.setv({bounds:[u,h]},{silent:!0}),p=!0);var g=(0,l.__read)([this.start,this.end],2),f=g[0],c=g[1];if(u!=f||h!=c){var v={};u!=f&&(v.start=u),h!=c&&(v.end=h),this.setv(v),p=!1}p&&this.change.emit()}},i.prototype.reset=function(){this.have_updated_interactively=!1,this.setv({range_padding:this._initial_range_padding,range_padding_units:this._initial_range_padding_units,follow:this._initial_follow,follow_interval:this._initial_follow_interval,default_span:this._initial_default_span},{silent:!0}),this.change.emit()},i}(s.DataRange);n.DataRange1d=p,r=p,p.__name__="DataRange1d",r.define((function(t){var i=t.Boolean,n=t.Number,a=t.Nullable;return{start:[n],end:[n],range_padding:[n,.1],range_padding_units:[_.PaddingUnits,"percent"],flipped:[i,!1],follow:[a(_.StartEnd),null],follow_interval:[a(n),null],default_span:[n,2],only_visible:[i,!1]}})),r.internal((function(t){return{scale_hint:[(0,t.Enum)("log","auto"),"auto"]}}))},
function _(n,e,r,a,t){a();var i,u=n(1),_=function(n){function e(e){return n.call(this,e)||this}return(0,u.__extends)(e,n),e}(n(172).Range);r.DataRange=_,i=_,_.__name__="DataRange",i.define((function(n){var e=n.String,r=n.Array,a=n.AnyRef;return{names:[r(e),[]],renderers:[r(a()),[]]}}))},
function _(t,e,i,r,n){r();var o=t(139),h=t(141),u=Math.min,y=Math.max;i.empty=function(){return{x0:1/0,y0:1/0,x1:-1/0,y1:-1/0}},i.positive_x=function(){return{x0:Number.MIN_VALUE,y0:-1/0,x1:1/0,y1:1/0}},i.positive_y=function(){return{x0:-1/0,y0:Number.MIN_VALUE,x1:1/0,y1:1/0}},i.union=function(t,e){return{x0:u(t.x0,e.x0),x1:y(t.x1,e.x1),y0:u(t.y0,e.y0),y1:y(t.y1,e.y1)}};var s=function(){function t(t){if(null==t)this.x0=0,this.y0=0,this.x1=0,this.y1=0;else if("x0"in t){var e=t.x0,i=t.y0,r=t.x1,n=t.y1;if(!(e<=r&&i<=n))throw new Error("invalid bbox {x0: "+e+", y0: "+i+", x1: "+r+", y1: "+n+"}");this.x0=e,this.y0=i,this.x1=r,this.y1=n}else if("x"in t){var o=t.x,h=t.y,u=t.width,y=t.height;if(!(u>=0&&y>=0))throw new Error("invalid bbox {x: "+o+", y: "+h+", width: "+u+", height: "+y+"}");this.x0=o,this.y0=h,this.x1=o+u,this.y1=h+y}else{var s=void 0,f=void 0,p=void 0,c=void 0;if("width"in t)if("left"in t)f=(s=t.left)+t.width;else if("right"in t)s=(f=t.right)-t.width;else{var x=t.width/2;s=t.hcenter-x,f=t.hcenter+x}else s=t.left,f=t.right;if("height"in t)if("top"in t)c=(p=t.top)+t.height;else if("bottom"in t)p=(c=t.bottom)-t.height;else{var a=t.height/2;p=t.vcenter-a,c=t.vcenter+a}else p=t.top,c=t.bottom;if(!(s<=f&&p<=c))throw new Error("invalid bbox {left: "+s+", top: "+p+", right: "+f+", bottom: "+c+"}");this.x0=s,this.y0=p,this.x1=f,this.y1=c}}return t.from_rect=function(e){var i=e.left,r=e.right,n=e.top,o=e.bottom;return new t({x0:Math.min(i,r),y0:Math.min(n,o),x1:Math.max(i,r),y1:Math.max(n,o)})},t.prototype.equals=function(t){return this.x0==t.x0&&this.y0==t.y0&&this.x1==t.x1&&this.y1==t.y1},t.prototype[h.equals]=function(t,e){return e.eq(this.x0,t.x0)&&e.eq(this.y0,t.y0)&&e.eq(this.x1,t.x1)&&e.eq(this.y1,t.y1)},t.prototype.toString=function(){return"BBox({left: "+this.left+", top: "+this.top+", width: "+this.width+", height: "+this.height+"})"},Object.defineProperty(t.prototype,"left",{get:function(){return this.x0},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"top",{get:function(){return this.y0},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"right",{get:function(){return this.x1},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"bottom",{get:function(){return this.y1},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"p0",{get:function(){return[this.x0,this.y0]},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"p1",{get:function(){return[this.x1,this.y1]},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"x",{get:function(){return this.x0},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"y",{get:function(){return this.y0},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"width",{get:function(){return this.x1-this.x0},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"height",{get:function(){return this.y1-this.y0},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"size",{get:function(){return{width:this.width,height:this.height}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"rect",{get:function(){var t=this,e=t.x0,i=t.y0,r=t.x1,n=t.y1;return{p0:{x:e,y:i},p1:{x:r,y:i},p2:{x:r,y:n},p3:{x:e,y:n}}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"box",{get:function(){var t=this;return{x:t.x,y:t.y,width:t.width,height:t.height}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"h_range",{get:function(){return{start:this.x0,end:this.x1}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"v_range",{get:function(){return{start:this.y0,end:this.y1}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"ranges",{get:function(){return[this.h_range,this.v_range]},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"aspect",{get:function(){return this.width/this.height},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"hcenter",{get:function(){return(this.left+this.right)/2},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"vcenter",{get:function(){return(this.top+this.bottom)/2},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"area",{get:function(){return this.width*this.height},enumerable:!1,configurable:!0}),t.prototype.relative=function(){return new t({x:0,y:0,width:this.width,height:this.height})},t.prototype.translate=function(e,i){var r=this;return new t({x:e+r.x,y:i+r.y,width:r.width,height:r.height})},t.prototype.relativize=function(t,e){return[t-this.x,e-this.y]},t.prototype.contains=function(t,e){return this.x0<=t&&t<=this.x1&&this.y0<=e&&e<=this.y1},t.prototype.clip=function(t,e){return t<this.x0?t=this.x0:t>this.x1&&(t=this.x1),e<this.y0?e=this.y0:e>this.y1&&(e=this.y1),[t,e]},t.prototype.grow_by=function(e){return new t({left:this.left-e,right:this.right+e,top:this.top-e,bottom:this.bottom+e})},t.prototype.shrink_by=function(e){return new t({left:this.left+e,right:this.right-e,top:this.top+e,bottom:this.bottom-e})},t.prototype.union=function(e){return new t({x0:u(this.x0,e.x0),y0:u(this.y0,e.y0),x1:y(this.x1,e.x1),y1:y(this.y1,e.y1)})},t.prototype.intersection=function(e){return this.intersects(e)?new t({x0:y(this.x0,e.x0),y0:y(this.y0,e.y0),x1:u(this.x1,e.x1),y1:u(this.y1,e.y1)}):null},t.prototype.intersects=function(t){return!(t.x1<this.x0||t.x0>this.x1||t.y1<this.y0||t.y0>this.y1)},Object.defineProperty(t.prototype,"xview",{get:function(){var t=this;return{compute:function(e){return t.left+e},v_compute:function(e){for(var i=new o.ScreenArray(e.length),r=t.left,n=0;n<e.length;n++)i[n]=r+e[n];return i}}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"yview",{get:function(){var t=this;return{compute:function(e){return t.bottom-e},v_compute:function(e){for(var i=new o.ScreenArray(e.length),r=t.bottom,n=0;n<e.length;n++)i[n]=r-e[n];return i}}},enumerable:!1,configurable:!0}),t}();i.BBox=s,s.__name__="BBox"},
function _(n,r,e,t,u){t();var i=n(126);e.compute_renderers=function(n,r,e){if(null==n)return[];var t="auto"==n?r:n;return e.length>0&&(t=t.filter((function(n){return(0,i.includes)(e,n.name)}))),t}},
function _(r,e,t,n,a){n();var i,o=r(1),s=r(172),l=r(135),u=r(136),p=r(139),c=r(126),d=r(125),_=r(127);function g(r,e,t){void 0===t&&(t=0);for(var n=new Map,a=0;a<r.length;a++){var i=r[a];if(n.has(i))throw new Error("duplicate factor or subfactor: "+i);n.set(i,{value:.5+a*(1+e)+t})}return[n,(r.length-1)*e]}function f(r,e,t,n){var a,i,s,l,u;void 0===n&&(n=0);var p=new Map,d=new Map;try{for(var _=(0,o.__values)(r),f=_.next();!f.done;f=_.next()){var v=(0,o.__read)(f.value,2),h=v[0],y=v[1],m=null!==(u=d.get(h))&&void 0!==u?u:[];d.set(h,(0,o.__spreadArray)((0,o.__spreadArray)([],(0,o.__read)(m),!1),[y],!1))}}catch(r){a={error:r}}finally{try{f&&!f.done&&(i=_.return)&&i.call(_)}finally{if(a)throw a.error}}var S=n,b=0,w=function(r,n){var a=n.length,i=(0,o.__read)(g(n,t,S),2),s=i[0],l=i[1];b+=l;var u=(0,c.sum)(n.map((function(r){return s.get(r).value})));p.set(r,{value:u/a,mapping:s}),S+=a+e+l};try{for(var x=(0,o.__values)(d),A=x.next();!A.done;A=x.next()){var N=(0,o.__read)(A.value,2);w(h=N[0],m=N[1])}}catch(r){s={error:r}}finally{try{A&&!A.done&&(l=x.return)&&l.call(x)}finally{if(s)throw s.error}}return[p,(d.size-1)*e+b]}function v(r,e,t,n,a){var i,s,l,u,p;void 0===a&&(a=0);var d=new Map,_=new Map;try{for(var g=(0,o.__values)(r),v=g.next();!v.done;v=g.next()){var h=(0,o.__read)(v.value,3),y=h[0],m=h[1],S=h[2],b=null!==(p=_.get(y))&&void 0!==p?p:[];_.set(y,(0,o.__spreadArray)((0,o.__spreadArray)([],(0,o.__read)(b),!1),[[m,S]],!1))}}catch(r){i={error:r}}finally{try{v&&!v.done&&(s=g.return)&&s.call(g)}finally{if(i)throw i.error}}var w=a,x=0,A=function(r,a){var i=a.length,s=(0,o.__read)(f(a,t,n,w),2),l=s[0],u=s[1];x+=u;var p=(0,c.sum)(a.map((function(r){var e=(0,o.__read)(r,1)[0];return l.get(e).value})));d.set(r,{value:p/i,mapping:l}),w+=i+e+u};try{for(var N=(0,o.__values)(_),k=N.next();!k.done;k=N.next()){var F=(0,o.__read)(k.value,2);A(y=F[0],b=F[1])}}catch(r){l={error:r}}finally{try{k&&!k.done&&(u=N.return)&&u.call(N)}finally{if(l)throw l.error}}return[d,(_.size-1)*e+x]}t.Factor=(0,u.Or)(u.String,(0,u.Tuple)(u.String,u.String),(0,u.Tuple)(u.String,u.String,u.String)),t.FactorSeq=(0,u.Or)((0,u.Array)(u.String),(0,u.Array)((0,u.Tuple)(u.String,u.String)),(0,u.Array)((0,u.Tuple)(u.String,u.String,u.String))),t.map_one_level=g,t.map_two_levels=f,t.map_three_levels=v;var h=function(r){function e(e){return r.call(this,e)||this}return(0,o.__extends)(e,r),Object.defineProperty(e.prototype,"min",{get:function(){return this.start},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"max",{get:function(){return this.end},enumerable:!1,configurable:!0}),e.prototype.initialize=function(){r.prototype.initialize.call(this),this._init(!0)},e.prototype.connect_signals=function(){var e=this;r.prototype.connect_signals.call(this),this.connect(this.properties.factors.change,(function(){return e.reset()})),this.connect(this.properties.factor_padding.change,(function(){return e.reset()})),this.connect(this.properties.group_padding.change,(function(){return e.reset()})),this.connect(this.properties.subgroup_padding.change,(function(){return e.reset()})),this.connect(this.properties.range_padding.change,(function(){return e.reset()})),this.connect(this.properties.range_padding_units.change,(function(){return e.reset()}))},e.prototype.reset=function(){this._init(!1),this.change.emit()},e.prototype._lookup=function(r){switch(r.length){case 1:var e=(0,o.__read)(r,1)[0];return null!=(a=this._mapping.get(e))?a.value:NaN;case 2:var t=(0,o.__read)(r,2),n=(e=t[0],t[1]);if(null!=(a=this._mapping.get(e)))if(null!=(i=a.mapping.get(n)))return i.value;return NaN;case 3:var a,i,s=(0,o.__read)(r,3),l=(e=s[0],n=s[1],s[2]);if(null!=(a=this._mapping.get(e)))if(null!=(i=a.mapping.get(n))){var u=i.mapping.get(l);if(null!=u)return u.value}return NaN;default:(0,_.unreachable)()}},e.prototype.synthetic=function(r){if((0,d.isNumber)(r))return r;if((0,d.isString)(r))return this._lookup([r]);var e=0,t=r[r.length-1];return(0,d.isNumber)(t)&&(e=t,r=r.slice(0,-1)),this._lookup(r)+e},e.prototype.v_synthetic=function(r){for(var e=r.length,t=new p.ScreenArray(e),n=0;n<e;n++)t[n]=this.synthetic(r[n]);return t},e.prototype._init=function(r){var e=this,t=function(){var r,t,n,a;if((0,c.every)(e.factors,d.isString)){var i=e.factors,s=(0,o.__read)(g(i,e.factor_padding),2);return{levels:1,mapping:s[0],tops:null,mids:null,inside_padding:s[1]}}if((0,c.every)(e.factors,(function(r){return(0,d.isArray)(r)&&2==r.length&&(0,d.isString)(r[0])&&(0,d.isString)(r[1])}))){i=e.factors;var l=(0,o.__read)(f(i,e.group_padding,e.factor_padding),2),u=l[0],p=l[1],h=(0,o.__spreadArray)([],(0,o.__read)(u.keys()),!1);return{levels:2,mapping:u,tops:h,mids:null,inside_padding:p}}if((0,c.every)(e.factors,(function(r){return(0,d.isArray)(r)&&3==r.length&&(0,d.isString)(r[0])&&(0,d.isString)(r[1])&&(0,d.isString)(r[2])}))){i=e.factors;var y=(0,o.__read)(v(i,e.group_padding,e.subgroup_padding,e.factor_padding),2),m=y[0],S=y[1],b=(0,o.__spreadArray)([],(0,o.__read)(m.keys()),!1),w=[];try{for(var x=(0,o.__values)(m),A=x.next();!A.done;A=x.next()){var N=(0,o.__read)(A.value,2),k=N[0],F=N[1];try{for(var M=(n=void 0,(0,o.__values)(F.mapping.keys())),T=M.next();!T.done;T=M.next()){var z=T.value;w.push([k,z])}}catch(r){n={error:r}}finally{try{T&&!T.done&&(a=M.return)&&a.call(M)}finally{if(n)throw n.error}}}}catch(e){r={error:e}}finally{try{A&&!A.done&&(t=x.return)&&t.call(x)}finally{if(r)throw r.error}}return{levels:3,mapping:m,tops:b,mids:w,inside_padding:S}}(0,_.unreachable)()}(),n=t.levels,a=t.mapping,i=t.tops,s=t.mids,l=t.inside_padding;this._mapping=a,this.tops=i,this.mids=s;var u=0,p=this.factors.length+l;if("percent"==this.range_padding_units){var h=(p-u)*this.range_padding/2;u-=h,p+=h}else u-=this.range_padding,p+=this.range_padding;this.setv({start:u,end:p,levels:n},{silent:r}),"auto"==this.bounds&&this.setv({bounds:[u,p]},{silent:!0})},e}(s.Range);t.FactorRange=h,i=h,h.__name__="FactorRange",i.define((function(r){var e=r.Number;return{factors:[t.FactorSeq,[]],factor_padding:[e,0],subgroup_padding:[e,.8],group_padding:[e,1.4],range_padding:[e,0],range_padding_units:[l.PaddingUnits,"percent"],start:[e],end:[e]}})),i.internal((function(r){var e=r.Number,t=r.String,n=r.Array,a=r.Tuple,i=r.Nullable;return{levels:[e],mids:[i(n(a(t,t))),null],tops:[i(n(t)),null]}}))},
function _(t,e,s,a,i){a();var n,r=t(1),o=t(184),_=t(227),l=t(163),d=t(135),h=t(139),u=t(228),c=(0,r.__importStar)(t(133)),p=t(117),v=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,r.__extends)(e,t),e.prototype.lazy_initialize=function(){return(0,r.__awaiter)(this,void 0,void 0,(function(){var e,s,a,i,n;return(0,r.__generator)(this,(function(r){switch(r.label){case 0:return[4,t.prototype.lazy_initialize.call(this)];case 1:return r.sent(),e=this.model,s=e.start,a=e.end,null==s?[3,3]:(i=this,[4,(0,u.build_view)(s,{parent:this})]);case 2:i.start=r.sent(),r.label=3;case 3:return null==a?[3,5]:(n=this,[4,(0,u.build_view)(a,{parent:this})]);case 4:n.end=r.sent(),r.label=5;case 5:return[2]}}))}))},e.prototype.set_data=function(e){var s,a;t.prototype.set_data.call(this,e),null===(s=this.start)||void 0===s||s.set_data(e),null===(a=this.end)||void 0===a||a.set_data(e)},e.prototype.remove=function(){var e,s;null===(e=this.start)||void 0===e||e.remove(),null===(s=this.end)||void 0===s||s.remove(),t.prototype.remove.call(this)},e.prototype.map_data=function(){var t=this.plot_view.frame;"data"==this.model.start_units?(this._sx_start=this.coordinates.x_scale.v_compute(this._x_start),this._sy_start=this.coordinates.y_scale.v_compute(this._y_start)):(this._sx_start=t.bbox.xview.v_compute(this._x_start),this._sy_start=t.bbox.yview.v_compute(this._y_start)),"data"==this.model.end_units?(this._sx_end=this.coordinates.x_scale.v_compute(this._x_end),this._sy_end=this.coordinates.y_scale.v_compute(this._y_end)):(this._sx_end=t.bbox.xview.v_compute(this._x_end),this._sy_end=t.bbox.yview.v_compute(this._y_end));for(var e=this,s=e._sx_start,a=e._sy_start,i=e._sx_end,n=e._sy_end,r=s.length,o=this._angles=new h.ScreenArray(r),_=0;_<r;_++)o[_]=Math.PI/2+(0,p.atan2)([s[_],a[_]],[i[_],n[_]])},e.prototype.paint=function(t){for(var e=this.start,s=this.end,a=this,i=a._sx_start,n=a._sy_start,r=a._sx_end,o=a._sy_end,_=a._angles,l=this.plot_view.frame.bbox,d=l.x,h=l.y,u=l.width,c=l.height,p=0,v=i.length;p<v;p++)null!=s&&(t.save(),t.translate(r[p],o[p]),t.rotate(_[p]),s.render(t,p),t.restore()),null!=e&&(t.save(),t.translate(i[p],n[p]),t.rotate(_[p]+Math.PI),e.render(t,p),t.restore()),this.visuals.line.doit&&(t.save(),null==e&&null==s||(t.beginPath(),t.rect(d,h,u,c),null!=s&&(t.save(),t.translate(r[p],o[p]),t.rotate(_[p]),s.clip(t,p),t.restore()),null!=e&&(t.save(),t.translate(i[p],n[p]),t.rotate(_[p]+Math.PI),e.clip(t,p),t.restore()),t.closePath(),t.clip()),this.visuals.line.set_vectorize(t,p),t.beginPath(),t.moveTo(i[p],n[p]),t.lineTo(r[p],o[p]),t.stroke(),t.restore())},e}(o.DataAnnotationView);s.ArrowView=v,v.__name__="ArrowView";var y=function(t){function e(e){return t.call(this,e)||this}return(0,r.__extends)(e,t),e}(o.DataAnnotation);s.Arrow=y,n=y,y.__name__="Arrow",n.prototype.default_view=v,n.mixins(l.LineVector),n.define((function(t){var e=t.Ref,s=t.Nullable;return{x_start:[c.XCoordinateSpec,{field:"x_start"}],y_start:[c.YCoordinateSpec,{field:"y_start"}],start_units:[d.SpatialUnits,"data"],start:[s(e(_.ArrowHead)),null],x_end:[c.XCoordinateSpec,{field:"x_end"}],y_end:[c.YCoordinateSpec,{field:"y_end"}],end_units:[d.SpatialUnits,"data"],end:[s(e(_.ArrowHead)),function(){return new _.OpenHead}]}}))},
function _(t,n,e,a,r){a();var o,i=t(1),s=t(155),c=t(185),_=t(190),l=t(193),u=(0,i.__importStar)(t(133)),h=function(t){function n(){var n=t.apply(this,(0,i.__spreadArray)([],(0,i.__read)(arguments),!1))||this;return n._initial_set_data=!1,n}return(0,i.__extends)(n,t),n.prototype.connect_signals=function(){var n=this;t.prototype.connect_signals.call(this);var e=function(){n.set_data(n.model.source),n._rerender()};this.connect(this.model.change,e),this.connect(this.model.source.streaming,e),this.connect(this.model.source.patching,e),this.connect(this.model.source.change,e)},n.prototype._rerender=function(){this.request_render()},n.prototype.set_data=function(t){var n,e,a,r,o=this;try{for(var s=(0,i.__values)(this.model),c=s.next();!c.done;c=s.next()){var _=c.value;if(_ instanceof u.VectorSpec||_ instanceof u.ScalarSpec)if(_ instanceof u.BaseCoordinateSpec){var h=_.array(t);o["_"+_.attr]=h}else{var d=_.uniform(t);o[""+_.attr]=d}}}catch(t){n={error:t}}finally{try{c&&!c.done&&(e=s.return)&&e.call(s)}finally{if(n)throw n.error}}this.plot_model.use_map&&(null!=o._x&&l.inplace.project_xy(o._x,o._y),null!=o._xs&&l.inplace.project_xsys(o._xs,o._ys));try{for(var f=(0,i.__values)(this.visuals),p=f.next();!p.done;p=f.next()){p.value.update()}}catch(t){a={error:t}}finally{try{p&&!p.done&&(r=f.return)&&r.call(f)}finally{if(a)throw a.error}}},n.prototype._render=function(){this._initial_set_data||(this.set_data(this.model.source),this._initial_set_data=!0),this.map_data(),this.paint(this.layer.ctx)},n}(s.AnnotationView);e.DataAnnotationView=h,h.__name__="DataAnnotationView";var d=function(t){function n(n){return t.call(this,n)||this}return(0,i.__extends)(n,t),n}(s.Annotation);e.DataAnnotation=d,o=d,d.__name__="DataAnnotation",o.define((function(t){return{source:[(0,t.Ref)(c.ColumnarDataSource),function(){return new _.ColumnDataSource}]}}))},
function _(t,n,e,r,i){r();var a,o=t(1),l=t(186),u=t(130),c=t(134),s=t(188),h=t(125),f=t(126),p=t(128),g=t(187),y=t(189),d=t(144),_=function(t){function n(n){var e=t.call(this,n)||this;return e.selection_manager=new s.SelectionManager(e),e}return(0,o.__extends)(n,t),n.prototype.get_array=function(t){var n=this.data[t];return null==n?this.data[t]=n=[]:(0,h.isArray)(n)||(this.data[t]=n=Array.from(n)),n},n.prototype.initialize=function(){t.prototype.initialize.call(this),this._select=new u.Signal0(this,"select"),this.inspect=new u.Signal(this,"inspect"),this.streaming=new u.Signal0(this,"streaming"),this.patching=new u.Signal(this,"patching")},n.prototype.get_column=function(t){var n=this.data[t];return null!=n?n:null},n.prototype.columns=function(){return(0,p.keys)(this.data)},n.prototype.get_length=function(t){void 0===t&&(t=!0);var n=(0,f.uniq)((0,p.values)(this.data).map((function(t){return(0,d.is_NDArray)(t)?t.shape[0]:t.length})));switch(n.length){case 0:return null;case 1:return n[0];default:var e="data source has columns of inconsistent lengths";if(t)return c.logger.warn(e),n.sort()[0];throw new Error(e)}},Object.defineProperty(n.prototype,"length",{get:function(){var t;return null!==(t=this.get_length())&&void 0!==t?t:0},enumerable:!1,configurable:!0}),n.prototype.clear=function(){var t,n,e={};try{for(var r=(0,o.__values)(this.columns()),i=r.next();!i.done;i=r.next()){var a=i.value;e[a]=new this.data[a].constructor(0)}}catch(n){t={error:n}}finally{try{i&&!i.done&&(n=r.return)&&n.call(r)}finally{if(t)throw t.error}}this.data=e},n}(l.DataSource);e.ColumnarDataSource=_,a=_,_.__name__="ColumnarDataSource",a.define((function(t){return{selection_policy:[(0,t.Ref)(y.SelectionPolicy),function(){return new y.UnionRenderers}]}})),a.internal((function(t){return{inspected:[(0,t.AnyRef)(),function(){return new g.Selection}]}}))},
function _(e,n,t,c,r){c();var u,i=e(1),o=e(168),a=e(187),f=function(e){function n(n){return e.call(this,n)||this}return(0,i.__extends)(n,e),n}(o.Model);t.DataSource=f,u=f,f.__name__="DataSource",u.define((function(e){return{selected:[(0,e.Ref)(a.Selection),function(){return new a.Selection}]}}))},
function _(i,e,t,n,s){n();var c,l=i(1),d=i(168),h=i(126),_=i(128),u=function(i){function e(e){return i.call(this,e)||this}return(0,l.__extends)(e,i),e.prototype.get_view=function(){return this.view},Object.defineProperty(e.prototype,"selected_glyph",{get:function(){return this.selected_glyphs.length>0?this.selected_glyphs[0]:null},enumerable:!1,configurable:!0}),e.prototype.add_to_selected_glyphs=function(i){this.selected_glyphs.push(i)},e.prototype.update=function(i,e,t){switch(void 0===e&&(e=!0),void 0===t&&(t="replace"),t){case"replace":this.indices=i.indices,this.line_indices=i.line_indices,this.multiline_indices=i.multiline_indices,this.image_indices=i.image_indices,this.view=i.view,this.selected_glyphs=i.selected_glyphs;break;case"append":this.update_through_union(i);break;case"intersect":this.update_through_intersection(i);break;case"subtract":this.update_through_subtraction(i)}},e.prototype.clear=function(){this.indices=[],this.line_indices=[],this.multiline_indices={},this.image_indices=[],this.view=null,this.selected_glyphs=[]},e.prototype.map=function(i){return new e((0,l.__assign)((0,l.__assign)({},this.attributes),{indices:this.indices.map(i),multiline_indices:(0,_.to_object)((0,_.entries)(this.multiline_indices).map((function(e){var t=(0,l.__read)(e,2),n=t[0],s=t[1];return[i(Number(n)),s]}))),image_indices:this.image_indices.map((function(e){return(0,l.__assign)((0,l.__assign)({},e),{index:i(e.index)})}))}))},e.prototype.is_empty=function(){return 0==this.indices.length&&0==this.line_indices.length&&0==this.image_indices.length},e.prototype.update_through_union=function(i){this.indices=(0,h.union)(this.indices,i.indices),this.selected_glyphs=(0,h.union)(i.selected_glyphs,this.selected_glyphs),this.line_indices=(0,h.union)(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=(0,_.merge)(i.multiline_indices,this.multiline_indices)},e.prototype.update_through_intersection=function(i){this.indices=(0,h.intersection)(this.indices,i.indices),this.selected_glyphs=(0,h.union)(i.selected_glyphs,this.selected_glyphs),this.line_indices=(0,h.union)(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=(0,_.merge)(i.multiline_indices,this.multiline_indices)},e.prototype.update_through_subtraction=function(i){this.indices=(0,h.difference)(this.indices,i.indices),this.selected_glyphs=(0,h.union)(i.selected_glyphs,this.selected_glyphs),this.line_indices=(0,h.union)(i.line_indices,this.line_indices),this.view=i.view,this.multiline_indices=(0,_.merge)(i.multiline_indices,this.multiline_indices)},e}(d.Model);t.Selection=u,c=u,u.__name__="Selection",c.define((function(i){var e=i.Int,t=i.Array,n=i.Dict;return{indices:[t(e),[]],line_indices:[t(e),[]],multiline_indices:[n(t(e)),{}]}})),c.internal((function(i){var e=i.Int,t=i.Array,n=i.AnyRef,s=i.Struct,c=i.Nullable;return{selected_glyphs:[t(n()),[]],view:[c(n()),null],image_indices:[t(s({index:e,dim1:e,dim2:e,flat_index:e})),[]]}}))},
function _(e,t,r,o,n){o();var i=e(1),c=e(187);function l(e){return"GlyphRenderer"==e.model.type}function s(e){return"GraphRenderer"==e.model.type}var a=function(){function e(e){this.source=e,this.inspectors=new Map}return e.prototype.select=function(e,t,r,o){var n,c,a,p;void 0===o&&(o="replace");var u=[],_=[];try{for(var h=(0,i.__values)(e),d=h.next();!d.done;d=h.next()){l(m=d.value)?u.push(m):s(m)&&_.push(m)}}catch(e){n={error:e}}finally{try{d&&!d.done&&(c=h.return)&&c.call(h)}finally{if(n)throw n.error}}var y=!1;try{for(var f=(0,i.__values)(_),v=f.next();!v.done;v=f.next()){var m,g=(m=v.value).model.selection_policy.hit_test(t,m);y=y||m.model.selection_policy.do_selection(g,m.model,r,o)}}catch(e){a={error:e}}finally{try{v&&!v.done&&(p=f.return)&&p.call(f)}finally{if(a)throw a.error}}if(u.length>0){g=this.source.selection_policy.hit_test(t,u);y=y||this.source.selection_policy.do_selection(g,this.source,r,o)}return y},e.prototype.inspect=function(e,t){var r=!1;if(l(e)){if(null!=(n=e.hit_test(t))){r=!n.is_empty();var o=this.get_or_create_inspector(e.model);o.update(n,!0,"replace"),this.source.setv({inspected:o},{silent:!0}),this.source.inspect.emit([e.model,{geometry:t}])}}else if(s(e)){var n=e.model.inspection_policy.hit_test(t,e);r=r||e.model.inspection_policy.do_inspection(n,t,e,!1,"replace")}return r},e.prototype.clear=function(e){this.source.selected.clear(),null!=e&&this.get_or_create_inspector(e.model).clear()},e.prototype.get_or_create_inspector=function(e){var t=this.inspectors.get(e);return null==t&&(t=new c.Selection,this.inspectors.set(e,t)),t},e}();r.SelectionManager=a,a.__name__="SelectionManager"},
function _(e,r,t,n,l){n();var o=e(1),u=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return(0,o.__extends)(r,e),r.prototype.do_selection=function(e,r,t,n){return null!=e&&(r.selected.update(e,t,n),r._select.emit(),!r.selected.is_empty())},r}(e(168).Model);t.SelectionPolicy=u,u.__name__="SelectionPolicy";var a=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return(0,o.__extends)(r,e),r.prototype.hit_test=function(e,r){var t,n,l,u,a=[];try{for(var i=(0,o.__values)(r),_=i.next();!_.done;_=i.next()){var c=_.value.hit_test(e);null!=c&&a.push(c)}}catch(e){t={error:e}}finally{try{_&&!_.done&&(n=i.return)&&n.call(i)}finally{if(t)throw t.error}}if(a.length>0){var s=a[0];try{for(var f=(0,o.__values)(a),h=f.next();!h.done;h=f.next()){var y=h.value;s.update_through_intersection(y)}}catch(e){l={error:e}}finally{try{h&&!h.done&&(u=f.return)&&u.call(f)}finally{if(l)throw l.error}}return s}return null},r}(u);t.IntersectRenderers=a,a.__name__="IntersectRenderers";var i=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return(0,o.__extends)(r,e),r.prototype.hit_test=function(e,r){var t,n,l,u,a=[];try{for(var i=(0,o.__values)(r),_=i.next();!_.done;_=i.next()){var c=_.value.hit_test(e);null!=c&&a.push(c)}}catch(e){t={error:e}}finally{try{_&&!_.done&&(n=i.return)&&n.call(i)}finally{if(t)throw t.error}}if(a.length>0){var s=a[0];try{for(var f=(0,o.__values)(a),h=f.next();!h.done;h=f.next()){var y=h.value;s.update_through_union(y)}}catch(e){l={error:e}}finally{try{h&&!h.done&&(u=f.return)&&u.call(f)}finally{if(l)throw l.error}}return s}return null},r}(u);t.UnionRenderers=i,i.__name__="UnionRenderers"},
function _(t,r,e,n,a){n();var o,i=t(1),l=t(185),u=t(125),s=t(128),c=(0,i.__importStar)(t(191)),d=t(192),h=t(150);function _(t,r,e){if((0,u.isArray)(t)){var n=t.concat(r);return null!=e&&n.length>e?n.slice(-e):n}if((0,u.isTypedArray)(t)){var a=t.length+r.length;if(null!=e&&a>e){var o=a-e,i=t.length;n=void 0;t.length<e?(n=new t.constructor(e)).set(t,0):n=t;for(var l=o,s=i;l<s;l++)n[l-o]=n[l];for(l=0,s=r.length;l<s;l++)n[l+(i-o)]=r[l];return n}var d=new t.constructor(r);return c.concat(t,d)}throw new Error("unsupported array types")}function v(t,r){var e,n,a;return(0,u.isNumber)(t)?(e=t,a=t+1,n=1):(e=null!=t.start?t.start:0,a=null!=t.stop?t.stop:r,n=null!=t.step?t.step:1),[e,a,n]}function f(t,r){var e,n,a=new Set,o=!1;try{for(var l=(0,i.__values)(r),s=l.next();!s.done;s=l.next()){var c=(0,i.__read)(s.value,2),d=c[0],h=c[1],_=void 0,f=void 0,y=void 0,m=void 0;if((0,u.isArray)(d)){var p=(0,i.__read)(d,1)[0];a.add(p),_=t[p].shape,f=t[p],m=h,2===d.length?(_=[1,_[0]],y=[d[0],0,d[1]]):y=d}else(0,u.isNumber)(d)?(m=[h],a.add(d)):(m=h,o=!0),y=[0,0,d],_=[1,t.length],f=t;var g=0,w=(0,i.__read)(v(y[1],_[0]),3),x=w[0],S=w[1],A=w[2],C=(0,i.__read)(v(y[2],_[1]),3),D=C[0],E=C[1],b=C[2];for(p=x;p<S;p+=A)for(var N=D;N<E;N+=b)o&&a.add(N),f[p*_[1]+N]=m[g],g++}}catch(t){e={error:t}}finally{try{s&&!s.done&&(n=l.return)&&n.call(l)}finally{if(e)throw e.error}}return a}e.stream_to_column=_,e.slice=v,e.patch_to_column=f;var y=function(t){function r(r){return t.call(this,r)||this}return(0,i.__extends)(r,t),r.prototype.stream=function(t,r,e){var n,a,o=this.data;try{for(var l=(0,i.__values)((0,s.entries)(t)),u=l.next();!u.done;u=l.next()){var c=(0,i.__read)(u.value,2),d=c[0],v=c[1];o[d]=_(o[d],v,r)}}catch(t){n={error:t}}finally{try{u&&!u.done&&(a=l.return)&&a.call(l)}finally{if(n)throw n.error}}if(this.setv({data:o},{silent:!0}),this.streaming.emit(),null!=this.document){var f=new h.ColumnsStreamedEvent(this.document,this.ref(),t,r);this.document._notify_change(this,"data",null,null,{setter_id:e,hint:f})}},r.prototype.patch=function(t,r){var e,n,a=this.data,o=new Set;try{for(var l=(0,i.__values)((0,s.entries)(t)),u=l.next();!u.done;u=l.next()){var c=(0,i.__read)(u.value,2),_=c[0],v=c[1];o=(0,d.union)(o,f(a[_],v))}}catch(t){e={error:t}}finally{try{u&&!u.done&&(n=l.return)&&n.call(l)}finally{if(e)throw e.error}}if(this.setv({data:a},{silent:!0}),this.patching.emit((0,i.__spreadArray)([],(0,i.__read)(o),!1)),null!=this.document){var y=new h.ColumnsPatchedEvent(this.document,this.ref(),t);this.document._notify_change(this,"data",null,null,{setter_id:r,hint:y})}},r}(l.ColumnarDataSource);e.ColumnDataSource=y,o=y,y.__name__="ColumnDataSource",o.define((function(t){return{data:[(0,t.Dict)(t.Any),{}]}}))},
function _(r,e,n,t,a){t();var l=r(1);n.concat=function(r){for(var e,n,t,a,o=[],c=1;c<arguments.length;c++)o[c-1]=arguments[c];var v=r.length;try{for(var f=(0,l.__values)(o),u=f.next();!u.done;u=f.next()){v+=(s=u.value).length}}catch(r){e={error:r}}finally{try{u&&!u.done&&(n=f.return)&&n.call(f)}finally{if(e)throw e.error}}var h=new r.constructor(v);h.set(r,0);var i=r.length;try{for(var y=(0,l.__values)(o),g=y.next();!g.done;g=y.next()){var s=g.value;h.set(s,i),i+=s.length}}catch(r){t={error:r}}finally{try{g&&!g.done&&(a=y.return)&&a.call(y)}finally{if(t)throw t.error}}return h}},
function _(r,e,n,a,t){a();var l=r(1);function o(){for(var r,e,n,a,t=[],o=0;o<arguments.length;o++)t[o]=arguments[o];var f=new Set;try{for(var v=(0,l.__values)(t),i=v.next();!i.done;i=v.next()){var u=i.value;try{for(var c=(n=void 0,(0,l.__values)(u)),y=c.next();!y.done;y=c.next()){var d=y.value;f.add(d)}}catch(r){n={error:r}}finally{try{y&&!y.done&&(a=c.return)&&a.call(c)}finally{if(n)throw n.error}}}}catch(e){r={error:e}}finally{try{i&&!i.done&&(e=v.return)&&e.call(v)}finally{if(r)throw r.error}}return f}n.union=o,n.intersection=function(r){for(var e,n,a,t,o=[],f=1;f<arguments.length;f++)o[f-1]=arguments[f];var v=new Set;try{r:for(var i=(0,l.__values)(r),u=i.next();!u.done;u=i.next()){var c=u.value;try{for(var y=(a=void 0,(0,l.__values)(o)),d=y.next();!d.done;d=y.next()){var _=d.value;if(!_.has(c))continue r}}catch(r){a={error:r}}finally{try{d&&!d.done&&(t=y.return)&&t.call(y)}finally{if(a)throw a.error}}v.add(c)}}catch(r){e={error:r}}finally{try{u&&!u.done&&(n=i.return)&&n.call(i)}finally{if(e)throw e.error}}return v},n.difference=function(r){for(var e,n,a=[],t=1;t<arguments.length;t++)a[t-1]=arguments[t];var f=new Set(r);try{for(var v=(0,l.__values)(o.apply(void 0,(0,l.__spreadArray)([],(0,l.__read)(a),!1))),i=v.next();!i.done;i=v.next()){var u=i.value;f.delete(u)}}catch(r){e={error:r}}finally{try{i&&!i.done&&(n=v.return)&&n.call(v)}finally{if(e)throw e.error}}return f}},
function _(n,r,e,t,a){t();var i=n(1),l=(0,i.__importDefault)(n(194)),o=(0,i.__importDefault)(n(195)),u=n(139),c=new o.default("GOOGLE"),_=new o.default("WGS84"),f=(0,l.default)(_,c);e.wgs84_mercator={compute:function(n,r){return isFinite(n)&&isFinite(r)?f.forward([n,r]):[NaN,NaN]},invert:function(n,r){return isFinite(n)&&isFinite(r)?f.inverse([n,r]):[NaN,NaN]}};var p={lon:[-20026376.39,20026376.39],lat:[-20048966.1,20048966.1]},v={lon:[-180,180],lat:[-85.06,85.06]},s=Math.min,g=Math.max;function h(n,r){var t=s(n.length,r.length),a=(0,u.infer_type)(n,r),i=new a(t),l=new a(t);return e.inplace.project_xy(n,r,i,l),[i,l]}e.clip_mercator=function(n,r,e){var t=(0,i.__read)(p[e],2),a=t[0],l=t[1];return[g(n,a),s(r,l)]},e.in_bounds=function(n,r){var e=(0,i.__read)(v[r],2),t=e[0],a=e[1];return t<n&&n<a},function(n){function r(n,r,t,a){var l=s(n.length,r.length);t=null!=t?t:n,a=null!=a?a:r;for(var o=0;o<l;o++){var u=n[o],c=r[o],_=(0,i.__read)(e.wgs84_mercator.compute(u,c),2),f=_[0],p=_[1];t[o]=f,a[o]=p}}n.project_xy=r,n.project_xsys=function(n,e,t,a){var i=s(n.length,e.length);t=null!=t?t:n,a=null!=a?a:e;for(var l=0;l<i;l++)r(n[l],e[l],t[l],a[l])}}(e.inplace||(e.inplace={})),e.project_xy=h,e.project_xsys=function(n,r){for(var e=s(n.length,r.length),t=new Array(e),a=new Array(e),l=0;l<e;l++){var o=(0,i.__read)(h(n[l],r[l]),2),u=o[0],c=o[1];t[l]=u,a[l]=c}return[t,a]}},
function _(e,n,t,r,o){r();var a=e(1),i=(0,a.__importDefault)(e(195)),c=(0,a.__importDefault)(e(221)),u=(0,i.default)("WGS84");function f(e,n,t,r){var o,a,i;return Array.isArray(t)?(o=(0,c.default)(e,n,t,r)||{x:NaN,y:NaN},t.length>2?void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name?"number"==typeof o.z?[o.x,o.y,o.z].concat(t.splice(3)):[o.x,o.y,t[2]].concat(t.splice(3)):[o.x,o.y].concat(t.splice(2)):[o.x,o.y]):(a=(0,c.default)(e,n,t,r),2===(i=Object.keys(t)).length||i.forEach((function(r){if(void 0!==e.name&&"geocent"===e.name||void 0!==n.name&&"geocent"===n.name){if("x"===r||"y"===r||"z"===r)return}else if("x"===r||"y"===r)return;a[r]=t[r]})),a)}function l(e){return e instanceof i.default?e:e.oProj?e.oProj:(0,i.default)(e)}t.default=function(e,n,t){e=l(e);var r,o=!1;return void 0===n?(n=e,e=u,o=!0):(void 0!==n.x||Array.isArray(n))&&(t=n,n=e,e=u,o=!0),n=l(n),t?f(e,n,t):(r={forward:function(t,r){return f(e,n,t,r)},inverse:function(t,r){return f(n,e,t,r)}},o&&(r.oProj=n),r)}},
function _(t,e,a,s,i){s();var l=t(1),u=(0,l.__importDefault)(t(196)),r=(0,l.__importDefault)(t(207)),d=(0,l.__importDefault)(t(208)),f=t(216),o=(0,l.__importDefault)(t(218)),p=(0,l.__importDefault)(t(219)),m=(0,l.__importDefault)(t(203)),n=t(220);function h(t,e){if(!(this instanceof h))return new h(t);e=e||function(t){if(t)throw t};var a=(0,u.default)(t);if("object"==typeof a){var s=h.projections.get(a.projName);if(s){if(a.datumCode&&"none"!==a.datumCode){var i=(0,m.default)(o.default,a.datumCode);i&&(a.datum_params=a.datum_params||(i.towgs84?i.towgs84.split(","):null),a.ellps=i.ellipse,a.datumName=i.datumName?i.datumName:a.datumCode)}a.k0=a.k0||1,a.axis=a.axis||"enu",a.ellps=a.ellps||"wgs84",a.lat1=a.lat1||a.lat0;var l=(0,f.sphere)(a.a,a.b,a.rf,a.ellps,a.sphere),d=(0,f.eccentricity)(l.a,l.b,l.rf,a.R_A),_=(0,n.getNadgrids)(a.nadgrids),c=a.datum||(0,p.default)(a.datumCode,a.datum_params,l.a,l.b,d.es,d.ep2,_);(0,r.default)(this,a),(0,r.default)(this,s),this.a=l.a,this.b=l.b,this.rf=l.rf,this.sphere=l.sphere,this.es=d.es,this.e=d.e,this.ep2=d.ep2,this.datum=c,this.init(),e(null,this)}else e(t)}else e(t)}h.projections=d.default,h.projections.start(),a.default=h},
function _(t,r,u,n,e){n();var f=t(1),i=(0,f.__importDefault)(t(197)),a=(0,f.__importDefault)(t(204)),o=(0,f.__importDefault)(t(199)),l=(0,f.__importDefault)(t(203));var C=["PROJECTEDCRS","PROJCRS","GEOGCS","GEOCCS","PROJCS","LOCAL_CS","GEODCRS","GEODETICCRS","GEODETICDATUM","ENGCRS","ENGINEERINGCRS"];var d=["3857","900913","3785","102113"];u.default=function(t){if(!function(t){return"string"==typeof t}(t))return t;if(function(t){return t in i.default}(t))return i.default[t];if(function(t){return C.some((function(r){return t.indexOf(r)>-1}))}(t)){var r=(0,a.default)(t);if(function(t){var r=(0,l.default)(t,"authority");if(r){var u=(0,l.default)(r,"epsg");return u&&d.indexOf(u)>-1}}(r))return i.default["EPSG:3857"];var u=function(t){var r=(0,l.default)(t,"extension");if(r)return(0,l.default)(r,"proj4")}(r);return u?(0,o.default)(u):r}return function(t){return"+"===t[0]}(t)?(0,o.default)(t):void 0}},
function _(t,r,i,e,n){e();var a=t(1),f=(0,a.__importDefault)(t(198)),l=(0,a.__importDefault)(t(199)),u=(0,a.__importDefault)(t(204));function o(t){var r=this;if(2===arguments.length){var i=arguments[1];"string"==typeof i?"+"===i.charAt(0)?o[t]=(0,l.default)(arguments[1]):o[t]=(0,u.default)(arguments[1]):o[t]=i}else if(1===arguments.length){if(Array.isArray(t))return t.map((function(t){Array.isArray(t)?o.apply(r,t):o(t)}));if("string"==typeof t){if(t in o)return o[t]}else"EPSG"in t?o["EPSG:"+t.EPSG]=t:"ESRI"in t?o["ESRI:"+t.ESRI]=t:"IAU2000"in t?o["IAU2000:"+t.IAU2000]=t:console.log(t);return}}(0,f.default)(o),i.default=o},
function _(t,l,G,S,e){S(),G.default=function(t){t("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),t("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),t("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"),t.WGS84=t["EPSG:4326"],t["EPSG:3785"]=t["EPSG:3857"],t.GOOGLE=t["EPSG:3857"],t["EPSG:900913"]=t["EPSG:3857"],t["EPSG:102113"]=t["EPSG:3857"]}},
function _(t,n,o,a,u){a();var e=t(1),r=t(200),i=(0,e.__importDefault)(t(201)),f=(0,e.__importDefault)(t(202)),l=(0,e.__importDefault)(t(203));o.default=function(t){var n,o,a,u={},e=t.split("+").map((function(t){return t.trim()})).filter((function(t){return t})).reduce((function(t,n){var o=n.split("=");return o.push(!0),t[o[0].toLowerCase()]=o[1],t}),{}),c={proj:"projName",datum:"datumCode",rf:function(t){u.rf=parseFloat(t)},lat_0:function(t){u.lat0=t*r.D2R},lat_1:function(t){u.lat1=t*r.D2R},lat_2:function(t){u.lat2=t*r.D2R},lat_ts:function(t){u.lat_ts=t*r.D2R},lon_0:function(t){u.long0=t*r.D2R},lon_1:function(t){u.long1=t*r.D2R},lon_2:function(t){u.long2=t*r.D2R},alpha:function(t){u.alpha=parseFloat(t)*r.D2R},gamma:function(t){u.rectified_grid_angle=parseFloat(t)},lonc:function(t){u.longc=t*r.D2R},x_0:function(t){u.x0=parseFloat(t)},y_0:function(t){u.y0=parseFloat(t)},k_0:function(t){u.k0=parseFloat(t)},k:function(t){u.k0=parseFloat(t)},a:function(t){u.a=parseFloat(t)},b:function(t){u.b=parseFloat(t)},r_a:function(){u.R_A=!0},zone:function(t){u.zone=parseInt(t,10)},south:function(){u.utmSouth=!0},towgs84:function(t){u.datum_params=t.split(",").map((function(t){return parseFloat(t)}))},to_meter:function(t){u.to_meter=parseFloat(t)},units:function(t){u.units=t;var n=(0,l.default)(f.default,t);n&&(u.to_meter=n.to_meter)},from_greenwich:function(t){u.from_greenwich=t*r.D2R},pm:function(t){var n=(0,l.default)(i.default,t);u.from_greenwich=(n||parseFloat(t))*r.D2R},nadgrids:function(t){"@null"===t?u.datumCode="none":u.nadgrids=t},axis:function(t){var n="ewnsud";3===t.length&&-1!==n.indexOf(t.substr(0,1))&&-1!==n.indexOf(t.substr(1,1))&&-1!==n.indexOf(t.substr(2,1))&&(u.axis=t)},approx:function(){u.approx=!0}};for(n in e)o=e[n],n in c?"function"==typeof(a=c[n])?a(o):u[a]=o:u[n]=o;return"string"==typeof u.datumCode&&"WGS84"!==u.datumCode&&(u.datumCode=u.datumCode.toLowerCase()),u}},
function _(S,_,P,R,I){R(),P.PJD_3PARAM=1,P.PJD_7PARAM=2,P.PJD_GRIDSHIFT=3,P.PJD_WGS84=4,P.PJD_NODATUM=5,P.SRS_WGS84_SEMIMAJOR=6378137,P.SRS_WGS84_SEMIMINOR=6356752.314,P.SRS_WGS84_ESQUARED=.0066943799901413165,P.SEC_TO_RAD=484813681109536e-20,P.HALF_PI=Math.PI/2,P.SIXTH=.16666666666666666,P.RA4=.04722222222222222,P.RA6=.022156084656084655,P.EPSLN=1e-10,P.D2R=.017453292519943295,P.R2D=57.29577951308232,P.FORTPI=Math.PI/4,P.TWO_PI=2*Math.PI,P.SPI=3.14159265359},
function _(o,r,a,e,s){e();var n={};a.default=n,n.greenwich=0,n.lisbon=-9.131906111111,n.paris=2.337229166667,n.bogota=-74.080916666667,n.madrid=-3.687938888889,n.rome=12.452333333333,n.bern=7.439583333333,n.jakarta=106.807719444444,n.ferro=-17.666666666667,n.brussels=4.367975,n.stockholm=18.058277777778,n.athens=23.7163375,n.oslo=10.722916666667},
function _(t,e,f,o,u){o(),f.default={ft:{to_meter:.3048},"us-ft":{to_meter:1200/3937}}},
function _(e,r,t,a,n){a();var o=/[\s_\-\/\(\)]/g;t.default=function(e,r){if(e[r])return e[r];for(var t,a=Object.keys(e),n=r.toLowerCase().replace(o,""),f=-1;++f<a.length;)if((t=a[f]).toLowerCase().replace(o,"")===n)return e[t]}},
function _(e,a,t,o,n){o();var r=e(1),l=(0,r.__importDefault)(e(205)),d=e(206);function i(e){return.017453292519943295*e}t.default=function(e){var a=(0,l.default)(e),t=a.shift(),o=a.shift();a.unshift(["name",o]),a.unshift(["type",t]);var n={};return(0,d.sExpr)(a,n),function(e){if("GEOGCS"===e.type?e.projName="longlat":"LOCAL_CS"===e.type?(e.projName="identity",e.local=!0):"object"==typeof e.PROJECTION?e.projName=Object.keys(e.PROJECTION)[0]:e.projName=e.PROJECTION,e.AXIS){for(var a="",t=0,o=e.AXIS.length;t<o;++t){var n=[e.AXIS[t][0].toLowerCase(),e.AXIS[t][1].toLowerCase()];-1!==n[0].indexOf("north")||("y"===n[0]||"lat"===n[0])&&"north"===n[1]?a+="n":-1!==n[0].indexOf("south")||("y"===n[0]||"lat"===n[0])&&"south"===n[1]?a+="s":-1!==n[0].indexOf("east")||("x"===n[0]||"lon"===n[0])&&"east"===n[1]?a+="e":-1===n[0].indexOf("west")&&("x"!==n[0]&&"lon"!==n[0]||"west"!==n[1])||(a+="w")}2===a.length&&(a+="u"),3===a.length&&(e.axis=a)}e.UNIT&&(e.units=e.UNIT.name.toLowerCase(),"metre"===e.units&&(e.units="meter"),e.UNIT.convert&&("GEOGCS"===e.type?e.DATUM&&e.DATUM.SPHEROID&&(e.to_meter=e.UNIT.convert*e.DATUM.SPHEROID.a):e.to_meter=e.UNIT.convert));var r=e.GEOGCS;function l(a){return a*(e.to_meter||1)}"GEOGCS"===e.type&&(r=e),r&&(r.DATUM?e.datumCode=r.DATUM.name.toLowerCase():e.datumCode=r.name.toLowerCase(),"d_"===e.datumCode.slice(0,2)&&(e.datumCode=e.datumCode.slice(2)),"new_zealand_geodetic_datum_1949"!==e.datumCode&&"new_zealand_1949"!==e.datumCode||(e.datumCode="nzgd49"),"wgs_1984"!==e.datumCode&&"world_geodetic_system_1984"!==e.datumCode||("Mercator_Auxiliary_Sphere"===e.PROJECTION&&(e.sphere=!0),e.datumCode="wgs84"),"_ferro"===e.datumCode.slice(-6)&&(e.datumCode=e.datumCode.slice(0,-6)),"_jakarta"===e.datumCode.slice(-8)&&(e.datumCode=e.datumCode.slice(0,-8)),~e.datumCode.indexOf("belge")&&(e.datumCode="rnb72"),r.DATUM&&r.DATUM.SPHEROID&&(e.ellps=r.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),"international"===e.ellps.toLowerCase().slice(0,13)&&(e.ellps="intl"),e.a=r.DATUM.SPHEROID.a,e.rf=parseFloat(r.DATUM.SPHEROID.rf,10)),r.DATUM&&r.DATUM.TOWGS84&&(e.datum_params=r.DATUM.TOWGS84),~e.datumCode.indexOf("osgb_1936")&&(e.datumCode="osgb36"),~e.datumCode.indexOf("osni_1952")&&(e.datumCode="osni52"),(~e.datumCode.indexOf("tm65")||~e.datumCode.indexOf("geodetic_datum_of_1965"))&&(e.datumCode="ire65"),"ch1903+"===e.datumCode&&(e.datumCode="ch1903"),~e.datumCode.indexOf("israel")&&(e.datumCode="isr93")),e.b&&!isFinite(e.b)&&(e.b=e.a),[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_1","Latitude of 1st standard parallel"],["standard_parallel_2","Standard_Parallel_2"],["standard_parallel_2","Latitude of 2nd standard parallel"],["false_easting","False_Easting"],["false_easting","False easting"],["false-easting","Easting at false origin"],["false_northing","False_Northing"],["false_northing","False northing"],["false_northing","Northing at false origin"],["central_meridian","Central_Meridian"],["central_meridian","Longitude of natural origin"],["central_meridian","Longitude of false origin"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["latitude_of_origin","Latitude of natural origin"],["latitude_of_origin","Latitude of false origin"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_Of_Center"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",i],["longitude_of_center","Longitude_Of_Center"],["longitude_of_center","Longitude_of_center"],["longc","longitude_of_center",i],["x0","false_easting",l],["y0","false_northing",l],["long0","central_meridian",i],["lat0","latitude_of_origin",i],["lat0","standard_parallel_1",i],["lat1","standard_parallel_1",i],["lat2","standard_parallel_2",i],["azimuth","Azimuth"],["alpha","azimuth",i],["srsCode","name"]].forEach((function(a){return t=e,n=(o=a)[0],r=o[1],void(!(n in t)&&r in t&&(t[n]=t[r],3===o.length&&(t[n]=o[2](t[n]))));var t,o,n,r})),e.long0||!e.longc||"Albers_Conic_Equal_Area"!==e.projName&&"Lambert_Azimuthal_Equal_Area"!==e.projName||(e.long0=e.longc),e.lat_ts||!e.lat1||"Stereographic_South_Pole"!==e.projName&&"Polar Stereographic (variant B)"!==e.projName||(e.lat0=i(e.lat1>0?90:-90),e.lat_ts=e.lat1)}(n),n}},
function _(t,e,r,i,s){i(),r.default=function(t){return new d(t).output()};var h=/\s/,o=/[A-Za-z]/,n=/[A-Za-z84]/,a=/[,\]]/,u=/[\d\.E\-\+]/;function d(t){if("string"!=typeof t)throw new Error("not a string");this.text=t.trim(),this.level=0,this.place=0,this.root=null,this.stack=[],this.currentObject=null,this.state=1}d.prototype.readCharicter=function(){var t=this.text[this.place++];if(4!==this.state)for(;h.test(t);){if(this.place>=this.text.length)return;t=this.text[this.place++]}switch(this.state){case 1:return this.neutral(t);case 2:return this.keyword(t);case 4:return this.quoted(t);case 5:return this.afterquote(t);case 3:return this.number(t);case-1:return}},d.prototype.afterquote=function(t){if('"'===t)return this.word+='"',void(this.state=4);if(a.test(t))return this.word=this.word.trim(),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in afterquote yet, index '+this.place)},d.prototype.afterItem=function(t){return","===t?(null!==this.word&&this.currentObject.push(this.word),this.word=null,void(this.state=1)):"]"===t?(this.level--,null!==this.word&&(this.currentObject.push(this.word),this.word=null),this.state=1,this.currentObject=this.stack.pop(),void(this.currentObject||(this.state=-1))):void 0},d.prototype.number=function(t){if(!u.test(t)){if(a.test(t))return this.word=parseFloat(this.word),void this.afterItem(t);throw new Error("havn't handled \""+t+'" in number yet, index '+this.place)}this.word+=t},d.prototype.quoted=function(t){'"'!==t?this.word+=t:this.state=5},d.prototype.keyword=function(t){if(n.test(t))this.word+=t;else{if("["===t){var e=[];return e.push(this.word),this.level++,null===this.root?this.root=e:this.currentObject.push(e),this.stack.push(this.currentObject),this.currentObject=e,void(this.state=1)}if(!a.test(t))throw new Error("havn't handled \""+t+'" in keyword yet, index '+this.place);this.afterItem(t)}},d.prototype.neutral=function(t){if(o.test(t))return this.word=t,void(this.state=2);if('"'===t)return this.word="",void(this.state=4);if(u.test(t))return this.word=t,void(this.state=3);if(!a.test(t))throw new Error("havn't handled \""+t+'" in neutral yet, index '+this.place);this.afterItem(t)},d.prototype.output=function(){for(;this.place<this.text.length;)this.readCharicter();if(-1===this.state)return this.root;throw new Error('unable to parse string "'+this.text+'". State is '+this.state)}},
function _(e,a,r,s,c){function n(e,a,r){Array.isArray(a)&&(r.unshift(a),a=null);var s=a?{}:e,c=r.reduce((function(e,a){return E(a,e),e}),s);a&&(e[a]=c)}function E(e,a){if(Array.isArray(e)){var r=e.shift();if("PARAMETER"===r&&(r=e.shift()),1===e.length)return Array.isArray(e[0])?(a[r]={},void E(e[0],a[r])):void(a[r]=e[0]);if(e.length)if("TOWGS84"!==r){if("AXIS"===r)return r in a||(a[r]=[]),void a[r].push(e);var s;switch(Array.isArray(r)||(a[r]={}),r){case"UNIT":case"PRIMEM":case"VERT_DATUM":return a[r]={name:e[0].toLowerCase(),convert:e[1]},void(3===e.length&&E(e[2],a[r]));case"SPHEROID":case"ELLIPSOID":return a[r]={name:e[0],a:e[1],rf:e[2]},void(4===e.length&&E(e[3],a[r]));case"PROJECTEDCRS":case"PROJCRS":case"GEOGCS":case"GEOCCS":case"PROJCS":case"LOCAL_CS":case"GEODCRS":case"GEODETICCRS":case"GEODETICDATUM":case"EDATUM":case"ENGINEERINGDATUM":case"VERT_CS":case"VERTCRS":case"VERTICALCRS":case"COMPD_CS":case"COMPOUNDCRS":case"ENGINEERINGCRS":case"ENGCRS":case"FITTED_CS":case"LOCAL_DATUM":case"DATUM":return e[0]=["name",e[0]],void n(a,r,e);default:for(s=-1;++s<e.length;)if(!Array.isArray(e[s]))return E(e,a[r]);return n(a,r,e)}}else a[r]=e;else a[r]=!0}else a[e]=!0}s(),r.sExpr=E},
function _(n,r,f,i,t){i(),f.default=function(n,r){var f,i;if(n=n||{},!r)return n;for(i in r)void 0!==(f=r[i])&&(n[i]=f);return n}},
function _(t,a,e,o,n){o();var r=t(1),f=(0,r.__importDefault)(t(209)),u=(0,r.__importDefault)(t(215)),i=[f.default,u.default],d={},c=[];function l(t,a){var e=c.length;return t.names?(c[e]=t,t.names.forEach((function(t){d[t.toLowerCase()]=e})),this):(console.log(a),!0)}function s(t){if(!t)return!1;var a=t.toLowerCase();return void 0!==d[a]&&c[d[a]]?c[d[a]]:void 0}function v(){i.forEach(l)}e.add=l,e.get=s,e.start=v,e.default={start:v,add:l,get:s}},
function _(t,i,s,h,a){h();var e=t(1),r=(0,e.__importDefault)(t(210)),n=(0,e.__importDefault)(t(211)),l=(0,e.__importDefault)(t(213)),u=(0,e.__importDefault)(t(214)),o=t(200);function f(){var t=this.b/this.a;this.es=1-t*t,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=(0,r.default)(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)}function _(t){var i,s,h=t.x,a=t.y;if(a*o.R2D>90&&a*o.R2D<-90&&h*o.R2D>180&&h*o.R2D<-180)return null;if(Math.abs(Math.abs(a)-o.HALF_PI)<=o.EPSLN)return null;if(this.sphere)i=this.x0+this.a*this.k0*(0,n.default)(h-this.long0),s=this.y0+this.a*this.k0*Math.log(Math.tan(o.FORTPI+.5*a));else{var e=Math.sin(a),r=(0,l.default)(this.e,a,e);i=this.x0+this.a*this.k0*(0,n.default)(h-this.long0),s=this.y0-this.a*this.k0*Math.log(r)}return t.x=i,t.y=s,t}function M(t){var i,s,h=t.x-this.x0,a=t.y-this.y0;if(this.sphere)s=o.HALF_PI-2*Math.atan(Math.exp(-a/(this.a*this.k0)));else{var e=Math.exp(-a/(this.a*this.k0));if(-9999===(s=(0,u.default)(this.e,e)))return null}return i=(0,n.default)(this.long0+h/(this.a*this.k0)),t.x=i,t.y=s,t}s.init=f,s.forward=_,s.inverse=M,s.names=["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","merc"],s.default={init:f,forward:_,inverse:M,names:s.names}},
function _(t,n,r,u,a){u(),r.default=function(t,n,r){var u=t*n;return r/Math.sqrt(1-u*u)}},
function _(t,a,u,f,n){f();var e=t(1),r=t(200),_=(0,e.__importDefault)(t(212));u.default=function(t){return Math.abs(t)<=r.SPI?t:t-(0,_.default)(t)*r.TWO_PI}},
function _(n,t,u,f,c){f(),u.default=function(n){return n<0?-1:1}},
function _(t,a,n,r,u){r();var f=t(200);n.default=function(t,a,n){var r=t*n,u=.5*t;return r=Math.pow((1-r)/(1+r),u),Math.tan(.5*(f.HALF_PI-a))/r}},
function _(a,t,n,r,f){r();var h=a(200);n.default=function(a,t){for(var n,r,f=.5*a,u=h.HALF_PI-2*Math.atan(t),M=0;M<=15;M++)if(n=a*Math.sin(u),u+=r=h.HALF_PI-2*Math.atan(t*Math.pow((1-n)/(1+n),f))-u,Math.abs(r)<=1e-10)return u;return-9999}},
function _(n,i,e,t,r){function a(){}function f(n){return n}t(),e.init=a,e.forward=f,e.inverse=f,e.names=["longlat","identity"],e.default={init:a,forward:f,inverse:f,names:e.names}},
function _(r,t,e,a,f){a();var n=r(1),i=r(200),u=(0,n.__importStar)(r(217)),c=(0,n.__importDefault)(r(203));e.eccentricity=function(r,t,e,a){var f=r*r,n=t*t,u=(f-n)/f,c=0;return a?(f=(r*=1-u*(i.SIXTH+u*(i.RA4+u*i.RA6)))*r,u=0):c=Math.sqrt(u),{es:u,e:c,ep2:(f-n)/n}},e.sphere=function(r,t,e,a,f){if(!r){var n=(0,c.default)(u.default,a);n||(n=u.WGS84),r=n.a,t=n.b,e=n.rf}return e&&!t&&(t=(1-1/e)*r),(0===e||Math.abs(r-t)<i.EPSLN)&&(f=!0,t=r),{a:r,b:t,rf:e,sphere:f}}},
function _(e,a,l,s,r){s();var i={};l.default=i,i.MERIT={a:6378137,rf:298.257,ellipseName:"MERIT 1983"},i.SGS85={a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},i.GRS80={a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},i.IAU76={a:6378140,rf:298.257,ellipseName:"IAU 1976"},i.airy={a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},i.APL4={a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},i.NWL9D={a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},i.mod_airy={a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},i.andrae={a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},i.aust_SA={a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},i.GRS67={a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},i.bessel={a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},i.bess_nam={a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},i.clrk66={a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},i.clrk80={a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},i.clrk58={a:6378293.645208759,rf:294.2606763692654,ellipseName:"Clarke 1858"},i.CPM={a:6375738.7,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},i.delmbr={a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},i.engelis={a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},i.evrst30={a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},i.evrst48={a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},i.evrst56={a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},i.evrst69={a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},i.evrstSS={a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},i.fschr60={a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},i.fschr60m={a:6378155,rf:298.3,ellipseName:"Fischer 1960"},i.fschr68={a:6378150,rf:298.3,ellipseName:"Fischer 1968"},i.helmert={a:6378200,rf:298.3,ellipseName:"Helmert 1906"},i.hough={a:6378270,rf:297,ellipseName:"Hough"},i.intl={a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},i.kaula={a:6378163,rf:298.24,ellipseName:"Kaula 1961"},i.lerch={a:6378139,rf:298.257,ellipseName:"Lerch 1979"},i.mprts={a:6397300,rf:191,ellipseName:"Maupertius 1738"},i.new_intl={a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},i.plessis={a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},i.krass={a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},i.SEasia={a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},i.walbeck={a:6376896,b:6355834.8467,ellipseName:"Walbeck"},i.WGS60={a:6378165,rf:298.3,ellipseName:"WGS 60"},i.WGS66={a:6378145,rf:298.25,ellipseName:"WGS 66"},i.WGS7={a:6378135,rf:298.26,ellipseName:"WGS 72"},l.WGS84=i.WGS84={a:6378137,rf:298.257223563,ellipseName:"WGS 84"},i.sphere={a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"}},
function _(e,a,s,t,l){t();var m={};s.default=m,m.wgs84={towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},m.ch1903={towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},m.ggrs87={towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},m.nad83={towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},m.nad27={nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},m.potsdam={towgs84:"598.1,73.7,418.2,0.202,0.045,-2.455,6.7",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},m.carthage={towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},m.hermannskogel={towgs84:"577.326,90.129,463.919,5.137,1.474,5.297,2.4232",ellipse:"bessel",datumName:"Hermannskogel"},m.osni52={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"airy",datumName:"Irish National"},m.ire65={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},m.rassadiran={towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},m.nzgd49={towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},m.osgb36={towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"},m.s_jtsk={towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},m.beduaram={towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},m.gunung_segara={towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},m.rnb72={towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"}},
function _(a,m,_,t,u){t();var d=a(200);_.default=function(a,m,_,t,u,p,r){var s={};return s.datum_type=void 0===a||"none"===a?d.PJD_NODATUM:d.PJD_WGS84,m&&(s.datum_params=m.map(parseFloat),0===s.datum_params[0]&&0===s.datum_params[1]&&0===s.datum_params[2]||(s.datum_type=d.PJD_3PARAM),s.datum_params.length>3&&(0===s.datum_params[3]&&0===s.datum_params[4]&&0===s.datum_params[5]&&0===s.datum_params[6]||(s.datum_type=d.PJD_7PARAM,s.datum_params[3]*=d.SEC_TO_RAD,s.datum_params[4]*=d.SEC_TO_RAD,s.datum_params[5]*=d.SEC_TO_RAD,s.datum_params[6]=s.datum_params[6]/1e6+1))),r&&(s.datum_type=d.PJD_GRIDSHIFT,s.grids=r),s.a=_,s.b=t,s.es=u,s.ep2=p,s}},
function _(t,e,n,r,i){r();var u={};function l(t){if(0===t.length)return null;var e="@"===t[0];return e&&(t=t.slice(1)),"null"===t?{name:"null",mandatory:!e,grid:null,isNull:!0}:{name:t,mandatory:!e,grid:u[t]||null,isNull:!1}}function o(t){return t/3600*Math.PI/180}function a(t,e,n){return String.fromCharCode.apply(null,new Uint8Array(t.buffer.slice(e,n)))}function d(t){return t.map((function(t){return[o(t.longitudeShift),o(t.latitudeShift)]}))}function g(t,e,n){return{name:a(t,e+8,e+16).trim(),parent:a(t,e+24,e+24+8).trim(),lowerLatitude:t.getFloat64(e+72,n),upperLatitude:t.getFloat64(e+88,n),lowerLongitude:t.getFloat64(e+104,n),upperLongitude:t.getFloat64(e+120,n),latitudeInterval:t.getFloat64(e+136,n),longitudeInterval:t.getFloat64(e+152,n),gridNodeCount:t.getInt32(e+168,n)}}function s(t,e,n,r){for(var i=e+176,u=[],l=0;l<n.gridNodeCount;l++){var o={latitudeShift:t.getFloat32(i+16*l,r),longitudeShift:t.getFloat32(i+16*l+4,r),latitudeAccuracy:t.getFloat32(i+16*l+8,r),longitudeAccuracy:t.getFloat32(i+16*l+12,r)};u.push(o)}return u}n.default=function(t,e){var n=new DataView(e),r=function(t){var e=t.getInt32(8,!1);if(11===e)return!1;11!==(e=t.getInt32(8,!0))&&console.warn("Failed to detect nadgrid endian-ness, defaulting to little-endian");return!0}(n),i=function(t,e){return{nFields:t.getInt32(8,e),nSubgridFields:t.getInt32(24,e),nSubgrids:t.getInt32(40,e),shiftType:a(t,56,64).trim(),fromSemiMajorAxis:t.getFloat64(120,e),fromSemiMinorAxis:t.getFloat64(136,e),toSemiMajorAxis:t.getFloat64(152,e),toSemiMinorAxis:t.getFloat64(168,e)}}(n,r);i.nSubgrids>1&&console.log("Only single NTv2 subgrids are currently supported, subsequent sub grids are ignored");var l=function(t,e,n){for(var r=176,i=[],u=0;u<e.nSubgrids;u++){var l=g(t,r,n),a=s(t,r,l,n),f=Math.round(1+(l.upperLongitude-l.lowerLongitude)/l.longitudeInterval),c=Math.round(1+(l.upperLatitude-l.lowerLatitude)/l.latitudeInterval);i.push({ll:[o(l.lowerLongitude),o(l.lowerLatitude)],del:[o(l.longitudeInterval),o(l.latitudeInterval)],lim:[f,c],count:l.gridNodeCount,cvs:d(a)})}return i}(n,i,r),f={header:i,subgrids:l};return u[t]=f,f},n.getNadgrids=function(t){return void 0===t?null:t.split(",").map(l)}},
function _(t,e,a,r,u){r();var m=t(1),_=t(200),o=(0,m.__importDefault)(t(222)),d=(0,m.__importDefault)(t(224)),f=(0,m.__importDefault)(t(195)),i=(0,m.__importDefault)(t(225)),n=(0,m.__importDefault)(t(226));a.default=function t(e,a,r,u){var m;if(Array.isArray(r)&&(r=(0,i.default)(r)),(0,n.default)(r),e.datum&&a.datum&&function(t,e){return(t.datum.datum_type===_.PJD_3PARAM||t.datum.datum_type===_.PJD_7PARAM)&&"WGS84"!==e.datumCode||(e.datum.datum_type===_.PJD_3PARAM||e.datum.datum_type===_.PJD_7PARAM)&&"WGS84"!==t.datumCode}(e,a)&&(r=t(e,m=new f.default("WGS84"),r,u),e=m),u&&"enu"!==e.axis&&(r=(0,d.default)(e,!1,r)),"longlat"===e.projName)r={x:r.x*_.D2R,y:r.y*_.D2R,z:r.z||0};else if(e.to_meter&&(r={x:r.x*e.to_meter,y:r.y*e.to_meter,z:r.z||0}),!(r=e.inverse(r)))return;if(e.from_greenwich&&(r.x+=e.from_greenwich),r=(0,o.default)(e.datum,a.datum,r))return a.from_greenwich&&(r={x:r.x-a.from_greenwich,y:r.y,z:r.z||0}),"longlat"===a.projName?r={x:r.x*_.R2D,y:r.y*_.R2D,z:r.z||0}:(r=a.forward(r),a.to_meter&&(r={x:r.x/a.to_meter,y:r.y/a.to_meter,z:r.z||0})),u&&"enu"!==a.axis?(0,d.default)(a,!0,r):r}},
function _(r,e,t,a,i){a();var l=r(1),n=r(200),o=r(223),u=(0,l.__importDefault)(r(211));function d(r){return r===n.PJD_3PARAM||r===n.PJD_7PARAM}function s(r,e,t){if(null===r.grids||0===r.grids.length)return console.log("Grid shift grids not found"),-1;for(var a={x:-t.x,y:t.y},i={x:Number.NaN,y:Number.NaN},l=[],o=0;o<r.grids.length;o++){var u=r.grids[o];if(l.push(u.name),u.isNull){i=a;break}if(u.mandatory,null!==u.grid){var d=u.grid.subgrids[0],s=(Math.abs(d.del[1])+Math.abs(d.del[0]))/1e4,f=d.ll[0]-s,x=d.ll[1]-s,m=d.ll[0]+(d.lim[0]-1)*d.del[0]+s,N=d.ll[1]+(d.lim[1]-1)*d.del[1]+s;if(!(x>a.y||f>a.x||N<a.y||m<a.x||(i=y(a,e,d),isNaN(i.x))))break}else if(u.mandatory)return console.log("Unable to find mandatory grid '"+u.name+"'"),-1}return isNaN(i.x)?(console.log("Failed to find a grid shift table for location '"+-a.x*n.R2D+" "+a.y*n.R2D+" tried: '"+l+"'"),-1):(t.x=-i.x,t.y=i.y,0)}function y(r,e,t){var a={x:Number.NaN,y:Number.NaN};if(isNaN(r.x))return a;var i={x:r.x,y:r.y};i.x-=t.ll[0],i.y-=t.ll[1],i.x=(0,u.default)(i.x-Math.PI)+Math.PI;var l=f(i,t);if(e){if(isNaN(l.x))return a;l.x=i.x-l.x,l.y=i.y-l.y;var n,o,d=9;do{if(o=f(l,t),isNaN(o.x)){console.log("Inverse grid shift iteration failed, presumably at grid edge.  Using first approximation.");break}n={x:i.x-(o.x+l.x),y:i.y-(o.y+l.y)},l.x+=n.x,l.y+=n.y}while(d--&&Math.abs(n.x)>1e-12&&Math.abs(n.y)>1e-12);if(d<0)return console.log("Inverse grid shift iterator failed to converge."),a;a.x=(0,u.default)(l.x+t.ll[0]),a.y=l.y+t.ll[1]}else isNaN(l.x)||(a.x=r.x+l.x,a.y=r.y+l.y);return a}function f(r,e){var t,a={x:r.x/e.del[0],y:r.y/e.del[1]},i=Math.floor(a.x),l=Math.floor(a.y),n=a.x-1*i,o=a.y-1*l,u={x:Number.NaN,y:Number.NaN};if(i<0||i>=e.lim[0])return u;if(l<0||l>=e.lim[1])return u;t=l*e.lim[0]+i;var d=e.cvs[t][0],s=e.cvs[t][1];t++;var y=e.cvs[t][0],f=e.cvs[t][1];t+=e.lim[0];var x=e.cvs[t][0],m=e.cvs[t][1];t--;var N=e.cvs[t][0],_=e.cvs[t][1],c=n*o,g=n*(1-o),v=(1-n)*(1-o),S=(1-n)*o;return u.x=v*d+g*y+S*N+c*x,u.y=v*s+g*f+S*_+c*m,u}t.default=function(r,e,t){if((0,o.compareDatums)(r,e))return t;if(r.datum_type===n.PJD_NODATUM||e.datum_type===n.PJD_NODATUM)return t;var a=r.a,i=r.es;if(r.datum_type===n.PJD_GRIDSHIFT){if(0!==s(r,!1,t))return;a=n.SRS_WGS84_SEMIMAJOR,i=n.SRS_WGS84_ESQUARED}var l=e.a,u=e.b,y=e.es;if(e.datum_type===n.PJD_GRIDSHIFT&&(l=n.SRS_WGS84_SEMIMAJOR,u=n.SRS_WGS84_SEMIMINOR,y=n.SRS_WGS84_ESQUARED),i===y&&a===l&&!d(r.datum_type)&&!d(e.datum_type))return t;if(t=(0,o.geodeticToGeocentric)(t,i,a),d(r.datum_type)&&(t=(0,o.geocentricToWgs84)(t,r.datum_type,r.datum_params)),d(e.datum_type)&&(t=(0,o.geocentricFromWgs84)(t,e.datum_type,e.datum_params)),t=(0,o.geocentricToGeodetic)(t,y,l,u),e.datum_type===n.PJD_GRIDSHIFT&&0!==s(e,!0,t))return;return t},t.applyGridShift=s},
function _(a,t,r,m,u){m();var s=a(200);r.compareDatums=function(a,t){return a.datum_type===t.datum_type&&(!(a.a!==t.a||Math.abs(a.es-t.es)>5e-11)&&(a.datum_type===s.PJD_3PARAM?a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]:a.datum_type!==s.PJD_7PARAM||a.datum_params[0]===t.datum_params[0]&&a.datum_params[1]===t.datum_params[1]&&a.datum_params[2]===t.datum_params[2]&&a.datum_params[3]===t.datum_params[3]&&a.datum_params[4]===t.datum_params[4]&&a.datum_params[5]===t.datum_params[5]&&a.datum_params[6]===t.datum_params[6]))},r.geodeticToGeocentric=function(a,t,r){var m,u,_,e,n=a.x,d=a.y,i=a.z?a.z:0;if(d<-s.HALF_PI&&d>-1.001*s.HALF_PI)d=-s.HALF_PI;else if(d>s.HALF_PI&&d<1.001*s.HALF_PI)d=s.HALF_PI;else{if(d<-s.HALF_PI)return{x:-1/0,y:-1/0,z:a.z};if(d>s.HALF_PI)return{x:1/0,y:1/0,z:a.z}}return n>Math.PI&&(n-=2*Math.PI),u=Math.sin(d),e=Math.cos(d),_=u*u,{x:((m=r/Math.sqrt(1-t*_))+i)*e*Math.cos(n),y:(m+i)*e*Math.sin(n),z:(m*(1-t)+i)*u}},r.geocentricToGeodetic=function(a,t,r,m){var u,_,e,n,d,i,p,P,y,z,M,A,o,c,x,h=1e-12,f=a.x,I=a.y,F=a.z?a.z:0;if(u=Math.sqrt(f*f+I*I),_=Math.sqrt(f*f+I*I+F*F),u/r<h){if(c=0,_/r<h)return s.HALF_PI,x=-m,{x:a.x,y:a.y,z:a.z}}else c=Math.atan2(I,f);e=F/_,P=(n=u/_)*(1-t)*(d=1/Math.sqrt(1-t*(2-t)*n*n)),y=e*d,o=0;do{o++,i=t*(p=r/Math.sqrt(1-t*y*y))/(p+(x=u*P+F*y-p*(1-t*y*y))),A=(M=e*(d=1/Math.sqrt(1-i*(2-i)*n*n)))*P-(z=n*(1-i)*d)*y,P=z,y=M}while(A*A>1e-24&&o<30);return{x:c,y:Math.atan(M/Math.abs(z)),z:x}},r.geocentricToWgs84=function(a,t,r){if(t===s.PJD_3PARAM)return{x:a.x+r[0],y:a.y+r[1],z:a.z+r[2]};if(t===s.PJD_7PARAM){var m=r[0],u=r[1],_=r[2],e=r[3],n=r[4],d=r[5],i=r[6];return{x:i*(a.x-d*a.y+n*a.z)+m,y:i*(d*a.x+a.y-e*a.z)+u,z:i*(-n*a.x+e*a.y+a.z)+_}}},r.geocentricFromWgs84=function(a,t,r){if(t===s.PJD_3PARAM)return{x:a.x-r[0],y:a.y-r[1],z:a.z-r[2]};if(t===s.PJD_7PARAM){var m=r[0],u=r[1],_=r[2],e=r[3],n=r[4],d=r[5],i=r[6],p=(a.x-m)/i,P=(a.y-u)/i,y=(a.z-_)/i;return{x:p+d*P-n*y,y:-d*p+P+e*y,z:n*p-e*P+y}}}},
function _(e,a,i,r,s){r(),i.default=function(e,a,i){var r,s,n,c=i.x,d=i.y,f=i.z||0,u={};for(n=0;n<3;n++)if(!a||2!==n||void 0!==i.z)switch(0===n?(r=c,s=-1!=="ew".indexOf(e.axis[n])?"x":"y"):1===n?(r=d,s=-1!=="ns".indexOf(e.axis[n])?"y":"x"):(r=f,s="z"),e.axis[n]){case"e":u[s]=r;break;case"w":u[s]=-r;break;case"n":u[s]=r;break;case"s":u[s]=-r;break;case"u":void 0!==i[s]&&(u.z=r);break;case"d":void 0!==i[s]&&(u.z=-r);break;default:return null}return u}},
function _(n,t,e,u,f){u(),e.default=function(n){var t={x:n[0],y:n[1]};return n.length>2&&(t.z=n[2]),n.length>3&&(t.m=n[3]),t}},
function _(e,i,n,t,r){function o(e){if("function"==typeof Number.isFinite){if(Number.isFinite(e))return;throw new TypeError("coordinates must be finite numbers")}if("number"!=typeof e||e!=e||!isFinite(e))throw new TypeError("coordinates must be finite numbers")}t(),n.default=function(e){o(e.x),o(e.y)}},
function _(e,t,i,n,o){n();var r,l,s,a,u,_=e(1),c=e(168),v=e(157),p=(0,_.__importStar)(e(160)),f=e(163),h=(0,_.__importStar)(e(133)),d=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,_.__extends)(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.visuals=new p.Visuals(this)},t.prototype.request_render=function(){this.parent.request_render()},Object.defineProperty(t.prototype,"canvas",{get:function(){return this.parent.canvas},enumerable:!1,configurable:!0}),t.prototype.set_data=function(e){var t,i;try{for(var n=(0,_.__values)(this.model),o=n.next();!o.done;o=n.next()){var r=o.value;if(r instanceof h.VectorSpec||r instanceof h.ScalarSpec){var l=r.uniform(e);this[""+r.attr]=l}}}catch(e){t={error:e}}finally{try{o&&!o.done&&(i=n.return)&&i.call(n)}finally{if(t)throw t.error}}},t}(v.View);i.ArrowHeadView=d,d.__name__="ArrowHeadView";var m=function(e){function t(t){return e.call(this,t)||this}return(0,_.__extends)(t,e),t}(c.Model);i.ArrowHead=m,r=m,m.__name__="ArrowHead",r.define((function(){return{size:[h.NumberSpec,25]}}));var T=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,_.__extends)(t,e),t.prototype.clip=function(e,t){this.visuals.line.set_vectorize(e,t);var i=this.size.get(t);e.moveTo(.5*i,i),e.lineTo(.5*i,-2),e.lineTo(-.5*i,-2),e.lineTo(-.5*i,i),e.lineTo(0,0),e.lineTo(.5*i,i)},t.prototype.render=function(e,t){if(this.visuals.line.doit){this.visuals.line.set_vectorize(e,t);var i=this.size.get(t);e.beginPath(),e.moveTo(.5*i,i),e.lineTo(0,0),e.lineTo(-.5*i,i),e.stroke()}},t}(d);i.OpenHeadView=T,T.__name__="OpenHeadView";var y=function(e){function t(t){return e.call(this,t)||this}return(0,_.__extends)(t,e),t}(m);i.OpenHead=y,l=y,y.__name__="OpenHead",l.prototype.default_view=T,l.mixins(f.LineVector);var V=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,_.__extends)(t,e),t.prototype.clip=function(e,t){this.visuals.line.set_vectorize(e,t);var i=this.size.get(t);e.moveTo(.5*i,i),e.lineTo(.5*i,-2),e.lineTo(-.5*i,-2),e.lineTo(-.5*i,i),e.lineTo(.5*i,i)},t.prototype.render=function(e,t){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,t),this._normal(e,t),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,t),this._normal(e,t),e.stroke())},t.prototype._normal=function(e,t){var i=this.size.get(t);e.beginPath(),e.moveTo(.5*i,i),e.lineTo(0,0),e.lineTo(-.5*i,i),e.closePath()},t}(d);i.NormalHeadView=V,V.__name__="NormalHeadView";var w=function(e){function t(t){return e.call(this,t)||this}return(0,_.__extends)(t,e),t}(m);i.NormalHead=w,s=w,w.__name__="NormalHead",s.prototype.default_view=V,s.mixins([f.LineVector,f.FillVector]),s.override({fill_color:"black"});var H=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,_.__extends)(t,e),t.prototype.clip=function(e,t){this.visuals.line.set_vectorize(e,t);var i=this.size.get(t);e.moveTo(.5*i,i),e.lineTo(.5*i,-2),e.lineTo(-.5*i,-2),e.lineTo(-.5*i,i),e.lineTo(0,.5*i),e.lineTo(.5*i,i)},t.prototype.render=function(e,t){this.visuals.fill.doit&&(this.visuals.fill.set_vectorize(e,t),this._vee(e,t),e.fill()),this.visuals.line.doit&&(this.visuals.line.set_vectorize(e,t),this._vee(e,t),e.stroke())},t.prototype._vee=function(e,t){var i=this.size.get(t);e.beginPath(),e.moveTo(.5*i,i),e.lineTo(0,0),e.lineTo(-.5*i,i),e.lineTo(0,.5*i),e.closePath()},t}(d);i.VeeHeadView=H,H.__name__="VeeHeadView";var z=function(e){function t(t){return e.call(this,t)||this}return(0,_.__extends)(t,e),t}(m);i.VeeHead=z,a=z,z.__name__="VeeHead",a.prototype.default_view=H,a.mixins([f.LineVector,f.FillVector]),a.override({fill_color:"black"});var x=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,_.__extends)(t,e),t.prototype.render=function(e,t){if(this.visuals.line.doit){this.visuals.line.set_vectorize(e,t);var i=this.size.get(t);e.beginPath(),e.moveTo(.5*i,0),e.lineTo(-.5*i,0),e.stroke()}},t.prototype.clip=function(e,t){},t}(d);i.TeeHeadView=x,x.__name__="TeeHeadView";var g=function(e){function t(t){return e.call(this,t)||this}return(0,_.__extends)(t,e),t}(m);i.TeeHead=g,u=g,g.__name__="TeeHead",u.prototype.default_view=x,u.mixins(f.LineVector)},
function _(e,r,n,t,a){t();var i=e(1),l=e(126);function o(e,r,n){return(0,i.__awaiter)(this,void 0,void 0,(function(){var t;return(0,i.__generator)(this,(function(a){switch(a.label){case 0:return(t=new e((0,i.__assign)((0,i.__assign)({},n),{model:r}))).initialize(),[4,t.lazy_initialize()];case 1:return a.sent(),[2,t]}}))}))}n.build_view=function(e,r,n){return void 0===r&&(r={parent:null}),void 0===n&&(n=function(e){return e.default_view}),(0,i.__awaiter)(this,void 0,void 0,(function(){var t;return(0,i.__generator)(this,(function(a){switch(a.label){case 0:return[4,o(n(e),e,r)];case 1:return(t=a.sent()).connect_signals(),[2,t]}}))}))},n.build_views=function(e,r,n,t){return void 0===n&&(n={parent:null}),void 0===t&&(t=function(e){return e.default_view}),(0,i.__awaiter)(this,void 0,void 0,(function(){var a,u,s,c,_,f,v,d,h,y,w,b,g,x,p,m,z,k;return(0,i.__generator)(this,(function(A){switch(A.label){case 0:a=(0,l.difference)((0,i.__spreadArray)([],(0,i.__read)(e.keys()),!1),r);try{for(u=(0,i.__values)(a),s=u.next();!s.done;s=u.next())d=s.value,e.get(d).remove(),e.delete(d)}catch(e){g={error:e}}finally{try{s&&!s.done&&(x=u.return)&&x.call(u)}finally{if(g)throw g.error}}c=[],_=r.filter((function(r){return!e.has(r)})),A.label=1;case 1:A.trys.push([1,6,7,8]),f=(0,i.__values)(_),v=f.next(),A.label=2;case 2:return v.done?[3,5]:(d=v.value,[4,o(t(d),d,n)]);case 3:b=A.sent(),e.set(d,b),c.push(b),A.label=4;case 4:return v=f.next(),[3,2];case 5:return[3,8];case 6:return h=A.sent(),p={error:h},[3,8];case 7:try{v&&!v.done&&(m=f.return)&&m.call(f)}finally{if(p)throw p.error}return[7];case 8:try{for(y=(0,i.__values)(c),w=y.next();!w.done;w=y.next())(b=w.value).connect_signals()}catch(e){z={error:e}}finally{try{w&&!w.done&&(k=y.return)&&k.call(y)}finally{if(z)throw z.error}}return[2,c]}}))}))},n.remove_views=function(e){var r,n;try{for(var t=(0,i.__values)(e),a=t.next();!a.done;a=t.next()){var l=(0,i.__read)(a.value,2),o=l[0];l[1].remove(),e.delete(o)}}catch(e){r={error:e}}finally{try{a&&!a.done&&(n=t.return)&&n.call(t)}finally{if(r)throw r.error}}}},
function _(e,i,_,s,t){s();var l,r=e(1),n=e(230),o=(0,r.__importStar)(e(163)),p=function(e){function i(){return null!==e&&e.apply(this,arguments)||this}return(0,r.__extends)(i,e),i.prototype.paint=function(e){e.beginPath(),e.moveTo(this._lower_sx[0],this._lower_sy[0]);for(var i=0,_=this._lower_sx.length;i<_;i++)e.lineTo(this._lower_sx[i],this._lower_sy[i]);for(i=this._upper_sx.length-1;i>=0;i--)e.lineTo(this._upper_sx[i],this._upper_sy[i]);e.closePath(),this.visuals.fill.apply(e),e.beginPath(),e.moveTo(this._lower_sx[0],this._lower_sy[0]);for(i=0,_=this._lower_sx.length;i<_;i++)e.lineTo(this._lower_sx[i],this._lower_sy[i]);this.visuals.line.apply(e),e.beginPath(),e.moveTo(this._upper_sx[0],this._upper_sy[0]);for(i=0,_=this._upper_sx.length;i<_;i++)e.lineTo(this._upper_sx[i],this._upper_sy[i]);this.visuals.line.apply(e)},i}(n.UpperLowerView);_.BandView=p,p.__name__="BandView";var h=function(e){function i(i){return e.call(this,i)||this}return(0,r.__extends)(i,e),i}(n.UpperLower);_.Band=h,l=h,h.__name__="Band",l.prototype.default_view=p,l.mixins([o.Line,o.Fill]),l.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},
function _(e,t,i,r,n){r();var o,s=e(1),p=e(184),a=e(135),_=(0,s.__importStar)(e(133)),u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,s.__extends)(t,e),t.prototype.map_data=function(){var e,t,i,r=this.plot_view.frame,n=this.model.dimension,o=this.coordinates.x_scale,p=this.coordinates.y_scale,a="height"==n?p:o,_="height"==n?o:p,u="height"==n?r.bbox.yview:r.bbox.xview,h="height"==n?r.bbox.xview:r.bbox.yview;e="data"==this.model.properties.lower.units?a.v_compute(this._lower):u.v_compute(this._lower),t="data"==this.model.properties.upper.units?a.v_compute(this._upper):u.v_compute(this._upper),i="data"==this.model.properties.base.units?_.v_compute(this._base):h.v_compute(this._base);var l=(0,s.__read)("height"==n?[1,0]:[0,1],2),c=l[0],d=l[1],m=[e,i],b=[t,i];this._lower_sx=m[c],this._lower_sy=m[d],this._upper_sx=b[c],this._upper_sy=b[d]},t}(p.DataAnnotationView);i.UpperLowerView=u,u.__name__="UpperLowerView";var h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,s.__extends)(t,e),Object.defineProperty(t.prototype,"dimension",{get:function(){return"width"==this.obj.dimension?"x":"y"},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"units",{get:function(){var e;return null!==(e=this.spec.units)&&void 0!==e?e:"data"},enumerable:!1,configurable:!0}),t}(_.CoordinateSpec);i.XOrYCoordinateSpec=h,h.__name__="XOrYCoordinateSpec";var l=function(e){function t(t){return e.call(this,t)||this}return(0,s.__extends)(t,e),t}(p.DataAnnotation);i.UpperLower=l,o=l,l.__name__="UpperLower",o.define((function(){return{dimension:[a.Dimension,"height"],lower:[h,{field:"lower"}],upper:[h,{field:"upper"}],base:[h,{field:"base"}]}}))},
function _(t,o,n,i,e){i();var r,l=t(1),a=t(155),s=(0,l.__importStar)(t(163)),u=t(135),c=t(180);n.EDGE_TOLERANCE=2.5;var h=function(t){function o(){var o=t.apply(this,(0,l.__spreadArray)([],(0,l.__read)(arguments),!1))||this;return o.bbox=new c.BBox,o}return(0,l.__extends)(o,t),o.prototype.connect_signals=function(){var o=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return o.request_render()}))},o.prototype._render=function(){var t=this,o=this.model,n=o.left,i=o.right,e=o.top,r=o.bottom;if(null!=n||null!=i||null!=e||null!=r){var l=this.plot_view.frame,a=this.coordinates.x_scale,s=this.coordinates.y_scale,u=function(o,n,i,e,r){return null!=o?t.model.screen?o:"data"==n?i.compute(o):e.compute(o):r};this.bbox=c.BBox.from_rect({left:u(n,this.model.left_units,a,l.bbox.xview,l.bbox.left),right:u(i,this.model.right_units,a,l.bbox.xview,l.bbox.right),top:u(e,this.model.top_units,s,l.bbox.yview,l.bbox.top),bottom:u(r,this.model.bottom_units,s,l.bbox.yview,l.bbox.bottom)}),this._paint_box()}},o.prototype._paint_box=function(){var t=this.layer.ctx;t.save();var o=this.bbox,n=o.left,i=o.top,e=o.width,r=o.height;t.beginPath(),t.rect(n,i,e,r),this.visuals.fill.apply(t),this.visuals.hatch.apply(t),this.visuals.line.apply(t),t.restore()},o.prototype.interactive_bbox=function(){var t=this.model.line_width+n.EDGE_TOLERANCE;return this.bbox.grow_by(t)},o.prototype.interactive_hit=function(t,o){return null!=this.model.in_cursor&&this.interactive_bbox().contains(t,o)},o.prototype.cursor=function(t,o){var n=this.bbox,i=n.left,e=n.right,r=n.bottom,l=n.top;return Math.abs(t-i)<3||Math.abs(t-e)<3?this.model.ew_cursor:Math.abs(o-r)<3||Math.abs(o-l)<3?this.model.ns_cursor:this.bbox.contains(t,o)?this.model.in_cursor:null},o}(a.AnnotationView);n.BoxAnnotationView=h,h.__name__="BoxAnnotationView";var _=function(t){function o(o){return t.call(this,o)||this}return(0,l.__extends)(o,t),o.prototype.update=function(t){var o=t.left,n=t.right,i=t.top,e=t.bottom;this.setv({left:o,right:n,top:i,bottom:e,screen:!0})},o}(a.Annotation);n.BoxAnnotation=_,r=_,_.__name__="BoxAnnotation",r.prototype.default_view=h,r.mixins([s.Line,s.Fill,s.Hatch]),r.define((function(t){var o=t.Number,n=t.Nullable;return{top:[n(o),null],top_units:[u.SpatialUnits,"data"],bottom:[n(o),null],bottom_units:[u.SpatialUnits,"data"],left:[n(o),null],left_units:[u.SpatialUnits,"data"],right:[n(o),null],right_units:[u.SpatialUnits,"data"],render_mode:[u.RenderMode,"canvas"]}})),r.internal((function(t){var o=t.Boolean,n=t.String,i=t.Nullable;return{screen:[o,!1],ew_cursor:[i(n),null],ns_cursor:[i(n),null],in_cursor:[i(n),null]}})),r.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},
function _(t,e,i,r,n){r();var a,o=t(1),l=t(155),_=t(233),s=t(241),c=t(242),h=t(245),u=t(283),p=t(246),f=t(307),d=t(247),g=t(288),m=t(287),v=t(311),w=t(319),b=t(321),y=t(248),x=t(135),k=(0,o.__importStar)(t(163)),z=t(126),C=t(322),j=t(323),L=t(326),B=t(238),S=t(127),M=t(228),T=t(180),A=t(125),R=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(e,t),Object.defineProperty(e.prototype,"orientation",{get:function(){return this._orientation},enumerable:!1,configurable:!0}),e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this);var i=this.model,r=i.ticker,n=i.formatter,a=i.color_mapper;this._ticker="auto"!=r?r:function(){switch(!0){case a instanceof v.LogColorMapper:return new u.LogTicker;case a instanceof v.ScanningColorMapper:return new u.BinnedTicker({mapper:a});case a instanceof v.CategoricalColorMapper:return new u.CategoricalTicker;default:return new u.BasicTicker}}(),this._formatter="auto"!=n?n:function(){switch(!0){case e._ticker instanceof u.LogTicker:return new f.LogTickFormatter;case a instanceof v.CategoricalColorMapper:return new f.CategoricalTickFormatter;default:return new f.BasicTickFormatter}}(),this._major_range=function(){if(a instanceof v.CategoricalColorMapper){var t=a.factors;return new b.FactorRange({factors:t})}if(a instanceof m.ContinuousColorMapper){var e=a.metrics,i=e.min,r=e.max;return new b.Range1d({start:i,end:r})}(0,S.unreachable)()}(),this._major_scale=function(){if(a instanceof v.LinearColorMapper)return new w.LinearScale;if(a instanceof v.LogColorMapper)return new w.LogScale;if(a instanceof v.ScanningColorMapper){var t=a.metrics.binning;return new w.LinearInterpolationScale({binning:t})}if(a instanceof v.CategoricalColorMapper)return new w.CategoricalScale;(0,S.unreachable)()}(),this._minor_range=new b.Range1d({start:0,end:1}),this._minor_scale=new w.LinearScale;var l=k.attrs_of(this.model,"major_label_",k.Text,!0),s=k.attrs_of(this.model,"major_tick_",k.Line,!0),h=k.attrs_of(this.model,"minor_tick_",k.Line,!0),p=k.attrs_of(this.model,"title_",k.Text),d=a instanceof v.CategoricalColorMapper?c.CategoricalAxis:a instanceof v.LogColorMapper?c.LogAxis:c.LinearAxis;this._axis=new d((0,o.__assign)((0,o.__assign)((0,o.__assign)({ticker:this._ticker,formatter:this._formatter,major_tick_in:this.model.major_tick_in,major_tick_out:this.model.major_tick_out,minor_tick_in:this.model.minor_tick_in,minor_tick_out:this.model.minor_tick_out,major_label_standoff:this.model.label_standoff,major_label_overrides:this.model.major_label_overrides,major_label_policy:this.model.major_label_policy,axis_line_color:null},l),s),h));var g=this.model.title;g&&(this._title=new _.Title((0,o.__assign)({text:g,standoff:this.model.title_standoff},p)))},e.prototype.lazy_initialize=function(){return(0,o.__awaiter)(this,void 0,void 0,(function(){var e,i,r,n;return(0,o.__generator)(this,(function(a){switch(a.label){case 0:return[4,t.prototype.lazy_initialize.call(this)];case 1:return a.sent(),e=this,i={get parent(){return e.parent},get root(){return e.root},get frame(){return e._frame},get canvas_view(){return e.parent.canvas_view},request_layout:function(){e.parent.request_layout()}},r=this,[4,(0,M.build_view)(this._axis,{parent:i})];case 2:return r._axis_view=a.sent(),null==this._title?[3,4]:(n=this,[4,(0,M.build_view)(this._title,{parent:i})]);case 3:n._title_view=a.sent(),a.label=4;case 4:return[2]}}))}))},e.prototype.remove=function(){var e;null===(e=this._title_view)||void 0===e||e.remove(),this._axis_view.remove(),t.prototype.remove.call(this)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this._ticker.change,(function(){return e.request_render()})),this.connect(this._formatter.change,(function(){return e.request_render()})),this.connect(this.model.color_mapper.metrics_change,(function(){var t=e._major_range,i=e._major_scale,r=e.model.color_mapper;if(r instanceof m.ContinuousColorMapper&&t instanceof b.Range1d){var n=r.metrics,a=n.min,o=n.max;t.setv({start:a,end:o})}if(r instanceof v.ScanningColorMapper&&i instanceof w.LinearInterpolationScale){var l=r.metrics.binning;i.binning=l}e._set_canvas_image(),e.plot_view.request_layout()}))},e.prototype._set_canvas_image=function(){var t=this,e=this.orientation,i=function(){var i=t.model.color_mapper.palette;return"vertical"==e?(0,z.reversed)(i):i}(),r=(0,o.__read)("vertical"==e?[1,i.length]:[i.length,1],2),n=r[0],a=r[1],l=this._image=document.createElement("canvas");l.width=n,l.height=a;var _=l.getContext("2d"),s=_.getImageData(0,0,n,a),c=new v.LinearColorMapper({palette:i}).rgba_mapper.v_compute((0,z.range)(0,i.length));s.data.set(c),_.putImageData(s,0,0)},e.prototype.update_layout=function(){var t=this,e=this.model,i=e.location,r=e.width,n=e.height,a=e.padding,l=e.margin,_=(0,o.__read)(function(){if(!(0,A.isString)(i))return["end","start"];switch(i){case"top_left":return["start","start"];case"top":case"top_center":return["start","center"];case"top_right":return["start","end"];case"bottom_left":return["end","start"];case"bottom":case"bottom_center":return["end","center"];case"bottom_right":return["end","end"];case"left":case"center_left":return["center","start"];case"center":case"center_center":return["center","center"];case"right":case"center_right":return["center","end"]}}(),2),c=_[0],h=_[1],u=this._orientation=function(){var e=t.model.orientation;return"auto"==e?null!=t.panel?t.panel.is_horizontal?"horizontal":"vertical":"start"==h||"end"==h||"center"==h&&"center"==c?"vertical":"horizontal":e}(),p=new j.NodeLayout,f=new j.VStack,d=new j.VStack,g=new j.HStack,m=new j.HStack;p.absolute=!0,f.absolute=!0,d.absolute=!0,g.absolute=!0,m.absolute=!0;var v=(0,o.__read)("horizontal"==u?[t._major_scale,t._minor_scale,t._major_range,t._minor_range]:[t._minor_scale,t._major_scale,t._minor_range,t._major_range],4),w=v[0],b=v[1],y=v[2],x=v[3];this._frame=new s.CartesianFrame(w,b,y,x),p.on_resize((function(e){return t._frame.set_geometry(e)}));var k=new L.BorderLayout;this._inner_layout=k,k.absolute=!0,k.center_panel=p,k.top_panel=f,k.bottom_panel=d,k.left_panel=g,k.right_panel=m;var z,S,M,R,F={left:a,right:a,top:a,bottom:a},I=function(){if(null==t.panel){if((0,A.isString)(i))return{left:l,right:l,top:l,bottom:l};var e=(0,o.__read)(i,2),r=e[0],n=e[1];return{left:r,right:l,top:l,bottom:n}}if(!(0,A.isString)(i)){var a=(0,o.__read)(i,2),_=a[0],s=a[1];return k.fixup_geometry=function(e,i){var r=e,n=t.layout.bbox,a=e.width,o=e.height;if(e=new T.BBox({left:n.left+_,bottom:n.bottom-s,width:a,height:o}),null!=i){var l=e.left-r.left,c=e.top-r.top,h=i.left,u=i.top,p=i.width,f=i.height;i=new T.BBox({left:h+l,top:u+c,width:p,height:f})}return[e,i]},{left:_,right:0,top:0,bottom:s}}k.fixup_geometry=function(e,i){var r=e;if("horizontal"==u){var n=e.top,a=e.width,o=e.height;if("end"==h){var l=t.layout.bbox.right;e=new T.BBox({right:l,top:n,width:a,height:o})}else if("center"==h){var _=t.layout.bbox.hcenter;e=new T.BBox({hcenter:Math.round(_),top:n,width:a,height:o})}}else{var s=e.left;a=e.width,o=e.height;if("end"==c){var p=t.layout.bbox.bottom;e=new T.BBox({left:s,bottom:p,width:a,height:o})}else if("center"==c){var f=t.layout.bbox.vcenter;e=new T.BBox({left:s,vcenter:Math.round(f),width:a,height:o})}}if(null!=i){var d=e.left-r.left,g=e.top-r.top;s=i.left,n=i.top,a=i.width,o=i.height;i=new T.BBox({left:s+d,top:n+g,width:a,height:o})}return[e,i]}}();if(k.padding=F,null!=this.panel?(z="max",S=void 0,M=void 0,R=void 0):"auto"==("horizontal"==u?r:n)?(z="fixed",S=25*this.model.color_mapper.palette.length,M={percent:.3},R={percent:.8}):(z="fit",S=void 0),"horizontal"==u){var q="auto"==r?void 0:r,P="auto"==n?25:n;k.set_sizing({width_policy:z,height_policy:"min",width:S,min_width:M,max_width:R,halign:h,valign:c,margin:I}),k.center_panel.set_sizing({width_policy:"auto"==r?"fit":"fixed",height_policy:"fixed",width:q,height:P})}else{q="auto"==r?25:r,P="auto"==n?void 0:n;k.set_sizing({width_policy:"min",height_policy:z,height:S,min_height:M,max_height:R,halign:h,valign:c,margin:I}),k.center_panel.set_sizing({width_policy:"fixed",height_policy:"auto"==n?"fit":"fixed",width:q,height:P})}f.set_sizing({width_policy:"fit",height_policy:"min"}),d.set_sizing({width_policy:"fit",height_policy:"min"}),g.set_sizing({width_policy:"min",height_policy:"fit"}),m.set_sizing({width_policy:"min",height_policy:"fit"});var V=this._title_view;null!=V&&("horizontal"==u?(V.panel=new B.Panel("above"),V.update_layout(),f.children.push(V.layout)):(V.panel=new B.Panel("left"),V.update_layout(),g.children.push(V.layout)));var N=this.panel,O=null!=N&&u==N.orientation?N.side:"horizontal"==u?"below":"right",D=function(){switch(O){case"above":return f;case"below":return d;case"left":return g;case"right":return m}}(),E=this._axis_view;if(E.panel=new B.Panel(O),E.update_layout(),D.children.push(E.layout),null!=this.panel){var H=new C.Grid([{layout:k,row:0,col:0}]);H.absolute=!0,"horizontal"==u?H.set_sizing({width_policy:"max",height_policy:"min"}):H.set_sizing({width_policy:"min",height_policy:"max"}),this.layout=H}else this.layout=this._inner_layout;var G=this.model.visible;this.layout.sizing.visible=G,this._set_canvas_image()},e.prototype._render=function(){var t,e=this.layer.ctx;e.save(),this._paint_bbox(e,this._inner_layout.bbox),this._paint_image(e,this._inner_layout.center_panel.bbox),null===(t=this._title_view)||void 0===t||t.render(),this._axis_view.render(),e.restore()},e.prototype._paint_bbox=function(t,e){var i=e.x,r=e.y,n=e.width,a=e.height;i+n>=this.parent.canvas_view.bbox.width&&(n-=1),r+a>=this.parent.canvas_view.bbox.height&&(a-=1),t.save(),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),t.fillRect(i,r,n,a)),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),t.strokeRect(i,r,n,a)),t.restore()},e.prototype._paint_image=function(t,e){var i=e.x,r=e.y,n=e.width,a=e.height;t.save(),t.setImageSmoothingEnabled(!1),t.globalAlpha=this.model.scale_alpha,t.drawImage(this._image,i,r,n,a),this.visuals.bar_line.doit&&(this.visuals.bar_line.set_value(t),t.strokeRect(i,r,n,a)),t.restore()},e.prototype.serializable_state=function(){var e=t.prototype.serializable_state.call(this),i=e.children,r=void 0===i?[]:i,n=(0,o.__rest)(e,["children"]);return null!=this._title_view&&r.push(this._title_view.serializable_state()),r.push(this._axis_view.serializable_state()),(0,o.__assign)((0,o.__assign)({},n),{children:r})},e}(l.AnnotationView);i.ColorBarView=R,R.__name__="ColorBarView";var F=function(t){function e(e){return t.call(this,e)||this}return(0,o.__extends)(e,t),e}(l.Annotation);i.ColorBar=F,a=F,F.__name__="ColorBar",a.prototype.default_view=R,a.mixins([["major_label_",k.Text],["title_",k.Text],["major_tick_",k.Line],["minor_tick_",k.Line],["border_",k.Line],["bar_",k.Line],["background_",k.Fill]]),a.define((function(t){var e=t.Alpha,i=t.Number,r=t.String,n=t.Tuple,a=t.Dict,o=t.Or,l=t.Ref,_=t.Auto,s=t.Nullable;return{location:[o(x.Anchor,n(i,i)),"top_right"],orientation:[o(x.Orientation,_),"auto"],title:[s(r),null],title_standoff:[i,2],width:[o(i,_),"auto"],height:[o(i,_),"auto"],scale_alpha:[e,1],ticker:[o(l(h.Ticker),_),"auto"],formatter:[o(l(p.TickFormatter),_),"auto"],major_label_overrides:[a(o(r,l(y.BaseText))),{}],major_label_policy:[l(d.LabelingPolicy),function(){return new d.NoOverlap}],color_mapper:[l(g.ColorMapper)],label_standoff:[i,5],margin:[i,30],padding:[i,10],major_tick_in:[i,5],major_tick_out:[i,0],minor_tick_in:[i,0],minor_tick_out:[i,0]}})),a.override({background_fill_color:"#ffffff",background_fill_alpha:.95,bar_line_color:null,border_line_color:null,major_label_text_font_size:"11px",major_tick_line_color:"#ffffff",minor_tick_line_color:null,title_text_font_size:"13px",title_text_font_style:"italic"})},
function _(t,e,i,a,n){a();var o,l=t(1),r=t(234),s=t(135),c=t(235),h=(0,l.__importStar)(t(163)),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,l.__extends)(e,t),e.prototype._get_location=function(){var t,e,i=this.model.offset,a=this.model.standoff/2,n=this.layout.bbox;switch(this.panel.side){case"above":case"below":switch(this.model.vertical_align){case"top":e=n.top+a;break;case"middle":e=n.vcenter;break;case"bottom":e=n.bottom-a}switch(this.model.align){case"left":t=n.left+i;break;case"center":t=n.hcenter;break;case"right":t=n.right-i}break;case"left":switch(this.model.vertical_align){case"top":t=n.left+a;break;case"middle":t=n.hcenter;break;case"bottom":t=n.right-a}switch(this.model.align){case"left":e=n.bottom-i;break;case"center":e=n.vcenter;break;case"right":e=n.top+i}break;case"right":switch(this.model.vertical_align){case"top":t=n.right-a;break;case"middle":t=n.hcenter;break;case"bottom":t=n.left+a}switch(this.model.align){case"left":e=n.top+i;break;case"center":e=n.vcenter;break;case"right":e=n.bottom-i}}return[t,e]},e.prototype._render=function(){var t=this.model.text;if(null!=t&&0!=t.length){this.model.text_baseline=this.model.vertical_align,this.model.text_align=this.model.align;var e=(0,l.__read)(this._get_location(),2),i=e[0],a=e[1],n=this.panel.get_label_angle_heuristic("parallel");("canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this))(this.layer.ctx,t,i,a,n)}},e.prototype._get_size=function(){var t=this.model.text,e=new c.TextBox({text:t});e.visuals=this.visuals.text.values();var i=e.size(),a=i.width,n=i.height;return{width:a,height:0==n?0:2+n+this.model.standoff}},e}(r.TextAnnotationView);i.TitleView=_,_.__name__="TitleView";var d=function(t){function e(e){return t.call(this,e)||this}return(0,l.__extends)(e,t),e}(r.TextAnnotation);i.Title=d,o=d,d.__name__="Title",o.prototype.default_view=_,o.mixins([h.Text,["border_",h.Line],["background_",h.Fill]]),o.define((function(t){var e=t.Number;return{text:[t.String,""],vertical_align:[s.VerticalAlign,"bottom"],align:[s.TextAlign,"left"],offset:[e,0],standoff:[e,10]}})),o.prototype._props.text_align.options.internal=!0,o.prototype._props.text_baseline.options.internal=!0,o.override({text_font_size:"13px",text_font_style:"bold",text_line_height:1,background_fill_color:null,border_line_color:null})},
function _(t,e,n,i,s){i();var o,l=t(1),r=t(155),a=t(158),u=t(135),c=t(235),d=t(238),h=t(127),p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,l.__extends)(e,t),e.prototype.update_layout=function(){var t=this,e=this.panel;this.layout=null!=e?new d.SideLayout(e,(function(){return t.get_size()}),!0):void 0},e.prototype.initialize=function(){t.prototype.initialize.call(this),"css"==this.model.render_mode&&(this.el=(0,a.div)(),this.plot_view.canvas_view.add_overlay(this.el))},e.prototype.remove=function(){null!=this.el&&(0,a.remove)(this.el),t.prototype.remove.call(this)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),"css"==this.model.render_mode?this.connect(this.model.change,(function(){return e.render()})):this.connect(this.model.change,(function(){return e.request_render()}))},e.prototype.render=function(){this.model.visible||"css"!=this.model.render_mode||(0,a.undisplay)(this.el),t.prototype.render.call(this)},e.prototype._canvas_text=function(t,e,n,i,s){var o=new c.TextBox({text:e});o.angle=s,o.position={sx:n,sy:i},o.visuals=this.visuals.text.values();var l=this.visuals,r=l.background_fill,a=l.border_line;if(r.doit||a.doit){var u=o.rect(),d=u.p0,h=u.p1,p=u.p2,_=u.p3;t.beginPath(),t.moveTo(d.x,d.y),t.lineTo(h.x,h.y),t.lineTo(p.x,p.y),t.lineTo(_.x,_.y),t.closePath(),this.visuals.background_fill.apply(t),this.visuals.border_line.apply(t)}this.visuals.text.doit&&o.paint(t)},e.prototype._css_text=function(t,e,n,i,s){var o=this,r=this.el;(0,h.assert)(null!=r),(0,a.undisplay)(r),r.textContent=e,this.visuals.text.set_value(t),r.style.position="absolute",r.style.left=n+"px",r.style.top=i+"px",r.style.color=t.fillStyle,r.style.font=t.font,r.style.lineHeight="normal",r.style.whiteSpace="pre";var u=(0,l.__read)(function(){switch(o.visuals.text.text_align.get_value()){case"left":return["left","0%"];case"center":return["center","-50%"];case"right":return["right","-100%"]}}(),2),c=u[0],d=u[1],p=(0,l.__read)(function(){switch(o.visuals.text.text_baseline.get_value()){case"top":return["top","0%"];case"middle":return["center","-50%"];case"bottom":return["bottom","-100%"];default:return["center","-50%"]}}(),2),_=p[0],y="translate("+d+", "+p[1]+")";s&&(y+="rotate("+s+"rad)"),r.style.transformOrigin=c+" "+_,r.style.transform=y,this.layout,this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(t),r.style.backgroundColor=t.fillStyle),this.visuals.border_line.doit&&(this.visuals.border_line.set_value(t),r.style.borderStyle=t.lineDash.length<2?"solid":"dashed",r.style.borderWidth=t.lineWidth+"px",r.style.borderColor=t.strokeStyle),(0,a.display)(r)},e}(r.AnnotationView);n.TextAnnotationView=p,p.__name__="TextAnnotationView";var _=function(t){function e(e){return t.call(this,e)||this}return(0,l.__extends)(e,t),e}(r.Annotation);n.TextAnnotation=_,o=_,_.__name__="TextAnnotation",o.define((function(){return{render_mode:[u.RenderMode,"canvas"]}}))},
function _(t,e,i,n,r){n();var s,o,a=t(1),h=t(180),c=t(236),u=t(126),l=t(125),_=t(237),f=t(137);i.text_width=(s=document.createElement("canvas").getContext("2d"),o="",function(t,e){return e!=o&&(o=e,s.font=e),s.measureText(t).width});var p=function(){function t(){this._position={sx:0,sy:0},this.font_size_scale=1,this.align="left",this._base_font_size=13,this._x_anchor="left",this._y_anchor="center"}return Object.defineProperty(t.prototype,"base_font_size",{get:function(){return this._base_font_size},set:function(t){null!=t&&(this._base_font_size=t)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"position",{get:function(){return this._position},set:function(t){this._position=t},enumerable:!1,configurable:!0}),t.prototype.infer_text_height=function(){return"ascent_descent"},t.prototype.bbox=function(){var t=this.rect(),e=t.p0,i=t.p1,n=t.p2,r=t.p3,s=Math.min(e.x,i.x,n.x,r.x),o=Math.min(e.y,i.y,n.y,r.y),a=Math.max(e.x,i.x,n.x,r.x),c=Math.max(e.y,i.y,n.y,r.y);return new h.BBox({left:s,right:a,top:o,bottom:c})},t.prototype.size=function(){var t=this._size(),e=t.width,i=t.height,n=this.angle;if(n){var r=Math.cos(Math.abs(n)),s=Math.sin(Math.abs(n));return{width:Math.abs(e*r+i*s),height:Math.abs(e*s+i*r)}}return{width:e,height:i}},t.prototype.rect=function(){var t=this._rect(),e=this.angle;if(e){var i=this.position,n=i.sx,r=i.sy,s=new _.AffineTransform;return s.translate(n,r),s.rotate(e),s.translate(-n,-r),s.apply_rect(t)}return t},t.prototype.paint_rect=function(t){var e=this.rect(),i=e.p0,n=e.p1,r=e.p2,s=e.p3;t.save(),t.strokeStyle="red",t.lineWidth=1,t.beginPath();var o=Math.round;t.moveTo(o(i.x),o(i.y)),t.lineTo(o(n.x),o(n.y)),t.lineTo(o(r.x),o(r.y)),t.lineTo(o(s.x),o(s.y)),t.closePath(),t.stroke(),t.restore()},t.prototype.paint_bbox=function(t){var e=this.bbox(),i=e.x,n=e.y,r=e.width,s=e.height;t.save(),t.strokeStyle="blue",t.lineWidth=1,t.beginPath();var o=Math.round;t.moveTo(o(i),o(n)),t.lineTo(o(i),o(n+s)),t.lineTo(o(i+r),o(n+s)),t.lineTo(o(i+r),o(n)),t.closePath(),t.stroke(),t.restore()},t}();i.GraphicsBox=p,p.__name__="GraphicsBox";var x=function(t){function e(e){var i=e.text,n=t.call(this)||this;return n.text=i,n}return(0,a.__extends)(e,t),Object.defineProperty(e.prototype,"visuals",{set:function(t){var e=t.color,i=t.alpha,n=t.font_style,r=t.font_size,s=t.font,o=this.font_size_scale,a=this.base_font_size,h=(0,c.parse_css_font_size)(r);if(null!=h){var u=h.value,l=h.unit;u*=o,"em"==l&&a&&(u*=a,l="px"),r=""+u+l}var _=n+" "+r+" "+s;this.font=_,this.color=(0,f.color2css)(e,i),this.line_height=t.line_height;var p=t.align;this._x_anchor=p;var x=t.baseline;this._y_anchor=function(){switch(x){case"top":return"top";case"middle":return"center";case"bottom":return"bottom";default:return"baseline"}}()},enumerable:!1,configurable:!0}),e.prototype.infer_text_height=function(){if(this.text.includes("\n"))return"ascent_descent";return function(t){var e,i;try{for(var n=(0,a.__values)(new Set(t)),r=n.next();!r.done;r=n.next()){var s=r.value;if(!("0"<=s&&s<="9"))switch(s){case",":case".":case"+":case"-":case"\u2212":case"e":continue;default:return!1}}}catch(t){e={error:t}}finally{try{r&&!r.done&&(i=n.return)&&i.call(n)}finally{if(e)throw e.error}}return!0}(this.text)?"cap":"ascent_descent"},e.prototype._text_line=function(t){var e,i=null!==(e=this.text_height_metric)&&void 0!==e?e:this.infer_text_height(),n=function(){switch(i){case"x":case"x_descent":return t.x_height;case"cap":case"cap_descent":return t.cap_height;case"ascent":case"ascent_descent":return t.ascent}}(),r=function(){switch(i){case"x":case"cap":case"ascent":return 0;case"x_descent":case"cap_descent":case"ascent_descent":return t.descent}}();return{height:n+r,ascent:n,descent:r}},Object.defineProperty(e.prototype,"nlines",{get:function(){return this.text.split("\n").length},enumerable:!1,configurable:!0}),e.prototype._size=function(){var t,e,n=this.font,r=(0,c.font_metrics)(n),s=(this.line_height-1)*r.height,o=""==this.text,a=this.text.split("\n"),h=a.length,l=a.map((function(t){return(0,i.text_width)(t,n)})),_=this._text_line(r).height*h,f="%"==(null===(t=this.width)||void 0===t?void 0:t.unit)?this.width.value:1,p="%"==(null===(e=this.height)||void 0===e?void 0:e.unit)?this.height.value:1;return{width:(0,u.max)(l)*f,height:o?0:(_+s*(h-1))*p,metrics:r}},e.prototype._computed_position=function(t,e,i){var n=this,r=t.width,s=t.height,o=this.position,a=o.sx,h=o.sy,c=o.x_anchor,u=void 0===c?this._x_anchor:c,_=o.y_anchor,f=void 0===_?this._y_anchor:_,p=a-function(){if((0,l.isNumber)(u))return u*r;switch(u){case"left":return 0;case"center":return.5*r;case"right":return r}}(),x=h-function(){var t;if((0,l.isNumber)(f))return f*s;switch(f){case"top":return 0;case"center":return.5*s;case"bottom":return s;case"baseline":if(1!=i)return.5*s;switch(null!==(t=n.text_height_metric)&&void 0!==t?t:n.infer_text_height()){case"x":case"x_descent":return e.x_height;case"cap":case"cap_descent":return e.cap_height;case"ascent":case"ascent_descent":return e.ascent}}}();return{x:p,y:x}},e.prototype._rect=function(){var t=this._size(),e=t.width,i=t.height,n=t.metrics,r=this.text.split("\n").length,s=this._computed_position({width:e,height:i},n,r),o=s.x,a=s.y;return new h.BBox({x:o,y:a,width:e,height:i}).rect},e.prototype.paint=function(t){var e,n,r=this.font,s=(0,c.font_metrics)(r),o=(this.line_height-1)*s.height,a=this.text.split("\n"),h=a.length,l=a.map((function(t){return(0,i.text_width)(t,r)})),_=this._text_line(s),f=_.height*h,p="%"==(null===(e=this.width)||void 0===e?void 0:e.unit)?this.width.value:1,x="%"==(null===(n=this.height)||void 0===n?void 0:n.unit)?this.height.value:1,y=(0,u.max)(l)*p,d=(f+o*(h-1))*x;t.save(),t.fillStyle=this.color,t.font=this.font,t.textAlign="left",t.textBaseline="alphabetic";var v=this.position,b=v.sx,g=v.sy,m=this.align,w=this.angle;w&&(t.translate(b,g),t.rotate(w),t.translate(-b,-g));var z=this._computed_position({width:y,height:d},s,h),M=z.x,P=z.y;if("justify"==m)for(var T=0;T<h;T++){for(var j=M,B=a[T].split(" "),O=B.length,S=B.map((function(t){return(0,i.text_width)(t,r)})),k=(y-(0,u.sum)(S))/(O-1),G=0;G<O;G++)t.fillText(B[G],j,P),j+=S[G]+k;P+=_.height+o}else{var N=function(e){var i=M+function(){switch(m){case"left":return 0;case"center":return.5*(y-l[e]);case"right":return y-l[e]}}();t.fillStyle=E.color,t.fillText(a[e],i,P+_.ascent),P+=_.height+o},E=this;for(T=0;T<h;T++)N(T)}t.restore()},e}(p);i.TextBox=x,x.__name__="TextBox";var y=function(t){function e(e,i){var n=t.call(this)||this;return n.base=e,n.expo=i,n}return(0,a.__extends)(e,t),Object.defineProperty(e.prototype,"children",{get:function(){return[this.base,this.expo]},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"base_font_size",{set:function(e){t.prototype.base_font_size=e,this.base.base_font_size=e,this.expo.base_font_size=e},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"position",{get:function(){return this._position},set:function(t){this._position=t;var e=this.base.size(),i=this.expo.size(),n=this._shift_scale()*e.height,r=Math.max(e.height,n+i.height);this.base.position={sx:0,x_anchor:"left",sy:r,y_anchor:"bottom"},this.expo.position={sx:e.width,x_anchor:"left",sy:n,y_anchor:"bottom"}},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"visuals",{set:function(t){this.expo.font_size_scale=.7,this.base.visuals=t,this.expo.visuals=t},enumerable:!1,configurable:!0}),e.prototype._shift_scale=function(){if(this.base instanceof x&&1==this.base.nlines){var t=(0,c.font_metrics)(this.base.font);return t.x_height/t.cap_height}return 2/3},e.prototype.infer_text_height=function(){return this.base.infer_text_height()},e.prototype._rect=function(){var t=this.base.bbox(),e=this.expo.bbox(),i=t.union(e),n=this._computed_position(),r=n.x,s=n.y;return i.translate(r,s).rect},e.prototype._size=function(){var t=this.base.size(),e=this.expo.size();return{width:t.width+e.width,height:Math.max(t.height,this._shift_scale()*t.height+e.height)}},e.prototype.paint=function(t){t.save();var e=this.angle;if(e){var i=this.position,n=i.sx,r=i.sy;t.translate(n,r),t.rotate(e),t.translate(-n,-r)}var s=this._computed_position(),o=s.x,a=s.y;t.translate(o,a),this.base.paint(t),this.expo.paint(t),t.restore()},e.prototype.paint_bbox=function(e){var i,n;t.prototype.paint_bbox.call(this,e);var r=this._computed_position(),s=r.x,o=r.y;e.save(),e.translate(s,o);try{for(var h=(0,a.__values)(this.children),c=h.next();!c.done;c=h.next()){c.value.paint_bbox(e)}}catch(t){i={error:t}}finally{try{c&&!c.done&&(n=h.return)&&n.call(h)}finally{if(i)throw i.error}}e.restore()},e.prototype._computed_position=function(){var t=this._size(),e=t.width,i=t.height,n=this.position,r=n.sx,s=n.sy,o=n.x_anchor,a=void 0===o?this._x_anchor:o,h=n.y_anchor,c=void 0===h?this._y_anchor:h;return{x:r-function(){if((0,l.isNumber)(a))return a*e;switch(a){case"left":return 0;case"center":return.5*e;case"right":return e}}(),y:s-function(){if((0,l.isNumber)(c))return c*i;switch(c){case"top":return 0;case"center":return.5*i;case"bottom":return i;case"baseline":return.5*i}}()}},e}(p);i.BaseExpo=y,y.__name__="BaseExpo";var d=function(){function t(t){this.items=t}return Object.defineProperty(t.prototype,"base_font_size",{set:function(t){var e,i;try{for(var n=(0,a.__values)(this.items),r=n.next();!r.done;r=n.next()){r.value.base_font_size=t}}catch(t){e={error:t}}finally{try{r&&!r.done&&(i=n.return)&&i.call(n)}finally{if(e)throw e.error}}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"length",{get:function(){return this.items.length},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"visuals",{set:function(t){var e,i,n,r;try{for(var s=(0,a.__values)(this.items),o=s.next();!o.done;o=s.next()){o.value.visuals=t}}catch(t){e={error:t}}finally{try{o&&!o.done&&(i=s.return)&&i.call(s)}finally{if(e)throw e.error}}var h={x:0,cap:1,ascent:2,x_descent:3,cap_descent:4,ascent_descent:5},c=(0,u.max_by)(this.items.map((function(t){return t.infer_text_height()})),(function(t){return h[t]}));try{for(var l=(0,a.__values)(this.items),_=l.next();!_.done;_=l.next()){_.value.text_height_metric=c}}catch(t){n={error:t}}finally{try{_&&!_.done&&(r=l.return)&&r.call(l)}finally{if(n)throw n.error}}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"angle",{set:function(t){var e,i;try{for(var n=(0,a.__values)(this.items),r=n.next();!r.done;r=n.next()){r.value.angle=t}}catch(t){e={error:t}}finally{try{r&&!r.done&&(i=n.return)&&i.call(n)}finally{if(e)throw e.error}}},enumerable:!1,configurable:!0}),t.prototype.max_size=function(){var t,e,i=0,n=0;try{for(var r=(0,a.__values)(this.items),s=r.next();!s.done;s=r.next()){var o=s.value.size();i=Math.max(i,o.width),n=Math.max(n,o.height)}}catch(e){t={error:e}}finally{try{s&&!s.done&&(e=r.return)&&e.call(r)}finally{if(t)throw t.error}}return{width:i,height:n}},t}();i.GraphicsBoxes=d,d.__name__="GraphicsBoxes"},
function _(t,e,n,r,a){r();var u,l=t(1),i=t(127),c=function(){try{return"undefined"!=typeof OffscreenCanvas&&null!=new OffscreenCanvas(0,0).getContext("2d")}catch(t){return!1}}()?function(t,e){return new OffscreenCanvas(t,e)}:function(t,e){var n=document.createElement("canvas");return n.width=t,n.height=e,n},o=(u=c(0,0).getContext("2d"),function(t){u.font=t;var e=u.measureText("M"),n=u.measureText("x"),r=u.measureText("\xc5\u015ag|"),a=r.fontBoundingBoxAscent,l=r.fontBoundingBoxDescent;if(null!=a&&null!=l)return{height:a+l,ascent:a,descent:l,cap_height:e.actualBoundingBoxAscent,x_height:n.actualBoundingBoxAscent};var c=r.actualBoundingBoxAscent,o=r.actualBoundingBoxDescent;if(null!=c&&null!=o)return{height:c+o,ascent:c,descent:o,cap_height:e.actualBoundingBoxAscent,x_height:n.actualBoundingBoxAscent};(0,i.unreachable)()}),f=function(){var t=c(0,0).getContext("2d");return function(e,n){t.font=n;var r=t.measureText(e),a=r.actualBoundingBoxAscent,u=r.actualBoundingBoxDescent;if(null!=a&&null!=u)return{width:r.width,height:a+u,ascent:a,descent:u};(0,i.unreachable)()}}(),s=function(){var t=document.createElement("canvas"),e=t.getContext("2d"),n=-1,r=-1;return function(a,u){var i,c,o,f,s,h;void 0===u&&(u=1),e.font=a;var v=e.measureText("M").width*u,d=Math.ceil(v),g=Math.ceil(2*v),x=Math.ceil(1.5*v);n<d&&(n=d,t.width=d),r<g&&(r=g,t.height=g),e.save(),e.scale(u,u),e.fillStyle="#f00",e.fillRect(0,0,d,g);var y=function(t){for(var e=0,n=0;n<=x;n++)for(var r=0;r<d;r++,e+=4)if(255!=t[e])return x-n;return 0};e.font=a,e.fillStyle="#000";try{for(var m=(0,l.__values)("xa"),B=m.next();!B.done;B=m.next()){var _=B.value;e.fillText(_,0,x/u)}}catch(t){i={error:t}}finally{try{B&&!B.done&&(c=m.return)&&c.call(m)}finally{if(i)throw i.error}}var w=y(e.getImageData(0,0,d,g).data)/u;try{for(var p=(0,l.__values)("ASQ"),M=p.next();!M.done;M=p.next()){_=M.value;e.fillText(_,0,x/u)}}catch(t){o={error:t}}finally{try{M&&!M.done&&(f=p.return)&&f.call(p)}finally{if(o)throw o.error}}var T=y(e.getImageData(0,0,d,g).data)/u;try{for(var A=(0,l.__values)("\xc5\u015agy"),C=A.next();!C.done;C=A.next()){_=C.value;e.fillText(_,0,x/u)}}catch(t){s={error:t}}finally{try{C&&!C.done&&(h=A.return)&&h.call(A)}finally{if(s)throw s.error}}var D=e.getImageData(0,0,d,g).data,S=y(D)/u,I=function(t){for(var e=t.length-4,n=g;n>=x;n--)for(var r=0;r<d;r++,e-=4)if(255!=t[e])return n-x;return 0}(D)/u;return e.restore(),{height:S+I,ascent:S,cap_height:T,x_height:w,descent:I}}}(),h=function(){var t=document.createElement("canvas"),e=t.getContext("2d"),n=-1,r=-1;return function(a,u,l){void 0===l&&(l=1),e.font=u;var i=e.measureText("M").width*l,c=Math.ceil(i),o=Math.ceil(2*i),f=Math.ceil(1.5*i);(n<c||r<o)&&(n=c,t.width=c,r=o,t.height=o),e.save(),e.scale(l,l),e.fillStyle="#f00",e.fillRect(0,0,c,o);e.font=u,e.fillStyle="#000",e.fillText(a,0,f/l);var s=e.measureText(a),h=e.getImageData(0,0,c,o).data,v=function(t){for(var e=0,n=0;n<=f;n++)for(var r=0;r<c;r++,e+=4)if(255!=t[e])return f-n;return 0}(h)/l,d=function(t){for(var e=t.length-4,n=o;n>=f;n--)for(var r=0;r<c;r++,e-=4)if(255!=t[e])return n-f;return 0}(h)/l;return e.restore(),{width:s.width,height:v+d,ascent:v,descent:d}}}(),v=function(){try{return o("normal 10px sans-serif"),o}catch(t){return s}}(),d=function(){try{return f("A","normal 10px sans-serif"),f}catch(t){return h}}(),g=new Map;function x(t){var e=g.get(t);return null==e&&(e={font:v(t),glyphs:new Map},g.set(t,e)),e.font}n.font_metrics=x,n.glyph_metrics=function(t,e){var n=g.get(e);null==n&&(x(e),n=g.get(e));var r=n.glyphs.get(t);return null==r&&(r=d(t,e),n.glyphs.set(t,r)),r},n.parse_css_font_size=function(t){var e=t.match(/^\s*(\d+(\.\d+)?)(\w+)\s*$/);if(null!=e){var n=(0,l.__read)(e,4),r=n[1],a=n[3],u=Number(r);if(isFinite(u))return{value:u,unit:a}}return null}},
function _(t,r,n,o,i){o();var e=t(1),p=Math.sin,a=Math.cos,s=function(){function t(t,r,n,o,i,e){void 0===t&&(t=1),void 0===r&&(r=0),void 0===n&&(n=0),void 0===o&&(o=1),void 0===i&&(i=0),void 0===e&&(e=0),this.a=t,this.b=r,this.c=n,this.d=o,this.e=i,this.f=e}return t.prototype.toString=function(){var t=this;return"matrix("+t.a+", "+t.b+", "+t.c+", "+t.d+", "+t.e+", "+t.f+")"},t.from_DOMMatrix=function(r){return new t(r.a,r.b,r.c,r.d,r.e,r.f)},t.prototype.to_DOMMatrix=function(){var t=this,r=t.a,n=t.b,o=t.c,i=t.d,e=t.e,p=t.f;return new DOMMatrix([r,n,o,i,e,p])},t.prototype.clone=function(){var r=this;return new t(r.a,r.b,r.c,r.d,r.e,r.f)},Object.defineProperty(t.prototype,"is_identity",{get:function(){var t=this,r=t.a,n=t.b,o=t.c,i=t.d,e=t.e,p=t.f;return 1==r&&0==n&&0==o&&1==i&&0==e&&0==p},enumerable:!1,configurable:!0}),t.prototype.apply_point=function(t){var r=(0,e.__read)(this.apply(t.x,t.y),2);return{x:r[0],y:r[1]}},t.prototype.apply_rect=function(t){return{p0:this.apply_point(t.p0),p1:this.apply_point(t.p1),p2:this.apply_point(t.p2),p3:this.apply_point(t.p3)}},t.prototype.apply=function(t,r){var n=this,o=n.a,i=n.b,e=n.c,p=n.d;return[o*t+e*r+n.e,i*t+p*r+n.f]},t.prototype.iv_apply=function(t,r){for(var n=this,o=n.a,i=n.b,e=n.c,p=n.d,a=n.e,s=n.f,f=t.length,u=0;u<f;u++){var c=t[u],h=r[u];t[u]=o*c+e*h+a,r[u]=i*c+p*h+s}},t.prototype.transform=function(t,r,n,o,i,e){var p=this,a=p.a,s=p.b,f=p.c,u=p.d,c=p.e,h=p.f;return this.a=a*t+f*r,this.c=a*n+f*o,this.e=a*i+f*e+c,this.b=s*t+u*r,this.d=s*n+u*o,this.f=s*i+u*e+h,this},t.prototype.translate=function(t,r){return this.transform(1,0,0,1,t,r)},t.prototype.scale=function(t,r){return this.transform(t,0,0,r,0,0)},t.prototype.skew=function(t,r){return this.transform(1,r,t,1,0,0)},t.prototype.rotate=function(t){var r=p(t),n=a(t);return this.transform(n,r,-r,n,0,0)},t.prototype.rotate_ccw=function(t){return this.rotate(-t)},t.prototype.translate_x=function(t){return this.translate(t,0)},t.prototype.translate_y=function(t){return this.translate(0,t)},t.prototype.flip=function(){return this.scale(-1,-1)},t.prototype.flip_x=function(){return this.scale(1,-1)},t.prototype.flip_y=function(){return this.scale(-1,1)},t}();n.AffineTransform=s,s.__name__="AffineTransform"},
function _(e,t,r,i,n){i();var l=e(1),o=e(239),a=e(240),h=e(125),c=Math.PI/2,s={above:{parallel:0,normal:-c,horizontal:0,vertical:-c},below:{parallel:0,normal:c,horizontal:0,vertical:c},left:{parallel:-c,normal:0,horizontal:0,vertical:-c},right:{parallel:c,normal:0,horizontal:0,vertical:c}},p={above:{parallel:"bottom",normal:"center",horizontal:"bottom",vertical:"center"},below:{parallel:"top",normal:"center",horizontal:"top",vertical:"center"},left:{parallel:"bottom",normal:"center",horizontal:"center",vertical:"bottom"},right:{parallel:"bottom",normal:"center",horizontal:"center",vertical:"bottom"}},b={above:{parallel:"center",normal:"left",horizontal:"center",vertical:"left"},below:{parallel:"center",normal:"left",horizontal:"center",vertical:"left"},left:{parallel:"center",normal:"right",horizontal:"right",vertical:"center"},right:{parallel:"center",normal:"left",horizontal:"left",vertical:"center"}},u={above:"right",below:"left",left:"right",right:"left"},g={above:"left",below:"right",left:"right",right:"left"},f=function(){function e(e){this.side=e}return Object.defineProperty(e.prototype,"dimension",{get:function(){return"above"==this.side||"below"==this.side?0:1},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"normals",{get:function(){switch(this.side){case"above":return[0,-1];case"below":return[0,1];case"left":return[-1,0];case"right":return[1,0]}},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"orientation",{get:function(){return this.is_horizontal?"horizontal":"vertical"},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"is_horizontal",{get:function(){return 0==this.dimension},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"is_vertical",{get:function(){return 1==this.dimension},enumerable:!1,configurable:!0}),e.prototype.get_label_text_heuristics=function(e){var t=this.side;return(0,h.isString)(e)?{vertical_align:p[t][e],align:b[t][e]}:{vertical_align:"center",align:(e<0?u:g)[t]}},e.prototype.get_label_angle_heuristic=function(e){return(0,h.isString)(e)?s[this.side][e]:-e},e}();r.Panel=f,f.__name__="Panel";var _=function(e){function t(t,r,i){void 0===i&&(i=!1);var n=e.call(this)||this;return n.panel=t,n.get_size=r,n.rotate=i,n.panel.is_horizontal?n.set_sizing({width_policy:"max",height_policy:"fixed"}):n.set_sizing({width_policy:"fixed",height_policy:"max"}),n}return(0,l.__extends)(t,e),t.prototype._content_size=function(){var e=this.get_size(),t=e.width,r=e.height;return!this.rotate||this.panel.is_horizontal?new o.Sizeable({width:t,height:r}):new o.Sizeable({width:r,height:t})},t.prototype.has_size_changed=function(){var e=this._content_size(),t=e.width,r=e.height;return this.panel.is_horizontal?this.bbox.height!=r:this.bbox.width!=t},t}(a.ContentLayoutable);r.SideLayout=_,_.__name__="SideLayout"},
function _(t,h,i,e,n){e();var o=t(136),r=Math.min,w=Math.max,d=function(){function t(t){void 0===t&&(t={}),this.width=null!=t.width?t.width:0,this.height=null!=t.height?t.height:0}return t.prototype.bounded_to=function(h){var i=h.width,e=h.height;return new t({width:this.width==1/0&&null!=i?i:this.width,height:this.height==1/0&&null!=e?e:this.height})},t.prototype.expanded_to=function(h){var i=h.width,e=h.height;return new t({width:i!=1/0?w(this.width,i):this.width,height:e!=1/0?w(this.height,e):this.height})},t.prototype.expand_to=function(t){var h=t.width,i=t.height;this.width=w(this.width,h),this.height=w(this.height,i)},t.prototype.narrowed_to=function(h){var i=h.width,e=h.height;return new t({width:r(this.width,i),height:r(this.height,e)})},t.prototype.narrow_to=function(t){var h=t.width,i=t.height;this.width=r(this.width,h),this.height=r(this.height,i)},t.prototype.grow_by=function(h){var i=h.left,e=h.right,n=h.top,o=h.bottom;return new t({width:this.width+i+e,height:this.height+n+o})},t.prototype.shrink_by=function(h){var i=h.left,e=h.right,n=h.top,o=h.bottom;return new t({width:w(this.width-i-e,0),height:w(this.height-n-o,0)})},t.prototype.map=function(h,i){return new t({width:h(this.width),height:(null!=i?i:h)(this.height)})},t}();i.Sizeable=d,d.__name__="Sizeable",i.SizingPolicy=(0,o.Enum)("fixed","fit","min","max")},
function _(i,t,e,n,h){n();var r=i(1),o=i(239),s=i(180),u=i(125),a=Math.min,l=Math.max,g=Math.round,_=function(){function i(){this.absolute=!1,this._bbox=new s.BBox,this._inner_bbox=new s.BBox,this._dirty=!1,this._handlers=[]}return i.prototype[Symbol.iterator]=function(){return(0,r.__generator)(this,(function(i){return[2]}))},Object.defineProperty(i.prototype,"bbox",{get:function(){return this._bbox},enumerable:!1,configurable:!0}),Object.defineProperty(i.prototype,"inner_bbox",{get:function(){return this._inner_bbox},enumerable:!1,configurable:!0}),Object.defineProperty(i.prototype,"sizing",{get:function(){return this._sizing},enumerable:!1,configurable:!0}),Object.defineProperty(i.prototype,"visible",{set:function(i){this._sizing.visible=i,this._dirty=!0},enumerable:!1,configurable:!0}),i.prototype.set_sizing=function(i){var t,e,n,h,r,o=null!==(t=i.width_policy)&&void 0!==t?t:"fit",s=i.width,u=i.min_width,a=i.max_width,l=null!==(e=i.height_policy)&&void 0!==e?e:"fit",g=i.height,_=i.min_height,d=i.max_height,c=i.aspect,p=null!==(n=i.margin)&&void 0!==n?n:{top:0,right:0,bottom:0,left:0},f=!1!==i.visible,y=null!==(h=i.halign)&&void 0!==h?h:"start",b=null!==(r=i.valign)&&void 0!==r?r:"start";this._sizing={width_policy:o,min_width:u,width:s,max_width:a,height_policy:l,min_height:_,height:g,max_height:d,aspect:c,margin:p,visible:f,halign:y,valign:b,size:{width:s,height:g}},this._init()},i.prototype._init=function(){},i.prototype._set_geometry=function(i,t){this._bbox=i,this._inner_bbox=t},i.prototype.set_geometry=function(i,t){var e,n,h,o=this.fixup_geometry;null!=o&&(i=(e=(0,r.__read)(o(i,t),2))[0],t=e[1]),this._set_geometry(i,null!=t?t:i);try{for(var s=(0,r.__values)(this._handlers),u=s.next();!u.done;u=s.next()){(0,u.value)(this._bbox,this._inner_bbox)}}catch(i){n={error:i}}finally{try{u&&!u.done&&(h=s.return)&&h.call(s)}finally{if(n)throw n.error}}},i.prototype.on_resize=function(i){this._handlers.push(i)},i.prototype.is_width_expanding=function(){return"max"==this.sizing.width_policy},i.prototype.is_height_expanding=function(){return"max"==this.sizing.height_policy},i.prototype.apply_aspect=function(i,t){var e=t.width,n=t.height,h=this.sizing.aspect;if(null!=h){var r=this.sizing,o=r.width_policy,s=r.height_policy;if("fixed"!=o&&"fixed"!=s)if(o==s){var u=e,a=g(e/h),l=g(n*h),_=n;Math.abs(i.width-u)+Math.abs(i.height-a)<=Math.abs(i.width-l)+Math.abs(i.height-_)?(e=u,n=a):(e=l,n=_)}else!function(i,t){var e={max:4,fit:3,min:2,fixed:1};return e[i]>e[t]}(o,s)?e=g(n*h):n=g(e/h);else"fixed"==o?n=g(e/h):"fixed"==s&&(e=g(n*h))}return{width:e,height:n}},i.prototype.measure=function(i){var t=this;if(!this.sizing.visible)return{width:0,height:0};var e=function(i){return"fixed"==t.sizing.width_policy&&null!=t.sizing.width?t.sizing.width:i},n=function(i){return"fixed"==t.sizing.height_policy&&null!=t.sizing.height?t.sizing.height:i},h=new o.Sizeable(i).shrink_by(this.sizing.margin).map(e,n),s=this._measure(h),u=this.clip_size(s,h),a=e(u.width),l=n(u.height),g=this.apply_aspect(h,{width:a,height:l});return(0,r.__assign)((0,r.__assign)({},s),g)},i.prototype.compute=function(i){void 0===i&&(i={});var t=this.measure({width:null!=i.width&&this.is_width_expanding()?i.width:1/0,height:null!=i.height&&this.is_height_expanding()?i.height:1/0}),e=t.width,n=t.height,h=new s.BBox({left:0,top:0,width:e,height:n}),r=void 0;if(null!=t.inner){var o=t.inner,u=o.left,a=o.top,l=o.right,g=o.bottom;r=new s.BBox({left:u,top:a,right:e-l,bottom:n-g})}this.set_geometry(h,r)},Object.defineProperty(i.prototype,"xview",{get:function(){return this.bbox.xview},enumerable:!1,configurable:!0}),Object.defineProperty(i.prototype,"yview",{get:function(){return this.bbox.yview},enumerable:!1,configurable:!0}),i.prototype.clip_size=function(i,t){function e(i,t,e,n){return null==e?e=0:(0,u.isNumber)(e)||(e=Math.round(e.percent*t)),null==n?n=1/0:(0,u.isNumber)(n)||(n=Math.round(n.percent*t)),l(e,a(i,n))}return{width:e(i.width,t.width,this.sizing.min_width,this.sizing.max_width),height:e(i.height,t.height,this.sizing.min_height,this.sizing.max_height)}},i.prototype.has_size_changed=function(){var i=this._dirty;return this._dirty=!1,i},i}();e.Layoutable=_,_.__name__="Layoutable";var d=function(i){function t(){return null!==i&&i.apply(this,arguments)||this}return(0,r.__extends)(t,i),t.prototype._measure=function(i){var t=this,e=this.sizing,n=e.width_policy,h=e.height_policy;return{width:function(){var e=t.sizing.width;if(i.width==1/0)return null!=e?e:0;switch(n){case"fixed":return null!=e?e:0;case"min":return null!=e?a(i.width,e):0;case"fit":return null!=e?a(i.width,e):i.width;case"max":return null!=e?l(i.width,e):i.width}}(),height:function(){var e=t.sizing.height;if(i.height==1/0)return null!=e?e:0;switch(h){case"fixed":return null!=e?e:0;case"min":return null!=e?a(i.height,e):0;case"fit":return null!=e?a(i.height,e):i.height;case"max":return null!=e?l(i.height,e):i.height}}()}},t}(_);e.LayoutItem=d,d.__name__="LayoutItem";var c=function(i){function t(){return null!==i&&i.apply(this,arguments)||this}return(0,r.__extends)(t,i),t.prototype._measure=function(i){var t=this,e=this._content_size(),n=i.bounded_to(this.sizing.size).bounded_to(e);return{width:function(){switch(t.sizing.width_policy){case"fixed":return null!=t.sizing.width?t.sizing.width:e.width;case"min":return e.width;case"fit":return n.width;case"max":return Math.max(e.width,n.width)}}(),height:function(){switch(t.sizing.height_policy){case"fixed":return null!=t.sizing.height?t.sizing.height:e.height;case"min":return e.height;case"fit":return n.height;case"max":return Math.max(e.height,n.height)}}()}},t}(_);e.ContentLayoutable=c,c.__name__="ContentLayoutable"},
function _(e,t,r,n,a){n();var s=e(1),_=e(177),i=e(176),o=e(173),c=e(178),l=e(182),g=e(180),u=e(128),f=e(127),y=function(){function e(e,t,r,n,a,s,_,i){void 0===a&&(a={}),void 0===s&&(s={}),void 0===_&&(_={}),void 0===i&&(i={}),this.in_x_scale=e,this.in_y_scale=t,this.x_range=r,this.y_range=n,this.extra_x_ranges=a,this.extra_y_ranges=s,this.extra_x_scales=_,this.extra_y_scales=i,this._bbox=new g.BBox,(0,f.assert)(null==e.source_range&&null==e.target_range),(0,f.assert)(null==t.source_range&&null==t.target_range),this._configure_scales()}return Object.defineProperty(e.prototype,"bbox",{get:function(){return this._bbox},enumerable:!1,configurable:!0}),e.prototype._get_ranges=function(e,t){return new Map((0,u.entries)((0,s.__assign)((0,s.__assign)({},t),{default:e})))},e.prototype._get_scales=function(e,t,r,n){var a,o,g,f=new Map((0,u.entries)((0,s.__assign)((0,s.__assign)({},t),{default:e}))),y=new Map;try{for(var h=(0,s.__values)(r),p=h.next();!p.done;p=h.next()){var b=(0,s.__read)(p.value,2),x=b[0],d=b[1];if(d instanceof l.FactorRange!=e instanceof _.CategoricalScale)throw new Error("Range "+d.type+" is incompatible is Scale "+e.type);e instanceof i.LogScale&&d instanceof c.DataRange1d&&(d.scale_hint="log");var v=(null!==(g=f.get(x))&&void 0!==g?g:e).clone();v.setv({source_range:d,target_range:n}),y.set(x,v)}}catch(e){a={error:e}}finally{try{p&&!p.done&&(o=h.return)&&o.call(h)}finally{if(a)throw a.error}}return y},e.prototype._configure_frame_ranges=function(){var e=this.bbox;this._x_target=new o.Range1d({start:e.left,end:e.right}),this._y_target=new o.Range1d({start:e.bottom,end:e.top})},e.prototype._configure_scales=function(){this._configure_frame_ranges(),this._x_ranges=this._get_ranges(this.x_range,this.extra_x_ranges),this._y_ranges=this._get_ranges(this.y_range,this.extra_y_ranges),this._x_scales=this._get_scales(this.in_x_scale,this.extra_x_scales,this._x_ranges,this._x_target),this._y_scales=this._get_scales(this.in_y_scale,this.extra_y_scales,this._y_ranges,this._y_target)},e.prototype._update_scales=function(){var e,t,r,n;this._configure_frame_ranges();try{for(var a=(0,s.__values)(this._x_scales),_=a.next();!_.done;_=a.next()){(0,s.__read)(_.value,2)[1].target_range=this._x_target}}catch(t){e={error:t}}finally{try{_&&!_.done&&(t=a.return)&&t.call(a)}finally{if(e)throw e.error}}try{for(var i=(0,s.__values)(this._y_scales),o=i.next();!o.done;o=i.next()){(0,s.__read)(o.value,2)[1].target_range=this._y_target}}catch(e){r={error:e}}finally{try{o&&!o.done&&(n=i.return)&&n.call(i)}finally{if(r)throw r.error}}},e.prototype.set_geometry=function(e){this._bbox=e,this._update_scales()},Object.defineProperty(e.prototype,"x_target",{get:function(){return this._x_target},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"y_target",{get:function(){return this._y_target},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"x_ranges",{get:function(){return this._x_ranges},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"y_ranges",{get:function(){return this._y_ranges},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"x_scales",{get:function(){return this._x_scales},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"y_scales",{get:function(){return this._y_scales},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"x_scale",{get:function(){return this._x_scales.get("default")},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"y_scale",{get:function(){return this._y_scales.get("default")},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"xscales",{get:function(){return(0,u.to_object)(this.x_scales)},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"yscales",{get:function(){return(0,u.to_object)(this.y_scales)},enumerable:!1,configurable:!0}),e}();r.CartesianFrame=y,y.__name__="CartesianFrame"},
function _(i,s,x,A,o){A(),o("Axis",i(243).Axis),o("CategoricalAxis",i(255).CategoricalAxis),o("ContinuousAxis",i(258).ContinuousAxis),o("DatetimeAxis",i(259).DatetimeAxis),o("LinearAxis",i(260).LinearAxis),o("LogAxis",i(277).LogAxis),o("MercatorAxis",i(280).MercatorAxis)},
function _(e,t,i,r,a){r();var n,o=e(1),s=e(244),l=e(245),_=e(246),u=e(247),c=(0,o.__importStar)(e(163)),h=e(135),d=e(139),b=e(238),f=e(126),p=e(128),v=e(125),m=e(235),x=e(182),g=e(248),y=e(228),w=e(127),j=e(125),k=e(249),z=Math.abs,P=function(e){function t(){var t=e.apply(this,(0,o.__spreadArray)([],(0,o.__read)(arguments),!1))||this;return t._axis_label_view=null,t._major_label_views=new Map,t}return(0,o.__extends)(t,e),t.prototype.lazy_initialize=function(){return(0,o.__awaiter)(this,void 0,void 0,(function(){return(0,o.__generator)(this,(function(t){switch(t.label){case 0:return[4,e.prototype.lazy_initialize.call(this)];case 1:return t.sent(),[4,this._init_axis_label()];case 2:return t.sent(),[4,this._init_major_labels()];case 3:return t.sent(),[2]}}))}))},t.prototype._init_axis_label=function(){return(0,o.__awaiter)(this,void 0,void 0,(function(){var e,t,i;return(0,o.__generator)(this,(function(r){switch(r.label){case 0:return null==(e=this.model.axis_label)?[3,2]:(t=(0,j.isString)(e)?(0,k.parse_delimited_string)(e):e,i=this,[4,(0,y.build_view)(t,{parent:this})]);case 1:return i._axis_label_view=r.sent(),[3,3];case 2:this._axis_label_view=null,r.label=3;case 3:return[2]}}))}))},t.prototype._init_major_labels=function(){return(0,o.__awaiter)(this,void 0,void 0,(function(){var e,t,i,r,a,n,s,l,_,u,c,h,d;return(0,o.__generator)(this,(function(b){switch(b.label){case 0:e=this.model.major_label_overrides,b.label=1;case 1:b.trys.push([1,6,7,8]),t=(0,o.__values)((0,p.entries)(e)),i=t.next(),b.label=2;case 2:return i.done?[3,5]:(r=(0,o.__read)(i.value,2),a=r[0],n=r[1],s=(0,j.isString)(n)?(0,k.parse_delimited_string)(n):n,_=(l=this._major_label_views).set,u=[a],[4,(0,y.build_view)(s,{parent:this})]);case 3:_.apply(l,u.concat([b.sent()])),b.label=4;case 4:return i=t.next(),[3,2];case 5:return[3,8];case 6:return c=b.sent(),h={error:c},[3,8];case 7:try{i&&!i.done&&(d=t.return)&&d.call(t)}finally{if(h)throw h.error}return[7];case 8:return[2]}}))}))},t.prototype.update_layout=function(){var e=this;this.layout=new b.SideLayout(this.panel,(function(){return e.get_size()}),!0),this.layout.on_resize((function(){return e._coordinates=void 0}))},t.prototype.get_size=function(){var e=this.model,t=e.visible,i=e.fixed_location;if(t&&null==i&&this.is_renderable){var r=this.extents;return{width:0,height:Math.round(r.tick+r.tick_label+r.axis_label)}}return{width:0,height:0}},Object.defineProperty(t.prototype,"is_renderable",{get:function(){var e=(0,o.__read)(this.ranges,2),t=e[0],i=e[1];return t.is_valid&&i.is_valid},enumerable:!1,configurable:!0}),t.prototype._render=function(){var e;if(this.is_renderable){var t=this.tick_coords,i=this.extents,r=this.layer.ctx;r.save(),this._draw_rule(r,i),this._draw_major_ticks(r,i,t),this._draw_minor_ticks(r,i,t),this._draw_major_labels(r,i,t),this._draw_axis_label(r,i,t),null===(e=this._paint)||void 0===e||e.call(this,r,i,t),r.restore()}},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this);var i=this.model.properties,r=i.axis_label,a=i.major_label_overrides;this.on_change(r,(function(){return(0,o.__awaiter)(t,void 0,void 0,(function(){var e;return(0,o.__generator)(this,(function(t){switch(t.label){case 0:return null===(e=this._axis_label_view)||void 0===e||e.remove(),[4,this._init_axis_label()];case 1:return t.sent(),[2]}}))}))})),this.on_change(a,(function(){return(0,o.__awaiter)(t,void 0,void 0,(function(){var e,t,i,r;return(0,o.__generator)(this,(function(a){switch(a.label){case 0:try{for(e=(0,o.__values)(this._major_label_views.values()),t=e.next();!t.done;t=e.next())t.value.remove()}catch(e){i={error:e}}finally{try{t&&!t.done&&(r=e.return)&&r.call(e)}finally{if(i)throw i.error}}return[4,this._init_major_labels()];case 1:return a.sent(),[2]}}))}))})),this.connect(this.model.change,(function(){return t.plot_view.request_layout()}))},Object.defineProperty(t.prototype,"needs_clip",{get:function(){return null!=this.model.fixed_location},enumerable:!1,configurable:!0}),t.prototype._draw_rule=function(e,t){if(this.visuals.axis_line.doit){var i=(0,o.__read)(this.rule_coords,2),r=i[0],a=i[1],n=(0,o.__read)(this.coordinates.map_to_screen(r,a),2),s=n[0],l=n[1],_=(0,o.__read)(this.normals,2),u=_[0],c=_[1],h=(0,o.__read)(this.offsets,2),d=h[0],b=h[1];this.visuals.axis_line.set_value(e),e.beginPath();for(var f=0;f<s.length;f++){var p=Math.round(s[f]+u*d),v=Math.round(l[f]+c*b);e.lineTo(p,v)}e.stroke()}},t.prototype._draw_major_ticks=function(e,t,i){var r=this.model.major_tick_in,a=this.model.major_tick_out,n=this.visuals.major_tick_line;this._draw_ticks(e,i.major,r,a,n)},t.prototype._draw_minor_ticks=function(e,t,i){var r=this.model.minor_tick_in,a=this.model.minor_tick_out,n=this.visuals.minor_tick_line;this._draw_ticks(e,i.minor,r,a,n)},t.prototype._draw_major_labels=function(e,t,i){var r=i.major,a=this.compute_labels(r[this.dimension]),n=this.model.major_label_orientation,o=t.tick+this.model.major_label_standoff,s=this.visuals.major_label_text;this._draw_oriented_labels(e,a,r,n,this.panel.side,o,s)},t.prototype._axis_label_extent=function(){if(null==this._axis_label_view)return 0;var e=this._axis_label_view.graphics();e.visuals=this.visuals.axis_label_text.values(),e.angle=this.panel.get_label_angle_heuristic("parallel"),(0,v.isNumber)(this.plot_view.base_font_size)&&(e.base_font_size=this.plot_view.base_font_size);var t=e.size(),i=0==this.dimension?t.height:t.width,r=this.model.axis_label_standoff;return i>0?r+i+3:0},t.prototype._draw_axis_label=function(e,t,i){var r=this;if(null!=this._axis_label_view&&null==this.model.fixed_location){var a=(0,o.__read)(function(){var e=r.layout.bbox;switch(r.panel.side){case"above":return[e.hcenter,e.bottom];case"below":return[e.hcenter,e.top];case"left":return[e.right,e.vcenter];case"right":return[e.left,e.vcenter]}}(),2),n=a[0],s=a[1],l=(0,o.__read)(this.normals,2),_=l[0],u=l[1],c=t.tick+t.tick_label+this.model.axis_label_standoff,h=this.panel.get_label_text_heuristics("parallel"),d=h.vertical_align,b=h.align,f={sx:n+_*c,sy:s+u*c,x_anchor:b,y_anchor:d},p=this._axis_label_view.graphics();p.visuals=this.visuals.axis_label_text.values(),p.angle=this.panel.get_label_angle_heuristic("parallel"),this.plot_view.base_font_size&&(p.base_font_size=this.plot_view.base_font_size),p.position=f,p.align=b,p.paint(e)}},t.prototype._draw_ticks=function(e,t,i,r,a){if(a.doit){var n=(0,o.__read)(t,2),s=n[0],l=n[1],_=(0,o.__read)(this.coordinates.map_to_screen(s,l),2),u=_[0],c=_[1],h=(0,o.__read)(this.normals,2),d=h[0],b=h[1],f=(0,o.__read)(this.offsets,2),p=f[0],v=f[1],m=(0,o.__read)([d*(p-i),b*(v-i)],2),x=m[0],g=m[1],y=(0,o.__read)([d*(p+r),b*(v+r)],2),w=y[0],j=y[1];a.set_value(e),e.beginPath();for(var k=0;k<u.length;k++){var z=Math.round(u[k]+w),P=Math.round(c[k]+j),M=Math.round(u[k]+x),O=Math.round(c[k]+g);e.moveTo(z,P),e.lineTo(M,O)}e.stroke()}},t.prototype._draw_oriented_labels=function(e,t,i,r,a,n,s){var l,_,u=this;if(s.doit&&0!=t.length){var c=(0,o.__read)(i,2),h=c[0],b=c[1],f=(0,o.__read)(this.coordinates.map_to_screen(h,b),2),p=f[0],v=f[1],x=(0,o.__read)(this.offsets,2),g=x[0],y=x[1],w=(0,o.__read)(this.normals,2),j=w[0]*(g+n),k=w[1]*(y+n),z=this.panel.get_label_text_heuristics(r),P=z.vertical_align,M=z.align,O=this.panel.get_label_angle_heuristic(r);t.visuals=s.values(),t.angle=O,t.base_font_size=this.plot_view.base_font_size;for(var T=0;T<t.length;T++){(E=t.items[T]).position={sx:p[T]+j,sy:v[T]+k,x_anchor:M,y_anchor:P},E instanceof m.TextBox&&(E.align=M)}var A=t.length,L=d.Indices.all_set(A),S=t.items,N=S.map((function(e){return e.bbox()})),B=(0,o.__read)(u.ranges,1)[0].is_reversed?0==u.dimension?function(e,t){return N[e].left-N[t].right}:function(e,t){return N[t].top-N[e].bottom}:0==u.dimension?function(e,t){return N[t].left-N[e].right}:function(e,t){return N[e].top-N[t].bottom},R=this.model.major_label_policy.filter(L,N,B),G=(0,o.__spreadArray)([],(0,o.__read)(R.ones()),!1);if(0!=G.length){var V=this.parent.canvas_view.bbox,F=function(e){var t=N[e];if(t.left<0){var i=-t.left,r=S[e].position;S[e].position=(0,o.__assign)((0,o.__assign)({},r),{sx:r.sx+i})}else if(t.right>V.width){i=t.right-V.width,r=S[e].position;S[e].position=(0,o.__assign)((0,o.__assign)({},r),{sx:r.sx-i})}},I=function(e){var t=N[e];if(t.top<0){var i=-t.top,r=S[e].position;S[e].position=(0,o.__assign)((0,o.__assign)({},r),{sy:r.sy+i})}else if(t.bottom>V.height){i=t.bottom-V.height,r=S[e].position;S[e].position=(0,o.__assign)((0,o.__assign)({},r),{sy:r.sy-i})}},q=(T=G[0],G[G.length-1]);0==this.dimension?(F(T),F(q)):(I(T),I(q))}try{for(var D=(0,o.__values)(R),C=D.next();!C.done;C=D.next()){var E;T=C.value;(E=S[T]).paint(e)}}catch(e){l={error:e}}finally{try{C&&!C.done&&(_=D.return)&&_.call(D)}finally{if(l)throw l.error}}}},t.prototype._tick_extent=function(){return this.model.major_tick_out},t.prototype._tick_label_extents=function(){var e=this.tick_coords.major,t=this.compute_labels(e[this.dimension]),i=this.model.major_label_orientation,r=this.model.major_label_standoff,a=this.visuals.major_label_text;return[this._oriented_labels_extent(t,i,r,a)]},Object.defineProperty(t.prototype,"extents",{get:function(){var e=this._tick_label_extents();return{tick:this._tick_extent(),tick_labels:e,tick_label:(0,f.sum)(e),axis_label:this._axis_label_extent()}},enumerable:!1,configurable:!0}),t.prototype._oriented_labels_extent=function(e,t,i,r){if(0==e.length||!r.doit)return 0;var a=this.panel.get_label_angle_heuristic(t);e.visuals=r.values(),e.angle=a,e.base_font_size=this.plot_view.base_font_size;var n=e.max_size(),o=0==this.dimension?n.height:n.width;return o>0?i+o+3:0},Object.defineProperty(t.prototype,"normals",{get:function(){return this.panel.normals},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"dimension",{get:function(){return this.panel.dimension},enumerable:!1,configurable:!0}),t.prototype.compute_labels=function(e){for(var t,i,r=this.model.formatter.format_graphics(e,this),a=this._major_label_views,n=new Set,s=0;s<e.length;s++){var l=a.get(e[s].toString());null!=l&&(n.add(l),r[s]=l.graphics())}try{for(var _=(0,o.__values)(this._major_label_views.values()),u=_.next();!u.done;u=_.next()){var c=u.value;n.has(c)||(c._has_finished=!0)}}catch(e){t={error:e}}finally{try{u&&!u.done&&(i=_.return)&&i.call(_)}finally{if(t)throw t.error}}return new m.GraphicsBoxes(r)},Object.defineProperty(t.prototype,"offsets",{get:function(){if(null!=this.model.fixed_location)return[0,0];var e=this.plot_view.frame,t=(0,o.__read)([0,0],2),i=t[0],r=t[1];switch(this.panel.side){case"below":r=z(this.layout.bbox.top-e.bbox.bottom);break;case"above":r=z(this.layout.bbox.bottom-e.bbox.top);break;case"right":i=z(this.layout.bbox.left-e.bbox.right);break;case"left":i=z(this.layout.bbox.right-e.bbox.left)}return[i,r]},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"ranges",{get:function(){var e=this.dimension,t=(e+1)%2,i=this.coordinates.ranges;return[i[e],i[t]]},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"computed_bounds",{get:function(){var e=(0,o.__read)(this.ranges,1)[0],t=this.model.bounds,i=[e.min,e.max];if("auto"==t)return[e.min,e.max];var r=void 0,a=void 0,n=(0,o.__read)(t,2),s=n[0],l=n[1],_=(0,o.__read)(i,2),u=_[0],c=_[1],h=Math.min,d=Math.max;return z(s-l)>z(u-c)?(r=d(h(s,l),u),a=h(d(s,l),c)):(r=h(s,l),a=d(s,l)),[r,a]},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"rule_coords",{get:function(){var e=this.dimension,t=(e+1)%2,i=(0,o.__read)(this.ranges,1)[0],r=(0,o.__read)(this.computed_bounds,2),a=r[0],n=r[1],s=[new Array(2),new Array(2)];return s[e][0]=Math.max(a,i.min),s[e][1]=Math.min(n,i.max),s[e][0]>s[e][1]&&(s[e][0]=s[e][1]=NaN),s[t][0]=this.loc,s[t][1]=this.loc,s},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"tick_coords",{get:function(){for(var e=this.dimension,t=(e+1)%2,i=(0,o.__read)(this.ranges,1)[0],r=(0,o.__read)(this.computed_bounds,2),a=r[0],n=r[1],s=this.model.ticker.get_ticks(a,n,i,this.loc),l=s.major,_=s.minor,u=[[],[]],c=[[],[]],h=(0,o.__read)([i.min,i.max],2),d=h[0],b=h[1],f=0;f<l.length;f++)l[f]<d||l[f]>b||(u[e].push(l[f]),u[t].push(this.loc));for(f=0;f<_.length;f++)_[f]<d||_[f]>b||(c[e].push(_[f]),c[t].push(this.loc));return{major:u,minor:c}},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"loc",{get:function(){var e=this.model.fixed_location;if(null!=e){if((0,v.isNumber)(e))return e;var t=(0,o.__read)(this.ranges,2)[1];if(t instanceof x.FactorRange)return t.synthetic(e);(0,w.unreachable)()}var i=(0,o.__read)(this.ranges,2)[1];switch(this.panel.side){case"left":case"below":return i.start;case"right":case"above":return i.end}},enumerable:!1,configurable:!0}),t.prototype.serializable_state=function(){return(0,o.__assign)((0,o.__assign)({},e.prototype.serializable_state.call(this)),{bbox:this.layout.bbox.box})},t.prototype.remove=function(){var t,i,r;null===(r=this._axis_label_view)||void 0===r||r.remove();try{for(var a=(0,o.__values)(this._major_label_views.values()),n=a.next();!n.done;n=a.next()){n.value.remove()}}catch(e){t={error:e}}finally{try{n&&!n.done&&(i=a.return)&&i.call(a)}finally{if(t)throw t.error}}e.prototype.remove.call(this)},t.prototype.has_finished=function(){var t,i;if(!e.prototype.has_finished.call(this))return!1;if(null!=this._axis_label_view&&!this._axis_label_view.has_finished())return!1;try{for(var r=(0,o.__values)(this._major_label_views.values()),a=r.next();!a.done;a=r.next()){if(!a.value.has_finished())return!1}}catch(e){t={error:e}}finally{try{a&&!a.done&&(i=r.return)&&i.call(r)}finally{if(t)throw t.error}}return!0},t}(s.GuideRendererView);i.AxisView=P,P.__name__="AxisView";var M=function(e){function t(t){return e.call(this,t)||this}return(0,o.__extends)(t,e),t}(s.GuideRenderer);i.Axis=M,n=M,M.__name__="Axis",n.prototype.default_view=P,n.mixins([["axis_",c.Line],["major_tick_",c.Line],["minor_tick_",c.Line],["major_label_",c.Text],["axis_label_",c.Text]]),n.define((function(e){var t=e.Any,i=e.Int,r=e.Number,a=e.String,n=e.Ref,o=e.Dict,s=e.Tuple,c=e.Or,d=e.Nullable,b=e.Auto;return{bounds:[c(s(r,r),b),"auto"],ticker:[n(l.Ticker)],formatter:[n(_.TickFormatter)],axis_label:[d(c(a,n(g.BaseText))),null],axis_label_standoff:[i,5],major_label_standoff:[i,5],major_label_orientation:[c(h.TickLabelOrientation,r),"horizontal"],major_label_overrides:[o(c(a,n(g.BaseText))),{}],major_label_policy:[n(u.LabelingPolicy),function(){return new u.AllLabels}],major_tick_in:[r,2],major_tick_out:[r,6],minor_tick_in:[r,0],minor_tick_out:[r,4],fixed_location:[d(c(r,t)),null]}})),n.override({axis_line_color:"black",major_tick_line_color:"black",minor_tick_line_color:"black",major_label_text_font_size:"11px",major_label_text_align:"center",major_label_text_baseline:"alphabetic",axis_label_text_font_size:"13px",axis_label_text_font_style:"italic"})},
function _(e,n,r,i,t){i();var u,d=e(1),_=e(156),l=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,d.__extends)(n,e),n}(_.RendererView);r.GuideRendererView=l,l.__name__="GuideRendererView";var a=function(e){function n(n){return e.call(this,n)||this}return(0,d.__extends)(n,e),n}(_.Renderer);r.GuideRenderer=a,u=a,a.__name__="GuideRenderer",u.override({level:"guide"})},
function _(n,e,t,i,r){i();var _=n(1),c=function(n){function e(e){return n.call(this,e)||this}return(0,_.__extends)(e,n),e}(n(168).Model);t.Ticker=c,c.__name__="Ticker"},
function _(t,o,n,r,e){r();var u=t(1),c=t(168),i=t(235),a=function(t){function o(o){return t.call(this,o)||this}return(0,u.__extends)(o,t),o.prototype.format_graphics=function(t,o){return this.doFormat(t,o).map((function(t){return new i.TextBox({text:t})}))},o.prototype.compute=function(t,o){return this.doFormat([t],null!=o?o:{loc:0})[0]},o.prototype.v_compute=function(t,o){return this.doFormat(t,null!=o?o:{loc:0})},o}(c.Model);n.TickFormatter=a,a.__name__="TickFormatter"},
function _(e,n,r,t,i){t();var a,o,u=e(1),l=e(168),s=e(128),c=e(149),_=e(125),f=e(139),d=function(e){function n(n){return e.call(this,n)||this}return(0,u.__extends)(n,e),n}(l.Model);r.LabelingPolicy=d,d.__name__="LabelingPolicy";var p=function(e){function n(n){return e.call(this,n)||this}return(0,u.__extends)(n,e),n.prototype.filter=function(e,n,r){return e},n}(d);r.AllLabels=p,p.__name__="AllLabels";var v=function(e){function n(n){return e.call(this,n)||this}return(0,u.__extends)(n,e),n.prototype.filter=function(e,n,r){var t,i,a=this.min_distance,o=null;try{for(var l=(0,u.__values)(e),s=l.next();!s.done;s=l.next()){var c=s.value;null!=o&&r(o,c)<a?e.unset(c):o=c}}catch(e){t={error:e}}finally{try{s&&!s.done&&(i=l.return)&&i.call(l)}finally{if(t)throw t.error}}return e},n}(d);r.NoOverlap=v,a=v,v.__name__="NoOverlap",a.define((function(e){return{min_distance:[e.Number,5]}}));var y=function(e){function n(n){return e.call(this,n)||this}return(0,u.__extends)(n,e),Object.defineProperty(n.prototype,"names",{get:function(){return(0,s.keys)(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"values",{get:function(){return(0,s.values)(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"func",{get:function(){var e=(0,c.use_strict)(this.code);return new(f.GeneratorFunction.bind.apply(f.GeneratorFunction,(0,u.__spreadArray)((0,u.__spreadArray)([void 0,"indices","bboxes","distance"],(0,u.__read)(this.names),!1),[e],!1)))},enumerable:!1,configurable:!0}),n.prototype.filter=function(e,n,r){var t,i=Object.create(null),a=(t=this.func).call.apply(t,(0,u.__spreadArray)([i,e,n,r],(0,u.__read)(this.values),!1)),o=a.next();if(o.done&&void 0!==o.value){var l=o.value;return l instanceof f.Indices?l:void 0===l?e:(0,_.isIterable)(l)?f.Indices.from_indices(e.size,l):f.Indices.all_unset(e.size)}var s=[];do{s.push(o.value),o=a.next()}while(!o.done);return f.Indices.from_indices(e.size,s)},n}(d);r.CustomLabelingPolicy=y,o=y,y.__name__="CustomLabelingPolicy",o.define((function(e){var n=e.Unknown,r=e.String;return{args:[(0,e.Dict)(n),{}],code:[r,""]}}))},
function _(e,n,t,i,r){i();var _,u=e(1),a=e(168),s=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,u.__extends)(n,e),n}(e(157).View);t.BaseTextView=s,s.__name__="BaseTextView";var c=function(e){function n(n){return e.call(this,n)||this}return(0,u.__extends)(n,e),n}(a.Model);t.BaseText=c,_=c,c.__name__="BaseText",_.define((function(e){return{text:[e.String]}}))},
function _(e,n,t,r,i){r();var a=e(1),l=e(250),d=e(254),f=[{start:"$$",end:"$$",inline:!1},{start:"\\[",end:"\\]",inline:!1},{start:"\\(",end:"\\)",inline:!0}];t.parse_delimited_string=function(e){var n,t;try{for(var r=(0,a.__values)(f),i=r.next();!i.done;i=r.next()){var s=i.value,o=e.indexOf(s.start),u=o+s.start.length;if(0==o){var v=e.indexOf(s.end,u),x=v;if(v==e.length-s.end.length)return new l.TeX({text:e.slice(u,x),inline:s.inline});break}}}catch(e){n={error:e}}finally{try{i&&!i.done&&(t=r.return)&&t.call(r)}finally{if(n)throw n.error}}return new d.PlainText({text:e})}},
function _(t,e,i,n,r){n();var o,s,a,h=t(1),_=t(125),u=t(251),l=t(137),c=t(235),p=t(236),f=t(237),d=t(180),v=t(248),g=t(252),y=function(t){function e(){var e=t.apply(this,(0,h.__spreadArray)([],(0,h.__read)(arguments),!1))||this;return e._position={sx:0,sy:0},e.align="left",e._x_anchor="left",e._y_anchor="center",e._base_font_size=13,e.font_size_scale=1,e.svg_image=null,e}return(0,h.__extends)(e,t),e.prototype.graphics=function(){return this},e.prototype.infer_text_height=function(){return"ascent_descent"},Object.defineProperty(e.prototype,"base_font_size",{get:function(){return this._base_font_size},set:function(t){null!=t&&(this._base_font_size=t)},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"has_image_loaded",{get:function(){return null!=this.svg_image},enumerable:!1,configurable:!0}),e.prototype._rect=function(){var t=this._size(),e=t.width,i=t.height,n=this._computed_position(),r=n.x,o=n.y;return new d.BBox({x:r,y:o,width:e,height:i}).rect},Object.defineProperty(e.prototype,"position",{get:function(){return this._position},set:function(t){this._position=t},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"text",{get:function(){return this.model.text},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"provider",{get:function(){return g.default_provider},enumerable:!1,configurable:!0}),e.prototype.lazy_initialize=function(){return(0,h.__awaiter)(this,void 0,void 0,(function(){var e=this;return(0,h.__generator)(this,(function(i){switch(i.label){case 0:return[4,t.prototype.lazy_initialize.call(this)];case 1:return i.sent(),"not_started"!=this.provider.status?[3,3]:[4,this.provider.fetch()];case 2:i.sent(),i.label=3;case 3:return"not_started"!=this.provider.status&&"loading"!=this.provider.status||this.provider.ready.connect((function(){return e.load_image()})),"loaded"!=this.provider.status?[3,5]:[4,this.load_image()];case 4:i.sent(),i.label=5;case 5:return[2]}}))}))},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.on_change(this.model.properties.text,(function(){return e.load_image()}))},Object.defineProperty(e.prototype,"visuals",{set:function(t){var e=t.color,i=t.alpha,n=t.font_style,r=t.font_size,o=t.font,s=this.font_size_scale,a=this._base_font_size,h=(0,p.parse_css_font_size)(r);if(null!=h){var _=h.value,u=h.unit;_*=s,"em"==u&&a&&(_*=a,u="px"),r=""+_+u}var c=n+" "+r+" "+o;this.font=c,this.color=(0,l.color2css)(e,i)},enumerable:!1,configurable:!0}),e.prototype._computed_position=function(){var t=this._size(),e=t.width,i=t.height,n=this.position,r=n.sx,o=n.sy,s=n.x_anchor,a=void 0===s?this._x_anchor:s,h=n.y_anchor,u=void 0===h?this._y_anchor:h;return{x:r-function(){if((0,_.isNumber)(a))return a*e;switch(a){case"left":return 0;case"center":return.5*e;case"right":return e}}(),y:o-function(){if((0,_.isNumber)(u))return u*i;switch(u){case"top":return 0;case"center":return.5*i;case"bottom":return i;case"baseline":return.5*i}}()}},e.prototype.size=function(){var t=this._size(),e=t.width,i=t.height,n=this.angle;if(n){var r=Math.cos(Math.abs(n)),o=Math.sin(Math.abs(n));return{width:Math.abs(e*r+i*o),height:Math.abs(e*o+i*r)}}return{width:e,height:i}},e.prototype.get_text_dimensions=function(){return{width:(0,c.text_width)(this.model.text,this.font),height:(0,p.font_metrics)(this.font).height}},e.prototype.get_image_dimensions=function(){var t,e,i,n,r=parseFloat(null!==(e=null===(t=this.svg_element.getAttribute("height"))||void 0===t?void 0:t.replace(/([A-z])/g,""))&&void 0!==e?e:"0"),o=parseFloat(null!==(n=null===(i=this.svg_element.getAttribute("width"))||void 0===i?void 0:i.replace(/([A-z])/g,""))&&void 0!==n?n:"0");return{width:(0,p.font_metrics)(this.font).x_height*o,height:(0,p.font_metrics)(this.font).x_height*r}},e.prototype._size=function(){return this.has_image_loaded?this.get_image_dimensions():this.get_text_dimensions()},e.prototype.bbox=function(){var t=this.rect(),e=t.p0,i=t.p1,n=t.p2,r=t.p3,o=Math.min(e.x,i.x,n.x,r.x),s=Math.min(e.y,i.y,n.y,r.y),a=Math.max(e.x,i.x,n.x,r.x),h=Math.max(e.y,i.y,n.y,r.y);return new d.BBox({left:o,right:a,top:s,bottom:h})},e.prototype.rect=function(){var t=this._rect(),e=this.angle;if(e){var i=this.position,n=i.sx,r=i.sy,o=new f.AffineTransform;return o.translate(n,r),o.rotate(e),o.translate(-n,-r),o.apply_rect(t)}return t},e.prototype.paint_rect=function(t){var e=this.rect(),i=e.p0,n=e.p1,r=e.p2,o=e.p3;t.save(),t.strokeStyle="red",t.lineWidth=1,t.beginPath();var s=Math.round;t.moveTo(s(i.x),s(i.y)),t.lineTo(s(n.x),s(n.y)),t.lineTo(s(r.x),s(r.y)),t.lineTo(s(o.x),s(o.y)),t.closePath(),t.stroke(),t.restore()},e.prototype.paint_bbox=function(t){var e=this.bbox(),i=e.x,n=e.y,r=e.width,o=e.height;t.save(),t.strokeStyle="blue",t.lineWidth=1,t.beginPath();var s=Math.round;t.moveTo(s(i),s(n)),t.lineTo(s(i),s(n+o)),t.lineTo(s(i+r),s(n+o)),t.lineTo(s(i+r),s(n)),t.closePath(),t.stroke(),t.restore()},e.prototype.load_image=function(){return(0,h.__awaiter)(this,void 0,void 0,(function(){var t,e,i,n,r,o;return(0,h.__generator)(this,(function(s){switch(s.label){case 0:if(null==this.provider.MathJax)return[2,null];if(null==(t=this._process_text(this.model.text)))return this._has_finished=!0,[2,null];e=t.children[0],this.svg_element=e,e.setAttribute("font",this.font),e.setAttribute("stroke",this.color),i=e.outerHTML,n=new Blob([i],{type:"image/svg+xml"}),r=URL.createObjectURL(n),s.label=1;case 1:return s.trys.push([1,,3,4]),o=this,[4,(0,u.load_image)(r)];case 2:return o.svg_image=s.sent(),[3,4];case 3:return URL.revokeObjectURL(r),[7];case 4:return this.parent.request_layout(),[2,this.svg_image]}}))}))},e.prototype.paint=function(t){t.save();var e=this.position,i=e.sx,n=e.sy;this.angle&&(t.translate(i,n),t.rotate(this.angle),t.translate(-i,-n));var r=this._computed_position(),o=r.x,s=r.y;if(null!=this.svg_image){var a=this.get_image_dimensions(),h=a.width,_=a.height;t.drawImage(this.svg_image,o,s,h,_)}else t.fillStyle=this.color,t.font=this.font,t.textAlign="left",t.textBaseline="alphabetic",t.fillText(this.model.text,o,s+(0,p.font_metrics)(this.font).ascent);t.restore(),this._has_finished||"failed"!=this.provider.status&&!this.has_image_loaded||(this._has_finished=!0,this.parent.notify_finished_after_paint())},e}(v.BaseTextView);i.MathTextView=y,y.__name__="MathTextView";var m=function(t){function e(e){return t.call(this,e)||this}return(0,h.__extends)(e,t),e}(v.BaseText);i.MathText=m,m.__name__="MathText";var x=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,h.__extends)(e,t),e.prototype._process_text=function(t){},e}(y);i.AsciiView=x,x.__name__="AsciiView";var b=function(t){function e(e){return t.call(this,e)||this}return(0,h.__extends)(e,t),e}(m);i.Ascii=b,o=b,b.__name__="Ascii",o.prototype.default_view=x;var w=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,h.__extends)(e,t),e.prototype._process_text=function(t){var e;return null===(e=this.provider.MathJax)||void 0===e?void 0:e.mathml2svg(t.trim())},e}(y);i.MathMLView=w,w.__name__="MathMLView";var M=function(t){function e(e){return t.call(this,e)||this}return(0,h.__extends)(e,t),e}(m);i.MathML=M,s=M,M.__name__="MathML",s.prototype.default_view=w;var T=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,h.__extends)(e,t),e.prototype._process_text=function(t){var e;return null===(e=this.provider.MathJax)||void 0===e?void 0:e.tex2svg(t,void 0,this.model.macros)},e}(y);i.TeXView=T,T.__name__="TeXView";var z=function(t){function e(e){return t.call(this,e)||this}return(0,h.__extends)(e,t),e}(m);i.TeX=z,a=z,z.__name__="TeX",a.prototype.default_view=T,a.define((function(t){var e=t.Boolean,i=t.Number,n=t.String,r=t.Dict,o=t.Tuple;return{macros:[r((0,t.Or)(n,o(n,i))),{}],inline:[e,!1]}}))},
function _(e,i,n,r,t){r();var o=e(1),a=e(134);n.load_image=function(e,i){return(0,o.__awaiter)(this,void 0,void 0,(function(){return(0,o.__generator)(this,(function(n){return[2,new u(e,i).promise]}))}))};var u=function(){function e(e,i){var n=this;void 0===i&&(i={}),this._image=new Image,this._finished=!1;var r=i.attempts,t=void 0===r?1:r,o=i.timeout,u=void 0===o?1:o;this.promise=new Promise((function(r,o){n._image.crossOrigin="anonymous";var g=0;n._image.onerror=function(){if(++g==t){var r="unable to load "+e+" image after "+t+" attempts";if(a.logger.warn(r),null==n._image.crossOrigin)return void(null!=i.failed&&i.failed());a.logger.warn("attempting to load "+e+" without a cross origin policy"),n._image.crossOrigin=null,g=0}setTimeout((function(){return n._image.src=e}),u)},n._image.onload=function(){n._finished=!0,null!=i.loaded&&i.loaded(n._image),r(n._image)},n._image.src=e}))}return Object.defineProperty(e.prototype,"finished",{get:function(){return this._finished},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"image",{get:function(){if(this._finished)return this._image;throw new Error("not loaded yet")},enumerable:!1,configurable:!0}),e}();n.ImageLoader=u,u.__name__="ImageLoader"},
function _(t,e,n,r,i){r();var a=t(1),o=t(130),u=t(253),s=function(){this.ready=new o.Signal0(this,"ready"),this.status="not_started"};n.MathJaxProvider=s,s.__name__="MathJaxProvider";var d=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,a.__extends)(e,t),Object.defineProperty(e.prototype,"MathJax",{get:function(){return null},enumerable:!1,configurable:!0}),e.prototype.fetch=function(){return(0,a.__awaiter)(this,void 0,void 0,(function(){return(0,a.__generator)(this,(function(t){return this.status="failed",[2]}))}))},e}(s);n.NoProvider=d,d.__name__="NoProvider";var c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,a.__extends)(e,t),Object.defineProperty(e.prototype,"MathJax",{get:function(){return"undefined"!=typeof MathJax?MathJax:null},enumerable:!1,configurable:!0}),e.prototype.fetch=function(){return(0,a.__awaiter)(this,void 0,void 0,(function(){var t,e=this;return(0,a.__generator)(this,(function(n){return(t=document.createElement("script")).src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-svg.js",t.onload=function(){e.status="loaded",e.ready.emit()},t.onerror=function(){e.status="failed"},this.status="loading",document.head.appendChild(t),[2]}))}))},e}(s);n.CDNProvider=c,c.__name__="CDNProvider";var h=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(n,e),Object.defineProperty(n.prototype,"MathJax",{get:function(){return this._mathjax},enumerable:!1,configurable:!0}),n.prototype.fetch=function(){return(0,a.__awaiter)(this,void 0,void 0,(function(){var e;return(0,a.__generator)(this,(function(n){switch(n.label){case 0:this.status="loading",n.label=1;case 1:return n.trys.push([1,3,,4]),[4,(0,u.load_module)(Promise.resolve().then((function(){return(0,a.__importStar)(t(630))})))];case 2:return e=n.sent(),this._mathjax=e,this.status="loaded",this.ready.emit(),[3,4];case 3:return n.sent(),this.status="failed",[3,4];case 4:return[2]}}))}))},n}(s);n.BundleProvider=h,h.__name__="BundleProvider",n.default_provider=new h},
function _(r,n,e,t,o){t();var a=r(1);e.load_module=function(r){return(0,a.__awaiter)(this,void 0,void 0,(function(){var n;return(0,a.__generator)(this,(function(e){switch(e.label){case 0:return e.trys.push([0,2,,3]),[4,r];case 1:return[2,e.sent()];case 2:if(n=e.sent(),(t=n)instanceof Error&&"code"in t&&"MODULE_NOT_FOUND"===n.code)return[2,null];throw n;case 3:return[2]}var t}))}))}},
function _(t,e,i,n,a){n();var o,r=t(1),_=t(248),l=t(235),s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,r.__extends)(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._has_finished=!0},e.prototype.graphics=function(){return new l.TextBox({text:this.model.text})},e}(_.BaseTextView);i.PlainTextView=s,s.__name__="PlainTextView";var u=function(t){function e(e){return t.call(this,e)||this}return(0,r.__extends)(e,t),e}(_.BaseText);i.PlainText=u,o=u,u.__name__="PlainText",o.prototype.default_view=s},
function _(t,e,r,o,i){o();var a,s=t(1),n=t(243),_=t(256),l=t(257),u=(0,s.__importStar)(t(163)),p=t(135),c=t(235),h=t(125),d=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,s.__extends)(e,t),e.prototype._paint=function(t,e,r){this._draw_group_separators(t,e,r)},e.prototype._draw_group_separators=function(t,e,r){var o,i=(0,s.__read)(this.ranges,1)[0],a=(0,s.__read)(this.computed_bounds,2),n=a[0],_=a[1];if(i.tops&&!(i.tops.length<2)&&this.visuals.separator_line.doit){for(var l=this.dimension,u=(l+1)%2,p=[[],[]],c=0,h=0;h<i.tops.length-1;h++){for(var d=void 0,m=void 0,f=c;f<i.factors.length;f++)if(i.factors[f][0]==i.tops[h+1]){d=(o=(0,s.__read)([i.factors[f-1],i.factors[f]],2))[0],m=o[1],c=f;break}var g=(i.synthetic(d)+i.synthetic(m))/2;g>n&&g<_&&(p[l].push(g),p[u].push(this.loc))}var b=this.extents.tick_label;this._draw_ticks(t,p,-3,b-6,this.visuals.separator_line)}},e.prototype._draw_major_labels=function(t,e,r){for(var o=this._get_factor_info(),i=e.tick+this.model.major_label_standoff,a=0;a<o.length;a++){var n=(0,s.__read)(o[a],4),_=n[0],l=n[1],u=n[2],p=n[3];this._draw_oriented_labels(t,_,l,u,this.panel.side,i,p),i+=e.tick_labels[a]}},e.prototype._tick_label_extents=function(){var t,e,r=this._get_factor_info(),o=[];try{for(var i=(0,s.__values)(r),a=i.next();!a.done;a=i.next()){var n=(0,s.__read)(a.value,4),_=n[0],l=n[2],u=n[3],p=this._oriented_labels_extent(_,l,this.model.major_label_standoff,u);o.push(p)}}catch(e){t={error:e}}finally{try{a&&!a.done&&(e=i.return)&&e.call(i)}finally{if(t)throw t.error}}return o},e.prototype._get_factor_info=function(){var t=this,e=(0,s.__read)(this.ranges,1)[0],r=(0,s.__read)(this.computed_bounds,2),o=r[0],i=r[1],a=this.loc,n=this.model.ticker.get_ticks(o,i,e,a),_=this.tick_coords,l=[],u=function(t){return new c.GraphicsBoxes(t.map((function(t){return(0,h.isString)(t)?new c.TextBox({text:t}):t})))},p=function(e){return u(t.model.formatter.doFormat(e,t))};if(1==e.levels){var d=p(n.major);l.push([d,_.major,this.model.major_label_orientation,this.visuals.major_label_text])}else if(2==e.levels){d=p(n.major.map((function(t){return t[1]})));l.push([d,_.major,this.model.major_label_orientation,this.visuals.major_label_text]),l.push([u(n.tops),_.tops,this.model.group_label_orientation,this.visuals.group_text])}else if(3==e.levels){d=p(n.major.map((function(t){return t[2]})));var m=n.mids.map((function(t){return t[1]}));l.push([d,_.major,this.model.major_label_orientation,this.visuals.major_label_text]),l.push([u(m),_.mids,this.model.subgroup_label_orientation,this.visuals.subgroup_text]),l.push([u(n.tops),_.tops,this.model.group_label_orientation,this.visuals.group_text])}return l},Object.defineProperty(e.prototype,"tick_coords",{get:function(){var t=this,e=this.dimension,r=(e+1)%2,o=(0,s.__read)(this.ranges,1)[0],i=(0,s.__read)(this.computed_bounds,2),a=i[0],n=i[1],_=this.model.ticker.get_ticks(a,n,o,this.loc),l={major:[[],[]],mids:[[],[]],tops:[[],[]],minor:[[],[]]};return l.major[e]=_.major,l.major[r]=_.major.map((function(){return t.loc})),3==o.levels&&(l.mids[e]=_.mids,l.mids[r]=_.mids.map((function(){return t.loc}))),o.levels>1&&(l.tops[e]=_.tops,l.tops[r]=_.tops.map((function(){return t.loc}))),l},enumerable:!1,configurable:!0}),e}(n.AxisView);r.CategoricalAxisView=d,d.__name__="CategoricalAxisView";var m=function(t){function e(e){return t.call(this,e)||this}return(0,s.__extends)(e,t),e}(n.Axis);r.CategoricalAxis=m,a=m,m.__name__="CategoricalAxis",a.prototype.default_view=d,a.mixins([["separator_",u.Line],["group_",u.Text],["subgroup_",u.Text]]),a.define((function(t){var e=t.Number,r=t.Or;return{group_label_orientation:[r(p.TickLabelOrientation,e),"parallel"],subgroup_label_orientation:[r(p.TickLabelOrientation,e),"parallel"]}})),a.override({ticker:function(){return new _.CategoricalTicker},formatter:function(){return new l.CategoricalTickFormatter},separator_line_color:"lightgrey",separator_line_width:2,group_text_font_style:"bold",group_text_font_size:"11px",group_text_color:"grey",subgroup_text_font_style:"bold",subgroup_text_font_size:"11px"})},
function _(t,r,e,o,n){o();var c=t(1),i=function(t){function r(r){return t.call(this,r)||this}return(0,c.__extends)(r,t),r.prototype.get_ticks=function(t,r,e,o){var n,c;return{major:this._collect(e.factors,e,t,r),minor:[],tops:this._collect(null!==(n=e.tops)&&void 0!==n?n:[],e,t,r),mids:this._collect(null!==(c=e.mids)&&void 0!==c?c:[],e,t,r)}},r.prototype._collect=function(t,r,e,o){var n,i,l=[];try{for(var a=(0,c.__values)(t),s=a.next();!s.done;s=a.next()){var u=s.value,_=r.synthetic(u);_>e&&_<o&&l.push(u)}}catch(t){n={error:t}}finally{try{s&&!s.done&&(i=a.return)&&i.call(a)}finally{if(n)throw n.error}}return l},r}(t(245).Ticker);e.CategoricalTicker=i,i.__name__="CategoricalTicker"},
function _(t,r,o,n,e){n();var a=t(1),c=t(246),i=t(126),u=function(t){function r(r){return t.call(this,r)||this}return(0,a.__extends)(r,t),r.prototype.doFormat=function(t,r){return(0,i.copy)(t)},r}(c.TickFormatter);o.CategoricalTickFormatter=u,u.__name__="CategoricalTickFormatter"},
function _(n,i,t,u,s){u();var e=n(1),o=n(243),_=function(n){function i(){return null!==n&&n.apply(this,arguments)||this}return(0,e.__extends)(i,n),i}(o.AxisView);t.ContinuousAxisView=_,_.__name__="ContinuousAxisView";var r=function(n){function i(i){return n.call(this,i)||this}return(0,e.__extends)(i,n),i}(o.Axis);t.ContinuousAxis=r,r.__name__="ContinuousAxis"},
function _(e,t,i,n,r){n();var a,u=e(1),_=e(260),o=e(265),s=e(270),c=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,u.__extends)(t,e),t}(_.LinearAxisView);i.DatetimeAxisView=c,c.__name__="DatetimeAxisView";var m=function(e){function t(t){return e.call(this,t)||this}return(0,u.__extends)(t,e),t}(_.LinearAxis);i.DatetimeAxis=m,a=m,m.__name__="DatetimeAxis",a.prototype.default_view=c,a.override({ticker:function(){return new s.DatetimeTicker},formatter:function(){return new o.DatetimeTickFormatter}})},
function _(n,i,e,t,r){t();var u,o=n(1),s=n(258),a=n(261),_=n(262),c=function(n){function i(){return null!==n&&n.apply(this,arguments)||this}return(0,o.__extends)(i,n),i}(s.ContinuousAxisView);e.LinearAxisView=c,c.__name__="LinearAxisView";var f=function(n){function i(i){return n.call(this,i)||this}return(0,o.__extends)(i,n),i}(s.ContinuousAxis);e.LinearAxis=f,u=f,f.__name__="LinearAxis",u.prototype.default_view=c,u.override({ticker:function(){return new _.BasicTicker},formatter:function(){return new a.BasicTickFormatter}})},
function _(t,i,r,e,n){e();var o,a=t(1),c=t(246),s=t(149);function _(t){var i,r,e="";try{for(var n=(0,a.__values)(t),o=n.next();!o.done;o=n.next()){var c=o.value;e+="-"==c?"\u2212":c}}catch(t){i={error:t}}finally{try{o&&!o.done&&(r=n.return)&&r.call(n)}finally{if(i)throw i.error}}return e}r.unicode_replace=_;var l=function(t){function i(i){var r=t.call(this,i)||this;return r.last_precision=3,r}return(0,a.__extends)(i,t),Object.defineProperty(i.prototype,"scientific_limit_low",{get:function(){return Math.pow(10,this.power_limit_low)},enumerable:!1,configurable:!0}),Object.defineProperty(i.prototype,"scientific_limit_high",{get:function(){return Math.pow(10,this.power_limit_high)},enumerable:!1,configurable:!0}),i.prototype._need_sci=function(t){var i,r;if(!this.use_scientific)return!1;var e=this.scientific_limit_high,n=this.scientific_limit_low,o=t.length<2?0:Math.abs(t[1]-t[0])/1e4;try{for(var c=(0,a.__values)(t),s=c.next();!s.done;s=c.next()){var _=s.value,l=Math.abs(_);if(!(l<=o)&&(l>=e||l<=n))return!0}}catch(t){i={error:t}}finally{try{s&&!s.done&&(r=c.return)&&r.call(c)}finally{if(i)throw i.error}}return!1},i.prototype._format_with_precision=function(t,i,r){return i?t.map((function(t){return _(t.toExponential(r))})):t.map((function(t){return _((0,s.to_fixed)(t,r))}))},i.prototype._auto_precision=function(t,i){var r=new Array(t.length),e=this.last_precision<=15;t:for(var n=this.last_precision;e?n<=15:n>=1;e?n++:n--){if(i){r[0]=t[0].toExponential(n);for(var o=1;o<t.length;o++)if(r[o]==r[o-1])continue t;this.last_precision=n;break}r[0]=(0,s.to_fixed)(t[0],n);for(o=1;o<t.length;o++)if(r[o]=(0,s.to_fixed)(t[o],n),r[o]==r[o-1])continue t;this.last_precision=n;break}return this.last_precision},i.prototype.doFormat=function(t,i){if(0==t.length)return[];var r=this._need_sci(t),e="auto"==this.precision?this._auto_precision(t,r):this.precision;return this._format_with_precision(t,r,e)},i}(c.TickFormatter);r.BasicTickFormatter=l,o=l,l.__name__="BasicTickFormatter",o.define((function(t){var i=t.Boolean,r=t.Int,e=t.Auto;return{precision:[(0,t.Or)(r,e),"auto"],use_scientific:[i,!0],power_limit_high:[r,5],power_limit_low:[r,-3]}}))},
function _(i,n,c,e,t){e();var r=i(1),_=function(i){function n(n){return i.call(this,n)||this}return(0,r.__extends)(n,i),n}(i(263).AdaptiveTicker);c.BasicTicker=_,_.__name__="BasicTicker"},
function _(t,i,a,e,n){e();var r,s=t(1),_=t(264),l=t(126),o=t(117),h=function(t){function i(i){return t.call(this,i)||this}return(0,s.__extends)(i,t),i.prototype.get_min_interval=function(){return this.min_interval},i.prototype.get_max_interval=function(){var t;return null!==(t=this.max_interval)&&void 0!==t?t:1/0},i.prototype.initialize=function(){t.prototype.initialize.call(this);var i=(0,l.nth)(this.mantissas,-1)/this.base,a=(0,l.nth)(this.mantissas,0)*this.base;this.extended_mantissas=(0,s.__spreadArray)((0,s.__spreadArray)([i],(0,s.__read)(this.mantissas),!1),[a],!1),this.base_factor=0===this.get_min_interval()?1:this.get_min_interval()},i.prototype.get_interval=function(t,i,a){var e=i-t,n=this.get_ideal_interval(t,i,a),r=Math.floor((0,o.log)(n/this.base_factor,this.base)),s=Math.pow(this.base,r)*this.base_factor,_=this.extended_mantissas,h=_.map((function(t){return Math.abs(a-e/(t*s))})),u=_[(0,l.argmin)(h)]*s;return(0,o.clamp)(u,this.get_min_interval(),this.get_max_interval())},i}(_.ContinuousTicker);a.AdaptiveTicker=h,r=h,h.__name__="AdaptiveTicker",r.define((function(t){var i=t.Number,a=t.Array,e=t.Nullable;return{base:[i,10],mantissas:[a(i),[1,2,5]],min_interval:[i,0],max_interval:[e(i),null]}}))},
function _(r,t,n,e,i){e();var o,a=r(1),u=r(245),l=r(126),c=function(r){function t(t){return r.call(this,t)||this}return(0,a.__extends)(t,r),t.prototype.get_ticks=function(r,t,n,e){return this.get_ticks_no_defaults(r,t,e,this.desired_num_ticks)},t.prototype.get_ticks_no_defaults=function(r,t,n,e){var i,o,u,c,_,f,s=this.get_interval(r,t,e),v=Math.floor(r/s),h=Math.ceil(t/s),d=(isFinite(v)&&isFinite(h)?(0,l.range)(v,h+1):[]).map((function(r){return r*s})).filter((function(n){return r<=n&&n<=t})),y=this.num_minor_ticks,m=[];if(y>0&&d.length>0){var k=s/y,p=(0,l.range)(0,y).map((function(r){return r*k}));try{for(var g=(0,a.__values)(p.slice(1)),x=g.next();!x.done;x=g.next()){var w=x.value,T=d[0]-w;r<=T&&T<=t&&m.push(T)}}catch(r){i={error:r}}finally{try{x&&!x.done&&(o=g.return)&&o.call(g)}finally{if(i)throw i.error}}try{for(var C=(0,a.__values)(d),F=C.next();!F.done;F=C.next()){var M=F.value;try{for(var j=(_=void 0,(0,a.__values)(p)),I=j.next();!I.done;I=j.next()){w=I.value;r<=(T=M+w)&&T<=t&&m.push(T)}}catch(r){_={error:r}}finally{try{I&&!I.done&&(f=j.return)&&f.call(j)}finally{if(_)throw _.error}}}}catch(r){u={error:r}}finally{try{F&&!F.done&&(c=C.return)&&c.call(C)}finally{if(u)throw u.error}}}return{major:d,minor:m}},t.prototype.get_ideal_interval=function(r,t,n){return(t-r)/n},t}(u.Ticker);n.ContinuousTicker=c,o=c,c.__name__="ContinuousTicker",o.define((function(r){var t=r.Int;return{num_minor_ticks:[t,5],desired_num_ticks:[t,6]}}))},
function _(t,r,e,n,s){n();var i,o=t(1),a=(0,o.__importDefault)(t(266)),u=t(246),c=t(134),h=t(267),m=t(126),d=t(125);function l(t){return(0,a.default)(t,"%Y %m %d %H %M %S").split(/\s+/).map((function(t){return parseInt(t,10)}))}function f(t,r){if((0,d.isFunction)(r))return r(t);var e=(0,h.sprintf)("$1%06d",function(t){return Math.round(t/1e3%1*1e6)}(t));return-1==(r=r.replace(/((^|[^%])(%%)*)%f/,e)).indexOf("%")?r:(0,a.default)(t,r)}var _=["microseconds","milliseconds","seconds","minsec","minutes","hourmin","hours","days","months","years"],p=function(t){function r(r){var e=t.call(this,r)||this;return e.strip_leading_zeros=!0,e}return(0,o.__extends)(r,t),r.prototype.initialize=function(){t.prototype.initialize.call(this),this._update_width_formats()},r.prototype._update_width_formats=function(){var t=+(0,a.default)(new Date),r=function(r){var e=r.map((function(r){return f(t,r).length})),n=(0,m.sort_by)((0,m.zip)(e,r),(function(t){return(0,o.__read)(t,1)[0]}));return(0,m.unzip)(n)};this._width_formats={microseconds:r(this.microseconds),milliseconds:r(this.milliseconds),seconds:r(this.seconds),minsec:r(this.minsec),minutes:r(this.minutes),hourmin:r(this.hourmin),hours:r(this.hours),days:r(this.days),months:r(this.months),years:r(this.years)}},r.prototype._get_resolution_str=function(t,r){var e=1.1*t;switch(!1){case!(e<.001):return"microseconds";case!(e<1):return"milliseconds";case!(e<60):return r>=60?"minsec":"seconds";case!(e<3600):return r>=3600?"hourmin":"minutes";case!(e<86400):return"hours";case!(e<2678400):return"days";case!(e<31536e3):return"months";default:return"years"}},r.prototype.doFormat=function(t,r){var e,n,s,i;if(0==t.length)return[];var a=Math.abs(t[t.length-1]-t[0])/1e3,u=a/(t.length-1),h=this._get_resolution_str(u,a),m=(0,o.__read)(this._width_formats[h],2),d=(0,o.__read)(m[1],1)[0],p=[],y=_.indexOf(h),v={};try{for(var g=(0,o.__values)(_),w=g.next();!w.done;w=g.next()){v[w.value]=0}}catch(t){e={error:t}}finally{try{w&&!w.done&&(n=g.return)&&n.call(g)}finally{if(e)throw e.error}}v.seconds=5,v.minsec=4,v.minutes=4,v.hourmin=3,v.hours=3;try{for(var M=(0,o.__values)(t),x=M.next();!x.done;x=M.next()){var b=x.value,k=void 0,z=void 0;try{z=l(b),k=f(b,d)}catch(t){c.logger.warn("unable to format tick for timestamp value "+b),c.logger.warn(" - "+t),p.push("ERR");continue}for(var F=!1,S=y;0==z[v[_[S]]];){if((S+=1)==_.length)break;if(("minsec"==h||"hourmin"==h)&&!F){if("minsec"==h&&0==z[4]&&0!=z[5]||"hourmin"==h&&0==z[3]&&0!=z[4]){k=f(b,this._width_formats[_[y-1]][1][0]);break}F=!0}k=f(b,this._width_formats[_[S]][1][0])}if(this.strip_leading_zeros){var D=k.replace(/^0+/g,"");D!=k&&isNaN(parseInt(D))&&(D="0"+D),p.push(D)}else p.push(k)}}catch(t){s={error:t}}finally{try{x&&!x.done&&(i=M.return)&&i.call(M)}finally{if(s)throw s.error}}return p},r}(u.TickFormatter);e.DatetimeTickFormatter=p,i=p,p.__name__="DatetimeTickFormatter",i.define((function(t){var r=t.String,e=t.Array;return{microseconds:[e(r),["%fus"]],milliseconds:[e(r),["%3Nms","%S.%3Ns"]],seconds:[e(r),["%Ss"]],minsec:[e(r),[":%M:%S"]],minutes:[e(r),[":%M","%Mm"]],hourmin:[e(r),["%H:%M"]],hours:[e(r),["%Hh","%H:%M"]],days:[e(r),["%m/%d","%a%d"]],months:[e(r),["%m/%Y","%b %Y"]],years:[e(r),["%Y"]]}}))},
function _(e,t,n,r,o){!function(e){"object"==typeof t&&t.exports?t.exports=e():"function"==typeof define?define(e):this.tz=e()}((function(){function e(e,t,n){var r,o=t.day[1];do{r=new Date(Date.UTC(n,t.month,Math.abs(o++)))}while(t.day[0]<7&&r.getUTCDay()!=t.day[0]);return(r={clock:t.clock,sort:r.getTime(),rule:t,save:6e4*t.save,offset:e.offset})[r.clock]=r.sort+6e4*t.time,r.posix?r.wallclock=r[r.clock]+(e.offset+t.saved):r.posix=r[r.clock]-(e.offset+t.saved),r}function t(t,n,r){var o,a,u,i,l,s,c,f=t[t.zone],h=[],T=new Date(r).getUTCFullYear(),g=1;for(o=1,a=f.length;o<a&&!(f[o][n]<=r);o++);if((u=f[o]).rules){for(s=t[u.rules],c=T+1;c>=T-g;--c)for(o=0,a=s.length;o<a;o++)s[o].from<=c&&c<=s[o].to?h.push(e(u,s[o],c)):s[o].to<c&&1==g&&(g=c-s[o].to);for(h.sort((function(e,t){return e.sort-t.sort})),o=0,a=h.length;o<a;o++)r>=h[o][n]&&h[o][h[o].clock]>u[h[o].clock]&&(i=h[o])}return i&&((l=/^(.*)\/(.*)$/.exec(u.format))?i.abbrev=l[i.save?2:1]:i.abbrev=u.format.replace(/%s/,i.rule.letter)),i||u}function n(e,n){return"UTC"==e.zone?n:(e.entry=t(e,"posix",n),n+e.entry.offset+e.entry.save)}function r(e,n){return"UTC"==e.zone?n:(e.entry=r=t(e,"wallclock",n),0<(o=n-r.wallclock)&&o<r.save?null:n-r.offset-r.save);var r,o}function o(e,t,o){var a,i=+(o[1]+1),s=o[2]*i,c=u.indexOf(o[3].toLowerCase());if(c>9)t+=s*l[c-10];else{if(a=new Date(n(e,t)),c<7)for(;s;)a.setUTCDate(a.getUTCDate()+i),a.getUTCDay()==c&&(s-=i);else 7==c?a.setUTCFullYear(a.getUTCFullYear()+s):8==c?a.setUTCMonth(a.getUTCMonth()+s):a.setUTCDate(a.getUTCDate()+s);null==(t=r(e,a.getTime()))&&(t=r(e,a.getTime()+864e5*i)-864e5*i)}return t}var a={clock:function(){return+new Date},zone:"UTC",entry:{abbrev:"UTC",offset:0,save:0},UTC:1,z:function(e,t,n,r){var o,a,u=this.entry.offset+this.entry.save,i=Math.abs(u/1e3),l=[],s=3600;for(o=0;o<3;o++)l.push(("0"+Math.floor(i/s)).slice(-2)),i%=s,s/=60;return"^"!=n||u?("^"==n&&(r=3),3==r?(a=(a=l.join(":")).replace(/:00$/,""),"^"!=n&&(a=a.replace(/:00$/,""))):r?(a=l.slice(0,r+1).join(":"),"^"==n&&(a=a.replace(/:00$/,""))):a=l.slice(0,2).join(""),a=(a=(u<0?"-":"+")+a).replace(/([-+])(0)/,{_:" $1","-":"$1"}[n]||"$1$2")):"Z"},"%":function(e){return"%"},n:function(e){return"\n"},t:function(e){return"\t"},U:function(e){return s(e,0)},W:function(e){return s(e,1)},V:function(e){return c(e)[0]},G:function(e){return c(e)[1]},g:function(e){return c(e)[1]%100},j:function(e){return Math.floor((e.getTime()-Date.UTC(e.getUTCFullYear(),0))/864e5)+1},s:function(e){return Math.floor(e.getTime()/1e3)},C:function(e){return Math.floor(e.getUTCFullYear()/100)},N:function(e){return e.getTime()%1e3*1e6},m:function(e){return e.getUTCMonth()+1},Y:function(e){return e.getUTCFullYear()},y:function(e){return e.getUTCFullYear()%100},H:function(e){return e.getUTCHours()},M:function(e){return e.getUTCMinutes()},S:function(e){return e.getUTCSeconds()},e:function(e){return e.getUTCDate()},d:function(e){return e.getUTCDate()},u:function(e){return e.getUTCDay()||7},w:function(e){return e.getUTCDay()},l:function(e){return e.getUTCHours()%12||12},I:function(e){return e.getUTCHours()%12||12},k:function(e){return e.getUTCHours()},Z:function(e){return this.entry.abbrev},a:function(e){return this[this.locale].day.abbrev[e.getUTCDay()]},A:function(e){return this[this.locale].day.full[e.getUTCDay()]},h:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},b:function(e){return this[this.locale].month.abbrev[e.getUTCMonth()]},B:function(e){return this[this.locale].month.full[e.getUTCMonth()]},P:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)].toLowerCase()},p:function(e){return this[this.locale].meridiem[Math.floor(e.getUTCHours()/12)]},R:function(e,t){return this.convert([t,"%H:%M"])},T:function(e,t){return this.convert([t,"%H:%M:%S"])},D:function(e,t){return this.convert([t,"%m/%d/%y"])},F:function(e,t){return this.convert([t,"%Y-%m-%d"])},x:function(e,t){return this.convert([t,this[this.locale].date])},r:function(e,t){return this.convert([t,this[this.locale].time12||"%I:%M:%S"])},X:function(e,t){return this.convert([t,this[this.locale].time24])},c:function(e,t){return this.convert([t,this[this.locale].dateTime])},convert:function(e){if(!e.length)return"1.0.23";var t,a,u,l,s,c=Object.create(this),f=[];for(t=0;t<e.length;t++)if(l=e[t],Array.isArray(l))t||isNaN(l[1])?l.splice.apply(e,[t--,1].concat(l)):s=l;else if(isNaN(l)){if("string"==(u=typeof l))~l.indexOf("%")?c.format=l:t||"*"!=l?!t&&(u=/^(\d{4})-(\d{2})-(\d{2})(?:[T\s](\d{2}):(\d{2})(?::(\d{2})(?:\.(\d+))?)?(Z|(([+-])(\d{2}(:\d{2}){0,2})))?)?$/.exec(l))?((s=[]).push.apply(s,u.slice(1,8)),u[9]?(s.push(u[10]+1),s.push.apply(s,u[11].split(/:/))):u[8]&&s.push(1)):/^\w{2,3}_\w{2}$/.test(l)?c.locale=l:(u=i.exec(l))?f.push(u):c.zone=l:s=l;else if("function"==u){if(u=l.call(c))return u}else if(/^\w{2,3}_\w{2}$/.test(l.name))c[l.name]=l;else if(l.zones){for(u in l.zones)c[u]=l.zones[u];for(u in l.rules)c[u]=l.rules[u]}}else t||(s=l);if(c[c.locale]||delete c.locale,c[c.zone]||delete c.zone,null!=s){if("*"==s)s=c.clock();else if(Array.isArray(s)){for(u=[],a=!s[7],t=0;t<11;t++)u[t]=+(s[t]||0);--u[1],s=Date.UTC.apply(Date.UTC,u)+-u[7]*(36e5*u[8]+6e4*u[9]+1e3*u[10])}else s=Math.floor(s);if(!isNaN(s)){if(a&&(s=r(c,s)),null==s)return s;for(t=0,a=f.length;t<a;t++)s=o(c,s,f[t]);return c.format?(u=new Date(n(c,s)),c.format.replace(/%([-0_^]?)(:{0,3})(\d*)(.)/g,(function(e,t,n,r,o){var a,i,l="0";if(a=c[o]){for(e=String(a.call(c,u,s,t,n.length)),"_"==(t||a.style)&&(l=" "),i="-"==t?0:a.pad||0;e.length<i;)e=l+e;for(i="-"==t?0:r||a.pad;e.length<i;)e=l+e;"N"==o&&i<e.length&&(e=e.slice(0,i)),"^"==t&&(e=e.toUpperCase())}return e}))):s}}return function(){return c.convert(arguments)}},locale:"en_US",en_US:{date:"%m/%d/%Y",time24:"%I:%M:%S %p",time12:"%I:%M:%S %p",dateTime:"%a %d %b %Y %I:%M:%S %p %Z",meridiem:["AM","PM"],month:{abbrev:"Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec".split("|"),full:"January|February|March|April|May|June|July|August|September|October|November|December".split("|")},day:{abbrev:"Sun|Mon|Tue|Wed|Thu|Fri|Sat".split("|"),full:"Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday".split("|")}}},u="Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|year|month|day|hour|minute|second|millisecond",i=new RegExp("^\\s*([+-])(\\d+)\\s+("+u+")s?\\s*$","i"),l=[36e5,6e4,1e3,1];function s(e,t){var n,r,o;return r=new Date(Date.UTC(e.getUTCFullYear(),0)),n=Math.floor((e.getTime()-r.getTime())/864e5),r.getUTCDay()==t?o=0:8==(o=7-r.getUTCDay()+t)&&(o=1),n>=o?Math.floor((n-o)/7)+1:0}function c(e){var t,n,r;return n=e.getUTCFullYear(),t=new Date(Date.UTC(n,0)).getUTCDay(),(r=s(e,1)+(t>1&&t<=4?1:0))?53!=r||4==t||3==t&&29==new Date(n,1,29).getDate()?[r,e.getUTCFullYear()]:[1,e.getUTCFullYear()+1]:(n=e.getUTCFullYear()-1,[r=4==(t=new Date(Date.UTC(n,0)).getUTCDay())||3==t&&29==new Date(n,1,29).getDate()?53:52,e.getUTCFullYear()-1])}return u=u.toLowerCase().split("|"),"delmHMSUWVgCIky".replace(/./g,(function(e){a[e].pad=2})),a.N.pad=9,a.j.pad=3,a.k.style="_",a.l.style="_",a.e.style="_",function(){return a.convert(arguments)}}))},
function _(r,n,t,e,i){e();var u=r(1),a=(0,u.__importStar)(r(268)),f=r(269),o=(0,u.__importDefault)(r(266)),l=r(136),c=r(125);function s(r){for(var n=[],t=1;t<arguments.length;t++)n[t-1]=arguments[t];return f.sprintf.apply(void 0,(0,u.__spreadArray)([r],(0,u.__read)(n),!1))}function _(r,n,t){return(0,c.isNumber)(r)?s(function(){switch(!1){case Math.floor(r)!=r:return"%d";case!(Math.abs(r)>.1&&Math.abs(r)<1e3):return"%0.3f";default:return"%0.3e"}}(),r):""+r}function m(r,n,e){if(null==n)return _;if(null!=e&&r in e){var i=e[r];if((0,c.isString)(i)){if(i in t.DEFAULT_FORMATTERS)return t.DEFAULT_FORMATTERS[i];throw new Error("Unknown tooltip field formatter type '"+i+"'")}return function(r,n,t){return i.format(r,n,t)}}return t.DEFAULT_FORMATTERS.numeral}function d(r,n,t){var e=n.get_column(r);if(null==e)return null;if((0,c.isNumber)(t))return e[t];var i=e[t.index];return(0,c.isTypedArray)(i)||(0,c.isArray)(i)?(0,c.isArray)(i[0])?i[t.dim2][t.dim1]:i[t.flat_index]:i}function p(r,n,t,e){return"$"==r[0]?function(r,n){if(r in n)return n[r];throw new Error("Unknown special variable '$"+r+"'")}(r.substring(1),e):d(r.substring(1).replace(/[{}]/g,""),n,t)}t.FormatterType=(0,l.Enum)("numeral","printf","datetime"),t.DEFAULT_FORMATTERS={numeral:function(r,n,t){return a.format(r,n)},datetime:function(r,n,t){return(0,o.default)(r,n)},printf:function(r,n,t){return s(n,r)}},t.sprintf=s,t.basic_formatter=_,t.get_formatter=m,t._get_column_value=d,t.get_value=p,t.replace_placeholders=function(r,n,t,e,i,a){var f,o;if(void 0===i&&(i={}),(0,c.isString)(r)?(f=r,o=!1):(f=r.html,o=!0),f=(f=f.replace(/@\$name/g,(function(r){return"@{"+i.name+"}"}))).replace(/((?:\$\w+)|(?:@\w+)|(?:@{(?:[^{}]+)}))(?:{([^{}]+)})?/g,(function(r,u,f){var l=p(u,n,t,i);if(null==l)return a?a("???"):"???";if("safe"==f)return o=!0,""+l;var c=""+m(u,f,e)(l,f,i);return a?a(c):c})),o){var l=(new DOMParser).parseFromString(f,"text/html");return(0,u.__spreadArray)([],(0,u.__read)(l.body.childNodes),!1)}return f}},
function _(e,n,t,r,i){
/*!
     * numbro.js
     * version : 1.6.2
     * author : Företagsplatsen AB
     * license : MIT
     * http://www.foretagsplatsen.se
     */
var a,o={},l=o,u="en-US",c=null,s="0,0";void 0!==n&&n.exports;function f(e){this._value=e}function d(e){var n,t="";for(n=0;n<e;n++)t+="0";return t}function h(e,n,t,r){var i,a,o=Math.pow(10,n);return a=e.toFixed(0).search("e")>-1?function(e,n){var t,r,i,a;return t=(a=e.toString()).split("e")[0],i=a.split("e")[1],a=t.split(".")[0]+(r=t.split(".")[1]||"")+d(i-r.length),n>0&&(a+="."+d(n)),a}(e,n):(t(e*o)/o).toFixed(n),r&&(i=new RegExp("0{1,"+r+"}$"),a=a.replace(i,"")),a}function p(e,n,t){var r;return r=n.indexOf("$")>-1?function(e,n,t){var r,i,a=n,l=a.indexOf("$"),c=a.indexOf("("),s=a.indexOf("+"),f=a.indexOf("-"),d="",h="";-1===a.indexOf("$")?"infix"===o[u].currency.position?(h=o[u].currency.symbol,o[u].currency.spaceSeparated&&(h=" "+h+" ")):o[u].currency.spaceSeparated&&(d=" "):a.indexOf(" $")>-1?(d=" ",a=a.replace(" $","")):a.indexOf("$ ")>-1?(d=" ",a=a.replace("$ ","")):a=a.replace("$","");if(i=m(e,a,t,h),-1===n.indexOf("$"))switch(o[u].currency.position){case"postfix":i.indexOf(")")>-1?((i=i.split("")).splice(-1,0,d+o[u].currency.symbol),i=i.join("")):i=i+d+o[u].currency.symbol;break;case"infix":break;case"prefix":i.indexOf("(")>-1||i.indexOf("-")>-1?(i=i.split(""),r=Math.max(c,f)+1,i.splice(r,0,o[u].currency.symbol+d),i=i.join("")):i=o[u].currency.symbol+d+i;break;default:throw Error('Currency position should be among ["prefix", "infix", "postfix"]')}else l<=1?i.indexOf("(")>-1||i.indexOf("+")>-1||i.indexOf("-")>-1?(r=1,(l<c||l<s||l<f)&&(r=0),(i=i.split("")).splice(r,0,o[u].currency.symbol+d),i=i.join("")):i=o[u].currency.symbol+d+i:i.indexOf(")")>-1?((i=i.split("")).splice(-1,0,d+o[u].currency.symbol),i=i.join("")):i=i+d+o[u].currency.symbol;return i}(e,n,t):n.indexOf("%")>-1?function(e,n,t){var r,i="";e*=100,n.indexOf(" %")>-1?(i=" ",n=n.replace(" %","")):n=n.replace("%","");(r=m(e,n,t)).indexOf(")")>-1?((r=r.split("")).splice(-1,0,i+"%"),r=r.join("")):r=r+i+"%";return r}(e,n,t):n.indexOf(":")>-1?function(e){var n=Math.floor(e/60/60),t=Math.floor((e-60*n*60)/60),r=Math.round(e-60*n*60-60*t);return n+":"+(t<10?"0"+t:t)+":"+(r<10?"0"+r:r)}(e):m(e,n,t),r}function m(e,n,t,r){var i,a,l,s,f,d,p,m,x,g,O,b,w,y,M,v,$,B=!1,E=!1,F=!1,k="",U=!1,N=!1,S=!1,j=!1,D=!1,C="",L="",T=Math.abs(e),K=["B","KiB","MiB","GiB","TiB","PiB","EiB","ZiB","YiB"],G=["B","KB","MB","GB","TB","PB","EB","ZB","YB"],I="",P=!1,R=!1;if(0===e&&null!==c)return c;if(!isFinite(e))return""+e;if(0===n.indexOf("{")){var W=n.indexOf("}");if(-1===W)throw Error('Format should also contain a "}"');b=n.slice(1,W),n=n.slice(W+1)}else b="";if(n.indexOf("}")===n.length-1){var Y=n.indexOf("{");if(-1===Y)throw Error('Format should also contain a "{"');w=n.slice(Y+1,-1),n=n.slice(0,Y+1)}else w="";if(v=null===($=-1===n.indexOf(".")?n.match(/([0-9]+).*/):n.match(/([0-9]+)\..*/))?-1:$[1].length,-1!==n.indexOf("-")&&(P=!0),n.indexOf("(")>-1?(B=!0,n=n.slice(1,-1)):n.indexOf("+")>-1&&(E=!0,n=n.replace(/\+/g,"")),n.indexOf("a")>-1){if(g=n.split(".")[0].match(/[0-9]+/g)||["0"],g=parseInt(g[0],10),U=n.indexOf("aK")>=0,N=n.indexOf("aM")>=0,S=n.indexOf("aB")>=0,j=n.indexOf("aT")>=0,D=U||N||S||j,n.indexOf(" a")>-1?(k=" ",n=n.replace(" a","")):n=n.replace("a",""),p=0===(p=(f=Math.floor(Math.log(T)/Math.LN10)+1)%3)?3:p,g&&0!==T&&(d=Math.floor(Math.log(T)/Math.LN10)+1-g,m=3*~~((Math.min(g,f)-p)/3),T/=Math.pow(10,m),-1===n.indexOf(".")&&g>3))for(n+="[.]",M=(M=0===d?0:3*~~(d/3)-d)<0?M+3:M,i=0;i<M;i++)n+="0";Math.floor(Math.log(Math.abs(e))/Math.LN10)+1!==g&&(T>=Math.pow(10,12)&&!D||j?(k+=o[u].abbreviations.trillion,e/=Math.pow(10,12)):T<Math.pow(10,12)&&T>=Math.pow(10,9)&&!D||S?(k+=o[u].abbreviations.billion,e/=Math.pow(10,9)):T<Math.pow(10,9)&&T>=Math.pow(10,6)&&!D||N?(k+=o[u].abbreviations.million,e/=Math.pow(10,6)):(T<Math.pow(10,6)&&T>=Math.pow(10,3)&&!D||U)&&(k+=o[u].abbreviations.thousand,e/=Math.pow(10,3)))}if(n.indexOf("b")>-1)for(n.indexOf(" b")>-1?(C=" ",n=n.replace(" b","")):n=n.replace("b",""),s=0;s<=K.length;s++)if(a=Math.pow(1024,s),l=Math.pow(1024,s+1),e>=a&&e<l){C+=K[s],a>0&&(e/=a);break}if(n.indexOf("d")>-1)for(n.indexOf(" d")>-1?(C=" ",n=n.replace(" d","")):n=n.replace("d",""),s=0;s<=G.length;s++)if(a=Math.pow(1e3,s),l=Math.pow(1e3,s+1),e>=a&&e<l){C+=G[s],a>0&&(e/=a);break}if(n.indexOf("o")>-1&&(n.indexOf(" o")>-1?(L=" ",n=n.replace(" o","")):n=n.replace("o",""),o[u].ordinal&&(L+=o[u].ordinal(e))),n.indexOf("[.]")>-1&&(F=!0,n=n.replace("[.]",".")),x=e.toString().split(".")[0],O=n.split(".")[1],y=n.indexOf(","),O){if(x=(I=-1!==O.indexOf("*")?h(e,e.toString().split(".")[1].length,t):O.indexOf("[")>-1?h(e,(O=(O=O.replace("]","")).split("["))[0].length+O[1].length,t,O[1].length):h(e,O.length,t)).split(".")[0],I.split(".")[1].length)I=(r?k+r:o[u].delimiters.decimal)+I.split(".")[1];else I="";F&&0===Number(I.slice(1))&&(I="")}else x=h(e,null,t);return x.indexOf("-")>-1&&(x=x.slice(1),R=!0),x.length<v&&(x=new Array(v-x.length+1).join("0")+x),y>-1&&(x=x.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g,"$1"+o[u].delimiters.thousands)),0===n.indexOf(".")&&(x=""),b+(n.indexOf("(")<n.indexOf("-")?(B&&R?"(":"")+(P&&R||!B&&R?"-":""):(P&&R||!B&&R?"-":"")+(B&&R?"(":""))+(!R&&E&&0!==e?"+":"")+x+I+(L||"")+(k&&!r?k:"")+(C||"")+(B&&R?")":"")+w}function x(e,n){o[e]=n}function g(e){u=e;var n=o[e].defaults;n&&n.format&&a.defaultFormat(n.format),n&&n.currencyFormat&&a.defaultCurrencyFormat(n.currencyFormat)}(a=function(e){return a.isNumbro(e)?e=e.value():0===e||void 0===e?e=0:Number(e)||(e=a.fn.unformat(e)),new f(Number(e))}).version="1.6.2",a.isNumbro=function(e){return e instanceof f},a.setLanguage=function(e,n){console.warn("`setLanguage` is deprecated since version 1.6.0. Use `setCulture` instead");var t=e,r=e.split("-")[0],i=null;l[t]||(Object.keys(l).forEach((function(e){i||e.split("-")[0]!==r||(i=e)})),t=i||n||"en-US"),g(t)},a.setCulture=function(e,n){var t=e,r=e.split("-")[1],i=null;o[t]||(r&&Object.keys(o).forEach((function(e){i||e.split("-")[1]!==r||(i=e)})),t=i||n||"en-US"),g(t)},a.language=function(e,n){if(console.warn("`language` is deprecated since version 1.6.0. Use `culture` instead"),!e)return u;if(e&&!n){if(!l[e])throw new Error("Unknown language : "+e);g(e)}return!n&&l[e]||x(e,n),a},a.culture=function(e,n){if(!e)return u;if(e&&!n){if(!o[e])throw new Error("Unknown culture : "+e);g(e)}return!n&&o[e]||x(e,n),a},a.languageData=function(e){if(console.warn("`languageData` is deprecated since version 1.6.0. Use `cultureData` instead"),!e)return l[u];if(!l[e])throw new Error("Unknown language : "+e);return l[e]},a.cultureData=function(e){if(!e)return o[u];if(!o[e])throw new Error("Unknown culture : "+e);return o[e]},a.culture("en-US",{delimiters:{thousands:",",decimal:"."},abbreviations:{thousand:"k",million:"m",billion:"b",trillion:"t"},ordinal:function(e){var n=e%10;return 1==~~(e%100/10)?"th":1===n?"st":2===n?"nd":3===n?"rd":"th"},currency:{symbol:"$",position:"prefix"},defaults:{currencyFormat:",0000 a"},formats:{fourDigits:"0000 a",fullWithTwoDecimals:"$ ,0.00",fullWithTwoDecimalsNoCurrency:",0.00"}}),a.languages=function(){return console.warn("`languages` is deprecated since version 1.6.0. Use `cultures` instead"),l},a.cultures=function(){return o},a.zeroFormat=function(e){c="string"==typeof e?e:null},a.defaultFormat=function(e){s="string"==typeof e?e:"0.0"},a.defaultCurrencyFormat=function(e){"string"==typeof e?e:"0$"},a.validate=function(e,n){var t,r,i,o,l,u,c,s;if("string"!=typeof e&&(e+="",console.warn&&console.warn("Numbro.js: Value is not string. It has been co-erced to: ",e)),(e=e.trim()).match(/^\d+$/))return!0;if(""===e)return!1;try{c=a.cultureData(n)}catch(e){c=a.cultureData(a.culture())}return i=c.currency.symbol,l=c.abbreviations,t=c.delimiters.decimal,r="."===c.delimiters.thousands?"\\.":c.delimiters.thousands,(null===(s=e.match(/^[^\d]+/))||(e=e.substr(1),s[0]===i))&&((null===(s=e.match(/[^\d]+$/))||(e=e.slice(0,-1),s[0]===l.thousand||s[0]===l.million||s[0]===l.billion||s[0]===l.trillion))&&(u=new RegExp(r+"{2}"),!e.match(/[^\d.,]/g)&&(!((o=e.split(t)).length>2)&&(o.length<2?!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u):1===o[0].length?!!o[0].match(/^\d+$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/):!!o[0].match(/^\d+.*\d$/)&&!o[0].match(u)&&!!o[1].match(/^\d+$/)))))},n.exports={format:function(e,n,t,r){return null!=t&&t!==a.culture()&&a.setCulture(t),p(Number(e),null!=n?n:s,null==r?Math.round:r)}}},
function _(e,n,t,r,i){!function(){"use strict";var e={not_string:/[^s]/,not_bool:/[^t]/,not_type:/[^T]/,not_primitive:/[^v]/,number:/[diefg]/,numeric_arg:/[bcdiefguxX]/,json:/[j]/,not_json:/[^j]/,text:/^[^\x25]+/,modulo:/^\x25{2}/,placeholder:/^\x25(?:([1-9]\d*)\$|\(([^)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijostTuvxX])/,key:/^([a-z_][a-z_\d]*)/i,key_access:/^\.([a-z_][a-z_\d]*)/i,index_access:/^\[(\d+)\]/,sign:/^[+-]/};function n(e){return i(a(e),arguments)}function r(e,t){return n.apply(null,[e].concat(t||[]))}function i(t,r){var i,s,a,o,p,c,l,u,f,d=1,g=t.length,y="";for(s=0;s<g;s++)if("string"==typeof t[s])y+=t[s];else if("object"==typeof t[s]){if((o=t[s]).keys)for(i=r[d],a=0;a<o.keys.length;a++){if(null==i)throw new Error(n('[sprintf] Cannot access property "%s" of undefined value "%s"',o.keys[a],o.keys[a-1]));i=i[o.keys[a]]}else i=o.param_no?r[o.param_no]:r[d++];if(e.not_type.test(o.type)&&e.not_primitive.test(o.type)&&i instanceof Function&&(i=i()),e.numeric_arg.test(o.type)&&"number"!=typeof i&&isNaN(i))throw new TypeError(n("[sprintf] expecting number but found %T",i));switch(e.number.test(o.type)&&(u=i>=0),o.type){case"b":i=parseInt(i,10).toString(2);break;case"c":i=String.fromCharCode(parseInt(i,10));break;case"d":case"i":i=parseInt(i,10);break;case"j":i=JSON.stringify(i,null,o.width?parseInt(o.width):0);break;case"e":i=o.precision?parseFloat(i).toExponential(o.precision):parseFloat(i).toExponential();break;case"f":i=o.precision?parseFloat(i).toFixed(o.precision):parseFloat(i);break;case"g":i=o.precision?String(Number(i.toPrecision(o.precision))):parseFloat(i);break;case"o":i=(parseInt(i,10)>>>0).toString(8);break;case"s":i=String(i),i=o.precision?i.substring(0,o.precision):i;break;case"t":i=String(!!i),i=o.precision?i.substring(0,o.precision):i;break;case"T":i=Object.prototype.toString.call(i).slice(8,-1).toLowerCase(),i=o.precision?i.substring(0,o.precision):i;break;case"u":i=parseInt(i,10)>>>0;break;case"v":i=i.valueOf(),i=o.precision?i.substring(0,o.precision):i;break;case"x":i=(parseInt(i,10)>>>0).toString(16);break;case"X":i=(parseInt(i,10)>>>0).toString(16).toUpperCase()}e.json.test(o.type)?y+=i:(!e.number.test(o.type)||u&&!o.sign?f="":(f=u?"+":"-",i=i.toString().replace(e.sign,"")),c=o.pad_char?"0"===o.pad_char?"0":o.pad_char.charAt(1):" ",l=o.width-(f+i).length,p=o.width&&l>0?c.repeat(l):"",y+=o.align?f+i+p:"0"===c?f+p+i:p+f+i)}return y}var s=Object.create(null);function a(n){if(s[n])return s[n];for(var t,r=n,i=[],a=0;r;){if(null!==(t=e.text.exec(r)))i.push(t[0]);else if(null!==(t=e.modulo.exec(r)))i.push("%");else{if(null===(t=e.placeholder.exec(r)))throw new SyntaxError("[sprintf] unexpected placeholder");if(t[2]){a|=1;var o=[],p=t[2],c=[];if(null===(c=e.key.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");for(o.push(c[1]);""!==(p=p.substring(c[0].length));)if(null!==(c=e.key_access.exec(p)))o.push(c[1]);else{if(null===(c=e.index_access.exec(p)))throw new SyntaxError("[sprintf] failed to parse named argument key");o.push(c[1])}t[2]=o}else a|=2;if(3===a)throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");i.push({placeholder:t[0],param_no:t[1],keys:t[2],sign:t[3],pad_char:t[4],align:t[5],width:t[6],precision:t[7],type:t[8]})}r=r.substring(t[0].length)}return s[n]=i}void 0!==t&&(t.sprintf=n,t.vsprintf=r),"undefined"!=typeof window&&(window.sprintf=n,window.vsprintf=r,"function"==typeof define&&define.amd&&define((function(){return{sprintf:n,vsprintf:r}})))}()},
function _(e,n,i,r,a){r();var t,s=e(1),_=e(126),c=e(263),m=e(271),k=e(272),o=e(275),T=e(276),w=e(274),u=function(e){function n(n){return e.call(this,n)||this}return(0,s.__extends)(n,e),n}(m.CompositeTicker);i.DatetimeTicker=u,t=u,u.__name__="DatetimeTicker",t.override({num_minor_ticks:0,tickers:function(){return[new c.AdaptiveTicker({mantissas:[1,2,5],base:10,min_interval:0,max_interval:500*w.ONE_MILLI,num_minor_ticks:0}),new c.AdaptiveTicker({mantissas:[1,2,5,10,15,20,30],base:60,min_interval:w.ONE_SECOND,max_interval:30*w.ONE_MINUTE,num_minor_ticks:0}),new c.AdaptiveTicker({mantissas:[1,2,4,6,8,12],base:24,min_interval:w.ONE_HOUR,max_interval:12*w.ONE_HOUR,num_minor_ticks:0}),new k.DaysTicker({days:(0,_.range)(1,32)}),new k.DaysTicker({days:(0,_.range)(1,31,3)}),new k.DaysTicker({days:[1,8,15,22]}),new k.DaysTicker({days:[1,15]}),new o.MonthsTicker({months:(0,_.range)(0,12,1)}),new o.MonthsTicker({months:(0,_.range)(0,12,2)}),new o.MonthsTicker({months:(0,_.range)(0,12,4)}),new o.MonthsTicker({months:(0,_.range)(0,12,6)}),new T.YearsTicker({})]}})},
function _(t,e,n,i,r){i();var s,o=t(1),_=t(264),a=t(126),u=function(t){function e(e){return t.call(this,e)||this}return(0,o.__extends)(e,t),Object.defineProperty(e.prototype,"min_intervals",{get:function(){return this.tickers.map((function(t){return t.get_min_interval()}))},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"max_intervals",{get:function(){return this.tickers.map((function(t){return t.get_max_interval()}))},enumerable:!1,configurable:!0}),e.prototype.get_min_interval=function(){return this.min_intervals[0]},e.prototype.get_max_interval=function(){return this.max_intervals[0]},e.prototype.get_best_ticker=function(t,e,n){var i,r=e-t,s=this.get_ideal_interval(t,e,n),o=[(0,a.sorted_index)(this.min_intervals,s)-1,(0,a.sorted_index)(this.max_intervals,s)],_=[this.min_intervals[o[0]],this.max_intervals[o[1]]].map((function(t){return Math.abs(n-r/t)}));if((0,a.is_empty)(_.filter((function(t){return!isNaN(t)}))))i=this.tickers[0];else{var u=o[(0,a.argmin)(_)];i=this.tickers[u]}return i},e.prototype.get_interval=function(t,e,n){return this.get_best_ticker(t,e,n).get_interval(t,e,n)},e.prototype.get_ticks_no_defaults=function(t,e,n,i){return this.get_best_ticker(t,e,i).get_ticks_no_defaults(t,e,n,i)},e}(_.ContinuousTicker);n.CompositeTicker=u,s=u,u.__name__="CompositeTicker",s.define((function(t){return{tickers:[(0,t.Array)((0,t.Ref)(_.ContinuousTicker)),[]]}}))},
function _(t,n,e,r,a){r();var i,o=t(1),u=t(273),l=t(274),_=t(126);var c=function(t){function n(n){return t.call(this,n)||this}return(0,o.__extends)(n,t),n.prototype.initialize=function(){t.prototype.initialize.call(this);var n=this.days;n.length>1?this.interval=(n[1]-n[0])*l.ONE_DAY:this.interval=31*l.ONE_DAY},n.prototype.get_ticks_no_defaults=function(t,n,e,r){var a=function(t,n){var e=(0,l.last_month_no_later_than)(new Date(t)),r=(0,l.last_month_no_later_than)(new Date(n));r.setUTCMonth(r.getUTCMonth()+1);for(var a=[],i=e;a.push((0,l.copy_date)(i)),i.setUTCMonth(i.getUTCMonth()+1),!(i>r););return a}(t,n),i=this.days,u=this.interval,c=(0,_.concat)(a.map((function(t){return function(t,n){var e,r,a=t.getUTCMonth(),u=[];try{for(var _=(0,o.__values)(i),c=_.next();!c.done;c=_.next()){var s=c.value,h=(0,l.copy_date)(t);h.setUTCDate(s),new Date(h.getTime()+n/2).getUTCMonth()==a&&u.push(h)}}catch(t){e={error:t}}finally{try{c&&!c.done&&(r=_.return)&&r.call(_)}finally{if(e)throw e.error}}return u}(t,u)})));return{major:c.map((function(t){return t.getTime()})).filter((function(e){return t<=e&&e<=n})),minor:[]}},n}(u.SingleIntervalTicker);e.DaysTicker=c,i=c,c.__name__="DaysTicker",i.define((function(t){var n=t.Int;return{days:[(0,t.Array)(n),[]]}})),i.override({num_minor_ticks:0})},
function _(t,n,e,r,i){r();var u,o=t(1),a=function(t){function n(n){return t.call(this,n)||this}return(0,o.__extends)(n,t),n.prototype.get_interval=function(t,n,e){return this.interval},n.prototype.get_min_interval=function(){return this.interval},n.prototype.get_max_interval=function(){return this.interval},n}(t(264).ContinuousTicker);e.SingleIntervalTicker=a,u=a,a.__name__="SingleIntervalTicker",u.define((function(t){return{interval:[t.Number]}}))},
function _(t,e,_,n,E){function N(t){return new Date(t.getTime())}function O(t){var e=N(t);return e.setUTCDate(1),e.setUTCHours(0),e.setUTCMinutes(0),e.setUTCSeconds(0),e.setUTCMilliseconds(0),e}n(),_.ONE_MILLI=1,_.ONE_SECOND=1e3,_.ONE_MINUTE=60*_.ONE_SECOND,_.ONE_HOUR=60*_.ONE_MINUTE,_.ONE_DAY=24*_.ONE_HOUR,_.ONE_MONTH=30*_.ONE_DAY,_.ONE_YEAR=365*_.ONE_DAY,_.copy_date=N,_.last_month_no_later_than=O,_.last_year_no_later_than=function(t){var e=O(t);return e.setUTCMonth(0),e}},
function _(t,n,e,r,a){r();var i,o=t(1),u=t(273),l=t(274),_=t(126);var c=function(t){function n(n){return t.call(this,n)||this}return(0,o.__extends)(n,t),n.prototype.initialize=function(){t.prototype.initialize.call(this);var n=this.months;n.length>1?this.interval=(n[1]-n[0])*l.ONE_MONTH:this.interval=12*l.ONE_MONTH},n.prototype.get_ticks_no_defaults=function(t,n,e,r){var a=function(t,n){var e=(0,l.last_year_no_later_than)(new Date(t)),r=(0,l.last_year_no_later_than)(new Date(n));r.setUTCFullYear(r.getUTCFullYear()+1);for(var a=[],i=e;a.push((0,l.copy_date)(i)),i.setUTCFullYear(i.getUTCFullYear()+1),!(i>r););return a}(t,n),i=this.months;return{major:(0,_.concat)(a.map((function(t){return i.map((function(n){var e=(0,l.copy_date)(t);return e.setUTCMonth(n),e}))}))).map((function(t){return t.getTime()})).filter((function(e){return t<=e&&e<=n})),minor:[]}},n}(u.SingleIntervalTicker);e.MonthsTicker=c,i=c,c.__name__="MonthsTicker",i.define((function(t){var n=t.Int;return{months:[(0,t.Array)(n),[]]}}))},
function _(t,e,i,n,r){n();var a=t(1),_=t(262),c=t(273),o=t(274),l=function(t){function e(e){return t.call(this,e)||this}return(0,a.__extends)(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.interval=o.ONE_YEAR,this.basic_ticker=new _.BasicTicker({num_minor_ticks:0})},e.prototype.get_ticks_no_defaults=function(t,e,i,n){var r=(0,o.last_year_no_later_than)(new Date(t)).getUTCFullYear(),a=(0,o.last_year_no_later_than)(new Date(e)).getUTCFullYear();return{major:this.basic_ticker.get_ticks_no_defaults(r,a,i,n).major.map((function(t){return Date.UTC(t,0,1)})).filter((function(i){return t<=i&&i<=e})),minor:[]}},e}(c.SingleIntervalTicker);i.YearsTicker=l,l.__name__="YearsTicker"},
function _(n,t,i,e,r){e();var o,u=n(1),s=n(258),_=n(278),c=n(279),a=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return(0,u.__extends)(t,n),t}(s.ContinuousAxisView);i.LogAxisView=a,a.__name__="LogAxisView";var f=function(n){function t(t){return n.call(this,t)||this}return(0,u.__extends)(t,n),t}(s.ContinuousAxis);i.LogAxis=f,o=f,f.__name__="LogAxis",o.prototype.default_view=a,o.override({ticker:function(){return new c.LogTicker},formatter:function(){return new _.LogTickFormatter}})},
function _(t,e,n,r,o){r();var i,a=t(1),l=t(246),u=t(261),c=t(279),p=t(235),s=Math.abs,f=Math.log,_=Math.round,h=function(t){function e(e){return t.call(this,e)||this}return(0,a.__extends)(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.basic_formatter=new u.BasicTickFormatter},e.prototype.format_graphics=function(t,e){var n,r,o=this;if(0==t.length)return[];var i=null!==(r=null===(n=this.ticker)||void 0===n?void 0:n.base)&&void 0!==r?r:10,a=this._exponents(t,i);return null==a?this.basic_formatter.format_graphics(t,e):a.map((function(t){if(s(t)<o.min_exponent){var e=new p.TextBox({text:(0,u.unicode_replace)(""+Math.pow(i,t))}),n=new p.TextBox({text:""});return new p.BaseExpo(e,n)}e=new p.TextBox({text:(0,u.unicode_replace)(""+i)}),n=new p.TextBox({text:(0,u.unicode_replace)(""+t)});return new p.BaseExpo(e,n)}))},e.prototype._exponents=function(t,e){var n,r,o=null,i=[];try{for(var l=(0,a.__values)(t),u=l.next();!u.done;u=l.next()){var c=u.value,p=_(f(c)/f(e));if(o==p)return null;o=p,i.push(p)}}catch(t){n={error:t}}finally{try{u&&!u.done&&(r=l.return)&&r.call(l)}finally{if(n)throw n.error}}return i},e.prototype.doFormat=function(t,e){var n,r,o=this;if(0==t.length)return[];var i=null!==(r=null===(n=this.ticker)||void 0===n?void 0:n.base)&&void 0!==r?r:10,a=this._exponents(t,i);return null==a?this.basic_formatter.doFormat(t,e):a.map((function(t){return s(t)<o.min_exponent?(0,u.unicode_replace)(""+Math.pow(i,t)):(0,u.unicode_replace)(i+"^"+t)}))},e}(l.TickFormatter);n.LogTickFormatter=h,i=h,h.__name__="LogTickFormatter",i.define((function(t){var e=t.Int,n=t.Ref;return{ticker:[(0,t.Nullable)(n(c.LogTicker)),null],min_exponent:[e,0]}}))},
function _(r,e,t,n,a){n();var l,o=r(1),i=r(263),u=r(126),f=function(r){function e(e){return r.call(this,e)||this}return(0,o.__extends)(e,r),e.prototype.get_ticks_no_defaults=function(r,e,t,n){var a,l,i,f,c,h,v,s,y,_,d,g,p,x=this.num_minor_ticks,M=[],m=this.base,w=Math.log(r)/Math.log(m),k=Math.log(e)/Math.log(m),T=k-w;if(isFinite(T))if(T<2){var L=this.get_interval(r,e,n),b=Math.floor(r/L),j=Math.ceil(e/L);if(p=(0,u.range)(b,j+1).filter((function(r){return 0!=r})).map((function(r){return r*L})).filter((function(t){return r<=t&&t<=e})),x>0&&p.length>0){var A=L/x,F=(0,u.range)(0,x).map((function(r){return r*A}));try{for(var q=(0,o.__values)(F.slice(1)),z=q.next();!z.done;z=q.next()){var B=z.value;M.push(p[0]-B)}}catch(r){a={error:r}}finally{try{z&&!z.done&&(l=q.return)&&l.call(q)}finally{if(a)throw a.error}}try{for(var C=(0,o.__values)(p),D=C.next();!D.done;D=C.next()){var E=D.value;try{for(var G=(c=void 0,(0,o.__values)(F)),H=G.next();!H.done;H=G.next()){B=H.value;M.push(E+B)}}catch(r){c={error:r}}finally{try{H&&!H.done&&(h=G.return)&&h.call(G)}finally{if(c)throw c.error}}}}catch(r){i={error:r}}finally{try{D&&!D.done&&(f=C.return)&&f.call(C)}finally{if(i)throw i.error}}}}else{var I=Math.ceil(.999999*w),J=Math.floor(1.000001*k),K=Math.ceil((J-I)/9);if(p=(0,u.range)(I-1,J+1,K).map((function(r){return Math.pow(m,r)})),x>0&&p.length>0){var N=Math.pow(m,K)/x;F=(0,u.range)(1,x+1).map((function(r){return r*N}));try{for(var O=(0,o.__values)(F),P=O.next();!P.done;P=O.next()){B=P.value;M.push(p[0]/B)}}catch(r){v={error:r}}finally{try{P&&!P.done&&(s=O.return)&&s.call(O)}finally{if(v)throw v.error}}M.push(p[0]);try{for(var Q=(0,o.__values)(p),R=Q.next();!R.done;R=Q.next()){E=R.value;try{for(var S=(d=void 0,(0,o.__values)(F)),U=S.next();!U.done;U=S.next()){B=U.value;M.push(E*B)}}catch(r){d={error:r}}finally{try{U&&!U.done&&(g=S.return)&&g.call(S)}finally{if(d)throw d.error}}}}catch(r){y={error:r}}finally{try{R&&!R.done&&(_=Q.return)&&_.call(Q)}finally{if(y)throw y.error}}}}else p=[];return{major:p.filter((function(t){return r<=t&&t<=e})),minor:M.filter((function(t){return r<=t&&t<=e}))}},e}(i.AdaptiveTicker);t.LogTicker=f,l=f,f.__name__="LogTicker",l.override({mantissas:[1,5]})},
function _(r,e,t,n,i){n();var o,a=r(1),c=r(243),u=r(260),s=r(281),_=r(282),f=function(r){function e(){return null!==r&&r.apply(this,arguments)||this}return(0,a.__extends)(e,r),e}(c.AxisView);t.MercatorAxisView=f,f.__name__="MercatorAxisView";var l=function(r){function e(e){return r.call(this,e)||this}return(0,a.__extends)(e,r),e}(u.LinearAxis);t.MercatorAxis=l,o=l,l.__name__="MercatorAxis",o.prototype.default_view=f,o.override({ticker:function(){return new _.MercatorTicker({dimension:"lat"})},formatter:function(){return new s.MercatorTickFormatter({dimension:"lat"})}})},
function _(r,t,n,e,o){e();var i,a=r(1),c=r(261),l=r(135),s=r(193),u=function(r){function t(t){return r.call(this,t)||this}return(0,a.__extends)(t,r),t.prototype.doFormat=function(t,n){if(null==this.dimension)throw new Error("MercatorTickFormatter.dimension not configured");if(0==t.length)return[];var e=t.length,o=new Array(e);if("lon"==this.dimension)for(var i=0;i<e;i++){var c=(0,a.__read)(s.wgs84_mercator.invert(t[i],n.loc),1)[0];o[i]=c}else for(i=0;i<e;i++){var l=(0,a.__read)(s.wgs84_mercator.invert(n.loc,t[i]),2)[1];o[i]=l}return r.prototype.doFormat.call(this,o,n)},t}(c.BasicTickFormatter);n.MercatorTickFormatter=u,i=u,u.__name__="MercatorTickFormatter",i.define((function(r){return{dimension:[(0,r.Nullable)(l.LatLon),null]}}))},
function _(r,t,e,n,o){n();var a,i=r(1),_=r(262),l=r(135),c=r(193),s=function(r){function t(t){return r.call(this,t)||this}return(0,i.__extends)(t,r),t.prototype.get_ticks_no_defaults=function(r,t,e,n){var o;if(null==this.dimension)throw new Error(this+".dimension wasn't configured");return r=(o=(0,i.__read)((0,c.clip_mercator)(r,t,this.dimension),2))[0],t=o[1],"lon"==this.dimension?this._get_ticks_lon(r,t,e,n):this._get_ticks_lat(r,t,e,n)},t.prototype._get_ticks_lon=function(t,e,n,o){var a,_,l,s,u=(0,i.__read)(c.wgs84_mercator.invert(t,n),1)[0],f=(0,i.__read)(c.wgs84_mercator.invert(e,n),2),d=f[0],m=f[1],v=r.prototype.get_ticks_no_defaults.call(this,u,d,n,o),h=[];try{for(var y=(0,i.__values)(v.major),p=y.next();!p.done;p=y.next()){var g=p.value;if((0,c.in_bounds)(g,"lon")){var w=(0,i.__read)(c.wgs84_mercator.compute(g,m),1)[0];h.push(w)}}}catch(r){a={error:r}}finally{try{p&&!p.done&&(_=y.return)&&_.call(y)}finally{if(a)throw a.error}}var k=[];try{for(var x=(0,i.__values)(v.minor),b=x.next();!b.done;b=x.next()){g=b.value;if((0,c.in_bounds)(g,"lon")){w=(0,i.__read)(c.wgs84_mercator.compute(g,m),1)[0];k.push(w)}}}catch(r){l={error:r}}finally{try{b&&!b.done&&(s=x.return)&&s.call(x)}finally{if(l)throw l.error}}return{major:h,minor:k}},t.prototype._get_ticks_lat=function(t,e,n,o){var a,_,l,s,u=(0,i.__read)(c.wgs84_mercator.invert(n,t),2)[1],f=(0,i.__read)(c.wgs84_mercator.invert(n,e),2),d=f[0],m=f[1],v=r.prototype.get_ticks_no_defaults.call(this,u,m,n,o),h=[];try{for(var y=(0,i.__values)(v.major),p=y.next();!p.done;p=y.next()){var g=p.value;if((0,c.in_bounds)(g,"lat")){var w=(0,i.__read)(c.wgs84_mercator.compute(d,g),2)[1];h.push(w)}}}catch(r){a={error:r}}finally{try{p&&!p.done&&(_=y.return)&&_.call(y)}finally{if(a)throw a.error}}var k=[];try{for(var x=(0,i.__values)(v.minor),b=x.next();!b.done;b=x.next()){g=b.value;if((0,c.in_bounds)(g,"lat")){w=(0,i.__read)(c.wgs84_mercator.compute(d,g),2)[1];k.push(w)}}}catch(r){l={error:r}}finally{try{b&&!b.done&&(s=x.return)&&s.call(x)}finally{if(l)throw l.error}}return{major:h,minor:k}},t}(_.BasicTicker);e.MercatorTicker=s,a=s,s.__name__="MercatorTicker",a.define((function(r){return{dimension:[(0,r.Nullable)(l.LatLon),null]}}))},
function _(e,i,r,c,k){c(),k("AdaptiveTicker",e(263).AdaptiveTicker),k("BasicTicker",e(262).BasicTicker),k("CategoricalTicker",e(256).CategoricalTicker),k("CompositeTicker",e(271).CompositeTicker),k("ContinuousTicker",e(264).ContinuousTicker),k("DatetimeTicker",e(270).DatetimeTicker),k("DaysTicker",e(272).DaysTicker),k("FixedTicker",e(284).FixedTicker),k("LogTicker",e(279).LogTicker),k("MercatorTicker",e(282).MercatorTicker),k("MonthsTicker",e(275).MonthsTicker),k("SingleIntervalTicker",e(273).SingleIntervalTicker),k("Ticker",e(245).Ticker),k("YearsTicker",e(276).YearsTicker),k("BinnedTicker",e(285).BinnedTicker)},
function _(t,n,r,i,e){i();var o,u=t(1),c=function(t){function n(n){return t.call(this,n)||this}return(0,u.__extends)(n,t),n.prototype.get_ticks_no_defaults=function(t,n,r,i){return{major:this.ticks,minor:this.minor_ticks}},n.prototype.get_interval=function(t,n,r){return 0},n.prototype.get_min_interval=function(){return 0},n.prototype.get_max_interval=function(){return 0},n}(t(264).ContinuousTicker);r.FixedTicker=c,o=c,c.__name__="FixedTicker",o.define((function(t){var n=t.Number,r=t.Array;return{ticks:[r(n),[]],minor_ticks:[r(n),[]]}}))},
function _(n,e,t,r,i){r();var a,o=n(1),u=n(245),_=n(286),c=n(116),h=function(n){function e(e){return n.call(this,e)||this}return(0,o.__extends)(e,n),e.prototype.get_ticks=function(n,e,t,r){for(var i=this.mapper.metrics.binning,a=Math.max(0,(0,c.left_edge_index)(n,i)),o=Math.min((0,c.left_edge_index)(e,i)+1,i.length-1),u=[],_=a;_<=o;_++)u.push(i[_]);for(var h=this.num_major_ticks,m=[],f="auto"==h?u.length:h,s=Math.max(1,Math.floor(u.length/f)),l=0;l<u.length;l+=s)m.push(u[l]);return{major:m,minor:[]}},e}(u.Ticker);t.BinnedTicker=h,a=h,h.__name__="BinnedTicker",a.define((function(n){var e=n.Number,t=n.Ref,r=n.Or,i=n.Auto;return{mapper:[t(_.ScanningColorMapper)],num_major_ticks:[r(e,i),8]}}))},
function _(n,i,e,t,o){t();var r=n(1),a=n(287),p=n(116),u=function(n){function i(i){return n.call(this,i)||this}return(0,r.__extends)(i,n),i.prototype.cmap=function(n,i,e,t,o){return n<o.binning[0]?e:n>o.binning[o.binning.length-1]?t:i[(0,p.left_edge_index)(n,o.binning)]},i}(a.ContinuousColorMapper);e.ScanningColorMapper=u,u.__name__="ScanningColorMapper"},
function _(e,r,t,n,a){n();var l,o=e(1),s=e(288),c=e(290),i=e(126),u=e(125),_=function(e){function r(r){var t=e.call(this,r)||this;return t._scan_data=null,t}return(0,o.__extends)(r,e),r.prototype.connect_signals=function(){var r=this;e.prototype.connect_signals.call(this);var t=function(){var e,t;try{for(var n=(0,o.__values)(r.domain),a=n.next();!a.done;a=n.next()){var l=(0,o.__read)(a.value,1)[0];r.connect(l.view.change,(function(){return r.update_data()})),r.connect(l.data_source.selected.change,(function(){return r.update_data()}))}}catch(r){e={error:r}}finally{try{a&&!a.done&&(t=n.return)&&t.call(n)}finally{if(e)throw e.error}}};this.connect(this.properties.domain.change,(function(){return t()})),t()},r.prototype.update_data=function(){var e=this.domain,r=this.palette,t=(0,o.__spreadArray)([],(0,o.__read)(this._collect(e)),!1);this._scan_data=this.scan(t,r.length),this.metrics_change.emit(),this.change.emit()},Object.defineProperty(r.prototype,"metrics",{get:function(){return null==this._scan_data&&this.update_data(),this._scan_data},enumerable:!1,configurable:!0}),r.prototype._collect=function(e){var r,t,n,a,l,s,c,_,h,d,p,f,v,y,g;return(0,o.__generator)(this,(function(m){switch(m.label){case 0:m.trys.push([0,11,12,13]),r=(0,o.__values)(e),t=r.next(),m.label=1;case 1:if(t.done)return[3,10];n=(0,o.__read)(t.value,2),a=n[0],l=n[1],s=function(e){var r,t,n,l,s,c,_,h,d,p;return(0,o.__generator)(this,(function(f){switch(f.label){case 0:if(r=a.data_source.get_column(e),r=a.view.indices.select(r),t=a.view.masked,n=a.data_source.selected.indices,l=void 0,null!=t&&n.length>0?l=(0,i.intersection)((0,o.__spreadArray)([],(0,o.__read)(t),!1),n):null!=t?l=(0,o.__spreadArray)([],(0,o.__read)(t),!1):n.length>0&&(l=n),null!=l&&(r=(0,i.map)(l,(function(e){return r[e]}))),!(r.length>0)||(0,u.isNumber)(r[0]))return[3,9];f.label=1;case 1:f.trys.push([1,6,7,8]),d=void 0,s=(0,o.__values)(r),c=s.next(),f.label=2;case 2:return c.done?[3,5]:(_=c.value,[5,(0,o.__values)(_)]);case 3:f.sent(),f.label=4;case 4:return c=s.next(),[3,2];case 5:return[3,8];case 6:return h=f.sent(),d={error:h},[3,8];case 7:try{c&&!c.done&&(p=s.return)&&p.call(s)}finally{if(d)throw d.error}return[7];case 8:return[3,11];case 9:return[5,(0,o.__values)(r)];case 10:f.sent(),f.label=11;case 11:return[2]}}))},m.label=2;case 2:m.trys.push([2,7,8,9]),y=void 0,c=(0,o.__values)((0,u.isArray)(l)?l:[l]),_=c.next(),m.label=3;case 3:return _.done?[3,6]:(h=_.value,[5,s(h)]);case 4:m.sent(),m.label=5;case 5:return _=c.next(),[3,3];case 6:return[3,9];case 7:return d=m.sent(),y={error:d},[3,9];case 8:try{_&&!_.done&&(g=c.return)&&g.call(c)}finally{if(y)throw y.error}return[7];case 9:return t=r.next(),[3,1];case 10:return[3,13];case 11:return p=m.sent(),f={error:p},[3,13];case 12:try{t&&!t.done&&(v=r.return)&&v.call(r)}finally{if(f)throw f.error}return[7];case 13:return[2]}}))},r.prototype._v_compute=function(e,r,t,n){var a=n.nan_color,l=n.low_color,s=n.high_color;null==l&&(l=t[0]),null==s&&(s=t[t.length-1]);var c=this.domain,u=(0,i.is_empty)(c)?e:(0,o.__spreadArray)([],(0,o.__read)(this._collect(c)),!1);this._scan_data=this.scan(u,t.length),this.metrics_change.emit();for(var _=0,h=e.length;_<h;_++){var d=e[_];isNaN(d)?r[_]=a:r[_]=this.cmap(d,t,l,s,this._scan_data)}},r.prototype._colors=function(r){return(0,o.__assign)((0,o.__assign)({},e.prototype._colors.call(this,r)),{low_color:null!=this.low_color?r(this.low_color):void 0,high_color:null!=this.high_color?r(this.high_color):void 0})},r}(s.ColorMapper);t.ContinuousColorMapper=_,l=_,_.__name__="ContinuousColorMapper",l.define((function(e){var r=e.Number,t=e.String,n=e.Ref,a=e.Color,l=e.Or,o=e.Tuple,s=e.Array,i=e.Nullable;return{high:[i(r),null],low:[i(r),null],high_color:[i(a),null],low_color:[i(a),null],domain:[s(o(n(c.GlyphRenderer),l(t,s(t)))),[]]}}))},
function _(t,r,e,n,o){n();var i,a=t(1),c=t(289),l=t(130),u=t(139),_=t(137),p=t(142);function f(t){return(0,_.encode_rgba)((0,_.color2rgba)(t))}function h(t){for(var r=new Uint32Array(t.length),e=0,n=t.length;e<n;e++)r[e]=f(t[e]);return r}e._convert_color=f,e._convert_palette=h;var s=function(t){function r(r){return t.call(this,r)||this}return(0,a.__extends)(r,t),r.prototype.initialize=function(){t.prototype.initialize.call(this),this.metrics_change=new l.Signal0(this,"metrics_change")},r.prototype.v_compute=function(t){var r=new Array(t.length);return this._v_compute(t,r,this.palette,this._colors((function(t){return t}))),r},Object.defineProperty(r.prototype,"rgba_mapper",{get:function(){var t=this,r=h(this.palette),e=this._colors(f);return{v_compute:function(n){var o=new u.ColorArray(n.length);return t._v_compute(n,o,r,e),new Uint8ClampedArray((0,p.to_big_endian)(o).buffer)}}},enumerable:!1,configurable:!0}),r.prototype._colors=function(t){return{nan_color:t(this.nan_color)}},r}(c.Mapper);e.ColorMapper=s,i=s,s.__name__="ColorMapper",i.define((function(t){var r=t.Color;return{palette:[(0,t.Array)(r)],nan_color:[r,"gray"]}}))},
function _(n,r,t,e,o){e();var p=n(1),i=function(n){function r(r){return n.call(this,r)||this}return(0,p.__extends)(r,n),r.prototype.compute=function(n){throw new Error("mapping single values is not supported")},r}(n(171).Transform);t.Mapper=i,i.__name__="Mapper"},
function _(e,t,i,n,l){n();var r,s=e(1),h=e(291),o=e(292),a=e(301),c=e(302),_=e(304),d=e(294),u=e(185),p=e(305),y=e(139),g=e(116),v=e(128),f=e(228),m=e(182),w={fill:{},line:{}},b={fill:{fill_alpha:.3,fill_color:"grey"},line:{line_alpha:.3,line_color:"grey"}},x={fill:{fill_alpha:.2},line:{}},V={fill:{fill_alpha:.2},line:{}},G=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,s.__extends)(t,e),Object.defineProperty(t.prototype,"glyph_view",{get:function(){return this.glyph},enumerable:!1,configurable:!0}),t.prototype.lazy_initialize=function(){var t;return(0,s.__awaiter)(this,void 0,void 0,(function(){function i(e){var t=(0,v.clone)(a);return h&&(0,v.extend)(t,e.fill),o&&(0,v.extend)(t,e.line),new l.constructor(t)}function n(e,t){return t instanceof d.Glyph?t:i("auto"==t?e:{fill:{},line:{}})}var l,r,h,o,a,c,_,u,p,y,g,f,m,G,A,R;return(0,s.__generator)(this,(function(i){switch(i.label){case 0:return[4,e.prototype.lazy_initialize.call(this)];case 1:return i.sent(),l=this.model.glyph,r=this,[4,this.build_glyph_view(l)];case 2:return r.glyph=i.sent(),h="fill"in this.glyph.visuals,o="line"in this.glyph.visuals,delete(a=(0,s.__assign)({},l.attributes)).id,c=this.model,_=c.selection_glyph,u=c.nonselection_glyph,p=c.hover_glyph,y=c.muted_glyph,_=n(w,_),g=this,[4,this.build_glyph_view(_)];case 3:return g.selection_glyph=i.sent(),u=n(x,u),f=this,[4,this.build_glyph_view(u)];case 4:return f.nonselection_glyph=i.sent(),null==p?[3,6]:(m=this,[4,this.build_glyph_view(p)]);case 5:m.hover_glyph=i.sent(),i.label=6;case 6:return y=n(V,y),G=this,[4,this.build_glyph_view(y)];case 7:return G.muted_glyph=i.sent(),A=n(b,"auto"),R=this,[4,this.build_glyph_view(A)];case 8:return R.decimated_glyph=i.sent(),this.selection_glyph.set_base(this.glyph),this.nonselection_glyph.set_base(this.glyph),null===(t=this.hover_glyph)||void 0===t||t.set_base(this.glyph),this.muted_glyph.set_base(this.glyph),this.decimated_glyph.set_base(this.glyph),this.set_data(),[2]}}))}))},t.prototype.build_glyph_view=function(e){return(0,s.__awaiter)(this,void 0,void 0,(function(){return(0,s.__generator)(this,(function(t){return[2,(0,f.build_view)(e,{parent:this})]}))}))},t.prototype.remove=function(){var t;this.glyph.remove(),this.selection_glyph.remove(),this.nonselection_glyph.remove(),null===(t=this.hover_glyph)||void 0===t||t.remove(),this.muted_glyph.remove(),this.decimated_glyph.remove(),e.prototype.remove.call(this)},t.prototype.connect_signals=function(){var t,i,n,l,r=this;e.prototype.connect_signals.call(this);var h=function(){return r.request_render()},o=function(){return r.update_data()};this.connect(this.model.change,h),this.connect(this.glyph.model.change,o),this.connect(this.selection_glyph.model.change,o),this.connect(this.nonselection_glyph.model.change,o),null!=this.hover_glyph&&this.connect(this.hover_glyph.model.change,o),this.connect(this.muted_glyph.model.change,o),this.connect(this.decimated_glyph.model.change,o),this.connect(this.model.data_source.change,o),this.connect(this.model.data_source.streaming,o),this.connect(this.model.data_source.patching,(function(e){return r.update_data(e)})),this.connect(this.model.data_source.selected.change,h),this.connect(this.model.data_source._select,h),null!=this.hover_glyph&&this.connect(this.model.data_source.inspect,h),this.connect(this.model.properties.view.change,o),this.connect(this.model.view.properties.indices.change,o),this.connect(this.model.view.properties.masked.change,(function(){return r.set_visuals()})),this.connect(this.model.properties.visible.change,(function(){return r.plot_view.invalidate_dataranges=!0}));var a=this.plot_view.frame,c=a.x_ranges,_=a.y_ranges;try{for(var d=(0,s.__values)(c),u=d.next();!u.done;u=d.next()){(g=(0,s.__read)(u.value,2)[1])instanceof m.FactorRange&&this.connect(g.change,o)}}catch(e){t={error:e}}finally{try{u&&!u.done&&(i=d.return)&&i.call(d)}finally{if(t)throw t.error}}try{for(var p=(0,s.__values)(_),y=p.next();!y.done;y=p.next()){var g;(g=(0,s.__read)(y.value,2)[1])instanceof m.FactorRange&&this.connect(g.change,o)}}catch(e){n={error:e}}finally{try{y&&!y.done&&(l=p.return)&&l.call(p)}finally{if(n)throw n.error}}var v=this.model.glyph,f=v.transformchange,w=v.exprchange;this.connect(f,o),this.connect(w,o)},t.prototype._update_masked_indices=function(){var e=this.glyph.mask_data();return this.model.view.masked=e,e},t.prototype.update_data=function(e){this.set_data(e),this.request_render()},t.prototype.set_data=function(e){var t=this.model.data_source;this.all_indices=this.model.view.indices;var i=this.all_indices;this.glyph.set_data(t,i,e),this.set_visuals(),this._update_masked_indices();var n=this.plot_model.lod_factor,l=this.all_indices.count;this.decimated=new y.Indices(l);for(var r=0;r<l;r+=n)this.decimated.set(r);this.plot_view.invalidate_dataranges=!0},t.prototype.set_visuals=function(){var e,t=this.model.data_source,i=this.all_indices;this.glyph.set_visuals(t,i),this.decimated_glyph.set_visuals(t,i),this.selection_glyph.set_visuals(t,i),this.nonselection_glyph.set_visuals(t,i),null===(e=this.hover_glyph)||void 0===e||e.set_visuals(t,i),this.muted_glyph.set_visuals(t,i)},Object.defineProperty(t.prototype,"has_webgl",{get:function(){return this.glyph.has_webgl},enumerable:!1,configurable:!0}),t.prototype._render=function(){var e,t,i,n,l,r,h,d,u,p,y=this,v=this.has_webgl;this.glyph.map_data();var f=(0,s.__spreadArray)([],(0,s.__read)(this.all_indices),!1),m=(0,s.__spreadArray)([],(0,s.__read)(this._update_masked_indices()),!1),w=this.layer.ctx;w.save();var b,x=this.model.data_source.selected;b=!x||x.is_empty()?[]:this.glyph instanceof o.LineView&&x.selected_glyph===this.glyph.model?this.model.view.convert_indices_from_subset(m):x.indices;var V,G,A,R=this.model.data_source.inspected,k=new Set(!R||R.is_empty()?[]:R.selected_glyph?y.model.view.convert_indices_from_subset(m):R.indices.length>0?R.indices:Object.keys(R.multiline_indices).map((function(e){return parseInt(e)}))),z=(0,g.filter)(m,(function(e){return k.has(f[e])})),D=this.plot_model.lod_threshold;if(null!=this.model.document&&this.model.document.interactive_duration()>0&&!v&&null!=D&&f.length>D?(m=(0,s.__spreadArray)([],(0,s.__read)(this.decimated),!1),V=this.decimated_glyph,G=this.decimated_glyph,A=this.selection_glyph):(V=this.model.muted?this.muted_glyph:this.glyph,G=this.nonselection_glyph,A=this.selection_glyph),null!=this.hover_glyph&&z.length){var O=new Set(m);try{for(var S=(0,s.__values)(z),j=S.next();!j.done;j=S.next()){var L=j.value;O.delete(L)}}catch(t){e={error:t}}finally{try{j&&!j.done&&(t=S.return)&&t.call(S)}finally{if(e)throw e.error}}m=(0,s.__spreadArray)([],(0,s.__read)(O),!1)}if(b.length){var C={};try{for(var I=(0,s.__values)(b),P=I.next();!P.done;P=I.next()){C[L=P.value]=!0}}catch(e){l={error:e}}finally{try{P&&!P.done&&(r=I.return)&&r.call(I)}finally{if(l)throw l.error}}var q=new Array,F=new Array;if(this.glyph instanceof o.LineView)try{for(var N=(0,s.__values)(f),B=N.next();!B.done;B=N.next()){null!=C[L=B.value]?q.push(L):F.push(L)}}catch(e){h={error:e}}finally{try{B&&!B.done&&(d=N.return)&&d.call(N)}finally{if(h)throw h.error}}else try{for(var H=(0,s.__values)(m),E=H.next();!E.done;E=H.next()){L=E.value;null!=C[f[L]]?q.push(L):F.push(L)}}catch(e){u={error:e}}finally{try{E&&!E.done&&(p=H.return)&&p.call(H)}finally{if(u)throw u.error}}G.render(w,F),A.render(w,q),null!=this.hover_glyph&&(this.glyph instanceof o.LineView?this.hover_glyph.render(w,this.model.view.convert_indices_from_subset(z)):this.hover_glyph.render(w,z))}else if(this.glyph instanceof o.LineView)this.hover_glyph&&z.length?this.hover_glyph.render(w,this.model.view.convert_indices_from_subset(z)):V.render(w,f);else if(this.glyph instanceof a.PatchView||this.glyph instanceof c.HAreaView||this.glyph instanceof _.VAreaView)if(0==R.selected_glyphs.length||null==this.hover_glyph)V.render(w,f);else try{for(var J=(0,s.__values)(R.selected_glyphs),K=J.next();!K.done;K=J.next()){K.value==this.glyph.model&&this.hover_glyph.render(w,f)}}catch(e){i={error:e}}finally{try{K&&!K.done&&(n=J.return)&&n.call(J)}finally{if(i)throw i.error}}else V.render(w,m),this.hover_glyph&&z.length&&this.hover_glyph.render(w,z);w.restore()},t.prototype.draw_legend=function(e,t,i,n,l,r,s,h){0!=this.glyph.data_size&&(null==h&&(h=this.model.get_reference_point(r,s)),this.glyph.draw_legend_for_index(e,{x0:t,x1:i,y0:n,y1:l},h))},t.prototype.hit_test=function(e){if(!this.model.visible)return null;var t=this.glyph.hit_test(e);return null==t?null:this.model.view.convert_selection_from_subset(t)},t}(h.DataRendererView);i.GlyphRendererView=G,G.__name__="GlyphRendererView";var A=function(e){function t(t){return e.call(this,t)||this}return(0,s.__extends)(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.view.source!=this.data_source&&(this.view.source=this.data_source,this.view.compute_indices())},t.prototype.get_reference_point=function(e,t){var i,n;if(null!=e){var l=this.data_source.get_column(e);if(null!=l)try{for(var r=(0,s.__values)(Object.entries(this.view.indices_map)),h=r.next();!h.done;h=r.next()){var o=(0,s.__read)(h.value,2),a=o[0],c=o[1];if(l[parseInt(a)]==t)return c}}catch(e){i={error:e}}finally{try{h&&!h.done&&(n=r.return)&&n.call(r)}finally{if(i)throw i.error}}}return 0},t.prototype.get_selection_manager=function(){return this.data_source.selection_manager},t}(h.DataRenderer);i.GlyphRenderer=A,r=A,A.__name__="GlyphRenderer",r.prototype.default_view=G,r.define((function(e){var t=e.Boolean,i=e.Auto,n=e.Or,l=e.Ref,r=e.Null,s=e.Nullable;return{data_source:[l(u.ColumnarDataSource)],view:[l(p.CDSView),function(e){return new p.CDSView({source:e.data_source})}],glyph:[l(d.Glyph)],hover_glyph:[s(l(d.Glyph)),null],nonselection_glyph:[n(l(d.Glyph),i,r),"auto"],selection_glyph:[n(l(d.Glyph),i,r),"auto"],muted_glyph:[n(l(d.Glyph),i,r),"auto"],muted:[t,!1]}}))},
function _(e,n,r,t,a){t();var i,o=e(1),c=e(156),u=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,o.__extends)(n,e),Object.defineProperty(n.prototype,"xscale",{get:function(){return this.coordinates.x_scale},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"yscale",{get:function(){return this.coordinates.y_scale},enumerable:!1,configurable:!0}),n}(c.RendererView);r.DataRendererView=u,u.__name__="DataRendererView";var l=function(e){function n(n){return e.call(this,n)||this}return(0,o.__extends)(n,e),Object.defineProperty(n.prototype,"selection_manager",{get:function(){return this.get_selection_manager()},enumerable:!1,configurable:!0}),n}(c.Renderer);r.DataRenderer=l,i=l,l.__name__="DataRenderer",i.override({level:"glyph"})},
function _(e,t,i,n,r){n();var s,l=e(1),o=e(293),_=e(299),a=(0,l.__importStar)(e(163)),h=(0,l.__importStar)(e(300)),u=e(187),c=function(t){function i(){return null!==t&&t.apply(this,arguments)||this}return(0,l.__extends)(i,t),i.prototype.lazy_initialize=function(){return(0,l.__awaiter)(this,void 0,void 0,(function(){var i,n;return(0,l.__generator)(this,(function(r){switch(r.label){case 0:return[4,t.prototype.lazy_initialize.call(this)];case 1:return r.sent(),(null==(i=this.renderer.plot_view.canvas_view.webgl)?void 0:i.regl_wrapper.has_webgl)?[4,Promise.resolve().then((function(){return(0,l.__importStar)(e(536))}))]:[3,3];case 2:n=r.sent().LineGL,this.glglyph=new n(i.regl_wrapper,this),r.label=3;case 3:return[2]}}))}))},i.prototype._render=function(e,t,i){var n,r,s=null!=i?i:this,o=s.sx,_=s.sy,a=null,h=function(e){return null!=a&&e-a!=1},u=!0;e.beginPath();try{for(var c=(0,l.__values)(t),p=c.next();!p.done;p=c.next()){var y=p.value,d=o[y],v=_[y];isFinite(d+v)?u||h(y)?(e.moveTo(d,v),u=!1):e.lineTo(d,v):u=!0,a=y}}catch(e){n={error:e}}finally{try{p&&!p.done&&(r=c.return)&&r.call(c)}finally{if(n)throw n.error}}this.visuals.line.set_value(e),e.stroke()},i.prototype._hit_point=function(e){for(var t=new u.Selection,i={x:e.sx,y:e.sy},n=9999,r=Math.max(2,this.line_width.value/2),s=0,l=this.sx.length-1;s<l;s++){var o={x:this.sx[s],y:this.sy[s]},_={x:this.sx[s+1],y:this.sy[s+1]},a=h.dist_to_segment(i,o,_);a<r&&a<n&&(n=a,t.add_to_selected_glyphs(this.model),t.view=this,t.line_indices=[s])}return t},i.prototype._hit_span=function(e){var t,i,n=e.sx,r=e.sy,s=new u.Selection;"v"==e.direction?(t=this.renderer.yscale.invert(r),i=this._y):(t=this.renderer.xscale.invert(n),i=this._x);for(var l=0,o=i.length-1;l<o;l++)(i[l]<=t&&t<=i[l+1]||i[l+1]<=t&&t<=i[l])&&(s.add_to_selected_glyphs(this.model),s.view=this,s.line_indices.push(l));return s},i.prototype.get_interpolation_hit=function(e,t){var i=(0,l.__read)([this._x[e],this._y[e],this._x[e+1],this._y[e+1]],4),n=i[0],r=i[1],s=i[2],o=i[3];return(0,_.line_interpolation)(this.renderer,t,n,r,s,o)},i.prototype.draw_legend_for_index=function(e,t,i){(0,_.generic_line_scalar_legend)(this.visuals,e,t)},i}(o.XYGlyphView);i.LineView=c,c.__name__="LineView";var p=function(e){function t(t){return e.call(this,t)||this}return(0,l.__extends)(t,e),t}(o.XYGlyph);i.Line=p,s=p,p.__name__="Line",s.prototype.default_view=c,s.mixins(a.LineScalar)},
function _(t,n,e,i,r){i();var _,o=t(1),p=t(193),a=(0,o.__importStar)(t(133)),y=t(294),c=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(n,t),n.prototype._project_data=function(){p.inplace.project_xy(this._x,this._y)},n.prototype._index_data=function(t){for(var n=this,e=n._x,i=n._y,r=n.data_size,_=0;_<r;_++){var o=e[_],p=i[_];t.add_point(o,p)}},n.prototype.scenterxy=function(t){return[this.sx[t],this.sy[t]]},n}(y.GlyphView);e.XYGlyphView=c,c.__name__="XYGlyphView";var u=function(t){function n(n){return t.call(this,n)||this}return(0,o.__extends)(n,t),n}(y.Glyph);e.XYGlyph=u,_=u,u.__name__="XYGlyph",_.define((function(t){return{x:[a.XCoordinateSpec,{field:"x"}],y:[a.YCoordinateSpec,{field:"y"}]}}))},
function _(e,t,r,n,i){n();var a=e(1),o=(0,a.__importStar)(e(133)),s=(0,a.__importStar)(e(180)),l=(0,a.__importStar)(e(160)),_=e(157),u=e(168),c=e(134),d=e(139),h=e(125),p=e(295),f=e(116),y=e(141),v=e(296),g=e(182),x=e(187),b=Math.abs,m=Math.ceil,w=function(e){function t(){var t=e.apply(this,(0,a.__spreadArray)([],(0,a.__read)(arguments),!1))||this;return t._index=null,t._data_size=null,t._nohit_warned=new Set,t}return(0,a.__extends)(t,e),Object.defineProperty(t.prototype,"renderer",{get:function(){return this.parent},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"has_webgl",{get:function(){return null!=this.glglyph},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"index",{get:function(){var e=this._index;if(null!=e)return e;throw new Error(this+".index_data() wasn't called")},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"data_size",{get:function(){var e=this._data_size;if(null!=e)return e;throw new Error(this+".set_data() wasn't called")},enumerable:!1,configurable:!0}),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.visuals=new l.Visuals(this)},t.prototype.request_render=function(){this.parent.request_render()},Object.defineProperty(t.prototype,"canvas",{get:function(){return this.renderer.parent.canvas_view},enumerable:!1,configurable:!0}),t.prototype.render=function(e,t,r){var n;null!=this.glglyph&&(this.renderer.needs_webgl_blit=this.glglyph.render(e,t,null!==(n=this.base)&&void 0!==n?n:this),this.renderer.needs_webgl_blit)||this._render(e,t,null!=r?r:this.base)},t.prototype.has_finished=function(){return!0},t.prototype.notify_finished=function(){this.renderer.notify_finished()},t.prototype._bounds=function(e){return e},t.prototype.bounds=function(){return this._bounds(this.index.bbox)},t.prototype.log_bounds=function(){var e=this.index.bounds(s.positive_x()),t=e.x0,r=e.x1,n=this.index.bounds(s.positive_y()),i=n.y0,a=n.y1;return this._bounds({x0:t,y0:i,x1:r,y1:a})},t.prototype.get_anchor_point=function(e,t,r){var n=(0,a.__read)(r,2),i=n[0],o=n[1];switch(e){case"center":case"center_center":var s=(0,a.__read)(this.scenterxy(t,i,o),2);return{x:s[0],y:s[1]};default:return null}},t.prototype.scenterx=function(e,t,r){return this.scenterxy(e,t,r)[0]},t.prototype.scentery=function(e,t,r){return this.scenterxy(e,t,r)[1]},t.prototype.sdist=function(e,t,r,n,i){void 0===n&&(n="edge"),void 0===i&&(i=!1);var a=t.length,o=new d.ScreenArray(a),s=e.s_compute;if("center"==n)for(var l=0;l<a;l++){var _=t[l],u=r.get(l)/2,c=s(_-u),h=s(_+u);o[l]=b(h-c)}else for(l=0;l<a;l++){c=s(_=t[l]),h=s(_+r.get(l));o[l]=b(h-c)}return i&&(0,f.inplace_map)(o,(function(e){return m(e)})),o},t.prototype.draw_legend_for_index=function(e,t,r){},t.prototype.hit_test=function(e){switch(e.type){case"point":if(null!=this._hit_point)return this._hit_point(e);break;case"span":if(null!=this._hit_span)return this._hit_span(e);break;case"rect":if(null!=this._hit_rect)return this._hit_rect(e);break;case"poly":if(null!=this._hit_poly)return this._hit_poly(e)}return this._nohit_warned.has(e.type)||(c.logger.debug("'"+e.type+"' selection not available for "+this.model.type),this._nohit_warned.add(e.type)),null},t.prototype._hit_rect_against_index=function(e){var t=e.sx0,r=e.sx1,n=e.sy0,i=e.sy1,o=(0,a.__read)(this.renderer.coordinates.x_scale.r_invert(t,r),2),s=o[0],l=o[1],_=(0,a.__read)(this.renderer.coordinates.y_scale.r_invert(n,i),2),u=_[0],c=_[1],d=(0,a.__spreadArray)([],(0,a.__read)(this.index.indices({x0:s,x1:l,y0:u,y1:c})),!1);return new x.Selection({indices:d})},t.prototype._project_data=function(){},t.prototype._iter_visuals=function(){var e,t,r,n,i,s,l,_,u,c,d,h;return(0,a.__generator)(this,(function(p){switch(p.label){case 0:p.trys.push([0,11,12,13]),e=(0,a.__values)(this.visuals),t=e.next(),p.label=1;case 1:if(t.done)return[3,10];r=t.value,p.label=2;case 2:p.trys.push([2,7,8,9]),d=void 0,n=(0,a.__values)(r),i=n.next(),p.label=3;case 3:return i.done?[3,6]:(s=i.value)instanceof o.VectorSpec||s instanceof o.ScalarSpec?[4,s]:[3,5];case 4:p.sent(),p.label=5;case 5:return i=n.next(),[3,3];case 6:return[3,9];case 7:return l=p.sent(),d={error:l},[3,9];case 8:try{i&&!i.done&&(h=n.return)&&h.call(n)}finally{if(d)throw d.error}return[7];case 9:return t=e.next(),[3,1];case 10:return[3,13];case 11:return _=p.sent(),u={error:_},[3,13];case 12:try{t&&!t.done&&(c=e.return)&&c.call(e)}finally{if(u)throw u.error}return[7];case 13:return[2]}}))},t.prototype.set_base=function(e){e!=this&&e instanceof this.constructor&&(this.base=e)},t.prototype._configure=function(e,t){Object.defineProperty(this,(0,h.isString)(e)?e:e.attr,(0,a.__assign)({configurable:!0,enumerable:!0},t))},t.prototype.set_visuals=function(e,t){var r,n,i,o,s,l=function(r){var n=_.base;if(null!=n){var i=n.model.properties[r.attr];if(null!=i&&(0,y.is_equal)(r.get_value(),i.get_value()))return _._configure(r,{get:function(){return n[""+r.attr]}}),"continue"}var a=r.uniform(e).select(t);_._configure(r,{value:a})},_=this;try{for(var u=(0,a.__values)(this._iter_visuals()),c=u.next();!c.done;c=u.next()){l(c.value)}}catch(e){r={error:e}}finally{try{c&&!c.done&&(n=u.return)&&n.call(u)}finally{if(r)throw r.error}}try{for(var d=(0,a.__values)(this.visuals),h=d.next();!h.done;h=d.next()){h.value.update()}}catch(e){i={error:e}}finally{try{h&&!h.done&&(o=d.return)&&o.call(d)}finally{if(i)throw i.error}}this._set_visuals(),null===(s=this.glglyph)||void 0===s||s.set_visuals_changed()},t.prototype._set_visuals=function(){},t.prototype.set_data=function(e,t,r){var n,i,s,l=this.renderer.coordinates,_=l.x_source,u=l.y_source,c=new Set(this._iter_visuals());this._data_size=t.count;try{for(var d=(0,a.__values)(this.model),h=d.next();!h.done;h=d.next()){var y=h.value;if((y instanceof o.VectorSpec||y instanceof o.ScalarSpec)&&!c.has(y))if(y instanceof o.BaseCoordinateSpec){var v=y.array(e),x=t.select(v),b="x"==y.dimension?_:u;if(b instanceof g.FactorRange)if(y instanceof o.CoordinateSpec)x=b.v_synthetic(x);else if(y instanceof o.CoordinateSeqSpec)for(var m=0;m<x.length;m++)x[m]=b.v_synthetic(x[m]);var w=void 0;w=y instanceof o.CoordinateSeqSpec?p.RaggedArray.from(x,Float64Array):x,this._configure("_"+y.attr,{value:w})}else{var S=y.uniform(e).select(t);if(this._configure(y,{value:S}),y instanceof o.DistanceSpec){var z=S.is_Scalar()?S.value:(0,f.max)(S.array);this._configure("max_"+y.attr,{value:z})}}}}catch(e){n={error:e}}finally{try{h&&!h.done&&(i=d.return)&&i.call(d)}finally{if(n)throw n.error}}this.renderer.plot_view.model.use_map&&this._project_data(),this._set_data(null!=r?r:null),null===(s=this.glglyph)||void 0===s||s.set_data_changed(),this.index_data()},t.prototype._set_data=function(e){},Object.defineProperty(t.prototype,"_index_size",{get:function(){return this.data_size},enumerable:!1,configurable:!0}),t.prototype.index_data=function(){var e=new v.SpatialIndex(this._index_size);this._index_data(e),e.finish(),this._index=e},t.prototype.mask_data=function(){return null==this._mask_data?d.Indices.all_set(this.data_size):this._mask_data()},t.prototype.map_data=function(){var e,t,r,n=this.renderer.coordinates,i=n.x_scale,s=n.y_scale;try{for(var l=(0,a.__values)(this.model),_=l.next();!_.done;_=l.next()){var u=_.value;if(u instanceof o.BaseCoordinateSpec){var c="x"==u.dimension?i:s,d=this["_"+u.attr];if(d instanceof p.RaggedArray){var h=c.v_compute(d.array);d=new p.RaggedArray(d.offsets,h)}else d=c.v_compute(d);this["s"+u.attr]=d}}}catch(t){e={error:t}}finally{try{_&&!_.done&&(t=l.return)&&t.call(l)}finally{if(e)throw e.error}}this._map_data(),null===(r=this.glglyph)||void 0===r||r.set_data_changed()},t.prototype._map_data=function(){},t}(_.View);r.GlyphView=w,w.__name__="GlyphView";var S=function(e){function t(t){return e.call(this,t)||this}return(0,a.__extends)(t,e),t}(u.Model);r.Glyph=S,S.__name__="Glyph"},
function _(t,r,e,n,s){n();var a,o=t(1),i=t(141),f=t(127),u=function(){function t(t,r){this.offsets=t,this.array=r}return t.prototype[(a=Symbol.toStringTag,i.equals)]=function(t,r){return r.arrays(this.offsets,t.offsets)&&r.arrays(this.array,t.array)},Object.defineProperty(t.prototype,"length",{get:function(){return this.offsets.length},enumerable:!1,configurable:!0}),t.prototype.clone=function(){return new t(this.offsets.slice(),this.array.slice())},t.from=function(r,e){for(var n=r.length,s=0,a=function(){for(var t=new Uint32Array(n),e=0;e<n;e++){var a=r[e].length;t[e]=s,s+=a}return s<256?new Uint8Array(t):s<65536?new Uint16Array(t):t}(),o=new e(s),i=0;i<n;i++)o.set(r[i],a[i]);return new t(a,o)},t.prototype[Symbol.iterator]=function(){var t,r,e,n;return(0,o.__generator)(this,(function(s){switch(s.label){case 0:r=(t=this).offsets,e=t.length,n=0,s.label=1;case 1:return n<e?[4,this.array.subarray(r[n],r[n+1])]:[3,4];case 2:s.sent(),s.label=3;case 3:return n++,[3,1];case 4:return[2]}}))},t.prototype._check_bounds=function(t){(0,f.assert)(0<=t&&t<this.length,"Out of bounds: 0 <= "+t+" < "+this.length)},t.prototype.get=function(t){this._check_bounds(t);var r=this.offsets;return this.array.subarray(r[t],r[t+1])},t.prototype.set=function(t,r){this._check_bounds(t),this.array.set(r,this.offsets[t])},t}();e.RaggedArray=u,u.__name__="RaggedArray",u[a]="RaggedArray"},
function _(t,e,n,i,r){i();var o=t(1),s=(0,o.__importDefault)(t(297)),a=t(139),d=t(180);function u(t,e){for(var n=0,i=e.length-1;n<i;){var r=n+i>>1;e[r]>t?i=r:n=r+1}return e[n]}var h=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(e,t),Object.defineProperty(e.prototype,"boxes",{get:function(){return this._boxes},enumerable:!1,configurable:!0}),e.prototype.search_indices=function(t,e,n,i){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");for(var r=this._boxes.length-4,o=[],s=new a.Indices(this.numItems);void 0!==r;){for(var d=Math.min(r+4*this.nodeSize,u(r,this._levelBounds)),h=r;h<d;h+=4){var l=0|this._indices[h>>2],x=this._boxes[h+0],_=this._boxes[h+1],p=this._boxes[h+2],y=this._boxes[h+3];n<x||(i<_||t>p||e>y||(r<4*this.numItems?s.set(l):o.push(l)))}r=o.pop()}return s},e}(s.default);h.__name__="_FlatBush";var l=function(){function t(t){this.index=null,t>0&&(this.index=new h(t))}return t.prototype.add_rect=function(t,e,n,i){var r;isFinite(t+e+n+i)?null===(r=this.index)||void 0===r||r.add(t,e,n,i):this.add_empty()},t.prototype.add_point=function(t,e){var n;isFinite(t+e)?null===(n=this.index)||void 0===n||n.add(t,e,t,e):this.add_empty()},t.prototype.add_empty=function(){var t;null===(t=this.index)||void 0===t||t.add(1/0,1/0,-1/0,-1/0)},t.prototype.finish=function(){var t;null===(t=this.index)||void 0===t||t.finish()},t.prototype._normalize=function(t){var e,n,i=t.x0,r=t.y0,s=t.x1,a=t.y1;return i>s&&(i=(e=(0,o.__read)([s,i],2))[0],s=e[1]),r>a&&(r=(n=(0,o.__read)([a,r],2))[0],a=n[1]),{x0:i,y0:r,x1:s,y1:a}},Object.defineProperty(t.prototype,"bbox",{get:function(){if(null==this.index)return(0,d.empty)();var t=this.index;return{x0:t.minX,y0:t.minY,x1:t.maxX,y1:t.maxY}},enumerable:!1,configurable:!0}),t.prototype.indices=function(t){if(null==this.index)return new a.Indices(0);var e=this._normalize(t),n=e.x0,i=e.y0,r=e.x1,o=e.y1;return this.index.search_indices(n,i,r,o)},t.prototype.bounds=function(t){var e,n,i=(0,d.empty)();if(null==this.index)return i;var r=this.index.boxes;try{for(var s=(0,o.__values)(this.indices(t)),a=s.next();!a.done;a=s.next()){var u=a.value,h=r[4*u+0],l=r[4*u+1],x=r[4*u+2],_=r[4*u+3];h>=t.x0&&h<i.x0&&(i.x0=h),x<=t.x1&&x>i.x1&&(i.x1=x),l>=t.y0&&l<i.y0&&(i.y0=l),_<=t.y1&&_>i.y1&&(i.y1=_)}}catch(t){e={error:t}}finally{try{a&&!a.done&&(n=s.return)&&n.call(s)}finally{if(e)throw e.error}}return i},t}();n.SpatialIndex=l,l.__name__="SpatialIndex"},
function _(t,i,s,e,r){e();var h=t(1),o=(0,h.__importDefault)(t(298)),n=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array],a=function(){function t(t,i,s,e){if(void 0===i&&(i=16),void 0===s&&(s=Float64Array),void 0===t)throw new Error("Missing required argument: numItems.");if(isNaN(t)||t<=0)throw new Error("Unpexpected numItems value: "+t+".");this.numItems=+t,this.nodeSize=Math.min(Math.max(+i,2),65535);var r=t,h=r;this._levelBounds=[4*r];do{h+=r=Math.ceil(r/this.nodeSize),this._levelBounds.push(4*h)}while(1!==r);this.ArrayType=s||Float64Array,this.IndexArrayType=h<16384?Uint16Array:Uint32Array;var a=n.indexOf(this.ArrayType),_=4*h*this.ArrayType.BYTES_PER_ELEMENT;if(a<0)throw new Error("Unexpected typed array class: "+s+".");e&&e instanceof ArrayBuffer?(this.data=e,this._boxes=new this.ArrayType(this.data,8,4*h),this._indices=new this.IndexArrayType(this.data,8+_,h),this._pos=4*h,this.minX=this._boxes[this._pos-4],this.minY=this._boxes[this._pos-3],this.maxX=this._boxes[this._pos-2],this.maxY=this._boxes[this._pos-1]):(this.data=new ArrayBuffer(8+_+h*this.IndexArrayType.BYTES_PER_ELEMENT),this._boxes=new this.ArrayType(this.data,8,4*h),this._indices=new this.IndexArrayType(this.data,8+_,h),this._pos=0,this.minX=1/0,this.minY=1/0,this.maxX=-1/0,this.maxY=-1/0,new Uint8Array(this.data,0,2).set([251,48+a]),new Uint16Array(this.data,2,1)[0]=i,new Uint32Array(this.data,4,1)[0]=t),this._queue=new o.default}return t.from=function(i){if(!(i instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");var s=(0,h.__read)(new Uint8Array(i,0,2),2),e=s[0],r=s[1];if(251!==e)throw new Error("Data does not appear to be in a Flatbush format.");if(r>>4!=3)throw new Error("Got v"+(r>>4)+" data when expected v3.");var o=(0,h.__read)(new Uint16Array(i,2,1),1)[0];return new t((0,h.__read)(new Uint32Array(i,4,1),1)[0],o,n[15&r],i)},t.prototype.add=function(t,i,s,e){var r=this._pos>>2;return this._indices[r]=r,this._boxes[this._pos++]=t,this._boxes[this._pos++]=i,this._boxes[this._pos++]=s,this._boxes[this._pos++]=e,t<this.minX&&(this.minX=t),i<this.minY&&(this.minY=i),s>this.maxX&&(this.maxX=s),e>this.maxY&&(this.maxY=e),r},t.prototype.finish=function(){if(this._pos>>2!==this.numItems)throw new Error("Added "+(this._pos>>2)+" items when expected "+this.numItems+".");if(this.numItems<=this.nodeSize)return this._boxes[this._pos++]=this.minX,this._boxes[this._pos++]=this.minY,this._boxes[this._pos++]=this.maxX,void(this._boxes[this._pos++]=this.maxY);for(var t=this.maxX-this.minX,i=this.maxY-this.minY,s=new Uint32Array(this.numItems),e=0;e<this.numItems;e++){var r=4*e,h=this._boxes[r++],o=this._boxes[r++],n=this._boxes[r++],a=this._boxes[r++],_=Math.floor(65535*((h+n)/2-this.minX)/t),d=Math.floor(65535*((o+a)/2-this.minY)/i);s[e]=u(_,d)}x(s,this._boxes,this._indices,0,this.numItems-1,this.nodeSize);for(e=0,r=0;e<this._levelBounds.length-1;e++)for(var p=this._levelBounds[e];r<p;){for(var m=r,f=1/0,y=1/0,l=-1/0,b=-1/0,v=0;v<this.nodeSize&&r<p;v++)f=Math.min(f,this._boxes[r++]),y=Math.min(y,this._boxes[r++]),l=Math.max(l,this._boxes[r++]),b=Math.max(b,this._boxes[r++]);this._indices[this._pos>>2]=m,this._boxes[this._pos++]=f,this._boxes[this._pos++]=y,this._boxes[this._pos++]=l,this._boxes[this._pos++]=b}},t.prototype.search=function(t,i,s,e,r){if(this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");for(var h=this._boxes.length-4,o=[],n=[];void 0!==h;){for(var a=Math.min(h+4*this.nodeSize,d(h,this._levelBounds)),_=h;_<a;_+=4){var x=0|this._indices[_>>2];s<this._boxes[_]||(e<this._boxes[_+1]||t>this._boxes[_+2]||i>this._boxes[_+3]||(h<4*this.numItems?(void 0===r||r(x))&&n.push(x):o.push(x)))}h=o.pop()}return n},t.prototype.neighbors=function(t,i,s,e,r){if(void 0===s&&(s=1/0),void 0===e&&(e=1/0),this._pos!==this._boxes.length)throw new Error("Data not yet indexed - call index.finish().");for(var h=this._boxes.length-4,o=this._queue,n=[],a=e*e;void 0!==h;){for(var x=Math.min(h+4*this.nodeSize,d(h,this._levelBounds)),p=h;p<x;p+=4){var u=0|this._indices[p>>2],m=_(t,this._boxes[p],this._boxes[p+2]),f=_(i,this._boxes[p+1],this._boxes[p+3]),y=m*m+f*f;h<4*this.numItems?(void 0===r||r(u))&&o.push(-u-1,y):o.push(u,y)}for(;o.length&&o.peek()<0;){if((y=o.peekValue())>a)return o.clear(),n;if(n.push(-o.pop()-1),n.length===s)return o.clear(),n}h=o.pop()}return o.clear(),n},t}();function _(t,i,s){return t<i?i-t:t<=s?0:t-s}function d(t,i){for(var s=0,e=i.length-1;s<e;){var r=s+e>>1;i[r]>t?e=r:s=r+1}return i[s]}function x(t,i,s,e,r,h){if(!(Math.floor(e/h)>=Math.floor(r/h))){for(var o=t[e+r>>1],n=e-1,a=r+1;;){do{n++}while(t[n]<o);do{a--}while(t[a]>o);if(n>=a)break;p(t,i,s,n,a)}x(t,i,s,e,a,h),x(t,i,s,a+1,r,h)}}function p(t,i,s,e,r){var h=t[e];t[e]=t[r],t[r]=h;var o=4*e,n=4*r,a=i[o],_=i[o+1],d=i[o+2],x=i[o+3];i[o]=i[n],i[o+1]=i[n+1],i[o+2]=i[n+2],i[o+3]=i[n+3],i[n]=a,i[n+1]=_,i[n+2]=d,i[n+3]=x;var p=s[e];s[e]=s[r],s[r]=p}function u(t,i){var s=t^i,e=65535^s,r=65535^(t|i),h=t&(65535^i),o=s|e>>1,n=s>>1^s,a=r>>1^e&h>>1^r,_=s&r>>1^h>>1^h;n=(s=o)&(e=n)>>2^e&(s^e)>>2,a^=s&(r=a)>>2^e&(h=_)>>2,_^=e&r>>2^(s^e)&h>>2,n=(s=o=s&s>>2^e&e>>2)&(e=n)>>4^e&(s^e)>>4,a^=s&(r=a)>>4^e&(h=_)>>4,_^=e&r>>4^(s^e)&h>>4,a^=(s=o=s&s>>4^e&e>>4)&(r=a)>>8^(e=n)&(h=_)>>8;var d=t^i,x=(e=(_^=e&r>>8^(s^e)&h>>8)^_>>1)|65535^(d|(s=a^a>>1));return((x=1431655765&((x=858993459&((x=252645135&((x=16711935&(x|x<<8))|x<<4))|x<<2))|x<<1))<<1|(d=1431655765&((d=858993459&((d=252645135&((d=16711935&(d|d<<8))|d<<4))|d<<2))|d<<1)))>>>0}s.default=a},
function _(t,i,s,h,e){h();var n=function(){function t(){this.ids=[],this.values=[],this.length=0}return t.prototype.clear=function(){this.length=0},t.prototype.push=function(t,i){var s=this.length++;for(this.ids[s]=t,this.values[s]=i;s>0;){var h=s-1>>1,e=this.values[h];if(i>=e)break;this.ids[s]=this.ids[h],this.values[s]=e,s=h}this.ids[s]=t,this.values[s]=i},t.prototype.pop=function(){if(0!==this.length){var t=this.ids[0];if(this.length--,this.length>0){for(var i=this.ids[0]=this.ids[this.length],s=this.values[0]=this.values[this.length],h=this.length>>1,e=0;e<h;){var n=1+(e<<1),l=n+1,u=this.ids[n],r=this.values[n],a=this.values[l];if(l<this.length&&a<r&&(n=l,u=this.ids[l],r=a),r>=s)break;this.ids[e]=u,this.values[e]=r,e=n}this.ids[e]=i,this.values[e]=s}return t}},t.prototype.peek=function(){if(0!==this.length)return this.ids[0]},t.prototype.peekValue=function(){if(0!==this.length)return this.values[0]},t}();s.default=n},
function _(e,a,n,r,i){r();var l=e(1),t=(0,l.__importStar)(e(300));function _(e,a,n,r){var i=n.x0,l=n.x1,t=n.y0,_=n.y1;a.save(),a.beginPath(),a.moveTo(i,(t+_)/2),a.lineTo(l,(t+_)/2),e.line.apply(a,r),a.restore()}function c(e,a,n,r){var i,l,t=n.x0,_=n.x1,c=n.y0,o=n.y1,v=.1*Math.abs(_-t),y=.1*Math.abs(o-c),p=t+v,s=_-v,d=c+y,g=o-y;a.beginPath(),a.rect(p,d,s-p,g-d),e.fill.apply(a,r),null===(i=e.hatch)||void 0===i||i.apply(a,r),null===(l=e.line)||void 0===l||l.apply(a,r)}n.generic_line_scalar_legend=function(e,a,n){var r=n.x0,i=n.x1,l=n.y0,t=n.y1;a.save(),a.beginPath(),a.moveTo(r,(l+t)/2),a.lineTo(i,(l+t)/2),e.line.apply(a),a.restore()},n.generic_line_vector_legend=_,n.generic_line_legend=_,n.generic_area_scalar_legend=function(e,a,n){var r,i,l=n.x0,t=n.x1,_=n.y0,c=n.y1,o=.1*Math.abs(t-l),v=.1*Math.abs(c-_),y=l+o,p=t-o,s=_+v,d=c-v;a.beginPath(),a.rect(y,s,p-y,d-s),e.fill.apply(a),null===(r=e.hatch)||void 0===r||r.apply(a),null===(i=e.line)||void 0===i||i.apply(a)},n.generic_area_vector_legend=c,n.generic_area_legend=c,n.line_interpolation=function(e,a,n,r,i,_){var c,o,v,y,p,s,d,g,h,x,u=a.sx,b=a.sy;"point"==a.type?(h=(c=(0,l.__read)(e.yscale.r_invert(b-1,b+1),2))[0],x=c[1],d=(o=(0,l.__read)(e.xscale.r_invert(u-1,u+1),2))[0],g=o[1]):"v"==a.direction?(h=(v=(0,l.__read)(e.yscale.r_invert(b,b),2))[0],x=v[1],d=(y=(0,l.__read)([Math.min(n-1,i-1),Math.max(n+1,i+1)],2))[0],g=y[1]):(d=(p=(0,l.__read)(e.xscale.r_invert(u,u),2))[0],g=p[1],h=(s=(0,l.__read)([Math.min(r-1,_-1),Math.max(r+1,_+1)],2))[0],x=s[1]);var f=t.check_2_segments_intersect(d,h,g,x,n,r,i,_);return[f.x,f.y]}},
function _(t,n,r,o,a){function e(t,n){return Math.pow(t.x-n.x,2)+Math.pow(t.y-n.y,2)}function h(t,n,r){var o=e(n,r);if(0==o)return e(t,n);var a=((t.x-n.x)*(r.x-n.x)+(t.y-n.y)*(r.y-n.y))/o;return e(t,a<0?n:a>1?r:{x:n.x+a*(r.x-n.x),y:n.y+a*(r.y-n.y)})}o(),r.point_in_poly=function(t,n,r,o){for(var a=!1,e=r[r.length-1],h=o[o.length-1],i=0;i<r.length;i++){var s=r[i],u=o[i];h<n!=u<n&&e+(n-h)/(u-h)*(s-e)<t&&(a=!a),e=s,h=u}return a},r.point_in_ellipse=function(t,n,r,o,a,e,h){var i=Math.pow(Math.cos(r)/a,2)+Math.pow(Math.sin(r)/o,2),s=2*Math.cos(r)*Math.sin(r)*(Math.pow(1/a,2)-Math.pow(1/o,2)),u=Math.pow(Math.cos(r)/o,2)+Math.pow(Math.sin(r)/a,2);return i*Math.pow(t-e,2)+s*(t-e)*(n-h)+u*Math.pow(n-h,2)<=1},r.dist_2_pts=e,r.dist_to_segment_squared=h,r.dist_to_segment=function(t,n,r){return Math.sqrt(h(t,n,r))},r.check_2_segments_intersect=function(t,n,r,o,a,e,h,i){var s=(i-e)*(r-t)-(h-a)*(o-n);if(0==s)return{hit:!1,x:null,y:null};var u=n-e,M=t-a,p=(h-a)*u-(i-e)*M;return M=((r-t)*u-(o-n)*M)/s,{hit:(u=p/s)>0&&u<1&&M>0&&M<1,x:t+u*(r-t),y:n+u*(o-n)}}},
function _(t,e,i,n,a){n();var r,l=t(1),s=t(293),o=t(299),_=(0,l.__importStar)(t(300)),h=(0,l.__importStar)(t(163)),c=t(187),p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,l.__extends)(e,t),e.prototype._render=function(t,e,i){var n,a,r=null!=i?i:this,s=r.sx,o=r.sy,_=!0;t.beginPath();try{for(var h=(0,l.__values)(e),c=h.next();!c.done;c=h.next()){var p=c.value,u=s[p],y=o[p];isFinite(u+y)?_?(t.moveTo(u,y),_=!1):t.lineTo(u,y):(t.closePath(),_=!0)}}catch(t){n={error:t}}finally{try{c&&!c.done&&(a=h.return)&&a.call(h)}finally{if(n)throw n.error}}t.closePath(),this.visuals.fill.apply(t),this.visuals.hatch.apply(t),this.visuals.line.apply(t)},e.prototype.draw_legend_for_index=function(t,e,i){(0,o.generic_area_scalar_legend)(this.visuals,t,e)},e.prototype._hit_point=function(t){var e=new c.Selection;return _.point_in_poly(t.sx,t.sy,this.sx,this.sy)&&(e.add_to_selected_glyphs(this.model),e.view=this),e},e}(s.XYGlyphView);i.PatchView=p,p.__name__="PatchView";var u=function(t){function e(e){return t.call(this,e)||this}return(0,l.__extends)(e,t),e}(s.XYGlyph);i.Patch=u,r=u,u.__name__="Patch",r.prototype.default_view=p,r.mixins([h.LineScalar,h.FillScalar,h.HatchScalar])},
function _(t,e,i,r,n){r();var s,a=t(1),o=t(139),h=t(303),_=(0,a.__importStar)(t(300)),l=(0,a.__importStar)(t(133)),p=t(187),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,a.__extends)(e,t),e.prototype._index_data=function(t){for(var e=Math.min,i=Math.max,r=this.data_size,n=0;n<r;n++){var s=this._x1[n],a=this._x2[n],o=this._y[n];t.add_rect(e(s,a),o,i(s,a),o)}},e.prototype._render=function(t,e,i){var r=null!=i?i:this,n=r.sx1,s=r.sx2,a=r.sy;t.beginPath();for(var o=0,h=n.length;o<h;o++)t.lineTo(n[o],a[o]);for(o=s.length-1;o>=0;o--)t.lineTo(s[o],a[o]);t.closePath(),this.visuals.fill.apply(t),this.visuals.hatch.apply(t)},e.prototype._hit_point=function(t){for(var e=this.sy.length,i=new o.ScreenArray(2*e),r=new o.ScreenArray(2*e),n=0,s=e;n<s;n++)i[n]=this.sx1[n],r[n]=this.sy[n],i[e+n]=this.sx2[e-n-1],r[e+n]=this.sy[e-n-1];var a=new p.Selection;return _.point_in_poly(t.sx,t.sy,i,r)&&(a.add_to_selected_glyphs(this.model),a.view=this),a},e.prototype.scenterxy=function(t){return[(this.sx1[t]+this.sx2[t])/2,this.sy[t]]},e.prototype._map_data=function(){this.sx1=this.renderer.xscale.v_compute(this._x1),this.sx2=this.renderer.xscale.v_compute(this._x2),this.sy=this.renderer.yscale.v_compute(this._y)},e}(h.AreaView);i.HAreaView=c,c.__name__="HAreaView";var u=function(t){function e(e){return t.call(this,e)||this}return(0,a.__extends)(e,t),e}(h.Area);i.HArea=u,s=u,u.__name__="HArea",s.prototype.default_view=c,s.define((function(t){return{x1:[l.XCoordinateSpec,{field:"x1"}],x2:[l.XCoordinateSpec,{field:"x2"}],y:[l.YCoordinateSpec,{field:"y"}]}}))},
function _(e,n,r,a,t){a();var i,_=e(1),l=e(294),c=e(299),u=(0,_.__importStar)(e(163)),s=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,_.__extends)(n,e),n.prototype.draw_legend_for_index=function(e,n,r){(0,c.generic_area_scalar_legend)(this.visuals,e,n)},n}(l.GlyphView);r.AreaView=s,s.__name__="AreaView";var o=function(e){function n(n){return e.call(this,n)||this}return(0,_.__extends)(n,e),n}(l.Glyph);r.Area=o,i=o,o.__name__="Area",i.mixins([u.FillScalar,u.HatchScalar])},
function _(t,e,i,r,n){r();var s,a=t(1),o=t(139),h=t(303),_=(0,a.__importStar)(t(300)),y=(0,a.__importStar)(t(133)),l=t(187),p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,a.__extends)(e,t),e.prototype._index_data=function(t){for(var e=Math.min,i=Math.max,r=this.data_size,n=0;n<r;n++){var s=this._x[n],a=this._y1[n],o=this._y2[n];t.add_rect(s,e(a,o),s,i(a,o))}},e.prototype._render=function(t,e,i){var r=null!=i?i:this,n=r.sx,s=r.sy1,a=r.sy2;t.beginPath();for(var o=0,h=s.length;o<h;o++)t.lineTo(n[o],s[o]);for(o=a.length-1;o>=0;o--)t.lineTo(n[o],a[o]);t.closePath(),this.visuals.fill.apply(t),this.visuals.hatch.apply(t)},e.prototype.scenterxy=function(t){return[this.sx[t],(this.sy1[t]+this.sy2[t])/2]},e.prototype._hit_point=function(t){for(var e=this.sx.length,i=new o.ScreenArray(2*e),r=new o.ScreenArray(2*e),n=0,s=e;n<s;n++)i[n]=this.sx[n],r[n]=this.sy1[n],i[e+n]=this.sx[e-n-1],r[e+n]=this.sy2[e-n-1];var a=new l.Selection;return _.point_in_poly(t.sx,t.sy,i,r)&&(a.add_to_selected_glyphs(this.model),a.view=this),a},e.prototype._map_data=function(){this.sx=this.renderer.xscale.v_compute(this._x),this.sy1=this.renderer.yscale.v_compute(this._y1),this.sy2=this.renderer.yscale.v_compute(this._y2)},e}(h.AreaView);i.VAreaView=p,p.__name__="VAreaView";var c=function(t){function e(e){return t.call(this,e)||this}return(0,a.__extends)(e,t),e}(h.Area);i.VArea=c,s=c,c.__name__="VArea",s.prototype.default_view=p,s.define((function(t){return{x:[y.XCoordinateSpec,{field:"x"}],y1:[y.YCoordinateSpec,{field:"y1"}],y2:[y.YCoordinateSpec,{field:"y2"}]}}))},
function _(t,n,e,i,r){i();var c,o=t(1),s=t(168),u=t(139),a=t(306),_=t(185),l=function(t){function n(n){return t.call(this,n)||this}return(0,o.__extends)(n,t),n.prototype.initialize=function(){t.prototype.initialize.call(this),this.compute_indices()},n.prototype.connect_signals=function(){var n=this;t.prototype.connect_signals.call(this),this.connect(this.properties.filters.change,(function(){return n.compute_indices()}));var e=function(){var t=function(){return n.compute_indices()};null!=n.source&&(n.connect(n.source.change,t),n.source instanceof _.ColumnarDataSource&&(n.connect(n.source.streaming,t),n.connect(n.source.patching,t)))},i=null!=this.source;i?e():this.connect(this.properties.source.change,(function(){i||(e(),i=!0)}))},n.prototype.compute_indices=function(){var t,n,e,i=this.source;if(null!=i){var r=null!==(e=i.get_length())&&void 0!==e?e:1,c=u.Indices.all_set(r);try{for(var s=(0,o.__values)(this.filters),a=s.next();!a.done;a=s.next()){var _=a.value;c.intersect(_.compute_indices(i))}}catch(n){t={error:n}}finally{try{a&&!a.done&&(n=s.return)&&n.call(s)}finally{if(t)throw t.error}}this.indices=c,this._indices=(0,o.__spreadArray)([],(0,o.__read)(c),!1),this.indices_map_to_subset()}},n.prototype.indices_map_to_subset=function(){this.indices_map={};for(var t=0;t<this._indices.length;t++)this.indices_map[this._indices[t]]=t},n.prototype.convert_selection_from_subset=function(t){var n=this;return t.map((function(t){return n._indices[t]}))},n.prototype.convert_selection_to_subset=function(t){var n=this;return t.map((function(t){return n.indices_map[t]}))},n.prototype.convert_indices_from_subset=function(t){var n=this;return t.map((function(t){return n._indices[t]}))},n}(s.Model);e.CDSView=l,c=l,l.__name__="CDSView",c.define((function(t){var n=t.Array,e=t.Ref;return{filters:[n(e(a.Filter)),[]],source:[e(_.ColumnarDataSource)]}})),c.internal((function(t){var n=t.Int,e=t.Dict,i=t.Ref,r=t.Nullable;return{indices:[i(u.Indices)],indices_map:[e(n),{}],masked:[r(i(u.Indices)),null]}}))},
function _(n,t,e,i,r){i();var _=n(1),l=function(n){function t(t){return n.call(this,t)||this}return(0,_.__extends)(t,n),t}(n(168).Model);e.Filter=l,l.__name__="Filter"},
function _(t,r,a,e,c){e(),c("BasicTickFormatter",t(261).BasicTickFormatter),c("CategoricalTickFormatter",t(257).CategoricalTickFormatter),c("DatetimeTickFormatter",t(265).DatetimeTickFormatter),c("FuncTickFormatter",t(308).FuncTickFormatter),c("LogTickFormatter",t(278).LogTickFormatter),c("MercatorTickFormatter",t(281).MercatorTickFormatter),c("NumeralTickFormatter",t(309).NumeralTickFormatter),c("PrintfTickFormatter",t(310).PrintfTickFormatter),c("TickFormatter",t(246).TickFormatter)},
function _(e,r,t,n,i){n();var a,o=e(1),u=e(246),c=e(128),s=e(149),_=function(e){function r(r){return e.call(this,r)||this}return(0,o.__extends)(r,e),Object.defineProperty(r.prototype,"names",{get:function(){return(0,c.keys)(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(r.prototype,"values",{get:function(){return(0,c.values)(this.args)},enumerable:!1,configurable:!0}),r.prototype._make_func=function(){var e=(0,s.use_strict)(this.code);return new(Function.bind.apply(Function,(0,o.__spreadArray)((0,o.__spreadArray)([void 0,"tick","index","ticks"],(0,o.__read)(this.names),!1),[e],!1)))},r.prototype.doFormat=function(e,r){var t=this,n=this._make_func().bind({});return e.map((function(e,r,i){return""+n.apply(void 0,(0,o.__spreadArray)([e,r,i],(0,o.__read)(t.values),!1))}))},r}(u.TickFormatter);t.FuncTickFormatter=_,a=_,_.__name__="FuncTickFormatter",a.define((function(e){var r=e.Unknown,t=e.String;return{args:[(0,e.Dict)(r),{}],code:[t,""]}}))},
function _(n,r,t,e,o){e();var u,a=n(1),i=(0,a.__importStar)(n(268)),c=n(246),f=n(135),d=function(n){function r(r){return n.call(this,r)||this}return(0,a.__extends)(r,n),Object.defineProperty(r.prototype,"_rounding_fn",{get:function(){switch(this.rounding){case"round":case"nearest":return Math.round;case"floor":case"rounddown":return Math.floor;case"ceil":case"roundup":return Math.ceil}},enumerable:!1,configurable:!0}),r.prototype.doFormat=function(n,r){var t=this,e=t.format,o=t.language,u=t._rounding_fn;return n.map((function(n){return i.format(n,e,o,u)}))},r}(c.TickFormatter);t.NumeralTickFormatter=d,u=d,d.__name__="NumeralTickFormatter",u.define((function(n){var r=n.String;return{format:[r,"0,0"],language:[r,"en"],rounding:[f.RoundingFunction,"round"]}}))},
function _(t,r,n,i,o){i();var e,f=t(1),a=t(246),u=t(267),c=function(t){function r(r){return t.call(this,r)||this}return(0,f.__extends)(r,t),r.prototype.doFormat=function(t,r){var n=this;return t.map((function(t){return(0,u.sprintf)(n.format,t)}))},r}(a.TickFormatter);n.PrintfTickFormatter=c,e=c,c.__name__="PrintfTickFormatter",e.define((function(t){return{format:[t.String,"%s"]}}))},
function _(r,o,a,p,e){p(),e("CategoricalColorMapper",r(312).CategoricalColorMapper),e("CategoricalMarkerMapper",r(314).CategoricalMarkerMapper),e("CategoricalPatternMapper",r(315).CategoricalPatternMapper),e("ContinuousColorMapper",r(287).ContinuousColorMapper),e("ColorMapper",r(288).ColorMapper),e("LinearColorMapper",r(316).LinearColorMapper),e("LogColorMapper",r(317).LogColorMapper),e("ScanningColorMapper",r(286).ScanningColorMapper),e("EqHistColorMapper",r(318).EqHistColorMapper)},
function _(t,r,o,e,n){e();var a,c=t(1),i=t(313),l=t(288),u=t(182),_=function(t){function r(r){return t.call(this,r)||this}return(0,c.__extends)(r,t),r.prototype._v_compute=function(t,r,o,e){var n=e.nan_color;(0,i.cat_v_compute)(t,this.factors,o,r,this.start,this.end,n)},r}(l.ColorMapper);o.CategoricalColorMapper=_,a=_,_.__name__="CategoricalColorMapper",a.define((function(t){var r=t.Number,o=t.Nullable;return{factors:[u.FactorSeq],start:[r,0],end:[o(r),null]}}))},
function _(n,t,e,i,l){i();var r=n(116),u=n(125);function f(n,t){if(n.length!=t.length)return!1;for(var e=0,i=n.length;e<i;e++)if(n[e]!==t[e])return!1;return!0}e._cat_equals=f,e.cat_v_compute=function(n,t,e,i,l,o,c){for(var a=n.length,v=function(a){var v=n[a],_=void 0;(0,u.isString)(v)?_=(0,r.index_of)(t,v):(null!=l?v=null!=o?v.slice(l,o):v.slice(l):null!=o&&(v=v.slice(0,o)),_=1==v.length?(0,r.index_of)(t,v[0]):(0,r.find_index)(t,(function(n){return f(n,v)})));var g=void 0;g=_<0||_>=e.length?c:e[_],i[a]=g},_=0;_<a;_++)v(_)}},
function _(r,e,t,a,n){a();var u,c=r(1),i=r(313),l=r(182),o=r(289),s=r(135),p=function(r){function e(e){return r.call(this,e)||this}return(0,c.__extends)(e,r),e.prototype.v_compute=function(r){var e=new Array(r.length);return(0,i.cat_v_compute)(r,this.factors,this.markers,e,this.start,this.end,this.default_value),e},e}(o.Mapper);t.CategoricalMarkerMapper=p,u=p,p.__name__="CategoricalMarkerMapper",u.define((function(r){var e=r.Number,t=r.Array,a=r.Nullable;return{factors:[l.FactorSeq],markers:[t(s.MarkerType)],start:[e,0],end:[a(e),null],default_value:[s.MarkerType,"circle"]}}))},
function _(t,e,a,r,n){r();var u,c=t(1),i=t(313),l=t(182),o=t(289),p=t(135),s=function(t){function e(e){return t.call(this,e)||this}return(0,c.__extends)(e,t),e.prototype.v_compute=function(t){var e=new Array(t.length);return(0,i.cat_v_compute)(t,this.factors,this.patterns,e,this.start,this.end,this.default_value),e},e}(o.Mapper);a.CategoricalPatternMapper=s,u=s,s.__name__="CategoricalPatternMapper",u.define((function(t){var e=t.Number,a=t.Array,r=t.Nullable;return{factors:[l.FactorSeq],patterns:[a(p.HatchPatternType)],start:[e,0],end:[r(e),null],default_value:[p.HatchPatternType," "]}}))},
function _(n,r,t,o,i){o();var a=n(1),e=n(287),l=n(116),u=function(n){function r(r){return n.call(this,r)||this}return(0,a.__extends)(r,n),r.prototype.scan=function(n,r){var t=null!=this.low?this.low:(0,l.min)(n),o=null!=this.high?this.high:(0,l.max)(n);return{max:o,min:t,norm_factor:1/(o-t),normed_interval:1/r}},r.prototype.cmap=function(n,r,t,o,i){var a=r.length-1;if(n==i.max)return r[a];var e=(n-i.min)*i.norm_factor,l=Math.floor(e/i.normed_interval);return l<0?t:l>a?o:r[l]},r}(e.ContinuousColorMapper);t.LinearColorMapper=u,u.__name__="LinearColorMapper"},
function _(t,n,o,r,a){r();var i=t(1),l=t(287),e=t(116),h=function(t){function n(n){return t.call(this,n)||this}return(0,i.__extends)(n,t),n.prototype.scan=function(t,n){var o=null!=this.low?this.low:(0,e.min)(t),r=null!=this.high?this.high:(0,e.max)(t);return{max:r,min:o,scale:n/(Math.log(r)-Math.log(o))}},n.prototype.cmap=function(t,n,o,r,a){var i=n.length-1;if(t>a.max)return r;if(t==a.max)return n[i];if(t<a.min)return o;var l=Math.log(t)-Math.log(a.min),e=Math.floor(l*a.scale);return e>i&&(e=i),n[e]},n}(l.ContinuousColorMapper);o.LogColorMapper=h,h.__name__="LogColorMapper"},
function _(n,r,t,i,e){i();var a,o=n(1),l=n(286),u=n(116),s=n(126),h=n(134),c=function(n){function r(r){return n.call(this,r)||this}return(0,o.__extends)(r,n),r.prototype.scan=function(n,r){for(var t=null!=this.low?this.low:(0,u.min)(n),i=null!=this.high?this.high:(0,u.max)(n),e=this.bins,a=(0,s.linspace)(t,i,e+1),o=(0,u.bin_counts)(n,a),l=new Array(e),c=0,g=a.length;c<g-1;c++){var p=a[c],f=a[c+1];l[c]=(p+f)/2}for(var m=(0,s.cumsum)(o),v=m[m.length-1],_=(0,u.map)(m,(function(n){return n/v})),M=r-1,b=[],d=0,q=2*r;M!=r&&d<4&&0!=M;){var w=q/M;if(w>1e3)break;q=Math.round(Math.max(r*w,r));var x=(0,s.range)(0,q),C=(0,u.map)(_,(function(n){return n*(q-1)}));b=(0,u.interpolate)(x,C,l),M=(0,s.uniq)(b).length-1,d++}if(0==M){b=[t,i];for(var H=0;H<r-1;H++)b.push(i)}else b=b.slice(b.length-r-1),M!=r&&h.logger.warn("EqHistColorMapper warning: Histogram equalization did not converge.");return b[0]=t,b[b.length-1]=i,{min:t,max:i,binning:b}},r}(l.ScanningColorMapper);t.EqHistColorMapper=c,a=c,c.__name__="EqHistColorMapper",a.define((function(n){return{bins:[n.Int,65536]}}))},
function _(a,e,l,c,n){c(),n("CategoricalScale",a(177).CategoricalScale),n("ContinuousScale",a(175).ContinuousScale),n("LinearScale",a(174).LinearScale),n("LinearInterpolationScale",a(320).LinearInterpolationScale),n("LogScale",a(176).LogScale),n("Scale",a(170).Scale)},
function _(e,n,r,t,a){t();var o,i=e(1),c=e(170),u=e(174),l=e(116),_=function(e){function n(n){return e.call(this,n)||this}return(0,i.__extends)(n,e),n.prototype.connect_signals=function(){var n=this;e.prototype.connect_signals.call(this);var r=this.properties,t=r.source_range,a=r.target_range;this.on_change([t,a],(function(){n.linear_scale=new u.LinearScale({source_range:n.source_range,target_range:n.target_range})}))},Object.defineProperty(n.prototype,"s_compute",{get:function(){throw new Error("not implemented")},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"s_invert",{get:function(){throw new Error("not implemented")},enumerable:!1,configurable:!0}),n.prototype.compute=function(e){return e},n.prototype.v_compute=function(e){for(var n=this.binning,r=this.source_range,t=r.start,a=r.end,o=t,i=a,c=n.length,u=(a-t)/(c-1),_=new Float64Array(c),p=0;p<c;p++)_[p]=t+p*u;var g=(0,l.map)(e,(function(e){if(e<o)return o;if(e>i)return i;var r=(0,l.left_edge_index)(e,n);if(-1==r)return o;if(r>=c-1)return i;var t=n[r],a=(e-t)/(n[r+1]-t),u=_[r];return u+a*(_[r+1]-u)}));return this.linear_scale.v_compute(g)},n.prototype.invert=function(e){return e},n.prototype.v_invert=function(e){return new Float64Array(e)},n}(c.Scale);r.LinearInterpolationScale=_,o=_,_.__name__="LinearInterpolationScale",o.internal((function(e){return{binning:[e.Arrayable],linear_scale:[(0,e.Ref)(u.LinearScale),function(e){return new u.LinearScale({source_range:e.source_range,target_range:e.target_range})}]}}))},
function _(a,n,e,g,R){g(),R("DataRange",a(179).DataRange),R("DataRange1d",a(178).DataRange1d),R("FactorRange",a(182).FactorRange),R("Range",a(172).Range),R("Range1d",a(173).Range1d)},
function _(a,o,i,t,e){t();var n=a(239);e("Sizeable",n.Sizeable),e("SizingPolicy",n.SizingPolicy);var c=a(240);e("Layoutable",c.Layoutable),e("LayoutItem",c.LayoutItem);var r=a(323);e("HStack",r.HStack),e("VStack",r.VStack);var l=a(324);e("Grid",l.Grid),e("Row",l.Row),e("Column",l.Column);var S=a(325);e("ContentBox",S.ContentBox),e("VariadicBox",S.VariadicBox)},
function _(t,e,r,n,i){n();var h=t(1),a=t(240),o=t(180),l=function(t){function e(){var e=t.apply(this,(0,h.__spreadArray)([],(0,h.__read)(arguments),!1))||this;return e.children=[],e}return(0,h.__extends)(e,t),e.prototype[Symbol.iterator]=function(){return(0,h.__generator)(this,(function(t){switch(t.label){case 0:return[5,(0,h.__values)(this.children)];case 1:return t.sent(),[2]}}))},e}(a.Layoutable);r.Stack=l,l.__name__="Stack";var u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,h.__extends)(e,t),e.prototype._measure=function(t){var e,r,n=0,i=0;try{for(var a=(0,h.__values)(this.children),o=a.next();!o.done;o=a.next()){var l=o.value.measure({width:0,height:0});n+=l.width,i=Math.max(i,l.height)}}catch(t){e={error:t}}finally{try{o&&!o.done&&(r=a.return)&&r.call(a)}finally{if(e)throw e.error}}return{width:n,height:i}},e.prototype._set_geometry=function(e,r){var n,i;t.prototype._set_geometry.call(this,e,r);var a=this.absolute?e.top:0,l=this.absolute?e.left:0,u=e.height;try{for(var s=(0,h.__values)(this.children),c=s.next();!c.done;c=s.next()){var _=c.value,d=_.measure({width:0,height:0}).width;_.set_geometry(new o.BBox({left:l,width:d,top:a,height:u})),l+=d}}catch(t){n={error:t}}finally{try{c&&!c.done&&(i=s.return)&&i.call(s)}finally{if(n)throw n.error}}},e}(l);r.HStack=u,u.__name__="HStack";var s=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,h.__extends)(e,t),e.prototype._measure=function(t){var e,r,n=0,i=0;try{for(var a=(0,h.__values)(this.children),o=a.next();!o.done;o=a.next()){var l=o.value.measure({width:0,height:0});n=Math.max(n,l.width),i+=l.height}}catch(t){e={error:t}}finally{try{o&&!o.done&&(r=a.return)&&r.call(a)}finally{if(e)throw e.error}}return{width:n,height:i}},e.prototype._set_geometry=function(e,r){var n,i;t.prototype._set_geometry.call(this,e,r);var a=this.absolute?e.left:0,l=this.absolute?e.top:0,u=e.width;try{for(var s=(0,h.__values)(this.children),c=s.next();!c.done;c=s.next()){var _=c.value,d=_.measure({width:0,height:0}).height;_.set_geometry(new o.BBox({top:l,height:d,left:a,width:u})),l+=d}}catch(t){n={error:t}}finally{try{c&&!c.done&&(i=s.return)&&i.call(s)}finally{if(n)throw n.error}}},e}(l);r.VStack=s,s.__name__="VStack";var c=function(t){function e(){var e=t.apply(this,(0,h.__spreadArray)([],(0,h.__read)(arguments),!1))||this;return e.children=[],e}return(0,h.__extends)(e,t),e.prototype[Symbol.iterator]=function(){return(0,h.__generator)(this,(function(t){switch(t.label){case 0:return[5,(0,h.__values)(this.children)];case 1:return t.sent(),[2]}}))},e.prototype._measure=function(t){var e,r,n=this,i=this.sizing,a=i.width_policy,o=i.height_policy,l=Math.min,u=Math.max,s=0,c=0;try{for(var _=(0,h.__values)(this.children),d=_.next();!d.done;d=_.next()){var f=d.value.measure(t),g=f.width,y=f.height;s=u(s,g),c=u(c,y)}}catch(t){e={error:t}}finally{try{d&&!d.done&&(r=_.return)&&r.call(_)}finally{if(e)throw e.error}}return{width:function(){var e=n.sizing.width;if(t.width==1/0)return"fixed"==a&&null!=e?e:s;switch(a){case"fixed":return null!=e?e:s;case"min":return s;case"fit":return null!=e?l(t.width,e):t.width;case"max":return null!=e?u(t.width,e):t.width}}(),height:function(){var e=n.sizing.height;if(t.height==1/0)return"fixed"==o&&null!=e?e:c;switch(o){case"fixed":return null!=e?e:c;case"min":return c;case"fit":return null!=e?l(t.height,e):t.height;case"max":return null!=e?u(t.height,e):t.height}}()}},e.prototype._set_geometry=function(e,r){var n,i;t.prototype._set_geometry.call(this,e,r);var a=this.absolute?e:e.relative(),l=a.left,u=a.right,s=a.top,c=a.bottom,_=Math.round(a.vcenter),d=Math.round(a.hcenter),f=function(t){var r=t.sizing,n=r.margin,i=r.halign,h=r.valign,a=t.measure(e),f=a.width,g=a.height,y=a.inner,w=function(){switch(h+"_"+i){case"start_start":return new o.BBox({left:l+n.left,top:s+n.top,width:f,height:g});case"start_center":return new o.BBox({hcenter:d,top:s+n.top,width:f,height:g});case"start_end":return new o.BBox({right:u-n.right,top:s+n.top,width:f,height:g});case"center_start":return new o.BBox({left:l+n.left,vcenter:_,width:f,height:g});case"center_center":return new o.BBox({hcenter:d,vcenter:_,width:f,height:g});case"center_end":return new o.BBox({right:u-n.right,vcenter:_,width:f,height:g});case"end_start":return new o.BBox({left:l+n.left,bottom:c-n.bottom,width:f,height:g});case"end_center":return new o.BBox({hcenter:d,bottom:c-n.bottom,width:f,height:g});case"end_end":return new o.BBox({right:u-n.right,bottom:c-n.bottom,width:f,height:g})}}(),v=null==y?w:new o.BBox({left:w.left+y.left,top:w.top+y.top,right:w.right-y.right,bottom:w.bottom-y.bottom});t.set_geometry(w,v)};try{for(var g=(0,h.__values)(this.children),y=g.next();!y.done;y=g.next()){f(y.value)}}catch(t){n={error:t}}finally{try{y&&!y.done&&(i=g.return)&&i.call(g)}finally{if(n)throw n.error}}},e}(a.Layoutable);r.NodeLayout=c,c.__name__="NodeLayout"},
function _(t,i,r,e,n){e();var o=t(1),a=t(239),s=t(240),l=t(125),c=t(180),h=t(126),u=Math.max,f=Math.round,p=function(){function t(t){this.def=t,this._map=new Map}return t.prototype.get=function(t){var i=this._map.get(t);return void 0===i&&(i=this.def(),this._map.set(t,i)),i},t.prototype.apply=function(t,i){var r=this.get(t);this._map.set(t,i(r))},t}();p.__name__="DefaultMap";var _=function(){function t(){this._items=[],this._nrows=0,this._ncols=0}return Object.defineProperty(t.prototype,"nrows",{get:function(){return this._nrows},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"ncols",{get:function(){return this._ncols},enumerable:!1,configurable:!0}),t.prototype.add=function(t,i){var r=t.r1,e=t.c1;this._nrows=u(this._nrows,r+1),this._ncols=u(this._ncols,e+1),this._items.push({span:t,data:i})},t.prototype.at=function(t,i){return this._items.filter((function(r){var e=r.span;return e.r0<=t&&t<=e.r1&&e.c0<=i&&i<=e.c1})).map((function(t){return t.data}))},t.prototype.row=function(t){return this._items.filter((function(i){var r=i.span;return r.r0<=t&&t<=r.r1})).map((function(t){return t.data}))},t.prototype.col=function(t){return this._items.filter((function(i){var r=i.span;return r.c0<=t&&t<=r.c1})).map((function(t){return t.data}))},t.prototype.foreach=function(t){var i,r;try{for(var e=(0,o.__values)(this._items),n=e.next();!n.done;n=e.next()){var a=n.value;t(a.span,a.data)}}catch(t){i={error:t}}finally{try{n&&!n.done&&(r=e.return)&&r.call(e)}finally{if(i)throw i.error}}},t.prototype.map=function(i){var r,e,n=new t;try{for(var a=(0,o.__values)(this._items),s=a.next();!s.done;s=a.next()){var l=s.value,c=l.span,h=l.data;n.add(c,i(c,h))}}catch(t){r={error:t}}finally{try{s&&!s.done&&(e=a.return)&&e.call(a)}finally{if(r)throw r.error}}return n},t}();_.__name__="Container";var g=function(t){function i(i){void 0===i&&(i=[]);var r=t.call(this)||this;return r.items=i,r.rows="auto",r.cols="auto",r.spacing=0,r}return(0,o.__extends)(i,t),i.prototype[Symbol.iterator]=function(){var t,i,r,e,n;return(0,o.__generator)(this,(function(a){switch(a.label){case 0:a.trys.push([0,5,6,7]),t=(0,o.__values)(this.items),i=t.next(),a.label=1;case 1:return i.done?[3,4]:[4,i.value.layout];case 2:a.sent(),a.label=3;case 3:return i=t.next(),[3,1];case 4:return[3,7];case 5:return r=a.sent(),e={error:r},[3,7];case 6:try{i&&!i.done&&(n=t.return)&&n.call(t)}finally{if(e)throw e.error}return[7];case 7:return[2]}}))},i.prototype.is_width_expanding=function(){if(t.prototype.is_width_expanding.call(this))return!0;if("fixed"==this.sizing.width_policy)return!1;var i=this._state.cols;return(0,h.some)(i,(function(t){return"max"==t.policy}))},i.prototype.is_height_expanding=function(){if(t.prototype.is_height_expanding.call(this))return!0;if("fixed"==this.sizing.height_policy)return!1;var i=this._state.rows;return(0,h.some)(i,(function(t){return"max"==t.policy}))},i.prototype._init=function(){var i,r,e,n,a,s,c=this;t.prototype._init.call(this);var u=new _;try{for(var f=(0,o.__values)(this.items),p=f.next();!p.done;p=f.next()){var g=p.value,d=g.layout,y=g.row,w=g.col,v=g.row_span,m=g.col_span;if(d.sizing.visible){var x=y,b=w,z=y+(null!=v?v:1)-1,B=w+(null!=m?m:1)-1;u.add({r0:x,c0:b,r1:z,c1:B},d)}}}catch(t){i={error:t}}finally{try{p&&!p.done&&(r=f.return)&&r.call(f)}finally{if(i)throw i.error}}for(var j=u.nrows,A=u.ncols,M=new Array(j),O=function(t){var i=function(){var i,r=(0,l.isPlainObject)(c.rows)?null!==(i=c.rows[t])&&void 0!==i?i:c.rows["*"]:c.rows;return null==r?{policy:"auto"}:(0,l.isNumber)(r)?{policy:"fixed",height:r}:(0,l.isString)(r)?{policy:r}:r}(),r=null!==(e=i.align)&&void 0!==e?e:"auto";if("fixed"==i.policy)M[t]={policy:"fixed",height:i.height,align:r};else if("min"==i.policy)M[t]={policy:"min",align:r};else if("fit"==i.policy||"max"==i.policy)M[t]={policy:i.policy,flex:null!==(n=i.flex)&&void 0!==n?n:1,align:r};else{if("auto"!=i.policy)throw new Error("unrechable");(0,h.some)(u.row(t),(function(t){return t.is_height_expanding()}))?M[t]={policy:"max",flex:1,align:r}:M[t]={policy:"min",align:r}}},P=0;P<j;P++)O(P);for(var S=new Array(A),C=function(t){var i=function(){var i,r=(0,l.isPlainObject)(c.cols)?null!==(i=c.cols[t])&&void 0!==i?i:c.cols["*"]:c.cols;return null==r?{policy:"auto"}:(0,l.isNumber)(r)?{policy:"fixed",width:r}:(0,l.isString)(r)?{policy:r}:r}(),r=null!==(a=i.align)&&void 0!==a?a:"auto";if("fixed"==i.policy)S[t]={policy:"fixed",width:i.width,align:r};else if("min"==i.policy)S[t]={policy:"min",align:r};else if("fit"==i.policy||"max"==i.policy)S[t]={policy:i.policy,flex:null!==(s=i.flex)&&void 0!==s?s:1,align:r};else{if("auto"!=i.policy)throw new Error("unrechable");(0,h.some)(u.col(t),(function(t){return t.is_width_expanding()}))?S[t]={policy:"max",flex:1,align:r}:S[t]={policy:"min",align:r}}},N=0;N<A;N++)C(N);var E=(0,o.__read)((0,l.isNumber)(this.spacing)?[this.spacing,this.spacing]:this.spacing,2),G=E[0],R=E[1];this._state={items:u,nrows:j,ncols:A,rows:M,cols:S,rspacing:G,cspacing:R}},i.prototype._measure_totals=function(t,i){var r=this._state,e=r.nrows,n=r.ncols,o=r.rspacing,a=r.cspacing;return{height:(0,h.sum)(t)+(e-1)*o,width:(0,h.sum)(i)+(n-1)*a}},i.prototype._measure_cells=function(t){for(var i=this._state,r=i.items,e=i.nrows,n=i.ncols,s=i.rows,l=i.cols,c=i.rspacing,h=i.cspacing,p=new Array(e),g=0;g<e;g++){var d=s[g];p[g]="fixed"==d.policy?d.height:0}for(var y=new Array(n),w=0;w<n;w++){var v=l[w];y[w]="fixed"==v.policy?v.width:0}var m=new _;return r.foreach((function(i,r){for(var e,n,_,g,d=i.r0,w=i.c0,v=i.r1,x=i.c1,b=(v-d)*c,z=(x-w)*h,B=0,j=d;j<=v;j++)B+=t(j,w).height;B+=b;for(var A=0,M=w;M<=x;M++)A+=t(d,M).width;A+=z;var O=r.measure({width:A,height:B});m.add(i,{layout:r,size_hint:O});var P=new a.Sizeable(O).grow_by(r.sizing.margin);P.height-=b,P.width-=z;var S=[];for(j=d;j<=v;j++){var C=s[j];"fixed"==C.policy?P.height-=C.height:S.push(j)}if(P.height>0){var N=f(P.height/S.length);try{for(var E=(0,o.__values)(S),G=E.next();!G.done;G=E.next()){j=G.value;p[j]=u(p[j],N)}}catch(t){e={error:t}}finally{try{G&&!G.done&&(n=E.return)&&n.call(E)}finally{if(e)throw e.error}}}var R=[];for(M=w;M<=x;M++){var D=l[M];"fixed"==D.policy?P.width-=D.width:R.push(M)}if(P.width>0){var L=f(P.width/R.length);try{for(var k=(0,o.__values)(R),q=k.next();!q.done;q=k.next()){M=q.value;y[M]=u(y[M],L)}}catch(t){_={error:t}}finally{try{q&&!q.done&&(g=k.return)&&g.call(k)}finally{if(_)throw _.error}}}})),{size:this._measure_totals(p,y),row_heights:p,col_widths:y,size_hints:m}},i.prototype._measure_grid=function(t){var i,r=this._state,e=r.nrows,n=r.ncols,o=r.rows,a=r.cols,s=r.rspacing,l=r.cspacing,c=this._measure_cells((function(t,i){var r=o[t],e=a[i];return{width:"fixed"==e.policy?e.width:1/0,height:"fixed"==r.policy?r.height:1/0}}));i="fixed"==this.sizing.height_policy&&null!=this.sizing.height?this.sizing.height:t.height!=1/0&&this.is_height_expanding()?t.height:c.size.height;for(var h,p=0,_=0;_<e;_++){"fit"==(y=o[_]).policy||"max"==y.policy?p+=y.flex:i-=c.row_heights[_]}if(i-=(e-1)*s,0!=p&&i>0)for(_=0;_<e;_++){if("fit"==(y=o[_]).policy||"max"==y.policy)i-=w=f(i*(y.flex/p)),c.row_heights[_]=w,p-=y.flex}else if(i<0){var g=0;for(_=0;_<e;_++){"fixed"!=(y=o[_]).policy&&g++}var d=-i;for(_=0;_<e;_++){var y;if("fixed"!=(y=o[_]).policy){var w=c.row_heights[_],v=f(d/g);c.row_heights[_]=u(w-v,0),d-=v>w?w:v,g--}}}h="fixed"==this.sizing.width_policy&&null!=this.sizing.width?this.sizing.width:t.width!=1/0&&this.is_width_expanding()?t.width:c.size.width;for(var m=0,x=0;x<n;x++){"fit"==(z=a[x]).policy||"max"==z.policy?m+=z.flex:h-=c.col_widths[x]}if(h-=(n-1)*l,0!=m&&h>0)for(x=0;x<n;x++){if("fit"==(z=a[x]).policy||"max"==z.policy)h-=B=f(h*(z.flex/m)),c.col_widths[x]=B,m-=z.flex}else if(h<0){for(g=0,x=0;x<n;x++){"fixed"!=(z=a[x]).policy&&g++}var b=-h;for(x=0;x<n;x++){var z;if("fixed"!=(z=a[x]).policy){var B=c.col_widths[x];v=f(b/g);c.col_widths[x]=u(B-v,0),b-=v>B?B:v,g--}}}var j=this._measure_cells((function(t,i){return{width:c.col_widths[i],height:c.row_heights[t]}})),A=j.row_heights,M=j.col_widths,O=j.size_hints;return{size:this._measure_totals(A,M),row_heights:A,col_widths:M,size_hints:O}},i.prototype._measure=function(t){return this._measure_grid(t).size},i.prototype._set_geometry=function(i,r){var e=this;t.prototype._set_geometry.call(this,i,r);for(var n=this._state,a=n.nrows,s=n.ncols,l=n.rspacing,h=n.cspacing,_=this._measure_grid(i),g=_.row_heights,d=_.col_widths,y=_.size_hints,w=this._state.rows.map((function(t,i){return(0,o.__assign)((0,o.__assign)({},t),{top:0,height:g[i],get bottom(){return this.top+this.height}})})),v=this._state.cols.map((function(t,i){return(0,o.__assign)((0,o.__assign)({},t),{left:0,width:d[i],get right(){return this.left+this.width}})})),m=y.map((function(t,i){return(0,o.__assign)((0,o.__assign)({},i),{outer:new c.BBox,inner:new c.BBox})})),x=0,b=this.absolute?i.top:0;x<a;x++){var z=w[x];z.top=b,b+=z.height+l}for(var B=0,j=this.absolute?i.left:0;B<s;B++){var A=v[B];A.left=j,j+=A.width+h}m.foreach((function(t,i){var r=t.r0,e=t.c0,n=t.r1,o=t.c1,a=i.layout,s=i.size_hint,u=a.sizing,p=s.width,_=s.height,g=function(t,i){for(var r=(i-t)*h,e=t;e<=i;e++)r+=v[e].width;return r}(e,o),d=function(t,i){for(var r=(i-t)*l,e=t;e<=i;e++)r+=w[e].height;return r}(r,n),y=e==o&&"auto"!=v[e].align?v[e].align:u.halign,m=r==n&&"auto"!=w[r].align?w[r].align:u.valign,x=v[e].left;"start"==y?x+=u.margin.left:"center"==y?x+=f((g-p)/2):"end"==y&&(x+=g-u.margin.right-p);var b=w[r].top;"start"==m?b+=u.margin.top:"center"==m?b+=f((d-_)/2):"end"==m&&(b+=d-u.margin.bottom-_),i.outer=new c.BBox({left:x,top:b,width:p,height:_})}));var M=w.map((function(){return{start:new p((function(){return 0})),end:new p((function(){return 0}))}})),O=v.map((function(){return{start:new p((function(){return 0})),end:new p((function(){return 0}))}}));m.foreach((function(t,i){var r=t.r0,e=t.c0,n=t.r1,o=t.c1,a=i.size_hint,s=i.outer,l=a.inner;null!=l&&(M[r].start.apply(s.top,(function(t){return u(t,l.top)})),M[n].end.apply(w[n].bottom-s.bottom,(function(t){return u(t,l.bottom)})),O[e].start.apply(s.left,(function(t){return u(t,l.left)})),O[o].end.apply(v[o].right-s.right,(function(t){return u(t,l.right)})))})),m.foreach((function(t,i){var r=t.r0,n=t.c0,o=t.r1,a=t.c1,s=i.size_hint,l=i.outer,h=function(t){var i=e.absolute?l:l.relative(),r=i.left+t.left,n=i.top+t.top,o=i.right-t.right,a=i.bottom-t.bottom;return new c.BBox({left:r,top:n,right:o,bottom:a})};if(null!=s.inner){var u=h(s.inner);if(!1!==s.align){var f=M[r].start.get(l.top),p=M[o].end.get(w[o].bottom-l.bottom),_=O[n].start.get(l.left),g=O[a].end.get(v[a].right-l.right);try{u=h({top:f,bottom:p,left:_,right:g})}catch(t){}}i.inner=u}else i.inner=l})),m.foreach((function(t,i){var r=i.layout,e=i.outer,n=i.inner;r.set_geometry(e,n)}))},i}(s.Layoutable);r.Grid=g,g.__name__="Grid";var d=function(t){function i(i){var r=t.call(this)||this;return r.items=i.map((function(t,i){return{layout:t,row:0,col:i}})),r.rows="fit",r}return(0,o.__extends)(i,t),i}(g);r.Row=d,d.__name__="Row";var y=function(t){function i(i){var r=t.call(this)||this;return r.items=i.map((function(t,i){return{layout:t,row:i,col:0}})),r.cols="fit",r}return(0,o.__extends)(i,t),i}(g);r.Column=y,y.__name__="Column"},
function _(e,t,n,i,a){i();var r=e(1),o=e(240),c=e(239),_=e(158),u=function(e){function t(t){var n=e.call(this)||this;return n.content_size=(0,_.unsized)(t,(function(){return new c.Sizeable((0,_.size)(t))})),n}return(0,r.__extends)(t,e),t.prototype._content_size=function(){return this.content_size},t}(o.ContentLayoutable);n.ContentBox=u,u.__name__="ContentBox";var s=function(e){function t(t){var n=e.call(this)||this;return n.el=t,n}return(0,r.__extends)(t,e),t.prototype._measure=function(e){var t=this,n=new c.Sizeable(e).bounded_to(this.sizing.size);return(0,_.sized)(this.el,n,(function(){var e=new c.Sizeable((0,_.content_size)(t.el)),n=(0,_.extents)(t.el),i=n.border,a=n.padding;return e.grow_by(i).grow_by(a).map(Math.ceil)}))},t}(o.Layoutable);n.VariadicBox=s,s.__name__="VariadicBox";var h=function(e){function t(t){var n=e.call(this,t)||this;return n._cache=new Map,n}return(0,r.__extends)(t,e),t.prototype._measure=function(t){var n=t.width+","+t.height,i=this._cache.get(n);return null==i&&(i=e.prototype._measure.call(this,t),this._cache.set(n,i)),i},t.prototype.invalidate_cache=function(){this._cache.clear()},t}(s);n.CachedVariadicBox=h,h.__name__="CachedVariadicBox"},
function _(t,e,i,h,r){h();var o=t(1),n=t(239),s=t(240),a=t(180),g=function(t){function e(){var e=t.apply(this,(0,o.__spreadArray)([],(0,o.__read)(arguments),!1))||this;return e.min_border={left:0,top:0,right:0,bottom:0},e.padding={left:0,top:0,right:0,bottom:0},e}return(0,o.__extends)(e,t),e.prototype[Symbol.iterator]=function(){return(0,o.__generator)(this,(function(t){switch(t.label){case 0:return[4,this.top_panel];case 1:return t.sent(),[4,this.bottom_panel];case 2:return t.sent(),[4,this.left_panel];case 3:return t.sent(),[4,this.right_panel];case 4:return t.sent(),[4,this.center_panel];case 5:return t.sent(),[2]}}))},e.prototype._measure=function(t){var e=this;t=new n.Sizeable({width:"fixed"==this.sizing.width_policy||t.width==1/0?this.sizing.width:t.width,height:"fixed"==this.sizing.height_policy||t.height==1/0?this.sizing.height:t.height});var i,h,r,o=this.left_panel.measure({width:0,height:t.height}),s=Math.max(o.width,this.min_border.left)+this.padding.left,a=this.right_panel.measure({width:0,height:t.height}),g=Math.max(a.width,this.min_border.right)+this.padding.right,p=this.top_panel.measure({width:t.width,height:0}),_=Math.max(p.height,this.min_border.top)+this.padding.top,d=this.bottom_panel.measure({width:t.width,height:0}),l=Math.max(d.height,this.min_border.bottom)+this.padding.bottom,m=new n.Sizeable(t).shrink_by({left:s,right:g,top:_,bottom:l}),w=this.center_panel.measure(m);return{width:s+w.width+g,height:_+w.height+l,inner:{left:s,right:g,top:_,bottom:l},align:(i=e.center_panel.sizing,h=i.width_policy,r=i.height_policy,"fixed"!=h&&"fixed"!=r)}},e.prototype._set_geometry=function(e,i){t.prototype._set_geometry.call(this,e,i),this.center_panel.set_geometry(i);var h=this.left_panel.measure({width:0,height:e.height}),r=this.right_panel.measure({width:0,height:e.height}),o=this.top_panel.measure({width:e.width,height:0}),n=this.bottom_panel.measure({width:e.width,height:0}),s=i.left,g=i.top,p=i.right,_=i.bottom;this.top_panel.set_geometry(new a.BBox({left:s,right:p,bottom:g,height:o.height})),this.bottom_panel.set_geometry(new a.BBox({left:s,right:p,top:_,height:n.height})),this.left_panel.set_geometry(new a.BBox({top:g,bottom:_,right:s,width:h.width})),this.right_panel.set_geometry(new a.BBox({top:g,bottom:_,left:p,width:r.width}))},e}(s.Layoutable);i.BorderLayout=g,g.__name__="BorderLayout"},
function _(t,e,i,n,o){n();var s,l=t(1),a=t(234),r=t(117),_=t(135),u=t(235),d=t(238),h=(0,l.__importStar)(t(163)),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,l.__extends)(e,t),e.prototype.update_layout=function(){var t=this,e=this.panel;this.layout=null!=e?new d.SideLayout(e,(function(){return t.get_size()}),!1):void 0},e.prototype._get_size=function(){var t=this.model.text,e=new u.TextBox({text:t}),i=this.model,n=i.angle,o=i.angle_units;e.angle=(0,r.resolve_angle)(n,o),e.visuals=this.visuals.text.values();var s=e.size();return{width:s.width,height:s.height}},e.prototype._render=function(){var t=this.model,e=t.angle,i=t.angle_units,n=(0,r.resolve_angle)(e,i),o=null!=this.layout?this.layout:this.plot_view.frame,s=this.coordinates.x_scale,l=this.coordinates.y_scale,a="data"==this.model.x_units?s.compute(this.model.x):o.bbox.xview.compute(this.model.x),_="data"==this.model.y_units?l.compute(this.model.y):o.bbox.yview.compute(this.model.y);a+=this.model.x_offset,_-=this.model.y_offset,("canvas"==this.model.render_mode?this._canvas_text.bind(this):this._css_text.bind(this))(this.layer.ctx,this.model.text,a,_,n)},e}(a.TextAnnotationView);i.LabelView=c,c.__name__="LabelView";var x=function(t){function e(e){return t.call(this,e)||this}return(0,l.__extends)(e,t),e}(a.TextAnnotation);i.Label=x,s=x,x.__name__="Label",s.prototype.default_view=c,s.mixins([h.Text,["border_",h.Line],["background_",h.Fill]]),s.define((function(t){var e=t.Number,i=t.String,n=t.Angle;return{x:[e],x_units:[_.SpatialUnits,"data"],y:[e],y_units:[_.SpatialUnits,"data"],text:[i,""],angle:[n,0],angle_units:[_.AngleUnits,"rad"],x_offset:[e,0],y_offset:[e,0]}})),s.override({background_fill_color:null,border_line_color:null})},
function _(t,e,i,s,r){s();var o,n=t(1),l=t(184),a=(0,n.__importStar)(t(163)),_=t(135),u=t(158),d=t(235),c=(0,n.__importStar)(t(133)),h=t(127),v=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,n.__extends)(e,t),e.prototype.set_data=function(e){var i,s,r;if(t.prototype.set_data.call(this,e),null===(r=this.els)||void 0===r||r.forEach((function(t){return(0,u.remove)(t)})),"css"==this.model.render_mode){var o=this.els=(0,n.__spreadArray)([],(0,n.__read)(this.text),!1).map((function(){return(0,u.div)({style:{display:"none"}})}));try{for(var l=(0,n.__values)(o),a=l.next();!a.done;a=l.next()){var _=a.value;this.plot_view.canvas_view.add_overlay(_)}}catch(t){i={error:t}}finally{try{a&&!a.done&&(s=l.return)&&s.call(l)}finally{if(i)throw i.error}}}else delete this.els},e.prototype.remove=function(){var e;null===(e=this.els)||void 0===e||e.forEach((function(t){return(0,u.remove)(t)})),t.prototype.remove.call(this)},e.prototype._rerender=function(){"css"==this.model.render_mode?this.render():this.request_render()},e.prototype.map_data=function(){var t=this.coordinates,e=t.x_scale,i=t.y_scale,s=null!=this.layout?this.layout:this.plot_view.frame;this.sx="data"==this.model.x_units?e.v_compute(this._x):s.bbox.xview.v_compute(this._x),this.sy="data"==this.model.y_units?i.v_compute(this._y):s.bbox.yview.v_compute(this._y)},e.prototype.paint=function(){for(var t="canvas"==this.model.render_mode?this._v_canvas_text.bind(this):this._v_css_text.bind(this),e=this.layer.ctx,i=0,s=this.text.length;i<s;i++){var r=this.x_offset.get(i),o=this.y_offset.get(i),n=this.sx[i]+r,l=this.sy[i]-o,a=this.angle.get(i);t(e,i,this.text.get(i),n,l,a)}},e.prototype._v_canvas_text=function(t,e,i,s,r,o){var n=new d.TextBox({text:i});n.angle=o,n.position={sx:s,sy:r},n.visuals=this.visuals.text.values(e);var l=this.visuals,a=l.background_fill,_=l.border_line;if(a.doit||_.doit){var u=n.rect(),c=u.p0,h=u.p1,v=u.p2,p=u.p3;t.beginPath(),t.moveTo(c.x,c.y),t.lineTo(h.x,h.y),t.lineTo(v.x,v.y),t.lineTo(p.x,p.y),t.closePath(),this.visuals.background_fill.apply(t,e),this.visuals.border_line.apply(t,e)}this.visuals.text.doit&&n.paint(t)},e.prototype._v_css_text=function(t,e,i,s,r,o){var l=this;(0,h.assert)(null!=this.els);var a=this.els[e];a.textContent=i,this.visuals.text.set_vectorize(t,e),a.style.position="absolute",a.style.left=s+"px",a.style.top=r+"px",a.style.color=t.fillStyle,a.style.font=t.font,a.style.lineHeight="normal",a.style.whiteSpace="pre";var _=(0,n.__read)(function(){switch(l.visuals.text.text_align.get(e)){case"left":return["left","0%"];case"center":return["center","-50%"];case"right":return["right","-100%"]}}(),2),d=_[0],c=_[1],v=(0,n.__read)(function(){switch(l.visuals.text.text_baseline.get(e)){case"top":return["top","0%"];case"middle":return["center","-50%"];case"bottom":return["bottom","-100%"];default:return["center","-50%"]}}(),2),p=v[0],y="translate("+c+", "+v[1]+")";o&&(y+="rotate("+o+"rad)"),a.style.transformOrigin=d+" "+p,a.style.transform=y,this.layout,this.visuals.background_fill.doit&&(this.visuals.background_fill.set_vectorize(t,e),a.style.backgroundColor=t.fillStyle),this.visuals.border_line.doit&&(this.visuals.border_line.set_vectorize(t,e),a.style.borderStyle=t.lineDash.length<2?"solid":"dashed",a.style.borderWidth=t.lineWidth+"px",a.style.borderColor=t.strokeStyle),(0,u.display)(a)},e}(l.DataAnnotationView);i.LabelSetView=v,v.__name__="LabelSetView";var p=function(t){function e(e){return t.call(this,e)||this}return(0,n.__extends)(e,t),e}(l.DataAnnotation);i.LabelSet=p,o=p,p.__name__="LabelSet",o.prototype.default_view=v,o.mixins([a.TextVector,["border_",a.LineVector],["background_",a.FillVector]]),o.define((function(){return{x:[c.XCoordinateSpec,{field:"x"}],y:[c.YCoordinateSpec,{field:"y"}],x_units:[_.SpatialUnits,"data"],y_units:[_.SpatialUnits,"data"],text:[c.StringSpec,{field:"text"}],angle:[c.AngleSpec,0],x_offset:[c.NumberSpec,{value:0}],y_offset:[c.NumberSpec,{value:0}],render_mode:[_.RenderMode,"canvas"]}})),o.override({background_fill_color:null,border_line_color:null})},
function _(e,t,i,r,l){r();var n,a=e(1),o=e(155),s=e(330),_=e(135),h=(0,a.__importStar)(e(163)),d=e(130),c=e(238),u=e(236),f=e(180),v=e(126),g=e(125),m=e(127),p=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(t,e),t.prototype.update_layout=function(){var e=this,t=this.panel;this.layout=null!=t?new c.SideLayout(t,(function(){return e.get_size()})):void 0},t.prototype.cursor=function(e,t){return"none"==this.model.click_policy?null:"pointer"},Object.defineProperty(t.prototype,"legend_padding",{get:function(){return null!=this.model.border_line_color?this.model.padding:0},enumerable:!1,configurable:!0}),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return t.request_render()})),this.connect(this.model.item_change,(function(){return t.request_render()}))},t.prototype.compute_legend_bbox=function(){var e,t,i,r,l=this.model.get_legend_names(),n=this.model,o=n.glyph_height,s=n.glyph_width,_=this.model,h=_.label_height,d=_.label_width;this.max_label_height=(0,v.max)([(0,u.font_metrics)(this.visuals.label_text.font_value()).height,h,o]);var c=this.layer.ctx;c.save(),this.visuals.label_text.set_value(c),this.text_widths=new Map;try{for(var p=(0,a.__values)(l),y=p.next();!y.done;y=p.next()){var x=y.value;this.text_widths.set(x,(0,v.max)([c.measureText(x).width,d]))}}catch(t){e={error:t}}finally{try{y&&!y.done&&(t=p.return)&&t.call(p)}finally{if(e)throw e.error}}this.visuals.title_text.set_value(c),this.title_height=this.model.title?(0,u.font_metrics)(this.visuals.title_text.font_value()).height+this.model.title_standoff:0,this.title_width=this.model.title?c.measureText(this.model.title).width:0,c.restore();var b,w,k=Math.max((0,v.max)((0,a.__spreadArray)([],(0,a.__read)(this.text_widths.values()),!1)),0),L=this.model.margin,T=this.legend_padding,z=this.model.spacing,A=this.model.label_standoff;if("vertical"==this.model.orientation)b=l.length*this.max_label_height+Math.max(l.length-1,0)*z+2*T+this.title_height,w=(0,v.max)([k+s+A+2*T,this.title_width+2*T]);else{var S=2*T+Math.max(l.length-1,0)*z;try{for(var B=(0,a.__values)(this.text_widths),M=B.next();!M.done;M=B.next()){var P=(0,a.__read)(M.value,2)[1];S+=(0,v.max)([P,d])+s+A}}catch(e){i={error:e}}finally{try{M&&!M.done&&(r=B.return)&&r.call(B)}finally{if(i)throw i.error}}w=(0,v.max)([this.title_width+2*T,S]),b=this.max_label_height+this.title_height+2*T}var O,V,q=null!=this.layout?this.layout:this.plot_view.frame,F=(0,a.__read)(q.bbox.ranges,2),N=F[0],j=F[1],C=this.model.location;if((0,g.isString)(C))switch(C){case"top_left":O=N.start+L,V=j.start+L;break;case"top":case"top_center":O=(N.end+N.start)/2-w/2,V=j.start+L;break;case"top_right":O=N.end-L-w,V=j.start+L;break;case"bottom_right":O=N.end-L-w,V=j.end-L-b;break;case"bottom":case"bottom_center":O=(N.end+N.start)/2-w/2,V=j.end-L-b;break;case"bottom_left":O=N.start+L,V=j.end-L-b;break;case"left":case"center_left":O=N.start+L,V=(j.end+j.start)/2-b/2;break;case"center":case"center_center":O=(N.end+N.start)/2-w/2,V=(j.end+j.start)/2-b/2;break;case"right":case"center_right":O=N.end-L-w,V=(j.end+j.start)/2-b/2}else if((0,g.isArray)(C)&&2==C.length){var I=(0,a.__read)(C,2),R=I[0],D=I[1];O=q.bbox.xview.compute(R),V=q.bbox.yview.compute(D)-b}else(0,m.unreachable)();return new f.BBox({left:O,top:V,width:w,height:b})},t.prototype.interactive_bbox=function(){return this.compute_legend_bbox()},t.prototype.interactive_hit=function(e,t){return this.interactive_bbox().contains(e,t)},t.prototype.on_hit=function(e,t){var i,r,l,n,o,s,_,h,d,c,u,v=this.model.glyph_width,g=this.legend_padding,m=this.model.spacing,p=this.model.label_standoff,y=u=g,x=this.compute_legend_bbox(),b="vertical"==this.model.orientation;try{for(var w=(0,a.__values)(this.model.items),k=w.next();!k.done;k=w.next()){var L=k.value,T=L.get_labels_list_from_label_prop();try{for(var z=(l=void 0,(0,a.__values)(T)),A=z.next();!A.done;A=z.next()){var S=A.value,B=x.x+y,M=x.y+u+this.title_height,P=void 0,O=void 0;if(b?(P=(o=(0,a.__read)([x.width-2*g,this.max_label_height],2))[0],O=o[1]):(P=(s=(0,a.__read)([this.text_widths.get(S)+v+p,this.max_label_height],2))[0],O=s[1]),new f.BBox({left:B,top:M,width:P,height:O}).contains(e,t)){switch(this.model.click_policy){case"hide":try{for(var V=(_=void 0,(0,a.__values)(L.renderers)),q=V.next();!q.done;q=V.next()){(j=q.value).visible=!j.visible}}catch(e){_={error:e}}finally{try{q&&!q.done&&(h=V.return)&&h.call(V)}finally{if(_)throw _.error}}break;case"mute":try{for(var F=(d=void 0,(0,a.__values)(L.renderers)),N=F.next();!N.done;N=F.next()){var j;(j=N.value).muted=!j.muted}}catch(e){d={error:e}}finally{try{N&&!N.done&&(c=F.return)&&c.call(F)}finally{if(d)throw d.error}}}return!0}b?u+=this.max_label_height+m:y+=this.text_widths.get(S)+v+p+m}}catch(e){l={error:e}}finally{try{A&&!A.done&&(n=z.return)&&n.call(z)}finally{if(l)throw l.error}}}}catch(e){i={error:e}}finally{try{k&&!k.done&&(r=w.return)&&r.call(w)}finally{if(i)throw i.error}}return!1},t.prototype._render=function(){var e,t;if(0!=this.model.items.length&&(0,v.some)(this.model.items,(function(e){return e.visible}))){try{for(var i=(0,a.__values)(this.model.items),r=i.next();!r.done;r=i.next()){r.value.legend=this.model}}catch(t){e={error:t}}finally{try{r&&!r.done&&(t=i.return)&&t.call(i)}finally{if(e)throw e.error}}var l=this.layer.ctx,n=this.compute_legend_bbox();l.save(),this._draw_legend_box(l,n),this._draw_legend_items(l,n),this._draw_title(l,n),l.restore()}},t.prototype._draw_legend_box=function(e,t){e.beginPath(),e.rect(t.x,t.y,t.width,t.height),this.visuals.background_fill.apply(e),this.visuals.border_line.apply(e)},t.prototype._draw_legend_items=function(e,t){var i,r,l=this,n=this.model,o=n.glyph_width,s=n.glyph_height,_=this.legend_padding,h=this.model.spacing,d=this.model.label_standoff,c=_,u=_,f="vertical"==this.model.orientation,g=function(i){var r,n,g,p,y,x;if(!i.visible)return"continue";var b=i.get_labels_list_from_label_prop(),w=i.get_field_from_label_prop();if(0==b.length)return"continue";var k=function(){switch(l.model.click_policy){case"none":return!0;case"hide":return(0,v.every)(i.renderers,(function(e){return e.visible}));case"mute":return(0,v.every)(i.renderers,(function(e){return!e.muted}))}}();try{for(var L=(r=void 0,(0,a.__values)(b)),T=L.next();!T.done;T=L.next()){var z=T.value,A=t.x+c,S=t.y+u+m.title_height,B=A+o,M=S+s;f?u+=m.max_label_height+h:c+=m.text_widths.get(z)+o+d+h,m.visuals.label_text.set_value(e),e.fillText(z,B+d,S+m.max_label_height/2);try{for(var P=(g=void 0,(0,a.__values)(i.renderers)),O=P.next();!O.done;O=P.next()){var V=O.value,q=m.plot_view.renderer_view(V);null==q||q.draw_legend(e,A,B,S,M,w,z,i.index)}}catch(e){g={error:e}}finally{try{O&&!O.done&&(p=P.return)&&p.call(P)}finally{if(g)throw g.error}}if(!k){var F=void 0,N=void 0;f?(F=(y=(0,a.__read)([t.width-2*_,m.max_label_height],2))[0],N=y[1]):(F=(x=(0,a.__read)([m.text_widths.get(z)+o+d,m.max_label_height],2))[0],N=x[1]),e.beginPath(),e.rect(A,S,F,N),m.visuals.inactive_fill.set_value(e),e.fill()}}}catch(e){r={error:e}}finally{try{T&&!T.done&&(n=L.return)&&n.call(L)}finally{if(r)throw r.error}}},m=this;try{for(var p=(0,a.__values)(this.model.items),y=p.next();!y.done;y=p.next()){g(y.value)}}catch(e){i={error:e}}finally{try{y&&!y.done&&(r=p.return)&&r.call(p)}finally{if(i)throw i.error}}},t.prototype._draw_title=function(e,t){var i=this.model.title;i&&this.visuals.title_text.doit&&(e.save(),e.translate(t.x0,t.y0+this.title_height),this.visuals.title_text.set_value(e),e.fillText(i,this.legend_padding,this.legend_padding-this.model.title_standoff),e.restore())},t.prototype._get_size=function(){var e=this.compute_legend_bbox(),t=e.width,i=e.height;return{width:t+2*this.model.margin,height:i+2*this.model.margin}},t}(o.AnnotationView);i.LegendView=p,p.__name__="LegendView";var y=function(e){function t(t){return e.call(this,t)||this}return(0,a.__extends)(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.item_change=new d.Signal0(this,"item_change")},t.prototype.get_legend_names=function(){var e,t,i=[];try{for(var r=(0,a.__values)(this.items),l=r.next();!l.done;l=r.next()){var n=l.value.get_labels_list_from_label_prop();i.push.apply(i,(0,a.__spreadArray)([],(0,a.__read)(n),!1))}}catch(t){e={error:t}}finally{try{l&&!l.done&&(t=r.return)&&t.call(r)}finally{if(e)throw e.error}}return i},t}(o.Annotation);i.Legend=y,n=y,y.__name__="Legend",n.prototype.default_view=p,n.mixins([["label_",h.Text],["title_",h.Text],["inactive_",h.Fill],["border_",h.Line],["background_",h.Fill]]),n.define((function(e){var t=e.Number,i=e.String,r=e.Array,l=e.Tuple,n=e.Or,a=e.Ref,o=e.Nullable;return{orientation:[_.Orientation,"vertical"],location:[n(_.LegendLocation,l(t,t)),"top_right"],title:[o(i),null],title_standoff:[t,5],label_standoff:[t,5],glyph_height:[t,20],glyph_width:[t,20],label_height:[t,20],label_width:[t,20],margin:[t,10],padding:[t,10],spacing:[t,3],items:[r(a(s.LegendItem)),[]],click_policy:[_.LegendClickPolicy,"none"]}})),n.override({border_line_color:"#e5e5e5",border_line_alpha:.5,border_line_width:1,background_fill_color:"#ffffff",background_fill_alpha:.95,inactive_fill_color:"white",inactive_fill_alpha:.7,label_text_font_size:"13px",label_text_baseline:"middle",title_text_font_size:"13px",title_text_font_style:"italic"})},
function _(e,r,n,t,l){t();var i,o=e(1),a=e(168),u=e(290),s=e(185),_=e(331),d=(0,o.__importStar)(e(133)),c=e(134),f=e(126),h=function(e){function r(r){return e.call(this,r)||this}return(0,o.__extends)(r,e),r.prototype._check_data_sources_on_renderers=function(){var e,r;if(null!=this.get_field_from_label_prop()){if(this.renderers.length<1)return!1;var n=this.renderers[0].data_source;if(null!=n)try{for(var t=(0,o.__values)(this.renderers),l=t.next();!l.done;l=t.next()){if(l.value.data_source!=n)return!1}}catch(r){e={error:r}}finally{try{l&&!l.done&&(r=t.return)&&r.call(t)}finally{if(e)throw e.error}}}return!0},r.prototype._check_field_label_on_data_source=function(){var e=this.get_field_from_label_prop();if(null!=e){if(this.renderers.length<1)return!1;var r=this.renderers[0].data_source;if(null!=r&&!(0,f.includes)(r.columns(),e))return!1}return!0},r.prototype.initialize=function(){var r=this;e.prototype.initialize.call(this),this.legend=null,this.connect(this.change,(function(){var e;return null===(e=r.legend)||void 0===e?void 0:e.item_change.emit()})),this._check_data_sources_on_renderers()||c.logger.error("Non matching data sources on legend item renderers"),this._check_field_label_on_data_source()||c.logger.error("Bad column name on label: "+this.label)},r.prototype.get_field_from_label_prop=function(){var e=this.label;return(0,_.isField)(e)?e.field:null},r.prototype.get_labels_list_from_label_prop=function(){if(!this.visible)return[];if((0,_.isValue)(this.label)){var e=this.label.value;return null!=e?[e]:[]}var r=this.get_field_from_label_prop();if(null!=r){var n=void 0;if(!this.renderers[0]||null==this.renderers[0].data_source)return["No source found"];if((n=this.renderers[0].data_source)instanceof s.ColumnarDataSource){var t=n.get_column(r);return null!=t?(0,f.uniq)(Array.from(t)):["Invalid field"]}}return[]},r}(a.Model);n.LegendItem=h,i=h,h.__name__="LegendItem",i.define((function(e){var r=e.Boolean,n=e.Int,t=e.Array,l=e.Ref,i=e.Nullable;return{label:[d.NullStringSpec,null],renderers:[t(l(u.GlyphRenderer)),[]],index:[i(n),null],visible:[r,!0]}}))},
function _(i,n,e,t,r){t();var u=i(125);e.isValue=function(i){return(0,u.isPlainObject)(i)&&"value"in i},e.isField=function(i){return(0,u.isPlainObject)(i)&&"field"in i},e.isExpr=function(i){return(0,u.isPlainObject)(i)&&"expr"in i}},
function _(t,n,i,e,o){e();var s,a=t(1),l=t(155),r=(0,a.__importStar)(t(163)),c=t(135),u=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,a.__extends)(n,t),n.prototype.connect_signals=function(){var n=this;t.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return n.request_render()}))},n.prototype._render=function(){var t=this.model,n=t.xs,i=t.ys;if(n.length==i.length){var e=n.length;if(!(e<3)){var o=this.plot_view.frame,s=this.layer.ctx,a=this.coordinates.x_scale,l=this.coordinates.y_scale,r=this.model.screen,c=h(n,this.model.xs_units,a,o.bbox.xview),u=h(i,this.model.ys_units,l,o.bbox.yview);s.beginPath();for(var _=0;_<e;_++)s.lineTo(c[_],u[_]);s.closePath(),this.visuals.fill.apply(s),this.visuals.hatch.apply(s),this.visuals.line.apply(s)}}function h(t,n,i,e){return r?t:"data"==n?i.v_compute(t):e.v_compute(t)}},n}(l.AnnotationView);i.PolyAnnotationView=u,u.__name__="PolyAnnotationView";var _=function(t){function n(n){return t.call(this,n)||this}return(0,a.__extends)(n,t),n.prototype.update=function(t){var n=t.xs,i=t.ys;this.setv({xs:n,ys:i,screen:!0},{check_eq:!1})},n}(l.Annotation);i.PolyAnnotation=_,s=_,_.__name__="PolyAnnotation",s.prototype.default_view=u,s.mixins([r.Line,r.Fill,r.Hatch]),s.define((function(t){var n=t.Number,i=t.Array;return{xs:[i(n),[]],xs_units:[c.SpatialUnits,"data"],ys:[i(n),[]],ys_units:[c.SpatialUnits,"data"]}})),s.internal((function(t){return{screen:[t.Boolean,!1]}})),s.override({fill_color:"#fff9ba",fill_alpha:.4,line_color:"#cccccc",line_alpha:.3})},
function _(e,t,n,i,o){i();var r,l=e(1),a=e(155),s=(0,l.__importStar)(e(163)),c=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,l.__extends)(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return t.request_render()}))},t.prototype._render=function(){var e=this.model,t=e.gradient,n=e.y_intercept;if(null!=t&&null!=n){var i,o,r,l,a=this.plot_view.frame,s=this.coordinates.x_scale,c=this.coordinates.y_scale;if(0==t)o=i=c.compute(n),l=(r=a.bbox.left)+a.bbox.width;else{o=(i=a.bbox.top)+a.bbox.height;var u=(c.invert(i)-n)/t,_=(c.invert(o)-n)/t;r=s.compute(u),l=s.compute(_)}var p=this.layer.ctx;p.save(),p.beginPath(),this.visuals.line.set_value(p),p.moveTo(r,i),p.lineTo(l,o),p.stroke(),p.restore()}},t}(a.AnnotationView);n.SlopeView=c,c.__name__="SlopeView";var u=function(e){function t(t){return e.call(this,t)||this}return(0,l.__extends)(t,e),t}(a.Annotation);n.Slope=u,r=u,u.__name__="Slope",r.prototype.default_view=c,r.mixins(s.Line),r.define((function(e){var t=e.Number,n=e.Nullable;return{gradient:[n(t),null],y_intercept:[n(t),null]}})),r.override({line_color:"black"})},
function _(n,t,e,i,o){i();var r,a=n(1),l=n(155),s=(0,a.__importStar)(n(163)),c=n(135),_=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return(0,a.__extends)(t,n),t.prototype.connect_signals=function(){var t=this;n.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return t.plot_view.request_paint(t)}))},t.prototype._render=function(){var n=this,t=this.model.location;if(null!=t){var e,i,o,r,a=this.plot_view.frame,l=this.coordinates.x_scale,s=this.coordinates.y_scale,c=function(e,i){return"data"==n.model.location_units?e.compute(t):n.model.for_hover?t:i.compute(t)};"width"==this.model.dimension?(o=c(s,a.bbox.yview),i=a.bbox.left,r=a.bbox.width,e=this.model.line_width):(o=a.bbox.top,i=c(l,a.bbox.xview),r=this.model.line_width,e=a.bbox.height);var _=this.layer.ctx;_.save(),_.beginPath(),this.visuals.line.set_value(_),_.moveTo(i,o),"width"==this.model.dimension?_.lineTo(i+r,o):_.lineTo(i,o+e),_.stroke(),_.restore()}},t}(l.AnnotationView);e.SpanView=_,_.__name__="SpanView";var u=function(n){function t(t){return n.call(this,t)||this}return(0,a.__extends)(t,n),t}(l.Annotation);e.Span=u,r=u,u.__name__="Span",r.prototype.default_view=_,r.mixins(s.Line),r.define((function(n){var t=n.Number,e=n.Nullable;return{render_mode:[c.RenderMode,"canvas"],location:[e(t),null],location_units:[c.SpatialUnits,"data"],dimension:[c.Dimension,"width"]}})),r.internal((function(n){return{for_hover:[n.Boolean,!1]}})),r.override({line_color:"black"})},
function _(t,i,e,o,n){o();var r,l=t(1),a=t(155),s=t(336),_=t(228),h=t(158),u=t(238),p=t(180),v=function(t){function i(){var i=t.apply(this,(0,l.__spreadArray)([],(0,l.__read)(arguments),!1))||this;return i._invalidate_toolbar=!0,i._previous_bbox=new p.BBox,i}return(0,l.__extends)(i,t),i.prototype.update_layout=function(){var t=this;this.layout=new u.SideLayout(this.panel,(function(){return t.get_size()}),!0)},i.prototype.initialize=function(){t.prototype.initialize.call(this),this.el=(0,h.div)(),this.plot_view.canvas_view.add_event(this.el)},i.prototype.lazy_initialize=function(){return(0,l.__awaiter)(this,void 0,void 0,(function(){var i,e=this;return(0,l.__generator)(this,(function(o){switch(o.label){case 0:return[4,t.prototype.lazy_initialize.call(this)];case 1:return o.sent(),i=this,[4,(0,_.build_view)(this.model.toolbar,{parent:this})];case 2:return i._toolbar_view=o.sent(),this.plot_view.visibility_callbacks.push((function(t){return e._toolbar_view.set_visibility(t)})),[2]}}))}))},i.prototype.remove=function(){this._toolbar_view.remove(),(0,h.remove)(this.el),t.prototype.remove.call(this)},i.prototype.render=function(){this.model.visible||(0,h.undisplay)(this.el),t.prototype.render.call(this)},i.prototype._render=function(){var t=this.layout.bbox;this._previous_bbox.equals(t)||((0,h.position)(this.el,t),this._previous_bbox=t,this._invalidate_toolbar=!0),this._invalidate_toolbar&&(this.el.style.position="absolute",this.el.style.overflow="hidden",(0,h.empty)(this.el),this.el.appendChild(this._toolbar_view.el),this._toolbar_view.layout.bbox=t,this._toolbar_view.render(),this._invalidate_toolbar=!1),(0,h.display)(this.el)},i.prototype._get_size=function(){var t=this.model.toolbar,i=t.tools,e=t.logo;return{width:30*i.length+(null!=e?25:0)+15,height:30}},i}(a.AnnotationView);e.ToolbarPanelView=v,v.__name__="ToolbarPanelView";var b=function(t){function i(i){return t.call(this,i)||this}return(0,l.__extends)(i,t),i}(a.Annotation);e.ToolbarPanel=b,r=b,b.__name__="ToolbarPanel",r.prototype.default_view=v,r.define((function(t){return{toolbar:[(0,t.Ref)(s.Toolbar)]}}))},
function _(t,e,r,i,n){i();var a,o=t(1),l=t(125),c=t(126),s=t(128),u=t(337),v=t(338),_=t(347),h=t(348);function f(t){switch(t){case"tap":return"active_tap";case"pan":return"active_drag";case"pinch":case"scroll":return"active_scroll";case"multi":return"active_multi"}return null}function p(t){return"tap"==t||"pan"==t}r.Drag=u.Tool,r.Inspection=u.Tool,r.Scroll=u.Tool,r.Tap=u.Tool;var y=function(t){function e(e){return t.call(this,e)||this}return(0,o.__extends)(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this);var r=this.properties,i=r.tools,n=r.active_drag,a=r.active_inspect,o=r.active_scroll,l=r.active_tap,c=r.active_multi;this.on_change([i,n,a,o,l,c],(function(){return e._init_tools()}))},e.prototype._init_tools=function(){var e,r,i,n,a,u,v,h,y,d,g,x,T=this;if(t.prototype._init_tools.call(this),"auto"==this.active_inspect);else if(this.active_inspect instanceof _.InspectTool){var w=!1;try{for(var b=(0,o.__values)(this.inspectors),m=b.next();!m.done;m=b.next()){(D=m.value)!=this.active_inspect?D.active=!1:w=!0}}catch(t){e={error:t}}finally{try{m&&!m.done&&(r=b.return)&&r.call(b)}finally{if(e)throw e.error}}w||(this.active_inspect=null)}else if((0,l.isArray)(this.active_inspect)){var I=(0,c.intersection)(this.active_inspect,this.inspectors);I.length!=this.active_inspect.length&&(this.active_inspect=I);try{for(var A=(0,o.__values)(this.inspectors),B=A.next();!B.done;B=A.next()){var D=B.value;(0,c.includes)(this.active_inspect,D)||(D.active=!1)}}catch(t){i={error:t}}finally{try{B&&!B.done&&(n=A.return)&&n.call(A)}finally{if(i)throw i.error}}}else if(null==this.active_inspect)try{for(var S=(0,o.__values)(this.inspectors),G=S.next();!G.done;G=S.next()){(D=G.value).active=!1}}catch(t){a={error:t}}finally{try{G&&!G.done&&(u=S.return)&&u.call(S)}finally{if(a)throw a.error}}var N=function(t){t.active?T._active_change(t):t.active=!0};try{for(var O=(0,o.__values)((0,s.values)(this.gestures)),R=O.next();!R.done;R=O.next()){(H=R.value).tools=(0,c.sort_by)(H.tools,(function(t){return t.default_order}));var V=function(t){j.connect(t.properties.active.change,(function(){return T._active_change(t)}))},j=this;try{for(var k=(y=void 0,(0,o.__values)(H.tools)),q=k.next();!q.done;q=k.next()){V(q.value)}}catch(t){y={error:t}}finally{try{q&&!q.done&&(d=k.return)&&d.call(k)}finally{if(y)throw y.error}}}}catch(t){v={error:t}}finally{try{R&&!R.done&&(h=O.return)&&h.call(O)}finally{if(v)throw v.error}}try{for(var z=(0,o.__values)((0,s.entries)(this.gestures)),C=z.next();!C.done;C=z.next()){var E=(0,o.__read)(C.value,2),F=E[0],H=E[1],J=f(F);if(J){var K=this[J];"auto"==K?0!=H.tools.length&&p(F)&&N(H.tools[0]):null!=K&&((0,c.includes)(this.tools,K)?N(K):this[J]=null)}}}catch(t){g={error:t}}finally{try{C&&!C.done&&(x=z.return)&&x.call(z)}finally{if(g)throw g.error}}},e}(h.ToolbarBase);r.Toolbar=y,a=y,y.__name__="Toolbar",a.prototype.default_view=h.ToolbarBaseView,a.define((function(t){var e=t.Or,i=t.Ref,n=t.Auto,a=t.Null;return{active_drag:[e(i(r.Drag),n,a),"auto"],active_inspect:[e(i(r.Inspection),n,a),"auto"],active_scroll:[e(i(r.Scroll),n,a),"auto"],active_tap:[e(i(r.Tap),n,a),"auto"],active_multi:[e(i(v.GestureTool),n,a),"auto"]}}))},
function _(t,e,n,o,r){o();var i,a=t(1),s=t(157),l=t(126),c=t(168),_=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,a.__extends)(e,t),Object.defineProperty(e.prototype,"plot_view",{get:function(){return this.parent},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"plot_model",{get:function(){return this.parent.model},enumerable:!1,configurable:!0}),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,(function(){e.model.active?e.activate():e.deactivate()}))},e.prototype.activate=function(){},e.prototype.deactivate=function(){},e}(s.View);n.ToolView=_,_.__name__="ToolView";var p=function(t){function e(e){return t.call(this,e)||this}return(0,a.__extends)(e,t),Object.defineProperty(e.prototype,"synthetic_renderers",{get:function(){return[]},enumerable:!1,configurable:!0}),e.prototype._get_dim_limits=function(t,e,n,o){var r,i=(0,a.__read)(t,2),s=i[0],c=i[1],_=(0,a.__read)(e,2),p=_[0],u=_[1],d=n.bbox.h_range;"width"==o||"both"==o?(r=[(0,l.min)([s,p]),(0,l.max)([s,p])],r=[(0,l.max)([r[0],d.start]),(0,l.min)([r[1],d.end])]):r=[d.start,d.end];var f,h=n.bbox.v_range;return"height"==o||"both"==o?(f=[(0,l.min)([c,u]),(0,l.max)([c,u])],f=[(0,l.max)([f[0],h.start]),(0,l.min)([f[1],h.end])]):f=[h.start,h.end],[r,f]},e.register_alias=function(t,e){this.prototype._known_aliases.set(t,e)},e.from_string=function(t){var e=this.prototype._known_aliases.get(t);if(null!=e)return e();var n=(0,a.__spreadArray)([],(0,a.__read)(this.prototype._known_aliases.keys()),!1);throw new Error("unexpected tool name '"+t+"', possible tools are "+n.join(", "))},e}(c.Model);n.Tool=p,i=p,p.__name__="Tool",i.prototype._known_aliases=new Map,i.define((function(t){var e=t.String;return{description:[(0,t.Nullable)(e),null]}})),i.internal((function(t){return{active:[t.Boolean,!1]}}))},
function _(t,n,e,o,u){o();var r=t(1),i=t(339),_=t(346),l=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,r.__extends)(n,t),n}(i.ButtonToolView);e.GestureToolView=l,l.__name__="GestureToolView";var s=function(t){function n(n){var e=t.call(this,n)||this;return e.button_view=_.OnOffButtonView,e}return(0,r.__extends)(n,t),n}(i.ButtonTool);e.GestureTool=s,s.__name__="GestureTool"},
function _(t,e,o,n,i){n();var r,l=t(1),u=(0,l.__importDefault)(t(340)),a=t(341),s=t(337),c=t(158),_=t(149),p=t(125),h=t(126),d=(0,l.__importStar)(t(342)),m=d,f=(0,l.__importDefault)(t(343)),y=(0,l.__importDefault)(t(344)),v=t(345),b=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,l.__extends)(e,t),e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this);var o=this.model.menu;if(null!=o){var n=this.parent.model.toolbar_location,i="left"==n||"above"==n,r=this.parent.model.horizontal?"vertical":"horizontal";this._menu=new v.ContextMenu(i?(0,h.reversed)(o):o,{orientation:r,prevent_hide:function(t){return t.target==e.el}})}this._hammer=new u.default(this.el,{touchAction:"auto",inputClass:u.default.TouchMouseInput}),this.connect(this.model.change,(function(){return e.render()})),this._hammer.on("tap",(function(t){var o;(null===(o=e._menu)||void 0===o?void 0:o.is_open)?e._menu.hide():t.target==e.el&&e._clicked()})),this._hammer.on("press",(function(){return e._pressed()})),this.el.addEventListener("keydown",(function(t){t.keyCode==c.Keys.Enter&&e._clicked()}))},e.prototype.remove=function(){var e;this._hammer.destroy(),null===(e=this._menu)||void 0===e||e.remove(),t.prototype.remove.call(this)},e.prototype.styles=function(){return(0,l.__spreadArray)((0,l.__spreadArray)([],(0,l.__read)(t.prototype.styles.call(this)),!1),[d.default,f.default,y.default],!1)},e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat(m.toolbar_button)},e.prototype.render=function(){(0,c.empty)(this.el);var t=this.model.computed_icon;(0,p.isString)(t)&&((0,_.startsWith)(t,"data:image")?this.el.style.backgroundImage='url("'+t+'")':this.el.classList.add(t)),this.el.title=this.model.tooltip,this.el.tabIndex=0,null!=this._menu&&this.root.el.appendChild(this._menu.el)},e.prototype._pressed=function(){var t,e=this,o=function(){switch(e.parent.model.toolbar_location){case"right":return{left_of:e.el};case"left":return{right_of:e.el};case"above":return{below:e.el};case"below":return{above:e.el}}}();null===(t=this._menu)||void 0===t||t.toggle(o)},e}(a.DOMView);o.ButtonToolButtonView=b,b.__name__="ButtonToolButtonView";var g=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,l.__extends)(e,t),e}(s.ToolView);o.ButtonToolView=g,g.__name__="ButtonToolView";var w=function(t){function e(e){return t.call(this,e)||this}return(0,l.__extends)(e,t),e.prototype._get_dim_tooltip=function(t){var e=this.description,o=this.tool_name;return null!=e?e:"both"==t?o:o+" ("+("width"==t?"x":"y")+"-axis)"},Object.defineProperty(e.prototype,"tooltip",{get:function(){var t;return null!==(t=this.description)&&void 0!==t?t:this.tool_name},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"computed_icon",{get:function(){return this.icon},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"menu",{get:function(){return null},enumerable:!1,configurable:!0}),e}(s.Tool);o.ButtonTool=w,r=w,w.__name__="ButtonTool",r.internal((function(t){return{disabled:[t.Boolean,!1]}}))},
function _(t,e,i,n,r){
/*! Hammer.JS - v2.0.7 - 2016-04-22
     * http://hammerjs.github.io/
     *
     * Copyright (c) 2016 Jorik Tangelder;
     * Licensed under the MIT license */
!function(t,i,n,r){"use strict";var s,o=["","webkit","Moz","MS","ms","o"],a=i.createElement("div"),h=Math.round,u=Math.abs,c=Date.now;function l(t,e,i){return setTimeout(T(t,i),e)}function p(t,e,i){return!!Array.isArray(t)&&(f(t,i[e],i),!0)}function f(t,e,i){var n;if(t)if(t.forEach)t.forEach(e,i);else if(t.length!==r)for(n=0;n<t.length;)e.call(i,t[n],n,t),n++;else for(n in t)t.hasOwnProperty(n)&&e.call(i,t[n],n,t)}function v(e,i,n){var r="DEPRECATED METHOD: "+i+"\n"+n+" AT \n";return function(){var i=new Error("get-stack-trace"),n=i&&i.stack?i.stack.replace(/^[^\(]+?[\n$]/gm,"").replace(/^\s+at\s+/gm,"").replace(/^Object.<anonymous>\s*\(/gm,"{anonymous}()@"):"Unknown Stack Trace",s=t.console&&(t.console.warn||t.console.log);return s&&s.call(t.console,r,n),e.apply(this,arguments)}}s="function"!=typeof Object.assign?function(t){if(t===r||null===t)throw new TypeError("Cannot convert undefined or null to object");for(var e=Object(t),i=1;i<arguments.length;i++){var n=arguments[i];if(n!==r&&null!==n)for(var s in n)n.hasOwnProperty(s)&&(e[s]=n[s])}return e}:Object.assign;var d=v((function(t,e,i){for(var n=Object.keys(e),s=0;s<n.length;)(!i||i&&t[n[s]]===r)&&(t[n[s]]=e[n[s]]),s++;return t}),"extend","Use `assign`."),m=v((function(t,e){return d(t,e,!0)}),"merge","Use `assign`.");function g(t,e,i){var n,r=e.prototype;(n=t.prototype=Object.create(r)).constructor=t,n._super=r,i&&s(n,i)}function T(t,e){return function(){return t.apply(e,arguments)}}function y(t,e){return"function"==typeof t?t.apply(e&&e[0]||r,e):t}function E(t,e){return t===r?e:t}function I(t,e,i){f(S(e),(function(e){t.addEventListener(e,i,!1)}))}function A(t,e,i){f(S(e),(function(e){t.removeEventListener(e,i,!1)}))}function _(t,e){for(;t;){if(t==e)return!0;t=t.parentNode}return!1}function C(t,e){return t.indexOf(e)>-1}function S(t){return t.trim().split(/\s+/g)}function b(t,e,i){if(t.indexOf&&!i)return t.indexOf(e);for(var n=0;n<t.length;){if(i&&t[n][i]==e||!i&&t[n]===e)return n;n++}return-1}function P(t){return Array.prototype.slice.call(t,0)}function D(t,e,i){for(var n=[],r=[],s=0;s<t.length;){var o=e?t[s][e]:t[s];b(r,o)<0&&n.push(t[s]),r[s]=o,s++}return i&&(n=e?n.sort((function(t,i){return t[e]>i[e]})):n.sort()),n}function x(t,e){for(var i,n,s=e[0].toUpperCase()+e.slice(1),a=0;a<o.length;){if((n=(i=o[a])?i+s:e)in t)return n;a++}return r}var w=1;function O(e){var i=e.ownerDocument||e;return i.defaultView||i.parentWindow||t}var R="ontouchstart"in t,M=x(t,"PointerEvent")!==r,z=R&&/mobile|tablet|ip(ad|hone|od)|android/i.test(navigator.userAgent),N="touch",X="mouse",Y=24,F=["x","y"],W=["clientX","clientY"];function q(t,e){var i=this;this.manager=t,this.callback=e,this.element=t.element,this.target=t.options.inputTarget,this.domHandler=function(e){y(t.options.enable,[t])&&i.handler(e)},this.init()}function k(t,e,i){var n=i.pointers.length,s=i.changedPointers.length,o=1&e&&n-s==0,a=12&e&&n-s==0;i.isFirst=!!o,i.isFinal=!!a,o&&(t.session={}),i.eventType=e,function(t,e){var i=t.session,n=e.pointers,s=n.length;i.firstInput||(i.firstInput=H(e));s>1&&!i.firstMultiple?i.firstMultiple=H(e):1===s&&(i.firstMultiple=!1);var o=i.firstInput,a=i.firstMultiple,h=a?a.center:o.center,l=e.center=L(n);e.timeStamp=c(),e.deltaTime=e.timeStamp-o.timeStamp,e.angle=G(h,l),e.distance=j(h,l),function(t,e){var i=e.center,n=t.offsetDelta||{},r=t.prevDelta||{},s=t.prevInput||{};1!==e.eventType&&4!==s.eventType||(r=t.prevDelta={x:s.deltaX||0,y:s.deltaY||0},n=t.offsetDelta={x:i.x,y:i.y});e.deltaX=r.x+(i.x-n.x),e.deltaY=r.y+(i.y-n.y)}(i,e),e.offsetDirection=V(e.deltaX,e.deltaY);var p=U(e.deltaTime,e.deltaX,e.deltaY);e.overallVelocityX=p.x,e.overallVelocityY=p.y,e.overallVelocity=u(p.x)>u(p.y)?p.x:p.y,e.scale=a?(f=a.pointers,v=n,j(v[0],v[1],W)/j(f[0],f[1],W)):1,e.rotation=a?function(t,e){return G(e[1],e[0],W)+G(t[1],t[0],W)}(a.pointers,n):0,e.maxPointers=i.prevInput?e.pointers.length>i.prevInput.maxPointers?e.pointers.length:i.prevInput.maxPointers:e.pointers.length,function(t,e){var i,n,s,o,a=t.lastInterval||e,h=e.timeStamp-a.timeStamp;if(8!=e.eventType&&(h>25||a.velocity===r)){var c=e.deltaX-a.deltaX,l=e.deltaY-a.deltaY,p=U(h,c,l);n=p.x,s=p.y,i=u(p.x)>u(p.y)?p.x:p.y,o=V(c,l),t.lastInterval=e}else i=a.velocity,n=a.velocityX,s=a.velocityY,o=a.direction;e.velocity=i,e.velocityX=n,e.velocityY=s,e.direction=o}(i,e);var f,v;var d=t.element;_(e.srcEvent.target,d)&&(d=e.srcEvent.target);e.target=d}(t,i),t.emit("hammer.input",i),t.recognize(i),t.session.prevInput=i}function H(t){for(var e=[],i=0;i<t.pointers.length;)e[i]={clientX:h(t.pointers[i].clientX),clientY:h(t.pointers[i].clientY)},i++;return{timeStamp:c(),pointers:e,center:L(e),deltaX:t.deltaX,deltaY:t.deltaY}}function L(t){var e=t.length;if(1===e)return{x:h(t[0].clientX),y:h(t[0].clientY)};for(var i=0,n=0,r=0;r<e;)i+=t[r].clientX,n+=t[r].clientY,r++;return{x:h(i/e),y:h(n/e)}}function U(t,e,i){return{x:e/t||0,y:i/t||0}}function V(t,e){return t===e?1:u(t)>=u(e)?t<0?2:4:e<0?8:16}function j(t,e,i){i||(i=F);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return Math.sqrt(n*n+r*r)}function G(t,e,i){i||(i=F);var n=e[i[0]]-t[i[0]],r=e[i[1]]-t[i[1]];return 180*Math.atan2(r,n)/Math.PI}q.prototype={handler:function(){},init:function(){this.evEl&&I(this.element,this.evEl,this.domHandler),this.evTarget&&I(this.target,this.evTarget,this.domHandler),this.evWin&&I(O(this.element),this.evWin,this.domHandler)},destroy:function(){this.evEl&&A(this.element,this.evEl,this.domHandler),this.evTarget&&A(this.target,this.evTarget,this.domHandler),this.evWin&&A(O(this.element),this.evWin,this.domHandler)}};var Z={mousedown:1,mousemove:2,mouseup:4},B="mousedown",$="mousemove mouseup";function J(){this.evEl=B,this.evWin=$,this.pressed=!1,q.apply(this,arguments)}g(J,q,{handler:function(t){var e=Z[t.type];1&e&&0===t.button&&(this.pressed=!0),2&e&&1!==t.which&&(e=4),this.pressed&&(4&e&&(this.pressed=!1),this.callback(this.manager,e,{pointers:[t],changedPointers:[t],pointerType:X,srcEvent:t}))}});var K={pointerdown:1,pointermove:2,pointerup:4,pointercancel:8,pointerout:8},Q={2:N,3:"pen",4:X,5:"kinect"},tt="pointerdown",et="pointermove pointerup pointercancel";function it(){this.evEl=tt,this.evWin=et,q.apply(this,arguments),this.store=this.manager.session.pointerEvents=[]}t.MSPointerEvent&&!t.PointerEvent&&(tt="MSPointerDown",et="MSPointerMove MSPointerUp MSPointerCancel"),g(it,q,{handler:function(t){var e=this.store,i=!1,n=t.type.toLowerCase().replace("ms",""),r=K[n],s=Q[t.pointerType]||t.pointerType,o=s==N,a=b(e,t.pointerId,"pointerId");1&r&&(0===t.button||o)?a<0&&(e.push(t),a=e.length-1):12&r&&(i=!0),a<0||(e[a]=t,this.callback(this.manager,r,{pointers:e,changedPointers:[t],pointerType:s,srcEvent:t}),i&&e.splice(a,1))}});var nt={touchstart:1,touchmove:2,touchend:4,touchcancel:8},rt="touchstart",st="touchstart touchmove touchend touchcancel";function ot(){this.evTarget=rt,this.evWin=st,this.started=!1,q.apply(this,arguments)}function at(t,e){var i=P(t.touches),n=P(t.changedTouches);return 12&e&&(i=D(i.concat(n),"identifier",!0)),[i,n]}g(ot,q,{handler:function(t){var e=nt[t.type];if(1===e&&(this.started=!0),this.started){var i=at.call(this,t,e);12&e&&i[0].length-i[1].length==0&&(this.started=!1),this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:N,srcEvent:t})}}});var ht={touchstart:1,touchmove:2,touchend:4,touchcancel:8},ut="touchstart touchmove touchend touchcancel";function ct(){this.evTarget=ut,this.targetIds={},q.apply(this,arguments)}function lt(t,e){var i=P(t.touches),n=this.targetIds;if(3&e&&1===i.length)return n[i[0].identifier]=!0,[i,i];var r,s,o=P(t.changedTouches),a=[],h=this.target;if(s=i.filter((function(t){return _(t.target,h)})),1===e)for(r=0;r<s.length;)n[s[r].identifier]=!0,r++;for(r=0;r<o.length;)n[o[r].identifier]&&a.push(o[r]),12&e&&delete n[o[r].identifier],r++;return a.length?[D(s.concat(a),"identifier",!0),a]:void 0}g(ct,q,{handler:function(t){var e=ht[t.type],i=lt.call(this,t,e);i&&this.callback(this.manager,e,{pointers:i[0],changedPointers:i[1],pointerType:N,srcEvent:t})}});function pt(){q.apply(this,arguments);var t=T(this.handler,this);this.touch=new ct(this.manager,t),this.mouse=new J(this.manager,t),this.primaryTouch=null,this.lastTouches=[]}function ft(t,e){1&t?(this.primaryTouch=e.changedPointers[0].identifier,vt.call(this,e)):12&t&&vt.call(this,e)}function vt(t){var e=t.changedPointers[0];if(e.identifier===this.primaryTouch){var i={x:e.clientX,y:e.clientY};this.lastTouches.push(i);var n=this.lastTouches;setTimeout((function(){var t=n.indexOf(i);t>-1&&n.splice(t,1)}),2500)}}function dt(t){for(var e=t.srcEvent.clientX,i=t.srcEvent.clientY,n=0;n<this.lastTouches.length;n++){var r=this.lastTouches[n],s=Math.abs(e-r.x),o=Math.abs(i-r.y);if(s<=25&&o<=25)return!0}return!1}g(pt,q,{handler:function(t,e,i){var n=i.pointerType==N,r=i.pointerType==X;if(!(r&&i.sourceCapabilities&&i.sourceCapabilities.firesTouchEvents)){if(n)ft.call(this,e,i);else if(r&&dt.call(this,i))return;this.callback(t,e,i)}},destroy:function(){this.touch.destroy(),this.mouse.destroy()}});var mt=x(a.style,"touchAction"),gt=mt!==r,Tt="compute",yt="auto",Et="manipulation",It="none",At="pan-x",_t="pan-y",Ct=function(){if(!gt)return!1;var e={},i=t.CSS&&t.CSS.supports;return["auto","manipulation","pan-y","pan-x","pan-x pan-y","none"].forEach((function(n){e[n]=!i||t.CSS.supports("touch-action",n)})),e}();function St(t,e){this.manager=t,this.set(e)}St.prototype={set:function(t){t==Tt&&(t=this.compute()),gt&&this.manager.element.style&&Ct[t]&&(this.manager.element.style[mt]=t),this.actions=t.toLowerCase().trim()},update:function(){this.set(this.manager.options.touchAction)},compute:function(){var t=[];return f(this.manager.recognizers,(function(e){y(e.options.enable,[e])&&(t=t.concat(e.getTouchAction()))})),function(t){if(C(t,It))return It;var e=C(t,At),i=C(t,_t);if(e&&i)return It;if(e||i)return e?At:_t;if(C(t,Et))return Et;return yt}(t.join(" "))},preventDefaults:function(t){var e=t.srcEvent,i=t.offsetDirection;if(this.manager.session.prevented)e.preventDefault();else{var n=this.actions,r=C(n,It)&&!Ct.none,s=C(n,_t)&&!Ct["pan-y"],o=C(n,At)&&!Ct["pan-x"];if(r){var a=1===t.pointers.length,h=t.distance<2,u=t.deltaTime<250;if(a&&h&&u)return}if(!o||!s)return r||s&&6&i||o&&i&Y?this.preventSrc(e):void 0}},preventSrc:function(t){this.manager.session.prevented=!0,t.preventDefault()}};var bt=32;function Pt(t){this.options=s({},this.defaults,t||{}),this.id=w++,this.manager=null,this.options.enable=E(this.options.enable,!0),this.state=1,this.simultaneous={},this.requireFail=[]}function Dt(t){return 16&t?"cancel":8&t?"end":4&t?"move":2&t?"start":""}function xt(t){return 16==t?"down":8==t?"up":2==t?"left":4==t?"right":""}function wt(t,e){var i=e.manager;return i?i.get(t):t}function Ot(){Pt.apply(this,arguments)}function Rt(){Ot.apply(this,arguments),this.pX=null,this.pY=null}function Mt(){Ot.apply(this,arguments)}function zt(){Pt.apply(this,arguments),this._timer=null,this._input=null}function Nt(){Ot.apply(this,arguments)}function Xt(){Ot.apply(this,arguments)}function Yt(){Pt.apply(this,arguments),this.pTime=!1,this.pCenter=!1,this._timer=null,this._input=null,this.count=0}function Ft(t,e){return(e=e||{}).recognizers=E(e.recognizers,Ft.defaults.preset),new Wt(t,e)}Pt.prototype={defaults:{},set:function(t){return s(this.options,t),this.manager&&this.manager.touchAction.update(),this},recognizeWith:function(t){if(p(t,"recognizeWith",this))return this;var e=this.simultaneous;return e[(t=wt(t,this)).id]||(e[t.id]=t,t.recognizeWith(this)),this},dropRecognizeWith:function(t){return p(t,"dropRecognizeWith",this)||(t=wt(t,this),delete this.simultaneous[t.id]),this},requireFailure:function(t){if(p(t,"requireFailure",this))return this;var e=this.requireFail;return-1===b(e,t=wt(t,this))&&(e.push(t),t.requireFailure(this)),this},dropRequireFailure:function(t){if(p(t,"dropRequireFailure",this))return this;t=wt(t,this);var e=b(this.requireFail,t);return e>-1&&this.requireFail.splice(e,1),this},hasRequireFailures:function(){return this.requireFail.length>0},canRecognizeWith:function(t){return!!this.simultaneous[t.id]},emit:function(t){var e=this,i=this.state;function n(i){e.manager.emit(i,t)}i<8&&n(e.options.event+Dt(i)),n(e.options.event),t.additionalEvent&&n(t.additionalEvent),i>=8&&n(e.options.event+Dt(i))},tryEmit:function(t){if(this.canEmit())return this.emit(t);this.state=bt},canEmit:function(){for(var t=0;t<this.requireFail.length;){if(!(33&this.requireFail[t].state))return!1;t++}return!0},recognize:function(t){var e=s({},t);if(!y(this.options.enable,[this,e]))return this.reset(),void(this.state=bt);56&this.state&&(this.state=1),this.state=this.process(e),30&this.state&&this.tryEmit(e)},process:function(t){},getTouchAction:function(){},reset:function(){}},g(Ot,Pt,{defaults:{pointers:1},attrTest:function(t){var e=this.options.pointers;return 0===e||t.pointers.length===e},process:function(t){var e=this.state,i=t.eventType,n=6&e,r=this.attrTest(t);return n&&(8&i||!r)?16|e:n||r?4&i?8|e:2&e?4|e:2:bt}}),g(Rt,Ot,{defaults:{event:"pan",threshold:10,pointers:1,direction:30},getTouchAction:function(){var t=this.options.direction,e=[];return 6&t&&e.push(_t),t&Y&&e.push(At),e},directionTest:function(t){var e=this.options,i=!0,n=t.distance,r=t.direction,s=t.deltaX,o=t.deltaY;return r&e.direction||(6&e.direction?(r=0===s?1:s<0?2:4,i=s!=this.pX,n=Math.abs(t.deltaX)):(r=0===o?1:o<0?8:16,i=o!=this.pY,n=Math.abs(t.deltaY))),t.direction=r,i&&n>e.threshold&&r&e.direction},attrTest:function(t){return Ot.prototype.attrTest.call(this,t)&&(2&this.state||!(2&this.state)&&this.directionTest(t))},emit:function(t){this.pX=t.deltaX,this.pY=t.deltaY;var e=xt(t.direction);e&&(t.additionalEvent=this.options.event+e),this._super.emit.call(this,t)}}),g(Mt,Ot,{defaults:{event:"pinch",threshold:0,pointers:2},getTouchAction:function(){return[It]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.scale-1)>this.options.threshold||2&this.state)},emit:function(t){if(1!==t.scale){var e=t.scale<1?"in":"out";t.additionalEvent=this.options.event+e}this._super.emit.call(this,t)}}),g(zt,Pt,{defaults:{event:"press",pointers:1,time:251,threshold:9},getTouchAction:function(){return[yt]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,r=t.deltaTime>e.time;if(this._input=t,!n||!i||12&t.eventType&&!r)this.reset();else if(1&t.eventType)this.reset(),this._timer=l((function(){this.state=8,this.tryEmit()}),e.time,this);else if(4&t.eventType)return 8;return bt},reset:function(){clearTimeout(this._timer)},emit:function(t){8===this.state&&(t&&4&t.eventType?this.manager.emit(this.options.event+"up",t):(this._input.timeStamp=c(),this.manager.emit(this.options.event,this._input)))}}),g(Nt,Ot,{defaults:{event:"rotate",threshold:0,pointers:2},getTouchAction:function(){return[It]},attrTest:function(t){return this._super.attrTest.call(this,t)&&(Math.abs(t.rotation)>this.options.threshold||2&this.state)}}),g(Xt,Ot,{defaults:{event:"swipe",threshold:10,velocity:.3,direction:30,pointers:1},getTouchAction:function(){return Rt.prototype.getTouchAction.call(this)},attrTest:function(t){var e,i=this.options.direction;return 30&i?e=t.overallVelocity:6&i?e=t.overallVelocityX:i&Y&&(e=t.overallVelocityY),this._super.attrTest.call(this,t)&&i&t.offsetDirection&&t.distance>this.options.threshold&&t.maxPointers==this.options.pointers&&u(e)>this.options.velocity&&4&t.eventType},emit:function(t){var e=xt(t.offsetDirection);e&&this.manager.emit(this.options.event+e,t),this.manager.emit(this.options.event,t)}}),g(Yt,Pt,{defaults:{event:"tap",pointers:1,taps:1,interval:300,time:250,threshold:9,posThreshold:10},getTouchAction:function(){return[Et]},process:function(t){var e=this.options,i=t.pointers.length===e.pointers,n=t.distance<e.threshold,r=t.deltaTime<e.time;if(this.reset(),1&t.eventType&&0===this.count)return this.failTimeout();if(n&&r&&i){if(4!=t.eventType)return this.failTimeout();var s=!this.pTime||t.timeStamp-this.pTime<e.interval,o=!this.pCenter||j(this.pCenter,t.center)<e.posThreshold;if(this.pTime=t.timeStamp,this.pCenter=t.center,o&&s?this.count+=1:this.count=1,this._input=t,0===this.count%e.taps)return this.hasRequireFailures()?(this._timer=l((function(){this.state=8,this.tryEmit()}),e.interval,this),2):8}return bt},failTimeout:function(){return this._timer=l((function(){this.state=bt}),this.options.interval,this),bt},reset:function(){clearTimeout(this._timer)},emit:function(){8==this.state&&(this._input.tapCount=this.count,this.manager.emit(this.options.event,this._input))}}),Ft.VERSION="2.0.7",Ft.defaults={domEvents:!1,touchAction:Tt,enable:!0,inputTarget:null,inputClass:null,preset:[[Nt,{enable:!1}],[Mt,{enable:!1},["rotate"]],[Xt,{direction:6}],[Rt,{direction:6},["swipe"]],[Yt],[Yt,{event:"doubletap",taps:2},["tap"]],[zt]],cssProps:{userSelect:"none",touchSelect:"none",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}};function Wt(t,e){var i;this.options=s({},Ft.defaults,e||{}),this.options.inputTarget=this.options.inputTarget||t,this.handlers={},this.session={},this.recognizers=[],this.oldCssProps={},this.element=t,this.input=new((i=this).options.inputClass||(M?it:z?ct:R?pt:J))(i,k),this.touchAction=new St(this,this.options.touchAction),qt(this,!0),f(this.options.recognizers,(function(t){var e=this.add(new t[0](t[1]));t[2]&&e.recognizeWith(t[2]),t[3]&&e.requireFailure(t[3])}),this)}function qt(t,e){var i,n=t.element;n.style&&(f(t.options.cssProps,(function(r,s){i=x(n.style,s),e?(t.oldCssProps[i]=n.style[i],n.style[i]=r):n.style[i]=t.oldCssProps[i]||""})),e||(t.oldCssProps={}))}Wt.prototype={set:function(t){return s(this.options,t),t.touchAction&&this.touchAction.update(),t.inputTarget&&(this.input.destroy(),this.input.target=t.inputTarget,this.input.init()),this},stop:function(t){this.session.stopped=t?2:1},recognize:function(t){var e=this.session;if(!e.stopped){var i;this.touchAction.preventDefaults(t);var n=this.recognizers,r=e.curRecognizer;(!r||r&&8&r.state)&&(r=e.curRecognizer=null);for(var s=0;s<n.length;)i=n[s],2===e.stopped||r&&i!=r&&!i.canRecognizeWith(r)?i.reset():i.recognize(t),!r&&14&i.state&&(r=e.curRecognizer=i),s++}},get:function(t){if(t instanceof Pt)return t;for(var e=this.recognizers,i=0;i<e.length;i++)if(e[i].options.event==t)return e[i];return null},add:function(t){if(p(t,"add",this))return this;var e=this.get(t.options.event);return e&&this.remove(e),this.recognizers.push(t),t.manager=this,this.touchAction.update(),t},remove:function(t){if(p(t,"remove",this))return this;if(t=this.get(t)){var e=this.recognizers,i=b(e,t);-1!==i&&(e.splice(i,1),this.touchAction.update())}return this},on:function(t,e){if(t!==r&&e!==r){var i=this.handlers;return f(S(t),(function(t){i[t]=i[t]||[],i[t].push(e)})),this}},off:function(t,e){if(t!==r){var i=this.handlers;return f(S(t),(function(t){e?i[t]&&i[t].splice(b(i[t],e),1):delete i[t]})),this}},emit:function(t,e){this.options.domEvents&&function(t,e){var n=i.createEvent("Event");n.initEvent(t,!0,!0),n.gesture=e,e.target.dispatchEvent(n)}(t,e);var n=this.handlers[t]&&this.handlers[t].slice();if(n&&n.length){e.type=t,e.preventDefault=function(){e.srcEvent.preventDefault()};for(var r=0;r<n.length;)n[r](e),r++}},destroy:function(){this.element&&qt(this,!1),this.handlers={},this.session={},this.input.destroy(),this.element=null}},s(Ft,{INPUT_START:1,INPUT_MOVE:2,INPUT_END:4,INPUT_CANCEL:8,STATE_POSSIBLE:1,STATE_BEGAN:2,STATE_CHANGED:4,STATE_ENDED:8,STATE_RECOGNIZED:8,STATE_CANCELLED:16,STATE_FAILED:bt,DIRECTION_NONE:1,DIRECTION_LEFT:2,DIRECTION_RIGHT:4,DIRECTION_UP:8,DIRECTION_DOWN:16,DIRECTION_HORIZONTAL:6,DIRECTION_VERTICAL:Y,DIRECTION_ALL:30,Manager:Wt,Input:q,TouchAction:St,TouchInput:ct,MouseInput:J,PointerEventInput:it,TouchMouseInput:pt,SingleTouchInput:ot,Recognizer:Pt,AttrRecognizer:Ot,Tap:Yt,Pan:Rt,Swipe:Xt,Pinch:Mt,Rotate:Nt,Press:zt,on:I,off:A,each:f,merge:m,extend:d,assign:s,inherit:g,bindFn:T,prefixed:x}),(void 0!==t?t:"undefined"!=typeof self?self:{}).Hammer=Ft,"function"==typeof define&&define.amd?define((function(){return Ft})):void 0!==e&&e.exports?e.exports=Ft:t.Hammer=Ft}(window,document)},
function _(t,e,i,n,o){n();var r=t(1),s=t(157),c=t(158),p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,r.__extends)(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.el=this._createElement()},e.prototype.remove=function(){(0,c.remove)(this.el),t.prototype.remove.call(this)},e.prototype.css_classes=function(){return[]},e.prototype.render=function(){},e.prototype.renderTo=function(t){t.appendChild(this.el),this.render(),this._has_finished=!0,this.notify_finished()},e.prototype._createElement=function(){return(0,c.createElement)(this.constructor.tag_name,{class:this.css_classes()})},e}(s.View);i.DOMView=p,p.__name__="DOMView",p.tag_name="div"},
function _(o,t,b,r,e){r(),b.root="bk-root",b.toolbar_hidden="bk-toolbar-hidden",b.toolbar="bk-toolbar",b.logo="bk-logo",b.above="bk-above",b.below="bk-below",b.left="bk-left",b.right="bk-right",b.toolbar_button="bk-toolbar-button",b.tool_overflow="bk-tool-overflow",b.active="bk-active",b.divider="bk-divider",b.horizontal="bk-horizontal",b.vertical="bk-vertical",b.default='.bk-root .bk-toolbar-hidden{visibility:hidden;opacity:0;transition:visibility 0.3s linear, opacity 0.3s linear;}.bk-root .bk-toolbar{display:flex;flex-wrap:nowrap;align-items:center;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;}.bk-root .bk-toolbar .bk-logo{flex-shrink:0;}.bk-root .bk-toolbar.bk-above,.bk-root .bk-toolbar.bk-below{flex-direction:row;justify-content:flex-end;}.bk-root .bk-toolbar.bk-above .bk-logo,.bk-root .bk-toolbar.bk-below .bk-logo{order:1;margin-left:5px;margin-right:0px;}.bk-root .bk-toolbar.bk-left,.bk-root .bk-toolbar.bk-right{flex-direction:column;justify-content:flex-start;}.bk-root .bk-toolbar.bk-left .bk-logo,.bk-root .bk-toolbar.bk-right .bk-logo{order:0;margin-bottom:5px;margin-top:0px;}.bk-root .bk-toolbar-button{width:30px;height:30px;cursor:pointer;background-size:60% 60%;background-origin:border-box;background-color:transparent;background-repeat:no-repeat;background-position:center center;}.bk-root .bk-toolbar-button:hover,.bk-root .bk-tool-overflow:hover{background-color:rgba(192, 192, 192, 0.15);}.bk-root .bk-toolbar-button:focus,.bk-root .bk-tool-overflow:focus,.bk-root .bk-toolbar-button:focus-visible,.bk-root .bk-tool-overflow:focus-visible{outline:1px dotted #26aae1;outline-offset:-1px;}.bk-root .bk-toolbar-button::-moz-focus-inner,.bk-root .bk-tool-overflow::-moz-focus-inner{border:0;}.bk-root .bk-above .bk-toolbar-button{border-bottom:2px solid transparent;}.bk-root .bk-above .bk-toolbar-button.bk-active{border-bottom-color:#26aae1;}.bk-root .bk-below .bk-toolbar-button{border-top:2px solid transparent;}.bk-root .bk-below .bk-toolbar-button.bk-active{border-top-color:#26aae1;}.bk-root .bk-right .bk-toolbar-button{border-left:2px solid transparent;}.bk-root .bk-right .bk-toolbar-button.bk-active{border-left-color:#26aae1;}.bk-root .bk-left .bk-toolbar-button{border-right:2px solid transparent;}.bk-root .bk-left .bk-toolbar-button.bk-active{border-right-color:#26aae1;}.bk-root .bk-divider{content:" ";display:inline-block;background-color:lightgray;}.bk-root .bk-above .bk-divider,.bk-root .bk-below .bk-divider{height:10px;width:1px;}.bk-root .bk-left .bk-divider,.bk-root .bk-right .bk-divider{height:1px;width:10px;}.bk-root .bk-tool-overflow{color:gray;display:flex;align-items:center;}.bk-root .bk-above .bk-tool-overflow,.bk-root .bk-below .bk-tool-overflow,.bk-root .bk-horizontal .bk-tool-overflow{width:15px;height:30px;flex-direction:row;}.bk-root .bk-left .bk-tool-overflow,.bk-root .bk-right .bk-tool-overflow,.bk-root .bk-vertical .bk-tool-overflow{width:30px;height:15px;flex-direction:column;}'},
function _(A,g,o,C,l){C(),o.root="bk-root",o.tool_icon_copy_to_clipboard="bk-tool-icon-copy-to-clipboard",o.tool_icon_replace_mode="bk-tool-icon-replace-mode",o.tool_icon_append_mode="bk-tool-icon-append-mode",o.tool_icon_intersect_mode="bk-tool-icon-intersect-mode",o.tool_icon_subtract_mode="bk-tool-icon-subtract-mode",o.tool_icon_clear_selection="bk-tool-icon-clear-selection",o.tool_icon_box_select="bk-tool-icon-box-select",o.tool_icon_box_zoom="bk-tool-icon-box-zoom",o.tool_icon_zoom_in="bk-tool-icon-zoom-in",o.tool_icon_zoom_out="bk-tool-icon-zoom-out",o.tool_icon_help="bk-tool-icon-help",o.tool_icon_hover="bk-tool-icon-hover",o.tool_icon_crosshair="bk-tool-icon-crosshair",o.tool_icon_lasso_select="bk-tool-icon-lasso-select",o.tool_icon_pan="bk-tool-icon-pan",o.tool_icon_xpan="bk-tool-icon-xpan",o.tool_icon_ypan="bk-tool-icon-ypan",o.tool_icon_range="bk-tool-icon-range",o.tool_icon_polygon_select="bk-tool-icon-polygon-select",o.tool_icon_redo="bk-tool-icon-redo",o.tool_icon_reset="bk-tool-icon-reset",o.tool_icon_save="bk-tool-icon-save",o.tool_icon_tap_select="bk-tool-icon-tap-select",o.tool_icon_undo="bk-tool-icon-undo",o.tool_icon_wheel_pan="bk-tool-icon-wheel-pan",o.tool_icon_wheel_zoom="bk-tool-icon-wheel-zoom",o.tool_icon_box_edit="bk-tool-icon-box-edit",o.tool_icon_freehand_draw="bk-tool-icon-freehand-draw",o.tool_icon_poly_draw="bk-tool-icon-poly-draw",o.tool_icon_point_draw="bk-tool-icon-point-draw",o.tool_icon_poly_edit="bk-tool-icon-poly-edit",o.tool_icon_line_edit="bk-tool-icon-line-edit",o.default='.bk-root .bk-tool-icon-copy-to-clipboard{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUSDBoBvcHQeQAAAG9JREFUWMNjXLhsJcNAAiaGAQYwB/xHwh/Q+ITEkfHQCwEWND4jmeb8H/JpgBwfI6cNBhLSEkqaGXRpgFRAcZoZsmlg1AGjDhh1wKgDRh0w6gCaVcf/R2wIkNqw+D9s0wADvUNiyIYA47BJAwPuAAAj/Cjd0TCN6wAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-replace-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxokK3gniQAAAHpJREFUWMNjXLhsJcNAAiaGAQajDhhwB7DgEP+PxmeksvjgDwFcLmYkUh2hkBj8IcBIZXsYh1w2/I8v3sgAOM0bLYhGc8GgrwuICgldfQO88pcvXvg/aOuCUQeM5oLRuoCFCJcTbOMh5XOiW0JDNhdQS3y0IBp1ABwAAF8KGrhC1Eg6AAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-append-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkZWD04WwAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAAAoUlEQVRYw+1WQQ6AIAwrhO8Y/bIXEz9jIMSDr8ETCUEPQzA4pMeFLKNbu4l5WR0CDOMEALBGIzMuQIBEZQjPgP9JLjwTfBjY9sO9lZsFA9IafZng3BlIyVefgd8XQFZBAWe8jfNxwsDhir6rzoCiPiy1K+J8/FRQemv2XfAdFcQ9znU4Viqg9ta1qYJ+D1BnAIBrkgGVOrXNqUA9rbyZm/AEzFh4jEeY/soAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-intersect-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxkrkOpp2wAAAPhJREFUWMPtV1EKwjAMTUavI3oawR/vtn5srJdREfzwMvHHQlcT2mpdMzFfWxiP5r2+JMN+mAiCOB72CABgR1cln4oOGocJnuMTSxWk8jMm7OggYkYXA9gPE3uyd8NXHONJ+eYMdE/NqCJmEZ5ZqlJJ4sUksKN7cYSaPoCZFWR1QI+Xm1fBACU63Cw22x0AAJxudwrffVwvZ+JmQdAHZkw0d4EpAMCw8k87pMdbnwtizQumJYv3nwV6XOA1qbUT/oQLUJgFRbsiNwFVucBIlyR3p0tdMp+XmFjfLKi1LatyAXtCRjPWBdL3Ke3VuACJKFfDr/xFN2fgAR/Go0qaLlmEAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-subtract-mode{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUFFxgsF5XNOQAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAABFUlEQVRYw9VWUQqDMAxNpWfxQxD1MoP97G7zQ5mH2RTZYLtM9lWoMbXtxLXNX4OG9r28l4hrd0PQoqxqAACYpxH25C/nkwCHyCBwSPoS09k1T5Fo+4EiExcC4v584xGFmyIXHBLRISAVZyZufUPVa4rcrwmPDgr93ylo+2GliLRUYHK6th/o/6r7nfLpqaCsagEA8Hh9FmcNKeRmgeYDC+SCq0B6FFi8/BcV6BdR9cL3gCv3ijPKOacsn3rBEcjmaVxpfGcg4wHxzgJJnc6241Hn23DERFRAu1bNcWa3Q0uXi62XR6sCaWoSejbtdLYmU3kTEunNgj0bUbQqYG/IcMaqwPS9jftoVCAQ0ZVDJwf0zQdH4AsyW6fpQu4YegAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-clear-selection{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH5AUGEhcuan3d3wAAAoRJREFUWMPtlzFP3EAQhd+b3TNSzg0N5TWXLkJQUUaKhIQ4fgP/g5ArrriE/I3opEgRrZtIVJR0FJQ010SioUmEZHtnUpwN9gWHGA5BJCy58MraffvmfZ41v3z9hqe8BE98vQh4cgG+Ydzmnrng8efvQJNi/uN7dznx/B3ggtfhf4ehNdUttRzBDIm/2VTiiWCG1HK0nc+3UWtq8BQIiEEakEQOADBIA4QCQmBqoHBhFNR27ikQSmGdYCdTqCpEHMDZmEKRWUBEv1gBDg5SzRJnpopILWICgWuRYflLamuzxB2BmtYqSRIka5VWU8QduXO+1hRc5YZu5GAwmP2ZJzND0IBu5HCV2+NQcAhAVRsnC2IbPzPdSjzd6to6VtfWkXi6YLaVWr7xoAwkfpb8MnC3SH7rKSMBe4M0jA/OTicFIbtCGRIyNbURhcf3ErCd6YwA1m0HgAxhw1NGQnlXBHG4kylVlSJuH0RfIP2CkL2I/qS1gIAAQiBl1QwFggIHtyxgrxK5PgyfC0JWKoT0HLh8LwoietB4TYKaIl7yeNURxB05UtMxDOcVQlZIrlRKdK6m47gjR/fuBRQihyLArtNeJD50Izcx2Eczu7iFkIug4VM3cpOr3MKDekFED0fWUHv9Zq0kpLnridjhY3XDg7NTN0jDrhO3X7O9Wg7wwyANu4mnayNg3gmbu0tCNoUyBNGv2l4rB9EXynA7082FOxAQLhU6rQVO9T2AvWowFToNCJcPORGxIRcnpjZSKATSU9NxvOQnAPArDSaQoUKnNI4iufkGtD4P3EHIcWZhz4HLceSOyrR3Izf5memPAL2cX3yhAkonysZVaWLBkd9dw1Ivv2a/AYPkK+ty1U1DAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-box-select{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg0kduFrowAAAIdJREFUWMPtVtEKwCAI9KL//4e9DPZ3+wP3KgOjNZouFYI4C8q7s7DtB1lGIeMoRMRinCLXg/ML3EcFqpjjloOyZxRntxpwQ8HsgHYARKFAtSFrCg3TCdMFCE1BuuALEXJLjC4qENsFVXCESZw38/kWLOkC/K4PcOc/Hj03WkoDT3EaWW9egQul6CUbq90JTwAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-box-zoom{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg82t254aQAAAkBJREFUWMPN11+E1FEUB/DPTFn2qaeIpcSwr5NlUyJiKWVXWUqvlUh/iE3RY9mUekkPPURtLKNRrFJEeuphGfUUaVliiX1aVjGs6aG7+XX9ZnZ+d2fTl2vmnHvPPfeee/79Sk+may2/UQq/q7Qu+bAJoxjHIKqB/wlfUMcMVqI9bLZ+DGIKwzlzQ2GcxCx2xwvKOUKlaHTiX8bHNspjDONHkOmJBW5jIof/FvPh/06MZOb6cRc7cGn1AKUE5cdzlM/gAr5F/O24H3xkFRfxAbVygvK+cIsspjGWo1zgjeFpxL+BvnLw7laBA4xjIFJwrgu52DoVjKdY4HBEX8dSF3JLYe1fe6UcYCii3xWQjdfuSTnAtoheKCC7GNED5Zx4L4qt61jbTLHA94geKSC7P7ZeShQ0Inoi1IJuEOeORooFXkV0FZNdZs5qvFfKAeqYy7nZ6yg//HG0MBfffh71lFrQDCW2EvEP4mt4okZUDftz9rmGZkotmMxJRtlisy+MTniAWrty3AlXw0hFM2TD89l+oNsoOJXjbIs4EpqNtTCLXbiZ0g+M4mFObj8U3vsNjoZCVcmk60ZwthpepLZkB/AsivWfOJZxtpUQHfWib7KWDwzjeegBZJSdKFiE2qJTFFTwElsi/unQ/awXrU4WGMD7nOJxBY/1EO2iYConq93CHT1GOwucjdqnRyFz+VcHmMNefMY9nNkA3SWUOoXhQviSWQ4huLIRFlirFixnQq/XaKXUgg2xQNGv4V7x/RcW+AXPB3h7H1PaiQAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-zoom-in{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsUBmL8iQAAA2JJREFUWMO9l12IlFUYx3//MzPrLpSjkm5oN4FFIWVEl66IQlFYwtLOzozsjHdGRSCRF0sfBEXRVV0FQuQiLm5CZNBFgRRaRLVFhbJ2EdiN5gbK7toObTPn6eYdPTvNzPvOBz5Xh/ec5/n/n89zXtEHmZqeSXSuXBz/3zfdKvBWJHQrwZuRcP0El+QkbQXeBX6WZEgm6TtJk5lM5o4Lc+cV6qpf4Ga20Tm338zeATItVK9Ker6yvPzp4NDQ3+XieGsCU9MzTYumGbhz7m4ze9/MHgvBgItACrgfGAj2jgAvAYs3wlEujjc13kii8YyZrXXOfWhmo9GnFUlvOOemarVapVqtkslksmb2KjARqL62ecuWN9NxbRInzrldAXhV0uFSIfdew7G/gNLU9MwS8CwSmE3Oz88fcXG5blfpqVRq0Ix8VIAAX0XgrVL7HDCHGcCaWrV60LUBN8Dae58aQIxEqcA592I9M610JL0cpG/U9TIHJNKY3RV5z0R+7Nd4HZ0P1g/2RMBuegLAsRMnb4vT8d5vqKfMzOgtAlADrkmqGywmiMBTwfr3dC9j1Xv/r6Tvg/5/5ejxE6cO7M9faVbQZrYNOFSPmqQvVo9FKexvi5uWX58943aM7DwAfBDY+FbSCxP5sdkGx55GeguzrUEXPaSo2pFkAbiSZQCAzZJOmdkjwd6SpB/M7KykQTPbA2wDhoIzRzcNDx9MJwGNIXdJ0mEzmwbujL7dbma7gd03A7lKfnTOvf74nl0r6bonTUbujRSUCrm2d4L3/kvn3JPe+8+BDW2i9o+kT7z3kxP5sYsA6W47oE64TsR7P9tQL4vA2mh9WdIscKxUyJ0M7aR7acOGzikD65EQLEjaa2ZXzMwDFeB6qZBbbLTRE4EGeSaozNOZgYFf8qP7lmIvs354n0qlHpB0T7B9Ogl4IgJJrmjv/SiQjbrkD+BMUkfSbYATPdckrTOzkciWAXOlQu5cYgLdPEIapud9wMOR9zVJH3ViKx333mtHMJvNuoWFhZ3A+ojMcja77njXBEKwJJfTcqUyCIQ34Mf7nnh0paMnXacFuGoC1mr3AtuDfLzd8Zuyl+rfuGn4HLAD+Az4qZQf+61TAj0Noj8vX6oC35SL43u7teG6rf5+iXppwW7/JUL5D03qaFRvvUe+AAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-zoom-out{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgsHgty9VwAAA0FJREFUWMO9l09oXFUUxn/fmXlpItppi22k7UJBRSlVkCytSAuKUloIdjKT0El3FXVXdVFKRVAQV7qQohsNwdA0UFvBhYtqUVyIVlRaogtFQVq7qSTVjA3z3nHzBq/jvPmTN/Ss7rv3nvN99/y794kByMzcfE/7picn/jenmwWeRUI3E7wdCRskuCSTdDfwBvCtJEdySV9KOhpF0e0/LF5SqKtBgbv7ZjObcvfXgShD9Zqk5+orKx8Oj4z8NT05kU1gZm6+bdK0Azezu9z9hLs/HoIBvwAF4H5gKFh7B3gBWFY3460kWve4+3oze9fdx9OpVUmvmNlMHMf1RqNBFEUldz8OHAxUX9q6bduryut+Sfvc/Wz62ZD0fK1afjND9y3gGSRwv1GMojstTxUUCoVhdyopEYDzKXjWwZ4FFnEHWBc3Goet00m7lZlZYQixKw0FZnakGZksHUnHgvCN5/KARBH37enpOVg58H13HV0Kxg/kIuD/ngSA2ZMLt3bTSZJkUzNk7k4+D0AM/CGpaXCyBw/sC8Y/qZd2GpZiuL9YLN4Sx/HpoP5/c/exQ1OVq+1yyt13SLoArEsJnMjlgfOffvK3u58Kprab2QezJxfG2iTzUzI70wRPG9jbmpmb95SNB9mpzp7/j2yVdNbdx4K565K+cvfPJQ27+x5gBzAS7Hlvy+jo4WIvoC3kWpcvS3rR3eeAO9K529x9N7C7zX6AC2b28hN7Hl1Vt44niVq13LUjmtlYkiQfA5s6eO+GpDNJkhw9NFX5ueNt2ARodyF1IHIN2JiOl4H16fiKpK+B2Vq1vBAqFAf4IJkGNiIhWJK0192vunsC1IE/a9XycquNXARa5OnApeeioaHvKuP7r3dTGsiLqFAo7JR0T7B8rhfwXARa2us4UEqr5Ffgs151i/08oTNKdIO770ptObBYq5Yv5ibQq/sl3Qc8lJ4+lnSqH1vFfp9koZRKJVtaWnqkWXqSVkqlDe+vmUDWpZMlK/X6MBDegKf3P/nYaj8ErN9fqZBYEsf3Ag8G8Xit33BaniTcvGX0IvAw8BHwTa1y4Md+CeRqRL9fudwAvpienNi7Vhu21uwflOT+L+i1X2TJP57iUvUFtHWsAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-help{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAAlwSFlzAAALEwAACxMBAJqcGAAABltpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IlhNUCBDb3JlIDUuNC4wIj4KICAgPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAgICAgeG1sbnM6dGlmZj0iaHR0cDovL25zLmFkb2JlLmNvbS90aWZmLzEuMC8iCiAgICAgICAgICAgIHhtbG5zOmV4aWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20vZXhpZi8xLjAvIgogICAgICAgICAgICB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIKICAgICAgICAgICAgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiCiAgICAgICAgICAgIHhtbG5zOmRjPSJodHRwOi8vcHVybC5vcmcvZGMvZWxlbWVudHMvMS4xLyIKICAgICAgICAgICAgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIj4KICAgICAgICAgPHRpZmY6UmVzb2x1dGlvblVuaXQ+MjwvdGlmZjpSZXNvbHV0aW9uVW5pdD4KICAgICAgICAgPHRpZmY6Q29tcHJlc3Npb24+NTwvdGlmZjpDb21wcmVzc2lvbj4KICAgICAgICAgPHRpZmY6WFJlc29sdXRpb24+NzI8L3RpZmY6WFJlc29sdXRpb24+CiAgICAgICAgIDx0aWZmOk9yaWVudGF0aW9uPjE8L3RpZmY6T3JpZW50YXRpb24+CiAgICAgICAgIDx0aWZmOllSZXNvbHV0aW9uPjcyPC90aWZmOllSZXNvbHV0aW9uPgogICAgICAgICA8ZXhpZjpQaXhlbFlEaW1lbnNpb24+MzI8L2V4aWY6UGl4ZWxZRGltZW5zaW9uPgogICAgICAgICA8ZXhpZjpQaXhlbFhEaW1lbnNpb24+MzI8L2V4aWY6UGl4ZWxYRGltZW5zaW9uPgogICAgICAgICA8ZXhpZjpDb2xvclNwYWNlPjE8L2V4aWY6Q29sb3JTcGFjZT4KICAgICAgICAgPHhtcE1NOkluc3RhbmNlSUQ+eG1wLmlpZDpBODVDNDBDMzIwQjMxMUU0ODREQUYzNzM5QTM2MjBCRTwveG1wTU06SW5zdGFuY2VJRD4KICAgICAgICAgPHhtcE1NOkRvY3VtZW50SUQ+eG1wLmRpZDpBODVDNDBDNDIwQjMxMUU0ODREQUYzNzM5QTM2MjBCRTwveG1wTU06RG9jdW1lbnRJRD4KICAgICAgICAgPHhtcE1NOkRlcml2ZWRGcm9tIHJkZjpwYXJzZVR5cGU9IlJlc291cmNlIj4KICAgICAgICAgICAgPHN0UmVmOmluc3RhbmNlSUQ+eG1wLmlpZDpBODVDNDBDMTIwQjMxMUU0ODREQUYzNzM5QTM2MjBCRTwvc3RSZWY6aW5zdGFuY2VJRD4KICAgICAgICAgICAgPHN0UmVmOmRvY3VtZW50SUQ+eG1wLmRpZDpBODVDNDBDMjIwQjMxMUU0ODREQUYzNzM5QTM2MjBCRTwvc3RSZWY6ZG9jdW1lbnRJRD4KICAgICAgICAgPC94bXBNTTpEZXJpdmVkRnJvbT4KICAgICAgICAgPGRjOnN1YmplY3Q+CiAgICAgICAgICAgIDxyZGY6U2VxLz4KICAgICAgICAgPC9kYzpzdWJqZWN0PgogICAgICAgICA8eG1wOk1vZGlmeURhdGU+MjAxNjoxMToyOCAxMToxMTo4MjwveG1wOk1vZGlmeURhdGU+CiAgICAgICAgIDx4bXA6Q3JlYXRvclRvb2w+UGl4ZWxtYXRvciAzLjY8L3htcDpDcmVhdG9yVG9vbD4KICAgICAgPC9yZGY6RGVzY3JpcHRpb24+CiAgIDwvcmRmOlJERj4KPC94OnhtcG1ldGE+Cphjt2AAAAT7SURBVFgJxRdbaFxFdGb2bhui227BWrsVKYgf2kJUbP9EUPuzEB803WTXJjH61Q/7Ya1+CMYKEVTsh4J/EpvY7BoabUiNiA8s1p+4KIhpoUUEselHqyS76TbZ3HuP58ydc3d2u4+IkQxczpz3mZkzZ86VYpXjvenpjZsLhUcliE4AuUuASAgptmt1EFdwPiclzIIUUwubNn17OJlcXo1p2UpodHRiux9xB1Eug1+slbzhFxGOKc851tu7/0oznYYBDA8Pt0U2tL8KQryIq2tvZqQhD0QJHRz3yqWhgYGBpXpydQMwqz6NCnurleCSADkJEfgKfOePqL80R/wV1ZaQyr1LenKfkPCkEPKeaj0xg7vxVL3duCmA0Vyuw/fl52hgBxsBED+h4Cv9z3R/zbRm8MTJTx7HQN7GQB6w5C4L4SX7M5lfLBpurjXMyvNIShiyi0l1pL8n9b7EDGPR8fHxzSsQ6XDB3618/xqo6Pk25V5MpVJllgHM1BO58RdQ612kOYZ+GXdij70TYQB05mpj+1kU5G2fB+l3PZtOf8NGx6ambnMXb3yAxg8wjSEG6OKKR9oicBQD+ZvpH2Wzj0lQpxCPG9qMv1x6hHNCsSAlHM7ZOa682vlI9tRDbvHGbD3nZAPpDoD/3JIrLpAs26UFkC3EMUA99hpfGtEBfJjNJnS2Gwnadnvl+Xw+iuc3DAJuNyIaSCHpilVldyDjjUxj3WDZIAhxhHHyRcdNuA7AAfUaXzVKODpzFiZ4/uLvh5G+m2no+C/pyIf7MqlEJB7bpqR6nXkEUfbeawuLaZsW2ISfNQ2vtaktQlGFQyIVGT0o2+2EC4iQNGwjBIN9qdQ5Qg4mk4X4rW3vCClLtowE2FOFUxKDfNmiZci3ovKKRFPh4FK9q4Zbdr+lKKJiA13TcHR2dmLBgdmQ0GAS2MZaEowY+XbAk09IvgtYZGp16SyvFhaHcIUh645t8T9DBCcnz5zZ4hZLu3DzK2QlL1QQa0Y+pHiJKPSuOGj3PmZTheM5w2TwqBxnvBZOTk7G5gvXJ5Aelms8wnJURL+olSWcfEhf6gDoUXPMq6ZlqbzWU2pE+3hi4s6F68tfIj9cBMlikr7Z0/P0b/X0yIcUXsDCF1WhtL4OROHaXk+xlkbV0Cu732Nmhc4peaWSg73pA8dq5RkvO37ldUTfXCKZv2q45MkhvG87WQEzpCCUSvV1d9GONBy3lMvgKSwrZig8gjAietWY0QriylO2jIo4yVbOSb7KB/qmI9BPKjHpSSXYauRyn92Nq9/Kcrj13x3s3v8D481glQ/0raiNYgX9njPSBOImbrHZePl+tfFmc9sH+Xaoh8NjOKSVdDMhjjYzQLy+dFceH5+IJQf9VYXX4tROg4ZFU8m31M3mfPEqUoJqCGJfvWpo2xnNfdrhC28n06SCeSzNZxlvBINGRXCtKS7EY1uV6V7HWAm38y1cXaXsMcOCvr9ySPj+af7A1U2HJXHzVNvUXVLIGyPf+jV0pf8GHoN+TLAyPkidTCi2RpPApmnR0Bd1zGRaB/B8Oj2HSw7LLbVR1MmskW8RdEWVXSJf3JbpAMgRtc4IZoxTh9qotQjCasm46M0YX9pV1VmbpvRH5OwwgdRtSg2vKaAz/1dNKVtb17Y8DCL4HVufHxMOYl1/zTgIgiYvBnFKfaNp3YjTdPz3n9Na8//X7/k/O1tdwopcZlcAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-hover{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4oVHp0SwAAAQJJREFUWMPtlsENgzAMRb8RQ5VJItFDOgaZAMaAA0iZpN3KPZSoEEHSQBCViI/G8pfNt/KAFFcPshPdoAGgZkYVVYjQAFCyFLN8tlAbXRwAxp61nc9XCkGERpZCxRDvBl0zoxp7K98GAACxxH29srNNmPsK2l7zHoHHXZDr+/9vwDfB3kgeSB5IHkgeOH0DmesJjSXi6pUvkYt5u9teVy6aWREDM0D0BRvmGRV5N6DsQkMzI64FidtI5t3AOKWaFhuioY8dlYf9TO1PREUh/9HVeAqzIThHgWZ6MuNmC1jiL1mK4pAzlKUojEmNsxcmL0J60tazWjLZFpClPbd9BMJfL95145YajN5RHQAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-crosshair{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADEUlEQVRYR81XXVIaQRCeHqug8CXmBNETaE4gniDwIgpVspxAbxC9ATkBkCpQ8gKeQDiB5AQxNyAvUlrldr7eHxyGXZi1rMJ5opbp7m++7un+htSGF204vsoMoNXrlzSpfWa1oxQfhAegCZGaEtPorHo8znIoJwCt6+td8uk7ApUQCIHTF4BNAWzImq8ap6cP68CsBdDp9i9ZqXM7ML79g/EnCWD+jgMKENKqWT+tXK0CkQqgNRjs0OxpQIqKhoMxaG6/6JeRnK7T6yO2UvVqhYSlLX+ryORfgKn9ORDFIy7ky41yGcwsr0QAQfDH5zucOswx819fs4egI9OFCcD8DjBF7VNbEX0JzdWEt3NHSSASAcCxBDqMgt/623kvyTgNgNjJIfTjk4D4FqaJR1715MjmYAmA5Bx3AwUXQL+t105KaTlcBSC26XRvhjEIoLiq1yqXpr8FAGG16/ug4IT27fxBWu7EiQuAiImJpEMKE6nYM30uAIDDttSUOPfJP7JzbjPhAiBIh9QE67vIvoOi9WJfCwDavf40ulpjbCqmUf+W753ezURuh7Dg1SqflwAEHU6pgfyBq9Y4qx0LG++2fnZ/eUzcstmdM2AWH+jfc+liWdBJfSENf8Lifi3GVwC9mybOfi5dzatWVrbbLIHNva8p5h/16gkaFiLGGxbufkoE6XguwePiXLF3XmMfCUCUAqtKXU7sumd1CowOuJEi3Pg1FBpjitIGhyvVSfvmjci6ZR+rFQfDiPVE2jFYeICQ+PoewwjC5h7CZld6DBdyu6nDSKgzOyIMhmhK5TTqXYbRorZYM46TmpKAAOrGWwSJJekSB1yqJNOzp1Gs7YJ0EDeySDIMtJbQHh6Kf/uFfNFZkolJICRmz0P8DKWZuIG2g1hpok+Mk0Qphs0h9lzMtWRoNvYLuVImUWrmPJDlBKeRBDfATGOpHkhw670QSHWGLLckmF1PTsMlYqMJpyUbiO0weiMMceqLVTcotnMCYAYJJbcuQrVgZFP0NOOJYpr62pf3AmrHfWUG4O7abefGAfwH7EXSMJafOlYAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-lasso-select{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgwlGP1qdAAABMBJREFUWMO9V1uIVVUY/r61z57ZMx4DnbzgkbQXL5iCJphlWdpIGY4jpFBkEiU9ZNaDRRcITcIwMwgxoQtU2IMXdAZfMjFvpERXYiSbysyBEXFmyuHMnLP32uvrwT2xnY5nxvHQ93Jg7fWv71/r//7L4a59TRgqJk+Z6v3a+sv0OI5nk5wu6VaSVZImAThHsgjgrKTvM5nMUWvtmf5n8HodCIKgOgzDhc65pSTrJQWDsSNpJX1ljHnDOfdT37oZLLHv+8OMMasKhcIJ59xHAJYMlhwAJGUAzJfUTHLFuFzOG5QDU6dNMyQfs9Yedc5tBpAD4IYYNQGoBrDtQnt7/b0LFrJsCHzfn2itfQfAnZLiazytA3AaQAuAiwDaEgeNpGkkswAWSBqRONB38b88z5uTKePt6iiKXkk8jq+iJC5LOmiMaTLGHLPWhmWeHr7vV0dRtATAapAzIVmSo51zyzIlbm2stesFPA6pKk0r6Ryg93y/ek8YFvPOOTg3cDSiKCoC2OP7/rEoirYm4rUkF12lAWNM1lr7lqQn0+QA8gI2jBg5cj6Aj8OwmB+KAKIoukhyp6SRJAUgl0ndPLDWPi9pJQCbuviXvu+/GIZhW1dnJ24UJFuTjCCA2ADA8sYGWmsXS3qmL94kDYAtkh4Nw7ANlQJ5U6INT1KrAYC9zQdykl7nFSj5fXp5Y8NWVBhy7mUAjqShMYdMXV2dJ2klyRwAJ8lIeuGWCRMP7N7frEqSG2OmAFhKshNAp5wrmO7u7jEAngPQm1S2z2pqapr+OPt7XEly0oxwzq2RdFmSD2AMgKKJouhhAL4kA+Cs53l7e3t7uytJHgRBreTWkXwkKVJnJD0B4GAGwIJE9R6AFufc6UqSZ7PZbD6ff5dkA4CQZEHSqwAOISmXtwGIE+F1SeqqIP8d+Xz+C0mLJYWSAODteXffczjdDQNJ0BWMCoLg5gqIbRTJNwHsljQhUb0luWPM2LE7Thw/9m/5NCT/TByxAOYWi8X6/gdWV1dnfN8fNRBxJpMZTXKdc+6IpFVJWAEgkvSJpA0X2tvtVTaSjgOYBCAEEADYSHK87/sfhmEYA9gShuEDkgzJHyWtB/B1irQ2juP7ADxkrX0wOUOpzmdpzEY590HJ7Ni1r2kSyZOSiv2+hSRjSTXp/QAukzySNJOJkmalyNIl10hqMcasdc61XDNcQRD8BnITgNp+36r6kfcNFMMlLQGwTNLMEuQGQBfJl2bdPru+HDkAZAqFQux53jZHEsC6aw0eg2gylNRBcqcx5v04ji999+03AwsWAOI4Lsy9a94WkisAnE5a5WCJYwCfA1g7LJudI2lTHMeXBm1faiQzxkyRtF3S5CTupeAB+KG2tnZFT0/P30NO2VKLzrmfAbwGMipjG5Oc0dPTc0Md05SZ5U4Q2FxChErtEYD7jTGNQ3UgM8Asv90Yc9I5LSKRlXSI5CxJa0jWSALJjKRnAewfkniT+vwf7N7fXHK9rq7O7+jo+BTA/NRrdBpjnnLOnUrvXd7YMPQXSBunneno6IhIHgYwW1JtkgmBpBkATlVMAwOk3nFJ+VSoqgCMr6gIy2FcLtdKspAedyQN/98caDt/3kpyabUmf8WvG/8A1vODTBVE/0MAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-pan{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4lKssI9gAAAOtJREFUWMPVll0KwyAMgNPgoc0JzDX2Mtgp3csKErSamGabIEUo/T6bHz0ezxdsjPJ5kvUDaROem7VJAp3gufkbtwtI+JYEOsHNEugIN0mgM1wtsVoF1MnyKtZHZBW4DVxoMh6jaAW0MTfnBAbALyUwCD6UwEB4VyJN4FXx4aqUAACgFLjzrsRP9AECAP4Cm88QtJeJrGivdeNdPpko+j1H7XzUB+6WYHmo4eDk4wj41XFMEfBZGXpK0F/eB+QhVcXslVo7i6eANjF5NYSojCN7wi05MJNgbfKiMaPZA75TBVKCrWWbnGrb3DPePZ9Bcbe/QecAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-xpan{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4X4hxZdgAAAMpJREFUWMPtlsEKwjAMhr/pwOOedINJe/PobWXCfAIvgo/nA4heOiilZQqN2yE5lpD/I38SWt3uD9aMHSuHAiiAAmwaYCqoM/0KMABtQYDW11wEaHyiEei28bWb8LGOkk5C4iEEgE11YBQWDyHGuAMD0CeS30IQPfACbC3o+Vd2bOIOWMCtoO1mC+ap3CfmoCokFs/SZd6E0ILjnzrhvFbyEJ2FIZzXyB6iZ3AkjITn8WOdSbbAoaD4NSW+tIZdQYBOPyQKoAAKkIsPv0se4A/1UC0AAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-ypan{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4anK0lywAAAMVJREFUWMPtlzEKwzAMRX/S7rlpIMXeOnaLaME36FLo8XqCdNFghGljyc4kgQi2Q/SUj0F/eL7eMMTKz6j9wNlYPGRrFcSoLH4XxQPvdQeYuPOlcLbw2dRTgqvoXEaolWM0aP4LYm0NkHYWzyFSSwlmzjw2sR6OvAXNwgEcwAEcwAEcwAEcoGYk20SiMCHlmVoCzACoojEqjHBmCeJOCOo1lgPA7Q8E8TvdjMmHuzsV3NFD4w+1t+Ai/gTx3qHuOFqdMQB8ASMwJX0IEHOeAAAAAElFTkSuQmCC");}.bk-root .bk-tool-icon-range{background-image:url("data:image/png;base64,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");}.bk-root .bk-tool-icon-polygon-select{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjc1OfiVKAAAAe1JREFUWMPt1r9rU1EUB/DPK0XbqphFHETo4OCiFhwF0V1KHbRSROLqon+AUMVRRFBwEbRFMBiV+mMW/wIxi5OD1kERRVKRJHUwLvfBTZrU5OWBGXLgQu7Jfe98z/ec7z0vKa88b2q1BDtRHdAPBaylm1NzsxsOjPnPNt6WSWprbft+/c3I3zOAjhT1Y4+fvcjEQJIXnVECSa+AhqIHqlHH5lWCZoe+Gk4GRgDG86j9SAUdlDBSQaZhlOkuHyoVdJmsw98D1S5fM4NYM1LCpqM+Lwa240oLgmZzpVZvzKT75VLZcqksSZKWlQeAy/iORVwIvh31xvotvK7VG3Px4aWHj3Jl4C2uYSvq+Bn8v6LLbaVWb9zsBiKLCvbiNG7gLm7jAYqbPHMJMziZ9lsKoh8GtqCEVVzHftwJn+TFHp4/hg8BSCYVfMOZoPEv2NZGdy9WCGUr9toDR3E2/H4V6nwRe/BmgN65H1ZhvMuB3XiKIyFoGefwO6ysVkUlrNUNsyAK/jli533Q+Y8cJFvAeXyMS1CI/jiMr/gUtD2LQwMGr4R3p7bY3oQHQ5b38CT4D2AXXg6YcQXHpyYnlqKsi5iOAVSwL9zd7zJ09r+Cpwq72omFMazjT9Dnibym0dTkRDUKrrgwH7MwXVyYB38BstaGDfLUTsgAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-redo{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4itK+dVQAAAaFJREFUWMPt1L1rFFEUBfDfJDaBBSslIFjbaSFp1FJQFMVCHkzhKIqdUYOCoBgErVz8rCwiTDMwBCIKipDWyip/gxAIWAmBgBC0eYFh2Gx2l9lFcA5M8e59782Zc84dWrT435Hs1siLchqn43MS0zgW22vYxjesYjVLw3YjBPKinMUTBOwf8J5fKLGYpWFjJAJ5Uc7gIW6jM6Kim3iNZ1katgYmEL/6I+YasvY7Lg6iRpIX5VF8wuEe/XV8wGf8jN6LWTiAc7iEQ7ucPZ+lYW0vAtfwvlbfwCKW9gpXDOv1mJvZHiSO91MiyYsyiQSuxtpXXM7SsDmM5nlRdrCMMz3sOJWl4Xevc/vwBzdwAl+yNNwZxfRI+GxelK9ikHcwh8d4NNR/YFRES1ZwoTYdR7I0rNf3TzVNIGbmSvR/Bx08mIgCFSVu4l2ltIWD9WxNGR+W8KOynqnZ0rwCeVG+wa0hjrxtWoF5dAfc28V8Mib/n+Nev5dnabg/zgw87aNEN/bHOwVRiRe4Wym9zNKwMKkpgIWKEt24njxiJlq0aPFv4i9ZWXMSPPhE/QAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-reset{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4gWqH8eQAABLdJREFUWMPtlktsVGUUx3/nfvfOlLQaY2IiRRMQIRpI0PjamJhoVASDvNpCpYw1vJQYSVwZwIVQF6wwRHmkAUof9ElrI6VqDAXcID4TF0IiYQMkSlTokNCZ+b7jove2t+NMH7rQBWd3v+989/zP+Z8X3Jb/WGQySvUNTQBJESkNguAVYIWqzhaRhwBU9WcR+QXoymazn6jqzUQiMQSQzWZRVdal1vwzAI2tHQBPOuc2AbWTdOyQ53n7nHNfRwee51GzqoIQMCLDpr3x/tLQ0oZzrk5Vj0/BOEBt+KYuOlBVGlrahr0Wob27t3gEjnZ2AyQzmUwHsDgP6J/AYRE553neDwDOuUdU9QngNeCumK4TkRMhZUORcYC1qysLA6iuSQHIwkWLD6lqapQsuSmwTVV3h99I7EcAR462A2xR2Ilq6ehTaejvO1774kuLNALR33eclsaGsQDe3fYegHl43vyNwEeqGl1963mm2jl7YZRTQ82qlWP4HM6ZToC5ztkW4LHQoALru7s6Di5dvlIj/e6ujrEAWoZDn8hmMjXATMACGaAVuBjXTVVXFc/AxhaA+4zvn1DV+eHxVWPMAmvtb5GeMWZyZVhI2rt7qVy2pOh9U1snwIPW2vMi4oWJuBPYHkVAVScPoKmtkzVVK6cEMsyJraHhiCqJqJUwj/JRz7TW1iSSyR2rVyylqa0Ta+24Ic8vXaAEmDFc/l5Z2A/80OibuVyuz/f9ElUdHCmvw82t5HK5h6y1PYhsz2YyGw43t2KtBZHIGwB6+j4rCkBVUdV7gXrggnPuu8h4eP+xMeZS2D0rJYZ6AdAMzAt1b4nI26p6IFZOY8pugijcKSIHVLUK0LyST4vnrVfnWr3mjmP4QTATaERkXkypRFX3isjmuHdRJEK6Ckqquopp06bdKCkp2Sgi7XnGLcg7gzeutwNIiPYc8HixqIrIOlU9ONVIhHPEd851icgSVXUiskVV94gIqoonIt0i8gfQCfwae38e6BWRXuBZz5jZ8VbaOE4EIqlZVUEQBLlkMplS1QER2RwkEnsSyaREDUzyeNsvIhvCMqkH1kdIJ2o+k8iJB1LVVRfjZ6nqqlEAIbdVQGto8Lrv+/dbawcjAL7vc+6bs+zetetfLSHxniIFGofGGsU2oC7eOCbDfZ7nQawBOSAX74SF9oEPImOq+r7nmVmxb5raukZa8UReGmNmhbMkAwwBH467EYVZe49z7kdgenj8k7V2oTHm8kgdWcvrNdVFjR8cHkYzjDH9wLjDaEwEzpwa4MypgWvAjtjxfGNMj4jMiT+M+kFsZI/Q6Pv+HGNMT8w4wI7TAyevxXVPD5z8+zD64tRXAMHVK1eaVLUyVvuDqroV2BOnJF4ZIedviUidqt4Re9s+vbx8zZXLl7PR2+nl5Tz/zNOFp2FzxzGAklw22wUsLLaSKXwf8vhosZUM6PeDYEUum70VHfpBwKsVyyfeikOP6oBNwN1TrLbfgX3A1kKLzKeff8nLLzw38T5wZDgxn1LnNk5lLRfP26/OnR2hwfNYW2Atn9RCsrf+EECyrKysDFimqhXhyjY3VLkAXBKRDqA7nU6nS0tLhyIj6XSaN9bVclv+l/IXAmkwvZc+jNUAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-save{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4UexUIzAAAAIRJREFUWMNjXLhs5X+GAQRMDAMMWJDYjGhyf7CoIQf8x2H+f0KGM9M7BBio5FNcITo408CoA0YdQM1cwEhtB/ylgqMkCJmFLwrOQguj/xTg50hmkeyARAYGhlNUCIXjDAwM0eREwTUGBgbz0Ww46oBRB4w6YNQBow4YdcCIahP+H5EhAAAH2R8hH3Rg0QAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-tap-select{background-image:url("data:image/png;base64,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");}.bk-root .bk-tool-icon-undo{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4em8Dh0gAAAatJREFUWMPt1rFrFFEQBvDfGhACASshkL/ALpWVrSAKEQV5sIULWlgZNSgIFkGIVQ412gkBt1lYLERREFJqJRaW1oHAoZUQsDqwecWy7N3tbe6C4H2wxc682Zn3zTfvLXPM8b8j6RqYF+UCzsfnHBawGt3fMcAX7GEvS8NgKgXkRbmMxwg41TLsN0psZmnodyogL8pFPMIdLHUk7hA7eJKl4U/rAuKu3+HslFr/FZezNPSTFslX8QErDe4DvMVH/Iq9F7VwGpdwZUjsPtaSFjv/1vCBPjaxO0xcNbHejLpZrrlvJCMCT+JzA+2fcC1Lw+GE4l3CG1yIptfjCtiKoqtiJ0vD3aM0Py/K57iIMxgkQxat4EdN7e9xdRzlk+LEEPvDWvIDXJ928sYxjL36icWK+VaWhlezOIqbGFirJd/H7szugrwoX+D2BDEvszSsT5OBdfRaru/F9dPXQF6U27g/KnmWhgctxqyzBrZGMNGL/rHI0nDkKXiKexXTsywNGx0OnFbFNk3BRoWJXnw//j+ivCi32/S8CxPVNiWOAdUiJtXITIqYY45/Cn8B2D97FYW2H+IAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-wheel-pan{background-image:url("data:image/png;base64,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");}.bk-root .bk-tool-icon-wheel-zoom{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEgskILvMJQAABTtJREFUWMPdl1+MXVUVxn/fPvf2zrSFmUKnoBCUdjRoVaIxEpO2JhilMYBCtBQS2hejpg1Uo2NUrIFAoyGmtiE+GHwQGtvQJhqDmKYRBv+URFsFDNCSptH60DJTO3dKnX/33rM/H7rvsDu9M20fDMaVnGTvtb69z7fWXmvtc/TEzqd4OyXwNsv/FwFJQVI/sA14SZKRLOlPkr5TrVYXHz70quYkEEK4TtI2YAgYkrQthHDdhV5uuw+43/ZrwCbgRttgY/tjtrc0m83X3/f+D6ydnJhYcB4BSZcBA7aP2d4ELAGW2N5k+xgwkDB0IH19CGGH7R8B1aQeAf4KvAw0ku4K2zu7uru3ApdPEyiKohd4TNKjtjt5h6RHgccSNrddbvuHtm9Jqoak7xVF8WFgdavV+pSk5cCObNmXgK++85prCj3z28HKqZMnH7D9YAY4BvwujT8BvCuL1INX9vVt+dfwcCvNb7f9q2RuSfrGvWu/sL2Nf3LX7pzvj4ENSGBPVarVd4fRkZFltjdmoMGiKO4IIWwIIWwoiuIOYDDzeOPoyMiyFLkum7WJCMDztrcrTTrIRuAQZ6NcK1utL4dWq/VZoC8BhqvV6l1lWb4YYxyLMY6VZflitVq9CxhOmL60hhCKeYiV7WMKIXw9jT1HpXw3c+bOAKzOjJubzebJrKQCQLPZPClpc7bP6rMYKtjXth2OMf7tIkr11Wz8oQDc1Fb09vY+kQw1YAuwJY2nbUluAnCWpKkaFl6IQIzxivaR2SYA89sJVK/Xp2x32R6w/a30DNjuqtfrU0ArYecDCEqgLqm94T0dEm9mBG7PxkdDlkBnkhebgIezNQ8nHcCZPL9ijE1Jf/bZZoPtzbavmqNZLbf9tSxq+yoduuJ+SZ+zXSZyBXCqU+d8fvC5yRUrV+0G2j3g2hDCLyXd/+Su3QdnvP/zCuH72LWsgf2k0oHlH2c2odlkxcpVEdgr6aDtjyb8x20/J+mA7T9I6rL9SWA5dne2/GdXLl58qNJh398An85yTMA+4DOz8Dgu6Zu2dwJXJ91ltm8Gbp7Fgb+EEB4aHhpq5CEtACqVyr3AC0AlPS8k3TSmQ2YPhhBuS/1/LpmS9JTtNTHGfwBU2uUALARotVqniqJYH2Pck85pfavVaufAwnQvnHc0McaDKVptebN94QAnJB0EdtjekydyZXqjs/0ZgLIs/w6sy8bnYGYJ63pgERKC05JutT1kOwITwL9tvzlzUQUYB+Zjs2DBgu6xsbGJZHstByZbezregcBXeCsEz1bnzXt5anLyzLq71zDLxTRdVgemdx0fv2e2w5thO5DbiqL4oKT3ZKpnpyYnz+SY2ZpTAPZmJfdIrVZbNBNUq9UW2X4kU+2dcf53Aj1pj2PA7y/6m1DS00A9za9uNBq7iqJYBuoGdRdFsazRaOzKSqye1rTbaa/tlbYrqXQP2X4FIA9/J1l39xrC0v7+w5IeB8XkwS1lWe6TGJAYKMty31tfO4qSHl/a3384I3CDpI+kzC4lnRfrue6GytEjR8oQwlY73gC0L4qlth/q0M1/LYWtR48cKQF6enrC6dOnVwGLEpnxnp7en4+O1i/tszzGOCTpPmB7ahb57QUwBWyXdF+McWg6MScmuoA8OX8xOlpvXGz422XYTsB/SnpA0h7bX5R0WzI9HUL4qe2XbI+dk3xl+V7gxoztD5jRI+YK/zkEEokx2/uB/RdzIfUtueqVN04cXwF8G3iHY3z9Urw/j8ClyhsnjrcS2Vv/J/8NLxT+/zqBTkcxU/cfEkyEAu3kmjAAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-box-edit{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEg4QfHjM1QAAAGRJREFUWMNjXLhsJcNAAiaGAQYsDAwM/+lsJ+OgCwGsLqMB+D8o08CoA0YdMOqAUQewDFQdMBoFIyoN/B/U7YFRB7DQIc7xyo9GwbBMA4xDqhxgISH1klXbDYk0QOseEeOgDgEAIS0JQleje6IAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-freehand-draw{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAADTElEQVRYCeWWTWwMYRjH/88721X1lZJIGxJxcEE4OOiBgzjXWh8TJKR76kWacOBGxdEJIdk4VChZI/phidRBHMRRIr7DSUiaSCRFRM3u88gz+o7Z6bBTdjmYZPf9eJ55fv/5zzvvDPC/H9QsA66Olo9Ga+/MdR+Ljm2/KQIULsz9FqItGdOfJKLhApLgVkiSCGODjWit7QpKWy+TNrFeXvzKVUT8NiTVaIgDcbiCFJ7GiT8WkARXAdYBK0Lbhi/CenArRNskuM7/tgNp4ArQ42dwjf3WY5gWTqC7O/NbNn2Xkfw/YwdSw/We14HP2IEZwX+y9cZ9SH0LmgFP7UCz4KkENBNeV0Cz4b8U8DfgKiDxMWwUXETqLvJpCQpXZfawbzS7t9v5pL19cHBwfja7YA0y/lyCM0+E5hv5+piZXwKYcF23as+37bTXsQVqgkL0p/34fHR7DcBtbetFsBmGDwMOJCggYG55yw7dMlk6DuC1Bdu2RsCU9TYWQq2IoGbsreZ5NzvEqfSBsIsIy8OTbcdgiRHeh4o8AFAEwDakbY2AaCCpH7V9aGhoUUUy3UyVbkPYFuYLDlUZH8XBpwxkK0Dbgxg5HcVi0ent7a0RULMIozaHBSMfF9b2SzdutFcFB2FkwMIJOG6qfteXOa1nHZ48tyefuwyfT9s6wtzZ3t7eZse2DR2I228TtHXzuWCx9g8MtK5cuHCZTH4tiHEOa4xFngvTyS8f35d6enomiCi4/foEXBkZaQuukChL4FYA2Whd7YcC4gEdW3CpdL3LtGAVCVYJywEyTpAuJKeMOKXZs/Bw947C50KhUFOG4cwz35cjWNBlHGeD53n3xsfHP/T19U1qciggar8Fa4I3PHobIotBWBtc2hSiChyZxVzM53Pv7FVH6Tp3uVy+g0r1ImD2GjIrQGYIxjnfuXTZGICS5k/bBwJoubwEFX4TLah9EXomJGMA3za+f9913Yl4TnzsDQ+vE6YTZOjHh4ngibstt1pzQwd04F0bPStEBpXqRoBeQ/AKghfBnOEKgS+Q7z91Xfdz/HGKg8Ox7z8iYD9z6wqTkZFgnvhMGP9VZ2or1XVkPM9z0mytSfVsHa1RLBZbLoyNzUnK+ydz3wC6I9x+lwbngwAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-poly-draw{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEjglo9eZgwAAAc5JREFUWMPt1zFrU1EUB/DfS4OmVTGDIChCP4BgnQXRxVHqIJUupp9AB8VBQcRBQUXIB9DWQoMRiXZzcnQSA34A7aAuHSJKkgo2LvfBrU3aJnlYkBy4vHcP557zP/9z3r33JdXa647N0kHSZd5Nn0rSxc8G3cXp85sMcnZZ8vge3osZ+l3vB8CWFA0iL14t79h210swAjACMAIwAjACkB90D/8/GchI9ve4nPwTBh5E9ws7OepzGWb9EddSn51Op9ZstadSg4VK1UKlKkmSDSMLALewiuNh/hVJq71Wxttmqz0dG88vPc+MgWP4grvYG3SLOBrZFFFrttqPe4HIDxh4GSei+98iSlusuYopXEAjBtEPA3tQwUpwluAbDm4TPJUz+BTW9l2Ce6G7L0X/Bw8D3T/7SKKIDzHg7QCcxjvcQAEtXAnrrg/RP0/DKPbqgcN4iVOR7gcO4dcQgRuoh7HSqwlP4n20m63jJu5n8MkWMYfP3UowhzdR8FU8w9iQwevBdyq3/27CMRzAE5yLuvsRLg+ZcR1nJ8YL81HWJUzGAPaFZwe/Q5MdyYDyNHgjzO90YyGHtVDncuiJchaHw8R4oREFV5qdiVmYLM3OgD9k5209/atmIAAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-point-draw{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEMEiERGWPELgAAA4RJREFUWMO1lr1uG1cQhb9ztdRSP7AF1QxgwKlcuZSqRC9gWUUUINWqTh5AnaFOnVPEteQmRuhCURqWsSqqc9IolREXdEvQBElxtdw7KURSFEVKu4w8wAKLxdw9Z+bMnRmZGXfZ29//II8th4WwGVNyIoQLYB5vxA9Caq04iUd9A+7ZlsNC2I7TdSd2hZXMJKlnTqp9jtl/GBaqoyQ0noFKpUIzBicYYc+DEFpxkglc4oVJa5gvDn8v1xV2irG3FM4NSVwjUKlUaMcpJhCGmSEJQ6QGD8M5WnHCd8+f3QCXpPLx8WNwv0j6Bm9FMK7FJ3WBE+R/2t7c/GBmFvSBrzRTCsyTDjXrxUgEMtpxynJYmJoBJ4VAybwVARgvL7Oik0okCodnKpVKX7P0leiVMb0VvbJT+upznK4vh0GIeQwwQStJkHQD3MwsCALTJRG7Qrdrj5m/djgYaIa0hlkRdJk26XEgC9txurccBtVW3IudBImmZuACUP+ZlIDBt9FKcubYNTcAH/X0RYM1E7utJPlqe+uZzPxUcEkiSS4sTT95n15Mud0xWC0o2PAWOCdK3KYZlFxfM+tHOcnMzNr1es18ug+cgsVjP4yBU/Ppfrter1m/+l0+zYygML1xRVHU7TSb1cSzBzoBzszsH+AMdJJ49jrNZjWKou6wBnwOzcyndBpNbuueURR1Dw8Pq35p9cc5p/Dy9Dypt7jXrtdGwQECS9NPhr6Gq6txUzNigE6zydLK6lTw12/KT4FGFEUfJX2YJNONq5tVs4ODA7sD/DnwJ/BoADZuE3tHFs12dna6d4C/BI6AlbyzI8ii2TTw12/KK33gb2cdXsNZoAntbZC2SeO4c9592k/5eNQbiwvFd1kJuFGwLJr1wSPg/SwpvyFBHufOeXcFeAlE97U/uCxOY+P3b+Bn4B3Q+L8EdJfD4a+/AbC4UBzPxiPg3wlHZquB28Cn2IuR9x3gr3uV4DbwfvSDOvi4uFA8BDZmIRHkjHpS9Ht9iRqd8+5G3g05mAGcQbsdiX5QJ428G7Kygo8XYdb1/K4NWVmjzkNge2sz84bs+ELmpDDLtqWsNZBXgvmw8CTtpWVMT7x5YWBjLARnwZfKQNYN2U2LPvrh+5nBt7c2M2/It9bArCTKR8eZN+SJ13AScPnoODeRdqNenH+wul5w2gUr2WUjMFAt8bZ/0axX/wNnv4H8vTFb1QAAAABJRU5ErkJggg==");}.bk-root .bk-tool-icon-poly-edit{background-image:url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gELFi46qJmxxAAABV9JREFUWMOdl19vFFUYxn9n9u9sCyylUIzWUoMQBAWCMdEEIt6xIRQSLIEKtvHe6AcA4yeQb7CAUNJy0daLeomJN8SEULAC2kBBapBKoLvbmdl/c14vdmY7u91tF95kknPOnHmf95znPc97Ro2OTeBbdjFDT3c32ZxVHUOE9kSMB0/m6ExuoJn1H+ur6Y+OTfD50SMN5168OgrAlyf7CfuD+z7+iDs3p8hkLUQ0iFQ/yFl5Nm/qonfHVva+s32Zw9GxCYILsZ08tpNfBhbs+1YN4OH9+7huGdECSBVfqUosbsllfmauBqiR+cCNwOr7AEo8pPHJnymXykhg5fUWjoQpl0vVvhZhbSzGoUOHqgBlt6B6uruj2Zy1E9jo0fhfeyL2x4Mnc8VErK0KUEOB64JSyptfG4RSytsJjUJVxw2lsFy3urL9nx1Qd25ObctkrVMi+jQivd7U2ZyV/3Hzpq7h3h1b/7p9Y0o8v8rwAbTWrGpSocN/FGDlbAI0Rl23PCBan0Ok158H9Ipwzi25A/Mzc9Gl/BYx/E4kYqC1NKRARNAaDCNUM27Z+Zr+ouXs0q4+LSLBHPYCFkTkC6uU39kwCdsS7WRKmaYUiAhdnZ3MPX2K4+QjQI+C94A93rMzm8ltMwyDeDzWjMZeEb2pYQDdW3vITU2jtUZ5QThOPgm8C7wP7J15OPsBsB3oWpGnVWisCeDS1VHj4vBI92+/3tgB7Ab2AruAXiDBK5oIOkhtkEYRNRuJhObrd8Dl9ewf4D5wG7hVLpen29vb5wzD+BrkbBMaL3d1dk5nsrnlFDTTFWAWmAZueWD3gCemGde2k2fw1Al1YXhEvjozoO49eczdqekrWmsc2zlrmvEKOGoW1GUjFLqSk2KpJrCLwyMCPAP+BO54QL8DM6YZX/ClsP9YnwKkXnIBP4jdIpJRpdJTCYdMwwi98KU0Hjc/dDILNyUcwTCWdOSMJ0TRmBktGRhLugu0xyLk7CIqVNm+0bGJptl1YXikD0grpY4Rjc4a8Fbgdab/6OGbAJeCUuyJnnHmZH9pbSyGuBXV8NUwlUpR1EWyixmSyTWEwqGlJ2Swbo2JXbAAfgDGgGQA9I1A9t1tlq0AxrXxn0ilUpw4fhQqYkH/sT41OTnJJwf2s6FjI5mshdYa7bqVR2uezr9MJmJt14FvGrh/O9D+e6UkM/xyCuCqEKCYnJyUTKFQrZDHjxzGshwWLQcRsOz8Hi85P23id0ug/XilAMLBmm4tPGdoaKjSH5+oAGrhwvBI9SjZTn4QSK9yenoD7dlrExPoJlXW8G8ytpNHxRKk02lGxsdRKFwXLNvx5yY94HQLGhGk4LFCYQSqaE0AwWM1eOoEbR0dKBSW7bC4mKuffxs4D/wCLKwQQPAUzIkslfp6cVomROWSolh0GjldAM4nzDi2k9/i5UAzC9aKfwNJ3zgJg9YEvN6+C7SHgKm69+sD7RfNnKTTaZRPQfAut4oFV//IS7gkcB34VlVo8kGzphlfB+DU+TfNGBpZtRastvrvARJmfMF28ge9sc2B9/PNnCilMIDwK6y8/ow/Ai4kvILTljAXvDvEvrqKSUs60KolzPjBxspavQD2tKqCAGF/Ba+xE/Wbilu54wZV8NEKF5fXzQHl/bh4hUsE0WAXSlDMYcQSrQXgCmsTseXHsJkNnjqBFGwKJaHsKlxtUHYVhbLCzr1kaOA4bcn1y1Swmb+iLpJKpVrfgdpfsiVVCYcgluwgnU7jEgJ4s5UkLFtWYyHyEg0/N1q1tmQH+YXnAMFr97Nmv3p+0QsHQRsF8qpBOE5+rb9Nkaj50tVQKjqh4OU3GNL/1/So3vuUgbAAAAAASUVORK5CYII=");}.bk-root .bk-tool-icon-line-edit{background-image:url("data:image/png;base64,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");}'},
function _(o,t,e,r,b){r(),e.root="bk-root",e.menu_icon="bk-menu-icon",e.context_menu="bk-context-menu",e.horizontal="bk-horizontal",e.vertical="bk-vertical",e.divider="bk-divider",e.active="bk-active",e.menu="bk-menu",e.above="bk-above",e.below="bk-below",e.caret="bk-caret",e.down="bk-down",e.up="bk-up",e.left="bk-left",e.right="bk-right",e.default=".bk-root .bk-menu-icon{width:28px;height:28px;background-size:60%;background-color:transparent;background-repeat:no-repeat;background-position:center center;}.bk-root .bk-context-menu{position:absolute;display:inline-flex;flex-wrap:nowrap;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;width:auto;height:auto;z-index:100;cursor:pointer;font-size:12px;background-color:#fff;border:1px solid #ccc;border-radius:4px;box-shadow:0 6px 12px rgba(0, 0, 0, 0.175);}.bk-root .bk-context-menu.bk-horizontal{flex-direction:row;}.bk-root .bk-context-menu.bk-vertical{flex-direction:column;}.bk-root .bk-context-menu > .bk-divider{cursor:default;overflow:hidden;background-color:#e5e5e5;}.bk-root .bk-context-menu.bk-horizontal > .bk-divider{width:1px;margin:5px 0;}.bk-root .bk-context-menu.bk-vertical > .bk-divider{height:1px;margin:0 5px;}.bk-root .bk-context-menu > :not(.bk-divider){border:1px solid transparent;}.bk-root .bk-context-menu > :not(.bk-divider).bk-active{border-color:#26aae1;}.bk-root .bk-context-menu > :not(.bk-divider):hover{background-color:#f9f9f9;}.bk-root .bk-context-menu > :not(.bk-divider):focus,.bk-root .bk-context-menu > :not(.bk-divider):focus-visible{outline:1px dotted #26aae1;outline-offset:-1px;}.bk-root .bk-context-menu > :not(.bk-divider)::-moz-focus-inner{border:0;}.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):first-child{border-top-left-radius:4px;border-bottom-left-radius:4px;}.bk-root .bk-context-menu.bk-horizontal > :not(.bk-divider):last-child{border-top-right-radius:4px;border-bottom-right-radius:4px;}.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):first-child{border-top-left-radius:4px;border-top-right-radius:4px;}.bk-root .bk-context-menu.bk-vertical > :not(.bk-divider):last-child{border-bottom-left-radius:4px;border-bottom-right-radius:4px;}.bk-root .bk-menu{position:absolute;left:0;width:100%;z-index:100;cursor:pointer;font-size:12px;background-color:#fff;border:1px solid #ccc;border-radius:4px;box-shadow:0 6px 12px rgba(0, 0, 0, 0.175);}.bk-root .bk-menu.bk-above{bottom:100%;}.bk-root .bk-menu.bk-below{top:100%;}.bk-root .bk-menu > .bk-divider{height:1px;margin:7.5px 0;overflow:hidden;background-color:#e5e5e5;}.bk-root .bk-menu > :not(.bk-divider){padding:6px 12px;}.bk-root .bk-menu > :not(.bk-divider):hover,.bk-root .bk-menu > :not(.bk-divider).bk-active{background-color:#e6e6e6;}.bk-root .bk-caret{display:inline-block;vertical-align:middle;width:0;height:0;margin:0 5px;}.bk-root .bk-caret.bk-down{border-top:4px solid;}.bk-root .bk-caret.bk-up{border-bottom:4px solid;}.bk-root .bk-caret.bk-down,.bk-root .bk-caret.bk-up{border-right:4px solid transparent;border-left:4px solid transparent;}.bk-root .bk-caret.bk-left{border-right:4px solid;}.bk-root .bk-caret.bk-right{border-left:4px solid;}.bk-root .bk-caret.bk-left,.bk-root .bk-caret.bk-right{border-top:4px solid transparent;border-bottom:4px solid transparent;}"},
function _(t,e,n,i,o){i();var l=t(1),r=t(158),s=t(126),u=(0,l.__importStar)(t(344)),d=function(){function t(t,e){var n,i,o=this;void 0===e&&(e={}),this.items=t,this.el=(0,r.div)(),this._open=!1,this._item_click=function(t){var e;null===(e=t.handler)||void 0===e||e.call(t),o.hide()},this._on_mousedown=function(t){var e,n=t.target;n instanceof Node&&o.el.contains(n)||(null===(e=o.prevent_hide)||void 0===e?void 0:e.call(o,t))||o.hide()},this._on_keydown=function(t){t.keyCode==r.Keys.Esc&&o.hide()},this._on_blur=function(){o.hide()},this.orientation=null!==(n=e.orientation)&&void 0!==n?n:"vertical",this.reversed=null!==(i=e.reversed)&&void 0!==i&&i,this.prevent_hide=e.prevent_hide,(0,r.undisplay)(this.el)}return Object.defineProperty(t.prototype,"is_open",{get:function(){return this._open},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"can_open",{get:function(){return 0!=this.items.length},enumerable:!1,configurable:!0}),t.prototype.remove=function(){(0,r.remove)(this.el),this._unlisten()},t.prototype._listen=function(){document.addEventListener("mousedown",this._on_mousedown),document.addEventListener("keydown",this._on_keydown),window.addEventListener("blur",this._on_blur)},t.prototype._unlisten=function(){document.removeEventListener("mousedown",this._on_mousedown),document.removeEventListener("keydown",this._on_keydown),window.removeEventListener("blur",this._on_blur)},t.prototype._position=function(t){var e=this.el.parentElement;if(null!=e){var n=function(){if("left_of"in t){var e=t.left_of.getBoundingClientRect();return{right:e.left,top:i=e.top}}if("right_of"in t){var n=t.right_of.getBoundingClientRect(),i=n.top;return{left:n.right,top:i}}if("below"in t){var o=t.below.getBoundingClientRect();return{left:o.left,top:o.bottom}}if("above"in t){var l=t.above.getBoundingClientRect();return{left:l.left,bottom:i=l.top}}return t}(),i=e.getBoundingClientRect();this.el.style.left=null!=n.left?n.left-i.left+"px":"",this.el.style.top=null!=n.top?n.top-i.top+"px":"",this.el.style.right=null!=n.right?i.right-n.right+"px":"",this.el.style.bottom=null!=n.bottom?i.bottom-n.bottom+"px":""}},t.prototype.render=function(){var t,e,n,i=this;(0,r.empty)(this.el,!0),(0,r.classes)(this.el).add("bk-context-menu","bk-"+this.orientation);var o=this.reversed?(0,s.reversed)(this.items):this.items,d=function(t){var e=void 0;if(null==t)e=(0,r.div)({class:u.divider});else{if(null!=t.if&&!t.if())return"continue";if(null!=t.content)e=t.content;else{var o=null!=t.icon?(0,r.div)({class:["bk-menu-icon",t.icon]}):null,l=[(null===(n=t.active)||void 0===n?void 0:n.call(t))?"bk-active":null,t.class];(e=(0,r.div)({class:l,title:t.tooltip,tabIndex:0},o,t.label,t.content)).addEventListener("click",(function(){i._item_click(t)})),e.addEventListener("keydown",(function(e){e.keyCode==r.Keys.Enter&&i._item_click(t)}))}}h.el.appendChild(e)},h=this;try{for(var c=(0,l.__values)(o),a=c.next();!a.done;a=c.next()){d(a.value)}}catch(e){t={error:e}}finally{try{a&&!a.done&&(e=c.return)&&e.call(c)}finally{if(t)throw t.error}}},t.prototype.show=function(t){if(0!=this.items.length&&!this._open){if(this.render(),0==this.el.children.length)return;this._position(null!=t?t:{left:0,top:0}),(0,r.display)(this.el),this._listen(),this._open=!0}},t.prototype.hide=function(){this._open&&(this._open=!1,this._unlisten(),(0,r.undisplay)(this.el))},t.prototype.toggle=function(t){this._open?this.hide():this.show(t)},t}();n.ContextMenu=d,d.__name__="ContextMenu"},
function _(t,e,n,o,i){o();var r=t(1),c=t(339),l=(0,r.__importStar)(t(342)),u=t(158),a=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,r.__extends)(e,t),e.prototype.render=function(){t.prototype.render.call(this),(0,u.classes)(this.el).toggle(l.active,this.model.active)},e.prototype._clicked=function(){var t=this.model.active;this.model.active=!t},e}(c.ButtonToolButtonView);n.OnOffButtonView=a,a.__name__="OnOffButtonView"},
function _(t,n,e,o,i){o();var r,u=t(1),_=t(339),l=t(346),c=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,u.__extends)(n,t),n}(_.ButtonToolView);e.InspectToolView=c,c.__name__="InspectToolView";var a=function(t){function n(n){var e=t.call(this,n)||this;return e.event_type="move",e}return(0,u.__extends)(n,t),n}(_.ButtonTool);e.InspectTool=a,r=a,a.__name__="InspectTool",r.prototype.button_view=l.OnOffButtonView,r.define((function(t){return{toggleable:[t.Boolean,!0]}})),r.override({active:!0})},
function _(t,e,o,i,n){i();var r,l,a=t(1),s=t(134),u=t(158),c=t(228),_=t(341),h=t(135),v=t(126),p=t(349),f=t(128),d=t(125),y=t(350),b=t(180),g=t(168),m=t(337),w=t(338),x=t(353),T=t(354),z=t(347),B=t(345),C=(0,a.__importStar)(t(342)),k=C,A=(0,a.__importStar)(t(355)),L=A,M=function(t){function e(e){return t.call(this,e)||this}return(0,a.__extends)(e,t),Object.defineProperty(e.prototype,"visible",{get:function(){var t;return!this.autohide||null!==(t=this._visible)&&void 0!==t&&t},enumerable:!1,configurable:!0}),e}(g.Model);o.ToolbarViewModel=M,r=M,M.__name__="ToolbarViewModel",r.define((function(t){return{autohide:[t.Boolean,!1]}})),r.internal((function(t){var e=t.Boolean;return{_visible:[(0,t.Nullable)(e),null]}}));var S=function(t){function e(){var e=t.apply(this,(0,a.__spreadArray)([],(0,a.__read)(arguments),!1))||this;return e.layout={bbox:new b.BBox},e}return(0,a.__extends)(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._tool_button_views=new Map,this._toolbar_view_model=new M({autohide:this.model.autohide});var e=this.model.toolbar_location,o="left"==e||"above"==e,i=this.model.horizontal?"vertical":"horizontal";this._overflow_menu=new B.ContextMenu([],{orientation:i,reversed:o})},e.prototype.lazy_initialize=function(){return(0,a.__awaiter)(this,void 0,void 0,(function(){return(0,a.__generator)(this,(function(e){switch(e.label){case 0:return[4,t.prototype.lazy_initialize.call(this)];case 1:return e.sent(),[4,this._build_tool_button_views()];case 2:return e.sent(),[2]}}))}))},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.tools.change,(function(){return(0,a.__awaiter)(e,void 0,void 0,(function(){return(0,a.__generator)(this,(function(t){switch(t.label){case 0:return[4,this._build_tool_button_views()];case 1:return t.sent(),this.render(),[2]}}))}))})),this.connect(this.model.properties.autohide.change,(function(){e._toolbar_view_model.autohide=e.model.autohide,e._on_visible_change()})),this.connect(this._toolbar_view_model.properties._visible.change,(function(){return e._on_visible_change()}))},e.prototype.styles=function(){return(0,a.__spreadArray)((0,a.__spreadArray)([],(0,a.__read)(t.prototype.styles.call(this)),!1),[C.default,A.default],!1)},e.prototype.remove=function(){(0,c.remove_views)(this._tool_button_views),t.prototype.remove.call(this)},e.prototype._build_tool_button_views=function(){return(0,a.__awaiter)(this,void 0,void 0,(function(){var t;return(0,a.__generator)(this,(function(e){switch(e.label){case 0:return t=null!=this.model._proxied_tools?this.model._proxied_tools:this.model.tools,[4,(0,c.build_views)(this._tool_button_views,t,{parent:this},(function(t){return t.button_view}))];case 1:return e.sent(),[2]}}))}))},e.prototype.set_visibility=function(t){t!=this._toolbar_view_model._visible&&(this._toolbar_view_model._visible=t)},e.prototype._on_visible_change=function(){var t=this._toolbar_view_model.visible;(0,u.classes)(this.el).toggle(k.toolbar_hidden,!t)},e.prototype.render=function(){var t,e,o,i,n,r,l=this;(0,u.empty)(this.el),this.el.classList.add(k.toolbar),this.el.classList.add(k[this.model.toolbar_location]),this._toolbar_view_model.autohide=this.model.autohide,this._on_visible_change();var s=this.model.horizontal,c=0;if(null!=this.model.logo){var _="grey"===this.model.logo?L.grey:null,h=(0,u.a)({href:"https://bokeh.org/",target:"_blank",class:[L.logo,L.logo_small,_]});this.el.appendChild(h);var v=h.getBoundingClientRect(),d=v.width,y=v.height;c+=s?d:y}try{for(var b=(0,a.__values)(this._tool_button_views),g=b.next();!g.done;g=b.next()){(0,a.__read)(g.value,2)[1].render()}}catch(e){t={error:e}}finally{try{g&&!g.done&&(e=b.return)&&e.call(b)}finally{if(t)throw t.error}}var m=[],w=function(t){return l._tool_button_views.get(t).el},x=this.model.gestures;try{for(var T=(0,a.__values)((0,f.values)(x)),z=T.next();!z.done;z=T.next()){var B=z.value;m.push(B.tools.map(w))}}catch(t){o={error:t}}finally{try{z&&!z.done&&(i=T.return)&&i.call(T)}finally{if(o)throw o.error}}m.push(this.model.actions.map(w)),m.push(this.model.inspectors.filter((function(t){return t.toggleable})).map(w));var C=m.filter((function(t){return 0!=t.length})),A=this.layout.bbox,M=!1;this.root.el.appendChild(this._overflow_menu.el);var S=(0,u.div)({class:k.tool_overflow,tabIndex:0},s?"\u22ee":"\u22ef"),j=function(){var t=function(){switch(l.model.toolbar_location){case"right":return{left_of:S};case"left":return{right_of:S};case"above":return{below:S};case"below":return{above:S}}}();l._overflow_menu.toggle(t)};S.addEventListener("click",(function(){j()})),S.addEventListener("keydown",(function(t){t.keyCode==u.Keys.Enter&&j()}));try{for(var O=(0,a.__values)((0,p.join)(C,(function(){return(0,u.div)({class:k.divider})}))),V=O.next();!V.done;V=O.next()){var R=V.value;if(M)this._overflow_menu.items.push({content:R,class:s?k.right:k.above});else{this.el.appendChild(R);var E=R.getBoundingClientRect();d=E.width,y=E.height;if(c+=s?d:y,M=s?c>A.width-15:c>A.height-15){this.el.removeChild(R),this.el.appendChild(S);var I=this._overflow_menu.items;I.splice(0,I.length),I.push({content:R})}}}}catch(t){n={error:t}}finally{try{V&&!V.done&&(r=O.return)&&r.call(O)}finally{if(n)throw n.error}}},e.prototype.update_layout=function(){},e.prototype.update_position=function(){},e.prototype.after_layout=function(){this._has_finished=!0},e.prototype.export=function(t,e){void 0===e&&(e=!0);var o="png"==t?"canvas":"svg",i=new y.CanvasLayer(o,e);return i.resize(0,0),i},e}(_.DOMView);function j(){return{pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}}}o.ToolbarBaseView=S,S.__name__="ToolbarBaseView";var O=function(t){function e(e){return t.call(this,e)||this}return(0,a.__extends)(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this._init_tools()},e.prototype._init_tools=function(){var t,e,o,i,n,r,l=this,u=function(t,e){if(t.length!=e.length)return!0;var o=new Set(e.map((function(t){return t.id})));return(0,v.some)(t,(function(t){return!o.has(t.id)}))},c=this.tools.filter((function(t){return t instanceof z.InspectTool}));u(this.inspectors,c)&&(this.inspectors=c);var _=this.tools.filter((function(t){return t instanceof T.HelpTool}));u(this.help,_)&&(this.help=_);var h=this.tools.filter((function(t){return t instanceof x.ActionTool}));u(this.actions,h)&&(this.actions=h);var p=function(t,e){t in l.gestures||s.logger.warn("Toolbar: unknown event type '"+t+"' for tool: "+e)},f={pan:{tools:[],active:null},scroll:{tools:[],active:null},pinch:{tools:[],active:null},tap:{tools:[],active:null},doubletap:{tools:[],active:null},press:{tools:[],active:null},pressup:{tools:[],active:null},rotate:{tools:[],active:null},move:{tools:[],active:null},multi:{tools:[],active:null}};try{for(var y=(0,a.__values)(this.tools),b=y.next();!b.done;b=y.next()){var g=b.value;if(g instanceof w.GestureTool&&g.event_type)if((0,d.isString)(g.event_type))f[g.event_type].tools.push(g),p(g.event_type,g);else{f.multi.tools.push(g);try{for(var m=(o=void 0,(0,a.__values)(g.event_type)),B=m.next();!B.done;B=m.next()){p(B.value,g)}}catch(t){o={error:t}}finally{try{B&&!B.done&&(i=m.return)&&i.call(m)}finally{if(o)throw o.error}}}}}catch(e){t={error:e}}finally{try{b&&!b.done&&(e=y.return)&&e.call(y)}finally{if(t)throw t.error}}var C=function(t){var e=k.gestures[t];u(e.tools,f[t].tools)&&(e.tools=f[t].tools),e.active&&(0,v.every)(e.tools,(function(t){return t.id!=e.active.id}))&&(e.active=null)},k=this;try{for(var A=(0,a.__values)(Object.keys(f)),L=A.next();!L.done;L=A.next()){C(L.value)}}catch(t){n={error:t}}finally{try{L&&!L.done&&(r=A.return)&&r.call(A)}finally{if(n)throw n.error}}},Object.defineProperty(e.prototype,"horizontal",{get:function(){return"above"===this.toolbar_location||"below"===this.toolbar_location},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"vertical",{get:function(){return"left"===this.toolbar_location||"right"===this.toolbar_location},enumerable:!1,configurable:!0}),e.prototype._active_change=function(t){var e,o,i=t.event_type;if(null!=i){var n=(0,d.isString)(i)?[i]:i;try{for(var r=(0,a.__values)(n),l=r.next();!l.done;l=r.next()){var u=l.value;if(t.active){var c=this.gestures[u].active;null!=c&&t!=c&&(s.logger.debug("Toolbar: deactivating tool: "+c+" for event type '"+u+"'"),c.active=!1),this.gestures[u].active=t,s.logger.debug("Toolbar: activating tool: "+t+" for event type '"+u+"'")}else this.gestures[u].active=null}}catch(t){e={error:t}}finally{try{l&&!l.done&&(o=r.return)&&o.call(r)}finally{if(e)throw e.error}}}},e}(g.Model);o.ToolbarBase=O,l=O,O.__name__="ToolbarBase",l.prototype.default_view=S,l.define((function(t){var e=t.Boolean,o=t.Array,i=t.Ref,n=t.Nullable;return{tools:[o(i(m.Tool)),[]],logo:[n(h.Logo),"normal"],autohide:[e,!1]}})),l.internal((function(t){var e=t.Array,o=t.Struct,i=t.Ref,n=t.Nullable,r=o({tools:e(i(w.GestureTool)),active:n(i(m.Tool))});return{gestures:[o({pan:r,scroll:r,pinch:r,tap:r,doubletap:r,press:r,pressup:r,rotate:r,move:r,multi:r}),j],actions:[e(i(x.ActionTool)),[]],inspectors:[e(i(z.InspectTool)),[]],help:[e(i(T.HelpTool)),[]],toolbar_location:[h.Location,"right"]}}))},
function _(e,r,n,t,a){t();var l=e(1),s=e(126);function u(e,r){var n,t,a,u,c,o,i,f,_,v,h,b,y;return(0,l.__generator)(this,(function(d){switch(d.label){case 0:return n=e.length,r>n?[2]:[4,(t=(0,s.range)(r)).map((function(r){return e[r]}))];case 1:d.sent(),d.label=2;case 2:0,a=void 0;try{for(v=void 0,u=(0,l.__values)((0,s.reversed)((0,s.range)(r))),c=u.next();!c.done;c=u.next())if(o=c.value,t[o]!=o+n-r){a=o;break}}catch(e){v={error:e}}finally{try{c&&!c.done&&(h=u.return)&&h.call(u)}finally{if(v)throw v.error}}if(null==a)return[2];t[a]+=1;try{for(b=void 0,i=(0,l.__values)((0,s.range)(a+1,r)),f=i.next();!f.done;f=i.next())_=f.value,t[_]=t[_-1]+1}catch(e){b={error:e}}finally{try{f&&!f.done&&(y=i.return)&&y.call(i)}finally{if(b)throw b.error}}return[4,t.map((function(r){return e[r]}))];case 3:return d.sent(),[3,2];case 4:return[2]}}))}n.enumerate=function(e){var r,n,t,a,s,u;return(0,l.__generator)(this,(function(c){switch(c.label){case 0:r=0,c.label=1;case 1:c.trys.push([1,6,7,8]),n=(0,l.__values)(e),t=n.next(),c.label=2;case 2:return t.done?[3,5]:[4,[t.value,r++]];case 3:c.sent(),c.label=4;case 4:return t=n.next(),[3,2];case 5:return[3,8];case 6:return a=c.sent(),s={error:a},[3,8];case 7:try{t&&!t.done&&(u=n.return)&&u.call(n)}finally{if(s)throw s.error}return[7];case 8:return[2]}}))},n.join=function(e,r){var n,t,a,s,u,c,o;return(0,l.__generator)(this,(function(i){switch(i.label){case 0:n=!0,i.label=1;case 1:i.trys.push([1,9,10,11]),t=(0,l.__values)(e),a=t.next(),i.label=2;case 2:return a.done?[3,8]:(s=a.value,n?(n=!1,[3,5]):[3,3]);case 3:return null==r?[3,5]:[4,r()];case 4:i.sent(),i.label=5;case 5:return[5,(0,l.__values)(s)];case 6:i.sent(),i.label=7;case 7:return a=t.next(),[3,2];case 8:return[3,11];case 9:return u=i.sent(),c={error:u},[3,11];case 10:try{a&&!a.done&&(o=t.return)&&o.call(t)}finally{if(c)throw c.error}return[7];case 11:return[2]}}))},n.combinations=u,n.subsets=function(e){var r,n,t,a,c,o;return(0,l.__generator)(this,(function(i){switch(i.label){case 0:i.trys.push([0,5,6,7]),r=(0,l.__values)((0,s.range)(e.length+1)),n=r.next(),i.label=1;case 1:return n.done?[3,4]:(t=n.value,[5,(0,l.__values)(u(e,t))]);case 2:i.sent(),i.label=3;case 3:return n=r.next(),[3,1];case 4:return[3,7];case 5:return a=i.sent(),c={error:a},[3,7];case 6:try{n&&!n.done&&(o=r.return)&&o.call(r)}finally{if(c)throw c.error}return[7];case 7:return[2]}}))}},
function _(t,e,n,i,o){i();var r=t(351),a=t(180),s=t(158);function c(t){!function(t){void 0===t.lineDash&&Object.defineProperty(t,"lineDash",{get:function(){return t.getLineDash()},set:function(e){return t.setLineDash(e)}})}(t),function(t){t.setImageSmoothingEnabled=function(e){t.imageSmoothingEnabled=e,t.mozImageSmoothingEnabled=e,t.oImageSmoothingEnabled=e,t.webkitImageSmoothingEnabled=e,t.msImageSmoothingEnabled=e},t.getImageSmoothingEnabled=function(){var e=t.imageSmoothingEnabled;return null==e||e}}(t),function(t){t.ellipse||(t.ellipse=function(e,n,i,o,r,a,s,c){void 0===c&&(c=!1);var l=.551784;t.translate(e,n),t.rotate(r);var h=i,u=o;c&&(h=-i,u=-o),t.moveTo(-h,0),t.bezierCurveTo(-h,u*l,-h*l,u,0,u),t.bezierCurveTo(h*l,u,h,u*l,h,0),t.bezierCurveTo(h,-u*l,h*l,-u,0,-u),t.bezierCurveTo(-h*l,-u,-h,-u*l,-h,0),t.rotate(-r),t.translate(-e,-n)})}(t)}var l={position:"absolute",top:"0",left:"0",width:"100%",height:"100%"},h=function(){function t(t,e){switch(this.backend=t,this.hidpi=e,this.pixel_ratio=1,this.bbox=new a.BBox,t){case"webgl":case"canvas":if(this._el=this._canvas=(0,s.canvas)({style:l}),null==(n=this.canvas.getContext("2d")))throw new Error("unable to obtain 2D rendering context");this._ctx=n,e&&(this.pixel_ratio=devicePixelRatio);break;case"svg":var n=new r.SVGRenderingContext2D;this._ctx=n,this._canvas=n.get_svg(),this._el=(0,s.div)({style:l},this._canvas)}this._ctx.layer=this,c(this._ctx)}return Object.defineProperty(t.prototype,"canvas",{get:function(){return this._canvas},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"ctx",{get:function(){return this._ctx},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"el",{get:function(){return this._el},enumerable:!1,configurable:!0}),t.prototype.resize=function(t,e){this.bbox=new a.BBox({left:0,top:0,width:t,height:e});var n=this._ctx instanceof r.SVGRenderingContext2D?this._ctx:this.canvas;n.width=t*this.pixel_ratio,n.height=e*this.pixel_ratio},t.prototype.undo_transform=function(t){var e=this.ctx;if(void 0===e.getTransform)t(e);else{var n=e.getTransform();e.setTransform(this._base_transform);try{t(e)}finally{e.setTransform(n)}}},t.prototype.prepare=function(){var t=this,e=t.ctx,n=t.hidpi,i=t.pixel_ratio;e.save(),n&&(e.scale(i,i),e.translate(.5,.5)),void 0!==e.getTransform&&(this._base_transform=e.getTransform()),this.clear()},t.prototype.clear=function(){var t=this.bbox,e=t.x,n=t.y,i=t.width,o=t.height;this.ctx.clearRect(e,n,i,o)},t.prototype.finish=function(){this.ctx.restore()},t.prototype.to_blob=function(){var t=this._canvas;if(t instanceof HTMLCanvasElement)return null!=t.msToBlob?Promise.resolve(t.msToBlob()):new Promise((function(e,n){t.toBlob((function(t){return null!=t?e(t):n()}),"image/png")}));var e=this._ctx.get_serialized_svg(!0),n=new Blob([e],{type:"image/svg+xml"});return Promise.resolve(n)},t}();n.CanvasLayer=h,h.__name__="CanvasLayer"},
function _(t,e,r,i,n){i();var a=t(1),o=t(237),s=t(125),l=t(352),h=t(117),_=t(158);function p(t){var e,r={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return null!==(e=r[t])&&void 0!==e?e:r.alphabetic}var u=function(t,e){var r=new Map,i=t.split(",");e=null!=e?e:10;for(var n=0;n<i.length;n+=2){var a="&"+i[n+1]+";",o=parseInt(i[n],e);r.set(a,"&#"+o+";")}return r.set("\\xa0","&#160;"),r}("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32),c={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"},lineDashOffset:{svgAttr:"stroke-dashoffset",canvas:0,svg:0,apply:"stroke"}},d=function(){function t(t,e){this.__root=t,this.__ctx=e}return t.prototype.addColorStop=function(t,e){if(!("linearGradient"===this.__root.nodeName&&this.__root.getAttribute("x1")===this.__root.getAttribute("x2")&&this.__root.getAttribute("y1")===this.__root.getAttribute("y2")||"radialGradient"===this.__root.nodeName&&this.__root.getAttribute("cx")===this.__root.getAttribute("fx")&&this.__root.getAttribute("cy")===this.__root.getAttribute("fy")&&this.__root.getAttribute("r")===this.__root.getAttribute("r0"))){var r=this.__ctx.__createElement("stop");if(r.setAttribute("offset",""+t),-1!==e.indexOf("rgba")){var i=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(e),n=(0,a.__read)(i,5),o=n[1],s=n[2],l=n[3],h=n[4];r.setAttribute("stop-color","rgb("+o+","+s+","+l+")"),r.setAttribute("stop-opacity",h)}else r.setAttribute("stop-color",e);this.__root.appendChild(r)}},t}();d.__name__="CanvasGradient";var f=function(){function t(t,e){this.__root=t,this.__ctx=e}return t.prototype.setTransform=function(t){throw new Error("not implemented")},t}();f.__name__="CanvasPattern";var m=function(){function t(t){var e,r,i;this.__currentPosition=null,this._transform=new o.AffineTransform,this._clip_path=null,this.__document=null!==(e=null==t?void 0:t.document)&&void 0!==e?e:document,(null==t?void 0:t.ctx)?this.__ctx=t.ctx:(this.__canvas=this.__document.createElement("canvas"),this.__ctx=this.__canvas.getContext("2d")),this.__setDefaultStyles(),this.__stack=[],this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg"),this.__root.setAttribute("version","1.1"),this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg"),this.width=null!==(r=null==t?void 0:t.width)&&void 0!==r?r:500,this.height=null!==(i=null==t?void 0:t.height)&&void 0!==i?i:500,this.__ids=new Set,this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs"),this.__root.appendChild(this.__defs)}return Object.defineProperty(t.prototype,"canvas",{get:function(){return this},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"width",{get:function(){return this._width},set:function(t){this._width=t,this.__root.setAttribute("width",""+t)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"height",{get:function(){return this._height},set:function(t){this._height=t,this.__root.setAttribute("height",""+t)},enumerable:!1,configurable:!0}),t.prototype._random_string=function(){var e;do{e=t.__random.choices(12,"ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz").join("")}while(this.__ids.has(e));return e},t.prototype.__createElement=function(t,e,r){var i,n;void 0===e&&(e={}),void 0===r&&(r=!1);var o=this.__document.createElementNS("http://www.w3.org/2000/svg",t);r&&(o.setAttribute("fill","none"),o.setAttribute("stroke","none"));var s=Object.keys(e);try{for(var l=(0,a.__values)(s),h=l.next();!h.done;h=l.next()){var _=h.value;o.setAttribute(_,""+e[_])}}catch(t){i={error:t}}finally{try{h&&!h.done&&(n=l.return)&&n.call(l)}finally{if(i)throw i.error}}return o},t.prototype.__setDefaultStyles=function(){for(var t=Object.keys(c),e=0;e<t.length;e++){var r=t[e];this[r]=c[r].canvas}},t.prototype.__applyStyleState=function(t){for(var e=Object.keys(t),r=0;r<e.length;r++){var i=e[r];this[i]=t[i]}},t.prototype.__getStyleState=function(){for(var t=Object.keys(c),e={},r=0;r<t.length;r++){var i=t[r];e[i]=this[i]}return e},t.prototype.__applyStyleToCurrentElement=function(t){for(var e,r,i,n=this.__currentElement,o=Object.keys(c),l=0;l<o.length;l++){var h=c[o[l]],_=this[o[l]];if(null===(i=h.apply)||void 0===i?void 0:i.includes(t))if(_ instanceof f){try{for(var p=(e=void 0,(0,a.__values)((0,a.__spreadArray)([],(0,a.__read)(_.__ctx.__defs.childNodes),!1))),u=p.next();!u.done;u=p.next()){var m=u.value;if(m instanceof Element){var g=m.getAttribute("id");this.__ids.add(g),this.__defs.appendChild(m)}}}catch(t){e={error:t}}finally{try{u&&!u.done&&(r=p.return)&&r.call(p)}finally{if(e)throw e.error}}var v=_.__root.getAttribute("id");n.setAttribute(h.apply,"url(#"+v+")")}else if(_ instanceof d){v=_.__root.getAttribute("id");n.setAttribute(h.apply,"url(#"+v+")")}else if(h.svg!==_)if("stroke"!==h.svgAttr&&"fill"!==h.svgAttr||!(0,s.isString)(_)||-1===_.indexOf("rgba")){var y=h.svgAttr;if("globalAlpha"===o[l]&&(y=t+"-"+h.svgAttr,n.getAttribute(y)))continue;n.setAttribute(y,""+_)}else{var b=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi.exec(_),A=(0,a.__read)(b,5),w=A[1],x=A[2],E=A[3],C=A[4];n.setAttribute(h.svgAttr,"rgb("+w+","+x+","+E+")");var P=parseFloat(C),k=this.globalAlpha;null!=k&&(P*=k),n.setAttribute(h.svgAttr+"-opacity",""+P)}}},t.prototype.get_serialized_svg=function(t){var e,r;void 0===t&&(t=!1);var i=(new XMLSerializer).serializeToString(this.__root);if(t)try{for(var n=(0,a.__values)(u),o=n.next();!o.done;o=n.next()){var s=(0,a.__read)(o.value,2),l=s[0],h=s[1],_=new RegExp(l,"gi");_.test(i)&&(i=i.replace(_,h))}}catch(t){e={error:t}}finally{try{o&&!o.done&&(r=n.return)&&r.call(n)}finally{if(e)throw e.error}}return i},t.prototype.get_svg=function(){return this.__root},t.prototype.save=function(){this.__stack.push({transform:this._transform,clip_path:this._clip_path,attributes:this.__getStyleState()}),this._transform=this._transform.clone()},t.prototype.restore=function(){if(0!=this.__stack.length){var t=this.__stack.pop(),e=t.transform,r=t.clip_path,i=t.attributes;this._transform=e,this._clip_path=r,this.__applyStyleState(i)}},t.prototype._apply_transform=function(t,e){void 0===e&&(e=this._transform),e.is_identity||t.setAttribute("transform",e.toString())},t.prototype.scale=function(t,e){isFinite(t)&&(null==e||isFinite(e))&&this._transform.scale(t,null!=e?e:t)},t.prototype.rotate=function(t){isFinite(t)&&this._transform.rotate(t)},t.prototype.translate=function(t,e){isFinite(t+e)&&this._transform.translate(t,e)},t.prototype.transform=function(t,e,r,i,n,a){isFinite(t+e+r+i+n+a)&&this._transform.transform(t,e,r,i,n,a)},t.prototype.beginPath=function(){this.__currentDefaultPath="",this.__currentPosition=null,this.__init_element()},t.prototype.__init_element=function(){var t=this.__createElement("path",{},!0);this.__root.appendChild(t),this.__currentElement=t},t.prototype.__applyCurrentDefaultPath=function(){var t=this.__currentElement;"path"===t.nodeName?t.setAttribute("d",this.__currentDefaultPath):console.error("Attempted to apply path command to node",t.nodeName)},t.prototype.__addPathCommand=function(t,e,r){var i=this.__currentDefaultPath?" ":"";this.__currentDefaultPath+=i+r,this.__currentPosition={x:t,y:e}},Object.defineProperty(t.prototype,"_hasCurrentDefaultPath",{get:function(){return!!this.__currentDefaultPath},enumerable:!1,configurable:!0}),t.prototype.moveTo=function(t,e){if(isFinite(t+e)){var r=this.__currentElement;r&&"path"===r.nodeName||this.beginPath();var i=(0,a.__read)(this._transform.apply(t,e),2),n=i[0],o=i[1];this.__addPathCommand(n,o,"M "+n+" "+o)}},t.prototype.closePath=function(){this._hasCurrentDefaultPath&&this.__addPathCommand(NaN,NaN,"Z")},t.prototype.lineTo=function(t,e){if(isFinite(t+e))if(this._hasCurrentDefaultPath){var r=(0,a.__read)(this._transform.apply(t,e),2),i=r[0],n=r[1];this.__addPathCommand(i,n,"L "+i+" "+n)}else this.moveTo(t,e)},t.prototype.bezierCurveTo=function(t,e,r,i,n,o){if(isFinite(t+e+r+i+n+o)){var s=(0,a.__read)(this._transform.apply(n,o),2),l=s[0],h=s[1],_=(0,a.__read)(this._transform.apply(t,e),2),p=_[0],u=_[1],c=(0,a.__read)(this._transform.apply(r,i),2),d=c[0],f=c[1];this.__addPathCommand(l,h,"C "+p+" "+u+" "+d+" "+f+" "+l+" "+h)}},t.prototype.quadraticCurveTo=function(t,e,r,i){if(isFinite(t+e+r+i)){var n=(0,a.__read)(this._transform.apply(r,i),2),o=n[0],s=n[1],l=(0,a.__read)(this._transform.apply(t,e),2),h=l[0],_=l[1];this.__addPathCommand(o,s,"Q "+h+" "+_+" "+o+" "+s)}},t.prototype.arcTo=function(t,e,r,i,n){if(isFinite(t+e+r+i+n)&&null!=this.__currentPosition){var o=this.__currentPosition.x,s=this.__currentPosition.y;if(n<0)throw new Error("IndexSizeError: The radius provided ("+n+") is negative.");if(o===t&&s===e||t===r&&e===i||0===n)this.lineTo(t,e);else{var l=b([o-t,s-e]),h=b([r-t,i-e]);if(l[0]*h[1]!=l[1]*h[0]){var _=l[0]*h[0]+l[1]*h[1],p=Math.acos(Math.abs(_)),u=b([l[0]+h[0],l[1]+h[1]]),c=n/Math.sin(p/2),d=t+c*u[0],f=e+c*u[1],m=[-l[1],l[0]],g=[h[1],-h[0]],v=A(m),y=A(g);this.lineTo(d+m[0]*n,f+m[1]*n),this.arc(d,f,n,v,y)}else this.lineTo(t,e)}}function b(t){var e=(0,a.__read)(t,2),r=e[0],i=e[1],n=Math.sqrt(Math.pow(r,2)+Math.pow(i,2));return[r/n,i/n]}function A(t){var e=t[0];return t[1]>=0?Math.acos(e):-Math.acos(e)}},t.prototype.stroke=function(){"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","fill"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("stroke"),null!=this._clip_path&&this.__currentElement.setAttribute("clip-path",this._clip_path)},t.prototype.fill=function(t,e){var r=null;if(t instanceof Path2D)r=t;else{if("evenodd"!=t&&"nonzero"!=t&&null!=t||null!=e)throw new Error("invalid arguments");e=t}if(null!=r)throw new Error("not implemented");"none"!=this.__currentElement.getAttribute("fill")&&this.__init_element(),"path"===this.__currentElement.nodeName&&this.__currentElement.setAttribute("paint-order","stroke"),this.__applyCurrentDefaultPath(),this.__applyStyleToCurrentElement("fill"),null!=e&&this.__currentElement.setAttribute("fill-rule",e),null!=this._clip_path&&this.__currentElement.setAttribute("clip-path",this._clip_path)},t.prototype.rect=function(t,e,r,i){isFinite(t+e+r+i)&&(this.moveTo(t,e),this.lineTo(t+r,e),this.lineTo(t+r,e+i),this.lineTo(t,e+i),this.lineTo(t,e))},t.prototype.fillRect=function(t,e,r,i){isFinite(t+e+r+i)&&(this.beginPath(),this.rect(t,e,r,i),this.fill())},t.prototype.strokeRect=function(t,e,r,i){isFinite(t+e+r+i)&&(this.beginPath(),this.rect(t,e,r,i),this.stroke())},t.prototype.__clearCanvas=function(){(0,_.empty)(this.__defs),(0,_.empty)(this.__root),this.__root.appendChild(this.__defs),this.__currentElement=this.__root},t.prototype.clearRect=function(t,e,r,i){if(isFinite(t+e+r+i))if(0!==t||0!==e||r!==this.width||i!==this.height){var n=this.__createElement("rect",{x:t,y:e,width:r,height:i,fill:"#FFFFFF"},!0);this._apply_transform(n),this.__root.appendChild(n)}else this.__clearCanvas()},t.prototype.createLinearGradient=function(t,e,r,i){if(!isFinite(t+e+r+i))throw new Error("The provided double value is non-finite");var n=(0,a.__read)(this._transform.apply(t,e),2),o=n[0],s=n[1],l=(0,a.__read)(this._transform.apply(r,i),2),h=l[0],_=l[1],p=this.__createElement("linearGradient",{id:this._random_string(),x1:o+"px",x2:h+"px",y1:s+"px",y2:_+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(p),new d(p,this)},t.prototype.createRadialGradient=function(t,e,r,i,n,o){if(!isFinite(t+e+r+i+n+o))throw new Error("The provided double value is non-finite");var s=(0,a.__read)(this._transform.apply(t,e),2),l=s[0],h=s[1],_=(0,a.__read)(this._transform.apply(i,n),2),p=_[0],u=_[1],c=this.__createElement("radialGradient",{id:this._random_string(),cx:p+"px",cy:u+"px",r:o+"px",r0:r+"px",fx:l+"px",fy:h+"px",gradientUnits:"userSpaceOnUse"},!1);return this.__defs.appendChild(c),new d(c,this)},t.prototype.__parseFont=function(){var t,e,r,i,n,a=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i.exec(this.font);return{style:null!==(t=a[1])&&void 0!==t?t:"normal",size:null!==(e=a[4])&&void 0!==e?e:"10px",family:null!==(r=a[6])&&void 0!==r?r:"sans-serif",weight:null!==(i=a[3])&&void 0!==i?i:"normal",decoration:null!==(n=a[2])&&void 0!==n?n:"normal"}},t.prototype.__applyText=function(t,e,r,i){var n,a,o,s=this,l=this.__parseFont(),h=this.__createElement("text",{"font-family":l.family,"font-size":l.size,"font-style":l.style,"font-weight":l.weight,"text-decoration":l.decoration,x:e,y:r,"text-anchor":(n=this.textAlign,o={left:"start",right:"end",center:"middle",start:"start",end:"end"},null!==(a=o[n])&&void 0!==a?a:o.start),"dominant-baseline":p(this.textBaseline)},!0);h.appendChild(this.__document.createTextNode(t)),this._apply_transform(h),this.__currentElement=h,this.__applyStyleToCurrentElement(i);var _=function(){if(null!=s._clip_path){var t=s.__createElement("g");return t.setAttribute("clip-path",s._clip_path),t.appendChild(h),t}return h}();this.__root.appendChild(_)},t.prototype.fillText=function(t,e,r){null!=t&&isFinite(e+r)&&this.__applyText(t,e,r,"fill")},t.prototype.strokeText=function(t,e,r){null!=t&&isFinite(e+r)&&this.__applyText(t,e,r,"stroke")},t.prototype.measureText=function(t){return this.__ctx.font=this.font,this.__ctx.measureText(t)},t.prototype.arc=function(t,e,r,i,n,a){void 0===a&&(a=!1),this.ellipse(t,e,r,r,0,i,n,a)},t.prototype.ellipse=function(t,e,r,i,n,o,s,l){if(void 0===l&&(l=!1),isFinite(t+e+r+i+n+o+s)){if(r<0||i<0)throw new DOMException("IndexSizeError, radius can't be negative");var _=l?s-o:o-s;o%=2*Math.PI,s%=2*Math.PI;var p=t+r*Math.cos(o),u=e+i*Math.sin(o);this.lineTo(p,u);var c=180*n/Math.PI,d=l?0:1;if(Math.abs(o-s)<2*h.float32_epsilon&&!(Math.abs(_)<2*h.float32_epsilon&&_<0)){var f=t+r*Math.cos(o+Math.PI),m=e+i*Math.sin(o+Math.PI),g=(0,a.__read)(this._transform.apply(p,u),2),v=g[0],y=g[1],b=(0,a.__read)(this._transform.apply(f,m),2),A=b[0],w=b[1];this.__addPathCommand(v,y,"A "+r+" "+i+" "+c+" 0 "+d+" "+A+" "+w+" A "+r+" "+i+" "+c+" 0 "+d+" "+v+" "+y)}else{var x=t+r*Math.cos(s),E=e+i*Math.sin(s),C=s-o;C<0&&(C+=2*Math.PI);var P=l!==C>Math.PI?1:0,k=(0,a.__read)(this._transform.apply(x,E),2),S=k[0],T=k[1];this.__addPathCommand(S,T,"A "+r+" "+i+" "+c+" "+P+" "+d+" "+S+" "+T)}}},t.prototype.clip=function(){var t=this.__createElement("clipPath"),e=this._random_string();this.__applyCurrentDefaultPath(),t.setAttribute("id",e),t.appendChild(this.__currentElement),this.__defs.appendChild(t),this._clip_path="url(#"+e+")"},t.prototype.drawImage=function(e){for(var r,i,n,o,s,l,h,_,p,u,c,d,f,m,g,v=[],y=1;y<arguments.length;y++)v[y-1]=arguments[y];if(2==v.length){if(_=(r=(0,a.__read)(v,2))[0],p=r[1],!isFinite(_+p))return;d=0,f=0,u=m=e.width,c=g=e.height}else if(4==v.length){if(_=(i=(0,a.__read)(v,4))[0],p=i[1],u=i[2],c=i[3],!isFinite(_+p+u+c))return;d=0,f=0,m=e.width,g=e.height}else{if(8!==v.length)throw new Error("Inavlid number of arguments passed to drawImage: "+arguments.length);if(d=(n=(0,a.__read)(v,8))[0],f=n[1],m=n[2],g=n[3],_=n[4],p=n[5],u=n[6],c=n[7],!isFinite(d+f+m+g+_+p+u+c))return}var b=this.__root,A=this._transform.clone().translate(_,p);if(e instanceof t||e instanceof SVGSVGElement){var w=e instanceof SVGSVGElement?e:e.get_svg(),x=w.cloneNode(!0),E=void 0;A.is_identity&&1==this.globalAlpha&&null==this._clip_path?E=b:(E=this.__createElement("g"),A.is_identity||this._apply_transform(E,A),1!=this.globalAlpha&&E.setAttribute("opacity",""+this.globalAlpha),null!=this._clip_path&&E.setAttribute("clip-path",this._clip_path),b.appendChild(E));try{for(var C=(0,a.__values)((0,a.__spreadArray)([],(0,a.__read)(x.childNodes),!1)),P=C.next();!P.done;P=C.next()){var k=P.value;if(k instanceof SVGDefsElement)try{for(var S=(l=void 0,(0,a.__values)((0,a.__spreadArray)([],(0,a.__read)(k.childNodes),!1))),T=S.next();!T.done;T=S.next()){var M=T.value;if(M instanceof Element){var D=M.getAttribute("id");this.__ids.add(D),this.__defs.appendChild(M.cloneNode(!0))}}}catch(t){l={error:t}}finally{try{T&&!T.done&&(h=S.return)&&h.call(S)}finally{if(l)throw l.error}}else E.appendChild(k.cloneNode(!0))}}catch(t){o={error:t}}finally{try{P&&!P.done&&(s=C.return)&&s.call(C)}finally{if(o)throw o.error}}}else if(e instanceof HTMLImageElement||e instanceof SVGImageElement){if((N=this.__createElement("image")).setAttribute("width",""+u),N.setAttribute("height",""+c),N.setAttribute("preserveAspectRatio","none"),1!=this.globalAlpha&&N.setAttribute("opacity",""+this.globalAlpha),d||f||m!==e.width||g!==e.height)(j=this.__document.createElement("canvas")).width=u,j.height=c,(F=j.getContext("2d")).drawImage(e,d,f,m,g,0,0,u,c),e=j;this._apply_transform(N,A);var O=e instanceof HTMLCanvasElement?e.toDataURL():e.getAttribute("src");if(N.setAttribute("href",O),null!=this._clip_path)(E=this.__createElement("g")).setAttribute("clip-path",this._clip_path),E.appendChild(N),b.appendChild(E);else b.appendChild(N)}else if(e instanceof HTMLCanvasElement){var N,j,F;if((N=this.__createElement("image")).setAttribute("width",""+u),N.setAttribute("height",""+c),N.setAttribute("preserveAspectRatio","none"),1!=this.globalAlpha&&N.setAttribute("opacity",""+this.globalAlpha),(j=this.__document.createElement("canvas")).width=u,j.height=c,(F=j.getContext("2d")).imageSmoothingEnabled=!1,F.drawImage(e,d,f,m,g,0,0,u,c),e=j,this._apply_transform(N,A),N.setAttribute("href",e.toDataURL()),null!=this._clip_path)(E=this.__createElement("g")).setAttribute("clip-path",this._clip_path),E.appendChild(N),b.appendChild(E);else b.appendChild(N)}},t.prototype.createPattern=function(e,r){var i,n,o,s,l=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),h=this._random_string();if(l.setAttribute("id",h),l.setAttribute("width",""+this._to_number(e.width)),l.setAttribute("height",""+this._to_number(e.height)),l.setAttribute("patternUnits","userSpaceOnUse"),e instanceof HTMLCanvasElement||e instanceof HTMLImageElement||e instanceof SVGImageElement){var _=this.__document.createElementNS("http://www.w3.org/2000/svg","image"),p=e instanceof HTMLCanvasElement?e.toDataURL():e.getAttribute("src");_.setAttribute("href",p),l.appendChild(_),this.__defs.appendChild(l)}else if(e instanceof t){try{for(var u=(0,a.__values)((0,a.__spreadArray)([],(0,a.__read)(e.__root.childNodes),!1)),c=u.next();!c.done;c=u.next()){(g=c.value)instanceof SVGDefsElement||l.appendChild(g.cloneNode(!0))}}catch(t){i={error:t}}finally{try{c&&!c.done&&(n=u.return)&&n.call(u)}finally{if(i)throw i.error}}this.__defs.appendChild(l)}else{if(!(e instanceof SVGSVGElement))throw new Error("unsupported");try{for(var d=(0,a.__values)((0,a.__spreadArray)([],(0,a.__read)(e.childNodes),!1)),m=d.next();!m.done;m=d.next()){var g;(g=m.value)instanceof SVGDefsElement||l.appendChild(g.cloneNode(!0))}}catch(t){o={error:t}}finally{try{m&&!m.done&&(s=d.return)&&s.call(d)}finally{if(o)throw o.error}}this.__defs.appendChild(l)}return new f(l,this)},t.prototype.getLineDash=function(){var t=this.lineDash;return(0,s.isString)(t)?t.split(",").map((function(t){return parseInt(t)})):null==t?[]:t},t.prototype.setLineDash=function(t){t&&t.length>0?this.lineDash=t.join(","):this.lineDash=null},t.prototype._to_number=function(t){return(0,s.isNumber)(t)?t:t.baseVal.value},t.prototype.getTransform=function(){return this._transform.to_DOMMatrix()},t.prototype.setTransform=function(){for(var t,e=[],r=0;r<arguments.length;r++)e[r]=arguments[r];t=(0,s.isNumber)(e[0])?new DOMMatrix(e):e[0]instanceof DOMMatrix?e[0]:new DOMMatrix(Object.values(!e[0])),this._transform=o.AffineTransform.from_DOMMatrix(t)},t.prototype.resetTransform=function(){this._transform=new o.AffineTransform},t.prototype.isPointInPath=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];throw new Error("not implemented")},t.prototype.isPointInStroke=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];throw new Error("not implemented")},t.prototype.createImageData=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];throw new Error("not implemented")},t.prototype.getImageData=function(t,e,r,i){throw new Error("not implemented")},t.prototype.putImageData=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];throw new Error("not implemented")},t.prototype.drawFocusIfNeeded=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];throw new Error("not implemented")},t.prototype.scrollPathIntoView=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];throw new Error("not implemented")},t}();r.SVGRenderingContext2D=m,m.__name__="SVGRenderingContext2D",m.__random=l.random},
function _(t,e,n,o,r){o();var i=2147483647,s=function(){function t(t){this.seed=t%i,this.seed<=0&&(this.seed+=2147483646)}return t.prototype.integer=function(){return this.seed=48271*this.seed%i,this.seed},t.prototype.float=function(){return(this.integer()-1)/2147483646},t.prototype.floats=function(t,e,n){void 0===e&&(e=0),void 0===n&&(n=1);for(var o=new Array(t),r=0;r<t;r++)o[r]=e+this.float()*(n-e);return o},t.prototype.choices=function(t,e){for(var n=e.length,o=new Array(t),r=0;r<t;r++)o[r]=e[this.integer()%n];return o},t}();n.Random=s,s.__name__="Random",n.random=new s(Date.now())},
function _(t,n,o,i,e){i();var c=t(1),u=t(339),l=t(130),_=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,c.__extends)(n,t),n.prototype._clicked=function(){this.model.do.emit(void 0)},n}(u.ButtonToolButtonView);o.ActionToolButtonView=_,_.__name__="ActionToolButtonView";var r=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,c.__extends)(n,t),n.prototype.connect_signals=function(){var n=this;t.prototype.connect_signals.call(this),this.connect(this.model.do,(function(t){return n.doit(t)}))},n}(u.ButtonToolView);o.ActionToolView=r,r.__name__="ActionToolView";var s=function(t){function n(n){var o=t.call(this,n)||this;return o.button_view=_,o.do=new l.Signal(o,"do"),o}return(0,c.__extends)(n,t),n}(u.ButtonTool);o.ActionTool=s,s.__name__="ActionTool"},
function _(o,e,t,n,i){n();var r,l=o(1),u=o(353),c=o(343),_=function(o){function e(){return null!==o&&o.apply(this,arguments)||this}return(0,l.__extends)(e,o),e.prototype.doit=function(){window.open(this.model.redirect)},e}(u.ActionToolView);t.HelpToolView=_,_.__name__="HelpToolView";var s=function(o){function e(e){var t=o.call(this,e)||this;return t.tool_name="Help",t.icon=c.tool_icon_help,t}return(0,l.__extends)(e,o),e}(u.ActionTool);t.HelpTool=s,r=s,s.__name__="HelpTool",r.prototype.default_view=_,r.define((function(o){return{redirect:[o.String,"https://docs.bokeh.org/en/latest/docs/user_guide/tools.html"]}})),r.override({description:"Click the question mark to learn more about Bokeh plot tools."}),r.register_alias("help",(function(){return new s}))},
function _(o,l,g,A,r){A(),g.root="bk-root",g.logo="bk-logo",g.grey="bk-grey",g.logo_small="bk-logo-small",g.logo_notebook="bk-logo-notebook",g.default=".bk-root .bk-logo{margin:5px;position:relative;display:block;background-repeat:no-repeat;}.bk-root .bk-logo.bk-grey{filter:url(\"data:image/svg+xml;utf8,<svg xmlns='http://www.w3.org/2000/svg'><filter id='grayscale'><feColorMatrix type='matrix' values='0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0.3333 0.3333 0.3333 0 0 0 0 0 1 0'/></filter></svg>#grayscale\");filter:gray;-webkit-filter:grayscale(100%);}.bk-root .bk-logo-small{width:20px;height:20px;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAABx0RVh0U29mdHdhcmUAQWRvYmUgRmlyZXdvcmtzIENTNui8sowAAAOkSURBVDiNjZRtaJVlGMd/1/08zzln5zjP1LWcU9N0NkN8m2CYjpgQYQXqSs0I84OLIC0hkEKoPtiH3gmKoiJDU7QpLgoLjLIQCpEsNJ1vqUOdO7ppbuec5+V+rj4ctwzd8IIbbi6u+8f1539dt3A78eXC7QizUF7gyV1fD1Yqg4JWz84yffhm0qkFqBogB9rM8tZdtwVsPUhWhGcFJngGeWrPzHm5oaMmkfEg1usvLFyc8jLRqDOMru7AyC8saQr7GG7f5fvDeH7Ej8CM66nIF+8yngt6HWaKh7k49Soy9nXurCi1o3qUbS3zWfrYeQDTB/Qj6kX6Ybhw4B+bOYoLKCC9H3Nu/leUTZ1JdRWkkn2ldcCamzrcf47KKXdAJllSlxAOkRgyHsGC/zRday5Qld9DyoM4/q/rUoy/CXh3jzOu3bHUVZeU+DEn8FInkPBFlu3+nW3Nw0mk6vCDiWg8CeJaxEwuHS3+z5RgY+YBR6V1Z1nxSOfoaPa4LASWxxdNp+VWTk7+4vzaou8v8PN+xo+KY2xsw6une2frhw05CTYOmQvsEhjhWjn0bmXPjpE1+kplmmkP3suftwTubK9Vq22qKmrBhpY4jvd5afdRA3wGjFAgcnTK2s4hY0/GPNIb0nErGMCRxWOOX64Z8RAC4oCXdklmEvcL8o0BfkNK4lUg9HTl+oPlQxdNo3Mg4Nv175e/1LDGzZen30MEjRUtmXSfiTVu1kK8W4txyV6BMKlbgk3lMwYCiusNy9fVfvvwMxv8Ynl6vxoByANLTWplvuj/nF9m2+PDtt1eiHPBr1oIfhCChQMBw6Aw0UulqTKZdfVvfG7VcfIqLG9bcldL/+pdWTLxLUy8Qq38heUIjh4XlzZxzQm19lLFlr8vdQ97rjZVOLf8nclzckbcD4wxXMidpX30sFd37Fv/GtwwhzhxGVAprjbg0gCAEeIgwCZyTV2Z1REEW8O4py0wsjeloKoMr6iCY6dP92H6Vw/oTyICIthibxjm/DfN9lVz8IqtqKYLUXfoKVMVQVVJOElGjrnnUt9T9wbgp8AyYKaGlqingHZU/uG2NTZSVqwHQTWkx9hxjkpWDaCg6Ckj5qebgBVbT3V3NNXMSiWSDdGV3hrtzla7J+duwPOToIg42ChPQOQjspnSlp1V+Gjdged7+8UN5CRAV7a5EdFNwCjEaBR27b3W890TE7g24NAP/mMDXRWrGoFPQI9ls/MWO2dWFAar/xcOIImbbpA3zgAAAABJRU5ErkJggg==);}.bk-root .bk-logo-notebook{display:inline-block;vertical-align:middle;margin-right:5px;}"},
function _(t,e,i,o,l){o();var s,n=t(1),r=t(155),a=t(135),h=t(158),c=(0,n.__importStar)(t(357)),p=c,u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,n.__extends)(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.el=(0,h.div)({class:p.tooltip}),(0,h.undisplay)(this.el),this.plot_view.canvas_view.add_overlay(this.el)},e.prototype.remove=function(){(0,h.remove)(this.el),t.prototype.remove.call(this)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.content.change,(function(){return e.render()})),this.connect(this.model.properties.position.change,(function(){return e._reposition()}))},e.prototype.styles=function(){return(0,n.__spreadArray)((0,n.__spreadArray)([],(0,n.__read)(t.prototype.styles.call(this)),!1),[c.default],!1)},e.prototype.render=function(){this.model.visible||(0,h.undisplay)(this.el),t.prototype.render.call(this)},e.prototype._render=function(){var t=this.model.content;null!=t?((0,h.empty)(this.el),(0,h.classes)(this.el).toggle("bk-tooltip-custom",this.model.custom),this.el.appendChild(t),this.model.show_arrow&&this.el.classList.add(p.tooltip_arrow)):(0,h.undisplay)(this.el)},e.prototype._reposition=function(){var t=this,e=this.model.position;if(null!=e){var i,o=(0,n.__read)(e,2),l=o[0],s=o[1],r=function(){var e=t.parent.layout.bbox.relative(),i=t.model.attachment;switch(i){case"horizontal":return l<e.hcenter?"right":"left";case"vertical":return s<e.vcenter?"below":"above";default:return i}}();this.el.classList.remove(p.right),this.el.classList.remove(p.left),this.el.classList.remove(p.above),this.el.classList.remove(p.below),(0,h.display)(this.el);var a=null,c=null;switch(r){case"right":this.el.classList.add(p.left),a=l+(this.el.offsetWidth-this.el.clientWidth)+10,i=s-this.el.offsetHeight/2;break;case"left":this.el.classList.add(p.right),c=this.plot_view.layout.bbox.width-l+10,i=s-this.el.offsetHeight/2;break;case"below":this.el.classList.add(p.above),i=s+(this.el.offsetHeight-this.el.clientHeight)+10,a=Math.round(l-this.el.offsetWidth/2);break;case"above":this.el.classList.add(p.below),i=s-this.el.offsetHeight-10,a=Math.round(l-this.el.offsetWidth/2)}this.el.style.top=i+"px",this.el.style.left=null!=a?a+"px":"auto",this.el.style.right=null!=c?c+"px":"auto"}else(0,h.undisplay)(this.el)},e}(r.AnnotationView);i.TooltipView=u,u.__name__="TooltipView";var d=function(t){function e(e){return t.call(this,e)||this}return(0,n.__extends)(e,t),e.prototype.clear=function(){this.position=null},e}(r.Annotation);i.Tooltip=d,s=d,d.__name__="Tooltip",s.prototype.default_view=u,s.define((function(t){var e=t.Boolean;return{attachment:[a.TooltipAttachment,"horizontal"],inner_only:[e,!0],show_arrow:[e,!0]}})),s.internal((function(t){var e=t.Boolean,i=t.Number,o=t.Tuple,l=t.Ref;return{position:[(0,t.Nullable)(o(i,i)),null],content:[l(HTMLElement),function(){return(0,h.div)()}],custom:[e]}})),s.override({level:"overlay"})},
function _(o,t,r,e,l){e(),r.root="bk-root",r.tooltip="bk-tooltip",r.left="bk-left",r.tooltip_arrow="bk-tooltip-arrow",r.right="bk-right",r.above="bk-above",r.below="bk-below",r.tooltip_row_label="bk-tooltip-row-label",r.tooltip_row_value="bk-tooltip-row-value",r.tooltip_color_block="bk-tooltip-color-block",r.default='.bk-root{}.bk-root .bk-tooltip{font-weight:300;font-size:12px;position:absolute;padding:5px;border:1px solid #e5e5e5;color:#2f2f2f;background-color:white;pointer-events:none;opacity:0.95;z-index:100;}.bk-root .bk-tooltip > div:not(:first-child){margin-top:5px;border-top:#e5e5e5 1px dashed;}.bk-root .bk-tooltip.bk-left.bk-tooltip-arrow::before{position:absolute;margin:-7px 0 0 0;top:50%;width:0;height:0;border-style:solid;border-width:7px 0 7px 0;border-color:transparent;content:" ";display:block;left:-10px;border-right-width:10px;border-right-color:#909599;}.bk-root .bk-tooltip.bk-left::before{left:-10px;border-right-width:10px;border-right-color:#909599;}.bk-root .bk-tooltip.bk-right.bk-tooltip-arrow::after{position:absolute;margin:-7px 0 0 0;top:50%;width:0;height:0;border-style:solid;border-width:7px 0 7px 0;border-color:transparent;content:" ";display:block;right:-10px;border-left-width:10px;border-left-color:#909599;}.bk-root .bk-tooltip.bk-right::after{right:-10px;border-left-width:10px;border-left-color:#909599;}.bk-root .bk-tooltip.bk-above::before{position:absolute;margin:0 0 0 -7px;left:50%;width:0;height:0;border-style:solid;border-width:0 7px 0 7px;border-color:transparent;content:" ";display:block;top:-10px;border-bottom-width:10px;border-bottom-color:#909599;}.bk-root .bk-tooltip.bk-below::after{position:absolute;margin:0 0 0 -7px;left:50%;width:0;height:0;border-style:solid;border-width:0 7px 0 7px;border-color:transparent;content:" ";display:block;bottom:-10px;border-top-width:10px;border-top-color:#909599;}.bk-root .bk-tooltip-row-label{text-align:right;color:#26aae1;}.bk-root .bk-tooltip-row-value{color:default;}.bk-root .bk-tooltip-color-block{width:12px;height:12px;margin-left:5px;margin-right:5px;outline:#dddddd solid 1px;display:inline-block;}'},
function _(e,t,r,i,s){i();var n,a=e(1),l=e(230),o=e(227),_=e(228),h=e(163),u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(t,e),t.prototype.lazy_initialize=function(){return(0,a.__awaiter)(this,void 0,void 0,(function(){var t,r,i,s,n;return(0,a.__generator)(this,(function(a){switch(a.label){case 0:return[4,e.prototype.lazy_initialize.call(this)];case 1:return a.sent(),t=this.model,r=t.lower_head,i=t.upper_head,null==r?[3,3]:(s=this,[4,(0,_.build_view)(r,{parent:this})]);case 2:s.lower_head=a.sent(),a.label=3;case 3:return null==i?[3,5]:(n=this,[4,(0,_.build_view)(i,{parent:this})]);case 4:n.upper_head=a.sent(),a.label=5;case 5:return[2]}}))}))},t.prototype.set_data=function(t){var r,i;e.prototype.set_data.call(this,t),null===(r=this.lower_head)||void 0===r||r.set_data(t),null===(i=this.upper_head)||void 0===i||i.set_data(t)},t.prototype.paint=function(e){if(this.visuals.line.doit)for(var t=0,r=this._lower_sx.length;t<r;t++)this.visuals.line.set_vectorize(e,t),e.beginPath(),e.moveTo(this._lower_sx[t],this._lower_sy[t]),e.lineTo(this._upper_sx[t],this._upper_sy[t]),e.stroke();var i="height"==this.model.dimension?0:Math.PI/2;if(null!=this.lower_head)for(t=0,r=this._lower_sx.length;t<r;t++)e.save(),e.translate(this._lower_sx[t],this._lower_sy[t]),e.rotate(i+Math.PI),this.lower_head.render(e,t),e.restore();if(null!=this.upper_head)for(t=0,r=this._upper_sx.length;t<r;t++)e.save(),e.translate(this._upper_sx[t],this._upper_sy[t]),e.rotate(i),this.upper_head.render(e,t),e.restore()},t}(l.UpperLowerView);r.WhiskerView=u,u.__name__="WhiskerView";var p=function(e){function t(t){return e.call(this,t)||this}return(0,a.__extends)(t,e),t}(l.UpperLower);r.Whisker=p,n=p,p.__name__="Whisker",n.prototype.default_view=u,n.mixins(h.LineVector),n.define((function(e){var t=e.Ref,r=e.Nullable;return{lower_head:[r(t(o.ArrowHead)),function(){return new o.TeeHead({size:10})}],upper_head:[r(t(o.ArrowHead)),function(){return new o.TeeHead({size:10})}]}})),n.override({level:"underlay"})},
function _(n,o,t,u,e){u(),e("CustomJS",n(360).CustomJS),e("OpenURL",n(362).OpenURL)},
function _(e,t,n,r,o){r();var u,a=e(1),i=e(361),c=e(128),s=e(149),f=function(e){function t(t){return e.call(this,t)||this}return(0,a.__extends)(t,e),Object.defineProperty(t.prototype,"names",{get:function(){return(0,c.keys)(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"values",{get:function(){return(0,c.values)(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"func",{get:function(){var e=(0,s.use_strict)(this.code);return new(Function.bind.apply(Function,(0,a.__spreadArray)((0,a.__spreadArray)([void 0],(0,a.__read)(this.names),!1),["cb_obj","cb_data",e],!1)))},enumerable:!1,configurable:!0}),t.prototype.execute=function(e,t){return void 0===t&&(t={}),this.func.apply(e,this.values.concat(e,t))},t}(i.Callback);n.CustomJS=f,u=f,f.__name__="CustomJS",u.define((function(e){var t=e.Unknown,n=e.String;return{args:[(0,e.Dict)(t),{}],code:[n,""]}}))},
function _(n,t,a,l,_){l();var c=n(1),e=function(n){function t(t){return n.call(this,t)||this}return(0,c.__extends)(t,n),t}(n(168).Model);a.Callback=e,e.__name__="Callback"},
function _(e,n,t,r,o){r();var i,a=e(1),l=e(361),c=e(267),u=e(125),f=function(e){function n(n){return e.call(this,n)||this}return(0,a.__extends)(n,e),n.prototype.navigate=function(e){this.same_tab?window.location.href=e:window.open(e)},n.prototype.execute=function(e,n){var t,r,o,i,l=this,f=n.source,s=function(e){var n=(0,c.replace_placeholders)(l.url,f,e,void 0,void 0,encodeURI);if(!(0,u.isString)(n))throw new Error("HTML output is not supported in this context");l.navigate(n)},d=f.selected;try{for(var _=(0,a.__values)(d.indices),v=_.next();!v.done;v=_.next()){s(v.value)}}catch(e){t={error:e}}finally{try{v&&!v.done&&(r=_.return)&&r.call(_)}finally{if(t)throw t.error}}try{for(var h=(0,a.__values)(d.line_indices),p=h.next();!p.done;p=h.next()){s(p.value)}}catch(e){o={error:e}}finally{try{p&&!p.done&&(i=h.return)&&i.call(h)}finally{if(o)throw o.error}}},n}(l.Callback);t.OpenURL=f,i=f,f.__name__="OpenURL",i.define((function(e){var n=e.Boolean;return{url:[e.String,"http://"],same_tab:[n,!1]}}))},
function _(a,n,i,e,r){e(),r("Canvas",a(364).Canvas),r("CartesianFrame",a(241).CartesianFrame),r("CoordinateMapping",a(169).CoordinateMapping)},
function _(e,t,i,r,a){r();var n,s=e(1),o=e(129),l=e(341),u=e(134),p=e(158),h=e(135),c=e(128),_=e(365),d=e(180),v=e(253),b=e(350);function y(){return(0,s.__awaiter)(this,void 0,void 0,(function(){var t,i,r,a;return(0,s.__generator)(this,(function(n){switch(n.label){case 0:return t=document.createElement("canvas"),null==(i=t.getContext("webgl",{premultipliedAlpha:!0}))?[3,2]:[4,(0,v.load_module)(Promise.resolve().then((function(){return(0,s.__importStar)(e(525))})))];case 1:if(null!=(r=n.sent())){if((a=r.get_regl(i)).has_webgl)return[2,{canvas:t,regl_wrapper:a}];u.logger.trace("WebGL is supported, but not the required extensions")}else u.logger.trace("WebGL is supported, but bokehjs(.min).js bundle is not available");return[3,3];case 2:u.logger.trace("WebGL is not supported"),n.label=3;case 3:return[2,null]}}))}))}var g,w=function(){return(0,s.__awaiter)(void 0,void 0,void 0,(function(){return(0,s.__generator)(this,(function(e){switch(e.label){case 0:return void 0===g?[3,1]:[2,g];case 1:return[4,y()];case 2:return[2,g=e.sent()]}}))}))},f={position:"absolute",top:"0",left:"0",width:"100%",height:"100%"},m=function(e){function t(){var t=e.apply(this,(0,s.__spreadArray)([],(0,s.__read)(arguments),!1))||this;return t.bbox=new d.BBox,t.webgl=null,t}return(0,s.__extends)(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.underlays_el=(0,p.div)({style:f}),this.primary=this.create_layer(),this.overlays=this.create_layer(),this.overlays_el=(0,p.div)({style:f}),this.events_el=(0,p.div)({class:"bk-canvas-events",style:f});var t=[this.underlays_el,this.primary.el,this.overlays.el,this.overlays_el,this.events_el];(0,c.extend)(this.el.style,f),p.append.apply(void 0,(0,s.__spreadArray)([this.el],(0,s.__read)(t),!1)),this.ui_event_bus=new _.UIEventBus(this)},t.prototype.lazy_initialize=function(){return(0,s.__awaiter)(this,void 0,void 0,(function(){var t;return(0,s.__generator)(this,(function(i){switch(i.label){case 0:return[4,e.prototype.lazy_initialize.call(this)];case 1:return i.sent(),"webgl"!=this.model.output_backend?[3,3]:(t=this,[4,w()]);case 2:t.webgl=i.sent(),i.label=3;case 3:return[2]}}))}))},t.prototype.remove=function(){this.ui_event_bus.destroy(),e.prototype.remove.call(this)},t.prototype.add_underlay=function(e){this.underlays_el.appendChild(e)},t.prototype.add_overlay=function(e){this.overlays_el.appendChild(e)},t.prototype.add_event=function(e){this.events_el.appendChild(e)},Object.defineProperty(t.prototype,"pixel_ratio",{get:function(){return this.primary.pixel_ratio},enumerable:!1,configurable:!0}),t.prototype.resize=function(e,t){this.bbox=new d.BBox({left:0,top:0,width:e,height:t}),this.primary.resize(e,t),this.overlays.resize(e,t)},t.prototype.prepare_webgl=function(e){var t=this.webgl;if(null!=t){var i=this.bbox,r=i.width,a=i.height;t.canvas.width=this.pixel_ratio*r,t.canvas.height=this.pixel_ratio*a;var n=(0,s.__read)(e,4),o=n[0],l=n[1],u=n[2],p=n[3],h=this.bbox,c=h.xview,_=h.yview,d=c.compute(o),v=_.compute(l+p),b=this.pixel_ratio;t.regl_wrapper.set_scissor(b*d,b*v,b*u,b*p),this._clear_webgl()}},t.prototype.blit_webgl=function(e){var t=this.webgl;if(null!=t){if(u.logger.debug("Blitting WebGL canvas"),e.restore(),e.drawImage(t.canvas,0,0),e.save(),this.model.hidpi){var i=this.pixel_ratio;e.scale(i,i),e.translate(.5,.5)}this._clear_webgl()}},t.prototype._clear_webgl=function(){var e=this.webgl;if(null!=e){var t=e.regl_wrapper,i=e.canvas;t.clear(i.width,i.height)}},t.prototype.compose=function(){var e=this.create_layer(),t=this.bbox,i=t.width,r=t.height;return e.resize(i,r),e.ctx.drawImage(this.primary.canvas,0,0),e.ctx.drawImage(this.overlays.canvas,0,0),e},t.prototype.create_layer=function(){var e=this.model,t=e.output_backend,i=e.hidpi;return new b.CanvasLayer(t,i)},t.prototype.to_blob=function(){return this.compose().to_blob()},t}(l.DOMView);i.CanvasView=m,m.__name__="CanvasView";var x=function(e){function t(t){return e.call(this,t)||this}return(0,s.__extends)(t,e),t}(o.HasProps);i.Canvas=x,n=x,x.__name__="Canvas",n.prototype.default_view=m,n.internal((function(e){return{hidpi:[e.Boolean,!0],output_backend:[h.OutputBackend,"canvas"]}}))},
function _(t,e,n,r,i){r();var s=t(1),o=(0,s.__importDefault)(t(340)),a=t(130),_=t(134),h=t(158),p=(0,s.__importStar)(t(366)),u=t(367),c=t(126),l=t(125),v=t(142),y=t(345);var d=function(){function t(t){var e=this;this.canvas_view=t,this.pan_start=new a.Signal(this,"pan:start"),this.pan=new a.Signal(this,"pan"),this.pan_end=new a.Signal(this,"pan:end"),this.pinch_start=new a.Signal(this,"pinch:start"),this.pinch=new a.Signal(this,"pinch"),this.pinch_end=new a.Signal(this,"pinch:end"),this.rotate_start=new a.Signal(this,"rotate:start"),this.rotate=new a.Signal(this,"rotate"),this.rotate_end=new a.Signal(this,"rotate:end"),this.tap=new a.Signal(this,"tap"),this.doubletap=new a.Signal(this,"doubletap"),this.press=new a.Signal(this,"press"),this.pressup=new a.Signal(this,"pressup"),this.move_enter=new a.Signal(this,"move:enter"),this.move=new a.Signal(this,"move"),this.move_exit=new a.Signal(this,"move:exit"),this.scroll=new a.Signal(this,"scroll"),this.keydown=new a.Signal(this,"keydown"),this.keyup=new a.Signal(this,"keyup"),this.hammer=new o.default(this.hit_area,{touchAction:"auto",inputClass:o.default.TouchMouseInput}),this._prev_move=null,this._curr_pan=null,this._curr_pinch=null,this._curr_rotate=null,this._configure_hammerjs(),this.hit_area.addEventListener("mousemove",(function(t){return e._mouse_move(t)})),this.hit_area.addEventListener("mouseenter",(function(t){return e._mouse_enter(t)})),this.hit_area.addEventListener("mouseleave",(function(t){return e._mouse_exit(t)})),this.hit_area.addEventListener("contextmenu",(function(t){return e._context_menu(t)})),this.hit_area.addEventListener("wheel",(function(t){return e._mouse_wheel(t)})),document.addEventListener("keydown",this),document.addEventListener("keyup",this),this.menu=new y.ContextMenu([],{prevent_hide:function(t){return 2==t.button&&t.target==e.hit_area}}),this.hit_area.appendChild(this.menu.el)}return Object.defineProperty(t.prototype,"hit_area",{get:function(){return this.canvas_view.events_el},enumerable:!1,configurable:!0}),t.prototype.destroy=function(){this.menu.remove(),this.hammer.destroy(),document.removeEventListener("keydown",this),document.removeEventListener("keyup",this)},t.prototype.handleEvent=function(t){"keydown"==t.type?this._key_down(t):"keyup"==t.type&&this._key_up(t)},t.prototype._configure_hammerjs=function(){var t=this;this.hammer.get("doubletap").recognizeWith("tap"),this.hammer.get("tap").requireFailure("doubletap"),this.hammer.get("doubletap").dropRequireFailure("tap"),this.hammer.on("doubletap",(function(e){return t._doubletap(e)})),this.hammer.on("tap",(function(e){return t._tap(e)})),this.hammer.on("press",(function(e){return t._press(e)})),this.hammer.on("pressup",(function(e){return t._pressup(e)})),this.hammer.get("pan").set({direction:o.default.DIRECTION_ALL}),this.hammer.on("panstart",(function(e){return t._pan_start(e)})),this.hammer.on("pan",(function(e){return t._pan(e)})),this.hammer.on("panend",(function(e){return t._pan_end(e)})),this.hammer.get("pinch").set({enable:!0}),this.hammer.on("pinchstart",(function(e){return t._pinch_start(e)})),this.hammer.on("pinch",(function(e){return t._pinch(e)})),this.hammer.on("pinchend",(function(e){return t._pinch_end(e)})),this.hammer.get("rotate").set({enable:!0}),this.hammer.on("rotatestart",(function(e){return t._rotate_start(e)})),this.hammer.on("rotate",(function(e){return t._rotate(e)})),this.hammer.on("rotateend",(function(e){return t._rotate_end(e)}))},t.prototype.register_tool=function(t){var e=this,n=t.model.event_type;null!=n&&((0,l.isString)(n)?this._register_tool(t,n):n.forEach((function(n,r){return e._register_tool(t,n,r<1)})))},t.prototype._register_tool=function(t,e,n){void 0===n&&(n=!0);var r=t,i=r.model.id,s=function(t){return function(e){e.id==i&&t(e.e)}},o=function(t){return function(e){t(e.e)}};switch(e){case"pan":null!=r._pan_start&&r.connect(this.pan_start,s(r._pan_start.bind(r))),null!=r._pan&&r.connect(this.pan,s(r._pan.bind(r))),null!=r._pan_end&&r.connect(this.pan_end,s(r._pan_end.bind(r)));break;case"pinch":null!=r._pinch_start&&r.connect(this.pinch_start,s(r._pinch_start.bind(r))),null!=r._pinch&&r.connect(this.pinch,s(r._pinch.bind(r))),null!=r._pinch_end&&r.connect(this.pinch_end,s(r._pinch_end.bind(r)));break;case"rotate":null!=r._rotate_start&&r.connect(this.rotate_start,s(r._rotate_start.bind(r))),null!=r._rotate&&r.connect(this.rotate,s(r._rotate.bind(r))),null!=r._rotate_end&&r.connect(this.rotate_end,s(r._rotate_end.bind(r)));break;case"move":null!=r._move_enter&&r.connect(this.move_enter,s(r._move_enter.bind(r))),null!=r._move&&r.connect(this.move,s(r._move.bind(r))),null!=r._move_exit&&r.connect(this.move_exit,s(r._move_exit.bind(r)));break;case"tap":null!=r._tap&&r.connect(this.tap,s(r._tap.bind(r))),null!=r._doubletap&&r.connect(this.doubletap,s(r._doubletap.bind(r)));break;case"press":null!=r._press&&r.connect(this.press,s(r._press.bind(r))),null!=r._pressup&&r.connect(this.pressup,s(r._pressup.bind(r)));break;case"scroll":null!=r._scroll&&r.connect(this.scroll,s(r._scroll.bind(r)));break;default:throw new Error("unsupported event_type: "+e)}n&&(null!=r._keydown&&r.connect(this.keydown,o(r._keydown.bind(r))),null!=r._keyup&&r.connect(this.keyup,o(r._keyup.bind(r))),v.is_mobile&&null!=r._scroll&&"pinch"==e&&(_.logger.debug("Registering scroll on touch screen"),r.connect(this.scroll,s(r._scroll.bind(r)))))},t.prototype._hit_test_renderers=function(t,e,n){var r,i,o,a=t.get_renderer_views();try{for(var _=(0,s.__values)((0,c.reversed)(a)),h=_.next();!h.done;h=_.next()){var p=h.value;if(null===(o=p.interactive_hit)||void 0===o?void 0:o.call(p,e,n))return p}}catch(t){r={error:t}}finally{try{h&&!h.done&&(i=_.return)&&i.call(_)}finally{if(r)throw r.error}}return null},t.prototype.set_cursor=function(t){void 0===t&&(t="default"),this.hit_area.style.cursor=t},t.prototype._hit_test_frame=function(t,e,n){return t.frame.bbox.contains(e,n)},t.prototype._hit_test_canvas=function(t,e,n){return t.layout.bbox.contains(e,n)},t.prototype._hit_test_plot=function(t,e){var n,r;try{for(var i=(0,s.__values)(this.canvas_view.plot_views),o=i.next();!o.done;o=i.next()){var a=o.value;if(a.layout.bbox.relative().contains(t,e))return a}}catch(t){n={error:t}}finally{try{o&&!o.done&&(r=i.return)&&r.call(i)}finally{if(n)throw n.error}}return null},t.prototype._trigger=function(t,e,n){var r,i=e.sx,o=e.sy,a=this._hit_test_plot(i,o),_=function(t){var n=(0,s.__read)([i,o],2),r=n[0],a=n[1];return(0,s.__assign)((0,s.__assign)({},e),{sx:r,sy:a})};if("panstart"==e.type||"pan"==e.type||"panend"==e.type){var h=void 0;if("panstart"==e.type&&null!=a?(this._curr_pan={plot_view:a},h=a):"pan"==e.type&&null!=this._curr_pan?h=this._curr_pan.plot_view:"panend"==e.type&&null!=this._curr_pan?(h=this._curr_pan.plot_view,this._curr_pan=null):h=null,null!=h){var p=_();this.__trigger(h,t,p,n)}}else if("pinchstart"==e.type||"pinch"==e.type||"pinchend"==e.type){var u=void 0;if("pinchstart"==e.type&&null!=a?(this._curr_pinch={plot_view:a},u=a):"pinch"==e.type&&null!=this._curr_pinch?u=this._curr_pinch.plot_view:"pinchend"==e.type&&null!=this._curr_pinch?(u=this._curr_pinch.plot_view,this._curr_pinch=null):u=null,null!=u){p=_();this.__trigger(u,t,p,n)}}else if("rotatestart"==e.type||"rotate"==e.type||"rotateend"==e.type){var c=void 0;if("rotatestart"==e.type&&null!=a?(this._curr_rotate={plot_view:a},c=a):"rotate"==e.type&&null!=this._curr_rotate?c=this._curr_rotate.plot_view:"rotateend"==e.type&&null!=this._curr_rotate?(c=this._curr_rotate.plot_view,this._curr_rotate=null):c=null,null!=c){p=_();this.__trigger(c,t,p,n)}}else if("mouseenter"==e.type||"mousemove"==e.type||"mouseleave"==e.type){var l=null===(r=this._prev_move)||void 0===r?void 0:r.plot_view;if(null!=l&&("mouseleave"==e.type||l!=a)){var v=_(),y=v.sx,d=v.sy;this.__trigger(l,this.move_exit,{type:"mouseleave",sx:y,sy:d,shiftKey:!1,ctrlKey:!1},n)}if(null!=a&&("mouseenter"==e.type||l!=a)){var g=_(),f=g.sx,m=g.sy;this.__trigger(a,this.move_enter,{type:"mouseenter",sx:f,sy:m,shiftKey:!1,ctrlKey:!1},n)}if(null!=a&&"mousemove"==e.type){p=_();this.__trigger(a,t,p,n)}this._prev_move={sx:i,sy:o,plot_view:a}}else if(null!=a){p=_();this.__trigger(a,t,p,n)}},t.prototype.__trigger=function(t,e,n,r){var i,s,o=this,a=t.model.toolbar.gestures,_=e.name.split(":")[0],h=this._hit_test_renderers(t,n.sx,n.sy),p=this._hit_test_canvas(t,n.sx,n.sy);switch(_){case"move":null!=(d=a[_].active)&&this.trigger(e,n,d.id);var u=t.model.toolbar.inspectors.filter((function(t){return t.active})),l="default";null!=h?(l=null!==(i=h.cursor(n.sx,n.sy))&&void 0!==i?i:l,(0,c.is_empty)(u)||(e=this.move_exit)):this._hit_test_frame(t,n.sx,n.sy)&&((0,c.is_empty)(u)||(l="crosshair")),this.set_cursor(l),t.set_toolbar_visibility(p),u.map((function(t){return o.trigger(e,n,t.id)}));break;case"tap":var y=r.target;if(null!=y&&y!=this.hit_area)return;null!=h&&null!=h.on_hit&&h.on_hit(n.sx,n.sy),null!=(d=a[_].active)&&this.trigger(e,n,d.id);break;case"doubletap":null!=(d=null!==(s=a.doubletap.active)&&void 0!==s?s:a.tap.active)&&this.trigger(e,n,d.id);break;case"scroll":null!=(d=a[v.is_mobile?"pinch":"scroll"].active)&&(r.preventDefault(),r.stopPropagation(),this.trigger(e,n,d.id));break;case"pan":null!=(d=a[_].active)&&(r.preventDefault(),this.trigger(e,n,d.id));break;default:var d;null!=(d=a[_].active)&&this.trigger(e,n,d.id)}this._trigger_bokeh_event(t,n)},t.prototype.trigger=function(t,e,n){void 0===n&&(n=null),t.emit({id:n,e:e})},t.prototype._trigger_bokeh_event=function(t,e){var n=function(){var n=e.sx,r=e.sy,i=t.frame.x_scale.invert(n),s=t.frame.y_scale.invert(r);switch(e.type){case"wheel":return new p.MouseWheel(n,r,i,s,e.delta);case"mousemove":return new p.MouseMove(n,r,i,s);case"mouseenter":return new p.MouseEnter(n,r,i,s);case"mouseleave":return new p.MouseLeave(n,r,i,s);case"tap":return new p.Tap(n,r,i,s);case"doubletap":return new p.DoubleTap(n,r,i,s);case"press":return new p.Press(n,r,i,s);case"pressup":return new p.PressUp(n,r,i,s);case"pan":return new p.Pan(n,r,i,s,e.deltaX,e.deltaY);case"panstart":return new p.PanStart(n,r,i,s);case"panend":return new p.PanEnd(n,r,i,s);case"pinch":return new p.Pinch(n,r,i,s,e.scale);case"pinchstart":return new p.PinchStart(n,r,i,s);case"pinchend":return new p.PinchEnd(n,r,i,s);case"rotate":return new p.Rotate(n,r,i,s,e.rotation);case"rotatestart":return new p.RotateStart(n,r,i,s);case"rotateend":return new p.RotateEnd(n,r,i,s);default:return}}();null!=n&&t.model.trigger_event(n)},t.prototype._get_sxy=function(t){var e=function(t){return"undefined"!=typeof TouchEvent&&t instanceof TouchEvent}(t)?(0!=t.touches.length?t.touches:t.changedTouches)[0]:t,n=e.pageX,r=e.pageY,i=(0,h.offset)(this.hit_area);return{sx:n-i.left,sy:r-i.top}},t.prototype._pan_event=function(t){return(0,s.__assign)((0,s.__assign)({type:t.type},this._get_sxy(t.srcEvent)),{deltaX:t.deltaX,deltaY:t.deltaY,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})},t.prototype._pinch_event=function(t){return(0,s.__assign)((0,s.__assign)({type:t.type},this._get_sxy(t.srcEvent)),{scale:t.scale,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})},t.prototype._rotate_event=function(t){return(0,s.__assign)((0,s.__assign)({type:t.type},this._get_sxy(t.srcEvent)),{rotation:t.rotation,shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})},t.prototype._tap_event=function(t){return(0,s.__assign)((0,s.__assign)({type:t.type},this._get_sxy(t.srcEvent)),{shiftKey:t.srcEvent.shiftKey,ctrlKey:t.srcEvent.ctrlKey})},t.prototype._move_event=function(t){return(0,s.__assign)((0,s.__assign)({type:t.type},this._get_sxy(t)),{shiftKey:t.shiftKey,ctrlKey:t.ctrlKey})},t.prototype._scroll_event=function(t){return(0,s.__assign)((0,s.__assign)({type:t.type},this._get_sxy(t)),{delta:(0,u.getDeltaY)(t),shiftKey:t.shiftKey,ctrlKey:t.ctrlKey})},t.prototype._key_event=function(t){return{type:t.type,keyCode:t.keyCode}},t.prototype._pan_start=function(t){var e=this._pan_event(t);e.sx-=t.deltaX,e.sy-=t.deltaY,this._trigger(this.pan_start,e,t.srcEvent)},t.prototype._pan=function(t){this._trigger(this.pan,this._pan_event(t),t.srcEvent)},t.prototype._pan_end=function(t){this._trigger(this.pan_end,this._pan_event(t),t.srcEvent)},t.prototype._pinch_start=function(t){this._trigger(this.pinch_start,this._pinch_event(t),t.srcEvent)},t.prototype._pinch=function(t){this._trigger(this.pinch,this._pinch_event(t),t.srcEvent)},t.prototype._pinch_end=function(t){this._trigger(this.pinch_end,this._pinch_event(t),t.srcEvent)},t.prototype._rotate_start=function(t){this._trigger(this.rotate_start,this._rotate_event(t),t.srcEvent)},t.prototype._rotate=function(t){this._trigger(this.rotate,this._rotate_event(t),t.srcEvent)},t.prototype._rotate_end=function(t){this._trigger(this.rotate_end,this._rotate_event(t),t.srcEvent)},t.prototype._tap=function(t){this._trigger(this.tap,this._tap_event(t),t.srcEvent)},t.prototype._doubletap=function(t){this._trigger(this.doubletap,this._tap_event(t),t.srcEvent)},t.prototype._press=function(t){this._trigger(this.press,this._tap_event(t),t.srcEvent)},t.prototype._pressup=function(t){this._trigger(this.pressup,this._tap_event(t),t.srcEvent)},t.prototype._mouse_enter=function(t){this._trigger(this.move_enter,this._move_event(t),t)},t.prototype._mouse_move=function(t){this._trigger(this.move,this._move_event(t),t)},t.prototype._mouse_exit=function(t){this._trigger(this.move_exit,this._move_event(t),t)},t.prototype._mouse_wheel=function(t){this._trigger(this.scroll,this._scroll_event(t),t)},t.prototype._context_menu=function(t){!this.menu.is_open&&this.menu.can_open&&t.preventDefault();var e=this._get_sxy(t),n=e.sx,r=e.sy;this.menu.toggle({left:n,top:r})},t.prototype._key_down=function(t){this.trigger(this.keydown,this._key_event(t))},t.prototype._key_up=function(t){this.trigger(this.keyup,this._key_event(t))},t}();n.UIEventBus=d,d.__name__="UIEventBus"},
function _(t,n,e,r,_){r();var o=t(1),a=this&&this.__decorate||function(t,n,e,r){var _,o=arguments.length,a=o<3?n:null===r?r=Object.getOwnPropertyDescriptor(n,e):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)a=Reflect.decorate(t,n,e,r);else for(var s=t.length-1;s>=0;s--)(_=t[s])&&(a=(o<3?_(a):o>3?_(n,e,a):_(n,e))||a);return o>3&&a&&Object.defineProperty(n,e,a),a};function s(t){return function(n){n.prototype.event_name=t}}var i=function(){function t(){}return t.prototype.to_json=function(){return{event_name:this.event_name,event_values:this._to_json()}},t}();e.BokehEvent=i,i.__name__="BokehEvent";var u=function(t){function n(){var n=t.apply(this,(0,o.__spreadArray)([],(0,o.__read)(arguments),!1))||this;return n.origin=null,n}return(0,o.__extends)(n,t),n.prototype._to_json=function(){return{model:this.origin}},n}(i);e.ModelEvent=u,u.__name__="ModelEvent";var l=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(n,t),n.prototype._to_json=function(){return{}},n}(i);e.DocumentReady=l,l.__name__="DocumentReady",e.DocumentReady=l=a([s("document_ready")],l);var c=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(n,t),n}(u);e.ButtonClick=c,c.__name__="ButtonClick",e.ButtonClick=c=a([s("button_click")],c);var p=function(t){function n(n){var e=t.call(this)||this;return e.item=n,e}return(0,o.__extends)(n,t),n.prototype._to_json=function(){var n=this.item;return(0,o.__assign)((0,o.__assign)({},t.prototype._to_json.call(this)),{item:n})},n}(u);e.MenuItemClick=p,p.__name__="MenuItemClick",e.MenuItemClick=p=a([s("menu_item_click")],p);var h=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(n,t),n}(u);e.UIEvent=h,h.__name__="UIEvent";var f=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(n,t),n}(h);e.LODStart=f,f.__name__="LODStart",e.LODStart=f=a([s("lodstart")],f);var d=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(n,t),n}(h);e.LODEnd=d,d.__name__="LODEnd",e.LODEnd=d=a([s("lodend")],d);var y=function(t){function n(n,e,r,_){var o=t.call(this)||this;return o.x0=n,o.x1=e,o.y0=r,o.y1=_,o}return(0,o.__extends)(n,t),n.prototype._to_json=function(){var n=this,e=n.x0,r=n.x1,_=n.y0,a=n.y1;return(0,o.__assign)((0,o.__assign)({},t.prototype._to_json.call(this)),{x0:e,x1:r,y0:_,y1:a})},n}(h);e.RangesUpdate=y,y.__name__="RangesUpdate",e.RangesUpdate=y=a([s("rangesupdate")],y);var v=function(t){function n(n,e){var r=t.call(this)||this;return r.geometry=n,r.final=e,r}return(0,o.__extends)(n,t),n.prototype._to_json=function(){var n=this.geometry,e=this.final;return(0,o.__assign)((0,o.__assign)({},t.prototype._to_json.call(this)),{geometry:n,final:e})},n}(h);e.SelectionGeometry=v,v.__name__="SelectionGeometry",e.SelectionGeometry=v=a([s("selectiongeometry")],v);var m=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(n,t),n}(h);e.Reset=m,m.__name__="Reset",e.Reset=m=a([s("reset")],m);var x=function(t){function n(n,e,r,_){var o=t.call(this)||this;return o.sx=n,o.sy=e,o.x=r,o.y=_,o}return(0,o.__extends)(n,t),n.prototype._to_json=function(){var n=this,e=n.sx,r=n.sy,_=n.x,a=n.y;return(0,o.__assign)((0,o.__assign)({},t.prototype._to_json.call(this)),{sx:e,sy:r,x:_,y:a})},n}(h);e.PointEvent=x,x.__name__="PointEvent";var g=function(t){function n(n,e,r,_,o,a){var s=t.call(this,n,e,r,_)||this;return s.delta_x=o,s.delta_y=a,s}return(0,o.__extends)(n,t),n.prototype._to_json=function(){var n=this.delta_x,e=this.delta_y;return(0,o.__assign)((0,o.__assign)({},t.prototype._to_json.call(this)),{delta_x:n,delta_y:e})},n}(x);e.Pan=g,g.__name__="Pan",e.Pan=g=a([s("pan")],g);var P=function(t){function n(n,e,r,_,o){var a=t.call(this,n,e,r,_)||this;return a.scale=o,a}return(0,o.__extends)(n,t),n.prototype._to_json=function(){var n=this.scale;return(0,o.__assign)((0,o.__assign)({},t.prototype._to_json.call(this)),{scale:n})},n}(x);e.Pinch=P,P.__name__="Pinch",e.Pinch=P=a([s("pinch")],P);var j=function(t){function n(n,e,r,_,o){var a=t.call(this,n,e,r,_)||this;return a.rotation=o,a}return(0,o.__extends)(n,t),n.prototype._to_json=function(){var n=this.rotation;return(0,o.__assign)((0,o.__assign)({},t.prototype._to_json.call(this)),{rotation:n})},n}(x);e.Rotate=j,j.__name__="Rotate",e.Rotate=j=a([s("rotate")],j);var E=function(t){function n(n,e,r,_,o){var a=t.call(this,n,e,r,_)||this;return a.delta=o,a}return(0,o.__extends)(n,t),n.prototype._to_json=function(){var n=this.delta;return(0,o.__assign)((0,o.__assign)({},t.prototype._to_json.call(this)),{delta:n})},n}(x);e.MouseWheel=E,E.__name__="MouseWheel",e.MouseWheel=E=a([s("wheel")],E);var R=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(n,t),n}(x);e.MouseMove=R,R.__name__="MouseMove",e.MouseMove=R=a([s("mousemove")],R);var M=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(n,t),n}(x);e.MouseEnter=M,M.__name__="MouseEnter",e.MouseEnter=M=a([s("mouseenter")],M);var S=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(n,t),n}(x);e.MouseLeave=S,S.__name__="MouseLeave",e.MouseLeave=S=a([s("mouseleave")],S);var D=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(n,t),n}(x);e.Tap=D,D.__name__="Tap",e.Tap=D=a([s("tap")],D);var k=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(n,t),n}(x);e.DoubleTap=k,k.__name__="DoubleTap",e.DoubleTap=k=a([s("doubletap")],k);var L=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(n,t),n}(x);e.Press=L,L.__name__="Press",e.Press=L=a([s("press")],L);var O=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(n,t),n}(x);e.PressUp=O,O.__name__="PressUp",e.PressUp=O=a([s("pressup")],O);var b=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(n,t),n}(x);e.PanStart=b,b.__name__="PanStart",e.PanStart=b=a([s("panstart")],b);var U=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(n,t),n}(x);e.PanEnd=U,U.__name__="PanEnd",e.PanEnd=U=a([s("panend")],U);var C=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(n,t),n}(x);e.PinchStart=C,C.__name__="PinchStart",e.PinchStart=C=a([s("pinchstart")],C);var T=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(n,t),n}(x);e.PinchEnd=T,T.__name__="PinchEnd",e.PinchEnd=T=a([s("pinchend")],T);var B=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(n,t),n}(x);e.RotateStart=B,B.__name__="RotateStart",e.RotateStart=B=a([s("rotatestart")],B);var I=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(n,t),n}(x);e.RotateEnd=I,I.__name__="RotateEnd",e.RotateEnd=I=a([s("rotateend")],I)},
function _(t,e,n,l,a){
/*!
     * jQuery Mousewheel 3.1.13
     *
     * Copyright jQuery Foundation and other contributors
     * Released under the MIT license
     * http://jquery.org/license
     */
function o(t){var e=getComputedStyle(t).fontSize;return null!=e?parseInt(e,10):null}l(),n.getDeltaY=function(t){var e,n,l,a,r=-t.deltaY;if(t.target instanceof HTMLElement)switch(t.deltaMode){case t.DOM_DELTA_LINE:r*=(e=t.target,null!==(a=null!==(l=o(null!==(n=e.offsetParent)&&void 0!==n?n:document.body))&&void 0!==l?l:o(e))&&void 0!==a?a:16);break;case t.DOM_DELTA_PAGE:r*=function(t){return t.clientHeight}(t.target)}return r}},
function _(m,o,n,r,a){r(),a("Expression",m(369).Expression),a("CustomJSExpr",m(370).CustomJSExpr),a("Stack",m(371).Stack),a("CumSum",m(372).CumSum),a("ScalarExpression",m(369).ScalarExpression),a("Minimum",m(373).Minimum),a("Maximum",m(374).Maximum);var s=m(375);a("XComponent",s.XComponent),a("YComponent",s.YComponent),a("PolarTransform",m(376).PolarTransform)},
function _(t,i,e,n,r){n();var o=t(1),s=t(168),u=function(t){function i(i){return t.call(this,i)||this}return(0,o.__extends)(i,t),i.prototype.initialize=function(){t.prototype.initialize.call(this),this._result=new Map},i.prototype.v_compute=function(t){var i=this._result.get(t);return(void 0===i||t.changed_for(this))&&(i=this._v_compute(t),this._result.set(t,i)),i},i}(s.Model);e.Expression=u,u.__name__="Expression";var _=function(t){function i(i){return t.call(this,i)||this}return(0,o.__extends)(i,t),i.prototype.initialize=function(){t.prototype.initialize.call(this),this._result=new Map},i.prototype.compute=function(t){var i=this._result.get(t);return(void 0===i||t.changed_for(this))&&(i=this._compute(t),this._result.set(t,i)),i},i}(s.Model);e.ScalarExpression=_,_.__name__="ScalarExpression"},
function _(e,r,n,t,a){t();var o,i=e(1),s=e(129),u=e(369),c=e(139),l=e(126),p=e(128),f=e(149),_=e(125),y=function(e){function r(r){return e.call(this,r)||this}return(0,i.__extends)(r,e),r.prototype.connect_signals=function(){var r,n,t=this;e.prototype.connect_signals.call(this);try{for(var a=(0,i.__values)((0,p.values)(this.args)),o=a.next();!o.done;o=a.next()){var u=o.value;u instanceof s.HasProps&&u.change.connect((function(){t._result.clear(),t.change.emit()}))}}catch(e){r={error:e}}finally{try{o&&!o.done&&(n=a.return)&&n.call(a)}finally{if(r)throw r.error}}},Object.defineProperty(r.prototype,"names",{get:function(){return(0,p.keys)(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(r.prototype,"values",{get:function(){return(0,p.values)(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(r.prototype,"func",{get:function(){var e=(0,f.use_strict)(this.code);return new(c.GeneratorFunction.bind.apply(c.GeneratorFunction,(0,i.__spreadArray)((0,i.__spreadArray)([void 0],(0,i.__read)(this.names),!1),[e],!1)))},enumerable:!1,configurable:!0}),r.prototype._v_compute=function(e){var r=this.func.apply(e,this.values),n=r.next();if(n.done&&void 0!==n.value){var t=n.value;return(0,_.isArray)(t)||(0,_.isTypedArray)(t)?t:(0,_.isIterable)(t)?(0,i.__spreadArray)([],(0,i.__read)(t),!1):(0,l.repeat)(t,e.length)}var a=[];do{a.push(n.value),n=r.next()}while(!n.done);return a},r}(u.Expression);n.CustomJSExpr=y,o=y,y.__name__="CustomJSExpr",o.define((function(e){var r=e.Unknown,n=e.String;return{args:[(0,e.Dict)(r),{}],code:[n,""]}}))},
function _(r,n,t,e,a){e();var i,l=r(1),o=function(r){function n(n){return r.call(this,n)||this}return(0,l.__extends)(n,r),n.prototype._v_compute=function(r){var n,t,e,a=null!==(e=r.get_length())&&void 0!==e?e:0,i=new Float64Array(a);try{for(var o=(0,l.__values)(this.fields),u=o.next();!u.done;u=o.next()){var f=u.value,c=r.data[f];if(null!=c)for(var _=Math.min(a,c.length),v=0;v<_;v++)i[v]+=c[v]}}catch(r){n={error:r}}finally{try{u&&!u.done&&(t=o.return)&&t.call(o)}finally{if(n)throw n.error}}return i},n}(r(369).Expression);t.Stack=o,i=o,o.__name__="Stack",i.define((function(r){var n=r.String;return{fields:[(0,r.Array)(n),[]]}}))},
function _(n,e,t,r,i){r();var u,o=n(1),l=function(n){function e(e){return n.call(this,e)||this}return(0,o.__extends)(e,n),e.prototype._v_compute=function(n){var e,t=new Float64Array(null!==(e=n.get_length())&&void 0!==e?e:0),r=n.data[this.field],i=this.include_zero?1:0;t[0]=this.include_zero?0:r[0];for(var u=1;u<t.length;u++)t[u]=t[u-1]+r[u-i];return t},e}(n(369).Expression);t.CumSum=l,u=l,l.__name__="CumSum",u.define((function(n){var e=n.Boolean;return{field:[n.String],include_zero:[e,!1]}}))},
function _(i,n,t,u,e){u();var l,r=i(1),a=i(369),o=i(126),m=function(i){function n(n){return i.call(this,n)||this}return(0,r.__extends)(n,i),n.prototype._compute=function(i){var n,t,u=null!==(n=i.data[this.field])&&void 0!==n?n:[];return Math.min(null!==(t=this.initial)&&void 0!==t?t:1/0,(0,o.min)(u))},n}(a.ScalarExpression);t.Minimum=m,l=m,m.__name__="Minimum",l.define((function(i){var n=i.Number;return{field:[i.String],initial:[(0,i.Nullable)(n),null]}}))},
function _(i,n,t,a,u){a();var e,l=i(1),r=i(369),o=i(126),m=function(i){function n(n){return i.call(this,n)||this}return(0,l.__extends)(n,i),n.prototype._compute=function(i){var n,t,a=null!==(n=i.data[this.field])&&void 0!==n?n:[];return Math.max(null!==(t=this.initial)&&void 0!==t?t:-1/0,(0,o.max)(a))},n}(r.ScalarExpression);t.Maximum=m,e=m,m.__name__="Maximum",e.define((function(i){var n=i.Number;return{field:[i.String],initial:[(0,i.Nullable)(n),null]}}))},
function _(n,t,e,r,o){r();var i,u=n(1),_=n(369),f=function(n){function t(t){return n.call(this,t)||this}return(0,u.__extends)(t,n),Object.defineProperty(t.prototype,"x",{get:function(){return new c({transform:this})},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"y",{get:function(){return new a({transform:this})},enumerable:!1,configurable:!0}),t}(_.Expression);e.CoordinateTransform=f,f.__name__="CoordinateTransform";var s=function(n){function t(t){return n.call(this,t)||this}return(0,u.__extends)(t,n),t}(_.Expression);e.XYComponent=s,i=s,s.__name__="XYComponent",i.define((function(n){return{transform:[(0,n.Ref)(f)]}}));var c=function(n){function t(t){return n.call(this,t)||this}return(0,u.__extends)(t,n),t.prototype._v_compute=function(n){return this.transform.v_compute(n).x},t}(s);e.XComponent=c,c.__name__="XComponent";var a=function(n){function t(t){return n.call(this,t)||this}return(0,u.__extends)(t,n),t.prototype._v_compute=function(n){return this.transform.v_compute(n).y},t}(s);e.YComponent=a,a.__name__="YComponent"},
function _(r,n,t,e,i){e();var o,a=r(1),c=r(375),s=r(135),l=(0,a.__importStar)(r(133)),u=function(r){function n(n){return r.call(this,n)||this}return(0,a.__extends)(n,r),n.prototype._v_compute=function(r){for(var n=this.properties.radius.uniform(r),t=this.properties.angle.uniform(r),e="anticlock"==this.direction?-1:1,i=Math.min(n.length,t.length),o=new Float64Array(i),a=new Float64Array(i),c=0;c<i;c++){var s=n.get(c),l=t.get(c)*e;o[c]=s*Math.cos(l),a[c]=s*Math.sin(l)}return{x:o,y:a}},n}(c.CoordinateTransform);t.PolarTransform=u,o=u,u.__name__="PolarTransform",o.define((function(r){return{radius:[l.DistanceSpec,{field:"radius"}],angle:[l.AngleSpec,{field:"angle"}],direction:[s.Direction,"anticlock"]}}))},
function _(e,t,l,r,i){r(),i("BooleanFilter",e(378).BooleanFilter),i("CustomJSFilter",e(379).CustomJSFilter),i("Filter",e(306).Filter),i("GroupFilter",e(380).GroupFilter),i("IndexFilter",e(381).IndexFilter)},
function _(n,e,l,o,t){o();var r,i=n(1),a=n(306),u=n(139),s=function(n){function e(e){return n.call(this,e)||this}return(0,i.__extends)(e,n),e.prototype.compute_indices=function(n){var e=n.length,l=this.booleans;return null==l?u.Indices.all_set(e):u.Indices.from_booleans(e,l)},e}(a.Filter);l.BooleanFilter=s,r=s,s.__name__="BooleanFilter",r.define((function(n){var e=n.Boolean,l=n.Array;return{booleans:[(0,n.Nullable)(l(e)),null]}}))},
function _(e,r,n,t,i){t();var o,a=e(1),s=e(306),u=e(139),c=e(128),l=e(125),f=e(149),_=function(e){function r(r){return e.call(this,r)||this}return(0,a.__extends)(r,e),Object.defineProperty(r.prototype,"names",{get:function(){return(0,c.keys)(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(r.prototype,"values",{get:function(){return(0,c.values)(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(r.prototype,"func",{get:function(){var e=(0,f.use_strict)(this.code);return new(Function.bind.apply(Function,(0,a.__spreadArray)((0,a.__spreadArray)([void 0],(0,a.__read)(this.names),!1),["source",e],!1)))},enumerable:!1,configurable:!0}),r.prototype.compute_indices=function(e){var r=e.length,n=this.func.apply(this,(0,a.__spreadArray)((0,a.__spreadArray)([],(0,a.__read)(this.values),!1),[e],!1));if(null==n)return u.Indices.all_set(r);if((0,l.isArrayOf)(n,l.isInteger))return u.Indices.from_indices(r,n);if((0,l.isArrayOf)(n,l.isBoolean))return u.Indices.from_booleans(r,n);throw new Error("expect an array of integers or booleans, or null, got "+n)},r}(s.Filter);n.CustomJSFilter=_,o=_,_.__name__="CustomJSFilter",o.define((function(e){var r=e.Unknown,n=e.String;return{args:[(0,e.Dict)(r),{}],code:[n,""]}}))},
function _(n,e,t,r,u){r();var i,o=n(1),c=n(306),l=n(139),s=n(134),a=function(n){function e(e){return n.call(this,e)||this}return(0,o.__extends)(e,n),e.prototype.compute_indices=function(n){var e=n.get_column(this.column_name);if(null==e)return s.logger.warn(this+": groupby column '"+this.column_name+"' not found in the data source"),new l.Indices(n.length,1);for(var t=new l.Indices(n.length),r=0;r<t.size;r++)e[r]===this.group&&t.set(r);return t},e}(c.Filter);t.GroupFilter=a,i=a,a.__name__="GroupFilter",i.define((function(n){var e=n.String;return{column_name:[e],group:[e]}}))},
function _(n,e,i,t,r){t();var l,c=n(1),u=n(306),s=n(139),d=function(n){function e(e){return n.call(this,e)||this}return(0,c.__extends)(e,n),e.prototype.compute_indices=function(n){var e=n.length,i=this.indices;return null==i?s.Indices.all_set(e):s.Indices.from_indices(e,i)},e}(u.Filter);i.IndexFilter=d,l=d,d.__name__="IndexFilter",l.define((function(n){var e=n.Int,i=n.Array;return{indices:[(0,n.Nullable)(i(e)),null]}}))},
function _(e,a,l,i,t){i(),t("AnnularWedge",e(383).AnnularWedge),t("Annulus",e(384).Annulus),t("Arc",e(385).Arc),t("Bezier",e(386).Bezier),t("Circle",e(387).Circle),t("Ellipse",e(388).Ellipse),t("EllipseOval",e(389).EllipseOval),t("Glyph",e(294).Glyph),t("HArea",e(302).HArea),t("HBar",e(391).HBar),t("HexTile",e(393).HexTile),t("Image",e(394).Image),t("ImageRGBA",e(396).ImageRGBA),t("ImageURL",e(397).ImageURL),t("Line",e(292).Line),t("MultiLine",e(398).MultiLine),t("MultiPolygons",e(399).MultiPolygons),t("Oval",e(400).Oval),t("Patch",e(301).Patch),t("Patches",e(401).Patches),t("Quad",e(402).Quad),t("Quadratic",e(403).Quadratic),t("Ray",e(404).Ray),t("Rect",e(405).Rect),t("Scatter",e(406).Scatter),t("Segment",e(409).Segment),t("Spline",e(410).Spline),t("Step",e(412).Step),t("Text",e(413).Text),t("VArea",e(304).VArea),t("VBar",e(414).VBar),t("Wedge",e(415).Wedge)},
function _(e,t,r,i,s){i();var a,n=e(1),o=e(293),_=e(299),u=e(163),l=e(139),d=e(135),h=(0,n.__importStar)(e(133)),c=e(117),p=e(187),y=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,n.__extends)(t,e),t.prototype._map_data=function(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this.inner_radius):this.sinner_radius=(0,l.to_screen)(this.inner_radius),"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this.outer_radius):this.souter_radius=(0,l.to_screen)(this.outer_radius)},t.prototype._render=function(e,t,r){var i,s,a=null!=r?r:this,o=a.sx,_=a.sy,u=a.start_angle,l=a.end_angle,d=a.sinner_radius,h=a.souter_radius,c="anticlock"==this.model.direction;try{for(var p=(0,n.__values)(t),y=p.next();!y.done;y=p.next()){var x=y.value,f=o[x],v=_[x],g=d[x],m=h[x],w=u.get(x),M=l.get(x);if(isFinite(f+v+g+m+w+M)){var A=M-w;e.translate(f,v),e.rotate(w),e.beginPath(),e.moveTo(m,0),e.arc(0,0,m,0,A,c),e.rotate(A),e.lineTo(g,0),e.arc(0,0,g,0,-A,!c),e.closePath(),e.rotate(-A-w),e.translate(-f,-v),this.visuals.fill.apply(e,x),this.visuals.hatch.apply(e,x),this.visuals.line.apply(e,x)}}}catch(e){i={error:e}}finally{try{y&&!y.done&&(s=p.return)&&s.call(p)}finally{if(i)throw i.error}}},t.prototype._hit_point=function(e){var t,r,i,s,a,o,_,u,l,d,h=e.sx,y=e.sy,x=this.renderer.xscale.invert(h),f=this.renderer.yscale.invert(y);if("data"==this.model.properties.outer_radius.units)_=x-this.max_outer_radius,l=x+this.max_outer_radius,u=f-this.max_outer_radius,d=f+this.max_outer_radius;else{var v=h-this.max_outer_radius,g=h+this.max_outer_radius;_=(t=(0,n.__read)(this.renderer.xscale.r_invert(v,g),2))[0],l=t[1];var m=y-this.max_outer_radius,w=y+this.max_outer_radius;u=(r=(0,n.__read)(this.renderer.yscale.r_invert(m,w),2))[0],d=r[1]}var M=[];try{for(var A=(0,n.__values)(this.index.indices({x0:_,x1:l,y0:u,y1:d})),S=A.next();!S.done;S=A.next()){var V=S.value,W=Math.pow(this.souter_radius[V],2),k=Math.pow(this.sinner_radius[V],2),D=(0,n.__read)(this.renderer.xscale.r_compute(x,this._x[V]),2),b=(v=D[0],g=D[1],(0,n.__read)(this.renderer.yscale.r_compute(f,this._y[V]),2)),F=(m=b[0],w=b[1],Math.pow(v-g,2)+Math.pow(m-w,2));F<=W&&F>=k&&M.push(V)}}catch(e){i={error:e}}finally{try{S&&!S.done&&(s=A.return)&&s.call(A)}finally{if(i)throw i.error}}var G="anticlock"==this.model.direction,P=[];try{for(var T=(0,n.__values)(M),X=T.next();!X.done;X=T.next()){V=X.value;var Y=Math.atan2(y-this.sy[V],h-this.sx[V]);(0,c.angle_between)(-Y,-this.start_angle.get(V),-this.end_angle.get(V),G)&&P.push(V)}}catch(e){a={error:e}}finally{try{X&&!X.done&&(o=T.return)&&o.call(T)}finally{if(a)throw a.error}}return new p.Selection({indices:P})},t.prototype.draw_legend_for_index=function(e,t,r){(0,_.generic_area_vector_legend)(this.visuals,e,t,r)},t.prototype.scenterxy=function(e){var t=(this.sinner_radius[e]+this.souter_radius[e])/2,r=(this.start_angle.get(e)+this.end_angle.get(e))/2;return[this.sx[e]+t*Math.cos(r),this.sy[e]+t*Math.sin(r)]},t}(o.XYGlyphView);r.AnnularWedgeView=y,y.__name__="AnnularWedgeView";var x=function(e){function t(t){return e.call(this,t)||this}return(0,n.__extends)(t,e),t}(o.XYGlyph);r.AnnularWedge=x,a=x,x.__name__="AnnularWedge",a.prototype.default_view=y,a.mixins([u.LineVector,u.FillVector,u.HatchVector]),a.define((function(e){return{direction:[d.Direction,"anticlock"],inner_radius:[h.DistanceSpec,{field:"inner_radius"}],outer_radius:[h.DistanceSpec,{field:"outer_radius"}],start_angle:[h.AngleSpec,{field:"start_angle"}],end_angle:[h.AngleSpec,{field:"end_angle"}]}}))},
function _(r,e,t,i,s){i();var a,n=r(1),u=r(293),_=r(139),o=r(163),d=(0,n.__importStar)(r(133)),h=r(142),l=r(187),c=function(r){function e(){return null!==r&&r.apply(this,arguments)||this}return(0,n.__extends)(e,r),e.prototype._map_data=function(){"data"==this.model.properties.inner_radius.units?this.sinner_radius=this.sdist(this.renderer.xscale,this._x,this.inner_radius):this.sinner_radius=(0,_.to_screen)(this.inner_radius),"data"==this.model.properties.outer_radius.units?this.souter_radius=this.sdist(this.renderer.xscale,this._x,this.outer_radius):this.souter_radius=(0,_.to_screen)(this.outer_radius)},e.prototype._render=function(r,e,t){var i,s,a,u,_=null!=t?t:this,o=_.sx,d=_.sy,l=_.sinner_radius,c=_.souter_radius;try{for(var p=(0,n.__values)(e),y=p.next();!y.done;y=p.next()){var v=y.value,x=o[v],f=d[v],m=l[v],w=c[v];if(isFinite(x+f+m+w)){if(r.beginPath(),h.is_ie)try{for(var M=(a=void 0,(0,n.__values)([!1,!0])),A=M.next();!A.done;A=M.next()){var V=A.value;r.moveTo(x,f),r.arc(x,f,m,0,Math.PI,V),r.moveTo(x+w,f),r.arc(x,f,w,Math.PI,0,!V)}}catch(r){a={error:r}}finally{try{A&&!A.done&&(u=M.return)&&u.call(M)}finally{if(a)throw a.error}}else r.arc(x,f,m,0,2*Math.PI,!0),r.moveTo(x+w,f),r.arc(x,f,w,2*Math.PI,0,!1);this.visuals.fill.apply(r,v),this.visuals.hatch.apply(r,v),this.visuals.line.apply(r,v)}}}catch(r){i={error:r}}finally{try{y&&!y.done&&(s=p.return)&&s.call(p)}finally{if(i)throw i.error}}},e.prototype._hit_point=function(r){var e,t,i,s,a,u,_,o,d=r.sx,h=r.sy,c=this.renderer.xscale.invert(d),p=this.renderer.yscale.invert(h);if("data"==this.model.properties.outer_radius.units)a=c-this.max_outer_radius,_=c+this.max_outer_radius,u=p-this.max_outer_radius,o=p+this.max_outer_radius;else{var y=d-this.max_outer_radius,v=d+this.max_outer_radius;a=(e=(0,n.__read)(this.renderer.xscale.r_invert(y,v),2))[0],_=e[1];var x=h-this.max_outer_radius,f=h+this.max_outer_radius;u=(t=(0,n.__read)(this.renderer.yscale.r_invert(x,f),2))[0],o=t[1]}var m=[];try{for(var w=(0,n.__values)(this.index.indices({x0:a,x1:_,y0:u,y1:o})),M=w.next();!M.done;M=w.next()){var A=M.value,V=Math.pow(this.souter_radius[A],2),P=Math.pow(this.sinner_radius[A],2),I=(0,n.__read)(this.renderer.xscale.r_compute(c,this._x[A]),2),S=(y=I[0],v=I[1],(0,n.__read)(this.renderer.yscale.r_compute(p,this._y[A]),2)),b=(x=S[0],f=S[1],Math.pow(y-v,2)+Math.pow(x-f,2));b<=V&&b>=P&&m.push(A)}}catch(r){i={error:r}}finally{try{M&&!M.done&&(s=w.return)&&s.call(w)}finally{if(i)throw i.error}}return new l.Selection({indices:m})},e.prototype.draw_legend_for_index=function(r,e,t){var i=e.x0,s=e.y0,a=e.x1,n=e.y1,u=t+1,_=new Array(u);_[t]=(i+a)/2;var o=new Array(u);o[t]=(s+n)/2;var d=.5*Math.min(Math.abs(a-i),Math.abs(n-s)),h=new Array(u);h[t]=.4*d;var l=new Array(u);l[t]=.8*d,this._render(r,[t],{sx:_,sy:o,sinner_radius:h,souter_radius:l})},e}(u.XYGlyphView);t.AnnulusView=c,c.__name__="AnnulusView";var p=function(r){function e(e){return r.call(this,e)||this}return(0,n.__extends)(e,r),e}(u.XYGlyph);t.Annulus=p,a=p,p.__name__="Annulus",a.prototype.default_view=c,a.mixins([o.LineVector,o.FillVector,o.HatchVector]),a.define((function(r){return{inner_radius:[d.DistanceSpec,{field:"inner_radius"}],outer_radius:[d.DistanceSpec,{field:"outer_radius"}]}}))},
function _(e,t,i,n,r){n();var s,a=e(1),l=e(293),o=e(299),_=e(163),c=e(139),d=e(135),u=(0,a.__importStar)(e(133)),h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(t,e),t.prototype._map_data=function(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this.radius):this.sradius=(0,c.to_screen)(this.radius)},t.prototype._render=function(e,t,i){var n,r;if(this.visuals.line.doit){var s=null!=i?i:this,l=s.sx,o=s.sy,_=s.sradius,c=s.start_angle,d=s.end_angle,u="anticlock"==this.model.direction;try{for(var h=(0,a.__values)(t),f=h.next();!f.done;f=h.next()){var p=f.value,g=l[p],v=o[p],y=_[p],x=c.get(p),m=d.get(p);isFinite(g+v+y+x+m)&&(e.beginPath(),e.arc(g,v,y,x,m,u),this.visuals.line.set_vectorize(e,p),e.stroke())}}catch(e){n={error:e}}finally{try{f&&!f.done&&(r=h.return)&&r.call(h)}finally{if(n)throw n.error}}}},t.prototype.draw_legend_for_index=function(e,t,i){(0,o.generic_line_vector_legend)(this.visuals,e,t,i)},t}(l.XYGlyphView);i.ArcView=h,h.__name__="ArcView";var f=function(e){function t(t){return e.call(this,t)||this}return(0,a.__extends)(t,e),t}(l.XYGlyph);i.Arc=f,s=f,f.__name__="Arc",s.prototype.default_view=h,s.mixins(_.LineVector),s.define((function(e){return{direction:[d.Direction,"anticlock"],radius:[u.DistanceSpec,{field:"radius"}],start_angle:[u.AngleSpec,{field:"start_angle"}],end_angle:[u.AngleSpec,{field:"end_angle"}]}}))},
function _(e,r,t,i,a){i();var n,o=e(1),_=e(163),c=e(294),s=e(299),d=e(193),p=(0,o.__importStar)(e(133));function l(e,r,t,i,a,n,_,c){for(var s=[],d=[[],[]],p=0;p<=2;p++){var l=void 0,y=void 0,f=void 0;if(0===p?(y=6*e-12*t+6*a,l=-3*e+9*t-9*a+3*_,f=3*t-3*e):(y=6*r-12*i+6*n,l=-3*r+9*i-9*n+3*c,f=3*i-3*r),Math.abs(l)<1e-12){if(Math.abs(y)<1e-12)continue;0<(C=-f/y)&&C<1&&s.push(C)}else{var h=y*y-4*f*l,u=Math.sqrt(h);if(!(h<0)){var v=(-y+u)/(2*l);0<v&&v<1&&s.push(v);var x=(-y-u)/(2*l);0<x&&x<1&&s.push(x)}}}for(var m=s.length,M=m;m--;){var C,S=1-(C=s[m]),w=S*S*S*e+3*S*S*C*t+3*S*C*C*a+C*C*C*_;d[0][m]=w;var z=S*S*S*r+3*S*S*C*i+3*S*C*C*n+C*C*C*c;d[1][m]=z}return d[0][M]=e,d[1][M]=r,d[0][M+1]=_,d[1][M+1]=c,[Math.min.apply(Math,(0,o.__spreadArray)([],(0,o.__read)(d[0]),!1)),Math.max.apply(Math,(0,o.__spreadArray)([],(0,o.__read)(d[1]),!1)),Math.max.apply(Math,(0,o.__spreadArray)([],(0,o.__read)(d[0]),!1)),Math.min.apply(Math,(0,o.__spreadArray)([],(0,o.__read)(d[1]),!1))]}var y=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return(0,o.__extends)(r,e),r.prototype._project_data=function(){d.inplace.project_xy(this._x0,this._y0),d.inplace.project_xy(this._x1,this._y1)},r.prototype._index_data=function(e){for(var r=this,t=r.data_size,i=r._x0,a=r._y0,n=r._x1,_=r._y1,c=r._cx0,s=r._cy0,d=r._cx1,p=r._cy1,y=0;y<t;y++){var f=i[y],h=a[y],u=n[y],v=_[y],x=c[y],m=s[y],M=d[y],C=p[y];if(isFinite(f+u+h+v+x+m+M+C)){var S=(0,o.__read)(l(f,h,u,v,x,m,M,C),4),w=S[0],z=S[1],g=S[2],b=S[3];e.add_rect(w,z,g,b)}else e.add_empty()}},r.prototype._render=function(e,r,t){var i,a;if(this.visuals.line.doit){var n=null!=t?t:this,_=n.sx0,c=n.sy0,s=n.sx1,d=n.sy1,p=n.scx0,l=n.scy0,y=n.scx1,f=n.scy1;try{for(var h=(0,o.__values)(r),u=h.next();!u.done;u=h.next()){var v=u.value,x=_[v],m=c[v],M=s[v],C=d[v],S=p[v],w=l[v],z=y[v],g=f[v];isFinite(x+m+M+C+S+w+z+g)&&(e.beginPath(),e.moveTo(x,m),e.bezierCurveTo(S,w,z,g,M,C),this.visuals.line.set_vectorize(e,v),e.stroke())}}catch(e){i={error:e}}finally{try{u&&!u.done&&(a=h.return)&&a.call(h)}finally{if(i)throw i.error}}}},r.prototype.draw_legend_for_index=function(e,r,t){(0,s.generic_line_vector_legend)(this.visuals,e,r,t)},r.prototype.scenterxy=function(){throw new Error(this+".scenterxy() is not implemented")},r}(c.GlyphView);t.BezierView=y,y.__name__="BezierView";var f=function(e){function r(r){return e.call(this,r)||this}return(0,o.__extends)(r,e),r}(c.Glyph);t.Bezier=f,n=f,f.__name__="Bezier",n.prototype.default_view=y,n.define((function(e){return{x0:[p.XCoordinateSpec,{field:"x0"}],y0:[p.YCoordinateSpec,{field:"y0"}],x1:[p.XCoordinateSpec,{field:"x1"}],y1:[p.YCoordinateSpec,{field:"y1"}],cx0:[p.XCoordinateSpec,{field:"cx0"}],cy0:[p.YCoordinateSpec,{field:"cy0"}],cx1:[p.XCoordinateSpec,{field:"cx1"}],cy1:[p.YCoordinateSpec,{field:"cy1"}]}})),n.mixins(_.LineVector)},
function _(e,r,i,t,s){t();var a,n=e(1),d=e(293),h=e(163),u=e(139),_=e(135),o=(0,n.__importStar)(e(300)),l=(0,n.__importStar)(e(133)),c=e(126),p=e(116),y=e(187),x=function(r){function i(){return null!==r&&r.apply(this,arguments)||this}return(0,n.__extends)(i,r),i.prototype.lazy_initialize=function(){return(0,n.__awaiter)(this,void 0,void 0,(function(){var i,t;return(0,n.__generator)(this,(function(s){switch(s.label){case 0:return[4,r.prototype.lazy_initialize.call(this)];case 1:return s.sent(),(null==(i=this.renderer.plot_view.canvas_view.webgl)?void 0:i.regl_wrapper.has_webgl)?[4,Promise.resolve().then((function(){return(0,n.__importStar)(e(541))}))]:[3,3];case 2:t=s.sent().MarkerGL,this.glglyph=new t(i.regl_wrapper,this,"circle"),s.label=3;case 3:return[2]}}))}))},Object.defineProperty(i.prototype,"use_radius",{get:function(){return!(this.radius.is_Scalar()&&isNaN(this.radius.value))},enumerable:!1,configurable:!0}),i.prototype._set_data=function(e){var i=this;r.prototype._set_data.call(this,e);var t=function(){if(i.use_radius)return 2*i.max_radius;var e=i.size;return e.is_Scalar()?e.value:(0,p.max)(e.array)}();this._configure("max_size",{value:t})},i.prototype._map_data=function(){if(this.use_radius)if("data"==this.model.properties.radius.units)switch(this.model.radius_dimension){case"x":this.sradius=this.sdist(this.renderer.xscale,this._x,this.radius);break;case"y":this.sradius=this.sdist(this.renderer.yscale,this._y,this.radius);break;case"max":var e=this.sdist(this.renderer.xscale,this._x,this.radius),r=this.sdist(this.renderer.yscale,this._y,this.radius);this.sradius=(0,p.map)(e,(function(e,i){return Math.max(e,r[i])}));break;case"min":e=this.sdist(this.renderer.xscale,this._x,this.radius);var i=this.sdist(this.renderer.yscale,this._y,this.radius);this.sradius=(0,p.map)(e,(function(e,r){return Math.min(e,i[r])}))}else this.sradius=(0,u.to_screen)(this.radius);else{var t=u.ScreenArray.from(this.size);this.sradius=(0,p.map)(t,(function(e){return e/2}))}},i.prototype._mask_data=function(){var e,r,i=this,t=this.renderer.plot_view.frame,s=t.x_target,a=t.y_target;return this.use_radius&&"data"==this.model.properties.radius.units?(e=s.map((function(e){return i.renderer.xscale.invert(e)})).widen(this.max_radius),r=a.map((function(e){return i.renderer.yscale.invert(e)})).widen(this.max_radius)):(e=s.widen(this.max_size).map((function(e){return i.renderer.xscale.invert(e)})),r=a.widen(this.max_size).map((function(e){return i.renderer.yscale.invert(e)}))),this.index.indices({x0:e.start,x1:e.end,y0:r.start,y1:r.end})},i.prototype._render=function(e,r,i){var t,s,a=null!=i?i:this,d=a.sx,h=a.sy,u=a.sradius;try{for(var _=(0,n.__values)(r),o=_.next();!o.done;o=_.next()){var l=o.value,c=d[l],p=h[l],y=u[l];isFinite(c+p+y)&&(e.beginPath(),e.arc(c,p,y,0,2*Math.PI,!1),this.visuals.fill.apply(e,l),this.visuals.hatch.apply(e,l),this.visuals.line.apply(e,l))}}catch(e){t={error:e}}finally{try{o&&!o.done&&(s=_.return)&&s.call(_)}finally{if(t)throw t.error}}},i.prototype._hit_point=function(e){var r,i,t,s,a,d,h,u,_,o,l=e.sx,c=e.sy,p=this.renderer.xscale.invert(l),x=this.renderer.yscale.invert(c),v=this.model.hit_dilation;if(this.use_radius&&"data"==this.model.properties.radius.units)h=p-this.max_radius*v,u=p+this.max_radius*v,_=x-this.max_radius*v,o=x+this.max_radius*v;else{var m=l-this.max_size*v,f=l+this.max_size*v;h=(r=(0,n.__read)(this.renderer.xscale.r_invert(m,f),2))[0],u=r[1];var w=c-this.max_size*v,g=c+this.max_size*v;_=(i=(0,n.__read)(this.renderer.yscale.r_invert(w,g),2))[0],o=i[1]}var z=this.index.indices({x0:h,x1:u,y0:_,y1:o}),b=[];if(this.use_radius&&"data"==this.model.properties.radius.units)try{for(var S=(0,n.__values)(z),M=S.next();!M.done;M=S.next()){var A=M.value,V=Math.pow(this.sradius[A]*v,2),k=(0,n.__read)(this.renderer.xscale.r_compute(p,this._x[A]),2),C=(m=k[0],f=k[1],(0,n.__read)(this.renderer.yscale.r_compute(x,this._y[A]),2));w=C[0],g=C[1];Math.pow(m-f,2)+Math.pow(w-g,2)<=V&&b.push(A)}}catch(e){t={error:e}}finally{try{M&&!M.done&&(s=S.return)&&s.call(S)}finally{if(t)throw t.error}}else try{for(var N=(0,n.__values)(z),P=N.next();!P.done;P=N.next()){A=P.value,V=Math.pow(this.sradius[A]*v,2);Math.pow(this.sx[A]-l,2)+Math.pow(this.sy[A]-c,2)<=V&&b.push(A)}}catch(e){a={error:e}}finally{try{P&&!P.done&&(d=N.return)&&d.call(N)}finally{if(a)throw a.error}}return new y.Selection({indices:b})},i.prototype._hit_span=function(e){var r,i,t,s,a,d,h,u,_=e.sx,o=e.sy,l=this.bounds();if("h"==e.direction){var c=void 0,p=void 0;if(h=l.y0,u=l.y1,this.use_radius&&"data"==this.model.properties.radius.units)c=_-this.max_radius,p=_+this.max_radius,a=(r=(0,n.__read)(this.renderer.xscale.r_invert(c,p),2))[0],d=r[1];else c=_-(x=this.max_size/2),p=_+x,a=(i=(0,n.__read)(this.renderer.xscale.r_invert(c,p),2))[0],d=i[1]}else{var x,v=void 0,m=void 0;if(a=l.x0,d=l.x1,this.use_radius&&"data"==this.model.properties.radius.units)v=o-this.max_radius,m=o+this.max_radius,h=(t=(0,n.__read)(this.renderer.yscale.r_invert(v,m),2))[0],u=t[1];else v=o-(x=this.max_size/2),m=o+x,h=(s=(0,n.__read)(this.renderer.yscale.r_invert(v,m),2))[0],u=s[1]}var f=(0,n.__spreadArray)([],(0,n.__read)(this.index.indices({x0:a,x1:d,y0:h,y1:u})),!1);return new y.Selection({indices:f})},i.prototype._hit_rect=function(e){var r=e.sx0,i=e.sx1,t=e.sy0,s=e.sy1,a=(0,n.__read)(this.renderer.xscale.r_invert(r,i),2),d=a[0],h=a[1],u=(0,n.__read)(this.renderer.yscale.r_invert(t,s),2),_=u[0],o=u[1],l=(0,n.__spreadArray)([],(0,n.__read)(this.index.indices({x0:d,x1:h,y0:_,y1:o})),!1);return new y.Selection({indices:l})},i.prototype._hit_poly=function(e){for(var r=e.sx,i=e.sy,t=(0,c.range)(0,this.sx.length),s=[],a=0,n=t.length;a<n;a++){var d=t[a];o.point_in_poly(this.sx[a],this.sy[a],r,i)&&s.push(d)}return new y.Selection({indices:s})},i.prototype.draw_legend_for_index=function(e,r,i){var t=r.x0,s=r.y0,a=r.x1,n=r.y1,d=i+1,h=new Array(d);h[i]=(t+a)/2;var u=new Array(d);u[i]=(s+n)/2;var _=new Array(d);_[i]=.2*Math.min(Math.abs(a-t),Math.abs(n-s)),this._render(e,[i],{sx:h,sy:u,sradius:_})},i}(d.XYGlyphView);i.CircleView=x,x.__name__="CircleView";var v=function(e){function r(r){return e.call(this,r)||this}return(0,n.__extends)(r,e),r}(d.XYGlyph);i.Circle=v,a=v,v.__name__="Circle",a.prototype.default_view=x,a.mixins([h.LineVector,h.FillVector,h.HatchVector]),a.define((function(e){var r=e.Number;return{angle:[l.AngleSpec,0],size:[l.ScreenSizeSpec,{value:4}],radius:[l.NullDistanceSpec,null],radius_dimension:[_.RadiusDimension,"x"],hit_dilation:[r,1]}}))},
function _(e,l,i,n,t){n();var _,s=e(1),r=e(389),u=function(e){function l(){return null!==e&&e.apply(this,arguments)||this}return(0,s.__extends)(l,e),l}(r.EllipseOvalView);i.EllipseView=u,u.__name__="EllipseView";var p=function(e){function l(l){return e.call(this,l)||this}return(0,s.__extends)(l,e),l}(r.EllipseOval);i.Ellipse=p,_=p,p.__name__="Ellipse",_.prototype.default_view=u},
function _(t,e,i,r,s){r();var a=t(1),h=t(390),n=(0,a.__importStar)(t(300)),l=t(139),_=t(187),o=(0,a.__importStar)(t(133)),d=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,a.__extends)(e,t),e.prototype._map_data=function(){"data"==this.model.properties.width.units?this.sw=this.sdist(this.renderer.xscale,this._x,this.width,"center"):this.sw=(0,l.to_screen)(this.width),"data"==this.model.properties.height.units?this.sh=this.sdist(this.renderer.yscale,this._y,this.height,"center"):this.sh=(0,l.to_screen)(this.height)},e.prototype._render=function(t,e,i){var r,s,h=null!=i?i:this,n=h.sx,l=h.sy,_=h.sw,o=h.sh,d=h.angle;try{for(var p=(0,a.__values)(e),y=p.next();!y.done;y=p.next()){var c=y.value,u=n[c],v=l[c],x=_[c],w=o[c],f=d.get(c);isFinite(u+v+x+w+f)&&(t.beginPath(),t.ellipse(u,v,x/2,w/2,f,0,2*Math.PI),this.visuals.fill.apply(t,c),this.visuals.hatch.apply(t,c),this.visuals.line.apply(t,c))}}catch(t){r={error:t}}finally{try{y&&!y.done&&(s=p.return)&&s.call(p)}finally{if(r)throw r.error}}},e.prototype._hit_point=function(t){var e,i,r,s,h,l,o,d,p,y,c,u,v=t.sx,x=t.sy,w=this.renderer.xscale.invert(v),f=this.renderer.yscale.invert(x);"data"==this.model.properties.width.units?(h=w-this.max_width,l=w+this.max_width):(p=v-this.max_width,y=v+this.max_width,h=(e=(0,a.__read)(this.renderer.xscale.r_invert(p,y),2))[0],l=e[1]),"data"==this.model.properties.height.units?(o=f-this.max_height,d=f+this.max_height):(c=x-this.max_height,u=x+this.max_height,o=(i=(0,a.__read)(this.renderer.yscale.r_invert(c,u),2))[0],d=i[1]);var m=this.index.indices({x0:h,x1:l,y0:o,y1:d}),g=[];try{for(var b=(0,a.__values)(m),A=b.next();!A.done;A=b.next()){var E=A.value;n.point_in_ellipse(v,x,this.angle.get(E),this.sh[E]/2,this.sw[E]/2,this.sx[E],this.sy[E])&&g.push(E)}}catch(t){r={error:t}}finally{try{A&&!A.done&&(s=b.return)&&s.call(b)}finally{if(r)throw r.error}}return new _.Selection({indices:g})},e.prototype.draw_legend_for_index=function(t,e,i){var r=e.x0,s=e.y0,a=e.x1,h=e.y1,n=i+1,l=new Array(n);l[i]=(r+a)/2;var _=new Array(n);_[i]=(s+h)/2;var d=this.sw[i]/this.sh[i],p=.8*Math.min(Math.abs(a-r),Math.abs(h-s)),y=new Array(n),c=new Array(n);d>1?(y[i]=p,c[i]=p/d):(y[i]=p*d,c[i]=p);var u=new o.UniformScalar(0,n);this._render(t,[i],{sx:l,sy:_,sw:y,sh:c,angle:u})},e}(h.CenterRotatableView);i.EllipseOvalView=d,d.__name__="EllipseOvalView";var p=function(t){function e(e){return t.call(this,e)||this}return(0,a.__extends)(e,t),e}(h.CenterRotatable);i.EllipseOval=p,p.__name__="EllipseOval"},
function _(e,t,n,i,r){i();var a,o=e(1),h=e(293),u=e(163),c=(0,o.__importStar)(e(133)),l=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,o.__extends)(t,e),Object.defineProperty(t.prototype,"max_w2",{get:function(){return"data"==this.model.properties.width.units?this.max_width/2:0},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"max_h2",{get:function(){return"data"==this.model.properties.height.units?this.max_height/2:0},enumerable:!1,configurable:!0}),t.prototype._bounds=function(e){var t=e.x0,n=e.x1,i=e.y0,r=e.y1,a=this.max_w2,o=this.max_h2;return{x0:t-a,x1:n+a,y0:i-o,y1:r+o}},t}(h.XYGlyphView);n.CenterRotatableView=l,l.__name__="CenterRotatableView";var _=function(e){function t(t){return e.call(this,t)||this}return(0,o.__extends)(t,e),t}(h.XYGlyph);n.CenterRotatable=_,a=_,_.__name__="CenterRotatable",a.mixins([u.LineVector,u.FillVector,u.HatchVector]),a.define((function(e){return{angle:[c.AngleSpec,0],width:[c.DistanceSpec,{field:"width"}],height:[c.DistanceSpec,{field:"height"}]}}))},
function _(t,e,i,r,s){r();var h,n=t(1),o=t(392),a=t(139),_=(0,n.__importStar)(t(133)),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,n.__extends)(e,t),e.prototype.scenterxy=function(t){return[(this.sleft[t]+this.sright[t])/2,this.sy[t]]},e.prototype._lrtb=function(t){var e=this._left[t],i=this._right[t],r=this._y[t],s=this.height.get(t)/2;return[Math.min(e,i),Math.max(e,i),r+s,r-s]},e.prototype._map_data=function(){this.sy=this.renderer.yscale.v_compute(this._y),this.sh=this.sdist(this.renderer.yscale,this._y,this.height,"center"),this.sleft=this.renderer.xscale.v_compute(this._left),this.sright=this.renderer.xscale.v_compute(this._right);var t=this.sy.length;this.stop=new a.ScreenArray(t),this.sbottom=new a.ScreenArray(t);for(var e=0;e<t;e++)this.stop[e]=this.sy[e]-this.sh[e]/2,this.sbottom[e]=this.sy[e]+this.sh[e]/2;this._clamp_viewport()},e}(o.BoxView);i.HBarView=c,c.__name__="HBarView";var u=function(t){function e(e){return t.call(this,e)||this}return(0,n.__extends)(e,t),e}(o.Box);i.HBar=u,h=u,u.__name__="HBar",h.prototype.default_view=c,h.define((function(t){return{left:[_.XCoordinateSpec,{value:0}],y:[_.YCoordinateSpec,{field:"y"}],height:[_.NumberSpec,{value:1}],right:[_.XCoordinateSpec,{field:"right"}]}}))},
function _(t,e,r,i,n){i();var s,a=t(1),o=t(163),h=t(294),_=t(299),c=t(187),l=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,a.__extends)(e,t),e.prototype.get_anchor_point=function(t,e,r){var i=Math.min(this.sleft[e],this.sright[e]),n=Math.max(this.sright[e],this.sleft[e]),s=Math.min(this.stop[e],this.sbottom[e]),a=Math.max(this.sbottom[e],this.stop[e]);switch(t){case"top_left":return{x:i,y:s};case"top":case"top_center":return{x:(i+n)/2,y:s};case"top_right":return{x:n,y:s};case"bottom_left":return{x:i,y:a};case"bottom":case"bottom_center":return{x:(i+n)/2,y:a};case"bottom_right":return{x:n,y:a};case"left":case"center_left":return{x:i,y:(s+a)/2};case"center":case"center_center":return{x:(i+n)/2,y:(s+a)/2};case"right":case"center_right":return{x:n,y:(s+a)/2}}},e.prototype._index_data=function(t){for(var e=Math.min,r=Math.max,i=this.data_size,n=0;n<i;n++){var s=(0,a.__read)(this._lrtb(n),4),o=s[0],h=s[1],_=s[2],c=s[3];t.add_rect(e(o,h),e(_,c),r(h,o),r(_,c))}},e.prototype._render=function(t,e,r){var i,n,s=null!=r?r:this,o=s.sleft,h=s.sright,_=s.stop,c=s.sbottom;try{for(var l=(0,a.__values)(e),p=l.next();!p.done;p=l.next()){var d=p.value,x=o[d],y=_[d],u=h[d],f=c[d];isFinite(x+y+u+f)&&(t.beginPath(),t.rect(x,y,u-x,f-y),this.visuals.fill.apply(t,d),this.visuals.hatch.apply(t,d),this.visuals.line.apply(t,d))}}catch(t){i={error:t}}finally{try{p&&!p.done&&(n=l.return)&&n.call(l)}finally{if(i)throw i.error}}},e.prototype._clamp_viewport=function(){for(var t=this.renderer.plot_view.frame.bbox.h_range,e=this.renderer.plot_view.frame.bbox.v_range,r=this.stop.length,i=0;i<r;i++)this.stop[i]=Math.max(this.stop[i],e.start),this.sbottom[i]=Math.min(this.sbottom[i],e.end),this.sleft[i]=Math.max(this.sleft[i],t.start),this.sright[i]=Math.min(this.sright[i],t.end)},e.prototype._hit_rect=function(t){return this._hit_rect_against_index(t)},e.prototype._hit_point=function(t){var e=t.sx,r=t.sy,i=this.renderer.xscale.invert(e),n=this.renderer.yscale.invert(r),s=(0,a.__spreadArray)([],(0,a.__read)(this.index.indices({x0:i,y0:n,x1:i,y1:n})),!1);return new c.Selection({indices:s})},e.prototype._hit_span=function(t){var e,r=t.sx,i=t.sy;if("v"==t.direction){var n=this.renderer.yscale.invert(i),s=this.renderer.plot_view.frame.bbox.h_range,o=(0,a.__read)(this.renderer.xscale.r_invert(s.start,s.end),2),h=o[0],_=o[1];e=(0,a.__spreadArray)([],(0,a.__read)(this.index.indices({x0:h,y0:n,x1:_,y1:n})),!1)}else{var l=this.renderer.xscale.invert(r),p=this.renderer.plot_view.frame.bbox.v_range,d=(0,a.__read)(this.renderer.yscale.r_invert(p.start,p.end),2),x=d[0],y=d[1];e=(0,a.__spreadArray)([],(0,a.__read)(this.index.indices({x0:l,y0:x,x1:l,y1:y})),!1)}return new c.Selection({indices:e})},e.prototype.draw_legend_for_index=function(t,e,r){(0,_.generic_area_vector_legend)(this.visuals,t,e,r)},e}(h.GlyphView);r.BoxView=l,l.__name__="BoxView";var p=function(t){function e(e){return t.call(this,e)||this}return(0,a.__extends)(e,t),e}(h.Glyph);r.Box=p,s=p,p.__name__="Box",s.mixins([o.LineVector,o.FillVector,o.HatchVector])},
function _(e,t,r,i,s){i();var n,a=e(1),o=e(294),_=(0,a.__importStar)(e(300)),l=(0,a.__importStar)(e(133)),c=e(163),h=e(135),d=e(193),p=e(299),y=e(187),u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(t,e),t.prototype.scenterxy=function(e){return[this.sx[e],this.sy[e]]},t.prototype._set_data=function(){var e=this.model,t=e.orientation,r=e.size,i=e.aspect_scale,s=this.q,n=this.r,a=this.q.length;this._x=new Float64Array(a),this._y=new Float64Array(a);var o=this._x,_=this._y,l=Math.sqrt(3);if("pointytop"==t)for(var c=0;c<a;c++){var h=s.get(c),d=n.get(c)/2;o[c]=r*l*(h+d)/i,_[c]=-3*r*d}else for(c=0;c<a;c++){var p=s.get(c)/2,y=n.get(c);o[c]=3*r*p,_[c]=-r*l*(y+p)*i}},t.prototype._project_data=function(){d.inplace.project_xy(this._x,this._y)},t.prototype._index_data=function(e){var t,r=this.model.size,i=Math.sqrt(3)*r/2;"flattop"==this.model.orientation?(i=(t=(0,a.__read)([r,i],2))[0],r=t[1],r*=this.model.aspect_scale):i/=this.model.aspect_scale;for(var s=this.data_size,n=0;n<s;n++){var o=this._x[n],_=this._y[n];e.add_rect(o-i,_-r,o+i,_+r)}},t.prototype.map_data=function(){var e,t;e=(0,a.__read)(this.renderer.coordinates.map_to_screen(this._x,this._y),2),this.sx=e[0],this.sy=e[1],t=(0,a.__read)(this._get_unscaled_vertices(),2),this.svx=t[0],this.svy=t[1]},t.prototype._get_unscaled_vertices=function(){var e=this.model.size,t=this.model.aspect_scale;if("pointytop"==this.model.orientation){var r=this.renderer.yscale,i=this.renderer.xscale,s=Math.abs(r.compute(0)-r.compute(e));return[[0,-(n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))/t),-n,0,n,n],[s,a=s/2,-a,-s,-a,a]]}var n,a;r=this.renderer.xscale,i=this.renderer.yscale;return[[s=Math.abs(r.compute(0)-r.compute(e)),a=s/2,-a,-s,-a,a],[0,-(n=Math.sqrt(3)/2*Math.abs(i.compute(0)-i.compute(e))*t),-n,0,n,n]]},t.prototype._render=function(e,t,r){var i,s,n=null!=r?r:this,o=n.sx,_=n.sy,l=n.svx,c=n.svy,h=n.scale;try{for(var d=(0,a.__values)(t),p=d.next();!p.done;p=d.next()){var y=p.value,u=o[y],v=_[y],x=h.get(y);if(isFinite(u+v+x)){e.translate(u,v),e.beginPath();for(var f=0;f<6;f++)e.lineTo(l[f]*x,c[f]*x);e.closePath(),e.translate(-u,-v),this.visuals.fill.apply(e,y),this.visuals.hatch.apply(e,y),this.visuals.line.apply(e,y)}}}catch(e){i={error:e}}finally{try{p&&!p.done&&(s=d.return)&&s.call(d)}finally{if(i)throw i.error}}},t.prototype._hit_point=function(e){var t,r,i=e.sx,s=e.sy,n=this.renderer.xscale.invert(i),o=this.renderer.yscale.invert(s),l=this.index.indices({x0:n,y0:o,x1:n,y1:o}),c=[];try{for(var h=(0,a.__values)(l),d=h.next();!d.done;d=h.next()){var p=d.value;_.point_in_poly(i-this.sx[p],s-this.sy[p],this.svx,this.svy)&&c.push(p)}}catch(e){t={error:e}}finally{try{d&&!d.done&&(r=h.return)&&r.call(h)}finally{if(t)throw t.error}}return new y.Selection({indices:c})},t.prototype._hit_span=function(e){var t,r=e.sx,i=e.sy;if("v"==e.direction){var s=this.renderer.yscale.invert(i),n=this.renderer.plot_view.frame.bbox.h_range,o=(0,a.__read)(this.renderer.xscale.r_invert(n.start,n.end),2),_=o[0],l=o[1];t=(0,a.__spreadArray)([],(0,a.__read)(this.index.indices({x0:_,y0:s,x1:l,y1:s})),!1)}else{var c=this.renderer.xscale.invert(r),h=this.renderer.plot_view.frame.bbox.v_range,d=(0,a.__read)(this.renderer.yscale.r_invert(h.start,h.end),2),p=d[0],u=d[1];t=(0,a.__spreadArray)([],(0,a.__read)(this.index.indices({x0:c,y0:p,x1:c,y1:u})),!1)}return new y.Selection({indices:t})},t.prototype._hit_rect=function(e){var t=e.sx0,r=e.sx1,i=e.sy0,s=e.sy1,n=(0,a.__read)(this.renderer.xscale.r_invert(t,r),2),o=n[0],_=n[1],l=(0,a.__read)(this.renderer.yscale.r_invert(i,s),2),c=l[0],h=l[1],d=(0,a.__spreadArray)([],(0,a.__read)(this.index.indices({x0:o,x1:_,y0:c,y1:h})),!1);return new y.Selection({indices:d})},t.prototype.draw_legend_for_index=function(e,t,r){(0,p.generic_area_vector_legend)(this.visuals,e,t,r)},t}(o.GlyphView);r.HexTileView=u,u.__name__="HexTileView";var v=function(e){function t(t){return e.call(this,t)||this}return(0,a.__extends)(t,e),t}(o.Glyph);r.HexTile=v,n=v,v.__name__="HexTile",n.prototype.default_view=u,n.mixins([c.LineVector,c.FillVector,c.HatchVector]),n.define((function(e){var t=e.Number;return{r:[l.NumberSpec,{field:"r"}],q:[l.NumberSpec,{field:"q"}],scale:[l.NumberSpec,1],size:[t,1],aspect_scale:[t,1],orientation:[h.HexTileOrientation,"pointytop"]}})),n.override({line_color:null})},
function _(e,t,n,r,a){r();var o,i=e(1),_=e(395),p=e(288),u=e(316),f=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,i.__extends)(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.color_mapper.change,(function(){return t._update_image()}))},t.prototype._update_image=function(){null!=this.image_data&&(this._set_data(null),this.renderer.request_render())},t.prototype._flat_img_to_buf8=function(e){return this.model.color_mapper.rgba_mapper.v_compute(e)},t}(_.ImageBaseView);n.ImageView=f,f.__name__="ImageView";var c=function(e){function t(t){return e.call(this,t)||this}return(0,i.__extends)(t,e),t}(_.ImageBase);n.Image=c,o=c,c.__name__="Image",o.prototype.default_view=f,o.define((function(e){return{color_mapper:[(0,e.Ref)(p.ColorMapper),function(){return new u.LinearColorMapper({palette:["#000000","#252525","#525252","#737373","#969696","#bdbdbd","#d9d9d9","#f0f0f0","#ffffff"]})}]}}))},
function _(e,t,i,a,r){a();var s,h=e(1),n=e(293),_=e(139),l=(0,h.__importStar)(e(133)),d=e(187),o=e(126),g=e(144),c=e(127),u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,h.__extends)(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.global_alpha.change,(function(){return t.renderer.request_render()}))},t.prototype._render=function(e,t,i){var a,r,s=null!=i?i:this,n=s.image_data,_=s.sx,l=s.sy,d=s.sw,o=s.sh,g=s.global_alpha,c=e.getImageSmoothingEnabled();e.setImageSmoothingEnabled(!1);var u=g.is_Scalar();u&&(e.globalAlpha=g.value);try{for(var m=(0,h.__values)(t),p=m.next();!p.done;p=m.next()){var f=p.value,y=n[f],v=_[f],w=l[f],x=d[f],b=o[f],I=this.global_alpha.get(f);if(null!=y&&isFinite(v+w+x+b+I)){u||(e.globalAlpha=I);var S=w;e.translate(0,S),e.scale(1,-1),e.translate(0,-S),e.drawImage(y,0|v,0|w,x,b),e.translate(0,S),e.scale(1,-1),e.translate(0,-S)}}}catch(e){a={error:e}}finally{try{p&&!p.done&&(r=m.return)&&r.call(m)}finally{if(a)throw a.error}}e.setImageSmoothingEnabled(c)},t.prototype._set_data=function(e){this._set_width_heigh_data();for(var t=0,i=this.image.length;t<i;t++)if(!(null!=e&&e.indexOf(t)<0)){var a=this.image.get(t),r=void 0;(0,g.is_NDArray)(a)?((0,c.assert)(2==a.dimension,"expected a 2D array"),r=a,this._height[t]=a.shape[0],this._width[t]=a.shape[1]):(r=(0,o.concat)(a),this._height[t]=a.length,this._width[t]=a[0].length);var s=this._flat_img_to_buf8(r);this._set_image_data_from_buffer(t,s)}},t.prototype._index_data=function(e){for(var t=this.data_size,i=0;i<t;i++){var a=(0,h.__read)(this._lrtb(i),4),r=a[0],s=a[1],n=a[2],_=a[3];e.add_rect(r,_,s,n)}},t.prototype._lrtb=function(e){var t=this.dw.get(e),i=this.dh.get(e),a=this.renderer.xscale.source_range,r=this._x[e],s=a.is_reversed?r-t:r+t,n=this.renderer.yscale.source_range,_=this._y[e],l=n.is_reversed?_-i:_+i,d=(0,h.__read)(r<s?[r,s]:[s,r],2),o=d[0],g=d[1],c=(0,h.__read)(_<l?[_,l]:[l,_],2),u=c[0];return[o,g,c[1],u]},t.prototype._set_width_heigh_data=function(){null!=this.image_data&&this.image_data.length==this.image.length||(this.image_data=new Array(this.image.length)),null!=this._width&&this._width.length==this.image.length||(this._width=new Uint32Array(this.image.length)),null!=this._height&&this._height.length==this.image.length||(this._height=new Uint32Array(this.image.length))},t.prototype._get_or_create_canvas=function(e){var t=this.image_data[e];if(null!=t&&t.width==this._width[e]&&t.height==this._height[e])return t;var i=document.createElement("canvas");return i.width=this._width[e],i.height=this._height[e],i},t.prototype._set_image_data_from_buffer=function(e,t){var i=this._get_or_create_canvas(e),a=i.getContext("2d"),r=a.getImageData(0,0,this._width[e],this._height[e]);r.data.set(t),a.putImageData(r,0,0),this.image_data[e]=i},t.prototype._map_data=function(){"data"==this.model.properties.dw.units?this.sw=this.sdist(this.renderer.xscale,this._x,this.dw,"edge",this.model.dilate):this.sw=(0,_.to_screen)(this.dw),"data"==this.model.properties.dh.units?this.sh=this.sdist(this.renderer.yscale,this._y,this.dh,"edge",this.model.dilate):this.sh=(0,_.to_screen)(this.dh)},t.prototype._image_index=function(e,t,i){var a=(0,h.__read)(this._lrtb(e),4),r=a[0],s=a[1],n=a[2],_=a[3],l=this._width[e],d=this._height[e],o=(s-r)/l,g=(n-_)/d,c=Math.floor((t-r)/o),u=Math.floor((i-_)/g);return this.renderer.xscale.source_range.is_reversed&&(c=l-c-1),this.renderer.yscale.source_range.is_reversed&&(u=d-u-1),{index:e,dim1:c,dim2:u,flat_index:u*l+c}},t.prototype._hit_point=function(e){var t,i,a=e.sx,r=e.sy,s=this.renderer.xscale.invert(a),n=this.renderer.yscale.invert(r),_=this.index.indices({x0:s,x1:s,y0:n,y1:n}),l=new d.Selection;try{for(var o=(0,h.__values)(_),g=o.next();!g.done;g=o.next()){var c=g.value;a!=1/0&&r!=1/0&&l.image_indices.push(this._image_index(c,s,n))}}catch(e){t={error:e}}finally{try{g&&!g.done&&(i=o.return)&&i.call(o)}finally{if(t)throw t.error}}return l},t}(n.XYGlyphView);i.ImageBaseView=u,u.__name__="ImageBaseView";var m=function(e){function t(t){return e.call(this,t)||this}return(0,h.__extends)(t,e),t}(n.XYGlyph);i.ImageBase=m,s=m,m.__name__="ImageBase",s.define((function(e){var t=e.Boolean;return{image:[l.NDArraySpec,{field:"image"}],dw:[l.DistanceSpec,{field:"dw"}],dh:[l.DistanceSpec,{field:"dh"}],global_alpha:[l.NumberSpec,{value:1}],dilate:[t,!1]}}))},
function _(e,n,t,r,a){r();var i,_=e(1),u=e(395),f=e(125),o=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,_.__extends)(n,e),n.prototype._flat_img_to_buf8=function(e){var n;return n=(0,f.isArray)(e)?new Uint32Array(e):e,new Uint8ClampedArray(n.buffer)},n}(u.ImageBaseView);t.ImageRGBAView=o,o.__name__="ImageRGBAView";var m=function(e){function n(n){return e.call(this,n)||this}return(0,_.__extends)(n,e),n}(u.ImageBase);t.ImageRGBA=m,i=m,m.__name__="ImageRGBA",i.prototype.default_view=o},
function _(e,t,r,a,n){a();var s,i=e(1),o=e(293),_=e(139),c=e(135),h=(0,i.__importStar)(e(133)),l=e(116),d=e(251),u=function(e){function t(){var t=e.apply(this,(0,i.__spreadArray)([],(0,i.__read)(arguments),!1))||this;return t._images_rendered=!1,t._set_data_iteration=0,t}return(0,i.__extends)(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.global_alpha.change,(function(){return t.renderer.request_render()}))},t.prototype._index_data=function(e){for(var t=this.data_size,r=0;r<t;r++)e.add_empty()},t.prototype._set_data=function(){var e,t,r=this;this._set_data_iteration++;var a=this.url.length;this.image=new Array(a);for(var n=this.model,s=n.retry_attempts,o=n.retry_timeout,c=this._set_data_iteration,h=function(e){var t=u.url.get(e);if(!t)return"continue";new d.ImageLoader(t,{loaded:function(t){r._set_data_iteration==c&&(r.image[e]=t,r.renderer.request_render())},attempts:s+1,timeout:o})},u=this,p=0;p<a;p++)h(p);var f="data"==this.model.properties.w.units,m="data"==this.model.properties.h.units,g=this._x.length,y=new _.ScreenArray(f?2*g:g),b=new _.ScreenArray(m?2*g:g),w=this.model.anchor;function v(e,t){switch(w){case"top_left":case"bottom_left":case"left":case"center_left":return[e,e+t];case"top":case"top_center":case"bottom":case"bottom_center":case"center":case"center_center":return[e-t/2,e+t/2];case"top_right":case"bottom_right":case"right":case"center_right":return[e-t,e]}}function x(e,t){switch(w){case"top_left":case"top":case"top_center":case"top_right":return[e,e-t];case"bottom_left":case"bottom":case"bottom_center":case"bottom_right":return[e+t,e];case"left":case"center_left":case"center":case"center_center":case"right":case"center_right":return[e+t/2,e-t/2]}}if(f)for(p=0;p<g;p++)e=(0,i.__read)(v(this._x[p],this.w.get(p)),2),y[p]=e[0],y[g+p]=e[1];else y.set(this._x,0);if(m)for(p=0;p<g;p++)t=(0,i.__read)(x(this._y[p],this.h.get(p)),2),b[p]=t[0],b[g+p]=t[1];else b.set(this._y,0);var S=(0,i.__read)((0,l.minmax)(y),2),I=S[0],A=S[1],L=(0,i.__read)((0,l.minmax)(b),2),R=L[0],U=L[1];this._bounds_rect={x0:I,x1:A,y0:R,y1:U}},t.prototype.has_finished=function(){return e.prototype.has_finished.call(this)&&1==this._images_rendered},t.prototype._map_data=function(){"data"==this.model.properties.w.units?this.sw=this.sdist(this.renderer.xscale,this._x,this.w,"edge",this.model.dilate):this.sw=(0,_.to_screen)(this.w),"data"==this.model.properties.h.units?this.sh=this.sdist(this.renderer.yscale,this._y,this.h,"edge",this.model.dilate):this.sh=(0,_.to_screen)(this.h)},t.prototype._render=function(e,t,r){var a,n,s=null!=r?r:this,o=s.image,_=s.sx,c=s.sy,h=s.sw,l=s.sh,d=s.angle,u=s.global_alpha,p=this.renderer.plot_view.frame;e.beginPath(),e.rect(p.bbox.left+1,p.bbox.top+1,p.bbox.width-2,p.bbox.height-2),e.clip();var f=!0;try{for(var m=(0,i.__values)(t),g=m.next();!g.done;g=m.next()){var y=g.value;if(isFinite(_[y]+c[y]+d.get(y)+u.get(y))){var b=o[y];null!=b?this._render_image(e,y,b,_,c,h,l,d,u):f=!1}}}catch(e){a={error:e}}finally{try{g&&!g.done&&(n=m.return)&&n.call(m)}finally{if(a)throw a.error}}f&&!this._images_rendered&&(this._images_rendered=!0,this.notify_finished())},t.prototype._final_sx_sy=function(e,t,r,a,n){switch(e){case"top_left":return[t,r];case"top":case"top_center":return[t-a/2,r];case"top_right":return[t-a,r];case"right":case"center_right":return[t-a,r-n/2];case"bottom_right":return[t-a,r-n];case"bottom":case"bottom_center":return[t-a/2,r-n];case"bottom_left":return[t,r-n];case"left":case"center_left":return[t,r-n/2];case"center":case"center_center":return[t-a/2,r-n/2]}},t.prototype._render_image=function(e,t,r,a,n,s,o,_,c){isFinite(s[t])||(s[t]=r.width),isFinite(o[t])||(o[t]=r.height);var h=s[t],l=o[t],d=this.model.anchor,u=(0,i.__read)(this._final_sx_sy(d,a[t],n[t],h,l),2),p=u[0],f=u[1],m=_.get(t),g=c.get(t);e.save(),e.globalAlpha=g;var y=h/2,b=l/2;m?(e.translate(p,f),e.translate(y,b),e.rotate(m),e.translate(-y,-b),e.drawImage(r,0,0,h,l),e.translate(y,b),e.rotate(-m),e.translate(-y,-b),e.translate(-p,-f)):e.drawImage(r,p,f,h,l),e.restore()},t.prototype.bounds=function(){return this._bounds_rect},t}(o.XYGlyphView);r.ImageURLView=u,u.__name__="ImageURLView";var p=function(e){function t(t){return e.call(this,t)||this}return(0,i.__extends)(t,e),t}(o.XYGlyph);r.ImageURL=p,s=p,p.__name__="ImageURL",s.prototype.default_view=u,s.define((function(e){var t=e.Boolean,r=e.Int;return{url:[h.StringSpec,{field:"url"}],anchor:[c.Anchor,"top_left"],global_alpha:[h.NumberSpec,{value:1}],angle:[h.AngleSpec,0],w:[h.NullDistanceSpec,null],h:[h.NullDistanceSpec,null],dilate:[t,!1],retry_attempts:[r,0],retry_timeout:[r,0]}}))},
function _(e,t,n,i,r){i();var s,o=e(1),_=e(193),a=e(163),l=(0,o.__importStar)(e(300)),h=(0,o.__importStar)(e(133)),c=e(116),p=e(128),u=e(294),y=e(299),d=e(187),f=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,o.__extends)(t,e),t.prototype._project_data=function(){_.inplace.project_xy(this._xs.array,this._ys.array)},t.prototype._index_data=function(e){for(var t=this.data_size,n=0;n<t;n++){var i=this._xs.get(n),r=this._ys.get(n),s=(0,o.__read)((0,c.minmax2)(i,r),4),_=s[0],a=s[1],l=s[2],h=s[3];e.add_rect(_,l,a,h)}},t.prototype._render=function(e,t,n){var i,r,s=null!=n?n:this,_=s.sxs,a=s.sys;try{for(var l=(0,o.__values)(t),h=l.next();!h.done;h=l.next()){var c=h.value,p=_.get(c),u=a.get(c),y=Math.min(p.length,u.length),d=!0;e.beginPath();for(var f=0;f<y;f++){var v=p[f],x=u[f];isFinite(v+x)?d?(e.moveTo(v,x),d=!1):e.lineTo(v,x):d=!0}this.visuals.line.set_vectorize(e,c),e.stroke()}}catch(e){i={error:e}}finally{try{h&&!h.done&&(r=l.return)&&r.call(l)}finally{if(i)throw i.error}}},t.prototype._hit_point=function(e){for(var t={x:e.sx,y:e.sy},n=9999,i=new Map,r=0,s=this.sxs.length;r<s;r++){for(var _=Math.max(2,this.line_width.get(r)/2),a=this.sxs.get(r),h=this.sys.get(r),c=null,u=0,y=a.length-1;u<y;u++){var f={x:a[u],y:h[u]},v={x:a[u+1],y:h[u+1]},x=l.dist_to_segment(t,f,v);x<_&&x<n&&(n=x,c=[u])}null!=c&&i.set(r,c)}return new d.Selection({indices:(0,o.__spreadArray)([],(0,o.__read)(i.keys()),!1),multiline_indices:(0,p.to_object)(i)})},t.prototype._hit_span=function(e){var t,n,i=e.sx,r=e.sy;"v"==e.direction?(t=this.renderer.yscale.invert(r),n=this._ys):(t=this.renderer.xscale.invert(i),n=this._xs);for(var s=new Map,_=0,a=n.length;_<a;_++){for(var l=n.get(_),h=[],c=0,u=l.length-1;c<u;c++)l[c]<=t&&t<=l[c+1]&&h.push(c);h.length>0&&s.set(_,h)}return new d.Selection({indices:(0,o.__spreadArray)([],(0,o.__read)(s.keys()),!1),multiline_indices:(0,p.to_object)(s)})},t.prototype.get_interpolation_hit=function(e,t,n){var i=this._xs.get(e),r=this._ys.get(e),s=i[t],o=r[t],_=i[t+1],a=r[t+1];return(0,y.line_interpolation)(this.renderer,n,s,o,_,a)},t.prototype.draw_legend_for_index=function(e,t,n){(0,y.generic_line_vector_legend)(this.visuals,e,t,n)},t.prototype.scenterxy=function(){throw new Error(this+".scenterxy() is not implemented")},t}(u.GlyphView);n.MultiLineView=f,f.__name__="MultiLineView";var v=function(e){function t(t){return e.call(this,t)||this}return(0,o.__extends)(t,e),t}(u.Glyph);n.MultiLine=v,s=v,v.__name__="MultiLine",s.prototype.default_view=f,s.define((function(e){return{xs:[h.XCoordinateSeqSpec,{field:"xs"}],ys:[h.YCoordinateSeqSpec,{field:"ys"}]}})),s.mixins(a.LineVector)},
function _(e,t,r,n,i){n();var s,a=e(1),o=e(296),h=e(294),l=e(299),_=e(116),d=e(116),y=e(163),f=(0,a.__importStar)(e(300)),p=(0,a.__importStar)(e(133)),v=e(187),c=e(127),x=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(t,e),t.prototype._project_data=function(){},t.prototype._index_data=function(e){for(var t=Math.min,r=Math.max,n=this.data_size,i=0;i<n;i++){var s=this._xs[i],o=this._ys[i];if(0!=s.length&&0!=o.length){for(var h=1/0,l=-1/0,d=1/0,y=-1/0,f=0,p=s.length;f<p;f++){var v=s[f][0],c=o[f][0];if(0!=v.length&&0!=c.length){var x=(0,a.__read)((0,_.minmax)(v),2),u=x[0],g=x[1],m=(0,a.__read)((0,_.minmax)(c),2),w=m[0],S=m[1];h=t(h,u),l=r(l,g),d=t(d,w),y=r(y,S)}}e.add_rect(h,d,l,y)}else e.add_empty()}this._hole_index=this._index_hole_data()},t.prototype._index_hole_data=function(){for(var e=Math.min,t=Math.max,r=this.data_size,n=new o.SpatialIndex(r),i=0;i<r;i++){var s=this._xs[i],h=this._ys[i];if(0!=s.length&&0!=h.length){for(var l=1/0,d=-1/0,y=1/0,f=-1/0,p=0,v=s.length;p<v;p++){var c=s[p],x=h[p];if(c.length>1&&x.length>1)for(var u=1,g=c.length;u<g;u++){var m=(0,a.__read)((0,_.minmax)(c[u]),2),w=m[0],S=m[1],M=(0,a.__read)((0,_.minmax)(x[u]),2),q=M[0],A=M[1];l=e(l,w),d=t(d,S),y=e(y,q),f=t(f,A)}}n.add_rect(l,y,d,f)}else n.add_empty()}return n.finish(),n},t.prototype._mask_data=function(){var e=this.renderer.plot_view.frame,t=e.x_range,r=e.y_range;return this.index.indices({x0:t.min,x1:t.max,y0:r.min,y1:r.max})},t.prototype._render=function(e,t,r){var n,i;if(this.visuals.fill.doit||this.visuals.line.doit){var s=null!=r?r:this,o=s.sxs,h=s.sys;try{for(var l=(0,a.__values)(t),_=l.next();!_.done;_=l.next()){var d=_.value;e.beginPath();for(var y=o[d],f=h[d],p=Math.min(y.length,f.length),v=0;v<p;v++)for(var c=y[v],x=f[v],u=Math.min(c.length,x.length),g=0;g<u;g++){for(var m=c[g],w=x[g],S=Math.min(m.length,w.length),M=0;M<S;M++){var q=m[M],A=w[M];0==M?e.moveTo(q,A):e.lineTo(q,A)}e.closePath()}this.visuals.fill.apply(e,d,"evenodd"),this.visuals.hatch.apply(e,d,"evenodd"),this.visuals.line.apply(e,d)}}catch(e){n={error:e}}finally{try{_&&!_.done&&(i=l.return)&&i.call(l)}finally{if(n)throw n.error}}}},t.prototype._hit_rect=function(e){var t,r,n=e.sx0,i=e.sx1,s=e.sy0,o=e.sy1,h=[n,i,i,n],l=[s,s,o,o],_=(0,a.__read)(this.renderer.xscale.r_invert(n,i),2),d=_[0],y=_[1],p=(0,a.__read)(this.renderer.yscale.r_invert(s,o),2),c=p[0],x=p[1],u=this.index.indices({x0:d,x1:y,y0:c,y1:x}),g=[];try{for(var m=(0,a.__values)(u),w=m.next();!w.done;w=m.next()){for(var S=w.value,M=this.sxs[S],q=this.sys[S],A=!0,P=0,V=M.length;P<V;P++){for(var b=0,k=M[P][0].length;b<k;b++){var z=M[P][0][b],C=q[P][0][b];if(!f.point_in_poly(z,C,h,l)){A=!1;break}}if(!A)break}A&&g.push(S)}}catch(e){t={error:e}}finally{try{w&&!w.done&&(r=m.return)&&r.call(m)}finally{if(t)throw t.error}}return new v.Selection({indices:g})},t.prototype._hit_point=function(e){var t,r,n=e.sx,i=e.sy,s=this.renderer.xscale.invert(n),o=this.renderer.yscale.invert(i),h=this.index.indices({x0:s,y0:o,x1:s,y1:o}),l=this._hole_index.indices({x0:s,y0:o,x1:s,y1:o}),_=[];try{for(var d=(0,a.__values)(h),y=d.next();!y.done;y=d.next())for(var p=y.value,c=this.sxs[p],x=this.sys[p],u=0,g=c.length;u<g;u++){var m=c[u].length;if(f.point_in_poly(n,i,c[u][0],x[u][0]))if(1==m)_.push(p);else if(l.get(p)){if(m>1){for(var w=!1,S=1;S<m;S++){var M=c[u][S],q=x[u][S];if(f.point_in_poly(n,i,M,q)){w=!0;break}}w||_.push(p)}}else _.push(p)}}catch(e){t={error:e}}finally{try{y&&!y.done&&(r=d.return)&&r.call(d)}finally{if(t)throw t.error}}return new v.Selection({indices:_})},t.prototype._get_snap_coord=function(e){return(0,d.sum)(e)/e.length},t.prototype.scenterxy=function(e,t,r){if(1==this.sxs[e].length)return[this._get_snap_coord(this.sxs[e][0][0]),this._get_snap_coord(this.sys[e][0][0])];for(var n=this.sxs[e],i=this.sys[e],s=0,a=n.length;s<a;s++){if(f.point_in_poly(t,r,n[s][0],i[s][0]))return[this._get_snap_coord(n[s][0]),this._get_snap_coord(i[s][0])]}(0,c.unreachable)()},t.prototype.map_data=function(){var e=this._xs.length;this.sxs=new Array(e),this.sys=new Array(e);for(var t=0;t<e;t++){var r=this._xs[t].length;this.sxs[t]=new Array(r),this.sys[t]=new Array(r);for(var n=0;n<r;n++){var i=this._xs[t][n].length;this.sxs[t][n]=new Array(i),this.sys[t][n]=new Array(i);for(var s=0;s<i;s++){var o=(0,a.__read)(this.renderer.coordinates.map_to_screen(this._xs[t][n][s],this._ys[t][n][s]),2),h=o[0],l=o[1];this.sxs[t][n][s]=h,this.sys[t][n][s]=l}}}},t.prototype.draw_legend_for_index=function(e,t,r){(0,l.generic_area_vector_legend)(this.visuals,e,t,r)},t}(h.GlyphView);r.MultiPolygonsView=x,x.__name__="MultiPolygonsView";var u=function(e){function t(t){return e.call(this,t)||this}return(0,a.__extends)(t,e),t}(h.Glyph);r.MultiPolygons=u,s=u,u.__name__="MultiPolygons",s.prototype.default_view=x,s.define((function(e){return{xs:[p.XCoordinateSeqSeqSeqSpec,{field:"xs"}],ys:[p.YCoordinateSeqSeqSeqSpec,{field:"ys"}]}})),s.mixins([y.LineVector,y.FillVector,y.HatchVector])},
function _(t,n,a,e,l){e();var i,_=t(1),r=t(389),u=t(116),o=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,_.__extends)(n,t),n.prototype._map_data=function(){t.prototype._map_data.call(this),(0,u.mul)(this.sw,.75)},n}(r.EllipseOvalView);a.OvalView=o,o.__name__="OvalView";var p=function(t){function n(n){return t.call(this,n)||this}return(0,_.__extends)(n,t),n}(r.EllipseOval);a.Oval=p,i=p,p.__name__="Oval",i.prototype.default_view=o},
function _(e,t,r,n,i){n();var a,s=e(1),o=e(294),_=e(299),l=e(116),c=e(163),h=(0,s.__importStar)(e(300)),y=(0,s.__importStar)(e(133)),p=e(187),u=e(127),d=e(193),f=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,s.__extends)(t,e),t.prototype._project_data=function(){d.inplace.project_xy(this._xs.array,this._ys.array)},t.prototype._index_data=function(e){for(var t=this.data_size,r=0;r<t;r++){var n=this._xs.get(r),i=this._ys.get(r),a=(0,s.__read)((0,l.minmax2)(n,i),4),o=a[0],_=a[1],c=a[2],h=a[3];e.add_rect(o,c,_,h)}},t.prototype._mask_data=function(){var e=this.renderer.plot_view.frame,t=e.x_range,r=e.y_range;return this.index.indices({x0:t.min,x1:t.max,y0:r.min,y1:r.max})},t.prototype._render=function(e,t,r){var n,i,a=null!=r?r:this,o=a.sxs,_=a.sys;try{for(var l=(0,s.__values)(t),c=l.next();!c.done;c=l.next()){var h=c.value,y=o.get(h),p=_.get(h),u=!0;e.beginPath();for(var d=Math.min(y.length,p.length),f=0;f<d;f++){var v=y[f],x=p[f];isFinite(v+x)?u?(e.moveTo(v,x),u=!1):e.lineTo(v,x):(e.closePath(),u=!0)}e.closePath(),this.visuals.fill.apply(e,h),this.visuals.hatch.apply(e,h),this.visuals.line.apply(e,h)}}catch(e){n={error:e}}finally{try{c&&!c.done&&(i=l.return)&&i.call(l)}finally{if(n)throw n.error}}},t.prototype._hit_rect=function(e){var t,r,n=e.sx0,i=e.sx1,a=e.sy0,o=e.sy1,_=[n,i,i,n],l=[a,a,o,o],c=(0,s.__read)(this.renderer.xscale.r_invert(n,i),2),y=c[0],u=c[1],d=(0,s.__read)(this.renderer.yscale.r_invert(a,o),2),f=d[0],v=d[1],x=this.index.indices({x0:y,x1:u,y0:f,y1:v}),g=[];try{for(var m=(0,s.__values)(x),w=m.next();!w.done;w=m.next()){for(var b=w.value,S=this.sxs.get(b),P=this.sys.get(b),V=!0,k=0,N=S.length;k<N;k++){var j=S[k],q=P[k];if(!h.point_in_poly(j,q,_,l)){V=!1;break}}V&&g.push(b)}}catch(e){t={error:e}}finally{try{w&&!w.done&&(r=m.return)&&r.call(m)}finally{if(t)throw t.error}}return new p.Selection({indices:g})},t.prototype._hit_point=function(e){var t,r,n=e.sx,i=e.sy,a=this.renderer.xscale.invert(n),o=this.renderer.yscale.invert(i),_=this.index.indices({x0:a,y0:o,x1:a,y1:o}),l=[];try{for(var c=(0,s.__values)(_),y=c.next();!y.done;y=c.next())for(var u=y.value,d=this.sxs.get(u),f=this.sys.get(u),v=d.length,x=0,g=0;;g++){if(isNaN(d[g])||g==v){var m=d.subarray(x,g),w=f.subarray(x,g);if(h.point_in_poly(n,i,m,w)){l.push(u);break}x=g+1}if(g==v)break}}catch(e){t={error:e}}finally{try{y&&!y.done&&(r=c.return)&&r.call(c)}finally{if(t)throw t.error}}return new p.Selection({indices:l})},t.prototype._get_snap_coord=function(e){return(0,l.sum)(e)/e.length},t.prototype.scenterxy=function(e,t,r){for(var n=this.sxs.get(e),i=this.sys.get(e),a=n.length,s=!1,o=0,_=0;;_++){var l=isNaN(n[_]);if(s=s||l,_==a&&!s)return[this._get_snap_coord(n),this._get_snap_coord(i)];if(l||_==a){var c=n.subarray(o,_),y=i.subarray(o,_);if(h.point_in_poly(t,r,c,y))return[this._get_snap_coord(c),this._get_snap_coord(y)];o=_+1}if(_==a)break}(0,u.unreachable)()},t.prototype.draw_legend_for_index=function(e,t,r){(0,_.generic_area_vector_legend)(this.visuals,e,t,r)},t}(o.GlyphView);r.PatchesView=f,f.__name__="PatchesView";var v=function(e){function t(t){return e.call(this,t)||this}return(0,s.__extends)(t,e),t}(o.Glyph);r.Patches=v,a=v,v.__name__="Patches",a.prototype.default_view=f,a.define((function(e){return{xs:[y.XCoordinateSeqSpec,{field:"xs"}],ys:[y.YCoordinateSeqSpec,{field:"ys"}]}})),a.mixins([c.LineVector,c.FillVector,c.HatchVector])},
function _(t,e,i,o,n){o();var r,u=t(1),_=t(392),s=(0,u.__importStar)(t(133)),f=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,u.__extends)(e,t),e.prototype.scenterxy=function(t){return[this.sleft[t]/2+this.sright[t]/2,this.stop[t]/2+this.sbottom[t]/2]},e.prototype._lrtb=function(t){return[this._left[t],this._right[t],this._top[t],this._bottom[t]]},e}(_.BoxView);i.QuadView=f,f.__name__="QuadView";var p=function(t){function e(e){return t.call(this,e)||this}return(0,u.__extends)(e,t),e}(_.Box);i.Quad=p,r=p,p.__name__="Quad",r.prototype.default_view=f,r.define((function(t){return{right:[s.XCoordinateSpec,{field:"right"}],bottom:[s.YCoordinateSpec,{field:"bottom"}],left:[s.XCoordinateSpec,{field:"left"}],top:[s.YCoordinateSpec,{field:"top"}]}}))},
function _(e,t,i,r,n){r();var a,o=e(1),_=e(163),c=e(193),d=e(294),s=e(299),l=(0,o.__importStar)(e(133));function u(e,t,i){if(t==(e+i)/2)return[e,i];var r=(e-t)/(e-2*t+i),n=e*Math.pow(1-r,2)+2*t*(1-r)*r+i*Math.pow(r,2);return[Math.min(e,i,n),Math.max(e,i,n)]}var p=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,o.__extends)(t,e),t.prototype._project_data=function(){c.inplace.project_xy(this._x0,this._y0),c.inplace.project_xy(this._x1,this._y1)},t.prototype._index_data=function(e){for(var t=this,i=t._x0,r=t._x1,n=t._y0,a=t._y1,_=t._cx,c=t._cy,d=t.data_size,s=0;s<d;s++){var l=i[s],p=r[s],y=n[s],f=a[s],x=_[s],h=c[s];if(isFinite(l+p+y+f+x+h)){var v=(0,o.__read)(u(l,x,p),2),m=v[0],w=v[1],C=(0,o.__read)(u(y,h,f),2),S=C[0],g=C[1];e.add_rect(m,S,w,g)}else e.add_empty()}},t.prototype._render=function(e,t,i){var r,n;if(this.visuals.line.doit){var a=null!=i?i:this,_=a.sx0,c=a.sy0,d=a.sx1,s=a.sy1,l=a.scx,u=a.scy;try{for(var p=(0,o.__values)(t),y=p.next();!y.done;y=p.next()){var f=y.value,x=_[f],h=c[f],v=d[f],m=s[f],w=l[f],C=u[f];isFinite(x+h+v+m+w+C)&&(e.beginPath(),e.moveTo(x,h),e.quadraticCurveTo(w,C,v,m),this.visuals.line.set_vectorize(e,f),e.stroke())}}catch(e){r={error:e}}finally{try{y&&!y.done&&(n=p.return)&&n.call(p)}finally{if(r)throw r.error}}}},t.prototype.draw_legend_for_index=function(e,t,i){(0,s.generic_line_vector_legend)(this.visuals,e,t,i)},t.prototype.scenterxy=function(){throw new Error(this+".scenterxy() is not implemented")},t}(d.GlyphView);i.QuadraticView=p,p.__name__="QuadraticView";var y=function(e){function t(t){return e.call(this,t)||this}return(0,o.__extends)(t,e),t}(d.Glyph);i.Quadratic=y,a=y,y.__name__="Quadratic",a.prototype.default_view=p,a.define((function(e){return{x0:[l.XCoordinateSpec,{field:"x0"}],y0:[l.YCoordinateSpec,{field:"y0"}],x1:[l.XCoordinateSpec,{field:"x1"}],y1:[l.YCoordinateSpec,{field:"y1"}],cx:[l.XCoordinateSpec,{field:"cx"}],cy:[l.YCoordinateSpec,{field:"cy"}]}})),a.mixins(_.LineVector)},
function _(e,t,n,i,r){i();var s,l=e(1),a=e(293),o=e(299),h=e(163),_=e(139),u=(0,l.__importStar)(e(133)),c=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,l.__extends)(t,e),t.prototype._map_data=function(){"data"==this.model.properties.length.units?this.slength=this.sdist(this.renderer.xscale,this._x,this.length):this.slength=(0,_.to_screen)(this.length);for(var e=this.renderer.plot_view.frame.bbox,t=2*(e.width+e.height),n=this.slength,i=0,r=n.length;i<r;i++)0==n[i]&&(n[i]=t)},t.prototype._render=function(e,t,n){var i,r,s=null!=n?n:this,a=s.sx,o=s.sy,h=s.slength,_=s.angle;if(this.visuals.line.doit)try{for(var u=(0,l.__values)(t),c=u.next();!c.done;c=u.next()){var d=c.value,f=a[d],p=o[d],g=_.get(d),v=h[d];isFinite(f+p+g+v)&&(e.translate(f,p),e.rotate(g),e.beginPath(),e.moveTo(0,0),e.lineTo(v,0),this.visuals.line.set_vectorize(e,d),e.stroke(),e.rotate(-g),e.translate(-f,-p))}}catch(e){i={error:e}}finally{try{c&&!c.done&&(r=u.return)&&r.call(u)}finally{if(i)throw i.error}}},t.prototype.draw_legend_for_index=function(e,t,n){(0,o.generic_line_vector_legend)(this.visuals,e,t,n)},t}(a.XYGlyphView);n.RayView=c,c.__name__="RayView";var d=function(e){function t(t){return e.call(this,t)||this}return(0,l.__extends)(t,e),t}(a.XYGlyph);n.Ray=d,s=d,d.__name__="Ray",s.prototype.default_view=c,s.mixins(h.LineVector),s.define((function(e){return{length:[u.DistanceSpec,0],angle:[u.AngleSpec,0]}}))},
function _(t,e,s,i,r){i();var n,a=t(1),h=t(390),o=t(299),l=t(139),_=t(116),c=t(187),d=function(e){function s(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(s,e),s.prototype.lazy_initialize=function(){return(0,a.__awaiter)(this,void 0,void 0,(function(){var s,i;return(0,a.__generator)(this,(function(r){switch(r.label){case 0:return[4,e.prototype.lazy_initialize.call(this)];case 1:return r.sent(),(null==(s=this.renderer.plot_view.canvas_view.webgl)?void 0:s.regl_wrapper.has_webgl)?[4,Promise.resolve().then((function(){return(0,a.__importStar)(t(540))}))]:[3,3];case 2:i=r.sent().RectGL,this.glglyph=new i(s.regl_wrapper,this),r.label=3;case 3:return[2]}}))}))},s.prototype._map_data=function(){var t,e;if("data"==this.model.properties.width.units)t=(0,a.__read)(this._map_dist_corner_for_data_side_length(this._x,this.width,this.renderer.xscale),2),this.sw=t[0],this.sx0=t[1];else{this.sw=(0,l.to_screen)(this.width);var s=this.sx.length;this.sx0=new l.ScreenArray(s);for(var i=0;i<s;i++)this.sx0[i]=this.sx[i]-this.sw[i]/2}if("data"==this.model.properties.height.units)e=(0,a.__read)(this._map_dist_corner_for_data_side_length(this._y,this.height,this.renderer.yscale),2),this.sh=e[0],this.sy1=e[1];else{this.sh=(0,l.to_screen)(this.height);var r=this.sy.length;this.sy1=new l.ScreenArray(r);for(i=0;i<r;i++)this.sy1[i]=this.sy[i]-this.sh[i]/2}var n=this.sw.length;this.ssemi_diag=new l.ScreenArray(n);for(i=0;i<n;i++)this.ssemi_diag[i]=Math.sqrt(this.sw[i]/2*this.sw[i]/2+this.sh[i]/2*this.sh[i]/2)},s.prototype._render=function(t,e,s){var i,r,n=null!=s?s:this,h=n.sx,o=n.sy,l=n.sx0,_=n.sy1,c=n.sw,d=n.sh,y=n.angle;try{for(var u=(0,a.__values)(e),v=u.next();!v.done;v=u.next()){var p=v.value,f=h[p],w=o[p],g=l[p],x=_[p],m=c[p],b=d[p],A=y.get(p);isFinite(f+w+g+x+m+b+A)&&(0!=m&&0!=b&&(t.beginPath(),A?(t.translate(f,w),t.rotate(A),t.rect(-m/2,-b/2,m,b),t.rotate(-A),t.translate(-f,-w)):t.rect(g,x,m,b),this.visuals.fill.apply(t,p),this.visuals.hatch.apply(t,p),this.visuals.line.apply(t,p)))}}catch(t){i={error:t}}finally{try{v&&!v.done&&(r=u.return)&&r.call(u)}finally{if(i)throw i.error}}},s.prototype._hit_rect=function(t){return this._hit_rect_against_index(t)},s.prototype._hit_point=function(t){for(var e,s,i=t.sx,r=t.sy,n=this.renderer.xscale.invert(i),h=this.renderer.yscale.invert(r),o=this.sx0.length,d=new l.ScreenArray(o),y=0;y<o;y++)d[y]=this.sx0[y]+this.sw[y]/2;var u=new l.ScreenArray(o);for(y=0;y<o;y++)u[y]=this.sy1[y]+this.sh[y]/2;var v,p,f=(0,_.max)(this._ddist(0,d,this.ssemi_diag)),w=(0,_.max)(this._ddist(1,u,this.ssemi_diag)),g=n-f,x=n+f,m=h-w,b=h+w,A=[];try{for(var R=(0,a.__values)(this.index.indices({x0:g,x1:x,y0:m,y1:b})),S=R.next();!S.done;S=R.next()){y=S.value;var M=this.angle.get(y);if(M){var z=Math.sin(-M),F=Math.cos(-M),V=F*(i-this.sx[y])-z*(r-this.sy[y])+this.sx[y],C=z*(i-this.sx[y])+F*(r-this.sy[y])+this.sy[y];i=V,r=C,v=Math.abs(this.sx[y]-i)<=this.sw[y]/2,p=Math.abs(this.sy[y]-r)<=this.sh[y]/2}else{var N=i-this.sx0[y],P=r-this.sy1[y];v=0<=N&&N<=this.sw[y],p=0<=P&&P<=this.sh[y]}v&&p&&A.push(y)}}catch(t){e={error:t}}finally{try{S&&!S.done&&(s=R.return)&&s.call(R)}finally{if(e)throw e.error}}return new c.Selection({indices:A})},s.prototype._map_dist_corner_for_data_side_length=function(t,e,s){for(var i=t.length,r=new Float64Array(i),n=new Float64Array(i),a=0;a<i;a++){var h=t[a],o=e.get(a)/2;r[a]=h-o,n[a]=h+o}var l=s.v_compute(r),_=s.v_compute(n),c=this.sdist(s,r,e,"edge",this.model.dilate),d=l;for(a=0;a<i;a++){var y=l[a],u=_[a];if(!isNaN(y+u)&&y!=u){d=y<u?l:_;break}}return[c,d]},s.prototype._ddist=function(t,e,s){for(var i=(0,l.infer_type)(e,s),r=0==t?this.renderer.xscale:this.renderer.yscale,n=e,a=n.length,h=new i(a),o=0;o<a;o++)h[o]=n[o]+s[o];var _=r.v_invert(n),c=r.v_invert(h),d=_.length,y=new i(d);for(o=0;o<d;o++)y[o]=Math.abs(c[o]-_[o]);return y},s.prototype.draw_legend_for_index=function(t,e,s){(0,o.generic_area_vector_legend)(this.visuals,t,e,s)},s}(h.CenterRotatableView);s.RectView=d,d.__name__="RectView";var y=function(t){function e(e){return t.call(this,e)||this}return(0,a.__extends)(e,t),e}(h.CenterRotatable);s.Rect=y,n=y,y.__name__="Rect",n.prototype.default_view=d,n.define((function(t){return{dilate:[t.Boolean,!1]}}))},
function _(e,r,t,i,n){i();var a,l=e(1),s=e(407),_=e(408),o=(0,l.__importStar)(e(133)),u=function(r){function t(){return null!==r&&r.apply(this,arguments)||this}return(0,l.__extends)(t,r),t.prototype.lazy_initialize=function(){return(0,l.__awaiter)(this,void 0,void 0,(function(){var t,i;return(0,l.__generator)(this,(function(n){switch(n.label){case 0:return[4,r.prototype.lazy_initialize.call(this)];case 1:return n.sent(),(null==(t=this.renderer.plot_view.canvas_view.webgl)?void 0:t.regl_wrapper.has_webgl)?[4,Promise.resolve().then((function(){return(0,l.__importStar)(e(541))}))]:[3,3];case 2:i=n.sent().MarkerGL,this.glcls=i,n.label=3;case 3:return[2]}}))}))},t.prototype._init_webgl=function(){var e=this.renderer.plot_view.canvas_view.webgl;if(null!=e){var r=e.regl_wrapper;if(r.has_webgl){var t=new Set(null!=this.base?this.base.marker:this.marker);if(1==t.size){var i=(0,l.__read)((0,l.__spreadArray)([],(0,l.__read)(t),!1),1)[0],n=this.glcls;if(null==n?void 0:n.is_supported(i)){var a=this.glglyph;if(null==a||a.marker_type!=i)return void(this.glglyph=new n(r,this,i))}}}}delete this.glglyph},t.prototype._set_visuals=function(){this._init_webgl()},t.prototype._render=function(e,r,t){var i,n,a=null!=t?t:this,s=a.sx,o=a.sy,u=a.size,c=a.angle,h=a.marker;try{for(var p=(0,l.__values)(r),v=p.next();!v.done;v=p.next()){var f=v.value,g=s[f],d=o[f],y=u.get(f),w=c.get(f),m=h.get(f);if(isFinite(g+d+y+w)&&null!=m){var k=y/2;e.beginPath(),e.translate(g,d),w&&e.rotate(w),_.marker_funcs[m](e,f,k,this.visuals),w&&e.rotate(-w),e.translate(-g,-d)}}}catch(e){i={error:e}}finally{try{v&&!v.done&&(n=p.return)&&n.call(p)}finally{if(i)throw i.error}}},t.prototype.draw_legend_for_index=function(e,r,t){var i=r.x0,n=r.x1,a=r.y0,s=r.y1,_=t+1,u=this.marker.get(t),c=(0,l.__assign)((0,l.__assign)({},this._get_legend_args({x0:i,x1:n,y0:a,y1:s},t)),{marker:new o.UniformScalar(u,_)});this._render(e,[t],c)},t}(s.MarkerView);t.ScatterView=u,u.__name__="ScatterView";var c=function(e){function r(r){return e.call(this,r)||this}return(0,l.__extends)(r,e),r}(s.Marker);t.Scatter=c,a=c,c.__name__="Scatter",a.prototype.default_view=u,a.define((function(){return{marker:[o.MarkerSpec,{value:"circle"}]}}))},
function _(e,r,t,n,i){n();var a,s=e(1),_=e(293),o=e(163),l=(0,s.__importStar)(e(300)),h=(0,s.__importStar)(e(133)),d=e(126),y=e(187),c=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return(0,s.__extends)(r,e),r.prototype._render=function(e,r,t){var n,i,a=null!=t?t:this,_=a.sx,o=a.sy,l=a.size,h=a.angle;try{for(var d=(0,s.__values)(r),y=d.next();!y.done;y=d.next()){var c=y.value,x=_[c],u=o[c],p=l.get(c),v=h.get(c);if(isFinite(x+u+p+v)){var f=p/2;e.beginPath(),e.translate(x,u),v&&e.rotate(v),this._render_one(e,c,f,this.visuals),v&&e.rotate(-v),e.translate(-x,-u)}}}catch(e){n={error:e}}finally{try{y&&!y.done&&(i=d.return)&&i.call(d)}finally{if(n)throw n.error}}},r.prototype._mask_data=function(){var e=this,r=this.renderer.plot_view.frame,t=r.x_target,n=r.y_target,i=t.widen(this.max_size).map((function(r){return e.renderer.xscale.invert(r)})),a=n.widen(this.max_size).map((function(r){return e.renderer.yscale.invert(r)}));return this.index.indices({x0:i.start,x1:i.end,y0:a.start,y1:a.end})},r.prototype._hit_point=function(e){var r,t,n=e.sx,i=e.sy,a=this.max_size,_=this.model.hit_dilation,o=n-a*_,l=n+a*_,h=(0,s.__read)(this.renderer.xscale.r_invert(o,l),2),d=h[0],c=h[1],x=i-a*_,u=i+a*_,p=(0,s.__read)(this.renderer.yscale.r_invert(x,u),2),v=p[0],f=p[1],g=this.index.indices({x0:d,x1:c,y0:v,y1:f}),m=[];try{for(var w=(0,s.__values)(g),S=w.next();!S.done;S=w.next()){var z=S.value,M=this.size.get(z)/2*_;Math.abs(this.sx[z]-n)<=M&&Math.abs(this.sy[z]-i)<=M&&m.push(z)}}catch(e){r={error:e}}finally{try{S&&!S.done&&(t=w.return)&&t.call(w)}finally{if(r)throw r.error}}return new y.Selection({indices:m})},r.prototype._hit_span=function(e){var r,t,n,i,a,_,o=e.sx,l=e.sy,h=this.bounds(),d=this.max_size/2;if("h"==e.direction){a=h.y0,_=h.y1;var c=o-d,x=o+d;n=(r=(0,s.__read)(this.renderer.xscale.r_invert(c,x),2))[0],i=r[1]}else{n=h.x0,i=h.x1;var u=l-d,p=l+d;a=(t=(0,s.__read)(this.renderer.yscale.r_invert(u,p),2))[0],_=t[1]}var v=(0,s.__spreadArray)([],(0,s.__read)(this.index.indices({x0:n,x1:i,y0:a,y1:_})),!1);return new y.Selection({indices:v})},r.prototype._hit_rect=function(e){var r=e.sx0,t=e.sx1,n=e.sy0,i=e.sy1,a=(0,s.__read)(this.renderer.xscale.r_invert(r,t),2),_=a[0],o=a[1],l=(0,s.__read)(this.renderer.yscale.r_invert(n,i),2),h=l[0],d=l[1],c=(0,s.__spreadArray)([],(0,s.__read)(this.index.indices({x0:_,x1:o,y0:h,y1:d})),!1);return new y.Selection({indices:c})},r.prototype._hit_poly=function(e){for(var r=e.sx,t=e.sy,n=(0,d.range)(0,this.sx.length),i=[],a=0,s=n.length;a<s;a++){var _=n[a];l.point_in_poly(this.sx[a],this.sy[a],r,t)&&i.push(_)}return new y.Selection({indices:i})},r.prototype._get_legend_args=function(e,r){var t=e.x0,n=e.x1,i=e.y0,a=e.y1,s=r+1,_=new Array(s),o=new Array(s);_[r]=(t+n)/2,o[r]=(i+a)/2;var l=.4*Math.min(Math.abs(n-t),Math.abs(a-i));return{sx:_,sy:o,size:new h.UniformScalar(l,s),angle:new h.UniformScalar(0,s)}},r.prototype.draw_legend_for_index=function(e,r,t){var n=r.x0,i=r.x1,a=r.y0,s=r.y1,_=this._get_legend_args({x0:n,x1:i,y0:a,y1:s},t);this._render(e,[t],_)},r}(_.XYGlyphView);t.MarkerView=c,c.__name__="MarkerView";var x=function(e){function r(r){return e.call(this,r)||this}return(0,s.__extends)(r,e),r}(_.XYGlyph);t.Marker=x,a=x,x.__name__="Marker",a.mixins([o.LineVector,o.FillVector,o.HatchVector]),a.define((function(e){var r=e.Number;return{size:[h.ScreenSizeSpec,{value:4}],angle:[h.AngleSpec,0],hit_dilation:[r,1]}}))},
function _(l,i,o,n,e){n();var t=Math.sqrt(3),a=Math.sqrt(5),c=(a+1)/4,p=Math.sqrt((5-a)/8),r=(a-1)/4,h=Math.sqrt((5+a)/8);function u(l,i){l.rotate(Math.PI/4),T(l,i),l.rotate(-Math.PI/4)}function f(l,i){var o=i*t,n=o/3;l.moveTo(-o/2,-n),l.lineTo(0,0),l.lineTo(o/2,-n),l.lineTo(0,0),l.lineTo(0,i)}function T(l,i){l.moveTo(0,i),l.lineTo(0,-i),l.moveTo(-i,0),l.lineTo(i,0)}function y(l,i){l.moveTo(0,i),l.lineTo(i/1.5,0),l.lineTo(0,-i),l.lineTo(-i/1.5,0),l.closePath()}function s(l,i){var o=i*t,n=o/3;l.moveTo(-i,n),l.lineTo(i,n),l.lineTo(0,n-o),l.closePath()}function v(l,i,o,n){l.arc(0,0,o,0,2*Math.PI,!1),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.apply(l,i)}function d(l,i,o,n){y(l,o),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.apply(l,i)}function _(l,i,o,n){!function(l,i){l.beginPath(),l.arc(0,0,i/4,0,2*Math.PI,!1),l.closePath()}(l,o),n.line.set_vectorize(l,i),l.fillStyle=l.strokeStyle,l.fill()}function P(l,i,o,n){!function(l,i){var o=i/2,n=t*o;l.moveTo(i,0),l.lineTo(o,-n),l.lineTo(-o,-n),l.lineTo(-i,0),l.lineTo(-o,n),l.lineTo(o,n),l.closePath()}(l,o),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.apply(l,i)}function m(l,i,o,n){var e=2*o;l.rect(-o,-o,e,e),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.apply(l,i)}function q(l,i,o,n){!function(l,i){var o=Math.sqrt(5-2*a)*i;l.moveTo(0,-i),l.lineTo(o*r,o*h-i),l.lineTo(o*(1+r),o*h-i),l.lineTo(o*(1+r-c),o*(h+p)-i),l.lineTo(o*(1+2*r-c),o*(2*h+p)-i),l.lineTo(0,2*o*h-i),l.lineTo(-o*(1+2*r-c),o*(2*h+p)-i),l.lineTo(-o*(1+r-c),o*(h+p)-i),l.lineTo(-o*(1+r),o*h-i),l.lineTo(-o*r,o*h-i),l.closePath()}(l,o),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.apply(l,i)}function M(l,i,o,n){s(l,o),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.apply(l,i)}o.marker_funcs={asterisk:function(l,i,o,n){T(l,o),u(l,o),n.line.apply(l,i)},circle:v,circle_cross:function(l,i,o,n){l.arc(0,0,o,0,2*Math.PI,!1),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.doit&&(n.line.set_vectorize(l,i),T(l,o),l.stroke())},circle_dot:function(l,i,o,n){v(l,i,o,n),_(l,i,o,n)},circle_y:function(l,i,o,n){l.arc(0,0,o,0,2*Math.PI,!1),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.doit&&(n.line.set_vectorize(l,i),f(l,o),l.stroke())},circle_x:function(l,i,o,n){l.arc(0,0,o,0,2*Math.PI,!1),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.doit&&(n.line.set_vectorize(l,i),u(l,o),l.stroke())},cross:function(l,i,o,n){T(l,o),n.line.apply(l,i)},diamond:d,diamond_dot:function(l,i,o,n){d(l,i,o,n),_(l,i,o,n)},diamond_cross:function(l,i,o,n){y(l,o),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.doit&&(n.line.set_vectorize(l,i),l.moveTo(0,o),l.lineTo(0,-o),l.moveTo(-o/1.5,0),l.lineTo(o/1.5,0),l.stroke())},dot:_,hex:P,hex_dot:function(l,i,o,n){P(l,i,o,n),_(l,i,o,n)},inverted_triangle:function(l,i,o,n){l.rotate(Math.PI),s(l,o),l.rotate(-Math.PI),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.apply(l,i)},plus:function(l,i,o,n){var e=3*o/8,t=[e,e,o,o,e,e,-e,-e,-o,-o,-e,-e],a=[o,e,e,-e,-e,-o,-o,-e,-e,e,e,o];l.beginPath();for(var c=0;c<12;c++)l.lineTo(t[c],a[c]);l.closePath(),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.apply(l,i)},square:m,square_cross:function(l,i,o,n){var e=2*o;l.rect(-o,-o,e,e),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.doit&&(n.line.set_vectorize(l,i),T(l,o),l.stroke())},square_dot:function(l,i,o,n){m(l,i,o,n),_(l,i,o,n)},square_pin:function(l,i,o,n){var e=3*o/8;l.moveTo(-o,-o),l.quadraticCurveTo(0,-e,o,-o),l.quadraticCurveTo(e,0,o,o),l.quadraticCurveTo(0,e,-o,o),l.quadraticCurveTo(-e,0,-o,-o),l.closePath(),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.apply(l,i)},square_x:function(l,i,o,n){var e=2*o;l.rect(-o,-o,e,e),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.doit&&(n.line.set_vectorize(l,i),l.moveTo(-o,o),l.lineTo(o,-o),l.moveTo(-o,-o),l.lineTo(o,o),l.stroke())},star:q,star_dot:function(l,i,o,n){q(l,i,o,n),_(l,i,o,n)},triangle:M,triangle_dot:function(l,i,o,n){M(l,i,o,n),_(l,i,o,n)},triangle_pin:function(l,i,o,n){var e=o*t,a=e/3,c=3*a/8;l.moveTo(-o,a),l.quadraticCurveTo(0,c,o,a),l.quadraticCurveTo(t*c/2,c/2,0,a-e),l.quadraticCurveTo(-t*c/2,c/2,-o,a),l.closePath(),n.fill.apply(l,i),n.hatch.apply(l,i),n.line.apply(l,i)},dash:function(l,i,o,n){!function(l,i){l.moveTo(-i,0),l.lineTo(i,0)}(l,o),n.line.apply(l,i)},x:function(l,i,o,n){u(l,o),n.line.apply(l,i)},y:function(l,i,o,n){f(l,o),n.line.apply(l,i)}}},
function _(e,t,r,i,n){i();var s,a=e(1),_=(0,a.__importStar)(e(300)),o=(0,a.__importStar)(e(133)),h=e(163),l=e(193),d=e(294),y=e(299),c=e(187),x=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(t,e),t.prototype._project_data=function(){l.inplace.project_xy(this._x0,this._y0),l.inplace.project_xy(this._x1,this._y1)},t.prototype._index_data=function(e){for(var t=Math.min,r=Math.max,i=this,n=i._x0,s=i._x1,a=i._y0,_=i._y1,o=i.data_size,h=0;h<o;h++){var l=n[h],d=s[h],y=a[h],c=_[h];e.add_rect(t(l,d),t(y,c),r(l,d),r(y,c))}},t.prototype._render=function(e,t,r){var i,n;if(this.visuals.line.doit){var s=null!=r?r:this,_=s.sx0,o=s.sy0,h=s.sx1,l=s.sy1;try{for(var d=(0,a.__values)(t),y=d.next();!y.done;y=d.next()){var c=y.value,x=_[c],u=o[c],p=h[c],v=l[c];isFinite(x+u+p+v)&&(e.beginPath(),e.moveTo(x,u),e.lineTo(p,v),this.visuals.line.set_vectorize(e,c),e.stroke())}}catch(e){i={error:e}}finally{try{y&&!y.done&&(n=d.return)&&n.call(d)}finally{if(i)throw i.error}}}},t.prototype._hit_point=function(e){var t,r,i=e.sx,n=e.sy,s={x:i,y:n},o=(0,a.__read)(this.renderer.xscale.r_invert(i-2,i+2),2),h=o[0],l=o[1],d=(0,a.__read)(this.renderer.yscale.r_invert(n-2,n+2),2),y=d[0],x=d[1],u=this.index.indices({x0:h,y0:y,x1:l,y1:x}),p=[];try{for(var v=(0,a.__values)(u),f=v.next();!f.done;f=v.next()){var m=f.value,w=Math.pow(Math.max(2,this.line_width.get(m)/2),2),g={x:this.sx0[m],y:this.sy0[m]},S={x:this.sx1[m],y:this.sy1[m]};_.dist_to_segment_squared(s,g,S)<w&&p.push(m)}}catch(e){t={error:e}}finally{try{f&&!f.done&&(r=v.return)&&r.call(v)}finally{if(t)throw t.error}}return new c.Selection({indices:p})},t.prototype._hit_span=function(e){var t,r,i,n,s,_,o,h=(0,a.__read)(this.renderer.plot_view.frame.bbox.ranges,2),l=h[0],d=h[1],y=e.sx,x=e.sy;"v"==e.direction?(o=this.renderer.yscale.invert(x),s=(t=(0,a.__read)([this._y0,this._y1],2))[0],_=t[1]):(o=this.renderer.xscale.invert(y),s=(r=(0,a.__read)([this._x0,this._x1],2))[0],_=r[1]);var u=[],p=(0,a.__read)(this.renderer.xscale.r_invert(l.start,l.end),2),v=p[0],f=p[1],m=(0,a.__read)(this.renderer.yscale.r_invert(d.start,d.end),2),w=m[0],g=m[1],S=this.index.indices({x0:v,y0:w,x1:f,y1:g});try{for(var M=(0,a.__values)(S),b=M.next();!b.done;b=M.next()){var C=b.value;(s[C]<=o&&o<=_[C]||_[C]<=o&&o<=s[C])&&u.push(C);var V=1.5+this.line_width.get(C)/2;s[C]==_[C]&&("h"==e.direction?Math.abs(this.sx0[C]-y)<=V&&u.push(C):Math.abs(this.sy0[C]-x)<=V&&u.push(C))}}catch(e){i={error:e}}finally{try{b&&!b.done&&(n=M.return)&&n.call(M)}finally{if(i)throw i.error}}return new c.Selection({indices:u})},t.prototype.scenterxy=function(e){return[this.sx0[e]/2+this.sx1[e]/2,this.sy0[e]/2+this.sy1[e]/2]},t.prototype.draw_legend_for_index=function(e,t,r){(0,y.generic_line_vector_legend)(this.visuals,e,t,r)},t}(d.GlyphView);r.SegmentView=x,x.__name__="SegmentView";var u=function(e){function t(t){return e.call(this,t)||this}return(0,a.__extends)(t,e),t}(d.Glyph);r.Segment=u,s=u,u.__name__="Segment",s.prototype.default_view=x,s.define((function(e){return{x0:[o.XCoordinateSpec,{field:"x0"}],y0:[o.YCoordinateSpec,{field:"y0"}],x1:[o.XCoordinateSpec,{field:"x1"}],y1:[o.YCoordinateSpec,{field:"y1"}]}})),s.mixins(h.LineVector)},
function _(t,e,n,i,s){i();var r,o=t(1),_=t(293),a=(0,o.__importStar)(t(163)),l=t(411),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(e,t),e.prototype._set_data=function(){var t,e=this.model,n=e.tension,i=e.closed;t=(0,o.__read)((0,l.catmullrom_spline)(this._x,this._y,20,n,i),2),this._xt=t[0],this._yt=t[1]},e.prototype._map_data=function(){var t=this.renderer.coordinates,e=t.x_scale,n=t.y_scale;this.sxt=e.v_compute(this._xt),this.syt=n.v_compute(this._yt)},e.prototype._render=function(t,e,n){var i=null!=n?n:this,s=i.sxt,r=i.syt,o=!0;t.beginPath();for(var _=s.length,a=0;a<_;a++){var l=s[a],u=r[a];isFinite(l+u)?o?(t.moveTo(l,u),o=!1):t.lineTo(l,u):o=!0}this.visuals.line.set_value(t),t.stroke()},e}(_.XYGlyphView);n.SplineView=u,u.__name__="SplineView";var p=function(t){function e(e){return t.call(this,e)||this}return(0,o.__extends)(e,t),e}(_.XYGlyph);n.Spline=p,r=p,p.__name__="Spline",r.prototype.default_view=u,r.mixins(a.LineScalar),r.define((function(t){var e=t.Boolean;return{tension:[t.Number,.5],closed:[e,!1]}}))},
function _(e,n,r,t,a){t();var o=e(139),v=e(127);r.catmullrom_spline=function(e,n,r,t,a){void 0===r&&(r=10),void 0===t&&(t=.5),void 0===a&&(a=!1),(0,v.assert)(e.length==n.length);var i=e.length,f=a?i+1:i,l=(0,o.infer_type)(e,n),w=new l(f+2),s=new l(f+2);w.set(e,1),s.set(n,1),a?(w[0]=e[i-1],s[0]=n[i-1],w[f]=e[0],s[f]=n[0],w[f+1]=e[1],s[f+1]=n[1]):(w[0]=e[0],s[0]=n[0],w[f+1]=e[i-1],s[f+1]=n[i-1]);for(var h=new l(4*(r+1)),u=0,c=0;u<=r;u++){var d=u/r,g=Math.pow(d,2),p=d*g;h[c++]=2*p-3*g+1,h[c++]=-2*p+3*g,h[c++]=p-2*g+d,h[c++]=p-g}var _=new l((f-1)*(r+1)),m=new l((f-1)*(r+1)),y=1;for(c=0;y<f;y++){var M=(w[y+1]-w[y-1])*t,b=(s[y+1]-s[y-1])*t,j=(w[y+2]-w[y])*t,k=(s[y+2]-s[y])*t;for(u=0;u<=4*r;c++){var q=h[u++],x=h[u++],z=h[u++],A=h[u++];_[c]=q*w[y]+x*w[y+1]+z*M+A*j,m[c]=q*s[y]+x*s[y+1]+z*b+A*k}}return[_,m]}},
function _(e,n,r,t,i){t();var a,o=e(1),l=e(293),_=e(299),s=(0,o.__importStar)(e(163)),u=e(135),d=e(127),c=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,o.__extends)(n,e),n.prototype._render=function(e,n,r){var t,i,a,l,_,s,u,c,f=null!=r?r:this,v=f.sx,h=f.sy,p=!1,y=null;this.visuals.line.set_value(e);var b=n.length;if(!(b<2)){e.beginPath(),e.moveTo(v[0],h[0]);try{for(var m=(0,o.__values)(n),g=m.next();!g.done;g=m.next()){var w=g.value,x=void 0,S=void 0,k=void 0,T=void 0;switch(this.model.mode){case"before":x=(a=(0,o.__read)([v[w-1],h[w]],2))[0],k=a[1],S=(l=(0,o.__read)([v[w],h[w]],2))[0],T=l[1];break;case"after":x=(_=(0,o.__read)([v[w],h[w-1]],2))[0],k=_[1],S=(s=(0,o.__read)([v[w],h[w]],2))[0],T=s[1];break;case"center":var P=(v[w-1]+v[w])/2;x=(u=(0,o.__read)([P,h[w-1]],2))[0],k=u[1],S=(c=(0,o.__read)([P,h[w]],2))[0],T=c[1];break;default:(0,d.unreachable)()}if(p){if(!isFinite(v[w]+h[w])){e.stroke(),e.beginPath(),p=!1,y=w;continue}null!=y&&w-y>1&&(e.stroke(),p=!1)}p?(e.lineTo(x,k),e.lineTo(S,T)):(e.beginPath(),e.moveTo(v[w],h[w]),p=!0),y=w}}catch(e){t={error:e}}finally{try{g&&!g.done&&(i=m.return)&&i.call(m)}finally{if(t)throw t.error}}e.lineTo(v[b-1],h[b-1]),e.stroke()}},n.prototype.draw_legend_for_index=function(e,n,r){(0,_.generic_line_scalar_legend)(this.visuals,e,n)},n}(l.XYGlyphView);r.StepView=c,c.__name__="StepView";var f=function(e){function n(n){return e.call(this,n)||this}return(0,o.__extends)(n,e),n}(l.XYGlyph);r.Step=f,a=f,f.__name__="Step",a.prototype.default_view=c,a.mixins(s.LineScalar),a.define((function(){return{mode:[u.StepMode,"before"]}}))},
function _(t,e,r,s,n){s();var i,o=t(1),a=t(293),_=t(163),l=(0,o.__importStar)(t(300)),h=(0,o.__importStar)(t(133)),u=t(236),f=t(127),x=t(187),p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,o.__extends)(e,t),e.prototype._rotate_point=function(t,e,r,s,n){return[(t-r)*Math.cos(n)-(e-s)*Math.sin(n)+r,(t-r)*Math.sin(n)+(e-s)*Math.cos(n)+s]},e.prototype._text_bounds=function(t,e,r,s){return[[t,t+r,t+r,t,t],[e,e,e-s,e-s,e]]},e.prototype._render=function(t,e,r){var s,n,i,a,_=null!=r?r:this,l=_.sx,h=_.sy,f=_.x_offset,x=_.y_offset,p=_.angle,c=_.text;this._sys=[],this._sxs=[];try{for(var v=(0,o.__values)(e),d=v.next();!d.done;d=v.next()){var y=d.value,g=this._sxs[y]=[],m=this._sys[y]=[],w=l[y],b=h[y],T=f.get(y),S=x.get(y),M=p.get(y),V=c.get(y);if(isFinite(w+b+T+S+M)&&null!=V&&this.visuals.text.doit){var k=""+V;t.save(),t.translate(w+T,b+S),t.rotate(M),this.visuals.text.set_vectorize(t,y);var N=this.visuals.text.font_value(y),G=(0,u.font_metrics)(N).height,X=this.text_line_height.get(y)*G;if(-1==k.indexOf("\n")){t.fillText(k,0,0);var Y=w+T,z=b+S,A=t.measureText(k).width,F=(0,o.__read)(this._text_bounds(Y,z,A,X),2),O=F[0],j=F[1];g.push(O),m.push(j)}else{var q=k.split("\n"),B=X*q.length,C=this.text_baseline.get(y),D=void 0;switch(C){case"top":D=0;break;case"middle":D=-B/2+X/2;break;case"bottom":D=-B+X;break;default:D=0,console.warn("'"+C+"' baseline not supported with multi line text")}try{for(var E=(i=void 0,(0,o.__values)(q)),H=E.next();!H.done;H=E.next()){var I=H.value;t.fillText(I,0,D);Y=w+T,z=D+b+S,A=t.measureText(I).width;var J=(0,o.__read)(this._text_bounds(Y,z,A,X),2);O=J[0],j=J[1];g.push(O),m.push(j),D+=X}}catch(t){i={error:t}}finally{try{H&&!H.done&&(a=E.return)&&a.call(E)}finally{if(i)throw i.error}}}t.restore()}}}catch(t){s={error:t}}finally{try{d&&!d.done&&(n=v.return)&&n.call(v)}finally{if(s)throw s.error}}},e.prototype._hit_point=function(t){for(var e=t.sx,r=t.sy,s=[],n=0;n<this._sxs.length;n++)for(var i=this._sxs[n],a=this._sys[n],_=i.length,h=0,u=_;h<u;h++){var f=(0,o.__read)(this._rotate_point(e,r,i[_-1][0],a[_-1][0],-this.angle.get(n)),2),p=f[0],c=f[1];l.point_in_poly(p,c,i[h],a[h])&&s.push(n)}return new x.Selection({indices:s})},e.prototype.scenterxy=function(t){var e=this._sxs[t],r=this._sys[t];(0,f.assert)(0!=e.length&&0!=r.length);var s=e[0][0],n=r[0][0],i=(e[0][2]+s)/2,a=(r[0][2]+n)/2,_=(0,o.__read)(this._rotate_point(i,a,s,n,this.angle.get(t)),2);return[_[0],_[1]]},e}(a.XYGlyphView);r.TextView=p,p.__name__="TextView";var c=function(t){function e(e){return t.call(this,e)||this}return(0,o.__extends)(e,t),e}(a.XYGlyph);r.Text=c,i=c,c.__name__="Text",i.prototype.default_view=p,i.mixins(_.TextVector),i.define((function(t){return{text:[h.NullStringSpec,{field:"text"}],angle:[h.AngleSpec,0],x_offset:[h.NumberSpec,0],y_offset:[h.NumberSpec,0]}}))},
function _(t,e,i,s,r){s();var o,n=t(1),h=t(392),a=t(139),_=(0,n.__importStar)(t(133)),p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,n.__extends)(e,t),e.prototype.scenterxy=function(t){return[this.sx[t],(this.stop[t]+this.sbottom[t])/2]},e.prototype._lrtb=function(t){var e=this.width.get(t)/2,i=this._x[t],s=this._top[t],r=this._bottom[t];return[i-e,i+e,Math.max(s,r),Math.min(s,r)]},e.prototype._map_data=function(){this.sx=this.renderer.xscale.v_compute(this._x),this.sw=this.sdist(this.renderer.xscale,this._x,this.width,"center"),this.stop=this.renderer.yscale.v_compute(this._top),this.sbottom=this.renderer.yscale.v_compute(this._bottom);var t=this.sx.length;this.sleft=new a.ScreenArray(t),this.sright=new a.ScreenArray(t);for(var e=0;e<t;e++)this.sleft[e]=this.sx[e]-this.sw[e]/2,this.sright[e]=this.sx[e]+this.sw[e]/2;this._clamp_viewport()},e}(h.BoxView);i.VBarView=p,p.__name__="VBarView";var c=function(t){function e(e){return t.call(this,e)||this}return(0,n.__extends)(e,t),e}(h.Box);i.VBar=c,o=c,c.__name__="VBar",o.prototype.default_view=p,o.define((function(t){return{x:[_.XCoordinateSpec,{field:"x"}],bottom:[_.YCoordinateSpec,{value:0}],width:[_.NumberSpec,{value:1}],top:[_.YCoordinateSpec,{field:"top"}]}}))},
function _(e,t,r,i,n){i();var a,s=e(1),l=e(293),o=e(299),d=e(163),h=e(139),_=e(135),c=(0,s.__importStar)(e(133)),u=e(117),p=e(187),y=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,s.__extends)(t,e),t.prototype._map_data=function(){"data"==this.model.properties.radius.units?this.sradius=this.sdist(this.renderer.xscale,this._x,this.radius):this.sradius=(0,h.to_screen)(this.radius)},t.prototype._render=function(e,t,r){var i,n,a=null!=r?r:this,l=a.sx,o=a.sy,d=a.sradius,h=a.start_angle,_=a.end_angle,c="anticlock"==this.model.direction;try{for(var u=(0,s.__values)(t),p=u.next();!p.done;p=u.next()){var y=p.value,f=l[y],v=o[y],g=d[y],x=h.get(y),w=_.get(y);isFinite(f+v+g+x+w)&&(e.beginPath(),e.arc(f,v,g,x,w,c),e.lineTo(f,v),e.closePath(),this.visuals.fill.apply(e,y),this.visuals.hatch.apply(e,y),this.visuals.line.apply(e,y))}}catch(e){i={error:e}}finally{try{p&&!p.done&&(n=u.return)&&n.call(u)}finally{if(i)throw i.error}}},t.prototype._hit_point=function(e){var t,r,i,n,a,l,o,d,h,_,c,y,f,v,g,x,w=e.sx,m=e.sy,M=this.renderer.xscale.invert(w),V=this.renderer.yscale.invert(m),S=2*this.max_radius;"data"===this.model.properties.radius.units?(f=M-S,v=M+S,g=V-S,x=V+S):(h=w-S,_=w+S,f=(t=(0,s.__read)(this.renderer.xscale.r_invert(h,_),2))[0],v=t[1],c=m-S,y=m+S,g=(r=(0,s.__read)(this.renderer.yscale.r_invert(c,y),2))[0],x=r[1]);var W=[];try{for(var k=(0,s.__values)(this.index.indices({x0:f,x1:v,y0:g,y1:x})),b=k.next();!b.done;b=k.next()){var A=b.value,D=Math.pow(this.sradius[A],2);h=(a=(0,s.__read)(this.renderer.xscale.r_compute(M,this._x[A]),2))[0],_=a[1],c=(l=(0,s.__read)(this.renderer.yscale.r_compute(V,this._y[A]),2))[0],y=l[1],Math.pow(h-_,2)+Math.pow(c-y,2)<=D&&W.push(A)}}catch(e){i={error:e}}finally{try{b&&!b.done&&(n=k.return)&&n.call(k)}finally{if(i)throw i.error}}var F="anticlock"==this.model.direction,G=[];try{for(var P=(0,s.__values)(W),X=P.next();!X.done;X=P.next()){A=X.value;var Y=Math.atan2(m-this.sy[A],w-this.sx[A]);(0,u.angle_between)(-Y,-this.start_angle.get(A),-this.end_angle.get(A),F)&&G.push(A)}}catch(e){o={error:e}}finally{try{X&&!X.done&&(d=P.return)&&d.call(P)}finally{if(o)throw o.error}}return new p.Selection({indices:G})},t.prototype.draw_legend_for_index=function(e,t,r){(0,o.generic_area_vector_legend)(this.visuals,e,t,r)},t.prototype.scenterxy=function(e){var t=this.sradius[e]/2,r=(this.start_angle.get(e)+this.end_angle.get(e))/2;return[this.sx[e]+t*Math.cos(r),this.sy[e]+t*Math.sin(r)]},t}(l.XYGlyphView);r.WedgeView=y,y.__name__="WedgeView";var f=function(e){function t(t){return e.call(this,t)||this}return(0,s.__extends)(t,e),t}(l.XYGlyph);r.Wedge=f,a=f,f.__name__="Wedge",a.prototype.default_view=y,a.mixins([d.LineVector,d.FillVector,d.HatchVector]),a.define((function(e){return{direction:[_.Direction,"anticlock"],radius:[c.DistanceSpec,{field:"radius"}],start_angle:[c.AngleSpec,{field:"start_angle"}],end_angle:[c.AngleSpec,{field:"end_angle"}]}}))},
function _(r,t,_,a,o){a();var e=r(1);(0,e.__exportStar)(r(417),_),(0,e.__exportStar)(r(418),_),(0,e.__exportStar)(r(419),_)},
function _(e,t,n,r,d){r();var o=e(1),i=e(168),_=e(116),s=e(126),a=e(187),c=function(e){function t(t){return e.call(this,t)||this}return(0,o.__extends)(t,e),t.prototype._hit_test=function(e,t,n){if(!t.model.visible)return null;var r=n.glyph.hit_test(e);return null==r?null:n.model.view.convert_selection_from_subset(r)},t}(i.Model);n.GraphHitTestPolicy=c,c.__name__="GraphHitTestPolicy";var l=function(e){function t(t){return e.call(this,t)||this}return(0,o.__extends)(t,e),t.prototype.hit_test=function(e,t){return this._hit_test(e,t,t.edge_view)},t.prototype.do_selection=function(e,t,n,r){if(null==e)return!1;var d=t.edge_renderer.data_source.selected;return d.update(e,n,r),t.edge_renderer.data_source._select.emit(),!d.is_empty()},t.prototype.do_inspection=function(e,t,n,r,d){if(null==e)return!1;var o=n.model.edge_renderer.get_selection_manager().get_or_create_inspector(n.edge_view.model);return o.update(e,r,d),n.edge_view.model.data_source.setv({inspected:o},{silent:!0}),n.edge_view.model.data_source.inspect.emit([n.edge_view.model,{geometry:t}]),!o.is_empty()},t}(c);n.EdgesOnly=l,l.__name__="EdgesOnly";var u=function(e){function t(t){return e.call(this,t)||this}return(0,o.__extends)(t,e),t.prototype.hit_test=function(e,t){return this._hit_test(e,t,t.node_view)},t.prototype.do_selection=function(e,t,n,r){if(null==e)return!1;var d=t.node_renderer.data_source.selected;return d.update(e,n,r),t.node_renderer.data_source._select.emit(),!d.is_empty()},t.prototype.do_inspection=function(e,t,n,r,d){if(null==e)return!1;var o=n.model.node_renderer.get_selection_manager().get_or_create_inspector(n.node_view.model);return o.update(e,r,d),n.node_view.model.data_source.setv({inspected:o},{silent:!0}),n.node_view.model.data_source.inspect.emit([n.node_view.model,{geometry:t}]),!o.is_empty()},t}(c);n.NodesOnly=u,u.__name__="NodesOnly";var p=function(e){function t(t){return e.call(this,t)||this}return(0,o.__extends)(t,e),t.prototype.hit_test=function(e,t){return this._hit_test(e,t,t.node_view)},t.prototype.get_linked_edges=function(e,t,n){var r,d,i=[];"selection"==n?i=e.selected.indices.map((function(t){return e.data.index[t]})):"inspection"==n&&(i=e.inspected.indices.map((function(t){return e.data.index[t]})));for(var _=[],c=0;c<t.data.start.length;c++)((0,s.contains)(i,t.data.start[c])||(0,s.contains)(i,t.data.end[c]))&&_.push(c);var l=new a.Selection;try{for(var u=(0,o.__values)(_),p=u.next();!p.done;p=u.next()){c=p.value;l.multiline_indices[c]=[0]}}catch(e){r={error:e}}finally{try{p&&!p.done&&(d=u.return)&&d.call(u)}finally{if(r)throw r.error}}return l.indices=_,l},t.prototype.do_selection=function(e,t,n,r){if(null==e)return!1;var d=t.node_renderer.data_source.selected;d.update(e,n,r);var o=t.edge_renderer.data_source.selected,i=this.get_linked_edges(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.update(i,n,r),t.node_renderer.data_source._select.emit(),!d.is_empty()},t.prototype.do_inspection=function(e,t,n,r,d){if(null==e)return!1;var o=n.node_view.model.data_source.selection_manager.get_or_create_inspector(n.node_view.model);o.update(e,r,d),n.node_view.model.data_source.setv({inspected:o},{silent:!0});var i=n.edge_view.model.data_source.selection_manager.get_or_create_inspector(n.edge_view.model),_=this.get_linked_edges(n.node_view.model.data_source,n.edge_view.model.data_source,"inspection");return i.update(_,r,d),n.edge_view.model.data_source.setv({inspected:i},{silent:!0}),n.node_view.model.data_source.inspect.emit([n.node_view.model,{geometry:t}]),!o.is_empty()},t}(c);n.NodesAndLinkedEdges=p,p.__name__="NodesAndLinkedEdges";var v=function(e){function t(t){return e.call(this,t)||this}return(0,o.__extends)(t,e),t.prototype.hit_test=function(e,t){return this._hit_test(e,t,t.edge_view)},t.prototype.get_linked_nodes=function(e,t,n){var r,d,i=[];"selection"==n?i=t.selected.indices:"inspection"==n&&(i=t.inspected.indices);var c=[];try{for(var l=(0,o.__values)(i),u=l.next();!u.done;u=l.next()){var p=u.value;c.push(t.data.start[p]),c.push(t.data.end[p])}}catch(e){r={error:e}}finally{try{u&&!u.done&&(d=l.return)&&d.call(l)}finally{if(r)throw r.error}}var v=(0,s.uniq)(c).map((function(t){return(0,_.indexOf)(e.data.index,t)}));return new a.Selection({indices:v})},t.prototype.do_selection=function(e,t,n,r){if(null==e)return!1;var d=t.edge_renderer.data_source.selected;d.update(e,n,r);var o=t.node_renderer.data_source.selected,i=this.get_linked_nodes(t.node_renderer.data_source,t.edge_renderer.data_source,"selection");return o.update(i,n,r),t.edge_renderer.data_source._select.emit(),!d.is_empty()},t.prototype.do_inspection=function(e,t,n,r,d){if(null==e)return!1;var o=n.edge_view.model.data_source.selection_manager.get_or_create_inspector(n.edge_view.model);o.update(e,r,d),n.edge_view.model.data_source.setv({inspected:o},{silent:!0});var i=n.node_view.model.data_source.selection_manager.get_or_create_inspector(n.node_view.model),_=this.get_linked_nodes(n.node_view.model.data_source,n.edge_view.model.data_source,"inspection");return i.update(_,r,d),n.node_view.model.data_source.setv({inspected:i},{silent:!0}),n.edge_view.model.data_source.inspect.emit([n.edge_view.model,{geometry:t}]),!o.is_empty()},t}(c);n.EdgesAndLinkedNodes=v,v.__name__="EdgesAndLinkedNodes"},
function _(e,t,n,o,r){o();var i,a=e(1),u=e(168),_=e(375),d=function(e){function t(t){return e.call(this,t)||this}return(0,a.__extends)(t,e),Object.defineProperty(t.prototype,"node_coordinates",{get:function(){return new s({layout:this})},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"edge_coordinates",{get:function(){return new f({layout:this})},enumerable:!1,configurable:!0}),t}(u.Model);n.LayoutProvider=d,d.__name__="LayoutProvider";var c=function(e){function t(t){return e.call(this,t)||this}return(0,a.__extends)(t,e),t}(_.CoordinateTransform);n.GraphCoordinates=c,i=c,c.__name__="GraphCoordinates",i.define((function(e){return{layout:[(0,e.Ref)(d)]}}));var s=function(e){function t(t){return e.call(this,t)||this}return(0,a.__extends)(t,e),t.prototype._v_compute=function(e){var t=(0,a.__read)(this.layout.get_node_coordinates(e),2);return{x:t[0],y:t[1]}},t}(c);n.NodeCoordinates=s,s.__name__="NodeCoordinates";var f=function(e){function t(t){return e.call(this,t)||this}return(0,a.__extends)(t,e),t.prototype._v_compute=function(e){var t=(0,a.__read)(this.layout.get_edge_coordinates(e),2);return{x:t[0],y:t[1]}},t}(c);n.EdgeCoordinates=f,f.__name__="EdgeCoordinates"},
function _(t,a,r,n,o){n();var e,u=t(1),l=function(t){function a(a){return t.call(this,a)||this}return(0,u.__extends)(a,t),a.prototype.get_node_coordinates=function(t){for(var a,r=null!==(a=t.data.index)&&void 0!==a?a:[],n=r.length,o=new Float64Array(n),e=new Float64Array(n),l=0;l<n;l++){var i=this.graph_layout[r[l]],d=(0,u.__read)(null!=i?i:[NaN,NaN],2),h=d[0],s=d[1];o[l]=h,e[l]=s}return[o,e]},a.prototype.get_edge_coordinates=function(t){for(var a,r,n=null!==(a=t.data.start)&&void 0!==a?a:[],o=null!==(r=t.data.end)&&void 0!==r?r:[],e=Math.min(n.length,o.length),u=[],l=[],i=null!=t.data.xs&&null!=t.data.ys,d=0;d<e;d++){var h=null!=this.graph_layout[n[d]]&&null!=this.graph_layout[o[d]];if(i&&h)u.push(t.data.xs[d]),l.push(t.data.ys[d]);else{var s=void 0,_=void 0;h?(s=this.graph_layout[n[d]],_=this.graph_layout[o[d]]):(s=[NaN,NaN],_=[NaN,NaN]),u.push([s[0],_[0]]),l.push([s[1],_[1]])}}return[u,l]},a}(t(418).LayoutProvider);r.StaticLayoutProvider=l,e=l,l.__name__="StaticLayoutProvider",e.define((function(t){var a=t.Number,r=t.Tuple;return{graph_layout:[(0,t.Dict)(r(a,a)),{}]}}))},
function _(i,d,n,r,G){r(),G("Grid",i(421).Grid)},
function _(r,i,e,t,n){t();var o,a=r(1),_=r(242),s=r(244),d=r(245),l=(0,a.__importStar)(r(163)),u=r(125),h=function(r){function i(){return null!==r&&r.apply(this,arguments)||this}return(0,a.__extends)(i,r),i.prototype._render=function(){var r=this.layer.ctx;r.save(),this._draw_regions(r),this._draw_minor_grids(r),this._draw_grids(r),r.restore()},i.prototype.connect_signals=function(){var i=this;r.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return i.request_render()}))},i.prototype._draw_regions=function(r){if(this.visuals.band_fill.doit||this.visuals.band_hatch.doit)for(var i=(0,a.__read)(this.grid_coords("major",!1),2),e=i[0],t=i[1],n=0;n<e.length-1;n++)if(n%2==1){var o=(0,a.__read)(this.coordinates.map_to_screen(e[n],t[n]),2),_=o[0],s=o[1],d=(0,a.__read)(this.coordinates.map_to_screen(e[n+1],t[n+1]),2),l=d[0],u=d[1];r.beginPath(),r.rect(_[0],s[0],l[1]-_[0],u[1]-s[0]),this.visuals.band_fill.apply(r),this.visuals.band_hatch.apply(r)}},i.prototype._draw_grids=function(r){if(this.visuals.grid_line.doit){var i=(0,a.__read)(this.grid_coords("major"),2),e=i[0],t=i[1];this._draw_grid_helper(r,this.visuals.grid_line,e,t)}},i.prototype._draw_minor_grids=function(r){if(this.visuals.minor_grid_line.doit){var i=(0,a.__read)(this.grid_coords("minor"),2),e=i[0],t=i[1];this._draw_grid_helper(r,this.visuals.minor_grid_line,e,t)}},i.prototype._draw_grid_helper=function(r,i,e,t){i.set_value(r),r.beginPath();for(var n=0;n<e.length;n++){var o=(0,a.__read)(this.coordinates.map_to_screen(e[n],t[n]),2),_=o[0],s=o[1];r.moveTo(Math.round(_[0]),Math.round(s[0]));for(var d=1;d<_.length;d++)r.lineTo(Math.round(_[d]),Math.round(s[d]))}r.stroke()},i.prototype.ranges=function(){var r=this.model.dimension,i=(r+1)%2,e=this.coordinates.ranges;return[e[r],e[i]]},i.prototype.computed_bounds=function(){var r,i,e,t,n,o,_=(0,a.__read)(this.ranges(),1)[0],s=this.model.bounds,d=[_.min,_.max];if((0,u.isArray)(s))n=Math.min(s[0],s[1]),o=Math.max(s[0],s[1]),n<d[0]&&(n=d[0]),o>d[1]&&(o=d[1]);else{n=(r=(0,a.__read)(d,2))[0],o=r[1];try{for(var l=(0,a.__values)(this.plot_view.axis_views),h=l.next();!h.done;h=l.next()){var c=h.value;c.dimension==this.model.dimension&&c.model.x_range_name==this.model.x_range_name&&c.model.y_range_name==this.model.y_range_name&&(n=(t=(0,a.__read)(c.computed_bounds,2))[0],o=t[1])}}catch(r){i={error:r}}finally{try{h&&!h.done&&(e=l.return)&&e.call(l)}finally{if(i)throw i.error}}}return[n,o]},i.prototype.grid_coords=function(r,i){var e;void 0===i&&(i=!0);var t=this.model.dimension,n=(t+1)%2,o=(0,a.__read)(this.ranges(),2),_=o[0],s=o[1],d=(0,a.__read)(this.computed_bounds(),2),l=d[0],u=d[1];l=(e=(0,a.__read)([Math.min(l,u),Math.max(l,u)],2))[0],u=e[1];var h=[[],[]],c=this.model.get_ticker();if(null==c)return h;var m=c.get_ticks(l,u,_,s.min)[r],p=_.min,g=_.max,v=s.min,f=s.max;i||(m[0]!=p&&m.splice(0,0,p),m[m.length-1]!=g&&m.push(g));for(var y=0;y<m.length;y++)if(m[y]!=p&&m[y]!=g||!i){for(var x=[],b=[],w=0;w<2;w++){var k=v+(f-v)/1*w;x.push(m[y]),b.push(k)}h[t].push(x),h[n].push(b)}return h},i}(s.GuideRendererView);e.GridView=h,h.__name__="GridView";var c=function(r){function i(i){return r.call(this,i)||this}return(0,a.__extends)(i,r),i.prototype.get_ticker=function(){return null!=this.ticker?this.ticker:null!=this.axis?this.axis.ticker:null},i}(s.GuideRenderer);e.Grid=c,o=c,c.__name__="Grid",o.prototype.default_view=h,o.mixins([["grid_",l.Line],["minor_grid_",l.Line],["band_",l.Fill],["band_",l.Hatch]]),o.define((function(r){var i=r.Number,e=r.Auto,t=r.Enum,n=r.Ref,o=r.Tuple,a=r.Or,s=r.Nullable;return{bounds:[a(o(i,i),e),"auto"],dimension:[t(0,1),0],axis:[s(n(_.Axis)),null],ticker:[s(n(d.Ticker)),null]}})),o.override({level:"underlay",band_fill_color:null,band_fill_alpha:0,grid_line_color:"#e5e5e5",minor_grid_line_color:null})},
function _(o,a,x,B,e){B(),e("Box",o(423).Box),e("Column",o(425).Column),e("GridBox",o(426).GridBox),e("HTMLBox",o(427).HTMLBox),e("LayoutDOM",o(424).LayoutDOM),e("Panel",o(428).Panel),e("Row",o(429).Row),e("Spacer",o(430).Spacer),e("Tabs",o(431).Tabs),e("WidgetBox",o(434).WidgetBox)},
function _(n,e,t,r,i){r();var o,c=n(1),u=n(424),a=function(n){function e(){return null!==n&&n.apply(this,arguments)||this}return(0,c.__extends)(e,n),e.prototype.connect_signals=function(){var e=this;n.prototype.connect_signals.call(this),this.connect(this.model.properties.children.change,(function(){return e.rebuild()}))},Object.defineProperty(e.prototype,"child_models",{get:function(){return this.model.children},enumerable:!1,configurable:!0}),e}(u.LayoutDOMView);t.BoxView=a,a.__name__="BoxView";var l=function(n){function e(e){return n.call(this,e)||this}return(0,c.__extends)(e,n),e}(u.LayoutDOM);t.Box=l,o=l,l.__name__="Box",o.define((function(n){var e=n.Number;return{children:[(0,n.Array)((0,n.Ref)(u.LayoutDOM)),[]],spacing:[e,0]}}))},
function _(t,e,i,r,o){r();var n,l=t(1),a=t(168),s=t(135),h=t(158),u=t(134),_=t(125),c=t(137),d=t(236),p=t(228),y=t(341),f=t(322),v=t(159),m=t(350),g=function(t){function e(){var e=t.apply(this,(0,l.__spreadArray)([],(0,l.__read)(arguments),!1))||this;return e._offset_parent=null,e._viewport={},e}return(0,l.__extends)(e,t),Object.defineProperty(e.prototype,"is_layout_root",{get:function(){return this.is_root||!(this.parent instanceof e)},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"base_font_size",{get:function(){var t=getComputedStyle(this.el).fontSize,e=(0,d.parse_css_font_size)(t);if(null!=e){var i=e.value;if("px"==e.unit)return i}return null},enumerable:!1,configurable:!0}),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.el.style.position=this.is_layout_root?"relative":"absolute",this._child_views=new Map},e.prototype.lazy_initialize=function(){return(0,l.__awaiter)(this,void 0,void 0,(function(){return(0,l.__generator)(this,(function(e){switch(e.label){case 0:return[4,t.prototype.lazy_initialize.call(this)];case 1:return e.sent(),[4,this.build_child_views()];case 2:return e.sent(),[2]}}))}))},e.prototype.remove=function(){var e,i;try{for(var r=(0,l.__values)(this.child_views),o=r.next();!o.done;o=r.next()){o.value.remove()}}catch(t){e={error:t}}finally{try{o&&!o.done&&(i=r.return)&&i.call(r)}finally{if(e)throw e.error}}this._child_views.clear(),t.prototype.remove.call(this)},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.is_layout_root&&(this._on_resize=function(){return e.resize_layout()},window.addEventListener("resize",this._on_resize),this._parent_observer=setInterval((function(){var t=e.el.offsetParent;e._offset_parent!=t&&(e._offset_parent=t,null!=t&&(e.compute_viewport(),e.invalidate_layout()))}),250));var i=this.model.properties;this.on_change([i.width,i.height,i.min_width,i.min_height,i.max_width,i.max_height,i.margin,i.width_policy,i.height_policy,i.sizing_mode,i.aspect_ratio,i.visible],(function(){return e.invalidate_layout()})),this.on_change([i.background,i.css_classes],(function(){return e.invalidate_render()}))},e.prototype.disconnect_signals=function(){null!=this._parent_observer&&clearTimeout(this._parent_observer),null!=this._on_resize&&window.removeEventListener("resize",this._on_resize),t.prototype.disconnect_signals.call(this)},e.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat(this.model.css_classes)},Object.defineProperty(e.prototype,"child_views",{get:function(){var t=this;return this.child_models.map((function(e){return t._child_views.get(e)}))},enumerable:!1,configurable:!0}),e.prototype.build_child_views=function(){return(0,l.__awaiter)(this,void 0,void 0,(function(){return(0,l.__generator)(this,(function(t){switch(t.label){case 0:return[4,(0,p.build_views)(this._child_views,this.child_models,{parent:this})];case 1:return t.sent(),[2]}}))}))},e.prototype.render=function(){var e,i,r;t.prototype.render.call(this),(0,h.empty)(this.el);var o=this.model.background;this.el.style.backgroundColor=null!=o?(0,c.color2css)(o):"",(e=(0,h.classes)(this.el).clear()).add.apply(e,(0,l.__spreadArray)([],(0,l.__read)(this.css_classes()),!1));try{for(var n=(0,l.__values)(this.child_views),a=n.next();!a.done;a=n.next()){var s=a.value;this.el.appendChild(s.el),s.render()}}catch(t){i={error:t}}finally{try{a&&!a.done&&(r=n.return)&&r.call(n)}finally{if(i)throw i.error}}},e.prototype.update_layout=function(){var t,e;try{for(var i=(0,l.__values)(this.child_views),r=i.next();!r.done;r=i.next()){r.value.update_layout()}}catch(e){t={error:e}}finally{try{r&&!r.done&&(e=i.return)&&e.call(i)}finally{if(t)throw t.error}}this._update_layout()},e.prototype.update_position=function(){var t,e;this.el.style.display=this.model.visible?"block":"none";var i=this.is_layout_root?this.layout.sizing.margin:void 0;(0,h.position)(this.el,this.layout.bbox,i);try{for(var r=(0,l.__values)(this.child_views),o=r.next();!o.done;o=r.next()){o.value.update_position()}}catch(e){t={error:e}}finally{try{o&&!o.done&&(e=r.return)&&e.call(r)}finally{if(t)throw t.error}}},e.prototype.after_layout=function(){var t,e;try{for(var i=(0,l.__values)(this.child_views),r=i.next();!r.done;r=i.next()){r.value.after_layout()}}catch(e){t={error:e}}finally{try{r&&!r.done&&(e=i.return)&&e.call(i)}finally{if(t)throw t.error}}this._has_finished=!0},e.prototype.compute_viewport=function(){this._viewport=this._viewport_size()},e.prototype.renderTo=function(t){t.appendChild(this.el),this._offset_parent=this.el.offsetParent,this.compute_viewport(),this.build(),this.notify_finished()},e.prototype.build=function(){if(!this.is_layout_root)throw new Error(this.toString()+" is not a root layout");return this.render(),this.update_layout(),this.compute_layout(),this},e.prototype.rebuild=function(){return(0,l.__awaiter)(this,void 0,void 0,(function(){return(0,l.__generator)(this,(function(t){switch(t.label){case 0:return[4,this.build_child_views()];case 1:return t.sent(),this.invalidate_render(),[2]}}))}))},e.prototype.compute_layout=function(){var t=Date.now();this.layout.compute(this._viewport),this.update_position(),this.after_layout(),u.logger.debug("layout computed in "+(Date.now()-t)+" ms")},e.prototype.resize_layout=function(){this.root.compute_viewport(),this.root.compute_layout()},e.prototype.invalidate_layout=function(){this.root.update_layout(),this.root.compute_layout()},e.prototype.invalidate_render=function(){this.render(),this.invalidate_layout()},e.prototype.has_finished=function(){var e,i;if(!t.prototype.has_finished.call(this))return!1;try{for(var r=(0,l.__values)(this.child_views),o=r.next();!o.done;o=r.next()){if(!o.value.has_finished())return!1}}catch(t){e={error:t}}finally{try{o&&!o.done&&(i=r.return)&&i.call(r)}finally{if(e)throw e.error}}return!0},e.prototype._width_policy=function(){return null!=this.model.width?"fixed":"fit"},e.prototype._height_policy=function(){return null!=this.model.height?"fixed":"fit"},e.prototype.box_sizing=function(){var t,e=this.model,i=e.width_policy,r=e.height_policy,o=e.aspect_ratio;"auto"==i&&(i=this._width_policy()),"auto"==r&&(r=this._height_policy());var n=this.model.sizing_mode;if(null!=n)if("fixed"==n)i=r="fixed";else if("stretch_both"==n)i=r="max";else if("stretch_width"==n)i="max";else if("stretch_height"==n)r="max";else switch(null==o&&(o="auto"),n){case"scale_width":i="max",r="min";break;case"scale_height":i="min",r="max";break;case"scale_both":i="max",r="max"}var a={width_policy:i,height_policy:r},s=this.model,h=s.min_width,u=s.min_height;null!=h&&(a.min_width=h),null!=u&&(a.min_height=u);var c=this.model,d=c.width,p=c.height;null!=d&&(a.width=d),null!=p&&(a.height=p);var y=this.model,f=y.max_width,v=y.max_height;null!=f&&(a.max_width=f),null!=v&&(a.max_height=v),"auto"==o&&null!=d&&null!=p?a.aspect=d/p:(0,_.isNumber)(o)&&(a.aspect=o);var m=this.model.margin;if(null!=m)if((0,_.isNumber)(m))a.margin={top:m,right:m,bottom:m,left:m};else if(2==m.length){var g=(0,l.__read)(m,2),w=g[0],b=g[1];a.margin={top:w,right:b,bottom:w,left:b}}else{var x=(0,l.__read)(m,4),z=x[0],M=x[1],O=x[2],A=x[3];a.margin={top:z,right:M,bottom:O,left:A}}a.visible=this.model.visible;var L=this.model.align;return(0,_.isArray)(L)?(t=(0,l.__read)(L,2),a.halign=t[0],a.valign=t[1]):a.halign=a.valign=L,a},e.prototype._viewport_size=function(){var t=this;return(0,h.undisplayed)(this.el,(function(){for(var e=t.el;e=e.parentElement;)if(!e.classList.contains(v.root)){if(e==document.body){var i=(0,h.extents)(document.body).margin,r=i.left,o=i.right,n=i.top,l=i.bottom;return{width:Math.ceil(document.documentElement.clientWidth-r-o),height:Math.ceil(document.documentElement.clientHeight-n-l)}}var a=(0,h.extents)(e).padding,s=a.left,u=a.right,_=a.top,c=a.bottom,d=e.getBoundingClientRect(),p=d.width,y=d.height,f=Math.ceil(p-s-u),m=Math.ceil(y-_-c);if(f>0||m>0)return{width:f>0?f:void 0,height:m>0?m:void 0}}return{}}))},e.prototype.export=function(t,e){var i,r;void 0===e&&(e=!0);var o="png"==t?"canvas":"svg",n=new m.CanvasLayer(o,e),a=this.layout.bbox,s=a.width,h=a.height;n.resize(s,h);try{for(var u=(0,l.__values)(this.child_views),_=u.next();!_.done;_=u.next()){var c=_.value,d=c.export(t,e),p=c.layout.bbox,y=p.x,f=p.y;n.ctx.drawImage(d.canvas,y,f)}}catch(t){i={error:t}}finally{try{_&&!_.done&&(r=u.return)&&r.call(u)}finally{if(i)throw i.error}}return n},e.prototype.serializable_state=function(){return(0,l.__assign)((0,l.__assign)({},t.prototype.serializable_state.call(this)),{bbox:this.layout.bbox.box,children:this.child_views.map((function(t){return t.serializable_state()}))})},e}(y.DOMView);i.LayoutDOMView=g,g.__name__="LayoutDOMView";var w=function(t){function e(e){return t.call(this,e)||this}return(0,l.__extends)(e,t),e}(a.Model);i.LayoutDOM=w,n=w,w.__name__="LayoutDOM",n.define((function(t){var e=t.Boolean,i=t.Number,r=t.String,o=t.Auto,n=t.Color,l=t.Array,a=t.Tuple,h=t.Or,u=t.Null,_=t.Nullable,c=a(i,i),d=a(i,i,i,i);return{width:[_(i),null],height:[_(i),null],min_width:[_(i),null],min_height:[_(i),null],max_width:[_(i),null],max_height:[_(i),null],margin:[_(h(i,c,d)),[0,0,0,0]],width_policy:[h(f.SizingPolicy,o),"auto"],height_policy:[h(f.SizingPolicy,o),"auto"],aspect_ratio:[h(i,o,u),null],sizing_mode:[_(s.SizingMode),null],visible:[e,!0],disabled:[e,!1],align:[h(s.Align,a(s.Align,s.Align)),"start"],background:[_(n),null],css_classes:[l(r),[]]}}))},
function _(t,n,i,o,u){o();var e,s=t(1),l=t(423),r=t(324),a=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,s.__extends)(n,t),n.prototype._update_layout=function(){var t=this.child_views.map((function(t){return t.layout}));this.layout=new r.Column(t),this.layout.rows=this.model.rows,this.layout.spacing=[this.model.spacing,0],this.layout.set_sizing(this.box_sizing())},n}(l.BoxView);i.ColumnView=a,a.__name__="ColumnView";var _=function(t){function n(n){return t.call(this,n)||this}return(0,s.__extends)(n,t),n}(l.Box);i.Column=_,e=_,_.__name__="Column",e.prototype.default_view=a,e.define((function(t){return{rows:[t.Any,"auto"]}}))},
function _(t,e,o,n,r){n();var i,a=t(1),l=t(424),s=t(324),u=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,a.__extends)(e,t),e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this);var o=this.model.properties,n=o.children,r=o.rows,i=o.cols,a=o.spacing;this.on_change([n,r,i,a],(function(){return e.rebuild()}))},Object.defineProperty(e.prototype,"child_models",{get:function(){return this.model.children.map((function(t){return(0,a.__read)(t,1)[0]}))},enumerable:!1,configurable:!0}),e.prototype._update_layout=function(){var t,e;this.layout=new s.Grid,this.layout.rows=this.model.rows,this.layout.cols=this.model.cols,this.layout.spacing=this.model.spacing;try{for(var o=(0,a.__values)(this.model.children),n=o.next();!n.done;n=o.next()){var r=(0,a.__read)(n.value,5),i=r[0],l=r[1],u=r[2],c=r[3],_=r[4],h=this._child_views.get(i);this.layout.items.push({layout:h.layout,row:l,col:u,row_span:c,col_span:_})}}catch(e){t={error:e}}finally{try{n&&!n.done&&(e=o.return)&&e.call(o)}finally{if(t)throw t.error}}this.layout.set_sizing(this.box_sizing())},e}(l.LayoutDOMView);o.GridBoxView=u,u.__name__="GridBoxView";var c=function(t){function e(e){return t.call(this,e)||this}return(0,a.__extends)(e,t),e}(l.LayoutDOM);o.GridBox=c,i=c,c.__name__="GridBox",i.prototype.default_view=u,i.define((function(t){var e=t.Any,o=t.Int,n=t.Number,r=t.Tuple,i=t.Array,a=t.Ref,s=t.Or,u=t.Opt;return{children:[i(r(a(l.LayoutDOM),o,o,u(o),u(o))),[]],rows:[e,"auto"],cols:[e,"auto"],spacing:[s(n,r(n,n)),0]}}))},
function _(t,n,e,o,i){o();var u=t(1),r=t(424),_=t(322),a=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,u.__extends)(n,t),Object.defineProperty(n.prototype,"child_models",{get:function(){return[]},enumerable:!1,configurable:!0}),n.prototype._update_layout=function(){this.layout=new _.ContentBox(this.el),this.layout.set_sizing(this.box_sizing())},n}(r.LayoutDOMView);e.HTMLBoxView=a,a.__name__="HTMLBoxView";var s=function(t){function n(n){return t.call(this,n)||this}return(0,u.__extends)(n,t),n}(r.LayoutDOM);e.HTMLBox=s,s.__name__="HTMLBox"},
function _(n,e,t,i,l){i();var a,o=n(1),r=n(168),u=n(424),c=function(n){function e(e){return n.call(this,e)||this}return(0,o.__extends)(e,n),e}(r.Model);t.Panel=c,a=c,c.__name__="Panel",a.define((function(n){var e=n.Boolean;return{title:[n.String,""],child:[(0,n.Ref)(u.LayoutDOM)],closable:[e,!1],disabled:[e,!1]}}))},
function _(t,n,i,o,e){o();var u,s=t(1),a=t(423),_=t(324),l=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,s.__extends)(n,t),n.prototype._update_layout=function(){var t=this.child_views.map((function(t){return t.layout}));this.layout=new _.Row(t),this.layout.cols=this.model.cols,this.layout.spacing=[0,this.model.spacing],this.layout.set_sizing(this.box_sizing())},n}(a.BoxView);i.RowView=l,l.__name__="RowView";var r=function(t){function n(n){return t.call(this,n)||this}return(0,s.__extends)(n,t),n}(a.Box);i.Row=r,u=r,r.__name__="Row",u.prototype.default_view=l,u.define((function(t){return{cols:[t.Any,"auto"]}}))},
function _(t,e,n,i,o){i();var r,u=t(1),a=t(424),_=t(322),c=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,u.__extends)(e,t),Object.defineProperty(e.prototype,"child_models",{get:function(){return[]},enumerable:!1,configurable:!0}),e.prototype._update_layout=function(){this.layout=new _.LayoutItem,this.layout.set_sizing(this.box_sizing())},e}(a.LayoutDOMView);n.SpacerView=c,c.__name__="SpacerView";var p=function(t){function e(e){return t.call(this,e)||this}return(0,u.__extends)(e,t),e}(a.LayoutDOM);n.Spacer=p,r=p,p.__name__="Spacer",r.prototype.default_view=c},
function _(e,t,i,r,l){r();var s,a=e(1),o=e(322),n=e(158),h=e(126),d=e(117),c=e(135),_=e(424),u=e(428),p=(0,a.__importStar)(e(432)),v=p,f=(0,a.__importStar)(e(433)),b=f,y=(0,a.__importStar)(e(344)),m=y,g=function(e){function t(){var t=e.apply(this,(0,a.__spreadArray)([],(0,a.__read)(arguments),!1))||this;return t._scroll_index=0,t}return(0,a.__extends)(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.tabs.change,(function(){return t.rebuild()})),this.connect(this.model.properties.active.change,(function(){return t.on_active_change()}))},t.prototype.styles=function(){return(0,a.__spreadArray)((0,a.__spreadArray)([],(0,a.__read)(e.prototype.styles.call(this)),!1),[f.default,y.default,p.default],!1)},Object.defineProperty(t.prototype,"child_models",{get:function(){return this.model.tabs.map((function(e){return e.child}))},enumerable:!1,configurable:!0}),t.prototype._update_layout=function(){var e=this.model.tabs_location,t="above"==e||"below"==e,i=this.scroll_el,r=this.headers_el;this.header=new(function(e){function l(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(l,e),l.prototype._measure=function(l){var s=(0,n.size)(i),a=(0,n.children)(r).slice(0,3).map((function(e){return(0,n.size)(e)})),o=e.prototype._measure.call(this,l),d=o.width,c=o.height;if(t){var _=s.width+(0,h.sum)(a.map((function(e){return e.width})));return{width:l.width!=1/0?l.width:_,height:c}}var u=s.height+(0,h.sum)(a.map((function(e){return e.height})));return{width:d,height:l.height!=1/0?l.height:u}},l}(o.ContentBox))(this.header_el),t?this.header.set_sizing({width_policy:"fit",height_policy:"fixed"}):this.header.set_sizing({width_policy:"fixed",height_policy:"fit"});var l=1,s=1;switch(e){case"above":l-=1;break;case"below":l+=1;break;case"left":s-=1;break;case"right":s+=1}var d={layout:this.header,row:l,col:s},c=this.child_views.map((function(e){return{layout:e.layout,row:1,col:1}}));this.layout=new o.Grid((0,a.__spreadArray)([d],(0,a.__read)(c),!1)),this.layout.set_sizing(this.box_sizing())},t.prototype.update_position=function(){var t,i;e.prototype.update_position.call(this),this.header_el.style.position="absolute",(0,n.position)(this.header_el,this.header.bbox);var r=this.model.tabs_location,l="above"==r||"below"==r,s=(0,n.size)(this.scroll_el),o=(0,n.scroll_size)(this.headers_el);if(l){var h=this.header.bbox.width;o.width>h?(this.wrapper_el.style.maxWidth=h-s.width+"px",(0,n.display)(this.scroll_el),this.do_scroll(this.model.active)):(this.wrapper_el.style.maxWidth="",(0,n.undisplay)(this.scroll_el))}else{var d=this.header.bbox.height;o.height>d?(this.wrapper_el.style.maxHeight=d-s.height+"px",(0,n.display)(this.scroll_el),this.do_scroll(this.model.active)):(this.wrapper_el.style.maxHeight="",(0,n.undisplay)(this.scroll_el))}var c=this.child_views;try{for(var _=(0,a.__values)(c),u=_.next();!u.done;u=_.next()){var p=u.value;(0,n.hide)(p.el)}}catch(e){t={error:e}}finally{try{u&&!u.done&&(i=_.return)&&i.call(_)}finally{if(t)throw t.error}}var v=c[this.model.active];null!=v&&(0,n.show)(v.el)},t.prototype.render=function(){var t=this;e.prototype.render.call(this);var i=this.model.active,r=this.model.tabs.map((function(e,r){var l=(0,n.div)({class:[v.tab,r==i?v.active:null]},e.title);if(l.addEventListener("click",(function(e){t.model.disabled||e.target==e.currentTarget&&t.change_active(r)})),e.closable){var s=(0,n.div)({class:v.close});s.addEventListener("click",(function(e){if(e.target==e.currentTarget){t.model.tabs=(0,h.remove_at)(t.model.tabs,r);var i=t.model.tabs.length;t.model.active>i-1&&(t.model.active=i-1)}})),l.appendChild(s)}return(t.model.disabled||e.disabled)&&l.classList.add(v.disabled),l}));this.headers_el=(0,n.div)({class:[v.headers]},r),this.wrapper_el=(0,n.div)({class:v.headers_wrapper},this.headers_el),this.left_el=(0,n.div)({class:[b.btn,b.btn_default],disabled:""},(0,n.div)({class:[m.caret,v.left]})),this.right_el=(0,n.div)({class:[b.btn,b.btn_default]},(0,n.div)({class:[m.caret,v.right]})),this.left_el.addEventListener("click",(function(){return t.do_scroll("left")})),this.right_el.addEventListener("click",(function(){return t.do_scroll("right")})),this.scroll_el=(0,n.div)({class:b.btn_group},this.left_el,this.right_el);var l=this.model.tabs_location;this.header_el=(0,n.div)({class:[v.tabs_header,v[l]]},this.scroll_el,this.wrapper_el),this.el.appendChild(this.header_el)},t.prototype.do_scroll=function(e){var t=this.model.tabs.length;"left"==e?this._scroll_index-=1:"right"==e?this._scroll_index+=1:this._scroll_index=e,this._scroll_index=(0,d.clamp)(this._scroll_index,0,t-1),0==this._scroll_index?this.left_el.setAttribute("disabled",""):this.left_el.removeAttribute("disabled"),this._scroll_index==t-1?this.right_el.setAttribute("disabled",""):this.right_el.removeAttribute("disabled");var i=(0,n.children)(this.headers_el).slice(0,this._scroll_index).map((function(e){return e.getBoundingClientRect()})),r=this.model.tabs_location;if("above"==r||"below"==r){var l=-(0,h.sum)(i.map((function(e){return e.width})));this.headers_el.style.left=l+"px"}else{var s=-(0,h.sum)(i.map((function(e){return e.height})));this.headers_el.style.top=s+"px"}},t.prototype.change_active=function(e){e!=this.model.active&&(this.model.active=e)},t.prototype.on_active_change=function(){var e,t,i,r,l=this.model.active,s=(0,n.children)(this.headers_el);try{for(var o=(0,a.__values)(s),h=o.next();!h.done;h=o.next()){h.value.classList.remove(v.active)}}catch(t){e={error:t}}finally{try{h&&!h.done&&(t=o.return)&&t.call(o)}finally{if(e)throw e.error}}s[l].classList.add(v.active);var d=this.child_views;try{for(var c=(0,a.__values)(d),_=c.next();!_.done;_=c.next()){var u=_.value;(0,n.hide)(u.el)}}catch(e){i={error:e}}finally{try{_&&!_.done&&(r=c.return)&&r.call(c)}finally{if(i)throw i.error}}(0,n.show)(d[l].el)},t}(_.LayoutDOMView);i.TabsView=g,g.__name__="TabsView";var w=function(e){function t(t){return e.call(this,t)||this}return(0,a.__extends)(t,e),t}(_.LayoutDOM);i.Tabs=w,s=w,w.__name__="Tabs",s.prototype.default_view=g,s.define((function(e){var t=e.Int;return{tabs:[(0,e.Array)((0,e.Ref)(u.Panel)),[]],tabs_location:[c.Location,"above"],active:[t,0]}}))},
function _(e,r,b,o,t){o(),b.root="bk-root",b.tabs_header="bk-tabs-header",b.btn_group="bk-btn-group",b.btn="bk-btn",b.headers_wrapper="bk-headers-wrapper",b.above="bk-above",b.right="bk-right",b.below="bk-below",b.left="bk-left",b.headers="bk-headers",b.tab="bk-tab",b.active="bk-active",b.close="bk-close",b.disabled="bk-disabled",b.default='.bk-root .bk-tabs-header{display:flex;flex-wrap:nowrap;align-items:center;overflow:hidden;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;}.bk-root .bk-tabs-header .bk-btn-group{height:auto;margin-right:5px;}.bk-root .bk-tabs-header .bk-btn-group > .bk-btn{flex-grow:0;height:auto;padding:4px 4px;}.bk-root .bk-tabs-header .bk-headers-wrapper{flex-grow:1;overflow:hidden;color:#666666;}.bk-root .bk-tabs-header.bk-above .bk-headers-wrapper{border-bottom:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-right .bk-headers-wrapper{border-left:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-below .bk-headers-wrapper{border-top:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-left .bk-headers-wrapper{border-right:1px solid #e6e6e6;}.bk-root .bk-tabs-header.bk-above,.bk-root .bk-tabs-header.bk-below{flex-direction:row;}.bk-root .bk-tabs-header.bk-above .bk-headers,.bk-root .bk-tabs-header.bk-below .bk-headers{flex-direction:row;}.bk-root .bk-tabs-header.bk-left,.bk-root .bk-tabs-header.bk-right{flex-direction:column;}.bk-root .bk-tabs-header.bk-left .bk-headers,.bk-root .bk-tabs-header.bk-right .bk-headers{flex-direction:column;}.bk-root .bk-tabs-header .bk-headers{position:relative;display:flex;flex-wrap:nowrap;align-items:center;}.bk-root .bk-tabs-header .bk-tab{padding:4px 8px;border:solid transparent;white-space:nowrap;cursor:pointer;}.bk-root .bk-tabs-header .bk-tab:hover{background-color:#f2f2f2;}.bk-root .bk-tabs-header .bk-tab.bk-active{color:#4d4d4d;background-color:white;border-color:#e6e6e6;}.bk-root .bk-tabs-header .bk-tab .bk-close{margin-left:10px;}.bk-root .bk-tabs-header .bk-tab.bk-disabled{cursor:not-allowed;pointer-events:none;opacity:0.65;}.bk-root .bk-tabs-header.bk-above .bk-tab{border-width:3px 1px 0px 1px;border-radius:4px 4px 0 0;}.bk-root .bk-tabs-header.bk-right .bk-tab{border-width:1px 3px 1px 0px;border-radius:0 4px 4px 0;}.bk-root .bk-tabs-header.bk-below .bk-tab{border-width:0px 1px 3px 1px;border-radius:0 0 4px 4px;}.bk-root .bk-tabs-header.bk-left .bk-tab{border-width:1px 0px 1px 3px;border-radius:4px 0 0 4px;}.bk-root .bk-close{display:inline-block;width:10px;height:10px;vertical-align:middle;background-image:url(\'data:image/svg+xml;utf8,      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">        <line x1="1" y1="9" x2="9" y2="1" stroke="gray" stroke-width="2"/>        <line x1="1" y1="1" x2="9" y2="9" stroke="gray" stroke-width="2"/>      </svg>\');}.bk-root .bk-close:hover{background-image:url(\'data:image/svg+xml;utf8,      <svg viewPort="0 0 10 10" version="1.1" xmlns="http://www.w3.org/2000/svg">        <line x1="1" y1="9" x2="9" y2="1" stroke="red" stroke-width="2"/>        <line x1="1" y1="1" x2="9" y2="9" stroke="red" stroke-width="2"/>      </svg>\');}'},
function _(o,b,r,t,e){t(),r.root="bk-root",r.btn="bk-btn",r.active="bk-active",r.btn_default="bk-btn-default",r.btn_primary="bk-btn-primary",r.btn_success="bk-btn-success",r.btn_warning="bk-btn-warning",r.btn_danger="bk-btn-danger",r.btn_light="bk-btn-light",r.btn_group="bk-btn-group",r.vertical="bk-vertical",r.horizontal="bk-horizontal",r.dropdown_toggle="bk-dropdown-toggle",r.default=".bk-root .bk-btn{height:100%;display:inline-block;text-align:center;vertical-align:middle;white-space:nowrap;cursor:pointer;padding:6px 12px;font-size:12px;border:1px solid transparent;border-radius:4px;outline:0;user-select:none;-ms-user-select:none;-moz-user-select:none;-webkit-user-select:none;}.bk-root .bk-btn:hover,.bk-root .bk-btn:focus{text-decoration:none;}.bk-root .bk-btn:active,.bk-root .bk-btn.bk-active{background-image:none;box-shadow:inset 0 3px 5px rgba(0, 0, 0, 0.125);}.bk-root .bk-btn[disabled]{cursor:not-allowed;pointer-events:none;opacity:0.65;box-shadow:none;}.bk-root .bk-btn-default{color:#333;background-color:#fff;border-color:#ccc;}.bk-root .bk-btn-default:hover{background-color:#f5f5f5;border-color:#b8b8b8;}.bk-root .bk-btn-default.bk-active{background-color:#ebebeb;border-color:#adadad;}.bk-root .bk-btn-default[disabled],.bk-root .bk-btn-default[disabled]:hover,.bk-root .bk-btn-default[disabled]:focus,.bk-root .bk-btn-default[disabled]:active,.bk-root .bk-btn-default[disabled].bk-active{background-color:#e6e6e6;border-color:#ccc;}.bk-root .bk-btn-primary{color:#fff;background-color:#428bca;border-color:#357ebd;}.bk-root .bk-btn-primary:hover{background-color:#3681c1;border-color:#2c699e;}.bk-root .bk-btn-primary.bk-active{background-color:#3276b1;border-color:#285e8e;}.bk-root .bk-btn-primary[disabled],.bk-root .bk-btn-primary[disabled]:hover,.bk-root .bk-btn-primary[disabled]:focus,.bk-root .bk-btn-primary[disabled]:active,.bk-root .bk-btn-primary[disabled].bk-active{background-color:#506f89;border-color:#357ebd;}.bk-root .bk-btn-success{color:#fff;background-color:#5cb85c;border-color:#4cae4c;}.bk-root .bk-btn-success:hover{background-color:#4eb24e;border-color:#409240;}.bk-root .bk-btn-success.bk-active{background-color:#47a447;border-color:#398439;}.bk-root .bk-btn-success[disabled],.bk-root .bk-btn-success[disabled]:hover,.bk-root .bk-btn-success[disabled]:focus,.bk-root .bk-btn-success[disabled]:active,.bk-root .bk-btn-success[disabled].bk-active{background-color:#667b66;border-color:#4cae4c;}.bk-root .bk-btn-warning{color:#fff;background-color:#f0ad4e;border-color:#eea236;}.bk-root .bk-btn-warning:hover{background-color:#eea43b;border-color:#e89014;}.bk-root .bk-btn-warning.bk-active{background-color:#ed9c28;border-color:#d58512;}.bk-root .bk-btn-warning[disabled],.bk-root .bk-btn-warning[disabled]:hover,.bk-root .bk-btn-warning[disabled]:focus,.bk-root .bk-btn-warning[disabled]:active,.bk-root .bk-btn-warning[disabled].bk-active{background-color:#c89143;border-color:#eea236;}.bk-root .bk-btn-danger{color:#fff;background-color:#d9534f;border-color:#d43f3a;}.bk-root .bk-btn-danger:hover{background-color:#d5433e;border-color:#bd2d29;}.bk-root .bk-btn-danger.bk-active{background-color:#d2322d;border-color:#ac2925;}.bk-root .bk-btn-danger[disabled],.bk-root .bk-btn-danger[disabled]:hover,.bk-root .bk-btn-danger[disabled]:focus,.bk-root .bk-btn-danger[disabled]:active,.bk-root .bk-btn-danger[disabled].bk-active{background-color:#a55350;border-color:#d43f3a;}.bk-root .bk-btn-light{color:#333;background-color:#fff;border-color:#ccc;border-color:transparent;}.bk-root .bk-btn-light:hover{background-color:#f5f5f5;border-color:#b8b8b8;}.bk-root .bk-btn-light.bk-active{background-color:#ebebeb;border-color:#adadad;}.bk-root .bk-btn-light[disabled],.bk-root .bk-btn-light[disabled]:hover,.bk-root .bk-btn-light[disabled]:focus,.bk-root .bk-btn-light[disabled]:active,.bk-root .bk-btn-light[disabled].bk-active{background-color:#e6e6e6;border-color:#ccc;}.bk-root .bk-btn-group{height:100%;display:flex;flex-wrap:nowrap;align-items:center;}.bk-root .bk-btn-group:not(.bk-vertical),.bk-root .bk-btn-group.bk-horizontal{flex-direction:row;}.bk-root .bk-btn-group.bk-vertical{flex-direction:column;}.bk-root .bk-btn-group > .bk-btn{flex-grow:1;}.bk-root .bk-btn-group:not(.bk-vertical) > .bk-btn + .bk-btn{margin-left:-1px;}.bk-root .bk-btn-group.bk-vertical > .bk-btn + .bk-btn{margin-top:-1px;}.bk-root .bk-btn-group:not(.bk-vertical) > .bk-btn:first-child:not(:last-child){border-bottom-right-radius:0;border-top-right-radius:0;}.bk-root .bk-btn-group.bk-vertical > .bk-btn:first-child:not(:last-child){border-bottom-left-radius:0;border-bottom-right-radius:0;}.bk-root .bk-btn-group:not(.bk-vertical) > .bk-btn:not(:first-child):last-child{border-bottom-left-radius:0;border-top-left-radius:0;}.bk-root .bk-btn-group.bk-vertical > .bk-btn:not(:first-child):last-child{border-top-left-radius:0;border-top-right-radius:0;}.bk-root .bk-btn-group > .bk-btn:not(:first-child):not(:last-child){border-radius:0;}.bk-root .bk-btn-group.bk-vertical > .bk-btn{width:100%;}.bk-root .bk-btn-group .bk-dropdown-toggle{flex:0 0 0;padding:6px 6px;}"},
function _(t,n,e,i,_){i();var o,u=t(1),r=t(425),l=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,u.__extends)(n,t),n}(r.ColumnView);e.WidgetBoxView=l,l.__name__="WidgetBoxView";var a=function(t){function n(n){return t.call(this,n)||this}return(0,u.__extends)(n,t),n}(r.Column);e.WidgetBox=a,o=a,a.__name__="WidgetBox",o.prototype.default_view=l},
function _(t,a,i,e,M){e();var T=t(250);M("MathText",T.MathText),M("Ascii",T.Ascii),M("MathML",T.MathML),M("TeX",T.TeX),M("PlainText",t(254).PlainText)},
function _(r,o,t,e,n){e(),n("CustomJSTransform",r(437).CustomJSTransform),n("Dodge",r(438).Dodge),n("Interpolator",r(440).Interpolator),n("Jitter",r(441).Jitter),n("LinearInterpolator",r(442).LinearInterpolator),n("StepInterpolator",r(443).StepInterpolator),n("Transform",r(171).Transform)},
function _(r,e,t,n,a){n();var o,s=r(1),u=r(171),i=r(128),_=r(149),c=function(r){function e(e){return r.call(this,e)||this}return(0,s.__extends)(e,r),Object.defineProperty(e.prototype,"names",{get:function(){return(0,i.keys)(this.args)},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"values",{get:function(){return(0,i.values)(this.args)},enumerable:!1,configurable:!0}),e.prototype._make_transform=function(r,e){return new(Function.bind.apply(Function,(0,s.__spreadArray)((0,s.__spreadArray)([void 0],(0,s.__read)(this.names),!1),[r,(0,_.use_strict)(e)],!1)))},Object.defineProperty(e.prototype,"scalar_transform",{get:function(){return this._make_transform("x",this.func)},enumerable:!1,configurable:!0}),Object.defineProperty(e.prototype,"vector_transform",{get:function(){return this._make_transform("xs",this.v_func)},enumerable:!1,configurable:!0}),e.prototype.compute=function(r){return this.scalar_transform.apply(this,(0,s.__spreadArray)((0,s.__spreadArray)([],(0,s.__read)(this.values),!1),[r],!1))},e.prototype.v_compute=function(r){return this.vector_transform.apply(this,(0,s.__spreadArray)((0,s.__spreadArray)([],(0,s.__read)(this.values),!1),[r],!1))},e}(u.Transform);t.CustomJSTransform=c,o=c,c.__name__="CustomJSTransform",o.define((function(r){var e=r.Unknown,t=r.String;return{args:[(0,r.Dict)(e),{}],func:[t,""],v_func:[t,""]}}))},
function _(n,e,t,r,u){r();var o,i=n(1),_=function(n){function e(e){return n.call(this,e)||this}return(0,i.__extends)(e,n),e.prototype._compute=function(n){return n+this.value},e}(n(439).RangeTransform);t.Dodge=_,o=_,_.__name__="Dodge",o.define((function(n){return{value:[n.Number,0]}}))},
function _(n,e,t,r,a){r();var i,o=n(1),u=n(171),c=n(172),s=n(182),f=n(139),h=n(125),_=n(127),g=function(n){function e(e){return n.call(this,e)||this}return(0,o.__extends)(e,n),e.prototype.v_compute=function(n){var e;this.range instanceof s.FactorRange?e=this.range.v_synthetic(n):(0,h.isArrayableOf)(n,h.isNumber)?e=n:(0,_.unreachable)();for(var t=new((0,f.infer_type)(e))(e.length),r=0;r<e.length;r++){var a=e[r];t[r]=this._compute(a)}return t},e.prototype.compute=function(n){return this.range instanceof s.FactorRange?this._compute(this.range.synthetic(n)):(0,h.isNumber)(n)?this._compute(n):void(0,_.unreachable)()},e}(u.Transform);t.RangeTransform=g,i=g,g.__name__="RangeTransform",i.define((function(n){var e=n.Ref;return{range:[(0,n.Nullable)(e(c.Range)),null]}}))},
function _(t,r,e,n,o){n();var i,a=t(1),s=t(171),h=t(185),d=t(139),l=t(126),u=t(125),c=function(t){function r(r){var e=t.call(this,r)||this;return e._sorted_dirty=!0,e}return(0,a.__extends)(r,t),r.prototype.connect_signals=function(){var r=this;t.prototype.connect_signals.call(this),this.connect(this.change,(function(){return r._sorted_dirty=!0}))},r.prototype.v_compute=function(t){for(var r=new((0,d.infer_type)(t))(t.length),e=0;e<t.length;e++){var n=t[e];r[e]=this.compute(n)}return r},r.prototype.sort=function(t){if(void 0===t&&(t=!1),this._sorted_dirty){var r,e;if((0,u.isString)(this.x)&&(0,u.isString)(this.y)&&null!=this.data){var n=this.data.columns();if(!(0,l.includes)(n,this.x))throw new Error("The x parameter does not correspond to a valid column name defined in the data parameter");if(!(0,l.includes)(n,this.y))throw new Error("The y parameter does not correspond to a valid column name defined in the data parameter");r=this.data.get_column(this.x),e=this.data.get_column(this.y)}else{if(!(0,u.isArray)(this.x)||!(0,u.isArray)(this.y))throw new Error("parameters 'x' and 'y' must be both either string fields or arrays");r=this.x,e=this.y}if(r.length!==e.length)throw new Error("The length for x and y do not match");if(r.length<2)throw new Error("x and y must have at least two elements to support interpolation");for(var o=r.length,i=new Uint32Array(o),a=0;a<o;a++)i[a]=a;var s=t?-1:1;i.sort((function(t,e){return s*(r[t]-r[e])})),this._x_sorted=new((0,d.infer_type)(r))(o),this._y_sorted=new((0,d.infer_type)(e))(o);for(a=0;a<o;a++)this._x_sorted[a]=r[i[a]],this._y_sorted[a]=e[i[a]];this._sorted_dirty=!1}},r}(s.Transform);e.Interpolator=c,i=c,c.__name__="Interpolator",i.define((function(t){var r=t.Boolean,e=t.Number,n=t.String,o=t.Ref,i=t.Array,a=t.Or,s=t.Nullable;return{x:[a(n,i(e))],y:[a(n,i(e))],data:[s(o(h.ColumnarDataSource)),null],clip:[r,!0]}}))},
function _(t,i,r,n,e){n();var s,o=t(1),u=t(439),a=t(182),f=t(135),h=t(125),c=t(116),m=(0,o.__importStar)(t(117)),_=t(127),p=function(t){function i(i){return t.call(this,i)||this}return(0,o.__extends)(i,t),i.prototype.v_compute=function(t){var i,r,n=this;this.range instanceof a.FactorRange?r=this.range.v_synthetic(t):(0,h.isArrayableOf)(t,h.isNumber)?r=t:(0,_.unreachable)();var e=r.length;(null===(i=this.previous_offsets)||void 0===i?void 0:i.length)!=e&&(this.previous_offsets=new Array(e),this.previous_offsets=(0,c.map)(this.previous_offsets,(function(){return n._compute()})));var s=this.previous_offsets;return(0,c.map)(r,(function(t,i){return s[i]+t}))},i.prototype._compute=function(){switch(this.distribution){case"uniform":return this.mean+(m.random()-.5)*this.width;case"normal":return m.rnorm(this.mean,this.width)}},i}(u.RangeTransform);r.Jitter=p,s=p,p.__name__="Jitter",s.define((function(t){var i=t.Number;return{mean:[i,0],width:[i,1],distribution:[f.Distribution,"uniform"]}}))},
function _(t,r,_,e,s){e();var i=t(1),o=t(126),n=function(t){function r(r){return t.call(this,r)||this}return(0,i.__extends)(r,t),r.prototype.compute=function(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}if(t==this._x_sorted[0])return this._y_sorted[0];var r=(0,o.find_last_index)(this._x_sorted,(function(r){return r<t})),_=this._x_sorted[r],e=this._x_sorted[r+1],s=this._y_sorted[r],i=this._y_sorted[r+1];return s+(t-_)/(e-_)*(i-s)},r}(t(440).Interpolator);_.LinearInterpolator=n,n.__name__="LinearInterpolator"},
function _(t,e,r,n,i){n();var o,s=t(1),_=t(440),d=t(135),h=t(126),a=function(t){function e(e){return t.call(this,e)||this}return(0,s.__extends)(e,t),e.prototype.compute=function(t){if(this.sort(!1),this.clip){if(t<this._x_sorted[0]||t>this._x_sorted[this._x_sorted.length-1])return NaN}else{if(t<this._x_sorted[0])return this._y_sorted[0];if(t>this._x_sorted[this._x_sorted.length-1])return this._y_sorted[this._y_sorted.length-1]}var e;switch(this.mode){case"after":e=(0,h.find_last_index)(this._x_sorted,(function(e){return t>=e}));break;case"before":e=(0,h.find_index)(this._x_sorted,(function(e){return t<=e}));break;case"center":var r=(0,h.map)(this._x_sorted,(function(e){return Math.abs(e-t)})),n=(0,h.min)(r);e=(0,h.find_index)(r,(function(t){return n===t}));break;default:throw new Error("unknown mode: "+this.mode)}return-1!=e?this._y_sorted[e]:NaN},e}(_.Interpolator);r.StepInterpolator=a,o=a,a.__name__="StepInterpolator",o.define((function(){return{mode:[d.StepMode,"after"]}}))},
function _(p,o,t,a,n){a(),n("MapOptions",p(445).MapOptions),n("GMapOptions",p(445).GMapOptions),n("GMapPlot",p(445).GMapPlot),n("Plot",p(446).Plot)},
function _(n,t,e,r,a){r();var i,o,_,u=n(1),p=n(446),l=n(168),s=n(173),c=n(451);a("GMapPlotView",c.GMapPlotView);var f=function(n){function t(t){return n.call(this,t)||this}return(0,u.__extends)(t,n),t}(l.Model);e.MapOptions=f,i=f,f.__name__="MapOptions",i.define((function(n){var t=n.Int,e=n.Number;return{lat:[e],lng:[e],zoom:[t,12]}}));var d=function(n){function t(t){return n.call(this,t)||this}return(0,u.__extends)(t,n),t}(f);e.GMapOptions=d,o=d,d.__name__="GMapOptions",o.define((function(n){var t=n.Boolean,e=n.Int,r=n.String;return{map_type:[r,"roadmap"],scale_control:[t,!1],styles:[r],tilt:[e,45]}}));var v=function(n){function t(t){var e=n.call(this,t)||this;return e.use_map=!0,e}return(0,u.__extends)(t,n),t}(p.Plot);e.GMapPlot=v,_=v,v.__name__="GMapPlot",_.prototype.default_view=c.GMapPlotView,_.define((function(n){var t=n.String;return{map_options:[(0,n.Ref)(d)],api_key:[t],api_version:[t,"3.43"]}})),_.override({x_range:function(){return new s.Range1d},y_range:function(){return new s.Range1d}})},
function _(e,t,r,n,o){n();var i,a=e(1),l=(0,a.__importStar)(e(163)),_=(0,a.__importStar)(e(133)),s=e(130),c=e(135),u=e(126),d=e(128),h=e(125),f=e(424),p=e(243),y=e(421),g=e(155),v=e(233),b=e(174),w=e(336),x=e(172),m=e(170),A=e(190),S=e(156),R=e(291),P=e(290),D=e(178),L=e(447);o("PlotView",L.PlotView);var O=function(e){function t(t){var r=e.call(this,t)||this;return r.use_map=!1,r}return(0,a.__extends)(t,e),t.prototype._doc_attached=function(){e.prototype._doc_attached.call(this),this._push_changes([[this.properties.inner_height,null,this.inner_height],[this.properties.inner_width,null,this.inner_width]])},t.prototype.initialize=function(){var t,r,n,o;e.prototype.initialize.call(this),this.reset=new s.Signal0(this,"reset");try{for(var i=(0,a.__values)((0,d.values)(this.extra_x_ranges).concat(this.x_range)),l=i.next();!l.done;l=i.next()){var _=l.value,c=_.plots;(0,h.isArray)(c)&&(c=c.concat(this),_.setv({plots:c},{silent:!0}))}}catch(e){t={error:e}}finally{try{l&&!l.done&&(r=i.return)&&r.call(i)}finally{if(t)throw t.error}}try{for(var u=(0,a.__values)((0,d.values)(this.extra_y_ranges).concat(this.y_range)),f=u.next();!f.done;f=u.next()){var p=f.value;c=p.plots;(0,h.isArray)(c)&&(c=c.concat(this),p.setv({plots:c},{silent:!0}))}}catch(e){n={error:e}}finally{try{f&&!f.done&&(o=u.return)&&o.call(u)}finally{if(n)throw n.error}}},t.prototype.add_layout=function(e,t){var r;void 0===t&&(t="center");var n=this.properties[t].get_value();this.setv(((r={})[t]=(0,a.__spreadArray)((0,a.__spreadArray)([],(0,a.__read)(n),!1),[e],!1),r))},t.prototype.remove_layout=function(e){var t=function(t){(0,u.remove_by)(t,(function(t){return t==e}))};t(this.left),t(this.right),t(this.above),t(this.below),t(this.center)},Object.defineProperty(t.prototype,"data_renderers",{get:function(){return this.renderers.filter((function(e){return e instanceof R.DataRenderer}))},enumerable:!1,configurable:!0}),t.prototype.add_renderers=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];this.renderers=this.renderers.concat(e)},t.prototype.add_glyph=function(e,t,r){void 0===t&&(t=new A.ColumnDataSource),void 0===r&&(r={});var n=new P.GlyphRenderer((0,a.__assign)((0,a.__assign)({},r),{data_source:t,glyph:e}));return this.add_renderers(n),n},t.prototype.add_tools=function(){for(var e=[],t=0;t<arguments.length;t++)e[t]=arguments[t];this.toolbar.tools=this.toolbar.tools.concat(e)},Object.defineProperty(t.prototype,"panels",{get:function(){return(0,a.__spreadArray)((0,a.__spreadArray)([],(0,a.__read)(this.side_panels),!1),(0,a.__read)(this.center),!1)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"side_panels",{get:function(){var e=this,t=e.above,r=e.below,n=e.left,o=e.right;return(0,u.concat)([t,r,n,o])},enumerable:!1,configurable:!0}),t}(f.LayoutDOM);r.Plot=O,i=O,O.__name__="Plot",i.prototype.default_view=L.PlotView,i.mixins([["outline_",l.Line],["background_",l.Fill],["border_",l.Fill]]),i.define((function(e){var t=e.Boolean,r=e.Number,n=e.String,o=e.Array,i=e.Dict,a=e.Or,l=e.Ref,s=e.Null,u=e.Nullable;return{toolbar:[l(w.Toolbar),function(){return new w.Toolbar}],toolbar_location:[u(c.Location),"right"],toolbar_sticky:[t,!0],plot_width:[_.Alias("width")],plot_height:[_.Alias("height")],frame_width:[u(r),null],frame_height:[u(r),null],title:[a(l(v.Title),n,s),"",{convert:function(e){return(0,h.isString)(e)?new v.Title({text:e}):e}}],title_location:[u(c.Location),"above"],above:[o(a(l(g.Annotation),l(p.Axis))),[]],below:[o(a(l(g.Annotation),l(p.Axis))),[]],left:[o(a(l(g.Annotation),l(p.Axis))),[]],right:[o(a(l(g.Annotation),l(p.Axis))),[]],center:[o(a(l(g.Annotation),l(y.Grid))),[]],renderers:[o(l(S.Renderer)),[]],x_range:[l(x.Range),function(){return new D.DataRange1d}],y_range:[l(x.Range),function(){return new D.DataRange1d}],x_scale:[l(m.Scale),function(){return new b.LinearScale}],y_scale:[l(m.Scale),function(){return new b.LinearScale}],extra_x_ranges:[i(l(x.Range)),{}],extra_y_ranges:[i(l(x.Range)),{}],extra_x_scales:[i(l(m.Scale)),{}],extra_y_scales:[i(l(m.Scale)),{}],lod_factor:[r,10],lod_interval:[r,300],lod_threshold:[u(r),2e3],lod_timeout:[r,500],hidpi:[t,!0],output_backend:[c.OutputBackend,"canvas"],min_border:[u(r),5],min_border_top:[u(r),null],min_border_left:[u(r),null],min_border_bottom:[u(r),null],min_border_right:[u(r),null],inner_width:[r,0],inner_height:[r,0],outer_width:[r,0],outer_height:[r,0],match_aspect:[t,!1],aspect_scale:[r,1],reset_policy:[c.ResetPolicy,"standard"]}})),i.override({width:600,height:600,outline_line_color:"#e5e5e5",border_fill_color:"#ffffff",background_fill_color:"#ffffff"})},
function _(e,t,i,r,n){r();var a=e(1),o=e(241),s=e(364),l=e(424),_=e(155),u=e(233),h=e(243),c=e(335),d=e(366),p=e(228),v=e(160),y=e(134),f=e(366),b=e(448),g=e(125),w=e(126),m=e(350),x=e(323),z=e(326),k=e(324),P=e(238),q=e(180),M=e(449),A=e(450),R=e(143),V=function(e){function t(){var t=e.apply(this,(0,a.__spreadArray)([],(0,a.__read)(arguments),!1))||this;return t._outer_bbox=new q.BBox,t._inner_bbox=new q.BBox,t._needs_paint=!0,t._needs_layout=!1,t._invalidated_painters=new Set,t._invalidate_all=!0,t._needs_notify=!1,t}return(0,a.__extends)(t,e),Object.defineProperty(t.prototype,"canvas",{get:function(){return this.canvas_view},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"state",{get:function(){return this._state_manager},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"invalidate_dataranges",{set:function(e){this._range_manager.invalidate_dataranges=e},enumerable:!1,configurable:!0}),t.prototype.renderer_view=function(e){var t,i,r=this.renderer_views.get(e);if(null==r)try{for(var n=(0,a.__values)(this.renderer_views),o=n.next();!o.done;o=n.next()){var s=(0,a.__read)(o.value,2)[1].renderer_view(e);if(null!=s)return s}}catch(e){t={error:e}}finally{try{o&&!o.done&&(i=n.return)&&i.call(n)}finally{if(t)throw t.error}}return r},Object.defineProperty(t.prototype,"is_paused",{get:function(){return null!=this._is_paused&&0!==this._is_paused},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"child_models",{get:function(){return[]},enumerable:!1,configurable:!0}),t.prototype.pause=function(){null==this._is_paused?this._is_paused=1:this._is_paused+=1},t.prototype.unpause=function(e){if(void 0===e&&(e=!1),null==this._is_paused)throw new Error("wasn't paused");this._is_paused-=1,0!=this._is_paused||e||this.request_paint("everything")},t.prototype.notify_finished_after_paint=function(){this._needs_notify=!0},t.prototype.request_render=function(){this.request_paint("everything")},t.prototype.request_paint=function(e){this.invalidate_painters(e),this.schedule_paint()},t.prototype.invalidate_painters=function(e){var t,i;if("everything"==e)this._invalidate_all=!0;else if((0,g.isArray)(e))try{for(var r=(0,a.__values)(e),n=r.next();!n.done;n=r.next()){var o=n.value;this._invalidated_painters.add(o)}}catch(e){t={error:e}}finally{try{n&&!n.done&&(i=r.return)&&i.call(r)}finally{if(t)throw t.error}}else this._invalidated_painters.add(e)},t.prototype.schedule_paint=function(){if(!this.is_paused){var e=this.throttled_paint();this._ready=this._ready.then((function(){return e}))}},t.prototype.request_layout=function(){this._needs_layout=!0,this.request_paint("everything")},t.prototype.reset=function(){"standard"==this.model.reset_policy&&(this.state.clear(),this.reset_range(),this.reset_selection()),this.model.trigger_event(new d.Reset)},t.prototype.remove=function(){(0,p.remove_views)(this.renderer_views),(0,p.remove_views)(this.tool_views),this.canvas_view.remove(),e.prototype.remove.call(this)},t.prototype.render=function(){e.prototype.render.call(this),this.el.appendChild(this.canvas_view.el),this.canvas_view.render()},t.prototype.initialize=function(){var t=this;this.pause(),e.prototype.initialize.call(this),this.lod_started=!1,this.visuals=new v.Visuals(this),this._initial_state={selection:new Map,dimensions:{width:0,height:0}},this.visibility_callbacks=[],this.renderer_views=new Map,this.tool_views=new Map,this.frame=new o.CartesianFrame(this.model.x_scale,this.model.y_scale,this.model.x_range,this.model.y_range,this.model.extra_x_ranges,this.model.extra_y_ranges,this.model.extra_x_scales,this.model.extra_y_scales),this._range_manager=new M.RangeManager(this),this._state_manager=new A.StateManager(this,this._initial_state),this.throttled_paint=(0,b.throttle)((function(){return t.repaint()}),1e3/60);var i=this.model,r=i.title_location,n=i.title;null!=r&&null!=n&&(this._title=n instanceof u.Title?n:new u.Title({text:n}));var a=this.model,s=a.toolbar_location,l=a.toolbar;null!=s&&null!=l&&(this._toolbar=new c.ToolbarPanel({toolbar:l}),l.toolbar_location=s)},t.prototype.lazy_initialize=function(){return(0,a.__awaiter)(this,void 0,void 0,(function(){var t,i,r,n,o;return(0,a.__generator)(this,(function(a){switch(a.label){case 0:return[4,e.prototype.lazy_initialize.call(this)];case 1:return a.sent(),t=this.model,i=t.hidpi,r=t.output_backend,n=new s.Canvas({hidpi:i,output_backend:r}),o=this,[4,(0,p.build_view)(n,{parent:this})];case 2:return o.canvas_view=a.sent(),this.canvas_view.plot_views=[this],[4,this.build_renderer_views()];case 3:return a.sent(),[4,this.build_tool_views()];case 4:return a.sent(),this._range_manager.update_dataranges(),this.unpause(!0),y.logger.debug("PlotView initialized"),[2]}}))}))},t.prototype._width_policy=function(){return null==this.model.frame_width?e.prototype._width_policy.call(this):"min"},t.prototype._height_policy=function(){return null==this.model.frame_height?e.prototype._height_policy.call(this):"min"},t.prototype._update_layout=function(){var e,t,i,r,n,o=this;this.layout=new z.BorderLayout,this.layout.set_sizing(this.box_sizing());var s=(0,w.copy)(this.model.above),l=(0,w.copy)(this.model.below),h=(0,w.copy)(this.model.left),d=(0,w.copy)(this.model.right),p=function(e){switch(e){case"above":return s;case"below":return l;case"left":return h;case"right":return d}},v=this.model,y=v.title_location,f=v.title;null!=y&&null!=f&&p(y).push(this._title);var b=this.model,m=b.toolbar_location,q=b.toolbar;if(null!=m&&null!=q){var M=p(m),A=!0;if(this.model.toolbar_sticky)for(var R=0;R<M.length;R++){var V=M[R];if(V instanceof u.Title){M[R]="above"==m||"below"==m?[V,this._toolbar]:[this._toolbar,V],A=!1;break}}A&&M.push(this._toolbar)}var S=function(e,t){var i,r=o.renderer_view(t);return r.panel=new P.Panel(e),null===(i=r.update_layout)||void 0===i||i.call(r),r.layout},O=function(e,t){var i,r,n="above"==e||"below"==e,o=[];try{for(var s=(0,a.__values)(t),l=s.next();!l.done;l=s.next()){var _=l.value;if((0,g.isArray)(_)){var u=_.map((function(t){var i,r=S(e,t);if(t instanceof c.ToolbarPanel){var o=n?"width_policy":"height_policy";r.set_sizing((0,a.__assign)((0,a.__assign)({},r.sizing),((i={})[o]="min",i)))}return r})),h=void 0;n?(h=new k.Row(u)).set_sizing({width_policy:"max",height_policy:"min"}):(h=new k.Column(u)).set_sizing({width_policy:"min",height_policy:"max"}),h.absolute=!0,o.push(h)}else o.push(S(e,_))}}catch(e){i={error:e}}finally{try{l&&!l.done&&(r=s.return)&&r.call(s)}finally{if(i)throw i.error}}return o},j=null!==(e=this.model.min_border)&&void 0!==e?e:0;this.layout.min_border={left:null!==(t=this.model.min_border_left)&&void 0!==t?t:j,top:null!==(i=this.model.min_border_top)&&void 0!==i?i:j,right:null!==(r=this.model.min_border_right)&&void 0!==r?r:j,bottom:null!==(n=this.model.min_border_bottom)&&void 0!==n?n:j};var T=new x.NodeLayout,B=new x.VStack,C=new x.VStack,L=new x.HStack,H=new x.HStack;T.absolute=!0,B.absolute=!0,C.absolute=!0,L.absolute=!0,H.absolute=!0,T.children=this.model.center.filter((function(e){return e instanceof _.Annotation})).map((function(e){var t,i=o.renderer_view(e);return null===(t=i.update_layout)||void 0===t||t.call(i),i.layout})).filter((function(e){return null!=e}));var D=this.model,E=D.frame_width,F=D.frame_height;T.set_sizing((0,a.__assign)((0,a.__assign)({},null!=E?{width_policy:"fixed",width:E}:{width_policy:"fit"}),null!=F?{height_policy:"fixed",height:F}:{height_policy:"fit"})),T.on_resize((function(e){return o.frame.set_geometry(e)})),B.children=(0,w.reversed)(O("above",s)),C.children=O("below",l),L.children=(0,w.reversed)(O("left",h)),H.children=O("right",d),B.set_sizing({width_policy:"fit",height_policy:"min"}),C.set_sizing({width_policy:"fit",height_policy:"min"}),L.set_sizing({width_policy:"min",height_policy:"fit"}),H.set_sizing({width_policy:"min",height_policy:"fit"}),this.layout.center_panel=T,this.layout.top_panel=B,this.layout.bottom_panel=C,this.layout.left_panel=L,this.layout.right_panel=H},Object.defineProperty(t.prototype,"axis_views",{get:function(){var e,t,i=[];try{for(var r=(0,a.__values)(this.renderer_views),n=r.next();!n.done;n=r.next()){var o=(0,a.__read)(n.value,2)[1];o instanceof h.AxisView&&i.push(o)}}catch(t){e={error:t}}finally{try{n&&!n.done&&(t=r.return)&&t.call(r)}finally{if(e)throw e.error}}return i},enumerable:!1,configurable:!0}),t.prototype.set_toolbar_visibility=function(e){var t,i;try{for(var r=(0,a.__values)(this.visibility_callbacks),n=r.next();!n.done;n=r.next()){(0,n.value)(e)}}catch(e){t={error:e}}finally{try{n&&!n.done&&(i=r.return)&&i.call(r)}finally{if(t)throw t.error}}},t.prototype.update_range=function(e,t){this.pause(),this._range_manager.update(e,t),this.unpause()},t.prototype.reset_range=function(){this.update_range(null),this.trigger_ranges_update_event()},t.prototype.trigger_ranges_update_event=function(){var e=this.model,t=e.x_range,i=e.y_range;this.model.trigger_event(new f.RangesUpdate(t.start,t.end,i.start,i.end))},t.prototype.get_selection=function(){var e,t,i=new Map;try{for(var r=(0,a.__values)(this.model.data_renderers),n=r.next();!n.done;n=r.next()){var o=n.value,s=o.selection_manager.source.selected;i.set(o,s)}}catch(t){e={error:t}}finally{try{n&&!n.done&&(t=r.return)&&t.call(r)}finally{if(e)throw e.error}}return i},t.prototype.update_selection=function(e){var t,i;try{for(var r=(0,a.__values)(this.model.data_renderers),n=r.next();!n.done;n=r.next()){var o=n.value,s=o.selection_manager.source;if(null!=e){var l=e.get(o);null!=l&&s.selected.update(l,!0)}else s.selection_manager.clear()}}catch(e){t={error:e}}finally{try{n&&!n.done&&(i=r.return)&&i.call(r)}finally{if(t)throw t.error}}},t.prototype.reset_selection=function(){this.update_selection(null)},t.prototype._invalidate_layout=function(){var e=this;(function(){var t,i,r;try{for(var n=(0,a.__values)(e.model.side_panels),o=n.next();!o.done;o=n.next()){var s=o.value,l=e.renderer_views.get(s);if(null===(r=l.layout)||void 0===r?void 0:r.has_size_changed())return e.invalidate_painters(l),!0}}catch(e){t={error:e}}finally{try{o&&!o.done&&(i=n.return)&&i.call(n)}finally{if(t)throw t.error}}return!1})()&&this.root.compute_layout()},t.prototype.get_renderer_views=function(){var e=this;return this.computed_renderers.map((function(t){return e.renderer_views.get(t)}))},t.prototype._compute_renderers=function(){var e,t,i,r,n,o,s,l,_,u,h,c,d;return(0,a.__generator)(this,(function(p){switch(p.label){case 0:return e=this.model,t=e.above,i=e.below,r=e.left,n=e.right,o=e.center,s=e.renderers,[5,(0,a.__values)(s)];case 1:return p.sent(),[5,(0,a.__values)(t)];case 2:return p.sent(),[5,(0,a.__values)(i)];case 3:return p.sent(),[5,(0,a.__values)(r)];case 4:return p.sent(),[5,(0,a.__values)(n)];case 5:return p.sent(),[5,(0,a.__values)(o)];case 6:return p.sent(),null==this._title?[3,8]:[4,this._title];case 7:p.sent(),p.label=8;case 8:return null==this._toolbar?[3,10]:[4,this._toolbar];case 9:p.sent(),p.label=10;case 10:p.trys.push([10,17,18,19]),l=(0,a.__values)(this.model.toolbar.tools),_=l.next(),p.label=11;case 11:return _.done?[3,16]:null==(u=_.value).overlay?[3,13]:[4,u.overlay];case 12:p.sent(),p.label=13;case 13:return[5,(0,a.__values)(u.synthetic_renderers)];case 14:p.sent(),p.label=15;case 15:return _=l.next(),[3,11];case 16:return[3,19];case 17:return h=p.sent(),c={error:h},[3,19];case 18:try{_&&!_.done&&(d=l.return)&&d.call(l)}finally{if(c)throw c.error}return[7];case 19:return[2]}}))},t.prototype.build_renderer_views=function(){return(0,a.__awaiter)(this,void 0,void 0,(function(){return(0,a.__generator)(this,(function(e){switch(e.label){case 0:return this.computed_renderers=(0,a.__spreadArray)([],(0,a.__read)(this._compute_renderers()),!1),[4,(0,p.build_views)(this.renderer_views,this.computed_renderers,{parent:this})];case 1:return e.sent(),[2]}}))}))},t.prototype.build_tool_views=function(){return(0,a.__awaiter)(this,void 0,void 0,(function(){var e,t=this;return(0,a.__generator)(this,(function(i){switch(i.label){case 0:return e=this.model.toolbar.tools,[4,(0,p.build_views)(this.tool_views,e,{parent:this})];case 1:return i.sent().map((function(e){return t.canvas_view.ui_event_bus.register_tool(e)})),[2]}}))}))},t.prototype.connect_signals=function(){var t,i,r,n,o=this;e.prototype.connect_signals.call(this);var s=this.frame,l=s.x_ranges,_=s.y_ranges;try{for(var u=(0,a.__values)(l),h=u.next();!h.done;h=u.next()){var c=(0,a.__read)(h.value,2)[1];this.connect(c.change,(function(){o._needs_layout=!0,o.request_paint("everything")}))}}catch(e){t={error:e}}finally{try{h&&!h.done&&(i=u.return)&&i.call(u)}finally{if(t)throw t.error}}try{for(var d=(0,a.__values)(_),p=d.next();!p.done;p=d.next()){c=(0,a.__read)(p.value,2)[1];this.connect(c.change,(function(){o._needs_layout=!0,o.request_paint("everything")}))}}catch(e){r={error:e}}finally{try{p&&!p.done&&(n=d.return)&&n.call(d)}finally{if(r)throw r.error}}var v=this.model.properties,y=v.above,f=v.below,b=v.left,g=v.right,w=v.center,m=v.renderers;this.on_change([y,f,b,g,w,m],(function(){return(0,a.__awaiter)(o,void 0,void 0,(function(){return(0,a.__generator)(this,(function(e){switch(e.label){case 0:return[4,this.build_renderer_views()];case 1:return[2,e.sent()]}}))}))})),this.connect(this.model.toolbar.properties.tools.change,(function(){return(0,a.__awaiter)(o,void 0,void 0,(function(){return(0,a.__generator)(this,(function(e){switch(e.label){case 0:return[4,this.build_renderer_views()];case 1:return e.sent(),[4,this.build_tool_views()];case 2:return e.sent(),[2]}}))}))})),this.connect(this.model.change,(function(){return o.request_paint("everything")})),this.connect(this.model.reset,(function(){return o.reset()}))},t.prototype.has_finished=function(){var t,i;if(!e.prototype.has_finished.call(this))return!1;if(this.model.visible)try{for(var r=(0,a.__values)(this.renderer_views),n=r.next();!n.done;n=r.next()){if(!(0,a.__read)(n.value,2)[1].has_finished())return!1}}catch(e){t={error:e}}finally{try{n&&!n.done&&(i=r.return)&&i.call(r)}finally{if(t)throw t.error}}return!0},t.prototype.after_layout=function(){var t,i,r;e.prototype.after_layout.call(this);try{for(var n=(0,a.__values)(this.renderer_views),o=n.next();!o.done;o=n.next()){var s=(0,a.__read)(o.value,2)[1];s instanceof _.AnnotationView&&(null===(r=s.after_layout)||void 0===r||r.call(s))}}catch(e){t={error:e}}finally{try{o&&!o.done&&(i=n.return)&&i.call(n)}finally{if(t)throw t.error}}if(this._needs_layout=!1,this.model.setv({inner_width:Math.round(this.frame.bbox.width),inner_height:Math.round(this.frame.bbox.height),outer_width:Math.round(this.layout.bbox.width),outer_height:Math.round(this.layout.bbox.height)},{no_change:!0}),!1!==this.model.match_aspect&&(this.pause(),this._range_manager.update_dataranges(),this.unpause(!0)),!this._outer_bbox.equals(this.layout.bbox)){var l=this.layout.bbox,u=l.width,h=l.height;this.canvas_view.resize(u,h),this._outer_bbox=this.layout.bbox,this._invalidate_all=!0,this._needs_paint=!0}var c=this.layout.inner_bbox;this._inner_bbox.equals(c)||(this._inner_bbox=c,this._needs_paint=!0),this._needs_paint&&this.paint()},t.prototype.repaint=function(){this._needs_layout&&this._invalidate_layout(),this.paint()},t.prototype.paint=function(){this.is_paused||(this.model.visible&&(y.logger.trace(this.toString()+".paint()"),this._actual_paint()),this._needs_notify&&(this._needs_notify=!1,this.notify_finished()))},t.prototype._actual_paint=function(){var e,t,i,r=this,n=this.model.document;if(null!=n){var o=n.interactive_duration();o>=0&&o<this.model.lod_interval?setTimeout((function(){n.interactive_duration()>r.model.lod_timeout&&n.interactive_stop(),r.request_paint("everything")}),this.model.lod_timeout):n.interactive_stop()}this._range_manager.invalidate_dataranges&&(this._range_manager.update_dataranges(),this._invalidate_layout());var s=!1,l=!1;if(this._invalidate_all)s=!0,l=!0;else try{for(var _=(0,a.__values)(this._invalidated_painters),u=_.next();!u.done;u=_.next()){if("overlay"!=u.value.model.level?s=!0:l=!0,s&&l)break}}catch(t){e={error:t}}finally{try{u&&!u.done&&(t=_.return)&&t.call(_)}finally{if(e)throw e.error}}this._invalidated_painters.clear(),this._invalidate_all=!1;var h=[this.frame.bbox.left,this.frame.bbox.top,this.frame.bbox.width,this.frame.bbox.height],c=this.canvas_view,d=c.primary,p=c.overlays;s&&(d.prepare(),this.canvas_view.prepare_webgl(h),this._map_hook(d.ctx,h),this._paint_empty(d.ctx,h),this._paint_outline(d.ctx,h),this._paint_levels(d.ctx,"image",h,!0),this._paint_levels(d.ctx,"underlay",h,!0),this._paint_levels(d.ctx,"glyph",h,!0),this._paint_levels(d.ctx,"guide",h,!1),this._paint_levels(d.ctx,"annotation",h,!1),d.finish()),(l||R.settings.wireframe)&&(p.prepare(),this._paint_levels(p.ctx,"overlay",h,!1),R.settings.wireframe&&this._paint_layout(p.ctx,this.layout),p.finish()),null==this._initial_state.range&&(this._initial_state.range=null!==(i=this._range_manager.compute_initial())&&void 0!==i?i:void 0),this._needs_paint=!1},t.prototype._paint_levels=function(e,t,i,r){var n,o;try{for(var s=(0,a.__values)(this.computed_renderers),l=s.next();!l.done;l=s.next()){var _=l.value;if(_.level==t){var u=this.renderer_views.get(_);e.save(),(r||u.needs_clip)&&(e.beginPath(),e.rect.apply(e,(0,a.__spreadArray)([],(0,a.__read)(i),!1)),e.clip()),u.render(),e.restore(),u.has_webgl&&u.needs_webgl_blit&&this.canvas_view.blit_webgl(e)}}}catch(e){n={error:e}}finally{try{l&&!l.done&&(o=s.return)&&o.call(s)}finally{if(n)throw n.error}}},t.prototype._paint_layout=function(e,t){var i,r,n=t.bbox,o=n.x,s=n.y,l=n.width,_=n.height;e.strokeStyle="blue",e.strokeRect(o,s,l,_);try{for(var u=(0,a.__values)(t),h=u.next();!h.done;h=u.next()){var c=h.value;e.save(),t.absolute||e.translate(o,s),this._paint_layout(e,c),e.restore()}}catch(e){i={error:e}}finally{try{h&&!h.done&&(r=u.return)&&r.call(u)}finally{if(i)throw i.error}}},t.prototype._map_hook=function(e,t){},t.prototype._paint_empty=function(e,t){var i=(0,a.__read)([0,0,this.layout.bbox.width,this.layout.bbox.height],4),r=i[0],n=i[1],o=i[2],s=i[3],l=(0,a.__read)(t,4),_=l[0],u=l[1],h=l[2],c=l[3];this.visuals.border_fill.doit&&(this.visuals.border_fill.set_value(e),e.fillRect(r,n,o,s),e.clearRect(_,u,h,c)),this.visuals.background_fill.doit&&(this.visuals.background_fill.set_value(e),e.fillRect(_,u,h,c))},t.prototype._paint_outline=function(e,t){if(this.visuals.outline_line.doit){e.save(),this.visuals.outline_line.set_value(e);var i=(0,a.__read)(t,4),r=i[0],n=i[1],o=i[2],s=i[3];r+o==this.layout.bbox.width&&(o-=1),n+s==this.layout.bbox.height&&(s-=1),e.strokeRect(r,n,o,s),e.restore()}},t.prototype.to_blob=function(){return this.canvas_view.to_blob()},t.prototype.export=function(e,t){void 0===t&&(t=!0);var i="png"==e?"canvas":"svg",r=new m.CanvasLayer(i,t),n=this.layout.bbox,a=n.width,o=n.height;r.resize(a,o);var s=this.canvas_view.compose().canvas;return r.ctx.drawImage(s,0,0),r},t.prototype.serializable_state=function(){var t=e.prototype.serializable_state.call(this),i=t.children,r=(0,a.__rest)(t,["children"]),n=this.get_renderer_views().map((function(e){return e.serializable_state()})).filter((function(e){return null!=e.bbox}));return(0,a.__assign)((0,a.__assign)({},r),{children:(0,a.__spreadArray)((0,a.__spreadArray)([],(0,a.__read)(null!=i?i:[]),!1),(0,a.__read)(n),!1)})},t}(l.LayoutDOMView);i.PlotView=V,V.__name__="PlotView"},
function _(n,t,e,r,u){r(),e.throttle=function(n,t){var e=null,r=0,u=!1;return function(){return new Promise((function(o,i){var a=function(){r=Date.now(),e=null,u=!1;try{n(),o()}catch(n){i(n)}},c=Date.now(),l=t-(c-r);l<=0&&!u?(null!=e&&clearTimeout(e),u=!0,requestAnimationFrame(a)):e||u?o():e=setTimeout((function(){return requestAnimationFrame(a)}),l)}))}}},
function _(r,e,a,t,n){t();var l=r(1),o=r(178),i=r(134),s=function(){function r(r){this.parent=r,this.invalidate_dataranges=!0}return Object.defineProperty(r.prototype,"frame",{get:function(){return this.parent.frame},enumerable:!1,configurable:!0}),r.prototype.update=function(r,e){var a,t,n,o,i,s,_,u,d=this.frame,f=d.x_ranges,v=d.y_ranges;if(null==r){try{for(var y=(0,l.__values)(f),c=y.next();!c.done;c=y.next()){(M=(0,l.__read)(c.value,2)[1]).reset()}}catch(r){a={error:r}}finally{try{c&&!c.done&&(t=y.return)&&t.call(y)}finally{if(a)throw a.error}}try{for(var h=(0,l.__values)(v),g=h.next();!g.done;g=h.next()){(M=(0,l.__read)(g.value,2)[1]).reset()}}catch(r){n={error:r}}finally{try{g&&!g.done&&(o=h.return)&&o.call(h)}finally{if(n)throw n.error}}this.update_dataranges()}else{var p=[];try{for(var x=(0,l.__values)(f),w=x.next();!w.done;w=x.next()){var b=(0,l.__read)(w.value,2),m=b[0],M=b[1];p.push([M,r.xrs.get(m)])}}catch(r){i={error:r}}finally{try{w&&!w.done&&(s=x.return)&&s.call(x)}finally{if(i)throw i.error}}try{for(var R=(0,l.__values)(v),D=R.next();!D.done;D=R.next()){var N=(0,l.__read)(D.value,2);m=N[0],M=N[1];p.push([M,r.yrs.get(m)])}}catch(r){_={error:r}}finally{try{D&&!D.done&&(u=R.return)&&u.call(R)}finally{if(_)throw _.error}}(null==e?void 0:e.scrolling)&&this._update_ranges_together(p),this._update_ranges_individually(p,e)}},r.prototype.reset=function(){this.update(null)},r.prototype._update_dataranges=function(r){var e,a,t,n,s,_,u,d,f,v,y,c,h,g,p=new Map,x=new Map,w=!1;try{for(var b=(0,l.__values)(r.x_ranges),m=b.next();!m.done;m=b.next()){(L=(0,l.__read)(m.value,2)[1])instanceof o.DataRange1d&&"log"==L.scale_hint&&(w=!0)}}catch(r){e={error:r}}finally{try{m&&!m.done&&(a=b.return)&&a.call(b)}finally{if(e)throw e.error}}try{for(var M=(0,l.__values)(r.y_ranges),R=M.next();!R.done;R=M.next()){(T=(0,l.__read)(R.value,2)[1])instanceof o.DataRange1d&&"log"==T.scale_hint&&(w=!0)}}catch(r){t={error:r}}finally{try{R&&!R.done&&(n=M.return)&&n.call(M)}finally{if(t)throw t.error}}try{for(var D=(0,l.__values)(this.parent.model.data_renderers),N=D.next();!N.done;N=D.next()){var k=N.value,j=this.parent.renderer_view(k);if(null!=j){var F=j.glyph_view.bounds();if(null!=F&&p.set(k,F),w){var O=j.glyph_view.log_bounds();null!=O&&x.set(k,O)}}}}catch(r){s={error:r}}finally{try{N&&!N.done&&(_=D.return)&&_.call(D)}finally{if(s)throw s.error}}var P,q=!1,z=!1,A=r.x_target.span,B=r.y_target.span;!1!==this.parent.model.match_aspect&&0!=A&&0!=B&&(P=1/this.parent.model.aspect_scale*(A/B));try{for(var C=(0,l.__values)(r.x_ranges),E=C.next();!E.done;E=C.next()){if((L=(0,l.__read)(E.value,2)[1])instanceof o.DataRange1d){var G="log"==L.scale_hint?x:p;L.update(G,0,this.parent.model,P),L.follow&&(q=!0)}null!=L.bounds&&(z=!0)}}catch(r){u={error:r}}finally{try{E&&!E.done&&(d=C.return)&&d.call(C)}finally{if(u)throw u.error}}try{for(var H=(0,l.__values)(r.y_ranges),I=H.next();!I.done;I=H.next()){if((T=(0,l.__read)(I.value,2)[1])instanceof o.DataRange1d){G="log"==T.scale_hint?x:p;T.update(G,1,this.parent.model,P),T.follow&&(q=!0)}null!=T.bounds&&(z=!0)}}catch(r){f={error:r}}finally{try{I&&!I.done&&(v=H.return)&&v.call(H)}finally{if(f)throw f.error}}if(q&&z){i.logger.warn("Follow enabled so bounds are unset.");try{for(var J=(0,l.__values)(r.x_ranges),K=J.next();!K.done;K=J.next()){var L;(L=(0,l.__read)(K.value,2)[1]).bounds=null}}catch(r){y={error:r}}finally{try{K&&!K.done&&(c=J.return)&&c.call(J)}finally{if(y)throw y.error}}try{for(var Q=(0,l.__values)(r.y_ranges),S=Q.next();!S.done;S=Q.next()){var T;(T=(0,l.__read)(S.value,2)[1]).bounds=null}}catch(r){h={error:r}}finally{try{S&&!S.done&&(g=Q.return)&&g.call(Q)}finally{if(h)throw h.error}}}},r.prototype.update_dataranges=function(){var r,e;this._update_dataranges(this.frame);try{for(var a=(0,l.__values)(this.parent.model.renderers),t=a.next();!t.done;t=a.next()){var n=t.value.coordinates;null!=n&&this._update_dataranges(n)}}catch(e){r={error:e}}finally{try{t&&!t.done&&(e=a.return)&&e.call(a)}finally{if(r)throw r.error}}null!=this.compute_initial()&&(this.invalidate_dataranges=!1)},r.prototype.compute_initial=function(){var r,e,a,t,n=!0,o=this.frame,s=o.x_ranges,_=o.y_ranges,u=new Map,d=new Map;try{for(var f=(0,l.__values)(s),v=f.next();!v.done;v=f.next()){var y=(0,l.__read)(v.value,2),c=y[0],h=(w=y[1]).start,g=w.end;if(null==h||null==g||isNaN(h+g)){n=!1;break}u.set(c,{start:h,end:g})}}catch(e){r={error:e}}finally{try{v&&!v.done&&(e=f.return)&&e.call(f)}finally{if(r)throw r.error}}if(n)try{for(var p=(0,l.__values)(_),x=p.next();!x.done;x=p.next()){var w,b=(0,l.__read)(x.value,2);c=b[0],h=(w=b[1]).start,g=w.end;if(null==h||null==g||isNaN(h+g)){n=!1;break}d.set(c,{start:h,end:g})}}catch(r){a={error:r}}finally{try{x&&!x.done&&(t=p.return)&&t.call(p)}finally{if(a)throw a.error}}return n?{xrs:u,yrs:d}:(i.logger.warn("could not set initial ranges"),null)},r.prototype._update_ranges_together=function(r){var e,a,t,n,o=1;try{for(var i=(0,l.__values)(r),s=i.next();!s.done;s=i.next()){var _=(0,l.__read)(s.value,2),u=_[0],d=_[1];o=Math.min(o,this._get_weight_to_constrain_interval(u,d))}}catch(r){e={error:r}}finally{try{s&&!s.done&&(a=i.return)&&a.call(i)}finally{if(e)throw e.error}}if(o<1)try{for(var f=(0,l.__values)(r),v=f.next();!v.done;v=f.next()){var y=(0,l.__read)(v.value,2);u=y[0];(d=y[1]).start=o*d.start+(1-o)*u.start,d.end=o*d.end+(1-o)*u.end}}catch(r){t={error:r}}finally{try{v&&!v.done&&(n=f.return)&&n.call(f)}finally{if(t)throw t.error}}},r.prototype._update_ranges_individually=function(r,e){var a,t,n,o,i=!!(null==e?void 0:e.panning),s=!!(null==e?void 0:e.scrolling),_=!1;try{for(var u=(0,l.__values)(r),d=u.next();!d.done;d=u.next()){var f=(0,l.__read)(d.value,2),v=f[0],y=f[1];if(!s){var c=this._get_weight_to_constrain_interval(v,y);c<1&&(y.start=c*y.start+(1-c)*v.start,y.end=c*y.end+(1-c)*v.end)}if(null!=v.bounds&&"auto"!=v.bounds){var h=(0,l.__read)(v.bounds,2),g=h[0],p=h[1],x=Math.abs(y.end-y.start);v.is_reversed?(null!=g&&g>=y.end&&(_=!0,y.end=g,(i||s)&&(y.start=g+x)),null!=p&&p<=y.start&&(_=!0,y.start=p,(i||s)&&(y.end=p-x))):(null!=g&&g>=y.start&&(_=!0,y.start=g,(i||s)&&(y.end=g+x)),null!=p&&p<=y.end&&(_=!0,y.end=p,(i||s)&&(y.start=p-x)))}}}catch(r){a={error:r}}finally{try{d&&!d.done&&(t=u.return)&&t.call(u)}finally{if(a)throw a.error}}if(!(s&&_&&(null==e?void 0:e.maintain_focus)))try{for(var w=(0,l.__values)(r),b=w.next();!b.done;b=w.next()){var m=(0,l.__read)(b.value,2);v=m[0],y=m[1];v.have_updated_interactively=!0,v.start==y.start&&v.end==y.end||v.setv(y)}}catch(r){n={error:r}}finally{try{b&&!b.done&&(o=w.return)&&o.call(w)}finally{if(n)throw n.error}}},r.prototype._get_weight_to_constrain_interval=function(r,e){var a=r.min_interval,t=r.max_interval;if(null!=r.bounds&&"auto"!=r.bounds){var n=(0,l.__read)(r.bounds,2),o=n[0],i=n[1];if(null!=o&&null!=i){var s=Math.abs(i-o);t=null!=t?Math.min(t,s):s}}var _=1;if(null!=a||null!=t){var u=Math.abs(r.end-r.start),d=Math.abs(e.end-e.start);null!=a&&a>0&&d<a&&(_=(u-a)/(u-d)),null!=t&&t>0&&d>t&&(_=(t-u)/(d-u)),_=Math.max(0,Math.min(1,_))}return _},r}();a.RangeManager=s,s.__name__="RangeManager"},
function _(t,e,i,n,s){n();var h=t(1),r=t(130),a=function(){function t(t,e){this.parent=t,this.initial_state=e,this.changed=new r.Signal0(this.parent,"state_changed"),this.history=[],this.index=-1}return t.prototype._do_state_change=function(t){var e=null!=this.history[t]?this.history[t].state:this.initial_state;return null!=e.range&&this.parent.update_range(e.range),null!=e.selection&&this.parent.update_selection(e.selection),e},t.prototype.push=function(t,e){var i=this.history,n=this.index,s=null!=i[n]?i[n].state:{},r=(0,h.__assign)((0,h.__assign)((0,h.__assign)({},this.initial_state),s),e);this.history=this.history.slice(0,this.index+1),this.history.push({type:t,state:r}),this.index=this.history.length-1,this.changed.emit()},t.prototype.clear=function(){this.history=[],this.index=-1,this.changed.emit()},t.prototype.undo=function(){if(this.can_undo){this.index-=1;var t=this._do_state_change(this.index);return this.changed.emit(),t}return null},t.prototype.redo=function(){if(this.can_redo){this.index+=1;var t=this._do_state_change(this.index);return this.changed.emit(),t}return null},Object.defineProperty(t.prototype,"can_undo",{get:function(){return this.index>=0},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"can_redo",{get:function(){return this.index<this.history.length-1},enumerable:!1,configurable:!0}),t}();i.StateManager=a,a.__name__="StateManager"},
function _(t,e,o,i,n){i();var s=t(1),a=t(134),p=t(130),l=t(158),_=t(193),r=t(137),h=t(447),d=new p.Signal0({},"gmaps_ready"),m=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,s.__extends)(e,t),e.prototype.initialize=function(){var e=this;this.pause(),t.prototype.initialize.call(this),this._tiles_loaded=!1,this.zoom_count=0;var o=this.model.map_options,i=o.zoom,n=o.lat,s=o.lng;if(this.initial_zoom=i,this.initial_lat=n,this.initial_lng=s,!this.model.api_key){a.logger.error("api_key is required. See https://developers.google.com/maps/documentation/javascript/get-api-key for more information on how to obtain your own.")}if("undefined"==typeof google||null==google.maps){if(void 0===window._bokeh_gmaps_callback){var p=this.model;!function(t,e){window._bokeh_gmaps_callback=function(){return d.emit()};var o=encodeURIComponent,i=document.createElement("script");i.type="text/javascript",i.src="https://maps.googleapis.com/maps/api/js?v="+o(e)+"&key="+o(t)+"&callback=_bokeh_gmaps_callback",document.body.appendChild(i)}(p.api_key,p.api_version)}d.connect((function(){return e.request_paint("everything")}))}this.unpause()},e.prototype.remove=function(){(0,l.remove)(this.map_el),t.prototype.remove.call(this)},e.prototype.update_range=function(e,o){var i,n;if(null==e)this.map.setCenter({lat:this.initial_lat,lng:this.initial_lng}),this.map.setOptions({zoom:this.initial_zoom}),t.prototype.update_range.call(this,null,o);else if(null!=e.sdx||null!=e.sdy)this.map.panBy(null!==(i=e.sdx)&&void 0!==i?i:0,null!==(n=e.sdy)&&void 0!==n?n:0),t.prototype.update_range.call(this,e,o);else if(null!=e.factor){if(10!==this.zoom_count)return void(this.zoom_count+=1);this.zoom_count=0,this.pause(),t.prototype.update_range.call(this,e,o);var a=e.factor<0?-1:1,p=this.map.getZoom();if(null!=p){var l=p+a;if(l>=2){this.map.setZoom(l);var _=(0,s.__read)(this._get_projected_bounds(),2),r=_[0];_[1]-r<0&&this.map.setZoom(p)}}this.unpause()}this._set_bokeh_ranges()},e.prototype._build_map=function(){var t=this,e=google.maps;this.map_types={satellite:e.MapTypeId.SATELLITE,terrain:e.MapTypeId.TERRAIN,roadmap:e.MapTypeId.ROADMAP,hybrid:e.MapTypeId.HYBRID};var o=this.model.map_options,i={center:new e.LatLng(o.lat,o.lng),zoom:o.zoom,disableDefaultUI:!0,mapTypeId:this.map_types[o.map_type],scaleControl:o.scale_control,tilt:o.tilt};null!=o.styles&&(i.styles=JSON.parse(o.styles)),this.map_el=(0,l.div)({style:{position:"absolute"}}),this.canvas_view.add_underlay(this.map_el),this.map=new e.Map(this.map_el,i),e.event.addListener(this.map,"idle",(function(){return t._set_bokeh_ranges()})),e.event.addListener(this.map,"bounds_changed",(function(){return t._set_bokeh_ranges()})),e.event.addListenerOnce(this.map,"tilesloaded",(function(){return t._render_finished()})),this.connect(this.model.properties.map_options.change,(function(){return t._update_options()})),this.connect(this.model.map_options.properties.styles.change,(function(){return t._update_styles()})),this.connect(this.model.map_options.properties.lat.change,(function(){return t._update_center("lat")})),this.connect(this.model.map_options.properties.lng.change,(function(){return t._update_center("lng")})),this.connect(this.model.map_options.properties.zoom.change,(function(){return t._update_zoom()})),this.connect(this.model.map_options.properties.map_type.change,(function(){return t._update_map_type()})),this.connect(this.model.map_options.properties.scale_control.change,(function(){return t._update_scale_control()})),this.connect(this.model.map_options.properties.tilt.change,(function(){return t._update_tilt()}))},e.prototype._render_finished=function(){this._tiles_loaded=!0,this.notify_finished()},e.prototype.has_finished=function(){return t.prototype.has_finished.call(this)&&!0===this._tiles_loaded},e.prototype._get_latlon_bounds=function(){var t=this.map.getBounds(),e=t.getNorthEast(),o=t.getSouthWest();return[o.lng(),e.lng(),o.lat(),e.lat()]},e.prototype._get_projected_bounds=function(){var t=(0,s.__read)(this._get_latlon_bounds(),4),e=t[0],o=t[1],i=t[2],n=t[3],a=(0,s.__read)(_.wgs84_mercator.compute(e,i),2),p=a[0],l=a[1],r=(0,s.__read)(_.wgs84_mercator.compute(o,n),2);return[p,r[0],l,r[1]]},e.prototype._set_bokeh_ranges=function(){var t=(0,s.__read)(this._get_projected_bounds(),4),e=t[0],o=t[1],i=t[2],n=t[3];this.frame.x_range.setv({start:e,end:o}),this.frame.y_range.setv({start:i,end:n})},e.prototype._update_center=function(t){var e,o=null===(e=this.map.getCenter())||void 0===e?void 0:e.toJSON();null!=o&&(o[t]=this.model.map_options[t],this.map.setCenter(o),this._set_bokeh_ranges())},e.prototype._update_map_type=function(){this.map.setOptions({mapTypeId:this.map_types[this.model.map_options.map_type]})},e.prototype._update_scale_control=function(){this.map.setOptions({scaleControl:this.model.map_options.scale_control})},e.prototype._update_tilt=function(){this.map.setOptions({tilt:this.model.map_options.tilt})},e.prototype._update_options=function(){this._update_styles(),this._update_center("lat"),this._update_center("lng"),this._update_zoom(),this._update_map_type()},e.prototype._update_styles=function(){this.map.setOptions({styles:JSON.parse(this.model.map_options.styles)})},e.prototype._update_zoom=function(){this.map.setOptions({zoom:this.model.map_options.zoom}),this._set_bokeh_ranges()},e.prototype._map_hook=function(t,e){if(null==this.map&&"undefined"!=typeof google&&null!=google.maps&&this._build_map(),null!=this.map_el){var o=(0,s.__read)(e,4),i=o[0],n=o[1],a=o[2],p=o[3];this.map_el.style.top=n+"px",this.map_el.style.left=i+"px",this.map_el.style.width=a+"px",this.map_el.style.height=p+"px"}},e.prototype._paint_empty=function(t,e){var o=this.layout.bbox.width,i=this.layout.bbox.height,n=(0,s.__read)(e,4),a=n[0],p=n[1],l=n[2],_=n[3];t.clearRect(0,0,o,i),t.beginPath(),t.moveTo(0,0),t.lineTo(0,i),t.lineTo(o,i),t.lineTo(o,0),t.lineTo(0,0),t.moveTo(a,p),t.lineTo(a+l,p),t.lineTo(a+l,p+_),t.lineTo(a,p+_),t.lineTo(a,p),t.closePath(),null!=this.model.border_fill_color&&(t.fillStyle=(0,r.color2css)(this.model.border_fill_color),t.fill())},e}(h.PlotView);o.GMapPlotView=m,m.__name__="GMapPlotView"},
function _(t,_,n,o,r){o(),(0,t(1).__exportStar)(t(247),n)},
function _(e,r,d,n,R){n(),R("GlyphRenderer",e(290).GlyphRenderer),R("GraphRenderer",e(454).GraphRenderer),R("GuideRenderer",e(244).GuideRenderer);var G=e(156);R("Renderer",G.Renderer),R("RendererGroup",G.RendererGroup)},
function _(e,r,t,n,i){n();var o,p=e(1),a=e(291),d=e(290),s=e(418),l=e(417),_=e(228),h=e(293),y=e(398),c=e(401),u=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return(0,p.__extends)(r,e),Object.defineProperty(r.prototype,"glyph_view",{get:function(){return this.node_view.glyph},enumerable:!1,configurable:!0}),r.prototype.lazy_initialize=function(){return(0,p.__awaiter)(this,void 0,void 0,(function(){var r,t,n,i,o,a;return(0,p.__generator)(this,(function(p){switch(p.label){case 0:return[4,e.prototype.lazy_initialize.call(this)];case 1:return p.sent(),this.apply_coordinates(),r=this.parent,t=this.model,n=t.edge_renderer,i=t.node_renderer,o=this,[4,(0,_.build_view)(n,{parent:r})];case 2:return o.edge_view=p.sent(),a=this,[4,(0,_.build_view)(i,{parent:r})];case 3:return a.node_view=p.sent(),[2]}}))}))},r.prototype.connect_signals=function(){var r=this;e.prototype.connect_signals.call(this),this.connect(this.model.layout_provider.change,(function(){r.apply_coordinates(),r.edge_view.set_data(),r.node_view.set_data(),r.request_render()}))},r.prototype.apply_coordinates=function(){var e=this.model,r=e.edge_renderer,t=e.node_renderer;if(!(r.glyph instanceof y.MultiLine||r.glyph instanceof c.Patches))throw new Error(this+".edge_renderer.glyph must be a MultiLine glyph");if(!(t.glyph instanceof h.XYGlyph))throw new Error(this+".node_renderer.glyph must be a XYGlyph glyph");var n=this.model.layout_provider.edge_coordinates,i=this.model.layout_provider.node_coordinates;r.glyph.properties.xs.internal=!0,r.glyph.properties.ys.internal=!0,t.glyph.properties.x.internal=!0,t.glyph.properties.y.internal=!0,r.glyph.xs={expr:n.x},r.glyph.ys={expr:n.y},t.glyph.x={expr:i.x},t.glyph.y={expr:i.y}},r.prototype.remove=function(){this.edge_view.remove(),this.node_view.remove(),e.prototype.remove.call(this)},r.prototype._render=function(){this.edge_view.render(),this.node_view.render()},r.prototype.renderer_view=function(r){if(r instanceof d.GlyphRenderer){if(r==this.edge_view.model)return this.edge_view;if(r==this.node_view.model)return this.node_view}return e.prototype.renderer_view.call(this,r)},r}(a.DataRendererView);t.GraphRendererView=u,u.__name__="GraphRendererView";var g=function(e){function r(r){return e.call(this,r)||this}return(0,p.__extends)(r,e),r.prototype.get_selection_manager=function(){return this.node_renderer.data_source.selection_manager},r}(a.DataRenderer);t.GraphRenderer=g,o=g,g.__name__="GraphRenderer",o.prototype.default_view=u,o.define((function(e){var r=e.Ref;return{layout_provider:[r(s.LayoutProvider)],node_renderer:[r(d.GlyphRenderer)],edge_renderer:[r(d.GlyphRenderer)],selection_policy:[r(l.GraphHitTestPolicy),function(){return new l.NodesOnly}],inspection_policy:[r(l.GraphHitTestPolicy),function(){return new l.NodesOnly}]}}))},
function _(e,t,n,o,c){o(),(0,e(1).__exportStar)(e(189),n),c("Selection",e(187).Selection)},
function _(a,e,S,o,r){o(),r("ServerSentDataSource",a(457).ServerSentDataSource),r("AjaxDataSource",a(459).AjaxDataSource),r("ColumnDataSource",a(190).ColumnDataSource),r("ColumnarDataSource",a(185).ColumnarDataSource),r("CDSView",a(305).CDSView),r("DataSource",a(186).DataSource),r("GeoJSONDataSource",a(460).GeoJSONDataSource),r("WebDataSource",a(458).WebDataSource)},
function _(t,e,i,a,n){a();var r=t(1),o=function(t){function e(e){var i=t.call(this,e)||this;return i.initialized=!1,i}return(0,r.__extends)(e,t),e.prototype.setup=function(){var t=this;this.initialized||(this.initialized=!0,new EventSource(this.data_url).onmessage=function(e){var i;t.load_data(JSON.parse(e.data),t.mode,null!==(i=t.max_size)&&void 0!==i?i:void 0)})},e}(t(458).WebDataSource);i.ServerSentDataSource=o,o.__name__="ServerSentDataSource"},
function _(t,e,a,r,n){r();var l,o=t(1),i=t(190),u=t(135),c=function(t){function e(e){return t.call(this,e)||this}return(0,o.__extends)(e,t),e.prototype.get_column=function(t){var e=this.data[t];return null!=e?e:[]},e.prototype.get_length=function(){var e;return null!==(e=t.prototype.get_length.call(this))&&void 0!==e?e:0},e.prototype.initialize=function(){t.prototype.initialize.call(this),this.setup()},e.prototype.load_data=function(t,e,a){var r,n,l,i=this.adapter;switch(l=null!=i?i.execute(this,{response:t}):t,e){case"replace":this.data=l;break;case"append":var u=this.data;try{for(var c=(0,o.__values)(this.columns()),s=c.next();!s.done;s=c.next()){var p=s.value,d=Array.from(u[p]),h=Array.from(l[p]),f=d.concat(h);l[p]=null!=a?f.slice(-a):f}}catch(t){r={error:t}}finally{try{s&&!s.done&&(n=c.return)&&n.call(c)}finally{if(r)throw r.error}}this.data=l}},e}(i.ColumnDataSource);a.WebDataSource=c,l=c,c.__name__="WebDataSource",l.define((function(t){var e=t.Any,a=t.Int,r=t.String,n=t.Nullable;return{max_size:[n(a),null],mode:[u.UpdateMode,"replace"],adapter:[n(e),null],data_url:[r]}}))},
function _(t,e,r,n,i){n();var a,o=t(1),l=t(458),s=t(135),d=t(134),u=t(128),h=function(t){function e(e){var r=t.call(this,e)||this;return r.interval=null,r.initialized=!1,r}return(0,o.__extends)(e,t),e.prototype.destroy=function(){null!=this.interval&&clearInterval(this.interval),t.prototype.destroy.call(this)},e.prototype.setup=function(){var t=this;if(!this.initialized&&(this.initialized=!0,this.get_data(this.mode),null!=this.polling_interval)){this.interval=setInterval((function(){return t.get_data(t.mode,t.max_size,t.if_modified)}),this.polling_interval)}},e.prototype.get_data=function(t,e,r){var n=this;void 0===e&&(e=null),void 0===r&&(r=!1);var i=this.prepare_request();i.addEventListener("load",(function(){return n.do_load(i,t,null!=e?e:void 0)})),i.addEventListener("error",(function(){return n.do_error(i)})),i.send()},e.prototype.prepare_request=function(){var t,e,r=new XMLHttpRequest;r.open(this.method,this.data_url,!0),r.withCredentials=!1,r.setRequestHeader("Content-Type",this.content_type);var n=this.http_headers;try{for(var i=(0,o.__values)((0,u.entries)(n)),a=i.next();!a.done;a=i.next()){var l=(0,o.__read)(a.value,2),s=l[0],d=l[1];r.setRequestHeader(s,d)}}catch(e){t={error:e}}finally{try{a&&!a.done&&(e=i.return)&&e.call(i)}finally{if(t)throw t.error}}return r},e.prototype.do_load=function(t,e,r){if(200===t.status){var n=JSON.parse(t.responseText);this.load_data(n,e,r)}},e.prototype.do_error=function(t){d.logger.error("Failed to fetch JSON from "+this.data_url+" with code "+t.status)},e}(l.WebDataSource);r.AjaxDataSource=h,a=h,h.__name__="AjaxDataSource",a.define((function(t){var e=t.Boolean,r=t.Int,n=t.String,i=t.Dict;return{polling_interval:[(0,t.Nullable)(r),null],content_type:[n,"application/json"],http_headers:[i(n),{}],method:[s.HTTPMethod,"POST"],if_modified:[e,!1]}}))},
function _(e,r,t,o,n){o();var a,i=e(1),l=e(185),s=e(134),_=e(126),u=e(128);function c(e){return null!=e?e:NaN}var y=Object.prototype.hasOwnProperty,h=function(e){function r(r){return e.call(this,r)||this}return(0,i.__extends)(r,e),r.prototype.initialize=function(){e.prototype.initialize.call(this),this._update_data()},r.prototype.connect_signals=function(){var r=this;e.prototype.connect_signals.call(this),this.connect(this.properties.geojson.change,(function(){return r._update_data()}))},r.prototype._update_data=function(){this.data=this.geojson_to_column_data()},r.prototype._get_new_list_array=function(e){return(0,_.range)(0,e).map((function(e){return[]}))},r.prototype._get_new_nan_array=function(e){return(0,_.range)(0,e).map((function(e){return NaN}))},r.prototype._add_properties=function(e,r,t,o){var n,a,l,s=null!==(l=e.properties)&&void 0!==l?l:{};try{for(var _=(0,i.__values)((0,u.entries)(s)),h=_.next();!h.done;h=_.next()){var d=(0,i.__read)(h.value,2),p=d[0],g=d[1];y.call(r,p)||(r[p]=this._get_new_nan_array(o)),r[p][t]=c(g)}}catch(e){n={error:e}}finally{try{h&&!h.done&&(a=_.return)&&a.call(_)}finally{if(n)throw n.error}}},r.prototype._add_geometry=function(e,r,t){var o,n;function a(e,r){return e.concat([[NaN,NaN,NaN]]).concat(r)}switch(e.type){case"Point":var l=(0,i.__read)(e.coordinates,3),_=l[0],u=l[1],y=l[2];r.x[t]=_,r.y[t]=u,r.z[t]=c(y);break;case"LineString":for(var h=e.coordinates,d=0;d<h.length;d++){var p=(0,i.__read)(h[d],3);_=p[0],u=p[1],y=p[2];r.xs[t][d]=_,r.ys[t][d]=u,r.zs[t][d]=c(y)}break;case"Polygon":e.coordinates.length>1&&s.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used.");var g=e.coordinates[0];for(d=0;d<g.length;d++){var f=(0,i.__read)(g[d],3);_=f[0],u=f[1],y=f[2];r.xs[t][d]=_,r.ys[t][d]=u,r.zs[t][d]=c(y)}break;case"MultiPoint":s.logger.warn("MultiPoint not supported in Bokeh");break;case"MultiLineString":for(h=e.coordinates.reduce(a),d=0;d<h.length;d++){var v=(0,i.__read)(h[d],3);_=v[0],u=v[1],y=v[2];r.xs[t][d]=_,r.ys[t][d]=u,r.zs[t][d]=c(y)}break;case"MultiPolygon":var w=[];try{for(var m=(0,i.__values)(e.coordinates),x=m.next();!x.done;x=m.next()){var N=x.value;N.length>1&&s.logger.warn("Bokeh does not support Polygons with holes in, only exterior ring used."),w.push(N[0])}}catch(e){o={error:e}}finally{try{x&&!x.done&&(n=m.return)&&n.call(m)}finally{if(o)throw o.error}}for(h=w.reduce(a),d=0;d<h.length;d++){var k=(0,i.__read)(h[d],3);_=k[0],u=k[1],y=k[2];r.xs[t][d]=_,r.ys[t][d]=u,r.zs[t][d]=c(y)}break;default:throw new Error("Invalid GeoJSON geometry type: "+e.type)}},r.prototype.geojson_to_column_data=function(){var e,r,t,o,n,a,l,s=JSON.parse(this.geojson);switch(s.type){case"GeometryCollection":if(null==s.geometries)throw new Error("No geometries found in GeometryCollection");if(0===s.geometries.length)throw new Error("geojson.geometries must have one or more items");l=s.geometries;break;case"FeatureCollection":if(null==s.features)throw new Error("No features found in FeaturesCollection");if(0==s.features.length)throw new Error("geojson.features must have one or more items");l=s.features;break;default:throw new Error("Bokeh only supports type GeometryCollection and FeatureCollection at top level")}var _=0;try{for(var u=(0,i.__values)(l),c=u.next();!c.done;c=u.next()){"GeometryCollection"==(f="Feature"===(g=c.value).type?g.geometry:g).type?_+=f.geometries.length:_+=1}}catch(r){e={error:r}}finally{try{c&&!c.done&&(r=u.return)&&r.call(u)}finally{if(e)throw e.error}}var y={x:this._get_new_nan_array(_),y:this._get_new_nan_array(_),z:this._get_new_nan_array(_),xs:this._get_new_list_array(_),ys:this._get_new_list_array(_),zs:this._get_new_list_array(_)},h=0;try{for(var d=(0,i.__values)(l),p=d.next();!p.done;p=d.next()){var g,f;if("GeometryCollection"==(f="Feature"==(g=p.value).type?g.geometry:g).type)try{for(var v=(n=void 0,(0,i.__values)(f.geometries)),w=v.next();!w.done;w=v.next()){var m=w.value;this._add_geometry(m,y,h),"Feature"===g.type&&this._add_properties(g,y,h,_),h+=1}}catch(e){n={error:e}}finally{try{w&&!w.done&&(a=v.return)&&a.call(v)}finally{if(n)throw n.error}}else this._add_geometry(f,y,h),"Feature"===g.type&&this._add_properties(g,y,h,_),h+=1}}catch(e){t={error:e}}finally{try{p&&!p.done&&(o=d.return)&&o.call(d)}finally{if(t)throw t.error}}return y},r}(l.ColumnarDataSource);t.GeoJSONDataSource=h,a=h,h.__name__="GeoJSONDataSource",a.define((function(e){return{geojson:[e.String]}})),a.internal((function(e){return{data:[(0,e.Dict)(e.Arrayable),{}]}}))},
function _(e,r,T,o,S){o(),S("BBoxTileSource",e(462).BBoxTileSource),S("MercatorTileSource",e(463).MercatorTileSource),S("QUADKEYTileSource",e(466).QUADKEYTileSource),S("TileRenderer",e(467).TileRenderer),S("TileSource",e(464).TileSource),S("TMSTileSource",e(470).TMSTileSource),S("WMTSTileSource",e(468).WMTSTileSource)},
function _(e,t,r,n,i){n();var o,_=e(1),l=function(e){function t(t){return e.call(this,t)||this}return(0,_.__extends)(t,e),t.prototype.get_image_url=function(e,t,r){var n,i,o,l,u,a,c=this.string_lookup_replace(this.url,this.extra_url_vars);return this.use_latlon?(l=(n=(0,_.__read)(this.get_tile_geographic_bounds(e,t,r),4))[0],a=n[1],o=n[2],u=n[3]):(l=(i=(0,_.__read)(this.get_tile_meter_bounds(e,t,r),4))[0],a=i[1],o=i[2],u=i[3]),c.replace("{XMIN}",l.toString()).replace("{YMIN}",a.toString()).replace("{XMAX}",o.toString()).replace("{YMAX}",u.toString())},t}(e(463).MercatorTileSource);r.BBoxTileSource=l,o=l,l.__name__="BBoxTileSource",o.define((function(e){return{use_latlon:[e.Boolean,!1]}}))},
function _(t,e,r,i,o){i();var _,n=t(1),s=t(464),a=t(126),u=t(465),l=function(t){function e(e){return t.call(this,e)||this}return(0,n.__extends)(e,t),e.prototype.initialize=function(){var e=this;t.prototype.initialize.call(this),this._resolutions=(0,a.range)(this.min_zoom,this.max_zoom+1).map((function(t){return e.get_resolution(t)}))},e.prototype._computed_initial_resolution=function(){return null!=this.initial_resolution?this.initial_resolution:2*Math.PI*6378137/this.tile_size},e.prototype.is_valid_tile=function(t,e,r){return!(!this.wrap_around&&(t<0||t>=Math.pow(2,r)))&&!(e<0||e>=Math.pow(2,r))},e.prototype.parent_by_tile_xyz=function(t,e,r){var i=this.tile_xyz_to_quadkey(t,e,r),o=i.substring(0,i.length-1);return this.quadkey_to_tile_xyz(o)},e.prototype.get_resolution=function(t){return this._computed_initial_resolution()/Math.pow(2,t)},e.prototype.get_resolution_by_extent=function(t,e,r){return[(t[2]-t[0])/r,(t[3]-t[1])/e]},e.prototype.get_level_by_extent=function(t,e,r){var i,o,_=(t[2]-t[0])/r,s=(t[3]-t[1])/e,a=Math.max(_,s),u=0;try{for(var l=(0,n.__values)(this._resolutions),p=l.next();!p.done;p=l.next()){if(a>p.value){if(0==u)return 0;if(u>0)return u-1}u+=1}}catch(t){i={error:t}}finally{try{p&&!p.done&&(o=l.return)&&o.call(l)}finally{if(i)throw i.error}}return u-1},e.prototype.get_closest_level_by_extent=function(t,e,r){var i=(t[2]-t[0])/r,o=(t[3]-t[1])/e,_=Math.max(i,o),n=this._resolutions.reduce((function(t,e){return Math.abs(e-_)<Math.abs(t-_)?e:t}));return this._resolutions.indexOf(n)},e.prototype.snap_to_zoom_level=function(t,e,r,i){var o=(0,n.__read)(t,4),_=o[0],s=o[1],a=o[2],u=o[3],l=this._resolutions[i],p=r*l,h=e*l;if(!this.snap_to_zoom){var y=(a-_)/p,f=(u-s)/h;y>f?(p=a-_,h*=y):(p*=f,h=u-s)}var c=(p-(a-_))/2,d=(h-(u-s))/2;return[_-c,s-d,a+c,u+d]},e.prototype.tms_to_wmts=function(t,e,r){return[t,Math.pow(2,r)-1-e,r]},e.prototype.wmts_to_tms=function(t,e,r){return[t,Math.pow(2,r)-1-e,r]},e.prototype.pixels_to_meters=function(t,e,r){var i=this.get_resolution(r);return[t*i-this.x_origin_offset,e*i-this.y_origin_offset]},e.prototype.meters_to_pixels=function(t,e,r){var i=this.get_resolution(r);return[(t+this.x_origin_offset)/i,(e+this.y_origin_offset)/i]},e.prototype.pixels_to_tile=function(t,e){var r=Math.ceil(t/this.tile_size);return[r=0===r?r:r-1,Math.max(Math.ceil(e/this.tile_size)-1,0)]},e.prototype.pixels_to_raster=function(t,e,r){return[t,(this.tile_size<<r)-e]},e.prototype.meters_to_tile=function(t,e,r){var i=(0,n.__read)(this.meters_to_pixels(t,e,r),2),o=i[0],_=i[1];return this.pixels_to_tile(o,_)},e.prototype.get_tile_meter_bounds=function(t,e,r){var i=(0,n.__read)(this.pixels_to_meters(t*this.tile_size,e*this.tile_size,r),2),o=i[0],_=i[1],s=(0,n.__read)(this.pixels_to_meters((t+1)*this.tile_size,(e+1)*this.tile_size,r),2);return[o,_,s[0],s[1]]},e.prototype.get_tile_geographic_bounds=function(t,e,r){var i=this.get_tile_meter_bounds(t,e,r),o=(0,n.__read)((0,u.meters_extent_to_geographic)(i),4);return[o[0],o[1],o[2],o[3]]},e.prototype.get_tiles_by_extent=function(t,e,r){void 0===r&&(r=1);var i=(0,n.__read)(t,4),o=i[0],_=i[1],s=i[2],a=i[3],u=(0,n.__read)(this.meters_to_tile(o,_,e),2),l=u[0],p=u[1],h=(0,n.__read)(this.meters_to_tile(s,a,e),2),y=h[0],f=h[1];l-=r,p-=r,y+=r;for(var c=[],d=f+=r;d>=p;d--)for(var x=l;x<=y;x++)this.is_valid_tile(x,d,e)&&c.push([x,d,e,this.get_tile_meter_bounds(x,d,e)]);return this.sort_tiles_from_center(c,[l,p,y,f]),c},e.prototype.quadkey_to_tile_xyz=function(t){for(var e=0,r=0,i=t.length,o=i;o>0;o--){var _=1<<o-1;switch(t.charAt(i-o)){case"0":continue;case"1":e|=_;break;case"2":r|=_;break;case"3":e|=_,r|=_;break;default:throw new TypeError("Invalid Quadkey: "+t)}}return[e,r,i]},e.prototype.tile_xyz_to_quadkey=function(t,e,r){for(var i="",o=r;o>0;o--){var _=1<<o-1,n=0;0!=(t&_)&&(n+=1),0!=(e&_)&&(n+=2),i+=n.toString()}return i},e.prototype.children_by_tile_xyz=function(t,e,r){for(var i=this.tile_xyz_to_quadkey(t,e,r),o=[],_=0;_<=3;_++){var s=(0,n.__read)(this.quadkey_to_tile_xyz(i+_.toString()),3),a=s[0],u=s[1],l=s[2],p=this.get_tile_meter_bounds(a,u,l);o.push([a,u,l,p])}return o},e.prototype.get_closest_parent_by_tile_xyz=function(t,e,r){var i,o,_,s=this.calculate_world_x_by_tile_xyz(t,e,r);t=(i=(0,n.__read)(this.normalize_xyz(t,e,r),3))[0],e=i[1],r=i[2];for(var a=this.tile_xyz_to_quadkey(t,e,r);a.length>0;)if(a=a.substring(0,a.length-1),t=(o=(0,n.__read)(this.quadkey_to_tile_xyz(a),3))[0],e=o[1],r=o[2],t=(_=(0,n.__read)(this.denormalize_xyz(t,e,r,s),3))[0],e=_[1],r=_[2],this.tiles.has(this.tile_xyz_to_key(t,e,r)))return[t,e,r];return[0,0,0]},e.prototype.normalize_xyz=function(t,e,r){if(this.wrap_around){var i=Math.pow(2,r);return[(t%i+i)%i,e,r]}return[t,e,r]},e.prototype.denormalize_xyz=function(t,e,r,i){return[t+i*Math.pow(2,r),e,r]},e.prototype.denormalize_meters=function(t,e,r,i){return[t+2*i*Math.PI*6378137,e]},e.prototype.calculate_world_x_by_tile_xyz=function(t,e,r){return Math.floor(t/Math.pow(2,r))},e}(s.TileSource);r.MercatorTileSource=l,_=l,l.__name__="MercatorTileSource",_.define((function(t){var e=t.Boolean;return{snap_to_zoom:[e,!1],wrap_around:[e,!0]}})),_.override({x_origin_offset:20037508.34,y_origin_offset:20037508.34,initial_resolution:156543.03392804097})},
function _(t,e,r,n,i){n();var o,a=t(1),l=t(168),c=t(128),_=function(t){function e(e){return t.call(this,e)||this}return(0,a.__extends)(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.tiles=new Map,this._normalize_case()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.change,(function(){return e._clear_cache()}))},e.prototype.string_lookup_replace=function(t,e){var r,n,i=t;try{for(var o=(0,a.__values)((0,c.entries)(e)),l=o.next();!l.done;l=o.next()){var _=(0,a.__read)(l.value,2),p=_[0],u=_[1];i=i.replace("{"+p+"}",u)}}catch(t){r={error:t}}finally{try{l&&!l.done&&(n=o.return)&&n.call(o)}finally{if(r)throw r.error}}return i},e.prototype._normalize_case=function(){var t=this.url.replace("{x}","{X}").replace("{y}","{Y}").replace("{z}","{Z}").replace("{q}","{Q}").replace("{xmin}","{XMIN}").replace("{ymin}","{YMIN}").replace("{xmax}","{XMAX}").replace("{ymax}","{YMAX}");this.url=t},e.prototype._clear_cache=function(){this.tiles=new Map},e.prototype.tile_xyz_to_key=function(t,e,r){return t+":"+e+":"+r},e.prototype.key_to_tile_xyz=function(t){var e=(0,a.__read)(t.split(":").map((function(t){return parseInt(t)})),3);return[e[0],e[1],e[2]]},e.prototype.sort_tiles_from_center=function(t,e){var r=(0,a.__read)(e,4),n=r[0],i=r[1],o=r[2],l=r[3],c=(o-n)/2+n,_=(l-i)/2+i;t.sort((function(t,e){return Math.sqrt(Math.pow(c-t[0],2)+Math.pow(_-t[1],2))-Math.sqrt(Math.pow(c-e[0],2)+Math.pow(_-e[1],2))}))},e.prototype.get_image_url=function(t,e,r){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",t.toString()).replace("{Y}",e.toString()).replace("{Z}",r.toString())},e}(l.Model);r.TileSource=_,o=_,_.__name__="TileSource",o.define((function(t){var e=t.Number,r=t.String,n=t.Dict,i=t.Nullable;return{url:[r,""],tile_size:[e,256],max_zoom:[e,30],min_zoom:[e,0],extra_url_vars:[n(r),{}],attribution:[r,""],x_origin_offset:[e],y_origin_offset:[e],initial_resolution:[i(e),null]}}))},
function _(e,r,t,_,n){_();var o=e(1),a=e(193);function c(e,r){return a.wgs84_mercator.compute(e,r)}function g(e,r){return a.wgs84_mercator.invert(e,r)}t.geographic_to_meters=c,t.meters_to_geographic=g,t.geographic_extent_to_meters=function(e){var r=(0,o.__read)(e,4),t=r[0],_=r[1],n=r[2],a=r[3],g=(0,o.__read)(c(t,_),2),i=g[0],u=g[1],m=(0,o.__read)(c(n,a),2);return[i,u,m[0],m[1]]},t.meters_extent_to_geographic=function(e){var r=(0,o.__read)(e,4),t=r[0],_=r[1],n=r[2],a=r[3],c=(0,o.__read)(g(t,_),2),i=c[0],u=c[1],m=(0,o.__read)(g(n,a),2);return[i,u,m[0],m[1]]}},
function _(t,e,r,_,i){_();var u=t(1),n=function(t){function e(e){return t.call(this,e)||this}return(0,u.__extends)(e,t),e.prototype.get_image_url=function(t,e,r){var _=this.string_lookup_replace(this.url,this.extra_url_vars),i=(0,u.__read)(this.tms_to_wmts(t,e,r),3),n=i[0],o=i[1],a=i[2],l=this.tile_xyz_to_quadkey(n,o,a);return _.replace("{Q}",l)},e}(t(463).MercatorTileSource);r.QUADKEYTileSource=n,n.__name__="QUADKEYTileSource"},
function _(e,t,i,r,n){r();var a,o=e(1),_=e(464),s=e(468),l=e(156),h=e(173),d=e(158),u=e(251),c=e(126),p=e(125),m=(0,o.__importStar)(e(469)),f=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,o.__extends)(t,e),t.prototype.initialize=function(){this._tiles=[],e.prototype.initialize.call(this)},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.change,(function(){return t.request_render()})),this.connect(this.model.tile_source.change,(function(){return t.request_render()}))},t.prototype.remove=function(){null!=this.attribution_el&&(0,d.removeElement)(this.attribution_el),e.prototype.remove.call(this)},t.prototype.styles=function(){return(0,o.__spreadArray)((0,o.__spreadArray)([],(0,o.__read)(e.prototype.styles.call(this)),!1),[m.default],!1)},t.prototype.get_extent=function(){return[this.x_range.start,this.y_range.start,this.x_range.end,this.y_range.end]},Object.defineProperty(t.prototype,"map_plot",{get:function(){return this.plot_model},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"map_canvas",{get:function(){return this.layer.ctx},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"map_frame",{get:function(){return this.plot_view.frame},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"x_range",{get:function(){return this.map_plot.x_range},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"y_range",{get:function(){return this.map_plot.y_range},enumerable:!1,configurable:!0}),t.prototype._set_data=function(){this.extent=this.get_extent(),this._last_height=void 0,this._last_width=void 0},t.prototype._update_attribution=function(){null!=this.attribution_el&&(0,d.removeElement)(this.attribution_el);var e=this.model.tile_source.attribution;if((0,p.isString)(e)&&e.length>0){var t=this.plot_view,i=t.layout,r=t.frame,n=i.bbox.width-r.bbox.right,a=i.bbox.height-r.bbox.bottom,o=r.bbox.width;this.attribution_el=(0,d.div)({class:m.tile_attribution,style:{position:"absolute",right:n+"px",bottom:a+"px","max-width":o-4+"px",padding:"2px","background-color":"rgba(255,255,255,0.5)","font-size":"9px","line-height":"1.05","white-space":"nowrap",overflow:"hidden","text-overflow":"ellipsis"}}),this.plot_view.canvas_view.add_event(this.attribution_el),this.attribution_el.innerHTML=e,this.attribution_el.title=this.attribution_el.textContent.replace(/\s*\n\s*/g," ")}},t.prototype._map_data=function(){this.initial_extent=this.get_extent();var e=this.model.tile_source.get_level_by_extent(this.initial_extent,this.map_frame.bbox.height,this.map_frame.bbox.width),t=this.model.tile_source.snap_to_zoom_level(this.initial_extent,this.map_frame.bbox.height,this.map_frame.bbox.width,e);this.x_range.start=t[0],this.y_range.start=t[1],this.x_range.end=t[2],this.y_range.end=t[3],this.x_range instanceof h.Range1d&&(this.x_range.reset_start=t[0],this.x_range.reset_end=t[2]),this.y_range instanceof h.Range1d&&(this.y_range.reset_start=t[1],this.y_range.reset_end=t[3]),this._update_attribution()},t.prototype._create_tile=function(e,t,i,r,n){var a=this;void 0===n&&(n=!1);var _=this.model.tile_source.tile_xyz_to_quadkey(e,t,i),s=this.model.tile_source.tile_xyz_to_key(e,t,i);if(!this.model.tile_source.tiles.has(s)){var l=(0,o.__read)(this.model.tile_source.normalize_xyz(e,t,i),3),h=l[0],d=l[1],c=l[2],p=this.model.tile_source.get_image_url(h,d,c),m={img:void 0,tile_coords:[e,t,i],normalized_coords:[h,d,c],quadkey:_,cache_key:s,bounds:r,loaded:!1,finished:!1,x_coord:r[0],y_coord:r[3]};this.model.tile_source.tiles.set(s,m),this._tiles.push(m),new u.ImageLoader(p,{loaded:function(e){Object.assign(m,{img:e,loaded:!0}),n?(m.finished=!0,a.notify_finished()):a.request_render()},failed:function(){m.finished=!0}})}},t.prototype._enforce_aspect_ratio=function(){if(this._last_height!==this.map_frame.bbox.height||this._last_width!==this.map_frame.bbox.width){var e=this.get_extent(),t=this.model.tile_source.get_level_by_extent(e,this.map_frame.bbox.height,this.map_frame.bbox.width),i=this.model.tile_source.snap_to_zoom_level(e,this.map_frame.bbox.height,this.map_frame.bbox.width,t);this.x_range.setv({start:i[0],end:i[2]}),this.y_range.setv({start:i[1],end:i[3]}),this.extent=i,this._last_height=this.map_frame.bbox.height,this._last_width=this.map_frame.bbox.width}},t.prototype.has_finished=function(){var t,i;if(!e.prototype.has_finished.call(this))return!1;if(0==this._tiles.length)return!1;try{for(var r=(0,o.__values)(this._tiles),n=r.next();!n.done;n=r.next()){if(!n.value.finished)return!1}}catch(e){t={error:e}}finally{try{n&&!n.done&&(i=r.return)&&i.call(r)}finally{if(t)throw t.error}}return!0},t.prototype._render=function(){null==this.map_initialized&&(this._set_data(),this._map_data(),this.map_initialized=!0),this._enforce_aspect_ratio(),this._update(),null!=this.prefetch_timer&&clearTimeout(this.prefetch_timer),this.prefetch_timer=setTimeout(this._prefetch_tiles.bind(this),500),this.has_finished()&&this.notify_finished()},t.prototype._draw_tile=function(e){var t=this.model.tile_source.tiles.get(e);if(null!=t&&t.loaded){var i=(0,o.__read)(this.coordinates.map_to_screen([t.bounds[0]],[t.bounds[3]]),2),r=(0,o.__read)(i[0],1)[0],n=(0,o.__read)(i[1],1)[0],a=(0,o.__read)(this.coordinates.map_to_screen([t.bounds[2]],[t.bounds[1]]),2),_=(0,o.__read)(a[0],1)[0]-r,s=(0,o.__read)(a[1],1)[0]-n,l=r,h=n,d=this.map_canvas.getImageSmoothingEnabled();this.map_canvas.setImageSmoothingEnabled(this.model.smoothing),this.map_canvas.drawImage(t.img,l,h,_,s),this.map_canvas.setImageSmoothingEnabled(d),t.finished=!0}},t.prototype._set_rect=function(){var e=this.plot_model.outline_line_width,t=this.map_frame.bbox.left+e/2,i=this.map_frame.bbox.top+e/2,r=this.map_frame.bbox.width-e,n=this.map_frame.bbox.height-e;this.map_canvas.rect(t,i,r,n),this.map_canvas.clip()},t.prototype._render_tiles=function(e){var t,i;this.map_canvas.save(),this._set_rect(),this.map_canvas.globalAlpha=this.model.alpha;try{for(var r=(0,o.__values)(e),n=r.next();!n.done;n=r.next()){var a=n.value;this._draw_tile(a)}}catch(e){t={error:e}}finally{try{n&&!n.done&&(i=r.return)&&i.call(r)}finally{if(t)throw t.error}}this.map_canvas.restore()},t.prototype._prefetch_tiles=function(){for(var e,t,i=this.model.tile_source,r=this.get_extent(),n=this.map_frame.bbox.height,a=this.map_frame.bbox.width,_=this.model.tile_source.get_level_by_extent(r,n,a),s=this.model.tile_source.get_tiles_by_extent(r,_),l=0,h=Math.min(10,s.length);l<h;l++){var d=(0,o.__read)(s[l],3),u=d[0],c=d[1],p=d[2],m=this.model.tile_source.children_by_tile_xyz(u,c,p);try{for(var f=(e=void 0,(0,o.__values)(m)),y=f.next();!y.done;y=f.next()){var b=y.value,g=(0,o.__read)(b,4),x=g[0],v=g[1],w=g[2],z=g[3];i.tiles.has(i.tile_xyz_to_key(x,v,w))||this._create_tile(x,v,w,z,!0)}}catch(t){e={error:t}}finally{try{y&&!y.done&&(t=f.return)&&t.call(f)}finally{if(e)throw e.error}}}},t.prototype._fetch_tiles=function(e){var t,i;try{for(var r=(0,o.__values)(e),n=r.next();!n.done;n=r.next()){var a=n.value,_=(0,o.__read)(a,4),s=_[0],l=_[1],h=_[2],d=_[3];this._create_tile(s,l,h,d)}}catch(e){t={error:e}}finally{try{n&&!n.done&&(i=r.return)&&i.call(r)}finally{if(t)throw t.error}}},t.prototype._update=function(){var e,t,i,r,n=this,a=this.model.tile_source,_=a.min_zoom,s=a.max_zoom,l=this.get_extent(),h=this.extent[2]-this.extent[0]<l[2]-l[0],d=this.map_frame.bbox.height,u=this.map_frame.bbox.width,p=a.get_level_by_extent(l,d,u),m=!1;p<_?(l=this.extent,p=_,m=!0):p>s&&(l=this.extent,p=s,m=!0),m&&(this.x_range.setv({start:l[0],end:l[2]}),this.y_range.setv({start:l[1],end:l[3]})),this.extent=l;var f=a.get_tiles_by_extent(l,p),y=[],b=[],g=[],x=[];try{for(var v=(0,o.__values)(f),w=v.next();!w.done;w=v.next()){var z=w.value,T=(0,o.__read)(z,3),k=T[0],R=T[1],S=T[2],j=a.tile_xyz_to_key(k,R,S),O=a.tiles.get(j);if(null!=O&&O.loaded)b.push(j);else if(this.model.render_parents){var q=(0,o.__read)(a.get_closest_parent_by_tile_xyz(k,R,S),3),E=q[0],I=q[1],P=q[2],A=a.tile_xyz_to_key(E,I,P),M=a.tiles.get(A);if(null!=M&&M.loaded&&!(0,c.includes)(g,A)&&g.push(A),h){var V=a.children_by_tile_xyz(k,R,S);try{for(var L=(i=void 0,(0,o.__values)(V)),B=L.next();!B.done;B=L.next()){var C=(0,o.__read)(B.value,3),H=C[0],N=C[1],W=C[2],D=a.tile_xyz_to_key(H,N,W);a.tiles.has(D)&&x.push(D)}}catch(e){i={error:e}}finally{try{B&&!B.done&&(r=L.return)&&r.call(L)}finally{if(i)throw i.error}}}}null==O&&y.push(z)}}catch(t){e={error:t}}finally{try{w&&!w.done&&(t=v.return)&&t.call(v)}finally{if(e)throw e.error}}this._render_tiles(g),this._render_tiles(x),this._render_tiles(b),null!=this.render_timer&&clearTimeout(this.render_timer),this.render_timer=setTimeout((function(){return n._fetch_tiles(y)}),65)},t}(l.RendererView);i.TileRendererView=f,f.__name__="TileRendererView";var y=function(e){function t(t){return e.call(this,t)||this}return(0,o.__extends)(t,e),t}(l.Renderer);i.TileRenderer=y,a=y,y.__name__="TileRenderer",a.prototype.default_view=f,a.define((function(e){var t=e.Boolean;return{alpha:[e.Number,1],smoothing:[t,!0],tile_source:[(0,e.Ref)(_.TileSource),function(){return new s.WMTSTileSource}],render_parents:[t,!0]}})),a.override({level:"image"})},
function _(t,r,e,i,n){i();var _=t(1),o=function(t){function r(r){return t.call(this,r)||this}return(0,_.__extends)(r,t),r.prototype.get_image_url=function(t,r,e){var i=this.string_lookup_replace(this.url,this.extra_url_vars),n=(0,_.__read)(this.tms_to_wmts(t,r,e),3),o=n[0],u=n[1],a=n[2];return i.replace("{X}",o.toString()).replace("{Y}",u.toString()).replace("{Z}",a.toString())},r}(t(463).MercatorTileSource);e.WMTSTileSource=o,o.__name__="WMTSTileSource"},
function _(t,o,i,b,r){b(),i.root="bk-root",i.tile_attribution="bk-tile-attribution",i.default=".bk-root .bk-tile-attribution a{color:black;}"},
function _(r,e,t,i,n){i();var o=r(1),u=function(r){function e(e){return r.call(this,e)||this}return(0,o.__extends)(e,r),e.prototype.get_image_url=function(r,e,t){return this.string_lookup_replace(this.url,this.extra_url_vars).replace("{X}",r.toString()).replace("{Y}",e.toString()).replace("{Z}",t.toString())},e}(r(463).MercatorTileSource);t.TMSTileSource=u,u.__name__="TMSTileSource"},
function _(e,t,u,a,r){a(),r("CanvasTexture",e(472).CanvasTexture),r("ImageURLTexture",e(474).ImageURLTexture),r("Texture",e(473).Texture)},
function _(t,e,n,r,c){r();var u,i=t(1),o=t(473),a=t(149),s=function(t){function e(e){return t.call(this,e)||this}return(0,i.__extends)(e,t),Object.defineProperty(e.prototype,"func",{get:function(){var t=(0,a.use_strict)(this.code);return new Function("ctx","color","scale","weight",t)},enumerable:!1,configurable:!0}),e.prototype.get_pattern=function(t,e,n){var r=document.createElement("canvas");r.width=e,r.height=e;var c=r.getContext("2d");return this.func.call(this,c,t,e,n),r},e}(o.Texture);n.CanvasTexture=s,u=s,s.__name__="CanvasTexture",u.define((function(t){return{code:[t.String]}}))},
function _(e,t,n,r,i){r();var u,o=e(1),_=e(168),c=e(135),f=function(e){function t(t){return e.call(this,t)||this}return(0,o.__extends)(t,e),t}(_.Model);n.Texture=f,u=f,f.__name__="Texture",u.define((function(){return{repetition:[c.TextureRepetition,"repeat"]}}))},
function _(e,t,i,n,r){n();var o,a=e(1),u=e(473),l=e(251),_=function(e){function t(t){return e.call(this,t)||this}return(0,a.__extends)(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this._loader=new l.ImageLoader(this.url)},t.prototype.get_pattern=function(e,t,i){var n=this._loader;return this._loader.finished?n.image:n.promise},t}(u.Texture);i.ImageURLTexture=_,o=_,_.__name__="ImageURLTexture",o.define((function(e){return{url:[e.String]}}))},
function _(o,l,T,e,t){e(),t("ActionTool",o(353).ActionTool),t("CustomAction",o(476).CustomAction),t("HelpTool",o(354).HelpTool),t("RedoTool",o(477).RedoTool),t("ResetTool",o(478).ResetTool),t("SaveTool",o(479).SaveTool),t("UndoTool",o(480).UndoTool),t("ZoomInTool",o(481).ZoomInTool),t("ZoomOutTool",o(484).ZoomOutTool),t("ButtonTool",o(339).ButtonTool),t("EditTool",o(485).EditTool),t("BoxEditTool",o(486).BoxEditTool),t("FreehandDrawTool",o(487).FreehandDrawTool),t("PointDrawTool",o(488).PointDrawTool),t("PolyDrawTool",o(489).PolyDrawTool),t("PolyTool",o(490).PolyTool),t("PolyEditTool",o(491).PolyEditTool),t("BoxSelectTool",o(492).BoxSelectTool),t("BoxZoomTool",o(494).BoxZoomTool),t("GestureTool",o(338).GestureTool),t("LassoSelectTool",o(495).LassoSelectTool),t("LineEditTool",o(497).LineEditTool),t("PanTool",o(499).PanTool),t("PolySelectTool",o(496).PolySelectTool),t("RangeTool",o(500).RangeTool),t("SelectTool",o(493).SelectTool),t("TapTool",o(501).TapTool),t("WheelPanTool",o(502).WheelPanTool),t("WheelZoomTool",o(503).WheelZoomTool),t("CrosshairTool",o(504).CrosshairTool),t("CustomJSHover",o(505).CustomJSHover),t("HoverTool",o(506).HoverTool),t("InspectTool",o(347).InspectTool),t("Tool",o(337).Tool),t("ToolProxy",o(509).ToolProxy),t("Toolbar",o(336).Toolbar),t("ToolbarBase",o(348).ToolbarBase),t("ProxyToolbar",o(510).ProxyToolbar),t("ToolbarBox",o(510).ToolbarBox)},
function _(t,o,n,i,e){i();var c,u=t(1),r=t(353),s=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return(0,u.__extends)(o,t),o.prototype.css_classes=function(){return t.prototype.css_classes.call(this).concat("bk-toolbar-button-custom-action")},o}(r.ActionToolButtonView);n.CustomActionButtonView=s,s.__name__="CustomActionButtonView";var l=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return(0,u.__extends)(o,t),o.prototype.doit=function(){var t;null===(t=this.model.callback)||void 0===t||t.execute(this.model)},o}(r.ActionToolView);n.CustomActionView=l,l.__name__="CustomActionView";var a=function(t){function o(o){var n=t.call(this,o)||this;return n.tool_name="Custom Action",n.button_view=s,n}return(0,u.__extends)(o,t),o}(r.ActionTool);n.CustomAction=a,c=a,a.__name__="CustomAction",c.prototype.default_view=l,c.define((function(t){var o=t.Any,n=t.String;return{callback:[(0,t.Nullable)(o)],icon:[n]}})),c.override({description:"Perform a Custom Action"})},
function _(t,o,e,n,i){n();var r,l=t(1),_=t(353),a=t(343),s=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return(0,l.__extends)(o,t),o.prototype.connect_signals=function(){var o=this;t.prototype.connect_signals.call(this),this.connect(this.plot_view.state.changed,(function(){return o.model.disabled=!o.plot_view.state.can_redo}))},o.prototype.doit=function(){var t=this.plot_view.state.redo();null!=(null==t?void 0:t.range)&&this.plot_view.trigger_ranges_update_event()},o}(_.ActionToolView);e.RedoToolView=s,s.__name__="RedoToolView";var c=function(t){function o(o){var e=t.call(this,o)||this;return e.tool_name="Redo",e.icon=a.tool_icon_redo,e}return(0,l.__extends)(o,t),o}(_.ActionTool);e.RedoTool=c,r=c,c.__name__="RedoTool",r.prototype.default_view=s,r.override({disabled:!0}),r.register_alias("redo",(function(){return new c}))},
function _(e,t,o,n,i){n();var r,_=e(1),s=e(353),l=e(343),u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,_.__extends)(t,e),t.prototype.doit=function(){this.plot_view.reset()},t}(s.ActionToolView);o.ResetToolView=u,u.__name__="ResetToolView";var c=function(e){function t(t){var o=e.call(this,t)||this;return o.tool_name="Reset",o.icon=l.tool_icon_reset,o}return(0,_.__extends)(t,e),t}(s.ActionTool);o.ResetTool=c,r=c,c.__name__="ResetTool",r.prototype.default_view=u,r.register_alias("reset",(function(){return new c}))},
function _(e,t,o,n,i){n();var r,a=e(1),c=e(353),s=e(343),u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(t,e),t.prototype.copy=function(){return(0,a.__awaiter)(this,void 0,void 0,(function(){var e,t,o;return(0,a.__generator)(this,(function(n){switch(n.label){case 0:return[4,this.plot_view.to_blob()];case 1:return e=n.sent(),t=new ClipboardItem(((o={})[e.type]=Promise.resolve(e),o)),[4,navigator.clipboard.write([t])];case 2:return n.sent(),[2]}}))}))},t.prototype.save=function(e){return(0,a.__awaiter)(this,void 0,void 0,(function(){var t,o;return(0,a.__generator)(this,(function(n){switch(n.label){case 0:return[4,this.plot_view.to_blob()];case 1:return t=n.sent(),(o=document.createElement("a")).href=URL.createObjectURL(t),o.download=e,o.target="_blank",o.dispatchEvent(new MouseEvent("click")),[2]}}))}))},t.prototype.doit=function(e){switch(void 0===e&&(e="save"),e){case"save":this.save("bokeh_plot");break;case"copy":this.copy()}},t}(c.ActionToolView);o.SaveToolView=u,u.__name__="SaveToolView";var l=function(e){function t(t){var o=e.call(this,t)||this;return o.tool_name="Save",o.icon=s.tool_icon_save,o}return(0,a.__extends)(t,e),Object.defineProperty(t.prototype,"menu",{get:function(){var e=this;return[{icon:"bk-tool-icon-copy-to-clipboard",tooltip:"Copy image to clipboard",if:function(){return"undefined"!=typeof ClipboardItem},handler:function(){e.do.emit("copy")}}]},enumerable:!1,configurable:!0}),t}(c.ActionTool);o.SaveTool=l,r=l,l.__name__="SaveTool",r.prototype.default_view=u,r.register_alias("save",(function(){return new l}))},
function _(n,t,o,e,i){e();var l,r=n(1),_=n(353),a=n(343),s=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return(0,r.__extends)(t,n),t.prototype.connect_signals=function(){var t=this;n.prototype.connect_signals.call(this),this.connect(this.plot_view.state.changed,(function(){return t.model.disabled=!t.plot_view.state.can_undo}))},t.prototype.doit=function(){var n=this.plot_view.state.undo();null!=(null==n?void 0:n.range)&&this.plot_view.trigger_ranges_update_event()},t}(_.ActionToolView);o.UndoToolView=s,s.__name__="UndoToolView";var u=function(n){function t(t){var o=n.call(this,t)||this;return o.tool_name="Undo",o.icon=a.tool_icon_undo,o}return(0,r.__extends)(t,n),t}(_.ActionTool);o.UndoTool=u,l=u,u.__name__="UndoTool",l.prototype.default_view=s,l.override({disabled:!0}),l.register_alias("undo",(function(){return new u}))},
function _(o,n,i,e,t){e();var r,_=o(1),s=o(482),a=o(343),l=function(o){function n(){return null!==o&&o.apply(this,arguments)||this}return(0,_.__extends)(n,o),n}(s.ZoomBaseToolView);i.ZoomInToolView=l,l.__name__="ZoomInToolView";var m=function(o){function n(n){var i=o.call(this,n)||this;return i.sign=1,i.tool_name="Zoom In",i.icon=a.tool_icon_zoom_in,i}return(0,_.__extends)(n,o),n}(s.ZoomBaseTool);i.ZoomInTool=m,r=m,m.__name__="ZoomInTool",r.prototype.default_view=l,r.register_alias("zoom_in",(function(){return new m({dimensions:"both"})})),r.register_alias("xzoom_in",(function(){return new m({dimensions:"width"})})),r.register_alias("yzoom_in",(function(){return new m({dimensions:"height"})}))},
function _(t,o,e,i,n){i();var s,r=t(1),a=t(353),l=t(135),_=t(483),u=function(t){function o(){return null!==t&&t.apply(this,arguments)||this}return(0,r.__extends)(o,t),o.prototype.doit=function(){var t,o=this.plot_view.frame,e=this.model.dimensions,i="width"==e||"both"==e,n="height"==e||"both"==e,s=(0,_.scale_range)(o,this.model.sign*this.model.factor,i,n);this.plot_view.state.push("zoom_out",{range:s}),this.plot_view.update_range(s,{scrolling:!0,maintain_focus:this.model.maintain_focus}),null===(t=this.model.document)||void 0===t||t.interactive_start(this.plot_model),this.plot_view.trigger_ranges_update_event()},o}(a.ActionToolView);e.ZoomBaseToolView=u,u.__name__="ZoomBaseToolView";var m=function(t){function o(o){var e=t.call(this,o)||this;return e.maintain_focus=!0,e}return(0,r.__extends)(o,t),Object.defineProperty(o.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.dimensions)},enumerable:!1,configurable:!0}),o}(a.ActionTool);e.ZoomBaseTool=m,s=m,m.__name__="ZoomBaseTool",s.define((function(t){return{factor:[t.Percent,.1],dimensions:[l.Dimensions,"both"]}}))},
function _(r,e,a,n,_){n();var t=r(1),l=r(117);function o(r,e,a){var n=(0,t.__read)([r.start,r.end],2),_=n[0],l=n[1],o=null!=a?a:(l+_)/2;return[_-(_-o)*e,l-(l-o)*e]}function d(r,e){var a,n,_=(0,t.__read)(e,2),l=_[0],o=_[1],d=new Map;try{for(var i=(0,t.__values)(r),v=i.next();!v.done;v=i.next()){var c=(0,t.__read)(v.value,2),u=c[0],s=c[1],f=(0,t.__read)(s.r_invert(l,o),2),x=f[0],y=f[1];d.set(u,{start:x,end:y})}}catch(r){a={error:r}}finally{try{v&&!v.done&&(n=i.return)&&n.call(i)}finally{if(a)throw a.error}}return d}a.scale_highlow=o,a.get_info=d,a.scale_range=function(r,e,a,n,_){void 0===a&&(a=!0),void 0===n&&(n=!0),e=(0,l.clamp)(e,-.9,.9);var i=a?e:0,v=(0,t.__read)(o(r.bbox.h_range,i,null!=_?_.x:void 0),2),c=v[0],u=v[1],s=d(r.x_scales,[c,u]),f=n?e:0,x=(0,t.__read)(o(r.bbox.v_range,f,null!=_?_.y:void 0),2),y=x[0],g=x[1];return{xrs:s,yrs:d(r.y_scales,[y,g]),factor:e}}},
function _(o,n,t,e,i){e();var u,r=o(1),_=o(482),s=o(343),a=function(o){function n(){return null!==o&&o.apply(this,arguments)||this}return(0,r.__extends)(n,o),n}(_.ZoomBaseToolView);t.ZoomOutToolView=a,a.__name__="ZoomOutToolView";var l=function(o){function n(n){var t=o.call(this,n)||this;return t.sign=-1,t.tool_name="Zoom Out",t.icon=s.tool_icon_zoom_out,t}return(0,r.__extends)(n,o),n}(_.ZoomBaseTool);t.ZoomOutTool=l,u=l,l.__name__="ZoomOutTool",u.prototype.default_view=a,u.define((function(o){return{maintain_focus:[o.Boolean,!0]}})),u.register_alias("zoom_out",(function(){return new l({dimensions:"both"})})),u.register_alias("xzoom_out",(function(){return new l({dimensions:"width"})})),u.register_alias("yzoom_out",(function(){return new l({dimensions:"height"})}))},
function _(e,r,t,n,a){n();var o,i=e(1),l=e(126),_=e(125),s=e(127),c=e(290),u=e(338),d=function(e){function r(){var r=e.apply(this,(0,i.__spreadArray)([],(0,i.__read)(arguments),!1))||this;return r._mouse_in_frame=!0,r}return(0,i.__extends)(r,e),r.prototype._select_mode=function(e){var r=e.shiftKey,t=e.ctrlKey;return r||t?r&&!t?"append":!r&&t?"intersect":r&&t?"subtract":void(0,s.unreachable)():"replace"},r.prototype._move_enter=function(e){this._mouse_in_frame=!0},r.prototype._move_exit=function(e){this._mouse_in_frame=!1},r.prototype._map_drag=function(e,r,t){if(!this.plot_view.frame.bbox.contains(e,r))return null;var n=this.plot_view.renderer_view(t);return null==n?null:[n.coordinates.x_scale.invert(e),n.coordinates.y_scale.invert(r)]},r.prototype._delete_selected=function(e){var r,t,n=e.data_source,a=n.selected.indices;a.sort();try{for(var o=(0,i.__values)(n.columns()),l=o.next();!l.done;l=o.next())for(var _=l.value,s=n.get_array(_),c=0;c<a.length;c++){var u=a[c];s.splice(u-c,1)}}catch(e){r={error:e}}finally{try{l&&!l.done&&(t=o.return)&&t.call(o)}finally{if(r)throw r.error}}this._emit_cds_changes(n)},r.prototype._pop_glyphs=function(e,r){var t,n,a=e.columns();if(r&&a.length)try{for(var o=(0,i.__values)(a),l=o.next();!l.done;l=o.next()){var s=l.value,c=e.get_array(s),u=c.length-r+1;u<1||((0,_.isArray)(c)||(c=Array.from(c),e.data[s]=c),c.splice(0,u))}}catch(e){t={error:e}}finally{try{l&&!l.done&&(n=o.return)&&n.call(o)}finally{if(t)throw t.error}}},r.prototype._emit_cds_changes=function(e,r,t,n){void 0===r&&(r=!0),void 0===t&&(t=!0),void 0===n&&(n=!0),t&&e.selection_manager.clear(),r&&e.change.emit(),n&&(e.data=e.data,e.properties.data.change.emit())},r.prototype._drag_points=function(e,r,t){var n,a,o,l;if(void 0===t&&(t="both"),null!=this._basepoint){var _=(0,i.__read)(this._basepoint,2),s=_[0],c=_[1];try{for(var u=(0,i.__values)(r),d=u.next();!d.done;d=u.next()){var f=d.value,p=this._map_drag(s,c,f),v=this._map_drag(e.sx,e.sy,f);if(null!=v&&null!=p){var y=(0,i.__read)(v,2),h=y[0],m=y[1],g=(0,i.__read)(p,2),x=g[0],w=g[1],b=(0,i.__read)([h-x,m-w],2),T=b[0],A=b[1],E=f.glyph,G=f.data_source,V=(0,i.__read)([E.x.field,E.y.field],2),K=V[0],R=V[1];try{for(var j=(o=void 0,(0,i.__values)(G.selected.indices)),k=j.next();!k.done;k=j.next()){var N=k.value;!K||"width"!=t&&"both"!=t||(G.data[K][N]+=T),!R||"height"!=t&&"both"!=t||(G.data[R][N]+=A)}}catch(e){o={error:e}}finally{try{k&&!k.done&&(l=j.return)&&l.call(j)}finally{if(o)throw o.error}}G.change.emit()}}}catch(e){n={error:e}}finally{try{d&&!d.done&&(a=u.return)&&a.call(u)}finally{if(n)throw n.error}}this._basepoint=[e.sx,e.sy]}},r.prototype._pad_empty_columns=function(e,r){var t,n;try{for(var a=(0,i.__values)(e.columns()),o=a.next();!o.done;o=a.next()){var _=o.value;(0,l.includes)(r,_)||e.get_array(_).push(this.model.empty_value)}}catch(e){t={error:e}}finally{try{o&&!o.done&&(n=a.return)&&n.call(a)}finally{if(t)throw t.error}}},r.prototype._select_event=function(e,r,t){var n,a,o=this.plot_view.frame,l=e.sx,_=e.sy;if(!o.bbox.contains(l,_))return[];var s={type:"point",sx:l,sy:_},c=[];try{for(var u=(0,i.__values)(t),d=u.next();!d.done;d=u.next()){var f=d.value,p=f.get_selection_manager(),v=f.data_source,y=this.plot_view.renderer_view(f);if(null!=y)p.select([y],s,!0,r)&&c.push(f),v.properties.selected.change.emit()}}catch(e){n={error:e}}finally{try{d&&!d.done&&(a=u.return)&&a.call(u)}finally{if(n)throw n.error}}return c},r}(u.GestureToolView);t.EditToolView=d,d.__name__="EditToolView";var f=function(e){function r(r){return e.call(this,r)||this}return(0,i.__extends)(r,e),Object.defineProperty(r.prototype,"computed_icon",{get:function(){var e;return null!==(e=this.custom_icon)&&void 0!==e?e:this.icon},enumerable:!1,configurable:!0}),r}(u.GestureTool);t.EditTool=f,o=f,f.__name__="EditTool",o.define((function(e){var r=e.Unknown,t=e.String,n=e.Array,a=e.Ref;return{custom_icon:[(0,e.Nullable)(t),null],empty_value:[r],renderers:[n(a(c.GlyphRenderer)),[]]}}))},
function _(e,t,i,_,o){_();var r,s=e(1),n=e(158),a=e(135),d=e(485),l=e(343),h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,s.__extends)(t,e),t.prototype._tap=function(e){null==this._draw_basepoint&&null==this._basepoint&&this._select_event(e,this._select_mode(e),this.model.renderers)},t.prototype._keyup=function(e){var t,i;if(this.model.active&&this._mouse_in_frame)try{for(var _=(0,s.__values)(this.model.renderers),o=_.next();!o.done;o=_.next()){var r=o.value;if(e.keyCode===n.Keys.Backspace)this._delete_selected(r);else if(e.keyCode==n.Keys.Esc){r.data_source.selection_manager.clear()}}}catch(e){t={error:e}}finally{try{o&&!o.done&&(i=_.return)&&i.call(_)}finally{if(t)throw t.error}}},t.prototype._set_extent=function(e,t,i,_){var o=(0,s.__read)(e,2),r=o[0],n=o[1],a=(0,s.__read)(t,2),d=a[0],l=a[1];void 0===_&&(_=!1);var h=this.model.renderers[0],p=this.plot_view.renderer_view(h);if(null!=p){var u=h.glyph,c=h.data_source,f=(0,s.__read)(p.coordinates.x_scale.r_invert(r,n),2),y=f[0],v=f[1],m=(0,s.__read)(p.coordinates.y_scale.r_invert(d,l),2),b=m[0],x=m[1],w=(0,s.__read)([(y+v)/2,(b+x)/2],2),g=w[0],E=w[1],T=(0,s.__read)([v-y,x-b],2),B=T[0],K=T[1],k=(0,s.__read)([u.x.field,u.y.field],2),V=k[0],j=k[1],C=(0,s.__read)([u.width.field,u.height.field],2),D=C[0],I=C[1];if(i)this._pop_glyphs(c,this.model.num_objects),V&&c.get_array(V).push(g),j&&c.get_array(j).push(E),D&&c.get_array(D).push(B),I&&c.get_array(I).push(K),this._pad_empty_columns(c,[V,j,D,I]);else{var q=c.data[V].length-1;V&&(c.data[V][q]=g),j&&(c.data[j][q]=E),D&&(c.data[D][q]=B),I&&(c.data[I][q]=K)}this._emit_cds_changes(c,!0,!1,_)}},t.prototype._update_box=function(e,t,i){if(void 0===t&&(t=!1),void 0===i&&(i=!1),null!=this._draw_basepoint){var _=[e.sx,e.sy],o=this.plot_view.frame,r=this.model.dimensions,n=this.model._get_dim_limits(this._draw_basepoint,_,o,r);if(null!=n){var a=(0,s.__read)(n,2),d=a[0],l=a[1];this._set_extent(d,l,t,i)}}},t.prototype._doubletap=function(e){this.model.active&&(null!=this._draw_basepoint?(this._update_box(e,!1,!0),this._draw_basepoint=null):(this._draw_basepoint=[e.sx,e.sy],this._select_event(e,"append",this.model.renderers),this._update_box(e,!0,!1)))},t.prototype._move=function(e){this._update_box(e,!1,!1)},t.prototype._pan_start=function(e){if(e.shiftKey){if(null!=this._draw_basepoint)return;this._draw_basepoint=[e.sx,e.sy],this._update_box(e,!0,!1)}else{if(null!=this._basepoint)return;this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy]}},t.prototype._pan=function(e,t,i){if(void 0===t&&(t=!1),void 0===i&&(i=!1),e.shiftKey){if(null==this._draw_basepoint)return;this._update_box(e,t,i)}else{if(null==this._basepoint)return;this._drag_points(e,this.model.renderers)}},t.prototype._pan_end=function(e){var t,i;if(this._pan(e,!1,!0),e.shiftKey)this._draw_basepoint=null;else{this._basepoint=null;try{for(var _=(0,s.__values)(this.model.renderers),o=_.next();!o.done;o=_.next()){var r=o.value;this._emit_cds_changes(r.data_source,!1,!0,!0)}}catch(e){t={error:e}}finally{try{o&&!o.done&&(i=_.return)&&i.call(_)}finally{if(t)throw t.error}}}},t}(d.EditToolView);i.BoxEditToolView=h,h.__name__="BoxEditToolView";var p=function(e){function t(t){var i=e.call(this,t)||this;return i.tool_name="Box Edit Tool",i.icon=l.tool_icon_box_edit,i.event_type=["tap","pan","move"],i.default_order=1,i}return(0,s.__extends)(t,e),t}(d.EditTool);i.BoxEditTool=p,r=p,p.__name__="BoxEditTool",r.prototype.default_view=h,r.define((function(e){var t=e.Int;return{dimensions:[a.Dimensions,"both"],num_objects:[t,0]}}))},
function _(e,t,r,a,n){a();var o,_=e(1),i=e(158),d=e(125),s=e(485),l=e(343),h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,_.__extends)(t,e),t.prototype._draw=function(e,t,r){if(void 0===r&&(r=!1),this.model.active){var a=this.model.renderers[0],n=this._map_drag(e.sx,e.sy,a);if(null!=n){var o=(0,_.__read)(n,2),i=o[0],s=o[1],l=a.data_source,h=a.glyph,u=(0,_.__read)([h.xs.field,h.ys.field],2),c=u[0],p=u[1];if("new"==t)this._pop_glyphs(l,this.model.num_objects),c&&l.get_array(c).push([i]),p&&l.get_array(p).push([s]),this._pad_empty_columns(l,[c,p]);else if("add"==t){if(c){var f=l.data[c].length-1,y=l.get_array(c)[f];(0,d.isArray)(y)||(y=Array.from(y),l.data[c][f]=y),y.push(i)}if(p){var m=l.data[p].length-1,w=l.get_array(p)[m];(0,d.isArray)(w)||(w=Array.from(w),l.data[p][m]=w),w.push(s)}}this._emit_cds_changes(l,!0,!0,r)}}},t.prototype._pan_start=function(e){this._draw(e,"new")},t.prototype._pan=function(e){this._draw(e,"add")},t.prototype._pan_end=function(e){this._draw(e,"add",!0)},t.prototype._tap=function(e){this._select_event(e,this._select_mode(e),this.model.renderers)},t.prototype._keyup=function(e){var t,r;if(this.model.active&&this._mouse_in_frame)try{for(var a=(0,_.__values)(this.model.renderers),n=a.next();!n.done;n=a.next()){var o=n.value;e.keyCode===i.Keys.Esc?o.data_source.selection_manager.clear():e.keyCode===i.Keys.Backspace&&this._delete_selected(o)}}catch(e){t={error:e}}finally{try{n&&!n.done&&(r=a.return)&&r.call(a)}finally{if(t)throw t.error}}},t}(s.EditToolView);r.FreehandDrawToolView=h,h.__name__="FreehandDrawToolView";var u=function(e){function t(t){var r=e.call(this,t)||this;return r.tool_name="Freehand Draw Tool",r.icon=l.tool_icon_freehand_draw,r.event_type=["pan","tap"],r.default_order=3,r}return(0,_.__extends)(t,e),t}(s.EditTool);r.FreehandDrawTool=u,o=u,u.__name__="FreehandDrawTool",o.prototype.default_view=h,o.define((function(e){return{num_objects:[e.Int,0]}})),o.register_alias("freehand_draw",(function(){return new u}))},
function _(e,t,r,o,n){o();var a,i=e(1),s=e(158),_=e(485),l=e(343),d=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,i.__extends)(t,e),t.prototype._tap=function(e){if(!this._select_event(e,this._select_mode(e),this.model.renderers).length&&this.model.add){var t=this.model.renderers[0],r=this._map_drag(e.sx,e.sy,t);if(null!=r){var o=t.glyph,n=t.data_source,a=(0,i.__read)([o.x.field,o.y.field],2),s=a[0],_=a[1],l=(0,i.__read)(r,2),d=l[0],h=l[1];this._pop_glyphs(n,this.model.num_objects),s&&n.get_array(s).push(d),_&&n.get_array(_).push(h),this._pad_empty_columns(n,[s,_]),n.change.emit(),n.data=n.data,n.properties.data.change.emit()}}},t.prototype._keyup=function(e){var t,r;if(this.model.active&&this._mouse_in_frame)try{for(var o=(0,i.__values)(this.model.renderers),n=o.next();!n.done;n=o.next()){var a=n.value;e.keyCode===s.Keys.Backspace?this._delete_selected(a):e.keyCode==s.Keys.Esc&&a.data_source.selection_manager.clear()}}catch(e){t={error:e}}finally{try{n&&!n.done&&(r=o.return)&&r.call(o)}finally{if(t)throw t.error}}},t.prototype._pan_start=function(e){this.model.drag&&(this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy])},t.prototype._pan=function(e){this.model.drag&&null!=this._basepoint&&this._drag_points(e,this.model.renderers)},t.prototype._pan_end=function(e){var t,r;if(this.model.drag){this._pan(e);try{for(var o=(0,i.__values)(this.model.renderers),n=o.next();!n.done;n=o.next()){var a=n.value;this._emit_cds_changes(a.data_source,!1,!0,!0)}}catch(e){t={error:e}}finally{try{n&&!n.done&&(r=o.return)&&r.call(o)}finally{if(t)throw t.error}}this._basepoint=null}},t}(_.EditToolView);r.PointDrawToolView=d,d.__name__="PointDrawToolView";var h=function(e){function t(t){var r=e.call(this,t)||this;return r.tool_name="Point Draw Tool",r.icon=l.tool_icon_point_draw,r.event_type=["tap","pan","move"],r.default_order=2,r}return(0,i.__extends)(t,e),t}(_.EditTool);r.PointDrawTool=h,a=h,h.__name__="PointDrawTool",a.prototype.default_view=d,a.define((function(e){var t=e.Boolean;return{add:[t,!0],drag:[t,!0],num_objects:[e.Int,0]}}))},
function _(e,r,t,a,i){a();var n,o=e(1),s=e(158),_=e(125),l=e(490),d=e(343),h=function(e){function r(){var r=e.apply(this,(0,o.__spreadArray)([],(0,o.__read)(arguments),!1))||this;return r._drawing=!1,r._initialized=!1,r}return(0,o.__extends)(r,e),r.prototype._tap=function(e){this._drawing?this._draw(e,"add",!0):this._select_event(e,this._select_mode(e),this.model.renderers)},r.prototype._draw=function(e,r,t){void 0===t&&(t=!1);var a=this.model.renderers[0],i=this._map_drag(e.sx,e.sy,a);if(this._initialized||this.activate(),null!=i){var n=(0,o.__read)(this._snap_to_vertex.apply(this,(0,o.__spreadArray)([e],(0,o.__read)(i),!1)),2),s=n[0],l=n[1],d=a.data_source,h=a.glyph,c=(0,o.__read)([h.xs.field,h.ys.field],2),y=c[0],f=c[1];if("new"==r)this._pop_glyphs(d,this.model.num_objects),y&&d.get_array(y).push([s,s]),f&&d.get_array(f).push([l,l]),this._pad_empty_columns(d,[y,f]);else if("edit"==r){if(y)(p=d.data[y][d.data[y].length-1])[p.length-1]=s;if(f)(g=d.data[f][d.data[f].length-1])[g.length-1]=l}else if("add"==r){if(y){var p,v=d.data[y].length-1,u=(p=d.get_array(y)[v])[p.length-1];p[p.length-1]=s,(0,_.isArray)(p)||(p=Array.from(p),d.data[y][v]=p),p.push(u)}if(f){var g,m=d.data[f].length-1,w=(g=d.get_array(f)[m])[g.length-1];g[g.length-1]=l,(0,_.isArray)(g)||(g=Array.from(g),d.data[f][m]=g),g.push(w)}}this._emit_cds_changes(d,!0,!1,t)}},r.prototype._show_vertices=function(){var e,r,t,a;if(this.model.active){for(var i=[],n=[],s=0;s<this.model.renderers.length;s++){var _=this.model.renderers[s],l=_.data_source,d=_.glyph,h=(0,o.__read)([d.xs.field,d.ys.field],2),c=h[0],y=h[1];if(c)try{for(var f=(e=void 0,(0,o.__values)(l.get_array(c))),p=f.next();!p.done;p=f.next()){var v=p.value;i.push.apply(i,(0,o.__spreadArray)([],(0,o.__read)(v),!1))}}catch(r){e={error:r}}finally{try{p&&!p.done&&(r=f.return)&&r.call(f)}finally{if(e)throw e.error}}if(y)try{for(var u=(t=void 0,(0,o.__values)(l.get_array(y))),g=u.next();!g.done;g=u.next()){v=g.value;n.push.apply(n,(0,o.__spreadArray)([],(0,o.__read)(v),!1))}}catch(e){t={error:e}}finally{try{g&&!g.done&&(a=u.return)&&a.call(u)}finally{if(t)throw t.error}}this._drawing&&s==this.model.renderers.length-1&&(i.splice(i.length-1,1),n.splice(n.length-1,1))}this._set_vertices(i,n)}},r.prototype._doubletap=function(e){this.model.active&&(this._drawing?(this._drawing=!1,this._draw(e,"edit",!0)):(this._drawing=!0,this._draw(e,"new",!0)))},r.prototype._move=function(e){this._drawing&&this._draw(e,"edit")},r.prototype._remove=function(){var e=this.model.renderers[0],r=e.data_source,t=e.glyph,a=(0,o.__read)([t.xs.field,t.ys.field],2),i=a[0],n=a[1];if(i){var s=r.data[i].length-1,_=r.get_array(i)[s];_.splice(_.length-1,1)}if(n){var l=r.data[n].length-1,d=r.get_array(n)[l];d.splice(d.length-1,1)}this._emit_cds_changes(r)},r.prototype._keyup=function(e){var r,t;if(this.model.active&&this._mouse_in_frame)try{for(var a=(0,o.__values)(this.model.renderers),i=a.next();!i.done;i=a.next()){var n=i.value;e.keyCode===s.Keys.Backspace?this._delete_selected(n):e.keyCode==s.Keys.Esc&&(this._drawing&&(this._remove(),this._drawing=!1),n.data_source.selection_manager.clear())}}catch(e){r={error:e}}finally{try{i&&!i.done&&(t=a.return)&&t.call(a)}finally{if(r)throw r.error}}},r.prototype._pan_start=function(e){this.model.drag&&(this._select_event(e,"append",this.model.renderers),this._basepoint=[e.sx,e.sy])},r.prototype._pan=function(e){var r,t,a,i;if(null!=this._basepoint&&this.model.drag){var n=(0,o.__read)(this._basepoint,2),s=n[0],_=n[1];try{for(var l=(0,o.__values)(this.model.renderers),d=l.next();!d.done;d=l.next()){var h=d.value,c=this._map_drag(s,_,h),y=this._map_drag(e.sx,e.sy,h);if(null!=y&&null!=c){var f=h.data_source,p=h.glyph,v=(0,o.__read)([p.xs.field,p.ys.field],2),u=v[0],g=v[1];if(u||g){var m=(0,o.__read)(y,2),w=m[0],x=m[1],b=(0,o.__read)(c,2),A=b[0],P=b[1],T=(0,o.__read)([w-A,x-P],2),D=T[0],k=T[1];try{for(var z=(a=void 0,(0,o.__values)(f.selected.indices)),V=z.next();!V.done;V=z.next()){var j=V.value,B=void 0,C=void 0,K=void 0;u&&(C=f.data[u][j]),B=g?(K=f.data[g][j]).length:C.length;for(var E=0;E<B;E++)C&&(C[E]+=D),K&&(K[E]+=k)}}catch(e){a={error:e}}finally{try{V&&!V.done&&(i=z.return)&&i.call(z)}finally{if(a)throw a.error}}f.change.emit()}}}}catch(e){r={error:e}}finally{try{d&&!d.done&&(t=l.return)&&t.call(l)}finally{if(r)throw r.error}}this._basepoint=[e.sx,e.sy]}},r.prototype._pan_end=function(e){var r,t;if(this.model.drag){this._pan(e);try{for(var a=(0,o.__values)(this.model.renderers),i=a.next();!i.done;i=a.next()){var n=i.value;this._emit_cds_changes(n.data_source)}}catch(e){r={error:e}}finally{try{i&&!i.done&&(t=a.return)&&t.call(a)}finally{if(r)throw r.error}}this._basepoint=null}},r.prototype.activate=function(){var e,r,t=this;if(this.model.vertex_renderer&&this.model.active){if(this._show_vertices(),!this._initialized)try{for(var a=(0,o.__values)(this.model.renderers),i=a.next();!i.done;i=a.next()){var n=i.value.data_source;n.connect(n.properties.data.change,(function(){return t._show_vertices()}))}}catch(r){e={error:r}}finally{try{i&&!i.done&&(r=a.return)&&r.call(a)}finally{if(e)throw e.error}}this._initialized=!0}},r.prototype.deactivate=function(){this._drawing&&(this._remove(),this._drawing=!1),this.model.vertex_renderer&&this._hide_vertices()},r}(l.PolyToolView);t.PolyDrawToolView=h,h.__name__="PolyDrawToolView";var c=function(e){function r(r){var t=e.call(this,r)||this;return t.tool_name="Polygon Draw Tool",t.icon=d.tool_icon_poly_draw,t.event_type=["pan","tap","move"],t.default_order=3,t}return(0,o.__extends)(r,e),r}(l.PolyTool);t.PolyDrawTool=c,n=c,c.__name__="PolyDrawTool",n.prototype.default_view=h,n.define((function(e){return{drag:[e.Boolean,!0],num_objects:[e.Int,0]}}))},
function _(e,t,r,n,i){n();var o,_=e(1),l=e(125),d=e(485),a=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,_.__extends)(t,e),t.prototype._set_vertices=function(e,t){var r=this.model.vertex_renderer.glyph,n=this.model.vertex_renderer.data_source,i=(0,_.__read)([r.x.field,r.y.field],2),o=i[0],d=i[1];o&&((0,l.isArray)(e)?n.data[o]=e:r.x={value:e}),d&&((0,l.isArray)(t)?n.data[d]=t:r.y={value:t}),this._emit_cds_changes(n,!0,!0,!1)},t.prototype._hide_vertices=function(){this._set_vertices([],[])},t.prototype._snap_to_vertex=function(e,t,r){if(this.model.vertex_renderer){var n=this._select_event(e,"replace",[this.model.vertex_renderer]),i=this.model.vertex_renderer.data_source,o=this.model.vertex_renderer.glyph,l=(0,_.__read)([o.x.field,o.y.field],2),d=l[0],a=l[1];if(n.length){var s=i.selected.indices[0];d&&(t=i.data[d][s]),a&&(r=i.data[a][s]),i.selection_manager.clear()}}return[t,r]},t}(d.EditToolView);r.PolyToolView=a,a.__name__="PolyToolView";var s=function(e){function t(t){return e.call(this,t)||this}return(0,_.__extends)(t,e),t}(d.EditTool);r.PolyTool=s,o=s,s.__name__="PolyTool",o.define((function(e){return{vertex_renderer:[(0,e.AnyRef)()]}}))},
function _(e,t,r,i,_){i();var s,d=e(1),a=e(158),n=e(125),l=e(490),o=e(343),c=function(e){function t(){var t=e.apply(this,(0,d.__spreadArray)([],(0,d.__read)(arguments),!1))||this;return t._drawing=!1,t._cur_index=null,t}return(0,d.__extends)(t,e),t.prototype._doubletap=function(e){if(this.model.active){var t=this._map_drag(e.sx,e.sy,this.model.vertex_renderer);if(null!=t){var r=(0,d.__read)(t,2),i=r[0],_=r[1],s=this._select_event(e,"replace",[this.model.vertex_renderer]),a=this.model.vertex_renderer.data_source,n=this.model.vertex_renderer.glyph,l=(0,d.__read)([n.x.field,n.y.field],2),o=l[0],c=l[1];if(s.length&&null!=this._selected_renderer){var h=a.selected.indices[0];this._drawing?(this._drawing=!1,a.selection_manager.clear()):(a.selected.indices=[h+1],o&&a.get_array(o).splice(h+1,0,i),c&&a.get_array(c).splice(h+1,0,_),this._drawing=!0),a.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}else this._show_vertices(e)}}},t.prototype._show_vertices=function(e){var t=this;if(this.model.active){var r=this.model.renderers[0],i=function(){return t._update_vertices(r)},_=null==r?void 0:r.data_source,s=this._select_event(e,"replace",this.model.renderers);if(!s.length)return this._set_vertices([],[]),this._selected_renderer=null,this._drawing=!1,this._cur_index=null,void(null!=_&&_.disconnect(_.properties.data.change,i));null!=_&&_.connect(_.properties.data.change,i),this._cur_index=s[0].data_source.selected.indices[0],this._update_vertices(s[0])}},t.prototype._update_vertices=function(e){var t,r,i=e.glyph,_=e.data_source,s=this._cur_index,a=(0,d.__read)([i.xs.field,i.ys.field],2),l=a[0],o=a[1];this._drawing||(null==s&&(l||o)||(l&&null!=s?(t=_.data[l][s],(0,n.isArray)(t)||(_.data[l][s]=t=Array.from(t))):t=i.xs.value,o&&null!=s?(r=_.data[o][s],(0,n.isArray)(r)||(_.data[o][s]=r=Array.from(r))):r=i.ys.value,this._selected_renderer=e,this._set_vertices(t,r)))},t.prototype._move=function(e){var t;if(this._drawing&&null!=this._selected_renderer){var r=this.model.vertex_renderer,i=r.data_source,_=r.glyph,s=this._map_drag(e.sx,e.sy,r);if(null==s)return;var a=(0,d.__read)(s,2),n=a[0],l=a[1],o=i.selected.indices;n=(t=(0,d.__read)(this._snap_to_vertex(e,n,l),2))[0],l=t[1],i.selected.indices=o;var c=(0,d.__read)([_.x.field,_.y.field],2),h=c[0],u=c[1],v=o[0];h&&(i.data[h][v]=n),u&&(i.data[u][v]=l),i.change.emit(),this._selected_renderer.data_source.change.emit()}},t.prototype._tap=function(e){var t,r=this.model.vertex_renderer,i=this._map_drag(e.sx,e.sy,r);if(null!=i){if(this._drawing&&this._selected_renderer){var _=(0,d.__read)(i,2),s=_[0],a=_[1],n=r.data_source,l=r.glyph,o=(0,d.__read)([l.x.field,l.y.field],2),c=o[0],h=o[1],u=n.selected.indices;s=(t=(0,d.__read)(this._snap_to_vertex(e,s,a),2))[0],a=t[1];var v=u[0];if(n.selected.indices=[v+1],c){var p=n.get_array(c),y=p[v];p[v]=s,p.splice(v+1,0,y)}if(h){var f=n.get_array(h),m=f[v];f[v]=a,f.splice(v+1,0,m)}return n.change.emit(),void this._emit_cds_changes(this._selected_renderer.data_source,!0,!1,!0)}var g=this._select_mode(e);this._select_event(e,g,[r]),this._select_event(e,g,this.model.renderers)}},t.prototype._remove_vertex=function(){if(this._drawing&&this._selected_renderer){var e=this.model.vertex_renderer,t=e.data_source,r=e.glyph,i=t.selected.indices[0],_=(0,d.__read)([r.x.field,r.y.field],2),s=_[0],a=_[1];s&&t.get_array(s).splice(i,1),a&&t.get_array(a).splice(i,1),t.change.emit(),this._emit_cds_changes(this._selected_renderer.data_source)}},t.prototype._pan_start=function(e){this._select_event(e,"append",[this.model.vertex_renderer]),this._basepoint=[e.sx,e.sy]},t.prototype._pan=function(e){null!=this._basepoint&&(this._drag_points(e,[this.model.vertex_renderer]),this._selected_renderer&&this._selected_renderer.data_source.change.emit())},t.prototype._pan_end=function(e){null!=this._basepoint&&(this._drag_points(e,[this.model.vertex_renderer]),this._emit_cds_changes(this.model.vertex_renderer.data_source,!1,!0,!0),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)},t.prototype._keyup=function(e){var t,r;if(this.model.active&&this._mouse_in_frame){var i;i=this._selected_renderer?[this.model.vertex_renderer]:this.model.renderers;try{for(var _=(0,d.__values)(i),s=_.next();!s.done;s=_.next()){var n=s.value;e.keyCode===a.Keys.Backspace?(this._delete_selected(n),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source)):e.keyCode==a.Keys.Esc&&(this._drawing?(this._remove_vertex(),this._drawing=!1):this._selected_renderer&&this._hide_vertices(),n.data_source.selection_manager.clear())}}catch(e){t={error:e}}finally{try{s&&!s.done&&(r=_.return)&&r.call(_)}finally{if(t)throw t.error}}}},t.prototype.deactivate=function(){this._selected_renderer&&(this._drawing&&(this._remove_vertex(),this._drawing=!1),this._hide_vertices())},t}(l.PolyToolView);r.PolyEditToolView=c,c.__name__="PolyEditToolView";var h=function(e){function t(t){var r=e.call(this,t)||this;return r.tool_name="Poly Edit Tool",r.icon=o.tool_icon_poly_edit,r.event_type=["tap","pan","move"],r.default_order=4,r}return(0,d.__extends)(t,e),t}(l.PolyTool);r.PolyEditTool=h,s=h,h.__name__="PolyEditTool",s.prototype.default_view=c},
function _(e,t,o,i,n){i();var l,s=e(1),_=e(493),r=e(231),a=e(135),c=e(343),u=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,s.__extends)(t,e),t.prototype._compute_limits=function(e){var t=this.plot_view.frame,o=this.model.dimensions,i=this._base_point;if("center"==this.model.origin){var n=(0,s.__read)(i,2),l=n[0],_=n[1],r=(0,s.__read)(e,2);i=[l-(r[0]-l),_-(r[1]-_)]}return this.model._get_dim_limits(i,e,t,o)},t.prototype._pan_start=function(e){var t=e.sx,o=e.sy;this._base_point=[t,o]},t.prototype._pan=function(e){var t=[e.sx,e.sy],o=(0,s.__read)(this._compute_limits(t),2),i=o[0],n=o[1];this.model.overlay.update({left:i[0],right:i[1],top:n[0],bottom:n[1]}),this.model.select_every_mousemove&&this._do_select(i,n,!1,this._select_mode(e))},t.prototype._pan_end=function(e){var t=[e.sx,e.sy],o=(0,s.__read)(this._compute_limits(t),2),i=o[0],n=o[1];this._do_select(i,n,!0,this._select_mode(e)),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null,this.plot_view.state.push("box_select",{selection:this.plot_view.get_selection()})},t.prototype._do_select=function(e,t,o,i){var n=(0,s.__read)(e,2),l=n[0],_=n[1],r=(0,s.__read)(t,2);void 0===i&&(i="replace");var a={type:"rect",sx0:l,sx1:_,sy0:r[0],sy1:r[1]};this._select(a,o,i)},t}(_.SelectToolView);o.BoxSelectToolView=u,u.__name__="BoxSelectToolView";var p=function(){return new r.BoxAnnotation({level:"overlay",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]})},d=function(e){function t(t){var o=e.call(this,t)||this;return o.tool_name="Box Select",o.icon=c.tool_icon_box_select,o.event_type="pan",o.default_order=30,o}return(0,s.__extends)(t,e),Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.dimensions)},enumerable:!1,configurable:!0}),t}(_.SelectTool);o.BoxSelectTool=d,l=d,d.__name__="BoxSelectTool",l.prototype.default_view=u,l.define((function(e){var t=e.Boolean,o=e.Ref;return{dimensions:[a.Dimensions,"both"],select_every_mousemove:[t,!1],overlay:[o(r.BoxAnnotation),p],origin:[a.BoxOrigin,"corner"]}})),l.register_alias("box_select",(function(){return new d})),l.register_alias("xbox_select",(function(){return new d({dimensions:"width"})})),l.register_alias("ybox_select",(function(){return new d({dimensions:"height"})}))},
function _(e,t,r,n,o){n();var i,a=e(1),c=e(338),l=e(290),s=e(454),_=e(291),u=e(181),d=e(135),p=e(158),v=e(366),f=e(130),y=e(127),h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.model.clear.connect((function(){return t._clear()}))},Object.defineProperty(t.prototype,"computed_renderers",{get:function(){var e=this.model,t=e.renderers,r=e.names,n=this.plot_model.data_renderers;return(0,u.compute_renderers)(t,n,r)},enumerable:!1,configurable:!0}),t.prototype._computed_renderers_by_data_source=function(){var e,t,r,n=new Map;try{for(var o=(0,a.__values)(this.computed_renderers),i=o.next();!i.done;i=o.next()){var c=i.value,_=void 0;if(c instanceof l.GlyphRenderer)_=c.data_source;else{if(!(c instanceof s.GraphRenderer))continue;_=c.node_renderer.data_source}var u=null!==(r=n.get(_))&&void 0!==r?r:[];n.set(_,(0,a.__spreadArray)((0,a.__spreadArray)([],(0,a.__read)(u),!1),[c],!1))}}catch(t){e={error:t}}finally{try{i&&!i.done&&(t=o.return)&&t.call(o)}finally{if(e)throw e.error}}return n},t.prototype._select_mode=function(e){var t=e.shiftKey,r=e.ctrlKey;return t||r?t&&!r?"append":!t&&r?"intersect":t&&r?"subtract":void(0,y.unreachable)():this.model.mode},t.prototype._keyup=function(e){e.keyCode==p.Keys.Esc&&this._clear()},t.prototype._clear=function(){var e,t,r=this;try{for(var n=(0,a.__values)(this.computed_renderers),o=n.next();!o.done;o=n.next()){o.value.get_selection_manager().clear()}}catch(t){e={error:t}}finally{try{o&&!o.done&&(t=n.return)&&t.call(n)}finally{if(e)throw e.error}}var i=this.computed_renderers.map((function(e){return r.plot_view.renderer_view(e)}));this.plot_view.request_paint(i)},t.prototype._select=function(e,t,r){var n,o,i,c,l=this._computed_renderers_by_data_source();try{for(var s=(0,a.__values)(l),_=s.next();!_.done;_=s.next()){var u=(0,a.__read)(_.value,2)[1],d=u[0].get_selection_manager(),p=[];try{for(var v=(i=void 0,(0,a.__values)(u)),f=v.next();!f.done;f=v.next()){var y=f.value,h=this.plot_view.renderer_view(y);null!=h&&p.push(h)}}catch(e){i={error:e}}finally{try{f&&!f.done&&(c=v.return)&&c.call(v)}finally{if(i)throw i.error}}d.select(p,e,t,r)}}catch(e){n={error:e}}finally{try{_&&!_.done&&(o=s.return)&&o.call(s)}finally{if(n)throw n.error}}null!=this.model.callback&&this._emit_callback(e),this._emit_selection_event(e,t)},t.prototype._emit_selection_event=function(e,t){void 0===t&&(t=!0);var r,n=this.plot_view.frame,o=n.x_scale,i=n.y_scale;switch(e.type){case"point":var c=e.sx,l=e.sy,s=o.invert(c),_=i.invert(l);r=(0,a.__assign)((0,a.__assign)({},e),{x:s,y:_});break;case"span":c=e.sx,l=e.sy,s=o.invert(c),_=i.invert(l);r=(0,a.__assign)((0,a.__assign)({},e),{x:s,y:_});break;case"rect":var u=e.sx0,d=e.sx1,p=e.sy0,f=e.sy1,y=(0,a.__read)(o.r_invert(u,d),2),h=y[0],m=y[1],b=(0,a.__read)(i.r_invert(p,f),2),g=b[0],x=b[1];r=(0,a.__assign)((0,a.__assign)({},e),{x0:h,y0:g,x1:m,y1:x});break;case"poly":c=e.sx,l=e.sy,s=o.v_invert(c),_=i.v_invert(l);r=(0,a.__assign)((0,a.__assign)({},e),{x:s,y:_})}this.plot_model.trigger_event(new v.SelectionGeometry(r,t))},t}(c.GestureToolView);r.SelectToolView=h,h.__name__="SelectToolView";var m=function(e){function t(t){return e.call(this,t)||this}return(0,a.__extends)(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this.clear=new f.Signal0(this,"clear")},Object.defineProperty(t.prototype,"menu",{get:function(){var e=this;return[{icon:"bk-tool-icon-replace-mode",tooltip:"Replace the current selection",active:function(){return"replace"==e.mode},handler:function(){e.mode="replace",e.active=!0}},{icon:"bk-tool-icon-append-mode",tooltip:"Append to the current selection (Shift)",active:function(){return"append"==e.mode},handler:function(){e.mode="append",e.active=!0}},{icon:"bk-tool-icon-intersect-mode",tooltip:"Intersect with the current selection (Ctrl)",active:function(){return"intersect"==e.mode},handler:function(){e.mode="intersect",e.active=!0}},{icon:"bk-tool-icon-subtract-mode",tooltip:"Subtract from the current selection (Shift+Ctrl)",active:function(){return"subtract"==e.mode},handler:function(){e.mode="subtract",e.active=!0}},null,{icon:"bk-tool-icon-clear-selection",tooltip:"Clear the current selection (Esc)",handler:function(){e.clear.emit()}}]},enumerable:!1,configurable:!0}),t}(c.GestureTool);r.SelectTool=m,i=m,m.__name__="SelectTool",i.define((function(e){var t=e.String,r=e.Array,n=e.Ref,o=e.Or,i=e.Auto;return{renderers:[o(r(n(_.DataRenderer)),i),"auto"],names:[r(t),[]],mode:[d.SelectionMode,"replace"]}}))},
function _(t,e,o,n,r){n();var i,a=t(1),_=t(338),s=t(231),l=t(135),u=t(343),p=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,a.__extends)(e,t),e.prototype._match_aspect=function(t,e,o){var n,r,i,_,s=o.bbox.aspect,l=o.bbox.h_range.end,u=o.bbox.h_range.start,p=o.bbox.v_range.end,h=o.bbox.v_range.start,d=Math.abs(t[0]-e[0]),c=Math.abs(t[1]-e[1]),m=0==c?0:d/c,f=(0,a.__read)(m>=s?[1,m/s]:[s/m,1],1)[0];return t[0]<=e[0]?(n=t[0],(r=t[0]+d*f)>l&&(r=l)):(r=t[0],(n=t[0]-d*f)<u&&(n=u)),d=Math.abs(r-n),t[1]<=e[1]?(_=t[1],(i=t[1]+d/s)>p&&(i=p)):(i=t[1],(_=t[1]-d/s)<h&&(_=h)),c=Math.abs(i-_),t[0]<=e[0]?r=t[0]+s*c:n=t[0]-s*c,[[n,r],[_,i]]},e.prototype._compute_limits=function(t){var e,o,n,r,i=this.plot_view.frame,_=this.model.dimensions,s=this._base_point;if("center"==this.model.origin){var l=(0,a.__read)(s,2),u=l[0],p=l[1],h=(0,a.__read)(t,2);s=[u-(h[0]-u),p-(h[1]-p)]}return this.model.match_aspect&&"both"==_?(n=(e=(0,a.__read)(this._match_aspect(s,t,i),2))[0],r=e[1]):(n=(o=(0,a.__read)(this.model._get_dim_limits(s,t,i,_),2))[0],r=o[1]),[n,r]},e.prototype._pan_start=function(t){this._base_point=[t.sx,t.sy]},e.prototype._pan=function(t){var e=[t.sx,t.sy],o=(0,a.__read)(this._compute_limits(e),2),n=o[0],r=o[1];this.model.overlay.update({left:n[0],right:n[1],top:r[0],bottom:r[1]})},e.prototype._pan_end=function(t){var e=[t.sx,t.sy],o=(0,a.__read)(this._compute_limits(e),2),n=o[0],r=o[1];this._update(n,r),this.model.overlay.update({left:null,right:null,top:null,bottom:null}),this._base_point=null,this.plot_view.trigger_ranges_update_event()},e.prototype._update=function(t,e){var o,n,r,i,_=(0,a.__read)(t,2),s=_[0],l=_[1],u=(0,a.__read)(e,2),p=u[0],h=u[1];if(!(Math.abs(l-s)<=5||Math.abs(h-p)<=5)){var d=this.plot_view.frame,c=d.x_scales,m=d.y_scales,f=new Map;try{for(var v=(0,a.__values)(c),b=v.next();!b.done;b=v.next()){var x=(0,a.__read)(b.value,2),y=x[0],g=x[1],w=(0,a.__read)(g.r_invert(s,l),2),B=w[0],M=w[1];f.set(y,{start:B,end:M})}}catch(t){o={error:t}}finally{try{b&&!b.done&&(n=v.return)&&n.call(v)}finally{if(o)throw o.error}}var T=new Map;try{for(var z=(0,a.__values)(m),Z=z.next();!Z.done;Z=z.next()){var V=(0,a.__read)(Z.value,2),A=(y=V[0],g=V[1],(0,a.__read)(g.r_invert(p,h),2));B=A[0],M=A[1];T.set(y,{start:B,end:M})}}catch(t){r={error:t}}finally{try{Z&&!Z.done&&(i=z.return)&&i.call(z)}finally{if(r)throw r.error}}var G={xrs:f,yrs:T};this.plot_view.state.push("box_zoom",{range:G}),this.plot_view.update_range(G)}},e}(_.GestureToolView);o.BoxZoomToolView=p,p.__name__="BoxZoomToolView";var h=function(){return new s.BoxAnnotation({level:"overlay",top_units:"screen",left_units:"screen",bottom_units:"screen",right_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]})},d=function(t){function e(e){var o=t.call(this,e)||this;return o.tool_name="Box Zoom",o.icon=u.tool_icon_box_zoom,o.event_type="pan",o.default_order=20,o}return(0,a.__extends)(e,t),Object.defineProperty(e.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.dimensions)},enumerable:!1,configurable:!0}),e}(_.GestureTool);o.BoxZoomTool=d,i=d,d.__name__="BoxZoomTool",i.prototype.default_view=p,i.define((function(t){var e=t.Boolean,o=t.Ref;return{dimensions:[l.Dimensions,"both"],overlay:[o(s.BoxAnnotation),h],match_aspect:[e,!1],origin:[l.BoxOrigin,"corner"]}})),i.register_alias("box_zoom",(function(){return new d({dimensions:"both"})})),i.register_alias("xbox_zoom",(function(){return new d({dimensions:"width"})})),i.register_alias("ybox_zoom",(function(){return new d({dimensions:"height"})}))},
function _(e,t,s,o,i){o();var n,_=e(1),a=e(493),l=e(332),r=e(496),c=e(158),p=e(343),y=function(e){function t(){var t=e.apply(this,(0,_.__spreadArray)([],(0,_.__read)(arguments),!1))||this;return t.sxs=[],t.sys=[],t}return(0,_.__extends)(t,e),t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,(function(){return t._active_change()}))},t.prototype._active_change=function(){this.model.active||this._clear_overlay()},t.prototype._keyup=function(e){e.keyCode==c.Keys.Enter&&this._clear_overlay()},t.prototype._pan_start=function(e){this.sxs=[],this.sys=[];var t=e.sx,s=e.sy;this._append_overlay(t,s)},t.prototype._pan=function(e){var t=(0,_.__read)(this.plot_view.frame.bbox.clip(e.sx,e.sy),2),s=t[0],o=t[1];this._append_overlay(s,o),this.model.select_every_mousemove&&this._do_select(this.sxs,this.sys,!1,this._select_mode(e))},t.prototype._pan_end=function(e){var t=this.sxs,s=this.sys;this._clear_overlay(),this._do_select(t,s,!0,this._select_mode(e)),this.plot_view.state.push("lasso_select",{selection:this.plot_view.get_selection()})},t.prototype._append_overlay=function(e,t){var s=this.sxs,o=this.sys;s.push(e),o.push(t),this.model.overlay.update({xs:s,ys:o})},t.prototype._clear_overlay=function(){this.sxs=[],this.sys=[],this.model.overlay.update({xs:this.sxs,ys:this.sys})},t.prototype._do_select=function(e,t,s,o){var i={type:"poly",sx:e,sy:t};this._select(i,s,o)},t}(a.SelectToolView);s.LassoSelectToolView=y,y.__name__="LassoSelectToolView";var h=function(e){function t(t){var s=e.call(this,t)||this;return s.tool_name="Lasso Select",s.icon=p.tool_icon_lasso_select,s.event_type="pan",s.default_order=12,s}return(0,_.__extends)(t,e),t}(a.SelectTool);s.LassoSelectTool=h,n=h,h.__name__="LassoSelectTool",n.prototype.default_view=y,n.define((function(e){return{select_every_mousemove:[e.Boolean,!0],overlay:[(0,e.Ref)(l.PolyAnnotation),r.DEFAULT_POLY_OVERLAY]}})),n.register_alias("lasso_select",(function(){return new h}))},
function _(t,e,o,i,n){i();var l,s=t(1),a=t(493),c=t(332),_=t(158),r=t(126),p=t(343),y=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,s.__extends)(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.data={sx:[],sy:[]}},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),this.connect(this.model.properties.active.change,(function(){return e._active_change()}))},e.prototype._active_change=function(){this.model.active||this._clear_data()},e.prototype._keyup=function(t){t.keyCode==_.Keys.Enter&&this._clear_data()},e.prototype._doubletap=function(t){this._do_select(this.data.sx,this.data.sy,!0,this._select_mode(t)),this.plot_view.state.push("poly_select",{selection:this.plot_view.get_selection()}),this._clear_data()},e.prototype._clear_data=function(){this.data={sx:[],sy:[]},this.model.overlay.update({xs:[],ys:[]})},e.prototype._tap=function(t){var e=t.sx,o=t.sy;this.plot_view.frame.bbox.contains(e,o)&&(this.data.sx.push(e),this.data.sy.push(o),this.model.overlay.update({xs:(0,r.copy)(this.data.sx),ys:(0,r.copy)(this.data.sy)}))},e.prototype._do_select=function(t,e,o,i){var n={type:"poly",sx:t,sy:e};this._select(n,o,i)},e}(a.SelectToolView);o.PolySelectToolView=y,y.__name__="PolySelectToolView";o.DEFAULT_POLY_OVERLAY=function(){return new c.PolyAnnotation({level:"overlay",xs_units:"screen",ys_units:"screen",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:2,line_dash:[4,4]})};var h=function(t){function e(e){var o=t.call(this,e)||this;return o.tool_name="Poly Select",o.icon=p.tool_icon_polygon_select,o.event_type="tap",o.default_order=11,o}return(0,s.__extends)(e,t),e}(a.SelectTool);o.PolySelectTool=h,l=h,h.__name__="PolySelectTool",l.prototype.default_view=y,l.define((function(t){return{overlay:[(0,t.Ref)(c.PolyAnnotation),o.DEFAULT_POLY_OVERLAY]}})),l.register_alias("poly_select",(function(){return new h}))},
function _(e,t,r,i,n){i();var s,_=e(1),o=e(135),d=e(498),a=e(343),l=function(e){function t(){var t=e.apply(this,(0,_.__spreadArray)([],(0,_.__read)(arguments),!1))||this;return t._drawing=!1,t}return(0,_.__extends)(t,e),t.prototype._doubletap=function(e){var t,r;if(this.model.active){var i=this.model.renderers;try{for(var n=(0,_.__values)(i),s=n.next();!s.done;s=n.next()){var o=s.value;1==this._select_event(e,"replace",[o]).length&&(this._selected_renderer=o)}}catch(e){t={error:e}}finally{try{s&&!s.done&&(r=n.return)&&r.call(n)}finally{if(t)throw t.error}}this._show_intersections(),this._update_line_cds()}},t.prototype._show_intersections=function(){if(this.model.active&&null!=this._selected_renderer){if(!this.model.renderers.length)return this._set_intersection([],[]),this._selected_renderer=null,void(this._drawing=!1);var e=this._selected_renderer.data_source,t=this._selected_renderer.glyph,r=(0,_.__read)([t.x.field,t.y.field],2),i=r[0],n=r[1],s=e.get_array(i),o=e.get_array(n);this._set_intersection(s,o)}},t.prototype._tap=function(e){var t=this.model.intersection_renderer;if(null!=this._map_drag(e.sx,e.sy,t)){if(this._drawing&&this._selected_renderer){var r=this._select_mode(e);if(0==this._select_event(e,r,[t]).length)return}var i=this._select_mode(e);this._select_event(e,i,[t]),this._select_event(e,i,this.model.renderers)}},t.prototype._update_line_cds=function(){if(null!=this._selected_renderer){var e=this.model.intersection_renderer.glyph,t=this.model.intersection_renderer.data_source,r=(0,_.__read)([e.x.field,e.y.field],2),i=r[0],n=r[1];if(i&&n){var s=t.data[i],o=t.data[n];this._selected_renderer.data_source.data[i]=s,this._selected_renderer.data_source.data[n]=o}this._emit_cds_changes(this._selected_renderer.data_source,!0,!0,!1)}},t.prototype._pan_start=function(e){this._select_event(e,"append",[this.model.intersection_renderer]),this._basepoint=[e.sx,e.sy]},t.prototype._pan=function(e){null!=this._basepoint&&(this._drag_points(e,[this.model.intersection_renderer],this.model.dimensions),this._selected_renderer&&this._selected_renderer.data_source.change.emit())},t.prototype._pan_end=function(e){null!=this._basepoint&&(this._drag_points(e,[this.model.intersection_renderer]),this._emit_cds_changes(this.model.intersection_renderer.data_source,!1,!0,!0),this._selected_renderer&&this._emit_cds_changes(this._selected_renderer.data_source),this._basepoint=null)},t.prototype.activate=function(){this._drawing=!0},t.prototype.deactivate=function(){this._selected_renderer&&(this._drawing&&(this._drawing=!1),this._hide_intersections())},t}(d.LineToolView);r.LineEditToolView=l,l.__name__="LineEditToolView";var c=function(e){function t(t){var r=e.call(this,t)||this;return r.tool_name="Line Edit Tool",r.icon=a.tool_icon_line_edit,r.event_type=["tap","pan","move"],r.default_order=4,r}return(0,_.__extends)(t,e),Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.dimensions)},enumerable:!1,configurable:!0}),t}(d.LineTool);r.LineEditTool=c,s=c,c.__name__="LineEditTool",s.prototype.default_view=l,s.define((function(){return{dimensions:[o.Dimensions,"both"]}}))},
function _(e,n,t,i,r){i();var o,_=e(1),s=e(125),a=e(485),c=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return(0,_.__extends)(n,e),n.prototype._set_intersection=function(e,n){var t=this.model.intersection_renderer.glyph,i=this.model.intersection_renderer.data_source,r=(0,_.__read)([t.x.field,t.y.field],2),o=r[0],a=r[1];o&&((0,s.isArray)(e)?i.data[o]=e:t.x={value:e}),a&&((0,s.isArray)(n)?i.data[a]=n:t.y={value:n}),this._emit_cds_changes(i,!0,!0,!1)},n.prototype._hide_intersections=function(){this._set_intersection([],[])},n}(a.EditToolView);t.LineToolView=c,c.__name__="LineToolView";var d=function(e){function n(n){return e.call(this,n)||this}return(0,_.__extends)(n,e),n}(a.EditTool);t.LineTool=d,o=d,d.__name__="LineTool",o.define((function(e){return{intersection_renderer:[(0,e.AnyRef)()]}}))},
function _(t,n,e,i,o){i();var a,s=t(1),r=t(338),_=t(135),l=(0,s.__importStar)(t(343));function h(t,n,e){var i,o,a=new Map;try{for(var r=(0,s.__values)(t),_=r.next();!_.done;_=r.next()){var l=(0,s.__read)(_.value,2),h=l[0],d=l[1],p=(0,s.__read)(d.r_invert(n,e),2),u=p[0],c=p[1];a.set(h,{start:u,end:c})}}catch(t){i={error:t}}finally{try{_&&!_.done&&(o=r.return)&&o.call(r)}finally{if(i)throw i.error}}return a}e.update_ranges=h;var d=function(t){function n(){return null!==t&&t.apply(this,arguments)||this}return(0,s.__extends)(n,t),n.prototype._pan_start=function(t){var n;this.last_dx=0,this.last_dy=0;var e=t.sx,i=t.sy,o=this.plot_view.frame.bbox;if(!o.contains(e,i)){var a=o.h_range,s=o.v_range;(e<a.start||e>a.end)&&(this.v_axis_only=!0),(i<s.start||i>s.end)&&(this.h_axis_only=!0)}null===(n=this.model.document)||void 0===n||n.interactive_start(this.plot_model)},n.prototype._pan=function(t){var n;this._update(t.deltaX,t.deltaY),null===(n=this.model.document)||void 0===n||n.interactive_start(this.plot_model)},n.prototype._pan_end=function(t){this.h_axis_only=!1,this.v_axis_only=!1,null!=this.pan_info&&this.plot_view.state.push("pan",{range:this.pan_info}),this.plot_view.trigger_ranges_update_event()},n.prototype._update=function(t,n){var e,i,o,a,s,r,_=this.plot_view.frame,l=t-this.last_dx,d=n-this.last_dy,p=_.bbox.h_range,u=p.start-l,c=p.end-l,v=_.bbox.v_range,f=v.start-d,y=v.end-d,m=this.model.dimensions;"width"!=m&&"both"!=m||this.v_axis_only?(e=p.start,i=p.end,o=0):(e=u,i=c,o=-l),"height"!=m&&"both"!=m||this.h_axis_only?(a=v.start,s=v.end,r=0):(a=f,s=y,r=-d),this.last_dx=t,this.last_dy=n;var x=_.x_scales,g=_.y_scales,w=h(x,e,i),b=h(g,a,s);this.pan_info={xrs:w,yrs:b,sdx:o,sdy:r},this.plot_view.update_range(this.pan_info,{panning:!0})},n}(r.GestureToolView);e.PanToolView=d,d.__name__="PanToolView";var p=function(t){function n(n){var e=t.call(this,n)||this;return e.tool_name="Pan",e.event_type="pan",e.default_order=10,e}return(0,s.__extends)(n,t),Object.defineProperty(n.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.dimensions)},enumerable:!1,configurable:!0}),n}(r.GestureTool);e.PanTool=p,a=p,p.__name__="PanTool",a.prototype.default_view=d,a.define((function(){return{dimensions:[_.Dimensions,"both",{on_update:function(t,n){switch(t){case"both":n.icon=l.tool_icon_pan;break;case"width":n.icon=l.tool_icon_xpan;break;case"height":n.icon=l.tool_icon_ypan}}}]}})),a.register_alias("pan",(function(){return new p({dimensions:"both"})})),a.register_alias("xpan",(function(){return new p({dimensions:"width"})})),a.register_alias("ypan",(function(){return new p({dimensions:"height"})}))},
function _(t,e,i,n,r){n();var s,l=t(1),a=t(231),o=t(173),_=t(134),h=t(338),d=t(343);function u(t){switch(t){case 1:return 2;case 2:return 1;case 4:return 5;case 5:return 4;default:return t}}function c(t,e,i,n){if(null==e)return!1;var r=i.compute(e);return Math.abs(t-r)<n}function y(t,e,i,n,r){var s=!0;if(null!=r.left&&null!=r.right){var l=i.invert(t);(l<r.left||l>r.right)&&(s=!1)}if(null!=r.bottom&&null!=r.top){var a=n.invert(e);(a<r.bottom||a>r.top)&&(s=!1)}return s}function g(t,e,i){var n=0;return t>=i.start&&t<=i.end&&(n+=1),e>=i.start&&e<=i.end&&(n+=1),n}function f(t,e,i,n){var r=e.compute(t),s=e.invert(r+i);return s>=n.start&&s<=n.end?s:t}function p(t,e,i){return t>e.start?(e.end=t,i):(e.end=e.start,e.start=t,u(i))}function v(t,e,i){return t<e.end?(e.start=t,i):(e.start=e.end,e.end=t,u(i))}function m(t,e,i,n){var r=(0,l.__read)(e.r_compute(t.start,t.end),2),s=r[0],a=r[1],o=(0,l.__read)(e.r_invert(s+i,a+i),2),_=o[0],h=o[1],d=g(t.start,t.end,n);g(_,h,n)>=d&&(t.start=_,t.end=h)}i.flip_side=u,i.is_near=c,i.is_inside=y,i.sides_inside=g,i.compute_value=f,i.update_range_end_side=p,i.update_range_start_side=v,i.update_range=m;var x=function(t){function e(){return null!==t&&t.apply(this,arguments)||this}return(0,l.__extends)(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.side=0,this.model.update_overlay_from_ranges()},e.prototype.connect_signals=function(){var e=this;t.prototype.connect_signals.call(this),null!=this.model.x_range&&this.connect(this.model.x_range.change,(function(){return e.model.update_overlay_from_ranges()})),null!=this.model.y_range&&this.connect(this.model.y_range.change,(function(){return e.model.update_overlay_from_ranges()}))},e.prototype._pan_start=function(t){this.last_dx=0,this.last_dy=0;var e=this.model.x_range,i=this.model.y_range,n=this.plot_view.frame,r=n.x_scale,s=n.y_scale,l=this.model.overlay,o=l.left,_=l.right,h=l.top,d=l.bottom,u=this.model.overlay.line_width+a.EDGE_TOLERANCE;null!=e&&this.model.x_interaction&&(c(t.sx,o,r,u)?this.side=1:c(t.sx,_,r,u)?this.side=2:y(t.sx,t.sy,r,s,l)&&(this.side=3)),null!=i&&this.model.y_interaction&&(0==this.side&&c(t.sy,d,s,u)&&(this.side=4),0==this.side&&c(t.sy,h,s,u)?this.side=5:y(t.sx,t.sy,r,s,this.model.overlay)&&(3==this.side?this.side=7:this.side=6))},e.prototype._pan=function(t){var e=this.plot_view.frame,i=t.deltaX-this.last_dx,n=t.deltaY-this.last_dy,r=this.model.x_range,s=this.model.y_range,l=e.x_scale,a=e.y_scale;if(null!=r)if(3==this.side||7==this.side)m(r,l,i,e.x_range);else if(1==this.side){var o=f(r.start,l,i,e.x_range);this.side=v(o,r,this.side)}else if(2==this.side){var _=f(r.end,l,i,e.x_range);this.side=p(_,r,this.side)}if(null!=s)if(6==this.side||7==this.side)m(s,a,n,e.y_range);else if(4==this.side){o=f(s.start,a,n,e.y_range);this.side=v(o,s,this.side)}else if(5==this.side){_=f(s.end,a,n,e.y_range);this.side=p(_,s,this.side)}this.last_dx=t.deltaX,this.last_dy=t.deltaY},e.prototype._pan_end=function(t){this.side=0,this.plot_view.trigger_ranges_update_event()},e}(h.GestureToolView);i.RangeToolView=x,x.__name__="RangeToolView";var w=function(){return new a.BoxAnnotation({level:"overlay",fill_color:"lightgrey",fill_alpha:.5,line_color:"black",line_alpha:1,line_width:.5,line_dash:[2,2]})},R=function(t){function e(e){var i=t.call(this,e)||this;return i.tool_name="Range Tool",i.icon=d.tool_icon_range,i.event_type="pan",i.default_order=1,i}return(0,l.__extends)(e,t),e.prototype.initialize=function(){t.prototype.initialize.call(this),this.overlay.in_cursor="grab",this.overlay.ew_cursor=null!=this.x_range&&this.x_interaction?"ew-resize":null,this.overlay.ns_cursor=null!=this.y_range&&this.y_interaction?"ns-resize":null},e.prototype.update_overlay_from_ranges=function(){null==this.x_range&&null==this.y_range&&(this.overlay.left=null,this.overlay.right=null,this.overlay.bottom=null,this.overlay.top=null,_.logger.warn("RangeTool not configured with any Ranges.")),null==this.x_range?(this.overlay.left=null,this.overlay.right=null):(this.overlay.left=this.x_range.start,this.overlay.right=this.x_range.end),null==this.y_range?(this.overlay.bottom=null,this.overlay.top=null):(this.overlay.bottom=this.y_range.start,this.overlay.top=this.y_range.end)},e}(h.GestureTool);i.RangeTool=R,s=R,R.__name__="RangeTool",s.prototype.default_view=x,s.define((function(t){var e=t.Boolean,i=t.Ref,n=t.Nullable;return{x_range:[n(i(o.Range1d)),null],x_interaction:[e,!0],y_range:[n(i(o.Range1d)),null],y_interaction:[e,!0],overlay:[i(a.BoxAnnotation),w]}}))},
function _(e,t,r,n,o){n();var i,a=e(1),l=e(493),s=e(135),_=e(343),c=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(t,e),t.prototype._tap=function(e){"tap"==this.model.gesture&&this._handle_tap(e)},t.prototype._doubletap=function(e){"doubletap"==this.model.gesture&&this._handle_tap(e)},t.prototype._handle_tap=function(e){var t={type:"point",sx:e.sx,sy:e.sy};this._select(t,!0,this._select_mode(e))},t.prototype._select=function(e,t,r){var n,o,i,l,s=this,_=this.model.callback;if("select"==this.model.behavior){var c=this._computed_renderers_by_data_source();try{for(var u=(0,a.__values)(c),p=u.next();!p.done;p=u.next()){var d=(0,a.__read)(p.value,2)[1],h=d[0].get_selection_manager(),v=d.map((function(e){return s.plot_view.renderer_view(e)})).filter((function(e){return null!=e}));if(h.select(v,e,t,r)&&null!=_){var f=v[0].coordinates.x_scale.invert(e.sx),y=v[0].coordinates.y_scale.invert(e.sy),m={geometries:(0,a.__assign)((0,a.__assign)({},e),{x:f,y:y}),source:h.source};_.execute(this.model,m)}}}catch(e){n={error:e}}finally{try{p&&!p.done&&(o=u.return)&&o.call(u)}finally{if(n)throw n.error}}this._emit_selection_event(e),this.plot_view.state.push("tap",{selection:this.plot_view.get_selection()})}else try{for(var g=(0,a.__values)(this.computed_renderers),x=g.next();!x.done;x=g.next()){var w=x.value,b=this.plot_view.renderer_view(w);if(null!=b)if((h=w.get_selection_manager()).inspect(b,e)&&null!=_){f=b.coordinates.x_scale.invert(e.sx),y=b.coordinates.y_scale.invert(e.sy),m={geometries:(0,a.__assign)((0,a.__assign)({},e),{x:f,y:y}),source:h.source};_.execute(this.model,m)}}}catch(e){i={error:e}}finally{try{x&&!x.done&&(l=g.return)&&l.call(g)}finally{if(i)throw i.error}}},t}(l.SelectToolView);r.TapToolView=c,c.__name__="TapToolView";var u=function(e){function t(t){var r=e.call(this,t)||this;return r.tool_name="Tap",r.icon=_.tool_icon_tap_select,r.event_type="tap",r.default_order=10,r}return(0,a.__extends)(t,e),t}(l.SelectTool);r.TapTool=u,i=u,u.__name__="TapTool",i.prototype.default_view=c,i.define((function(e){var t=e.Any,r=e.Enum,n=e.Nullable;return{behavior:[s.TapBehavior,"select"],gesture:[r("tap","doubletap"),"tap"],callback:[n(t)]}})),i.register_alias("click",(function(){return new u({behavior:"inspect"})})),i.register_alias("tap",(function(){return new u})),i.register_alias("doubletap",(function(){return new u({gesture:"doubletap"})}))},
function _(e,t,n,i,r){i();var o,a=e(1),s=e(338),_=e(135),l=e(343),u=e(499),h=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,a.__extends)(t,e),t.prototype._scroll=function(e){var t=this.model.speed*e.delta;t>.9?t=.9:t<-.9&&(t=-.9),this._update_ranges(t)},t.prototype._update_ranges=function(e){var t,n,i,r,o,s=this,_=this.plot_view.frame,l=_.bbox.h_range,h=_.bbox.v_range,d=(0,a.__read)([l.start,l.end],2),p=d[0],c=d[1],f=(0,a.__read)([h.start,h.end],2),g=f[0],m=f[1];switch(this.model.dimension){case"height":var v=Math.abs(m-g);n=p,i=c,r=g-v*e,o=m-v*e;break;case"width":var w=Math.abs(c-p);n=p-w*e,i=c-w*e,r=g,o=m}var b=_.x_scales,y=_.y_scales,x={xrs:(0,u.update_ranges)(b,n,i),yrs:(0,u.update_ranges)(y,r,o),factor:e};this.plot_view.state.push("wheel_pan",{range:x}),this.plot_view.update_range(x,{scrolling:!0}),null===(t=this.model.document)||void 0===t||t.interactive_start(this.plot_model,(function(){return s.plot_view.trigger_ranges_update_event()}))},t}(s.GestureToolView);n.WheelPanToolView=h,h.__name__="WheelPanToolView";var d=function(e){function t(t){var n=e.call(this,t)||this;return n.tool_name="Wheel Pan",n.icon=l.tool_icon_wheel_pan,n.event_type="scroll",n.default_order=12,n}return(0,a.__extends)(t,e),Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.dimension)},enumerable:!1,configurable:!0}),t}(s.GestureTool);n.WheelPanTool=d,o=d,d.__name__="WheelPanTool",o.prototype.default_view=h,o.define((function(){return{dimension:[_.Dimension,"width"]}})),o.internal((function(e){return{speed:[e.Number,.001]}})),o.register_alias("xwheel_pan",(function(){return new d({dimension:"width"})})),o.register_alias("ywheel_pan",(function(){return new d({dimension:"height"})}))},
function _(e,o,t,i,n){i();var s,r=e(1),l=e(338),_=e(483),a=e(135),h=e(142),u=e(343),m=function(e){function o(){return null!==e&&e.apply(this,arguments)||this}return(0,r.__extends)(o,e),o.prototype._pinch=function(e){var o,t=e.sx,i=e.sy,n=e.scale,s=e.ctrlKey,r=e.shiftKey;o=n>=1?20*(n-1):-20/n,this._scroll({type:"wheel",sx:t,sy:i,delta:o,ctrlKey:s,shiftKey:r})},o.prototype._scroll=function(e){var o,t=this,i=this.plot_view.frame,n=i.bbox.h_range,s=i.bbox.v_range,r=e.sx,l=e.sy,a=this.model.dimensions,h=("width"==a||"both"==a)&&n.start<r&&r<n.end,u=("height"==a||"both"==a)&&s.start<l&&l<s.end;if(h&&u||this.model.zoom_on_axis){var m=this.model.speed*e.delta,c=(0,_.scale_range)(i,m,h,u,{x:r,y:l});this.plot_view.state.push("wheel_zoom",{range:c});var d=this.model.maintain_focus;this.plot_view.update_range(c,{scrolling:!0,maintain_focus:d}),null===(o=this.model.document)||void 0===o||o.interactive_start(this.plot_model,(function(){return t.plot_view.trigger_ranges_update_event()}))}},o}(l.GestureToolView);t.WheelZoomToolView=m,m.__name__="WheelZoomToolView";var c=function(e){function o(o){var t=e.call(this,o)||this;return t.tool_name="Wheel Zoom",t.icon=u.tool_icon_wheel_zoom,t.event_type=h.is_mobile?"pinch":"scroll",t.default_order=10,t}return(0,r.__extends)(o,e),Object.defineProperty(o.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.dimensions)},enumerable:!1,configurable:!0}),o}(l.GestureTool);t.WheelZoomTool=c,s=c,c.__name__="WheelZoomTool",s.prototype.default_view=m,s.define((function(e){var o=e.Boolean,t=e.Number;return{dimensions:[a.Dimensions,"both"],maintain_focus:[o,!0],zoom_on_axis:[o,!0],speed:[t,1/600]}})),s.register_alias("wheel_zoom",(function(){return new c({dimensions:"both"})})),s.register_alias("xwheel_zoom",(function(){return new c({dimensions:"width"})})),s.register_alias("ywheel_zoom",(function(){return new c({dimensions:"height"})}))},
function _(n,t,e,i,o){i();var r,s=n(1),l=n(347),a=n(334),h=n(135),u=n(128),_=n(343),p=function(n){function t(){return null!==n&&n.apply(this,arguments)||this}return(0,s.__extends)(t,n),t.prototype._move=function(n){if(this.model.active){var t=n.sx,e=n.sy;this.plot_view.frame.bbox.contains(t,e)?this._update_spans(t,e):this._update_spans(null,null)}},t.prototype._move_exit=function(n){this._update_spans(null,null)},t.prototype._update_spans=function(n,t){var e=this.model.dimensions;"width"!=e&&"both"!=e||(this.model.spans.width.location=t),"height"!=e&&"both"!=e||(this.model.spans.height.location=n)},t}(l.InspectToolView);e.CrosshairToolView=p,p.__name__="CrosshairToolView";var c=function(n){function t(t){var e=n.call(this,t)||this;return e.tool_name="Crosshair",e.icon=_.tool_icon_crosshair,e}return(0,s.__extends)(t,n),Object.defineProperty(t.prototype,"tooltip",{get:function(){return this._get_dim_tooltip(this.dimensions)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"synthetic_renderers",{get:function(){return(0,u.values)(this.spans)},enumerable:!1,configurable:!0}),t}(l.InspectTool);e.CrosshairTool=c,r=c,c.__name__="CrosshairTool",function(){function n(n,t){return new a.Span({for_hover:!0,dimension:t,location_units:"screen",level:"overlay",line_color:n.line_color,line_width:n.line_width,line_alpha:n.line_alpha})}r.prototype.default_view=p,r.define((function(n){var t=n.Alpha,e=n.Number,i=n.Color;return{dimensions:[h.Dimensions,"both"],line_color:[i,"black"],line_width:[e,1],line_alpha:[t,1]}})),r.internal((function(t){var e=t.Struct,i=t.Ref;return{spans:[e({width:i(a.Span),height:i(a.Span)}),function(t){return{width:n(t,"width"),height:n(t,"height")}}]}})),r.register_alias("crosshair",(function(){return new c}))}()},
function _(e,r,t,n,a){n();var o,i=e(1),s=e(168),_=e(128),u=e(149),c=function(e){function r(r){return e.call(this,r)||this}return(0,i.__extends)(r,e),Object.defineProperty(r.prototype,"values",{get:function(){return(0,_.values)(this.args)},enumerable:!1,configurable:!0}),r.prototype._make_code=function(e,r,t,n){return new(Function.bind.apply(Function,(0,i.__spreadArray)((0,i.__spreadArray)([void 0],(0,i.__read)((0,_.keys)(this.args)),!1),[e,r,t,(0,u.use_strict)(n)],!1)))},r.prototype.format=function(e,r,t){return this._make_code("value","format","special_vars",this.code).apply(void 0,(0,i.__spreadArray)((0,i.__spreadArray)([],(0,i.__read)(this.values),!1),[e,r,t],!1))},r}(s.Model);t.CustomJSHover=c,o=c,c.__name__="CustomJSHover",o.define((function(e){var r=e.Unknown,t=e.String;return{args:[(0,e.Dict)(r),{}],code:[t,""]}}))},
function _(e,t,r,n,a){n();var i,o=e(1),l=e(347),s=e(505),_=e(356),c=e(290),d=e(454),u=e(291),p=e(292),h=e(398),v=(0,o.__importStar)(e(300)),y=e(267),f=e(158),m=e(137),x=e(128),w=e(349),g=e(125),b=e(228),k=e(135),C=e(343),S=e(130),T=e(181),R=(0,o.__importStar)(e(357)),A=e(507);function M(e,t,r,n,a,i){var o,l,s={x:a[e],y:i[e]},_={x:a[e+1],y:i[e+1]};if("span"==t.type)"h"==t.direction?(o=Math.abs(s.x-r),l=Math.abs(_.x-r)):(o=Math.abs(s.y-n),l=Math.abs(_.y-n));else{var c={x:r,y:n};o=v.dist_2_pts(s,c),l=v.dist_2_pts(_,c)}return o<l?[[s.x,s.y],e]:[[_.x,_.y],e+1]}function $(e,t,r){return[[e[r],t[r]],r]}r._nearest_line_hit=M,r._line_hit=$;var G=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return(0,o.__extends)(t,e),t.prototype.initialize=function(){e.prototype.initialize.call(this),this._ttmodels=new Map,this._ttviews=new Map},t.prototype.lazy_initialize=function(){return(0,o.__awaiter)(this,void 0,void 0,(function(){var t,r;return(0,o.__generator)(this,(function(n){switch(n.label){case 0:return[4,e.prototype.lazy_initialize.call(this)];case 1:return n.sent(),[4,this._update_ttmodels()];case 2:return n.sent(),(t=this.model.tooltips)instanceof A.Template?(r=this,[4,(0,b.build_view)(t,{parent:this})]):[3,4];case 3:r._template_view=n.sent(),this._template_view.render(),n.label=4;case 4:return[2]}}))}))},t.prototype.remove=function(){var t;null===(t=this._template_view)||void 0===t||t.remove(),(0,b.remove_views)(this._ttviews),e.prototype.remove.call(this)},t.prototype.connect_signals=function(){var t=this;e.prototype.connect_signals.call(this);var r=this.plot_model.properties.renderers,n=this.model.properties,a=n.renderers,i=n.tooltips;this.on_change(i,(function(){return delete t._template_el})),this.on_change([r,a,i],(function(){return(0,o.__awaiter)(t,void 0,void 0,(function(){return(0,o.__generator)(this,(function(e){switch(e.label){case 0:return[4,this._update_ttmodels()];case 1:return[2,e.sent()]}}))}))}))},t.prototype._update_ttmodels=function(){return(0,o.__awaiter)(this,void 0,void 0,(function(){var e,t,r,n,a,i,l,s,u,p,h,v,y,f,m,x,w,k,C,T,R,A;return(0,o.__generator)(this,(function(M){switch(M.label){case 0:if(t=(e=this)._ttmodels,r=e.computed_renderers,t.clear(),null!=(n=this.model.tooltips))try{for(a=(0,o.__values)(this.computed_renderers),i=a.next();!i.done;i=a.next())x=i.value,l=new _.Tooltip({custom:(0,g.isString)(n)||(0,g.isFunction)(n),attachment:this.model.attachment,show_arrow:this.model.show_arrow}),x instanceof c.GlyphRenderer?t.set(x,l):x instanceof d.GraphRenderer&&(t.set(x.node_renderer,l),t.set(x.edge_renderer,l))}catch(e){w={error:e}}finally{try{i&&!i.done&&(k=a.return)&&k.call(a)}finally{if(w)throw w.error}}return[4,(0,b.build_views)(this._ttviews,(0,o.__spreadArray)([],(0,o.__read)(t.values()),!1),{parent:this.plot_view})];case 1:s=M.sent();try{for(u=(0,o.__values)(s),p=u.next();!p.done;p=u.next())p.value.render()}catch(e){C={error:e}}finally{try{p&&!p.done&&(T=u.return)&&T.call(u)}finally{if(C)throw C.error}}h=(0,o.__spreadArray)([],(0,o.__read)(function(){var e,t,n,a,i,l;return(0,o.__generator)(this,(function(s){switch(s.label){case 0:s.trys.push([0,8,9,10]),e=(0,o.__values)(r),t=e.next(),s.label=1;case 1:return t.done?[3,7]:(n=t.value)instanceof c.GlyphRenderer?[4,n]:[3,3];case 2:return s.sent(),[3,6];case 3:return n instanceof d.GraphRenderer?[4,n.node_renderer]:[3,6];case 4:return s.sent(),[4,n.edge_renderer];case 5:s.sent(),s.label=6;case 6:return t=e.next(),[3,1];case 7:return[3,10];case 8:return a=s.sent(),i={error:a},[3,10];case 9:try{t&&!t.done&&(l=e.return)&&l.call(e)}finally{if(i)throw i.error}return[7];case 10:return[2]}}))}()),!1),null!=(v=this._slots.get(this._update))&&(y=new Set(h.map((function(e){return e.data_source}))),S.Signal.disconnect_receiver(this,v,y));try{for(f=(0,o.__values)(h),m=f.next();!m.done;m=f.next())x=m.value,this.connect(x.data_source.inspect,this._update)}catch(e){R={error:e}}finally{try{m&&!m.done&&(A=f.return)&&A.call(f)}finally{if(R)throw R.error}}return[2]}}))}))},Object.defineProperty(t.prototype,"computed_renderers",{get:function(){var e=this.model,t=e.renderers,r=e.names,n=this.plot_model.data_renderers;return(0,T.compute_renderers)(t,n,r)},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"ttmodels",{get:function(){return this._ttmodels},enumerable:!1,configurable:!0}),t.prototype._clear=function(){var e,t;this._inspect(1/0,1/0);try{for(var r=(0,o.__values)(this.ttmodels),n=r.next();!n.done;n=r.next()){(0,o.__read)(n.value,2)[1].clear()}}catch(t){e={error:t}}finally{try{n&&!n.done&&(t=r.return)&&t.call(r)}finally{if(e)throw e.error}}},t.prototype._move=function(e){if(this.model.active){var t=e.sx,r=e.sy;this.plot_view.frame.bbox.contains(t,r)?this._inspect(t,r):this._clear()}},t.prototype._move_exit=function(){this._clear()},t.prototype._inspect=function(e,t){var r,n,a;"mouse"==this.model.mode?a={type:"point",sx:e,sy:t}:a={type:"span",direction:"vline"==this.model.mode?"h":"v",sx:e,sy:t};try{for(var i=(0,o.__values)(this.computed_renderers),l=i.next();!l.done;l=i.next()){var s=l.value,_=s.get_selection_manager(),c=this.plot_view.renderer_view(s);null!=c&&_.inspect(c,a)}}catch(e){r={error:e}}finally{try{l&&!l.done&&(n=i.return)&&n.call(i)}finally{if(r)throw r.error}}this._emit_callback(a)},t.prototype._update=function(e){var t,r,n,a,i,l,s,_,d,u,v,y,m,w,g,b,k,C,S,T,R,A,G,z,H,P,O,V,F=(0,o.__read)(e,2),N=F[0],q=F[1].geometry;if(this.model.active&&("point"==q.type||"span"==q.type)&&N instanceof c.GlyphRenderer&&("ignore"!=this.model.muted_policy||!N.muted)){var L=this.ttmodels.get(N);if(null!=L){var j=N.get_selection_manager(),D=j.inspectors.get(N),E=N.view.convert_selection_to_subset(D);if(D.is_empty())L.clear();else{var I=j.source,B=this.plot_view.renderer_view(N);if(null!=B){var J=q.sx,K=q.sy,Q=B.coordinates.x_scale,U=B.coordinates.y_scale,W=Q.invert(J),X=U.invert(K),Y=B.glyph,Z=[];if(Y instanceof p.LineView)try{for(var ee=(0,o.__values)(E.line_indices),te=ee.next();!te.done;te=ee.next()){var re=te.value,ne=Y._x[re+1],ae=Y._y[re+1],ie=re,oe=void 0,le=void 0;switch(this.model.line_policy){case"interp":ne=(n=(0,o.__read)(Y.get_interpolation_hit(re,q),2))[0],ae=n[1],oe=Q.compute(ne),le=U.compute(ae);break;case"prev":a=(0,o.__read)($(Y.sx,Y.sy,re),2),oe=(i=(0,o.__read)(a[0],2))[0],le=i[1],ie=a[1];break;case"next":l=(0,o.__read)($(Y.sx,Y.sy,re+1),2),oe=(s=(0,o.__read)(l[0],2))[0],le=s[1],ie=l[1];break;case"nearest":_=(0,o.__read)(M(re,q,J,K,Y.sx,Y.sy),2),oe=(d=(0,o.__read)(_[0],2))[0],le=d[1],ie=_[1],ne=Y._x[ie],ae=Y._y[ie];break;default:oe=(u=(0,o.__read)([J,K],2))[0],le=u[1]}var se={index:ie,x:W,y:X,sx:J,sy:K,data_x:ne,data_y:ae,rx:oe,ry:le,indices:E.line_indices,name:N.name};Z.push([oe,le,this._render_tooltips(I,ie,se)])}}catch(e){t={error:e}}finally{try{te&&!te.done&&(r=ee.return)&&r.call(ee)}finally{if(t)throw t.error}}try{for(var _e=(0,o.__values)(D.image_indices),ce=_e.next();!ce.done;ce=_e.next()){var de=ce.value,ue=(se={index:de.index,x:W,y:X,sx:J,sy:K,name:N.name},this._render_tooltips(I,de,se));Z.push([J,K,ue])}}catch(e){v={error:e}}finally{try{ce&&!ce.done&&(y=_e.return)&&y.call(_e)}finally{if(v)throw v.error}}try{for(var pe=(0,o.__values)(E.indices),he=pe.next();!he.done;he=pe.next()){re=he.value;if(Y instanceof h.MultiLineView&&!(0,x.isEmpty)(E.multiline_indices))try{for(var ve=(g=void 0,(0,o.__values)(E.multiline_indices[re.toString()])),ye=ve.next();!ye.done;ye=ve.next()){var fe=ye.value,me=(ne=Y._xs.get(re)[fe],ae=Y._ys.get(re)[fe],fe);oe=void 0,le=void 0;switch(this.model.line_policy){case"interp":ne=(k=(0,o.__read)(Y.get_interpolation_hit(re,fe,q),2))[0],ae=k[1],oe=Q.compute(ne),le=U.compute(ae);break;case"prev":C=(0,o.__read)($(Y.sxs.get(re),Y.sys.get(re),fe),2),oe=(S=(0,o.__read)(C[0],2))[0],le=S[1],me=C[1];break;case"next":T=(0,o.__read)($(Y.sxs.get(re),Y.sys.get(re),fe+1),2),oe=(R=(0,o.__read)(T[0],2))[0],le=R[1],me=T[1];break;case"nearest":A=(0,o.__read)(M(fe,q,J,K,Y.sxs.get(re),Y.sys.get(re)),2),oe=(G=(0,o.__read)(A[0],2))[0],le=G[1],me=A[1],ne=Y._xs.get(re)[me],ae=Y._ys.get(re)[me];break;default:throw new Error("shouldn't have happened")}var xe=void 0;se={index:xe=N instanceof c.GlyphRenderer?N.view.convert_indices_from_subset([re])[0]:re,x:W,y:X,sx:J,sy:K,data_x:ne,data_y:ae,segment_index:me,indices:E.multiline_indices,name:N.name};Z.push([oe,le,this._render_tooltips(I,xe,se)])}}catch(e){g={error:e}}finally{try{ye&&!ye.done&&(b=ve.return)&&b.call(ve)}finally{if(g)throw g.error}}else{ne=null===(O=Y._x)||void 0===O?void 0:O[re],ae=null===(V=Y._y)||void 0===V?void 0:V[re],oe=void 0,le=void 0;if("snap_to_data"==this.model.point_policy){v