#------------------------------------------------------------------------------
# Copyright (c) 2005, Enthought, Inc.
# All rights reserved.
#
# This software is provided without warranty under the terms of the BSD
# license included in enthought/LICENSE.txt and may be redistributed only
# under the conditions described in the aforementioned license.  The license
# is also available online at http://www.enthought.com/licenses/BSD.txt
# Thanks for using Enthought open source!
#
# Author: David C. Morrill
# Description: Test 'Person' class for the View Editing Tool
#------------------------------------------------------------------------------

#-------------------------------------------------------------------------------
#  Imports:
#-------------------------------------------------------------------------------

from traits.api import HasStrictTraits, Trait, Font, Color, \
                                Str, Range, List, Instance, RGBColor
from traitsui.api import CodeEditor, View

#-------------------------------------------------------------------------------
#  'Person' class:
#-------------------------------------------------------------------------------

class Person ( HasStrictTraits ):

    #---------------------------------------------------------------------------
    #  Trait definitions:
    #---------------------------------------------------------------------------

    name       = Str
    age        = Range( 0, 120 )
    weight     = Range( 0.0, 500.0 )
    eye_color  = Color( 'blue' )
    rgb_color = RGBColor( 'green' )
    sex        = Trait( 'male', 'female' )
    code       = Str( editor = CodeEditor )
    wx_font    = Font
    children   = List( Instance( 'Person' ), use_notebook = True )

    #---------------------------------------------------------------------------
    #  Traits view definition:
    #---------------------------------------------------------------------------

    traits_view = View( 'name', 'age', 'weight' )


