#!/usr/bin/env python

import sys
from distutils.core import setup


long_desc = """You can use this Python module to convert amongst many
different notations and to manage couples of address/netmask
in the CIDR notation.
"""

classifiers = """\
Development Status :: 4 - Beta
Development Status :: 5 - Production/Stable
Environment :: Console
Environment :: No Input/Output (Daemon)
Intended Audience :: Developers
Intended Audience :: End Users/Desktop
License :: OSI Approved :: GNU General Public License (GPL)
Natural Language :: English
Operating System :: OS Independent
Programming Language :: Python
Topic :: Software Development :: Libraries :: Python Modules
Topic :: System :: Networking
Topic :: Internet
Topic :: Utilities
"""

if sys.version_info < (2, 3):
    _setup = setup
    def setup(**kwargs):
        if kwargs.has_key('classifiers'):
            del kwargs['classifiers']
        if kwargs.has_key('download_url'):
            del kwargs['download_url']
        _setup(**kwargs)

setup(name = 'iplib',
      version = '0.7',
      description = 'convert amongst many different IPv4 notations',
      long_description = long_desc,
      author = 'Davide Alberani',
      author_email = 'davide.alberani@erlug.linux.it',
      maintainer = 'Davide Alberani',
      maintainer_email = 'davide.alberani@erlug.linux.it',
      url = 'http://digilander.libero.it/alberanid/soft/iplib/',
      download_url = 'http://digilander.libero.it/alberanid/soft/iplib/',
      license = 'GPL',
      platforms = 'any',
      classifiers = filter(None, classifiers.split("\n")),
      keywords = ['ip', 'address', 'quad', 'dot', 'notation',
                    'binary', 'octal', 'hexadecimal', 'netmask', 'cidr'],
      py_modules = ['iplib'])



