<!--
If your issue is a usage question, submit it our Google Group instead: 
https://groups.google.com/forum/#!forum/librosa
-->

<!-- Instructions For Filing a Bug: https://github.com/librosa/librosa/blob/master/CONTRIBUTING.md#filing-bugs -->

#### Description
<!-- Example: Error when computing spectral_contrast on a single frame-->

#### Steps/Code to Reproduce
<!--
Example:
```
import librosa

# Generate one frame of random STFT-like energy
S = np.random.randn(1025, 1)**2

contrast = librosa.feature.spectral_contrast(S=S)
```
If the code is too long, feel free to put it in a public gist and link
it in the issue: https://gist.github.com
-->

#### Expected Results
<!-- Example: contrast should have shape (1, 1)-->

#### Actual Results
<!-- Please paste or specifically describe the actual output or traceback. -->

#### Versions
<!--
Please run the following snippet and paste the output below.
import platform; print(platform.platform())
import sys; print("Python", sys.version)
import numpy; print("NumPy", numpy.__version__)
import scipy; print("SciPy", scipy.__version__)
import librosa; print("librosa", librosa.__version__)
-->


<!-- Thanks for contributing! -->
