# Local Pipelines

Local Pipelines parses your `bitbucket-pipelines.yml` and runs it locally
using your local Docker instance.  There is no build reporting aside from exit
status.  It supports both [Mercurial](https://www.mercurial-scm.org/) and
[Git](https://git-scm.com/).

## Installation

local-pipelines can be easily installed from [pypi](https://pypi.python.org).
The following command will install local-pipelines locally for your user:

    pip install -U --user local-pipelines

Once installation is complete make sure that `~/.local/bin` is in your `$PATH`.

## Running

You can run your your `bitbucket-pipelines.yml` from the working directory with
the following command:

    pipelines

If you want to run it from another directory you can use the `-f` argument to
specify the path to the file.

    pipelines -f /path/to/bitbucket-pipelines.yml

### Environment Variables

You can specify environment variables by using the `-e` or `--env` options on
the command line.

You can also use `--env-file` to specify one or more files to load environment
variables from.  These files will be evaluated in the order given and will
over write values that were set previously.

For example, you can ship a `common.env` which all includes settings common to
all members/users of your project.  Then your members/users can override
settings in `common.env` or set sensitive settings by using another env file.

#### Example

##### common.env

    LOG_LEVEL=info
    PORT=5000

##### user.env

    DEBUG=true
    LOG_LEVEL=debug

You can then run the pipeline with

    pipelines --env-file=common.env --env-file=user.env

The resulting will look like the following

    DEBUG=true
    LOG_LEVEL=debug
    PORT=5000

## Licensing

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
