# Explanation

The explanation section aims to clarify, deepen, and broaden the understanding of Panel with discussions about topics at a high-level or from alternate angles. This may include reasoning about design decisions, historical development, and technical constraints.

Beyond the [Getting Started > Core Concepts](../getting_started/core_concepts.md), which new users must complete before working with Panel, this explanation section is intended to help practitioners form and strengthen a conceptual web that facilitates new and advanced usage directions.

## APIs

::::{grid} 1 2 2 3
:gutter: 1 1 1 2

:::{grid-item-card} {octicon}`workflow;2.5em;sd-mr-1 sd-animate-grow50` API context
:link: api/index
:link-type: doc

Learn the pros and cons of Panel's different APIs.
:::

::::

## Components

::::{grid} 1 2 2 3
:gutter: 1 1 1 2

:::{grid-item-card} {octicon}`rows;2.5em;sd-mr-1 sd-animate-grow50` Components overview
:link: components/components_overview
:link-type: doc

Deepen your understanding about Panel's visible objects and layouts types.
:::

:::{grid-item-card} {octicon}`plus-circle;2.5em;sd-mr-1 sd-animate-grow50` Custom components
:link: components/components_custom
:link-type: doc

Deepen your understanding about building custom Panel components.
:::

::::

## Linking

::::{grid} 1 2 2 3
:gutter: 1 1 1 2

:::{grid-item-card} {octicon}`arrow-both;2.5em;sd-mr-1 sd-animate-grow50` Panel Communications
:link: comms/comms
:link-type: doc

Deepen your understanding about how Panel communicates between Python and Javascript in different contexts.
:::

::::

## Styling

::::{grid} 1 2 2 3
:gutter: 1 1 1 2

:::{grid-item-card} {octicon}`repo-template;2.5em;sd-mr-1 sd-animate-grow50` Templates
:link: templates/templates_overview
:link-type: doc

Deepen your understanding about Template styling in Panel.
:::

::::
## Dependencies

::::{grid} 1 2 2 3
:gutter: 1 1 1 2

:::{grid-item-card} Panel and Param
:link: dependencies/param
:link-type: doc

Learn about why Panel utilizes the Param library.

```{image} https://assets.holoviz.org/panel/background/dependencies/param_logo_stacked.png
:width: 125px
:align: center
:name: Param
```

:::

:::{grid-item-card} Panel and Bokeh
:link: dependencies/bokeh
:link-type: doc

Learn about why Panel utilizes the Bokeh library.

```{image} https://assets.holoviz.org/panel/background/dependencies/bokeh-icon%405x.png
:width: 125px
:align: center
:name: Bokeh
```

:::

::::

## Technology comparisons

::::{grid} 1 2 2 3
:gutter: 1 1 1 2

:::{grid-item-card} Panel vs. Dash
:link: comparisons/compare_dash
:link-type: doc

```{image} https://assets.holoviz.org/panel/background/comparisons/dash_logo.png
:width: 125px
:align: center
:name: Dash
```

:::

:::{grid-item-card} Panel vs. ipywidgets
:link: comparisons/compare_ipywidgets
:link-type: doc

```{image} https://assets.holoviz.org/panel/background/comparisons/jupyter_logo.png
:height: 125px
:align: center
:name: ipywidgets
```

:::

:::{grid-item-card} Panel vs. Voila
:link: comparisons/compare_voila
:link-type: doc

```{image} https://assets.holoviz.org/panel/background/comparisons/voila_logo.webp
:width: 125px
:align: center
:name: Voila
```

:::

:::{grid-item-card} Panel vs. Streamlit
:link: comparisons/compare_streamlit
:link-type: doc

```{image} https://assets.holoviz.org/panel/background/comparisons/streamlit_logo.png
:width: 125px
:align: center
:name: Streamlit
```

:::

:::{grid-item-card} Panel vs. JavaScript
:link: comparisons/compare_js
:link-type: doc

```{image} https://assets.holoviz.org/panel/background/comparisons/JavaScript_logo.png
:width: 125px
:align: center
:name: JavaScript
```

:::

:::{grid-item-card} Panel vs. Bokeh
:link: comparisons/compare_bokeh
:link-type: doc

```{image} https://assets.holoviz.org/panel/background/dependencies/bokeh-icon%405x.png
:width: 125px
:align: center
:name: Bokeh
```

:::

::::

```{toctree}
:titlesonly:
:hidden:
:maxdepth: 2

apis
components
linking
styling
dependencies
comparisons
```
