(() => {
  var __defProp = Object.defineProperty;
  var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
  var __esm = (fn, res) => function __init() {
    return fn && (res = (0, fn[Object.keys(fn)[0]])(fn = 0)), res;
  };
  var __commonJS = (cb, mod) => function __require() {
    return mod || (0, cb[Object.keys(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
  };
  var __export = (target, all) => {
    __markAsModule(target);
    for (var name in all)
      __defProp(target, name, { get: all[name], enumerable: true });
  };

  // src/lib/parse-json.ts
  function parseJSONSync(jsonText, options) {
    try {
      const json = JSON.parse(jsonText);
      if (options.json?.table) {
        return getFirstArray(json) || json;
      }
      return json;
    } catch (error) {
      throw new Error("JSONLoader: failed to parse JSON");
    }
  }
  function getFirstArray(json) {
    if (Array.isArray(json)) {
      return json;
    }
    if (json && typeof json === "object") {
      for (const value of Object.values(json)) {
        const array = getFirstArray(value);
        if (array) {
          return array;
        }
      }
    }
    return null;
  }
  var init_parse_json = __esm({
    "src/lib/parse-json.ts"() {
    }
  });

  // ../schema/src/lib/batches/base-table-batch-aggregator.ts
  var DEFAULT_ROW_COUNT, RowTableBatchAggregator;
  var init_base_table_batch_aggregator = __esm({
    "../schema/src/lib/batches/base-table-batch-aggregator.ts"() {
      DEFAULT_ROW_COUNT = 100;
      RowTableBatchAggregator = class {
        constructor(schema, options) {
          this.length = 0;
          this.rows = null;
          this.cursor = 0;
          this._headers = [];
          this.options = options;
          this.schema = schema;
          if (!Array.isArray(schema)) {
            this._headers = [];
            for (const key in schema) {
              this._headers[schema[key].index] = schema[key].name;
            }
          }
        }
        rowCount() {
          return this.length;
        }
        addArrayRow(row, cursor) {
          if (Number.isFinite(cursor)) {
            this.cursor = cursor;
          }
          this.rows = this.rows || new Array(DEFAULT_ROW_COUNT);
          this.rows[this.length] = row;
          this.length++;
        }
        addObjectRow(row, cursor) {
          if (Number.isFinite(cursor)) {
            this.cursor = cursor;
          }
          this.rows = this.rows || new Array(DEFAULT_ROW_COUNT);
          this.rows[this.length] = row;
          this.length++;
        }
        getBatch() {
          let rows = this.rows;
          if (!rows) {
            return null;
          }
          rows = rows.slice(0, this.length);
          this.rows = null;
          const batch = {
            shape: this.options.shape,
            batchType: "data",
            data: rows,
            length: this.length,
            schema: this.schema,
            cursor: this.cursor
          };
          return batch;
        }
      };
    }
  });

  // ../schema/src/lib/utils/row-utils.ts
  function convertToObjectRow(arrayRow, headers) {
    if (!arrayRow) {
      throw new Error("null row");
    }
    if (!headers) {
      throw new Error("no headers");
    }
    const objectRow = {};
    for (let i = 0; i < headers.length; i++) {
      objectRow[headers[i]] = arrayRow[i];
    }
    return objectRow;
  }
  function convertToArrayRow(objectRow, headers) {
    if (!objectRow) {
      throw new Error("null row");
    }
    if (!headers) {
      throw new Error("no headers");
    }
    const arrayRow = new Array(headers.length);
    for (let i = 0; i < headers.length; i++) {
      arrayRow[i] = objectRow[headers[i]];
    }
    return arrayRow;
  }
  var init_row_utils = __esm({
    "../schema/src/lib/utils/row-utils.ts"() {
    }
  });

  // ../schema/src/lib/batches/row-table-batch-aggregator.ts
  var DEFAULT_ROW_COUNT2, RowTableBatchAggregator2;
  var init_row_table_batch_aggregator = __esm({
    "../schema/src/lib/batches/row-table-batch-aggregator.ts"() {
      init_row_utils();
      DEFAULT_ROW_COUNT2 = 100;
      RowTableBatchAggregator2 = class {
        constructor(schema, options) {
          this.length = 0;
          this.objectRows = null;
          this.arrayRows = null;
          this.cursor = 0;
          this._headers = [];
          this.options = options;
          this.schema = schema;
          if (!Array.isArray(schema)) {
            this._headers = [];
            for (const key in schema) {
              this._headers[schema[key].index] = schema[key].name;
            }
          }
        }
        rowCount() {
          return this.length;
        }
        addArrayRow(row, cursor) {
          if (Number.isFinite(cursor)) {
            this.cursor = cursor;
          }
          switch (this.options.shape) {
            case "object-row-table":
              const rowObject = convertToObjectRow(row, this._headers);
              this.addObjectRow(rowObject, cursor);
              break;
            case "array-row-table":
              this.arrayRows = this.arrayRows || new Array(DEFAULT_ROW_COUNT2);
              this.arrayRows[this.length] = row;
              this.length++;
              break;
          }
        }
        addObjectRow(row, cursor) {
          if (Number.isFinite(cursor)) {
            this.cursor = cursor;
          }
          switch (this.options.shape) {
            case "array-row-table":
              const rowArray = convertToArrayRow(row, this._headers);
              this.addArrayRow(rowArray, cursor);
              break;
            case "object-row-table":
              this.objectRows = this.objectRows || new Array(DEFAULT_ROW_COUNT2);
              this.objectRows[this.length] = row;
              this.length++;
              break;
          }
        }
        getBatch() {
          let rows = this.arrayRows || this.objectRows;
          if (!rows) {
            return null;
          }
          rows = rows.slice(0, this.length);
          this.arrayRows = null;
          this.objectRows = null;
          return {
            shape: this.options.shape,
            batchType: "data",
            data: rows,
            length: this.length,
            schema: this.schema,
            cursor: this.cursor
          };
        }
      };
    }
  });

  // ../schema/src/lib/batches/columnar-table-batch-aggregator.ts
  var DEFAULT_ROW_COUNT3, ColumnarTableBatchAggregator;
  var init_columnar_table_batch_aggregator = __esm({
    "../schema/src/lib/batches/columnar-table-batch-aggregator.ts"() {
      DEFAULT_ROW_COUNT3 = 100;
      ColumnarTableBatchAggregator = class {
        constructor(schema, options) {
          this.length = 0;
          this.allocated = 0;
          this.columns = {};
          this.schema = schema;
          this._reallocateColumns();
        }
        rowCount() {
          return this.length;
        }
        addArrayRow(row) {
          this._reallocateColumns();
          let i = 0;
          for (const fieldName in this.columns) {
            this.columns[fieldName][this.length] = row[i++];
          }
          this.length++;
        }
        addObjectRow(row) {
          this._reallocateColumns();
          for (const fieldName in row) {
            this.columns[fieldName][this.length] = row[fieldName];
          }
          this.length++;
        }
        getBatch() {
          this._pruneColumns();
          const columns = Array.isArray(this.schema) ? this.columns : {};
          if (!Array.isArray(this.schema)) {
            for (const fieldName in this.schema) {
              const field = this.schema[fieldName];
              columns[field.name] = this.columns[field.index];
            }
          }
          this.columns = {};
          const batch = {
            shape: "columnar-table",
            batchType: "data",
            data: columns,
            schema: this.schema,
            length: this.length
          };
          return batch;
        }
        _reallocateColumns() {
          if (this.length < this.allocated) {
            return;
          }
          this.allocated = this.allocated > 0 ? this.allocated *= 2 : DEFAULT_ROW_COUNT3;
          this.columns = {};
          for (const fieldName in this.schema) {
            const field = this.schema[fieldName];
            const ArrayType = field.type || Float32Array;
            const oldColumn = this.columns[field.index];
            if (oldColumn && ArrayBuffer.isView(oldColumn)) {
              const typedArray = new ArrayType(this.allocated);
              typedArray.set(oldColumn);
              this.columns[field.index] = typedArray;
            } else if (oldColumn) {
              oldColumn.length = this.allocated;
              this.columns[field.index] = oldColumn;
            } else {
              this.columns[field.index] = new ArrayType(this.allocated);
            }
          }
        }
        _pruneColumns() {
          for (const [columnName, column] of Object.entries(this.columns)) {
            this.columns[columnName] = column.slice(0, this.length);
          }
        }
      };
    }
  });

  // ../schema/src/lib/batches/table-batch-builder.ts
  var DEFAULT_OPTIONS, ERR_MESSAGE, TableBatchBuilder;
  var init_table_batch_builder = __esm({
    "../schema/src/lib/batches/table-batch-builder.ts"() {
      init_base_table_batch_aggregator();
      init_row_table_batch_aggregator();
      init_columnar_table_batch_aggregator();
      DEFAULT_OPTIONS = {
        shape: "array-row-table",
        batchSize: "auto",
        batchDebounceMs: 0,
        limit: 0,
        _limitMB: 0
      };
      ERR_MESSAGE = "TableBatchBuilder";
      TableBatchBuilder = class {
        constructor(schema, options) {
          this.aggregator = null;
          this.batchCount = 0;
          this.bytesUsed = 0;
          this.isChunkComplete = false;
          this.lastBatchEmittedMs = Date.now();
          this.totalLength = 0;
          this.totalBytes = 0;
          this.rowBytes = 0;
          this.schema = schema;
          this.options = { ...DEFAULT_OPTIONS, ...options };
        }
        limitReached() {
          if (Boolean(this.options?.limit) && this.totalLength >= this.options.limit) {
            return true;
          }
          if (Boolean(this.options?._limitMB) && this.totalBytes / 1e6 >= this.options._limitMB) {
            return true;
          }
          return false;
        }
        addRow(row) {
          if (this.limitReached()) {
            return;
          }
          this.totalLength++;
          this.rowBytes = this.rowBytes || this._estimateRowMB(row);
          this.totalBytes += this.rowBytes;
          if (Array.isArray(row)) {
            this.addArrayRow(row);
          } else {
            this.addObjectRow(row);
          }
        }
        addArrayRow(row) {
          if (!this.aggregator) {
            const TableBatchType = this._getTableBatchType();
            this.aggregator = new TableBatchType(this.schema, this.options);
          }
          this.aggregator.addArrayRow(row);
        }
        addObjectRow(row) {
          if (!this.aggregator) {
            const TableBatchType = this._getTableBatchType();
            this.aggregator = new TableBatchType(this.schema, this.options);
          }
          this.aggregator.addObjectRow(row);
        }
        chunkComplete(chunk) {
          if (chunk instanceof ArrayBuffer) {
            this.bytesUsed += chunk.byteLength;
          }
          if (typeof chunk === "string") {
            this.bytesUsed += chunk.length;
          }
          this.isChunkComplete = true;
        }
        getFullBatch(options) {
          return this._isFull() ? this._getBatch(options) : null;
        }
        getFinalBatch(options) {
          return this._getBatch(options);
        }
        _estimateRowMB(row) {
          return Array.isArray(row) ? row.length * 8 : Object.keys(row).length * 8;
        }
        _isFull() {
          if (!this.aggregator || this.aggregator.rowCount() === 0) {
            return false;
          }
          if (this.options.batchSize === "auto") {
            if (!this.isChunkComplete) {
              return false;
            }
          } else if (this.options.batchSize > this.aggregator.rowCount()) {
            return false;
          }
          if (this.options.batchDebounceMs > Date.now() - this.lastBatchEmittedMs) {
            return false;
          }
          this.isChunkComplete = false;
          this.lastBatchEmittedMs = Date.now();
          return true;
        }
        _getBatch(options) {
          if (!this.aggregator) {
            return null;
          }
          if (options?.bytesUsed) {
            this.bytesUsed = options.bytesUsed;
          }
          const normalizedBatch = this.aggregator.getBatch();
          normalizedBatch.count = this.batchCount;
          normalizedBatch.bytesUsed = this.bytesUsed;
          Object.assign(normalizedBatch, options);
          this.batchCount++;
          this.aggregator = null;
          return normalizedBatch;
        }
        _getTableBatchType() {
          switch (this.options.shape) {
            case "row-table":
              return RowTableBatchAggregator;
            case "array-row-table":
            case "object-row-table":
              return RowTableBatchAggregator2;
            case "columnar-table":
              return ColumnarTableBatchAggregator;
            case "arrow-table":
              if (!TableBatchBuilder.ArrowBatch) {
                throw new Error(ERR_MESSAGE);
              }
              return TableBatchBuilder.ArrowBatch;
            default:
              throw new Error(ERR_MESSAGE);
          }
        }
      };
    }
  });

  // ../schema/src/index.ts
  var init_src = __esm({
    "../schema/src/index.ts"() {
      init_table_batch_builder();
    }
  });

  // ../loader-utils/src/lib/env-utils/assert.ts
  function assert(condition, message) {
    if (!condition) {
      throw new Error(message || "loader assertion failed.");
    }
  }
  var init_assert = __esm({
    "../loader-utils/src/lib/env-utils/assert.ts"() {
    }
  });

  // ../loader-utils/src/lib/iterators/text-iterators.ts
  async function* makeTextDecoderIterator(arrayBufferIterator, options = {}) {
    const textDecoder = new TextDecoder(void 0, options);
    for await (const arrayBuffer of arrayBufferIterator) {
      yield typeof arrayBuffer === "string" ? arrayBuffer : textDecoder.decode(arrayBuffer, { stream: true });
    }
  }
  async function* makeLineIterator(textIterator) {
    let previous = "";
    for await (const textChunk of textIterator) {
      previous += textChunk;
      let eolIndex;
      while ((eolIndex = previous.indexOf("\n")) >= 0) {
        const line = previous.slice(0, eolIndex + 1);
        previous = previous.slice(eolIndex + 1);
        yield line;
      }
    }
    if (previous.length > 0) {
      yield previous;
    }
  }
  async function* makeNumberedLineIterator(lineIterator) {
    let counter = 1;
    for await (const line of lineIterator) {
      yield { counter, line };
      counter++;
    }
  }
  var init_text_iterators = __esm({
    "../loader-utils/src/lib/iterators/text-iterators.ts"() {
    }
  });

  // ../loader-utils/src/index.ts
  var init_src2 = __esm({
    "../loader-utils/src/index.ts"() {
      init_assert();
      init_text_iterators();
    }
  });

  // src/lib/clarinet/clarinet.ts
  function isWhitespace(c) {
    return c === Char.carriageReturn || c === Char.lineFeed || c === Char.space || c === Char.tab;
  }
  function checkBufferLength(parser) {
    const maxAllowed = Math.max(MAX_BUFFER_LENGTH, 10);
    let maxActual = 0;
    for (const buffer of ["textNode", "numberNode"]) {
      const len = parser[buffer] === void 0 ? 0 : parser[buffer].length;
      if (len > maxAllowed) {
        switch (buffer) {
          case "text":
            break;
          default:
            parser._error(`Max buffer length exceeded: ${buffer}`);
        }
      }
      maxActual = Math.max(maxActual, len);
    }
    parser.bufferCheckPosition = MAX_BUFFER_LENGTH - maxActual + parser.position;
  }
  var MAX_BUFFER_LENGTH, STATE, Char, stringTokenPattern, DEFAULT_OPTIONS2, ClarinetParser;
  var init_clarinet = __esm({
    "src/lib/clarinet/clarinet.ts"() {
      MAX_BUFFER_LENGTH = Number.MAX_SAFE_INTEGER;
      (function(STATE2) {
        STATE2[STATE2["BEGIN"] = 0] = "BEGIN";
        STATE2[STATE2["VALUE"] = 1] = "VALUE";
        STATE2[STATE2["OPEN_OBJECT"] = 2] = "OPEN_OBJECT";
        STATE2[STATE2["CLOSE_OBJECT"] = 3] = "CLOSE_OBJECT";
        STATE2[STATE2["OPEN_ARRAY"] = 4] = "OPEN_ARRAY";
        STATE2[STATE2["CLOSE_ARRAY"] = 5] = "CLOSE_ARRAY";
        STATE2[STATE2["TEXT_ESCAPE"] = 6] = "TEXT_ESCAPE";
        STATE2[STATE2["STRING"] = 7] = "STRING";
        STATE2[STATE2["BACKSLASH"] = 8] = "BACKSLASH";
        STATE2[STATE2["END"] = 9] = "END";
        STATE2[STATE2["OPEN_KEY"] = 10] = "OPEN_KEY";
        STATE2[STATE2["CLOSE_KEY"] = 11] = "CLOSE_KEY";
        STATE2[STATE2["TRUE"] = 12] = "TRUE";
        STATE2[STATE2["TRUE2"] = 13] = "TRUE2";
        STATE2[STATE2["TRUE3"] = 14] = "TRUE3";
        STATE2[STATE2["FALSE"] = 15] = "FALSE";
        STATE2[STATE2["FALSE2"] = 16] = "FALSE2";
        STATE2[STATE2["FALSE3"] = 17] = "FALSE3";
        STATE2[STATE2["FALSE4"] = 18] = "FALSE4";
        STATE2[STATE2["NULL"] = 19] = "NULL";
        STATE2[STATE2["NULL2"] = 20] = "NULL2";
        STATE2[STATE2["NULL3"] = 21] = "NULL3";
        STATE2[STATE2["NUMBER_DECIMAL_POINT"] = 22] = "NUMBER_DECIMAL_POINT";
        STATE2[STATE2["NUMBER_DIGIT"] = 23] = "NUMBER_DIGIT";
      })(STATE || (STATE = {}));
      Char = {
        tab: 9,
        lineFeed: 10,
        carriageReturn: 13,
        space: 32,
        doubleQuote: 34,
        plus: 43,
        comma: 44,
        minus: 45,
        period: 46,
        _0: 48,
        _9: 57,
        colon: 58,
        E: 69,
        openBracket: 91,
        backslash: 92,
        closeBracket: 93,
        a: 97,
        b: 98,
        e: 101,
        f: 102,
        l: 108,
        n: 110,
        r: 114,
        s: 115,
        t: 116,
        u: 117,
        openBrace: 123,
        closeBrace: 125
      };
      stringTokenPattern = /[\\"\n]/g;
      DEFAULT_OPTIONS2 = {
        onready: () => {
        },
        onopenobject: () => {
        },
        onkey: () => {
        },
        oncloseobject: () => {
        },
        onopenarray: () => {
        },
        onclosearray: () => {
        },
        onvalue: () => {
        },
        onerror: () => {
        },
        onend: () => {
        },
        onchunkparsed: () => {
        }
      };
      ClarinetParser = class {
        constructor(options = {}) {
          this.options = DEFAULT_OPTIONS2;
          this.bufferCheckPosition = MAX_BUFFER_LENGTH;
          this.q = "";
          this.c = "";
          this.p = "";
          this.closed = false;
          this.closedRoot = false;
          this.sawRoot = false;
          this.error = null;
          this.state = 0;
          this.stack = [];
          this.position = 0;
          this.column = 0;
          this.line = 1;
          this.slashed = false;
          this.unicodeI = 0;
          this.unicodeS = null;
          this.depth = 0;
          this.options = { ...DEFAULT_OPTIONS2, ...options };
          this.textNode = void 0;
          this.numberNode = "";
          this.emit("onready");
        }
        end() {
          if (this.state !== 1 || this.depth !== 0)
            this._error("Unexpected end");
          this._closeValue();
          this.c = "";
          this.closed = true;
          this.emit("onend");
          return this;
        }
        resume() {
          this.error = null;
          return this;
        }
        close() {
          return this.write(null);
        }
        emit(event, data) {
          this.options[event]?.(data, this);
        }
        emitNode(event, data) {
          this._closeValue();
          this.emit(event, data);
        }
        write(chunk) {
          if (this.error) {
            throw this.error;
          }
          if (this.closed) {
            return this._error("Cannot write after close. Assign an onready handler.");
          }
          if (chunk === null) {
            return this.end();
          }
          let i = 0;
          let c = chunk.charCodeAt(0);
          let p = this.p;
          while (c) {
            p = c;
            this.c = c = chunk.charCodeAt(i++);
            if (p !== c) {
              this.p = p;
            } else {
              p = this.p;
            }
            if (!c)
              break;
            this.position++;
            if (c === Char.lineFeed) {
              this.line++;
              this.column = 0;
            } else
              this.column++;
            switch (this.state) {
              case 0:
                if (c === Char.openBrace)
                  this.state = 2;
                else if (c === Char.openBracket)
                  this.state = 4;
                else if (!isWhitespace(c)) {
                  this._error("Non-whitespace before {[.");
                }
                continue;
              case 10:
              case 2:
                if (isWhitespace(c))
                  continue;
                if (this.state === 10)
                  this.stack.push(11);
                else if (c === Char.closeBrace) {
                  this.emit("onopenobject");
                  this.depth++;
                  this.emit("oncloseobject");
                  this.depth--;
                  this.state = this.stack.pop() || 1;
                  continue;
                } else
                  this.stack.push(3);
                if (c === Char.doubleQuote)
                  this.state = 7;
                else
                  this._error('Malformed object key should start with "');
                continue;
              case 11:
              case 3:
                if (isWhitespace(c))
                  continue;
                if (c === Char.colon) {
                  if (this.state === 3) {
                    this.stack.push(3);
                    this._closeValue("onopenobject");
                    this.depth++;
                  } else
                    this._closeValue("onkey");
                  this.state = 1;
                } else if (c === Char.closeBrace) {
                  this.emitNode("oncloseobject");
                  this.depth--;
                  this.state = this.stack.pop() || 1;
                } else if (c === Char.comma) {
                  if (this.state === 3)
                    this.stack.push(3);
                  this._closeValue();
                  this.state = 10;
                } else
                  this._error("Bad object");
                continue;
              case 4:
              case 1:
                if (isWhitespace(c))
                  continue;
                if (this.state === 4) {
                  this.emit("onopenarray");
                  this.depth++;
                  this.state = 1;
                  if (c === Char.closeBracket) {
                    this.emit("onclosearray");
                    this.depth--;
                    this.state = this.stack.pop() || 1;
                    continue;
                  } else {
                    this.stack.push(5);
                  }
                }
                if (c === Char.doubleQuote)
                  this.state = 7;
                else if (c === Char.openBrace)
                  this.state = 2;
                else if (c === Char.openBracket)
                  this.state = 4;
                else if (c === Char.t)
                  this.state = 12;
                else if (c === Char.f)
                  this.state = 15;
                else if (c === Char.n)
                  this.state = 19;
                else if (c === Char.minus) {
                  this.numberNode += "-";
                } else if (Char._0 <= c && c <= Char._9) {
                  this.numberNode += String.fromCharCode(c);
                  this.state = 23;
                } else
                  this._error("Bad value");
                continue;
              case 5:
                if (c === Char.comma) {
                  this.stack.push(5);
                  this._closeValue("onvalue");
                  this.state = 1;
                } else if (c === Char.closeBracket) {
                  this.emitNode("onclosearray");
                  this.depth--;
                  this.state = this.stack.pop() || 1;
                } else if (isWhitespace(c))
                  continue;
                else
                  this._error("Bad array");
                continue;
              case 7:
                if (this.textNode === void 0) {
                  this.textNode = "";
                }
                let starti = i - 1;
                let slashed = this.slashed;
                let unicodeI = this.unicodeI;
                STRING_BIGLOOP:
                  while (true) {
                    while (unicodeI > 0) {
                      this.unicodeS += String.fromCharCode(c);
                      c = chunk.charCodeAt(i++);
                      this.position++;
                      if (unicodeI === 4) {
                        this.textNode += String.fromCharCode(parseInt(this.unicodeS, 16));
                        unicodeI = 0;
                        starti = i - 1;
                      } else {
                        unicodeI++;
                      }
                      if (!c)
                        break STRING_BIGLOOP;
                    }
                    if (c === Char.doubleQuote && !slashed) {
                      this.state = this.stack.pop() || 1;
                      this.textNode += chunk.substring(starti, i - 1);
                      this.position += i - 1 - starti;
                      break;
                    }
                    if (c === Char.backslash && !slashed) {
                      slashed = true;
                      this.textNode += chunk.substring(starti, i - 1);
                      this.position += i - 1 - starti;
                      c = chunk.charCodeAt(i++);
                      this.position++;
                      if (!c)
                        break;
                    }
                    if (slashed) {
                      slashed = false;
                      if (c === Char.n) {
                        this.textNode += "\n";
                      } else if (c === Char.r) {
                        this.textNode += "\r";
                      } else if (c === Char.t) {
                        this.textNode += "	";
                      } else if (c === Char.f) {
                        this.textNode += "\f";
                      } else if (c === Char.b) {
                        this.textNode += "\b";
                      } else if (c === Char.u) {
                        unicodeI = 1;
                        this.unicodeS = "";
                      } else {
                        this.textNode += String.fromCharCode(c);
                      }
                      c = chunk.charCodeAt(i++);
                      this.position++;
                      starti = i - 1;
                      if (!c)
                        break;
                      else
                        continue;
                    }
                    stringTokenPattern.lastIndex = i;
                    const reResult = stringTokenPattern.exec(chunk);
                    if (reResult === null) {
                      i = chunk.length + 1;
                      this.textNode += chunk.substring(starti, i - 1);
                      this.position += i - 1 - starti;
                      break;
                    }
                    i = reResult.index + 1;
                    c = chunk.charCodeAt(reResult.index);
                    if (!c) {
                      this.textNode += chunk.substring(starti, i - 1);
                      this.position += i - 1 - starti;
                      break;
                    }
                  }
                this.slashed = slashed;
                this.unicodeI = unicodeI;
                continue;
              case 12:
                if (c === Char.r)
                  this.state = 13;
                else
                  this._error(`Invalid true started with t${c}`);
                continue;
              case 13:
                if (c === Char.u)
                  this.state = 14;
                else
                  this._error(`Invalid true started with tr${c}`);
                continue;
              case 14:
                if (c === Char.e) {
                  this.emit("onvalue", true);
                  this.state = this.stack.pop() || 1;
                } else
                  this._error(`Invalid true started with tru${c}`);
                continue;
              case 15:
                if (c === Char.a)
                  this.state = 16;
                else
                  this._error(`Invalid false started with f${c}`);
                continue;
              case 16:
                if (c === Char.l)
                  this.state = 17;
                else
                  this._error(`Invalid false started with fa${c}`);
                continue;
              case 17:
                if (c === Char.s)
                  this.state = 18;
                else
                  this._error(`Invalid false started with fal${c}`);
                continue;
              case 18:
                if (c === Char.e) {
                  this.emit("onvalue", false);
                  this.state = this.stack.pop() || 1;
                } else
                  this._error(`Invalid false started with fals${c}`);
                continue;
              case 19:
                if (c === Char.u)
                  this.state = 20;
                else
                  this._error(`Invalid null started with n${c}`);
                continue;
              case 20:
                if (c === Char.l)
                  this.state = 21;
                else
                  this._error(`Invalid null started with nu${c}`);
                continue;
              case 21:
                if (c === Char.l) {
                  this.emit("onvalue", null);
                  this.state = this.stack.pop() || 1;
                } else
                  this._error(`Invalid null started with nul${c}`);
                continue;
              case 22:
                if (c === Char.period) {
                  this.numberNode += ".";
                  this.state = 23;
                } else
                  this._error("Leading zero not followed by .");
                continue;
              case 23:
                if (Char._0 <= c && c <= Char._9)
                  this.numberNode += String.fromCharCode(c);
                else if (c === Char.period) {
                  if (this.numberNode.indexOf(".") !== -1)
                    this._error("Invalid number has two dots");
                  this.numberNode += ".";
                } else if (c === Char.e || c === Char.E) {
                  if (this.numberNode.indexOf("e") !== -1 || this.numberNode.indexOf("E") !== -1)
                    this._error("Invalid number has two exponential");
                  this.numberNode += "e";
                } else if (c === Char.plus || c === Char.minus) {
                  if (!(p === Char.e || p === Char.E))
                    this._error("Invalid symbol in number");
                  this.numberNode += String.fromCharCode(c);
                } else {
                  this._closeNumber();
                  i--;
                  this.state = this.stack.pop() || 1;
                }
                continue;
              default:
                this._error(`Unknown state: ${this.state}`);
            }
          }
          if (this.position >= this.bufferCheckPosition) {
            checkBufferLength(this);
          }
          this.emit("onchunkparsed");
          return this;
        }
        _closeValue(event = "onvalue") {
          if (this.textNode !== void 0) {
            this.emit(event, this.textNode);
          }
          this.textNode = void 0;
        }
        _closeNumber() {
          if (this.numberNode)
            this.emit("onvalue", parseFloat(this.numberNode));
          this.numberNode = "";
        }
        _error(message = "") {
          this._closeValue();
          message += `
Line: ${this.line}
Column: ${this.column}
Char: ${this.c}`;
          const error = new Error(message);
          this.error = error;
          this.emit("onerror", error);
        }
      };
    }
  });

  // src/lib/jsonpath/jsonpath.ts
  var JSONPath;
  var init_jsonpath = __esm({
    "src/lib/jsonpath/jsonpath.ts"() {
      JSONPath = class {
        constructor(path = null) {
          this.path = ["$"];
          if (path instanceof JSONPath) {
            this.path = [...path.path];
            return;
          }
          if (Array.isArray(path)) {
            this.path.push(...path);
            return;
          }
          if (typeof path === "string") {
            this.path = path.split(".");
            if (this.path[0] !== "$") {
              throw new Error("JSONPaths must start with $");
            }
          }
        }
        clone() {
          return new JSONPath(this);
        }
        toString() {
          return this.path.join(".");
        }
        push(name) {
          this.path.push(name);
        }
        pop() {
          return this.path.pop();
        }
        set(name) {
          this.path[this.path.length - 1] = name;
        }
        equals(other) {
          if (!this || !other || this.path.length !== other.path.length) {
            return false;
          }
          for (let i = 0; i < this.path.length; ++i) {
            if (this.path[i] !== other.path[i]) {
              return false;
            }
          }
          return true;
        }
        setFieldAtPath(object, value) {
          const path = [...this.path];
          path.shift();
          const field = path.pop();
          for (const component of path) {
            object = object[component];
          }
          object[field] = value;
        }
        getFieldAtPath(object) {
          const path = [...this.path];
          path.shift();
          const field = path.pop();
          for (const component of path) {
            object = object[component];
          }
          return object[field];
        }
      };
    }
  });

  // src/lib/parser/json-parser.ts
  var JSONParser;
  var init_json_parser = __esm({
    "src/lib/parser/json-parser.ts"() {
      init_clarinet();
      init_jsonpath();
      JSONParser = class {
        constructor(options) {
          this.result = void 0;
          this.previousStates = [];
          this.currentState = Object.freeze({ container: [], key: null });
          this.jsonpath = new JSONPath();
          this.reset();
          this.parser = new ClarinetParser({
            onready: () => {
              this.jsonpath = new JSONPath();
              this.previousStates.length = 0;
              this.currentState.container.length = 0;
            },
            onopenobject: (name) => {
              this._openObject({});
              if (typeof name !== "undefined") {
                this.parser.emit("onkey", name);
              }
            },
            onkey: (name) => {
              this.jsonpath.set(name);
              this.currentState.key = name;
            },
            oncloseobject: () => {
              this._closeObject();
            },
            onopenarray: () => {
              this._openArray();
            },
            onclosearray: () => {
              this._closeArray();
            },
            onvalue: (value) => {
              this._pushOrSet(value);
            },
            onerror: (error) => {
              throw error;
            },
            onend: () => {
              this.result = this.currentState.container.pop();
            },
            ...options
          });
        }
        reset() {
          this.result = void 0;
          this.previousStates = [];
          this.currentState = Object.freeze({ container: [], key: null });
          this.jsonpath = new JSONPath();
        }
        write(chunk) {
          this.parser.write(chunk);
        }
        close() {
          this.parser.close();
        }
        _pushOrSet(value) {
          const { container, key } = this.currentState;
          if (key !== null) {
            container[key] = value;
            this.currentState.key = null;
          } else {
            container.push(value);
          }
        }
        _openArray(newContainer = []) {
          this.jsonpath.push(null);
          this._pushOrSet(newContainer);
          this.previousStates.push(this.currentState);
          this.currentState = { container: newContainer, isArray: true, key: null };
        }
        _closeArray() {
          this.jsonpath.pop();
          this.currentState = this.previousStates.pop();
        }
        _openObject(newContainer = {}) {
          this.jsonpath.push(null);
          this._pushOrSet(newContainer);
          this.previousStates.push(this.currentState);
          this.currentState = { container: newContainer, isArray: false, key: null };
        }
        _closeObject() {
          this.jsonpath.pop();
          this.currentState = this.previousStates.pop();
        }
      };
    }
  });

  // src/lib/parser/streaming-json-parser.ts
  var StreamingJSONParser;
  var init_streaming_json_parser = __esm({
    "src/lib/parser/streaming-json-parser.ts"() {
      init_json_parser();
      init_jsonpath();
      StreamingJSONParser = class extends JSONParser {
        constructor(options = {}) {
          super({
            onopenarray: () => {
              if (!this.streamingArray) {
                if (this._matchJSONPath()) {
                  this.streamingJsonPath = this.getJsonPath().clone();
                  this.streamingArray = [];
                  this._openArray(this.streamingArray);
                  return;
                }
              }
              this._openArray();
            },
            onopenobject: (name) => {
              if (!this.topLevelObject) {
                this.topLevelObject = {};
                this._openObject(this.topLevelObject);
              } else {
                this._openObject({});
              }
              if (typeof name !== "undefined") {
                this.parser.emit("onkey", name);
              }
            }
          });
          this.streamingJsonPath = null;
          this.streamingArray = null;
          this.topLevelObject = null;
          const jsonpaths = options.jsonpaths || [];
          this.jsonPaths = jsonpaths.map((jsonpath) => new JSONPath(jsonpath));
        }
        write(chunk) {
          super.write(chunk);
          let array = [];
          if (this.streamingArray) {
            array = [...this.streamingArray];
            this.streamingArray.length = 0;
          }
          return array;
        }
        getPartialResult() {
          return this.topLevelObject;
        }
        getStreamingJsonPath() {
          return this.streamingJsonPath;
        }
        getStreamingJsonPathAsString() {
          return this.streamingJsonPath && this.streamingJsonPath.toString();
        }
        getJsonPath() {
          return this.jsonpath;
        }
        _matchJSONPath() {
          const currentPath = this.getJsonPath();
          if (this.jsonPaths.length === 0) {
            return true;
          }
          for (const jsonPath of this.jsonPaths) {
            if (jsonPath.equals(currentPath)) {
              return true;
            }
          }
          return false;
        }
      };
    }
  });

  // src/lib/parse-json-in-batches.ts
  async function* parseJSONInBatches(binaryAsyncIterator, options) {
    const asyncIterator = makeTextDecoderIterator(binaryAsyncIterator);
    const { metadata } = options;
    const { jsonpaths } = options.json || {};
    let isFirstChunk = true;
    const schema = null;
    const shape = options?.json?.shape || "row-table";
    const tableBatchBuilder = new TableBatchBuilder(schema, {
      ...options,
      shape
    });
    const parser = new StreamingJSONParser({ jsonpaths });
    for await (const chunk of asyncIterator) {
      const rows = parser.write(chunk);
      const jsonpath2 = rows.length > 0 && parser.getStreamingJsonPathAsString();
      if (rows.length > 0 && isFirstChunk) {
        if (metadata) {
          const initialBatch = {
            shape,
            batchType: "partial-result",
            data: [],
            length: 0,
            bytesUsed: 0,
            container: parser.getPartialResult(),
            jsonpath: jsonpath2
          };
          yield initialBatch;
        }
        isFirstChunk = false;
      }
      for (const row of rows) {
        tableBatchBuilder.addRow(row);
        const batch3 = tableBatchBuilder.getFullBatch({ jsonpath: jsonpath2 });
        if (batch3) {
          yield batch3;
        }
      }
      tableBatchBuilder.chunkComplete(chunk);
      const batch2 = tableBatchBuilder.getFullBatch({ jsonpath: jsonpath2 });
      if (batch2) {
        yield batch2;
      }
    }
    const jsonpath = parser.getStreamingJsonPathAsString();
    const batch = tableBatchBuilder.getFinalBatch({ jsonpath });
    if (batch) {
      yield batch;
    }
    if (metadata) {
      const finalBatch = {
        shape,
        batchType: "final-result",
        container: parser.getPartialResult(),
        jsonpath: parser.getStreamingJsonPathAsString(),
        data: [],
        length: 0
      };
      yield finalBatch;
    }
  }
  function rebuildJsonObject(batch, data) {
    assert(batch.batchType === "final-result");
    if (batch.jsonpath === "$") {
      return data;
    }
    if (batch.jsonpath && batch.jsonpath.length > 1) {
      const topLevelObject = batch.container;
      const streamingPath = new JSONPath(batch.jsonpath);
      streamingPath.setFieldAtPath(topLevelObject, data);
      return topLevelObject;
    }
    return batch.container;
  }
  var init_parse_json_in_batches = __esm({
    "src/lib/parse-json-in-batches.ts"() {
      init_src();
      init_src2();
      init_streaming_json_parser();
      init_jsonpath();
    }
  });

  // src/json-loader.ts
  async function parse(arrayBuffer, options) {
    return parseTextSync(new TextDecoder().decode(arrayBuffer), options);
  }
  function parseTextSync(text, options) {
    const jsonOptions = { ...options, json: { ...DEFAULT_JSON_LOADER_OPTIONS.json, ...options?.json } };
    return parseJSONSync(text, jsonOptions);
  }
  function parseInBatches(asyncIterator, options) {
    const jsonOptions = { ...options, json: { ...DEFAULT_JSON_LOADER_OPTIONS.json, ...options?.json } };
    return parseJSONInBatches(asyncIterator, jsonOptions);
  }
  var VERSION, DEFAULT_JSON_LOADER_OPTIONS, JSONLoader;
  var init_json_loader = __esm({
    "src/json-loader.ts"() {
      init_parse_json();
      init_parse_json_in_batches();
      VERSION = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
      DEFAULT_JSON_LOADER_OPTIONS = {
        json: {
          shape: "row-table",
          table: false,
          jsonpaths: []
        }
      };
      JSONLoader = {
        name: "JSON",
        id: "json",
        module: "json",
        version: VERSION,
        extensions: ["json", "geojson"],
        mimeTypes: ["application/json"],
        category: "table",
        text: true,
        parse,
        parseTextSync,
        parseInBatches,
        options: DEFAULT_JSON_LOADER_OPTIONS
      };
    }
  });

  // src/lib/parse-ndjson.ts
  function parseNDJSONSync(ndjsonText) {
    const lines = ndjsonText.trim().split("\n");
    return lines.map((line, counter) => {
      try {
        return JSON.parse(line);
      } catch (error) {
        throw new Error(`NDJSONLoader: failed to parse JSON on line ${counter + 1}`);
      }
    });
  }
  var init_parse_ndjson = __esm({
    "src/lib/parse-ndjson.ts"() {
    }
  });

  // src/lib/parse-ndjson-in-batches.ts
  async function* parseNDJSONInBatches(binaryAsyncIterator, options) {
    const textIterator = makeTextDecoderIterator(binaryAsyncIterator);
    const lineIterator = makeLineIterator(textIterator);
    const numberedLineIterator = makeNumberedLineIterator(lineIterator);
    const schema = null;
    const shape = "row-table";
    const tableBatchBuilder = new TableBatchBuilder(schema, {
      ...options,
      shape
    });
    for await (const { counter, line } of numberedLineIterator) {
      try {
        const row = JSON.parse(line);
        tableBatchBuilder.addRow(row);
        tableBatchBuilder.chunkComplete(line);
        const batch2 = tableBatchBuilder.getFullBatch();
        if (batch2) {
          yield batch2;
        }
      } catch (error) {
        throw new Error(`NDJSONLoader: failed to parse JSON on line ${counter}`);
      }
    }
    const batch = tableBatchBuilder.getFinalBatch();
    if (batch) {
      yield batch;
    }
  }
  var init_parse_ndjson_in_batches = __esm({
    "src/lib/parse-ndjson-in-batches.ts"() {
      init_src();
      init_src2();
    }
  });

  // src/ndjson-loader.ts
  async function parse2(arrayBuffer) {
    return parseTextSync2(new TextDecoder().decode(arrayBuffer));
  }
  function parseTextSync2(text) {
    return parseNDJSONSync(text);
  }
  function parseInBatches2(asyncIterator, options) {
    return parseNDJSONInBatches(asyncIterator, options);
  }
  var VERSION2, NDJSONLoader;
  var init_ndjson_loader = __esm({
    "src/ndjson-loader.ts"() {
      init_parse_ndjson();
      init_parse_ndjson_in_batches();
      VERSION2 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
      NDJSONLoader = {
        name: "NDJSON",
        id: "ndjson",
        module: "json",
        version: VERSION2,
        extensions: ["ndjson"],
        mimeTypes: ["application/x-ndjson"],
        category: "table",
        text: true,
        parse: parse2,
        parseTextSync: parseTextSync2,
        parseInBatches: parseInBatches2,
        options: {}
      };
    }
  });

  // ../../node_modules/@math.gl/polygon/dist/esm/polygon-utils.js
  function getPolygonSignedArea(points, options = {}) {
    const {
      start = 0,
      end = points.length
    } = options;
    const dim = options.size || 2;
    let area2 = 0;
    for (let i = start, j = end - dim; i < end; i += dim) {
      area2 += (points[i] - points[j]) * (points[i + 1] + points[j + 1]);
      j = i;
    }
    return area2 / 2;
  }
  var init_polygon_utils = __esm({
    "../../node_modules/@math.gl/polygon/dist/esm/polygon-utils.js"() {
    }
  });

  // ../../node_modules/@math.gl/polygon/dist/esm/polygon.js
  var init_polygon = __esm({
    "../../node_modules/@math.gl/polygon/dist/esm/polygon.js"() {
      init_polygon_utils();
    }
  });

  // ../../node_modules/@math.gl/polygon/dist/esm/earcut.js
  function earcut(data, holeIndices, dim, areas) {
    dim = dim || 2;
    const hasHoles = holeIndices && holeIndices.length;
    const outerLen = hasHoles ? holeIndices[0] * dim : data.length;
    let outerNode = linkedList(data, 0, outerLen, dim, true, areas && areas[0]);
    const triangles = [];
    if (!outerNode || outerNode.next === outerNode.prev)
      return triangles;
    let invSize;
    let maxX;
    let maxY;
    let minX;
    let minY;
    let x;
    let y;
    if (hasHoles)
      outerNode = eliminateHoles(data, holeIndices, outerNode, dim, areas);
    if (data.length > 80 * dim) {
      minX = maxX = data[0];
      minY = maxY = data[1];
      for (let i = dim; i < outerLen; i += dim) {
        x = data[i];
        y = data[i + 1];
        if (x < minX)
          minX = x;
        if (y < minY)
          minY = y;
        if (x > maxX)
          maxX = x;
        if (y > maxY)
          maxY = y;
      }
      invSize = Math.max(maxX - minX, maxY - minY);
      invSize = invSize !== 0 ? 1 / invSize : 0;
    }
    earcutLinked(outerNode, triangles, dim, minX, minY, invSize);
    return triangles;
  }
  function linkedList(data, start, end, dim, clockwise, area2) {
    let i;
    let last;
    if (area2 === void 0) {
      area2 = getPolygonSignedArea(data, {
        start,
        end,
        size: dim
      });
    }
    if (clockwise === area2 < 0) {
      for (i = start; i < end; i += dim)
        last = insertNode(i, data[i], data[i + 1], last);
    } else {
      for (i = end - dim; i >= start; i -= dim)
        last = insertNode(i, data[i], data[i + 1], last);
    }
    if (last && equals(last, last.next)) {
      removeNode(last);
      last = last.next;
    }
    return last;
  }
  function filterPoints(start, end) {
    if (!start)
      return start;
    if (!end)
      end = start;
    let p = start;
    let again;
    do {
      again = false;
      if (!p.steiner && (equals(p, p.next) || area(p.prev, p, p.next) === 0)) {
        removeNode(p);
        p = end = p.prev;
        if (p === p.next)
          break;
        again = true;
      } else {
        p = p.next;
      }
    } while (again || p !== end);
    return end;
  }
  function earcutLinked(ear, triangles, dim, minX, minY, invSize, pass) {
    if (!ear)
      return;
    if (!pass && invSize)
      indexCurve(ear, minX, minY, invSize);
    let stop = ear;
    let prev;
    let next;
    while (ear.prev !== ear.next) {
      prev = ear.prev;
      next = ear.next;
      if (invSize ? isEarHashed(ear, minX, minY, invSize) : isEar(ear)) {
        triangles.push(prev.i / dim);
        triangles.push(ear.i / dim);
        triangles.push(next.i / dim);
        removeNode(ear);
        ear = next.next;
        stop = next.next;
        continue;
      }
      ear = next;
      if (ear === stop) {
        if (!pass) {
          earcutLinked(filterPoints(ear), triangles, dim, minX, minY, invSize, 1);
        } else if (pass === 1) {
          ear = cureLocalIntersections(filterPoints(ear), triangles, dim);
          earcutLinked(ear, triangles, dim, minX, minY, invSize, 2);
        } else if (pass === 2) {
          splitEarcut(ear, triangles, dim, minX, minY, invSize);
        }
        break;
      }
    }
  }
  function isEar(ear) {
    const a = ear.prev;
    const b = ear;
    const c = ear.next;
    if (area(a, b, c) >= 0)
      return false;
    let p = ear.next.next;
    while (p !== ear.prev) {
      if (pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, p.x, p.y) && area(p.prev, p, p.next) >= 0)
        return false;
      p = p.next;
    }
    return true;
  }
  function isEarHashed(ear, minX, minY, invSize) {
    const a = ear.prev;
    const b = ear;
    const c = ear.next;
    if (area(a, b, c) >= 0)
      return false;
    const minTX = a.x < b.x ? a.x < c.x ? a.x : c.x : b.x < c.x ? b.x : c.x;
    const minTY = a.y < b.y ? a.y < c.y ? a.y : c.y : b.y < c.y ? b.y : c.y;
    const maxTX = a.x > b.x ? a.x > c.x ? a.x : c.x : b.x > c.x ? b.x : c.x;
    const maxTY = a.y > b.y ? a.y > c.y ? a.y : c.y : b.y > c.y ? b.y : c.y;
    const minZ = zOrder(minTX, minTY, minX, minY, invSize);
    const maxZ = zOrder(maxTX, maxTY, minX, minY, invSize);
    let p = ear.prevZ;
    let n = ear.nextZ;
    while (p && p.z >= minZ && n && n.z <= maxZ) {
      if (p !== ear.prev && p !== ear.next && pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, p.x, p.y) && area(p.prev, p, p.next) >= 0)
        return false;
      p = p.prevZ;
      if (n !== ear.prev && n !== ear.next && pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, n.x, n.y) && area(n.prev, n, n.next) >= 0)
        return false;
      n = n.nextZ;
    }
    while (p && p.z >= minZ) {
      if (p !== ear.prev && p !== ear.next && pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, p.x, p.y) && area(p.prev, p, p.next) >= 0)
        return false;
      p = p.prevZ;
    }
    while (n && n.z <= maxZ) {
      if (n !== ear.prev && n !== ear.next && pointInTriangle(a.x, a.y, b.x, b.y, c.x, c.y, n.x, n.y) && area(n.prev, n, n.next) >= 0)
        return false;
      n = n.nextZ;
    }
    return true;
  }
  function cureLocalIntersections(start, triangles, dim) {
    let p = start;
    do {
      const a = p.prev;
      const b = p.next.next;
      if (!equals(a, b) && intersects(a, p, p.next, b) && locallyInside(a, b) && locallyInside(b, a)) {
        triangles.push(a.i / dim);
        triangles.push(p.i / dim);
        triangles.push(b.i / dim);
        removeNode(p);
        removeNode(p.next);
        p = start = b;
      }
      p = p.next;
    } while (p !== start);
    return filterPoints(p);
  }
  function splitEarcut(start, triangles, dim, minX, minY, invSize) {
    let a = start;
    do {
      let b = a.next.next;
      while (b !== a.prev) {
        if (a.i !== b.i && isValidDiagonal(a, b)) {
          let c = splitPolygon(a, b);
          a = filterPoints(a, a.next);
          c = filterPoints(c, c.next);
          earcutLinked(a, triangles, dim, minX, minY, invSize);
          earcutLinked(c, triangles, dim, minX, minY, invSize);
          return;
        }
        b = b.next;
      }
      a = a.next;
    } while (a !== start);
  }
  function eliminateHoles(data, holeIndices, outerNode, dim, areas) {
    const queue = [];
    let i;
    let len;
    let start;
    let end;
    let list;
    for (i = 0, len = holeIndices.length; i < len; i++) {
      start = holeIndices[i] * dim;
      end = i < len - 1 ? holeIndices[i + 1] * dim : data.length;
      list = linkedList(data, start, end, dim, false, areas && areas[i + 1]);
      if (list === list.next)
        list.steiner = true;
      queue.push(getLeftmost(list));
    }
    queue.sort(compareX);
    for (i = 0; i < queue.length; i++) {
      eliminateHole(queue[i], outerNode);
      outerNode = filterPoints(outerNode, outerNode.next);
    }
    return outerNode;
  }
  function compareX(a, b) {
    return a.x - b.x;
  }
  function eliminateHole(hole, outerNode) {
    outerNode = findHoleBridge(hole, outerNode);
    if (outerNode) {
      const b = splitPolygon(outerNode, hole);
      filterPoints(outerNode, outerNode.next);
      filterPoints(b, b.next);
    }
  }
  function findHoleBridge(hole, outerNode) {
    let p = outerNode;
    const hx = hole.x;
    const hy = hole.y;
    let qx = -Infinity;
    let m;
    do {
      if (hy <= p.y && hy >= p.next.y && p.next.y !== p.y) {
        const x = p.x + (hy - p.y) * (p.next.x - p.x) / (p.next.y - p.y);
        if (x <= hx && x > qx) {
          qx = x;
          if (x === hx) {
            if (hy === p.y)
              return p;
            if (hy === p.next.y)
              return p.next;
          }
          m = p.x < p.next.x ? p : p.next;
        }
      }
      p = p.next;
    } while (p !== outerNode);
    if (!m)
      return null;
    if (hx === qx)
      return m;
    const stop = m;
    const mx = m.x;
    const my = m.y;
    let tanMin = Infinity;
    let tan;
    p = m;
    do {
      if (hx >= p.x && p.x >= mx && hx !== p.x && pointInTriangle(hy < my ? hx : qx, hy, mx, my, hy < my ? qx : hx, hy, p.x, p.y)) {
        tan = Math.abs(hy - p.y) / (hx - p.x);
        if (locallyInside(p, hole) && (tan < tanMin || tan === tanMin && (p.x > m.x || p.x === m.x && sectorContainsSector(m, p)))) {
          m = p;
          tanMin = tan;
        }
      }
      p = p.next;
    } while (p !== stop);
    return m;
  }
  function sectorContainsSector(m, p) {
    return area(m.prev, m, p.prev) < 0 && area(p.next, m, m.next) < 0;
  }
  function indexCurve(start, minX, minY, invSize) {
    let p = start;
    do {
      if (p.z === null)
        p.z = zOrder(p.x, p.y, minX, minY, invSize);
      p.prevZ = p.prev;
      p.nextZ = p.next;
      p = p.next;
    } while (p !== start);
    p.prevZ.nextZ = null;
    p.prevZ = null;
    sortLinked(p);
  }
  function sortLinked(list) {
    let e;
    let i;
    let inSize = 1;
    let numMerges;
    let p;
    let pSize;
    let q;
    let qSize;
    let tail;
    do {
      p = list;
      list = null;
      tail = null;
      numMerges = 0;
      while (p) {
        numMerges++;
        q = p;
        pSize = 0;
        for (i = 0; i < inSize; i++) {
          pSize++;
          q = q.nextZ;
          if (!q)
            break;
        }
        qSize = inSize;
        while (pSize > 0 || qSize > 0 && q) {
          if (pSize !== 0 && (qSize === 0 || !q || p.z <= q.z)) {
            e = p;
            p = p.nextZ;
            pSize--;
          } else {
            e = q;
            q = q.nextZ;
            qSize--;
          }
          if (tail)
            tail.nextZ = e;
          else
            list = e;
          e.prevZ = tail;
          tail = e;
        }
        p = q;
      }
      tail.nextZ = null;
      inSize *= 2;
    } while (numMerges > 1);
    return list;
  }
  function zOrder(x, y, minX, minY, invSize) {
    x = 32767 * (x - minX) * invSize;
    y = 32767 * (y - minY) * invSize;
    x = (x | x << 8) & 16711935;
    x = (x | x << 4) & 252645135;
    x = (x | x << 2) & 858993459;
    x = (x | x << 1) & 1431655765;
    y = (y | y << 8) & 16711935;
    y = (y | y << 4) & 252645135;
    y = (y | y << 2) & 858993459;
    y = (y | y << 1) & 1431655765;
    return x | y << 1;
  }
  function getLeftmost(start) {
    let p = start;
    let leftmost = start;
    do {
      if (p.x < leftmost.x || p.x === leftmost.x && p.y < leftmost.y)
        leftmost = p;
      p = p.next;
    } while (p !== start);
    return leftmost;
  }
  function pointInTriangle(ax, ay, bx, by, cx, cy, px, py) {
    return (cx - px) * (ay - py) - (ax - px) * (cy - py) >= 0 && (ax - px) * (by - py) - (bx - px) * (ay - py) >= 0 && (bx - px) * (cy - py) - (cx - px) * (by - py) >= 0;
  }
  function isValidDiagonal(a, b) {
    return a.next.i !== b.i && a.prev.i !== b.i && !intersectsPolygon(a, b) && (locallyInside(a, b) && locallyInside(b, a) && middleInside(a, b) && (area(a.prev, a, b.prev) || area(a, b.prev, b)) || equals(a, b) && area(a.prev, a, a.next) > 0 && area(b.prev, b, b.next) > 0);
  }
  function area(p, q, r) {
    return (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y);
  }
  function equals(p1, p2) {
    return p1.x === p2.x && p1.y === p2.y;
  }
  function intersects(p1, q1, p2, q2) {
    const o1 = sign(area(p1, q1, p2));
    const o2 = sign(area(p1, q1, q2));
    const o3 = sign(area(p2, q2, p1));
    const o4 = sign(area(p2, q2, q1));
    if (o1 !== o2 && o3 !== o4)
      return true;
    if (o1 === 0 && onSegment(p1, p2, q1))
      return true;
    if (o2 === 0 && onSegment(p1, q2, q1))
      return true;
    if (o3 === 0 && onSegment(p2, p1, q2))
      return true;
    if (o4 === 0 && onSegment(p2, q1, q2))
      return true;
    return false;
  }
  function onSegment(p, q, r) {
    return q.x <= Math.max(p.x, r.x) && q.x >= Math.min(p.x, r.x) && q.y <= Math.max(p.y, r.y) && q.y >= Math.min(p.y, r.y);
  }
  function sign(num) {
    return num > 0 ? 1 : num < 0 ? -1 : 0;
  }
  function intersectsPolygon(a, b) {
    let p = a;
    do {
      if (p.i !== a.i && p.next.i !== a.i && p.i !== b.i && p.next.i !== b.i && intersects(p, p.next, a, b))
        return true;
      p = p.next;
    } while (p !== a);
    return false;
  }
  function locallyInside(a, b) {
    return area(a.prev, a, a.next) < 0 ? area(a, b, a.next) >= 0 && area(a, a.prev, b) >= 0 : area(a, b, a.prev) < 0 || area(a, a.next, b) < 0;
  }
  function middleInside(a, b) {
    let p = a;
    let inside = false;
    const px = (a.x + b.x) / 2;
    const py = (a.y + b.y) / 2;
    do {
      if (p.y > py !== p.next.y > py && p.next.y !== p.y && px < (p.next.x - p.x) * (py - p.y) / (p.next.y - p.y) + p.x)
        inside = !inside;
      p = p.next;
    } while (p !== a);
    return inside;
  }
  function splitPolygon(a, b) {
    const a2 = new Node(a.i, a.x, a.y);
    const b2 = new Node(b.i, b.x, b.y);
    const an = a.next;
    const bp = b.prev;
    a.next = b;
    b.prev = a;
    a2.next = an;
    an.prev = a2;
    b2.next = a2;
    a2.prev = b2;
    bp.next = b2;
    b2.prev = bp;
    return b2;
  }
  function insertNode(i, x, y, last) {
    const p = new Node(i, x, y);
    if (!last) {
      p.prev = p;
      p.next = p;
    } else {
      p.next = last.next;
      p.prev = last;
      last.next.prev = p;
      last.next = p;
    }
    return p;
  }
  function removeNode(p) {
    p.next.prev = p.prev;
    p.prev.next = p.next;
    if (p.prevZ)
      p.prevZ.nextZ = p.nextZ;
    if (p.nextZ)
      p.nextZ.prevZ = p.prevZ;
  }
  function Node(i, x, y) {
    this.i = i;
    this.x = x;
    this.y = y;
    this.prev = null;
    this.next = null;
    this.z = null;
    this.prevZ = null;
    this.nextZ = null;
    this.steiner = false;
  }
  var init_earcut = __esm({
    "../../node_modules/@math.gl/polygon/dist/esm/earcut.js"() {
      init_polygon_utils();
    }
  });

  // ../../node_modules/@math.gl/polygon/dist/esm/utils.js
  var init_utils = __esm({
    "../../node_modules/@math.gl/polygon/dist/esm/utils.js"() {
    }
  });

  // ../../node_modules/@math.gl/polygon/dist/esm/lineclip.js
  var init_lineclip = __esm({
    "../../node_modules/@math.gl/polygon/dist/esm/lineclip.js"() {
      init_utils();
    }
  });

  // ../../node_modules/@math.gl/polygon/dist/esm/cut-by-grid.js
  var init_cut_by_grid = __esm({
    "../../node_modules/@math.gl/polygon/dist/esm/cut-by-grid.js"() {
      init_lineclip();
      init_utils();
    }
  });

  // ../../node_modules/@math.gl/polygon/dist/esm/cut-by-mercator-bounds.js
  var init_cut_by_mercator_bounds = __esm({
    "../../node_modules/@math.gl/polygon/dist/esm/cut-by-mercator-bounds.js"() {
      init_cut_by_grid();
      init_utils();
    }
  });

  // ../../node_modules/@math.gl/polygon/dist/esm/index.js
  var init_esm = __esm({
    "../../node_modules/@math.gl/polygon/dist/esm/index.js"() {
      init_polygon();
      init_polygon_utils();
      init_earcut();
      init_lineclip();
      init_cut_by_grid();
      init_cut_by_mercator_bounds();
      init_polygon();
    }
  });

  // ../gis/src/lib/flat-geojson-to-binary.ts
  function flatGeojsonToBinary(features, geometryInfo, options) {
    const propArrayTypes = extractNumericPropTypes(features);
    const numericPropKeys = Object.keys(propArrayTypes).filter((k) => propArrayTypes[k] !== Array);
    return fillArrays(features, {
      propArrayTypes,
      ...geometryInfo
    }, {
      numericPropKeys: options && options.numericPropKeys || numericPropKeys,
      PositionDataType: options ? options.PositionDataType : Float32Array
    });
  }
  function extractNumericPropTypes(features) {
    const propArrayTypes = {};
    for (const feature of features) {
      if (feature.properties) {
        for (const key in feature.properties) {
          const val = feature.properties[key];
          propArrayTypes[key] = deduceArrayType(val, propArrayTypes[key]);
        }
      }
    }
    return propArrayTypes;
  }
  function fillArrays(features, geometryInfo, options) {
    const {
      pointPositionsCount,
      pointFeaturesCount,
      linePositionsCount,
      linePathsCount,
      lineFeaturesCount,
      polygonPositionsCount,
      polygonObjectsCount,
      polygonRingsCount,
      polygonFeaturesCount,
      propArrayTypes,
      coordLength
    } = geometryInfo;
    const { numericPropKeys = [], PositionDataType = Float32Array } = options;
    const hasGlobalId = features[0] && "id" in features[0];
    const GlobalFeatureIdsDataType = features.length > 65535 ? Uint32Array : Uint16Array;
    const points = {
      type: "Point",
      positions: new PositionDataType(pointPositionsCount * coordLength),
      globalFeatureIds: new GlobalFeatureIdsDataType(pointPositionsCount),
      featureIds: pointFeaturesCount > 65535 ? new Uint32Array(pointPositionsCount) : new Uint16Array(pointPositionsCount),
      numericProps: {},
      properties: [],
      fields: []
    };
    const lines = {
      type: "LineString",
      pathIndices: linePositionsCount > 65535 ? new Uint32Array(linePathsCount + 1) : new Uint16Array(linePathsCount + 1),
      positions: new PositionDataType(linePositionsCount * coordLength),
      globalFeatureIds: new GlobalFeatureIdsDataType(linePositionsCount),
      featureIds: lineFeaturesCount > 65535 ? new Uint32Array(linePositionsCount) : new Uint16Array(linePositionsCount),
      numericProps: {},
      properties: [],
      fields: []
    };
    const polygons = {
      type: "Polygon",
      polygonIndices: polygonPositionsCount > 65535 ? new Uint32Array(polygonObjectsCount + 1) : new Uint16Array(polygonObjectsCount + 1),
      primitivePolygonIndices: polygonPositionsCount > 65535 ? new Uint32Array(polygonRingsCount + 1) : new Uint16Array(polygonRingsCount + 1),
      positions: new PositionDataType(polygonPositionsCount * coordLength),
      triangles: [],
      globalFeatureIds: new GlobalFeatureIdsDataType(polygonPositionsCount),
      featureIds: polygonFeaturesCount > 65535 ? new Uint32Array(polygonPositionsCount) : new Uint16Array(polygonPositionsCount),
      numericProps: {},
      properties: [],
      fields: []
    };
    for (const object of [points, lines, polygons]) {
      for (const propName of numericPropKeys) {
        const T = propArrayTypes[propName];
        object.numericProps[propName] = new T(object.positions.length / coordLength);
      }
    }
    lines.pathIndices[linePathsCount] = linePositionsCount;
    polygons.polygonIndices[polygonObjectsCount] = polygonPositionsCount;
    polygons.primitivePolygonIndices[polygonRingsCount] = polygonPositionsCount;
    const indexMap = {
      pointPosition: 0,
      pointFeature: 0,
      linePosition: 0,
      linePath: 0,
      lineFeature: 0,
      polygonPosition: 0,
      polygonObject: 0,
      polygonRing: 0,
      polygonFeature: 0,
      feature: 0
    };
    for (const feature of features) {
      const geometry = feature.geometry;
      const properties = feature.properties || {};
      switch (geometry.type) {
        case "Point":
          handlePoint(geometry, points, indexMap, coordLength, properties);
          points.properties.push(keepStringProperties(properties, numericPropKeys));
          if (hasGlobalId) {
            points.fields.push({ id: feature.id });
          }
          indexMap.pointFeature++;
          break;
        case "LineString":
          handleLineString(geometry, lines, indexMap, coordLength, properties);
          lines.properties.push(keepStringProperties(properties, numericPropKeys));
          if (hasGlobalId) {
            lines.fields.push({ id: feature.id });
          }
          indexMap.lineFeature++;
          break;
        case "Polygon":
          handlePolygon(geometry, polygons, indexMap, coordLength, properties);
          polygons.properties.push(keepStringProperties(properties, numericPropKeys));
          if (hasGlobalId) {
            polygons.fields.push({ id: feature.id });
          }
          indexMap.polygonFeature++;
          break;
        default:
          throw new Error("Invalid geometry type");
      }
      indexMap.feature++;
    }
    return makeAccessorObjects(points, lines, polygons, coordLength);
  }
  function handlePoint(geometry, points, indexMap, coordLength, properties) {
    points.positions.set(geometry.data, indexMap.pointPosition * coordLength);
    const nPositions = geometry.data.length / coordLength;
    fillNumericProperties(points, properties, indexMap.pointPosition, nPositions);
    points.globalFeatureIds.fill(indexMap.feature, indexMap.pointPosition, indexMap.pointPosition + nPositions);
    points.featureIds.fill(indexMap.pointFeature, indexMap.pointPosition, indexMap.pointPosition + nPositions);
    indexMap.pointPosition += nPositions;
  }
  function handleLineString(geometry, lines, indexMap, coordLength, properties) {
    lines.positions.set(geometry.data, indexMap.linePosition * coordLength);
    const nPositions = geometry.data.length / coordLength;
    fillNumericProperties(lines, properties, indexMap.linePosition, nPositions);
    lines.globalFeatureIds.fill(indexMap.feature, indexMap.linePosition, indexMap.linePosition + nPositions);
    lines.featureIds.fill(indexMap.lineFeature, indexMap.linePosition, indexMap.linePosition + nPositions);
    for (let i = 0, il = geometry.indices.length; i < il; ++i) {
      const start = geometry.indices[i];
      const end = i === il - 1 ? geometry.data.length : geometry.indices[i + 1];
      lines.pathIndices[indexMap.linePath++] = indexMap.linePosition;
      indexMap.linePosition += (end - start) / coordLength;
    }
  }
  function handlePolygon(geometry, polygons, indexMap, coordLength, properties) {
    polygons.positions.set(geometry.data, indexMap.polygonPosition * coordLength);
    const nPositions = geometry.data.length / coordLength;
    fillNumericProperties(polygons, properties, indexMap.polygonPosition, nPositions);
    polygons.globalFeatureIds.fill(indexMap.feature, indexMap.polygonPosition, indexMap.polygonPosition + nPositions);
    polygons.featureIds.fill(indexMap.polygonFeature, indexMap.polygonPosition, indexMap.polygonPosition + nPositions);
    for (let l = 0, ll = geometry.indices.length; l < ll; ++l) {
      const startPosition = indexMap.polygonPosition;
      polygons.polygonIndices[indexMap.polygonObject++] = startPosition;
      const areas = geometry.areas[l];
      const indices = geometry.indices[l];
      const nextIndices = geometry.indices[l + 1];
      for (let i = 0, il = indices.length; i < il; ++i) {
        const start = indices[i];
        const end = i === il - 1 ? nextIndices === void 0 ? geometry.data.length : nextIndices[0] : indices[i + 1];
        polygons.primitivePolygonIndices[indexMap.polygonRing++] = indexMap.polygonPosition;
        indexMap.polygonPosition += (end - start) / coordLength;
      }
      const endPosition = indexMap.polygonPosition;
      triangulatePolygon(polygons, areas, indices, { startPosition, endPosition, coordLength });
    }
  }
  function triangulatePolygon(polygons, areas, indices, {
    startPosition,
    endPosition,
    coordLength
  }) {
    const start = startPosition * coordLength;
    const end = endPosition * coordLength;
    const polygonPositions = polygons.positions.subarray(start, end);
    const offset = indices[0];
    const holes = indices.slice(1).map((n) => (n - offset) / coordLength);
    const triangles = earcut(polygonPositions, holes, coordLength, areas);
    for (let t = 0, tl = triangles.length; t < tl; ++t) {
      polygons.triangles.push(startPosition + triangles[t]);
    }
  }
  function wrapProps(obj, size) {
    const returnObj = {};
    for (const key in obj) {
      returnObj[key] = { value: obj[key], size };
    }
    return returnObj;
  }
  function makeAccessorObjects(points, lines, polygons, coordLength) {
    return {
      points: {
        ...points,
        positions: { value: points.positions, size: coordLength },
        globalFeatureIds: { value: points.globalFeatureIds, size: 1 },
        featureIds: { value: points.featureIds, size: 1 },
        numericProps: wrapProps(points.numericProps, 1)
      },
      lines: {
        ...lines,
        positions: { value: lines.positions, size: coordLength },
        pathIndices: { value: lines.pathIndices, size: 1 },
        globalFeatureIds: { value: lines.globalFeatureIds, size: 1 },
        featureIds: { value: lines.featureIds, size: 1 },
        numericProps: wrapProps(lines.numericProps, 1)
      },
      polygons: {
        ...polygons,
        positions: { value: polygons.positions, size: coordLength },
        polygonIndices: { value: polygons.polygonIndices, size: 1 },
        primitivePolygonIndices: { value: polygons.primitivePolygonIndices, size: 1 },
        triangles: { value: new Uint32Array(polygons.triangles), size: 1 },
        globalFeatureIds: { value: polygons.globalFeatureIds, size: 1 },
        featureIds: { value: polygons.featureIds, size: 1 },
        numericProps: wrapProps(polygons.numericProps, 1)
      }
    };
  }
  function fillNumericProperties(object, properties, index, length) {
    for (const numericPropName in object.numericProps) {
      if (numericPropName in properties) {
        const value = properties[numericPropName];
        object.numericProps[numericPropName].fill(value, index, index + length);
      }
    }
  }
  function keepStringProperties(properties, numericKeys) {
    const props = {};
    for (const key in properties) {
      if (!numericKeys.includes(key)) {
        props[key] = properties[key];
      }
    }
    return props;
  }
  function deduceArrayType(x, constructor) {
    if (constructor === Array || !Number.isFinite(x)) {
      return Array;
    }
    return constructor === Float64Array || Math.fround(x) !== x ? Float64Array : Float32Array;
  }
  var init_flat_geojson_to_binary = __esm({
    "../gis/src/lib/flat-geojson-to-binary.ts"() {
      init_esm();
    }
  });

  // ../gis/src/lib/extract-geometry-info.ts
  function extractGeometryInfo(features) {
    let pointPositionsCount = 0;
    let pointFeaturesCount = 0;
    let linePositionsCount = 0;
    let linePathsCount = 0;
    let lineFeaturesCount = 0;
    let polygonPositionsCount = 0;
    let polygonObjectsCount = 0;
    let polygonRingsCount = 0;
    let polygonFeaturesCount = 0;
    const coordLengths = new Set();
    for (const feature of features) {
      const geometry = feature.geometry;
      switch (geometry.type) {
        case "Point":
          pointFeaturesCount++;
          pointPositionsCount++;
          coordLengths.add(geometry.coordinates.length);
          break;
        case "MultiPoint":
          pointFeaturesCount++;
          pointPositionsCount += geometry.coordinates.length;
          for (const point of geometry.coordinates) {
            coordLengths.add(point.length);
          }
          break;
        case "LineString":
          lineFeaturesCount++;
          linePositionsCount += geometry.coordinates.length;
          linePathsCount++;
          for (const coord of geometry.coordinates) {
            coordLengths.add(coord.length);
          }
          break;
        case "MultiLineString":
          lineFeaturesCount++;
          for (const line of geometry.coordinates) {
            linePositionsCount += line.length;
            linePathsCount++;
            for (const coord of line) {
              coordLengths.add(coord.length);
            }
          }
          break;
        case "Polygon":
          polygonFeaturesCount++;
          polygonObjectsCount++;
          polygonRingsCount += geometry.coordinates.length;
          const flattened = geometry.coordinates.flat();
          polygonPositionsCount += flattened.length;
          for (const coord of flattened) {
            coordLengths.add(coord.length);
          }
          break;
        case "MultiPolygon":
          polygonFeaturesCount++;
          for (const polygon of geometry.coordinates) {
            polygonObjectsCount++;
            polygonRingsCount += polygon.length;
            const flattened2 = polygon.flat();
            polygonPositionsCount += flattened2.length;
            for (const coord of flattened2) {
              coordLengths.add(coord.length);
            }
          }
          break;
        default:
          throw new Error(`Unsupported geometry type: ${geometry.type}`);
      }
    }
    return {
      coordLength: coordLengths.size > 0 ? Math.max(...coordLengths) : 2,
      pointPositionsCount,
      pointFeaturesCount,
      linePositionsCount,
      linePathsCount,
      lineFeaturesCount,
      polygonPositionsCount,
      polygonObjectsCount,
      polygonRingsCount,
      polygonFeaturesCount
    };
  }
  var init_extract_geometry_info = __esm({
    "../gis/src/lib/extract-geometry-info.ts"() {
    }
  });

  // ../gis/src/lib/geojson-to-flat-geojson.ts
  function geojsonToFlatGeojson(features, options = { coordLength: 2, fixRingWinding: true }) {
    return features.map((feature) => flattenFeature(feature, options));
  }
  function flattenPoint(coordinates, data, indices, options) {
    indices.push(data.length);
    data.push(...coordinates);
    for (let i = coordinates.length; i < options.coordLength; i++) {
      data.push(0);
    }
  }
  function flattenLineString(coordinates, data, indices, options) {
    indices.push(data.length);
    for (const c of coordinates) {
      data.push(...c);
      for (let i = c.length; i < options.coordLength; i++) {
        data.push(0);
      }
    }
  }
  function flattenPolygon(coordinates, data, indices, areas, options) {
    let count = 0;
    const ringAreas = [];
    const polygons = [];
    for (const lineString of coordinates) {
      const lineString2d = lineString.map((p) => p.slice(0, 2));
      let area2 = getPolygonSignedArea(lineString2d.flat());
      const ccw = area2 < 0;
      if (options.fixRingWinding && (count === 0 && !ccw || count > 0 && ccw)) {
        lineString.reverse();
        area2 = -area2;
      }
      ringAreas.push(area2);
      flattenLineString(lineString, data, polygons, options);
      count++;
    }
    if (count > 0) {
      areas.push(ringAreas);
      indices.push(polygons);
    }
  }
  function flattenFeature(feature, options) {
    const { geometry } = feature;
    if (geometry.type === "GeometryCollection") {
      throw new Error("GeometryCollection type not supported");
    }
    const data = [];
    const indices = [];
    let areas;
    let type;
    switch (geometry.type) {
      case "Point":
        type = "Point";
        flattenPoint(geometry.coordinates, data, indices, options);
        break;
      case "MultiPoint":
        type = "Point";
        geometry.coordinates.map((c) => flattenPoint(c, data, indices, options));
        break;
      case "LineString":
        type = "LineString";
        flattenLineString(geometry.coordinates, data, indices, options);
        break;
      case "MultiLineString":
        type = "LineString";
        geometry.coordinates.map((c) => flattenLineString(c, data, indices, options));
        break;
      case "Polygon":
        type = "Polygon";
        areas = [];
        flattenPolygon(geometry.coordinates, data, indices, areas, options);
        break;
      case "MultiPolygon":
        type = "Polygon";
        areas = [];
        geometry.coordinates.map((c) => flattenPolygon(c, data, indices, areas, options));
        break;
      default:
        throw new Error(`Unknown type: ${type}`);
    }
    return { ...feature, geometry: { type, indices, data, areas } };
  }
  var init_geojson_to_flat_geojson = __esm({
    "../gis/src/lib/geojson-to-flat-geojson.ts"() {
      init_esm();
    }
  });

  // ../gis/src/lib/geojson-to-binary.ts
  function geojsonToBinary(features, options = { fixRingWinding: true }) {
    const geometryInfo = extractGeometryInfo(features);
    const coordLength = geometryInfo.coordLength;
    const { fixRingWinding } = options;
    const flatFeatures = geojsonToFlatGeojson(features, { coordLength, fixRingWinding });
    return flatGeojsonToBinary(flatFeatures, geometryInfo, {
      numericPropKeys: options.numericPropKeys,
      PositionDataType: options.PositionDataType || Float32Array
    });
  }
  var init_geojson_to_binary = __esm({
    "../gis/src/lib/geojson-to-binary.ts"() {
      init_extract_geometry_info();
      init_geojson_to_flat_geojson();
      init_flat_geojson_to_binary();
    }
  });

  // ../gis/src/index.ts
  var init_src3 = __esm({
    "../gis/src/index.ts"() {
      init_geojson_to_binary();
    }
  });

  // src/geojson-loader.ts
  async function parse3(arrayBuffer, options) {
    return parseTextSync3(new TextDecoder().decode(arrayBuffer), options);
  }
  function parseTextSync3(text, options) {
    options = { ...DEFAULT_GEOJSON_LOADER_OPTIONS, ...options };
    options.json = { ...DEFAULT_GEOJSON_LOADER_OPTIONS.geojson, ...options.geojson };
    options.gis = options.gis || {};
    const json = parseJSONSync(text, options);
    switch (options.gis.format) {
      case "binary":
        return geojsonToBinary(json);
      default:
        return json;
    }
  }
  function parseInBatches3(asyncIterator, options) {
    options = { ...DEFAULT_GEOJSON_LOADER_OPTIONS, ...options };
    options.json = { ...DEFAULT_GEOJSON_LOADER_OPTIONS.geojson, ...options.geojson };
    const geojsonIterator = parseJSONInBatches(asyncIterator, options);
    switch (options.gis.format) {
      case "binary":
        return makeBinaryGeometryIterator(geojsonIterator);
      default:
        return geojsonIterator;
    }
  }
  async function* makeBinaryGeometryIterator(geojsonIterator) {
    for await (const batch of geojsonIterator) {
      batch.data = geojsonToBinary(batch.data);
      yield batch;
    }
  }
  var VERSION3, DEFAULT_GEOJSON_LOADER_OPTIONS, GeoJSONWorkerLoader, GeoJSONLoader;
  var init_geojson_loader = __esm({
    "src/geojson-loader.ts"() {
      init_src3();
      init_parse_json();
      init_parse_json_in_batches();
      VERSION3 = typeof __VERSION__ !== "undefined" ? __VERSION__ : "latest";
      DEFAULT_GEOJSON_LOADER_OPTIONS = {
        geojson: {
          shape: "object-row-table"
        },
        json: {
          jsonpaths: ["$", "$.features"]
        },
        gis: {
          format: "geojson"
        }
      };
      GeoJSONWorkerLoader = {
        name: "GeoJSON",
        id: "geojson",
        module: "geojson",
        version: VERSION3,
        worker: true,
        extensions: ["geojson"],
        mimeTypes: ["application/geo+json"],
        category: "geometry",
        text: true,
        options: DEFAULT_GEOJSON_LOADER_OPTIONS
      };
      GeoJSONLoader = {
        ...GeoJSONWorkerLoader,
        parse: parse3,
        parseTextSync: parseTextSync3,
        parseInBatches: parseInBatches3
      };
    }
  });

  // src/index.ts
  var src_exports = {};
  __export(src_exports, {
    JSONLoader: () => JSONLoader,
    NDJSONLoader: () => NDJSONLoader,
    _ClarinetParser: () => ClarinetParser,
    _GeoJSONLoader: () => GeoJSONLoader,
    _GeoJSONWorkerLoader: () => GeoJSONWorkerLoader,
    _JSONPath: () => JSONPath,
    _rebuildJsonObject: () => rebuildJsonObject
  });
  var init_src4 = __esm({
    "src/index.ts"() {
      init_json_loader();
      init_ndjson_loader();
      init_geojson_loader();
      init_jsonpath();
      init_clarinet();
      init_parse_json_in_batches();
    }
  });

  // src/bundle.ts
  var require_bundle = __commonJS({
    "src/bundle.ts"(exports, module) {
      var moduleExports = (init_src4(), src_exports);
      globalThis.loaders = globalThis.loaders || {};
      module.exports = Object.assign(globalThis.loaders, moduleExports);
    }
  });
  require_bundle();
})();
