
__author__    = "Andre Merzky"
__copyright__ = "Copyright 2012-2013, The SAGA Project"
__license__   = "MIT"


# import gc

import os
import sys
import time
import saga
import pprint
import cProfile

import subprocess

import threading

def create_service (url, services) :

    service = saga.job.Service (url)
  # print "%s : %s" % (service.get_url (), id(service))
    services.append (service)



def run_jobs (service, n_jobs) :

    jd   = saga.job.Description ()
    jd.executable = '/bin/sleep'
    jd.arguments  = ['1']
    
    for id in range (1, n_jobs+1) :
        tmp_j     = service.create_job (jd)
        tmp_j.run ()
      # print "id: %5d : %s  [%s]" % (id, tmp_j.id, tmp_j.get_state ())
        # time.sleep (5)

    # time.sleep (1)
    # sys.stdout.write ('\n')
    # del (service)



def perf (n_jobs, tuples) :

    try :

        s = saga.Session ()

        targets    = ""
        urls       = []
        threads    = []
        services   = []
        n_services = 0

        for (n, url) in tuples :
            for i in range (0, n) : urls.append (url)
            n_services += n
            targets    += "%d*%s " % (n, url)


        for url in urls :
            thread = threading.Thread (target=create_service, args=[url, services])
            thread.start ()
            threads.append (thread)

        for thread in threads :
            thread.join ()

        threads = []

        start      = time.time ()
        for service in services :
            thread = threading.Thread (target=run_jobs, args=[service, n_jobs // n_services])
            thread.start ()
            threads.append (thread)

        for thread in threads :
            thread.join ()

        stop    = time.time ()
        seconds = stop - start
        rate    = n_jobs / (seconds)
        print "%10s  %5s  %5.2f  %7.2f  %s" % (n_services, n_jobs, seconds, rate, targets)
            
    except saga.exceptions.SagaException as e :
        print "Exception: ==========\n%s"  %  e.get_message ()
        print "%s====================="    %  e.get_traceback ()



#     "xxxxxxxxxx xxxxxx xxxxxx xxxxxxxx xxxxxx  xxxxxxx..."
print "n_services n_jobs   time jobs/sec memory  targets"

def main () :
    perf (100, [(1, 'fork://localhost/')])

# cProfile.run('main()', 'test_perf.prof')

# perf (10000, [(10, 'ssh://merzky@localhost/')]          + \
#              [(10, 'ssh://amerzky@cyder.cct.lsu.edu/')] +  \
#              [(10, 'ssh://repex1.tacc.utexas.edu/')])

# perf (100, [(2, 'fork://localhost/')])
# perf (100, [(2, 'ssh://merzky@localhost/')])

# perf (1000,  [( 1, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (1000,  [( 2, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (1000,  [( 3, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (1000,  [( 4, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (1000,  [( 5, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (1000,  [( 6, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (1000,  [( 7, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (1000,  [( 8, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (1000,  [( 9, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (1000,  [(10, 'ssh://amerzky@cyder.cct.lsu.edu/')])

# perf (1,  [(1, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (1,  [(1, 'ssh://repex1.tacc.utexas.edu/')])
# perf (1,  [(1, 'gsissh://trestles-login.sdsc.edu/')])
# perf (1,  [(1, 'ssh://india.futuregrid.org/')])
# perf (1,  [(1, 'ssh://sierra.futuregrid.org/')])

perf (100,  [(10, 'ssh://amerzky@cyder.cct.lsu.edu/')])
perf (100,  [(10, 'ssh://amerzky@cyder.cct.lsu.edu/'), 
             (10, 'ssh://repex1.tacc.utexas.edu/')])
perf (100,  [(10, 'ssh://amerzky@cyder.cct.lsu.edu/'), 
             (10, 'ssh://repex1.tacc.utexas.edu/'), 
             (10, 'gsissh://trestles-login.sdsc.edu/')])
perf (100,  [(10, 'ssh://amerzky@cyder.cct.lsu.edu/'), 
             (10, 'ssh://repex1.tacc.utexas.edu/'), 
             (10, 'gsissh://trestles-login.sdsc.edu/'), 
             (10, 'ssh://india.futuregrid.org/')])
perf (100,  [(10, 'ssh://amerzky@cyder.cct.lsu.edu/'), 
             (10, 'ssh://repex1.tacc.utexas.edu/'), 
             (10, 'gsissh://trestles-login.sdsc.edu/'), 
             (10, 'ssh://india.futuregrid.org/'), 
             (10, 'ssh://sierra.futuregrid.org/')])


# perf (    100,  [(1, 'fork://localhost/')])
# perf (    100,  [(1, 'ssh://merzky@localhost/')])
# perf (    100,  [(10, 'fork://localhost/')])
# perf (    100,  [(10, 'ssh://merzky@localhost/')])
# perf (    1,  [(1, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    1,  [(1, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    1,  [(1, 'gsissh://stampede.tacc.utexas.edu/')])

# perf (  10,  [(10, 'fork://localhost/')])
# perf (  10,  [(10, 'fork://localhost/')])
# perf (  10,  [(10, 'fork://localhost/')])
#           
# perf (  10,  [(10, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  10,  [(10, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  10,  [(10, 'ssh://repex1.tacc.utexas.edu/')])
#           
# perf (  10,  [(10, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  10,  [(10, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  10,  [(10, 'ssh://amerzky@cyder.cct.lsu.edu/')])
#           
# perf (  10,  [(10, 'ssh://localhost/')])
# perf (  10,  [(10, 'ssh://localhost/')])
# perf (  10,  [(10, 'ssh://localhost/')])
#          
# perf (  10,  [(10, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  10,  [(10, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  10,  [(10, 'gsissh://ranger.tacc.utexas.edu/')])
 
# perf (  100,  [(1, 'ssh://merzky@localhost/')])

# perf (    0,  [(1, 'fork://localhost/')])
# perf (    1,  [(1, 'fork://localhost/')])
# perf (    2,  [(1, 'fork://localhost/')])
# perf (    4,  [(1, 'fork://localhost/')])
# perf (    8,  [(1, 'fork://localhost/')])
# perf (   16,  [(1, 'fork://localhost/')])
# perf (   32,  [(1, 'fork://localhost/')])
# perf (   64,  [(1, 'fork://localhost/')])
# perf (  128,  [(1, 'fork://localhost/')])
# perf (  256,  [(1, 'fork://localhost/')])
# perf (  512,  [(1, 'fork://localhost/')])
# perf ( 1024,  [(1, 'fork://localhost/')])
# perf ( 2048,  [(1, 'fork://localhost/')])
# perf ( 4096,  [(1, 'fork://localhost/')])
# perf ( 8192,  [(1, 'fork://localhost/')])
# perf (16384,  [(1, 'fork://localhost/')])
# perf (32768,  [(1, 'fork://localhost/')])
# perf (    0,  [(2, 'fork://localhost/')])
# perf (    1,  [(2, 'fork://localhost/')])
# perf (    2,  [(2, 'fork://localhost/')])
# perf (    4,  [(2, 'fork://localhost/')])
# perf (    8,  [(2, 'fork://localhost/')])
# perf (   16,  [(2, 'fork://localhost/')])
# perf (   32,  [(2, 'fork://localhost/')])
# perf (   64,  [(2, 'fork://localhost/')])
# perf (  128,  [(2, 'fork://localhost/')])
# perf (  256,  [(2, 'fork://localhost/')])
# perf (  512,  [(2, 'fork://localhost/')])
# perf ( 1024,  [(2, 'fork://localhost/')])
# perf ( 2048,  [(2, 'fork://localhost/')])
# perf ( 4096,  [(2, 'fork://localhost/')])
# perf ( 8192,  [(2, 'fork://localhost/')])
# perf (16384,  [(2, 'fork://localhost/')])
# perf (32768,  [(2, 'fork://localhost/')])
# perf (    0,  [(3, 'fork://localhost/')])
# perf (    1,  [(3, 'fork://localhost/')])
# perf (    2,  [(3, 'fork://localhost/')])
# perf (    4,  [(3, 'fork://localhost/')])
# perf (    8,  [(3, 'fork://localhost/')])
# perf (   16,  [(3, 'fork://localhost/')])
# perf (   32,  [(3, 'fork://localhost/')])
# perf (   64,  [(3, 'fork://localhost/')])
# perf (  128,  [(3, 'fork://localhost/')])
# perf (  256,  [(3, 'fork://localhost/')])
# perf (  512,  [(3, 'fork://localhost/')])
# perf ( 1024,  [(3, 'fork://localhost/')])
# perf ( 2048,  [(3, 'fork://localhost/')])
# perf ( 4096,  [(3, 'fork://localhost/')])
# perf ( 8192,  [(3, 'fork://localhost/')])
# perf (16384,  [(3, 'fork://localhost/')])
# perf (32768,  [(3, 'fork://localhost/')])
# perf (    0,  [(4, 'fork://localhost/')])
# perf (    1,  [(4, 'fork://localhost/')])
# perf (    2,  [(4, 'fork://localhost/')])
# perf (    4,  [(4, 'fork://localhost/')])
# perf (    8,  [(4, 'fork://localhost/')])
# perf (   16,  [(4, 'fork://localhost/')])
# perf (   32,  [(4, 'fork://localhost/')])
# perf (   64,  [(4, 'fork://localhost/')])
# perf (  128,  [(4, 'fork://localhost/')])
# perf (  256,  [(4, 'fork://localhost/')])
# perf (  512,  [(4, 'fork://localhost/')])
# perf ( 1024,  [(4, 'fork://localhost/')])
# perf ( 2048,  [(4, 'fork://localhost/')])
# perf ( 4096,  [(4, 'fork://localhost/')])
# perf ( 8192,  [(4, 'fork://localhost/')])
# perf (16384,  [(4, 'fork://localhost/')])
# perf (32768,  [(4, 'fork://localhost/')])
# perf (    0,  [(5, 'fork://localhost/')])
# perf (    1,  [(5, 'fork://localhost/')])
# perf (    2,  [(5, 'fork://localhost/')])
# perf (    4,  [(5, 'fork://localhost/')])
# perf (    8,  [(5, 'fork://localhost/')])
# perf (   16,  [(5, 'fork://localhost/')])
# perf (   32,  [(5, 'fork://localhost/')])
# perf (   64,  [(5, 'fork://localhost/')])
# perf (  128,  [(5, 'fork://localhost/')])
# perf (  256,  [(5, 'fork://localhost/')])
# perf (  512,  [(5, 'fork://localhost/')])
# perf ( 1024,  [(5, 'fork://localhost/')])
# perf ( 2048,  [(5, 'fork://localhost/')])
# perf ( 4096,  [(5, 'fork://localhost/')])
# perf ( 8192,  [(5, 'fork://localhost/')])
# perf (16384,  [(5, 'fork://localhost/')])
# perf (32768,  [(5, 'fork://localhost/')])
# perf (    0,  [(6, 'fork://localhost/')])
# perf (    1,  [(6, 'fork://localhost/')])
# perf (    2,  [(6, 'fork://localhost/')])
# perf (    4,  [(6, 'fork://localhost/')])
# perf (    8,  [(6, 'fork://localhost/')])
# perf (   16,  [(6, 'fork://localhost/')])
# perf (   32,  [(6, 'fork://localhost/')])
# perf (   64,  [(6, 'fork://localhost/')])
# perf (  128,  [(6, 'fork://localhost/')])
# perf (  256,  [(6, 'fork://localhost/')])
# perf (  512,  [(6, 'fork://localhost/')])
# perf ( 1024,  [(6, 'fork://localhost/')])
# perf ( 2048,  [(6, 'fork://localhost/')])
# perf ( 4096,  [(6, 'fork://localhost/')])
# perf ( 8192,  [(6, 'fork://localhost/')])
# perf (16384,  [(6, 'fork://localhost/')])
# perf (32768,  [(6, 'fork://localhost/')])
# perf (    0,  [(7, 'fork://localhost/')])
# perf (    1,  [(7, 'fork://localhost/')])
# perf (    2,  [(7, 'fork://localhost/')])
# perf (    4,  [(7, 'fork://localhost/')])
# perf (    8,  [(7, 'fork://localhost/')])
# perf (   16,  [(7, 'fork://localhost/')])
# perf (   32,  [(7, 'fork://localhost/')])
# perf (   64,  [(7, 'fork://localhost/')])
# perf (  128,  [(7, 'fork://localhost/')])
# perf (  256,  [(7, 'fork://localhost/')])
# perf (  512,  [(7, 'fork://localhost/')])
# perf ( 1024,  [(7, 'fork://localhost/')])
# perf ( 2048,  [(7, 'fork://localhost/')])
# perf ( 4096,  [(7, 'fork://localhost/')])
# perf ( 8192,  [(7, 'fork://localhost/')])
# perf (16384,  [(7, 'fork://localhost/')])
# perf (32768,  [(7, 'fork://localhost/')])
# perf (    0,  [(8, 'fork://localhost/')])
# perf (    1,  [(8, 'fork://localhost/')])
# perf (    2,  [(8, 'fork://localhost/')])
# perf (    4,  [(8, 'fork://localhost/')])
# perf (    8,  [(8, 'fork://localhost/')])
# perf (   16,  [(8, 'fork://localhost/')])
# perf (   32,  [(8, 'fork://localhost/')])
# perf (   64,  [(8, 'fork://localhost/')])
# perf (  128,  [(8, 'fork://localhost/')])
# perf (  256,  [(8, 'fork://localhost/')])
# perf (  512,  [(8, 'fork://localhost/')])
# perf ( 1024,  [(8, 'fork://localhost/')])
# perf ( 2048,  [(8, 'fork://localhost/')])
# perf ( 4096,  [(8, 'fork://localhost/')])
# perf ( 8192,  [(8, 'fork://localhost/')])
# perf (16384,  [(8, 'fork://localhost/')])
# perf (32768,  [(8, 'fork://localhost/')])
# perf (    0,  [(9, 'fork://localhost/')])
# perf (    1,  [(9, 'fork://localhost/')])
# perf (    2,  [(9, 'fork://localhost/')])
# perf (    4,  [(9, 'fork://localhost/')])
# perf (    8,  [(9, 'fork://localhost/')])
# perf (   16,  [(9, 'fork://localhost/')])
# perf (   32,  [(9, 'fork://localhost/')])
# perf (   64,  [(9, 'fork://localhost/')])
# perf (  128,  [(9, 'fork://localhost/')])
# perf (  256,  [(9, 'fork://localhost/')])
# perf (  512,  [(9, 'fork://localhost/')])
# perf ( 1024,  [(9, 'fork://localhost/')])
# perf ( 2048,  [(9, 'fork://localhost/')])
# perf ( 4096,  [(9, 'fork://localhost/')])
# perf ( 8192,  [(9, 'fork://localhost/')])
# perf (16384,  [(9, 'fork://localhost/')])
# perf (32768,  [(9, 'fork://localhost/')])
# perf (    0, [(10, 'fork://localhost/')])
# perf (    1, [(10, 'fork://localhost/')])
# perf (    2, [(10, 'fork://localhost/')])
# perf (    4, [(10, 'fork://localhost/')])
# perf (    8, [(10, 'fork://localhost/')])
# perf (   16, [(10, 'fork://localhost/')])
# perf (   32, [(10, 'fork://localhost/')])
# perf (   64, [(10, 'fork://localhost/')])
# perf (  128, [(10, 'fork://localhost/')])
# perf (  256, [(10, 'fork://localhost/')])
# perf (  512, [(10, 'fork://localhost/')])
# perf ( 1024, [(10, 'fork://localhost/')])
# perf ( 2048, [(10, 'fork://localhost/')])
# perf ( 4096, [(10, 'fork://localhost/')])
# perf ( 8192, [(10, 'fork://localhost/')])
# perf (16384, [(10, 'fork://localhost/')])
# perf (32768, [(10, 'fork://localhost/')])
# 
# perf (    0,  [(1, 'ssh://merzky@localhost/')])
# perf (    1,  [(1, 'ssh://merzky@localhost/')])
# perf (    2,  [(1, 'ssh://merzky@localhost/')])
# perf (    4,  [(1, 'ssh://merzky@localhost/')])
# perf (    8,  [(1, 'ssh://merzky@localhost/')])
# perf (   16,  [(1, 'ssh://merzky@localhost/')])
# perf (   32,  [(1, 'ssh://merzky@localhost/')])
# perf (   64,  [(1, 'ssh://merzky@localhost/')])
# perf (  128,  [(1, 'ssh://merzky@localhost/')])
# perf (  256,  [(1, 'ssh://merzky@localhost/')])
# perf (  512,  [(1, 'ssh://merzky@localhost/')])
# perf ( 1024,  [(1, 'ssh://merzky@localhost/')])
# perf ( 2048,  [(1, 'ssh://merzky@localhost/')])
# perf ( 4096,  [(1, 'ssh://merzky@localhost/')])
# perf ( 8192,  [(1, 'ssh://merzky@localhost/')])
# perf (16384,  [(1, 'ssh://merzky@localhost/')])
# perf (32768,  [(1, 'ssh://merzky@localhost/')])
# perf (    0,  [(2, 'ssh://merzky@localhost/')])
# perf (    1,  [(2, 'ssh://merzky@localhost/')])
# perf (    2,  [(2, 'ssh://merzky@localhost/')])
# perf (    4,  [(2, 'ssh://merzky@localhost/')])
# perf (    8,  [(2, 'ssh://merzky@localhost/')])
# perf (   16,  [(2, 'ssh://merzky@localhost/')])
# perf (   32,  [(2, 'ssh://merzky@localhost/')])
# perf (   64,  [(2, 'ssh://merzky@localhost/')])
# perf (  128,  [(2, 'ssh://merzky@localhost/')])
# perf (  256,  [(2, 'ssh://merzky@localhost/')])
# perf (  512,  [(2, 'ssh://merzky@localhost/')])
# perf ( 1024,  [(2, 'ssh://merzky@localhost/')])
# perf ( 2048,  [(2, 'ssh://merzky@localhost/')])
# perf ( 4096,  [(2, 'ssh://merzky@localhost/')])
# perf ( 8192,  [(2, 'ssh://merzky@localhost/')])
# perf (16384,  [(2, 'ssh://merzky@localhost/')])
# perf (32768,  [(2, 'ssh://merzky@localhost/')])
# perf (    0,  [(3, 'ssh://merzky@localhost/')])
# perf (    1,  [(3, 'ssh://merzky@localhost/')])
# perf (    2,  [(3, 'ssh://merzky@localhost/')])
# perf (    4,  [(3, 'ssh://merzky@localhost/')])
# perf (    8,  [(3, 'ssh://merzky@localhost/')])
# perf (   16,  [(3, 'ssh://merzky@localhost/')])
# perf (   32,  [(3, 'ssh://merzky@localhost/')])
# perf (   64,  [(3, 'ssh://merzky@localhost/')])
# perf (  128,  [(3, 'ssh://merzky@localhost/')])
# perf (  256,  [(3, 'ssh://merzky@localhost/')])
# perf (  512,  [(3, 'ssh://merzky@localhost/')])
# perf ( 1024,  [(3, 'ssh://merzky@localhost/')])
# perf ( 2048,  [(3, 'ssh://merzky@localhost/')])
# perf ( 4096,  [(3, 'ssh://merzky@localhost/')])
# perf ( 8192,  [(3, 'ssh://merzky@localhost/')])
# perf (16384,  [(3, 'ssh://merzky@localhost/')])
# perf (32768,  [(3, 'ssh://merzky@localhost/')])
# perf (    0,  [(4, 'ssh://merzky@localhost/')])
# perf (    1,  [(4, 'ssh://merzky@localhost/')])
# perf (    2,  [(4, 'ssh://merzky@localhost/')])
# perf (    4,  [(4, 'ssh://merzky@localhost/')])
# perf (    8,  [(4, 'ssh://merzky@localhost/')])
# perf (   16,  [(4, 'ssh://merzky@localhost/')])
# perf (   32,  [(4, 'ssh://merzky@localhost/')])
# perf (   64,  [(4, 'ssh://merzky@localhost/')])
# perf (  128,  [(4, 'ssh://merzky@localhost/')])
# perf (  256,  [(4, 'ssh://merzky@localhost/')])
# perf (  512,  [(4, 'ssh://merzky@localhost/')])
# perf ( 1024,  [(4, 'ssh://merzky@localhost/')])
# perf ( 2048,  [(4, 'ssh://merzky@localhost/')])
# perf ( 4096,  [(4, 'ssh://merzky@localhost/')])
# perf ( 8192,  [(4, 'ssh://merzky@localhost/')])
# perf (16384,  [(4, 'ssh://merzky@localhost/')])
# perf (32768,  [(4, 'ssh://merzky@localhost/')])
# perf (    0,  [(5, 'ssh://merzky@localhost/')])
# perf (    1,  [(5, 'ssh://merzky@localhost/')])
# perf (    2,  [(5, 'ssh://merzky@localhost/')])
# perf (    4,  [(5, 'ssh://merzky@localhost/')])
# perf (    8,  [(5, 'ssh://merzky@localhost/')])
# perf (   16,  [(5, 'ssh://merzky@localhost/')])
# perf (   32,  [(5, 'ssh://merzky@localhost/')])
# perf (   64,  [(5, 'ssh://merzky@localhost/')])
# perf (  128,  [(5, 'ssh://merzky@localhost/')])
# perf (  256,  [(5, 'ssh://merzky@localhost/')])
# perf (  512,  [(5, 'ssh://merzky@localhost/')])
# perf ( 1024,  [(5, 'ssh://merzky@localhost/')])
# perf ( 2048,  [(5, 'ssh://merzky@localhost/')])
# perf ( 4096,  [(5, 'ssh://merzky@localhost/')])
# perf ( 8192,  [(5, 'ssh://merzky@localhost/')])
# perf (16384,  [(5, 'ssh://merzky@localhost/')])
# perf (32768,  [(5, 'ssh://merzky@localhost/')])
# perf (    0,  [(6, 'ssh://merzky@localhost/')])
# perf (    1,  [(6, 'ssh://merzky@localhost/')])
# perf (    2,  [(6, 'ssh://merzky@localhost/')])
# perf (    4,  [(6, 'ssh://merzky@localhost/')])
# perf (    8,  [(6, 'ssh://merzky@localhost/')])
# perf (   16,  [(6, 'ssh://merzky@localhost/')])
# perf (   32,  [(6, 'ssh://merzky@localhost/')])
# perf (   64,  [(6, 'ssh://merzky@localhost/')])
# perf (  128,  [(6, 'ssh://merzky@localhost/')])
# perf (  256,  [(6, 'ssh://merzky@localhost/')])
# perf (  512,  [(6, 'ssh://merzky@localhost/')])
# perf ( 1024,  [(6, 'ssh://merzky@localhost/')])
# perf ( 2048,  [(6, 'ssh://merzky@localhost/')])
# perf ( 4096,  [(6, 'ssh://merzky@localhost/')])
# perf ( 8192,  [(6, 'ssh://merzky@localhost/')])
# perf (16384,  [(6, 'ssh://merzky@localhost/')])
# perf (32768,  [(6, 'ssh://merzky@localhost/')])
# perf (    0,  [(7, 'ssh://merzky@localhost/')])
# perf (    1,  [(7, 'ssh://merzky@localhost/')])
# perf (    2,  [(7, 'ssh://merzky@localhost/')])
# perf (    4,  [(7, 'ssh://merzky@localhost/')])
# perf (    8,  [(7, 'ssh://merzky@localhost/')])
# perf (   16,  [(7, 'ssh://merzky@localhost/')])
# perf (   32,  [(7, 'ssh://merzky@localhost/')])
# perf (   64,  [(7, 'ssh://merzky@localhost/')])
# perf (  128,  [(7, 'ssh://merzky@localhost/')])
# perf (  256,  [(7, 'ssh://merzky@localhost/')])
# perf (  512,  [(7, 'ssh://merzky@localhost/')])
# perf ( 1024,  [(7, 'ssh://merzky@localhost/')])
# perf ( 2048,  [(7, 'ssh://merzky@localhost/')])
# perf ( 4096,  [(7, 'ssh://merzky@localhost/')])
# perf ( 8192,  [(7, 'ssh://merzky@localhost/')])
# perf (16384,  [(7, 'ssh://merzky@localhost/')])
# perf (32768,  [(7, 'ssh://merzky@localhost/')])
# perf (    0,  [(8, 'ssh://merzky@localhost/')])
# perf (    1,  [(8, 'ssh://merzky@localhost/')])
# perf (    2,  [(8, 'ssh://merzky@localhost/')])
# perf (    4,  [(8, 'ssh://merzky@localhost/')])
# perf (    8,  [(8, 'ssh://merzky@localhost/')])
# perf (   16,  [(8, 'ssh://merzky@localhost/')])
# perf (   32,  [(8, 'ssh://merzky@localhost/')])
# perf (   64,  [(8, 'ssh://merzky@localhost/')])
# perf (  128,  [(8, 'ssh://merzky@localhost/')])
# perf (  256,  [(8, 'ssh://merzky@localhost/')])
# perf (  512,  [(8, 'ssh://merzky@localhost/')])
# perf ( 1024,  [(8, 'ssh://merzky@localhost/')])
# perf ( 2048,  [(8, 'ssh://merzky@localhost/')])
# perf ( 4096,  [(8, 'ssh://merzky@localhost/')])
# perf ( 8192,  [(8, 'ssh://merzky@localhost/')])
# perf (16384,  [(8, 'ssh://merzky@localhost/')])
# perf (32768,  [(8, 'ssh://merzky@localhost/')])
# perf (    0,  [(9, 'ssh://merzky@localhost/')])
# perf (    1,  [(9, 'ssh://merzky@localhost/')])
# perf (    2,  [(9, 'ssh://merzky@localhost/')])
# perf (    4,  [(9, 'ssh://merzky@localhost/')])
# perf (    8,  [(9, 'ssh://merzky@localhost/')])
# perf (   16,  [(9, 'ssh://merzky@localhost/')])
# perf (   32,  [(9, 'ssh://merzky@localhost/')])
# perf (   64,  [(9, 'ssh://merzky@localhost/')])
# perf (  128,  [(9, 'ssh://merzky@localhost/')])
# perf (  256,  [(9, 'ssh://merzky@localhost/')])
# perf (  512,  [(9, 'ssh://merzky@localhost/')])
# perf ( 1024,  [(9, 'ssh://merzky@localhost/')])
# perf ( 2048,  [(9, 'ssh://merzky@localhost/')])
# perf ( 4096,  [(9, 'ssh://merzky@localhost/')])
# perf ( 8192,  [(9, 'ssh://merzky@localhost/')])
# perf (16384,  [(9, 'ssh://merzky@localhost/')])
# perf (32768,  [(9, 'ssh://merzky@localhost/')])
# perf (    0, [(10, 'ssh://merzky@localhost/')])
# perf (    1, [(10, 'ssh://merzky@localhost/')])
# perf (    2, [(10, 'ssh://merzky@localhost/')])
# perf (    4, [(10, 'ssh://merzky@localhost/')])
# perf (    8, [(10, 'ssh://merzky@localhost/')])
# perf (   16, [(10, 'ssh://merzky@localhost/')])
# perf (   32, [(10, 'ssh://merzky@localhost/')])
# perf (   64, [(10, 'ssh://merzky@localhost/')])
# perf (  128, [(10, 'ssh://merzky@localhost/')])
# perf (  256, [(10, 'ssh://merzky@localhost/')])
# perf (  512, [(10, 'ssh://merzky@localhost/')])
# perf ( 1024, [(10, 'ssh://merzky@localhost/')])
# perf ( 2048, [(10, 'ssh://merzky@localhost/')])
# perf ( 4096, [(10, 'ssh://merzky@localhost/')])
# perf ( 8192, [(10, 'ssh://merzky@localhost/')])
# perf (16384, [(10, 'ssh://merzky@localhost/')])
# perf (32768, [(10, 'ssh://merzky@localhost/')])
# 
# 
# perf (    0,  [(1, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    1,  [(1, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    2,  [(1, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    4,  [(1, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    8,  [(1, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   16,  [(1, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   32,  [(1, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   64,  [(1, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  128,  [(1, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  256,  [(1, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  512,  [(1, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 1024,  [(1, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 2048,  [(1, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 4096,  [(1, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 8192,  [(1, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (16384,  [(1, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (32768,  [(1, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    0,  [(2, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    1,  [(2, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    2,  [(2, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    4,  [(2, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    8,  [(2, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   16,  [(2, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   32,  [(2, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   64,  [(2, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  128,  [(2, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  256,  [(2, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  512,  [(2, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 1024,  [(2, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 2048,  [(2, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 4096,  [(2, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 8192,  [(2, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (16384,  [(2, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (32768,  [(2, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    0,  [(3, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    1,  [(3, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    2,  [(3, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    4,  [(3, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    8,  [(3, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   16,  [(3, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   32,  [(3, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   64,  [(3, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  128,  [(3, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  256,  [(3, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  512,  [(3, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 1024,  [(3, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 2048,  [(3, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 4096,  [(3, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 8192,  [(3, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (16384,  [(3, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (32768,  [(3, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    0,  [(4, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    1,  [(4, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    2,  [(4, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    4,  [(4, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    8,  [(4, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   16,  [(4, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   32,  [(4, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   64,  [(4, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  128,  [(4, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  256,  [(4, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  512,  [(4, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 1024,  [(4, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 2048,  [(4, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 4096,  [(4, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 8192,  [(4, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (16384,  [(4, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (32768,  [(4, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    0,  [(5, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    1,  [(5, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    2,  [(5, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    4,  [(5, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    8,  [(5, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   16,  [(5, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   32,  [(5, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   64,  [(5, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  128,  [(5, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  256,  [(5, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  512,  [(5, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 1024,  [(5, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 2048,  [(5, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 4096,  [(5, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 8192,  [(5, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (16384,  [(5, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (32768,  [(5, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    0,  [(6, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    1,  [(6, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    2,  [(6, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    4,  [(6, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    8,  [(6, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   16,  [(6, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   32,  [(6, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   64,  [(6, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  128,  [(6, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  256,  [(6, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  512,  [(6, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 1024,  [(6, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 2048,  [(6, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 4096,  [(6, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 8192,  [(6, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (16384,  [(6, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (32768,  [(6, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    0,  [(7, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    1,  [(7, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    2,  [(7, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    4,  [(7, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    8,  [(7, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   16,  [(7, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   32,  [(7, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   64,  [(7, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  128,  [(7, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  256,  [(7, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  512,  [(7, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 1024,  [(7, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 2048,  [(7, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 4096,  [(7, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 8192,  [(7, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (16384,  [(7, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (32768,  [(7, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    0,  [(8, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    1,  [(8, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    2,  [(8, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    4,  [(8, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    8,  [(8, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   16,  [(8, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   32,  [(8, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   64,  [(8, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  128,  [(8, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  256,  [(8, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  512,  [(8, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 1024,  [(8, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 2048,  [(8, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 4096,  [(8, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 8192,  [(8, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (16384,  [(8, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (32768,  [(8, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    0,  [(9, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    1,  [(9, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    2,  [(9, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    4,  [(9, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    8,  [(9, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   16,  [(9, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   32,  [(9, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   64,  [(9, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  128,  [(9, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  256,  [(9, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  512,  [(9, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 1024,  [(9, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 2048,  [(9, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 4096,  [(9, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 8192,  [(9, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (16384,  [(9, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (32768,  [(9, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    0, [(10, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    1, [(10, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    2, [(10, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    4, [(10, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (    8, [(10, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   16, [(10, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   32, [(10, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (   64, [(10, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  128, [(10, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  256, [(10, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (  512, [(10, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 1024, [(10, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 2048, [(10, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 4096, [(10, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf ( 8192, [(10, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (16384, [(10, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# perf (32768, [(10, 'ssh://amerzky@cyder.cct.lsu.edu/')])
# 
# 
# perf (    0,  [(1, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    1,  [(1, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    2,  [(1, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    4,  [(1, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    8,  [(1, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   16,  [(1, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   32,  [(1, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   64,  [(1, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  128,  [(1, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  256,  [(1, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  512,  [(1, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 1024,  [(1, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 2048,  [(1, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 4096,  [(1, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 8192,  [(1, 'ssh://repex1.tacc.utexas.edu/')])
# perf (16384,  [(1, 'ssh://repex1.tacc.utexas.edu/')])
# perf (32768,  [(1, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    0,  [(2, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    1,  [(2, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    2,  [(2, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    4,  [(2, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    8,  [(2, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   16,  [(2, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   32,  [(2, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   64,  [(2, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  128,  [(2, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  256,  [(2, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  512,  [(2, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 1024,  [(2, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 2048,  [(2, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 4096,  [(2, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 8192,  [(2, 'ssh://repex1.tacc.utexas.edu/')])
# perf (16384,  [(2, 'ssh://repex1.tacc.utexas.edu/')])
# perf (32768,  [(2, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    0,  [(3, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    1,  [(3, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    2,  [(3, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    4,  [(3, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    8,  [(3, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   16,  [(3, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   32,  [(3, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   64,  [(3, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  128,  [(3, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  256,  [(3, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  512,  [(3, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 1024,  [(3, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 2048,  [(3, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 4096,  [(3, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 8192,  [(3, 'ssh://repex1.tacc.utexas.edu/')])
# perf (16384,  [(3, 'ssh://repex1.tacc.utexas.edu/')])
# perf (32768,  [(3, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    0,  [(4, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    1,  [(4, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    2,  [(4, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    4,  [(4, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    8,  [(4, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   16,  [(4, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   32,  [(4, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   64,  [(4, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  128,  [(4, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  256,  [(4, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  512,  [(4, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 1024,  [(4, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 2048,  [(4, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 4096,  [(4, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 8192,  [(4, 'ssh://repex1.tacc.utexas.edu/')])
# perf (16384,  [(4, 'ssh://repex1.tacc.utexas.edu/')])
# perf (32768,  [(4, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    0,  [(5, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    1,  [(5, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    2,  [(5, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    4,  [(5, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    8,  [(5, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   16,  [(5, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   32,  [(5, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   64,  [(5, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  128,  [(5, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  256,  [(5, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  512,  [(5, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 1024,  [(5, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 2048,  [(5, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 4096,  [(5, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 8192,  [(5, 'ssh://repex1.tacc.utexas.edu/')])
# perf (16384,  [(5, 'ssh://repex1.tacc.utexas.edu/')])
# perf (32768,  [(5, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    0,  [(6, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    1,  [(6, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    2,  [(6, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    4,  [(6, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    8,  [(6, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   16,  [(6, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   32,  [(6, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   64,  [(6, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  128,  [(6, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  256,  [(6, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  512,  [(6, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 1024,  [(6, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 2048,  [(6, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 4096,  [(6, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 8192,  [(6, 'ssh://repex1.tacc.utexas.edu/')])
# perf (16384,  [(6, 'ssh://repex1.tacc.utexas.edu/')])
# perf (32768,  [(6, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    0,  [(7, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    1,  [(7, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    2,  [(7, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    4,  [(7, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    8,  [(7, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   16,  [(7, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   32,  [(7, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   64,  [(7, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  128,  [(7, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  256,  [(7, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  512,  [(7, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 1024,  [(7, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 2048,  [(7, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 4096,  [(7, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 8192,  [(7, 'ssh://repex1.tacc.utexas.edu/')])
# perf (16384,  [(7, 'ssh://repex1.tacc.utexas.edu/')])
# perf (32768,  [(7, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    0,  [(8, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    1,  [(8, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    2,  [(8, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    4,  [(8, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    8,  [(8, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   16,  [(8, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   32,  [(8, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   64,  [(8, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  128,  [(8, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  256,  [(8, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  512,  [(8, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 1024,  [(8, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 2048,  [(8, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 4096,  [(8, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 8192,  [(8, 'ssh://repex1.tacc.utexas.edu/')])
# perf (16384,  [(8, 'ssh://repex1.tacc.utexas.edu/')])
# perf (32768,  [(8, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    0,  [(9, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    1,  [(9, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    2,  [(9, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    4,  [(9, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    8,  [(9, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   16,  [(9, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   32,  [(9, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   64,  [(9, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  128,  [(9, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  256,  [(9, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  512,  [(9, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 1024,  [(9, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 2048,  [(9, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 4096,  [(9, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 8192,  [(9, 'ssh://repex1.tacc.utexas.edu/')])
# perf (16384,  [(9, 'ssh://repex1.tacc.utexas.edu/')])
# perf (32768,  [(9, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    0, [(10, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    1, [(10, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    2, [(10, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    4, [(10, 'ssh://repex1.tacc.utexas.edu/')])
# perf (    8, [(10, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   16, [(10, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   32, [(10, 'ssh://repex1.tacc.utexas.edu/')])
# perf (   64, [(10, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  128, [(10, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  256, [(10, 'ssh://repex1.tacc.utexas.edu/')])
# perf (  512, [(10, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 1024, [(10, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 2048, [(10, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 4096, [(10, 'ssh://repex1.tacc.utexas.edu/')])
# perf ( 8192, [(10, 'ssh://repex1.tacc.utexas.edu/')])
# perf (16384, [(10, 'ssh://repex1.tacc.utexas.edu/')])
# perf (32768, [(10, 'ssh://repex1.tacc.utexas.edu/')])
# 
# perf (    0,  [(1, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    1,  [(1, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    2,  [(1, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    4,  [(1, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    8,  [(1, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   16,  [(1, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   32,  [(1, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   64,  [(1, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  128,  [(1, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  256,  [(1, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  512,  [(1, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 1024,  [(1, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 2048,  [(1, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 4096,  [(1, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 8192,  [(1, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (16384,  [(1, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (32768,  [(1, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    0,  [(2, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    1,  [(2, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    2,  [(2, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    4,  [(2, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    8,  [(2, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   16,  [(2, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   32,  [(2, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   64,  [(2, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  128,  [(2, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  256,  [(2, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  512,  [(2, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 1024,  [(2, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 2048,  [(2, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 4096,  [(2, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 8192,  [(2, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (16384,  [(2, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (32768,  [(2, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    0,  [(3, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    1,  [(3, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    2,  [(3, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    4,  [(3, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    8,  [(3, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   16,  [(3, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   32,  [(3, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   64,  [(3, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  128,  [(3, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  256,  [(3, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  512,  [(3, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 1024,  [(3, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 2048,  [(3, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 4096,  [(3, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 8192,  [(3, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (16384,  [(3, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (32768,  [(3, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    0,  [(4, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    1,  [(4, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    2,  [(4, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    4,  [(4, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    8,  [(4, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   16,  [(4, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   32,  [(4, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   64,  [(4, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  128,  [(4, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  256,  [(4, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  512,  [(4, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 1024,  [(4, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 2048,  [(4, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 4096,  [(4, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 8192,  [(4, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (16384,  [(4, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (32768,  [(4, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    0,  [(5, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    1,  [(5, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    2,  [(5, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    4,  [(5, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    8,  [(5, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   16,  [(5, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   32,  [(5, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   64,  [(5, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  128,  [(5, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  256,  [(5, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  512,  [(5, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 1024,  [(5, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 2048,  [(5, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 4096,  [(5, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 8192,  [(5, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (16384,  [(5, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (32768,  [(5, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    0,  [(6, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    1,  [(6, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    2,  [(6, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    4,  [(6, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    8,  [(6, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   16,  [(6, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   32,  [(6, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   64,  [(6, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  128,  [(6, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  256,  [(6, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  512,  [(6, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 1024,  [(6, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 2048,  [(6, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 4096,  [(6, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 8192,  [(6, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (16384,  [(6, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (32768,  [(6, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    0,  [(7, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    1,  [(7, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    2,  [(7, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    4,  [(7, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    8,  [(7, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   16,  [(7, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   32,  [(7, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   64,  [(7, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  128,  [(7, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  256,  [(7, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  512,  [(7, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 1024,  [(7, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 2048,  [(7, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 4096,  [(7, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 8192,  [(7, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (16384,  [(7, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (32768,  [(7, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    0,  [(8, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    1,  [(8, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    2,  [(8, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    4,  [(8, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    8,  [(8, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   16,  [(8, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   32,  [(8, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   64,  [(8, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  128,  [(8, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  256,  [(8, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  512,  [(8, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 1024,  [(8, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 2048,  [(8, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 4096,  [(8, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 8192,  [(8, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (16384,  [(8, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (32768,  [(8, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    0,  [(9, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    1,  [(9, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    2,  [(9, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    4,  [(9, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    8,  [(9, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   16,  [(9, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   32,  [(9, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   64,  [(9, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  128,  [(9, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  256,  [(9, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  512,  [(9, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 1024,  [(9, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 2048,  [(9, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 4096,  [(9, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 8192,  [(9, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (16384,  [(9, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (32768,  [(9, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    0, [(10, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    1, [(10, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    2, [(10, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    4, [(10, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (    8, [(10, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   16, [(10, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   32, [(10, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (   64, [(10, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  128, [(10, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  256, [(10, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (  512, [(10, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 1024, [(10, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 2048, [(10, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 4096, [(10, 'gsissh://ranger.tacc.utexas.edu/')])
# perf ( 8192, [(10, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (16384, [(10, 'gsissh://ranger.tacc.utexas.edu/')])
# perf (32768, [(10, 'gsissh://ranger.tacc.utexas.edu/')])




