#!/usr/local/bin/python
#
# Copyright (c) 2002 Neil Blakey-Milner
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#

import unittest

# sibling import 
import config
import agentparsing

BROWSERS = [
    ("Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1", "IE6", "Windows XP"),
    ("Mozilla/5.0 (compatible; Konqueror/3; FreeBSD)", "Konqueror", "FreeBSD"),
    ("Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1) Opera 7.11  [en]", "Opera", "Windows XP"),
]

class BrowserTestCase(unittest.TestCase):
    def testOnlyOne(self):
        error_message = ""
        for browser in BROWSERS:
            found = []
            P = agentparsing.buildDictionary([browser[0]], config.BROWSERS)
            for k, v in P.items():
                if v:
                    found.append(k)
                if v > 1:
                    error_message = error_message + "\nFound more than once - %s made %s be found %d times" % (browser[0], k, v)
                
            if len(found) > 1:
                error_message = error_message + "\nFound more than one browser - %s found these browsers: %s" % (browser[0], str(found))

        if len(error_message):
            self.fail(error_message)

    def testExpected(self):
        error_message = ""
        for browser in BROWSERS:
            found = []
            P = agentparsing.buildDictionary([browser[0]], config.BROWSERS)
            if not P.has_key(browser[1]):
                error_message = error_message + "\nDid not find expected browser: %s should have found %s" % (browser[0], browser[1])
                continue

            if not P[browser[1]]:
                error_message = error_message + "\nDid not find expected browser: %s should have found %s" % (browser[0], browser[1])

        if len(error_message):
            self.fail(error_message)

class PlatformTestCase(unittest.TestCase):
    def testOnlyOne(self):
        error_message = ""
        for browser in BROWSERS:
            found = []
            P = agentparsing.buildDictionary([browser[0]], config.PLATFORMS)
            for k, v in P.items():
                if v:
                    found.append(k)
                if v > 1:
                    error_message = error_message + "\nFound more this OS more than once - %s made %s be found %d times" % (browser[0], k, v)
                
            if len(found) > 1:
                error_message = error_message + "\nFound more than one OS - %s found these browsers: %s" % (browser[0], str(found))

        if len(error_message):
            self.fail(error_message)

    def testExpected(self):
        error_message = ""
        for browser in BROWSERS:
            found = []
            P = agentparsing.buildDictionary([browser[0]], config.PLATFORMS)
            if not P.has_key(browser[2]):
                error_message = error_message + "\nDid not find expected platform: %s should have found %s" % (browser[0], browser[1])
                continue

            if not P[browser[2]]:
                error_message = error_message + "\nDid not find expected platform: %s should have found %s" % (browser[0], browser[1])

        if len(error_message):
            self.fail(error_message)

if __name__ == '__main__':
    unittest.main()

