# Minor release to list

**Subject**: [ANN] Spyder 4.1.1 is released!


Hi all,

On the behalf of the [Spyder Project Contributors](https://github.com/spyder-ide/spyder/graphs/contributors),
I'm pleased to announce that Spyder **4.1.1** has been released and is available for
Windows, GNU/Linux and MacOS X: https://github.com/spyder-ide/spyder/releases

This release comes three days after version 4.1.1 and it contains the
following new features and important fixes:

- New features
  * Add file path completions to the Editor. This works by writing the
    beginning of a file path, either absolute or relative, inside a
    string and pressing `Tab` or `Ctrl+Space`.
  * Add a new command line option called `--report-segfault` to be
    able to send segmentation fault reports to Github.

- Important fixes
  * Fix a critical error when starting kernels on Windows.
  * Update Jedi to 0.15.2.
  * Add conda activation scripts for the kernel to the package.

In this release we fixed 6 issues and merged 8 pull requests that amount
to more than 40 commits. For a full list of fixes, please see our
[Changelog](https://github.com/spyder-ide/spyder/blob/4.x/CHANGELOG.md).

Don't forget to follow Spyder updates/news on the project's
[website](https://www.spyder-ide.org).

Last, but not least, we welcome any contribution that helps making Spyder an
efficient scientific development and computing environment. Join us to help
creating your favorite environment!

Enjoy!
Carlos


----


# Major release to list

**Subject**: [ANN] Spyder 4.0 is released!


Hi all,

On the behalf of the [Spyder Project Contributors](https://github.com/spyder-ide/spyder/graphs/contributors),
I'm pleased to announce that Spyder **4.0** has been released and is available for
Windows, GNU/Linux and MacOS X: https://github.com/spyder-ide/spyder/releases

This release represents more than three years of development since version 3.0 was
released, and it introduces major enhancements and new features. The most important ones
are:

- Main Window
    * Dark theme for the entire application.
    * A new Plots pane to browse all inline figures generated by the
      IPython console.
    * Rename the following panes:
        - `Static code analysis` to `Code Analysis`
        - `File explorer` to `Files`
        - `Find in files` to `Find`
        - `History log` to `History`
        - `Project explorer` to `Project`
    * Create a separate window when undocking all panes.
    * Show current conda environment (if any) in the status bar.

- Editor
    * Code folding.
    * Indentation guides.
    * A class/method/function lookup panel. This can be shown in the menu
      `Source > Show selector for classes and functions`.
    * Autosave functionality to recover unsaved files after a crash.
    * Optional integration with the [Kite](https://kite.com/) completion
      engine.
    * Code completion and linting are provided by the Python Language Server.

- IPython Console
    * Run files in an empty namespace.
    * Open dedicated consoles for Pylab, Sympy and Cython.
    * Run cells through a new function called `runcell`.
    * Run cells by name.

- Debugger
    * Code completion.
    * Execute multi-line statements.
    * Syntax highlighting.
    * Permanent history.
    * `runfile` and `runcell` can be called when the debugger is active.
    * Debug cells with `Alt+Shift+Return`.

- Variable Explorer
    * New viewer to inspect any Python object in a tree-like representation.
    * Filter variables by name or type.
    * MultiIndex support in the Dataframe viewer.
    * Support for all Pandas indexes.
    * Support for sets.
    * Support for Numpy object arrays.
    * Restore the ability to refresh it while code is being executed.

- Files
    * Associate external applications to open specific file extensions.
    * Context menu action to open files externally.
    * Multi-select functionality with `Ctrl/Shift + mouse click`.
    * Copy/paste files and their absolute or relative paths.
    * Use special icons for different file types.

- Outline
    * Show cells grouped in sections.
    * Add default name to all cells.

For a complete list of changes, please see our
[changelog](https://github.com/spyder-ide/spyder/blob/4.x/CHANGELOG.md)

Spyder 3.0 has been a huge success (being downloaded more than 2.5 million times in
2018 alone!) and we hope 4.0 will be as successful. For that we fixed 502 bugs,
merged 741 pull requests from about 60 authors and added more than 5000 commits
between these two releases.

Don't forget to follow Spyder updates/news on the project's
[website](https://www.spyder-ide.org).

Last, but not least, we welcome any contribution that helps making Spyder an
efficient scientific development/computing environment. Join us to help creating
your favorite environment!

Enjoy!
-Carlos


----


# Major release to others

**Note**: Leave this free of Markdown because it could go to mailing lists that
don't support hmtl.

**Subject**: [ANN] Spyder 4.0 is released!


Hi all,

On the behalf of the Spyder Project Contributors (https://github.com/spyder-ide/spyder/graphs/contributors),
I'm pleased to announce that Spyder 3.0 has been released and is available for
Windows, GNU/Linux and MacOS X: https://github.com/spyder-ide/spyder/releases

Spyder is a free, open-source (MIT license) interactive development environment
for the Python language with advanced editing, interactive testing, debugging
and introspection features. It was designed to provide MATLAB-like features
(integrated help, interactive console, variable explorer with GUI-based editors
for NumPy arrays and Pandas dataframes), it is strongly oriented towards
scientific computing and software development.

<The rest is the same as for the list>


----


# Beta release

**Subject**: [ANN] Spyder 4.0 third release candidate


Hi all,

On the behalf of the [Spyder Project Contributors](https://github.com/spyder-ide/spyder/graphs/contributors),
I'm pleased to announce the third release candidate of our next major version: Spyder **4.0**.

We've been working on this version for more than three years now and as far as we know
it's working very well. There are still several bugs to squash but we encourage all
people who like the bleeding edge to give it a try. This beta version is released
one week after Spyder 4.0 rc2 and it includes more than 130 commits.

Spyder 4.0 comes with several interesting and exciting new features. The most
important ones are:

- Main Window
    * Dark theme for the entire application.
    * A new Plots pane to browse all inline figures generated by the
      IPython console.
    * Rename the following panes:
        - `Static code analysis` to `Code Analysis`
        - `File explorer` to `Files`
        - `Find in files` to `Find`
        - `History log` to `History`
        - `Project explorer` to `Project`
    * Create a separate window when undocking all panes.
    * Show current conda environment (if any) in the status bar.

- Editor
    * Code folding.
    * Indentation guides.
    * A class/method/function lookup panel. This can be shown in the menu
      `Source > Show selector for classes and functions`.
    * Autosave functionality to recover unsaved files after a crash.
    * Optional integration with the [Kite](https://kite.com/) completion
      engine.
    * Code completion and linting are provided by the Python Language Server.

- IPython Console
    * Run files in an empty namespace.
    * Open dedicated consoles for Pylab, Sympy and Cython.
    * Run cells through a new function called `runcell`.
    * Run cells by name.

- Debugger
    * Code completion.
    * Execute multi-line statements.
    * Syntax highlighting.
    * Permanent history.
    * `runfile` and `runcell` can be called when the debugger is active.
    * Debug cells with `Alt+Shift+Return`.

- Variable Explorer
    * New viewer to inspect any Python object in a tree-like representation.
    * Filter variables by name or type.
    * MultiIndex support in the Dataframe viewer.
    * Support for all Pandas indexes.
    * Support for sets.
    * Support for Numpy object arrays.
    * Restore the ability to refresh it while code is being executed.

- Files
    * Associate external applications to open specific file extensions.
    * Context menu action to open files externally.
    * Multi-select functionality with `Ctrl/Shift + mouse click`.
    * Copy/paste files and their absolute or relative paths.
    * Use special icons for different file types.

- Outline
    * Show cells grouped in sections.
    * Add default name to all cells.


For a more complete list of changes, please see our
[changelog](https://github.com/spyder-ide/spyder/wiki/Beta-version-changelog)

You can easily install this beta if you use Anaconda by running:

    conda update qt pyqt
    conda install -c spyder-ide spyder=4.0.0rc3

Or you can use pip with this command:

    pip install --pre -U spyder


Enjoy!
Carlos
