// Copyright 2019 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Defines the tfx_bsl extension module. We aim at having only one
// extension module (i.e. dynamic shared library), therefore all the TFX BSL
// C++ APIs must be added here.
// This C++ object has exception (-fexception) enabled (to work with
// pybind11). -fexception may harm performance and increase the binary size,
// therefore do not put any non-trivial logic here.
#include <memory>
#include <stdexcept>

#include "tfx_bsl/cc/arrow/arrow_submodule.h"
#include "tfx_bsl/cc/coders/coders_submodule.h"
#include "tfx_bsl/cc/sketches/sketches_submodule.h"
#include "include/pybind11/pybind11.h"

#ifndef TFX_BSL_USE_ARROW_C_ABI
#include "arrow/python/pyarrow.h"
#endif

namespace tfx_bsl {
namespace {
void MaybeImportPyarrow() {
#ifndef TFX_BSL_USE_ARROW_C_ABI
  arrow::py::import_pyarrow();
#endif
}
}  // namespace

PYBIND11_MODULE(
    tfx_bsl_extension,  // this must be kept the same as the "extension_name"
                           // param in the build rule
    m) {
  m.doc() = "TFX Basic Shared Libraries extension module";
  MaybeImportPyarrow();
  DefineArrowSubmodule(m);
  DefineCodersSubmodule(m);
  DefineSketchesSubmodule(m);
}

}  // namespace tfx_bsl
