/***************************************************************************
  qgswidgetstatehelper_p.cpp - QgsWidgetStateHelper

 ---------------------
 begin                : 3.12.2017
 copyright            : (C) 2017 by Nathan Woodrow
 Email                : woodrow.nathan at gmail dot com
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "qgswidgetstatehelper_p.h"
#include <QWidget>
#include <QEvent>
#include <QObject>
#include "qgsguiutils.h"
#include "qgslogger.h"

QgsWidgetStateHelper::QgsWidgetStateHelper( QObject *parent ) : QObject( parent )
{

}

bool QgsWidgetStateHelper::eventFilter( QObject *object, QEvent *event )
{
  if ( event->type() == QEvent::Close || event->type() == QEvent::Destroy )
  {
    QString key = mKeys[object->objectName()];
    QWidget *widget = qobject_cast<QWidget *>( object );
    QgsGuiUtils::saveGeometry( widget, key );
  }
  else if ( event->type() == QEvent::Show )
  {
    QString key = mKeys[object->objectName()];
    QWidget *widget = qobject_cast<QWidget *>( object );
    QgsGuiUtils::restoreGeometry( widget, key );
  }
  return QObject::eventFilter( object, event );
}

void QgsWidgetStateHelper::registerWidget( QWidget *widget, const QString &key )
{
  Q_ASSERT( !widget->objectName().isEmpty() );
  mKeys[widget->objectName()] = key;
  widget->installEventFilter( this );
}
