SET LANGUAGE us_english;  -- avoid month day swap in datetime

DROP TABLE IF EXISTS qgis_test.[someData];
GO

DROP TABLE IF EXISTS qgis_test.[some_poly_data];
GO

DROP TABLE IF EXISTS qgis_test.[date_times];
GO

DROP TABLE IF EXISTS qgis_test.[new_table];
GO

DROP TABLE IF EXISTS qgis_test.[new_table_multipoint];
GO

DROP TABLE IF EXISTS qgis_test.[invalid_polys];
GO

DROP TABLE IF EXISTS qgis_test.[new_table_multipolygon];
GO

DROP TABLE IF EXISTS qgis_test.[float_dec];
GO

DROP TABLE IF EXISTS qgis_test.[multiGeomColumns];
GO

DROP TABLE IF EXISTS qgis_test.[sacrificialLamb];
GO

DROP TABLE IF EXISTS qgis_test.[someDataCompound];
GO

DROP TABLE IF EXISTS qgis_test.[tb_test_compound_pk];
GO

DROP TABLE IF EXISTS qgis_test.[tb_test_composite_float_pk];
GO

DROP TABLE IF EXISTS qgis_test.[constraints];
GO

DROP SCHEMA qgis_test;
GO

CREATE SCHEMA qgis_test;
GO

CREATE TABLE qgis_test.[someData] (
    pk integer PRIMARY KEY,
    cnt integer,
    name nvarchar(max) DEFAULT 'qgis',
    name2 nvarchar(max) DEFAULT 'qgis',
    num_char nvarchar(max),
    dt datetime,
    [date] date,
    [time] time,
    geom geometry
);
GO

CREATE TABLE qgis_test.[some_poly_data] (
    pk integer PRIMARY KEY,
    geom geometry
);
GO

CREATE TABLE qgis_test.[date_times] (
       id integer PRIMARY KEY,
       date_field date,
       time_field time,
       datetime_field datetime
);
GO

CREATE TABLE qgis_test.[float_dec] (
       id integer PRIMARY KEY,
       float_field float,
       dec_field decimal(7,3)
);
GO

CREATE TABLE qgis_test.[multiGeomColumns] (
    pk integer PRIMARY KEY,
    geom1 geometry,
    geom2 geometry
);
GO

CREATE TABLE qgis_test.[sacrificialLamb] (
    pk integer PRIMARY KEY
);
GO

INSERT INTO qgis_test.[someData] (pk, cnt, name, name2, num_char, dt, [date], [time], geom) VALUES
(5, -200, NULL, 'NuLl', '5', '2020-05-04 12:13:14', '2020-05-02', '12:13:01', geometry::STGeomFromText( 'Point(-71.123 78.23)', 4326 )),
(3,  300, 'Pear', 'PEaR', '3', NULL, NULL, NULL, NULL),
(1,  100, 'Orange', 'oranGe', '1', '2020-05-03 12:13:14', '2020-05-03', '12:13:14', geometry::STGeomFromText( 'Point(-70.332 66.33)', 4326 )),
(2,  200, 'Apple', 'Apple', '2', '2020-05-04 12:14:14', '2020-05-04', '12:14:14', geometry::STGeomFromText( 'Point(-68.2 70.8)', 4326 )),
(4,  400, 'Honey', 'Honey', '4', '2021-05-04 13:13:14', '2021-05-04', '13:13:14', geometry::STGeomFromText( 'Point(-65.32 78.3)', 4326 ))
;
GO

INSERT INTO qgis_test.[some_poly_data] (pk, geom) VALUES
(1, geometry::STGeomFromText('Polygon ((-69.0 81.4, -69.0 80.2, -73.7 80.2, -73.7 76.3, -74.9 76.3, -74.9 81.4, -69.0 81.4))', 4326 )),
(2, geometry::STGeomFromText('Polygon ((-67.6 81.2, -66.3 81.2, -66.3 76.9, -67.6 76.9, -67.6 81.2))', 4326 )),
(3, geometry::STGeomFromText('Polygon ((-68.4 75.8, -67.5 72.6, -68.6 73.7, -70.2 72.9, -68.4 75.8))', 4326 )),
(4, NULL)
;
GO

INSERT INTO qgis_test.[date_times] (id, date_field, time_field, datetime_field ) VALUES
 (1, '2004-03-04', '13:41:52', '2004-03-04 13:41:52' );

INSERT INTO qgis_test.[float_dec] (id, float_field, dec_field ) VALUES
 (1, 1.1111111111, 1.123 );
GO

INSERT INTO qgis_test.[sacrificialLamb] (pk) VALUES
 (1);
GO

INSERT INTO qgis_test.[multiGeomColumns] (pk, geom1, geom2) VALUES
(5, geometry::STGeomFromText( 'Point( 1 2 )', 4326 ), NULL),
(3, NULL, geometry::STGeomFromText( 'LineString( 1 2, 3 4 )', 4326 )),
(1, geometry::STGeomFromText( 'Point( 2 3 )', 4326 ), geometry::STGeomFromText( 'LineString( 2 3, 4 5 )', 4326 )),
(2, geometry::STGeomFromText( 'Point( 3 4 )', 4326 ), geometry::STGeomFromText( 'LineString( 3 4, 5 6 )', 4326 )),
(4, geometry::STGeomFromText( 'Point( 5 6 )', 4326 ), geometry::STGeomFromText( 'LineString( 5 6, 7 8 )', 4326 ))
;
GO

/** Contains invalid polygons **/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [qgis_test].[invalid_polys](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[ogr_geometry] [geometry] NULL,
 CONSTRAINT [PK_invalid_parcels] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
SET IDENTITY_INSERT [qgis_test].[invalid_polys] ON 

GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (258348, 0x47100000010408000000DC293B02AABE654008C8480AADC144C05C395D11AABE6540D81F66D1A9C144C0CC35D9FAAABE654050DD9A16AAC144C0ECCDD77BADBE6540506342CCA5C144C0E04E1598ADBE65402071DEEBA3C144C0B4DF72A6ADBE6540C8D4A2ADA6C144C088403273AABE6540982A29C1ACC144C0DC293B02AABE654008C8480AADC144C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (1528836, 0x4710000001001000000074C8AF1AB9BE6540581FB97CFEC044C0381C2E23B9BE6540C8788F91FEC044C0582BE746B9BE654030831B3DFFC044C0281F717EB9BE6540A0DFEBFCFFC044C058C8128CB9BE6540686A1E2F00C144C034FF507FB9BE6540D881240000C144C004DAC298B9BE6540484FCF5D00C144C0846AC076B9BE654010E836F502C144C05CB8077CB9BE654008FA501103C144C0D07A3596B9BE6540F8FDA78A05C144C00CB48933B9BE6540F8555E9706C144C08C6D52D1B8BE65407010F7A207C144C0B0DE03CFB8BE654048AD41A907C144C0A0C97789B7BE654090F0A0200BC144C06845E570B7BE654000DD860703C144C074C8AF1AB9BE6540581FB97CFEC044C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (1528864, 0x47100000010016000000DCFADC15B9BE6540D0386351FEC044C0F4C5FCE1B9BE65406083B93BFDC044C0DCBD37E1B9BE654010BBAA44FDC044C0B80970DAB9BE654098B5BE8FFDC044C048AD4ED3B9BE654030D28BDAFDC044C0F4A0F7CBB9BE6540F06C3425FEC044C0184CB2C4B9BE654088890170FEC044C0C44D57C1B9BE65405016AD92FEC044C048C950BAB9BE6540008F9CDDFEC044C0C8444AB3B9BE654098AB6928FFC044C03C985EACB9BE654020A67D73FFC044C00CBCB1A5B9BE6540A8A091BEFFC044C03C474C9FB9BE65402079EC0900C144C0B4E96399B9BE65405055905500C144C004DAC298B9BE6540484FCF5D00C144C034FF507FB9BE6540D881240000C144C058C8128CB9BE6540686A1E2F00C144C0281F717EB9BE6540A0DFEBFCFFC044C0582BE746B9BE654030831B3DFFC044C0381C2E23B9BE6540C8788F91FEC044C074C8AF1AB9BE6540581FB97CFEC044C0DCFADC15B9BE6540D0386351FEC044C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705263, 0x47100000010405000000988FB5D0DFBE6540284A2C3D9BC044C01CA53ED5E0BE654088FFC34999C044C05CEBA9DAE0BE6540C0D2596399C044C06C4C20D6DFBE6540889B9D569BC044C0988FB5D0DFBE6540284A2C3D9BC044C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705291, 0x4710000001040F000000548E7F55E4BE6540A829FDE264C144C020EEEA55E4BE654028F86D8871C144C070CF4E61E0BE65409052B34E6FC144C00037E6D0DDBE654010EECEDA6DC144C058433DD8DDBE6540588467E461C144C0FCF0EFDDDDBE654030241BA058C144C0309882DFDDBE6540A878C83956C144C0F458F6CEDFBE6540C8D7603F56C144C0A8B79AD0DFBE654070DC1DAA4DC144C0F82C3767E0BE654090203F624EC144C0180D0C65E0BE654058CC74545AC144C058868263E0BE65401045E86A62C144C07461495EE2BE65402873F84662C144C0EC955B55E4BE6540D8475D2162C144C0548E7F55E4BE6540A829FDE264C144C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705302, 0x4710000001040900000010EDCBE8A3BE6540805302A927C144C0580016A3A5BE6540901E865627C144C0B4D187CEA5BE6540C0887D0228C144C0C89F9B42A6BE654068C5E8CD29C144C080E158C1A6BE654040C967C32BC144C01CEA0F7EA6BE6540C0E44B4A2FC144C004B6EFF6A5BE654048B19EB82EC144C0FCDDFE06A4BE65401878556A2DC144C010EDCBE8A3BE6540805302A927C144C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705306, 0x47100000010448000000205727BDD8BE6540282FE3BA2AC144C078126CB7D8BE6540906E3AB82AC144C0C4D6C79ED8BE654028322EAD2AC144C004733E86D8BE6540487ABDA02AC144C0B472D476D8BE654018DF17972AC144C0C8969B5ED8BE6540D805C1852AC144C048B38646D8BE654088F12E722AC144C0C03E952ED8BE6540D8BD5A5D2AC144C0E0BF5B1BD8BE654088C31C4E2AC144C0D4FC4F03D8BE6540684F1F3A2AC144C0C83F70EBD7BE6540183ABB242AC144C010BCC6D3D7BE6540E8A1600D2AC144C0385776BCD7BE6540E06E5FF329C144C00010CEACD7BE654068DCF1DF29C144C0D8BA1E96D7BE6540D8092FC129C144C09415A57FD7BE6540F839E3A029C144C03CB13D69D7BE6540582CE57F29C144C0B0B33F55D7BE65408898A66329C144C06C0EC63ED7BE6540804A7F4329C144C014AA5E28D7BE6540E876EA2229C144C040941112D7BE65408009810129C144C018BD5301D7BE65405058A4E728C144C09C7745EBD6BE6540B049D4C428C144C0107349D5D6BE65406037BBA128C144C00C4E44BFD6BE6540D04AA47E28C144C084E25FB5D6BE65408050666F28C144C0884E379FD6BE65408023264D28C144C090511789D6BE654080F6E52A28C144C0A0EBFF72D6BE6540D0C55C0828C144C0B49DC370D6BE654070A5480528C144C02450F059D6BE6540583568E527C144C03C7BB543D6BE6540388A4CC327C144C084B6042FD6BE6540989ABF9A27C144C0E8DA3526D6BE6540B0C5848427C144C0B8BAA014D6BE6540F843894F27C144C074931804D6BE654040C0E91627C144C078D210F5D5BE6540409522E526C144C08453E2E4D5BE6540B0B117AC26C144C0282B93D5D5BE65401071187126C144C00C5DD7CFD5BE654090DC065A26C144C018E5A6C1D5BE654048B9A51C26C144C0CCEB3AB4D5BE6540983C99DD25C144C03C2A55A7D5BE6540A0FC6C9D25C144C08887C89AD5BE654000DBB05C25C144C040A35693D5BE6540A08D5C3725C144C0FC89CA86D5BE6540006CA0F624C144C0A4B77C7AD5BE6540706C9DB524C144C0B0464A6ED5BE6540F08E537424C144C040243262D5BE6540982FE53224C144C08CC58D60D5BE6540B891C82A24C144C028136053D5BE654098D3C0EA23C144C0BC322146D5BE65409071DBAA23C144C0B4503239D5BE6540A853686A23C144C0D49EED2CD5BE654040D2402923C144C06C5CB521D5BE654060D5B4E622C144C0E4F0D017D5BE654058597BA222C144C02C4A2717D5BE6540005A4E9D22C144C04815020FD5BE654000FFFB5622C144C0BC681608D5BE654018FFF90E22C144C0C47B0102D5BE6540606523C621C144C08CC672FCD4BE6540D86BE17C21C144C0E039B2F7D4BE6540201E8E5021C144C090C463F0D4BE654078A6700721C144C02C9725EBD4BE654030872CBE20C144C0E8C7ADE9D4BE6540E02D7F7420C144C0F8F690EBD4BE6540A863F54420C144C0140D52F0D4BE6540682C01FB1FC144C0B8C6495CD5BE654070ABD6781FC144C0880AE2F7D7BE6540B05CCA541CC144C07C14BF73D9BE654078A1BE071DC144C0A0DF41FDD8BE6540A073B7EB25C144C0205727BDD8BE6540282FE3BA2AC144C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705315, 0x47100000010419000000487D59DA89BE654040E9B520EEC044C0281CA90D8ABE6540A8BC5642F7C044C038ACA92C8ABE6540F805AFEEFCC044C0F0AB353E8ABE654018A358B5FEC044C08CC80B448ABE6540C879104CFFC044C03CF6B3588ABE6540804EAD6301C144C0D87EB9B68ABE6540308C43E90AC144C0587FA2B78ABE6540C864C7FF0AC144C088231C6E88BE654060AED46C0BC144C0940FF34588BE654068E960B60AC144C0C056091687BE654050EBDBEE0AC144C000FCDA9A87BE654038573E1209C144C07472497F86BE6540C8A194FC07C144C0E45F22E383BE6540B0E5DF7808C144C0B0F089D083BE6540803E208904C144C080E9B46E83BE6540A0D2329904C144C050060A6683BE65403854F8D802C144C0CCFE226383BE654070211E4202C144C010B0935083BE6540B01FB883FEC044C0B436323483BE654000BB3ACAF8C044C054BFDF2383BE6540B0D705CDF8C044C088A574F582BE6540D848D469EFC044C03CBA1E4087BE6540282D019DEEC044C0B4A84F7287BE6540D0138093EEC044C0487D59DA89BE654040E9B520EEC044C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705332, 0x47100000010406000000E8F5CC37A7BE654030325C78B9C044C05C36EC57A7BE654058863D8FBFC044C0E81432F7A3BE6540F8354D30C0C044C0E85D13D7A3BE6540D0E16B19BAC044C0DC006C40A4BE654080CDD905BAC044C0E8F5CC37A7BE654030325C78B9C044C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705349, 0x47100000010410000000789F99168BBE6540E02BBAF59AC044C0601BB4018FBE6540B06763809FC044C0C489F9038FBE654000F0F4EF9FC044C064D2D2218FBE6540581FF997A5C044C07C4706198EBE6540F0422EC9A5C044C0682515DC8BBE654078510034A6C044C05833897F8ABE654000E13ED09CC044C03877E7958ABE6540A0AD3EAF9CC044C00CD539AB8ABE6540C8E485889CC044C08CAA52BF8ABE6540E818575C9CC044C028120FD28ABE65407873FD2A9CC044C098004AE38ABE6540782EE2F49BC044C0C819E1F28ABE6540B8A970BA9BC044C06852AF008BBE6540C06A167C9BC044C0707CA30C8BBE6540B0075F3A9BC044C0789F99168BBE6540E02BBAF59AC044C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705382, 0x471000000104080000004076830DB4BE654028525040C9C044C064CB8A92B4BE6540780069A4CAC044C0984121A7B4BE6540A84A0C16CFC044C034C5DFA0B4BE6540086A4E17CFC044C00C36BFABAFBE654018D0FF03D0C044C0A4D57F8CAFBE6540F0C45617CAC044C0008569CEB0BE6540F06415DBC9C044C04076830DB4BE654028525040C9C044C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705449, 0x47100000010407000000E860C03CBBBE6540C037A39F96C044C0BC794F8ABBBE6540E8515D6592C044C00428EFDEBFBE654028AB443495C044C0340F6091BFBE654060AFFA6D99C044C09CC76130BFBE654030D2D0AE9EC044C0344408D4BABE6540B05CCA549CC044C0E860C03CBBBE6540C037A39F96C044C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705451, 0x4710000001040C000000387DD57BAEBE6540C82479675AC044C03CD7EAB7AEBE654080DCD4F95DC044C08CF85BF6ACBE6540A09740005FC044C07477AA37ABBE654098D3FE0460C044C074DB2A2DA8BE6540A0026CAF61C044C0E0B3380DA8BE6540E053568C60C044C0503B57EFABBE65405802846A5EC044C0CC683283ABBE6540787BC67457C044C07457CD78ADBE6540F8FA98B156C044C0B45BAD0EAEBE6540E879707756C044C0A8F4C53EAEBE654050A3906456C044C0387DD57BAEBE6540C82479675AC044C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705469, 0x4710000001040A000000D4940964DBBE654010B3DC4148C144C0D0CB2896DBBE654098B03B7F48C144C010B9B18ADBBE654078CCF6D761C144C000C8EBBCDBBE6540108CCDD861C144C058433DD8DDBE6540588467E461C144C00037E6D0DDBE654010EECEDA6DC144C094048A53DBBE654038FDEABB6CC144C020AA7758DBBE6540E80C20D761C144C07832B159DBBE654020435B295FC144C0D4940964DBBE654010B3DC4148C144C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705540, 0x4710000001041700000008453064DEBE6540704057CA0EC144C0608216BCDFBE6540A8AF3D6C0FC144C05CEF2AB0DFBE6540E8DC864E18C144C00461C5AEDFBE6540403CF58F18C144C0BC8A4FABDFBE6540D85DB1D018C144C0008DD2A5DFBE654040DE061019C144C0B8A8609EDFBE654078DFAE4D19C144C0E8740295DFBE6540F8A1D28819C144C0F852D389DFBE6540F0C506C119C144C0F470E47CDFBE654090EBDFF519C144C02471636EDFBE654020D5AB261AC144C0A4186A5EDFBE654008DB43531AC144C0D0C8134DDFBE6540100BFA7A1AC144C000BB963ADFBE6540D897A59D1AC144C0B8D41527DFBE65405847DDBA1AC144C0E8C5C612DFBE654078BD7ED21AC144C05879C5FDDEBE6540A8741CE41AC144C08C4358E8DEBE6540F86CB6EF1AC144C0EC859AD2DEBE6540404A2AF51AC144C04431D4BCDEBE6540800C78F41AC144C090B428A7DEBE6540E8317BED1AC144C0FC62F3C7DDBE654060247B841AC144C008453064DEBE6540704057CA0EC144C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705563, 0x47100000010407000000B412A91FAABE6540F094698FF2C044C020F4119DAABE6540A8A1BE79F2C044C0FC874F95AABE6540F099CF00F1C044C068A96164AEBE6540C0317C58F0C044C06C95421BAEBE6540282A0F63F6C044C0849E1738AABE6540C0031434F7C044C0B412A91FAABE6540F094698FF2C044C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705569, 0x47100000010407000000E4A388B69ABE654018DD35796EC144C0A8A89FDC9BBE654058C50A6D6FC144C0A4ED6C839BBE6540606CBA9B70C144C05C0EF4509BBE654008B3CB1570C144C094CB17659ABE654020C6B5EB6FC144C094910E6A9ABE6540A866C06D6EC144C0E4A388B69ABE654018DD35796EC144C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705589, 0x471000000104050000002C87AEF589BE6540D02039F769C044C0B430B0338ABE6540C02055B975C044C088C606178ABE654028CEEA1A76C044C0607722D789BE6540305ACFFC69C044C02C87AEF589BE6540D02039F769C044C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705609, 0x471000000104070000006893B6FD8ABE6540C0BDDC6EDCC044C03C5B333E8BBE6540186354AAE8C044C068605D758ABE65405032CDCFE8C044C03410638389BE6540D819F5FCE8C044C0D868EF4289BE654070185BC1DCC044C09898E0348ABE6540F88C5594DCC044C06893B6FD8ABE6540C0BDDC6EDCC044C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705614, 0x47100000010407000000B0211AD8B8BE6540C850C60C55C044C074BCB843B9BE654078F481424FC044C0147BC3D8BDBE6540D8F3953D52C044C0D46137CCBDBE6540B040EFEB52C044C08C18946EBDBE654048937A0558C044C0AC735655B9BE654080E4DB5D55C044C0B0211AD8B8BE6540C850C60C55C044C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705618, 0x4710000001040500000078B1231A9CBE654038EF5A9D77C144C02897C62F9CBE6540B0B0ACD677C144C028EB74769BBE6540F896664B7AC144C06430725B9ABE654058F2CE5A77C144C078B1231A9CBE654038EF5A9D77C144C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705633, 0x4710000001041000000064AF6A558ABE654050DECC8A96C044C0807676E88ABE65400053F5E18FC044C06C02B1118DBE65408066DC768FC044C064B682AB8EBE6540F02FBB278FC044C0241A0CC48EBE6540E81D13CE93C044C0909962138BBE65409829087998C044C02CEE32088BBE6540D06E4A3298C044C048EDEAFA8ABE6540780E0AEF97C044C064E5A4EB8ABE6540E80FD9AF97C044C000257BDA8ABE6540602BFC7497C044C0684E9BC78ABE654050C4273F97C044C09CD028B38ABE654070DEA40E97C044C0805B599D8ABE6540B89123E496C044C078E750868ABE6540C885CABF96C044C0009B446E8ABE6540D072DEA196C044C064AF6A558ABE654050DECC8A96C044C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705638, 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
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705672, 0x47100000010409000000A8C4DD6F90BE65402898CAD819C144C050B6813B90BE6540E82B4DEC0FC144C0B46E0ACB92BE6540E06AF8710FC144C060B5CAFD92BE6540B0CF52680FC144C0E853BA0093BE6540C0A954F80FC144C0C4B6FB0B93BE654088D5241A12C144C02CB82C1A93BE65402001F9CB14C144C06484C43193BE6540901D605519C144C0A8C4DD6F90BE65402898CAD819C144C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705674, 0x471000000104050000007C749C3BA7BE6540C084311F59C044C0CC683283ABBE6540787BC67457C044C0503B57EFABBE65405802846A5EC044C0E0B3380DA8BE6540E053568C60C044C07C749C3BA7BE6540C084311F59C044C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705686, 0x47100000010404000000605F909990BE654028A996BE21C144C0048EBA8C91BE654070C8124524C144C0D088A6A790BE65404071B66F24C144C0605F909990BE654028A996BE21C144C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705690, 0x471000000104090000009004865195BE6540F811696214C144C034C9416995BE6540785089EB18C144C0A4075C5C95BE654090AD7DED18C144C0A8D03C2A95BE6540F8E8B7F618C144C06484C43193BE6540901D605519C144C02CB82C1A93BE65402001F9CB14C144C024AB4E1395BE6540208C276E14C144C020E26D4595BE6540A0F4CA6414C144C09004865195BE6540F811696214C144C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705802, 0x4710000001040A000000D83E7C4AF2BE6540C06E11186BC144C09095B6BDEFBE6540D89DF3F56AC144C0CC823FB2EFBE6540D009DF9D6AC144C028CE8EAAEFBE6540A01704426AC144C000B59F2CEFBE6540788DBD1467C144C080B5882DEFBE654050E433ED63C144C090C48E70F1BE654038D5660B64C144C0DC457A4CF2BE6540B04BDC1664C144C028E7D54AF2BE654088B356126BC144C0D83E7C4AF2BE6540C06E11186BC144C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705826, 0x471000000104090000005412E631CBBE65404875EB4961C144C06CFB2B1FCABE6540E060B43669C144C06C51FE9FC7BE6540E8190CBF65C144C0C41E8C38CABE6540B8D90EFC5EC144C0045F2C67CABE6540F856F07D5FC144C0E43E8397CABE6540F0BCF4F95FC144C074E675C9CABE654010C0177060C144C0C014F2FCCABE6540082A39E060C144C05412E631CBBE65404875EB4961C144C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705832, 0x471000000104120000003479D794CCBE6540C0FCBF315EC144C000C063D8CEBE6540B010C24854C144C090F1DA05D0BE6540C0327B4854C144C058140E6ECFBE6540C85B09385FC144C0F88AAB20CFBE6540186C7E575FC144C074BC9AEDCEBE65405845D5685FC144C0805E5DBACEBE654038FC73735FC144C02408FC86CEBE654030DC5E775FC144C0C8B19A53CEBE6540A83D6F745FC144C05C335420CEBE65405024EE6A5FC144C064443AEDCDBE654090E8B45A5FC144C0B06671BACDBE6540F0D5C7435FC144C0DCA70188CDBE6540B82247265FC144C050000F56CDBE6540B8F434025FC144C0F4B0AB24CDBE6540C8CDB5D75EC144C0C091F2F3CCBE65404006A3A65EC144C0BCD0F4C3CCBE6540E8A1456F5EC144C03479D794CCBE6540C0FCBF315EC144C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705835, 0x47100000010416000000FC5573C5A4BE6540C82EC25B7AC144C040E4E3C9A4BE6540988E2D5C7AC144C05C34AEC9A4BE654000E65F6D7AC144C0C86BCABAA4BE6540A05BED037EC144C0ACE6EF94A4BE6540F0F1AE1F87C144C01CE25C199DBE6540E87B5C0786C144C0444E15429DBE6540E0C25F387CC144C0F4AB2C169EBE654038F58D577CC144C0B8748F169EBE6540C89BB7427CC144C0C019941A9EBE654058FACB4C7BC144C0F40AED979DBE65407087EDF179C144C0205D4E049FBE6540786FA01B75C144C0BCBA0CFAA0BE6540509765527AC144C080836FFAA0BE654010DE233D7AC144C0EC0DAD04A1BE654010B69AD377C144C084F2881BA1BE654068B4F5D677C144C0607DA4D7A2BE6540702F5D1978C144C04C17FA11A3BE654018034BAB6AC144C0BC5E0206A5BE65405000D6F46AC144C05C21B9F0A4BE6540881DE8FC6FC144C0FC7C87E7A4BE6540081C53C172C144C0FC5573C5A4BE6540C82EC25B7AC144C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705839, 0x471000000104070000006C4D5F749EBE65405847E92DF9C044C0A4911DBB9EBE654088E0694607C144C0E4C09EBB9CBE6540202DC2A507C144C0B4D2E1779CBE6540E070E19EF9C044C0E0DB6D779CBE654008D8B38CF9C044C06CF4D6659DBE6540382E3E60F9C044C06C4D5F749EBE65405847E92DF9C044C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705852, 0x47100000010406000000C0E6CEAC92BE6540B8C788FA93C044C01CAF33CA92BE6540407F468E99C044C078BF65A990BE6540708EEBF399C044C02CD828E68EBE65409864CE479AC044C0CC0FC4C88EBE6540382BECB394C044C0C0E6CEAC92BE6540B8C788FA93C044C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705886, 0x4710000001040600000034B8A003EABE654018698C1D67C044C01802CAF0E9BE654098AA9EE063C044C0682325DDE9BE65402819EF7D60C044C03C771618EDBE6540F08D10D45FC044C080FAC270EDBE6540F004566966C044C034B8A003EABE654018698C1D67C044C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705887, 0x4710000001040600000024B12BCDC0BE654058ACF70749C044C078EFA831C1BE654060B1374548C044C05812F75DC3BE6540F83CC4AE49C044C04CA8E0F0C2BE654098C575A04FC044C0A894E876C0BE654020F69DBA4DC044C024B12BCDC0BE654058ACF70749C044C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705892, 0x471000000104090000004CAE55C7C9BE6540507A7F866EC144C09C96F035C8BE654040B950406DC144C0CC00AF80C6BE65408055DF0D6AC144C0C4511041C7BE654070DE82B666C144C06C51FE9FC7BE6540E8190CBF65C144C06CFB2B1FCABE6540E060B43669C144C05412E631CBBE65404875EB4961C144C09C4B7E7FCBBE654028CE9BD461C144C04CAE55C7C9BE6540507A7F866EC144C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705902, 0x47100000010409000000281E06A9CABE654090D96567ADC144C0882146C3CABE6540003BE826B2C144C018D52FCCCABE6540086BFCBFB3C144C0C459D4D1C8BE6540B8FBC61EB4C144C0B45DFCC8C8BE654000C86985B2C144C0788A66AFC8BE654068E80BC6ADC144C0A4A14621C9BE6540F054CCB0ADC144C010520141CABE6540E0EDF77AADC144C0281E06A9CABE654090D96567ADC144C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705915, 0x47100000010425000000743A4266D4BE6540C8D8BAE82CC144C0ACFFDB7BD4BE6540C00429092DC144C0EC5B7E91D4BE6540805699292DC144C04C99C7A6D4BE6540B0236E4B2DC144C064BF93BBD4BE654088D3A46F2DC144C0280C14C2D4BE6540502FF37B2DC144C0E8A9A6D5D4BE6540B0969BA52DC144C0F4A08FE8D4BE654058C235D22DC144C038CF15FBD4BE6540204BC4002EC144C0106E6F0DD5BE6540A01105302EC144C0D44DDB1FD5BE654030FAFE5E2EC144C0BCFD1020D5BE6540F8596A5F2EC144C06824BB32D5BE6540D8266B8D2EC144C094027745D5BE6540306EFEBA2EC144C01CB17158D5BE6540F0F5BAE72EC144C07CE7BC6BD5BE65406080EE122FC144C034215278D5BE654008957F2D2FC144C0AC5F628CD5BE654000A37C552FC144C08074DDA0D5BE6540F8AFA77B2FC144C010BBB2B5D5BE6540E8BB00A02FC144C00800D8CAD5BE6540604CF5C22FC144C05C153CE0D5BE6540B897A5E42FC144C0E06428E2D5BE6540403695E72FC144C044397AF7D5BE654060A7470930C144C078670B0DD6BE654018F9B72930C144C0A89BC822D6BE6540A0A9C14830C144C0B8DAB634D6BE6540683B5C6130C144C03020C54AD6BE6540E8EA937E30C144C018F5FF60D6BE6540D0A08B9A30C144C078EA4377D6BE654020D115B630C144C0A0C10188D6BE6540E026A3CA30C144C0B8CAAB24D6BE65400038FBA533C144C0A056693CD5BE6540F0851F553AC144C0706A6396D4BE6540A8AB478939C144C0D4CE876CD2BE6540187CE42032C144C09CB3D601D4BE6540703216F22DC144C0743A4266D4BE6540C8D8BAE82CC144C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
INSERT [qgis_test].[invalid_polys] ([id], [ogr_geometry]) VALUES (3705938, 0x47100000010405000000748C75BBA8BE654098EF25FCAEC044C010A90134AEBE6540D816E36BABC044C0E4B4B40EAFBE65405095162BB3C044C0709E8FD7A8BE654048E5924FB4C044C0748C75BBA8BE654098EF25FCAEC044C001000000020000000002000000FFFFFFFF0000000006000000000000000003)
GO
SET IDENTITY_INSERT [qgis_test].[invalid_polys] OFF
GO

-- Provider check with compound key

CREATE TABLE [qgis_test].[someDataCompound] (
    pk integer NOT NULL,
    cnt integer,
    name nvarchar(max) DEFAULT 'qgis',
    name2 nvarchar(max) DEFAULT 'qgis',
    num_char nvarchar(max),
    dt datetime,
    "date" date,
    "time" time,
    geom geometry,
    key1 integer,
    key2 integer,
    PRIMARY KEY(key1, key2)
);

INSERT INTO [qgis_test].[someDataCompound] ( key1, key2, pk, cnt, name, name2, num_char, dt, "date", "time", geom) VALUES
(1, 1, 5, -200, NULL, 'NuLl', '5', '2020-05-04 12:13:14', '2020-05-02', '12:13:01', geometry::STGeomFromText('POINT(-71.123 78.23)', 4326)),
(1, 2, 3,  300, 'Pear', 'PEaR', '3', NULL, NULL, NULL, NULL),
(2, 1, 1,  100, 'Orange', 'oranGe', '1', '2020-05-03 12:13:14', '2020-05-03', '12:13:14', geometry::STGeomFromText('POINT(-70.332 66.33)', 4326)),
(2, 2, 2,  200, 'Apple', 'Apple', '2', '2020-05-04 12:14:14', '2020-05-04', '12:14:14', geometry::STGeomFromText('POINT(-68.2 70.8)', 4326)),
(2, 3, 4,  400, 'Honey', 'Honey', '4', '2021-05-04 13:13:14', '2021-05-04', '13:13:14', geometry::STGeomFromText('POINT(-65.32 78.3)', 4326));
GO


CREATE TABLE [qgis_test].[tb_test_compound_pk]
(
    pk1 integer,
    pk2 bigint,
    value nvarchar(16),
    geom geometry,
    PRIMARY KEY (pk1, pk2)
);

INSERT INTO [qgis_test].[tb_test_compound_pk] (pk1, pk2, value, geom) VALUES
(1, 1, 'test 1', geometry::STGeomFromText('POINT(-47.930 -15.818)', 4326)),
(1, 2, 'test 2', geometry::STGeomFromText('POINT(-47.887 -15.864)', 4326)),
(2, 1, 'test 3', geometry::STGeomFromText('POINT(-47.902 -15.763)', 4326)),
(2, 2, 'test 4', geometry::STGeomFromText('POINT(-47.952 -15.781)', 4326));
GO

CREATE TABLE [qgis_test].[tb_test_composite_float_pk]
(
    pk1 integer,
    pk2 bigint,
    pk3 real,
    value nvarchar(16),
    geom geometry,
    PRIMARY KEY (pk1, pk2, pk3)
);

INSERT INTO [qgis_test].[tb_test_composite_float_pk] (pk1, pk2, pk3, value, geom) VALUES
    (1, 1, 1.0,         'test 1', geometry::STGeomFromText('POINT(-47.930 -15.818)', 4326)),
    (1, 2, 3.141592741, 'test 2', geometry::STGeomFromText('POINT(-47.887 -15.864)', 4326)),
    (2, 2, 2.718281828, 'test 3', geometry::STGeomFromText('POINT(-47.902 -15.763)', 4326)),
    (2, 2, 1.0,         'test 4', geometry::STGeomFromText('POINT(-47.952 -15.781)', 4326));
GO

-- Table for constraint tests
CREATE TABLE [qgis_test].[constraints]
(
  gid integer PRIMARY KEY,
  val int,
  name text NOT NULL,
  description text
);
GO
