/* -*- mode: c++; indent-tabs-mode: nil -*- */
/** @file XmlReader.qpp defines the XmlReader class */
/*
  QC_XmlReader.qpp

  Qore Programming Language

  Copyright 2003 - 2022 Qore Technologies, s.r.o.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "qore-xml-module.h"

#include "QC_XmlReader.h"
#include "QC_XmlNode.h"
#include "ql_xml.h"
/* Qore class Qore::Xml::XmlReader */

qore_classid_t CID_XMLREADER;
QoreClass* QC_XMLREADER;

// int XmlReader::attributeCount(){}
static QoreValue XmlReader_attributeCount(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 312 "QC_XmlReader.qpp"
    return xr->attributeCount();
}

// *string XmlReader::baseUri(){}
static QoreValue XmlReader_baseUri(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 322 "QC_XmlReader.qpp"
    const char *n = xr->baseUri();
   return n ? new QoreStringNode(n, QCS_UTF8) : 0;
}

// XmlReader::constructor(XmlDoc doc) {}
static void XmlReader_constructor_C6XmlDoc(QoreObject* self, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    HARD_QORE_VALUE_OBJ_DATA(doc, QoreXmlDocData, args, 0, CID_XMLDOC, "XmlReader::constructor()", "XmlDoc", xsink);
    if (*xsink)
        return;
# 43 "QC_XmlReader.qpp"
ReferenceHolder<QoreXmlDocData> doc_holder(doc, xsink);

   SimpleRefHolder<QoreXmlReaderData> xr(new QoreXmlReaderData(doc, xsink));
   if (*xsink)
      return;

   self->setPrivate(CID_XMLREADER, xr.release());
}

// XmlReader::constructor(string xml) {}
static void XmlReader_constructor_Vs(QoreObject* self, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    const QoreStringNode* xml = HARD_QORE_VALUE_STRING(args, 0);
# 60 "QC_XmlReader.qpp"
// FIXME: there is no TempNodeEncodingHelper class :(
    QoreStringNode* xarg;
    if (xml->getEncoding() == QCS_UTF8)
        xarg = xml->stringRefSelf();
    else {
        xarg = xml->convertEncoding(QCS_UTF8, xsink);
        if (!xarg)
            return;
    }

    SimpleRefHolder<QoreXmlReaderData> xr(new QoreXmlReaderData(xarg, QORE_XML_PARSER_OPTIONS, nullptr, xsink));
    if (*xsink)
        return;

    self->setPrivate(CID_XMLREADER, xr.release());
}

// XmlReader::constructor(Qore::InputStream is, *hash opts) {}
static void XmlReader_constructor_C11InputStreamNh(QoreObject* self, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    HARD_QORE_VALUE_OBJ_DATA(is, InputStream, args, 0, CID_INPUTSTREAM, "XmlReader::constructor()", "Qore::InputStream", xsink);
    if (*xsink)
        return;
    const QoreHashNode* opts = get_param_value(args, 1).get<const QoreHashNode>();
# 97 "QC_XmlReader.qpp"
const char* encoding = QoreXmlReaderData::processOptionsGetEncoding(opts, "XML-READER-OPTION-ERROR", xsink);
    if (*xsink)
        return;
    ReferenceHolder<QoreXmlReaderData> xr(new QoreXmlReaderData(is, encoding, QoreXmlReaderData::getOptions(opts), opts, xsink), xsink);
    if (*xsink)
        return;
    self->setPrivate(CID_XMLREADER, xr.release());
    self->setValue("is", static_cast<QoreObject*>(obj_is->refSelf()), xsink);
}

// XmlReader::copy() {}
static void XmlReader_copy(QoreObject* self, QoreObject* old, QoreXmlReaderData* xr, ExceptionSink* xsink) {
# 114 "QC_XmlReader.qpp"
ReferenceHolder<QoreXmlReaderData> doc(xr->copy(xsink), xsink);
    if (!*xsink)
        self->setPrivate(CID_XMLREADER, doc.release());
}

// int XmlReader::depth(){}
static QoreValue XmlReader_depth(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 186 "QC_XmlReader.qpp"
    return xr->depth();
}

// *string XmlReader::encoding(){}
static QoreValue XmlReader_encoding(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 335 "QC_XmlReader.qpp"
    const char *n = xr->encoding();
   return n ? new QoreStringNode(n, QCS_UTF8) : 0;
}

// *string XmlReader::getAttribute(string attr){}
static QoreValue XmlReader_getAttribute_Vs(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    const QoreStringNode* attr = HARD_QORE_VALUE_STRING(args, 0);
# 405 "QC_XmlReader.qpp"
    return xr->getAttribute(attr->getBuffer());
}

// *string XmlReader::getAttributeNs(string attr, string ns){}
static QoreValue XmlReader_getAttributeNs_VsVs(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    const QoreStringNode* attr = HARD_QORE_VALUE_STRING(args, 0);
    const QoreStringNode* ns = HARD_QORE_VALUE_STRING(args, 1);
# 434 "QC_XmlReader.qpp"
    return xr->getAttributeNs(attr->getBuffer(), ns->getBuffer());
}

// *string XmlReader::getAttributeOffset(softint offset = 0){}
static QoreValue XmlReader_getAttributeOffset_vi(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    int64 offset = HARD_QORE_VALUE_INT(args, 0);
# 419 "QC_XmlReader.qpp"
    return xr->getAttributeOffset((int)offset);
}

// *string XmlReader::getInnerXml(){}
static QoreValue XmlReader_getInnerXml(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 579 "QC_XmlReader.qpp"
    return xr->getInnerXml(xsink);
}

// *string XmlReader::getOuterXml(){}
static QoreValue XmlReader_getOuterXml(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 591 "QC_XmlReader.qpp"
    return xr->getOuterXml(xsink);
}

// bool XmlReader::hasAttributes(){}
static QoreValue XmlReader_hasAttributes(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 220 "QC_XmlReader.qpp"
    return xr->hasAttributes();
}

// bool XmlReader::hasValue(){}
static QoreValue XmlReader_hasValue(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 230 "QC_XmlReader.qpp"
    return xr->hasValue();
}

// bool XmlReader::isDefault(){}
static QoreValue XmlReader_isDefault(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 240 "QC_XmlReader.qpp"
    return xr->isDefault();
}

// bool XmlReader::isEmptyElement(){}
static QoreValue XmlReader_isEmptyElement(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 250 "QC_XmlReader.qpp"
    return xr->isEmptyElement();
}

// bool XmlReader::isNamespaceDecl(){}
static QoreValue XmlReader_isNamespaceDecl(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 260 "QC_XmlReader.qpp"
    return xr->isNamespaceDecl();
}

// bool XmlReader::isValid(){}
static QoreValue XmlReader_isValid(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 270 "QC_XmlReader.qpp"
    return xr->isValid();
}

// *string XmlReader::localName(){}
static QoreValue XmlReader_localName(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 346 "QC_XmlReader.qpp"
    const char *n = xr->localName();
   return n ? new QoreStringNode(n, QCS_UTF8) : 0;
}

// *string XmlReader::lookupNamespace(){}
static QoreValue XmlReader_lookupNamespace(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 444 "QC_XmlReader.qpp"
    return xr->lookupNamespace(0);
}

// *string XmlReader::lookupNamespace(string prefix){}
static QoreValue XmlReader_lookupNamespace_Vs(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    const QoreStringNode* prefix = HARD_QORE_VALUE_STRING(args, 0);
# 456 "QC_XmlReader.qpp"
    return xr->lookupNamespace(prefix->getBuffer());
}

// bool XmlReader::moveToAttribute(string attr){}
static QoreValue XmlReader_moveToAttribute_Vs(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    const QoreStringNode* attr = HARD_QORE_VALUE_STRING(args, 0);
# 474 "QC_XmlReader.qpp"
    return xr->moveToAttribute(attr->getBuffer(), xsink);
}

// bool XmlReader::moveToAttributeNs(string attr, string ns){}
static QoreValue XmlReader_moveToAttributeNs_VsVs(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    const QoreStringNode* attr = HARD_QORE_VALUE_STRING(args, 0);
    const QoreStringNode* ns = HARD_QORE_VALUE_STRING(args, 1);
# 511 "QC_XmlReader.qpp"
    return xr->moveToAttributeNs(attr->getBuffer(), ns->getBuffer(), xsink);
}

// bool XmlReader::moveToAttributeOffset(softint offset){}
static QoreValue XmlReader_moveToAttributeOffset_vi(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    int64 offset = HARD_QORE_VALUE_INT(args, 0);
# 492 "QC_XmlReader.qpp"
    return xr->moveToAttributeOffset((int)offset, xsink);
}

// bool XmlReader::moveToElement(){}
static QoreValue XmlReader_moveToElement(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 525 "QC_XmlReader.qpp"
    return xr->moveToElement(xsink);
}

// bool XmlReader::moveToFirstAttribute(){}
static QoreValue XmlReader_moveToFirstAttribute(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 539 "QC_XmlReader.qpp"
    return xr->moveToFirstAttribute(xsink);
}

// bool XmlReader::moveToNextAttribute(){}
static QoreValue XmlReader_moveToNextAttribute(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 553 "QC_XmlReader.qpp"
    return xr->moveToNextAttribute(xsink);
}

// *string XmlReader::name(){}
static QoreValue XmlReader_name(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 198 "QC_XmlReader.qpp"
    const char *n = xr->constName();
   return n ? new QoreStringNode(n, QCS_UTF8) : 0;
}

// *string XmlReader::namespaceUri(){}
static QoreValue XmlReader_namespaceUri(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 357 "QC_XmlReader.qpp"
    const char *n = xr->namespaceUri();
   return n ? new QoreStringNode(n, QCS_UTF8) : 0;
}

// bool XmlReader::next(){}
static QoreValue XmlReader_next(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 567 "QC_XmlReader.qpp"
    return xr->next(xsink);
}

// int XmlReader::nodeType(){}
static QoreValue XmlReader_nodeType(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 163 "QC_XmlReader.qpp"
    return xr->nodeType();
}

// *string XmlReader::nodeTypeName(){}
static QoreValue XmlReader_nodeTypeName(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 175 "QC_XmlReader.qpp"
    const char *n = get_xml_node_type_name(xr->nodeType());
   return n ? new QoreStringNode(n) : 0;
}

// *string XmlReader::prefix(){}
static QoreValue XmlReader_prefix(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 368 "QC_XmlReader.qpp"
    const char *n = xr->prefix();
   return n ? new QoreStringNode(n, QCS_UTF8) : 0;
}

// bool XmlReader::read(){}
static QoreValue XmlReader_read(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 133 "QC_XmlReader.qpp"
    return (bool)xr->read(xsink);
}

// bool XmlReader::readSkipWhitespace(){}
static QoreValue XmlReader_readSkipWhitespace(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 150 "QC_XmlReader.qpp"
    return (bool)xr->readSkipWhitespace(xsink);
}

// nothing XmlReader::relaxNGValidate(string relaxng){}
static QoreValue XmlReader_relaxNGValidate_Vs(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    const QoreStringNode* relaxng = HARD_QORE_VALUE_STRING(args, 0);
# 608 "QC_XmlReader.qpp"
    #ifdef HAVE_XMLTEXTREADERRELAXNGSETSCHEMA
   xr->relaxNGValidate(relaxng->getBuffer(), xsink);
#else
   xsink->raiseException("MISSING-FEATURE-ERROR", "the libxml2 version used to compile the qore library did not support the xmlTextReaderRelaxNGValidate() function, therefore XmlReader::relaxNGValidate() is not available in Qore; for maximum portability, use the constant Option::HAVE_PARSEXMLWITHRELAXNG to check if this method is implemented before calling");
#endif
   return 0;
}

// nothing XmlReader::schemaValidate(string xsd){}
static QoreValue XmlReader_schemaValidate_Vs(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    const QoreStringNode* xsd = HARD_QORE_VALUE_STRING(args, 0);
# 630 "QC_XmlReader.qpp"
    #ifdef HAVE_XMLTEXTREADERSETSCHEMA
   xr->schemaValidate(xsd->getBuffer(), xsink);
#else
   xsink->raiseException("MISSING-FEATURE-ERROR", "the libxml2 version used to compile the qore library did not support the xmlTextReaderSchemaValidate() function, therefore XmlReader::schemaValidate() is not available in Qore; for maximum portability, use the constant Option::HAVE_PARSEXMLWITHSCHEMA to check if this method is implemented before calling");
#endif
   return 0;
}

// any XmlReader::toQore(int pflags = XPF_PRESERVE_ORDER){}
static QoreValue XmlReader_toQore_Vi(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    int64 pflags = HARD_QORE_VALUE_INT(args, 0);
# 286 "QC_XmlReader.qpp"
    return xr->parseXmlData(QCS_UTF8, pflags, xsink);
}

// any XmlReader::toQoreData(*int pflags){}
static QoreValue XmlReader_toQoreData_Ni(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    int64 pflags = HARD_QORE_VALUE_INT(args, 0);
# 302 "QC_XmlReader.qpp"
    return xr->parseXmlData(QCS_UTF8, pflags, xsink);
}

// *string XmlReader::value(){}
static QoreValue XmlReader_value(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 209 "QC_XmlReader.qpp"
    const char *n = xr->constValue();
   return n ? new QoreStringNode(n, QCS_UTF8) : 0;
}

// *string XmlReader::xmlLang(){}
static QoreValue XmlReader_xmlLang(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 379 "QC_XmlReader.qpp"
    const char *n = xr->xmlLang();
   return n ? new QoreStringNode(n, QCS_UTF8) : 0;
}

// *string XmlReader::xmlVersion(){}
static QoreValue XmlReader_xmlVersion(QoreObject* self, QoreXmlReaderData* xr, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 390 "QC_XmlReader.qpp"
    const char *n = xr->xmlVersion();
   return n ? new QoreStringNode(n, QCS_UTF8) : 0;
}

DLLLOCAL void preinitXmlReaderClass() {
    QC_XMLREADER = new QoreClass("XmlReader", "::Qore::Xml::XmlReader", QDOM_DEFAULT);
    CID_XMLREADER = QC_XMLREADER->getID();
    QC_XMLREADER->setSystem();
}

DLLLOCAL QoreClass* initXmlReaderClass(QoreNamespace& ns) {
    if (!QC_XMLREADER)
        preinitXmlReaderClass();

    // private:internal members
    QC_XMLREADER->addMember("is", Internal, QC_INPUTSTREAM->getTypeInfo());

    // int XmlReader::attributeCount(){}
    QC_XMLREADER->addMethod("attributeCount", (q_method_n_t)XmlReader_attributeCount, Public, QCF_CONSTANT, QDOM_DEFAULT, bigIntTypeInfo);

    // *string XmlReader::baseUri(){}
    QC_XMLREADER->addMethod("baseUri", (q_method_n_t)XmlReader_baseUri, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo);

    // XmlReader::constructor(XmlDoc doc) {}
    QC_XMLREADER->addConstructor(XmlReader_constructor_C6XmlDoc, Public, QCF_NO_FLAGS, QDOM_DEFAULT, 1, QC_XMLDOC->getTypeInfo(), QORE_PARAM_NO_ARG, "doc");

    // XmlReader::constructor(string xml) {}
    QC_XMLREADER->addConstructor(XmlReader_constructor_Vs, Public, QCF_NO_FLAGS, QDOM_DEFAULT, 1, stringTypeInfo, QORE_PARAM_NO_ARG, "xml");

    // XmlReader::constructor(Qore::InputStream is, *hash opts) {}
    QC_XMLREADER->addConstructor(XmlReader_constructor_C11InputStreamNh, Public, QCF_NO_FLAGS, QDOM_DEFAULT, 2, QC_INPUTSTREAM->getTypeInfo(), QORE_PARAM_NO_ARG, "is", hashOrNothingTypeInfo, QORE_PARAM_NO_ARG, "opts");

    // XmlReader::copy() {}
    QC_XMLREADER->setCopy((q_copy_t)XmlReader_copy);

    // int XmlReader::depth(){}
    QC_XMLREADER->addMethod("depth", (q_method_n_t)XmlReader_depth, Public, QCF_CONSTANT, QDOM_DEFAULT, bigIntTypeInfo);

    // *string XmlReader::encoding(){}
    QC_XMLREADER->addMethod("encoding", (q_method_n_t)XmlReader_encoding, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo);

    // *string XmlReader::getAttribute(string attr){}
    QC_XMLREADER->addMethod("getAttribute", (q_method_n_t)XmlReader_getAttribute_Vs, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo, 1, stringTypeInfo, QORE_PARAM_NO_ARG, "attr");

    // *string XmlReader::getAttributeNs(string attr, string ns){}
    QC_XMLREADER->addMethod("getAttributeNs", (q_method_n_t)XmlReader_getAttributeNs_VsVs, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo, 2, stringTypeInfo, QORE_PARAM_NO_ARG, "attr", stringTypeInfo, QORE_PARAM_NO_ARG, "ns");

    // *string XmlReader::getAttributeOffset(softint offset = 0){}
    QC_XMLREADER->addMethod("getAttributeOffset", (q_method_n_t)XmlReader_getAttributeOffset_vi, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo, 1, softBigIntTypeInfo, QoreSimpleValue().assign((int64)0), "offset");

    // *string XmlReader::getInnerXml(){}
    QC_XMLREADER->addMethod("getInnerXml", (q_method_n_t)XmlReader_getInnerXml, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo);

    // *string XmlReader::getOuterXml(){}
    QC_XMLREADER->addMethod("getOuterXml", (q_method_n_t)XmlReader_getOuterXml, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo);

    // bool XmlReader::hasAttributes(){}
    QC_XMLREADER->addMethod("hasAttributes", (q_method_n_t)XmlReader_hasAttributes, Public, QCF_CONSTANT, QDOM_DEFAULT, boolTypeInfo);

    // bool XmlReader::hasValue(){}
    QC_XMLREADER->addMethod("hasValue", (q_method_n_t)XmlReader_hasValue, Public, QCF_CONSTANT, QDOM_DEFAULT, boolTypeInfo);

    // bool XmlReader::isDefault(){}
    QC_XMLREADER->addMethod("isDefault", (q_method_n_t)XmlReader_isDefault, Public, QCF_CONSTANT, QDOM_DEFAULT, boolTypeInfo);

    // bool XmlReader::isEmptyElement(){}
    QC_XMLREADER->addMethod("isEmptyElement", (q_method_n_t)XmlReader_isEmptyElement, Public, QCF_CONSTANT, QDOM_DEFAULT, boolTypeInfo);

    // bool XmlReader::isNamespaceDecl(){}
    QC_XMLREADER->addMethod("isNamespaceDecl", (q_method_n_t)XmlReader_isNamespaceDecl, Public, QCF_CONSTANT, QDOM_DEFAULT, boolTypeInfo);

    // bool XmlReader::isValid(){}
    QC_XMLREADER->addMethod("isValid", (q_method_n_t)XmlReader_isValid, Public, QCF_CONSTANT, QDOM_DEFAULT, boolTypeInfo);

    // *string XmlReader::localName(){}
    QC_XMLREADER->addMethod("localName", (q_method_n_t)XmlReader_localName, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo);

    // *string XmlReader::lookupNamespace(){}
    QC_XMLREADER->addMethod("lookupNamespace", (q_method_n_t)XmlReader_lookupNamespace, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo);

    // *string XmlReader::lookupNamespace(string prefix){}
    QC_XMLREADER->addMethod("lookupNamespace", (q_method_n_t)XmlReader_lookupNamespace_Vs, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo, 1, stringTypeInfo, QORE_PARAM_NO_ARG, "prefix");

    // bool XmlReader::moveToAttribute(string attr){}
    QC_XMLREADER->addMethod("moveToAttribute", (q_method_n_t)XmlReader_moveToAttribute_Vs, Public, QCF_NO_FLAGS, QDOM_DEFAULT, boolTypeInfo, 1, stringTypeInfo, QORE_PARAM_NO_ARG, "attr");

    // bool XmlReader::moveToAttributeNs(string attr, string ns){}
    QC_XMLREADER->addMethod("moveToAttributeNs", (q_method_n_t)XmlReader_moveToAttributeNs_VsVs, Public, QCF_NO_FLAGS, QDOM_DEFAULT, boolTypeInfo, 2, stringTypeInfo, QORE_PARAM_NO_ARG, "attr", stringTypeInfo, QORE_PARAM_NO_ARG, "ns");

    // bool XmlReader::moveToAttributeOffset(softint offset){}
    QC_XMLREADER->addMethod("moveToAttributeOffset", (q_method_n_t)XmlReader_moveToAttributeOffset_vi, Public, QCF_NO_FLAGS, QDOM_DEFAULT, boolTypeInfo, 1, softBigIntTypeInfo, QORE_PARAM_NO_ARG, "offset");

    // bool XmlReader::moveToElement(){}
    QC_XMLREADER->addMethod("moveToElement", (q_method_n_t)XmlReader_moveToElement, Public, QCF_NO_FLAGS, QDOM_DEFAULT, boolTypeInfo);

    // bool XmlReader::moveToFirstAttribute(){}
    QC_XMLREADER->addMethod("moveToFirstAttribute", (q_method_n_t)XmlReader_moveToFirstAttribute, Public, QCF_NO_FLAGS, QDOM_DEFAULT, boolTypeInfo);

    // bool XmlReader::moveToNextAttribute(){}
    QC_XMLREADER->addMethod("moveToNextAttribute", (q_method_n_t)XmlReader_moveToNextAttribute, Public, QCF_NO_FLAGS, QDOM_DEFAULT, boolTypeInfo);

    // *string XmlReader::name(){}
    QC_XMLREADER->addMethod("name", (q_method_n_t)XmlReader_name, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo);

    // *string XmlReader::namespaceUri(){}
    QC_XMLREADER->addMethod("namespaceUri", (q_method_n_t)XmlReader_namespaceUri, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo);

    // bool XmlReader::next(){}
    QC_XMLREADER->addMethod("next", (q_method_n_t)XmlReader_next, Public, QCF_NO_FLAGS, QDOM_DEFAULT, boolTypeInfo);

    // int XmlReader::nodeType(){}
    QC_XMLREADER->addMethod("nodeType", (q_method_n_t)XmlReader_nodeType, Public, QCF_CONSTANT, QDOM_DEFAULT, bigIntTypeInfo);

    // *string XmlReader::nodeTypeName(){}
    QC_XMLREADER->addMethod("nodeTypeName", (q_method_n_t)XmlReader_nodeTypeName, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo);

    // *string XmlReader::prefix(){}
    QC_XMLREADER->addMethod("prefix", (q_method_n_t)XmlReader_prefix, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo);

    // bool XmlReader::read(){}
    QC_XMLREADER->addMethod("read", (q_method_n_t)XmlReader_read, Public, QCF_NO_FLAGS, QDOM_DEFAULT, boolTypeInfo);

    // bool XmlReader::readSkipWhitespace(){}
    QC_XMLREADER->addMethod("readSkipWhitespace", (q_method_n_t)XmlReader_readSkipWhitespace, Public, QCF_NO_FLAGS, QDOM_DEFAULT, boolTypeInfo);

    // nothing XmlReader::relaxNGValidate(string relaxng){}
    QC_XMLREADER->addMethod("relaxNGValidate", (q_method_n_t)XmlReader_relaxNGValidate_Vs, Public, QCF_NO_FLAGS, QDOM_DEFAULT, nothingTypeInfo, 1, stringTypeInfo, QORE_PARAM_NO_ARG, "relaxng");

    // nothing XmlReader::schemaValidate(string xsd){}
    QC_XMLREADER->addMethod("schemaValidate", (q_method_n_t)XmlReader_schemaValidate_Vs, Public, QCF_NO_FLAGS, QDOM_DEFAULT, nothingTypeInfo, 1, stringTypeInfo, QORE_PARAM_NO_ARG, "xsd");

    // any XmlReader::toQore(int pflags = XPF_PRESERVE_ORDER){}
    QC_XMLREADER->addMethod("toQore", (q_method_n_t)XmlReader_toQore_Vi, Public, QCF_RET_VALUE_ONLY, QDOM_DEFAULT, anyTypeInfo, 1, bigIntTypeInfo, QoreSimpleValue().assign((int64)XPF_PRESERVE_ORDER), "pflags");

    // any XmlReader::toQoreData(*int pflags){}
    QC_XMLREADER->addMethod("toQoreData", (q_method_n_t)XmlReader_toQoreData_Ni, Public, QCF_RET_VALUE_ONLY, QDOM_DEFAULT, anyTypeInfo, 1, bigIntOrNothingTypeInfo, QORE_PARAM_NO_ARG, "pflags");

    // *string XmlReader::value(){}
    QC_XMLREADER->addMethod("value", (q_method_n_t)XmlReader_value, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo);

    // *string XmlReader::xmlLang(){}
    QC_XMLREADER->addMethod("xmlLang", (q_method_n_t)XmlReader_xmlLang, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo);

    // *string XmlReader::xmlVersion(){}
    QC_XMLREADER->addMethod("xmlVersion", (q_method_n_t)XmlReader_xmlVersion, Public, QCF_CONSTANT, QDOM_DEFAULT, stringOrNothingTypeInfo);

    return QC_XMLREADER;
}
