/*
 * This file is part of the DOM implementation for KDE.
 *
 * Copyright (C) 2003 Lars Knoll (knoll@kde.org)
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

/* This file is mostly data generated by flex. Unfortunately flex
   can't handle 16bit strings directly, so we just copy the part of
   the code we need and modify it to our needs.

   Most of the defines below are to make sure we can easily use the
   flex generated code, using as little editing as possible.

   The flex syntax to generate the lexer are more or less directly
   copied from the CSS2.1 specs, with some fixes for comments and
   the important symbol.

   To regenerate, run flex on tokenizer.flex. After this, copy the
   data tables and the YY_DECL method over to this file. Remove the
   init code from YY_DECL and change the YY_END_OF_BUFFER to only call
   yyterminate().

*/

// --------- begin generated code -------------------


#include "CSSGrammar.h"

#define INITIAL 0
#define mediaquery 1

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L
#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t;
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */
#define YY_NUM_RULES 57
#define YY_END_OF_BUFFER 58
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[368] =
    {   0,
        0,    0,    0,    0,   58,   56,    2,    2,   56,   56,
       56,   56,   56,   56,   56,   56,   56,   46,   56,   56,
       14,   14,   14,   56,   56,   56,   56,   55,   14,   14,
       14,   54,    2,    0,    0,    0,   13,    0,    0,    0,
       16,   16,    0,    8,    0,    0,    9,    0,   14,    0,
       47,    0,   45,    0,    0,   46,   44,   44,   44,   44,
       44,   44,   44,   44,   44,   44,   44,   41,    0,   44,
        0,    0,    0,    0,    0,    0,    0,    0,   51,   14,
        0,   14,    0,   14,   14,   14,    7,    6,    5,   14,
       14,   14,    0,    0,    0,   13,    0,    0,    0,   16,

       16,    0,   16,   16,    0,    0,   13,    0,    0,    4,
        0,    0,   44,    0,   32,   44,   28,   30,   44,   42,
       34,   44,   33,   40,   36,   35,   31,   44,   44,   44,
       44,    0,    0,    0,    0,    0,    0,    0,    0,   14,
       14,   14,   52,   52,   14,   14,   12,   10,   14,    0,
        0,    0,   15,   15,   16,   16,   16,    0,    0,    0,
        1,   44,   44,   37,   44,   43,   38,   44,   44,    3,
        0,    0,    0,    0,    0,    0,    0,   14,   48,    0,
       52,   52,   52,   51,   14,   11,    0,    0,    0,   16,
       16,   16,    0,    0,    0,   44,   39,   44,   44,    0,

        0,    0,    0,    0,    0,   18,   14,   53,   52,   52,
       52,   52,    0,    0,    0,    0,   50,    0,   14,    0,
        0,    0,   16,   16,   16,    0,   44,   44,   29,    0,
        0,    0,    0,   19,    0,   14,   53,   52,   52,   52,
       52,   52,    0,    0,    0,    0,    0,    0,    0,    0,
        0,   50,    0,    0,   14,    0,    0,   15,   15,   16,
       16,    0,   44,   44,    0,    0,    0,   17,    0,   14,
       53,   52,   52,   52,   52,   52,   52,    0,   49,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
       14,    0,    0,   16,   16,    0,   44,   44,    0,   21,

        0,    0,   14,   53,   52,   52,   52,   52,   52,   52,
       52,    0,   49,    0,    0,    0,   49,    0,    0,    0,
        0,   16,   44,    0,    0,    0,   53,    0,    0,    0,
       27,    0,    0,    0,    0,   20,   22,   53,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,   23,    0,   24,    0,
       25,    0,    0,    0,    0,   26,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    4,    5,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    6,    7,    8,    9,   10,   11,   12,   13,   14,
       15,   16,   17,   12,   18,   19,   20,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   12,   22,   23,
       24,   25,   26,   27,   28,   29,   30,   31,   32,   33,
       34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
       44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
       12,   54,   12,   55,   56,   12,   57,   58,   59,   60,

       61,   62,   63,   64,   65,   37,   66,   67,   68,   69,
       70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
       80,   81,   82,   83,   12,   84,    1,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,

       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85,   85,   85,   85,   85,   85,
       85,   85,   85,   85,   85
    } ;

static yyconst flex_int32_t yy_meta[86] =
    {   0,
        1,    2,    3,    3,    3,    4,    4,    4,    4,    4,
        4,    4,    4,    5,    4,    4,    4,    6,    4,    4,
        7,    4,    4,    4,    4,    8,    4,    9,    9,    9,
        9,    9,    9,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,    4,   10,    9,    9,    9,    9,
        9,    9,   10,   10,   10,   10,   10,   10,   10,   10,
       10,   10,   10,   10,   10,   10,   10,   10,   10,   10,
       10,    4,    4,    4,   10
    } ;

static yyconst flex_int16_t yy_base[414] =
    {   0,
        0,    0,   64,   66,  899, 4700,   93,   98,  107,   83,
      155,  873,   74,  872,   71,  874,  878,  207,  886,  275,
       76,  100,  102,  326,  868,  866,  864, 4700,  108,  110,
      112, 4700,  155,  197,   77,   85, 4700,  387,   97,    0,
      429,  833,  471, 4700,  114,  532, 4700,  861,  115,  574,
      119,  867,  860,  626,  849,    0,  814,  125,  135,  249,
      137,  141,  109,  157,  255,  291,  170,  805,  680,  150,
      840,  241,  155,  252,  256,  173,  269,  270, 4700,  117,
      722,  285,  830,  339,  276,  783, 4700, 4700, 4700,  317,
      321,  355,  270,  359,  166,  298,  844,  905,    0,  800,

      947,  989,  797, 1050,  307,  320,  350, 1111, 1172, 4700,
      819,  356,  780, 1214,  778,  347,  755,  746,  345,  745,
      711,  326,  707,  669,  649,  629,  614,  351,  599, 1275,
      370,  633,  275,  369,  359,  360,  367,  372,  389,  311,
     1336,  411,  205,  604,  415, 1378,  416,  418,  425,  393,
      413, 1420,    0, 1462,  554, 1523, 1565,  420, 1607,  560,
     4700,  520, 1668,  504,  422,  503,  502, 1710,  419, 4700,
      408,  391,  396,  414,  432,  446,  449, 1752, 4700,    0,
      286,  518,  516,  512, 1794,  440,  440, 1836,    0, 1878,
     1920, 1962, 2004,  459,  418, 2046,  401, 2088,  455,  455,

      450,  346,  453,  483,  473, 4700, 2130,    0,  520,  325,
      323,  288,  565,  609,  498,  495, 4700, 2191, 2252,  475,
     2313,    0, 2374, 2416, 2458, 2500, 2542, 2584,  248,  476,
      511,  515,  504, 4700,  511, 2626,    0,  557,  206,  204,
      203,  182,  594,  531,  623, 2687,  588, 2748,  712,  754,
      815,  876, 2809, 2870, 2931,  527, 2992, 4700, 3034, 3076,
     3118, 3160, 3202, 3244,  512,  541,  553, 4700,  592, 3286,
        0,  622,  181,  171,  129,  118,  115,  673, 4700,  651,
      613,  916, 3347, 3408,  652,  626,  937, 3469, 3530, 3591,
     3633,  577,  768, 3675, 3717, 3759, 3801, 3843,  114, 4700,

      593,  611,  726,    0,  102, 4700, 4700, 4700, 4700, 4700,
     4700,  943,  642,  665, 3885,  979,  630,  668, 3927, 3969,
      627,  742,  788, 1027,  663,  672,    0, 4011, 4053, 4095,
     4700,  675,  702,  645,  707, 4700, 4700, 4700, 4137, 4179,
     4221,  719,  746,  659,  729, 4263, 4305, 4347,  736,  759,
      766,  753,  858, 1010,  759,  774, 4700,  775, 4700,  766,
     4700,  777,  794,  794,  805, 4700, 4700, 4408, 4413, 4422,
     4427, 4433, 4440, 4449, 4453, 4457, 4464, 4473, 4483, 4488,
     4495, 4502, 4506, 4509, 4515, 4525, 4532, 4537, 4540, 4549,
     4553, 4557, 4565, 4569, 4578, 4582, 4586, 4594, 4603, 4612,

     4621, 4625, 4628, 4632, 4640, 4649, 4658, 4667, 4671, 4675,
     4683, 4687, 4690
    } ;

static yyconst flex_int16_t yy_def[414] =
    {   0,
      367,    1,    1,    1,  367,  367,  367,  367,  367,  368,
      369,  367,  370,  367,  371,  367,  367,  367,  367,  367,
      372,  372,  372,  373,  367,  367,  367,  367,  372,  372,
      372,  367,  367,  367,  367,  368,  367,  374,  369,  375,
      376,  376,  377,  367,  370,  378,  367,  367,  372,  373,
       18,  379,  367,   18,  367,   18,  380,  380,  380,  380,
      380,  380,  380,  380,  380,  380,  380,  380,  381,  380,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  372,
      382,  372,  383,  372,  372,  372,  367,  367,  367,  372,
      372,  372,  367,  368,  368,  368,  368,  374,  384,  376,

      376,  385,  376,  101,  370,  370,  370,  370,  378,  367,
      379,  386,  380,  387,  380,  380,  380,  380,  380,  380,
      380,  380,  380,  380,  380,  380,  380,  380,  380,  380,
      380,  367,  367,  367,  367,  367,  367,  367,  367,  372,
       86,  372,  388,  367,  372,   86,  372,  372,  372,  367,
      368,   97,  389,  101,  376,  101,  104,  370,  108,  390,
      367,  380,  130,  380,  380,  380,  380,  130,  380,  367,
      367,  367,  367,  367,  367,  367,  367,  141,  367,  391,
      392,  367,  367,  393,   86,  372,  367,   97,  394,  101,
      156,  104,  108,  390,  395,  163,  380,  130,  380,  367,

      367,  367,  367,  367,  367,  367,  141,  396,  397,  367,
      367,  367,  393,  393,  398,  399,  367,  400,  141,  367,
      401,  402,  104,  156,  104,  108,  163,  130,  380,  367,
      367,  367,  367,  367,  367,  141,  403,  404,  367,  367,
      367,  367,  367,  398,  367,  405,  399,  406,  393,  393,
      393,  393,  393,  407,  141,  367,  408,  367,  223,  224,
      104,  108,  163,  130,  367,  367,  367,  367,  367,  141,
      409,  410,  367,  367,  367,  367,  367,  367,  367,  398,
      398,  398,  398,  405,  399,  399,  399,  399,  411,  393,
      255,  367,  408,  260,  104,  108,  163,  130,  367,  367,

      367,  367,  291,  412,  367,  367,  367,  367,  367,  367,
      367,  398,  398,  398,  283,  399,  399,  399,  288,  290,
      367,  295,  298,  367,  367,  367,  413,  283,  288,  290,
      367,  367,  367,  367,  367,  367,  367,  367,  283,  288,
      290,  367,  367,  367,  367,  283,  288,  290,  367,  367,
      367,  367,  398,  399,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,    0,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,

      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367
    } ;

static yyconst flex_int16_t yy_nxt[4786] =
    {   0,
        6,    7,    8,    7,    7,    7,    9,   10,   11,   12,
        6,    6,   13,    6,    6,   14,    6,   15,   16,   17,
       18,    6,   19,    6,    6,    6,   20,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   21,   21,
       22,   21,   21,   21,   21,   21,   21,   23,   21,   21,
       21,   21,   21,   24,   25,   21,   21,   21,   21,   21,
       21,   21,   21,   21,   21,   21,   21,   21,   22,   21,
       21,   21,   21,   21,   21,   23,   21,   21,   21,   21,
       21,    6,   26,   27,   21,   28,   37,   28,   48,   79,
       37,   29,   37,   29,   33,   33,   33,   33,   33,   33,

       33,   33,   33,   33,   30,   31,   30,   31,   34,   34,
       34,   34,   34,   79,  367,   79,   93,  367,   83,  180,
       29,   79,   29,   79,   50,   79,   37,   46,   79,   81,
       79,  324,   30,   31,   30,   31,   38,  367,   38,   51,
      311,   82,   35,  310,   93,   32,   84,   32,   90,  121,
       43,   91,   92,   81,  309,   81,   33,   33,   33,   33,
       33,   81,  114,   81,  115,   81,  116,   46,   81,   82,
       81,   35,   39,   37,   84,   40,   90,  121,  114,   91,
       92,  119,   41,   41,   41,   41,   41,   41,  114,  134,
      114,  122,  115,  120,  114,  116,  308,  128,   34,   34,

       34,   34,   34,  114,  137,  131,  307,  277,   43,  119,
      114,   41,   41,   41,   41,   41,   41,   53,  134,   38,
      122,  120,  180,  114,   54,   55,  128,   56,  276,  275,
      182,  274,   35,  137,   57,   57,   58,   59,   60,   57,
       61,   62,   63,   57,   64,   57,   65,   57,   57,   66,
       57,   67,   68,   57,   57,   57,   57,   57,   57,   57,
       69,   35,   70,   57,   57,   58,   59,   60,   57,   61,
       62,   63,   64,   57,   65,   57,   57,   66,   57,   67,
       68,   57,   57,   57,   57,   57,   57,   57,  117,   79,
      133,   57,   72,  135,  123,  136,  138,  139,   79,  118,

      124,  114,  114,  180,   73,   37,  171,   74,  114,   45,
       75,  210,  150,  242,   76,   77,  117,   78,  133,   37,
      125,  135,  123,  136,   79,  138,  139,  118,  124,   81,
       79,  142,   37,   73,   79,  171,   74,  126,   81,   75,
      150,  127,   76,   77,  114,   78,   86,  147,  241,  125,
      240,   38,   79,   86,   86,   86,   86,   86,   86,  142,
       46,   36,   37,  232,   81,  126,   37,  148,   79,  127,
       81,  112,  165,   46,   81,  161,  147,  145,  166,  114,
      164,  167,   86,   86,   86,   86,   86,   86,   36,   36,
       36,   94,   81,  149,   96,  148,  172,  175,  114,  173,

      114,  165,  174,   46,  114,  145,  166,   97,   81,  164,
      167,  176,   38,  169,   97,   97,   97,   97,   97,   97,
       37,  149,  177,  114,  179,  172,  175,  173,  184,   79,
      174,  179,   37,  195,  187,  201,  200,  161,   79,  176,
       98,  169,  202,   97,   97,   97,   97,   97,   97,  101,
      199,  177,  197,   79,  114,  203,  101,  101,  101,  101,
      101,  101,  187,  201,   81,  200,   38,  204,   81,   81,
      202,   81,  114,   46,  195,  114,  186,  205,   81,  199,
      206,  197,  102,  203,  220,  101,  101,  101,  101,  101,
      101,  104,  230,   81,  229,  231,  204,  233,  104,  104,

      104,  104,  104,  104,  186,  245,  205,  245,  114,  206,
      234,  265,  220,  213,  213,  213,  213,  213,  235,  215,
      230,  256,  229,  231,  216,  233,  217,  104,  104,  104,
      104,  104,  104,   45,   45,   45,  105,  180,  245,  234,
      265,  212,  266,  211,  107,  239,  235,  267,  248,  256,
      268,  246,  108,  269,  292,  114,  114,  114,  299,  108,
      108,  108,  108,  108,  108,  218,  213,  213,  213,  213,
      213,  266,  215,  114,  180,  195,  267,  216,  268,  217,
      301,  269,  273,  292,  246,  109,  299,  300,  108,  108,
      108,  108,  108,  108,   86,  243,  243,  243,  243,  243,

      245,   86,   86,   86,   86,   86,   86,  102,  217,  301,
      243,  243,  243,  243,  243,  300,  367,  321,  218,  302,
      245,  367,  325,  217,  278,  278,  278,  278,  278,  183,
       86,   86,   86,   86,   86,   86,  367,  279,  245,  180,
      326,  248,  245,  367,  367,  321,  367,  306,  302,  245,
      170,  325,  114,  244,  247,   57,   57,   57,  245,   57,
       57,   57,  218,   57,  245,   57,  246,  114,   57,  326,
       57,   57,  245,  331,  278,  278,  278,  278,  278,  248,
      245,   57,  114,  248,   57,   57,   57,  279,   57,   57,
       57,   57,  344,   57,  336,  246,   57,  351,   57,   57,

      130,  331,  114,  337,  246,  248,  342,  130,  130,  130,
      130,  130,  130,  243,  243,  243,  243,  243,  246,  367,
      344,  248,  114,  336,  367,  351,  217,  140,  140,  140,
      140,  140,  337,  343,  345,  342,  130,  130,  130,  130,
      130,  130,  141,  155,  155,  155,  155,  155,  349,  141,
      141,  141,  141,  141,  141,  243,  243,  243,  243,  243,
      114,  367,  343,  345,  114,  218,  367,  352,  217,   95,
      151,  151,  151,   95,  355,   37,  350,  349,  141,  141,
      141,  141,  141,  141,   85,   85,   85,   85,   85,  162,
      162,  162,  162,  162,  356,  352,   79,  357,  114,  114,

      358,  360,  355,  146,  359,  350,  361,  218,  114,  362,
      146,  146,  146,  146,  146,  146,  243,  243,  243,  243,
      243,   38,  367,  356,  363,  364,  357,  367,  358,  217,
      360,  114,  359,  114,  112,  361,   81,  362,  365,  146,
      146,  146,  146,  146,  146,   95,  151,  151,  151,   95,
      102,   37,  363,  102,  364,  144,  366,  132,  114,  281,
      314,  314,  314,  281,  152,  245,  365,  114,  218,   51,
       53,  152,  152,  152,  152,  152,  152,  243,  243,  243,
      243,  243,  112,  367,  366,  110,  102,   89,  367,   88,
      217,   87,   71,   52,   51,   47,   44,   38,  367,  367,

      152,  152,  152,  152,  152,  152,   36,   36,   36,   94,
      367,  246,   96,  367,  367,  367,  367,  312,  278,  278,
      278,  312,  367,  245,  367,   97,  367,  367,  367,  218,
      313,  367,   97,   97,   97,   97,   97,   97,  316,  278,
      278,  278,  316,  367,  312,  278,  278,  278,  312,  245,
      245,  317,  367,  367,  367,  367,  367,  313,   98,  367,
      367,   97,   97,   97,   97,   97,   97,  154,  367,  246,
      367,  367,  367,  367,  154,  154,  154,  154,  154,  154,
      316,  278,  278,  278,  316,  367,  367,  367,  367,  367,
      248,  245,  367,  317,  367,  367,  246,  367,  367,  367,

      102,  367,  367,  154,  154,  154,  154,  154,  154,  156,
      367,  286,  318,  318,  318,  286,  156,  156,  156,  156,
      156,  156,  245,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  248,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  156,  156,  156,  156,  156,
      156,  103,  103,  103,  103,  103,  367,  332,  367,  367,
      367,  367,  367,  248,  367,  367,  333,  367,  367,  367,
      157,  334,  367,  367,  367,  335,  367,  157,  157,  157,
      157,  157,  157,  367,  367,  367,  332,  367,  367,  367,
      367,  367,  367,  367,  333,  367,  367,  367,  367,  334,

      367,  367,  367,  335,  367,  367,  157,  157,  157,  157,
      157,  157,  106,  158,  158,  158,  106,  367,  367,  367,
      367,  367,  367,   37,  367,  367,  367,  367,  367,  367,
      367,  159,  367,  367,  367,  367,  367,  367,  159,  159,
      159,  159,  159,  159,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,   46,  367,  367,  159,  159,  159,
      159,  159,  159,   45,   45,   45,  105,  367,  367,  367,
      367,  367,  367,  367,  107,  367,  367,  367,  367,  367,
      367,  367,  108,  367,  367,  367,  367,  367,  367,  108,

      108,  108,  108,  108,  108,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  109,  367,  367,  108,  108,
      108,  108,  108,  108,  163,  367,  367,  367,  367,  367,
      367,  163,  163,  163,  163,  163,  163,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      163,  163,  163,  163,  163,  163,  129,  129,  129,  129,
      129,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  168,  367,  367,  367,  367,

      367,  367,  168,  168,  168,  168,  168,  168,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  114,  367,
      367,  168,  168,  168,  168,  168,  168,  140,  140,  140,
      140,  140,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  178,  367,  367,  367,
      367,  367,  367,  178,  178,  178,  178,  178,  178,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  178,  178,  178,  178,  178,  178,  185,  367,

      367,  367,  367,  367,  367,  185,  185,  185,  185,  185,
      185,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  185,  185,  185,  185,  185,  185,
      188,  367,  367,  367,  367,  367,  367,  188,  188,  188,
      188,  188,  188,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  188,  188,  188,  188,
      188,  188,  190,  367,  367,  367,  367,  367,  367,  190,
      190,  190,  190,  190,  190,  367,  367,  367,  367,  367,

      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  190,  190,
      190,  190,  190,  190,  155,  155,  155,  155,  155,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  191,  367,  367,  367,  367,  367,  367,
      191,  191,  191,  191,  191,  191,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  191,
      191,  191,  191,  191,  191,  192,  367,  367,  367,  367,
      367,  367,  192,  192,  192,  192,  192,  192,  367,  367,

      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  192,  192,  192,  192,  192,  192,  193,  367,  367,
      367,  367,  367,  367,  193,  193,  193,  193,  193,  193,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  193,  193,  193,  193,  193,  193,  162,
      162,  162,  162,  162,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  196,  367,
      367,  367,  367,  367,  367,  196,  196,  196,  196,  196,

      196,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  196,  196,  196,  196,  196,  196,
      198,  367,  367,  367,  367,  367,  367,  198,  198,  198,
      198,  198,  198,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  198,  198,  198,  198,
      198,  198,  207,  367,  367,  367,  367,  367,  367,  207,
      207,  207,  207,  207,  207,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,

      367,  367,  367,  367,  367,  367,  367,  367,  207,  207,
      207,  207,  207,  207,  219,  367,  367,  367,  367,  367,
      367,  219,  219,  219,  219,  219,  219,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      219,  219,  219,  219,  219,  219,  221,  367,  367,  367,
      367,  367,  367,  221,  221,  221,  221,  221,  221,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  221,  221,  221,  221,  221,  221,  223,  367,

      367,  367,  367,  367,  367,  223,  223,  223,  223,  223,
      223,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  223,  223,  223,  223,  223,  223,
      224,  367,  367,  367,  367,  367,  367,  224,  224,  224,
      224,  224,  224,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  224,  224,  224,  224,
      224,  224,  225,  367,  367,  367,  367,  367,  367,  225,
      225,  225,  225,  225,  225,  367,  367,  367,  367,  367,

      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  225,  225,
      225,  225,  225,  225,  226,  367,  367,  367,  367,  367,
      367,  226,  226,  226,  226,  226,  226,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      226,  226,  226,  226,  226,  226,  227,  367,  367,  367,
      367,  367,  367,  227,  227,  227,  227,  227,  227,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,

      367,  367,  227,  227,  227,  227,  227,  227,  228,  367,
      367,  367,  367,  367,  367,  228,  228,  228,  228,  228,
      228,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  228,  228,  228,  228,  228,  228,
      236,  367,  367,  367,  367,  367,  367,  236,  236,  236,
      236,  236,  236,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  236,  236,  236,  236,
      236,  236,  243,  243,  243,  243,  249,  367,  251,  367,

      367,  367,  367,  251,  251,  252,  367,  367,  367,  367,
      367,  253,  367,  367,  367,  367,  367,  367,  253,  253,
      253,  253,  253,  253,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  254,  367,  367,  253,  253,  253,
      253,  253,  253,   85,   85,   85,   85,   85,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  255,  367,  367,  367,  367,  367,  367,  255,
      255,  255,  255,  255,  255,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,

      367,  367,  367,  367,  367,  367,  367,  367,  255,  255,
      255,  255,  255,  255,   95,  151,  151,  151,   95,  367,
       37,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  257,  367,  367,  367,  367,  367,  367,
      257,  257,  257,  257,  257,  257,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,   38,  367,  367,  257,
      257,  257,  257,  257,  257,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  259,  367,  367,  367,  367,  367,

      367,  259,  259,  259,  259,  259,  259,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      259,  259,  259,  259,  259,  259,  260,  367,  367,  367,
      367,  367,  367,  260,  260,  260,  260,  260,  260,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  260,  260,  260,  260,  260,  260,  261,  367,
      367,  367,  367,  367,  367,  261,  261,  261,  261,  261,
      261,  367,  367,  367,  367,  367,  367,  367,  367,  367,

      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  261,  261,  261,  261,  261,  261,
      262,  367,  367,  367,  367,  367,  367,  262,  262,  262,
      262,  262,  262,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  262,  262,  262,  262,
      262,  262,  263,  367,  367,  367,  367,  367,  367,  263,
      263,  263,  263,  263,  263,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  263,  263,

      263,  263,  263,  263,  264,  367,  367,  367,  367,  367,
      367,  264,  264,  264,  264,  264,  264,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      264,  264,  264,  264,  264,  264,  270,  367,  367,  367,
      367,  367,  367,  270,  270,  270,  270,  270,  270,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  270,  270,  270,  270,  270,  270,  244,  244,
      244,  280,  367,  367,  282,  367,  367,  367,  367,  367,

      367,  367,  367,  367,  367,  367,  367,  283,  367,  367,
      367,  367,  367,  367,  283,  283,  283,  283,  283,  283,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      284,  367,  367,  283,  283,  283,  283,  283,  283,  247,
      247,  247,  285,  367,  367,  367,  367,  367,  367,  367,
      287,  367,  367,  367,  367,  367,  367,  367,  288,  367,
      367,  367,  367,  367,  367,  288,  288,  288,  288,  288,
      288,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,

      367,  289,  367,  367,  288,  288,  288,  288,  288,  288,
      249,  249,  249,  249,  249,  367,  367,  367,  367,  367,
      367,  367,  367,  217,  367,  367,  367,  367,  367,  290,
      367,  367,  367,  367,  367,  367,  290,  290,  290,  290,
      290,  290,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  218,  367,  367,  290,  290,  290,  290,  290,
      290,  243,  243,  243,  243,  249,  367,  251,  367,  367,
      367,  367,  251,  251,  252,  367,  367,  367,  367,  367,
      253,  367,  367,  367,  367,  367,  367,  253,  253,  253,

      253,  253,  253,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  254,  367,  367,  253,  253,  253,  253,
      253,  253,   85,   85,   85,   85,   85,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  291,  367,  367,  367,  367,  367,  367,  291,  291,
      291,  291,  291,  291,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  291,  291,  291,
      291,  291,  291,   95,  151,  151,  151,   95,  367,   37,

      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  293,  367,  367,  367,  367,  367,  367,  293,
      293,  293,  293,  293,  293,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,   38,  367,  367,  293,  293,
      293,  293,  293,  293,  100,  367,  367,  367,  367,  367,
      367,  100,  100,  100,  100,  100,  100,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      100,  100,  100,  100,  100,  100,  294,  367,  367,  367,

      367,  367,  367,  294,  294,  294,  294,  294,  294,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  294,  294,  294,  294,  294,  294,  295,  367,
      367,  367,  367,  367,  367,  295,  295,  295,  295,  295,
      295,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  295,  295,  295,  295,  295,  295,
      296,  367,  367,  367,  367,  367,  367,  296,  296,  296,
      296,  296,  296,  367,  367,  367,  367,  367,  367,  367,

      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  296,  296,  296,  296,
      296,  296,  297,  367,  367,  367,  367,  367,  367,  297,
      297,  297,  297,  297,  297,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  297,  297,
      297,  297,  297,  297,  298,  367,  367,  367,  367,  367,
      367,  298,  298,  298,  298,  298,  298,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,

      298,  298,  298,  298,  298,  298,  303,  367,  367,  367,
      367,  367,  367,  303,  303,  303,  303,  303,  303,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  303,  303,  303,  303,  303,  303,  281,  314,
      314,  314,  281,  367,  245,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  315,  367,  367,
      367,  367,  367,  367,  315,  315,  315,  315,  315,  315,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,

      246,  367,  367,  315,  315,  315,  315,  315,  315,  244,
      244,  244,  280,  367,  367,  282,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  283,  367,
      367,  367,  367,  367,  367,  283,  283,  283,  283,  283,
      283,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  284,  367,  367,  283,  283,  283,  283,  283,  283,
      286,  318,  318,  318,  286,  367,  367,  367,  367,  367,
      367,  245,  367,  367,  367,  367,  367,  367,  367,  319,
      367,  367,  367,  367,  367,  367,  319,  319,  319,  319,

      319,  319,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  248,  367,  367,  319,  319,  319,  319,  319,
      319,  247,  247,  247,  285,  367,  367,  367,  367,  367,
      367,  367,  287,  367,  367,  367,  367,  367,  367,  367,
      288,  367,  367,  367,  367,  367,  367,  288,  288,  288,
      288,  288,  288,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  289,  367,  367,  288,  288,  288,  288,
      288,  288,  249,  249,  249,  249,  249,  367,  367,  367,

      367,  367,  367,  367,  367,  217,  367,  367,  367,  367,
      367,  320,  367,  367,  367,  367,  367,  367,  320,  320,
      320,  320,  320,  320,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  218,  367,  367,  320,  320,  320,
      320,  320,  320,   80,  367,  367,  367,  367,  367,  367,
       80,   80,   80,   80,   80,   80,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,   80,
       80,   80,   80,   80,   80,  322,  367,  367,  367,  367,

      367,  367,  322,  322,  322,  322,  322,  322,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  322,  322,  322,  322,  322,  322,  100,  367,  367,
      367,  367,  367,  367,  100,  100,  100,  100,  100,  100,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  100,  100,  100,  100,  100,  100,   45,
      367,  367,  367,  367,  367,  367,   45,   45,   45,   45,
       45,   45,  367,  367,  367,  367,  367,  367,  367,  367,

      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,   45,   45,   45,   45,   45,
       45,  323,  367,  367,  367,  367,  367,  367,  323,  323,
      323,  323,  323,  323,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  323,  323,  323,
      323,  323,  323,  113,  367,  367,  367,  367,  367,  367,
      113,  113,  113,  113,  113,  113,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  113,

      113,  113,  113,  113,  113,  328,  367,  367,  367,  367,
      367,  367,  328,  328,  328,  328,  328,  328,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  328,  328,  328,  328,  328,  328,  329,  367,  367,
      367,  367,  367,  367,  329,  329,  329,  329,  329,  329,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  329,  329,  329,  329,  329,  329,  330,
      367,  367,  367,  367,  367,  367,  330,  330,  330,  330,

      330,  330,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  330,  330,  330,  330,  330,
      330,  339,  367,  367,  367,  367,  367,  367,  339,  339,
      339,  339,  339,  339,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  339,  339,  339,
      339,  339,  339,  340,  367,  367,  367,  367,  367,  367,
      340,  340,  340,  340,  340,  340,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,

      367,  367,  367,  367,  367,  367,  367,  367,  367,  340,
      340,  340,  340,  340,  340,  341,  367,  367,  367,  367,
      367,  367,  341,  341,  341,  341,  341,  341,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  341,  341,  341,  341,  341,  341,  346,  367,  367,
      367,  367,  367,  367,  346,  346,  346,  346,  346,  346,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  346,  346,  346,  346,  346,  346,  347,

      367,  367,  367,  367,  367,  367,  347,  347,  347,  347,
      347,  347,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  347,  347,  347,  347,  347,
      347,  348,  367,  367,  367,  367,  367,  367,  348,  348,
      348,  348,  348,  348,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  348,  348,  348,
      348,  348,  348,  353,  367,  367,  367,  367,  367,  367,
      353,  353,  353,  353,  353,  353,  367,  367,  367,  367,

      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  353,
      353,  353,  353,  353,  353,  354,  367,  367,  367,  367,
      367,  367,  354,  354,  354,  354,  354,  354,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  354,  354,  354,  354,  354,  354,  214,  367,  367,
      367,  367,  367,  367,  214,  214,  214,  214,  214,  214,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,

      367,  367,  367,  214,  214,  214,  214,  214,  214,   36,
      367,   36,   36,   36,   36,   36,   36,   36,   42,   42,
      367,   42,   42,   45,  367,   45,   45,   45,   45,   45,
       45,   45,   49,  367,  367,   49,   49,   80,   80,   80,
      367,   80,   80,   85,   85,   85,   85,   85,   85,   85,
       95,   95,   95,   95,   95,   95,   95,   95,   95,   99,
      367,   99,  100,  100,  367,  100,  100,  103,  103,  103,
      103,  103,  103,  103,  106,  106,  106,  106,  106,  106,
      106,  106,  106,  111,  111,  111,  111,  111,  111,  111,
      111,  111,  111,  113,  113,  367,  113,  113,  129,  129,

      129,  129,  129,  129,  129,  140,  140,  140,  140,  140,
      140,  140,  143,  143,  143,  153,  367,  153,  155,  155,
      155,  155,  155,  155,  155,  160,  160,  160,  160,  160,
      160,  160,  160,  160,  160,  162,  162,  162,  162,  162,
      162,  162,  181,  181,  181,  181,  189,  367,  189,  194,
      194,  194,  194,  194,  194,  194,  194,  194,  194,  208,
      367,  208,  209,  209,  209,  209,  214,  214,  214,  367,
      214,  214,  214,  214,  214,  222,  367,  222,  160,  160,
      160,  160,  160,  160,  160,  160,  160,  160,  237,  367,
      237,  238,  238,  238,  238,  244,  367,  244,  244,  244,

      244,  244,  244,  244,  247,  367,  247,  247,  247,  247,
      247,  247,  247,  250,  250,  250,  250,  250,  250,  250,
      250,  250,   36,   36,   36,   36,   36,   36,   36,   36,
       36,  258,  367,  258,  271,  367,  271,  272,  272,  272,
      272,  281,  281,  281,  281,  281,  281,  281,  281,  281,
      286,  286,  286,  286,  286,  286,  286,  286,  286,  250,
      250,  250,  250,  250,  250,  250,  250,  250,   36,   36,
       36,   36,   36,   36,   36,   36,   36,  304,  367,  304,
      305,  305,  305,  305,  286,  286,  286,  286,  286,  286,
      286,  286,  286,  327,  367,  327,  338,  367,  338,    5,

      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367
    } ;

static yyconst flex_int16_t yy_chk[4786] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    3,   13,    4,   15,   21,
       10,    3,   36,    4,    7,    7,    7,    7,    7,    8,

        8,    8,    8,    8,    3,    3,    4,    4,    9,    9,
        9,    9,    9,   22,   39,   23,   35,   39,   23,  305,
        3,   29,    4,   30,   15,   31,   45,   13,   49,   21,
       80,  299,    3,    3,    4,    4,   10,   51,   36,   51,
      277,   22,    9,  276,   35,    3,   23,    4,   29,   63,
       39,   30,   31,   22,  275,   23,   33,   33,   33,   33,
       33,   29,   63,   30,   58,   31,   59,   45,   49,   22,
       80,    9,   11,   95,   23,   11,   29,   63,   58,   30,
       31,   61,   11,   11,   11,   11,   11,   11,   59,   73,
       61,   64,   58,   62,   62,   59,  274,   67,   34,   34,

       34,   34,   34,   70,   76,   70,  273,  242,   11,   61,
       64,   11,   11,   11,   11,   11,   11,   18,   73,   95,
       64,   62,  143,   67,   18,   18,   67,   18,  241,  240,
      143,  239,   34,   76,   18,   18,   18,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   34,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   18,   18,   18,
       18,   18,   18,   18,   18,   18,   18,   18,   60,   85,
       72,   18,   20,   74,   65,   75,   77,   78,   82,   60,

       65,  229,   60,  181,   20,   96,  133,   20,   65,  105,
       20,  181,   93,  212,   20,   20,   60,   20,   72,  105,
       66,   74,   65,   75,  140,   77,   78,   60,   65,   85,
       90,   82,  106,   20,   91,  133,   20,   66,   82,   20,
       93,   66,   20,   20,   66,   20,   24,   90,  211,   66,
      210,   96,   84,   24,   24,   24,   24,   24,   24,   82,
      105,   94,  107,  202,  140,   66,   94,   91,   92,   66,
       90,  112,  119,  106,   91,  112,   90,   84,  122,  122,
      116,  128,   24,   24,   24,   24,   24,   24,   38,   38,
       38,   38,   84,   92,   38,   91,  134,  137,  119,  135,

      116,  119,  136,  107,  128,   84,  122,   38,   92,  116,
      128,  138,   94,  131,   38,   38,   38,   38,   38,   38,
      151,   92,  139,  131,  142,  134,  137,  135,  145,  147,
      136,  148,  158,  195,  150,  172,  171,  195,  149,  138,
       38,  131,  173,   38,   38,   38,   38,   38,   38,   41,
      169,  139,  165,  186,  197,  174,   41,   41,   41,   41,
       41,   41,  150,  172,  142,  171,  151,  175,  145,  147,
      173,  148,  169,  158,  194,  165,  149,  176,  149,  169,
      177,  165,   41,  174,  187,   41,   41,   41,   41,   41,
       41,   43,  200,  186,  199,  201,  175,  203,   43,   43,

       43,   43,   43,   43,  149,  215,  176,  216,  199,  177,
      204,  230,  187,  184,  184,  184,  184,  184,  205,  184,
      200,  220,  199,  201,  184,  203,  184,   43,   43,   43,
       43,   43,   43,   46,   46,   46,   46,  209,  244,  204,
      230,  183,  231,  182,   46,  209,  205,  232,  216,  220,
      233,  215,   46,  235,  256,  167,  166,  164,  265,   46,
       46,   46,   46,   46,   46,  184,  213,  213,  213,  213,
      213,  231,  213,  162,  238,  160,  232,  213,  233,  213,
      267,  235,  238,  256,  244,   46,  265,  266,   46,   46,
       46,   46,   46,   46,   50,  243,  243,  243,  243,  243,

      247,   50,   50,   50,   50,   50,   50,  155,  243,  267,
      214,  214,  214,  214,  214,  266,  214,  292,  213,  269,
      281,  214,  301,  214,  245,  245,  245,  245,  245,  144,
       50,   50,   50,   50,   50,   50,   54,  245,  286,  272,
      302,  247,  317,   54,   54,  292,   54,  272,  269,  313,
      132,  301,  129,  280,  285,   54,   54,   54,  280,   54,
       54,   54,  214,   54,  285,   54,  281,  127,   54,  302,
       54,   54,  314,  321,  278,  278,  278,  278,  278,  286,
      318,   54,  126,  317,   54,   54,   54,  278,   54,   54,
       54,   54,  334,   54,  325,  313,   54,  344,   54,   54,

       69,  321,  125,  326,  280,  285,  332,   69,   69,   69,
       69,   69,   69,  249,  249,  249,  249,  249,  314,  249,
      334,  318,  124,  325,  249,  344,  249,  303,  303,  303,
      303,  303,  326,  333,  335,  332,   69,   69,   69,   69,
       69,   69,   81,  322,  322,  322,  322,  322,  342,   81,
       81,   81,   81,   81,   81,  250,  250,  250,  250,  250,
      123,  250,  333,  335,  121,  249,  250,  345,  250,  293,
      293,  293,  293,  293,  349,  293,  343,  342,   81,   81,
       81,   81,   81,   81,   86,   86,   86,   86,   86,  323,
      323,  323,  323,  323,  350,  345,   86,  351,  120,  118,

      352,  356,  349,   86,  355,  343,  358,  250,  117,  360,
       86,   86,   86,   86,   86,   86,  251,  251,  251,  251,
      251,  293,  251,  350,  362,  363,  351,  251,  352,  251,
      356,  115,  355,  113,  111,  358,   86,  360,  364,   86,
       86,   86,   86,   86,   86,   97,   97,   97,   97,   97,
      103,   97,  362,  100,  363,   83,  365,   71,   68,  353,
      353,  353,  353,  353,   97,  353,  364,   57,  251,   55,
       53,   97,   97,   97,   97,   97,   97,  252,  252,  252,
      252,  252,   52,  252,  365,   48,   42,   27,  252,   26,
      252,   25,   19,   17,   16,   14,   12,   97,    5,    0,

       97,   97,   97,   97,   97,   97,   98,   98,   98,   98,
        0,  353,   98,    0,    0,    0,    0,  282,  282,  282,
      282,  282,    0,  282,    0,   98,    0,    0,    0,  252,
      282,    0,   98,   98,   98,   98,   98,   98,  287,  287,
      287,  287,  287,    0,  312,  312,  312,  312,  312,  287,
      312,  287,    0,    0,    0,    0,    0,  312,   98,    0,
        0,   98,   98,   98,   98,   98,   98,  101,    0,  282,
        0,    0,    0,    0,  101,  101,  101,  101,  101,  101,
      316,  316,  316,  316,  316,    0,    0,    0,    0,    0,
      287,  316,    0,  316,    0,    0,  312,    0,    0,    0,

      101,    0,    0,  101,  101,  101,  101,  101,  101,  102,
        0,  354,  354,  354,  354,  354,  102,  102,  102,  102,
      102,  102,  354,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  316,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  102,  102,  102,  102,  102,
      102,  104,  104,  104,  104,  104,    0,  324,    0,    0,
        0,    0,    0,  354,    0,    0,  324,    0,    0,    0,
      104,  324,    0,    0,    0,  324,    0,  104,  104,  104,
      104,  104,  104,    0,    0,    0,  324,    0,    0,    0,
        0,    0,    0,    0,  324,    0,    0,    0,    0,  324,

        0,    0,    0,  324,    0,    0,  104,  104,  104,  104,
      104,  104,  108,  108,  108,  108,  108,    0,    0,    0,
        0,    0,    0,  108,    0,    0,    0,    0,    0,    0,
        0,  108,    0,    0,    0,    0,    0,    0,  108,  108,
      108,  108,  108,  108,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  108,    0,    0,  108,  108,  108,
      108,  108,  108,  109,  109,  109,  109,    0,    0,    0,
        0,    0,    0,    0,  109,    0,    0,    0,    0,    0,
        0,    0,  109,    0,    0,    0,    0,    0,    0,  109,

      109,  109,  109,  109,  109,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  109,    0,    0,  109,  109,
      109,  109,  109,  109,  114,    0,    0,    0,    0,    0,
        0,  114,  114,  114,  114,  114,  114,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      114,  114,  114,  114,  114,  114,  130,  130,  130,  130,
      130,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  130,    0,    0,    0,    0,

        0,    0,  130,  130,  130,  130,  130,  130,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  130,    0,
        0,  130,  130,  130,  130,  130,  130,  141,  141,  141,
      141,  141,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  141,    0,    0,    0,
        0,    0,    0,  141,  141,  141,  141,  141,  141,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  141,  141,  141,  141,  141,  141,  146,    0,

        0,    0,    0,    0,    0,  146,  146,  146,  146,  146,
      146,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  146,  146,  146,  146,  146,  146,
      152,    0,    0,    0,    0,    0,    0,  152,  152,  152,
      152,  152,  152,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  152,  152,  152,  152,
      152,  152,  154,    0,    0,    0,    0,    0,    0,  154,
      154,  154,  154,  154,  154,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  154,  154,
      154,  154,  154,  154,  156,  156,  156,  156,  156,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  156,    0,    0,    0,    0,    0,    0,
      156,  156,  156,  156,  156,  156,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  156,
      156,  156,  156,  156,  156,  157,    0,    0,    0,    0,
        0,    0,  157,  157,  157,  157,  157,  157,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  157,  157,  157,  157,  157,  157,  159,    0,    0,
        0,    0,    0,    0,  159,  159,  159,  159,  159,  159,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  159,  159,  159,  159,  159,  159,  163,
      163,  163,  163,  163,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  163,    0,
        0,    0,    0,    0,    0,  163,  163,  163,  163,  163,

      163,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  163,  163,  163,  163,  163,  163,
      168,    0,    0,    0,    0,    0,    0,  168,  168,  168,
      168,  168,  168,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  168,  168,  168,  168,
      168,  168,  178,    0,    0,    0,    0,    0,    0,  178,
      178,  178,  178,  178,  178,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,  178,  178,
      178,  178,  178,  178,  185,    0,    0,    0,    0,    0,
        0,  185,  185,  185,  185,  185,  185,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      185,  185,  185,  185,  185,  185,  188,    0,    0,    0,
        0,    0,    0,  188,  188,  188,  188,  188,  188,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  188,  188,  188,  188,  188,  188,  190,    0,

        0,    0,    0,    0,    0,  190,  190,  190,  190,  190,
      190,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  190,  190,  190,  190,  190,  190,
      191,    0,    0,    0,    0,    0,    0,  191,  191,  191,
      191,  191,  191,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  191,  191,  191,  191,
      191,  191,  192,    0,    0,    0,    0,    0,    0,  192,
      192,  192,  192,  192,  192,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  192,  192,
      192,  192,  192,  192,  193,    0,    0,    0,    0,    0,
        0,  193,  193,  193,  193,  193,  193,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      193,  193,  193,  193,  193,  193,  196,    0,    0,    0,
        0,    0,    0,  196,  196,  196,  196,  196,  196,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,  196,  196,  196,  196,  196,  196,  198,    0,
        0,    0,    0,    0,    0,  198,  198,  198,  198,  198,
      198,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  198,  198,  198,  198,  198,  198,
      207,    0,    0,    0,    0,    0,    0,  207,  207,  207,
      207,  207,  207,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  207,  207,  207,  207,
      207,  207,  218,  218,  218,  218,  218,    0,  218,    0,

        0,    0,    0,  218,  218,  218,    0,    0,    0,    0,
        0,  218,    0,    0,    0,    0,    0,    0,  218,  218,
      218,  218,  218,  218,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  218,    0,    0,  218,  218,  218,
      218,  218,  218,  219,  219,  219,  219,  219,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  219,    0,    0,    0,    0,    0,    0,  219,
      219,  219,  219,  219,  219,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,  219,  219,
      219,  219,  219,  219,  221,  221,  221,  221,  221,    0,
      221,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  221,    0,    0,    0,    0,    0,    0,
      221,  221,  221,  221,  221,  221,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  221,    0,    0,  221,
      221,  221,  221,  221,  221,  223,  223,  223,  223,  223,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  223,    0,    0,    0,    0,    0,

        0,  223,  223,  223,  223,  223,  223,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      223,  223,  223,  223,  223,  223,  224,    0,    0,    0,
        0,    0,    0,  224,  224,  224,  224,  224,  224,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  224,  224,  224,  224,  224,  224,  225,    0,
        0,    0,    0,    0,    0,  225,  225,  225,  225,  225,
      225,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  225,  225,  225,  225,  225,  225,
      226,    0,    0,    0,    0,    0,    0,  226,  226,  226,
      226,  226,  226,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  226,  226,  226,  226,
      226,  226,  227,    0,    0,    0,    0,    0,    0,  227,
      227,  227,  227,  227,  227,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  227,  227,

      227,  227,  227,  227,  228,    0,    0,    0,    0,    0,
        0,  228,  228,  228,  228,  228,  228,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      228,  228,  228,  228,  228,  228,  236,    0,    0,    0,
        0,    0,    0,  236,  236,  236,  236,  236,  236,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  236,  236,  236,  236,  236,  236,  246,  246,
      246,  246,    0,    0,  246,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,  246,    0,    0,
        0,    0,    0,    0,  246,  246,  246,  246,  246,  246,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      246,    0,    0,  246,  246,  246,  246,  246,  246,  248,
      248,  248,  248,    0,    0,    0,    0,    0,    0,    0,
      248,    0,    0,    0,    0,    0,    0,    0,  248,    0,
        0,    0,    0,    0,    0,  248,  248,  248,  248,  248,
      248,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,  248,    0,    0,  248,  248,  248,  248,  248,  248,
      253,  253,  253,  253,  253,    0,  253,    0,    0,    0,
        0,  253,    0,  253,    0,    0,    0,    0,    0,  253,
        0,    0,    0,    0,    0,    0,  253,  253,  253,  253,
      253,  253,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  253,    0,    0,  253,  253,  253,  253,  253,
      253,  254,  254,  254,  254,  254,    0,  254,    0,    0,
        0,    0,  254,  254,  254,    0,    0,    0,    0,    0,
      254,    0,    0,    0,    0,    0,    0,  254,  254,  254,

      254,  254,  254,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  254,    0,    0,  254,  254,  254,  254,
      254,  254,  255,  255,  255,  255,  255,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  255,    0,    0,    0,    0,    0,    0,  255,  255,
      255,  255,  255,  255,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  255,  255,  255,
      255,  255,  255,  257,  257,  257,  257,  257,    0,  257,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  257,    0,    0,    0,    0,    0,    0,  257,
      257,  257,  257,  257,  257,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  257,    0,    0,  257,  257,
      257,  257,  257,  257,  259,    0,    0,    0,    0,    0,
        0,  259,  259,  259,  259,  259,  259,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
      259,  259,  259,  259,  259,  259,  260,    0,    0,    0,

        0,    0,    0,  260,  260,  260,  260,  260,  260,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  260,  260,  260,  260,  260,  260,  261,    0,
        0,    0,    0,    0,    0,  261,  261,  261,  261,  261,
      261,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  261,  261,  261,  261,  261,  261,
      262,    0,    0,    0,    0,    0,    0,  262,  262,  262,
      262,  262,  262,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,  262,  262,  262,  262,
      262,  262,  263,    0,    0,    0,    0,    0,    0,  263,
      263,  263,  263,  263,  263,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  263,  263,
      263,  263,  263,  263,  264,    0,    0,    0,    0,    0,
        0,  264,  264,  264,  264,  264,  264,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

      264,  264,  264,  264,  264,  264,  270,    0,    0,    0,
        0,    0,    0,  270,  270,  270,  270,  270,  270,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  270,  270,  270,  270,  270,  270,  283,  283,
      283,  283,  283,    0,  283,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  283,    0,    0,
        0,    0,    0,    0,  283,  283,  283,  283,  283,  283,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

      283,    0,    0,  283,  283,  283,  283,  283,  283,  284,
      284,  284,  284,    0,    0,  284,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,  284,    0,
        0,    0,    0,    0,    0,  284,  284,  284,  284,  284,
      284,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  284,    0,    0,  284,  284,  284,  284,  284,  284,
      288,  288,  288,  288,  288,    0,    0,    0,    0,    0,
        0,  288,    0,    0,    0,    0,    0,    0,    0,  288,
        0,    0,    0,    0,    0,    0,  288,  288,  288,  288,

      288,  288,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,  288,    0,    0,  288,  288,  288,  288,  288,
      288,  289,  289,  289,  289,    0,    0,    0,    0,    0,
        0,    0,  289,    0,    0,    0,    0,    0,    0,    0,
      289,    0,    0,    0,    0,    0,    0,  289,  289,  289,
      289,  289,  289,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  289,    0,    0,  289,  289,  289,  289,
      289,  289,  290,  290,  290,  290,  290,    0,  290,    0,

        0,    0,    0,  290,    0,  290,    0,    0,    0,    0,
        0,  290,    0,    0,    0,    0,    0,    0,  290,  290,
      290,  290,  290,  290,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,  290,    0,    0,  290,  290,  290,
      290,  290,  290,  291,    0,    0,    0,    0,    0,    0,
      291,  291,  291,  291,  291,  291,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  291,
      291,  291,  291,  291,  291,  294,    0,    0,    0,    0,

        0,    0,  294,  294,  294,  294,  294,  294,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  294,  294,  294,  294,  294,  294,  295,    0,    0,
        0,    0,    0,    0,  295,  295,  295,  295,  295,  295,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  295,  295,  295,  295,  295,  295,  296,
        0,    0,    0,    0,    0,    0,  296,  296,  296,  296,
      296,  296,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  296,  296,  296,  296,  296,
      296,  297,    0,    0,    0,    0,    0,    0,  297,  297,
      297,  297,  297,  297,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  297,  297,  297,
      297,  297,  297,  298,    0,    0,    0,    0,    0,    0,
      298,  298,  298,  298,  298,  298,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  298,

      298,  298,  298,  298,  298,  315,    0,    0,    0,    0,
        0,    0,  315,  315,  315,  315,  315,  315,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  315,  315,  315,  315,  315,  315,  319,    0,    0,
        0,    0,    0,    0,  319,  319,  319,  319,  319,  319,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  319,  319,  319,  319,  319,  319,  320,
        0,    0,    0,    0,    0,    0,  320,  320,  320,  320,

      320,  320,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  320,  320,  320,  320,  320,
      320,  328,    0,    0,    0,    0,    0,    0,  328,  328,
      328,  328,  328,  328,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  328,  328,  328,
      328,  328,  328,  329,    0,    0,    0,    0,    0,    0,
      329,  329,  329,  329,  329,  329,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,  329,
      329,  329,  329,  329,  329,  330,    0,    0,    0,    0,
        0,    0,  330,  330,  330,  330,  330,  330,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  330,  330,  330,  330,  330,  330,  339,    0,    0,
        0,    0,    0,    0,  339,  339,  339,  339,  339,  339,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,  339,  339,  339,  339,  339,  339,  340,

        0,    0,    0,    0,    0,    0,  340,  340,  340,  340,
      340,  340,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,  340,  340,  340,  340,  340,
      340,  341,    0,    0,    0,    0,    0,    0,  341,  341,
      341,  341,  341,  341,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  341,  341,  341,
      341,  341,  341,  346,    0,    0,    0,    0,    0,    0,
      346,  346,  346,  346,  346,  346,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  346,
      346,  346,  346,  346,  346,  347,    0,    0,    0,    0,
        0,    0,  347,  347,  347,  347,  347,  347,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,  347,  347,  347,  347,  347,  347,  348,    0,    0,
        0,    0,    0,    0,  348,  348,  348,  348,  348,  348,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,  348,  348,  348,  348,  348,  348,  368,
        0,  368,  368,  368,  368,  368,  368,  368,  369,  369,
        0,  369,  369,  370,    0,  370,  370,  370,  370,  370,
      370,  370,  371,    0,    0,  371,  371,  372,  372,  372,
        0,  372,  372,  373,  373,  373,  373,  373,  373,  373,
      374,  374,  374,  374,  374,  374,  374,  374,  374,  375,
        0,  375,  376,  376,    0,  376,  376,  377,  377,  377,
      377,  377,  377,  377,  378,  378,  378,  378,  378,  378,
      378,  378,  378,  379,  379,  379,  379,  379,  379,  379,
      379,  379,  379,  380,  380,    0,  380,  380,  381,  381,

      381,  381,  381,  381,  381,  382,  382,  382,  382,  382,
      382,  382,  383,  383,  383,  384,    0,  384,  385,  385,
      385,  385,  385,  385,  385,  386,  386,  386,  386,  386,
      386,  386,  386,  386,  386,  387,  387,  387,  387,  387,
      387,  387,  388,  388,  388,  388,  389,    0,  389,  390,
      390,  390,  390,  390,  390,  390,  390,  390,  390,  391,
        0,  391,  392,  392,  392,  392,  393,  393,  393,    0,
      393,  393,  393,  393,  393,  394,    0,  394,  395,  395,
      395,  395,  395,  395,  395,  395,  395,  395,  396,    0,
      396,  397,  397,  397,  397,  398,    0,  398,  398,  398,

      398,  398,  398,  398,  399,    0,  399,  399,  399,  399,
      399,  399,  399,  400,  400,  400,  400,  400,  400,  400,
      400,  400,  401,  401,  401,  401,  401,  401,  401,  401,
      401,  402,    0,  402,  403,    0,  403,  404,  404,  404,
      404,  405,  405,  405,  405,  405,  405,  405,  405,  405,
      406,  406,  406,  406,  406,  406,  406,  406,  406,  407,
      407,  407,  407,  407,  407,  407,  407,  407,  408,  408,
      408,  408,  408,  408,  408,  408,  408,  409,    0,  409,
      410,  410,  410,  410,  411,  411,  411,  411,  411,  411,
      411,  411,  411,  412,    0,  412,  413,    0,  413,  367,

      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367,  367,  367,  367,  367,  367,
      367,  367,  367,  367,  367
    } ;

#line 1 "<stdin>"
YY_DECL
{
	register yy_state_type yy_current_state;
	register UChar *yy_cp, *yy_bp;
	register int yy_act;
	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 368 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 4700 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 29 "<stdin>"
/* ignore comments */
	YY_BREAK
case 2:
/* rule 2 can match eol */
YY_RULE_SETUP
#line 31 "<stdin>"
{yyTok = WHITESPACE; return yyTok;}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 33 "<stdin>"
{yyTok = SGML_CD; return yyTok;}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 34 "<stdin>"
{yyTok = SGML_CD; return yyTok;}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 35 "<stdin>"
{yyTok = INCLUDES; return yyTok;}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 36 "<stdin>"
{yyTok = DASHMATCH; return yyTok;}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 37 "<stdin>"
{yyTok = BEGINSWITH; return yyTok;}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 38 "<stdin>"
{yyTok = ENDSWITH; return yyTok;}
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 39 "<stdin>"
{yyTok = CONTAINS; return yyTok;}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 40 "<stdin>"
{yyTok = MEDIA_NOT; return yyTok;}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 41 "<stdin>"
{yyTok = MEDIA_ONLY; return yyTok;}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 42 "<stdin>"
{yyTok = MEDIA_AND; return yyTok;}
	YY_BREAK
case 13:
/* rule 13 can match eol */
YY_RULE_SETUP
#line 44 "<stdin>"
{yyTok = STRING; return yyTok;}
	YY_BREAK
case 14:
/* rule 14 can match eol */
YY_RULE_SETUP
#line 46 "<stdin>"
{yyTok = IDENT; return yyTok;}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 48 "<stdin>"
{yyTok = HEX; return yyTok;}
	YY_BREAK
case 16:
/* rule 16 can match eol */
YY_RULE_SETUP
#line 49 "<stdin>"
{yyTok = IDSEL; return yyTok;}
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 51 "<stdin>"
{BEGIN(mediaquery); yyTok = IMPORT_SYM; return yyTok;}
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 52 "<stdin>"
{yyTok = PAGE_SYM; return yyTok;}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 53 "<stdin>"
{BEGIN(mediaquery); yyTok = MEDIA_SYM; return yyTok;}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 54 "<stdin>"
{yyTok = FONT_FACE_SYM; return yyTok;}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 55 "<stdin>"
{yyTok = CHARSET_SYM; return yyTok;}
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 56 "<stdin>"
{yyTok = NAMESPACE_SYM; return yyTok; }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 57 "<stdin>"
{yyTok = WEBKIT_RULE_SYM; return yyTok; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 58 "<stdin>"
{yyTok = WEBKIT_DECLS_SYM; return yyTok; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 59 "<stdin>"
{yyTok = WEBKIT_VALUE_SYM; return yyTok; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 60 "<stdin>"
{BEGIN(mediaquery); yyTok = WEBKIT_MEDIAQUERY_SYM; return yyTok; }
	YY_BREAK
case 27:
/* rule 27 can match eol */
YY_RULE_SETUP
#line 62 "<stdin>"
{yyTok = IMPORTANT_SYM; return yyTok;}
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 64 "<stdin>"
{yyTok = EMS; return yyTok;}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 65 "<stdin>"
{yyTok = QEMS; return yyTok;} /* quirky ems */
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 66 "<stdin>"
{yyTok = EXS; return yyTok;}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 67 "<stdin>"
{yyTok = PXS; return yyTok;}
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 68 "<stdin>"
{yyTok = CMS; return yyTok;}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 69 "<stdin>"
{yyTok = MMS; return yyTok;}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 70 "<stdin>"
{yyTok = INS; return yyTok;}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 71 "<stdin>"
{yyTok = PTS; return yyTok;}
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 72 "<stdin>"
{yyTok = PCS; return yyTok;}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 73 "<stdin>"
{yyTok = DEGS; return yyTok;}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 74 "<stdin>"
{yyTok = RADS; return yyTok;}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 75 "<stdin>"
{yyTok = GRADS; return yyTok;}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 76 "<stdin>"
{yyTok = MSECS; return yyTok;}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 77 "<stdin>"
{yyTok = SECS; return yyTok;}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 78 "<stdin>"
{yyTok = HERZ; return yyTok;}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 79 "<stdin>"
{yyTok = KHERZ; return yyTok;}
	YY_BREAK
case 44:
/* rule 44 can match eol */
YY_RULE_SETUP
#line 80 "<stdin>"
{yyTok = DIMEN; return yyTok;}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 81 "<stdin>"
{yyTok = PERCENTAGE; return yyTok;}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 82 "<stdin>"
{yyTok = INTEGER; return yyTok;}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 83 "<stdin>"
{yyTok = FLOATTOKEN; return yyTok;}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 85 "<stdin>"
{yyTok = NOTFUNCTION; return yyTok;}
	YY_BREAK
case 49:
/* rule 49 can match eol */
YY_RULE_SETUP
#line 86 "<stdin>"
{yyTok = URI; return yyTok;}
	YY_BREAK
case 50:
/* rule 50 can match eol */
YY_RULE_SETUP
#line 87 "<stdin>"
{yyTok = URI; return yyTok;}
	YY_BREAK
case 51:
/* rule 51 can match eol */
YY_RULE_SETUP
#line 88 "<stdin>"
{yyTok = FUNCTION; return yyTok;}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 90 "<stdin>"
{yyTok = UNICODERANGE; return yyTok;}
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 91 "<stdin>"
{yyTok = UNICODERANGE; return yyTok;}
	YY_BREAK
case 54:
#line 94 "<stdin>"
case 55:
YY_RULE_SETUP
#line 94 "<stdin>"
{BEGIN(INITIAL); yyTok = *yytext; return yyTok; }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 95 "<stdin>"
{yyTok = *yytext; return yyTok;}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 97 "<stdin>"
ECHO;
	YY_BREAK
#line 2189 "<stdout>"
case YY_STATE_EOF(INITIAL):
case YY_END_OF_BUFFER:
case YY_STATE_EOF(mediaquery):
	yyterminate();

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of yylex */
