/*
 *  commands.c
 *  quickascii
 *
 *  Created by Nicholas Pisarro on Mon Oct 28 2002.
 *  Copyright (c) 2002 __MyCompanyName__. All rights reserved.
 *
 */
 
#include <stdio.h>
#include <String.h>
#include "commands.h"

#define DEFAULT_SCALE 1
#if 0
	// 16x9
	#define	DEFAULT_WIDTH	80
	#define DEFAULT_HEIGHT	17
#else
	// 4x3
	#define	DEFAULT_WIDTH	80
	#define DEFAULT_HEIGHT	24
#endif


// returns index of arguments contain a flag of char arg, or 0 if not found
// only looks for single char flags
// deprecated
int resolve_command (int argc, char *argv[],char arg) {
    int i;
    for (i = 1;i < argc; i++) {
        if (argv[i][0] == '-' && argv[i][1] == arg) {
            return i;
        }
    }
    return 0;
}

// returns the index of parameter matching argchar or argstr, or 0 if not found
int resolve_flag (int argc,char *argv[],char argchar,char* argstr) {
    int i;
    for (i = 1;i < argc; i++) {
        if (argv[i][0] == '-') {
            if (argv[i][1] == argchar) {
                return i;
            } else if (argv[i][1] == '-' && strcmp(&argv[i][2],argstr) == 0) {
                return i;
            }
        }
    }
    return 0;
}

// returns the value a parameter is set to, or 0 if not found
char* resolve_flag_value (int argc,char *argv[],char argchar,char* argstr) {
    int index = resolve_flag(argc,argv,argchar,argstr);
    if (index == 0 || argc == index + 1 || argv[index + 1][0] == '-') {
        return 0;
    } else {
        return argv[index + 1];
    }
}


// returns the first argument that does not begin with a dash ('-')
// checks last argument 2nd
char *resolve_file (int argc,char *argv[]) {
    int i;
    if (argc <= 1) {				// if no arguments, bail
        return 0;
    } else if (argv[1][0] != '-') {		// checks 1st arg
        return argv[1];
    } else if (argv[argc-1][0] != '-') {	// checks last arg
        return (argv[argc-1]);
    } else {					// loop through 2nd -> 2nd to last arg
        for (i = 2;i < argc-1; i++) {
            if (argv[i][0] != '-') {
                return argv[i];
            }
        }
        return 0;
    }
}

// returns the value of the scale parameter
float resolve_scale (int argc,char *argv[]) {
    char* param;
    float result;
    
    param = resolve_flag_value(argc,argv,'s',"scale");
    if (param) {
        sscanf(param,"%f",&result);
        return result;
    } else {
        return DEFAULT_SCALE;
    }
}

// returns the index of the invert parameter, or 0 if not found
int resolve_inversion (int argc,char *argv[]) {
    return resolve_flag(argc,argv,'i',"invert");
}

// resolves all of the dimension parameters and sets their variables apropriately
void set_dimensions(int argc,char *argv[],float *height,float *width,int *intheight,int *intwidth) {
    float scale = resolve_scale(argc,argv);
    int tempheight = 0,tempwidth = 0;
    char *tempresult;
    
    // get height
    tempresult = resolve_flag_value(argc,argv,'t',"height");
    if (tempresult) {
        sscanf(tempresult,"%d",&tempheight);
    }
    
    // get width
    tempresult = resolve_flag_value(argc,argv,'w',"width");
    if (tempresult) {
        sscanf(tempresult,"%d",&tempwidth);
    }

    if (tempheight && tempwidth) {
        *height = tempheight;
        *width = tempwidth;
    } else if (tempheight && !tempwidth) {
        *height = tempheight;
        *width = ((float) DEFAULT_WIDTH / (float) DEFAULT_HEIGHT) * (float) tempheight;
    } else if (tempwidth && !tempheight) {
        *width = tempwidth;
        *height = ((float) DEFAULT_HEIGHT / (float) DEFAULT_WIDTH) * (float) tempwidth;
    } else {
        *width = DEFAULT_WIDTH;
        *height = DEFAULT_HEIGHT;
    }
    
    *width *= scale;
    *height *= scale;
    
    *intheight = (int) *height;
    *intwidth = (int) *width;
}


// searches the arguments for -c, -h or -v, if found runs their functions and returns 1
int run_init_flags (int argc,char *argv[]) {
    int now_exit = 0;

    if (resolve_flag(argc,argv,'h',"help")) {
        print_help();
        now_exit = 1;
    } else if (resolve_flag(argc,argv,'c',"copyright")) {
        print_copyright();
        now_exit = 1;
    } else if (resolve_flag(argc,argv,'v',"version")) {
        print_version();
        now_exit = 1;
    }
    
    return now_exit;
}

// returns the of the color parameter, or 0 if not found
int resolve_color(int argc,char *argv[]) {
    return resolve_flag(argc,argv,'o',"color");
}


// prints the help message
void print_help () {
	printf("quickascii [options] filename\n");
	printf("   -h/--help             help (this message)\n");
	printf("   -c/--copyright        print copyright info, then exit\n");
	printf("   -v/--version          print version info, then exit\n");
	printf("   -i/--invert           invert luminence of output\n");
	printf("   -w/--width [number]   set picture width to this many columns\n");
	printf("   -t/--height [number]  set picture height to this many rows\n");
	printf("   -s/--scale [decimal]  scale picture by this amount\n");
	printf("   -o/--color            enable color support\n");
}

// prints the copyright information
void print_copyright () {
	printf("Portions copyright (c) 2002 Apple Computer, inc.\n");
	printf("Additions copyright (c) 2002 the QuickASCII team\n");
}

// prints version information
void print_version () {
    printf("QuickASCII 1.0.5\n");
}
