#include "fxex.h"

/* This demo is used to display the local time and UTC time.  */

class MainWindow : public FXMainWindow {
  FXDECLARE(MainWindow)
private:
  FXToolTip       *tooltip;
  FXVerticalFrame *localframe;
protected:
  MainWindow(){}
public:
  enum {
    ID_MAINWINDOW=FXMainWindow::ID_LAST,
    ID_QUIT
    };
public:
  long onQuit(FXObject*,FXSelector,void*);
  long onMainWindow(FXObject*,FXSelector,void*);
public:
  MainWindow(FXApp *a);
  virtual void create();
  ~MainWindow();
  };



// map
FXDEFMAP(MainWindow) MainWindowMap[]={
  FXMAPFUNC(SEL_SIGNAL,MainWindow::ID_QUIT,MainWindow::onQuit),
  FXMAPFUNC(SEL_CLOSE,MainWindow::ID_QUIT,MainWindow::onQuit),
  FXMAPFUNC(SEL_COMMAND,MainWindow::ID_QUIT,MainWindow::onQuit),
  FXMAPFUNC(SEL_COMMAND,MainWindow::ID_MAINWINDOW,MainWindow::onMainWindow),
  };
FXIMPLEMENT(MainWindow,FXMainWindow,MainWindowMap,ARRAYNUMBER(MainWindowMap))

MainWindow::MainWindow(FXApp *a) : FXMainWindow(a,"Local/World clock",NULL,NULL,DECOR_ALL){
  setTarget(this);
  setSelector(ID_MAINWINDOW);
  tooltip=new FXToolTip(getApp());
  FXSplitter *splitter=new FXSplitter(this,LAYOUT_FILL_X|LAYOUT_FILL_Y|SPLITTER_VERTICAL|SPLITTER_TRACKING);
  localframe=new FXVerticalFrame(splitter,LAYOUT_FILL_X|LAYOUT_FIX_HEIGHT|FRAME_SUNKEN|FRAME_THICK, 0,0,0,0, 0,0,0,0, 0,0);
  FXVerticalFrame *utcframe=new FXVerticalFrame(splitter,LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_SUNKEN|FRAME_THICK, 0,0,0,0, 0,0,0,0, 0,0);
  FXLCDClock *local=new FXLCDClock(localframe,NULL,0,LCDCLOCK_SECONDS|LCDCLOCK_LOCALTIME|LAYOUT_FILL_X|LAYOUT_FILL_Y, 5,5,5,5);
  FXLCDClock *utc=new FXLCDClock(utcframe,NULL,0,LCDCLOCK_UTCTIME|LAYOUT_FILL_X|LAYOUT_FILL_Y);
  local->setFgColor(FXRGB(0,200,0));
  utc->setFgColor(FXRGB(200,80,80));
  }

MainWindow::~MainWindow(){
  delete tooltip->getFont();
  }

void MainWindow::create(){
  FXMainWindow::create();
  FXFont *font=new FXFont(getApp(),"Helvetica",300);
  font->create();
  tooltip->setFont(font);
  show(PLACEMENT_MAXIMIZED);
  getApp()->forceRefresh();
  localframe->setHeight(getRoot()->getDefaultHeight()>>1);
  }

long MainWindow::onQuit(FXObject*,FXSelector,void*){
  getApp()->exit(0);
  return 1;
  }

long MainWindow::onMainWindow(FXObject*,FXSelector,void*){
  fxmessage("MainWindow event\n");
  return 1;
  }

/* start it up */
int main(int argc, char *argv[]){
  FXApp app("World Clock","FoxExTest");
  app.init(argc,argv);
  new MainWindow(&app);
  app.create();
  return app.run();
  }

