#include "FXTest.h"
#include <stdio.h>

FXDEFMAP(FXTest) FXTestMap[] = {
FXMAPFUNC(SEL_COMMAND,    FXTest::ID_SVRSOCKET,  FXTest::onSvrSocket),
FXMAPFUNC(SEL_COMMAND,    FXTest::ID_CLSOCKET,   FXTest::onClSocket),
FXMAPFUNC(SEL_COMMAND,    FXTest::ID_CONNECT,    FXTest::onConnect),
FXMAPFUNC(SEL_COMMAND,    FXTest::ID_ASSERVER,   FXTest::onAsServer),
FXMAPFUNC(SEL_COMMAND,    FXTest::ID_DISCONNECT, FXTest::onDisconnect),
FXMAPFUNC(SEL_COMMAND,    FXTest::ID_SEND,       FXTest::onSend)
};

FXIMPLEMENT(FXTest, FXMainWindow, FXTestMap, ARRAYNUMBER(FXTestMap));

FXTest::FXTest(FXApp *app): FXMainWindow(app, "Sample chat test") {
  isServer = FALSE;
  closing = FALSE;
  MainFrame = new FXVerticalFrame(this, LAYOUT_SIDE_TOP|LAYOUT_SIDE_LEFT|LAYOUT_FILL_X|LAYOUT_FILL_Y);
    AddrFrame = new FXHorizontalFrame(MainFrame, LAYOUT_FILL_X);
      lServer = new FXLabel(AddrFrame, "Server address:");
      tServer = new FXTextField(AddrFrame, 10);
    PortFrame = new FXHorizontalFrame(MainFrame, LAYOUT_FILL_X);
      lPort = new FXLabel(PortFrame, "Server port:");
      tPort = new FXTextField(PortFrame, 10);
    ButtonFrame = new FXHorizontalFrame(MainFrame, LAYOUT_FILL_X);
      bConnect = new FXButton(ButtonFrame, "Connect", NULL, this, ID_CONNECT);
      bAsServer = new FXButton(ButtonFrame, "Listen", NULL, this, ID_ASSERVER);
      bDisconnect = new FXButton(ButtonFrame, "Disconnect", NULL, this, ID_DISCONNECT);
    fSend = new FXHorizontalFrame(MainFrame, LAYOUT_FILL_X);
      tSend = new FXTextField(fSend, 64, NULL, 0, LAYOUT_FILL_X);
      bSend = new FXButton(fSend, "Send!", NULL, this, ID_SEND);
    tRecv = new FXText(MainFrame, NULL, 0, TEXT_READONLY|LAYOUT_FILL_X);
  cl = new FXClientSocket(app, this, ID_CLSOCKET);
  svr = new FXServerSocket(app, this, ID_SVRSOCKET);
}

void FXTest::create() {
  FXMainWindow::create();
  tServer->setText("127.0.0.1");
  tPort->setText("61000");
  cl->create();
  svr->create();
  svr->setMaxClients(16);
  setConnectedState(FALSE);
  insertLine("[info] Ready.");
  show(PLACEMENT_SCREEN);
}

FXTest::~FXTest() {
  if(cl) delete cl;
  if(svr) delete svr;
}

void FXTest::setConnectedState(FXbool Connected) {
  if(Connected) {
    bConnect->disable();
    bAsServer->disable();
    bDisconnect->enable();
    bSend->enable();
  } else {
    bConnect->enable();
    bAsServer->enable();
    bDisconnect->disable();
    bSend->disable();
  }
}

void FXTest::insertLine(const FXString &text) {
  FXString toAdd(text);
  toAdd += "\n";
  tRecv->appendText(toAdd.text(), toAdd.length());
  tRecv->makePositionVisible(tRecv->getBottomLine());
}

long FXTest::onConnect(FXObject *Sender, FXSelector ser, void *data) {
  FXString ServerName;
  FXint ServerPort;
  ServerName = tServer->getText();
  ServerPort = FXIntVal(tPort->getText());
  if(cl->setServerName(ServerName) == SOCKET_ERROR) {
    insertLine("[info] setServerName() failed");
    return 1;
  }
  if(cl->setServerPort(ServerPort) == SOCKET_ERROR) {
    insertLine("[info] setServerPort() failed");
    return 1;
  }
  if(cl->connect() == SOCKET_ERROR) {
    insertLine("[info] connect() failed");
    return 1;
  }
  setConnectedState(TRUE);
  isServer = FALSE;
  closing = FALSE;
  return 1;
}

long FXTest::onAsServer(FXObject *Sender, FXSelector ser, void *data) {
  FXint localPort;
  localPort = FXIntVal(tPort->getText());
  if(svr->setLocalPort(localPort) == SOCKET_ERROR) {
    insertLine("[info] setLocalPort() failed");
    return 1;
  }
  if(svr->connect() == SOCKET_ERROR) {
    insertLine("[info] connect() failed");
    return 1;
  }
  setConnectedState(TRUE);
  insertLine("[info] listening...");
  isServer = TRUE;
  closing = FALSE;
  return 1;
}

long FXTest::onDisconnect(FXObject *Sender, FXSelector ser, void *data) {
  closing = TRUE;
  if(isServer) svr->disconnect();
  else cl->disconnect();
  return 1;
}

long FXTest::onSend(FXObject *Sender, FXSelector ser, void *data) {
  FXString text;

  text = tSend->getText();
  Dispatch(text, TRUE);
  text = "[send] "+text;
  insertLine(text);
  tSend->setText("");
  return 1;
}

long FXTest::onSvrSocket(FXObject *Sender, FXSelector sel, void *data) {
  FXSocketEvent *ev = (FXSocketEvent *) data;
  FXString s;
  FXSocket *connection = ev->Socket;
  FXint res;
  
  switch(ev->eventType) {
    case SOCK_DISCONNECT:
        s = "["+connection->getRemoteAddress()+"] disconnected";
        insertLine(s);
        Dispatch(s);
      break;
    case SOCK_CONNECT:
      s = "[info] connection from "+connection->getRemoteAddress();
      insertLine(s);
      Dispatch(s, FALSE, connection);
      break;
    case SOCK_READ:
      res = connection->readString(s);
      if(res>=0) {
        insertLine(s);
        Dispatch(s, FALSE, connection);
      }
      break;
    case SOCK_ERROR:
      s = "[info] socket error: ";
      s += (FXchar *) ev->vdata;
      insertLine(s);
      break;
    case SOCK_SERVDISCONNECT:
      insertLine("[info] server closed");
      setConnectedState(FALSE);
      break;
    case SOCK_CONNREJECT:
      insertLine("[info] connection rejected (already connected)");
      break;
    case SOCK_SERVERROR:
      s = "[info] server socket error: ";
      s += (FXchar *) ev->vdata;
      insertLine(s);
      break;
  }
  return 1;
}

long FXTest::onClSocket(FXObject *Sender, FXSelector sel, void *data) {
  FXString s;
  FXint res;
  FXSocketEvent *ev = (FXSocketEvent *) data;
  FXSocket *connection = ev->Socket;;

  switch(ev->eventType) {
    case SOCK_CONNECT:
      s = "[info] connected to "+connection->getRemoteAddress();
      insertLine(s);
      bSend->enable();
      break;
    case SOCK_DISCONNECT:
      insertLine("["+connection->getRemoteAddress()+"] disconnected");
      setConnectedState(FALSE);
      break;
    case SOCK_READ:
      res = connection->readString(s);
      if(res>=0) insertLine(s);
      break;
    case SOCK_ERROR:
      s = "[info] socket error: ";
      s += (FXchar *) ev->vdata;
      insertLine(s);
      break;
  }
  return 1;
}

void FXTest::Dispatch(const FXString &s, FXbool Prefix, FXSocket *except) {
  FXint c;
  FXint conn;
  FXString toSend;

  if(closing) return;
  if(isServer) {
    conn = svr->connCount();
    for(c=0; c<conn; ++c)
      if(svr->connection(c)!=except) {
        if(Prefix) toSend = "["+svr->connection(c)->getLocalAddress()+"] "+s;
        else toSend = s;
        svr->connection(c)->writeString(toSend);
      }
  } else {
    if(Prefix) toSend = "["+cl->getLocalAddress()+"] "+s;
    else toSend = s;    
    cl->writeString(toSend);
  }
}

int main(int argc, char **argv) {
  FXApp *app;
  FXTest *MainForm;
  app = new FXApp("SockTest", "test");
  app->init(argc, argv);
  MainForm = new FXTest(app);
  app->create();
  app->run();
  return 0;
}
