/***********************************-*- mode: c++; tab - width: 2 -*-*\
 * 
 * NAME:
 *    main
 *  AUTHOR:
 *    Daniel Gehriger
 * 
 * Copyright(c) 1999 by Daniel Gehriger.  All Rights Reserved
 * 
 * PUPROSE:
 *    Main entry point
 * 
 * HISTORY:
 *          dgehrige - Aug 12, 1999: Created.
 * 
\*******************************************************************/

#include "main.h"

/*
** COM Support
*/
#ifdef WIN32
#include "contnr.h"
#include "evntsink.h"

CEventSink*     g_pEvent     = NULL;
CContainer*     g_pContainer = NULL;
DWORD           g_dwCookie   = 0;

_DSomeocxPtr  	g_pSomeocx;

#endif

/*******************************************************************\
 * 
 * Main application entry function
 * 
\*******************************************************************/
int main(FXint argc, FXchar *argv[])
{
  g_pProgramDir = argv[0];
  FXApp* pApp = new FXApp("Test COM App", "Daniel Gehriger");
  
  /*
  ** Parse the command line and open the display
  */
  pApp->init(argc, argv);
 
  /*
  ** COM Support
  */
#ifdef WIN32
  OleInitialize(NULL);
  
  g_pContainer = new CContainer();
  g_pEvent = new CEventSink();
  
  if (g_pContainer && g_pEvent)
  {
    g_pContainer->setParent(NULL);
    g_pContainer->add(L"Somename.someocx.1");
    g_pContainer->setVisible(FALSE);
    g_pContainer->setFocus(FALSE);
    
    IUnknown* pUnk = g_pContainer->getUnknown();
    if (pUnk)
    {
      HRESULT hr = pUnk->QueryInterface(__uuidof(_DSomeocx), (PVOID*)&g_pSomeocx);
      pUnk->Release();
    }
    
    connectEvents();
  }
  else
  {
    FXASSERT(false);
  }
  
  if (g_pSomeocx)
  {
    IPersistStreamInit* ppsi;
    IStream* pps;
    if (SUCCEEDED(g_pSomeocx->QueryInterface(IID_IPersistStreamInit, (PVOID *)&ppsi)))
    {
      g_pContainer->QueryInterface(IID_IStream, (PVOID *)&pps));
      ppsi->Release();
    }

#endif /* WIN32 */
    
  /*
  ** Create the application
  */
  pApp->create();
    
  /*
  ** Create and display main window
  */
  MyMainDialog* pDlg = new LcMainDialog(pApp);
  pDlg->create();
  pDlg->show();
    
  /*
  ** Run!
  */
  pDlg->setFocus();
  pApp->run();
  
  /*
  ** Destroy
  */
  delete pApp;

  
  /*
  ** COM Support
  */
#ifdef WIN32
  
  g_pSomeocx->Release();
  g_pSomeocx.Detach();
  disconnectEvents();
  if (g_pEvent)
  {
    g_pEvent->Release();
  }
  if (g_pContainer)
  {
    g_pContainer->remove();
    g_pContainer->Release();
  }
  
  OleUninitialize();
#endif /* WIN32 */
    
  return 0;
}

/*-----------------------------------------------------------------*\
 * 
 * COM Functions
 * 
\*-----------------------------------------------------------------*/
#ifdef WIN32

void connectEvents()
{
  if (!g_pContainer || !g_pEvent)
  {
    FXASSERT(false);
    return;
  }
  
  IUnknown *punk = g_pContainer->getUnknown();
  if (!punk)
  {
    FXASSERT(false);
    return;
  }
  
  IConnectionPoint *pcp;
  pcp = getConnectionPoint(__uuidof(_DSomeocxEvents));
  if (!pcp)
  {
    FXASSERT(false);
    return;
  }
  
  pcp->Advise(g_pEvent, &g_dwCookie);
  pcp->Release();
  
  punk->Release();
}

IConnectionPoint* getConnectionPoint(REFIID riid)
{
  if (!g_pContainer)
  {
    FXASSERT(false);
    return NULL;
  }
  
  IUnknown *punk = g_pContainer->getUnknown();
  if (!punk)
  {
    FXASSERT(false);
    return NULL;
  }
  
  IConnectionPointContainer   *pcpc;
  IConnectionPoint            *pcp = NULL;
  
  HRESULT hr = punk->QueryInterface(IID_IConnectionPointContainer, (PVOID *)&pcpc);
  if (SUCCEEDED(hr))
  {
    pcpc->FindConnectionPoint(riid, &pcp);
    pcpc->Release();
  }
  
  punk->Release();
  return pcp;
}

void disconnectEvents()
{
  IConnectionPoint    *pcp;
  
  pcp = getConnectionPoint(__uuidof(_DSomeocxEvents));
  if (!pcp)
  {
    FXASSERT(false);
    return;
  }
  
  pcp->Unadvise(g_dwCookie);
  pcp->Release();
}

#endif /* WIN32 */
