/* FXExTreeList ver.0.2.4
 *
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 *
 * $fxextreelist: fxextreelist.h,v 1.74.10 2001/10/25 10:43:00 Toshihiro Inoue Exp $
 */
#ifndef FXEXTREELIST_H
#define FXEXTREELIST_H

#ifndef FXTREELIST_H
#include <fox/FXTreeList.h>
using namespace FX;
#endif
namespace FXEX {
class FXExTreeItem;

/**
 * FXExTreeList is widget which extends the normal FOX FXTreeList widget, with some nice
 * features.
 */
class FXAPI FXExTreeList: public FXTreeList {
  FXDECLARE(FXExTreeList)
  
protected:
  FXuint itemID;
  FXTextField* labelEdit;
  FXbool editable;
  FXExTreeItem* mEditItem;
  FXbool flgEditTimer;
  FXbool flgEnter;
  FXDragType* offerTypes;
  FXint offerCount;
  FXDragType* acceptTypes;
  FXint acceptCount;
  FXExTreeItem* dragItem;
  FXDragAction dragAction;
  FXDragAction exportMode;
  FXDragAction dropAction;
  FXbool isTarget;
  FXExTreeItem* targetItem;
  FXint targetState;
  FXint targetType;
  FXbool lastAcceptable;

protected:
  /// serialisation
  FXExTreeList(){}
  
public:
  enum {
    ID_LABELEDIT=FXTreeList::ID_LAST,
    ID_EDITTIMER,
    ID_OPENTIMER,
    ID_EDITEND,
    ID_NEXTLINE,
    ID_LAST
    };

public:
  long onLeftBtnPress(FXObject* sender, FXSelector sel, void* ptr);
  long onLeftBtnRelease(FXObject* sender, FXSelector sel, void* ptr);
  long onEditTimer(FXObject* sender, FXSelector sel, void* ptr);
  long onEditKeyPress(FXObject* sender, FXSelector sel, void* ptr);
  long onKeyRelease(FXObject* sender, FXSelector sel, void* ptr);
  long onEditFocusOut(FXObject* sender, FXSelector sel, void* ptr);
  long onPaint(FXObject* sender, FXSelector sel, void* ptr);
  long onMotion(FXObject* sender, FXSelector sel, void* ptr);
  long onBeginDrag(FXObject* sender, FXSelector sel, void* ptr);
  long onEndDrag(FXObject* sender, FXSelector sel, void* ptr);
  long onDragged(FXObject* sender, FXSelector sel, void* ptr);
  long onDNDEnter(FXObject* sender, FXSelector sel, void* ptr);
  long onDNDLeave(FXObject* sender, FXSelector sel, void* ptr);
  long onDNDMotion(FXObject* sender, FXSelector sel, void* ptr);
  long onDNDRequest(FXObject* sender, FXSelector sel, void* ptr);
  long onDNDDrop(FXObject* sender, FXSelector sel, void* ptr);
  long onRightBtnRelease(FXObject* sender, FXSelector sel, void* ptr);
  long onOpenTimer(FXObject* sender, FXSelector sel, void* ptr);
  long onTipTimer(FXObject* sender, FXSelector sel, void* ptr);
  long onEditEnd(FXObject* sender, FXSelector sel, void* ptr);

public:
  /// is tree list editable
  inline FXbool isEditable() const { return editable; }

  /// make tree list editable
  inline void setEditable(FXbool b) { editable = b; }

  /// set mode of drag
  inline void setExportMode(FXDragAction a) { exportMode = a; }

  /// is the last item accepting items
  inline FXbool isLastAcceptable() const { return lastAcceptable; }

  /// make the last item accept items
  inline void setLastAcceptable(FXbool b) { lastAcceptable = b; }
  
public:
  /// make a new Tree list
  FXExTreeList(FXComposite *p,FXint nvis,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);

  /// create an FXTreeItem item
  virtual FXTreeItem* createItem(const FXString& text,FXIcon* oi,FXIcon* ci,void* ptr);

  /// make a FXExTreeItem at a specific position
  virtual FXExTreeItem* newItem(FXTreeItem* parent, FXTreeItem* prev, FXTreeItem* next);

  /// copy an item
  virtual FXTreeItem* copyItem(FXTreeItem* src,FXTreeItem* parent,FXTreeItem* prev,FXTreeItem* next, FXuint ignore=0);

  /// move an item to a new position
  virtual FXTreeItem* moveItem(FXTreeItem* src, FXTreeItem* parent, FXTreeItem* prev, FXTreeItem* next);

  /// copy selected items
  FXTreeItem* copySelectedItems(FXTreeItem* parent, FXTreeItem* prev, FXTreeItem* next, FXbool desel = TRUE);

  /// move selected items
  FXTreeItem* moveSelectedItems(FXTreeItem* parent, FXTreeItem* prev, FXTreeItem* next);

  /// remove selected items
  void removeSelectedItems(FXuint ignore = 0);

  /// check if item is ancestor
  FXbool isAncestor(FXTreeItem* anc, FXTreeItem* desc);

  /// check if item is ancestor
  FXbool checkAncestor(FXTreeItem* src, FXTreeItem* parent, FXTreeItem* prev, FXTreeItem* next);

  /// get the item position x,y
  void getItemPos(FXTreeItem* item, FXint& x, FXint& y);

  /// get the height of the item
  FXint getDescHeight(FXTreeItem* item);

  /// get the next item after deletion
  FXTreeItem* getAfterDelItem();

  /// start editng an item
  void editItem(FXTreeItem* item, int how = 0);

  /// finish editing an item
  void editEnd();

  /// cancel editing an item
  void editCancel();

  /// move the window contents
  virtual void moveContents(FXint x, FXint y);

  /// called before a DND drag begins
  virtual void beforeDrag() {}

  /// checks the DND drop site
  virtual void checkDrop(FXEvent* e);

  /// offer selected item data to stream
  virtual void offerSelectedData(FXint type, FXStream* stream);

  /// offer item data to stream
  virtual void offerData(FXint type, FXStream* stream, FXTreeItem* item){}

  /// accept item data from stream
  virtual FXTreeItem* acceptData(FXint type, FXuchar* buffer, FXuint size, FXTreeItem* parent, FXTreeItem* prev, FXTreeItem* next) { return NULL; }

  /// is the item a DND drag source
  FXbool isDragSource(FXTreeItem* item);

  /// dtor
  virtual ~FXExTreeList();
  };

} // namespace FXEX
#endif // FXEXTREELIST_H
