/********************************************************************************
*                                                                               *
*                  FTP client                                                   *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
using namespace FX;
#include "fxexdefs.h"
#include "FXThreadEvent.h"
#include "FXFastMutex.h"
#include "FXAtomic.h"
#include "FXMutex.h"
#include "FXResolver.h"
#include "FXSocketClient.h"
#include "FXFtpClient.h"
using namespace FXEX;
namespace FXEX {

// maps
FXDEFMAP (FXFtpClient) FXFtpClientMap[]={
  FXMAPFUNC(SEL_OPENED,FXFtpClient::ID_FTP_CLIENT,FXFtpClient::onOpened),
  FXMAPFUNC(SEL_CLOSED,FXFtpClient::ID_FTP_CLIENT,FXFtpClient::onClosed),
  FXMAPFUNC(SEL_DESTROY,FXFtpClient::ID_FTP_CLIENT,FXFtpClient::onDestroyed),
  FXMAPFUNC(SEL_COMMAND,FXFtpClient::ID_FTP_CLIENT,FXFtpClient::onDataIncoming),
  FXMAPFUNC(SEL_CHORE,FXFtpClient::ID_DATA_FORWARD,FXFtpClient::onDataForward),
  };
FXIMPLEMENT(FXFtpClient,FXIOSlave,FXFtpClientMap,ARRAYNUMBER(FXFtpClientMap))

// ctor
FXFtpClient::FXFtpClient(FXApp *a,const FXString& host,FXObject *tgt,FXSelector sel,FXint prt) : FXIOSlave(a,tgt,sel) {
  connection=new FXSocketClient(getApp(),host,prt,this,ID_FTP_CLIENT);
  datalen=0;
  }

// free up all resources
FXFtpClient::~FXFtpClient(){
  getApp()->removeChore(this,ID_DATA_FORWARD);
  delete connection;
  }

// open ftp connection
void FXFtpClient::open(){
  //if(state==FXIOStateNone) return connection->open();
  //return FALSE;
  }

// close ftp connection
void FXFtpClient::close(){
  if (state==FXIOStateConnected) connection->close();
  state=FXIOStateNone;
  }

// list the current directory
void FXFtpClient::list(){
  }

// handle newly opened connection
long FXFtpClient::onOpened(FXObject*,FXSelector,void*){
  state=FXIOStateConnected;
  if(target) target->handle(this,FXSEL(SEL_OPENED,message),NULL);
  return 1;
  }

// handle a closed connection
long FXFtpClient::onClosed(FXObject*,FXSelector,void*){
  if(target) target->handle(this,FXSEL(SEL_CLOSED,message),NULL);
  state=FXIOStateNone;
  return 1;
  }

// handle destroy
long FXFtpClient::onDestroyed(FXObject*,FXSelector,void*){
  if(target) target->handle(this,FXSEL(SEL_DESTROY,message),NULL);
  state=FXIOStateNone;
  return 1;
  }

// handle incoming data
long FXFtpClient::onDataIncoming(FXObject*,FXSelector,void *ptr){
  FXIOData *buffer=(FXIOData*)ptr;
  FXuchar *data=(FXuchar*)getUserData();
  FXuint datalen=getUserDataLen();
  if(FXRESIZE(&data,FXuchar,datalen+buffer->no)){
    memcpy(&data[datalen],buffer->data,buffer->no);
    datalen+=buffer->no;
    // we handle forwarding of data in chore, so as to maximise network throughput
    getApp()->addChore(this,ID_DATA_FORWARD);
    }
  setUserData((void*)data);
  setUserDataLen(datalen);
  return 0;
  }

// forward data to app when chore runs out
long FXFtpClient::onDataForward(FXObject*,FXSelector,void*){
  FXuint datalen=getUserDataLen();
  if(datalen){
    if (target) target->handle(this,FXSEL(SEL_COMMAND,message),NULL);  //FIXME
    FXuchar *data=(FXuchar*)getUserData();
    FXFREE(&data);
    }
  setUserData(NULL);
  setUserDataLen(0);
  return 1;
  }

}

