/********************************************************************************
*                                                                               *
*                  Toolbar button widget                                        *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXButton.h>
#include <fox/FXPopup.h>
#include <fox/FXMenuButton.h>
using namespace FX;
#include "FXToolbarButton.h"
using namespace FXEX;
namespace FXEX {


FXDEFMAP(FXToolbarButton)FXToolbarButtonMap[]={
  FXMAPFUNC(SEL_COMMAND,FXToolbarButton::ID_TOGGLESHOWN,FXToolbarButton::onCmdToggleText),
  FXMAPFUNC(SEL_UPDATE,FXToolbarButton::ID_TOGGLESHOWN,FXToolbarButton::onUpdToggleText),
  };
FXIMPLEMENT(FXToolbarButton,FXHorizontalFrame,FXToolbarButtonMap,ARRAYNUMBER(FXToolbarButtonMap))


// ctor - if we assign the pup to be NULL, we hide the popup button
FXToolbarButton::FXToolbarButton(FXComposite *p,const FXString& text,FXIcon *ic,FXPopup *pup,FXObject *tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb) : FXHorizontalFrame(p,FRAME_NONE,0,0,0,0,0,0,0,0,0,0){
  setTarget(tgt);
  setSelector(sel);
  mainbutton = new FXButton(this,text,ic,tgt,sel,opts,x,y,w,h,pl,pr,pt,pb);
  menubutton = new FXMenuButton(this,"",NULL,pup,opts|LAYOUT_FILL_Y,x,y,w,h,pl,pr,pt,pb);
  if (!pup) menubutton->hide();
  label=mainbutton->getText();
  }

FXToolbarButton::~FXToolbarButton(){
  delete menubutton;
  delete mainbutton;
  }

void FXToolbarButton::create(){
  FXHorizontalFrame::create();
  mainbutton->create();
  menubutton->create();
  if (menubutton->getMenu()->getDefaultWidth() < getDefaultWidth())
    menubutton->getMenu()->setWidth(getDefaultWidth());
  menubutton->setXOffset(- mainbutton->getDefaultWidth());
  }

void FXToolbarButton::detach(){
  FXHorizontalFrame::detach();
  mainbutton->detach();
  menubutton->detach();
  }

void FXToolbarButton::destroy(){
  FXHorizontalFrame::destroy();
  mainbutton->destroy();
  menubutton->destroy();
  }

void FXToolbarButton::save(FXStream& store) const {
  FXHorizontalFrame::save(store);
  store << mainbutton;
  store << menubutton;
  store << label;
  }

void FXToolbarButton::load(FXStream& store){
  FXHorizontalFrame::load(store);
  store >> mainbutton;
  store >> menubutton;
  store >> label;
  }

long FXToolbarButton::onCmdToggleText(FXObject*,FXSelector,void*){
  textToggle();
  return 1;
  }

long FXToolbarButton::onUpdToggleText(FXObject* sender,FXSelector,void*){
  if (textShown())
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_CHECK),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_UNCHECK),NULL);
  return 1;
  }

void FXToolbarButton::textToggle(){
  if (textShown()) mainbutton->setText(FXString::null);
  else mainbutton->setText(label);
  }

FXbool FXToolbarButton::textShown(){
  return !mainbutton->getText().empty();
  }

// this looks kinda crappy, but it ensures that the underlying FXButton
// ends up with the right text.  The biggest issue here is that we could incurr
// a repaint since the button will have been marked as dirty...
void FXToolbarButton::setText(const FXString& text){
  FXbool shown = textShown();
  mainbutton->setText(text);
  label=mainbutton->getText();
  if(!shown) mainbutton->setText(FXString::null);
  }

FXString FXToolbarButton::getText() const {
  return mainbutton->getText();
  }

void FXToolbarButton::setMenu(FXPopup *pup){
  menubutton->setMenu(pup);
  if (menubutton->getMenu()) menubutton->show();
  else menubutton->hide();
  }

}

