/********************************************************************************
*                                                                               *
*              Generic 2D grid data                                             *
*                                                                               *
*********************************************************************************
* Copyright (C) 2002 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This program is free software; you can redistribute it and/or modify          *
* it under the terms of the GNU General Public License as published by          *
* the Free Software Foundation; either version 2 of the License, or             *
* (at your option) any later version.                                           *
*                                                                               *
* This program is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                 *
* GNU General Public License for more details.                                  *
*                                                                               *
* You should have received a copy of the GNU General Public License             *
* along with this program; if not, write to the Free Software                   *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/

/*
This Array class is used as a replacement for the standard array syntax, except that we
are using pointers...  The purpose is so that we can create a derived class which can
handle the data type in question.

Note: resizing the array causes the contents to be dumped, so you may want to delete it
      contents elements first, both in the child class (which would normally contain
      the array data implementation details) and any pointers allocated in the app...

Todo:
- it really implements a slow search, looking for the element in question. Maybe I can
  make it faster...
- it uses 'new' to grab memory - should really grab a chunk of memory using FXMALLOC()

FIXME:
- what was I on when I wrote this class...  I should really make into proper array syntax
*/

#ifndef GRIDPOINTERARRAY_H
#define GRIDPOINTERARRAY_H

struct point {
  FXuint x;
  FXuint y;
  point(FXuint a=0,FXuint b=0):x(a),y(b){};
  };

struct GridElement {
  void *data;
  GridElement* next;
  GridElement(void* d=NULL) : data(d),next(NULL) {};
  };

class GridPointerArray {
  private:
    GridElement  *list;
    FXuint    xamount;
    FXuint    yamount;

  protected:
    GridElement* get(FXuint x,FXuint y);

  public:
    GridPointerArray(FXuint x=0,FXuint y=0);
    virtual ~GridPointerArray();

    FXuint xsize() { return xamount; }
    FXuint ysize() { return yamount; }
    point  xsize(FXuint x) { return size(x,yamount); }
    point  ysize(FXuint y) { return size(xamount,y); }

    virtual point size(FXuint x,FXuint y);
    virtual point insert(FXuint x,FXuint y,void* data);
    virtual void* find(FXuint x,FXuint y);
  };

#endif
