/********************************************************************************
*                                                                               *
*                  Process event manager                                        *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#ifndef FXPROCESSMANAGER_H
#define FXPROCESSMANAGER_H

#ifndef FXBASEOBJECT_H
#include "FXBaseObject.h"
#endif
namespace FXEX {
class FXProcess;

/// An FXProcessList is a list of FXProcess objects
typedef FXArray<FXProcess*> FXProcessList;


/**
 * A Process Manager is required to be created in the main process, since there may be a
 * number of child processes, each capable of delivering signals and stdout/stderr output
 * to the main process.  As such, this needs special handling so that the correct FOX
 * event is generated for each child process event.
 *
 * FXProcessManager is a singleton object, ie you can only create one of them.
 */
class FXAPI FXProcessManager : public FXBaseObject {
  FXDECLARE(FXProcessManager)

private:
  FXProcessList      processlist; // list of currently executing processes
  FXIntList          pidlist;     // list of currently executing processes, by process ID
  FXint              last;        // last pointed-to process

  static FXProcessManager* manager;  // process manager instance

protected:
  /// serialisation
  FXProcessManager();

  /// handle child exited signal
  void wait();

public:
  enum {
    ID_PROCESS_MANAGER=FXBaseObject::ID_LAST,
    ID_CHILD_SIGNAL,
    ID_LAST
    };

public:
  long onChildSignal(FXObject*,FXSelector,void*);

public:
  /**
   * Create a process manager
   * A process manager can itself generate FOX events
   */
  FXProcessManager(FXApp *a,FXObject *tgt=NULL,FXSelector sel=0);

  /// get the current process manager instance
  static FXProcessManager* instance();

  /// add a process to the list of managed processes
  void add(FXProcess *p);

  /// remove an existing process
  void remove(FXProcess *p);

  /// return the number of active processes (not including the main process)
  FXint size();

  /// return the next available process
  FXProcess* next();

  /// dtor
  virtual ~FXProcessManager();
  };

} // namespace FXEX
#endif // FXPROCESSMANAGER_H
