/********************************************************************************
*                                                                               *
*                  Enhanced Exception usage                                     *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXString.h>
#include <fox/FXStream.h>
#include <fox/FXWindow.h>
#include <fox/FXIcon.h>
#include <fox/FXMessageBox.h>
using namespace FX;
#include "FXExtendedException.h"
using namespace FXEX;
namespace FXEX {

// show an exception description, using a dialog box
void show(FXWindow *owner,const FXException &ex){
  FXMessageBox::error(owner,MBOX_OK,"Exception","%s",ex.what());
  }

// show an extended exception description, using a dialog box
void show(FXWindow *owner,const FXExtendedException &ex){
  FXMessageBox::error(owner,MBOX_OK,"Exception","%s\nException code: %i",ex.what(),ex.error());
  }


// general extended exception
const FXchar FXExtendedException::exceptionName[]="extended error";

// general thread error
const FXchar FXThreadException::exceptionName[]="thread error";

// thrown if there is a fatal error
const FXchar FXThreadFatal::exceptionName[]="thread fatal condition";

// thread supplied invalid parameters
const FXchar FXThreadInvalid::exceptionName[]="invalid arguments";

// thread supplied invalid parameters
const FXchar FXDatabaseException::exceptionName[]="database error";

}

