/********************************************************************************
*                                                                               *
*                  Settings Data Target                                         *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXApp.h>
using namespace FX;
#include "FXSettingsDataTarget.h"
using namespace FXEX;
namespace FXEX {

// Map
FXDEFMAP(FXSettingsDataTarget) FXSettingsDataTargetMap[]={
  FXMAPFUNC(SEL_COMMAND, FXDataTarget::ID_VALUE, FXSettingsDataTarget::onCmdValue),
  FXMAPFUNC(SEL_COMMAND, FXDataTarget::ID_VALUE, FXSettingsDataTarget::onCmdOption),
  };
FXIMPLEMENT(FXSettingsDataTarget,FXDataTarget,FXSettingsDataTargetMap,ARRAYNUMBER(FXSettingsDataTargetMap));

// Destructors
FXSettingsDataTarget::~FXSettingsDataTarget() {
  settings=(FXSettings*)-1;
  }

// Set the registry section and key
void FXSettingsDataTarget::setSettings(FXSettings* settingsDb,const FXString& sect,const FXString& ky) {
  settings=settingsDb;
  section=sect;
  key=ky;
  if (settings && section.length() && key.length()
      && settings->existingEntry(section.text(),key.text()) ){
    switch(getType()){
      case DT_VOID: break; 
      case DT_INT: *((FXint*)data)=settings->readIntEntry(section.text(),key.text(),0); break;
      case DT_UINT: *((FXuint*)data)=settings->readUnsignedEntry(section.text(),key.text(),0); break;
      case DT_DOUBLE: *((FXdouble*)data)=settings->readRealEntry(section.text(),key.text(),0); break;
      case DT_STRING: *((FXString*)data)=settings->readStringEntry(section.text(),key.text(),NULL); break;
      }
    }
  }

// update the settings database, value based on the ID_GETXXXVALUE
long FXSettingsDataTarget::onCmdValue(FXObject* sender,FXSelector sel,void* ptr) {
  FXDataTarget::onCmdValue(sender,sel,ptr);
  if (settings && section.length() && key.length()){
    FXint i=*((FXint*)data);
    FXuint u=*((FXuint*)data);
    FXdouble d=*((FXdouble*)data);
    switch(getType()) {
      case DT_VOID: break;
      case DT_INT: settings->writeIntEntry(section.text(),key.text(),i); break;
      case DT_UINT: settings->writeUnsignedEntry(section.text(),key.text(),u); break;
      case DT_DOUBLE: settings->writeRealEntry(section.text(),key.text(),d); break;
      case DT_STRING: settings->writeStringEntry(section.text(),key.text(),((FXString*)data)->text()); break;
      }
    }
  return 1;
  }

// update the settings database, value based on the message ID
long FXSettingsDataTarget::onCmdOption(FXObject* sender,FXSelector sel,void *ptr){
  FXDataTarget::onCmdOption(sender,sel,ptr);
  if (settings && section.length() && key.length()
      && settings->existingEntry(section.text(),key.text()) ){
    FXint i=*((FXint*)data);
    FXuint u=*((FXuint*)data);
    FXdouble d=*((FXdouble*)data);
    switch(getType()){
      case DT_VOID: break; 
      case DT_INT: settings->writeIntEntry(section.text(),key.text(),i); break;
      case DT_UINT: settings->writeUnsignedEntry(section.text(),key.text(),u); break;
      case DT_DOUBLE: settings->writeRealEntry(section.text(),key.text(),d); break;
      case DT_STRING: settings->writeStringEntry(section.text(),key.text(),((FXString*)data)->text()); break;
      }
    }
  return 1;
  }

}

